// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.core');
goog.require('cljs.core');
goog.require('sci.core');
goog.require('fluree.db.dbfunctions.fns');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
/**
 * Returns true if the arg is a string containing a transaction function.
 */
fluree.db.dbfunctions.core.tx_fn_QMARK_ = (function fluree$db$dbfunctions$core$tx_fn_QMARK_(v){
var and__5043__auto__ = typeof v === 'string';
if(and__5043__auto__){
return cljs.core.re_matches.call(null,/^#\(.+\)$/,v);
} else {
return and__5043__auto__;
}
});
fluree.db.dbfunctions.core.allowed_symbols = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [new cljs.core.Symbol(null,"?pO","?pO",1714537515,null),null,new cljs.core.Symbol(null,"?auth_id","?auth_id",612691741,null),null,new cljs.core.Symbol(null,"sid","sid",-839419355,null),null,new cljs.core.Symbol(null,"?user_id","?user_id",-101968770,null),null,new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),null,new cljs.core.Symbol(null,"?a","?a",1314302913,null),null,new cljs.core.Symbol(null,"?db","?db",1493359450,null),null,new cljs.core.Symbol(null,"?s","?s",456183954,null),null,new cljs.core.Symbol(null,"?o","?o",-1814741084,null),null], null), null);
/**
 * Copies local fns ns public vars into SCI
 */
fluree.db.dbfunctions.core.load_local_fns_ns = (function fluree$db$dbfunctions$core$load_local_fns_ns(){
var ns_public_vars = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentVector.fromArray([new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"uuid"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.uuid;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","uuid","fluree.db.dbfunctions.fns/uuid",1199900311,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,803,null,803,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.uuid)?fluree.db.dbfunctions.fns.uuid.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"max-pred-val"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.max_pred_val;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","max-pred-val","fluree.db.dbfunctions.fns/max-pred-val",884898813,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"max-pred-val","max-pred-val",-1898501472,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",19,1,546,null,546,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null)),"Finds the maximum predicate value.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max_pred_val)?fluree.db.dbfunctions.fns.max_pred_val.cljs$lang$test:null),"10, plus fuel cost."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"contains?"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.contains_QMARK_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","contains?","fluree.db.dbfunctions.fns/contains?",979635755,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",16,1,372,null,372,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),"Returns true if key is present.",(cljs.core.truth_(fluree.db.dbfunctions.fns.contains_QMARK_)?fluree.db.dbfunctions.fns.contains_QMARK_.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"subs"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.subs;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","subs","fluree.db.dbfunctions.fns/subs",815704759,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"subs","subs",1453849536,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,135,null,135,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(cljs.core.truth_(fluree.db.dbfunctions.fns.subs)?fluree.db.dbfunctions.fns.subs.cljs$lang$test:null),(30)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"ctx"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.ctx;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","ctx","fluree.db.dbfunctions.fns/ctx",570947084,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"ctx","ctx",1146921409,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,363,null,363,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"db","db",-1661185010,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.Symbol(null,"key-or-ks","key-or-ks",715926861,null)], null)),"Returns a value from the user's context if set. Provide the key or key sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.ctx)?fluree.db.dbfunctions.fns.ctx.cljs$lang$test:null),(1)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"query"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.query;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","query","fluree.db.dbfunctions.fns/query",2131906892,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"query","query",352022017,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,504,null,504,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),"Executes a query",(cljs.core.truth_(fluree.db.dbfunctions.fns.query)?fluree.db.dbfunctions.fns.query.cljs$lang$test:null),"Fuel required for query"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"flakes"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.flakes;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","flakes","fluree.db.dbfunctions.fns/flakes",2105901429,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"flakes","flakes",-676540030,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",13,1,775,null,775,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the flakes from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.flakes)?fluree.db.dbfunctions.fns.flakes.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"boolean"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.boolean$;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","boolean","fluree.db.dbfunctions.fns/boolean",831125140,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,1,684,null,684,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Coerce to boolean. Everything except false and nil is true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.boolean$)?fluree.db.dbfunctions.fns.boolean$.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"dec"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.dec;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","dec","fluree.db.dbfunctions.fns/dec",2016365502,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"dec","dec",-766002333,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,570,null,570,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),"Decrements any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.dec)?fluree.db.dbfunctions.fns.dec.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"<"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._LT_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","<","fluree.db.dbfunctions.fns/<",-518653073,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"<","<",993667236,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,426,null,426,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically increasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT_)?fluree.db.dbfunctions.fns._LT_.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"floor"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.floor;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","floor","fluree.db.dbfunctions.fns/floor",2077352177,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",12,1,825,null,825,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),"Takes the floor of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.floor)?fluree.db.dbfunctions.fns.floor.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"?o"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_o;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?o","fluree.db.dbfunctions.fns/?o",2112743665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?o","?o",-1814741084,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,1,303,null,303,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the object of an predicate from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_o)?fluree.db.dbfunctions.fns._QMARK_o.cljs$lang$test:null),(1)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"?sid"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_sid;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?sid","fluree.db.dbfunctions.fns/?sid",-1145594406,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?sid","?sid",-778261371,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,171,null,171,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current subject id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_sid)?fluree.db.dbfunctions.fns._QMARK_sid.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"objF"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.objF;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","objF","fluree.db.dbfunctions.fns/objF",1608830606,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"objF","objF",-104129083,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,763,null,763,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the summed object of all false flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objF)?fluree.db.dbfunctions.fns.objF.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"ceil"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.ceil;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","ceil","fluree.db.dbfunctions.fns/ceil",-1898210568,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,813,null,813,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),"Takes the ceiling of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.ceil)?fluree.db.dbfunctions.fns.ceil.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"<="),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._LT__EQ_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","<=","fluree.db.dbfunctions.fns/<=",-535009166,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"<=","<=",1244895369,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,439,null,439,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT__EQ_)?fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"*"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._STAR_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","*","fluree.db.dbfunctions.fns/*",1333037714,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"*","*",345799209,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,619,null,619,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns product of all the numbers in the sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns._STAR_)?fluree.db.dbfunctions.fns._STAR_.cljs$lang$test:null),"9 + count of numbers in *"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"min"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.min;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","min","fluree.db.dbfunctions.fns/min",-1032470830,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"min","min",2085523049,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,491,null,491,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets min value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.min)?fluree.db.dbfunctions.fns.min.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"get"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.get;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","get","fluree.db.dbfunctions.fns/get",1827842903,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"get","get",-971253014,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,272,null,272,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cache","cache",403508473,null),new cljs.core.Symbol(null,"db","db",-1661185010,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null)),"Gets a value from an subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get)?fluree.db.dbfunctions.fns.get.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"?pO"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_pO;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pO","fluree.db.dbfunctions.fns/?pO",-2142759792,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?pO","?pO",1714537515,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,315,null,315,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the most recent object of an predicate, as of the previous block",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pO)?fluree.db.dbfunctions.fns._QMARK_pO.cljs$lang$test:null),"10 plus fuel cost"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"empty?"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.empty_QMARK_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","empty?","fluree.db.dbfunctions.fns/empty?",-487925850,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"empty?","empty?",76408555,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",13,1,111,null,111,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),"True if empty or #{nil}, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.empty_QMARK_)?fluree.db.dbfunctions.fns.empty_QMARK_.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"quot"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.quot;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","quot","fluree.db.dbfunctions.fns/quot",1725032899,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"quot","quot",-1125214196,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,645,null,645,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),"Quot[ient] of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.quot)?fluree.db.dbfunctions.fns.quot.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"now"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.now;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","now","fluree.db.dbfunctions.fns/now",1494134809,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"now","now",-9994004,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,583,null,583,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Returns current epoch milliseconds on the executing machine.",(cljs.core.truth_(fluree.db.dbfunctions.fns.now)?fluree.db.dbfunctions.fns.now.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"not="),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.not_EQ_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","not=","fluree.db.dbfunctions.fns/not=",-1186054057,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"not=","not=",1466536204,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,465,null,465,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if two (or more) values are not equal.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not_EQ_)?fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"if-else"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.if_else;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","if-else","fluree.db.dbfunctions.fns/if-else",-1024242186,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"if-else","if-else",-1675068243,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,1,75,null,75,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null)),"Evaluates test.",(cljs.core.truth_(fluree.db.dbfunctions.fns.if_else)?fluree.db.dbfunctions.fns.if_else.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"rand"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.rand;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","rand","fluree.db.dbfunctions.fns/rand",805823682,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,787,null,787,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.rand)?fluree.db.dbfunctions.fns.rand.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,">"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._GT_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns",">","fluree.db.dbfunctions.fns/>",-23637352,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,">",">",1085014381,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,413,null,413,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT_)?fluree.db.dbfunctions.fns._GT_.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"mod"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.mod;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","mod","fluree.db.dbfunctions.fns/mod",-198597254,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"mod","mod",1510044207,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,658,null,658,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),"Modulus of num and div. Truncates toward negative infinity.",(cljs.core.truth_(fluree.db.dbfunctions.fns.mod)?fluree.db.dbfunctions.fns.mod.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"lower-case"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.lower_case;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","lower-case","fluree.db.dbfunctions.fns/lower-case",-442259,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"lower-case","lower-case",1428172944,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",17,1,147,null,147,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),"Makes string lower case",(cljs.core.truth_(fluree.db.dbfunctions.fns.lower_case)?fluree.db.dbfunctions.fns.lower_case.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"-"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","-","fluree.db.dbfunctions.fns/-",-1982229401,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"-","-",-471816912,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,606,null,606,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns difference of all the numbers in the sequence with the first number as the minuend.",(cljs.core.truth_(fluree.db.dbfunctions.fns._)?fluree.db.dbfunctions.fns._.cljs$lang$test:null),"9 + count of numbers in -"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"hash-set"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.hash_set;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","hash-set","fluree.db.dbfunctions.fns/hash-set",-1047040869,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"hash-set","hash-set",-1145168432,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,386,null,386,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns a hash-set of values",(cljs.core.truth_(fluree.db.dbfunctions.fns.hash_set)?fluree.db.dbfunctions.fns.hash_set.cljs$lang$test:null),"9 + count of items in hash-set"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"or"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.or;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","or","fluree.db.dbfunctions.fns/or",-919667013,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"or","or",1876275696,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,245,null,245,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if any in the sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.or)?fluree.db.dbfunctions.fns.or.cljs$lang$test:null),"Count of objects in or"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"valid-email?"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.valid_email_QMARK_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","valid-email?","fluree.db.dbfunctions.fns/valid-email?",110711142,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"valid-email?","valid-email?",-1587437519,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",19,1,709,null,709,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null)),"Determines whether an email is valid, based on its pattern",(cljs.core.truth_(fluree.db.dbfunctions.fns.valid_email_QMARK_)?fluree.db.dbfunctions.fns.valid_email_QMARK_.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"?s"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_s;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?s","fluree.db.dbfunctions.fns/?s",-1324621735,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?s","?s",456183954,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,203,null,203,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_s)?fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"rem"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.rem;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","rem","fluree.db.dbfunctions.fns/rem",1237147007,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"rem","rem",664046770,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,671,null,671,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),"Remainder of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.rem)?fluree.db.dbfunctions.fns.rem.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"nth"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.nth;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","nth","fluree.db.dbfunctions.fns/nth",-246664273,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"nth","nth",1529209554,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,60,null,60,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),"Returns the nth item in a collection",(cljs.core.truth_(fluree.db.dbfunctions.fns.nth)?fluree.db.dbfunctions.fns.nth.cljs$lang$test:null),"9 + count of objects in collection"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"nil?"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.nil_QMARK_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","nil?","fluree.db.dbfunctions.fns/nil?",-1144188177,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,88,null,88,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),"True if nil, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.nil_QMARK_)?fluree.db.dbfunctions.fns.nil_QMARK_.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"cas"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.cas;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","cas","fluree.db.dbfunctions.fns/cas",-1666886306,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"cas","cas",1188988307,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,837,null,837,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null)),"Does a compare and set/swap operation as a transaction function.",(cljs.core.truth_(fluree.db.dbfunctions.fns.cas)?fluree.db.dbfunctions.fns.cas.cljs$lang$test:null),(20)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"re-find"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.re_find;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","re-find","fluree.db.dbfunctions.fns/re-find",-1361091826,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"re-find","re-find",1143444147,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,1,696,null,696,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null)),"Execute a re-find operation of regex pattern on provided string.",(cljs.core.truth_(fluree.db.dbfunctions.fns.re_find)?fluree.db.dbfunctions.fns.re_find.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"not"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.not;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","not","fluree.db.dbfunctions.fns/not",-1684442274,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"not","not",1044554643,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,100,null,100,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),"Takes a boolean, true returns false, false returns true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not)?fluree.db.dbfunctions.fns.not.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"/"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._SLASH_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","/","fluree.db.dbfunctions.fns//",1439768862,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"/","/",-1371932971,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,632,null,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",(cljs.core.truth_(fluree.db.dbfunctions.fns._SLASH_)?fluree.db.dbfunctions.fns._SLASH_.cljs$lang$test:null),"9 + count of numbers in /"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,">="),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._GT__EQ_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns",">=","fluree.db.dbfunctions.fns/>=",-1771718525,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,">=",">=",1016916022,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,452,null,452,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT__EQ_)?fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"upper-case"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.upper_case;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","upper-case","fluree.db.dbfunctions.fns/upper-case",-210929244,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"upper-case","upper-case",1427515769,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",17,1,159,null,159,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),"Makes string upper-case",(cljs.core.truth_(fluree.db.dbfunctions.fns.upper_case)?fluree.db.dbfunctions.fns.upper_case.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"inc"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.inc;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","inc","fluree.db.dbfunctions.fns/inc",1299152788,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"inc","inc",324505433,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,558,null,558,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),"Increments any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.inc)?fluree.db.dbfunctions.fns.inc.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"+"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._PLUS_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","+","fluree.db.dbfunctions.fns/+",1979608855,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"+","+",-740910886,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,593,null,593,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns sum of each argument.",(cljs.core.truth_(fluree.db.dbfunctions.fns._PLUS_)?fluree.db.dbfunctions.fns._PLUS_.cljs$lang$test:null),"9 + count of numbers in +"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"str"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.str;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","str","fluree.db.dbfunctions.fns/str",215086055,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,123,null,123,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Concatenates all in sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.str)?fluree.db.dbfunctions.fns.str.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"objT"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.objT;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","objT","fluree.db.dbfunctions.fns/objT",308919174,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"objT","objT",1212205659,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,751,null,751,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the summed object of all true flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objT)?fluree.db.dbfunctions.fns.objT.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"max"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.max;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","max","fluree.db.dbfunctions.fns/max",-821447668,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"max","max",1701898075,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,478,null,478,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets max value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max)?fluree.db.dbfunctions.fns.max.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"=="),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._EQ__EQ_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","==","fluree.db.dbfunctions.fns/==",1478685734,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"==","==",-234118149,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,400,null,400,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"count"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.count;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","count","fluree.db.dbfunctions.fns/count",1267596361,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"count","count",-514511684,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",12,1,258,null,258,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps",(cljs.core.truth_(fluree.db.dbfunctions.fns.count)?fluree.db.dbfunctions.fns.count.cljs$lang$test:null),"9 + count of objects in count"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"get-all"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.get_all;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-all","fluree.db.dbfunctions.fns/get-all",1682787369,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"get-all","get-all",-567116420,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,1,328,null,328,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),"Used to get-all values in a nested result set, or also can follow a subject down the provided path and return a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path + query costs"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"?p"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_p;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?p","fluree.db.dbfunctions.fns/?p",1090611913,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?p","?p",-10896580,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,216,null,216,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current predicate predicates",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_p)?fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"?auth_id"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_auth_id;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?auth_id","fluree.db.dbfunctions.fns/?auth_id",-1900200218,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?auth_id","?auth_id",612691741,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",15,1,739,null,739,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current auth _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_auth_id)?fluree.db.dbfunctions.fns._QMARK_auth_id.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"extract"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.extract;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","extract","fluree.db.dbfunctions.fns/extract",-1458126328,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"macro","macro",-867863404),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"extract","extract",399446909,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",18,1,14,true,14,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null)),"Resolves a value if a channel.\n  Must be used inside of a go-block.",(cljs.core.truth_(fluree.db.dbfunctions.fns.extract)?fluree.db.dbfunctions.fns.extract.cljs$lang$test:null)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"?user_id"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_user_id;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?user_id","fluree.db.dbfunctions.fns/?user_id",599092011,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?user_id","?user_id",-101968770,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",15,1,721,null,721,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current user _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_user_id)?fluree.db.dbfunctions.fns._QMARK_user_id.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"relationship?"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.relationship_QMARK_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","relationship?","fluree.db.dbfunctions.fns/relationship?",-46706197,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"relationship?","relationship?",1461608766,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",20,1,531,null,531,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null)),"Determines whether there is a relationship between two subjects",(cljs.core.truth_(fluree.db.dbfunctions.fns.relationship_QMARK_)?fluree.db.dbfunctions.fns.relationship_QMARK_.cljs$lang$test:null),"10, plus fuel cost"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"and"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.and;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","and","fluree.db.dbfunctions.fns/and",2113043921,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"and","and",668631710,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,232,null,232,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if all in a sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.and)?fluree.db.dbfunctions.fns.and.cljs$lang$test:null),"Count of objects in and"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"?pid"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_pid;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pid","fluree.db.dbfunctions.fns/?pid",-1962601142,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,190,null,190,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current predicate id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pid)?fluree.db.dbfunctions.fns._QMARK_pid.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"get-in"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.get_in;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-in","fluree.db.dbfunctions.fns/get-in",821000586,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",13,1,349,null,349,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),"Returns the value of a nested structure",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_in)?fluree.db.dbfunctions.fns.get_in.cljs$lang$test:null),"Length of path"]))], null)], true));
var _ = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["Loading ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,ns_public_vars))," local fns"].join('')], null));
var sci_ns = sci.core.create_ns.call(null,new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null));
return cljs.core.reduce.call(null,(function (ns_map,p__65711){
var vec__65712 = p__65711;
var var_name = cljs.core.nth.call(null,vec__65712,(0),null);
var var$ = cljs.core.nth.call(null,vec__65712,(1),null);
var m = cljs.core.meta.call(null,var$);
var no_doc = new cljs.core.Keyword(null,"no-doc","no-doc",1559921891).cljs$core$IFn$_invoke$arity$1(m);
var doc = new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m);
var arglists = new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(no_doc)){
return ns_map;
} else {
return cljs.core.assoc.call(null,ns_map,var_name,sci.core.new_var.call(null,cljs.core.symbol.call(null,var_name),cljs.core.deref.call(null,var$),(function (){var G__65715 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ns","ns",441598760),sci_ns,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m)], null);
var G__65715__$1 = (cljs.core.truth_(new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m))?cljs.core.assoc.call(null,G__65715,new cljs.core.Keyword(null,"macro","macro",-867863404),true):G__65715);
var G__65715__$2 = (cljs.core.truth_(doc)?cljs.core.assoc.call(null,G__65715__$1,new cljs.core.Keyword(null,"doc","doc",1913296891),doc):G__65715__$1);
if(cljs.core.truth_(arglists)){
return cljs.core.assoc.call(null,G__65715__$2,new cljs.core.Keyword(null,"arglists","arglists",1661989754),arglists);
} else {
return G__65715__$2;
}
})()));
}
}),cljs.core.PersistentArrayMap.EMPTY,ns_public_vars);
});
fluree.db.dbfunctions.core.sci_ctx = (new cljs.core.Delay((function (){
var cfg = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),fluree.db.dbfunctions.core.load_local_fns_ns.call(null)], null)], null);
fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["SCI config:",cfg], null));

return sci.core.init.call(null,cfg);
}),null));
fluree.db.dbfunctions.core.parse_string = (function fluree$db$dbfunctions$core$parse_string(s){
return sci.core.parse_string.call(null,cljs.core.deref.call(null,fluree.db.dbfunctions.core.sci_ctx),s);
});
fluree.db.dbfunctions.core.eval_string = (function fluree$db$dbfunctions$core$eval_string(s){
return sci.core.eval_string_STAR_.call(null,cljs.core.deref.call(null,fluree.db.dbfunctions.core.sci_ctx),s);
});
fluree.db.dbfunctions.core.eval_form = (function fluree$db$dbfunctions$core$eval_form(f){
return sci.core.eval_form.call(null,cljs.core.deref.call(null,fluree.db.dbfunctions.core.sci_ctx),f);
});
/**
 * Given a collection of function strings, returns a combined function using
 *   the and function.
 */
fluree.db.dbfunctions.core.combine_fns = (function fluree$db$dbfunctions$core$combine_fns(fn_str_coll){
if((cljs.core.count.call(null,fn_str_coll) > (1))){
return ["(and ",clojure.string.join.call(null," ",fn_str_coll),")"].join('');
} else {
return cljs.core.first.call(null,fn_str_coll);
}
});
/**
 * Tries to resolve a local pre-defined fn with fn-name. Returns a fn-map if
 *   found, nil otherwise.
 */
fluree.db.dbfunctions.core.find_local_fn = (function fluree$db$dbfunctions$core$find_local_fn(fn_name){
fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Looking for local fn:",fn_name], null));

var local_fns_ns = new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null);
var sci_vars = fluree.db.dbfunctions.core.eval_string.call(null,["(ns-publics '",cljs.core.str.cljs$core$IFn$_invoke$arity$1(local_fns_ns),")"].join(''));
fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["SCI vars:",sci_vars], null));

if(cljs.core.truth_(cljs.core.set.call(null,cljs.core.keys.call(null,sci_vars)).call(null,cljs.core.symbol.call(null,fn_name)))){
fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Found local fn:",fn_name], null));

var fn_var = cljs.core.symbol.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(local_fns_ns),cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_name));
var map__65717 = fluree.db.dbfunctions.core.eval_string.call(null,["(meta #'",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_var),")"].join(''));
var map__65717__$1 = cljs.core.__destructure_map.call(null,map__65717);
var sci_fn_meta = map__65717__$1;
var arglists = cljs.core.get.call(null,map__65717__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
var spec = cljs.core.get.call(null,map__65717__$1,new cljs.core.Keyword("fdb","spec","fdb/spec",346638389));
if(cljs.core.truth_(sci_fn_meta)){
fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["SCI fn metadata:",sci_fn_meta], null));

var first_arglist = cljs.core.first.call(null,arglists);
var args_set = cljs.core.set.call(null,first_arglist);
var var_args_QMARK_ = cljs.core.boolean$.call(null,args_set.call(null,new cljs.core.Symbol(null,"&","&",-2144855648,null)));
var arity = ((var_args_QMARK_)?null:cljs.core.set.call(null,cljs.core.map.call(null,(function (p1__65716_SHARP_){
return (cljs.core.count.call(null,p1__65716_SHARP_) - (1));
}),arglists)));
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"f","f",-1597136552),fn_var,new cljs.core.Keyword(null,"params","params",710516235),arglists,new cljs.core.Keyword(null,"arity","arity",-1808556135),arity,new cljs.core.Keyword(null,"var-args?","var-args?",-1630678710),var_args_QMARK_,new cljs.core.Keyword(null,"spec","spec",347520401),spec], null);
} else {
return null;
}
} else {
return null;
}
});
fluree.db.dbfunctions.core.find_db_fn = (function fluree$db$dbfunctions$core$find_db_fn(var_args){
var G__65719 = arguments.length;
switch (G__65719) {
case 2:
return fluree.db.dbfunctions.core.find_db_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.find_db_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.find_db_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,fn_name){
return fluree.db.dbfunctions.core.find_db_fn.call(null,db,fn_name,null);
}));

(fluree.db.dbfunctions.core.find_db_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_name,fn_type){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_65810){
var state_val_65811 = (state_65810[(1)]);
if((state_val_65811 === (7))){
var inst_65746 = cljs.core.pr_str.call(null,fn_name);
var inst_65747 = ["Unknown function: ",inst_65746].join('');
var inst_65748 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65749 = [(400),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)];
var inst_65750 = cljs.core.PersistentHashMap.fromArrays(inst_65748,inst_65749);
var inst_65751 = cljs.core.ex_info.call(null,inst_65747,inst_65750);
var inst_65752 = (function(){throw inst_65751})();
var state_65810__$1 = state_65810;
var statearr_65812_65845 = state_65810__$1;
(statearr_65812_65845[(2)] = inst_65752);

(statearr_65812_65845[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65811 === (1))){
var state_65810__$1 = state_65810;
var statearr_65813_65846 = state_65810__$1;
(statearr_65813_65846[(2)] = null);

(statearr_65813_65846[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65811 === (4))){
var inst_65720 = (state_65810[(2)]);
var state_65810__$1 = state_65810;
var statearr_65814_65847 = state_65810__$1;
(statearr_65814_65847[(2)] = inst_65720);

(statearr_65814_65847[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65811 === (15))){
var inst_65772 = (state_65810[(7)]);
var inst_65743 = (state_65810[(8)]);
var inst_65772__$1 = (state_65810[(2)]);
var inst_65773 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65774 = ["Parsed params:",inst_65772__$1];
var inst_65775 = (new cljs.core.PersistentVector(null,2,(5),inst_65773,inst_65774,null));
var inst_65776 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_65775);
var inst_65777 = cljs.core.get.call(null,inst_65743,"_fn/code");
var inst_65778 = fluree.db.dbfunctions.core.parse_string.call(null,inst_65777);
var inst_65779 = fluree.db.dbfunctions.core.validate_form.call(null,db,inst_65778,fn_type,inst_65772__$1);
var state_65810__$1 = (function (){var statearr_65815 = state_65810;
(statearr_65815[(7)] = inst_65772__$1);

(statearr_65815[(9)] = inst_65776);

return statearr_65815;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65810__$1,(16),inst_65779);
} else {
if((state_val_65811 === (13))){
var state_65810__$1 = state_65810;
var statearr_65816_65848 = state_65810__$1;
(statearr_65816_65848[(2)] = null);

(statearr_65816_65848[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65811 === (6))){
var inst_65743 = (state_65810[(8)]);
var inst_65742 = (state_65810[(2)]);
var inst_65743__$1 = fluree.db.util.async.throw_err.call(null,inst_65742);
var inst_65744 = cljs.core.empty_QMARK_.call(null,inst_65743__$1);
var state_65810__$1 = (function (){var statearr_65817 = state_65810;
(statearr_65817[(8)] = inst_65743__$1);

return statearr_65817;
})();
if(inst_65744){
var statearr_65818_65849 = state_65810__$1;
(statearr_65818_65849[(1)] = (7));

} else {
var statearr_65819_65850 = state_65810__$1;
(statearr_65819_65850[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65811 === (3))){
var inst_65808 = (state_65810[(2)]);
var state_65810__$1 = state_65810;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65810__$1,inst_65808);
} else {
if((state_val_65811 === (12))){
var inst_65766 = (state_65810[(10)]);
var inst_65766__$1 = (state_65810[(2)]);
var inst_65767 = (inst_65766__$1 == null);
var state_65810__$1 = (function (){var statearr_65820 = state_65810;
(statearr_65820[(10)] = inst_65766__$1);

return statearr_65820;
})();
if(cljs.core.truth_(inst_65767)){
var statearr_65821_65851 = state_65810__$1;
(statearr_65821_65851[(1)] = (13));

} else {
var statearr_65822_65852 = state_65810__$1;
(statearr_65822_65852[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65811 === (2))){
var _ = (function (){var statearr_65823 = state_65810;
(statearr_65823[(4)] = cljs.core.cons.call(null,(5),(state_65810[(4)])));

return statearr_65823;
})();
var inst_65726 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65727 = ["Looking for custom db fn:",fn_name];
var inst_65728 = (new cljs.core.PersistentVector(null,2,(5),inst_65726,inst_65727,null));
var inst_65729 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_65728);
var inst_65730 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044)];
var inst_65731 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65732 = ["_fn/params","_fn/code","_fn/spec"];
var inst_65733 = (new cljs.core.PersistentVector(null,3,(5),inst_65731,inst_65732,null));
var inst_65734 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65735 = cljs.core.name.call(null,fn_name);
var inst_65736 = ["_fn/name",inst_65735];
var inst_65737 = (new cljs.core.PersistentVector(null,2,(5),inst_65734,inst_65736,null));
var inst_65738 = [inst_65733,inst_65737];
var inst_65739 = cljs.core.PersistentHashMap.fromArrays(inst_65730,inst_65738);
var inst_65740 = fluree.db.dbproto._query.call(null,db,inst_65739);
var state_65810__$1 = (function (){var statearr_65824 = state_65810;
(statearr_65824[(11)] = inst_65729);

return statearr_65824;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65810__$1,(6),inst_65740);
} else {
if((state_val_65811 === (11))){
var inst_65743 = (state_65810[(8)]);
var inst_65764 = cljs.core.get.call(null,inst_65743,"_fn/params");
var state_65810__$1 = state_65810;
var statearr_65826_65853 = state_65810__$1;
(statearr_65826_65853[(2)] = inst_65764);

(statearr_65826_65853[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65811 === (9))){
var inst_65743 = (state_65810[(8)]);
var inst_65755 = (state_65810[(2)]);
var inst_65756 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65757 = ["Custom db fn query results:",inst_65743];
var inst_65758 = (new cljs.core.PersistentVector(null,2,(5),inst_65756,inst_65757,null));
var inst_65759 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_65758);
var inst_65761 = (inst_65743 == null);
var state_65810__$1 = (function (){var statearr_65827 = state_65810;
(statearr_65827[(12)] = inst_65755);

(statearr_65827[(13)] = inst_65759);

return statearr_65827;
})();
if(cljs.core.truth_(inst_65761)){
var statearr_65828_65854 = state_65810__$1;
(statearr_65828_65854[(1)] = (10));

} else {
var statearr_65829_65855 = state_65810__$1;
(statearr_65829_65855[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65811 === (5))){
var _ = (function (){var statearr_65830 = state_65810;
(statearr_65830[(4)] = cljs.core.rest.call(null,(state_65810[(4)])));

return statearr_65830;
})();
var state_65810__$1 = state_65810;
var ex65825 = (state_65810__$1[(2)]);
var statearr_65831_65856 = state_65810__$1;
(statearr_65831_65856[(5)] = ex65825);


if((ex65825 instanceof Error)){
var statearr_65832_65857 = state_65810__$1;
(statearr_65832_65857[(1)] = (4));

(statearr_65832_65857[(5)] = null);

} else {
throw ex65825;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65811 === (14))){
var inst_65766 = (state_65810[(10)]);
var inst_65770 = fluree.db.dbfunctions.core.parse_string.call(null,inst_65766);
var state_65810__$1 = state_65810;
var statearr_65833_65858 = state_65810__$1;
(statearr_65833_65858[(2)] = inst_65770);

(statearr_65833_65858[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65811 === (16))){
var inst_65772 = (state_65810[(7)]);
var inst_65743 = (state_65810[(8)]);
var inst_65781 = (state_65810[(2)]);
var inst_65782 = fluree.db.util.async.throw_err.call(null,inst_65781);
var inst_65783 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65784 = ["Validated code:",inst_65782];
var inst_65785 = (new cljs.core.PersistentVector(null,2,(5),inst_65783,inst_65784,null));
var inst_65786 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_65785);
var inst_65787 = cljs.core.get.call(null,inst_65743,"_fn/spec");
var inst_65788 = cljs.core.PersistentVector.EMPTY;
var inst_65789 = new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null);
var inst_65790 = cljs.core.mapv.call(null,cljs.core.symbol,inst_65772);
var inst_65791 = cljs.core.cons.call(null,inst_65789,inst_65790);
var inst_65792 = cljs.core.into.call(null,inst_65788,inst_65791);
var inst_65793 = ["(fn ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65792)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65782),")"].join('');
var inst_65794 = fluree.db.dbfunctions.core.parse_string.call(null,inst_65793);
var inst_65795 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65796 = cljs.core.pr_str.call(null,inst_65794);
var inst_65797 = ["Found custom db fn:",inst_65796];
var inst_65798 = (new cljs.core.PersistentVector(null,2,(5),inst_65795,inst_65797,null));
var inst_65799 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_65798);
var inst_65800 = [new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"arity","arity",-1808556135),new cljs.core.Keyword(null,"var-args?","var-args?",-1630678710),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"code","code",1586293142)];
var inst_65801 = cljs.core.count.call(null,inst_65772);
var inst_65802 = [inst_65801];
var inst_65803 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_65802);
var inst_65804 = [inst_65794,inst_65772,inst_65803,false,inst_65787,null];
var inst_65805 = cljs.core.PersistentHashMap.fromArrays(inst_65800,inst_65804);
var _ = (function (){var statearr_65834 = state_65810;
(statearr_65834[(4)] = cljs.core.rest.call(null,(state_65810[(4)])));

return statearr_65834;
})();
var state_65810__$1 = (function (){var statearr_65835 = state_65810;
(statearr_65835[(14)] = inst_65799);

(statearr_65835[(15)] = inst_65786);

return statearr_65835;
})();
var statearr_65836_65859 = state_65810__$1;
(statearr_65836_65859[(2)] = inst_65805);

(statearr_65836_65859[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65811 === (10))){
var state_65810__$1 = state_65810;
var statearr_65837_65860 = state_65810__$1;
(statearr_65837_65860[(2)] = null);

(statearr_65837_65860[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65811 === (8))){
var state_65810__$1 = state_65810;
var statearr_65838_65861 = state_65810__$1;
(statearr_65838_65861[(2)] = null);

(statearr_65838_65861[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__2746__auto____0 = (function (){
var statearr_65839 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65839[(0)] = fluree$db$dbfunctions$core$state_machine__2746__auto__);

(statearr_65839[(1)] = (1));

return statearr_65839;
});
var fluree$db$dbfunctions$core$state_machine__2746__auto____1 = (function (state_65810){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_65810);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e65840){var ex__2749__auto__ = e65840;
var statearr_65841_65862 = state_65810;
(statearr_65841_65862[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_65810[(4)]))){
var statearr_65842_65863 = state_65810;
(statearr_65842_65863[(1)] = cljs.core.first.call(null,(state_65810[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65864 = state_65810;
state_65810 = G__65864;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__2746__auto__ = function(state_65810){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__2746__auto____1.call(this,state_65810);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__2746__auto____0;
fluree$db$dbfunctions$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__2746__auto____1;
return fluree$db$dbfunctions$core$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_65843 = f__2769__auto__.call(null);
(statearr_65843[(6)] = c__2768__auto__);

return statearr_65843;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.core.find_db_fn.cljs$lang$maxFixedArity = 3);

/**
 * Is the symbol sym valid with the given form type & params?
 */
fluree.db.dbfunctions.core.valid_symbol_QMARK_ = (function fluree$db$dbfunctions$core$valid_symbol_QMARK_(type,params,sym){
var or__5045__auto__ = fluree.db.dbfunctions.core.allowed_symbols.call(null,sym);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = cljs.core.set.call(null,cljs.core.map.call(null,cljs.core.symbol,params)).call(null,sym);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core._EQ_.call(null,type,"functionDec");
}
}
});
/**
 * Resolves local or custom db-stored fn from fn-name string
 */
fluree.db.dbfunctions.core.resolve_fn = (function fluree$db$dbfunctions$core$resolve_fn(db,fn_name,type){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_65884){
var state_val_65885 = (state_65884[(1)]);
if((state_val_65885 === (7))){
var inst_65874 = fluree.db.dbfunctions.core.find_db_fn.call(null,db,fn_name,type);
var state_65884__$1 = state_65884;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65884__$1,(9),inst_65874);
} else {
if((state_val_65885 === (1))){
var state_65884__$1 = state_65884;
var statearr_65886_65905 = state_65884__$1;
(statearr_65886_65905[(2)] = null);

(statearr_65886_65905[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65885 === (4))){
var inst_65865 = (state_65884[(2)]);
var state_65884__$1 = state_65884;
var statearr_65887_65906 = state_65884__$1;
(statearr_65887_65906[(2)] = inst_65865);

(statearr_65887_65906[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65885 === (6))){
var inst_65871 = (state_65884[(7)]);
var state_65884__$1 = state_65884;
var statearr_65888_65907 = state_65884__$1;
(statearr_65888_65907[(2)] = inst_65871);

(statearr_65888_65907[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65885 === (3))){
var inst_65882 = (state_65884[(2)]);
var state_65884__$1 = state_65884;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65884__$1,inst_65882);
} else {
if((state_val_65885 === (2))){
var inst_65871 = (state_65884[(7)]);
var _ = (function (){var statearr_65890 = state_65884;
(statearr_65890[(4)] = cljs.core.cons.call(null,(5),(state_65884[(4)])));

return statearr_65890;
})();
var inst_65871__$1 = fluree.db.dbfunctions.core.find_local_fn.call(null,fn_name);
var state_65884__$1 = (function (){var statearr_65891 = state_65884;
(statearr_65891[(7)] = inst_65871__$1);

return statearr_65891;
})();
if(cljs.core.truth_(inst_65871__$1)){
var statearr_65892_65908 = state_65884__$1;
(statearr_65892_65908[(1)] = (6));

} else {
var statearr_65893_65909 = state_65884__$1;
(statearr_65893_65909[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65885 === (9))){
var inst_65876 = (state_65884[(2)]);
var inst_65877 = fluree.db.util.async.throw_err.call(null,inst_65876);
var state_65884__$1 = state_65884;
var statearr_65894_65910 = state_65884__$1;
(statearr_65894_65910[(2)] = inst_65877);

(statearr_65894_65910[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65885 === (5))){
var _ = (function (){var statearr_65895 = state_65884;
(statearr_65895[(4)] = cljs.core.rest.call(null,(state_65884[(4)])));

return statearr_65895;
})();
var state_65884__$1 = state_65884;
var ex65889 = (state_65884__$1[(2)]);
var statearr_65896_65911 = state_65884__$1;
(statearr_65896_65911[(5)] = ex65889);


if((ex65889 instanceof Error)){
var statearr_65897_65912 = state_65884__$1;
(statearr_65897_65912[(1)] = (4));

(statearr_65897_65912[(5)] = null);

} else {
throw ex65889;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65885 === (8))){
var inst_65879 = (state_65884[(2)]);
var _ = (function (){var statearr_65898 = state_65884;
(statearr_65898[(4)] = cljs.core.rest.call(null,(state_65884[(4)])));

return statearr_65898;
})();
var state_65884__$1 = state_65884;
var statearr_65899_65913 = state_65884__$1;
(statearr_65899_65913[(2)] = inst_65879);

(statearr_65899_65913[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2746__auto____0 = (function (){
var statearr_65900 = [null,null,null,null,null,null,null,null];
(statearr_65900[(0)] = fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2746__auto__);

(statearr_65900[(1)] = (1));

return statearr_65900;
});
var fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2746__auto____1 = (function (state_65884){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_65884);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e65901){var ex__2749__auto__ = e65901;
var statearr_65902_65914 = state_65884;
(statearr_65902_65914[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_65884[(4)]))){
var statearr_65903_65915 = state_65884;
(statearr_65903_65915[(1)] = cljs.core.first.call(null,(state_65884[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65916 = state_65884;
state_65884 = G__65916;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2746__auto__ = function(state_65884){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2746__auto____1.call(this,state_65884);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_65904 = f__2769__auto__.call(null);
(statearr_65904[(6)] = c__2768__auto__);

return statearr_65904;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.dbfunctions.core.validate_form = (function fluree$db$dbfunctions$core$validate_form(var_args){
var G__65919 = arguments.length;
switch (G__65919) {
case 2:
return fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$2 = (function (db,form){
return fluree.db.dbfunctions.core.validate_form.call(null,db,form,null,null);
}));

(fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$3 = (function (db,form,type){
return fluree.db.dbfunctions.core.validate_form.call(null,db,form,type,null);
}));

(fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$4 = (function (db,form,type,params){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_66054){
var state_val_66055 = (state_66054[(1)]);
if((state_val_66055 === (7))){
var state_66054__$1 = state_66054;
var statearr_66056_66120 = state_66054__$1;
(statearr_66056_66120[(2)] = null);

(statearr_66056_66120[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (20))){
var inst_66031 = (state_66054[(2)]);
var state_66054__$1 = state_66054;
var statearr_66057_66121 = state_66054__$1;
(statearr_66057_66121[(2)] = inst_66031);

(statearr_66057_66121[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (27))){
var inst_66020 = (state_66054[(2)]);
var state_66054__$1 = state_66054;
var statearr_66058_66122 = state_66054__$1;
(statearr_66058_66122[(2)] = inst_66020);

(statearr_66058_66122[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (1))){
var state_66054__$1 = state_66054;
var statearr_66059_66123 = state_66054__$1;
(statearr_66059_66123[(2)] = null);

(statearr_66059_66123[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (24))){
var inst_65990 = (state_66054[(2)]);
var inst_65991 = fluree.db.util.async.throw_err.call(null,inst_65990);
var state_66054__$1 = state_66054;
var statearr_66060_66124 = state_66054__$1;
(statearr_66060_66124[(2)] = inst_65991);

(statearr_66060_66124[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (4))){
var inst_65920 = (state_66054[(2)]);
var state_66054__$1 = state_66054;
var statearr_66061_66125 = state_66054__$1;
(statearr_66061_66125[(2)] = inst_65920);

(statearr_66061_66125[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (15))){
var inst_65946 = (state_66054[(2)]);
var inst_65947 = fluree.db.util.async.throw_err.call(null,inst_65946);
var state_66054__$1 = state_66054;
var statearr_66062_66126 = state_66054__$1;
(statearr_66062_66126[(2)] = inst_65947);

(statearr_66062_66126[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (21))){
var inst_65975 = (state_66054[(7)]);
var inst_65988 = fluree.db.dbfunctions.core.validate_form.call(null,db,inst_65975,type,params);
var state_66054__$1 = state_66054;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66054__$1,(24),inst_65988);
} else {
if((state_val_66055 === (31))){
var inst_66023 = (state_66054[(8)]);
var inst_65976 = (state_66054[(9)]);
var inst_65968 = inst_65976;
var inst_65969 = inst_66023;
var state_66054__$1 = (function (){var statearr_66063 = state_66054;
(statearr_66063[(10)] = inst_65968);

(statearr_66063[(11)] = inst_65969);

return statearr_66063;
})();
var statearr_66064_66127 = state_66054__$1;
(statearr_66064_66127[(2)] = null);

(statearr_66064_66127[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (32))){
var inst_66023 = (state_66054[(8)]);
var state_66054__$1 = state_66054;
var statearr_66065_66128 = state_66054__$1;
(statearr_66065_66128[(2)] = inst_66023);

(statearr_66065_66128[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (33))){
var inst_66029 = (state_66054[(2)]);
var state_66054__$1 = state_66054;
var statearr_66066_66129 = state_66054__$1;
(statearr_66066_66129[(2)] = inst_66029);

(statearr_66066_66129[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (13))){
var state_66054__$1 = state_66054;
var statearr_66067_66130 = state_66054__$1;
(statearr_66067_66130[(2)] = null);

(statearr_66067_66130[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (22))){
var inst_65975 = (state_66054[(7)]);
var inst_65993 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65994 = [cljs.core.string_QMARK_,cljs.core.number_QMARK_,cljs.core.true_QMARK_,cljs.core.false_QMARK_,cljs.core.nil_QMARK_];
var inst_65995 = (new cljs.core.PersistentVector(null,5,(5),inst_65993,inst_65994,null));
var inst_65996 = cljs.core.apply.call(null,cljs.core.some_fn,inst_65995);
var inst_65997 = inst_65996.call(null,inst_65975);
var state_66054__$1 = state_66054;
if(cljs.core.truth_(inst_65997)){
var statearr_66068_66131 = state_66054__$1;
(statearr_66068_66131[(1)] = (25));

} else {
var statearr_66069_66132 = state_66054__$1;
(statearr_66069_66132[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (36))){
var inst_66049 = (state_66054[(2)]);
var _ = (function (){var statearr_66070 = state_66054;
(statearr_66070[(4)] = cljs.core.rest.call(null,(state_66054[(4)])));

return statearr_66070;
})();
var state_66054__$1 = state_66054;
var statearr_66071_66133 = state_66054__$1;
(statearr_66071_66133[(2)] = inst_66049);

(statearr_66071_66133[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (29))){
var inst_65975 = (state_66054[(7)]);
var inst_66008 = cljs.core.pr_str.call(null,inst_65975);
var inst_66009 = type.call(null,inst_65975);
var inst_66010 = cljs.core.pr_str.call(null,form);
var inst_66011 = ["Invalid element (",inst_66008,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66009),") in form: ",inst_66010,"."].join('');
var inst_66012 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66013 = [(400),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)];
var inst_66014 = cljs.core.PersistentHashMap.fromArrays(inst_66012,inst_66013);
var inst_66015 = cljs.core.ex_info.call(null,inst_66011,inst_66014);
var inst_66016 = (function(){throw inst_66015})();
var state_66054__$1 = state_66054;
var statearr_66072_66134 = state_66054__$1;
(statearr_66072_66134[(2)] = inst_66016);

(statearr_66072_66134[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (6))){
var inst_65933 = cljs.core.first.call(null,form);
var state_66054__$1 = state_66054;
var statearr_66073_66135 = state_66054__$1;
(statearr_66073_66135[(2)] = inst_65933);

(statearr_66073_66135[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (28))){
var inst_65975 = (state_66054[(7)]);
var state_66054__$1 = state_66054;
var statearr_66074_66136 = state_66054__$1;
(statearr_66074_66136[(2)] = inst_65975);

(statearr_66074_66136[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (25))){
var inst_65975 = (state_66054[(7)]);
var state_66054__$1 = state_66054;
var statearr_66075_66137 = state_66054__$1;
(statearr_66075_66137[(2)] = inst_65975);

(statearr_66075_66137[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (34))){
var inst_66034 = (state_66054[(12)]);
var inst_65952 = (state_66054[(13)]);
var inst_66036 = new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null);
var inst_66037 = cljs.core.cons.call(null,inst_66036,inst_66034);
var inst_66038 = cljs.core.cons.call(null,inst_65952,inst_66037);
var inst_66039 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66040 = ["Validated fn form:",inst_66038];
var inst_66041 = (new cljs.core.PersistentVector(null,2,(5),inst_66039,inst_66040,null));
var inst_66042 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_66041);
var state_66054__$1 = (function (){var statearr_66076 = state_66054;
(statearr_66076[(14)] = inst_66042);

return statearr_66076;
})();
var statearr_66077_66138 = state_66054__$1;
(statearr_66077_66138[(2)] = inst_66038);

(statearr_66077_66138[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (17))){
var state_66054__$1 = state_66054;
var statearr_66078_66139 = state_66054__$1;
(statearr_66078_66139[(2)] = null);

(statearr_66078_66139[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (3))){
var inst_66052 = (state_66054[(2)]);
var state_66054__$1 = state_66054;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66054__$1,inst_66052);
} else {
if((state_val_66055 === (12))){
var inst_65936 = (state_66054[(15)]);
var inst_65944 = fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_65936,type);
var state_66054__$1 = state_66054;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66054__$1,(15),inst_65944);
} else {
if((state_val_66055 === (2))){
var _ = (function (){var statearr_66079 = state_66054;
(statearr_66079[(4)] = cljs.core.cons.call(null,(5),(state_66054[(4)])));

return statearr_66079;
})();
var inst_65926 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65927 = ["Validating form:",form,"- params:",params];
var inst_65928 = (new cljs.core.PersistentVector(null,4,(5),inst_65926,inst_65927,null));
var inst_65929 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_65928);
var inst_65931 = cljs.core.list_QMARK_.call(null,form);
var state_66054__$1 = (function (){var statearr_66080 = state_66054;
(statearr_66080[(16)] = inst_65929);

return statearr_66080;
})();
if(inst_65931){
var statearr_66081_66140 = state_66054__$1;
(statearr_66081_66140[(1)] = (6));

} else {
var statearr_66082_66141 = state_66054__$1;
(statearr_66082_66141[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (23))){
var inst_65969 = (state_66054[(11)]);
var inst_65976 = (state_66054[(9)]);
var inst_66022 = (state_66054[(2)]);
var inst_66023 = cljs.core.conj.call(null,inst_65969,inst_66022);
var inst_66024 = cljs.core.seq.call(null,inst_65976);
var state_66054__$1 = (function (){var statearr_66083 = state_66054;
(statearr_66083[(8)] = inst_66023);

return statearr_66083;
})();
if(inst_66024){
var statearr_66084_66142 = state_66054__$1;
(statearr_66084_66142[(1)] = (31));

} else {
var statearr_66085_66143 = state_66054__$1;
(statearr_66085_66143[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (35))){
var inst_66044 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66045 = ["Validated non-fn form:",form];
var inst_66046 = (new cljs.core.PersistentVector(null,2,(5),inst_66044,inst_66045,null));
var inst_66047 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_66046);
var state_66054__$1 = (function (){var statearr_66086 = state_66054;
(statearr_66086[(17)] = inst_66047);

return statearr_66086;
})();
var statearr_66087_66144 = state_66054__$1;
(statearr_66087_66144[(2)] = form);

(statearr_66087_66144[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (19))){
var inst_65968 = (state_66054[(10)]);
var inst_65975 = (state_66054[(7)]);
var inst_65974 = cljs.core.seq.call(null,inst_65968);
var inst_65975__$1 = cljs.core.first.call(null,inst_65974);
var inst_65976 = cljs.core.next.call(null,inst_65974);
var inst_65977 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65978 = ["Validating arg:",inst_65975__$1];
var inst_65979 = (new cljs.core.PersistentVector(null,2,(5),inst_65977,inst_65978,null));
var inst_65980 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_65979);
var inst_65982 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65983 = [cljs.core.list_QMARK_,cljs.core.vector_QMARK_];
var inst_65984 = (new cljs.core.PersistentVector(null,2,(5),inst_65982,inst_65983,null));
var inst_65985 = cljs.core.apply.call(null,cljs.core.some_fn,inst_65984);
var inst_65986 = inst_65985.call(null,inst_65975__$1);
var state_66054__$1 = (function (){var statearr_66088 = state_66054;
(statearr_66088[(18)] = inst_65980);

(statearr_66088[(7)] = inst_65975__$1);

(statearr_66088[(9)] = inst_65976);

return statearr_66088;
})();
if(cljs.core.truth_(inst_65986)){
var statearr_66089_66145 = state_66054__$1;
(statearr_66089_66145[(1)] = (21));

} else {
var statearr_66090_66146 = state_66054__$1;
(statearr_66090_66146[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (11))){
var inst_65941 = (state_66054[(19)]);
var inst_65936 = (state_66054[(15)]);
var inst_65941__$1 = (state_66054[(2)]);
var inst_65942 = cljs.core.count.call(null,inst_65941__$1);
var state_66054__$1 = (function (){var statearr_66092 = state_66054;
(statearr_66092[(19)] = inst_65941__$1);

(statearr_66092[(20)] = inst_65942);

return statearr_66092;
})();
if(cljs.core.truth_(inst_65936)){
var statearr_66093_66147 = state_66054__$1;
(statearr_66093_66147[(1)] = (12));

} else {
var statearr_66094_66148 = state_66054__$1;
(statearr_66094_66148[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (9))){
var inst_65938 = cljs.core.rest.call(null,form);
var state_66054__$1 = state_66054;
var statearr_66095_66149 = state_66054__$1;
(statearr_66095_66149[(2)] = inst_65938);

(statearr_66095_66149[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (5))){
var _ = (function (){var statearr_66096 = state_66054;
(statearr_66096[(4)] = cljs.core.rest.call(null,(state_66054[(4)])));

return statearr_66096;
})();
var state_66054__$1 = state_66054;
var ex66091 = (state_66054__$1[(2)]);
var statearr_66097_66150 = state_66054__$1;
(statearr_66097_66150[(5)] = ex66091);


if((ex66091 instanceof Error)){
var statearr_66098_66151 = state_66054__$1;
(statearr_66098_66151[(1)] = (4));

(statearr_66098_66151[(5)] = null);

} else {
throw ex66091;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (14))){
var inst_65941 = (state_66054[(19)]);
var inst_65951 = (state_66054[(21)]);
var inst_65950 = (state_66054[(22)]);
var inst_65950__$1 = (state_66054[(2)]);
var inst_65951__$1 = cljs.core.__destructure_map.call(null,inst_65950__$1);
var inst_65952 = cljs.core.get.call(null,inst_65951__$1,new cljs.core.Keyword(null,"f","f",-1597136552));
var inst_65953 = cljs.core.get.call(null,inst_65951__$1,new cljs.core.Keyword(null,"arity","arity",-1808556135));
var inst_65954 = cljs.core.get.call(null,inst_65951__$1,new cljs.core.Keyword(null,"var-args?","var-args?",-1630678710));
var inst_65955 = cljs.core.seq.call(null,inst_65941);
var state_66054__$1 = (function (){var statearr_66099 = state_66054;
(statearr_66099[(23)] = inst_65953);

(statearr_66099[(21)] = inst_65951__$1);

(statearr_66099[(24)] = inst_65954);

(statearr_66099[(22)] = inst_65950__$1);

(statearr_66099[(13)] = inst_65952);

return statearr_66099;
})();
if(inst_65955){
var statearr_66100_66152 = state_66054__$1;
(statearr_66100_66152[(1)] = (16));

} else {
var statearr_66101_66153 = state_66054__$1;
(statearr_66101_66153[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (26))){
var inst_65953 = (state_66054[(23)]);
var inst_65966 = (state_66054[(25)]);
var inst_65968 = (state_66054[(10)]);
var inst_65941 = (state_66054[(19)]);
var inst_65936 = (state_66054[(15)]);
var inst_65951 = (state_66054[(21)]);
var inst_65954 = (state_66054[(24)]);
var inst_65950 = (state_66054[(22)]);
var inst_65975 = (state_66054[(7)]);
var inst_65969 = (state_66054[(11)]);
var inst_65965 = (state_66054[(26)]);
var inst_65976 = (state_66054[(9)]);
var inst_65942 = (state_66054[(20)]);
var inst_65952 = (state_66054[(13)]);
var inst_66000 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66001 = (function (){var arity = inst_65953;
var args_n = inst_65942;
var fn_map = inst_65950;
var vec__65961 = inst_65941;
var expr__65981 = inst_65975;
var args = inst_65941;
var r = inst_65976;
var first__65963 = inst_65965;
var vec__65971 = inst_65968;
var acc = inst_65969;
var var_args_QMARK_ = inst_65954;
var seq__65972 = inst_65976;
var fn_name = inst_65936;
var G__65960 = inst_65968;
var arg = inst_65975;
var first__65973 = inst_65975;
var map__65930 = inst_65951;
var seq__65962 = inst_65966;
var f = inst_65952;
return (function (p1__65917_SHARP_){
var and__5043__auto__ = (p1__65917_SHARP_ instanceof cljs.core.Symbol);
if(and__5043__auto__){
return fluree.db.dbfunctions.core.valid_symbol_QMARK_.call(null,type,params,p1__65917_SHARP_);
} else {
return and__5043__auto__;
}
});
})();
var inst_66002 = [inst_66001];
var inst_66003 = (new cljs.core.PersistentVector(null,1,(5),inst_66000,inst_66002,null));
var inst_66004 = cljs.core.apply.call(null,cljs.core.some_fn,inst_66003);
var inst_66005 = inst_66004.call(null,inst_65975);
var state_66054__$1 = state_66054;
if(cljs.core.truth_(inst_66005)){
var statearr_66102_66154 = state_66054__$1;
(statearr_66102_66154[(1)] = (28));

} else {
var statearr_66103_66155 = state_66054__$1;
(statearr_66103_66155[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (16))){
var inst_65941 = (state_66054[(19)]);
var inst_65964 = cljs.core.seq.call(null,inst_65941);
var inst_65965 = cljs.core.first.call(null,inst_65964);
var inst_65966 = cljs.core.next.call(null,inst_65964);
var inst_65967 = cljs.core.PersistentVector.EMPTY;
var inst_65968 = inst_65941;
var inst_65969 = inst_65967;
var state_66054__$1 = (function (){var statearr_66104 = state_66054;
(statearr_66104[(25)] = inst_65966);

(statearr_66104[(10)] = inst_65968);

(statearr_66104[(11)] = inst_65969);

(statearr_66104[(26)] = inst_65965);

return statearr_66104;
})();
var statearr_66105_66156 = state_66054__$1;
(statearr_66105_66156[(2)] = null);

(statearr_66105_66156[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (30))){
var inst_66018 = (state_66054[(2)]);
var state_66054__$1 = state_66054;
var statearr_66106_66157 = state_66054__$1;
(statearr_66106_66157[(2)] = inst_66018);

(statearr_66106_66157[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (10))){
var state_66054__$1 = state_66054;
var statearr_66107_66158 = state_66054__$1;
(statearr_66107_66158[(2)] = form);

(statearr_66107_66158[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (18))){
var inst_65936 = (state_66054[(15)]);
var inst_66034 = (state_66054[(2)]);
var state_66054__$1 = (function (){var statearr_66108 = state_66054;
(statearr_66108[(12)] = inst_66034);

return statearr_66108;
})();
if(cljs.core.truth_(inst_65936)){
var statearr_66109_66159 = state_66054__$1;
(statearr_66109_66159[(1)] = (34));

} else {
var statearr_66110_66160 = state_66054__$1;
(statearr_66110_66160[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66055 === (8))){
var inst_65936 = (state_66054[(15)]);
var inst_65936__$1 = (state_66054[(2)]);
var state_66054__$1 = (function (){var statearr_66111 = state_66054;
(statearr_66111[(15)] = inst_65936__$1);

return statearr_66111;
})();
if(cljs.core.truth_(inst_65936__$1)){
var statearr_66112_66161 = state_66054__$1;
(statearr_66112_66161[(1)] = (9));

} else {
var statearr_66113_66162 = state_66054__$1;
(statearr_66113_66162[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__2746__auto____0 = (function (){
var statearr_66114 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66114[(0)] = fluree$db$dbfunctions$core$state_machine__2746__auto__);

(statearr_66114[(1)] = (1));

return statearr_66114;
});
var fluree$db$dbfunctions$core$state_machine__2746__auto____1 = (function (state_66054){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_66054);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e66115){var ex__2749__auto__ = e66115;
var statearr_66116_66163 = state_66054;
(statearr_66116_66163[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_66054[(4)]))){
var statearr_66117_66164 = state_66054;
(statearr_66117_66164[(1)] = cljs.core.first.call(null,(state_66054[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66165 = state_66054;
state_66054 = G__66165;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__2746__auto__ = function(state_66054){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__2746__auto____1.call(this,state_66054);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__2746__auto____0;
fluree$db$dbfunctions$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__2746__auto____1;
return fluree$db$dbfunctions$core$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_66118 = f__2769__auto__.call(null);
(statearr_66118[(6)] = c__2768__auto__);

return statearr_66118;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.core.validate_form.cljs$lang$maxFixedArity = 4);

fluree.db.dbfunctions.core.parse_fn = (function fluree$db$dbfunctions$core$parse_fn(db,fn_str,type,params){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_66201){
var state_val_66202 = (state_66201[(1)]);
if((state_val_66202 === (7))){
var inst_66172 = ["(fn [_] ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_str),")"].join('');
var inst_66173 = fluree.db.dbfunctions.core.parse_string.call(null,inst_66172);
var state_66201__$1 = state_66201;
var statearr_66203_66227 = state_66201__$1;
(statearr_66203_66227[(2)] = inst_66173);

(statearr_66203_66227[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66202 === (1))){
var state_66201__$1 = state_66201;
var statearr_66204_66228 = state_66201__$1;
(statearr_66204_66228[(2)] = null);

(statearr_66204_66228[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66202 === (4))){
var inst_66166 = (state_66201[(2)]);
var state_66201__$1 = state_66201;
var statearr_66205_66229 = state_66201__$1;
(statearr_66205_66229[(2)] = inst_66166);

(statearr_66205_66229[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66202 === (6))){
var inst_66196 = (state_66201[(2)]);
var _ = (function (){var statearr_66206 = state_66201;
(statearr_66206[(4)] = cljs.core.rest.call(null,(state_66201[(4)])));

return statearr_66206;
})();
var state_66201__$1 = state_66201;
var statearr_66207_66230 = state_66201__$1;
(statearr_66207_66230[(2)] = inst_66196);

(statearr_66207_66230[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66202 === (3))){
var inst_66199 = (state_66201[(2)]);
var state_66201__$1 = state_66201;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66201__$1,inst_66199);
} else {
if((state_val_66202 === (12))){
var inst_66180 = (state_66201[(2)]);
var inst_66181 = fluree.db.util.async.throw_err.call(null,inst_66180);
var inst_66182 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66183 = ["Parsed & validated db fn:",inst_66181];
var inst_66184 = (new cljs.core.PersistentVector(null,2,(5),inst_66182,inst_66183,null));
var inst_66185 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_66184);
var state_66201__$1 = (function (){var statearr_66208 = state_66201;
(statearr_66208[(7)] = inst_66185);

return statearr_66208;
})();
var statearr_66209_66231 = state_66201__$1;
(statearr_66209_66231[(2)] = inst_66181);

(statearr_66209_66231[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66202 === (2))){
var _ = (function (){var statearr_66210 = state_66201;
(statearr_66210[(4)] = cljs.core.cons.call(null,(5),(state_66201[(4)])));

return statearr_66210;
})();
var state_66201__$1 = state_66201;
var G__66211_66232 = fn_str;
switch (G__66211_66232) {
case "true":
case "false":
var statearr_66212_66234 = state_66201__$1;
(statearr_66212_66234[(1)] = (7));


break;
default:
var statearr_66213_66235 = state_66201__$1;
(statearr_66213_66235[(1)] = (8));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66202 === (11))){
var inst_66193 = (state_66201[(2)]);
var state_66201__$1 = state_66201;
var statearr_66215_66236 = state_66201__$1;
(statearr_66215_66236[(2)] = inst_66193);

(statearr_66215_66236[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66202 === (9))){
var inst_66177 = fluree.db.dbfunctions.core.parse_string.call(null,fn_str);
var inst_66178 = fluree.db.dbfunctions.core.validate_form.call(null,db,inst_66177,type,params);
var state_66201__$1 = state_66201;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66201__$1,(12),inst_66178);
} else {
if((state_val_66202 === (5))){
var _ = (function (){var statearr_66216 = state_66201;
(statearr_66216[(4)] = cljs.core.rest.call(null,(state_66201[(4)])));

return statearr_66216;
})();
var state_66201__$1 = state_66201;
var ex66214 = (state_66201__$1[(2)]);
var statearr_66217_66237 = state_66201__$1;
(statearr_66217_66237[(5)] = ex66214);


if((ex66214 instanceof Error)){
var statearr_66218_66238 = state_66201__$1;
(statearr_66218_66238[(1)] = (4));

(statearr_66218_66238[(5)] = null);

} else {
throw ex66214;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66202 === (10))){
var inst_66187 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66188 = [(400),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)];
var inst_66189 = cljs.core.PersistentHashMap.fromArrays(inst_66187,inst_66188);
var inst_66190 = cljs.core.ex_info.call(null,"Bad function",inst_66189);
var inst_66191 = (function(){throw inst_66190})();
var state_66201__$1 = state_66201;
var statearr_66219_66239 = state_66201__$1;
(statearr_66219_66239[(2)] = inst_66191);

(statearr_66219_66239[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66202 === (8))){
var inst_66175 = cljs.core.re_matches.call(null,/^\(.+\)$/,fn_str);
var state_66201__$1 = state_66201;
if(cljs.core.truth_(inst_66175)){
var statearr_66220_66240 = state_66201__$1;
(statearr_66220_66240[(1)] = (9));

} else {
var statearr_66221_66241 = state_66201__$1;
(statearr_66221_66241[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$parse_fn_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$core$parse_fn_$_state_machine__2746__auto____0 = (function (){
var statearr_66222 = [null,null,null,null,null,null,null,null];
(statearr_66222[(0)] = fluree$db$dbfunctions$core$parse_fn_$_state_machine__2746__auto__);

(statearr_66222[(1)] = (1));

return statearr_66222;
});
var fluree$db$dbfunctions$core$parse_fn_$_state_machine__2746__auto____1 = (function (state_66201){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_66201);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e66223){var ex__2749__auto__ = e66223;
var statearr_66224_66242 = state_66201;
(statearr_66224_66242[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_66201[(4)]))){
var statearr_66225_66243 = state_66201;
(statearr_66225_66243[(1)] = cljs.core.first.call(null,(state_66201[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66244 = state_66201;
state_66201 = G__66244;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$parse_fn_$_state_machine__2746__auto__ = function(state_66201){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$parse_fn_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$parse_fn_$_state_machine__2746__auto____1.call(this,state_66201);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$parse_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$parse_fn_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$core$parse_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$parse_fn_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$core$parse_fn_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_66226 = f__2769__auto__.call(null);
(statearr_66226[(6)] = c__2768__auto__);

return statearr_66226;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.dbfunctions.core.parse_and_wrap_fn = (function fluree$db$dbfunctions$core$parse_and_wrap_fn(var_args){
var G__66246 = arguments.length;
switch (G__66246) {
case 3:
return fluree.db.dbfunctions.core.parse_and_wrap_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_and_wrap_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_and_wrap_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_str,type){
return fluree.db.dbfunctions.core.parse_and_wrap_fn.call(null,db,fn_str,type,null);
}));

(fluree.db.dbfunctions.core.parse_and_wrap_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,fn_str,type,params){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_66289){
var state_val_66290 = (state_66289[(1)]);
if((state_val_66290 === (7))){
var inst_66272 = cljs.core._EQ_.call(null,type,"functionDec");
var state_66289__$1 = state_66289;
var statearr_66291_66315 = state_66289__$1;
(statearr_66291_66315[(2)] = inst_66272);

(statearr_66291_66315[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66290 === (1))){
var state_66289__$1 = state_66289;
var statearr_66292_66316 = state_66289__$1;
(statearr_66292_66316[(2)] = null);

(statearr_66292_66316[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66290 === (4))){
var inst_66247 = (state_66289[(2)]);
var state_66289__$1 = state_66289;
var statearr_66293_66317 = state_66289__$1;
(statearr_66293_66317[(2)] = inst_66247);

(statearr_66293_66317[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66290 === (6))){
var inst_66270 = (state_66289[(7)]);
var inst_66255 = (state_66289[(2)]);
var inst_66256 = fluree.db.util.async.throw_err.call(null,inst_66255);
var inst_66257 = new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null);
var inst_66258 = (new cljs.core.List(null,inst_66257,null,(1),null));
var inst_66259 = new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null);
var inst_66260 = (new cljs.core.List(null,inst_66259,null,(1),null));
var inst_66261 = cljs.core.concat.call(null,inst_66260);
var inst_66262 = cljs.core.seq.call(null,inst_66261);
var inst_66263 = cljs.core.sequence.call(null,inst_66262);
var inst_66264 = cljs.core.vec.call(null,inst_66263);
var inst_66265 = (new cljs.core.List(null,inst_66264,null,(1),null));
var inst_66266 = (new cljs.core.List(null,inst_66256,null,(1),null));
var inst_66267 = cljs.core.concat.call(null,inst_66258,inst_66265,inst_66266);
var inst_66268 = cljs.core.seq.call(null,inst_66267);
var inst_66269 = cljs.core.sequence.call(null,inst_66268);
var inst_66270__$1 = params;
var state_66289__$1 = (function (){var statearr_66294 = state_66289;
(statearr_66294[(7)] = inst_66270__$1);

(statearr_66294[(8)] = inst_66269);

return statearr_66294;
})();
if(cljs.core.truth_(inst_66270__$1)){
var statearr_66295_66318 = state_66289__$1;
(statearr_66295_66318[(1)] = (7));

} else {
var statearr_66296_66319 = state_66289__$1;
(statearr_66296_66319[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66290 === (3))){
var inst_66287 = (state_66289[(2)]);
var state_66289__$1 = state_66289;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66289__$1,inst_66287);
} else {
if((state_val_66290 === (12))){
var inst_66280 = (state_66289[(2)]);
var inst_66281 = [new cljs.core.Keyword(null,"fnstr","fnstr",2092773532)];
var inst_66282 = [fn_str];
var inst_66283 = cljs.core.PersistentHashMap.fromArrays(inst_66281,inst_66282);
var inst_66284 = cljs.core.with_meta.call(null,inst_66280,inst_66283);
var _ = (function (){var statearr_66297 = state_66289;
(statearr_66297[(4)] = cljs.core.rest.call(null,(state_66289[(4)])));

return statearr_66297;
})();
var state_66289__$1 = state_66289;
var statearr_66298_66320 = state_66289__$1;
(statearr_66298_66320[(2)] = inst_66284);

(statearr_66298_66320[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66290 === (2))){
var _ = (function (){var statearr_66299 = state_66289;
(statearr_66299[(4)] = cljs.core.cons.call(null,(5),(state_66289[(4)])));

return statearr_66299;
})();
var inst_66253 = fluree.db.dbfunctions.core.parse_fn.call(null,db,fn_str,type,params);
var state_66289__$1 = state_66289;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66289__$1,(6),inst_66253);
} else {
if((state_val_66290 === (11))){
var inst_66269 = (state_66289[(8)]);
var inst_66278 = fluree.db.dbfunctions.core.eval_form.call(null,inst_66269);
var state_66289__$1 = state_66289;
var statearr_66301_66321 = state_66289__$1;
(statearr_66301_66321[(2)] = inst_66278);

(statearr_66301_66321[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66290 === (9))){
var inst_66275 = (state_66289[(2)]);
var state_66289__$1 = state_66289;
if(cljs.core.truth_(inst_66275)){
var statearr_66302_66322 = state_66289__$1;
(statearr_66302_66322[(1)] = (10));

} else {
var statearr_66303_66323 = state_66289__$1;
(statearr_66303_66323[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66290 === (5))){
var _ = (function (){var statearr_66304 = state_66289;
(statearr_66304[(4)] = cljs.core.rest.call(null,(state_66289[(4)])));

return statearr_66304;
})();
var state_66289__$1 = state_66289;
var ex66300 = (state_66289__$1[(2)]);
var statearr_66305_66324 = state_66289__$1;
(statearr_66305_66324[(5)] = ex66300);


if((ex66300 instanceof Error)){
var statearr_66306_66325 = state_66289__$1;
(statearr_66306_66325[(1)] = (4));

(statearr_66306_66325[(5)] = null);

} else {
throw ex66300;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66290 === (10))){
var inst_66269 = (state_66289[(8)]);
var state_66289__$1 = state_66289;
var statearr_66307_66326 = state_66289__$1;
(statearr_66307_66326[(2)] = inst_66269);

(statearr_66307_66326[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66290 === (8))){
var inst_66270 = (state_66289[(7)]);
var state_66289__$1 = state_66289;
var statearr_66308_66327 = state_66289__$1;
(statearr_66308_66327[(2)] = inst_66270);

(statearr_66308_66327[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__2746__auto____0 = (function (){
var statearr_66309 = [null,null,null,null,null,null,null,null,null];
(statearr_66309[(0)] = fluree$db$dbfunctions$core$state_machine__2746__auto__);

(statearr_66309[(1)] = (1));

return statearr_66309;
});
var fluree$db$dbfunctions$core$state_machine__2746__auto____1 = (function (state_66289){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_66289);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e66310){var ex__2749__auto__ = e66310;
var statearr_66311_66328 = state_66289;
(statearr_66311_66328[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_66289[(4)]))){
var statearr_66312_66329 = state_66289;
(statearr_66312_66329[(1)] = cljs.core.first.call(null,(state_66289[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66330 = state_66289;
state_66289 = G__66330;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__2746__auto__ = function(state_66289){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__2746__auto____1.call(this,state_66289);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__2746__auto____0;
fluree$db$dbfunctions$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__2746__auto____1;
return fluree$db$dbfunctions$core$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_66313 = f__2769__auto__.call(null);
(statearr_66313[(6)] = c__2768__auto__);

return statearr_66313;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.core.parse_and_wrap_fn.cljs$lang$maxFixedArity = 4);

/**
 * Executes a transaction function
 */
fluree.db.dbfunctions.core.execute_tx_fn = (function fluree$db$dbfunctions$core$execute_tx_fn(p__66331){
var map__66332 = p__66331;
var map__66332__$1 = cljs.core.__destructure_map.call(null,map__66332);
var db = cljs.core.get.call(null,map__66332__$1,new cljs.core.Keyword(null,"db","db",993250759));
var auth = cljs.core.get.call(null,map__66332__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var _credits = cljs.core.get.call(null,map__66332__$1,new cljs.core.Keyword(null,"_credits","_credits",1245712171));
var s = cljs.core.get.call(null,map__66332__$1,new cljs.core.Keyword(null,"s","s",1705939918));
var p = cljs.core.get.call(null,map__66332__$1,new cljs.core.Keyword(null,"p","p",151049309));
var o = cljs.core.get.call(null,map__66332__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var fuel = cljs.core.get.call(null,map__66332__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485));
var block_instant = cljs.core.get.call(null,map__66332__$1,new cljs.core.Keyword(null,"block-instant","block-instant",-641639021));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_66366){
var state_val_66367 = (state_66366[(1)]);
if((state_val_66367 === (7))){
var inst_66353 = (state_66366[(7)]);
var state_66366__$1 = state_66366;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66366__$1,(10),inst_66353);
} else {
if((state_val_66367 === (1))){
var state_66366__$1 = state_66366;
var statearr_66368_66388 = state_66366__$1;
(statearr_66368_66388[(2)] = null);

(statearr_66368_66388[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66367 === (4))){
var inst_66333 = (state_66366[(2)]);
var state_66366__$1 = state_66366;
var statearr_66369_66389 = state_66366__$1;
(statearr_66369_66389[(2)] = inst_66333);

(statearr_66369_66389[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66367 === (6))){
var inst_66353 = (state_66366[(7)]);
var inst_66342 = (state_66366[(8)]);
var inst_66345 = (state_66366[(2)]);
var inst_66346 = fluree.db.util.async.throw_err.call(null,inst_66345);
var inst_66347 = (new cljs.core.List(null,inst_66342,null,(1),null));
var inst_66348 = (new cljs.core.List(null,inst_66346,inst_66347,(2),null));
var inst_66349 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66350 = ["Evaluating fn call:",inst_66348];
var inst_66351 = (new cljs.core.PersistentVector(null,2,(5),inst_66349,inst_66350,null));
var inst_66352 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_66351);
var inst_66353__$1 = fluree.db.dbfunctions.core.eval_form.call(null,inst_66348);
var inst_66354 = fluree.db.util.async.channel_QMARK_.call(null,inst_66353__$1);
var state_66366__$1 = (function (){var statearr_66370 = state_66366;
(statearr_66370[(9)] = inst_66352);

(statearr_66370[(7)] = inst_66353__$1);

return statearr_66370;
})();
if(inst_66354){
var statearr_66371_66390 = state_66366__$1;
(statearr_66371_66390[(1)] = (7));

} else {
var statearr_66372_66391 = state_66366__$1;
(statearr_66372_66391[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66367 === (3))){
var inst_66364 = (state_66366[(2)]);
var state_66366__$1 = state_66366;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66366__$1,inst_66364);
} else {
if((state_val_66367 === (2))){
var _ = (function (){var statearr_66374 = state_66366;
(statearr_66374[(4)] = cljs.core.cons.call(null,(5),(state_66366[(4)])));

return statearr_66374;
})();
var inst_66339 = cljs.core.subs.call(null,o,(1));
var inst_66340 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"pid","pid",1018387698),new cljs.core.Keyword(null,"auth_id","auth_id",1917762333),new cljs.core.Keyword(null,"state","state",-1988618099)];
var inst_66341 = [db,block_instant,s,p,auth,fuel];
var inst_66342 = cljs.core.PersistentHashMap.fromArrays(inst_66340,inst_66341);
var inst_66343 = fluree.db.dbfunctions.core.parse_and_wrap_fn.call(null,db,inst_66339,"txn");
var state_66366__$1 = (function (){var statearr_66375 = state_66366;
(statearr_66375[(8)] = inst_66342);

return statearr_66375;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66366__$1,(6),inst_66343);
} else {
if((state_val_66367 === (9))){
var inst_66361 = (state_66366[(2)]);
var _ = (function (){var statearr_66376 = state_66366;
(statearr_66376[(4)] = cljs.core.rest.call(null,(state_66366[(4)])));

return statearr_66376;
})();
var state_66366__$1 = state_66366;
var statearr_66377_66392 = state_66366__$1;
(statearr_66377_66392[(2)] = inst_66361);

(statearr_66377_66392[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66367 === (5))){
var _ = (function (){var statearr_66378 = state_66366;
(statearr_66378[(4)] = cljs.core.rest.call(null,(state_66366[(4)])));

return statearr_66378;
})();
var state_66366__$1 = state_66366;
var ex66373 = (state_66366__$1[(2)]);
var statearr_66379_66393 = state_66366__$1;
(statearr_66379_66393[(5)] = ex66373);


if((ex66373 instanceof Error)){
var statearr_66380_66394 = state_66366__$1;
(statearr_66380_66394[(1)] = (4));

(statearr_66380_66394[(5)] = null);

} else {
throw ex66373;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66367 === (10))){
var inst_66357 = (state_66366[(2)]);
var inst_66358 = fluree.db.util.async.throw_err.call(null,inst_66357);
var state_66366__$1 = state_66366;
var statearr_66381_66395 = state_66366__$1;
(statearr_66381_66395[(2)] = inst_66358);

(statearr_66381_66395[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66367 === (8))){
var inst_66353 = (state_66366[(7)]);
var state_66366__$1 = state_66366;
var statearr_66382_66396 = state_66366__$1;
(statearr_66382_66396[(2)] = inst_66353);

(statearr_66382_66396[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto____0 = (function (){
var statearr_66383 = [null,null,null,null,null,null,null,null,null,null];
(statearr_66383[(0)] = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto__);

(statearr_66383[(1)] = (1));

return statearr_66383;
});
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto____1 = (function (state_66366){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_66366);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e66384){var ex__2749__auto__ = e66384;
var statearr_66385_66397 = state_66366;
(statearr_66385_66397[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_66366[(4)]))){
var statearr_66386_66398 = state_66366;
(statearr_66386_66398[(1)] = cljs.core.first.call(null,(state_66366[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66399 = state_66366;
state_66366 = G__66399;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto__ = function(state_66366){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto____1.call(this,state_66366);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_66387 = f__2769__auto__.call(null);
(statearr_66387[(6)] = c__2768__auto__);

return statearr_66387;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
