// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.range');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.call(null,param_str):param_str);
if(cljs.core.map_QMARK_.call(null,parsed_param)){
var key = cljs.core.first.call(null,cljs.core.keys.call(null,parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace.call(null,key) == null))?cljs.core.name.call(null,key):[cljs.core.namespace.call(null,key),"/",cljs.core.name.call(null,key)].join('')));
var value = cljs.core.first.call(null,cljs.core.vals.call(null,parsed_param));
var value_SINGLEQUOTE_ = fluree.db.dbfunctions.internal.parse_select_map.call(null,value);
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,value_SINGLEQUOTE_))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.call(null,cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_.call(null,parsed_param)))){
if((cljs.core.namespace.call(null,parsed_param) == null)){
return cljs.core.name.call(null,parsed_param);
} else {
return [cljs.core.namespace.call(null,parsed_param),"/",cljs.core.name.call(null,parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_.call(null,parsed_param)){
return cljs.core.mapv.call(null,fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.call(null,["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36094 = arguments.length;
var i__5770__auto___36095 = (0);
while(true){
if((i__5770__auto___36095 < len__5769__auto___36094)){
args__5775__auto__.push((arguments[i__5770__auto___36095]));

var G__36096 = (i__5770__auto___36095 + (1));
i__5770__auto___36095 = G__36096;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.call(null,e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.call(null,args));

throw cljs.core.ex_info.call(null,(function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,args))?clojure.string.join.call(null," ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq36091){
var G__36092 = cljs.core.first.call(null,seq36091);
var seq36091__$1 = cljs.core.next.call(null,seq36091);
var G__36093 = cljs.core.first.call(null,seq36091__$1);
var seq36091__$2 = cljs.core.next.call(null,seq36091__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__36092,G__36093,seq36091__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$.call(null,x);
}catch (e36097){var e = e36097;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"boolean",x);
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e36098){var e = e36098;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nil?",arg);
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not.call(null,arg);
}catch (e36099){var e = e36099;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not",arg);
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_.call(null,arg)) || (cljs.core._EQ_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e36100){var e = e36100;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"empty?",arg);
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e36101){var e = e36101;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"if-else",test,true_res,false_res);
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36104 = arguments.length;
var i__5770__auto___36105 = (0);
while(true){
if((i__5770__auto___36105 < len__5769__auto___36104)){
args__5775__auto__.push((arguments[i__5770__auto___36105]));

var G__36106 = (i__5770__auto___36105 + (1));
i__5770__auto___36105 = G__36106;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e36103){var e = e36103;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"and",args);
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq36102){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36102));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36109 = arguments.length;
var i__5770__auto___36110 = (0);
while(true){
if((i__5770__auto___36110 < len__5769__auto___36109)){
args__5775__auto__.push((arguments[i__5770__auto___36110]));

var G__36111 = (i__5770__auto___36110 + (1));
i__5770__auto___36110 = G__36111;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.some.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e36108){var e = e36108;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"or",args);
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq36107){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36107));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count.call(null,coll);
}catch (e36112){var e = e36112;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"count",coll);
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36115 = arguments.length;
var i__5770__auto___36116 = (0);
while(true){
if((i__5770__auto___36116 < len__5769__auto___36115)){
args__5775__auto__.push((arguments[i__5770__auto___36116]));

var G__36117 = (i__5770__auto___36116 + (1));
i__5770__auto___36116 = G__36117;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.str,args);
}catch (e36114){var e = e36114;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"str",args);
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq36113){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36113));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36120 = arguments.length;
var i__5770__auto___36121 = (0);
while(true){
if((i__5770__auto___36121 < len__5769__auto___36120)){
args__5775__auto__.push((arguments[i__5770__auto___36121]));

var G__36122 = (i__5770__auto___36121 + (1));
i__5770__auto___36121 = G__36122;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.subs,args);
}catch (e36119){var e = e36119;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"subs",args);
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq36118){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36118));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case.call(null,str);
}catch (e36123){var e = e36123;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"lower-case",str);
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case.call(null,str);
}catch (e36124){var e = e36124;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"upper-case",str);
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36127 = arguments.length;
var i__5770__auto___36128 = (0);
while(true){
if((i__5770__auto___36128 < len__5769__auto___36127)){
args__5775__auto__.push((arguments[i__5770__auto___36128]));

var G__36129 = (i__5770__auto___36128 + (1));
i__5770__auto___36128 = G__36129;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.max,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e36126){var e = e36126;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"max",args);
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq36125){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36125));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36132 = arguments.length;
var i__5770__auto___36133 = (0);
while(true){
if((i__5770__auto___36133 < len__5769__auto___36132)){
args__5775__auto__.push((arguments[i__5770__auto___36133]));

var G__36134 = (i__5770__auto___36133 + (1));
i__5770__auto___36133 = G__36134;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e36131){var e = e36131;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"min",args);
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq36130){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36130));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36137 = arguments.length;
var i__5770__auto___36138 = (0);
while(true){
if((i__5770__auto___36138 < len__5769__auto___36137)){
args__5775__auto__.push((arguments[i__5770__auto___36138]));

var G__36139 = (i__5770__auto___36138 + (1));
i__5770__auto___36138 = G__36139;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT_,args);
}catch (e36136){var e = e36136;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">",args);
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq36135){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36135));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36142 = arguments.length;
var i__5770__auto___36143 = (0);
while(true){
if((i__5770__auto___36143 < len__5769__auto___36142)){
args__5775__auto__.push((arguments[i__5770__auto___36143]));

var G__36144 = (i__5770__auto___36143 + (1));
i__5770__auto___36143 = G__36144;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT__EQ_,args);
}catch (e36141){var e = e36141;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">=",args);
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq36140){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36140));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36147 = arguments.length;
var i__5770__auto___36148 = (0);
while(true){
if((i__5770__auto___36148 < len__5769__auto___36147)){
args__5775__auto__.push((arguments[i__5770__auto___36148]));

var G__36149 = (i__5770__auto___36148 + (1));
i__5770__auto___36148 = G__36149;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT_,args);
}catch (e36146){var e = e36146;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<",args);
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq36145){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36145));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36152 = arguments.length;
var i__5770__auto___36153 = (0);
while(true){
if((i__5770__auto___36153 < len__5769__auto___36152)){
args__5775__auto__.push((arguments[i__5770__auto___36153]));

var G__36154 = (i__5770__auto___36153 + (1));
i__5770__auto___36153 = G__36154;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT__EQ_,args);
}catch (e36151){var e = e36151;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<=",args);
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq36150){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36150));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36157 = arguments.length;
var i__5770__auto___36158 = (0);
while(true){
if((i__5770__auto___36158 < len__5769__auto___36157)){
args__5775__auto__.push((arguments[i__5770__auto___36158]));

var G__36159 = (i__5770__auto___36158 + (1));
i__5770__auto___36158 = G__36159;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.not_EQ_,args);
}catch (e36156){var e = e36156;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not=",args);
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq36155){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36155));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__36161 = arguments.length;
switch (G__36161) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_36189){
var state_val_36190 = (state_36189[(1)]);
if((state_val_36190 === (7))){
var inst_36174 = (state_36189[(7)]);
var inst_36177 = fluree.db.dbfunctions.internal.function_error.call(null,inst_36174,"query",query_map);
var state_36189__$1 = state_36189;
var statearr_36191_36277 = state_36189__$1;
(statearr_36191_36277[(2)] = inst_36177);

(statearr_36191_36277[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36190 === (1))){
var state_36189__$1 = state_36189;
var statearr_36192_36278 = state_36189__$1;
(statearr_36192_36278[(2)] = null);

(statearr_36192_36278[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36190 === (4))){
var inst_36162 = (state_36189[(2)]);
var state_36189__$1 = state_36189;
var statearr_36193_36279 = state_36189__$1;
(statearr_36193_36279[(2)] = inst_36162);

(statearr_36193_36279[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36190 === (6))){
var inst_36174 = (state_36189[(7)]);
var inst_36174__$1 = (state_36189[(2)]);
var inst_36175 = fluree.db.util.core.exception_QMARK_.call(null,inst_36174__$1);
var state_36189__$1 = (function (){var statearr_36194 = state_36189;
(statearr_36194[(7)] = inst_36174__$1);

return statearr_36194;
})();
if(inst_36175){
var statearr_36195_36280 = state_36189__$1;
(statearr_36195_36280[(1)] = (7));

} else {
var statearr_36196_36281 = state_36189__$1;
(statearr_36196_36281[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36190 === (3))){
var inst_36187 = (state_36189[(2)]);
var state_36189__$1 = state_36189;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36189__$1,inst_36187);
} else {
if((state_val_36190 === (2))){
var inst_36168 = (state_36189[(8)]);
var _ = (function (){var statearr_36198 = state_36189;
(statearr_36198[(4)] = cljs.core.cons.call(null,(5),(state_36189[(4)])));

return statearr_36198;
})();
var inst_36168__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_36169 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_36170 = cljs.core.assoc.call(null,inst_36169,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_36168__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000));
var inst_36171 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_36170);
var inst_36172 = fluree.db.query.fql.query.call(null,db,inst_36171);
var state_36189__$1 = (function (){var statearr_36199 = state_36189;
(statearr_36199[(8)] = inst_36168__$1);

return statearr_36199;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36189__$1,(6),inst_36172);
} else {
if((state_val_36190 === (9))){
var inst_36184 = (state_36189[(2)]);
var _ = (function (){var statearr_36200 = state_36189;
(statearr_36200[(4)] = cljs.core.rest.call(null,(state_36189[(4)])));

return statearr_36200;
})();
var state_36189__$1 = state_36189;
var statearr_36201_36282 = state_36189__$1;
(statearr_36201_36282[(2)] = inst_36184);

(statearr_36201_36282[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36190 === (5))){
var _ = (function (){var statearr_36202 = state_36189;
(statearr_36202[(4)] = cljs.core.rest.call(null,(state_36189[(4)])));

return statearr_36202;
})();
var state_36189__$1 = state_36189;
var ex36197 = (state_36189__$1[(2)]);
var statearr_36203_36283 = state_36189__$1;
(statearr_36203_36283[(5)] = ex36197);


if((ex36197 instanceof Error)){
var statearr_36204_36284 = state_36189__$1;
(statearr_36204_36284[(1)] = (4));

(statearr_36204_36284[(5)] = null);

} else {
throw ex36197;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36190 === (8))){
var inst_36174 = (state_36189[(7)]);
var inst_36168 = (state_36189[(8)]);
var inst_36179 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36180 = cljs.core.deref.call(null,inst_36168);
var inst_36181 = [inst_36174,inst_36180];
var inst_36182 = (new cljs.core.PersistentVector(null,2,(5),inst_36179,inst_36181,null));
var state_36189__$1 = state_36189;
var statearr_36205_36285 = state_36189__$1;
(statearr_36205_36285[(2)] = inst_36182);

(statearr_36205_36285[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2746__auto____0 = (function (){
var statearr_36206 = [null,null,null,null,null,null,null,null,null];
(statearr_36206[(0)] = fluree$db$dbfunctions$internal$state_machine__2746__auto__);

(statearr_36206[(1)] = (1));

return statearr_36206;
});
var fluree$db$dbfunctions$internal$state_machine__2746__auto____1 = (function (state_36189){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_36189);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e36207){var ex__2749__auto__ = e36207;
var statearr_36208_36286 = state_36189;
(statearr_36208_36286[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_36189[(4)]))){
var statearr_36209_36287 = state_36189;
(statearr_36209_36287[(1)] = cljs.core.first.call(null,(state_36189[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36288 = state_36189;
state_36189 = G__36288;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2746__auto__ = function(state_36189){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____1.call(this,state_36189);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_36210 = f__2769__auto__.call(null);
(statearr_36210[(6)] = c__2768__auto__);

return statearr_36210;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_36255){
var state_val_36256 = (state_36255[(1)]);
if((state_val_36256 === (7))){
var inst_36241 = (state_36255[(2)]);
var inst_36242 = fluree.db.query.fql.query.call(null,db,inst_36241);
var state_36255__$1 = state_36255;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36255__$1,(8),inst_36242);
} else {
if((state_val_36256 === (1))){
var inst_36211 = typeof select === 'string';
var state_36255__$1 = state_36255;
if(cljs.core.truth_(inst_36211)){
var statearr_36257_36289 = state_36255__$1;
(statearr_36257_36289[(1)] = (2));

} else {
var statearr_36258_36290 = state_36255__$1;
(statearr_36258_36290[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36256 === (4))){
var inst_36217 = (state_36255[(7)]);
var inst_36224 = (state_36255[(8)]);
var inst_36216 = (state_36255[(2)]);
var inst_36217__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_36218 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_36219 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_36220 = [inst_36217__$1,(100000)];
var inst_36221 = cljs.core.PersistentHashMap.fromArrays(inst_36219,inst_36220);
var inst_36222 = [inst_36216,from,where,block,limit,inst_36221];
var inst_36223 = cljs.core.PersistentHashMap.fromArrays(inst_36218,inst_36222);
var inst_36224__$1 = fluree.db.util.core.without_nils.call(null,inst_36223);
var inst_36225 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_36224__$1);
var inst_36226 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_36224__$1);
var inst_36227 = cljs.core.first.call(null,inst_36226);
var inst_36228 = fluree.db.dbfunctions.internal.str.call(null,inst_36227);
var inst_36229 = cljs.core._EQ_.call(null,"[",inst_36228);
var inst_36230 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_36224__$1);
var inst_36231 = cljs.core.last.call(null,inst_36230);
var inst_36232 = fluree.db.dbfunctions.internal.str.call(null,inst_36231);
var inst_36233 = cljs.core._EQ_.call(null,"]",inst_36232);
var inst_36234 = fluree.db.dbfunctions.internal.and.call(null,inst_36225,inst_36229,inst_36233);
var state_36255__$1 = (function (){var statearr_36259 = state_36255;
(statearr_36259[(7)] = inst_36217__$1);

(statearr_36259[(8)] = inst_36224__$1);

return statearr_36259;
})();
if(cljs.core.truth_(inst_36234)){
var statearr_36260_36291 = state_36255__$1;
(statearr_36260_36291[(1)] = (5));

} else {
var statearr_36261_36292 = state_36255__$1;
(statearr_36261_36292[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36256 === (6))){
var inst_36224 = (state_36255[(8)]);
var state_36255__$1 = state_36255;
var statearr_36262_36293 = state_36255__$1;
(statearr_36262_36293[(2)] = inst_36224);

(statearr_36262_36293[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36256 === (3))){
var state_36255__$1 = state_36255;
var statearr_36263_36294 = state_36255__$1;
(statearr_36263_36294[(2)] = select);

(statearr_36263_36294[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36256 === (2))){
var inst_36213 = fluree.db.dbfunctions.internal.parse_select_map.call(null,select);
var state_36255__$1 = state_36255;
var statearr_36264_36295 = state_36255__$1;
(statearr_36264_36295[(2)] = inst_36213);

(statearr_36264_36295[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36256 === (11))){
var inst_36253 = (state_36255[(2)]);
var state_36255__$1 = state_36255;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36255__$1,inst_36253);
} else {
if((state_val_36256 === (9))){
var inst_36244 = (state_36255[(9)]);
var state_36255__$1 = state_36255;
var statearr_36265_36296 = state_36255__$1;
(statearr_36265_36296[(2)] = inst_36244);

(statearr_36265_36296[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36256 === (5))){
var inst_36224 = (state_36255[(8)]);
var inst_36236 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_36224);
var inst_36237 = cljs.reader.read_string.call(null,inst_36236);
var inst_36238 = cljs.core.assoc.call(null,inst_36224,new cljs.core.Keyword(null,"where","where",-2044795965),inst_36237);
var state_36255__$1 = state_36255;
var statearr_36266_36297 = state_36255__$1;
(statearr_36266_36297[(2)] = inst_36238);

(statearr_36266_36297[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36256 === (10))){
var inst_36217 = (state_36255[(7)]);
var inst_36244 = (state_36255[(9)]);
var inst_36248 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36249 = cljs.core.deref.call(null,inst_36217);
var inst_36250 = [inst_36244,inst_36249];
var inst_36251 = (new cljs.core.PersistentVector(null,2,(5),inst_36248,inst_36250,null));
var state_36255__$1 = state_36255;
var statearr_36267_36298 = state_36255__$1;
(statearr_36267_36298[(2)] = inst_36251);

(statearr_36267_36298[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36256 === (8))){
var inst_36244 = (state_36255[(9)]);
var inst_36244__$1 = (state_36255[(2)]);
var inst_36245 = fluree.db.util.core.exception_QMARK_.call(null,inst_36244__$1);
var state_36255__$1 = (function (){var statearr_36268 = state_36255;
(statearr_36268[(9)] = inst_36244__$1);

return statearr_36268;
})();
if(inst_36245){
var statearr_36269_36299 = state_36255__$1;
(statearr_36269_36299[(1)] = (9));

} else {
var statearr_36270_36300 = state_36255__$1;
(statearr_36270_36300[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2746__auto____0 = (function (){
var statearr_36271 = [null,null,null,null,null,null,null,null,null,null];
(statearr_36271[(0)] = fluree$db$dbfunctions$internal$state_machine__2746__auto__);

(statearr_36271[(1)] = (1));

return statearr_36271;
});
var fluree$db$dbfunctions$internal$state_machine__2746__auto____1 = (function (state_36255){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_36255);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e36272){var ex__2749__auto__ = e36272;
var statearr_36273_36301 = state_36255;
(statearr_36273_36301[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_36255[(4)]))){
var statearr_36274_36302 = state_36255;
(statearr_36274_36302[(1)] = cljs.core.first.call(null,(state_36255[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36303 = state_36255;
state_36255 = G__36303;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2746__auto__ = function(state_36255){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____1.call(this,state_36255);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_36275 = f__2769__auto__.call(null);
(statearr_36275[(6)] = c__2768__auto__);

return statearr_36275;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.call(null,fluree.db.dbfunctions.internal.str.call(null,"Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace.call(null,pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__36307 = path;
var vec__36308 = G__36307;
var seq__36309 = cljs.core.seq.call(null,vec__36308);
var first__36310 = cljs.core.first.call(null,seq__36309);
var seq__36309__$1 = cljs.core.next.call(null,seq__36309);
var var$ = first__36310;
var r = seq__36309__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__36307__$1 = G__36307;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__36314 = G__36307__$1;
var seq__36315 = cljs.core.seq.call(null,vec__36314);
var first__36316 = cljs.core.first.call(null,seq__36315);
var seq__36315__$1 = cljs.core.next.call(null,seq__36315);
var var$__$1 = first__36316;
var r__$1 = seq__36315__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.call(null,fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_.call(null,r__$1)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null)], null));
var G__36317 = r__$1;
var G__36318 = n__$2;
var G__36319 = next_clauses;
G__36307__$1 = G__36317;
n__$1 = G__36318;
where_clauses__$1 = G__36319;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",next_n),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",next_n)], null));
var G__36320 = r__$1;
var G__36321 = next_n;
var G__36322 = cljs.core.conj.call(null,where_clauses__$2,next_clause);
G__36307__$1 = G__36320;
n__$1 = G__36321;
where_clauses__$1 = G__36322;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,endSubject], null));
return cljs.core.conj.call(null,where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_36359){
var state_val_36360 = (state_36359[(1)]);
if((state_val_36360 === (7))){
var inst_36332 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36333 = [path];
var inst_36334 = (new cljs.core.PersistentVector(null,1,(5),inst_36332,inst_36333,null));
var state_36359__$1 = state_36359;
var statearr_36361_36389 = state_36359__$1;
(statearr_36361_36389[(2)] = inst_36334);

(statearr_36361_36389[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36360 === (1))){
var state_36359__$1 = state_36359;
var statearr_36362_36390 = state_36359__$1;
(statearr_36362_36390[(2)] = null);

(statearr_36362_36390[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36360 === (4))){
var inst_36323 = (state_36359[(2)]);
var state_36359__$1 = state_36359;
var statearr_36363_36391 = state_36359__$1;
(statearr_36363_36391[(2)] = inst_36323);

(statearr_36363_36391[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36360 === (13))){
var inst_36350 = (state_36359[(2)]);
var inst_36351 = fluree.db.util.async.throw_err.call(null,inst_36350);
var _ = (function (){var statearr_36364 = state_36359;
(statearr_36364[(4)] = cljs.core.rest.call(null,(state_36359[(4)])));

return statearr_36364;
})();
var state_36359__$1 = state_36359;
var statearr_36365_36392 = state_36359__$1;
(statearr_36365_36392[(2)] = inst_36351);

(statearr_36365_36392[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36360 === (6))){
var state_36359__$1 = state_36359;
var statearr_36367_36393 = state_36359__$1;
(statearr_36367_36393[(2)] = path);

(statearr_36367_36393[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36360 === (3))){
var inst_36357 = (state_36359[(2)]);
var state_36359__$1 = state_36359;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36359__$1,inst_36357);
} else {
if((state_val_36360 === (12))){
var _ = (function (){var statearr_36368 = state_36359;
(statearr_36368[(4)] = cljs.core.rest.call(null,(state_36359[(4)])));

return statearr_36368;
})();
var state_36359__$1 = state_36359;
var ex36366 = (state_36359__$1[(2)]);
var statearr_36369_36394 = state_36359__$1;
(statearr_36369_36394[(5)] = ex36366);


var statearr_36370_36395 = state_36359__$1;
(statearr_36370_36395[(1)] = (11));

(statearr_36370_36395[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36360 === (2))){
var _ = (function (){var statearr_36371 = state_36359;
(statearr_36371[(4)] = cljs.core.cons.call(null,(5),(state_36359[(4)])));

return statearr_36371;
})();
var inst_36329 = cljs.core.vector_QMARK_.call(null,path);
var state_36359__$1 = state_36359;
if(inst_36329){
var statearr_36372_36396 = state_36359__$1;
(statearr_36372_36396[(1)] = (6));

} else {
var statearr_36373_36397 = state_36359__$1;
(statearr_36373_36397[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36360 === (11))){
var inst_36336 = (state_36359[(7)]);
var inst_36341 = (state_36359[(2)]);
var inst_36342 = fluree.db.dbfunctions.internal.function_error.call(null,inst_36341,"relationship?",startSubject,inst_36336,endSubject);
var state_36359__$1 = state_36359;
var statearr_36375_36398 = state_36359__$1;
(statearr_36375_36398[(2)] = inst_36342);

(statearr_36375_36398[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36360 === (9))){
var inst_36340 = (state_36359[(8)]);
var _ = (function (){var statearr_36376 = state_36359;
(statearr_36376[(4)] = cljs.core.cons.call(null,(12),(state_36359[(4)])));

return statearr_36376;
})();
var inst_36348 = fluree.db.dbfunctions.internal.query.call(null,db,inst_36340);
var state_36359__$1 = state_36359;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36359__$1,(13),inst_36348);
} else {
if((state_val_36360 === (5))){
var _ = (function (){var statearr_36377 = state_36359;
(statearr_36377[(4)] = cljs.core.rest.call(null,(state_36359[(4)])));

return statearr_36377;
})();
var state_36359__$1 = state_36359;
var ex36374 = (state_36359__$1[(2)]);
var statearr_36378_36399 = state_36359__$1;
(statearr_36378_36399[(5)] = ex36374);


if((ex36374 instanceof Error)){
var statearr_36379_36400 = state_36359__$1;
(statearr_36379_36400[(1)] = (4));

(statearr_36379_36400[(5)] = null);

} else {
throw ex36374;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36360 === (10))){
var inst_36354 = (state_36359[(2)]);
var _ = (function (){var statearr_36380 = state_36359;
(statearr_36380[(4)] = cljs.core.rest.call(null,(state_36359[(4)])));

return statearr_36380;
})();
var state_36359__$1 = state_36359;
var statearr_36381_36401 = state_36359__$1;
(statearr_36381_36401[(2)] = inst_36354);

(statearr_36381_36401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36360 === (8))){
var inst_36336 = (state_36359[(7)]);
var inst_36336__$1 = (state_36359[(2)]);
var inst_36337 = fluree.db.dbfunctions.internal.build_where_clause.call(null,startSubject,inst_36336__$1,endSubject);
var inst_36338 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_36339 = ["?var1",inst_36337];
var inst_36340 = cljs.core.PersistentHashMap.fromArrays(inst_36338,inst_36339);
var state_36359__$1 = (function (){var statearr_36382 = state_36359;
(statearr_36382[(7)] = inst_36336__$1);

(statearr_36382[(8)] = inst_36340);

return statearr_36382;
})();
var statearr_36383_36402 = state_36359__$1;
(statearr_36383_36402[(2)] = null);

(statearr_36383_36402[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_36384 = [null,null,null,null,null,null,null,null,null];
(statearr_36384[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__);

(statearr_36384[(1)] = (1));

return statearr_36384;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____1 = (function (state_36359){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_36359);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e36385){var ex__2749__auto__ = e36385;
var statearr_36386_36403 = state_36359;
(statearr_36386_36403[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_36359[(4)]))){
var statearr_36387_36404 = state_36359;
(statearr_36387_36404[(1)] = cljs.core.first.call(null,(state_36359[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36405 = state_36359;
state_36359 = G__36405;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__ = function(state_36359){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____1.call(this,state_36359);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_36388 = f__2769__auto__.call(null);
(statearr_36388[(6)] = c__2768__auto__);

return statearr_36388;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (1);
} else {
return (n + (1));
}
}catch (e36406){var e = e36406;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"inc",n);
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (-1);
} else {
return (n - (1));
}
}catch (e36407){var e = e36407;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"dec",n);
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__5045__auto__ = cljs.core.get.call(null,m,k);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.call(null,m,cljs.core.keyword.call(null,k));
}
}catch (e36408){var e = e36408;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get",m,k);
}});
/**
 * Retrieve's a subject's predicate value by doing a lookup.
 *   If multi returns a vector, else a single value.
 */
fluree.db.dbfunctions.internal.get_subj_pred = (function fluree$db$dbfunctions$internal$get_subj_pred(db,sid,pred){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_36462){
var state_val_36463 = (state_36462[(1)]);
if((state_val_36463 === (7))){
var state_36462__$1 = state_36462;
var statearr_36464_36502 = state_36462__$1;
(statearr_36464_36502[(2)] = pred);

(statearr_36464_36502[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36463 === (20))){
var inst_36445 = (state_36462[(7)]);
var inst_36441 = (state_36462[(8)]);
var inst_36449 = cljs.core.mapv.call(null,inst_36445,inst_36441);
var state_36462__$1 = state_36462;
var statearr_36465_36503 = state_36462__$1;
(statearr_36465_36503[(2)] = inst_36449);

(statearr_36465_36503[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36463 === (1))){
var state_36462__$1 = state_36462;
var statearr_36466_36504 = state_36462__$1;
(statearr_36466_36504[(2)] = null);

(statearr_36466_36504[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36463 === (4))){
var inst_36409 = (state_36462[(2)]);
var state_36462__$1 = state_36462;
var statearr_36467_36505 = state_36462__$1;
(statearr_36467_36505[(2)] = inst_36409);

(statearr_36467_36505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36463 === (15))){
var state_36462__$1 = state_36462;
var statearr_36468_36506 = state_36462__$1;
(statearr_36468_36506[(2)] = fluree.db.flake.o);

(statearr_36468_36506[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36463 === (21))){
var inst_36445 = (state_36462[(7)]);
var inst_36441 = (state_36462[(8)]);
var inst_36451 = cljs.core.first.call(null,inst_36441);
var inst_36452 = inst_36445.call(null,inst_36451);
var state_36462__$1 = state_36462;
var statearr_36469_36507 = state_36462__$1;
(statearr_36469_36507[(2)] = inst_36452);

(statearr_36469_36507[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36463 === (13))){
var inst_36438 = (state_36462[(2)]);
var inst_36439 = fluree.db.util.async.throw_err.call(null,inst_36438);
var state_36462__$1 = state_36462;
var statearr_36470_36508 = state_36462__$1;
(statearr_36470_36508[(2)] = inst_36439);

(statearr_36470_36508[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36463 === (22))){
var inst_36454 = (state_36462[(2)]);
var state_36462__$1 = state_36462;
var statearr_36471_36509 = state_36462__$1;
(statearr_36471_36509[(2)] = inst_36454);

(statearr_36471_36509[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36463 === (6))){
var inst_36419 = clojure.string.replace.call(null,pred,"/_","/");
var state_36462__$1 = state_36462;
var statearr_36472_36510 = state_36462__$1;
(statearr_36472_36510[(2)] = inst_36419);

(statearr_36472_36510[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36463 === (17))){
var inst_36423 = (state_36462[(9)]);
var state_36462__$1 = state_36462;
if(cljs.core.truth_(inst_36423)){
var statearr_36473_36511 = state_36462__$1;
(statearr_36473_36511[(1)] = (20));

} else {
var statearr_36474_36512 = state_36462__$1;
(statearr_36474_36512[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36463 === (3))){
var inst_36460 = (state_36462[(2)]);
var state_36462__$1 = state_36462;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36462__$1,inst_36460);
} else {
if((state_val_36463 === (12))){
var inst_36430 = (state_36462[(2)]);
var inst_36431 = fluree.db.util.async.throw_err.call(null,inst_36430);
var state_36462__$1 = state_36462;
var statearr_36475_36513 = state_36462__$1;
(statearr_36475_36513[(2)] = inst_36431);

(statearr_36475_36513[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36463 === (2))){
var inst_36417 = (state_36462[(10)]);
var _ = (function (){var statearr_36476 = state_36462;
(statearr_36476[(4)] = cljs.core.cons.call(null,(5),(state_36462[(4)])));

return statearr_36476;
})();
var inst_36415 = typeof pred === 'string';
var inst_36416 = cljs.core.re_matches.call(null,/.+\/_.+/,pred);
var inst_36417__$1 = fluree.db.dbfunctions.internal.and.call(null,inst_36415,inst_36416);
var state_36462__$1 = (function (){var statearr_36477 = state_36462;
(statearr_36477[(10)] = inst_36417__$1);

return statearr_36477;
})();
if(cljs.core.truth_(inst_36417__$1)){
var statearr_36478_36514 = state_36462__$1;
(statearr_36478_36514[(1)] = (6));

} else {
var statearr_36479_36515 = state_36462__$1;
(statearr_36479_36515[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36463 === (19))){
var inst_36457 = (state_36462[(2)]);
var _ = (function (){var statearr_36480 = state_36462;
(statearr_36480[(4)] = cljs.core.rest.call(null,(state_36462[(4)])));

return statearr_36480;
})();
var state_36462__$1 = state_36462;
var statearr_36481_36516 = state_36462__$1;
(statearr_36481_36516[(2)] = inst_36457);

(statearr_36481_36516[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36463 === (11))){
var inst_36417 = (state_36462[(10)]);
var inst_36441 = (state_36462[(2)]);
var state_36462__$1 = (function (){var statearr_36483 = state_36462;
(statearr_36483[(8)] = inst_36441);

return statearr_36483;
})();
if(cljs.core.truth_(inst_36417)){
var statearr_36484_36517 = state_36462__$1;
(statearr_36484_36517[(1)] = (14));

} else {
var statearr_36485_36518 = state_36462__$1;
(statearr_36485_36518[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36463 === (9))){
var inst_36422 = (state_36462[(11)]);
var inst_36425 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36426 = [sid,inst_36422];
var inst_36427 = (new cljs.core.PersistentVector(null,2,(5),inst_36425,inst_36426,null));
var inst_36428 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_36427);
var state_36462__$1 = state_36462;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36462__$1,(12),inst_36428);
} else {
if((state_val_36463 === (5))){
var _ = (function (){var statearr_36486 = state_36462;
(statearr_36486[(4)] = cljs.core.rest.call(null,(state_36462[(4)])));

return statearr_36486;
})();
var state_36462__$1 = state_36462;
var ex36482 = (state_36462__$1[(2)]);
var statearr_36487_36519 = state_36462__$1;
(statearr_36487_36519[(5)] = ex36482);


if((ex36482 instanceof Error)){
var statearr_36488_36520 = state_36462__$1;
(statearr_36488_36520[(1)] = (4));

(statearr_36488_36520[(5)] = null);

} else {
throw ex36482;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36463 === (14))){
var state_36462__$1 = state_36462;
var statearr_36489_36521 = state_36462__$1;
(statearr_36489_36521[(2)] = fluree.db.flake.s);

(statearr_36489_36521[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36463 === (16))){
var inst_36441 = (state_36462[(8)]);
var inst_36445 = (state_36462[(2)]);
var inst_36446 = cljs.core.seq.call(null,inst_36441);
var state_36462__$1 = (function (){var statearr_36490 = state_36462;
(statearr_36490[(7)] = inst_36445);

return statearr_36490;
})();
if(inst_36446){
var statearr_36491_36522 = state_36462__$1;
(statearr_36491_36522[(1)] = (17));

} else {
var statearr_36492_36523 = state_36462__$1;
(statearr_36492_36523[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36463 === (10))){
var inst_36422 = (state_36462[(11)]);
var inst_36433 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36434 = [sid,inst_36422];
var inst_36435 = (new cljs.core.PersistentVector(null,2,(5),inst_36433,inst_36434,null));
var inst_36436 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_36435);
var state_36462__$1 = state_36462;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36462__$1,(13),inst_36436);
} else {
if((state_val_36463 === (18))){
var state_36462__$1 = state_36462;
var statearr_36493_36524 = state_36462__$1;
(statearr_36493_36524[(2)] = null);

(statearr_36493_36524[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36463 === (8))){
var inst_36422 = (state_36462[(11)]);
var inst_36417 = (state_36462[(10)]);
var inst_36422__$1 = (state_36462[(2)]);
var inst_36423 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_36422__$1);
var state_36462__$1 = (function (){var statearr_36494 = state_36462;
(statearr_36494[(9)] = inst_36423);

(statearr_36494[(11)] = inst_36422__$1);

return statearr_36494;
})();
if(cljs.core.truth_(inst_36417)){
var statearr_36495_36525 = state_36462__$1;
(statearr_36495_36525[(1)] = (9));

} else {
var statearr_36496_36526 = state_36462__$1;
(statearr_36496_36526[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto____0 = (function (){
var statearr_36497 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36497[(0)] = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto__);

(statearr_36497[(1)] = (1));

return statearr_36497;
});
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto____1 = (function (state_36462){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_36462);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e36498){var ex__2749__auto__ = e36498;
var statearr_36499_36527 = state_36462;
(statearr_36499_36527[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_36462[(4)]))){
var statearr_36500_36528 = state_36462;
(statearr_36500_36528[(1)] = cljs.core.first.call(null,(state_36462[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36529 = state_36462;
state_36462 = G__36529;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto__ = function(state_36462){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto____1.call(this,state_36462);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_36501 = f__2769__auto__.call(null);
(statearr_36501[(6)] = c__2768__auto__);

return statearr_36501;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis.call(null);
}catch (e36530){var e = e36530;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36533 = arguments.length;
var i__5770__auto___36534 = (0);
while(true){
if((i__5770__auto___36534 < len__5769__auto___36533)){
args__5775__auto__.push((arguments[i__5770__auto___36534]));

var G__36535 = (i__5770__auto___36534 + (1));
i__5770__auto___36534 = G__36535;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._PLUS_,args);
}catch (e36532){var e = e36532;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"+",args);
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq36531){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36531));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36538 = arguments.length;
var i__5770__auto___36539 = (0);
while(true){
if((i__5770__auto___36539 < len__5769__auto___36538)){
args__5775__auto__.push((arguments[i__5770__auto___36539]));

var G__36540 = (i__5770__auto___36539 + (1));
i__5770__auto___36539 = G__36540;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._,args);
}catch (e36537){var e = e36537;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"-",args);
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq36536){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36536));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36543 = arguments.length;
var i__5770__auto___36544 = (0);
while(true){
if((i__5770__auto___36544 < len__5769__auto___36543)){
args__5775__auto__.push((arguments[i__5770__auto___36544]));

var G__36545 = (i__5770__auto___36544 + (1));
i__5770__auto___36544 = G__36545;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__5045__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_.call(null,args);
}
})())){
return (1);
} else {
return cljs.core.apply.call(null,cljs.core._STAR_,args);
}
}catch (e36542){var e = e36542;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"*",args);
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq36541){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36541));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36548 = arguments.length;
var i__5770__auto___36549 = (0);
while(true){
if((i__5770__auto___36549 < len__5769__auto___36548)){
args__5775__auto__.push((arguments[i__5770__auto___36549]));

var G__36550 = (i__5770__auto___36549 + (1));
i__5770__auto___36549 = G__36550;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
throw cljs.core.ex_info.call(null,"Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.call(null,cljs.core._SLASH_,args);
}
}catch (e36547){var e = e36547;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"/",args);
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq36546){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36546));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot.call(null,n,d);
}catch (e36551){var e = e36551;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"quot",n,d);
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod.call(null,n,d);
}catch (e36552){var e = e36552;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"mod",n,d);
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem.call(null,n,d);
}catch (e36553){var e = e36553;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rem",n,d);
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e36554){var e = e36554;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"ceil",num);
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e36555){var e = e36555;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"floor",num);
}});
/**
 * Follows a result set down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__36561 = path;
var vec__36562 = G__36561;
var seq__36563 = cljs.core.seq.call(null,vec__36562);
var first__36564 = cljs.core.first.call(null,seq__36563);
var seq__36563__$1 = cljs.core.next.call(null,seq__36563);
var pred = first__36564;
var r = seq__36563__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__36561__$1 = G__36561;
var subjects__$1 = subjects;
while(true){
var vec__36568 = G__36561__$1;
var seq__36569 = cljs.core.seq.call(null,vec__36568);
var first__36570 = cljs.core.first.call(null,seq__36569);
var seq__36569__$1 = cljs.core.next.call(null,seq__36569);
var pred__$1 = first__36570;
var r__$1 = seq__36569__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.call(null,((function (G__36561__$1,subjects__$1,vec__36568,seq__36569,first__36570,seq__36569__$1,pred__$1,r__$1,subjects__$2,G__36561,vec__36562,seq__36563,first__36564,seq__36563__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_.call(null,subject))?cljs.core.mapv.call(null,((function (G__36561__$1,subjects__$1,vec__36568,seq__36569,first__36570,seq__36569__$1,pred__$1,r__$1,subjects__$2,G__36561,vec__36562,seq__36563,first__36564,seq__36563__$1,pred,r,subjects){
return (function (p1__36556_SHARP_){
return fluree.db.dbfunctions.internal.get.call(null,p1__36556_SHARP_,pred__$1);
});})(G__36561__$1,subjects__$1,vec__36568,seq__36569,first__36570,seq__36569__$1,pred__$1,r__$1,subjects__$2,G__36561,vec__36562,seq__36563,first__36564,seq__36563__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get.call(null,subject,pred__$1));
if(((cljs.core.vector_QMARK_.call(null,sub_subjects)) || (cljs.core.set_QMARK_.call(null,sub_subjects)))){
return cljs.core.into.call(null,acc,sub_subjects);
} else {
return cljs.core.conj.call(null,acc,sub_subjects);
}
});})(G__36561__$1,subjects__$1,vec__36568,seq__36569,first__36570,seq__36569__$1,pred__$1,r__$1,subjects__$2,G__36561,vec__36562,seq__36563,first__36564,seq__36563__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__5043__auto__ = r__$1;
if(and__5043__auto__){
return cljs.core.not_empty.call(null,next_subjects);
} else {
return and__5043__auto__;
}
})())){
var G__36571 = r__$1;
var G__36572 = next_subjects;
G__36561__$1 = G__36571;
subjects__$1 = G__36572;
continue;
} else {
return cljs.core.set.call(null,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e36557){var e = e36557;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-all",start_subject,path);
}});
/**
 * Takes a path in a vector format and returns a select statement to crawl those vars.
 *   e.g. convert: ['_user/_auth', 'groupMembership/_user', 'group/_admins']
 *          to: {'_user/_auth' [{'groupMembership/_user' ['group/_admins']}]}
 */
fluree.db.dbfunctions.internal.select_from_path = (function fluree$db$dbfunctions$internal$select_from_path(path){
if(cljs.core._EQ_.call(null,(1),fluree.db.dbfunctions.internal.count.call(null,path))){
return path;
} else {
var r_path = cljs.core.reverse.call(null,path);
return cljs.core.reduce.call(null,(function (acc,p){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([p,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc], null)]);
}),cljs.core.first.call(null,r_path),cljs.core.rest.call(null,r_path));
}
});
/**
 * Follows a subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.follow_subject = (function fluree$db$dbfunctions$internal$follow_subject(_QMARK_ctx,sid,path){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_36612){
var state_val_36613 = (state_36612[(1)]);
if((state_val_36613 === (7))){
var state_36612__$1 = state_36612;
var statearr_36614_36633 = state_36612__$1;
(statearr_36614_36633[(2)] = path);

(statearr_36614_36633[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36613 === (1))){
var state_36612__$1 = state_36612;
var statearr_36615_36634 = state_36612__$1;
(statearr_36615_36634[(2)] = null);

(statearr_36615_36634[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36613 === (4))){
var inst_36573 = (state_36612[(2)]);
var inst_36574 = fluree.db.dbfunctions.internal.function_error.call(null,inst_36573,"get-all",sid,path);
var state_36612__$1 = state_36612;
var statearr_36616_36635 = state_36612__$1;
(statearr_36616_36635[(2)] = inst_36574);

(statearr_36616_36635[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36613 === (6))){
var inst_36591 = (state_36612[(2)]);
var inst_36592 = fluree.db.util.async.throw_err.call(null,inst_36591);
var inst_36593 = cljs.core.nth.call(null,inst_36592,(0),null);
var inst_36594 = cljs.core.nth.call(null,inst_36592,(1),null);
var inst_36595 = cljs.core.last.call(null,path);
var inst_36596 = cljs.core._EQ_.call(null,"_id",inst_36595);
var state_36612__$1 = (function (){var statearr_36617 = state_36612;
(statearr_36617[(7)] = inst_36593);

(statearr_36617[(8)] = inst_36594);

return statearr_36617;
})();
if(inst_36596){
var statearr_36618_36636 = state_36612__$1;
(statearr_36618_36636[(1)] = (7));

} else {
var statearr_36619_36637 = state_36612__$1;
(statearr_36619_36637[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36613 === (3))){
var inst_36610 = (state_36612[(2)]);
var state_36612__$1 = state_36612;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36612__$1,inst_36610);
} else {
if((state_val_36613 === (2))){
var _ = (function (){var statearr_36621 = state_36612;
(statearr_36621[(4)] = cljs.core.cons.call(null,(5),(state_36612[(4)])));

return statearr_36621;
})();
var inst_36583 = fluree.db.dbfunctions.internal.select_from_path.call(null,path);
var inst_36584 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_36585 = cljs.core.PersistentHashMap.EMPTY;
var inst_36586 = [inst_36583,sid,inst_36585];
var inst_36587 = cljs.core.PersistentHashMap.fromArrays(inst_36584,inst_36586);
var inst_36588 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_36589 = fluree.db.dbfunctions.internal.query.call(null,inst_36588,inst_36587);
var state_36612__$1 = state_36612;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36612__$1,(6),inst_36589);
} else {
if((state_val_36613 === (9))){
var inst_36593 = (state_36612[(7)]);
var inst_36594 = (state_36612[(8)]);
var inst_36601 = (state_36612[(2)]);
var inst_36602 = fluree.db.dbfunctions.internal.get_all.call(null,inst_36593,inst_36601);
var inst_36603 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36604 = fluree.db.dbfunctions.internal.count.call(null,path);
var inst_36605 = fluree.db.dbfunctions.internal._PLUS_.call(null,inst_36594,inst_36604,(9));
var inst_36606 = [inst_36602,inst_36605];
var inst_36607 = (new cljs.core.PersistentVector(null,2,(5),inst_36603,inst_36606,null));
var _ = (function (){var statearr_36622 = state_36612;
(statearr_36622[(4)] = cljs.core.rest.call(null,(state_36612[(4)])));

return statearr_36622;
})();
var state_36612__$1 = state_36612;
var statearr_36623_36638 = state_36612__$1;
(statearr_36623_36638[(2)] = inst_36607);

(statearr_36623_36638[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36613 === (5))){
var _ = (function (){var statearr_36624 = state_36612;
(statearr_36624[(4)] = cljs.core.rest.call(null,(state_36612[(4)])));

return statearr_36624;
})();
var state_36612__$1 = state_36612;
var ex36620 = (state_36612__$1[(2)]);
var statearr_36625_36639 = state_36612__$1;
(statearr_36625_36639[(5)] = ex36620);


var statearr_36626_36640 = state_36612__$1;
(statearr_36626_36640[(1)] = (4));

(statearr_36626_36640[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36613 === (8))){
var inst_36599 = cljs.core.conj.call(null,path,"_id");
var state_36612__$1 = state_36612;
var statearr_36627_36641 = state_36612__$1;
(statearr_36627_36641[(2)] = inst_36599);

(statearr_36627_36641[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto____0 = (function (){
var statearr_36628 = [null,null,null,null,null,null,null,null,null];
(statearr_36628[(0)] = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto__);

(statearr_36628[(1)] = (1));

return statearr_36628;
});
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto____1 = (function (state_36612){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_36612);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e36629){var ex__2749__auto__ = e36629;
var statearr_36630_36642 = state_36612;
(statearr_36630_36642[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_36612[(4)]))){
var statearr_36631_36643 = state_36612;
(statearr_36631_36643[(1)] = cljs.core.first.call(null,(state_36612[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36644 = state_36612;
state_36612 = G__36644;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto__ = function(state_36612){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto____1.call(this,state_36612);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_36632 = f__2769__auto__.call(null);
(statearr_36632[(6)] = c__2768__auto__);

return statearr_36632;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all.call(null,m,ks);
}catch (e36645){var e = e36645;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-in",m,ks);
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{if(cljs.core.sequential_QMARK_.call(null,key)){
return cljs.core.some.call(null,(function (p1__36646_SHARP_){
return fluree.db.dbfunctions.internal.contains_QMARK_.call(null,coll,p1__36646_SHARP_);
}),key);
} else {
return cljs.core.contains_QMARK_.call(null,coll,key);
}
}catch (e36647){var e = e36647;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"contains?",coll,key);
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36650 = arguments.length;
var i__5770__auto___36651 = (0);
while(true){
if((i__5770__auto___36651 < len__5769__auto___36650)){
args__5775__auto__.push((arguments[i__5770__auto___36651]));

var G__36652 = (i__5770__auto___36651 + (1));
i__5770__auto___36651 = G__36652;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.hash_set,args);
}catch (e36649){var e = e36649;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"hash-set",args);
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq36648){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36648));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_.call(null,coll))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.call(null,coll_SINGLEQUOTE_,key);
}catch (e36653){var e = e36653;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nth",coll,key);
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___36656 = arguments.length;
var i__5770__auto___36657 = (0);
while(true){
if((i__5770__auto___36657 < len__5769__auto___36656)){
args__5775__auto__.push((arguments[i__5770__auto___36657]));

var G__36658 = (i__5770__auto___36657 + (1));
i__5770__auto___36657 = G__36658;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._EQ_,args);
}catch (e36655){var e = e36655;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"==",args);
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq36654){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36654));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,pattern),string);
}catch (e36659){var e = e36659;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"re-find",pattern,string);
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_36716){
var state_val_36717 = (state_36716[(1)]);
if((state_val_36717 === (7))){
var inst_36662 = (state_36716[(2)]);
var state_36716__$1 = state_36716;
var statearr_36718_36752 = state_36716__$1;
(statearr_36718_36752[(2)] = inst_36662);

(statearr_36718_36752[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36717 === (1))){
var state_36716__$1 = state_36716;
var statearr_36719_36753 = state_36716__$1;
(statearr_36719_36753[(2)] = null);

(statearr_36719_36753[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36717 === (4))){
var inst_36661 = (state_36716[(2)]);
var state_36716__$1 = (function (){var statearr_36720 = state_36716;
(statearr_36720[(7)] = inst_36661);

return statearr_36720;
})();
var statearr_36721_36754 = state_36716__$1;
(statearr_36721_36754[(2)] = null);

(statearr_36721_36754[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36717 === (15))){
var inst_36684 = (state_36716[(8)]);
var inst_36697 = (state_36716[(9)]);
var inst_36686 = (state_36716[(10)]);
var inst_36699 = (state_36716[(11)]);
var inst_36687 = (state_36716[(12)]);
var inst_36696 = (state_36716[(13)]);
var inst_36703 = (function (){var db = inst_36684;
var prevT = inst_36686;
var db_SINGLEQUOTE_ = inst_36687;
var prev_vals = inst_36696;
var fuel = inst_36697;
var G__36698 = inst_36699;
return (function (p1__36660_SHARP_){
var f = p1__36660_SHARP_;
return fluree.db.flake.o.call(null,f);
});
})();
var inst_36704 = inst_36703.call(null,inst_36699);
var state_36716__$1 = state_36716;
var statearr_36722_36755 = state_36716__$1;
(statearr_36722_36755[(2)] = inst_36704);

(statearr_36722_36755[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36717 === (13))){
var inst_36699 = (state_36716[(11)]);
var inst_36696 = (state_36716[(13)]);
var inst_36695 = (state_36716[(2)]);
var inst_36696__$1 = fluree.db.util.async.throw_err.call(null,inst_36695);
var inst_36697 = fluree.db.dbfunctions.internal.count.call(null,inst_36696__$1);
var inst_36699__$1 = cljs.core.first.call(null,inst_36696__$1);
var inst_36700 = (inst_36699__$1 == null);
var state_36716__$1 = (function (){var statearr_36723 = state_36716;
(statearr_36723[(9)] = inst_36697);

(statearr_36723[(11)] = inst_36699__$1);

(statearr_36723[(13)] = inst_36696__$1);

return statearr_36723;
})();
if(cljs.core.truth_(inst_36700)){
var statearr_36724_36756 = state_36716__$1;
(statearr_36724_36756[(1)] = (14));

} else {
var statearr_36725_36757 = state_36716__$1;
(statearr_36725_36757[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36717 === (6))){
var inst_36671 = (state_36716[(2)]);
var state_36716__$1 = state_36716;
var statearr_36726_36758 = state_36716__$1;
(statearr_36726_36758[(2)] = inst_36671);

(statearr_36726_36758[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36717 === (3))){
var inst_36714 = (state_36716[(2)]);
var state_36716__$1 = state_36716;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36716__$1,inst_36714);
} else {
if((state_val_36717 === (12))){
var inst_36711 = (state_36716[(2)]);
var _ = (function (){var statearr_36727 = state_36716;
(statearr_36727[(4)] = cljs.core.rest.call(null,(state_36716[(4)])));

return statearr_36727;
})();
var state_36716__$1 = state_36716;
var statearr_36728_36759 = state_36716__$1;
(statearr_36728_36759[(2)] = inst_36711);

(statearr_36728_36759[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36717 === (2))){
var _ = (function (){var statearr_36730 = state_36716;
(statearr_36730[(4)] = cljs.core.cons.call(null,(9),(state_36716[(4)])));

return statearr_36730;
})();
var inst_36677 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_36678 = typeof inst_36677 === 'string';
var state_36716__$1 = state_36716;
if(cljs.core.truth_(inst_36678)){
var statearr_36731_36760 = state_36716__$1;
(statearr_36731_36760[(1)] = (10));

} else {
var statearr_36732_36761 = state_36716__$1;
(statearr_36732_36761[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36717 === (11))){
var inst_36684 = (state_36716[(8)]);
var inst_36686 = (state_36716[(10)]);
var inst_36687 = (state_36716[(12)]);
var inst_36684__$1 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_36685 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_36684__$1);
var inst_36686__$1 = fluree.db.dbfunctions.internal.inc.call(null,inst_36685);
var inst_36687__$1 = cljs.core.assoc.call(null,inst_36684__$1,new cljs.core.Keyword(null,"t","t",-1397832519),inst_36686__$1);
var inst_36688 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36689 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_36690 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_36691 = [inst_36689,inst_36690];
var inst_36692 = (new cljs.core.PersistentVector(null,2,(5),inst_36688,inst_36691,null));
var inst_36693 = fluree.db.dbproto._search.call(null,inst_36687__$1,inst_36692);
var state_36716__$1 = (function (){var statearr_36733 = state_36716;
(statearr_36733[(8)] = inst_36684__$1);

(statearr_36733[(10)] = inst_36686__$1);

(statearr_36733[(12)] = inst_36687__$1);

return statearr_36733;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36716__$1,(13),inst_36693);
} else {
if((state_val_36717 === (9))){
var _ = (function (){var statearr_36734 = state_36716;
(statearr_36734[(4)] = cljs.core.rest.call(null,(state_36716[(4)])));

return statearr_36734;
})();
var state_36716__$1 = state_36716;
var ex36729 = (state_36716__$1[(2)]);
var statearr_36735_36762 = state_36716__$1;
(statearr_36735_36762[(5)] = ex36729);


var statearr_36736_36763 = state_36716__$1;
(statearr_36736_36763[(1)] = (4));

(statearr_36736_36763[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36717 === (5))){
var inst_36661 = (state_36716[(7)]);
var _ = (function (){var statearr_36737 = state_36716;
(statearr_36737[(4)] = cljs.core.cons.call(null,(8),(state_36716[(4)])));

return statearr_36737;
})();
var inst_36668 = fluree.db.dbfunctions.internal.function_error.call(null,inst_36661,"?pO","Context Object");
var ___$1 = (function (){var statearr_36738 = state_36716;
(statearr_36738[(4)] = cljs.core.rest.call(null,(state_36716[(4)])));

return statearr_36738;
})();
var state_36716__$1 = state_36716;
var statearr_36739_36764 = state_36716__$1;
(statearr_36739_36764[(2)] = inst_36668);

(statearr_36739_36764[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36717 === (14))){
var state_36716__$1 = state_36716;
var statearr_36740_36765 = state_36716__$1;
(statearr_36740_36765[(2)] = null);

(statearr_36740_36765[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36717 === (16))){
var inst_36697 = (state_36716[(9)]);
var inst_36706 = (state_36716[(2)]);
var inst_36707 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36708 = [inst_36706,inst_36697];
var inst_36709 = (new cljs.core.PersistentVector(null,2,(5),inst_36707,inst_36708,null));
var state_36716__$1 = state_36716;
var statearr_36742_36766 = state_36716__$1;
(statearr_36742_36766[(2)] = inst_36709);

(statearr_36742_36766[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36717 === (10))){
var inst_36680 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36681 = [null,(0)];
var inst_36682 = (new cljs.core.PersistentVector(null,2,(5),inst_36680,inst_36681,null));
var state_36716__$1 = state_36716;
var statearr_36743_36767 = state_36716__$1;
(statearr_36743_36767[(2)] = inst_36682);

(statearr_36743_36767[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36717 === (8))){
var _ = (function (){var statearr_36744 = state_36716;
(statearr_36744[(4)] = cljs.core.rest.call(null,(state_36716[(4)])));

return statearr_36744;
})();
var state_36716__$1 = state_36716;
var ex36741 = (state_36716__$1[(2)]);
var statearr_36745_36768 = state_36716__$1;
(statearr_36745_36768[(5)] = ex36741);


var statearr_36746_36769 = state_36716__$1;
(statearr_36746_36769[(1)] = (7));

(statearr_36746_36769[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____0 = (function (){
var statearr_36747 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36747[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__);

(statearr_36747[(1)] = (1));

return statearr_36747;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____1 = (function (state_36716){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_36716);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e36748){var ex__2749__auto__ = e36748;
var statearr_36749_36770 = state_36716;
(statearr_36749_36770[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_36716[(4)]))){
var statearr_36750_36771 = state_36716;
(statearr_36750_36771[(1)] = cljs.core.first.call(null,(state_36716[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36772 = state_36716;
state_36716 = G__36772;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__ = function(state_36716){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____1.call(this,state_36716);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_36751 = f__2769__auto__.call(null);
(statearr_36751[(6)] = c__2768__auto__);

return statearr_36751;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_36824){
var state_val_36825 = (state_36824[(1)]);
if((state_val_36825 === (7))){
var inst_36774 = (state_36824[(2)]);
var state_36824__$1 = state_36824;
var statearr_36826_36855 = state_36824__$1;
(statearr_36826_36855[(2)] = inst_36774);

(statearr_36826_36855[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36825 === (1))){
var state_36824__$1 = state_36824;
var statearr_36827_36856 = state_36824__$1;
(statearr_36827_36856[(2)] = null);

(statearr_36827_36856[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36825 === (4))){
var inst_36773 = (state_36824[(2)]);
var state_36824__$1 = (function (){var statearr_36828 = state_36824;
(statearr_36828[(7)] = inst_36773);

return statearr_36828;
})();
var statearr_36829_36857 = state_36824__$1;
(statearr_36829_36857[(2)] = null);

(statearr_36829_36857[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36825 === (13))){
var inst_36819 = (state_36824[(2)]);
var _ = (function (){var statearr_36830 = state_36824;
(statearr_36830[(4)] = cljs.core.rest.call(null,(state_36824[(4)])));

return statearr_36830;
})();
var state_36824__$1 = state_36824;
var statearr_36831_36858 = state_36824__$1;
(statearr_36831_36858[(2)] = inst_36819);

(statearr_36831_36858[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36825 === (6))){
var inst_36783 = (state_36824[(2)]);
var state_36824__$1 = state_36824;
var statearr_36832_36859 = state_36824__$1;
(statearr_36832_36859[(2)] = inst_36783);

(statearr_36832_36859[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36825 === (3))){
var inst_36822 = (state_36824[(2)]);
var state_36824__$1 = state_36824;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36824__$1,inst_36822);
} else {
if((state_val_36825 === (12))){
var inst_36806 = (state_36824[(8)]);
var inst_36815 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36816 = [null,inst_36806];
var inst_36817 = (new cljs.core.PersistentVector(null,2,(5),inst_36815,inst_36816,null));
var state_36824__$1 = state_36824;
var statearr_36833_36860 = state_36824__$1;
(statearr_36833_36860[(2)] = inst_36817);

(statearr_36833_36860[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36825 === (2))){
var _ = (function (){var statearr_36835 = state_36824;
(statearr_36835[(4)] = cljs.core.cons.call(null,(9),(state_36824[(4)])));

return statearr_36835;
})();
var inst_36792 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_36793 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36794 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36795 = [null,pred_name,"?o"];
var inst_36796 = (new cljs.core.PersistentVector(null,3,(5),inst_36794,inst_36795,null));
var inst_36797 = [inst_36796];
var inst_36798 = (new cljs.core.PersistentVector(null,1,(5),inst_36793,inst_36797,null));
var inst_36799 = ["?o",inst_36798,opts];
var inst_36800 = cljs.core.PersistentHashMap.fromArrays(inst_36792,inst_36799);
var inst_36801 = fluree.db.dbfunctions.internal.query.call(null,db,inst_36800);
var state_36824__$1 = state_36824;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36824__$1,(10),inst_36801);
} else {
if((state_val_36825 === (11))){
var inst_36805 = (state_36824[(9)]);
var inst_36806 = (state_36824[(8)]);
var inst_36810 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36811 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_36805);
var inst_36812 = [inst_36811,inst_36806];
var inst_36813 = (new cljs.core.PersistentVector(null,2,(5),inst_36810,inst_36812,null));
var state_36824__$1 = state_36824;
var statearr_36836_36861 = state_36824__$1;
(statearr_36836_36861[(2)] = inst_36813);

(statearr_36836_36861[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36825 === (9))){
var _ = (function (){var statearr_36837 = state_36824;
(statearr_36837[(4)] = cljs.core.rest.call(null,(state_36824[(4)])));

return statearr_36837;
})();
var state_36824__$1 = state_36824;
var ex36834 = (state_36824__$1[(2)]);
var statearr_36838_36862 = state_36824__$1;
(statearr_36838_36862[(5)] = ex36834);


var statearr_36839_36863 = state_36824__$1;
(statearr_36839_36863[(1)] = (4));

(statearr_36839_36863[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36825 === (5))){
var inst_36773 = (state_36824[(7)]);
var _ = (function (){var statearr_36841 = state_36824;
(statearr_36841[(4)] = cljs.core.cons.call(null,(8),(state_36824[(4)])));

return statearr_36841;
})();
var inst_36780 = fluree.db.dbfunctions.internal.function_error.call(null,inst_36773,"max-pred-val",pred_name);
var ___$1 = (function (){var statearr_36842 = state_36824;
(statearr_36842[(4)] = cljs.core.rest.call(null,(state_36824[(4)])));

return statearr_36842;
})();
var state_36824__$1 = state_36824;
var statearr_36843_36864 = state_36824__$1;
(statearr_36843_36864[(2)] = inst_36780);

(statearr_36843_36864[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36825 === (10))){
var inst_36805 = (state_36824[(9)]);
var inst_36803 = (state_36824[(2)]);
var inst_36804 = fluree.db.util.async.throw_err.call(null,inst_36803);
var inst_36805__$1 = cljs.core.nth.call(null,inst_36804,(0),null);
var inst_36806 = cljs.core.nth.call(null,inst_36804,(1),null);
var inst_36807 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_36805__$1);
var inst_36808 = cljs.core.not.call(null,inst_36807);
var state_36824__$1 = (function (){var statearr_36844 = state_36824;
(statearr_36844[(9)] = inst_36805__$1);

(statearr_36844[(8)] = inst_36806);

return statearr_36844;
})();
if(inst_36808){
var statearr_36845_36865 = state_36824__$1;
(statearr_36845_36865[(1)] = (11));

} else {
var statearr_36846_36866 = state_36824__$1;
(statearr_36846_36866[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36825 === (8))){
var _ = (function (){var statearr_36847 = state_36824;
(statearr_36847[(4)] = cljs.core.rest.call(null,(state_36824[(4)])));

return statearr_36847;
})();
var state_36824__$1 = state_36824;
var ex36840 = (state_36824__$1[(2)]);
var statearr_36848_36867 = state_36824__$1;
(statearr_36848_36867[(5)] = ex36840);


var statearr_36849_36868 = state_36824__$1;
(statearr_36849_36868[(1)] = (7));

(statearr_36849_36868[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____0 = (function (){
var statearr_36850 = [null,null,null,null,null,null,null,null,null,null];
(statearr_36850[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__);

(statearr_36850[(1)] = (1));

return statearr_36850;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____1 = (function (state_36824){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_36824);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e36851){var ex__2749__auto__ = e36851;
var statearr_36852_36869 = state_36824;
(statearr_36852_36869[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_36824[(4)]))){
var statearr_36853_36870 = state_36824;
(statearr_36853_36870[(1)] = cljs.core.first.call(null,(state_36824[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36871 = state_36824;
state_36824 = G__36871;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__ = function(state_36824){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____1.call(this,state_36824);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_36854 = f__2769__auto__.call(null);
(statearr_36854[(6)] = c__2768__auto__);

return statearr_36854;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$.call(null,(function (){var and__5043__auto__ = typeof email === 'string';
if(and__5043__auto__){
return cljs.core.re_matches.call(null,pattern,email);
} else {
return and__5043__auto__;
}
})());
}catch (e36872){var e = e36872;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"valid-email?",email);
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__36874 = arguments.length;
switch (G__36874) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_36944){
var state_val_36945 = (state_36944[(1)]);
if((state_val_36945 === (7))){
var inst_36876 = (state_36944[(2)]);
var state_36944__$1 = state_36944;
var statearr_36946_36990 = state_36944__$1;
(statearr_36946_36990[(2)] = inst_36876);

(statearr_36946_36990[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36945 === (20))){
var inst_36920 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36921 = ["*"];
var inst_36922 = (new cljs.core.PersistentVector(null,1,(5),inst_36920,inst_36921,null));
var state_36944__$1 = state_36944;
var statearr_36947_36991 = state_36944__$1;
(statearr_36947_36991[(2)] = inst_36922);

(statearr_36947_36991[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36945 === (1))){
var state_36944__$1 = state_36944;
var statearr_36948_36992 = state_36944__$1;
(statearr_36948_36992[(2)] = null);

(statearr_36948_36992[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36945 === (4))){
var inst_36875 = (state_36944[(2)]);
var state_36944__$1 = (function (){var statearr_36949 = state_36944;
(statearr_36949[(7)] = inst_36875);

return statearr_36949;
})();
var statearr_36950_36993 = state_36944__$1;
(statearr_36950_36993[(2)] = null);

(statearr_36950_36993[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36945 === (15))){
var inst_36939 = (state_36944[(2)]);
var _ = (function (){var statearr_36951 = state_36944;
(statearr_36951[(4)] = cljs.core.rest.call(null,(state_36944[(4)])));

return statearr_36951;
})();
var state_36944__$1 = state_36944;
var statearr_36952_36994 = state_36944__$1;
(statearr_36952_36994[(2)] = inst_36939);

(statearr_36952_36994[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36945 === (21))){
var inst_36910 = (state_36944[(8)]);
var inst_36903 = (state_36944[(9)]);
var inst_36924 = (state_36944[(2)]);
var inst_36925 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_36926 = cljs.core.PersistentHashMap.EMPTY;
var inst_36927 = [inst_36924,inst_36910,inst_36926];
var inst_36928 = cljs.core.PersistentHashMap.fromArrays(inst_36925,inst_36927);
var inst_36929 = fluree.db.dbfunctions.internal.query.call(null,inst_36903,inst_36928);
var state_36944__$1 = state_36944;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36944__$1,(22),inst_36929);
} else {
if((state_val_36945 === (13))){
var inst_36898 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_36944__$1 = state_36944;
var statearr_36953_36995 = state_36944__$1;
(statearr_36953_36995[(2)] = inst_36898);

(statearr_36953_36995[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36945 === (22))){
var inst_36931 = (state_36944[(2)]);
var inst_36932 = fluree.db.util.async.throw_err.call(null,inst_36931);
var inst_36933 = cljs.core.nth.call(null,inst_36932,(0),null);
var inst_36934 = cljs.core.nth.call(null,inst_36932,(1),null);
var inst_36935 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36936 = [inst_36933,inst_36934];
var inst_36937 = (new cljs.core.PersistentVector(null,2,(5),inst_36935,inst_36936,null));
var state_36944__$1 = state_36944;
var statearr_36954_36996 = state_36944__$1;
(statearr_36954_36996[(2)] = inst_36937);

(statearr_36954_36996[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36945 === (6))){
var inst_36885 = (state_36944[(2)]);
var state_36944__$1 = state_36944;
var statearr_36955_36997 = state_36944__$1;
(statearr_36955_36997[(2)] = inst_36885);

(statearr_36955_36997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36945 === (17))){
var inst_36907 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_36908 = fluree.db.dbfunctions.internal.get.call(null,inst_36907,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_36944__$1 = state_36944;
var statearr_36956_36998 = state_36944__$1;
(statearr_36956_36998[(2)] = inst_36908);

(statearr_36956_36998[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36945 === (3))){
var inst_36942 = (state_36944[(2)]);
var state_36944__$1 = state_36944;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36944__$1,inst_36942);
} else {
if((state_val_36945 === (12))){
var inst_36896 = (state_36944[(2)]);
var state_36944__$1 = state_36944;
if(cljs.core.truth_(inst_36896)){
var statearr_36957_36999 = state_36944__$1;
(statearr_36957_36999[(1)] = (13));

} else {
var statearr_36958_37000 = state_36944__$1;
(statearr_36958_37000[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36945 === (2))){
var inst_36891 = (state_36944[(10)]);
var _ = (function (){var statearr_36959 = state_36944;
(statearr_36959[(4)] = cljs.core.cons.call(null,(9),(state_36944[(4)])));

return statearr_36959;
})();
var inst_36891__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_36944__$1 = (function (){var statearr_36960 = state_36944;
(statearr_36960[(10)] = inst_36891__$1);

return statearr_36960;
})();
if(cljs.core.truth_(inst_36891__$1)){
var statearr_36961_37001 = state_36944__$1;
(statearr_36961_37001[(1)] = (10));

} else {
var statearr_36962_37002 = state_36944__$1;
(statearr_36962_37002[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36945 === (19))){
var inst_36912 = cljs.core.PersistentVector.EMPTY;
var inst_36913 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36914 = ["*"];
var inst_36915 = (new cljs.core.PersistentVector(null,1,(5),inst_36913,inst_36914,null));
var inst_36916 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_36917 = cljs.core.concat.call(null,inst_36915,inst_36916);
var inst_36918 = cljs.core.into.call(null,inst_36912,inst_36917);
var state_36944__$1 = state_36944;
var statearr_36964_37003 = state_36944__$1;
(statearr_36964_37003[(2)] = inst_36918);

(statearr_36964_37003[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36945 === (11))){
var inst_36891 = (state_36944[(10)]);
var state_36944__$1 = state_36944;
var statearr_36965_37004 = state_36944__$1;
(statearr_36965_37004[(2)] = inst_36891);

(statearr_36965_37004[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36945 === (9))){
var _ = (function (){var statearr_36966 = state_36944;
(statearr_36966[(4)] = cljs.core.rest.call(null,(state_36944[(4)])));

return statearr_36966;
})();
var state_36944__$1 = state_36944;
var ex36963 = (state_36944__$1[(2)]);
var statearr_36967_37005 = state_36944__$1;
(statearr_36967_37005[(5)] = ex36963);


var statearr_36968_37006 = state_36944__$1;
(statearr_36968_37006[(1)] = (4));

(statearr_36968_37006[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36945 === (5))){
var inst_36875 = (state_36944[(7)]);
var _ = (function (){var statearr_36969 = state_36944;
(statearr_36969[(4)] = cljs.core.cons.call(null,(8),(state_36944[(4)])));

return statearr_36969;
})();
var inst_36882 = fluree.db.dbfunctions.internal.function_error.call(null,inst_36875,"?s","Context Object",additional_params);
var ___$1 = (function (){var statearr_36970 = state_36944;
(statearr_36970[(4)] = cljs.core.rest.call(null,(state_36944[(4)])));

return statearr_36970;
})();
var state_36944__$1 = state_36944;
var statearr_36971_37007 = state_36944__$1;
(statearr_36971_37007[(2)] = inst_36882);

(statearr_36971_37007[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36945 === (14))){
var inst_36904 = (state_36944[(11)]);
var inst_36903 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_36904__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_36944__$1 = (function (){var statearr_36972 = state_36944;
(statearr_36972[(11)] = inst_36904__$1);

(statearr_36972[(9)] = inst_36903);

return statearr_36972;
})();
if(cljs.core.truth_(inst_36904__$1)){
var statearr_36973_37008 = state_36944__$1;
(statearr_36973_37008[(1)] = (16));

} else {
var statearr_36974_37009 = state_36944__$1;
(statearr_36974_37009[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36945 === (16))){
var inst_36904 = (state_36944[(11)]);
var state_36944__$1 = state_36944;
var statearr_36975_37010 = state_36944__$1;
(statearr_36975_37010[(2)] = inst_36904);

(statearr_36975_37010[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36945 === (10))){
var inst_36893 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,additional_params);
var state_36944__$1 = state_36944;
var statearr_36977_37011 = state_36944__$1;
(statearr_36977_37011[(2)] = inst_36893);

(statearr_36977_37011[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36945 === (18))){
var inst_36910 = (state_36944[(2)]);
var state_36944__$1 = (function (){var statearr_36978 = state_36944;
(statearr_36978[(8)] = inst_36910);

return statearr_36978;
})();
if(cljs.core.truth_(additional_params)){
var statearr_36979_37012 = state_36944__$1;
(statearr_36979_37012[(1)] = (19));

} else {
var statearr_36980_37013 = state_36944__$1;
(statearr_36980_37013[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36945 === (8))){
var _ = (function (){var statearr_36981 = state_36944;
(statearr_36981[(4)] = cljs.core.rest.call(null,(state_36944[(4)])));

return statearr_36981;
})();
var state_36944__$1 = state_36944;
var ex36976 = (state_36944__$1[(2)]);
var statearr_36982_37014 = state_36944__$1;
(statearr_36982_37014[(5)] = ex36976);


var statearr_36983_37015 = state_36944__$1;
(statearr_36983_37015[(1)] = (7));

(statearr_36983_37015[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2746__auto____0 = (function (){
var statearr_36984 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36984[(0)] = fluree$db$dbfunctions$internal$state_machine__2746__auto__);

(statearr_36984[(1)] = (1));

return statearr_36984;
});
var fluree$db$dbfunctions$internal$state_machine__2746__auto____1 = (function (state_36944){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_36944);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e36985){var ex__2749__auto__ = e36985;
var statearr_36986_37016 = state_36944;
(statearr_36986_37016[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_36944[(4)]))){
var statearr_36987_37017 = state_36944;
(statearr_36987_37017[(1)] = cljs.core.first.call(null,(state_36944[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37018 = state_36944;
state_36944 = G__37018;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2746__auto__ = function(state_36944){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____1.call(this,state_36944);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_36988 = f__2769__auto__.call(null);
(statearr_36988[(6)] = c__2768__auto__);

return statearr_36988;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__37020 = arguments.length;
switch (G__37020) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_37064){
var state_val_37065 = (state_37064[(1)]);
if((state_val_37065 === (7))){
var inst_37042 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37043 = ["*"];
var inst_37044 = (new cljs.core.PersistentVector(null,1,(5),inst_37042,inst_37043,null));
var state_37064__$1 = state_37064;
var statearr_37066_37086 = state_37064__$1;
(statearr_37066_37086[(2)] = inst_37044);

(statearr_37066_37086[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37065 === (1))){
var state_37064__$1 = state_37064;
var statearr_37067_37087 = state_37064__$1;
(statearr_37067_37087[(2)] = null);

(statearr_37067_37087[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37065 === (4))){
var inst_37021 = (state_37064[(2)]);
var inst_37022 = fluree.db.dbfunctions.internal.function_error.call(null,inst_37021,"?p","Context Object",additional_params);
var state_37064__$1 = state_37064;
var statearr_37068_37088 = state_37064__$1;
(statearr_37068_37088[(2)] = inst_37022);

(statearr_37068_37088[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37065 === (6))){
var inst_37034 = cljs.core.PersistentVector.EMPTY;
var inst_37035 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37036 = ["*"];
var inst_37037 = (new cljs.core.PersistentVector(null,1,(5),inst_37035,inst_37036,null));
var inst_37038 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_37039 = cljs.core.concat.call(null,inst_37037,inst_37038);
var inst_37040 = cljs.core.into.call(null,inst_37034,inst_37039);
var state_37064__$1 = state_37064;
var statearr_37069_37089 = state_37064__$1;
(statearr_37069_37089[(2)] = inst_37040);

(statearr_37069_37089[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37065 === (3))){
var inst_37062 = (state_37064[(2)]);
var state_37064__$1 = state_37064;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37064__$1,inst_37062);
} else {
if((state_val_37065 === (2))){
var _ = (function (){var statearr_37071 = state_37064;
(statearr_37071[(4)] = cljs.core.cons.call(null,(5),(state_37064[(4)])));

return statearr_37071;
})();
var inst_37031 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_37032 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_37064__$1 = (function (){var statearr_37072 = state_37064;
(statearr_37072[(7)] = inst_37032);

(statearr_37072[(8)] = inst_37031);

return statearr_37072;
})();
if(cljs.core.truth_(additional_params)){
var statearr_37073_37090 = state_37064__$1;
(statearr_37073_37090[(1)] = (6));

} else {
var statearr_37074_37091 = state_37064__$1;
(statearr_37074_37091[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37065 === (9))){
var inst_37053 = (state_37064[(2)]);
var inst_37054 = fluree.db.util.async.throw_err.call(null,inst_37053);
var inst_37055 = cljs.core.nth.call(null,inst_37054,(0),null);
var inst_37056 = cljs.core.nth.call(null,inst_37054,(1),null);
var inst_37057 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37058 = [inst_37055,inst_37056];
var inst_37059 = (new cljs.core.PersistentVector(null,2,(5),inst_37057,inst_37058,null));
var _ = (function (){var statearr_37075 = state_37064;
(statearr_37075[(4)] = cljs.core.rest.call(null,(state_37064[(4)])));

return statearr_37075;
})();
var state_37064__$1 = state_37064;
var statearr_37076_37092 = state_37064__$1;
(statearr_37076_37092[(2)] = inst_37059);

(statearr_37076_37092[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37065 === (5))){
var _ = (function (){var statearr_37077 = state_37064;
(statearr_37077[(4)] = cljs.core.rest.call(null,(state_37064[(4)])));

return statearr_37077;
})();
var state_37064__$1 = state_37064;
var ex37070 = (state_37064__$1[(2)]);
var statearr_37078_37093 = state_37064__$1;
(statearr_37078_37093[(5)] = ex37070);


var statearr_37079_37094 = state_37064__$1;
(statearr_37079_37094[(1)] = (4));

(statearr_37079_37094[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37065 === (8))){
var inst_37032 = (state_37064[(7)]);
var inst_37031 = (state_37064[(8)]);
var inst_37046 = (state_37064[(2)]);
var inst_37047 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_37048 = cljs.core.PersistentHashMap.EMPTY;
var inst_37049 = [inst_37046,inst_37032,inst_37048];
var inst_37050 = cljs.core.PersistentHashMap.fromArrays(inst_37047,inst_37049);
var inst_37051 = fluree.db.dbfunctions.internal.query.call(null,inst_37031,inst_37050);
var state_37064__$1 = state_37064;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37064__$1,(9),inst_37051);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2746__auto____0 = (function (){
var statearr_37080 = [null,null,null,null,null,null,null,null,null];
(statearr_37080[(0)] = fluree$db$dbfunctions$internal$state_machine__2746__auto__);

(statearr_37080[(1)] = (1));

return statearr_37080;
});
var fluree$db$dbfunctions$internal$state_machine__2746__auto____1 = (function (state_37064){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_37064);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e37081){var ex__2749__auto__ = e37081;
var statearr_37082_37095 = state_37064;
(statearr_37082_37095[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_37064[(4)]))){
var statearr_37083_37096 = state_37064;
(statearr_37083_37096[(1)] = cljs.core.first.call(null,(state_37064[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37097 = state_37064;
state_37064 = G__37097;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2746__auto__ = function(state_37064){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____1.call(this,state_37064);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_37084 = f__2769__auto__.call(null);
(statearr_37084[(6)] = c__2768__auto__);

return statearr_37084;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_37141){
var state_val_37142 = (state_37141[(1)]);
if((state_val_37142 === (1))){
var state_37141__$1 = state_37141;
var statearr_37143_37157 = state_37141__$1;
(statearr_37143_37157[(2)] = null);

(statearr_37143_37157[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37142 === (2))){
var _ = (function (){var statearr_37144 = state_37141;
(statearr_37144[(4)] = cljs.core.cons.call(null,(5),(state_37141[(4)])));

return statearr_37144;
})();
var inst_37108 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_37109 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37110 = ["_user/_auth"];
var inst_37111 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37112 = ["*"];
var inst_37113 = (new cljs.core.PersistentVector(null,1,(5),inst_37111,inst_37112,null));
var inst_37114 = [inst_37113];
var inst_37115 = cljs.core.PersistentHashMap.fromArrays(inst_37110,inst_37114);
var inst_37116 = [inst_37115];
var inst_37117 = (new cljs.core.PersistentVector(null,1,(5),inst_37109,inst_37116,null));
var inst_37118 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_37119 = cljs.core.PersistentHashMap.EMPTY;
var inst_37120 = [inst_37117,inst_37118,inst_37119];
var inst_37121 = cljs.core.PersistentHashMap.fromArrays(inst_37108,inst_37120);
var inst_37122 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_37123 = fluree.db.dbfunctions.internal.query.call(null,inst_37122,inst_37121);
var state_37141__$1 = state_37141;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37141__$1,(6),inst_37123);
} else {
if((state_val_37142 === (3))){
var inst_37139 = (state_37141[(2)]);
var state_37141__$1 = state_37141;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37141__$1,inst_37139);
} else {
if((state_val_37142 === (4))){
var inst_37098 = (state_37141[(2)]);
var inst_37099 = fluree.db.dbfunctions.internal.function_error.call(null,inst_37098,"?user_id-from-auth","Context Object");
var state_37141__$1 = state_37141;
var statearr_37146_37158 = state_37141__$1;
(statearr_37146_37158[(2)] = inst_37099);

(statearr_37146_37158[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37142 === (5))){
var _ = (function (){var statearr_37147 = state_37141;
(statearr_37147[(4)] = cljs.core.rest.call(null,(state_37141[(4)])));

return statearr_37147;
})();
var state_37141__$1 = state_37141;
var ex37145 = (state_37141__$1[(2)]);
var statearr_37148_37159 = state_37141__$1;
(statearr_37148_37159[(5)] = ex37145);


var statearr_37149_37160 = state_37141__$1;
(statearr_37149_37160[(1)] = (4));

(statearr_37149_37160[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37142 === (6))){
var inst_37125 = (state_37141[(2)]);
var inst_37126 = fluree.db.util.async.throw_err.call(null,inst_37125);
var inst_37127 = cljs.core.nth.call(null,inst_37126,(0),null);
var inst_37128 = cljs.core.nth.call(null,inst_37126,(1),null);
var inst_37129 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37130 = ["_user/_auth","_id"];
var inst_37131 = (new cljs.core.PersistentVector(null,2,(5),inst_37129,inst_37130,null));
var inst_37132 = fluree.db.dbfunctions.internal.get_in.call(null,inst_37127,inst_37131);
var inst_37133 = cljs.core.first.call(null,inst_37132);
var inst_37134 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37135 = [inst_37133,inst_37128];
var inst_37136 = (new cljs.core.PersistentVector(null,2,(5),inst_37134,inst_37135,null));
var _ = (function (){var statearr_37150 = state_37141;
(statearr_37150[(4)] = cljs.core.rest.call(null,(state_37141[(4)])));

return statearr_37150;
})();
var state_37141__$1 = state_37141;
var statearr_37151_37161 = state_37141__$1;
(statearr_37151_37161[(2)] = inst_37136);

(statearr_37151_37161[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____0 = (function (){
var statearr_37152 = [null,null,null,null,null,null,null];
(statearr_37152[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__);

(statearr_37152[(1)] = (1));

return statearr_37152;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____1 = (function (state_37141){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_37141);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e37153){var ex__2749__auto__ = e37153;
var statearr_37154_37162 = state_37141;
(statearr_37154_37162[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_37141[(4)]))){
var statearr_37155_37163 = state_37141;
(statearr_37155_37163[(1)] = cljs.core.first.call(null,(state_37141[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37164 = state_37141;
state_37141 = G__37164;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__ = function(state_37141){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____1.call(this,state_37141);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_37156 = f__2769__auto__.call(null);
(statearr_37156[(6)] = c__2768__auto__);

return statearr_37156;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_37186){
var state_val_37187 = (state_37186[(1)]);
if((state_val_37187 === (7))){
var inst_37171 = (state_37186[(7)]);
var inst_37175 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_37176 = fluree.db.dbproto._subid.call(null,inst_37175,inst_37171);
var state_37186__$1 = state_37186;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37186__$1,(9),inst_37176);
} else {
if((state_val_37187 === (1))){
var state_37186__$1 = state_37186;
var statearr_37188_37207 = state_37186__$1;
(statearr_37188_37207[(2)] = null);

(statearr_37188_37207[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37187 === (4))){
var inst_37165 = (state_37186[(2)]);
var state_37186__$1 = state_37186;
var statearr_37189_37208 = state_37186__$1;
(statearr_37189_37208[(2)] = inst_37165);

(statearr_37189_37208[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37187 === (6))){
var inst_37171 = (state_37186[(7)]);
var state_37186__$1 = state_37186;
var statearr_37190_37209 = state_37186__$1;
(statearr_37190_37209[(2)] = inst_37171);

(statearr_37190_37209[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37187 === (3))){
var inst_37184 = (state_37186[(2)]);
var state_37186__$1 = state_37186;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37186__$1,inst_37184);
} else {
if((state_val_37187 === (2))){
var inst_37171 = (state_37186[(7)]);
var _ = (function (){var statearr_37192 = state_37186;
(statearr_37192[(4)] = cljs.core.cons.call(null,(5),(state_37186[(4)])));

return statearr_37192;
})();
var inst_37171__$1 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_37172 = typeof inst_37171__$1 === 'number';
var state_37186__$1 = (function (){var statearr_37193 = state_37186;
(statearr_37193[(7)] = inst_37171__$1);

return statearr_37193;
})();
if(cljs.core.truth_(inst_37172)){
var statearr_37194_37210 = state_37186__$1;
(statearr_37194_37210[(1)] = (6));

} else {
var statearr_37195_37211 = state_37186__$1;
(statearr_37195_37211[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37187 === (9))){
var inst_37178 = (state_37186[(2)]);
var inst_37179 = fluree.db.util.async.throw_err.call(null,inst_37178);
var state_37186__$1 = state_37186;
var statearr_37196_37212 = state_37186__$1;
(statearr_37196_37212[(2)] = inst_37179);

(statearr_37196_37212[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37187 === (5))){
var _ = (function (){var statearr_37197 = state_37186;
(statearr_37197[(4)] = cljs.core.rest.call(null,(state_37186[(4)])));

return statearr_37197;
})();
var state_37186__$1 = state_37186;
var ex37191 = (state_37186__$1[(2)]);
var statearr_37198_37213 = state_37186__$1;
(statearr_37198_37213[(5)] = ex37191);


if((ex37191 instanceof Error)){
var statearr_37199_37214 = state_37186__$1;
(statearr_37199_37214[(1)] = (4));

(statearr_37199_37214[(5)] = null);

} else {
throw ex37191;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37187 === (8))){
var inst_37181 = (state_37186[(2)]);
var _ = (function (){var statearr_37200 = state_37186;
(statearr_37200[(4)] = cljs.core.rest.call(null,(state_37186[(4)])));

return statearr_37200;
})();
var state_37186__$1 = state_37186;
var statearr_37201_37215 = state_37186__$1;
(statearr_37201_37215[(2)] = inst_37181);

(statearr_37201_37215[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____0 = (function (){
var statearr_37202 = [null,null,null,null,null,null,null,null];
(statearr_37202[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__);

(statearr_37202[(1)] = (1));

return statearr_37202;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____1 = (function (state_37186){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_37186);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e37203){var ex__2749__auto__ = e37203;
var statearr_37204_37216 = state_37186;
(statearr_37204_37216[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_37186[(4)]))){
var statearr_37205_37217 = state_37186;
(statearr_37205_37217[(1)] = cljs.core.first.call(null,(state_37186[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37218 = state_37186;
state_37186 = G__37218;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__ = function(state_37186){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____1.call(this,state_37186);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_37206 = f__2769__auto__.call(null);
(statearr_37206[(6)] = c__2768__auto__);

return statearr_37206;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv.call(null,(function (p1__37219_SHARP_){
return fluree.db.flake.op.call(null,p1__37219_SHARP_) === true;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__37220_SHARP_){
return fluree.db.flake.o.call(null,p1__37220_SHARP_);
}),trueF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e37221){var e = e37221;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objT",flakes);
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv.call(null,(function (p1__37222_SHARP_){
return fluree.db.flake.op.call(null,p1__37222_SHARP_) === false;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__37223_SHARP_){
return fluree.db.flake.o.call(null,p1__37223_SHARP_);
}),falseF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e37224){var e = e37224;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objF",flakes);
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = (Math.floor(fluree.db.dbfunctions.internal._STAR_.call(null,base,max_SINGLEQUOTE_)) | (0));
return num;
}catch (e37225){var e = e37225;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rand",instant,max_SINGLEQUOTE_);
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_37305){
var state_val_37306 = (state_37305[(1)]);
if((state_val_37306 === (7))){
var inst_37244 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val);
var inst_37245 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_37246 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_37247 = cljs.core.PersistentHashMap.fromArrays(inst_37245,inst_37246);
var inst_37248 = cljs.core.ex_info.call(null,inst_37244,inst_37247);
var inst_37249 = (function(){throw inst_37248})();
var state_37305__$1 = state_37305;
var statearr_37307_37342 = state_37305__$1;
(statearr_37307_37342[(2)] = inst_37249);

(statearr_37307_37342[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37306 === (1))){
var state_37305__$1 = state_37305;
var statearr_37308_37343 = state_37305__$1;
(statearr_37308_37343[(2)] = null);

(statearr_37308_37343[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37306 === (4))){
var inst_37226 = (state_37305[(2)]);
var state_37305__$1 = state_37305;
var statearr_37309_37344 = state_37305__$1;
(statearr_37309_37344[(2)] = inst_37226);

(statearr_37309_37344[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37306 === (15))){
var inst_37289 = (state_37305[(7)]);
var inst_37285 = (state_37305[(2)]);
var inst_37286 = fluree.db.util.async.throw_err.call(null,inst_37285);
var inst_37287 = cljs.core.nth.call(null,inst_37286,(0),null);
var inst_37288 = cljs.core.nth.call(null,inst_37286,(1),null);
var inst_37289__$1 = cljs.core.first.call(null,inst_37287);
var inst_37290 = cljs.core._EQ_.call(null,inst_37289__$1,compare_val);
var state_37305__$1 = (function (){var statearr_37310 = state_37305;
(statearr_37310[(7)] = inst_37289__$1);

(statearr_37310[(8)] = inst_37288);

return statearr_37310;
})();
if(inst_37290){
var statearr_37311_37345 = state_37305__$1;
(statearr_37311_37345[(1)] = (16));

} else {
var statearr_37312_37346 = state_37305__$1;
(statearr_37312_37346[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37306 === (13))){
var state_37305__$1 = state_37305;
var statearr_37313_37347 = state_37305__$1;
(statearr_37313_37347[(2)] = null);

(statearr_37313_37347[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37306 === (6))){
var state_37305__$1 = state_37305;
var statearr_37314_37348 = state_37305__$1;
(statearr_37314_37348[(2)] = null);

(statearr_37314_37348[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37306 === (17))){
var inst_37289 = (state_37305[(7)]);
var inst_37293 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_37289)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_37294 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_37295 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_37296 = cljs.core.PersistentHashMap.fromArrays(inst_37294,inst_37295);
var inst_37297 = cljs.core.ex_info.call(null,inst_37293,inst_37296);
var inst_37298 = (function(){throw inst_37297})();
var state_37305__$1 = state_37305;
var statearr_37315_37349 = state_37305__$1;
(statearr_37315_37349[(2)] = inst_37298);

(statearr_37315_37349[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37306 === (3))){
var inst_37303 = (state_37305[(2)]);
var state_37305__$1 = state_37305;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37305__$1,inst_37303);
} else {
if((state_val_37306 === (12))){
var inst_37241 = (state_37305[(9)]);
var inst_37264 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas on a multi-cardinality predicate: ",inst_37241);
var inst_37265 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_37266 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_37267 = cljs.core.PersistentHashMap.fromArrays(inst_37265,inst_37266);
var inst_37268 = cljs.core.ex_info.call(null,inst_37264,inst_37267);
var inst_37269 = (function(){throw inst_37268})();
var state_37305__$1 = state_37305;
var statearr_37316_37350 = state_37305__$1;
(statearr_37316_37350[(2)] = inst_37269);

(statearr_37316_37350[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37306 === (2))){
var inst_37239 = (state_37305[(10)]);
var inst_37238 = (state_37305[(11)]);
var inst_37240 = (state_37305[(12)]);
var _ = (function (){var statearr_37317 = state_37305;
(statearr_37317[(4)] = cljs.core.cons.call(null,(5),(state_37305[(4)])));

return statearr_37317;
})();
var inst_37236 = _QMARK_ctx;
var inst_37237 = cljs.core.__destructure_map.call(null,inst_37236);
var inst_37238__$1 = cljs.core.get.call(null,inst_37237,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_37239__$1 = cljs.core.get.call(null,inst_37237,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_37240__$1 = cljs.core.get.call(null,inst_37237,new cljs.core.Keyword(null,"db","db",993250759));
var inst_37241 = fluree.db.dbproto._p_prop.call(null,inst_37240__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_37239__$1);
var state_37305__$1 = (function (){var statearr_37318 = state_37305;
(statearr_37318[(10)] = inst_37239__$1);

(statearr_37318[(11)] = inst_37238__$1);

(statearr_37318[(12)] = inst_37240__$1);

(statearr_37318[(9)] = inst_37241);

return statearr_37318;
})();
if(cljs.core.truth_(inst_37238__$1)){
var statearr_37319_37351 = state_37305__$1;
(statearr_37319_37351[(1)] = (6));

} else {
var statearr_37320_37352 = state_37305__$1;
(statearr_37320_37352[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37306 === (11))){
var inst_37239 = (state_37305[(10)]);
var inst_37240 = (state_37305[(12)]);
var inst_37261 = (state_37305[(2)]);
var inst_37262 = fluree.db.dbproto._p_prop.call(null,inst_37240,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_37239);
var state_37305__$1 = (function (){var statearr_37322 = state_37305;
(statearr_37322[(13)] = inst_37261);

return statearr_37322;
})();
if(cljs.core.truth_(inst_37262)){
var statearr_37323_37353 = state_37305__$1;
(statearr_37323_37353[(1)] = (12));

} else {
var statearr_37324_37354 = state_37305__$1;
(statearr_37324_37354[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37306 === (9))){
var state_37305__$1 = state_37305;
var statearr_37325_37355 = state_37305__$1;
(statearr_37325_37355[(2)] = null);

(statearr_37325_37355[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37306 === (5))){
var _ = (function (){var statearr_37326 = state_37305;
(statearr_37326[(4)] = cljs.core.rest.call(null,(state_37305[(4)])));

return statearr_37326;
})();
var state_37305__$1 = state_37305;
var ex37321 = (state_37305__$1[(2)]);
var statearr_37327_37356 = state_37305__$1;
(statearr_37327_37356[(5)] = ex37321);


if((ex37321 instanceof Error)){
var statearr_37328_37357 = state_37305__$1;
(statearr_37328_37357[(1)] = (4));

(statearr_37328_37357[(5)] = null);

} else {
throw ex37321;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37306 === (14))){
var inst_37238 = (state_37305[(11)]);
var inst_37240 = (state_37305[(12)]);
var inst_37241 = (state_37305[(9)]);
var inst_37272 = (state_37305[(2)]);
var inst_37273 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_37274 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37275 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37276 = [inst_37238,inst_37241,"?current-val"];
var inst_37277 = (new cljs.core.PersistentVector(null,3,(5),inst_37275,inst_37276,null));
var inst_37278 = [inst_37277];
var inst_37279 = (new cljs.core.PersistentVector(null,1,(5),inst_37274,inst_37278,null));
var inst_37280 = cljs.core.PersistentHashMap.EMPTY;
var inst_37281 = ["?current-val",inst_37279,inst_37280];
var inst_37282 = cljs.core.PersistentHashMap.fromArrays(inst_37273,inst_37281);
var inst_37283 = fluree.db.dbfunctions.internal.query.call(null,inst_37240,inst_37282);
var state_37305__$1 = (function (){var statearr_37329 = state_37305;
(statearr_37329[(14)] = inst_37272);

return statearr_37329;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37305__$1,(15),inst_37283);
} else {
if((state_val_37306 === (16))){
var state_37305__$1 = state_37305;
var statearr_37330_37358 = state_37305__$1;
(statearr_37330_37358[(2)] = new_val);

(statearr_37330_37358[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37306 === (10))){
var inst_37254 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val);
var inst_37255 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_37256 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_37257 = cljs.core.PersistentHashMap.fromArrays(inst_37255,inst_37256);
var inst_37258 = cljs.core.ex_info.call(null,inst_37254,inst_37257);
var inst_37259 = (function(){throw inst_37258})();
var state_37305__$1 = state_37305;
var statearr_37331_37359 = state_37305__$1;
(statearr_37331_37359[(2)] = inst_37259);

(statearr_37331_37359[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37306 === (18))){
var inst_37300 = (state_37305[(2)]);
var _ = (function (){var statearr_37332 = state_37305;
(statearr_37332[(4)] = cljs.core.rest.call(null,(state_37305[(4)])));

return statearr_37332;
})();
var state_37305__$1 = state_37305;
var statearr_37333_37360 = state_37305__$1;
(statearr_37333_37360[(2)] = inst_37300);

(statearr_37333_37360[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37306 === (8))){
var inst_37241 = (state_37305[(9)]);
var inst_37251 = (state_37305[(2)]);
var state_37305__$1 = (function (){var statearr_37334 = state_37305;
(statearr_37334[(15)] = inst_37251);

return statearr_37334;
})();
if(cljs.core.truth_(inst_37241)){
var statearr_37335_37361 = state_37305__$1;
(statearr_37335_37361[(1)] = (9));

} else {
var statearr_37336_37362 = state_37305__$1;
(statearr_37336_37362[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____0 = (function (){
var statearr_37337 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37337[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__);

(statearr_37337[(1)] = (1));

return statearr_37337;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____1 = (function (state_37305){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_37305);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e37338){var ex__2749__auto__ = e37338;
var statearr_37339_37363 = state_37305;
(statearr_37339_37363[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_37305[(4)]))){
var statearr_37340_37364 = state_37305;
(statearr_37340_37364[(1)] = cljs.core.first.call(null,(state_37305[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37365 = state_37305;
state_37305 = G__37365;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__ = function(state_37305){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____1.call(this,state_37305);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_37341 = f__2769__auto__.call(null);
(statearr_37341[(6)] = c__2768__auto__);

return statearr_37341;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
