// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.analytical_filter');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
fluree.db.query.analytical_filter.filter_fns_with_ns = cljs.core.PersistentHashMap.fromArrays(["re-pattern","&&","=","coalesce","!","*","<=","not","/","-","strEnds","re-find","nil?","if","not=","or",">=","and","strStarts","<","bound","now","||","+",">"],[new cljs.core.Symbol(null,"re-pattern","re-pattern",1047705161,null),new cljs.core.Symbol(null,"&&","&&",-1330982734,null),new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol("fluree.db.query.analytical-filter","coalesce","fluree.db.query.analytical-filter/coalesce",-342154698,null),new cljs.core.Symbol("fluree.db.query.analytical-filter","!","fluree.db.query.analytical-filter/!",317544900,null),new cljs.core.Symbol(null,"*","*",345799209,null),new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"not","not",1044554643,null),new cljs.core.Symbol(null,"/","/",-1371932971,null),new cljs.core.Symbol(null,"-","-",-471816912,null),new cljs.core.Symbol("fluree.db.query.analytical-filter","strEnds","fluree.db.query.analytical-filter/strEnds",459780392,null),new cljs.core.Symbol(null,"re-find","re-find",1143444147,null),new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.Symbol(null,"if","if",1181717262,null),new cljs.core.Symbol(null,"not=","not=",1466536204,null),new cljs.core.Symbol(null,"or","or",1876275696,null),new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"and","and",668631710,null),new cljs.core.Symbol("fluree.db.query.analytical-filter","strStarts","fluree.db.query.analytical-filter/strStarts",255731441,null),new cljs.core.Symbol(null,"<","<",993667236,null),new cljs.core.Symbol("fluree.db.query.analytical-filter","bound","fluree.db.query.analytical-filter/bound",-1543996761,null),new cljs.core.Symbol("fluree.db.query.analytical-filter","now","fluree.db.query.analytical-filter/now",296501066,null),new cljs.core.Symbol("fluree.db.query.analytical-filter","||","fluree.db.query.analytical-filter/||",1985077720,null),new cljs.core.Symbol(null,"+","+",-740910886,null),new cljs.core.Symbol(null,">",">",1085014381,null)]);
fluree.db.query.analytical_filter._BANG_ = (function fluree$db$query$analytical_filter$_BANG_(x){
return cljs.core.not.call(null,x);
});
var ret__5824__auto___18551 = (function (){
/**
 * Equivalent to and
 */
fluree.db.query.analytical_filter._AMPERSAND__AMPERSAND_ = (function fluree$db$query$analytical_filter$_AMPERSAND__AMPERSAND_(var_args){
var G__18550 = arguments.length;
switch (G__18550) {
case 2:
return fluree.db.query.analytical_filter._AMPERSAND__AMPERSAND_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.analytical_filter._AMPERSAND__AMPERSAND_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__5794__auto__ = [];
var len__5769__auto___18553 = arguments.length;
var i__5770__auto___18554 = (0);
while(true){
if((i__5770__auto___18554 < len__5769__auto___18553)){
args_arr__5794__auto__.push((arguments[i__5770__auto___18554]));

var G__18555 = (i__5770__auto___18554 + (1));
i__5770__auto___18554 = G__18555;
continue;
} else {
}
break;
}

var argseq__5795__auto__ = (new cljs.core.IndexedSeq(args_arr__5794__auto__.slice((3)),(0),null));
return fluree.db.query.analytical_filter._AMPERSAND__AMPERSAND_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5795__auto__);

}
});

(fluree.db.query.analytical_filter._AMPERSAND__AMPERSAND_.cljs$core$IFn$_invoke$arity$2 = (function (_AMPERSAND_form,_AMPERSAND_env){
return true;
}));

(fluree.db.query.analytical_filter._AMPERSAND__AMPERSAND_.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return x;
}));

(fluree.db.query.analytical_filter._AMPERSAND__AMPERSAND_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,next){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"and__18544__auto__","and__18544__auto__",1544753576,null),null,(1),null)),(new cljs.core.List(null,x,null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"and__18544__auto__","and__18544__auto__",1544753576,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","and","cljs.core/and",-6692549,null),null,(1),null)),next))),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"and__18544__auto__","and__18544__auto__",1544753576,null),null,(1),null))))),null,(1),null)))));
}));

/** @this {Function} */
(fluree.db.query.analytical_filter._AMPERSAND__AMPERSAND_.cljs$lang$applyTo = (function (seq18546){
var G__18547 = cljs.core.first.call(null,seq18546);
var seq18546__$1 = cljs.core.next.call(null,seq18546);
var G__18548 = cljs.core.first.call(null,seq18546__$1);
var seq18546__$2 = cljs.core.next.call(null,seq18546__$1);
var G__18549 = cljs.core.first.call(null,seq18546__$2);
var seq18546__$3 = cljs.core.next.call(null,seq18546__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18547,G__18548,G__18549,seq18546__$3);
}));

(fluree.db.query.analytical_filter._AMPERSAND__AMPERSAND_.cljs$lang$maxFixedArity = (3));

return null;
})()
;
(fluree.db.query.analytical_filter._AMPERSAND__AMPERSAND_.cljs$lang$macro = true);

var ret__5824__auto___18563 = (function (){
/**
 * Equivalent to or
 */
fluree.db.query.analytical_filter._BAR__BAR_ = (function fluree$db$query$analytical_filter$_BAR__BAR_(var_args){
var G__18562 = arguments.length;
switch (G__18562) {
case 2:
return fluree.db.query.analytical_filter._BAR__BAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.analytical_filter._BAR__BAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__5794__auto__ = [];
var len__5769__auto___18565 = arguments.length;
var i__5770__auto___18566 = (0);
while(true){
if((i__5770__auto___18566 < len__5769__auto___18565)){
args_arr__5794__auto__.push((arguments[i__5770__auto___18566]));

var G__18567 = (i__5770__auto___18566 + (1));
i__5770__auto___18566 = G__18567;
continue;
} else {
}
break;
}

var argseq__5795__auto__ = (new cljs.core.IndexedSeq(args_arr__5794__auto__.slice((3)),(0),null));
return fluree.db.query.analytical_filter._BAR__BAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5795__auto__);

}
});

(fluree.db.query.analytical_filter._BAR__BAR_.cljs$core$IFn$_invoke$arity$2 = (function (_AMPERSAND_form,_AMPERSAND_env){
return null;
}));

(fluree.db.query.analytical_filter._BAR__BAR_.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return x;
}));

(fluree.db.query.analytical_filter._BAR__BAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,next){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"or__18556__auto__","or__18556__auto__",1435380909,null),null,(1),null)),(new cljs.core.List(null,x,null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"or__18556__auto__","or__18556__auto__",1435380909,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"or__18556__auto__","or__18556__auto__",1435380909,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","or","cljs.core/or",1201033885,null),null,(1),null)),next))),null,(1),null))))),null,(1),null)))));
}));

/** @this {Function} */
(fluree.db.query.analytical_filter._BAR__BAR_.cljs$lang$applyTo = (function (seq18558){
var G__18559 = cljs.core.first.call(null,seq18558);
var seq18558__$1 = cljs.core.next.call(null,seq18558);
var G__18560 = cljs.core.first.call(null,seq18558__$1);
var seq18558__$2 = cljs.core.next.call(null,seq18558__$1);
var G__18561 = cljs.core.first.call(null,seq18558__$2);
var seq18558__$3 = cljs.core.next.call(null,seq18558__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18559,G__18560,G__18561,seq18558__$3);
}));

(fluree.db.query.analytical_filter._BAR__BAR_.cljs$lang$maxFixedArity = (3));

return null;
})()
;
(fluree.db.query.analytical_filter._BAR__BAR_.cljs$lang$macro = true);

fluree.db.query.analytical_filter.bound = (function fluree$db$query$analytical_filter$bound(x){
return (!((x == null)));
});
fluree.db.query.analytical_filter.now = (function fluree$db$query$analytical_filter$now(){
return null;
});
fluree.db.query.analytical_filter.strStarts = (function fluree$db$query$analytical_filter$strStarts(s,substr){
return clojure.string.starts_with_QMARK_.call(null,s,substr);
});
fluree.db.query.analytical_filter.strEnds = (function fluree$db$query$analytical_filter$strEnds(s,substr){
return clojure.string.ends_with_QMARK_.call(null,s,substr);
});
/**
 * Takes a filter fn as a string and a set/fn of allowed symbols that can be used within the fn.
 * 
 *   Returns two-tuple of parsed function and variables (symbols) used within the function as a set.
 */
fluree.db.query.analytical_filter.extract_filter_fn = (function fluree$db$query$analytical_filter$extract_filter_fn(func,symbols_allowed){
var func_SINGLEQUOTE_ = ((typeof func === 'string')?cljs.reader.read_string.call(null,func):func);
var symbols_allowed_STAR_ = (function (){var or__5045__auto__ = symbols_allowed;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (function (sym){
return cljs.core.not_EQ_.call(null,"?",cljs.core.first.call(null,cljs.core.name.call(null,sym)));
});
}
})();
var fn_name = cljs.core.first.call(null,func_SINGLEQUOTE_);
var fn_w_ns = (function (){var or__5045__auto__ = (function (){var and__5043__auto__ = cljs.core.set_QMARK_.call(null,fn_name);
if(and__5043__auto__){
var and__5043__auto____$1 = cljs.core.every_QMARK_.call(null,(function (p1__18568_SHARP_){
return ((typeof p1__18568_SHARP_ === 'number') || (typeof p1__18568_SHARP_ === 'string'));
}),fn_name);
if(and__5043__auto____$1){
return fn_name;
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = fluree.db.query.analytical_filter.filter_fns_with_ns.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_name));
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
throw cljs.core.ex_info.call(null,["Invalid filter function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_name)," used in function argument: ",cljs.core.pr_str.call(null,func)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}
}
})();
var args = cljs.core.rest.call(null,func_SINGLEQUOTE_);
var vec__18569 = cljs.core.reduce.call(null,(function (p__18572,arg){
var vec__18573 = p__18572;
var args_STAR_ = cljs.core.nth.call(null,vec__18573,(0),null);
var vars = cljs.core.nth.call(null,vec__18573,(1),null);
if(cljs.core.list_QMARK_.call(null,arg)){
var vec__18576 = fluree.db.query.analytical_filter.extract_filter_fn.call(null,arg,symbols_allowed_STAR_);
var args_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__18576,(0),null);
var vars_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__18576,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,args_STAR_,args_SINGLEQUOTE_),cljs.core.into.call(null,vars,vars_SINGLEQUOTE_)], null);
} else {
if((arg instanceof cljs.core.Symbol)){
if(cljs.core.not.call(null,symbols_allowed_STAR_.call(null,arg))){
throw cljs.core.ex_info.call(null,["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arg)," used in function argument: ",cljs.core.pr_str.call(null,func)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,args_STAR_,arg),cljs.core.conj.call(null,vars,arg)], null);
}
} else {
if(((typeof arg === 'string') || (((typeof arg === 'number') || (((cljs.core.boolean_QMARK_.call(null,arg)) || ((((arg == null)) || (cljs.core.regexp_QMARK_.call(null,arg)))))))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,args_STAR_,arg),vars], null);
} else {
throw cljs.core.ex_info.call(null,["Illegal element ",cljs.core.pr_str.call(null,arg)," of type: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,arg))," in function argument: ",cljs.core.pr_str.call(null,func),"."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,cljs.core.PersistentHashSet.EMPTY], null),args);
var args_STAR_ = cljs.core.nth.call(null,vec__18569,(0),null);
var vars = cljs.core.nth.call(null,vec__18569,(1),null);
var fn_STAR_ = cljs.core.cons.call(null,fn_w_ns,args_STAR_);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fn_STAR_,vars], null);
});
/**
 * Takes a SPARQL-formatted filer, and returns 
 */
fluree.db.query.analytical_filter.SPARQL_filter_parser = (function fluree$db$query$analytical_filter$SPARQL_filter_parser(code){
throw cljs.core.ex_info.call(null,"Filter functions written in standard SPARQL format are not yet accepted.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
/**
 * optional? indicates we are looking for optional filters. 
 */
fluree.db.query.analytical_filter.get_filters = (function fluree$db$query$analytical_filter$get_filters(filters,optional_QMARK_){
return cljs.core.reduce.call(null,(function (acc,fil){
if(typeof fil === 'string'){
if(cljs.core.truth_(optional_QMARK_)){
return acc;
} else {
return cljs.core.conj.call(null,acc,fil);
}
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core.vector_QMARK_.call(null,fil);
if(and__5043__auto__){
var and__5043__auto____$1 = optional_QMARK_;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.call(null,"optional",clojure.string.lower_case.call(null,cljs.core.first.call(null,fil)));
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
return cljs.core.conj.call(null,acc,cljs.core.second.call(null,fil));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core.map_QMARK_.call(null,fil);
if(and__5043__auto__){
var and__5043__auto____$1 = cljs.core._EQ_.call(null,"clojure",clojure.string.lower_case.call(null,new cljs.core.Keyword(null,"language","language",-1591107564).cljs$core$IFn$_invoke$arity$1(fil)));
if(and__5043__auto____$1){
var and__5043__auto____$2 = (cljs.core.truth_(optional_QMARK_)?new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(fil):(!(new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(fil) === true)));
if(cljs.core.truth_(and__5043__auto____$2)){
return cljs.core.contains_QMARK_.call(null,fil,new cljs.core.Keyword(null,"code","code",1586293142));
} else {
return and__5043__auto____$2;
}
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
return cljs.core.conj.call(null,acc,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(fil));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core.map_QMARK_.call(null,fil);
if(and__5043__auto__){
var and__5043__auto____$1 = cljs.core._EQ_.call(null,"sparql",clojure.string.lower_case.call(null,new cljs.core.Keyword(null,"language","language",-1591107564).cljs$core$IFn$_invoke$arity$1(fil)));
if(and__5043__auto____$1){
var and__5043__auto____$2 = (cljs.core.truth_(optional_QMARK_)?new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(fil):(!(new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(fil) === true)));
if(cljs.core.truth_(and__5043__auto____$2)){
return cljs.core.contains_QMARK_.call(null,fil,new cljs.core.Keyword(null,"code","code",1586293142));
} else {
return and__5043__auto____$2;
}
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
return cljs.core.conj.call(null,acc,fluree.db.query.analytical_filter.SPARQL_filter_parser.call(null,fil));
} else {
return acc;

}
}
}
}
}),cljs.core.PersistentVector.EMPTY,filters);
});
var ret__5824__auto___18589 = (function (){
/**
 * Evaluates args in order. The result of the first arg not to return error gets returned.
 */
fluree.db.query.analytical_filter.coalesce = (function fluree$db$query$analytical_filter$coalesce(var_args){
var G__18588 = arguments.length;
switch (G__18588) {
case 2:
return fluree.db.query.analytical_filter.coalesce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.analytical_filter.coalesce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__5794__auto__ = [];
var len__5769__auto___18591 = arguments.length;
var i__5770__auto___18592 = (0);
while(true){
if((i__5770__auto___18592 < len__5769__auto___18591)){
args_arr__5794__auto__.push((arguments[i__5770__auto___18592]));

var G__18593 = (i__5770__auto___18592 + (1));
i__5770__auto___18592 = G__18593;
continue;
} else {
}
break;
}

var argseq__5795__auto__ = (new cljs.core.IndexedSeq(args_arr__5794__auto__.slice((3)),(0),null));
return fluree.db.query.analytical_filter.coalesce.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5795__auto__);

}
});

(fluree.db.query.analytical_filter.coalesce.cljs$core$IFn$_invoke$arity$2 = (function (_AMPERSAND_form,_AMPERSAND_env){
throw cljs.core.ex_info.call(null,"COALESCE evaluation failed on all forms.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}));

(fluree.db.query.analytical_filter.coalesce.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,arg){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"res__18579__auto__","res__18579__auto__",163547911,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"try","try",-1273693247,null),null,(1),null)),(new cljs.core.List(null,arg,null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"catch","catch",-1616370245,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.query.analytical-filter","Exception","fluree.db.query.analytical-filter/Exception",1403766076,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"e__18580__auto__","e__18580__auto__",-1583131751,null),null,(1),null)),(new cljs.core.List(null,null,null,(1),null))))),null,(1),null))))),null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"res__18579__auto__","res__18579__auto__",163547911,null),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"throw","throw",595905694,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","ex-info","cljs.core/ex-info",-409744395,null),null,(1),null)),(new cljs.core.List(null,"Coalesce evaluation failed on all forms.",null,(1),null)),(new cljs.core.List(null,cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Keyword(null,"status","status",-1997798413),null,(1),null)),(new cljs.core.List(null,(400),null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword(null,"error","error",-978969032),null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917),null,(1),null)))))),null,(1),null))))),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"res__18579__auto__","res__18579__auto__",163547911,null),null,(1),null))))),null,(1),null)))));
}));

(fluree.db.query.analytical_filter.coalesce.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,arg,args){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"res__18581__auto__","res__18581__auto__",-1700774551,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"try","try",-1273693247,null),null,(1),null)),(new cljs.core.List(null,arg,null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"catch","catch",-1616370245,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.query.analytical-filter","Exception","fluree.db.query.analytical-filter/Exception",1403766076,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"e__18582__auto__","e__18582__auto__",-1265992925,null),null,(1),null)),(new cljs.core.List(null,null,null,(1),null))))),null,(1),null))))),null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"res__18581__auto__","res__18581__auto__",-1700774551,null),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.query.analytical-filter","coalesce","fluree.db.query.analytical-filter/coalesce",-342154698,null),null,(1),null)),args))),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"res__18581__auto__","res__18581__auto__",-1700774551,null),null,(1),null))))),null,(1),null)))));
}));

/** @this {Function} */
(fluree.db.query.analytical_filter.coalesce.cljs$lang$applyTo = (function (seq18584){
var G__18585 = cljs.core.first.call(null,seq18584);
var seq18584__$1 = cljs.core.next.call(null,seq18584);
var G__18586 = cljs.core.first.call(null,seq18584__$1);
var seq18584__$2 = cljs.core.next.call(null,seq18584__$1);
var G__18587 = cljs.core.first.call(null,seq18584__$2);
var seq18584__$3 = cljs.core.next.call(null,seq18584__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18585,G__18586,G__18587,seq18584__$3);
}));

(fluree.db.query.analytical_filter.coalesce.cljs$lang$maxFixedArity = (3));

return null;
})()
;
(fluree.db.query.analytical_filter.coalesce.cljs$lang$macro = true);

fluree.db.query.analytical_filter.filter_row = (function fluree$db$query$analytical_filter$filter_row(headers,clause,fil){
return cljs.core.eval.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,headers,null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,cljs.reader.read_string.call(null,fil),null,(1),null)))))).call(null,clause);
});
fluree.db.query.analytical_filter.get_internal_filter_fn = (function fluree$db$query$analytical_filter$get_internal_filter_fn(var$,fun){
return cljs.core.eval.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,var$,null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,fun,null,(1),null))))));
});
/**
 * Like the legacy get-internal-filter-fn, but allows for multiple vars.
 */
fluree.db.query.analytical_filter.make_executable = (function fluree$db$query$analytical_filter$make_executable(params,fun){
return cljs.core.eval.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),null,(1),null)),(new cljs.core.List(null,params,null,(1),null)),(new cljs.core.List(null,fun,null,(1),null))))));
});
