// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.fql_resp');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.analytical_parse');
/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql_resp.vswap_BANG_ = (function fluree$db$query$fql_resp$vswap_BANG_(var_args){
var G__21778 = arguments.length;
switch (G__21778) {
case 2:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol)));
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1));
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2));
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2,arg3));
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql_resp.has_ns_lookups_QMARK_ = (function fluree$db$query$fql_resp$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql_resp.full_select_spec = (function fluree$db$query$fql_resp$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid.call(null,subject_id);
var or__5045__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec.call(null,db,coll_id,cljs.core.get_in.call(null,base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.call(null,base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.call(null,lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
fluree.db.query.fql_resp.vswap_BANG_.call(null,cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
fluree.db.query.fql_resp.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql_resp$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.call(null,(function (acc,spec){
var key_spec = cljs.core.key.call(null,spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,spec)) == null))?cljs.core.assoc.call(null,cljs.core.val.call(null,spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val.call(null,spec));
return cljs.core.assoc.call(null,acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql_resp.add_fuel = (function fluree$db$query$fql_resp$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql_resp.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql_resp.resolve_reverse_refs = (function fluree$db$query$fql_resp$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_21939){
var state_val_21940 = (state_21939[(1)]);
if((state_val_21940 === (7))){
var inst_21934 = (state_21939[(2)]);
var _ = (function (){var statearr_21941 = state_21939;
(statearr_21941[(4)] = cljs.core.rest.call(null,(state_21939[(4)])));

return statearr_21941;
})();
var state_21939__$1 = state_21939;
var statearr_21942_22024 = state_21939__$1;
(statearr_21942_22024[(2)] = inst_21934);

(statearr_21942_22024[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (20))){
var inst_21861 = (state_21939[(7)]);
var state_21939__$1 = state_21939;
var statearr_21943_22025 = state_21939__$1;
(statearr_21943_22025[(2)] = inst_21861);

(statearr_21943_22025[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (27))){
var inst_21816 = (state_21939[(8)]);
var state_21939__$1 = state_21939;
if(cljs.core.truth_(inst_21816)){
var statearr_21944_22026 = state_21939__$1;
(statearr_21944_22026[(1)] = (29));

} else {
var statearr_21945_22027 = state_21939__$1;
(statearr_21945_22027[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (1))){
var state_21939__$1 = state_21939;
var statearr_21946_22028 = state_21939__$1;
(statearr_21946_22028[(2)] = null);

(statearr_21946_22028[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (24))){
var inst_21817 = (state_21939[(9)]);
var state_21939__$1 = state_21939;
var statearr_21947_22029 = state_21939__$1;
(statearr_21947_22029[(2)] = inst_21817);

(statearr_21947_22029[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (39))){
var inst_21853 = (state_21939[(10)]);
var state_21939__$1 = state_21939;
var statearr_21948_22030 = state_21939__$1;
(statearr_21948_22030[(2)] = inst_21853);

(statearr_21948_22030[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (46))){
var inst_21818 = (state_21939[(11)]);
var state_21939__$1 = state_21939;
var statearr_21949_22031 = state_21939__$1;
(statearr_21949_22031[(2)] = inst_21818);

(statearr_21949_22031[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (4))){
var inst_21780 = (state_21939[(2)]);
var state_21939__$1 = state_21939;
var statearr_21950_22032 = state_21939__$1;
(statearr_21950_22032[(2)] = inst_21780);

(statearr_21950_22032[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (15))){
var inst_21829 = (state_21939[(12)]);
var inst_21835 = cljs.core.count.call(null,inst_21829);
var inst_21836 = fluree.db.query.fql_resp.add_fuel.call(null,fuel,inst_21835,max_fuel);
var state_21939__$1 = state_21939;
var statearr_21951_22033 = state_21939__$1;
(statearr_21951_22033[(2)] = inst_21836);

(statearr_21951_22033[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (48))){
var inst_21920 = (state_21939[(13)]);
var inst_21798 = (state_21939[(14)]);
var inst_21805 = (state_21939[(15)]);
var inst_21928 = (state_21939[(2)]);
var inst_21929 = cljs.core.assoc.call(null,inst_21798,inst_21928,inst_21920);
var inst_21797 = inst_21805;
var inst_21798__$1 = inst_21929;
var state_21939__$1 = (function (){var statearr_21952 = state_21939;
(statearr_21952[(14)] = inst_21798__$1);

(statearr_21952[(16)] = inst_21797);

return statearr_21952;
})();
var statearr_21953_22034 = state_21939__$1;
(statearr_21953_22034[(2)] = null);

(statearr_21953_22034[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (50))){
var inst_21820 = (state_21939[(17)]);
var state_21939__$1 = state_21939;
var statearr_21954_22035 = state_21939__$1;
(statearr_21954_22035[(2)] = inst_21820);

(statearr_21954_22035[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (21))){
var inst_21817 = (state_21939[(9)]);
var state_21939__$1 = state_21939;
if(cljs.core.truth_(inst_21817)){
var statearr_21956_22036 = state_21939__$1;
(statearr_21956_22036[(1)] = (23));

} else {
var statearr_21957_22037 = state_21939__$1;
(statearr_21957_22037[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (31))){
var inst_21877 = (state_21939[(2)]);
var state_21939__$1 = state_21939;
if(cljs.core.truth_(inst_21877)){
var statearr_21958_22038 = state_21939__$1;
(statearr_21958_22038[(1)] = (32));

} else {
var statearr_21959_22039 = state_21939__$1;
(statearr_21959_22039[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (32))){
var inst_21860 = (state_21939[(18)]);
var inst_21853 = (state_21939[(10)]);
var inst_21852 = (state_21939[(19)]);
var inst_21879 = (inst_21852 + (1));
var tmp21955 = inst_21853;
var inst_21851 = inst_21860;
var inst_21852__$1 = inst_21879;
var inst_21853__$1 = tmp21955;
var state_21939__$1 = (function (){var statearr_21960 = state_21939;
(statearr_21960[(20)] = inst_21851);

(statearr_21960[(10)] = inst_21853__$1);

(statearr_21960[(19)] = inst_21852__$1);

return statearr_21960;
})();
var statearr_21961_22040 = state_21939__$1;
(statearr_21961_22040[(2)] = null);

(statearr_21961_22040[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (40))){
var state_21939__$1 = state_21939;
if(cljs.core.truth_(fuel)){
var statearr_21962_22041 = state_21939__$1;
(statearr_21962_22041[(1)] = (42));

} else {
var statearr_21963_22042 = state_21939__$1;
(statearr_21963_22042[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (33))){
var state_21939__$1 = state_21939;
var statearr_21964_22043 = state_21939__$1;
(statearr_21964_22043[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (13))){
var inst_21829 = (state_21939[(12)]);
var state_21939__$1 = state_21939;
var statearr_21966_22044 = state_21939__$1;
(statearr_21966_22044[(2)] = inst_21829);

(statearr_21966_22044[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (22))){
var inst_21870 = (state_21939[(2)]);
var state_21939__$1 = state_21939;
if(cljs.core.truth_(inst_21870)){
var statearr_21967_22045 = state_21939__$1;
(statearr_21967_22045[(1)] = (26));

} else {
var statearr_21968_22046 = state_21939__$1;
(statearr_21968_22046[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (36))){
var state_21939__$1 = state_21939;
var statearr_21969_22047 = state_21939__$1;
(statearr_21969_22047[(2)] = null);

(statearr_21969_22047[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (41))){
var inst_21860 = (state_21939[(18)]);
var inst_21852 = (state_21939[(19)]);
var inst_21909 = (state_21939[(2)]);
var inst_21910 = (inst_21852 + (1));
var inst_21851 = inst_21860;
var inst_21852__$1 = inst_21910;
var inst_21853 = inst_21909;
var state_21939__$1 = (function (){var statearr_21970 = state_21939;
(statearr_21970[(20)] = inst_21851);

(statearr_21970[(10)] = inst_21853);

(statearr_21970[(19)] = inst_21852__$1);

return statearr_21970;
})();
var statearr_21971_22048 = state_21939__$1;
(statearr_21971_22048[(2)] = null);

(statearr_21971_22048[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (43))){
var state_21939__$1 = state_21939;
var statearr_21972_22049 = state_21939__$1;
(statearr_21972_22049[(2)] = null);

(statearr_21972_22049[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (29))){
var inst_21816 = (state_21939[(8)]);
var inst_21852 = (state_21939[(19)]);
var inst_21874 = (inst_21852 < inst_21816);
var state_21939__$1 = state_21939;
var statearr_21973_22050 = state_21939__$1;
(statearr_21973_22050[(2)] = inst_21874);

(statearr_21973_22050[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (44))){
var inst_21893 = (state_21939[(21)]);
var inst_21889 = (state_21939[(22)]);
var inst_21902 = (state_21939[(2)]);
var inst_21903 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_21893,inst_21889);
var state_21939__$1 = (function (){var statearr_21974 = state_21939;
(statearr_21974[(23)] = inst_21902);

return statearr_21974;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21939__$1,(45),inst_21903);
} else {
if((state_val_21940 === (6))){
var inst_21797 = (state_21939[(16)]);
var inst_21804 = (state_21939[(24)]);
var inst_21803 = cljs.core.seq.call(null,inst_21797);
var inst_21804__$1 = cljs.core.first.call(null,inst_21803);
var inst_21805 = cljs.core.next.call(null,inst_21803);
var inst_21806 = cljs.core.not.call(null,inst_21804__$1);
var state_21939__$1 = (function (){var statearr_21975 = state_21939;
(statearr_21975[(15)] = inst_21805);

(statearr_21975[(24)] = inst_21804__$1);

return statearr_21975;
})();
if(inst_21806){
var statearr_21976_22051 = state_21939__$1;
(statearr_21976_22051[(1)] = (8));

} else {
var statearr_21977_22052 = state_21939__$1;
(statearr_21977_22052[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (28))){
var inst_21918 = (state_21939[(2)]);
var state_21939__$1 = state_21939;
var statearr_21978_22053 = state_21939__$1;
(statearr_21978_22053[(2)] = inst_21918);

(statearr_21978_22053[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (51))){
var inst_21926 = (state_21939[(2)]);
var state_21939__$1 = state_21939;
var statearr_21979_22054 = state_21939__$1;
(statearr_21979_22054[(2)] = inst_21926);

(statearr_21979_22054[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (25))){
var inst_21868 = (state_21939[(2)]);
var state_21939__$1 = state_21939;
var statearr_21980_22055 = state_21939__$1;
(statearr_21980_22055[(2)] = inst_21868);

(statearr_21980_22055[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (34))){
var inst_21916 = (state_21939[(2)]);
var state_21939__$1 = state_21939;
var statearr_21981_22056 = state_21939__$1;
(statearr_21981_22056[(2)] = inst_21916);

(statearr_21981_22056[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (17))){
var inst_21829 = (state_21939[(12)]);
var inst_21839 = (state_21939[(2)]);
var inst_21847 = cljs.core.seq.call(null,inst_21829);
var inst_21848 = cljs.core.first.call(null,inst_21847);
var inst_21849 = cljs.core.next.call(null,inst_21847);
var inst_21850 = cljs.core.PersistentVector.EMPTY;
var inst_21851 = inst_21829;
var inst_21852 = (0);
var inst_21853 = inst_21850;
var state_21939__$1 = (function (){var statearr_21982 = state_21939;
(statearr_21982[(20)] = inst_21851);

(statearr_21982[(10)] = inst_21853);

(statearr_21982[(25)] = inst_21848);

(statearr_21982[(19)] = inst_21852);

(statearr_21982[(26)] = inst_21849);

(statearr_21982[(27)] = inst_21839);

return statearr_21982;
})();
var statearr_21983_22057 = state_21939__$1;
(statearr_21983_22057[(2)] = null);

(statearr_21983_22057[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (3))){
var inst_21937 = (state_21939[(2)]);
var state_21939__$1 = state_21939;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21939__$1,inst_21937);
} else {
if((state_val_21940 === (12))){
var state_21939__$1 = state_21939;
var statearr_21984_22058 = state_21939__$1;
(statearr_21984_22058[(2)] = fuel);

(statearr_21984_22058[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (2))){
var _ = (function (){var statearr_21985 = state_21939;
(statearr_21985[(4)] = cljs.core.cons.call(null,(5),(state_21939[(4)])));

return statearr_21985;
})();
var inst_21793 = reverse_refs_specs;
var inst_21794 = cljs.core.seq.call(null,inst_21793);
var inst_21795 = cljs.core.first.call(null,inst_21794);
var inst_21796 = cljs.core.next.call(null,inst_21794);
var inst_21797 = inst_21793;
var inst_21798 = null;
var state_21939__$1 = (function (){var statearr_21986 = state_21939;
(statearr_21986[(28)] = inst_21795);

(statearr_21986[(14)] = inst_21798);

(statearr_21986[(29)] = inst_21796);

(statearr_21986[(16)] = inst_21797);

return statearr_21986;
})();
var statearr_21987_22059 = state_21939__$1;
(statearr_21987_22059[(2)] = null);

(statearr_21987_22059[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (23))){
var inst_21817 = (state_21939[(9)]);
var inst_21852 = (state_21939[(19)]);
var inst_21865 = (inst_21852 >= inst_21817);
var state_21939__$1 = state_21939;
var statearr_21988_22060 = state_21939__$1;
(statearr_21988_22060[(2)] = inst_21865);

(statearr_21988_22060[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (47))){
var inst_21819 = (state_21939[(30)]);
var state_21939__$1 = state_21939;
if(cljs.core.truth_(inst_21819)){
var statearr_21989_22061 = state_21939__$1;
(statearr_21989_22061[(1)] = (49));

} else {
var statearr_21990_22062 = state_21939__$1;
(statearr_21990_22062[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (35))){
var inst_21859 = (state_21939[(31)]);
var inst_21883 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21884 = [inst_21859];
var inst_21885 = (new cljs.core.PersistentVector(null,1,(5),inst_21883,inst_21884,null));
var inst_21886 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_21885);
var state_21939__$1 = state_21939;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21939__$1,(38),inst_21886);
} else {
if((state_val_21940 === (19))){
var inst_21818 = (state_21939[(11)]);
var inst_21920 = (state_21939[(2)]);
var state_21939__$1 = (function (){var statearr_21991 = state_21939;
(statearr_21991[(13)] = inst_21920);

return statearr_21991;
})();
if(cljs.core.truth_(inst_21818)){
var statearr_21992_22063 = state_21939__$1;
(statearr_21992_22063[(1)] = (46));

} else {
var statearr_21993_22064 = state_21939__$1;
(statearr_21993_22064[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (11))){
var inst_21829 = (state_21939[(12)]);
var inst_21826 = (state_21939[(2)]);
var inst_21827 = fluree.db.util.async.throw_err.call(null,inst_21826);
var inst_21828 = cljs.core.map.call(null,fluree.db.flake.s,inst_21827);
var inst_21829__$1 = cljs.core.not_empty.call(null,inst_21828);
var state_21939__$1 = (function (){var statearr_21995 = state_21939;
(statearr_21995[(12)] = inst_21829__$1);

return statearr_21995;
})();
if(cljs.core.truth_(inst_21829__$1)){
var statearr_21996_22065 = state_21939__$1;
(statearr_21996_22065[(1)] = (12));

} else {
var statearr_21997_22066 = state_21939__$1;
(statearr_21997_22066[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (9))){
var inst_21814 = (state_21939[(32)]);
var inst_21804 = (state_21939[(24)]);
var inst_21813 = cljs.core.nth.call(null,inst_21804,(0),null);
var inst_21814__$1 = cljs.core.nth.call(null,inst_21804,(1),null);
var inst_21815 = cljs.core.__destructure_map.call(null,inst_21814__$1);
var inst_21816 = cljs.core.get.call(null,inst_21815,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_21817 = cljs.core.get.call(null,inst_21815,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_21818 = cljs.core.get.call(null,inst_21815,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_21819 = cljs.core.get.call(null,inst_21815,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_21820 = cljs.core.get.call(null,inst_21815,new cljs.core.Keyword(null,"p","p",151049309));
var inst_21821 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21822 = [subject_id,inst_21813];
var inst_21823 = (new cljs.core.PersistentVector(null,2,(5),inst_21821,inst_21822,null));
var inst_21824 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_21823);
var state_21939__$1 = (function (){var statearr_21998 = state_21939;
(statearr_21998[(30)] = inst_21819);

(statearr_21998[(17)] = inst_21820);

(statearr_21998[(8)] = inst_21816);

(statearr_21998[(11)] = inst_21818);

(statearr_21998[(32)] = inst_21814__$1);

(statearr_21998[(9)] = inst_21817);

return statearr_21998;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21939__$1,(11),inst_21824);
} else {
if((state_val_21940 === (5))){
var _ = (function (){var statearr_21999 = state_21939;
(statearr_21999[(4)] = cljs.core.rest.call(null,(state_21939[(4)])));

return statearr_21999;
})();
var state_21939__$1 = state_21939;
var ex21994 = (state_21939__$1[(2)]);
var statearr_22000_22067 = state_21939__$1;
(statearr_22000_22067[(5)] = ex21994);


if((ex21994 instanceof Error)){
var statearr_22001_22068 = state_21939__$1;
(statearr_22001_22068[(1)] = (4));

(statearr_22001_22068[(5)] = null);

} else {
throw ex21994;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (14))){
var inst_21833 = (state_21939[(2)]);
var state_21939__$1 = state_21939;
if(cljs.core.truth_(inst_21833)){
var statearr_22002_22069 = state_21939__$1;
(statearr_22002_22069[(1)] = (15));

} else {
var statearr_22003_22070 = state_21939__$1;
(statearr_22003_22070[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (45))){
var inst_21853 = (state_21939[(10)]);
var inst_21905 = (state_21939[(2)]);
var inst_21906 = fluree.db.util.async.throw_err.call(null,inst_21905);
var inst_21907 = cljs.core.conj.call(null,inst_21853,inst_21906);
var state_21939__$1 = state_21939;
var statearr_22004_22071 = state_21939__$1;
(statearr_22004_22071[(2)] = inst_21907);

(statearr_22004_22071[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (26))){
var inst_21853 = (state_21939[(10)]);
var state_21939__$1 = state_21939;
var statearr_22005_22072 = state_21939__$1;
(statearr_22005_22072[(2)] = inst_21853);

(statearr_22005_22072[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (16))){
var state_21939__$1 = state_21939;
var statearr_22006_22073 = state_21939__$1;
(statearr_22006_22073[(2)] = null);

(statearr_22006_22073[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (38))){
var inst_21814 = (state_21939[(32)]);
var inst_21889 = (state_21939[(22)]);
var inst_21888 = (state_21939[(2)]);
var inst_21889__$1 = fluree.db.util.async.throw_err.call(null,inst_21888);
var inst_21890 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21891 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_21892 = (new cljs.core.PersistentVector(null,4,(5),inst_21890,inst_21891,null));
var inst_21893 = cljs.core.select_keys.call(null,inst_21814,inst_21892);
var inst_21894 = cljs.core.empty_QMARK_.call(null,inst_21889__$1);
var state_21939__$1 = (function (){var statearr_22007 = state_21939;
(statearr_22007[(21)] = inst_21893);

(statearr_22007[(22)] = inst_21889__$1);

return statearr_22007;
})();
if(inst_21894){
var statearr_22008_22074 = state_21939__$1;
(statearr_22008_22074[(1)] = (39));

} else {
var statearr_22009_22075 = state_21939__$1;
(statearr_22009_22075[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (30))){
var inst_21816 = (state_21939[(8)]);
var state_21939__$1 = state_21939;
var statearr_22010_22076 = state_21939__$1;
(statearr_22010_22076[(2)] = inst_21816);

(statearr_22010_22076[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (10))){
var inst_21932 = (state_21939[(2)]);
var state_21939__$1 = state_21939;
var statearr_22011_22077 = state_21939__$1;
(statearr_22011_22077[(2)] = inst_21932);

(statearr_22011_22077[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (18))){
var inst_21851 = (state_21939[(20)]);
var inst_21861 = (state_21939[(7)]);
var inst_21859 = (state_21939[(31)]);
var inst_21858 = cljs.core.seq.call(null,inst_21851);
var inst_21859__$1 = cljs.core.first.call(null,inst_21858);
var inst_21860 = cljs.core.next.call(null,inst_21858);
var inst_21861__$1 = cljs.core.not.call(null,inst_21859__$1);
var state_21939__$1 = (function (){var statearr_22012 = state_21939;
(statearr_22012[(7)] = inst_21861__$1);

(statearr_22012[(18)] = inst_21860);

(statearr_22012[(31)] = inst_21859__$1);

return statearr_22012;
})();
if(inst_21861__$1){
var statearr_22013_22078 = state_21939__$1;
(statearr_22013_22078[(1)] = (20));

} else {
var statearr_22014_22079 = state_21939__$1;
(statearr_22014_22079[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (42))){
var inst_21889 = (state_21939[(22)]);
var inst_21898 = cljs.core.count.call(null,inst_21889);
var inst_21899 = fluree.db.query.fql_resp.add_fuel.call(null,fuel,inst_21898,max_fuel);
var state_21939__$1 = state_21939;
var statearr_22015_22080 = state_21939__$1;
(statearr_22015_22080[(2)] = inst_21899);

(statearr_22015_22080[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (37))){
var inst_21914 = (state_21939[(2)]);
var state_21939__$1 = state_21939;
var statearr_22016_22081 = state_21939__$1;
(statearr_22016_22081[(2)] = inst_21914);

(statearr_22016_22081[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (8))){
var inst_21798 = (state_21939[(14)]);
var state_21939__$1 = state_21939;
var statearr_22017_22082 = state_21939__$1;
(statearr_22017_22082[(2)] = inst_21798);

(statearr_22017_22082[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21940 === (49))){
var inst_21819 = (state_21939[(30)]);
var state_21939__$1 = state_21939;
var statearr_22018_22083 = state_21939__$1;
(statearr_22018_22083[(2)] = inst_21819);

(statearr_22018_22083[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto____0 = (function (){
var statearr_22019 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22019[(0)] = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto__);

(statearr_22019[(1)] = (1));

return statearr_22019;
});
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto____1 = (function (state_21939){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_21939);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e22020){var ex__2749__auto__ = e22020;
var statearr_22021_22084 = state_21939;
(statearr_22021_22084[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_21939[(4)]))){
var statearr_22022_22085 = state_21939;
(statearr_22022_22085[(1)] = cljs.core.first.call(null,(state_21939[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22086 = state_21939;
state_21939 = G__22086;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto__ = function(state_21939){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto____1.call(this,state_21939);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto____0;
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto____1;
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_22023 = f__2769__auto__.call(null);
(statearr_22023[(6)] = c__2768__auto__);

return statearr_22023;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.fql_resp.component_follow_QMARK_ = (function fluree$db$query$fql_resp$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_.call(null,pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql_resp.fuel_flake_transducer = (function fluree$db$query$fql_resp$fuel_flake_transducer(var_args){
var G__22088 = arguments.length;
switch (G__22088) {
case 2:
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql_resp.fuel_flake_transducer.call(null,fuel,max_fuel,(1));
}));

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__22090 = null;
var G__22090__0 = (function (){
return xf.call(null);
});
var G__22090__1 = (function (result){
return xf.call(null,result);
});
var G__22090__2 = (function (result,flake){
fluree.db.query.fql_resp.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return xf.call(null,result,flake);
});
G__22090 = function(result,flake){
switch(arguments.length){
case 0:
return G__22090__0.call(this);
case 1:
return G__22090__1.call(this,result);
case 2:
return G__22090__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22090.cljs$core$IFn$_invoke$arity$0 = G__22090__0;
G__22090.cljs$core$IFn$_invoke$arity$1 = G__22090__1;
G__22090.cljs$core$IFn$_invoke$arity$2 = G__22090__2;
return G__22090;
})()
});
}));

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql_resp.recur_select_spec = (function fluree$db$query$fql_resp$recur_select_spec(select_spec,flake){
var recur_subject = fluree.db.flake.o.call(null,flake);
var recur_pred = fluree.db.flake.p.call(null,flake);
var map__22091 = select_spec;
var map__22091__$1 = cljs.core.__destructure_map.call(null,map__22091);
var recur_seen = cljs.core.get.call(null,map__22091__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.call(null,map__22091__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.call(null,recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql_resp.flake__GT_recur = (function fluree$db$query$fql_resp$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_22205){
var state_val_22206 = (state_22205[(1)]);
if((state_val_22206 === (7))){
var inst_22117 = flakes;
var inst_22118 = cljs.core.seq.call(null,inst_22117);
var inst_22119 = cljs.core.first.call(null,inst_22118);
var inst_22120 = cljs.core.next.call(null,inst_22118);
var inst_22121 = cljs.core.PersistentVector.EMPTY;
var inst_22122 = inst_22117;
var inst_22123 = (0);
var inst_22124 = inst_22121;
var state_22205__$1 = (function (){var statearr_22207 = state_22205;
(statearr_22207[(7)] = inst_22124);

(statearr_22207[(8)] = inst_22119);

(statearr_22207[(9)] = inst_22122);

(statearr_22207[(10)] = inst_22123);

(statearr_22207[(11)] = inst_22120);

return statearr_22207;
})();
var statearr_22208_22274 = state_22205__$1;
(statearr_22208_22274[(2)] = null);

(statearr_22208_22274[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (20))){
var state_22205__$1 = state_22205;
var statearr_22209_22275 = state_22205__$1;
(statearr_22209_22275[(2)] = results);

(statearr_22209_22275[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (27))){
var state_22205__$1 = state_22205;
var statearr_22210_22276 = state_22205__$1;
(statearr_22210_22276[(2)] = null);

(statearr_22210_22276[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (1))){
var state_22205__$1 = state_22205;
var statearr_22211_22277 = state_22205__$1;
(statearr_22211_22277[(2)] = null);

(statearr_22211_22277[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (24))){
var state_22205__$1 = state_22205;
var statearr_22212_22278 = state_22205__$1;
(statearr_22212_22278[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (39))){
var inst_22124 = (state_22205[(7)]);
var inst_22131 = (state_22205[(12)]);
var inst_22186 = (state_22205[(13)]);
var inst_22189 = (state_22205[(2)]);
var inst_22190 = fluree.db.util.async.throw_err.call(null,inst_22189);
var inst_22191 = cljs.core.conj.call(null,inst_22124,inst_22190);
var inst_22122 = inst_22131;
var inst_22123 = inst_22186;
var inst_22124__$1 = inst_22191;
var state_22205__$1 = (function (){var statearr_22214 = state_22205;
(statearr_22214[(7)] = inst_22124__$1);

(statearr_22214[(9)] = inst_22122);

(statearr_22214[(10)] = inst_22123);

return statearr_22214;
})();
var statearr_22215_22279 = state_22205__$1;
(statearr_22215_22279[(2)] = null);

(statearr_22215_22279[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (4))){
var inst_22092 = (state_22205[(2)]);
var state_22205__$1 = state_22205;
var statearr_22216_22280 = state_22205__$1;
(statearr_22216_22280[(2)] = inst_22092);

(statearr_22216_22280[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (15))){
var inst_22105 = (state_22205[(14)]);
var state_22205__$1 = state_22205;
var statearr_22217_22281 = state_22205__$1;
(statearr_22217_22281[(2)] = inst_22105);

(statearr_22217_22281[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (21))){
var inst_22101 = (state_22205[(15)]);
var state_22205__$1 = state_22205;
if(cljs.core.truth_(inst_22101)){
var statearr_22218_22282 = state_22205__$1;
(statearr_22218_22282[(1)] = (23));

} else {
var statearr_22219_22283 = state_22205__$1;
(statearr_22219_22283[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (31))){
var inst_22169 = (state_22205[(16)]);
var state_22205__$1 = state_22205;
var statearr_22220_22284 = state_22205__$1;
(statearr_22220_22284[(2)] = inst_22169);

(statearr_22220_22284[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (32))){
var inst_22161 = (state_22205[(17)]);
var inst_22175 = (state_22205[(2)]);
var state_22205__$1 = (function (){var statearr_22221 = state_22205;
(statearr_22221[(18)] = inst_22175);

return statearr_22221;
})();
if(cljs.core.truth_(inst_22161)){
var statearr_22222_22285 = state_22205__$1;
(statearr_22222_22285[(1)] = (33));

} else {
var statearr_22223_22286 = state_22205__$1;
(statearr_22223_22286[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (33))){
var inst_22161 = (state_22205[(17)]);
var state_22205__$1 = state_22205;
var statearr_22224_22287 = state_22205__$1;
(statearr_22224_22287[(2)] = inst_22161);

(statearr_22224_22287[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (13))){
var inst_22141 = (state_22205[(2)]);
var state_22205__$1 = state_22205;
if(cljs.core.truth_(inst_22141)){
var statearr_22226_22288 = state_22205__$1;
(statearr_22226_22288[(1)] = (17));

} else {
var statearr_22227_22289 = state_22205__$1;
(statearr_22227_22289[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (22))){
var inst_22158 = (state_22205[(2)]);
var state_22205__$1 = state_22205;
var statearr_22228_22290 = state_22205__$1;
(statearr_22228_22290[(2)] = inst_22158);

(statearr_22228_22290[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (36))){
var inst_22124 = (state_22205[(7)]);
var inst_22131 = (state_22205[(12)]);
var inst_22123 = (state_22205[(10)]);
var inst_22183 = (inst_22123 + (1));
var tmp22225 = inst_22124;
var inst_22122 = inst_22131;
var inst_22123__$1 = inst_22183;
var inst_22124__$1 = tmp22225;
var state_22205__$1 = (function (){var statearr_22229 = state_22205;
(statearr_22229[(7)] = inst_22124__$1);

(statearr_22229[(9)] = inst_22122);

(statearr_22229[(10)] = inst_22123__$1);

return statearr_22229;
})();
var statearr_22230_22291 = state_22205__$1;
(statearr_22230_22291[(2)] = null);

(statearr_22230_22291[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (29))){
var inst_22168 = (state_22205[(2)]);
var inst_22169 = fluree.db.util.async.throw_err.call(null,inst_22168);
var state_22205__$1 = (function (){var statearr_22231 = state_22205;
(statearr_22231[(16)] = inst_22169);

return statearr_22231;
})();
if(cljs.core.truth_(fuel)){
var statearr_22232_22292 = state_22205__$1;
(statearr_22232_22292[(1)] = (30));

} else {
var statearr_22233_22293 = state_22205__$1;
(statearr_22233_22293[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (6))){
var state_22205__$1 = state_22205;
var statearr_22234_22294 = state_22205__$1;
(statearr_22234_22294[(2)] = results);

(statearr_22234_22294[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (28))){
var inst_22154 = (state_22205[(2)]);
var state_22205__$1 = state_22205;
var statearr_22235_22295 = state_22205__$1;
(statearr_22235_22295[(2)] = inst_22154);

(statearr_22235_22295[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (25))){
var inst_22156 = (state_22205[(2)]);
var state_22205__$1 = state_22205;
var statearr_22236_22296 = state_22205__$1;
(statearr_22236_22296[(2)] = inst_22156);

(statearr_22236_22296[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (34))){
var inst_22175 = (state_22205[(18)]);
var inst_22178 = cljs.core.empty_QMARK_.call(null,inst_22175);
var state_22205__$1 = state_22205;
var statearr_22237_22297 = state_22205__$1;
(statearr_22237_22297[(2)] = inst_22178);

(statearr_22237_22297[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (17))){
var inst_22124 = (state_22205[(7)]);
var inst_22143 = cljs.core.empty_QMARK_.call(null,inst_22124);
var state_22205__$1 = state_22205;
if(inst_22143){
var statearr_22238_22298 = state_22205__$1;
(statearr_22238_22298[(1)] = (20));

} else {
var statearr_22239_22299 = state_22205__$1;
(statearr_22239_22299[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (3))){
var inst_22203 = (state_22205[(2)]);
var state_22205__$1 = state_22205;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22205__$1,inst_22203);
} else {
if((state_val_22206 === (12))){
var inst_22105 = (state_22205[(14)]);
var state_22205__$1 = state_22205;
if(cljs.core.truth_(inst_22105)){
var statearr_22240_22300 = state_22205__$1;
(statearr_22240_22300[(1)] = (14));

} else {
var statearr_22241_22301 = state_22205__$1;
(statearr_22241_22301[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (2))){
var _ = (function (){var statearr_22242 = state_22205;
(statearr_22242[(4)] = cljs.core.cons.call(null,(5),(state_22205[(4)])));

return statearr_22242;
})();
var inst_22099 = select_spec;
var inst_22100 = cljs.core.__destructure_map.call(null,inst_22099);
var inst_22101 = cljs.core.get.call(null,inst_22100,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_22102 = cljs.core.get.call(null,inst_22100,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_22103 = cljs.core.get.call(null,inst_22100,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_22104 = cljs.core.get.call(null,inst_22100,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_22105 = cljs.core.get.call(null,inst_22100,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22106 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_22107 = (inst_22104 > inst_22106);
var state_22205__$1 = (function (){var statearr_22243 = state_22205;
(statearr_22243[(15)] = inst_22101);

(statearr_22243[(19)] = inst_22103);

(statearr_22243[(14)] = inst_22105);

(statearr_22243[(20)] = inst_22102);

return statearr_22243;
})();
if(cljs.core.truth_(inst_22107)){
var statearr_22244_22302 = state_22205__$1;
(statearr_22244_22302[(1)] = (6));

} else {
var statearr_22245_22303 = state_22205__$1;
(statearr_22245_22303[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (23))){
var inst_22124 = (state_22205[(7)]);
var inst_22102 = (state_22205[(20)]);
var inst_22147 = cljs.core.assoc.call(null,results,inst_22102,inst_22124);
var state_22205__$1 = state_22205;
var statearr_22246_22304 = state_22205__$1;
(statearr_22246_22304[(2)] = inst_22147);

(statearr_22246_22304[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (35))){
var inst_22130 = (state_22205[(21)]);
var inst_22180 = (state_22205[(2)]);
var inst_22181 = fluree.db.query.fql_resp.recur_select_spec.call(null,select_spec,inst_22130);
var state_22205__$1 = (function (){var statearr_22247 = state_22205;
(statearr_22247[(22)] = inst_22181);

return statearr_22247;
})();
if(cljs.core.truth_(inst_22180)){
var statearr_22248_22305 = state_22205__$1;
(statearr_22248_22305[(1)] = (36));

} else {
var statearr_22249_22306 = state_22205__$1;
(statearr_22249_22306[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (19))){
var inst_22196 = (state_22205[(2)]);
var state_22205__$1 = state_22205;
var statearr_22250_22307 = state_22205__$1;
(statearr_22250_22307[(2)] = inst_22196);

(statearr_22250_22307[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (11))){
var inst_22132 = (state_22205[(23)]);
var state_22205__$1 = state_22205;
var statearr_22252_22308 = state_22205__$1;
(statearr_22252_22308[(2)] = inst_22132);

(statearr_22252_22308[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (9))){
var inst_22122 = (state_22205[(9)]);
var inst_22132 = (state_22205[(23)]);
var inst_22130 = (state_22205[(21)]);
var inst_22129 = cljs.core.seq.call(null,inst_22122);
var inst_22130__$1 = cljs.core.first.call(null,inst_22129);
var inst_22131 = cljs.core.next.call(null,inst_22129);
var inst_22132__$1 = cljs.core.not.call(null,inst_22130__$1);
var state_22205__$1 = (function (){var statearr_22253 = state_22205;
(statearr_22253[(23)] = inst_22132__$1);

(statearr_22253[(21)] = inst_22130__$1);

(statearr_22253[(12)] = inst_22131);

return statearr_22253;
})();
if(inst_22132__$1){
var statearr_22254_22309 = state_22205__$1;
(statearr_22254_22309[(1)] = (11));

} else {
var statearr_22255_22310 = state_22205__$1;
(statearr_22255_22310[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (5))){
var _ = (function (){var statearr_22256 = state_22205;
(statearr_22256[(4)] = cljs.core.rest.call(null,(state_22205[(4)])));

return statearr_22256;
})();
var state_22205__$1 = state_22205;
var ex22251 = (state_22205__$1[(2)]);
var statearr_22257_22311 = state_22205__$1;
(statearr_22257_22311[(5)] = ex22251);


if((ex22251 instanceof Error)){
var statearr_22258_22312 = state_22205__$1;
(statearr_22258_22312[(1)] = (4));

(statearr_22258_22312[(5)] = null);

} else {
throw ex22251;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (14))){
var inst_22105 = (state_22205[(14)]);
var inst_22123 = (state_22205[(10)]);
var inst_22136 = (inst_22123 < inst_22105);
var state_22205__$1 = state_22205;
var statearr_22259_22313 = state_22205__$1;
(statearr_22259_22313[(2)] = inst_22136);

(statearr_22259_22313[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (26))){
var inst_22124 = (state_22205[(7)]);
var inst_22102 = (state_22205[(20)]);
var inst_22150 = cljs.core.first.call(null,inst_22124);
var inst_22151 = cljs.core.assoc.call(null,results,inst_22102,inst_22150);
var state_22205__$1 = state_22205;
var statearr_22260_22314 = state_22205__$1;
(statearr_22260_22314[(2)] = inst_22151);

(statearr_22260_22314[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (16))){
var inst_22139 = (state_22205[(2)]);
var state_22205__$1 = state_22205;
var statearr_22261_22315 = state_22205__$1;
(statearr_22261_22315[(2)] = inst_22139);

(statearr_22261_22315[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (38))){
var inst_22194 = (state_22205[(2)]);
var state_22205__$1 = state_22205;
var statearr_22262_22316 = state_22205__$1;
(statearr_22262_22316[(2)] = inst_22194);

(statearr_22262_22316[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (30))){
var inst_22169 = (state_22205[(16)]);
var inst_22171 = fluree.db.query.fql_resp.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_22172 = cljs.core.sequence.call(null,inst_22171,inst_22169);
var state_22205__$1 = state_22205;
var statearr_22263_22317 = state_22205__$1;
(statearr_22263_22317[(2)] = inst_22172);

(statearr_22263_22317[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (10))){
var inst_22198 = (state_22205[(2)]);
var state_22205__$1 = state_22205;
var statearr_22264_22318 = state_22205__$1;
(statearr_22264_22318[(2)] = inst_22198);

(statearr_22264_22318[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22206 === (18))){
var inst_22103 = (state_22205[(19)]);
var inst_22130 = (state_22205[(21)]);
var inst_22160 = fluree.db.flake.o.call(null,inst_22130);
var inst_22161 = cljs.core.contains_QMARK_.call(null,inst_22103,inst_22160);
var inst_22163 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22164 = [inst_22160];
var inst_22165 = (new cljs.core.PersistentVector(null,1,(5),inst_22163,inst_22164,null));
var inst_22166 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22165);
var state_22205__$1 = (function (){var statearr_22265 = state_22205;
(statearr_22265[(17)] = inst_22161);

return statearr_22265;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22205__$1,(29),inst_22166);
} else {
if((state_val_22206 === (37))){
var inst_22175 = (state_22205[(18)]);
var inst_22181 = (state_22205[(22)]);
var inst_22123 = (state_22205[(10)]);
var inst_22186 = (inst_22123 + (1));
var inst_22187 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22181,inst_22175);
var state_22205__$1 = (function (){var statearr_22266 = state_22205;
(statearr_22266[(13)] = inst_22186);

return statearr_22266;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22205__$1,(39),inst_22187);
} else {
if((state_val_22206 === (8))){
var inst_22200 = (state_22205[(2)]);
var _ = (function (){var statearr_22267 = state_22205;
(statearr_22267[(4)] = cljs.core.rest.call(null,(state_22205[(4)])));

return statearr_22267;
})();
var state_22205__$1 = state_22205;
var statearr_22268_22319 = state_22205__$1;
(statearr_22268_22319[(2)] = inst_22200);

(statearr_22268_22319[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto____0 = (function (){
var statearr_22269 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22269[(0)] = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto__);

(statearr_22269[(1)] = (1));

return statearr_22269;
});
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto____1 = (function (state_22205){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_22205);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e22270){var ex__2749__auto__ = e22270;
var statearr_22271_22320 = state_22205;
(statearr_22271_22320[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_22205[(4)]))){
var statearr_22272_22321 = state_22205;
(statearr_22272_22321[(1)] = cljs.core.first.call(null,(state_22205[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22322 = state_22205;
state_22205 = G__22322;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto__ = function(state_22205){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto____1.call(this,state_22205);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto____0;
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto____1;
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_22273 = f__2769__auto__.call(null);
(statearr_22273[(6)] = c__2768__auto__);

return statearr_22273;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql_resp.wildcard_pred_spec = (function fluree$db$query$fql_resp$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__5045__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config.call(null,db,p,compact_QMARK_);
fluree.db.query.fql_resp.vswap_BANG_.call(null,cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql_resp.add_pred = (function fluree$db$query$fql_resp$add_pred(var_args){
var G__22326 = arguments.length;
switch (G__22326) {
case 9:
return fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql_resp.add_pred.call(null,db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_22765){
var state_val_22766 = (state_22765[(1)]);
if((state_val_22766 === (121))){
var inst_22688 = (state_22765[(2)]);
var inst_22689 = fluree.db.util.async.throw_err.call(null,inst_22688);
var inst_22690 = cljs.core.seq.call(null,inst_22689);
var state_22765__$1 = state_22765;
if(inst_22690){
var statearr_22767_22981 = state_22765__$1;
(statearr_22767_22981[(1)] = (122));

} else {
var statearr_22768_22982 = state_22765__$1;
(statearr_22768_22982[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (65))){
var inst_22481 = (state_22765[(7)]);
var inst_22480 = (state_22765[(2)]);
var inst_22481__$1 = fluree.db.util.async.throw_err.call(null,inst_22480);
var inst_22482 = cljs.core.seq.call(null,inst_22481__$1);
var state_22765__$1 = (function (){var statearr_22769 = state_22765;
(statearr_22769[(7)] = inst_22481__$1);

return statearr_22769;
})();
if(inst_22482){
var statearr_22770_22983 = state_22765__$1;
(statearr_22770_22983[(1)] = (66));

} else {
var statearr_22771_22984 = state_22765__$1;
(statearr_22771_22984[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (70))){
var inst_22481 = (state_22765[(7)]);
var inst_22492 = cljs.core.count.call(null,inst_22481);
var inst_22493 = fluree.db.query.fql_resp.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_22492);
var state_22765__$1 = state_22765;
var statearr_22772_22985 = state_22765__$1;
(statearr_22772_22985[(2)] = inst_22493);

(statearr_22772_22985[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (62))){
var inst_22471 = (state_22765[(8)]);
var inst_22474 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22475 = fluree.db.flake.o.call(null,inst_22471);
var inst_22476 = [inst_22475];
var inst_22477 = (new cljs.core.PersistentVector(null,1,(5),inst_22474,inst_22476,null));
var inst_22478 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22477);
var state_22765__$1 = state_22765;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22765__$1,(65),inst_22478);
} else {
if((state_val_22766 === (74))){
var inst_22465 = (state_22765[(9)]);
var state_22765__$1 = state_22765;
var statearr_22773_22986 = state_22765__$1;
(statearr_22773_22986[(2)] = inst_22465);

(statearr_22773_22986[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (110))){
var inst_22650 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_22651 = new cljs.core.Keyword(null,"root?","root?",-2045639518).cljs$core$IFn$_invoke$arity$1(inst_22650);
var inst_22652 = inst_22651 === true;
var state_22765__$1 = state_22765;
if(cljs.core.truth_(inst_22652)){
var statearr_22774_22987 = state_22765__$1;
(statearr_22774_22987[(1)] = (113));

} else {
var statearr_22775_22988 = state_22765__$1;
(statearr_22775_22988[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (130))){
var inst_22760 = (state_22765[(2)]);
var _ = (function (){var statearr_22776 = state_22765;
(statearr_22776[(4)] = cljs.core.rest.call(null,(state_22765[(4)])));

return statearr_22776;
})();
var state_22765__$1 = state_22765;
var statearr_22777_22989 = state_22765__$1;
(statearr_22777_22989[(2)] = inst_22760);

(statearr_22777_22989[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (128))){
var inst_22735 = (state_22765[(10)]);
var inst_22738 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22739 = [acc,inst_22735];
var inst_22740 = (new cljs.core.PersistentVector(null,2,(5),inst_22738,inst_22739,null));
var state_22765__$1 = state_22765;
var statearr_22778_22990 = state_22765__$1;
(statearr_22778_22990[(2)] = inst_22740);

(statearr_22778_22990[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (7))){
var inst_22338 = (state_22765[(11)]);
var state_22765__$1 = state_22765;
var statearr_22779_22991 = state_22765__$1;
(statearr_22779_22991[(2)] = inst_22338);

(statearr_22779_22991[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (59))){
var inst_22729 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
var statearr_22780_22992 = state_22765__$1;
(statearr_22780_22992[(2)] = inst_22729);

(statearr_22780_22992[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (86))){
var inst_22559 = (state_22765[(12)]);
var inst_22559__$1 = (state_22765[(2)]);
var state_22765__$1 = (function (){var statearr_22781 = state_22765;
(statearr_22781[(12)] = inst_22559__$1);

return statearr_22781;
})();
if(cljs.core.truth_(inst_22559__$1)){
var statearr_22782_22993 = state_22765__$1;
(statearr_22782_22993[(1)] = (88));

} else {
var statearr_22783_22994 = state_22765__$1;
(statearr_22783_22994[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (20))){
var inst_22380 = (state_22765[(13)]);
var inst_22367 = (state_22765[(14)]);
var inst_22379 = (state_22765[(15)]);
var inst_22378 = (state_22765[(2)]);
var inst_22379__$1 = cljs.core.__destructure_map.call(null,inst_22367);
var inst_22380__$1 = cljs.core.get.call(null,inst_22379__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_22381 = cljs.core.get.call(null,inst_22379__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_22382 = cljs.core.get.call(null,inst_22379__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22383 = cljs.core.get.call(null,inst_22379__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_22384 = cljs.core.get.call(null,inst_22379__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_22385 = cljs.core.get.call(null,inst_22379__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_22765__$1 = (function (){var statearr_22784 = state_22765;
(statearr_22784[(13)] = inst_22380__$1);

(statearr_22784[(16)] = inst_22382);

(statearr_22784[(17)] = inst_22381);

(statearr_22784[(18)] = inst_22384);

(statearr_22784[(19)] = inst_22385);

(statearr_22784[(15)] = inst_22379__$1);

(statearr_22784[(20)] = inst_22378);

(statearr_22784[(21)] = inst_22383);

return statearr_22784;
})();
if(cljs.core.truth_(inst_22380__$1)){
var statearr_22785_22995 = state_22765__$1;
(statearr_22785_22995[(1)] = (24));

} else {
var statearr_22786_22996 = state_22765__$1;
(statearr_22786_22996[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (72))){
var inst_22490 = (state_22765[(22)]);
var inst_22496 = (state_22765[(2)]);
var inst_22497 = cljs.core.seq.call(null,inst_22490);
var state_22765__$1 = (function (){var statearr_22787 = state_22765;
(statearr_22787[(23)] = inst_22496);

return statearr_22787;
})();
if(inst_22497){
var statearr_22788_22997 = state_22765__$1;
(statearr_22788_22997[(1)] = (73));

} else {
var statearr_22789_22998 = state_22765__$1;
(statearr_22789_22998[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (58))){
var inst_22367 = (state_22765[(14)]);
var inst_22512 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_22367);
var state_22765__$1 = state_22765;
if(cljs.core.truth_(inst_22512)){
var statearr_22790_22999 = state_22765__$1;
(statearr_22790_22999[(1)] = (76));

} else {
var statearr_22791_23000 = state_22765__$1;
(statearr_22791_23000[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (60))){
var inst_22471 = (state_22765[(8)]);
var inst_22464 = (state_22765[(24)]);
var inst_22470 = cljs.core.seq.call(null,inst_22464);
var inst_22471__$1 = cljs.core.first.call(null,inst_22470);
var inst_22472 = cljs.core.next.call(null,inst_22470);
var state_22765__$1 = (function (){var statearr_22792 = state_22765;
(statearr_22792[(8)] = inst_22471__$1);

(statearr_22792[(25)] = inst_22472);

return statearr_22792;
})();
if(cljs.core.truth_(inst_22471__$1)){
var statearr_22793_23001 = state_22765__$1;
(statearr_22793_23001[(1)] = (62));

} else {
var statearr_22794_23002 = state_22765__$1;
(statearr_22794_23002[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (27))){
var inst_22388 = (state_22765[(26)]);
var inst_22384 = (state_22765[(18)]);
var inst_22388__$1 = cljs.core.not_EQ_.call(null,(0),inst_22384);
var state_22765__$1 = (function (){var statearr_22795 = state_22765;
(statearr_22795[(26)] = inst_22388__$1);

return statearr_22795;
})();
if(inst_22388__$1){
var statearr_22796_23003 = state_22765__$1;
(statearr_22796_23003[(1)] = (30));

} else {
var statearr_22797_23004 = state_22765__$1;
(statearr_22797_23004[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (1))){
var state_22765__$1 = state_22765;
var statearr_22798_23005 = state_22765__$1;
(statearr_22798_23005[(2)] = null);

(statearr_22798_23005[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (69))){
var inst_22486 = (state_22765[(2)]);
var inst_22487 = fluree.db.util.async.throw_err.call(null,inst_22486);
var state_22765__$1 = state_22765;
var statearr_22799_23006 = state_22765__$1;
(statearr_22799_23006[(2)] = inst_22487);

(statearr_22799_23006[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (101))){
var inst_22643 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
var statearr_22800_23007 = state_22765__$1;
(statearr_22800_23007[(2)] = inst_22643);

(statearr_22800_23007[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (24))){
var inst_22384 = (state_22765[(18)]);
var state_22765__$1 = state_22765;
if(cljs.core.truth_(inst_22384)){
var statearr_22801_23008 = state_22765__$1;
(statearr_22801_23008[(1)] = (27));

} else {
var statearr_22802_23009 = state_22765__$1;
(statearr_22802_23009[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (102))){
var inst_22615 = (state_22765[(27)]);
var inst_22614 = (state_22765[(2)]);
var inst_22615__$1 = fluree.db.util.async.throw_err.call(null,inst_22614);
var inst_22616 = cljs.core.empty_QMARK_.call(null,inst_22615__$1);
var state_22765__$1 = (function (){var statearr_22803 = state_22765;
(statearr_22803[(27)] = inst_22615__$1);

return statearr_22803;
})();
if(inst_22616){
var statearr_22804_23010 = state_22765__$1;
(statearr_22804_23010[(1)] = (103));

} else {
var statearr_22805_23011 = state_22765__$1;
(statearr_22805_23011[(1)] = (104));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (135))){
var state_22765__$1 = state_22765;
var statearr_22806_23012 = state_22765__$1;
(statearr_22806_23012[(2)] = null);

(statearr_22806_23012[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (55))){
var inst_22367 = (state_22765[(14)]);
var inst_22440 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_22367);
var state_22765__$1 = state_22765;
var statearr_22807_23013 = state_22765__$1;
(statearr_22807_23013[(2)] = inst_22440);

(statearr_22807_23013[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (85))){
var inst_22534 = (state_22765[(28)]);
var inst_22367 = (state_22765[(14)]);
var inst_22546 = fluree.db.flake.o.call(null,inst_22534);
var inst_22547 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22367);
var inst_22548 = fluree.db.dbproto._tag.call(null,db,inst_22546,inst_22547);
var state_22765__$1 = state_22765;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22765__$1,(87),inst_22548);
} else {
if((state_val_22766 === (39))){
var inst_22415 = (state_22765[(29)]);
var inst_22383 = (state_22765[(21)]);
var inst_22415__$1 = cljs.core.not.call(null,inst_22383);
var state_22765__$1 = (function (){var statearr_22808 = state_22765;
(statearr_22808[(29)] = inst_22415__$1);

return statearr_22808;
})();
if(inst_22415__$1){
var statearr_22809_23014 = state_22765__$1;
(statearr_22809_23014[(1)] = (42));

} else {
var statearr_22810_23015 = state_22765__$1;
(statearr_22810_23015[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (88))){
var inst_22528 = (state_22765[(30)]);
var inst_22559 = (state_22765[(12)]);
var inst_22561 = cljs.core.conj.call(null,inst_22528,inst_22559);
var state_22765__$1 = state_22765;
var statearr_22811_23016 = state_22765__$1;
(statearr_22811_23016[(2)] = inst_22561);

(statearr_22811_23016[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (46))){
var inst_22382 = (state_22765[(16)]);
var state_22765__$1 = state_22765;
var statearr_22812_23017 = state_22765__$1;
(statearr_22812_23017[(2)] = inst_22382);

(statearr_22812_23017[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (4))){
var inst_22327 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
var statearr_22813_23018 = state_22765__$1;
(statearr_22813_23018[(2)] = inst_22327);

(statearr_22813_23018[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (77))){
var inst_22574 = (state_22765[(31)]);
var inst_22574__$1 = componentFollow_QMARK_;
var state_22765__$1 = (function (){var statearr_22814 = state_22765;
(statearr_22814[(31)] = inst_22574__$1);

return statearr_22814;
})();
if(cljs.core.truth_(inst_22574__$1)){
var statearr_22815_23019 = state_22765__$1;
(statearr_22815_23019[(1)] = (91));

} else {
var statearr_22816_23020 = state_22765__$1;
(statearr_22816_23020[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (106))){
var inst_22595 = (state_22765[(32)]);
var inst_22629 = (state_22765[(2)]);
var inst_22630 = fluree.db.util.async.throw_err.call(null,inst_22629);
var inst_22631 = cljs.core.conj.call(null,inst_22595,inst_22630);
var state_22765__$1 = state_22765;
var statearr_22817_23021 = state_22765__$1;
(statearr_22817_23021[(2)] = inst_22631);

(statearr_22817_23021[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (119))){
var inst_22673 = (state_22765[(33)]);
var inst_22703 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22704 = [inst_22673,offset_map];
var inst_22705 = (new cljs.core.PersistentVector(null,2,(5),inst_22703,inst_22704,null));
var state_22765__$1 = state_22765;
var statearr_22818_23022 = state_22765__$1;
(statearr_22818_23022[(2)] = inst_22705);

(statearr_22818_23022[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (95))){
var inst_22381 = (state_22765[(17)]);
var state_22765__$1 = state_22765;
if(cljs.core.truth_(inst_22381)){
var statearr_22819_23023 = state_22765__$1;
(statearr_22819_23023[(1)] = (110));

} else {
var statearr_22820_23024 = state_22765__$1;
(statearr_22820_23024[(1)] = (111));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (54))){
var inst_22437 = (state_22765[(34)]);
var state_22765__$1 = state_22765;
var statearr_22821_23025 = state_22765__$1;
(statearr_22821_23025[(2)] = inst_22437);

(statearr_22821_23025[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (92))){
var inst_22574 = (state_22765[(31)]);
var state_22765__$1 = state_22765;
var statearr_22822_23026 = state_22765__$1;
(statearr_22822_23026[(2)] = inst_22574);

(statearr_22822_23026[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (104))){
var inst_22615 = (state_22765[(27)]);
var inst_22337 = (state_22765[(35)]);
var inst_22624 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298)];
var inst_22625 = [true,inst_22337];
var inst_22626 = cljs.core.PersistentHashMap.fromArrays(inst_22624,inst_22625);
var inst_22627 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22626,inst_22615);
var state_22765__$1 = state_22765;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22765__$1,(106),inst_22627);
} else {
if((state_val_22766 === (15))){
var inst_22337 = (state_22765[(35)]);
var inst_22360 = (state_22765[(36)]);
var inst_22364 = cljs.core.assoc.call(null,inst_22360,new cljs.core.Keyword(null,"compact?","compact?",1216893298),inst_22337);
var state_22765__$1 = state_22765;
var statearr_22823_23027 = state_22765__$1;
(statearr_22823_23027[(2)] = inst_22364);

(statearr_22823_23027[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (48))){
var inst_22431 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22432 = [null,offset_map];
var inst_22433 = (new cljs.core.PersistentVector(null,2,(5),inst_22431,inst_22432,null));
var state_22765__$1 = state_22765;
var statearr_22824_23028 = state_22765__$1;
(statearr_22824_23028[(2)] = inst_22433);

(statearr_22824_23028[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (50))){
var inst_22731 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
var statearr_22825_23029 = state_22765__$1;
(statearr_22825_23029[(2)] = inst_22731);

(statearr_22825_23029[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (116))){
var inst_22672 = (state_22765[(37)]);
var inst_22679 = (state_22765[(38)]);
var inst_22678 = cljs.core.seq.call(null,inst_22672);
var inst_22679__$1 = cljs.core.first.call(null,inst_22678);
var inst_22680 = cljs.core.next.call(null,inst_22678);
var state_22765__$1 = (function (){var statearr_22826 = state_22765;
(statearr_22826[(39)] = inst_22680);

(statearr_22826[(38)] = inst_22679__$1);

return statearr_22826;
})();
if(cljs.core.truth_(inst_22679__$1)){
var statearr_22827_23030 = state_22765__$1;
(statearr_22827_23030[(1)] = (118));

} else {
var statearr_22828_23031 = state_22765__$1;
(statearr_22828_23031[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (75))){
var inst_22472 = (state_22765[(25)]);
var inst_22502 = (state_22765[(2)]);
var inst_22464 = inst_22472;
var inst_22465 = inst_22502;
var state_22765__$1 = (function (){var statearr_22829 = state_22765;
(statearr_22829[(9)] = inst_22465);

(statearr_22829[(24)] = inst_22464);

return statearr_22829;
})();
var statearr_22830_23032 = state_22765__$1;
(statearr_22830_23032[(2)] = null);

(statearr_22830_23032[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (99))){
var inst_22367 = (state_22765[(14)]);
var inst_22601 = (state_22765[(40)]);
var inst_22604 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22605 = fluree.db.flake.o.call(null,inst_22601);
var inst_22606 = [inst_22605];
var inst_22607 = (new cljs.core.PersistentVector(null,1,(5),inst_22604,inst_22606,null));
var inst_22608 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_22609 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_22367);
var inst_22610 = [inst_22609];
var inst_22611 = cljs.core.PersistentHashMap.fromArrays(inst_22608,inst_22610);
var inst_22612 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22607,inst_22611);
var state_22765__$1 = state_22765;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22765__$1,(102),inst_22612);
} else {
if((state_val_22766 === (21))){
var inst_22371 = (state_22765[(41)]);
var state_22765__$1 = state_22765;
var statearr_22831_23033 = state_22765__$1;
(statearr_22831_23033[(2)] = inst_22371);

(statearr_22831_23033[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (31))){
var inst_22388 = (state_22765[(26)]);
var state_22765__$1 = state_22765;
var statearr_22832_23034 = state_22765__$1;
(statearr_22832_23034[(2)] = inst_22388);

(statearr_22832_23034[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (113))){
var inst_22380 = (state_22765[(13)]);
var inst_22382 = (state_22765[(16)]);
var inst_22367 = (state_22765[(14)]);
var inst_22381 = (state_22765[(17)]);
var inst_22384 = (state_22765[(18)]);
var inst_22385 = (state_22765[(19)]);
var inst_22379 = (state_22765[(15)]);
var inst_22378 = (state_22765[(20)]);
var inst_22337 = (state_22765[(35)]);
var inst_22383 = (state_22765[(21)]);
var inst_22352 = (state_22765[(42)]);
var inst_22654 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22655 = (function (){var map__22333 = inst_22379;
var p = inst_22385;
var pred_spec__$1 = inst_22352;
var orderBy = inst_22383;
var multi_QMARK_ = inst_22380;
var limit = inst_22382;
var offset = inst_22384;
var k = inst_22378;
var compact_QMARK_ = inst_22337;
var pred_spec_SINGLEQUOTE_ = inst_22367;
var ref_QMARK_ = inst_22381;
return (function (p1__22323_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"_id","_id",-789960287)],[fluree.db.flake.o.call(null,p1__22323_SHARP_)]);
});
})();
var inst_22656 = cljs.core.mapv.call(null,inst_22655,flakes);
var inst_22657 = [inst_22656,offset_map];
var inst_22658 = (new cljs.core.PersistentVector(null,2,(5),inst_22654,inst_22657,null));
var state_22765__$1 = state_22765;
var statearr_22833_23035 = state_22765__$1;
(statearr_22833_23035[(2)] = inst_22658);

(statearr_22833_23035[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (32))){
var inst_22394 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
var statearr_22834_23036 = state_22765__$1;
(statearr_22834_23036[(2)] = inst_22394);

(statearr_22834_23036[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (136))){
var inst_22756 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
var statearr_22835_23037 = state_22765__$1;
(statearr_22835_23037[(2)] = inst_22756);

(statearr_22835_23037[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (40))){
var inst_22380 = (state_22765[(13)]);
var state_22765__$1 = state_22765;
var statearr_22836_23038 = state_22765__$1;
(statearr_22836_23038[(2)] = inst_22380);

(statearr_22836_23038[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (129))){
var inst_22380 = (state_22765[(13)]);
var state_22765__$1 = state_22765;
if(cljs.core.truth_(inst_22380)){
var statearr_22837_23039 = state_22765__$1;
(statearr_22837_23039[(1)] = (131));

} else {
var statearr_22838_23040 = state_22765__$1;
(statearr_22838_23040[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (91))){
var inst_22367 = (state_22765[(14)]);
var inst_22576 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_22367);
var state_22765__$1 = state_22765;
var statearr_22839_23041 = state_22765__$1;
(statearr_22839_23041[(2)] = inst_22576);

(statearr_22839_23041[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (117))){
var inst_22709 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
var statearr_22840_23042 = state_22765__$1;
(statearr_22840_23042[(2)] = inst_22709);

(statearr_22840_23042[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (108))){
var state_22765__$1 = state_22765;
var statearr_22841_23043 = state_22765__$1;
(statearr_22841_23043[(2)] = null);

(statearr_22841_23043[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (56))){
var inst_22442 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
var statearr_22842_23044 = state_22765__$1;
(statearr_22842_23044[(2)] = inst_22442);

(statearr_22842_23044[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (33))){
var inst_22385 = (state_22765[(19)]);
var inst_22402 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22403 = cljs.core.get.call(null,offset_map,inst_22385);
var state_22765__$1 = (function (){var statearr_22843 = state_22765;
(statearr_22843[(43)] = inst_22402);

return statearr_22843;
})();
if(cljs.core.truth_(inst_22403)){
var statearr_22844_23045 = state_22765__$1;
(statearr_22844_23045[(1)] = (36));

} else {
var statearr_22845_23046 = state_22765__$1;
(statearr_22845_23046[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (13))){
var inst_22352 = (state_22765[(42)]);
var state_22765__$1 = state_22765;
var statearr_22846_23047 = state_22765__$1;
(statearr_22846_23047[(2)] = inst_22352);

(statearr_22846_23047[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (22))){
var inst_22367 = (state_22765[(14)]);
var inst_22374 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22367);
var state_22765__$1 = state_22765;
var statearr_22847_23048 = state_22765__$1;
(statearr_22847_23048[(2)] = inst_22374);

(statearr_22847_23048[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (90))){
var inst_22535 = (state_22765[(44)]);
var inst_22564 = (state_22765[(2)]);
var inst_22527 = inst_22535;
var inst_22528 = inst_22564;
var state_22765__$1 = (function (){var statearr_22848 = state_22765;
(statearr_22848[(30)] = inst_22528);

(statearr_22848[(45)] = inst_22527);

return statearr_22848;
})();
var statearr_22849_23049 = state_22765__$1;
(statearr_22849_23049[(2)] = null);

(statearr_22849_23049[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (109))){
var inst_22602 = (state_22765[(46)]);
var inst_22633 = (state_22765[(47)]);
var inst_22639 = (state_22765[(2)]);
var inst_22594 = inst_22602;
var inst_22595 = inst_22633;
var state_22765__$1 = (function (){var statearr_22850 = state_22765;
(statearr_22850[(32)] = inst_22595);

(statearr_22850[(48)] = inst_22594);

(statearr_22850[(49)] = inst_22639);

return statearr_22850;
})();
var statearr_22851_23050 = state_22765__$1;
(statearr_22851_23050[(2)] = null);

(statearr_22851_23050[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (36))){
var inst_22385 = (state_22765[(19)]);
var inst_22405 = cljs.core.update.call(null,offset_map,inst_22385,cljs.core.dec);
var state_22765__$1 = state_22765;
var statearr_22852_23051 = state_22765__$1;
(statearr_22852_23051[(2)] = inst_22405);

(statearr_22852_23051[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (41))){
var inst_22429 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
if(cljs.core.truth_(inst_22429)){
var statearr_22853_23052 = state_22765__$1;
(statearr_22853_23052[(1)] = (48));

} else {
var statearr_22854_23053 = state_22765__$1;
(statearr_22854_23053[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (118))){
var inst_22679 = (state_22765[(38)]);
var inst_22682 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22683 = fluree.db.flake.o.call(null,inst_22679);
var inst_22684 = [inst_22683];
var inst_22685 = (new cljs.core.PersistentVector(null,1,(5),inst_22682,inst_22684,null));
var inst_22686 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22685);
var state_22765__$1 = state_22765;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22765__$1,(121),inst_22686);
} else {
if((state_val_22766 === (89))){
var inst_22528 = (state_22765[(30)]);
var state_22765__$1 = state_22765;
var statearr_22855_23054 = state_22765__$1;
(statearr_22855_23054[(2)] = inst_22528);

(statearr_22855_23054[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (100))){
var inst_22595 = (state_22765[(32)]);
var state_22765__$1 = state_22765;
var statearr_22856_23055 = state_22765__$1;
(statearr_22856_23055[(2)] = inst_22595);

(statearr_22856_23055[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (131))){
var inst_22734 = (state_22765[(50)]);
var inst_22378 = (state_22765[(20)]);
var inst_22735 = (state_22765[(10)]);
var inst_22743 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22744 = cljs.core.assoc.call(null,acc,inst_22378,inst_22734);
var inst_22745 = [inst_22744,inst_22735];
var inst_22746 = (new cljs.core.PersistentVector(null,2,(5),inst_22743,inst_22745,null));
var state_22765__$1 = state_22765;
var statearr_22857_23056 = state_22765__$1;
(statearr_22857_23056[(2)] = inst_22746);

(statearr_22857_23056[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (122))){
var inst_22680 = (state_22765[(39)]);
var inst_22673 = (state_22765[(33)]);
var inst_22679 = (state_22765[(38)]);
var inst_22692 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22693 = fluree.db.flake.o.call(null,inst_22679);
var inst_22694 = [inst_22693];
var inst_22695 = cljs.core.PersistentHashMap.fromArrays(inst_22692,inst_22694);
var inst_22696 = cljs.core.conj.call(null,inst_22673,inst_22695);
var inst_22672 = inst_22680;
var inst_22673__$1 = inst_22696;
var state_22765__$1 = (function (){var statearr_22858 = state_22765;
(statearr_22858[(37)] = inst_22672);

(statearr_22858[(33)] = inst_22673__$1);

return statearr_22858;
})();
var statearr_22859_23057 = state_22765__$1;
(statearr_22859_23057[(2)] = null);

(statearr_22859_23057[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (43))){
var inst_22415 = (state_22765[(29)]);
var state_22765__$1 = state_22765;
var statearr_22860_23058 = state_22765__$1;
(statearr_22860_23058[(2)] = inst_22415);

(statearr_22860_23058[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (61))){
var inst_22451 = (state_22765[(51)]);
var inst_22508 = (state_22765[(2)]);
var inst_22509 = [inst_22508,offset_map];
var inst_22510 = (new cljs.core.PersistentVector(null,2,(5),inst_22451,inst_22509,null));
var state_22765__$1 = state_22765;
var statearr_22861_23059 = state_22765__$1;
(statearr_22861_23059[(2)] = inst_22510);

(statearr_22861_23059[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (29))){
var inst_22397 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
var statearr_22862_23060 = state_22765__$1;
(statearr_22862_23060[(2)] = inst_22397);

(statearr_22862_23060[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (44))){
var inst_22426 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
var statearr_22863_23061 = state_22765__$1;
(statearr_22863_23061[(2)] = inst_22426);

(statearr_22863_23061[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (93))){
var inst_22579 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
if(cljs.core.truth_(inst_22579)){
var statearr_22864_23062 = state_22765__$1;
(statearr_22864_23062[(1)] = (94));

} else {
var statearr_22865_23063 = state_22765__$1;
(statearr_22865_23063[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (6))){
var inst_22340 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22341 = (inst_22340 == null);
var state_22765__$1 = state_22765;
var statearr_22866_23064 = state_22765__$1;
(statearr_22866_23064[(2)] = inst_22341);

(statearr_22866_23064[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (111))){
var state_22765__$1 = state_22765;
var statearr_22867_23065 = state_22765__$1;
(statearr_22867_23065[(1)] = (125));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (28))){
var inst_22384 = (state_22765[(18)]);
var state_22765__$1 = state_22765;
var statearr_22869_23066 = state_22765__$1;
(statearr_22869_23066[(2)] = inst_22384);

(statearr_22869_23066[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (134))){
var inst_22734 = (state_22765[(50)]);
var inst_22378 = (state_22765[(20)]);
var inst_22735 = (state_22765[(10)]);
var inst_22749 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22750 = cljs.core.first.call(null,inst_22734);
var inst_22751 = cljs.core.assoc.call(null,acc,inst_22378,inst_22750);
var inst_22752 = [inst_22751,inst_22735];
var inst_22753 = (new cljs.core.PersistentVector(null,2,(5),inst_22749,inst_22752,null));
var state_22765__$1 = state_22765;
var statearr_22870_23067 = state_22765__$1;
(statearr_22870_23067[(2)] = inst_22753);

(statearr_22870_23067[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (64))){
var inst_22506 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
var statearr_22871_23068 = state_22765__$1;
(statearr_22871_23068[(2)] = inst_22506);

(statearr_22871_23068[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (103))){
var inst_22595 = (state_22765[(32)]);
var inst_22601 = (state_22765[(40)]);
var inst_22618 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22619 = fluree.db.flake.o.call(null,inst_22601);
var inst_22620 = [inst_22619];
var inst_22621 = cljs.core.PersistentHashMap.fromArrays(inst_22618,inst_22620);
var inst_22622 = cljs.core.conj.call(null,inst_22595,inst_22621);
var state_22765__$1 = state_22765;
var statearr_22872_23069 = state_22765__$1;
(statearr_22872_23069[(2)] = inst_22622);

(statearr_22872_23069[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (51))){
var inst_22367 = (state_22765[(14)]);
var inst_22437 = (state_22765[(34)]);
var inst_22437__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_22367);
var state_22765__$1 = (function (){var statearr_22873 = state_22765;
(statearr_22873[(34)] = inst_22437__$1);

return statearr_22873;
})();
if(cljs.core.truth_(inst_22437__$1)){
var statearr_22874_23070 = state_22765__$1;
(statearr_22874_23070[(1)] = (54));

} else {
var statearr_22875_23071 = state_22765__$1;
(statearr_22875_23071[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (25))){
var inst_22380 = (state_22765[(13)]);
var state_22765__$1 = state_22765;
var statearr_22876_23072 = state_22765__$1;
(statearr_22876_23072[(2)] = inst_22380);

(statearr_22876_23072[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (34))){
var inst_22380 = (state_22765[(13)]);
var state_22765__$1 = state_22765;
if(cljs.core.truth_(inst_22380)){
var statearr_22877_23073 = state_22765__$1;
(statearr_22877_23073[(1)] = (39));

} else {
var statearr_22878_23074 = state_22765__$1;
(statearr_22878_23074[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (125))){
var inst_22380 = (state_22765[(13)]);
var inst_22382 = (state_22765[(16)]);
var inst_22367 = (state_22765[(14)]);
var inst_22381 = (state_22765[(17)]);
var inst_22384 = (state_22765[(18)]);
var inst_22385 = (state_22765[(19)]);
var inst_22379 = (state_22765[(15)]);
var inst_22378 = (state_22765[(20)]);
var inst_22337 = (state_22765[(35)]);
var inst_22383 = (state_22765[(21)]);
var inst_22352 = (state_22765[(42)]);
var inst_22714 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22715 = (function (){var map__22333 = inst_22379;
var p = inst_22385;
var pred_spec__$1 = inst_22352;
var orderBy = inst_22383;
var multi_QMARK_ = inst_22380;
var limit = inst_22382;
var offset = inst_22384;
var k = inst_22378;
var compact_QMARK_ = inst_22337;
var pred_spec_SINGLEQUOTE_ = inst_22367;
var ref_QMARK_ = inst_22381;
return (function (p1__22324_SHARP_){
return fluree.db.flake.o.call(null,p1__22324_SHARP_);
});
})();
var inst_22716 = cljs.core.mapv.call(null,inst_22715,flakes);
var inst_22717 = [inst_22716,offset_map];
var inst_22718 = (new cljs.core.PersistentVector(null,2,(5),inst_22714,inst_22717,null));
var state_22765__$1 = state_22765;
var statearr_22879_23075 = state_22765__$1;
(statearr_22879_23075[(2)] = inst_22718);

(statearr_22879_23075[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (17))){
var inst_22368 = (state_22765[(52)]);
var inst_22367 = (state_22765[(14)]);
var inst_22367__$1 = (state_22765[(2)]);
var inst_22368__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_22367__$1);
var state_22765__$1 = (function (){var statearr_22880 = state_22765;
(statearr_22880[(52)] = inst_22368__$1);

(statearr_22880[(14)] = inst_22367__$1);

return statearr_22880;
})();
if(cljs.core.truth_(inst_22368__$1)){
var statearr_22881_23076 = state_22765__$1;
(statearr_22881_23076[(1)] = (18));

} else {
var statearr_22882_23077 = state_22765__$1;
(statearr_22882_23077[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (3))){
var inst_22763 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22765__$1,inst_22763);
} else {
if((state_val_22766 === (12))){
var inst_22352 = (state_22765[(42)]);
var inst_22357 = cljs.core.assoc.call(null,inst_22352,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_22765__$1 = state_22765;
var statearr_22883_23078 = state_22765__$1;
(statearr_22883_23078[(2)] = inst_22357);

(statearr_22883_23078[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (2))){
var inst_22338 = (state_22765[(11)]);
var _ = (function (){var statearr_22884 = state_22765;
(statearr_22884[(4)] = cljs.core.cons.call(null,(5),(state_22765[(4)])));

return statearr_22884;
})();
var inst_22337 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22338__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_22765__$1 = (function (){var statearr_22885 = state_22765;
(statearr_22885[(11)] = inst_22338__$1);

(statearr_22885[(35)] = inst_22337);

return statearr_22885;
})();
if(cljs.core.truth_(inst_22338__$1)){
var statearr_22886_23079 = state_22765__$1;
(statearr_22886_23079[(1)] = (6));

} else {
var statearr_22887_23080 = state_22765__$1;
(statearr_22887_23080[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (66))){
var inst_22481 = (state_22765[(7)]);
var inst_22450 = (state_22765[(53)]);
var inst_22484 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22450,inst_22481);
var state_22765__$1 = state_22765;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22765__$1,(69),inst_22484);
} else {
if((state_val_22766 === (107))){
var inst_22615 = (state_22765[(27)]);
var inst_22635 = cljs.core.count.call(null,inst_22615);
var inst_22636 = fluree.db.query.fql_resp.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_22635);
var state_22765__$1 = state_22765;
var statearr_22888_23081 = state_22765__$1;
(statearr_22888_23081[(2)] = inst_22636);

(statearr_22888_23081[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (23))){
var inst_22376 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
var statearr_22889_23082 = state_22765__$1;
(statearr_22889_23082[(2)] = inst_22376);

(statearr_22889_23082[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (47))){
var inst_22423 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
var statearr_22890_23083 = state_22765__$1;
(statearr_22890_23083[(2)] = inst_22423);

(statearr_22890_23083[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (35))){
var inst_22734 = (state_22765[(50)]);
var inst_22733 = (state_22765[(2)]);
var inst_22734__$1 = cljs.core.nth.call(null,inst_22733,(0),null);
var inst_22735 = cljs.core.nth.call(null,inst_22733,(1),null);
var inst_22736 = cljs.core.empty_QMARK_.call(null,inst_22734__$1);
var state_22765__$1 = (function (){var statearr_22891 = state_22765;
(statearr_22891[(50)] = inst_22734__$1);

(statearr_22891[(10)] = inst_22735);

return statearr_22891;
})();
if(inst_22736){
var statearr_22892_23084 = state_22765__$1;
(statearr_22892_23084[(1)] = (128));

} else {
var statearr_22893_23085 = state_22765__$1;
(statearr_22893_23085[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (127))){
var inst_22721 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
var statearr_22894_23086 = state_22765__$1;
(statearr_22894_23086[(2)] = inst_22721);

(statearr_22894_23086[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (82))){
var inst_22528 = (state_22765[(30)]);
var state_22765__$1 = state_22765;
var statearr_22895_23087 = state_22765__$1;
(statearr_22895_23087[(2)] = inst_22528);

(statearr_22895_23087[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (76))){
var inst_22514 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22522 = flakes;
var inst_22523 = cljs.core.seq.call(null,inst_22522);
var inst_22524 = cljs.core.first.call(null,inst_22523);
var inst_22525 = cljs.core.next.call(null,inst_22523);
var inst_22526 = cljs.core.PersistentVector.EMPTY;
var inst_22527 = inst_22522;
var inst_22528 = inst_22526;
var state_22765__$1 = (function (){var statearr_22896 = state_22765;
(statearr_22896[(30)] = inst_22528);

(statearr_22896[(54)] = inst_22514);

(statearr_22896[(45)] = inst_22527);

(statearr_22896[(55)] = inst_22524);

(statearr_22896[(56)] = inst_22525);

return statearr_22896;
})();
var statearr_22897_23088 = state_22765__$1;
(statearr_22897_23088[(2)] = null);

(statearr_22897_23088[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (97))){
var inst_22601 = (state_22765[(40)]);
var inst_22594 = (state_22765[(48)]);
var inst_22600 = cljs.core.seq.call(null,inst_22594);
var inst_22601__$1 = cljs.core.first.call(null,inst_22600);
var inst_22602 = cljs.core.next.call(null,inst_22600);
var state_22765__$1 = (function (){var statearr_22898 = state_22765;
(statearr_22898[(46)] = inst_22602);

(statearr_22898[(40)] = inst_22601__$1);

return statearr_22898;
})();
if(cljs.core.truth_(inst_22601__$1)){
var statearr_22899_23089 = state_22765__$1;
(statearr_22899_23089[(1)] = (99));

} else {
var statearr_22900_23090 = state_22765__$1;
(statearr_22900_23090[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (19))){
var inst_22367 = (state_22765[(14)]);
var inst_22371 = (state_22765[(41)]);
var inst_22371__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22367);
var state_22765__$1 = (function (){var statearr_22901 = state_22765;
(statearr_22901[(41)] = inst_22371__$1);

return statearr_22901;
})();
if(cljs.core.truth_(inst_22371__$1)){
var statearr_22902_23091 = state_22765__$1;
(statearr_22902_23091[(1)] = (21));

} else {
var statearr_22903_23092 = state_22765__$1;
(statearr_22903_23092[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (57))){
var inst_22367 = (state_22765[(14)]);
var inst_22447 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22448 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_22449 = (new cljs.core.PersistentVector(null,3,(5),inst_22447,inst_22448,null));
var inst_22450 = cljs.core.select_keys.call(null,inst_22367,inst_22449);
var inst_22451 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22459 = flakes;
var inst_22460 = cljs.core.seq.call(null,inst_22459);
var inst_22461 = cljs.core.first.call(null,inst_22460);
var inst_22462 = cljs.core.next.call(null,inst_22460);
var inst_22463 = cljs.core.PersistentVector.EMPTY;
var inst_22464 = inst_22459;
var inst_22465 = inst_22463;
var state_22765__$1 = (function (){var statearr_22904 = state_22765;
(statearr_22904[(53)] = inst_22450);

(statearr_22904[(9)] = inst_22465);

(statearr_22904[(57)] = inst_22462);

(statearr_22904[(58)] = inst_22461);

(statearr_22904[(51)] = inst_22451);

(statearr_22904[(24)] = inst_22464);

return statearr_22904;
})();
var statearr_22905_23093 = state_22765__$1;
(statearr_22905_23093[(2)] = null);

(statearr_22905_23093[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (68))){
var inst_22490 = (state_22765[(2)]);
var state_22765__$1 = (function (){var statearr_22906 = state_22765;
(statearr_22906[(22)] = inst_22490);

return statearr_22906;
})();
if(cljs.core.truth_(fuel)){
var statearr_22907_23094 = state_22765__$1;
(statearr_22907_23094[(1)] = (70));

} else {
var statearr_22908_23095 = state_22765__$1;
(statearr_22908_23095[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (11))){
var inst_22352 = (state_22765[(42)]);
var inst_22352__$1 = (state_22765[(2)]);
var inst_22354 = cljs.core.contains_QMARK_.call(null,inst_22352__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var inst_22355 = (!(inst_22354));
var state_22765__$1 = (function (){var statearr_22909 = state_22765;
(statearr_22909[(42)] = inst_22352__$1);

return statearr_22909;
})();
if(inst_22355){
var statearr_22910_23096 = state_22765__$1;
(statearr_22910_23096[(1)] = (12));

} else {
var statearr_22911_23097 = state_22765__$1;
(statearr_22911_23097[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (115))){
var inst_22711 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
var statearr_22913_23098 = state_22765__$1;
(statearr_22913_23098[(2)] = inst_22711);

(statearr_22913_23098[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (9))){
var inst_22346 = cljs.core.first.call(null,flakes);
var inst_22347 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22346);
var inst_22348 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22349 = fluree.db.query.fql_resp.wildcard_pred_spec.call(null,db,cache,inst_22347,inst_22348);
var state_22765__$1 = state_22765;
var statearr_22914_23099 = state_22765__$1;
(statearr_22914_23099[(2)] = inst_22349);

(statearr_22914_23099[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (5))){
var _ = (function (){var statearr_22915 = state_22765;
(statearr_22915[(4)] = cljs.core.rest.call(null,(state_22765[(4)])));

return statearr_22915;
})();
var state_22765__$1 = state_22765;
var ex22912 = (state_22765__$1[(2)]);
var statearr_22916_23100 = state_22765__$1;
(statearr_22916_23100[(5)] = ex22912);


if((ex22912 instanceof Error)){
var statearr_22917_23101 = state_22765__$1;
(statearr_22917_23101[(1)] = (4));

(statearr_22917_23101[(5)] = null);

} else {
throw ex22912;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (112))){
var inst_22723 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
var statearr_22918_23102 = state_22765__$1;
(statearr_22918_23102[(2)] = inst_22723);

(statearr_22918_23102[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (83))){
var inst_22568 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
var statearr_22919_23103 = state_22765__$1;
(statearr_22919_23103[(2)] = inst_22568);

(statearr_22919_23103[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (14))){
var inst_22352 = (state_22765[(42)]);
var inst_22360 = (state_22765[(2)]);
var inst_22361 = cljs.core.contains_QMARK_.call(null,inst_22352,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var inst_22362 = (!(inst_22361));
var state_22765__$1 = (function (){var statearr_22920 = state_22765;
(statearr_22920[(36)] = inst_22360);

return statearr_22920;
})();
if(inst_22362){
var statearr_22921_23104 = state_22765__$1;
(statearr_22921_23104[(1)] = (15));

} else {
var statearr_22922_23105 = state_22765__$1;
(statearr_22922_23105[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (45))){
var inst_22382 = (state_22765[(16)]);
var inst_22378 = (state_22765[(20)]);
var inst_22418 = cljs.core.get.call(null,acc,inst_22378);
var inst_22419 = cljs.core.count.call(null,inst_22418);
var inst_22420 = (inst_22419 >= inst_22382);
var state_22765__$1 = state_22765;
var statearr_22923_23106 = state_22765__$1;
(statearr_22923_23106[(2)] = inst_22420);

(statearr_22923_23106[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (53))){
var inst_22445 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
if(cljs.core.truth_(inst_22445)){
var statearr_22924_23107 = state_22765__$1;
(statearr_22924_23107[(1)] = (57));

} else {
var statearr_22925_23108 = state_22765__$1;
(statearr_22925_23108[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (78))){
var inst_22727 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
var statearr_22926_23109 = state_22765__$1;
(statearr_22926_23109[(2)] = inst_22727);

(statearr_22926_23109[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (132))){
var state_22765__$1 = state_22765;
var statearr_22928_23110 = state_22765__$1;
(statearr_22928_23110[(1)] = (134));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (26))){
var inst_22400 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
if(cljs.core.truth_(inst_22400)){
var statearr_22930_23111 = state_22765__$1;
(statearr_22930_23111[(1)] = (33));

} else {
var statearr_22931_23112 = state_22765__$1;
(statearr_22931_23112[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (123))){
var inst_22680 = (state_22765[(39)]);
var inst_22673 = (state_22765[(33)]);
var tmp22927 = inst_22673;
var inst_22672 = inst_22680;
var inst_22673__$1 = tmp22927;
var state_22765__$1 = (function (){var statearr_22932 = state_22765;
(statearr_22932[(37)] = inst_22672);

(statearr_22932[(33)] = inst_22673__$1);

return statearr_22932;
})();
var statearr_22933_23113 = state_22765__$1;
(statearr_22933_23113[(2)] = null);

(statearr_22933_23113[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (16))){
var inst_22360 = (state_22765[(36)]);
var state_22765__$1 = state_22765;
var statearr_22934_23114 = state_22765__$1;
(statearr_22934_23114[(2)] = inst_22360);

(statearr_22934_23114[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (133))){
var inst_22758 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
var statearr_22935_23115 = state_22765__$1;
(statearr_22935_23115[(2)] = inst_22758);

(statearr_22935_23115[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (81))){
var inst_22534 = (state_22765[(28)]);
var inst_22367 = (state_22765[(14)]);
var inst_22543 = (state_22765[(59)]);
var inst_22537 = cljs.core.deref.call(null,cache);
var inst_22538 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22539 = fluree.db.flake.o.call(null,inst_22534);
var inst_22540 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22367);
var inst_22541 = [inst_22539,inst_22540];
var inst_22542 = (new cljs.core.PersistentVector(null,2,(5),inst_22538,inst_22541,null));
var inst_22543__$1 = cljs.core.get.call(null,inst_22537,inst_22542);
var state_22765__$1 = (function (){var statearr_22936 = state_22765;
(statearr_22936[(59)] = inst_22543__$1);

return statearr_22936;
})();
if(cljs.core.truth_(inst_22543__$1)){
var statearr_22937_23116 = state_22765__$1;
(statearr_22937_23116[(1)] = (84));

} else {
var statearr_22938_23117 = state_22765__$1;
(statearr_22938_23117[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (120))){
var inst_22707 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
var statearr_22939_23118 = state_22765__$1;
(statearr_22939_23118[(2)] = inst_22707);

(statearr_22939_23118[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (79))){
var inst_22534 = (state_22765[(28)]);
var inst_22527 = (state_22765[(45)]);
var inst_22533 = cljs.core.seq.call(null,inst_22527);
var inst_22534__$1 = cljs.core.first.call(null,inst_22533);
var inst_22535 = cljs.core.next.call(null,inst_22533);
var state_22765__$1 = (function (){var statearr_22940 = state_22765;
(statearr_22940[(28)] = inst_22534__$1);

(statearr_22940[(44)] = inst_22535);

return statearr_22940;
})();
if(cljs.core.truth_(inst_22534__$1)){
var statearr_22941_23119 = state_22765__$1;
(statearr_22941_23119[(1)] = (81));

} else {
var statearr_22942_23120 = state_22765__$1;
(statearr_22942_23120[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (38))){
var inst_22402 = (state_22765[(43)]);
var inst_22410 = (state_22765[(2)]);
var inst_22411 = [null,inst_22410];
var inst_22412 = (new cljs.core.PersistentVector(null,2,(5),inst_22402,inst_22411,null));
var state_22765__$1 = state_22765;
var statearr_22943_23121 = state_22765__$1;
(statearr_22943_23121[(2)] = inst_22412);

(statearr_22943_23121[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (126))){
var state_22765__$1 = state_22765;
var statearr_22944_23122 = state_22765__$1;
(statearr_22944_23122[(2)] = null);

(statearr_22944_23122[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (98))){
var inst_22581 = (state_22765[(60)]);
var inst_22645 = (state_22765[(2)]);
var inst_22646 = [inst_22645,offset_map];
var inst_22647 = (new cljs.core.PersistentVector(null,2,(5),inst_22581,inst_22646,null));
var state_22765__$1 = state_22765;
var statearr_22945_23123 = state_22765__$1;
(statearr_22945_23123[(2)] = inst_22647);

(statearr_22945_23123[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (124))){
var inst_22701 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
var statearr_22946_23124 = state_22765__$1;
(statearr_22946_23124[(2)] = inst_22701);

(statearr_22946_23124[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (87))){
var inst_22534 = (state_22765[(28)]);
var inst_22367 = (state_22765[(14)]);
var inst_22550 = (state_22765[(2)]);
var inst_22551 = fluree.db.util.async.throw_err.call(null,inst_22550);
var inst_22552 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22553 = fluree.db.flake.o.call(null,inst_22534);
var inst_22554 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22367);
var inst_22555 = [inst_22553,inst_22554];
var inst_22556 = (new cljs.core.PersistentVector(null,2,(5),inst_22552,inst_22555,null));
var inst_22557 = fluree.db.query.fql_resp.vswap_BANG_.call(null,cache,cljs.core.assoc,inst_22556,inst_22551);
var state_22765__$1 = (function (){var statearr_22947 = state_22765;
(statearr_22947[(61)] = inst_22557);

return statearr_22947;
})();
var statearr_22948_23125 = state_22765__$1;
(statearr_22948_23125[(2)] = inst_22551);

(statearr_22948_23125[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (30))){
var inst_22385 = (state_22765[(19)]);
var inst_22390 = cljs.core.get.call(null,offset_map,inst_22385);
var inst_22391 = cljs.core.not_EQ_.call(null,(0),inst_22390);
var state_22765__$1 = state_22765;
var statearr_22949_23126 = state_22765__$1;
(statearr_22949_23126[(2)] = inst_22391);

(statearr_22949_23126[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (73))){
var inst_22465 = (state_22765[(9)]);
var inst_22490 = (state_22765[(22)]);
var inst_22499 = cljs.core.conj.call(null,inst_22465,inst_22490);
var state_22765__$1 = state_22765;
var statearr_22950_23127 = state_22765__$1;
(statearr_22950_23127[(2)] = inst_22499);

(statearr_22950_23127[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (96))){
var inst_22725 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
var statearr_22951_23128 = state_22765__$1;
(statearr_22951_23128[(2)] = inst_22725);

(statearr_22951_23128[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (10))){
var state_22765__$1 = state_22765;
var statearr_22952_23129 = state_22765__$1;
(statearr_22952_23129[(2)] = pred_spec);

(statearr_22952_23129[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (18))){
var inst_22368 = (state_22765[(52)]);
var state_22765__$1 = state_22765;
var statearr_22953_23130 = state_22765__$1;
(statearr_22953_23130[(2)] = inst_22368);

(statearr_22953_23130[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (105))){
var inst_22633 = (state_22765[(2)]);
var state_22765__$1 = (function (){var statearr_22954 = state_22765;
(statearr_22954[(47)] = inst_22633);

return statearr_22954;
})();
if(cljs.core.truth_(fuel)){
var statearr_22955_23131 = state_22765__$1;
(statearr_22955_23131[(1)] = (107));

} else {
var statearr_22956_23132 = state_22765__$1;
(statearr_22956_23132[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (52))){
var inst_22435 = (state_22765[(62)]);
var state_22765__$1 = state_22765;
var statearr_22957_23133 = state_22765__$1;
(statearr_22957_23133[(2)] = inst_22435);

(statearr_22957_23133[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (114))){
var inst_22667 = flakes;
var inst_22668 = cljs.core.seq.call(null,inst_22667);
var inst_22669 = cljs.core.first.call(null,inst_22668);
var inst_22670 = cljs.core.next.call(null,inst_22668);
var inst_22671 = cljs.core.PersistentVector.EMPTY;
var inst_22672 = inst_22667;
var inst_22673 = inst_22671;
var state_22765__$1 = (function (){var statearr_22958 = state_22765;
(statearr_22958[(37)] = inst_22672);

(statearr_22958[(33)] = inst_22673);

(statearr_22958[(63)] = inst_22670);

(statearr_22958[(64)] = inst_22669);

return statearr_22958;
})();
var statearr_22959_23134 = state_22765__$1;
(statearr_22959_23134[(2)] = null);

(statearr_22959_23134[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (67))){
var state_22765__$1 = state_22765;
var statearr_22960_23135 = state_22765__$1;
(statearr_22960_23135[(2)] = null);

(statearr_22960_23135[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (71))){
var state_22765__$1 = state_22765;
var statearr_22961_23136 = state_22765__$1;
(statearr_22961_23136[(2)] = null);

(statearr_22961_23136[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (42))){
var inst_22382 = (state_22765[(16)]);
var state_22765__$1 = state_22765;
if(cljs.core.truth_(inst_22382)){
var statearr_22962_23137 = state_22765__$1;
(statearr_22962_23137[(1)] = (45));

} else {
var statearr_22963_23138 = state_22765__$1;
(statearr_22963_23138[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (80))){
var inst_22514 = (state_22765[(54)]);
var inst_22570 = (state_22765[(2)]);
var inst_22571 = [inst_22570,offset_map];
var inst_22572 = (new cljs.core.PersistentVector(null,2,(5),inst_22514,inst_22571,null));
var state_22765__$1 = state_22765;
var statearr_22964_23139 = state_22765__$1;
(statearr_22964_23139[(2)] = inst_22572);

(statearr_22964_23139[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (37))){
var inst_22384 = (state_22765[(18)]);
var inst_22385 = (state_22765[(19)]);
var inst_22407 = (inst_22384 - (1));
var inst_22408 = cljs.core.assoc.call(null,offset_map,inst_22385,inst_22407);
var state_22765__$1 = state_22765;
var statearr_22965_23140 = state_22765__$1;
(statearr_22965_23140[(2)] = inst_22408);

(statearr_22965_23140[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (63))){
var inst_22465 = (state_22765[(9)]);
var state_22765__$1 = state_22765;
var statearr_22966_23141 = state_22765__$1;
(statearr_22966_23141[(2)] = inst_22465);

(statearr_22966_23141[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (94))){
var inst_22581 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22589 = flakes;
var inst_22590 = cljs.core.seq.call(null,inst_22589);
var inst_22591 = cljs.core.first.call(null,inst_22590);
var inst_22592 = cljs.core.next.call(null,inst_22590);
var inst_22593 = cljs.core.PersistentVector.EMPTY;
var inst_22594 = inst_22589;
var inst_22595 = inst_22593;
var state_22765__$1 = (function (){var statearr_22967 = state_22765;
(statearr_22967[(32)] = inst_22595);

(statearr_22967[(48)] = inst_22594);

(statearr_22967[(65)] = inst_22592);

(statearr_22967[(66)] = inst_22591);

(statearr_22967[(60)] = inst_22581);

return statearr_22967;
})();
var statearr_22968_23142 = state_22765__$1;
(statearr_22968_23142[(2)] = null);

(statearr_22968_23142[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (8))){
var inst_22344 = (state_22765[(2)]);
var state_22765__$1 = state_22765;
if(cljs.core.truth_(inst_22344)){
var statearr_22969_23143 = state_22765__$1;
(statearr_22969_23143[(1)] = (9));

} else {
var statearr_22970_23144 = state_22765__$1;
(statearr_22970_23144[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (49))){
var inst_22435 = (state_22765[(62)]);
var inst_22435__$1 = cljs.core.not.call(null,recur_QMARK_);
var state_22765__$1 = (function (){var statearr_22971 = state_22765;
(statearr_22971[(62)] = inst_22435__$1);

return statearr_22971;
})();
if(inst_22435__$1){
var statearr_22972_23145 = state_22765__$1;
(statearr_22972_23145[(1)] = (51));

} else {
var statearr_22973_23146 = state_22765__$1;
(statearr_22973_23146[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22766 === (84))){
var inst_22543 = (state_22765[(59)]);
var state_22765__$1 = state_22765;
var statearr_22974_23147 = state_22765__$1;
(statearr_22974_23147[(2)] = inst_22543);

(statearr_22974_23147[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$state_machine__2746__auto__ = null;
var fluree$db$query$fql_resp$state_machine__2746__auto____0 = (function (){
var statearr_22975 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22975[(0)] = fluree$db$query$fql_resp$state_machine__2746__auto__);

(statearr_22975[(1)] = (1));

return statearr_22975;
});
var fluree$db$query$fql_resp$state_machine__2746__auto____1 = (function (state_22765){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_22765);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e22976){var ex__2749__auto__ = e22976;
var statearr_22977_23148 = state_22765;
(statearr_22977_23148[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_22765[(4)]))){
var statearr_22978_23149 = state_22765;
(statearr_22978_23149[(1)] = cljs.core.first.call(null,(state_22765[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23150 = state_22765;
state_22765 = G__23150;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql_resp$state_machine__2746__auto__ = function(state_22765){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$state_machine__2746__auto____1.call(this,state_22765);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$state_machine__2746__auto____0;
fluree$db$query$fql_resp$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$state_machine__2746__auto____1;
return fluree$db$query$fql_resp$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_22979 = f__2769__auto__.call(null);
(statearr_22979[(6)] = c__2768__auto__);

return statearr_22979;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.fql_resp.add_pred.cljs$lang$maxFixedArity = 10);

fluree.db.query.fql_resp.compare_fn = (function fluree$db$query$fql_resp$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare.call(null,clojure.string.upper_case.call(null,a),clojure.string.upper_case.call(null,b));
if(cljs.core._EQ_.call(null,res,(0))){
return ((-1) * cljs.core.compare.call(null,a,b));
} else {
return res;
}
} else {
return cljs.core.compare.call(null,a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql_resp.sort_offset_and_limit_res = (function fluree$db$query$fql_resp$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_.call(null,res)){
var G__23152 = res;
var G__23152__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.call(null,(function (p1__23151_SHARP_){
return cljs.core.get.call(null,p1__23151_SHARP_,sortPred);
}),fluree.db.query.fql_resp.compare_fn,G__23152):G__23152);
var G__23152__$2 = ((cljs.core._EQ_.call(null,"DESC",sortOrder))?cljs.core.reverse.call(null,G__23152__$1):G__23152__$1);
var G__23152__$3 = (cljs.core.truth_(offset)?cljs.core.drop.call(null,offset,G__23152__$2):G__23152__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.call(null,limit,G__23152__$3);
} else {
return G__23152__$3;
}
} else {
return res;
}
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql_resp.flakes__GT_res = (function fluree$db$query$fql_resp$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23333){
var state_val_23334 = (state_23333[(1)]);
if((state_val_23334 === (7))){
var state_23333__$1 = state_23333;
var statearr_23335_23421 = state_23333__$1;
(statearr_23335_23421[(2)] = null);

(statearr_23335_23421[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (20))){
var inst_23191 = cljs.core.PersistentHashMap.EMPTY;
var state_23333__$1 = state_23333;
var statearr_23336_23422 = state_23333__$1;
(statearr_23336_23422[(2)] = inst_23191);

(statearr_23336_23422[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (27))){
var inst_23173 = (state_23333[(7)]);
var inst_23193 = (state_23333[(8)]);
var inst_23179 = (state_23333[(9)]);
var inst_23209 = (state_23333[(10)]);
var inst_23312 = (state_23333[(2)]);
var inst_23313 = (function (){var top_level_subject = inst_23173;
var select_spec = inst_23179;
var base_acc = inst_23193;
var acc_PLUS_refs = inst_23209;
var result = inst_23312;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__5045__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var and__5043__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
}
})())){
return cljs.core.conj.call(null,acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_23314 = cljs.core.PersistentVector.EMPTY;
var inst_23315 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23179);
var inst_23316 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_23315);
var inst_23317 = cljs.core.vals.call(null,inst_23316);
var inst_23318 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23179);
var inst_23319 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_23318);
var inst_23320 = cljs.core.vals.call(null,inst_23319);
var inst_23321 = cljs.core.concat.call(null,inst_23317,inst_23320);
var inst_23322 = cljs.core.reduce.call(null,inst_23313,inst_23314,inst_23321);
var inst_23324 = (function (){var top_level_subject = inst_23173;
var select_spec = inst_23179;
var base_acc = inst_23193;
var acc_PLUS_refs = inst_23209;
var result = inst_23312;
var sort_preds = inst_23322;
return (function (acc,p__23323){
var vec__23337 = p__23323;
var selectPred = cljs.core.nth.call(null,vec__23337,(0),null);
var sortOrder = cljs.core.nth.call(null,vec__23337,(1),null);
var sortPred = cljs.core.nth.call(null,vec__23337,(2),null);
var limit = cljs.core.nth.call(null,vec__23337,(3),null);
return cljs.core.assoc.call(null,acc,selectPred,fluree.db.query.fql_resp.sort_offset_and_limit_res.call(null,sortPred,sortOrder,(0),limit,cljs.core.get.call(null,acc,selectPred)));
});
})();
var inst_23325 = cljs.core.reduce.call(null,inst_23324,inst_23312,inst_23322);
var state_23333__$1 = state_23333;
var statearr_23340_23423 = state_23333__$1;
(statearr_23340_23423[(2)] = inst_23325);

(statearr_23340_23423[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (1))){
var state_23333__$1 = state_23333;
var statearr_23341_23424 = state_23333__$1;
(statearr_23341_23424[(2)] = null);

(statearr_23341_23424[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (24))){
var inst_23209 = (state_23333[(10)]);
var inst_23209__$1 = (state_23333[(2)]);
var inst_23210 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"p","p",151049309),flakes);
var inst_23211 = cljs.core.PersistentHashMap.EMPTY;
var inst_23212 = inst_23210;
var inst_23213 = inst_23209__$1;
var inst_23214 = inst_23211;
var state_23333__$1 = (function (){var statearr_23342 = state_23333;
(statearr_23342[(11)] = inst_23212);

(statearr_23342[(12)] = inst_23213);

(statearr_23342[(10)] = inst_23209__$1);

(statearr_23342[(13)] = inst_23214);

return statearr_23342;
})();
var statearr_23343_23425 = state_23333__$1;
(statearr_23343_23425[(2)] = null);

(statearr_23343_23425[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (39))){
var inst_23222 = (state_23333[(14)]);
var inst_23213 = (state_23333[(12)]);
var inst_23179 = (state_23333[(9)]);
var inst_23229 = (state_23333[(15)]);
var inst_23258 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23259 = fluree.db.query.fql_resp.add_pred.call(null,db,cache,fuel,max_fuel,inst_23213,inst_23179,inst_23222,inst_23229,false);
var state_23333__$1 = (function (){var statearr_23344 = state_23333;
(statearr_23344[(16)] = inst_23258);

return statearr_23344;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23333__$1,(42),inst_23259);
} else {
if((state_val_23334 === (46))){
var inst_23222 = (state_23333[(14)]);
var inst_23212 = (state_23333[(11)]);
var inst_23214 = (state_23333[(13)]);
var inst_23276 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23277 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23278 = cljs.core.first.call(null,inst_23222);
var inst_23279 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_23278);
var inst_23280 = [inst_23279];
var inst_23281 = cljs.core.PersistentHashMap.fromArrays(inst_23277,inst_23280);
var inst_23282 = cljs.core.rest.call(null,inst_23212);
var inst_23283 = [inst_23281,inst_23282,inst_23214];
var inst_23284 = (new cljs.core.PersistentVector(null,3,(5),inst_23276,inst_23283,null));
var state_23333__$1 = state_23333;
var statearr_23345_23426 = state_23333__$1;
(statearr_23345_23426[(2)] = inst_23284);

(statearr_23345_23426[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (4))){
var inst_23153 = (state_23333[(2)]);
var state_23333__$1 = state_23333;
var statearr_23346_23427 = state_23333__$1;
(statearr_23346_23427[(2)] = inst_23153);

(statearr_23346_23427[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (15))){
var inst_23180 = (state_23333[(17)]);
var inst_23179 = (state_23333[(9)]);
var inst_23179__$1 = (state_23333[(2)]);
var inst_23180__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23179__$1);
var state_23333__$1 = (function (){var statearr_23347 = state_23333;
(statearr_23347[(17)] = inst_23180__$1);

(statearr_23347[(9)] = inst_23179__$1);

return statearr_23347;
})();
if(cljs.core.truth_(inst_23180__$1)){
var statearr_23348_23428 = state_23333__$1;
(statearr_23348_23428[(1)] = (16));

} else {
var statearr_23349_23429 = state_23333__$1;
(statearr_23349_23429[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (48))){
var inst_23295 = (state_23333[(2)]);
var state_23333__$1 = state_23333;
var statearr_23350_23430 = state_23333__$1;
(statearr_23350_23430[(2)] = inst_23295);

(statearr_23350_23430[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (50))){
var state_23333__$1 = state_23333;
var statearr_23351_23431 = state_23333__$1;
(statearr_23351_23431[(2)] = null);

(statearr_23351_23431[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (21))){
var inst_23179 = (state_23333[(9)]);
var inst_23193 = (state_23333[(2)]);
var inst_23194 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23195 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_23196 = (new cljs.core.PersistentVector(null,2,(5),inst_23194,inst_23195,null));
var inst_23197 = cljs.core.get_in.call(null,inst_23179,inst_23196);
var state_23333__$1 = (function (){var statearr_23352 = state_23333;
(statearr_23352[(8)] = inst_23193);

return statearr_23352;
})();
if(cljs.core.truth_(inst_23197)){
var statearr_23353_23432 = state_23333__$1;
(statearr_23353_23432[(1)] = (22));

} else {
var statearr_23354_23433 = state_23333__$1;
(statearr_23354_23433[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (31))){
var inst_23228 = (state_23333[(18)]);
var inst_23222 = (state_23333[(14)]);
var inst_23213 = (state_23333[(12)]);
var inst_23232 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23233 = fluree.db.query.fql_resp.flake__GT_recur.call(null,db,inst_23222,inst_23228,inst_23213,fuel,max_fuel,cache);
var state_23333__$1 = (function (){var statearr_23355 = state_23333;
(statearr_23355[(19)] = inst_23232);

return statearr_23355;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23333__$1,(34),inst_23233);
} else {
if((state_val_23334 === (32))){
var inst_23228 = (state_23333[(18)]);
var state_23333__$1 = state_23333;
if(cljs.core.truth_(inst_23228)){
var statearr_23356_23434 = state_23333__$1;
(statearr_23356_23434[(1)] = (35));

} else {
var statearr_23357_23435 = state_23333__$1;
(statearr_23357_23435[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (40))){
var inst_23269 = (state_23333[(20)]);
var inst_23179 = (state_23333[(9)]);
var inst_23268 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23179);
var inst_23269__$1 = cljs.core.empty_QMARK_.call(null,inst_23268);
var state_23333__$1 = (function (){var statearr_23358 = state_23333;
(statearr_23358[(20)] = inst_23269__$1);

return statearr_23358;
})();
if(inst_23269__$1){
var statearr_23359_23436 = state_23333__$1;
(statearr_23359_23436[(1)] = (43));

} else {
var statearr_23360_23437 = state_23333__$1;
(statearr_23360_23437[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (33))){
var inst_23222 = (state_23333[(14)]);
var inst_23301 = (state_23333[(2)]);
var inst_23302 = cljs.core.nth.call(null,inst_23301,(0),null);
var inst_23303 = cljs.core.nth.call(null,inst_23301,(1),null);
var inst_23304 = cljs.core.nth.call(null,inst_23301,(2),null);
var inst_23305 = cljs.core.first.call(null,inst_23222);
var inst_23306 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_23305);
var inst_23307 = cljs.core.assoc.call(null,inst_23302,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_23306);
var inst_23212 = inst_23303;
var inst_23213 = inst_23307;
var inst_23214 = inst_23304;
var state_23333__$1 = (function (){var statearr_23361 = state_23333;
(statearr_23361[(11)] = inst_23212);

(statearr_23361[(12)] = inst_23213);

(statearr_23361[(13)] = inst_23214);

return statearr_23361;
})();
var statearr_23362_23438 = state_23333__$1;
(statearr_23362_23438[(2)] = null);

(statearr_23362_23438[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (13))){
var inst_23173 = (state_23333[(7)]);
var inst_23176 = fluree.db.query.fql_resp.full_select_spec.call(null,db,cache,base_select_spec,inst_23173);
var state_23333__$1 = state_23333;
var statearr_23363_23439 = state_23333__$1;
(statearr_23363_23439[(2)] = inst_23176);

(statearr_23363_23439[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (22))){
var inst_23179 = (state_23333[(9)]);
var inst_23199 = cljs.core.first.call(null,flakes);
var inst_23200 = fluree.db.flake.s.call(null,inst_23199);
var inst_23201 = fluree.db.query.fql_resp.select_spec__GT_reverse_pred_specs.call(null,inst_23179);
var inst_23202 = fluree.db.query.fql_resp.resolve_reverse_refs.call(null,db,cache,fuel,max_fuel,inst_23200,inst_23201);
var state_23333__$1 = state_23333;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23333__$1,(25),inst_23202);
} else {
if((state_val_23334 === (36))){
var inst_23179 = (state_23333[(9)]);
var inst_23256 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23179);
var state_23333__$1 = state_23333;
if(cljs.core.truth_(inst_23256)){
var statearr_23364_23440 = state_23333__$1;
(statearr_23364_23440[(1)] = (39));

} else {
var statearr_23365_23441 = state_23333__$1;
(statearr_23365_23441[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (41))){
var inst_23297 = (state_23333[(2)]);
var state_23333__$1 = state_23333;
var statearr_23366_23442 = state_23333__$1;
(statearr_23366_23442[(2)] = inst_23297);

(statearr_23366_23442[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (43))){
var inst_23179 = (state_23333[(9)]);
var inst_23271 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23179);
var state_23333__$1 = state_23333;
var statearr_23367_23443 = state_23333__$1;
(statearr_23367_23443[(2)] = inst_23271);

(statearr_23367_23443[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (29))){
var inst_23228 = (state_23333[(18)]);
var inst_23222 = (state_23333[(14)]);
var inst_23212 = (state_23333[(11)]);
var inst_23179 = (state_23333[(9)]);
var inst_23222__$1 = cljs.core.first.call(null,inst_23212);
var inst_23223 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23224 = cljs.core.first.call(null,inst_23222__$1);
var inst_23225 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_23224);
var inst_23226 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_23225];
var inst_23227 = (new cljs.core.PersistentVector(null,3,(5),inst_23223,inst_23226,null));
var inst_23228__$1 = cljs.core.get_in.call(null,inst_23179,inst_23227);
var inst_23229 = fluree.db.query.fql_resp.component_follow_QMARK_.call(null,inst_23228__$1,inst_23179);
var inst_23230 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_23228__$1);
var state_23333__$1 = (function (){var statearr_23368 = state_23333;
(statearr_23368[(18)] = inst_23228__$1);

(statearr_23368[(14)] = inst_23222__$1);

(statearr_23368[(15)] = inst_23229);

return statearr_23368;
})();
if(cljs.core.truth_(inst_23230)){
var statearr_23369_23444 = state_23333__$1;
(statearr_23369_23444[(1)] = (31));

} else {
var statearr_23370_23445 = state_23333__$1;
(statearr_23370_23445[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (44))){
var inst_23269 = (state_23333[(20)]);
var state_23333__$1 = state_23333;
var statearr_23371_23446 = state_23333__$1;
(statearr_23371_23446[(2)] = inst_23269);

(statearr_23371_23446[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (6))){
var state_23333__$1 = state_23333;
var statearr_23372_23447 = state_23333__$1;
(statearr_23372_23447[(2)] = null);

(statearr_23372_23447[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (28))){
var inst_23213 = (state_23333[(12)]);
var state_23333__$1 = state_23333;
var statearr_23373_23448 = state_23333__$1;
(statearr_23373_23448[(2)] = inst_23213);

(statearr_23373_23448[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (51))){
var inst_23293 = (state_23333[(2)]);
var state_23333__$1 = state_23333;
var statearr_23374_23449 = state_23333__$1;
(statearr_23374_23449[(2)] = inst_23293);

(statearr_23374_23449[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (25))){
var inst_23193 = (state_23333[(8)]);
var inst_23204 = (state_23333[(2)]);
var inst_23205 = fluree.db.util.async.throw_err.call(null,inst_23204);
var inst_23206 = cljs.core.merge.call(null,inst_23193,inst_23205);
var state_23333__$1 = state_23333;
var statearr_23375_23450 = state_23333__$1;
(statearr_23375_23450[(2)] = inst_23206);

(statearr_23375_23450[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (34))){
var inst_23232 = (state_23333[(19)]);
var inst_23212 = (state_23333[(11)]);
var inst_23214 = (state_23333[(13)]);
var inst_23235 = (state_23333[(2)]);
var inst_23236 = fluree.db.util.async.throw_err.call(null,inst_23235);
var inst_23237 = cljs.core.rest.call(null,inst_23212);
var inst_23238 = [inst_23236,inst_23237,inst_23214];
var inst_23239 = (new cljs.core.PersistentVector(null,3,(5),inst_23232,inst_23238,null));
var state_23333__$1 = state_23333;
var statearr_23376_23451 = state_23333__$1;
(statearr_23376_23451[(2)] = inst_23239);

(statearr_23376_23451[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (17))){
var inst_23179 = (state_23333[(9)]);
var inst_23183 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23179);
var state_23333__$1 = state_23333;
var statearr_23378_23452 = state_23333__$1;
(statearr_23378_23452[(2)] = inst_23183);

(statearr_23378_23452[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (3))){
var inst_23331 = (state_23333[(2)]);
var state_23333__$1 = state_23333;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23333__$1,inst_23331);
} else {
if((state_val_23334 === (12))){
var _ = (function (){var statearr_23379 = state_23333;
(statearr_23379[(4)] = cljs.core.rest.call(null,(state_23333[(4)])));

return statearr_23379;
})();
var state_23333__$1 = state_23333;
var ex23377 = (state_23333__$1[(2)]);
var statearr_23380_23453 = state_23333__$1;
(statearr_23380_23453[(5)] = ex23377);


var statearr_23381_23454 = state_23333__$1;
(statearr_23381_23454[(1)] = (11));

(statearr_23381_23454[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (2))){
var _ = (function (){var statearr_23382 = state_23333;
(statearr_23382[(4)] = cljs.core.cons.call(null,(5),(state_23333[(4)])));

return statearr_23382;
})();
var inst_23159 = cljs.core.not_empty.call(null,flakes);
var state_23333__$1 = state_23333;
if(cljs.core.truth_(inst_23159)){
var statearr_23383_23455 = state_23333__$1;
(statearr_23383_23455[(1)] = (6));

} else {
var statearr_23384_23456 = state_23333__$1;
(statearr_23384_23456[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (23))){
var inst_23193 = (state_23333[(8)]);
var state_23333__$1 = state_23333;
var statearr_23385_23457 = state_23333__$1;
(statearr_23385_23457[(2)] = inst_23193);

(statearr_23385_23457[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (47))){
var state_23333__$1 = state_23333;
var statearr_23386_23458 = state_23333__$1;
(statearr_23386_23458[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (35))){
var inst_23228 = (state_23333[(18)]);
var inst_23222 = (state_23333[(14)]);
var inst_23213 = (state_23333[(12)]);
var inst_23229 = (state_23333[(15)]);
var inst_23214 = (state_23333[(13)]);
var inst_23245 = fluree.db.query.fql_resp.add_pred.call(null,db,cache,fuel,max_fuel,inst_23213,inst_23228,inst_23222,inst_23229,false,inst_23214);
var state_23333__$1 = state_23333;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23333__$1,(38),inst_23245);
} else {
if((state_val_23334 === (19))){
var inst_23173 = (state_23333[(7)]);
var inst_23187 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23188 = [inst_23173];
var inst_23189 = cljs.core.PersistentHashMap.fromArrays(inst_23187,inst_23188);
var state_23333__$1 = state_23333;
var statearr_23388_23459 = state_23333__$1;
(statearr_23388_23459[(2)] = inst_23189);

(statearr_23388_23459[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (11))){
var inst_23161 = (state_23333[(2)]);
var inst_23162 = fluree.db.util.log.error.call(null,inst_23161);
var inst_23163 = (function(){throw inst_23161})();
var state_23333__$1 = (function (){var statearr_23390 = state_23333;
(statearr_23390[(21)] = inst_23162);

return statearr_23390;
})();
var statearr_23391_23460 = state_23333__$1;
(statearr_23391_23460[(2)] = inst_23163);

(statearr_23391_23460[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (9))){
var _ = (function (){var statearr_23392 = state_23333;
(statearr_23392[(4)] = cljs.core.cons.call(null,(12),(state_23333[(4)])));

return statearr_23392;
})();
var inst_23169 = cljs.core.first.call(null,flakes);
var inst_23170 = fluree.db.flake.s.call(null,inst_23169);
var ___$1 = (function (){var statearr_23393 = state_23333;
(statearr_23393[(4)] = cljs.core.rest.call(null,(state_23333[(4)])));

return statearr_23393;
})();
var state_23333__$1 = state_23333;
var statearr_23394_23461 = state_23333__$1;
(statearr_23394_23461[(2)] = inst_23170);

(statearr_23394_23461[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (5))){
var _ = (function (){var statearr_23395 = state_23333;
(statearr_23395[(4)] = cljs.core.rest.call(null,(state_23333[(4)])));

return statearr_23395;
})();
var state_23333__$1 = state_23333;
var ex23389 = (state_23333__$1[(2)]);
var statearr_23396_23462 = state_23333__$1;
(statearr_23396_23462[(5)] = ex23389);


if((ex23389 instanceof Error)){
var statearr_23397_23463 = state_23333__$1;
(statearr_23397_23463[(1)] = (4));

(statearr_23397_23463[(5)] = null);

} else {
throw ex23389;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (14))){
var state_23333__$1 = state_23333;
var statearr_23398_23464 = state_23333__$1;
(statearr_23398_23464[(2)] = base_select_spec);

(statearr_23398_23464[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (45))){
var inst_23274 = (state_23333[(2)]);
var state_23333__$1 = state_23333;
if(cljs.core.truth_(inst_23274)){
var statearr_23399_23465 = state_23333__$1;
(statearr_23399_23465[(1)] = (46));

} else {
var statearr_23400_23466 = state_23333__$1;
(statearr_23400_23466[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (26))){
var inst_23212 = (state_23333[(11)]);
var inst_23216 = cljs.core.empty_QMARK_.call(null,inst_23212);
var state_23333__$1 = state_23333;
if(inst_23216){
var statearr_23401_23467 = state_23333__$1;
(statearr_23401_23467[(1)] = (28));

} else {
var statearr_23402_23468 = state_23333__$1;
(statearr_23402_23468[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (16))){
var inst_23180 = (state_23333[(17)]);
var state_23333__$1 = state_23333;
var statearr_23403_23469 = state_23333__$1;
(statearr_23403_23469[(2)] = inst_23180);

(statearr_23403_23469[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (38))){
var inst_23212 = (state_23333[(11)]);
var inst_23247 = (state_23333[(2)]);
var inst_23248 = fluree.db.util.async.throw_err.call(null,inst_23247);
var inst_23249 = cljs.core.nth.call(null,inst_23248,(0),null);
var inst_23250 = cljs.core.nth.call(null,inst_23248,(1),null);
var inst_23251 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23252 = cljs.core.rest.call(null,inst_23212);
var inst_23253 = [inst_23249,inst_23252,inst_23250];
var inst_23254 = (new cljs.core.PersistentVector(null,3,(5),inst_23251,inst_23253,null));
var state_23333__$1 = state_23333;
var statearr_23404_23470 = state_23333__$1;
(statearr_23404_23470[(2)] = inst_23254);

(statearr_23404_23470[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (30))){
var inst_23310 = (state_23333[(2)]);
var state_23333__$1 = state_23333;
var statearr_23405_23471 = state_23333__$1;
(statearr_23405_23471[(2)] = inst_23310);

(statearr_23405_23471[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (10))){
var inst_23173 = (state_23333[(2)]);
var inst_23174 = fluree.db.query.fql_resp.has_ns_lookups_QMARK_.call(null,base_select_spec);
var state_23333__$1 = (function (){var statearr_23406 = state_23333;
(statearr_23406[(7)] = inst_23173);

return statearr_23406;
})();
if(cljs.core.truth_(inst_23174)){
var statearr_23407_23472 = state_23333__$1;
(statearr_23407_23472[(1)] = (13));

} else {
var statearr_23408_23473 = state_23333__$1;
(statearr_23408_23473[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (18))){
var inst_23185 = (state_23333[(2)]);
var state_23333__$1 = state_23333;
if(cljs.core.truth_(inst_23185)){
var statearr_23409_23474 = state_23333__$1;
(statearr_23409_23474[(1)] = (19));

} else {
var statearr_23410_23475 = state_23333__$1;
(statearr_23410_23475[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (42))){
var inst_23258 = (state_23333[(16)]);
var inst_23212 = (state_23333[(11)]);
var inst_23214 = (state_23333[(13)]);
var inst_23261 = (state_23333[(2)]);
var inst_23262 = fluree.db.util.async.throw_err.call(null,inst_23261);
var inst_23263 = cljs.core.first.call(null,inst_23262);
var inst_23264 = cljs.core.rest.call(null,inst_23212);
var inst_23265 = [inst_23263,inst_23264,inst_23214];
var inst_23266 = (new cljs.core.PersistentVector(null,3,(5),inst_23258,inst_23265,null));
var state_23333__$1 = state_23333;
var statearr_23411_23476 = state_23333__$1;
(statearr_23411_23476[(2)] = inst_23266);

(statearr_23411_23476[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (37))){
var inst_23299 = (state_23333[(2)]);
var state_23333__$1 = state_23333;
var statearr_23412_23477 = state_23333__$1;
(statearr_23412_23477[(2)] = inst_23299);

(statearr_23412_23477[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (8))){
var inst_23328 = (state_23333[(2)]);
var _ = (function (){var statearr_23413 = state_23333;
(statearr_23413[(4)] = cljs.core.rest.call(null,(state_23333[(4)])));

return statearr_23413;
})();
var state_23333__$1 = state_23333;
var statearr_23414_23478 = state_23333__$1;
(statearr_23414_23478[(2)] = inst_23328);

(statearr_23414_23478[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23334 === (49))){
var inst_23212 = (state_23333[(11)]);
var inst_23213 = (state_23333[(12)]);
var inst_23214 = (state_23333[(13)]);
var inst_23287 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23288 = cljs.core.rest.call(null,inst_23212);
var inst_23289 = [inst_23213,inst_23288,inst_23214];
var inst_23290 = (new cljs.core.PersistentVector(null,3,(5),inst_23287,inst_23289,null));
var state_23333__$1 = state_23333;
var statearr_23415_23479 = state_23333__$1;
(statearr_23415_23479[(2)] = inst_23290);

(statearr_23415_23479[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto____0 = (function (){
var statearr_23416 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23416[(0)] = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto__);

(statearr_23416[(1)] = (1));

return statearr_23416;
});
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto____1 = (function (state_23333){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23333);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23417){var ex__2749__auto__ = e23417;
var statearr_23418_23480 = state_23333;
(statearr_23418_23480[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23333[(4)]))){
var statearr_23419_23481 = state_23333;
(statearr_23419_23481[(1)] = cljs.core.first.call(null,(state_23333[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23482 = state_23333;
state_23333 = G__23482;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto__ = function(state_23333){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto____1.call(this,state_23333);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto____0;
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto____1;
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23420 = f__2769__auto__.call(null);
(statearr_23420[(6)] = c__2768__auto__);

return statearr_23420;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
