// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.sparql_parser');
goog.require('cljs.core');
goog.require('instaparse.core');
goog.require('fluree.db.util.cljs_shim');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('cljs.tools.reader');
fluree.db.query.sparql_parser.inline_content = "<Query> ::=  <COMMENT?> WS Prologue WS ( SelectQuery | ConstructQuery | DescribeQuery | AskQuery ) WS Modifiers\nUpdateUnit ::= Update\nPrologue ::= ( BaseDec1 | PrefixDec1 )*\nBaseDec1 ::= 'BASE' IRIREF\nPrefixDec1 ::= <'PREFIX'> WS PNAME_NS WS IRIREF\nSelectQuery ::= WS SelectClause WS DatasetClause* WS WhereClause WS SolutionModifier WS\nSubSelect ::= SelectClause WhereClause SolutionModifier ValuesClause\n<SelectClause> ::= WS <'SELECT'> WS ( 'DISTINCT' | 'REDUCED')? WS ( ( Var | ( <'('> Expression WS 'AS' WS Var <')'> ) )+ | '*' )\nConstructQuery\t  ::=  \t'CONSTRUCT' ( ConstructTemplate DatasetClause* WhereClause SolutionModifier | DatasetClause* 'WHERE' '{' TriplesTemplate? '}' SolutionModifier )\nDescribeQuery\t  ::=  \t'DESCRIBE' ( VarOrIri+ | '*' ) DatasetClause* WhereClause? SolutionModifier\nAskQuery\t  ::=  \t'ASK' DatasetClause* WhereClause SolutionModifier\nModifiers ::= (ValuesClause? | PrettyPrint? ) (PrettyPrint? | ValuesClause? )\nDatasetClause\t  ::=  \t'FROM' ( DefaultGraphClause | NamedGraphClause )\nDefaultGraphClause\t  ::=  \tSourceSelector\nNamedGraphClause\t  ::=  \t'NAMED' SourceSelector\nSourceSelector\t  ::=  \tiri\nWhereClause\t  ::=  \t<'WHERE'?> WS GroupGraphPattern WS\nSolutionModifier\t  ::=  \tGroupClause? HavingClause? OrderClause? LimitOffsetClauses?\nGroupClause\t  ::=  \t<'GROUP' WS 'BY' WS> GroupCondition+\nGroupCondition\t  ::=  \tBuiltInCall | FunctionCall | <'('> Expression ( WS 'AS' WS Var )? <')'> | Var\nHavingClause\t  ::=  \t'HAVING' HavingCondition+\nHavingCondition\t  ::=  \tConstraint\nOrderClause\t  ::=  \t<'ORDER' WS 'BY'> WS OrderCondition+ WS\n<OrderCondition>\t  ::=  \t( ( 'ASC' | 'DESC' ) WS BrackettedExpression ) | ( Constraint | Var )\n<LimitOffsetClauses>\t  ::=  \tLimitClause OffsetClause? | OffsetClause LimitClause?\nLimitClause\t  ::=  \t<'LIMIT'> WS INTEGER\nOffsetClause\t  ::=  \t<'OFFSET'> INTEGER\nValuesClause\t  ::=  \t( <'VALUES'> WS DataBlock )? WS\nUpdate\t  ::=  \tPrologue ( Update1 ( ';' Update )? )?\nUpdate1\t  ::=  \tLoad | Clear | Drop | Add | Move | Copy | Create | InsertData | DeleteData | DeleteWhere | Modify\nLoad\t  ::=  \t'LOAD' 'SILENT'? iri ( 'INTO' GraphRef )?\nClear\t  ::=  \t'CLEAR' 'SILENT'? GraphRefAll\nDrop\t  ::=  \t'DROP' 'SILENT'? GraphRefAll\nCreate\t  ::=  \t'CREATE' 'SILENT'? GraphRef\nAdd\t  ::=  \t'ADD' 'SILENT'? GraphOrDefault 'TO' GraphOrDefault\nMove\t  ::=  \t'MOVE' 'SILENT'? GraphOrDefault 'TO' GraphOrDefault\nCopy\t  ::=  \t'COPY' 'SILENT'? GraphOrDefault 'TO' GraphOrDefault\nInsertData\t  ::=  \t'INSERT DATA' QuadData\nDeleteData\t  ::=  \t'DELETE DATA' QuadData\nDeleteWhere\t  ::=  \t'DELETE WHERE' QuadPattern\nModify\t  ::=  \t( 'WITH' iri )? ( DeleteClause InsertClause? | InsertClause ) UsingClause* 'WHERE' GroupGraphPattern\nDeleteClause\t  ::=  \t'DELETE' QuadPattern\nInsertClause\t  ::=  \t'INSERT' QuadPattern\nUsingClause\t  ::=  \t'USING' ( iri | 'NAMED' iri )\nGraphOrDefault\t  ::=  \t'DEFAULT' | 'GRAPH'? iri\nGraphRef\t  ::=  \t'GRAPH' iri\nGraphRefAll\t  ::=  \tGraphRef | 'DEFAULT' | 'NAMED' | 'ALL'\nQuadPattern\t  ::=  \t'{' Quads '}'\nQuadData\t  ::=  \t'{' Quads '}'\nQuads\t  ::=  \tTriplesTemplate? ( QuadsNotTriples '.'? TriplesTemplate? )*\nQuadsNotTriples\t  ::=  \t'GRAPH' VarOrIri '{' TriplesTemplate? '}'\nTriplesTemplate\t  ::=  \tTriplesSameSubject ( '.' TriplesTemplate? )?\n<GroupGraphPattern>\t  ::=  \tWS <'{'> WS ( SubSelect | GroupGraphPatternSub ) WS <'}'> WS\nGroupGraphPatternSub\t  ::=  WS TriplesBlock? ( GraphPatternNotTriples WS <'.'?> TriplesBlock? WS )* WS\nTriplesBlock\t  ::=  WS TriplesSameSubjectPath WS ( <'.'> TriplesBlock? WS )?\nGraphPatternNotTriples\t  ::=  \tGroupOrUnionGraphPattern | OptionalGraphPattern | MinusGraphPattern | GraphGraphPattern | ServiceGraphPattern | Filter | Bind | InlineData\nOptionalGraphPattern\t  ::=  \t<'OPTIONAL'> GroupGraphPattern\nGraphGraphPattern\t  ::=  \t'GRAPH' VarOrIri GroupGraphPattern\nServiceGraphPattern\t  ::=  \t'SERVICE' 'SILENT'? VarOrIri GroupGraphPattern\nBind\t  ::=  \t<'BIND' WS '(' WS>  Expression <WS 'AS' WS> Var <WS ')' WS>\nInlineData\t  ::=  \t<'VALUES'> WS DataBlock\n<DataBlock>\t  ::=  \tInlineDataOneVar | InlineDataFull\nInlineDataOneVar\t  ::=  \tVar <'{'> WS DataBlockValue* <'}'>\nInlineDataFull\t  ::=  \t( NIL | '(' Var* ')' ) '{' ( '(' DataBlockValue* ')' | NIL )* '}'\nDataBlockValue\t  ::=  \tiri | RDFLiteral | NumericLiteral | BooleanLiteral | 'UNDEF' WS\nMinusGraphPattern\t  ::=  \t'MINUS' GroupGraphPattern\nGroupOrUnionGraphPattern\t  ::=  \tGroupGraphPattern ( <'UNION'> GroupGraphPattern )*\nFilter\t  ::=  \t<'FILTER'> WS Constraint\nConstraint\t  ::=  \tBrackettedExpression | BuiltInCall | FunctionCall\nFunctionCall\t  ::=  \tiri ArgList\nArgList\t  ::=  \tNIL | <'('> 'DISTINCT'? Expression ( <','> Expression )* <')'>\nExpressionList\t  ::=  \tNIL | <'('> Expression ( <','> Expression )* <')'>\nConstructTemplate\t  ::=  \t'{' ConstructTriples? '}'\nConstructTriples\t  ::=  \tTriplesSameSubject ( '.' ConstructTriples? )?\nTriplesSameSubject\t  ::=  \tVarOrTerm PropertyListNotEmpty | TriplesNode PropertyList\nPropertyList\t  ::=  \tPropertyListNotEmpty?\nPropertyListNotEmpty\t  ::=  \tVerb ObjectList ( <';'>  WS ( Verb ObjectList )? )*\nVerb\t  ::=  \tVarOrIri | 'a'\nObjectList\t  ::=  \tObject ( <','> WS Object )*\nObject\t  ::=  \tGraphNode\nTriplesSameSubjectPath\t  ::=  \tVarOrTerm PropertyListPathNotEmpty | TriplesNodePath PropertyListPath WS\nPropertyListPath\t  ::=  \tPropertyListPathNotEmpty?\nPropertyListPathNotEmpty\t  ::=  \t( VerbPath | VerbSimple ) ObjectListPath ( <';'> WS ( ( VerbPath | VerbSimple ) ObjectList )? )* WS\n<VerbPath>\t  ::=  \tPath\n<VerbSimple>\t  ::=  \tVar\n<ObjectListPath>\t  ::=  \tObjectPath WS ( <',' WS> ObjectPath )*\nObjectPath\t  ::=  \tGraphNodePath\n<Path>\t  ::=  \tPathAlternative\n<PathAlternative>\t  ::=  \tPathSequence ( <'|'> PathSequence )*\nPathSequence\t  ::=  \tPathEltOrInverse ( <'/'> PathEltOrInverse )*\n<PathElt>\t  ::=  \tPathPrimary PathMod?\n<PathEltOrInverse>\t  ::=  \tPathElt | <'^'> PathElt\nPathMod\t  ::=  \t'?' | '*' | ('+' INTEGER?) WS\nPathPrimary\t  ::=  \tiri | 'a' | '!' PathNegatedPropertySet | '(' Path ')'\nPathNegatedPropertySet\t  ::=  \tPathOneInPropertySet | '(' ( PathOneInPropertySet ( '|' PathOneInPropertySet )* )? ')'\nPathOneInPropertySet\t  ::=  \tiri | 'a' | '^' ( iri | 'a' )\nInteger\t  ::=  \tINTEGER\nTriplesNode\t  ::=  \tCollection | BlankNodePropertyList\nBlankNodePropertyList\t  ::=  \t'[' PropertyListNotEmpty ']'\nTriplesNodePath\t  ::=  \tCollectionPath WS | BlankNodePropertyListPath WS\nBlankNodePropertyListPath\t  ::=  \t'[' PropertyListPathNotEmpty ']'\nCollection\t  ::=  \t'(' GraphNode+ ')'\nCollectionPath\t  ::=  \t'(' GraphNodePath+ ')'\n<GraphNode>\t  ::=  \tVarOrTerm | TriplesNode\n<GraphNodePath>\t  ::=  \tVarOrTerm | TriplesNodePath\n<VarOrTerm>\t  ::=  \tVar | GraphTerm WS\nVarOrIri\t  ::=  \tVar | iri WS\nVar\t  ::=  \tVAR1 WS | VAR2 WS\nGraphTerm\t  ::=  \tiri | RDFLiteral | NumericLiteral | BooleanLiteral | BlankNode | NIL\nExpression\t  ::=  \tWS ConditionalOrExpression WS\n<ConditionalOrExpression>\t  ::=  \tConditionalAndExpression ( <'||'> ConditionalAndExpression )*\n<ConditionalAndExpression>\t  ::=  \tValueLogical ( <'&&'> ValueLogical )*\n<ValueLogical>\t  ::=  \tRelationalExpression\nRelationalExpression\t  ::=  \tNumericExpression WS ( '=' NumericExpression | '!=' NumericExpression | '<' NumericExpression | '>' NumericExpression | '<=' NumericExpression | '>=' NumericExpression | 'IN' ExpressionList | 'NOT' 'IN' ExpressionList )?\nNumericExpression\t  ::=  \tWS AdditiveExpression WS\n\n<AdditiveExpression>\t  ::=  \tMultiplicativeExpression ( '+' MultiplicativeExpression | '-' MultiplicativeExpression | ( NumericLiteralPositive | NumericLiteralNegative ) ( ( '*' UnaryExpression ) | ( '/' UnaryExpression ) )* )*\n\n\nMultiplicativeExpression\t  ::=  \tUnaryExpression ( '*' UnaryExpression | '/' UnaryExpression )*\n<UnaryExpression>\t  ::=  \t  '!' PrimaryExpression\n| '+' PrimaryExpression\n| '-' PrimaryExpression\n| PrimaryExpression\n<PrimaryExpression>\t  ::=  \tBrackettedExpression | BuiltInCall | iriOrFunction | RDFLiteral | NumericLiteral | BooleanLiteral | Var\nBrackettedExpression\t  ::=  \t<'('> WS Expression WS <')'>\n\nBuiltInCall\t  ::=  \t  Aggregate\n| 'STR' <'('> Expression <')'>\n| 'LANG' <'('> Expression <')'>\n| 'LANGMATCHES' <'('> Expression <','> Expression <')'>\n| 'DATATYPE' <'('> Expression <')'>\n| 'BOUND' <'('> Var <')'>\n| 'IRI' <'('> Expression <')'>\n| 'URI' <'('> Expression <')'>\n| 'BNODE' ( <'('> Expression <')'> | NIL )\n| 'RAND' NIL\n| 'ABS' <'('> Expression <')'>\n| 'CEIL' <'('> Expression <')'>\n| 'FLOOR' <'('> Expression <')'>\n| 'ROUND' <'('> Expression <')'>\n| 'CONCAT' ExpressionList\n| SubstringExpression\n| 'STRLEN' <'('> Expression <')'>\n| StrReplaceExpression\n| 'UCASE' <'('> Expression <')'>\n| 'LCASE' <'('> Expression <')'>\n| 'ENCODE_FOR_URI' <'('> Expression <')'>\n| 'CONTAINS' <'('> Expression <','> Expression <')'>\n| 'STRSTARTS' <'('> Expression <','> Expression <')'>\n| 'STRENDS' <'('> Expression <','> Expression <')'>\n| 'STRBEFORE' <'('> Expression <','> Expression <')'>\n| 'STRAFTER' <'('> Expression <','> Expression <')'>\n| 'YEAR' <'('> Expression <')'>\n| 'MONTH' <'('> Expression <')'>\n| 'DAY' <'('> Expression <')'>\n| 'HOURS' <'('> Expression <')'>\n| 'MINUTES' <'('> Expression <')'>\n| 'SECONDS' <'('> Expression <')'>\n| 'TIMEZONE' <'('> Expression <')'>\n| 'TZ' <'('> Expression <')'>\n| 'NOW' NIL\n| 'UUID' NIL\n| 'STRUUID' NIL\n| 'MD5' <'('>Expression <')'>\n| 'SHA1' <'('> Expression <')'>\n| 'SHA256' <'('> Expression <')'>\n| 'SHA384' <'('> Expression <')'>\n| 'SHA512' <'('> Expression <')'>\n| 'COALESCE' WS ExpressionList\n| 'IF' <'('> Expression <','> Expression <','> Expression <')'>\n| 'STRLANG' <'('> Expression <','> Expression <')'>\n| 'STRDT' <'('> Expression <','> Expression <')'>\n| 'sameTerm' <'('> Expression <','> Expression <')'>\n| 'isIRI' <'('> Expression <')'>\n| 'isURI' <'('> Expression <')'>\n| 'isBLANK' <'('> Expression <')'>\n| 'isLITERAL' <'('> Expression <')'>\n| 'isNUMERIC' <'('> Expression <')'>\n| RegexExpression\n| ExistsFunc\n| NotExistsFunc\n\n\nRegexExpression\t  ::=  \t'REGEX' '(' Expression ',' Expression ( ',' Expression )? ')'\nSubstringExpression\t  ::=  \t'SUBSTR' '(' Expression ',' Expression ( ',' Expression )? ')'\nStrReplaceExpression\t  ::=  \t'REPLACE' '(' Expression ',' Expression ',' Expression ( ',' Expression )? ')'\nExistsFunc\t  ::=  \t'EXISTS' GroupGraphPattern\nNotExistsFunc\t  ::=  \t'NOT' 'EXISTS' GroupGraphPattern\nAggregate\t  ::=  \t  'COUNT' WS <'('> WS 'DISTINCT'? WS ( '*' | Expression ) WS <')'> WS\n| 'SUM' WS <'('> WS 'DISTINCT'? Expression <')'>\n| 'MIN' <'('>  WS 'DISTINCT'? Expression <')'>\n| 'MAX' <'('>  WS 'DISTINCT'? Expression <')'>\n| 'AVG' <'('>  WS 'DISTINCT'? Expression <')'>\n| 'SAMPLE' <'('>  WS 'DISTINCT'? Expression? Expression <')'>\n| 'GROUP_CONCAT' <'('> WS 'DISTINCT'? Expression ( <';'> WS 'SEPARATOR' WS <'='> WS String WS )? <')'>\niriOrFunction\t  ::=  \tiri ArgList?\nRDFLiteral\t  ::=  \tString WS ( LANGTAG | ( '^^' iri ) )? WS\nNumericLiteral\t  ::=  \tNumericLiteralUnsigned WS | NumericLiteralPositive WS | NumericLiteralNegative WS\n<NumericLiteralUnsigned>\t  ::=  \tINTEGER | DECIMAL | DOUBLE\n<NumericLiteralPositive>\t  ::=  \tINTEGER_POSITIVE | DECIMAL_POSITIVE | DOUBLE_POSITIVE\n<NumericLiteralNegative>\t  ::=  \tINTEGER_NEGATIVE | DECIMAL_NEGATIVE | DOUBLE_NEGATIVE\nBooleanLiteral\t  ::=  \t'true' WS | 'false' WS\n<String>\t  ::=  \tSTRING_LITERAL1 | STRING_LITERAL2 | STRING_LITERAL_LONG1 | STRING_LITERAL_LONG2\niri\t  ::=  \tIRIREF | PrefixedName WS\nPrefixedName\t  ::=  \t( PNAME_LN WS ) | ( PNAME_NS WS)\nBlankNode\t  ::=  \tBLANK_NODE_LABEL | ANON\nPrettyPrint ::= <'PRETTY-PRINT'> WS\nIRIREF\t  ::=  \t#\"<[^<>\\\"{}|^`\\x00-\\x20]*>\" WS\n<PNAME_NS>\t  ::=  \tPN_PREFIX? ':'\n<PNAME_LN>\t  ::=  \tPNAME_NS PN_LOCAL '*'?\nBLANK_NODE_LABEL\t  ::=  \t'_:' ( PN_CHARS_U | #\"[0-9]\" ) ((PN_CHARS|'.')* PN_CHARS)?\n<VAR1>\t  ::=  \t<'?'> VARNAME\n<VAR2>\t  ::=  \t<'$'> VARNAME\nLANGTAG\t  ::=  \t#\"@[a-zA-Z]+-[a-zA-Z0-9]*\" WS\n<INTEGER>\t  ::=  \t#\"[0-9]+\"\n<DECIMAL>\t  ::=  #\"[0-9]*\\.[0-9]*\"\n<DOUBLE>\t  ::=  \t#\"[0-9]+\\.[0-9]*|(\\.[0-9]+)|([0-9]+)\" EXPONENT\n<INTEGER_POSITIVE>\t  ::=  \t'+' INTEGER\n<DECIMAL_POSITIVE>\t  ::=  \t'+' DECIMAL\n<DOUBLE_POSITIVE>\t  ::=  \t'+' DOUBLE\n<INTEGER_NEGATIVE>\t  ::=  \t'-' INTEGER\n<DECIMAL_NEGATIVE>\t  ::=  \t'-' DECIMAL\n<DOUBLE_NEGATIVE>\t  ::=  \t'-' DOUBLE\nEXPONENT\t  ::=  \t#\"[eE][+-]?[0-9]+\"\n<STRING_LITERAL1>\t  ::=  \t<\"'\"> ( #\"[^\\x27\\x5C\\x0A\\x0D]\" | ECHAR )* <\"'\">\n<STRING_LITERAL2>\t  ::=  \t<'\"'> ( #\"[^\\x27\\x5C\\x0A\\x0D]\" | ECHAR )* <'\"'>\n<STRING_LITERAL_LONG1>\t  ::=  \t\"'''\" ( ( \"'\" | \"''\" )? ( #\"[^'\\\\]\" | ECHAR ) )* \"'''\"\n<STRING_LITERAL_LONG2>\t  ::=  \t'\"\"\"' ( ( '\"' | '\"\"' )? ( #\"[^'\\\\]\" | ECHAR ) )* '\"\"\"'\nECHAR\t  ::=  \t#\"\\\\[tbnrf]\"\nNIL\t  ::=  \t'(' WS* ')'\n<WS>\t  ::=  \t<#\"[\\x20\\x09\\x0D\\x0A]*\\#[^\\n]*\\n*[\\x20\\x09\\x0D\\x0A]*|[\\x20\\x09\\x0D\\x0A]*\">\nANON\t  ::=  \t'[' WS* ']'\n<PN_CHARS_BASE>\t  ::=  \t#\"[a-zA-Z]|[\\u00C0-\\u00D6]|[\\u00D8-\\u00F6]|[\\u00F8-\\u02FF]|[\\u0370-\\u037D]|[\\u037F-\\u1FFF]|[\\u200C-\\u200D]|[\\u2070-\\u218F]|[\\u2C00-\\u2FEF]|[\\u3001-\\uD7FF]|[\\uF900-\\uFDCF]|[\\uFDF0-\\uFFFD]|[\\u10000-\\uEFFFF]\"\n<PN_CHARS_U>\t  ::=  \tPN_CHARS_BASE | #\"_\"\n<VARNAME>\t  ::=  \t( PN_CHARS_U | #\"[0-9]\" ) ( PN_CHARS_U | #\"[0-9]|\\u00B7|[\\u0300-\\u036F]|[\\u203F-\\u2040]\" )*\n<PN_CHARS>\t  ::=  \tPN_CHARS_U | #\"-|[0-9]|\\u00B7|[\\u0300-\\u036F]|[\\u203F-\\u2040]|/\"\n<PN_PREFIX>\t  ::=  \tPN_CHARS_BASE ((PN_CHARS|#\"\\.\")* PN_CHARS)?\n<PN_LOCAL>\t  ::=  \t( PN_CHARS_U | #\"[0-9]\" ) ((PN_CHARS|#\"\\.\")* PN_CHARS)?\n<COMMENT>       ::=   <#\"\\#[^\\n]*\\n{1}\">\n<PLX>\t  ::=  \tPERCENT | PN_LOCAL_ESC\n<PERCENT>\t  ::=  \t'%' HEX HEX\n<HEX>\t  ::=  \t#\"[0-9]\" | #\"[A-F]\" | #\"[a-f]\"\n<PN_LOCAL_ESC>\t  ::=  \t#\"[\\\\_~.\\-!$&'()*+,;=/?#@%]\"";
fluree.db.query.sparql_parser.sparql = instaparse.core.parser.call(null,fluree.db.query.sparql_parser.inline_content);
fluree.db.query.sparql_parser.wikidata_prefixes = new cljs.core.PersistentVector(null, 29, 5, cljs.core.PersistentVector.EMPTY_NODE, ["<http://www.wikidata.org/entity/>","<http://www.w3.org/2002/07/owl#>","<http://www.w3.org/ns/prov#>","<http://www.bigdata.com/queryHints#>","<http://www.wikidata.org/prop/novalue/>","<http://www.wikidata.org/prop/statement/value/>","<http://www.wikidata.org/prop/qualifier/value/>","<http://www.w3.org/1999/02/22-rdf-syntax-ns#>","<http://www.wikidata.org/prop/>","<http://www.wikidata.org/reference/>","<http://www.wikidata.org/prop/statement/>","<http://www.bigdata.com/rdf/search#>","<http://schema.org/>","<http://www.wikidata.org/prop/direct/>","<http://www.wikidata.org/value/>","<http://www.wikidata.org/wiki/Special:EntityData/>","<http://www.bigdata.com/rdf/gas#>","<http://www.wikidata.org/entity/statement/>","<http://www.bigdata.com/rdf#>","<http://www.wikidata.org/prop/qualifier/value-normalized/>","<http://wikiba.se/ontology#>","<http://www.wikidata.org/prop/reference/value-normalized/>","<http://www.w3.org/2000/01/rdf-schema#>","<http://www.wikidata.org/prop/qualifier/>","<http://www.wikidata.org/prop/statement/value-normalized/>","<http://www.wikidata.org/prop/reference/value/>","<http://www.w3.org/2004/02/skos/core#>","<http://www.wikidata.org/prop/reference/>","<http://www.w3.org/2001/XMLSchema#>"], null);
fluree.db.query.sparql_parser.handle_var = (function fluree$db$query$sparql_parser$handle_var(var_clause){
return ["?",clojure.string.join.call(null,var_clause)].join('');
});
/**
 * [:Modifiers [:PrettyPrint]]
 */
fluree.db.query.sparql_parser.valid_modifiers_QMARK_ = (function fluree$db$query$sparql_parser$valid_modifiers_QMARK_(modifiers){
if(((cljs.core._EQ_.call(null,cljs.core.first.call(null,modifiers),new cljs.core.Keyword(null,"Modifiers","Modifiers",717414284))) && (cljs.core.vector_QMARK_.call(null,cljs.core.second.call(null,modifiers))))){
return true;
} else {
throw cljs.core.ex_info.call(null,["Improperly formatted SPARQL query. Note: FlureeDB does not support all SPARQL features. Trouble parsing query modifiers: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(modifiers)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
});
fluree.db.query.sparql_parser.handle_iri_ref = (function fluree$db$query$sparql_parser$handle_iri_ref(ref){
return cljs.core.subs.call(null,ref,(1),(cljs.core.count.call(null,ref) - (1)));
});
/**
 * BNF -- PNAME_NS IRIREF
 */
fluree.db.query.sparql_parser.handle_prefix_dec1 = (function fluree$db$query$sparql_parser$handle_prefix_dec1(prefix_dec){
var name = cljs.core.keyword.call(null,clojure.string.join.call(null,cljs.core.drop_last.call(null,(2),prefix_dec)));
var iriref = fluree.db.query.sparql_parser.handle_iri_ref.call(null,cljs.core.second.call(null,cljs.core.last.call(null,prefix_dec)));
return cljs.core.PersistentArrayMap.createAsIfByAssoc([name,iriref]);
});
/**
 * Returns a source and predicate
 */
fluree.db.query.sparql_parser.handle_prefixed_name = (function fluree$db$query$sparql_parser$handle_prefixed_name(prefixed_name){
var name = clojure.string.join.call(null,prefixed_name);
var vec__75760 = clojure.string.split.call(null,name,/:/);
var source = cljs.core.nth.call(null,vec__75760,(0),null);
var predicate = cljs.core.nth.call(null,vec__75760,(1),null);
var source__$1 = clojure.string.replace.call(null,source,";",":");
if(((cljs.core._EQ_.call(null,source__$1,"fdb")) || (cljs.core._EQ_.call(null,source__$1,"fd")))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["$fdb",predicate], null);
} else {
if(clojure.string.starts_with_QMARK_.call(null,source__$1,"wd")){
var predicate__$1 = ((clojure.string.starts_with_QMARK_.call(null,predicate,"?"))?predicate:name);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["$wd",predicate__$1], null);
} else {
if(cljs.core._EQ_.call(null,source__$1,"fullText")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["$fdb",[source__$1,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(predicate)].join('')], null);
} else {
if(clojure.string.starts_with_QMARK_.call(null,source__$1,"fdb")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [["$",source__$1].join(''),predicate], null);
} else {
if(clojure.string.starts_with_QMARK_.call(null,source__$1,"fd")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [["$fdb",cljs.core.subs.call(null,source__$1,(2))].join(''),predicate], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [source__$1,predicate], null);

}
}
}
}
}
});
/**
 * Returns a source and predicate.
 *   BNF -- IRIREF | PrefixedName
 * 
 *   IRIREF not currently supported.
 */
fluree.db.query.sparql_parser.handle_iri = (function fluree$db$query$sparql_parser$handle_iri(iri){
var pred__75763 = cljs.core._EQ_;
var expr__75764 = cljs.core.first.call(null,iri);
if(cljs.core.truth_(pred__75763.call(null,new cljs.core.Keyword(null,"PrefixedName","PrefixedName",909049158),expr__75764))){
return fluree.db.query.sparql_parser.handle_prefixed_name.call(null,cljs.core.rest.call(null,iri));
} else {
if(cljs.core.truth_(pred__75763.call(null,new cljs.core.Keyword(null,"IRIREF","IRIREF",1708346892),expr__75764))){
throw cljs.core.ex_info.call(null,["IRIREF not currently supported as SPARQL predicate. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(iri)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__75764)].join('')));
}
}
});
/**
 * BNF -- String ( LANGTAG | ( '^^' iri ) )?
 */
fluree.db.query.sparql_parser.handle_rdf_literal = (function fluree$db$query$sparql_parser$handle_rdf_literal(rdf_literal){
return clojure.string.join.call(null,rdf_literal);
});
fluree.db.query.sparql_parser.handle_numeric_literal = (function fluree$db$query$sparql_parser$handle_numeric_literal(num_literal){
return cljs.tools.reader.read_string.call(null,num_literal);
});
fluree.db.query.sparql_parser.handle_boolean_literal = (function fluree$db$query$sparql_parser$handle_boolean_literal(bool_lit){
return cljs.tools.reader.read_string.call(null,bool_lit);
});
fluree.db.query.sparql_parser.handle_data_block_value_or_graph_term = (function fluree$db$query$sparql_parser$handle_data_block_value_or_graph_term(data_block_value){
var pred__75766 = cljs.core._EQ_;
var expr__75767 = cljs.core.first.call(null,data_block_value);
if(cljs.core.truth_(pred__75766.call(null,new cljs.core.Keyword(null,"NumericLiteral","NumericLiteral",875234501),expr__75767))){
return fluree.db.query.sparql_parser.handle_boolean_literal.call(null,cljs.core.second.call(null,data_block_value));
} else {
if(cljs.core.truth_(pred__75766.call(null,new cljs.core.Keyword(null,"BooleanLiteral","BooleanLiteral",1524154868),expr__75767))){
return cljs.tools.reader.read_string.call(null,cljs.core.second.call(null,data_block_value));
} else {
if(cljs.core.truth_(pred__75766.call(null,"UNDEF",expr__75767))){
return null;
} else {
if(cljs.core.truth_(pred__75766.call(null,new cljs.core.Keyword(null,"iri","iri",423917494),expr__75767))){
return fluree.db.query.sparql_parser.handle_iri.call(null,cljs.core.second.call(null,data_block_value));
} else {
if(cljs.core.truth_(pred__75766.call(null,new cljs.core.Keyword(null,"RDFLiteral","RDFLiteral",-752460807),expr__75767))){
return fluree.db.query.sparql_parser.handle_rdf_literal.call(null,cljs.core.rest.call(null,data_block_value));
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__75767)].join('')));
}
}
}
}
}
});
fluree.db.query.sparql_parser.handle_inline_data_one_var = (function fluree$db$query$sparql_parser$handle_inline_data_one_var(var_parts){
var variable_key = ((cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.first.call(null,var_parts)),new cljs.core.Keyword(null,"Var","Var",820644153)))?fluree.db.query.sparql_parser.handle_var.call(null,cljs.core.rest.call(null,cljs.core.first.call(null,var_parts))):(function(){throw cljs.core.ex_info.call(null,["Improperly formatted SPARQL query. Note: FlureeDB does not support all SPARQL features. Trouble parsing VALUES: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_parts)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var variable_val = ((cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.second.call(null,var_parts)),new cljs.core.Keyword(null,"DataBlockValue","DataBlockValue",2012223432)))?fluree.db.query.sparql_parser.handle_data_block_value_or_graph_term.call(null,cljs.core.second.call(null,cljs.core.second.call(null,var_parts))):(function(){throw cljs.core.ex_info.call(null,["Improperly formatted SPARQL query. Note: FlureeDB does not support all SPARQL features. Trouble parsing VALUES: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_parts)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return cljs.core.PersistentArrayMap.createAsIfByAssoc([variable_key,variable_val]);
});
fluree.db.query.sparql_parser.handle_values = (function fluree$db$query$sparql_parser$handle_values(values){
var pred__75769 = cljs.core._EQ_;
var expr__75770 = cljs.core.first.call(null,values);
if(cljs.core.truth_(pred__75769.call(null,new cljs.core.Keyword(null,"InlineDataOneVar","InlineDataOneVar",862435727),expr__75770))){
return fluree.db.query.sparql_parser.handle_inline_data_one_var.call(null,cljs.core.rest.call(null,values));
} else {
return new cljs.core.Keyword(null,"else","else",-1508377146);
}
});
fluree.db.query.sparql_parser.handle_modifiers = (function fluree$db$query$sparql_parser$handle_modifiers(query,modifiers){
return cljs.core.reduce.call(null,(function (q,modifier){
var pred__75772 = cljs.core._EQ_;
var expr__75773 = cljs.core.first.call(null,modifier);
if(cljs.core.truth_(pred__75772.call(null,new cljs.core.Keyword(null,"PrettyPrint","PrettyPrint",-706084685),expr__75773))){
return cljs.core.assoc.call(null,q,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),true);
} else {
if(cljs.core.truth_(pred__75772.call(null,new cljs.core.Keyword(null,"ValuesClause","ValuesClause",899621028),expr__75773))){
return cljs.core.update.call(null,q,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,fluree.db.query.sparql_parser.handle_values.call(null,cljs.core.second.call(null,modifier)));
} else {
if(cljs.core.truth_(pred__75772.call(null,new cljs.core.Keyword(null,"else","else",-1508377146),expr__75773))){
throw cljs.core.ex_info.call(null,["Unknown modifier. Note: FlureeDB does not support all SPARQL features. Trouble parsing query modifiers: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(modifier)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__75773)].join('')));
}
}
}
}),query,modifiers);
});
/**
 * BNF -- VarOrTerm | TriplesNode
 */
fluree.db.query.sparql_parser.handle_object = (function fluree$db$query$sparql_parser$handle_object(object){
var pred__75775 = cljs.core._EQ_;
var expr__75776 = cljs.core.first.call(null,object);
if(cljs.core.truth_(pred__75775.call(null,new cljs.core.Keyword(null,"Var","Var",820644153),expr__75776))){
return fluree.db.query.sparql_parser.handle_var.call(null,cljs.core.rest.call(null,object));
} else {
if(cljs.core.truth_(pred__75775.call(null,new cljs.core.Keyword(null,"GraphTerm","GraphTerm",-486780288),expr__75776))){
var res = fluree.db.query.sparql_parser.handle_data_block_value_or_graph_term.call(null,cljs.core.second.call(null,object));
if(cljs.core.vector_QMARK_.call(null,res)){
return cljs.core.second.call(null,res);
} else {
return res;
}
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__75776)].join('')));
}
}
});
/**
 * Given a subject, predicate, and either an ObjectPath or Object List, returns an array of where clauses.
 */
fluree.db.query.sparql_parser.handle_object_in_property_list_path = (function fluree$db$query$sparql_parser$handle_object_in_property_list_path(var_args){
var G__75781 = arguments.length;
switch (G__75781) {
case 3:
return fluree.db.query.sparql_parser.handle_object_in_property_list_path.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.sparql_parser.handle_object_in_property_list_path.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.sparql_parser.handle_object_in_property_list_path.cljs$core$IFn$_invoke$arity$3 = (function (subject,predicate,object){
return fluree.db.query.sparql_parser.handle_object_in_property_list_path.call(null,subject,predicate,object,null);
}));

(fluree.db.query.sparql_parser.handle_object_in_property_list_path.cljs$core$IFn$_invoke$arity$4 = (function (subject,predicate,object,source){
var pred__75782 = cljs.core._EQ_;
var expr__75783 = cljs.core.first.call(null,object);
if(cljs.core.truth_(pred__75782.call(null,new cljs.core.Keyword(null,"ObjectPath","ObjectPath",681501430),expr__75783))){
if(cljs.core.truth_(source)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [source,subject,predicate,fluree.db.query.sparql_parser.handle_object.call(null,cljs.core.second.call(null,object))], null)], null);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,predicate,fluree.db.query.sparql_parser.handle_object.call(null,cljs.core.second.call(null,object))], null)], null);
}
} else {
if(cljs.core.truth_(pred__75782.call(null,new cljs.core.Keyword(null,"ObjectList","ObjectList",735181858),expr__75783))){
if(cljs.core.truth_(source)){
return cljs.core.map.call(null,(function (p1__75778_SHARP_){
return (new cljs.core.PersistentVector(null,4,(5),cljs.core.PersistentVector.EMPTY_NODE,[source,subject,predicate,fluree.db.query.sparql_parser.handle_object.call(null,cljs.core.second.call(null,p1__75778_SHARP_))],null));
}),cljs.core.rest.call(null,object));
} else {
return cljs.core.map.call(null,(function (p1__75779_SHARP_){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,predicate,fluree.db.query.sparql_parser.handle_object.call(null,cljs.core.second.call(null,p1__75779_SHARP_))],null));
}),cljs.core.rest.call(null,object));
}
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__75783)].join('')));
}
}
}));

(fluree.db.query.sparql_parser.handle_object_in_property_list_path.cljs$lang$maxFixedArity = 4);

/**
 * Return source and predicate.
 *   BNF -- iri | 'a' | '!'
 *   a becomes rdf:type, and ! is not currently supported. 
 */
fluree.db.query.sparql_parser.handle_path_primary = (function fluree$db$query$sparql_parser$handle_path_primary(path_primary){
if(((cljs.core.coll_QMARK_.call(null,path_primary)) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"iri","iri",423917494),cljs.core.first.call(null,path_primary))))){
return fluree.db.query.sparql_parser.handle_iri.call(null,cljs.core.second.call(null,path_primary));
} else {
if(cljs.core._EQ_.call(null,path_primary,"a")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["$fdb","rdf:type"], null);
} else {
if(cljs.core._EQ_.call(null,path_primary,"!")){
throw cljs.core.ex_info.call(null,"! not currently supported as SPARQL predicate.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
return null;
}
}
}
});
fluree.db.query.sparql_parser.supported_path_mod = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["*",null,"+",null], null), null);
fluree.db.query.sparql_parser.handle_path_mod = (function fluree$db$query$sparql_parser$handle_path_mod(mod){
var mod_type = (function (){var or__5045__auto__ = fluree.db.query.sparql_parser.supported_path_mod.call(null,cljs.core.first.call(null,mod));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["The path modification: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,mod))," is not currently supported. "].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
if(cljs.core._EQ_.call(null,(2),cljs.core.count.call(null,mod))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mod_type),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.nth.call(null,mod,(1)))].join('');
} else {
return mod_type;
}
});
/**
 * Returns a predicate name and source.
 *   BNF -- PathPrimary PathMod?
 *   PathMod being - ?, *, +, the only one which we currently support is +
 *   
 */
fluree.db.query.sparql_parser.handle_path_sequence = (function fluree$db$query$sparql_parser$handle_path_sequence(path_sequence){
var vec__75786 = fluree.db.query.sparql_parser.handle_path_primary.call(null,cljs.core.second.call(null,cljs.core.first.call(null,path_sequence)));
var source = cljs.core.nth.call(null,vec__75786,(0),null);
var predicate = cljs.core.nth.call(null,vec__75786,(1),null);
var predicate__$1 = (function (){var temp__5802__auto__ = cljs.core.second.call(null,path_sequence);
if(cljs.core.truth_(temp__5802__auto__)){
var mod = temp__5802__auto__;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(predicate),cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.query.sparql_parser.handle_path_mod.call(null,cljs.core.rest.call(null,mod)))].join('');
} else {
return predicate;
}
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [source,predicate__$1], null);
});
/**
 * Returns an array of where clauses, i.e. [[?s ?p ?o] [?s ?p1 ?o1]]
 *   BNF -- ( Path | Var ) ObjectPath ( ( ( Path | Simple ) ObjectList )? )* 
 */
fluree.db.query.sparql_parser.handle_property_list_path_not_empty = (function fluree$db$query$sparql_parser$handle_property_list_path_not_empty(subject,prop_path){
var G__75792 = prop_path;
var vec__75793 = G__75792;
var seq__75794 = cljs.core.seq.call(null,vec__75793);
var first__75795 = cljs.core.first.call(null,seq__75794);
var seq__75794__$1 = cljs.core.next.call(null,seq__75794);
var path_item = first__75795;
var r = seq__75794__$1;
var most_recent_pred = null;
var most_recent_source = null;
var clauses = cljs.core.PersistentVector.EMPTY;
var G__75792__$1 = G__75792;
var most_recent_pred__$1 = most_recent_pred;
var most_recent_source__$1 = most_recent_source;
var clauses__$1 = clauses;
while(true){
var vec__75805 = G__75792__$1;
var seq__75806 = cljs.core.seq.call(null,vec__75805);
var first__75807 = cljs.core.first.call(null,seq__75806);
var seq__75806__$1 = cljs.core.next.call(null,seq__75806);
var path_item__$1 = first__75807;
var r__$1 = seq__75806__$1;
var most_recent_pred__$2 = most_recent_pred__$1;
var most_recent_source__$2 = most_recent_source__$1;
var clauses__$2 = clauses__$1;
if(cljs.core.truth_(path_item__$1)){
var pred__75808 = cljs.core._EQ_;
var expr__75809 = cljs.core.first.call(null,path_item__$1);
if(cljs.core.truth_(pred__75808.call(null,new cljs.core.Keyword(null,"Var","Var",820644153),expr__75809))){
var predicate = fluree.db.query.sparql_parser.handle_var.call(null,cljs.core.rest.call(null,path_item__$1));
var object = cljs.core.first.call(null,r__$1);
var new_r = cljs.core.rest.call(null,r__$1);
var new_clauses = fluree.db.query.sparql_parser.handle_object_in_property_list_path.call(null,subject,predicate,object);
var G__75814 = new_r;
var G__75815 = predicate;
var G__75816 = most_recent_source__$2;
var G__75817 = cljs.core.concat.call(null,clauses__$2,new_clauses);
G__75792__$1 = G__75814;
most_recent_pred__$1 = G__75815;
most_recent_source__$1 = G__75816;
clauses__$1 = G__75817;
continue;
} else {
if(cljs.core.truth_(pred__75808.call(null,new cljs.core.Keyword(null,"PathSequence","PathSequence",605463677),expr__75809))){
var vec__75811 = fluree.db.query.sparql_parser.handle_path_sequence.call(null,cljs.core.rest.call(null,path_item__$1));
var source = cljs.core.nth.call(null,vec__75811,(0),null);
var predicate = cljs.core.nth.call(null,vec__75811,(1),null);
var object = cljs.core.first.call(null,r__$1);
var new_r = cljs.core.rest.call(null,r__$1);
var new_clauses = fluree.db.query.sparql_parser.handle_object_in_property_list_path.call(null,subject,predicate,object,source);
var G__75818 = new_r;
var G__75819 = predicate;
var G__75820 = source;
var G__75821 = cljs.core.concat.call(null,clauses__$2,new_clauses);
G__75792__$1 = G__75818;
most_recent_pred__$1 = G__75819;
most_recent_source__$1 = G__75820;
clauses__$1 = G__75821;
continue;
} else {
if(cljs.core.truth_(pred__75808.call(null,new cljs.core.Keyword(null,"ObjectPath","ObjectPath",681501430),expr__75809))){
var G__75822 = r__$1;
var G__75823 = most_recent_pred__$2;
var G__75824 = most_recent_source__$2;
var G__75825 = cljs.core.concat.call(null,clauses__$2,fluree.db.query.sparql_parser.handle_object_in_property_list_path.call(null,subject,most_recent_pred__$2,path_item__$1,most_recent_source__$2));
G__75792__$1 = G__75822;
most_recent_pred__$1 = G__75823;
most_recent_source__$1 = G__75824;
clauses__$1 = G__75825;
continue;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__75809)].join('')));
}
}
}
} else {
return clauses__$2;
}
break;
}
});
/**
 * Returns array of clauses.
 *   BNF -- VarOrTerm PropertyListPathNotEmpty | TriplesNodePath PropertyListPath.
 */
fluree.db.query.sparql_parser.handle_triples_same_subject_path = (function fluree$db$query$sparql_parser$handle_triples_same_subject_path(same_subject_path){
var subject = fluree.db.query.sparql_parser.handle_var.call(null,cljs.core.rest.call(null,cljs.core.first.call(null,same_subject_path)));
return cljs.core.reduce.call(null,(function (where_arr,where_item){
var pred__75826 = cljs.core._EQ_;
var expr__75827 = cljs.core.first.call(null,where_item);
if(cljs.core.truth_(pred__75826.call(null,new cljs.core.Keyword(null,"PropertyListPathNotEmpty","PropertyListPathNotEmpty",162664507),expr__75827))){
return cljs.core.concat.call(null,where_arr,fluree.db.query.sparql_parser.handle_property_list_path_not_empty.call(null,subject,cljs.core.rest.call(null,where_item)));
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__75827)].join('')));
}
}),cljs.core.PersistentVector.EMPTY,cljs.core.drop.call(null,(1),same_subject_path));
});
/**
 * TriplesSameSubjectPath ( <'.'> TriplesBlock? )?
 */
fluree.db.query.sparql_parser.handle_triples_block = (function fluree$db$query$sparql_parser$handle_triples_block(triples_block){
return cljs.core.apply.call(null,cljs.core.concat,cljs.core.map.call(null,(function (triple_item){
var pred__75829 = cljs.core._EQ_;
var expr__75830 = cljs.core.first.call(null,triple_item);
if(cljs.core.truth_(pred__75829.call(null,new cljs.core.Keyword(null,"TriplesBlock","TriplesBlock",124585844),expr__75830))){
return fluree.db.query.sparql_parser.handle_triples_block.call(null,cljs.core.rest.call(null,triple_item));
} else {
if(cljs.core.truth_(pred__75829.call(null,new cljs.core.Keyword(null,"TriplesSameSubjectPath","TriplesSameSubjectPath",670174210),expr__75830))){
return fluree.db.query.sparql_parser.handle_triples_same_subject_path.call(null,cljs.core.rest.call(null,triple_item));
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__75830)].join('')));
}
}
}),triples_block));
});
/**
 * BNF -- iri ArgList?
 */
fluree.db.query.sparql_parser.handle_iri_or_function = (function fluree$db$query$sparql_parser$handle_iri_or_function(iri_or_function){
return cljs.core.map.call(null,(function (p1__75832_SHARP_){
var pred__75833 = cljs.core._EQ_;
var expr__75834 = cljs.core.first.call(null,p1__75832_SHARP_);
if(cljs.core.truth_(pred__75833.call(null,new cljs.core.Keyword(null,"iri","iri",423917494),expr__75834))){
return fluree.db.query.sparql_parser.handle_iri.call(null,cljs.core.rest.call(null,p1__75832_SHARP_));
} else {
if(cljs.core.truth_(pred__75833.call(null,new cljs.core.Keyword(null,"ArgList","ArgList",343747228),expr__75834))){
return fluree.db.query.sparql_parser.handle_arg_list.call(null,cljs.core.rest.call(null,p1__75832_SHARP_));
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__75834)].join('')));
}
}
}),iri_or_function);
});
fluree.db.query.sparql_parser.supported_aggregates = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 7, ["SUM",null,"MEDIAN",null,"COUNT",null,"AVG",null,"MIN",null,"MAX",null,"SAMPLE",null], null), null);
fluree.db.query.sparql_parser.handle_aggregate = (function fluree$db$query$sparql_parser$handle_aggregate(aggregate){
var function$ = fluree.db.query.sparql_parser.supported_aggregates.call(null,cljs.core.first.call(null,aggregate));
var distinct_QMARK_ = ((typeof cljs.core.second.call(null,aggregate) === 'string') && (cljs.core._EQ_.call(null,"DISTINCT",cljs.core.second.call(null,aggregate))));
var function$__$1 = ((((distinct_QMARK_) && (cljs.core._EQ_.call(null,function$,"COUNT"))))?"count-distinct":((distinct_QMARK_)?(function(){throw cljs.core.ex_info.call(null,["Distinct option is currently not supported in functions other than count. Provided function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function$)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():function$
));
var expressions = ((distinct_QMARK_)?cljs.core.drop.call(null,(2),aggregate):cljs.core.drop.call(null,(1),aggregate));
var expressions__$1 = cljs.core.map.call(null,(function (p1__75836_SHARP_){
return cljs.core.first.call(null,fluree.db.query.sparql_parser.handle_expression.call(null,cljs.core.rest.call(null,p1__75836_SHARP_)));
}),expressions);
return ["(",clojure.string.lower_case.call(null,function$__$1)," ",clojure.string.join.call(null," ",expressions__$1),")"].join('');
});
fluree.db.query.sparql_parser.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 49, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"BOUND",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"DATATYPE",null,"IRI",null,"isNUMERIC",null,"BNODE",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"URI",null,"ROUND",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"LANG",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null,"LANGMATCHES",null], null), null);
fluree.db.query.sparql_parser.supported_functions = cljs.core.PersistentHashMap.fromArrays(["STRSTARTS","IF","COALESCE","STRLEN","CONCAT","CEIL","RAND","STRENDS","FLOOR","STR","ABS"],["strStarts","if","coalesce","count","groupconcat","ceil","rand","strEnds","floor","str","abs"]);
/**
 * BNF is Aggregate or {FUN}( Expression ). Where FUN could be one of 50+ functions.
 *   There's some other variation possible here, including  functions take a var instead of an expression and other functions can take more than one expression.
 */
fluree.db.query.sparql_parser.handle_built_in_call = (function fluree$db$query$sparql_parser$handle_built_in_call(built_in){
if(typeof cljs.core.first.call(null,built_in) === 'string'){
var function$ = cljs.core.get.call(null,fluree.db.query.sparql_parser.supported_functions,cljs.core.first.call(null,built_in));
var _ = (cljs.core.truth_(function$)?null:(function(){throw cljs.core.ex_info.call(null,"This function is not yet implemented in SPARQL",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var args = cljs.core.flatten.call(null,fluree.db.query.sparql_parser.handle_arg_list.call(null,cljs.core.rest.call(null,cljs.core.second.call(null,built_in))));
return ["(",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function$)," ",clojure.string.join.call(null," ",args),")"].join('');
} else {
if(cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.first.call(null,built_in)),new cljs.core.Keyword(null,"Aggregate","Aggregate",2098352429))){
return fluree.db.query.sparql_parser.handle_aggregate.call(null,cljs.core.rest.call(null,cljs.core.first.call(null,built_in)));
} else {
return null;
}
}
});
/**
 * BNF -- UnaryExpression ( '*' UnaryExpression | '/' UnaryExpression )*
 */
fluree.db.query.sparql_parser.handle_multiplicative_expression = (function fluree$db$query$sparql_parser$handle_multiplicative_expression(mult_exp){
var pred__75837 = cljs.core._EQ_;
var expr__75838 = cljs.core.first.call(null,mult_exp);
if(cljs.core.truth_(pred__75837.call(null,new cljs.core.Keyword(null,"BrackettedExpresion","BrackettedExpresion",-1997810743),expr__75838))){
return fluree.db.query.sparql_parser.handle_expression.call(null,cljs.core.rest.call(null,mult_exp));
} else {
if(cljs.core.truth_(pred__75837.call(null,new cljs.core.Keyword(null,"BuiltInCall","BuiltInCall",-1460465838),expr__75838))){
return fluree.db.query.sparql_parser.handle_built_in_call.call(null,cljs.core.rest.call(null,mult_exp));
} else {
if(cljs.core.truth_(pred__75837.call(null,new cljs.core.Keyword(null,"iriOrFunction","iriOrFunction",457755910),expr__75838))){
return fluree.db.query.sparql_parser.handle_iri_or_function.call(null,cljs.core.rest.call(null,mult_exp));
} else {
if(cljs.core.truth_(pred__75837.call(null,new cljs.core.Keyword(null,"RDFLiteral","RDFLiteral",-752460807),expr__75838))){
return fluree.db.query.sparql_parser.handle_rdf_literal.call(null,cljs.core.rest.call(null,mult_exp));
} else {
if(cljs.core.truth_(pred__75837.call(null,new cljs.core.Keyword(null,"NumericLiteral","NumericLiteral",875234501),expr__75838))){
return fluree.db.query.sparql_parser.handle_numeric_literal.call(null,cljs.core.second.call(null,mult_exp));
} else {
if(cljs.core.truth_(pred__75837.call(null,new cljs.core.Keyword(null,"BooleanLiteral","BooleanLiteral",1524154868),expr__75838))){
return fluree.db.query.sparql_parser.handle_boolean_literal.call(null,cljs.core.second.call(null,mult_exp));
} else {
if(cljs.core.truth_(pred__75837.call(null,new cljs.core.Keyword(null,"Var","Var",820644153),expr__75838))){
return fluree.db.query.sparql_parser.handle_var.call(null,cljs.core.rest.call(null,mult_exp));
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__75838)].join('')));
}
}
}
}
}
}
}
});
fluree.db.query.sparql_parser.arithmetic_ops = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, ["",null,"*",null,"/",null,"-",null,"+",null], null), null);
/**
 * BNF -- MultiplicativeExpression ( '+' MultiplicativeExpression | '-' MultiplicativeExpression | ( NumericLiteralPositive | NumericLiteralPositive ) ( ( '*' UnaryExpression ) | ( '/' UnaryExpression ) )* )
 */
fluree.db.query.sparql_parser.handle_numeric_expression = (function fluree$db$query$sparql_parser$handle_numeric_expression(num_exp){
var exp_group = cljs.core.take.call(null,(3),num_exp);
var r = cljs.core.drop.call(null,(3),num_exp);
var acc = cljs.core.PersistentVector.EMPTY;
while(true){
var pred__75843 = cljs.core._EQ_;
var expr__75844 = cljs.core.count.call(null,exp_group);
if(cljs.core.truth_(pred__75843.call(null,(1),expr__75844))){
return fluree.db.query.sparql_parser.handle_multiplicative_expression.call(null,cljs.core.second.call(null,cljs.core.first.call(null,exp_group)));
} else {
if(cljs.core.truth_(pred__75843.call(null,(2),expr__75844))){
var operator = (function (){var op = cljs.core.first.call(null,exp_group);
var or__5045__auto__ = fluree.db.query.sparql_parser.arithmetic_ops.call(null,op);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Unrecognized or unsupported opertator. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(op)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var mult_exp = fluree.db.query.sparql_parser.handle_multiplicative_expression.call(null,cljs.core.rest.call(null,cljs.core.second.call(null,exp_group)));
var G__75846 = cljs.core.take.call(null,(2),r);
var G__75847 = cljs.core.drop.call(null,(2),r);
var G__75848 = cljs.core.concat.call(null,acc,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [operator,mult_exp], null)], null));
exp_group = G__75846;
r = G__75847;
acc = G__75848;
continue;
} else {
if(cljs.core.truth_(pred__75843.call(null,(3),expr__75844))){
var mult_exp = fluree.db.query.sparql_parser.handle_multiplicative_expression.call(null,cljs.core.rest.call(null,cljs.core.first.call(null,exp_group)));
var operator = (function (){var op = cljs.core.second.call(null,exp_group);
var or__5045__auto__ = fluree.db.query.sparql_parser.arithmetic_ops.call(null,op);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Unrecognized or unsupported opertator. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(op)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var mult_exp_2 = fluree.db.query.sparql_parser.handle_multiplicative_expression.call(null,cljs.core.rest.call(null,cljs.core.nth.call(null,exp_group,(2))));
var G__75849 = cljs.core.take.call(null,(2),r);
var G__75850 = cljs.core.drop.call(null,(2),r);
var G__75851 = cljs.core.concat.call(null,acc,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [mult_exp,operator,mult_exp_2], null)], null));
exp_group = G__75849;
r = G__75850;
acc = G__75851;
continue;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__75844)].join('')));
}
}
}
break;
}
});
fluree.db.query.sparql_parser.comparators = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, ["!=",null,"=",null,"<=",null,">=",null,"<",null,">",null], null), null);
/**
 * Returns expression as string.
 * 
 *   BNF -- NumericExpression ( '=' NumericExpression | '!=' NumericExpression | '<' NumericExpression | '>' NumericExpression | '<=' NumericExpression | '>=' NumericExpression | 'IN' ExpressionList | 'NOT' 'IN' ExpressionList )?
 */
fluree.db.query.sparql_parser.handle_relational_expression = (function fluree$db$query$sparql_parser$handle_relational_expression(rel_exp){
var first_exp = fluree.db.query.sparql_parser.handle_numeric_expression.call(null,cljs.core.rest.call(null,cljs.core.first.call(null,rel_exp)));
var operator = (function (){var temp__5804__auto__ = cljs.core.second.call(null,rel_exp);
if(cljs.core.truth_(temp__5804__auto__)){
var op = temp__5804__auto__;
if(cljs.core.truth_((function (){var and__5043__auto__ = op;
if(cljs.core.truth_(and__5043__auto__)){
return fluree.db.query.sparql_parser.comparators.call(null,op);
} else {
return and__5043__auto__;
}
})())){
return op;
} else {
throw cljs.core.ex_info.call(null,["Unrecognized or unsupported opertator. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(op)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
} else {
return null;
}
})();
var second_exp = (function (){var temp__5804__auto__ = (function (){var and__5043__auto__ = (cljs.core.count.call(null,rel_exp) > (1));
if(and__5043__auto__){
return cljs.core.nth.call(null,rel_exp,(2));
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var second_exp = temp__5804__auto__;
return fluree.db.query.sparql_parser.handle_numeric_expression.call(null,cljs.core.rest.call(null,second_exp));
} else {
return null;
}
})();
if(cljs.core.truth_((function (){var or__5045__auto__ = operator;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return second_exp;
}
})())){
return ["(",cljs.core.str.cljs$core$IFn$_invoke$arity$1(operator)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(first_exp)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(second_exp),")"].join('');
} else {
return first_exp;
}
});
/**
 * BNF -- RelationalExpression*
 */
fluree.db.query.sparql_parser.handle_expression = (function fluree$db$query$sparql_parser$handle_expression(exp){
return cljs.core.map.call(null,(function (exp__$1){
var pred__75852 = cljs.core._EQ_;
var expr__75853 = cljs.core.first.call(null,exp__$1);
if(cljs.core.truth_(pred__75852.call(null,new cljs.core.Keyword(null,"RelationalExpression","RelationalExpression",618397682),expr__75853))){
return fluree.db.query.sparql_parser.handle_relational_expression.call(null,cljs.core.rest.call(null,exp__$1));
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__75853)].join('')));
}
}),exp);
});
/**
 * Returns bind statement inside [ ], i.e. [{"bind": {"?handle": "dsanchez"}}]
 */
fluree.db.query.sparql_parser.handle_bind = (function fluree$db$query$sparql_parser$handle_bind(bind){
var var$ = fluree.db.query.sparql_parser.handle_var.call(null,cljs.core.rest.call(null,cljs.core.second.call(null,bind)));
var bindValue = cljs.core.first.call(null,fluree.db.query.sparql_parser.handle_expression.call(null,cljs.core.rest.call(null,cljs.core.first.call(null,bind))));
var bindValue__$1 = ((clojure.string.starts_with_QMARK_.call(null,bindValue,"("))?["#",cljs.core.str.cljs$core$IFn$_invoke$arity$1(bindValue)].join(''):bindValue);
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"bind","bind",-113428417),cljs.core.PersistentArrayMap.createAsIfByAssoc([var$,bindValue__$1])], null);
});
/**
 * BNF -- NIL | 'DISTINCT'? Expression ( Expression )* 
 */
fluree.db.query.sparql_parser.handle_arg_list = (function fluree$db$query$sparql_parser$handle_arg_list(arg_list){
return cljs.core.map.call(null,(function (arg){
if(cljs.core._EQ_.call(null,"NIL",arg)){
return null;
} else {
if(cljs.core._EQ_.call(null,"DISTINCT",arg)){
return "DISTINCT";
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"Expression","Expression",2047597743),cljs.core.first.call(null,arg))){
return fluree.db.query.sparql_parser.handle_expression.call(null,cljs.core.rest.call(null,arg));
} else {
return null;
}
}
}
}),arg_list);
});
/**
 * TriplesBlock? ( GraphPatternNotTriples <'.'?> TriplesBlock? )* 
 */
fluree.db.query.sparql_parser.handle_group_graph_pattern_sub = (function fluree$db$query$sparql_parser$handle_group_graph_pattern_sub(where_val){
return cljs.core.vec.call(null,cljs.core.apply.call(null,cljs.core.concat,cljs.core.mapv.call(null,(function (where_item){
var pred__75855 = cljs.core._EQ_;
var expr__75856 = cljs.core.first.call(null,where_item);
if(cljs.core.truth_(pred__75855.call(null,new cljs.core.Keyword(null,"TriplesBlock","TriplesBlock",124585844),expr__75856))){
return fluree.db.query.sparql_parser.handle_triples_block.call(null,cljs.core.rest.call(null,where_item));
} else {
if(cljs.core.truth_(pred__75855.call(null,new cljs.core.Keyword(null,"GraphPatternNotTriples","GraphPatternNotTriples",-1967988237),expr__75856))){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.sparql_parser.handle_graph_pattern_not_triples.call(null,cljs.core.second.call(null,where_item))], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__75856)].join('')));
}
}
}),where_val)));
});
/**
 * ( SubSelect | GroupGraphPatternSub )
 */
fluree.db.query.sparql_parser.handle_where_clause = (function fluree$db$query$sparql_parser$handle_where_clause(where_clause){
var pred__75858 = cljs.core._EQ_;
var expr__75859 = cljs.core.first.call(null,where_clause);
if(cljs.core.truth_(pred__75858.call(null,new cljs.core.Keyword(null,"GroupGraphPatternSub","GroupGraphPatternSub",-1079238844),expr__75859))){
return fluree.db.query.sparql_parser.handle_group_graph_pattern_sub.call(null,cljs.core.rest.call(null,where_clause));
} else {
if(cljs.core.truth_(pred__75858.call(null,new cljs.core.Keyword(null,"SubSelect","SubSelect",416686695),expr__75859))){
throw cljs.core.ex_info.call(null,["SubSelect queries not currently supported. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rest.call(null,where_clause))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__75859)].join('')));
}
}
});
/**
 * BNF- BrackettedExpression | BuiltInCall | FunctionCall
 */
fluree.db.query.sparql_parser.handle_constraint = (function fluree$db$query$sparql_parser$handle_constraint(filter_exp){
var pred__75861 = cljs.core._EQ_;
var expr__75862 = cljs.core.first.call(null,filter_exp);
if(cljs.core.truth_(pred__75861.call(null,new cljs.core.Keyword(null,"BrackettedExpression","BrackettedExpression",1460032265),expr__75862))){
return cljs.core.vec.call(null,fluree.db.query.sparql_parser.handle_expression.call(null,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second.call(null,cljs.core.second.call(null,filter_exp))],null))));
} else {
if(cljs.core.truth_(pred__75861.call(null,new cljs.core.Keyword(null,"BuiltInCall","BuiltInCall",-1460465838),expr__75862))){
return fluree.db.query.sparql_parser.handle_built_in_call.call(null,cljs.core.rest.call(null,filter_exp));
} else {
if(cljs.core.truth_(pred__75861.call(null,new cljs.core.Keyword(null,"FunctionCall","FunctionCall",-1248776003),expr__75862))){
throw cljs.core.ex_info.call(null,["This feature is not yet implemented in SPARQL. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_exp)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__75862)].join('')));
}
}
}
});
/**
 * BNF -- GroupGraphPattern ( <'UNION'> GroupGraphPattern )*
 *   {"union": [ [[s p o][s1 p1 p1]] [[s2 p2 o2]] ]   
 */
fluree.db.query.sparql_parser.handle_group_or_union = (function fluree$db$query$sparql_parser$handle_group_or_union(group_or_union){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"union","union",2142937499),cljs.core.mapv.call(null,fluree.db.query.sparql_parser.handle_where_clause,group_or_union)], null);
});
fluree.db.query.sparql_parser.handle_optional_graph_pattern = (function fluree$db$query$sparql_parser$handle_optional_graph_pattern(optional){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"optional","optional",2053951509),cljs.core.first.call(null,cljs.core.mapv.call(null,fluree.db.query.sparql_parser.handle_where_clause,optional))], null);
});
/**
 * BNF -- GroupOrUnionGraphPattern | OptionalGraphPattern | MinusGraphPattern | GraphGraphPattern | ServiceGraphPattern | Filter | Bind | InlineData
 */
fluree.db.query.sparql_parser.handle_graph_pattern_not_triples = (function fluree$db$query$sparql_parser$handle_graph_pattern_not_triples(not_triples){
var pred__75864 = cljs.core._EQ_;
var expr__75865 = cljs.core.first.call(null,not_triples);
if(cljs.core.truth_(pred__75864.call(null,new cljs.core.Keyword(null,"GroupOrUnionGraphPattern","GroupOrUnionGraphPattern",406579851),expr__75865))){
return fluree.db.query.sparql_parser.handle_group_or_union.call(null,cljs.core.rest.call(null,not_triples));
} else {
if(cljs.core.truth_(pred__75864.call(null,new cljs.core.Keyword(null,"OptionalGraphPattern","OptionalGraphPattern",1935225185),expr__75865))){
return fluree.db.query.sparql_parser.handle_optional_graph_pattern.call(null,cljs.core.rest.call(null,not_triples));
} else {
if(cljs.core.truth_(pred__75864.call(null,new cljs.core.Keyword(null,"MinusGraphPattern","MinusGraphPattern",-459665303),expr__75865))){
throw cljs.core.ex_info.call(null,["This feature is not yet implemented in SPARQL. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(not_triples)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_(pred__75864.call(null,new cljs.core.Keyword(null,"GraphGraphPattern","GraphGraphPattern",-1896647490),expr__75865))){
throw cljs.core.ex_info.call(null,["This feature is not yet implemented in SPARQL. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(not_triples)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_(pred__75864.call(null,new cljs.core.Keyword(null,"ServiceGraphPattern","ServiceGraphPattern",-1979206159),expr__75865))){
throw cljs.core.ex_info.call(null,["This feature is not yet implemented in SPARQL. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(not_triples)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_(pred__75864.call(null,new cljs.core.Keyword(null,"Filter","Filter",-2065424859),expr__75865))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"filter","filter",-948537934),fluree.db.query.sparql_parser.handle_constraint.call(null,cljs.core.second.call(null,cljs.core.second.call(null,not_triples)))], null);
} else {
if(cljs.core.truth_(pred__75864.call(null,new cljs.core.Keyword(null,"Bind","Bind",-309756020),expr__75865))){
return fluree.db.query.sparql_parser.handle_bind.call(null,cljs.core.rest.call(null,not_triples));
} else {
if(cljs.core.truth_(pred__75864.call(null,new cljs.core.Keyword(null,"InlineData","InlineData",1277913531),expr__75865))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"bind","bind",-113428417),fluree.db.query.sparql_parser.handle_values.call(null,cljs.core.second.call(null,not_triples))], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__75865)].join('')));
}
}
}
}
}
}
}
}
});
/**
 * BNF -- BuiltInCall | FunctionCall | Expression ( 'AS' Var )? | Var
 */
fluree.db.query.sparql_parser.handle_group_condition = (function fluree$db$query$sparql_parser$handle_group_condition(group_condition){
var pred__75867 = cljs.core._EQ_;
var expr__75868 = cljs.core.first.call(null,group_condition);
if(cljs.core.truth_(pred__75867.call(null,new cljs.core.Keyword(null,"Var","Var",820644153),expr__75868))){
return fluree.db.query.sparql_parser.handle_var.call(null,cljs.core.rest.call(null,group_condition));
} else {
if(cljs.core.truth_(pred__75867.call(null,new cljs.core.Keyword(null,"BuiltInCall","BuiltInCall",-1460465838),expr__75868))){
throw cljs.core.ex_info.call(null,["This format of GroupBy is not currently supported. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(group_condition)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_(pred__75867.call(null,new cljs.core.Keyword(null,"FunctionCall","FunctionCall",-1248776003),expr__75868))){
throw cljs.core.ex_info.call(null,["This format of GroupBy is not currently supported. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(group_condition)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_(pred__75867.call(null,new cljs.core.Keyword(null,"Expression","Expression",2047597743),expr__75868))){
throw cljs.core.ex_info.call(null,["This format of GroupBy is not currently supported. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(group_condition)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__75868)].join('')));
}
}
}
}
});
/**
 * BNF -- ( ( 'ASC' | 'DESC' ) BrackettedExpression ) | ( Constraint | Var )
 */
fluree.db.query.sparql_parser.handle_order_condition = (function fluree$db$query$sparql_parser$handle_order_condition(order_condition){
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null).call(null,cljs.core.first.call(null,order_condition)))){
var exp = cljs.core.second.call(null,cljs.core.second.call(null,order_condition));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,order_condition),cljs.core.first.call(null,fluree.db.query.sparql_parser.handle_expression.call(null,cljs.core.rest.call(null,cljs.core.second.call(null,cljs.core.second.call(null,order_condition)))))], null);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"Var","Var",820644153),cljs.core.first.call(null,cljs.core.first.call(null,order_condition)))){
return fluree.db.query.sparql_parser.handle_var.call(null,cljs.core.rest.call(null,cljs.core.first.call(null,order_condition)));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"Constraint","Constraint",-1624928190),cljs.core.first.call(null,cljs.core.first.call(null,order_condition)))){
throw cljs.core.ex_info.call(null,["Ordering by a constraint not currently supported. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(order_condition)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
return null;
}
}
}
});
fluree.db.query.sparql_parser.handle_having_condition = (function fluree$db$query$sparql_parser$handle_having_condition(having_condition){
var expressions = cljs.core.rest.call(null,cljs.core.second.call(null,cljs.core.second.call(null,having_condition)));
var _ = (((cljs.core.count.call(null,expressions) > (1)))?(function(){throw cljs.core.ex_info.call(null,"Multiple 'HAVING' expressions in SPARQL not currently supported, please let us know you'd like this supported!",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
var parsed = fluree.db.query.sparql_parser.handle_expression.call(null,expressions);
return cljs.core.first.call(null,parsed);
});
fluree.db.query.sparql_parser.handle_solution_modifier = (function fluree$db$query$sparql_parser$handle_solution_modifier(solution_modifier){
return cljs.core.reduce.call(null,(function (acc,modifier){
var pred__75872 = cljs.core._EQ_;
var expr__75873 = cljs.core.first.call(null,modifier);
if(cljs.core.truth_(pred__75872.call(null,new cljs.core.Keyword(null,"LimitClause","LimitClause",-2065977212),expr__75873))){
return cljs.core.assoc.call(null,acc,new cljs.core.Keyword(null,"limit","limit",-1355822363),cljs.tools.reader.read_string.call(null,cljs.core.second.call(null,modifier)));
} else {
if(cljs.core.truth_(pred__75872.call(null,new cljs.core.Keyword(null,"OffsetClause","OffsetClause",198784535),expr__75873))){
return cljs.core.assoc.call(null,acc,new cljs.core.Keyword(null,"offset","offset",296498311),cljs.tools.reader.read_string.call(null,cljs.core.second.call(null,modifier)));
} else {
if(cljs.core.truth_(pred__75872.call(null,new cljs.core.Keyword(null,"GroupClause","GroupClause",1310621742),expr__75873))){
var group_conditions = cljs.core.rest.call(null,modifier);
var groupBy = ((cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,group_conditions)))?fluree.db.query.sparql_parser.handle_group_condition.call(null,cljs.core.second.call(null,cljs.core.first.call(null,group_conditions))):cljs.core.mapv.call(null,(function (p1__75870_SHARP_){
return fluree.db.query.sparql_parser.handle_group_condition.call(null,cljs.core.second.call(null,p1__75870_SHARP_));
}),group_conditions));
return cljs.core.assoc.call(null,acc,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy);
} else {
if(cljs.core.truth_(pred__75872.call(null,new cljs.core.Keyword(null,"OrderClause","OrderClause",-1331818348),expr__75873))){
return cljs.core.assoc.call(null,acc,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),fluree.db.query.sparql_parser.handle_order_condition.call(null,cljs.core.rest.call(null,modifier)));
} else {
if(cljs.core.truth_(pred__75872.call(null,new cljs.core.Keyword(null,"HavingClause","HavingClause",607452806),expr__75873))){
var having_condition = cljs.core.second.call(null,cljs.core.some.call(null,(function (p1__75871_SHARP_){
if(((cljs.core.vector_QMARK_.call(null,p1__75871_SHARP_)) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"HavingCondition","HavingCondition",1275557408),cljs.core.first.call(null,p1__75871_SHARP_))))){
return p1__75871_SHARP_;
} else {
return null;
}
}),modifier));
var having = fluree.db.query.sparql_parser.handle_having_condition.call(null,having_condition);
return cljs.core.assoc.call(null,acc,new cljs.core.Keyword(null,"having","having",-399543166),having);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__75873)].join('')));
}
}
}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,solution_modifier);
});
fluree.db.query.sparql_parser.supported_select_options = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["REDUCED",null,"DISTINCT",null], null), null);
fluree.db.query.sparql_parser.handle_select = (function fluree$db$query$sparql_parser$handle_select(query,select){
var query__$1 = query;
var G__75878 = select;
var vec__75879 = G__75878;
var seq__75880 = cljs.core.seq.call(null,vec__75879);
var first__75881 = cljs.core.first.call(null,seq__75880);
var seq__75880__$1 = cljs.core.next.call(null,seq__75880);
var item = first__75881;
var r = seq__75880__$1;
var query__$2 = query__$1;
var G__75878__$1 = G__75878;
while(true){
var query__$3 = query__$2;
var vec__75882 = G__75878__$1;
var seq__75883 = cljs.core.seq.call(null,vec__75882);
var first__75884 = cljs.core.first.call(null,seq__75883);
var seq__75883__$1 = cljs.core.next.call(null,seq__75883);
var item__$1 = first__75884;
var r__$1 = seq__75883__$1;
if(cljs.core.not.call(null,item__$1)){
var q = cljs.core.update.call(null,query__$3,new cljs.core.Keyword(null,"select","select",1147833503),cljs.core.vec);
var temp__5802__auto__ = new cljs.core.Keyword(null,"selectKey","selectKey",1621046327).cljs$core$IFn$_invoke$arity$1(q);
if(cljs.core.truth_(temp__5802__auto__)){
var select_key = temp__5802__auto__;
return cljs.core.dissoc.call(null,clojure.set.rename_keys.call(null,q,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"select","select",1147833503),select_key], null)),new cljs.core.Keyword(null,"selectKey","selectKey",1621046327));
} else {
return q;
}
} else {
var vec__75885 = ((typeof item__$1 === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,query__$3,new cljs.core.Keyword(null,"selectKey","selectKey",1621046327),cljs.core.keyword.call(null,["select",clojure.string.capitalize.call(null,item__$1)].join(''))),r__$1], null):(function (){var pred__75888 = cljs.core._EQ_;
var expr__75889 = cljs.core.first.call(null,item__$1);
if(cljs.core.truth_(pred__75888.call(null,new cljs.core.Keyword(null,"Var","Var",820644153),expr__75889))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update.call(null,query__$3,new cljs.core.Keyword(null,"select","select",1147833503),cljs.core.concat,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.sparql_parser.handle_var.call(null,cljs.core.rest.call(null,item__$1))], null)),r__$1], null);
} else {
if(cljs.core.truth_(pred__75888.call(null,new cljs.core.Keyword(null,"Expression","Expression",2047597743),expr__75889))){
var exp = cljs.core.first.call(null,fluree.db.query.sparql_parser.handle_expression.call(null,cljs.core.rest.call(null,item__$1)));
var next_as_QMARK_ = cljs.core._EQ_.call(null,"AS",cljs.core.first.call(null,r__$1));
var vec__75891 = ((next_as_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [["(as ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(exp)," ",fluree.db.query.sparql_parser.handle_var.call(null,cljs.core.rest.call(null,cljs.core.second.call(null,r__$1))),")"].join(''),cljs.core.drop.call(null,(2),r__$1)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [exp,r__$1], null));
var exp__$1 = cljs.core.nth.call(null,vec__75891,(0),null);
var r__$2 = cljs.core.nth.call(null,vec__75891,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update.call(null,query__$3,new cljs.core.Keyword(null,"select","select",1147833503),cljs.core.concat,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [exp__$1], null)),r__$2], null);
} else {
if(cljs.core.truth_(pred__75888.call(null,new cljs.core.Keyword(null,"WhereClause","WhereClause",-1077178064),expr__75889))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,query__$3,new cljs.core.Keyword(null,"where","where",-2044795965),cljs.core.vec.call(null,fluree.db.query.sparql_parser.handle_where_clause.call(null,cljs.core.second.call(null,item__$1)))),r__$1], null);
} else {
if(cljs.core.truth_(pred__75888.call(null,new cljs.core.Keyword(null,"SolutionModifier","SolutionModifier",-1718092900),expr__75889))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,query__$3,fluree.db.query.sparql_parser.handle_solution_modifier.call(null,cljs.core.rest.call(null,item__$1))),r__$1], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__75889)].join('')));
}
}
}
}
})());
var q = cljs.core.nth.call(null,vec__75885,(0),null);
var r__$2 = cljs.core.nth.call(null,vec__75885,(1),null);
var G__75894 = q;
var G__75895 = r__$2;
query__$2 = G__75894;
G__75878__$1 = G__75895;
continue;
}
break;
}
});
/**
 * BNF -- ( BaseDec1 | PrefixDec1 )*
 */
fluree.db.query.sparql_parser.handle_prologue = (function fluree$db$query$sparql_parser$handle_prologue(prologue){
return cljs.core.reduce.call(null,(function (acc,pro){
var pred__75896 = cljs.core._EQ_;
var expr__75897 = cljs.core.first.call(null,pro);
if(cljs.core.truth_(pred__75896.call(null,new cljs.core.Keyword(null,"BaseDec1","BaseDec1",1363035735),expr__75897))){
throw cljs.core.ex_info.call(null,["Base URIs not currently supported in SPARQL implementation. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rest.call(null,pro))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_(pred__75896.call(null,new cljs.core.Keyword(null,"PrefixDec1","PrefixDec1",-587881537),expr__75897))){
return cljs.core.merge.call(null,acc,fluree.db.query.sparql_parser.handle_prefix_dec1.call(null,cljs.core.rest.call(null,pro)));
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__75897)].join('')));
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prologue);
});
fluree.db.query.sparql_parser.sparql_parsed__GT_analytical = (function fluree$db$query$sparql_parser$sparql_parsed__GT_analytical(parsed){
return cljs.core.reduce.call(null,(function (query,top_level){
var pred__75899 = cljs.core._EQ_;
var expr__75900 = cljs.core.first.call(null,top_level);
if(cljs.core.truth_(pred__75899.call(null,new cljs.core.Keyword(null,"Prologue","Prologue",149256287),expr__75900))){
return cljs.core.assoc.call(null,query,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197),fluree.db.query.sparql_parser.handle_prologue.call(null,cljs.core.rest.call(null,top_level)));
} else {
if(cljs.core.truth_(pred__75899.call(null,new cljs.core.Keyword(null,"Modifiers","Modifiers",717414284),expr__75900))){
if(cljs.core.truth_(fluree.db.query.sparql_parser.valid_modifiers_QMARK_)){
return fluree.db.query.sparql_parser.handle_modifiers.call(null,query,cljs.core.rest.call(null,top_level));
} else {
return null;
}
} else {
if(cljs.core.truth_(pred__75899.call(null,new cljs.core.Keyword(null,"SelectQuery","SelectQuery",-1304496464),expr__75900))){
return fluree.db.query.sparql_parser.handle_select.call(null,query,cljs.core.rest.call(null,top_level));
} else {
if(cljs.core.truth_(pred__75899.call(null,new cljs.core.Keyword(null,"else","else",-1508377146),expr__75900))){
throw cljs.core.ex_info.call(null,["Improperly formatted SPARQL query. Note: FlureeDB does not support all SPARQL features. Trouble parsing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,top_level))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__75900)].join('')));
}
}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,parsed);
});
fluree.db.query.sparql_parser.sparql_to_ad_hoc = (function fluree$db$query$sparql_parser$sparql_to_ad_hoc(sparql_query){
var sparql_parsed = fluree.db.query.sparql_parser.sparql.call(null,sparql_query);
var _ = ((cljs.core._EQ_.call(null,instaparse.gll.Failure,cljs.core.type.call(null,sparql_parsed)))?(function(){throw cljs.core.ex_info.call(null,["Improperly formatted SPARQL query. Note: FlureeDB does not support all SPARQL features. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(sparql_query)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return fluree.db.query.sparql_parser.sparql_parsed__GT_analytical.call(null,sparql_parsed);
});
