// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.subject_crawl.common');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.schema');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.query.fql_resp');
/**
 * Transducing function to extract matching subjects from initial where clause.
 */
fluree.db.query.subject_crawl.common.where_subj_xf = (function fluree$db$query$subject_crawl$common$where_subj_xf(p__23485){
var map__23486 = p__23485;
var map__23486__$1 = cljs.core.__destructure_map.call(null,map__23486);
var start_test = cljs.core.get.call(null,map__23486__$1,new cljs.core.Keyword(null,"start-test","start-test",-952983565));
var start_flake = cljs.core.get.call(null,map__23486__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_test = cljs.core.get.call(null,map__23486__$1,new cljs.core.Keyword(null,"end-test","end-test",481973727));
var end_flake = cljs.core.get.call(null,map__23486__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var xf = cljs.core.get.call(null,map__23486__$1,new cljs.core.Keyword(null,"xf","xf",401902988));
return cljs.core.apply.call(null,cljs.core.comp,(function (){var G__23487 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.map.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739)),cljs.core.map.call(null,(function (flakes){
return fluree.db.flake.subrange.call(null,flakes,start_test,start_flake,end_test,end_flake);
}))], null);
if(cljs.core.truth_(xf)){
return cljs.core.conj.call(null,G__23487,xf);
} else {
return G__23487;
}
})());
});
fluree.db.query.subject_crawl.common.result_af = (function fluree$db$query$subject_crawl$common$result_af(p__23488){
var map__23489 = p__23488;
var map__23489__$1 = cljs.core.__destructure_map.call(null,map__23489);
var _opts = map__23489__$1;
var db = cljs.core.get.call(null,map__23489__$1,new cljs.core.Keyword(null,"db","db",993250759));
var cache = cljs.core.get.call(null,map__23489__$1,new cljs.core.Keyword(null,"cache","cache",-1237023054));
var fuel_vol = cljs.core.get.call(null,map__23489__$1,new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142));
var max_fuel = cljs.core.get.call(null,map__23489__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var select_spec = cljs.core.get.call(null,map__23489__$1,new cljs.core.Keyword(null,"select-spec","select-spec",55073283));
var error_ch = cljs.core.get.call(null,map__23489__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
return (function (flakes,port){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23520){
var state_val_23521 = (state_23520[(1)]);
if((state_val_23521 === (7))){
var state_23520__$1 = state_23520;
var statearr_23522_23548 = state_23520__$1;
(statearr_23522_23548[(2)] = null);

(statearr_23522_23548[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23521 === (1))){
var state_23520__$1 = state_23520;
var statearr_23523_23549 = state_23520__$1;
(statearr_23523_23549[(2)] = null);

(statearr_23523_23549[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23521 === (4))){
var inst_23490 = (state_23520[(2)]);
var inst_23491 = cljs.core.async.put_BANG_.call(null,error_ch,inst_23490);
var inst_23492 = cljs.core.async.close_BANG_.call(null,port);
var state_23520__$1 = (function (){var statearr_23524 = state_23520;
(statearr_23524[(7)] = inst_23491);

(statearr_23524[(8)] = inst_23492);

return statearr_23524;
})();
var statearr_23525_23550 = state_23520__$1;
(statearr_23525_23550[(2)] = null);

(statearr_23525_23550[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23521 === (6))){
var inst_23502 = (state_23520[(9)]);
var inst_23501 = (state_23520[(2)]);
var inst_23502__$1 = fluree.db.util.async.throw_err.call(null,inst_23501);
var inst_23503 = (inst_23502__$1 == null);
var state_23520__$1 = (function (){var statearr_23526 = state_23520;
(statearr_23526[(9)] = inst_23502__$1);

return statearr_23526;
})();
if(cljs.core.truth_(inst_23503)){
var statearr_23527_23551 = state_23520__$1;
(statearr_23527_23551[(1)] = (7));

} else {
var statearr_23528_23552 = state_23520__$1;
(statearr_23528_23552[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23521 === (3))){
var inst_23518 = (state_23520[(2)]);
var state_23520__$1 = state_23520;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23520__$1,inst_23518);
} else {
if((state_val_23521 === (12))){
var inst_23514 = (state_23520[(2)]);
var inst_23515 = cljs.core.async.close_BANG_.call(null,port);
var _ = (function (){var statearr_23529 = state_23520;
(statearr_23529[(4)] = cljs.core.rest.call(null,(state_23520[(4)])));

return statearr_23529;
})();
var state_23520__$1 = (function (){var statearr_23530 = state_23520;
(statearr_23530[(10)] = inst_23514);

return statearr_23530;
})();
var statearr_23531_23553 = state_23520__$1;
(statearr_23531_23553[(2)] = inst_23515);

(statearr_23531_23553[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23521 === (2))){
var _ = (function (){var statearr_23532 = state_23520;
(statearr_23532[(4)] = cljs.core.cons.call(null,(5),(state_23520[(4)])));

return statearr_23532;
})();
var inst_23499 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel_vol,max_fuel,select_spec,flakes);
var state_23520__$1 = state_23520;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23520__$1,(6),inst_23499);
} else {
if((state_val_23521 === (11))){
var inst_23508 = (state_23520[(11)]);
var inst_23512 = cljs.core.async.put_BANG_.call(null,port,inst_23508);
var state_23520__$1 = state_23520;
var statearr_23534_23554 = state_23520__$1;
(statearr_23534_23554[(2)] = inst_23512);

(statearr_23534_23554[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23521 === (9))){
var inst_23508 = (state_23520[(11)]);
var inst_23508__$1 = (state_23520[(2)]);
var inst_23509 = (inst_23508__$1 == null);
var state_23520__$1 = (function (){var statearr_23535 = state_23520;
(statearr_23535[(11)] = inst_23508__$1);

return statearr_23535;
})();
if(cljs.core.truth_(inst_23509)){
var statearr_23536_23555 = state_23520__$1;
(statearr_23536_23555[(1)] = (10));

} else {
var statearr_23537_23556 = state_23520__$1;
(statearr_23537_23556[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23521 === (5))){
var _ = (function (){var statearr_23538 = state_23520;
(statearr_23538[(4)] = cljs.core.rest.call(null,(state_23520[(4)])));

return statearr_23538;
})();
var state_23520__$1 = state_23520;
var ex23533 = (state_23520__$1[(2)]);
var statearr_23539_23557 = state_23520__$1;
(statearr_23539_23557[(5)] = ex23533);


var statearr_23540_23558 = state_23520__$1;
(statearr_23540_23558[(1)] = (4));

(statearr_23540_23558[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23521 === (10))){
var state_23520__$1 = state_23520;
var statearr_23541_23559 = state_23520__$1;
(statearr_23541_23559[(2)] = null);

(statearr_23541_23559[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23521 === (8))){
var inst_23502 = (state_23520[(9)]);
var inst_23506 = cljs.core.not_empty.call(null,inst_23502);
var state_23520__$1 = state_23520;
var statearr_23542_23560 = state_23520__$1;
(statearr_23542_23560[(2)] = inst_23506);

(statearr_23542_23560[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto____0 = (function (){
var statearr_23543 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23543[(0)] = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto__);

(statearr_23543[(1)] = (1));

return statearr_23543;
});
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto____1 = (function (state_23520){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23520);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23544){var ex__2749__auto__ = e23544;
var statearr_23545_23561 = state_23520;
(statearr_23545_23561[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23520[(4)]))){
var statearr_23546_23562 = state_23520;
(statearr_23546_23562[(1)] = cljs.core.first.call(null,(state_23520[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23563 = state_23520;
state_23520 = G__23563;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto__ = function(state_23520){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto____1.call(this,state_23520);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23547 = f__2769__auto__.call(null);
(statearr_23547[(6)] = c__2768__auto__);

return statearr_23547;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
});
/**
 * Returns a specific filtering function which takes all subject flakes and
 *   returns the flakes allowed, or nil if none are allowed.
 */
fluree.db.query.subject_crawl.common.subj_perm_filter_fn = (function fluree$db$query$subject_crawl$common$subj_perm_filter_fn(p__23564){
var map__23565 = p__23564;
var map__23565__$1 = cljs.core.__destructure_map.call(null,map__23565);
var db = map__23565__$1;
var permissions = cljs.core.get.call(null,map__23565__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var pred_permissions_QMARK_ = cljs.core.contains_QMARK_.call(null,permissions,new cljs.core.Keyword(null,"predicate","predicate",-1742501860));
var coll_permissions = new cljs.core.Keyword(null,"collection","collection",-683361892).cljs$core$IFn$_invoke$arity$1(permissions);
var filter_cache = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var default_deny_QMARK_ = ((new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(coll_permissions) === true)?false:true);
var filter_predicates_QMARK_ = (function (cid){
var temp__5806__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,filter_cache),cid);
if((temp__5806__auto__ == null)){
var coll_perm = cljs.core.get.call(null,coll_permissions,cid);
var filter_QMARK_ = ((fluree.db.util.schema.is_schema_cid_QMARK_.call(null,cid))?false:((pred_permissions_QMARK_)?true:(((coll_perm == null))?default_deny_QMARK_:((((cljs.core.contains_QMARK_.call(null,coll_perm,new cljs.core.Keyword(null,"all","all",892129742))) && (cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,coll_perm)))))?false:true
))));
cljs.core.swap_BANG_.call(null,filter_cache,cljs.core.assoc,cid,filter_QMARK_);

return cljs.core.filter;
} else {
var cached = temp__5806__auto__;
return cached;
}
});
return (function (flakes){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23596){
var state_val_23597 = (state_23596[(1)]);
if((state_val_23597 === (7))){
var inst_23572 = (state_23596[(7)]);
var inst_23582 = fluree.db.permissions_validate.allow_flake_QMARK_.call(null,db,inst_23572);
var state_23596__$1 = state_23596;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23596__$1,(10),inst_23582);
} else {
if((state_val_23597 === (1))){
var state_23596__$1 = state_23596;
var statearr_23598_23621 = state_23596__$1;
(statearr_23598_23621[(2)] = null);

(statearr_23598_23621[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23597 === (4))){
var inst_23566 = (state_23596[(2)]);
var state_23596__$1 = state_23596;
var statearr_23599_23622 = state_23596__$1;
(statearr_23599_23622[(2)] = inst_23566);

(statearr_23599_23622[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23597 === (13))){
var inst_23589 = (state_23596[(2)]);
var state_23596__$1 = state_23596;
var statearr_23600_23623 = state_23596__$1;
(statearr_23600_23623[(2)] = inst_23589);

(statearr_23600_23623[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23597 === (6))){
var inst_23577 = fluree.db.permissions_validate.allow_flakes_QMARK_.call(null,db,flakes);
var state_23596__$1 = state_23596;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23596__$1,(9),inst_23577);
} else {
if((state_val_23597 === (3))){
var inst_23594 = (state_23596[(2)]);
var state_23596__$1 = state_23596;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23596__$1,inst_23594);
} else {
if((state_val_23597 === (12))){
var state_23596__$1 = state_23596;
var statearr_23601_23624 = state_23596__$1;
(statearr_23601_23624[(2)] = null);

(statearr_23601_23624[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23597 === (2))){
var inst_23572 = (state_23596[(7)]);
var _ = (function (){var statearr_23602 = state_23596;
(statearr_23602[(4)] = cljs.core.cons.call(null,(5),(state_23596[(4)])));

return statearr_23602;
})();
var inst_23572__$1 = cljs.core.first.call(null,flakes);
var inst_23573 = fluree.db.flake.s.call(null,inst_23572__$1);
var inst_23574 = fluree.db.flake.sid__GT_cid.call(null,inst_23573);
var inst_23575 = filter_predicates_QMARK_.call(null,inst_23574);
var state_23596__$1 = (function (){var statearr_23603 = state_23596;
(statearr_23603[(7)] = inst_23572__$1);

return statearr_23603;
})();
if(cljs.core.truth_(inst_23575)){
var statearr_23604_23625 = state_23596__$1;
(statearr_23604_23625[(1)] = (6));

} else {
var statearr_23605_23626 = state_23596__$1;
(statearr_23605_23626[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23597 === (11))){
var state_23596__$1 = state_23596;
var statearr_23607_23627 = state_23596__$1;
(statearr_23607_23627[(2)] = flakes);

(statearr_23607_23627[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23597 === (9))){
var inst_23579 = (state_23596[(2)]);
var inst_23580 = fluree.db.util.async.throw_err.call(null,inst_23579);
var state_23596__$1 = state_23596;
var statearr_23608_23628 = state_23596__$1;
(statearr_23608_23628[(2)] = inst_23580);

(statearr_23608_23628[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23597 === (5))){
var _ = (function (){var statearr_23609 = state_23596;
(statearr_23609[(4)] = cljs.core.rest.call(null,(state_23596[(4)])));

return statearr_23609;
})();
var state_23596__$1 = state_23596;
var ex23606 = (state_23596__$1[(2)]);
var statearr_23610_23629 = state_23596__$1;
(statearr_23610_23629[(5)] = ex23606);


if((ex23606 instanceof Error)){
var statearr_23611_23630 = state_23596__$1;
(statearr_23611_23630[(1)] = (4));

(statearr_23611_23630[(5)] = null);

} else {
throw ex23606;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23597 === (10))){
var inst_23584 = (state_23596[(2)]);
var inst_23585 = fluree.db.util.async.throw_err.call(null,inst_23584);
var state_23596__$1 = state_23596;
if(cljs.core.truth_(inst_23585)){
var statearr_23612_23631 = state_23596__$1;
(statearr_23612_23631[(1)] = (11));

} else {
var statearr_23613_23632 = state_23596__$1;
(statearr_23613_23632[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23597 === (8))){
var inst_23591 = (state_23596[(2)]);
var _ = (function (){var statearr_23614 = state_23596;
(statearr_23614[(4)] = cljs.core.rest.call(null,(state_23596[(4)])));

return statearr_23614;
})();
var state_23596__$1 = state_23596;
var statearr_23615_23633 = state_23596__$1;
(statearr_23615_23633[(2)] = inst_23591);

(statearr_23615_23633[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto____0 = (function (){
var statearr_23616 = [null,null,null,null,null,null,null,null];
(statearr_23616[(0)] = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto__);

(statearr_23616[(1)] = (1));

return statearr_23616;
});
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto____1 = (function (state_23596){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23596);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23617){var ex__2749__auto__ = e23617;
var statearr_23618_23634 = state_23596;
(statearr_23618_23634[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23596[(4)]))){
var statearr_23619_23635 = state_23596;
(statearr_23619_23635[(1)] = cljs.core.first.call(null,(state_23596[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23636 = state_23596;
state_23596 = G__23636;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto__ = function(state_23596){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto____1.call(this,state_23596);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23620 = f__2769__auto__.call(null);
(statearr_23620[(6)] = c__2768__auto__);

return statearr_23620;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
});
fluree.db.query.subject_crawl.common.passes_filter_QMARK_ = (function fluree$db$query$subject_crawl$common$passes_filter_QMARK_(filter_fn,vars,pred_flakes){
return cljs.core.some.call(null,(function (p1__23637_SHARP_){
return filter_fn.call(null,p1__23637_SHARP_,vars);
}),pred_flakes);
});
/**
 * For a group of predicate flakes (all same .-p value)
 *   and a list of filter-functions, returns true if at least
 *   one of the predicates passes every function, else returns false.
 */
fluree.db.query.subject_crawl.common.pass_all_filters_QMARK_ = (function fluree$db$query$subject_crawl$common$pass_all_filters_QMARK_(filter_fns,vars,pred_flakes){
var G__23641 = filter_fns;
var vec__23642 = G__23641;
var seq__23643 = cljs.core.seq.call(null,vec__23642);
var first__23644 = cljs.core.first.call(null,seq__23643);
var seq__23643__$1 = cljs.core.next.call(null,seq__23643);
var filter_fn = first__23644;
var r_fns = seq__23643__$1;
var G__23641__$1 = G__23641;
while(true){
var vec__23645 = G__23641__$1;
var seq__23646 = cljs.core.seq.call(null,vec__23645);
var first__23647 = cljs.core.first.call(null,seq__23646);
var seq__23646__$1 = cljs.core.next.call(null,seq__23646);
var filter_fn__$1 = first__23647;
var r_fns__$1 = seq__23646__$1;
if(cljs.core.truth_(filter_fn__$1)){
if(cljs.core.truth_(fluree.db.query.subject_crawl.common.passes_filter_QMARK_.call(null,filter_fn__$1,vars,pred_flakes))){
var G__23648 = r_fns__$1;
G__23641__$1 = G__23648;
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
});
/**
 * Filters a set of flakes for a single subject and returns true if
 *   the subject meets the filter map.
 * 
 *   filter-map is a map where pred-ids are keys and values are a list of filtering functions
 *   where each flake of pred-id must return a truthy value if the subject is allowed.
 */
fluree.db.query.subject_crawl.common.filter_subject = (function fluree$db$query$subject_crawl$common$filter_subject(vars,filter_map,flakes){
var G__23652 = cljs.core.partition_by.call(null,fluree.db.flake.p,flakes);
var vec__23653 = G__23652;
var seq__23654 = cljs.core.seq.call(null,vec__23653);
var first__23655 = cljs.core.first.call(null,seq__23654);
var seq__23654__$1 = cljs.core.next.call(null,seq__23654);
var p_flakes = first__23655;
var r = seq__23654__$1;
var required_p = new cljs.core.Keyword(null,"required-p","required-p",-2091946078).cljs$core$IFn$_invoke$arity$1(filter_map);
var G__23652__$1 = G__23652;
var required_p__$1 = required_p;
while(true){
var vec__23659 = G__23652__$1;
var seq__23660 = cljs.core.seq.call(null,vec__23659);
var first__23661 = cljs.core.first.call(null,seq__23660);
var seq__23660__$1 = cljs.core.next.call(null,seq__23660);
var p_flakes__$1 = first__23661;
var r__$1 = seq__23660__$1;
var required_p__$2 = required_p__$1;
if(cljs.core.truth_(p_flakes__$1)){
var p = fluree.db.flake.p.call(null,cljs.core.first.call(null,p_flakes__$1));
var temp__5802__auto__ = cljs.core.get.call(null,filter_map,p);
if(cljs.core.truth_(temp__5802__auto__)){
var filter_fns = temp__5802__auto__;
if(fluree.db.query.subject_crawl.common.pass_all_filters_QMARK_.call(null,filter_fns,vars,p_flakes__$1)){
var G__23662 = r__$1;
var G__23663 = cljs.core.disj.call(null,required_p__$2,p);
G__23652__$1 = G__23662;
required_p__$1 = G__23663;
continue;
} else {
return null;
}
} else {
var G__23664 = r__$1;
var G__23665 = cljs.core.disj.call(null,required_p__$2,p);
G__23652__$1 = G__23664;
required_p__$1 = G__23665;
continue;
}
} else {
if(cljs.core.empty_QMARK_.call(null,required_p__$2)){
return flakes;
} else {
return null;
}
}
break;
}
});
/**
 * If order-by exists in query, orders final results.
 *   order-by is defined by a map with keys (see analytical-parse for code):
 *   - :type - :variable or :predicate
 *   - :order - :asc or :desc
 *   - :predicate - if type = :predicate, contains predicate pid or name
 *   - :variable - if type = :variable, contains variable name (not supported for simple subject crawl)
 */
fluree.db.query.subject_crawl.common.order_results = (function fluree$db$query$subject_crawl$common$order_results(results,p__23666,limit){
var map__23667 = p__23666;
var map__23667__$1 = cljs.core.__destructure_map.call(null,map__23667);
var type = cljs.core.get.call(null,map__23667__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var order = cljs.core.get.call(null,map__23667__$1,new cljs.core.Keyword(null,"order","order",-1254677256));
var predicate = cljs.core.get.call(null,map__23667__$1,new cljs.core.Keyword(null,"predicate","predicate",-1742501860));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"variable","variable",-281346492),type)){
throw cljs.core.ex_info.call(null,"Ordering by a variable not supported in this type of query.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
var sorted = (function (){var G__23668 = cljs.core.sort_by.call(null,(function (result){
return cljs.core.get.call(null,result,predicate);
}),results);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"desc","desc",2093485764),order)){
return cljs.core.reverse.call(null,G__23668);
} else {
return G__23668;
}
})();
return cljs.core.vec.call(null,cljs.core.take.call(null,limit,sorted));
}
});
