// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');

/**
 * @interface
 */
fluree.db.storage.core.Store = function(){};

var fluree$db$storage$core$Store$exists_QMARK_$dyn_17184 = (function (s,k){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.exists_QMARK_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,s,k);
} else {
var m__5392__auto__ = (fluree.db.storage.core.exists_QMARK_["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,s,k);
} else {
throw cljs.core.missing_protocol.call(null,"Store.exists?",s);
}
}
});
/**
 * Returns true when `k` exists in `s`
 */
fluree.db.storage.core.exists_QMARK_ = (function fluree$db$storage$core$exists_QMARK_(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$exists_QMARK_$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$exists_QMARK_$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$exists_QMARK_$dyn_17184.call(null,s,k);
}
});

var fluree$db$storage$core$Store$list$dyn_17185 = (function (s,d){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.list[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,s,d);
} else {
var m__5392__auto__ = (fluree.db.storage.core.list["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,s,d);
} else {
throw cljs.core.missing_protocol.call(null,"Store.list",s);
}
}
});
/**
 * Returns a collection containing the keys stored under the subdirectory/prefix `d` of `s`
 */
fluree.db.storage.core.list = (function fluree$db$storage$core$list(s,d){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$list$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$list$arity$2(s,d);
} else {
return fluree$db$storage$core$Store$list$dyn_17185.call(null,s,d);
}
});

var fluree$db$storage$core$Store$read$dyn_17186 = (function (s,k){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.read[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,s,k);
} else {
var m__5392__auto__ = (fluree.db.storage.core.read["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,s,k);
} else {
throw cljs.core.missing_protocol.call(null,"Store.read",s);
}
}
});
/**
 * Reads raw bytes from `s` associated with `k`
 */
fluree.db.storage.core.read = (function fluree$db$storage$core$read(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$read$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$read$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$read$dyn_17186.call(null,s,k);
}
});

var fluree$db$storage$core$Store$write$dyn_17187 = (function (s,k,data){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.write[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,s,k,data);
} else {
var m__5392__auto__ = (fluree.db.storage.core.write["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,s,k,data);
} else {
throw cljs.core.missing_protocol.call(null,"Store.write",s);
}
}
});
/**
 * Writes `data` as raw bytes to `s` and associates it with `k`
 */
fluree.db.storage.core.write = (function fluree$db$storage$core$write(s,k,data){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$write$arity$3 == null)))))){
return s.fluree$db$storage$core$Store$write$arity$3(s,k,data);
} else {
return fluree$db$storage$core$Store$write$dyn_17187.call(null,s,k,data);
}
});

var fluree$db$storage$core$Store$rename$dyn_17188 = (function (s,old_key,new_key){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.rename[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,s,old_key,new_key);
} else {
var m__5392__auto__ = (fluree.db.storage.core.rename["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,s,old_key,new_key);
} else {
throw cljs.core.missing_protocol.call(null,"Store.rename",s);
}
}
});
/**
 * Remove `old-key` and associate its data to `new-key`
 */
fluree.db.storage.core.rename = (function fluree$db$storage$core$rename(s,old_key,new_key){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$rename$arity$3 == null)))))){
return s.fluree$db$storage$core$Store$rename$arity$3(s,old_key,new_key);
} else {
return fluree$db$storage$core$Store$rename$dyn_17188.call(null,s,old_key,new_key);
}
});

var fluree$db$storage$core$Store$delete$dyn_17189 = (function (s,k){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.delete$[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,s,k);
} else {
var m__5392__auto__ = (fluree.db.storage.core.delete$["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,s,k);
} else {
throw cljs.core.missing_protocol.call(null,"Store.delete",s);
}
}
});
/**
 * Delete data associated with key `k`
 */
fluree.db.storage.core.delete$ = (function fluree$db$storage$core$delete(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$delete$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$delete$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$delete$dyn_17189.call(null,s,k);
}
});

/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_prefix = (function fluree$db$storage$core$ledger_garbage_prefix(network,ldgr_id){
return clojure.string.join.call(null,"_",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ldgr_id,"garbage"], null));
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ldgr_id,block){
var pre = fluree.db.storage.core.ledger_garbage_prefix.call(null,network,ldgr_id);
return clojure.string.join.call(null,"_",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pre,block], null));
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name.call(null,idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17211){
var state_val_17212 = (state_17211[(1)]);
if((state_val_17212 === (7))){
var inst_17200 = (state_17211[(7)]);
var inst_17202 = fluree.db.storage.core.serde.call(null,conn);
var inst_17203 = fluree.db.serde.protocol._deserialize_block.call(null,inst_17202,inst_17200);
var state_17211__$1 = state_17211;
var statearr_17213_17232 = state_17211__$1;
(statearr_17213_17232[(2)] = inst_17203);

(statearr_17213_17232[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17212 === (1))){
var state_17211__$1 = state_17211;
var statearr_17214_17233 = state_17211__$1;
(statearr_17214_17233[(2)] = null);

(statearr_17214_17233[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17212 === (4))){
var inst_17190 = (state_17211[(2)]);
var state_17211__$1 = state_17211;
var statearr_17215_17234 = state_17211__$1;
(statearr_17215_17234[(2)] = inst_17190);

(statearr_17215_17234[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17212 === (6))){
var inst_17200 = (state_17211[(7)]);
var inst_17199 = (state_17211[(2)]);
var inst_17200__$1 = fluree.db.util.async.throw_err.call(null,inst_17199);
var state_17211__$1 = (function (){var statearr_17216 = state_17211;
(statearr_17216[(7)] = inst_17200__$1);

return statearr_17216;
})();
if(cljs.core.truth_(inst_17200__$1)){
var statearr_17217_17235 = state_17211__$1;
(statearr_17217_17235[(1)] = (7));

} else {
var statearr_17218_17236 = state_17211__$1;
(statearr_17218_17236[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17212 === (3))){
var inst_17209 = (state_17211[(2)]);
var state_17211__$1 = state_17211;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17211__$1,inst_17209);
} else {
if((state_val_17212 === (2))){
var _ = (function (){var statearr_17220 = state_17211;
(statearr_17220[(4)] = cljs.core.cons.call(null,(5),(state_17211[(4)])));

return statearr_17220;
})();
var inst_17196 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_17197 = fluree.db.storage.core.read.call(null,conn,inst_17196);
var state_17211__$1 = state_17211;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17211__$1,(6),inst_17197);
} else {
if((state_val_17212 === (9))){
var inst_17206 = (state_17211[(2)]);
var _ = (function (){var statearr_17221 = state_17211;
(statearr_17221[(4)] = cljs.core.rest.call(null,(state_17211[(4)])));

return statearr_17221;
})();
var state_17211__$1 = state_17211;
var statearr_17222_17237 = state_17211__$1;
(statearr_17222_17237[(2)] = inst_17206);

(statearr_17222_17237[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17212 === (5))){
var _ = (function (){var statearr_17223 = state_17211;
(statearr_17223[(4)] = cljs.core.rest.call(null,(state_17211[(4)])));

return statearr_17223;
})();
var state_17211__$1 = state_17211;
var ex17219 = (state_17211__$1[(2)]);
var statearr_17224_17238 = state_17211__$1;
(statearr_17224_17238[(5)] = ex17219);


if((ex17219 instanceof Error)){
var statearr_17225_17239 = state_17211__$1;
(statearr_17225_17239[(1)] = (4));

(statearr_17225_17239[(5)] = null);

} else {
throw ex17219;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17212 === (8))){
var state_17211__$1 = state_17211;
var statearr_17226_17240 = state_17211__$1;
(statearr_17226_17240[(2)] = null);

(statearr_17226_17240[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__2746__auto____0 = (function (){
var statearr_17227 = [null,null,null,null,null,null,null,null];
(statearr_17227[(0)] = fluree$db$storage$core$read_block_$_state_machine__2746__auto__);

(statearr_17227[(1)] = (1));

return statearr_17227;
});
var fluree$db$storage$core$read_block_$_state_machine__2746__auto____1 = (function (state_17211){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17211);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17228){var ex__2749__auto__ = e17228;
var statearr_17229_17241 = state_17211;
(statearr_17229_17241[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17211[(4)]))){
var statearr_17230_17242 = state_17211;
(statearr_17230_17242[(1)] = cljs.core.first.call(null,(state_17211[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17243 = state_17211;
state_17211 = G__17243;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__2746__auto__ = function(state_17211){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__2746__auto____1.call(this,state_17211);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__2746__auto____0;
fluree$db$storage$core$read_block_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__2746__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17231 = f__2769__auto__.call(null);
(statearr_17231[(6)] = c__2768__auto__);

return statearr_17231;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17266){
var state_val_17267 = (state_17266[(1)]);
if((state_val_17267 === (7))){
var inst_17255 = (state_17266[(7)]);
var inst_17257 = fluree.db.storage.core.serde.call(null,conn);
var inst_17258 = fluree.db.serde.protocol._deserialize_block.call(null,inst_17257,inst_17255);
var state_17266__$1 = state_17266;
var statearr_17268_17287 = state_17266__$1;
(statearr_17268_17287[(2)] = inst_17258);

(statearr_17268_17287[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17267 === (1))){
var state_17266__$1 = state_17266;
var statearr_17269_17288 = state_17266__$1;
(statearr_17269_17288[(2)] = null);

(statearr_17269_17288[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17267 === (4))){
var inst_17244 = (state_17266[(2)]);
var state_17266__$1 = state_17266;
var statearr_17270_17289 = state_17266__$1;
(statearr_17270_17289[(2)] = inst_17244);

(statearr_17270_17289[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17267 === (6))){
var inst_17255 = (state_17266[(7)]);
var inst_17254 = (state_17266[(2)]);
var inst_17255__$1 = fluree.db.util.async.throw_err.call(null,inst_17254);
var state_17266__$1 = (function (){var statearr_17271 = state_17266;
(statearr_17271[(7)] = inst_17255__$1);

return statearr_17271;
})();
if(cljs.core.truth_(inst_17255__$1)){
var statearr_17272_17290 = state_17266__$1;
(statearr_17272_17290[(1)] = (7));

} else {
var statearr_17273_17291 = state_17266__$1;
(statearr_17273_17291[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17267 === (3))){
var inst_17264 = (state_17266[(2)]);
var state_17266__$1 = state_17266;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17266__$1,inst_17264);
} else {
if((state_val_17267 === (2))){
var _ = (function (){var statearr_17275 = state_17266;
(statearr_17275[(4)] = cljs.core.cons.call(null,(5),(state_17266[(4)])));

return statearr_17275;
})();
var inst_17250 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_17251 = [inst_17250,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_17252 = fluree.db.storage.core.read.call(null,conn,inst_17251);
var state_17266__$1 = state_17266;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17266__$1,(6),inst_17252);
} else {
if((state_val_17267 === (9))){
var inst_17261 = (state_17266[(2)]);
var _ = (function (){var statearr_17276 = state_17266;
(statearr_17276[(4)] = cljs.core.rest.call(null,(state_17266[(4)])));

return statearr_17276;
})();
var state_17266__$1 = state_17266;
var statearr_17277_17292 = state_17266__$1;
(statearr_17277_17292[(2)] = inst_17261);

(statearr_17277_17292[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17267 === (5))){
var _ = (function (){var statearr_17278 = state_17266;
(statearr_17278[(4)] = cljs.core.rest.call(null,(state_17266[(4)])));

return statearr_17278;
})();
var state_17266__$1 = state_17266;
var ex17274 = (state_17266__$1[(2)]);
var statearr_17279_17293 = state_17266__$1;
(statearr_17279_17293[(5)] = ex17274);


if((ex17274 instanceof Error)){
var statearr_17280_17294 = state_17266__$1;
(statearr_17280_17294[(1)] = (4));

(statearr_17280_17294[(5)] = null);

} else {
throw ex17274;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17267 === (8))){
var state_17266__$1 = state_17266;
var statearr_17281_17295 = state_17266__$1;
(statearr_17281_17295[(2)] = null);

(statearr_17281_17295[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__2746__auto____0 = (function (){
var statearr_17282 = [null,null,null,null,null,null,null,null];
(statearr_17282[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__2746__auto__);

(statearr_17282[(1)] = (1));

return statearr_17282;
});
var fluree$db$storage$core$read_block_version_$_state_machine__2746__auto____1 = (function (state_17266){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17266);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17283){var ex__2749__auto__ = e17283;
var statearr_17284_17296 = state_17266;
(statearr_17284_17296[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17266[(4)]))){
var statearr_17285_17297 = state_17266;
(statearr_17285_17297[(1)] = cljs.core.first.call(null,(state_17266[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17298 = state_17266;
state_17266 = G__17298;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__2746__auto__ = function(state_17266){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__2746__auto____1.call(this,state_17266);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__2746__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__2746__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17286 = f__2769__auto__.call(null);
(statearr_17286[(6)] = c__2768__auto__);

return statearr_17286;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash   hash
 * :sigs   sigs
 * :txns   {tid (tx-id, string) {:cmd command (JSON string)
 *                               :sig signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,ledger_id,block_data,version){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17322){
var state_val_17323 = (state_17322[(1)]);
if((state_val_17323 === (1))){
var state_17322__$1 = state_17322;
var statearr_17324_17338 = state_17322__$1;
(statearr_17324_17338[(2)] = null);

(statearr_17324_17338[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17323 === (2))){
var _ = (function (){var statearr_17325 = state_17322;
(statearr_17325[(4)] = cljs.core.cons.call(null,(5),(state_17322[(4)])));

return statearr_17325;
})();
var inst_17305 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17306 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17307 = (new cljs.core.PersistentVector(null,3,(5),inst_17305,inst_17306,null));
var inst_17308 = cljs.core.select_keys.call(null,block_data,inst_17307);
var inst_17309 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_17308);
var inst_17310 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,inst_17309);
var inst_17311 = [inst_17310,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_17312 = fluree.db.storage.core.serde.call(null,conn);
var inst_17313 = fluree.db.serde.protocol._serialize_block.call(null,inst_17312,inst_17308);
var inst_17314 = fluree.db.storage.core.write.call(null,conn,inst_17311,inst_17313);
var state_17322__$1 = state_17322;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17322__$1,(6),inst_17314);
} else {
if((state_val_17323 === (3))){
var inst_17320 = (state_17322[(2)]);
var state_17322__$1 = state_17322;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17322__$1,inst_17320);
} else {
if((state_val_17323 === (4))){
var inst_17299 = (state_17322[(2)]);
var state_17322__$1 = state_17322;
var statearr_17327_17339 = state_17322__$1;
(statearr_17327_17339[(2)] = inst_17299);

(statearr_17327_17339[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17323 === (5))){
var _ = (function (){var statearr_17328 = state_17322;
(statearr_17328[(4)] = cljs.core.rest.call(null,(state_17322[(4)])));

return statearr_17328;
})();
var state_17322__$1 = state_17322;
var ex17326 = (state_17322__$1[(2)]);
var statearr_17329_17340 = state_17322__$1;
(statearr_17329_17340[(5)] = ex17326);


if((ex17326 instanceof Error)){
var statearr_17330_17341 = state_17322__$1;
(statearr_17330_17341[(1)] = (4));

(statearr_17330_17341[(5)] = null);

} else {
throw ex17326;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17323 === (6))){
var inst_17316 = (state_17322[(2)]);
var inst_17317 = fluree.db.util.async.throw_err.call(null,inst_17316);
var _ = (function (){var statearr_17331 = state_17322;
(statearr_17331[(4)] = cljs.core.rest.call(null,(state_17322[(4)])));

return statearr_17331;
})();
var state_17322__$1 = state_17322;
var statearr_17332_17342 = state_17322__$1;
(statearr_17332_17342[(2)] = inst_17317);

(statearr_17332_17342[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__2746__auto____0 = (function (){
var statearr_17333 = [null,null,null,null,null,null,null];
(statearr_17333[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__2746__auto__);

(statearr_17333[(1)] = (1));

return statearr_17333;
});
var fluree$db$storage$core$write_block_version_$_state_machine__2746__auto____1 = (function (state_17322){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17322);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17334){var ex__2749__auto__ = e17334;
var statearr_17335_17343 = state_17322;
(statearr_17335_17343[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17322[(4)]))){
var statearr_17336_17344 = state_17322;
(statearr_17336_17344[(1)] = cljs.core.first.call(null,(state_17322[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17345 = state_17322;
state_17322 = G__17345;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__2746__auto__ = function(state_17322){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__2746__auto____1.call(this,state_17322);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__2746__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__2746__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17337 = f__2769__auto__.call(null);
(statearr_17337[(6)] = c__2768__auto__);

return statearr_17337;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash   hash
 * :sigs   sigs
 * :txns   {tid (tx-id, string) {:cmd command (JSON string)
 *                               :sig signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,ledger_id,block_data){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17368){
var state_val_17369 = (state_17368[(1)]);
if((state_val_17369 === (1))){
var state_17368__$1 = state_17368;
var statearr_17370_17384 = state_17368__$1;
(statearr_17370_17384[(2)] = null);

(statearr_17370_17384[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17369 === (2))){
var _ = (function (){var statearr_17371 = state_17368;
(statearr_17371[(4)] = cljs.core.cons.call(null,(5),(state_17368[(4)])));

return statearr_17371;
})();
var inst_17352 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17353 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17354 = (new cljs.core.PersistentVector(null,3,(5),inst_17352,inst_17353,null));
var inst_17355 = cljs.core.select_keys.call(null,block_data,inst_17354);
var inst_17356 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_17355);
var inst_17357 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,inst_17356);
var inst_17358 = fluree.db.storage.core.serde.call(null,conn);
var inst_17359 = fluree.db.serde.protocol._serialize_block.call(null,inst_17358,inst_17355);
var inst_17360 = fluree.db.storage.core.write.call(null,conn,inst_17357,inst_17359);
var state_17368__$1 = state_17368;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17368__$1,(6),inst_17360);
} else {
if((state_val_17369 === (3))){
var inst_17366 = (state_17368[(2)]);
var state_17368__$1 = state_17368;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17368__$1,inst_17366);
} else {
if((state_val_17369 === (4))){
var inst_17346 = (state_17368[(2)]);
var state_17368__$1 = state_17368;
var statearr_17373_17385 = state_17368__$1;
(statearr_17373_17385[(2)] = inst_17346);

(statearr_17373_17385[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17369 === (5))){
var _ = (function (){var statearr_17374 = state_17368;
(statearr_17374[(4)] = cljs.core.rest.call(null,(state_17368[(4)])));

return statearr_17374;
})();
var state_17368__$1 = state_17368;
var ex17372 = (state_17368__$1[(2)]);
var statearr_17375_17386 = state_17368__$1;
(statearr_17375_17386[(5)] = ex17372);


if((ex17372 instanceof Error)){
var statearr_17376_17387 = state_17368__$1;
(statearr_17376_17387[(1)] = (4));

(statearr_17376_17387[(5)] = null);

} else {
throw ex17372;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17369 === (6))){
var inst_17362 = (state_17368[(2)]);
var inst_17363 = fluree.db.util.async.throw_err.call(null,inst_17362);
var _ = (function (){var statearr_17377 = state_17368;
(statearr_17377[(4)] = cljs.core.rest.call(null,(state_17368[(4)])));

return statearr_17377;
})();
var state_17368__$1 = state_17368;
var statearr_17378_17388 = state_17368__$1;
(statearr_17378_17388[(2)] = inst_17363);

(statearr_17378_17388[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__2746__auto____0 = (function (){
var statearr_17379 = [null,null,null,null,null,null,null];
(statearr_17379[(0)] = fluree$db$storage$core$write_block_$_state_machine__2746__auto__);

(statearr_17379[(1)] = (1));

return statearr_17379;
});
var fluree$db$storage$core$write_block_$_state_machine__2746__auto____1 = (function (state_17368){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17368);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17380){var ex__2749__auto__ = e17380;
var statearr_17381_17389 = state_17368;
(statearr_17381_17389[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17368[(4)]))){
var statearr_17382_17390 = state_17368;
(statearr_17382_17390[(1)] = cljs.core.first.call(null,(state_17368[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17391 = state_17368;
state_17368 = G__17391;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__2746__auto__ = function(state_17368){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__2746__auto____1.call(this,state_17368);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__2746__auto____0;
fluree$db$storage$core$write_block_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__2746__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17383 = f__2769__auto__.call(null);
(statearr_17383[(6)] = c__2768__auto__);

return statearr_17383;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into
 *   storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys.call(null,child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.random_leaf_id = (function fluree$db$storage$core$random_leaf_id(network,ledger_id,idx){
return fluree.db.storage.core.ledger_node_key.call(null,network,ledger_id,idx,cljs.core.random_uuid.call(null),"l");
});
/**
 * Writes `leaf` to storage under the provided `leaf-id`, computing a new id if
 *   one isn't provided. Returns the leaf map with the id used attached uner the
 *   `:id` key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(var_args){
var G__17393 = arguments.length;
switch (G__17393) {
case 5:
return fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,ledger_id,idx_type,leaf){
var leaf_id = fluree.db.storage.core.random_leaf_id.call(null,network,ledger_id,idx_type);
return fluree.db.storage.core.write_leaf.call(null,conn,network,ledger_id,idx_type,leaf_id,leaf);
}));

(fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$6 = (function (conn,network,ledger_id,idx_type,leaf_id,p__17394){
var map__17395 = p__17394;
var map__17395__$1 = cljs.core.__destructure_map.call(null,map__17395);
var leaf = map__17395__$1;
var flakes = cljs.core.get.call(null,map__17395__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17416){
var state_val_17417 = (state_17416[(1)]);
if((state_val_17417 === (1))){
var state_17416__$1 = state_17416;
var statearr_17418_17434 = state_17416__$1;
(statearr_17418_17434[(2)] = null);

(statearr_17418_17434[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17417 === (2))){
var _ = (function (){var statearr_17419 = state_17416;
(statearr_17419[(4)] = cljs.core.cons.call(null,(5),(state_17416[(4)])));

return statearr_17419;
})();
var inst_17402 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17403 = [flakes];
var inst_17404 = cljs.core.PersistentHashMap.fromArrays(inst_17402,inst_17403);
var inst_17405 = fluree.db.storage.core.serde.call(null,conn);
var inst_17406 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_17405,inst_17404);
var inst_17407 = fluree.db.storage.core.write.call(null,conn,leaf_id,inst_17406);
var state_17416__$1 = state_17416;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17416__$1,(6),inst_17407);
} else {
if((state_val_17417 === (3))){
var inst_17414 = (state_17416[(2)]);
var state_17416__$1 = state_17416;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17416__$1,inst_17414);
} else {
if((state_val_17417 === (4))){
var inst_17396 = (state_17416[(2)]);
var state_17416__$1 = state_17416;
var statearr_17421_17435 = state_17416__$1;
(statearr_17421_17435[(2)] = inst_17396);

(statearr_17421_17435[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17417 === (5))){
var _ = (function (){var statearr_17422 = state_17416;
(statearr_17422[(4)] = cljs.core.rest.call(null,(state_17416[(4)])));

return statearr_17422;
})();
var state_17416__$1 = state_17416;
var ex17420 = (state_17416__$1[(2)]);
var statearr_17423_17436 = state_17416__$1;
(statearr_17423_17436[(5)] = ex17420);


if((ex17420 instanceof Error)){
var statearr_17424_17437 = state_17416__$1;
(statearr_17424_17437[(1)] = (4));

(statearr_17424_17437[(5)] = null);

} else {
throw ex17420;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17417 === (6))){
var inst_17409 = (state_17416[(2)]);
var inst_17410 = fluree.db.util.async.throw_err.call(null,inst_17409);
var inst_17411 = cljs.core.assoc.call(null,leaf,new cljs.core.Keyword(null,"id","id",-1388402092),leaf_id);
var _ = (function (){var statearr_17425 = state_17416;
(statearr_17425[(4)] = cljs.core.rest.call(null,(state_17416[(4)])));

return statearr_17425;
})();
var state_17416__$1 = (function (){var statearr_17426 = state_17416;
(statearr_17426[(7)] = inst_17410);

return statearr_17426;
})();
var statearr_17427_17438 = state_17416__$1;
(statearr_17427_17438[(2)] = inst_17411);

(statearr_17427_17438[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2746__auto__ = null;
var fluree$db$storage$core$state_machine__2746__auto____0 = (function (){
var statearr_17428 = [null,null,null,null,null,null,null,null];
(statearr_17428[(0)] = fluree$db$storage$core$state_machine__2746__auto__);

(statearr_17428[(1)] = (1));

return statearr_17428;
});
var fluree$db$storage$core$state_machine__2746__auto____1 = (function (state_17416){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17416);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17429){var ex__2749__auto__ = e17429;
var statearr_17430_17439 = state_17416;
(statearr_17430_17439[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17416[(4)]))){
var statearr_17431_17440 = state_17416;
(statearr_17431_17440[(1)] = cljs.core.first.call(null,(state_17416[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17441 = state_17416;
state_17416 = G__17441;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2746__auto__ = function(state_17416){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2746__auto____1.call(this,state_17416);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2746__auto____0;
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2746__auto____1;
return fluree$db$storage$core$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17432 = f__2769__auto__.call(null);
(statearr_17432[(6)] = c__2768__auto__);

return statearr_17432;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.storage.core.write_leaf.cljs$lang$maxFixedArity = 6);

/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17458){
var state_val_17459 = (state_17458[(1)]);
if((state_val_17459 === (1))){
var state_17458__$1 = state_17458;
var statearr_17460_17475 = state_17458__$1;
(statearr_17460_17475[(2)] = null);

(statearr_17460_17475[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17459 === (2))){
var _ = (function (){var statearr_17461 = state_17458;
(statearr_17461[(4)] = cljs.core.cons.call(null,(5),(state_17458[(4)])));

return statearr_17461;
})();
var inst_17448 = fluree.db.storage.core.serde.call(null,conn);
var inst_17449 = fluree.db.serde.protocol._serialize_branch.call(null,inst_17448,data);
var inst_17450 = fluree.db.storage.core.write.call(null,conn,key,inst_17449);
var state_17458__$1 = state_17458;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17458__$1,(6),inst_17450);
} else {
if((state_val_17459 === (3))){
var inst_17456 = (state_17458[(2)]);
var state_17458__$1 = state_17458;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17458__$1,inst_17456);
} else {
if((state_val_17459 === (4))){
var inst_17442 = (state_17458[(2)]);
var state_17458__$1 = state_17458;
var statearr_17463_17476 = state_17458__$1;
(statearr_17463_17476[(2)] = inst_17442);

(statearr_17463_17476[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17459 === (5))){
var _ = (function (){var statearr_17464 = state_17458;
(statearr_17464[(4)] = cljs.core.rest.call(null,(state_17458[(4)])));

return statearr_17464;
})();
var state_17458__$1 = state_17458;
var ex17462 = (state_17458__$1[(2)]);
var statearr_17465_17477 = state_17458__$1;
(statearr_17465_17477[(5)] = ex17462);


if((ex17462 instanceof Error)){
var statearr_17466_17478 = state_17458__$1;
(statearr_17466_17478[(1)] = (4));

(statearr_17466_17478[(5)] = null);

} else {
throw ex17462;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17459 === (6))){
var inst_17452 = (state_17458[(2)]);
var inst_17453 = fluree.db.util.async.throw_err.call(null,inst_17452);
var _ = (function (){var statearr_17467 = state_17458;
(statearr_17467[(4)] = cljs.core.rest.call(null,(state_17458[(4)])));

return statearr_17467;
})();
var state_17458__$1 = (function (){var statearr_17468 = state_17458;
(statearr_17468[(7)] = inst_17453);

return statearr_17468;
})();
var statearr_17469_17479 = state_17458__$1;
(statearr_17469_17479[(2)] = key);

(statearr_17469_17479[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto____0 = (function (){
var statearr_17470 = [null,null,null,null,null,null,null,null];
(statearr_17470[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto__);

(statearr_17470[(1)] = (1));

return statearr_17470;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto____1 = (function (state_17458){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17458);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17471){var ex__2749__auto__ = e17471;
var statearr_17472_17480 = state_17458;
(statearr_17472_17480[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17458[(4)]))){
var statearr_17473_17481 = state_17458;
(statearr_17473_17481[(1)] = cljs.core.first.call(null,(state_17458[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17482 = state_17458;
state_17458 = G__17482;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto__ = function(state_17458){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto____1.call(this,state_17458);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17474 = f__2769__auto__.call(null);
(statearr_17474[(6)] = c__2768__auto__);

return statearr_17474;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.storage.core.random_branch_id = (function fluree$db$storage$core$random_branch_id(network,ledger_id,idx){
return fluree.db.storage.core.ledger_node_key.call(null,network,ledger_id,idx,cljs.core.random_uuid.call(null),"b");
});
/**
 * Writes `branch` to storage under the provided `branch-id`, computing a new id
 *   if one isn't provided. Returns the branch map with the id used attached uner
 *   the `:id` key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(var_args){
var G__17484 = arguments.length;
switch (G__17484) {
case 5:
return fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,ledger_id,idx_type,branch){
var branch_id = fluree.db.storage.core.random_branch_id.call(null,network,ledger_id,idx_type);
return fluree.db.storage.core.write_branch.call(null,conn,network,ledger_id,idx_type,branch_id,branch);
}));

(fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$6 = (function (conn,network,ledger_id,idx_type,branch_id,p__17485){
var map__17486 = p__17485;
var map__17486__$1 = cljs.core.__destructure_map.call(null,map__17486);
var branch = map__17486__$1;
var children = cljs.core.get.call(null,map__17486__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17512){
var state_val_17513 = (state_17512[(1)]);
if((state_val_17513 === (1))){
var state_17512__$1 = state_17512;
var statearr_17514_17531 = state_17512__$1;
(statearr_17514_17531[(2)] = null);

(statearr_17514_17531[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17513 === (2))){
var _ = (function (){var statearr_17515 = state_17512;
(statearr_17515[(4)] = cljs.core.cons.call(null,(5),(state_17512[(4)])));

return statearr_17515;
})();
var inst_17493 = cljs.core.map.call(null,cljs.core.val,children);
var inst_17494 = cljs.core.mapv.call(null,fluree.db.storage.core.child_data,inst_17493);
var inst_17495 = cljs.core.first.call(null,inst_17494);
var inst_17496 = new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(inst_17495);
var inst_17497 = cljs.core.rseq.call(null,inst_17494);
var inst_17498 = cljs.core.first.call(null,inst_17497);
var inst_17499 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_17498);
var inst_17500 = [new cljs.core.Keyword(null,"children","children",-940561982)];
var inst_17501 = [inst_17494];
var inst_17502 = cljs.core.PersistentHashMap.fromArrays(inst_17500,inst_17501);
var inst_17503 = fluree.db.storage.core.write_branch_data.call(null,conn,branch_id,inst_17502);
var state_17512__$1 = (function (){var statearr_17516 = state_17512;
(statearr_17516[(7)] = inst_17499);

(statearr_17516[(8)] = inst_17496);

return statearr_17516;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17512__$1,(6),inst_17503);
} else {
if((state_val_17513 === (3))){
var inst_17510 = (state_17512[(2)]);
var state_17512__$1 = state_17512;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17512__$1,inst_17510);
} else {
if((state_val_17513 === (4))){
var inst_17487 = (state_17512[(2)]);
var state_17512__$1 = state_17512;
var statearr_17518_17532 = state_17512__$1;
(statearr_17518_17532[(2)] = inst_17487);

(statearr_17518_17532[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17513 === (5))){
var _ = (function (){var statearr_17519 = state_17512;
(statearr_17519[(4)] = cljs.core.rest.call(null,(state_17512[(4)])));

return statearr_17519;
})();
var state_17512__$1 = state_17512;
var ex17517 = (state_17512__$1[(2)]);
var statearr_17520_17533 = state_17512__$1;
(statearr_17520_17533[(5)] = ex17517);


if((ex17517 instanceof Error)){
var statearr_17521_17534 = state_17512__$1;
(statearr_17521_17534[(1)] = (4));

(statearr_17521_17534[(5)] = null);

} else {
throw ex17517;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17513 === (6))){
var inst_17505 = (state_17512[(2)]);
var inst_17506 = fluree.db.util.async.throw_err.call(null,inst_17505);
var inst_17507 = cljs.core.assoc.call(null,branch,new cljs.core.Keyword(null,"id","id",-1388402092),branch_id);
var _ = (function (){var statearr_17522 = state_17512;
(statearr_17522[(4)] = cljs.core.rest.call(null,(state_17512[(4)])));

return statearr_17522;
})();
var state_17512__$1 = (function (){var statearr_17523 = state_17512;
(statearr_17523[(9)] = inst_17506);

return statearr_17523;
})();
var statearr_17524_17535 = state_17512__$1;
(statearr_17524_17535[(2)] = inst_17507);

(statearr_17524_17535[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2746__auto__ = null;
var fluree$db$storage$core$state_machine__2746__auto____0 = (function (){
var statearr_17525 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17525[(0)] = fluree$db$storage$core$state_machine__2746__auto__);

(statearr_17525[(1)] = (1));

return statearr_17525;
});
var fluree$db$storage$core$state_machine__2746__auto____1 = (function (state_17512){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17512);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17526){var ex__2749__auto__ = e17526;
var statearr_17527_17536 = state_17512;
(statearr_17527_17536[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17512[(4)]))){
var statearr_17528_17537 = state_17512;
(statearr_17528_17537[(1)] = cljs.core.first.call(null,(state_17512[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17538 = state_17512;
state_17512 = G__17538;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2746__auto__ = function(state_17512){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2746__auto____1.call(this,state_17512);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2746__auto____0;
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2746__auto____1;
return fluree$db$storage$core$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17529 = f__2769__auto__.call(null);
(statearr_17529[(6)] = c__2768__auto__);

return statearr_17529;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.storage.core.write_branch.cljs$lang$maxFixedArity = 6);

/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,garbage){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17566){
var state_val_17567 = (state_17566[(1)]);
if((state_val_17567 === (1))){
var state_17566__$1 = state_17566;
var statearr_17568_17584 = state_17566__$1;
(statearr_17568_17584[(2)] = null);

(statearr_17568_17584[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17567 === (2))){
var inst_17552 = (state_17566[(7)]);
var _ = (function (){var statearr_17569 = state_17566;
(statearr_17569[(4)] = cljs.core.cons.call(null,(5),(state_17566[(4)])));

return statearr_17569;
})();
var inst_17546 = db;
var inst_17547 = cljs.core.__destructure_map.call(null,inst_17546);
var inst_17548 = cljs.core.get.call(null,inst_17547,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_17549 = cljs.core.get.call(null,inst_17547,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_17550 = cljs.core.get.call(null,inst_17547,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_17551 = cljs.core.get.call(null,inst_17547,new cljs.core.Keyword(null,"block","block",664686210));
var inst_17552__$1 = fluree.db.storage.core.ledger_garbage_key.call(null,inst_17549,inst_17550,inst_17551);
var inst_17553 = [new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_17554 = [inst_17550,inst_17551,garbage];
var inst_17555 = cljs.core.PersistentHashMap.fromArrays(inst_17553,inst_17554);
var inst_17556 = fluree.db.storage.core.serde.call(null,inst_17548);
var inst_17557 = fluree.db.serde.protocol._serialize_garbage.call(null,inst_17556,inst_17555);
var inst_17558 = fluree.db.storage.core.write.call(null,inst_17548,inst_17552__$1,inst_17557);
var state_17566__$1 = (function (){var statearr_17570 = state_17566;
(statearr_17570[(7)] = inst_17552__$1);

return statearr_17570;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17566__$1,(6),inst_17558);
} else {
if((state_val_17567 === (3))){
var inst_17564 = (state_17566[(2)]);
var state_17566__$1 = state_17566;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17566__$1,inst_17564);
} else {
if((state_val_17567 === (4))){
var inst_17539 = (state_17566[(2)]);
var state_17566__$1 = state_17566;
var statearr_17572_17585 = state_17566__$1;
(statearr_17572_17585[(2)] = inst_17539);

(statearr_17572_17585[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17567 === (5))){
var _ = (function (){var statearr_17573 = state_17566;
(statearr_17573[(4)] = cljs.core.rest.call(null,(state_17566[(4)])));

return statearr_17573;
})();
var state_17566__$1 = state_17566;
var ex17571 = (state_17566__$1[(2)]);
var statearr_17574_17586 = state_17566__$1;
(statearr_17574_17586[(5)] = ex17571);


if((ex17571 instanceof Error)){
var statearr_17575_17587 = state_17566__$1;
(statearr_17575_17587[(1)] = (4));

(statearr_17575_17587[(5)] = null);

} else {
throw ex17571;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17567 === (6))){
var inst_17552 = (state_17566[(7)]);
var inst_17560 = (state_17566[(2)]);
var inst_17561 = fluree.db.util.async.throw_err.call(null,inst_17560);
var _ = (function (){var statearr_17576 = state_17566;
(statearr_17576[(4)] = cljs.core.rest.call(null,(state_17566[(4)])));

return statearr_17576;
})();
var state_17566__$1 = (function (){var statearr_17577 = state_17566;
(statearr_17577[(8)] = inst_17561);

return statearr_17577;
})();
var statearr_17578_17588 = state_17566__$1;
(statearr_17578_17588[(2)] = inst_17552);

(statearr_17578_17588[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__2746__auto____0 = (function (){
var statearr_17579 = [null,null,null,null,null,null,null,null,null];
(statearr_17579[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__2746__auto__);

(statearr_17579[(1)] = (1));

return statearr_17579;
});
var fluree$db$storage$core$write_garbage_$_state_machine__2746__auto____1 = (function (state_17566){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17566);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17580){var ex__2749__auto__ = e17580;
var statearr_17581_17589 = state_17566;
(statearr_17581_17589[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17566[(4)]))){
var statearr_17582_17590 = state_17566;
(statearr_17582_17590[(1)] = cljs.core.first.call(null,(state_17566[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17591 = state_17566;
state_17566 = G__17591;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__2746__auto__ = function(state_17566){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__2746__auto____1.call(this,state_17566);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__2746__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__2746__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17583 = f__2769__auto__.call(null);
(statearr_17583[(6)] = c__2768__auto__);

return statearr_17583;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__17593 = arguments.length;
switch (G__17593) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.call(null,db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17651){
var state_val_17652 = (state_17651[(1)]);
if((state_val_17652 === (7))){
var state_17651__$1 = state_17651;
var statearr_17653_17679 = state_17651__$1;
(statearr_17653_17679[(2)] = (0));

(statearr_17653_17679[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17652 === (1))){
var state_17651__$1 = state_17651;
var statearr_17654_17680 = state_17651__$1;
(statearr_17654_17680[(2)] = null);

(statearr_17654_17680[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17652 === (4))){
var inst_17594 = (state_17651[(2)]);
var state_17651__$1 = state_17651;
var statearr_17655_17681 = state_17651__$1;
(statearr_17655_17681[(2)] = inst_17594);

(statearr_17655_17681[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17652 === (6))){
var inst_17620 = (state_17651[(7)]);
var state_17651__$1 = state_17651;
var statearr_17656_17682 = state_17651__$1;
(statearr_17656_17682[(2)] = inst_17620);

(statearr_17656_17682[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17652 === (3))){
var inst_17649 = (state_17651[(2)]);
var state_17651__$1 = state_17651;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17651__$1,inst_17649);
} else {
if((state_val_17652 === (12))){
var inst_17617 = (state_17651[(8)]);
var inst_17645 = (state_17651[(2)]);
var inst_17646 = fluree.db.util.async.throw_err.call(null,inst_17645);
var _ = (function (){var statearr_17657 = state_17651;
(statearr_17657[(4)] = cljs.core.rest.call(null,(state_17651[(4)])));

return statearr_17657;
})();
var state_17651__$1 = (function (){var statearr_17658 = state_17651;
(statearr_17658[(9)] = inst_17646);

return statearr_17658;
})();
var statearr_17659_17683 = state_17651__$1;
(statearr_17659_17683[(2)] = inst_17617);

(statearr_17659_17683[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17652 === (2))){
var inst_17612 = (state_17651[(10)]);
var inst_17609 = (state_17651[(11)]);
var inst_17620 = (state_17651[(7)]);
var inst_17607 = (state_17651[(12)]);
var _ = (function (){var statearr_17660 = state_17651;
(statearr_17660[(4)] = cljs.core.cons.call(null,(5),(state_17651[(4)])));

return statearr_17660;
})();
var inst_17601 = db;
var inst_17602 = cljs.core.__destructure_map.call(null,inst_17601);
var inst_17603 = cljs.core.get.call(null,inst_17602,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_17604 = cljs.core.get.call(null,inst_17602,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_17605 = cljs.core.get.call(null,inst_17602,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_17606 = cljs.core.get.call(null,inst_17602,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_17607__$1 = cljs.core.get.call(null,inst_17602,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_17608 = cljs.core.get.call(null,inst_17602,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_17609__$1 = cljs.core.get.call(null,inst_17602,new cljs.core.Keyword(null,"block","block",664686210));
var inst_17610 = cljs.core.get.call(null,inst_17602,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_17611 = cljs.core.get.call(null,inst_17602,new cljs.core.Keyword(null,"tspo","tspo",-440144953));
var inst_17612__$1 = cljs.core.get.call(null,inst_17602,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_17613 = cljs.core.get.call(null,inst_17602,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_17614 = cljs.core.get.call(null,inst_17602,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_17615 = cljs.core.get.call(null,inst_17602,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_17616 = cljs.core.get.call(null,inst_17602,new cljs.core.Keyword(null,"post","post",269697687));
var inst_17617 = fluree.db.storage.core.ledger_root_key.call(null,inst_17603,inst_17612__$1,inst_17609__$1);
var inst_17618 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_17619 = fluree.db.storage.core.child_data.call(null,inst_17610);
var inst_17620__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_17607__$1);
var state_17651__$1 = (function (){var statearr_17661 = state_17651;
(statearr_17661[(13)] = inst_17605);

(statearr_17661[(10)] = inst_17612__$1);

(statearr_17661[(14)] = inst_17619);

(statearr_17661[(15)] = inst_17604);

(statearr_17661[(16)] = inst_17616);

(statearr_17661[(17)] = inst_17618);

(statearr_17661[(8)] = inst_17617);

(statearr_17661[(11)] = inst_17609__$1);

(statearr_17661[(18)] = inst_17613);

(statearr_17661[(7)] = inst_17620__$1);

(statearr_17661[(19)] = inst_17615);

(statearr_17661[(20)] = inst_17611);

(statearr_17661[(21)] = inst_17606);

(statearr_17661[(22)] = inst_17614);

(statearr_17661[(23)] = inst_17608);

(statearr_17661[(12)] = inst_17607__$1);

return statearr_17661;
})();
if(cljs.core.truth_(inst_17620__$1)){
var statearr_17662_17684 = state_17651__$1;
(statearr_17662_17684[(1)] = (6));

} else {
var statearr_17663_17685 = state_17651__$1;
(statearr_17663_17685[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17652 === (11))){
var inst_17605 = (state_17651[(13)]);
var inst_17612 = (state_17651[(10)]);
var inst_17619 = (state_17651[(14)]);
var inst_17604 = (state_17651[(15)]);
var inst_17616 = (state_17651[(16)]);
var inst_17624 = (state_17651[(24)]);
var inst_17618 = (state_17651[(17)]);
var inst_17617 = (state_17651[(8)]);
var inst_17609 = (state_17651[(11)]);
var inst_17615 = (state_17651[(19)]);
var inst_17625 = (state_17651[(25)]);
var inst_17606 = (state_17651[(21)]);
var inst_17614 = (state_17651[(22)]);
var inst_17608 = (state_17651[(23)]);
var inst_17607 = (state_17651[(12)]);
var inst_17630 = (state_17651[(2)]);
var inst_17631 = fluree.db.storage.core.child_data.call(null,inst_17614);
var inst_17632 = fluree.db.storage.core.child_data.call(null,inst_17616);
var inst_17633 = fluree.db.util.core.current_time_millis.call(null);
var inst_17634 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17635 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_17636 = (new cljs.core.PersistentVector(null,2,(5),inst_17634,inst_17635,null));
var inst_17637 = cljs.core.select_keys.call(null,inst_17607,inst_17636);
var inst_17638 = fluree.db.storage.core.child_data.call(null,inst_17606);
var inst_17639 = [inst_17609,inst_17619,inst_17624,inst_17612,inst_17625,inst_17630,inst_17631,inst_17632,inst_17604,inst_17633,inst_17605,inst_17615,inst_17637,inst_17638];
var inst_17640 = cljs.core.PersistentHashMap.fromArrays(inst_17618,inst_17639);
var inst_17641 = fluree.db.storage.core.serde.call(null,inst_17608);
var inst_17642 = fluree.db.serde.protocol._serialize_db_root.call(null,inst_17641,inst_17640);
var inst_17643 = fluree.db.storage.core.write.call(null,inst_17608,inst_17617,inst_17642);
var state_17651__$1 = state_17651;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17651__$1,(12),inst_17643);
} else {
if((state_val_17652 === (9))){
var inst_17626 = (state_17651[(26)]);
var state_17651__$1 = state_17651;
var statearr_17665_17686 = state_17651__$1;
(statearr_17665_17686[(2)] = inst_17626);

(statearr_17665_17686[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17652 === (5))){
var _ = (function (){var statearr_17666 = state_17651;
(statearr_17666[(4)] = cljs.core.rest.call(null,(state_17651[(4)])));

return statearr_17666;
})();
var state_17651__$1 = state_17651;
var ex17664 = (state_17651__$1[(2)]);
var statearr_17667_17687 = state_17651__$1;
(statearr_17667_17687[(5)] = ex17664);


if((ex17664 instanceof Error)){
var statearr_17668_17688 = state_17651__$1;
(statearr_17668_17688[(1)] = (4));

(statearr_17668_17688[(5)] = null);

} else {
throw ex17664;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17652 === (10))){
var inst_17613 = (state_17651[(18)]);
var state_17651__$1 = state_17651;
var statearr_17669_17689 = state_17651__$1;
(statearr_17669_17689[(2)] = inst_17613);

(statearr_17669_17689[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17652 === (8))){
var inst_17626 = (state_17651[(26)]);
var inst_17611 = (state_17651[(20)]);
var inst_17624 = (state_17651[(2)]);
var inst_17625 = fluree.db.storage.core.child_data.call(null,inst_17611);
var inst_17626__$1 = custom_ecount;
var state_17651__$1 = (function (){var statearr_17670 = state_17651;
(statearr_17670[(26)] = inst_17626__$1);

(statearr_17670[(24)] = inst_17624);

(statearr_17670[(25)] = inst_17625);

return statearr_17670;
})();
if(cljs.core.truth_(inst_17626__$1)){
var statearr_17671_17690 = state_17651__$1;
(statearr_17671_17690[(1)] = (9));

} else {
var statearr_17672_17691 = state_17651__$1;
(statearr_17672_17691[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2746__auto__ = null;
var fluree$db$storage$core$state_machine__2746__auto____0 = (function (){
var statearr_17673 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17673[(0)] = fluree$db$storage$core$state_machine__2746__auto__);

(statearr_17673[(1)] = (1));

return statearr_17673;
});
var fluree$db$storage$core$state_machine__2746__auto____1 = (function (state_17651){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17651);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17674){var ex__2749__auto__ = e17674;
var statearr_17675_17692 = state_17651;
(statearr_17675_17692[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17651[(4)]))){
var statearr_17676_17693 = state_17651;
(statearr_17676_17693[(1)] = cljs.core.first.call(null,(state_17651[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17694 = state_17651;
state_17651 = G__17694;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2746__auto__ = function(state_17651){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2746__auto____1.call(this,state_17651);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2746__auto____0;
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2746__auto____1;
return fluree$db$storage$core$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17677 = f__2769__auto__.call(null);
(statearr_17677[(6)] = c__2768__auto__);

return statearr_17677;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(p__17695,key){
var map__17696 = p__17695;
var map__17696__$1 = cljs.core.__destructure_map.call(null,map__17696);
var conn = map__17696__$1;
var serializer = cljs.core.get.call(null,map__17696__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17716){
var state_val_17717 = (state_17716[(1)]);
if((state_val_17717 === (7))){
var inst_17706 = (state_17716[(7)]);
var inst_17708 = fluree.db.serde.protocol._deserialize_branch.call(null,serializer,inst_17706);
var state_17716__$1 = state_17716;
var statearr_17718_17737 = state_17716__$1;
(statearr_17718_17737[(2)] = inst_17708);

(statearr_17718_17737[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17717 === (1))){
var state_17716__$1 = state_17716;
var statearr_17719_17738 = state_17716__$1;
(statearr_17719_17738[(2)] = null);

(statearr_17719_17738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17717 === (4))){
var inst_17697 = (state_17716[(2)]);
var state_17716__$1 = state_17716;
var statearr_17720_17739 = state_17716__$1;
(statearr_17720_17739[(2)] = inst_17697);

(statearr_17720_17739[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17717 === (6))){
var inst_17706 = (state_17716[(7)]);
var inst_17705 = (state_17716[(2)]);
var inst_17706__$1 = fluree.db.util.async.throw_err.call(null,inst_17705);
var state_17716__$1 = (function (){var statearr_17721 = state_17716;
(statearr_17721[(7)] = inst_17706__$1);

return statearr_17721;
})();
if(cljs.core.truth_(inst_17706__$1)){
var statearr_17722_17740 = state_17716__$1;
(statearr_17722_17740[(1)] = (7));

} else {
var statearr_17723_17741 = state_17716__$1;
(statearr_17723_17741[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17717 === (3))){
var inst_17714 = (state_17716[(2)]);
var state_17716__$1 = state_17716;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17716__$1,inst_17714);
} else {
if((state_val_17717 === (2))){
var _ = (function (){var statearr_17725 = state_17716;
(statearr_17725[(4)] = cljs.core.cons.call(null,(5),(state_17716[(4)])));

return statearr_17725;
})();
var inst_17703 = fluree.db.storage.core.read.call(null,conn,key);
var state_17716__$1 = state_17716;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17716__$1,(6),inst_17703);
} else {
if((state_val_17717 === (9))){
var inst_17711 = (state_17716[(2)]);
var _ = (function (){var statearr_17726 = state_17716;
(statearr_17726[(4)] = cljs.core.rest.call(null,(state_17716[(4)])));

return statearr_17726;
})();
var state_17716__$1 = state_17716;
var statearr_17727_17742 = state_17716__$1;
(statearr_17727_17742[(2)] = inst_17711);

(statearr_17727_17742[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17717 === (5))){
var _ = (function (){var statearr_17728 = state_17716;
(statearr_17728[(4)] = cljs.core.rest.call(null,(state_17716[(4)])));

return statearr_17728;
})();
var state_17716__$1 = state_17716;
var ex17724 = (state_17716__$1[(2)]);
var statearr_17729_17743 = state_17716__$1;
(statearr_17729_17743[(5)] = ex17724);


if((ex17724 instanceof Error)){
var statearr_17730_17744 = state_17716__$1;
(statearr_17730_17744[(1)] = (4));

(statearr_17730_17744[(5)] = null);

} else {
throw ex17724;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17717 === (8))){
var state_17716__$1 = state_17716;
var statearr_17731_17745 = state_17716__$1;
(statearr_17731_17745[(2)] = null);

(statearr_17731_17745[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__2746__auto____0 = (function (){
var statearr_17732 = [null,null,null,null,null,null,null,null];
(statearr_17732[(0)] = fluree$db$storage$core$read_branch_$_state_machine__2746__auto__);

(statearr_17732[(1)] = (1));

return statearr_17732;
});
var fluree$db$storage$core$read_branch_$_state_machine__2746__auto____1 = (function (state_17716){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17716);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17733){var ex__2749__auto__ = e17733;
var statearr_17734_17746 = state_17716;
(statearr_17734_17746[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17716[(4)]))){
var statearr_17735_17747 = state_17716;
(statearr_17735_17747[(1)] = cljs.core.first.call(null,(state_17716[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17748 = state_17716;
state_17716 = G__17748;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__2746__auto__ = function(state_17716){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__2746__auto____1.call(this,state_17716);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__2746__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__2746__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17736 = f__2769__auto__.call(null);
(statearr_17736[(6)] = c__2768__auto__);

return statearr_17736;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(p__17749,key){
var map__17750 = p__17749;
var map__17750__$1 = cljs.core.__destructure_map.call(null,map__17750);
var conn = map__17750__$1;
var serializer = cljs.core.get.call(null,map__17750__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17770){
var state_val_17771 = (state_17770[(1)]);
if((state_val_17771 === (7))){
var inst_17760 = (state_17770[(7)]);
var inst_17762 = fluree.db.serde.protocol._deserialize_leaf.call(null,serializer,inst_17760);
var state_17770__$1 = state_17770;
var statearr_17772_17791 = state_17770__$1;
(statearr_17772_17791[(2)] = inst_17762);

(statearr_17772_17791[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17771 === (1))){
var state_17770__$1 = state_17770;
var statearr_17773_17792 = state_17770__$1;
(statearr_17773_17792[(2)] = null);

(statearr_17773_17792[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17771 === (4))){
var inst_17751 = (state_17770[(2)]);
var state_17770__$1 = state_17770;
var statearr_17774_17793 = state_17770__$1;
(statearr_17774_17793[(2)] = inst_17751);

(statearr_17774_17793[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17771 === (6))){
var inst_17760 = (state_17770[(7)]);
var inst_17759 = (state_17770[(2)]);
var inst_17760__$1 = fluree.db.util.async.throw_err.call(null,inst_17759);
var state_17770__$1 = (function (){var statearr_17775 = state_17770;
(statearr_17775[(7)] = inst_17760__$1);

return statearr_17775;
})();
if(cljs.core.truth_(inst_17760__$1)){
var statearr_17776_17794 = state_17770__$1;
(statearr_17776_17794[(1)] = (7));

} else {
var statearr_17777_17795 = state_17770__$1;
(statearr_17777_17795[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17771 === (3))){
var inst_17768 = (state_17770[(2)]);
var state_17770__$1 = state_17770;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17770__$1,inst_17768);
} else {
if((state_val_17771 === (2))){
var _ = (function (){var statearr_17779 = state_17770;
(statearr_17779[(4)] = cljs.core.cons.call(null,(5),(state_17770[(4)])));

return statearr_17779;
})();
var inst_17757 = fluree.db.storage.core.read.call(null,conn,key);
var state_17770__$1 = state_17770;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17770__$1,(6),inst_17757);
} else {
if((state_val_17771 === (9))){
var inst_17765 = (state_17770[(2)]);
var _ = (function (){var statearr_17780 = state_17770;
(statearr_17780[(4)] = cljs.core.rest.call(null,(state_17770[(4)])));

return statearr_17780;
})();
var state_17770__$1 = state_17770;
var statearr_17781_17796 = state_17770__$1;
(statearr_17781_17796[(2)] = inst_17765);

(statearr_17781_17796[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17771 === (5))){
var _ = (function (){var statearr_17782 = state_17770;
(statearr_17782[(4)] = cljs.core.rest.call(null,(state_17770[(4)])));

return statearr_17782;
})();
var state_17770__$1 = state_17770;
var ex17778 = (state_17770__$1[(2)]);
var statearr_17783_17797 = state_17770__$1;
(statearr_17783_17797[(5)] = ex17778);


if((ex17778 instanceof Error)){
var statearr_17784_17798 = state_17770__$1;
(statearr_17784_17798[(1)] = (4));

(statearr_17784_17798[(5)] = null);

} else {
throw ex17778;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17771 === (8))){
var state_17770__$1 = state_17770;
var statearr_17785_17799 = state_17770__$1;
(statearr_17785_17799[(2)] = null);

(statearr_17785_17799[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__2746__auto____0 = (function (){
var statearr_17786 = [null,null,null,null,null,null,null,null];
(statearr_17786[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__2746__auto__);

(statearr_17786[(1)] = (1));

return statearr_17786;
});
var fluree$db$storage$core$read_leaf_$_state_machine__2746__auto____1 = (function (state_17770){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17770);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17787){var ex__2749__auto__ = e17787;
var statearr_17788_17800 = state_17770;
(statearr_17788_17800[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17770[(4)]))){
var statearr_17789_17801 = state_17770;
(statearr_17789_17801[(1)] = cljs.core.first.call(null,(state_17770[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17802 = state_17770;
state_17770 = G__17802;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__2746__auto__ = function(state_17770){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__2746__auto____1.call(this,state_17770);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__2746__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__2746__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17790 = f__2769__auto__.call(null);
(statearr_17790[(6)] = c__2768__auto__);

return statearr_17790;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(_conn,p__17803,index,index_data){
var map__17804 = p__17803;
var map__17804__$1 = cljs.core.__destructure_map.call(null,map__17804);
var network = cljs.core.get.call(null,map__17804__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__17804__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var comparators = cljs.core.get.call(null,map__17804__$1,new cljs.core.Keyword(null,"comparators","comparators",-1325611955));
var block = cljs.core.get.call(null,map__17804__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__17804__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var cmp = (function (){var or__5045__auto__ = cljs.core.get.call(null,comparators,index);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Internal error reifying db index root: ",cljs.core.pr_str.call(null,index)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
var G__17805 = index_data;
var G__17805__$1 = (cljs.core.truth_(new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(index_data))?cljs.core.update.call(null,G__17805,new cljs.core.Keyword(null,"rhs","rhs",-229356739),fluree.db.flake.parts__GT_Flake):G__17805);
var G__17805__$2 = (cljs.core.truth_(new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(index_data))?cljs.core.update.call(null,G__17805__$1,new cljs.core.Keyword(null,"first","first",-644103046),fluree.db.flake.parts__GT_Flake):G__17805__$1);
return cljs.core.assoc.call(null,G__17805__$2,new cljs.core.Keyword(null,"comparator","comparator",2144896662),cmp,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),ledger_id,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true);

});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__17806 = root_data;
var map__17806__$1 = cljs.core.__destructure_map.call(null,map__17806);
var block = cljs.core.get.call(null,map__17806__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__17806__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.call(null,map__17806__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.call(null,map__17806__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.call(null,blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.call(null,stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block));
return cljs.core.reduce.call(null,(function (db,idx){
var idx_root = fluree.db.storage.core.reify_index_root.call(null,conn,db,idx,cljs.core.get.call(null,root_data,idx));
return cljs.core.assoc.call(null,db,idx,idx_root);
}),db_STAR_,fluree.db.index.types);
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,ledger_id,block){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17828){
var state_val_17829 = (state_17828[(1)]);
if((state_val_17829 === (7))){
var state_17828__$1 = state_17828;
var statearr_17830_17850 = state_17828__$1;
(statearr_17830_17850[(2)] = null);

(statearr_17830_17850[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17829 === (1))){
var state_17828__$1 = state_17828;
var statearr_17831_17851 = state_17828__$1;
(statearr_17831_17851[(2)] = null);

(statearr_17831_17851[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17829 === (4))){
var inst_17807 = (state_17828[(2)]);
var state_17828__$1 = state_17828;
var statearr_17832_17852 = state_17828__$1;
(statearr_17832_17852[(2)] = inst_17807);

(statearr_17832_17852[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17829 === (6))){
var inst_17814 = (state_17828[(7)]);
var inst_17816 = fluree.db.storage.core.serde.call(null,conn);
var state_17828__$1 = (function (){var statearr_17833 = state_17828;
(statearr_17833[(8)] = inst_17816);

return statearr_17833;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17828__$1,(9),inst_17814);
} else {
if((state_val_17829 === (3))){
var inst_17826 = (state_17828[(2)]);
var state_17828__$1 = state_17828;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17828__$1,inst_17826);
} else {
if((state_val_17829 === (2))){
var inst_17814 = (state_17828[(7)]);
var _ = (function (){var statearr_17835 = state_17828;
(statearr_17835[(4)] = cljs.core.cons.call(null,(5),(state_17828[(4)])));

return statearr_17835;
})();
var inst_17813 = fluree.db.storage.core.ledger_garbage_key.call(null,network,ledger_id,block);
var inst_17814__$1 = fluree.db.storage.core.read.call(null,conn,inst_17813);
var state_17828__$1 = (function (){var statearr_17836 = state_17828;
(statearr_17836[(7)] = inst_17814__$1);

return statearr_17836;
})();
if(cljs.core.truth_(inst_17814__$1)){
var statearr_17837_17853 = state_17828__$1;
(statearr_17837_17853[(1)] = (6));

} else {
var statearr_17838_17854 = state_17828__$1;
(statearr_17838_17854[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17829 === (9))){
var inst_17816 = (state_17828[(8)]);
var inst_17818 = (state_17828[(2)]);
var inst_17819 = fluree.db.util.async.throw_err.call(null,inst_17818);
var inst_17820 = fluree.db.serde.protocol._deserialize_garbage.call(null,inst_17816,inst_17819);
var state_17828__$1 = state_17828;
var statearr_17839_17855 = state_17828__$1;
(statearr_17839_17855[(2)] = inst_17820);

(statearr_17839_17855[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17829 === (5))){
var _ = (function (){var statearr_17840 = state_17828;
(statearr_17840[(4)] = cljs.core.rest.call(null,(state_17828[(4)])));

return statearr_17840;
})();
var state_17828__$1 = state_17828;
var ex17834 = (state_17828__$1[(2)]);
var statearr_17841_17856 = state_17828__$1;
(statearr_17841_17856[(5)] = ex17834);


if((ex17834 instanceof Error)){
var statearr_17842_17857 = state_17828__$1;
(statearr_17842_17857[(1)] = (4));

(statearr_17842_17857[(5)] = null);

} else {
throw ex17834;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17829 === (8))){
var inst_17823 = (state_17828[(2)]);
var _ = (function (){var statearr_17843 = state_17828;
(statearr_17843[(4)] = cljs.core.rest.call(null,(state_17828[(4)])));

return statearr_17843;
})();
var state_17828__$1 = state_17828;
var statearr_17844_17858 = state_17828__$1;
(statearr_17844_17858[(2)] = inst_17823);

(statearr_17844_17858[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__2746__auto____0 = (function (){
var statearr_17845 = [null,null,null,null,null,null,null,null,null];
(statearr_17845[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__2746__auto__);

(statearr_17845[(1)] = (1));

return statearr_17845;
});
var fluree$db$storage$core$read_garbage_$_state_machine__2746__auto____1 = (function (state_17828){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17828);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17846){var ex__2749__auto__ = e17846;
var statearr_17847_17859 = state_17828;
(statearr_17847_17859[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17828[(4)]))){
var statearr_17848_17860 = state_17828;
(statearr_17848_17860[(1)] = cljs.core.first.call(null,(state_17828[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17861 = state_17828;
state_17828 = G__17861;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__2746__auto__ = function(state_17828){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__2746__auto____1.call(this,state_17828);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__2746__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__2746__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17849 = f__2769__auto__.call(null);
(statearr_17849[(6)] = c__2768__auto__);

return statearr_17849;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,ledger_id,block){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17883){
var state_val_17884 = (state_17883[(1)]);
if((state_val_17884 === (7))){
var inst_17872 = (state_17883[(7)]);
var inst_17874 = fluree.db.storage.core.serde.call(null,conn);
var inst_17875 = fluree.db.serde.protocol._deserialize_db_root.call(null,inst_17874,inst_17872);
var state_17883__$1 = state_17883;
var statearr_17885_17904 = state_17883__$1;
(statearr_17885_17904[(2)] = inst_17875);

(statearr_17885_17904[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17884 === (1))){
var state_17883__$1 = state_17883;
var statearr_17886_17905 = state_17883__$1;
(statearr_17886_17905[(2)] = null);

(statearr_17886_17905[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17884 === (4))){
var inst_17862 = (state_17883[(2)]);
var state_17883__$1 = state_17883;
var statearr_17887_17906 = state_17883__$1;
(statearr_17887_17906[(2)] = inst_17862);

(statearr_17887_17906[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17884 === (6))){
var inst_17872 = (state_17883[(7)]);
var inst_17871 = (state_17883[(2)]);
var inst_17872__$1 = fluree.db.util.async.throw_err.call(null,inst_17871);
var state_17883__$1 = (function (){var statearr_17888 = state_17883;
(statearr_17888[(7)] = inst_17872__$1);

return statearr_17888;
})();
if(cljs.core.truth_(inst_17872__$1)){
var statearr_17889_17907 = state_17883__$1;
(statearr_17889_17907[(1)] = (7));

} else {
var statearr_17890_17908 = state_17883__$1;
(statearr_17890_17908[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17884 === (3))){
var inst_17881 = (state_17883[(2)]);
var state_17883__$1 = state_17883;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17883__$1,inst_17881);
} else {
if((state_val_17884 === (2))){
var _ = (function (){var statearr_17892 = state_17883;
(statearr_17892[(4)] = cljs.core.cons.call(null,(5),(state_17883[(4)])));

return statearr_17892;
})();
var inst_17868 = fluree.db.storage.core.ledger_root_key.call(null,network,ledger_id,block);
var inst_17869 = fluree.db.storage.core.read.call(null,conn,inst_17868);
var state_17883__$1 = state_17883;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17883__$1,(6),inst_17869);
} else {
if((state_val_17884 === (9))){
var inst_17878 = (state_17883[(2)]);
var _ = (function (){var statearr_17893 = state_17883;
(statearr_17893[(4)] = cljs.core.rest.call(null,(state_17883[(4)])));

return statearr_17893;
})();
var state_17883__$1 = state_17883;
var statearr_17894_17909 = state_17883__$1;
(statearr_17894_17909[(2)] = inst_17878);

(statearr_17894_17909[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17884 === (5))){
var _ = (function (){var statearr_17895 = state_17883;
(statearr_17895[(4)] = cljs.core.rest.call(null,(state_17883[(4)])));

return statearr_17895;
})();
var state_17883__$1 = state_17883;
var ex17891 = (state_17883__$1[(2)]);
var statearr_17896_17910 = state_17883__$1;
(statearr_17896_17910[(5)] = ex17891);


if((ex17891 instanceof Error)){
var statearr_17897_17911 = state_17883__$1;
(statearr_17897_17911[(1)] = (4));

(statearr_17897_17911[(5)] = null);

} else {
throw ex17891;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17884 === (8))){
var state_17883__$1 = state_17883;
var statearr_17898_17912 = state_17883__$1;
(statearr_17898_17912[(2)] = null);

(statearr_17898_17912[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__2746__auto____0 = (function (){
var statearr_17899 = [null,null,null,null,null,null,null,null];
(statearr_17899[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__2746__auto__);

(statearr_17899[(1)] = (1));

return statearr_17899;
});
var fluree$db$storage$core$read_db_root_$_state_machine__2746__auto____1 = (function (state_17883){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17883);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17900){var ex__2749__auto__ = e17900;
var statearr_17901_17913 = state_17883;
(statearr_17901_17913[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17883[(4)]))){
var statearr_17902_17914 = state_17883;
(statearr_17902_17914[(1)] = cljs.core.first.call(null,(state_17883[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17915 = state_17883;
state_17883 = G__17915;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__2746__auto__ = function(state_17883){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__2746__auto____1.call(this,state_17883);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__2746__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__2746__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17903 = f__2769__auto__.call(null);
(statearr_17903[(6)] = c__2768__auto__);

return statearr_17903;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index,
 *   throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,ledger_id,blank_db,index){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17952){
var state_val_17953 = (state_17952[(1)]);
if((state_val_17953 === (7))){
var inst_17922 = (state_17952[(7)]);
var state_17952__$1 = state_17952;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17952__$1,(9),inst_17922);
} else {
if((state_val_17953 === (1))){
var state_17952__$1 = state_17952;
var statearr_17954_17975 = state_17952__$1;
(statearr_17954_17975[(2)] = null);

(statearr_17954_17975[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17953 === (4))){
var inst_17916 = (state_17952[(2)]);
var state_17952__$1 = state_17952;
var statearr_17955_17976 = state_17952__$1;
(statearr_17955_17976[(2)] = inst_17916);

(statearr_17955_17976[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17953 === (6))){
var inst_17925 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_17926 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17927 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_17928 = cljs.core.PersistentHashMap.fromArrays(inst_17926,inst_17927);
var inst_17929 = cljs.core.ex_info.call(null,inst_17925,inst_17928);
var inst_17930 = (function(){throw inst_17929})();
var state_17952__$1 = state_17952;
var statearr_17956_17977 = state_17952__$1;
(statearr_17956_17977[(2)] = inst_17930);

(statearr_17956_17977[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17953 === (3))){
var inst_17950 = (state_17952[(2)]);
var state_17952__$1 = state_17952;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17952__$1,inst_17950);
} else {
if((state_val_17953 === (2))){
var inst_17922 = (state_17952[(7)]);
var _ = (function (){var statearr_17957 = state_17952;
(statearr_17957[(4)] = cljs.core.cons.call(null,(5),(state_17952[(4)])));

return statearr_17957;
})();
var inst_17922__$1 = fluree.db.storage.core.read_db_root.call(null,conn,network,ledger_id,index);
var inst_17923 = cljs.core.not.call(null,inst_17922__$1);
var state_17952__$1 = (function (){var statearr_17958 = state_17952;
(statearr_17958[(7)] = inst_17922__$1);

return statearr_17958;
})();
if(inst_17923){
var statearr_17959_17978 = state_17952__$1;
(statearr_17959_17978[(1)] = (6));

} else {
var statearr_17960_17979 = state_17952__$1;
(statearr_17960_17979[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17953 === (11))){
var inst_17940 = (state_17952[(8)]);
var inst_17943 = (state_17952[(2)]);
var inst_17944 = fluree.db.util.async.throw_err.call(null,inst_17943);
var inst_17945 = cljs.core.assoc.call(null,inst_17940,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_17944);
var state_17952__$1 = state_17952;
var statearr_17962_17980 = state_17952__$1;
(statearr_17962_17980[(2)] = inst_17945);

(statearr_17962_17980[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17953 === (9))){
var inst_17935 = (state_17952[(9)]);
var inst_17933 = (state_17952[(2)]);
var inst_17934 = fluree.db.util.async.throw_err.call(null,inst_17933);
var inst_17935__$1 = fluree.db.storage.core.reify_db_root.call(null,conn,blank_db,inst_17934);
var inst_17936 = fluree.db.query.schema.schema_map.call(null,inst_17935__$1);
var state_17952__$1 = (function (){var statearr_17963 = state_17952;
(statearr_17963[(9)] = inst_17935__$1);

return statearr_17963;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17952__$1,(10),inst_17936);
} else {
if((state_val_17953 === (5))){
var _ = (function (){var statearr_17964 = state_17952;
(statearr_17964[(4)] = cljs.core.rest.call(null,(state_17952[(4)])));

return statearr_17964;
})();
var state_17952__$1 = state_17952;
var ex17961 = (state_17952__$1[(2)]);
var statearr_17965_17981 = state_17952__$1;
(statearr_17965_17981[(5)] = ex17961);


if((ex17961 instanceof Error)){
var statearr_17966_17982 = state_17952__$1;
(statearr_17966_17982[(1)] = (4));

(statearr_17966_17982[(5)] = null);

} else {
throw ex17961;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17953 === (10))){
var inst_17940 = (state_17952[(8)]);
var inst_17935 = (state_17952[(9)]);
var inst_17938 = (state_17952[(2)]);
var inst_17939 = fluree.db.util.async.throw_err.call(null,inst_17938);
var inst_17940__$1 = cljs.core.assoc.call(null,inst_17935,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_17939);
var inst_17941 = fluree.db.query.schema.setting_map.call(null,inst_17940__$1);
var state_17952__$1 = (function (){var statearr_17967 = state_17952;
(statearr_17967[(8)] = inst_17940__$1);

return statearr_17967;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17952__$1,(11),inst_17941);
} else {
if((state_val_17953 === (8))){
var inst_17947 = (state_17952[(2)]);
var _ = (function (){var statearr_17968 = state_17952;
(statearr_17968[(4)] = cljs.core.rest.call(null,(state_17952[(4)])));

return statearr_17968;
})();
var state_17952__$1 = state_17952;
var statearr_17969_17983 = state_17952__$1;
(statearr_17969_17983[(2)] = inst_17947);

(statearr_17969_17983[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__2746__auto____0 = (function (){
var statearr_17970 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17970[(0)] = fluree$db$storage$core$reify_db_$_state_machine__2746__auto__);

(statearr_17970[(1)] = (1));

return statearr_17970;
});
var fluree$db$storage$core$reify_db_$_state_machine__2746__auto____1 = (function (state_17952){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17952);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17971){var ex__2749__auto__ = e17971;
var statearr_17972_17984 = state_17952;
(statearr_17972_17984[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17952[(4)]))){
var statearr_17973_17985 = state_17952;
(statearr_17973_17985[(1)] = cljs.core.first.call(null,(state_17952[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17986 = state_17952;
state_17952 = G__17986;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__2746__auto__ = function(state_17952){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__2746__auto____1.call(this,state_17952);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__2746__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__2746__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17974 = f__2769__auto__.call(null);
(statearr_17974[(6)] = c__2768__auto__);

return statearr_17974;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.storage.core.fetch_child_attributes = (function fluree$db$storage$core$fetch_child_attributes(conn,p__17987){
var map__17988 = p__17987;
var map__17988__$1 = cljs.core.__destructure_map.call(null,map__17988);
var branch = map__17988__$1;
var id = cljs.core.get.call(null,map__17988__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var comparator = cljs.core.get.call(null,map__17988__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var leftmost_QMARK_ = cljs.core.get.call(null,map__17988__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18025){
var state_val_18026 = (state_18025[(1)]);
if((state_val_18026 === (7))){
var inst_17998 = (state_18025[(7)]);
var inst_18001 = cljs.core.__destructure_map.call(null,inst_17998);
var inst_18002 = cljs.core.get.call(null,inst_18001,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_18003 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18004 = [new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"tempid","tempid",1427663222)];
var inst_18005 = (new cljs.core.PersistentVector(null,7,(5),inst_18003,inst_18004,null));
var inst_18006 = cljs.core.select_keys.call(null,branch,inst_18005);
var inst_18007 = (function (){var temp__5802__auto__ = inst_17998;
var map__18000 = inst_18001;
var children = inst_18002;
var branch_metadata = inst_18006;
return (function (i,child){
return cljs.core.merge.call(null,cljs.core.assoc.call(null,branch_metadata,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),(function (){var and__5043__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return (i === (0));
} else {
return and__5043__auto__;
}
})()),child);
});
})();
var inst_18008 = cljs.core.map_indexed.call(null,inst_18007,inst_18002);
var inst_18009 = cljs.core.juxt.call(null,new cljs.core.Keyword(null,"first","first",-644103046),cljs.core.identity);
var inst_18010 = cljs.core.mapcat.call(null,inst_18009,inst_18008);
var inst_18011 = cljs.core.apply.call(null,fluree.db.flake.sorted_map_by,comparator,inst_18010);
var state_18025__$1 = state_18025;
var statearr_18027_18046 = state_18025__$1;
(statearr_18027_18046[(2)] = inst_18011);

(statearr_18027_18046[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18026 === (1))){
var state_18025__$1 = state_18025;
var statearr_18028_18047 = state_18025__$1;
(statearr_18028_18047[(2)] = null);

(statearr_18028_18047[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18026 === (4))){
var inst_17989 = (state_18025[(2)]);
var state_18025__$1 = state_18025;
var statearr_18029_18048 = state_18025__$1;
(statearr_18029_18048[(2)] = inst_17989);

(statearr_18029_18048[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18026 === (6))){
var inst_17998 = (state_18025[(7)]);
var inst_17997 = (state_18025[(2)]);
var inst_17998__$1 = fluree.db.util.async.throw_err.call(null,inst_17997);
var state_18025__$1 = (function (){var statearr_18030 = state_18025;
(statearr_18030[(7)] = inst_17998__$1);

return statearr_18030;
})();
if(cljs.core.truth_(inst_17998__$1)){
var statearr_18031_18049 = state_18025__$1;
(statearr_18031_18049[(1)] = (7));

} else {
var statearr_18032_18050 = state_18025__$1;
(statearr_18032_18050[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18026 === (3))){
var inst_18023 = (state_18025[(2)]);
var state_18025__$1 = state_18025;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18025__$1,inst_18023);
} else {
if((state_val_18026 === (2))){
var _ = (function (){var statearr_18034 = state_18025;
(statearr_18034[(4)] = cljs.core.cons.call(null,(5),(state_18025[(4)])));

return statearr_18034;
})();
var inst_17995 = fluree.db.storage.core.read_branch.call(null,conn,id);
var state_18025__$1 = state_18025;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18025__$1,(6),inst_17995);
} else {
if((state_val_18026 === (9))){
var inst_18020 = (state_18025[(2)]);
var _ = (function (){var statearr_18035 = state_18025;
(statearr_18035[(4)] = cljs.core.rest.call(null,(state_18025[(4)])));

return statearr_18035;
})();
var state_18025__$1 = state_18025;
var statearr_18036_18051 = state_18025__$1;
(statearr_18036_18051[(2)] = inst_18020);

(statearr_18036_18051[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18026 === (5))){
var _ = (function (){var statearr_18037 = state_18025;
(statearr_18037[(4)] = cljs.core.rest.call(null,(state_18025[(4)])));

return statearr_18037;
})();
var state_18025__$1 = state_18025;
var ex18033 = (state_18025__$1[(2)]);
var statearr_18038_18052 = state_18025__$1;
(statearr_18038_18052[(5)] = ex18033);


if((ex18033 instanceof Error)){
var statearr_18039_18053 = state_18025__$1;
(statearr_18039_18053[(1)] = (4));

(statearr_18039_18053[(5)] = null);

} else {
throw ex18033;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18026 === (8))){
var inst_18013 = ["Unable to retrieve index branch with id ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)," from storage."].join('');
var inst_18014 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18015 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_18016 = cljs.core.PersistentHashMap.fromArrays(inst_18014,inst_18015);
var inst_18017 = cljs.core.ex_info.call(null,inst_18013,inst_18016);
var inst_18018 = (function(){throw inst_18017})();
var state_18025__$1 = state_18025;
var statearr_18040_18054 = state_18025__$1;
(statearr_18040_18054[(2)] = inst_18018);

(statearr_18040_18054[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto____0 = (function (){
var statearr_18041 = [null,null,null,null,null,null,null,null];
(statearr_18041[(0)] = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto__);

(statearr_18041[(1)] = (1));

return statearr_18041;
});
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto____1 = (function (state_18025){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18025);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18042){var ex__2749__auto__ = e18042;
var statearr_18043_18055 = state_18025;
(statearr_18043_18055[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18025[(4)]))){
var statearr_18044_18056 = state_18025;
(statearr_18044_18056[(1)] = cljs.core.first.call(null,(state_18025[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18057 = state_18025;
state_18025 = G__18057;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto__ = function(state_18025){
switch(arguments.length){
case 0:
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto____1.call(this,state_18025);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto____0;
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto____1;
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18045 = f__2769__auto__.call(null);
(statearr_18045[(6)] = c__2768__auto__);

return statearr_18045;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.storage.core.fetch_leaf_flakes = (function fluree$db$storage$core$fetch_leaf_flakes(conn,p__18058){
var map__18059 = p__18058;
var map__18059__$1 = cljs.core.__destructure_map.call(null,map__18059);
var id = cljs.core.get.call(null,map__18059__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var comparator = cljs.core.get.call(null,map__18059__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18088){
var state_val_18089 = (state_18088[(1)]);
if((state_val_18089 === (7))){
var inst_18069 = (state_18088[(7)]);
var inst_18072 = cljs.core.__destructure_map.call(null,inst_18069);
var inst_18073 = cljs.core.get.call(null,inst_18072,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_18074 = cljs.core.apply.call(null,fluree.db.flake.sorted_set_by,comparator,inst_18073);
var state_18088__$1 = state_18088;
var statearr_18090_18109 = state_18088__$1;
(statearr_18090_18109[(2)] = inst_18074);

(statearr_18090_18109[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18089 === (1))){
var state_18088__$1 = state_18088;
var statearr_18091_18110 = state_18088__$1;
(statearr_18091_18110[(2)] = null);

(statearr_18091_18110[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18089 === (4))){
var inst_18060 = (state_18088[(2)]);
var state_18088__$1 = state_18088;
var statearr_18092_18111 = state_18088__$1;
(statearr_18092_18111[(2)] = inst_18060);

(statearr_18092_18111[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18089 === (6))){
var inst_18069 = (state_18088[(7)]);
var inst_18068 = (state_18088[(2)]);
var inst_18069__$1 = fluree.db.util.async.throw_err.call(null,inst_18068);
var state_18088__$1 = (function (){var statearr_18093 = state_18088;
(statearr_18093[(7)] = inst_18069__$1);

return statearr_18093;
})();
if(cljs.core.truth_(inst_18069__$1)){
var statearr_18094_18112 = state_18088__$1;
(statearr_18094_18112[(1)] = (7));

} else {
var statearr_18095_18113 = state_18088__$1;
(statearr_18095_18113[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18089 === (3))){
var inst_18086 = (state_18088[(2)]);
var state_18088__$1 = state_18088;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18088__$1,inst_18086);
} else {
if((state_val_18089 === (2))){
var _ = (function (){var statearr_18097 = state_18088;
(statearr_18097[(4)] = cljs.core.cons.call(null,(5),(state_18088[(4)])));

return statearr_18097;
})();
var inst_18066 = fluree.db.storage.core.read_leaf.call(null,conn,id);
var state_18088__$1 = state_18088;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18088__$1,(6),inst_18066);
} else {
if((state_val_18089 === (9))){
var inst_18083 = (state_18088[(2)]);
var _ = (function (){var statearr_18098 = state_18088;
(statearr_18098[(4)] = cljs.core.rest.call(null,(state_18088[(4)])));

return statearr_18098;
})();
var state_18088__$1 = state_18088;
var statearr_18099_18114 = state_18088__$1;
(statearr_18099_18114[(2)] = inst_18083);

(statearr_18099_18114[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18089 === (5))){
var _ = (function (){var statearr_18100 = state_18088;
(statearr_18100[(4)] = cljs.core.rest.call(null,(state_18088[(4)])));

return statearr_18100;
})();
var state_18088__$1 = state_18088;
var ex18096 = (state_18088__$1[(2)]);
var statearr_18101_18115 = state_18088__$1;
(statearr_18101_18115[(5)] = ex18096);


if((ex18096 instanceof Error)){
var statearr_18102_18116 = state_18088__$1;
(statearr_18102_18116[(1)] = (4));

(statearr_18102_18116[(5)] = null);

} else {
throw ex18096;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18089 === (8))){
var inst_18076 = ["Unable to retrieve leaf node with id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)," from storage"].join('');
var inst_18077 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18078 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_18079 = cljs.core.PersistentHashMap.fromArrays(inst_18077,inst_18078);
var inst_18080 = cljs.core.ex_info.call(null,inst_18076,inst_18079);
var inst_18081 = (function(){throw inst_18080})();
var state_18088__$1 = state_18088;
var statearr_18103_18117 = state_18088__$1;
(statearr_18103_18117[(2)] = inst_18081);

(statearr_18103_18117[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto__ = null;
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto____0 = (function (){
var statearr_18104 = [null,null,null,null,null,null,null,null];
(statearr_18104[(0)] = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto__);

(statearr_18104[(1)] = (1));

return statearr_18104;
});
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto____1 = (function (state_18088){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18088);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18105){var ex__2749__auto__ = e18105;
var statearr_18106_18118 = state_18088;
(statearr_18106_18118[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18088[(4)]))){
var statearr_18107_18119 = state_18088;
(statearr_18107_18119[(1)] = cljs.core.first.call(null,(state_18088[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18120 = state_18088;
state_18088 = G__18120;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto__ = function(state_18088){
switch(arguments.length){
case 0:
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto____1.call(this,state_18088);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto____0;
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto____1;
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18108 = f__2769__auto__.call(null);
(statearr_18108[(6)] = c__2768__auto__);

return statearr_18108;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.storage.core.resolve_index_node = (function fluree$db$storage$core$resolve_index_node(var_args){
var G__18122 = arguments.length;
switch (G__18122) {
case 2:
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$2 = (function (conn,node){
return fluree.db.storage.core.resolve_index_node.call(null,node,null);
}));

(fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$3 = (function (conn,p__18123,error_fn){
var map__18124 = p__18123;
var map__18124__$1 = cljs.core.__destructure_map.call(null,map__18124);
var node = map__18124__$1;
var comparator = cljs.core.get.call(null,map__18124__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var leaf = cljs.core.get.call(null,map__18124__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
if(cljs.core.truth_(comparator)){
} else {
throw (new Error(["Assert failed: ","Cannot resolve index node; configuration does not have a comparator.","\n","comparator"].join('')));
}

var return_ch = cljs.core.async.chan.call(null);
var c__2768__auto___18196 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18168){
var state_val_18169 = (state_18168[(1)]);
if((state_val_18169 === (7))){
var inst_18133 = (state_18168[(2)]);
var state_18168__$1 = state_18168;
var statearr_18170_18197 = state_18168__$1;
(statearr_18170_18197[(2)] = inst_18133);

(statearr_18170_18197[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18169 === (1))){
var state_18168__$1 = state_18168;
var statearr_18171_18198 = state_18168__$1;
(statearr_18171_18198[(2)] = null);

(statearr_18171_18198[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18169 === (4))){
var inst_18125 = (state_18168[(7)]);
var inst_18125__$1 = (state_18168[(2)]);
var inst_18126 = fluree.db.util.log.error.call(null,inst_18125__$1,"Error resolving index node");
var state_18168__$1 = (function (){var statearr_18172 = state_18168;
(statearr_18172[(8)] = inst_18126);

(statearr_18172[(7)] = inst_18125__$1);

return statearr_18172;
})();
if(cljs.core.truth_(error_fn)){
var statearr_18173_18199 = state_18168__$1;
(statearr_18173_18199[(1)] = (5));

} else {
var statearr_18174_18200 = state_18168__$1;
(statearr_18174_18200[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18169 === (13))){
var inst_18151 = (state_18168[(9)]);
var inst_18154 = (state_18168[(2)]);
var inst_18155 = fluree.db.util.async.throw_err.call(null,inst_18154);
var inst_18156 = [new cljs.core.Keyword(null,"children","children",-940561982),inst_18155];
var inst_18157 = (new cljs.core.PersistentVector(null,2,(5),inst_18151,inst_18156,null));
var state_18168__$1 = state_18168;
var statearr_18175_18201 = state_18168__$1;
(statearr_18175_18201[(2)] = inst_18157);

(statearr_18175_18201[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18169 === (6))){
var state_18168__$1 = state_18168;
var statearr_18176_18202 = state_18168__$1;
(statearr_18176_18202[(2)] = null);

(statearr_18176_18202[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18169 === (3))){
var inst_18166 = (state_18168[(2)]);
var state_18168__$1 = state_18168;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18168__$1,inst_18166);
} else {
if((state_val_18169 === (12))){
var inst_18143 = (state_18168[(10)]);
var inst_18146 = (state_18168[(2)]);
var inst_18147 = fluree.db.util.async.throw_err.call(null,inst_18146);
var inst_18148 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_18147];
var inst_18149 = (new cljs.core.PersistentVector(null,2,(5),inst_18143,inst_18148,null));
var state_18168__$1 = state_18168;
var statearr_18177_18203 = state_18168__$1;
(statearr_18177_18203[(2)] = inst_18149);

(statearr_18177_18203[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18169 === (2))){
var _ = (function (){var statearr_18178 = state_18168;
(statearr_18178[(4)] = cljs.core.cons.call(null,(8),(state_18168[(4)])));

return statearr_18178;
})();
var state_18168__$1 = state_18168;
if(cljs.core.truth_(leaf)){
var statearr_18179_18204 = state_18168__$1;
(statearr_18179_18204[(1)] = (9));

} else {
var statearr_18180_18205 = state_18168__$1;
(statearr_18180_18205[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18169 === (11))){
var inst_18159 = (state_18168[(2)]);
var inst_18160 = cljs.core.nth.call(null,inst_18159,(0),null);
var inst_18161 = cljs.core.nth.call(null,inst_18159,(1),null);
var inst_18162 = cljs.core.assoc.call(null,node,inst_18160,inst_18161);
var inst_18163 = cljs.core.async.put_BANG_.call(null,return_ch,inst_18162);
var _ = (function (){var statearr_18181 = state_18168;
(statearr_18181[(4)] = cljs.core.rest.call(null,(state_18168[(4)])));

return statearr_18181;
})();
var state_18168__$1 = state_18168;
var statearr_18182_18206 = state_18168__$1;
(statearr_18182_18206[(2)] = inst_18163);

(statearr_18182_18206[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18169 === (9))){
var inst_18143 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18144 = fluree.db.storage.core.fetch_leaf_flakes.call(null,conn,node);
var state_18168__$1 = (function (){var statearr_18183 = state_18168;
(statearr_18183[(10)] = inst_18143);

return statearr_18183;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18168__$1,(12),inst_18144);
} else {
if((state_val_18169 === (5))){
var inst_18125 = (state_18168[(7)]);
var inst_18128 = cljs.core.async.put_BANG_.call(null,return_ch,inst_18125);
var inst_18129 = cljs.core.async.close_BANG_.call(null,return_ch);
var inst_18130 = error_fn.call(null,inst_18128,inst_18129);
var state_18168__$1 = state_18168;
var statearr_18185_18207 = state_18168__$1;
(statearr_18185_18207[(2)] = inst_18130);

(statearr_18185_18207[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18169 === (10))){
var inst_18151 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18152 = fluree.db.storage.core.fetch_child_attributes.call(null,conn,node);
var state_18168__$1 = (function (){var statearr_18186 = state_18168;
(statearr_18186[(9)] = inst_18151);

return statearr_18186;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18168__$1,(13),inst_18152);
} else {
if((state_val_18169 === (8))){
var _ = (function (){var statearr_18187 = state_18168;
(statearr_18187[(4)] = cljs.core.rest.call(null,(state_18168[(4)])));

return statearr_18187;
})();
var state_18168__$1 = state_18168;
var ex18184 = (state_18168__$1[(2)]);
var statearr_18188_18208 = state_18168__$1;
(statearr_18188_18208[(5)] = ex18184);


var statearr_18189_18209 = state_18168__$1;
(statearr_18189_18209[(1)] = (4));

(statearr_18189_18209[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2746__auto__ = null;
var fluree$db$storage$core$state_machine__2746__auto____0 = (function (){
var statearr_18190 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18190[(0)] = fluree$db$storage$core$state_machine__2746__auto__);

(statearr_18190[(1)] = (1));

return statearr_18190;
});
var fluree$db$storage$core$state_machine__2746__auto____1 = (function (state_18168){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18168);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18191){var ex__2749__auto__ = e18191;
var statearr_18192_18210 = state_18168;
(statearr_18192_18210[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18168[(4)]))){
var statearr_18193_18211 = state_18168;
(statearr_18193_18211[(1)] = cljs.core.first.call(null,(state_18168[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18212 = state_18168;
state_18168 = G__18212;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2746__auto__ = function(state_18168){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2746__auto____1.call(this,state_18168);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2746__auto____0;
fluree$db$storage$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2746__auto____1;
return fluree$db$storage$core$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18194 = f__2769__auto__.call(null);
(statearr_18194[(6)] = c__2768__auto___18196);

return statearr_18194;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return return_ch;
}));

(fluree.db.storage.core.resolve_index_node.cljs$lang$maxFixedArity = 3);

fluree.db.storage.core.resolve_empty_leaf = (function fluree$db$storage$core$resolve_empty_leaf(p__18213){
var map__18214 = p__18213;
var map__18214__$1 = cljs.core.__destructure_map.call(null,map__18214);
var node = map__18214__$1;
var comparator = cljs.core.get.call(null,map__18214__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var ch = cljs.core.async.chan.call(null);
var empty_set = fluree.db.flake.sorted_set_by.call(null,comparator);
var empty_node = cljs.core.assoc.call(null,node,new cljs.core.Keyword(null,"flakes","flakes",1977895739),empty_set);
cljs.core.async.put_BANG_.call(null,ch,empty_node);

return ch;
});
