// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.dbfunctions.ctx');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__69387 = arguments.length;
switch (G__69387) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5802__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var block = temp__5802__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___69426 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69408){
var state_val_69409 = (state_69408[(1)]);
if((state_val_69409 === (1))){
var state_69408__$1 = state_69408;
var statearr_69410_69427 = state_69408__$1;
(statearr_69410_69427[(2)] = null);

(statearr_69410_69427[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (2))){
var _ = (function (){var statearr_69411 = state_69408;
(statearr_69411[(4)] = cljs.core.cons((5),(state_69408[(4)])));

return statearr_69411;
})();
var inst_69394 = fluree.db.session.db(conn,ledger,null);
var state_69408__$1 = state_69408;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69408__$1,(7),inst_69394);
} else {
if((state_val_69409 === (3))){
var inst_69404 = (state_69408[(2)]);
var inst_69405 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_69404);
var inst_69406 = cljs.core.async.close_BANG_(pc);
var state_69408__$1 = (function (){var statearr_69413 = state_69408;
(statearr_69413[(7)] = inst_69405);

return statearr_69413;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_69408__$1,inst_69406);
} else {
if((state_val_69409 === (4))){
var inst_69388 = (state_69408[(2)]);
var state_69408__$1 = state_69408;
var statearr_69414_69428 = state_69408__$1;
(statearr_69414_69428[(2)] = inst_69388);

(statearr_69414_69428[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (5))){
var _ = (function (){var statearr_69415 = state_69408;
(statearr_69415[(4)] = cljs.core.rest((state_69408[(4)])));

return statearr_69415;
})();
var state_69408__$1 = state_69408;
var ex69412 = (state_69408__$1[(2)]);
var statearr_69416_69429 = state_69408__$1;
(statearr_69416_69429[(5)] = ex69412);


var statearr_69417_69430 = state_69408__$1;
(statearr_69417_69430[(1)] = (4));

(statearr_69417_69430[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (6))){
var inst_69400 = (state_69408[(2)]);
var inst_69401 = fluree.db.util.async.throw_err(inst_69400);
var _ = (function (){var statearr_69418 = state_69408;
(statearr_69418[(4)] = cljs.core.rest((state_69408[(4)])));

return statearr_69418;
})();
var state_69408__$1 = state_69408;
var statearr_69419_69431 = state_69408__$1;
(statearr_69419_69431[(2)] = inst_69401);

(statearr_69419_69431[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (7))){
var inst_69396 = (state_69408[(2)]);
var inst_69397 = fluree.db.util.async.throw_err(inst_69396);
var inst_69398 = fluree.db.time_travel.as_of_block(inst_69397,block);
var state_69408__$1 = state_69408;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69408__$1,(6),inst_69398);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2727__auto__ = null;
var fluree$db$api$ledger$state_machine__2727__auto____0 = (function (){
var statearr_69420 = [null,null,null,null,null,null,null,null];
(statearr_69420[(0)] = fluree$db$api$ledger$state_machine__2727__auto__);

(statearr_69420[(1)] = (1));

return statearr_69420;
});
var fluree$db$api$ledger$state_machine__2727__auto____1 = (function (state_69408){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_69408);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69421){var ex__2730__auto__ = e69421;
var statearr_69422_69432 = state_69408;
(statearr_69422_69432[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_69408[(4)]))){
var statearr_69423_69433 = state_69408;
(statearr_69423_69433[(1)] = cljs.core.first((state_69408[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69434 = state_69408;
state_69408 = G__69434;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2727__auto__ = function(state_69408){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2727__auto____1.call(this,state_69408);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2727__auto____0;
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2727__auto____1;
return fluree$db$api$ledger$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69424 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_69424[(6)] = c__2749__auto___69426);

return statearr_69424;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t(db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69475){
var state_val_69476 = (state_69475[(1)]);
if((state_val_69476 === (7))){
var inst_69444 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_69475__$1 = state_69475;
if(inst_69444){
var statearr_69477_69508 = state_69475__$1;
(statearr_69477_69508[(1)] = (9));

} else {
var statearr_69478_69509 = state_69475__$1;
(statearr_69478_69509[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69476 === (1))){
var state_69475__$1 = state_69475;
var statearr_69479_69510 = state_69475__$1;
(statearr_69479_69510[(2)] = null);

(statearr_69479_69510[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69476 === (4))){
var inst_69435 = (state_69475[(2)]);
var state_69475__$1 = state_69475;
var statearr_69480_69511 = state_69475__$1;
(statearr_69480_69511[(2)] = inst_69435);

(statearr_69480_69511[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69476 === (15))){
var inst_69452 = (state_69475[(7)]);
var inst_69451 = (state_69475[(2)]);
var inst_69452__$1 = fluree.db.util.async.throw_err(inst_69451);
var state_69475__$1 = (function (){var statearr_69481 = state_69475;
(statearr_69481[(7)] = inst_69452__$1);

return statearr_69481;
})();
if(cljs.core.truth_(inst_69452__$1)){
var statearr_69482_69512 = state_69475__$1;
(statearr_69482_69512[(1)] = (16));

} else {
var statearr_69483_69513 = state_69475__$1;
(statearr_69483_69513[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69476 === (13))){
var state_69475__$1 = state_69475;
var statearr_69484_69514 = state_69475__$1;
(statearr_69484_69514[(2)] = null);

(statearr_69484_69514[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69476 === (6))){
var state_69475__$1 = state_69475;
var statearr_69485_69515 = state_69475__$1;
(statearr_69485_69515[(2)] = db);

(statearr_69485_69515[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69476 === (17))){
var inst_69456 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_69457 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69458 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_69459 = cljs.core.PersistentHashMap.fromArrays(inst_69457,inst_69458);
var inst_69460 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_69456,inst_69459);
var inst_69461 = (function(){throw inst_69460})();
var state_69475__$1 = state_69475;
var statearr_69486_69516 = state_69475__$1;
(statearr_69486_69516[(2)] = inst_69461);

(statearr_69486_69516[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69476 === (3))){
var inst_69473 = (state_69475[(2)]);
var state_69475__$1 = state_69475;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69475__$1,inst_69473);
} else {
if((state_val_69476 === (12))){
var inst_69449 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_69475__$1 = state_69475;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69475__$1,(15),inst_69449);
} else {
if((state_val_69476 === (2))){
var _ = (function (){var statearr_69487 = state_69475;
(statearr_69487[(4)] = cljs.core.cons((5),(state_69475[(4)])));

return statearr_69487;
})();
var inst_69441 = cljs.core.not(auth);
var state_69475__$1 = state_69475;
if(inst_69441){
var statearr_69488_69517 = state_69475__$1;
(statearr_69488_69517[(1)] = (6));

} else {
var statearr_69489_69518 = state_69475__$1;
(statearr_69489_69518[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69476 === (11))){
var inst_69468 = (state_69475[(2)]);
var state_69475__$1 = state_69475;
var statearr_69491_69519 = state_69475__$1;
(statearr_69491_69519[(2)] = inst_69468);

(statearr_69491_69519[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69476 === (9))){
var inst_69446 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_69475__$1 = state_69475;
var statearr_69492_69520 = state_69475__$1;
(statearr_69492_69520[(2)] = inst_69446);

(statearr_69492_69520[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69476 === (5))){
var _ = (function (){var statearr_69493 = state_69475;
(statearr_69493[(4)] = cljs.core.rest((state_69475[(4)])));

return statearr_69493;
})();
var state_69475__$1 = state_69475;
var ex69490 = (state_69475__$1[(2)]);
var statearr_69494_69521 = state_69475__$1;
(statearr_69494_69521[(5)] = ex69490);


if((ex69490 instanceof Error)){
var statearr_69495_69522 = state_69475__$1;
(statearr_69495_69522[(1)] = (4));

(statearr_69495_69522[(5)] = null);

} else {
throw ex69490;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69476 === (14))){
var inst_69466 = (state_69475[(2)]);
var state_69475__$1 = state_69475;
var statearr_69496_69523 = state_69475__$1;
(statearr_69496_69523[(2)] = inst_69466);

(statearr_69496_69523[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69476 === (16))){
var inst_69452 = (state_69475[(7)]);
var inst_69454 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_69452);
var state_69475__$1 = state_69475;
var statearr_69497_69524 = state_69475__$1;
(statearr_69497_69524[(2)] = inst_69454);

(statearr_69497_69524[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69476 === (10))){
var state_69475__$1 = state_69475;
var statearr_69498_69525 = state_69475__$1;
(statearr_69498_69525[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69476 === (18))){
var inst_69463 = (state_69475[(2)]);
var state_69475__$1 = state_69475;
var statearr_69500_69526 = state_69475__$1;
(statearr_69500_69526[(2)] = inst_69463);

(statearr_69500_69526[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69476 === (8))){
var inst_69470 = (state_69475[(2)]);
var _ = (function (){var statearr_69501 = state_69475;
(statearr_69501[(4)] = cljs.core.rest((state_69475[(4)])));

return statearr_69501;
})();
var state_69475__$1 = state_69475;
var statearr_69502_69527 = state_69475__$1;
(statearr_69502_69527[(2)] = inst_69470);

(statearr_69502_69527[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0 = (function (){
var statearr_69503 = [null,null,null,null,null,null,null,null];
(statearr_69503[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__);

(statearr_69503[(1)] = (1));

return statearr_69503;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1 = (function (state_69475){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_69475);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69504){var ex__2730__auto__ = e69504;
var statearr_69505_69528 = state_69475;
(statearr_69505_69528[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_69475[(4)]))){
var statearr_69506_69529 = state_69475;
(statearr_69506_69529[(1)] = cljs.core.first((state_69475[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69530 = state_69475;
state_69475 = G__69530;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__ = function(state_69475){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1.call(this,state_69475);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69507 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_69507[(6)] = c__2749__auto__);

return statearr_69507;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69602){
var state_val_69603 = (state_69602[(1)]);
if((state_val_69603 === (7))){
var inst_69540 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_69602__$1 = state_69602;
if(inst_69540){
var statearr_69604_69658 = state_69602__$1;
(statearr_69604_69658[(1)] = (9));

} else {
var statearr_69605_69659 = state_69602__$1;
(statearr_69605_69659[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (20))){
var inst_69564 = (state_69602[(7)]);
var state_69602__$1 = state_69602;
if(cljs.core.truth_(inst_69564)){
var statearr_69606_69660 = state_69602__$1;
(statearr_69606_69660[(1)] = (22));

} else {
var statearr_69607_69661 = state_69602__$1;
(statearr_69607_69661[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (27))){
var state_69602__$1 = state_69602;
var statearr_69608_69662 = state_69602__$1;
(statearr_69608_69662[(2)] = null);

(statearr_69608_69662[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (1))){
var state_69602__$1 = state_69602;
var statearr_69609_69663 = state_69602__$1;
(statearr_69609_69663[(2)] = null);

(statearr_69609_69663[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (24))){
var inst_69578 = (state_69602[(2)]);
var state_69602__$1 = state_69602;
var statearr_69610_69664 = state_69602__$1;
(statearr_69610_69664[(2)] = inst_69578);

(statearr_69610_69664[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (4))){
var inst_69531 = (state_69602[(2)]);
var state_69602__$1 = state_69602;
var statearr_69611_69665 = state_69602__$1;
(statearr_69611_69665[(2)] = inst_69531);

(statearr_69611_69665[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (15))){
var inst_69547 = (state_69602[(8)]);
var inst_69546 = (state_69602[(2)]);
var inst_69547__$1 = fluree.db.util.async.throw_err(inst_69546);
var state_69602__$1 = (function (){var statearr_69612 = state_69602;
(statearr_69612[(8)] = inst_69547__$1);

return statearr_69612;
})();
if(cljs.core.truth_(inst_69547__$1)){
var statearr_69613_69666 = state_69602__$1;
(statearr_69613_69666[(1)] = (16));

} else {
var statearr_69614_69667 = state_69602__$1;
(statearr_69614_69667[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (21))){
var inst_69580 = (state_69602[(9)]);
var inst_69580__$1 = (state_69602[(2)]);
var state_69602__$1 = (function (){var statearr_69615 = state_69602;
(statearr_69615[(9)] = inst_69580__$1);

return statearr_69615;
})();
if(cljs.core.truth_(inst_69580__$1)){
var statearr_69616_69668 = state_69602__$1;
(statearr_69616_69668[(1)] = (29));

} else {
var statearr_69617_69669 = state_69602__$1;
(statearr_69617_69669[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (31))){
var inst_69580 = (state_69602[(9)]);
var inst_69588 = (state_69602[(2)]);
var state_69602__$1 = (function (){var statearr_69618 = state_69602;
(statearr_69618[(10)] = inst_69588);

return statearr_69618;
})();
if(cljs.core.truth_(inst_69580)){
var statearr_69619_69670 = state_69602__$1;
(statearr_69619_69670[(1)] = (33));

} else {
var statearr_69620_69671 = state_69602__$1;
(statearr_69620_69671[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (32))){
var inst_69584 = (state_69602[(2)]);
var inst_69585 = fluree.db.util.async.throw_err(inst_69584);
var state_69602__$1 = state_69602;
var statearr_69621_69672 = state_69602__$1;
(statearr_69621_69672[(2)] = inst_69585);

(statearr_69621_69672[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (33))){
var inst_69580 = (state_69602[(9)]);
var inst_69590 = fluree.db.permissions.permission_map(db,inst_69580,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_69602__$1 = state_69602;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69602__$1,(36),inst_69590);
} else {
if((state_val_69603 === (13))){
var state_69602__$1 = state_69602;
var statearr_69622_69673 = state_69602__$1;
(statearr_69622_69673[(2)] = null);

(statearr_69622_69673[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (22))){
var inst_69564 = (state_69602[(7)]);
var inst_69568 = fluree.db.auth.roles(db,inst_69564);
var state_69602__$1 = state_69602;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69602__$1,(25),inst_69568);
} else {
if((state_val_69603 === (36))){
var inst_69592 = (state_69602[(2)]);
var inst_69593 = fluree.db.util.async.throw_err(inst_69592);
var state_69602__$1 = state_69602;
var statearr_69623_69674 = state_69602__$1;
(statearr_69623_69674[(2)] = inst_69593);

(statearr_69623_69674[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (29))){
var inst_69564 = (state_69602[(7)]);
var inst_69580 = (state_69602[(9)]);
var inst_69582 = fluree.db.dbfunctions.ctx.build(db,inst_69564,inst_69580);
var state_69602__$1 = state_69602;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69602__$1,(32),inst_69582);
} else {
if((state_val_69603 === (6))){
var state_69602__$1 = state_69602;
var statearr_69624_69675 = state_69602__$1;
(statearr_69624_69675[(2)] = null);

(statearr_69624_69675[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (28))){
var inst_69576 = (state_69602[(2)]);
var state_69602__$1 = state_69602;
var statearr_69625_69676 = state_69602__$1;
(statearr_69625_69676[(2)] = inst_69576);

(statearr_69625_69676[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (25))){
var inst_69570 = (state_69602[(2)]);
var inst_69571 = fluree.db.util.async.throw_err(inst_69570);
var state_69602__$1 = state_69602;
var statearr_69626_69677 = state_69602__$1;
(statearr_69626_69677[(2)] = inst_69571);

(statearr_69626_69677[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (34))){
var state_69602__$1 = state_69602;
var statearr_69627_69678 = state_69602__$1;
(statearr_69627_69678[(2)] = null);

(statearr_69627_69678[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (17))){
var inst_69550 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_69551 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69552 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_69553 = cljs.core.PersistentHashMap.fromArrays(inst_69551,inst_69552);
var inst_69554 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_69550,inst_69553);
var inst_69555 = (function(){throw inst_69554})();
var state_69602__$1 = state_69602;
var statearr_69628_69679 = state_69602__$1;
(statearr_69628_69679[(2)] = inst_69555);

(statearr_69628_69679[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (3))){
var inst_69600 = (state_69602[(2)]);
var state_69602__$1 = state_69602;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69602__$1,inst_69600);
} else {
if((state_val_69603 === (12))){
var inst_69544 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_69602__$1 = state_69602;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69602__$1,(15),inst_69544);
} else {
if((state_val_69603 === (2))){
var _ = (function (){var statearr_69629 = state_69602;
(statearr_69629[(4)] = cljs.core.cons((5),(state_69602[(4)])));

return statearr_69629;
})();
var inst_69537 = (auth == null);
var state_69602__$1 = state_69602;
if(cljs.core.truth_(inst_69537)){
var statearr_69630_69680 = state_69602__$1;
(statearr_69630_69680[(1)] = (6));

} else {
var statearr_69631_69681 = state_69602__$1;
(statearr_69631_69681[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (23))){
var state_69602__$1 = state_69602;
var statearr_69632_69682 = state_69602__$1;
(statearr_69632_69682[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (35))){
var inst_69564 = (state_69602[(7)]);
var inst_69580 = (state_69602[(9)]);
var inst_69588 = (state_69602[(10)]);
var inst_69596 = (state_69602[(2)]);
var inst_69597 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_69564,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"roles","roles",143379530),inst_69580,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_69596,new cljs.core.Keyword(null,"ctx","ctx",-493610118),inst_69588], 0));
var _ = (function (){var statearr_69634 = state_69602;
(statearr_69634[(4)] = cljs.core.rest((state_69602[(4)])));

return statearr_69634;
})();
var state_69602__$1 = state_69602;
var statearr_69635_69683 = state_69602__$1;
(statearr_69635_69683[(2)] = inst_69597);

(statearr_69635_69683[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (19))){
var state_69602__$1 = state_69602;
var statearr_69636_69684 = state_69602__$1;
(statearr_69636_69684[(2)] = roles);

(statearr_69636_69684[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (11))){
var inst_69562 = (state_69602[(2)]);
var state_69602__$1 = state_69602;
var statearr_69638_69685 = state_69602__$1;
(statearr_69638_69685[(2)] = inst_69562);

(statearr_69638_69685[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (9))){
var state_69602__$1 = state_69602;
var statearr_69639_69686 = state_69602__$1;
(statearr_69639_69686[(2)] = (0));

(statearr_69639_69686[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (5))){
var _ = (function (){var statearr_69640 = state_69602;
(statearr_69640[(4)] = cljs.core.rest((state_69602[(4)])));

return statearr_69640;
})();
var state_69602__$1 = state_69602;
var ex69637 = (state_69602__$1[(2)]);
var statearr_69641_69687 = state_69602__$1;
(statearr_69641_69687[(5)] = ex69637);


if((ex69637 instanceof Error)){
var statearr_69642_69688 = state_69602__$1;
(statearr_69642_69688[(1)] = (4));

(statearr_69642_69688[(5)] = null);

} else {
throw ex69637;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (14))){
var inst_69560 = (state_69602[(2)]);
var state_69602__$1 = state_69602;
var statearr_69643_69689 = state_69602__$1;
(statearr_69643_69689[(2)] = inst_69560);

(statearr_69643_69689[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (26))){
var state_69602__$1 = state_69602;
var statearr_69644_69690 = state_69602__$1;
(statearr_69644_69690[(2)] = null);

(statearr_69644_69690[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (16))){
var inst_69547 = (state_69602[(8)]);
var state_69602__$1 = state_69602;
var statearr_69645_69691 = state_69602__$1;
(statearr_69645_69691[(2)] = inst_69547);

(statearr_69645_69691[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (30))){
var state_69602__$1 = state_69602;
var statearr_69646_69692 = state_69602__$1;
(statearr_69646_69692[(2)] = null);

(statearr_69646_69692[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (10))){
var state_69602__$1 = state_69602;
if(cljs.core.truth_(auth)){
var statearr_69647_69693 = state_69602__$1;
(statearr_69647_69693[(1)] = (12));

} else {
var statearr_69648_69694 = state_69602__$1;
(statearr_69648_69694[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (18))){
var inst_69557 = (state_69602[(2)]);
var state_69602__$1 = state_69602;
var statearr_69649_69695 = state_69602__$1;
(statearr_69649_69695[(2)] = inst_69557);

(statearr_69649_69695[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (8))){
var inst_69564 = (state_69602[(2)]);
var state_69602__$1 = (function (){var statearr_69650 = state_69602;
(statearr_69650[(7)] = inst_69564);

return statearr_69650;
})();
if(cljs.core.truth_(roles)){
var statearr_69651_69696 = state_69602__$1;
(statearr_69651_69696[(1)] = (19));

} else {
var statearr_69652_69697 = state_69602__$1;
(statearr_69652_69697[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0 = (function (){
var statearr_69653 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_69653[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__);

(statearr_69653[(1)] = (1));

return statearr_69653;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1 = (function (state_69602){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_69602);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69654){var ex__2730__auto__ = e69654;
var statearr_69655_69698 = state_69602;
(statearr_69655_69698[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_69602[(4)]))){
var statearr_69656_69699 = state_69602;
(statearr_69656_69699[(1)] = cljs.core.first((state_69602[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69700 = state_69602;
state_69602 = G__69700;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__ = function(state_69602){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1.call(this,state_69602);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69657 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_69657[(6)] = c__2749__auto__);

return statearr_69657;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__69701 = db;
var map__69701__$1 = cljs.core.__destructure_map(map__69701);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69701__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69701__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69701__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,ledger_id,listen_id);

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69708){
var state_val_69709 = (state_69708[(1)]);
if((state_val_69709 === (1))){
var inst_69702 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_69703 = fluree.db.session.db(conn,inst_69702,null);
var state_69708__$1 = state_69708;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69708__$1,(2),inst_69703);
} else {
if((state_val_69709 === (2))){
var inst_69705 = (state_69708[(2)]);
var inst_69706 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_69705);
var state_69708__$1 = state_69708;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69708__$1,inst_69706);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0 = (function (){
var statearr_69710 = [null,null,null,null,null,null,null];
(statearr_69710[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__);

(statearr_69710[(1)] = (1));

return statearr_69710;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1 = (function (state_69708){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_69708);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69711){var ex__2730__auto__ = e69711;
var statearr_69712_69739 = state_69708;
(statearr_69712_69739[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_69708[(4)]))){
var statearr_69713_69740 = state_69708;
(statearr_69713_69740[(1)] = cljs.core.first((state_69708[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69741 = state_69708;
state_69708 = G__69741;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = function(state_69708){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1.call(this,state_69708);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69714 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_69714[(6)] = c__2749__auto__);

return statearr_69714;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,ledger_id,listen_id,event_fn);

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69727){
var state_val_69728 = (state_69727[(1)]);
if((state_val_69728 === (1))){
var inst_69715 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_69716 = fluree.db.session.db(conn,inst_69715,null);
var state_69727__$1 = state_69727;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69727__$1,(2),inst_69716);
} else {
if((state_val_69728 === (2))){
var inst_69718 = (state_69727[(7)]);
var inst_69718__$1 = (state_69727[(2)]);
var inst_69719 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_69718__$1);
var inst_69720 = newer_block_QMARK_(inst_69719);
var state_69727__$1 = (function (){var statearr_69729 = state_69727;
(statearr_69729[(7)] = inst_69718__$1);

return statearr_69729;
})();
if(inst_69720){
var statearr_69730_69742 = state_69727__$1;
(statearr_69730_69742[(1)] = (3));

} else {
var statearr_69731_69743 = state_69727__$1;
(statearr_69731_69743[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69728 === (3))){
var inst_69718 = (state_69727[(7)]);
var inst_69722 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_69718);
var state_69727__$1 = state_69727;
var statearr_69732_69744 = state_69727__$1;
(statearr_69732_69744[(2)] = inst_69722);

(statearr_69732_69744[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69728 === (4))){
var state_69727__$1 = state_69727;
var statearr_69733_69745 = state_69727__$1;
(statearr_69733_69745[(2)] = null);

(statearr_69733_69745[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69728 === (5))){
var inst_69725 = (state_69727[(2)]);
var state_69727__$1 = state_69727;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69727__$1,inst_69725);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0 = (function (){
var statearr_69734 = [null,null,null,null,null,null,null,null];
(statearr_69734[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__);

(statearr_69734[(1)] = (1));

return statearr_69734;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1 = (function (state_69727){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_69727);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69735){var ex__2730__auto__ = e69735;
var statearr_69736_69746 = state_69727;
(statearr_69736_69746[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_69727[(4)]))){
var statearr_69737_69747 = state_69727;
(statearr_69737_69747[(1)] = cljs.core.first((state_69727[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69748 = state_69727;
state_69727 = G__69748;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = function(state_69727){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1.call(this,state_69727);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69738 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_69738[(6)] = c__2749__auto__);

return statearr_69738;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__69749 = db;
var map__69749__$1 = cljs.core.__destructure_map(map__69749);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69749__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69749__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69749__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var listen_id = cljs.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__5133__auto__ = syncTimeout;
var y__5134__auto__ = (120000);
return ((x__5133__auto__ < y__5134__auto__) ? x__5133__auto__ : y__5134__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__2749__auto___69825 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69799){
var state_val_69800 = (state_69799[(1)]);
if((state_val_69800 === (7))){
var inst_69765 = (state_69799[(7)]);
var inst_69776 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_69765,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_69799__$1 = state_69799;
if(inst_69776){
var statearr_69801_69826 = state_69799__$1;
(statearr_69801_69826[(1)] = (9));

} else {
var statearr_69802_69827 = state_69799__$1;
(statearr_69802_69827[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69800 === (1))){
var inst_69750 = (state_69799[(8)]);
var inst_69758 = (state_69799[(9)]);
var inst_69750__$1 = cljs.core.async.timeout(timeout);
var inst_69758__$1 = res_port;
var inst_69759 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69760 = [inst_69750__$1,inst_69758__$1];
var inst_69761 = (new cljs.core.PersistentVector(null,2,(5),inst_69759,inst_69760,null));
var state_69799__$1 = (function (){var statearr_69803 = state_69799;
(statearr_69803[(8)] = inst_69750__$1);

(statearr_69803[(9)] = inst_69758__$1);

return statearr_69803;
})();
return cljs.core.async.ioc_alts_BANG_(state_69799__$1,(2),inst_69761);
} else {
if((state_val_69800 === (4))){
var inst_69758 = (state_69799[(9)]);
var inst_69765 = (state_69799[(7)]);
var inst_69769 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_69765,inst_69758);
var state_69799__$1 = state_69799;
if(inst_69769){
var statearr_69804_69828 = state_69799__$1;
(statearr_69804_69828[(1)] = (6));

} else {
var statearr_69805_69829 = state_69799__$1;
(statearr_69805_69829[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69800 === (13))){
var inst_69784 = (state_69799[(10)]);
var inst_69795 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_69784);
var state_69799__$1 = state_69799;
var statearr_69806_69830 = state_69799__$1;
(statearr_69806_69830[(2)] = inst_69795);

(statearr_69806_69830[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69800 === (6))){
var inst_69763 = (state_69799[(11)]);
var inst_69774 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69763,(0),null);
var state_69799__$1 = state_69799;
var statearr_69807_69831 = state_69799__$1;
(statearr_69807_69831[(2)] = inst_69774);

(statearr_69807_69831[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69800 === (3))){
var state_69799__$1 = state_69799;
var statearr_69808_69832 = state_69799__$1;
(statearr_69808_69832[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_69808_69832[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69800 === (12))){
var inst_69788 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_69789 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69790 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_69791 = cljs.core.PersistentHashMap.fromArrays(inst_69789,inst_69790);
var inst_69792 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_69788,inst_69791);
var inst_69793 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_69792);
var state_69799__$1 = state_69799;
var statearr_69809_69833 = state_69799__$1;
(statearr_69809_69833[(2)] = inst_69793);

(statearr_69809_69833[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69800 === (2))){
var inst_69750 = (state_69799[(8)]);
var inst_69765 = (state_69799[(7)]);
var inst_69763 = (state_69799[(11)]);
var inst_69763__$1 = (state_69799[(2)]);
var inst_69764 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69763__$1,(0),null);
var inst_69765__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69763__$1,(1),null);
var inst_69766 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_69765__$1,inst_69750);
var state_69799__$1 = (function (){var statearr_69810 = state_69799;
(statearr_69810[(7)] = inst_69765__$1);

(statearr_69810[(11)] = inst_69763__$1);

(statearr_69810[(12)] = inst_69764);

return statearr_69810;
})();
if(inst_69766){
var statearr_69811_69834 = state_69799__$1;
(statearr_69811_69834[(1)] = (3));

} else {
var statearr_69812_69835 = state_69799__$1;
(statearr_69812_69835[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69800 === (11))){
var inst_69780 = (state_69799[(2)]);
var state_69799__$1 = state_69799;
var statearr_69813_69836 = state_69799__$1;
(statearr_69813_69836[(2)] = inst_69780);

(statearr_69813_69836[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69800 === (9))){
var inst_69764 = (state_69799[(12)]);
var state_69799__$1 = state_69799;
var statearr_69814_69837 = state_69799__$1;
(statearr_69814_69837[(2)] = inst_69764);

(statearr_69814_69837[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69800 === (5))){
var inst_69784 = (state_69799[(10)]);
var inst_69784__$1 = (state_69799[(2)]);
var inst_69785 = fluree.db.connection.remove_listener(conn,network,ledger_id,listen_id);
var inst_69786 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_69784__$1);
var state_69799__$1 = (function (){var statearr_69815 = state_69799;
(statearr_69815[(13)] = inst_69785);

(statearr_69815[(10)] = inst_69784__$1);

return statearr_69815;
})();
if(inst_69786){
var statearr_69816_69838 = state_69799__$1;
(statearr_69816_69838[(1)] = (12));

} else {
var statearr_69817_69839 = state_69799__$1;
(statearr_69817_69839[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69800 === (14))){
var inst_69797 = (state_69799[(2)]);
var state_69799__$1 = state_69799;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69799__$1,inst_69797);
} else {
if((state_val_69800 === (10))){
var state_69799__$1 = state_69799;
var statearr_69818_69840 = state_69799__$1;
(statearr_69818_69840[(2)] = null);

(statearr_69818_69840[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69800 === (8))){
var inst_69782 = (state_69799[(2)]);
var state_69799__$1 = state_69799;
var statearr_69819_69841 = state_69799__$1;
(statearr_69819_69841[(2)] = inst_69782);

(statearr_69819_69841[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0 = (function (){
var statearr_69820 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69820[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__);

(statearr_69820[(1)] = (1));

return statearr_69820;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1 = (function (state_69799){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_69799);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69821){var ex__2730__auto__ = e69821;
var statearr_69822_69842 = state_69799;
(statearr_69822_69842[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_69799[(4)]))){
var statearr_69823_69843 = state_69799;
(statearr_69823_69843[(1)] = cljs.core.first((state_69799[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69844 = state_69799;
state_69799 = G__69844;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__ = function(state_69799){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1.call(this,state_69799);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69824 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_69824[(6)] = c__2749__auto___69825);

return statearr_69824;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__69846 = arguments.length;
switch (G__69846) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__69847){
var map__69848 = p__69847;
var map__69848__$1 = cljs.core.__destructure_map(map__69848);
var opts = map__69848__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69848__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69848__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69848__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69848__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69848__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2749__auto___69937 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69899){
var state_val_69900 = (state_69899[(1)]);
if((state_val_69900 === (7))){
var inst_69861 = (state_69899[(7)]);
var inst_69863 = fluree.db.api.ledger.syncTo_db(inst_69861,syncTo,syncTimeout);
var state_69899__$1 = state_69899;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69899__$1,(10),inst_69863);
} else {
if((state_val_69900 === (20))){
var inst_69885 = (state_69899[(8)]);
var state_69899__$1 = state_69899;
var statearr_69901_69938 = state_69899__$1;
(statearr_69901_69938[(2)] = inst_69885);

(statearr_69901_69938[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69900 === (1))){
var state_69899__$1 = state_69899;
var statearr_69902_69939 = state_69899__$1;
(statearr_69902_69939[(2)] = null);

(statearr_69902_69939[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69900 === (4))){
var inst_69849 = (state_69899[(2)]);
var inst_69850 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_69849);
var inst_69851 = cljs.core.async.close_BANG_(pc);
var state_69899__$1 = (function (){var statearr_69903 = state_69899;
(statearr_69903[(9)] = inst_69850);

return statearr_69903;
})();
var statearr_69904_69940 = state_69899__$1;
(statearr_69904_69940[(2)] = inst_69851);

(statearr_69904_69940[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69900 === (15))){
var inst_69877 = (state_69899[(10)]);
var inst_69879 = fluree.db.api.ledger.add_db_permissions(inst_69877,auth,roles);
var state_69899__$1 = state_69899;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69899__$1,(18),inst_69879);
} else {
if((state_val_69900 === (21))){
var inst_69893 = (state_69899[(2)]);
var inst_69894 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_69893);
var _ = (function (){var statearr_69905 = state_69899;
(statearr_69905[(4)] = cljs.core.rest((state_69899[(4)])));

return statearr_69905;
})();
var state_69899__$1 = state_69899;
var statearr_69906_69941 = state_69899__$1;
(statearr_69906_69941[(2)] = inst_69894);

(statearr_69906_69941[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69900 === (13))){
var inst_69877 = (state_69899[(2)]);
var state_69899__$1 = (function (){var statearr_69907 = state_69899;
(statearr_69907[(10)] = inst_69877);

return statearr_69907;
})();
if(cljs.core.truth_(roles)){
var statearr_69908_69942 = state_69899__$1;
(statearr_69908_69942[(1)] = (15));

} else {
var statearr_69909_69943 = state_69899__$1;
(statearr_69909_69943[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69900 === (22))){
var inst_69889 = (state_69899[(2)]);
var inst_69890 = fluree.db.util.async.throw_err(inst_69889);
var state_69899__$1 = state_69899;
var statearr_69910_69944 = state_69899__$1;
(statearr_69910_69944[(2)] = inst_69890);

(statearr_69910_69944[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69900 === (6))){
var inst_69860 = (state_69899[(2)]);
var inst_69861 = fluree.db.util.async.throw_err(inst_69860);
var state_69899__$1 = (function (){var statearr_69911 = state_69899;
(statearr_69911[(7)] = inst_69861);

return statearr_69911;
})();
if(cljs.core.truth_(syncTo)){
var statearr_69912_69945 = state_69899__$1;
(statearr_69912_69945[(1)] = (7));

} else {
var statearr_69913_69946 = state_69899__$1;
(statearr_69913_69946[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69900 === (17))){
var inst_69885 = (state_69899[(2)]);
var state_69899__$1 = (function (){var statearr_69914 = state_69899;
(statearr_69914[(8)] = inst_69885);

return statearr_69914;
})();
if(cljs.core.truth_(auth)){
var statearr_69915_69947 = state_69899__$1;
(statearr_69915_69947[(1)] = (19));

} else {
var statearr_69916_69948 = state_69899__$1;
(statearr_69916_69948[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69900 === (3))){
var inst_69897 = (state_69899[(2)]);
var state_69899__$1 = state_69899;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69899__$1,inst_69897);
} else {
if((state_val_69900 === (12))){
var inst_69869 = (state_69899[(11)]);
var state_69899__$1 = state_69899;
var statearr_69917_69949 = state_69899__$1;
(statearr_69917_69949[(2)] = inst_69869);

(statearr_69917_69949[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69900 === (2))){
var _ = (function (){var statearr_69918 = state_69899;
(statearr_69918[(4)] = cljs.core.cons((5),(state_69899[(4)])));

return statearr_69918;
})();
var inst_69858 = fluree.db.session.db(conn,ledger,opts_SINGLEQUOTE_);
var state_69899__$1 = state_69899;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69899__$1,(6),inst_69858);
} else {
if((state_val_69900 === (19))){
var inst_69885 = (state_69899[(8)]);
var inst_69887 = fluree.db.api.ledger.add_db_permissions(inst_69885,auth,roles);
var state_69899__$1 = state_69899;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69899__$1,(22),inst_69887);
} else {
if((state_val_69900 === (11))){
var inst_69869 = (state_69899[(11)]);
var inst_69871 = fluree.db.time_travel.as_of_block(inst_69869,block);
var state_69899__$1 = state_69899;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69899__$1,(14),inst_69871);
} else {
if((state_val_69900 === (9))){
var inst_69869 = (state_69899[(2)]);
var state_69899__$1 = (function (){var statearr_69920 = state_69899;
(statearr_69920[(11)] = inst_69869);

return statearr_69920;
})();
if(cljs.core.truth_(block)){
var statearr_69921_69950 = state_69899__$1;
(statearr_69921_69950[(1)] = (11));

} else {
var statearr_69922_69951 = state_69899__$1;
(statearr_69922_69951[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69900 === (5))){
var _ = (function (){var statearr_69923 = state_69899;
(statearr_69923[(4)] = cljs.core.rest((state_69899[(4)])));

return statearr_69923;
})();
var state_69899__$1 = state_69899;
var ex69919 = (state_69899__$1[(2)]);
var statearr_69924_69952 = state_69899__$1;
(statearr_69924_69952[(5)] = ex69919);


var statearr_69925_69953 = state_69899__$1;
(statearr_69925_69953[(1)] = (4));

(statearr_69925_69953[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69900 === (14))){
var inst_69873 = (state_69899[(2)]);
var inst_69874 = fluree.db.util.async.throw_err(inst_69873);
var state_69899__$1 = state_69899;
var statearr_69926_69954 = state_69899__$1;
(statearr_69926_69954[(2)] = inst_69874);

(statearr_69926_69954[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69900 === (16))){
var inst_69877 = (state_69899[(10)]);
var state_69899__$1 = state_69899;
var statearr_69927_69955 = state_69899__$1;
(statearr_69927_69955[(2)] = inst_69877);

(statearr_69927_69955[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69900 === (10))){
var inst_69865 = (state_69899[(2)]);
var inst_69866 = fluree.db.util.async.throw_err(inst_69865);
var state_69899__$1 = state_69899;
var statearr_69928_69956 = state_69899__$1;
(statearr_69928_69956[(2)] = inst_69866);

(statearr_69928_69956[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69900 === (18))){
var inst_69881 = (state_69899[(2)]);
var inst_69882 = fluree.db.util.async.throw_err(inst_69881);
var state_69899__$1 = state_69899;
var statearr_69929_69957 = state_69899__$1;
(statearr_69929_69957[(2)] = inst_69882);

(statearr_69929_69957[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69900 === (8))){
var inst_69861 = (state_69899[(7)]);
var state_69899__$1 = state_69899;
var statearr_69930_69958 = state_69899__$1;
(statearr_69930_69958[(2)] = inst_69861);

(statearr_69930_69958[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2727__auto__ = null;
var fluree$db$api$ledger$state_machine__2727__auto____0 = (function (){
var statearr_69931 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69931[(0)] = fluree$db$api$ledger$state_machine__2727__auto__);

(statearr_69931[(1)] = (1));

return statearr_69931;
});
var fluree$db$api$ledger$state_machine__2727__auto____1 = (function (state_69899){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_69899);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69932){var ex__2730__auto__ = e69932;
var statearr_69933_69959 = state_69899;
(statearr_69933_69959[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_69899[(4)]))){
var statearr_69934_69960 = state_69899;
(statearr_69934_69960[(1)] = cljs.core.first((state_69899[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69961 = state_69899;
state_69899 = G__69961;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2727__auto__ = function(state_69899){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2727__auto____1.call(this,state_69899);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2727__auto____0;
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2727__auto____1;
return fluree$db$api$ledger$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69935 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_69935[(6)] = c__2749__auto___69937);

return statearr_69935;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

