// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.core');
goog.require('cljs.core');
goog.require('sci.core');
goog.require('fluree.db.dbfunctions.fns');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
/**
 * Returns true if the arg is a string containing a transaction function.
 */
fluree.db.dbfunctions.core.tx_fn_QMARK_ = (function fluree$db$dbfunctions$core$tx_fn_QMARK_(v){
var and__5043__auto__ = typeof v === 'string';
if(and__5043__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,v);
} else {
return and__5043__auto__;
}
});
fluree.db.dbfunctions.core.allowed_symbols = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [new cljs.core.Symbol(null,"?pO","?pO",1714537515,null),null,new cljs.core.Symbol(null,"?auth_id","?auth_id",612691741,null),null,new cljs.core.Symbol(null,"sid","sid",-839419355,null),null,new cljs.core.Symbol(null,"?user_id","?user_id",-101968770,null),null,new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),null,new cljs.core.Symbol(null,"?a","?a",1314302913,null),null,new cljs.core.Symbol(null,"?db","?db",1493359450,null),null,new cljs.core.Symbol(null,"?s","?s",456183954,null),null,new cljs.core.Symbol(null,"?o","?o",-1814741084,null),null], null), null);
/**
 * Copies local fns ns public vars into SCI
 */
fluree.db.dbfunctions.core.load_local_fns_ns = (function fluree$db$dbfunctions$core$load_local_fns_ns(){
var ns_public_vars = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentVector.fromArray([new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("uuid"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.uuid;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","uuid","fluree.db.dbfunctions.fns/uuid",1199900311,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,803,null,803,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.uuid)?fluree.db.dbfunctions.fns.uuid.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("max-pred-val"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.max_pred_val;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","max-pred-val","fluree.db.dbfunctions.fns/max-pred-val",884898813,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"max-pred-val","max-pred-val",-1898501472,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",19,1,546,null,546,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null)),"Finds the maximum predicate value.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max_pred_val)?fluree.db.dbfunctions.fns.max_pred_val.cljs$lang$test:null),"10, plus fuel cost."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("contains?"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.contains_QMARK_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","contains?","fluree.db.dbfunctions.fns/contains?",979635755,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",16,1,372,null,372,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),"Returns true if key is present.",(cljs.core.truth_(fluree.db.dbfunctions.fns.contains_QMARK_)?fluree.db.dbfunctions.fns.contains_QMARK_.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("subs"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.subs;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","subs","fluree.db.dbfunctions.fns/subs",815704759,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"subs","subs",1453849536,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,135,null,135,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(cljs.core.truth_(fluree.db.dbfunctions.fns.subs)?fluree.db.dbfunctions.fns.subs.cljs$lang$test:null),(30)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("ctx"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.ctx;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","ctx","fluree.db.dbfunctions.fns/ctx",570947084,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"ctx","ctx",1146921409,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,363,null,363,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"db","db",-1661185010,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.Symbol(null,"key-or-ks","key-or-ks",715926861,null)], null)),"Returns a value from the user's context if set. Provide the key or key sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.ctx)?fluree.db.dbfunctions.fns.ctx.cljs$lang$test:null),(1)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("query"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.query;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","query","fluree.db.dbfunctions.fns/query",2131906892,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"query","query",352022017,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,504,null,504,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),"Executes a query",(cljs.core.truth_(fluree.db.dbfunctions.fns.query)?fluree.db.dbfunctions.fns.query.cljs$lang$test:null),"Fuel required for query"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("flakes"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.flakes;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","flakes","fluree.db.dbfunctions.fns/flakes",2105901429,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"flakes","flakes",-676540030,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",13,1,775,null,775,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the flakes from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.flakes)?fluree.db.dbfunctions.fns.flakes.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("boolean"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.boolean$;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","boolean","fluree.db.dbfunctions.fns/boolean",831125140,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,1,684,null,684,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Coerce to boolean. Everything except false and nil is true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.boolean$)?fluree.db.dbfunctions.fns.boolean$.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("dec"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.dec;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","dec","fluree.db.dbfunctions.fns/dec",2016365502,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"dec","dec",-766002333,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,570,null,570,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),"Decrements any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.dec)?fluree.db.dbfunctions.fns.dec.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("<"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._LT_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","<","fluree.db.dbfunctions.fns/<",-518653073,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"<","<",993667236,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,426,null,426,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically increasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT_)?fluree.db.dbfunctions.fns._LT_.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("floor"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.floor;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","floor","fluree.db.dbfunctions.fns/floor",2077352177,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",12,1,825,null,825,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),"Takes the floor of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.floor)?fluree.db.dbfunctions.fns.floor.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("?o"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_o;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?o","fluree.db.dbfunctions.fns/?o",2112743665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?o","?o",-1814741084,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,1,303,null,303,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the object of an predicate from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_o)?fluree.db.dbfunctions.fns._QMARK_o.cljs$lang$test:null),(1)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("?sid"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_sid;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?sid","fluree.db.dbfunctions.fns/?sid",-1145594406,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?sid","?sid",-778261371,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,171,null,171,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current subject id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_sid)?fluree.db.dbfunctions.fns._QMARK_sid.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("objF"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.objF;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","objF","fluree.db.dbfunctions.fns/objF",1608830606,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"objF","objF",-104129083,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,763,null,763,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the summed object of all false flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objF)?fluree.db.dbfunctions.fns.objF.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("ceil"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.ceil;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","ceil","fluree.db.dbfunctions.fns/ceil",-1898210568,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,813,null,813,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),"Takes the ceiling of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.ceil)?fluree.db.dbfunctions.fns.ceil.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("<="),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._LT__EQ_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","<=","fluree.db.dbfunctions.fns/<=",-535009166,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"<=","<=",1244895369,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,439,null,439,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT__EQ_)?fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("*"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._STAR_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","*","fluree.db.dbfunctions.fns/*",1333037714,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"*","*",345799209,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,619,null,619,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns product of all the numbers in the sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns._STAR_)?fluree.db.dbfunctions.fns._STAR_.cljs$lang$test:null),"9 + count of numbers in *"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("min"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.min;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","min","fluree.db.dbfunctions.fns/min",-1032470830,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"min","min",2085523049,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,491,null,491,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets min value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.min)?fluree.db.dbfunctions.fns.min.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("get"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.get;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","get","fluree.db.dbfunctions.fns/get",1827842903,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"get","get",-971253014,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,272,null,272,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cache","cache",403508473,null),new cljs.core.Symbol(null,"db","db",-1661185010,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null)),"Gets a value from an subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get)?fluree.db.dbfunctions.fns.get.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("?pO"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_pO;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pO","fluree.db.dbfunctions.fns/?pO",-2142759792,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?pO","?pO",1714537515,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,315,null,315,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the most recent object of an predicate, as of the previous block",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pO)?fluree.db.dbfunctions.fns._QMARK_pO.cljs$lang$test:null),"10 plus fuel cost"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("empty?"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.empty_QMARK_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","empty?","fluree.db.dbfunctions.fns/empty?",-487925850,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"empty?","empty?",76408555,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",13,1,111,null,111,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),"True if empty or #{nil}, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.empty_QMARK_)?fluree.db.dbfunctions.fns.empty_QMARK_.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("quot"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.quot;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","quot","fluree.db.dbfunctions.fns/quot",1725032899,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"quot","quot",-1125214196,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,645,null,645,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),"Quot[ient] of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.quot)?fluree.db.dbfunctions.fns.quot.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("now"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.now;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","now","fluree.db.dbfunctions.fns/now",1494134809,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"now","now",-9994004,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,583,null,583,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Returns current epoch milliseconds on the executing machine.",(cljs.core.truth_(fluree.db.dbfunctions.fns.now)?fluree.db.dbfunctions.fns.now.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("not="),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.not_EQ_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","not=","fluree.db.dbfunctions.fns/not=",-1186054057,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"not=","not=",1466536204,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,465,null,465,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if two (or more) values are not equal.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not_EQ_)?fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("if-else"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.if_else;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","if-else","fluree.db.dbfunctions.fns/if-else",-1024242186,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"if-else","if-else",-1675068243,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,1,75,null,75,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null)),"Evaluates test.",(cljs.core.truth_(fluree.db.dbfunctions.fns.if_else)?fluree.db.dbfunctions.fns.if_else.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("rand"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.rand;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","rand","fluree.db.dbfunctions.fns/rand",805823682,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,787,null,787,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.rand)?fluree.db.dbfunctions.fns.rand.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(">"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._GT_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns",">","fluree.db.dbfunctions.fns/>",-23637352,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,">",">",1085014381,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,413,null,413,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT_)?fluree.db.dbfunctions.fns._GT_.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("mod"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.mod;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","mod","fluree.db.dbfunctions.fns/mod",-198597254,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"mod","mod",1510044207,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,658,null,658,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),"Modulus of num and div. Truncates toward negative infinity.",(cljs.core.truth_(fluree.db.dbfunctions.fns.mod)?fluree.db.dbfunctions.fns.mod.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("lower-case"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.lower_case;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","lower-case","fluree.db.dbfunctions.fns/lower-case",-442259,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"lower-case","lower-case",1428172944,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",17,1,147,null,147,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),"Makes string lower case",(cljs.core.truth_(fluree.db.dbfunctions.fns.lower_case)?fluree.db.dbfunctions.fns.lower_case.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("-"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","-","fluree.db.dbfunctions.fns/-",-1982229401,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"-","-",-471816912,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,606,null,606,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns difference of all the numbers in the sequence with the first number as the minuend.",(cljs.core.truth_(fluree.db.dbfunctions.fns._)?fluree.db.dbfunctions.fns._.cljs$lang$test:null),"9 + count of numbers in -"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("hash-set"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.hash_set;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","hash-set","fluree.db.dbfunctions.fns/hash-set",-1047040869,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"hash-set","hash-set",-1145168432,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,386,null,386,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns a hash-set of values",(cljs.core.truth_(fluree.db.dbfunctions.fns.hash_set)?fluree.db.dbfunctions.fns.hash_set.cljs$lang$test:null),"9 + count of items in hash-set"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("or"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.or;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","or","fluree.db.dbfunctions.fns/or",-919667013,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"or","or",1876275696,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,245,null,245,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if any in the sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.or)?fluree.db.dbfunctions.fns.or.cljs$lang$test:null),"Count of objects in or"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("valid-email?"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.valid_email_QMARK_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","valid-email?","fluree.db.dbfunctions.fns/valid-email?",110711142,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"valid-email?","valid-email?",-1587437519,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",19,1,709,null,709,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null)),"Determines whether an email is valid, based on its pattern",(cljs.core.truth_(fluree.db.dbfunctions.fns.valid_email_QMARK_)?fluree.db.dbfunctions.fns.valid_email_QMARK_.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("?s"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_s;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?s","fluree.db.dbfunctions.fns/?s",-1324621735,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?s","?s",456183954,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,203,null,203,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_s)?fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("rem"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.rem;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","rem","fluree.db.dbfunctions.fns/rem",1237147007,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"rem","rem",664046770,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,671,null,671,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),"Remainder of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.rem)?fluree.db.dbfunctions.fns.rem.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("nth"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.nth;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","nth","fluree.db.dbfunctions.fns/nth",-246664273,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"nth","nth",1529209554,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,60,null,60,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),"Returns the nth item in a collection",(cljs.core.truth_(fluree.db.dbfunctions.fns.nth)?fluree.db.dbfunctions.fns.nth.cljs$lang$test:null),"9 + count of objects in collection"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("nil?"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.nil_QMARK_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","nil?","fluree.db.dbfunctions.fns/nil?",-1144188177,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,88,null,88,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),"True if nil, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.nil_QMARK_)?fluree.db.dbfunctions.fns.nil_QMARK_.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("cas"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.cas;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","cas","fluree.db.dbfunctions.fns/cas",-1666886306,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"cas","cas",1188988307,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,837,null,837,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null)),"Does a compare and set/swap operation as a transaction function.",(cljs.core.truth_(fluree.db.dbfunctions.fns.cas)?fluree.db.dbfunctions.fns.cas.cljs$lang$test:null),(20)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("re-find"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.re_find;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","re-find","fluree.db.dbfunctions.fns/re-find",-1361091826,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"re-find","re-find",1143444147,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,1,696,null,696,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null)),"Execute a re-find operation of regex pattern on provided string.",(cljs.core.truth_(fluree.db.dbfunctions.fns.re_find)?fluree.db.dbfunctions.fns.re_find.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("not"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.not;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","not","fluree.db.dbfunctions.fns/not",-1684442274,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"not","not",1044554643,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,100,null,100,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),"Takes a boolean, true returns false, false returns true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not)?fluree.db.dbfunctions.fns.not.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("/"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._SLASH_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","/","fluree.db.dbfunctions.fns//",1439768862,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"/","/",-1371932971,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,632,null,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",(cljs.core.truth_(fluree.db.dbfunctions.fns._SLASH_)?fluree.db.dbfunctions.fns._SLASH_.cljs$lang$test:null),"9 + count of numbers in /"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(">="),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._GT__EQ_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns",">=","fluree.db.dbfunctions.fns/>=",-1771718525,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,">=",">=",1016916022,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,452,null,452,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT__EQ_)?fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("upper-case"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.upper_case;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","upper-case","fluree.db.dbfunctions.fns/upper-case",-210929244,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"upper-case","upper-case",1427515769,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",17,1,159,null,159,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),"Makes string upper-case",(cljs.core.truth_(fluree.db.dbfunctions.fns.upper_case)?fluree.db.dbfunctions.fns.upper_case.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("inc"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.inc;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","inc","fluree.db.dbfunctions.fns/inc",1299152788,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"inc","inc",324505433,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,558,null,558,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),"Increments any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.inc)?fluree.db.dbfunctions.fns.inc.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("+"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._PLUS_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","+","fluree.db.dbfunctions.fns/+",1979608855,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"+","+",-740910886,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,593,null,593,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns sum of each argument.",(cljs.core.truth_(fluree.db.dbfunctions.fns._PLUS_)?fluree.db.dbfunctions.fns._PLUS_.cljs$lang$test:null),"9 + count of numbers in +"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("str"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.str;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","str","fluree.db.dbfunctions.fns/str",215086055,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,123,null,123,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Concatenates all in sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.str)?fluree.db.dbfunctions.fns.str.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("objT"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.objT;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","objT","fluree.db.dbfunctions.fns/objT",308919174,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"objT","objT",1212205659,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,751,null,751,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the summed object of all true flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objT)?fluree.db.dbfunctions.fns.objT.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("max"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.max;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","max","fluree.db.dbfunctions.fns/max",-821447668,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"max","max",1701898075,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,478,null,478,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets max value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max)?fluree.db.dbfunctions.fns.max.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("=="),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._EQ__EQ_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","==","fluree.db.dbfunctions.fns/==",1478685734,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"==","==",-234118149,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,400,null,400,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("count"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.count;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","count","fluree.db.dbfunctions.fns/count",1267596361,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"count","count",-514511684,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",12,1,258,null,258,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps",(cljs.core.truth_(fluree.db.dbfunctions.fns.count)?fluree.db.dbfunctions.fns.count.cljs$lang$test:null),"9 + count of objects in count"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("get-all"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.get_all;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-all","fluree.db.dbfunctions.fns/get-all",1682787369,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"get-all","get-all",-567116420,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,1,328,null,328,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),"Used to get-all values in a nested result set, or also can follow a subject down the provided path and return a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path + query costs"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("?p"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_p;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?p","fluree.db.dbfunctions.fns/?p",1090611913,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?p","?p",-10896580,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,216,null,216,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current predicate predicates",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_p)?fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("?auth_id"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_auth_id;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?auth_id","fluree.db.dbfunctions.fns/?auth_id",-1900200218,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?auth_id","?auth_id",612691741,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",15,1,739,null,739,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current auth _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_auth_id)?fluree.db.dbfunctions.fns._QMARK_auth_id.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("extract"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.extract;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","extract","fluree.db.dbfunctions.fns/extract",-1458126328,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"macro","macro",-867863404),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"extract","extract",399446909,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",18,1,14,true,14,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null)),"Resolves a value if a channel.\n  Must be used inside of a go-block.",(cljs.core.truth_(fluree.db.dbfunctions.fns.extract)?fluree.db.dbfunctions.fns.extract.cljs$lang$test:null)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("?user_id"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_user_id;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?user_id","fluree.db.dbfunctions.fns/?user_id",599092011,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?user_id","?user_id",-101968770,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",15,1,721,null,721,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current user _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_user_id)?fluree.db.dbfunctions.fns._QMARK_user_id.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("relationship?"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.relationship_QMARK_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","relationship?","fluree.db.dbfunctions.fns/relationship?",-46706197,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"relationship?","relationship?",1461608766,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",20,1,531,null,531,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null)),"Determines whether there is a relationship between two subjects",(cljs.core.truth_(fluree.db.dbfunctions.fns.relationship_QMARK_)?fluree.db.dbfunctions.fns.relationship_QMARK_.cljs$lang$test:null),"10, plus fuel cost"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("and"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.and;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","and","fluree.db.dbfunctions.fns/and",2113043921,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"and","and",668631710,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,232,null,232,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if all in a sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.and)?fluree.db.dbfunctions.fns.and.cljs$lang$test:null),"Count of objects in and"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("?pid"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_pid;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pid","fluree.db.dbfunctions.fns/?pid",-1962601142,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,190,null,190,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current predicate id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pid)?fluree.db.dbfunctions.fns._QMARK_pid.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("get-in"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.get_in;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-in","fluree.db.dbfunctions.fns/get-in",821000586,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",13,1,349,null,349,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),"Returns the value of a nested structure",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_in)?fluree.db.dbfunctions.fns.get_in.cljs$lang$test:null),"Length of path"]))], null)], true));
var _ = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["Loading ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(ns_public_vars))," local fns"].join('')], null));
var sci_ns = sci.core.create_ns.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ns_map,p__62930){
var vec__62931 = p__62930;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62931,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62931,(1),null);
var m = cljs.core.meta(var$);
var no_doc = new cljs.core.Keyword(null,"no-doc","no-doc",1559921891).cljs$core$IFn$_invoke$arity$1(m);
var doc = new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m);
var arglists = new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(no_doc)){
return ns_map;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ns_map,var_name,sci.core.new_var.cljs$core$IFn$_invoke$arity$3(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var_name),cljs.core.deref(var$),(function (){var G__62934 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ns","ns",441598760),sci_ns,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m)], null);
var G__62934__$1 = (cljs.core.truth_(new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__62934,new cljs.core.Keyword(null,"macro","macro",-867863404),true):G__62934);
var G__62934__$2 = (cljs.core.truth_(doc)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__62934__$1,new cljs.core.Keyword(null,"doc","doc",1913296891),doc):G__62934__$1);
if(cljs.core.truth_(arglists)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__62934__$2,new cljs.core.Keyword(null,"arglists","arglists",1661989754),arglists);
} else {
return G__62934__$2;
}
})()));
}
}),cljs.core.PersistentArrayMap.EMPTY,ns_public_vars);
});
fluree.db.dbfunctions.core.sci_ctx = (new cljs.core.Delay((function (){
var cfg = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),fluree.db.dbfunctions.core.load_local_fns_ns()], null)], null);
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["SCI config:",cfg], null));

return sci.core.init(cfg);
}),null));
fluree.db.dbfunctions.core.parse_string = (function fluree$db$dbfunctions$core$parse_string(s){
return sci.core.parse_string(cljs.core.deref(fluree.db.dbfunctions.core.sci_ctx),s);
});
fluree.db.dbfunctions.core.eval_string = (function fluree$db$dbfunctions$core$eval_string(s){
return sci.core.eval_string_STAR_(cljs.core.deref(fluree.db.dbfunctions.core.sci_ctx),s);
});
fluree.db.dbfunctions.core.eval_form = (function fluree$db$dbfunctions$core$eval_form(f){
return sci.core.eval_form(cljs.core.deref(fluree.db.dbfunctions.core.sci_ctx),f);
});
/**
 * Given a collection of function strings, returns a combined function using
 *   the and function.
 */
fluree.db.dbfunctions.core.combine_fns = (function fluree$db$dbfunctions$core$combine_fns(fn_str_coll){
if((cljs.core.count(fn_str_coll) > (1))){
return ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",fn_str_coll),")"].join('');
} else {
return cljs.core.first(fn_str_coll);
}
});
/**
 * Tries to resolve a local pre-defined fn with fn-name. Returns a fn-map if
 *   found, nil otherwise.
 */
fluree.db.dbfunctions.core.find_local_fn = (function fluree$db$dbfunctions$core$find_local_fn(fn_name){
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Looking for local fn:",fn_name], null));

var local_fns_ns = new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null);
var sci_vars = fluree.db.dbfunctions.core.eval_string(["(ns-publics '",cljs.core.str.cljs$core$IFn$_invoke$arity$1(local_fns_ns),")"].join(''));
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["SCI vars:",sci_vars], null));

if(cljs.core.truth_((function (){var G__62937 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(fn_name);
var fexpr__62936 = cljs.core.set(cljs.core.keys(sci_vars));
return (fexpr__62936.cljs$core$IFn$_invoke$arity$1 ? fexpr__62936.cljs$core$IFn$_invoke$arity$1(G__62937) : fexpr__62936.call(null,G__62937));
})())){
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Found local fn:",fn_name], null));

var fn_var = cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(local_fns_ns),cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_name));
var map__62938 = fluree.db.dbfunctions.core.eval_string(["(meta #'",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_var),")"].join(''));
var map__62938__$1 = cljs.core.__destructure_map(map__62938);
var sci_fn_meta = map__62938__$1;
var arglists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62938__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62938__$1,new cljs.core.Keyword("fdb","spec","fdb/spec",346638389));
if(cljs.core.truth_(sci_fn_meta)){
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["SCI fn metadata:",sci_fn_meta], null));

var first_arglist = cljs.core.first(arglists);
var args_set = cljs.core.set(first_arglist);
var var_args_QMARK_ = cljs.core.boolean$((function (){var G__62939 = new cljs.core.Symbol(null,"&","&",-2144855648,null);
return (args_set.cljs$core$IFn$_invoke$arity$1 ? args_set.cljs$core$IFn$_invoke$arity$1(G__62939) : args_set.call(null,G__62939));
})());
var arity = ((var_args_QMARK_)?null:cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__62935_SHARP_){
return (cljs.core.count(p1__62935_SHARP_) - (1));
}),arglists)));
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"f","f",-1597136552),fn_var,new cljs.core.Keyword(null,"params","params",710516235),arglists,new cljs.core.Keyword(null,"arity","arity",-1808556135),arity,new cljs.core.Keyword(null,"var-args?","var-args?",-1630678710),var_args_QMARK_,new cljs.core.Keyword(null,"spec","spec",347520401),spec], null);
} else {
return null;
}
} else {
return null;
}
});
fluree.db.dbfunctions.core.find_db_fn = (function fluree$db$dbfunctions$core$find_db_fn(var_args){
var G__62941 = arguments.length;
switch (G__62941) {
case 2:
return fluree.db.dbfunctions.core.find_db_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.find_db_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.find_db_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,fn_name){
return fluree.db.dbfunctions.core.find_db_fn.cljs$core$IFn$_invoke$arity$3(db,fn_name,null);
}));

(fluree.db.dbfunctions.core.find_db_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_name,fn_type){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63032){
var state_val_63033 = (state_63032[(1)]);
if((state_val_63033 === (7))){
var inst_62968 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fn_name], 0));
var inst_62969 = ["Unknown function: ",inst_62968].join('');
var inst_62970 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62971 = [(400),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)];
var inst_62972 = cljs.core.PersistentHashMap.fromArrays(inst_62970,inst_62971);
var inst_62973 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_62969,inst_62972);
var inst_62974 = (function(){throw inst_62973})();
var state_63032__$1 = state_63032;
var statearr_63034_63067 = state_63032__$1;
(statearr_63034_63067[(2)] = inst_62974);

(statearr_63034_63067[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63033 === (1))){
var state_63032__$1 = state_63032;
var statearr_63035_63068 = state_63032__$1;
(statearr_63035_63068[(2)] = null);

(statearr_63035_63068[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63033 === (4))){
var inst_62942 = (state_63032[(2)]);
var state_63032__$1 = state_63032;
var statearr_63036_63069 = state_63032__$1;
(statearr_63036_63069[(2)] = inst_62942);

(statearr_63036_63069[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63033 === (15))){
var inst_62994 = (state_63032[(7)]);
var inst_62965 = (state_63032[(8)]);
var inst_62994__$1 = (state_63032[(2)]);
var inst_62995 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62996 = ["Parsed params:",inst_62994__$1];
var inst_62997 = (new cljs.core.PersistentVector(null,2,(5),inst_62995,inst_62996,null));
var inst_62998 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_62997);
var inst_62999 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62965,"_fn/code");
var inst_63000 = fluree.db.dbfunctions.core.parse_string(inst_62999);
var inst_63001 = (fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$4(db,inst_63000,fn_type,inst_62994__$1) : fluree.db.dbfunctions.core.validate_form.call(null,db,inst_63000,fn_type,inst_62994__$1));
var state_63032__$1 = (function (){var statearr_63037 = state_63032;
(statearr_63037[(7)] = inst_62994__$1);

(statearr_63037[(9)] = inst_62998);

return statearr_63037;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63032__$1,(16),inst_63001);
} else {
if((state_val_63033 === (13))){
var state_63032__$1 = state_63032;
var statearr_63038_63070 = state_63032__$1;
(statearr_63038_63070[(2)] = null);

(statearr_63038_63070[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63033 === (6))){
var inst_62965 = (state_63032[(8)]);
var inst_62964 = (state_63032[(2)]);
var inst_62965__$1 = fluree.db.util.async.throw_err(inst_62964);
var inst_62966 = cljs.core.empty_QMARK_(inst_62965__$1);
var state_63032__$1 = (function (){var statearr_63039 = state_63032;
(statearr_63039[(8)] = inst_62965__$1);

return statearr_63039;
})();
if(inst_62966){
var statearr_63040_63071 = state_63032__$1;
(statearr_63040_63071[(1)] = (7));

} else {
var statearr_63041_63072 = state_63032__$1;
(statearr_63041_63072[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63033 === (3))){
var inst_63030 = (state_63032[(2)]);
var state_63032__$1 = state_63032;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63032__$1,inst_63030);
} else {
if((state_val_63033 === (12))){
var inst_62988 = (state_63032[(10)]);
var inst_62988__$1 = (state_63032[(2)]);
var inst_62989 = (inst_62988__$1 == null);
var state_63032__$1 = (function (){var statearr_63042 = state_63032;
(statearr_63042[(10)] = inst_62988__$1);

return statearr_63042;
})();
if(cljs.core.truth_(inst_62989)){
var statearr_63043_63073 = state_63032__$1;
(statearr_63043_63073[(1)] = (13));

} else {
var statearr_63044_63074 = state_63032__$1;
(statearr_63044_63074[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63033 === (2))){
var _ = (function (){var statearr_63045 = state_63032;
(statearr_63045[(4)] = cljs.core.cons((5),(state_63032[(4)])));

return statearr_63045;
})();
var inst_62948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62949 = ["Looking for custom db fn:",fn_name];
var inst_62950 = (new cljs.core.PersistentVector(null,2,(5),inst_62948,inst_62949,null));
var inst_62951 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_62950);
var inst_62952 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044)];
var inst_62953 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62954 = ["_fn/params","_fn/code","_fn/spec"];
var inst_62955 = (new cljs.core.PersistentVector(null,3,(5),inst_62953,inst_62954,null));
var inst_62956 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62957 = cljs.core.name(fn_name);
var inst_62958 = ["_fn/name",inst_62957];
var inst_62959 = (new cljs.core.PersistentVector(null,2,(5),inst_62956,inst_62958,null));
var inst_62960 = [inst_62955,inst_62959];
var inst_62961 = cljs.core.PersistentHashMap.fromArrays(inst_62952,inst_62960);
var inst_62962 = fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2(db,inst_62961);
var state_63032__$1 = (function (){var statearr_63046 = state_63032;
(statearr_63046[(11)] = inst_62951);

return statearr_63046;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63032__$1,(6),inst_62962);
} else {
if((state_val_63033 === (11))){
var inst_62965 = (state_63032[(8)]);
var inst_62986 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62965,"_fn/params");
var state_63032__$1 = state_63032;
var statearr_63048_63075 = state_63032__$1;
(statearr_63048_63075[(2)] = inst_62986);

(statearr_63048_63075[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63033 === (9))){
var inst_62965 = (state_63032[(8)]);
var inst_62977 = (state_63032[(2)]);
var inst_62978 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62979 = ["Custom db fn query results:",inst_62965];
var inst_62980 = (new cljs.core.PersistentVector(null,2,(5),inst_62978,inst_62979,null));
var inst_62981 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_62980);
var inst_62983 = (inst_62965 == null);
var state_63032__$1 = (function (){var statearr_63049 = state_63032;
(statearr_63049[(12)] = inst_62981);

(statearr_63049[(13)] = inst_62977);

return statearr_63049;
})();
if(cljs.core.truth_(inst_62983)){
var statearr_63050_63076 = state_63032__$1;
(statearr_63050_63076[(1)] = (10));

} else {
var statearr_63051_63077 = state_63032__$1;
(statearr_63051_63077[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63033 === (5))){
var _ = (function (){var statearr_63052 = state_63032;
(statearr_63052[(4)] = cljs.core.rest((state_63032[(4)])));

return statearr_63052;
})();
var state_63032__$1 = state_63032;
var ex63047 = (state_63032__$1[(2)]);
var statearr_63053_63078 = state_63032__$1;
(statearr_63053_63078[(5)] = ex63047);


if((ex63047 instanceof Error)){
var statearr_63054_63079 = state_63032__$1;
(statearr_63054_63079[(1)] = (4));

(statearr_63054_63079[(5)] = null);

} else {
throw ex63047;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63033 === (14))){
var inst_62988 = (state_63032[(10)]);
var inst_62992 = fluree.db.dbfunctions.core.parse_string(inst_62988);
var state_63032__$1 = state_63032;
var statearr_63055_63080 = state_63032__$1;
(statearr_63055_63080[(2)] = inst_62992);

(statearr_63055_63080[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63033 === (16))){
var inst_62994 = (state_63032[(7)]);
var inst_62965 = (state_63032[(8)]);
var inst_63003 = (state_63032[(2)]);
var inst_63004 = fluree.db.util.async.throw_err(inst_63003);
var inst_63005 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63006 = ["Validated code:",inst_63004];
var inst_63007 = (new cljs.core.PersistentVector(null,2,(5),inst_63005,inst_63006,null));
var inst_63008 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_63007);
var inst_63009 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62965,"_fn/spec");
var inst_63010 = cljs.core.PersistentVector.EMPTY;
var inst_63011 = new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null);
var inst_63012 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,inst_62994);
var inst_63013 = cljs.core.cons(inst_63011,inst_63012);
var inst_63014 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_63010,inst_63013);
var inst_63015 = ["(fn ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63014)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63004),")"].join('');
var inst_63016 = fluree.db.dbfunctions.core.parse_string(inst_63015);
var inst_63017 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63018 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63016], 0));
var inst_63019 = ["Found custom db fn:",inst_63018];
var inst_63020 = (new cljs.core.PersistentVector(null,2,(5),inst_63017,inst_63019,null));
var inst_63021 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_63020);
var inst_63022 = [new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"arity","arity",-1808556135),new cljs.core.Keyword(null,"var-args?","var-args?",-1630678710),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"code","code",1586293142)];
var inst_63023 = cljs.core.count(inst_62994);
var inst_63024 = [inst_63023];
var inst_63025 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_63024);
var inst_63026 = [inst_63016,inst_62994,inst_63025,false,inst_63009,null];
var inst_63027 = cljs.core.PersistentHashMap.fromArrays(inst_63022,inst_63026);
var _ = (function (){var statearr_63056 = state_63032;
(statearr_63056[(4)] = cljs.core.rest((state_63032[(4)])));

return statearr_63056;
})();
var state_63032__$1 = (function (){var statearr_63057 = state_63032;
(statearr_63057[(14)] = inst_63021);

(statearr_63057[(15)] = inst_63008);

return statearr_63057;
})();
var statearr_63058_63081 = state_63032__$1;
(statearr_63058_63081[(2)] = inst_63027);

(statearr_63058_63081[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63033 === (10))){
var state_63032__$1 = state_63032;
var statearr_63059_63082 = state_63032__$1;
(statearr_63059_63082[(2)] = null);

(statearr_63059_63082[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63033 === (8))){
var state_63032__$1 = state_63032;
var statearr_63060_63083 = state_63032__$1;
(statearr_63060_63083[(2)] = null);

(statearr_63060_63083[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__2727__auto____0 = (function (){
var statearr_63061 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63061[(0)] = fluree$db$dbfunctions$core$state_machine__2727__auto__);

(statearr_63061[(1)] = (1));

return statearr_63061;
});
var fluree$db$dbfunctions$core$state_machine__2727__auto____1 = (function (state_63032){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63032);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63062){var ex__2730__auto__ = e63062;
var statearr_63063_63084 = state_63032;
(statearr_63063_63084[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63032[(4)]))){
var statearr_63064_63085 = state_63032;
(statearr_63064_63085[(1)] = cljs.core.first((state_63032[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63086 = state_63032;
state_63032 = G__63086;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__2727__auto__ = function(state_63032){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__2727__auto____1.call(this,state_63032);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__2727__auto____0;
fluree$db$dbfunctions$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__2727__auto____1;
return fluree$db$dbfunctions$core$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63065 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63065[(6)] = c__2749__auto__);

return statearr_63065;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.core.find_db_fn.cljs$lang$maxFixedArity = 3);

/**
 * Is the symbol sym valid with the given form type & params?
 */
fluree.db.dbfunctions.core.valid_symbol_QMARK_ = (function fluree$db$dbfunctions$core$valid_symbol_QMARK_(type,params,sym){
var or__5045__auto__ = (fluree.db.dbfunctions.core.allowed_symbols.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.allowed_symbols.cljs$core$IFn$_invoke$arity$1(sym) : fluree.db.dbfunctions.core.allowed_symbols.call(null,sym));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = (function (){var fexpr__63087 = cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,params));
return (fexpr__63087.cljs$core$IFn$_invoke$arity$1 ? fexpr__63087.cljs$core$IFn$_invoke$arity$1(sym) : fexpr__63087.call(null,sym));
})();
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
}
}
});
/**
 * Resolves local or custom db-stored fn from fn-name string
 */
fluree.db.dbfunctions.core.resolve_fn = (function fluree$db$dbfunctions$core$resolve_fn(db,fn_name,type){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63107){
var state_val_63108 = (state_63107[(1)]);
if((state_val_63108 === (7))){
var inst_63097 = fluree.db.dbfunctions.core.find_db_fn.cljs$core$IFn$_invoke$arity$3(db,fn_name,type);
var state_63107__$1 = state_63107;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63107__$1,(9),inst_63097);
} else {
if((state_val_63108 === (1))){
var state_63107__$1 = state_63107;
var statearr_63109_63128 = state_63107__$1;
(statearr_63109_63128[(2)] = null);

(statearr_63109_63128[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63108 === (4))){
var inst_63088 = (state_63107[(2)]);
var state_63107__$1 = state_63107;
var statearr_63110_63129 = state_63107__$1;
(statearr_63110_63129[(2)] = inst_63088);

(statearr_63110_63129[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63108 === (6))){
var inst_63094 = (state_63107[(7)]);
var state_63107__$1 = state_63107;
var statearr_63111_63130 = state_63107__$1;
(statearr_63111_63130[(2)] = inst_63094);

(statearr_63111_63130[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63108 === (3))){
var inst_63105 = (state_63107[(2)]);
var state_63107__$1 = state_63107;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63107__$1,inst_63105);
} else {
if((state_val_63108 === (2))){
var inst_63094 = (state_63107[(7)]);
var _ = (function (){var statearr_63113 = state_63107;
(statearr_63113[(4)] = cljs.core.cons((5),(state_63107[(4)])));

return statearr_63113;
})();
var inst_63094__$1 = fluree.db.dbfunctions.core.find_local_fn(fn_name);
var state_63107__$1 = (function (){var statearr_63114 = state_63107;
(statearr_63114[(7)] = inst_63094__$1);

return statearr_63114;
})();
if(cljs.core.truth_(inst_63094__$1)){
var statearr_63115_63131 = state_63107__$1;
(statearr_63115_63131[(1)] = (6));

} else {
var statearr_63116_63132 = state_63107__$1;
(statearr_63116_63132[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63108 === (9))){
var inst_63099 = (state_63107[(2)]);
var inst_63100 = fluree.db.util.async.throw_err(inst_63099);
var state_63107__$1 = state_63107;
var statearr_63117_63133 = state_63107__$1;
(statearr_63117_63133[(2)] = inst_63100);

(statearr_63117_63133[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63108 === (5))){
var _ = (function (){var statearr_63118 = state_63107;
(statearr_63118[(4)] = cljs.core.rest((state_63107[(4)])));

return statearr_63118;
})();
var state_63107__$1 = state_63107;
var ex63112 = (state_63107__$1[(2)]);
var statearr_63119_63134 = state_63107__$1;
(statearr_63119_63134[(5)] = ex63112);


if((ex63112 instanceof Error)){
var statearr_63120_63135 = state_63107__$1;
(statearr_63120_63135[(1)] = (4));

(statearr_63120_63135[(5)] = null);

} else {
throw ex63112;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63108 === (8))){
var inst_63102 = (state_63107[(2)]);
var _ = (function (){var statearr_63121 = state_63107;
(statearr_63121[(4)] = cljs.core.rest((state_63107[(4)])));

return statearr_63121;
})();
var state_63107__$1 = state_63107;
var statearr_63122_63136 = state_63107__$1;
(statearr_63122_63136[(2)] = inst_63102);

(statearr_63122_63136[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2727__auto____0 = (function (){
var statearr_63123 = [null,null,null,null,null,null,null,null];
(statearr_63123[(0)] = fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2727__auto__);

(statearr_63123[(1)] = (1));

return statearr_63123;
});
var fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2727__auto____1 = (function (state_63107){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63107);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63124){var ex__2730__auto__ = e63124;
var statearr_63125_63137 = state_63107;
(statearr_63125_63137[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63107[(4)]))){
var statearr_63126_63138 = state_63107;
(statearr_63126_63138[(1)] = cljs.core.first((state_63107[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63139 = state_63107;
state_63107 = G__63139;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2727__auto__ = function(state_63107){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2727__auto____1.call(this,state_63107);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63127 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63127[(6)] = c__2749__auto__);

return statearr_63127;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.dbfunctions.core.validate_form = (function fluree$db$dbfunctions$core$validate_form(var_args){
var G__63142 = arguments.length;
switch (G__63142) {
case 2:
return fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$2 = (function (db,form){
return fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$4(db,form,null,null);
}));

(fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$3 = (function (db,form,type){
return fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$4(db,form,type,null);
}));

(fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$4 = (function (db,form,type,params){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63277){
var state_val_63278 = (state_63277[(1)]);
if((state_val_63278 === (7))){
var state_63277__$1 = state_63277;
var statearr_63279_63343 = state_63277__$1;
(statearr_63279_63343[(2)] = null);

(statearr_63279_63343[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (20))){
var inst_63254 = (state_63277[(2)]);
var state_63277__$1 = state_63277;
var statearr_63280_63344 = state_63277__$1;
(statearr_63280_63344[(2)] = inst_63254);

(statearr_63280_63344[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (27))){
var inst_63243 = (state_63277[(2)]);
var state_63277__$1 = state_63277;
var statearr_63281_63345 = state_63277__$1;
(statearr_63281_63345[(2)] = inst_63243);

(statearr_63281_63345[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (1))){
var state_63277__$1 = state_63277;
var statearr_63282_63346 = state_63277__$1;
(statearr_63282_63346[(2)] = null);

(statearr_63282_63346[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (24))){
var inst_63213 = (state_63277[(2)]);
var inst_63214 = fluree.db.util.async.throw_err(inst_63213);
var state_63277__$1 = state_63277;
var statearr_63283_63347 = state_63277__$1;
(statearr_63283_63347[(2)] = inst_63214);

(statearr_63283_63347[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (4))){
var inst_63143 = (state_63277[(2)]);
var state_63277__$1 = state_63277;
var statearr_63284_63348 = state_63277__$1;
(statearr_63284_63348[(2)] = inst_63143);

(statearr_63284_63348[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (15))){
var inst_63169 = (state_63277[(2)]);
var inst_63170 = fluree.db.util.async.throw_err(inst_63169);
var state_63277__$1 = state_63277;
var statearr_63285_63349 = state_63277__$1;
(statearr_63285_63349[(2)] = inst_63170);

(statearr_63285_63349[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (21))){
var inst_63198 = (state_63277[(7)]);
var inst_63211 = fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$4(db,inst_63198,type,params);
var state_63277__$1 = state_63277;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63277__$1,(24),inst_63211);
} else {
if((state_val_63278 === (31))){
var inst_63246 = (state_63277[(8)]);
var inst_63199 = (state_63277[(9)]);
var inst_63191 = inst_63199;
var inst_63192 = inst_63246;
var state_63277__$1 = (function (){var statearr_63286 = state_63277;
(statearr_63286[(10)] = inst_63191);

(statearr_63286[(11)] = inst_63192);

return statearr_63286;
})();
var statearr_63287_63350 = state_63277__$1;
(statearr_63287_63350[(2)] = null);

(statearr_63287_63350[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (32))){
var inst_63246 = (state_63277[(8)]);
var state_63277__$1 = state_63277;
var statearr_63288_63351 = state_63277__$1;
(statearr_63288_63351[(2)] = inst_63246);

(statearr_63288_63351[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (33))){
var inst_63252 = (state_63277[(2)]);
var state_63277__$1 = state_63277;
var statearr_63289_63352 = state_63277__$1;
(statearr_63289_63352[(2)] = inst_63252);

(statearr_63289_63352[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (13))){
var state_63277__$1 = state_63277;
var statearr_63290_63353 = state_63277__$1;
(statearr_63290_63353[(2)] = null);

(statearr_63290_63353[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (22))){
var inst_63198 = (state_63277[(7)]);
var inst_63216 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63217 = [cljs.core.string_QMARK_,cljs.core.number_QMARK_,cljs.core.true_QMARK_,cljs.core.false_QMARK_,cljs.core.nil_QMARK_];
var inst_63218 = (new cljs.core.PersistentVector(null,5,(5),inst_63216,inst_63217,null));
var inst_63219 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.some_fn,inst_63218);
var inst_63220 = (inst_63219.cljs$core$IFn$_invoke$arity$1 ? inst_63219.cljs$core$IFn$_invoke$arity$1(inst_63198) : inst_63219.call(null,inst_63198));
var state_63277__$1 = state_63277;
if(cljs.core.truth_(inst_63220)){
var statearr_63291_63354 = state_63277__$1;
(statearr_63291_63354[(1)] = (25));

} else {
var statearr_63292_63355 = state_63277__$1;
(statearr_63292_63355[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (36))){
var inst_63272 = (state_63277[(2)]);
var _ = (function (){var statearr_63293 = state_63277;
(statearr_63293[(4)] = cljs.core.rest((state_63277[(4)])));

return statearr_63293;
})();
var state_63277__$1 = state_63277;
var statearr_63294_63356 = state_63277__$1;
(statearr_63294_63356[(2)] = inst_63272);

(statearr_63294_63356[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (29))){
var inst_63198 = (state_63277[(7)]);
var inst_63231 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63198], 0));
var inst_63232 = (type.cljs$core$IFn$_invoke$arity$1 ? type.cljs$core$IFn$_invoke$arity$1(inst_63198) : type.call(null,inst_63198));
var inst_63233 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_63234 = ["Invalid element (",inst_63231,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63232),") in form: ",inst_63233,"."].join('');
var inst_63235 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63236 = [(400),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)];
var inst_63237 = cljs.core.PersistentHashMap.fromArrays(inst_63235,inst_63236);
var inst_63238 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_63234,inst_63237);
var inst_63239 = (function(){throw inst_63238})();
var state_63277__$1 = state_63277;
var statearr_63295_63357 = state_63277__$1;
(statearr_63295_63357[(2)] = inst_63239);

(statearr_63295_63357[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (6))){
var inst_63156 = cljs.core.first(form);
var state_63277__$1 = state_63277;
var statearr_63296_63358 = state_63277__$1;
(statearr_63296_63358[(2)] = inst_63156);

(statearr_63296_63358[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (28))){
var inst_63198 = (state_63277[(7)]);
var state_63277__$1 = state_63277;
var statearr_63297_63359 = state_63277__$1;
(statearr_63297_63359[(2)] = inst_63198);

(statearr_63297_63359[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (25))){
var inst_63198 = (state_63277[(7)]);
var state_63277__$1 = state_63277;
var statearr_63298_63360 = state_63277__$1;
(statearr_63298_63360[(2)] = inst_63198);

(statearr_63298_63360[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (34))){
var inst_63257 = (state_63277[(12)]);
var inst_63175 = (state_63277[(13)]);
var inst_63259 = new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null);
var inst_63260 = cljs.core.cons(inst_63259,inst_63257);
var inst_63261 = cljs.core.cons(inst_63175,inst_63260);
var inst_63262 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63263 = ["Validated fn form:",inst_63261];
var inst_63264 = (new cljs.core.PersistentVector(null,2,(5),inst_63262,inst_63263,null));
var inst_63265 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_63264);
var state_63277__$1 = (function (){var statearr_63299 = state_63277;
(statearr_63299[(14)] = inst_63265);

return statearr_63299;
})();
var statearr_63300_63361 = state_63277__$1;
(statearr_63300_63361[(2)] = inst_63261);

(statearr_63300_63361[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (17))){
var state_63277__$1 = state_63277;
var statearr_63301_63362 = state_63277__$1;
(statearr_63301_63362[(2)] = null);

(statearr_63301_63362[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (3))){
var inst_63275 = (state_63277[(2)]);
var state_63277__$1 = state_63277;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63277__$1,inst_63275);
} else {
if((state_val_63278 === (12))){
var inst_63159 = (state_63277[(15)]);
var inst_63167 = fluree.db.dbfunctions.core.resolve_fn(db,inst_63159,type);
var state_63277__$1 = state_63277;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63277__$1,(15),inst_63167);
} else {
if((state_val_63278 === (2))){
var _ = (function (){var statearr_63302 = state_63277;
(statearr_63302[(4)] = cljs.core.cons((5),(state_63277[(4)])));

return statearr_63302;
})();
var inst_63149 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63150 = ["Validating form:",form,"- params:",params];
var inst_63151 = (new cljs.core.PersistentVector(null,4,(5),inst_63149,inst_63150,null));
var inst_63152 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_63151);
var inst_63154 = cljs.core.list_QMARK_(form);
var state_63277__$1 = (function (){var statearr_63303 = state_63277;
(statearr_63303[(16)] = inst_63152);

return statearr_63303;
})();
if(inst_63154){
var statearr_63304_63363 = state_63277__$1;
(statearr_63304_63363[(1)] = (6));

} else {
var statearr_63305_63364 = state_63277__$1;
(statearr_63305_63364[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (23))){
var inst_63199 = (state_63277[(9)]);
var inst_63192 = (state_63277[(11)]);
var inst_63245 = (state_63277[(2)]);
var inst_63246 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_63192,inst_63245);
var inst_63247 = cljs.core.seq(inst_63199);
var state_63277__$1 = (function (){var statearr_63306 = state_63277;
(statearr_63306[(8)] = inst_63246);

return statearr_63306;
})();
if(inst_63247){
var statearr_63307_63365 = state_63277__$1;
(statearr_63307_63365[(1)] = (31));

} else {
var statearr_63308_63366 = state_63277__$1;
(statearr_63308_63366[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (35))){
var inst_63267 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63268 = ["Validated non-fn form:",form];
var inst_63269 = (new cljs.core.PersistentVector(null,2,(5),inst_63267,inst_63268,null));
var inst_63270 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_63269);
var state_63277__$1 = (function (){var statearr_63309 = state_63277;
(statearr_63309[(17)] = inst_63270);

return statearr_63309;
})();
var statearr_63310_63367 = state_63277__$1;
(statearr_63310_63367[(2)] = form);

(statearr_63310_63367[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (19))){
var inst_63198 = (state_63277[(7)]);
var inst_63191 = (state_63277[(10)]);
var inst_63197 = cljs.core.seq(inst_63191);
var inst_63198__$1 = cljs.core.first(inst_63197);
var inst_63199 = cljs.core.next(inst_63197);
var inst_63200 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63201 = ["Validating arg:",inst_63198__$1];
var inst_63202 = (new cljs.core.PersistentVector(null,2,(5),inst_63200,inst_63201,null));
var inst_63203 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_63202);
var inst_63205 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63206 = [cljs.core.list_QMARK_,cljs.core.vector_QMARK_];
var inst_63207 = (new cljs.core.PersistentVector(null,2,(5),inst_63205,inst_63206,null));
var inst_63208 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.some_fn,inst_63207);
var inst_63209 = (inst_63208.cljs$core$IFn$_invoke$arity$1 ? inst_63208.cljs$core$IFn$_invoke$arity$1(inst_63198__$1) : inst_63208.call(null,inst_63198__$1));
var state_63277__$1 = (function (){var statearr_63311 = state_63277;
(statearr_63311[(7)] = inst_63198__$1);

(statearr_63311[(9)] = inst_63199);

(statearr_63311[(18)] = inst_63203);

return statearr_63311;
})();
if(cljs.core.truth_(inst_63209)){
var statearr_63312_63368 = state_63277__$1;
(statearr_63312_63368[(1)] = (21));

} else {
var statearr_63313_63369 = state_63277__$1;
(statearr_63313_63369[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (11))){
var inst_63159 = (state_63277[(15)]);
var inst_63164 = (state_63277[(19)]);
var inst_63164__$1 = (state_63277[(2)]);
var inst_63165 = cljs.core.count(inst_63164__$1);
var state_63277__$1 = (function (){var statearr_63315 = state_63277;
(statearr_63315[(20)] = inst_63165);

(statearr_63315[(19)] = inst_63164__$1);

return statearr_63315;
})();
if(cljs.core.truth_(inst_63159)){
var statearr_63316_63370 = state_63277__$1;
(statearr_63316_63370[(1)] = (12));

} else {
var statearr_63317_63371 = state_63277__$1;
(statearr_63317_63371[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (9))){
var inst_63161 = cljs.core.rest(form);
var state_63277__$1 = state_63277;
var statearr_63318_63372 = state_63277__$1;
(statearr_63318_63372[(2)] = inst_63161);

(statearr_63318_63372[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (5))){
var _ = (function (){var statearr_63319 = state_63277;
(statearr_63319[(4)] = cljs.core.rest((state_63277[(4)])));

return statearr_63319;
})();
var state_63277__$1 = state_63277;
var ex63314 = (state_63277__$1[(2)]);
var statearr_63320_63373 = state_63277__$1;
(statearr_63320_63373[(5)] = ex63314);


if((ex63314 instanceof Error)){
var statearr_63321_63374 = state_63277__$1;
(statearr_63321_63374[(1)] = (4));

(statearr_63321_63374[(5)] = null);

} else {
throw ex63314;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (14))){
var inst_63173 = (state_63277[(21)]);
var inst_63174 = (state_63277[(22)]);
var inst_63164 = (state_63277[(19)]);
var inst_63173__$1 = (state_63277[(2)]);
var inst_63174__$1 = cljs.core.__destructure_map(inst_63173__$1);
var inst_63175 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63174__$1,new cljs.core.Keyword(null,"f","f",-1597136552));
var inst_63176 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63174__$1,new cljs.core.Keyword(null,"arity","arity",-1808556135));
var inst_63177 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63174__$1,new cljs.core.Keyword(null,"var-args?","var-args?",-1630678710));
var inst_63178 = cljs.core.seq(inst_63164);
var state_63277__$1 = (function (){var statearr_63322 = state_63277;
(statearr_63322[(21)] = inst_63173__$1);

(statearr_63322[(22)] = inst_63174__$1);

(statearr_63322[(23)] = inst_63177);

(statearr_63322[(13)] = inst_63175);

(statearr_63322[(24)] = inst_63176);

return statearr_63322;
})();
if(inst_63178){
var statearr_63323_63375 = state_63277__$1;
(statearr_63323_63375[(1)] = (16));

} else {
var statearr_63324_63376 = state_63277__$1;
(statearr_63324_63376[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (26))){
var inst_63173 = (state_63277[(21)]);
var inst_63174 = (state_63277[(22)]);
var inst_63165 = (state_63277[(20)]);
var inst_63188 = (state_63277[(25)]);
var inst_63159 = (state_63277[(15)]);
var inst_63189 = (state_63277[(26)]);
var inst_63198 = (state_63277[(7)]);
var inst_63177 = (state_63277[(23)]);
var inst_63199 = (state_63277[(9)]);
var inst_63175 = (state_63277[(13)]);
var inst_63176 = (state_63277[(24)]);
var inst_63191 = (state_63277[(10)]);
var inst_63192 = (state_63277[(11)]);
var inst_63164 = (state_63277[(19)]);
var inst_63223 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63224 = (function (){var first__63186 = inst_63188;
var arity = inst_63176;
var args_n = inst_63165;
var fn_map = inst_63173;
var G__63183 = inst_63191;
var expr__63204 = inst_63198;
var args = inst_63164;
var r = inst_63199;
var first__63196 = inst_63198;
var vec__63194 = inst_63191;
var seq__63195 = inst_63199;
var seq__63185 = inst_63189;
var acc = inst_63192;
var var_args_QMARK_ = inst_63177;
var fn_name = inst_63159;
var map__63153 = inst_63174;
var arg = inst_63198;
var vec__63184 = inst_63164;
var f = inst_63175;
return (function (p1__63140_SHARP_){
var and__5043__auto__ = (p1__63140_SHARP_ instanceof cljs.core.Symbol);
if(and__5043__auto__){
return fluree.db.dbfunctions.core.valid_symbol_QMARK_(type,params,p1__63140_SHARP_);
} else {
return and__5043__auto__;
}
});
})();
var inst_63225 = [inst_63224];
var inst_63226 = (new cljs.core.PersistentVector(null,1,(5),inst_63223,inst_63225,null));
var inst_63227 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.some_fn,inst_63226);
var inst_63228 = (inst_63227.cljs$core$IFn$_invoke$arity$1 ? inst_63227.cljs$core$IFn$_invoke$arity$1(inst_63198) : inst_63227.call(null,inst_63198));
var state_63277__$1 = state_63277;
if(cljs.core.truth_(inst_63228)){
var statearr_63325_63377 = state_63277__$1;
(statearr_63325_63377[(1)] = (28));

} else {
var statearr_63326_63378 = state_63277__$1;
(statearr_63326_63378[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (16))){
var inst_63164 = (state_63277[(19)]);
var inst_63187 = cljs.core.seq(inst_63164);
var inst_63188 = cljs.core.first(inst_63187);
var inst_63189 = cljs.core.next(inst_63187);
var inst_63190 = cljs.core.PersistentVector.EMPTY;
var inst_63191 = inst_63164;
var inst_63192 = inst_63190;
var state_63277__$1 = (function (){var statearr_63327 = state_63277;
(statearr_63327[(25)] = inst_63188);

(statearr_63327[(26)] = inst_63189);

(statearr_63327[(10)] = inst_63191);

(statearr_63327[(11)] = inst_63192);

return statearr_63327;
})();
var statearr_63328_63379 = state_63277__$1;
(statearr_63328_63379[(2)] = null);

(statearr_63328_63379[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (30))){
var inst_63241 = (state_63277[(2)]);
var state_63277__$1 = state_63277;
var statearr_63329_63380 = state_63277__$1;
(statearr_63329_63380[(2)] = inst_63241);

(statearr_63329_63380[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (10))){
var state_63277__$1 = state_63277;
var statearr_63330_63381 = state_63277__$1;
(statearr_63330_63381[(2)] = form);

(statearr_63330_63381[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (18))){
var inst_63159 = (state_63277[(15)]);
var inst_63257 = (state_63277[(2)]);
var state_63277__$1 = (function (){var statearr_63331 = state_63277;
(statearr_63331[(12)] = inst_63257);

return statearr_63331;
})();
if(cljs.core.truth_(inst_63159)){
var statearr_63332_63382 = state_63277__$1;
(statearr_63332_63382[(1)] = (34));

} else {
var statearr_63333_63383 = state_63277__$1;
(statearr_63333_63383[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63278 === (8))){
var inst_63159 = (state_63277[(15)]);
var inst_63159__$1 = (state_63277[(2)]);
var state_63277__$1 = (function (){var statearr_63334 = state_63277;
(statearr_63334[(15)] = inst_63159__$1);

return statearr_63334;
})();
if(cljs.core.truth_(inst_63159__$1)){
var statearr_63335_63384 = state_63277__$1;
(statearr_63335_63384[(1)] = (9));

} else {
var statearr_63336_63385 = state_63277__$1;
(statearr_63336_63385[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__2727__auto____0 = (function (){
var statearr_63337 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63337[(0)] = fluree$db$dbfunctions$core$state_machine__2727__auto__);

(statearr_63337[(1)] = (1));

return statearr_63337;
});
var fluree$db$dbfunctions$core$state_machine__2727__auto____1 = (function (state_63277){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63277);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63338){var ex__2730__auto__ = e63338;
var statearr_63339_63386 = state_63277;
(statearr_63339_63386[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63277[(4)]))){
var statearr_63340_63387 = state_63277;
(statearr_63340_63387[(1)] = cljs.core.first((state_63277[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63388 = state_63277;
state_63277 = G__63388;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__2727__auto__ = function(state_63277){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__2727__auto____1.call(this,state_63277);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__2727__auto____0;
fluree$db$dbfunctions$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__2727__auto____1;
return fluree$db$dbfunctions$core$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63341 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63341[(6)] = c__2749__auto__);

return statearr_63341;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.core.validate_form.cljs$lang$maxFixedArity = 4);

fluree.db.dbfunctions.core.parse_fn = (function fluree$db$dbfunctions$core$parse_fn(db,fn_str,type,params){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63424){
var state_val_63425 = (state_63424[(1)]);
if((state_val_63425 === (7))){
var inst_63395 = ["(fn [_] ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_str),")"].join('');
var inst_63396 = fluree.db.dbfunctions.core.parse_string(inst_63395);
var state_63424__$1 = state_63424;
var statearr_63426_63450 = state_63424__$1;
(statearr_63426_63450[(2)] = inst_63396);

(statearr_63426_63450[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63425 === (1))){
var state_63424__$1 = state_63424;
var statearr_63427_63451 = state_63424__$1;
(statearr_63427_63451[(2)] = null);

(statearr_63427_63451[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63425 === (4))){
var inst_63389 = (state_63424[(2)]);
var state_63424__$1 = state_63424;
var statearr_63428_63452 = state_63424__$1;
(statearr_63428_63452[(2)] = inst_63389);

(statearr_63428_63452[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63425 === (6))){
var inst_63419 = (state_63424[(2)]);
var _ = (function (){var statearr_63429 = state_63424;
(statearr_63429[(4)] = cljs.core.rest((state_63424[(4)])));

return statearr_63429;
})();
var state_63424__$1 = state_63424;
var statearr_63430_63453 = state_63424__$1;
(statearr_63430_63453[(2)] = inst_63419);

(statearr_63430_63453[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63425 === (3))){
var inst_63422 = (state_63424[(2)]);
var state_63424__$1 = state_63424;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63424__$1,inst_63422);
} else {
if((state_val_63425 === (12))){
var inst_63403 = (state_63424[(2)]);
var inst_63404 = fluree.db.util.async.throw_err(inst_63403);
var inst_63405 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63406 = ["Parsed & validated db fn:",inst_63404];
var inst_63407 = (new cljs.core.PersistentVector(null,2,(5),inst_63405,inst_63406,null));
var inst_63408 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_63407);
var state_63424__$1 = (function (){var statearr_63431 = state_63424;
(statearr_63431[(7)] = inst_63408);

return statearr_63431;
})();
var statearr_63432_63454 = state_63424__$1;
(statearr_63432_63454[(2)] = inst_63404);

(statearr_63432_63454[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63425 === (2))){
var _ = (function (){var statearr_63433 = state_63424;
(statearr_63433[(4)] = cljs.core.cons((5),(state_63424[(4)])));

return statearr_63433;
})();
var state_63424__$1 = state_63424;
var G__63434_63455 = fn_str;
switch (G__63434_63455) {
case "true":
case "false":
var statearr_63435_63457 = state_63424__$1;
(statearr_63435_63457[(1)] = (7));


break;
default:
var statearr_63436_63458 = state_63424__$1;
(statearr_63436_63458[(1)] = (8));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63425 === (11))){
var inst_63416 = (state_63424[(2)]);
var state_63424__$1 = state_63424;
var statearr_63438_63459 = state_63424__$1;
(statearr_63438_63459[(2)] = inst_63416);

(statearr_63438_63459[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63425 === (9))){
var inst_63400 = fluree.db.dbfunctions.core.parse_string(fn_str);
var inst_63401 = fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$4(db,inst_63400,type,params);
var state_63424__$1 = state_63424;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63424__$1,(12),inst_63401);
} else {
if((state_val_63425 === (5))){
var _ = (function (){var statearr_63439 = state_63424;
(statearr_63439[(4)] = cljs.core.rest((state_63424[(4)])));

return statearr_63439;
})();
var state_63424__$1 = state_63424;
var ex63437 = (state_63424__$1[(2)]);
var statearr_63440_63460 = state_63424__$1;
(statearr_63440_63460[(5)] = ex63437);


if((ex63437 instanceof Error)){
var statearr_63441_63461 = state_63424__$1;
(statearr_63441_63461[(1)] = (4));

(statearr_63441_63461[(5)] = null);

} else {
throw ex63437;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63425 === (10))){
var inst_63410 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63411 = [(400),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)];
var inst_63412 = cljs.core.PersistentHashMap.fromArrays(inst_63410,inst_63411);
var inst_63413 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Bad function",inst_63412);
var inst_63414 = (function(){throw inst_63413})();
var state_63424__$1 = state_63424;
var statearr_63442_63462 = state_63424__$1;
(statearr_63442_63462[(2)] = inst_63414);

(statearr_63442_63462[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63425 === (8))){
var inst_63398 = cljs.core.re_matches(/^\(.+\)$/,fn_str);
var state_63424__$1 = state_63424;
if(cljs.core.truth_(inst_63398)){
var statearr_63443_63463 = state_63424__$1;
(statearr_63443_63463[(1)] = (9));

} else {
var statearr_63444_63464 = state_63424__$1;
(statearr_63444_63464[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$parse_fn_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$core$parse_fn_$_state_machine__2727__auto____0 = (function (){
var statearr_63445 = [null,null,null,null,null,null,null,null];
(statearr_63445[(0)] = fluree$db$dbfunctions$core$parse_fn_$_state_machine__2727__auto__);

(statearr_63445[(1)] = (1));

return statearr_63445;
});
var fluree$db$dbfunctions$core$parse_fn_$_state_machine__2727__auto____1 = (function (state_63424){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63424);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63446){var ex__2730__auto__ = e63446;
var statearr_63447_63465 = state_63424;
(statearr_63447_63465[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63424[(4)]))){
var statearr_63448_63466 = state_63424;
(statearr_63448_63466[(1)] = cljs.core.first((state_63424[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63467 = state_63424;
state_63424 = G__63467;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$parse_fn_$_state_machine__2727__auto__ = function(state_63424){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$parse_fn_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$parse_fn_$_state_machine__2727__auto____1.call(this,state_63424);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$parse_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$parse_fn_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$core$parse_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$parse_fn_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$core$parse_fn_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63449 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63449[(6)] = c__2749__auto__);

return statearr_63449;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.dbfunctions.core.parse_and_wrap_fn = (function fluree$db$dbfunctions$core$parse_and_wrap_fn(var_args){
var G__63469 = arguments.length;
switch (G__63469) {
case 3:
return fluree.db.dbfunctions.core.parse_and_wrap_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_and_wrap_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_and_wrap_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_str,type){
return fluree.db.dbfunctions.core.parse_and_wrap_fn.cljs$core$IFn$_invoke$arity$4(db,fn_str,type,null);
}));

(fluree.db.dbfunctions.core.parse_and_wrap_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,fn_str,type,params){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63512){
var state_val_63513 = (state_63512[(1)]);
if((state_val_63513 === (7))){
var inst_63495 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_63512__$1 = state_63512;
var statearr_63514_63538 = state_63512__$1;
(statearr_63514_63538[(2)] = inst_63495);

(statearr_63514_63538[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63513 === (1))){
var state_63512__$1 = state_63512;
var statearr_63515_63539 = state_63512__$1;
(statearr_63515_63539[(2)] = null);

(statearr_63515_63539[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63513 === (4))){
var inst_63470 = (state_63512[(2)]);
var state_63512__$1 = state_63512;
var statearr_63516_63540 = state_63512__$1;
(statearr_63516_63540[(2)] = inst_63470);

(statearr_63516_63540[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63513 === (6))){
var inst_63493 = (state_63512[(7)]);
var inst_63478 = (state_63512[(2)]);
var inst_63479 = fluree.db.util.async.throw_err(inst_63478);
var inst_63480 = new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null);
var inst_63481 = (new cljs.core.List(null,inst_63480,null,(1),null));
var inst_63482 = new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null);
var inst_63483 = (new cljs.core.List(null,inst_63482,null,(1),null));
var inst_63484 = cljs.core.concat.cljs$core$IFn$_invoke$arity$1(inst_63483);
var inst_63485 = cljs.core.seq(inst_63484);
var inst_63486 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_63485);
var inst_63487 = cljs.core.vec(inst_63486);
var inst_63488 = (new cljs.core.List(null,inst_63487,null,(1),null));
var inst_63489 = (new cljs.core.List(null,inst_63479,null,(1),null));
var inst_63490 = cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(inst_63481,inst_63488,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63489], 0));
var inst_63491 = cljs.core.seq(inst_63490);
var inst_63492 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_63491);
var inst_63493__$1 = params;
var state_63512__$1 = (function (){var statearr_63517 = state_63512;
(statearr_63517[(7)] = inst_63493__$1);

(statearr_63517[(8)] = inst_63492);

return statearr_63517;
})();
if(cljs.core.truth_(inst_63493__$1)){
var statearr_63518_63541 = state_63512__$1;
(statearr_63518_63541[(1)] = (7));

} else {
var statearr_63519_63542 = state_63512__$1;
(statearr_63519_63542[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63513 === (3))){
var inst_63510 = (state_63512[(2)]);
var state_63512__$1 = state_63512;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63512__$1,inst_63510);
} else {
if((state_val_63513 === (12))){
var inst_63503 = (state_63512[(2)]);
var inst_63504 = [new cljs.core.Keyword(null,"fnstr","fnstr",2092773532)];
var inst_63505 = [fn_str];
var inst_63506 = cljs.core.PersistentHashMap.fromArrays(inst_63504,inst_63505);
var inst_63507 = cljs.core.with_meta(inst_63503,inst_63506);
var _ = (function (){var statearr_63520 = state_63512;
(statearr_63520[(4)] = cljs.core.rest((state_63512[(4)])));

return statearr_63520;
})();
var state_63512__$1 = state_63512;
var statearr_63521_63543 = state_63512__$1;
(statearr_63521_63543[(2)] = inst_63507);

(statearr_63521_63543[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63513 === (2))){
var _ = (function (){var statearr_63522 = state_63512;
(statearr_63522[(4)] = cljs.core.cons((5),(state_63512[(4)])));

return statearr_63522;
})();
var inst_63476 = fluree.db.dbfunctions.core.parse_fn(db,fn_str,type,params);
var state_63512__$1 = state_63512;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63512__$1,(6),inst_63476);
} else {
if((state_val_63513 === (11))){
var inst_63492 = (state_63512[(8)]);
var inst_63501 = fluree.db.dbfunctions.core.eval_form(inst_63492);
var state_63512__$1 = state_63512;
var statearr_63524_63544 = state_63512__$1;
(statearr_63524_63544[(2)] = inst_63501);

(statearr_63524_63544[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63513 === (9))){
var inst_63498 = (state_63512[(2)]);
var state_63512__$1 = state_63512;
if(cljs.core.truth_(inst_63498)){
var statearr_63525_63545 = state_63512__$1;
(statearr_63525_63545[(1)] = (10));

} else {
var statearr_63526_63546 = state_63512__$1;
(statearr_63526_63546[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63513 === (5))){
var _ = (function (){var statearr_63527 = state_63512;
(statearr_63527[(4)] = cljs.core.rest((state_63512[(4)])));

return statearr_63527;
})();
var state_63512__$1 = state_63512;
var ex63523 = (state_63512__$1[(2)]);
var statearr_63528_63547 = state_63512__$1;
(statearr_63528_63547[(5)] = ex63523);


if((ex63523 instanceof Error)){
var statearr_63529_63548 = state_63512__$1;
(statearr_63529_63548[(1)] = (4));

(statearr_63529_63548[(5)] = null);

} else {
throw ex63523;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63513 === (10))){
var inst_63492 = (state_63512[(8)]);
var state_63512__$1 = state_63512;
var statearr_63530_63549 = state_63512__$1;
(statearr_63530_63549[(2)] = inst_63492);

(statearr_63530_63549[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63513 === (8))){
var inst_63493 = (state_63512[(7)]);
var state_63512__$1 = state_63512;
var statearr_63531_63550 = state_63512__$1;
(statearr_63531_63550[(2)] = inst_63493);

(statearr_63531_63550[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__2727__auto____0 = (function (){
var statearr_63532 = [null,null,null,null,null,null,null,null,null];
(statearr_63532[(0)] = fluree$db$dbfunctions$core$state_machine__2727__auto__);

(statearr_63532[(1)] = (1));

return statearr_63532;
});
var fluree$db$dbfunctions$core$state_machine__2727__auto____1 = (function (state_63512){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63512);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63533){var ex__2730__auto__ = e63533;
var statearr_63534_63551 = state_63512;
(statearr_63534_63551[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63512[(4)]))){
var statearr_63535_63552 = state_63512;
(statearr_63535_63552[(1)] = cljs.core.first((state_63512[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63553 = state_63512;
state_63512 = G__63553;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__2727__auto__ = function(state_63512){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__2727__auto____1.call(this,state_63512);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__2727__auto____0;
fluree$db$dbfunctions$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__2727__auto____1;
return fluree$db$dbfunctions$core$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63536 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63536[(6)] = c__2749__auto__);

return statearr_63536;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.core.parse_and_wrap_fn.cljs$lang$maxFixedArity = 4);

/**
 * Executes a transaction function
 */
fluree.db.dbfunctions.core.execute_tx_fn = (function fluree$db$dbfunctions$core$execute_tx_fn(p__63554){
var map__63555 = p__63554;
var map__63555__$1 = cljs.core.__destructure_map(map__63555);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63555__$1,new cljs.core.Keyword(null,"db","db",993250759));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63555__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var _credits = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63555__$1,new cljs.core.Keyword(null,"_credits","_credits",1245712171));
var s = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63555__$1,new cljs.core.Keyword(null,"s","s",1705939918));
var p = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63555__$1,new cljs.core.Keyword(null,"p","p",151049309));
var o = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63555__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var fuel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63555__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485));
var block_instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63555__$1,new cljs.core.Keyword(null,"block-instant","block-instant",-641639021));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63589){
var state_val_63590 = (state_63589[(1)]);
if((state_val_63590 === (7))){
var inst_63576 = (state_63589[(7)]);
var state_63589__$1 = state_63589;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63589__$1,(10),inst_63576);
} else {
if((state_val_63590 === (1))){
var state_63589__$1 = state_63589;
var statearr_63591_63611 = state_63589__$1;
(statearr_63591_63611[(2)] = null);

(statearr_63591_63611[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63590 === (4))){
var inst_63556 = (state_63589[(2)]);
var state_63589__$1 = state_63589;
var statearr_63592_63612 = state_63589__$1;
(statearr_63592_63612[(2)] = inst_63556);

(statearr_63592_63612[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63590 === (6))){
var inst_63565 = (state_63589[(8)]);
var inst_63576 = (state_63589[(7)]);
var inst_63568 = (state_63589[(2)]);
var inst_63569 = fluree.db.util.async.throw_err(inst_63568);
var inst_63570 = (new cljs.core.List(null,inst_63565,null,(1),null));
var inst_63571 = (new cljs.core.List(null,inst_63569,inst_63570,(2),null));
var inst_63572 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63573 = ["Evaluating fn call:",inst_63571];
var inst_63574 = (new cljs.core.PersistentVector(null,2,(5),inst_63572,inst_63573,null));
var inst_63575 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_63574);
var inst_63576__$1 = fluree.db.dbfunctions.core.eval_form(inst_63571);
var inst_63577 = fluree.db.util.async.channel_QMARK_(inst_63576__$1);
var state_63589__$1 = (function (){var statearr_63593 = state_63589;
(statearr_63593[(9)] = inst_63575);

(statearr_63593[(7)] = inst_63576__$1);

return statearr_63593;
})();
if(inst_63577){
var statearr_63594_63613 = state_63589__$1;
(statearr_63594_63613[(1)] = (7));

} else {
var statearr_63595_63614 = state_63589__$1;
(statearr_63595_63614[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63590 === (3))){
var inst_63587 = (state_63589[(2)]);
var state_63589__$1 = state_63589;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63589__$1,inst_63587);
} else {
if((state_val_63590 === (2))){
var _ = (function (){var statearr_63597 = state_63589;
(statearr_63597[(4)] = cljs.core.cons((5),(state_63589[(4)])));

return statearr_63597;
})();
var inst_63562 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(o,(1));
var inst_63563 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"pid","pid",1018387698),new cljs.core.Keyword(null,"auth_id","auth_id",1917762333),new cljs.core.Keyword(null,"state","state",-1988618099)];
var inst_63564 = [db,block_instant,s,p,auth,fuel];
var inst_63565 = cljs.core.PersistentHashMap.fromArrays(inst_63563,inst_63564);
var inst_63566 = fluree.db.dbfunctions.core.parse_and_wrap_fn.cljs$core$IFn$_invoke$arity$3(db,inst_63562,"txn");
var state_63589__$1 = (function (){var statearr_63598 = state_63589;
(statearr_63598[(8)] = inst_63565);

return statearr_63598;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63589__$1,(6),inst_63566);
} else {
if((state_val_63590 === (9))){
var inst_63584 = (state_63589[(2)]);
var _ = (function (){var statearr_63599 = state_63589;
(statearr_63599[(4)] = cljs.core.rest((state_63589[(4)])));

return statearr_63599;
})();
var state_63589__$1 = state_63589;
var statearr_63600_63615 = state_63589__$1;
(statearr_63600_63615[(2)] = inst_63584);

(statearr_63600_63615[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63590 === (5))){
var _ = (function (){var statearr_63601 = state_63589;
(statearr_63601[(4)] = cljs.core.rest((state_63589[(4)])));

return statearr_63601;
})();
var state_63589__$1 = state_63589;
var ex63596 = (state_63589__$1[(2)]);
var statearr_63602_63616 = state_63589__$1;
(statearr_63602_63616[(5)] = ex63596);


if((ex63596 instanceof Error)){
var statearr_63603_63617 = state_63589__$1;
(statearr_63603_63617[(1)] = (4));

(statearr_63603_63617[(5)] = null);

} else {
throw ex63596;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63590 === (10))){
var inst_63580 = (state_63589[(2)]);
var inst_63581 = fluree.db.util.async.throw_err(inst_63580);
var state_63589__$1 = state_63589;
var statearr_63604_63618 = state_63589__$1;
(statearr_63604_63618[(2)] = inst_63581);

(statearr_63604_63618[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63590 === (8))){
var inst_63576 = (state_63589[(7)]);
var state_63589__$1 = state_63589;
var statearr_63605_63619 = state_63589__$1;
(statearr_63605_63619[(2)] = inst_63576);

(statearr_63605_63619[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2727__auto____0 = (function (){
var statearr_63606 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63606[(0)] = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2727__auto__);

(statearr_63606[(1)] = (1));

return statearr_63606;
});
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2727__auto____1 = (function (state_63589){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63589);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63607){var ex__2730__auto__ = e63607;
var statearr_63608_63620 = state_63589;
(statearr_63608_63620[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63589[(4)]))){
var statearr_63609_63621 = state_63589;
(statearr_63609_63621[(1)] = cljs.core.first((state_63589[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63622 = state_63589;
state_63589 = G__63622;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2727__auto__ = function(state_63589){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2727__auto____1.call(this,state_63589);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63610 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63610[(6)] = c__2749__auto__);

return statearr_63610;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
