// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.range');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28013 = arguments.length;
var i__5770__auto___28014 = (0);
while(true){
if((i__5770__auto___28014 < len__5769__auto___28013)){
args__5775__auto__.push((arguments[i__5770__auto___28014]));

var G__28015 = (i__5770__auto___28014 + (1));
i__5770__auto___28014 = G__28015;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
var G__28008_28016 = e;
var G__28009_28017 = "Function Error: ";
var G__28010_28018 = function_name;
var G__28011_28019 = "args: ";
var G__28012_28020 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$5 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$5(G__28008_28016,G__28009_28017,G__28010_28018,G__28011_28019,G__28012_28020) : fluree.db.util.log.error.call(null,G__28008_28016,G__28009_28017,G__28010_28018,G__28011_28019,G__28012_28020));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq28005){
var G__28006 = cljs.core.first(seq28005);
var seq28005__$1 = cljs.core.next(seq28005);
var G__28007 = cljs.core.first(seq28005__$1);
var seq28005__$2 = cljs.core.next(seq28005__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28006,G__28007,seq28005__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e28021){var e = e28021;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e28022){var e = e28022;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e28023){var e = e28023;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e28024){var e = e28024;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e28025){var e = e28025;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28028 = arguments.length;
var i__5770__auto___28029 = (0);
while(true){
if((i__5770__auto___28029 < len__5769__auto___28028)){
args__5775__auto__.push((arguments[i__5770__auto___28029]));

var G__28030 = (i__5770__auto___28029 + (1));
i__5770__auto___28029 = G__28030;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28027){var e = e28027;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq28026){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28026));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28033 = arguments.length;
var i__5770__auto___28034 = (0);
while(true){
if((i__5770__auto___28034 < len__5769__auto___28033)){
args__5775__auto__.push((arguments[i__5770__auto___28034]));

var G__28035 = (i__5770__auto___28034 + (1));
i__5770__auto___28034 = G__28035;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28032){var e = e28032;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq28031){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28031));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e28036){var e = e28036;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28039 = arguments.length;
var i__5770__auto___28040 = (0);
while(true){
if((i__5770__auto___28040 < len__5769__auto___28039)){
args__5775__auto__.push((arguments[i__5770__auto___28040]));

var G__28041 = (i__5770__auto___28040 + (1));
i__5770__auto___28040 = G__28041;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e28038){var e = e28038;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq28037){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28037));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28044 = arguments.length;
var i__5770__auto___28045 = (0);
while(true){
if((i__5770__auto___28045 < len__5769__auto___28044)){
args__5775__auto__.push((arguments[i__5770__auto___28045]));

var G__28046 = (i__5770__auto___28045 + (1));
i__5770__auto___28045 = G__28046;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e28043){var e = e28043;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq28042){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28042));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e28047){var e = e28047;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e28048){var e = e28048;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28051 = arguments.length;
var i__5770__auto___28052 = (0);
while(true){
if((i__5770__auto___28052 < len__5769__auto___28051)){
args__5775__auto__.push((arguments[i__5770__auto___28052]));

var G__28053 = (i__5770__auto___28052 + (1));
i__5770__auto___28052 = G__28053;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28050){var e = e28050;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq28049){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28049));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28056 = arguments.length;
var i__5770__auto___28057 = (0);
while(true){
if((i__5770__auto___28057 < len__5769__auto___28056)){
args__5775__auto__.push((arguments[i__5770__auto___28057]));

var G__28058 = (i__5770__auto___28057 + (1));
i__5770__auto___28057 = G__28058;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28055){var e = e28055;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq28054){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28054));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28061 = arguments.length;
var i__5770__auto___28062 = (0);
while(true){
if((i__5770__auto___28062 < len__5769__auto___28061)){
args__5775__auto__.push((arguments[i__5770__auto___28062]));

var G__28063 = (i__5770__auto___28062 + (1));
i__5770__auto___28062 = G__28063;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e28060){var e = e28060;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq28059){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28059));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28066 = arguments.length;
var i__5770__auto___28067 = (0);
while(true){
if((i__5770__auto___28067 < len__5769__auto___28066)){
args__5775__auto__.push((arguments[i__5770__auto___28067]));

var G__28068 = (i__5770__auto___28067 + (1));
i__5770__auto___28067 = G__28068;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e28065){var e = e28065;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq28064){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28064));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28071 = arguments.length;
var i__5770__auto___28072 = (0);
while(true){
if((i__5770__auto___28072 < len__5769__auto___28071)){
args__5775__auto__.push((arguments[i__5770__auto___28072]));

var G__28073 = (i__5770__auto___28072 + (1));
i__5770__auto___28072 = G__28073;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e28070){var e = e28070;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq28069){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28069));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28076 = arguments.length;
var i__5770__auto___28077 = (0);
while(true){
if((i__5770__auto___28077 < len__5769__auto___28076)){
args__5775__auto__.push((arguments[i__5770__auto___28077]));

var G__28078 = (i__5770__auto___28077 + (1));
i__5770__auto___28077 = G__28078;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e28075){var e = e28075;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq28074){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28074));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28081 = arguments.length;
var i__5770__auto___28082 = (0);
while(true){
if((i__5770__auto___28082 < len__5769__auto___28081)){
args__5775__auto__.push((arguments[i__5770__auto___28082]));

var G__28083 = (i__5770__auto___28082 + (1));
i__5770__auto___28082 = G__28083;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e28080){var e = e28080;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq28079){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28079));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__28085 = arguments.length;
switch (G__28085) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28113){
var state_val_28114 = (state_28113[(1)]);
if((state_val_28114 === (7))){
var inst_28098 = (state_28113[(7)]);
var inst_28101 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28098,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_28113__$1 = state_28113;
var statearr_28115_28201 = state_28113__$1;
(statearr_28115_28201[(2)] = inst_28101);

(statearr_28115_28201[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28114 === (1))){
var state_28113__$1 = state_28113;
var statearr_28116_28202 = state_28113__$1;
(statearr_28116_28202[(2)] = null);

(statearr_28116_28202[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28114 === (4))){
var inst_28086 = (state_28113[(2)]);
var state_28113__$1 = state_28113;
var statearr_28117_28203 = state_28113__$1;
(statearr_28117_28203[(2)] = inst_28086);

(statearr_28117_28203[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28114 === (6))){
var inst_28098 = (state_28113[(7)]);
var inst_28098__$1 = (state_28113[(2)]);
var inst_28099 = fluree.db.util.core.exception_QMARK_(inst_28098__$1);
var state_28113__$1 = (function (){var statearr_28118 = state_28113;
(statearr_28118[(7)] = inst_28098__$1);

return statearr_28118;
})();
if(inst_28099){
var statearr_28119_28204 = state_28113__$1;
(statearr_28119_28204[(1)] = (7));

} else {
var statearr_28120_28205 = state_28113__$1;
(statearr_28120_28205[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28114 === (3))){
var inst_28111 = (state_28113[(2)]);
var state_28113__$1 = state_28113;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28113__$1,inst_28111);
} else {
if((state_val_28114 === (2))){
var inst_28092 = (state_28113[(8)]);
var _ = (function (){var statearr_28122 = state_28113;
(statearr_28122[(4)] = cljs.core.cons((5),(state_28113[(4)])));

return statearr_28122;
})();
var inst_28092__$1 = cljs.core.volatile_BANG_((0));
var inst_28093 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_28094 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_28093,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_28092__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000)], 0));
var inst_28095 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_28094);
var inst_28096 = fluree.db.query.fql.query(db,inst_28095);
var state_28113__$1 = (function (){var statearr_28123 = state_28113;
(statearr_28123[(8)] = inst_28092__$1);

return statearr_28123;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28113__$1,(6),inst_28096);
} else {
if((state_val_28114 === (9))){
var inst_28108 = (state_28113[(2)]);
var _ = (function (){var statearr_28124 = state_28113;
(statearr_28124[(4)] = cljs.core.rest((state_28113[(4)])));

return statearr_28124;
})();
var state_28113__$1 = state_28113;
var statearr_28125_28206 = state_28113__$1;
(statearr_28125_28206[(2)] = inst_28108);

(statearr_28125_28206[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28114 === (5))){
var _ = (function (){var statearr_28126 = state_28113;
(statearr_28126[(4)] = cljs.core.rest((state_28113[(4)])));

return statearr_28126;
})();
var state_28113__$1 = state_28113;
var ex28121 = (state_28113__$1[(2)]);
var statearr_28127_28207 = state_28113__$1;
(statearr_28127_28207[(5)] = ex28121);


if((ex28121 instanceof Error)){
var statearr_28128_28208 = state_28113__$1;
(statearr_28128_28208[(1)] = (4));

(statearr_28128_28208[(5)] = null);

} else {
throw ex28121;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28114 === (8))){
var inst_28092 = (state_28113[(8)]);
var inst_28098 = (state_28113[(7)]);
var inst_28103 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28104 = cljs.core.deref(inst_28092);
var inst_28105 = [inst_28098,inst_28104];
var inst_28106 = (new cljs.core.PersistentVector(null,2,(5),inst_28103,inst_28105,null));
var state_28113__$1 = state_28113;
var statearr_28129_28209 = state_28113__$1;
(statearr_28129_28209[(2)] = inst_28106);

(statearr_28129_28209[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2727__auto____0 = (function (){
var statearr_28130 = [null,null,null,null,null,null,null,null,null];
(statearr_28130[(0)] = fluree$db$dbfunctions$internal$state_machine__2727__auto__);

(statearr_28130[(1)] = (1));

return statearr_28130;
});
var fluree$db$dbfunctions$internal$state_machine__2727__auto____1 = (function (state_28113){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28113);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28131){var ex__2730__auto__ = e28131;
var statearr_28132_28210 = state_28113;
(statearr_28132_28210[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28113[(4)]))){
var statearr_28133_28211 = state_28113;
(statearr_28133_28211[(1)] = cljs.core.first((state_28113[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28212 = state_28113;
state_28113 = G__28212;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2727__auto__ = function(state_28113){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____1.call(this,state_28113);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28134 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_28134[(6)] = c__2749__auto__);

return statearr_28134;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28179){
var state_val_28180 = (state_28179[(1)]);
if((state_val_28180 === (7))){
var inst_28165 = (state_28179[(2)]);
var inst_28166 = fluree.db.query.fql.query(db,inst_28165);
var state_28179__$1 = state_28179;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28179__$1,(8),inst_28166);
} else {
if((state_val_28180 === (1))){
var inst_28135 = typeof select === 'string';
var state_28179__$1 = state_28179;
if(cljs.core.truth_(inst_28135)){
var statearr_28181_28213 = state_28179__$1;
(statearr_28181_28213[(1)] = (2));

} else {
var statearr_28182_28214 = state_28179__$1;
(statearr_28182_28214[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28180 === (4))){
var inst_28148 = (state_28179[(7)]);
var inst_28141 = (state_28179[(8)]);
var inst_28140 = (state_28179[(2)]);
var inst_28141__$1 = cljs.core.volatile_BANG_((0));
var inst_28142 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28143 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_28144 = [inst_28141__$1,(100000)];
var inst_28145 = cljs.core.PersistentHashMap.fromArrays(inst_28143,inst_28144);
var inst_28146 = [inst_28140,from,where,block,limit,inst_28145];
var inst_28147 = cljs.core.PersistentHashMap.fromArrays(inst_28142,inst_28146);
var inst_28148__$1 = fluree.db.util.core.without_nils(inst_28147);
var inst_28149 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28148__$1);
var inst_28150 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28148__$1);
var inst_28151 = cljs.core.first(inst_28150);
var inst_28152 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28151], 0));
var inst_28153 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_28152);
var inst_28154 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28148__$1);
var inst_28155 = cljs.core.last(inst_28154);
var inst_28156 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28155], 0));
var inst_28157 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_28156);
var inst_28158 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28149,inst_28153,inst_28157], 0));
var state_28179__$1 = (function (){var statearr_28183 = state_28179;
(statearr_28183[(7)] = inst_28148__$1);

(statearr_28183[(8)] = inst_28141__$1);

return statearr_28183;
})();
if(cljs.core.truth_(inst_28158)){
var statearr_28184_28215 = state_28179__$1;
(statearr_28184_28215[(1)] = (5));

} else {
var statearr_28185_28216 = state_28179__$1;
(statearr_28185_28216[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28180 === (6))){
var inst_28148 = (state_28179[(7)]);
var state_28179__$1 = state_28179;
var statearr_28186_28217 = state_28179__$1;
(statearr_28186_28217[(2)] = inst_28148);

(statearr_28186_28217[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28180 === (3))){
var state_28179__$1 = state_28179;
var statearr_28187_28218 = state_28179__$1;
(statearr_28187_28218[(2)] = select);

(statearr_28187_28218[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28180 === (2))){
var inst_28137 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_28179__$1 = state_28179;
var statearr_28188_28219 = state_28179__$1;
(statearr_28188_28219[(2)] = inst_28137);

(statearr_28188_28219[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28180 === (11))){
var inst_28177 = (state_28179[(2)]);
var state_28179__$1 = state_28179;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28179__$1,inst_28177);
} else {
if((state_val_28180 === (9))){
var inst_28168 = (state_28179[(9)]);
var state_28179__$1 = state_28179;
var statearr_28189_28220 = state_28179__$1;
(statearr_28189_28220[(2)] = inst_28168);

(statearr_28189_28220[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28180 === (5))){
var inst_28148 = (state_28179[(7)]);
var inst_28160 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28148);
var inst_28161 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_28160);
var inst_28162 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_28148,new cljs.core.Keyword(null,"where","where",-2044795965),inst_28161);
var state_28179__$1 = state_28179;
var statearr_28190_28221 = state_28179__$1;
(statearr_28190_28221[(2)] = inst_28162);

(statearr_28190_28221[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28180 === (10))){
var inst_28141 = (state_28179[(8)]);
var inst_28168 = (state_28179[(9)]);
var inst_28172 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28173 = cljs.core.deref(inst_28141);
var inst_28174 = [inst_28168,inst_28173];
var inst_28175 = (new cljs.core.PersistentVector(null,2,(5),inst_28172,inst_28174,null));
var state_28179__$1 = state_28179;
var statearr_28191_28222 = state_28179__$1;
(statearr_28191_28222[(2)] = inst_28175);

(statearr_28191_28222[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28180 === (8))){
var inst_28168 = (state_28179[(9)]);
var inst_28168__$1 = (state_28179[(2)]);
var inst_28169 = fluree.db.util.core.exception_QMARK_(inst_28168__$1);
var state_28179__$1 = (function (){var statearr_28192 = state_28179;
(statearr_28192[(9)] = inst_28168__$1);

return statearr_28192;
})();
if(inst_28169){
var statearr_28193_28223 = state_28179__$1;
(statearr_28193_28223[(1)] = (9));

} else {
var statearr_28194_28224 = state_28179__$1;
(statearr_28194_28224[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2727__auto____0 = (function (){
var statearr_28195 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28195[(0)] = fluree$db$dbfunctions$internal$state_machine__2727__auto__);

(statearr_28195[(1)] = (1));

return statearr_28195;
});
var fluree$db$dbfunctions$internal$state_machine__2727__auto____1 = (function (state_28179){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28179);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28196){var ex__2730__auto__ = e28196;
var statearr_28197_28225 = state_28179;
(statearr_28197_28225[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28179[(4)]))){
var statearr_28198_28226 = state_28179;
(statearr_28198_28226[(1)] = cljs.core.first((state_28179[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28227 = state_28179;
state_28179 = G__28227;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2727__auto__ = function(state_28179){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____1.call(this,state_28179);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28199 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_28199[(6)] = c__2749__auto__);

return statearr_28199;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__28231 = path;
var vec__28232 = G__28231;
var seq__28233 = cljs.core.seq(vec__28232);
var first__28234 = cljs.core.first(seq__28233);
var seq__28233__$1 = cljs.core.next(seq__28233);
var var$ = first__28234;
var r = seq__28233__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__28231__$1 = G__28231;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__28238 = G__28231__$1;
var seq__28239 = cljs.core.seq(vec__28238);
var first__28240 = cljs.core.first(seq__28239);
var seq__28239__$1 = cljs.core.next(seq__28239);
var var$__$1 = first__28240;
var r__$1 = seq__28239__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__28241 = r__$1;
var G__28242 = n__$2;
var G__28243 = next_clauses;
G__28231__$1 = G__28241;
n__$1 = G__28242;
where_clauses__$1 = G__28243;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__28244 = r__$1;
var G__28245 = next_n;
var G__28246 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__28231__$1 = G__28244;
n__$1 = G__28245;
where_clauses__$1 = G__28246;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28283){
var state_val_28284 = (state_28283[(1)]);
if((state_val_28284 === (7))){
var inst_28256 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28257 = [path];
var inst_28258 = (new cljs.core.PersistentVector(null,1,(5),inst_28256,inst_28257,null));
var state_28283__$1 = state_28283;
var statearr_28285_28313 = state_28283__$1;
(statearr_28285_28313[(2)] = inst_28258);

(statearr_28285_28313[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28284 === (1))){
var state_28283__$1 = state_28283;
var statearr_28286_28314 = state_28283__$1;
(statearr_28286_28314[(2)] = null);

(statearr_28286_28314[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28284 === (4))){
var inst_28247 = (state_28283[(2)]);
var state_28283__$1 = state_28283;
var statearr_28287_28315 = state_28283__$1;
(statearr_28287_28315[(2)] = inst_28247);

(statearr_28287_28315[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28284 === (13))){
var inst_28274 = (state_28283[(2)]);
var inst_28275 = fluree.db.util.async.throw_err(inst_28274);
var _ = (function (){var statearr_28288 = state_28283;
(statearr_28288[(4)] = cljs.core.rest((state_28283[(4)])));

return statearr_28288;
})();
var state_28283__$1 = state_28283;
var statearr_28289_28316 = state_28283__$1;
(statearr_28289_28316[(2)] = inst_28275);

(statearr_28289_28316[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28284 === (6))){
var state_28283__$1 = state_28283;
var statearr_28291_28317 = state_28283__$1;
(statearr_28291_28317[(2)] = path);

(statearr_28291_28317[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28284 === (3))){
var inst_28281 = (state_28283[(2)]);
var state_28283__$1 = state_28283;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28283__$1,inst_28281);
} else {
if((state_val_28284 === (12))){
var _ = (function (){var statearr_28292 = state_28283;
(statearr_28292[(4)] = cljs.core.rest((state_28283[(4)])));

return statearr_28292;
})();
var state_28283__$1 = state_28283;
var ex28290 = (state_28283__$1[(2)]);
var statearr_28293_28318 = state_28283__$1;
(statearr_28293_28318[(5)] = ex28290);


var statearr_28294_28319 = state_28283__$1;
(statearr_28294_28319[(1)] = (11));

(statearr_28294_28319[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28284 === (2))){
var _ = (function (){var statearr_28295 = state_28283;
(statearr_28295[(4)] = cljs.core.cons((5),(state_28283[(4)])));

return statearr_28295;
})();
var inst_28253 = cljs.core.vector_QMARK_(path);
var state_28283__$1 = state_28283;
if(inst_28253){
var statearr_28296_28320 = state_28283__$1;
(statearr_28296_28320[(1)] = (6));

} else {
var statearr_28297_28321 = state_28283__$1;
(statearr_28297_28321[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28284 === (11))){
var inst_28260 = (state_28283[(7)]);
var inst_28265 = (state_28283[(2)]);
var inst_28266 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28265,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_28260,endSubject], 0));
var state_28283__$1 = state_28283;
var statearr_28299_28322 = state_28283__$1;
(statearr_28299_28322[(2)] = inst_28266);

(statearr_28299_28322[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28284 === (9))){
var inst_28264 = (state_28283[(8)]);
var _ = (function (){var statearr_28300 = state_28283;
(statearr_28300[(4)] = cljs.core.cons((12),(state_28283[(4)])));

return statearr_28300;
})();
var inst_28272 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_28264);
var state_28283__$1 = state_28283;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28283__$1,(13),inst_28272);
} else {
if((state_val_28284 === (5))){
var _ = (function (){var statearr_28301 = state_28283;
(statearr_28301[(4)] = cljs.core.rest((state_28283[(4)])));

return statearr_28301;
})();
var state_28283__$1 = state_28283;
var ex28298 = (state_28283__$1[(2)]);
var statearr_28302_28323 = state_28283__$1;
(statearr_28302_28323[(5)] = ex28298);


if((ex28298 instanceof Error)){
var statearr_28303_28324 = state_28283__$1;
(statearr_28303_28324[(1)] = (4));

(statearr_28303_28324[(5)] = null);

} else {
throw ex28298;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28284 === (10))){
var inst_28278 = (state_28283[(2)]);
var _ = (function (){var statearr_28304 = state_28283;
(statearr_28304[(4)] = cljs.core.rest((state_28283[(4)])));

return statearr_28304;
})();
var state_28283__$1 = state_28283;
var statearr_28305_28325 = state_28283__$1;
(statearr_28305_28325[(2)] = inst_28278);

(statearr_28305_28325[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28284 === (8))){
var inst_28260 = (state_28283[(7)]);
var inst_28260__$1 = (state_28283[(2)]);
var inst_28261 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_28260__$1,endSubject);
var inst_28262 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_28263 = ["?var1",inst_28261];
var inst_28264 = cljs.core.PersistentHashMap.fromArrays(inst_28262,inst_28263);
var state_28283__$1 = (function (){var statearr_28306 = state_28283;
(statearr_28306[(7)] = inst_28260__$1);

(statearr_28306[(8)] = inst_28264);

return statearr_28306;
})();
var statearr_28307_28326 = state_28283__$1;
(statearr_28307_28326[(2)] = null);

(statearr_28307_28326[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_28308 = [null,null,null,null,null,null,null,null,null];
(statearr_28308[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__);

(statearr_28308[(1)] = (1));

return statearr_28308;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____1 = (function (state_28283){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28283);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28309){var ex__2730__auto__ = e28309;
var statearr_28310_28327 = state_28283;
(statearr_28310_28327[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28283[(4)]))){
var statearr_28311_28328 = state_28283;
(statearr_28311_28328[(1)] = cljs.core.first((state_28283[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28329 = state_28283;
state_28283 = G__28329;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__ = function(state_28283){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____1.call(this,state_28283);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28312 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_28312[(6)] = c__2749__auto__);

return statearr_28312;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e28330){var e = e28330;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e28331){var e = e28331;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e28332){var e = e28332;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Retrieve's a subject's predicate value by doing a lookup.
 *   If multi returns a vector, else a single value.
 */
fluree.db.dbfunctions.internal.get_subj_pred = (function fluree$db$dbfunctions$internal$get_subj_pred(db,sid,pred){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28386){
var state_val_28387 = (state_28386[(1)]);
if((state_val_28387 === (7))){
var state_28386__$1 = state_28386;
var statearr_28388_28426 = state_28386__$1;
(statearr_28388_28426[(2)] = pred);

(statearr_28388_28426[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (20))){
var inst_28365 = (state_28386[(7)]);
var inst_28369 = (state_28386[(8)]);
var inst_28373 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_28369,inst_28365);
var state_28386__$1 = state_28386;
var statearr_28389_28427 = state_28386__$1;
(statearr_28389_28427[(2)] = inst_28373);

(statearr_28389_28427[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (1))){
var state_28386__$1 = state_28386;
var statearr_28390_28428 = state_28386__$1;
(statearr_28390_28428[(2)] = null);

(statearr_28390_28428[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (4))){
var inst_28333 = (state_28386[(2)]);
var state_28386__$1 = state_28386;
var statearr_28391_28429 = state_28386__$1;
(statearr_28391_28429[(2)] = inst_28333);

(statearr_28391_28429[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (15))){
var state_28386__$1 = state_28386;
var statearr_28392_28430 = state_28386__$1;
(statearr_28392_28430[(2)] = fluree.db.flake.o);

(statearr_28392_28430[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (21))){
var inst_28365 = (state_28386[(7)]);
var inst_28369 = (state_28386[(8)]);
var inst_28375 = cljs.core.first(inst_28365);
var inst_28376 = (inst_28369.cljs$core$IFn$_invoke$arity$1 ? inst_28369.cljs$core$IFn$_invoke$arity$1(inst_28375) : inst_28369.call(null,inst_28375));
var state_28386__$1 = state_28386;
var statearr_28393_28431 = state_28386__$1;
(statearr_28393_28431[(2)] = inst_28376);

(statearr_28393_28431[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (13))){
var inst_28362 = (state_28386[(2)]);
var inst_28363 = fluree.db.util.async.throw_err(inst_28362);
var state_28386__$1 = state_28386;
var statearr_28394_28432 = state_28386__$1;
(statearr_28394_28432[(2)] = inst_28363);

(statearr_28394_28432[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (22))){
var inst_28378 = (state_28386[(2)]);
var state_28386__$1 = state_28386;
var statearr_28395_28433 = state_28386__$1;
(statearr_28395_28433[(2)] = inst_28378);

(statearr_28395_28433[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (6))){
var inst_28343 = clojure.string.replace(pred,"/_","/");
var state_28386__$1 = state_28386;
var statearr_28396_28434 = state_28386__$1;
(statearr_28396_28434[(2)] = inst_28343);

(statearr_28396_28434[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (17))){
var inst_28347 = (state_28386[(9)]);
var state_28386__$1 = state_28386;
if(cljs.core.truth_(inst_28347)){
var statearr_28397_28435 = state_28386__$1;
(statearr_28397_28435[(1)] = (20));

} else {
var statearr_28398_28436 = state_28386__$1;
(statearr_28398_28436[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (3))){
var inst_28384 = (state_28386[(2)]);
var state_28386__$1 = state_28386;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28386__$1,inst_28384);
} else {
if((state_val_28387 === (12))){
var inst_28354 = (state_28386[(2)]);
var inst_28355 = fluree.db.util.async.throw_err(inst_28354);
var state_28386__$1 = state_28386;
var statearr_28399_28437 = state_28386__$1;
(statearr_28399_28437[(2)] = inst_28355);

(statearr_28399_28437[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (2))){
var inst_28341 = (state_28386[(10)]);
var _ = (function (){var statearr_28400 = state_28386;
(statearr_28400[(4)] = cljs.core.cons((5),(state_28386[(4)])));

return statearr_28400;
})();
var inst_28339 = typeof pred === 'string';
var inst_28340 = cljs.core.re_matches(/.+\/_.+/,pred);
var inst_28341__$1 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28339,inst_28340], 0));
var state_28386__$1 = (function (){var statearr_28401 = state_28386;
(statearr_28401[(10)] = inst_28341__$1);

return statearr_28401;
})();
if(cljs.core.truth_(inst_28341__$1)){
var statearr_28402_28438 = state_28386__$1;
(statearr_28402_28438[(1)] = (6));

} else {
var statearr_28403_28439 = state_28386__$1;
(statearr_28403_28439[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (19))){
var inst_28381 = (state_28386[(2)]);
var _ = (function (){var statearr_28404 = state_28386;
(statearr_28404[(4)] = cljs.core.rest((state_28386[(4)])));

return statearr_28404;
})();
var state_28386__$1 = state_28386;
var statearr_28405_28440 = state_28386__$1;
(statearr_28405_28440[(2)] = inst_28381);

(statearr_28405_28440[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (11))){
var inst_28341 = (state_28386[(10)]);
var inst_28365 = (state_28386[(2)]);
var state_28386__$1 = (function (){var statearr_28407 = state_28386;
(statearr_28407[(7)] = inst_28365);

return statearr_28407;
})();
if(cljs.core.truth_(inst_28341)){
var statearr_28408_28441 = state_28386__$1;
(statearr_28408_28441[(1)] = (14));

} else {
var statearr_28409_28442 = state_28386__$1;
(statearr_28409_28442[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (9))){
var inst_28346 = (state_28386[(11)]);
var inst_28349 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28350 = [sid,inst_28346];
var inst_28351 = (new cljs.core.PersistentVector(null,2,(5),inst_28349,inst_28350,null));
var inst_28352 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_28351);
var state_28386__$1 = state_28386;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28386__$1,(12),inst_28352);
} else {
if((state_val_28387 === (5))){
var _ = (function (){var statearr_28410 = state_28386;
(statearr_28410[(4)] = cljs.core.rest((state_28386[(4)])));

return statearr_28410;
})();
var state_28386__$1 = state_28386;
var ex28406 = (state_28386__$1[(2)]);
var statearr_28411_28443 = state_28386__$1;
(statearr_28411_28443[(5)] = ex28406);


if((ex28406 instanceof Error)){
var statearr_28412_28444 = state_28386__$1;
(statearr_28412_28444[(1)] = (4));

(statearr_28412_28444[(5)] = null);

} else {
throw ex28406;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (14))){
var state_28386__$1 = state_28386;
var statearr_28413_28445 = state_28386__$1;
(statearr_28413_28445[(2)] = fluree.db.flake.s);

(statearr_28413_28445[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (16))){
var inst_28365 = (state_28386[(7)]);
var inst_28369 = (state_28386[(2)]);
var inst_28370 = cljs.core.seq(inst_28365);
var state_28386__$1 = (function (){var statearr_28414 = state_28386;
(statearr_28414[(8)] = inst_28369);

return statearr_28414;
})();
if(inst_28370){
var statearr_28415_28446 = state_28386__$1;
(statearr_28415_28446[(1)] = (17));

} else {
var statearr_28416_28447 = state_28386__$1;
(statearr_28416_28447[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (10))){
var inst_28346 = (state_28386[(11)]);
var inst_28357 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28358 = [sid,inst_28346];
var inst_28359 = (new cljs.core.PersistentVector(null,2,(5),inst_28357,inst_28358,null));
var inst_28360 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_28359);
var state_28386__$1 = state_28386;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28386__$1,(13),inst_28360);
} else {
if((state_val_28387 === (18))){
var state_28386__$1 = state_28386;
var statearr_28417_28448 = state_28386__$1;
(statearr_28417_28448[(2)] = null);

(statearr_28417_28448[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (8))){
var inst_28341 = (state_28386[(10)]);
var inst_28346 = (state_28386[(11)]);
var inst_28346__$1 = (state_28386[(2)]);
var inst_28347 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_28346__$1);
var state_28386__$1 = (function (){var statearr_28418 = state_28386;
(statearr_28418[(9)] = inst_28347);

(statearr_28418[(11)] = inst_28346__$1);

return statearr_28418;
})();
if(cljs.core.truth_(inst_28341)){
var statearr_28419_28449 = state_28386__$1;
(statearr_28419_28449[(1)] = (9));

} else {
var statearr_28420_28450 = state_28386__$1;
(statearr_28420_28450[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____0 = (function (){
var statearr_28421 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28421[(0)] = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__);

(statearr_28421[(1)] = (1));

return statearr_28421;
});
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____1 = (function (state_28386){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28386);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28422){var ex__2730__auto__ = e28422;
var statearr_28423_28451 = state_28386;
(statearr_28423_28451[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28386[(4)]))){
var statearr_28424_28452 = state_28386;
(statearr_28424_28452[(1)] = cljs.core.first((state_28386[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28453 = state_28386;
state_28386 = G__28453;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__ = function(state_28386){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____1.call(this,state_28386);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28425 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_28425[(6)] = c__2749__auto__);

return statearr_28425;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e28454){var e = e28454;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28457 = arguments.length;
var i__5770__auto___28458 = (0);
while(true){
if((i__5770__auto___28458 < len__5769__auto___28457)){
args__5775__auto__.push((arguments[i__5770__auto___28458]));

var G__28459 = (i__5770__auto___28458 + (1));
i__5770__auto___28458 = G__28459;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e28456){var e = e28456;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq28455){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28455));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28462 = arguments.length;
var i__5770__auto___28463 = (0);
while(true){
if((i__5770__auto___28463 < len__5769__auto___28462)){
args__5775__auto__.push((arguments[i__5770__auto___28463]));

var G__28464 = (i__5770__auto___28463 + (1));
i__5770__auto___28463 = G__28464;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e28461){var e = e28461;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq28460){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28460));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28467 = arguments.length;
var i__5770__auto___28468 = (0);
while(true){
if((i__5770__auto___28468 < len__5769__auto___28467)){
args__5775__auto__.push((arguments[i__5770__auto___28468]));

var G__28469 = (i__5770__auto___28468 + (1));
i__5770__auto___28468 = G__28469;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__5045__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e28466){var e = e28466;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq28465){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28465));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28472 = arguments.length;
var i__5770__auto___28473 = (0);
while(true){
if((i__5770__auto___28473 < len__5769__auto___28472)){
args__5775__auto__.push((arguments[i__5770__auto___28473]));

var G__28474 = (i__5770__auto___28473 + (1));
i__5770__auto___28473 = G__28474;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e28471){var e = e28471;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq28470){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28470));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e28475){var e = e28475;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e28476){var e = e28476;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e28477){var e = e28477;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e28478){var e = e28478;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e28479){var e = e28479;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows a result set down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__28485 = path;
var vec__28486 = G__28485;
var seq__28487 = cljs.core.seq(vec__28486);
var first__28488 = cljs.core.first(seq__28487);
var seq__28487__$1 = cljs.core.next(seq__28487);
var pred = first__28488;
var r = seq__28487__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__28485__$1 = G__28485;
var subjects__$1 = subjects;
while(true){
var vec__28492 = G__28485__$1;
var seq__28493 = cljs.core.seq(vec__28492);
var first__28494 = cljs.core.first(seq__28493);
var seq__28493__$1 = cljs.core.next(seq__28493);
var pred__$1 = first__28494;
var r__$1 = seq__28493__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__28485__$1,subjects__$1,vec__28492,seq__28493,first__28494,seq__28493__$1,pred__$1,r__$1,subjects__$2,G__28485,vec__28486,seq__28487,first__28488,seq__28487__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__28485__$1,subjects__$1,vec__28492,seq__28493,first__28494,seq__28493__$1,pred__$1,r__$1,subjects__$2,G__28485,vec__28486,seq__28487,first__28488,seq__28487__$1,pred,r,subjects){
return (function (p1__28480_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__28480_SHARP_,pred__$1);
});})(G__28485__$1,subjects__$1,vec__28492,seq__28493,first__28494,seq__28493__$1,pred__$1,r__$1,subjects__$2,G__28485,vec__28486,seq__28487,first__28488,seq__28487__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__28485__$1,subjects__$1,vec__28492,seq__28493,first__28494,seq__28493__$1,pred__$1,r__$1,subjects__$2,G__28485,vec__28486,seq__28487,first__28488,seq__28487__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__5043__auto__ = r__$1;
if(and__5043__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__5043__auto__;
}
})())){
var G__28495 = r__$1;
var G__28496 = next_subjects;
G__28485__$1 = G__28495;
subjects__$1 = G__28496;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e28481){var e = e28481;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Takes a path in a vector format and returns a select statement to crawl those vars.
 *   e.g. convert: ['_user/_auth', 'groupMembership/_user', 'group/_admins']
 *          to: {'_user/_auth' [{'groupMembership/_user' ['group/_admins']}]}
 */
fluree.db.dbfunctions.internal.select_from_path = (function fluree$db$dbfunctions$internal$select_from_path(path){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),fluree.db.dbfunctions.internal.count(path))){
return path;
} else {
var r_path = cljs.core.reverse(path);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([p,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc], null)]);
}),cljs.core.first(r_path),cljs.core.rest(r_path));
}
});
/**
 * Follows a subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.follow_subject = (function fluree$db$dbfunctions$internal$follow_subject(_QMARK_ctx,sid,path){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28536){
var state_val_28537 = (state_28536[(1)]);
if((state_val_28537 === (7))){
var state_28536__$1 = state_28536;
var statearr_28538_28557 = state_28536__$1;
(statearr_28538_28557[(2)] = path);

(statearr_28538_28557[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28537 === (1))){
var state_28536__$1 = state_28536;
var statearr_28539_28558 = state_28536__$1;
(statearr_28539_28558[(2)] = null);

(statearr_28539_28558[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28537 === (4))){
var inst_28497 = (state_28536[(2)]);
var inst_28498 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28497,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([sid,path], 0));
var state_28536__$1 = state_28536;
var statearr_28540_28559 = state_28536__$1;
(statearr_28540_28559[(2)] = inst_28498);

(statearr_28540_28559[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28537 === (6))){
var inst_28515 = (state_28536[(2)]);
var inst_28516 = fluree.db.util.async.throw_err(inst_28515);
var inst_28517 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28516,(0),null);
var inst_28518 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28516,(1),null);
var inst_28519 = cljs.core.last(path);
var inst_28520 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_28519);
var state_28536__$1 = (function (){var statearr_28541 = state_28536;
(statearr_28541[(7)] = inst_28518);

(statearr_28541[(8)] = inst_28517);

return statearr_28541;
})();
if(inst_28520){
var statearr_28542_28560 = state_28536__$1;
(statearr_28542_28560[(1)] = (7));

} else {
var statearr_28543_28561 = state_28536__$1;
(statearr_28543_28561[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28537 === (3))){
var inst_28534 = (state_28536[(2)]);
var state_28536__$1 = state_28536;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28536__$1,inst_28534);
} else {
if((state_val_28537 === (2))){
var _ = (function (){var statearr_28545 = state_28536;
(statearr_28545[(4)] = cljs.core.cons((5),(state_28536[(4)])));

return statearr_28545;
})();
var inst_28507 = fluree.db.dbfunctions.internal.select_from_path(path);
var inst_28508 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28509 = cljs.core.PersistentHashMap.EMPTY;
var inst_28510 = [inst_28507,sid,inst_28509];
var inst_28511 = cljs.core.PersistentHashMap.fromArrays(inst_28508,inst_28510);
var inst_28512 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28513 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_28512,inst_28511);
var state_28536__$1 = state_28536;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28536__$1,(6),inst_28513);
} else {
if((state_val_28537 === (9))){
var inst_28518 = (state_28536[(7)]);
var inst_28517 = (state_28536[(8)]);
var inst_28525 = (state_28536[(2)]);
var inst_28526 = fluree.db.dbfunctions.internal.get_all(inst_28517,inst_28525);
var inst_28527 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28528 = fluree.db.dbfunctions.internal.count(path);
var inst_28529 = fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28518,inst_28528,(9)], 0));
var inst_28530 = [inst_28526,inst_28529];
var inst_28531 = (new cljs.core.PersistentVector(null,2,(5),inst_28527,inst_28530,null));
var _ = (function (){var statearr_28546 = state_28536;
(statearr_28546[(4)] = cljs.core.rest((state_28536[(4)])));

return statearr_28546;
})();
var state_28536__$1 = state_28536;
var statearr_28547_28562 = state_28536__$1;
(statearr_28547_28562[(2)] = inst_28531);

(statearr_28547_28562[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28537 === (5))){
var _ = (function (){var statearr_28548 = state_28536;
(statearr_28548[(4)] = cljs.core.rest((state_28536[(4)])));

return statearr_28548;
})();
var state_28536__$1 = state_28536;
var ex28544 = (state_28536__$1[(2)]);
var statearr_28549_28563 = state_28536__$1;
(statearr_28549_28563[(5)] = ex28544);


var statearr_28550_28564 = state_28536__$1;
(statearr_28550_28564[(1)] = (4));

(statearr_28550_28564[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28537 === (8))){
var inst_28523 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(path,"_id");
var state_28536__$1 = state_28536;
var statearr_28551_28565 = state_28536__$1;
(statearr_28551_28565[(2)] = inst_28523);

(statearr_28551_28565[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____0 = (function (){
var statearr_28552 = [null,null,null,null,null,null,null,null,null];
(statearr_28552[(0)] = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__);

(statearr_28552[(1)] = (1));

return statearr_28552;
});
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____1 = (function (state_28536){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28536);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28553){var ex__2730__auto__ = e28553;
var statearr_28554_28566 = state_28536;
(statearr_28554_28566[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28536[(4)]))){
var statearr_28555_28567 = state_28536;
(statearr_28555_28567[(1)] = cljs.core.first((state_28536[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28568 = state_28536;
state_28536 = G__28568;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__ = function(state_28536){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____1.call(this,state_28536);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28556 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_28556[(6)] = c__2749__auto__);

return statearr_28556;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e28569){var e = e28569;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{if(cljs.core.sequential_QMARK_(key)){
return cljs.core.some((function (p1__28570_SHARP_){
return (fluree.db.dbfunctions.internal.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 ? fluree.db.dbfunctions.internal.contains_QMARK_.cljs$core$IFn$_invoke$arity$2(coll,p1__28570_SHARP_) : fluree.db.dbfunctions.internal.contains_QMARK_.call(null,coll,p1__28570_SHARP_));
}),key);
} else {
return cljs.core.contains_QMARK_(coll,key);
}
}catch (e28571){var e = e28571;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28574 = arguments.length;
var i__5770__auto___28575 = (0);
while(true){
if((i__5770__auto___28575 < len__5769__auto___28574)){
args__5775__auto__.push((arguments[i__5770__auto___28575]));

var G__28576 = (i__5770__auto___28575 + (1));
i__5770__auto___28575 = G__28576;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e28573){var e = e28573;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq28572){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28572));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e28577){var e = e28577;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28580 = arguments.length;
var i__5770__auto___28581 = (0);
while(true){
if((i__5770__auto___28581 < len__5769__auto___28580)){
args__5775__auto__.push((arguments[i__5770__auto___28581]));

var G__28582 = (i__5770__auto___28581 + (1));
i__5770__auto___28581 = G__28582;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e28579){var e = e28579;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq28578){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28578));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e28583){var e = e28583;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28640){
var state_val_28641 = (state_28640[(1)]);
if((state_val_28641 === (7))){
var inst_28586 = (state_28640[(2)]);
var state_28640__$1 = state_28640;
var statearr_28642_28676 = state_28640__$1;
(statearr_28642_28676[(2)] = inst_28586);

(statearr_28642_28676[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28641 === (1))){
var state_28640__$1 = state_28640;
var statearr_28643_28677 = state_28640__$1;
(statearr_28643_28677[(2)] = null);

(statearr_28643_28677[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28641 === (4))){
var inst_28585 = (state_28640[(2)]);
var state_28640__$1 = (function (){var statearr_28644 = state_28640;
(statearr_28644[(7)] = inst_28585);

return statearr_28644;
})();
var statearr_28645_28678 = state_28640__$1;
(statearr_28645_28678[(2)] = null);

(statearr_28645_28678[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28641 === (15))){
var inst_28611 = (state_28640[(8)]);
var inst_28608 = (state_28640[(9)]);
var inst_28620 = (state_28640[(10)]);
var inst_28610 = (state_28640[(11)]);
var inst_28621 = (state_28640[(12)]);
var inst_28623 = (state_28640[(13)]);
var inst_28627 = (function (){var db = inst_28608;
var prevT = inst_28610;
var db_SINGLEQUOTE_ = inst_28611;
var prev_vals = inst_28620;
var fuel = inst_28621;
var G__28622 = inst_28623;
return (function (p1__28584_SHARP_){
var f = p1__28584_SHARP_;
return fluree.db.flake.o(f);
});
})();
var inst_28628 = (inst_28627.cljs$core$IFn$_invoke$arity$1 ? inst_28627.cljs$core$IFn$_invoke$arity$1(inst_28623) : inst_28627.call(null,inst_28623));
var state_28640__$1 = state_28640;
var statearr_28646_28679 = state_28640__$1;
(statearr_28646_28679[(2)] = inst_28628);

(statearr_28646_28679[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28641 === (13))){
var inst_28620 = (state_28640[(10)]);
var inst_28623 = (state_28640[(13)]);
var inst_28619 = (state_28640[(2)]);
var inst_28620__$1 = fluree.db.util.async.throw_err(inst_28619);
var inst_28621 = fluree.db.dbfunctions.internal.count(inst_28620__$1);
var inst_28623__$1 = cljs.core.first(inst_28620__$1);
var inst_28624 = (inst_28623__$1 == null);
var state_28640__$1 = (function (){var statearr_28647 = state_28640;
(statearr_28647[(10)] = inst_28620__$1);

(statearr_28647[(12)] = inst_28621);

(statearr_28647[(13)] = inst_28623__$1);

return statearr_28647;
})();
if(cljs.core.truth_(inst_28624)){
var statearr_28648_28680 = state_28640__$1;
(statearr_28648_28680[(1)] = (14));

} else {
var statearr_28649_28681 = state_28640__$1;
(statearr_28649_28681[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28641 === (6))){
var inst_28595 = (state_28640[(2)]);
var state_28640__$1 = state_28640;
var statearr_28650_28682 = state_28640__$1;
(statearr_28650_28682[(2)] = inst_28595);

(statearr_28650_28682[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28641 === (3))){
var inst_28638 = (state_28640[(2)]);
var state_28640__$1 = state_28640;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28640__$1,inst_28638);
} else {
if((state_val_28641 === (12))){
var inst_28635 = (state_28640[(2)]);
var _ = (function (){var statearr_28651 = state_28640;
(statearr_28651[(4)] = cljs.core.rest((state_28640[(4)])));

return statearr_28651;
})();
var state_28640__$1 = state_28640;
var statearr_28652_28683 = state_28640__$1;
(statearr_28652_28683[(2)] = inst_28635);

(statearr_28652_28683[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28641 === (2))){
var _ = (function (){var statearr_28654 = state_28640;
(statearr_28654[(4)] = cljs.core.cons((9),(state_28640[(4)])));

return statearr_28654;
})();
var inst_28601 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28602 = typeof inst_28601 === 'string';
var state_28640__$1 = state_28640;
if(cljs.core.truth_(inst_28602)){
var statearr_28655_28684 = state_28640__$1;
(statearr_28655_28684[(1)] = (10));

} else {
var statearr_28656_28685 = state_28640__$1;
(statearr_28656_28685[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28641 === (11))){
var inst_28611 = (state_28640[(8)]);
var inst_28608 = (state_28640[(9)]);
var inst_28610 = (state_28640[(11)]);
var inst_28608__$1 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28609 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_28608__$1);
var inst_28610__$1 = fluree.db.dbfunctions.internal.inc(inst_28609);
var inst_28611__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_28608__$1,new cljs.core.Keyword(null,"t","t",-1397832519),inst_28610__$1);
var inst_28612 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28613 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28614 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28615 = [inst_28613,inst_28614];
var inst_28616 = (new cljs.core.PersistentVector(null,2,(5),inst_28612,inst_28615,null));
var inst_28617 = fluree.db.dbproto._search(inst_28611__$1,inst_28616);
var state_28640__$1 = (function (){var statearr_28657 = state_28640;
(statearr_28657[(8)] = inst_28611__$1);

(statearr_28657[(9)] = inst_28608__$1);

(statearr_28657[(11)] = inst_28610__$1);

return statearr_28657;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28640__$1,(13),inst_28617);
} else {
if((state_val_28641 === (9))){
var _ = (function (){var statearr_28658 = state_28640;
(statearr_28658[(4)] = cljs.core.rest((state_28640[(4)])));

return statearr_28658;
})();
var state_28640__$1 = state_28640;
var ex28653 = (state_28640__$1[(2)]);
var statearr_28659_28686 = state_28640__$1;
(statearr_28659_28686[(5)] = ex28653);


var statearr_28660_28687 = state_28640__$1;
(statearr_28660_28687[(1)] = (4));

(statearr_28660_28687[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28641 === (5))){
var inst_28585 = (state_28640[(7)]);
var _ = (function (){var statearr_28661 = state_28640;
(statearr_28661[(4)] = cljs.core.cons((8),(state_28640[(4)])));

return statearr_28661;
})();
var inst_28592 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28585,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_28662 = state_28640;
(statearr_28662[(4)] = cljs.core.rest((state_28640[(4)])));

return statearr_28662;
})();
var state_28640__$1 = state_28640;
var statearr_28663_28688 = state_28640__$1;
(statearr_28663_28688[(2)] = inst_28592);

(statearr_28663_28688[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28641 === (14))){
var state_28640__$1 = state_28640;
var statearr_28664_28689 = state_28640__$1;
(statearr_28664_28689[(2)] = null);

(statearr_28664_28689[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28641 === (16))){
var inst_28621 = (state_28640[(12)]);
var inst_28630 = (state_28640[(2)]);
var inst_28631 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28632 = [inst_28630,inst_28621];
var inst_28633 = (new cljs.core.PersistentVector(null,2,(5),inst_28631,inst_28632,null));
var state_28640__$1 = state_28640;
var statearr_28666_28690 = state_28640__$1;
(statearr_28666_28690[(2)] = inst_28633);

(statearr_28666_28690[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28641 === (10))){
var inst_28604 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28605 = [null,(0)];
var inst_28606 = (new cljs.core.PersistentVector(null,2,(5),inst_28604,inst_28605,null));
var state_28640__$1 = state_28640;
var statearr_28667_28691 = state_28640__$1;
(statearr_28667_28691[(2)] = inst_28606);

(statearr_28667_28691[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28641 === (8))){
var _ = (function (){var statearr_28668 = state_28640;
(statearr_28668[(4)] = cljs.core.rest((state_28640[(4)])));

return statearr_28668;
})();
var state_28640__$1 = state_28640;
var ex28665 = (state_28640__$1[(2)]);
var statearr_28669_28692 = state_28640__$1;
(statearr_28669_28692[(5)] = ex28665);


var statearr_28670_28693 = state_28640__$1;
(statearr_28670_28693[(1)] = (7));

(statearr_28670_28693[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____0 = (function (){
var statearr_28671 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28671[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__);

(statearr_28671[(1)] = (1));

return statearr_28671;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____1 = (function (state_28640){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28640);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28672){var ex__2730__auto__ = e28672;
var statearr_28673_28694 = state_28640;
(statearr_28673_28694[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28640[(4)]))){
var statearr_28674_28695 = state_28640;
(statearr_28674_28695[(1)] = cljs.core.first((state_28640[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28696 = state_28640;
state_28640 = G__28696;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__ = function(state_28640){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____1.call(this,state_28640);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28675 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_28675[(6)] = c__2749__auto__);

return statearr_28675;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28748){
var state_val_28749 = (state_28748[(1)]);
if((state_val_28749 === (7))){
var inst_28698 = (state_28748[(2)]);
var state_28748__$1 = state_28748;
var statearr_28750_28779 = state_28748__$1;
(statearr_28750_28779[(2)] = inst_28698);

(statearr_28750_28779[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28749 === (1))){
var state_28748__$1 = state_28748;
var statearr_28751_28780 = state_28748__$1;
(statearr_28751_28780[(2)] = null);

(statearr_28751_28780[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28749 === (4))){
var inst_28697 = (state_28748[(2)]);
var state_28748__$1 = (function (){var statearr_28752 = state_28748;
(statearr_28752[(7)] = inst_28697);

return statearr_28752;
})();
var statearr_28753_28781 = state_28748__$1;
(statearr_28753_28781[(2)] = null);

(statearr_28753_28781[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28749 === (13))){
var inst_28743 = (state_28748[(2)]);
var _ = (function (){var statearr_28754 = state_28748;
(statearr_28754[(4)] = cljs.core.rest((state_28748[(4)])));

return statearr_28754;
})();
var state_28748__$1 = state_28748;
var statearr_28755_28782 = state_28748__$1;
(statearr_28755_28782[(2)] = inst_28743);

(statearr_28755_28782[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28749 === (6))){
var inst_28707 = (state_28748[(2)]);
var state_28748__$1 = state_28748;
var statearr_28756_28783 = state_28748__$1;
(statearr_28756_28783[(2)] = inst_28707);

(statearr_28756_28783[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28749 === (3))){
var inst_28746 = (state_28748[(2)]);
var state_28748__$1 = state_28748;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28748__$1,inst_28746);
} else {
if((state_val_28749 === (12))){
var inst_28730 = (state_28748[(8)]);
var inst_28739 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28740 = [null,inst_28730];
var inst_28741 = (new cljs.core.PersistentVector(null,2,(5),inst_28739,inst_28740,null));
var state_28748__$1 = state_28748;
var statearr_28757_28784 = state_28748__$1;
(statearr_28757_28784[(2)] = inst_28741);

(statearr_28757_28784[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28749 === (2))){
var _ = (function (){var statearr_28759 = state_28748;
(statearr_28759[(4)] = cljs.core.cons((9),(state_28748[(4)])));

return statearr_28759;
})();
var inst_28716 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28717 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28718 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28719 = [null,pred_name,"?o"];
var inst_28720 = (new cljs.core.PersistentVector(null,3,(5),inst_28718,inst_28719,null));
var inst_28721 = [inst_28720];
var inst_28722 = (new cljs.core.PersistentVector(null,1,(5),inst_28717,inst_28721,null));
var inst_28723 = ["?o",inst_28722,opts];
var inst_28724 = cljs.core.PersistentHashMap.fromArrays(inst_28716,inst_28723);
var inst_28725 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_28724);
var state_28748__$1 = state_28748;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28748__$1,(10),inst_28725);
} else {
if((state_val_28749 === (11))){
var inst_28729 = (state_28748[(9)]);
var inst_28730 = (state_28748[(8)]);
var inst_28734 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28735 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_28729);
var inst_28736 = [inst_28735,inst_28730];
var inst_28737 = (new cljs.core.PersistentVector(null,2,(5),inst_28734,inst_28736,null));
var state_28748__$1 = state_28748;
var statearr_28760_28785 = state_28748__$1;
(statearr_28760_28785[(2)] = inst_28737);

(statearr_28760_28785[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28749 === (9))){
var _ = (function (){var statearr_28761 = state_28748;
(statearr_28761[(4)] = cljs.core.rest((state_28748[(4)])));

return statearr_28761;
})();
var state_28748__$1 = state_28748;
var ex28758 = (state_28748__$1[(2)]);
var statearr_28762_28786 = state_28748__$1;
(statearr_28762_28786[(5)] = ex28758);


var statearr_28763_28787 = state_28748__$1;
(statearr_28763_28787[(1)] = (4));

(statearr_28763_28787[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28749 === (5))){
var inst_28697 = (state_28748[(7)]);
var _ = (function (){var statearr_28765 = state_28748;
(statearr_28765[(4)] = cljs.core.cons((8),(state_28748[(4)])));

return statearr_28765;
})();
var inst_28704 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28697,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_28766 = state_28748;
(statearr_28766[(4)] = cljs.core.rest((state_28748[(4)])));

return statearr_28766;
})();
var state_28748__$1 = state_28748;
var statearr_28767_28788 = state_28748__$1;
(statearr_28767_28788[(2)] = inst_28704);

(statearr_28767_28788[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28749 === (10))){
var inst_28729 = (state_28748[(9)]);
var inst_28727 = (state_28748[(2)]);
var inst_28728 = fluree.db.util.async.throw_err(inst_28727);
var inst_28729__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28728,(0),null);
var inst_28730 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28728,(1),null);
var inst_28731 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_28729__$1);
var inst_28732 = cljs.core.not(inst_28731);
var state_28748__$1 = (function (){var statearr_28768 = state_28748;
(statearr_28768[(9)] = inst_28729__$1);

(statearr_28768[(8)] = inst_28730);

return statearr_28768;
})();
if(inst_28732){
var statearr_28769_28789 = state_28748__$1;
(statearr_28769_28789[(1)] = (11));

} else {
var statearr_28770_28790 = state_28748__$1;
(statearr_28770_28790[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28749 === (8))){
var _ = (function (){var statearr_28771 = state_28748;
(statearr_28771[(4)] = cljs.core.rest((state_28748[(4)])));

return statearr_28771;
})();
var state_28748__$1 = state_28748;
var ex28764 = (state_28748__$1[(2)]);
var statearr_28772_28791 = state_28748__$1;
(statearr_28772_28791[(5)] = ex28764);


var statearr_28773_28792 = state_28748__$1;
(statearr_28773_28792[(1)] = (7));

(statearr_28773_28792[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____0 = (function (){
var statearr_28774 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28774[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__);

(statearr_28774[(1)] = (1));

return statearr_28774;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____1 = (function (state_28748){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28748);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28775){var ex__2730__auto__ = e28775;
var statearr_28776_28793 = state_28748;
(statearr_28776_28793[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28748[(4)]))){
var statearr_28777_28794 = state_28748;
(statearr_28777_28794[(1)] = cljs.core.first((state_28748[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28795 = state_28748;
state_28748 = G__28795;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__ = function(state_28748){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____1.call(this,state_28748);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28778 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_28778[(6)] = c__2749__auto__);

return statearr_28778;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$((function (){var and__5043__auto__ = typeof email === 'string';
if(and__5043__auto__){
return cljs.core.re_matches(pattern,email);
} else {
return and__5043__auto__;
}
})());
}catch (e28796){var e = e28796;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__28798 = arguments.length;
switch (G__28798) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28868){
var state_val_28869 = (state_28868[(1)]);
if((state_val_28869 === (7))){
var inst_28800 = (state_28868[(2)]);
var state_28868__$1 = state_28868;
var statearr_28870_28914 = state_28868__$1;
(statearr_28870_28914[(2)] = inst_28800);

(statearr_28870_28914[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28869 === (20))){
var inst_28844 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28845 = ["*"];
var inst_28846 = (new cljs.core.PersistentVector(null,1,(5),inst_28844,inst_28845,null));
var state_28868__$1 = state_28868;
var statearr_28871_28915 = state_28868__$1;
(statearr_28871_28915[(2)] = inst_28846);

(statearr_28871_28915[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28869 === (1))){
var state_28868__$1 = state_28868;
var statearr_28872_28916 = state_28868__$1;
(statearr_28872_28916[(2)] = null);

(statearr_28872_28916[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28869 === (4))){
var inst_28799 = (state_28868[(2)]);
var state_28868__$1 = (function (){var statearr_28873 = state_28868;
(statearr_28873[(7)] = inst_28799);

return statearr_28873;
})();
var statearr_28874_28917 = state_28868__$1;
(statearr_28874_28917[(2)] = null);

(statearr_28874_28917[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28869 === (15))){
var inst_28863 = (state_28868[(2)]);
var _ = (function (){var statearr_28875 = state_28868;
(statearr_28875[(4)] = cljs.core.rest((state_28868[(4)])));

return statearr_28875;
})();
var state_28868__$1 = state_28868;
var statearr_28876_28918 = state_28868__$1;
(statearr_28876_28918[(2)] = inst_28863);

(statearr_28876_28918[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28869 === (21))){
var inst_28834 = (state_28868[(8)]);
var inst_28827 = (state_28868[(9)]);
var inst_28848 = (state_28868[(2)]);
var inst_28849 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28850 = cljs.core.PersistentHashMap.EMPTY;
var inst_28851 = [inst_28848,inst_28834,inst_28850];
var inst_28852 = cljs.core.PersistentHashMap.fromArrays(inst_28849,inst_28851);
var inst_28853 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_28827,inst_28852);
var state_28868__$1 = state_28868;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28868__$1,(22),inst_28853);
} else {
if((state_val_28869 === (13))){
var inst_28822 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_28868__$1 = state_28868;
var statearr_28877_28919 = state_28868__$1;
(statearr_28877_28919[(2)] = inst_28822);

(statearr_28877_28919[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28869 === (22))){
var inst_28855 = (state_28868[(2)]);
var inst_28856 = fluree.db.util.async.throw_err(inst_28855);
var inst_28857 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28856,(0),null);
var inst_28858 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28856,(1),null);
var inst_28859 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28860 = [inst_28857,inst_28858];
var inst_28861 = (new cljs.core.PersistentVector(null,2,(5),inst_28859,inst_28860,null));
var state_28868__$1 = state_28868;
var statearr_28878_28920 = state_28868__$1;
(statearr_28878_28920[(2)] = inst_28861);

(statearr_28878_28920[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28869 === (6))){
var inst_28809 = (state_28868[(2)]);
var state_28868__$1 = state_28868;
var statearr_28879_28921 = state_28868__$1;
(statearr_28879_28921[(2)] = inst_28809);

(statearr_28879_28921[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28869 === (17))){
var inst_28831 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28832 = fluree.db.dbfunctions.internal.get(inst_28831,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_28868__$1 = state_28868;
var statearr_28880_28922 = state_28868__$1;
(statearr_28880_28922[(2)] = inst_28832);

(statearr_28880_28922[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28869 === (3))){
var inst_28866 = (state_28868[(2)]);
var state_28868__$1 = state_28868;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28868__$1,inst_28866);
} else {
if((state_val_28869 === (12))){
var inst_28820 = (state_28868[(2)]);
var state_28868__$1 = state_28868;
if(cljs.core.truth_(inst_28820)){
var statearr_28881_28923 = state_28868__$1;
(statearr_28881_28923[(1)] = (13));

} else {
var statearr_28882_28924 = state_28868__$1;
(statearr_28882_28924[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28869 === (2))){
var inst_28815 = (state_28868[(10)]);
var _ = (function (){var statearr_28883 = state_28868;
(statearr_28883[(4)] = cljs.core.cons((9),(state_28868[(4)])));

return statearr_28883;
})();
var inst_28815__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_28868__$1 = (function (){var statearr_28884 = state_28868;
(statearr_28884[(10)] = inst_28815__$1);

return statearr_28884;
})();
if(cljs.core.truth_(inst_28815__$1)){
var statearr_28885_28925 = state_28868__$1;
(statearr_28885_28925[(1)] = (10));

} else {
var statearr_28886_28926 = state_28868__$1;
(statearr_28886_28926[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28869 === (19))){
var inst_28836 = cljs.core.PersistentVector.EMPTY;
var inst_28837 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28838 = ["*"];
var inst_28839 = (new cljs.core.PersistentVector(null,1,(5),inst_28837,inst_28838,null));
var inst_28840 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_28841 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_28839,inst_28840);
var inst_28842 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_28836,inst_28841);
var state_28868__$1 = state_28868;
var statearr_28888_28927 = state_28868__$1;
(statearr_28888_28927[(2)] = inst_28842);

(statearr_28888_28927[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28869 === (11))){
var inst_28815 = (state_28868[(10)]);
var state_28868__$1 = state_28868;
var statearr_28889_28928 = state_28868__$1;
(statearr_28889_28928[(2)] = inst_28815);

(statearr_28889_28928[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28869 === (9))){
var _ = (function (){var statearr_28890 = state_28868;
(statearr_28890[(4)] = cljs.core.rest((state_28868[(4)])));

return statearr_28890;
})();
var state_28868__$1 = state_28868;
var ex28887 = (state_28868__$1[(2)]);
var statearr_28891_28929 = state_28868__$1;
(statearr_28891_28929[(5)] = ex28887);


var statearr_28892_28930 = state_28868__$1;
(statearr_28892_28930[(1)] = (4));

(statearr_28892_28930[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28869 === (5))){
var inst_28799 = (state_28868[(7)]);
var _ = (function (){var statearr_28893 = state_28868;
(statearr_28893[(4)] = cljs.core.cons((8),(state_28868[(4)])));

return statearr_28893;
})();
var inst_28806 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28799,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_28894 = state_28868;
(statearr_28894[(4)] = cljs.core.rest((state_28868[(4)])));

return statearr_28894;
})();
var state_28868__$1 = state_28868;
var statearr_28895_28931 = state_28868__$1;
(statearr_28895_28931[(2)] = inst_28806);

(statearr_28895_28931[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28869 === (14))){
var inst_28828 = (state_28868[(11)]);
var inst_28827 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28828__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_28868__$1 = (function (){var statearr_28896 = state_28868;
(statearr_28896[(11)] = inst_28828__$1);

(statearr_28896[(9)] = inst_28827);

return statearr_28896;
})();
if(cljs.core.truth_(inst_28828__$1)){
var statearr_28897_28932 = state_28868__$1;
(statearr_28897_28932[(1)] = (16));

} else {
var statearr_28898_28933 = state_28868__$1;
(statearr_28898_28933[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28869 === (16))){
var inst_28828 = (state_28868[(11)]);
var state_28868__$1 = state_28868;
var statearr_28899_28934 = state_28868__$1;
(statearr_28899_28934[(2)] = inst_28828);

(statearr_28899_28934[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28869 === (10))){
var inst_28817 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_28868__$1 = state_28868;
var statearr_28901_28935 = state_28868__$1;
(statearr_28901_28935[(2)] = inst_28817);

(statearr_28901_28935[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28869 === (18))){
var inst_28834 = (state_28868[(2)]);
var state_28868__$1 = (function (){var statearr_28902 = state_28868;
(statearr_28902[(8)] = inst_28834);

return statearr_28902;
})();
if(cljs.core.truth_(additional_params)){
var statearr_28903_28936 = state_28868__$1;
(statearr_28903_28936[(1)] = (19));

} else {
var statearr_28904_28937 = state_28868__$1;
(statearr_28904_28937[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28869 === (8))){
var _ = (function (){var statearr_28905 = state_28868;
(statearr_28905[(4)] = cljs.core.rest((state_28868[(4)])));

return statearr_28905;
})();
var state_28868__$1 = state_28868;
var ex28900 = (state_28868__$1[(2)]);
var statearr_28906_28938 = state_28868__$1;
(statearr_28906_28938[(5)] = ex28900);


var statearr_28907_28939 = state_28868__$1;
(statearr_28907_28939[(1)] = (7));

(statearr_28907_28939[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2727__auto____0 = (function (){
var statearr_28908 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28908[(0)] = fluree$db$dbfunctions$internal$state_machine__2727__auto__);

(statearr_28908[(1)] = (1));

return statearr_28908;
});
var fluree$db$dbfunctions$internal$state_machine__2727__auto____1 = (function (state_28868){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28868);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28909){var ex__2730__auto__ = e28909;
var statearr_28910_28940 = state_28868;
(statearr_28910_28940[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28868[(4)]))){
var statearr_28911_28941 = state_28868;
(statearr_28911_28941[(1)] = cljs.core.first((state_28868[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28942 = state_28868;
state_28868 = G__28942;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2727__auto__ = function(state_28868){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____1.call(this,state_28868);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28912 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_28912[(6)] = c__2749__auto__);

return statearr_28912;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__28944 = arguments.length;
switch (G__28944) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28988){
var state_val_28989 = (state_28988[(1)]);
if((state_val_28989 === (7))){
var inst_28966 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28967 = ["*"];
var inst_28968 = (new cljs.core.PersistentVector(null,1,(5),inst_28966,inst_28967,null));
var state_28988__$1 = state_28988;
var statearr_28990_29010 = state_28988__$1;
(statearr_28990_29010[(2)] = inst_28968);

(statearr_28990_29010[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28989 === (1))){
var state_28988__$1 = state_28988;
var statearr_28991_29011 = state_28988__$1;
(statearr_28991_29011[(2)] = null);

(statearr_28991_29011[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28989 === (4))){
var inst_28945 = (state_28988[(2)]);
var inst_28946 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28945,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_28988__$1 = state_28988;
var statearr_28992_29012 = state_28988__$1;
(statearr_28992_29012[(2)] = inst_28946);

(statearr_28992_29012[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28989 === (6))){
var inst_28958 = cljs.core.PersistentVector.EMPTY;
var inst_28959 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28960 = ["*"];
var inst_28961 = (new cljs.core.PersistentVector(null,1,(5),inst_28959,inst_28960,null));
var inst_28962 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_28963 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_28961,inst_28962);
var inst_28964 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_28958,inst_28963);
var state_28988__$1 = state_28988;
var statearr_28993_29013 = state_28988__$1;
(statearr_28993_29013[(2)] = inst_28964);

(statearr_28993_29013[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28989 === (3))){
var inst_28986 = (state_28988[(2)]);
var state_28988__$1 = state_28988;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28988__$1,inst_28986);
} else {
if((state_val_28989 === (2))){
var _ = (function (){var statearr_28995 = state_28988;
(statearr_28995[(4)] = cljs.core.cons((5),(state_28988[(4)])));

return statearr_28995;
})();
var inst_28955 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28956 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_28988__$1 = (function (){var statearr_28996 = state_28988;
(statearr_28996[(7)] = inst_28955);

(statearr_28996[(8)] = inst_28956);

return statearr_28996;
})();
if(cljs.core.truth_(additional_params)){
var statearr_28997_29014 = state_28988__$1;
(statearr_28997_29014[(1)] = (6));

} else {
var statearr_28998_29015 = state_28988__$1;
(statearr_28998_29015[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28989 === (9))){
var inst_28977 = (state_28988[(2)]);
var inst_28978 = fluree.db.util.async.throw_err(inst_28977);
var inst_28979 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28978,(0),null);
var inst_28980 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28978,(1),null);
var inst_28981 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28982 = [inst_28979,inst_28980];
var inst_28983 = (new cljs.core.PersistentVector(null,2,(5),inst_28981,inst_28982,null));
var _ = (function (){var statearr_28999 = state_28988;
(statearr_28999[(4)] = cljs.core.rest((state_28988[(4)])));

return statearr_28999;
})();
var state_28988__$1 = state_28988;
var statearr_29000_29016 = state_28988__$1;
(statearr_29000_29016[(2)] = inst_28983);

(statearr_29000_29016[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28989 === (5))){
var _ = (function (){var statearr_29001 = state_28988;
(statearr_29001[(4)] = cljs.core.rest((state_28988[(4)])));

return statearr_29001;
})();
var state_28988__$1 = state_28988;
var ex28994 = (state_28988__$1[(2)]);
var statearr_29002_29017 = state_28988__$1;
(statearr_29002_29017[(5)] = ex28994);


var statearr_29003_29018 = state_28988__$1;
(statearr_29003_29018[(1)] = (4));

(statearr_29003_29018[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28989 === (8))){
var inst_28955 = (state_28988[(7)]);
var inst_28956 = (state_28988[(8)]);
var inst_28970 = (state_28988[(2)]);
var inst_28971 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28972 = cljs.core.PersistentHashMap.EMPTY;
var inst_28973 = [inst_28970,inst_28956,inst_28972];
var inst_28974 = cljs.core.PersistentHashMap.fromArrays(inst_28971,inst_28973);
var inst_28975 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_28955,inst_28974);
var state_28988__$1 = state_28988;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28988__$1,(9),inst_28975);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2727__auto____0 = (function (){
var statearr_29004 = [null,null,null,null,null,null,null,null,null];
(statearr_29004[(0)] = fluree$db$dbfunctions$internal$state_machine__2727__auto__);

(statearr_29004[(1)] = (1));

return statearr_29004;
});
var fluree$db$dbfunctions$internal$state_machine__2727__auto____1 = (function (state_28988){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28988);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e29005){var ex__2730__auto__ = e29005;
var statearr_29006_29019 = state_28988;
(statearr_29006_29019[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28988[(4)]))){
var statearr_29007_29020 = state_28988;
(statearr_29007_29020[(1)] = cljs.core.first((state_28988[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29021 = state_28988;
state_28988 = G__29021;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2727__auto__ = function(state_28988){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____1.call(this,state_28988);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_29008 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_29008[(6)] = c__2749__auto__);

return statearr_29008;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_29065){
var state_val_29066 = (state_29065[(1)]);
if((state_val_29066 === (1))){
var state_29065__$1 = state_29065;
var statearr_29067_29081 = state_29065__$1;
(statearr_29067_29081[(2)] = null);

(statearr_29067_29081[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29066 === (2))){
var _ = (function (){var statearr_29068 = state_29065;
(statearr_29068[(4)] = cljs.core.cons((5),(state_29065[(4)])));

return statearr_29068;
})();
var inst_29032 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29033 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29034 = ["_user/_auth"];
var inst_29035 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29036 = ["*"];
var inst_29037 = (new cljs.core.PersistentVector(null,1,(5),inst_29035,inst_29036,null));
var inst_29038 = [inst_29037];
var inst_29039 = cljs.core.PersistentHashMap.fromArrays(inst_29034,inst_29038);
var inst_29040 = [inst_29039];
var inst_29041 = (new cljs.core.PersistentVector(null,1,(5),inst_29033,inst_29040,null));
var inst_29042 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29043 = cljs.core.PersistentHashMap.EMPTY;
var inst_29044 = [inst_29041,inst_29042,inst_29043];
var inst_29045 = cljs.core.PersistentHashMap.fromArrays(inst_29032,inst_29044);
var inst_29046 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29047 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29046,inst_29045);
var state_29065__$1 = state_29065;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29065__$1,(6),inst_29047);
} else {
if((state_val_29066 === (3))){
var inst_29063 = (state_29065[(2)]);
var state_29065__$1 = state_29065;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29065__$1,inst_29063);
} else {
if((state_val_29066 === (4))){
var inst_29022 = (state_29065[(2)]);
var inst_29023 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29022,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_29065__$1 = state_29065;
var statearr_29070_29082 = state_29065__$1;
(statearr_29070_29082[(2)] = inst_29023);

(statearr_29070_29082[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29066 === (5))){
var _ = (function (){var statearr_29071 = state_29065;
(statearr_29071[(4)] = cljs.core.rest((state_29065[(4)])));

return statearr_29071;
})();
var state_29065__$1 = state_29065;
var ex29069 = (state_29065__$1[(2)]);
var statearr_29072_29083 = state_29065__$1;
(statearr_29072_29083[(5)] = ex29069);


var statearr_29073_29084 = state_29065__$1;
(statearr_29073_29084[(1)] = (4));

(statearr_29073_29084[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29066 === (6))){
var inst_29049 = (state_29065[(2)]);
var inst_29050 = fluree.db.util.async.throw_err(inst_29049);
var inst_29051 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29050,(0),null);
var inst_29052 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29050,(1),null);
var inst_29053 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29054 = ["_user/_auth","_id"];
var inst_29055 = (new cljs.core.PersistentVector(null,2,(5),inst_29053,inst_29054,null));
var inst_29056 = fluree.db.dbfunctions.internal.get_in(inst_29051,inst_29055);
var inst_29057 = cljs.core.first(inst_29056);
var inst_29058 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29059 = [inst_29057,inst_29052];
var inst_29060 = (new cljs.core.PersistentVector(null,2,(5),inst_29058,inst_29059,null));
var _ = (function (){var statearr_29074 = state_29065;
(statearr_29074[(4)] = cljs.core.rest((state_29065[(4)])));

return statearr_29074;
})();
var state_29065__$1 = state_29065;
var statearr_29075_29085 = state_29065__$1;
(statearr_29075_29085[(2)] = inst_29060);

(statearr_29075_29085[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____0 = (function (){
var statearr_29076 = [null,null,null,null,null,null,null];
(statearr_29076[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__);

(statearr_29076[(1)] = (1));

return statearr_29076;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____1 = (function (state_29065){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_29065);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e29077){var ex__2730__auto__ = e29077;
var statearr_29078_29086 = state_29065;
(statearr_29078_29086[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_29065[(4)]))){
var statearr_29079_29087 = state_29065;
(statearr_29079_29087[(1)] = cljs.core.first((state_29065[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29088 = state_29065;
state_29065 = G__29088;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__ = function(state_29065){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____1.call(this,state_29065);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_29080 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_29080[(6)] = c__2749__auto__);

return statearr_29080;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_29110){
var state_val_29111 = (state_29110[(1)]);
if((state_val_29111 === (7))){
var inst_29095 = (state_29110[(7)]);
var inst_29099 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29100 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_29099,inst_29095);
var state_29110__$1 = state_29110;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29110__$1,(9),inst_29100);
} else {
if((state_val_29111 === (1))){
var state_29110__$1 = state_29110;
var statearr_29112_29131 = state_29110__$1;
(statearr_29112_29131[(2)] = null);

(statearr_29112_29131[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29111 === (4))){
var inst_29089 = (state_29110[(2)]);
var state_29110__$1 = state_29110;
var statearr_29113_29132 = state_29110__$1;
(statearr_29113_29132[(2)] = inst_29089);

(statearr_29113_29132[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29111 === (6))){
var inst_29095 = (state_29110[(7)]);
var state_29110__$1 = state_29110;
var statearr_29114_29133 = state_29110__$1;
(statearr_29114_29133[(2)] = inst_29095);

(statearr_29114_29133[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29111 === (3))){
var inst_29108 = (state_29110[(2)]);
var state_29110__$1 = state_29110;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29110__$1,inst_29108);
} else {
if((state_val_29111 === (2))){
var inst_29095 = (state_29110[(7)]);
var _ = (function (){var statearr_29116 = state_29110;
(statearr_29116[(4)] = cljs.core.cons((5),(state_29110[(4)])));

return statearr_29116;
})();
var inst_29095__$1 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29096 = typeof inst_29095__$1 === 'number';
var state_29110__$1 = (function (){var statearr_29117 = state_29110;
(statearr_29117[(7)] = inst_29095__$1);

return statearr_29117;
})();
if(cljs.core.truth_(inst_29096)){
var statearr_29118_29134 = state_29110__$1;
(statearr_29118_29134[(1)] = (6));

} else {
var statearr_29119_29135 = state_29110__$1;
(statearr_29119_29135[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29111 === (9))){
var inst_29102 = (state_29110[(2)]);
var inst_29103 = fluree.db.util.async.throw_err(inst_29102);
var state_29110__$1 = state_29110;
var statearr_29120_29136 = state_29110__$1;
(statearr_29120_29136[(2)] = inst_29103);

(statearr_29120_29136[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29111 === (5))){
var _ = (function (){var statearr_29121 = state_29110;
(statearr_29121[(4)] = cljs.core.rest((state_29110[(4)])));

return statearr_29121;
})();
var state_29110__$1 = state_29110;
var ex29115 = (state_29110__$1[(2)]);
var statearr_29122_29137 = state_29110__$1;
(statearr_29122_29137[(5)] = ex29115);


if((ex29115 instanceof Error)){
var statearr_29123_29138 = state_29110__$1;
(statearr_29123_29138[(1)] = (4));

(statearr_29123_29138[(5)] = null);

} else {
throw ex29115;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29111 === (8))){
var inst_29105 = (state_29110[(2)]);
var _ = (function (){var statearr_29124 = state_29110;
(statearr_29124[(4)] = cljs.core.rest((state_29110[(4)])));

return statearr_29124;
})();
var state_29110__$1 = state_29110;
var statearr_29125_29139 = state_29110__$1;
(statearr_29125_29139[(2)] = inst_29105);

(statearr_29125_29139[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____0 = (function (){
var statearr_29126 = [null,null,null,null,null,null,null,null];
(statearr_29126[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__);

(statearr_29126[(1)] = (1));

return statearr_29126;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____1 = (function (state_29110){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_29110);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e29127){var ex__2730__auto__ = e29127;
var statearr_29128_29140 = state_29110;
(statearr_29128_29140[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_29110[(4)]))){
var statearr_29129_29141 = state_29110;
(statearr_29129_29141[(1)] = cljs.core.first((state_29110[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29142 = state_29110;
state_29110 = G__29142;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__ = function(state_29110){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____1.call(this,state_29110);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_29130 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_29130[(6)] = c__2749__auto__);

return statearr_29130;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__29143_SHARP_){
return fluree.db.flake.op(p1__29143_SHARP_) === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29144_SHARP_){
return fluree.db.flake.o(p1__29144_SHARP_);
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e29145){var e = e29145;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__29146_SHARP_){
return fluree.db.flake.op(p1__29146_SHARP_) === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29147_SHARP_){
return fluree.db.flake.o(p1__29147_SHARP_);
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e29148){var e = e29148;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__29150 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__29150);
})() | (0));
return num;
}catch (e29149){var e = e29149;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_29230){
var state_val_29231 = (state_29230[(1)]);
if((state_val_29231 === (7))){
var inst_29169 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_29170 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29171 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29172 = cljs.core.PersistentHashMap.fromArrays(inst_29170,inst_29171);
var inst_29173 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29169,inst_29172);
var inst_29174 = (function(){throw inst_29173})();
var state_29230__$1 = state_29230;
var statearr_29232_29267 = state_29230__$1;
(statearr_29232_29267[(2)] = inst_29174);

(statearr_29232_29267[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29231 === (1))){
var state_29230__$1 = state_29230;
var statearr_29233_29268 = state_29230__$1;
(statearr_29233_29268[(2)] = null);

(statearr_29233_29268[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29231 === (4))){
var inst_29151 = (state_29230[(2)]);
var state_29230__$1 = state_29230;
var statearr_29234_29269 = state_29230__$1;
(statearr_29234_29269[(2)] = inst_29151);

(statearr_29234_29269[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29231 === (15))){
var inst_29214 = (state_29230[(7)]);
var inst_29210 = (state_29230[(2)]);
var inst_29211 = fluree.db.util.async.throw_err(inst_29210);
var inst_29212 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29211,(0),null);
var inst_29213 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29211,(1),null);
var inst_29214__$1 = cljs.core.first(inst_29212);
var inst_29215 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29214__$1,compare_val);
var state_29230__$1 = (function (){var statearr_29235 = state_29230;
(statearr_29235[(8)] = inst_29213);

(statearr_29235[(7)] = inst_29214__$1);

return statearr_29235;
})();
if(inst_29215){
var statearr_29236_29270 = state_29230__$1;
(statearr_29236_29270[(1)] = (16));

} else {
var statearr_29237_29271 = state_29230__$1;
(statearr_29237_29271[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29231 === (13))){
var state_29230__$1 = state_29230;
var statearr_29238_29272 = state_29230__$1;
(statearr_29238_29272[(2)] = null);

(statearr_29238_29272[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29231 === (6))){
var state_29230__$1 = state_29230;
var statearr_29239_29273 = state_29230__$1;
(statearr_29239_29273[(2)] = null);

(statearr_29239_29273[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29231 === (17))){
var inst_29214 = (state_29230[(7)]);
var inst_29218 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29214)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_29219 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29220 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29221 = cljs.core.PersistentHashMap.fromArrays(inst_29219,inst_29220);
var inst_29222 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29218,inst_29221);
var inst_29223 = (function(){throw inst_29222})();
var state_29230__$1 = state_29230;
var statearr_29240_29274 = state_29230__$1;
(statearr_29240_29274[(2)] = inst_29223);

(statearr_29240_29274[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29231 === (3))){
var inst_29228 = (state_29230[(2)]);
var state_29230__$1 = state_29230;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29230__$1,inst_29228);
} else {
if((state_val_29231 === (12))){
var inst_29166 = (state_29230[(9)]);
var inst_29189 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_29166], 0));
var inst_29190 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29191 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29192 = cljs.core.PersistentHashMap.fromArrays(inst_29190,inst_29191);
var inst_29193 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29189,inst_29192);
var inst_29194 = (function(){throw inst_29193})();
var state_29230__$1 = state_29230;
var statearr_29241_29275 = state_29230__$1;
(statearr_29241_29275[(2)] = inst_29194);

(statearr_29241_29275[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29231 === (2))){
var inst_29165 = (state_29230[(10)]);
var inst_29164 = (state_29230[(11)]);
var inst_29163 = (state_29230[(12)]);
var _ = (function (){var statearr_29242 = state_29230;
(statearr_29242[(4)] = cljs.core.cons((5),(state_29230[(4)])));

return statearr_29242;
})();
var inst_29161 = _QMARK_ctx;
var inst_29162 = cljs.core.__destructure_map(inst_29161);
var inst_29163__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29162,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_29164__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29162,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_29165__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29162,new cljs.core.Keyword(null,"db","db",993250759));
var inst_29166 = fluree.db.dbproto._p_prop(inst_29165__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_29164__$1);
var state_29230__$1 = (function (){var statearr_29243 = state_29230;
(statearr_29243[(10)] = inst_29165__$1);

(statearr_29243[(9)] = inst_29166);

(statearr_29243[(11)] = inst_29164__$1);

(statearr_29243[(12)] = inst_29163__$1);

return statearr_29243;
})();
if(cljs.core.truth_(inst_29163__$1)){
var statearr_29244_29276 = state_29230__$1;
(statearr_29244_29276[(1)] = (6));

} else {
var statearr_29245_29277 = state_29230__$1;
(statearr_29245_29277[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29231 === (11))){
var inst_29165 = (state_29230[(10)]);
var inst_29164 = (state_29230[(11)]);
var inst_29186 = (state_29230[(2)]);
var inst_29187 = fluree.db.dbproto._p_prop(inst_29165,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_29164);
var state_29230__$1 = (function (){var statearr_29247 = state_29230;
(statearr_29247[(13)] = inst_29186);

return statearr_29247;
})();
if(cljs.core.truth_(inst_29187)){
var statearr_29248_29278 = state_29230__$1;
(statearr_29248_29278[(1)] = (12));

} else {
var statearr_29249_29279 = state_29230__$1;
(statearr_29249_29279[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29231 === (9))){
var state_29230__$1 = state_29230;
var statearr_29250_29280 = state_29230__$1;
(statearr_29250_29280[(2)] = null);

(statearr_29250_29280[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29231 === (5))){
var _ = (function (){var statearr_29251 = state_29230;
(statearr_29251[(4)] = cljs.core.rest((state_29230[(4)])));

return statearr_29251;
})();
var state_29230__$1 = state_29230;
var ex29246 = (state_29230__$1[(2)]);
var statearr_29252_29281 = state_29230__$1;
(statearr_29252_29281[(5)] = ex29246);


if((ex29246 instanceof Error)){
var statearr_29253_29282 = state_29230__$1;
(statearr_29253_29282[(1)] = (4));

(statearr_29253_29282[(5)] = null);

} else {
throw ex29246;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29231 === (14))){
var inst_29165 = (state_29230[(10)]);
var inst_29166 = (state_29230[(9)]);
var inst_29163 = (state_29230[(12)]);
var inst_29197 = (state_29230[(2)]);
var inst_29198 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29199 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29200 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29201 = [inst_29163,inst_29166,"?current-val"];
var inst_29202 = (new cljs.core.PersistentVector(null,3,(5),inst_29200,inst_29201,null));
var inst_29203 = [inst_29202];
var inst_29204 = (new cljs.core.PersistentVector(null,1,(5),inst_29199,inst_29203,null));
var inst_29205 = cljs.core.PersistentHashMap.EMPTY;
var inst_29206 = ["?current-val",inst_29204,inst_29205];
var inst_29207 = cljs.core.PersistentHashMap.fromArrays(inst_29198,inst_29206);
var inst_29208 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29165,inst_29207);
var state_29230__$1 = (function (){var statearr_29254 = state_29230;
(statearr_29254[(14)] = inst_29197);

return statearr_29254;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29230__$1,(15),inst_29208);
} else {
if((state_val_29231 === (16))){
var state_29230__$1 = state_29230;
var statearr_29255_29283 = state_29230__$1;
(statearr_29255_29283[(2)] = new_val);

(statearr_29255_29283[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29231 === (10))){
var inst_29179 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_29180 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29181 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29182 = cljs.core.PersistentHashMap.fromArrays(inst_29180,inst_29181);
var inst_29183 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29179,inst_29182);
var inst_29184 = (function(){throw inst_29183})();
var state_29230__$1 = state_29230;
var statearr_29256_29284 = state_29230__$1;
(statearr_29256_29284[(2)] = inst_29184);

(statearr_29256_29284[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29231 === (18))){
var inst_29225 = (state_29230[(2)]);
var _ = (function (){var statearr_29257 = state_29230;
(statearr_29257[(4)] = cljs.core.rest((state_29230[(4)])));

return statearr_29257;
})();
var state_29230__$1 = state_29230;
var statearr_29258_29285 = state_29230__$1;
(statearr_29258_29285[(2)] = inst_29225);

(statearr_29258_29285[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29231 === (8))){
var inst_29166 = (state_29230[(9)]);
var inst_29176 = (state_29230[(2)]);
var state_29230__$1 = (function (){var statearr_29259 = state_29230;
(statearr_29259[(15)] = inst_29176);

return statearr_29259;
})();
if(cljs.core.truth_(inst_29166)){
var statearr_29260_29286 = state_29230__$1;
(statearr_29260_29286[(1)] = (9));

} else {
var statearr_29261_29287 = state_29230__$1;
(statearr_29261_29287[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____0 = (function (){
var statearr_29262 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29262[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__);

(statearr_29262[(1)] = (1));

return statearr_29262;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____1 = (function (state_29230){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_29230);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e29263){var ex__2730__auto__ = e29263;
var statearr_29264_29288 = state_29230;
(statearr_29264_29288[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_29230[(4)]))){
var statearr_29265_29289 = state_29230;
(statearr_29265_29289[(1)] = cljs.core.first((state_29230[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29290 = state_29230;
state_29230 = G__29290;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__ = function(state_29230){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____1.call(this,state_29230);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_29266 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_29266[(6)] = c__2749__auto__);

return statearr_29266;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
