// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.analytical_parse');
goog.require('fluree.db.query.subject_crawl.core');
goog.require('fluree.db.query.fql_resp');
/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__24612 = arguments.length;
switch (G__24612) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_(vol,(function (){var G__24613 = cljs.core._deref(vol);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__24613) : f.call(null,G__24613));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_(vol,(function (){var G__24614 = cljs.core._deref(vol);
var G__24615 = arg1;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__24614,G__24615) : f.call(null,G__24614,G__24615));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_(vol,(function (){var G__24616 = cljs.core._deref(vol);
var G__24617 = arg1;
var G__24618 = arg2;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__24616,G__24617,G__24618) : f.call(null,G__24616,G__24617,G__24618));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_(vol,(function (){var G__24619 = cljs.core._deref(vol);
var G__24620 = arg1;
var G__24621 = arg2;
var G__24622 = arg3;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__24619,G__24620,G__24621,G__24622) : f.call(null,G__24619,G__24620,G__24621,G__24622));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__24625 = arguments.length;
switch (G__24625) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__24627 = null;
var G__24627__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__24627__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__24627__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__24627 = function(result,flake){
switch(arguments.length){
case 0:
return G__24627__0.call(this);
case 1:
return G__24627__1.call(this,result);
case 2:
return G__24627__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24627.cljs$core$IFn$_invoke$arity$0 = G__24627__0;
G__24627.cljs$core$IFn$_invoke$arity$1 = G__24627__1;
G__24627.cljs$core$IFn$_invoke$arity$2 = G__24627__2;
return G__24627;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__24628_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__24628_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__24632 = vars;
var vec__24633 = G__24632;
var seq__24634 = cljs.core.seq(vec__24633);
var first__24635 = cljs.core.first(seq__24634);
var seq__24634__$1 = cljs.core.next(seq__24634);
var var$ = first__24635;
var r = seq__24634__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__24632__$1 = G__24632;
var all_vars__$1 = all_vars;
while(true){
var vec__24640 = G__24632__$1;
var seq__24641 = cljs.core.seq(vec__24640);
var first__24642 = cljs.core.first(seq__24641);
var seq__24641__$1 = cljs.core.next(seq__24641);
var var$__$1 = first__24642;
var r__$1 = seq__24641__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__24643 = cljs.core.set(all_vars__$2);
return (fexpr__24643.cljs$core$IFn$_invoke$arity$1 ? fexpr__24643.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__24643.call(null,var$__$1));
})())){
var G__24644 = r__$1;
var G__24645 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__24632__$1 = G__24644;
all_vars__$1 = G__24645;
continue;
} else {
var G__24646 = r__$1;
var G__24647 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__24632__$1 = G__24646;
all_vars__$1 = G__24647;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,select_item){
var temp__5804__auto__ = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5804__auto__)){
var query_map = temp__5804__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__24648){
var vec__24649 = p__24648;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24649,(0),null);
var query_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24649,(1),null);
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tuple_result,tuple_index);
if(cljs.core.truth_(temp__5804__auto__)){
var _id = temp__5804__auto__;
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24663){
var state_val_24664 = (state_24663[(1)]);
if((state_val_24664 === (1))){
var inst_24652 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24653 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_24654 = [query_map,_id,query_opts];
var inst_24655 = cljs.core.PersistentHashMap.fromArrays(inst_24653,inst_24654);
var inst_24656 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_24655) : fluree.db.query.fql.query.call(null,db,inst_24655));
var state_24663__$1 = (function (){var statearr_24665 = state_24663;
(statearr_24665[(7)] = inst_24652);

return statearr_24665;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24663__$1,(2),inst_24656);
} else {
if((state_val_24664 === (2))){
var inst_24652 = (state_24663[(7)]);
var inst_24658 = (state_24663[(2)]);
var inst_24659 = fluree.db.util.async.throw_err(inst_24658);
var inst_24660 = [tuple_index,inst_24659];
var inst_24661 = (new cljs.core.PersistentVector(null,2,(5),inst_24652,inst_24660,null));
var state_24663__$1 = state_24663;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24663__$1,inst_24661);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__2727__auto____0 = (function (){
var statearr_24666 = [null,null,null,null,null,null,null,null];
(statearr_24666[(0)] = fluree$db$query$fql$expand_map_$_state_machine__2727__auto__);

(statearr_24666[(1)] = (1));

return statearr_24666;
});
var fluree$db$query$fql$expand_map_$_state_machine__2727__auto____1 = (function (state_24663){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24663);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24667){var ex__2730__auto__ = e24667;
var statearr_24668_24671 = state_24663;
(statearr_24668_24671[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24663[(4)]))){
var statearr_24669_24672 = state_24663;
(statearr_24669_24672[(1)] = cljs.core.first((state_24663[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24673 = state_24663;
state_24663 = G__24673;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__2727__auto__ = function(state_24663){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__2727__auto____1.call(this,state_24663);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__2727__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__2727__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24670 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24670[(6)] = c__2749__auto__);

return statearr_24670;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_(expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__24674 = expand_map_tuple;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24674,(0),null);
var query_map_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24674,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24737){
var state_val_24738 = (state_24737[(1)]);
if((state_val_24738 === (7))){
var inst_24732 = (state_24737[(2)]);
var _ = (function (){var statearr_24739 = state_24737;
(statearr_24739[(4)] = cljs.core.rest((state_24737[(4)])));

return statearr_24739;
})();
var state_24737__$1 = state_24737;
var statearr_24740_24831 = state_24737__$1;
(statearr_24740_24831[(2)] = inst_24732);

(statearr_24740_24831[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24738 === (20))){
var inst_24723 = (state_24737[(2)]);
var state_24737__$1 = state_24737;
var statearr_24741_24832 = state_24737__$1;
(statearr_24741_24832[(2)] = inst_24723);

(statearr_24741_24832[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24738 === (1))){
var state_24737__$1 = state_24737;
var statearr_24742_24833 = state_24737__$1;
(statearr_24742_24833[(2)] = null);

(statearr_24742_24833[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24738 === (4))){
var inst_24679 = (state_24737[(2)]);
var state_24737__$1 = state_24737;
var statearr_24743_24834 = state_24737__$1;
(statearr_24743_24834[(2)] = inst_24679);

(statearr_24743_24834[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24738 === (15))){
var inst_24699 = (state_24737[(7)]);
var inst_24708 = cljs.core.second(inst_24699);
var inst_24709 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_24708);
var inst_24710 = (inst_24709 > max_fuel);
var state_24737__$1 = state_24737;
if(cljs.core.truth_(inst_24710)){
var statearr_24744_24835 = state_24737__$1;
(statearr_24744_24835[(1)] = (18));

} else {
var statearr_24745_24836 = state_24737__$1;
(statearr_24745_24836[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24738 === (13))){
var state_24737__$1 = state_24737;
var statearr_24746_24837 = state_24737__$1;
(statearr_24746_24837[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24738 === (6))){
var inst_24687 = (state_24737[(8)]);
var state_24737__$1 = state_24737;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24737__$1,(8),inst_24687);
} else {
if((state_val_24738 === (17))){
var inst_24726 = (state_24737[(2)]);
var state_24737__$1 = state_24737;
var statearr_24748_24838 = state_24737__$1;
(statearr_24748_24838[(2)] = inst_24726);

(statearr_24748_24838[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24738 === (3))){
var inst_24735 = (state_24737[(2)]);
var state_24737__$1 = state_24737;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24737__$1,inst_24735);
} else {
if((state_val_24738 === (12))){
var inst_24699 = (state_24737[(7)]);
var inst_24688 = (state_24737[(9)]);
var inst_24705 = (inst_24688.cljs$core$IFn$_invoke$arity$0 ? inst_24688.cljs$core$IFn$_invoke$arity$0() : inst_24688.call(null));
var state_24737__$1 = (function (){var statearr_24749 = state_24737;
(statearr_24749[(10)] = inst_24705);

return statearr_24749;
})();
var statearr_24750_24839 = state_24737__$1;
(statearr_24750_24839[(2)] = inst_24699);

(statearr_24750_24839[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24738 === (2))){
var inst_24687 = (state_24737[(8)]);
var inst_24688 = (state_24737[(9)]);
var _ = (function (){var statearr_24751 = state_24737;
(statearr_24751[(4)] = cljs.core.cons((5),(state_24737[(4)])));

return statearr_24751;
})();
var inst_24685 = fluree.db.query.fql.build_expand_map(select,pp_keys);
var inst_24686 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_24687__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_24688__$1 = (function (){var expandMaps = inst_24685;
var queue_ch = inst_24686;
var res_ch = inst_24687__$1;
return (function (){
cljs.core.async.close_BANG_(queue_ch);

return cljs.core.async.close_BANG_(res_ch);
});
})();
var inst_24689 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667)], 0));
var inst_24690 = cljs.core.volatile_BANG_((0));
var inst_24691 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_24689,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_24690);
var inst_24692 = (function (){var expandMaps = inst_24685;
var queue_ch = inst_24686;
var res_ch = inst_24687__$1;
var stop_BANG_ = inst_24688__$1;
var opts_STAR_ = inst_24691;
return (function (tuple_res,port){
var c__2749__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24784){
var state_val_24785 = (state_24784[(1)]);
if((state_val_24785 === (7))){
var state_24784__$1 = state_24784;
var statearr_24786_24840 = state_24784__$1;
(statearr_24786_24840[(2)] = tuple_res);

(statearr_24786_24840[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24785 === (1))){
var state_24784__$1 = state_24784;
var statearr_24787_24841 = state_24784__$1;
(statearr_24787_24841[(2)] = null);

(statearr_24787_24841[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24785 === (4))){
var inst_24752 = (state_24784[(2)]);
var inst_24753 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_24752);
var inst_24754 = cljs.core.async.close_BANG_(port);
var state_24784__$1 = (function (){var statearr_24788 = state_24784;
(statearr_24788[(7)] = inst_24753);

return statearr_24788;
})();
var statearr_24789_24842 = state_24784__$1;
(statearr_24789_24842[(2)] = inst_24754);

(statearr_24789_24842[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24785 === (6))){
var inst_24761 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24762 = [tuple_res];
var inst_24763 = (new cljs.core.PersistentVector(null,1,(5),inst_24761,inst_24762,null));
var state_24784__$1 = state_24784;
var statearr_24790_24843 = state_24784__$1;
(statearr_24790_24843[(2)] = inst_24763);

(statearr_24790_24843[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24785 === (3))){
var inst_24782 = (state_24784[(2)]);
var state_24784__$1 = state_24784;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24784__$1,inst_24782);
} else {
if((state_val_24785 === (2))){
var ___$1 = (function (){var statearr_24792 = state_24784;
(statearr_24792[(4)] = cljs.core.cons((5),(state_24784[(4)])));

return statearr_24792;
})();
var state_24784__$1 = state_24784;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_24793_24844 = state_24784__$1;
(statearr_24793_24844[(1)] = (6));

} else {
var statearr_24794_24845 = state_24784__$1;
(statearr_24794_24845[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24785 === (9))){
var inst_24768 = (state_24784[(8)]);
var inst_24766 = (state_24784[(9)]);
var inst_24775 = (state_24784[(2)]);
var inst_24776 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.replace_expand_maps,inst_24766,inst_24775);
var inst_24777 = (inst_24768.cljs$core$IFn$_invoke$arity$1 ? inst_24768.cljs$core$IFn$_invoke$arity$1(inst_24776) : inst_24768.call(null,inst_24776));
var inst_24778 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_24777);
var inst_24779 = cljs.core.async.close_BANG_(port);
var ___$1 = (function (){var statearr_24795 = state_24784;
(statearr_24795[(4)] = cljs.core.rest((state_24784[(4)])));

return statearr_24795;
})();
var state_24784__$1 = (function (){var statearr_24796 = state_24784;
(statearr_24796[(10)] = inst_24778);

return statearr_24796;
})();
var statearr_24797_24846 = state_24784__$1;
(statearr_24797_24846[(2)] = inst_24779);

(statearr_24797_24846[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24785 === (5))){
var ___$1 = (function (){var statearr_24798 = state_24784;
(statearr_24798[(4)] = cljs.core.rest((state_24784[(4)])));

return statearr_24798;
})();
var state_24784__$1 = state_24784;
var ex24791 = (state_24784__$1[(2)]);
var statearr_24799_24847 = state_24784__$1;
(statearr_24799_24847[(5)] = ex24791);


var statearr_24800_24848 = state_24784__$1;
(statearr_24800_24848[(1)] = (4));

(statearr_24800_24848[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24785 === (8))){
var inst_24766 = (state_24784[(9)]);
var inst_24766__$1 = (state_24784[(2)]);
var inst_24767 = cljs.core.volatile_BANG_((0));
var inst_24768 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24766__$1;
var query_fuel = inst_24767;
return (function (p1__24678_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(p1__24678_SHARP_),cljs.core.deref(query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__24678_SHARP_,cljs.core.deref(query_fuel)], null);
}
});
})();
var inst_24769 = cljs.core.PersistentVector.EMPTY;
var inst_24770 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24766__$1;
var query_fuel = inst_24767;
return (function (p1__24677_SHARP_){
return fluree.db.query.fql.expand_map(db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_STAR_,new cljs.core.Keyword(null,"fuel","fuel",10405485),fuel),tuple_res_SINGLEQUOTE_,p1__24677_SHARP_);
});
})();
var inst_24771 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_24770,expandMaps);
var inst_24772 = cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1(inst_24771);
var inst_24773 = cljs.core.async.into(inst_24769,inst_24772);
var state_24784__$1 = (function (){var statearr_24801 = state_24784;
(statearr_24801[(8)] = inst_24768);

(statearr_24801[(9)] = inst_24766__$1);

return statearr_24801;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24784__$1,(9),inst_24773);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0 = (function (){
var statearr_24802 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24802[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__);

(statearr_24802[(1)] = (1));

return statearr_24802;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1 = (function (state_24784){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24784);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24803){var ex__2730__auto__ = e24803;
var statearr_24804_24849 = state_24784;
(statearr_24804_24849[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24784[(4)]))){
var statearr_24805_24850 = state_24784;
(statearr_24805_24850[(1)] = cljs.core.first((state_24784[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24851 = state_24784;
state_24784 = G__24851;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__ = function(state_24784){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1.call(this,state_24784);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24806 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24806[(6)] = c__2749__auto____$1);

return statearr_24806;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto____$1;
});
})();
var inst_24693 = cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(inst_24686,tuples_res);
var inst_24694 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_24687__$1,inst_24692,inst_24686);
var inst_24695 = cljs.core.PersistentVector.EMPTY;
var inst_24696 = inst_24695;
var state_24737__$1 = (function (){var statearr_24807 = state_24737;
(statearr_24807[(8)] = inst_24687__$1);

(statearr_24807[(11)] = inst_24693);

(statearr_24807[(12)] = inst_24696);

(statearr_24807[(9)] = inst_24688__$1);

(statearr_24807[(13)] = inst_24694);

return statearr_24807;
})();
var statearr_24808_24852 = state_24737__$1;
(statearr_24808_24852[(2)] = null);

(statearr_24808_24852[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24738 === (19))){
var inst_24699 = (state_24737[(7)]);
var inst_24696 = (state_24737[(12)]);
var inst_24719 = cljs.core.first(inst_24699);
var inst_24720 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24696,inst_24719);
var inst_24696__$1 = inst_24720;
var state_24737__$1 = (function (){var statearr_24809 = state_24737;
(statearr_24809[(12)] = inst_24696__$1);

return statearr_24809;
})();
var statearr_24810_24853 = state_24737__$1;
(statearr_24810_24853[(2)] = null);

(statearr_24810_24853[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24738 === (11))){
var inst_24730 = (state_24737[(2)]);
var state_24737__$1 = state_24737;
var statearr_24812_24854 = state_24737__$1;
(statearr_24812_24854[(2)] = inst_24730);

(statearr_24812_24854[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24738 === (9))){
var inst_24696 = (state_24737[(12)]);
var state_24737__$1 = state_24737;
var statearr_24813_24855 = state_24737__$1;
(statearr_24813_24855[(2)] = inst_24696);

(statearr_24813_24855[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24738 === (5))){
var _ = (function (){var statearr_24814 = state_24737;
(statearr_24814[(4)] = cljs.core.rest((state_24737[(4)])));

return statearr_24814;
})();
var state_24737__$1 = state_24737;
var ex24811 = (state_24737__$1[(2)]);
var statearr_24815_24856 = state_24737__$1;
(statearr_24815_24856[(5)] = ex24811);


if((ex24811 instanceof Error)){
var statearr_24816_24857 = state_24737__$1;
(statearr_24816_24857[(1)] = (4));

(statearr_24816_24857[(5)] = null);

} else {
throw ex24811;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24738 === (14))){
var inst_24728 = (state_24737[(2)]);
var state_24737__$1 = state_24737;
var statearr_24817_24858 = state_24737__$1;
(statearr_24817_24858[(2)] = inst_24728);

(statearr_24817_24858[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24738 === (16))){
var state_24737__$1 = state_24737;
var statearr_24818_24859 = state_24737__$1;
(statearr_24818_24859[(2)] = null);

(statearr_24818_24859[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24738 === (10))){
var inst_24699 = (state_24737[(7)]);
var inst_24703 = fluree.db.util.core.exception_QMARK_(inst_24699);
var state_24737__$1 = state_24737;
if(inst_24703){
var statearr_24819_24860 = state_24737__$1;
(statearr_24819_24860[(1)] = (12));

} else {
var statearr_24820_24861 = state_24737__$1;
(statearr_24820_24861[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24738 === (18))){
var inst_24688 = (state_24737[(9)]);
var inst_24712 = (inst_24688.cljs$core$IFn$_invoke$arity$0 ? inst_24688.cljs$core$IFn$_invoke$arity$0() : inst_24688.call(null));
var inst_24713 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_24714 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_24715 = [new cljs.core.Keyword("db","insufficient-fuel","db/insufficient-fuel",344386102),(400)];
var inst_24716 = cljs.core.PersistentHashMap.fromArrays(inst_24714,inst_24715);
var inst_24717 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_24713,inst_24716);
var state_24737__$1 = (function (){var statearr_24821 = state_24737;
(statearr_24821[(14)] = inst_24712);

return statearr_24821;
})();
var statearr_24822_24862 = state_24737__$1;
(statearr_24822_24862[(2)] = inst_24717);

(statearr_24822_24862[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24738 === (8))){
var inst_24699 = (state_24737[(7)]);
var inst_24699__$1 = (state_24737[(2)]);
var inst_24700 = (inst_24699__$1 == null);
var state_24737__$1 = (function (){var statearr_24823 = state_24737;
(statearr_24823[(7)] = inst_24699__$1);

return statearr_24823;
})();
if(cljs.core.truth_(inst_24700)){
var statearr_24824_24863 = state_24737__$1;
(statearr_24824_24863[(1)] = (9));

} else {
var statearr_24825_24864 = state_24737__$1;
(statearr_24825_24864[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0 = (function (){
var statearr_24826 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24826[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__);

(statearr_24826[(1)] = (1));

return statearr_24826;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1 = (function (state_24737){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24737);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24827){var ex__2730__auto__ = e24827;
var statearr_24828_24865 = state_24737;
(statearr_24828_24865[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24737[(4)]))){
var statearr_24829_24866 = state_24737;
(statearr_24829_24866[(1)] = cljs.core.first((state_24737[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24867 = state_24737;
state_24737 = G__24867;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__ = function(state_24737){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1.call(this,state_24737);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24830 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24830[(6)] = c__2749__auto__);

return statearr_24830;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__24868 = select;
var map__24868__$1 = cljs.core.__destructure_map(map__24868);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24868__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24868__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24868__$1,new cljs.core.Keyword(null,"value","value",305978217));
var select_val = (function (){var or__5045__auto__ = as;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx(headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly(value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?cljs.core.constantly(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__24871 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24871,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24871,(1),null);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24871,(2),null);
var comparator = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?(function (a,b){
return cljs.core.compare(b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("NOCASE",clojure.string.upper_case(option))));
var keyfn = ((no_case_QMARK_)?(function (p1__24869_SHARP_){
return clojure.string.upper_case(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__24869_SHARP_,compare_idx));
}):(function (p1__24870_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__24870_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count(tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__24876 = arguments.length;
switch (G__24876) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__24877,p__24878,group_limit,opts){
var map__24879 = p__24877;
var map__24879__$1 = cljs.core.__destructure_map(map__24879);
var res = map__24879__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24879__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__24880 = p__24878;
var map__24880__$1 = cljs.core.__destructure_map(map__24880);
var select_spec = map__24880__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24880__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24880__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24880__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24880__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24880__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24880__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24880__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24880__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24880__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24880__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25017){
var state_val_25018 = (state_25017[(1)]);
if((state_val_25018 === (7))){
var inst_24887 = (state_25017[(7)]);
var state_25017__$1 = state_25017;
var statearr_25019_25121 = state_25017__$1;
(statearr_25019_25121[(2)] = inst_24887);

(statearr_25019_25121[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (59))){
var inst_25010 = (state_25017[(2)]);
var state_25017__$1 = state_25017;
var statearr_25020_25122 = state_25017__$1;
(statearr_25020_25122[(2)] = inst_25010);

(statearr_25020_25122[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (20))){
var inst_24923 = (state_25017[(8)]);
var inst_24926 = (state_25017[(9)]);
var inst_24922 = (state_25017[(2)]);
var inst_24923__$1 = cljs.core.__destructure_map(inst_24922);
var inst_24924 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24923__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_24925 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24923__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_24926__$1 = offset;
var state_25017__$1 = (function (){var statearr_25021 = state_25017;
(statearr_25021[(8)] = inst_24923__$1);

(statearr_25021[(9)] = inst_24926__$1);

(statearr_25021[(10)] = inst_24924);

(statearr_25021[(11)] = inst_24925);

return statearr_25021;
})();
if(cljs.core.truth_(inst_24926__$1)){
var statearr_25022_25123 = state_25017__$1;
(statearr_25022_25123[(1)] = (21));

} else {
var statearr_25023_25124 = state_25017__$1;
(statearr_25023_25124[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (58))){
var inst_25002 = (state_25017[(12)]);
var state_25017__$1 = state_25017;
var statearr_25024_25125 = state_25017__$1;
(statearr_25024_25125[(2)] = inst_25002);

(statearr_25024_25125[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (60))){
var inst_25006 = (state_25017[(2)]);
var inst_25007 = fluree.db.util.async.throw_err(inst_25006);
var state_25017__$1 = state_25017;
var statearr_25025_25126 = state_25017__$1;
(statearr_25025_25126[(2)] = inst_25007);

(statearr_25025_25126[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (27))){
var inst_24938 = cljs.core.not(inVector_QMARK_);
var state_25017__$1 = state_25017;
var statearr_25026_25127 = state_25017__$1;
(statearr_25026_25127[(2)] = inst_24938);

(statearr_25026_25127[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (1))){
var state_25017__$1 = state_25017;
var statearr_25027_25128 = state_25017__$1;
(statearr_25027_25128[(2)] = null);

(statearr_25027_25128[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (24))){
var state_25017__$1 = state_25017;
var statearr_25028_25129 = state_25017__$1;
(statearr_25028_25129[(2)] = offset);

(statearr_25028_25129[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (55))){
var inst_24996 = (state_25017[(13)]);
var state_25017__$1 = state_25017;
var statearr_25029_25130 = state_25017__$1;
(statearr_25029_25130[(2)] = inst_24996);

(statearr_25029_25130[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (39))){
var inst_24964 = (state_25017[(14)]);
var inst_24966 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_24967 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24964,inst_24966);
var state_25017__$1 = state_25017;
var statearr_25030_25131 = state_25017__$1;
(statearr_25030_25131[(2)] = inst_24967);

(statearr_25030_25131[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (46))){
var inst_24976 = (state_25017[(15)]);
var state_25017__$1 = state_25017;
var statearr_25031_25132 = state_25017__$1;
(statearr_25031_25132[(2)] = inst_24976);

(statearr_25031_25132[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (4))){
var inst_24881 = (state_25017[(2)]);
var state_25017__$1 = state_25017;
var statearr_25032_25133 = state_25017__$1;
(statearr_25032_25133[(2)] = inst_24881);

(statearr_25032_25133[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (54))){
var inst_24990 = (state_25017[(16)]);
var inst_24996 = (state_25017[(13)]);
var inst_24998 = cljs.core.PersistentVector.EMPTY;
var inst_24999 = cljs.core.into.cljs$core$IFn$_invoke$arity$3(inst_24998,inst_24990,inst_24996);
var state_25017__$1 = state_25017;
var statearr_25033_25134 = state_25017__$1;
(statearr_25033_25134[(2)] = inst_24999);

(statearr_25033_25134[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (15))){
var inst_24908 = (state_25017[(17)]);
var inst_24910 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24911 = [inst_24908];
var inst_24912 = (new cljs.core.PersistentVector(null,1,(5),inst_24910,inst_24911,null));
var state_25017__$1 = state_25017;
var statearr_25034_25135 = state_25017__$1;
(statearr_25034_25135[(2)] = inst_24912);

(statearr_25034_25135[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (48))){
var inst_24923 = (state_25017[(8)]);
var inst_24946 = (state_25017[(18)]);
var inst_24982 = (state_25017[(19)]);
var inst_24935 = (state_25017[(20)]);
var inst_24941 = (state_25017[(21)]);
var inst_24924 = (state_25017[(10)]);
var inst_24925 = (state_25017[(11)]);
var inst_24984 = (function (){var map__24917 = inst_24923;
var headers = inst_24924;
var tuples = inst_24925;
var offset_SINGLEQUOTE_ = inst_24935;
var single_result_QMARK_ = inst_24941;
var pp_keys = inst_24946;
var G__24947 = inst_24982;
return (function (p1__24874_SHARP_){
return cljs.core.zipmap(fluree.db.query.fql.get_pretty_print_keys(select),p1__24874_SHARP_);
});
})();
var inst_24985 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_24984);
var inst_24986 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24982,inst_24985);
var state_25017__$1 = state_25017;
var statearr_25035_25136 = state_25017__$1;
(statearr_25035_25136[(2)] = inst_24986);

(statearr_25035_25136[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (50))){
var inst_24989 = (state_25017[(2)]);
var inst_24990 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,inst_24989);
var state_25017__$1 = (function (){var statearr_25036 = state_25017;
(statearr_25036[(16)] = inst_24990);

return statearr_25036;
})();
if(cljs.core.truth_(orderBy)){
var statearr_25037_25137 = state_25017__$1;
(statearr_25037_25137[(1)] = (51));

} else {
var statearr_25038_25138 = state_25017__$1;
(statearr_25038_25138[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (21))){
var inst_24928 = cljs.core.not(groupBy);
var state_25017__$1 = state_25017;
var statearr_25039_25139 = state_25017__$1;
(statearr_25039_25139[(2)] = inst_24928);

(statearr_25039_25139[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (31))){
var state_25017__$1 = state_25017;
var statearr_25040_25140 = state_25017__$1;
(statearr_25040_25140[(2)] = null);

(statearr_25040_25140[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (32))){
var inst_24941 = (state_25017[(21)]);
var inst_24924 = (state_25017[(10)]);
var inst_24946 = (state_25017[(2)]);
var inst_24948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24949 = fluree.db.query.fql.select_tuples_fn(inst_24924,vars,select);
var inst_24950 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_24949);
var inst_24951 = [inst_24950];
var inst_24952 = (new cljs.core.PersistentVector(null,1,(5),inst_24948,inst_24951,null));
var state_25017__$1 = (function (){var statearr_25041 = state_25017;
(statearr_25041[(18)] = inst_24946);

(statearr_25041[(22)] = inst_24952);

return statearr_25041;
})();
if(cljs.core.truth_(inst_24941)){
var statearr_25042_25141 = state_25017__$1;
(statearr_25042_25141[(1)] = (33));

} else {
var statearr_25043_25142 = state_25017__$1;
(statearr_25043_25142[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (40))){
var inst_24964 = (state_25017[(14)]);
var state_25017__$1 = state_25017;
var statearr_25044_25143 = state_25017__$1;
(statearr_25044_25143[(2)] = inst_24964);

(statearr_25044_25143[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (56))){
var inst_25002 = (state_25017[(2)]);
var state_25017__$1 = (function (){var statearr_25045 = state_25017;
(statearr_25045[(12)] = inst_25002);

return statearr_25045;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_25046_25144 = state_25017__$1;
(statearr_25046_25144[(1)] = (57));

} else {
var statearr_25047_25145 = state_25017__$1;
(statearr_25047_25145[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (33))){
var inst_24952 = (state_25017[(22)]);
var inst_24954 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.first);
var inst_24955 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24952,inst_24954);
var state_25017__$1 = state_25017;
var statearr_25048_25146 = state_25017__$1;
(statearr_25048_25146[(2)] = inst_24955);

(statearr_25048_25146[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (13))){
var inst_24897 = (state_25017[(23)]);
var state_25017__$1 = state_25017;
var statearr_25049_25147 = state_25017__$1;
(statearr_25049_25147[(2)] = inst_24897);

(statearr_25049_25147[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (22))){
var inst_24926 = (state_25017[(9)]);
var state_25017__$1 = state_25017;
var statearr_25050_25148 = state_25017__$1;
(statearr_25050_25148[(2)] = inst_24926);

(statearr_25050_25148[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (36))){
var inst_24958 = (state_25017[(24)]);
var inst_24960 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(5));
var inst_24961 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24958,inst_24960);
var state_25017__$1 = state_25017;
var statearr_25051_25149 = state_25017__$1;
(statearr_25051_25149[(2)] = inst_24961);

(statearr_25051_25149[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (41))){
var inst_24935 = (state_25017[(20)]);
var inst_24970 = (state_25017[(2)]);
var state_25017__$1 = (function (){var statearr_25052 = state_25017;
(statearr_25052[(25)] = inst_24970);

return statearr_25052;
})();
if(cljs.core.truth_(inst_24935)){
var statearr_25053_25150 = state_25017__$1;
(statearr_25053_25150[(1)] = (42));

} else {
var statearr_25054_25151 = state_25017__$1;
(statearr_25054_25151[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (43))){
var inst_24970 = (state_25017[(25)]);
var state_25017__$1 = state_25017;
var statearr_25055_25152 = state_25017__$1;
(statearr_25055_25152[(2)] = inst_24970);

(statearr_25055_25152[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (29))){
var inst_24941 = (state_25017[(2)]);
var state_25017__$1 = (function (){var statearr_25056 = state_25017;
(statearr_25056[(21)] = inst_24941);

return statearr_25056;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25057_25153 = state_25017__$1;
(statearr_25057_25153[(1)] = (30));

} else {
var statearr_25058_25154 = state_25017__$1;
(statearr_25058_25154[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (44))){
var inst_24976 = (state_25017[(2)]);
var state_25017__$1 = (function (){var statearr_25059 = state_25017;
(statearr_25059[(15)] = inst_24976);

return statearr_25059;
})();
if(cljs.core.truth_(group_limit)){
var statearr_25060_25155 = state_25017__$1;
(statearr_25060_25155[(1)] = (45));

} else {
var statearr_25061_25156 = state_25017__$1;
(statearr_25061_25156[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (6))){
var inst_24889 = cljs.core.count(select);
var inst_24890 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_24889);
var state_25017__$1 = state_25017;
var statearr_25062_25157 = state_25017__$1;
(statearr_25062_25157[(2)] = inst_24890);

(statearr_25062_25157[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (28))){
var inst_24936 = (state_25017[(26)]);
var state_25017__$1 = state_25017;
var statearr_25063_25158 = state_25017__$1;
(statearr_25063_25158[(2)] = inst_24936);

(statearr_25063_25158[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (51))){
var inst_24924 = (state_25017[(10)]);
var inst_24925 = (state_25017[(11)]);
var inst_24993 = fluree.db.query.fql.order_result_tuples(fuel,max_fuel,inst_24924,orderBy,inst_24925);
var state_25017__$1 = state_25017;
var statearr_25064_25159 = state_25017__$1;
(statearr_25064_25159[(2)] = inst_24993);

(statearr_25064_25159[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (25))){
var state_25017__$1 = state_25017;
var statearr_25065_25160 = state_25017__$1;
(statearr_25065_25160[(2)] = null);

(statearr_25065_25160[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (34))){
var inst_24952 = (state_25017[(22)]);
var state_25017__$1 = state_25017;
var statearr_25066_25161 = state_25017__$1;
(statearr_25066_25161[(2)] = inst_24952);

(statearr_25066_25161[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (17))){
var inst_24915 = (state_25017[(2)]);
var state_25017__$1 = state_25017;
var statearr_25067_25162 = state_25017__$1;
(statearr_25067_25162[(2)] = inst_24915);

(statearr_25067_25162[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (3))){
var inst_25015 = (state_25017[(2)]);
var state_25017__$1 = state_25017;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25017__$1,inst_25015);
} else {
if((state_val_25018 === (12))){
var inst_24897 = (state_25017[(23)]);
var inst_24899 = cljs.core.first(select);
var inst_24900 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_24899);
var inst_24901 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24900);
var inst_24902 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_24901,(1));
var inst_24903 = [inst_24902];
var inst_24904 = [inst_24897];
var inst_24905 = cljs.core.PersistentHashMap.fromArrays(inst_24903,inst_24904);
var state_25017__$1 = state_25017;
var statearr_25068_25163 = state_25017__$1;
(statearr_25068_25163[(2)] = inst_24905);

(statearr_25068_25163[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (2))){
var inst_24887 = (state_25017[(7)]);
var _ = (function (){var statearr_25069 = state_25017;
(statearr_25069[(4)] = cljs.core.cons((5),(state_25017[(4)])));

return statearr_25069;
})();
var inst_24887__$1 = aggregates;
var state_25017__$1 = (function (){var statearr_25070 = state_25017;
(statearr_25070[(7)] = inst_24887__$1);

return statearr_25070;
})();
if(cljs.core.truth_(inst_24887__$1)){
var statearr_25071_25164 = state_25017__$1;
(statearr_25071_25164[(1)] = (6));

} else {
var statearr_25072_25165 = state_25017__$1;
(statearr_25072_25165[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (23))){
var inst_24931 = (state_25017[(2)]);
var state_25017__$1 = state_25017;
if(cljs.core.truth_(inst_24931)){
var statearr_25073_25166 = state_25017__$1;
(statearr_25073_25166[(1)] = (24));

} else {
var statearr_25074_25167 = state_25017__$1;
(statearr_25074_25167[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (47))){
var inst_24982 = (state_25017[(2)]);
var state_25017__$1 = (function (){var statearr_25075 = state_25017;
(statearr_25075[(19)] = inst_24982);

return statearr_25075;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25076_25168 = state_25017__$1;
(statearr_25076_25168[(1)] = (48));

} else {
var statearr_25077_25169 = state_25017__$1;
(statearr_25077_25169[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (35))){
var inst_24958 = (state_25017[(2)]);
var state_25017__$1 = (function (){var statearr_25078 = state_25017;
(statearr_25078[(24)] = inst_24958);

return statearr_25078;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25079_25170 = state_25017__$1;
(statearr_25079_25170[(1)] = (36));

} else {
var statearr_25080_25171 = state_25017__$1;
(statearr_25080_25171[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (19))){
var state_25017__$1 = state_25017;
var statearr_25081_25172 = state_25017__$1;
(statearr_25081_25172[(2)] = res);

(statearr_25081_25172[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (57))){
var inst_24946 = (state_25017[(18)]);
var inst_24941 = (state_25017[(21)]);
var inst_25002 = (state_25017[(12)]);
var inst_25004 = fluree.db.query.fql.pipeline_expandmaps_result(select,inst_24946,inst_24941,db,fuel,max_fuel,opts,(8),inst_25002);
var state_25017__$1 = state_25017;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25017__$1,(60),inst_25004);
} else {
if((state_val_25018 === (11))){
var inst_25012 = (state_25017[(2)]);
var _ = (function (){var statearr_25083 = state_25017;
(statearr_25083[(4)] = cljs.core.rest((state_25017[(4)])));

return statearr_25083;
})();
var state_25017__$1 = state_25017;
var statearr_25084_25173 = state_25017__$1;
(statearr_25084_25173[(2)] = inst_25012);

(statearr_25084_25173[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (9))){
var inst_24895 = cljs.core.first(aggregates);
var inst_24896 = fluree.db.query.analytical.calculate_aggregate(res,inst_24895);
var inst_24897 = cljs.core.second(inst_24896);
var state_25017__$1 = (function (){var statearr_25085 = state_25017;
(statearr_25085[(23)] = inst_24897);

return statearr_25085;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25086_25174 = state_25017__$1;
(statearr_25086_25174[(1)] = (12));

} else {
var statearr_25087_25175 = state_25017__$1;
(statearr_25087_25175[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (5))){
var _ = (function (){var statearr_25088 = state_25017;
(statearr_25088[(4)] = cljs.core.rest((state_25017[(4)])));

return statearr_25088;
})();
var state_25017__$1 = state_25017;
var ex25082 = (state_25017__$1[(2)]);
var statearr_25089_25176 = state_25017__$1;
(statearr_25089_25176[(5)] = ex25082);


if((ex25082 instanceof Error)){
var statearr_25090_25177 = state_25017__$1;
(statearr_25090_25177[(1)] = (4));

(statearr_25090_25177[(5)] = null);

} else {
throw ex25082;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (14))){
var inst_24908 = (state_25017[(2)]);
var state_25017__$1 = (function (){var statearr_25091 = state_25017;
(statearr_25091[(17)] = inst_24908);

return statearr_25091;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25092_25178 = state_25017__$1;
(statearr_25092_25178[(1)] = (15));

} else {
var statearr_25093_25179 = state_25017__$1;
(statearr_25093_25179[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (45))){
var inst_24976 = (state_25017[(15)]);
var inst_24978 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(group_limit);
var inst_24979 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24976,inst_24978);
var state_25017__$1 = state_25017;
var statearr_25094_25180 = state_25017__$1;
(statearr_25094_25180[(2)] = inst_24979);

(statearr_25094_25180[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (53))){
var inst_24996 = (state_25017[(2)]);
var state_25017__$1 = (function (){var statearr_25095 = state_25017;
(statearr_25095[(13)] = inst_24996);

return statearr_25095;
})();
var statearr_25096_25181 = state_25017__$1;
(statearr_25096_25181[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (26))){
var inst_24936 = (state_25017[(26)]);
var inst_24935 = (state_25017[(2)]);
var inst_24936__$1 = cljs.core.not(prettyPrint);
var state_25017__$1 = (function (){var statearr_25098 = state_25017;
(statearr_25098[(26)] = inst_24936__$1);

(statearr_25098[(20)] = inst_24935);

return statearr_25098;
})();
if(inst_24936__$1){
var statearr_25099_25182 = state_25017__$1;
(statearr_25099_25182[(1)] = (27));

} else {
var statearr_25100_25183 = state_25017__$1;
(statearr_25100_25183[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (16))){
var inst_24908 = (state_25017[(17)]);
var state_25017__$1 = state_25017;
var statearr_25101_25184 = state_25017__$1;
(statearr_25101_25184[(2)] = inst_24908);

(statearr_25101_25184[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (38))){
var inst_24964 = (state_25017[(2)]);
var state_25017__$1 = (function (){var statearr_25102 = state_25017;
(statearr_25102[(14)] = inst_24964);

return statearr_25102;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25103_25185 = state_25017__$1;
(statearr_25103_25185[(1)] = (39));

} else {
var statearr_25104_25186 = state_25017__$1;
(statearr_25104_25186[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (30))){
var inst_24943 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_25017__$1 = state_25017;
var statearr_25105_25187 = state_25017__$1;
(statearr_25105_25187[(2)] = inst_24943);

(statearr_25105_25187[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (10))){
var state_25017__$1 = state_25017;
if(cljs.core.truth_(aggregates)){
var statearr_25106_25188 = state_25017__$1;
(statearr_25106_25188[(1)] = (18));

} else {
var statearr_25107_25189 = state_25017__$1;
(statearr_25107_25189[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (18))){
var inst_24919 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_25017__$1 = state_25017;
var statearr_25108_25190 = state_25017__$1;
(statearr_25108_25190[(2)] = inst_24919);

(statearr_25108_25190[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (52))){
var inst_24925 = (state_25017[(11)]);
var state_25017__$1 = state_25017;
var statearr_25109_25191 = state_25017__$1;
(statearr_25109_25191[(2)] = inst_24925);

(statearr_25109_25191[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (42))){
var inst_24935 = (state_25017[(20)]);
var inst_24970 = (state_25017[(25)]);
var inst_24972 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(inst_24935);
var inst_24973 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24970,inst_24972);
var state_25017__$1 = state_25017;
var statearr_25110_25192 = state_25017__$1;
(statearr_25110_25192[(2)] = inst_24973);

(statearr_25110_25192[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (37))){
var inst_24958 = (state_25017[(24)]);
var state_25017__$1 = state_25017;
var statearr_25111_25193 = state_25017__$1;
(statearr_25111_25193[(2)] = inst_24958);

(statearr_25111_25193[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (8))){
var inst_24893 = (state_25017[(2)]);
var state_25017__$1 = state_25017;
if(cljs.core.truth_(inst_24893)){
var statearr_25112_25194 = state_25017__$1;
(statearr_25112_25194[(1)] = (9));

} else {
var statearr_25113_25195 = state_25017__$1;
(statearr_25113_25195[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25018 === (49))){
var inst_24982 = (state_25017[(19)]);
var state_25017__$1 = state_25017;
var statearr_25114_25196 = state_25017__$1;
(statearr_25114_25196[(2)] = inst_24982);

(statearr_25114_25196[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2727__auto__ = null;
var fluree$db$query$fql$state_machine__2727__auto____0 = (function (){
var statearr_25115 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25115[(0)] = fluree$db$query$fql$state_machine__2727__auto__);

(statearr_25115[(1)] = (1));

return statearr_25115;
});
var fluree$db$query$fql$state_machine__2727__auto____1 = (function (state_25017){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25017);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25116){var ex__2730__auto__ = e25116;
var statearr_25117_25197 = state_25017;
(statearr_25117_25197[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25017[(4)]))){
var statearr_25118_25198 = state_25017;
(statearr_25118_25198[(1)] = cljs.core.first((state_25017[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25199 = state_25017;
state_25017 = G__25199;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2727__auto__ = function(state_25017){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2727__auto____1.call(this,state_25017);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2727__auto____0;
fluree$db$query$fql$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2727__auto____1;
return fluree$db$query$fql$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25119 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25119[(6)] = c__2749__auto__);

return statearr_25119;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__25202,groupBy){
var map__25203 = p__25202;
var map__25203__$1 = cljs.core.__destructure_map(map__25203);
var res = map__25203__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25203__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25203__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__25204 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25204,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25204,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__25200_SHARP_){
return fluree.db.util.core.index_of(headers,p1__25200_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__25201_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__25201_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__25207 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25207,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25207,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
/**
 * groupBy statements can optionally have a 'having' statement which filters
 *   items within the group.
 */
fluree.db.query.fql.filter_having = (function fluree$db$query$fql$filter_having(p__25210,headers,group_map){
var map__25211 = p__25210;
var map__25211__$1 = cljs.core.__destructure_map(map__25211);
var having = map__25211__$1;
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25211__$1,new cljs.core.Keyword(null,"params","params",710516235));
var function$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25211__$1,new cljs.core.Keyword(null,"function","function",-2127255473));
var idxs = fluree.db.query.analytical.get_tuple_indexes(params,headers);
var filtered = (function (){var G__25218 = group_map;
var vec__25219 = G__25218;
var seq__25220 = cljs.core.seq(vec__25219);
var first__25221 = cljs.core.first(seq__25220);
var seq__25220__$1 = cljs.core.next(seq__25220);
var vec__25222 = first__25221;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25222,(0),null);
var tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25222,(1),null);
var r = seq__25220__$1;
var acc = cljs.core.PersistentArrayMap.EMPTY;
var G__25218__$1 = G__25218;
var acc__$1 = acc;
while(true){
var vec__25234 = G__25218__$1;
var seq__25235 = cljs.core.seq(vec__25234);
var first__25236 = cljs.core.first(seq__25235);
var seq__25235__$1 = cljs.core.next(seq__25235);
var vec__25237 = first__25236;
var k__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25237,(0),null);
var tuples__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25237,(1),null);
var r__$1 = seq__25235__$1;
var acc__$2 = acc__$1;
if(cljs.core.truth_(k__$1)){
var argument = cljs.core.flatten(fluree.db.query.analytical.transform_tuples_to_idxs(idxs,tuples__$1));
var res = (function (){try{return (function$.cljs$core$IFn$_invoke$arity$1 ? function$.cljs$core$IFn$_invoke$arity$1(argument) : function$.call(null,argument));
}catch (e25240){var e = e25240;
var G__25241_25243 = e;
var G__25242_25244 = ["Error procesing fn: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402).cljs$core$IFn$_invoke$arity$1(having))," with argument: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(argument)].join('');
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__25241_25243,G__25242_25244) : fluree.db.util.log.error.call(null,G__25241_25243,G__25242_25244));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error executing having function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402).cljs$core$IFn$_invoke$arity$1(having))," with error message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.ex_message(e))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}})();
if(cljs.core.truth_(res)){
var G__25245 = r__$1;
var G__25246 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc__$2,k__$1,tuples__$1);
G__25218__$1 = G__25245;
acc__$1 = G__25246;
continue;
} else {
var G__25247 = r__$1;
var G__25248 = acc__$2;
G__25218__$1 = G__25247;
acc__$1 = G__25248;
continue;
}
} else {
return acc__$2;
}
break;
}
})();
return filtered;
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__25249,p__25250,opts){
var map__25251 = p__25249;
var map__25251__$1 = cljs.core.__destructure_map(map__25251);
var res = map__25251__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25251__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25251__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__25252 = p__25250;
var map__25252__$1 = cljs.core.__destructure_map(map__25252);
var select_spec = map__25252__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25252__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25252__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25252__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25252__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25252__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25252__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25252__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var having = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25252__$1,new cljs.core.Keyword(null,"having","having",-399543166));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25376){
var state_val_25377 = (state_25376[(1)]);
if((state_val_25377 === (7))){
var state_25376__$1 = state_25376;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25378_25451 = state_25376__$1;
(statearr_25378_25451[(1)] = (30));

} else {
var statearr_25379_25452 = state_25376__$1;
(statearr_25379_25452[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (20))){
var inst_25283 = (state_25376[(2)]);
var state_25376__$1 = (function (){var statearr_25380 = state_25376;
(statearr_25380[(7)] = inst_25283);

return statearr_25380;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25381_25453 = state_25376__$1;
(statearr_25381_25453[(1)] = (21));

} else {
var statearr_25382_25454 = state_25376__$1;
(statearr_25382_25454[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (27))){
var inst_25309 = (state_25376[(8)]);
var state_25376__$1 = state_25376;
var statearr_25383_25455 = state_25376__$1;
(statearr_25383_25455[(2)] = inst_25309);

(statearr_25383_25455[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (1))){
var state_25376__$1 = state_25376;
var statearr_25384_25456 = state_25376__$1;
(statearr_25384_25456[(2)] = null);

(statearr_25384_25456[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (24))){
var inst_25320 = (state_25376[(9)]);
var inst_25308 = (state_25376[(10)]);
var inst_25317 = cljs.core.seq(inst_25308);
var inst_25318 = cljs.core.first(inst_25317);
var inst_25319 = cljs.core.next(inst_25317);
var inst_25320__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25318,(0),null);
var inst_25321 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25318,(1),null);
var state_25376__$1 = (function (){var statearr_25385 = state_25376;
(statearr_25385[(9)] = inst_25320__$1);

(statearr_25385[(11)] = inst_25319);

(statearr_25385[(12)] = inst_25321);

return statearr_25385;
})();
if(cljs.core.truth_(inst_25320__$1)){
var statearr_25386_25457 = state_25376__$1;
(statearr_25386_25457[(1)] = (26));

} else {
var statearr_25387_25458 = state_25376__$1;
(statearr_25387_25458[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (39))){
var inst_25357 = (state_25376[(2)]);
var state_25376__$1 = state_25376;
var statearr_25388_25459 = state_25376__$1;
(statearr_25388_25459[(2)] = inst_25357);

(statearr_25388_25459[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (4))){
var inst_25253 = (state_25376[(2)]);
var state_25376__$1 = state_25376;
var statearr_25389_25460 = state_25376__$1;
(statearr_25389_25460[(2)] = inst_25253);

(statearr_25389_25460[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (15))){
var inst_25273 = (state_25376[(13)]);
var inst_25275 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,inst_25273);
var state_25376__$1 = state_25376;
var statearr_25390_25461 = state_25376__$1;
(statearr_25390_25461[(2)] = inst_25275);

(statearr_25390_25461[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (21))){
var inst_25283 = (state_25376[(7)]);
var inst_25285 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((1),inst_25283);
var state_25376__$1 = state_25376;
var statearr_25391_25462 = state_25376__$1;
(statearr_25391_25462[(2)] = inst_25285);

(statearr_25391_25462[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (31))){
var state_25376__$1 = state_25376;
var statearr_25392_25463 = state_25376__$1;
(statearr_25392_25463[(2)] = limit);

(statearr_25392_25463[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (32))){
var inst_25343 = (state_25376[(2)]);
var inst_25344 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,inst_25343,opts);
var state_25376__$1 = state_25376;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25376__$1,(33),inst_25344);
} else {
if((state_val_25377 === (40))){
var inst_25347 = (state_25376[(14)]);
var inst_25360 = cljs.core.first(inst_25347);
var state_25376__$1 = state_25376;
var statearr_25393_25464 = state_25376__$1;
(statearr_25393_25464[(2)] = inst_25360);

(statearr_25393_25464[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (33))){
var inst_25347 = (state_25376[(14)]);
var inst_25346 = (state_25376[(2)]);
var inst_25347__$1 = fluree.db.util.async.throw_err(inst_25346);
var inst_25348 = cljs.core.coll_QMARK_(inst_25347__$1);
var inst_25349 = (!(inst_25348));
var state_25376__$1 = (function (){var statearr_25394 = state_25376;
(statearr_25394[(14)] = inst_25347__$1);

return statearr_25394;
})();
if(inst_25349){
var statearr_25395_25465 = state_25376__$1;
(statearr_25395_25465[(1)] = (34));

} else {
var statearr_25396_25466 = state_25376__$1;
(statearr_25396_25466[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (13))){
var inst_25268 = (state_25376[(15)]);
var state_25376__$1 = state_25376;
var statearr_25397_25467 = state_25376__$1;
(statearr_25397_25467[(2)] = inst_25268);

(statearr_25397_25467[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (22))){
var inst_25283 = (state_25376[(7)]);
var state_25376__$1 = state_25376;
var statearr_25398_25468 = state_25376__$1;
(statearr_25398_25468[(2)] = inst_25283);

(statearr_25398_25468[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (36))){
var inst_25369 = (state_25376[(2)]);
var state_25376__$1 = state_25376;
var statearr_25399_25469 = state_25376__$1;
(statearr_25399_25469[(2)] = inst_25369);

(statearr_25399_25469[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (41))){
var state_25376__$1 = state_25376;
var statearr_25400_25470 = state_25376__$1;
(statearr_25400_25470[(1)] = (43));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (43))){
var inst_25347 = (state_25376[(14)]);
var state_25376__$1 = state_25376;
var statearr_25402_25471 = state_25376__$1;
(statearr_25402_25471[(2)] = inst_25347);

(statearr_25402_25471[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (29))){
var inst_25320 = (state_25376[(9)]);
var inst_25309 = (state_25376[(8)]);
var inst_25319 = (state_25376[(11)]);
var inst_25330 = (state_25376[(2)]);
var inst_25331 = fluree.db.util.async.throw_err(inst_25330);
var inst_25332 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25309,inst_25320,inst_25331);
var inst_25308 = inst_25319;
var inst_25309__$1 = inst_25332;
var state_25376__$1 = (function (){var statearr_25403 = state_25376;
(statearr_25403[(10)] = inst_25308);

(statearr_25403[(8)] = inst_25309__$1);

return statearr_25403;
})();
var statearr_25404_25472 = state_25376__$1;
(statearr_25404_25472[(2)] = null);

(statearr_25404_25472[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (44))){
var state_25376__$1 = state_25376;
var statearr_25405_25473 = state_25376__$1;
(statearr_25405_25473[(2)] = null);

(statearr_25405_25473[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (6))){
var inst_25260 = (state_25376[(16)]);
var inst_25260__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_25262 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_25376__$1 = (function (){var statearr_25406 = state_25376;
(statearr_25406[(16)] = inst_25260__$1);

(statearr_25406[(17)] = inst_25262);

return statearr_25406;
})();
if(cljs.core.truth_(inst_25260__$1)){
var statearr_25407_25474 = state_25376__$1;
(statearr_25407_25474[(1)] = (9));

} else {
var statearr_25408_25475 = state_25376__$1;
(statearr_25408_25475[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (28))){
var inst_25336 = (state_25376[(2)]);
var state_25376__$1 = state_25376;
var statearr_25409_25476 = state_25376__$1;
(statearr_25409_25476[(2)] = inst_25336);

(statearr_25409_25476[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (25))){
var inst_25338 = (state_25376[(2)]);
var state_25376__$1 = state_25376;
var statearr_25410_25477 = state_25376__$1;
(statearr_25410_25477[(2)] = inst_25338);

(statearr_25410_25477[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (34))){
var state_25376__$1 = state_25376;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25411_25478 = state_25376__$1;
(statearr_25411_25478[(1)] = (37));

} else {
var statearr_25412_25479 = state_25376__$1;
(statearr_25412_25479[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (17))){
var inst_25278 = (state_25376[(2)]);
var state_25376__$1 = (function (){var statearr_25413 = state_25376;
(statearr_25413[(18)] = inst_25278);

return statearr_25413;
})();
if(cljs.core.truth_(limit)){
var statearr_25414_25480 = state_25376__$1;
(statearr_25414_25480[(1)] = (18));

} else {
var statearr_25415_25481 = state_25376__$1;
(statearr_25415_25481[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (3))){
var inst_25374 = (state_25376[(2)]);
var state_25376__$1 = state_25376;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25376__$1,inst_25374);
} else {
if((state_val_25377 === (12))){
var inst_25268 = (state_25376[(15)]);
var inst_25270 = fluree.db.query.fql.filter_having(having,headers,inst_25268);
var state_25376__$1 = state_25376;
var statearr_25416_25482 = state_25376__$1;
(statearr_25416_25482[(2)] = inst_25270);

(statearr_25416_25482[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (2))){
var _ = (function (){var statearr_25417 = state_25376;
(statearr_25417[(4)] = cljs.core.cons((5),(state_25376[(4)])));

return statearr_25417;
})();
var state_25376__$1 = state_25376;
if(cljs.core.truth_(groupBy)){
var statearr_25418_25483 = state_25376__$1;
(statearr_25418_25483[(1)] = (6));

} else {
var statearr_25419_25484 = state_25376__$1;
(statearr_25419_25484[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (23))){
var inst_25288 = (state_25376[(2)]);
var inst_25302 = cljs.core.seq(inst_25288);
var inst_25303 = cljs.core.first(inst_25302);
var inst_25304 = cljs.core.next(inst_25302);
var inst_25305 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25303,(0),null);
var inst_25306 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25303,(1),null);
var inst_25307 = cljs.core.PersistentHashMap.EMPTY;
var inst_25308 = inst_25288;
var inst_25309 = inst_25307;
var state_25376__$1 = (function (){var statearr_25420 = state_25376;
(statearr_25420[(10)] = inst_25308);

(statearr_25420[(8)] = inst_25309);

(statearr_25420[(19)] = inst_25305);

(statearr_25420[(20)] = inst_25304);

(statearr_25420[(21)] = inst_25306);

return statearr_25420;
})();
var statearr_25421_25485 = state_25376__$1;
(statearr_25421_25485[(2)] = null);

(statearr_25421_25485[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (35))){
var state_25376__$1 = state_25376;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25422_25486 = state_25376__$1;
(statearr_25422_25486[(1)] = (40));

} else {
var statearr_25423_25487 = state_25376__$1;
(statearr_25423_25487[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (19))){
var inst_25278 = (state_25376[(18)]);
var state_25376__$1 = state_25376;
var statearr_25424_25488 = state_25376__$1;
(statearr_25424_25488[(2)] = inst_25278);

(statearr_25424_25488[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (11))){
var inst_25268 = (state_25376[(2)]);
var state_25376__$1 = (function (){var statearr_25426 = state_25376;
(statearr_25426[(15)] = inst_25268);

return statearr_25426;
})();
if(cljs.core.truth_(having)){
var statearr_25427_25489 = state_25376__$1;
(statearr_25427_25489[(1)] = (12));

} else {
var statearr_25428_25490 = state_25376__$1;
(statearr_25428_25490[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (9))){
var inst_25260 = (state_25376[(16)]);
var inst_25262 = (state_25376[(17)]);
var inst_25264 = cljs.core.sorted_map_by(inst_25260);
var inst_25265 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25264,inst_25262);
var state_25376__$1 = state_25376;
var statearr_25429_25491 = state_25376__$1;
(statearr_25429_25491[(2)] = inst_25265);

(statearr_25429_25491[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (5))){
var _ = (function (){var statearr_25430 = state_25376;
(statearr_25430[(4)] = cljs.core.rest((state_25376[(4)])));

return statearr_25430;
})();
var state_25376__$1 = state_25376;
var ex25425 = (state_25376__$1[(2)]);
var statearr_25431_25492 = state_25376__$1;
(statearr_25431_25492[(5)] = ex25425);


if((ex25425 instanceof Error)){
var statearr_25432_25493 = state_25376__$1;
(statearr_25432_25493[(1)] = (4));

(statearr_25432_25493[(5)] = null);

} else {
throw ex25425;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (14))){
var inst_25273 = (state_25376[(2)]);
var state_25376__$1 = (function (){var statearr_25433 = state_25376;
(statearr_25433[(13)] = inst_25273);

return statearr_25433;
})();
if(cljs.core.truth_(offset)){
var statearr_25434_25494 = state_25376__$1;
(statearr_25434_25494[(1)] = (15));

} else {
var statearr_25435_25495 = state_25376__$1;
(statearr_25435_25495[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (45))){
var inst_25365 = (state_25376[(2)]);
var state_25376__$1 = state_25376;
var statearr_25436_25496 = state_25376__$1;
(statearr_25436_25496[(2)] = inst_25365);

(statearr_25436_25496[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (26))){
var inst_25321 = (state_25376[(12)]);
var inst_25323 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_25324 = [headers,vars,inst_25321];
var inst_25325 = cljs.core.PersistentHashMap.fromArrays(inst_25323,inst_25324);
var inst_25326 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_25327 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_25328 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6(db,fuel,max_fuel,inst_25325,inst_25326,inst_25327);
var state_25376__$1 = state_25376;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25376__$1,(29),inst_25328);
} else {
if((state_val_25377 === (16))){
var inst_25273 = (state_25376[(13)]);
var state_25376__$1 = state_25376;
var statearr_25437_25497 = state_25376__$1;
(statearr_25437_25497[(2)] = inst_25273);

(statearr_25437_25497[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (38))){
var inst_25347 = (state_25376[(14)]);
var state_25376__$1 = state_25376;
var statearr_25438_25498 = state_25376__$1;
(statearr_25438_25498[(2)] = inst_25347);

(statearr_25438_25498[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (30))){
var state_25376__$1 = state_25376;
var statearr_25439_25499 = state_25376__$1;
(statearr_25439_25499[(2)] = (1));

(statearr_25439_25499[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (10))){
var inst_25262 = (state_25376[(17)]);
var state_25376__$1 = state_25376;
var statearr_25440_25500 = state_25376__$1;
(statearr_25440_25500[(2)] = inst_25262);

(statearr_25440_25500[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (18))){
var inst_25278 = (state_25376[(18)]);
var inst_25280 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,inst_25278);
var state_25376__$1 = state_25376;
var statearr_25441_25501 = state_25376__$1;
(statearr_25441_25501[(2)] = inst_25280);

(statearr_25441_25501[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (42))){
var inst_25367 = (state_25376[(2)]);
var state_25376__$1 = state_25376;
var statearr_25442_25502 = state_25376__$1;
(statearr_25442_25502[(2)] = inst_25367);

(statearr_25442_25502[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (37))){
var inst_25347 = (state_25376[(14)]);
var inst_25352 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25353 = [inst_25347];
var inst_25354 = (new cljs.core.PersistentVector(null,1,(5),inst_25352,inst_25353,null));
var state_25376__$1 = state_25376;
var statearr_25443_25503 = state_25376__$1;
(statearr_25443_25503[(2)] = inst_25354);

(statearr_25443_25503[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25377 === (8))){
var inst_25371 = (state_25376[(2)]);
var _ = (function (){var statearr_25444 = state_25376;
(statearr_25444[(4)] = cljs.core.rest((state_25376[(4)])));

return statearr_25444;
})();
var state_25376__$1 = state_25376;
var statearr_25445_25504 = state_25376__$1;
(statearr_25445_25504[(2)] = inst_25371);

(statearr_25445_25504[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____0 = (function (){
var statearr_25446 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25446[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__);

(statearr_25446[(1)] = (1));

return statearr_25446;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____1 = (function (state_25376){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25376);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25447){var ex__2730__auto__ = e25447;
var statearr_25448_25505 = state_25376;
(statearr_25448_25505[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25376[(4)]))){
var statearr_25449_25506 = state_25376;
(statearr_25449_25506[(1)] = cljs.core.first((state_25376[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25507 = state_25376;
state_25376 = G__25507;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__ = function(state_25376){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____1.call(this,state_25376);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25450 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25450[(6)] = c__2749__auto__);

return statearr_25450;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Legacy ad-hoc query processor
 */
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,parsed_query,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25568){
var state_val_25569 = (state_25568[(1)]);
if((state_val_25569 === (7))){
var state_25568__$1 = state_25568;
var statearr_25570_25608 = state_25568__$1;
(statearr_25570_25608[(2)] = (0));

(statearr_25570_25608[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25569 === (20))){
var inst_25552 = (state_25568[(2)]);
var state_25568__$1 = state_25568;
var statearr_25571_25609 = state_25568__$1;
(statearr_25571_25609[(2)] = inst_25552);

(statearr_25571_25609[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25569 === (1))){
var state_25568__$1 = state_25568;
var statearr_25572_25610 = state_25568__$1;
(statearr_25572_25610[(2)] = null);

(statearr_25572_25610[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25569 === (4))){
var inst_25508 = (state_25568[(2)]);
var state_25568__$1 = state_25568;
var statearr_25573_25611 = state_25568__$1;
(statearr_25573_25611[(2)] = inst_25508);

(statearr_25573_25611[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25569 === (15))){
var inst_25539 = (state_25568[(7)]);
var state_25568__$1 = state_25568;
var statearr_25574_25612 = state_25568__$1;
(statearr_25574_25612[(2)] = inst_25539);

(statearr_25574_25612[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25569 === (21))){
var inst_25539 = (state_25568[(7)]);
var inst_25554 = (state_25568[(8)]);
var inst_25524 = (state_25568[(9)]);
var inst_25557 = (state_25568[(2)]);
var inst_25558 = fluree.db.util.async.throw_err(inst_25557);
var inst_25559 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(parsed_query);
var inst_25560 = fluree.db.query.fql.process_ad_hoc_res(db,inst_25554,inst_25539,inst_25558,inst_25559,inst_25524);
var state_25568__$1 = state_25568;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25568__$1,(22),inst_25560);
} else {
if((state_val_25569 === (13))){
var inst_25539 = (state_25568[(7)]);
var state_25568__$1 = state_25568;
if(cljs.core.truth_(inst_25539)){
var statearr_25575_25613 = state_25568__$1;
(statearr_25575_25613[(1)] = (15));

} else {
var statearr_25576_25614 = state_25568__$1;
(statearr_25576_25614[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25569 === (22))){
var inst_25562 = (state_25568[(2)]);
var inst_25563 = fluree.db.util.async.throw_err(inst_25562);
var _ = (function (){var statearr_25577 = state_25568;
(statearr_25577[(4)] = cljs.core.rest((state_25568[(4)])));

return statearr_25577;
})();
var state_25568__$1 = state_25568;
var statearr_25578_25615 = state_25568__$1;
(statearr_25578_25615[(2)] = inst_25563);

(statearr_25578_25615[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25569 === (6))){
var inst_25519 = (state_25568[(10)]);
var state_25568__$1 = state_25568;
var statearr_25579_25616 = state_25568__$1;
(statearr_25579_25616[(2)] = inst_25519);

(statearr_25579_25616[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25569 === (17))){
var inst_25547 = (state_25568[(2)]);
var state_25568__$1 = state_25568;
if(cljs.core.truth_(inst_25547)){
var statearr_25580_25617 = state_25568__$1;
(statearr_25580_25617[(1)] = (18));

} else {
var statearr_25581_25618 = state_25568__$1;
(statearr_25581_25618[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25569 === (3))){
var inst_25566 = (state_25568[(2)]);
var state_25568__$1 = state_25568;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25568__$1,inst_25566);
} else {
if((state_val_25569 === (12))){
var inst_25540 = (state_25568[(11)]);
var state_25568__$1 = state_25568;
var statearr_25582_25619 = state_25568__$1;
(statearr_25582_25619[(2)] = inst_25540);

(statearr_25582_25619[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25569 === (2))){
var inst_25519 = (state_25568[(10)]);
var _ = (function (){var statearr_25583 = state_25568;
(statearr_25583[(4)] = cljs.core.cons((5),(state_25568[(4)])));

return statearr_25583;
})();
var inst_25515 = query_map;
var inst_25516 = cljs.core.__destructure_map(inst_25515);
var inst_25517 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25516,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_25518 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25516,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_25519__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25516,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_25520 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25516,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_25521 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25516,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_25522 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25516,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var inst_25523 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25516,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_25524 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25516,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_25526 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803)];
var state_25568__$1 = (function (){var statearr_25584 = state_25568;
(statearr_25584[(12)] = inst_25518);

(statearr_25584[(13)] = inst_25521);

(statearr_25584[(14)] = inst_25523);

(statearr_25584[(15)] = inst_25520);

(statearr_25584[(16)] = inst_25526);

(statearr_25584[(9)] = inst_25524);

(statearr_25584[(10)] = inst_25519__$1);

(statearr_25584[(17)] = inst_25522);

(statearr_25584[(18)] = inst_25517);

return statearr_25584;
})();
if(cljs.core.truth_(inst_25519__$1)){
var statearr_25585_25620 = state_25568__$1;
(statearr_25585_25620[(1)] = (6));

} else {
var statearr_25586_25621 = state_25568__$1;
(statearr_25586_25621[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25569 === (19))){
var state_25568__$1 = state_25568;
var statearr_25587_25622 = state_25568__$1;
(statearr_25587_25622[(2)] = null);

(statearr_25587_25622[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25569 === (11))){
var inst_25538 = (state_25568[(19)]);
var inst_25540 = (state_25568[(11)]);
var inst_25524 = (state_25568[(9)]);
var inst_25538__$1 = (state_25568[(2)]);
var inst_25539 = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(inst_25538__$1);
var inst_25540__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_25524);
var state_25568__$1 = (function (){var statearr_25589 = state_25568;
(statearr_25589[(7)] = inst_25539);

(statearr_25589[(19)] = inst_25538__$1);

(statearr_25589[(11)] = inst_25540__$1);

return statearr_25589;
})();
if(cljs.core.truth_(inst_25540__$1)){
var statearr_25590_25623 = state_25568__$1;
(statearr_25590_25623[(1)] = (12));

} else {
var statearr_25591_25624 = state_25568__$1;
(statearr_25591_25624[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25569 === (9))){
var inst_25533 = (state_25568[(20)]);
var inst_25535 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25533,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var state_25568__$1 = state_25568;
var statearr_25592_25625 = state_25568__$1;
(statearr_25592_25625[(2)] = inst_25535);

(statearr_25592_25625[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25569 === (5))){
var _ = (function (){var statearr_25593 = state_25568;
(statearr_25593[(4)] = cljs.core.rest((state_25568[(4)])));

return statearr_25593;
})();
var state_25568__$1 = state_25568;
var ex25588 = (state_25568__$1[(2)]);
var statearr_25594_25626 = state_25568__$1;
(statearr_25594_25626[(5)] = ex25588);


if((ex25588 instanceof Error)){
var statearr_25595_25627 = state_25568__$1;
(statearr_25595_25627[(1)] = (4));

(statearr_25595_25627[(5)] = null);

} else {
throw ex25588;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25569 === (14))){
var inst_25539 = (state_25568[(7)]);
var inst_25538 = (state_25568[(19)]);
var inst_25554 = (state_25568[(8)]);
var inst_25554__$1 = (state_25568[(2)]);
var inst_25555 = fluree.db.query.analytical.q(query_map,inst_25554__$1,inst_25539,db,inst_25538);
var state_25568__$1 = (function (){var statearr_25596 = state_25568;
(statearr_25596[(8)] = inst_25554__$1);

return statearr_25596;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25568__$1,(21),inst_25555);
} else {
if((state_val_25569 === (16))){
var inst_25524 = (state_25568[(9)]);
var inst_25545 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_25524);
var state_25568__$1 = state_25568;
var statearr_25597_25628 = state_25568__$1;
(statearr_25597_25628[(2)] = inst_25545);

(statearr_25597_25628[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25569 === (10))){
var inst_25533 = (state_25568[(20)]);
var state_25568__$1 = state_25568;
var statearr_25598_25629 = state_25568__$1;
(statearr_25598_25629[(2)] = inst_25533);

(statearr_25598_25629[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25569 === (18))){
var inst_25549 = cljs.core.volatile_BANG_((0));
var state_25568__$1 = state_25568;
var statearr_25599_25630 = state_25568__$1;
(statearr_25599_25630[(2)] = inst_25549);

(statearr_25599_25630[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25569 === (8))){
var inst_25518 = (state_25568[(12)]);
var inst_25521 = (state_25568[(13)]);
var inst_25523 = (state_25568[(14)]);
var inst_25520 = (state_25568[(15)]);
var inst_25526 = (state_25568[(16)]);
var inst_25524 = (state_25568[(9)]);
var inst_25522 = (state_25568[(17)]);
var inst_25517 = (state_25568[(18)]);
var inst_25530 = (state_25568[(2)]);
var inst_25531 = [inst_25518,inst_25530,inst_25520,inst_25521,inst_25522,inst_25523];
var inst_25532 = cljs.core.PersistentHashMap.fromArrays(inst_25526,inst_25531);
var inst_25533 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_25532,inst_25524], 0));
var state_25568__$1 = (function (){var statearr_25600 = state_25568;
(statearr_25600[(20)] = inst_25533);

return statearr_25600;
})();
if(cljs.core.truth_(inst_25517)){
var statearr_25601_25631 = state_25568__$1;
(statearr_25601_25631[(1)] = (9));

} else {
var statearr_25602_25632 = state_25568__$1;
(statearr_25602_25632[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____0 = (function (){
var statearr_25603 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25603[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__);

(statearr_25603[(1)] = (1));

return statearr_25603;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____1 = (function (state_25568){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25568);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25604){var ex__2730__auto__ = e25604;
var statearr_25605_25633 = state_25568;
(statearr_25605_25633[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25568[(4)]))){
var statearr_25606_25634 = state_25568;
(statearr_25606_25634[(1)] = cljs.core.first((state_25568[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25635 = state_25568;
state_25568 = G__25635;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__ = function(state_25568){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____1.call(this,state_25568);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25607 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25607[(6)] = c__2749__auto__);

return statearr_25607;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns already cached query from cache if available, else
 *   executes and stores query into cache.
 */
fluree.db.query.fql.cache_query = (function fluree$db$query$fql$cache_query(p__25636,p__25637){
var map__25638 = p__25636;
var map__25638__$1 = cljs.core.__destructure_map(map__25638);
var db = map__25638__$1;
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25638__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25638__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25638__$1,new cljs.core.Keyword(null,"block","block",664686210));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25638__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25638__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var map__25639 = p__25637;
var map__25639__$1 = cljs.core.__destructure_map(map__25639);
var query_map = map__25639__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25639__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var oc = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
var query_STAR_ = cljs.core.update.cljs$core$IFn$_invoke$arity$5(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.dissoc,new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var cache_key = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query","query",-1288509510),network,ledger_id,block,auth,query_STAR_], null);
var G__25640 = cache_key;
var G__25641 = (function (_){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___25658 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25651){
var state_val_25652 = (state_25651[(1)]);
if((state_val_25652 === (1))){
var inst_25642 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25643 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"cache","cache",-1237023054)];
var inst_25644 = (new cljs.core.PersistentVector(null,2,(5),inst_25642,inst_25643,null));
var inst_25645 = cljs.core.assoc_in(query_map,inst_25644,false);
var inst_25646 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_25645) : fluree.db.query.fql.query.call(null,db,inst_25645));
var state_25651__$1 = state_25651;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25651__$1,(2),inst_25646);
} else {
if((state_val_25652 === (2))){
var inst_25648 = (state_25651[(2)]);
var inst_25649 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_25648);
var state_25651__$1 = state_25651;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25651__$1,inst_25649);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$cache_query_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$cache_query_$_state_machine__2727__auto____0 = (function (){
var statearr_25653 = [null,null,null,null,null,null,null];
(statearr_25653[(0)] = fluree$db$query$fql$cache_query_$_state_machine__2727__auto__);

(statearr_25653[(1)] = (1));

return statearr_25653;
});
var fluree$db$query$fql$cache_query_$_state_machine__2727__auto____1 = (function (state_25651){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25651);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25654){var ex__2730__auto__ = e25654;
var statearr_25655_25659 = state_25651;
(statearr_25655_25659[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25651[(4)]))){
var statearr_25656_25660 = state_25651;
(statearr_25656_25660[(1)] = cljs.core.first((state_25651[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25661 = state_25651;
state_25651 = G__25661;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$cache_query_$_state_machine__2727__auto__ = function(state_25651){
switch(arguments.length){
case 0:
return fluree$db$query$fql$cache_query_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$cache_query_$_state_machine__2727__auto____1.call(this,state_25651);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$cache_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$cache_query_$_state_machine__2727__auto____0;
fluree$db$query$fql$cache_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$cache_query_$_state_machine__2727__auto____1;
return fluree$db$query$fql$cache_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25657 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25657[(6)] = c__2749__auto___25658);

return statearr_25657;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
});
return (oc.cljs$core$IFn$_invoke$arity$2 ? oc.cljs$core$IFn$_invoke$arity$2(G__25640,G__25641) : oc.call(null,G__25640,G__25641));
});
/**
 * Returns true if query was requested to run from the cache.
 */
fluree.db.query.fql.cache_QMARK_ = (function fluree$db$query$fql$cache_QMARK_(p__25662){
var map__25663 = p__25662;
var map__25663__$1 = cljs.core.__destructure_map(map__25663);
var _query_map = map__25663__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25663__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
return false;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
var G__25664_25666 = "Running query:";
var G__25665_25667 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
(fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2(G__25664_25666,G__25665_25667) : fluree.db.util.log.debug.call(null,G__25664_25666,G__25665_25667));

if(fluree.db.query.fql.cache_QMARK_(query_map)){
return fluree.db.query.fql.cache_query(db,query_map);
} else {
var parsed_query = fluree.db.query.analytical_parse.parse(db,query_map);
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"ctx-cache","ctx-cache",-391738418),cljs.core.volatile_BANG_(cljs.core.PersistentArrayMap.EMPTY));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"simple-subject-crawl","simple-subject-crawl",1022725044),new cljs.core.Keyword(null,"strategy","strategy",-1471631918).cljs$core$IFn$_invoke$arity$1(parsed_query))){
return fluree.db.query.subject_crawl.core.simple_subject_crawl(db_STAR_,parsed_query);
} else {
return fluree.db.query.fql.ad_hoc_query(db_STAR_,parsed_query,query_map);
}
}
});
