// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.ledger_id = ledger_id;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k27083,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__27087 = k27083;
var G__27087__$1 = (((G__27087 instanceof cljs.core.Keyword))?G__27087.fqn:null);
switch (G__27087__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "ledger-id":
return self__.ledger_id;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k27083,else__5346__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__27088){
var vec__27089 = p__27088;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27089,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27089,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.session.DbSession{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27082){
var self__ = this;
var G__27082__$1 = this;
return (new cljs.core.RecordIter((0),G__27082__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__27092 = (function (coll__5340__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
});
return fexpr__27092(this__5339__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27084,other27085){
var self__ = this;
var this27084__$1 = this;
return (((!((other27085 == null)))) && ((((this27084__$1.constructor === other27085.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27084__$1.conn,other27085.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27084__$1.network,other27085.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27084__$1.ledger_id,other27085.ledger_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27084__$1.db_name,other27085.db_name)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27084__$1.update_chan,other27085.update_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27084__$1.transact_chan,other27085.transact_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27084__$1.state,other27085.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27084__$1.schema_cache,other27085.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27084__$1.blank_db,other27085.blank_db)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27084__$1.close,other27085.close)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27084__$1.id,other27085.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27084__$1.__extmap,other27085.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k27083){
var self__ = this;
var this__5350__auto____$1 = this;
var G__27093 = k27083;
var G__27093__$1 = (((G__27093 instanceof cljs.core.Keyword))?G__27093.fqn:null);
switch (G__27093__$1) {
case "conn":
case "network":
case "ledger-id":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k27083);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__27082){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__27094 = cljs.core.keyword_identical_QMARK_;
var expr__27095 = k__5352__auto__;
if(cljs.core.truth_((function (){var G__27097 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__27098 = expr__27095;
return (pred__27094.cljs$core$IFn$_invoke$arity$2 ? pred__27094.cljs$core$IFn$_invoke$arity$2(G__27097,G__27098) : pred__27094.call(null,G__27097,G__27098));
})())){
return (new fluree.db.session.DbSession(G__27082,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27099 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__27100 = expr__27095;
return (pred__27094.cljs$core$IFn$_invoke$arity$2 ? pred__27094.cljs$core$IFn$_invoke$arity$2(G__27099,G__27100) : pred__27094.call(null,G__27099,G__27100));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__27082,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27101 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015);
var G__27102 = expr__27095;
return (pred__27094.cljs$core$IFn$_invoke$arity$2 ? pred__27094.cljs$core$IFn$_invoke$arity$2(G__27101,G__27102) : pred__27094.call(null,G__27101,G__27102));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__27082,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27103 = new cljs.core.Keyword(null,"db-name","db-name",1157928745);
var G__27104 = expr__27095;
return (pred__27094.cljs$core$IFn$_invoke$arity$2 ? pred__27094.cljs$core$IFn$_invoke$arity$2(G__27103,G__27104) : pred__27094.call(null,G__27103,G__27104));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,G__27082,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27105 = new cljs.core.Keyword(null,"update-chan","update-chan",-863760792);
var G__27106 = expr__27095;
return (pred__27094.cljs$core$IFn$_invoke$arity$2 ? pred__27094.cljs$core$IFn$_invoke$arity$2(G__27105,G__27106) : pred__27094.call(null,G__27105,G__27106));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,G__27082,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27107 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840);
var G__27108 = expr__27095;
return (pred__27094.cljs$core$IFn$_invoke$arity$2 ? pred__27094.cljs$core$IFn$_invoke$arity$2(G__27107,G__27108) : pred__27094.call(null,G__27107,G__27108));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,G__27082,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27109 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__27110 = expr__27095;
return (pred__27094.cljs$core$IFn$_invoke$arity$2 ? pred__27094.cljs$core$IFn$_invoke$arity$2(G__27109,G__27110) : pred__27094.call(null,G__27109,G__27110));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,G__27082,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27111 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__27112 = expr__27095;
return (pred__27094.cljs$core$IFn$_invoke$arity$2 ? pred__27094.cljs$core$IFn$_invoke$arity$2(G__27111,G__27112) : pred__27094.call(null,G__27111,G__27112));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__27082,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27113 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534);
var G__27114 = expr__27095;
return (pred__27094.cljs$core$IFn$_invoke$arity$2 ? pred__27094.cljs$core$IFn$_invoke$arity$2(G__27113,G__27114) : pred__27094.call(null,G__27113,G__27114));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__27082,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27115 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__27116 = expr__27095;
return (pred__27094.cljs$core$IFn$_invoke$arity$2 ? pred__27094.cljs$core$IFn$_invoke$arity$2(G__27115,G__27116) : pred__27094.call(null,G__27115,G__27116));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__27082,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27117 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__27118 = expr__27095;
return (pred__27094.cljs$core$IFn$_invoke$arity$2 ? pred__27094.cljs$core$IFn$_invoke$arity$2(G__27117,G__27118) : pred__27094.call(null,G__27117,G__27118));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__27082,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__27082),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__27082){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__27082,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"ledger-id","ledger-id",-949008754,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__27086){
var extmap__5385__auto__ = (function (){var G__27119 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__27086,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], 0));
if(cljs.core.record_QMARK_(G__27086)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__27119);
} else {
return G__27119;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27086),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27086),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(G__27086),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__27086),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__27086),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__27086),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__27086),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27086),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__27086),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__27086),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__27086),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__27122 = session;
var map__27122__$1 = cljs.core.__destructure_map(map__27122);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27122__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27122__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
}));

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,ledger_id){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,ledger_id){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.ready_QMARK_ = (function fluree$db$session$ready_QMARK_(db_info){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ready","ready",1086465795),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(db_info)));
});
fluree.db.session.load_ledger_info = (function fluree$db$session$load_ledger_info(conn,network,ledger_id){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27164){
var state_val_27165 = (state_27164[(1)]);
if((state_val_27165 === (7))){
var inst_27138 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)," is not found on this ledger group."].join('');
var inst_27139 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27140 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_27141 = cljs.core.PersistentHashMap.fromArrays(inst_27139,inst_27140);
var inst_27142 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27138,inst_27141);
var inst_27143 = (function(){throw inst_27142})();
var state_27164__$1 = state_27164;
var statearr_27166_27189 = state_27164__$1;
(statearr_27166_27189[(2)] = inst_27143);

(statearr_27166_27189[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27165 === (1))){
var state_27164__$1 = state_27164;
var statearr_27167_27190 = state_27164__$1;
(statearr_27167_27190[(2)] = null);

(statearr_27167_27190[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27165 === (4))){
var inst_27123 = (state_27164[(2)]);
var state_27164__$1 = state_27164;
var statearr_27168_27191 = state_27164__$1;
(statearr_27168_27191[(2)] = inst_27123);

(statearr_27168_27191[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27165 === (6))){
var inst_27135 = (state_27164[(7)]);
var inst_27134 = (state_27164[(2)]);
var inst_27135__$1 = fluree.db.util.async.throw_err(inst_27134);
var inst_27136 = cljs.core.empty_QMARK_(inst_27135__$1);
var state_27164__$1 = (function (){var statearr_27169 = state_27164;
(statearr_27169[(7)] = inst_27135__$1);

return statearr_27169;
})();
if(inst_27136){
var statearr_27170_27192 = state_27164__$1;
(statearr_27170_27192[(1)] = (7));

} else {
var statearr_27171_27193 = state_27164__$1;
(statearr_27171_27193[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27165 === (3))){
var inst_27162 = (state_27164[(2)]);
var state_27164__$1 = state_27164;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27164__$1,inst_27162);
} else {
if((state_val_27165 === (12))){
var inst_27157 = (state_27164[(2)]);
var state_27164__$1 = state_27164;
var statearr_27172_27194 = state_27164__$1;
(statearr_27172_27194[(2)] = inst_27157);

(statearr_27172_27194[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27165 === (2))){
var _ = (function (){var statearr_27173 = state_27164;
(statearr_27173[(4)] = cljs.core.cons((5),(state_27164[(4)])));

return statearr_27173;
})();
var inst_27129 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27130 = [network,ledger_id];
var inst_27131 = (new cljs.core.PersistentVector(null,2,(5),inst_27129,inst_27130,null));
var inst_27132 = fluree.db.operations.ledger_info_async(conn,inst_27131);
var state_27164__$1 = state_27164;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27164__$1,(6),inst_27132);
} else {
if((state_val_27165 === (11))){
var inst_27135 = (state_27164[(7)]);
var state_27164__$1 = state_27164;
var statearr_27175_27195 = state_27164__$1;
(statearr_27175_27195[(2)] = inst_27135);

(statearr_27175_27195[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27165 === (9))){
var inst_27159 = (state_27164[(2)]);
var _ = (function (){var statearr_27176 = state_27164;
(statearr_27176[(4)] = cljs.core.rest((state_27164[(4)])));

return statearr_27176;
})();
var state_27164__$1 = state_27164;
var statearr_27177_27196 = state_27164__$1;
(statearr_27177_27196[(2)] = inst_27159);

(statearr_27177_27196[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27165 === (5))){
var _ = (function (){var statearr_27178 = state_27164;
(statearr_27178[(4)] = cljs.core.rest((state_27164[(4)])));

return statearr_27178;
})();
var state_27164__$1 = state_27164;
var ex27174 = (state_27164__$1[(2)]);
var statearr_27179_27197 = state_27164__$1;
(statearr_27179_27197[(5)] = ex27174);


if((ex27174 instanceof Error)){
var statearr_27180_27198 = state_27164__$1;
(statearr_27180_27198[(1)] = (4));

(statearr_27180_27198[(5)] = null);

} else {
throw ex27174;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27165 === (10))){
var inst_27135 = (state_27164[(7)]);
var inst_27148 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_27135);
var inst_27149 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27148),"."].join('');
var inst_27150 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27151 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_27152 = cljs.core.PersistentHashMap.fromArrays(inst_27150,inst_27151);
var inst_27153 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27149,inst_27152);
var inst_27154 = (function(){throw inst_27153})();
var state_27164__$1 = state_27164;
var statearr_27181_27199 = state_27164__$1;
(statearr_27181_27199[(2)] = inst_27154);

(statearr_27181_27199[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27165 === (8))){
var inst_27135 = (state_27164[(7)]);
var inst_27145 = fluree.db.session.ready_QMARK_(inst_27135);
var inst_27146 = (!(inst_27145));
var state_27164__$1 = state_27164;
if(inst_27146){
var statearr_27182_27200 = state_27164__$1;
(statearr_27182_27200[(1)] = (10));

} else {
var statearr_27183_27201 = state_27164__$1;
(statearr_27183_27201[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_ledger_info_$_state_machine__2727__auto__ = null;
var fluree$db$session$load_ledger_info_$_state_machine__2727__auto____0 = (function (){
var statearr_27184 = [null,null,null,null,null,null,null,null];
(statearr_27184[(0)] = fluree$db$session$load_ledger_info_$_state_machine__2727__auto__);

(statearr_27184[(1)] = (1));

return statearr_27184;
});
var fluree$db$session$load_ledger_info_$_state_machine__2727__auto____1 = (function (state_27164){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27164);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27185){var ex__2730__auto__ = e27185;
var statearr_27186_27202 = state_27164;
(statearr_27186_27202[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27164[(4)]))){
var statearr_27187_27203 = state_27164;
(statearr_27187_27203[(1)] = cljs.core.first((state_27164[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27204 = state_27164;
state_27164 = G__27204;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$load_ledger_info_$_state_machine__2727__auto__ = function(state_27164){
switch(arguments.length){
case 0:
return fluree$db$session$load_ledger_info_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$load_ledger_info_$_state_machine__2727__auto____1.call(this,state_27164);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_ledger_info_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_ledger_info_$_state_machine__2727__auto____0;
fluree$db$session$load_ledger_info_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_ledger_info_$_state_machine__2727__auto____1;
return fluree$db$session$load_ledger_info_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27188 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27188[(6)] = c__2749__auto__);

return statearr_27188;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.session.load_current_db = (function fluree$db$session$load_current_db(conn,p__27205){
var map__27206 = p__27205;
var map__27206__$1 = cljs.core.__destructure_map(map__27206);
var blank_db = map__27206__$1;
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27206__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27206__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27281){
var state_val_27282 = (state_27281[(1)]);
if((state_val_27282 === (7))){
var inst_27224 = (state_27281[(7)]);
var inst_27223 = (state_27281[(2)]);
var inst_27224__$1 = fluree.db.util.async.throw_err(inst_27223);
var state_27281__$1 = (function (){var statearr_27283 = state_27281;
(statearr_27283[(7)] = inst_27224__$1);

return statearr_27283;
})();
if(cljs.core.truth_(inst_27224__$1)){
var statearr_27284_27319 = state_27281__$1;
(statearr_27284_27319[(1)] = (8));

} else {
var statearr_27285_27320 = state_27281__$1;
(statearr_27285_27320[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (20))){
var inst_27229 = (state_27281[(8)]);
var inst_27262 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27229)," for ledger: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_27263 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27264 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_27265 = cljs.core.PersistentHashMap.fromArrays(inst_27263,inst_27264);
var inst_27266 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27262,inst_27265);
var inst_27267 = (function(){throw inst_27266})();
var state_27281__$1 = state_27281;
var statearr_27286_27321 = state_27281__$1;
(statearr_27286_27321[(2)] = inst_27267);

(statearr_27286_27321[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (1))){
var state_27281__$1 = state_27281;
var statearr_27287_27322 = state_27281__$1;
(statearr_27287_27322[(2)] = null);

(statearr_27287_27322[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (4))){
var inst_27207 = (state_27281[(2)]);
var state_27281__$1 = state_27281;
var statearr_27288_27323 = state_27281__$1;
(statearr_27288_27323[(2)] = inst_27207);

(statearr_27288_27323[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (15))){
var inst_27271 = (state_27281[(2)]);
var state_27281__$1 = state_27281;
var statearr_27289_27324 = state_27281__$1;
(statearr_27289_27324[(2)] = inst_27271);

(statearr_27289_27324[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (21))){
var inst_27269 = (state_27281[(2)]);
var state_27281__$1 = state_27281;
var statearr_27290_27325 = state_27281__$1;
(statearr_27290_27325[(2)] = inst_27269);

(statearr_27290_27325[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (13))){
var inst_27228 = (state_27281[(9)]);
var inst_27233 = fluree.db.query.schema.schema_map(inst_27228);
var inst_27234 = fluree.db.query.schema.setting_map(inst_27228);
var inst_27235 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(inst_27228);
var inst_27236 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_27235,cljs.core.empty);
var state_27281__$1 = (function (){var statearr_27291 = state_27281;
(statearr_27291[(10)] = inst_27236);

(statearr_27291[(11)] = inst_27234);

return statearr_27291;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27281__$1,(16),inst_27233);
} else {
if((state_val_27282 === (22))){
var inst_27229 = (state_27281[(8)]);
var inst_27257 = (state_27281[(2)]);
var inst_27258 = fluree.db.util.async.throw_err(inst_27257);
var inst_27259 = (inst_27229 + (1));
var inst_27228 = inst_27258;
var inst_27229__$1 = inst_27259;
var state_27281__$1 = (function (){var statearr_27292 = state_27281;
(statearr_27292[(8)] = inst_27229__$1);

(statearr_27292[(9)] = inst_27228);

return statearr_27292;
})();
var statearr_27293_27326 = state_27281__$1;
(statearr_27293_27326[(2)] = null);

(statearr_27293_27326[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (6))){
var inst_27216 = (state_27281[(2)]);
var inst_27217 = fluree.db.util.async.throw_err(inst_27216);
var inst_27218 = cljs.core.__destructure_map(inst_27217);
var inst_27219 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27218,new cljs.core.Keyword(null,"block","block",664686210));
var inst_27220 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27218,new cljs.core.Keyword(null,"index","index",-1531685915));
var inst_27221 = fluree.db.storage.core.reify_db(conn,network,ledger_id,blank_db,inst_27220);
var state_27281__$1 = (function (){var statearr_27294 = state_27281;
(statearr_27294[(12)] = inst_27219);

return statearr_27294;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27281__$1,(7),inst_27221);
} else {
if((state_val_27282 === (17))){
var inst_27228 = (state_27281[(9)]);
var inst_27239 = (state_27281[(13)]);
var inst_27241 = (state_27281[(2)]);
var inst_27242 = fluree.db.util.async.throw_err(inst_27241);
var inst_27243 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_27228,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_27239,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"settings","settings",1556144875),inst_27242], 0));
var state_27281__$1 = state_27281;
var statearr_27295_27327 = state_27281__$1;
(statearr_27295_27327[(2)] = inst_27243);

(statearr_27295_27327[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (3))){
var inst_27279 = (state_27281[(2)]);
var state_27281__$1 = state_27281;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27281__$1,inst_27279);
} else {
if((state_val_27282 === (12))){
var inst_27273 = (state_27281[(2)]);
var state_27281__$1 = state_27281;
var statearr_27296_27328 = state_27281__$1;
(statearr_27296_27328[(2)] = inst_27273);

(statearr_27296_27328[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (2))){
var _ = (function (){var statearr_27297 = state_27281;
(statearr_27297[(4)] = cljs.core.cons((5),(state_27281[(4)])));

return statearr_27297;
})();
var inst_27214 = fluree.db.session.load_ledger_info(conn,network,ledger_id);
var state_27281__$1 = state_27281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27281__$1,(6),inst_27214);
} else {
if((state_val_27282 === (19))){
var inst_27248 = (state_27281[(14)]);
var inst_27228 = (state_27281[(9)]);
var inst_27251 = cljs.core.__destructure_map(inst_27248);
var inst_27252 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27251,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_27253 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27251,new cljs.core.Keyword(null,"block","block",664686210));
var inst_27254 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27251,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_27255 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_27228,inst_27253,inst_27252);
var state_27281__$1 = (function (){var statearr_27298 = state_27281;
(statearr_27298[(15)] = inst_27254);

return statearr_27298;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27281__$1,(22),inst_27255);
} else {
if((state_val_27282 === (11))){
var inst_27229 = (state_27281[(8)]);
var inst_27219 = (state_27281[(12)]);
var inst_27231 = (inst_27229 > inst_27219);
var state_27281__$1 = state_27281;
if(cljs.core.truth_(inst_27231)){
var statearr_27300_27329 = state_27281__$1;
(statearr_27300_27329[(1)] = (13));

} else {
var statearr_27301_27330 = state_27281__$1;
(statearr_27301_27330[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (9))){
var state_27281__$1 = state_27281;
var statearr_27302_27331 = state_27281__$1;
(statearr_27302_27331[(2)] = null);

(statearr_27302_27331[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (5))){
var _ = (function (){var statearr_27303 = state_27281;
(statearr_27303[(4)] = cljs.core.rest((state_27281[(4)])));

return statearr_27303;
})();
var state_27281__$1 = state_27281;
var ex27299 = (state_27281__$1[(2)]);
var statearr_27304_27332 = state_27281__$1;
(statearr_27304_27332[(5)] = ex27299);


if((ex27299 instanceof Error)){
var statearr_27305_27333 = state_27281__$1;
(statearr_27305_27333[(1)] = (4));

(statearr_27305_27333[(5)] = null);

} else {
throw ex27299;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (14))){
var inst_27229 = (state_27281[(8)]);
var inst_27245 = fluree.db.storage.core.read_block(conn,network,ledger_id,inst_27229);
var state_27281__$1 = state_27281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27281__$1,(18),inst_27245);
} else {
if((state_val_27282 === (16))){
var inst_27234 = (state_27281[(11)]);
var inst_27238 = (state_27281[(2)]);
var inst_27239 = fluree.db.util.async.throw_err(inst_27238);
var state_27281__$1 = (function (){var statearr_27306 = state_27281;
(statearr_27306[(13)] = inst_27239);

return statearr_27306;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27281__$1,(17),inst_27234);
} else {
if((state_val_27282 === (10))){
var inst_27276 = (state_27281[(2)]);
var _ = (function (){var statearr_27307 = state_27281;
(statearr_27307[(4)] = cljs.core.rest((state_27281[(4)])));

return statearr_27307;
})();
var state_27281__$1 = state_27281;
var statearr_27308_27334 = state_27281__$1;
(statearr_27308_27334[(2)] = inst_27276);

(statearr_27308_27334[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (18))){
var inst_27248 = (state_27281[(14)]);
var inst_27247 = (state_27281[(2)]);
var inst_27248__$1 = fluree.db.util.async.throw_err(inst_27247);
var state_27281__$1 = (function (){var statearr_27309 = state_27281;
(statearr_27309[(14)] = inst_27248__$1);

return statearr_27309;
})();
if(cljs.core.truth_(inst_27248__$1)){
var statearr_27310_27335 = state_27281__$1;
(statearr_27310_27335[(1)] = (19));

} else {
var statearr_27311_27336 = state_27281__$1;
(statearr_27311_27336[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (8))){
var inst_27224 = (state_27281[(7)]);
var inst_27226 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27224);
var inst_27227 = (inst_27226 + (1));
var inst_27228 = inst_27224;
var inst_27229 = inst_27227;
var state_27281__$1 = (function (){var statearr_27312 = state_27281;
(statearr_27312[(8)] = inst_27229);

(statearr_27312[(9)] = inst_27228);

return statearr_27312;
})();
var statearr_27313_27337 = state_27281__$1;
(statearr_27313_27337[(2)] = null);

(statearr_27313_27337[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_current_db_$_state_machine__2727__auto__ = null;
var fluree$db$session$load_current_db_$_state_machine__2727__auto____0 = (function (){
var statearr_27314 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27314[(0)] = fluree$db$session$load_current_db_$_state_machine__2727__auto__);

(statearr_27314[(1)] = (1));

return statearr_27314;
});
var fluree$db$session$load_current_db_$_state_machine__2727__auto____1 = (function (state_27281){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27281);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27315){var ex__2730__auto__ = e27315;
var statearr_27316_27338 = state_27281;
(statearr_27316_27338[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27281[(4)]))){
var statearr_27317_27339 = state_27281;
(statearr_27317_27339[(1)] = cljs.core.first((state_27281[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27340 = state_27281;
state_27281 = G__27340;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$load_current_db_$_state_machine__2727__auto__ = function(state_27281){
switch(arguments.length){
case 0:
return fluree$db$session$load_current_db_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$load_current_db_$_state_machine__2727__auto____1.call(this,state_27281);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_current_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_current_db_$_state_machine__2727__auto____0;
fluree$db$session$load_current_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_current_db_$_state_machine__2727__auto____1;
return fluree$db$session$load_current_db_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27318 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27318[(6)] = c__2749__auto__);

return statearr_27318;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Perform a compare and set operation to update the db stored in the session
 *   argument's state atom. Update the cache to `new-db-ch`, but only if the
 *   previously stored db channel is the same as the `old-db-ch`. Returns a boolean
 *   indicating whether the cache was updated.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(p__27341,old_db_ch,new_db_ch){
var map__27342 = p__27341;
var map__27342__$1 = cljs.core.__destructure_map(map__27342);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27342__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (p__27343){
var map__27344 = p__27343;
var map__27344__$1 = cljs.core.__destructure_map(map__27344);
var s = map__27344__$1;
var current = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27344__$1,new cljs.core.Keyword("db","current","db/current",-1088041545));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(current,old_db_ch)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("db","current","db/current",-1088041545),new_db_ch);
} else {
return s;
}
}))),new_db_ch);
});
/**
 * Clears db channel from session state, forcing a new full load next time db
 *   channel is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(p__27345){
var map__27346 = p__27345;
var map__27346__$1 = cljs.core.__destructure_map(map__27346);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27346__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
});
/**
 * Clears any cached database channels and forces an immediate reload. Returns a
 *   channel that will contain the newly loaded database
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(p__27347){
var map__27348 = p__27347;
var map__27348__$1 = cljs.core.__destructure_map(map__27348);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27348__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var blank_db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27348__$1,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27348__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var db_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),db_ch);

var c__2749__auto___27385 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27368){
var state_val_27369 = (state_27368[(1)]);
if((state_val_27369 === (1))){
var state_27368__$1 = state_27368;
var statearr_27370_27386 = state_27368__$1;
(statearr_27370_27386[(2)] = null);

(statearr_27370_27386[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27369 === (2))){
var _ = (function (){var statearr_27371 = state_27368;
(statearr_27371[(4)] = cljs.core.cons((5),(state_27368[(4)])));

return statearr_27371;
})();
var inst_27358 = fluree.db.session.load_current_db(conn,blank_db);
var state_27368__$1 = state_27368;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27368__$1,(6),inst_27358);
} else {
if((state_val_27369 === (3))){
var inst_27366 = (state_27368[(2)]);
var state_27368__$1 = state_27368;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27368__$1,inst_27366);
} else {
if((state_val_27369 === (4))){
var inst_27349 = (state_27368[(2)]);
var inst_27350 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
var inst_27351 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(inst_27349,"Error reloading db") : fluree.db.util.log.error.call(null,inst_27349,"Error reloading db"));
var inst_27352 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(db_ch,inst_27349);
var state_27368__$1 = (function (){var statearr_27373 = state_27368;
(statearr_27373[(7)] = inst_27351);

(statearr_27373[(8)] = inst_27350);

return statearr_27373;
})();
var statearr_27374_27387 = state_27368__$1;
(statearr_27374_27387[(2)] = inst_27352);

(statearr_27374_27387[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27369 === (5))){
var _ = (function (){var statearr_27375 = state_27368;
(statearr_27375[(4)] = cljs.core.rest((state_27368[(4)])));

return statearr_27375;
})();
var state_27368__$1 = state_27368;
var ex27372 = (state_27368__$1[(2)]);
var statearr_27376_27388 = state_27368__$1;
(statearr_27376_27388[(5)] = ex27372);


var statearr_27377_27389 = state_27368__$1;
(statearr_27377_27389[(1)] = (4));

(statearr_27377_27389[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27369 === (6))){
var inst_27360 = (state_27368[(2)]);
var inst_27361 = fluree.db.util.async.throw_err(inst_27360);
var state_27368__$1 = state_27368;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27368__$1,(7),db_ch,inst_27361);
} else {
if((state_val_27369 === (7))){
var inst_27363 = (state_27368[(2)]);
var _ = (function (){var statearr_27378 = state_27368;
(statearr_27378[(4)] = cljs.core.rest((state_27368[(4)])));

return statearr_27378;
})();
var state_27368__$1 = state_27368;
var statearr_27379_27390 = state_27368__$1;
(statearr_27379_27390[(2)] = inst_27363);

(statearr_27379_27390[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$reload_db_BANG__$_state_machine__2727__auto__ = null;
var fluree$db$session$reload_db_BANG__$_state_machine__2727__auto____0 = (function (){
var statearr_27380 = [null,null,null,null,null,null,null,null,null];
(statearr_27380[(0)] = fluree$db$session$reload_db_BANG__$_state_machine__2727__auto__);

(statearr_27380[(1)] = (1));

return statearr_27380;
});
var fluree$db$session$reload_db_BANG__$_state_machine__2727__auto____1 = (function (state_27368){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27368);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27381){var ex__2730__auto__ = e27381;
var statearr_27382_27391 = state_27368;
(statearr_27382_27391[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27368[(4)]))){
var statearr_27383_27392 = state_27368;
(statearr_27383_27392[(1)] = cljs.core.first((state_27368[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27393 = state_27368;
state_27368 = G__27393;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$reload_db_BANG__$_state_machine__2727__auto__ = function(state_27368){
switch(arguments.length){
case 0:
return fluree$db$session$reload_db_BANG__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$reload_db_BANG__$_state_machine__2727__auto____1.call(this,state_27368);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$reload_db_BANG__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$reload_db_BANG__$_state_machine__2727__auto____0;
fluree$db$session$reload_db_BANG__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$reload_db_BANG__$_state_machine__2727__auto____1;
return fluree$db$session$reload_db_BANG__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27384 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27384[(6)] = c__2749__auto___27385);

return statearr_27384;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return db_ch;
});
/**
 * Gets the channel containing the current database from the session's state. If
 *   no database channel is cached then the current database is loaded form storage
 *   and a new channel containing it is cached. Returns the cached channel that
 *   will contain the current database
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(var_args){
var G__27395 = arguments.length;
switch (G__27395) {
case 1:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 = (function (p__27396){
var map__27397 = p__27396;
var map__27397__$1 = cljs.core.__destructure_map(map__27397);
var session = map__27397__$1;
var blank_db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27397__$1,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534));
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2(session,blank_db);
}));

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2 = (function (p__27398,blank_db){
var map__27399 = p__27398;
var map__27399__$1 = cljs.core.__destructure_map(map__27399);
var session = map__27399__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27399__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27399__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (s){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis()),new cljs.core.Keyword("req","count","req/count",2145574363),cljs.core.inc);
}));

var or__5045__auto__ = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(state));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var cur_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var state_ch = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (s){
if(cljs.core.not(new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(s))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("db","current","db/current",-1088041545),cur_ch);
} else {
return s;
}
})));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cur_ch,state_ch)){
var c__2749__auto___27437 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27419){
var state_val_27420 = (state_27419[(1)]);
if((state_val_27420 === (1))){
var state_27419__$1 = state_27419;
var statearr_27421_27438 = state_27419__$1;
(statearr_27421_27438[(2)] = null);

(statearr_27421_27438[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27420 === (2))){
var _ = (function (){var statearr_27422 = state_27419;
(statearr_27422[(4)] = cljs.core.cons((5),(state_27419[(4)])));

return statearr_27422;
})();
var inst_27409 = fluree.db.session.load_current_db(conn,blank_db);
var state_27419__$1 = state_27419;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27419__$1,(6),inst_27409);
} else {
if((state_val_27420 === (3))){
var inst_27417 = (state_27419[(2)]);
var state_27419__$1 = state_27419;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27419__$1,inst_27417);
} else {
if((state_val_27420 === (4))){
var inst_27400 = (state_27419[(2)]);
var inst_27401 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
var inst_27402 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(inst_27400,"Error loading current db") : fluree.db.util.log.error.call(null,inst_27400,"Error loading current db"));
var inst_27403 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cur_ch,inst_27400);
var state_27419__$1 = (function (){var statearr_27424 = state_27419;
(statearr_27424[(7)] = inst_27402);

(statearr_27424[(8)] = inst_27401);

return statearr_27424;
})();
var statearr_27425_27439 = state_27419__$1;
(statearr_27425_27439[(2)] = inst_27403);

(statearr_27425_27439[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27420 === (5))){
var _ = (function (){var statearr_27426 = state_27419;
(statearr_27426[(4)] = cljs.core.rest((state_27419[(4)])));

return statearr_27426;
})();
var state_27419__$1 = state_27419;
var ex27423 = (state_27419__$1[(2)]);
var statearr_27427_27440 = state_27419__$1;
(statearr_27427_27440[(5)] = ex27423);


var statearr_27428_27441 = state_27419__$1;
(statearr_27428_27441[(1)] = (4));

(statearr_27428_27441[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27420 === (6))){
var inst_27411 = (state_27419[(2)]);
var inst_27412 = fluree.db.util.async.throw_err(inst_27411);
var state_27419__$1 = state_27419;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27419__$1,(7),cur_ch,inst_27412);
} else {
if((state_val_27420 === (7))){
var inst_27414 = (state_27419[(2)]);
var _ = (function (){var statearr_27429 = state_27419;
(statearr_27429[(4)] = cljs.core.rest((state_27419[(4)])));

return statearr_27429;
})();
var state_27419__$1 = state_27419;
var statearr_27430_27442 = state_27419__$1;
(statearr_27430_27442[(2)] = inst_27414);

(statearr_27430_27442[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2727__auto__ = null;
var fluree$db$session$state_machine__2727__auto____0 = (function (){
var statearr_27431 = [null,null,null,null,null,null,null,null,null];
(statearr_27431[(0)] = fluree$db$session$state_machine__2727__auto__);

(statearr_27431[(1)] = (1));

return statearr_27431;
});
var fluree$db$session$state_machine__2727__auto____1 = (function (state_27419){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27419);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27432){var ex__2730__auto__ = e27432;
var statearr_27433_27443 = state_27419;
(statearr_27433_27443[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27419[(4)]))){
var statearr_27434_27444 = state_27419;
(statearr_27434_27444[(1)] = cljs.core.first((state_27419[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27445 = state_27419;
state_27419 = G__27445;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$state_machine__2727__auto__ = function(state_27419){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2727__auto____1.call(this,state_27419);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2727__auto____0;
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2727__auto____1;
return fluree$db$session$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27435 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27435[(6)] = c__2749__auto___27437);

return statearr_27435;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return cur_ch;
} else {
return state_ch;
}
}
}));

(fluree.db.session.current_db.cljs$lang$maxFixedArity = 2);

/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_promise_ch = (function fluree$db$session$indexing_promise_ch(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock. Returns two-tuple of [lock? promise-chan]
 *   where lock? indicates if the lock was successful, and promise-chan is whatever
 *   promise-chan is registered for indexing.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,pc){
var swap_res = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),pc);
} else {
return s;
}
}));
var res_pc = new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(swap_res);
var lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(pc,res_pc);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lock_QMARK_,res_pc], null);
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("db","indexed","db/indexed",390759770),block], 0));
}));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__5045__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var ledger_id = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),ledger_id);

return ledger_id;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var maybe_alias = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return maybe_alias;
} else {
return and__5043__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
if(clojure.string.starts_with_QMARK_(maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id(network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__5642__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__27446 = cljs.core.get_global_hierarchy;
return (fexpr__27446.cljs$core$IFn$_invoke$arity$0 ? fexpr__27446.cljs$core$IFn$_invoke$arity$0() : fexpr__27446.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27448){
var state_val_27449 = (state_27448[(1)]);
if((state_val_27449 === (1))){
var state_27448__$1 = state_27448;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27448__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2727__auto__ = null;
var fluree$db$session$state_machine__2727__auto____0 = (function (){
var statearr_27450 = [null,null,null,null,null,null,null];
(statearr_27450[(0)] = fluree$db$session$state_machine__2727__auto__);

(statearr_27450[(1)] = (1));

return statearr_27450;
});
var fluree$db$session$state_machine__2727__auto____1 = (function (state_27448){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27448);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27451){var ex__2730__auto__ = e27451;
var statearr_27452_27455 = state_27448;
(statearr_27452_27455[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27448[(4)]))){
var statearr_27453_27456 = state_27448;
(statearr_27453_27456[(1)] = cljs.core.first((state_27448[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27457 = state_27448;
state_27448 = G__27457;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$state_machine__2727__auto__ = function(state_27448){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2727__auto____1.call(this,state_27448);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2727__auto____0;
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2727__auto____1;
return fluree$db$session$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27454 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27454[(6)] = c__2749__auto__);

return statearr_27454;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__27458){
var map__27459 = p__27458;
var map__27459__$1 = cljs.core.__destructure_map(map__27459);
var data = map__27459__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27459__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27459__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27459__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27518){
var state_val_27519 = (state_27518[(1)]);
if((state_val_27519 === (7))){
var inst_27470 = (state_27518[(7)]);
var inst_27473 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27474 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27475 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27473),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27474),": Received block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current at block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27470),". No-op."].join('');
var inst_27476 = (fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1(inst_27475) : fluree.db.util.log.info.call(null,inst_27475));
var state_27518__$1 = state_27518;
var statearr_27520_27558 = state_27518__$1;
(statearr_27520_27558[(2)] = inst_27476);

(statearr_27520_27558[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27519 === (1))){
var state_27518__$1 = state_27518;
var statearr_27521_27559 = state_27518__$1;
(statearr_27521_27559[(2)] = null);

(statearr_27521_27559[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27519 === (4))){
var inst_27460 = (state_27518[(2)]);
var state_27518__$1 = state_27518;
var statearr_27522_27560 = state_27518__$1;
(statearr_27522_27560[(2)] = inst_27460);

(statearr_27522_27560[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27519 === (15))){
var inst_27499 = (state_27518[(2)]);
var state_27518__$1 = state_27518;
var statearr_27523_27561 = state_27518__$1;
(statearr_27523_27561[(2)] = inst_27499);

(statearr_27523_27561[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27519 === (13))){
var inst_27490 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_27491 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27492 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27493 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27494 = [inst_27492,inst_27493];
var inst_27495 = (new cljs.core.PersistentVector(null,2,(5),inst_27491,inst_27494,null));
var inst_27496 = (function (){var G__27524 = inst_27490;
var G__27525 = new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117);
var G__27526 = inst_27495;
var G__27527 = data;
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(G__27524,G__27525,G__27526,G__27527) : fluree.db.conn_events.process_event.call(null,G__27524,G__27525,G__27526,G__27527));
})();
var state_27518__$1 = state_27518;
var statearr_27528_27562 = state_27518__$1;
(statearr_27528_27562[(2)] = inst_27496);

(statearr_27528_27562[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27519 === (6))){
var inst_27470 = (state_27518[(7)]);
var inst_27469 = (state_27518[(8)]);
var inst_27468 = (state_27518[(2)]);
var inst_27469__$1 = fluree.db.util.async.throw_err(inst_27468);
var inst_27470__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27469__$1);
var inst_27471 = (block <= inst_27470__$1);
var state_27518__$1 = (function (){var statearr_27529 = state_27518;
(statearr_27529[(7)] = inst_27470__$1);

(statearr_27529[(8)] = inst_27469__$1);

return statearr_27529;
})();
if(cljs.core.truth_(inst_27471)){
var statearr_27530_27563 = state_27518__$1;
(statearr_27530_27563[(1)] = (7));

} else {
var statearr_27531_27564 = state_27518__$1;
(statearr_27531_27564[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27519 === (17))){
var state_27518__$1 = state_27518;
var statearr_27532_27565 = state_27518__$1;
(statearr_27532_27565[(2)] = null);

(statearr_27532_27565[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27519 === (3))){
var inst_27516 = (state_27518[(2)]);
var state_27518__$1 = state_27518;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27518__$1,inst_27516);
} else {
if((state_val_27519 === (12))){
var inst_27511 = (state_27518[(2)]);
var state_27518__$1 = state_27518;
var statearr_27533_27566 = state_27518__$1;
(statearr_27533_27566[(2)] = inst_27511);

(statearr_27533_27566[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27519 === (2))){
var inst_27466 = (state_27518[(9)]);
var _ = (function (){var statearr_27534 = state_27518;
(statearr_27534[(4)] = cljs.core.cons((5),(state_27518[(4)])));

return statearr_27534;
})();
var inst_27466__$1 = fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session);
var state_27518__$1 = (function (){var statearr_27535 = state_27518;
(statearr_27535[(9)] = inst_27466__$1);

return statearr_27535;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27518__$1,(6),inst_27466__$1);
} else {
if((state_val_27519 === (11))){
var state_27518__$1 = state_27518;
var statearr_27537_27567 = state_27518__$1;
(statearr_27537_27567[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27519 === (9))){
var inst_27513 = (state_27518[(2)]);
var _ = (function (){var statearr_27539 = state_27518;
(statearr_27539[(4)] = cljs.core.rest((state_27518[(4)])));

return statearr_27539;
})();
var state_27518__$1 = state_27518;
var statearr_27540_27568 = state_27518__$1;
(statearr_27540_27568[(2)] = inst_27513);

(statearr_27540_27568[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27519 === (5))){
var _ = (function (){var statearr_27541 = state_27518;
(statearr_27541[(4)] = cljs.core.rest((state_27518[(4)])));

return statearr_27541;
})();
var state_27518__$1 = state_27518;
var ex27536 = (state_27518__$1[(2)]);
var statearr_27542_27569 = state_27518__$1;
(statearr_27542_27569[(5)] = ex27536);


if((ex27536 instanceof Error)){
var statearr_27543_27570 = state_27518__$1;
(statearr_27543_27570[(1)] = (4));

(statearr_27543_27570[(5)] = null);

} else {
throw ex27536;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27519 === (14))){
var state_27518__$1 = state_27518;
var statearr_27544_27571 = state_27518__$1;
(statearr_27544_27571[(2)] = null);

(statearr_27544_27571[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27519 === (16))){
var inst_27470 = (state_27518[(7)]);
var inst_27502 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27503 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27504 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27502),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27503),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27470),". Forcing a db reload."].join('');
var inst_27505 = (fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1(inst_27504) : fluree.db.util.log.info.call(null,inst_27504));
var inst_27506 = fluree.db.session.reload_db_BANG_(session);
var state_27518__$1 = (function (){var statearr_27545 = state_27518;
(statearr_27545[(10)] = inst_27505);

return statearr_27545;
})();
var statearr_27546_27572 = state_27518__$1;
(statearr_27546_27572[(2)] = inst_27506);

(statearr_27546_27572[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27519 === (10))){
var inst_27470 = (state_27518[(7)]);
var inst_27469 = (state_27518[(8)]);
var inst_27466 = (state_27518[(9)]);
var inst_27481 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27482 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27483 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27481),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27482),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_27484 = (fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$1(inst_27483) : fluree.db.util.log.trace.call(null,inst_27483));
var inst_27485 = (function (){var current_db_ch = inst_27466;
var current_db = inst_27469;
var current_block = inst_27470;
return (function (f){
if((f instanceof fluree.db.flake.Flake)){
return f;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(f);
}
});
})();
var inst_27486 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_27485,flakes);
var inst_27487 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_27469,block,inst_27486);
var inst_27488 = fluree.db.session.cas_db_BANG_(session,inst_27466,inst_27487);
var state_27518__$1 = (function (){var statearr_27547 = state_27518;
(statearr_27547[(11)] = inst_27484);

return statearr_27547;
})();
if(inst_27488){
var statearr_27548_27573 = state_27518__$1;
(statearr_27548_27573[(1)] = (13));

} else {
var statearr_27549_27574 = state_27518__$1;
(statearr_27549_27574[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27519 === (18))){
var inst_27509 = (state_27518[(2)]);
var state_27518__$1 = state_27518;
var statearr_27550_27575 = state_27518__$1;
(statearr_27550_27575[(2)] = inst_27509);

(statearr_27550_27575[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27519 === (8))){
var inst_27470 = (state_27518[(7)]);
var inst_27478 = ((1) + inst_27470);
var inst_27479 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_27478);
var state_27518__$1 = state_27518;
if(inst_27479){
var statearr_27551_27576 = state_27518__$1;
(statearr_27551_27576[(1)] = (10));

} else {
var statearr_27552_27577 = state_27518__$1;
(statearr_27552_27577[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2727__auto__ = null;
var fluree$db$session$state_machine__2727__auto____0 = (function (){
var statearr_27553 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27553[(0)] = fluree$db$session$state_machine__2727__auto__);

(statearr_27553[(1)] = (1));

return statearr_27553;
});
var fluree$db$session$state_machine__2727__auto____1 = (function (state_27518){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27518);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27554){var ex__2730__auto__ = e27554;
var statearr_27555_27578 = state_27518;
(statearr_27555_27578[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27518[(4)]))){
var statearr_27556_27579 = state_27518;
(statearr_27556_27579[(1)] = cljs.core.first((state_27518[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27580 = state_27518;
state_27518 = G__27580;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$state_machine__2727__auto__ = function(state_27518){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2727__auto____1.call(this,state_27518);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2727__auto____0;
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2727__auto____1;
return fluree$db$session$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27557 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27557[(6)] = c__2749__auto__);

return statearr_27557;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27587){
var state_val_27588 = (state_27587[(1)]);
if((state_val_27588 === (1))){
var inst_27581 = fluree.db.session.clear_db_BANG_(session);
var inst_27582 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27583 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27584 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27582),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27583)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_27585 = (fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$1(inst_27584) : fluree.db.util.log.debug.call(null,inst_27584));
var state_27587__$1 = (function (){var statearr_27589 = state_27587;
(statearr_27589[(7)] = inst_27581);

(statearr_27589[(8)] = inst_27585);

return statearr_27589;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_27587__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2727__auto__ = null;
var fluree$db$session$state_machine__2727__auto____0 = (function (){
var statearr_27590 = [null,null,null,null,null,null,null,null,null];
(statearr_27590[(0)] = fluree$db$session$state_machine__2727__auto__);

(statearr_27590[(1)] = (1));

return statearr_27590;
});
var fluree$db$session$state_machine__2727__auto____1 = (function (state_27587){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27587);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27591){var ex__2730__auto__ = e27591;
var statearr_27592_27595 = state_27587;
(statearr_27592_27595[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27587[(4)]))){
var statearr_27593_27596 = state_27587;
(statearr_27593_27596[(1)] = cljs.core.first((state_27587[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27597 = state_27587;
state_27587 = G__27597;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$state_machine__2727__auto__ = function(state_27587){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2727__auto____1.call(this,state_27587);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2727__auto____0;
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2727__auto____1;
return fluree$db$session$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27594 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27594[(6)] = c__2749__auto__);

return statearr_27594;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + ledger-id will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__27599 = arguments.length;
switch (G__27599) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (p__27600){
var map__27601 = p__27600;
var map__27601__$1 = cljs.core.__destructure_map(map__27601);
var session = map__27601__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27601__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27601__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27601__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27601__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27601__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27601__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27601__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.truth_(fluree.db.session.closed_QMARK_(session))){
fluree.db.session.remove_cache_BANG_(network,ledger_id);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

var fexpr__27602_27605 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__27602_27605.cljs$core$IFn$_invoke$arity$3 ? fexpr__27602_27605.cljs$core$IFn$_invoke$arity$3(network,ledger_id,id) : fexpr__27602_27605.call(null,network,ledger_id,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,ledger_id);

if(cljs.core.fn_QMARK_(new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__27603_27606 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session);
(fexpr__27603_27606.cljs$core$IFn$_invoke$arity$0 ? fexpr__27603_27606.cljs$core$IFn$_invoke$arity$0() : fexpr__27603_27606.call(null));
} else {
}

return true;
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,ledger_id){
var temp__5802__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(temp__5802__auto__)){
var session = temp__5802__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27658){
var state_val_27659 = (state_27658[(1)]);
if((state_val_27659 === (7))){
var inst_27654 = (state_27658[(2)]);
var state_27658__$1 = state_27658;
var statearr_27660_27691 = state_27658__$1;
(statearr_27660_27691[(2)] = inst_27654);

(statearr_27660_27691[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27659 === (1))){
var state_27658__$1 = state_27658;
var statearr_27661_27692 = state_27658__$1;
(statearr_27661_27692[(2)] = null);

(statearr_27661_27692[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27659 === (4))){
var inst_27610 = (state_27658[(7)]);
var inst_27609 = (state_27658[(2)]);
var inst_27610__$1 = fluree.db.util.async.throw_err(inst_27609);
var inst_27611 = fluree.db.session.from_cache(network,ledger_id);
var inst_27612 = (inst_27610__$1 == null);
var state_27658__$1 = (function (){var statearr_27662 = state_27658;
(statearr_27662[(7)] = inst_27610__$1);

(statearr_27662[(8)] = inst_27611);

return statearr_27662;
})();
if(cljs.core.truth_(inst_27612)){
var statearr_27663_27693 = state_27658__$1;
(statearr_27663_27693[(1)] = (5));

} else {
var statearr_27664_27694 = state_27658__$1;
(statearr_27664_27694[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27659 === (15))){
var inst_27646 = (state_27658[(2)]);
var state_27658__$1 = (function (){var statearr_27665 = state_27658;
(statearr_27665[(9)] = inst_27646);

return statearr_27665;
})();
var statearr_27666_27695 = state_27658__$1;
(statearr_27666_27695[(2)] = null);

(statearr_27666_27695[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27659 === (13))){
var inst_27650 = (state_27658[(2)]);
var state_27658__$1 = state_27658;
var statearr_27668_27696 = state_27658__$1;
(statearr_27668_27696[(2)] = inst_27650);

(statearr_27668_27696[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27659 === (6))){
var inst_27611 = (state_27658[(8)]);
var inst_27617 = (inst_27611 == null);
var state_27658__$1 = state_27658;
if(cljs.core.truth_(inst_27617)){
var statearr_27669_27697 = state_27658__$1;
(statearr_27669_27697[(1)] = (8));

} else {
var statearr_27670_27698 = state_27658__$1;
(statearr_27670_27698[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27659 === (17))){
var _ = (function (){var statearr_27671 = state_27658;
(statearr_27671[(4)] = cljs.core.rest((state_27658[(4)])));

return statearr_27671;
})();
var state_27658__$1 = state_27658;
var ex27667 = (state_27658__$1[(2)]);
var statearr_27672_27699 = state_27658__$1;
(statearr_27672_27699[(5)] = ex27667);


var statearr_27673_27700 = state_27658__$1;
(statearr_27673_27700[(1)] = (16));

(statearr_27673_27700[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27659 === (3))){
var inst_27656 = (state_27658[(2)]);
var state_27658__$1 = state_27658;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27658__$1,inst_27656);
} else {
if((state_val_27659 === (12))){
var state_27658__$1 = state_27658;
var statearr_27674_27701 = state_27658__$1;
(statearr_27674_27701[(2)] = null);

(statearr_27674_27701[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27659 === (2))){
var state_27658__$1 = state_27658;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27658__$1,(4),update_chan);
} else {
if((state_val_27659 === (11))){
var state_27658__$1 = state_27658;
var statearr_27675_27702 = state_27658__$1;
(statearr_27675_27702[(2)] = null);

(statearr_27675_27702[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27659 === (9))){
var state_27658__$1 = state_27658;
var statearr_27676_27703 = state_27658__$1;
(statearr_27676_27703[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27659 === (5))){
var inst_27614 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_27615 = (fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$2("Channel closed for session updates for:",inst_27614) : fluree.db.util.log.info.call(null,"Channel closed for session updates for:",inst_27614));
var state_27658__$1 = state_27658;
var statearr_27678_27704 = state_27658__$1;
(statearr_27678_27704[(2)] = inst_27615);

(statearr_27678_27704[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27659 === (14))){
var inst_27610 = (state_27658[(7)]);
var inst_27611 = (state_27658[(8)]);
var _ = (function (){var statearr_27679 = state_27658;
(statearr_27679[(4)] = cljs.core.cons((17),(state_27658[(4)])));

return statearr_27679;
})();
var inst_27634 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27610,(0),null);
var inst_27635 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27610,(1),null);
var inst_27636 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_27637 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27610], 0));
var inst_27638 = fluree.db.util.core.trunc(inst_27637,(200));
var inst_27639 = (fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2(inst_27636,inst_27638) : fluree.db.util.log.trace.call(null,inst_27636,inst_27638));
var inst_27640 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_27611,inst_27634,inst_27635) : fluree.db.session.process_ledger_update.call(null,inst_27611,inst_27634,inst_27635));
var state_27658__$1 = (function (){var statearr_27680 = state_27658;
(statearr_27680[(10)] = inst_27639);

return statearr_27680;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27658__$1,(18),inst_27640);
} else {
if((state_val_27659 === (16))){
var inst_27610 = (state_27658[(7)]);
var inst_27624 = (state_27658[(2)]);
var inst_27625 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3(inst_27624,"Exception processing ledger updates for message: ",inst_27610) : fluree.db.util.log.error.call(null,inst_27624,"Exception processing ledger updates for message: ",inst_27610));
var state_27658__$1 = state_27658;
var statearr_27681_27705 = state_27658__$1;
(statearr_27681_27705[(2)] = inst_27625);

(statearr_27681_27705[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27659 === (10))){
var inst_27652 = (state_27658[(2)]);
var state_27658__$1 = state_27658;
var statearr_27682_27706 = state_27658__$1;
(statearr_27682_27706[(2)] = inst_27652);

(statearr_27682_27706[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27659 === (18))){
var inst_27642 = (state_27658[(2)]);
var inst_27643 = fluree.db.util.async.throw_err(inst_27642);
var _ = (function (){var statearr_27683 = state_27658;
(statearr_27683[(4)] = cljs.core.rest((state_27658[(4)])));

return statearr_27683;
})();
var state_27658__$1 = state_27658;
var statearr_27684_27707 = state_27658__$1;
(statearr_27684_27707[(2)] = inst_27643);

(statearr_27684_27707[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27659 === (8))){
var inst_27610 = (state_27658[(7)]);
var inst_27619 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_27620 = cljs.core.first(inst_27610);
var inst_27621 = (fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$4("Ledger update received for session that is no longer open:",inst_27619,"Message: ",inst_27620) : fluree.db.util.log.warn.call(null,"Ledger update received for session that is no longer open:",inst_27619,"Message: ",inst_27620));
var state_27658__$1 = state_27658;
var statearr_27685_27708 = state_27658__$1;
(statearr_27685_27708[(2)] = inst_27621);

(statearr_27685_27708[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__2727__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__2727__auto____0 = (function (){
var statearr_27686 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27686[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__2727__auto__);

(statearr_27686[(1)] = (1));

return statearr_27686;
});
var fluree$db$session$process_ledger_updates_$_state_machine__2727__auto____1 = (function (state_27658){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27658);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27687){var ex__2730__auto__ = e27687;
var statearr_27688_27709 = state_27658;
(statearr_27688_27709[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27658[(4)]))){
var statearr_27689_27710 = state_27658;
(statearr_27689_27710[(1)] = cljs.core.first((state_27658[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27711 = state_27658;
state_27658 = G__27711;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__2727__auto__ = function(state_27658){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__2727__auto____1.call(this,state_27658);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__2727__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__2727__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27690 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27690[(6)] = c__2749__auto__);

return statearr_27690;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Creates a connection without first checking if one already exists. Only useful
 *   if reloading and replacing an existing session.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__27712){
var map__27713 = p__27712;
var map__27713__$1 = cljs.core.__destructure_map(map__27713);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27713__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27713__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27713__$1,new cljs.core.Keyword(null,"db","db",993250759));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27713__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27713__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27713__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27713__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27713__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27713__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cur_db = (cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","current","db/current",-1088041545),cur_db,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[ledger_id,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0(),db_name,state__$1,close,id,schema_cache,(cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null),network,null,conn]));
var current_db_fn = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.session.current_db,session);
var blank_db = fluree.db.graphdb.blank_db(conn,network,ledger_id,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__27717 = block_result;
var map__27717__$1 = cljs.core.__destructure_map(map__27717);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27717__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27717__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27717__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27717__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27717__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__27718 = tx_result;
var map__27718__$1 = cljs.core.__destructure_map(map__27718);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27718__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27718__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?(function (p1__27714_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,fluree.db.flake.t(p1__27714_SHARP_));
}):(function (p1__27715_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__27715_SHARP_,(3)));
}));
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some((function (p1__27716_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__27716_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__27716_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__27719 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27719,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27719,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27719,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27719,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__5045__auto__ = message;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var G__27722_27724 = "Create and cache session. Opt keys: ";
var G__27723_27725 = cljs.core.keys(opts);
(fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2(G__27722_27724,G__27723_27725) : fluree.db.util.log.trace.call(null,G__27722_27724,G__27723_27725));

var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2("session",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid()),(0),(7)));
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__27727 = arguments.length;
switch (G__27727) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__27728){
var map__27729 = p__27728;
var map__27729__$1 = cljs.core.__destructure_map(map__27729);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27729__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27729__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27729__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27729__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__27730 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27730,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27730,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27730,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__5045__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__5045__auto____$1 = state;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__27734_27886 = network;
var G__27735_27887 = ledger_id;
var G__27736_27888 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session);
var G__27737_27889 = (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5804__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5804__auto__)){
var tx_callbacks = temp__5804__auto__;
var tids = cljs.core.keys(new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__27738 = cljs.core.seq(tids);
var chunk__27739 = null;
var count__27740 = (0);
var i__27741 = (0);
while(true){
if((i__27741 < count__27740)){
var tid = chunk__27739.cljs$core$IIndexed$_nth$arity$2(null,i__27741);
var temp__5804__auto___27891__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5804__auto___27891__$1)){
var keyed_callbacks_27892 = temp__5804__auto___27891__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_27893 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__27798_27894 = cljs.core.seq(keyed_callbacks_27892);
var chunk__27799_27895 = null;
var count__27800_27896 = (0);
var i__27801_27897 = (0);
while(true){
if((i__27801_27897 < count__27800_27896)){
var vec__27814_27898 = chunk__27799_27895.cljs$core$IIndexed$_nth$arity$2(null,i__27801_27897);
var k_27899 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27814_27898,(0),null);
var f_27900 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27814_27898,(1),null);
try{(f_27900.cljs$core$IFn$_invoke$arity$1 ? f_27900.cljs$core$IFn$_invoke$arity$1(tx_response_27893) : f_27900.call(null,tx_response_27893));
}catch (e27817){var e_27901 = e27817;
var G__27818_27902 = e_27901;
var G__27819_27903 = ["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('');
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__27818_27902,G__27819_27903) : fluree.db.util.log.error.call(null,G__27818_27902,G__27819_27903));
}

var G__27904 = seq__27798_27894;
var G__27905 = chunk__27799_27895;
var G__27906 = count__27800_27896;
var G__27907 = (i__27801_27897 + (1));
seq__27798_27894 = G__27904;
chunk__27799_27895 = G__27905;
count__27800_27896 = G__27906;
i__27801_27897 = G__27907;
continue;
} else {
var temp__5804__auto___27908__$2 = cljs.core.seq(seq__27798_27894);
if(temp__5804__auto___27908__$2){
var seq__27798_27909__$1 = temp__5804__auto___27908__$2;
if(cljs.core.chunked_seq_QMARK_(seq__27798_27909__$1)){
var c__5568__auto___27910 = cljs.core.chunk_first(seq__27798_27909__$1);
var G__27911 = cljs.core.chunk_rest(seq__27798_27909__$1);
var G__27912 = c__5568__auto___27910;
var G__27913 = cljs.core.count(c__5568__auto___27910);
var G__27914 = (0);
seq__27798_27894 = G__27911;
chunk__27799_27895 = G__27912;
count__27800_27896 = G__27913;
i__27801_27897 = G__27914;
continue;
} else {
var vec__27820_27915 = cljs.core.first(seq__27798_27909__$1);
var k_27916 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27820_27915,(0),null);
var f_27917 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27820_27915,(1),null);
try{(f_27917.cljs$core$IFn$_invoke$arity$1 ? f_27917.cljs$core$IFn$_invoke$arity$1(tx_response_27893) : f_27917.call(null,tx_response_27893));
}catch (e27823){var e_27918 = e27823;
var G__27824_27919 = e_27918;
var G__27825_27920 = ["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('');
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__27824_27919,G__27825_27920) : fluree.db.util.log.error.call(null,G__27824_27919,G__27825_27920));
}

var G__27921 = cljs.core.next(seq__27798_27909__$1);
var G__27922 = null;
var G__27923 = (0);
var G__27924 = (0);
seq__27798_27894 = G__27921;
chunk__27799_27895 = G__27922;
count__27800_27896 = G__27923;
i__27801_27897 = G__27924;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__27925 = seq__27738;
var G__27926 = chunk__27739;
var G__27927 = count__27740;
var G__27928 = (i__27741 + (1));
seq__27738 = G__27925;
chunk__27739 = G__27926;
count__27740 = G__27927;
i__27741 = G__27928;
continue;
} else {
var temp__5804__auto____$1 = cljs.core.seq(seq__27738);
if(temp__5804__auto____$1){
var seq__27738__$1 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__27738__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__27738__$1);
var G__27929 = cljs.core.chunk_rest(seq__27738__$1);
var G__27930 = c__5568__auto__;
var G__27931 = cljs.core.count(c__5568__auto__);
var G__27932 = (0);
seq__27738 = G__27929;
chunk__27739 = G__27930;
count__27740 = G__27931;
i__27741 = G__27932;
continue;
} else {
var tid = cljs.core.first(seq__27738__$1);
var temp__5804__auto___27933__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5804__auto___27933__$2)){
var keyed_callbacks_27934 = temp__5804__auto___27933__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_27935 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__27826_27936 = cljs.core.seq(keyed_callbacks_27934);
var chunk__27827_27937 = null;
var count__27828_27938 = (0);
var i__27829_27939 = (0);
while(true){
if((i__27829_27939 < count__27828_27938)){
var vec__27842_27940 = chunk__27827_27937.cljs$core$IIndexed$_nth$arity$2(null,i__27829_27939);
var k_27941 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27842_27940,(0),null);
var f_27942 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27842_27940,(1),null);
try{(f_27942.cljs$core$IFn$_invoke$arity$1 ? f_27942.cljs$core$IFn$_invoke$arity$1(tx_response_27935) : f_27942.call(null,tx_response_27935));
}catch (e27845){var e_27943 = e27845;
var G__27846_27944 = e_27943;
var G__27847_27945 = ["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('');
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__27846_27944,G__27847_27945) : fluree.db.util.log.error.call(null,G__27846_27944,G__27847_27945));
}

var G__27946 = seq__27826_27936;
var G__27947 = chunk__27827_27937;
var G__27948 = count__27828_27938;
var G__27949 = (i__27829_27939 + (1));
seq__27826_27936 = G__27946;
chunk__27827_27937 = G__27947;
count__27828_27938 = G__27948;
i__27829_27939 = G__27949;
continue;
} else {
var temp__5804__auto___27950__$3 = cljs.core.seq(seq__27826_27936);
if(temp__5804__auto___27950__$3){
var seq__27826_27951__$1 = temp__5804__auto___27950__$3;
if(cljs.core.chunked_seq_QMARK_(seq__27826_27951__$1)){
var c__5568__auto___27952 = cljs.core.chunk_first(seq__27826_27951__$1);
var G__27953 = cljs.core.chunk_rest(seq__27826_27951__$1);
var G__27954 = c__5568__auto___27952;
var G__27955 = cljs.core.count(c__5568__auto___27952);
var G__27956 = (0);
seq__27826_27936 = G__27953;
chunk__27827_27937 = G__27954;
count__27828_27938 = G__27955;
i__27829_27939 = G__27956;
continue;
} else {
var vec__27848_27957 = cljs.core.first(seq__27826_27951__$1);
var k_27958 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27848_27957,(0),null);
var f_27959 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27848_27957,(1),null);
try{(f_27959.cljs$core$IFn$_invoke$arity$1 ? f_27959.cljs$core$IFn$_invoke$arity$1(tx_response_27935) : f_27959.call(null,tx_response_27935));
}catch (e27851){var e_27960 = e27851;
var G__27852_27961 = e_27960;
var G__27853_27962 = ["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('');
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__27852_27961,G__27853_27962) : fluree.db.util.log.error.call(null,G__27852_27961,G__27853_27962));
}

var G__27963 = cljs.core.next(seq__27826_27951__$1);
var G__27964 = null;
var G__27965 = (0);
var G__27966 = (0);
seq__27826_27936 = G__27963;
chunk__27827_27937 = G__27964;
count__27828_27938 = G__27965;
i__27829_27939 = G__27966;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__27967 = cljs.core.next(seq__27738__$1);
var G__27968 = null;
var G__27969 = (0);
var G__27970 = (0);
seq__27738 = G__27967;
chunk__27739 = G__27968;
count__27740 = G__27969;
i__27741 = G__27970;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
var fexpr__27733_27890 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__27733_27890.cljs$core$IFn$_invoke$arity$4 ? fexpr__27733_27890.cljs$core$IFn$_invoke$arity$4(G__27734_27886,G__27735_27887,G__27736_27888,G__27737_27889) : fexpr__27733_27890.call(null,G__27734_27886,G__27735_27887,G__27736_27888,G__27737_27889));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_27971 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__2749__auto___27972 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27870){
var state_val_27871 = (state_27870[(1)]);
if((state_val_27871 === (1))){
var state_27870__$1 = state_27870;
var statearr_27872_27973 = state_27870__$1;
(statearr_27872_27973[(2)] = null);

(statearr_27872_27973[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (2))){
var inst_27855 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_27870__$1 = state_27870;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27870__$1,(4),inst_27855);
} else {
if((state_val_27871 === (3))){
var inst_27868 = (state_27870[(2)]);
var state_27870__$1 = state_27870;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27870__$1,inst_27868);
} else {
if((state_val_27871 === (4))){
var inst_27857 = (state_27870[(7)]);
var inst_27857__$1 = (state_27870[(2)]);
var inst_27858 = (inst_27857__$1 == null);
var state_27870__$1 = (function (){var statearr_27873 = state_27870;
(statearr_27873[(7)] = inst_27857__$1);

return statearr_27873;
})();
if(cljs.core.truth_(inst_27858)){
var statearr_27874_27974 = state_27870__$1;
(statearr_27874_27974[(1)] = (5));

} else {
var statearr_27875_27975 = state_27870__$1;
(statearr_27875_27975[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (5))){
var inst_27860 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_27861 = (fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$2("Transactor session closing for db:",inst_27860) : fluree.db.util.log.info.call(null,"Transactor session closing for db:",inst_27860));
var state_27870__$1 = state_27870;
var statearr_27876_27976 = state_27870__$1;
(statearr_27876_27976[(2)] = inst_27861);

(statearr_27876_27976[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (6))){
var inst_27857 = (state_27870[(7)]);
var inst_27863 = (transact_handler_27971.cljs$core$IFn$_invoke$arity$2 ? transact_handler_27971.cljs$core$IFn$_invoke$arity$2(conn,inst_27857) : transact_handler_27971.call(null,conn,inst_27857));
var state_27870__$1 = (function (){var statearr_27877 = state_27870;
(statearr_27877[(8)] = inst_27863);

return statearr_27877;
})();
var statearr_27878_27977 = state_27870__$1;
(statearr_27878_27977[(2)] = null);

(statearr_27878_27977[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (7))){
var inst_27866 = (state_27870[(2)]);
var state_27870__$1 = state_27870;
var statearr_27879_27978 = state_27870__$1;
(statearr_27879_27978[(2)] = inst_27866);

(statearr_27879_27978[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2727__auto__ = null;
var fluree$db$session$state_machine__2727__auto____0 = (function (){
var statearr_27880 = [null,null,null,null,null,null,null,null,null];
(statearr_27880[(0)] = fluree$db$session$state_machine__2727__auto__);

(statearr_27880[(1)] = (1));

return statearr_27880;
});
var fluree$db$session$state_machine__2727__auto____1 = (function (state_27870){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27870);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27881){var ex__2730__auto__ = e27881;
var statearr_27882_27979 = state_27870;
(statearr_27882_27979[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27870[(4)]))){
var statearr_27883_27980 = state_27870;
(statearr_27883_27980[(1)] = cljs.core.first((state_27870[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27981 = state_27870;
state_27870 = G__27981;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$state_machine__2727__auto__ = function(state_27870){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2727__auto____1.call(this,state_27870);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2727__auto____0;
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2727__auto____1;
return fluree$db$session$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27884 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27884[(6)] = c__2749__auto___27972);

return statearr_27884;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__27984 = arguments.length;
switch (G__27984) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__27985 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__27982_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__27982_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__27985);
} else {
return G__27985;
}
})();
var seq__27986 = cljs.core.seq(sessions);
var chunk__27987 = null;
var count__27988 = (0);
var i__27989 = (0);
while(true){
if((i__27989 < count__27988)){
var session = chunk__27987.cljs$core$IIndexed$_nth$arity$2(null,i__27989);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__27991 = seq__27986;
var G__27992 = chunk__27987;
var G__27993 = count__27988;
var G__27994 = (i__27989 + (1));
seq__27986 = G__27991;
chunk__27987 = G__27992;
count__27988 = G__27993;
i__27989 = G__27994;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__27986);
if(temp__5804__auto__){
var seq__27986__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__27986__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__27986__$1);
var G__27995 = cljs.core.chunk_rest(seq__27986__$1);
var G__27996 = c__5568__auto__;
var G__27997 = cljs.core.count(c__5568__auto__);
var G__27998 = (0);
seq__27986 = G__27995;
chunk__27987 = G__27996;
count__27988 = G__27997;
i__27989 = G__27998;
continue;
} else {
var session = cljs.core.first(seq__27986__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__27999 = cljs.core.next(seq__27986__$1);
var G__28000 = null;
var G__28001 = (0);
var G__28002 = (0);
seq__27986 = G__27999;
chunk__27987 = G__28000;
count__27988 = G__28001;
i__27989 = G__28002;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
