// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');

/**
 * @interface
 */
fluree.db.storage.core.Store = function(){};

var fluree$db$storage$core$Store$exists_QMARK_$dyn_17231 = (function (s,k){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.exists_QMARK_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__5394__auto__.call(null,s,k));
} else {
var m__5392__auto__ = (fluree.db.storage.core.exists_QMARK_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__5392__auto__.call(null,s,k));
} else {
throw cljs.core.missing_protocol("Store.exists?",s);
}
}
});
/**
 * Returns true when `k` exists in `s`
 */
fluree.db.storage.core.exists_QMARK_ = (function fluree$db$storage$core$exists_QMARK_(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$exists_QMARK_$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$exists_QMARK_$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$exists_QMARK_$dyn_17231(s,k);
}
});

var fluree$db$storage$core$Store$list$dyn_17232 = (function (s,d){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.list[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(s,d) : m__5394__auto__.call(null,s,d));
} else {
var m__5392__auto__ = (fluree.db.storage.core.list["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(s,d) : m__5392__auto__.call(null,s,d));
} else {
throw cljs.core.missing_protocol("Store.list",s);
}
}
});
/**
 * Returns a collection containing the keys stored under the subdirectory/prefix `d` of `s`
 */
fluree.db.storage.core.list = (function fluree$db$storage$core$list(s,d){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$list$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$list$arity$2(s,d);
} else {
return fluree$db$storage$core$Store$list$dyn_17232(s,d);
}
});

var fluree$db$storage$core$Store$read$dyn_17233 = (function (s,k){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.read[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__5394__auto__.call(null,s,k));
} else {
var m__5392__auto__ = (fluree.db.storage.core.read["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__5392__auto__.call(null,s,k));
} else {
throw cljs.core.missing_protocol("Store.read",s);
}
}
});
/**
 * Reads raw bytes from `s` associated with `k`
 */
fluree.db.storage.core.read = (function fluree$db$storage$core$read(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$read$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$read$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$read$dyn_17233(s,k);
}
});

var fluree$db$storage$core$Store$write$dyn_17234 = (function (s,k,data){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.write[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(s,k,data) : m__5394__auto__.call(null,s,k,data));
} else {
var m__5392__auto__ = (fluree.db.storage.core.write["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(s,k,data) : m__5392__auto__.call(null,s,k,data));
} else {
throw cljs.core.missing_protocol("Store.write",s);
}
}
});
/**
 * Writes `data` as raw bytes to `s` and associates it with `k`
 */
fluree.db.storage.core.write = (function fluree$db$storage$core$write(s,k,data){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$write$arity$3 == null)))))){
return s.fluree$db$storage$core$Store$write$arity$3(s,k,data);
} else {
return fluree$db$storage$core$Store$write$dyn_17234(s,k,data);
}
});

var fluree$db$storage$core$Store$rename$dyn_17235 = (function (s,old_key,new_key){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.rename[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(s,old_key,new_key) : m__5394__auto__.call(null,s,old_key,new_key));
} else {
var m__5392__auto__ = (fluree.db.storage.core.rename["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(s,old_key,new_key) : m__5392__auto__.call(null,s,old_key,new_key));
} else {
throw cljs.core.missing_protocol("Store.rename",s);
}
}
});
/**
 * Remove `old-key` and associate its data to `new-key`
 */
fluree.db.storage.core.rename = (function fluree$db$storage$core$rename(s,old_key,new_key){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$rename$arity$3 == null)))))){
return s.fluree$db$storage$core$Store$rename$arity$3(s,old_key,new_key);
} else {
return fluree$db$storage$core$Store$rename$dyn_17235(s,old_key,new_key);
}
});

var fluree$db$storage$core$Store$delete$dyn_17236 = (function (s,k){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.delete$[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__5394__auto__.call(null,s,k));
} else {
var m__5392__auto__ = (fluree.db.storage.core.delete$["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__5392__auto__.call(null,s,k));
} else {
throw cljs.core.missing_protocol("Store.delete",s);
}
}
});
/**
 * Delete data associated with key `k`
 */
fluree.db.storage.core.delete$ = (function fluree$db$storage$core$delete(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$delete$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$delete$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$delete$dyn_17236(s,k);
}
});

/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_prefix = (function fluree$db$storage$core$ledger_garbage_prefix(network,ldgr_id){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("_",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ldgr_id,"garbage"], null));
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ldgr_id,block){
var pre = fluree.db.storage.core.ledger_garbage_prefix(network,ldgr_id);
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("_",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pre,block], null));
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17258){
var state_val_17259 = (state_17258[(1)]);
if((state_val_17259 === (7))){
var inst_17247 = (state_17258[(7)]);
var inst_17249 = fluree.db.storage.core.serde(conn);
var inst_17250 = fluree.db.serde.protocol._deserialize_block(inst_17249,inst_17247);
var state_17258__$1 = state_17258;
var statearr_17260_17279 = state_17258__$1;
(statearr_17260_17279[(2)] = inst_17250);

(statearr_17260_17279[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17259 === (1))){
var state_17258__$1 = state_17258;
var statearr_17261_17280 = state_17258__$1;
(statearr_17261_17280[(2)] = null);

(statearr_17261_17280[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17259 === (4))){
var inst_17237 = (state_17258[(2)]);
var state_17258__$1 = state_17258;
var statearr_17262_17281 = state_17258__$1;
(statearr_17262_17281[(2)] = inst_17237);

(statearr_17262_17281[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17259 === (6))){
var inst_17247 = (state_17258[(7)]);
var inst_17246 = (state_17258[(2)]);
var inst_17247__$1 = fluree.db.util.async.throw_err(inst_17246);
var state_17258__$1 = (function (){var statearr_17263 = state_17258;
(statearr_17263[(7)] = inst_17247__$1);

return statearr_17263;
})();
if(cljs.core.truth_(inst_17247__$1)){
var statearr_17264_17282 = state_17258__$1;
(statearr_17264_17282[(1)] = (7));

} else {
var statearr_17265_17283 = state_17258__$1;
(statearr_17265_17283[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17259 === (3))){
var inst_17256 = (state_17258[(2)]);
var state_17258__$1 = state_17258;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17258__$1,inst_17256);
} else {
if((state_val_17259 === (2))){
var _ = (function (){var statearr_17267 = state_17258;
(statearr_17267[(4)] = cljs.core.cons((5),(state_17258[(4)])));

return statearr_17267;
})();
var inst_17243 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_17244 = fluree.db.storage.core.read(conn,inst_17243);
var state_17258__$1 = state_17258;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17258__$1,(6),inst_17244);
} else {
if((state_val_17259 === (9))){
var inst_17253 = (state_17258[(2)]);
var _ = (function (){var statearr_17268 = state_17258;
(statearr_17268[(4)] = cljs.core.rest((state_17258[(4)])));

return statearr_17268;
})();
var state_17258__$1 = state_17258;
var statearr_17269_17284 = state_17258__$1;
(statearr_17269_17284[(2)] = inst_17253);

(statearr_17269_17284[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17259 === (5))){
var _ = (function (){var statearr_17270 = state_17258;
(statearr_17270[(4)] = cljs.core.rest((state_17258[(4)])));

return statearr_17270;
})();
var state_17258__$1 = state_17258;
var ex17266 = (state_17258__$1[(2)]);
var statearr_17271_17285 = state_17258__$1;
(statearr_17271_17285[(5)] = ex17266);


if((ex17266 instanceof Error)){
var statearr_17272_17286 = state_17258__$1;
(statearr_17272_17286[(1)] = (4));

(statearr_17272_17286[(5)] = null);

} else {
throw ex17266;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17259 === (8))){
var state_17258__$1 = state_17258;
var statearr_17273_17287 = state_17258__$1;
(statearr_17273_17287[(2)] = null);

(statearr_17273_17287[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__2727__auto____0 = (function (){
var statearr_17274 = [null,null,null,null,null,null,null,null];
(statearr_17274[(0)] = fluree$db$storage$core$read_block_$_state_machine__2727__auto__);

(statearr_17274[(1)] = (1));

return statearr_17274;
});
var fluree$db$storage$core$read_block_$_state_machine__2727__auto____1 = (function (state_17258){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17258);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17275){var ex__2730__auto__ = e17275;
var statearr_17276_17288 = state_17258;
(statearr_17276_17288[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17258[(4)]))){
var statearr_17277_17289 = state_17258;
(statearr_17277_17289[(1)] = cljs.core.first((state_17258[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17290 = state_17258;
state_17258 = G__17290;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__2727__auto__ = function(state_17258){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__2727__auto____1.call(this,state_17258);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17278 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17278[(6)] = c__2749__auto__);

return statearr_17278;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17313){
var state_val_17314 = (state_17313[(1)]);
if((state_val_17314 === (7))){
var inst_17302 = (state_17313[(7)]);
var inst_17304 = fluree.db.storage.core.serde(conn);
var inst_17305 = fluree.db.serde.protocol._deserialize_block(inst_17304,inst_17302);
var state_17313__$1 = state_17313;
var statearr_17315_17334 = state_17313__$1;
(statearr_17315_17334[(2)] = inst_17305);

(statearr_17315_17334[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17314 === (1))){
var state_17313__$1 = state_17313;
var statearr_17316_17335 = state_17313__$1;
(statearr_17316_17335[(2)] = null);

(statearr_17316_17335[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17314 === (4))){
var inst_17291 = (state_17313[(2)]);
var state_17313__$1 = state_17313;
var statearr_17317_17336 = state_17313__$1;
(statearr_17317_17336[(2)] = inst_17291);

(statearr_17317_17336[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17314 === (6))){
var inst_17302 = (state_17313[(7)]);
var inst_17301 = (state_17313[(2)]);
var inst_17302__$1 = fluree.db.util.async.throw_err(inst_17301);
var state_17313__$1 = (function (){var statearr_17318 = state_17313;
(statearr_17318[(7)] = inst_17302__$1);

return statearr_17318;
})();
if(cljs.core.truth_(inst_17302__$1)){
var statearr_17319_17337 = state_17313__$1;
(statearr_17319_17337[(1)] = (7));

} else {
var statearr_17320_17338 = state_17313__$1;
(statearr_17320_17338[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17314 === (3))){
var inst_17311 = (state_17313[(2)]);
var state_17313__$1 = state_17313;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17313__$1,inst_17311);
} else {
if((state_val_17314 === (2))){
var _ = (function (){var statearr_17322 = state_17313;
(statearr_17322[(4)] = cljs.core.cons((5),(state_17313[(4)])));

return statearr_17322;
})();
var inst_17297 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_17298 = [inst_17297,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_17299 = fluree.db.storage.core.read(conn,inst_17298);
var state_17313__$1 = state_17313;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17313__$1,(6),inst_17299);
} else {
if((state_val_17314 === (9))){
var inst_17308 = (state_17313[(2)]);
var _ = (function (){var statearr_17323 = state_17313;
(statearr_17323[(4)] = cljs.core.rest((state_17313[(4)])));

return statearr_17323;
})();
var state_17313__$1 = state_17313;
var statearr_17324_17339 = state_17313__$1;
(statearr_17324_17339[(2)] = inst_17308);

(statearr_17324_17339[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17314 === (5))){
var _ = (function (){var statearr_17325 = state_17313;
(statearr_17325[(4)] = cljs.core.rest((state_17313[(4)])));

return statearr_17325;
})();
var state_17313__$1 = state_17313;
var ex17321 = (state_17313__$1[(2)]);
var statearr_17326_17340 = state_17313__$1;
(statearr_17326_17340[(5)] = ex17321);


if((ex17321 instanceof Error)){
var statearr_17327_17341 = state_17313__$1;
(statearr_17327_17341[(1)] = (4));

(statearr_17327_17341[(5)] = null);

} else {
throw ex17321;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17314 === (8))){
var state_17313__$1 = state_17313;
var statearr_17328_17342 = state_17313__$1;
(statearr_17328_17342[(2)] = null);

(statearr_17328_17342[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____0 = (function (){
var statearr_17329 = [null,null,null,null,null,null,null,null];
(statearr_17329[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__);

(statearr_17329[(1)] = (1));

return statearr_17329;
});
var fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____1 = (function (state_17313){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17313);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17330){var ex__2730__auto__ = e17330;
var statearr_17331_17343 = state_17313;
(statearr_17331_17343[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17313[(4)]))){
var statearr_17332_17344 = state_17313;
(statearr_17332_17344[(1)] = cljs.core.first((state_17313[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17345 = state_17313;
state_17313 = G__17345;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__ = function(state_17313){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____1.call(this,state_17313);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17333 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17333[(6)] = c__2749__auto__);

return statearr_17333;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash   hash
 * :sigs   sigs
 * :txns   {tid (tx-id, string) {:cmd command (JSON string)
 *                               :sig signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,ledger_id,block_data,version){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17369){
var state_val_17370 = (state_17369[(1)]);
if((state_val_17370 === (1))){
var state_17369__$1 = state_17369;
var statearr_17371_17385 = state_17369__$1;
(statearr_17371_17385[(2)] = null);

(statearr_17371_17385[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17370 === (2))){
var _ = (function (){var statearr_17372 = state_17369;
(statearr_17372[(4)] = cljs.core.cons((5),(state_17369[(4)])));

return statearr_17372;
})();
var inst_17352 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17353 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17354 = (new cljs.core.PersistentVector(null,3,(5),inst_17352,inst_17353,null));
var inst_17355 = cljs.core.select_keys(block_data,inst_17354);
var inst_17356 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_17355);
var inst_17357 = fluree.db.storage.core.ledger_block_key(network,ledger_id,inst_17356);
var inst_17358 = [inst_17357,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_17359 = fluree.db.storage.core.serde(conn);
var inst_17360 = fluree.db.serde.protocol._serialize_block(inst_17359,inst_17355);
var inst_17361 = fluree.db.storage.core.write(conn,inst_17358,inst_17360);
var state_17369__$1 = state_17369;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17369__$1,(6),inst_17361);
} else {
if((state_val_17370 === (3))){
var inst_17367 = (state_17369[(2)]);
var state_17369__$1 = state_17369;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17369__$1,inst_17367);
} else {
if((state_val_17370 === (4))){
var inst_17346 = (state_17369[(2)]);
var state_17369__$1 = state_17369;
var statearr_17374_17386 = state_17369__$1;
(statearr_17374_17386[(2)] = inst_17346);

(statearr_17374_17386[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17370 === (5))){
var _ = (function (){var statearr_17375 = state_17369;
(statearr_17375[(4)] = cljs.core.rest((state_17369[(4)])));

return statearr_17375;
})();
var state_17369__$1 = state_17369;
var ex17373 = (state_17369__$1[(2)]);
var statearr_17376_17387 = state_17369__$1;
(statearr_17376_17387[(5)] = ex17373);


if((ex17373 instanceof Error)){
var statearr_17377_17388 = state_17369__$1;
(statearr_17377_17388[(1)] = (4));

(statearr_17377_17388[(5)] = null);

} else {
throw ex17373;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17370 === (6))){
var inst_17363 = (state_17369[(2)]);
var inst_17364 = fluree.db.util.async.throw_err(inst_17363);
var _ = (function (){var statearr_17378 = state_17369;
(statearr_17378[(4)] = cljs.core.rest((state_17369[(4)])));

return statearr_17378;
})();
var state_17369__$1 = state_17369;
var statearr_17379_17389 = state_17369__$1;
(statearr_17379_17389[(2)] = inst_17364);

(statearr_17379_17389[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____0 = (function (){
var statearr_17380 = [null,null,null,null,null,null,null];
(statearr_17380[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__);

(statearr_17380[(1)] = (1));

return statearr_17380;
});
var fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____1 = (function (state_17369){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17369);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17381){var ex__2730__auto__ = e17381;
var statearr_17382_17390 = state_17369;
(statearr_17382_17390[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17369[(4)]))){
var statearr_17383_17391 = state_17369;
(statearr_17383_17391[(1)] = cljs.core.first((state_17369[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17392 = state_17369;
state_17369 = G__17392;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__ = function(state_17369){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____1.call(this,state_17369);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17384 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17384[(6)] = c__2749__auto__);

return statearr_17384;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash   hash
 * :sigs   sigs
 * :txns   {tid (tx-id, string) {:cmd command (JSON string)
 *                               :sig signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,ledger_id,block_data){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17415){
var state_val_17416 = (state_17415[(1)]);
if((state_val_17416 === (1))){
var state_17415__$1 = state_17415;
var statearr_17417_17431 = state_17415__$1;
(statearr_17417_17431[(2)] = null);

(statearr_17417_17431[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17416 === (2))){
var _ = (function (){var statearr_17418 = state_17415;
(statearr_17418[(4)] = cljs.core.cons((5),(state_17415[(4)])));

return statearr_17418;
})();
var inst_17399 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17400 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17401 = (new cljs.core.PersistentVector(null,3,(5),inst_17399,inst_17400,null));
var inst_17402 = cljs.core.select_keys(block_data,inst_17401);
var inst_17403 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_17402);
var inst_17404 = fluree.db.storage.core.ledger_block_key(network,ledger_id,inst_17403);
var inst_17405 = fluree.db.storage.core.serde(conn);
var inst_17406 = fluree.db.serde.protocol._serialize_block(inst_17405,inst_17402);
var inst_17407 = fluree.db.storage.core.write(conn,inst_17404,inst_17406);
var state_17415__$1 = state_17415;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17415__$1,(6),inst_17407);
} else {
if((state_val_17416 === (3))){
var inst_17413 = (state_17415[(2)]);
var state_17415__$1 = state_17415;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17415__$1,inst_17413);
} else {
if((state_val_17416 === (4))){
var inst_17393 = (state_17415[(2)]);
var state_17415__$1 = state_17415;
var statearr_17420_17432 = state_17415__$1;
(statearr_17420_17432[(2)] = inst_17393);

(statearr_17420_17432[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17416 === (5))){
var _ = (function (){var statearr_17421 = state_17415;
(statearr_17421[(4)] = cljs.core.rest((state_17415[(4)])));

return statearr_17421;
})();
var state_17415__$1 = state_17415;
var ex17419 = (state_17415__$1[(2)]);
var statearr_17422_17433 = state_17415__$1;
(statearr_17422_17433[(5)] = ex17419);


if((ex17419 instanceof Error)){
var statearr_17423_17434 = state_17415__$1;
(statearr_17423_17434[(1)] = (4));

(statearr_17423_17434[(5)] = null);

} else {
throw ex17419;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17416 === (6))){
var inst_17409 = (state_17415[(2)]);
var inst_17410 = fluree.db.util.async.throw_err(inst_17409);
var _ = (function (){var statearr_17424 = state_17415;
(statearr_17424[(4)] = cljs.core.rest((state_17415[(4)])));

return statearr_17424;
})();
var state_17415__$1 = state_17415;
var statearr_17425_17435 = state_17415__$1;
(statearr_17425_17435[(2)] = inst_17410);

(statearr_17425_17435[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__2727__auto____0 = (function (){
var statearr_17426 = [null,null,null,null,null,null,null];
(statearr_17426[(0)] = fluree$db$storage$core$write_block_$_state_machine__2727__auto__);

(statearr_17426[(1)] = (1));

return statearr_17426;
});
var fluree$db$storage$core$write_block_$_state_machine__2727__auto____1 = (function (state_17415){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17415);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17427){var ex__2730__auto__ = e17427;
var statearr_17428_17436 = state_17415;
(statearr_17428_17436[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17415[(4)]))){
var statearr_17429_17437 = state_17415;
(statearr_17429_17437[(1)] = cljs.core.first((state_17415[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17438 = state_17415;
state_17415 = G__17438;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__2727__auto__ = function(state_17415){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__2727__auto____1.call(this,state_17415);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_block_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17430 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17430[(6)] = c__2749__auto__);

return statearr_17430;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into
 *   storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.random_leaf_id = (function fluree$db$storage$core$random_leaf_id(network,ledger_id,idx){
return fluree.db.storage.core.ledger_node_key(network,ledger_id,idx,cljs.core.random_uuid(),"l");
});
/**
 * Writes `leaf` to storage under the provided `leaf-id`, computing a new id if
 *   one isn't provided. Returns the leaf map with the id used attached uner the
 *   `:id` key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(var_args){
var G__17440 = arguments.length;
switch (G__17440) {
case 5:
return fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,ledger_id,idx_type,leaf){
var leaf_id = fluree.db.storage.core.random_leaf_id(network,ledger_id,idx_type);
return fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$6(conn,network,ledger_id,idx_type,leaf_id,leaf);
}));

(fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$6 = (function (conn,network,ledger_id,idx_type,leaf_id,p__17441){
var map__17442 = p__17441;
var map__17442__$1 = cljs.core.__destructure_map(map__17442);
var leaf = map__17442__$1;
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17442__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17463){
var state_val_17464 = (state_17463[(1)]);
if((state_val_17464 === (1))){
var state_17463__$1 = state_17463;
var statearr_17465_17481 = state_17463__$1;
(statearr_17465_17481[(2)] = null);

(statearr_17465_17481[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17464 === (2))){
var _ = (function (){var statearr_17466 = state_17463;
(statearr_17466[(4)] = cljs.core.cons((5),(state_17463[(4)])));

return statearr_17466;
})();
var inst_17449 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17450 = [flakes];
var inst_17451 = cljs.core.PersistentHashMap.fromArrays(inst_17449,inst_17450);
var inst_17452 = fluree.db.storage.core.serde(conn);
var inst_17453 = fluree.db.serde.protocol._serialize_leaf(inst_17452,inst_17451);
var inst_17454 = fluree.db.storage.core.write(conn,leaf_id,inst_17453);
var state_17463__$1 = state_17463;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17463__$1,(6),inst_17454);
} else {
if((state_val_17464 === (3))){
var inst_17461 = (state_17463[(2)]);
var state_17463__$1 = state_17463;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17463__$1,inst_17461);
} else {
if((state_val_17464 === (4))){
var inst_17443 = (state_17463[(2)]);
var state_17463__$1 = state_17463;
var statearr_17468_17482 = state_17463__$1;
(statearr_17468_17482[(2)] = inst_17443);

(statearr_17468_17482[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17464 === (5))){
var _ = (function (){var statearr_17469 = state_17463;
(statearr_17469[(4)] = cljs.core.rest((state_17463[(4)])));

return statearr_17469;
})();
var state_17463__$1 = state_17463;
var ex17467 = (state_17463__$1[(2)]);
var statearr_17470_17483 = state_17463__$1;
(statearr_17470_17483[(5)] = ex17467);


if((ex17467 instanceof Error)){
var statearr_17471_17484 = state_17463__$1;
(statearr_17471_17484[(1)] = (4));

(statearr_17471_17484[(5)] = null);

} else {
throw ex17467;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17464 === (6))){
var inst_17456 = (state_17463[(2)]);
var inst_17457 = fluree.db.util.async.throw_err(inst_17456);
var inst_17458 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(leaf,new cljs.core.Keyword(null,"id","id",-1388402092),leaf_id);
var _ = (function (){var statearr_17472 = state_17463;
(statearr_17472[(4)] = cljs.core.rest((state_17463[(4)])));

return statearr_17472;
})();
var state_17463__$1 = (function (){var statearr_17473 = state_17463;
(statearr_17473[(7)] = inst_17457);

return statearr_17473;
})();
var statearr_17474_17485 = state_17463__$1;
(statearr_17474_17485[(2)] = inst_17458);

(statearr_17474_17485[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2727__auto__ = null;
var fluree$db$storage$core$state_machine__2727__auto____0 = (function (){
var statearr_17475 = [null,null,null,null,null,null,null,null];
(statearr_17475[(0)] = fluree$db$storage$core$state_machine__2727__auto__);

(statearr_17475[(1)] = (1));

return statearr_17475;
});
var fluree$db$storage$core$state_machine__2727__auto____1 = (function (state_17463){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17463);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17476){var ex__2730__auto__ = e17476;
var statearr_17477_17486 = state_17463;
(statearr_17477_17486[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17463[(4)]))){
var statearr_17478_17487 = state_17463;
(statearr_17478_17487[(1)] = cljs.core.first((state_17463[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17488 = state_17463;
state_17463 = G__17488;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2727__auto__ = function(state_17463){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2727__auto____1.call(this,state_17463);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2727__auto____0;
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2727__auto____1;
return fluree$db$storage$core$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17479 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17479[(6)] = c__2749__auto__);

return statearr_17479;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.storage.core.write_leaf.cljs$lang$maxFixedArity = 6);

/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17505){
var state_val_17506 = (state_17505[(1)]);
if((state_val_17506 === (1))){
var state_17505__$1 = state_17505;
var statearr_17507_17522 = state_17505__$1;
(statearr_17507_17522[(2)] = null);

(statearr_17507_17522[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17506 === (2))){
var _ = (function (){var statearr_17508 = state_17505;
(statearr_17508[(4)] = cljs.core.cons((5),(state_17505[(4)])));

return statearr_17508;
})();
var inst_17495 = fluree.db.storage.core.serde(conn);
var inst_17496 = fluree.db.serde.protocol._serialize_branch(inst_17495,data);
var inst_17497 = fluree.db.storage.core.write(conn,key,inst_17496);
var state_17505__$1 = state_17505;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17505__$1,(6),inst_17497);
} else {
if((state_val_17506 === (3))){
var inst_17503 = (state_17505[(2)]);
var state_17505__$1 = state_17505;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17505__$1,inst_17503);
} else {
if((state_val_17506 === (4))){
var inst_17489 = (state_17505[(2)]);
var state_17505__$1 = state_17505;
var statearr_17510_17523 = state_17505__$1;
(statearr_17510_17523[(2)] = inst_17489);

(statearr_17510_17523[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17506 === (5))){
var _ = (function (){var statearr_17511 = state_17505;
(statearr_17511[(4)] = cljs.core.rest((state_17505[(4)])));

return statearr_17511;
})();
var state_17505__$1 = state_17505;
var ex17509 = (state_17505__$1[(2)]);
var statearr_17512_17524 = state_17505__$1;
(statearr_17512_17524[(5)] = ex17509);


if((ex17509 instanceof Error)){
var statearr_17513_17525 = state_17505__$1;
(statearr_17513_17525[(1)] = (4));

(statearr_17513_17525[(5)] = null);

} else {
throw ex17509;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17506 === (6))){
var inst_17499 = (state_17505[(2)]);
var inst_17500 = fluree.db.util.async.throw_err(inst_17499);
var _ = (function (){var statearr_17514 = state_17505;
(statearr_17514[(4)] = cljs.core.rest((state_17505[(4)])));

return statearr_17514;
})();
var state_17505__$1 = (function (){var statearr_17515 = state_17505;
(statearr_17515[(7)] = inst_17500);

return statearr_17515;
})();
var statearr_17516_17526 = state_17505__$1;
(statearr_17516_17526[(2)] = key);

(statearr_17516_17526[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____0 = (function (){
var statearr_17517 = [null,null,null,null,null,null,null,null];
(statearr_17517[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__);

(statearr_17517[(1)] = (1));

return statearr_17517;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____1 = (function (state_17505){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17505);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17518){var ex__2730__auto__ = e17518;
var statearr_17519_17527 = state_17505;
(statearr_17519_17527[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17505[(4)]))){
var statearr_17520_17528 = state_17505;
(statearr_17520_17528[(1)] = cljs.core.first((state_17505[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17529 = state_17505;
state_17505 = G__17529;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__ = function(state_17505){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____1.call(this,state_17505);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17521 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17521[(6)] = c__2749__auto__);

return statearr_17521;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.random_branch_id = (function fluree$db$storage$core$random_branch_id(network,ledger_id,idx){
return fluree.db.storage.core.ledger_node_key(network,ledger_id,idx,cljs.core.random_uuid(),"b");
});
/**
 * Writes `branch` to storage under the provided `branch-id`, computing a new id
 *   if one isn't provided. Returns the branch map with the id used attached uner
 *   the `:id` key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(var_args){
var G__17531 = arguments.length;
switch (G__17531) {
case 5:
return fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,ledger_id,idx_type,branch){
var branch_id = fluree.db.storage.core.random_branch_id(network,ledger_id,idx_type);
return fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$6(conn,network,ledger_id,idx_type,branch_id,branch);
}));

(fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$6 = (function (conn,network,ledger_id,idx_type,branch_id,p__17532){
var map__17533 = p__17532;
var map__17533__$1 = cljs.core.__destructure_map(map__17533);
var branch = map__17533__$1;
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17533__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17559){
var state_val_17560 = (state_17559[(1)]);
if((state_val_17560 === (1))){
var state_17559__$1 = state_17559;
var statearr_17561_17578 = state_17559__$1;
(statearr_17561_17578[(2)] = null);

(statearr_17561_17578[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17560 === (2))){
var _ = (function (){var statearr_17562 = state_17559;
(statearr_17562[(4)] = cljs.core.cons((5),(state_17559[(4)])));

return statearr_17562;
})();
var inst_17540 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.val,children);
var inst_17541 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.storage.core.child_data,inst_17540);
var inst_17542 = cljs.core.first(inst_17541);
var inst_17543 = new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(inst_17542);
var inst_17544 = cljs.core.rseq(inst_17541);
var inst_17545 = cljs.core.first(inst_17544);
var inst_17546 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_17545);
var inst_17547 = [new cljs.core.Keyword(null,"children","children",-940561982)];
var inst_17548 = [inst_17541];
var inst_17549 = cljs.core.PersistentHashMap.fromArrays(inst_17547,inst_17548);
var inst_17550 = fluree.db.storage.core.write_branch_data(conn,branch_id,inst_17549);
var state_17559__$1 = (function (){var statearr_17563 = state_17559;
(statearr_17563[(7)] = inst_17543);

(statearr_17563[(8)] = inst_17546);

return statearr_17563;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17559__$1,(6),inst_17550);
} else {
if((state_val_17560 === (3))){
var inst_17557 = (state_17559[(2)]);
var state_17559__$1 = state_17559;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17559__$1,inst_17557);
} else {
if((state_val_17560 === (4))){
var inst_17534 = (state_17559[(2)]);
var state_17559__$1 = state_17559;
var statearr_17565_17579 = state_17559__$1;
(statearr_17565_17579[(2)] = inst_17534);

(statearr_17565_17579[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17560 === (5))){
var _ = (function (){var statearr_17566 = state_17559;
(statearr_17566[(4)] = cljs.core.rest((state_17559[(4)])));

return statearr_17566;
})();
var state_17559__$1 = state_17559;
var ex17564 = (state_17559__$1[(2)]);
var statearr_17567_17580 = state_17559__$1;
(statearr_17567_17580[(5)] = ex17564);


if((ex17564 instanceof Error)){
var statearr_17568_17581 = state_17559__$1;
(statearr_17568_17581[(1)] = (4));

(statearr_17568_17581[(5)] = null);

} else {
throw ex17564;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17560 === (6))){
var inst_17552 = (state_17559[(2)]);
var inst_17553 = fluree.db.util.async.throw_err(inst_17552);
var inst_17554 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(branch,new cljs.core.Keyword(null,"id","id",-1388402092),branch_id);
var _ = (function (){var statearr_17569 = state_17559;
(statearr_17569[(4)] = cljs.core.rest((state_17559[(4)])));

return statearr_17569;
})();
var state_17559__$1 = (function (){var statearr_17570 = state_17559;
(statearr_17570[(9)] = inst_17553);

return statearr_17570;
})();
var statearr_17571_17582 = state_17559__$1;
(statearr_17571_17582[(2)] = inst_17554);

(statearr_17571_17582[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2727__auto__ = null;
var fluree$db$storage$core$state_machine__2727__auto____0 = (function (){
var statearr_17572 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17572[(0)] = fluree$db$storage$core$state_machine__2727__auto__);

(statearr_17572[(1)] = (1));

return statearr_17572;
});
var fluree$db$storage$core$state_machine__2727__auto____1 = (function (state_17559){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17559);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17573){var ex__2730__auto__ = e17573;
var statearr_17574_17583 = state_17559;
(statearr_17574_17583[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17559[(4)]))){
var statearr_17575_17584 = state_17559;
(statearr_17575_17584[(1)] = cljs.core.first((state_17559[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17585 = state_17559;
state_17559 = G__17585;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2727__auto__ = function(state_17559){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2727__auto____1.call(this,state_17559);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2727__auto____0;
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2727__auto____1;
return fluree$db$storage$core$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17576 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17576[(6)] = c__2749__auto__);

return statearr_17576;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.storage.core.write_branch.cljs$lang$maxFixedArity = 6);

/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,garbage){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17613){
var state_val_17614 = (state_17613[(1)]);
if((state_val_17614 === (1))){
var state_17613__$1 = state_17613;
var statearr_17615_17631 = state_17613__$1;
(statearr_17615_17631[(2)] = null);

(statearr_17615_17631[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17614 === (2))){
var inst_17599 = (state_17613[(7)]);
var _ = (function (){var statearr_17616 = state_17613;
(statearr_17616[(4)] = cljs.core.cons((5),(state_17613[(4)])));

return statearr_17616;
})();
var inst_17593 = db;
var inst_17594 = cljs.core.__destructure_map(inst_17593);
var inst_17595 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17594,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_17596 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17594,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_17597 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17594,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_17598 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17594,new cljs.core.Keyword(null,"block","block",664686210));
var inst_17599__$1 = fluree.db.storage.core.ledger_garbage_key(inst_17596,inst_17597,inst_17598);
var inst_17600 = [new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_17601 = [inst_17597,inst_17598,garbage];
var inst_17602 = cljs.core.PersistentHashMap.fromArrays(inst_17600,inst_17601);
var inst_17603 = fluree.db.storage.core.serde(inst_17595);
var inst_17604 = fluree.db.serde.protocol._serialize_garbage(inst_17603,inst_17602);
var inst_17605 = fluree.db.storage.core.write(inst_17595,inst_17599__$1,inst_17604);
var state_17613__$1 = (function (){var statearr_17617 = state_17613;
(statearr_17617[(7)] = inst_17599__$1);

return statearr_17617;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17613__$1,(6),inst_17605);
} else {
if((state_val_17614 === (3))){
var inst_17611 = (state_17613[(2)]);
var state_17613__$1 = state_17613;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17613__$1,inst_17611);
} else {
if((state_val_17614 === (4))){
var inst_17586 = (state_17613[(2)]);
var state_17613__$1 = state_17613;
var statearr_17619_17632 = state_17613__$1;
(statearr_17619_17632[(2)] = inst_17586);

(statearr_17619_17632[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17614 === (5))){
var _ = (function (){var statearr_17620 = state_17613;
(statearr_17620[(4)] = cljs.core.rest((state_17613[(4)])));

return statearr_17620;
})();
var state_17613__$1 = state_17613;
var ex17618 = (state_17613__$1[(2)]);
var statearr_17621_17633 = state_17613__$1;
(statearr_17621_17633[(5)] = ex17618);


if((ex17618 instanceof Error)){
var statearr_17622_17634 = state_17613__$1;
(statearr_17622_17634[(1)] = (4));

(statearr_17622_17634[(5)] = null);

} else {
throw ex17618;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17614 === (6))){
var inst_17599 = (state_17613[(7)]);
var inst_17607 = (state_17613[(2)]);
var inst_17608 = fluree.db.util.async.throw_err(inst_17607);
var _ = (function (){var statearr_17623 = state_17613;
(statearr_17623[(4)] = cljs.core.rest((state_17613[(4)])));

return statearr_17623;
})();
var state_17613__$1 = (function (){var statearr_17624 = state_17613;
(statearr_17624[(8)] = inst_17608);

return statearr_17624;
})();
var statearr_17625_17635 = state_17613__$1;
(statearr_17625_17635[(2)] = inst_17599);

(statearr_17625_17635[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____0 = (function (){
var statearr_17626 = [null,null,null,null,null,null,null,null,null];
(statearr_17626[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__);

(statearr_17626[(1)] = (1));

return statearr_17626;
});
var fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____1 = (function (state_17613){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17613);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17627){var ex__2730__auto__ = e17627;
var statearr_17628_17636 = state_17613;
(statearr_17628_17636[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17613[(4)]))){
var statearr_17629_17637 = state_17613;
(statearr_17629_17637[(1)] = cljs.core.first((state_17613[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17638 = state_17613;
state_17613 = G__17638;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__ = function(state_17613){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____1.call(this,state_17613);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__2727__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17630 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17630[(6)] = c__2749__auto__);

return statearr_17630;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__17640 = arguments.length;
switch (G__17640) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17698){
var state_val_17699 = (state_17698[(1)]);
if((state_val_17699 === (7))){
var state_17698__$1 = state_17698;
var statearr_17700_17726 = state_17698__$1;
(statearr_17700_17726[(2)] = (0));

(statearr_17700_17726[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17699 === (1))){
var state_17698__$1 = state_17698;
var statearr_17701_17727 = state_17698__$1;
(statearr_17701_17727[(2)] = null);

(statearr_17701_17727[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17699 === (4))){
var inst_17641 = (state_17698[(2)]);
var state_17698__$1 = state_17698;
var statearr_17702_17728 = state_17698__$1;
(statearr_17702_17728[(2)] = inst_17641);

(statearr_17702_17728[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17699 === (6))){
var inst_17667 = (state_17698[(7)]);
var state_17698__$1 = state_17698;
var statearr_17703_17729 = state_17698__$1;
(statearr_17703_17729[(2)] = inst_17667);

(statearr_17703_17729[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17699 === (3))){
var inst_17696 = (state_17698[(2)]);
var state_17698__$1 = state_17698;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17698__$1,inst_17696);
} else {
if((state_val_17699 === (12))){
var inst_17664 = (state_17698[(8)]);
var inst_17692 = (state_17698[(2)]);
var inst_17693 = fluree.db.util.async.throw_err(inst_17692);
var _ = (function (){var statearr_17704 = state_17698;
(statearr_17704[(4)] = cljs.core.rest((state_17698[(4)])));

return statearr_17704;
})();
var state_17698__$1 = (function (){var statearr_17705 = state_17698;
(statearr_17705[(9)] = inst_17693);

return statearr_17705;
})();
var statearr_17706_17730 = state_17698__$1;
(statearr_17706_17730[(2)] = inst_17664);

(statearr_17706_17730[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17699 === (2))){
var inst_17659 = (state_17698[(10)]);
var inst_17656 = (state_17698[(11)]);
var inst_17667 = (state_17698[(7)]);
var inst_17654 = (state_17698[(12)]);
var _ = (function (){var statearr_17707 = state_17698;
(statearr_17707[(4)] = cljs.core.cons((5),(state_17698[(4)])));

return statearr_17707;
})();
var inst_17648 = db;
var inst_17649 = cljs.core.__destructure_map(inst_17648);
var inst_17650 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17649,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_17651 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17649,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_17652 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17649,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_17653 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17649,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_17654__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17649,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_17655 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17649,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_17656__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17649,new cljs.core.Keyword(null,"block","block",664686210));
var inst_17657 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17649,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_17658 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17649,new cljs.core.Keyword(null,"tspo","tspo",-440144953));
var inst_17659__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17649,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_17660 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17649,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_17661 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17649,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_17662 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17649,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_17663 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17649,new cljs.core.Keyword(null,"post","post",269697687));
var inst_17664 = fluree.db.storage.core.ledger_root_key(inst_17650,inst_17659__$1,inst_17656__$1);
var inst_17665 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_17666 = fluree.db.storage.core.child_data(inst_17657);
var inst_17667__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_17654__$1);
var state_17698__$1 = (function (){var statearr_17708 = state_17698;
(statearr_17708[(13)] = inst_17653);

(statearr_17708[(10)] = inst_17659__$1);

(statearr_17708[(14)] = inst_17661);

(statearr_17708[(15)] = inst_17658);

(statearr_17708[(16)] = inst_17651);

(statearr_17708[(11)] = inst_17656__$1);

(statearr_17708[(7)] = inst_17667__$1);

(statearr_17708[(12)] = inst_17654__$1);

(statearr_17708[(17)] = inst_17666);

(statearr_17708[(18)] = inst_17662);

(statearr_17708[(19)] = inst_17665);

(statearr_17708[(8)] = inst_17664);

(statearr_17708[(20)] = inst_17660);

(statearr_17708[(21)] = inst_17655);

(statearr_17708[(22)] = inst_17663);

(statearr_17708[(23)] = inst_17652);

return statearr_17708;
})();
if(cljs.core.truth_(inst_17667__$1)){
var statearr_17709_17731 = state_17698__$1;
(statearr_17709_17731[(1)] = (6));

} else {
var statearr_17710_17732 = state_17698__$1;
(statearr_17710_17732[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17699 === (11))){
var inst_17653 = (state_17698[(13)]);
var inst_17671 = (state_17698[(24)]);
var inst_17659 = (state_17698[(10)]);
var inst_17661 = (state_17698[(14)]);
var inst_17651 = (state_17698[(16)]);
var inst_17656 = (state_17698[(11)]);
var inst_17654 = (state_17698[(12)]);
var inst_17666 = (state_17698[(17)]);
var inst_17662 = (state_17698[(18)]);
var inst_17665 = (state_17698[(19)]);
var inst_17664 = (state_17698[(8)]);
var inst_17655 = (state_17698[(21)]);
var inst_17663 = (state_17698[(22)]);
var inst_17652 = (state_17698[(23)]);
var inst_17672 = (state_17698[(25)]);
var inst_17677 = (state_17698[(2)]);
var inst_17678 = fluree.db.storage.core.child_data(inst_17661);
var inst_17679 = fluree.db.storage.core.child_data(inst_17663);
var inst_17680 = fluree.db.util.core.current_time_millis();
var inst_17681 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17682 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_17683 = (new cljs.core.PersistentVector(null,2,(5),inst_17681,inst_17682,null));
var inst_17684 = cljs.core.select_keys(inst_17654,inst_17683);
var inst_17685 = fluree.db.storage.core.child_data(inst_17653);
var inst_17686 = [inst_17656,inst_17666,inst_17671,inst_17659,inst_17672,inst_17677,inst_17678,inst_17679,inst_17651,inst_17680,inst_17652,inst_17662,inst_17684,inst_17685];
var inst_17687 = cljs.core.PersistentHashMap.fromArrays(inst_17665,inst_17686);
var inst_17688 = fluree.db.storage.core.serde(inst_17655);
var inst_17689 = fluree.db.serde.protocol._serialize_db_root(inst_17688,inst_17687);
var inst_17690 = fluree.db.storage.core.write(inst_17655,inst_17664,inst_17689);
var state_17698__$1 = state_17698;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17698__$1,(12),inst_17690);
} else {
if((state_val_17699 === (9))){
var inst_17673 = (state_17698[(26)]);
var state_17698__$1 = state_17698;
var statearr_17712_17733 = state_17698__$1;
(statearr_17712_17733[(2)] = inst_17673);

(statearr_17712_17733[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17699 === (5))){
var _ = (function (){var statearr_17713 = state_17698;
(statearr_17713[(4)] = cljs.core.rest((state_17698[(4)])));

return statearr_17713;
})();
var state_17698__$1 = state_17698;
var ex17711 = (state_17698__$1[(2)]);
var statearr_17714_17734 = state_17698__$1;
(statearr_17714_17734[(5)] = ex17711);


if((ex17711 instanceof Error)){
var statearr_17715_17735 = state_17698__$1;
(statearr_17715_17735[(1)] = (4));

(statearr_17715_17735[(5)] = null);

} else {
throw ex17711;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17699 === (10))){
var inst_17660 = (state_17698[(20)]);
var state_17698__$1 = state_17698;
var statearr_17716_17736 = state_17698__$1;
(statearr_17716_17736[(2)] = inst_17660);

(statearr_17716_17736[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17699 === (8))){
var inst_17658 = (state_17698[(15)]);
var inst_17673 = (state_17698[(26)]);
var inst_17671 = (state_17698[(2)]);
var inst_17672 = fluree.db.storage.core.child_data(inst_17658);
var inst_17673__$1 = custom_ecount;
var state_17698__$1 = (function (){var statearr_17717 = state_17698;
(statearr_17717[(24)] = inst_17671);

(statearr_17717[(26)] = inst_17673__$1);

(statearr_17717[(25)] = inst_17672);

return statearr_17717;
})();
if(cljs.core.truth_(inst_17673__$1)){
var statearr_17718_17737 = state_17698__$1;
(statearr_17718_17737[(1)] = (9));

} else {
var statearr_17719_17738 = state_17698__$1;
(statearr_17719_17738[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2727__auto__ = null;
var fluree$db$storage$core$state_machine__2727__auto____0 = (function (){
var statearr_17720 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17720[(0)] = fluree$db$storage$core$state_machine__2727__auto__);

(statearr_17720[(1)] = (1));

return statearr_17720;
});
var fluree$db$storage$core$state_machine__2727__auto____1 = (function (state_17698){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17698);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17721){var ex__2730__auto__ = e17721;
var statearr_17722_17739 = state_17698;
(statearr_17722_17739[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17698[(4)]))){
var statearr_17723_17740 = state_17698;
(statearr_17723_17740[(1)] = cljs.core.first((state_17698[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17741 = state_17698;
state_17698 = G__17741;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2727__auto__ = function(state_17698){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2727__auto____1.call(this,state_17698);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2727__auto____0;
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2727__auto____1;
return fluree$db$storage$core$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17724 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17724[(6)] = c__2749__auto__);

return statearr_17724;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(p__17742,key){
var map__17743 = p__17742;
var map__17743__$1 = cljs.core.__destructure_map(map__17743);
var conn = map__17743__$1;
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17743__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17763){
var state_val_17764 = (state_17763[(1)]);
if((state_val_17764 === (7))){
var inst_17753 = (state_17763[(7)]);
var inst_17755 = fluree.db.serde.protocol._deserialize_branch(serializer,inst_17753);
var state_17763__$1 = state_17763;
var statearr_17765_17784 = state_17763__$1;
(statearr_17765_17784[(2)] = inst_17755);

(statearr_17765_17784[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17764 === (1))){
var state_17763__$1 = state_17763;
var statearr_17766_17785 = state_17763__$1;
(statearr_17766_17785[(2)] = null);

(statearr_17766_17785[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17764 === (4))){
var inst_17744 = (state_17763[(2)]);
var state_17763__$1 = state_17763;
var statearr_17767_17786 = state_17763__$1;
(statearr_17767_17786[(2)] = inst_17744);

(statearr_17767_17786[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17764 === (6))){
var inst_17753 = (state_17763[(7)]);
var inst_17752 = (state_17763[(2)]);
var inst_17753__$1 = fluree.db.util.async.throw_err(inst_17752);
var state_17763__$1 = (function (){var statearr_17768 = state_17763;
(statearr_17768[(7)] = inst_17753__$1);

return statearr_17768;
})();
if(cljs.core.truth_(inst_17753__$1)){
var statearr_17769_17787 = state_17763__$1;
(statearr_17769_17787[(1)] = (7));

} else {
var statearr_17770_17788 = state_17763__$1;
(statearr_17770_17788[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17764 === (3))){
var inst_17761 = (state_17763[(2)]);
var state_17763__$1 = state_17763;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17763__$1,inst_17761);
} else {
if((state_val_17764 === (2))){
var _ = (function (){var statearr_17772 = state_17763;
(statearr_17772[(4)] = cljs.core.cons((5),(state_17763[(4)])));

return statearr_17772;
})();
var inst_17750 = fluree.db.storage.core.read(conn,key);
var state_17763__$1 = state_17763;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17763__$1,(6),inst_17750);
} else {
if((state_val_17764 === (9))){
var inst_17758 = (state_17763[(2)]);
var _ = (function (){var statearr_17773 = state_17763;
(statearr_17773[(4)] = cljs.core.rest((state_17763[(4)])));

return statearr_17773;
})();
var state_17763__$1 = state_17763;
var statearr_17774_17789 = state_17763__$1;
(statearr_17774_17789[(2)] = inst_17758);

(statearr_17774_17789[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17764 === (5))){
var _ = (function (){var statearr_17775 = state_17763;
(statearr_17775[(4)] = cljs.core.rest((state_17763[(4)])));

return statearr_17775;
})();
var state_17763__$1 = state_17763;
var ex17771 = (state_17763__$1[(2)]);
var statearr_17776_17790 = state_17763__$1;
(statearr_17776_17790[(5)] = ex17771);


if((ex17771 instanceof Error)){
var statearr_17777_17791 = state_17763__$1;
(statearr_17777_17791[(1)] = (4));

(statearr_17777_17791[(5)] = null);

} else {
throw ex17771;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17764 === (8))){
var state_17763__$1 = state_17763;
var statearr_17778_17792 = state_17763__$1;
(statearr_17778_17792[(2)] = null);

(statearr_17778_17792[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__2727__auto____0 = (function (){
var statearr_17779 = [null,null,null,null,null,null,null,null];
(statearr_17779[(0)] = fluree$db$storage$core$read_branch_$_state_machine__2727__auto__);

(statearr_17779[(1)] = (1));

return statearr_17779;
});
var fluree$db$storage$core$read_branch_$_state_machine__2727__auto____1 = (function (state_17763){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17763);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17780){var ex__2730__auto__ = e17780;
var statearr_17781_17793 = state_17763;
(statearr_17781_17793[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17763[(4)]))){
var statearr_17782_17794 = state_17763;
(statearr_17782_17794[(1)] = cljs.core.first((state_17763[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17795 = state_17763;
state_17763 = G__17795;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__2727__auto__ = function(state_17763){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__2727__auto____1.call(this,state_17763);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17783 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17783[(6)] = c__2749__auto__);

return statearr_17783;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(p__17796,key){
var map__17797 = p__17796;
var map__17797__$1 = cljs.core.__destructure_map(map__17797);
var conn = map__17797__$1;
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17797__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17817){
var state_val_17818 = (state_17817[(1)]);
if((state_val_17818 === (7))){
var inst_17807 = (state_17817[(7)]);
var inst_17809 = fluree.db.serde.protocol._deserialize_leaf(serializer,inst_17807);
var state_17817__$1 = state_17817;
var statearr_17819_17838 = state_17817__$1;
(statearr_17819_17838[(2)] = inst_17809);

(statearr_17819_17838[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17818 === (1))){
var state_17817__$1 = state_17817;
var statearr_17820_17839 = state_17817__$1;
(statearr_17820_17839[(2)] = null);

(statearr_17820_17839[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17818 === (4))){
var inst_17798 = (state_17817[(2)]);
var state_17817__$1 = state_17817;
var statearr_17821_17840 = state_17817__$1;
(statearr_17821_17840[(2)] = inst_17798);

(statearr_17821_17840[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17818 === (6))){
var inst_17807 = (state_17817[(7)]);
var inst_17806 = (state_17817[(2)]);
var inst_17807__$1 = fluree.db.util.async.throw_err(inst_17806);
var state_17817__$1 = (function (){var statearr_17822 = state_17817;
(statearr_17822[(7)] = inst_17807__$1);

return statearr_17822;
})();
if(cljs.core.truth_(inst_17807__$1)){
var statearr_17823_17841 = state_17817__$1;
(statearr_17823_17841[(1)] = (7));

} else {
var statearr_17824_17842 = state_17817__$1;
(statearr_17824_17842[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17818 === (3))){
var inst_17815 = (state_17817[(2)]);
var state_17817__$1 = state_17817;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17817__$1,inst_17815);
} else {
if((state_val_17818 === (2))){
var _ = (function (){var statearr_17826 = state_17817;
(statearr_17826[(4)] = cljs.core.cons((5),(state_17817[(4)])));

return statearr_17826;
})();
var inst_17804 = fluree.db.storage.core.read(conn,key);
var state_17817__$1 = state_17817;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17817__$1,(6),inst_17804);
} else {
if((state_val_17818 === (9))){
var inst_17812 = (state_17817[(2)]);
var _ = (function (){var statearr_17827 = state_17817;
(statearr_17827[(4)] = cljs.core.rest((state_17817[(4)])));

return statearr_17827;
})();
var state_17817__$1 = state_17817;
var statearr_17828_17843 = state_17817__$1;
(statearr_17828_17843[(2)] = inst_17812);

(statearr_17828_17843[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17818 === (5))){
var _ = (function (){var statearr_17829 = state_17817;
(statearr_17829[(4)] = cljs.core.rest((state_17817[(4)])));

return statearr_17829;
})();
var state_17817__$1 = state_17817;
var ex17825 = (state_17817__$1[(2)]);
var statearr_17830_17844 = state_17817__$1;
(statearr_17830_17844[(5)] = ex17825);


if((ex17825 instanceof Error)){
var statearr_17831_17845 = state_17817__$1;
(statearr_17831_17845[(1)] = (4));

(statearr_17831_17845[(5)] = null);

} else {
throw ex17825;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17818 === (8))){
var state_17817__$1 = state_17817;
var statearr_17832_17846 = state_17817__$1;
(statearr_17832_17846[(2)] = null);

(statearr_17832_17846[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____0 = (function (){
var statearr_17833 = [null,null,null,null,null,null,null,null];
(statearr_17833[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__);

(statearr_17833[(1)] = (1));

return statearr_17833;
});
var fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____1 = (function (state_17817){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17817);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17834){var ex__2730__auto__ = e17834;
var statearr_17835_17847 = state_17817;
(statearr_17835_17847[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17817[(4)]))){
var statearr_17836_17848 = state_17817;
(statearr_17836_17848[(1)] = cljs.core.first((state_17817[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17849 = state_17817;
state_17817 = G__17849;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__ = function(state_17817){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____1.call(this,state_17817);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17837 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17837[(6)] = c__2749__auto__);

return statearr_17837;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(_conn,p__17850,index,index_data){
var map__17851 = p__17850;
var map__17851__$1 = cljs.core.__destructure_map(map__17851);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17851__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17851__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var comparators = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17851__$1,new cljs.core.Keyword(null,"comparators","comparators",-1325611955));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17851__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17851__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var cmp = (function (){var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(comparators,index);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db index root: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
var G__17852 = index_data;
var G__17852__$1 = (cljs.core.truth_(new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(index_data))?cljs.core.update.cljs$core$IFn$_invoke$arity$3(G__17852,new cljs.core.Keyword(null,"rhs","rhs",-229356739),fluree.db.flake.parts__GT_Flake):G__17852);
var G__17852__$2 = (cljs.core.truth_(new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(index_data))?cljs.core.update.cljs$core$IFn$_invoke$arity$3(G__17852__$1,new cljs.core.Keyword(null,"first","first",-644103046),fluree.db.flake.parts__GT_Flake):G__17852__$1);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(G__17852__$2,new cljs.core.Keyword(null,"comparator","comparator",2144896662),cmp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),ledger_id,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true], 0));

});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__17853 = root_data;
var map__17853__$1 = cljs.core.__destructure_map(map__17853);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17853__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17853__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17853__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17853__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (db,idx){
var idx_root = fluree.db.storage.core.reify_index_root(conn,db,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,idx_root);
}),db_STAR_,fluree.db.index.types);
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,ledger_id,block){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17875){
var state_val_17876 = (state_17875[(1)]);
if((state_val_17876 === (7))){
var state_17875__$1 = state_17875;
var statearr_17877_17897 = state_17875__$1;
(statearr_17877_17897[(2)] = null);

(statearr_17877_17897[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17876 === (1))){
var state_17875__$1 = state_17875;
var statearr_17878_17898 = state_17875__$1;
(statearr_17878_17898[(2)] = null);

(statearr_17878_17898[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17876 === (4))){
var inst_17854 = (state_17875[(2)]);
var state_17875__$1 = state_17875;
var statearr_17879_17899 = state_17875__$1;
(statearr_17879_17899[(2)] = inst_17854);

(statearr_17879_17899[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17876 === (6))){
var inst_17861 = (state_17875[(7)]);
var inst_17863 = fluree.db.storage.core.serde(conn);
var state_17875__$1 = (function (){var statearr_17880 = state_17875;
(statearr_17880[(8)] = inst_17863);

return statearr_17880;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17875__$1,(9),inst_17861);
} else {
if((state_val_17876 === (3))){
var inst_17873 = (state_17875[(2)]);
var state_17875__$1 = state_17875;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17875__$1,inst_17873);
} else {
if((state_val_17876 === (2))){
var inst_17861 = (state_17875[(7)]);
var _ = (function (){var statearr_17882 = state_17875;
(statearr_17882[(4)] = cljs.core.cons((5),(state_17875[(4)])));

return statearr_17882;
})();
var inst_17860 = fluree.db.storage.core.ledger_garbage_key(network,ledger_id,block);
var inst_17861__$1 = fluree.db.storage.core.read(conn,inst_17860);
var state_17875__$1 = (function (){var statearr_17883 = state_17875;
(statearr_17883[(7)] = inst_17861__$1);

return statearr_17883;
})();
if(cljs.core.truth_(inst_17861__$1)){
var statearr_17884_17900 = state_17875__$1;
(statearr_17884_17900[(1)] = (6));

} else {
var statearr_17885_17901 = state_17875__$1;
(statearr_17885_17901[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17876 === (9))){
var inst_17863 = (state_17875[(8)]);
var inst_17865 = (state_17875[(2)]);
var inst_17866 = fluree.db.util.async.throw_err(inst_17865);
var inst_17867 = fluree.db.serde.protocol._deserialize_garbage(inst_17863,inst_17866);
var state_17875__$1 = state_17875;
var statearr_17886_17902 = state_17875__$1;
(statearr_17886_17902[(2)] = inst_17867);

(statearr_17886_17902[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17876 === (5))){
var _ = (function (){var statearr_17887 = state_17875;
(statearr_17887[(4)] = cljs.core.rest((state_17875[(4)])));

return statearr_17887;
})();
var state_17875__$1 = state_17875;
var ex17881 = (state_17875__$1[(2)]);
var statearr_17888_17903 = state_17875__$1;
(statearr_17888_17903[(5)] = ex17881);


if((ex17881 instanceof Error)){
var statearr_17889_17904 = state_17875__$1;
(statearr_17889_17904[(1)] = (4));

(statearr_17889_17904[(5)] = null);

} else {
throw ex17881;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17876 === (8))){
var inst_17870 = (state_17875[(2)]);
var _ = (function (){var statearr_17890 = state_17875;
(statearr_17890[(4)] = cljs.core.rest((state_17875[(4)])));

return statearr_17890;
})();
var state_17875__$1 = state_17875;
var statearr_17891_17905 = state_17875__$1;
(statearr_17891_17905[(2)] = inst_17870);

(statearr_17891_17905[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____0 = (function (){
var statearr_17892 = [null,null,null,null,null,null,null,null,null];
(statearr_17892[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__);

(statearr_17892[(1)] = (1));

return statearr_17892;
});
var fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____1 = (function (state_17875){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17875);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17893){var ex__2730__auto__ = e17893;
var statearr_17894_17906 = state_17875;
(statearr_17894_17906[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17875[(4)]))){
var statearr_17895_17907 = state_17875;
(statearr_17895_17907[(1)] = cljs.core.first((state_17875[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17908 = state_17875;
state_17875 = G__17908;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__ = function(state_17875){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____1.call(this,state_17875);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17896 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17896[(6)] = c__2749__auto__);

return statearr_17896;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,ledger_id,block){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17930){
var state_val_17931 = (state_17930[(1)]);
if((state_val_17931 === (7))){
var inst_17919 = (state_17930[(7)]);
var inst_17921 = fluree.db.storage.core.serde(conn);
var inst_17922 = fluree.db.serde.protocol._deserialize_db_root(inst_17921,inst_17919);
var state_17930__$1 = state_17930;
var statearr_17932_17951 = state_17930__$1;
(statearr_17932_17951[(2)] = inst_17922);

(statearr_17932_17951[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17931 === (1))){
var state_17930__$1 = state_17930;
var statearr_17933_17952 = state_17930__$1;
(statearr_17933_17952[(2)] = null);

(statearr_17933_17952[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17931 === (4))){
var inst_17909 = (state_17930[(2)]);
var state_17930__$1 = state_17930;
var statearr_17934_17953 = state_17930__$1;
(statearr_17934_17953[(2)] = inst_17909);

(statearr_17934_17953[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17931 === (6))){
var inst_17919 = (state_17930[(7)]);
var inst_17918 = (state_17930[(2)]);
var inst_17919__$1 = fluree.db.util.async.throw_err(inst_17918);
var state_17930__$1 = (function (){var statearr_17935 = state_17930;
(statearr_17935[(7)] = inst_17919__$1);

return statearr_17935;
})();
if(cljs.core.truth_(inst_17919__$1)){
var statearr_17936_17954 = state_17930__$1;
(statearr_17936_17954[(1)] = (7));

} else {
var statearr_17937_17955 = state_17930__$1;
(statearr_17937_17955[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17931 === (3))){
var inst_17928 = (state_17930[(2)]);
var state_17930__$1 = state_17930;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17930__$1,inst_17928);
} else {
if((state_val_17931 === (2))){
var _ = (function (){var statearr_17939 = state_17930;
(statearr_17939[(4)] = cljs.core.cons((5),(state_17930[(4)])));

return statearr_17939;
})();
var inst_17915 = fluree.db.storage.core.ledger_root_key(network,ledger_id,block);
var inst_17916 = fluree.db.storage.core.read(conn,inst_17915);
var state_17930__$1 = state_17930;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17930__$1,(6),inst_17916);
} else {
if((state_val_17931 === (9))){
var inst_17925 = (state_17930[(2)]);
var _ = (function (){var statearr_17940 = state_17930;
(statearr_17940[(4)] = cljs.core.rest((state_17930[(4)])));

return statearr_17940;
})();
var state_17930__$1 = state_17930;
var statearr_17941_17956 = state_17930__$1;
(statearr_17941_17956[(2)] = inst_17925);

(statearr_17941_17956[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17931 === (5))){
var _ = (function (){var statearr_17942 = state_17930;
(statearr_17942[(4)] = cljs.core.rest((state_17930[(4)])));

return statearr_17942;
})();
var state_17930__$1 = state_17930;
var ex17938 = (state_17930__$1[(2)]);
var statearr_17943_17957 = state_17930__$1;
(statearr_17943_17957[(5)] = ex17938);


if((ex17938 instanceof Error)){
var statearr_17944_17958 = state_17930__$1;
(statearr_17944_17958[(1)] = (4));

(statearr_17944_17958[(5)] = null);

} else {
throw ex17938;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17931 === (8))){
var state_17930__$1 = state_17930;
var statearr_17945_17959 = state_17930__$1;
(statearr_17945_17959[(2)] = null);

(statearr_17945_17959[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____0 = (function (){
var statearr_17946 = [null,null,null,null,null,null,null,null];
(statearr_17946[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__);

(statearr_17946[(1)] = (1));

return statearr_17946;
});
var fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____1 = (function (state_17930){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17930);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17947){var ex__2730__auto__ = e17947;
var statearr_17948_17960 = state_17930;
(statearr_17948_17960[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17930[(4)]))){
var statearr_17949_17961 = state_17930;
(statearr_17949_17961[(1)] = cljs.core.first((state_17930[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17962 = state_17930;
state_17930 = G__17962;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__ = function(state_17930){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____1.call(this,state_17930);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__2727__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17950 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17950[(6)] = c__2749__auto__);

return statearr_17950;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index,
 *   throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,ledger_id,blank_db,index){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17999){
var state_val_18000 = (state_17999[(1)]);
if((state_val_18000 === (7))){
var inst_17969 = (state_17999[(7)]);
var state_17999__$1 = state_17999;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17999__$1,(9),inst_17969);
} else {
if((state_val_18000 === (1))){
var state_17999__$1 = state_17999;
var statearr_18001_18022 = state_17999__$1;
(statearr_18001_18022[(2)] = null);

(statearr_18001_18022[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18000 === (4))){
var inst_17963 = (state_17999[(2)]);
var state_17999__$1 = state_17999;
var statearr_18002_18023 = state_17999__$1;
(statearr_18002_18023[(2)] = inst_17963);

(statearr_18002_18023[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18000 === (6))){
var inst_17972 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_17973 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17974 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_17975 = cljs.core.PersistentHashMap.fromArrays(inst_17973,inst_17974);
var inst_17976 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_17972,inst_17975);
var inst_17977 = (function(){throw inst_17976})();
var state_17999__$1 = state_17999;
var statearr_18003_18024 = state_17999__$1;
(statearr_18003_18024[(2)] = inst_17977);

(statearr_18003_18024[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18000 === (3))){
var inst_17997 = (state_17999[(2)]);
var state_17999__$1 = state_17999;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17999__$1,inst_17997);
} else {
if((state_val_18000 === (2))){
var inst_17969 = (state_17999[(7)]);
var _ = (function (){var statearr_18004 = state_17999;
(statearr_18004[(4)] = cljs.core.cons((5),(state_17999[(4)])));

return statearr_18004;
})();
var inst_17969__$1 = fluree.db.storage.core.read_db_root(conn,network,ledger_id,index);
var inst_17970 = cljs.core.not(inst_17969__$1);
var state_17999__$1 = (function (){var statearr_18005 = state_17999;
(statearr_18005[(7)] = inst_17969__$1);

return statearr_18005;
})();
if(inst_17970){
var statearr_18006_18025 = state_17999__$1;
(statearr_18006_18025[(1)] = (6));

} else {
var statearr_18007_18026 = state_17999__$1;
(statearr_18007_18026[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18000 === (11))){
var inst_17987 = (state_17999[(8)]);
var inst_17990 = (state_17999[(2)]);
var inst_17991 = fluree.db.util.async.throw_err(inst_17990);
var inst_17992 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_17987,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_17991);
var state_17999__$1 = state_17999;
var statearr_18009_18027 = state_17999__$1;
(statearr_18009_18027[(2)] = inst_17992);

(statearr_18009_18027[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18000 === (9))){
var inst_17982 = (state_17999[(9)]);
var inst_17980 = (state_17999[(2)]);
var inst_17981 = fluree.db.util.async.throw_err(inst_17980);
var inst_17982__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_17981);
var inst_17983 = fluree.db.query.schema.schema_map(inst_17982__$1);
var state_17999__$1 = (function (){var statearr_18010 = state_17999;
(statearr_18010[(9)] = inst_17982__$1);

return statearr_18010;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17999__$1,(10),inst_17983);
} else {
if((state_val_18000 === (5))){
var _ = (function (){var statearr_18011 = state_17999;
(statearr_18011[(4)] = cljs.core.rest((state_17999[(4)])));

return statearr_18011;
})();
var state_17999__$1 = state_17999;
var ex18008 = (state_17999__$1[(2)]);
var statearr_18012_18028 = state_17999__$1;
(statearr_18012_18028[(5)] = ex18008);


if((ex18008 instanceof Error)){
var statearr_18013_18029 = state_17999__$1;
(statearr_18013_18029[(1)] = (4));

(statearr_18013_18029[(5)] = null);

} else {
throw ex18008;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18000 === (10))){
var inst_17982 = (state_17999[(9)]);
var inst_17987 = (state_17999[(8)]);
var inst_17985 = (state_17999[(2)]);
var inst_17986 = fluree.db.util.async.throw_err(inst_17985);
var inst_17987__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_17982,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_17986);
var inst_17988 = fluree.db.query.schema.setting_map(inst_17987__$1);
var state_17999__$1 = (function (){var statearr_18014 = state_17999;
(statearr_18014[(8)] = inst_17987__$1);

return statearr_18014;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17999__$1,(11),inst_17988);
} else {
if((state_val_18000 === (8))){
var inst_17994 = (state_17999[(2)]);
var _ = (function (){var statearr_18015 = state_17999;
(statearr_18015[(4)] = cljs.core.rest((state_17999[(4)])));

return statearr_18015;
})();
var state_17999__$1 = state_17999;
var statearr_18016_18030 = state_17999__$1;
(statearr_18016_18030[(2)] = inst_17994);

(statearr_18016_18030[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__2727__auto____0 = (function (){
var statearr_18017 = [null,null,null,null,null,null,null,null,null,null];
(statearr_18017[(0)] = fluree$db$storage$core$reify_db_$_state_machine__2727__auto__);

(statearr_18017[(1)] = (1));

return statearr_18017;
});
var fluree$db$storage$core$reify_db_$_state_machine__2727__auto____1 = (function (state_17999){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17999);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18018){var ex__2730__auto__ = e18018;
var statearr_18019_18031 = state_17999;
(statearr_18019_18031[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17999[(4)]))){
var statearr_18020_18032 = state_17999;
(statearr_18020_18032[(1)] = cljs.core.first((state_17999[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18033 = state_17999;
state_17999 = G__18033;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__2727__auto__ = function(state_17999){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__2727__auto____1.call(this,state_17999);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__2727__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__2727__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18021 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18021[(6)] = c__2749__auto__);

return statearr_18021;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.fetch_child_attributes = (function fluree$db$storage$core$fetch_child_attributes(conn,p__18034){
var map__18035 = p__18034;
var map__18035__$1 = cljs.core.__destructure_map(map__18035);
var branch = map__18035__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18035__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var comparator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18035__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var leftmost_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18035__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18072){
var state_val_18073 = (state_18072[(1)]);
if((state_val_18073 === (7))){
var inst_18045 = (state_18072[(7)]);
var inst_18048 = cljs.core.__destructure_map(inst_18045);
var inst_18049 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18048,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_18050 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18051 = [new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"tempid","tempid",1427663222)];
var inst_18052 = (new cljs.core.PersistentVector(null,7,(5),inst_18050,inst_18051,null));
var inst_18053 = cljs.core.select_keys(branch,inst_18052);
var inst_18054 = (function (){var temp__5802__auto__ = inst_18045;
var map__18047 = inst_18048;
var children = inst_18049;
var branch_metadata = inst_18053;
return (function (i,child){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(branch_metadata,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),(function (){var and__5043__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return (i === (0));
} else {
return and__5043__auto__;
}
})()),child], 0));
});
})();
var inst_18055 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_18054,inst_18049);
var inst_18056 = cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"first","first",-644103046),cljs.core.identity);
var inst_18057 = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(inst_18056,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_18055], 0));
var inst_18058 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_map_by,comparator,inst_18057);
var state_18072__$1 = state_18072;
var statearr_18074_18093 = state_18072__$1;
(statearr_18074_18093[(2)] = inst_18058);

(statearr_18074_18093[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (1))){
var state_18072__$1 = state_18072;
var statearr_18075_18094 = state_18072__$1;
(statearr_18075_18094[(2)] = null);

(statearr_18075_18094[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (4))){
var inst_18036 = (state_18072[(2)]);
var state_18072__$1 = state_18072;
var statearr_18076_18095 = state_18072__$1;
(statearr_18076_18095[(2)] = inst_18036);

(statearr_18076_18095[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (6))){
var inst_18045 = (state_18072[(7)]);
var inst_18044 = (state_18072[(2)]);
var inst_18045__$1 = fluree.db.util.async.throw_err(inst_18044);
var state_18072__$1 = (function (){var statearr_18077 = state_18072;
(statearr_18077[(7)] = inst_18045__$1);

return statearr_18077;
})();
if(cljs.core.truth_(inst_18045__$1)){
var statearr_18078_18096 = state_18072__$1;
(statearr_18078_18096[(1)] = (7));

} else {
var statearr_18079_18097 = state_18072__$1;
(statearr_18079_18097[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (3))){
var inst_18070 = (state_18072[(2)]);
var state_18072__$1 = state_18072;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18072__$1,inst_18070);
} else {
if((state_val_18073 === (2))){
var _ = (function (){var statearr_18081 = state_18072;
(statearr_18081[(4)] = cljs.core.cons((5),(state_18072[(4)])));

return statearr_18081;
})();
var inst_18042 = fluree.db.storage.core.read_branch(conn,id);
var state_18072__$1 = state_18072;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18072__$1,(6),inst_18042);
} else {
if((state_val_18073 === (9))){
var inst_18067 = (state_18072[(2)]);
var _ = (function (){var statearr_18082 = state_18072;
(statearr_18082[(4)] = cljs.core.rest((state_18072[(4)])));

return statearr_18082;
})();
var state_18072__$1 = state_18072;
var statearr_18083_18098 = state_18072__$1;
(statearr_18083_18098[(2)] = inst_18067);

(statearr_18083_18098[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (5))){
var _ = (function (){var statearr_18084 = state_18072;
(statearr_18084[(4)] = cljs.core.rest((state_18072[(4)])));

return statearr_18084;
})();
var state_18072__$1 = state_18072;
var ex18080 = (state_18072__$1[(2)]);
var statearr_18085_18099 = state_18072__$1;
(statearr_18085_18099[(5)] = ex18080);


if((ex18080 instanceof Error)){
var statearr_18086_18100 = state_18072__$1;
(statearr_18086_18100[(1)] = (4));

(statearr_18086_18100[(5)] = null);

} else {
throw ex18080;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18073 === (8))){
var inst_18060 = ["Unable to retrieve index branch with id ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)," from storage."].join('');
var inst_18061 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18062 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_18063 = cljs.core.PersistentHashMap.fromArrays(inst_18061,inst_18062);
var inst_18064 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18060,inst_18063);
var inst_18065 = (function(){throw inst_18064})();
var state_18072__$1 = state_18072;
var statearr_18087_18101 = state_18072__$1;
(statearr_18087_18101[(2)] = inst_18065);

(statearr_18087_18101[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto____0 = (function (){
var statearr_18088 = [null,null,null,null,null,null,null,null];
(statearr_18088[(0)] = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto__);

(statearr_18088[(1)] = (1));

return statearr_18088;
});
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto____1 = (function (state_18072){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18072);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18089){var ex__2730__auto__ = e18089;
var statearr_18090_18102 = state_18072;
(statearr_18090_18102[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18072[(4)]))){
var statearr_18091_18103 = state_18072;
(statearr_18091_18103[(1)] = cljs.core.first((state_18072[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18104 = state_18072;
state_18072 = G__18104;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto__ = function(state_18072){
switch(arguments.length){
case 0:
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto____1.call(this,state_18072);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto____0;
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto____1;
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18092 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18092[(6)] = c__2749__auto__);

return statearr_18092;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.fetch_leaf_flakes = (function fluree$db$storage$core$fetch_leaf_flakes(conn,p__18105){
var map__18106 = p__18105;
var map__18106__$1 = cljs.core.__destructure_map(map__18106);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18106__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var comparator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18106__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18135){
var state_val_18136 = (state_18135[(1)]);
if((state_val_18136 === (7))){
var inst_18116 = (state_18135[(7)]);
var inst_18119 = cljs.core.__destructure_map(inst_18116);
var inst_18120 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18119,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_18121 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,comparator,inst_18120);
var state_18135__$1 = state_18135;
var statearr_18137_18156 = state_18135__$1;
(statearr_18137_18156[(2)] = inst_18121);

(statearr_18137_18156[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18136 === (1))){
var state_18135__$1 = state_18135;
var statearr_18138_18157 = state_18135__$1;
(statearr_18138_18157[(2)] = null);

(statearr_18138_18157[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18136 === (4))){
var inst_18107 = (state_18135[(2)]);
var state_18135__$1 = state_18135;
var statearr_18139_18158 = state_18135__$1;
(statearr_18139_18158[(2)] = inst_18107);

(statearr_18139_18158[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18136 === (6))){
var inst_18116 = (state_18135[(7)]);
var inst_18115 = (state_18135[(2)]);
var inst_18116__$1 = fluree.db.util.async.throw_err(inst_18115);
var state_18135__$1 = (function (){var statearr_18140 = state_18135;
(statearr_18140[(7)] = inst_18116__$1);

return statearr_18140;
})();
if(cljs.core.truth_(inst_18116__$1)){
var statearr_18141_18159 = state_18135__$1;
(statearr_18141_18159[(1)] = (7));

} else {
var statearr_18142_18160 = state_18135__$1;
(statearr_18142_18160[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18136 === (3))){
var inst_18133 = (state_18135[(2)]);
var state_18135__$1 = state_18135;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18135__$1,inst_18133);
} else {
if((state_val_18136 === (2))){
var _ = (function (){var statearr_18144 = state_18135;
(statearr_18144[(4)] = cljs.core.cons((5),(state_18135[(4)])));

return statearr_18144;
})();
var inst_18113 = fluree.db.storage.core.read_leaf(conn,id);
var state_18135__$1 = state_18135;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18135__$1,(6),inst_18113);
} else {
if((state_val_18136 === (9))){
var inst_18130 = (state_18135[(2)]);
var _ = (function (){var statearr_18145 = state_18135;
(statearr_18145[(4)] = cljs.core.rest((state_18135[(4)])));

return statearr_18145;
})();
var state_18135__$1 = state_18135;
var statearr_18146_18161 = state_18135__$1;
(statearr_18146_18161[(2)] = inst_18130);

(statearr_18146_18161[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18136 === (5))){
var _ = (function (){var statearr_18147 = state_18135;
(statearr_18147[(4)] = cljs.core.rest((state_18135[(4)])));

return statearr_18147;
})();
var state_18135__$1 = state_18135;
var ex18143 = (state_18135__$1[(2)]);
var statearr_18148_18162 = state_18135__$1;
(statearr_18148_18162[(5)] = ex18143);


if((ex18143 instanceof Error)){
var statearr_18149_18163 = state_18135__$1;
(statearr_18149_18163[(1)] = (4));

(statearr_18149_18163[(5)] = null);

} else {
throw ex18143;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18136 === (8))){
var inst_18123 = ["Unable to retrieve leaf node with id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)," from storage"].join('');
var inst_18124 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18125 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_18126 = cljs.core.PersistentHashMap.fromArrays(inst_18124,inst_18125);
var inst_18127 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18123,inst_18126);
var inst_18128 = (function(){throw inst_18127})();
var state_18135__$1 = state_18135;
var statearr_18150_18164 = state_18135__$1;
(statearr_18150_18164[(2)] = inst_18128);

(statearr_18150_18164[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto__ = null;
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto____0 = (function (){
var statearr_18151 = [null,null,null,null,null,null,null,null];
(statearr_18151[(0)] = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto__);

(statearr_18151[(1)] = (1));

return statearr_18151;
});
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto____1 = (function (state_18135){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18135);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18152){var ex__2730__auto__ = e18152;
var statearr_18153_18165 = state_18135;
(statearr_18153_18165[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18135[(4)]))){
var statearr_18154_18166 = state_18135;
(statearr_18154_18166[(1)] = cljs.core.first((state_18135[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18167 = state_18135;
state_18135 = G__18167;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto__ = function(state_18135){
switch(arguments.length){
case 0:
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto____1.call(this,state_18135);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto____0;
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto____1;
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18155 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18155[(6)] = c__2749__auto__);

return statearr_18155;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.storage.core.resolve_index_node = (function fluree$db$storage$core$resolve_index_node(var_args){
var G__18169 = arguments.length;
switch (G__18169) {
case 2:
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$2 = (function (conn,node){
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$2(node,null);
}));

(fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$3 = (function (conn,p__18170,error_fn){
var map__18171 = p__18170;
var map__18171__$1 = cljs.core.__destructure_map(map__18171);
var node = map__18171__$1;
var comparator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18171__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18171__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
if(cljs.core.truth_(comparator)){
} else {
throw (new Error(["Assert failed: ","Cannot resolve index node; configuration does not have a comparator.","\n","comparator"].join('')));
}

var return_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___18243 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18215){
var state_val_18216 = (state_18215[(1)]);
if((state_val_18216 === (7))){
var inst_18180 = (state_18215[(2)]);
var state_18215__$1 = state_18215;
var statearr_18217_18244 = state_18215__$1;
(statearr_18217_18244[(2)] = inst_18180);

(statearr_18217_18244[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18216 === (1))){
var state_18215__$1 = state_18215;
var statearr_18218_18245 = state_18215__$1;
(statearr_18218_18245[(2)] = null);

(statearr_18218_18245[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18216 === (4))){
var inst_18172 = (state_18215[(7)]);
var inst_18172__$1 = (state_18215[(2)]);
var inst_18173 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(inst_18172__$1,"Error resolving index node") : fluree.db.util.log.error.call(null,inst_18172__$1,"Error resolving index node"));
var state_18215__$1 = (function (){var statearr_18219 = state_18215;
(statearr_18219[(8)] = inst_18173);

(statearr_18219[(7)] = inst_18172__$1);

return statearr_18219;
})();
if(cljs.core.truth_(error_fn)){
var statearr_18220_18246 = state_18215__$1;
(statearr_18220_18246[(1)] = (5));

} else {
var statearr_18221_18247 = state_18215__$1;
(statearr_18221_18247[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18216 === (13))){
var inst_18198 = (state_18215[(9)]);
var inst_18201 = (state_18215[(2)]);
var inst_18202 = fluree.db.util.async.throw_err(inst_18201);
var inst_18203 = [new cljs.core.Keyword(null,"children","children",-940561982),inst_18202];
var inst_18204 = (new cljs.core.PersistentVector(null,2,(5),inst_18198,inst_18203,null));
var state_18215__$1 = state_18215;
var statearr_18222_18248 = state_18215__$1;
(statearr_18222_18248[(2)] = inst_18204);

(statearr_18222_18248[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18216 === (6))){
var state_18215__$1 = state_18215;
var statearr_18223_18249 = state_18215__$1;
(statearr_18223_18249[(2)] = null);

(statearr_18223_18249[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18216 === (3))){
var inst_18213 = (state_18215[(2)]);
var state_18215__$1 = state_18215;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18215__$1,inst_18213);
} else {
if((state_val_18216 === (12))){
var inst_18190 = (state_18215[(10)]);
var inst_18193 = (state_18215[(2)]);
var inst_18194 = fluree.db.util.async.throw_err(inst_18193);
var inst_18195 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_18194];
var inst_18196 = (new cljs.core.PersistentVector(null,2,(5),inst_18190,inst_18195,null));
var state_18215__$1 = state_18215;
var statearr_18224_18250 = state_18215__$1;
(statearr_18224_18250[(2)] = inst_18196);

(statearr_18224_18250[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18216 === (2))){
var _ = (function (){var statearr_18225 = state_18215;
(statearr_18225[(4)] = cljs.core.cons((8),(state_18215[(4)])));

return statearr_18225;
})();
var state_18215__$1 = state_18215;
if(cljs.core.truth_(leaf)){
var statearr_18226_18251 = state_18215__$1;
(statearr_18226_18251[(1)] = (9));

} else {
var statearr_18227_18252 = state_18215__$1;
(statearr_18227_18252[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18216 === (11))){
var inst_18206 = (state_18215[(2)]);
var inst_18207 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18206,(0),null);
var inst_18208 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18206,(1),null);
var inst_18209 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(node,inst_18207,inst_18208);
var inst_18210 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_18209);
var _ = (function (){var statearr_18228 = state_18215;
(statearr_18228[(4)] = cljs.core.rest((state_18215[(4)])));

return statearr_18228;
})();
var state_18215__$1 = state_18215;
var statearr_18229_18253 = state_18215__$1;
(statearr_18229_18253[(2)] = inst_18210);

(statearr_18229_18253[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18216 === (9))){
var inst_18190 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18191 = fluree.db.storage.core.fetch_leaf_flakes(conn,node);
var state_18215__$1 = (function (){var statearr_18230 = state_18215;
(statearr_18230[(10)] = inst_18190);

return statearr_18230;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18215__$1,(12),inst_18191);
} else {
if((state_val_18216 === (5))){
var inst_18172 = (state_18215[(7)]);
var inst_18175 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_18172);
var inst_18176 = cljs.core.async.close_BANG_(return_ch);
var inst_18177 = (error_fn.cljs$core$IFn$_invoke$arity$2 ? error_fn.cljs$core$IFn$_invoke$arity$2(inst_18175,inst_18176) : error_fn.call(null,inst_18175,inst_18176));
var state_18215__$1 = state_18215;
var statearr_18232_18254 = state_18215__$1;
(statearr_18232_18254[(2)] = inst_18177);

(statearr_18232_18254[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18216 === (10))){
var inst_18198 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18199 = fluree.db.storage.core.fetch_child_attributes(conn,node);
var state_18215__$1 = (function (){var statearr_18233 = state_18215;
(statearr_18233[(9)] = inst_18198);

return statearr_18233;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18215__$1,(13),inst_18199);
} else {
if((state_val_18216 === (8))){
var _ = (function (){var statearr_18234 = state_18215;
(statearr_18234[(4)] = cljs.core.rest((state_18215[(4)])));

return statearr_18234;
})();
var state_18215__$1 = state_18215;
var ex18231 = (state_18215__$1[(2)]);
var statearr_18235_18255 = state_18215__$1;
(statearr_18235_18255[(5)] = ex18231);


var statearr_18236_18256 = state_18215__$1;
(statearr_18236_18256[(1)] = (4));

(statearr_18236_18256[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2727__auto__ = null;
var fluree$db$storage$core$state_machine__2727__auto____0 = (function (){
var statearr_18237 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18237[(0)] = fluree$db$storage$core$state_machine__2727__auto__);

(statearr_18237[(1)] = (1));

return statearr_18237;
});
var fluree$db$storage$core$state_machine__2727__auto____1 = (function (state_18215){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18215);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18238){var ex__2730__auto__ = e18238;
var statearr_18239_18257 = state_18215;
(statearr_18239_18257[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18215[(4)]))){
var statearr_18240_18258 = state_18215;
(statearr_18240_18258[(1)] = cljs.core.first((state_18215[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18259 = state_18215;
state_18215 = G__18259;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2727__auto__ = function(state_18215){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2727__auto____1.call(this,state_18215);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2727__auto____0;
fluree$db$storage$core$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2727__auto____1;
return fluree$db$storage$core$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18241 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18241[(6)] = c__2749__auto___18243);

return statearr_18241;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return return_ch;
}));

(fluree.db.storage.core.resolve_index_node.cljs$lang$maxFixedArity = 3);

fluree.db.storage.core.resolve_empty_leaf = (function fluree$db$storage$core$resolve_empty_leaf(p__18260){
var map__18261 = p__18260;
var map__18261__$1 = cljs.core.__destructure_map(map__18261);
var node = map__18261__$1;
var comparator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18261__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var empty_set = fluree.db.flake.sorted_set_by(comparator);
var empty_node = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(node,new cljs.core.Keyword(null,"flakes","flakes",1977895739),empty_set);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ch,empty_node);

return ch;
});
