// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__5045__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_12299){
var state_val_12300 = (state_12299[(1)]);
if((state_val_12300 === (7))){
var inst_12294 = (state_12299[(2)]);
var _ = (function (){var statearr_12301 = state_12299;
(statearr_12301[(4)] = cljs.core.rest((state_12299[(4)])));

return statearr_12301;
})();
var state_12299__$1 = state_12299;
var statearr_12302_12324 = state_12299__$1;
(statearr_12302_12324[(2)] = inst_12294);

(statearr_12302_12324[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12300 === (1))){
var state_12299__$1 = state_12299;
var statearr_12303_12325 = state_12299__$1;
(statearr_12303_12325[(2)] = null);

(statearr_12303_12325[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12300 === (4))){
var inst_12256 = (state_12299[(2)]);
var state_12299__$1 = state_12299;
var statearr_12304_12326 = state_12299__$1;
(statearr_12304_12326[(2)] = inst_12256);

(statearr_12304_12326[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12300 === (6))){
var inst_12281 = (state_12299[(7)]);
var inst_12274 = (state_12299[(8)]);
var inst_12280 = cljs.core.seq(inst_12274);
var inst_12281__$1 = cljs.core.first(inst_12280);
var inst_12282 = cljs.core.next(inst_12280);
var inst_12283 = cljs.core.not(inst_12281__$1);
var state_12299__$1 = (function (){var statearr_12305 = state_12299;
(statearr_12305[(7)] = inst_12281__$1);

(statearr_12305[(9)] = inst_12282);

return statearr_12305;
})();
if(inst_12283){
var statearr_12306_12327 = state_12299__$1;
(statearr_12306_12327[(1)] = (8));

} else {
var statearr_12307_12328 = state_12299__$1;
(statearr_12307_12328[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12300 === (3))){
var inst_12297 = (state_12299[(2)]);
var state_12299__$1 = state_12299;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12299__$1,inst_12297);
} else {
if((state_val_12300 === (2))){
var _ = (function (){var statearr_12308 = state_12299;
(statearr_12308[(4)] = cljs.core.cons((5),(state_12299[(4)])));

return statearr_12308;
})();
var inst_12269 = chs;
var inst_12270 = cljs.core.seq(inst_12269);
var inst_12271 = cljs.core.first(inst_12270);
var inst_12272 = cljs.core.next(inst_12270);
var inst_12273 = coll;
var inst_12274 = inst_12269;
var inst_12275 = inst_12273;
var state_12299__$1 = (function (){var statearr_12309 = state_12299;
(statearr_12309[(8)] = inst_12274);

(statearr_12309[(10)] = inst_12271);

(statearr_12309[(11)] = inst_12272);

(statearr_12309[(12)] = inst_12275);

return statearr_12309;
})();
var statearr_12310_12329 = state_12299__$1;
(statearr_12310_12329[(2)] = null);

(statearr_12310_12329[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12300 === (11))){
var inst_12282 = (state_12299[(9)]);
var inst_12275 = (state_12299[(12)]);
var inst_12287 = (state_12299[(2)]);
var inst_12288 = fluree.db.util.async.throw_err(inst_12287);
var inst_12289 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_12275,inst_12288);
var inst_12274 = inst_12282;
var inst_12275__$1 = inst_12289;
var state_12299__$1 = (function (){var statearr_12312 = state_12299;
(statearr_12312[(8)] = inst_12274);

(statearr_12312[(12)] = inst_12275__$1);

return statearr_12312;
})();
var statearr_12313_12330 = state_12299__$1;
(statearr_12313_12330[(2)] = null);

(statearr_12313_12330[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12300 === (9))){
var inst_12281 = (state_12299[(7)]);
var state_12299__$1 = state_12299;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12299__$1,(11),inst_12281);
} else {
if((state_val_12300 === (5))){
var _ = (function (){var statearr_12314 = state_12299;
(statearr_12314[(4)] = cljs.core.rest((state_12299[(4)])));

return statearr_12314;
})();
var state_12299__$1 = state_12299;
var ex12311 = (state_12299__$1[(2)]);
var statearr_12315_12331 = state_12299__$1;
(statearr_12315_12331[(5)] = ex12311);


var statearr_12316_12332 = state_12299__$1;
(statearr_12316_12332[(1)] = (4));

(statearr_12316_12332[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12300 === (10))){
var inst_12292 = (state_12299[(2)]);
var state_12299__$1 = state_12299;
var statearr_12317_12333 = state_12299__$1;
(statearr_12317_12333[(2)] = inst_12292);

(statearr_12317_12333[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12300 === (8))){
var inst_12275 = (state_12299[(12)]);
var state_12299__$1 = state_12299;
var statearr_12318_12334 = state_12299__$1;
(statearr_12318_12334[(2)] = inst_12275);

(statearr_12318_12334[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_12319 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12319[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto__);

(statearr_12319[(1)] = (1));

return statearr_12319;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto____1 = (function (state_12299){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_12299);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e12320){var ex__2730__auto__ = e12320;
var statearr_12321_12335 = state_12299;
(statearr_12321_12335[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_12299[(4)]))){
var statearr_12322_12336 = state_12299;
(statearr_12322_12336[(1)] = cljs.core.first((state_12299[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12337 = state_12299;
state_12299 = G__12337;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto__ = function(state_12299){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto____1.call(this,state_12299);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_12323 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_12323[(6)] = c__2749__auto__);

return statearr_12323;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel instead of results if there is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_12363){
var state_val_12364 = (state_12363[(1)]);
if((state_val_12364 === (7))){
var inst_12358 = (state_12363[(2)]);
var _ = (function (){var statearr_12365 = state_12363;
(statearr_12365[(4)] = cljs.core.rest((state_12363[(4)])));

return statearr_12365;
})();
var state_12363__$1 = state_12363;
var statearr_12366_12388 = state_12363__$1;
(statearr_12366_12388[(2)] = inst_12358);

(statearr_12366_12388[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12364 === (1))){
var state_12363__$1 = state_12363;
var statearr_12367_12389 = state_12363__$1;
(statearr_12367_12389[(2)] = null);

(statearr_12367_12389[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12364 === (4))){
var inst_12338 = (state_12363[(2)]);
var state_12363__$1 = state_12363;
var statearr_12368_12390 = state_12363__$1;
(statearr_12368_12390[(2)] = inst_12338);

(statearr_12368_12390[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12364 === (6))){
var state_12363__$1 = state_12363;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12363__$1,(8),chan);
} else {
if((state_val_12364 === (3))){
var inst_12361 = (state_12363[(2)]);
var state_12363__$1 = state_12363;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12363__$1,inst_12361);
} else {
if((state_val_12364 === (2))){
var _ = (function (){var statearr_12369 = state_12363;
(statearr_12369[(4)] = cljs.core.cons((5),(state_12363[(4)])));

return statearr_12369;
})();
var inst_12344 = coll;
var inst_12345 = inst_12344;
var state_12363__$1 = (function (){var statearr_12370 = state_12363;
(statearr_12370[(7)] = inst_12345);

return statearr_12370;
})();
var statearr_12371_12391 = state_12363__$1;
(statearr_12371_12391[(2)] = null);

(statearr_12371_12391[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12364 === (11))){
var inst_12356 = (state_12363[(2)]);
var state_12363__$1 = state_12363;
var statearr_12373_12392 = state_12363__$1;
(statearr_12373_12392[(2)] = inst_12356);

(statearr_12373_12392[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12364 === (9))){
var inst_12345 = (state_12363[(7)]);
var state_12363__$1 = state_12363;
var statearr_12374_12393 = state_12363__$1;
(statearr_12374_12393[(2)] = inst_12345);

(statearr_12374_12393[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12364 === (5))){
var _ = (function (){var statearr_12375 = state_12363;
(statearr_12375[(4)] = cljs.core.rest((state_12363[(4)])));

return statearr_12375;
})();
var state_12363__$1 = state_12363;
var ex12372 = (state_12363__$1[(2)]);
var statearr_12376_12394 = state_12363__$1;
(statearr_12376_12394[(5)] = ex12372);


var statearr_12377_12395 = state_12363__$1;
(statearr_12377_12395[(1)] = (4));

(statearr_12377_12395[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12364 === (10))){
var inst_12349 = (state_12363[(8)]);
var inst_12345 = (state_12363[(7)]);
var inst_12353 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_12345,inst_12349);
var inst_12345__$1 = inst_12353;
var state_12363__$1 = (function (){var statearr_12378 = state_12363;
(statearr_12378[(7)] = inst_12345__$1);

return statearr_12378;
})();
var statearr_12379_12396 = state_12363__$1;
(statearr_12379_12396[(2)] = null);

(statearr_12379_12396[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12364 === (8))){
var inst_12349 = (state_12363[(8)]);
var inst_12348 = (state_12363[(2)]);
var inst_12349__$1 = fluree.db.util.async.throw_err(inst_12348);
var inst_12350 = (inst_12349__$1 == null);
var state_12363__$1 = (function (){var statearr_12380 = state_12363;
(statearr_12380[(8)] = inst_12349__$1);

return statearr_12380;
})();
if(cljs.core.truth_(inst_12350)){
var statearr_12381_12397 = state_12363__$1;
(statearr_12381_12397[(1)] = (9));

} else {
var statearr_12382_12398 = state_12363__$1;
(statearr_12382_12398[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_12383 = [null,null,null,null,null,null,null,null,null];
(statearr_12383[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__2727__auto__);

(statearr_12383[(1)] = (1));

return statearr_12383;
});
var fluree$db$util$async$into_QMARK__$_state_machine__2727__auto____1 = (function (state_12363){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_12363);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e12384){var ex__2730__auto__ = e12384;
var statearr_12385_12399 = state_12363;
(statearr_12385_12399[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_12363[(4)]))){
var statearr_12386_12400 = state_12363;
(statearr_12386_12400[(1)] = cljs.core.first((state_12363[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12401 = state_12363;
state_12363 = G__12401;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__2727__auto__ = function(state_12363){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__2727__auto____1.call(this,state_12363);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__2727__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__2727__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_12387 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_12387[(6)] = c__2749__auto__);

return statearr_12387;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
}
});
