// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
fluree.db.util.xhttp.node$module$axios = require('axios');
fluree.db.util.xhttp.node$module$ws = require('ws');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5804__auto__ = e.response;
if(cljs.core.truth_(temp__5804__auto__)){
var resp = temp__5804__auto__;
var temp__5804__auto____$1 = resp.status;
if(cljs.core.truth_(temp__5804__auto____$1)){
var st = temp__5804__auto____$1;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
})();
var error = ((clojure.string.starts_with_QMARK_(e.message,"timeout"))?new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562):(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return ((((300) <= status)) && ((status <= (499))));
} else {
return and__5043__auto__;
}
})())?new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305):(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return (status >= (500));
} else {
return and__5043__auto__;
}
})())?new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040):(function (){
var G__19778_19781 = "XHTTP Request Error:";
var G__19779_19782 = e.request;
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__19778_19781,G__19779_19782) : fluree.db.util.log.error.call(null,G__19778_19781,G__19779_19782));

return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
})()

)));
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return (status > (0));
} else {
return and__5043__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__19780 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__19780,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__19780;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__19783 = opts;
var map__19783__$1 = cljs.core.__destructure_map(map__19783);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__19783__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19783__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19783__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__19784 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__19784__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__19784,headers], 0)):G__19784);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__19784__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__19784__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"post",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1,new cljs.core.Keyword(null,"data","data",-232669377),message], null))).then((function (resp){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0))));
})).catch((function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,err));
}));

return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json, :edn or :binary (default :text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__19785 = opts;
var map__19785__$1 = cljs.core.__destructure_map(map__19785);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__19785__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19785__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19785__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19785__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__19785__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__19786 = cljs.core.PersistentArrayMap.EMPTY;
var G__19786__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__19786,headers], 0)):G__19786);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__19786__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__19786__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"get",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1], null))).then((function (resp){
var data = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__19787 = output_format;
var G__19787__$1 = (((G__19787 instanceof cljs.core.Keyword))?G__19787.fqn:null);
switch (G__19787__$1) {
case "text":
return data;

break;
case "json":
return fluree.db.util.json.stringify(data);

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
})).catch((function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,err));
}));

return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__19789 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__19789,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__19789;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19821){
var state_val_19822 = (state_19821[(1)]);
if((state_val_19822 === (7))){
var inst_19817 = (state_19821[(2)]);
var state_19821__$1 = state_19821;
var statearr_19823_19848 = state_19821__$1;
(statearr_19823_19848[(2)] = inst_19817);

(statearr_19823_19848[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19822 === (1))){
var state_19821__$1 = state_19821;
var statearr_19824_19849 = state_19821__$1;
(statearr_19824_19849[(2)] = null);

(statearr_19824_19849[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19822 === (4))){
var inst_19792 = (state_19821[(7)]);
var inst_19792__$1 = (state_19821[(2)]);
var inst_19793 = (inst_19792__$1 == null);
var state_19821__$1 = (function (){var statearr_19825 = state_19821;
(statearr_19825[(7)] = inst_19792__$1);

return statearr_19825;
})();
if(cljs.core.truth_(inst_19793)){
var statearr_19826_19850 = state_19821__$1;
(statearr_19826_19850[(1)] = (5));

} else {
var statearr_19827_19851 = state_19821__$1;
(statearr_19827_19851[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19822 === (6))){
var inst_19792 = (state_19821[(7)]);
var inst_19800 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19792,(0),null);
var inst_19801 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19792,(1),null);
var state_19821__$1 = (function (){var statearr_19828 = state_19821;
(statearr_19828[(8)] = inst_19800);

(statearr_19828[(9)] = inst_19801);

return statearr_19828;
})();
var statearr_19829_19852 = state_19821__$1;
(statearr_19829_19852[(2)] = null);

(statearr_19829_19852[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19822 === (3))){
var inst_19819 = (state_19821[(2)]);
var state_19821__$1 = state_19821;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19821__$1,inst_19819);
} else {
if((state_val_19822 === (2))){
var state_19821__$1 = state_19821;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19821__$1,(4),pub_chan);
} else {
if((state_val_19822 === (11))){
var _ = (function (){var statearr_19831 = state_19821;
(statearr_19831[(4)] = cljs.core.rest((state_19821[(4)])));

return statearr_19831;
})();
var state_19821__$1 = state_19821;
var ex19830 = (state_19821__$1[(2)]);
var statearr_19832_19853 = state_19821__$1;
(statearr_19832_19853[(5)] = ex19830);


var statearr_19833_19854 = state_19821__$1;
(statearr_19833_19854[(1)] = (10));

(statearr_19833_19854[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19822 === (9))){
var inst_19814 = (state_19821[(2)]);
var state_19821__$1 = (function (){var statearr_19834 = state_19821;
(statearr_19834[(10)] = inst_19814);

return statearr_19834;
})();
var statearr_19835_19855 = state_19821__$1;
(statearr_19835_19855[(2)] = null);

(statearr_19835_19855[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19822 === (5))){
var inst_19795 = (fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1("Web socket pub/producer channel closed.") : fluree.db.util.log.info.call(null,"Web socket pub/producer channel closed."));
var state_19821__$1 = state_19821;
var statearr_19836_19856 = state_19821__$1;
(statearr_19836_19856[(2)] = inst_19795);

(statearr_19836_19856[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19822 === (10))){
var inst_19800 = (state_19821[(8)]);
var inst_19801 = (state_19821[(9)]);
var inst_19802 = (state_19821[(2)]);
var inst_19803 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3(inst_19802,"Error sending websocket message:",inst_19800) : fluree.db.util.log.error.call(null,inst_19802,"Error sending websocket message:",inst_19800));
var inst_19804 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_19801,false);
var state_19821__$1 = (function (){var statearr_19837 = state_19821;
(statearr_19837[(11)] = inst_19803);

return statearr_19837;
})();
var statearr_19838_19857 = state_19821__$1;
(statearr_19838_19857[(2)] = inst_19804);

(statearr_19838_19857[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19822 === (8))){
var inst_19800 = (state_19821[(8)]);
var inst_19801 = (state_19821[(9)]);
var _ = (function (){var statearr_19839 = state_19821;
(statearr_19839[(4)] = cljs.core.cons((11),(state_19821[(4)])));

return statearr_19839;
})();
var inst_19810 = ws.send(inst_19800);
var inst_19811 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_19801,true);
var ___$1 = (function (){var statearr_19840 = state_19821;
(statearr_19840[(4)] = cljs.core.rest((state_19821[(4)])));

return statearr_19840;
})();
var state_19821__$1 = (function (){var statearr_19841 = state_19821;
(statearr_19841[(12)] = inst_19810);

return statearr_19841;
})();
var statearr_19842_19858 = state_19821__$1;
(statearr_19842_19858[(2)] = inst_19811);

(statearr_19842_19858[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____0 = (function (){
var statearr_19843 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19843[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__);

(statearr_19843[(1)] = (1));

return statearr_19843;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____1 = (function (state_19821){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_19821);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e19844){var ex__2730__auto__ = e19844;
var statearr_19845_19859 = state_19821;
(statearr_19845_19859[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_19821[(4)]))){
var statearr_19846_19860 = state_19821;
(statearr_19846_19860[(1)] = cljs.core.first((state_19821[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19861 = state_19821;
state_19821 = G__19861;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__ = function(state_19821){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____1.call(this,state_19821);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_19847 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_19847[(6)] = c__2749__auto__);

return statearr_19847;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (((cljs.core._STAR_target_STAR_ === "nodejs"))?(new fluree.db.util.xhttp.node$module$ws(url)):(new WebSocket(url)));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
var G__19862_19903 = "Websocket closed: ";
var G__19863_19904 = e.reason;
var G__19864_19905 = "Code: ";
var G__19865_19906 = e.code;
(fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$4(G__19862_19903,G__19863_19904,G__19864_19905,G__19865_19906) : fluree.db.util.log.warn.call(null,G__19862_19903,G__19863_19904,G__19864_19905,G__19865_19906));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__2749__auto___19907 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19890){
var state_val_19891 = (state_19890[(1)]);
if((state_val_19891 === (1))){
var inst_19869 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19870 = [open_QMARK_,timeout_chan];
var inst_19871 = (new cljs.core.PersistentVector(null,2,(5),inst_19869,inst_19870,null));
var state_19890__$1 = state_19890;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_19890__$1,(2),inst_19871,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"priority","priority",1431093715),true], 0));
} else {
if((state_val_19891 === (2))){
var inst_19873 = (state_19890[(2)]);
var inst_19874 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19873,(0),null);
var inst_19875 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19873,(1),null);
var inst_19876 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_19875,timeout_chan);
var state_19890__$1 = (function (){var statearr_19892 = state_19890;
(statearr_19892[(7)] = inst_19874);

return statearr_19892;
})();
if(inst_19876){
var statearr_19893_19908 = state_19890__$1;
(statearr_19893_19908[(1)] = (3));

} else {
var statearr_19894_19909 = state_19890__$1;
(statearr_19894_19909[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19891 === (3))){
var inst_19878 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_19879 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19880 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_19881 = cljs.core.PersistentHashMap.fromArrays(inst_19879,inst_19880);
var inst_19882 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_19878,inst_19881);
var inst_19883 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_19882);
var inst_19884 = fluree.db.util.xhttp.close_websocket(ws);
var state_19890__$1 = (function (){var statearr_19895 = state_19890;
(statearr_19895[(8)] = inst_19883);

return statearr_19895;
})();
var statearr_19896_19910 = state_19890__$1;
(statearr_19896_19910[(2)] = inst_19884);

(statearr_19896_19910[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19891 === (4))){
var inst_19886 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_19890__$1 = state_19890;
var statearr_19897_19911 = state_19890__$1;
(statearr_19897_19911[(2)] = inst_19886);

(statearr_19897_19911[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19891 === (5))){
var inst_19888 = (state_19890[(2)]);
var state_19890__$1 = state_19890;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19890__$1,inst_19888);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____0 = (function (){
var statearr_19898 = [null,null,null,null,null,null,null,null,null];
(statearr_19898[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__);

(statearr_19898[(1)] = (1));

return statearr_19898;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____1 = (function (state_19890){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_19890);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e19899){var ex__2730__auto__ = e19899;
var statearr_19900_19912 = state_19890;
(statearr_19900_19912[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_19890[(4)]))){
var statearr_19901_19913 = state_19890;
(statearr_19901_19913[(1)] = cljs.core.first((state_19890[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19914 = state_19890;
state_19890 = G__19914;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__ = function(state_19890){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____1.call(this,state_19890);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_19902 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_19902[(6)] = c__2749__auto___19907);

return statearr_19902;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
