// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('flureeworker');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.session');
goog.require('fluree.db.connection');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.connection_js');
goog.require('goog.object');
goog.scope(function(){
flureeworker.goog$module$goog$object = goog.module.get('goog.object');
});
flureeworker.conn_register = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
flureeworker.postMessage = (function flureeworker$postMessage(message){
return self.postMessage(cljs.core.clj__GT_js(message));
});
flureeworker.conn_id__GT_db = (function flureeworker$conn_id__GT_db(conn_id,time){
var map__69964 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__69964__$1 = cljs.core.__destructure_map(map__69964);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69964__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69964__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"block","block",664686210),time], null));
});
/**
 * Parses a (nested) JavaScript object into a Clojure map
 */
flureeworker.obj__GT_clj = (function flureeworker$obj__GT_clj(obj){
if(cljs.core.truth_(goog.isObject(obj))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (result,key){
var v = flureeworker.goog$module$goog$object.get.call(null,obj,key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("function",goog.typeOf(v))){
return result;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(key),(flureeworker.obj__GT_clj.cljs$core$IFn$_invoke$arity$1 ? flureeworker.obj__GT_clj.cljs$core$IFn$_invoke$arity$1(v) : flureeworker.obj__GT_clj.call(null,v)));
}
}),cljs.core.PersistentArrayMap.EMPTY,goog.object.getKeys(obj));
} else {
return obj;
}
});
if((typeof flureeworker !== 'undefined') && (typeof flureeworker.worker_action !== 'undefined')){
} else {
flureeworker.worker_action = (function (){var method_table__5642__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__69965 = cljs.core.get_global_hierarchy;
return (fexpr__69965.cljs$core$IFn$_invoke$arity$0 ? fexpr__69965.cljs$core$IFn$_invoke$arity$0() : fexpr__69965.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("flureeworker","worker-action"),(function() { 
var G__69966__delegate = function (conn_id,event,_){
return event;
};
var G__69966 = function (conn_id,event,var_args){
var _ = null;
if (arguments.length > 2) {
var G__69967__i = 0, G__69967__a = new Array(arguments.length -  2);
while (G__69967__i < G__69967__a.length) {G__69967__a[G__69967__i] = arguments[G__69967__i + 2]; ++G__69967__i;}
  _ = new cljs.core.IndexedSeq(G__69967__a,0,null);
} 
return G__69966__delegate.call(this,conn_id,event,_);};
G__69966.cljs$lang$maxFixedArity = 2;
G__69966.cljs$lang$applyTo = (function (arglist__69968){
var conn_id = cljs.core.first(arglist__69968);
arglist__69968 = cljs.core.next(arglist__69968);
var event = cljs.core.first(arglist__69968);
var _ = cljs.core.rest(arglist__69968);
return G__69966__delegate(conn_id,event,_);
});
G__69966.cljs$core$IFn$_invoke$arity$variadic = G__69966__delegate;
return G__69966;
})()
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"setState","setState",552299271),(function (conn_id,_,id,state_update){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"setState",new cljs.core.Keyword(null,"ref","ref",1289896967),id,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(state_update)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connStatus","connStatus",63327857),(function (conn_id,_,id,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connStatus",new cljs.core.Keyword(null,"ref","ref",1289896967),id,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"login","login",55217519),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"login",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"pwGenerate",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connClosed","connClosed",1810797125),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connClosed",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),response], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connReset","connReset",-1382938159),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connReset",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),response], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"setTransact","setTransact",1791803585),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"setTransact",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connInit","connInit",-148647574),(function (_,___$1){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"conn","conn",278309663),(0),new cljs.core.Keyword(null,"event","event",301435442),"connInit"], null));
}));
/**
 * Send an error map back to the worker invoker
 */
flureeworker.error_return_map = (function flureeworker$error_return_map(error){
var default_error = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"message","message",-406056002),(function (){var or__5045__auto__ = cljs.core.ex_message(error);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unknown Error.";
}
})(),new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
var e_map = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([default_error,cljs.core.ex_data(error)], 0));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),e_map,new cljs.core.Keyword(null,"status","status",-1997798413),"error"], null);
});
/**
 * Process a query for a specific component id and return result with a :setState call.
 */
flureeworker.process_query = (function flureeworker$process_query(conn_id,id,conn_opts){
var flureeql = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995),id], null));
var jwt = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null));
var opts_SINGLEQUOTE_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([conn_opts,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(flureeql)], 0)),new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt);
if(cljs.core.truth_(flureeql)){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69986){
var state_val_69987 = (state_69986[(1)]);
if((state_val_69987 === (1))){
var inst_69969 = new cljs.core.Keyword(null,"forceTime","forceTime",827124337).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var inst_69970 = flureeworker.conn_id__GT_db(conn_id,inst_69969);
var inst_69971 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeql,new cljs.core.Keyword(null,"opts","opts",155075701),opts_SINGLEQUOTE_);
var inst_69972 = fluree.db.api.query.query(inst_69970,inst_69971);
var state_69986__$1 = state_69986;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69986__$1,(2),inst_69972);
} else {
if((state_val_69987 === (2))){
var inst_69974 = (state_69986[(7)]);
var inst_69974__$1 = (state_69986[(2)]);
var inst_69975 = fluree.db.util.core.exception_QMARK_(inst_69974__$1);
var state_69986__$1 = (function (){var statearr_69988 = state_69986;
(statearr_69988[(7)] = inst_69974__$1);

return statearr_69988;
})();
if(inst_69975){
var statearr_69989_70002 = state_69986__$1;
(statearr_69989_70002[(1)] = (3));

} else {
var statearr_69990_70003 = state_69986__$1;
(statearr_69990_70003[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69987 === (3))){
var inst_69974 = (state_69986[(7)]);
var inst_69977 = flureeworker.error_return_map(inst_69974);
var state_69986__$1 = state_69986;
var statearr_69991_70004 = state_69986__$1;
(statearr_69991_70004[(2)] = inst_69977);

(statearr_69991_70004[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69987 === (4))){
var inst_69974 = (state_69986[(7)]);
var inst_69979 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_69980 = [inst_69974,"loaded"];
var inst_69981 = cljs.core.PersistentHashMap.fromArrays(inst_69979,inst_69980);
var state_69986__$1 = state_69986;
var statearr_69992_70005 = state_69986__$1;
(statearr_69992_70005[(2)] = inst_69981);

(statearr_69992_70005[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69987 === (5))){
var inst_69983 = (state_69986[(2)]);
var inst_69984 = (function (){var G__69993 = conn_id;
var G__69994 = new cljs.core.Keyword(null,"setState","setState",552299271);
var G__69995 = id;
var G__69996 = inst_69983;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__69993,G__69994,G__69995,G__69996) : flureeworker.worker_action.call(null,G__69993,G__69994,G__69995,G__69996));
})();
var state_69986__$1 = state_69986;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69986__$1,inst_69984);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$process_query_$_state_machine__2727__auto__ = null;
var flureeworker$process_query_$_state_machine__2727__auto____0 = (function (){
var statearr_69997 = [null,null,null,null,null,null,null,null];
(statearr_69997[(0)] = flureeworker$process_query_$_state_machine__2727__auto__);

(statearr_69997[(1)] = (1));

return statearr_69997;
});
var flureeworker$process_query_$_state_machine__2727__auto____1 = (function (state_69986){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_69986);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69998){var ex__2730__auto__ = e69998;
var statearr_69999_70006 = state_69986;
(statearr_69999_70006[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_69986[(4)]))){
var statearr_70000_70007 = state_69986;
(statearr_70000_70007[(1)] = cljs.core.first((state_69986[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70008 = state_69986;
state_69986 = G__70008;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureeworker$process_query_$_state_machine__2727__auto__ = function(state_69986){
switch(arguments.length){
case 0:
return flureeworker$process_query_$_state_machine__2727__auto____0.call(this);
case 1:
return flureeworker$process_query_$_state_machine__2727__auto____1.call(this,state_69986);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$process_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$process_query_$_state_machine__2727__auto____0;
flureeworker$process_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$process_query_$_state_machine__2727__auto____1;
return flureeworker$process_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70001 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70001[(6)] = c__2749__auto__);

return statearr_70001;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
} else {
return null;
}
});
/**
 * Re-execute every registered query.
 */
flureeworker.process_all_queries = (function flureeworker$process_all_queries(conn_id){
var map__70009 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__70009__$1 = cljs.core.__destructure_map(map__70009);
var queries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70009__$1,new cljs.core.Keyword(null,"queries","queries",1446291995));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70009__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var query_ids = cljs.core.keys(queries);
var seq__70010 = cljs.core.seq(query_ids);
var chunk__70011 = null;
var count__70012 = (0);
var i__70013 = (0);
while(true){
if((i__70013 < count__70012)){
var id = chunk__70011.cljs$core$IIndexed$_nth$arity$2(null,i__70013);
flureeworker.process_query(conn_id,id,opts);


var G__70014 = seq__70010;
var G__70015 = chunk__70011;
var G__70016 = count__70012;
var G__70017 = (i__70013 + (1));
seq__70010 = G__70014;
chunk__70011 = G__70015;
count__70012 = G__70016;
i__70013 = G__70017;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__70010);
if(temp__5804__auto__){
var seq__70010__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__70010__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__70010__$1);
var G__70018 = cljs.core.chunk_rest(seq__70010__$1);
var G__70019 = c__5568__auto__;
var G__70020 = cljs.core.count(c__5568__auto__);
var G__70021 = (0);
seq__70010 = G__70018;
chunk__70011 = G__70019;
count__70012 = G__70020;
i__70013 = G__70021;
continue;
} else {
var id = cljs.core.first(seq__70010__$1);
flureeworker.process_query(conn_id,id,opts);


var G__70022 = cljs.core.next(seq__70010__$1);
var G__70023 = null;
var G__70024 = (0);
var G__70025 = (0);
seq__70010 = G__70022;
chunk__70011 = G__70023;
count__70012 = G__70024;
i__70013 = G__70025;
continue;
}
} else {
return null;
}
}
break;
}
});
flureeworker.ledger_listener = (function flureeworker$ledger_listener(conn,ledger,conn_id){
var vec__70026 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70026,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70026,(1),null);
var cb = (function (header,data){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70034){
var state_val_70035 = (state_70034[(1)]);
if((state_val_70035 === (1))){
var inst_70029 = cljs.core.async.timeout((100));
var state_70034__$1 = state_70034;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70034__$1,(2),inst_70029);
} else {
if((state_val_70035 === (2))){
var inst_70031 = (state_70034[(2)]);
var inst_70032 = flureeworker.process_all_queries(conn_id);
var state_70034__$1 = (function (){var statearr_70036 = state_70034;
(statearr_70036[(7)] = inst_70031);

return statearr_70036;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_70034__$1,inst_70032);
} else {
return null;
}
}
});
return (function() {
var flureeworker$ledger_listener_$_state_machine__2727__auto__ = null;
var flureeworker$ledger_listener_$_state_machine__2727__auto____0 = (function (){
var statearr_70037 = [null,null,null,null,null,null,null,null];
(statearr_70037[(0)] = flureeworker$ledger_listener_$_state_machine__2727__auto__);

(statearr_70037[(1)] = (1));

return statearr_70037;
});
var flureeworker$ledger_listener_$_state_machine__2727__auto____1 = (function (state_70034){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70034);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70038){var ex__2730__auto__ = e70038;
var statearr_70039_70042 = state_70034;
(statearr_70039_70042[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70034[(4)]))){
var statearr_70040_70043 = state_70034;
(statearr_70040_70043[(1)] = cljs.core.first((state_70034[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70044 = state_70034;
state_70034 = G__70044;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureeworker$ledger_listener_$_state_machine__2727__auto__ = function(state_70034){
switch(arguments.length){
case 0:
return flureeworker$ledger_listener_$_state_machine__2727__auto____0.call(this);
case 1:
return flureeworker$ledger_listener_$_state_machine__2727__auto____1.call(this,state_70034);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$ledger_listener_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$ledger_listener_$_state_machine__2727__auto____0;
flureeworker$ledger_listener_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$ledger_listener_$_state_machine__2727__auto____1;
return flureeworker$ledger_listener_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70041 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70041[(6)] = c__2749__auto__);

return statearr_70041;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
return fluree.db.connection.add_listener(conn,network,ledger_id,conn_id,cb);
});
flureeworker.remove_conn_listener = (function flureeworker$remove_conn_listener(conn,conn_id,ledger){
var vec__70045 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70045,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70045,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,conn_id);
});
/**
 * Registers new connection with all of its items.
 */
flureeworker.register_connection = (function flureeworker$register_connection(conn,config,queries){
var map__70048 = config;
var map__70048__$1 = cljs.core.__destructure_map(map__70048);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70048__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70048__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70048__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var log = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70048__$1,new cljs.core.Keyword(null,"log","log",-1595516004));
var compact = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70048__$1,new cljs.core.Keyword(null,"compact","compact",-348732150));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70048__$1,new cljs.core.Keyword(null,"private","private",-558947994));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc,id,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"closed","closed",-919675359),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"queries","queries",1446291995),new cljs.core.Keyword(null,"log","log",-1595516004),new cljs.core.Keyword(null,"conn","conn",278309663)],[false,ledger,private$,config,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"compact","compact",-348732150),compact], null),servers,(function (){var or__5045__auto__ = queries;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),log,conn]));
});
/**
 * Creates a new connection from existing configuration
 */
flureeworker.connect_STAR_ = (function flureeworker$connect_STAR_(conn_id,ref){
var conn_data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__70049 = conn_data;
var map__70049__$1 = cljs.core.__destructure_map(map__70049);
var config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70049__$1,new cljs.core.Keyword(null,"config","config",994861415));
var queries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70049__$1,new cljs.core.Keyword(null,"queries","queries",1446291995));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70049__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var map__70050 = config;
var map__70050__$1 = cljs.core.__destructure_map(map__70050);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70050__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70050__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70050__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var keepAlive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70050__$1,new cljs.core.Keyword(null,"keepAlive","keepAlive",-12888007));
var cb = (cljs.core.truth_(keepAlive)?(function (){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70056){
var state_val_70057 = (state_70056[(1)]);
if((state_val_70057 === (1))){
var inst_70051 = cljs.core.async.timeout((100));
var state_70056__$1 = state_70056;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70056__$1,(2),inst_70051);
} else {
if((state_val_70057 === (2))){
var inst_70053 = (state_70056[(2)]);
var inst_70054 = (flureeworker.connect_STAR_.cljs$core$IFn$_invoke$arity$2 ? flureeworker.connect_STAR_.cljs$core$IFn$_invoke$arity$2(id,ref) : flureeworker.connect_STAR_.call(null,id,ref));
var state_70056__$1 = (function (){var statearr_70058 = state_70056;
(statearr_70058[(7)] = inst_70053);

return statearr_70058;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_70056__$1,inst_70054);
} else {
return null;
}
}
});
return (function() {
var flureeworker$connect_STAR__$_state_machine__2727__auto__ = null;
var flureeworker$connect_STAR__$_state_machine__2727__auto____0 = (function (){
var statearr_70059 = [null,null,null,null,null,null,null,null];
(statearr_70059[(0)] = flureeworker$connect_STAR__$_state_machine__2727__auto__);

(statearr_70059[(1)] = (1));

return statearr_70059;
});
var flureeworker$connect_STAR__$_state_machine__2727__auto____1 = (function (state_70056){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70056);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70060){var ex__2730__auto__ = e70060;
var statearr_70061_70072 = state_70056;
(statearr_70061_70072[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70056[(4)]))){
var statearr_70062_70073 = state_70056;
(statearr_70062_70073[(1)] = cljs.core.first((state_70056[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70074 = state_70056;
state_70056 = G__70074;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureeworker$connect_STAR__$_state_machine__2727__auto__ = function(state_70056){
switch(arguments.length){
case 0:
return flureeworker$connect_STAR__$_state_machine__2727__auto____0.call(this);
case 1:
return flureeworker$connect_STAR__$_state_machine__2727__auto____1.call(this,state_70056);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$connect_STAR__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$connect_STAR__$_state_machine__2727__auto____0;
flureeworker$connect_STAR__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$connect_STAR__$_state_machine__2727__auto____1;
return flureeworker$connect_STAR__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70063 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70063[(6)] = c__2749__auto__);

return statearr_70063;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}):null);
var opts = cljs.core.assoc_in(config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)], null),cb);
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers,opts).then((function (conn){
if(cljs.core.truth_(jwt)){
fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
} else {
}

flureeworker.register_connection(conn,config,queries);

flureeworker.ledger_listener(conn,ledger,id);

var G__70064_70075 = conn_id;
var G__70065_70076 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__70066_70077 = ref;
var G__70067_70078 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection reset"], null);
(flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70064_70075,G__70065_70076,G__70066_70077,G__70067_70078) : flureeworker.worker_action.call(null,G__70064_70075,G__70065_70076,G__70066_70077,G__70067_70078));

return flureeworker.process_all_queries(conn_id);
})).catch((function (error){
var error_data = (function (){var temp__5802__auto__ = cljs.core.ex_data(error);
if(cljs.core.truth_(temp__5802__auto__)){
var ex_data = temp__5802__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(ex_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (500);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(error)], null),ex_data], 0));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),["Unexpected error: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error], 0))].join('')], null);
}
})();
var G__70068 = conn_id;
var G__70069 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__70070 = ref;
var G__70071 = error_data;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70068,G__70069,G__70070,G__70071) : flureeworker.worker_action.call(null,G__70068,G__70069,G__70070,G__70071));
}));
});
flureeworker.close_connection_STAR_ = (function flureeworker$close_connection_STAR_(var_args){
var G__70080 = arguments.length;
switch (G__70080) {
case 1:
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2(conn_id,false);
}));

(flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,save_config_QMARK_){
var conn_data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__70081 = conn_data;
var map__70081__$1 = cljs.core.__destructure_map(map__70081);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70081__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70081__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70081__$1,new cljs.core.Keyword(null,"config","config",994861415));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70081__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var new_config = (cljs.core.truth_(save_config_QMARK_)?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"closed","closed",-919675359),true,new cljs.core.Keyword(null,"config","config",994861415),config,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null):new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"closed","closed",-919675359),true], null));
if((((conn_data == null)) || (new cljs.core.Keyword(null,"closed","closed",-919675359).cljs$core$IFn$_invoke$arity$1(conn_data) === true))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection doesn't exist, or is already closed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
flureeworker.remove_conn_listener(conn,conn_id,ledger);

fluree.db.connection_js.close(conn);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc,conn_id,new_config);

return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection closed."], null);
}
}));

(flureeworker.close_connection_STAR_.cljs$lang$maxFixedArity = 2);

flureeworker.close_connection = (function flureeworker$close_connection(conn_id,ref){
try{var G__70088 = conn_id;
var G__70089 = new cljs.core.Keyword(null,"connClosed","connClosed",1810797125);
var G__70090 = ref;
var G__70091 = flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1(conn_id);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70088,G__70089,G__70090,G__70091) : flureeworker.worker_action.call(null,G__70088,G__70089,G__70090,G__70091));
}catch (e70083){var e = e70083;
var msg = (function (){var or__5045__auto__ = cljs.core.ex_message(e);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unexpected error.";
}
})();
var data = (function (){var or__5045__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
}
})();
var G__70084 = conn_id;
var G__70085 = new cljs.core.Keyword(null,"connClosed","connClosed",1810797125);
var G__70086 = ref;
var G__70087 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,new cljs.core.Keyword(null,"message","message",-406056002),msg);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70084,G__70085,G__70086,G__70087) : flureeworker.worker_action.call(null,G__70084,G__70085,G__70086,G__70087));
}});
flureeworker.reset_connection = (function flureeworker$reset_connection(conn_id,ref){
try{var save_config_QMARK_ = true;
flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2(conn_id,save_config_QMARK_);

return flureeworker.connect_STAR_(conn_id,ref);
}catch (e70092){var e = e70092;
var msg = (function (){var or__5045__auto__ = cljs.core.ex_message(e);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unexpected error.";
}
})();
var data = (function (){var or__5045__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
}
})();
var G__70093 = conn_id;
var G__70094 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__70095 = ref;
var G__70096 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,new cljs.core.Keyword(null,"message","message",-406056002),msg);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70093,G__70094,G__70095,G__70096) : flureeworker.worker_action.call(null,G__70093,G__70094,G__70095,G__70096));
}});
/**
 * Open new connection to a Fluree instance
 */
flureeworker.connect_p = (function flureeworker$connect_p(config,ref){
var config_STAR_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(config,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__70097 = config_STAR_;
var map__70097__$1 = cljs.core.__destructure_map(map__70097);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70097__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70097__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70097__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var keepAlive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70097__$1,new cljs.core.Keyword(null,"keepAlive","keepAlive",-12888007));
var _ = (cljs.core.truth_(new cljs.core.Keyword(null,"log","log",-1595516004).cljs$core$IFn$_invoke$arity$1(config_STAR_))?fluree.db.util.log.set_level_BANG_(new cljs.core.Keyword(null,"finest","finest",-1359568890)):null);
var cb = (cljs.core.truth_(keepAlive)?(function (){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70103){
var state_val_70104 = (state_70103[(1)]);
if((state_val_70104 === (1))){
var inst_70098 = cljs.core.async.timeout((100));
var state_70103__$1 = state_70103;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70103__$1,(2),inst_70098);
} else {
if((state_val_70104 === (2))){
var inst_70100 = (state_70103[(2)]);
var inst_70101 = flureeworker.connect_STAR_(id,ref);
var state_70103__$1 = (function (){var statearr_70105 = state_70103;
(statearr_70105[(7)] = inst_70100);

return statearr_70105;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_70103__$1,inst_70101);
} else {
return null;
}
}
});
return (function() {
var flureeworker$connect_p_$_state_machine__2727__auto__ = null;
var flureeworker$connect_p_$_state_machine__2727__auto____0 = (function (){
var statearr_70106 = [null,null,null,null,null,null,null,null];
(statearr_70106[(0)] = flureeworker$connect_p_$_state_machine__2727__auto__);

(statearr_70106[(1)] = (1));

return statearr_70106;
});
var flureeworker$connect_p_$_state_machine__2727__auto____1 = (function (state_70103){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70103);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70107){var ex__2730__auto__ = e70107;
var statearr_70108_70119 = state_70103;
(statearr_70108_70119[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70103[(4)]))){
var statearr_70109_70120 = state_70103;
(statearr_70109_70120[(1)] = cljs.core.first((state_70103[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70121 = state_70103;
state_70103 = G__70121;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureeworker$connect_p_$_state_machine__2727__auto__ = function(state_70103){
switch(arguments.length){
case 0:
return flureeworker$connect_p_$_state_machine__2727__auto____0.call(this);
case 1:
return flureeworker$connect_p_$_state_machine__2727__auto____1.call(this,state_70103);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$connect_p_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$connect_p_$_state_machine__2727__auto____0;
flureeworker$connect_p_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$connect_p_$_state_machine__2727__auto____1;
return flureeworker$connect_p_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70110 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70110[(6)] = c__2749__auto__);

return statearr_70110;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}):null);
var opts = cljs.core.assoc_in(config_STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)], null),cb);
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers,opts).then((function (conn){
flureeworker.register_connection(conn,config_STAR_,null);

flureeworker.ledger_listener(conn,ledger,id);

var G__70111 = id;
var G__70112 = new cljs.core.Keyword(null,"connStatus","connStatus",63327857);
var G__70113 = ref;
var G__70114 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection is ready."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70111,G__70112,G__70113,G__70114) : flureeworker.worker_action.call(null,G__70111,G__70112,G__70113,G__70114));
})).catch((function (error){
var G__70115 = id;
var G__70116 = new cljs.core.Keyword(null,"connStatus","connStatus",63327857);
var G__70117 = ref;
var G__70118 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.str.cljs$core$IFn$_invoke$arity$1(error)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70115,G__70116,G__70117,G__70118) : flureeworker.worker_action.call(null,G__70115,G__70116,G__70117,G__70118));
}));
});
/**
 * Returns true if connection has been closed.
 */
flureeworker.conn_closed_QMARK_ = (function flureeworker$conn_closed_QMARK_(conn_id){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"closed","closed",-919675359)], null));
});
/**
 * Authenticate with ledger via username and password.
 * 
 * If authentication is successful, a 200 status is returned with a JSON web token.
 * Otherwise, an error status is returned.
 */
flureeworker.login = (function flureeworker$login(var_args){
var args__5775__auto__ = [];
var len__5769__auto___70189 = arguments.length;
var i__5770__auto___70190 = (0);
while(true){
if((i__5770__auto___70190 < len__5769__auto___70189)){
args__5775__auto__.push((arguments[i__5770__auto___70190]));

var G__70191 = (i__5770__auto___70190 + (1));
i__5770__auto___70190 = G__70191;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((4) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((4)),(0),null)):null);
return flureeworker.login.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5776__auto__);
});

(flureeworker.login.cljs$core$IFn$_invoke$arity$variadic = (function (conn_id,ref,username,password,p__70127){
var vec__70128 = p__70127;
var expire = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70128,(0),null);
var map__70131 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__70131__$1 = cljs.core.__destructure_map(map__70131);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70131__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70131__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70131__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var _ = (cljs.core.truth_(ledger)?null:(function (){var G__70132 = conn_id;
var G__70133 = new cljs.core.Keyword(null,"login","login",55217519);
var G__70134 = ref;
var G__70135 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"message","message",-406056002),"Connection missing Ledger information. Password authentication is specific to a ledger."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70132,G__70133,G__70134,G__70135) : flureeworker.worker_action.call(null,G__70132,G__70133,G__70134,G__70135));
})());
var auth = null;
var c__2749__auto___70192 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70156){
var state_val_70157 = (state_70156[(1)]);
if((state_val_70157 === (1))){
var state_70156__$1 = state_70156;
var statearr_70158_70193 = state_70156__$1;
(statearr_70158_70193[(2)] = null);

(statearr_70158_70193[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70157 === (2))){
var ___$1 = (function (){var statearr_70159 = state_70156;
(statearr_70159[(4)] = cljs.core.cons((5),(state_70156[(4)])));

return statearr_70159;
})();
var inst_70147 = fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,username,auth,expire);
var inst_70148 = (function (){return (function (token){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null),token);

var G__70160 = conn_id;
var G__70161 = new cljs.core.Keyword(null,"login","login",55217519);
var G__70162 = ref;
var G__70163 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"token","token",-1211463215),token], null)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70160,G__70161,G__70162,G__70163) : flureeworker.worker_action.call(null,G__70160,G__70161,G__70162,G__70163));
});
})();
var inst_70149 = inst_70147.then(inst_70148);
var inst_70150 = (function (){return (function (resp){
var err = (function (){try{return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
}catch (e70164){var ___$2 = e70164;
return null;
}})();
var status = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err);
if((!((status == null)))){
var message = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Authentication failed: unknown authentication error";
}
})();
var error = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})();
var G__70165 = conn_id;
var G__70166 = new cljs.core.Keyword(null,"login","login",55217519);
var G__70167 = ref;
var G__70168 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"message","message",-406056002),message,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70165,G__70166,G__70167,G__70168) : flureeworker.worker_action.call(null,G__70165,G__70166,G__70167,G__70168));
} else {
var G__70169 = conn_id;
var G__70170 = new cljs.core.Keyword(null,"login","login",55217519);
var G__70171 = ref;
var G__70172 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"message","message",-406056002),["Authentication failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp)].join('')], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70169,G__70170,G__70171,G__70172) : flureeworker.worker_action.call(null,G__70169,G__70170,G__70171,G__70172));

}
});
})();
var inst_70151 = inst_70149.catch(inst_70150);
var ___$2 = (function (){var statearr_70173 = state_70156;
(statearr_70173[(4)] = cljs.core.rest((state_70156[(4)])));

return statearr_70173;
})();
var state_70156__$1 = state_70156;
var statearr_70174_70194 = state_70156__$1;
(statearr_70174_70194[(2)] = inst_70151);

(statearr_70174_70194[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70157 === (3))){
var inst_70154 = (state_70156[(2)]);
var state_70156__$1 = state_70156;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70156__$1,inst_70154);
} else {
if((state_val_70157 === (4))){
var inst_70136 = (state_70156[(2)]);
var inst_70137 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_70138 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70136);
var inst_70139 = [(400),inst_70138];
var inst_70140 = cljs.core.PersistentHashMap.fromArrays(inst_70137,inst_70139);
var inst_70141 = (function (){var G__70176 = conn_id;
var G__70177 = new cljs.core.Keyword(null,"login","login",55217519);
var G__70178 = ref;
var G__70179 = inst_70140;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70176,G__70177,G__70178,G__70179) : flureeworker.worker_action.call(null,G__70176,G__70177,G__70178,G__70179));
})();
var state_70156__$1 = state_70156;
var statearr_70180_70195 = state_70156__$1;
(statearr_70180_70195[(2)] = inst_70141);

(statearr_70180_70195[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70157 === (5))){
var ___$1 = (function (){var statearr_70181 = state_70156;
(statearr_70181[(4)] = cljs.core.rest((state_70156[(4)])));

return statearr_70181;
})();
var state_70156__$1 = state_70156;
var ex70175 = (state_70156__$1[(2)]);
var statearr_70182_70196 = state_70156__$1;
(statearr_70182_70196[(5)] = ex70175);


var statearr_70183_70197 = state_70156__$1;
(statearr_70183_70197[(1)] = (4));

(statearr_70183_70197[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$state_machine__2727__auto__ = null;
var flureeworker$state_machine__2727__auto____0 = (function (){
var statearr_70184 = [null,null,null,null,null,null,null];
(statearr_70184[(0)] = flureeworker$state_machine__2727__auto__);

(statearr_70184[(1)] = (1));

return statearr_70184;
});
var flureeworker$state_machine__2727__auto____1 = (function (state_70156){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70156);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70185){var ex__2730__auto__ = e70185;
var statearr_70186_70198 = state_70156;
(statearr_70186_70198[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70156[(4)]))){
var statearr_70187_70199 = state_70156;
(statearr_70187_70199[(1)] = cljs.core.first((state_70156[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70200 = state_70156;
state_70156 = G__70200;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureeworker$state_machine__2727__auto__ = function(state_70156){
switch(arguments.length){
case 0:
return flureeworker$state_machine__2727__auto____0.call(this);
case 1:
return flureeworker$state_machine__2727__auto____1.call(this,state_70156);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$state_machine__2727__auto____0;
flureeworker$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$state_machine__2727__auto____1;
return flureeworker$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70188 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70188[(6)] = c__2749__auto___70192);

return statearr_70188;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return true;
}));

(flureeworker.login.cljs$lang$maxFixedArity = (4));

/** @this {Function} */
(flureeworker.login.cljs$lang$applyTo = (function (seq70122){
var G__70123 = cljs.core.first(seq70122);
var seq70122__$1 = cljs.core.next(seq70122);
var G__70124 = cljs.core.first(seq70122__$1);
var seq70122__$2 = cljs.core.next(seq70122__$1);
var G__70125 = cljs.core.first(seq70122__$2);
var seq70122__$3 = cljs.core.next(seq70122__$2);
var G__70126 = cljs.core.first(seq70122__$3);
var seq70122__$4 = cljs.core.next(seq70122__$3);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70123,G__70124,G__70125,G__70126,seq70122__$4);
}));

/**
 * Attempts to generate a new user auth record account.
 * 
 * If request is successful, a 200 status is returned with a JSON web token.
 * Otherwise, an error status is returned.
 */
flureeworker.pw_generate = (function flureeworker$pw_generate(conn_id,ref,map_data){
var map__70201 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__70201__$1 = cljs.core.__destructure_map(map__70201);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70201__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70201__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var _ = (cljs.core.truth_(ledger)?null:(function (){var G__70203 = conn_id;
var G__70204 = new cljs.core.Keyword(null,"login","login",55217519);
var G__70205 = ref;
var G__70206 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"message","message",-406056002),"Connection missing Ledger information. Password authentication is specific to a ledger."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70203,G__70204,G__70205,G__70206) : flureeworker.worker_action.call(null,G__70203,G__70204,G__70205,G__70206));
})());
var map__70202 = map_data;
var map__70202__$1 = cljs.core.__destructure_map(map__70202);
var username = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70202__$1,new cljs.core.Keyword(null,"username","username",1605666410));
var password = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70202__$1,new cljs.core.Keyword(null,"password","password",417022471));
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70202__$1,new cljs.core.Keyword(null,"options","options",99638489));
var opts = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.select_keys(options,cljs.core.keys(options)),new cljs.core.Keyword(null,"user","user",1532431356),username);
var c__2749__auto___70260 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70227){
var state_val_70228 = (state_70227[(1)]);
if((state_val_70228 === (1))){
var state_70227__$1 = state_70227;
var statearr_70229_70261 = state_70227__$1;
(statearr_70229_70261[(2)] = null);

(statearr_70229_70261[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70228 === (2))){
var ___$1 = (function (){var statearr_70230 = state_70227;
(statearr_70230[(4)] = cljs.core.cons((5),(state_70227[(4)])));

return statearr_70230;
})();
var inst_70218 = fluree.db.connection_js.password_generate(conn,ledger,password,opts);
var inst_70219 = (function (){return (function (token){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null),token);

var G__70231 = conn_id;
var G__70232 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__70233 = ref;
var G__70234 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"token","token",-1211463215),token], null)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70231,G__70232,G__70233,G__70234) : flureeworker.worker_action.call(null,G__70231,G__70232,G__70233,G__70234));
});
})();
var inst_70220 = inst_70218.then(inst_70219);
var inst_70221 = (function (){return (function (resp){
var err = (function (){try{return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
}catch (e70235){var ___$2 = e70235;
return null;
}})();
var status = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err);
if((!((status == null)))){
var message = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Password Generation failed: unknown error";
}
})();
var error = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})();
var G__70236 = conn_id;
var G__70237 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__70238 = ref;
var G__70239 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"message","message",-406056002),message,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70236,G__70237,G__70238,G__70239) : flureeworker.worker_action.call(null,G__70236,G__70237,G__70238,G__70239));
} else {
var G__70240 = conn_id;
var G__70241 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__70242 = ref;
var G__70243 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"message","message",-406056002),["Password Generation failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp)].join('')], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70240,G__70241,G__70242,G__70243) : flureeworker.worker_action.call(null,G__70240,G__70241,G__70242,G__70243));

}
});
})();
var inst_70222 = inst_70220.catch(inst_70221);
var ___$2 = (function (){var statearr_70244 = state_70227;
(statearr_70244[(4)] = cljs.core.rest((state_70227[(4)])));

return statearr_70244;
})();
var state_70227__$1 = state_70227;
var statearr_70245_70262 = state_70227__$1;
(statearr_70245_70262[(2)] = inst_70222);

(statearr_70245_70262[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70228 === (3))){
var inst_70225 = (state_70227[(2)]);
var state_70227__$1 = state_70227;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70227__$1,inst_70225);
} else {
if((state_val_70228 === (4))){
var inst_70207 = (state_70227[(2)]);
var inst_70208 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_70209 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70207);
var inst_70210 = [(400),inst_70209];
var inst_70211 = cljs.core.PersistentHashMap.fromArrays(inst_70208,inst_70210);
var inst_70212 = (function (){var G__70247 = conn_id;
var G__70248 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__70249 = ref;
var G__70250 = inst_70211;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__70247,G__70248,G__70249,G__70250) : flureeworker.worker_action.call(null,G__70247,G__70248,G__70249,G__70250));
})();
var state_70227__$1 = state_70227;
var statearr_70251_70263 = state_70227__$1;
(statearr_70251_70263[(2)] = inst_70212);

(statearr_70251_70263[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70228 === (5))){
var ___$1 = (function (){var statearr_70252 = state_70227;
(statearr_70252[(4)] = cljs.core.rest((state_70227[(4)])));

return statearr_70252;
})();
var state_70227__$1 = state_70227;
var ex70246 = (state_70227__$1[(2)]);
var statearr_70253_70264 = state_70227__$1;
(statearr_70253_70264[(5)] = ex70246);


var statearr_70254_70265 = state_70227__$1;
(statearr_70254_70265[(1)] = (4));

(statearr_70254_70265[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$pw_generate_$_state_machine__2727__auto__ = null;
var flureeworker$pw_generate_$_state_machine__2727__auto____0 = (function (){
var statearr_70255 = [null,null,null,null,null,null,null];
(statearr_70255[(0)] = flureeworker$pw_generate_$_state_machine__2727__auto__);

(statearr_70255[(1)] = (1));

return statearr_70255;
});
var flureeworker$pw_generate_$_state_machine__2727__auto____1 = (function (state_70227){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70227);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70256){var ex__2730__auto__ = e70256;
var statearr_70257_70266 = state_70227;
(statearr_70257_70266[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70227[(4)]))){
var statearr_70258_70267 = state_70227;
(statearr_70258_70267[(1)] = cljs.core.first((state_70227[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70268 = state_70227;
state_70227 = G__70268;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureeworker$pw_generate_$_state_machine__2727__auto__ = function(state_70227){
switch(arguments.length){
case 0:
return flureeworker$pw_generate_$_state_machine__2727__auto____0.call(this);
case 1:
return flureeworker$pw_generate_$_state_machine__2727__auto____1.call(this,state_70227);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$pw_generate_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$pw_generate_$_state_machine__2727__auto____0;
flureeworker$pw_generate_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$pw_generate_$_state_machine__2727__auto____1;
return flureeworker$pw_generate_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70259 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70259[(6)] = c__2749__auto___70260);

return statearr_70259;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return true;
});
flureeworker.unregisterQuery = (function flureeworker$unregisterQuery(conn_id,ref){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(flureeworker.conn_register,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ref], 0));
});
/**
 * Registers a new flureeQL query. 'opts' gets merged in with the flureeQL.opts, and is there
 *   to ease adding options to a GraphQL (and later other string-based queries like SPARQL and SQL),
 *   which do not have the same ability to dynamically add options.
 */
flureeworker.registerQuery = (function flureeworker$registerQuery(conn_id,ref,js_flurql,force_update_QMARK_){
var flureeQL = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(js_flurql,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(flureeQL,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995),ref], null)))) || (force_update_QMARK_ === true))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(flureeworker.conn_register,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ref,flureeQL], 0));

flureeworker.process_query(conn_id,ref,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"opts","opts",155075701)], null)));
} else {
}

return true;
});
/**
 * Submits a transaction across a websocket to a fluree instance
 */
flureeworker.transact = (function flureeworker$transact(conn_id,ref,map_data){
return new cljs.core.Keyword(null,"TODO","TODO",-523795145);
});
/**
 * Takes javascript array and move it into a clojurescript list without
 *   converting individual elements.
 */
flureeworker.js_array__GT_clj_list = (function flureeworker$js_array__GT_clj_list(js_array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__70269_SHARP_){
return (js_array[p1__70269_SHARP_]);
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(js_array.length));
});
/**
 * Main handler function for worker events
 *   Even data is a javascript object with the following keys:
 *   - action - the action to perform
 *   - params - parameters for the action we are calling
 *   - conn - the connection ID
 *   - ref - the reference ID to include in the response
 *   
 */
flureeworker.decode_message = (function flureeworker$decode_message(event){
try{var data = (event["data"]);
var action_str = (data["action"]);
var conn_id = (data["conn"]);
var ref = (data["ref"]);
var params_js = (data["params"]);
var params = ((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"pwGenerate")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"transact"))))?flureeworker.obj__GT_clj(cljs.core.first(params_js)):flureeworker.js_array__GT_clj_list(params_js)
);
if(cljs.core.truth_(flureeworker.conn_closed_QMARK_(conn_id))){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"unregisterQuery")){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),action_str,new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),({"status": (400), "message": "Connection has been closed."})], null));
} else {
return null;
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"connect")){
return flureeworker.connect_p(cljs.core.first(params),ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"close")){
return flureeworker.close_connection(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"reset")){
return flureeworker.reset_connection(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"registerQuery")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(flureeworker.registerQuery,conn_id,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"unregisterQuery")){
return flureeworker.unregisterQuery(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"login")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(flureeworker.login,conn_id,ref,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"pwGenerate")){
return flureeworker.pw_generate(conn_id,ref,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"transact")){
return flureeworker.transact(conn_id,ref,params);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unknown action: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(action_str)].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"status","status",-1997798413),(400)], null));

}
}
}
}
}
}
}
}
}
}catch (e70270){var e = e70270;
var data = (event["data"]);
var error_data = (function (){var temp__5802__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(temp__5802__auto__)){
var ex_data = temp__5802__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(ex_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (500);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(e)], null),ex_data], 0));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),["Unexpected error: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0))].join('')], null);
}
})();
console.error("Error executing message:",data);

console.error(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error_data], 0)));

return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),(data["conn"]),new cljs.core.Keyword(null,"event","event",301435442),(data["action"]),new cljs.core.Keyword(null,"ref","ref",1289896967),(data["ref"]),new cljs.core.Keyword(null,"data","data",-232669377),error_data], null));
}});
/**
 * Log errors in this web worker
 */
flureeworker.log_error = (function flureeworker$log_error(error){
return console.error(error);
});
var temp__5804__auto___70271 = cljs.core.not(self.document);
if(temp__5804__auto___70271){
var worker_QMARK__70272 = temp__5804__auto___70271;
(self.onerror = flureeworker.log_error);

(self.onmessage = flureeworker.decode_message);
} else {
}
var G__70273_70275 = null;
var G__70274_70276 = new cljs.core.Keyword(null,"connInit","connInit",-148647574);
(flureeworker.worker_action.cljs$core$IFn$_invoke$arity$2 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$2(G__70273_70275,G__70274_70276) : flureeworker.worker_action.call(null,G__70273_70275,G__70274_70276));
