// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('alphabase.base32');
goog.require('cljs.core');
goog.require('alphabase.codec');
goog.require('clojure.set');
alphabase.base32.base32_chars = "abcdefghijklmnopqrstuvwxyz234567";
alphabase.base32.base32_set = cljs.core.set.call(null,"abcdefghijklmnopqrstuvwxyz234567");
/**
 * Test if input is base32.
 */
alphabase.base32.base32_QMARK_ = (function alphabase$base32$base32_QMARK_(x){
return ((typeof x === 'string') && (clojure.set.subset_QMARK_.call(null,cljs.core.set.call(null,x),alphabase.base32.base32_set)));
});
/**
 * Converts a byte array into a base32 string.
 */
alphabase.base32.encode = (function alphabase$base32$encode(ba){
return alphabase.codec.encode.call(null,"abcdefghijklmnopqrstuvwxyz234567",ba);
});
/**
 * Decodes a base32 string into a byte array.
 */
alphabase.base32.decode = (function alphabase$base32$decode(b32_string){
return alphabase.codec.decode.call(null,"abcdefghijklmnopqrstuvwxyz234567",b32_string);
});
