// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('alphabase.base64');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('goog.crypt.base64');
alphabase.base64.base64_chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
alphabase.base64.base64_set = cljs.core.set.call(null,"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=");
/**
 * Converts a byte array into a base64-check string.
 */
alphabase.base64.encode = (function alphabase$base64$encode(ba){
return goog.crypt.base64.encodeByteArray(ba);
});
/**
 * Decodes a base64-check string into a byte array.
 */
alphabase.base64.decode = (function alphabase$base64$decode(b64_string){
return goog.crypt.base64.decodeStringToByteArray(b64_string);
});
/**
 * Test if input is base64
 */
alphabase.base64.base64_QMARK_ = (function alphabase$base64$base64_QMARK_(x){
return ((typeof x === 'string') && (clojure.set.subset_QMARK_.call(null,cljs.core.set.call(null,x),alphabase.base64.base64_set)));
});
