// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.dbfunctions.ctx');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__74158 = arguments.length;
switch (G__74158) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5802__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var block = temp__5802__auto__;
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___74197 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_74179){
var state_val_74180 = (state_74179[(1)]);
if((state_val_74180 === (1))){
var state_74179__$1 = state_74179;
var statearr_74181_74198 = state_74179__$1;
(statearr_74181_74198[(2)] = null);

(statearr_74181_74198[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74180 === (2))){
var _ = (function (){var statearr_74182 = state_74179;
(statearr_74182[(4)] = cljs.core.cons.call(null,(5),(state_74179[(4)])));

return statearr_74182;
})();
var inst_74165 = fluree.db.session.db.call(null,conn,ledger,null);
var state_74179__$1 = state_74179;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74179__$1,(7),inst_74165);
} else {
if((state_val_74180 === (3))){
var inst_74175 = (state_74179[(2)]);
var inst_74176 = cljs.core.async.put_BANG_.call(null,pc,inst_74175);
var inst_74177 = cljs.core.async.close_BANG_.call(null,pc);
var state_74179__$1 = (function (){var statearr_74184 = state_74179;
(statearr_74184[(7)] = inst_74176);

return statearr_74184;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74179__$1,inst_74177);
} else {
if((state_val_74180 === (4))){
var inst_74159 = (state_74179[(2)]);
var state_74179__$1 = state_74179;
var statearr_74185_74199 = state_74179__$1;
(statearr_74185_74199[(2)] = inst_74159);

(statearr_74185_74199[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74180 === (5))){
var _ = (function (){var statearr_74186 = state_74179;
(statearr_74186[(4)] = cljs.core.rest.call(null,(state_74179[(4)])));

return statearr_74186;
})();
var state_74179__$1 = state_74179;
var ex74183 = (state_74179__$1[(2)]);
var statearr_74187_74200 = state_74179__$1;
(statearr_74187_74200[(5)] = ex74183);


var statearr_74188_74201 = state_74179__$1;
(statearr_74188_74201[(1)] = (4));

(statearr_74188_74201[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74180 === (6))){
var inst_74171 = (state_74179[(2)]);
var inst_74172 = fluree.db.util.async.throw_err.call(null,inst_74171);
var _ = (function (){var statearr_74189 = state_74179;
(statearr_74189[(4)] = cljs.core.rest.call(null,(state_74179[(4)])));

return statearr_74189;
})();
var state_74179__$1 = state_74179;
var statearr_74190_74202 = state_74179__$1;
(statearr_74190_74202[(2)] = inst_74172);

(statearr_74190_74202[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74180 === (7))){
var inst_74167 = (state_74179[(2)]);
var inst_74168 = fluree.db.util.async.throw_err.call(null,inst_74167);
var inst_74169 = fluree.db.time_travel.as_of_block.call(null,inst_74168,block);
var state_74179__$1 = state_74179;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74179__$1,(6),inst_74169);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2746__auto__ = null;
var fluree$db$api$ledger$state_machine__2746__auto____0 = (function (){
var statearr_74191 = [null,null,null,null,null,null,null,null];
(statearr_74191[(0)] = fluree$db$api$ledger$state_machine__2746__auto__);

(statearr_74191[(1)] = (1));

return statearr_74191;
});
var fluree$db$api$ledger$state_machine__2746__auto____1 = (function (state_74179){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_74179);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e74192){var ex__2749__auto__ = e74192;
var statearr_74193_74203 = state_74179;
(statearr_74193_74203[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_74179[(4)]))){
var statearr_74194_74204 = state_74179;
(statearr_74194_74204[(1)] = cljs.core.first.call(null,(state_74179[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74205 = state_74179;
state_74179 = G__74205;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2746__auto__ = function(state_74179){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2746__auto____1.call(this,state_74179);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2746__auto____0;
fluree$db$api$ledger$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2746__auto____1;
return fluree$db$api$ledger$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_74195 = f__2769__auto__.call(null);
(statearr_74195[(6)] = c__2768__auto___74197);

return statearr_74195;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
} else {
return fluree.db.session.db.call(null,conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t.call(null,db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_74246){
var state_val_74247 = (state_74246[(1)]);
if((state_val_74247 === (7))){
var inst_74215 = cljs.core._EQ_.call(null,(0),auth);
var state_74246__$1 = state_74246;
if(inst_74215){
var statearr_74248_74279 = state_74246__$1;
(statearr_74248_74279[(1)] = (9));

} else {
var statearr_74249_74280 = state_74246__$1;
(statearr_74249_74280[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74247 === (1))){
var state_74246__$1 = state_74246;
var statearr_74250_74281 = state_74246__$1;
(statearr_74250_74281[(2)] = null);

(statearr_74250_74281[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74247 === (4))){
var inst_74206 = (state_74246[(2)]);
var state_74246__$1 = state_74246;
var statearr_74251_74282 = state_74246__$1;
(statearr_74251_74282[(2)] = inst_74206);

(statearr_74251_74282[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74247 === (15))){
var inst_74223 = (state_74246[(7)]);
var inst_74222 = (state_74246[(2)]);
var inst_74223__$1 = fluree.db.util.async.throw_err.call(null,inst_74222);
var state_74246__$1 = (function (){var statearr_74252 = state_74246;
(statearr_74252[(7)] = inst_74223__$1);

return statearr_74252;
})();
if(cljs.core.truth_(inst_74223__$1)){
var statearr_74253_74283 = state_74246__$1;
(statearr_74253_74283[(1)] = (16));

} else {
var statearr_74254_74284 = state_74246__$1;
(statearr_74254_74284[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74247 === (13))){
var state_74246__$1 = state_74246;
var statearr_74255_74285 = state_74246__$1;
(statearr_74255_74285[(2)] = null);

(statearr_74255_74285[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74247 === (6))){
var state_74246__$1 = state_74246;
var statearr_74256_74286 = state_74246__$1;
(statearr_74256_74286[(2)] = db);

(statearr_74256_74286[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74247 === (17))){
var inst_74227 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_74228 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74229 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_74230 = cljs.core.PersistentHashMap.fromArrays(inst_74228,inst_74229);
var inst_74231 = cljs.core.ex_info.call(null,inst_74227,inst_74230);
var inst_74232 = (function(){throw inst_74231})();
var state_74246__$1 = state_74246;
var statearr_74257_74287 = state_74246__$1;
(statearr_74257_74287[(2)] = inst_74232);

(statearr_74257_74287[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74247 === (3))){
var inst_74244 = (state_74246[(2)]);
var state_74246__$1 = state_74246;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74246__$1,inst_74244);
} else {
if((state_val_74247 === (12))){
var inst_74220 = fluree.db.dbproto._subid.call(null,db,auth);
var state_74246__$1 = state_74246;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74246__$1,(15),inst_74220);
} else {
if((state_val_74247 === (2))){
var _ = (function (){var statearr_74258 = state_74246;
(statearr_74258[(4)] = cljs.core.cons.call(null,(5),(state_74246[(4)])));

return statearr_74258;
})();
var inst_74212 = cljs.core.not.call(null,auth);
var state_74246__$1 = state_74246;
if(inst_74212){
var statearr_74259_74288 = state_74246__$1;
(statearr_74259_74288[(1)] = (6));

} else {
var statearr_74260_74289 = state_74246__$1;
(statearr_74260_74289[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74247 === (11))){
var inst_74239 = (state_74246[(2)]);
var state_74246__$1 = state_74246;
var statearr_74262_74290 = state_74246__$1;
(statearr_74262_74290[(2)] = inst_74239);

(statearr_74262_74290[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74247 === (9))){
var inst_74217 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_74246__$1 = state_74246;
var statearr_74263_74291 = state_74246__$1;
(statearr_74263_74291[(2)] = inst_74217);

(statearr_74263_74291[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74247 === (5))){
var _ = (function (){var statearr_74264 = state_74246;
(statearr_74264[(4)] = cljs.core.rest.call(null,(state_74246[(4)])));

return statearr_74264;
})();
var state_74246__$1 = state_74246;
var ex74261 = (state_74246__$1[(2)]);
var statearr_74265_74292 = state_74246__$1;
(statearr_74265_74292[(5)] = ex74261);


if((ex74261 instanceof Error)){
var statearr_74266_74293 = state_74246__$1;
(statearr_74266_74293[(1)] = (4));

(statearr_74266_74293[(5)] = null);

} else {
throw ex74261;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74247 === (14))){
var inst_74237 = (state_74246[(2)]);
var state_74246__$1 = state_74246;
var statearr_74267_74294 = state_74246__$1;
(statearr_74267_74294[(2)] = inst_74237);

(statearr_74267_74294[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74247 === (16))){
var inst_74223 = (state_74246[(7)]);
var inst_74225 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_74223);
var state_74246__$1 = state_74246;
var statearr_74268_74295 = state_74246__$1;
(statearr_74268_74295[(2)] = inst_74225);

(statearr_74268_74295[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74247 === (10))){
var state_74246__$1 = state_74246;
var statearr_74269_74296 = state_74246__$1;
(statearr_74269_74296[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74247 === (18))){
var inst_74234 = (state_74246[(2)]);
var state_74246__$1 = state_74246;
var statearr_74271_74297 = state_74246__$1;
(statearr_74271_74297[(2)] = inst_74234);

(statearr_74271_74297[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74247 === (8))){
var inst_74241 = (state_74246[(2)]);
var _ = (function (){var statearr_74272 = state_74246;
(statearr_74272[(4)] = cljs.core.rest.call(null,(state_74246[(4)])));

return statearr_74272;
})();
var state_74246__$1 = state_74246;
var statearr_74273_74298 = state_74246__$1;
(statearr_74273_74298[(2)] = inst_74241);

(statearr_74273_74298[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____0 = (function (){
var statearr_74274 = [null,null,null,null,null,null,null,null];
(statearr_74274[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__);

(statearr_74274[(1)] = (1));

return statearr_74274;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____1 = (function (state_74246){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_74246);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e74275){var ex__2749__auto__ = e74275;
var statearr_74276_74299 = state_74246;
(statearr_74276_74299[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_74246[(4)]))){
var statearr_74277_74300 = state_74246;
(statearr_74277_74300[(1)] = cljs.core.first.call(null,(state_74246[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74301 = state_74246;
state_74246 = G__74301;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__ = function(state_74246){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____1.call(this,state_74246);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_74278 = f__2769__auto__.call(null);
(statearr_74278[(6)] = c__2768__auto__);

return statearr_74278;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_74373){
var state_val_74374 = (state_74373[(1)]);
if((state_val_74374 === (7))){
var inst_74311 = cljs.core._EQ_.call(null,(0),auth);
var state_74373__$1 = state_74373;
if(inst_74311){
var statearr_74375_74429 = state_74373__$1;
(statearr_74375_74429[(1)] = (9));

} else {
var statearr_74376_74430 = state_74373__$1;
(statearr_74376_74430[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74374 === (20))){
var inst_74335 = (state_74373[(7)]);
var state_74373__$1 = state_74373;
if(cljs.core.truth_(inst_74335)){
var statearr_74377_74431 = state_74373__$1;
(statearr_74377_74431[(1)] = (22));

} else {
var statearr_74378_74432 = state_74373__$1;
(statearr_74378_74432[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74374 === (27))){
var state_74373__$1 = state_74373;
var statearr_74379_74433 = state_74373__$1;
(statearr_74379_74433[(2)] = null);

(statearr_74379_74433[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74374 === (1))){
var state_74373__$1 = state_74373;
var statearr_74380_74434 = state_74373__$1;
(statearr_74380_74434[(2)] = null);

(statearr_74380_74434[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74374 === (24))){
var inst_74349 = (state_74373[(2)]);
var state_74373__$1 = state_74373;
var statearr_74381_74435 = state_74373__$1;
(statearr_74381_74435[(2)] = inst_74349);

(statearr_74381_74435[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74374 === (4))){
var inst_74302 = (state_74373[(2)]);
var state_74373__$1 = state_74373;
var statearr_74382_74436 = state_74373__$1;
(statearr_74382_74436[(2)] = inst_74302);

(statearr_74382_74436[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74374 === (15))){
var inst_74318 = (state_74373[(8)]);
var inst_74317 = (state_74373[(2)]);
var inst_74318__$1 = fluree.db.util.async.throw_err.call(null,inst_74317);
var state_74373__$1 = (function (){var statearr_74383 = state_74373;
(statearr_74383[(8)] = inst_74318__$1);

return statearr_74383;
})();
if(cljs.core.truth_(inst_74318__$1)){
var statearr_74384_74437 = state_74373__$1;
(statearr_74384_74437[(1)] = (16));

} else {
var statearr_74385_74438 = state_74373__$1;
(statearr_74385_74438[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74374 === (21))){
var inst_74351 = (state_74373[(9)]);
var inst_74351__$1 = (state_74373[(2)]);
var state_74373__$1 = (function (){var statearr_74386 = state_74373;
(statearr_74386[(9)] = inst_74351__$1);

return statearr_74386;
})();
if(cljs.core.truth_(inst_74351__$1)){
var statearr_74387_74439 = state_74373__$1;
(statearr_74387_74439[(1)] = (29));

} else {
var statearr_74388_74440 = state_74373__$1;
(statearr_74388_74440[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74374 === (31))){
var inst_74351 = (state_74373[(9)]);
var inst_74359 = (state_74373[(2)]);
var state_74373__$1 = (function (){var statearr_74389 = state_74373;
(statearr_74389[(10)] = inst_74359);

return statearr_74389;
})();
if(cljs.core.truth_(inst_74351)){
var statearr_74390_74441 = state_74373__$1;
(statearr_74390_74441[(1)] = (33));

} else {
var statearr_74391_74442 = state_74373__$1;
(statearr_74391_74442[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74374 === (32))){
var inst_74355 = (state_74373[(2)]);
var inst_74356 = fluree.db.util.async.throw_err.call(null,inst_74355);
var state_74373__$1 = state_74373;
var statearr_74392_74443 = state_74373__$1;
(statearr_74392_74443[(2)] = inst_74356);

(statearr_74392_74443[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74374 === (33))){
var inst_74351 = (state_74373[(9)]);
var inst_74361 = fluree.db.permissions.permission_map.call(null,db,inst_74351,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_74373__$1 = state_74373;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74373__$1,(36),inst_74361);
} else {
if((state_val_74374 === (13))){
var state_74373__$1 = state_74373;
var statearr_74393_74444 = state_74373__$1;
(statearr_74393_74444[(2)] = null);

(statearr_74393_74444[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74374 === (22))){
var inst_74335 = (state_74373[(7)]);
var inst_74339 = fluree.db.auth.roles.call(null,db,inst_74335);
var state_74373__$1 = state_74373;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74373__$1,(25),inst_74339);
} else {
if((state_val_74374 === (36))){
var inst_74363 = (state_74373[(2)]);
var inst_74364 = fluree.db.util.async.throw_err.call(null,inst_74363);
var state_74373__$1 = state_74373;
var statearr_74394_74445 = state_74373__$1;
(statearr_74394_74445[(2)] = inst_74364);

(statearr_74394_74445[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74374 === (29))){
var inst_74351 = (state_74373[(9)]);
var inst_74335 = (state_74373[(7)]);
var inst_74353 = fluree.db.dbfunctions.ctx.build.call(null,db,inst_74335,inst_74351);
var state_74373__$1 = state_74373;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74373__$1,(32),inst_74353);
} else {
if((state_val_74374 === (6))){
var state_74373__$1 = state_74373;
var statearr_74395_74446 = state_74373__$1;
(statearr_74395_74446[(2)] = null);

(statearr_74395_74446[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74374 === (28))){
var inst_74347 = (state_74373[(2)]);
var state_74373__$1 = state_74373;
var statearr_74396_74447 = state_74373__$1;
(statearr_74396_74447[(2)] = inst_74347);

(statearr_74396_74447[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74374 === (25))){
var inst_74341 = (state_74373[(2)]);
var inst_74342 = fluree.db.util.async.throw_err.call(null,inst_74341);
var state_74373__$1 = state_74373;
var statearr_74397_74448 = state_74373__$1;
(statearr_74397_74448[(2)] = inst_74342);

(statearr_74397_74448[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74374 === (34))){
var state_74373__$1 = state_74373;
var statearr_74398_74449 = state_74373__$1;
(statearr_74398_74449[(2)] = null);

(statearr_74398_74449[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74374 === (17))){
var inst_74321 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_74322 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74323 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_74324 = cljs.core.PersistentHashMap.fromArrays(inst_74322,inst_74323);
var inst_74325 = cljs.core.ex_info.call(null,inst_74321,inst_74324);
var inst_74326 = (function(){throw inst_74325})();
var state_74373__$1 = state_74373;
var statearr_74399_74450 = state_74373__$1;
(statearr_74399_74450[(2)] = inst_74326);

(statearr_74399_74450[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74374 === (3))){
var inst_74371 = (state_74373[(2)]);
var state_74373__$1 = state_74373;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74373__$1,inst_74371);
} else {
if((state_val_74374 === (12))){
var inst_74315 = fluree.db.dbproto._subid.call(null,db,auth);
var state_74373__$1 = state_74373;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74373__$1,(15),inst_74315);
} else {
if((state_val_74374 === (2))){
var _ = (function (){var statearr_74400 = state_74373;
(statearr_74400[(4)] = cljs.core.cons.call(null,(5),(state_74373[(4)])));

return statearr_74400;
})();
var inst_74308 = (auth == null);
var state_74373__$1 = state_74373;
if(cljs.core.truth_(inst_74308)){
var statearr_74401_74451 = state_74373__$1;
(statearr_74401_74451[(1)] = (6));

} else {
var statearr_74402_74452 = state_74373__$1;
(statearr_74402_74452[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74374 === (23))){
var state_74373__$1 = state_74373;
var statearr_74403_74453 = state_74373__$1;
(statearr_74403_74453[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74374 === (35))){
var inst_74351 = (state_74373[(9)]);
var inst_74359 = (state_74373[(10)]);
var inst_74335 = (state_74373[(7)]);
var inst_74367 = (state_74373[(2)]);
var inst_74368 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_74335,new cljs.core.Keyword(null,"auth-id","auth-id",444160740),auth,new cljs.core.Keyword(null,"roles","roles",143379530),inst_74351,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_74367,new cljs.core.Keyword(null,"ctx","ctx",-493610118),inst_74359);
var _ = (function (){var statearr_74405 = state_74373;
(statearr_74405[(4)] = cljs.core.rest.call(null,(state_74373[(4)])));

return statearr_74405;
})();
var state_74373__$1 = state_74373;
var statearr_74406_74454 = state_74373__$1;
(statearr_74406_74454[(2)] = inst_74368);

(statearr_74406_74454[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74374 === (19))){
var state_74373__$1 = state_74373;
var statearr_74407_74455 = state_74373__$1;
(statearr_74407_74455[(2)] = roles);

(statearr_74407_74455[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74374 === (11))){
var inst_74333 = (state_74373[(2)]);
var state_74373__$1 = state_74373;
var statearr_74409_74456 = state_74373__$1;
(statearr_74409_74456[(2)] = inst_74333);

(statearr_74409_74456[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74374 === (9))){
var state_74373__$1 = state_74373;
var statearr_74410_74457 = state_74373__$1;
(statearr_74410_74457[(2)] = (0));

(statearr_74410_74457[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74374 === (5))){
var _ = (function (){var statearr_74411 = state_74373;
(statearr_74411[(4)] = cljs.core.rest.call(null,(state_74373[(4)])));

return statearr_74411;
})();
var state_74373__$1 = state_74373;
var ex74408 = (state_74373__$1[(2)]);
var statearr_74412_74458 = state_74373__$1;
(statearr_74412_74458[(5)] = ex74408);


if((ex74408 instanceof Error)){
var statearr_74413_74459 = state_74373__$1;
(statearr_74413_74459[(1)] = (4));

(statearr_74413_74459[(5)] = null);

} else {
throw ex74408;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74374 === (14))){
var inst_74331 = (state_74373[(2)]);
var state_74373__$1 = state_74373;
var statearr_74414_74460 = state_74373__$1;
(statearr_74414_74460[(2)] = inst_74331);

(statearr_74414_74460[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74374 === (26))){
var state_74373__$1 = state_74373;
var statearr_74415_74461 = state_74373__$1;
(statearr_74415_74461[(2)] = null);

(statearr_74415_74461[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74374 === (16))){
var inst_74318 = (state_74373[(8)]);
var state_74373__$1 = state_74373;
var statearr_74416_74462 = state_74373__$1;
(statearr_74416_74462[(2)] = inst_74318);

(statearr_74416_74462[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74374 === (30))){
var state_74373__$1 = state_74373;
var statearr_74417_74463 = state_74373__$1;
(statearr_74417_74463[(2)] = null);

(statearr_74417_74463[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74374 === (10))){
var state_74373__$1 = state_74373;
if(cljs.core.truth_(auth)){
var statearr_74418_74464 = state_74373__$1;
(statearr_74418_74464[(1)] = (12));

} else {
var statearr_74419_74465 = state_74373__$1;
(statearr_74419_74465[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74374 === (18))){
var inst_74328 = (state_74373[(2)]);
var state_74373__$1 = state_74373;
var statearr_74420_74466 = state_74373__$1;
(statearr_74420_74466[(2)] = inst_74328);

(statearr_74420_74466[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74374 === (8))){
var inst_74335 = (state_74373[(2)]);
var state_74373__$1 = (function (){var statearr_74421 = state_74373;
(statearr_74421[(7)] = inst_74335);

return statearr_74421;
})();
if(cljs.core.truth_(roles)){
var statearr_74422_74467 = state_74373__$1;
(statearr_74422_74467[(1)] = (19));

} else {
var statearr_74423_74468 = state_74373__$1;
(statearr_74423_74468[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____0 = (function (){
var statearr_74424 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_74424[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__);

(statearr_74424[(1)] = (1));

return statearr_74424;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____1 = (function (state_74373){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_74373);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e74425){var ex__2749__auto__ = e74425;
var statearr_74426_74469 = state_74373;
(statearr_74426_74469[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_74373[(4)]))){
var statearr_74427_74470 = state_74373;
(statearr_74427_74470[(1)] = cljs.core.first.call(null,(state_74373[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74471 = state_74373;
state_74373 = G__74471;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__ = function(state_74373){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____1.call(this,state_74373);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_74428 = f__2769__auto__.call(null);
(statearr_74428[(6)] = c__2768__auto__);

return statearr_74428;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__74472 = db;
var map__74472__$1 = cljs.core.__destructure_map.call(null,map__74472);
var conn = cljs.core.get.call(null,map__74472__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__74472__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__74472__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
if(((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_.call(null,new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,listen_id);

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_74479){
var state_val_74480 = (state_74479[(1)]);
if((state_val_74480 === (1))){
var inst_74473 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_74474 = fluree.db.session.db.call(null,conn,inst_74473,null);
var state_74479__$1 = state_74479;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74479__$1,(2),inst_74474);
} else {
if((state_val_74480 === (2))){
var inst_74476 = (state_74479[(2)]);
var inst_74477 = cljs.core.async.put_BANG_.call(null,resp_port,inst_74476);
var state_74479__$1 = state_74479;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74479__$1,inst_74477);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0 = (function (){
var statearr_74481 = [null,null,null,null,null,null,null];
(statearr_74481[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__);

(statearr_74481[(1)] = (1));

return statearr_74481;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1 = (function (state_74479){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_74479);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e74482){var ex__2749__auto__ = e74482;
var statearr_74483_74510 = state_74479;
(statearr_74483_74510[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_74479[(4)]))){
var statearr_74484_74511 = state_74479;
(statearr_74484_74511[(1)] = cljs.core.first.call(null,(state_74479[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74512 = state_74479;
state_74479 = G__74512;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__ = function(state_74479){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1.call(this,state_74479);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_74485 = f__2769__auto__.call(null);
(statearr_74485[(6)] = c__2768__auto__);

return statearr_74485;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener.call(null,conn,network,ledger_id,listen_id,event_fn);

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_74498){
var state_val_74499 = (state_74498[(1)]);
if((state_val_74499 === (1))){
var inst_74486 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_74487 = fluree.db.session.db.call(null,conn,inst_74486,null);
var state_74498__$1 = state_74498;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74498__$1,(2),inst_74487);
} else {
if((state_val_74499 === (2))){
var inst_74489 = (state_74498[(7)]);
var inst_74489__$1 = (state_74498[(2)]);
var inst_74490 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_74489__$1);
var inst_74491 = newer_block_QMARK_.call(null,inst_74490);
var state_74498__$1 = (function (){var statearr_74500 = state_74498;
(statearr_74500[(7)] = inst_74489__$1);

return statearr_74500;
})();
if(inst_74491){
var statearr_74501_74513 = state_74498__$1;
(statearr_74501_74513[(1)] = (3));

} else {
var statearr_74502_74514 = state_74498__$1;
(statearr_74502_74514[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74499 === (3))){
var inst_74489 = (state_74498[(7)]);
var inst_74493 = cljs.core.async.put_BANG_.call(null,resp_port,inst_74489);
var state_74498__$1 = state_74498;
var statearr_74503_74515 = state_74498__$1;
(statearr_74503_74515[(2)] = inst_74493);

(statearr_74503_74515[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74499 === (4))){
var state_74498__$1 = state_74498;
var statearr_74504_74516 = state_74498__$1;
(statearr_74504_74516[(2)] = null);

(statearr_74504_74516[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74499 === (5))){
var inst_74496 = (state_74498[(2)]);
var state_74498__$1 = state_74498;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74498__$1,inst_74496);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0 = (function (){
var statearr_74505 = [null,null,null,null,null,null,null,null];
(statearr_74505[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__);

(statearr_74505[(1)] = (1));

return statearr_74505;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1 = (function (state_74498){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_74498);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e74506){var ex__2749__auto__ = e74506;
var statearr_74507_74517 = state_74498;
(statearr_74507_74517[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_74498[(4)]))){
var statearr_74508_74518 = state_74498;
(statearr_74508_74518[(1)] = cljs.core.first.call(null,(state_74498[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74519 = state_74498;
state_74498 = G__74519;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__ = function(state_74498){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1.call(this,state_74498);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_74509 = f__2769__auto__.call(null);
(statearr_74509[(6)] = c__2768__auto__);

return statearr_74509;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_.call(null,syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.call(null);
var map__74520 = db;
var map__74520__$1 = cljs.core.__destructure_map.call(null,map__74520);
var conn = cljs.core.get.call(null,map__74520__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__74520__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__74520__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var listen_id = cljs.core.random_uuid.call(null);
var timeout = ((cljs.core.pos_int_QMARK_.call(null,syncTimeout))?(function (){var x__5133__auto__ = syncTimeout;
var y__5134__auto__ = (120000);
return ((x__5133__auto__ < y__5134__auto__) ? x__5133__auto__ : y__5134__auto__);
})():(60000));
var res_port = cljs.core.async.chan.call(null);
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.call(null,pc,db);
} else {
fluree.db.api.ledger.syncTo_wait.call(null,db,syncTo,listen_id,res_port);

var c__2768__auto___74596 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_74570){
var state_val_74571 = (state_74570[(1)]);
if((state_val_74571 === (7))){
var inst_74536 = (state_74570[(7)]);
var inst_74547 = cljs.core._EQ_.call(null,inst_74536,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_74570__$1 = state_74570;
if(inst_74547){
var statearr_74572_74597 = state_74570__$1;
(statearr_74572_74597[(1)] = (9));

} else {
var statearr_74573_74598 = state_74570__$1;
(statearr_74573_74598[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74571 === (1))){
var inst_74529 = (state_74570[(8)]);
var inst_74521 = (state_74570[(9)]);
var inst_74521__$1 = cljs.core.async.timeout.call(null,timeout);
var inst_74529__$1 = res_port;
var inst_74530 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74531 = [inst_74521__$1,inst_74529__$1];
var inst_74532 = (new cljs.core.PersistentVector(null,2,(5),inst_74530,inst_74531,null));
var state_74570__$1 = (function (){var statearr_74574 = state_74570;
(statearr_74574[(8)] = inst_74529__$1);

(statearr_74574[(9)] = inst_74521__$1);

return statearr_74574;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_74570__$1,(2),inst_74532);
} else {
if((state_val_74571 === (4))){
var inst_74529 = (state_74570[(8)]);
var inst_74536 = (state_74570[(7)]);
var inst_74540 = cljs.core._EQ_.call(null,inst_74536,inst_74529);
var state_74570__$1 = state_74570;
if(inst_74540){
var statearr_74575_74599 = state_74570__$1;
(statearr_74575_74599[(1)] = (6));

} else {
var statearr_74576_74600 = state_74570__$1;
(statearr_74576_74600[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74571 === (13))){
var inst_74555 = (state_74570[(10)]);
var inst_74566 = cljs.core.async.put_BANG_.call(null,pc,inst_74555);
var state_74570__$1 = state_74570;
var statearr_74577_74601 = state_74570__$1;
(statearr_74577_74601[(2)] = inst_74566);

(statearr_74577_74601[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74571 === (6))){
var inst_74534 = (state_74570[(11)]);
var inst_74545 = cljs.core.nth.call(null,inst_74534,(0),null);
var state_74570__$1 = state_74570;
var statearr_74578_74602 = state_74570__$1;
(statearr_74578_74602[(2)] = inst_74545);

(statearr_74578_74602[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74571 === (3))){
var state_74570__$1 = state_74570;
var statearr_74579_74603 = state_74570__$1;
(statearr_74579_74603[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_74579_74603[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74571 === (12))){
var inst_74559 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_74560 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74561 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_74562 = cljs.core.PersistentHashMap.fromArrays(inst_74560,inst_74561);
var inst_74563 = cljs.core.ex_info.call(null,inst_74559,inst_74562);
var inst_74564 = cljs.core.async.put_BANG_.call(null,pc,inst_74563);
var state_74570__$1 = state_74570;
var statearr_74580_74604 = state_74570__$1;
(statearr_74580_74604[(2)] = inst_74564);

(statearr_74580_74604[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74571 === (2))){
var inst_74536 = (state_74570[(7)]);
var inst_74521 = (state_74570[(9)]);
var inst_74534 = (state_74570[(11)]);
var inst_74534__$1 = (state_74570[(2)]);
var inst_74535 = cljs.core.nth.call(null,inst_74534__$1,(0),null);
var inst_74536__$1 = cljs.core.nth.call(null,inst_74534__$1,(1),null);
var inst_74537 = cljs.core._EQ_.call(null,inst_74536__$1,inst_74521);
var state_74570__$1 = (function (){var statearr_74581 = state_74570;
(statearr_74581[(12)] = inst_74535);

(statearr_74581[(7)] = inst_74536__$1);

(statearr_74581[(11)] = inst_74534__$1);

return statearr_74581;
})();
if(inst_74537){
var statearr_74582_74605 = state_74570__$1;
(statearr_74582_74605[(1)] = (3));

} else {
var statearr_74583_74606 = state_74570__$1;
(statearr_74583_74606[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74571 === (11))){
var inst_74551 = (state_74570[(2)]);
var state_74570__$1 = state_74570;
var statearr_74584_74607 = state_74570__$1;
(statearr_74584_74607[(2)] = inst_74551);

(statearr_74584_74607[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74571 === (9))){
var inst_74535 = (state_74570[(12)]);
var state_74570__$1 = state_74570;
var statearr_74585_74608 = state_74570__$1;
(statearr_74585_74608[(2)] = inst_74535);

(statearr_74585_74608[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74571 === (5))){
var inst_74555 = (state_74570[(10)]);
var inst_74555__$1 = (state_74570[(2)]);
var inst_74556 = fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,listen_id);
var inst_74557 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_74555__$1);
var state_74570__$1 = (function (){var statearr_74586 = state_74570;
(statearr_74586[(13)] = inst_74556);

(statearr_74586[(10)] = inst_74555__$1);

return statearr_74586;
})();
if(inst_74557){
var statearr_74587_74609 = state_74570__$1;
(statearr_74587_74609[(1)] = (12));

} else {
var statearr_74588_74610 = state_74570__$1;
(statearr_74588_74610[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74571 === (14))){
var inst_74568 = (state_74570[(2)]);
var state_74570__$1 = state_74570;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74570__$1,inst_74568);
} else {
if((state_val_74571 === (10))){
var state_74570__$1 = state_74570;
var statearr_74589_74611 = state_74570__$1;
(statearr_74589_74611[(2)] = null);

(statearr_74589_74611[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74571 === (8))){
var inst_74553 = (state_74570[(2)]);
var state_74570__$1 = state_74570;
var statearr_74590_74612 = state_74570__$1;
(statearr_74590_74612[(2)] = inst_74553);

(statearr_74590_74612[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____0 = (function (){
var statearr_74591 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74591[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__);

(statearr_74591[(1)] = (1));

return statearr_74591;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____1 = (function (state_74570){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_74570);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e74592){var ex__2749__auto__ = e74592;
var statearr_74593_74613 = state_74570;
(statearr_74593_74613[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_74570[(4)]))){
var statearr_74594_74614 = state_74570;
(statearr_74594_74614[(1)] = cljs.core.first.call(null,(state_74570[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74615 = state_74570;
state_74570 = G__74615;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__ = function(state_74570){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____1.call(this,state_74570);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_74595 = f__2769__auto__.call(null);
(statearr_74595[(6)] = c__2768__auto___74596);

return statearr_74595;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__74617 = arguments.length;
switch (G__74617) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__74618){
var map__74619 = p__74618;
var map__74619__$1 = cljs.core.__destructure_map.call(null,map__74619);
var opts = map__74619__$1;
var roles = cljs.core.get.call(null,map__74619__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.call(null,map__74619__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.call(null,map__74619__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.call(null,map__74619__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.call(null,map__74619__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.call(null);
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2768__auto___74708 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_74670){
var state_val_74671 = (state_74670[(1)]);
if((state_val_74671 === (7))){
var inst_74632 = (state_74670[(7)]);
var inst_74634 = fluree.db.api.ledger.syncTo_db.call(null,inst_74632,syncTo,syncTimeout);
var state_74670__$1 = state_74670;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74670__$1,(10),inst_74634);
} else {
if((state_val_74671 === (20))){
var inst_74656 = (state_74670[(8)]);
var state_74670__$1 = state_74670;
var statearr_74672_74709 = state_74670__$1;
(statearr_74672_74709[(2)] = inst_74656);

(statearr_74672_74709[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74671 === (1))){
var state_74670__$1 = state_74670;
var statearr_74673_74710 = state_74670__$1;
(statearr_74673_74710[(2)] = null);

(statearr_74673_74710[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74671 === (4))){
var inst_74620 = (state_74670[(2)]);
var inst_74621 = cljs.core.async.put_BANG_.call(null,pc,inst_74620);
var inst_74622 = cljs.core.async.close_BANG_.call(null,pc);
var state_74670__$1 = (function (){var statearr_74674 = state_74670;
(statearr_74674[(9)] = inst_74621);

return statearr_74674;
})();
var statearr_74675_74711 = state_74670__$1;
(statearr_74675_74711[(2)] = inst_74622);

(statearr_74675_74711[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74671 === (15))){
var inst_74648 = (state_74670[(10)]);
var inst_74650 = fluree.db.api.ledger.add_db_permissions.call(null,inst_74648,auth,roles);
var state_74670__$1 = state_74670;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74670__$1,(18),inst_74650);
} else {
if((state_val_74671 === (21))){
var inst_74664 = (state_74670[(2)]);
var inst_74665 = cljs.core.async.put_BANG_.call(null,pc,inst_74664);
var _ = (function (){var statearr_74676 = state_74670;
(statearr_74676[(4)] = cljs.core.rest.call(null,(state_74670[(4)])));

return statearr_74676;
})();
var state_74670__$1 = state_74670;
var statearr_74677_74712 = state_74670__$1;
(statearr_74677_74712[(2)] = inst_74665);

(statearr_74677_74712[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74671 === (13))){
var inst_74648 = (state_74670[(2)]);
var state_74670__$1 = (function (){var statearr_74678 = state_74670;
(statearr_74678[(10)] = inst_74648);

return statearr_74678;
})();
if(cljs.core.truth_(roles)){
var statearr_74679_74713 = state_74670__$1;
(statearr_74679_74713[(1)] = (15));

} else {
var statearr_74680_74714 = state_74670__$1;
(statearr_74680_74714[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74671 === (22))){
var inst_74660 = (state_74670[(2)]);
var inst_74661 = fluree.db.util.async.throw_err.call(null,inst_74660);
var state_74670__$1 = state_74670;
var statearr_74681_74715 = state_74670__$1;
(statearr_74681_74715[(2)] = inst_74661);

(statearr_74681_74715[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74671 === (6))){
var inst_74631 = (state_74670[(2)]);
var inst_74632 = fluree.db.util.async.throw_err.call(null,inst_74631);
var state_74670__$1 = (function (){var statearr_74682 = state_74670;
(statearr_74682[(7)] = inst_74632);

return statearr_74682;
})();
if(cljs.core.truth_(syncTo)){
var statearr_74683_74716 = state_74670__$1;
(statearr_74683_74716[(1)] = (7));

} else {
var statearr_74684_74717 = state_74670__$1;
(statearr_74684_74717[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74671 === (17))){
var inst_74656 = (state_74670[(2)]);
var state_74670__$1 = (function (){var statearr_74685 = state_74670;
(statearr_74685[(8)] = inst_74656);

return statearr_74685;
})();
if(cljs.core.truth_(auth)){
var statearr_74686_74718 = state_74670__$1;
(statearr_74686_74718[(1)] = (19));

} else {
var statearr_74687_74719 = state_74670__$1;
(statearr_74687_74719[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74671 === (3))){
var inst_74668 = (state_74670[(2)]);
var state_74670__$1 = state_74670;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74670__$1,inst_74668);
} else {
if((state_val_74671 === (12))){
var inst_74640 = (state_74670[(11)]);
var state_74670__$1 = state_74670;
var statearr_74688_74720 = state_74670__$1;
(statearr_74688_74720[(2)] = inst_74640);

(statearr_74688_74720[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74671 === (2))){
var _ = (function (){var statearr_74689 = state_74670;
(statearr_74689[(4)] = cljs.core.cons.call(null,(5),(state_74670[(4)])));

return statearr_74689;
})();
var inst_74629 = fluree.db.session.db.call(null,conn,ledger,opts_SINGLEQUOTE_);
var state_74670__$1 = state_74670;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74670__$1,(6),inst_74629);
} else {
if((state_val_74671 === (19))){
var inst_74656 = (state_74670[(8)]);
var inst_74658 = fluree.db.api.ledger.add_db_permissions.call(null,inst_74656,auth,roles);
var state_74670__$1 = state_74670;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74670__$1,(22),inst_74658);
} else {
if((state_val_74671 === (11))){
var inst_74640 = (state_74670[(11)]);
var inst_74642 = fluree.db.time_travel.as_of_block.call(null,inst_74640,block);
var state_74670__$1 = state_74670;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74670__$1,(14),inst_74642);
} else {
if((state_val_74671 === (9))){
var inst_74640 = (state_74670[(2)]);
var state_74670__$1 = (function (){var statearr_74691 = state_74670;
(statearr_74691[(11)] = inst_74640);

return statearr_74691;
})();
if(cljs.core.truth_(block)){
var statearr_74692_74721 = state_74670__$1;
(statearr_74692_74721[(1)] = (11));

} else {
var statearr_74693_74722 = state_74670__$1;
(statearr_74693_74722[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74671 === (5))){
var _ = (function (){var statearr_74694 = state_74670;
(statearr_74694[(4)] = cljs.core.rest.call(null,(state_74670[(4)])));

return statearr_74694;
})();
var state_74670__$1 = state_74670;
var ex74690 = (state_74670__$1[(2)]);
var statearr_74695_74723 = state_74670__$1;
(statearr_74695_74723[(5)] = ex74690);


var statearr_74696_74724 = state_74670__$1;
(statearr_74696_74724[(1)] = (4));

(statearr_74696_74724[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74671 === (14))){
var inst_74644 = (state_74670[(2)]);
var inst_74645 = fluree.db.util.async.throw_err.call(null,inst_74644);
var state_74670__$1 = state_74670;
var statearr_74697_74725 = state_74670__$1;
(statearr_74697_74725[(2)] = inst_74645);

(statearr_74697_74725[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74671 === (16))){
var inst_74648 = (state_74670[(10)]);
var state_74670__$1 = state_74670;
var statearr_74698_74726 = state_74670__$1;
(statearr_74698_74726[(2)] = inst_74648);

(statearr_74698_74726[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74671 === (10))){
var inst_74636 = (state_74670[(2)]);
var inst_74637 = fluree.db.util.async.throw_err.call(null,inst_74636);
var state_74670__$1 = state_74670;
var statearr_74699_74727 = state_74670__$1;
(statearr_74699_74727[(2)] = inst_74637);

(statearr_74699_74727[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74671 === (18))){
var inst_74652 = (state_74670[(2)]);
var inst_74653 = fluree.db.util.async.throw_err.call(null,inst_74652);
var state_74670__$1 = state_74670;
var statearr_74700_74728 = state_74670__$1;
(statearr_74700_74728[(2)] = inst_74653);

(statearr_74700_74728[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74671 === (8))){
var inst_74632 = (state_74670[(7)]);
var state_74670__$1 = state_74670;
var statearr_74701_74729 = state_74670__$1;
(statearr_74701_74729[(2)] = inst_74632);

(statearr_74701_74729[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2746__auto__ = null;
var fluree$db$api$ledger$state_machine__2746__auto____0 = (function (){
var statearr_74702 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74702[(0)] = fluree$db$api$ledger$state_machine__2746__auto__);

(statearr_74702[(1)] = (1));

return statearr_74702;
});
var fluree$db$api$ledger$state_machine__2746__auto____1 = (function (state_74670){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_74670);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e74703){var ex__2749__auto__ = e74703;
var statearr_74704_74730 = state_74670;
(statearr_74704_74730[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_74670[(4)]))){
var statearr_74705_74731 = state_74670;
(statearr_74705_74731[(1)] = cljs.core.first.call(null,(state_74670[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74732 = state_74670;
state_74670 = G__74732;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2746__auto__ = function(state_74670){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2746__auto____1.call(this,state_74670);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2746__auto____0;
fluree$db$api$ledger$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2746__auto____1;
return fluree$db$api$ledger$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_74706 = f__2769__auto__.call(null);
(statearr_74706[(6)] = c__2768__auto___74708);

return statearr_74706;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

