// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.fql_resp');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(ledger_id){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,ledger_id);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__65521 = arguments.length;
switch (G__65521) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___65669 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_65608){
var state_val_65609 = (state_65608[(1)]);
if((state_val_65609 === (7))){
var inst_65539 = (state_65608[(7)]);
var inst_65542 = cljs.core.not_EQ_.call(null,(0),inst_65539);
var state_65608__$1 = state_65608;
var statearr_65610_65670 = state_65608__$1;
(statearr_65610_65670[(2)] = inst_65542);

(statearr_65610_65670[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (20))){
var inst_65563 = (state_65608[(8)]);
var inst_65534 = (state_65608[(9)]);
var inst_65567 = fluree.db.auth.roles.call(null,inst_65534,inst_65563);
var state_65608__$1 = state_65608;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65608__$1,(23),inst_65567);
} else {
if((state_val_65609 === (27))){
var inst_65534 = (state_65608[(9)]);
var inst_65582 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_65583 = fluree.db.time_travel.as_of_block.call(null,inst_65534,inst_65582);
var state_65608__$1 = state_65608;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65608__$1,(30),inst_65583);
} else {
if((state_val_65609 === (1))){
var state_65608__$1 = state_65608;
var statearr_65611_65671 = state_65608__$1;
(statearr_65611_65671[(2)] = null);

(statearr_65611_65671[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (24))){
var inst_65575 = (state_65608[(10)]);
var inst_65534 = (state_65608[(9)]);
var inst_65577 = fluree.db.permissions.permission_map.call(null,inst_65534,inst_65575,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_65608__$1 = state_65608;
var statearr_65612_65672 = state_65608__$1;
(statearr_65612_65672[(2)] = inst_65577);

(statearr_65612_65672[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (4))){
var inst_65522 = (state_65608[(2)]);
var inst_65523 = cljs.core.async.put_BANG_.call(null,pc,inst_65522);
var inst_65524 = cljs.core.async.close_BANG_.call(null,pc);
var state_65608__$1 = (function (){var statearr_65613 = state_65608;
(statearr_65613[(11)] = inst_65523);

return statearr_65613;
})();
var statearr_65614_65673 = state_65608__$1;
(statearr_65614_65673[(2)] = inst_65524);

(statearr_65614_65673[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (15))){
var inst_65539 = (state_65608[(7)]);
var inst_65553 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65539)," unknown."].join('');
var inst_65554 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65555 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_65556 = cljs.core.PersistentHashMap.fromArrays(inst_65554,inst_65555);
var inst_65557 = cljs.core.ex_info.call(null,inst_65553,inst_65556);
var inst_65558 = (function(){throw inst_65557})();
var state_65608__$1 = state_65608;
var statearr_65615_65674 = state_65608__$1;
(statearr_65615_65674[(2)] = inst_65558);

(statearr_65615_65674[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (21))){
var state_65608__$1 = state_65608;
var statearr_65616_65675 = state_65608__$1;
(statearr_65616_65675[(2)] = null);

(statearr_65616_65675[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (31))){
var inst_65589 = (state_65608[(12)]);
var inst_65539 = (state_65608[(7)]);
var inst_65591 = cljs.core.assoc.call(null,inst_65589,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_65539);
var state_65608__$1 = state_65608;
var statearr_65617_65676 = state_65608__$1;
(statearr_65617_65676[(2)] = inst_65591);

(statearr_65617_65676[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (32))){
var inst_65589 = (state_65608[(12)]);
var state_65608__$1 = state_65608;
var statearr_65618_65677 = state_65608__$1;
(statearr_65618_65677[(2)] = inst_65589);

(statearr_65618_65677[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (33))){
var inst_65575 = (state_65608[(10)]);
var inst_65594 = (state_65608[(2)]);
var state_65608__$1 = (function (){var statearr_65619 = state_65608;
(statearr_65619[(13)] = inst_65594);

return statearr_65619;
})();
if(cljs.core.truth_(inst_65575)){
var statearr_65620_65678 = state_65608__$1;
(statearr_65620_65678[(1)] = (34));

} else {
var statearr_65621_65679 = state_65608__$1;
(statearr_65621_65679[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (13))){
var inst_65550 = (state_65608[(14)]);
var inst_65549 = (state_65608[(2)]);
var inst_65550__$1 = fluree.db.util.async.throw_err.call(null,inst_65549);
var state_65608__$1 = (function (){var statearr_65622 = state_65608;
(statearr_65622[(14)] = inst_65550__$1);

return statearr_65622;
})();
if(cljs.core.truth_(inst_65550__$1)){
var statearr_65623_65680 = state_65608__$1;
(statearr_65623_65680[(1)] = (14));

} else {
var statearr_65624_65681 = state_65608__$1;
(statearr_65624_65681[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (22))){
var inst_65573 = (state_65608[(2)]);
var state_65608__$1 = state_65608;
var statearr_65625_65682 = state_65608__$1;
(statearr_65625_65682[(2)] = inst_65573);

(statearr_65625_65682[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (36))){
var inst_65602 = (state_65608[(2)]);
var inst_65603 = cljs.core.async.put_BANG_.call(null,pc,inst_65602);
var _ = (function (){var statearr_65626 = state_65608;
(statearr_65626[(4)] = cljs.core.rest.call(null,(state_65608[(4)])));

return statearr_65626;
})();
var state_65608__$1 = state_65608;
var statearr_65627_65683 = state_65608__$1;
(statearr_65627_65683[(2)] = inst_65603);

(statearr_65627_65683[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (29))){
var inst_65539 = (state_65608[(7)]);
var inst_65589 = (state_65608[(2)]);
var state_65608__$1 = (function (){var statearr_65628 = state_65608;
(statearr_65628[(12)] = inst_65589);

return statearr_65628;
})();
if(cljs.core.truth_(inst_65539)){
var statearr_65629_65684 = state_65608__$1;
(statearr_65629_65684[(1)] = (31));

} else {
var statearr_65630_65685 = state_65608__$1;
(statearr_65630_65685[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (6))){
var inst_65539 = (state_65608[(7)]);
var inst_65533 = (state_65608[(2)]);
var inst_65534 = fluree.db.util.async.throw_err.call(null,inst_65533);
var inst_65535 = opts;
var inst_65536 = cljs.core.__destructure_map.call(null,inst_65535);
var inst_65537 = cljs.core.get.call(null,inst_65536,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_65538 = cljs.core.get.call(null,inst_65536,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_65539__$1 = cljs.core.get.call(null,inst_65536,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_65540 = cljs.core.get.call(null,inst_65536,new cljs.core.Keyword(null,"block","block",664686210));
var state_65608__$1 = (function (){var statearr_65631 = state_65608;
(statearr_65631[(15)] = inst_65537);

(statearr_65631[(16)] = inst_65538);

(statearr_65631[(9)] = inst_65534);

(statearr_65631[(7)] = inst_65539__$1);

(statearr_65631[(17)] = inst_65540);

return statearr_65631;
})();
if(cljs.core.truth_(inst_65539__$1)){
var statearr_65632_65686 = state_65608__$1;
(statearr_65632_65686[(1)] = (7));

} else {
var statearr_65633_65687 = state_65608__$1;
(statearr_65633_65687[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (28))){
var inst_65534 = (state_65608[(9)]);
var state_65608__$1 = state_65608;
var statearr_65634_65688 = state_65608__$1;
(statearr_65634_65688[(2)] = inst_65534);

(statearr_65634_65688[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (25))){
var state_65608__$1 = state_65608;
var statearr_65635_65689 = state_65608__$1;
(statearr_65635_65689[(2)] = null);

(statearr_65635_65689[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (34))){
var inst_65580 = (state_65608[(18)]);
var state_65608__$1 = state_65608;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65608__$1,(37),inst_65580);
} else {
if((state_val_65609 === (17))){
var inst_65537 = (state_65608[(15)]);
var state_65608__$1 = state_65608;
var statearr_65636_65690 = state_65608__$1;
(statearr_65636_65690[(2)] = inst_65537);

(statearr_65636_65690[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (3))){
var inst_65606 = (state_65608[(2)]);
var state_65608__$1 = state_65608;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65608__$1,inst_65606);
} else {
if((state_val_65609 === (12))){
var inst_65537 = (state_65608[(15)]);
var inst_65563 = (state_65608[(2)]);
var state_65608__$1 = (function (){var statearr_65637 = state_65608;
(statearr_65637[(8)] = inst_65563);

return statearr_65637;
})();
if(cljs.core.truth_(inst_65537)){
var statearr_65638_65691 = state_65608__$1;
(statearr_65638_65691[(1)] = (17));

} else {
var statearr_65639_65692 = state_65608__$1;
(statearr_65639_65692[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (2))){
var _ = (function (){var statearr_65640 = state_65608;
(statearr_65640[(4)] = cljs.core.cons.call(null,(5),(state_65608[(4)])));

return statearr_65640;
})();
var inst_65531 = fluree.db.session.db.call(null,conn,ledger,null);
var state_65608__$1 = state_65608;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65608__$1,(6),inst_65531);
} else {
if((state_val_65609 === (23))){
var inst_65569 = (state_65608[(2)]);
var inst_65570 = fluree.db.util.async.throw_err.call(null,inst_65569);
var state_65608__$1 = state_65608;
var statearr_65641_65693 = state_65608__$1;
(statearr_65641_65693[(2)] = inst_65570);

(statearr_65641_65693[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (35))){
var inst_65594 = (state_65608[(13)]);
var state_65608__$1 = state_65608;
var statearr_65642_65694 = state_65608__$1;
(statearr_65642_65694[(2)] = inst_65594);

(statearr_65642_65694[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (19))){
var inst_65575 = (state_65608[(10)]);
var inst_65575__$1 = (state_65608[(2)]);
var state_65608__$1 = (function (){var statearr_65643 = state_65608;
(statearr_65643[(10)] = inst_65575__$1);

return statearr_65643;
})();
if(cljs.core.truth_(inst_65575__$1)){
var statearr_65644_65695 = state_65608__$1;
(statearr_65644_65695[(1)] = (24));

} else {
var statearr_65645_65696 = state_65608__$1;
(statearr_65645_65696[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (11))){
var state_65608__$1 = state_65608;
var statearr_65647_65697 = state_65608__$1;
(statearr_65647_65697[(2)] = null);

(statearr_65647_65697[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (9))){
var inst_65545 = (state_65608[(2)]);
var state_65608__$1 = state_65608;
if(cljs.core.truth_(inst_65545)){
var statearr_65648_65698 = state_65608__$1;
(statearr_65648_65698[(1)] = (10));

} else {
var statearr_65649_65699 = state_65608__$1;
(statearr_65649_65699[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (5))){
var _ = (function (){var statearr_65650 = state_65608;
(statearr_65650[(4)] = cljs.core.rest.call(null,(state_65608[(4)])));

return statearr_65650;
})();
var state_65608__$1 = state_65608;
var ex65646 = (state_65608__$1[(2)]);
var statearr_65651_65700 = state_65608__$1;
(statearr_65651_65700[(5)] = ex65646);


var statearr_65652_65701 = state_65608__$1;
(statearr_65652_65701[(1)] = (4));

(statearr_65652_65701[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (14))){
var inst_65550 = (state_65608[(14)]);
var state_65608__$1 = state_65608;
var statearr_65653_65702 = state_65608__$1;
(statearr_65653_65702[(2)] = inst_65550);

(statearr_65653_65702[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (26))){
var inst_65540 = (state_65608[(17)]);
var inst_65580 = (state_65608[(2)]);
var state_65608__$1 = (function (){var statearr_65654 = state_65608;
(statearr_65654[(18)] = inst_65580);

return statearr_65654;
})();
if(cljs.core.truth_(inst_65540)){
var statearr_65655_65703 = state_65608__$1;
(statearr_65655_65703[(1)] = (27));

} else {
var statearr_65656_65704 = state_65608__$1;
(statearr_65656_65704[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (16))){
var inst_65560 = (state_65608[(2)]);
var state_65608__$1 = state_65608;
var statearr_65657_65705 = state_65608__$1;
(statearr_65657_65705[(2)] = inst_65560);

(statearr_65657_65705[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (30))){
var inst_65585 = (state_65608[(2)]);
var inst_65586 = fluree.db.util.async.throw_err.call(null,inst_65585);
var state_65608__$1 = state_65608;
var statearr_65658_65706 = state_65608__$1;
(statearr_65658_65706[(2)] = inst_65586);

(statearr_65658_65706[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (10))){
var inst_65534 = (state_65608[(9)]);
var inst_65539 = (state_65608[(7)]);
var inst_65547 = fluree.db.dbproto._subid.call(null,inst_65534,inst_65539);
var state_65608__$1 = state_65608;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65608__$1,(13),inst_65547);
} else {
if((state_val_65609 === (18))){
var inst_65563 = (state_65608[(8)]);
var state_65608__$1 = state_65608;
if(cljs.core.truth_(inst_65563)){
var statearr_65659_65707 = state_65608__$1;
(statearr_65659_65707[(1)] = (20));

} else {
var statearr_65660_65708 = state_65608__$1;
(statearr_65660_65708[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (37))){
var inst_65594 = (state_65608[(13)]);
var inst_65597 = (state_65608[(2)]);
var inst_65598 = fluree.db.util.async.throw_err.call(null,inst_65597);
var inst_65599 = cljs.core.assoc.call(null,inst_65594,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_65598);
var state_65608__$1 = state_65608;
var statearr_65661_65709 = state_65608__$1;
(statearr_65661_65709[(2)] = inst_65599);

(statearr_65661_65709[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65609 === (8))){
var inst_65539 = (state_65608[(7)]);
var state_65608__$1 = state_65608;
var statearr_65662_65710 = state_65608__$1;
(statearr_65662_65710[(2)] = inst_65539);

(statearr_65662_65710[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2746__auto__ = null;
var fluree$db$api$query$state_machine__2746__auto____0 = (function (){
var statearr_65663 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65663[(0)] = fluree$db$api$query$state_machine__2746__auto__);

(statearr_65663[(1)] = (1));

return statearr_65663;
});
var fluree$db$api$query$state_machine__2746__auto____1 = (function (state_65608){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_65608);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e65664){var ex__2749__auto__ = e65664;
var statearr_65665_65711 = state_65608;
(statearr_65665_65711[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_65608[(4)]))){
var statearr_65666_65712 = state_65608;
(statearr_65666_65712[(1)] = cljs.core.first.call(null,(state_65608[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65713 = state_65608;
state_65608 = G__65713;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2746__auto__ = function(state_65608){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2746__auto____1.call(this,state_65608);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2746__auto____0;
fluree$db$api$query$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2746__auto____1;
return fluree$db$api$query$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_65667 = f__2769__auto__.call(null);
(statearr_65667[(6)] = c__2768__auto___65669);

return statearr_65667;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_.call(null,val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.call(null,conn,ledger,opts);
return cljs.core.assoc.call(null,acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_65854){
var state_val_65855 = (state_65854[(1)]);
if((state_val_65855 === (7))){
var inst_65734 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65735 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_65736 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_65737 = [inst_65735,inst_65736];
var inst_65738 = (new cljs.core.PersistentVector(null,2,(5),inst_65734,inst_65737,null));
var state_65854__$1 = state_65854;
var statearr_65856_65926 = state_65854__$1;
(statearr_65856_65926[(2)] = inst_65738);

(statearr_65856_65926[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (20))){
var inst_65764 = (state_65854[(7)]);
var state_65854__$1 = state_65854;
var statearr_65857_65927 = state_65854__$1;
(statearr_65857_65927[(2)] = inst_65764);

(statearr_65857_65927[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (27))){
var state_65854__$1 = state_65854;
var statearr_65858_65928 = state_65854__$1;
(statearr_65858_65928[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (1))){
var state_65854__$1 = state_65854;
var statearr_65860_65929 = state_65854__$1;
(statearr_65860_65929[(2)] = null);

(statearr_65860_65929[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (24))){
var inst_65763 = (state_65854[(8)]);
var state_65854__$1 = state_65854;
if(cljs.core.truth_(inst_65763)){
var statearr_65861_65930 = state_65854__$1;
(statearr_65861_65930[(1)] = (26));

} else {
var statearr_65862_65931 = state_65854__$1;
(statearr_65862_65931[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (39))){
var inst_65810 = (state_65854[(9)]);
var inst_65809 = (state_65854[(10)]);
var inst_65835 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65836 = [inst_65809,inst_65810];
var inst_65837 = (new cljs.core.PersistentVector(null,2,(5),inst_65835,inst_65836,null));
var state_65854__$1 = state_65854;
var statearr_65863_65932 = state_65854__$1;
(statearr_65863_65932[(2)] = inst_65837);

(statearr_65863_65932[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (4))){
var inst_65714 = (state_65854[(2)]);
var state_65854__$1 = state_65854;
var statearr_65864_65933 = state_65854__$1;
(statearr_65864_65933[(2)] = inst_65714);

(statearr_65864_65933[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (15))){
var inst_65748 = (state_65854[(11)]);
var inst_65743 = (state_65854[(12)]);
var inst_65757 = (state_65854[(2)]);
var inst_65758 = [inst_65748,inst_65757];
var inst_65759 = (new cljs.core.PersistentVector(null,2,(5),inst_65743,inst_65758,null));
var state_65854__$1 = state_65854;
var statearr_65865_65934 = state_65854__$1;
(statearr_65865_65934[(2)] = inst_65759);

(statearr_65865_65934[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (21))){
var inst_65763 = (state_65854[(8)]);
var state_65854__$1 = state_65854;
var statearr_65866_65935 = state_65854__$1;
(statearr_65866_65935[(2)] = inst_65763);

(statearr_65866_65935[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (31))){
var inst_65804 = (state_65854[(2)]);
var state_65854__$1 = state_65854;
var statearr_65867_65936 = state_65854__$1;
(statearr_65867_65936[(2)] = inst_65804);

(statearr_65867_65936[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (32))){
var inst_65810 = (state_65854[(9)]);
var inst_65813 = cljs.core.pos_int_QMARK_.call(null,inst_65810);
var state_65854__$1 = state_65854;
var statearr_65868_65937 = state_65854__$1;
(statearr_65868_65937[(2)] = inst_65813);

(statearr_65868_65937[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (40))){
var inst_65765 = (state_65854[(13)]);
var inst_65841 = (state_65854[(14)]);
var inst_65839 = (state_65854[(2)]);
var inst_65840 = cljs.core.nth.call(null,inst_65839,(0),null);
var inst_65841__$1 = cljs.core.nth.call(null,inst_65839,(1),null);
var inst_65842 = (inst_65841__$1 > inst_65765);
var state_65854__$1 = (function (){var statearr_65869 = state_65854;
(statearr_65869[(15)] = inst_65840);

(statearr_65869[(14)] = inst_65841__$1);

return statearr_65869;
})();
if(cljs.core.truth_(inst_65842)){
var statearr_65870_65938 = state_65854__$1;
(statearr_65870_65938[(1)] = (41));

} else {
var statearr_65871_65939 = state_65854__$1;
(statearr_65871_65939[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (33))){
var inst_65811 = (state_65854[(16)]);
var state_65854__$1 = state_65854;
var statearr_65872_65940 = state_65854__$1;
(statearr_65872_65940[(2)] = inst_65811);

(statearr_65872_65940[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (13))){
var inst_65749 = (state_65854[(17)]);
var inst_65751 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_65749);
var state_65854__$1 = state_65854;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65854__$1,(16),inst_65751);
} else {
if((state_val_65855 === (22))){
var inst_65782 = (state_65854[(2)]);
var state_65854__$1 = state_65854;
if(cljs.core.truth_(inst_65782)){
var statearr_65873_65941 = state_65854__$1;
(statearr_65873_65941[(1)] = (23));

} else {
var statearr_65874_65942 = state_65854__$1;
(statearr_65874_65942[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (36))){
var state_65854__$1 = state_65854;
var statearr_65875_65943 = state_65854__$1;
(statearr_65875_65943[(2)] = null);

(statearr_65875_65943[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (41))){
var inst_65765 = (state_65854[(13)]);
var state_65854__$1 = state_65854;
var statearr_65876_65944 = state_65854__$1;
(statearr_65876_65944[(2)] = inst_65765);

(statearr_65876_65944[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (43))){
var inst_65840 = (state_65854[(15)]);
var inst_65846 = (state_65854[(2)]);
var inst_65847 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65848 = [inst_65840,inst_65846];
var inst_65849 = (new cljs.core.PersistentVector(null,2,(5),inst_65847,inst_65848,null));
var _ = (function (){var statearr_65877 = state_65854;
(statearr_65877[(4)] = cljs.core.rest.call(null,(state_65854[(4)])));

return statearr_65877;
})();
var state_65854__$1 = state_65854;
var statearr_65878_65945 = state_65854__$1;
(statearr_65878_65945[(2)] = inst_65849);

(statearr_65878_65945[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (29))){
var inst_65740 = (state_65854[(18)]);
var inst_65795 = cljs.core.pr_str.call(null,inst_65740);
var inst_65796 = ["Invalid block range provided: ",inst_65795].join('');
var inst_65797 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65798 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65799 = cljs.core.PersistentHashMap.fromArrays(inst_65797,inst_65798);
var inst_65800 = cljs.core.ex_info.call(null,inst_65796,inst_65799);
var inst_65801 = (function(){throw inst_65800})();
var state_65854__$1 = state_65854;
var statearr_65879_65946 = state_65854__$1;
(statearr_65879_65946[(2)] = inst_65801);

(statearr_65879_65946[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (6))){
var inst_65732 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_65854__$1 = state_65854;
var statearr_65880_65947 = state_65854__$1;
(statearr_65880_65947[(2)] = inst_65732);

(statearr_65880_65947[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (28))){
var inst_65806 = (state_65854[(2)]);
var state_65854__$1 = state_65854;
var statearr_65881_65948 = state_65854__$1;
(statearr_65881_65948[(2)] = inst_65806);

(statearr_65881_65948[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (25))){
var inst_65811 = (state_65854[(16)]);
var inst_65809 = (state_65854[(10)]);
var inst_65808 = (state_65854[(2)]);
var inst_65809__$1 = cljs.core.nth.call(null,inst_65808,(0),null);
var inst_65810 = cljs.core.nth.call(null,inst_65808,(1),null);
var inst_65811__$1 = cljs.core.pos_int_QMARK_.call(null,inst_65809__$1);
var state_65854__$1 = (function (){var statearr_65882 = state_65854;
(statearr_65882[(9)] = inst_65810);

(statearr_65882[(16)] = inst_65811__$1);

(statearr_65882[(10)] = inst_65809__$1);

return statearr_65882;
})();
if(inst_65811__$1){
var statearr_65883_65949 = state_65854__$1;
(statearr_65883_65949[(1)] = (32));

} else {
var statearr_65884_65950 = state_65854__$1;
(statearr_65884_65950[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (34))){
var inst_65816 = (state_65854[(2)]);
var inst_65817 = cljs.core.not.call(null,inst_65816);
var state_65854__$1 = state_65854;
if(inst_65817){
var statearr_65885_65951 = state_65854__$1;
(statearr_65885_65951[(1)] = (35));

} else {
var statearr_65886_65952 = state_65854__$1;
(statearr_65886_65952[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (17))){
var inst_65765 = (state_65854[(13)]);
var inst_65763 = (state_65854[(8)]);
var inst_65768 = cljs.core.pr_str.call(null,inst_65763);
var inst_65769 = cljs.core.pr_str.call(null,inst_65765);
var inst_65770 = ["Start block is out of range for this ledger. Start block provided: ",inst_65768,". Database block: ",inst_65769].join('');
var inst_65771 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65772 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65773 = cljs.core.PersistentHashMap.fromArrays(inst_65771,inst_65772);
var inst_65774 = cljs.core.ex_info.call(null,inst_65770,inst_65773);
var inst_65775 = (function(){throw inst_65774})();
var state_65854__$1 = state_65854;
var statearr_65887_65953 = state_65854__$1;
(statearr_65887_65953[(2)] = inst_65775);

(statearr_65887_65953[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (3))){
var inst_65852 = (state_65854[(2)]);
var state_65854__$1 = state_65854;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65854__$1,inst_65852);
} else {
if((state_val_65855 === (12))){
var inst_65749 = (state_65854[(17)]);
var inst_65740 = (state_65854[(18)]);
var inst_65747 = (state_65854[(2)]);
var inst_65748 = fluree.db.util.async.throw_err.call(null,inst_65747);
var inst_65749__$1 = cljs.core.second.call(null,inst_65740);
var state_65854__$1 = (function (){var statearr_65888 = state_65854;
(statearr_65888[(17)] = inst_65749__$1);

(statearr_65888[(11)] = inst_65748);

return statearr_65888;
})();
if(cljs.core.truth_(inst_65749__$1)){
var statearr_65889_65954 = state_65854__$1;
(statearr_65889_65954[(1)] = (13));

} else {
var statearr_65890_65955 = state_65854__$1;
(statearr_65890_65955[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (2))){
var _ = (function (){var statearr_65891 = state_65854;
(statearr_65891[(4)] = cljs.core.cons.call(null,(5),(state_65854[(4)])));

return statearr_65891;
})();
var inst_65729 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_65730 = cljs.core.sequential_QMARK_.call(null,inst_65729);
var state_65854__$1 = state_65854;
if(inst_65730){
var statearr_65892_65956 = state_65854__$1;
(statearr_65892_65956[(1)] = (6));

} else {
var statearr_65893_65957 = state_65854__$1;
(statearr_65893_65957[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (23))){
var inst_65764 = (state_65854[(7)]);
var inst_65763 = (state_65854[(8)]);
var inst_65784 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65785 = [inst_65763,inst_65764];
var inst_65786 = (new cljs.core.PersistentVector(null,2,(5),inst_65784,inst_65785,null));
var state_65854__$1 = state_65854;
var statearr_65894_65958 = state_65854__$1;
(statearr_65894_65958[(2)] = inst_65786);

(statearr_65894_65958[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (35))){
var inst_65740 = (state_65854[(18)]);
var inst_65819 = cljs.core.pr_str.call(null,inst_65740);
var inst_65820 = ["Invalid block range provided: ",inst_65819].join('');
var inst_65821 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65822 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65823 = cljs.core.PersistentHashMap.fromArrays(inst_65821,inst_65822);
var inst_65824 = cljs.core.ex_info.call(null,inst_65820,inst_65823);
var inst_65825 = (function(){throw inst_65824})();
var state_65854__$1 = state_65854;
var statearr_65895_65959 = state_65854__$1;
(statearr_65895_65959[(2)] = inst_65825);

(statearr_65895_65959[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (19))){
var inst_65763 = (state_65854[(8)]);
var inst_65778 = (state_65854[(2)]);
var state_65854__$1 = (function (){var statearr_65896 = state_65854;
(statearr_65896[(19)] = inst_65778);

return statearr_65896;
})();
if(cljs.core.truth_(inst_65763)){
var statearr_65897_65960 = state_65854__$1;
(statearr_65897_65960[(1)] = (20));

} else {
var statearr_65898_65961 = state_65854__$1;
(statearr_65898_65961[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (11))){
var inst_65765 = (state_65854[(13)]);
var inst_65763 = (state_65854[(8)]);
var inst_65762 = (state_65854[(2)]);
var inst_65763__$1 = cljs.core.nth.call(null,inst_65762,(0),null);
var inst_65764 = cljs.core.nth.call(null,inst_65762,(1),null);
var inst_65765__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_65766 = (inst_65763__$1 > inst_65765__$1);
var state_65854__$1 = (function (){var statearr_65900 = state_65854;
(statearr_65900[(7)] = inst_65764);

(statearr_65900[(13)] = inst_65765__$1);

(statearr_65900[(8)] = inst_65763__$1);

return statearr_65900;
})();
if(cljs.core.truth_(inst_65766)){
var statearr_65901_65962 = state_65854__$1;
(statearr_65901_65962[(1)] = (17));

} else {
var statearr_65902_65963 = state_65854__$1;
(statearr_65902_65963[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (9))){
var inst_65740 = (state_65854[(18)]);
var inst_65743 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65744 = cljs.core.first.call(null,inst_65740);
var inst_65745 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_65744);
var state_65854__$1 = (function (){var statearr_65903 = state_65854;
(statearr_65903[(12)] = inst_65743);

return statearr_65903;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65854__$1,(12),inst_65745);
} else {
if((state_val_65855 === (5))){
var _ = (function (){var statearr_65904 = state_65854;
(statearr_65904[(4)] = cljs.core.rest.call(null,(state_65854[(4)])));

return statearr_65904;
})();
var state_65854__$1 = state_65854;
var ex65899 = (state_65854__$1[(2)]);
var statearr_65905_65964 = state_65854__$1;
(statearr_65905_65964[(5)] = ex65899);


if((ex65899 instanceof Error)){
var statearr_65906_65965 = state_65854__$1;
(statearr_65906_65965[(1)] = (4));

(statearr_65906_65965[(5)] = null);

} else {
throw ex65899;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (14))){
var state_65854__$1 = state_65854;
var statearr_65907_65966 = state_65854__$1;
(statearr_65907_65966[(2)] = null);

(statearr_65907_65966[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (26))){
var inst_65763 = (state_65854[(8)]);
var inst_65789 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65790 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_65791 = [inst_65763,inst_65790];
var inst_65792 = (new cljs.core.PersistentVector(null,2,(5),inst_65789,inst_65791,null));
var state_65854__$1 = state_65854;
var statearr_65908_65967 = state_65854__$1;
(statearr_65908_65967[(2)] = inst_65792);

(statearr_65908_65967[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (16))){
var inst_65753 = (state_65854[(2)]);
var inst_65754 = fluree.db.util.async.throw_err.call(null,inst_65753);
var state_65854__$1 = state_65854;
var statearr_65909_65968 = state_65854__$1;
(statearr_65909_65968[(2)] = inst_65754);

(statearr_65909_65968[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (38))){
var inst_65810 = (state_65854[(9)]);
var inst_65809 = (state_65854[(10)]);
var inst_65831 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65832 = [inst_65810,inst_65809];
var inst_65833 = (new cljs.core.PersistentVector(null,2,(5),inst_65831,inst_65832,null));
var state_65854__$1 = state_65854;
var statearr_65910_65969 = state_65854__$1;
(statearr_65910_65969[(2)] = inst_65833);

(statearr_65910_65969[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (30))){
var state_65854__$1 = state_65854;
var statearr_65911_65970 = state_65854__$1;
(statearr_65911_65970[(2)] = null);

(statearr_65911_65970[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (10))){
var inst_65740 = (state_65854[(18)]);
var state_65854__$1 = state_65854;
var statearr_65912_65971 = state_65854__$1;
(statearr_65912_65971[(2)] = inst_65740);

(statearr_65912_65971[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (18))){
var state_65854__$1 = state_65854;
var statearr_65913_65972 = state_65854__$1;
(statearr_65913_65972[(2)] = null);

(statearr_65913_65972[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (42))){
var inst_65841 = (state_65854[(14)]);
var state_65854__$1 = state_65854;
var statearr_65914_65973 = state_65854__$1;
(statearr_65914_65973[(2)] = inst_65841);

(statearr_65914_65973[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (37))){
var inst_65810 = (state_65854[(9)]);
var inst_65809 = (state_65854[(10)]);
var inst_65828 = (state_65854[(2)]);
var inst_65829 = (inst_65810 < inst_65809);
var state_65854__$1 = (function (){var statearr_65915 = state_65854;
(statearr_65915[(20)] = inst_65828);

return statearr_65915;
})();
if(cljs.core.truth_(inst_65829)){
var statearr_65916_65974 = state_65854__$1;
(statearr_65916_65974[(1)] = (38));

} else {
var statearr_65917_65975 = state_65854__$1;
(statearr_65917_65975[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65855 === (8))){
var inst_65740 = (state_65854[(18)]);
var inst_65740__$1 = (state_65854[(2)]);
var inst_65741 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_65740__$1);
var state_65854__$1 = (function (){var statearr_65918 = state_65854;
(statearr_65918[(18)] = inst_65740__$1);

return statearr_65918;
})();
if(cljs.core.truth_(inst_65741)){
var statearr_65919_65976 = state_65854__$1;
(statearr_65919_65976[(1)] = (9));

} else {
var statearr_65920_65977 = state_65854__$1;
(statearr_65920_65977[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____0 = (function (){
var statearr_65921 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65921[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__);

(statearr_65921[(1)] = (1));

return statearr_65921;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____1 = (function (state_65854){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_65854);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e65922){var ex__2749__auto__ = e65922;
var statearr_65923_65978 = state_65854;
(statearr_65923_65978[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_65854[(4)]))){
var statearr_65924_65979 = state_65854;
(statearr_65924_65979[(1)] = cljs.core.first.call(null,(state_65854[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65980 = state_65854;
state_65854 = G__65980;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__ = function(state_65854){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____1.call(this,state_65854);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_65925 = f__2769__auto__.call(null);
(statearr_65925[(6)] = c__2768__auto__);

return statearr_65925;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_66130){
var state_val_66131 = (state_66130[(1)]);
if((state_val_66131 === (7))){
var inst_66042 = (state_66130[(2)]);
var inst_66043 = cljs.core.nth.call(null,inst_66042,(0),null);
var inst_66044 = cljs.core.nth.call(null,inst_66042,(1),null);
var inst_66052 = cljs.core.vals.call(null,inst_66044);
var inst_66053 = cljs.core.seq.call(null,inst_66052);
var inst_66054 = cljs.core.first.call(null,inst_66053);
var inst_66055 = cljs.core.next.call(null,inst_66053);
var inst_66056 = cljs.core.PersistentVector.EMPTY;
var inst_66057 = inst_66052;
var inst_66058 = inst_66056;
var state_66130__$1 = (function (){var statearr_66132 = state_66130;
(statearr_66132[(7)] = inst_66058);

(statearr_66132[(8)] = inst_66054);

(statearr_66132[(9)] = inst_66043);

(statearr_66132[(10)] = inst_66055);

(statearr_66132[(11)] = inst_66057);

return statearr_66132;
})();
var statearr_66133_66186 = state_66130__$1;
(statearr_66133_66186[(2)] = null);

(statearr_66133_66186[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66131 === (20))){
var inst_66064 = (state_66130[(12)]);
var inst_66069 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_66070 = cljs.core.PersistentHashMap.EMPTY;
var inst_66071 = [true,inst_66070];
var inst_66072 = cljs.core.PersistentHashMap.fromArrays(inst_66069,inst_66071);
var inst_66073 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_66072,inst_66064);
var state_66130__$1 = state_66130;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66130__$1,(22),inst_66073);
} else {
if((state_val_66131 === (27))){
var inst_66118 = (state_66130[(2)]);
var state_66130__$1 = state_66130;
var statearr_66134_66187 = state_66130__$1;
(statearr_66134_66187[(2)] = inst_66118);

(statearr_66134_66187[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66131 === (1))){
var state_66130__$1 = state_66130;
var statearr_66135_66188 = state_66130__$1;
(statearr_66135_66188[(2)] = null);

(statearr_66135_66188[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66131 === (24))){
var inst_66082 = (state_66130[(13)]);
var inst_66120 = (state_66130[(2)]);
var inst_66121 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_66122 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_66123 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_66124 = [inst_66122,inst_66123,inst_66082,inst_66120];
var inst_66125 = cljs.core.PersistentHashMap.fromArrays(inst_66121,inst_66124);
var _ = (function (){var statearr_66137 = state_66130;
(statearr_66137[(4)] = cljs.core.rest.call(null,(state_66130[(4)])));

return statearr_66137;
})();
var state_66130__$1 = state_66130;
var statearr_66138_66189 = state_66130__$1;
(statearr_66138_66189[(2)] = inst_66125);

(statearr_66138_66189[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66131 === (4))){
var inst_65983 = (state_66130[(2)]);
var state_66130__$1 = state_66130;
var statearr_66139_66190 = state_66130__$1;
(statearr_66139_66190[(2)] = inst_65983);

(statearr_66139_66190[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66131 === (15))){
var inst_66023 = (state_66130[(14)]);
var inst_66006 = (state_66130[(15)]);
var inst_66028 = (state_66130[(16)]);
var inst_66014 = (state_66130[(17)]);
var inst_66002 = (state_66130[(18)]);
var inst_66013 = (state_66130[(19)]);
var inst_66001 = (state_66130[(20)]);
var inst_66005 = (state_66130[(21)]);
var inst_66021 = (state_66130[(22)]);
var inst_65999 = (state_66130[(23)]);
var inst_66007 = (state_66130[(24)]);
var inst_66034 = (function (){var subject = inst_66021;
var flake = inst_66013;
var vec__65996 = inst_65999;
var first__66011 = inst_66013;
var seq__66010 = inst_66014;
var r = inst_66014;
var seq__65997 = inst_66002;
var vec__66009 = inst_66005;
var asserted_subjects = inst_66006;
var flake_SINGLEQUOTE_ = inst_66028;
var retracted_subjects = inst_66007;
var first__65998 = inst_66001;
var G__65995 = inst_66005;
var asserted_QMARK_ = inst_66023;
return (function (p1__65982_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__65982_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_66035 = cljs.core.update.call(null,inst_66007,inst_66021,inst_66034);
var tmp66136 = inst_66006;
var inst_66005__$1 = inst_66014;
var inst_66006__$1 = tmp66136;
var inst_66007__$1 = inst_66035;
var state_66130__$1 = (function (){var statearr_66140 = state_66130;
(statearr_66140[(15)] = inst_66006__$1);

(statearr_66140[(21)] = inst_66005__$1);

(statearr_66140[(24)] = inst_66007__$1);

return statearr_66140;
})();
var statearr_66141_66191 = state_66130__$1;
(statearr_66141_66191[(2)] = null);

(statearr_66141_66191[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66131 === (21))){
var inst_66080 = (state_66130[(2)]);
var state_66130__$1 = state_66130;
var statearr_66142_66192 = state_66130__$1;
(statearr_66142_66192[(2)] = inst_66080);

(statearr_66142_66192[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66131 === (13))){
var inst_66023 = (state_66130[(14)]);
var inst_66028 = (state_66130[(2)]);
var state_66130__$1 = (function (){var statearr_66143 = state_66130;
(statearr_66143[(16)] = inst_66028);

return statearr_66143;
})();
if(cljs.core.truth_(inst_66023)){
var statearr_66144_66193 = state_66130__$1;
(statearr_66144_66193[(1)] = (14));

} else {
var statearr_66145_66194 = state_66130__$1;
(statearr_66145_66194[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66131 === (22))){
var inst_66058 = (state_66130[(7)]);
var inst_66065 = (state_66130[(25)]);
var inst_66075 = (state_66130[(2)]);
var inst_66076 = fluree.db.util.async.throw_err.call(null,inst_66075);
var inst_66077 = cljs.core.conj.call(null,inst_66058,inst_66076);
var inst_66057 = inst_66065;
var inst_66058__$1 = inst_66077;
var state_66130__$1 = (function (){var statearr_66146 = state_66130;
(statearr_66146[(7)] = inst_66058__$1);

(statearr_66146[(11)] = inst_66057);

return statearr_66146;
})();
var statearr_66147_66195 = state_66130__$1;
(statearr_66147_66195[(2)] = null);

(statearr_66147_66195[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66131 === (6))){
var inst_66013 = (state_66130[(19)]);
var inst_66005 = (state_66130[(21)]);
var inst_66012 = cljs.core.seq.call(null,inst_66005);
var inst_66013__$1 = cljs.core.first.call(null,inst_66012);
var inst_66014 = cljs.core.next.call(null,inst_66012);
var inst_66015 = cljs.core.not.call(null,inst_66013__$1);
var state_66130__$1 = (function (){var statearr_66148 = state_66130;
(statearr_66148[(17)] = inst_66014);

(statearr_66148[(19)] = inst_66013__$1);

return statearr_66148;
})();
if(inst_66015){
var statearr_66149_66196 = state_66130__$1;
(statearr_66149_66196[(1)] = (8));

} else {
var statearr_66150_66197 = state_66130__$1;
(statearr_66150_66197[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66131 === (28))){
var inst_66096 = (state_66130[(26)]);
var inst_66103 = (state_66130[(27)]);
var inst_66113 = (state_66130[(2)]);
var inst_66114 = fluree.db.util.async.throw_err.call(null,inst_66113);
var inst_66115 = cljs.core.conj.call(null,inst_66096,inst_66114);
var inst_66095 = inst_66103;
var inst_66096__$1 = inst_66115;
var state_66130__$1 = (function (){var statearr_66151 = state_66130;
(statearr_66151[(28)] = inst_66095);

(statearr_66151[(26)] = inst_66096__$1);

return statearr_66151;
})();
var statearr_66152_66198 = state_66130__$1;
(statearr_66152_66198[(2)] = null);

(statearr_66152_66198[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66131 === (25))){
var inst_66096 = (state_66130[(26)]);
var state_66130__$1 = state_66130;
var statearr_66153_66199 = state_66130__$1;
(statearr_66153_66199[(2)] = inst_66096);

(statearr_66153_66199[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66131 === (17))){
var inst_66064 = (state_66130[(12)]);
var inst_66057 = (state_66130[(11)]);
var inst_66063 = cljs.core.seq.call(null,inst_66057);
var inst_66064__$1 = cljs.core.first.call(null,inst_66063);
var inst_66065 = cljs.core.next.call(null,inst_66063);
var inst_66066 = cljs.core.not.call(null,inst_66064__$1);
var state_66130__$1 = (function (){var statearr_66154 = state_66130;
(statearr_66154[(25)] = inst_66065);

(statearr_66154[(12)] = inst_66064__$1);

return statearr_66154;
})();
if(inst_66066){
var statearr_66155_66200 = state_66130__$1;
(statearr_66155_66200[(1)] = (19));

} else {
var statearr_66156_66201 = state_66130__$1;
(statearr_66156_66201[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66131 === (3))){
var inst_66128 = (state_66130[(2)]);
var state_66130__$1 = state_66130;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66130__$1,inst_66128);
} else {
if((state_val_66131 === (12))){
var inst_66013 = (state_66130[(19)]);
var inst_66026 = fluree.db.flake.flip_flake.call(null,inst_66013);
var state_66130__$1 = state_66130;
var statearr_66157_66202 = state_66130__$1;
(statearr_66157_66202[(2)] = inst_66026);

(statearr_66157_66202[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66131 === (2))){
var inst_65999 = (state_66130[(23)]);
var _ = (function (){var statearr_66158 = state_66130;
(statearr_66158[(4)] = cljs.core.cons.call(null,(5),(state_66130[(4)])));

return statearr_66158;
})();
var inst_65999__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_66000 = cljs.core.seq.call(null,inst_65999__$1);
var inst_66001 = cljs.core.first.call(null,inst_66000);
var inst_66002 = cljs.core.next.call(null,inst_66000);
var inst_66003 = cljs.core.PersistentHashMap.EMPTY;
var inst_66004 = cljs.core.PersistentHashMap.EMPTY;
var inst_66005 = inst_65999__$1;
var inst_66006 = inst_66003;
var inst_66007 = inst_66004;
var state_66130__$1 = (function (){var statearr_66159 = state_66130;
(statearr_66159[(15)] = inst_66006);

(statearr_66159[(18)] = inst_66002);

(statearr_66159[(20)] = inst_66001);

(statearr_66159[(21)] = inst_66005);

(statearr_66159[(23)] = inst_65999__$1);

(statearr_66159[(24)] = inst_66007);

return statearr_66159;
})();
var statearr_66160_66203 = state_66130__$1;
(statearr_66160_66203[(2)] = null);

(statearr_66160_66203[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66131 === (23))){
var inst_66095 = (state_66130[(28)]);
var inst_66102 = (state_66130[(29)]);
var inst_66101 = cljs.core.seq.call(null,inst_66095);
var inst_66102__$1 = cljs.core.first.call(null,inst_66101);
var inst_66103 = cljs.core.next.call(null,inst_66101);
var inst_66104 = cljs.core.not.call(null,inst_66102__$1);
var state_66130__$1 = (function (){var statearr_66161 = state_66130;
(statearr_66161[(27)] = inst_66103);

(statearr_66161[(29)] = inst_66102__$1);

return statearr_66161;
})();
if(inst_66104){
var statearr_66162_66204 = state_66130__$1;
(statearr_66162_66204[(1)] = (25));

} else {
var statearr_66163_66205 = state_66130__$1;
(statearr_66163_66205[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66131 === (19))){
var inst_66058 = (state_66130[(7)]);
var state_66130__$1 = state_66130;
var statearr_66164_66206 = state_66130__$1;
(statearr_66164_66206[(2)] = inst_66058);

(statearr_66164_66206[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66131 === (11))){
var inst_66013 = (state_66130[(19)]);
var state_66130__$1 = state_66130;
var statearr_66166_66207 = state_66130__$1;
(statearr_66166_66207[(2)] = inst_66013);

(statearr_66166_66207[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66131 === (9))){
var inst_66023 = (state_66130[(14)]);
var inst_66013 = (state_66130[(19)]);
var inst_66021 = fluree.db.flake.s.call(null,inst_66013);
var inst_66022 = fluree.db.flake.op.call(null,inst_66013);
var inst_66023__$1 = inst_66022 === true;
var state_66130__$1 = (function (){var statearr_66168 = state_66130;
(statearr_66168[(14)] = inst_66023__$1);

(statearr_66168[(22)] = inst_66021);

return statearr_66168;
})();
if(cljs.core.truth_(inst_66023__$1)){
var statearr_66169_66208 = state_66130__$1;
(statearr_66169_66208[(1)] = (11));

} else {
var statearr_66170_66209 = state_66130__$1;
(statearr_66170_66209[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66131 === (5))){
var _ = (function (){var statearr_66171 = state_66130;
(statearr_66171[(4)] = cljs.core.rest.call(null,(state_66130[(4)])));

return statearr_66171;
})();
var state_66130__$1 = state_66130;
var ex66165 = (state_66130__$1[(2)]);
var statearr_66172_66210 = state_66130__$1;
(statearr_66172_66210[(5)] = ex66165);


if((ex66165 instanceof Error)){
var statearr_66173_66211 = state_66130__$1;
(statearr_66173_66211[(1)] = (4));

(statearr_66173_66211[(5)] = null);

} else {
throw ex66165;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66131 === (14))){
var inst_66023 = (state_66130[(14)]);
var inst_66006 = (state_66130[(15)]);
var inst_66028 = (state_66130[(16)]);
var inst_66014 = (state_66130[(17)]);
var inst_66002 = (state_66130[(18)]);
var inst_66013 = (state_66130[(19)]);
var inst_66001 = (state_66130[(20)]);
var inst_66005 = (state_66130[(21)]);
var inst_66021 = (state_66130[(22)]);
var inst_65999 = (state_66130[(23)]);
var inst_66007 = (state_66130[(24)]);
var inst_66030 = (function (){var subject = inst_66021;
var flake = inst_66013;
var vec__65996 = inst_65999;
var first__66011 = inst_66013;
var seq__66010 = inst_66014;
var r = inst_66014;
var seq__65997 = inst_66002;
var vec__66009 = inst_66005;
var asserted_subjects = inst_66006;
var flake_SINGLEQUOTE_ = inst_66028;
var retracted_subjects = inst_66007;
var first__65998 = inst_66001;
var G__65995 = inst_66005;
var asserted_QMARK_ = inst_66023;
return (function (p1__65981_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__65981_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_66031 = cljs.core.update.call(null,inst_66006,inst_66021,inst_66030);
var tmp66167 = inst_66007;
var inst_66005__$1 = inst_66014;
var inst_66006__$1 = inst_66031;
var inst_66007__$1 = tmp66167;
var state_66130__$1 = (function (){var statearr_66174 = state_66130;
(statearr_66174[(15)] = inst_66006__$1);

(statearr_66174[(21)] = inst_66005__$1);

(statearr_66174[(24)] = inst_66007__$1);

return statearr_66174;
})();
var statearr_66175_66212 = state_66130__$1;
(statearr_66175_66212[(2)] = null);

(statearr_66175_66212[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66131 === (26))){
var inst_66102 = (state_66130[(29)]);
var inst_66107 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_66108 = cljs.core.PersistentHashMap.EMPTY;
var inst_66109 = [true,inst_66108];
var inst_66110 = cljs.core.PersistentHashMap.fromArrays(inst_66107,inst_66109);
var inst_66111 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_66110,inst_66102);
var state_66130__$1 = state_66130;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66130__$1,(28),inst_66111);
} else {
if((state_val_66131 === (16))){
var inst_66038 = (state_66130[(2)]);
var state_66130__$1 = state_66130;
var statearr_66176_66213 = state_66130__$1;
(statearr_66176_66213[(2)] = inst_66038);

(statearr_66176_66213[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66131 === (10))){
var inst_66040 = (state_66130[(2)]);
var state_66130__$1 = state_66130;
var statearr_66177_66214 = state_66130__$1;
(statearr_66177_66214[(2)] = inst_66040);

(statearr_66177_66214[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66131 === (18))){
var inst_66043 = (state_66130[(9)]);
var inst_66082 = (state_66130[(2)]);
var inst_66090 = cljs.core.vals.call(null,inst_66043);
var inst_66091 = cljs.core.seq.call(null,inst_66090);
var inst_66092 = cljs.core.first.call(null,inst_66091);
var inst_66093 = cljs.core.next.call(null,inst_66091);
var inst_66094 = cljs.core.PersistentVector.EMPTY;
var inst_66095 = inst_66090;
var inst_66096 = inst_66094;
var state_66130__$1 = (function (){var statearr_66178 = state_66130;
(statearr_66178[(28)] = inst_66095);

(statearr_66178[(26)] = inst_66096);

(statearr_66178[(30)] = inst_66092);

(statearr_66178[(13)] = inst_66082);

(statearr_66178[(31)] = inst_66093);

return statearr_66178;
})();
var statearr_66179_66215 = state_66130__$1;
(statearr_66179_66215[(2)] = null);

(statearr_66179_66215[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66131 === (8))){
var inst_66006 = (state_66130[(15)]);
var inst_66007 = (state_66130[(24)]);
var inst_66017 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66018 = [inst_66006,inst_66007];
var inst_66019 = (new cljs.core.PersistentVector(null,2,(5),inst_66017,inst_66018,null));
var state_66130__$1 = state_66130;
var statearr_66180_66216 = state_66130__$1;
(statearr_66180_66216[(2)] = inst_66019);

(statearr_66180_66216[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____0 = (function (){
var statearr_66181 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66181[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__);

(statearr_66181[(1)] = (1));

return statearr_66181;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____1 = (function (state_66130){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_66130);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e66182){var ex__2749__auto__ = e66182;
var statearr_66183_66217 = state_66130;
(statearr_66183_66217[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_66130[(4)]))){
var statearr_66184_66218 = state_66130;
(statearr_66184_66218[(1)] = cljs.core.first.call(null,(state_66130[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66219 = state_66130;
state_66130 = G__66219;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__ = function(state_66130){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____1.call(this,state_66130);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_66185 = f__2769__auto__.call(null);
(statearr_66185[(6)] = c__2768__auto__);

return statearr_66185;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_66251){
var state_val_66252 = (state_66251[(1)]);
if((state_val_66252 === (1))){
var inst_66220 = cljs.core.volatile_BANG_.call(null,(0));
var inst_66221 = cljs.core.PersistentHashMap.EMPTY;
var inst_66222 = cljs.core.volatile_BANG_.call(null,inst_66221);
var inst_66223 = cljs.core.first.call(null,resp);
var inst_66224 = cljs.core.rest.call(null,resp);
var inst_66225 = cljs.core.PersistentVector.EMPTY;
var inst_66226 = inst_66220;
var inst_66227 = inst_66222;
var inst_66228 = inst_66223;
var inst_66229 = inst_66224;
var inst_66230 = inst_66225;
var state_66251__$1 = (function (){var statearr_66253 = state_66251;
(statearr_66253[(7)] = inst_66230);

(statearr_66253[(8)] = inst_66228);

(statearr_66253[(9)] = inst_66226);

(statearr_66253[(10)] = inst_66227);

(statearr_66253[(11)] = inst_66229);

return statearr_66253;
})();
var statearr_66254_66269 = state_66251__$1;
(statearr_66254_66269[(2)] = null);

(statearr_66254_66269[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66252 === (2))){
var inst_66228 = (state_66251[(8)]);
var inst_66226 = (state_66251[(9)]);
var inst_66227 = (state_66251[(10)]);
var inst_66232 = fluree.db.api.query.format_block_resp_pretty.call(null,db,inst_66228,inst_66227,inst_66226);
var state_66251__$1 = state_66251;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66251__$1,(4),inst_66232);
} else {
if((state_val_66252 === (3))){
var inst_66249 = (state_66251[(2)]);
var state_66251__$1 = state_66251;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66251__$1,inst_66249);
} else {
if((state_val_66252 === (4))){
var inst_66230 = (state_66251[(7)]);
var inst_66229 = (state_66251[(11)]);
var inst_66234 = (state_66251[(2)]);
var inst_66235 = fluree.db.util.async.throw_err.call(null,inst_66234);
var inst_66236 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66237 = [inst_66235];
var inst_66238 = (new cljs.core.PersistentVector(null,1,(5),inst_66236,inst_66237,null));
var inst_66239 = cljs.core.concat.call(null,inst_66230,inst_66238);
var inst_66240 = cljs.core.first.call(null,inst_66229);
var state_66251__$1 = (function (){var statearr_66257 = state_66251;
(statearr_66257[(12)] = inst_66239);

return statearr_66257;
})();
if(cljs.core.truth_(inst_66240)){
var statearr_66258_66270 = state_66251__$1;
(statearr_66258_66270[(1)] = (5));

} else {
var statearr_66259_66271 = state_66251__$1;
(statearr_66259_66271[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66252 === (5))){
var inst_66226 = (state_66251[(9)]);
var inst_66227 = (state_66251[(10)]);
var inst_66229 = (state_66251[(11)]);
var inst_66239 = (state_66251[(12)]);
var inst_66242 = cljs.core.first.call(null,inst_66229);
var inst_66243 = cljs.core.rest.call(null,inst_66229);
var tmp66255 = inst_66226;
var tmp66256 = inst_66227;
var inst_66226__$1 = tmp66255;
var inst_66227__$1 = tmp66256;
var inst_66228 = inst_66242;
var inst_66229__$1 = inst_66243;
var inst_66230 = inst_66239;
var state_66251__$1 = (function (){var statearr_66260 = state_66251;
(statearr_66260[(7)] = inst_66230);

(statearr_66260[(8)] = inst_66228);

(statearr_66260[(9)] = inst_66226__$1);

(statearr_66260[(10)] = inst_66227__$1);

(statearr_66260[(11)] = inst_66229__$1);

return statearr_66260;
})();
var statearr_66261_66272 = state_66251__$1;
(statearr_66261_66272[(2)] = null);

(statearr_66261_66272[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66252 === (6))){
var inst_66239 = (state_66251[(12)]);
var state_66251__$1 = state_66251;
var statearr_66262_66273 = state_66251__$1;
(statearr_66262_66273[(2)] = inst_66239);

(statearr_66262_66273[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66252 === (7))){
var inst_66247 = (state_66251[(2)]);
var state_66251__$1 = state_66251;
var statearr_66263_66274 = state_66251__$1;
(statearr_66263_66274[(2)] = inst_66247);

(statearr_66263_66274[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____0 = (function (){
var statearr_66264 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66264[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__);

(statearr_66264[(1)] = (1));

return statearr_66264;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____1 = (function (state_66251){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_66251);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e66265){var ex__2749__auto__ = e66265;
var statearr_66266_66275 = state_66251;
(statearr_66266_66275[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_66251[(4)]))){
var statearr_66267_66276 = state_66251;
(statearr_66267_66276[(1)] = cljs.core.first.call(null,(state_66251[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66277 = state_66251;
state_66251 = G__66277;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__ = function(state_66251){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____1.call(this,state_66251);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_66268 = f__2769__auto__.call(null);
(statearr_66268[(6)] = c__2768__auto__);

return statearr_66268;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__66279 = arguments.length;
switch (G__66279) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.call(null,db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.call(null,db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range.call(null,db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__66281){
var map__66282 = p__66281;
var map__66282__$1 = cljs.core.__destructure_map.call(null,map__66282);
var query = map__66282__$1;
var opts = cljs.core.get.call(null,map__66282__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_66367){
var state_val_66368 = (state_66367[(1)]);
if((state_val_66368 === (7))){
var inst_66293 = (state_66367[(7)]);
var inst_66297 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66298 = ["_auth/id",inst_66293];
var inst_66299 = (new cljs.core.PersistentVector(null,2,(5),inst_66297,inst_66298,null));
var state_66367__$1 = state_66367;
var statearr_66369_66413 = state_66367__$1;
(statearr_66369_66413[(2)] = inst_66299);

(statearr_66369_66413[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66368 === (20))){
var inst_66347 = (state_66367[(2)]);
var inst_66348 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_66367__$1 = (function (){var statearr_66370 = state_66367;
(statearr_66370[(8)] = inst_66347);

return statearr_66370;
})();
if(cljs.core.truth_(inst_66348)){
var statearr_66371_66414 = state_66367__$1;
(statearr_66371_66414[(1)] = (22));

} else {
var statearr_66372_66415 = state_66367__$1;
(statearr_66372_66415[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66368 === (27))){
var inst_66350 = (state_66367[(9)]);
var inst_66294 = (state_66367[(10)]);
var inst_66356 = (state_66367[(2)]);
var inst_66357 = fluree.db.util.core.response_time_formatted.call(null,inst_66294);
var inst_66358 = [(200),inst_66356,(100),inst_66357];
var inst_66359 = cljs.core.PersistentHashMap.fromArrays(inst_66350,inst_66358);
var state_66367__$1 = state_66367;
var statearr_66373_66416 = state_66367__$1;
(statearr_66373_66416[(2)] = inst_66359);

(statearr_66373_66416[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66368 === (1))){
var state_66367__$1 = state_66367;
var statearr_66374_66417 = state_66367__$1;
(statearr_66374_66417[(2)] = null);

(statearr_66374_66417[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66368 === (24))){
var inst_66362 = (state_66367[(2)]);
var _ = (function (){var statearr_66375 = state_66367;
(statearr_66375[(4)] = cljs.core.rest.call(null,(state_66367[(4)])));

return statearr_66375;
})();
var state_66367__$1 = state_66367;
var statearr_66376_66418 = state_66367__$1;
(statearr_66376_66418[(2)] = inst_66362);

(statearr_66376_66418[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66368 === (4))){
var inst_66283 = (state_66367[(2)]);
var state_66367__$1 = state_66367;
var statearr_66377_66419 = state_66367__$1;
(statearr_66377_66419[(2)] = inst_66283);

(statearr_66377_66419[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66368 === (15))){
var inst_66334 = (state_66367[(11)]);
var state_66367__$1 = state_66367;
var statearr_66378_66420 = state_66367__$1;
(statearr_66378_66420[(2)] = inst_66334);

(statearr_66378_66420[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66368 === (21))){
var inst_66343 = (state_66367[(2)]);
var inst_66344 = fluree.db.util.async.throw_err.call(null,inst_66343);
var state_66367__$1 = state_66367;
var statearr_66379_66421 = state_66367__$1;
(statearr_66379_66421[(2)] = inst_66344);

(statearr_66379_66421[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66368 === (13))){
var inst_66292 = (state_66367[(12)]);
var inst_66334 = (state_66367[(11)]);
var inst_66333 = (state_66367[(2)]);
var inst_66334__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_66292);
var state_66367__$1 = (function (){var statearr_66380 = state_66367;
(statearr_66380[(13)] = inst_66333);

(statearr_66380[(11)] = inst_66334__$1);

return statearr_66380;
})();
if(cljs.core.truth_(inst_66334__$1)){
var statearr_66381_66422 = state_66367__$1;
(statearr_66381_66422[(1)] = (15));

} else {
var statearr_66382_66423 = state_66367__$1;
(statearr_66382_66423[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66368 === (22))){
var inst_66347 = (state_66367[(8)]);
var inst_66350 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_66351 = cljs.core.sequential_QMARK_.call(null,inst_66347);
var state_66367__$1 = (function (){var statearr_66383 = state_66367;
(statearr_66383[(9)] = inst_66350);

return statearr_66383;
})();
if(inst_66351){
var statearr_66384_66424 = state_66367__$1;
(statearr_66384_66424[(1)] = (25));

} else {
var statearr_66385_66425 = state_66367__$1;
(statearr_66385_66425[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66368 === (6))){
var inst_66292 = (state_66367[(12)]);
var inst_66308 = (state_66367[(14)]);
var inst_66307 = (state_66367[(2)]);
var inst_66308__$1 = fluree.db.util.async.throw_err.call(null,inst_66307);
var inst_66309 = fluree.db.api.query.resolve_block_range.call(null,inst_66308__$1,inst_66292);
var state_66367__$1 = (function (){var statearr_66386 = state_66367;
(statearr_66386[(14)] = inst_66308__$1);

return statearr_66386;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66367__$1,(10),inst_66309);
} else {
if((state_val_66368 === (25))){
var inst_66347 = (state_66367[(8)]);
var inst_66353 = cljs.core.doall.call(null,inst_66347);
var state_66367__$1 = state_66367;
var statearr_66387_66426 = state_66367__$1;
(statearr_66387_66426[(2)] = inst_66353);

(statearr_66387_66426[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66368 === (17))){
var inst_66339 = (state_66367[(2)]);
var state_66367__$1 = state_66367;
if(cljs.core.truth_(inst_66339)){
var statearr_66388_66427 = state_66367__$1;
(statearr_66388_66427[(1)] = (18));

} else {
var statearr_66389_66428 = state_66367__$1;
(statearr_66389_66428[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66368 === (3))){
var inst_66365 = (state_66367[(2)]);
var state_66367__$1 = state_66367;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66367__$1,inst_66365);
} else {
if((state_val_66368 === (12))){
var inst_66292 = (state_66367[(12)]);
var inst_66325 = cljs.core.pr_str.call(null,inst_66292);
var inst_66326 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_66325].join('');
var inst_66327 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66328 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_66329 = cljs.core.PersistentHashMap.fromArrays(inst_66327,inst_66328);
var inst_66330 = cljs.core.ex_info.call(null,inst_66326,inst_66329);
var inst_66331 = (function(){throw inst_66330})();
var state_66367__$1 = state_66367;
var statearr_66390_66429 = state_66367__$1;
(statearr_66390_66429[(2)] = inst_66331);

(statearr_66390_66429[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66368 === (2))){
var inst_66293 = (state_66367[(7)]);
var _ = (function (){var statearr_66391 = state_66367;
(statearr_66391[(4)] = cljs.core.cons.call(null,(5),(state_66367[(4)])));

return statearr_66391;
})();
var inst_66292 = cljs.core.dissoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_66293__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_66294 = fluree.db.util.core.current_time_millis.call(null);
var inst_66295 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_66367__$1 = (function (){var statearr_66392 = state_66367;
(statearr_66392[(15)] = inst_66295);

(statearr_66392[(12)] = inst_66292);

(statearr_66392[(7)] = inst_66293__$1);

(statearr_66392[(10)] = inst_66294);

return statearr_66392;
})();
if(cljs.core.truth_(inst_66293__$1)){
var statearr_66393_66430 = state_66367__$1;
(statearr_66393_66430[(1)] = (7));

} else {
var statearr_66394_66431 = state_66367__$1;
(statearr_66394_66431[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66368 === (23))){
var inst_66347 = (state_66367[(8)]);
var state_66367__$1 = state_66367;
var statearr_66395_66432 = state_66367__$1;
(statearr_66395_66432[(2)] = inst_66347);

(statearr_66395_66432[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66368 === (19))){
var inst_66333 = (state_66367[(13)]);
var state_66367__$1 = state_66367;
var statearr_66396_66433 = state_66367__$1;
(statearr_66396_66433[(2)] = inst_66333);

(statearr_66396_66433[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66368 === (11))){
var inst_66314 = (state_66367[(16)]);
var inst_66313 = (state_66367[(17)]);
var inst_66308 = (state_66367[(14)]);
var inst_66320 = fluree.db.api.query.block_range.call(null,inst_66308,inst_66313,inst_66314,opts);
var state_66367__$1 = state_66367;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66367__$1,(14),inst_66320);
} else {
if((state_val_66368 === (9))){
var inst_66295 = (state_66367[(15)]);
var inst_66302 = (state_66367[(2)]);
var inst_66303 = [inst_66302];
var inst_66304 = cljs.core.PersistentHashMap.fromArrays(inst_66295,inst_66303);
var inst_66305 = fluree.db.api.query.db.call(null,conn,ledger,inst_66304);
var state_66367__$1 = state_66367;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66367__$1,(6),inst_66305);
} else {
if((state_val_66368 === (5))){
var _ = (function (){var statearr_66398 = state_66367;
(statearr_66398[(4)] = cljs.core.rest.call(null,(state_66367[(4)])));

return statearr_66398;
})();
var state_66367__$1 = state_66367;
var ex66397 = (state_66367__$1[(2)]);
var statearr_66399_66434 = state_66367__$1;
(statearr_66399_66434[(5)] = ex66397);


if((ex66397 instanceof Error)){
var statearr_66400_66435 = state_66367__$1;
(statearr_66400_66435[(1)] = (4));

(statearr_66400_66435[(5)] = null);

} else {
throw ex66397;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66368 === (14))){
var inst_66322 = (state_66367[(2)]);
var inst_66323 = fluree.db.util.async.throw_err.call(null,inst_66322);
var state_66367__$1 = state_66367;
var statearr_66401_66436 = state_66367__$1;
(statearr_66401_66436[(2)] = inst_66323);

(statearr_66401_66436[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66368 === (26))){
var inst_66347 = (state_66367[(8)]);
var state_66367__$1 = state_66367;
var statearr_66402_66437 = state_66367__$1;
(statearr_66402_66437[(2)] = inst_66347);

(statearr_66402_66437[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66368 === (16))){
var inst_66292 = (state_66367[(12)]);
var inst_66337 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_66292);
var state_66367__$1 = state_66367;
var statearr_66403_66438 = state_66367__$1;
(statearr_66403_66438[(2)] = inst_66337);

(statearr_66403_66438[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66368 === (10))){
var inst_66292 = (state_66367[(12)]);
var inst_66311 = (state_66367[(2)]);
var inst_66312 = fluree.db.util.async.throw_err.call(null,inst_66311);
var inst_66313 = cljs.core.nth.call(null,inst_66312,(0),null);
var inst_66314 = cljs.core.nth.call(null,inst_66312,(1),null);
var inst_66315 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_66316 = cljs.core.dissoc.call(null,inst_66292,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_66317 = cljs.core.keys.call(null,inst_66316);
var inst_66318 = cljs.core._EQ_.call(null,inst_66315,inst_66317);
var state_66367__$1 = (function (){var statearr_66404 = state_66367;
(statearr_66404[(16)] = inst_66314);

(statearr_66404[(17)] = inst_66313);

return statearr_66404;
})();
if(inst_66318){
var statearr_66405_66439 = state_66367__$1;
(statearr_66405_66439[(1)] = (11));

} else {
var statearr_66406_66440 = state_66367__$1;
(statearr_66406_66440[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66368 === (18))){
var inst_66333 = (state_66367[(13)]);
var inst_66308 = (state_66367[(14)]);
var inst_66341 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_66308,inst_66333);
var state_66367__$1 = state_66367;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66367__$1,(21),inst_66341);
} else {
if((state_val_66368 === (8))){
var state_66367__$1 = state_66367;
var statearr_66407_66441 = state_66367__$1;
(statearr_66407_66441[(2)] = null);

(statearr_66407_66441[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2746__auto____0 = (function (){
var statearr_66408 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66408[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2746__auto__);

(statearr_66408[(1)] = (1));

return statearr_66408;
});
var fluree$db$api$query$block_query_async_$_state_machine__2746__auto____1 = (function (state_66367){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_66367);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e66409){var ex__2749__auto__ = e66409;
var statearr_66410_66442 = state_66367;
(statearr_66410_66442[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_66367[(4)]))){
var statearr_66411_66443 = state_66367;
(statearr_66411_66443[(1)] = cljs.core.first.call(null,(state_66367[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66444 = state_66367;
state_66367 = G__66444;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2746__auto__ = function(state_66367){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2746__auto____1.call(this,state_66367);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2746__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2746__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_66412 = f__2769__auto__.call(null);
(statearr_66412[(6)] = c__2768__auto__);

return statearr_66412;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_.call(null,history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_.call(null,history))?((cljs.core.empty_QMARK_.call(null,history))?(function(){throw cljs.core.ex_info.call(null,["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__66445 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.call(null,subject,(0)),cljs.core.get.call(null,subject,(1)),cljs.core.get.call(null,subject,(2)),cljs.core.get.call(null,subject,(3))], null);
var s = cljs.core.nth.call(null,vec__66445,(0),null);
var p = cljs.core.nth.call(null,vec__66445,(1),null);
var o = cljs.core.nth.call(null,vec__66445,(2),null);
var t = cljs.core.nth.call(null,vec__66445,(3),null);
var vec__66448 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.call(null,vec__66448,(0),null);
var idx = cljs.core.nth.call(null,vec__66448,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__66451 = cljs.core.get_in.call(null,t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.t.call(null,flake),new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.call(null,vec__66451,(0),null);
var id = cljs.core.nth.call(null,vec__66451,(1),null);
var or__5045__auto__ = auth_set.call(null,auth);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return auth_set.call(null,id);
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__5775__auto__ = [];
var len__5769__auto___66455 = arguments.length;
var i__5770__auto___66456 = (0);
while(true){
if((i__5770__auto___66456 < len__5769__auto___66455)){
args__5775__auto__.push((arguments[i__5770__auto___66456]));

var G__66457 = (i__5770__auto___66456 + (1));
i__5770__auto___66456 = G__66457;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq66454){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66454));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_66653){
var state_val_66654 = (state_66653[(1)]);
if((state_val_66654 === (7))){
var inst_66580 = (state_66653[(7)]);
var inst_66573 = (state_66653[(8)]);
var inst_66579 = cljs.core.seq.call(null,inst_66573);
var inst_66580__$1 = cljs.core.first.call(null,inst_66579);
var inst_66581 = cljs.core.next.call(null,inst_66579);
var state_66653__$1 = (function (){var statearr_66655 = state_66653;
(statearr_66655[(7)] = inst_66580__$1);

(statearr_66655[(9)] = inst_66581);

return statearr_66655;
})();
if(cljs.core.truth_(inst_66580__$1)){
var statearr_66656_66756 = state_66653__$1;
(statearr_66656_66756[(1)] = (9));

} else {
var statearr_66657_66757 = state_66653__$1;
(statearr_66657_66757[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (20))){
var inst_66643 = (state_66653[(2)]);
var state_66653__$1 = state_66653;
var statearr_66658_66758 = state_66653__$1;
(statearr_66658_66758[(2)] = inst_66643);

(statearr_66658_66758[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (27))){
var inst_66601 = (state_66653[(10)]);
var inst_66598 = (state_66653[(11)]);
var inst_66619 = (state_66653[(12)]);
var inst_66621 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66622 = [inst_66601,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_66623 = (new cljs.core.PersistentVector(null,2,(5),inst_66621,inst_66622,null));
var inst_66624 = cljs.core.update_in.call(null,inst_66619,inst_66623,fluree.db.api.query.min_safe,inst_66598);
var state_66653__$1 = state_66653;
var statearr_66659_66759 = state_66653__$1;
(statearr_66659_66759[(2)] = inst_66624);

(statearr_66659_66759[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (1))){
var state_66653__$1 = state_66653;
var statearr_66660_66760 = state_66653__$1;
(statearr_66660_66760[(2)] = null);

(statearr_66660_66760[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (24))){
var inst_66601 = (state_66653[(10)]);
var inst_66580 = (state_66653[(7)]);
var inst_66611 = (state_66653[(13)]);
var inst_66613 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66614 = [inst_66601,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_66615 = (new cljs.core.PersistentVector(null,2,(5),inst_66613,inst_66614,null));
var inst_66616 = cljs.core.update_in.call(null,inst_66611,inst_66615,cljs.core.conj,inst_66580);
var state_66653__$1 = state_66653;
var statearr_66662_66761 = state_66653__$1;
(statearr_66662_66761[(2)] = inst_66616);

(statearr_66662_66761[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (4))){
var inst_66459 = (state_66653[(2)]);
var state_66653__$1 = state_66653;
var statearr_66663_66762 = state_66653__$1;
(statearr_66663_66762[(2)] = inst_66459);

(statearr_66663_66762[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (15))){
var inst_66574 = (state_66653[(14)]);
var inst_66581 = (state_66653[(9)]);
var tmp66661 = inst_66574;
var inst_66573 = inst_66581;
var inst_66574__$1 = tmp66661;
var state_66653__$1 = (function (){var statearr_66664 = state_66653;
(statearr_66664[(14)] = inst_66574__$1);

(statearr_66664[(8)] = inst_66573);

return statearr_66664;
})();
var statearr_66665_66763 = state_66653__$1;
(statearr_66665_66763[(2)] = null);

(statearr_66665_66763[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (21))){
var inst_66574 = (state_66653[(14)]);
var inst_66601 = (state_66653[(10)]);
var inst_66605 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66606 = [inst_66601,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_66607 = (new cljs.core.PersistentVector(null,2,(5),inst_66605,inst_66606,null));
var inst_66608 = cljs.core.assoc_in.call(null,inst_66574,inst_66607,inst_66601);
var state_66653__$1 = state_66653;
var statearr_66666_66764 = state_66653__$1;
(statearr_66666_66764[(2)] = inst_66608);

(statearr_66666_66764[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (31))){
var inst_66627 = (state_66653[(15)]);
var state_66653__$1 = state_66653;
var statearr_66667_66765 = state_66653__$1;
(statearr_66667_66765[(2)] = inst_66627);

(statearr_66667_66765[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (32))){
var inst_66581 = (state_66653[(9)]);
var inst_66635 = (state_66653[(2)]);
var inst_66573 = inst_66581;
var inst_66574 = inst_66635;
var state_66653__$1 = (function (){var statearr_66668 = state_66653;
(statearr_66668[(14)] = inst_66574);

(statearr_66668[(8)] = inst_66573);

return statearr_66668;
})();
var statearr_66669_66766 = state_66653__$1;
(statearr_66669_66766[(2)] = null);

(statearr_66669_66766[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (33))){
var inst_66574 = (state_66653[(14)]);
var state_66653__$1 = state_66653;
var statearr_66670_66767 = state_66653__$1;
(statearr_66670_66767[(2)] = inst_66574);

(statearr_66670_66767[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (13))){
var inst_66583 = (state_66653[(16)]);
var state_66653__$1 = state_66653;
var statearr_66671_66768 = state_66653__$1;
(statearr_66671_66768[(2)] = inst_66583);

(statearr_66671_66768[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (22))){
var inst_66574 = (state_66653[(14)]);
var state_66653__$1 = state_66653;
var statearr_66672_66769 = state_66653__$1;
(statearr_66672_66769[(2)] = inst_66574);

(statearr_66672_66769[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (29))){
var inst_66627 = (state_66653[(2)]);
var state_66653__$1 = (function (){var statearr_66673 = state_66653;
(statearr_66673[(15)] = inst_66627);

return statearr_66673;
})();
if(cljs.core.truth_(show_auth)){
var statearr_66674_66770 = state_66653__$1;
(statearr_66674_66770[(1)] = (30));

} else {
var statearr_66675_66771 = state_66653__$1;
(statearr_66675_66771[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (6))){
var inst_66559 = (state_66653[(2)]);
var inst_66560 = fluree.db.util.async.throw_err.call(null,inst_66559);
var inst_66568 = resp;
var inst_66569 = cljs.core.seq.call(null,inst_66568);
var inst_66570 = cljs.core.first.call(null,inst_66569);
var inst_66571 = cljs.core.next.call(null,inst_66569);
var inst_66572 = cljs.core.PersistentHashMap.EMPTY;
var inst_66573 = inst_66568;
var inst_66574 = inst_66572;
var state_66653__$1 = (function (){var statearr_66676 = state_66653;
(statearr_66676[(17)] = inst_66571);

(statearr_66676[(18)] = inst_66570);

(statearr_66676[(14)] = inst_66574);

(statearr_66676[(19)] = inst_66560);

(statearr_66676[(8)] = inst_66573);

return statearr_66676;
})();
var statearr_66677_66772 = state_66653__$1;
(statearr_66677_66772[(2)] = null);

(statearr_66677_66772[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (28))){
var inst_66619 = (state_66653[(12)]);
var state_66653__$1 = state_66653;
var statearr_66678_66773 = state_66653__$1;
(statearr_66678_66773[(2)] = inst_66619);

(statearr_66678_66773[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (25))){
var inst_66611 = (state_66653[(13)]);
var state_66653__$1 = state_66653;
var statearr_66679_66774 = state_66653__$1;
(statearr_66679_66774[(2)] = inst_66611);

(statearr_66679_66774[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (34))){
var state_66653__$1 = state_66653;
var statearr_66680_66775 = state_66653__$1;
(statearr_66680_66775[(2)] = null);

(statearr_66680_66775[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (17))){
var inst_66645 = (state_66653[(2)]);
var state_66653__$1 = state_66653;
var statearr_66681_66776 = state_66653__$1;
(statearr_66681_66776[(2)] = inst_66645);

(statearr_66681_66776[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (3))){
var inst_66651 = (state_66653[(2)]);
var state_66653__$1 = state_66653;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66653__$1,inst_66651);
} else {
if((state_val_66654 === (12))){
var inst_66560 = (state_66653[(19)]);
var inst_66580 = (state_66653[(7)]);
var inst_66585 = fluree.db.api.query.auth_match.call(null,auth,inst_66560,inst_66580);
var inst_66586 = cljs.core.not.call(null,inst_66585);
var state_66653__$1 = state_66653;
var statearr_66682_66777 = state_66653__$1;
(statearr_66682_66777[(2)] = inst_66586);

(statearr_66682_66777[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (2))){
var _ = (function (){var statearr_66683 = state_66653;
(statearr_66683[(4)] = cljs.core.cons.call(null,(5),(state_66653[(4)])));

return statearr_66683;
})();
var inst_66465 = (function (){return (function (p1__66458_SHARP_){
return fluree.db.flake.t.call(null,p1__66458_SHARP_);
});
})();
var inst_66466 = cljs.core.map.call(null,inst_66465,resp);
var inst_66467 = cljs.core.set.call(null,inst_66466);
var inst_66555 = cljs.core.async.chan.call(null,(1));
var inst_66556 = (function (){var ts = inst_66467;
var c__2768__auto____$1 = inst_66555;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_66553){
var state_val_66554 = (state_66553[(1)]);
if((state_val_66554 === (7))){
var inst_66487 = (state_66553[(7)]);
var inst_66499 = (state_66553[(8)]);
var inst_66493 = (state_66553[(9)]);
var inst_66481 = (state_66553[(10)]);
var inst_66492 = (state_66553[(2)]);
var inst_66493__$1 = fluree.db.util.async.throw_err.call(null,inst_66492);
var inst_66495 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66496 = [inst_66487,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_66497 = (new cljs.core.PersistentVector(null,2,(5),inst_66495,inst_66496,null));
var inst_66498 = cljs.core.assoc_in.call(null,inst_66481,inst_66497,inst_66493__$1);
var inst_66499__$1 = auth;
var state_66553__$1 = (function (){var statearr_66684 = state_66553;
(statearr_66684[(11)] = inst_66498);

(statearr_66684[(8)] = inst_66499__$1);

(statearr_66684[(9)] = inst_66493__$1);

return statearr_66684;
})();
if(cljs.core.truth_(inst_66499__$1)){
var statearr_66685_66778 = state_66553__$1;
(statearr_66685_66778[(1)] = (8));

} else {
var statearr_66686_66779 = state_66553__$1;
(statearr_66686_66779[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66554 === (1))){
var inst_66475 = (state_66553[(12)]);
var inst_66475__$1 = ts;
var inst_66476 = cljs.core.seq.call(null,inst_66475__$1);
var inst_66477 = cljs.core.first.call(null,inst_66476);
var inst_66478 = cljs.core.next.call(null,inst_66476);
var inst_66479 = cljs.core.PersistentHashMap.EMPTY;
var inst_66480 = inst_66475__$1;
var inst_66481 = inst_66479;
var state_66553__$1 = (function (){var statearr_66687 = state_66553;
(statearr_66687[(13)] = inst_66477);

(statearr_66687[(14)] = inst_66478);

(statearr_66687[(10)] = inst_66481);

(statearr_66687[(15)] = inst_66480);

(statearr_66687[(12)] = inst_66475__$1);

return statearr_66687;
})();
var statearr_66688_66780 = state_66553__$1;
(statearr_66688_66780[(2)] = null);

(statearr_66688_66780[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66554 === (4))){
var inst_66487 = (state_66553[(7)]);
var inst_66490 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_66487);
var state_66553__$1 = state_66553;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66553__$1,(7),inst_66490);
} else {
if((state_val_66554 === (13))){
var inst_66488 = (state_66553[(16)]);
var inst_66545 = (state_66553[(2)]);
var inst_66480 = inst_66488;
var inst_66481 = inst_66545;
var state_66553__$1 = (function (){var statearr_66689 = state_66553;
(statearr_66689[(10)] = inst_66481);

(statearr_66689[(15)] = inst_66480);

return statearr_66689;
})();
var statearr_66690_66781 = state_66553__$1;
(statearr_66690_66781[(2)] = null);

(statearr_66690_66781[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66554 === (6))){
var inst_66549 = (state_66553[(2)]);
var state_66553__$1 = state_66553;
var statearr_66691_66782 = state_66553__$1;
(statearr_66691_66782[(2)] = inst_66549);

(statearr_66691_66782[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66554 === (3))){
var inst_66551 = (state_66553[(2)]);
var state_66553__$1 = state_66553;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66553__$1,inst_66551);
} else {
if((state_val_66554 === (12))){
var inst_66498 = (state_66553[(11)]);
var state_66553__$1 = state_66553;
var statearr_66692_66783 = state_66553__$1;
(statearr_66692_66783[(2)] = inst_66498);

(statearr_66692_66783[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66554 === (2))){
var inst_66487 = (state_66553[(7)]);
var inst_66480 = (state_66553[(15)]);
var inst_66486 = cljs.core.seq.call(null,inst_66480);
var inst_66487__$1 = cljs.core.first.call(null,inst_66486);
var inst_66488 = cljs.core.next.call(null,inst_66486);
var state_66553__$1 = (function (){var statearr_66693 = state_66553;
(statearr_66693[(7)] = inst_66487__$1);

(statearr_66693[(16)] = inst_66488);

return statearr_66693;
})();
if(cljs.core.truth_(inst_66487__$1)){
var statearr_66694_66784 = state_66553__$1;
(statearr_66694_66784[(1)] = (4));

} else {
var statearr_66695_66785 = state_66553__$1;
(statearr_66695_66785[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66554 === (11))){
var inst_66487 = (state_66553[(7)]);
var inst_66477 = (state_66553[(13)]);
var inst_66498 = (state_66553[(11)]);
var inst_66488 = (state_66553[(16)]);
var inst_66493 = (state_66553[(9)]);
var inst_66478 = (state_66553[(14)]);
var inst_66481 = (state_66553[(10)]);
var inst_66480 = (state_66553[(15)]);
var inst_66475 = (state_66553[(12)]);
var inst_66505 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66506 = [inst_66487,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_66507 = (new cljs.core.PersistentVector(null,2,(5),inst_66505,inst_66506,null));
var inst_66520 = cljs.core.async.chan.call(null,(1));
var inst_66521 = (function (){var t = inst_66487;
var vec__66472 = inst_66475;
var vec__66483 = inst_66480;
var block = inst_66493;
var r = inst_66488;
var first__66485 = inst_66487;
var G__66494 = inst_66498;
var acc = inst_66481;
var first__66474 = inst_66477;
var seq__66473 = inst_66478;
var seq__66484 = inst_66488;
var c__2768__auto____$2 = inst_66520;
var G__66471 = inst_66480;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_66518){
var state_val_66519 = (state_66518[(1)]);
if((state_val_66519 === (1))){
var state_66518__$1 = state_66518;
var statearr_66696_66786 = state_66518__$1;
(statearr_66696_66786[(2)] = null);

(statearr_66696_66786[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66519 === (2))){
var ___$1 = (function (){var statearr_66697 = state_66518;
(statearr_66697[(4)] = cljs.core.cons.call(null,(5),(state_66518[(4)])));

return statearr_66697;
})();
var ___$2 = (function (){var statearr_66698 = state_66518;
(statearr_66698[(4)] = cljs.core.rest.call(null,(state_66518[(4)])));

return statearr_66698;
})();
var state_66518__$1 = state_66518;
var statearr_66699_66787 = state_66518__$1;
(statearr_66699_66787[(2)] = db);

(statearr_66699_66787[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66519 === (3))){
var inst_66516 = (state_66518[(2)]);
var state_66518__$1 = state_66518;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66518__$1,inst_66516);
} else {
if((state_val_66519 === (4))){
var inst_66508 = (state_66518[(2)]);
var state_66518__$1 = state_66518;
var statearr_66701_66788 = state_66518__$1;
(statearr_66701_66788[(2)] = inst_66508);

(statearr_66701_66788[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66519 === (5))){
var ___$1 = (function (){var statearr_66702 = state_66518;
(statearr_66702[(4)] = cljs.core.rest.call(null,(state_66518[(4)])));

return statearr_66702;
})();
var state_66518__$1 = state_66518;
var ex66700 = (state_66518__$1[(2)]);
var statearr_66703_66789 = state_66518__$1;
(statearr_66703_66789[(5)] = ex66700);


if((ex66700 instanceof Error)){
var statearr_66704_66790 = state_66518__$1;
(statearr_66704_66790[(1)] = (4));

(statearr_66704_66790[(5)] = null);

} else {
throw ex66700;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_66705 = [null,null,null,null,null,null,null];
(statearr_66705[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__);

(statearr_66705[(1)] = (1));

return statearr_66705;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1 = (function (state_66518){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_66518);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e66706){var ex__2749__auto__ = e66706;
var statearr_66707_66791 = state_66518;
(statearr_66707_66791[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_66518[(4)]))){
var statearr_66708_66792 = state_66518;
(statearr_66708_66792[(1)] = cljs.core.first.call(null,(state_66518[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66793 = state_66518;
state_66518 = G__66793;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = function(state_66518){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1.call(this,state_66518);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_66709 = f__2769__auto__.call(null);
(statearr_66709[(6)] = c__2768__auto____$2);

return statearr_66709;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_66522 = cljs.core.async.impl.dispatch.run.call(null,inst_66521);
var inst_66523 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_66524 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66525 = ["?auth","?id"];
var inst_66526 = (new cljs.core.PersistentVector(null,2,(5),inst_66524,inst_66525,null));
var inst_66527 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66528 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66529 = [inst_66487,"_tx/auth","?auth"];
var inst_66530 = (new cljs.core.PersistentVector(null,3,(5),inst_66528,inst_66529,null));
var inst_66531 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66532 = ["?auth","_auth/id","?id"];
var inst_66533 = (new cljs.core.PersistentVector(null,3,(5),inst_66531,inst_66532,null));
var inst_66534 = [inst_66530,inst_66533];
var inst_66535 = (new cljs.core.PersistentVector(null,2,(5),inst_66527,inst_66534,null));
var inst_66536 = [inst_66526,inst_66535];
var inst_66537 = cljs.core.PersistentHashMap.fromArrays(inst_66523,inst_66536);
var inst_66538 = fluree.db.api.query.query_async.call(null,inst_66520,inst_66537);
var state_66553__$1 = (function (){var statearr_66710 = state_66553;
(statearr_66710[(17)] = inst_66507);

(statearr_66710[(18)] = inst_66522);

return statearr_66710;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66553__$1,(14),inst_66538);
} else {
if((state_val_66554 === (9))){
var state_66553__$1 = state_66553;
var statearr_66711_66794 = state_66553__$1;
(statearr_66711_66794[(2)] = show_auth);

(statearr_66711_66794[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66554 === (5))){
var inst_66481 = (state_66553[(10)]);
var state_66553__$1 = state_66553;
var statearr_66712_66795 = state_66553__$1;
(statearr_66712_66795[(2)] = inst_66481);

(statearr_66712_66795[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66554 === (14))){
var inst_66498 = (state_66553[(11)]);
var inst_66507 = (state_66553[(17)]);
var inst_66540 = (state_66553[(2)]);
var inst_66541 = fluree.db.util.async.throw_err.call(null,inst_66540);
var inst_66542 = cljs.core.assoc_in.call(null,inst_66498,inst_66507,inst_66541);
var state_66553__$1 = state_66553;
var statearr_66713_66796 = state_66553__$1;
(statearr_66713_66796[(2)] = inst_66542);

(statearr_66713_66796[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66554 === (10))){
var inst_66503 = (state_66553[(2)]);
var state_66553__$1 = state_66553;
if(cljs.core.truth_(inst_66503)){
var statearr_66714_66797 = state_66553__$1;
(statearr_66714_66797[(1)] = (11));

} else {
var statearr_66715_66798 = state_66553__$1;
(statearr_66715_66798[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66554 === (8))){
var inst_66499 = (state_66553[(8)]);
var state_66553__$1 = state_66553;
var statearr_66716_66799 = state_66553__$1;
(statearr_66716_66799[(2)] = inst_66499);

(statearr_66716_66799[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_66717 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66717[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__);

(statearr_66717[(1)] = (1));

return statearr_66717;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1 = (function (state_66553){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_66553);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e66718){var ex__2749__auto__ = e66718;
var statearr_66719_66800 = state_66553;
(statearr_66719_66800[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_66553[(4)]))){
var statearr_66720_66801 = state_66553;
(statearr_66720_66801[(1)] = cljs.core.first.call(null,(state_66553[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66802 = state_66553;
state_66553 = G__66802;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = function(state_66553){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1.call(this,state_66553);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_66721 = f__2769__auto__.call(null);
(statearr_66721[(6)] = c__2768__auto____$1);

return statearr_66721;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_66557 = cljs.core.async.impl.dispatch.run.call(null,inst_66556);
var state_66653__$1 = (function (){var statearr_66722 = state_66653;
(statearr_66722[(20)] = inst_66557);

return statearr_66722;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66653__$1,(6),inst_66555);
} else {
if((state_val_66654 === (23))){
var inst_66611 = (state_66653[(2)]);
var state_66653__$1 = (function (){var statearr_66723 = state_66653;
(statearr_66723[(13)] = inst_66611);

return statearr_66723;
})();
var statearr_66724_66803 = state_66653__$1;
(statearr_66724_66803[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (35))){
var inst_66641 = (state_66653[(2)]);
var state_66653__$1 = state_66653;
var statearr_66726_66804 = state_66653__$1;
(statearr_66726_66804[(2)] = inst_66641);

(statearr_66726_66804[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (19))){
var state_66653__$1 = state_66653;
var statearr_66727_66805 = state_66653__$1;
(statearr_66727_66805[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (11))){
var inst_66592 = (state_66653[(2)]);
var state_66653__$1 = state_66653;
if(cljs.core.truth_(inst_66592)){
var statearr_66730_66806 = state_66653__$1;
(statearr_66730_66806[(1)] = (15));

} else {
var statearr_66731_66807 = state_66653__$1;
(statearr_66731_66807[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (9))){
var inst_66583 = (state_66653[(16)]);
var inst_66583__$1 = auth;
var state_66653__$1 = (function (){var statearr_66732 = state_66653;
(statearr_66732[(16)] = inst_66583__$1);

return statearr_66732;
})();
if(cljs.core.truth_(inst_66583__$1)){
var statearr_66733_66808 = state_66653__$1;
(statearr_66733_66808[(1)] = (12));

} else {
var statearr_66734_66809 = state_66653__$1;
(statearr_66734_66809[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (5))){
var _ = (function (){var statearr_66735 = state_66653;
(statearr_66735[(4)] = cljs.core.rest.call(null,(state_66653[(4)])));

return statearr_66735;
})();
var state_66653__$1 = state_66653;
var ex66729 = (state_66653__$1[(2)]);
var statearr_66736_66810 = state_66653__$1;
(statearr_66736_66810[(5)] = ex66729);


if((ex66729 instanceof Error)){
var statearr_66737_66811 = state_66653__$1;
(statearr_66737_66811[(1)] = (4));

(statearr_66737_66811[(5)] = null);

} else {
throw ex66729;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (14))){
var inst_66589 = (state_66653[(2)]);
var state_66653__$1 = state_66653;
var statearr_66738_66812 = state_66653__$1;
(statearr_66738_66812[(2)] = inst_66589);

(statearr_66738_66812[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (26))){
var inst_66619 = (state_66653[(2)]);
var state_66653__$1 = (function (){var statearr_66739 = state_66653;
(statearr_66739[(12)] = inst_66619);

return statearr_66739;
})();
var statearr_66740_66813 = state_66653__$1;
(statearr_66740_66813[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (16))){
var inst_66580 = (state_66653[(7)]);
var state_66653__$1 = state_66653;
if(cljs.core.truth_(inst_66580)){
var statearr_66742_66814 = state_66653__$1;
(statearr_66742_66814[(1)] = (18));

} else {
var statearr_66743_66815 = state_66653__$1;
(statearr_66743_66815[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (30))){
var inst_66601 = (state_66653[(10)]);
var inst_66602 = (state_66653[(21)]);
var inst_66627 = (state_66653[(15)]);
var inst_66629 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66630 = [inst_66601,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_66631 = (new cljs.core.PersistentVector(null,2,(5),inst_66629,inst_66630,null));
var inst_66632 = cljs.core.assoc_in.call(null,inst_66627,inst_66631,inst_66602);
var state_66653__$1 = state_66653;
var statearr_66744_66816 = state_66653__$1;
(statearr_66744_66816[(2)] = inst_66632);

(statearr_66744_66816[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (10))){
var inst_66580 = (state_66653[(7)]);
var state_66653__$1 = state_66653;
var statearr_66745_66817 = state_66653__$1;
(statearr_66745_66817[(2)] = inst_66580);

(statearr_66745_66817[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (18))){
var inst_66598 = (state_66653[(11)]);
var inst_66560 = (state_66653[(19)]);
var inst_66580 = (state_66653[(7)]);
var inst_66598__$1 = fluree.db.flake.t.call(null,inst_66580);
var inst_66599 = cljs.core.get.call(null,inst_66560,inst_66598__$1);
var inst_66600 = cljs.core.__destructure_map.call(null,inst_66599);
var inst_66601 = cljs.core.get.call(null,inst_66600,new cljs.core.Keyword(null,"block","block",664686210));
var inst_66602 = cljs.core.get.call(null,inst_66600,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_66653__$1 = (function (){var statearr_66746 = state_66653;
(statearr_66746[(10)] = inst_66601);

(statearr_66746[(11)] = inst_66598__$1);

(statearr_66746[(21)] = inst_66602);

return statearr_66746;
})();
var statearr_66747_66818 = state_66653__$1;
(statearr_66747_66818[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (8))){
var inst_66647 = (state_66653[(2)]);
var inst_66648 = cljs.core.vals.call(null,inst_66647);
var _ = (function (){var statearr_66749 = state_66653;
(statearr_66749[(4)] = cljs.core.rest.call(null,(state_66653[(4)])));

return statearr_66749;
})();
var state_66653__$1 = state_66653;
var statearr_66750_66819 = state_66653__$1;
(statearr_66750_66819[(2)] = inst_66648);

(statearr_66750_66819[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_66751 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66751[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__);

(statearr_66751[(1)] = (1));

return statearr_66751;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1 = (function (state_66653){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_66653);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e66752){var ex__2749__auto__ = e66752;
var statearr_66753_66820 = state_66653;
(statearr_66753_66820[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_66653[(4)]))){
var statearr_66754_66821 = state_66653;
(statearr_66754_66821[(1)] = cljs.core.first.call(null,(state_66653[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66822 = state_66653;
state_66653 = G__66822;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = function(state_66653){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1.call(this,state_66653);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_66755 = f__2769__auto__.call(null);
(statearr_66755[(6)] = c__2768__auto__);

return statearr_66755;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.call(null,(function (block){
return cljs.core.assoc.call(null,block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.call(null,cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_66946){
var state_val_66947 = (state_66946[(1)]);
if((state_val_66947 === (7))){
var inst_66845 = (state_66946[(7)]);
var inst_66847 = fluree.db.api.query.resolve_block_range.call(null,inst_66845,query_map);
var state_66946__$1 = state_66946;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66946__$1,(10),inst_66847);
} else {
if((state_val_66947 === (20))){
var inst_66871 = (state_66946[(2)]);
var inst_66872 = fluree.db.util.async.throw_err.call(null,inst_66871);
var inst_66873 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_66872);
var inst_66874 = (inst_66873 - (1));
var state_66946__$1 = state_66946;
var statearr_66948_67011 = state_66946__$1;
(statearr_66948_67011[(2)] = inst_66874);

(statearr_66948_67011[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (27))){
var state_66946__$1 = state_66946;
var statearr_66949_67012 = state_66946__$1;
(statearr_66949_67012[(2)] = null);

(statearr_66949_67012[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (1))){
var state_66946__$1 = state_66946;
var statearr_66950_67013 = state_66946__$1;
(statearr_66950_67013[(2)] = null);

(statearr_66950_67013[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (24))){
var inst_66881 = (state_66946[(2)]);
var inst_66882 = fluree.db.util.async.throw_err.call(null,inst_66881);
var inst_66883 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_66882);
var state_66946__$1 = state_66946;
var statearr_66951_67014 = state_66946__$1;
(statearr_66951_67014[(2)] = inst_66883);

(statearr_66951_67014[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (39))){
var inst_66918 = (state_66946[(2)]);
var inst_66919 = fluree.db.util.async.throw_err.call(null,inst_66918);
var state_66946__$1 = state_66946;
var statearr_66952_67015 = state_66946__$1;
(statearr_66952_67015[(2)] = inst_66919);

(statearr_66952_67015[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (4))){
var inst_66823 = (state_66946[(2)]);
var state_66946__$1 = state_66946;
var statearr_66953_67016 = state_66946__$1;
(statearr_66953_67016[(2)] = inst_66823);

(statearr_66953_67016[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (15))){
var inst_66854 = (state_66946[(8)]);
var state_66946__$1 = state_66946;
var statearr_66954_67017 = state_66946__$1;
(statearr_66954_67017[(2)] = inst_66854);

(statearr_66954_67017[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (21))){
var inst_66855 = (state_66946[(9)]);
var inst_66845 = (state_66946[(7)]);
var inst_66879 = fluree.db.time_travel.as_of_block.call(null,inst_66845,inst_66855);
var state_66946__$1 = state_66946;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66946__$1,(24),inst_66879);
} else {
if((state_val_66947 === (31))){
var inst_66839 = (state_66946[(10)]);
var state_66946__$1 = state_66946;
var statearr_66955_67018 = state_66946__$1;
(statearr_66955_67018[(2)] = inst_66839);

(statearr_66955_67018[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (32))){
var inst_66902 = (state_66946[(11)]);
var inst_66897 = (state_66946[(12)]);
var inst_66845 = (state_66946[(7)]);
var inst_66906 = (state_66946[(2)]);
var inst_66907 = fluree.db.api.query.format_history_resp.call(null,inst_66845,inst_66897,inst_66902,inst_66906);
var state_66946__$1 = state_66946;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66946__$1,(29),inst_66907);
} else {
if((state_val_66947 === (40))){
var inst_66897 = (state_66946[(12)]);
var inst_66923 = (state_66946[(13)]);
var inst_66925 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_66926 = cljs.core.count.call(null,inst_66897);
var inst_66927 = [inst_66923,inst_66926,(200)];
var inst_66928 = cljs.core.PersistentHashMap.fromArrays(inst_66925,inst_66927);
var state_66946__$1 = state_66946;
var statearr_66956_67019 = state_66946__$1;
(statearr_66956_67019[(2)] = inst_66928);

(statearr_66956_67019[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (33))){
var inst_66838 = (state_66946[(14)]);
var state_66946__$1 = state_66946;
var statearr_66957_67020 = state_66946__$1;
(statearr_66957_67020[(2)] = inst_66838);

(statearr_66957_67020[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (13))){
var inst_66941 = (state_66946[(2)]);
var _ = (function (){var statearr_66958 = state_66946;
(statearr_66958[(4)] = cljs.core.rest.call(null,(state_66946[(4)])));

return statearr_66958;
})();
var state_66946__$1 = state_66946;
var statearr_66959_67021 = state_66946__$1;
(statearr_66959_67021[(2)] = inst_66941);

(statearr_66959_67021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (22))){
var inst_66845 = (state_66946[(7)]);
var inst_66885 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_66845);
var state_66946__$1 = state_66946;
var statearr_66960_67022 = state_66946__$1;
(statearr_66960_67022[(2)] = inst_66885);

(statearr_66960_67022[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (36))){
var inst_66845 = (state_66946[(7)]);
var inst_66910 = (state_66946[(15)]);
var inst_66916 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_66845,inst_66910);
var state_66946__$1 = state_66946;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66946__$1,(39),inst_66916);
} else {
if((state_val_66947 === (41))){
var inst_66923 = (state_66946[(13)]);
var state_66946__$1 = state_66946;
var statearr_66961_67023 = state_66946__$1;
(statearr_66961_67023[(2)] = inst_66923);

(statearr_66961_67023[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (29))){
var inst_66838 = (state_66946[(14)]);
var inst_66909 = (state_66946[(2)]);
var inst_66910 = fluree.db.util.async.throw_err.call(null,inst_66909);
var state_66946__$1 = (function (){var statearr_66962 = state_66946;
(statearr_66962[(15)] = inst_66910);

return statearr_66962;
})();
if(cljs.core.truth_(inst_66838)){
var statearr_66963_67024 = state_66946__$1;
(statearr_66963_67024[(1)] = (33));

} else {
var statearr_66964_67025 = state_66946__$1;
(statearr_66964_67025[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (6))){
var inst_66835 = (state_66946[(16)]);
var inst_66844 = (state_66946[(2)]);
var inst_66845 = fluree.db.util.async.throw_err.call(null,inst_66844);
var state_66946__$1 = (function (){var statearr_66965 = state_66946;
(statearr_66965[(7)] = inst_66845);

return statearr_66965;
})();
if(cljs.core.truth_(inst_66835)){
var statearr_66966_67026 = state_66946__$1;
(statearr_66966_67026[(1)] = (7));

} else {
var statearr_66967_67027 = state_66946__$1;
(statearr_66967_67027[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (28))){
var inst_66840 = (state_66946[(17)]);
var inst_66902 = (state_66946[(2)]);
var state_66946__$1 = (function (){var statearr_66968 = state_66946;
(statearr_66968[(11)] = inst_66902);

return statearr_66968;
})();
if(cljs.core.truth_(inst_66840)){
var statearr_66969_67028 = state_66946__$1;
(statearr_66969_67028[(1)] = (30));

} else {
var statearr_66970_67029 = state_66946__$1;
(statearr_66970_67029[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (25))){
var inst_66841 = (state_66946[(18)]);
var inst_66896 = (state_66946[(2)]);
var inst_66897 = fluree.db.util.async.throw_err.call(null,inst_66896);
var state_66946__$1 = (function (){var statearr_66971 = state_66946;
(statearr_66971[(12)] = inst_66897);

return statearr_66971;
})();
if(cljs.core.truth_(inst_66841)){
var statearr_66972_67030 = state_66946__$1;
(statearr_66972_67030[(1)] = (26));

} else {
var statearr_66973_67031 = state_66946__$1;
(statearr_66973_67031[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (34))){
var inst_66837 = (state_66946[(19)]);
var state_66946__$1 = state_66946;
var statearr_66974_67032 = state_66946__$1;
(statearr_66974_67032[(2)] = inst_66837);

(statearr_66974_67032[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (17))){
var inst_66845 = (state_66946[(7)]);
var inst_66854 = (state_66946[(8)]);
var inst_66868 = (inst_66854 - (1));
var inst_66869 = fluree.db.time_travel.as_of_block.call(null,inst_66845,inst_66868);
var state_66946__$1 = state_66946;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66946__$1,(20),inst_66869);
} else {
if((state_val_66947 === (3))){
var inst_66944 = (state_66946[(2)]);
var state_66946__$1 = state_66946;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66946__$1,inst_66944);
} else {
if((state_val_66947 === (12))){
var inst_66933 = cljs.core.pr_str.call(null,query_map);
var inst_66934 = ["History query not properly formatted. Provided ",inst_66933].join('');
var inst_66935 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66936 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_66937 = cljs.core.PersistentHashMap.fromArrays(inst_66935,inst_66936);
var inst_66938 = cljs.core.ex_info.call(null,inst_66934,inst_66937);
var inst_66939 = (function(){throw inst_66938})();
var state_66946__$1 = state_66946;
var statearr_66975_67033 = state_66946__$1;
(statearr_66975_67033[(2)] = inst_66939);

(statearr_66975_67033[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (2))){
var _ = (function (){var statearr_66976 = state_66946;
(statearr_66976[(4)] = cljs.core.cons.call(null,(5),(state_66946[(4)])));

return statearr_66976;
})();
var inst_66833 = query_map;
var inst_66834 = cljs.core.__destructure_map.call(null,inst_66833);
var inst_66835 = cljs.core.get.call(null,inst_66834,new cljs.core.Keyword(null,"block","block",664686210));
var inst_66836 = cljs.core.get.call(null,inst_66834,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_66837 = cljs.core.get.call(null,inst_66834,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_66838 = cljs.core.get.call(null,inst_66834,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_66839 = cljs.core.get.call(null,inst_66834,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_66840 = cljs.core.get.call(null,inst_66834,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_66841 = cljs.core.get.call(null,inst_66834,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_66842 = cljs.core.get.call(null,inst_66834,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_66946__$1 = (function (){var statearr_66977 = state_66946;
(statearr_66977[(20)] = inst_66836);

(statearr_66977[(16)] = inst_66835);

(statearr_66977[(14)] = inst_66838);

(statearr_66977[(17)] = inst_66840);

(statearr_66977[(18)] = inst_66841);

(statearr_66977[(19)] = inst_66837);

(statearr_66977[(10)] = inst_66839);

(statearr_66977[(21)] = inst_66842);

return statearr_66977;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66946__$1,(6),sources);
} else {
if((state_val_66947 === (23))){
var inst_66836 = (state_66946[(20)]);
var inst_66877 = (state_66946[(22)]);
var inst_66845 = (state_66946[(7)]);
var inst_66887 = (state_66946[(2)]);
var inst_66888 = fluree.db.api.query.get_history_pattern.call(null,inst_66836);
var inst_66889 = cljs.core.nth.call(null,inst_66888,(0),null);
var inst_66890 = cljs.core.nth.call(null,inst_66888,(1),null);
var inst_66891 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_66892 = [inst_66877,inst_66887];
var inst_66893 = cljs.core.PersistentHashMap.fromArrays(inst_66891,inst_66892);
var inst_66894 = fluree.db.query.range.time_range.call(null,inst_66845,inst_66890,cljs.core._EQ_,inst_66889,inst_66893);
var state_66946__$1 = state_66946;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66946__$1,(25),inst_66894);
} else {
if((state_val_66947 === (35))){
var inst_66914 = (state_66946[(2)]);
var state_66946__$1 = state_66946;
if(cljs.core.truth_(inst_66914)){
var statearr_66978_67034 = state_66946__$1;
(statearr_66978_67034[(1)] = (36));

} else {
var statearr_66979_67035 = state_66946__$1;
(statearr_66979_67035[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (19))){
var inst_66855 = (state_66946[(9)]);
var inst_66877 = (state_66946[(2)]);
var state_66946__$1 = (function (){var statearr_66980 = state_66946;
(statearr_66980[(22)] = inst_66877);

return statearr_66980;
})();
if(cljs.core.truth_(inst_66855)){
var statearr_66981_67036 = state_66946__$1;
(statearr_66981_67036[(1)] = (21));

} else {
var statearr_66982_67037 = state_66946__$1;
(statearr_66982_67037[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (11))){
var inst_66842 = (state_66946[(21)]);
var inst_66854 = (state_66946[(8)]);
var inst_66861 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_66842);
var state_66946__$1 = (function (){var statearr_66984 = state_66946;
(statearr_66984[(23)] = inst_66861);

return statearr_66984;
})();
if(cljs.core.truth_(inst_66854)){
var statearr_66985_67038 = state_66946__$1;
(statearr_66985_67038[(1)] = (14));

} else {
var statearr_66986_67039 = state_66946__$1;
(statearr_66986_67039[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (9))){
var inst_66853 = (state_66946[(2)]);
var inst_66854 = cljs.core.nth.call(null,inst_66853,(0),null);
var inst_66855 = cljs.core.nth.call(null,inst_66853,(1),null);
var inst_66856 = cljs.core.contains_QMARK_.call(null,query_map,new cljs.core.Keyword(null,"history","history",-247395220));
var state_66946__$1 = (function (){var statearr_66987 = state_66946;
(statearr_66987[(9)] = inst_66855);

(statearr_66987[(8)] = inst_66854);

return statearr_66987;
})();
if(inst_66856){
var statearr_66988_67040 = state_66946__$1;
(statearr_66988_67040[(1)] = (11));

} else {
var statearr_66989_67041 = state_66946__$1;
(statearr_66989_67041[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (5))){
var _ = (function (){var statearr_66990 = state_66946;
(statearr_66990[(4)] = cljs.core.rest.call(null,(state_66946[(4)])));

return statearr_66990;
})();
var state_66946__$1 = state_66946;
var ex66983 = (state_66946__$1[(2)]);
var statearr_66991_67042 = state_66946__$1;
(statearr_66991_67042[(5)] = ex66983);


if((ex66983 instanceof Error)){
var statearr_66992_67043 = state_66946__$1;
(statearr_66992_67043[(1)] = (4));

(statearr_66992_67043[(5)] = null);

} else {
throw ex66983;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (14))){
var inst_66854 = (state_66946[(8)]);
var inst_66863 = cljs.core.not_EQ_.call(null,(1),inst_66854);
var state_66946__$1 = state_66946;
var statearr_66993_67044 = state_66946__$1;
(statearr_66993_67044[(2)] = inst_66863);

(statearr_66993_67044[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (26))){
var inst_66841 = (state_66946[(18)]);
var inst_66899 = cljs.core.set.call(null,inst_66841);
var state_66946__$1 = state_66946;
var statearr_66994_67045 = state_66946__$1;
(statearr_66994_67045[(2)] = inst_66899);

(statearr_66994_67045[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (16))){
var inst_66866 = (state_66946[(2)]);
var state_66946__$1 = state_66946;
if(cljs.core.truth_(inst_66866)){
var statearr_66995_67046 = state_66946__$1;
(statearr_66995_67046[(1)] = (17));

} else {
var statearr_66996_67047 = state_66946__$1;
(statearr_66996_67047[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (38))){
var inst_66861 = (state_66946[(23)]);
var inst_66923 = (state_66946[(2)]);
var state_66946__$1 = (function (){var statearr_66997 = state_66946;
(statearr_66997[(13)] = inst_66923);

return statearr_66997;
})();
if(cljs.core.truth_(inst_66861)){
var statearr_66998_67048 = state_66946__$1;
(statearr_66998_67048[(1)] = (40));

} else {
var statearr_66999_67049 = state_66946__$1;
(statearr_66999_67049[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (30))){
var inst_66840 = (state_66946[(17)]);
var state_66946__$1 = state_66946;
var statearr_67000_67050 = state_66946__$1;
(statearr_67000_67050[(2)] = inst_66840);

(statearr_67000_67050[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (10))){
var inst_66849 = (state_66946[(2)]);
var inst_66850 = fluree.db.util.async.throw_err.call(null,inst_66849);
var state_66946__$1 = state_66946;
var statearr_67001_67051 = state_66946__$1;
(statearr_67001_67051[(2)] = inst_66850);

(statearr_67001_67051[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (18))){
var state_66946__$1 = state_66946;
var statearr_67002_67052 = state_66946__$1;
(statearr_67002_67052[(2)] = (-1));

(statearr_67002_67052[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (42))){
var inst_66931 = (state_66946[(2)]);
var state_66946__$1 = state_66946;
var statearr_67003_67053 = state_66946__$1;
(statearr_67003_67053[(2)] = inst_66931);

(statearr_67003_67053[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (37))){
var inst_66910 = (state_66946[(15)]);
var inst_66921 = fluree.db.api.query.block_Flakes__GT_vector.call(null,inst_66910);
var state_66946__$1 = state_66946;
var statearr_67004_67054 = state_66946__$1;
(statearr_67004_67054[(2)] = inst_66921);

(statearr_67004_67054[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66947 === (8))){
var state_66946__$1 = state_66946;
var statearr_67005_67055 = state_66946__$1;
(statearr_67005_67055[(2)] = null);

(statearr_67005_67055[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2746__auto____0 = (function (){
var statearr_67006 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67006[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2746__auto__);

(statearr_67006[(1)] = (1));

return statearr_67006;
});
var fluree$db$api$query$history_query_async_$_state_machine__2746__auto____1 = (function (state_66946){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_66946);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e67007){var ex__2749__auto__ = e67007;
var statearr_67008_67056 = state_66946;
(statearr_67008_67056[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_66946[(4)]))){
var statearr_67009_67057 = state_66946;
(statearr_67009_67057[(1)] = cljs.core.first.call(null,(state_66946[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67058 = state_66946;
state_66946 = G__67058;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2746__auto__ = function(state_66946){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2746__auto____1.call(this,state_66946);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2746__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2746__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_67010 = f__2769__auto__.call(null);
(statearr_67010[(6)] = c__2768__auto__);

return statearr_67010;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_67191){
var state_val_67192 = (state_67191[(1)]);
if((state_val_67192 === (7))){
var inst_67088 = cljs.core.pr_str.call(null,flureeQL);
var inst_67089 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_67088].join('');
var inst_67090 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_67091 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_67092 = cljs.core.PersistentHashMap.fromArrays(inst_67090,inst_67091);
var inst_67093 = cljs.core.ex_info.call(null,inst_67089,inst_67092);
var inst_67094 = (function(){throw inst_67093})();
var state_67191__$1 = state_67191;
var statearr_67193_67272 = state_67191__$1;
(statearr_67193_67272[(2)] = inst_67094);

(statearr_67193_67272[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (20))){
var inst_67126 = (state_67191[(2)]);
var state_67191__$1 = state_67191;
if(cljs.core.truth_(inst_67126)){
var statearr_67194_67273 = state_67191__$1;
(statearr_67194_67273[(1)] = (21));

} else {
var statearr_67195_67274 = state_67191__$1;
(statearr_67195_67274[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (27))){
var inst_67070 = (state_67191[(7)]);
var state_67191__$1 = state_67191;
var statearr_67196_67275 = state_67191__$1;
(statearr_67196_67275[(2)] = inst_67070);

(statearr_67196_67275[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (1))){
var state_67191__$1 = state_67191;
var statearr_67197_67276 = state_67191__$1;
(statearr_67197_67276[(2)] = null);

(statearr_67197_67276[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (24))){
var inst_67132 = (state_67191[(8)]);
var state_67191__$1 = state_67191;
var statearr_67198_67277 = state_67191__$1;
(statearr_67198_67277[(2)] = inst_67132);

(statearr_67198_67277[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (39))){
var inst_67076 = (state_67191[(9)]);
var state_67191__$1 = state_67191;
if(cljs.core.truth_(inst_67076)){
var statearr_67199_67278 = state_67191__$1;
(statearr_67199_67278[(1)] = (42));

} else {
var statearr_67200_67279 = state_67191__$1;
(statearr_67200_67279[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (46))){
var inst_67164 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_67165 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_67166 = cljs.core.PersistentHashMap.fromArrays(inst_67164,inst_67165);
var inst_67167 = cljs.core.ex_info.call(null,"Invalid query.",inst_67166);
var inst_67168 = (function(){throw inst_67167})();
var state_67191__$1 = state_67191;
var statearr_67201_67280 = state_67191__$1;
(statearr_67201_67280[(2)] = inst_67168);

(statearr_67201_67280[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (4))){
var inst_67060 = (state_67191[(2)]);
var state_67191__$1 = state_67191;
var statearr_67202_67281 = state_67191__$1;
(statearr_67202_67281[(2)] = inst_67060);

(statearr_67202_67281[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (15))){
var inst_67111 = (state_67191[(10)]);
var inst_67073 = (state_67191[(11)]);
var inst_67113 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_67111);
var inst_67114 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_67111);
var inst_67115 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_67111);
var inst_67116 = fluree.db.api.query.get_sources.call(null,inst_67113,inst_67114,inst_67115,inst_67073);
var state_67191__$1 = state_67191;
var statearr_67203_67282 = state_67191__$1;
(statearr_67203_67282[(2)] = inst_67116);

(statearr_67203_67282[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (48))){
var inst_67121 = (state_67191[(12)]);
var inst_67175 = (state_67191[(2)]);
var inst_67176 = fluree.db.util.async.throw_err.call(null,inst_67175);
var state_67191__$1 = (function (){var statearr_67204 = state_67191;
(statearr_67204[(13)] = inst_67176);

return statearr_67204;
})();
if(cljs.core.truth_(inst_67121)){
var statearr_67205_67283 = state_67191__$1;
(statearr_67205_67283[(1)] = (49));

} else {
var statearr_67206_67284 = state_67191__$1;
(statearr_67206_67284[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (50))){
var inst_67176 = (state_67191[(13)]);
var state_67191__$1 = state_67191;
var statearr_67207_67285 = state_67191__$1;
(statearr_67207_67285[(2)] = inst_67176);

(statearr_67207_67285[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (21))){
var inst_67128 = cljs.core.volatile_BANG_.call(null,(0));
var state_67191__$1 = state_67191;
var statearr_67208_67286 = state_67191__$1;
(statearr_67208_67286[(2)] = inst_67128);

(statearr_67208_67286[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (31))){
var inst_67074 = (state_67191[(14)]);
var state_67191__$1 = state_67191;
if(cljs.core.truth_(inst_67074)){
var statearr_67209_67287 = state_67191__$1;
(statearr_67209_67287[(1)] = (33));

} else {
var statearr_67210_67288 = state_67191__$1;
(statearr_67210_67288[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (32))){
var inst_67151 = (state_67191[(2)]);
var state_67191__$1 = state_67191;
var statearr_67211_67289 = state_67191__$1;
(statearr_67211_67289[(2)] = inst_67151);

(statearr_67211_67289[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (40))){
var inst_67153 = (state_67191[(15)]);
var state_67191__$1 = state_67191;
var statearr_67212_67290 = state_67191__$1;
(statearr_67212_67290[(2)] = inst_67153);

(statearr_67212_67290[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (33))){
var inst_67074 = (state_67191[(14)]);
var state_67191__$1 = state_67191;
var statearr_67213_67291 = state_67191__$1;
(statearr_67213_67291[(2)] = inst_67074);

(statearr_67213_67291[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (13))){
var inst_67071 = (state_67191[(16)]);
var inst_67100 = (state_67191[(2)]);
var inst_67101 = fluree.db.util.async.throw_err.call(null,inst_67100);
var inst_67102 = fluree.db.time_travel.as_of_block.call(null,inst_67101,inst_67071);
var state_67191__$1 = state_67191;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67191__$1,(12),inst_67102);
} else {
if((state_val_67192 === (22))){
var state_67191__$1 = state_67191;
var statearr_67214_67292 = state_67191__$1;
(statearr_67214_67292[(2)] = null);

(statearr_67214_67292[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (36))){
var inst_67078 = (state_67191[(17)]);
var state_67191__$1 = state_67191;
var statearr_67215_67293 = state_67191__$1;
(statearr_67215_67293[(2)] = inst_67078);

(statearr_67215_67293[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (41))){
var inst_67161 = (state_67191[(2)]);
var state_67191__$1 = state_67191;
if(cljs.core.truth_(inst_67161)){
var statearr_67216_67294 = state_67191__$1;
(statearr_67216_67294[(1)] = (45));

} else {
var statearr_67217_67295 = state_67191__$1;
(statearr_67217_67295[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (43))){
var inst_67072 = (state_67191[(18)]);
var state_67191__$1 = state_67191;
var statearr_67218_67296 = state_67191__$1;
(statearr_67218_67296[(2)] = inst_67072);

(statearr_67218_67296[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (29))){
var inst_67153 = (state_67191[(15)]);
var inst_67153__$1 = (state_67191[(2)]);
var state_67191__$1 = (function (){var statearr_67219 = state_67191;
(statearr_67219[(15)] = inst_67153__$1);

return statearr_67219;
})();
if(cljs.core.truth_(inst_67153__$1)){
var statearr_67220_67297 = state_67191__$1;
(statearr_67220_67297[(1)] = (39));

} else {
var statearr_67221_67298 = state_67191__$1;
(statearr_67221_67298[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (44))){
var inst_67158 = (state_67191[(2)]);
var state_67191__$1 = state_67191;
var statearr_67222_67299 = state_67191__$1;
(statearr_67222_67299[(2)] = inst_67158);

(statearr_67222_67299[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (6))){
var state_67191__$1 = state_67191;
var statearr_67223_67300 = state_67191__$1;
(statearr_67223_67300[(2)] = null);

(statearr_67223_67300[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (28))){
var inst_67075 = (state_67191[(19)]);
var state_67191__$1 = state_67191;
if(cljs.core.truth_(inst_67075)){
var statearr_67224_67301 = state_67191__$1;
(statearr_67224_67301[(1)] = (30));

} else {
var statearr_67225_67302 = state_67191__$1;
(statearr_67225_67302[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (51))){
var inst_67186 = (state_67191[(2)]);
var _ = (function (){var statearr_67226 = state_67191;
(statearr_67226[(4)] = cljs.core.rest.call(null,(state_67191[(4)])));

return statearr_67226;
})();
var state_67191__$1 = state_67191;
var statearr_67227_67303 = state_67191__$1;
(statearr_67227_67303[(2)] = inst_67186);

(statearr_67227_67303[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (25))){
var state_67191__$1 = state_67191;
var statearr_67228_67304 = state_67191__$1;
(statearr_67228_67304[(2)] = (1000000));

(statearr_67228_67304[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (34))){
var inst_67078 = (state_67191[(17)]);
var state_67191__$1 = state_67191;
if(cljs.core.truth_(inst_67078)){
var statearr_67229_67305 = state_67191__$1;
(statearr_67229_67305[(1)] = (36));

} else {
var statearr_67230_67306 = state_67191__$1;
(statearr_67230_67306[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (17))){
var inst_67122 = (state_67191[(20)]);
var inst_67077 = (state_67191[(21)]);
var inst_67120 = (state_67191[(2)]);
var inst_67121 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_67077);
var inst_67122__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_67077);
var state_67191__$1 = (function (){var statearr_67231 = state_67191;
(statearr_67231[(20)] = inst_67122__$1);

(statearr_67231[(22)] = inst_67120);

(statearr_67231[(12)] = inst_67121);

return statearr_67231;
})();
if(cljs.core.truth_(inst_67122__$1)){
var statearr_67232_67307 = state_67191__$1;
(statearr_67232_67307[(1)] = (18));

} else {
var statearr_67233_67308 = state_67191__$1;
(statearr_67233_67308[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (3))){
var inst_67189 = (state_67191[(2)]);
var state_67191__$1 = state_67191;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67191__$1,inst_67189);
} else {
if((state_val_67192 === (12))){
var inst_67104 = (state_67191[(2)]);
var inst_67105 = fluree.db.util.async.throw_err.call(null,inst_67104);
var state_67191__$1 = state_67191;
var statearr_67234_67309 = state_67191__$1;
(statearr_67234_67309[(2)] = inst_67105);

(statearr_67234_67309[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (2))){
var inst_67070 = (state_67191[(7)]);
var inst_67071 = (state_67191[(16)]);
var inst_67069 = (state_67191[(23)]);
var inst_67077 = (state_67191[(21)]);
var inst_67078 = (state_67191[(17)]);
var inst_67074 = (state_67191[(14)]);
var inst_67072 = (state_67191[(18)]);
var inst_67076 = (state_67191[(9)]);
var inst_67075 = (state_67191[(19)]);
var inst_67073 = (state_67191[(11)]);
var _ = (function (){var statearr_67235 = state_67191;
(statearr_67235[(4)] = cljs.core.cons.call(null,(5),(state_67191[(4)])));

return statearr_67235;
})();
var inst_67067 = flureeQL;
var inst_67068 = cljs.core.__destructure_map.call(null,inst_67067);
var inst_67069__$1 = cljs.core.get.call(null,inst_67068,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_67070__$1 = cljs.core.get.call(null,inst_67068,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_67071__$1 = cljs.core.get.call(null,inst_67068,new cljs.core.Keyword(null,"block","block",664686210));
var inst_67072__$1 = cljs.core.get.call(null,inst_67068,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_67073__$1 = cljs.core.get.call(null,inst_67068,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_67074__$1 = cljs.core.get.call(null,inst_67068,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_67075__$1 = cljs.core.get.call(null,inst_67068,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_67076__$1 = cljs.core.get.call(null,inst_67068,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_67077__$1 = cljs.core.get.call(null,inst_67068,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_67078__$1 = cljs.core.get.call(null,inst_67068,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_67079 = (function (){var construct = inst_67069__$1;
var select = inst_67070__$1;
var block = inst_67071__$1;
var where = inst_67072__$1;
var prefixes = inst_67073__$1;
var map__67066 = inst_67068;
var selectDistinct = inst_67074__$1;
var selectOne = inst_67075__$1;
var from = inst_67076__$1;
var opts = inst_67077__$1;
var selectReduced = inst_67078__$1;
return (function (p1__67059_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__67059_SHARP_);
});
})();
var inst_67080 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67081 = [inst_67070__$1,inst_67075__$1,inst_67074__$1,inst_67078__$1];
var inst_67082 = (new cljs.core.PersistentVector(null,4,(5),inst_67080,inst_67081,null));
var inst_67083 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_67082);
var inst_67084 = cljs.core.count.call(null,inst_67083);
var inst_67085 = inst_67079.call(null,inst_67084);
var state_67191__$1 = (function (){var statearr_67236 = state_67191;
(statearr_67236[(7)] = inst_67070__$1);

(statearr_67236[(16)] = inst_67071__$1);

(statearr_67236[(23)] = inst_67069__$1);

(statearr_67236[(21)] = inst_67077__$1);

(statearr_67236[(17)] = inst_67078__$1);

(statearr_67236[(14)] = inst_67074__$1);

(statearr_67236[(18)] = inst_67072__$1);

(statearr_67236[(9)] = inst_67076__$1);

(statearr_67236[(19)] = inst_67075__$1);

(statearr_67236[(11)] = inst_67073__$1);

return statearr_67236;
})();
if(cljs.core.truth_(inst_67085)){
var statearr_67237_67310 = state_67191__$1;
(statearr_67237_67310[(1)] = (6));

} else {
var statearr_67238_67311 = state_67191__$1;
(statearr_67238_67311[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (23))){
var inst_67077 = (state_67191[(21)]);
var inst_67132 = (state_67191[(8)]);
var inst_67131 = (state_67191[(2)]);
var inst_67132__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_67077);
var state_67191__$1 = (function (){var statearr_67239 = state_67191;
(statearr_67239[(8)] = inst_67132__$1);

(statearr_67239[(24)] = inst_67131);

return statearr_67239;
})();
if(cljs.core.truth_(inst_67132__$1)){
var statearr_67240_67312 = state_67191__$1;
(statearr_67240_67312[(1)] = (24));

} else {
var statearr_67241_67313 = state_67191__$1;
(statearr_67241_67313[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (47))){
var inst_67111 = (state_67191[(10)]);
var inst_67137 = (state_67191[(25)]);
var inst_67170 = (state_67191[(2)]);
var inst_67171 = fluree.db.util.core.current_time_millis.call(null);
var inst_67172 = cljs.core.assoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_67137);
var inst_67173 = fluree.db.query.fql.query.call(null,inst_67111,inst_67172);
var state_67191__$1 = (function (){var statearr_67242 = state_67191;
(statearr_67242[(26)] = inst_67170);

(statearr_67242[(27)] = inst_67171);

return statearr_67242;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67191__$1,(48),inst_67173);
} else {
if((state_val_67192 === (35))){
var inst_67149 = (state_67191[(2)]);
var state_67191__$1 = state_67191;
var statearr_67243_67314 = state_67191__$1;
(statearr_67243_67314[(2)] = inst_67149);

(statearr_67243_67314[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (19))){
var inst_67121 = (state_67191[(12)]);
var state_67191__$1 = state_67191;
var statearr_67244_67315 = state_67191__$1;
(statearr_67244_67315[(2)] = inst_67121);

(statearr_67244_67315[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (11))){
var inst_67073 = (state_67191[(11)]);
var inst_67111 = (state_67191[(2)]);
var state_67191__$1 = (function (){var statearr_67246 = state_67191;
(statearr_67246[(10)] = inst_67111);

return statearr_67246;
})();
if(cljs.core.truth_(inst_67073)){
var statearr_67247_67316 = state_67191__$1;
(statearr_67247_67316[(1)] = (15));

} else {
var statearr_67248_67317 = state_67191__$1;
(statearr_67248_67317[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (9))){
var inst_67097 = (state_67191[(28)]);
var state_67191__$1 = state_67191;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67191__$1,(13),inst_67097);
} else {
if((state_val_67192 === (5))){
var _ = (function (){var statearr_67249 = state_67191;
(statearr_67249[(4)] = cljs.core.rest.call(null,(state_67191[(4)])));

return statearr_67249;
})();
var state_67191__$1 = state_67191;
var ex67245 = (state_67191__$1[(2)]);
var statearr_67250_67318 = state_67191__$1;
(statearr_67250_67318[(5)] = ex67245);


if((ex67245 instanceof Error)){
var statearr_67251_67319 = state_67191__$1;
(statearr_67251_67319[(1)] = (4));

(statearr_67251_67319[(5)] = null);

} else {
throw ex67245;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (14))){
var inst_67108 = (state_67191[(2)]);
var inst_67109 = fluree.db.util.async.throw_err.call(null,inst_67108);
var state_67191__$1 = state_67191;
var statearr_67252_67320 = state_67191__$1;
(statearr_67252_67320[(2)] = inst_67109);

(statearr_67252_67320[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (45))){
var state_67191__$1 = state_67191;
var statearr_67253_67321 = state_67191__$1;
(statearr_67253_67321[(2)] = null);

(statearr_67253_67321[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (26))){
var inst_67070 = (state_67191[(7)]);
var inst_67077 = (state_67191[(21)]);
var inst_67120 = (state_67191[(22)]);
var inst_67131 = (state_67191[(24)]);
var inst_67136 = (state_67191[(2)]);
var inst_67137 = cljs.core.assoc.call(null,inst_67077,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_67120,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_67136,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_67131);
var state_67191__$1 = (function (){var statearr_67254 = state_67191;
(statearr_67254[(25)] = inst_67137);

return statearr_67254;
})();
if(cljs.core.truth_(inst_67070)){
var statearr_67255_67322 = state_67191__$1;
(statearr_67255_67322[(1)] = (27));

} else {
var statearr_67256_67323 = state_67191__$1;
(statearr_67256_67323[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (16))){
var inst_67118 = cljs.core.PersistentHashMap.EMPTY;
var state_67191__$1 = state_67191;
var statearr_67257_67324 = state_67191__$1;
(statearr_67257_67324[(2)] = inst_67118);

(statearr_67257_67324[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (38))){
var inst_67147 = (state_67191[(2)]);
var state_67191__$1 = state_67191;
var statearr_67258_67325 = state_67191__$1;
(statearr_67258_67325[(2)] = inst_67147);

(statearr_67258_67325[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (30))){
var inst_67075 = (state_67191[(19)]);
var state_67191__$1 = state_67191;
var statearr_67259_67326 = state_67191__$1;
(statearr_67259_67326[(2)] = inst_67075);

(statearr_67259_67326[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (10))){
var inst_67097 = (state_67191[(28)]);
var state_67191__$1 = state_67191;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67191__$1,(14),inst_67097);
} else {
if((state_val_67192 === (18))){
var inst_67122 = (state_67191[(20)]);
var state_67191__$1 = state_67191;
var statearr_67260_67327 = state_67191__$1;
(statearr_67260_67327[(2)] = inst_67122);

(statearr_67260_67327[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (42))){
var inst_67076 = (state_67191[(9)]);
var state_67191__$1 = state_67191;
var statearr_67261_67328 = state_67191__$1;
(statearr_67261_67328[(2)] = inst_67076);

(statearr_67261_67328[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (37))){
var inst_67069 = (state_67191[(23)]);
var state_67191__$1 = state_67191;
var statearr_67262_67329 = state_67191__$1;
(statearr_67262_67329[(2)] = inst_67069);

(statearr_67262_67329[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (8))){
var inst_67071 = (state_67191[(16)]);
var inst_67096 = (state_67191[(2)]);
var inst_67097 = sources;
var state_67191__$1 = (function (){var statearr_67263 = state_67191;
(statearr_67263[(28)] = inst_67097);

(statearr_67263[(29)] = inst_67096);

return statearr_67263;
})();
if(cljs.core.truth_(inst_67071)){
var statearr_67264_67330 = state_67191__$1;
(statearr_67264_67330[(1)] = (9));

} else {
var statearr_67265_67331 = state_67191__$1;
(statearr_67265_67331[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67192 === (49))){
var inst_67111 = (state_67191[(10)]);
var inst_67176 = (state_67191[(13)]);
var inst_67171 = (state_67191[(27)]);
var inst_67131 = (state_67191[(24)]);
var inst_67178 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_67179 = cljs.core.deref.call(null,inst_67131);
var inst_67180 = fluree.db.util.core.response_time_formatted.call(null,inst_67171);
var inst_67181 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_67111);
var inst_67182 = [(200),inst_67176,inst_67179,inst_67180,inst_67181];
var inst_67183 = cljs.core.PersistentHashMap.fromArrays(inst_67178,inst_67182);
var state_67191__$1 = state_67191;
var statearr_67266_67332 = state_67191__$1;
(statearr_67266_67332[(2)] = inst_67183);

(statearr_67266_67332[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2746__auto____0 = (function (){
var statearr_67267 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67267[(0)] = fluree$db$api$query$query_async_$_state_machine__2746__auto__);

(statearr_67267[(1)] = (1));

return statearr_67267;
});
var fluree$db$api$query$query_async_$_state_machine__2746__auto____1 = (function (state_67191){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_67191);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e67268){var ex__2749__auto__ = e67268;
var statearr_67269_67333 = state_67191;
(statearr_67269_67333[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_67191[(4)]))){
var statearr_67270_67334 = state_67191;
(statearr_67270_67334[(1)] = cljs.core.first.call(null,(state_67191[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67335 = state_67191;
state_67191 = G__67335;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2746__auto__ = function(state_67191){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2746__auto____1.call(this,state_67191);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2746__auto____0;
fluree$db$api$query$query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2746__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_67271 = f__2769__auto__.call(null);
(statearr_67271[(6)] = c__2768__auto__);

return statearr_67271;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_67476){
var state_val_67477 = (state_67476[(1)]);
if((state_val_67477 === (7))){
var inst_67471 = (state_67476[(2)]);
var _ = (function (){var statearr_67478 = state_67476;
(statearr_67478[(4)] = cljs.core.rest.call(null,(state_67476[(4)])));

return statearr_67478;
})();
var state_67476__$1 = state_67476;
var statearr_67479_67555 = state_67476__$1;
(statearr_67479_67555[(2)] = inst_67471);

(statearr_67479_67555[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (20))){
var inst_67443 = (state_67476[(2)]);
var state_67476__$1 = state_67476;
var statearr_67480_67556 = state_67476__$1;
(statearr_67480_67556[(2)] = inst_67443);

(statearr_67480_67556[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (27))){
var inst_67423 = (state_67476[(7)]);
var state_67476__$1 = state_67476;
var statearr_67481_67557 = state_67476__$1;
(statearr_67481_67557[(2)] = inst_67423);

(statearr_67481_67557[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (1))){
var state_67476__$1 = state_67476;
var statearr_67482_67558 = state_67476__$1;
(statearr_67482_67558[(2)] = null);

(statearr_67482_67558[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (24))){
var inst_67420 = (state_67476[(8)]);
var state_67476__$1 = state_67476;
var statearr_67483_67559 = state_67476__$1;
(statearr_67483_67559[(2)] = inst_67420);

(statearr_67483_67559[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (39))){
var inst_67377 = (state_67476[(9)]);
var inst_67410 = (state_67476[(10)]);
var inst_67388 = (state_67476[(11)]);
var inst_67454 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67455 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_67388];
var inst_67456 = (new cljs.core.PersistentVector(null,2,(5),inst_67454,inst_67455,null));
var inst_67457 = cljs.core.assoc_in.call(null,inst_67377,inst_67456,inst_67410);
var state_67476__$1 = state_67476;
var statearr_67484_67560 = state_67476__$1;
(statearr_67484_67560[(2)] = inst_67457);

(statearr_67484_67560[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (4))){
var inst_67336 = (state_67476[(2)]);
var state_67476__$1 = state_67476;
var statearr_67485_67561 = state_67476__$1;
(statearr_67485_67561[(2)] = inst_67336);

(statearr_67485_67561[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (15))){
var inst_67375 = (state_67476[(12)]);
var inst_67410 = (state_67476[(10)]);
var inst_67413 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_67410);
var inst_67414 = (inst_67375 == null);
var state_67476__$1 = (function (){var statearr_67486 = state_67476;
(statearr_67486[(13)] = inst_67413);

return statearr_67486;
})();
if(cljs.core.truth_(inst_67414)){
var statearr_67487_67562 = state_67476__$1;
(statearr_67487_67562[(1)] = (18));

} else {
var statearr_67488_67563 = state_67476__$1;
(statearr_67488_67563[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (21))){
var inst_67413 = (state_67476[(13)]);
var state_67476__$1 = state_67476;
var statearr_67489_67564 = state_67476__$1;
(statearr_67489_67564[(2)] = inst_67413);

(statearr_67489_67564[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (31))){
var state_67476__$1 = state_67476;
var statearr_67490_67565 = state_67476__$1;
(statearr_67490_67565[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (32))){
var inst_67439 = (state_67476[(2)]);
var state_67476__$1 = state_67476;
var statearr_67492_67566 = state_67476__$1;
(statearr_67492_67566[(2)] = inst_67439);

(statearr_67492_67566[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (40))){
var inst_67408 = (state_67476[(14)]);
var state_67476__$1 = state_67476;
if(cljs.core.truth_(inst_67408)){
var statearr_67493_67567 = state_67476__$1;
(statearr_67493_67567[(1)] = (42));

} else {
var statearr_67494_67568 = state_67476__$1;
(statearr_67494_67568[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (33))){
var inst_67375 = (state_67476[(12)]);
var inst_67413 = (state_67476[(13)]);
var inst_67434 = ((inst_67413 > inst_67375) ? inst_67413 : inst_67375);
var state_67476__$1 = state_67476;
var statearr_67495_67569 = state_67476__$1;
(statearr_67495_67569[(2)] = inst_67434);

(statearr_67495_67569[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (13))){
var inst_67399 = (state_67476[(2)]);
var state_67476__$1 = state_67476;
var statearr_67496_67570 = state_67476__$1;
(statearr_67496_67570[(2)] = inst_67399);

(statearr_67496_67570[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (22))){
var inst_67413 = (state_67476[(13)]);
var inst_67420 = (state_67476[(8)]);
var inst_67420__$1 = cljs.core._EQ_.call(null,(200),inst_67413);
var state_67476__$1 = (function (){var statearr_67497 = state_67476;
(statearr_67497[(8)] = inst_67420__$1);

return statearr_67497;
})();
if(inst_67420__$1){
var statearr_67498_67571 = state_67476__$1;
(statearr_67498_67571[(1)] = (24));

} else {
var statearr_67499_67572 = state_67476__$1;
(statearr_67499_67572[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (36))){
var inst_67410 = (state_67476[(10)]);
var inst_67376 = (state_67476[(15)]);
var inst_67448 = cljs.core.get.call(null,inst_67410,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_67449 = (inst_67376 + inst_67448);
var state_67476__$1 = state_67476;
var statearr_67500_67573 = state_67476__$1;
(statearr_67500_67573[(2)] = inst_67449);

(statearr_67500_67573[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (41))){
var inst_67452 = (state_67476[(16)]);
var inst_67387 = (state_67476[(17)]);
var inst_67446 = (state_67476[(18)]);
var inst_67466 = (state_67476[(2)]);
var inst_67374 = inst_67387;
var inst_67375 = inst_67446;
var inst_67376 = inst_67452;
var inst_67377 = inst_67466;
var state_67476__$1 = (function (){var statearr_67501 = state_67476;
(statearr_67501[(19)] = inst_67374);

(statearr_67501[(12)] = inst_67375);

(statearr_67501[(9)] = inst_67377);

(statearr_67501[(15)] = inst_67376);

return statearr_67501;
})();
var statearr_67502_67574 = state_67476__$1;
(statearr_67502_67574[(2)] = null);

(statearr_67502_67574[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (43))){
var inst_67410 = (state_67476[(10)]);
var state_67476__$1 = state_67476;
var statearr_67503_67575 = state_67476__$1;
(statearr_67503_67575[(2)] = inst_67410);

(statearr_67503_67575[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (29))){
var inst_67428 = (state_67476[(2)]);
var state_67476__$1 = state_67476;
var statearr_67504_67576 = state_67476__$1;
(statearr_67504_67576[(2)] = inst_67428);

(statearr_67504_67576[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (44))){
var inst_67377 = (state_67476[(9)]);
var inst_67388 = (state_67476[(11)]);
var inst_67463 = (state_67476[(2)]);
var inst_67464 = cljs.core.assoc.call(null,inst_67377,inst_67388,inst_67463);
var state_67476__$1 = state_67476;
var statearr_67505_67577 = state_67476__$1;
(statearr_67505_67577[(2)] = inst_67464);

(statearr_67505_67577[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (6))){
var inst_67374 = (state_67476[(19)]);
var inst_67389 = (state_67476[(20)]);
var inst_67385 = cljs.core.seq.call(null,inst_67374);
var inst_67386 = cljs.core.first.call(null,inst_67385);
var inst_67387 = cljs.core.next.call(null,inst_67385);
var inst_67388 = cljs.core.nth.call(null,inst_67386,(0),null);
var inst_67389__$1 = cljs.core.nth.call(null,inst_67386,(1),null);
var inst_67390 = (inst_67389__$1 == null);
var state_67476__$1 = (function (){var statearr_67506 = state_67476;
(statearr_67506[(17)] = inst_67387);

(statearr_67506[(20)] = inst_67389__$1);

(statearr_67506[(11)] = inst_67388);

return statearr_67506;
})();
if(cljs.core.truth_(inst_67390)){
var statearr_67507_67578 = state_67476__$1;
(statearr_67507_67578[(1)] = (8));

} else {
var statearr_67508_67579 = state_67476__$1;
(statearr_67508_67579[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (28))){
var inst_67375 = (state_67476[(12)]);
var inst_67426 = cljs.core._EQ_.call(null,(207),inst_67375);
var state_67476__$1 = state_67476;
var statearr_67509_67580 = state_67476__$1;
(statearr_67509_67580[(2)] = inst_67426);

(statearr_67509_67580[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (25))){
var inst_67375 = (state_67476[(12)]);
var inst_67423 = (state_67476[(7)]);
var inst_67423__$1 = cljs.core._EQ_.call(null,(200),inst_67375);
var state_67476__$1 = (function (){var statearr_67510 = state_67476;
(statearr_67510[(7)] = inst_67423__$1);

return statearr_67510;
})();
if(inst_67423__$1){
var statearr_67511_67581 = state_67476__$1;
(statearr_67511_67581[(1)] = (27));

} else {
var statearr_67512_67582 = state_67476__$1;
(statearr_67512_67582[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (34))){
var state_67476__$1 = state_67476;
var statearr_67513_67583 = state_67476__$1;
(statearr_67513_67583[(2)] = null);

(statearr_67513_67583[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (17))){
var inst_67407 = (state_67476[(21)]);
var inst_67446 = (state_67476[(2)]);
var state_67476__$1 = (function (){var statearr_67514 = state_67476;
(statearr_67514[(18)] = inst_67446);

return statearr_67514;
})();
if(cljs.core.truth_(inst_67407)){
var statearr_67515_67584 = state_67476__$1;
(statearr_67515_67584[(1)] = (36));

} else {
var statearr_67516_67585 = state_67476__$1;
(statearr_67516_67585[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (3))){
var inst_67474 = (state_67476[(2)]);
var state_67476__$1 = state_67476;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67476__$1,inst_67474);
} else {
if((state_val_67477 === (12))){
var inst_67377 = (state_67476[(9)]);
var state_67476__$1 = state_67476;
var statearr_67517_67586 = state_67476__$1;
(statearr_67517_67586[(2)] = inst_67377);

(statearr_67517_67586[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (2))){
var inst_67346 = (state_67476[(22)]);
var inst_67350 = (state_67476[(23)]);
var inst_67351 = (state_67476[(24)]);
var _ = (function (){var statearr_67518 = state_67476;
(statearr_67518[(4)] = cljs.core.cons.call(null,(5),(state_67476[(4)])));

return statearr_67518;
})();
var inst_67342 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_67343 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67344 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_67345 = (new cljs.core.PersistentVector(null,2,(5),inst_67343,inst_67344,null));
var inst_67346__$1 = cljs.core.get_in.call(null,flureeQL,inst_67345);
var inst_67347 = (function (){var global_block = inst_67342;
var global_meta_QMARK_ = inst_67346__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.call(null,query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__5045__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__5043__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not.call(null,query_meta_QMARK_);
} else {
return and__5043__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.call(null,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_);
var query_STAR_ = cljs.core.assoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return global_block;
}
})());
return cljs.core.assoc.call(null,acc,alias,query_STAR_);
});
})();
var inst_67348 = cljs.core.PersistentHashMap.EMPTY;
var inst_67349 = cljs.core.dissoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"block","block",664686210));
var inst_67350__$1 = cljs.core.reduce_kv.call(null,inst_67347,inst_67348,inst_67349);
var inst_67351__$1 = fluree.db.util.core.current_time_millis.call(null);
var inst_67353 = (function (){var global_block = inst_67342;
var global_meta_QMARK_ = inst_67346__$1;
var queries = inst_67350__$1;
var start_time = inst_67351__$1;
return (function (p__67352){
var vec__67519 = p__67352;
var alias = cljs.core.nth.call(null,vec__67519,(0),null);
var q = cljs.core.nth.call(null,vec__67519,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,fluree.db.api.query.query.call(null,source,q)], null);
});
})();
var inst_67354 = cljs.core.map.call(null,inst_67353,inst_67350__$1);
var inst_67368 = cljs.core.seq.call(null,inst_67354);
var inst_67369 = cljs.core.first.call(null,inst_67368);
var inst_67370 = cljs.core.next.call(null,inst_67368);
var inst_67371 = cljs.core.nth.call(null,inst_67369,(0),null);
var inst_67372 = cljs.core.nth.call(null,inst_67369,(1),null);
var inst_67373 = cljs.core.PersistentHashMap.EMPTY;
var inst_67374 = inst_67354;
var inst_67375 = null;
var inst_67376 = (0);
var inst_67377 = inst_67373;
var state_67476__$1 = (function (){var statearr_67522 = state_67476;
(statearr_67522[(19)] = inst_67374);

(statearr_67522[(25)] = inst_67370);

(statearr_67522[(12)] = inst_67375);

(statearr_67522[(22)] = inst_67346__$1);

(statearr_67522[(26)] = inst_67372);

(statearr_67522[(9)] = inst_67377);

(statearr_67522[(23)] = inst_67350__$1);

(statearr_67522[(15)] = inst_67376);

(statearr_67522[(24)] = inst_67351__$1);

(statearr_67522[(27)] = inst_67371);

return statearr_67522;
})();
var statearr_67523_67587 = state_67476__$1;
(statearr_67523_67587[(2)] = null);

(statearr_67523_67587[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (23))){
var inst_67441 = (state_67476[(2)]);
var state_67476__$1 = state_67476;
var statearr_67524_67588 = state_67476__$1;
(statearr_67524_67588[(2)] = inst_67441);

(statearr_67524_67588[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (35))){
var inst_67437 = (state_67476[(2)]);
var state_67476__$1 = state_67476;
var statearr_67525_67589 = state_67476__$1;
(statearr_67525_67589[(2)] = inst_67437);

(statearr_67525_67589[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (19))){
var inst_67375 = (state_67476[(12)]);
var inst_67413 = (state_67476[(13)]);
var inst_67417 = cljs.core._EQ_.call(null,inst_67375,inst_67413);
var state_67476__$1 = state_67476;
if(inst_67417){
var statearr_67526_67590 = state_67476__$1;
(statearr_67526_67590[(1)] = (21));

} else {
var statearr_67527_67591 = state_67476__$1;
(statearr_67527_67591[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (11))){
var inst_67375 = (state_67476[(12)]);
var inst_67377 = (state_67476[(9)]);
var inst_67376 = (state_67476[(15)]);
var inst_67351 = (state_67476[(24)]);
var inst_67393 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_67394 = fluree.db.util.core.response_time_formatted.call(null,inst_67351);
var inst_67395 = [inst_67377,inst_67376,inst_67375,inst_67394];
var inst_67396 = cljs.core.PersistentHashMap.fromArrays(inst_67393,inst_67395);
var state_67476__$1 = state_67476;
var statearr_67529_67592 = state_67476__$1;
(statearr_67529_67592[(2)] = inst_67396);

(statearr_67529_67592[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (9))){
var inst_67389 = (state_67476[(20)]);
var inst_67350 = (state_67476[(23)]);
var inst_67388 = (state_67476[(11)]);
var inst_67402 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67403 = [inst_67388,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_67404 = (new cljs.core.PersistentVector(null,2,(5),inst_67402,inst_67403,null));
var inst_67405 = cljs.core.get_in.call(null,inst_67350,inst_67404);
var inst_67406 = cljs.core.__destructure_map.call(null,inst_67405);
var inst_67407 = cljs.core.get.call(null,inst_67406,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_67408 = cljs.core.get.call(null,inst_67406,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_67476__$1 = (function (){var statearr_67530 = state_67476;
(statearr_67530[(14)] = inst_67408);

(statearr_67530[(21)] = inst_67407);

return statearr_67530;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67476__$1,(14),inst_67389);
} else {
if((state_val_67477 === (5))){
var _ = (function (){var statearr_67531 = state_67476;
(statearr_67531[(4)] = cljs.core.rest.call(null,(state_67476[(4)])));

return statearr_67531;
})();
var state_67476__$1 = state_67476;
var ex67528 = (state_67476__$1[(2)]);
var statearr_67532_67593 = state_67476__$1;
(statearr_67532_67593[(5)] = ex67528);


var statearr_67533_67594 = state_67476__$1;
(statearr_67533_67594[(1)] = (4));

(statearr_67533_67594[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (14))){
var inst_67407 = (state_67476[(21)]);
var inst_67410 = (state_67476[(10)]);
var inst_67410__$1 = (state_67476[(2)]);
var inst_67411 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_67410__$1);
var state_67476__$1 = (function (){var statearr_67534 = state_67476;
(statearr_67534[(10)] = inst_67410__$1);

(statearr_67534[(28)] = inst_67411);

return statearr_67534;
})();
if(cljs.core.truth_(inst_67407)){
var statearr_67535_67595 = state_67476__$1;
(statearr_67535_67595[(1)] = (15));

} else {
var statearr_67536_67596 = state_67476__$1;
(statearr_67536_67596[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (26))){
var inst_67430 = (state_67476[(2)]);
var state_67476__$1 = state_67476;
if(cljs.core.truth_(inst_67430)){
var statearr_67537_67597 = state_67476__$1;
(statearr_67537_67597[(1)] = (30));

} else {
var statearr_67538_67598 = state_67476__$1;
(statearr_67538_67598[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (16))){
var state_67476__$1 = state_67476;
var statearr_67539_67599 = state_67476__$1;
(statearr_67539_67599[(2)] = null);

(statearr_67539_67599[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (38))){
var inst_67411 = (state_67476[(28)]);
var inst_67452 = (state_67476[(2)]);
var state_67476__$1 = (function (){var statearr_67540 = state_67476;
(statearr_67540[(16)] = inst_67452);

return statearr_67540;
})();
if(cljs.core.truth_(inst_67411)){
var statearr_67541_67600 = state_67476__$1;
(statearr_67541_67600[(1)] = (39));

} else {
var statearr_67542_67601 = state_67476__$1;
(statearr_67542_67601[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (30))){
var state_67476__$1 = state_67476;
var statearr_67543_67602 = state_67476__$1;
(statearr_67543_67602[(2)] = (207));

(statearr_67543_67602[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (10))){
var inst_67469 = (state_67476[(2)]);
var state_67476__$1 = state_67476;
var statearr_67544_67603 = state_67476__$1;
(statearr_67544_67603[(2)] = inst_67469);

(statearr_67544_67603[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (18))){
var inst_67413 = (state_67476[(13)]);
var state_67476__$1 = state_67476;
var statearr_67545_67604 = state_67476__$1;
(statearr_67545_67604[(2)] = inst_67413);

(statearr_67545_67604[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (42))){
var inst_67410 = (state_67476[(10)]);
var inst_67460 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_67410);
var state_67476__$1 = state_67476;
var statearr_67546_67605 = state_67476__$1;
(statearr_67546_67605[(2)] = inst_67460);

(statearr_67546_67605[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (37))){
var state_67476__$1 = state_67476;
var statearr_67547_67606 = state_67476__$1;
(statearr_67547_67606[(2)] = null);

(statearr_67547_67606[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67477 === (8))){
var inst_67346 = (state_67476[(22)]);
var state_67476__$1 = state_67476;
if(cljs.core.truth_(inst_67346)){
var statearr_67548_67607 = state_67476__$1;
(statearr_67548_67607[(1)] = (11));

} else {
var statearr_67549_67608 = state_67476__$1;
(statearr_67549_67608[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____0 = (function (){
var statearr_67550 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67550[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__);

(statearr_67550[(1)] = (1));

return statearr_67550;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____1 = (function (state_67476){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_67476);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e67551){var ex__2749__auto__ = e67551;
var statearr_67552_67609 = state_67476;
(statearr_67552_67609[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_67476[(4)]))){
var statearr_67553_67610 = state_67476;
(statearr_67553_67610[(1)] = cljs.core.first.call(null,(state_67476[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67611 = state_67476;
state_67476 = G__67611;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__ = function(state_67476){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____1.call(this,state_67476);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_67554 = f__2769__auto__.call(null);
(statearr_67554[(6)] = c__2768__auto__);

return statearr_67554;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type.call(null,flureeQL);
var G__67612 = query_type;
var G__67612__$1 = (((G__67612 instanceof cljs.core.Keyword))?G__67612.fqn:null);
switch (G__67612__$1) {
case "standard":
return fluree.db.api.query.query_async.call(null,source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async.call(null,source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.call(null,new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async.call(null,conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async.call(null,source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__67612__$1)].join('')));

}
});
