// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.connection_js');
goog.require('fluree.db.query.fql_resp');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__5775__auto__ = [];
var len__5769__auto___69641 = arguments.length;
var i__5770__auto___69642 = (0);
while(true){
if((i__5770__auto___69642 < len__5769__auto___69641)){
args__5775__auto__.push((arguments[i__5770__auto___69642]));

var G__69643 = (i__5770__auto___69642 + (1));
i__5770__auto___69642 = G__69643;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__69570){
var vec__69571 = p__69570;
var opts = cljs.core.nth.call(null,vec__69571,(0),null);
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___69644 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69618){
var state_val_69619 = (state_69618[(1)]);
if((state_val_69619 === (7))){
var inst_69595 = (state_69618[(7)]);
var inst_69604 = (state_69618[(8)]);
var inst_69606 = fluree.db.time_travel.as_of_block.call(null,inst_69604,inst_69595);
var state_69618__$1 = state_69618;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69618__$1,(10),inst_69606);
} else {
if((state_val_69619 === (1))){
var state_69618__$1 = state_69618;
var statearr_69620_69645 = state_69618__$1;
(statearr_69620_69645[(2)] = null);

(statearr_69620_69645[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69619 === (4))){
var inst_69574 = (state_69618[(2)]);
var inst_69575 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69576 = [inst_69574];
var inst_69577 = (new cljs.core.PersistentVector(null,1,(5),inst_69575,inst_69576,null));
var inst_69578 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_69577);
var inst_69579 = cljs.core.async.put_BANG_.call(null,pc,inst_69574);
var inst_69580 = cljs.core.async.close_BANG_.call(null,pc);
var state_69618__$1 = (function (){var statearr_69621 = state_69618;
(statearr_69621[(9)] = inst_69578);

(statearr_69621[(10)] = inst_69579);

return statearr_69621;
})();
var statearr_69622_69646 = state_69618__$1;
(statearr_69622_69646[(2)] = inst_69580);

(statearr_69622_69646[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69619 === (6))){
var inst_69599 = (state_69618[(11)]);
var inst_69598 = (state_69618[(12)]);
var inst_69595 = (state_69618[(7)]);
var inst_69602 = (state_69618[(2)]);
var inst_69603 = fluree.db.util.async.throw_err.call(null,inst_69602);
var inst_69604 = cljs.core.assoc.call(null,inst_69603,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"network","network",2050004697),inst_69598,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),inst_69599);
var state_69618__$1 = (function (){var statearr_69623 = state_69618;
(statearr_69623[(8)] = inst_69604);

return statearr_69623;
})();
if(cljs.core.truth_(inst_69595)){
var statearr_69624_69647 = state_69618__$1;
(statearr_69624_69647[(1)] = (7));

} else {
var statearr_69625_69648 = state_69618__$1;
(statearr_69625_69648[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69619 === (3))){
var inst_69616 = (state_69618[(2)]);
var state_69618__$1 = state_69618;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69618__$1,inst_69616);
} else {
if((state_val_69619 === (2))){
var _ = (function (){var statearr_69627 = state_69618;
(statearr_69627[(4)] = cljs.core.cons.call(null,(5),(state_69618[(4)])));

return statearr_69627;
})();
var inst_69590 = opts;
var inst_69591 = cljs.core.__destructure_map.call(null,inst_69590);
var inst_69592 = cljs.core.get.call(null,inst_69591,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_69593 = cljs.core.get.call(null,inst_69591,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_69594 = cljs.core.get.call(null,inst_69591,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_69595 = cljs.core.get.call(null,inst_69591,new cljs.core.Keyword(null,"block","block",664686210));
var inst_69596 = fluree.db.connection_js.check_connection.call(null,conn,opts);
var inst_69597 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_69598 = cljs.core.nth.call(null,inst_69597,(0),null);
var inst_69599 = cljs.core.nth.call(null,inst_69597,(1),null);
var inst_69600 = fluree.db.session.db.call(null,conn,ledger,opts);
var state_69618__$1 = (function (){var statearr_69628 = state_69618;
(statearr_69628[(13)] = inst_69594);

(statearr_69628[(11)] = inst_69599);

(statearr_69628[(14)] = inst_69596);

(statearr_69628[(15)] = inst_69592);

(statearr_69628[(12)] = inst_69598);

(statearr_69628[(7)] = inst_69595);

(statearr_69628[(16)] = inst_69593);

return statearr_69628;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69618__$1,(6),inst_69600);
} else {
if((state_val_69619 === (9))){
var inst_69612 = (state_69618[(2)]);
var inst_69613 = cljs.core.async.put_BANG_.call(null,pc,inst_69612);
var _ = (function (){var statearr_69629 = state_69618;
(statearr_69629[(4)] = cljs.core.rest.call(null,(state_69618[(4)])));

return statearr_69629;
})();
var state_69618__$1 = state_69618;
var statearr_69630_69649 = state_69618__$1;
(statearr_69630_69649[(2)] = inst_69613);

(statearr_69630_69649[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69619 === (5))){
var _ = (function (){var statearr_69631 = state_69618;
(statearr_69631[(4)] = cljs.core.rest.call(null,(state_69618[(4)])));

return statearr_69631;
})();
var state_69618__$1 = state_69618;
var ex69626 = (state_69618__$1[(2)]);
var statearr_69632_69650 = state_69618__$1;
(statearr_69632_69650[(5)] = ex69626);


var statearr_69633_69651 = state_69618__$1;
(statearr_69633_69651[(1)] = (4));

(statearr_69633_69651[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69619 === (10))){
var inst_69608 = (state_69618[(2)]);
var inst_69609 = fluree.db.util.async.throw_err.call(null,inst_69608);
var state_69618__$1 = state_69618;
var statearr_69634_69652 = state_69618__$1;
(statearr_69634_69652[(2)] = inst_69609);

(statearr_69634_69652[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69619 === (8))){
var inst_69604 = (state_69618[(8)]);
var state_69618__$1 = state_69618;
var statearr_69635_69653 = state_69618__$1;
(statearr_69635_69653[(2)] = inst_69604);

(statearr_69635_69653[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_69636 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69636[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_69636[(1)] = (1));

return statearr_69636;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_69618){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69618);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69637){var ex__2749__auto__ = e69637;
var statearr_69638_69654 = state_69618;
(statearr_69638_69654[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69618[(4)]))){
var statearr_69639_69655 = state_69618;
(statearr_69639_69655[(1)] = cljs.core.first.call(null,(state_69618[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69656 = state_69618;
state_69618 = G__69656;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_69618){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_69618);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69640 = f__2769__auto__.call(null);
(statearr_69640[(6)] = c__2768__auto___69644);

return statearr_69640;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq69567){
var G__69568 = cljs.core.first.call(null,seq69567);
var seq69567__$1 = cljs.core.next.call(null,seq69567);
var G__69569 = cljs.core.first.call(null,seq69567__$1);
var seq69567__$2 = cljs.core.next.call(null,seq69567__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__69568,G__69569,seq69567__$2);
}));

fluree.db.api_js.ledger_ident_QMARK_ = (function fluree$db$api_js$ledger_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(ledger_id){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,ledger_id);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.ledger_ident_QMARK_.call(null,val);
if(and__5043__auto__){
var and__5043__auto____$1 = open_api;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.call(null,network,cljs.core.first.call(null,clojure.string.split.call(null,val,/\//)));
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
var ledger_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.call(null,db_fn,conn,ledger_id,opts);
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.ledger_ident_QMARK_.call(null,val);
if(and__5043__auto__){
return open_api;
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.ledger_ident_QMARK_.call(null,val);
if(and__5043__auto__){
return auth;
} else {
return and__5043__auto__;
}
})())){
var ledger_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var ledger = cljs.core.apply.call(null,db_fn,conn,ledger_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__69658 = arguments.length;
switch (G__69658) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.call(null,sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69787){
var state_val_69788 = (state_69787[(1)]);
if((state_val_69788 === (7))){
var inst_69677 = (state_69787[(7)]);
var inst_69687 = (state_69787[(8)]);
var inst_69689 = fluree.db.time_travel.as_of_block.call(null,inst_69687,inst_69677);
var state_69787__$1 = state_69787;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69787__$1,(10),inst_69689);
} else {
if((state_val_69788 === (20))){
var inst_69681 = (state_69787[(9)]);
var state_69787__$1 = state_69787;
var statearr_69789_69869 = state_69787__$1;
(statearr_69789_69869[(2)] = inst_69681);

(statearr_69789_69869[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (27))){
var inst_69675 = (state_69787[(10)]);
var state_69787__$1 = state_69787;
var statearr_69790_69870 = state_69787__$1;
(statearr_69790_69870[(2)] = inst_69675);

(statearr_69790_69870[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (1))){
var state_69787__$1 = state_69787;
var statearr_69791_69871 = state_69787__$1;
(statearr_69791_69871[(2)] = null);

(statearr_69791_69871[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (24))){
var inst_69684 = (state_69787[(11)]);
var state_69787__$1 = state_69787;
if(cljs.core.truth_(inst_69684)){
var statearr_69792_69872 = state_69787__$1;
(statearr_69792_69872[(1)] = (26));

} else {
var statearr_69793_69873 = state_69787__$1;
(statearr_69793_69873[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (39))){
var inst_69749 = (state_69787[(12)]);
var inst_69752 = cljs.core.ex_data.call(null,inst_69749);
var inst_69753 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69754 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_69752);
var inst_69755 = cljs.core.ex_message.call(null,inst_69749);
var inst_69756 = [inst_69754,inst_69755,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_69757 = cljs.core.PersistentHashMap.fromArrays(inst_69753,inst_69756);
var state_69787__$1 = state_69787;
var statearr_69794_69874 = state_69787__$1;
(statearr_69794_69874[(2)] = inst_69757);

(statearr_69794_69874[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (46))){
var inst_69749 = (state_69787[(12)]);
var state_69787__$1 = state_69787;
var statearr_69795_69875 = state_69787__$1;
(statearr_69795_69875[(2)] = inst_69749);

(statearr_69795_69875[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (4))){
var inst_69659 = (state_69787[(2)]);
var inst_69660 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69661 = [inst_69659];
var inst_69662 = (new cljs.core.PersistentVector(null,1,(5),inst_69660,inst_69661,null));
var inst_69663 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_69662);
var inst_69664 = cljs.core.ex_data.call(null,inst_69659);
var inst_69665 = cljs.core.ex_message.call(null,inst_69659);
var inst_69666 = cljs.core.assoc.call(null,inst_69664,new cljs.core.Keyword(null,"message","message",-406056002),inst_69665);
var state_69787__$1 = (function (){var statearr_69796 = state_69787;
(statearr_69796[(13)] = inst_69663);

return statearr_69796;
})();
var statearr_69797_69876 = state_69787__$1;
(statearr_69797_69876[(2)] = inst_69666);

(statearr_69797_69876[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (15))){
var state_69787__$1 = state_69787;
var statearr_69798_69877 = state_69787__$1;
(statearr_69798_69877[(2)] = (1000000));

(statearr_69798_69877[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (48))){
var inst_69749 = (state_69787[(12)]);
var state_69787__$1 = state_69787;
var statearr_69799_69878 = state_69787__$1;
(statearr_69799_69878[(2)] = inst_69749);

(statearr_69799_69878[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (50))){
var inst_69776 = (state_69787[(2)]);
var state_69787__$1 = state_69787;
var statearr_69800_69879 = state_69787__$1;
(statearr_69800_69879[(2)] = inst_69776);

(statearr_69800_69879[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (21))){
var inst_69680 = (state_69787[(14)]);
var state_69787__$1 = state_69787;
if(cljs.core.truth_(inst_69680)){
var statearr_69801_69880 = state_69787__$1;
(statearr_69801_69880[(1)] = (23));

} else {
var statearr_69802_69881 = state_69787__$1;
(statearr_69802_69881[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (31))){
var inst_69738 = (state_69787[(2)]);
var inst_69739 = cljs.core.not.call(null,inst_69738);
var state_69787__$1 = state_69787;
if(inst_69739){
var statearr_69803_69882 = state_69787__$1;
(statearr_69803_69882[(1)] = (35));

} else {
var statearr_69804_69883 = state_69787__$1;
(statearr_69804_69883[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (32))){
var inst_69682 = (state_69787[(15)]);
var state_69787__$1 = state_69787;
var statearr_69805_69884 = state_69787__$1;
(statearr_69805_69884[(2)] = inst_69682);

(statearr_69805_69884[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (40))){
var inst_69712 = (state_69787[(16)]);
var state_69787__$1 = state_69787;
if(cljs.core.truth_(inst_69712)){
var statearr_69806_69885 = state_69787__$1;
(statearr_69806_69885[(1)] = (42));

} else {
var statearr_69807_69886 = state_69787__$1;
(statearr_69807_69886[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (33))){
var inst_69678 = (state_69787[(17)]);
var state_69787__$1 = state_69787;
var statearr_69808_69887 = state_69787__$1;
(statearr_69808_69887[(2)] = inst_69678);

(statearr_69808_69887[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (13))){
var inst_69707 = (state_69787[(18)]);
var inst_69683 = (state_69787[(19)]);
var inst_69705 = (state_69787[(2)]);
var inst_69706 = cljs.core.volatile_BANG_.call(null,(0));
var inst_69707__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_69683);
var state_69787__$1 = (function (){var statearr_69809 = state_69787;
(statearr_69809[(20)] = inst_69705);

(statearr_69809[(18)] = inst_69707__$1);

(statearr_69809[(21)] = inst_69706);

return statearr_69809;
})();
if(cljs.core.truth_(inst_69707__$1)){
var statearr_69810_69888 = state_69787__$1;
(statearr_69810_69888[(1)] = (14));

} else {
var statearr_69811_69889 = state_69787__$1;
(statearr_69811_69889[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (22))){
var inst_69728 = (state_69787[(2)]);
var state_69787__$1 = state_69787;
var statearr_69812_69890 = state_69787__$1;
(statearr_69812_69890[(2)] = inst_69728);

(statearr_69812_69890[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (36))){
var inst_69695 = (state_69787[(22)]);
var inst_69714 = (state_69787[(23)]);
var inst_69745 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_69714);
var inst_69746 = fluree.db.query.fql.query.call(null,inst_69695,inst_69745);
var state_69787__$1 = state_69787;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69787__$1,(38),inst_69746);
} else {
if((state_val_69788 === (41))){
var inst_69780 = (state_69787[(2)]);
var state_69787__$1 = state_69787;
var statearr_69813_69891 = state_69787__$1;
(statearr_69813_69891[(2)] = inst_69780);

(statearr_69813_69891[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (43))){
var state_69787__$1 = state_69787;
var statearr_69814_69892 = state_69787__$1;
(statearr_69814_69892[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (29))){
var inst_69682 = (state_69787[(15)]);
var state_69787__$1 = state_69787;
if(cljs.core.truth_(inst_69682)){
var statearr_69816_69893 = state_69787__$1;
(statearr_69816_69893[(1)] = (32));

} else {
var statearr_69817_69894 = state_69787__$1;
(statearr_69817_69894[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (44))){
var inst_69778 = (state_69787[(2)]);
var state_69787__$1 = state_69787;
var statearr_69818_69895 = state_69787__$1;
(statearr_69818_69895[(2)] = inst_69778);

(statearr_69818_69895[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (6))){
var inst_69677 = (state_69787[(7)]);
var inst_69686 = (state_69787[(2)]);
var inst_69687 = fluree.db.util.async.throw_err.call(null,inst_69686);
var state_69787__$1 = (function (){var statearr_69819 = state_69787;
(statearr_69819[(8)] = inst_69687);

return statearr_69819;
})();
if(cljs.core.truth_(inst_69677)){
var statearr_69820_69896 = state_69787__$1;
(statearr_69820_69896[(1)] = (7));

} else {
var statearr_69821_69897 = state_69787__$1;
(statearr_69821_69897[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (28))){
var inst_69724 = (state_69787[(2)]);
var state_69787__$1 = state_69787;
var statearr_69822_69898 = state_69787__$1;
(statearr_69822_69898[(2)] = inst_69724);

(statearr_69822_69898[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (25))){
var inst_69726 = (state_69787[(2)]);
var state_69787__$1 = state_69787;
var statearr_69823_69899 = state_69787__$1;
(statearr_69823_69899[(2)] = inst_69726);

(statearr_69823_69899[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (34))){
var inst_69735 = (state_69787[(2)]);
var state_69787__$1 = state_69787;
var statearr_69824_69900 = state_69787__$1;
(statearr_69824_69900[(2)] = inst_69735);

(statearr_69824_69900[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (17))){
var inst_69676 = (state_69787[(24)]);
var state_69787__$1 = state_69787;
var statearr_69825_69901 = state_69787__$1;
(statearr_69825_69901[(2)] = inst_69676);

(statearr_69825_69901[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (3))){
var inst_69785 = (state_69787[(2)]);
var state_69787__$1 = state_69787;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69787__$1,inst_69785);
} else {
if((state_val_69788 === (12))){
var inst_69703 = cljs.core.PersistentHashMap.EMPTY;
var state_69787__$1 = state_69787;
var statearr_69826_69902 = state_69787__$1;
(statearr_69826_69902[(2)] = inst_69703);

(statearr_69826_69902[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (2))){
var _ = (function (){var statearr_69827 = state_69787;
(statearr_69827[(4)] = cljs.core.cons.call(null,(5),(state_69787[(4)])));

return statearr_69827;
})();
var inst_69673 = query_map;
var inst_69674 = cljs.core.__destructure_map.call(null,inst_69673);
var inst_69675 = cljs.core.get.call(null,inst_69674,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_69676 = cljs.core.get.call(null,inst_69674,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_69677 = cljs.core.get.call(null,inst_69674,new cljs.core.Keyword(null,"block","block",664686210));
var inst_69678 = cljs.core.get.call(null,inst_69674,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_69679 = cljs.core.get.call(null,inst_69674,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_69680 = cljs.core.get.call(null,inst_69674,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_69681 = cljs.core.get.call(null,inst_69674,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_69682 = cljs.core.get.call(null,inst_69674,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_69683 = cljs.core.get.call(null,inst_69674,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_69684 = cljs.core.get.call(null,inst_69674,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_69787__$1 = (function (){var statearr_69828 = state_69787;
(statearr_69828[(10)] = inst_69675);

(statearr_69828[(7)] = inst_69677);

(statearr_69828[(9)] = inst_69681);

(statearr_69828[(24)] = inst_69676);

(statearr_69828[(11)] = inst_69684);

(statearr_69828[(25)] = inst_69679);

(statearr_69828[(15)] = inst_69682);

(statearr_69828[(14)] = inst_69680);

(statearr_69828[(19)] = inst_69683);

(statearr_69828[(17)] = inst_69678);

return statearr_69828;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69787__$1,(6),sources);
} else {
if((state_val_69788 === (23))){
var inst_69680 = (state_69787[(14)]);
var state_69787__$1 = state_69787;
var statearr_69829_69903 = state_69787__$1;
(statearr_69829_69903[(2)] = inst_69680);

(statearr_69829_69903[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (47))){
var inst_69695 = (state_69787[(22)]);
var inst_69760 = (state_69787[(26)]);
var inst_69713 = (state_69787[(27)]);
var inst_69706 = (state_69787[(21)]);
var inst_69766 = (state_69787[(2)]);
var inst_69767 = cljs.core.deref.call(null,inst_69706);
var inst_69768 = fluree.db.util.core.response_time_formatted.call(null,inst_69713);
var inst_69769 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_69695);
var inst_69770 = [(200),inst_69766,inst_69767,inst_69768,inst_69769];
var inst_69771 = cljs.core.PersistentHashMap.fromArrays(inst_69760,inst_69770);
var state_69787__$1 = state_69787;
var statearr_69830_69904 = state_69787__$1;
(statearr_69830_69904[(2)] = inst_69771);

(statearr_69830_69904[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (35))){
var inst_69741 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69742 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_69743 = cljs.core.PersistentHashMap.fromArrays(inst_69741,inst_69742);
var state_69787__$1 = state_69787;
var statearr_69831_69905 = state_69787__$1;
(statearr_69831_69905[(2)] = inst_69743);

(statearr_69831_69905[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (19))){
var inst_69730 = (state_69787[(28)]);
var inst_69730__$1 = (state_69787[(2)]);
var state_69787__$1 = (function (){var statearr_69832 = state_69787;
(statearr_69832[(28)] = inst_69730__$1);

return statearr_69832;
})();
if(cljs.core.truth_(inst_69730__$1)){
var statearr_69833_69906 = state_69787__$1;
(statearr_69833_69906[(1)] = (29));

} else {
var statearr_69834_69907 = state_69787__$1;
(statearr_69834_69907[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (11))){
var inst_69695 = (state_69787[(22)]);
var inst_69679 = (state_69787[(25)]);
var inst_69696 = (state_69787[(29)]);
var inst_69698 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_69695);
var inst_69699 = fluree.db.connection_js.open_api_QMARK_.call(null,inst_69696);
var inst_69700 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_69695);
var inst_69701 = fluree.db.api_js.get_sources.call(null,inst_69696,inst_69698,inst_69699,inst_69700,inst_69679,db_fn);
var state_69787__$1 = state_69787;
var statearr_69836_69908 = state_69787__$1;
(statearr_69836_69908[(2)] = inst_69701);

(statearr_69836_69908[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (9))){
var inst_69695 = (state_69787[(22)]);
var inst_69679 = (state_69787[(25)]);
var inst_69695__$1 = (state_69787[(2)]);
var inst_69696 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_69695__$1);
var state_69787__$1 = (function (){var statearr_69837 = state_69787;
(statearr_69837[(22)] = inst_69695__$1);

(statearr_69837[(29)] = inst_69696);

return statearr_69837;
})();
if(cljs.core.truth_(inst_69679)){
var statearr_69838_69909 = state_69787__$1;
(statearr_69838_69909[(1)] = (11));

} else {
var statearr_69839_69910 = state_69787__$1;
(statearr_69839_69910[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (5))){
var _ = (function (){var statearr_69840 = state_69787;
(statearr_69840[(4)] = cljs.core.rest.call(null,(state_69787[(4)])));

return statearr_69840;
})();
var state_69787__$1 = state_69787;
var ex69835 = (state_69787__$1[(2)]);
var statearr_69841_69911 = state_69787__$1;
(statearr_69841_69911[(5)] = ex69835);


var statearr_69842_69912 = state_69787__$1;
(statearr_69842_69912[(1)] = (4));

(statearr_69842_69912[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (14))){
var inst_69707 = (state_69787[(18)]);
var state_69787__$1 = state_69787;
var statearr_69843_69913 = state_69787__$1;
(statearr_69843_69913[(2)] = inst_69707);

(statearr_69843_69913[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (45))){
var inst_69749 = (state_69787[(12)]);
var inst_69763 = cljs.core.doall.call(null,inst_69749);
var state_69787__$1 = state_69787;
var statearr_69844_69914 = state_69787__$1;
(statearr_69844_69914[(2)] = inst_69763);

(statearr_69844_69914[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (26))){
var inst_69684 = (state_69787[(11)]);
var state_69787__$1 = state_69787;
var statearr_69845_69915 = state_69787__$1;
(statearr_69845_69915[(2)] = inst_69684);

(statearr_69845_69915[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (16))){
var inst_69705 = (state_69787[(20)]);
var inst_69676 = (state_69787[(24)]);
var inst_69706 = (state_69787[(21)]);
var inst_69683 = (state_69787[(19)]);
var inst_69711 = (state_69787[(2)]);
var inst_69712 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_69683);
var inst_69713 = fluree.db.util.core.current_time_millis.call(null);
var inst_69714 = cljs.core.assoc.call(null,inst_69683,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_69705,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_69711,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_69706);
var state_69787__$1 = (function (){var statearr_69846 = state_69787;
(statearr_69846[(23)] = inst_69714);

(statearr_69846[(27)] = inst_69713);

(statearr_69846[(16)] = inst_69712);

return statearr_69846;
})();
if(cljs.core.truth_(inst_69676)){
var statearr_69847_69916 = state_69787__$1;
(statearr_69847_69916[(1)] = (17));

} else {
var statearr_69848_69917 = state_69787__$1;
(statearr_69848_69917[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (38))){
var inst_69749 = (state_69787[(12)]);
var inst_69748 = (state_69787[(2)]);
var inst_69749__$1 = fluree.db.util.async.throw_err.call(null,inst_69748);
var inst_69750 = (inst_69749__$1 instanceof cljs.core.ExceptionInfo);
var state_69787__$1 = (function (){var statearr_69849 = state_69787;
(statearr_69849[(12)] = inst_69749__$1);

return statearr_69849;
})();
if(cljs.core.truth_(inst_69750)){
var statearr_69850_69918 = state_69787__$1;
(statearr_69850_69918[(1)] = (39));

} else {
var statearr_69851_69919 = state_69787__$1;
(statearr_69851_69919[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (30))){
var inst_69730 = (state_69787[(28)]);
var state_69787__$1 = state_69787;
var statearr_69852_69920 = state_69787__$1;
(statearr_69852_69920[(2)] = inst_69730);

(statearr_69852_69920[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (10))){
var inst_69691 = (state_69787[(2)]);
var inst_69692 = fluree.db.util.async.throw_err.call(null,inst_69691);
var state_69787__$1 = state_69787;
var statearr_69853_69921 = state_69787__$1;
(statearr_69853_69921[(2)] = inst_69692);

(statearr_69853_69921[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (18))){
var inst_69681 = (state_69787[(9)]);
var state_69787__$1 = state_69787;
if(cljs.core.truth_(inst_69681)){
var statearr_69854_69922 = state_69787__$1;
(statearr_69854_69922[(1)] = (20));

} else {
var statearr_69855_69923 = state_69787__$1;
(statearr_69855_69923[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (42))){
var inst_69749 = (state_69787[(12)]);
var inst_69760 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_69761 = cljs.core.sequential_QMARK_.call(null,inst_69749);
var state_69787__$1 = (function (){var statearr_69856 = state_69787;
(statearr_69856[(26)] = inst_69760);

return statearr_69856;
})();
if(inst_69761){
var statearr_69857_69924 = state_69787__$1;
(statearr_69857_69924[(1)] = (45));

} else {
var statearr_69858_69925 = state_69787__$1;
(statearr_69858_69925[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (37))){
var inst_69782 = (state_69787[(2)]);
var _ = (function (){var statearr_69859 = state_69787;
(statearr_69859[(4)] = cljs.core.rest.call(null,(state_69787[(4)])));

return statearr_69859;
})();
var state_69787__$1 = state_69787;
var statearr_69860_69926 = state_69787__$1;
(statearr_69860_69926[(2)] = inst_69782);

(statearr_69860_69926[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (8))){
var inst_69687 = (state_69787[(8)]);
var state_69787__$1 = state_69787;
var statearr_69861_69927 = state_69787__$1;
(statearr_69861_69927[(2)] = inst_69687);

(statearr_69861_69927[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69788 === (49))){
var state_69787__$1 = state_69787;
var statearr_69862_69928 = state_69787__$1;
(statearr_69862_69928[(2)] = null);

(statearr_69862_69928[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_69863 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69863[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_69863[(1)] = (1));

return statearr_69863;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_69787){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69787);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69864){var ex__2749__auto__ = e69864;
var statearr_69865_69929 = state_69787;
(statearr_69865_69929[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69787[(4)]))){
var statearr_69866_69930 = state_69787;
(statearr_69866_69930[(1)] = cljs.core.first.call(null,(state_69787[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69931 = state_69787;
state_69787 = G__69931;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_69787){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_69787);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69867 = f__2769__auto__.call(null);
(statearr_69867[(6)] = c__2768__auto__);

return statearr_69867;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_.call(null,timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.call(null,conn,ledger);
var key = cljs.core.random_uuid.call(null);
var resp_chan = cljs.core.async.chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout_ms);
fluree.db.session.monitor_tx.call(null,session,tid,key,(function (p1__69932_SHARP_){
return cljs.core.async.put_BANG_.call(null,resp_chan,p1__69932_SHARP_);
}));

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69954){
var state_val_69955 = (state_69954[(1)]);
if((state_val_69955 === (1))){
var inst_69936 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69937 = [resp_chan,timeout_chan];
var inst_69938 = (new cljs.core.PersistentVector(null,2,(5),inst_69936,inst_69937,null));
var state_69954__$1 = state_69954;
return cljs.core.async.ioc_alts_BANG_.call(null,state_69954__$1,(2),inst_69938);
} else {
if((state_val_69955 === (2))){
var inst_69940 = (state_69954[(2)]);
var inst_69941 = cljs.core.nth.call(null,inst_69940,(0),null);
var inst_69942 = cljs.core.nth.call(null,inst_69940,(1),null);
var inst_69943 = cljs.core._EQ_.call(null,timeout_chan,inst_69942);
var state_69954__$1 = (function (){var statearr_69956 = state_69954;
(statearr_69956[(7)] = inst_69941);

return statearr_69956;
})();
if(inst_69943){
var statearr_69957_69967 = state_69954__$1;
(statearr_69957_69967[(1)] = (3));

} else {
var statearr_69958_69968 = state_69954__$1;
(statearr_69958_69968[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69955 === (3))){
var inst_69945 = fluree.db.session.monitor_tx_remove.call(null,session,tid,key);
var inst_69946 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_69947 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_69948 = [tid,(408),inst_69947];
var inst_69949 = cljs.core.PersistentHashMap.fromArrays(inst_69946,inst_69948);
var state_69954__$1 = (function (){var statearr_69959 = state_69954;
(statearr_69959[(8)] = inst_69945);

return statearr_69959;
})();
var statearr_69960_69969 = state_69954__$1;
(statearr_69960_69969[(2)] = inst_69949);

(statearr_69960_69969[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69955 === (4))){
var inst_69941 = (state_69954[(7)]);
var state_69954__$1 = state_69954;
var statearr_69961_69970 = state_69954__$1;
(statearr_69961_69970[(2)] = inst_69941);

(statearr_69961_69970[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69955 === (5))){
var inst_69952 = (state_69954[(2)]);
var state_69954__$1 = state_69954;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69954__$1,inst_69952);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____0 = (function (){
var statearr_69962 = [null,null,null,null,null,null,null,null,null];
(statearr_69962[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__);

(statearr_69962[(1)] = (1));

return statearr_69962;
});
var fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____1 = (function (state_69954){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69954);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69963){var ex__2749__auto__ = e69963;
var statearr_69964_69971 = state_69954;
(statearr_69964_69971[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69954[(4)]))){
var statearr_69965_69972 = state_69954;
(statearr_69965_69972[(1)] = cljs.core.first.call(null,(state_69954[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69973 = state_69954;
state_69954 = G__69973;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__ = function(state_69954){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____1.call(this,state_69954);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69966 = f__2769__auto__.call(null);
(statearr_69966[(6)] = c__2768__auto__);

return statearr_69966;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd    - a map with the command/transaction data as a JSON string
 *  - sig    - the signature of the above stringified map
 *  - id     - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - ledger - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__69975 = arguments.length;
switch (G__69975) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.call(null,ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var ledger_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__69976 = opts;
var map__69976__$1 = cljs.core.__destructure_map.call(null,map__69976);
var auth = cljs.core.get.call(null,map__69976__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__69976__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__69976__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.call(null,map__69976__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_.call(null,deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__69977 = (cljs.core.truth_((function (){var and__5043__auto__ = auth;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__5043__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__69977,(0),null);
var authority = cljs.core.nth.call(null,vec__69977,(1),null);
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__5045__auto__ = nonce;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__5045__auto__ = expire;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e69980){var e = e69980;

throw cljs.core.ex_info.call(null,"Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__69983 = arguments.length;
switch (G__69983) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.call(null,conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70052){
var state_val_70053 = (state_70052[(1)]);
if((state_val_70053 === (7))){
var inst_70007 = (state_70052[(7)]);
var inst_70006 = (state_70052[(8)]);
var inst_70003 = (state_70052[(9)]);
var inst_70005 = (state_70052[(10)]);
var inst_70008 = (state_70052[(11)]);
var inst_70021 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_70022 = [ledger,txn,inst_70003,inst_70005,inst_70006,inst_70007,inst_70008];
var inst_70023 = cljs.core.PersistentHashMap.fromArrays(inst_70021,inst_70022);
var inst_70024 = fluree.db.util.core.without_nils.call(null,inst_70023);
var inst_70025 = fluree.db.operations.transact_async.call(null,conn,inst_70024);
var state_70052__$1 = state_70052;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70052__$1,(13),inst_70025);
} else {
if((state_val_70053 === (20))){
var inst_70043 = (state_70052[(2)]);
var state_70052__$1 = state_70052;
var statearr_70054_70090 = state_70052__$1;
(statearr_70054_70090[(2)] = inst_70043);

(statearr_70054_70090[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70053 === (1))){
var state_70052__$1 = state_70052;
var statearr_70055_70091 = state_70052__$1;
(statearr_70055_70091[(2)] = null);

(statearr_70055_70091[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70053 === (4))){
var inst_69984 = (state_70052[(2)]);
var inst_69985 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69986 = [inst_69984];
var inst_69987 = (new cljs.core.PersistentVector(null,1,(5),inst_69985,inst_69986,null));
var inst_69988 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_69987);
var inst_69989 = cljs.core.ex_data.call(null,inst_69984);
var inst_69990 = cljs.core.ex_message.call(null,inst_69984);
var inst_69991 = cljs.core.assoc.call(null,inst_69989,new cljs.core.Keyword(null,"message","message",-406056002),inst_69990);
var state_70052__$1 = (function (){var statearr_70056 = state_70052;
(statearr_70056[(12)] = inst_69988);

return statearr_70056;
})();
var statearr_70057_70092 = state_70052__$1;
(statearr_70057_70092[(2)] = inst_69991);

(statearr_70057_70092[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70053 === (15))){
var inst_70002 = (state_70052[(13)]);
var inst_70027 = (state_70052[(14)]);
var inst_70030 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_70027,inst_70002);
var state_70052__$1 = state_70052;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70052__$1,(17),inst_70030);
} else {
if((state_val_70053 === (13))){
var inst_70001 = (state_70052[(15)]);
var inst_70027 = (state_70052[(2)]);
var state_70052__$1 = (function (){var statearr_70058 = state_70052;
(statearr_70058[(14)] = inst_70027);

return statearr_70058;
})();
if(cljs.core.truth_(inst_70001)){
var statearr_70059_70093 = state_70052__$1;
(statearr_70059_70093[(1)] = (14));

} else {
var statearr_70060_70094 = state_70052__$1;
(statearr_70060_70094[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70053 === (6))){
var inst_70001 = (state_70052[(15)]);
var inst_70000 = (state_70052[(16)]);
var inst_70010 = fluree.db.api_js.tx__GT_command.call(null,ledger,txn,inst_70000,opts);
var inst_70011 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_70010);
var inst_70012 = fluree.db.operations.command_async.call(null,conn,inst_70010);
var state_70052__$1 = (function (){var statearr_70061 = state_70052;
(statearr_70061[(17)] = inst_70012);

(statearr_70061[(18)] = inst_70011);

return statearr_70061;
})();
if(cljs.core.truth_(inst_70001)){
var statearr_70062_70095 = state_70052__$1;
(statearr_70062_70095[(1)] = (9));

} else {
var statearr_70063_70096 = state_70052__$1;
(statearr_70063_70096[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70053 === (17))){
var inst_70032 = (state_70052[(19)]);
var inst_70032__$1 = (state_70052[(2)]);
var inst_70033 = (inst_70032__$1 instanceof cljs.core.ExceptionInfo);
var state_70052__$1 = (function (){var statearr_70064 = state_70052;
(statearr_70064[(19)] = inst_70032__$1);

return statearr_70064;
})();
if(cljs.core.truth_(inst_70033)){
var statearr_70065_70097 = state_70052__$1;
(statearr_70065_70097[(1)] = (18));

} else {
var statearr_70066_70098 = state_70052__$1;
(statearr_70066_70098[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70053 === (3))){
var inst_70050 = (state_70052[(2)]);
var state_70052__$1 = state_70052;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70052__$1,inst_70050);
} else {
if((state_val_70053 === (12))){
var inst_70017 = (state_70052[(2)]);
var state_70052__$1 = state_70052;
var statearr_70067_70099 = state_70052__$1;
(statearr_70067_70099[(2)] = inst_70017);

(statearr_70067_70099[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70053 === (2))){
var inst_70000 = (state_70052[(16)]);
var _ = (function (){var statearr_70068 = state_70052;
(statearr_70068[(4)] = cljs.core.cons.call(null,(5),(state_70052[(4)])));

return statearr_70068;
})();
var inst_69998 = opts;
var inst_69999 = cljs.core.__destructure_map.call(null,inst_69998);
var inst_70000__$1 = cljs.core.get.call(null,inst_69999,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_70001 = cljs.core.get.call(null,inst_69999,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_70002 = cljs.core.get.call(null,inst_69999,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_70003 = cljs.core.get.call(null,inst_69999,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_70004 = fluree.db.util.core.current_time_millis.call(null);
var inst_70005 = cljs.core.get.call(null,inst_69999,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_70004);
var inst_70006 = cljs.core.get.call(null,inst_69999,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_70007 = cljs.core.get.call(null,inst_69999,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_70008 = cljs.core.get.call(null,inst_69999,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_70052__$1 = (function (){var statearr_70069 = state_70052;
(statearr_70069[(7)] = inst_70007);

(statearr_70069[(15)] = inst_70001);

(statearr_70069[(8)] = inst_70006);

(statearr_70069[(9)] = inst_70003);

(statearr_70069[(10)] = inst_70005);

(statearr_70069[(13)] = inst_70002);

(statearr_70069[(16)] = inst_70000__$1);

(statearr_70069[(11)] = inst_70008);

return statearr_70069;
})();
if(cljs.core.truth_(inst_70000__$1)){
var statearr_70070_70100 = state_70052__$1;
(statearr_70070_70100[(1)] = (6));

} else {
var statearr_70071_70101 = state_70052__$1;
(statearr_70071_70101[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70053 === (19))){
var inst_70032 = (state_70052[(19)]);
var state_70052__$1 = state_70052;
var statearr_70072_70102 = state_70052__$1;
(statearr_70072_70102[(2)] = inst_70032);

(statearr_70072_70102[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70053 === (11))){
var inst_70019 = (state_70052[(2)]);
var state_70052__$1 = state_70052;
var statearr_70074_70103 = state_70052__$1;
(statearr_70074_70103[(2)] = inst_70019);

(statearr_70074_70103[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70053 === (9))){
var inst_70012 = (state_70052[(17)]);
var state_70052__$1 = state_70052;
var statearr_70075_70104 = state_70052__$1;
(statearr_70075_70104[(2)] = inst_70012);

(statearr_70075_70104[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70053 === (5))){
var _ = (function (){var statearr_70076 = state_70052;
(statearr_70076[(4)] = cljs.core.rest.call(null,(state_70052[(4)])));

return statearr_70076;
})();
var state_70052__$1 = state_70052;
var ex70073 = (state_70052__$1[(2)]);
var statearr_70077_70105 = state_70052__$1;
(statearr_70077_70105[(5)] = ex70073);


var statearr_70078_70106 = state_70052__$1;
(statearr_70078_70106[(1)] = (4));

(statearr_70078_70106[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70053 === (14))){
var inst_70027 = (state_70052[(14)]);
var state_70052__$1 = state_70052;
var statearr_70079_70107 = state_70052__$1;
(statearr_70079_70107[(2)] = inst_70027);

(statearr_70079_70107[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70053 === (16))){
var inst_70045 = (state_70052[(2)]);
var state_70052__$1 = state_70052;
var statearr_70080_70108 = state_70052__$1;
(statearr_70080_70108[(2)] = inst_70045);

(statearr_70080_70108[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70053 === (10))){
var inst_70002 = (state_70052[(13)]);
var inst_70011 = (state_70052[(18)]);
var inst_70015 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_70011,inst_70002);
var state_70052__$1 = state_70052;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70052__$1,(12),inst_70015);
} else {
if((state_val_70053 === (18))){
var inst_70032 = (state_70052[(19)]);
var inst_70035 = cljs.core.ex_data.call(null,inst_70032);
var inst_70036 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70037 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_70035);
var inst_70038 = cljs.core.ex_message.call(null,inst_70032);
var inst_70039 = [inst_70037,inst_70038,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_70040 = cljs.core.PersistentHashMap.fromArrays(inst_70036,inst_70039);
var state_70052__$1 = state_70052;
var statearr_70081_70109 = state_70052__$1;
(statearr_70081_70109[(2)] = inst_70040);

(statearr_70081_70109[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70053 === (8))){
var inst_70047 = (state_70052[(2)]);
var _ = (function (){var statearr_70082 = state_70052;
(statearr_70082[(4)] = cljs.core.rest.call(null,(state_70052[(4)])));

return statearr_70082;
})();
var state_70052__$1 = state_70052;
var statearr_70083_70110 = state_70052__$1;
(statearr_70083_70110[(2)] = inst_70047);

(statearr_70083_70110[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_70084 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70084[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_70084[(1)] = (1));

return statearr_70084;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_70052){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70052);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70085){var ex__2749__auto__ = e70085;
var statearr_70086_70111 = state_70052;
(statearr_70086_70111[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70052[(4)]))){
var statearr_70087_70112 = state_70052;
(statearr_70087_70112[(1)] = cljs.core.first.call(null,(state_70052[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70113 = state_70052;
state_70052 = G__70113;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_70052){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_70052);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70088 = f__2769__auto__.call(null);
(statearr_70088[(6)] = c__2768__auto__);

return statearr_70088;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__5775__auto__ = [];
var len__5769__auto___70115 = arguments.length;
var i__5770__auto___70116 = (0);
while(true){
if((i__5770__auto___70116 < len__5769__auto___70115)){
args__5775__auto__.push((arguments[i__5770__auto___70116]));

var G__70117 = (i__5770__auto___70116 + (1));
i__5770__auto___70116 = G__70117;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq70114){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq70114));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70148){
var state_val_70149 = (state_70148[(1)]);
if((state_val_70149 === (1))){
var inst_70118 = cljs.core.first.call(null,flakes);
var inst_70119 = cljs.core.rest.call(null,flakes);
var inst_70120 = cljs.core.PersistentVector.EMPTY;
var inst_70121 = inst_70118;
var inst_70122 = inst_70119;
var inst_70123 = inst_70120;
var state_70148__$1 = (function (){var statearr_70150 = state_70148;
(statearr_70150[(7)] = inst_70121);

(statearr_70150[(8)] = inst_70123);

(statearr_70150[(9)] = inst_70122);

return statearr_70150;
})();
var statearr_70151_70164 = state_70148__$1;
(statearr_70151_70164[(2)] = null);

(statearr_70151_70164[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70149 === (2))){
var inst_70121 = (state_70148[(7)]);
var inst_70125 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_70126 = cljs.core.PersistentHashMap.EMPTY;
var inst_70127 = [true,inst_70126];
var inst_70128 = cljs.core.PersistentHashMap.fromArrays(inst_70125,inst_70127);
var inst_70129 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_70128,inst_70121);
var state_70148__$1 = state_70148;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70148__$1,(4),inst_70129);
} else {
if((state_val_70149 === (3))){
var inst_70146 = (state_70148[(2)]);
var state_70148__$1 = state_70148;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70148__$1,inst_70146);
} else {
if((state_val_70149 === (4))){
var inst_70123 = (state_70148[(8)]);
var inst_70122 = (state_70148[(9)]);
var inst_70131 = (state_70148[(2)]);
var inst_70132 = fluree.db.util.async.throw_err.call(null,inst_70131);
var inst_70133 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70134 = [inst_70132];
var inst_70135 = (new cljs.core.PersistentVector(null,1,(5),inst_70133,inst_70134,null));
var inst_70136 = cljs.core.concat.call(null,inst_70123,inst_70135);
var inst_70137 = cljs.core.first.call(null,inst_70122);
var state_70148__$1 = (function (){var statearr_70152 = state_70148;
(statearr_70152[(10)] = inst_70136);

return statearr_70152;
})();
if(cljs.core.truth_(inst_70137)){
var statearr_70153_70165 = state_70148__$1;
(statearr_70153_70165[(1)] = (5));

} else {
var statearr_70154_70166 = state_70148__$1;
(statearr_70154_70166[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70149 === (5))){
var inst_70136 = (state_70148[(10)]);
var inst_70122 = (state_70148[(9)]);
var inst_70139 = cljs.core.first.call(null,inst_70122);
var inst_70140 = cljs.core.rest.call(null,inst_70122);
var inst_70121 = inst_70139;
var inst_70122__$1 = inst_70140;
var inst_70123 = inst_70136;
var state_70148__$1 = (function (){var statearr_70155 = state_70148;
(statearr_70155[(7)] = inst_70121);

(statearr_70155[(8)] = inst_70123);

(statearr_70155[(9)] = inst_70122__$1);

return statearr_70155;
})();
var statearr_70156_70167 = state_70148__$1;
(statearr_70156_70167[(2)] = null);

(statearr_70156_70167[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70149 === (6))){
var inst_70136 = (state_70148[(10)]);
var state_70148__$1 = state_70148;
var statearr_70157_70168 = state_70148__$1;
(statearr_70157_70168[(2)] = inst_70136);

(statearr_70157_70168[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70149 === (7))){
var inst_70144 = (state_70148[(2)]);
var state_70148__$1 = state_70148;
var statearr_70158_70169 = state_70148__$1;
(statearr_70158_70169[(2)] = inst_70144);

(statearr_70158_70169[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____0 = (function (){
var statearr_70159 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_70159[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__);

(statearr_70159[(1)] = (1));

return statearr_70159;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____1 = (function (state_70148){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70148);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70160){var ex__2749__auto__ = e70160;
var statearr_70161_70170 = state_70148;
(statearr_70161_70170[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70148[(4)]))){
var statearr_70162_70171 = state_70148;
(statearr_70162_70171[(1)] = cljs.core.first.call(null,(state_70148[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70172 = state_70148;
state_70148 = G__70172;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__ = function(state_70148){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____1.call(this,state_70148);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70163 = f__2769__auto__.call(null);
(statearr_70163[(6)] = c__2768__auto__);

return statearr_70163;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70240){
var state_val_70241 = (state_70240[(1)]);
if((state_val_70241 === (7))){
var inst_70200 = (state_70240[(2)]);
var inst_70201 = fluree.db.util.async.throw_err.call(null,inst_70200);
var state_70240__$1 = state_70240;
var statearr_70242_70268 = state_70240__$1;
(statearr_70242_70268[(2)] = inst_70201);

(statearr_70242_70268[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70241 === (1))){
var inst_70177 = cljs.core.volatile_BANG_.call(null,(0));
var inst_70178 = cljs.core.PersistentHashMap.EMPTY;
var inst_70179 = cljs.core.volatile_BANG_.call(null,inst_70178);
var inst_70180 = cljs.core.first.call(null,resp);
var inst_70181 = cljs.core.rest.call(null,resp);
var inst_70182 = cljs.core.PersistentVector.EMPTY;
var inst_70183 = inst_70177;
var inst_70184 = inst_70179;
var inst_70185 = inst_70180;
var inst_70186 = inst_70181;
var inst_70187 = inst_70182;
var state_70240__$1 = (function (){var statearr_70243 = state_70240;
(statearr_70243[(7)] = inst_70184);

(statearr_70243[(8)] = inst_70183);

(statearr_70243[(9)] = inst_70185);

(statearr_70243[(10)] = inst_70187);

(statearr_70243[(11)] = inst_70186);

return statearr_70243;
})();
var statearr_70244_70269 = state_70240__$1;
(statearr_70244_70269[(2)] = null);

(statearr_70244_70269[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70241 === (4))){
var inst_70184 = (state_70240[(7)]);
var inst_70191 = (state_70240[(12)]);
var inst_70183 = (state_70240[(8)]);
var inst_70185 = (state_70240[(9)]);
var inst_70187 = (state_70240[(10)]);
var inst_70186 = (state_70240[(11)]);
var inst_70189 = (state_70240[(13)]);
var inst_70195 = (function (){var fuel = inst_70183;
var cache = inst_70184;
var curr_block = inst_70185;
var rest_blocks = inst_70186;
var acc = inst_70187;
var flakes = inst_70189;
var asserted = inst_70191;
return (function (p1__70174_SHARP_){
return p1__70174_SHARP_.s;
});
})();
var inst_70196 = cljs.core.group_by.call(null,inst_70195,inst_70191);
var inst_70197 = cljs.core.vals.call(null,inst_70196);
var inst_70198 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_70184,inst_70183,inst_70197);
var state_70240__$1 = state_70240;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70240__$1,(7),inst_70198);
} else {
if((state_val_70241 === (13))){
var inst_70228 = (state_70240[(14)]);
var state_70240__$1 = state_70240;
var statearr_70245_70270 = state_70240__$1;
(statearr_70245_70270[(2)] = inst_70228);

(statearr_70245_70270[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70241 === (6))){
var inst_70184 = (state_70240[(7)]);
var inst_70191 = (state_70240[(12)]);
var inst_70183 = (state_70240[(8)]);
var inst_70206 = (state_70240[(15)]);
var inst_70185 = (state_70240[(9)]);
var inst_70187 = (state_70240[(10)]);
var inst_70186 = (state_70240[(11)]);
var inst_70204 = (state_70240[(16)]);
var inst_70189 = (state_70240[(13)]);
var inst_70204__$1 = (state_70240[(2)]);
var inst_70205 = (function (){var fuel = inst_70183;
var cache = inst_70184;
var curr_block = inst_70185;
var rest_blocks = inst_70186;
var acc = inst_70187;
var flakes = inst_70189;
var asserted = inst_70191;
var asserted_SINGLEQUOTE_ = inst_70204__$1;
return (function (p1__70175_SHARP_){
return p1__70175_SHARP_.op === false;
});
})();
var inst_70206__$1 = cljs.core.filter.call(null,inst_70205,inst_70189);
var inst_70207 = cljs.core.empty_QMARK_.call(null,inst_70206__$1);
var inst_70208 = (!(inst_70207));
var state_70240__$1 = (function (){var statearr_70248 = state_70240;
(statearr_70248[(15)] = inst_70206__$1);

(statearr_70248[(16)] = inst_70204__$1);

return statearr_70248;
})();
if(inst_70208){
var statearr_70249_70271 = state_70240__$1;
(statearr_70249_70271[(1)] = (8));

} else {
var statearr_70250_70272 = state_70240__$1;
(statearr_70250_70272[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70241 === (3))){
var inst_70238 = (state_70240[(2)]);
var state_70240__$1 = state_70240;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70240__$1,inst_70238);
} else {
if((state_val_70241 === (12))){
var inst_70184 = (state_70240[(7)]);
var inst_70228 = (state_70240[(14)]);
var inst_70183 = (state_70240[(8)]);
var inst_70186 = (state_70240[(11)]);
var inst_70231 = cljs.core.first.call(null,inst_70186);
var inst_70232 = cljs.core.rest.call(null,inst_70186);
var tmp70246 = inst_70184;
var tmp70247 = inst_70183;
var inst_70183__$1 = tmp70247;
var inst_70184__$1 = tmp70246;
var inst_70185 = inst_70231;
var inst_70186__$1 = inst_70232;
var inst_70187 = inst_70228;
var state_70240__$1 = (function (){var statearr_70251 = state_70240;
(statearr_70251[(7)] = inst_70184__$1);

(statearr_70251[(8)] = inst_70183__$1);

(statearr_70251[(9)] = inst_70185);

(statearr_70251[(10)] = inst_70187);

(statearr_70251[(11)] = inst_70186__$1);

return statearr_70251;
})();
var statearr_70252_70273 = state_70240__$1;
(statearr_70252_70273[(2)] = null);

(statearr_70252_70273[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70241 === (2))){
var inst_70184 = (state_70240[(7)]);
var inst_70191 = (state_70240[(12)]);
var inst_70183 = (state_70240[(8)]);
var inst_70185 = (state_70240[(9)]);
var inst_70187 = (state_70240[(10)]);
var inst_70186 = (state_70240[(11)]);
var inst_70189 = (state_70240[(13)]);
var inst_70189__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_70185);
var inst_70190 = (function (){var fuel = inst_70183;
var cache = inst_70184;
var curr_block = inst_70185;
var rest_blocks = inst_70186;
var acc = inst_70187;
var flakes = inst_70189__$1;
return (function (p1__70173_SHARP_){
return p1__70173_SHARP_.op;
});
})();
var inst_70191__$1 = cljs.core.filter.call(null,inst_70190,inst_70189__$1);
var inst_70192 = cljs.core.empty_QMARK_.call(null,inst_70191__$1);
var inst_70193 = (!(inst_70192));
var state_70240__$1 = (function (){var statearr_70253 = state_70240;
(statearr_70253[(12)] = inst_70191__$1);

(statearr_70253[(13)] = inst_70189__$1);

return statearr_70253;
})();
if(inst_70193){
var statearr_70254_70274 = state_70240__$1;
(statearr_70254_70274[(1)] = (4));

} else {
var statearr_70255_70275 = state_70240__$1;
(statearr_70255_70275[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70241 === (11))){
var inst_70216 = (state_70240[(2)]);
var inst_70217 = fluree.db.util.async.throw_err.call(null,inst_70216);
var state_70240__$1 = state_70240;
var statearr_70256_70276 = state_70240__$1;
(statearr_70256_70276[(2)] = inst_70217);

(statearr_70256_70276[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70241 === (9))){
var state_70240__$1 = state_70240;
var statearr_70257_70277 = state_70240__$1;
(statearr_70257_70277[(2)] = null);

(statearr_70257_70277[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70241 === (5))){
var state_70240__$1 = state_70240;
var statearr_70258_70278 = state_70240__$1;
(statearr_70258_70278[(2)] = null);

(statearr_70258_70278[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70241 === (14))){
var inst_70236 = (state_70240[(2)]);
var state_70240__$1 = state_70240;
var statearr_70259_70279 = state_70240__$1;
(statearr_70259_70279[(2)] = inst_70236);

(statearr_70259_70279[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70241 === (10))){
var inst_70185 = (state_70240[(9)]);
var inst_70187 = (state_70240[(10)]);
var inst_70186 = (state_70240[(11)]);
var inst_70204 = (state_70240[(16)]);
var inst_70220 = (state_70240[(2)]);
var inst_70221 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_70222 = [inst_70204,inst_70220];
var inst_70223 = cljs.core.PersistentHashMap.fromArrays(inst_70221,inst_70222);
var inst_70224 = cljs.core.assoc.call(null,inst_70185,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_70223);
var inst_70225 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70226 = [inst_70224];
var inst_70227 = (new cljs.core.PersistentVector(null,1,(5),inst_70225,inst_70226,null));
var inst_70228 = cljs.core.concat.call(null,inst_70187,inst_70227);
var inst_70229 = cljs.core.first.call(null,inst_70186);
var state_70240__$1 = (function (){var statearr_70260 = state_70240;
(statearr_70260[(14)] = inst_70228);

return statearr_70260;
})();
if(cljs.core.truth_(inst_70229)){
var statearr_70261_70280 = state_70240__$1;
(statearr_70261_70280[(1)] = (12));

} else {
var statearr_70262_70281 = state_70240__$1;
(statearr_70262_70281[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70241 === (8))){
var inst_70184 = (state_70240[(7)]);
var inst_70191 = (state_70240[(12)]);
var inst_70183 = (state_70240[(8)]);
var inst_70206 = (state_70240[(15)]);
var inst_70185 = (state_70240[(9)]);
var inst_70187 = (state_70240[(10)]);
var inst_70186 = (state_70240[(11)]);
var inst_70204 = (state_70240[(16)]);
var inst_70189 = (state_70240[(13)]);
var inst_70210 = (function (){var flakes = inst_70189;
var rest_blocks = inst_70186;
var curr_block = inst_70185;
var asserted_SINGLEQUOTE_ = inst_70204;
var acc = inst_70187;
var fuel = inst_70183;
var cache = inst_70184;
var retracted = inst_70206;
var asserted = inst_70191;
return (function (p1__70176_SHARP_){
return p1__70176_SHARP_.s;
});
})();
var inst_70211 = cljs.core.map.call(null,fluree.db.flake.flip_flake,inst_70206);
var inst_70212 = cljs.core.group_by.call(null,inst_70210,inst_70211);
var inst_70213 = cljs.core.vals.call(null,inst_70212);
var inst_70214 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_70184,inst_70183,inst_70213);
var state_70240__$1 = state_70240;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70240__$1,(11),inst_70214);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____0 = (function (){
var statearr_70263 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70263[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__);

(statearr_70263[(1)] = (1));

return statearr_70263;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____1 = (function (state_70240){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70240);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70264){var ex__2749__auto__ = e70264;
var statearr_70265_70282 = state_70240;
(statearr_70265_70282[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70240[(4)]))){
var statearr_70266_70283 = state_70240;
(statearr_70266_70283[(1)] = cljs.core.first.call(null,(state_70240[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70284 = state_70240;
state_70240 = G__70284;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__ = function(state_70240){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____1.call(this,state_70240);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70267 = f__2769__auto__.call(null);
(statearr_70267[(6)] = c__2768__auto__);

return statearr_70267;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70384){
var state_val_70385 = (state_70384[(1)]);
if((state_val_70385 === (7))){
var inst_70356 = (state_70384[(7)]);
var inst_70349 = (state_70384[(8)]);
var inst_70355 = cljs.core.seq.call(null,inst_70349);
var inst_70356__$1 = cljs.core.first.call(null,inst_70355);
var inst_70357 = cljs.core.next.call(null,inst_70355);
var state_70384__$1 = (function (){var statearr_70386 = state_70384;
(statearr_70386[(7)] = inst_70356__$1);

(statearr_70386[(9)] = inst_70357);

return statearr_70386;
})();
if(cljs.core.truth_(inst_70356__$1)){
var statearr_70387_70424 = state_70384__$1;
(statearr_70387_70424[(1)] = (9));

} else {
var statearr_70388_70425 = state_70384__$1;
(statearr_70388_70425[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70385 === (1))){
var state_70384__$1 = state_70384;
var statearr_70389_70426 = state_70384__$1;
(statearr_70389_70426[(2)] = null);

(statearr_70389_70426[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70385 === (4))){
var inst_70286 = (state_70384[(2)]);
var state_70384__$1 = state_70384;
var statearr_70390_70427 = state_70384__$1;
(statearr_70390_70427[(2)] = inst_70286);

(statearr_70390_70427[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70385 === (6))){
var inst_70335 = (state_70384[(2)]);
var inst_70336 = fluree.db.util.async.throw_err.call(null,inst_70335);
var inst_70344 = resp;
var inst_70345 = cljs.core.seq.call(null,inst_70344);
var inst_70346 = cljs.core.first.call(null,inst_70345);
var inst_70347 = cljs.core.next.call(null,inst_70345);
var inst_70348 = cljs.core.PersistentHashMap.EMPTY;
var inst_70349 = inst_70344;
var inst_70350 = inst_70348;
var state_70384__$1 = (function (){var statearr_70391 = state_70384;
(statearr_70391[(10)] = inst_70336);

(statearr_70391[(11)] = inst_70347);

(statearr_70391[(12)] = inst_70350);

(statearr_70391[(13)] = inst_70346);

(statearr_70391[(8)] = inst_70349);

return statearr_70391;
})();
var statearr_70392_70428 = state_70384__$1;
(statearr_70392_70428[(2)] = null);

(statearr_70392_70428[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70385 === (3))){
var inst_70382 = (state_70384[(2)]);
var state_70384__$1 = state_70384;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70384__$1,inst_70382);
} else {
if((state_val_70385 === (2))){
var _ = (function (){var statearr_70393 = state_70384;
(statearr_70393[(4)] = cljs.core.cons.call(null,(5),(state_70384[(4)])));

return statearr_70393;
})();
var inst_70292 = (function (){return (function (p1__70285_SHARP_){
return p1__70285_SHARP_.t;
});
})();
var inst_70293 = cljs.core.map.call(null,inst_70292,resp);
var inst_70294 = cljs.core.set.call(null,inst_70293);
var inst_70331 = cljs.core.async.chan.call(null,(1));
var inst_70332 = (function (){var ts = inst_70294;
var c__2768__auto____$1 = inst_70331;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70329){
var state_val_70330 = (state_70329[(1)]);
if((state_val_70330 === (1))){
var inst_70302 = ts;
var inst_70303 = cljs.core.seq.call(null,inst_70302);
var inst_70304 = cljs.core.first.call(null,inst_70303);
var inst_70305 = cljs.core.next.call(null,inst_70303);
var inst_70306 = cljs.core.PersistentHashMap.EMPTY;
var inst_70307 = inst_70302;
var inst_70308 = inst_70306;
var state_70329__$1 = (function (){var statearr_70394 = state_70329;
(statearr_70394[(7)] = inst_70307);

(statearr_70394[(8)] = inst_70304);

(statearr_70394[(9)] = inst_70308);

(statearr_70394[(10)] = inst_70305);

return statearr_70394;
})();
var statearr_70395_70429 = state_70329__$1;
(statearr_70395_70429[(2)] = null);

(statearr_70395_70429[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70330 === (2))){
var inst_70307 = (state_70329[(7)]);
var inst_70314 = (state_70329[(11)]);
var inst_70313 = cljs.core.seq.call(null,inst_70307);
var inst_70314__$1 = cljs.core.first.call(null,inst_70313);
var inst_70315 = cljs.core.next.call(null,inst_70313);
var state_70329__$1 = (function (){var statearr_70396 = state_70329;
(statearr_70396[(12)] = inst_70315);

(statearr_70396[(11)] = inst_70314__$1);

return statearr_70396;
})();
if(cljs.core.truth_(inst_70314__$1)){
var statearr_70397_70430 = state_70329__$1;
(statearr_70397_70430[(1)] = (4));

} else {
var statearr_70398_70431 = state_70329__$1;
(statearr_70398_70431[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70330 === (3))){
var inst_70327 = (state_70329[(2)]);
var state_70329__$1 = state_70329;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70329__$1,inst_70327);
} else {
if((state_val_70330 === (4))){
var inst_70314 = (state_70329[(11)]);
var inst_70317 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_70314);
var state_70329__$1 = state_70329;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70329__$1,(7),inst_70317);
} else {
if((state_val_70330 === (5))){
var inst_70308 = (state_70329[(9)]);
var state_70329__$1 = state_70329;
var statearr_70399_70432 = state_70329__$1;
(statearr_70399_70432[(2)] = inst_70308);

(statearr_70399_70432[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70330 === (6))){
var inst_70325 = (state_70329[(2)]);
var state_70329__$1 = state_70329;
var statearr_70400_70433 = state_70329__$1;
(statearr_70400_70433[(2)] = inst_70325);

(statearr_70400_70433[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70330 === (7))){
var inst_70315 = (state_70329[(12)]);
var inst_70314 = (state_70329[(11)]);
var inst_70308 = (state_70329[(9)]);
var inst_70319 = (state_70329[(2)]);
var inst_70320 = fluree.db.util.async.throw_err.call(null,inst_70319);
var inst_70321 = cljs.core.assoc.call(null,inst_70308,inst_70314,inst_70320);
var inst_70307 = inst_70315;
var inst_70308__$1 = inst_70321;
var state_70329__$1 = (function (){var statearr_70401 = state_70329;
(statearr_70401[(7)] = inst_70307);

(statearr_70401[(9)] = inst_70308__$1);

return statearr_70401;
})();
var statearr_70402_70434 = state_70329__$1;
(statearr_70402_70434[(2)] = null);

(statearr_70402_70434[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_70403 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70403[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__);

(statearr_70403[(1)] = (1));

return statearr_70403;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1 = (function (state_70329){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70329);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70404){var ex__2749__auto__ = e70404;
var statearr_70405_70435 = state_70329;
(statearr_70405_70435[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70329[(4)]))){
var statearr_70406_70436 = state_70329;
(statearr_70406_70436[(1)] = cljs.core.first.call(null,(state_70329[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70437 = state_70329;
state_70329 = G__70437;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__ = function(state_70329){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1.call(this,state_70329);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70407 = f__2769__auto__.call(null);
(statearr_70407[(6)] = c__2768__auto____$1);

return statearr_70407;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_70333 = cljs.core.async.impl.dispatch.run.call(null,inst_70332);
var state_70384__$1 = (function (){var statearr_70408 = state_70384;
(statearr_70408[(14)] = inst_70333);

return statearr_70408;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70384__$1,(6),inst_70331);
} else {
if((state_val_70385 === (11))){
var inst_70376 = (state_70384[(2)]);
var state_70384__$1 = state_70384;
var statearr_70410_70438 = state_70384__$1;
(statearr_70410_70438[(2)] = inst_70376);

(statearr_70410_70438[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70385 === (9))){
var inst_70356 = (state_70384[(7)]);
var inst_70357 = (state_70384[(9)]);
var inst_70336 = (state_70384[(10)]);
var inst_70350 = (state_70384[(12)]);
var inst_70359 = inst_70356.t;
var inst_70360 = cljs.core.get.call(null,inst_70336,inst_70359);
var inst_70361 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70362 = [inst_70360,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_70363 = (new cljs.core.PersistentVector(null,2,(5),inst_70361,inst_70362,null));
var inst_70364 = cljs.core.assoc_in.call(null,inst_70350,inst_70363,inst_70360);
var inst_70365 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70366 = [inst_70360,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_70367 = (new cljs.core.PersistentVector(null,2,(5),inst_70365,inst_70366,null));
var inst_70368 = cljs.core.update_in.call(null,inst_70364,inst_70367,cljs.core.conj,inst_70356);
var inst_70369 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70370 = [inst_70360,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_70371 = (new cljs.core.PersistentVector(null,2,(5),inst_70369,inst_70370,null));
var inst_70372 = cljs.core.update_in.call(null,inst_70368,inst_70371,fluree.db.api_js.min_safe,inst_70359);
var inst_70349 = inst_70357;
var inst_70350__$1 = inst_70372;
var state_70384__$1 = (function (){var statearr_70411 = state_70384;
(statearr_70411[(12)] = inst_70350__$1);

(statearr_70411[(8)] = inst_70349);

return statearr_70411;
})();
var statearr_70412_70439 = state_70384__$1;
(statearr_70412_70439[(2)] = null);

(statearr_70412_70439[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70385 === (5))){
var _ = (function (){var statearr_70413 = state_70384;
(statearr_70413[(4)] = cljs.core.rest.call(null,(state_70384[(4)])));

return statearr_70413;
})();
var state_70384__$1 = state_70384;
var ex70409 = (state_70384__$1[(2)]);
var statearr_70414_70440 = state_70384__$1;
(statearr_70414_70440[(5)] = ex70409);


if((ex70409 instanceof Error)){
var statearr_70415_70441 = state_70384__$1;
(statearr_70415_70441[(1)] = (4));

(statearr_70415_70441[(5)] = null);

} else {
throw ex70409;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70385 === (10))){
var inst_70350 = (state_70384[(12)]);
var state_70384__$1 = state_70384;
var statearr_70416_70442 = state_70384__$1;
(statearr_70416_70442[(2)] = inst_70350);

(statearr_70416_70442[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70385 === (8))){
var inst_70378 = (state_70384[(2)]);
var inst_70379 = cljs.core.vals.call(null,inst_70378);
var _ = (function (){var statearr_70417 = state_70384;
(statearr_70417[(4)] = cljs.core.rest.call(null,(state_70384[(4)])));

return statearr_70417;
})();
var state_70384__$1 = state_70384;
var statearr_70418_70443 = state_70384__$1;
(statearr_70418_70443[(2)] = inst_70379);

(statearr_70418_70443[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_70419 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70419[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__);

(statearr_70419[(1)] = (1));

return statearr_70419;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1 = (function (state_70384){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70384);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70420){var ex__2749__auto__ = e70420;
var statearr_70421_70444 = state_70384;
(statearr_70421_70444[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70384[(4)]))){
var statearr_70422_70445 = state_70384;
(statearr_70422_70445[(1)] = cljs.core.first.call(null,(state_70384[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70446 = state_70384;
state_70384 = G__70446;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__ = function(state_70384){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1.call(this,state_70384);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70423 = f__2769__auto__.call(null);
(statearr_70423[(6)] = c__2768__auto__);

return statearr_70423;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70594){
var state_val_70595 = (state_70594[(1)]);
if((state_val_70595 === (7))){
var inst_70474 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70475 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_70476 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_70477 = [inst_70475,inst_70476];
var inst_70478 = (new cljs.core.PersistentVector(null,2,(5),inst_70474,inst_70477,null));
var state_70594__$1 = state_70594;
var statearr_70596_70667 = state_70594__$1;
(statearr_70596_70667[(2)] = inst_70478);

(statearr_70596_70667[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (20))){
var inst_70504 = (state_70594[(7)]);
var state_70594__$1 = state_70594;
var statearr_70597_70668 = state_70594__$1;
(statearr_70597_70668[(2)] = inst_70504);

(statearr_70597_70668[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (27))){
var state_70594__$1 = state_70594;
var statearr_70598_70669 = state_70594__$1;
(statearr_70598_70669[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (1))){
var state_70594__$1 = state_70594;
var statearr_70600_70670 = state_70594__$1;
(statearr_70600_70670[(2)] = null);

(statearr_70600_70670[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (24))){
var inst_70503 = (state_70594[(8)]);
var state_70594__$1 = state_70594;
if(cljs.core.truth_(inst_70503)){
var statearr_70601_70671 = state_70594__$1;
(statearr_70601_70671[(1)] = (26));

} else {
var statearr_70602_70672 = state_70594__$1;
(statearr_70602_70672[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (39))){
var inst_70549 = (state_70594[(9)]);
var inst_70550 = (state_70594[(10)]);
var inst_70575 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70576 = [inst_70549,inst_70550];
var inst_70577 = (new cljs.core.PersistentVector(null,2,(5),inst_70575,inst_70576,null));
var state_70594__$1 = state_70594;
var statearr_70603_70673 = state_70594__$1;
(statearr_70603_70673[(2)] = inst_70577);

(statearr_70603_70673[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (4))){
var inst_70447 = (state_70594[(2)]);
var inst_70448 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70449 = [inst_70447];
var inst_70450 = (new cljs.core.PersistentVector(null,1,(5),inst_70448,inst_70449,null));
var inst_70451 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_70450);
var inst_70452 = cljs.core.ex_data.call(null,inst_70447);
var inst_70453 = cljs.core.ex_message.call(null,inst_70447);
var inst_70454 = cljs.core.assoc.call(null,inst_70452,new cljs.core.Keyword(null,"message","message",-406056002),inst_70453);
var state_70594__$1 = (function (){var statearr_70604 = state_70594;
(statearr_70604[(11)] = inst_70451);

return statearr_70604;
})();
var statearr_70605_70674 = state_70594__$1;
(statearr_70605_70674[(2)] = inst_70454);

(statearr_70605_70674[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (15))){
var inst_70483 = (state_70594[(12)]);
var inst_70488 = (state_70594[(13)]);
var inst_70497 = (state_70594[(2)]);
var inst_70498 = [inst_70488,inst_70497];
var inst_70499 = (new cljs.core.PersistentVector(null,2,(5),inst_70483,inst_70498,null));
var state_70594__$1 = state_70594;
var statearr_70606_70675 = state_70594__$1;
(statearr_70606_70675[(2)] = inst_70499);

(statearr_70606_70675[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (21))){
var inst_70503 = (state_70594[(8)]);
var state_70594__$1 = state_70594;
var statearr_70607_70676 = state_70594__$1;
(statearr_70607_70676[(2)] = inst_70503);

(statearr_70607_70676[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (31))){
var inst_70544 = (state_70594[(2)]);
var state_70594__$1 = state_70594;
var statearr_70608_70677 = state_70594__$1;
(statearr_70608_70677[(2)] = inst_70544);

(statearr_70608_70677[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (32))){
var inst_70550 = (state_70594[(10)]);
var inst_70553 = cljs.core.pos_int_QMARK_.call(null,inst_70550);
var state_70594__$1 = state_70594;
var statearr_70609_70678 = state_70594__$1;
(statearr_70609_70678[(2)] = inst_70553);

(statearr_70609_70678[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (40))){
var inst_70581 = (state_70594[(14)]);
var inst_70505 = (state_70594[(15)]);
var inst_70579 = (state_70594[(2)]);
var inst_70580 = cljs.core.nth.call(null,inst_70579,(0),null);
var inst_70581__$1 = cljs.core.nth.call(null,inst_70579,(1),null);
var inst_70582 = (inst_70581__$1 > inst_70505);
var state_70594__$1 = (function (){var statearr_70610 = state_70594;
(statearr_70610[(16)] = inst_70580);

(statearr_70610[(14)] = inst_70581__$1);

return statearr_70610;
})();
if(cljs.core.truth_(inst_70582)){
var statearr_70611_70679 = state_70594__$1;
(statearr_70611_70679[(1)] = (41));

} else {
var statearr_70612_70680 = state_70594__$1;
(statearr_70612_70680[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (33))){
var inst_70551 = (state_70594[(17)]);
var state_70594__$1 = state_70594;
var statearr_70613_70681 = state_70594__$1;
(statearr_70613_70681[(2)] = inst_70551);

(statearr_70613_70681[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (13))){
var inst_70489 = (state_70594[(18)]);
var inst_70491 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_70489);
var state_70594__$1 = state_70594;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70594__$1,(16),inst_70491);
} else {
if((state_val_70595 === (22))){
var inst_70522 = (state_70594[(2)]);
var state_70594__$1 = state_70594;
if(cljs.core.truth_(inst_70522)){
var statearr_70614_70682 = state_70594__$1;
(statearr_70614_70682[(1)] = (23));

} else {
var statearr_70615_70683 = state_70594__$1;
(statearr_70615_70683[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (36))){
var state_70594__$1 = state_70594;
var statearr_70616_70684 = state_70594__$1;
(statearr_70616_70684[(2)] = null);

(statearr_70616_70684[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (41))){
var inst_70505 = (state_70594[(15)]);
var state_70594__$1 = state_70594;
var statearr_70617_70685 = state_70594__$1;
(statearr_70617_70685[(2)] = inst_70505);

(statearr_70617_70685[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (43))){
var inst_70580 = (state_70594[(16)]);
var inst_70586 = (state_70594[(2)]);
var inst_70587 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70588 = [inst_70580,inst_70586];
var inst_70589 = (new cljs.core.PersistentVector(null,2,(5),inst_70587,inst_70588,null));
var _ = (function (){var statearr_70618 = state_70594;
(statearr_70618[(4)] = cljs.core.rest.call(null,(state_70594[(4)])));

return statearr_70618;
})();
var state_70594__$1 = state_70594;
var statearr_70619_70686 = state_70594__$1;
(statearr_70619_70686[(2)] = inst_70589);

(statearr_70619_70686[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (29))){
var inst_70480 = (state_70594[(19)]);
var inst_70535 = cljs.core.pr_str.call(null,inst_70480);
var inst_70536 = ["Invalid block range provided: ",inst_70535].join('');
var inst_70537 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70538 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70539 = cljs.core.PersistentHashMap.fromArrays(inst_70537,inst_70538);
var inst_70540 = cljs.core.ex_info.call(null,inst_70536,inst_70539);
var inst_70541 = (function(){throw inst_70540})();
var state_70594__$1 = state_70594;
var statearr_70620_70687 = state_70594__$1;
(statearr_70620_70687[(2)] = inst_70541);

(statearr_70620_70687[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (6))){
var inst_70472 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_70594__$1 = state_70594;
var statearr_70621_70688 = state_70594__$1;
(statearr_70621_70688[(2)] = inst_70472);

(statearr_70621_70688[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (28))){
var inst_70546 = (state_70594[(2)]);
var state_70594__$1 = state_70594;
var statearr_70622_70689 = state_70594__$1;
(statearr_70622_70689[(2)] = inst_70546);

(statearr_70622_70689[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (25))){
var inst_70549 = (state_70594[(9)]);
var inst_70551 = (state_70594[(17)]);
var inst_70548 = (state_70594[(2)]);
var inst_70549__$1 = cljs.core.nth.call(null,inst_70548,(0),null);
var inst_70550 = cljs.core.nth.call(null,inst_70548,(1),null);
var inst_70551__$1 = cljs.core.pos_int_QMARK_.call(null,inst_70549__$1);
var state_70594__$1 = (function (){var statearr_70623 = state_70594;
(statearr_70623[(9)] = inst_70549__$1);

(statearr_70623[(17)] = inst_70551__$1);

(statearr_70623[(10)] = inst_70550);

return statearr_70623;
})();
if(inst_70551__$1){
var statearr_70624_70690 = state_70594__$1;
(statearr_70624_70690[(1)] = (32));

} else {
var statearr_70625_70691 = state_70594__$1;
(statearr_70625_70691[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (34))){
var inst_70556 = (state_70594[(2)]);
var inst_70557 = cljs.core.not.call(null,inst_70556);
var state_70594__$1 = state_70594;
if(inst_70557){
var statearr_70626_70692 = state_70594__$1;
(statearr_70626_70692[(1)] = (35));

} else {
var statearr_70627_70693 = state_70594__$1;
(statearr_70627_70693[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (17))){
var inst_70505 = (state_70594[(15)]);
var inst_70503 = (state_70594[(8)]);
var inst_70508 = cljs.core.pr_str.call(null,inst_70503);
var inst_70509 = cljs.core.pr_str.call(null,inst_70505);
var inst_70510 = ["Start block is out of range for this ledger. Start block provided: ",inst_70508,". Database block: ",inst_70509].join('');
var inst_70511 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70512 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70513 = cljs.core.PersistentHashMap.fromArrays(inst_70511,inst_70512);
var inst_70514 = cljs.core.ex_info.call(null,inst_70510,inst_70513);
var inst_70515 = (function(){throw inst_70514})();
var state_70594__$1 = state_70594;
var statearr_70628_70694 = state_70594__$1;
(statearr_70628_70694[(2)] = inst_70515);

(statearr_70628_70694[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (3))){
var inst_70592 = (state_70594[(2)]);
var state_70594__$1 = state_70594;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70594__$1,inst_70592);
} else {
if((state_val_70595 === (12))){
var inst_70480 = (state_70594[(19)]);
var inst_70489 = (state_70594[(18)]);
var inst_70487 = (state_70594[(2)]);
var inst_70488 = fluree.db.util.async.throw_err.call(null,inst_70487);
var inst_70489__$1 = cljs.core.second.call(null,inst_70480);
var state_70594__$1 = (function (){var statearr_70629 = state_70594;
(statearr_70629[(13)] = inst_70488);

(statearr_70629[(18)] = inst_70489__$1);

return statearr_70629;
})();
if(cljs.core.truth_(inst_70489__$1)){
var statearr_70630_70695 = state_70594__$1;
(statearr_70630_70695[(1)] = (13));

} else {
var statearr_70631_70696 = state_70594__$1;
(statearr_70631_70696[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (2))){
var _ = (function (){var statearr_70632 = state_70594;
(statearr_70632[(4)] = cljs.core.cons.call(null,(5),(state_70594[(4)])));

return statearr_70632;
})();
var inst_70469 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_70470 = cljs.core.sequential_QMARK_.call(null,inst_70469);
var state_70594__$1 = state_70594;
if(inst_70470){
var statearr_70633_70697 = state_70594__$1;
(statearr_70633_70697[(1)] = (6));

} else {
var statearr_70634_70698 = state_70594__$1;
(statearr_70634_70698[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (23))){
var inst_70504 = (state_70594[(7)]);
var inst_70503 = (state_70594[(8)]);
var inst_70524 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70525 = [inst_70503,inst_70504];
var inst_70526 = (new cljs.core.PersistentVector(null,2,(5),inst_70524,inst_70525,null));
var state_70594__$1 = state_70594;
var statearr_70635_70699 = state_70594__$1;
(statearr_70635_70699[(2)] = inst_70526);

(statearr_70635_70699[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (35))){
var inst_70480 = (state_70594[(19)]);
var inst_70559 = cljs.core.pr_str.call(null,inst_70480);
var inst_70560 = ["Invalid block range provided: ",inst_70559].join('');
var inst_70561 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70562 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70563 = cljs.core.PersistentHashMap.fromArrays(inst_70561,inst_70562);
var inst_70564 = cljs.core.ex_info.call(null,inst_70560,inst_70563);
var inst_70565 = (function(){throw inst_70564})();
var state_70594__$1 = state_70594;
var statearr_70636_70700 = state_70594__$1;
(statearr_70636_70700[(2)] = inst_70565);

(statearr_70636_70700[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (19))){
var inst_70503 = (state_70594[(8)]);
var inst_70518 = (state_70594[(2)]);
var state_70594__$1 = (function (){var statearr_70637 = state_70594;
(statearr_70637[(20)] = inst_70518);

return statearr_70637;
})();
if(cljs.core.truth_(inst_70503)){
var statearr_70638_70701 = state_70594__$1;
(statearr_70638_70701[(1)] = (20));

} else {
var statearr_70639_70702 = state_70594__$1;
(statearr_70639_70702[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (11))){
var inst_70505 = (state_70594[(15)]);
var inst_70503 = (state_70594[(8)]);
var inst_70502 = (state_70594[(2)]);
var inst_70503__$1 = cljs.core.nth.call(null,inst_70502,(0),null);
var inst_70504 = cljs.core.nth.call(null,inst_70502,(1),null);
var inst_70505__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_70506 = (inst_70503__$1 > inst_70505__$1);
var state_70594__$1 = (function (){var statearr_70641 = state_70594;
(statearr_70641[(7)] = inst_70504);

(statearr_70641[(15)] = inst_70505__$1);

(statearr_70641[(8)] = inst_70503__$1);

return statearr_70641;
})();
if(cljs.core.truth_(inst_70506)){
var statearr_70642_70703 = state_70594__$1;
(statearr_70642_70703[(1)] = (17));

} else {
var statearr_70643_70704 = state_70594__$1;
(statearr_70643_70704[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (9))){
var inst_70480 = (state_70594[(19)]);
var inst_70483 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70484 = cljs.core.first.call(null,inst_70480);
var inst_70485 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_70484);
var state_70594__$1 = (function (){var statearr_70644 = state_70594;
(statearr_70644[(12)] = inst_70483);

return statearr_70644;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70594__$1,(12),inst_70485);
} else {
if((state_val_70595 === (5))){
var _ = (function (){var statearr_70645 = state_70594;
(statearr_70645[(4)] = cljs.core.rest.call(null,(state_70594[(4)])));

return statearr_70645;
})();
var state_70594__$1 = state_70594;
var ex70640 = (state_70594__$1[(2)]);
var statearr_70646_70705 = state_70594__$1;
(statearr_70646_70705[(5)] = ex70640);


var statearr_70647_70706 = state_70594__$1;
(statearr_70647_70706[(1)] = (4));

(statearr_70647_70706[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (14))){
var state_70594__$1 = state_70594;
var statearr_70648_70707 = state_70594__$1;
(statearr_70648_70707[(2)] = null);

(statearr_70648_70707[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (26))){
var inst_70503 = (state_70594[(8)]);
var inst_70529 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70530 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_70531 = [inst_70503,inst_70530];
var inst_70532 = (new cljs.core.PersistentVector(null,2,(5),inst_70529,inst_70531,null));
var state_70594__$1 = state_70594;
var statearr_70649_70708 = state_70594__$1;
(statearr_70649_70708[(2)] = inst_70532);

(statearr_70649_70708[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (16))){
var inst_70493 = (state_70594[(2)]);
var inst_70494 = fluree.db.util.async.throw_err.call(null,inst_70493);
var state_70594__$1 = state_70594;
var statearr_70650_70709 = state_70594__$1;
(statearr_70650_70709[(2)] = inst_70494);

(statearr_70650_70709[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (38))){
var inst_70549 = (state_70594[(9)]);
var inst_70550 = (state_70594[(10)]);
var inst_70571 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70572 = [inst_70550,inst_70549];
var inst_70573 = (new cljs.core.PersistentVector(null,2,(5),inst_70571,inst_70572,null));
var state_70594__$1 = state_70594;
var statearr_70651_70710 = state_70594__$1;
(statearr_70651_70710[(2)] = inst_70573);

(statearr_70651_70710[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (30))){
var state_70594__$1 = state_70594;
var statearr_70652_70711 = state_70594__$1;
(statearr_70652_70711[(2)] = null);

(statearr_70652_70711[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (10))){
var inst_70480 = (state_70594[(19)]);
var state_70594__$1 = state_70594;
var statearr_70653_70712 = state_70594__$1;
(statearr_70653_70712[(2)] = inst_70480);

(statearr_70653_70712[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (18))){
var state_70594__$1 = state_70594;
var statearr_70654_70713 = state_70594__$1;
(statearr_70654_70713[(2)] = null);

(statearr_70654_70713[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (42))){
var inst_70581 = (state_70594[(14)]);
var state_70594__$1 = state_70594;
var statearr_70655_70714 = state_70594__$1;
(statearr_70655_70714[(2)] = inst_70581);

(statearr_70655_70714[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (37))){
var inst_70549 = (state_70594[(9)]);
var inst_70550 = (state_70594[(10)]);
var inst_70568 = (state_70594[(2)]);
var inst_70569 = (inst_70550 < inst_70549);
var state_70594__$1 = (function (){var statearr_70656 = state_70594;
(statearr_70656[(21)] = inst_70568);

return statearr_70656;
})();
if(cljs.core.truth_(inst_70569)){
var statearr_70657_70715 = state_70594__$1;
(statearr_70657_70715[(1)] = (38));

} else {
var statearr_70658_70716 = state_70594__$1;
(statearr_70658_70716[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70595 === (8))){
var inst_70480 = (state_70594[(19)]);
var inst_70480__$1 = (state_70594[(2)]);
var inst_70481 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_70480__$1);
var state_70594__$1 = (function (){var statearr_70659 = state_70594;
(statearr_70659[(19)] = inst_70480__$1);

return statearr_70659;
})();
if(cljs.core.truth_(inst_70481)){
var statearr_70660_70717 = state_70594__$1;
(statearr_70660_70717[(1)] = (9));

} else {
var statearr_70661_70718 = state_70594__$1;
(statearr_70661_70718[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____0 = (function (){
var statearr_70662 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70662[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__);

(statearr_70662[(1)] = (1));

return statearr_70662;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____1 = (function (state_70594){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70594);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70663){var ex__2749__auto__ = e70663;
var statearr_70664_70719 = state_70594;
(statearr_70664_70719[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70594[(4)]))){
var statearr_70665_70720 = state_70594;
(statearr_70665_70720[(1)] = cljs.core.first.call(null,(state_70594[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70721 = state_70594;
state_70594 = G__70721;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__ = function(state_70594){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____1.call(this,state_70594);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70666 = f__2769__auto__.call(null);
(statearr_70666[(6)] = c__2768__auto__);

return statearr_70666;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__70723 = arguments.length;
switch (G__70723) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.call(null,db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70817){
var state_val_70818 = (state_70817[(1)]);
if((state_val_70818 === (7))){
var inst_70749 = (state_70817[(7)]);
var inst_70752 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_70749);
var state_70817__$1 = state_70817;
var statearr_70819_70870 = state_70817__$1;
(statearr_70819_70870[(2)] = inst_70752);

(statearr_70819_70870[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70818 === (20))){
var inst_70788 = (state_70817[(8)]);
var inst_70791 = fluree.db.api_js.format_block_resp_pretty.call(null,db,inst_70788);
var state_70817__$1 = state_70817;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70817__$1,(23),inst_70791);
} else {
if((state_val_70818 === (27))){
var inst_70797 = (state_70817[(9)]);
var inst_70803 = cljs.core.doall.call(null,inst_70797);
var state_70817__$1 = state_70817;
var statearr_70820_70871 = state_70817__$1;
(statearr_70820_70871[(2)] = inst_70803);

(statearr_70820_70871[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70818 === (1))){
var state_70817__$1 = state_70817;
var statearr_70821_70872 = state_70817__$1;
(statearr_70821_70872[(2)] = null);

(statearr_70821_70872[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70818 === (24))){
var inst_70797 = (state_70817[(9)]);
var inst_70800 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_70801 = cljs.core.sequential_QMARK_.call(null,inst_70797);
var state_70817__$1 = (function (){var statearr_70822 = state_70817;
(statearr_70822[(10)] = inst_70800);

return statearr_70822;
})();
if(inst_70801){
var statearr_70823_70873 = state_70817__$1;
(statearr_70823_70873[(1)] = (27));

} else {
var statearr_70824_70874 = state_70817__$1;
(statearr_70824_70874[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70818 === (4))){
var inst_70724 = (state_70817[(2)]);
var inst_70725 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70726 = [inst_70724];
var inst_70727 = (new cljs.core.PersistentVector(null,1,(5),inst_70725,inst_70726,null));
var inst_70728 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_70727);
var inst_70729 = cljs.core.ex_data.call(null,inst_70724);
var inst_70730 = cljs.core.ex_message.call(null,inst_70724);
var inst_70731 = cljs.core.assoc.call(null,inst_70729,new cljs.core.Keyword(null,"message","message",-406056002),inst_70730);
var state_70817__$1 = (function (){var statearr_70825 = state_70817;
(statearr_70825[(11)] = inst_70728);

return statearr_70825;
})();
var statearr_70826_70875 = state_70817__$1;
(statearr_70826_70875[(2)] = inst_70731);

(statearr_70826_70875[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70818 === (15))){
var inst_70749 = (state_70817[(7)]);
var inst_70762 = (state_70817[(2)]);
var inst_70763 = cljs.core.ex_info.call(null,inst_70762,inst_70749);
var inst_70764 = (function(){throw inst_70763})();
var state_70817__$1 = state_70817;
var statearr_70827_70876 = state_70817__$1;
(statearr_70827_70876[(2)] = inst_70764);

(statearr_70827_70876[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70818 === (21))){
var inst_70788 = (state_70817[(8)]);
var state_70817__$1 = state_70817;
var statearr_70828_70877 = state_70817__$1;
(statearr_70828_70877[(2)] = inst_70788);

(statearr_70828_70877[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70818 === (13))){
var inst_70757 = (state_70817[(12)]);
var state_70817__$1 = state_70817;
var statearr_70829_70878 = state_70817__$1;
(statearr_70829_70878[(2)] = inst_70757);

(statearr_70829_70878[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70818 === (22))){
var inst_70797 = (state_70817[(2)]);
var inst_70798 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_70817__$1 = (function (){var statearr_70830 = state_70817;
(statearr_70830[(9)] = inst_70797);

return statearr_70830;
})();
if(cljs.core.truth_(inst_70798)){
var statearr_70831_70879 = state_70817__$1;
(statearr_70831_70879[(1)] = (24));

} else {
var statearr_70832_70880 = state_70817__$1;
(statearr_70832_70880[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70818 === (29))){
var inst_70800 = (state_70817[(10)]);
var inst_70741 = (state_70817[(13)]);
var inst_70806 = (state_70817[(2)]);
var inst_70807 = fluree.db.util.core.response_time_formatted.call(null,inst_70741);
var inst_70808 = [(200),inst_70806,(100),inst_70807];
var inst_70809 = cljs.core.PersistentHashMap.fromArrays(inst_70800,inst_70808);
var state_70817__$1 = state_70817;
var statearr_70833_70881 = state_70817__$1;
(statearr_70833_70881[(2)] = inst_70809);

(statearr_70833_70881[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70818 === (6))){
var inst_70750 = (state_70817[(14)]);
var inst_70749 = (state_70817[(7)]);
var inst_70748 = (state_70817[(2)]);
var inst_70749__$1 = fluree.db.util.async.throw_err.call(null,inst_70748);
var inst_70750__$1 = cljs.core.map_QMARK_.call(null,inst_70749__$1);
var state_70817__$1 = (function (){var statearr_70834 = state_70817;
(statearr_70834[(14)] = inst_70750__$1);

(statearr_70834[(7)] = inst_70749__$1);

return statearr_70834;
})();
if(inst_70750__$1){
var statearr_70835_70882 = state_70817__$1;
(statearr_70835_70882[(1)] = (7));

} else {
var statearr_70836_70883 = state_70817__$1;
(statearr_70836_70883[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70818 === (28))){
var inst_70797 = (state_70817[(9)]);
var state_70817__$1 = state_70817;
var statearr_70837_70884 = state_70817__$1;
(statearr_70837_70884[(2)] = inst_70797);

(statearr_70837_70884[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70818 === (25))){
var inst_70797 = (state_70817[(9)]);
var state_70817__$1 = state_70817;
var statearr_70838_70885 = state_70817__$1;
(statearr_70838_70885[(2)] = inst_70797);

(statearr_70838_70885[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70818 === (17))){
var inst_70780 = cljs.core.pr_str.call(null,query_map);
var inst_70781 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_70780].join('');
var inst_70782 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70783 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70784 = cljs.core.PersistentHashMap.fromArrays(inst_70782,inst_70783);
var inst_70785 = cljs.core.ex_info.call(null,inst_70781,inst_70784);
var inst_70786 = (function(){throw inst_70785})();
var state_70817__$1 = state_70817;
var statearr_70839_70886 = state_70817__$1;
(statearr_70839_70886[(2)] = inst_70786);

(statearr_70839_70886[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70818 === (3))){
var inst_70815 = (state_70817[(2)]);
var state_70817__$1 = state_70817;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70817__$1,inst_70815);
} else {
if((state_val_70818 === (12))){
var inst_70749 = (state_70817[(7)]);
var inst_70767 = (state_70817[(2)]);
var inst_70768 = cljs.core.nth.call(null,inst_70749,(0),null);
var inst_70769 = cljs.core.nth.call(null,inst_70749,(1),null);
var inst_70770 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_70771 = cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_70772 = cljs.core.keys.call(null,inst_70771);
var inst_70773 = cljs.core._EQ_.call(null,inst_70770,inst_70772);
var state_70817__$1 = (function (){var statearr_70840 = state_70817;
(statearr_70840[(15)] = inst_70768);

(statearr_70840[(16)] = inst_70769);

(statearr_70840[(17)] = inst_70767);

return statearr_70840;
})();
if(inst_70773){
var statearr_70841_70887 = state_70817__$1;
(statearr_70841_70887[(1)] = (16));

} else {
var statearr_70842_70888 = state_70817__$1;
(statearr_70842_70888[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70818 === (2))){
var _ = (function (){var statearr_70843 = state_70817;
(statearr_70843[(4)] = cljs.core.cons.call(null,(5),(state_70817[(4)])));

return statearr_70843;
})();
var inst_70741 = fluree.db.util.core.current_time_millis.call(null);
var inst_70742 = db;
var inst_70743 = cljs.core.__destructure_map.call(null,inst_70742);
var inst_70744 = cljs.core.get.call(null,inst_70743,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_70745 = cljs.core.get.call(null,inst_70743,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_70746 = fluree.db.api_js.resolve_block_range.call(null,db,query_map);
var state_70817__$1 = (function (){var statearr_70844 = state_70817;
(statearr_70844[(18)] = inst_70745);

(statearr_70844[(13)] = inst_70741);

(statearr_70844[(19)] = inst_70744);

return statearr_70844;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70817__$1,(6),inst_70746);
} else {
if((state_val_70818 === (23))){
var inst_70793 = (state_70817[(2)]);
var inst_70794 = fluree.db.util.async.throw_err.call(null,inst_70793);
var state_70817__$1 = state_70817;
var statearr_70845_70889 = state_70817__$1;
(statearr_70845_70889[(2)] = inst_70794);

(statearr_70845_70889[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70818 === (19))){
var inst_70777 = (state_70817[(2)]);
var inst_70778 = fluree.db.util.async.throw_err.call(null,inst_70777);
var state_70817__$1 = state_70817;
var statearr_70846_70890 = state_70817__$1;
(statearr_70846_70890[(2)] = inst_70778);

(statearr_70846_70890[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70818 === (11))){
var state_70817__$1 = state_70817;
var statearr_70848_70891 = state_70817__$1;
(statearr_70848_70891[(2)] = null);

(statearr_70848_70891[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70818 === (9))){
var inst_70755 = (state_70817[(2)]);
var state_70817__$1 = state_70817;
if(cljs.core.truth_(inst_70755)){
var statearr_70849_70892 = state_70817__$1;
(statearr_70849_70892[(1)] = (10));

} else {
var statearr_70850_70893 = state_70817__$1;
(statearr_70850_70893[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70818 === (5))){
var _ = (function (){var statearr_70851 = state_70817;
(statearr_70851[(4)] = cljs.core.rest.call(null,(state_70817[(4)])));

return statearr_70851;
})();
var state_70817__$1 = state_70817;
var ex70847 = (state_70817__$1[(2)]);
var statearr_70852_70894 = state_70817__$1;
(statearr_70852_70894[(5)] = ex70847);


var statearr_70853_70895 = state_70817__$1;
(statearr_70853_70895[(1)] = (4));

(statearr_70853_70895[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70818 === (14))){
var inst_70745 = (state_70817[(18)]);
var inst_70744 = (state_70817[(19)]);
var inst_70760 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70744),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70745)].join('');
var state_70817__$1 = state_70817;
var statearr_70854_70896 = state_70817__$1;
(statearr_70854_70896[(2)] = inst_70760);

(statearr_70854_70896[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70818 === (26))){
var inst_70812 = (state_70817[(2)]);
var _ = (function (){var statearr_70855 = state_70817;
(statearr_70855[(4)] = cljs.core.rest.call(null,(state_70817[(4)])));

return statearr_70855;
})();
var state_70817__$1 = state_70817;
var statearr_70856_70897 = state_70817__$1;
(statearr_70856_70897[(2)] = inst_70812);

(statearr_70856_70897[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70818 === (16))){
var inst_70768 = (state_70817[(15)]);
var inst_70769 = (state_70817[(16)]);
var inst_70775 = fluree.db.query.block.block_range.call(null,db,inst_70768,inst_70769,opts);
var state_70817__$1 = state_70817;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70817__$1,(19),inst_70775);
} else {
if((state_val_70818 === (10))){
var inst_70757 = (state_70817[(12)]);
var inst_70749 = (state_70817[(7)]);
var inst_70757__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_70749);
var state_70817__$1 = (function (){var statearr_70857 = state_70817;
(statearr_70857[(12)] = inst_70757__$1);

return statearr_70857;
})();
if(cljs.core.truth_(inst_70757__$1)){
var statearr_70858_70898 = state_70817__$1;
(statearr_70858_70898[(1)] = (13));

} else {
var statearr_70859_70899 = state_70817__$1;
(statearr_70859_70899[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70818 === (18))){
var inst_70788 = (state_70817[(2)]);
var inst_70789 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_70817__$1 = (function (){var statearr_70860 = state_70817;
(statearr_70860[(8)] = inst_70788);

return statearr_70860;
})();
if(cljs.core.truth_(inst_70789)){
var statearr_70861_70900 = state_70817__$1;
(statearr_70861_70900[(1)] = (20));

} else {
var statearr_70862_70901 = state_70817__$1;
(statearr_70862_70901[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70818 === (8))){
var inst_70750 = (state_70817[(14)]);
var state_70817__$1 = state_70817;
var statearr_70863_70902 = state_70817__$1;
(statearr_70863_70902[(2)] = inst_70750);

(statearr_70863_70902[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_70864 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70864[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_70864[(1)] = (1));

return statearr_70864;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_70817){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70817);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70865){var ex__2749__auto__ = e70865;
var statearr_70866_70903 = state_70817;
(statearr_70866_70903[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70817[(4)]))){
var statearr_70867_70904 = state_70817;
(statearr_70867_70904[(1)] = cljs.core.first.call(null,(state_70817[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70905 = state_70817;
state_70817 = G__70905;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_70817){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_70817);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70868 = f__2769__auto__.call(null);
(statearr_70868[(6)] = c__2768__auto__);

return statearr_70868;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__70907 = arguments.length;
switch (G__70907) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.call(null,sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_71102){
var state_val_71103 = (state_71102[(1)]);
if((state_val_71103 === (62))){
var inst_71100 = (state_71102[(2)]);
var state_71102__$1 = state_71102;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71102__$1,inst_71100);
} else {
if((state_val_71103 === (7))){
var inst_70928 = (state_71102[(7)]);
var inst_70938 = cljs.core.not_EQ_.call(null,(1),inst_70928);
var state_71102__$1 = state_71102;
var statearr_71104_71195 = state_71102__$1;
(statearr_71104_71195[(2)] = inst_70938);

(statearr_71104_71195[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (59))){
var inst_71088 = (state_71102[(2)]);
var inst_71089 = fluree.db.util.async.throw_err.call(null,inst_71088);
var state_71102__$1 = state_71102;
var statearr_71105_71196 = state_71102__$1;
(statearr_71105_71196[(2)] = inst_71089);

(statearr_71105_71196[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (20))){
var inst_70996 = (state_71102[(8)]);
var inst_71004 = (state_71102[(9)]);
var inst_70996__$1 = (state_71102[(2)]);
var inst_70997 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70998 = cljs.core.get.call(null,inst_70996__$1,(0));
var inst_70999 = cljs.core.get.call(null,inst_70996__$1,(1));
var inst_71000 = cljs.core.get.call(null,inst_70996__$1,(2));
var inst_71001 = cljs.core.get.call(null,inst_70996__$1,(3));
var inst_71002 = [inst_70998,inst_70999,inst_71000,inst_71001];
var inst_71003 = (new cljs.core.PersistentVector(null,4,(5),inst_70997,inst_71002,null));
var inst_71004__$1 = cljs.core.nth.call(null,inst_71003,(0),null);
var inst_71005 = cljs.core.nth.call(null,inst_71003,(1),null);
var inst_71006 = cljs.core.nth.call(null,inst_71003,(2),null);
var inst_71007 = cljs.core.nth.call(null,inst_71003,(3),null);
var inst_71008 = (inst_71004__$1 == null);
var inst_71009 = cljs.core.not.call(null,inst_71008);
var state_71102__$1 = (function (){var statearr_71106 = state_71102;
(statearr_71106[(10)] = inst_71006);

(statearr_71106[(8)] = inst_70996__$1);

(statearr_71106[(11)] = inst_71005);

(statearr_71106[(12)] = inst_71007);

(statearr_71106[(9)] = inst_71004__$1);

return statearr_71106;
})();
if(inst_71009){
var statearr_71107_71197 = state_71102__$1;
(statearr_71107_71197[(1)] = (30));

} else {
var statearr_71108_71198 = state_71102__$1;
(statearr_71108_71198[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (58))){
var inst_70936 = (state_71102[(13)]);
var inst_71092 = (state_71102[(2)]);
var state_71102__$1 = (function (){var statearr_71109 = state_71102;
(statearr_71109[(14)] = inst_71092);

return statearr_71109;
})();
if(cljs.core.truth_(inst_70936)){
var statearr_71110_71199 = state_71102__$1;
(statearr_71110_71199[(1)] = (60));

} else {
var statearr_71111_71200 = state_71102__$1;
(statearr_71111_71200[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (60))){
var inst_71080 = (state_71102[(15)]);
var inst_71092 = (state_71102[(14)]);
var inst_71094 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_71095 = cljs.core.count.call(null,inst_71080);
var inst_71096 = [inst_71092,inst_71095,(200)];
var inst_71097 = cljs.core.PersistentHashMap.fromArrays(inst_71094,inst_71096);
var state_71102__$1 = state_71102;
var statearr_71112_71201 = state_71102__$1;
(statearr_71112_71201[(2)] = inst_71097);

(statearr_71112_71201[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (27))){
var inst_70915 = (state_71102[(16)]);
var inst_70984 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70915)].join('');
var inst_70985 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70986 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70987 = cljs.core.PersistentHashMap.fromArrays(inst_70985,inst_70986);
var inst_70988 = cljs.core.ex_info.call(null,inst_70984,inst_70987);
var inst_70989 = (function(){throw inst_70988})();
var state_71102__$1 = state_71102;
var statearr_71113_71202 = state_71102__$1;
(statearr_71113_71202[(2)] = inst_70989);

(statearr_71113_71202[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (1))){
var inst_70912 = query_map;
var inst_70913 = cljs.core.__destructure_map.call(null,inst_70912);
var inst_70914 = cljs.core.get.call(null,inst_70913,new cljs.core.Keyword(null,"block","block",664686210));
var inst_70915 = cljs.core.get.call(null,inst_70913,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_70916 = cljs.core.get.call(null,inst_70913,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_71102__$1 = (function (){var statearr_71114 = state_71102;
(statearr_71114[(17)] = inst_70916);

(statearr_71114[(16)] = inst_70915);

(statearr_71114[(18)] = inst_70914);

return statearr_71114;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71102__$1,(2),sources);
} else {
if((state_val_71103 === (24))){
var inst_70915 = (state_71102[(16)]);
var inst_70973 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70915)].join('');
var inst_70974 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70975 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70976 = cljs.core.PersistentHashMap.fromArrays(inst_70974,inst_70975);
var inst_70977 = cljs.core.ex_info.call(null,inst_70973,inst_70976);
var inst_70978 = (function(){throw inst_70977})();
var state_71102__$1 = state_71102;
var statearr_71115_71203 = state_71102__$1;
(statearr_71115_71203[(2)] = inst_70978);

(statearr_71115_71203[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (55))){
var inst_70916 = (state_71102[(17)]);
var inst_71083 = (state_71102[(2)]);
var inst_71084 = fluree.db.util.async.throw_err.call(null,inst_71083);
var state_71102__$1 = (function (){var statearr_71116 = state_71102;
(statearr_71116[(19)] = inst_71084);

return statearr_71116;
})();
if(cljs.core.truth_(inst_70916)){
var statearr_71117_71204 = state_71102__$1;
(statearr_71117_71204[(1)] = (56));

} else {
var statearr_71118_71205 = state_71102__$1;
(statearr_71118_71205[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (39))){
var inst_71006 = (state_71102[(10)]);
var inst_71005 = (state_71102[(11)]);
var inst_71007 = (state_71102[(12)]);
var inst_71004 = (state_71102[(9)]);
var inst_71028 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71029 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71030 = [inst_71005,inst_71004,inst_71006,inst_71007];
var inst_71031 = (new cljs.core.PersistentVector(null,4,(5),inst_71029,inst_71030,null));
var inst_71032 = [inst_71031,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_71033 = (new cljs.core.PersistentVector(null,2,(5),inst_71028,inst_71032,null));
var state_71102__$1 = state_71102;
var statearr_71119_71206 = state_71102__$1;
(statearr_71119_71206[(2)] = inst_71033);

(statearr_71119_71206[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (46))){
var inst_71038 = (state_71102[(20)]);
var state_71102__$1 = state_71102;
var statearr_71120_71207 = state_71102__$1;
(statearr_71120_71207[(2)] = inst_71038);

(statearr_71120_71207[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (4))){
var state_71102__$1 = state_71102;
var statearr_71121_71208 = state_71102__$1;
(statearr_71121_71208[(2)] = null);

(statearr_71121_71208[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (54))){
var inst_71080 = (state_71102[(15)]);
var inst_70919 = (state_71102[(21)]);
var inst_71079 = (state_71102[(2)]);
var inst_71080__$1 = fluree.db.util.async.throw_err.call(null,inst_71079);
var inst_71081 = fluree.db.api_js.format_history_resp.call(null,inst_70919,inst_71080__$1);
var state_71102__$1 = (function (){var statearr_71122 = state_71102;
(statearr_71122[(15)] = inst_71080__$1);

return statearr_71122;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71102__$1,(55),inst_71081);
} else {
if((state_val_71103 === (15))){
var inst_70919 = (state_71102[(21)]);
var inst_70960 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_70919);
var state_71102__$1 = state_71102;
var statearr_71123_71209 = state_71102__$1;
(statearr_71123_71209[(2)] = inst_70960);

(statearr_71123_71209[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (48))){
var inst_71006 = (state_71102[(10)]);
var inst_71005 = (state_71102[(11)]);
var inst_71007 = (state_71102[(12)]);
var inst_71004 = (state_71102[(9)]);
var inst_71049 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71050 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71051 = [inst_71005,inst_71006,inst_71004,inst_71007];
var inst_71052 = (new cljs.core.PersistentVector(null,4,(5),inst_71050,inst_71051,null));
var inst_71053 = [inst_71052,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_71054 = (new cljs.core.PersistentVector(null,2,(5),inst_71049,inst_71053,null));
var state_71102__$1 = state_71102;
var statearr_71124_71210 = state_71102__$1;
(statearr_71124_71210[(2)] = inst_71054);

(statearr_71124_71210[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (50))){
var inst_71067 = (state_71102[(2)]);
var state_71102__$1 = state_71102;
var statearr_71125_71211 = state_71102__$1;
(statearr_71125_71211[(2)] = inst_71067);

(statearr_71125_71211[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (21))){
var inst_70915 = (state_71102[(16)]);
var inst_70971 = cljs.core.empty_QMARK_.call(null,inst_70915);
var state_71102__$1 = state_71102;
if(inst_70971){
var statearr_71126_71212 = state_71102__$1;
(statearr_71126_71212[(1)] = (24));

} else {
var statearr_71127_71213 = state_71102__$1;
(statearr_71127_71213[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (31))){
var inst_71015 = (state_71102[(22)]);
var inst_71004 = (state_71102[(9)]);
var inst_71015__$1 = (inst_71004 == null);
var state_71102__$1 = (function (){var statearr_71128 = state_71102;
(statearr_71128[(22)] = inst_71015__$1);

return statearr_71128;
})();
if(cljs.core.truth_(inst_71015__$1)){
var statearr_71129_71214 = state_71102__$1;
(statearr_71129_71214[(1)] = (33));

} else {
var statearr_71130_71215 = state_71102__$1;
(statearr_71130_71215[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (32))){
var inst_70962 = (state_71102[(23)]);
var inst_70919 = (state_71102[(21)]);
var inst_70952 = (state_71102[(24)]);
var inst_71071 = (state_71102[(2)]);
var inst_71072 = cljs.core.nth.call(null,inst_71071,(0),null);
var inst_71073 = cljs.core.nth.call(null,inst_71071,(1),null);
var inst_71074 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_71075 = [inst_70952,inst_70962];
var inst_71076 = cljs.core.PersistentHashMap.fromArrays(inst_71074,inst_71075);
var inst_71077 = fluree.db.query.range.time_range.call(null,inst_70919,inst_71073,cljs.core._EQ_,inst_71072,inst_71076);
var state_71102__$1 = state_71102;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71102__$1,(54),inst_71077);
} else {
if((state_val_71103 === (40))){
var inst_71035 = (state_71102[(25)]);
var inst_71004 = (state_71102[(9)]);
var inst_71035__$1 = (inst_71004 == null);
var state_71102__$1 = (function (){var statearr_71131 = state_71102;
(statearr_71131[(25)] = inst_71035__$1);

return statearr_71131;
})();
if(cljs.core.truth_(inst_71035__$1)){
var statearr_71132_71216 = state_71102__$1;
(statearr_71132_71216[(1)] = (42));

} else {
var statearr_71133_71217 = state_71102__$1;
(statearr_71133_71217[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (56))){
var inst_71084 = (state_71102[(19)]);
var inst_70919 = (state_71102[(21)]);
var inst_71086 = fluree.db.api_js.format_block_resp_pretty.call(null,inst_70919,inst_71084);
var state_71102__$1 = state_71102;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71102__$1,(59),inst_71086);
} else {
if((state_val_71103 === (33))){
var inst_71005 = (state_71102[(11)]);
var inst_71018 = (state_71102[(26)]);
var inst_71017 = (inst_71005 == null);
var inst_71018__$1 = cljs.core.not.call(null,inst_71017);
var state_71102__$1 = (function (){var statearr_71134 = state_71102;
(statearr_71134[(26)] = inst_71018__$1);

return statearr_71134;
})();
if(inst_71018__$1){
var statearr_71135_71218 = state_71102__$1;
(statearr_71135_71218[(1)] = (36));

} else {
var statearr_71136_71219 = state_71102__$1;
(statearr_71136_71219[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (13))){
var inst_70946 = (state_71102[(2)]);
var inst_70947 = fluree.db.util.async.throw_err.call(null,inst_70946);
var inst_70948 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_70947);
var inst_70949 = (inst_70948 - (1));
var state_71102__$1 = state_71102;
var statearr_71137_71220 = state_71102__$1;
(statearr_71137_71220[(2)] = inst_70949);

(statearr_71137_71220[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (22))){
var state_71102__$1 = state_71102;
var statearr_71138_71221 = state_71102__$1;
(statearr_71138_71221[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (36))){
var inst_71006 = (state_71102[(10)]);
var inst_71020 = (inst_71006 == null);
var state_71102__$1 = state_71102;
var statearr_71140_71222 = state_71102__$1;
(statearr_71140_71222[(2)] = inst_71020);

(statearr_71140_71222[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (41))){
var inst_71069 = (state_71102[(2)]);
var state_71102__$1 = state_71102;
var statearr_71141_71223 = state_71102__$1;
(statearr_71141_71223[(2)] = inst_71069);

(statearr_71141_71223[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (43))){
var inst_71035 = (state_71102[(25)]);
var state_71102__$1 = state_71102;
var statearr_71142_71224 = state_71102__$1;
(statearr_71142_71224[(2)] = inst_71035);

(statearr_71142_71224[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (61))){
var inst_71092 = (state_71102[(14)]);
var state_71102__$1 = state_71102;
var statearr_71143_71225 = state_71102__$1;
(statearr_71143_71225[(2)] = inst_71092);

(statearr_71143_71225[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (29))){
var inst_70992 = (state_71102[(2)]);
var state_71102__$1 = state_71102;
var statearr_71144_71226 = state_71102__$1;
(statearr_71144_71226[(2)] = inst_70992);

(statearr_71144_71226[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (44))){
var inst_71047 = (state_71102[(2)]);
var state_71102__$1 = state_71102;
if(cljs.core.truth_(inst_71047)){
var statearr_71145_71227 = state_71102__$1;
(statearr_71145_71227[(1)] = (48));

} else {
var statearr_71146_71228 = state_71102__$1;
(statearr_71146_71228[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (6))){
var inst_70923 = (state_71102[(2)]);
var inst_70924 = fluree.db.util.async.throw_err.call(null,inst_70923);
var state_71102__$1 = state_71102;
var statearr_71147_71229 = state_71102__$1;
(statearr_71147_71229[(2)] = inst_70924);

(statearr_71147_71229[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (28))){
var state_71102__$1 = state_71102;
var statearr_71148_71230 = state_71102__$1;
(statearr_71148_71230[(2)] = null);

(statearr_71148_71230[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (51))){
var inst_70915 = (state_71102[(16)]);
var inst_71057 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70915)].join('');
var inst_71058 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71059 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_71060 = cljs.core.PersistentHashMap.fromArrays(inst_71058,inst_71059);
var inst_71061 = cljs.core.ex_info.call(null,inst_71057,inst_71060);
var inst_71062 = (function(){throw inst_71061})();
var state_71102__$1 = state_71102;
var statearr_71149_71231 = state_71102__$1;
(statearr_71149_71231[(2)] = inst_71062);

(statearr_71149_71231[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (25))){
var inst_70915 = (state_71102[(16)]);
var state_71102__$1 = state_71102;
var statearr_71150_71232 = state_71102__$1;
(statearr_71150_71232[(2)] = inst_70915);

(statearr_71150_71232[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (34))){
var inst_71015 = (state_71102[(22)]);
var state_71102__$1 = state_71102;
var statearr_71151_71233 = state_71102__$1;
(statearr_71151_71233[(2)] = inst_71015);

(statearr_71151_71233[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (17))){
var inst_70956 = (state_71102[(2)]);
var inst_70957 = fluree.db.util.async.throw_err.call(null,inst_70956);
var inst_70958 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_70957);
var state_71102__$1 = state_71102;
var statearr_71152_71234 = state_71102__$1;
(statearr_71152_71234[(2)] = inst_70958);

(statearr_71152_71234[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (3))){
var inst_70919 = (state_71102[(21)]);
var inst_70921 = fluree.db.api_js.resolve_block_range.call(null,inst_70919,query_map);
var state_71102__$1 = state_71102;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71102__$1,(6),inst_70921);
} else {
if((state_val_71103 === (12))){
var inst_70929 = (state_71102[(27)]);
var inst_70952 = (state_71102[(2)]);
var state_71102__$1 = (function (){var statearr_71153 = state_71102;
(statearr_71153[(24)] = inst_70952);

return statearr_71153;
})();
if(cljs.core.truth_(inst_70929)){
var statearr_71154_71235 = state_71102__$1;
(statearr_71154_71235[(1)] = (14));

} else {
var statearr_71155_71236 = state_71102__$1;
(statearr_71155_71236[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (2))){
var inst_70914 = (state_71102[(18)]);
var inst_70918 = (state_71102[(2)]);
var inst_70919 = fluree.db.util.async.throw_err.call(null,inst_70918);
var state_71102__$1 = (function (){var statearr_71156 = state_71102;
(statearr_71156[(21)] = inst_70919);

return statearr_71156;
})();
if(cljs.core.truth_(inst_70914)){
var statearr_71157_71237 = state_71102__$1;
(statearr_71157_71237[(1)] = (3));

} else {
var statearr_71158_71238 = state_71102__$1;
(statearr_71158_71238[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (23))){
var inst_70994 = (state_71102[(2)]);
var state_71102__$1 = state_71102;
var statearr_71159_71239 = state_71102__$1;
(statearr_71159_71239[(2)] = inst_70994);

(statearr_71159_71239[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (47))){
var inst_71044 = (state_71102[(2)]);
var state_71102__$1 = state_71102;
var statearr_71160_71240 = state_71102__$1;
(statearr_71160_71240[(2)] = inst_71044);

(statearr_71160_71240[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (35))){
var inst_71026 = (state_71102[(2)]);
var state_71102__$1 = state_71102;
if(cljs.core.truth_(inst_71026)){
var statearr_71161_71241 = state_71102__$1;
(statearr_71161_71241[(1)] = (39));

} else {
var statearr_71162_71242 = state_71102__$1;
(statearr_71162_71242[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (19))){
var inst_70915 = (state_71102[(16)]);
var inst_70969 = cljs.core.sequential_QMARK_.call(null,inst_70915);
var state_71102__$1 = state_71102;
if(inst_70969){
var statearr_71163_71243 = state_71102__$1;
(statearr_71163_71243[(1)] = (21));

} else {
var statearr_71164_71244 = state_71102__$1;
(statearr_71164_71244[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (57))){
var inst_71084 = (state_71102[(19)]);
var state_71102__$1 = state_71102;
var statearr_71165_71245 = state_71102__$1;
(statearr_71165_71245[(2)] = inst_71084);

(statearr_71165_71245[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (11))){
var state_71102__$1 = state_71102;
var statearr_71166_71246 = state_71102__$1;
(statearr_71166_71246[(2)] = (-1));

(statearr_71166_71246[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (9))){
var inst_70941 = (state_71102[(2)]);
var state_71102__$1 = state_71102;
if(cljs.core.truth_(inst_70941)){
var statearr_71167_71247 = state_71102__$1;
(statearr_71167_71247[(1)] = (10));

} else {
var statearr_71168_71248 = state_71102__$1;
(statearr_71168_71248[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (5))){
var inst_70928 = (state_71102[(7)]);
var inst_70927 = (state_71102[(2)]);
var inst_70928__$1 = cljs.core.nth.call(null,inst_70927,(0),null);
var inst_70929 = cljs.core.nth.call(null,inst_70927,(1),null);
var inst_70936 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_71102__$1 = (function (){var statearr_71169 = state_71102;
(statearr_71169[(13)] = inst_70936);

(statearr_71169[(7)] = inst_70928__$1);

(statearr_71169[(27)] = inst_70929);

return statearr_71169;
})();
if(cljs.core.truth_(inst_70928__$1)){
var statearr_71170_71249 = state_71102__$1;
(statearr_71170_71249[(1)] = (7));

} else {
var statearr_71171_71250 = state_71102__$1;
(statearr_71171_71250[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (14))){
var inst_70929 = (state_71102[(27)]);
var inst_70919 = (state_71102[(21)]);
var inst_70954 = fluree.db.time_travel.as_of_block.call(null,inst_70919,inst_70929);
var state_71102__$1 = state_71102;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71102__$1,(17),inst_70954);
} else {
if((state_val_71103 === (45))){
var inst_71006 = (state_71102[(10)]);
var inst_71040 = (inst_71006 == null);
var inst_71041 = cljs.core.not.call(null,inst_71040);
var state_71102__$1 = state_71102;
var statearr_71172_71251 = state_71102__$1;
(statearr_71172_71251[(2)] = inst_71041);

(statearr_71172_71251[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (53))){
var inst_71065 = (state_71102[(2)]);
var state_71102__$1 = state_71102;
var statearr_71173_71252 = state_71102__$1;
(statearr_71173_71252[(2)] = inst_71065);

(statearr_71173_71252[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (26))){
var inst_70981 = (state_71102[(2)]);
var state_71102__$1 = state_71102;
var statearr_71174_71253 = state_71102__$1;
(statearr_71174_71253[(2)] = inst_70981);

(statearr_71174_71253[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (16))){
var inst_70915 = (state_71102[(16)]);
var inst_70962 = (state_71102[(2)]);
var inst_70963 = fluree.db.util.core.subj_ident_QMARK_.call(null,inst_70915);
var state_71102__$1 = (function (){var statearr_71175 = state_71102;
(statearr_71175[(23)] = inst_70962);

return statearr_71175;
})();
if(inst_70963){
var statearr_71176_71254 = state_71102__$1;
(statearr_71176_71254[(1)] = (18));

} else {
var statearr_71177_71255 = state_71102__$1;
(statearr_71177_71255[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (38))){
var inst_71023 = (state_71102[(2)]);
var state_71102__$1 = state_71102;
var statearr_71178_71256 = state_71102__$1;
(statearr_71178_71256[(2)] = inst_71023);

(statearr_71178_71256[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (30))){
var inst_70996 = (state_71102[(8)]);
var inst_71011 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71012 = [inst_70996,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_71013 = (new cljs.core.PersistentVector(null,2,(5),inst_71011,inst_71012,null));
var state_71102__$1 = state_71102;
var statearr_71179_71257 = state_71102__$1;
(statearr_71179_71257[(2)] = inst_71013);

(statearr_71179_71257[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (10))){
var inst_70928 = (state_71102[(7)]);
var inst_70919 = (state_71102[(21)]);
var inst_70943 = (inst_70928 - (1));
var inst_70944 = fluree.db.time_travel.as_of_block.call(null,inst_70919,inst_70943);
var state_71102__$1 = state_71102;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71102__$1,(13),inst_70944);
} else {
if((state_val_71103 === (18))){
var inst_70915 = (state_71102[(16)]);
var inst_70965 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70966 = [inst_70915];
var inst_70967 = (new cljs.core.PersistentVector(null,1,(5),inst_70965,inst_70966,null));
var state_71102__$1 = state_71102;
var statearr_71180_71258 = state_71102__$1;
(statearr_71180_71258[(2)] = inst_70967);

(statearr_71180_71258[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (52))){
var state_71102__$1 = state_71102;
var statearr_71181_71259 = state_71102__$1;
(statearr_71181_71259[(2)] = null);

(statearr_71181_71259[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (42))){
var inst_71005 = (state_71102[(11)]);
var inst_71038 = (state_71102[(20)]);
var inst_71037 = (inst_71005 == null);
var inst_71038__$1 = cljs.core.not.call(null,inst_71037);
var state_71102__$1 = (function (){var statearr_71182 = state_71102;
(statearr_71182[(20)] = inst_71038__$1);

return statearr_71182;
})();
if(inst_71038__$1){
var statearr_71183_71260 = state_71102__$1;
(statearr_71183_71260[(1)] = (45));

} else {
var statearr_71184_71261 = state_71102__$1;
(statearr_71184_71261[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (37))){
var inst_71018 = (state_71102[(26)]);
var state_71102__$1 = state_71102;
var statearr_71185_71262 = state_71102__$1;
(statearr_71185_71262[(2)] = inst_71018);

(statearr_71185_71262[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (8))){
var inst_70928 = (state_71102[(7)]);
var state_71102__$1 = state_71102;
var statearr_71186_71263 = state_71102__$1;
(statearr_71186_71263[(2)] = inst_70928);

(statearr_71186_71263[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71103 === (49))){
var state_71102__$1 = state_71102;
var statearr_71187_71264 = state_71102__$1;
(statearr_71187_71264[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_71189 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71189[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_71189[(1)] = (1));

return statearr_71189;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_71102){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_71102);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e71190){var ex__2749__auto__ = e71190;
var statearr_71191_71265 = state_71102;
(statearr_71191_71265[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_71102[(4)]))){
var statearr_71192_71266 = state_71102;
(statearr_71192_71266[(1)] = cljs.core.first.call(null,(state_71102[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71267 = state_71102;
state_71102 = G__71267;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_71102){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_71102);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_71193 = f__2769__auto__.call(null);
(statearr_71193[(6)] = c__2768__auto__);

return statearr_71193;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__71275 = arguments.length;
switch (G__71275) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5804__auto__)){
var block = temp__5804__auto__;
return fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,fluree.db.time_travel.block_to_int_format.call(null,fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = block;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.map_QMARK_.call(null,block);
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__5043__auto__ = block;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.coll_QMARK_.call(null,block);
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.call(null,multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__71268_SHARP_){
return cljs.core.dissoc.call(null,p1__71268_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals.call(null,multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys.call(null,multi_query_map_SINGLEQUOTE_);
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_71364){
var state_val_71365 = (state_71364[(1)]);
if((state_val_71365 === (7))){
var inst_71325 = (state_71364[(7)]);
var inst_71321 = (state_71364[(8)]);
var inst_71315 = (state_71364[(9)]);
var inst_71318 = (state_71364[(10)]);
var inst_71331 = (function (){var responses = inst_71315;
var responses_STAR_ = inst_71318;
var statuses = inst_71321;
var fuel = inst_71325;
return (function (p1__71271_SHARP_){
return cljs.core._EQ_.call(null,(200),p1__71271_SHARP_);
});
})();
var inst_71332 = cljs.core.some.call(null,inst_71331,inst_71321);
var state_71364__$1 = state_71364;
if(cljs.core.truth_(inst_71332)){
var statearr_71366_71414 = state_71364__$1;
(statearr_71366_71414[(1)] = (9));

} else {
var statearr_71367_71415 = state_71364__$1;
(statearr_71367_71415[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71365 === (20))){
var inst_71359 = (state_71364[(2)]);
var state_71364__$1 = state_71364;
var statearr_71368_71416 = state_71364__$1;
(statearr_71368_71416[(2)] = inst_71359);

(statearr_71368_71416[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71365 === (1))){
var inst_71310 = cljs.core.async.chan.call(null,(1));
var inst_71311 = (function (){var c__2768__auto____$1 = inst_71310;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_71308){
var state_val_71309 = (state_71308[(1)]);
if((state_val_71309 === (1))){
var inst_71276 = cljs.core.first.call(null,keys_SINGLEQUOTE_);
var inst_71277 = cljs.core.first.call(null,vals_SINGLEQUOTE_);
var inst_71278 = cljs.core.assoc.call(null,inst_71277,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_71279 = cljs.core.rest.call(null,keys_SINGLEQUOTE_);
var inst_71280 = cljs.core.rest.call(null,vals_SINGLEQUOTE_);
var inst_71281 = cljs.core.PersistentHashMap.EMPTY;
var inst_71282 = inst_71276;
var inst_71283 = inst_71278;
var inst_71284 = inst_71279;
var inst_71285 = inst_71280;
var inst_71286 = inst_71281;
var state_71308__$1 = (function (){var statearr_71369 = state_71308;
(statearr_71369[(7)] = inst_71284);

(statearr_71369[(8)] = inst_71282);

(statearr_71369[(9)] = inst_71285);

(statearr_71369[(10)] = inst_71283);

(statearr_71369[(11)] = inst_71286);

return statearr_71369;
})();
var statearr_71370_71417 = state_71308__$1;
(statearr_71370_71417[(2)] = null);

(statearr_71370_71417[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71309 === (2))){
var inst_71283 = (state_71308[(10)]);
var inst_71288 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_71283);
var inst_71289 = cljs.core.merge.call(null,opts,inst_71288);
var inst_71290 = cljs.core.assoc.call(null,inst_71283,new cljs.core.Keyword(null,"opts","opts",155075701),inst_71289);
var inst_71291 = fluree.db.api_js.query_async.call(null,db,inst_71290,db_fn);
var state_71308__$1 = state_71308;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71308__$1,(4),inst_71291);
} else {
if((state_val_71309 === (3))){
var inst_71306 = (state_71308[(2)]);
var state_71308__$1 = state_71308;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71308__$1,inst_71306);
} else {
if((state_val_71309 === (4))){
var inst_71284 = (state_71308[(7)]);
var inst_71282 = (state_71308[(8)]);
var inst_71286 = (state_71308[(11)]);
var inst_71293 = (state_71308[(2)]);
var inst_71294 = cljs.core.assoc.call(null,inst_71286,inst_71282,inst_71293);
var inst_71295 = cljs.core.first.call(null,inst_71284);
var state_71308__$1 = (function (){var statearr_71371 = state_71308;
(statearr_71371[(12)] = inst_71294);

return statearr_71371;
})();
if(cljs.core.truth_(inst_71295)){
var statearr_71372_71418 = state_71308__$1;
(statearr_71372_71418[(1)] = (5));

} else {
var statearr_71373_71419 = state_71308__$1;
(statearr_71373_71419[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71309 === (5))){
var inst_71284 = (state_71308[(7)]);
var inst_71285 = (state_71308[(9)]);
var inst_71294 = (state_71308[(12)]);
var inst_71297 = cljs.core.first.call(null,inst_71284);
var inst_71298 = cljs.core.first.call(null,inst_71285);
var inst_71299 = cljs.core.rest.call(null,inst_71284);
var inst_71300 = cljs.core.rest.call(null,inst_71285);
var inst_71282 = inst_71297;
var inst_71283 = inst_71298;
var inst_71284__$1 = inst_71299;
var inst_71285__$1 = inst_71300;
var inst_71286 = inst_71294;
var state_71308__$1 = (function (){var statearr_71374 = state_71308;
(statearr_71374[(7)] = inst_71284__$1);

(statearr_71374[(8)] = inst_71282);

(statearr_71374[(9)] = inst_71285__$1);

(statearr_71374[(10)] = inst_71283);

(statearr_71374[(11)] = inst_71286);

return statearr_71374;
})();
var statearr_71375_71420 = state_71308__$1;
(statearr_71375_71420[(2)] = null);

(statearr_71375_71420[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71309 === (6))){
var inst_71294 = (state_71308[(12)]);
var state_71308__$1 = state_71308;
var statearr_71376_71421 = state_71308__$1;
(statearr_71376_71421[(2)] = inst_71294);

(statearr_71376_71421[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71309 === (7))){
var inst_71304 = (state_71308[(2)]);
var state_71308__$1 = state_71308;
var statearr_71377_71422 = state_71308__$1;
(statearr_71377_71422[(2)] = inst_71304);

(statearr_71377_71422[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_71378 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71378[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_71378[(1)] = (1));

return statearr_71378;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_71308){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_71308);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e71379){var ex__2749__auto__ = e71379;
var statearr_71380_71423 = state_71308;
(statearr_71380_71423[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_71308[(4)]))){
var statearr_71381_71424 = state_71308;
(statearr_71381_71424[(1)] = cljs.core.first.call(null,(state_71308[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71425 = state_71308;
state_71308 = G__71425;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_71308){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_71308);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_71382 = f__2769__auto__.call(null);
(statearr_71382[(6)] = c__2768__auto____$1);

return statearr_71382;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_71312 = cljs.core.async.impl.dispatch.run.call(null,inst_71311);
var state_71364__$1 = (function (){var statearr_71383 = state_71364;
(statearr_71383[(11)] = inst_71312);

return statearr_71383;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71364__$1,(2),inst_71310);
} else {
if((state_val_71365 === (4))){
var inst_71315 = (state_71364[(9)]);
var state_71364__$1 = state_71364;
var statearr_71384_71426 = state_71364__$1;
(statearr_71384_71426[(2)] = inst_71315);

(statearr_71384_71426[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71365 === (15))){
var state_71364__$1 = state_71364;
var statearr_71385_71427 = state_71364__$1;
(statearr_71385_71427[(2)] = (400));

(statearr_71385_71427[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71365 === (13))){
var state_71364__$1 = state_71364;
var statearr_71386_71428 = state_71364__$1;
(statearr_71386_71428[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71365 === (6))){
var inst_71321 = (state_71364[(8)]);
var inst_71329 = cljs.core.first.call(null,inst_71321);
var state_71364__$1 = state_71364;
var statearr_71388_71429 = state_71364__$1;
(statearr_71388_71429[(2)] = inst_71329);

(statearr_71388_71429[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71365 === (17))){
var inst_71342 = (state_71364[(2)]);
var state_71364__$1 = state_71364;
var statearr_71389_71430 = state_71364__$1;
(statearr_71389_71430[(2)] = inst_71342);

(statearr_71389_71430[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71365 === (3))){
var inst_71325 = (state_71364[(7)]);
var inst_71321 = (state_71364[(8)]);
var inst_71315 = (state_71364[(9)]);
var inst_71318 = (state_71364[(10)]);
var inst_71320 = cljs.core.vals.call(null,inst_71315);
var inst_71321__$1 = cljs.core.map.call(null,new cljs.core.Keyword(null,"status","status",-1997798413),inst_71320);
var inst_71322 = (function (){var responses = inst_71315;
var responses_STAR_ = inst_71318;
var statuses = inst_71321__$1;
return (function (p1__71269_SHARP_){
var or__5045__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__71269_SHARP_);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
});
})();
var inst_71323 = cljs.core.vals.call(null,inst_71315);
var inst_71324 = cljs.core.map.call(null,inst_71322,inst_71323);
var inst_71325__$1 = cljs.core.apply.call(null,cljs.core._PLUS_,inst_71324);
var inst_71326 = (function (){var responses = inst_71315;
var responses_STAR_ = inst_71318;
var statuses = inst_71321__$1;
var fuel = inst_71325__$1;
return (function (p1__71270_SHARP_){
return cljs.core._EQ_.call(null,cljs.core.first.call(null,statuses),p1__71270_SHARP_);
});
})();
var inst_71327 = cljs.core.every_QMARK_.call(null,inst_71326,inst_71321__$1);
var state_71364__$1 = (function (){var statearr_71390 = state_71364;
(statearr_71390[(7)] = inst_71325__$1);

(statearr_71390[(8)] = inst_71321__$1);

return statearr_71390;
})();
if(inst_71327){
var statearr_71391_71431 = state_71364__$1;
(statearr_71391_71431[(1)] = (6));

} else {
var statearr_71392_71432 = state_71364__$1;
(statearr_71392_71432[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71365 === (12))){
var state_71364__$1 = state_71364;
var statearr_71393_71433 = state_71364__$1;
(statearr_71393_71433[(2)] = (500));

(statearr_71393_71433[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71365 === (2))){
var inst_71315 = (state_71364[(9)]);
var inst_71314 = (state_71364[(2)]);
var inst_71315__$1 = fluree.db.util.async.throw_err.call(null,inst_71314);
var inst_71316 = (function (){var responses = inst_71315__$1;
return (function (acc,index,response){
var resp = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.call(null,acc,index,resp);
}
});
})();
var inst_71317 = cljs.core.PersistentHashMap.EMPTY;
var inst_71318 = cljs.core.reduce_kv.call(null,inst_71316,inst_71317,inst_71315__$1);
var state_71364__$1 = (function (){var statearr_71394 = state_71364;
(statearr_71394[(9)] = inst_71315__$1);

(statearr_71394[(10)] = inst_71318);

return statearr_71394;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_71395_71434 = state_71364__$1;
(statearr_71395_71434[(1)] = (3));

} else {
var statearr_71396_71435 = state_71364__$1;
(statearr_71396_71435[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71365 === (19))){
var inst_71325 = (state_71364[(7)]);
var inst_71318 = (state_71364[(10)]);
var inst_71348 = (state_71364[(12)]);
var inst_71357 = cljs.core.assoc.call(null,inst_71318,new cljs.core.Keyword(null,"status","status",-1997798413),inst_71348,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_71325);
var state_71364__$1 = state_71364;
var statearr_71397_71436 = state_71364__$1;
(statearr_71397_71436[(2)] = inst_71357);

(statearr_71397_71436[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71365 === (11))){
var inst_71346 = (state_71364[(2)]);
var state_71364__$1 = state_71364;
var statearr_71398_71437 = state_71364__$1;
(statearr_71398_71437[(2)] = inst_71346);

(statearr_71398_71437[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71365 === (9))){
var state_71364__$1 = state_71364;
var statearr_71399_71438 = state_71364__$1;
(statearr_71399_71438[(2)] = (207));

(statearr_71399_71438[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71365 === (5))){
var inst_71362 = (state_71364[(2)]);
var state_71364__$1 = state_71364;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71364__$1,inst_71362);
} else {
if((state_val_71365 === (14))){
var inst_71344 = (state_71364[(2)]);
var state_71364__$1 = state_71364;
var statearr_71400_71439 = state_71364__$1;
(statearr_71400_71439[(2)] = inst_71344);

(statearr_71400_71439[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71365 === (16))){
var state_71364__$1 = state_71364;
var statearr_71401_71440 = state_71364__$1;
(statearr_71401_71440[(2)] = null);

(statearr_71401_71440[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71365 === (10))){
var inst_71325 = (state_71364[(7)]);
var inst_71321 = (state_71364[(8)]);
var inst_71315 = (state_71364[(9)]);
var inst_71318 = (state_71364[(10)]);
var inst_71335 = (function (){var responses = inst_71315;
var responses_STAR_ = inst_71318;
var statuses = inst_71321;
var fuel = inst_71325;
return (function (p1__71272_SHARP_){
return ((499) < p1__71272_SHARP_);
});
})();
var inst_71336 = cljs.core.some.call(null,inst_71335,inst_71321);
var state_71364__$1 = state_71364;
if(cljs.core.truth_(inst_71336)){
var statearr_71402_71441 = state_71364__$1;
(statearr_71402_71441[(1)] = (12));

} else {
var statearr_71403_71442 = state_71364__$1;
(statearr_71403_71442[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71365 === (18))){
var inst_71325 = (state_71364[(7)]);
var inst_71353 = (state_71364[(13)]);
var inst_71318 = (state_71364[(10)]);
var inst_71348 = (state_71364[(12)]);
var inst_71355 = cljs.core.assoc.call(null,inst_71318,new cljs.core.Keyword(null,"status","status",-1997798413),inst_71348,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_71325,new cljs.core.Keyword(null,"block","block",664686210),inst_71353);
var state_71364__$1 = state_71364;
var statearr_71404_71443 = state_71364__$1;
(statearr_71404_71443[(2)] = inst_71355);

(statearr_71404_71443[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71365 === (8))){
var inst_71325 = (state_71364[(7)]);
var inst_71321 = (state_71364[(8)]);
var inst_71315 = (state_71364[(9)]);
var inst_71353 = (state_71364[(13)]);
var inst_71318 = (state_71364[(10)]);
var inst_71348 = (state_71364[(12)]);
var inst_71348__$1 = (state_71364[(2)]);
var inst_71349 = (function (){var responses = inst_71315;
var responses_STAR_ = inst_71318;
var statuses = inst_71321;
var fuel = inst_71325;
var status = inst_71348__$1;
return (function (p1__71273_SHARP_){
return cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__71273_SHARP_));
});
})();
var inst_71350 = cljs.core.vals.call(null,inst_71315);
var inst_71351 = cljs.core.filter.call(null,inst_71349,inst_71350);
var inst_71352 = cljs.core.first.call(null,inst_71351);
var inst_71353__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_71352);
var state_71364__$1 = (function (){var statearr_71405 = state_71364;
(statearr_71405[(13)] = inst_71353__$1);

(statearr_71405[(12)] = inst_71348__$1);

return statearr_71405;
})();
if(cljs.core.truth_(inst_71353__$1)){
var statearr_71406_71444 = state_71364__$1;
(statearr_71406_71444[(1)] = (18));

} else {
var statearr_71407_71445 = state_71364__$1;
(statearr_71407_71445[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_71408 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71408[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_71408[(1)] = (1));

return statearr_71408;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_71364){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_71364);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e71409){var ex__2749__auto__ = e71409;
var statearr_71410_71446 = state_71364;
(statearr_71410_71446[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_71364[(4)]))){
var statearr_71411_71447 = state_71364;
(statearr_71411_71447[(1)] = cljs.core.first.call(null,(state_71364[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71448 = state_71364;
state_71364 = G__71448;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_71364){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_71364);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_71412 = f__2769__auto__.call(null);
(statearr_71412[(6)] = c__2768__auto__);

return statearr_71412;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd    - a map with the command/transaction data as a JSON string
 *  - sig    - the signature of the above stringified map
 *  - id     - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - ledger - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__71450 = arguments.length;
switch (G__71450) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.call(null,ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var ledger_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__71451 = opts;
var map__71451__$1 = cljs.core.__destructure_map.call(null,map__71451);
var auth = cljs.core.get.call(null,map__71451__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__71451__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__71451__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.call(null,map__71451__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__71452 = (cljs.core.truth_((function (){var and__5043__auto__ = auth;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__5043__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__71452,(0),null);
var authority = cljs.core.nth.call(null,vec__71452,(1),null);
var action__$1 = (function (){var or__5045__auto__ = action;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__5045__auto__ = nonce;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__5045__auto__ = expire;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e71455){var e = e71455;
throw cljs.core.ex_info.call(null,"Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__71458 = arguments.length;
switch (G__71458) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.call(null,conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_71492){
var state_val_71493 = (state_71492[(1)]);
if((state_val_71493 === (7))){
var state_71492__$1 = state_71492;
var statearr_71494_71515 = state_71492__$1;
(statearr_71494_71515[(2)] = opts);

(statearr_71494_71515[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71493 === (1))){
var state_71492__$1 = state_71492;
var statearr_71495_71516 = state_71492__$1;
(statearr_71495_71516[(2)] = null);

(statearr_71495_71516[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71493 === (4))){
var inst_71459 = (state_71492[(2)]);
var inst_71460 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71461 = [inst_71459];
var inst_71462 = (new cljs.core.PersistentVector(null,1,(5),inst_71460,inst_71461,null));
var inst_71463 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71462);
var inst_71464 = cljs.core.ex_data.call(null,inst_71459);
var inst_71465 = cljs.core.ex_message.call(null,inst_71459);
var inst_71466 = cljs.core.assoc.call(null,inst_71464,new cljs.core.Keyword(null,"message","message",-406056002),inst_71465);
var state_71492__$1 = (function (){var statearr_71496 = state_71492;
(statearr_71496[(7)] = inst_71463);

return statearr_71496;
})();
var statearr_71497_71517 = state_71492__$1;
(statearr_71497_71517[(2)] = inst_71466);

(statearr_71497_71517[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71493 === (6))){
var inst_71476 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71477 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_71478 = (new cljs.core.PersistentVector(null,1,(5),inst_71476,inst_71477,null));
var inst_71479 = cljs.core.assoc_in.call(null,opts,inst_71478,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_71492__$1 = state_71492;
var statearr_71498_71518 = state_71492__$1;
(statearr_71498_71518[(2)] = inst_71479);

(statearr_71498_71518[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71493 === (3))){
var inst_71490 = (state_71492[(2)]);
var state_71492__$1 = state_71492;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71492__$1,inst_71490);
} else {
if((state_val_71493 === (2))){
var _ = (function (){var statearr_71500 = state_71492;
(statearr_71500[(4)] = cljs.core.cons.call(null,(5),(state_71492[(4)])));

return statearr_71500;
})();
var inst_71472 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_71473 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_71474 = (inst_71473 == null);
var state_71492__$1 = (function (){var statearr_71501 = state_71492;
(statearr_71501[(8)] = inst_71472);

return statearr_71501;
})();
if(cljs.core.truth_(inst_71474)){
var statearr_71502_71519 = state_71492__$1;
(statearr_71502_71519[(1)] = (6));

} else {
var statearr_71503_71520 = state_71492__$1;
(statearr_71503_71520[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71493 === (9))){
var inst_71486 = (state_71492[(2)]);
var inst_71487 = fluree.db.util.async.throw_err.call(null,inst_71486);
var _ = (function (){var statearr_71504 = state_71492;
(statearr_71504[(4)] = cljs.core.rest.call(null,(state_71492[(4)])));

return statearr_71504;
})();
var state_71492__$1 = state_71492;
var statearr_71505_71521 = state_71492__$1;
(statearr_71505_71521[(2)] = inst_71487);

(statearr_71505_71521[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71493 === (5))){
var _ = (function (){var statearr_71506 = state_71492;
(statearr_71506[(4)] = cljs.core.rest.call(null,(state_71492[(4)])));

return statearr_71506;
})();
var state_71492__$1 = state_71492;
var ex71499 = (state_71492__$1[(2)]);
var statearr_71507_71522 = state_71492__$1;
(statearr_71507_71522[(5)] = ex71499);


var statearr_71508_71523 = state_71492__$1;
(statearr_71508_71523[(1)] = (4));

(statearr_71508_71523[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71493 === (8))){
var inst_71472 = (state_71492[(8)]);
var inst_71482 = (state_71492[(2)]);
var inst_71483 = fluree.db.api_js.qry__GT_command.call(null,ledger,query_map,inst_71472,inst_71482);
var inst_71484 = fluree.db.operations.command_async.call(null,conn,inst_71483);
var state_71492__$1 = state_71492;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71492__$1,(9),inst_71484);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_71509 = [null,null,null,null,null,null,null,null,null];
(statearr_71509[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_71509[(1)] = (1));

return statearr_71509;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_71492){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_71492);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e71510){var ex__2749__auto__ = e71510;
var statearr_71511_71524 = state_71492;
(statearr_71511_71524[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_71492[(4)]))){
var statearr_71512_71525 = state_71492;
(statearr_71512_71525[(1)] = cljs.core.first.call(null,(state_71492[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71526 = state_71492;
state_71492 = G__71526;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_71492){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_71492);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_71513 = f__2769__auto__.call(null);
(statearr_71513[(6)] = c__2768__auto__);

return statearr_71513;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

