// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
fluree.db.connection.server_connections_atom = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__67812_67993 = cljs.core.seq.call(null,servers);
var chunk__67813_67994 = null;
var count__67814_67995 = (0);
var i__67815_67996 = (0);
while(true){
if((i__67815_67996 < count__67814_67995)){
var server_67997 = cljs.core._nth.call(null,chunk__67813_67994,i__67815_67996);
var healthcheck_uri_67998 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_67997),"/fdb/health"].join('');
var resp_chan_67999 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_67998,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2768__auto___68000 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__67812_67993,chunk__67813_67994,count__67814_67995,i__67815_67996,c__2768__auto___68000,healthcheck_uri_67998,resp_chan_67999,server_67997){
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = ((function (seq__67812_67993,chunk__67813_67994,count__67814_67995,i__67815_67996,c__2768__auto___68000,healthcheck_uri_67998,resp_chan_67999,server_67997){
return (function (state_67885){
var state_val_67886 = (state_67885[(1)]);
if((state_val_67886 === (1))){
var state_67885__$1 = state_67885;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67885__$1,(2),resp_chan_67999);
} else {
if((state_val_67886 === (2))){
var inst_67871 = (state_67885[(7)]);
var inst_67871__$1 = (state_67885[(2)]);
var inst_67872 = fluree.db.util.core.exception_QMARK_.call(null,inst_67871__$1);
var state_67885__$1 = (function (){var statearr_67887 = state_67885;
(statearr_67887[(7)] = inst_67871__$1);

return statearr_67887;
})();
if(inst_67872){
var statearr_67888_68001 = state_67885__$1;
(statearr_67888_68001[(1)] = (3));

} else {
var statearr_67889_68002 = state_67885__$1;
(statearr_67889_68002[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67886 === (3))){
var inst_67871 = (state_67885[(7)]);
var inst_67874 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67875 = cljs.core.ex_message.call(null,inst_67871);
var inst_67876 = cljs.core.ex_data.call(null,inst_67871);
var inst_67877 = ["Server contact error: ",inst_67875,inst_67876];
var inst_67878 = (new cljs.core.PersistentVector(null,3,(5),inst_67874,inst_67877,null));
var inst_67879 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_67878);
var state_67885__$1 = state_67885;
var statearr_67890_68003 = state_67885__$1;
(statearr_67890_68003[(2)] = inst_67879);

(statearr_67890_68003[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67886 === (4))){
var inst_67881 = cljs.core.async.put_BANG_.call(null,promise_chan,server_67997);
var state_67885__$1 = state_67885;
var statearr_67891_68004 = state_67885__$1;
(statearr_67891_68004[(2)] = inst_67881);

(statearr_67891_68004[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67886 === (5))){
var inst_67883 = (state_67885[(2)]);
var state_67885__$1 = state_67885;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67885__$1,inst_67883);
} else {
return null;
}
}
}
}
}
});})(seq__67812_67993,chunk__67813_67994,count__67814_67995,i__67815_67996,c__2768__auto___68000,healthcheck_uri_67998,resp_chan_67999,server_67997))
;
return ((function (seq__67812_67993,chunk__67813_67994,count__67814_67995,i__67815_67996,switch__2745__auto__,c__2768__auto___68000,healthcheck_uri_67998,resp_chan_67999,server_67997){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0 = (function (){
var statearr_67892 = [null,null,null,null,null,null,null,null];
(statearr_67892[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__);

(statearr_67892[(1)] = (1));

return statearr_67892;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1 = (function (state_67885){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_67885);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e67893){var ex__2749__auto__ = e67893;
var statearr_67894_68005 = state_67885;
(statearr_67894_68005[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_67885[(4)]))){
var statearr_67895_68006 = state_67885;
(statearr_67895_68006[(1)] = cljs.core.first.call(null,(state_67885[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68007 = state_67885;
state_67885 = G__68007;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = function(state_67885){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1.call(this,state_67885);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__;
})()
;})(seq__67812_67993,chunk__67813_67994,count__67814_67995,i__67815_67996,switch__2745__auto__,c__2768__auto___68000,healthcheck_uri_67998,resp_chan_67999,server_67997))
})();
var state__2770__auto__ = (function (){var statearr_67896 = f__2769__auto__.call(null);
(statearr_67896[(6)] = c__2768__auto___68000);

return statearr_67896;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});})(seq__67812_67993,chunk__67813_67994,count__67814_67995,i__67815_67996,c__2768__auto___68000,healthcheck_uri_67998,resp_chan_67999,server_67997))
);



var G__68008 = seq__67812_67993;
var G__68009 = chunk__67813_67994;
var G__68010 = count__67814_67995;
var G__68011 = (i__67815_67996 + (1));
seq__67812_67993 = G__68008;
chunk__67813_67994 = G__68009;
count__67814_67995 = G__68010;
i__67815_67996 = G__68011;
continue;
} else {
var temp__5804__auto___68012 = cljs.core.seq.call(null,seq__67812_67993);
if(temp__5804__auto___68012){
var seq__67812_68013__$1 = temp__5804__auto___68012;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__67812_68013__$1)){
var c__5568__auto___68014 = cljs.core.chunk_first.call(null,seq__67812_68013__$1);
var G__68015 = cljs.core.chunk_rest.call(null,seq__67812_68013__$1);
var G__68016 = c__5568__auto___68014;
var G__68017 = cljs.core.count.call(null,c__5568__auto___68014);
var G__68018 = (0);
seq__67812_67993 = G__68015;
chunk__67813_67994 = G__68016;
count__67814_67995 = G__68017;
i__67815_67996 = G__68018;
continue;
} else {
var server_68019 = cljs.core.first.call(null,seq__67812_68013__$1);
var healthcheck_uri_68020 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_68019),"/fdb/health"].join('');
var resp_chan_68021 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_68020,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2768__auto___68022 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__67812_67993,chunk__67813_67994,count__67814_67995,i__67815_67996,c__2768__auto___68022,healthcheck_uri_68020,resp_chan_68021,server_68019,seq__67812_68013__$1,temp__5804__auto___68012){
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = ((function (seq__67812_67993,chunk__67813_67994,count__67814_67995,i__67815_67996,c__2768__auto___68022,healthcheck_uri_68020,resp_chan_68021,server_68019,seq__67812_68013__$1,temp__5804__auto___68012){
return (function (state_67912){
var state_val_67913 = (state_67912[(1)]);
if((state_val_67913 === (1))){
var state_67912__$1 = state_67912;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67912__$1,(2),resp_chan_68021);
} else {
if((state_val_67913 === (2))){
var inst_67898 = (state_67912[(7)]);
var inst_67898__$1 = (state_67912[(2)]);
var inst_67899 = fluree.db.util.core.exception_QMARK_.call(null,inst_67898__$1);
var state_67912__$1 = (function (){var statearr_67914 = state_67912;
(statearr_67914[(7)] = inst_67898__$1);

return statearr_67914;
})();
if(inst_67899){
var statearr_67915_68023 = state_67912__$1;
(statearr_67915_68023[(1)] = (3));

} else {
var statearr_67916_68024 = state_67912__$1;
(statearr_67916_68024[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67913 === (3))){
var inst_67898 = (state_67912[(7)]);
var inst_67901 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67902 = cljs.core.ex_message.call(null,inst_67898);
var inst_67903 = cljs.core.ex_data.call(null,inst_67898);
var inst_67904 = ["Server contact error: ",inst_67902,inst_67903];
var inst_67905 = (new cljs.core.PersistentVector(null,3,(5),inst_67901,inst_67904,null));
var inst_67906 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_67905);
var state_67912__$1 = state_67912;
var statearr_67917_68025 = state_67912__$1;
(statearr_67917_68025[(2)] = inst_67906);

(statearr_67917_68025[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67913 === (4))){
var inst_67908 = cljs.core.async.put_BANG_.call(null,promise_chan,server_68019);
var state_67912__$1 = state_67912;
var statearr_67918_68026 = state_67912__$1;
(statearr_67918_68026[(2)] = inst_67908);

(statearr_67918_68026[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67913 === (5))){
var inst_67910 = (state_67912[(2)]);
var state_67912__$1 = state_67912;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67912__$1,inst_67910);
} else {
return null;
}
}
}
}
}
});})(seq__67812_67993,chunk__67813_67994,count__67814_67995,i__67815_67996,c__2768__auto___68022,healthcheck_uri_68020,resp_chan_68021,server_68019,seq__67812_68013__$1,temp__5804__auto___68012))
;
return ((function (seq__67812_67993,chunk__67813_67994,count__67814_67995,i__67815_67996,switch__2745__auto__,c__2768__auto___68022,healthcheck_uri_68020,resp_chan_68021,server_68019,seq__67812_68013__$1,temp__5804__auto___68012){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0 = (function (){
var statearr_67919 = [null,null,null,null,null,null,null,null];
(statearr_67919[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__);

(statearr_67919[(1)] = (1));

return statearr_67919;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1 = (function (state_67912){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_67912);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e67920){var ex__2749__auto__ = e67920;
var statearr_67921_68027 = state_67912;
(statearr_67921_68027[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_67912[(4)]))){
var statearr_67922_68028 = state_67912;
(statearr_67922_68028[(1)] = cljs.core.first.call(null,(state_67912[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68029 = state_67912;
state_67912 = G__68029;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = function(state_67912){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1.call(this,state_67912);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__;
})()
;})(seq__67812_67993,chunk__67813_67994,count__67814_67995,i__67815_67996,switch__2745__auto__,c__2768__auto___68022,healthcheck_uri_68020,resp_chan_68021,server_68019,seq__67812_68013__$1,temp__5804__auto___68012))
})();
var state__2770__auto__ = (function (){var statearr_67923 = f__2769__auto__.call(null);
(statearr_67923[(6)] = c__2768__auto___68022);

return statearr_67923;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});})(seq__67812_67993,chunk__67813_67994,count__67814_67995,i__67815_67996,c__2768__auto___68022,healthcheck_uri_68020,resp_chan_68021,server_68019,seq__67812_68013__$1,temp__5804__auto___68012))
);



var G__68030 = cljs.core.next.call(null,seq__67812_68013__$1);
var G__68031 = null;
var G__68032 = (0);
var G__68033 = (0);
seq__67812_67993 = G__68030;
chunk__67813_67994 = G__68031;
count__67814_67995 = G__68032;
i__67815_67996 = G__68033;
continue;
}
} else {
}
}
break;
}

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_67967){
var state_val_67968 = (state_67967[(1)]);
if((state_val_67968 === (7))){
var inst_67939 = (state_67967[(7)]);
var inst_67946 = cljs.core._EQ_.call(null,inst_67939,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_67967__$1 = state_67967;
if(inst_67946){
var statearr_67969_68034 = state_67967__$1;
(statearr_67969_68034[(1)] = (9));

} else {
var statearr_67970_68035 = state_67967__$1;
(statearr_67970_68035[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (1))){
var inst_67932 = (state_67967[(8)]);
var inst_67931 = (state_67967[(9)]);
var inst_67931__$1 = promise_chan;
var inst_67932__$1 = cljs.core.async.timeout.call(null,(60000));
var inst_67933 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67934 = [inst_67931__$1,inst_67932__$1];
var inst_67935 = (new cljs.core.PersistentVector(null,2,(5),inst_67933,inst_67934,null));
var state_67967__$1 = (function (){var statearr_67971 = state_67967;
(statearr_67971[(8)] = inst_67932__$1);

(statearr_67971[(9)] = inst_67931__$1);

return statearr_67971;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_67967__$1,(2),inst_67935);
} else {
if((state_val_67968 === (4))){
var inst_67939 = (state_67967[(7)]);
var inst_67932 = (state_67967[(8)]);
var inst_67943 = cljs.core._EQ_.call(null,inst_67939,inst_67932);
var state_67967__$1 = state_67967;
if(inst_67943){
var statearr_67972_68036 = state_67967__$1;
(statearr_67972_68036[(1)] = (6));

} else {
var statearr_67973_68037 = state_67967__$1;
(statearr_67973_68037[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (13))){
var state_67967__$1 = state_67967;
var statearr_67974_68038 = state_67967__$1;
(statearr_67974_68038[(2)] = null);

(statearr_67974_68038[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (6))){
var state_67967__$1 = state_67967;
var statearr_67975_68039 = state_67967__$1;
(statearr_67975_68039[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_67975_68039[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (3))){
var state_67967__$1 = state_67967;
var statearr_67976_68040 = state_67967__$1;
(statearr_67976_68040[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_67976_68040[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (12))){
var inst_67957 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"server","server",1499190120));
var inst_67958 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_67959 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_67960 = cljs.core.PersistentHashMap.fromArrays(inst_67958,inst_67959);
var inst_67961 = cljs.core.ex_info.call(null,"Unable to find healthy server before timeout.",inst_67960);
var inst_67962 = cljs.core.async.put_BANG_.call(null,promise_chan,inst_67961);
var state_67967__$1 = (function (){var statearr_67977 = state_67967;
(statearr_67977[(10)] = inst_67957);

return statearr_67977;
})();
var statearr_67978_68041 = state_67967__$1;
(statearr_67978_68041[(2)] = inst_67962);

(statearr_67978_68041[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (2))){
var inst_67939 = (state_67967[(7)]);
var inst_67931 = (state_67967[(9)]);
var inst_67937 = (state_67967[(2)]);
var inst_67938 = cljs.core.nth.call(null,inst_67937,(0),null);
var inst_67939__$1 = cljs.core.nth.call(null,inst_67937,(1),null);
var inst_67940 = cljs.core._EQ_.call(null,inst_67939__$1,inst_67931);
var state_67967__$1 = (function (){var statearr_67979 = state_67967;
(statearr_67979[(11)] = inst_67938);

(statearr_67979[(7)] = inst_67939__$1);

return statearr_67979;
})();
if(inst_67940){
var statearr_67980_68042 = state_67967__$1;
(statearr_67980_68042[(1)] = (3));

} else {
var statearr_67981_68043 = state_67967__$1;
(statearr_67981_68043[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (11))){
var inst_67950 = (state_67967[(2)]);
var state_67967__$1 = state_67967;
var statearr_67982_68044 = state_67967__$1;
(statearr_67982_68044[(2)] = inst_67950);

(statearr_67982_68044[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (9))){
var inst_67938 = (state_67967[(11)]);
var state_67967__$1 = state_67967;
var statearr_67983_68045 = state_67967__$1;
(statearr_67983_68045[(2)] = inst_67938);

(statearr_67983_68045[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (5))){
var inst_67954 = (state_67967[(2)]);
var inst_67955 = cljs.core._EQ_.call(null,new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_67954);
var state_67967__$1 = state_67967;
if(inst_67955){
var statearr_67984_68046 = state_67967__$1;
(statearr_67984_68046[(1)] = (12));

} else {
var statearr_67985_68047 = state_67967__$1;
(statearr_67985_68047[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (14))){
var inst_67965 = (state_67967[(2)]);
var state_67967__$1 = state_67967;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67967__$1,inst_67965);
} else {
if((state_val_67968 === (10))){
var state_67967__$1 = state_67967;
var statearr_67986_68048 = state_67967__$1;
(statearr_67986_68048[(2)] = null);

(statearr_67986_68048[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67968 === (8))){
var inst_67952 = (state_67967[(2)]);
var state_67967__$1 = state_67967;
var statearr_67987_68049 = state_67967__$1;
(statearr_67987_68049[(2)] = inst_67952);

(statearr_67987_68049[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0 = (function (){
var statearr_67988 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67988[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__);

(statearr_67988[(1)] = (1));

return statearr_67988;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1 = (function (state_67967){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_67967);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e67989){var ex__2749__auto__ = e67989;
var statearr_67990_68050 = state_67967;
(statearr_67990_68050[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_67967[(4)]))){
var statearr_67991_68051 = state_67967;
(statearr_67991_68051[(1)] = cljs.core.first.call(null,(state_67967[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68052 = state_67967;
state_67967 = G__68052;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = function(state_67967){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1.call(this,state_67967);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_67992 = f__2769__auto__.call(null);
(statearr_67992[(6)] = c__2768__auto__);

return statearr_67992;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = cljs.core.random_uuid.call(null);
var new_state = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.call(null)], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.call(null,lock_id,cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server.call(null,conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68096){
var state_val_68097 = (state_68096[(1)]);
if((state_val_68097 === (7))){
var state_68096__$1 = state_68096;
var statearr_68098_68124 = state_68096__$1;
(statearr_68098_68124[(2)] = null);

(statearr_68098_68124[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68097 === (1))){
var state_68096__$1 = state_68096;
var statearr_68099_68125 = state_68096__$1;
(statearr_68099_68125[(2)] = null);

(statearr_68099_68125[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68097 === (4))){
var inst_68053 = (state_68096[(2)]);
var state_68096__$1 = state_68096;
var statearr_68100_68126 = state_68096__$1;
(statearr_68100_68126[(2)] = inst_68053);

(statearr_68100_68126[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68097 === (6))){
var inst_68075 = fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
var state_68096__$1 = state_68096;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68096__$1,(9),inst_68075);
} else {
if((state_val_68097 === (3))){
var inst_68094 = (state_68096[(2)]);
var state_68096__$1 = state_68096;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68096__$1,inst_68094);
} else {
if((state_val_68097 === (12))){
var inst_68088 = (state_68096[(2)]);
var state_68096__$1 = state_68096;
var statearr_68101_68127 = state_68096__$1;
(statearr_68101_68127[(2)] = inst_68088);

(statearr_68101_68127[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68097 === (2))){
var inst_68069 = (state_68096[(7)]);
var inst_68059 = (state_68096[(8)]);
var inst_68064 = (state_68096[(9)]);
var _ = (function (){var statearr_68102 = state_68096;
(statearr_68102[(4)] = cljs.core.cons.call(null,(5),(state_68096[(4)])));

return statearr_68102;
})();
var inst_68059__$1 = cljs.core.random_uuid.call(null);
var inst_68060 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68061 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_68062 = (new cljs.core.PersistentVector(null,2,(5),inst_68060,inst_68061,null));
var inst_68063 = (function (){var lock_id = inst_68059__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.call(null)], null);
}
});
})();
var inst_68064__$1 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_68062,inst_68063);
var inst_68065 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68066 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_68067 = (new cljs.core.PersistentVector(null,3,(5),inst_68065,inst_68066,null));
var inst_68068 = cljs.core.get_in.call(null,inst_68064__$1,inst_68067);
var inst_68069__$1 = cljs.core._EQ_.call(null,inst_68059__$1,inst_68068);
var inst_68070 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68071 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_68072 = (new cljs.core.PersistentVector(null,3,(5),inst_68070,inst_68071,null));
var inst_68073 = cljs.core.get_in.call(null,inst_68064__$1,inst_68072);
var state_68096__$1 = (function (){var statearr_68103 = state_68096;
(statearr_68103[(7)] = inst_68069__$1);

(statearr_68103[(8)] = inst_68059__$1);

(statearr_68103[(9)] = inst_68064__$1);

(statearr_68103[(10)] = inst_68073);

return statearr_68103;
})();
if(inst_68069__$1){
var statearr_68104_68128 = state_68096__$1;
(statearr_68104_68128[(1)] = (6));

} else {
var statearr_68105_68129 = state_68096__$1;
(statearr_68105_68129[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68097 === (11))){
var inst_68079 = (state_68096[(11)]);
var inst_68073 = (state_68096[(10)]);
var inst_68080 = (state_68096[(12)]);
var inst_68086 = fluree.db.util.xhttp.try_socket.call(null,inst_68079,sub_chan,pub_chan,inst_68073,(60000),inst_68080);
var state_68096__$1 = state_68096;
var statearr_68107_68130 = state_68096__$1;
(statearr_68107_68130[(2)] = inst_68086);

(statearr_68107_68130[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68097 === (9))){
var inst_68069 = (state_68096[(7)]);
var inst_68079 = (state_68096[(11)]);
var inst_68059 = (state_68096[(8)]);
var inst_68064 = (state_68096[(9)]);
var inst_68077 = (state_68096[(13)]);
var inst_68073 = (state_68096[(10)]);
var inst_68077__$1 = (state_68096[(2)]);
var inst_68078 = clojure.string.replace.call(null,inst_68077__$1,"http","ws");
var inst_68079__$1 = [inst_68078,"/fdb/ws"].join('');
var inst_68080 = (function (){var lock_id = inst_68059;
var state = inst_68064;
var have_lock_QMARK_ = inst_68069;
var resp_chan = inst_68073;
var healthy_server = inst_68077__$1;
var ws_url = inst_68079__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.call(null,conn_id);
});
})();
var inst_68081 = fluree.db.util.core.exception_QMARK_.call(null,inst_68077__$1);
var state_68096__$1 = (function (){var statearr_68108 = state_68096;
(statearr_68108[(11)] = inst_68079__$1);

(statearr_68108[(13)] = inst_68077__$1);

(statearr_68108[(12)] = inst_68080);

return statearr_68108;
})();
if(inst_68081){
var statearr_68109_68131 = state_68096__$1;
(statearr_68109_68131[(1)] = (10));

} else {
var statearr_68110_68132 = state_68096__$1;
(statearr_68110_68132[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68097 === (5))){
var _ = (function (){var statearr_68111 = state_68096;
(statearr_68111[(4)] = cljs.core.rest.call(null,(state_68096[(4)])));

return statearr_68111;
})();
var state_68096__$1 = state_68096;
var ex68106 = (state_68096__$1[(2)]);
var statearr_68112_68133 = state_68096__$1;
(statearr_68112_68133[(5)] = ex68106);


if((ex68106 instanceof Error)){
var statearr_68113_68134 = state_68096__$1;
(statearr_68113_68134[(1)] = (4));

(statearr_68113_68134[(5)] = null);

} else {
throw ex68106;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68097 === (10))){
var inst_68077 = (state_68096[(13)]);
var inst_68073 = (state_68096[(10)]);
var inst_68083 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"ws","ws",86841443));
var inst_68084 = cljs.core.async.put_BANG_.call(null,inst_68073,inst_68077);
var state_68096__$1 = (function (){var statearr_68114 = state_68096;
(statearr_68114[(14)] = inst_68083);

return statearr_68114;
})();
var statearr_68115_68135 = state_68096__$1;
(statearr_68115_68135[(2)] = inst_68084);

(statearr_68115_68135[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68097 === (8))){
var inst_68073 = (state_68096[(10)]);
var inst_68091 = (state_68096[(2)]);
var _ = (function (){var statearr_68116 = state_68096;
(statearr_68116[(4)] = cljs.core.rest.call(null,(state_68096[(4)])));

return statearr_68116;
})();
var state_68096__$1 = (function (){var statearr_68117 = state_68096;
(statearr_68117[(15)] = inst_68091);

return statearr_68117;
})();
var statearr_68118_68136 = state_68096__$1;
(statearr_68118_68136[(2)] = inst_68073);

(statearr_68118_68136[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2746__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2746__auto____0 = (function (){
var statearr_68119 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68119[(0)] = fluree$db$connection$establish_socket_$_state_machine__2746__auto__);

(statearr_68119[(1)] = (1));

return statearr_68119;
});
var fluree$db$connection$establish_socket_$_state_machine__2746__auto____1 = (function (state_68096){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68096);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68120){var ex__2749__auto__ = e68120;
var statearr_68121_68137 = state_68096;
(statearr_68121_68137[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68096[(4)]))){
var statearr_68122_68138 = state_68096;
(statearr_68122_68138[(1)] = cljs.core.first.call(null,(state_68096[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68139 = state_68096;
state_68096 = G__68139;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2746__auto__ = function(state_68096){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2746__auto____1.call(this,state_68096);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2746__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2746__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68123 = f__2769__auto__.call(null);
(statearr_68123[(6)] = c__2768__auto__);

return statearr_68123;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {fluree.db.index.Resolver}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.storage.core.Store}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_list = storage_list;
this.storage_write = storage_write;
this.storage_exists = storage_exists;
this.storage_rename = storage_rename;
this.storage_delete = storage_delete;
this.object_cache = object_cache;
this.async_cache = async_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k68141,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__68145 = k68141;
var G__68145__$1 = (((G__68145 instanceof cljs.core.Keyword))?G__68145.fqn:null);
switch (G__68145__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-list":
return self__.storage_list;

break;
case "storage-write":
return self__.storage_write;

break;
case "storage-exists":
return self__.storage_exists;

break;
case "storage-rename":
return self__.storage_rename;

break;
case "storage-delete":
return self__.storage_delete;

break;
case "object-cache":
return self__.object_cache;

break;
case "async-cache":
return self__.async_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k68141,else__5346__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5366__auto__,p__68146){
var vec__68147 = p__68146;
var k__5367__auto__ = cljs.core.nth.call(null,vec__68147,(0),null);
var v__5368__auto__ = cljs.core.nth.call(null,vec__68147,(1),null);
return f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__);
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.connection.Connection{",", ","}",opts__5360__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__68140){
var self__ = this;
var G__68140__$1 = this;
return (new cljs.core.RecordIter((0),G__68140__$1,27,new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (27 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll.call(null,coll__5340__auto__));
}).call(null,this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this68142,other68143){
var self__ = this;
var this68142__$1 = this;
return (((!((other68143 == null)))) && ((((this68142__$1.constructor === other68143.constructor)) && (((cljs.core._EQ_.call(null,this68142__$1.id,other68143.id)) && (((cljs.core._EQ_.call(null,this68142__$1.servers,other68143.servers)) && (((cljs.core._EQ_.call(null,this68142__$1.state,other68143.state)) && (((cljs.core._EQ_.call(null,this68142__$1.req_chan,other68143.req_chan)) && (((cljs.core._EQ_.call(null,this68142__$1.sub_chan,other68143.sub_chan)) && (((cljs.core._EQ_.call(null,this68142__$1.pub_chan,other68143.pub_chan)) && (((cljs.core._EQ_.call(null,this68142__$1.group,other68143.group)) && (((cljs.core._EQ_.call(null,this68142__$1.storage_read,other68143.storage_read)) && (((cljs.core._EQ_.call(null,this68142__$1.storage_list,other68143.storage_list)) && (((cljs.core._EQ_.call(null,this68142__$1.storage_write,other68143.storage_write)) && (((cljs.core._EQ_.call(null,this68142__$1.storage_exists,other68143.storage_exists)) && (((cljs.core._EQ_.call(null,this68142__$1.storage_rename,other68143.storage_rename)) && (((cljs.core._EQ_.call(null,this68142__$1.storage_delete,other68143.storage_delete)) && (((cljs.core._EQ_.call(null,this68142__$1.object_cache,other68143.object_cache)) && (((cljs.core._EQ_.call(null,this68142__$1.async_cache,other68143.async_cache)) && (((cljs.core._EQ_.call(null,this68142__$1.parallelism,other68143.parallelism)) && (((cljs.core._EQ_.call(null,this68142__$1.serializer,other68143.serializer)) && (((cljs.core._EQ_.call(null,this68142__$1.default_network,other68143.default_network)) && (((cljs.core._EQ_.call(null,this68142__$1.transactor_QMARK_,other68143.transactor_QMARK_)) && (((cljs.core._EQ_.call(null,this68142__$1.publish,other68143.publish)) && (((cljs.core._EQ_.call(null,this68142__$1.transact_handler,other68143.transact_handler)) && (((cljs.core._EQ_.call(null,this68142__$1.tx_private_key,other68143.tx_private_key)) && (((cljs.core._EQ_.call(null,this68142__$1.tx_key_id,other68143.tx_key_id)) && (((cljs.core._EQ_.call(null,this68142__$1.meta,other68143.meta)) && (((cljs.core._EQ_.call(null,this68142__$1.add_listener,other68143.add_listener)) && (((cljs.core._EQ_.call(null,this68142__$1.remove_listener,other68143.remove_listener)) && (((cljs.core._EQ_.call(null,this68142__$1.close,other68143.close)) && (cljs.core._EQ_.call(null,this68142__$1.__extmap,other68143.__extmap)))))))))))))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$resolve$arity$2 = (function (conn,p__68150){
var self__ = this;
var map__68151 = p__68150;
var map__68151__$1 = cljs.core.__destructure_map.call(null,map__68151);
var node = map__68151__$1;
var id__$1 = cljs.core.get.call(null,map__68151__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.call(null,map__68151__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var tempid = cljs.core.get.call(null,map__68151__$1,new cljs.core.Keyword(null,"tempid","tempid",1427663222));
var conn__$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),id__$1)){
return fluree.db.storage.core.resolve_empty_leaf.call(null,node);
} else {
return self__.async_cache.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null),(function (_){
return fluree.db.storage.core.resolve_index_node.call(null,conn__$1,node,(function (){
return self__.async_cache.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null),null);
}));
}));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 27, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),null,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),null,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k68141){
var self__ = this;
var this__5350__auto____$1 = this;
var G__68152 = k68141;
var G__68152__$1 = (((G__68152 instanceof cljs.core.Keyword))?G__68152.fqn:null);
switch (G__68152__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-list":
case "storage-write":
case "storage-exists":
case "storage-rename":
case "storage-delete":
case "object-cache":
case "async-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k68141);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__68140){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__68153 = cljs.core.keyword_identical_QMARK_;
var expr__68154 = k__5352__auto__;
if(cljs.core.truth_(pred__68153.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__68154))){
return (new fluree.db.connection.Connection(G__68140,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68153.call(null,new cljs.core.Keyword(null,"servers","servers",1881102005),expr__68154))){
return (new fluree.db.connection.Connection(self__.id,G__68140,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68153.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__68154))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__68140,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68153.call(null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),expr__68154))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__68140,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68153.call(null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),expr__68154))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__68140,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68153.call(null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),expr__68154))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__68140,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68153.call(null,new cljs.core.Keyword(null,"group","group",582596132),expr__68154))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__68140,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68153.call(null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),expr__68154))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__68140,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68153.call(null,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),expr__68154))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__68140,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68153.call(null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),expr__68154))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,G__68140,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68153.call(null,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),expr__68154))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,G__68140,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68153.call(null,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),expr__68154))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,G__68140,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68153.call(null,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),expr__68154))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,G__68140,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68153.call(null,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),expr__68154))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,G__68140,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68153.call(null,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),expr__68154))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,G__68140,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68153.call(null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),expr__68154))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,G__68140,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68153.call(null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),expr__68154))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,G__68140,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68153.call(null,new cljs.core.Keyword(null,"default-network","default-network",586420705),expr__68154))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,G__68140,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68153.call(null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),expr__68154))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,G__68140,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68153.call(null,new cljs.core.Keyword(null,"publish","publish",-1178026850),expr__68154))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__68140,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68153.call(null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),expr__68154))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__68140,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68153.call(null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),expr__68154))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__68140,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68153.call(null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),expr__68154))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__68140,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68153.call(null,new cljs.core.Keyword(null,"meta","meta",1499536964),expr__68154))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__68140,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68153.call(null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),expr__68154))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__68140,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68153.call(null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),expr__68154))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__68140,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68153.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__68154))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__68140,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5352__auto__,G__68140),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$read$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return self__.storage_read.call(null,k);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$write$arity$3 = (function (_,k,data){
var self__ = this;
var ___$1 = this;
return self__.storage_write.call(null,k,data);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$exists_QMARK_$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return self__.storage_exists.call(null,k);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$rename$arity$3 = (function (_,old_key,new_key){
var self__ = this;
var ___$1 = this;
return self__.storage_rename.call(null,old_key,new_key);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$list$arity$2 = (function (_,d){
var self__ = this;
var ___$1 = this;
return self__.storage_list.call(null,d);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$delete$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return self__.storage_delete.call(null,k);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__68140){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__68140,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5349__auto__,(0)),cljs.core._nth.call(null,entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-list","storage-list",-1451581441,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"storage-exists","storage-exists",-1251171694,null),new cljs.core.Symbol(null,"storage-rename","storage-rename",1329931298,null),new cljs.core.Symbol(null,"storage-delete","storage-delete",-1024062237,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"async-cache","async-cache",1450071636,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write.call(null,writer__5390__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__68144){
var extmap__5385__auto__ = (function (){var G__68156 = cljs.core.dissoc.call(null,G__68144,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582));
if(cljs.core.record_QMARK_.call(null,G__68144)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__68156);
} else {
return G__68156;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__68144),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__68144),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__68144),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__68144),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__68144),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__68144),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__68144),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__68144),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328).cljs$core$IFn$_invoke$arity$1(G__68144),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__68144),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(G__68144),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229).cljs$core$IFn$_invoke$arity$1(G__68144),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532).cljs$core$IFn$_invoke$arity$1(G__68144),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__68144),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(G__68144),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__68144),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__68144),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__68144),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__68144),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__68144),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__68144),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__68144),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__68144),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__68144),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__68144),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__68144),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__68144),null,cljs.core.not_empty.call(null,extmap__5385__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.call(null,servers,/,/):servers);
if(((cljs.core.empty_QMARK_.call(null,servers)) && (cljs.core.not.call(null,transactor_QMARK_)))){
throw cljs.core.ex_info.call(null,"At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty.call(null,servers_STAR_))){
var G__68162 = servers_STAR_;
var vec__68163 = G__68162;
var seq__68164 = cljs.core.seq.call(null,vec__68163);
var first__68165 = cljs.core.first.call(null,seq__68164);
var seq__68164__$1 = cljs.core.next.call(null,seq__68164);
var server = first__68165;
var r = seq__68164__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__68162__$1 = G__68162;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__68169 = G__68162__$1;
var seq__68170 = cljs.core.seq.call(null,vec__68169);
var first__68171 = cljs.core.first.call(null,seq__68170);
var seq__68170__$1 = cljs.core.next.call(null,seq__68170);
var server__$1 = first__68171;
var r__$1 = seq__68170__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.call(null,["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.call(null,server__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace.call(null,server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches.call(null,/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_.call(null,server__$2,"//"))?(function(){throw cljs.core.ex_info.call(null,["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches.call(null,/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_.call(null,server__$2,"https://");
var result_STAR_ = cljs.core.conj.call(null,result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches.call(null,fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.call(null,["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.call(null,is_https_QMARK_,https_QMARK___$2);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_.call(null,r__$1)){
return cljs.core.shuffle.call(null,result_STAR_);
} else {
var G__68172 = r__$1;
var G__68173 = is_https_QMARK_;
var G__68174 = result_STAR_;
G__68162__$1 = G__68172;
https_QMARK___$1 = G__68173;
result__$1 = G__68174;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__68175 = cljs.core.get_in.call(null,fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__68175 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_.call(null,G__68175);
}
})();
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket.call(null,existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68204){
var state_val_68205 = (state_68204[(1)]);
if((state_val_68205 === (7))){
var inst_68190 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68191 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68192 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68193 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68194 = fluree.db.connection.establish_socket.call(null,inst_68190,inst_68191,inst_68192,inst_68193);
var state_68204__$1 = state_68204;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68204__$1,(9),inst_68194);
} else {
if((state_val_68205 === (1))){
var state_68204__$1 = state_68204;
var statearr_68206_68225 = state_68204__$1;
(statearr_68206_68225[(2)] = null);

(statearr_68206_68225[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68205 === (4))){
var inst_68176 = (state_68204[(2)]);
var state_68204__$1 = state_68204;
var statearr_68207_68226 = state_68204__$1;
(statearr_68207_68226[(2)] = inst_68176);

(statearr_68207_68226[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68205 === (6))){
var inst_68187 = (state_68204[(7)]);
var state_68204__$1 = state_68204;
var statearr_68208_68227 = state_68204__$1;
(statearr_68208_68227[(2)] = inst_68187);

(statearr_68208_68227[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68205 === (3))){
var inst_68202 = (state_68204[(2)]);
var state_68204__$1 = state_68204;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68204__$1,inst_68202);
} else {
if((state_val_68205 === (2))){
var inst_68187 = (state_68204[(7)]);
var _ = (function (){var statearr_68210 = state_68204;
(statearr_68210[(4)] = cljs.core.cons.call(null,(5),(state_68204[(4)])));

return statearr_68210;
})();
var inst_68182 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_68183 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68184 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68185 = [inst_68184,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_68186 = (new cljs.core.PersistentVector(null,3,(5),inst_68183,inst_68185,null));
var inst_68187__$1 = cljs.core.get_in.call(null,inst_68182,inst_68186);
var state_68204__$1 = (function (){var statearr_68211 = state_68204;
(statearr_68211[(7)] = inst_68187__$1);

return statearr_68211;
})();
if(cljs.core.truth_(inst_68187__$1)){
var statearr_68212_68228 = state_68204__$1;
(statearr_68212_68228[(1)] = (6));

} else {
var statearr_68213_68229 = state_68204__$1;
(statearr_68213_68229[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68205 === (9))){
var inst_68196 = (state_68204[(2)]);
var inst_68197 = fluree.db.util.async.throw_err.call(null,inst_68196);
var state_68204__$1 = state_68204;
var statearr_68214_68230 = state_68204__$1;
(statearr_68214_68230[(2)] = inst_68197);

(statearr_68214_68230[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68205 === (5))){
var _ = (function (){var statearr_68215 = state_68204;
(statearr_68215[(4)] = cljs.core.rest.call(null,(state_68204[(4)])));

return statearr_68215;
})();
var state_68204__$1 = state_68204;
var ex68209 = (state_68204__$1[(2)]);
var statearr_68216_68231 = state_68204__$1;
(statearr_68216_68231[(5)] = ex68209);


if((ex68209 instanceof Error)){
var statearr_68217_68232 = state_68204__$1;
(statearr_68217_68232[(1)] = (4));

(statearr_68217_68232[(5)] = null);

} else {
throw ex68209;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68205 === (8))){
var inst_68199 = (state_68204[(2)]);
var _ = (function (){var statearr_68218 = state_68204;
(statearr_68218[(4)] = cljs.core.rest.call(null,(state_68204[(4)])));

return statearr_68218;
})();
var state_68204__$1 = state_68204;
var statearr_68219_68233 = state_68204__$1;
(statearr_68219_68233[(2)] = inst_68199);

(statearr_68219_68233[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2746__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2746__auto____0 = (function (){
var statearr_68220 = [null,null,null,null,null,null,null,null];
(statearr_68220[(0)] = fluree$db$connection$get_socket_$_state_machine__2746__auto__);

(statearr_68220[(1)] = (1));

return statearr_68220;
});
var fluree$db$connection$get_socket_$_state_machine__2746__auto____1 = (function (state_68204){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68204);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68221){var ex__2749__auto__ = e68221;
var statearr_68222_68234 = state_68204;
(statearr_68222_68234[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68204[(4)]))){
var statearr_68223_68235 = state_68204;
(statearr_68223_68235[(1)] = cljs.core.first.call(null,(state_68204[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68236 = state_68204;
state_68204 = G__68236;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2746__auto__ = function(state_68204){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2746__auto____1.call(this,state_68204);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2746__auto____0;
fluree$db$connection$get_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2746__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68224 = f__2769__auto__.call(null);
(statearr_68224[(6)] = c__2768__auto__);

return statearr_68224;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__5045__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.call(null);
var msg = (function (){try{return fluree.db.util.json.stringify.call(null,message);
}catch (e68237){var e = e68237;
fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Unable to publish message on websocket. Error encoding JSON message: ",message], null));

cljs.core.async.put_BANG_.call(null,resp_chan,cljs.core.ex_info.call(null,["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.call(null,pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(p__68239){
var map__68240 = p__68239;
var map__68240__$1 = cljs.core.__destructure_map.call(null,map__68240);
var conn = map__68240__$1;
var state = cljs.core.get.call(null,map__68240__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var req_chan = cljs.core.get.call(null,map__68240__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046));
var publish = cljs.core.get.call(null,map__68240__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68386){
var state_val_68387 = (state_68386[(1)]);
if((state_val_68387 === (7))){
var inst_68382 = (state_68386[(2)]);
var state_68386__$1 = state_68386;
var statearr_68389_68463 = state_68386__$1;
(statearr_68389_68463[(2)] = inst_68382);

(statearr_68389_68463[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (20))){
var _ = (function (){var statearr_68390 = state_68386;
(statearr_68390[(4)] = cljs.core.rest.call(null,(state_68386[(4)])));

return statearr_68390;
})();
var state_68386__$1 = state_68386;
var ex68388 = (state_68386__$1[(2)]);
var statearr_68391_68464 = state_68386__$1;
(statearr_68391_68464[(5)] = ex68388);


var statearr_68392_68465 = state_68386__$1;
(statearr_68392_68465[(1)] = (10));

(statearr_68392_68465[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (27))){
var inst_68343 = (state_68386[(7)]);
var inst_68343__$1 = (state_68386[(2)]);
var inst_68344 = inst_68343__$1 === true;
var state_68386__$1 = (function (){var statearr_68393 = state_68386;
(statearr_68393[(7)] = inst_68343__$1);

return statearr_68393;
})();
if(cljs.core.truth_(inst_68344)){
var statearr_68394_68466 = state_68386__$1;
(statearr_68394_68466[(1)] = (28));

} else {
var statearr_68395_68467 = state_68386__$1;
(statearr_68395_68467[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (1))){
var inst_68241 = (0);
var state_68386__$1 = (function (){var statearr_68396 = state_68386;
(statearr_68396[(8)] = inst_68241);

return statearr_68396;
})();
var statearr_68397_68468 = state_68386__$1;
(statearr_68397_68468[(2)] = null);

(statearr_68397_68468[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (24))){
var inst_68333 = (state_68386[(9)]);
var state_68386__$1 = state_68386;
var statearr_68398_68469 = state_68386__$1;
(statearr_68398_68469[(2)] = inst_68333);

(statearr_68398_68469[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (39))){
var inst_68368 = (state_68386[(2)]);
var state_68386__$1 = state_68386;
var statearr_68399_68470 = state_68386__$1;
(statearr_68399_68470[(2)] = inst_68368);

(statearr_68399_68470[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (4))){
var inst_68244 = (state_68386[(10)]);
var inst_68244__$1 = (state_68386[(2)]);
var state_68386__$1 = (function (){var statearr_68400 = state_68386;
(statearr_68400[(10)] = inst_68244__$1);

return statearr_68400;
})();
if(cljs.core.truth_(inst_68244__$1)){
var statearr_68401_68471 = state_68386__$1;
(statearr_68401_68471[(1)] = (5));

} else {
var statearr_68402_68472 = state_68386__$1;
(statearr_68402_68472[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (15))){
var inst_68257 = (state_68386[(11)]);
var state_68386__$1 = state_68386;
var statearr_68403_68473 = state_68386__$1;
(statearr_68403_68473[(2)] = inst_68257);

(statearr_68403_68473[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (21))){
var inst_68291 = (state_68386[(12)]);
var inst_68287 = (state_68386[(13)]);
var inst_68241 = (state_68386[(8)]);
var inst_68288 = (state_68386[(14)]);
var inst_68290 = (state_68386[(15)]);
var inst_68294 = (state_68386[(16)]);
var inst_68244 = (state_68386[(10)]);
var inst_68289 = (state_68386[(17)]);
var inst_68295 = (state_68386[(18)]);
var inst_68286 = (state_68386[(19)]);
var inst_68297 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68298 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_68294];
var inst_68299 = (new cljs.core.PersistentVector(null,2,(5),inst_68297,inst_68298,null));
var inst_68300 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc_in,inst_68299,inst_68289);
var inst_68327 = cljs.core.async.chan.call(null,(1));
var inst_68328 = (function (){var resp_chan = inst_68289;
var timeout = inst_68295;
var i = inst_68241;
var data = inst_68288;
var map__68282 = inst_68291;
var _ = inst_68286;
var req_id = inst_68294;
var operation = inst_68287;
var msg = inst_68244;
var temp__5804__auto__ = inst_68244;
var vec__68279 = inst_68244;
var c__2768__auto____$1 = inst_68327;
var opts = inst_68290;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68325){
var state_val_68326 = (state_68325[(1)]);
if((state_val_68326 === (1))){
var inst_68304 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68305 = cljs.core.async.timeout.call(null,timeout);
var inst_68306 = [resp_chan,inst_68305];
var inst_68307 = (new cljs.core.PersistentVector(null,2,(5),inst_68304,inst_68306,null));
var state_68325__$1 = state_68325;
return cljs.core.async.ioc_alts_BANG_.call(null,state_68325__$1,(2),inst_68307);
} else {
if((state_val_68326 === (2))){
var inst_68310 = (state_68325[(7)]);
var inst_68309 = (state_68325[(2)]);
var inst_68310__$1 = cljs.core.nth.call(null,inst_68309,(0),null);
var inst_68311 = cljs.core.nth.call(null,inst_68309,(1),null);
var inst_68312 = (function (){var vec__68301 = inst_68309;
var resp = inst_68310__$1;
var c = inst_68311;
return (function (p1__68238_SHARP_){
return cljs.core.dissoc.call(null,p1__68238_SHARP_,req_id);
});
})();
var inst_68313 = cljs.core.swap_BANG_.call(null,state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_68312);
var inst_68314 = cljs.core._EQ_.call(null,inst_68311,resp_chan);
var state_68325__$1 = (function (){var statearr_68404 = state_68325;
(statearr_68404[(7)] = inst_68310__$1);

(statearr_68404[(8)] = inst_68313);

return statearr_68404;
})();
if(inst_68314){
var statearr_68405_68474 = state_68325__$1;
(statearr_68405_68474[(1)] = (3));

} else {
var statearr_68406_68475 = state_68325__$1;
(statearr_68406_68475[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68326 === (3))){
var inst_68310 = (state_68325[(7)]);
var state_68325__$1 = state_68325;
var statearr_68407_68476 = state_68325__$1;
(statearr_68407_68476[(2)] = inst_68310);

(statearr_68407_68476[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68326 === (4))){
var inst_68317 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_68318 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68319 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_68320 = cljs.core.PersistentHashMap.fromArrays(inst_68318,inst_68319);
var inst_68321 = cljs.core.ex_info.call(null,inst_68317,inst_68320);
var state_68325__$1 = state_68325;
var statearr_68408_68477 = state_68325__$1;
(statearr_68408_68477[(2)] = inst_68321);

(statearr_68408_68477[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68326 === (5))){
var inst_68323 = (state_68325[(2)]);
var state_68325__$1 = state_68325;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68325__$1,inst_68323);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2746__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2746__auto____0 = (function (){
var statearr_68409 = [null,null,null,null,null,null,null,null,null];
(statearr_68409[(0)] = fluree$db$connection$msg_producer_$_state_machine__2746__auto__);

(statearr_68409[(1)] = (1));

return statearr_68409;
});
var fluree$db$connection$msg_producer_$_state_machine__2746__auto____1 = (function (state_68325){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68325);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68410){var ex__2749__auto__ = e68410;
var statearr_68411_68478 = state_68325;
(statearr_68411_68478[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68325[(4)]))){
var statearr_68412_68479 = state_68325;
(statearr_68412_68479[(1)] = cljs.core.first.call(null,(state_68325[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68480 = state_68325;
state_68325 = G__68480;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2746__auto__ = function(state_68325){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2746__auto____1.call(this,state_68325);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2746__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2746__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68413 = f__2769__auto__.call(null);
(statearr_68413[(6)] = c__2768__auto____$1);

return statearr_68413;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_68329 = cljs.core.async.impl.dispatch.run.call(null,inst_68328);
var state_68386__$1 = (function (){var statearr_68414 = state_68386;
(statearr_68414[(20)] = inst_68329);

(statearr_68414[(21)] = inst_68300);

return statearr_68414;
})();
var statearr_68415_68481 = state_68386__$1;
(statearr_68415_68481[(2)] = inst_68327);

(statearr_68415_68481[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (31))){
var inst_68343 = (state_68386[(7)]);
var inst_68349 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68350 = [inst_68343,"Error processing message in producer."];
var inst_68351 = (new cljs.core.PersistentVector(null,2,(5),inst_68349,inst_68350,null));
var inst_68352 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_68351);
var state_68386__$1 = state_68386;
var statearr_68416_68482 = state_68386__$1;
(statearr_68416_68482[(2)] = inst_68352);

(statearr_68416_68482[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (32))){
var inst_68343 = (state_68386[(7)]);
var inst_68354 = (inst_68343 == null);
var state_68386__$1 = state_68386;
if(cljs.core.truth_(inst_68354)){
var statearr_68417_68483 = state_68386__$1;
(statearr_68417_68483[(1)] = (34));

} else {
var statearr_68418_68484 = state_68386__$1;
(statearr_68418_68484[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (33))){
var inst_68372 = (state_68386[(2)]);
var state_68386__$1 = state_68386;
var statearr_68419_68485 = state_68386__$1;
(statearr_68419_68485[(2)] = inst_68372);

(statearr_68419_68485[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (13))){
var inst_68257 = (state_68386[(11)]);
var inst_68254 = (state_68386[(2)]);
var inst_68255 = cljs.core.nth.call(null,inst_68254,(0),null);
var inst_68256 = cljs.core.nth.call(null,inst_68254,(1),null);
var inst_68257__$1 = cljs.core.nth.call(null,inst_68254,(2),null);
var state_68386__$1 = (function (){var statearr_68420 = state_68386;
(statearr_68420[(11)] = inst_68257__$1);

(statearr_68420[(22)] = inst_68255);

(statearr_68420[(23)] = inst_68256);

return statearr_68420;
})();
if(cljs.core.truth_(inst_68257__$1)){
var statearr_68421_68486 = state_68386__$1;
(statearr_68421_68486[(1)] = (14));

} else {
var statearr_68422_68487 = state_68386__$1;
(statearr_68422_68487[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (22))){
var state_68386__$1 = state_68386;
var statearr_68423_68488 = state_68386__$1;
(statearr_68423_68488[(2)] = null);

(statearr_68423_68488[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (36))){
var inst_68370 = (state_68386[(2)]);
var state_68386__$1 = state_68386;
var statearr_68424_68489 = state_68386__$1;
(statearr_68424_68489[(2)] = inst_68370);

(statearr_68424_68489[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (29))){
var inst_68343 = (state_68386[(7)]);
var inst_68347 = fluree.db.util.core.exception_QMARK_.call(null,inst_68343);
var state_68386__$1 = state_68386;
if(inst_68347){
var statearr_68425_68490 = state_68386__$1;
(statearr_68425_68490[(1)] = (31));

} else {
var statearr_68426_68491 = state_68386__$1;
(statearr_68426_68491[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (6))){
var state_68386__$1 = state_68386;
var statearr_68427_68492 = state_68386__$1;
(statearr_68427_68492[(2)] = null);

(statearr_68427_68492[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (28))){
var state_68386__$1 = state_68386;
var statearr_68428_68493 = state_68386__$1;
(statearr_68428_68493[(2)] = null);

(statearr_68428_68493[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (25))){
var state_68386__$1 = state_68386;
var statearr_68429_68494 = state_68386__$1;
(statearr_68429_68494[(2)] = fluree.db.connection.default_publish_fn);

(statearr_68429_68494[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (34))){
var inst_68356 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68357 = ["Error processing message in producer. Socket closed."];
var inst_68358 = (new cljs.core.PersistentVector(null,1,(5),inst_68356,inst_68357,null));
var inst_68359 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_68358);
var state_68386__$1 = state_68386;
var statearr_68430_68495 = state_68386__$1;
(statearr_68430_68495[(2)] = inst_68359);

(statearr_68430_68495[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (17))){
var inst_68257 = (state_68386[(11)]);
var inst_68246 = (state_68386[(24)]);
var inst_68264 = cljs.core.async.put_BANG_.call(null,inst_68257,inst_68246);
var state_68386__$1 = state_68386;
var statearr_68431_68496 = state_68386__$1;
(statearr_68431_68496[(2)] = inst_68264);

(statearr_68431_68496[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (3))){
var inst_68384 = (state_68386[(2)]);
var state_68386__$1 = state_68386;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68386__$1,inst_68384);
} else {
if((state_val_68387 === (12))){
var state_68386__$1 = state_68386;
var statearr_68432_68497 = state_68386__$1;
(statearr_68432_68497[(2)] = null);

(statearr_68432_68497[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (2))){
var state_68386__$1 = state_68386;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68386__$1,(4),req_chan);
} else {
if((state_val_68387 === (23))){
var inst_68333 = (state_68386[(9)]);
var inst_68332 = (state_68386[(2)]);
var inst_68333__$1 = publish;
var state_68386__$1 = (function (){var statearr_68433 = state_68386;
(statearr_68433[(9)] = inst_68333__$1);

(statearr_68433[(25)] = inst_68332);

return statearr_68433;
})();
if(cljs.core.truth_(inst_68333__$1)){
var statearr_68434_68498 = state_68386__$1;
(statearr_68434_68498[(1)] = (24));

} else {
var statearr_68435_68499 = state_68386__$1;
(statearr_68435_68499[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (35))){
var state_68386__$1 = state_68386;
var statearr_68436_68500 = state_68386__$1;
(statearr_68436_68500[(1)] = (37));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (19))){
var inst_68273 = (state_68386[(2)]);
var state_68386__$1 = state_68386;
var statearr_68438_68501 = state_68386__$1;
(statearr_68438_68501[(2)] = inst_68273);

(statearr_68438_68501[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (11))){
var inst_68244 = (state_68386[(10)]);
var state_68386__$1 = state_68386;
var statearr_68439_68502 = state_68386__$1;
(statearr_68439_68502[(2)] = inst_68244);

(statearr_68439_68502[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (9))){
var inst_68241 = (state_68386[(8)]);
var inst_68377 = (state_68386[(2)]);
var inst_68378 = (inst_68241 + (1));
var inst_68241__$1 = inst_68378;
var state_68386__$1 = (function (){var statearr_68440 = state_68386;
(statearr_68440[(8)] = inst_68241__$1);

(statearr_68440[(26)] = inst_68377);

return statearr_68440;
})();
var statearr_68441_68503 = state_68386__$1;
(statearr_68441_68503[(2)] = null);

(statearr_68441_68503[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (5))){
var state_68386__$1 = state_68386;
var statearr_68442_68504 = state_68386__$1;
(statearr_68442_68504[(2)] = null);

(statearr_68442_68504[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (14))){
var inst_68257 = (state_68386[(11)]);
var inst_68259 = fluree.db.util.async.channel_QMARK_.call(null,inst_68257);
var state_68386__$1 = state_68386;
var statearr_68443_68505 = state_68386__$1;
(statearr_68443_68505[(2)] = inst_68259);

(statearr_68443_68505[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (26))){
var inst_68287 = (state_68386[(13)]);
var inst_68288 = (state_68386[(14)]);
var inst_68294 = (state_68386[(16)]);
var inst_68337 = (state_68386[(2)]);
var inst_68338 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68339 = [inst_68287,inst_68294,inst_68288];
var inst_68340 = (new cljs.core.PersistentVector(null,3,(5),inst_68338,inst_68339,null));
var inst_68341 = inst_68337.call(null,conn,inst_68340);
var state_68386__$1 = state_68386;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68386__$1,(27),inst_68341);
} else {
if((state_val_68387 === (16))){
var inst_68262 = (state_68386[(2)]);
var state_68386__$1 = state_68386;
if(cljs.core.truth_(inst_68262)){
var statearr_68444_68506 = state_68386__$1;
(statearr_68444_68506[(1)] = (17));

} else {
var statearr_68445_68507 = state_68386__$1;
(statearr_68445_68507[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (38))){
var state_68386__$1 = state_68386;
var statearr_68446_68508 = state_68386__$1;
(statearr_68446_68508[(2)] = null);

(statearr_68446_68508[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (30))){
var inst_68374 = (state_68386[(2)]);
var _ = (function (){var statearr_68447 = state_68386;
(statearr_68447[(4)] = cljs.core.rest.call(null,(state_68386[(4)])));

return statearr_68447;
})();
var state_68386__$1 = state_68386;
var statearr_68448_68509 = state_68386__$1;
(statearr_68448_68509[(2)] = inst_68374);

(statearr_68448_68509[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (10))){
var inst_68244 = (state_68386[(10)]);
var inst_68246 = (state_68386[(2)]);
var inst_68250 = cljs.core.sequential_QMARK_.call(null,inst_68244);
var state_68386__$1 = (function (){var statearr_68449 = state_68386;
(statearr_68449[(24)] = inst_68246);

return statearr_68449;
})();
if(inst_68250){
var statearr_68450_68510 = state_68386__$1;
(statearr_68450_68510[(1)] = (11));

} else {
var statearr_68451_68511 = state_68386__$1;
(statearr_68451_68511[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (18))){
var inst_68246 = (state_68386[(24)]);
var inst_68244 = (state_68386[(10)]);
var inst_68266 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68267 = cljs.core.pr_str.call(null,inst_68244);
var inst_68268 = ["Error processing ledger request, no valid return channel: ",inst_68267].join('');
var inst_68269 = [inst_68246,inst_68268];
var inst_68270 = (new cljs.core.PersistentVector(null,2,(5),inst_68266,inst_68269,null));
var inst_68271 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_68270);
var state_68386__$1 = state_68386;
var statearr_68452_68512 = state_68386__$1;
(statearr_68452_68512[(2)] = inst_68271);

(statearr_68452_68512[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (37))){
var inst_68343 = (state_68386[(7)]);
var inst_68362 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68363 = ["Error processing message in producer. Socket closed. Published result",inst_68343];
var inst_68364 = (new cljs.core.PersistentVector(null,2,(5),inst_68362,inst_68363,null));
var inst_68365 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_68364);
var state_68386__$1 = state_68386;
var statearr_68453_68513 = state_68386__$1;
(statearr_68453_68513[(2)] = inst_68365);

(statearr_68453_68513[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68387 === (8))){
var inst_68291 = (state_68386[(12)]);
var inst_68290 = (state_68386[(15)]);
var inst_68244 = (state_68386[(10)]);
var inst_68289 = (state_68386[(17)]);
var _ = (function (){var statearr_68454 = state_68386;
(statearr_68454[(4)] = cljs.core.cons.call(null,(20),(state_68386[(4)])));

return statearr_68454;
})();
var inst_68283 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68284 = ["Outgoing message to websocket: ",inst_68244];
var inst_68285 = (new cljs.core.PersistentVector(null,2,(5),inst_68283,inst_68284,null));
var inst_68286 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_68285);
var inst_68287 = cljs.core.nth.call(null,inst_68244,(0),null);
var inst_68288 = cljs.core.nth.call(null,inst_68244,(1),null);
var inst_68289__$1 = cljs.core.nth.call(null,inst_68244,(2),null);
var inst_68290__$1 = cljs.core.nth.call(null,inst_68244,(3),null);
var inst_68291__$1 = cljs.core.__destructure_map.call(null,inst_68290__$1);
var inst_68292 = cljs.core.random_uuid.call(null);
var inst_68293 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68292);
var inst_68294 = cljs.core.get.call(null,inst_68291__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_68293);
var inst_68295 = cljs.core.get.call(null,inst_68291__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_68386__$1 = (function (){var statearr_68455 = state_68386;
(statearr_68455[(12)] = inst_68291__$1);

(statearr_68455[(13)] = inst_68287);

(statearr_68455[(14)] = inst_68288);

(statearr_68455[(15)] = inst_68290__$1);

(statearr_68455[(16)] = inst_68294);

(statearr_68455[(17)] = inst_68289__$1);

(statearr_68455[(18)] = inst_68295);

(statearr_68455[(19)] = inst_68286);

return statearr_68455;
})();
if(cljs.core.truth_(inst_68289__$1)){
var statearr_68456_68514 = state_68386__$1;
(statearr_68456_68514[(1)] = (21));

} else {
var statearr_68457_68515 = state_68386__$1;
(statearr_68457_68515[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2746__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2746__auto____0 = (function (){
var statearr_68458 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68458[(0)] = fluree$db$connection$msg_producer_$_state_machine__2746__auto__);

(statearr_68458[(1)] = (1));

return statearr_68458;
});
var fluree$db$connection$msg_producer_$_state_machine__2746__auto____1 = (function (state_68386){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68386);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68459){var ex__2749__auto__ = e68459;
var statearr_68460_68516 = state_68386;
(statearr_68460_68516[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68386[(4)]))){
var statearr_68461_68517 = state_68386;
(statearr_68461_68517[(1)] = cljs.core.first.call(null,(state_68386[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68518 = state_68386;
state_68386 = G__68518;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2746__auto__ = function(state_68386){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2746__auto____1.call(this,state_68386);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2746__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2746__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68462 = f__2769__auto__.call(null);
(statearr_68462[(6)] = c__2768__auto__);

return statearr_68462;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(req_chan){
return cljs.core.async.put_BANG_.call(null,req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Returns a channel that will eventually have a websocket. Will exponentially backoff
 *   until connection attempts happen every two minutes. Uses the existing conn and will
 *   reuse the existing sub-chan and pub-chan so the msg-consumer/producer loops do not
 *   need to be restarted.
 */
fluree.db.connection.reconnect_conn = (function fluree$db$connection$reconnect_conn(conn){
fluree.db.connection.close_websocket.call(null,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn));

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68556){
var state_val_68557 = (state_68556[(1)]);
if((state_val_68557 === (7))){
var inst_68527 = (state_68556[(7)]);
var state_68556__$1 = state_68556;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68556__$1,(9),inst_68527);
} else {
if((state_val_68557 === (1))){
var inst_68519 = (1);
var state_68556__$1 = (function (){var statearr_68558 = state_68556;
(statearr_68558[(8)] = inst_68519);

return statearr_68558;
})();
var statearr_68559_68582 = state_68556__$1;
(statearr_68559_68582[(2)] = null);

(statearr_68559_68582[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68557 === (4))){
var inst_68524 = (state_68556[(2)]);
var inst_68525 = fluree.db.connection.get_socket.call(null,conn);
var state_68556__$1 = (function (){var statearr_68560 = state_68556;
(statearr_68560[(9)] = inst_68524);

return statearr_68560;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68556__$1,(5),inst_68525);
} else {
if((state_val_68557 === (15))){
var inst_68552 = (state_68556[(2)]);
var state_68556__$1 = state_68556;
var statearr_68561_68583 = state_68556__$1;
(statearr_68561_68583[(2)] = inst_68552);

(statearr_68561_68583[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68557 === (13))){
var inst_68519 = (state_68556[(8)]);
var inst_68534 = (state_68556[(10)]);
var inst_68542 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68543 = [inst_68534,"Cannot establish connection to a healthy server, backing off:",inst_68519,"s."];
var inst_68544 = (new cljs.core.PersistentVector(null,4,(5),inst_68542,inst_68543,null));
var inst_68545 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_68544);
var inst_68546 = ((2) * inst_68519);
var inst_68547 = ((60) * (2));
var inst_68548 = ((inst_68546 < inst_68547) ? inst_68546 : inst_68547);
var inst_68519__$1 = inst_68548;
var state_68556__$1 = (function (){var statearr_68562 = state_68556;
(statearr_68562[(11)] = inst_68545);

(statearr_68562[(8)] = inst_68519__$1);

return statearr_68562;
})();
var statearr_68563_68584 = state_68556__$1;
(statearr_68563_68584[(2)] = null);

(statearr_68563_68584[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68557 === (6))){
var inst_68527 = (state_68556[(7)]);
var state_68556__$1 = state_68556;
var statearr_68564_68585 = state_68556__$1;
(statearr_68564_68585[(2)] = inst_68527);

(statearr_68564_68585[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68557 === (3))){
var inst_68554 = (state_68556[(2)]);
var state_68556__$1 = state_68556;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68556__$1,inst_68554);
} else {
if((state_val_68557 === (12))){
var inst_68540 = (state_68556[(2)]);
var state_68556__$1 = state_68556;
if(cljs.core.truth_(inst_68540)){
var statearr_68565_68586 = state_68556__$1;
(statearr_68565_68586[(1)] = (13));

} else {
var statearr_68566_68587 = state_68556__$1;
(statearr_68566_68587[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68557 === (2))){
var inst_68519 = (state_68556[(8)]);
var inst_68521 = (inst_68519 * (1000));
var inst_68522 = cljs.core.async.timeout.call(null,inst_68521);
var state_68556__$1 = state_68556;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68556__$1,(4),inst_68522);
} else {
if((state_val_68557 === (11))){
var inst_68534 = (state_68556[(10)]);
var inst_68538 = fluree.db.util.core.exception_QMARK_.call(null,inst_68534);
var state_68556__$1 = state_68556;
var statearr_68567_68588 = state_68556__$1;
(statearr_68567_68588[(2)] = inst_68538);

(statearr_68567_68588[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68557 === (9))){
var inst_68532 = (state_68556[(2)]);
var state_68556__$1 = state_68556;
var statearr_68568_68589 = state_68556__$1;
(statearr_68568_68589[(2)] = inst_68532);

(statearr_68568_68589[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68557 === (5))){
var inst_68527 = (state_68556[(7)]);
var inst_68527__$1 = (state_68556[(2)]);
var inst_68528 = fluree.db.util.core.exception_QMARK_.call(null,inst_68527__$1);
var state_68556__$1 = (function (){var statearr_68569 = state_68556;
(statearr_68569[(7)] = inst_68527__$1);

return statearr_68569;
})();
if(inst_68528){
var statearr_68570_68590 = state_68556__$1;
(statearr_68570_68590[(1)] = (6));

} else {
var statearr_68571_68591 = state_68556__$1;
(statearr_68571_68591[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68557 === (14))){
var inst_68534 = (state_68556[(10)]);
var state_68556__$1 = state_68556;
var statearr_68572_68592 = state_68556__$1;
(statearr_68572_68592[(2)] = inst_68534);

(statearr_68572_68592[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68557 === (10))){
var inst_68535 = (state_68556[(12)]);
var state_68556__$1 = state_68556;
var statearr_68573_68593 = state_68556__$1;
(statearr_68573_68593[(2)] = inst_68535);

(statearr_68573_68593[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68557 === (8))){
var inst_68535 = (state_68556[(12)]);
var inst_68534 = (state_68556[(10)]);
var inst_68534__$1 = (state_68556[(2)]);
var inst_68535__$1 = (inst_68534__$1 == null);
var state_68556__$1 = (function (){var statearr_68574 = state_68556;
(statearr_68574[(12)] = inst_68535__$1);

(statearr_68574[(10)] = inst_68534__$1);

return statearr_68574;
})();
if(cljs.core.truth_(inst_68535__$1)){
var statearr_68575_68594 = state_68556__$1;
(statearr_68575_68594[(1)] = (10));

} else {
var statearr_68576_68595 = state_68556__$1;
(statearr_68576_68595[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$reconnect_conn_$_state_machine__2746__auto__ = null;
var fluree$db$connection$reconnect_conn_$_state_machine__2746__auto____0 = (function (){
var statearr_68577 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68577[(0)] = fluree$db$connection$reconnect_conn_$_state_machine__2746__auto__);

(statearr_68577[(1)] = (1));

return statearr_68577;
});
var fluree$db$connection$reconnect_conn_$_state_machine__2746__auto____1 = (function (state_68556){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68556);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68578){var ex__2749__auto__ = e68578;
var statearr_68579_68596 = state_68556;
(statearr_68579_68596[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68556[(4)]))){
var statearr_68580_68597 = state_68556;
(statearr_68580_68597[(1)] = cljs.core.first.call(null,(state_68556[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68598 = state_68556;
state_68556 = G__68598;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$reconnect_conn_$_state_machine__2746__auto__ = function(state_68556){
switch(arguments.length){
case 0:
return fluree$db$connection$reconnect_conn_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$reconnect_conn_$_state_machine__2746__auto____1.call(this,state_68556);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$reconnect_conn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$reconnect_conn_$_state_machine__2746__auto____0;
fluree$db$connection$reconnect_conn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$reconnect_conn_$_state_machine__2746__auto____1;
return fluree$db$connection$reconnect_conn_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68581 = f__2769__auto__.call(null);
(statearr_68581[(6)] = c__2768__auto__);

return statearr_68581;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(p__68599){
var map__68600 = p__68599;
var map__68600__$1 = cljs.core.__destructure_map.call(null,map__68600);
var conn = map__68600__$1;
var sub_chan = cljs.core.get.call(null,map__68600__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var req_chan = cljs.core.get.call(null,map__68600__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046));
var keep_alive_fn = cljs.core.get.call(null,map__68600__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var keep_alive = cljs.core.get.call(null,map__68600__$1,new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827));
var ping_transactor_after = (2500);
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68711){
var state_val_68712 = (state_68711[(1)]);
if((state_val_68712 === (7))){
var inst_68707 = (state_68711[(2)]);
var state_68711__$1 = state_68711;
var statearr_68713_68769 = state_68711__$1;
(statearr_68713_68769[(2)] = inst_68707);

(statearr_68713_68769[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68712 === (20))){
var inst_68658 = (state_68711[(2)]);
var state_68711__$1 = state_68711;
var statearr_68714_68770 = state_68711__$1;
(statearr_68714_68770[(2)] = inst_68658);

(statearr_68714_68770[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68712 === (27))){
var inst_68676 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68677 = ["Connection closed."];
var inst_68678 = (new cljs.core.PersistentVector(null,1,(5),inst_68676,inst_68677,null));
var inst_68679 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),inst_68678);
var state_68711__$1 = state_68711;
var statearr_68715_68771 = state_68711__$1;
(statearr_68715_68771[(2)] = inst_68679);

(statearr_68715_68771[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68712 === (1))){
var inst_68601 = (0);
var state_68711__$1 = (function (){var statearr_68716 = state_68711;
(statearr_68716[(7)] = inst_68601);

return statearr_68716;
})();
var statearr_68717_68772 = state_68711__$1;
(statearr_68717_68772[(2)] = null);

(statearr_68717_68772[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68712 === (24))){
var inst_68645 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68646 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_68647 = [keep_alive_fn];
var inst_68648 = cljs.core.PersistentHashMap.fromArrays(inst_68646,inst_68647);
var inst_68649 = ["Unsupported callback registered",inst_68648];
var inst_68650 = (new cljs.core.PersistentVector(null,2,(5),inst_68645,inst_68649,null));
var inst_68651 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_68650);
var state_68711__$1 = state_68711;
var statearr_68718_68773 = state_68711__$1;
(statearr_68718_68773[(2)] = inst_68651);

(statearr_68718_68773[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68712 === (4))){
var inst_68606 = (state_68711[(8)]);
var inst_68611 = (state_68711[(2)]);
var inst_68612 = cljs.core.nth.call(null,inst_68611,(0),null);
var inst_68613 = cljs.core.nth.call(null,inst_68611,(1),null);
var inst_68614 = cljs.core._EQ_.call(null,inst_68613,inst_68606);
var state_68711__$1 = (function (){var statearr_68719 = state_68711;
(statearr_68719[(9)] = inst_68612);

return statearr_68719;
})();
if(inst_68614){
var statearr_68720_68774 = state_68711__$1;
(statearr_68720_68774[(1)] = (5));

} else {
var statearr_68721_68775 = state_68711__$1;
(statearr_68721_68775[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68712 === (15))){
var inst_68631 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68632 = ["No keep-alive callback is registered"];
var inst_68633 = (new cljs.core.PersistentVector(null,1,(5),inst_68631,inst_68632,null));
var inst_68634 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_68633);
var state_68711__$1 = state_68711;
var statearr_68722_68776 = state_68711__$1;
(statearr_68722_68776[(2)] = inst_68634);

(statearr_68722_68776[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68712 === (21))){
var inst_68642 = cljs.core.eval.call(null,keep_alive_fn);
var state_68711__$1 = state_68711;
var statearr_68723_68777 = state_68711__$1;
(statearr_68723_68777[(2)] = inst_68642);

(statearr_68723_68777[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68712 === (31))){
var state_68711__$1 = state_68711;
var statearr_68724_68778 = state_68711__$1;
(statearr_68724_68778[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68712 === (32))){
var inst_68703 = (state_68711[(2)]);
var state_68711__$1 = state_68711;
var statearr_68726_68779 = state_68711__$1;
(statearr_68726_68779[(2)] = inst_68703);

(statearr_68726_68779[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68712 === (33))){
var inst_68612 = (state_68711[(9)]);
var inst_68690 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68691 = fluree.db.util.json.parse.call(null,inst_68612);
var inst_68692 = cljs.core.pr_str.call(null,inst_68691);
var inst_68693 = ["Received message:",inst_68692];
var inst_68694 = (new cljs.core.PersistentVector(null,2,(5),inst_68690,inst_68693,null));
var inst_68695 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_68694);
var inst_68696 = fluree.db.util.json.parse.call(null,inst_68612);
var inst_68697 = fluree.db.conn_events.process_events.call(null,conn,inst_68696);
var inst_68601 = (0);
var state_68711__$1 = (function (){var statearr_68727 = state_68711;
(statearr_68727[(10)] = inst_68695);

(statearr_68727[(7)] = inst_68601);

(statearr_68727[(11)] = inst_68697);

return statearr_68727;
})();
var statearr_68728_68780 = state_68711__$1;
(statearr_68728_68780[(2)] = null);

(statearr_68728_68780[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68712 === (13))){
var inst_68666 = (state_68711[(2)]);
var state_68711__$1 = state_68711;
var statearr_68729_68781 = state_68711__$1;
(statearr_68729_68781[(2)] = inst_68666);

(statearr_68729_68781[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68712 === (22))){
var state_68711__$1 = state_68711;
var statearr_68730_68782 = state_68711__$1;
(statearr_68730_68782[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68712 === (29))){
var inst_68705 = (state_68711[(2)]);
var state_68711__$1 = state_68711;
var statearr_68732_68783 = state_68711__$1;
(statearr_68732_68783[(2)] = inst_68705);

(statearr_68732_68783[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68712 === (6))){
var inst_68612 = (state_68711[(9)]);
var inst_68674 = (inst_68612 == null);
var state_68711__$1 = state_68711;
if(cljs.core.truth_(inst_68674)){
var statearr_68733_68784 = state_68711__$1;
(statearr_68733_68784[(1)] = (27));

} else {
var statearr_68734_68785 = state_68711__$1;
(statearr_68734_68785[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68712 === (28))){
var inst_68612 = (state_68711[(9)]);
var inst_68681 = fluree.db.util.core.exception_QMARK_.call(null,inst_68612);
var state_68711__$1 = state_68711;
if(inst_68681){
var statearr_68735_68786 = state_68711__$1;
(statearr_68735_68786[(1)] = (30));

} else {
var statearr_68736_68787 = state_68711__$1;
(statearr_68736_68787[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68712 === (25))){
var state_68711__$1 = state_68711;
var statearr_68737_68788 = state_68711__$1;
(statearr_68737_68788[(2)] = null);

(statearr_68737_68788[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68712 === (34))){
var state_68711__$1 = state_68711;
var statearr_68738_68789 = state_68711__$1;
(statearr_68738_68789[(2)] = null);

(statearr_68738_68789[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68712 === (17))){
var inst_68660 = (state_68711[(2)]);
var inst_68661 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68662 = fluree.db.connection.close_websocket.call(null,inst_68661);
var inst_68663 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68664 = fluree.db.session.close_all_sessions.call(null,inst_68663);
var state_68711__$1 = (function (){var statearr_68739 = state_68711;
(statearr_68739[(12)] = inst_68662);

(statearr_68739[(13)] = inst_68660);

return statearr_68739;
})();
var statearr_68740_68790 = state_68711__$1;
(statearr_68740_68790[(2)] = inst_68664);

(statearr_68740_68790[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68712 === (3))){
var inst_68709 = (state_68711[(2)]);
var state_68711__$1 = state_68711;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68711__$1,inst_68709);
} else {
if((state_val_68712 === (12))){
var inst_68624 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68625 = ["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."];
var inst_68626 = (new cljs.core.PersistentVector(null,1,(5),inst_68624,inst_68625,null));
var inst_68627 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_68626);
var inst_68628 = keep_alive_fn;
var inst_68629 = (keep_alive_fn == null);
var state_68711__$1 = (function (){var statearr_68741 = state_68711;
(statearr_68741[(14)] = inst_68627);

(statearr_68741[(15)] = inst_68628);

return statearr_68741;
})();
if(cljs.core.truth_(inst_68629)){
var statearr_68742_68791 = state_68711__$1;
(statearr_68742_68791[(1)] = (15));

} else {
var statearr_68743_68792 = state_68711__$1;
(statearr_68743_68792[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68712 === (2))){
var inst_68606 = (state_68711[(8)]);
var inst_68606__$1 = cljs.core.async.timeout.call(null,ping_transactor_after);
var inst_68607 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68608 = [sub_chan,inst_68606__$1];
var inst_68609 = (new cljs.core.PersistentVector(null,2,(5),inst_68607,inst_68608,null));
var state_68711__$1 = (function (){var statearr_68744 = state_68711;
(statearr_68744[(8)] = inst_68606__$1);

return statearr_68744;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_68711__$1,(4),inst_68609);
} else {
if((state_val_68712 === (23))){
var inst_68656 = (state_68711[(2)]);
var state_68711__$1 = state_68711;
var statearr_68745_68793 = state_68711__$1;
(statearr_68745_68793[(2)] = inst_68656);

(statearr_68745_68793[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68712 === (35))){
var inst_68701 = (state_68711[(2)]);
var state_68711__$1 = state_68711;
var statearr_68746_68794 = state_68711__$1;
(statearr_68746_68794[(2)] = inst_68701);

(statearr_68746_68794[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68712 === (19))){
var inst_68640 = typeof keep_alive_fn === 'string';
var state_68711__$1 = state_68711;
if(cljs.core.truth_(inst_68640)){
var statearr_68747_68795 = state_68711__$1;
(statearr_68747_68795[(1)] = (21));

} else {
var statearr_68748_68796 = state_68711__$1;
(statearr_68748_68796[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68712 === (11))){
var inst_68619 = fluree.db.connection.reconnect_conn.call(null,conn);
var state_68711__$1 = state_68711;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68711__$1,(14),inst_68619);
} else {
if((state_val_68712 === (9))){
var inst_68601 = (state_68711[(7)]);
var inst_68668 = fluree.db.connection.ping_transactor.call(null,req_chan);
var inst_68669 = (inst_68601 + (1));
var inst_68601__$1 = inst_68669;
var state_68711__$1 = (function (){var statearr_68749 = state_68711;
(statearr_68749[(16)] = inst_68668);

(statearr_68749[(7)] = inst_68601__$1);

return statearr_68749;
})();
var statearr_68750_68797 = state_68711__$1;
(statearr_68750_68797[(2)] = null);

(statearr_68750_68797[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68712 === (5))){
var inst_68601 = (state_68711[(7)]);
var inst_68616 = cljs.core._EQ_.call(null,(2),inst_68601);
var state_68711__$1 = state_68711;
if(inst_68616){
var statearr_68751_68798 = state_68711__$1;
(statearr_68751_68798[(1)] = (8));

} else {
var statearr_68752_68799 = state_68711__$1;
(statearr_68752_68799[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68712 === (14))){
var inst_68621 = (state_68711[(2)]);
var inst_68601 = (0);
var state_68711__$1 = (function (){var statearr_68753 = state_68711;
(statearr_68753[(7)] = inst_68601);

(statearr_68753[(17)] = inst_68621);

return statearr_68753;
})();
var statearr_68754_68800 = state_68711__$1;
(statearr_68754_68800[(2)] = null);

(statearr_68754_68800[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68712 === (26))){
var inst_68654 = (state_68711[(2)]);
var state_68711__$1 = state_68711;
var statearr_68755_68801 = state_68711__$1;
(statearr_68755_68801[(2)] = inst_68654);

(statearr_68755_68801[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68712 === (16))){
var inst_68636 = cljs.core.fn_QMARK_.call(null,keep_alive_fn);
var state_68711__$1 = state_68711;
if(inst_68636){
var statearr_68756_68802 = state_68711__$1;
(statearr_68756_68802[(1)] = (18));

} else {
var statearr_68757_68803 = state_68711__$1;
(statearr_68757_68803[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68712 === (30))){
var inst_68612 = (state_68711[(9)]);
var inst_68683 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68684 = [inst_68612];
var inst_68685 = (new cljs.core.PersistentVector(null,1,(5),inst_68683,inst_68684,null));
var inst_68686 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_68685);
var inst_68601 = (0);
var state_68711__$1 = (function (){var statearr_68758 = state_68711;
(statearr_68758[(7)] = inst_68601);

(statearr_68758[(18)] = inst_68686);

return statearr_68758;
})();
var statearr_68759_68804 = state_68711__$1;
(statearr_68759_68804[(2)] = null);

(statearr_68759_68804[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68712 === (10))){
var inst_68672 = (state_68711[(2)]);
var state_68711__$1 = state_68711;
var statearr_68760_68805 = state_68711__$1;
(statearr_68760_68805[(2)] = inst_68672);

(statearr_68760_68805[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68712 === (18))){
var inst_68638 = keep_alive_fn.call(null);
var state_68711__$1 = state_68711;
var statearr_68761_68806 = state_68711__$1;
(statearr_68761_68806[(2)] = inst_68638);

(statearr_68761_68806[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68712 === (8))){
var state_68711__$1 = state_68711;
if(cljs.core.truth_(keep_alive)){
var statearr_68762_68807 = state_68711__$1;
(statearr_68762_68807[(1)] = (11));

} else {
var statearr_68763_68808 = state_68711__$1;
(statearr_68763_68808[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2746__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2746__auto____0 = (function (){
var statearr_68764 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68764[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2746__auto__);

(statearr_68764[(1)] = (1));

return statearr_68764;
});
var fluree$db$connection$msg_consumer_$_state_machine__2746__auto____1 = (function (state_68711){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68711);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68765){var ex__2749__auto__ = e68765;
var statearr_68766_68809 = state_68711;
(statearr_68766_68809[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68711[(4)]))){
var statearr_68767_68810 = state_68711;
(statearr_68767_68810[(1)] = cljs.core.first.call(null,(state_68711[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68811 = state_68711;
state_68711 = G__68811;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2746__auto__ = function(state_68711){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2746__auto____1.call(this,state_68711);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2746__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2746__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68768 = f__2769__auto__.call(null);
(statearr_68768[(6)] = c__2768__auto__);

return statearr_68768;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__68813 = arguments.length;
switch (G__68813) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.call(null,conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__68814 = opts;
var map__68814__$1 = cljs.core.__destructure_map.call(null,map__68814);
var private$ = cljs.core.get.call(null,map__68814__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.call(null,map__68814__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68866){
var state_val_68867 = (state_68866[(1)]);
if((state_val_68867 === (7))){
var inst_68824 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_68825 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68826 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_68827 = (new cljs.core.PersistentVector(null,2,(5),inst_68825,inst_68826,null));
var inst_68828 = cljs.core.get_in.call(null,inst_68824,inst_68827);
var state_68866__$1 = state_68866;
var statearr_68868_68899 = state_68866__$1;
(statearr_68868_68899[(2)] = inst_68828);

(statearr_68868_68899[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68867 === (1))){
var state_68866__$1 = state_68866;
var statearr_68869_68900 = state_68866__$1;
(statearr_68869_68900[(2)] = null);

(statearr_68869_68900[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68867 === (4))){
var inst_68815 = (state_68866[(2)]);
var state_68866__$1 = state_68866;
var statearr_68870_68901 = state_68866__$1;
(statearr_68870_68901[(2)] = inst_68815);

(statearr_68870_68901[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68867 === (15))){
var inst_68835 = (state_68866[(7)]);
var inst_68854 = (state_68866[(2)]);
var inst_68855 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_68856 = [(5000),inst_68854,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_68857 = cljs.core.PersistentHashMap.fromArrays(inst_68855,inst_68856);
var inst_68858 = fluree.db.util.xhttp.get.call(null,inst_68835,inst_68857);
var state_68866__$1 = state_68866;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68866__$1,(16),inst_68858);
} else {
if((state_val_68867 === (13))){
var inst_68835 = (state_68866[(7)]);
var inst_68845 = (state_68866[(8)]);
var inst_68847 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_68848 = [inst_68845];
var inst_68849 = cljs.core.PersistentHashMap.fromArrays(inst_68847,inst_68848);
var inst_68850 = fluree.db.query.http_signatures.sign_request.call(null,"get",inst_68835,inst_68849,private$);
var inst_68851 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_68850);
var state_68866__$1 = state_68866;
var statearr_68871_68902 = state_68866__$1;
(statearr_68871_68902[(2)] = inst_68851);

(statearr_68871_68902[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68867 === (6))){
var inst_68821 = (state_68866[(9)]);
var state_68866__$1 = state_68866;
var statearr_68872_68903 = state_68866__$1;
(statearr_68872_68903[(2)] = inst_68821);

(statearr_68872_68903[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68867 === (3))){
var inst_68864 = (state_68866[(2)]);
var state_68866__$1 = state_68866;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68866__$1,inst_68864);
} else {
if((state_val_68867 === (12))){
var inst_68845 = (state_68866[(2)]);
var state_68866__$1 = (function (){var statearr_68873 = state_68866;
(statearr_68873[(8)] = inst_68845);

return statearr_68873;
})();
if(cljs.core.truth_(private$)){
var statearr_68874_68904 = state_68866__$1;
(statearr_68874_68904[(1)] = (13));

} else {
var statearr_68875_68905 = state_68866__$1;
(statearr_68875_68905[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68867 === (2))){
var inst_68821 = (state_68866[(9)]);
var _ = (function (){var statearr_68876 = state_68866;
(statearr_68876[(4)] = cljs.core.cons.call(null,(5),(state_68866[(4)])));

return statearr_68876;
})();
var inst_68821__$1 = jwt;
var state_68866__$1 = (function (){var statearr_68877 = state_68866;
(statearr_68877[(9)] = inst_68821__$1);

return statearr_68877;
})();
if(cljs.core.truth_(inst_68821__$1)){
var statearr_68878_68906 = state_68866__$1;
(statearr_68878_68906[(1)] = (6));

} else {
var statearr_68879_68907 = state_68866__$1;
(statearr_68879_68907[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68867 === (11))){
var inst_68839 = (state_68866[(10)]);
var state_68866__$1 = state_68866;
var statearr_68881_68908 = state_68866__$1;
(statearr_68881_68908[(2)] = inst_68839);

(statearr_68881_68908[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68867 === (9))){
var inst_68830 = (state_68866[(11)]);
var inst_68831 = (state_68866[(12)]);
var inst_68834 = (state_68866[(2)]);
var inst_68835 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68834),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68831)].join('');
var inst_68837 = ["Accept"];
var inst_68838 = ["application/json"];
var inst_68839 = cljs.core.PersistentHashMap.fromArrays(inst_68837,inst_68838);
var state_68866__$1 = (function (){var statearr_68882 = state_68866;
(statearr_68882[(7)] = inst_68835);

(statearr_68882[(10)] = inst_68839);

return statearr_68882;
})();
if(cljs.core.truth_(inst_68830)){
var statearr_68883_68909 = state_68866__$1;
(statearr_68883_68909[(1)] = (10));

} else {
var statearr_68884_68910 = state_68866__$1;
(statearr_68884_68910[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68867 === (5))){
var _ = (function (){var statearr_68885 = state_68866;
(statearr_68885[(4)] = cljs.core.rest.call(null,(state_68866[(4)])));

return statearr_68885;
})();
var state_68866__$1 = state_68866;
var ex68880 = (state_68866__$1[(2)]);
var statearr_68886_68911 = state_68866__$1;
(statearr_68886_68911[(5)] = ex68880);


if((ex68880 instanceof Error)){
var statearr_68887_68912 = state_68866__$1;
(statearr_68887_68912[(1)] = (4));

(statearr_68887_68912[(5)] = null);

} else {
throw ex68880;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68867 === (14))){
var inst_68845 = (state_68866[(8)]);
var state_68866__$1 = state_68866;
var statearr_68888_68913 = state_68866__$1;
(statearr_68888_68913[(2)] = inst_68845);

(statearr_68888_68913[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68867 === (16))){
var inst_68860 = (state_68866[(2)]);
var inst_68861 = fluree.db.util.async.throw_err.call(null,inst_68860);
var _ = (function (){var statearr_68889 = state_68866;
(statearr_68889[(4)] = cljs.core.rest.call(null,(state_68866[(4)])));

return statearr_68889;
})();
var state_68866__$1 = state_68866;
var statearr_68890_68914 = state_68866__$1;
(statearr_68890_68914[(2)] = inst_68861);

(statearr_68890_68914[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68867 === (10))){
var inst_68830 = (state_68866[(11)]);
var inst_68839 = (state_68866[(10)]);
var inst_68841 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68830)].join('');
var inst_68842 = cljs.core.assoc.call(null,inst_68839,"Authorization",inst_68841);
var state_68866__$1 = state_68866;
var statearr_68891_68915 = state_68866__$1;
(statearr_68891_68915[(2)] = inst_68842);

(statearr_68891_68915[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68867 === (8))){
var inst_68830 = (state_68866[(2)]);
var inst_68831 = clojure.string.replace.call(null,k,"_","/");
var inst_68832 = fluree.db.connection.get_server.call(null,conn_id,servers);
var state_68866__$1 = (function (){var statearr_68892 = state_68866;
(statearr_68892[(11)] = inst_68830);

(statearr_68892[(12)] = inst_68831);

return statearr_68892;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68866__$1,(9),inst_68832);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2746__auto__ = null;
var fluree$db$connection$state_machine__2746__auto____0 = (function (){
var statearr_68893 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68893[(0)] = fluree$db$connection$state_machine__2746__auto__);

(statearr_68893[(1)] = (1));

return statearr_68893;
});
var fluree$db$connection$state_machine__2746__auto____1 = (function (state_68866){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68866);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68894){var ex__2749__auto__ = e68894;
var statearr_68895_68916 = state_68866;
(statearr_68895_68916[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68866[(4)]))){
var statearr_68896_68917 = state_68866;
(statearr_68896_68917[(1)] = cljs.core.first.call(null,(state_68866[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68918 = state_68866;
state_68866 = G__68918;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2746__auto__ = function(state_68866){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2746__auto____1.call(this,state_68866);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2746__auto____0;
fluree$db$connection$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2746__auto____1;
return fluree$db$connection$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68897 = f__2769__auto__.call(null);
(statearr_68897[(6)] = c__2768__auto__);

return statearr_68897;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

fluree.db.connection.lookup_cache = (function fluree$db$connection$lookup_cache(cache_atom,k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.evict,k);
} else {
var temp__5804__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache_atom),k);
if(cljs.core.truth_(temp__5804__auto__)){
var v = temp__5804__auto__;
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.hit,k);

return v;
} else {
return null;
}
}
});
/**
 * Default synchronous object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
var temp__5802__auto__ = fluree.db.connection.lookup_cache.call(null,cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto__)){
var v = temp__5802__auto__;
return v;
} else {
var v = value_fn.call(null,k);
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.miss,k,v);

return v;
}
});
});
/**
 * Default asynchronous object cache to use for ledger.
 */
fluree.db.connection.default_async_cache_fn = (function fluree$db$connection$default_async_cache_fn(cache_atom){
return (function (k,value_fn){
var out = cljs.core.async.chan.call(null);
var temp__5802__auto___68943 = fluree.db.connection.lookup_cache.call(null,cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto___68943)){
var v_68944 = temp__5802__auto___68943;
cljs.core.async.put_BANG_.call(null,out,v_68944);
} else {
var c__2768__auto___68945 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68930){
var state_val_68931 = (state_68930[(1)]);
if((state_val_68931 === (1))){
var inst_68919 = value_fn.call(null,k);
var state_68930__$1 = state_68930;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68930__$1,(2),inst_68919);
} else {
if((state_val_68931 === (2))){
var inst_68921 = (state_68930[(7)]);
var inst_68921__$1 = (state_68930[(2)]);
var inst_68922 = fluree.db.util.core.exception_QMARK_.call(null,inst_68921__$1);
var state_68930__$1 = (function (){var statearr_68932 = state_68930;
(statearr_68932[(7)] = inst_68921__$1);

return statearr_68932;
})();
if(inst_68922){
var statearr_68933_68946 = state_68930__$1;
(statearr_68933_68946[(1)] = (3));

} else {
var statearr_68934_68947 = state_68930__$1;
(statearr_68934_68947[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68931 === (3))){
var state_68930__$1 = state_68930;
var statearr_68935_68948 = state_68930__$1;
(statearr_68935_68948[(2)] = null);

(statearr_68935_68948[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68931 === (4))){
var inst_68921 = (state_68930[(7)]);
var inst_68925 = cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.miss,k,inst_68921);
var state_68930__$1 = state_68930;
var statearr_68936_68949 = state_68930__$1;
(statearr_68936_68949[(2)] = inst_68925);

(statearr_68936_68949[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68931 === (5))){
var inst_68921 = (state_68930[(7)]);
var inst_68927 = (state_68930[(2)]);
var inst_68928 = cljs.core.async.put_BANG_.call(null,out,inst_68921);
var state_68930__$1 = (function (){var statearr_68937 = state_68930;
(statearr_68937[(8)] = inst_68927);

return statearr_68937;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68930__$1,inst_68928);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto__ = null;
var fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto____0 = (function (){
var statearr_68938 = [null,null,null,null,null,null,null,null,null];
(statearr_68938[(0)] = fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto__);

(statearr_68938[(1)] = (1));

return statearr_68938;
});
var fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto____1 = (function (state_68930){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68930);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68939){var ex__2749__auto__ = e68939;
var statearr_68940_68950 = state_68930;
(statearr_68940_68950[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68930[(4)]))){
var statearr_68941_68951 = state_68930;
(statearr_68941_68951[(1)] = cljs.core.first.call(null,(state_68930[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68952 = state_68930;
state_68930 = G__68952;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto__ = function(state_68930){
switch(arguments.length){
case 0:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto____1.call(this,state_68930);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto____0;
fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto____1;
return fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68942 = f__2769__auto__.call(null);
(statearr_68942[(6)] = c__2768__auto___68945);

return statearr_68942;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

}

return out;
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size);
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,ledger_id,key,fn){
if(cljs.core.fn_QMARK_.call(null,fn)){
} else {
throw cljs.core.ex_info.call(null,"add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.call(null,"add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null),(function (p1__68953_SHARP_){
if(cljs.core.truth_(p1__68953_SHARP_)){
throw cljs.core.ex_info.call(null,["add-listener key already in use: ",cljs.core.pr_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,ledger_id,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null)))){
cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null)], null),cljs.core.dissoc,key);

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + ledger-id.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,ledger_id,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var db = fluree.db.session.db.call(null,conn,ledger,null);
return fluree.db.connection.add_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key,fn);
});
/**
 * Removes listener on given network + ledger-id for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,ledger_id,key){
return fluree.db.connection.remove_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__68954_SHARP_){
var or__5045__auto__ = p1__68954_SHARP_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return token;
}
}));

return true;
}catch (e68955){var e = e68955;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__68956 = opts;
var map__68956__$1 = cljs.core.__destructure_map.call(null,map__68956);
var sub_chan = cljs.core.get.call(null,map__68956__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.call(null));
var storage_rename = cljs.core.get.call(null,map__68956__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.call(null,map__68956__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var storage_delete = cljs.core.get.call(null,map__68956__$1,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532));
var publish = cljs.core.get.call(null,map__68956__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.call(null,map__68956__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.call(null,map__68956__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.call(null,map__68956__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.call(null,map__68956__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.call(null,map__68956__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.call(null,map__68956__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.call(null,map__68956__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.call(null,map__68956__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.call(null,map__68956__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.call(null,map__68956__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.call(null,map__68956__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.call(null,map__68956__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde.call(null));
var memory = cljs.core.get.call(null,map__68956__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.call(null,map__68956__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var keep_alive = cljs.core.get.call(null,map__68956__$1,new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827));
var async_cache = cljs.core.get.call(null,map__68956__$1,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891));
var storage_write = cljs.core.get.call(null,map__68956__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.call(null,["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.call(null,map__68956__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.call(null,map__68956__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.call(null));
var pub_chan = cljs.core.get.call(null,map__68956__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.call(null));
var private_key_file = cljs.core.get.call(null,map__68956__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.call(null,map__68956__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot.call(null,memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.call(null,["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.call(null,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));
var object_cache_fn = (function (){var or__5045__auto__ = object_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_object_cache_fn.call(null,default_cache_atom);
}
})();
var async_cache_fn = (function (){var or__5045__auto__ = async_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_async_cache_fn.call(null,default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid.call(null));
var close = (function (){
cljs.core.async.close_BANG_.call(null,req_chan);

cljs.core.async.close_BANG_.call(null,sub_chan);

cljs.core.async.close_BANG_.call(null,pub_chan);

fluree.db.connection.close_websocket.call(null,conn_id);

cljs.core.swap_BANG_.call(null,state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

fluree.db.session.close_all_sessions.call(null,conn_id);

cljs.core.reset_BANG_.call(null,default_cache_atom,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));

if(cljs.core.fn_QMARK_.call(null,close_fn)){
close_fn.call(null);
} else {
}

return fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["connection closed"], null));
});
var servers_STAR_ = fluree.db.connection.normalize_servers.call(null,servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__5045__auto__ = storage_read;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__5045__auto__ = storage_exists;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = storage_read;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_.call(null,storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.call(null,storage_read)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_.call(null,storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.call(null,storage_exists)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__5043__auto__ = storage_write;
if(cljs.core.truth_(and__5043__auto__)){
return (!(cljs.core.fn_QMARK_.call(null,storage_write)));
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.call(null,storage_write)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.call(null,fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.call(null,fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,async_cache_fn,state_atom,keep_alive,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_.call(null,keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),storage_delete,publish]);
return fluree.db.connection.map__GT_Connection.call(null,settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_.call(null,conn))){
return false;
} else {
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn).call(null);

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__5775__auto__ = [];
var len__5769__auto___69000 = arguments.length;
var i__5770__auto___69001 = (0);
while(true){
if((i__5770__auto___69001 < len__5769__auto___69000)){
args__5775__auto__.push((arguments[i__5770__auto___69001]));

var G__69002 = (i__5770__auto___69001 + (1));
i__5770__auto___69001 = G__69002;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__68959){
var vec__68960 = p__68959;
var opts = cljs.core.nth.call(null,vec__68960,(0),null);
var conn = fluree.db.connection.generate_connection.call(null,servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2768__auto___69003 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68983){
var state_val_68984 = (state_68983[(1)]);
if((state_val_68984 === (1))){
var inst_68963 = fluree.db.connection.get_socket.call(null,conn);
var state_68983__$1 = state_68983;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68983__$1,(2),inst_68963);
} else {
if((state_val_68984 === (2))){
var inst_68965 = (state_68983[(7)]);
var inst_68966 = (state_68983[(8)]);
var inst_68965__$1 = (state_68983[(2)]);
var inst_68966__$1 = (inst_68965__$1 == null);
var state_68983__$1 = (function (){var statearr_68985 = state_68983;
(statearr_68985[(7)] = inst_68965__$1);

(statearr_68985[(8)] = inst_68966__$1);

return statearr_68985;
})();
if(cljs.core.truth_(inst_68966__$1)){
var statearr_68986_69004 = state_68983__$1;
(statearr_68986_69004[(1)] = (3));

} else {
var statearr_68987_69005 = state_68983__$1;
(statearr_68987_69005[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68984 === (3))){
var inst_68966 = (state_68983[(8)]);
var state_68983__$1 = state_68983;
var statearr_68988_69006 = state_68983__$1;
(statearr_68988_69006[(2)] = inst_68966);

(statearr_68988_69006[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68984 === (4))){
var inst_68965 = (state_68983[(7)]);
var inst_68969 = fluree.db.util.core.exception_QMARK_.call(null,inst_68965);
var state_68983__$1 = state_68983;
var statearr_68989_69007 = state_68983__$1;
(statearr_68989_69007[(2)] = inst_68969);

(statearr_68989_69007[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68984 === (5))){
var inst_68971 = (state_68983[(2)]);
var state_68983__$1 = state_68983;
if(cljs.core.truth_(inst_68971)){
var statearr_68990_69008 = state_68983__$1;
(statearr_68990_69008[(1)] = (6));

} else {
var statearr_68991_69009 = state_68983__$1;
(statearr_68991_69009[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68984 === (6))){
var inst_68965 = (state_68983[(7)]);
var inst_68973 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68974 = [inst_68965,"Cannot establish connection to a healthy server, disconnecting."];
var inst_68975 = (new cljs.core.PersistentVector(null,2,(5),inst_68973,inst_68974,null));
var inst_68976 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_68975);
var inst_68977 = cljs.core.async.close_BANG_.call(null,conn);
var state_68983__$1 = (function (){var statearr_68992 = state_68983;
(statearr_68992[(9)] = inst_68976);

return statearr_68992;
})();
var statearr_68993_69010 = state_68983__$1;
(statearr_68993_69010[(2)] = inst_68977);

(statearr_68993_69010[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68984 === (7))){
var inst_68979 = fluree.db.connection.msg_consumer.call(null,conn);
var state_68983__$1 = state_68983;
var statearr_68994_69011 = state_68983__$1;
(statearr_68994_69011[(2)] = inst_68979);

(statearr_68994_69011[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68984 === (8))){
var inst_68981 = (state_68983[(2)]);
var state_68983__$1 = state_68983;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68983__$1,inst_68981);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2746__auto__ = null;
var fluree$db$connection$state_machine__2746__auto____0 = (function (){
var statearr_68995 = [null,null,null,null,null,null,null,null,null,null];
(statearr_68995[(0)] = fluree$db$connection$state_machine__2746__auto__);

(statearr_68995[(1)] = (1));

return statearr_68995;
});
var fluree$db$connection$state_machine__2746__auto____1 = (function (state_68983){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68983);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68996){var ex__2749__auto__ = e68996;
var statearr_68997_69012 = state_68983;
(statearr_68997_69012[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68983[(4)]))){
var statearr_68998_69013 = state_68983;
(statearr_68998_69013[(1)] = cljs.core.first.call(null,(state_68983[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69014 = state_68983;
state_68983 = G__69014;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2746__auto__ = function(state_68983){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2746__auto____1.call(this,state_68983);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2746__auto____0;
fluree$db$connection$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2746__auto____1;
return fluree$db$connection$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68999 = f__2769__auto__.call(null);
(statearr_68999[(6)] = c__2768__auto___69003);

return statearr_68999;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

}

fluree.db.connection.msg_producer.call(null,conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq68957){
var G__68958 = cljs.core.first.call(null,seq68957);
var seq68957__$1 = cljs.core.next.call(null,seq68957);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__68958,seq68957__$1);
}));

