// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.call(null,new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt.call(null,secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__69025 = arguments.length;
switch (G__69025) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69070){
var state_val_69071 = (state_69070[(1)]);
if((state_val_69071 === (7))){
var inst_69040 = typeof user === 'string';
var state_69070__$1 = state_69070;
if(cljs.core.truth_(inst_69040)){
var statearr_69072_69101 = state_69070__$1;
(statearr_69072_69101[(1)] = (9));

} else {
var statearr_69073_69102 = state_69070__$1;
(statearr_69073_69102[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69071 === (1))){
var state_69070__$1 = state_69070;
var statearr_69074_69103 = state_69070__$1;
(statearr_69074_69103[(2)] = null);

(statearr_69074_69103[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69071 === (4))){
var inst_69026 = (state_69070[(2)]);
var inst_69027 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69028 = [inst_69026];
var inst_69029 = (new cljs.core.PersistentVector(null,1,(5),inst_69027,inst_69028,null));
var inst_69030 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_69029);
var inst_69031 = reject.call(null,inst_69026);
var state_69070__$1 = (function (){var statearr_69075 = state_69070;
(statearr_69075[(7)] = inst_69030);

return statearr_69075;
})();
var statearr_69076_69104 = state_69070__$1;
(statearr_69076_69104[(2)] = inst_69031);

(statearr_69076_69104[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69071 === (15))){
var inst_69059 = (state_69070[(2)]);
var inst_69060 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_69059);
var inst_69061 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_69062 = cljs.core.constantly.call(null,inst_69060);
var inst_69063 = cljs.core.swap_BANG_.call(null,inst_69061,inst_69062);
var inst_69064 = fluree.db.connection.add_token.call(null,conn,inst_69060);
var inst_69065 = resolve.call(null,inst_69059);
var _ = (function (){var statearr_69077 = state_69070;
(statearr_69077[(4)] = cljs.core.rest.call(null,(state_69070[(4)])));

return statearr_69077;
})();
var state_69070__$1 = (function (){var statearr_69078 = state_69070;
(statearr_69078[(8)] = inst_69064);

(statearr_69078[(9)] = inst_69063);

return statearr_69078;
})();
var statearr_69079_69105 = state_69070__$1;
(statearr_69079_69105[(2)] = inst_69065);

(statearr_69079_69105[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69071 === (13))){
var state_69070__$1 = state_69070;
var statearr_69080_69106 = state_69070__$1;
(statearr_69080_69106[(2)] = null);

(statearr_69080_69106[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69071 === (6))){
var state_69070__$1 = state_69070;
var statearr_69081_69107 = state_69070__$1;
(statearr_69081_69107[(2)] = user);

(statearr_69081_69107[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69071 === (3))){
var inst_69068 = (state_69070[(2)]);
var state_69070__$1 = state_69070;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69070__$1,inst_69068);
} else {
if((state_val_69071 === (12))){
var state_69070__$1 = state_69070;
var statearr_69082_69108 = state_69070__$1;
(statearr_69082_69108[(2)] = user);

(statearr_69082_69108[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69071 === (2))){
var _ = (function (){var statearr_69083 = state_69070;
(statearr_69083[(4)] = cljs.core.cons.call(null,(5),(state_69070[(4)])));

return statearr_69083;
})();
var inst_69037 = typeof user === 'number';
var state_69070__$1 = state_69070;
if(cljs.core.truth_(inst_69037)){
var statearr_69084_69109 = state_69070__$1;
(statearr_69084_69109[(1)] = (6));

} else {
var statearr_69085_69110 = state_69070__$1;
(statearr_69085_69110[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69071 === (11))){
var inst_69051 = (state_69070[(2)]);
var state_69070__$1 = state_69070;
var statearr_69087_69111 = state_69070__$1;
(statearr_69087_69111[(2)] = inst_69051);

(statearr_69087_69111[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69071 === (9))){
var inst_69042 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69043 = ["_user/username",user];
var inst_69044 = (new cljs.core.PersistentVector(null,2,(5),inst_69042,inst_69043,null));
var state_69070__$1 = state_69070;
var statearr_69088_69112 = state_69070__$1;
(statearr_69088_69112[(2)] = inst_69044);

(statearr_69088_69112[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69071 === (5))){
var _ = (function (){var statearr_69089 = state_69070;
(statearr_69089[(4)] = cljs.core.rest.call(null,(state_69070[(4)])));

return statearr_69089;
})();
var state_69070__$1 = state_69070;
var ex69086 = (state_69070__$1[(2)]);
var statearr_69090_69113 = state_69070__$1;
(statearr_69090_69113[(5)] = ex69086);


var statearr_69091_69114 = state_69070__$1;
(statearr_69091_69114[(1)] = (4));

(statearr_69091_69114[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69071 === (14))){
var inst_69049 = (state_69070[(2)]);
var state_69070__$1 = state_69070;
var statearr_69092_69115 = state_69070__$1;
(statearr_69092_69115[(2)] = inst_69049);

(statearr_69092_69115[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69071 === (10))){
var state_69070__$1 = state_69070;
var statearr_69093_69116 = state_69070__$1;
(statearr_69093_69116[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69071 === (8))){
var inst_69053 = (state_69070[(2)]);
var inst_69054 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_69055 = [account,inst_69053,password,expireSeconds,syncTo];
var inst_69056 = cljs.core.PersistentHashMap.fromArrays(inst_69054,inst_69055);
var inst_69057 = fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_69056);
var state_69070__$1 = state_69070;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69070__$1,(15),inst_69057);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_69095 = [null,null,null,null,null,null,null,null,null,null];
(statearr_69095[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_69095[(1)] = (1));

return statearr_69095;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_69070){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69070);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69096){var ex__2749__auto__ = e69096;
var statearr_69097_69117 = state_69070;
(statearr_69097_69117[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69070[(4)]))){
var statearr_69098_69118 = state_69070;
(statearr_69098_69118[(1)] = cljs.core.first.call(null,(state_69070[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69119 = state_69070;
state_69070 = G__69119;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_69070){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_69070);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69099 = f__2769__auto__.call(null);
(statearr_69099[(6)] = c__2768__auto__);

return statearr_69099;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__69121 = arguments.length;
switch (G__69121) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,fluree.db.connection.connect.call(null,servers_string,opts),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.call(null);
var _ = (function (){var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69130){
var state_val_69131 = (state_69130[(1)]);
if((state_val_69131 === (1))){
var inst_69122 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_69123 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69124 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_69125 = (new cljs.core.PersistentVector(null,4,(5),inst_69123,inst_69124,null));
var inst_69126 = cljs.core.async.put_BANG_.call(null,inst_69122,inst_69125);
var inst_69127 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__69132 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__69133 = null;
var count__69134 = (0);
var i__69135 = (0);
while(true){
if((i__69135 < count__69134)){
var k = cljs.core._nth.call(null,chunk__69133,i__69135);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__69143 = seq__69132;
var G__69144 = chunk__69133;
var G__69145 = count__69134;
var G__69146 = (i__69135 + (1));
seq__69132 = G__69143;
chunk__69133 = G__69144;
count__69134 = G__69145;
i__69135 = G__69146;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__69132);
if(temp__5804__auto__){
var seq__69132__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__69132__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__69132__$1);
var G__69147 = cljs.core.chunk_rest.call(null,seq__69132__$1);
var G__69148 = c__5568__auto__;
var G__69149 = cljs.core.count.call(null,c__5568__auto__);
var G__69150 = (0);
seq__69132 = G__69147;
chunk__69133 = G__69148;
count__69134 = G__69149;
i__69135 = G__69150;
continue;
} else {
var k = cljs.core.first.call(null,seq__69132__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__69151 = cljs.core.next.call(null,seq__69132__$1);
var G__69152 = null;
var G__69153 = (0);
var G__69154 = (0);
seq__69132 = G__69151;
chunk__69133 = G__69152;
count__69134 = G__69153;
i__69135 = G__69154;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_69128 = cljs.core.async.take_BANG_.call(null,pc,inst_69127);
var state_69130__$1 = (function (){var statearr_69136 = state_69130;
(statearr_69136[(7)] = inst_69126);

return statearr_69136;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69130__$1,inst_69128);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_69137 = [null,null,null,null,null,null,null,null];
(statearr_69137[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_69137[(1)] = (1));

return statearr_69137;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_69130){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69130);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69138){var ex__2749__auto__ = e69138;
var statearr_69139_69155 = state_69130;
(statearr_69139_69155[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69130[(4)]))){
var statearr_69140_69156 = state_69130;
(statearr_69140_69156[(1)] = cljs.core.first.call(null,(state_69130[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69157 = state_69130;
state_69130 = G__69157;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_69130){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_69130);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69141 = f__2769__auto__.call(null);
(statearr_69141[(6)] = c__2768__auto__);

return statearr_69141;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__69159 = arguments.length;
switch (G__69159) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69196){
var state_val_69197 = (state_69196[(1)]);
if((state_val_69197 === (1))){
var state_69196__$1 = state_69196;
var statearr_69198_69219 = state_69196__$1;
(statearr_69198_69219[(2)] = null);

(statearr_69198_69219[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69197 === (2))){
var _ = (function (){var statearr_69199 = state_69196;
(statearr_69199[(4)] = cljs.core.cons.call(null,(5),(state_69196[(4)])));

return statearr_69199;
})();
var inst_69171 = fluree.db.connection.connect.call(null,servers_string,opts);
var inst_69172 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69173 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_69174 = (new cljs.core.PersistentVector(null,1,(5),inst_69172,inst_69173,null));
var inst_69175 = cljs.core.PersistentHashMap.EMPTY;
var inst_69176 = cljs.core.atom.call(null,inst_69175);
var inst_69177 = cljs.core.assoc_in.call(null,inst_69171,inst_69174,inst_69176);
var inst_69178 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69179 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_69180 = (new cljs.core.PersistentVector(null,1,(5),inst_69178,inst_69179,null));
var inst_69181 = cljs.core.PersistentHashMap.EMPTY;
var inst_69182 = cljs.core.atom.call(null,inst_69181);
var inst_69183 = cljs.core.assoc_in.call(null,inst_69177,inst_69180,inst_69182);
var inst_69184 = cljs.core.async.promise_chan.call(null);
var inst_69185 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_69183);
var inst_69186 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69187 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_69184,null];
var inst_69188 = (new cljs.core.PersistentVector(null,4,(5),inst_69186,inst_69187,null));
var inst_69189 = cljs.core.async.put_BANG_.call(null,inst_69185,inst_69188);
var inst_69190 = (function (){var conn = inst_69183;
var pc = inst_69184;
return (function (x){
if((x == null)){
} else {
var seq__69200_69220 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__69201_69221 = null;
var count__69202_69222 = (0);
var i__69203_69223 = (0);
while(true){
if((i__69203_69223 < count__69202_69222)){
var k_69224 = cljs.core._nth.call(null,chunk__69201_69221,i__69203_69223);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_69224], null),cljs.core.get.call(null,x,k_69224,null));


var G__69225 = seq__69200_69220;
var G__69226 = chunk__69201_69221;
var G__69227 = count__69202_69222;
var G__69228 = (i__69203_69223 + (1));
seq__69200_69220 = G__69225;
chunk__69201_69221 = G__69226;
count__69202_69222 = G__69227;
i__69203_69223 = G__69228;
continue;
} else {
var temp__5804__auto___69229 = cljs.core.seq.call(null,seq__69200_69220);
if(temp__5804__auto___69229){
var seq__69200_69230__$1 = temp__5804__auto___69229;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__69200_69230__$1)){
var c__5568__auto___69231 = cljs.core.chunk_first.call(null,seq__69200_69230__$1);
var G__69232 = cljs.core.chunk_rest.call(null,seq__69200_69230__$1);
var G__69233 = c__5568__auto___69231;
var G__69234 = cljs.core.count.call(null,c__5568__auto___69231);
var G__69235 = (0);
seq__69200_69220 = G__69232;
chunk__69201_69221 = G__69233;
count__69202_69222 = G__69234;
i__69203_69223 = G__69235;
continue;
} else {
var k_69236 = cljs.core.first.call(null,seq__69200_69230__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_69236], null),cljs.core.get.call(null,x,k_69236,null));


var G__69237 = cljs.core.next.call(null,seq__69200_69230__$1);
var G__69238 = null;
var G__69239 = (0);
var G__69240 = (0);
seq__69200_69220 = G__69237;
chunk__69201_69221 = G__69238;
count__69202_69222 = G__69239;
i__69203_69223 = G__69240;
continue;
}
} else {
}
}
break;
}
}

return resolve.call(null,conn);
});
})();
var inst_69191 = cljs.core.async.take_BANG_.call(null,inst_69184,inst_69190);
var ___$1 = (function (){var statearr_69204 = state_69196;
(statearr_69204[(4)] = cljs.core.rest.call(null,(state_69196[(4)])));

return statearr_69204;
})();
var state_69196__$1 = (function (){var statearr_69205 = state_69196;
(statearr_69205[(7)] = inst_69189);

return statearr_69205;
})();
var statearr_69206_69241 = state_69196__$1;
(statearr_69206_69241[(2)] = inst_69191);

(statearr_69206_69241[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69197 === (3))){
var inst_69194 = (state_69196[(2)]);
var state_69196__$1 = state_69196;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69196__$1,inst_69194);
} else {
if((state_val_69197 === (4))){
var inst_69160 = (state_69196[(2)]);
var inst_69161 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69162 = [inst_69160];
var inst_69163 = (new cljs.core.PersistentVector(null,1,(5),inst_69161,inst_69162,null));
var inst_69164 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_69163);
var inst_69165 = reject.call(null,inst_69160);
var state_69196__$1 = (function (){var statearr_69208 = state_69196;
(statearr_69208[(8)] = inst_69164);

return statearr_69208;
})();
var statearr_69209_69242 = state_69196__$1;
(statearr_69209_69242[(2)] = inst_69165);

(statearr_69209_69242[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69197 === (5))){
var _ = (function (){var statearr_69210 = state_69196;
(statearr_69210[(4)] = cljs.core.rest.call(null,(state_69196[(4)])));

return statearr_69210;
})();
var state_69196__$1 = state_69196;
var ex69207 = (state_69196__$1[(2)]);
var statearr_69211_69243 = state_69196__$1;
(statearr_69211_69243[(5)] = ex69207);


var statearr_69212_69244 = state_69196__$1;
(statearr_69212_69244[(1)] = (4));

(statearr_69212_69244[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_69213 = [null,null,null,null,null,null,null,null,null];
(statearr_69213[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_69213[(1)] = (1));

return statearr_69213;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_69196){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69196);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69214){var ex__2749__auto__ = e69214;
var statearr_69215_69245 = state_69196;
(statearr_69215_69245[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69196[(4)]))){
var statearr_69216_69246 = state_69196;
(statearr_69216_69246[(1)] = cljs.core.first.call(null,(state_69196[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69247 = state_69196;
state_69196 = G__69247;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_69196){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_69196);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69217 = f__2769__auto__.call(null);
(statearr_69217[(6)] = c__2768__auto__);

return statearr_69217;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_.call(null,conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__69249 = arguments.length;
switch (G__69249) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.call(null,conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not.call(null,open_api_QMARK_)) && (cljs.core.not.call(null,has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.call(null,"To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token.call(null,conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__69251 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__69251,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__69251,(1),null);
var cb_STAR_ = (function (header,data){
return callback.call(null,cljs.core.clj__GT_js.call(null,header),cljs.core.clj__GT_js.call(null,data));
});
return fluree.db.connection.add_listener.call(null,conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__69254 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__69254,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__69254,(1),null);
return fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js.call(null,fluree.db.connection.listeners.call(null,conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69307){
var state_val_69308 = (state_69307[(1)]);
if((state_val_69308 === (7))){
var inst_69268 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69269 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_69270 = cljs.core.PersistentHashMap.fromArrays(inst_69268,inst_69269);
var inst_69271 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_69270);
var inst_69272 = (function(){throw inst_69271})();
var state_69307__$1 = state_69307;
var statearr_69309_69338 = state_69307__$1;
(statearr_69309_69338[(2)] = inst_69272);

(statearr_69309_69338[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69308 === (1))){
var state_69307__$1 = state_69307;
var statearr_69310_69339 = state_69307__$1;
(statearr_69310_69339[(2)] = null);

(statearr_69310_69339[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69308 === (4))){
var inst_69257 = (state_69307[(2)]);
var inst_69258 = cljs.core.clj__GT_js.call(null,inst_69257);
var inst_69259 = reject.call(null,inst_69258);
var state_69307__$1 = state_69307;
var statearr_69311_69340 = state_69307__$1;
(statearr_69311_69340[(2)] = inst_69259);

(statearr_69311_69340[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69308 === (13))){
var inst_69286 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69287 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_69288 = cljs.core.PersistentHashMap.fromArrays(inst_69286,inst_69287);
var inst_69289 = cljs.core.ex_info.call(null,"A password must be supplied.",inst_69288);
var inst_69290 = (function(){throw inst_69289})();
var state_69307__$1 = state_69307;
var statearr_69312_69341 = state_69307__$1;
(statearr_69312_69341[(2)] = inst_69290);

(statearr_69312_69341[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69308 === (6))){
var state_69307__$1 = state_69307;
var statearr_69313_69342 = state_69307__$1;
(statearr_69313_69342[(2)] = null);

(statearr_69313_69342[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69308 === (3))){
var inst_69305 = (state_69307[(2)]);
var state_69307__$1 = state_69307;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69307__$1,inst_69305);
} else {
if((state_val_69308 === (12))){
var state_69307__$1 = state_69307;
var statearr_69314_69343 = state_69307__$1;
(statearr_69314_69343[(2)] = null);

(statearr_69314_69343[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69308 === (2))){
var _ = (function (){var statearr_69315 = state_69307;
(statearr_69315[(4)] = cljs.core.cons.call(null,(5),(state_69307[(4)])));

return statearr_69315;
})();
var inst_69265 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_69307__$1 = state_69307;
if(cljs.core.truth_(inst_69265)){
var statearr_69316_69344 = state_69307__$1;
(statearr_69316_69344[(1)] = (6));

} else {
var statearr_69317_69345 = state_69307__$1;
(statearr_69317_69345[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69308 === (11))){
var inst_69283 = (state_69307[(2)]);
var state_69307__$1 = (function (){var statearr_69319 = state_69307;
(statearr_69319[(7)] = inst_69283);

return statearr_69319;
})();
if(cljs.core.truth_(password)){
var statearr_69320_69346 = state_69307__$1;
(statearr_69320_69346[(1)] = (12));

} else {
var statearr_69321_69347 = state_69307__$1;
(statearr_69321_69347[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69308 === (9))){
var state_69307__$1 = state_69307;
var statearr_69322_69348 = state_69307__$1;
(statearr_69322_69348[(2)] = null);

(statearr_69322_69348[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69308 === (5))){
var _ = (function (){var statearr_69323 = state_69307;
(statearr_69323[(4)] = cljs.core.rest.call(null,(state_69307[(4)])));

return statearr_69323;
})();
var state_69307__$1 = state_69307;
var ex69318 = (state_69307__$1[(2)]);
var statearr_69324_69349 = state_69307__$1;
(statearr_69324_69349[(5)] = ex69318);


var statearr_69325_69350 = state_69307__$1;
(statearr_69325_69350[(1)] = (4));

(statearr_69325_69350[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69308 === (14))){
var inst_69292 = (state_69307[(2)]);
var inst_69293 = cljs.core.assoc.call(null,map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,new cljs.core.Keyword(null,"password","password",417022471),password);
var inst_69294 = fluree.db.util.core.without_nils.call(null,inst_69293);
var inst_69295 = cljs.core.async.promise_chan.call(null);
var inst_69296 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_69297 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69298 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_69294,inst_69295,null];
var inst_69299 = (new cljs.core.PersistentVector(null,4,(5),inst_69297,inst_69298,null));
var inst_69300 = cljs.core.async.put_BANG_.call(null,inst_69296,inst_69299);
var inst_69301 = (function (){var _ = inst_69292;
var data = inst_69294;
var pc = inst_69295;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_69302 = cljs.core.async.take_BANG_.call(null,inst_69295,inst_69301);
var _ = (function (){var statearr_69326 = state_69307;
(statearr_69326[(4)] = cljs.core.rest.call(null,(state_69307[(4)])));

return statearr_69326;
})();
var state_69307__$1 = (function (){var statearr_69327 = state_69307;
(statearr_69327[(8)] = inst_69300);

return statearr_69327;
})();
var statearr_69328_69351 = state_69307__$1;
(statearr_69328_69351[(2)] = inst_69302);

(statearr_69328_69351[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69308 === (10))){
var inst_69277 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69278 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_69279 = cljs.core.PersistentHashMap.fromArrays(inst_69277,inst_69278);
var inst_69280 = cljs.core.ex_info.call(null,"A ledger must be supplied.",inst_69279);
var inst_69281 = (function(){throw inst_69280})();
var state_69307__$1 = state_69307;
var statearr_69329_69352 = state_69307__$1;
(statearr_69329_69352[(2)] = inst_69281);

(statearr_69329_69352[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69308 === (8))){
var inst_69274 = (state_69307[(2)]);
var state_69307__$1 = (function (){var statearr_69330 = state_69307;
(statearr_69330[(9)] = inst_69274);

return statearr_69330;
})();
if(cljs.core.truth_(ledger)){
var statearr_69331_69353 = state_69307__$1;
(statearr_69331_69353[(1)] = (9));

} else {
var statearr_69332_69354 = state_69307__$1;
(statearr_69332_69354[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2746__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2746__auto____0 = (function (){
var statearr_69333 = [null,null,null,null,null,null,null,null,null,null];
(statearr_69333[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2746__auto__);

(statearr_69333[(1)] = (1));

return statearr_69333;
});
var fluree$db$connection_js$password_generate_$_state_machine__2746__auto____1 = (function (state_69307){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69307);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69334){var ex__2749__auto__ = e69334;
var statearr_69335_69355 = state_69307;
(statearr_69335_69355[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69307[(4)]))){
var statearr_69336_69356 = state_69307;
(statearr_69336_69356[(1)] = cljs.core.first.call(null,(state_69307[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69357 = state_69307;
state_69307 = G__69357;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2746__auto__ = function(state_69307){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2746__auto____1.call(this,state_69307);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2746__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2746__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69337 = f__2769__auto__.call(null);
(statearr_69337[(6)] = c__2768__auto__);

return statearr_69337;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__69359 = arguments.length;
switch (G__69359) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69426){
var state_val_69427 = (state_69426[(1)]);
if((state_val_69427 === (7))){
var inst_69371 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69372 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_69373 = cljs.core.PersistentHashMap.fromArrays(inst_69371,inst_69372);
var inst_69374 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_69373);
var inst_69375 = (function(){throw inst_69374})();
var state_69426__$1 = state_69426;
var statearr_69428_69467 = state_69426__$1;
(statearr_69428_69467[(2)] = inst_69375);

(statearr_69428_69467[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69427 === (20))){
var inst_69409 = (state_69426[(2)]);
var inst_69410 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_69411 = [ledger,password,user,auth,expire];
var inst_69412 = cljs.core.PersistentHashMap.fromArrays(inst_69410,inst_69411);
var inst_69413 = fluree.db.util.core.without_nils.call(null,inst_69412);
var inst_69414 = cljs.core.async.promise_chan.call(null);
var inst_69415 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_69416 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69417 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_69413,inst_69414,null];
var inst_69418 = (new cljs.core.PersistentVector(null,4,(5),inst_69416,inst_69417,null));
var inst_69419 = cljs.core.async.put_BANG_.call(null,inst_69415,inst_69418);
var inst_69420 = (function (){var _ = inst_69409;
var data = inst_69413;
var pc = inst_69414;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_69421 = cljs.core.async.take_BANG_.call(null,inst_69414,inst_69420);
var _ = (function (){var statearr_69429 = state_69426;
(statearr_69429[(4)] = cljs.core.rest.call(null,(state_69426[(4)])));

return statearr_69429;
})();
var state_69426__$1 = (function (){var statearr_69430 = state_69426;
(statearr_69430[(7)] = inst_69419);

return statearr_69430;
})();
var statearr_69431_69468 = state_69426__$1;
(statearr_69431_69468[(2)] = inst_69421);

(statearr_69431_69468[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69427 === (1))){
var state_69426__$1 = state_69426;
var statearr_69432_69469 = state_69426__$1;
(statearr_69432_69469[(2)] = null);

(statearr_69432_69469[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69427 === (4))){
var inst_69360 = (state_69426[(2)]);
var inst_69361 = cljs.core.clj__GT_js.call(null,inst_69360);
var inst_69362 = reject.call(null,inst_69361);
var state_69426__$1 = state_69426;
var statearr_69433_69470 = state_69426__$1;
(statearr_69433_69470[(2)] = inst_69362);

(statearr_69433_69470[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69427 === (15))){
var inst_69396 = (state_69426[(8)]);
var state_69426__$1 = state_69426;
var statearr_69434_69471 = state_69426__$1;
(statearr_69434_69471[(2)] = inst_69396);

(statearr_69434_69471[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69427 === (13))){
var inst_69389 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69390 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_69391 = cljs.core.PersistentHashMap.fromArrays(inst_69389,inst_69390);
var inst_69392 = cljs.core.ex_info.call(null,"A password must be supplied in the provided JSON.",inst_69391);
var inst_69393 = (function(){throw inst_69392})();
var state_69426__$1 = state_69426;
var statearr_69435_69472 = state_69426__$1;
(statearr_69435_69472[(2)] = inst_69393);

(statearr_69435_69472[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69427 === (6))){
var state_69426__$1 = state_69426;
var statearr_69436_69473 = state_69426__$1;
(statearr_69436_69473[(2)] = null);

(statearr_69436_69473[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69427 === (17))){
var inst_69400 = (state_69426[(2)]);
var state_69426__$1 = state_69426;
if(cljs.core.truth_(inst_69400)){
var statearr_69437_69474 = state_69426__$1;
(statearr_69437_69474[(1)] = (18));

} else {
var statearr_69438_69475 = state_69426__$1;
(statearr_69438_69475[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69427 === (3))){
var inst_69424 = (state_69426[(2)]);
var state_69426__$1 = state_69426;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69426__$1,inst_69424);
} else {
if((state_val_69427 === (12))){
var state_69426__$1 = state_69426;
var statearr_69439_69476 = state_69426__$1;
(statearr_69439_69476[(2)] = null);

(statearr_69439_69476[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69427 === (2))){
var _ = (function (){var statearr_69440 = state_69426;
(statearr_69440[(4)] = cljs.core.cons.call(null,(5),(state_69426[(4)])));

return statearr_69440;
})();
var inst_69368 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_69426__$1 = state_69426;
if(cljs.core.truth_(inst_69368)){
var statearr_69441_69477 = state_69426__$1;
(statearr_69441_69477[(1)] = (6));

} else {
var statearr_69442_69478 = state_69426__$1;
(statearr_69442_69478[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69427 === (19))){
var inst_69403 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69404 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_69405 = cljs.core.PersistentHashMap.fromArrays(inst_69403,inst_69404);
var inst_69406 = cljs.core.ex_info.call(null,"A user identity or auth identity must be supplied.",inst_69405);
var inst_69407 = (function(){throw inst_69406})();
var state_69426__$1 = state_69426;
var statearr_69443_69479 = state_69426__$1;
(statearr_69443_69479[(2)] = inst_69407);

(statearr_69443_69479[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69427 === (11))){
var inst_69386 = (state_69426[(2)]);
var state_69426__$1 = (function (){var statearr_69445 = state_69426;
(statearr_69445[(9)] = inst_69386);

return statearr_69445;
})();
if(cljs.core.truth_(password)){
var statearr_69446_69480 = state_69426__$1;
(statearr_69446_69480[(1)] = (12));

} else {
var statearr_69447_69481 = state_69426__$1;
(statearr_69447_69481[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69427 === (9))){
var state_69426__$1 = state_69426;
var statearr_69448_69482 = state_69426__$1;
(statearr_69448_69482[(2)] = null);

(statearr_69448_69482[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69427 === (5))){
var _ = (function (){var statearr_69449 = state_69426;
(statearr_69449[(4)] = cljs.core.rest.call(null,(state_69426[(4)])));

return statearr_69449;
})();
var state_69426__$1 = state_69426;
var ex69444 = (state_69426__$1[(2)]);
var statearr_69450_69483 = state_69426__$1;
(statearr_69450_69483[(5)] = ex69444);


var statearr_69451_69484 = state_69426__$1;
(statearr_69451_69484[(1)] = (4));

(statearr_69451_69484[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69427 === (14))){
var inst_69396 = (state_69426[(8)]);
var inst_69395 = (state_69426[(2)]);
var inst_69396__$1 = user;
var state_69426__$1 = (function (){var statearr_69452 = state_69426;
(statearr_69452[(8)] = inst_69396__$1);

(statearr_69452[(10)] = inst_69395);

return statearr_69452;
})();
if(cljs.core.truth_(inst_69396__$1)){
var statearr_69453_69485 = state_69426__$1;
(statearr_69453_69485[(1)] = (15));

} else {
var statearr_69454_69486 = state_69426__$1;
(statearr_69454_69486[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69427 === (16))){
var state_69426__$1 = state_69426;
var statearr_69455_69487 = state_69426__$1;
(statearr_69455_69487[(2)] = auth);

(statearr_69455_69487[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69427 === (10))){
var inst_69380 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69381 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_69382 = cljs.core.PersistentHashMap.fromArrays(inst_69380,inst_69381);
var inst_69383 = cljs.core.ex_info.call(null,"A ledger must be supplied in the provided JSON.",inst_69382);
var inst_69384 = (function(){throw inst_69383})();
var state_69426__$1 = state_69426;
var statearr_69456_69488 = state_69426__$1;
(statearr_69456_69488[(2)] = inst_69384);

(statearr_69456_69488[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69427 === (18))){
var state_69426__$1 = state_69426;
var statearr_69457_69489 = state_69426__$1;
(statearr_69457_69489[(2)] = null);

(statearr_69457_69489[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69427 === (8))){
var inst_69377 = (state_69426[(2)]);
var state_69426__$1 = (function (){var statearr_69458 = state_69426;
(statearr_69458[(11)] = inst_69377);

return statearr_69458;
})();
if(cljs.core.truth_(ledger)){
var statearr_69459_69490 = state_69426__$1;
(statearr_69459_69490[(1)] = (9));

} else {
var statearr_69460_69491 = state_69426__$1;
(statearr_69460_69491[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_69461 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69461[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_69461[(1)] = (1));

return statearr_69461;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_69426){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69426);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69462){var ex__2749__auto__ = e69462;
var statearr_69463_69492 = state_69426;
(statearr_69463_69492[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69426[(4)]))){
var statearr_69464_69493 = state_69426;
(statearr_69464_69493[(1)] = cljs.core.first.call(null,(state_69426[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69494 = state_69426;
state_69426 = G__69494;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_69426){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_69426);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69465 = f__2769__auto__.call(null);
(statearr_69465[(6)] = c__2768__auto__);

return statearr_69465;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__69496 = arguments.length;
switch (G__69496) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69531){
var state_val_69532 = (state_69531[(1)]);
if((state_val_69532 === (1))){
var state_69531__$1 = state_69531;
var statearr_69533_69553 = state_69531__$1;
(statearr_69533_69553[(2)] = null);

(statearr_69533_69553[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69532 === (2))){
var _ = (function (){var statearr_69534 = state_69531;
(statearr_69534[(4)] = cljs.core.cons.call(null,(5),(state_69531[(4)])));

return statearr_69534;
})();
var inst_69505 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_69531__$1 = state_69531;
if(cljs.core.truth_(inst_69505)){
var statearr_69535_69554 = state_69531__$1;
(statearr_69535_69554[(1)] = (6));

} else {
var statearr_69536_69555 = state_69531__$1;
(statearr_69536_69555[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69532 === (3))){
var inst_69529 = (state_69531[(2)]);
var state_69531__$1 = state_69531;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69531__$1,inst_69529);
} else {
if((state_val_69532 === (4))){
var inst_69497 = (state_69531[(2)]);
var inst_69498 = cljs.core.clj__GT_js.call(null,inst_69497);
var inst_69499 = reject.call(null,inst_69498);
var state_69531__$1 = state_69531;
var statearr_69538_69556 = state_69531__$1;
(statearr_69538_69556[(2)] = inst_69499);

(statearr_69538_69556[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69532 === (5))){
var _ = (function (){var statearr_69539 = state_69531;
(statearr_69539[(4)] = cljs.core.rest.call(null,(state_69531[(4)])));

return statearr_69539;
})();
var state_69531__$1 = state_69531;
var ex69537 = (state_69531__$1[(2)]);
var statearr_69540_69557 = state_69531__$1;
(statearr_69540_69557[(5)] = ex69537);


var statearr_69541_69558 = state_69531__$1;
(statearr_69541_69558[(1)] = (4));

(statearr_69541_69558[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69532 === (6))){
var state_69531__$1 = state_69531;
var statearr_69542_69559 = state_69531__$1;
(statearr_69542_69559[(2)] = null);

(statearr_69542_69559[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69532 === (7))){
var inst_69508 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69509 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_69510 = cljs.core.PersistentHashMap.fromArrays(inst_69508,inst_69509);
var inst_69511 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_69510);
var inst_69512 = (function(){throw inst_69511})();
var state_69531__$1 = state_69531;
var statearr_69543_69560 = state_69531__$1;
(statearr_69543_69560[(2)] = inst_69512);

(statearr_69543_69560[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69532 === (8))){
var inst_69514 = (state_69531[(2)]);
var inst_69515 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_69516 = [jwt,expire];
var inst_69517 = cljs.core.PersistentHashMap.fromArrays(inst_69515,inst_69516);
var inst_69518 = fluree.db.util.core.without_nils.call(null,inst_69517);
var inst_69519 = cljs.core.async.promise_chan.call(null);
var inst_69520 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_69521 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69522 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_69518,inst_69519,null];
var inst_69523 = (new cljs.core.PersistentVector(null,4,(5),inst_69521,inst_69522,null));
var inst_69524 = cljs.core.async.put_BANG_.call(null,inst_69520,inst_69523);
var inst_69525 = (function (){var _ = inst_69514;
var data = inst_69518;
var pc = inst_69519;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
});
})();
var inst_69526 = cljs.core.async.take_BANG_.call(null,inst_69519,inst_69525);
var _ = (function (){var statearr_69544 = state_69531;
(statearr_69544[(4)] = cljs.core.rest.call(null,(state_69531[(4)])));

return statearr_69544;
})();
var state_69531__$1 = (function (){var statearr_69545 = state_69531;
(statearr_69545[(7)] = inst_69524);

return statearr_69545;
})();
var statearr_69546_69561 = state_69531__$1;
(statearr_69546_69561[(2)] = inst_69526);

(statearr_69546_69561[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_69547 = [null,null,null,null,null,null,null,null];
(statearr_69547[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_69547[(1)] = (1));

return statearr_69547;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_69531){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69531);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69548){var ex__2749__auto__ = e69548;
var statearr_69549_69562 = state_69531;
(statearr_69549_69562[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69531[(4)]))){
var statearr_69550_69563 = state_69531;
(statearr_69550_69563[(1)] = cljs.core.first.call(null,(state_69531[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69564 = state_69531;
state_69531 = G__69564;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_69531){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_69531);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69551 = f__2769__auto__.call(null);
(statearr_69551[(6)] = c__2768__auto__);

return statearr_69551;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

