// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.core');
goog.require('cljs.core');
goog.require('sci.core');
goog.require('fluree.db.dbfunctions.fns');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
/**
 * Returns true if the arg is a string containing a transaction function.
 */
fluree.db.dbfunctions.core.tx_fn_QMARK_ = (function fluree$db$dbfunctions$core$tx_fn_QMARK_(v){
var and__5043__auto__ = typeof v === 'string';
if(and__5043__auto__){
return cljs.core.re_matches.call(null,/^#\(.+\)$/,v);
} else {
return and__5043__auto__;
}
});
fluree.db.dbfunctions.core.allowed_symbols = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [new cljs.core.Symbol(null,"?pO","?pO",1714537515,null),null,new cljs.core.Symbol(null,"?auth_id","?auth_id",612691741,null),null,new cljs.core.Symbol(null,"sid","sid",-839419355,null),null,new cljs.core.Symbol(null,"?user_id","?user_id",-101968770,null),null,new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),null,new cljs.core.Symbol(null,"?a","?a",1314302913,null),null,new cljs.core.Symbol(null,"?db","?db",1493359450,null),null,new cljs.core.Symbol(null,"?s","?s",456183954,null),null,new cljs.core.Symbol(null,"?o","?o",-1814741084,null),null], null), null);
/**
 * Copies local fns ns public vars into SCI
 */
fluree.db.dbfunctions.core.load_local_fns_ns = (function fluree$db$dbfunctions$core$load_local_fns_ns(){
var ns_public_vars = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentVector.fromArray([new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"uuid"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.uuid;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","uuid","fluree.db.dbfunctions.fns/uuid",1199900311,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,803,null,803,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.uuid)?fluree.db.dbfunctions.fns.uuid.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"max-pred-val"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.max_pred_val;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","max-pred-val","fluree.db.dbfunctions.fns/max-pred-val",884898813,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"max-pred-val","max-pred-val",-1898501472,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",19,1,546,null,546,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null)),"Finds the maximum predicate value.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max_pred_val)?fluree.db.dbfunctions.fns.max_pred_val.cljs$lang$test:null),"10, plus fuel cost."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"contains?"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.contains_QMARK_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","contains?","fluree.db.dbfunctions.fns/contains?",979635755,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",16,1,372,null,372,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),"Returns true if key is present.",(cljs.core.truth_(fluree.db.dbfunctions.fns.contains_QMARK_)?fluree.db.dbfunctions.fns.contains_QMARK_.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"subs"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.subs;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","subs","fluree.db.dbfunctions.fns/subs",815704759,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"subs","subs",1453849536,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,135,null,135,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(cljs.core.truth_(fluree.db.dbfunctions.fns.subs)?fluree.db.dbfunctions.fns.subs.cljs$lang$test:null),(30)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"ctx"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.ctx;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","ctx","fluree.db.dbfunctions.fns/ctx",570947084,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"ctx","ctx",1146921409,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,363,null,363,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"db","db",-1661185010,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.Symbol(null,"key-or-ks","key-or-ks",715926861,null)], null)),"Returns a value from the user's context if set. Provide the key or key sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.ctx)?fluree.db.dbfunctions.fns.ctx.cljs$lang$test:null),(1)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"query"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.query;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","query","fluree.db.dbfunctions.fns/query",2131906892,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"query","query",352022017,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,504,null,504,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),"Executes a query",(cljs.core.truth_(fluree.db.dbfunctions.fns.query)?fluree.db.dbfunctions.fns.query.cljs$lang$test:null),"Fuel required for query"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"flakes"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.flakes;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","flakes","fluree.db.dbfunctions.fns/flakes",2105901429,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"flakes","flakes",-676540030,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",13,1,775,null,775,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the flakes from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.flakes)?fluree.db.dbfunctions.fns.flakes.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"boolean"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.boolean$;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","boolean","fluree.db.dbfunctions.fns/boolean",831125140,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,1,684,null,684,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Coerce to boolean. Everything except false and nil is true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.boolean$)?fluree.db.dbfunctions.fns.boolean$.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"dec"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.dec;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","dec","fluree.db.dbfunctions.fns/dec",2016365502,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"dec","dec",-766002333,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,570,null,570,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),"Decrements any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.dec)?fluree.db.dbfunctions.fns.dec.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"<"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._LT_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","<","fluree.db.dbfunctions.fns/<",-518653073,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"<","<",993667236,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,426,null,426,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically increasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT_)?fluree.db.dbfunctions.fns._LT_.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"floor"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.floor;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","floor","fluree.db.dbfunctions.fns/floor",2077352177,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",12,1,825,null,825,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),"Takes the floor of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.floor)?fluree.db.dbfunctions.fns.floor.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"?o"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_o;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?o","fluree.db.dbfunctions.fns/?o",2112743665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?o","?o",-1814741084,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,1,303,null,303,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the object of an predicate from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_o)?fluree.db.dbfunctions.fns._QMARK_o.cljs$lang$test:null),(1)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"?sid"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_sid;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?sid","fluree.db.dbfunctions.fns/?sid",-1145594406,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?sid","?sid",-778261371,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,171,null,171,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current subject id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_sid)?fluree.db.dbfunctions.fns._QMARK_sid.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"objF"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.objF;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","objF","fluree.db.dbfunctions.fns/objF",1608830606,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"objF","objF",-104129083,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,763,null,763,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the summed object of all false flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objF)?fluree.db.dbfunctions.fns.objF.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"ceil"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.ceil;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","ceil","fluree.db.dbfunctions.fns/ceil",-1898210568,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,813,null,813,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),"Takes the ceiling of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.ceil)?fluree.db.dbfunctions.fns.ceil.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"<="),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._LT__EQ_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","<=","fluree.db.dbfunctions.fns/<=",-535009166,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"<=","<=",1244895369,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,439,null,439,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT__EQ_)?fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"*"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._STAR_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","*","fluree.db.dbfunctions.fns/*",1333037714,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"*","*",345799209,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,619,null,619,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns product of all the numbers in the sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns._STAR_)?fluree.db.dbfunctions.fns._STAR_.cljs$lang$test:null),"9 + count of numbers in *"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"min"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.min;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","min","fluree.db.dbfunctions.fns/min",-1032470830,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"min","min",2085523049,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,491,null,491,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets min value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.min)?fluree.db.dbfunctions.fns.min.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"get"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.get;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","get","fluree.db.dbfunctions.fns/get",1827842903,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"get","get",-971253014,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,272,null,272,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cache","cache",403508473,null),new cljs.core.Symbol(null,"db","db",-1661185010,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null)),"Gets a value from an subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get)?fluree.db.dbfunctions.fns.get.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"?pO"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_pO;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pO","fluree.db.dbfunctions.fns/?pO",-2142759792,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?pO","?pO",1714537515,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,315,null,315,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the most recent object of an predicate, as of the previous block",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pO)?fluree.db.dbfunctions.fns._QMARK_pO.cljs$lang$test:null),"10 plus fuel cost"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"empty?"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.empty_QMARK_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","empty?","fluree.db.dbfunctions.fns/empty?",-487925850,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"empty?","empty?",76408555,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",13,1,111,null,111,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),"True if empty or #{nil}, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.empty_QMARK_)?fluree.db.dbfunctions.fns.empty_QMARK_.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"quot"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.quot;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","quot","fluree.db.dbfunctions.fns/quot",1725032899,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"quot","quot",-1125214196,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,645,null,645,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),"Quot[ient] of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.quot)?fluree.db.dbfunctions.fns.quot.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"now"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.now;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","now","fluree.db.dbfunctions.fns/now",1494134809,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"now","now",-9994004,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,583,null,583,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Returns current epoch milliseconds on the executing machine.",(cljs.core.truth_(fluree.db.dbfunctions.fns.now)?fluree.db.dbfunctions.fns.now.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"not="),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.not_EQ_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","not=","fluree.db.dbfunctions.fns/not=",-1186054057,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"not=","not=",1466536204,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,465,null,465,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if two (or more) values are not equal.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not_EQ_)?fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"if-else"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.if_else;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","if-else","fluree.db.dbfunctions.fns/if-else",-1024242186,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"if-else","if-else",-1675068243,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,1,75,null,75,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null)),"Evaluates test.",(cljs.core.truth_(fluree.db.dbfunctions.fns.if_else)?fluree.db.dbfunctions.fns.if_else.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"rand"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.rand;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","rand","fluree.db.dbfunctions.fns/rand",805823682,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,787,null,787,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.rand)?fluree.db.dbfunctions.fns.rand.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,">"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._GT_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns",">","fluree.db.dbfunctions.fns/>",-23637352,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,">",">",1085014381,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,413,null,413,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT_)?fluree.db.dbfunctions.fns._GT_.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"mod"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.mod;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","mod","fluree.db.dbfunctions.fns/mod",-198597254,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"mod","mod",1510044207,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,658,null,658,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),"Modulus of num and div. Truncates toward negative infinity.",(cljs.core.truth_(fluree.db.dbfunctions.fns.mod)?fluree.db.dbfunctions.fns.mod.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"lower-case"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.lower_case;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","lower-case","fluree.db.dbfunctions.fns/lower-case",-442259,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"lower-case","lower-case",1428172944,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",17,1,147,null,147,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),"Makes string lower case",(cljs.core.truth_(fluree.db.dbfunctions.fns.lower_case)?fluree.db.dbfunctions.fns.lower_case.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"-"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","-","fluree.db.dbfunctions.fns/-",-1982229401,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"-","-",-471816912,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,606,null,606,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns difference of all the numbers in the sequence with the first number as the minuend.",(cljs.core.truth_(fluree.db.dbfunctions.fns._)?fluree.db.dbfunctions.fns._.cljs$lang$test:null),"9 + count of numbers in -"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"hash-set"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.hash_set;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","hash-set","fluree.db.dbfunctions.fns/hash-set",-1047040869,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"hash-set","hash-set",-1145168432,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,386,null,386,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns a hash-set of values",(cljs.core.truth_(fluree.db.dbfunctions.fns.hash_set)?fluree.db.dbfunctions.fns.hash_set.cljs$lang$test:null),"9 + count of items in hash-set"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"or"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.or;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","or","fluree.db.dbfunctions.fns/or",-919667013,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"or","or",1876275696,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,245,null,245,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if any in the sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.or)?fluree.db.dbfunctions.fns.or.cljs$lang$test:null),"Count of objects in or"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"valid-email?"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.valid_email_QMARK_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","valid-email?","fluree.db.dbfunctions.fns/valid-email?",110711142,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"valid-email?","valid-email?",-1587437519,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",19,1,709,null,709,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null)),"Determines whether an email is valid, based on its pattern",(cljs.core.truth_(fluree.db.dbfunctions.fns.valid_email_QMARK_)?fluree.db.dbfunctions.fns.valid_email_QMARK_.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"?s"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_s;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?s","fluree.db.dbfunctions.fns/?s",-1324621735,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?s","?s",456183954,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,203,null,203,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_s)?fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"rem"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.rem;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","rem","fluree.db.dbfunctions.fns/rem",1237147007,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"rem","rem",664046770,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,671,null,671,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),"Remainder of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.rem)?fluree.db.dbfunctions.fns.rem.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"nth"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.nth;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","nth","fluree.db.dbfunctions.fns/nth",-246664273,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"nth","nth",1529209554,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,60,null,60,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),"Returns the nth item in a collection",(cljs.core.truth_(fluree.db.dbfunctions.fns.nth)?fluree.db.dbfunctions.fns.nth.cljs$lang$test:null),"9 + count of objects in collection"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"nil?"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.nil_QMARK_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","nil?","fluree.db.dbfunctions.fns/nil?",-1144188177,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,88,null,88,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),"True if nil, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.nil_QMARK_)?fluree.db.dbfunctions.fns.nil_QMARK_.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"cas"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.cas;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","cas","fluree.db.dbfunctions.fns/cas",-1666886306,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"cas","cas",1188988307,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,837,null,837,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null)),"Does a compare and set/swap operation as a transaction function.",(cljs.core.truth_(fluree.db.dbfunctions.fns.cas)?fluree.db.dbfunctions.fns.cas.cljs$lang$test:null),(20)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"re-find"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.re_find;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","re-find","fluree.db.dbfunctions.fns/re-find",-1361091826,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"re-find","re-find",1143444147,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,1,696,null,696,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null)),"Execute a re-find operation of regex pattern on provided string.",(cljs.core.truth_(fluree.db.dbfunctions.fns.re_find)?fluree.db.dbfunctions.fns.re_find.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"not"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.not;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","not","fluree.db.dbfunctions.fns/not",-1684442274,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"not","not",1044554643,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,100,null,100,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),"Takes a boolean, true returns false, false returns true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not)?fluree.db.dbfunctions.fns.not.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"/"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._SLASH_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","/","fluree.db.dbfunctions.fns//",1439768862,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"/","/",-1371932971,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,632,null,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",(cljs.core.truth_(fluree.db.dbfunctions.fns._SLASH_)?fluree.db.dbfunctions.fns._SLASH_.cljs$lang$test:null),"9 + count of numbers in /"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,">="),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._GT__EQ_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns",">=","fluree.db.dbfunctions.fns/>=",-1771718525,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,">=",">=",1016916022,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,452,null,452,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT__EQ_)?fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"upper-case"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.upper_case;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","upper-case","fluree.db.dbfunctions.fns/upper-case",-210929244,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"upper-case","upper-case",1427515769,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",17,1,159,null,159,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),"Makes string upper-case",(cljs.core.truth_(fluree.db.dbfunctions.fns.upper_case)?fluree.db.dbfunctions.fns.upper_case.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"inc"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.inc;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","inc","fluree.db.dbfunctions.fns/inc",1299152788,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"inc","inc",324505433,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,1,558,null,558,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),"Increments any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.inc)?fluree.db.dbfunctions.fns.inc.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"+"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._PLUS_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","+","fluree.db.dbfunctions.fns/+",1979608855,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"+","+",-740910886,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,593,null,593,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns sum of each argument.",(cljs.core.truth_(fluree.db.dbfunctions.fns._PLUS_)?fluree.db.dbfunctions.fns._PLUS_.cljs$lang$test:null),"9 + count of numbers in +"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"str"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.str;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","str","fluree.db.dbfunctions.fns/str",215086055,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,123,null,123,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Concatenates all in sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.str)?fluree.db.dbfunctions.fns.str.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"objT"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.objT;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","objT","fluree.db.dbfunctions.fns/objT",308919174,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"objT","objT",1212205659,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,751,null,751,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets the summed object of all true flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objT)?fluree.db.dbfunctions.fns.objT.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"max"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.max;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","max","fluree.db.dbfunctions.fns/max",-821447668,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"max","max",1701898075,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,478,null,478,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets max value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max)?fluree.db.dbfunctions.fns.max.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"=="),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._EQ__EQ_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","==","fluree.db.dbfunctions.fns/==",1478685734,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"==","==",-234118149,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,400,null,400,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"count"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.count;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","count","fluree.db.dbfunctions.fns/count",1267596361,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"count","count",-514511684,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",12,1,258,null,258,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps",(cljs.core.truth_(fluree.db.dbfunctions.fns.count)?fluree.db.dbfunctions.fns.count.cljs$lang$test:null),"9 + count of objects in count"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"get-all"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.get_all;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-all","fluree.db.dbfunctions.fns/get-all",1682787369,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"get-all","get-all",-567116420,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,1,328,null,328,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),"Used to get-all values in a nested result set, or also can follow a subject down the provided path and return a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path + query costs"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"?p"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_p;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?p","fluree.db.dbfunctions.fns/?p",1090611913,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?p","?p",-10896580,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),1,216,null,216,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current predicate predicates",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_p)?fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"?auth_id"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_auth_id;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?auth_id","fluree.db.dbfunctions.fns/?auth_id",-1900200218,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?auth_id","?auth_id",612691741,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",15,1,739,null,739,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current auth _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_auth_id)?fluree.db.dbfunctions.fns._QMARK_auth_id.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"extract"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.extract;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","extract","fluree.db.dbfunctions.fns/extract",-1458126328,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"macro","macro",-867863404),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"extract","extract",399446909,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",18,1,14,true,14,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null)),"Resolves a value if a channel.\n  Must be used inside of a go-block.",(cljs.core.truth_(fluree.db.dbfunctions.fns.extract)?fluree.db.dbfunctions.fns.extract.cljs$lang$test:null)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"?user_id"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_user_id;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?user_id","fluree.db.dbfunctions.fns/?user_id",599092011,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?user_id","?user_id",-101968770,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",15,1,721,null,721,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current user _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_user_id)?fluree.db.dbfunctions.fns._QMARK_user_id.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"relationship?"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.relationship_QMARK_;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","relationship?","fluree.db.dbfunctions.fns/relationship?",-46706197,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"relationship?","relationship?",1461608766,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",20,1,531,null,531,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null)),"Determines whether there is a relationship between two subjects",(cljs.core.truth_(fluree.db.dbfunctions.fns.relationship_QMARK_)?fluree.db.dbfunctions.fns.relationship_QMARK_.cljs$lang$test:null),"10, plus fuel cost"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"and"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.and;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","and","fluree.db.dbfunctions.fns/and",2113043921,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"and","and",668631710,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),1,232,null,232,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if all in a sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.and)?fluree.db.dbfunctions.fns.and.cljs$lang$test:null),"Count of objects in and"]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"?pid"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns._QMARK_pid;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pid","fluree.db.dbfunctions.fns/?pid",-1962601142,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,1,190,null,190,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),"Gets current predicate id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pid)?fluree.db.dbfunctions.fns._QMARK_pid.cljs$lang$test:null),(10)]))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,"get-in"),new cljs.core.Var(function(){return fluree.db.dbfunctions.fns.get_in;},new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-in","fluree.db.dbfunctions.fns/get-in",821000586,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",13,1,349,null,349,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),"Returns the value of a nested structure",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_in)?fluree.db.dbfunctions.fns.get_in.cljs$lang$test:null),"Length of path"]))], null)], true));
var _ = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["Loading ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,ns_public_vars))," local fns"].join('')], null));
var sci_ns = sci.core.create_ns.call(null,new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null));
return cljs.core.reduce.call(null,(function (ns_map,p__63418){
var vec__63419 = p__63418;
var var_name = cljs.core.nth.call(null,vec__63419,(0),null);
var var$ = cljs.core.nth.call(null,vec__63419,(1),null);
var m = cljs.core.meta.call(null,var$);
var no_doc = new cljs.core.Keyword(null,"no-doc","no-doc",1559921891).cljs$core$IFn$_invoke$arity$1(m);
var doc = new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m);
var arglists = new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(no_doc)){
return ns_map;
} else {
return cljs.core.assoc.call(null,ns_map,var_name,sci.core.new_var.call(null,cljs.core.symbol.call(null,var_name),cljs.core.deref.call(null,var$),(function (){var G__63422 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ns","ns",441598760),sci_ns,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m)], null);
var G__63422__$1 = (cljs.core.truth_(new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m))?cljs.core.assoc.call(null,G__63422,new cljs.core.Keyword(null,"macro","macro",-867863404),true):G__63422);
var G__63422__$2 = (cljs.core.truth_(doc)?cljs.core.assoc.call(null,G__63422__$1,new cljs.core.Keyword(null,"doc","doc",1913296891),doc):G__63422__$1);
if(cljs.core.truth_(arglists)){
return cljs.core.assoc.call(null,G__63422__$2,new cljs.core.Keyword(null,"arglists","arglists",1661989754),arglists);
} else {
return G__63422__$2;
}
})()));
}
}),cljs.core.PersistentArrayMap.EMPTY,ns_public_vars);
});
fluree.db.dbfunctions.core.sci_ctx = (new cljs.core.Delay((function (){
var cfg = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),fluree.db.dbfunctions.core.load_local_fns_ns.call(null)], null)], null);
fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["SCI config:",cfg], null));

return sci.core.init.call(null,cfg);
}),null));
fluree.db.dbfunctions.core.parse_string = (function fluree$db$dbfunctions$core$parse_string(s){
return sci.core.parse_string.call(null,cljs.core.deref.call(null,fluree.db.dbfunctions.core.sci_ctx),s);
});
fluree.db.dbfunctions.core.eval_string = (function fluree$db$dbfunctions$core$eval_string(s){
return sci.core.eval_string_STAR_.call(null,cljs.core.deref.call(null,fluree.db.dbfunctions.core.sci_ctx),s);
});
fluree.db.dbfunctions.core.eval_form = (function fluree$db$dbfunctions$core$eval_form(f){
return sci.core.eval_form.call(null,cljs.core.deref.call(null,fluree.db.dbfunctions.core.sci_ctx),f);
});
/**
 * Given a collection of function strings, returns a combined function using
 *   the and function.
 */
fluree.db.dbfunctions.core.combine_fns = (function fluree$db$dbfunctions$core$combine_fns(fn_str_coll){
if((cljs.core.count.call(null,fn_str_coll) > (1))){
return ["(and ",clojure.string.join.call(null," ",fn_str_coll),")"].join('');
} else {
return cljs.core.first.call(null,fn_str_coll);
}
});
/**
 * Tries to resolve a local pre-defined fn with fn-name. Returns a fn-map if
 *   found, nil otherwise.
 */
fluree.db.dbfunctions.core.find_local_fn = (function fluree$db$dbfunctions$core$find_local_fn(fn_name){
fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Looking for local fn:",fn_name], null));

var local_fns_ns = new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null);
var sci_vars = fluree.db.dbfunctions.core.eval_string.call(null,["(ns-publics '",cljs.core.str.cljs$core$IFn$_invoke$arity$1(local_fns_ns),")"].join(''));
fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["SCI vars:",sci_vars], null));

if(cljs.core.truth_(cljs.core.set.call(null,cljs.core.keys.call(null,sci_vars)).call(null,cljs.core.symbol.call(null,fn_name)))){
fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Found local fn:",fn_name], null));

var fn_var = cljs.core.symbol.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(local_fns_ns),cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_name));
var map__63424 = fluree.db.dbfunctions.core.eval_string.call(null,["(meta #'",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_var),")"].join(''));
var map__63424__$1 = cljs.core.__destructure_map.call(null,map__63424);
var sci_fn_meta = map__63424__$1;
var arglists = cljs.core.get.call(null,map__63424__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
var spec = cljs.core.get.call(null,map__63424__$1,new cljs.core.Keyword("fdb","spec","fdb/spec",346638389));
if(cljs.core.truth_(sci_fn_meta)){
fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["SCI fn metadata:",sci_fn_meta], null));

var first_arglist = cljs.core.first.call(null,arglists);
var args_set = cljs.core.set.call(null,first_arglist);
var var_args_QMARK_ = cljs.core.boolean$.call(null,args_set.call(null,new cljs.core.Symbol(null,"&","&",-2144855648,null)));
var arity = ((var_args_QMARK_)?null:cljs.core.set.call(null,cljs.core.map.call(null,(function (p1__63423_SHARP_){
return (cljs.core.count.call(null,p1__63423_SHARP_) - (1));
}),arglists)));
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"f","f",-1597136552),fn_var,new cljs.core.Keyword(null,"params","params",710516235),arglists,new cljs.core.Keyword(null,"arity","arity",-1808556135),arity,new cljs.core.Keyword(null,"var-args?","var-args?",-1630678710),var_args_QMARK_,new cljs.core.Keyword(null,"spec","spec",347520401),spec], null);
} else {
return null;
}
} else {
return null;
}
});
fluree.db.dbfunctions.core.find_db_fn = (function fluree$db$dbfunctions$core$find_db_fn(var_args){
var G__63426 = arguments.length;
switch (G__63426) {
case 2:
return fluree.db.dbfunctions.core.find_db_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.find_db_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.find_db_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,fn_name){
return fluree.db.dbfunctions.core.find_db_fn.call(null,db,fn_name,null);
}));

(fluree.db.dbfunctions.core.find_db_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_name,fn_type){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63517){
var state_val_63518 = (state_63517[(1)]);
if((state_val_63518 === (7))){
var inst_63453 = cljs.core.pr_str.call(null,fn_name);
var inst_63454 = ["Unknown function: ",inst_63453].join('');
var inst_63455 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63456 = [(400),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)];
var inst_63457 = cljs.core.PersistentHashMap.fromArrays(inst_63455,inst_63456);
var inst_63458 = cljs.core.ex_info.call(null,inst_63454,inst_63457);
var inst_63459 = (function(){throw inst_63458})();
var state_63517__$1 = state_63517;
var statearr_63519_63552 = state_63517__$1;
(statearr_63519_63552[(2)] = inst_63459);

(statearr_63519_63552[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63518 === (1))){
var state_63517__$1 = state_63517;
var statearr_63520_63553 = state_63517__$1;
(statearr_63520_63553[(2)] = null);

(statearr_63520_63553[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63518 === (4))){
var inst_63427 = (state_63517[(2)]);
var state_63517__$1 = state_63517;
var statearr_63521_63554 = state_63517__$1;
(statearr_63521_63554[(2)] = inst_63427);

(statearr_63521_63554[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63518 === (15))){
var inst_63479 = (state_63517[(7)]);
var inst_63450 = (state_63517[(8)]);
var inst_63479__$1 = (state_63517[(2)]);
var inst_63480 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63481 = ["Parsed params:",inst_63479__$1];
var inst_63482 = (new cljs.core.PersistentVector(null,2,(5),inst_63480,inst_63481,null));
var inst_63483 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_63482);
var inst_63484 = cljs.core.get.call(null,inst_63450,"_fn/code");
var inst_63485 = fluree.db.dbfunctions.core.parse_string.call(null,inst_63484);
var inst_63486 = fluree.db.dbfunctions.core.validate_form.call(null,db,inst_63485,fn_type,inst_63479__$1);
var state_63517__$1 = (function (){var statearr_63522 = state_63517;
(statearr_63522[(9)] = inst_63483);

(statearr_63522[(7)] = inst_63479__$1);

return statearr_63522;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63517__$1,(16),inst_63486);
} else {
if((state_val_63518 === (13))){
var state_63517__$1 = state_63517;
var statearr_63523_63555 = state_63517__$1;
(statearr_63523_63555[(2)] = null);

(statearr_63523_63555[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63518 === (6))){
var inst_63450 = (state_63517[(8)]);
var inst_63449 = (state_63517[(2)]);
var inst_63450__$1 = fluree.db.util.async.throw_err.call(null,inst_63449);
var inst_63451 = cljs.core.empty_QMARK_.call(null,inst_63450__$1);
var state_63517__$1 = (function (){var statearr_63524 = state_63517;
(statearr_63524[(8)] = inst_63450__$1);

return statearr_63524;
})();
if(inst_63451){
var statearr_63525_63556 = state_63517__$1;
(statearr_63525_63556[(1)] = (7));

} else {
var statearr_63526_63557 = state_63517__$1;
(statearr_63526_63557[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63518 === (3))){
var inst_63515 = (state_63517[(2)]);
var state_63517__$1 = state_63517;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63517__$1,inst_63515);
} else {
if((state_val_63518 === (12))){
var inst_63473 = (state_63517[(10)]);
var inst_63473__$1 = (state_63517[(2)]);
var inst_63474 = (inst_63473__$1 == null);
var state_63517__$1 = (function (){var statearr_63527 = state_63517;
(statearr_63527[(10)] = inst_63473__$1);

return statearr_63527;
})();
if(cljs.core.truth_(inst_63474)){
var statearr_63528_63558 = state_63517__$1;
(statearr_63528_63558[(1)] = (13));

} else {
var statearr_63529_63559 = state_63517__$1;
(statearr_63529_63559[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63518 === (2))){
var _ = (function (){var statearr_63530 = state_63517;
(statearr_63530[(4)] = cljs.core.cons.call(null,(5),(state_63517[(4)])));

return statearr_63530;
})();
var inst_63433 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63434 = ["Looking for custom db fn:",fn_name];
var inst_63435 = (new cljs.core.PersistentVector(null,2,(5),inst_63433,inst_63434,null));
var inst_63436 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_63435);
var inst_63437 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044)];
var inst_63438 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63439 = ["_fn/params","_fn/code","_fn/spec"];
var inst_63440 = (new cljs.core.PersistentVector(null,3,(5),inst_63438,inst_63439,null));
var inst_63441 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63442 = cljs.core.name.call(null,fn_name);
var inst_63443 = ["_fn/name",inst_63442];
var inst_63444 = (new cljs.core.PersistentVector(null,2,(5),inst_63441,inst_63443,null));
var inst_63445 = [inst_63440,inst_63444];
var inst_63446 = cljs.core.PersistentHashMap.fromArrays(inst_63437,inst_63445);
var inst_63447 = fluree.db.dbproto._query.call(null,db,inst_63446);
var state_63517__$1 = (function (){var statearr_63531 = state_63517;
(statearr_63531[(11)] = inst_63436);

return statearr_63531;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63517__$1,(6),inst_63447);
} else {
if((state_val_63518 === (11))){
var inst_63450 = (state_63517[(8)]);
var inst_63471 = cljs.core.get.call(null,inst_63450,"_fn/params");
var state_63517__$1 = state_63517;
var statearr_63533_63560 = state_63517__$1;
(statearr_63533_63560[(2)] = inst_63471);

(statearr_63533_63560[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63518 === (9))){
var inst_63450 = (state_63517[(8)]);
var inst_63462 = (state_63517[(2)]);
var inst_63463 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63464 = ["Custom db fn query results:",inst_63450];
var inst_63465 = (new cljs.core.PersistentVector(null,2,(5),inst_63463,inst_63464,null));
var inst_63466 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_63465);
var inst_63468 = (inst_63450 == null);
var state_63517__$1 = (function (){var statearr_63534 = state_63517;
(statearr_63534[(12)] = inst_63462);

(statearr_63534[(13)] = inst_63466);

return statearr_63534;
})();
if(cljs.core.truth_(inst_63468)){
var statearr_63535_63561 = state_63517__$1;
(statearr_63535_63561[(1)] = (10));

} else {
var statearr_63536_63562 = state_63517__$1;
(statearr_63536_63562[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63518 === (5))){
var _ = (function (){var statearr_63537 = state_63517;
(statearr_63537[(4)] = cljs.core.rest.call(null,(state_63517[(4)])));

return statearr_63537;
})();
var state_63517__$1 = state_63517;
var ex63532 = (state_63517__$1[(2)]);
var statearr_63538_63563 = state_63517__$1;
(statearr_63538_63563[(5)] = ex63532);


if((ex63532 instanceof Error)){
var statearr_63539_63564 = state_63517__$1;
(statearr_63539_63564[(1)] = (4));

(statearr_63539_63564[(5)] = null);

} else {
throw ex63532;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63518 === (14))){
var inst_63473 = (state_63517[(10)]);
var inst_63477 = fluree.db.dbfunctions.core.parse_string.call(null,inst_63473);
var state_63517__$1 = state_63517;
var statearr_63540_63565 = state_63517__$1;
(statearr_63540_63565[(2)] = inst_63477);

(statearr_63540_63565[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63518 === (16))){
var inst_63479 = (state_63517[(7)]);
var inst_63450 = (state_63517[(8)]);
var inst_63488 = (state_63517[(2)]);
var inst_63489 = fluree.db.util.async.throw_err.call(null,inst_63488);
var inst_63490 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63491 = ["Validated code:",inst_63489];
var inst_63492 = (new cljs.core.PersistentVector(null,2,(5),inst_63490,inst_63491,null));
var inst_63493 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_63492);
var inst_63494 = cljs.core.get.call(null,inst_63450,"_fn/spec");
var inst_63495 = cljs.core.PersistentVector.EMPTY;
var inst_63496 = new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null);
var inst_63497 = cljs.core.mapv.call(null,cljs.core.symbol,inst_63479);
var inst_63498 = cljs.core.cons.call(null,inst_63496,inst_63497);
var inst_63499 = cljs.core.into.call(null,inst_63495,inst_63498);
var inst_63500 = ["(fn ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63499)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63489),")"].join('');
var inst_63501 = fluree.db.dbfunctions.core.parse_string.call(null,inst_63500);
var inst_63502 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63503 = cljs.core.pr_str.call(null,inst_63501);
var inst_63504 = ["Found custom db fn:",inst_63503];
var inst_63505 = (new cljs.core.PersistentVector(null,2,(5),inst_63502,inst_63504,null));
var inst_63506 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_63505);
var inst_63507 = [new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"arity","arity",-1808556135),new cljs.core.Keyword(null,"var-args?","var-args?",-1630678710),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"code","code",1586293142)];
var inst_63508 = cljs.core.count.call(null,inst_63479);
var inst_63509 = [inst_63508];
var inst_63510 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_63509);
var inst_63511 = [inst_63501,inst_63479,inst_63510,false,inst_63494,null];
var inst_63512 = cljs.core.PersistentHashMap.fromArrays(inst_63507,inst_63511);
var _ = (function (){var statearr_63541 = state_63517;
(statearr_63541[(4)] = cljs.core.rest.call(null,(state_63517[(4)])));

return statearr_63541;
})();
var state_63517__$1 = (function (){var statearr_63542 = state_63517;
(statearr_63542[(14)] = inst_63493);

(statearr_63542[(15)] = inst_63506);

return statearr_63542;
})();
var statearr_63543_63566 = state_63517__$1;
(statearr_63543_63566[(2)] = inst_63512);

(statearr_63543_63566[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63518 === (10))){
var state_63517__$1 = state_63517;
var statearr_63544_63567 = state_63517__$1;
(statearr_63544_63567[(2)] = null);

(statearr_63544_63567[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63518 === (8))){
var state_63517__$1 = state_63517;
var statearr_63545_63568 = state_63517__$1;
(statearr_63545_63568[(2)] = null);

(statearr_63545_63568[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__2746__auto____0 = (function (){
var statearr_63546 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63546[(0)] = fluree$db$dbfunctions$core$state_machine__2746__auto__);

(statearr_63546[(1)] = (1));

return statearr_63546;
});
var fluree$db$dbfunctions$core$state_machine__2746__auto____1 = (function (state_63517){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63517);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63547){var ex__2749__auto__ = e63547;
var statearr_63548_63569 = state_63517;
(statearr_63548_63569[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63517[(4)]))){
var statearr_63549_63570 = state_63517;
(statearr_63549_63570[(1)] = cljs.core.first.call(null,(state_63517[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63571 = state_63517;
state_63517 = G__63571;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__2746__auto__ = function(state_63517){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__2746__auto____1.call(this,state_63517);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__2746__auto____0;
fluree$db$dbfunctions$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__2746__auto____1;
return fluree$db$dbfunctions$core$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63550 = f__2769__auto__.call(null);
(statearr_63550[(6)] = c__2768__auto__);

return statearr_63550;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.core.find_db_fn.cljs$lang$maxFixedArity = 3);

/**
 * Is the symbol sym valid with the given form type & params?
 */
fluree.db.dbfunctions.core.valid_symbol_QMARK_ = (function fluree$db$dbfunctions$core$valid_symbol_QMARK_(type,params,sym){
var or__5045__auto__ = fluree.db.dbfunctions.core.allowed_symbols.call(null,sym);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = cljs.core.set.call(null,cljs.core.map.call(null,cljs.core.symbol,params)).call(null,sym);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core._EQ_.call(null,type,"functionDec");
}
}
});
/**
 * Resolves local or custom db-stored fn from fn-name string
 */
fluree.db.dbfunctions.core.resolve_fn = (function fluree$db$dbfunctions$core$resolve_fn(db,fn_name,type){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63591){
var state_val_63592 = (state_63591[(1)]);
if((state_val_63592 === (7))){
var inst_63581 = fluree.db.dbfunctions.core.find_db_fn.call(null,db,fn_name,type);
var state_63591__$1 = state_63591;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63591__$1,(9),inst_63581);
} else {
if((state_val_63592 === (1))){
var state_63591__$1 = state_63591;
var statearr_63593_63612 = state_63591__$1;
(statearr_63593_63612[(2)] = null);

(statearr_63593_63612[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63592 === (4))){
var inst_63572 = (state_63591[(2)]);
var state_63591__$1 = state_63591;
var statearr_63594_63613 = state_63591__$1;
(statearr_63594_63613[(2)] = inst_63572);

(statearr_63594_63613[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63592 === (6))){
var inst_63578 = (state_63591[(7)]);
var state_63591__$1 = state_63591;
var statearr_63595_63614 = state_63591__$1;
(statearr_63595_63614[(2)] = inst_63578);

(statearr_63595_63614[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63592 === (3))){
var inst_63589 = (state_63591[(2)]);
var state_63591__$1 = state_63591;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63591__$1,inst_63589);
} else {
if((state_val_63592 === (2))){
var inst_63578 = (state_63591[(7)]);
var _ = (function (){var statearr_63597 = state_63591;
(statearr_63597[(4)] = cljs.core.cons.call(null,(5),(state_63591[(4)])));

return statearr_63597;
})();
var inst_63578__$1 = fluree.db.dbfunctions.core.find_local_fn.call(null,fn_name);
var state_63591__$1 = (function (){var statearr_63598 = state_63591;
(statearr_63598[(7)] = inst_63578__$1);

return statearr_63598;
})();
if(cljs.core.truth_(inst_63578__$1)){
var statearr_63599_63615 = state_63591__$1;
(statearr_63599_63615[(1)] = (6));

} else {
var statearr_63600_63616 = state_63591__$1;
(statearr_63600_63616[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63592 === (9))){
var inst_63583 = (state_63591[(2)]);
var inst_63584 = fluree.db.util.async.throw_err.call(null,inst_63583);
var state_63591__$1 = state_63591;
var statearr_63601_63617 = state_63591__$1;
(statearr_63601_63617[(2)] = inst_63584);

(statearr_63601_63617[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63592 === (5))){
var _ = (function (){var statearr_63602 = state_63591;
(statearr_63602[(4)] = cljs.core.rest.call(null,(state_63591[(4)])));

return statearr_63602;
})();
var state_63591__$1 = state_63591;
var ex63596 = (state_63591__$1[(2)]);
var statearr_63603_63618 = state_63591__$1;
(statearr_63603_63618[(5)] = ex63596);


if((ex63596 instanceof Error)){
var statearr_63604_63619 = state_63591__$1;
(statearr_63604_63619[(1)] = (4));

(statearr_63604_63619[(5)] = null);

} else {
throw ex63596;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63592 === (8))){
var inst_63586 = (state_63591[(2)]);
var _ = (function (){var statearr_63605 = state_63591;
(statearr_63605[(4)] = cljs.core.rest.call(null,(state_63591[(4)])));

return statearr_63605;
})();
var state_63591__$1 = state_63591;
var statearr_63606_63620 = state_63591__$1;
(statearr_63606_63620[(2)] = inst_63586);

(statearr_63606_63620[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2746__auto____0 = (function (){
var statearr_63607 = [null,null,null,null,null,null,null,null];
(statearr_63607[(0)] = fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2746__auto__);

(statearr_63607[(1)] = (1));

return statearr_63607;
});
var fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2746__auto____1 = (function (state_63591){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63591);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63608){var ex__2749__auto__ = e63608;
var statearr_63609_63621 = state_63591;
(statearr_63609_63621[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63591[(4)]))){
var statearr_63610_63622 = state_63591;
(statearr_63610_63622[(1)] = cljs.core.first.call(null,(state_63591[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63623 = state_63591;
state_63591 = G__63623;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2746__auto__ = function(state_63591){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2746__auto____1.call(this,state_63591);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$core$resolve_fn_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63611 = f__2769__auto__.call(null);
(statearr_63611[(6)] = c__2768__auto__);

return statearr_63611;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.dbfunctions.core.validate_form = (function fluree$db$dbfunctions$core$validate_form(var_args){
var G__63626 = arguments.length;
switch (G__63626) {
case 2:
return fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$2 = (function (db,form){
return fluree.db.dbfunctions.core.validate_form.call(null,db,form,null,null);
}));

(fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$3 = (function (db,form,type){
return fluree.db.dbfunctions.core.validate_form.call(null,db,form,type,null);
}));

(fluree.db.dbfunctions.core.validate_form.cljs$core$IFn$_invoke$arity$4 = (function (db,form,type,params){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63761){
var state_val_63762 = (state_63761[(1)]);
if((state_val_63762 === (7))){
var state_63761__$1 = state_63761;
var statearr_63763_63827 = state_63761__$1;
(statearr_63763_63827[(2)] = null);

(statearr_63763_63827[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (20))){
var inst_63738 = (state_63761[(2)]);
var state_63761__$1 = state_63761;
var statearr_63764_63828 = state_63761__$1;
(statearr_63764_63828[(2)] = inst_63738);

(statearr_63764_63828[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (27))){
var inst_63727 = (state_63761[(2)]);
var state_63761__$1 = state_63761;
var statearr_63765_63829 = state_63761__$1;
(statearr_63765_63829[(2)] = inst_63727);

(statearr_63765_63829[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (1))){
var state_63761__$1 = state_63761;
var statearr_63766_63830 = state_63761__$1;
(statearr_63766_63830[(2)] = null);

(statearr_63766_63830[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (24))){
var inst_63697 = (state_63761[(2)]);
var inst_63698 = fluree.db.util.async.throw_err.call(null,inst_63697);
var state_63761__$1 = state_63761;
var statearr_63767_63831 = state_63761__$1;
(statearr_63767_63831[(2)] = inst_63698);

(statearr_63767_63831[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (4))){
var inst_63627 = (state_63761[(2)]);
var state_63761__$1 = state_63761;
var statearr_63768_63832 = state_63761__$1;
(statearr_63768_63832[(2)] = inst_63627);

(statearr_63768_63832[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (15))){
var inst_63653 = (state_63761[(2)]);
var inst_63654 = fluree.db.util.async.throw_err.call(null,inst_63653);
var state_63761__$1 = state_63761;
var statearr_63769_63833 = state_63761__$1;
(statearr_63769_63833[(2)] = inst_63654);

(statearr_63769_63833[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (21))){
var inst_63682 = (state_63761[(7)]);
var inst_63695 = fluree.db.dbfunctions.core.validate_form.call(null,db,inst_63682,type,params);
var state_63761__$1 = state_63761;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63761__$1,(24),inst_63695);
} else {
if((state_val_63762 === (31))){
var inst_63730 = (state_63761[(8)]);
var inst_63683 = (state_63761[(9)]);
var inst_63675 = inst_63683;
var inst_63676 = inst_63730;
var state_63761__$1 = (function (){var statearr_63770 = state_63761;
(statearr_63770[(10)] = inst_63675);

(statearr_63770[(11)] = inst_63676);

return statearr_63770;
})();
var statearr_63771_63834 = state_63761__$1;
(statearr_63771_63834[(2)] = null);

(statearr_63771_63834[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (32))){
var inst_63730 = (state_63761[(8)]);
var state_63761__$1 = state_63761;
var statearr_63772_63835 = state_63761__$1;
(statearr_63772_63835[(2)] = inst_63730);

(statearr_63772_63835[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (33))){
var inst_63736 = (state_63761[(2)]);
var state_63761__$1 = state_63761;
var statearr_63773_63836 = state_63761__$1;
(statearr_63773_63836[(2)] = inst_63736);

(statearr_63773_63836[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (13))){
var state_63761__$1 = state_63761;
var statearr_63774_63837 = state_63761__$1;
(statearr_63774_63837[(2)] = null);

(statearr_63774_63837[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (22))){
var inst_63682 = (state_63761[(7)]);
var inst_63700 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63701 = [cljs.core.string_QMARK_,cljs.core.number_QMARK_,cljs.core.true_QMARK_,cljs.core.false_QMARK_,cljs.core.nil_QMARK_];
var inst_63702 = (new cljs.core.PersistentVector(null,5,(5),inst_63700,inst_63701,null));
var inst_63703 = cljs.core.apply.call(null,cljs.core.some_fn,inst_63702);
var inst_63704 = inst_63703.call(null,inst_63682);
var state_63761__$1 = state_63761;
if(cljs.core.truth_(inst_63704)){
var statearr_63775_63838 = state_63761__$1;
(statearr_63775_63838[(1)] = (25));

} else {
var statearr_63776_63839 = state_63761__$1;
(statearr_63776_63839[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (36))){
var inst_63756 = (state_63761[(2)]);
var _ = (function (){var statearr_63777 = state_63761;
(statearr_63777[(4)] = cljs.core.rest.call(null,(state_63761[(4)])));

return statearr_63777;
})();
var state_63761__$1 = state_63761;
var statearr_63778_63840 = state_63761__$1;
(statearr_63778_63840[(2)] = inst_63756);

(statearr_63778_63840[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (29))){
var inst_63682 = (state_63761[(7)]);
var inst_63715 = cljs.core.pr_str.call(null,inst_63682);
var inst_63716 = type.call(null,inst_63682);
var inst_63717 = cljs.core.pr_str.call(null,form);
var inst_63718 = ["Invalid element (",inst_63715,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63716),") in form: ",inst_63717,"."].join('');
var inst_63719 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63720 = [(400),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)];
var inst_63721 = cljs.core.PersistentHashMap.fromArrays(inst_63719,inst_63720);
var inst_63722 = cljs.core.ex_info.call(null,inst_63718,inst_63721);
var inst_63723 = (function(){throw inst_63722})();
var state_63761__$1 = state_63761;
var statearr_63779_63841 = state_63761__$1;
(statearr_63779_63841[(2)] = inst_63723);

(statearr_63779_63841[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (6))){
var inst_63640 = cljs.core.first.call(null,form);
var state_63761__$1 = state_63761;
var statearr_63780_63842 = state_63761__$1;
(statearr_63780_63842[(2)] = inst_63640);

(statearr_63780_63842[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (28))){
var inst_63682 = (state_63761[(7)]);
var state_63761__$1 = state_63761;
var statearr_63781_63843 = state_63761__$1;
(statearr_63781_63843[(2)] = inst_63682);

(statearr_63781_63843[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (25))){
var inst_63682 = (state_63761[(7)]);
var state_63761__$1 = state_63761;
var statearr_63782_63844 = state_63761__$1;
(statearr_63782_63844[(2)] = inst_63682);

(statearr_63782_63844[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (34))){
var inst_63659 = (state_63761[(12)]);
var inst_63741 = (state_63761[(13)]);
var inst_63743 = new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null);
var inst_63744 = cljs.core.cons.call(null,inst_63743,inst_63741);
var inst_63745 = cljs.core.cons.call(null,inst_63659,inst_63744);
var inst_63746 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63747 = ["Validated fn form:",inst_63745];
var inst_63748 = (new cljs.core.PersistentVector(null,2,(5),inst_63746,inst_63747,null));
var inst_63749 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_63748);
var state_63761__$1 = (function (){var statearr_63783 = state_63761;
(statearr_63783[(14)] = inst_63749);

return statearr_63783;
})();
var statearr_63784_63845 = state_63761__$1;
(statearr_63784_63845[(2)] = inst_63745);

(statearr_63784_63845[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (17))){
var state_63761__$1 = state_63761;
var statearr_63785_63846 = state_63761__$1;
(statearr_63785_63846[(2)] = null);

(statearr_63785_63846[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (3))){
var inst_63759 = (state_63761[(2)]);
var state_63761__$1 = state_63761;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63761__$1,inst_63759);
} else {
if((state_val_63762 === (12))){
var inst_63643 = (state_63761[(15)]);
var inst_63651 = fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_63643,type);
var state_63761__$1 = state_63761;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63761__$1,(15),inst_63651);
} else {
if((state_val_63762 === (2))){
var _ = (function (){var statearr_63786 = state_63761;
(statearr_63786[(4)] = cljs.core.cons.call(null,(5),(state_63761[(4)])));

return statearr_63786;
})();
var inst_63633 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63634 = ["Validating form:",form,"- params:",params];
var inst_63635 = (new cljs.core.PersistentVector(null,4,(5),inst_63633,inst_63634,null));
var inst_63636 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_63635);
var inst_63638 = cljs.core.list_QMARK_.call(null,form);
var state_63761__$1 = (function (){var statearr_63787 = state_63761;
(statearr_63787[(16)] = inst_63636);

return statearr_63787;
})();
if(inst_63638){
var statearr_63788_63847 = state_63761__$1;
(statearr_63788_63847[(1)] = (6));

} else {
var statearr_63789_63848 = state_63761__$1;
(statearr_63789_63848[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (23))){
var inst_63683 = (state_63761[(9)]);
var inst_63676 = (state_63761[(11)]);
var inst_63729 = (state_63761[(2)]);
var inst_63730 = cljs.core.conj.call(null,inst_63676,inst_63729);
var inst_63731 = cljs.core.seq.call(null,inst_63683);
var state_63761__$1 = (function (){var statearr_63790 = state_63761;
(statearr_63790[(8)] = inst_63730);

return statearr_63790;
})();
if(inst_63731){
var statearr_63791_63849 = state_63761__$1;
(statearr_63791_63849[(1)] = (31));

} else {
var statearr_63792_63850 = state_63761__$1;
(statearr_63792_63850[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (35))){
var inst_63751 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63752 = ["Validated non-fn form:",form];
var inst_63753 = (new cljs.core.PersistentVector(null,2,(5),inst_63751,inst_63752,null));
var inst_63754 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_63753);
var state_63761__$1 = (function (){var statearr_63793 = state_63761;
(statearr_63793[(17)] = inst_63754);

return statearr_63793;
})();
var statearr_63794_63851 = state_63761__$1;
(statearr_63794_63851[(2)] = form);

(statearr_63794_63851[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (19))){
var inst_63682 = (state_63761[(7)]);
var inst_63675 = (state_63761[(10)]);
var inst_63681 = cljs.core.seq.call(null,inst_63675);
var inst_63682__$1 = cljs.core.first.call(null,inst_63681);
var inst_63683 = cljs.core.next.call(null,inst_63681);
var inst_63684 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63685 = ["Validating arg:",inst_63682__$1];
var inst_63686 = (new cljs.core.PersistentVector(null,2,(5),inst_63684,inst_63685,null));
var inst_63687 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_63686);
var inst_63689 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63690 = [cljs.core.list_QMARK_,cljs.core.vector_QMARK_];
var inst_63691 = (new cljs.core.PersistentVector(null,2,(5),inst_63689,inst_63690,null));
var inst_63692 = cljs.core.apply.call(null,cljs.core.some_fn,inst_63691);
var inst_63693 = inst_63692.call(null,inst_63682__$1);
var state_63761__$1 = (function (){var statearr_63795 = state_63761;
(statearr_63795[(18)] = inst_63687);

(statearr_63795[(7)] = inst_63682__$1);

(statearr_63795[(9)] = inst_63683);

return statearr_63795;
})();
if(cljs.core.truth_(inst_63693)){
var statearr_63796_63852 = state_63761__$1;
(statearr_63796_63852[(1)] = (21));

} else {
var statearr_63797_63853 = state_63761__$1;
(statearr_63797_63853[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (11))){
var inst_63643 = (state_63761[(15)]);
var inst_63648 = (state_63761[(19)]);
var inst_63648__$1 = (state_63761[(2)]);
var inst_63649 = cljs.core.count.call(null,inst_63648__$1);
var state_63761__$1 = (function (){var statearr_63799 = state_63761;
(statearr_63799[(20)] = inst_63649);

(statearr_63799[(19)] = inst_63648__$1);

return statearr_63799;
})();
if(cljs.core.truth_(inst_63643)){
var statearr_63800_63854 = state_63761__$1;
(statearr_63800_63854[(1)] = (12));

} else {
var statearr_63801_63855 = state_63761__$1;
(statearr_63801_63855[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (9))){
var inst_63645 = cljs.core.rest.call(null,form);
var state_63761__$1 = state_63761;
var statearr_63802_63856 = state_63761__$1;
(statearr_63802_63856[(2)] = inst_63645);

(statearr_63802_63856[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (5))){
var _ = (function (){var statearr_63803 = state_63761;
(statearr_63803[(4)] = cljs.core.rest.call(null,(state_63761[(4)])));

return statearr_63803;
})();
var state_63761__$1 = state_63761;
var ex63798 = (state_63761__$1[(2)]);
var statearr_63804_63857 = state_63761__$1;
(statearr_63804_63857[(5)] = ex63798);


if((ex63798 instanceof Error)){
var statearr_63805_63858 = state_63761__$1;
(statearr_63805_63858[(1)] = (4));

(statearr_63805_63858[(5)] = null);

} else {
throw ex63798;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (14))){
var inst_63657 = (state_63761[(21)]);
var inst_63658 = (state_63761[(22)]);
var inst_63648 = (state_63761[(19)]);
var inst_63657__$1 = (state_63761[(2)]);
var inst_63658__$1 = cljs.core.__destructure_map.call(null,inst_63657__$1);
var inst_63659 = cljs.core.get.call(null,inst_63658__$1,new cljs.core.Keyword(null,"f","f",-1597136552));
var inst_63660 = cljs.core.get.call(null,inst_63658__$1,new cljs.core.Keyword(null,"arity","arity",-1808556135));
var inst_63661 = cljs.core.get.call(null,inst_63658__$1,new cljs.core.Keyword(null,"var-args?","var-args?",-1630678710));
var inst_63662 = cljs.core.seq.call(null,inst_63648);
var state_63761__$1 = (function (){var statearr_63806 = state_63761;
(statearr_63806[(21)] = inst_63657__$1);

(statearr_63806[(12)] = inst_63659);

(statearr_63806[(23)] = inst_63660);

(statearr_63806[(22)] = inst_63658__$1);

(statearr_63806[(24)] = inst_63661);

return statearr_63806;
})();
if(inst_63662){
var statearr_63807_63859 = state_63761__$1;
(statearr_63807_63859[(1)] = (16));

} else {
var statearr_63808_63860 = state_63761__$1;
(statearr_63808_63860[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (26))){
var inst_63672 = (state_63761[(25)]);
var inst_63657 = (state_63761[(21)]);
var inst_63659 = (state_63761[(12)]);
var inst_63673 = (state_63761[(26)]);
var inst_63660 = (state_63761[(23)]);
var inst_63649 = (state_63761[(20)]);
var inst_63682 = (state_63761[(7)]);
var inst_63643 = (state_63761[(15)]);
var inst_63675 = (state_63761[(10)]);
var inst_63658 = (state_63761[(22)]);
var inst_63683 = (state_63761[(9)]);
var inst_63676 = (state_63761[(11)]);
var inst_63648 = (state_63761[(19)]);
var inst_63661 = (state_63761[(24)]);
var inst_63707 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63708 = (function (){var arity = inst_63660;
var args_n = inst_63649;
var fn_map = inst_63657;
var first__63670 = inst_63672;
var args = inst_63648;
var first__63680 = inst_63682;
var r = inst_63683;
var acc = inst_63676;
var expr__63688 = inst_63682;
var var_args_QMARK_ = inst_63661;
var seq__63679 = inst_63683;
var seq__63669 = inst_63673;
var fn_name = inst_63643;
var map__63637 = inst_63658;
var vec__63668 = inst_63648;
var arg = inst_63682;
var vec__63678 = inst_63675;
var G__63667 = inst_63675;
var f = inst_63659;
return (function (p1__63624_SHARP_){
var and__5043__auto__ = (p1__63624_SHARP_ instanceof cljs.core.Symbol);
if(and__5043__auto__){
return fluree.db.dbfunctions.core.valid_symbol_QMARK_.call(null,type,params,p1__63624_SHARP_);
} else {
return and__5043__auto__;
}
});
})();
var inst_63709 = [inst_63708];
var inst_63710 = (new cljs.core.PersistentVector(null,1,(5),inst_63707,inst_63709,null));
var inst_63711 = cljs.core.apply.call(null,cljs.core.some_fn,inst_63710);
var inst_63712 = inst_63711.call(null,inst_63682);
var state_63761__$1 = state_63761;
if(cljs.core.truth_(inst_63712)){
var statearr_63809_63861 = state_63761__$1;
(statearr_63809_63861[(1)] = (28));

} else {
var statearr_63810_63862 = state_63761__$1;
(statearr_63810_63862[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (16))){
var inst_63648 = (state_63761[(19)]);
var inst_63671 = cljs.core.seq.call(null,inst_63648);
var inst_63672 = cljs.core.first.call(null,inst_63671);
var inst_63673 = cljs.core.next.call(null,inst_63671);
var inst_63674 = cljs.core.PersistentVector.EMPTY;
var inst_63675 = inst_63648;
var inst_63676 = inst_63674;
var state_63761__$1 = (function (){var statearr_63811 = state_63761;
(statearr_63811[(25)] = inst_63672);

(statearr_63811[(26)] = inst_63673);

(statearr_63811[(10)] = inst_63675);

(statearr_63811[(11)] = inst_63676);

return statearr_63811;
})();
var statearr_63812_63863 = state_63761__$1;
(statearr_63812_63863[(2)] = null);

(statearr_63812_63863[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (30))){
var inst_63725 = (state_63761[(2)]);
var state_63761__$1 = state_63761;
var statearr_63813_63864 = state_63761__$1;
(statearr_63813_63864[(2)] = inst_63725);

(statearr_63813_63864[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (10))){
var state_63761__$1 = state_63761;
var statearr_63814_63865 = state_63761__$1;
(statearr_63814_63865[(2)] = form);

(statearr_63814_63865[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (18))){
var inst_63643 = (state_63761[(15)]);
var inst_63741 = (state_63761[(2)]);
var state_63761__$1 = (function (){var statearr_63815 = state_63761;
(statearr_63815[(13)] = inst_63741);

return statearr_63815;
})();
if(cljs.core.truth_(inst_63643)){
var statearr_63816_63866 = state_63761__$1;
(statearr_63816_63866[(1)] = (34));

} else {
var statearr_63817_63867 = state_63761__$1;
(statearr_63817_63867[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (8))){
var inst_63643 = (state_63761[(15)]);
var inst_63643__$1 = (state_63761[(2)]);
var state_63761__$1 = (function (){var statearr_63818 = state_63761;
(statearr_63818[(15)] = inst_63643__$1);

return statearr_63818;
})();
if(cljs.core.truth_(inst_63643__$1)){
var statearr_63819_63868 = state_63761__$1;
(statearr_63819_63868[(1)] = (9));

} else {
var statearr_63820_63869 = state_63761__$1;
(statearr_63820_63869[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__2746__auto____0 = (function (){
var statearr_63821 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63821[(0)] = fluree$db$dbfunctions$core$state_machine__2746__auto__);

(statearr_63821[(1)] = (1));

return statearr_63821;
});
var fluree$db$dbfunctions$core$state_machine__2746__auto____1 = (function (state_63761){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63761);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63822){var ex__2749__auto__ = e63822;
var statearr_63823_63870 = state_63761;
(statearr_63823_63870[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63761[(4)]))){
var statearr_63824_63871 = state_63761;
(statearr_63824_63871[(1)] = cljs.core.first.call(null,(state_63761[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63872 = state_63761;
state_63761 = G__63872;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__2746__auto__ = function(state_63761){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__2746__auto____1.call(this,state_63761);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__2746__auto____0;
fluree$db$dbfunctions$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__2746__auto____1;
return fluree$db$dbfunctions$core$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63825 = f__2769__auto__.call(null);
(statearr_63825[(6)] = c__2768__auto__);

return statearr_63825;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.core.validate_form.cljs$lang$maxFixedArity = 4);

fluree.db.dbfunctions.core.parse_fn = (function fluree$db$dbfunctions$core$parse_fn(db,fn_str,type,params){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63908){
var state_val_63909 = (state_63908[(1)]);
if((state_val_63909 === (7))){
var inst_63879 = ["(fn [_] ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_str),")"].join('');
var inst_63880 = fluree.db.dbfunctions.core.parse_string.call(null,inst_63879);
var state_63908__$1 = state_63908;
var statearr_63910_63934 = state_63908__$1;
(statearr_63910_63934[(2)] = inst_63880);

(statearr_63910_63934[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63909 === (1))){
var state_63908__$1 = state_63908;
var statearr_63911_63935 = state_63908__$1;
(statearr_63911_63935[(2)] = null);

(statearr_63911_63935[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63909 === (4))){
var inst_63873 = (state_63908[(2)]);
var state_63908__$1 = state_63908;
var statearr_63912_63936 = state_63908__$1;
(statearr_63912_63936[(2)] = inst_63873);

(statearr_63912_63936[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63909 === (6))){
var inst_63903 = (state_63908[(2)]);
var _ = (function (){var statearr_63913 = state_63908;
(statearr_63913[(4)] = cljs.core.rest.call(null,(state_63908[(4)])));

return statearr_63913;
})();
var state_63908__$1 = state_63908;
var statearr_63914_63937 = state_63908__$1;
(statearr_63914_63937[(2)] = inst_63903);

(statearr_63914_63937[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63909 === (3))){
var inst_63906 = (state_63908[(2)]);
var state_63908__$1 = state_63908;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63908__$1,inst_63906);
} else {
if((state_val_63909 === (12))){
var inst_63887 = (state_63908[(2)]);
var inst_63888 = fluree.db.util.async.throw_err.call(null,inst_63887);
var inst_63889 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63890 = ["Parsed & validated db fn:",inst_63888];
var inst_63891 = (new cljs.core.PersistentVector(null,2,(5),inst_63889,inst_63890,null));
var inst_63892 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_63891);
var state_63908__$1 = (function (){var statearr_63915 = state_63908;
(statearr_63915[(7)] = inst_63892);

return statearr_63915;
})();
var statearr_63916_63938 = state_63908__$1;
(statearr_63916_63938[(2)] = inst_63888);

(statearr_63916_63938[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63909 === (2))){
var _ = (function (){var statearr_63917 = state_63908;
(statearr_63917[(4)] = cljs.core.cons.call(null,(5),(state_63908[(4)])));

return statearr_63917;
})();
var state_63908__$1 = state_63908;
var G__63918_63939 = fn_str;
switch (G__63918_63939) {
case "true":
case "false":
var statearr_63919_63941 = state_63908__$1;
(statearr_63919_63941[(1)] = (7));


break;
default:
var statearr_63920_63942 = state_63908__$1;
(statearr_63920_63942[(1)] = (8));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63909 === (11))){
var inst_63900 = (state_63908[(2)]);
var state_63908__$1 = state_63908;
var statearr_63922_63943 = state_63908__$1;
(statearr_63922_63943[(2)] = inst_63900);

(statearr_63922_63943[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63909 === (9))){
var inst_63884 = fluree.db.dbfunctions.core.parse_string.call(null,fn_str);
var inst_63885 = fluree.db.dbfunctions.core.validate_form.call(null,db,inst_63884,type,params);
var state_63908__$1 = state_63908;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63908__$1,(12),inst_63885);
} else {
if((state_val_63909 === (5))){
var _ = (function (){var statearr_63923 = state_63908;
(statearr_63923[(4)] = cljs.core.rest.call(null,(state_63908[(4)])));

return statearr_63923;
})();
var state_63908__$1 = state_63908;
var ex63921 = (state_63908__$1[(2)]);
var statearr_63924_63944 = state_63908__$1;
(statearr_63924_63944[(5)] = ex63921);


if((ex63921 instanceof Error)){
var statearr_63925_63945 = state_63908__$1;
(statearr_63925_63945[(1)] = (4));

(statearr_63925_63945[(5)] = null);

} else {
throw ex63921;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63909 === (10))){
var inst_63894 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63895 = [(400),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)];
var inst_63896 = cljs.core.PersistentHashMap.fromArrays(inst_63894,inst_63895);
var inst_63897 = cljs.core.ex_info.call(null,"Bad function",inst_63896);
var inst_63898 = (function(){throw inst_63897})();
var state_63908__$1 = state_63908;
var statearr_63926_63946 = state_63908__$1;
(statearr_63926_63946[(2)] = inst_63898);

(statearr_63926_63946[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63909 === (8))){
var inst_63882 = cljs.core.re_matches.call(null,/^\(.+\)$/,fn_str);
var state_63908__$1 = state_63908;
if(cljs.core.truth_(inst_63882)){
var statearr_63927_63947 = state_63908__$1;
(statearr_63927_63947[(1)] = (9));

} else {
var statearr_63928_63948 = state_63908__$1;
(statearr_63928_63948[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$parse_fn_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$core$parse_fn_$_state_machine__2746__auto____0 = (function (){
var statearr_63929 = [null,null,null,null,null,null,null,null];
(statearr_63929[(0)] = fluree$db$dbfunctions$core$parse_fn_$_state_machine__2746__auto__);

(statearr_63929[(1)] = (1));

return statearr_63929;
});
var fluree$db$dbfunctions$core$parse_fn_$_state_machine__2746__auto____1 = (function (state_63908){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63908);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63930){var ex__2749__auto__ = e63930;
var statearr_63931_63949 = state_63908;
(statearr_63931_63949[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63908[(4)]))){
var statearr_63932_63950 = state_63908;
(statearr_63932_63950[(1)] = cljs.core.first.call(null,(state_63908[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63951 = state_63908;
state_63908 = G__63951;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$parse_fn_$_state_machine__2746__auto__ = function(state_63908){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$parse_fn_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$parse_fn_$_state_machine__2746__auto____1.call(this,state_63908);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$parse_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$parse_fn_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$core$parse_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$parse_fn_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$core$parse_fn_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63933 = f__2769__auto__.call(null);
(statearr_63933[(6)] = c__2768__auto__);

return statearr_63933;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.dbfunctions.core.parse_and_wrap_fn = (function fluree$db$dbfunctions$core$parse_and_wrap_fn(var_args){
var G__63953 = arguments.length;
switch (G__63953) {
case 3:
return fluree.db.dbfunctions.core.parse_and_wrap_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_and_wrap_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_and_wrap_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_str,type){
return fluree.db.dbfunctions.core.parse_and_wrap_fn.call(null,db,fn_str,type,null);
}));

(fluree.db.dbfunctions.core.parse_and_wrap_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,fn_str,type,params){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63996){
var state_val_63997 = (state_63996[(1)]);
if((state_val_63997 === (7))){
var inst_63979 = cljs.core._EQ_.call(null,type,"functionDec");
var state_63996__$1 = state_63996;
var statearr_63998_64022 = state_63996__$1;
(statearr_63998_64022[(2)] = inst_63979);

(statearr_63998_64022[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63997 === (1))){
var state_63996__$1 = state_63996;
var statearr_63999_64023 = state_63996__$1;
(statearr_63999_64023[(2)] = null);

(statearr_63999_64023[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63997 === (4))){
var inst_63954 = (state_63996[(2)]);
var state_63996__$1 = state_63996;
var statearr_64000_64024 = state_63996__$1;
(statearr_64000_64024[(2)] = inst_63954);

(statearr_64000_64024[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63997 === (6))){
var inst_63977 = (state_63996[(7)]);
var inst_63962 = (state_63996[(2)]);
var inst_63963 = fluree.db.util.async.throw_err.call(null,inst_63962);
var inst_63964 = new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null);
var inst_63965 = (new cljs.core.List(null,inst_63964,null,(1),null));
var inst_63966 = new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null);
var inst_63967 = (new cljs.core.List(null,inst_63966,null,(1),null));
var inst_63968 = cljs.core.concat.call(null,inst_63967);
var inst_63969 = cljs.core.seq.call(null,inst_63968);
var inst_63970 = cljs.core.sequence.call(null,inst_63969);
var inst_63971 = cljs.core.vec.call(null,inst_63970);
var inst_63972 = (new cljs.core.List(null,inst_63971,null,(1),null));
var inst_63973 = (new cljs.core.List(null,inst_63963,null,(1),null));
var inst_63974 = cljs.core.concat.call(null,inst_63965,inst_63972,inst_63973);
var inst_63975 = cljs.core.seq.call(null,inst_63974);
var inst_63976 = cljs.core.sequence.call(null,inst_63975);
var inst_63977__$1 = params;
var state_63996__$1 = (function (){var statearr_64001 = state_63996;
(statearr_64001[(7)] = inst_63977__$1);

(statearr_64001[(8)] = inst_63976);

return statearr_64001;
})();
if(cljs.core.truth_(inst_63977__$1)){
var statearr_64002_64025 = state_63996__$1;
(statearr_64002_64025[(1)] = (7));

} else {
var statearr_64003_64026 = state_63996__$1;
(statearr_64003_64026[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63997 === (3))){
var inst_63994 = (state_63996[(2)]);
var state_63996__$1 = state_63996;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63996__$1,inst_63994);
} else {
if((state_val_63997 === (12))){
var inst_63987 = (state_63996[(2)]);
var inst_63988 = [new cljs.core.Keyword(null,"fnstr","fnstr",2092773532)];
var inst_63989 = [fn_str];
var inst_63990 = cljs.core.PersistentHashMap.fromArrays(inst_63988,inst_63989);
var inst_63991 = cljs.core.with_meta.call(null,inst_63987,inst_63990);
var _ = (function (){var statearr_64004 = state_63996;
(statearr_64004[(4)] = cljs.core.rest.call(null,(state_63996[(4)])));

return statearr_64004;
})();
var state_63996__$1 = state_63996;
var statearr_64005_64027 = state_63996__$1;
(statearr_64005_64027[(2)] = inst_63991);

(statearr_64005_64027[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63997 === (2))){
var _ = (function (){var statearr_64006 = state_63996;
(statearr_64006[(4)] = cljs.core.cons.call(null,(5),(state_63996[(4)])));

return statearr_64006;
})();
var inst_63960 = fluree.db.dbfunctions.core.parse_fn.call(null,db,fn_str,type,params);
var state_63996__$1 = state_63996;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63996__$1,(6),inst_63960);
} else {
if((state_val_63997 === (11))){
var inst_63976 = (state_63996[(8)]);
var inst_63985 = fluree.db.dbfunctions.core.eval_form.call(null,inst_63976);
var state_63996__$1 = state_63996;
var statearr_64008_64028 = state_63996__$1;
(statearr_64008_64028[(2)] = inst_63985);

(statearr_64008_64028[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63997 === (9))){
var inst_63982 = (state_63996[(2)]);
var state_63996__$1 = state_63996;
if(cljs.core.truth_(inst_63982)){
var statearr_64009_64029 = state_63996__$1;
(statearr_64009_64029[(1)] = (10));

} else {
var statearr_64010_64030 = state_63996__$1;
(statearr_64010_64030[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63997 === (5))){
var _ = (function (){var statearr_64011 = state_63996;
(statearr_64011[(4)] = cljs.core.rest.call(null,(state_63996[(4)])));

return statearr_64011;
})();
var state_63996__$1 = state_63996;
var ex64007 = (state_63996__$1[(2)]);
var statearr_64012_64031 = state_63996__$1;
(statearr_64012_64031[(5)] = ex64007);


if((ex64007 instanceof Error)){
var statearr_64013_64032 = state_63996__$1;
(statearr_64013_64032[(1)] = (4));

(statearr_64013_64032[(5)] = null);

} else {
throw ex64007;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63997 === (10))){
var inst_63976 = (state_63996[(8)]);
var state_63996__$1 = state_63996;
var statearr_64014_64033 = state_63996__$1;
(statearr_64014_64033[(2)] = inst_63976);

(statearr_64014_64033[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63997 === (8))){
var inst_63977 = (state_63996[(7)]);
var state_63996__$1 = state_63996;
var statearr_64015_64034 = state_63996__$1;
(statearr_64015_64034[(2)] = inst_63977);

(statearr_64015_64034[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__2746__auto____0 = (function (){
var statearr_64016 = [null,null,null,null,null,null,null,null,null];
(statearr_64016[(0)] = fluree$db$dbfunctions$core$state_machine__2746__auto__);

(statearr_64016[(1)] = (1));

return statearr_64016;
});
var fluree$db$dbfunctions$core$state_machine__2746__auto____1 = (function (state_63996){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63996);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e64017){var ex__2749__auto__ = e64017;
var statearr_64018_64035 = state_63996;
(statearr_64018_64035[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63996[(4)]))){
var statearr_64019_64036 = state_63996;
(statearr_64019_64036[(1)] = cljs.core.first.call(null,(state_63996[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64037 = state_63996;
state_63996 = G__64037;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__2746__auto__ = function(state_63996){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__2746__auto____1.call(this,state_63996);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__2746__auto____0;
fluree$db$dbfunctions$core$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__2746__auto____1;
return fluree$db$dbfunctions$core$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_64020 = f__2769__auto__.call(null);
(statearr_64020[(6)] = c__2768__auto__);

return statearr_64020;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.core.parse_and_wrap_fn.cljs$lang$maxFixedArity = 4);

/**
 * Executes a transaction function
 */
fluree.db.dbfunctions.core.execute_tx_fn = (function fluree$db$dbfunctions$core$execute_tx_fn(p__64038){
var map__64039 = p__64038;
var map__64039__$1 = cljs.core.__destructure_map.call(null,map__64039);
var db = cljs.core.get.call(null,map__64039__$1,new cljs.core.Keyword(null,"db","db",993250759));
var auth = cljs.core.get.call(null,map__64039__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var _credits = cljs.core.get.call(null,map__64039__$1,new cljs.core.Keyword(null,"_credits","_credits",1245712171));
var s = cljs.core.get.call(null,map__64039__$1,new cljs.core.Keyword(null,"s","s",1705939918));
var p = cljs.core.get.call(null,map__64039__$1,new cljs.core.Keyword(null,"p","p",151049309));
var o = cljs.core.get.call(null,map__64039__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var fuel = cljs.core.get.call(null,map__64039__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485));
var block_instant = cljs.core.get.call(null,map__64039__$1,new cljs.core.Keyword(null,"block-instant","block-instant",-641639021));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_64073){
var state_val_64074 = (state_64073[(1)]);
if((state_val_64074 === (7))){
var inst_64060 = (state_64073[(7)]);
var state_64073__$1 = state_64073;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64073__$1,(10),inst_64060);
} else {
if((state_val_64074 === (1))){
var state_64073__$1 = state_64073;
var statearr_64075_64095 = state_64073__$1;
(statearr_64075_64095[(2)] = null);

(statearr_64075_64095[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64074 === (4))){
var inst_64040 = (state_64073[(2)]);
var state_64073__$1 = state_64073;
var statearr_64076_64096 = state_64073__$1;
(statearr_64076_64096[(2)] = inst_64040);

(statearr_64076_64096[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64074 === (6))){
var inst_64060 = (state_64073[(7)]);
var inst_64049 = (state_64073[(8)]);
var inst_64052 = (state_64073[(2)]);
var inst_64053 = fluree.db.util.async.throw_err.call(null,inst_64052);
var inst_64054 = (new cljs.core.List(null,inst_64049,null,(1),null));
var inst_64055 = (new cljs.core.List(null,inst_64053,inst_64054,(2),null));
var inst_64056 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64057 = ["Evaluating fn call:",inst_64055];
var inst_64058 = (new cljs.core.PersistentVector(null,2,(5),inst_64056,inst_64057,null));
var inst_64059 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),inst_64058);
var inst_64060__$1 = fluree.db.dbfunctions.core.eval_form.call(null,inst_64055);
var inst_64061 = fluree.db.util.async.channel_QMARK_.call(null,inst_64060__$1);
var state_64073__$1 = (function (){var statearr_64077 = state_64073;
(statearr_64077[(9)] = inst_64059);

(statearr_64077[(7)] = inst_64060__$1);

return statearr_64077;
})();
if(inst_64061){
var statearr_64078_64097 = state_64073__$1;
(statearr_64078_64097[(1)] = (7));

} else {
var statearr_64079_64098 = state_64073__$1;
(statearr_64079_64098[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64074 === (3))){
var inst_64071 = (state_64073[(2)]);
var state_64073__$1 = state_64073;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64073__$1,inst_64071);
} else {
if((state_val_64074 === (2))){
var _ = (function (){var statearr_64081 = state_64073;
(statearr_64081[(4)] = cljs.core.cons.call(null,(5),(state_64073[(4)])));

return statearr_64081;
})();
var inst_64046 = cljs.core.subs.call(null,o,(1));
var inst_64047 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"pid","pid",1018387698),new cljs.core.Keyword(null,"auth_id","auth_id",1917762333),new cljs.core.Keyword(null,"state","state",-1988618099)];
var inst_64048 = [db,block_instant,s,p,auth,fuel];
var inst_64049 = cljs.core.PersistentHashMap.fromArrays(inst_64047,inst_64048);
var inst_64050 = fluree.db.dbfunctions.core.parse_and_wrap_fn.call(null,db,inst_64046,"txn");
var state_64073__$1 = (function (){var statearr_64082 = state_64073;
(statearr_64082[(8)] = inst_64049);

return statearr_64082;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64073__$1,(6),inst_64050);
} else {
if((state_val_64074 === (9))){
var inst_64068 = (state_64073[(2)]);
var _ = (function (){var statearr_64083 = state_64073;
(statearr_64083[(4)] = cljs.core.rest.call(null,(state_64073[(4)])));

return statearr_64083;
})();
var state_64073__$1 = state_64073;
var statearr_64084_64099 = state_64073__$1;
(statearr_64084_64099[(2)] = inst_64068);

(statearr_64084_64099[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64074 === (5))){
var _ = (function (){var statearr_64085 = state_64073;
(statearr_64085[(4)] = cljs.core.rest.call(null,(state_64073[(4)])));

return statearr_64085;
})();
var state_64073__$1 = state_64073;
var ex64080 = (state_64073__$1[(2)]);
var statearr_64086_64100 = state_64073__$1;
(statearr_64086_64100[(5)] = ex64080);


if((ex64080 instanceof Error)){
var statearr_64087_64101 = state_64073__$1;
(statearr_64087_64101[(1)] = (4));

(statearr_64087_64101[(5)] = null);

} else {
throw ex64080;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64074 === (10))){
var inst_64064 = (state_64073[(2)]);
var inst_64065 = fluree.db.util.async.throw_err.call(null,inst_64064);
var state_64073__$1 = state_64073;
var statearr_64088_64102 = state_64073__$1;
(statearr_64088_64102[(2)] = inst_64065);

(statearr_64088_64102[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64074 === (8))){
var inst_64060 = (state_64073[(7)]);
var state_64073__$1 = state_64073;
var statearr_64089_64103 = state_64073__$1;
(statearr_64089_64103[(2)] = inst_64060);

(statearr_64089_64103[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto____0 = (function (){
var statearr_64090 = [null,null,null,null,null,null,null,null,null,null];
(statearr_64090[(0)] = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto__);

(statearr_64090[(1)] = (1));

return statearr_64090;
});
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto____1 = (function (state_64073){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_64073);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e64091){var ex__2749__auto__ = e64091;
var statearr_64092_64104 = state_64073;
(statearr_64092_64104[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_64073[(4)]))){
var statearr_64093_64105 = state_64073;
(statearr_64093_64105[(1)] = cljs.core.first.call(null,(state_64073[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64106 = state_64073;
state_64073 = G__64106;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto__ = function(state_64073){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto____1.call(this,state_64073);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_64094 = f__2769__auto__.call(null);
(statearr_64094[(6)] = c__2768__auto__);

return statearr_64094;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
