// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__5824__auto___54201 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null)))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54252){
var state_val_54253 = (state_54252[(1)]);
if((state_val_54253 === (7))){
var inst_54247 = (state_54252[(2)]);
var _ = (function (){var statearr_54254 = state_54252;
(statearr_54254[(4)] = cljs.core.rest.call(null,(state_54252[(4)])));

return statearr_54254;
})();
var state_54252__$1 = state_54252;
var statearr_54255_54282 = state_54252__$1;
(statearr_54255_54282[(2)] = inst_54247);

(statearr_54255_54282[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54253 === (1))){
var state_54252__$1 = state_54252;
var statearr_54256_54283 = state_54252__$1;
(statearr_54256_54283[(2)] = null);

(statearr_54256_54283[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54253 === (4))){
var inst_54202 = (state_54252[(2)]);
var state_54252__$1 = state_54252;
var statearr_54257_54284 = state_54252__$1;
(statearr_54257_54284[(2)] = inst_54202);

(statearr_54257_54284[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54253 === (13))){
var inst_54243 = (state_54252[(2)]);
var state_54252__$1 = state_54252;
var statearr_54258_54285 = state_54252__$1;
(statearr_54258_54285[(2)] = inst_54243);

(statearr_54258_54285[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54253 === (6))){
var inst_54220 = (state_54252[(7)]);
var inst_54227 = (state_54252[(8)]);
var inst_54226 = cljs.core.seq.call(null,inst_54220);
var inst_54227__$1 = cljs.core.first.call(null,inst_54226);
var inst_54228 = cljs.core.next.call(null,inst_54226);
var inst_54229 = cljs.core.not.call(null,inst_54227__$1);
var state_54252__$1 = (function (){var statearr_54259 = state_54252;
(statearr_54259[(9)] = inst_54228);

(statearr_54259[(8)] = inst_54227__$1);

return statearr_54259;
})();
if(inst_54229){
var statearr_54260_54286 = state_54252__$1;
(statearr_54260_54286[(1)] = (8));

} else {
var statearr_54261_54287 = state_54252__$1;
(statearr_54261_54287[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54253 === (3))){
var inst_54250 = (state_54252[(2)]);
var state_54252__$1 = state_54252;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54252__$1,inst_54250);
} else {
if((state_val_54253 === (12))){
var inst_54228 = (state_54252[(9)]);
var inst_54221 = (state_54252[(10)]);
var inst_54227 = (state_54252[(8)]);
var inst_54240 = cljs.core.conj.call(null,inst_54221,inst_54227);
var inst_54220 = inst_54228;
var inst_54221__$1 = inst_54240;
var state_54252__$1 = (function (){var statearr_54262 = state_54252;
(statearr_54262[(7)] = inst_54220);

(statearr_54262[(10)] = inst_54221__$1);

return statearr_54262;
})();
var statearr_54263_54288 = state_54252__$1;
(statearr_54263_54288[(2)] = null);

(statearr_54263_54288[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54253 === (2))){
var _ = (function (){var statearr_54264 = state_54252;
(statearr_54264[(4)] = cljs.core.cons.call(null,(5),(state_54252[(4)])));

return statearr_54264;
})();
var inst_54215 = args;
var inst_54216 = cljs.core.seq.call(null,inst_54215);
var inst_54217 = cljs.core.first.call(null,inst_54216);
var inst_54218 = cljs.core.next.call(null,inst_54216);
var inst_54219 = cljs.core.PersistentVector.EMPTY;
var inst_54220 = inst_54215;
var inst_54221 = inst_54219;
var state_54252__$1 = (function (){var statearr_54265 = state_54252;
(statearr_54265[(7)] = inst_54220);

(statearr_54265[(11)] = inst_54218);

(statearr_54265[(12)] = inst_54217);

(statearr_54265[(10)] = inst_54221);

return statearr_54265;
})();
var statearr_54266_54289 = state_54252__$1;
(statearr_54266_54289[(2)] = null);

(statearr_54266_54289[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54253 === (11))){
var inst_54227 = (state_54252[(8)]);
var state_54252__$1 = state_54252;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54252__$1,(14),inst_54227);
} else {
if((state_val_54253 === (9))){
var inst_54227 = (state_54252[(8)]);
var inst_54232 = fluree.db.util.async.channel_QMARK_.call(null,inst_54227);
var state_54252__$1 = state_54252;
if(inst_54232){
var statearr_54268_54290 = state_54252__$1;
(statearr_54268_54290[(1)] = (11));

} else {
var statearr_54269_54291 = state_54252__$1;
(statearr_54269_54291[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54253 === (5))){
var _ = (function (){var statearr_54270 = state_54252;
(statearr_54270[(4)] = cljs.core.rest.call(null,(state_54252[(4)])));

return statearr_54270;
})();
var state_54252__$1 = state_54252;
var ex54267 = (state_54252__$1[(2)]);
var statearr_54271_54292 = state_54252__$1;
(statearr_54271_54292[(5)] = ex54267);


if((ex54267 instanceof Error)){
var statearr_54272_54293 = state_54252__$1;
(statearr_54272_54293[(1)] = (4));

(statearr_54272_54293[(5)] = null);

} else {
throw ex54267;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54253 === (14))){
var inst_54228 = (state_54252[(9)]);
var inst_54221 = (state_54252[(10)]);
var inst_54235 = (state_54252[(2)]);
var inst_54236 = fluree.db.util.async.throw_err.call(null,inst_54235);
var inst_54237 = cljs.core.conj.call(null,inst_54221,inst_54236);
var inst_54220 = inst_54228;
var inst_54221__$1 = inst_54237;
var state_54252__$1 = (function (){var statearr_54273 = state_54252;
(statearr_54273[(7)] = inst_54220);

(statearr_54273[(10)] = inst_54221__$1);

return statearr_54273;
})();
var statearr_54274_54294 = state_54252__$1;
(statearr_54274_54294[(2)] = null);

(statearr_54274_54294[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54253 === (10))){
var inst_54245 = (state_54252[(2)]);
var state_54252__$1 = state_54252;
var statearr_54275_54295 = state_54252__$1;
(statearr_54275_54295[(2)] = inst_54245);

(statearr_54275_54295[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54253 === (8))){
var inst_54221 = (state_54252[(10)]);
var state_54252__$1 = state_54252;
var statearr_54276_54296 = state_54252__$1;
(statearr_54276_54296[(2)] = inst_54221);

(statearr_54276_54296[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____0 = (function (){
var statearr_54277 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54277[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__);

(statearr_54277[(1)] = (1));

return statearr_54277;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____1 = (function (state_54252){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54252);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54278){var ex__2749__auto__ = e54278;
var statearr_54279_54297 = state_54252;
(statearr_54279_54297[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54252[(4)]))){
var statearr_54280_54298 = state_54252;
(statearr_54280_54298[(1)] = cljs.core.first.call(null,(state_54252[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54299 = state_54252;
state_54252 = G__54299;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__ = function(state_54252){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____1.call(this,state_54252);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54281 = f__2769__auto__.call(null);
(statearr_54281[(6)] = c__2768__auto__);

return statearr_54281;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__54301 = entry;
var res = cljs.core.nth.call(null,vec__54301,(0),null);
var cost = cljs.core.nth.call(null,vec__54301,(1),null);
fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Smart function stack:",res], null));

return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (p1__54300_SHARP_){
return cljs.core.update.call(null,cljs.core.update.call(null,cljs.core.update.call(null,p1__54300_SHARP_,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj,entry),new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._,cost),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_,cost);
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.call(null,msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack.call(null,_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54349){
var state_val_54350 = (state_54349[(1)]);
if((state_val_54350 === (7))){
var state_54349__$1 = state_54349;
var statearr_54351_54380 = state_54349__$1;
(statearr_54351_54380[(2)] = coll);

(statearr_54351_54380[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54350 === (1))){
var state_54349__$1 = state_54349;
var statearr_54352_54381 = state_54349__$1;
(statearr_54352_54381[(2)] = null);

(statearr_54352_54381[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54350 === (4))){
var inst_54304 = (state_54349[(2)]);
var state_54349__$1 = state_54349;
var statearr_54353_54382 = state_54349__$1;
(statearr_54353_54382[(2)] = inst_54304);

(statearr_54353_54382[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54350 === (15))){
var inst_54323 = (state_54349[(7)]);
var inst_54331 = (state_54349[(2)]);
var inst_54332 = fluree.db.dbfunctions.internal.nth.call(null,inst_54323,inst_54331);
var inst_54333 = cljs.core.count.call(null,inst_54323);
var inst_54334 = ((9) + inst_54333);
var inst_54335 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54336 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54337 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54338 = [inst_54323,inst_54331];
var inst_54339 = (new cljs.core.PersistentVector(null,2,(5),inst_54337,inst_54338,null));
var inst_54340 = ["nth",inst_54339,inst_54332];
var inst_54341 = cljs.core.PersistentHashMap.fromArrays(inst_54336,inst_54340);
var inst_54342 = [inst_54341,inst_54334];
var inst_54343 = (new cljs.core.PersistentVector(null,2,(5),inst_54335,inst_54342,null));
var inst_54344 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54343);
var _ = (function (){var statearr_54354 = state_54349;
(statearr_54354[(4)] = cljs.core.rest.call(null,(state_54349[(4)])));

return statearr_54354;
})();
var state_54349__$1 = (function (){var statearr_54355 = state_54349;
(statearr_54355[(8)] = inst_54344);

return statearr_54355;
})();
var statearr_54356_54383 = state_54349__$1;
(statearr_54356_54383[(2)] = inst_54332);

(statearr_54356_54383[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54350 === (13))){
var state_54349__$1 = state_54349;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54349__$1,(16),key);
} else {
if((state_val_54350 === (6))){
var state_54349__$1 = state_54349;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54349__$1,(9),coll);
} else {
if((state_val_54350 === (3))){
var inst_54347 = (state_54349[(2)]);
var state_54349__$1 = state_54349;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54349__$1,inst_54347);
} else {
if((state_val_54350 === (12))){
var inst_54323 = (state_54349[(2)]);
var inst_54324 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_54349__$1 = (function (){var statearr_54357 = state_54349;
(statearr_54357[(7)] = inst_54323);

return statearr_54357;
})();
if(inst_54324){
var statearr_54358_54384 = state_54349__$1;
(statearr_54358_54384[(1)] = (13));

} else {
var statearr_54359_54385 = state_54349__$1;
(statearr_54359_54385[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54350 === (2))){
var _ = (function (){var statearr_54360 = state_54349;
(statearr_54360[(4)] = cljs.core.cons.call(null,(5),(state_54349[(4)])));

return statearr_54360;
})();
var inst_54310 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_54349__$1 = state_54349;
if(inst_54310){
var statearr_54361_54386 = state_54349__$1;
(statearr_54361_54386[(1)] = (6));

} else {
var statearr_54362_54387 = state_54349__$1;
(statearr_54362_54387[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54350 === (11))){
var inst_54317 = (state_54349[(9)]);
var state_54349__$1 = state_54349;
var statearr_54364_54388 = state_54349__$1;
(statearr_54364_54388[(2)] = inst_54317);

(statearr_54364_54388[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54350 === (9))){
var inst_54313 = (state_54349[(2)]);
var inst_54314 = fluree.db.util.async.throw_err.call(null,inst_54313);
var state_54349__$1 = state_54349;
var statearr_54365_54389 = state_54349__$1;
(statearr_54365_54389[(2)] = inst_54314);

(statearr_54365_54389[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54350 === (5))){
var _ = (function (){var statearr_54366 = state_54349;
(statearr_54366[(4)] = cljs.core.rest.call(null,(state_54349[(4)])));

return statearr_54366;
})();
var state_54349__$1 = state_54349;
var ex54363 = (state_54349__$1[(2)]);
var statearr_54367_54390 = state_54349__$1;
(statearr_54367_54390[(5)] = ex54363);


if((ex54363 instanceof Error)){
var statearr_54368_54391 = state_54349__$1;
(statearr_54368_54391[(1)] = (4));

(statearr_54368_54391[(5)] = null);

} else {
throw ex54363;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54350 === (14))){
var state_54349__$1 = state_54349;
var statearr_54369_54392 = state_54349__$1;
(statearr_54369_54392[(2)] = key);

(statearr_54369_54392[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54350 === (16))){
var inst_54327 = (state_54349[(2)]);
var inst_54328 = fluree.db.util.async.throw_err.call(null,inst_54327);
var state_54349__$1 = state_54349;
var statearr_54370_54393 = state_54349__$1;
(statearr_54370_54393[(2)] = inst_54328);

(statearr_54370_54393[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54350 === (10))){
var inst_54317 = (state_54349[(9)]);
var inst_54320 = cljs.core.vec.call(null,inst_54317);
var state_54349__$1 = state_54349;
var statearr_54371_54394 = state_54349__$1;
(statearr_54371_54394[(2)] = inst_54320);

(statearr_54371_54394[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54350 === (8))){
var inst_54317 = (state_54349[(9)]);
var inst_54317__$1 = (state_54349[(2)]);
var inst_54318 = cljs.core.set_QMARK_.call(null,inst_54317__$1);
var state_54349__$1 = (function (){var statearr_54372 = state_54349;
(statearr_54372[(9)] = inst_54317__$1);

return statearr_54372;
})();
if(inst_54318){
var statearr_54373_54395 = state_54349__$1;
(statearr_54373_54395[(1)] = (10));

} else {
var statearr_54374_54396 = state_54349__$1;
(statearr_54374_54396[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____0 = (function (){
var statearr_54375 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54375[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__);

(statearr_54375[(1)] = (1));

return statearr_54375;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____1 = (function (state_54349){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54349);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54376){var ex__2749__auto__ = e54376;
var statearr_54377_54397 = state_54349;
(statearr_54377_54397[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54349[(4)]))){
var statearr_54378_54398 = state_54349;
(statearr_54378_54398[(1)] = cljs.core.first.call(null,(state_54349[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54399 = state_54349;
state_54349 = G__54399;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__ = function(state_54349){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____1.call(this,state_54349);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54379 = f__2769__auto__.call(null);
(statearr_54379[(6)] = c__2768__auto__);

return statearr_54379;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54460){
var state_val_54461 = (state_54460[(1)]);
if((state_val_54461 === (7))){
var state_54460__$1 = state_54460;
var statearr_54462_54496 = state_54460__$1;
(statearr_54462_54496[(2)] = test);

(statearr_54462_54496[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54461 === (20))){
var inst_54434 = (state_54460[(2)]);
var inst_54435 = fluree.db.util.async.throw_err.call(null,inst_54434);
var state_54460__$1 = state_54460;
var statearr_54463_54497 = state_54460__$1;
(statearr_54463_54497[(2)] = inst_54435);

(statearr_54463_54497[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54461 === (1))){
var state_54460__$1 = state_54460;
var statearr_54464_54498 = state_54460__$1;
(statearr_54464_54498[(2)] = null);

(statearr_54464_54498[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54461 === (4))){
var inst_54400 = (state_54460[(2)]);
var state_54460__$1 = state_54460;
var statearr_54465_54499 = state_54460__$1;
(statearr_54465_54499[(2)] = inst_54400);

(statearr_54465_54499[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54461 === (15))){
var inst_54418 = (state_54460[(7)]);
var inst_54426 = (state_54460[(2)]);
var inst_54427 = [inst_54426,f];
var inst_54428 = (new cljs.core.PersistentVector(null,2,(5),inst_54418,inst_54427,null));
var state_54460__$1 = state_54460;
var statearr_54466_54500 = state_54460__$1;
(statearr_54466_54500[(2)] = inst_54428);

(statearr_54466_54500[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54461 === (13))){
var state_54460__$1 = state_54460;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54460__$1,(16),t);
} else {
if((state_val_54461 === (6))){
var state_54460__$1 = state_54460;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54460__$1,(9),test);
} else {
if((state_val_54461 === (17))){
var state_54460__$1 = state_54460;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54460__$1,(20),f);
} else {
if((state_val_54461 === (3))){
var inst_54458 = (state_54460[(2)]);
var state_54460__$1 = state_54460;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54460__$1,inst_54458);
} else {
if((state_val_54461 === (12))){
var inst_54416 = (state_54460[(8)]);
var inst_54442 = (state_54460[(2)]);
var inst_54443 = cljs.core.nth.call(null,inst_54442,(0),null);
var inst_54444 = cljs.core.nth.call(null,inst_54442,(1),null);
var inst_54445 = fluree.db.dbfunctions.internal.if_else.call(null,inst_54416,inst_54443,inst_54444);
var inst_54446 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54447 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54448 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54449 = [inst_54416,inst_54443,inst_54444];
var inst_54450 = (new cljs.core.PersistentVector(null,3,(5),inst_54448,inst_54449,null));
var inst_54451 = ["if-else",inst_54450,inst_54445];
var inst_54452 = cljs.core.PersistentHashMap.fromArrays(inst_54447,inst_54451);
var inst_54453 = [inst_54452,(10)];
var inst_54454 = (new cljs.core.PersistentVector(null,2,(5),inst_54446,inst_54453,null));
var inst_54455 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54454);
var _ = (function (){var statearr_54467 = state_54460;
(statearr_54467[(4)] = cljs.core.rest.call(null,(state_54460[(4)])));

return statearr_54467;
})();
var state_54460__$1 = (function (){var statearr_54468 = state_54460;
(statearr_54468[(9)] = inst_54455);

return statearr_54468;
})();
var statearr_54469_54501 = state_54460__$1;
(statearr_54469_54501[(2)] = inst_54445);

(statearr_54469_54501[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54461 === (2))){
var _ = (function (){var statearr_54470 = state_54460;
(statearr_54470[(4)] = cljs.core.cons.call(null,(5),(state_54460[(4)])));

return statearr_54470;
})();
var inst_54409 = fluree.db.util.async.channel_QMARK_.call(null,test);
var state_54460__$1 = state_54460;
if(inst_54409){
var statearr_54471_54502 = state_54460__$1;
(statearr_54471_54502[(1)] = (6));

} else {
var statearr_54472_54503 = state_54460__$1;
(statearr_54472_54503[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54461 === (19))){
var inst_54430 = (state_54460[(10)]);
var inst_54438 = (state_54460[(2)]);
var inst_54439 = [f,inst_54438];
var inst_54440 = (new cljs.core.PersistentVector(null,2,(5),inst_54430,inst_54439,null));
var state_54460__$1 = state_54460;
var statearr_54473_54504 = state_54460__$1;
(statearr_54473_54504[(2)] = inst_54440);

(statearr_54473_54504[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54461 === (11))){
var inst_54430 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54431 = fluree.db.util.async.channel_QMARK_.call(null,f);
var state_54460__$1 = (function (){var statearr_54475 = state_54460;
(statearr_54475[(10)] = inst_54430);

return statearr_54475;
})();
if(inst_54431){
var statearr_54476_54505 = state_54460__$1;
(statearr_54476_54505[(1)] = (17));

} else {
var statearr_54477_54506 = state_54460__$1;
(statearr_54477_54506[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54461 === (9))){
var inst_54412 = (state_54460[(2)]);
var inst_54413 = fluree.db.util.async.throw_err.call(null,inst_54412);
var state_54460__$1 = state_54460;
var statearr_54478_54507 = state_54460__$1;
(statearr_54478_54507[(2)] = inst_54413);

(statearr_54478_54507[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54461 === (5))){
var _ = (function (){var statearr_54479 = state_54460;
(statearr_54479[(4)] = cljs.core.rest.call(null,(state_54460[(4)])));

return statearr_54479;
})();
var state_54460__$1 = state_54460;
var ex54474 = (state_54460__$1[(2)]);
var statearr_54480_54508 = state_54460__$1;
(statearr_54480_54508[(5)] = ex54474);


if((ex54474 instanceof Error)){
var statearr_54481_54509 = state_54460__$1;
(statearr_54481_54509[(1)] = (4));

(statearr_54481_54509[(5)] = null);

} else {
throw ex54474;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54461 === (14))){
var state_54460__$1 = state_54460;
var statearr_54482_54510 = state_54460__$1;
(statearr_54482_54510[(2)] = t);

(statearr_54482_54510[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54461 === (16))){
var inst_54422 = (state_54460[(2)]);
var inst_54423 = fluree.db.util.async.throw_err.call(null,inst_54422);
var state_54460__$1 = state_54460;
var statearr_54483_54511 = state_54460__$1;
(statearr_54483_54511[(2)] = inst_54423);

(statearr_54483_54511[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54461 === (10))){
var inst_54418 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54419 = fluree.db.util.async.channel_QMARK_.call(null,t);
var state_54460__$1 = (function (){var statearr_54484 = state_54460;
(statearr_54484[(7)] = inst_54418);

return statearr_54484;
})();
if(inst_54419){
var statearr_54485_54512 = state_54460__$1;
(statearr_54485_54512[(1)] = (13));

} else {
var statearr_54486_54513 = state_54460__$1;
(statearr_54486_54513[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54461 === (18))){
var state_54460__$1 = state_54460;
var statearr_54487_54514 = state_54460__$1;
(statearr_54487_54514[(2)] = f);

(statearr_54487_54514[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54461 === (8))){
var inst_54416 = (state_54460[(8)]);
var inst_54416__$1 = (state_54460[(2)]);
var state_54460__$1 = (function (){var statearr_54488 = state_54460;
(statearr_54488[(8)] = inst_54416__$1);

return statearr_54488;
})();
if(cljs.core.truth_(inst_54416__$1)){
var statearr_54489_54515 = state_54460__$1;
(statearr_54489_54515[(1)] = (10));

} else {
var statearr_54490_54516 = state_54460__$1;
(statearr_54490_54516[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____0 = (function (){
var statearr_54491 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_54491[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__);

(statearr_54491[(1)] = (1));

return statearr_54491;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____1 = (function (state_54460){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54460);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54492){var ex__2749__auto__ = e54492;
var statearr_54493_54517 = state_54460;
(statearr_54493_54517[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54460[(4)]))){
var statearr_54494_54518 = state_54460;
(statearr_54494_54518[(1)] = cljs.core.first.call(null,(state_54460[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54519 = state_54460;
state_54460 = G__54519;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__ = function(state_54460){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____1.call(this,state_54460);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54495 = f__2769__auto__.call(null);
(statearr_54495[(6)] = c__2768__auto__);

return statearr_54495;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54549){
var state_val_54550 = (state_54549[(1)]);
if((state_val_54550 === (7))){
var state_54549__$1 = state_54549;
var statearr_54551_54570 = state_54549__$1;
(statearr_54551_54570[(2)] = arg);

(statearr_54551_54570[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54550 === (1))){
var state_54549__$1 = state_54549;
var statearr_54552_54571 = state_54549__$1;
(statearr_54552_54571[(2)] = null);

(statearr_54552_54571[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54550 === (4))){
var inst_54520 = (state_54549[(2)]);
var state_54549__$1 = state_54549;
var statearr_54553_54572 = state_54549__$1;
(statearr_54553_54572[(2)] = inst_54520);

(statearr_54553_54572[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54550 === (6))){
var state_54549__$1 = state_54549;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54549__$1,(9),arg);
} else {
if((state_val_54550 === (3))){
var inst_54547 = (state_54549[(2)]);
var state_54549__$1 = state_54549;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54549__$1,inst_54547);
} else {
if((state_val_54550 === (2))){
var _ = (function (){var statearr_54555 = state_54549;
(statearr_54555[(4)] = cljs.core.cons.call(null,(5),(state_54549[(4)])));

return statearr_54555;
})();
var inst_54526 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_54549__$1 = state_54549;
if(inst_54526){
var statearr_54556_54573 = state_54549__$1;
(statearr_54556_54573[(1)] = (6));

} else {
var statearr_54557_54574 = state_54549__$1;
(statearr_54557_54574[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54550 === (9))){
var inst_54529 = (state_54549[(2)]);
var inst_54530 = fluree.db.util.async.throw_err.call(null,inst_54529);
var state_54549__$1 = state_54549;
var statearr_54558_54575 = state_54549__$1;
(statearr_54558_54575[(2)] = inst_54530);

(statearr_54558_54575[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54550 === (5))){
var _ = (function (){var statearr_54559 = state_54549;
(statearr_54559[(4)] = cljs.core.rest.call(null,(state_54549[(4)])));

return statearr_54559;
})();
var state_54549__$1 = state_54549;
var ex54554 = (state_54549__$1[(2)]);
var statearr_54560_54576 = state_54549__$1;
(statearr_54560_54576[(5)] = ex54554);


if((ex54554 instanceof Error)){
var statearr_54561_54577 = state_54549__$1;
(statearr_54561_54577[(1)] = (4));

(statearr_54561_54577[(5)] = null);

} else {
throw ex54554;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54550 === (8))){
var inst_54533 = (state_54549[(2)]);
var inst_54534 = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,inst_54533);
var inst_54535 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54536 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54537 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54538 = [inst_54533];
var inst_54539 = (new cljs.core.PersistentVector(null,1,(5),inst_54537,inst_54538,null));
var inst_54540 = ["nil?",inst_54539,inst_54534];
var inst_54541 = cljs.core.PersistentHashMap.fromArrays(inst_54536,inst_54540);
var inst_54542 = [inst_54541,(10)];
var inst_54543 = (new cljs.core.PersistentVector(null,2,(5),inst_54535,inst_54542,null));
var inst_54544 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54543);
var _ = (function (){var statearr_54562 = state_54549;
(statearr_54562[(4)] = cljs.core.rest.call(null,(state_54549[(4)])));

return statearr_54562;
})();
var state_54549__$1 = (function (){var statearr_54563 = state_54549;
(statearr_54563[(7)] = inst_54544);

return statearr_54563;
})();
var statearr_54564_54578 = state_54549__$1;
(statearr_54564_54578[(2)] = inst_54534);

(statearr_54564_54578[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_54565 = [null,null,null,null,null,null,null,null];
(statearr_54565[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__);

(statearr_54565[(1)] = (1));

return statearr_54565;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____1 = (function (state_54549){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54549);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54566){var ex__2749__auto__ = e54566;
var statearr_54567_54579 = state_54549;
(statearr_54567_54579[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54549[(4)]))){
var statearr_54568_54580 = state_54549;
(statearr_54568_54580[(1)] = cljs.core.first.call(null,(state_54549[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54581 = state_54549;
state_54549 = G__54581;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__ = function(state_54549){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____1.call(this,state_54549);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54569 = f__2769__auto__.call(null);
(statearr_54569[(6)] = c__2768__auto__);

return statearr_54569;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54611){
var state_val_54612 = (state_54611[(1)]);
if((state_val_54612 === (7))){
var state_54611__$1 = state_54611;
var statearr_54613_54632 = state_54611__$1;
(statearr_54613_54632[(2)] = arg);

(statearr_54613_54632[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54612 === (1))){
var state_54611__$1 = state_54611;
var statearr_54614_54633 = state_54611__$1;
(statearr_54614_54633[(2)] = null);

(statearr_54614_54633[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54612 === (4))){
var inst_54582 = (state_54611[(2)]);
var state_54611__$1 = state_54611;
var statearr_54615_54634 = state_54611__$1;
(statearr_54615_54634[(2)] = inst_54582);

(statearr_54615_54634[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54612 === (6))){
var state_54611__$1 = state_54611;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54611__$1,(9),arg);
} else {
if((state_val_54612 === (3))){
var inst_54609 = (state_54611[(2)]);
var state_54611__$1 = state_54611;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54611__$1,inst_54609);
} else {
if((state_val_54612 === (2))){
var _ = (function (){var statearr_54617 = state_54611;
(statearr_54617[(4)] = cljs.core.cons.call(null,(5),(state_54611[(4)])));

return statearr_54617;
})();
var inst_54588 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_54611__$1 = state_54611;
if(inst_54588){
var statearr_54618_54635 = state_54611__$1;
(statearr_54618_54635[(1)] = (6));

} else {
var statearr_54619_54636 = state_54611__$1;
(statearr_54619_54636[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54612 === (9))){
var inst_54591 = (state_54611[(2)]);
var inst_54592 = fluree.db.util.async.throw_err.call(null,inst_54591);
var state_54611__$1 = state_54611;
var statearr_54620_54637 = state_54611__$1;
(statearr_54620_54637[(2)] = inst_54592);

(statearr_54620_54637[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54612 === (5))){
var _ = (function (){var statearr_54621 = state_54611;
(statearr_54621[(4)] = cljs.core.rest.call(null,(state_54611[(4)])));

return statearr_54621;
})();
var state_54611__$1 = state_54611;
var ex54616 = (state_54611__$1[(2)]);
var statearr_54622_54638 = state_54611__$1;
(statearr_54622_54638[(5)] = ex54616);


if((ex54616 instanceof Error)){
var statearr_54623_54639 = state_54611__$1;
(statearr_54623_54639[(1)] = (4));

(statearr_54623_54639[(5)] = null);

} else {
throw ex54616;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54612 === (8))){
var inst_54595 = (state_54611[(2)]);
var inst_54596 = fluree.db.dbfunctions.internal.not.call(null,inst_54595);
var inst_54597 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54598 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54599 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54600 = [inst_54595];
var inst_54601 = (new cljs.core.PersistentVector(null,1,(5),inst_54599,inst_54600,null));
var inst_54602 = ["not",inst_54601,inst_54596];
var inst_54603 = cljs.core.PersistentHashMap.fromArrays(inst_54598,inst_54602);
var inst_54604 = [inst_54603,(10)];
var inst_54605 = (new cljs.core.PersistentVector(null,2,(5),inst_54597,inst_54604,null));
var inst_54606 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54605);
var _ = (function (){var statearr_54624 = state_54611;
(statearr_54624[(4)] = cljs.core.rest.call(null,(state_54611[(4)])));

return statearr_54624;
})();
var state_54611__$1 = (function (){var statearr_54625 = state_54611;
(statearr_54625[(7)] = inst_54606);

return statearr_54625;
})();
var statearr_54626_54640 = state_54611__$1;
(statearr_54626_54640[(2)] = inst_54596);

(statearr_54626_54640[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____0 = (function (){
var statearr_54627 = [null,null,null,null,null,null,null,null];
(statearr_54627[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__);

(statearr_54627[(1)] = (1));

return statearr_54627;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____1 = (function (state_54611){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54611);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54628){var ex__2749__auto__ = e54628;
var statearr_54629_54641 = state_54611;
(statearr_54629_54641[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54611[(4)]))){
var statearr_54630_54642 = state_54611;
(statearr_54630_54642[(1)] = cljs.core.first.call(null,(state_54611[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54643 = state_54611;
state_54611 = G__54643;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__ = function(state_54611){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____1.call(this,state_54611);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54631 = f__2769__auto__.call(null);
(statearr_54631[(6)] = c__2768__auto__);

return statearr_54631;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54673){
var state_val_54674 = (state_54673[(1)]);
if((state_val_54674 === (7))){
var state_54673__$1 = state_54673;
var statearr_54675_54694 = state_54673__$1;
(statearr_54675_54694[(2)] = arg);

(statearr_54675_54694[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54674 === (1))){
var state_54673__$1 = state_54673;
var statearr_54676_54695 = state_54673__$1;
(statearr_54676_54695[(2)] = null);

(statearr_54676_54695[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54674 === (4))){
var inst_54644 = (state_54673[(2)]);
var state_54673__$1 = state_54673;
var statearr_54677_54696 = state_54673__$1;
(statearr_54677_54696[(2)] = inst_54644);

(statearr_54677_54696[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54674 === (6))){
var state_54673__$1 = state_54673;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54673__$1,(9),arg);
} else {
if((state_val_54674 === (3))){
var inst_54671 = (state_54673[(2)]);
var state_54673__$1 = state_54673;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54673__$1,inst_54671);
} else {
if((state_val_54674 === (2))){
var _ = (function (){var statearr_54679 = state_54673;
(statearr_54679[(4)] = cljs.core.cons.call(null,(5),(state_54673[(4)])));

return statearr_54679;
})();
var inst_54650 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_54673__$1 = state_54673;
if(inst_54650){
var statearr_54680_54697 = state_54673__$1;
(statearr_54680_54697[(1)] = (6));

} else {
var statearr_54681_54698 = state_54673__$1;
(statearr_54681_54698[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54674 === (9))){
var inst_54653 = (state_54673[(2)]);
var inst_54654 = fluree.db.util.async.throw_err.call(null,inst_54653);
var state_54673__$1 = state_54673;
var statearr_54682_54699 = state_54673__$1;
(statearr_54682_54699[(2)] = inst_54654);

(statearr_54682_54699[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54674 === (5))){
var _ = (function (){var statearr_54683 = state_54673;
(statearr_54683[(4)] = cljs.core.rest.call(null,(state_54673[(4)])));

return statearr_54683;
})();
var state_54673__$1 = state_54673;
var ex54678 = (state_54673__$1[(2)]);
var statearr_54684_54700 = state_54673__$1;
(statearr_54684_54700[(5)] = ex54678);


if((ex54678 instanceof Error)){
var statearr_54685_54701 = state_54673__$1;
(statearr_54685_54701[(1)] = (4));

(statearr_54685_54701[(5)] = null);

} else {
throw ex54678;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54674 === (8))){
var inst_54657 = (state_54673[(2)]);
var inst_54658 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_54657);
var inst_54659 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54660 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54661 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54662 = [inst_54657];
var inst_54663 = (new cljs.core.PersistentVector(null,1,(5),inst_54661,inst_54662,null));
var inst_54664 = ["empty?",inst_54663,inst_54658];
var inst_54665 = cljs.core.PersistentHashMap.fromArrays(inst_54660,inst_54664);
var inst_54666 = [inst_54665,(10)];
var inst_54667 = (new cljs.core.PersistentVector(null,2,(5),inst_54659,inst_54666,null));
var inst_54668 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54667);
var _ = (function (){var statearr_54686 = state_54673;
(statearr_54686[(4)] = cljs.core.rest.call(null,(state_54673[(4)])));

return statearr_54686;
})();
var state_54673__$1 = (function (){var statearr_54687 = state_54673;
(statearr_54687[(7)] = inst_54668);

return statearr_54687;
})();
var statearr_54688_54702 = state_54673__$1;
(statearr_54688_54702[(2)] = inst_54658);

(statearr_54688_54702[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_54689 = [null,null,null,null,null,null,null,null];
(statearr_54689[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__);

(statearr_54689[(1)] = (1));

return statearr_54689;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____1 = (function (state_54673){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54673);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54690){var ex__2749__auto__ = e54690;
var statearr_54691_54703 = state_54673;
(statearr_54691_54703[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54673[(4)]))){
var statearr_54692_54704 = state_54673;
(statearr_54692_54704[(1)] = cljs.core.first.call(null,(state_54673[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54705 = state_54673;
state_54673 = G__54705;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__ = function(state_54673){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____1.call(this,state_54673);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54693 = f__2769__auto__.call(null);
(statearr_54693[(6)] = c__2768__auto__);

return statearr_54693;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___54750 = arguments.length;
var i__5770__auto___54751 = (0);
while(true){
if((i__5770__auto___54751 < len__5769__auto___54750)){
args__5775__auto__.push((arguments[i__5770__auto___54751]));

var G__54752 = (i__5770__auto___54751 + (1));
i__5770__auto___54751 = G__54752;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54733){
var state_val_54734 = (state_54733[(1)]);
if((state_val_54734 === (1))){
var state_54733__$1 = state_54733;
var statearr_54735_54753 = state_54733__$1;
(statearr_54735_54753[(2)] = null);

(statearr_54735_54753[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54734 === (2))){
var _ = (function (){var statearr_54736 = state_54733;
(statearr_54736[(4)] = cljs.core.cons.call(null,(5),(state_54733[(4)])));

return statearr_54736;
})();
var inst_54714 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54733__$1 = state_54733;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54733__$1,(6),inst_54714);
} else {
if((state_val_54734 === (3))){
var inst_54731 = (state_54733[(2)]);
var state_54733__$1 = state_54733;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54733__$1,inst_54731);
} else {
if((state_val_54734 === (4))){
var inst_54708 = (state_54733[(2)]);
var state_54733__$1 = state_54733;
var statearr_54738_54754 = state_54733__$1;
(statearr_54738_54754[(2)] = inst_54708);

(statearr_54738_54754[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54734 === (5))){
var _ = (function (){var statearr_54739 = state_54733;
(statearr_54739[(4)] = cljs.core.rest.call(null,(state_54733[(4)])));

return statearr_54739;
})();
var state_54733__$1 = state_54733;
var ex54737 = (state_54733__$1[(2)]);
var statearr_54740_54755 = state_54733__$1;
(statearr_54740_54755[(5)] = ex54737);


if((ex54737 instanceof Error)){
var statearr_54741_54756 = state_54733__$1;
(statearr_54741_54756[(1)] = (4));

(statearr_54741_54756[(5)] = null);

} else {
throw ex54737;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54734 === (6))){
var inst_54716 = (state_54733[(2)]);
var inst_54717 = fluree.db.util.async.throw_err.call(null,inst_54716);
var inst_54718 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.str,inst_54717);
var inst_54719 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54720 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54721 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54722 = [inst_54717];
var inst_54723 = (new cljs.core.PersistentVector(null,1,(5),inst_54721,inst_54722,null));
var inst_54724 = ["str",inst_54723,inst_54718];
var inst_54725 = cljs.core.PersistentHashMap.fromArrays(inst_54720,inst_54724);
var inst_54726 = [inst_54725,(10)];
var inst_54727 = (new cljs.core.PersistentVector(null,2,(5),inst_54719,inst_54726,null));
var inst_54728 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54727);
var _ = (function (){var statearr_54742 = state_54733;
(statearr_54742[(4)] = cljs.core.rest.call(null,(state_54733[(4)])));

return statearr_54742;
})();
var state_54733__$1 = (function (){var statearr_54743 = state_54733;
(statearr_54743[(7)] = inst_54728);

return statearr_54743;
})();
var statearr_54744_54757 = state_54733__$1;
(statearr_54744_54757[(2)] = inst_54718);

(statearr_54744_54757[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_54745 = [null,null,null,null,null,null,null,null];
(statearr_54745[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_54745[(1)] = (1));

return statearr_54745;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_54733){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54733);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54746){var ex__2749__auto__ = e54746;
var statearr_54747_54758 = state_54733;
(statearr_54747_54758[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54733[(4)]))){
var statearr_54748_54759 = state_54733;
(statearr_54748_54759[(1)] = cljs.core.first.call(null,(state_54733[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54760 = state_54733;
state_54733 = G__54760;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_54733){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_54733);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54749 = f__2769__auto__.call(null);
(statearr_54749[(6)] = c__2768__auto__);

return statearr_54749;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq54706){
var G__54707 = cljs.core.first.call(null,seq54706);
var seq54706__$1 = cljs.core.next.call(null,seq54706);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54707,seq54706__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54786){
var state_val_54787 = (state_54786[(1)]);
if((state_val_54787 === (1))){
var state_54786__$1 = state_54786;
var statearr_54788_54803 = state_54786__$1;
(statearr_54788_54803[(2)] = null);

(statearr_54788_54803[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54787 === (2))){
var _ = (function (){var statearr_54789 = state_54786;
(statearr_54789[(4)] = cljs.core.cons.call(null,(5),(state_54786[(4)])));

return statearr_54789;
})();
var inst_54767 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54786__$1 = state_54786;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54786__$1,(6),inst_54767);
} else {
if((state_val_54787 === (3))){
var inst_54784 = (state_54786[(2)]);
var state_54786__$1 = state_54786;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54786__$1,inst_54784);
} else {
if((state_val_54787 === (4))){
var inst_54761 = (state_54786[(2)]);
var state_54786__$1 = state_54786;
var statearr_54791_54804 = state_54786__$1;
(statearr_54791_54804[(2)] = inst_54761);

(statearr_54791_54804[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54787 === (5))){
var _ = (function (){var statearr_54792 = state_54786;
(statearr_54792[(4)] = cljs.core.rest.call(null,(state_54786[(4)])));

return statearr_54792;
})();
var state_54786__$1 = state_54786;
var ex54790 = (state_54786__$1[(2)]);
var statearr_54793_54805 = state_54786__$1;
(statearr_54793_54805[(5)] = ex54790);


if((ex54790 instanceof Error)){
var statearr_54794_54806 = state_54786__$1;
(statearr_54794_54806[(1)] = (4));

(statearr_54794_54806[(5)] = null);

} else {
throw ex54790;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54787 === (6))){
var inst_54769 = (state_54786[(2)]);
var inst_54770 = fluree.db.util.async.throw_err.call(null,inst_54769);
var inst_54771 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.subs,inst_54770);
var inst_54772 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54773 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54774 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54775 = [inst_54770];
var inst_54776 = (new cljs.core.PersistentVector(null,1,(5),inst_54774,inst_54775,null));
var inst_54777 = ["subs",inst_54776,inst_54771];
var inst_54778 = cljs.core.PersistentHashMap.fromArrays(inst_54773,inst_54777);
var inst_54779 = [inst_54778,(30)];
var inst_54780 = (new cljs.core.PersistentVector(null,2,(5),inst_54772,inst_54779,null));
var inst_54781 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54780);
var _ = (function (){var statearr_54795 = state_54786;
(statearr_54795[(4)] = cljs.core.rest.call(null,(state_54786[(4)])));

return statearr_54795;
})();
var state_54786__$1 = (function (){var statearr_54796 = state_54786;
(statearr_54796[(7)] = inst_54781);

return statearr_54796;
})();
var statearr_54797_54807 = state_54786__$1;
(statearr_54797_54807[(2)] = inst_54771);

(statearr_54797_54807[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____0 = (function (){
var statearr_54798 = [null,null,null,null,null,null,null,null];
(statearr_54798[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__);

(statearr_54798[(1)] = (1));

return statearr_54798;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____1 = (function (state_54786){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54786);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54799){var ex__2749__auto__ = e54799;
var statearr_54800_54808 = state_54786;
(statearr_54800_54808[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54786[(4)]))){
var statearr_54801_54809 = state_54786;
(statearr_54801_54809[(1)] = cljs.core.first.call(null,(state_54786[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54810 = state_54786;
state_54786 = G__54810;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__ = function(state_54786){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____1.call(this,state_54786);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54802 = f__2769__auto__.call(null);
(statearr_54802[(6)] = c__2768__auto__);

return statearr_54802;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54840){
var state_val_54841 = (state_54840[(1)]);
if((state_val_54841 === (7))){
var state_54840__$1 = state_54840;
var statearr_54842_54861 = state_54840__$1;
(statearr_54842_54861[(2)] = str);

(statearr_54842_54861[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54841 === (1))){
var state_54840__$1 = state_54840;
var statearr_54843_54862 = state_54840__$1;
(statearr_54843_54862[(2)] = null);

(statearr_54843_54862[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54841 === (4))){
var inst_54811 = (state_54840[(2)]);
var state_54840__$1 = state_54840;
var statearr_54844_54863 = state_54840__$1;
(statearr_54844_54863[(2)] = inst_54811);

(statearr_54844_54863[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54841 === (6))){
var state_54840__$1 = state_54840;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54840__$1,(9),str);
} else {
if((state_val_54841 === (3))){
var inst_54838 = (state_54840[(2)]);
var state_54840__$1 = state_54840;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54840__$1,inst_54838);
} else {
if((state_val_54841 === (2))){
var _ = (function (){var statearr_54846 = state_54840;
(statearr_54846[(4)] = cljs.core.cons.call(null,(5),(state_54840[(4)])));

return statearr_54846;
})();
var inst_54817 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_54840__$1 = state_54840;
if(inst_54817){
var statearr_54847_54864 = state_54840__$1;
(statearr_54847_54864[(1)] = (6));

} else {
var statearr_54848_54865 = state_54840__$1;
(statearr_54848_54865[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54841 === (9))){
var inst_54820 = (state_54840[(2)]);
var inst_54821 = fluree.db.util.async.throw_err.call(null,inst_54820);
var state_54840__$1 = state_54840;
var statearr_54849_54866 = state_54840__$1;
(statearr_54849_54866[(2)] = inst_54821);

(statearr_54849_54866[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54841 === (5))){
var _ = (function (){var statearr_54850 = state_54840;
(statearr_54850[(4)] = cljs.core.rest.call(null,(state_54840[(4)])));

return statearr_54850;
})();
var state_54840__$1 = state_54840;
var ex54845 = (state_54840__$1[(2)]);
var statearr_54851_54867 = state_54840__$1;
(statearr_54851_54867[(5)] = ex54845);


if((ex54845 instanceof Error)){
var statearr_54852_54868 = state_54840__$1;
(statearr_54852_54868[(1)] = (4));

(statearr_54852_54868[(5)] = null);

} else {
throw ex54845;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54841 === (8))){
var inst_54824 = (state_54840[(2)]);
var inst_54825 = fluree.db.dbfunctions.internal.lower_case.call(null,inst_54824);
var inst_54826 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54827 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54828 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54829 = [inst_54824];
var inst_54830 = (new cljs.core.PersistentVector(null,1,(5),inst_54828,inst_54829,null));
var inst_54831 = ["lower-case",inst_54830,inst_54825];
var inst_54832 = cljs.core.PersistentHashMap.fromArrays(inst_54827,inst_54831);
var inst_54833 = [inst_54832,(10)];
var inst_54834 = (new cljs.core.PersistentVector(null,2,(5),inst_54826,inst_54833,null));
var inst_54835 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54834);
var _ = (function (){var statearr_54853 = state_54840;
(statearr_54853[(4)] = cljs.core.rest.call(null,(state_54840[(4)])));

return statearr_54853;
})();
var state_54840__$1 = (function (){var statearr_54854 = state_54840;
(statearr_54854[(7)] = inst_54835);

return statearr_54854;
})();
var statearr_54855_54869 = state_54840__$1;
(statearr_54855_54869[(2)] = inst_54825);

(statearr_54855_54869[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____0 = (function (){
var statearr_54856 = [null,null,null,null,null,null,null,null];
(statearr_54856[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__);

(statearr_54856[(1)] = (1));

return statearr_54856;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____1 = (function (state_54840){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54840);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54857){var ex__2749__auto__ = e54857;
var statearr_54858_54870 = state_54840;
(statearr_54858_54870[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54840[(4)]))){
var statearr_54859_54871 = state_54840;
(statearr_54859_54871[(1)] = cljs.core.first.call(null,(state_54840[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54872 = state_54840;
state_54840 = G__54872;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__ = function(state_54840){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____1.call(this,state_54840);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54860 = f__2769__auto__.call(null);
(statearr_54860[(6)] = c__2768__auto__);

return statearr_54860;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54902){
var state_val_54903 = (state_54902[(1)]);
if((state_val_54903 === (7))){
var state_54902__$1 = state_54902;
var statearr_54904_54923 = state_54902__$1;
(statearr_54904_54923[(2)] = str);

(statearr_54904_54923[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54903 === (1))){
var state_54902__$1 = state_54902;
var statearr_54905_54924 = state_54902__$1;
(statearr_54905_54924[(2)] = null);

(statearr_54905_54924[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54903 === (4))){
var inst_54873 = (state_54902[(2)]);
var state_54902__$1 = state_54902;
var statearr_54906_54925 = state_54902__$1;
(statearr_54906_54925[(2)] = inst_54873);

(statearr_54906_54925[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54903 === (6))){
var state_54902__$1 = state_54902;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54902__$1,(9),str);
} else {
if((state_val_54903 === (3))){
var inst_54900 = (state_54902[(2)]);
var state_54902__$1 = state_54902;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54902__$1,inst_54900);
} else {
if((state_val_54903 === (2))){
var _ = (function (){var statearr_54908 = state_54902;
(statearr_54908[(4)] = cljs.core.cons.call(null,(5),(state_54902[(4)])));

return statearr_54908;
})();
var inst_54879 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_54902__$1 = state_54902;
if(inst_54879){
var statearr_54909_54926 = state_54902__$1;
(statearr_54909_54926[(1)] = (6));

} else {
var statearr_54910_54927 = state_54902__$1;
(statearr_54910_54927[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54903 === (9))){
var inst_54882 = (state_54902[(2)]);
var inst_54883 = fluree.db.util.async.throw_err.call(null,inst_54882);
var state_54902__$1 = state_54902;
var statearr_54911_54928 = state_54902__$1;
(statearr_54911_54928[(2)] = inst_54883);

(statearr_54911_54928[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54903 === (5))){
var _ = (function (){var statearr_54912 = state_54902;
(statearr_54912[(4)] = cljs.core.rest.call(null,(state_54902[(4)])));

return statearr_54912;
})();
var state_54902__$1 = state_54902;
var ex54907 = (state_54902__$1[(2)]);
var statearr_54913_54929 = state_54902__$1;
(statearr_54913_54929[(5)] = ex54907);


if((ex54907 instanceof Error)){
var statearr_54914_54930 = state_54902__$1;
(statearr_54914_54930[(1)] = (4));

(statearr_54914_54930[(5)] = null);

} else {
throw ex54907;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54903 === (8))){
var inst_54886 = (state_54902[(2)]);
var inst_54887 = fluree.db.dbfunctions.internal.upper_case.call(null,inst_54886);
var inst_54888 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54889 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54890 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54891 = [inst_54886];
var inst_54892 = (new cljs.core.PersistentVector(null,1,(5),inst_54890,inst_54891,null));
var inst_54893 = ["upper-case",inst_54892,inst_54887];
var inst_54894 = cljs.core.PersistentHashMap.fromArrays(inst_54889,inst_54893);
var inst_54895 = [inst_54894,(10)];
var inst_54896 = (new cljs.core.PersistentVector(null,2,(5),inst_54888,inst_54895,null));
var inst_54897 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54896);
var _ = (function (){var statearr_54915 = state_54902;
(statearr_54915[(4)] = cljs.core.rest.call(null,(state_54902[(4)])));

return statearr_54915;
})();
var state_54902__$1 = (function (){var statearr_54916 = state_54902;
(statearr_54916[(7)] = inst_54897);

return statearr_54916;
})();
var statearr_54917_54931 = state_54902__$1;
(statearr_54917_54931[(2)] = inst_54887);

(statearr_54917_54931[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____0 = (function (){
var statearr_54918 = [null,null,null,null,null,null,null,null];
(statearr_54918[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__);

(statearr_54918[(1)] = (1));

return statearr_54918;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____1 = (function (state_54902){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54902);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54919){var ex__2749__auto__ = e54919;
var statearr_54920_54932 = state_54902;
(statearr_54920_54932[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54902[(4)]))){
var statearr_54921_54933 = state_54902;
(statearr_54921_54933[(1)] = cljs.core.first.call(null,(state_54902[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54934 = state_54902;
state_54902 = G__54934;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__ = function(state_54902){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____1.call(this,state_54902);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54922 = f__2769__auto__.call(null);
(statearr_54922[(6)] = c__2768__auto__);

return statearr_54922;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__5043__auto__)){
return (!(typeof cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__5043__auto__;
}
})())){
var res = cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__54936 = arguments.length;
switch (G__54936) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54964){
var state_val_54965 = (state_54964[(1)]);
if((state_val_54965 === (1))){
var state_54964__$1 = state_54964;
var statearr_54966_54982 = state_54964__$1;
(statearr_54966_54982[(2)] = null);

(statearr_54966_54982[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54965 === (2))){
var _ = (function (){var statearr_54967 = state_54964;
(statearr_54967[(4)] = cljs.core.cons.call(null,(5),(state_54964[(4)])));

return statearr_54967;
})();
var inst_54946 = fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,additional_select);
var state_54964__$1 = state_54964;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54964__$1,(6),inst_54946);
} else {
if((state_val_54965 === (3))){
var inst_54962 = (state_54964[(2)]);
var state_54964__$1 = state_54964;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54964__$1,inst_54962);
} else {
if((state_val_54965 === (4))){
var inst_54937 = (state_54964[(2)]);
var state_54964__$1 = state_54964;
var statearr_54969_54983 = state_54964__$1;
(statearr_54969_54983[(2)] = inst_54937);

(statearr_54969_54983[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54965 === (5))){
var _ = (function (){var statearr_54970 = state_54964;
(statearr_54970[(4)] = cljs.core.rest.call(null,(state_54964[(4)])));

return statearr_54970;
})();
var state_54964__$1 = state_54964;
var ex54968 = (state_54964__$1[(2)]);
var statearr_54971_54984 = state_54964__$1;
(statearr_54971_54984[(5)] = ex54968);


if((ex54968 instanceof Error)){
var statearr_54972_54985 = state_54964__$1;
(statearr_54972_54985[(1)] = (4));

(statearr_54972_54985[(5)] = null);

} else {
throw ex54968;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54965 === (6))){
var inst_54948 = (state_54964[(2)]);
var inst_54949 = fluree.db.util.async.throw_err.call(null,inst_54948);
var inst_54950 = cljs.core.nth.call(null,inst_54949,(0),null);
var inst_54951 = cljs.core.nth.call(null,inst_54949,(1),null);
var inst_54952 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54953 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54954 = ["?s","?ctx",inst_54950];
var inst_54955 = cljs.core.PersistentHashMap.fromArrays(inst_54953,inst_54954);
var inst_54956 = ((10) + inst_54951);
var inst_54957 = [inst_54955,inst_54956];
var inst_54958 = (new cljs.core.PersistentVector(null,2,(5),inst_54952,inst_54957,null));
var inst_54959 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54958);
var _ = (function (){var statearr_54973 = state_54964;
(statearr_54973[(4)] = cljs.core.rest.call(null,(state_54964[(4)])));

return statearr_54973;
})();
var state_54964__$1 = (function (){var statearr_54974 = state_54964;
(statearr_54974[(7)] = inst_54959);

return statearr_54974;
})();
var statearr_54975_54986 = state_54964__$1;
(statearr_54975_54986[(2)] = inst_54950);

(statearr_54975_54986[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_54976 = [null,null,null,null,null,null,null,null];
(statearr_54976[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_54976[(1)] = (1));

return statearr_54976;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_54964){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54964);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54977){var ex__2749__auto__ = e54977;
var statearr_54978_54987 = state_54964;
(statearr_54978_54987[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54964[(4)]))){
var statearr_54979_54988 = state_54964;
(statearr_54979_54988[(1)] = cljs.core.first.call(null,(state_54964[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54989 = state_54964;
state_54964 = G__54989;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_54964){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_54964);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54980 = f__2769__auto__.call(null);
(statearr_54980[(6)] = c__2768__auto__);

return statearr_54980;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__54991 = arguments.length;
switch (G__54991) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55029){
var state_val_55030 = (state_55029[(1)]);
if((state_val_55030 === (7))){
var inst_55022 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?p from this function interface");
var state_55029__$1 = state_55029;
var statearr_55031_55051 = state_55029__$1;
(statearr_55031_55051[(2)] = inst_55022);

(statearr_55031_55051[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55030 === (1))){
var state_55029__$1 = state_55029;
var statearr_55032_55052 = state_55029__$1;
(statearr_55032_55052[(2)] = null);

(statearr_55032_55052[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55030 === (4))){
var inst_54992 = (state_55029[(2)]);
var state_55029__$1 = state_55029;
var statearr_55033_55053 = state_55029__$1;
(statearr_55033_55053[(2)] = inst_54992);

(statearr_55033_55053[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55030 === (6))){
var inst_55003 = fluree.db.dbfunctions.fns.coerce_args.call(null,additional_select);
var state_55029__$1 = state_55029;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55029__$1,(10),inst_55003);
} else {
if((state_val_55030 === (3))){
var inst_55027 = (state_55029[(2)]);
var state_55029__$1 = state_55029;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55029__$1,inst_55027);
} else {
if((state_val_55030 === (2))){
var _ = (function (){var statearr_55035 = state_55029;
(statearr_55035[(4)] = cljs.core.cons.call(null,(5),(state_55029[(4)])));

return statearr_55035;
})();
var inst_54998 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55029__$1 = state_55029;
if(cljs.core.truth_(inst_54998)){
var statearr_55036_55054 = state_55029__$1;
(statearr_55036_55054[(1)] = (6));

} else {
var statearr_55037_55055 = state_55029__$1;
(statearr_55037_55055[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55030 === (9))){
var inst_55009 = (state_55029[(2)]);
var inst_55010 = fluree.db.util.async.throw_err.call(null,inst_55009);
var inst_55011 = cljs.core.nth.call(null,inst_55010,(0),null);
var inst_55012 = cljs.core.nth.call(null,inst_55010,(1),null);
var inst_55013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55014 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55015 = ["?p","?ctx",inst_55011];
var inst_55016 = cljs.core.PersistentHashMap.fromArrays(inst_55014,inst_55015);
var inst_55017 = ((10) + inst_55012);
var inst_55018 = [inst_55016,inst_55017];
var inst_55019 = (new cljs.core.PersistentVector(null,2,(5),inst_55013,inst_55018,null));
var inst_55020 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55019);
var state_55029__$1 = (function (){var statearr_55038 = state_55029;
(statearr_55038[(7)] = inst_55020);

return statearr_55038;
})();
var statearr_55039_55056 = state_55029__$1;
(statearr_55039_55056[(2)] = inst_55011);

(statearr_55039_55056[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55030 === (5))){
var _ = (function (){var statearr_55040 = state_55029;
(statearr_55040[(4)] = cljs.core.rest.call(null,(state_55029[(4)])));

return statearr_55040;
})();
var state_55029__$1 = state_55029;
var ex55034 = (state_55029__$1[(2)]);
var statearr_55041_55057 = state_55029__$1;
(statearr_55041_55057[(5)] = ex55034);


if((ex55034 instanceof Error)){
var statearr_55042_55058 = state_55029__$1;
(statearr_55042_55058[(1)] = (4));

(statearr_55042_55058[(5)] = null);

} else {
throw ex55034;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55030 === (10))){
var inst_55005 = (state_55029[(2)]);
var inst_55006 = fluree.db.util.async.throw_err.call(null,inst_55005);
var inst_55007 = fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,inst_55006);
var state_55029__$1 = state_55029;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55029__$1,(9),inst_55007);
} else {
if((state_val_55030 === (8))){
var inst_55024 = (state_55029[(2)]);
var _ = (function (){var statearr_55043 = state_55029;
(statearr_55043[(4)] = cljs.core.rest.call(null,(state_55029[(4)])));

return statearr_55043;
})();
var state_55029__$1 = state_55029;
var statearr_55044_55059 = state_55029__$1;
(statearr_55044_55059[(2)] = inst_55024);

(statearr_55044_55059[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55045 = [null,null,null,null,null,null,null,null];
(statearr_55045[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55045[(1)] = (1));

return statearr_55045;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55029){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55029);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55046){var ex__2749__auto__ = e55046;
var statearr_55047_55060 = state_55029;
(statearr_55047_55060[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55029[(4)]))){
var statearr_55048_55061 = state_55029;
(statearr_55048_55061[(1)] = cljs.core.first.call(null,(state_55029[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55062 = state_55029;
state_55029 = G__55062;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55029){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55029);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55049 = f__2769__auto__.call(null);
(statearr_55049[(6)] = c__2768__auto__);

return statearr_55049;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55111 = arguments.length;
var i__5770__auto___55112 = (0);
while(true){
if((i__5770__auto___55112 < len__5769__auto___55111)){
args__5775__auto__.push((arguments[i__5770__auto___55112]));

var G__55113 = (i__5770__auto___55112 + (1));
i__5770__auto___55112 = G__55113;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55094){
var state_val_55095 = (state_55094[(1)]);
if((state_val_55095 === (1))){
var state_55094__$1 = state_55094;
var statearr_55096_55114 = state_55094__$1;
(statearr_55096_55114[(2)] = null);

(statearr_55096_55114[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55095 === (2))){
var _ = (function (){var statearr_55097 = state_55094;
(statearr_55097[(4)] = cljs.core.cons.call(null,(5),(state_55094[(4)])));

return statearr_55097;
})();
var inst_55071 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55094__$1 = state_55094;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55094__$1,(6),inst_55071);
} else {
if((state_val_55095 === (3))){
var inst_55092 = (state_55094[(2)]);
var state_55094__$1 = state_55094;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55094__$1,inst_55092);
} else {
if((state_val_55095 === (4))){
var inst_55065 = (state_55094[(2)]);
var state_55094__$1 = state_55094;
var statearr_55099_55115 = state_55094__$1;
(statearr_55099_55115[(2)] = inst_55065);

(statearr_55099_55115[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55095 === (5))){
var _ = (function (){var statearr_55100 = state_55094;
(statearr_55100[(4)] = cljs.core.rest.call(null,(state_55094[(4)])));

return statearr_55100;
})();
var state_55094__$1 = state_55094;
var ex55098 = (state_55094__$1[(2)]);
var statearr_55101_55116 = state_55094__$1;
(statearr_55101_55116[(5)] = ex55098);


if((ex55098 instanceof Error)){
var statearr_55102_55117 = state_55094__$1;
(statearr_55102_55117[(1)] = (4));

(statearr_55102_55117[(5)] = null);

} else {
throw ex55098;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55095 === (6))){
var inst_55073 = (state_55094[(2)]);
var inst_55074 = fluree.db.util.async.throw_err.call(null,inst_55073);
var inst_55075 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.and,inst_55074);
var inst_55076 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55077 = [inst_55074];
var inst_55078 = (new cljs.core.PersistentVector(null,1,(5),inst_55076,inst_55077,null));
var inst_55079 = cljs.core.count.call(null,inst_55078);
var inst_55080 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55081 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55082 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55083 = [inst_55074];
var inst_55084 = (new cljs.core.PersistentVector(null,1,(5),inst_55082,inst_55083,null));
var inst_55085 = ["and",inst_55084,inst_55075];
var inst_55086 = cljs.core.PersistentHashMap.fromArrays(inst_55081,inst_55085);
var inst_55087 = [inst_55086,inst_55079];
var inst_55088 = (new cljs.core.PersistentVector(null,2,(5),inst_55080,inst_55087,null));
var inst_55089 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55088);
var _ = (function (){var statearr_55103 = state_55094;
(statearr_55103[(4)] = cljs.core.rest.call(null,(state_55094[(4)])));

return statearr_55103;
})();
var state_55094__$1 = (function (){var statearr_55104 = state_55094;
(statearr_55104[(7)] = inst_55089);

return statearr_55104;
})();
var statearr_55105_55118 = state_55094__$1;
(statearr_55105_55118[(2)] = inst_55075);

(statearr_55105_55118[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55106 = [null,null,null,null,null,null,null,null];
(statearr_55106[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55106[(1)] = (1));

return statearr_55106;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55094){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55094);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55107){var ex__2749__auto__ = e55107;
var statearr_55108_55119 = state_55094;
(statearr_55108_55119[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55094[(4)]))){
var statearr_55109_55120 = state_55094;
(statearr_55109_55120[(1)] = cljs.core.first.call(null,(state_55094[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55121 = state_55094;
state_55094 = G__55121;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55094){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55094);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55110 = f__2769__auto__.call(null);
(statearr_55110[(6)] = c__2768__auto__);

return statearr_55110;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq55063){
var G__55064 = cljs.core.first.call(null,seq55063);
var seq55063__$1 = cljs.core.next.call(null,seq55063);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55064,seq55063__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55170 = arguments.length;
var i__5770__auto___55171 = (0);
while(true){
if((i__5770__auto___55171 < len__5769__auto___55170)){
args__5775__auto__.push((arguments[i__5770__auto___55171]));

var G__55172 = (i__5770__auto___55171 + (1));
i__5770__auto___55171 = G__55172;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55153){
var state_val_55154 = (state_55153[(1)]);
if((state_val_55154 === (1))){
var state_55153__$1 = state_55153;
var statearr_55155_55173 = state_55153__$1;
(statearr_55155_55173[(2)] = null);

(statearr_55155_55173[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55154 === (2))){
var _ = (function (){var statearr_55156 = state_55153;
(statearr_55156[(4)] = cljs.core.cons.call(null,(5),(state_55153[(4)])));

return statearr_55156;
})();
var inst_55130 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55153__$1 = state_55153;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55153__$1,(6),inst_55130);
} else {
if((state_val_55154 === (3))){
var inst_55151 = (state_55153[(2)]);
var state_55153__$1 = state_55153;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55153__$1,inst_55151);
} else {
if((state_val_55154 === (4))){
var inst_55124 = (state_55153[(2)]);
var state_55153__$1 = state_55153;
var statearr_55158_55174 = state_55153__$1;
(statearr_55158_55174[(2)] = inst_55124);

(statearr_55158_55174[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55154 === (5))){
var _ = (function (){var statearr_55159 = state_55153;
(statearr_55159[(4)] = cljs.core.rest.call(null,(state_55153[(4)])));

return statearr_55159;
})();
var state_55153__$1 = state_55153;
var ex55157 = (state_55153__$1[(2)]);
var statearr_55160_55175 = state_55153__$1;
(statearr_55160_55175[(5)] = ex55157);


if((ex55157 instanceof Error)){
var statearr_55161_55176 = state_55153__$1;
(statearr_55161_55176[(1)] = (4));

(statearr_55161_55176[(5)] = null);

} else {
throw ex55157;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55154 === (6))){
var inst_55132 = (state_55153[(2)]);
var inst_55133 = fluree.db.util.async.throw_err.call(null,inst_55132);
var inst_55134 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.or,inst_55133);
var inst_55135 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55136 = [inst_55133];
var inst_55137 = (new cljs.core.PersistentVector(null,1,(5),inst_55135,inst_55136,null));
var inst_55138 = cljs.core.count.call(null,inst_55137);
var inst_55139 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55140 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55141 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55142 = [inst_55133];
var inst_55143 = (new cljs.core.PersistentVector(null,1,(5),inst_55141,inst_55142,null));
var inst_55144 = ["or",inst_55143,inst_55134];
var inst_55145 = cljs.core.PersistentHashMap.fromArrays(inst_55140,inst_55144);
var inst_55146 = [inst_55145,inst_55138];
var inst_55147 = (new cljs.core.PersistentVector(null,2,(5),inst_55139,inst_55146,null));
var inst_55148 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55147);
var _ = (function (){var statearr_55162 = state_55153;
(statearr_55162[(4)] = cljs.core.rest.call(null,(state_55153[(4)])));

return statearr_55162;
})();
var state_55153__$1 = (function (){var statearr_55163 = state_55153;
(statearr_55163[(7)] = inst_55148);

return statearr_55163;
})();
var statearr_55164_55177 = state_55153__$1;
(statearr_55164_55177[(2)] = inst_55134);

(statearr_55164_55177[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55165 = [null,null,null,null,null,null,null,null];
(statearr_55165[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55165[(1)] = (1));

return statearr_55165;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55153){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55153);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55166){var ex__2749__auto__ = e55166;
var statearr_55167_55178 = state_55153;
(statearr_55167_55178[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55153[(4)]))){
var statearr_55168_55179 = state_55153;
(statearr_55168_55179[(1)] = cljs.core.first.call(null,(state_55153[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55180 = state_55153;
state_55153 = G__55180;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55153){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55153);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55169 = f__2769__auto__.call(null);
(statearr_55169[(6)] = c__2768__auto__);

return statearr_55169;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq55122){
var G__55123 = cljs.core.first.call(null,seq55122);
var seq55122__$1 = cljs.core.next.call(null,seq55122);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55123,seq55122__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55218){
var state_val_55219 = (state_55218[(1)]);
if((state_val_55219 === (7))){
var inst_55194 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_55218__$1 = state_55218;
if(inst_55194){
var statearr_55220_55243 = state_55218__$1;
(statearr_55220_55243[(1)] = (10));

} else {
var statearr_55221_55244 = state_55218__$1;
(statearr_55221_55244[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55219 === (1))){
var state_55218__$1 = state_55218;
var statearr_55222_55245 = state_55218__$1;
(statearr_55222_55245[(2)] = null);

(statearr_55222_55245[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55219 === (4))){
var inst_55181 = (state_55218[(2)]);
var state_55218__$1 = state_55218;
var statearr_55223_55246 = state_55218__$1;
(statearr_55223_55246[(2)] = inst_55181);

(statearr_55223_55246[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55219 === (13))){
var inst_55197 = (state_55218[(2)]);
var inst_55198 = fluree.db.util.async.throw_err.call(null,inst_55197);
var state_55218__$1 = state_55218;
var statearr_55224_55247 = state_55218__$1;
(statearr_55224_55247[(2)] = inst_55198);

(statearr_55224_55247[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55219 === (6))){
var inst_55189 = fluree.db.dbfunctions.fns.coerce_args.call(null,coll);
var state_55218__$1 = state_55218;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55218__$1,(9),inst_55189);
} else {
if((state_val_55219 === (3))){
var inst_55216 = (state_55218[(2)]);
var state_55218__$1 = state_55218;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55218__$1,inst_55216);
} else {
if((state_val_55219 === (12))){
var inst_55201 = (state_55218[(2)]);
var state_55218__$1 = state_55218;
var statearr_55225_55248 = state_55218__$1;
(statearr_55225_55248[(2)] = inst_55201);

(statearr_55225_55248[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55219 === (2))){
var _ = (function (){var statearr_55226 = state_55218;
(statearr_55226[(4)] = cljs.core.cons.call(null,(5),(state_55218[(4)])));

return statearr_55226;
})();
var inst_55187 = cljs.core.vector_QMARK_.call(null,coll);
var state_55218__$1 = state_55218;
if(inst_55187){
var statearr_55227_55249 = state_55218__$1;
(statearr_55227_55249[(1)] = (6));

} else {
var statearr_55228_55250 = state_55218__$1;
(statearr_55228_55250[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55219 === (11))){
var state_55218__$1 = state_55218;
var statearr_55230_55251 = state_55218__$1;
(statearr_55230_55251[(2)] = coll);

(statearr_55230_55251[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55219 === (9))){
var inst_55191 = (state_55218[(2)]);
var inst_55192 = fluree.db.util.async.throw_err.call(null,inst_55191);
var state_55218__$1 = state_55218;
var statearr_55231_55252 = state_55218__$1;
(statearr_55231_55252[(2)] = inst_55192);

(statearr_55231_55252[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55219 === (5))){
var _ = (function (){var statearr_55232 = state_55218;
(statearr_55232[(4)] = cljs.core.rest.call(null,(state_55218[(4)])));

return statearr_55232;
})();
var state_55218__$1 = state_55218;
var ex55229 = (state_55218__$1[(2)]);
var statearr_55233_55253 = state_55218__$1;
(statearr_55233_55253[(5)] = ex55229);


if((ex55229 instanceof Error)){
var statearr_55234_55254 = state_55218__$1;
(statearr_55234_55254[(1)] = (4));

(statearr_55234_55254[(5)] = null);

} else {
throw ex55229;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55219 === (10))){
var state_55218__$1 = state_55218;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55218__$1,(13),coll);
} else {
if((state_val_55219 === (8))){
var inst_55203 = (state_55218[(2)]);
var inst_55204 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_55203);
var inst_55205 = cljs.core.count.call(null,inst_55204);
var inst_55206 = ((9) + inst_55205);
var inst_55207 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55208 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55209 = ["count",inst_55203,inst_55205];
var inst_55210 = cljs.core.PersistentHashMap.fromArrays(inst_55208,inst_55209);
var inst_55211 = [inst_55210,inst_55206];
var inst_55212 = (new cljs.core.PersistentVector(null,2,(5),inst_55207,inst_55211,null));
var inst_55213 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55212);
var _ = (function (){var statearr_55235 = state_55218;
(statearr_55235[(4)] = cljs.core.rest.call(null,(state_55218[(4)])));

return statearr_55235;
})();
var state_55218__$1 = (function (){var statearr_55236 = state_55218;
(statearr_55236[(7)] = inst_55213);

return statearr_55236;
})();
var statearr_55237_55255 = state_55218__$1;
(statearr_55237_55255[(2)] = inst_55205);

(statearr_55237_55255[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____0 = (function (){
var statearr_55238 = [null,null,null,null,null,null,null,null];
(statearr_55238[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__);

(statearr_55238[(1)] = (1));

return statearr_55238;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____1 = (function (state_55218){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55218);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55239){var ex__2749__auto__ = e55239;
var statearr_55240_55256 = state_55218;
(statearr_55240_55256[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55218[(4)]))){
var statearr_55241_55257 = state_55218;
(statearr_55241_55257[(1)] = cljs.core.first.call(null,(state_55218[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55258 = state_55218;
state_55218 = G__55258;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__ = function(state_55218){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____1.call(this,state_55218);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55242 = f__2769__auto__.call(null);
(statearr_55242[(6)] = c__2768__auto__);

return statearr_55242;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(p__55259,subject,pred){
var map__55260 = p__55259;
var map__55260__$1 = cljs.core.__destructure_map.call(null,map__55260);
var _QMARK_ctx = map__55260__$1;
var cache = cljs.core.get.call(null,map__55260__$1,new cljs.core.Keyword(null,"cache","cache",-1237023054));
var db = cljs.core.get.call(null,map__55260__$1,new cljs.core.Keyword(null,"db","db",993250759));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55351){
var state_val_55352 = (state_55351[(1)]);
if((state_val_55352 === (7))){
var state_55351__$1 = state_55351;
var statearr_55353_55409 = state_55351__$1;
(statearr_55353_55409[(2)] = subject);

(statearr_55353_55409[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55352 === (20))){
var state_55351__$1 = state_55351;
var statearr_55354_55410 = state_55351__$1;
(statearr_55354_55410[(2)] = cache);

(statearr_55354_55410[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55352 === (27))){
var inst_55282 = (state_55351[(7)]);
var inst_55294 = (state_55351[(8)]);
var inst_55308 = fluree.db.dbfunctions.internal.get_subj_pred.call(null,db,inst_55294,inst_55282);
var state_55351__$1 = state_55351;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55351__$1,(29),inst_55308);
} else {
if((state_val_55352 === (1))){
var state_55351__$1 = state_55351;
var statearr_55355_55411 = state_55351__$1;
(statearr_55355_55411[(2)] = null);

(statearr_55355_55411[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55352 === (24))){
var inst_55294 = (state_55351[(8)]);
var inst_55321 = cljs.core.int_QMARK_.call(null,inst_55294);
var state_55351__$1 = state_55351;
if(inst_55321){
var statearr_55356_55412 = state_55351__$1;
(statearr_55356_55412[(1)] = (30));

} else {
var statearr_55357_55413 = state_55351__$1;
(statearr_55357_55413[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55352 === (4))){
var inst_55261 = (state_55351[(2)]);
var state_55351__$1 = state_55351;
var statearr_55358_55414 = state_55351__$1;
(statearr_55358_55414[(2)] = inst_55261);

(statearr_55358_55414[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55352 === (15))){
var inst_55274 = (state_55351[(9)]);
var state_55351__$1 = state_55351;
var statearr_55359_55415 = state_55351__$1;
(statearr_55359_55415[(2)] = inst_55274);

(statearr_55359_55415[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55352 === (21))){
var inst_55295 = (state_55351[(10)]);
var state_55351__$1 = state_55351;
var statearr_55360_55416 = state_55351__$1;
(statearr_55360_55416[(2)] = inst_55295);

(statearr_55360_55416[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55352 === (31))){
var state_55351__$1 = state_55351;
var statearr_55361_55417 = state_55351__$1;
(statearr_55361_55417[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55352 === (32))){
var inst_55334 = (state_55351[(2)]);
var state_55351__$1 = state_55351;
var statearr_55363_55418 = state_55351__$1;
(statearr_55363_55418[(2)] = inst_55334);

(statearr_55363_55418[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55352 === (33))){
var inst_55325 = (state_55351[(2)]);
var inst_55326 = fluree.db.util.async.throw_err.call(null,inst_55325);
var state_55351__$1 = state_55351;
var statearr_55364_55419 = state_55351__$1;
(statearr_55364_55419[(2)] = inst_55326);

(statearr_55364_55419[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55352 === (13))){
var inst_55278 = (state_55351[(2)]);
var inst_55279 = fluree.db.util.async.throw_err.call(null,inst_55278);
var state_55351__$1 = state_55351;
var statearr_55365_55420 = state_55351__$1;
(statearr_55365_55420[(2)] = inst_55279);

(statearr_55365_55420[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55352 === (22))){
var inst_55299 = (state_55351[(2)]);
var state_55351__$1 = state_55351;
if(cljs.core.truth_(inst_55299)){
var statearr_55366_55421 = state_55351__$1;
(statearr_55366_55421[(1)] = (23));

} else {
var statearr_55367_55422 = state_55351__$1;
(statearr_55367_55422[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55352 === (36))){
var inst_55332 = (state_55351[(2)]);
var state_55351__$1 = state_55351;
var statearr_55368_55423 = state_55351__$1;
(statearr_55368_55423[(2)] = inst_55332);

(statearr_55368_55423[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55352 === (29))){
var inst_55282 = (state_55351[(7)]);
var inst_55294 = (state_55351[(8)]);
var inst_55310 = (state_55351[(2)]);
var inst_55311 = fluree.db.util.async.throw_err.call(null,inst_55310);
var inst_55312 = cljs.core._deref.call(null,cache);
var inst_55313 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55314 = [new cljs.core.Keyword(null,"get","get",1683182755),inst_55294,inst_55282];
var inst_55315 = (new cljs.core.PersistentVector(null,3,(5),inst_55313,inst_55314,null));
var inst_55316 = cljs.core.assoc_in.call(null,inst_55312,inst_55315,inst_55311);
var inst_55317 = cljs.core._vreset_BANG_.call(null,cache,inst_55316);
var state_55351__$1 = (function (){var statearr_55369 = state_55351;
(statearr_55369[(11)] = inst_55317);

return statearr_55369;
})();
var statearr_55370_55424 = state_55351__$1;
(statearr_55370_55424[(2)] = inst_55311);

(statearr_55370_55424[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55352 === (6))){
var state_55351__$1 = state_55351;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55351__$1,(9),subject);
} else {
if((state_val_55352 === (28))){
var inst_55319 = (state_55351[(2)]);
var state_55351__$1 = state_55351;
var statearr_55371_55425 = state_55351__$1;
(statearr_55371_55425[(2)] = inst_55319);

(statearr_55371_55425[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55352 === (25))){
var inst_55282 = (state_55351[(7)]);
var inst_55274 = (state_55351[(9)]);
var inst_55336 = (state_55351[(2)]);
var inst_55337 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55338 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55339 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55340 = [inst_55274,inst_55282];
var inst_55341 = (new cljs.core.PersistentVector(null,2,(5),inst_55339,inst_55340,null));
var inst_55342 = ["get",inst_55341,inst_55336];
var inst_55343 = cljs.core.PersistentHashMap.fromArrays(inst_55338,inst_55342);
var inst_55344 = [inst_55343,(10)];
var inst_55345 = (new cljs.core.PersistentVector(null,2,(5),inst_55337,inst_55344,null));
var inst_55346 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55345);
var _ = (function (){var statearr_55372 = state_55351;
(statearr_55372[(4)] = cljs.core.rest.call(null,(state_55351[(4)])));

return statearr_55372;
})();
var state_55351__$1 = (function (){var statearr_55373 = state_55351;
(statearr_55373[(12)] = inst_55346);

return statearr_55373;
})();
var statearr_55374_55426 = state_55351__$1;
(statearr_55374_55426[(2)] = inst_55336);

(statearr_55374_55426[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55352 === (34))){
var inst_55282 = (state_55351[(7)]);
var inst_55294 = (state_55351[(8)]);
var inst_55329 = fluree.db.dbfunctions.internal.get.call(null,inst_55294,inst_55282);
var state_55351__$1 = state_55351;
var statearr_55375_55427 = state_55351__$1;
(statearr_55375_55427[(2)] = inst_55329);

(statearr_55375_55427[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55352 === (17))){
var inst_55274 = (state_55351[(9)]);
var inst_55288 = cljs.core.first.call(null,inst_55274);
var state_55351__$1 = state_55351;
var statearr_55376_55428 = state_55351__$1;
(statearr_55376_55428[(2)] = inst_55288);

(statearr_55376_55428[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55352 === (3))){
var inst_55349 = (state_55351[(2)]);
var state_55351__$1 = state_55351;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55351__$1,inst_55349);
} else {
if((state_val_55352 === (12))){
var inst_55274 = (state_55351[(9)]);
var inst_55282 = (state_55351[(2)]);
var inst_55283 = cljs.core.vector_QMARK_.call(null,inst_55274);
var state_55351__$1 = (function (){var statearr_55377 = state_55351;
(statearr_55377[(7)] = inst_55282);

return statearr_55377;
})();
if(inst_55283){
var statearr_55378_55429 = state_55351__$1;
(statearr_55378_55429[(1)] = (14));

} else {
var statearr_55379_55430 = state_55351__$1;
(statearr_55379_55430[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55352 === (2))){
var _ = (function (){var statearr_55380 = state_55351;
(statearr_55380[(4)] = cljs.core.cons.call(null,(5),(state_55351[(4)])));

return statearr_55380;
})();
var inst_55267 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_55351__$1 = state_55351;
if(inst_55267){
var statearr_55381_55431 = state_55351__$1;
(statearr_55381_55431[(1)] = (6));

} else {
var statearr_55382_55432 = state_55351__$1;
(statearr_55382_55432[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55352 === (23))){
var inst_55282 = (state_55351[(7)]);
var inst_55294 = (state_55351[(8)]);
var inst_55305 = (state_55351[(13)]);
var inst_55301 = cljs.core.deref.call(null,cache);
var inst_55302 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55303 = [new cljs.core.Keyword(null,"get","get",1683182755),inst_55294,inst_55282];
var inst_55304 = (new cljs.core.PersistentVector(null,3,(5),inst_55302,inst_55303,null));
var inst_55305__$1 = cljs.core.get_in.call(null,inst_55301,inst_55304);
var state_55351__$1 = (function (){var statearr_55383 = state_55351;
(statearr_55383[(13)] = inst_55305__$1);

return statearr_55383;
})();
if(cljs.core.truth_(inst_55305__$1)){
var statearr_55384_55433 = state_55351__$1;
(statearr_55384_55433[(1)] = (26));

} else {
var statearr_55385_55434 = state_55351__$1;
(statearr_55385_55434[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55352 === (35))){
var state_55351__$1 = state_55351;
var statearr_55386_55435 = state_55351__$1;
(statearr_55386_55435[(2)] = null);

(statearr_55386_55435[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55352 === (19))){
var inst_55291 = (state_55351[(2)]);
var state_55351__$1 = state_55351;
var statearr_55387_55436 = state_55351__$1;
(statearr_55387_55436[(2)] = inst_55291);

(statearr_55387_55436[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55352 === (11))){
var state_55351__$1 = state_55351;
var statearr_55389_55437 = state_55351__$1;
(statearr_55389_55437[(2)] = pred);

(statearr_55389_55437[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55352 === (9))){
var inst_55270 = (state_55351[(2)]);
var inst_55271 = fluree.db.util.async.throw_err.call(null,inst_55270);
var state_55351__$1 = state_55351;
var statearr_55390_55438 = state_55351__$1;
(statearr_55390_55438[(2)] = inst_55271);

(statearr_55390_55438[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55352 === (5))){
var _ = (function (){var statearr_55391 = state_55351;
(statearr_55391[(4)] = cljs.core.rest.call(null,(state_55351[(4)])));

return statearr_55391;
})();
var state_55351__$1 = state_55351;
var ex55388 = (state_55351__$1[(2)]);
var statearr_55392_55439 = state_55351__$1;
(statearr_55392_55439[(5)] = ex55388);


if((ex55388 instanceof Error)){
var statearr_55393_55440 = state_55351__$1;
(statearr_55393_55440[(1)] = (4));

(statearr_55393_55440[(5)] = null);

} else {
throw ex55388;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55352 === (14))){
var inst_55274 = (state_55351[(9)]);
var inst_55285 = cljs.core.count.call(null,inst_55274);
var inst_55286 = cljs.core._EQ_.call(null,(1),inst_55285);
var state_55351__$1 = state_55351;
if(inst_55286){
var statearr_55394_55441 = state_55351__$1;
(statearr_55394_55441[(1)] = (17));

} else {
var statearr_55395_55442 = state_55351__$1;
(statearr_55395_55442[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55352 === (26))){
var inst_55305 = (state_55351[(13)]);
var state_55351__$1 = state_55351;
var statearr_55396_55443 = state_55351__$1;
(statearr_55396_55443[(2)] = inst_55305);

(statearr_55396_55443[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55352 === (16))){
var inst_55294 = (state_55351[(8)]);
var inst_55295 = (state_55351[(10)]);
var inst_55294__$1 = (state_55351[(2)]);
var inst_55295__$1 = cljs.core.int_QMARK_.call(null,inst_55294__$1);
var state_55351__$1 = (function (){var statearr_55397 = state_55351;
(statearr_55397[(8)] = inst_55294__$1);

(statearr_55397[(10)] = inst_55295__$1);

return statearr_55397;
})();
if(inst_55295__$1){
var statearr_55398_55444 = state_55351__$1;
(statearr_55398_55444[(1)] = (20));

} else {
var statearr_55399_55445 = state_55351__$1;
(statearr_55399_55445[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55352 === (30))){
var inst_55282 = (state_55351[(7)]);
var inst_55294 = (state_55351[(8)]);
var inst_55323 = fluree.db.dbfunctions.internal.get_subj_pred.call(null,db,inst_55294,inst_55282);
var state_55351__$1 = state_55351;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55351__$1,(33),inst_55323);
} else {
if((state_val_55352 === (10))){
var state_55351__$1 = state_55351;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55351__$1,(13),pred);
} else {
if((state_val_55352 === (18))){
var inst_55274 = (state_55351[(9)]);
var state_55351__$1 = state_55351;
var statearr_55400_55446 = state_55351__$1;
(statearr_55400_55446[(2)] = inst_55274);

(statearr_55400_55446[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55352 === (8))){
var inst_55274 = (state_55351[(2)]);
var inst_55275 = fluree.db.util.async.channel_QMARK_.call(null,pred);
var state_55351__$1 = (function (){var statearr_55401 = state_55351;
(statearr_55401[(9)] = inst_55274);

return statearr_55401;
})();
if(inst_55275){
var statearr_55402_55447 = state_55351__$1;
(statearr_55402_55447[(1)] = (10));

} else {
var statearr_55403_55448 = state_55351__$1;
(statearr_55403_55448[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____0 = (function (){
var statearr_55404 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55404[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__);

(statearr_55404[(1)] = (1));

return statearr_55404;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____1 = (function (state_55351){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55351);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55405){var ex__2749__auto__ = e55405;
var statearr_55406_55449 = state_55351;
(statearr_55406_55449[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55351[(4)]))){
var statearr_55407_55450 = state_55351;
(statearr_55407_55450[(1)] = cljs.core.first.call(null,(state_55351[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55451 = state_55351;
state_55351 = G__55451;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__ = function(state_55351){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____1.call(this,state_55351);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55408 = f__2769__auto__.call(null);
(statearr_55408[(6)] = c__2768__auto__);

return statearr_55408;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55490){
var state_val_55491 = (state_55490[(1)]);
if((state_val_55491 === (7))){
var inst_55458 = (state_55490[(7)]);
var state_55490__$1 = state_55490;
var statearr_55492_55516 = state_55490__$1;
(statearr_55492_55516[(2)] = inst_55458);

(statearr_55492_55516[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (1))){
var state_55490__$1 = state_55490;
var statearr_55493_55517 = state_55490__$1;
(statearr_55493_55517[(2)] = null);

(statearr_55493_55517[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (4))){
var inst_55452 = (state_55490[(2)]);
var state_55490__$1 = state_55490;
var statearr_55494_55518 = state_55490__$1;
(statearr_55494_55518[(2)] = inst_55452);

(statearr_55494_55518[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (6))){
var inst_55460 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55490__$1 = state_55490;
var statearr_55495_55519 = state_55490__$1;
(statearr_55495_55519[(2)] = inst_55460);

(statearr_55495_55519[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (3))){
var inst_55488 = (state_55490[(2)]);
var state_55490__$1 = state_55490;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55490__$1,inst_55488);
} else {
if((state_val_55491 === (12))){
var inst_55470 = (state_55490[(2)]);
var inst_55471 = fluree.db.util.async.throw_err.call(null,inst_55470);
var inst_55472 = cljs.core.nth.call(null,inst_55471,(0),null);
var inst_55473 = cljs.core.nth.call(null,inst_55471,(1),null);
var inst_55474 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55475 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55476 = ["?pO","?ctx",inst_55472];
var inst_55477 = cljs.core.PersistentHashMap.fromArrays(inst_55475,inst_55476);
var inst_55478 = ((10) + inst_55473);
var inst_55479 = [inst_55477,inst_55478];
var inst_55480 = (new cljs.core.PersistentVector(null,2,(5),inst_55474,inst_55479,null));
var inst_55481 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55480);
var state_55490__$1 = (function (){var statearr_55496 = state_55490;
(statearr_55496[(8)] = inst_55481);

return statearr_55496;
})();
var statearr_55497_55520 = state_55490__$1;
(statearr_55497_55520[(2)] = inst_55472);

(statearr_55497_55520[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (2))){
var inst_55458 = (state_55490[(7)]);
var _ = (function (){var statearr_55498 = state_55490;
(statearr_55498[(4)] = cljs.core.cons.call(null,(5),(state_55490[(4)])));

return statearr_55498;
})();
var inst_55458__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55490__$1 = (function (){var statearr_55499 = state_55490;
(statearr_55499[(7)] = inst_55458__$1);

return statearr_55499;
})();
if(cljs.core.truth_(inst_55458__$1)){
var statearr_55500_55521 = state_55490__$1;
(statearr_55500_55521[(1)] = (6));

} else {
var statearr_55501_55522 = state_55490__$1;
(statearr_55501_55522[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (11))){
var inst_55485 = (state_55490[(2)]);
var _ = (function (){var statearr_55503 = state_55490;
(statearr_55503[(4)] = cljs.core.rest.call(null,(state_55490[(4)])));

return statearr_55503;
})();
var state_55490__$1 = state_55490;
var statearr_55504_55523 = state_55490__$1;
(statearr_55504_55523[(2)] = inst_55485);

(statearr_55504_55523[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (9))){
var inst_55468 = fluree.db.dbfunctions.internal._QMARK_pO.call(null,_QMARK_ctx);
var state_55490__$1 = state_55490;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55490__$1,(12),inst_55468);
} else {
if((state_val_55491 === (5))){
var _ = (function (){var statearr_55505 = state_55490;
(statearr_55505[(4)] = cljs.core.rest.call(null,(state_55490[(4)])));

return statearr_55505;
})();
var state_55490__$1 = state_55490;
var ex55502 = (state_55490__$1[(2)]);
var statearr_55506_55524 = state_55490__$1;
(statearr_55506_55524[(5)] = ex55502);


if((ex55502 instanceof Error)){
var statearr_55507_55525 = state_55490__$1;
(statearr_55507_55525[(1)] = (4));

(statearr_55507_55525[(5)] = null);

} else {
throw ex55502;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (10))){
var inst_55483 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_55490__$1 = state_55490;
var statearr_55508_55526 = state_55490__$1;
(statearr_55508_55526[(2)] = inst_55483);

(statearr_55508_55526[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55491 === (8))){
var inst_55463 = (state_55490[(2)]);
var state_55490__$1 = state_55490;
if(cljs.core.truth_(inst_55463)){
var statearr_55509_55527 = state_55490__$1;
(statearr_55509_55527[(1)] = (9));

} else {
var statearr_55510_55528 = state_55490__$1;
(statearr_55510_55528[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____0 = (function (){
var statearr_55511 = [null,null,null,null,null,null,null,null,null];
(statearr_55511[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__);

(statearr_55511[(1)] = (1));

return statearr_55511;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____1 = (function (state_55490){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55490);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55512){var ex__2749__auto__ = e55512;
var statearr_55513_55529 = state_55490;
(statearr_55513_55529[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55490[(4)]))){
var statearr_55514_55530 = state_55490;
(statearr_55514_55530[(1)] = cljs.core.first.call(null,(state_55490[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55531 = state_55490;
state_55490 = G__55531;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__ = function(state_55490){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____1.call(this,state_55490);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55515 = f__2769__auto__.call(null);
(statearr_55515[(6)] = c__2768__auto__);

return statearr_55515;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Used to get-all values in a nested result set, or also can follow a subject down the provided path and return a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55600){
var state_val_55601 = (state_55600[(1)]);
if((state_val_55601 === (7))){
var state_55600__$1 = state_55600;
var statearr_55602_55640 = state_55600__$1;
(statearr_55602_55640[(2)] = subject);

(statearr_55602_55640[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55601 === (20))){
var inst_55556 = (state_55600[(7)]);
var inst_55568 = (state_55600[(8)]);
var inst_55571 = fluree.db.dbfunctions.internal.follow_subject.call(null,_QMARK_ctx,inst_55568,inst_55556);
var state_55600__$1 = state_55600;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55600__$1,(23),inst_55571);
} else {
if((state_val_55601 === (1))){
var state_55600__$1 = state_55600;
var statearr_55603_55641 = state_55600__$1;
(statearr_55603_55641[(2)] = null);

(statearr_55603_55641[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55601 === (4))){
var inst_55532 = (state_55600[(2)]);
var state_55600__$1 = state_55600;
var statearr_55604_55642 = state_55600__$1;
(statearr_55604_55642[(2)] = inst_55532);

(statearr_55604_55642[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55601 === (15))){
var inst_55548 = (state_55600[(9)]);
var state_55600__$1 = state_55600;
var statearr_55605_55643 = state_55600__$1;
(statearr_55605_55643[(2)] = inst_55548);

(statearr_55605_55643[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55601 === (21))){
var inst_55556 = (state_55600[(7)]);
var inst_55568 = (state_55600[(8)]);
var inst_55576 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55577 = fluree.db.dbfunctions.internal.get_all.call(null,inst_55568,inst_55556);
var inst_55578 = cljs.core.count.call(null,inst_55556);
var inst_55579 = ((9) + inst_55578);
var inst_55580 = [inst_55577,inst_55579];
var inst_55581 = (new cljs.core.PersistentVector(null,2,(5),inst_55576,inst_55580,null));
var state_55600__$1 = state_55600;
var statearr_55606_55644 = state_55600__$1;
(statearr_55606_55644[(2)] = inst_55581);

(statearr_55606_55644[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55601 === (13))){
var inst_55552 = (state_55600[(2)]);
var inst_55553 = fluree.db.util.async.throw_err.call(null,inst_55552);
var state_55600__$1 = state_55600;
var statearr_55607_55645 = state_55600__$1;
(statearr_55607_55645[(2)] = inst_55553);

(statearr_55607_55645[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55601 === (22))){
var inst_55548 = (state_55600[(9)]);
var inst_55556 = (state_55600[(7)]);
var inst_55583 = (state_55600[(2)]);
var inst_55584 = cljs.core.nth.call(null,inst_55583,(0),null);
var inst_55585 = cljs.core.nth.call(null,inst_55583,(1),null);
var inst_55586 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55587 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55588 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55589 = [inst_55548,inst_55556];
var inst_55590 = (new cljs.core.PersistentVector(null,2,(5),inst_55588,inst_55589,null));
var inst_55591 = ["get-all",inst_55590,inst_55584];
var inst_55592 = cljs.core.PersistentHashMap.fromArrays(inst_55587,inst_55591);
var inst_55593 = [inst_55592,inst_55585];
var inst_55594 = (new cljs.core.PersistentVector(null,2,(5),inst_55586,inst_55593,null));
var inst_55595 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55594);
var _ = (function (){var statearr_55608 = state_55600;
(statearr_55608[(4)] = cljs.core.rest.call(null,(state_55600[(4)])));

return statearr_55608;
})();
var state_55600__$1 = (function (){var statearr_55609 = state_55600;
(statearr_55609[(10)] = inst_55595);

return statearr_55609;
})();
var statearr_55610_55646 = state_55600__$1;
(statearr_55610_55646[(2)] = inst_55584);

(statearr_55610_55646[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55601 === (6))){
var state_55600__$1 = state_55600;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55600__$1,(9),subject);
} else {
if((state_val_55601 === (17))){
var inst_55548 = (state_55600[(9)]);
var inst_55562 = cljs.core.first.call(null,inst_55548);
var state_55600__$1 = state_55600;
var statearr_55611_55647 = state_55600__$1;
(statearr_55611_55647[(2)] = inst_55562);

(statearr_55611_55647[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55601 === (3))){
var inst_55598 = (state_55600[(2)]);
var state_55600__$1 = state_55600;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55600__$1,inst_55598);
} else {
if((state_val_55601 === (12))){
var inst_55548 = (state_55600[(9)]);
var inst_55556 = (state_55600[(2)]);
var inst_55557 = cljs.core.vector_QMARK_.call(null,inst_55548);
var state_55600__$1 = (function (){var statearr_55612 = state_55600;
(statearr_55612[(7)] = inst_55556);

return statearr_55612;
})();
if(inst_55557){
var statearr_55613_55648 = state_55600__$1;
(statearr_55613_55648[(1)] = (14));

} else {
var statearr_55614_55649 = state_55600__$1;
(statearr_55614_55649[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55601 === (2))){
var _ = (function (){var statearr_55615 = state_55600;
(statearr_55615[(4)] = cljs.core.cons.call(null,(5),(state_55600[(4)])));

return statearr_55615;
})();
var inst_55541 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_55600__$1 = state_55600;
if(inst_55541){
var statearr_55616_55650 = state_55600__$1;
(statearr_55616_55650[(1)] = (6));

} else {
var statearr_55617_55651 = state_55600__$1;
(statearr_55617_55651[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55601 === (23))){
var inst_55573 = (state_55600[(2)]);
var inst_55574 = fluree.db.util.async.throw_err.call(null,inst_55573);
var state_55600__$1 = state_55600;
var statearr_55618_55652 = state_55600__$1;
(statearr_55618_55652[(2)] = inst_55574);

(statearr_55618_55652[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55601 === (19))){
var inst_55565 = (state_55600[(2)]);
var state_55600__$1 = state_55600;
var statearr_55619_55653 = state_55600__$1;
(statearr_55619_55653[(2)] = inst_55565);

(statearr_55619_55653[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55601 === (11))){
var state_55600__$1 = state_55600;
var statearr_55621_55654 = state_55600__$1;
(statearr_55621_55654[(2)] = path);

(statearr_55621_55654[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55601 === (9))){
var inst_55544 = (state_55600[(2)]);
var inst_55545 = fluree.db.util.async.throw_err.call(null,inst_55544);
var state_55600__$1 = state_55600;
var statearr_55622_55655 = state_55600__$1;
(statearr_55622_55655[(2)] = inst_55545);

(statearr_55622_55655[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55601 === (5))){
var _ = (function (){var statearr_55623 = state_55600;
(statearr_55623[(4)] = cljs.core.rest.call(null,(state_55600[(4)])));

return statearr_55623;
})();
var state_55600__$1 = state_55600;
var ex55620 = (state_55600__$1[(2)]);
var statearr_55624_55656 = state_55600__$1;
(statearr_55624_55656[(5)] = ex55620);


if((ex55620 instanceof Error)){
var statearr_55625_55657 = state_55600__$1;
(statearr_55625_55657[(1)] = (4));

(statearr_55625_55657[(5)] = null);

} else {
throw ex55620;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55601 === (14))){
var inst_55548 = (state_55600[(9)]);
var inst_55559 = cljs.core.count.call(null,inst_55548);
var inst_55560 = cljs.core._EQ_.call(null,(1),inst_55559);
var state_55600__$1 = state_55600;
if(inst_55560){
var statearr_55626_55658 = state_55600__$1;
(statearr_55626_55658[(1)] = (17));

} else {
var statearr_55627_55659 = state_55600__$1;
(statearr_55627_55659[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55601 === (16))){
var inst_55568 = (state_55600[(8)]);
var inst_55568__$1 = (state_55600[(2)]);
var inst_55569 = cljs.core.int_QMARK_.call(null,inst_55568__$1);
var state_55600__$1 = (function (){var statearr_55628 = state_55600;
(statearr_55628[(8)] = inst_55568__$1);

return statearr_55628;
})();
if(inst_55569){
var statearr_55629_55660 = state_55600__$1;
(statearr_55629_55660[(1)] = (20));

} else {
var statearr_55630_55661 = state_55600__$1;
(statearr_55630_55661[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55601 === (10))){
var state_55600__$1 = state_55600;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55600__$1,(13),path);
} else {
if((state_val_55601 === (18))){
var inst_55548 = (state_55600[(9)]);
var state_55600__$1 = state_55600;
var statearr_55631_55662 = state_55600__$1;
(statearr_55631_55662[(2)] = inst_55548);

(statearr_55631_55662[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55601 === (8))){
var inst_55548 = (state_55600[(2)]);
var inst_55549 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_55600__$1 = (function (){var statearr_55632 = state_55600;
(statearr_55632[(9)] = inst_55548);

return statearr_55632;
})();
if(inst_55549){
var statearr_55633_55663 = state_55600__$1;
(statearr_55633_55663[(1)] = (10));

} else {
var statearr_55634_55664 = state_55600__$1;
(statearr_55634_55664[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____0 = (function (){
var statearr_55635 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_55635[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__);

(statearr_55635[(1)] = (1));

return statearr_55635;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____1 = (function (state_55600){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55600);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55636){var ex__2749__auto__ = e55636;
var statearr_55637_55665 = state_55600;
(statearr_55637_55665[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55600[(4)]))){
var statearr_55638_55666 = state_55600;
(statearr_55638_55666[(1)] = cljs.core.first.call(null,(state_55600[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55667 = state_55600;
state_55600 = G__55667;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__ = function(state_55600){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____1.call(this,state_55600);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55639 = f__2769__auto__.call(null);
(statearr_55639[(6)] = c__2768__auto__);

return statearr_55639;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55706){
var state_val_55707 = (state_55706[(1)]);
if((state_val_55707 === (7))){
var state_55706__$1 = state_55706;
var statearr_55708_55732 = state_55706__$1;
(statearr_55708_55732[(2)] = subject);

(statearr_55708_55732[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55707 === (1))){
var state_55706__$1 = state_55706;
var statearr_55709_55733 = state_55706__$1;
(statearr_55709_55733[(2)] = null);

(statearr_55709_55733[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55707 === (4))){
var inst_55668 = (state_55706[(2)]);
var state_55706__$1 = state_55706;
var statearr_55710_55734 = state_55706__$1;
(statearr_55710_55734[(2)] = inst_55668);

(statearr_55710_55734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55707 === (13))){
var inst_55685 = (state_55706[(2)]);
var inst_55686 = fluree.db.util.async.throw_err.call(null,inst_55685);
var state_55706__$1 = state_55706;
var statearr_55711_55735 = state_55706__$1;
(statearr_55711_55735[(2)] = inst_55686);

(statearr_55711_55735[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55707 === (6))){
var state_55706__$1 = state_55706;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55706__$1,(9),subject);
} else {
if((state_val_55707 === (3))){
var inst_55704 = (state_55706[(2)]);
var state_55706__$1 = state_55706;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55706__$1,inst_55704);
} else {
if((state_val_55707 === (12))){
var inst_55681 = (state_55706[(7)]);
var inst_55689 = (state_55706[(2)]);
var inst_55690 = fluree.db.dbfunctions.internal.get_in.call(null,inst_55681,inst_55689);
var inst_55691 = cljs.core.count.call(null,inst_55689);
var inst_55692 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55693 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55694 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55695 = [inst_55681,inst_55689];
var inst_55696 = (new cljs.core.PersistentVector(null,2,(5),inst_55694,inst_55695,null));
var inst_55697 = ["get-in",inst_55696,inst_55690];
var inst_55698 = cljs.core.PersistentHashMap.fromArrays(inst_55693,inst_55697);
var inst_55699 = [inst_55698,inst_55691];
var inst_55700 = (new cljs.core.PersistentVector(null,2,(5),inst_55692,inst_55699,null));
var inst_55701 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55700);
var _ = (function (){var statearr_55712 = state_55706;
(statearr_55712[(4)] = cljs.core.rest.call(null,(state_55706[(4)])));

return statearr_55712;
})();
var state_55706__$1 = (function (){var statearr_55713 = state_55706;
(statearr_55713[(8)] = inst_55701);

return statearr_55713;
})();
var statearr_55714_55736 = state_55706__$1;
(statearr_55714_55736[(2)] = inst_55690);

(statearr_55714_55736[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55707 === (2))){
var _ = (function (){var statearr_55715 = state_55706;
(statearr_55715[(4)] = cljs.core.cons.call(null,(5),(state_55706[(4)])));

return statearr_55715;
})();
var inst_55674 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_55706__$1 = state_55706;
if(inst_55674){
var statearr_55716_55737 = state_55706__$1;
(statearr_55716_55737[(1)] = (6));

} else {
var statearr_55717_55738 = state_55706__$1;
(statearr_55717_55738[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55707 === (11))){
var state_55706__$1 = state_55706;
var statearr_55719_55739 = state_55706__$1;
(statearr_55719_55739[(2)] = path);

(statearr_55719_55739[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55707 === (9))){
var inst_55677 = (state_55706[(2)]);
var inst_55678 = fluree.db.util.async.throw_err.call(null,inst_55677);
var state_55706__$1 = state_55706;
var statearr_55720_55740 = state_55706__$1;
(statearr_55720_55740[(2)] = inst_55678);

(statearr_55720_55740[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55707 === (5))){
var _ = (function (){var statearr_55721 = state_55706;
(statearr_55721[(4)] = cljs.core.rest.call(null,(state_55706[(4)])));

return statearr_55721;
})();
var state_55706__$1 = state_55706;
var ex55718 = (state_55706__$1[(2)]);
var statearr_55722_55741 = state_55706__$1;
(statearr_55722_55741[(5)] = ex55718);


if((ex55718 instanceof Error)){
var statearr_55723_55742 = state_55706__$1;
(statearr_55723_55742[(1)] = (4));

(statearr_55723_55742[(5)] = null);

} else {
throw ex55718;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55707 === (10))){
var state_55706__$1 = state_55706;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55706__$1,(13),path);
} else {
if((state_val_55707 === (8))){
var inst_55681 = (state_55706[(2)]);
var inst_55682 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_55706__$1 = (function (){var statearr_55724 = state_55706;
(statearr_55724[(7)] = inst_55681);

return statearr_55724;
})();
if(inst_55682){
var statearr_55725_55743 = state_55706__$1;
(statearr_55725_55743[(1)] = (10));

} else {
var statearr_55726_55744 = state_55706__$1;
(statearr_55726_55744[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____0 = (function (){
var statearr_55727 = [null,null,null,null,null,null,null,null,null];
(statearr_55727[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__);

(statearr_55727[(1)] = (1));

return statearr_55727;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____1 = (function (state_55706){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55706);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55728){var ex__2749__auto__ = e55728;
var statearr_55729_55745 = state_55706;
(statearr_55729_55745[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55706[(4)]))){
var statearr_55730_55746 = state_55706;
(statearr_55730_55746[(1)] = cljs.core.first.call(null,(state_55706[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55747 = state_55706;
state_55706 = G__55747;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__ = function(state_55706){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____1.call(this,state_55706);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55731 = f__2769__auto__.call(null);
(statearr_55731[(6)] = c__2768__auto__);

return statearr_55731;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a value from the user's context if set. Provide the key or key sequence.
 */
fluree.db.dbfunctions.fns.ctx = (function fluree$db$dbfunctions$fns$ctx(p__55748,key_or_ks){
var map__55749 = p__55748;
var map__55749__$1 = cljs.core.__destructure_map.call(null,map__55749);
var _QMARK_ctx = map__55749__$1;
var db = cljs.core.get.call(null,map__55749__$1,new cljs.core.Keyword(null,"db","db",993250759));
if(cljs.core.sequential_QMARK_.call(null,key_or_ks)){
return cljs.core.get_in.call(null,new cljs.core.Keyword(null,"ctx","ctx",-493610118).cljs$core$IFn$_invoke$arity$1(db),key_or_ks);
} else {
return cljs.core.get.call(null,new cljs.core.Keyword(null,"ctx","ctx",-493610118).cljs$core$IFn$_invoke$arity$1(db),key_or_ks);
}
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55794){
var state_val_55795 = (state_55794[(1)]);
if((state_val_55795 === (7))){
var state_55794__$1 = state_55794;
var statearr_55796_55825 = state_55794__$1;
(statearr_55796_55825[(2)] = coll);

(statearr_55796_55825[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55795 === (1))){
var state_55794__$1 = state_55794;
var statearr_55797_55826 = state_55794__$1;
(statearr_55797_55826[(2)] = null);

(statearr_55797_55826[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55795 === (4))){
var inst_55750 = (state_55794[(2)]);
var state_55794__$1 = state_55794;
var statearr_55798_55827 = state_55794__$1;
(statearr_55798_55827[(2)] = inst_55750);

(statearr_55798_55827[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55795 === (15))){
var inst_55770 = (state_55794[(7)]);
var inst_55778 = (state_55794[(2)]);
var inst_55779 = fluree.db.dbfunctions.internal.contains_QMARK_.call(null,inst_55770,inst_55778);
var inst_55780 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55781 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55782 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55783 = [inst_55770,inst_55778];
var inst_55784 = (new cljs.core.PersistentVector(null,2,(5),inst_55782,inst_55783,null));
var inst_55785 = ["contains?",inst_55784,inst_55779];
var inst_55786 = cljs.core.PersistentHashMap.fromArrays(inst_55781,inst_55785);
var inst_55787 = [inst_55786,(10)];
var inst_55788 = (new cljs.core.PersistentVector(null,2,(5),inst_55780,inst_55787,null));
var inst_55789 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55788);
var _ = (function (){var statearr_55799 = state_55794;
(statearr_55799[(4)] = cljs.core.rest.call(null,(state_55794[(4)])));

return statearr_55799;
})();
var state_55794__$1 = (function (){var statearr_55800 = state_55794;
(statearr_55800[(8)] = inst_55789);

return statearr_55800;
})();
var statearr_55801_55828 = state_55794__$1;
(statearr_55801_55828[(2)] = inst_55779);

(statearr_55801_55828[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55795 === (13))){
var state_55794__$1 = state_55794;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55794__$1,(16),key);
} else {
if((state_val_55795 === (6))){
var state_55794__$1 = state_55794;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55794__$1,(9),coll);
} else {
if((state_val_55795 === (3))){
var inst_55792 = (state_55794[(2)]);
var state_55794__$1 = state_55794;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55794__$1,inst_55792);
} else {
if((state_val_55795 === (12))){
var inst_55770 = (state_55794[(2)]);
var inst_55771 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_55794__$1 = (function (){var statearr_55802 = state_55794;
(statearr_55802[(7)] = inst_55770);

return statearr_55802;
})();
if(inst_55771){
var statearr_55803_55829 = state_55794__$1;
(statearr_55803_55829[(1)] = (13));

} else {
var statearr_55804_55830 = state_55794__$1;
(statearr_55804_55830[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55795 === (2))){
var _ = (function (){var statearr_55805 = state_55794;
(statearr_55805[(4)] = cljs.core.cons.call(null,(5),(state_55794[(4)])));

return statearr_55805;
})();
var inst_55756 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_55794__$1 = state_55794;
if(inst_55756){
var statearr_55806_55831 = state_55794__$1;
(statearr_55806_55831[(1)] = (6));

} else {
var statearr_55807_55832 = state_55794__$1;
(statearr_55807_55832[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55795 === (11))){
var inst_55763 = (state_55794[(9)]);
var inst_55767 = cljs.core.flatten.call(null,inst_55763);
var inst_55768 = cljs.core.set.call(null,inst_55767);
var state_55794__$1 = state_55794;
var statearr_55809_55833 = state_55794__$1;
(statearr_55809_55833[(2)] = inst_55768);

(statearr_55809_55833[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55795 === (9))){
var inst_55759 = (state_55794[(2)]);
var inst_55760 = fluree.db.util.async.throw_err.call(null,inst_55759);
var state_55794__$1 = state_55794;
var statearr_55810_55834 = state_55794__$1;
(statearr_55810_55834[(2)] = inst_55760);

(statearr_55810_55834[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55795 === (5))){
var _ = (function (){var statearr_55811 = state_55794;
(statearr_55811[(4)] = cljs.core.rest.call(null,(state_55794[(4)])));

return statearr_55811;
})();
var state_55794__$1 = state_55794;
var ex55808 = (state_55794__$1[(2)]);
var statearr_55812_55835 = state_55794__$1;
(statearr_55812_55835[(5)] = ex55808);


if((ex55808 instanceof Error)){
var statearr_55813_55836 = state_55794__$1;
(statearr_55813_55836[(1)] = (4));

(statearr_55813_55836[(5)] = null);

} else {
throw ex55808;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55795 === (14))){
var state_55794__$1 = state_55794;
var statearr_55814_55837 = state_55794__$1;
(statearr_55814_55837[(2)] = key);

(statearr_55814_55837[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55795 === (16))){
var inst_55774 = (state_55794[(2)]);
var inst_55775 = fluree.db.util.async.throw_err.call(null,inst_55774);
var state_55794__$1 = state_55794;
var statearr_55815_55838 = state_55794__$1;
(statearr_55815_55838[(2)] = inst_55775);

(statearr_55815_55838[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55795 === (10))){
var inst_55763 = (state_55794[(9)]);
var state_55794__$1 = state_55794;
var statearr_55816_55839 = state_55794__$1;
(statearr_55816_55839[(2)] = inst_55763);

(statearr_55816_55839[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55795 === (8))){
var inst_55763 = (state_55794[(9)]);
var inst_55763__$1 = (state_55794[(2)]);
var inst_55764 = cljs.core.set_QMARK_.call(null,inst_55763__$1);
var state_55794__$1 = (function (){var statearr_55817 = state_55794;
(statearr_55817[(9)] = inst_55763__$1);

return statearr_55817;
})();
if(inst_55764){
var statearr_55818_55840 = state_55794__$1;
(statearr_55818_55840[(1)] = (10));

} else {
var statearr_55819_55841 = state_55794__$1;
(statearr_55819_55841[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_55820 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55820[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__);

(statearr_55820[(1)] = (1));

return statearr_55820;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____1 = (function (state_55794){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55794);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55821){var ex__2749__auto__ = e55821;
var statearr_55822_55842 = state_55794;
(statearr_55822_55842[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55794[(4)]))){
var statearr_55823_55843 = state_55794;
(statearr_55823_55843[(1)] = cljs.core.first.call(null,(state_55794[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55844 = state_55794;
state_55794 = G__55844;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__ = function(state_55794){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____1.call(this,state_55794);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55824 = f__2769__auto__.call(null);
(statearr_55824[(6)] = c__2768__auto__);

return statearr_55824;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55916 = arguments.length;
var i__5770__auto___55917 = (0);
while(true){
if((i__5770__auto___55917 < len__5769__auto___55916)){
args__5775__auto__.push((arguments[i__5770__auto___55917]));

var G__55918 = (i__5770__auto___55917 + (1));
i__5770__auto___55917 = G__55918;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55890){
var state_val_55891 = (state_55890[(1)]);
if((state_val_55891 === (7))){
var inst_55856 = (state_55890[(7)]);
var inst_55860 = cljs.core.first.call(null,inst_55856);
var inst_55861 = cljs.core.coll_QMARK_.call(null,inst_55860);
var state_55890__$1 = state_55890;
var statearr_55892_55919 = state_55890__$1;
(statearr_55892_55919[(2)] = inst_55861);

(statearr_55892_55919[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (1))){
var state_55890__$1 = state_55890;
var statearr_55893_55920 = state_55890__$1;
(statearr_55893_55920[(2)] = null);

(statearr_55893_55920[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (4))){
var inst_55847 = (state_55890[(2)]);
var state_55890__$1 = state_55890;
var statearr_55894_55921 = state_55890__$1;
(statearr_55894_55921[(2)] = inst_55847);

(statearr_55894_55921[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (6))){
var inst_55858 = (state_55890[(8)]);
var inst_55856 = (state_55890[(7)]);
var inst_55855 = (state_55890[(2)]);
var inst_55856__$1 = fluree.db.util.async.throw_err.call(null,inst_55855);
var inst_55857 = cljs.core.count.call(null,inst_55856__$1);
var inst_55858__$1 = cljs.core._EQ_.call(null,(1),inst_55857);
var state_55890__$1 = (function (){var statearr_55895 = state_55890;
(statearr_55895[(8)] = inst_55858__$1);

(statearr_55895[(7)] = inst_55856__$1);

return statearr_55895;
})();
if(inst_55858__$1){
var statearr_55896_55922 = state_55890__$1;
(statearr_55896_55922[(1)] = (7));

} else {
var statearr_55897_55923 = state_55890__$1;
(statearr_55897_55923[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (3))){
var inst_55888 = (state_55890[(2)]);
var state_55890__$1 = state_55890;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55890__$1,inst_55888);
} else {
if((state_val_55891 === (12))){
var inst_55869 = (state_55890[(2)]);
var inst_55870 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.hash_set,inst_55869);
var inst_55871 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55872 = [inst_55869];
var inst_55873 = (new cljs.core.PersistentVector(null,1,(5),inst_55871,inst_55872,null));
var inst_55874 = cljs.core.count.call(null,inst_55873);
var inst_55875 = ((9) + inst_55874);
var inst_55876 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55877 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55878 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55879 = [inst_55869];
var inst_55880 = (new cljs.core.PersistentVector(null,1,(5),inst_55878,inst_55879,null));
var inst_55881 = ["hash-set",inst_55880,inst_55870];
var inst_55882 = cljs.core.PersistentHashMap.fromArrays(inst_55877,inst_55881);
var inst_55883 = [inst_55882,inst_55875];
var inst_55884 = (new cljs.core.PersistentVector(null,2,(5),inst_55876,inst_55883,null));
var inst_55885 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55884);
var _ = (function (){var statearr_55898 = state_55890;
(statearr_55898[(4)] = cljs.core.rest.call(null,(state_55890[(4)])));

return statearr_55898;
})();
var state_55890__$1 = (function (){var statearr_55899 = state_55890;
(statearr_55899[(9)] = inst_55885);

return statearr_55899;
})();
var statearr_55900_55924 = state_55890__$1;
(statearr_55900_55924[(2)] = inst_55870);

(statearr_55900_55924[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (2))){
var _ = (function (){var statearr_55901 = state_55890;
(statearr_55901[(4)] = cljs.core.cons.call(null,(5),(state_55890[(4)])));

return statearr_55901;
})();
var inst_55853 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55890__$1 = state_55890;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55890__$1,(6),inst_55853);
} else {
if((state_val_55891 === (11))){
var inst_55856 = (state_55890[(7)]);
var state_55890__$1 = state_55890;
var statearr_55903_55925 = state_55890__$1;
(statearr_55903_55925[(2)] = inst_55856);

(statearr_55903_55925[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (9))){
var inst_55864 = (state_55890[(2)]);
var state_55890__$1 = state_55890;
if(cljs.core.truth_(inst_55864)){
var statearr_55904_55926 = state_55890__$1;
(statearr_55904_55926[(1)] = (10));

} else {
var statearr_55905_55927 = state_55890__$1;
(statearr_55905_55927[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (5))){
var _ = (function (){var statearr_55906 = state_55890;
(statearr_55906[(4)] = cljs.core.rest.call(null,(state_55890[(4)])));

return statearr_55906;
})();
var state_55890__$1 = state_55890;
var ex55902 = (state_55890__$1[(2)]);
var statearr_55907_55928 = state_55890__$1;
(statearr_55907_55928[(5)] = ex55902);


if((ex55902 instanceof Error)){
var statearr_55908_55929 = state_55890__$1;
(statearr_55908_55929[(1)] = (4));

(statearr_55908_55929[(5)] = null);

} else {
throw ex55902;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (10))){
var inst_55856 = (state_55890[(7)]);
var inst_55866 = cljs.core.first.call(null,inst_55856);
var state_55890__$1 = state_55890;
var statearr_55909_55930 = state_55890__$1;
(statearr_55909_55930[(2)] = inst_55866);

(statearr_55909_55930[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (8))){
var inst_55858 = (state_55890[(8)]);
var state_55890__$1 = state_55890;
var statearr_55910_55931 = state_55890__$1;
(statearr_55910_55931[(2)] = inst_55858);

(statearr_55910_55931[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55911 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55911[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55911[(1)] = (1));

return statearr_55911;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55890){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55890);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55912){var ex__2749__auto__ = e55912;
var statearr_55913_55932 = state_55890;
(statearr_55913_55932[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55890[(4)]))){
var statearr_55914_55933 = state_55890;
(statearr_55914_55933[(1)] = cljs.core.first.call(null,(state_55890[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55934 = state_55890;
state_55890 = G__55934;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55890){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55890);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55915 = f__2769__auto__.call(null);
(statearr_55915[(6)] = c__2768__auto__);

return statearr_55915;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq55845){
var G__55846 = cljs.core.first.call(null,seq55845);
var seq55845__$1 = cljs.core.next.call(null,seq55845);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55846,seq55845__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55984 = arguments.length;
var i__5770__auto___55985 = (0);
while(true){
if((i__5770__auto___55985 < len__5769__auto___55984)){
args__5775__auto__.push((arguments[i__5770__auto___55985]));

var G__55986 = (i__5770__auto___55985 + (1));
i__5770__auto___55985 = G__55986;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55967){
var state_val_55968 = (state_55967[(1)]);
if((state_val_55968 === (1))){
var state_55967__$1 = state_55967;
var statearr_55969_55987 = state_55967__$1;
(statearr_55969_55987[(2)] = null);

(statearr_55969_55987[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55968 === (2))){
var _ = (function (){var statearr_55970 = state_55967;
(statearr_55970[(4)] = cljs.core.cons.call(null,(5),(state_55967[(4)])));

return statearr_55970;
})();
var inst_55943 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55967__$1 = state_55967;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55967__$1,(6),inst_55943);
} else {
if((state_val_55968 === (3))){
var inst_55965 = (state_55967[(2)]);
var state_55967__$1 = state_55967;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55967__$1,inst_55965);
} else {
if((state_val_55968 === (4))){
var inst_55937 = (state_55967[(2)]);
var state_55967__$1 = state_55967;
var statearr_55972_55988 = state_55967__$1;
(statearr_55972_55988[(2)] = inst_55937);

(statearr_55972_55988[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55968 === (5))){
var _ = (function (){var statearr_55973 = state_55967;
(statearr_55973[(4)] = cljs.core.rest.call(null,(state_55967[(4)])));

return statearr_55973;
})();
var state_55967__$1 = state_55967;
var ex55971 = (state_55967__$1[(2)]);
var statearr_55974_55989 = state_55967__$1;
(statearr_55974_55989[(5)] = ex55971);


if((ex55971 instanceof Error)){
var statearr_55975_55990 = state_55967__$1;
(statearr_55975_55990[(1)] = (4));

(statearr_55975_55990[(5)] = null);

} else {
throw ex55971;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55968 === (6))){
var inst_55945 = (state_55967[(2)]);
var inst_55946 = fluree.db.util.async.throw_err.call(null,inst_55945);
var inst_55947 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._EQ__EQ_,inst_55946);
var inst_55948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55949 = [inst_55946];
var inst_55950 = (new cljs.core.PersistentVector(null,1,(5),inst_55948,inst_55949,null));
var inst_55951 = cljs.core.count.call(null,inst_55950);
var inst_55952 = ((9) + inst_55951);
var inst_55953 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55954 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55955 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55956 = [inst_55946];
var inst_55957 = (new cljs.core.PersistentVector(null,1,(5),inst_55955,inst_55956,null));
var inst_55958 = ["==",inst_55957,inst_55947];
var inst_55959 = cljs.core.PersistentHashMap.fromArrays(inst_55954,inst_55958);
var inst_55960 = [inst_55959,inst_55952];
var inst_55961 = (new cljs.core.PersistentVector(null,2,(5),inst_55953,inst_55960,null));
var inst_55962 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55961);
var _ = (function (){var statearr_55976 = state_55967;
(statearr_55976[(4)] = cljs.core.rest.call(null,(state_55967[(4)])));

return statearr_55976;
})();
var state_55967__$1 = (function (){var statearr_55977 = state_55967;
(statearr_55977[(7)] = inst_55962);

return statearr_55977;
})();
var statearr_55978_55991 = state_55967__$1;
(statearr_55978_55991[(2)] = inst_55947);

(statearr_55978_55991[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55979 = [null,null,null,null,null,null,null,null];
(statearr_55979[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55979[(1)] = (1));

return statearr_55979;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55967){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55967);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55980){var ex__2749__auto__ = e55980;
var statearr_55981_55992 = state_55967;
(statearr_55981_55992[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55967[(4)]))){
var statearr_55982_55993 = state_55967;
(statearr_55982_55993[(1)] = cljs.core.first.call(null,(state_55967[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55994 = state_55967;
state_55967 = G__55994;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55967){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55967);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55983 = f__2769__auto__.call(null);
(statearr_55983[(6)] = c__2768__auto__);

return statearr_55983;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq55935){
var G__55936 = cljs.core.first.call(null,seq55935);
var seq55935__$1 = cljs.core.next.call(null,seq55935);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55936,seq55935__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56044 = arguments.length;
var i__5770__auto___56045 = (0);
while(true){
if((i__5770__auto___56045 < len__5769__auto___56044)){
args__5775__auto__.push((arguments[i__5770__auto___56045]));

var G__56046 = (i__5770__auto___56045 + (1));
i__5770__auto___56045 = G__56046;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56027){
var state_val_56028 = (state_56027[(1)]);
if((state_val_56028 === (1))){
var state_56027__$1 = state_56027;
var statearr_56029_56047 = state_56027__$1;
(statearr_56029_56047[(2)] = null);

(statearr_56029_56047[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56028 === (2))){
var _ = (function (){var statearr_56030 = state_56027;
(statearr_56030[(4)] = cljs.core.cons.call(null,(5),(state_56027[(4)])));

return statearr_56030;
})();
var inst_56003 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56027__$1 = state_56027;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56027__$1,(6),inst_56003);
} else {
if((state_val_56028 === (3))){
var inst_56025 = (state_56027[(2)]);
var state_56027__$1 = state_56027;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56027__$1,inst_56025);
} else {
if((state_val_56028 === (4))){
var inst_55997 = (state_56027[(2)]);
var state_56027__$1 = state_56027;
var statearr_56032_56048 = state_56027__$1;
(statearr_56032_56048[(2)] = inst_55997);

(statearr_56032_56048[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56028 === (5))){
var _ = (function (){var statearr_56033 = state_56027;
(statearr_56033[(4)] = cljs.core.rest.call(null,(state_56027[(4)])));

return statearr_56033;
})();
var state_56027__$1 = state_56027;
var ex56031 = (state_56027__$1[(2)]);
var statearr_56034_56049 = state_56027__$1;
(statearr_56034_56049[(5)] = ex56031);


if((ex56031 instanceof Error)){
var statearr_56035_56050 = state_56027__$1;
(statearr_56035_56050[(1)] = (4));

(statearr_56035_56050[(5)] = null);

} else {
throw ex56031;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56028 === (6))){
var inst_56005 = (state_56027[(2)]);
var inst_56006 = fluree.db.util.async.throw_err.call(null,inst_56005);
var inst_56007 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT_,inst_56006);
var inst_56008 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56009 = [inst_56006];
var inst_56010 = (new cljs.core.PersistentVector(null,1,(5),inst_56008,inst_56009,null));
var inst_56011 = cljs.core.count.call(null,inst_56010);
var inst_56012 = ((9) + inst_56011);
var inst_56013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56014 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56015 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56016 = [inst_56006];
var inst_56017 = (new cljs.core.PersistentVector(null,1,(5),inst_56015,inst_56016,null));
var inst_56018 = [">",inst_56017,inst_56007];
var inst_56019 = cljs.core.PersistentHashMap.fromArrays(inst_56014,inst_56018);
var inst_56020 = [inst_56019,inst_56012];
var inst_56021 = (new cljs.core.PersistentVector(null,2,(5),inst_56013,inst_56020,null));
var inst_56022 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56021);
var _ = (function (){var statearr_56036 = state_56027;
(statearr_56036[(4)] = cljs.core.rest.call(null,(state_56027[(4)])));

return statearr_56036;
})();
var state_56027__$1 = (function (){var statearr_56037 = state_56027;
(statearr_56037[(7)] = inst_56022);

return statearr_56037;
})();
var statearr_56038_56051 = state_56027__$1;
(statearr_56038_56051[(2)] = inst_56007);

(statearr_56038_56051[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_56039 = [null,null,null,null,null,null,null,null];
(statearr_56039[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_56039[(1)] = (1));

return statearr_56039;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_56027){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56027);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56040){var ex__2749__auto__ = e56040;
var statearr_56041_56052 = state_56027;
(statearr_56041_56052[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56027[(4)]))){
var statearr_56042_56053 = state_56027;
(statearr_56042_56053[(1)] = cljs.core.first.call(null,(state_56027[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56054 = state_56027;
state_56027 = G__56054;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_56027){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_56027);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56043 = f__2769__auto__.call(null);
(statearr_56043[(6)] = c__2768__auto__);

return statearr_56043;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq55995){
var G__55996 = cljs.core.first.call(null,seq55995);
var seq55995__$1 = cljs.core.next.call(null,seq55995);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55996,seq55995__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56104 = arguments.length;
var i__5770__auto___56105 = (0);
while(true){
if((i__5770__auto___56105 < len__5769__auto___56104)){
args__5775__auto__.push((arguments[i__5770__auto___56105]));

var G__56106 = (i__5770__auto___56105 + (1));
i__5770__auto___56105 = G__56106;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56087){
var state_val_56088 = (state_56087[(1)]);
if((state_val_56088 === (1))){
var state_56087__$1 = state_56087;
var statearr_56089_56107 = state_56087__$1;
(statearr_56089_56107[(2)] = null);

(statearr_56089_56107[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56088 === (2))){
var _ = (function (){var statearr_56090 = state_56087;
(statearr_56090[(4)] = cljs.core.cons.call(null,(5),(state_56087[(4)])));

return statearr_56090;
})();
var inst_56063 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56087__$1 = state_56087;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56087__$1,(6),inst_56063);
} else {
if((state_val_56088 === (3))){
var inst_56085 = (state_56087[(2)]);
var state_56087__$1 = state_56087;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56087__$1,inst_56085);
} else {
if((state_val_56088 === (4))){
var inst_56057 = (state_56087[(2)]);
var state_56087__$1 = state_56087;
var statearr_56092_56108 = state_56087__$1;
(statearr_56092_56108[(2)] = inst_56057);

(statearr_56092_56108[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56088 === (5))){
var _ = (function (){var statearr_56093 = state_56087;
(statearr_56093[(4)] = cljs.core.rest.call(null,(state_56087[(4)])));

return statearr_56093;
})();
var state_56087__$1 = state_56087;
var ex56091 = (state_56087__$1[(2)]);
var statearr_56094_56109 = state_56087__$1;
(statearr_56094_56109[(5)] = ex56091);


if((ex56091 instanceof Error)){
var statearr_56095_56110 = state_56087__$1;
(statearr_56095_56110[(1)] = (4));

(statearr_56095_56110[(5)] = null);

} else {
throw ex56091;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56088 === (6))){
var inst_56065 = (state_56087[(2)]);
var inst_56066 = fluree.db.util.async.throw_err.call(null,inst_56065);
var inst_56067 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT_,inst_56066);
var inst_56068 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56069 = [inst_56066];
var inst_56070 = (new cljs.core.PersistentVector(null,1,(5),inst_56068,inst_56069,null));
var inst_56071 = cljs.core.count.call(null,inst_56070);
var inst_56072 = ((9) + inst_56071);
var inst_56073 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56074 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56075 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56076 = [inst_56066];
var inst_56077 = (new cljs.core.PersistentVector(null,1,(5),inst_56075,inst_56076,null));
var inst_56078 = ["<",inst_56077,inst_56067];
var inst_56079 = cljs.core.PersistentHashMap.fromArrays(inst_56074,inst_56078);
var inst_56080 = [inst_56079,inst_56072];
var inst_56081 = (new cljs.core.PersistentVector(null,2,(5),inst_56073,inst_56080,null));
var inst_56082 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56081);
var _ = (function (){var statearr_56096 = state_56087;
(statearr_56096[(4)] = cljs.core.rest.call(null,(state_56087[(4)])));

return statearr_56096;
})();
var state_56087__$1 = (function (){var statearr_56097 = state_56087;
(statearr_56097[(7)] = inst_56082);

return statearr_56097;
})();
var statearr_56098_56111 = state_56087__$1;
(statearr_56098_56111[(2)] = inst_56067);

(statearr_56098_56111[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_56099 = [null,null,null,null,null,null,null,null];
(statearr_56099[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_56099[(1)] = (1));

return statearr_56099;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_56087){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56087);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56100){var ex__2749__auto__ = e56100;
var statearr_56101_56112 = state_56087;
(statearr_56101_56112[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56087[(4)]))){
var statearr_56102_56113 = state_56087;
(statearr_56102_56113[(1)] = cljs.core.first.call(null,(state_56087[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56114 = state_56087;
state_56087 = G__56114;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_56087){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_56087);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56103 = f__2769__auto__.call(null);
(statearr_56103[(6)] = c__2768__auto__);

return statearr_56103;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq56055){
var G__56056 = cljs.core.first.call(null,seq56055);
var seq56055__$1 = cljs.core.next.call(null,seq56055);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56056,seq56055__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56164 = arguments.length;
var i__5770__auto___56165 = (0);
while(true){
if((i__5770__auto___56165 < len__5769__auto___56164)){
args__5775__auto__.push((arguments[i__5770__auto___56165]));

var G__56166 = (i__5770__auto___56165 + (1));
i__5770__auto___56165 = G__56166;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56147){
var state_val_56148 = (state_56147[(1)]);
if((state_val_56148 === (1))){
var state_56147__$1 = state_56147;
var statearr_56149_56167 = state_56147__$1;
(statearr_56149_56167[(2)] = null);

(statearr_56149_56167[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56148 === (2))){
var _ = (function (){var statearr_56150 = state_56147;
(statearr_56150[(4)] = cljs.core.cons.call(null,(5),(state_56147[(4)])));

return statearr_56150;
})();
var inst_56123 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56147__$1 = state_56147;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56147__$1,(6),inst_56123);
} else {
if((state_val_56148 === (3))){
var inst_56145 = (state_56147[(2)]);
var state_56147__$1 = state_56147;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56147__$1,inst_56145);
} else {
if((state_val_56148 === (4))){
var inst_56117 = (state_56147[(2)]);
var state_56147__$1 = state_56147;
var statearr_56152_56168 = state_56147__$1;
(statearr_56152_56168[(2)] = inst_56117);

(statearr_56152_56168[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56148 === (5))){
var _ = (function (){var statearr_56153 = state_56147;
(statearr_56153[(4)] = cljs.core.rest.call(null,(state_56147[(4)])));

return statearr_56153;
})();
var state_56147__$1 = state_56147;
var ex56151 = (state_56147__$1[(2)]);
var statearr_56154_56169 = state_56147__$1;
(statearr_56154_56169[(5)] = ex56151);


if((ex56151 instanceof Error)){
var statearr_56155_56170 = state_56147__$1;
(statearr_56155_56170[(1)] = (4));

(statearr_56155_56170[(5)] = null);

} else {
throw ex56151;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56148 === (6))){
var inst_56125 = (state_56147[(2)]);
var inst_56126 = fluree.db.util.async.throw_err.call(null,inst_56125);
var inst_56127 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT__EQ_,inst_56126);
var inst_56128 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56129 = [inst_56126];
var inst_56130 = (new cljs.core.PersistentVector(null,1,(5),inst_56128,inst_56129,null));
var inst_56131 = cljs.core.count.call(null,inst_56130);
var inst_56132 = ((9) + inst_56131);
var inst_56133 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56134 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56135 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56136 = [inst_56126];
var inst_56137 = (new cljs.core.PersistentVector(null,1,(5),inst_56135,inst_56136,null));
var inst_56138 = ["<=",inst_56137,inst_56127];
var inst_56139 = cljs.core.PersistentHashMap.fromArrays(inst_56134,inst_56138);
var inst_56140 = [inst_56139,inst_56132];
var inst_56141 = (new cljs.core.PersistentVector(null,2,(5),inst_56133,inst_56140,null));
var inst_56142 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56141);
var _ = (function (){var statearr_56156 = state_56147;
(statearr_56156[(4)] = cljs.core.rest.call(null,(state_56147[(4)])));

return statearr_56156;
})();
var state_56147__$1 = (function (){var statearr_56157 = state_56147;
(statearr_56157[(7)] = inst_56142);

return statearr_56157;
})();
var statearr_56158_56171 = state_56147__$1;
(statearr_56158_56171[(2)] = inst_56127);

(statearr_56158_56171[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_56159 = [null,null,null,null,null,null,null,null];
(statearr_56159[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_56159[(1)] = (1));

return statearr_56159;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_56147){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56147);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56160){var ex__2749__auto__ = e56160;
var statearr_56161_56172 = state_56147;
(statearr_56161_56172[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56147[(4)]))){
var statearr_56162_56173 = state_56147;
(statearr_56162_56173[(1)] = cljs.core.first.call(null,(state_56147[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56174 = state_56147;
state_56147 = G__56174;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_56147){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_56147);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56163 = f__2769__auto__.call(null);
(statearr_56163[(6)] = c__2768__auto__);

return statearr_56163;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq56115){
var G__56116 = cljs.core.first.call(null,seq56115);
var seq56115__$1 = cljs.core.next.call(null,seq56115);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56116,seq56115__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56224 = arguments.length;
var i__5770__auto___56225 = (0);
while(true){
if((i__5770__auto___56225 < len__5769__auto___56224)){
args__5775__auto__.push((arguments[i__5770__auto___56225]));

var G__56226 = (i__5770__auto___56225 + (1));
i__5770__auto___56225 = G__56226;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56207){
var state_val_56208 = (state_56207[(1)]);
if((state_val_56208 === (1))){
var state_56207__$1 = state_56207;
var statearr_56209_56227 = state_56207__$1;
(statearr_56209_56227[(2)] = null);

(statearr_56209_56227[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56208 === (2))){
var _ = (function (){var statearr_56210 = state_56207;
(statearr_56210[(4)] = cljs.core.cons.call(null,(5),(state_56207[(4)])));

return statearr_56210;
})();
var inst_56183 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56207__$1 = state_56207;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56207__$1,(6),inst_56183);
} else {
if((state_val_56208 === (3))){
var inst_56205 = (state_56207[(2)]);
var state_56207__$1 = state_56207;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56207__$1,inst_56205);
} else {
if((state_val_56208 === (4))){
var inst_56177 = (state_56207[(2)]);
var state_56207__$1 = state_56207;
var statearr_56212_56228 = state_56207__$1;
(statearr_56212_56228[(2)] = inst_56177);

(statearr_56212_56228[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56208 === (5))){
var _ = (function (){var statearr_56213 = state_56207;
(statearr_56213[(4)] = cljs.core.rest.call(null,(state_56207[(4)])));

return statearr_56213;
})();
var state_56207__$1 = state_56207;
var ex56211 = (state_56207__$1[(2)]);
var statearr_56214_56229 = state_56207__$1;
(statearr_56214_56229[(5)] = ex56211);


if((ex56211 instanceof Error)){
var statearr_56215_56230 = state_56207__$1;
(statearr_56215_56230[(1)] = (4));

(statearr_56215_56230[(5)] = null);

} else {
throw ex56211;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56208 === (6))){
var inst_56185 = (state_56207[(2)]);
var inst_56186 = fluree.db.util.async.throw_err.call(null,inst_56185);
var inst_56187 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT__EQ_,inst_56186);
var inst_56188 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56189 = [inst_56186];
var inst_56190 = (new cljs.core.PersistentVector(null,1,(5),inst_56188,inst_56189,null));
var inst_56191 = cljs.core.count.call(null,inst_56190);
var inst_56192 = ((9) + inst_56191);
var inst_56193 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56194 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56195 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56196 = [inst_56186];
var inst_56197 = (new cljs.core.PersistentVector(null,1,(5),inst_56195,inst_56196,null));
var inst_56198 = [">=",inst_56197,inst_56187];
var inst_56199 = cljs.core.PersistentHashMap.fromArrays(inst_56194,inst_56198);
var inst_56200 = [inst_56199,inst_56192];
var inst_56201 = (new cljs.core.PersistentVector(null,2,(5),inst_56193,inst_56200,null));
var inst_56202 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56201);
var _ = (function (){var statearr_56216 = state_56207;
(statearr_56216[(4)] = cljs.core.rest.call(null,(state_56207[(4)])));

return statearr_56216;
})();
var state_56207__$1 = (function (){var statearr_56217 = state_56207;
(statearr_56217[(7)] = inst_56202);

return statearr_56217;
})();
var statearr_56218_56231 = state_56207__$1;
(statearr_56218_56231[(2)] = inst_56187);

(statearr_56218_56231[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_56219 = [null,null,null,null,null,null,null,null];
(statearr_56219[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_56219[(1)] = (1));

return statearr_56219;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_56207){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56207);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56220){var ex__2749__auto__ = e56220;
var statearr_56221_56232 = state_56207;
(statearr_56221_56232[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56207[(4)]))){
var statearr_56222_56233 = state_56207;
(statearr_56222_56233[(1)] = cljs.core.first.call(null,(state_56207[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56234 = state_56207;
state_56207 = G__56234;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_56207){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_56207);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56223 = f__2769__auto__.call(null);
(statearr_56223[(6)] = c__2768__auto__);

return statearr_56223;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq56175){
var G__56176 = cljs.core.first.call(null,seq56175);
var seq56175__$1 = cljs.core.next.call(null,seq56175);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56176,seq56175__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56284 = arguments.length;
var i__5770__auto___56285 = (0);
while(true){
if((i__5770__auto___56285 < len__5769__auto___56284)){
args__5775__auto__.push((arguments[i__5770__auto___56285]));

var G__56286 = (i__5770__auto___56285 + (1));
i__5770__auto___56285 = G__56286;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56267){
var state_val_56268 = (state_56267[(1)]);
if((state_val_56268 === (1))){
var state_56267__$1 = state_56267;
var statearr_56269_56287 = state_56267__$1;
(statearr_56269_56287[(2)] = null);

(statearr_56269_56287[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56268 === (2))){
var _ = (function (){var statearr_56270 = state_56267;
(statearr_56270[(4)] = cljs.core.cons.call(null,(5),(state_56267[(4)])));

return statearr_56270;
})();
var inst_56243 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56267__$1 = state_56267;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56267__$1,(6),inst_56243);
} else {
if((state_val_56268 === (3))){
var inst_56265 = (state_56267[(2)]);
var state_56267__$1 = state_56267;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56267__$1,inst_56265);
} else {
if((state_val_56268 === (4))){
var inst_56237 = (state_56267[(2)]);
var state_56267__$1 = state_56267;
var statearr_56272_56288 = state_56267__$1;
(statearr_56272_56288[(2)] = inst_56237);

(statearr_56272_56288[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56268 === (5))){
var _ = (function (){var statearr_56273 = state_56267;
(statearr_56273[(4)] = cljs.core.rest.call(null,(state_56267[(4)])));

return statearr_56273;
})();
var state_56267__$1 = state_56267;
var ex56271 = (state_56267__$1[(2)]);
var statearr_56274_56289 = state_56267__$1;
(statearr_56274_56289[(5)] = ex56271);


if((ex56271 instanceof Error)){
var statearr_56275_56290 = state_56267__$1;
(statearr_56275_56290[(1)] = (4));

(statearr_56275_56290[(5)] = null);

} else {
throw ex56271;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56268 === (6))){
var inst_56245 = (state_56267[(2)]);
var inst_56246 = fluree.db.util.async.throw_err.call(null,inst_56245);
var inst_56247 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.not_EQ_,inst_56246);
var inst_56248 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56249 = [inst_56246];
var inst_56250 = (new cljs.core.PersistentVector(null,1,(5),inst_56248,inst_56249,null));
var inst_56251 = cljs.core.count.call(null,inst_56250);
var inst_56252 = ((9) + inst_56251);
var inst_56253 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56254 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56255 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56256 = [inst_56246];
var inst_56257 = (new cljs.core.PersistentVector(null,1,(5),inst_56255,inst_56256,null));
var inst_56258 = ["not=",inst_56257,inst_56247];
var inst_56259 = cljs.core.PersistentHashMap.fromArrays(inst_56254,inst_56258);
var inst_56260 = [inst_56259,inst_56252];
var inst_56261 = (new cljs.core.PersistentVector(null,2,(5),inst_56253,inst_56260,null));
var inst_56262 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56261);
var _ = (function (){var statearr_56276 = state_56267;
(statearr_56276[(4)] = cljs.core.rest.call(null,(state_56267[(4)])));

return statearr_56276;
})();
var state_56267__$1 = (function (){var statearr_56277 = state_56267;
(statearr_56277[(7)] = inst_56262);

return statearr_56277;
})();
var statearr_56278_56291 = state_56267__$1;
(statearr_56278_56291[(2)] = inst_56247);

(statearr_56278_56291[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_56279 = [null,null,null,null,null,null,null,null];
(statearr_56279[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_56279[(1)] = (1));

return statearr_56279;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_56267){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56267);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56280){var ex__2749__auto__ = e56280;
var statearr_56281_56292 = state_56267;
(statearr_56281_56292[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56267[(4)]))){
var statearr_56282_56293 = state_56267;
(statearr_56282_56293[(1)] = cljs.core.first.call(null,(state_56267[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56294 = state_56267;
state_56267 = G__56294;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_56267){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_56267);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56283 = f__2769__auto__.call(null);
(statearr_56283[(6)] = c__2768__auto__);

return statearr_56283;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq56235){
var G__56236 = cljs.core.first.call(null,seq56235);
var seq56235__$1 = cljs.core.next.call(null,seq56235);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56236,seq56235__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56344 = arguments.length;
var i__5770__auto___56345 = (0);
while(true){
if((i__5770__auto___56345 < len__5769__auto___56344)){
args__5775__auto__.push((arguments[i__5770__auto___56345]));

var G__56346 = (i__5770__auto___56345 + (1));
i__5770__auto___56345 = G__56346;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56327){
var state_val_56328 = (state_56327[(1)]);
if((state_val_56328 === (1))){
var state_56327__$1 = state_56327;
var statearr_56329_56347 = state_56327__$1;
(statearr_56329_56347[(2)] = null);

(statearr_56329_56347[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56328 === (2))){
var _ = (function (){var statearr_56330 = state_56327;
(statearr_56330[(4)] = cljs.core.cons.call(null,(5),(state_56327[(4)])));

return statearr_56330;
})();
var inst_56303 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56327__$1 = state_56327;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56327__$1,(6),inst_56303);
} else {
if((state_val_56328 === (3))){
var inst_56325 = (state_56327[(2)]);
var state_56327__$1 = state_56327;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56327__$1,inst_56325);
} else {
if((state_val_56328 === (4))){
var inst_56297 = (state_56327[(2)]);
var state_56327__$1 = state_56327;
var statearr_56332_56348 = state_56327__$1;
(statearr_56332_56348[(2)] = inst_56297);

(statearr_56332_56348[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56328 === (5))){
var _ = (function (){var statearr_56333 = state_56327;
(statearr_56333[(4)] = cljs.core.rest.call(null,(state_56327[(4)])));

return statearr_56333;
})();
var state_56327__$1 = state_56327;
var ex56331 = (state_56327__$1[(2)]);
var statearr_56334_56349 = state_56327__$1;
(statearr_56334_56349[(5)] = ex56331);


if((ex56331 instanceof Error)){
var statearr_56335_56350 = state_56327__$1;
(statearr_56335_56350[(1)] = (4));

(statearr_56335_56350[(5)] = null);

} else {
throw ex56331;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56328 === (6))){
var inst_56305 = (state_56327[(2)]);
var inst_56306 = fluree.db.util.async.throw_err.call(null,inst_56305);
var inst_56307 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_56306);
var inst_56308 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56309 = [inst_56306];
var inst_56310 = (new cljs.core.PersistentVector(null,1,(5),inst_56308,inst_56309,null));
var inst_56311 = cljs.core.count.call(null,inst_56310);
var inst_56312 = ((9) + inst_56311);
var inst_56313 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56314 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56315 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56316 = [inst_56306];
var inst_56317 = (new cljs.core.PersistentVector(null,1,(5),inst_56315,inst_56316,null));
var inst_56318 = ["max",inst_56317,inst_56307];
var inst_56319 = cljs.core.PersistentHashMap.fromArrays(inst_56314,inst_56318);
var inst_56320 = [inst_56319,inst_56312];
var inst_56321 = (new cljs.core.PersistentVector(null,2,(5),inst_56313,inst_56320,null));
var inst_56322 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56321);
var _ = (function (){var statearr_56336 = state_56327;
(statearr_56336[(4)] = cljs.core.rest.call(null,(state_56327[(4)])));

return statearr_56336;
})();
var state_56327__$1 = (function (){var statearr_56337 = state_56327;
(statearr_56337[(7)] = inst_56322);

return statearr_56337;
})();
var statearr_56338_56351 = state_56327__$1;
(statearr_56338_56351[(2)] = inst_56307);

(statearr_56338_56351[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_56339 = [null,null,null,null,null,null,null,null];
(statearr_56339[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_56339[(1)] = (1));

return statearr_56339;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_56327){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56327);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56340){var ex__2749__auto__ = e56340;
var statearr_56341_56352 = state_56327;
(statearr_56341_56352[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56327[(4)]))){
var statearr_56342_56353 = state_56327;
(statearr_56342_56353[(1)] = cljs.core.first.call(null,(state_56327[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56354 = state_56327;
state_56327 = G__56354;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_56327){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_56327);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56343 = f__2769__auto__.call(null);
(statearr_56343[(6)] = c__2768__auto__);

return statearr_56343;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq56295){
var G__56296 = cljs.core.first.call(null,seq56295);
var seq56295__$1 = cljs.core.next.call(null,seq56295);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56296,seq56295__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56404 = arguments.length;
var i__5770__auto___56405 = (0);
while(true){
if((i__5770__auto___56405 < len__5769__auto___56404)){
args__5775__auto__.push((arguments[i__5770__auto___56405]));

var G__56406 = (i__5770__auto___56405 + (1));
i__5770__auto___56405 = G__56406;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56387){
var state_val_56388 = (state_56387[(1)]);
if((state_val_56388 === (1))){
var state_56387__$1 = state_56387;
var statearr_56389_56407 = state_56387__$1;
(statearr_56389_56407[(2)] = null);

(statearr_56389_56407[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56388 === (2))){
var _ = (function (){var statearr_56390 = state_56387;
(statearr_56390[(4)] = cljs.core.cons.call(null,(5),(state_56387[(4)])));

return statearr_56390;
})();
var inst_56363 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56387__$1 = state_56387;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56387__$1,(6),inst_56363);
} else {
if((state_val_56388 === (3))){
var inst_56385 = (state_56387[(2)]);
var state_56387__$1 = state_56387;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56387__$1,inst_56385);
} else {
if((state_val_56388 === (4))){
var inst_56357 = (state_56387[(2)]);
var state_56387__$1 = state_56387;
var statearr_56392_56408 = state_56387__$1;
(statearr_56392_56408[(2)] = inst_56357);

(statearr_56392_56408[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56388 === (5))){
var _ = (function (){var statearr_56393 = state_56387;
(statearr_56393[(4)] = cljs.core.rest.call(null,(state_56387[(4)])));

return statearr_56393;
})();
var state_56387__$1 = state_56387;
var ex56391 = (state_56387__$1[(2)]);
var statearr_56394_56409 = state_56387__$1;
(statearr_56394_56409[(5)] = ex56391);


if((ex56391 instanceof Error)){
var statearr_56395_56410 = state_56387__$1;
(statearr_56395_56410[(1)] = (4));

(statearr_56395_56410[(5)] = null);

} else {
throw ex56391;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56388 === (6))){
var inst_56365 = (state_56387[(2)]);
var inst_56366 = fluree.db.util.async.throw_err.call(null,inst_56365);
var inst_56367 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.min,inst_56366);
var inst_56368 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56369 = [inst_56366];
var inst_56370 = (new cljs.core.PersistentVector(null,1,(5),inst_56368,inst_56369,null));
var inst_56371 = cljs.core.count.call(null,inst_56370);
var inst_56372 = ((9) + inst_56371);
var inst_56373 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56374 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56375 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56376 = [inst_56366];
var inst_56377 = (new cljs.core.PersistentVector(null,1,(5),inst_56375,inst_56376,null));
var inst_56378 = ["min",inst_56377,inst_56367];
var inst_56379 = cljs.core.PersistentHashMap.fromArrays(inst_56374,inst_56378);
var inst_56380 = [inst_56379,inst_56372];
var inst_56381 = (new cljs.core.PersistentVector(null,2,(5),inst_56373,inst_56380,null));
var inst_56382 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56381);
var _ = (function (){var statearr_56396 = state_56387;
(statearr_56396[(4)] = cljs.core.rest.call(null,(state_56387[(4)])));

return statearr_56396;
})();
var state_56387__$1 = (function (){var statearr_56397 = state_56387;
(statearr_56397[(7)] = inst_56382);

return statearr_56397;
})();
var statearr_56398_56411 = state_56387__$1;
(statearr_56398_56411[(2)] = inst_56367);

(statearr_56398_56411[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_56399 = [null,null,null,null,null,null,null,null];
(statearr_56399[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_56399[(1)] = (1));

return statearr_56399;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_56387){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56387);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56400){var ex__2749__auto__ = e56400;
var statearr_56401_56412 = state_56387;
(statearr_56401_56412[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56387[(4)]))){
var statearr_56402_56413 = state_56387;
(statearr_56402_56413[(1)] = cljs.core.first.call(null,(state_56387[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56414 = state_56387;
state_56387 = G__56414;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_56387){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_56387);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56403 = f__2769__auto__.call(null);
(statearr_56403[(6)] = c__2768__auto__);

return statearr_56403;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq56355){
var G__56356 = cljs.core.first.call(null,seq56355);
var seq56355__$1 = cljs.core.next.call(null,seq56355);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56356,seq56355__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__56416 = arguments.length;
switch (G__56416) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56461){
var state_val_56462 = (state_56461[(1)]);
if((state_val_56462 === (7))){
var state_56461__$1 = state_56461;
var statearr_56463_56600 = state_56461__$1;
(statearr_56463_56600[(2)] = query_map);

(statearr_56463_56600[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56462 === (1))){
var state_56461__$1 = state_56461;
var statearr_56464_56601 = state_56461__$1;
(statearr_56464_56601[(2)] = null);

(statearr_56464_56601[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56462 === (4))){
var inst_56417 = (state_56461[(2)]);
var state_56461__$1 = state_56461;
var statearr_56465_56602 = state_56461__$1;
(statearr_56465_56602[(2)] = inst_56417);

(statearr_56465_56602[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56462 === (13))){
var inst_56439 = (state_56461[(7)]);
var inst_56443 = (state_56461[(2)]);
var inst_56444 = fluree.db.util.async.throw_err.call(null,inst_56443);
var inst_56445 = cljs.core.nth.call(null,inst_56444,(0),null);
var inst_56446 = cljs.core.nth.call(null,inst_56444,(1),null);
var inst_56447 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56448 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56449 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56450 = [inst_56439];
var inst_56451 = (new cljs.core.PersistentVector(null,1,(5),inst_56449,inst_56450,null));
var inst_56452 = ["query",inst_56451,inst_56445];
var inst_56453 = cljs.core.PersistentHashMap.fromArrays(inst_56448,inst_56452);
var inst_56454 = [inst_56453,inst_56446];
var inst_56455 = (new cljs.core.PersistentVector(null,2,(5),inst_56447,inst_56454,null));
var inst_56456 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56455);
var _ = (function (){var statearr_56466 = state_56461;
(statearr_56466[(4)] = cljs.core.rest.call(null,(state_56461[(4)])));

return statearr_56466;
})();
var state_56461__$1 = (function (){var statearr_56467 = state_56461;
(statearr_56467[(8)] = inst_56456);

return statearr_56467;
})();
var statearr_56468_56603 = state_56461__$1;
(statearr_56468_56603[(2)] = inst_56445);

(statearr_56468_56603[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56462 === (6))){
var state_56461__$1 = state_56461;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56461__$1,(9),query_map);
} else {
if((state_val_56462 === (3))){
var inst_56459 = (state_56461[(2)]);
var state_56461__$1 = state_56461;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56461__$1,inst_56459);
} else {
if((state_val_56462 === (12))){
var inst_56439 = (state_56461[(7)]);
var inst_56439__$1 = (state_56461[(2)]);
var inst_56440 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56441 = fluree.db.dbfunctions.internal.query.call(null,inst_56440,inst_56439__$1);
var state_56461__$1 = (function (){var statearr_56469 = state_56461;
(statearr_56469[(7)] = inst_56439__$1);

return statearr_56469;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56461__$1,(13),inst_56441);
} else {
if((state_val_56462 === (2))){
var _ = (function (){var statearr_56470 = state_56461;
(statearr_56470[(4)] = cljs.core.cons.call(null,(5),(state_56461[(4)])));

return statearr_56470;
})();
var inst_56426 = fluree.db.util.async.channel_QMARK_.call(null,query_map);
var state_56461__$1 = state_56461;
if(inst_56426){
var statearr_56471_56604 = state_56461__$1;
(statearr_56471_56604[(1)] = (6));

} else {
var statearr_56472_56605 = state_56461__$1;
(statearr_56472_56605[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56462 === (11))){
var inst_56433 = (state_56461[(9)]);
var state_56461__$1 = state_56461;
var statearr_56474_56606 = state_56461__$1;
(statearr_56474_56606[(2)] = inst_56433);

(statearr_56474_56606[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56462 === (9))){
var inst_56429 = (state_56461[(2)]);
var inst_56430 = fluree.db.util.async.throw_err.call(null,inst_56429);
var state_56461__$1 = state_56461;
var statearr_56475_56607 = state_56461__$1;
(statearr_56475_56607[(2)] = inst_56430);

(statearr_56475_56607[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56462 === (5))){
var _ = (function (){var statearr_56476 = state_56461;
(statearr_56476[(4)] = cljs.core.rest.call(null,(state_56461[(4)])));

return statearr_56476;
})();
var state_56461__$1 = state_56461;
var ex56473 = (state_56461__$1[(2)]);
var statearr_56477_56608 = state_56461__$1;
(statearr_56477_56608[(5)] = ex56473);


if((ex56473 instanceof Error)){
var statearr_56478_56609 = state_56461__$1;
(statearr_56478_56609[(1)] = (4));

(statearr_56478_56609[(5)] = null);

} else {
throw ex56473;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56462 === (10))){
var inst_56433 = (state_56461[(9)]);
var inst_56436 = fluree.db.util.json.parse.call(null,inst_56433);
var state_56461__$1 = state_56461;
var statearr_56479_56610 = state_56461__$1;
(statearr_56479_56610[(2)] = inst_56436);

(statearr_56479_56610[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56462 === (8))){
var inst_56433 = (state_56461[(9)]);
var inst_56433__$1 = (state_56461[(2)]);
var inst_56434 = typeof inst_56433__$1 === 'string';
var state_56461__$1 = (function (){var statearr_56480 = state_56461;
(statearr_56480[(9)] = inst_56433__$1);

return statearr_56480;
})();
if(cljs.core.truth_(inst_56434)){
var statearr_56481_56611 = state_56461__$1;
(statearr_56481_56611[(1)] = (10));

} else {
var statearr_56482_56612 = state_56461__$1;
(statearr_56482_56612[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_56483 = [null,null,null,null,null,null,null,null,null,null];
(statearr_56483[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_56483[(1)] = (1));

return statearr_56483;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_56461){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56461);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56484){var ex__2749__auto__ = e56484;
var statearr_56485_56613 = state_56461;
(statearr_56485_56613[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56461[(4)]))){
var statearr_56486_56614 = state_56461;
(statearr_56486_56614[(1)] = cljs.core.first.call(null,(state_56461[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56615 = state_56461;
state_56461 = G__56615;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_56461){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_56461);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56487 = f__2769__auto__.call(null);
(statearr_56487[(6)] = c__2768__auto__);

return statearr_56487;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56558){
var state_val_56559 = (state_56558[(1)]);
if((state_val_56559 === (7))){
var state_56558__$1 = state_56558;
var statearr_56560_56616 = state_56558__$1;
(statearr_56560_56616[(2)] = select);

(statearr_56560_56616[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56559 === (20))){
var inst_56528 = (state_56558[(2)]);
var inst_56529 = fluree.db.util.async.channel_QMARK_.call(null,limit);
var state_56558__$1 = (function (){var statearr_56561 = state_56558;
(statearr_56561[(7)] = inst_56528);

return statearr_56561;
})();
if(inst_56529){
var statearr_56562_56617 = state_56558__$1;
(statearr_56562_56617[(1)] = (22));

} else {
var statearr_56563_56618 = state_56558__$1;
(statearr_56563_56618[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56559 === (1))){
var state_56558__$1 = state_56558;
var statearr_56564_56619 = state_56558__$1;
(statearr_56564_56619[(2)] = null);

(statearr_56564_56619[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56559 === (24))){
var inst_56520 = (state_56558[(8)]);
var inst_56528 = (state_56558[(7)]);
var inst_56504 = (state_56558[(9)]);
var inst_56512 = (state_56558[(10)]);
var inst_56536 = (state_56558[(2)]);
var inst_56537 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56538 = fluree.db.dbfunctions.internal.query.call(null,inst_56537,inst_56504,inst_56512,inst_56520,inst_56528,inst_56536);
var state_56558__$1 = state_56558;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56558__$1,(26),inst_56538);
} else {
if((state_val_56559 === (4))){
var inst_56488 = (state_56558[(2)]);
var state_56558__$1 = state_56558;
var statearr_56565_56620 = state_56558__$1;
(statearr_56565_56620[(2)] = inst_56488);

(statearr_56565_56620[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56559 === (15))){
var state_56558__$1 = state_56558;
var statearr_56566_56621 = state_56558__$1;
(statearr_56566_56621[(2)] = where);

(statearr_56566_56621[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56559 === (21))){
var inst_56524 = (state_56558[(2)]);
var inst_56525 = fluree.db.util.async.throw_err.call(null,inst_56524);
var state_56558__$1 = state_56558;
var statearr_56567_56622 = state_56558__$1;
(statearr_56567_56622[(2)] = inst_56525);

(statearr_56567_56622[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56559 === (13))){
var inst_56508 = (state_56558[(2)]);
var inst_56509 = fluree.db.util.async.throw_err.call(null,inst_56508);
var state_56558__$1 = state_56558;
var statearr_56568_56623 = state_56558__$1;
(statearr_56568_56623[(2)] = inst_56509);

(statearr_56568_56623[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56559 === (22))){
var state_56558__$1 = state_56558;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56558__$1,(25),limit);
} else {
if((state_val_56559 === (6))){
var state_56558__$1 = state_56558;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56558__$1,(9),select);
} else {
if((state_val_56559 === (25))){
var inst_56532 = (state_56558[(2)]);
var inst_56533 = fluree.db.util.async.throw_err.call(null,inst_56532);
var state_56558__$1 = state_56558;
var statearr_56569_56624 = state_56558__$1;
(statearr_56569_56624[(2)] = inst_56533);

(statearr_56569_56624[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56559 === (17))){
var inst_56516 = (state_56558[(2)]);
var inst_56517 = fluree.db.util.async.throw_err.call(null,inst_56516);
var state_56558__$1 = state_56558;
var statearr_56570_56625 = state_56558__$1;
(statearr_56570_56625[(2)] = inst_56517);

(statearr_56570_56625[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56559 === (3))){
var inst_56556 = (state_56558[(2)]);
var state_56558__$1 = state_56558;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56558__$1,inst_56556);
} else {
if((state_val_56559 === (12))){
var inst_56512 = (state_56558[(2)]);
var inst_56513 = fluree.db.util.async.channel_QMARK_.call(null,where);
var state_56558__$1 = (function (){var statearr_56571 = state_56558;
(statearr_56571[(10)] = inst_56512);

return statearr_56571;
})();
if(inst_56513){
var statearr_56572_56626 = state_56558__$1;
(statearr_56572_56626[(1)] = (14));

} else {
var statearr_56573_56627 = state_56558__$1;
(statearr_56573_56627[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56559 === (2))){
var _ = (function (){var statearr_56574 = state_56558;
(statearr_56574[(4)] = cljs.core.cons.call(null,(5),(state_56558[(4)])));

return statearr_56574;
})();
var inst_56497 = fluree.db.util.async.channel_QMARK_.call(null,select);
var state_56558__$1 = state_56558;
if(inst_56497){
var statearr_56575_56628 = state_56558__$1;
(statearr_56575_56628[(1)] = (6));

} else {
var statearr_56576_56629 = state_56558__$1;
(statearr_56576_56629[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56559 === (23))){
var state_56558__$1 = state_56558;
var statearr_56577_56630 = state_56558__$1;
(statearr_56577_56630[(2)] = limit);

(statearr_56577_56630[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56559 === (19))){
var state_56558__$1 = state_56558;
var statearr_56578_56631 = state_56558__$1;
(statearr_56578_56631[(2)] = block);

(statearr_56578_56631[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56559 === (11))){
var state_56558__$1 = state_56558;
var statearr_56580_56632 = state_56558__$1;
(statearr_56580_56632[(2)] = from);

(statearr_56580_56632[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56559 === (9))){
var inst_56500 = (state_56558[(2)]);
var inst_56501 = fluree.db.util.async.throw_err.call(null,inst_56500);
var state_56558__$1 = state_56558;
var statearr_56581_56633 = state_56558__$1;
(statearr_56581_56633[(2)] = inst_56501);

(statearr_56581_56633[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56559 === (5))){
var _ = (function (){var statearr_56582 = state_56558;
(statearr_56582[(4)] = cljs.core.rest.call(null,(state_56558[(4)])));

return statearr_56582;
})();
var state_56558__$1 = state_56558;
var ex56579 = (state_56558__$1[(2)]);
var statearr_56583_56634 = state_56558__$1;
(statearr_56583_56634[(5)] = ex56579);


if((ex56579 instanceof Error)){
var statearr_56584_56635 = state_56558__$1;
(statearr_56584_56635[(1)] = (4));

(statearr_56584_56635[(5)] = null);

} else {
throw ex56579;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56559 === (14))){
var state_56558__$1 = state_56558;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56558__$1,(17),where);
} else {
if((state_val_56559 === (26))){
var inst_56520 = (state_56558[(8)]);
var inst_56528 = (state_56558[(7)]);
var inst_56504 = (state_56558[(9)]);
var inst_56512 = (state_56558[(10)]);
var inst_56540 = (state_56558[(2)]);
var inst_56541 = fluree.db.util.async.throw_err.call(null,inst_56540);
var inst_56542 = cljs.core.nth.call(null,inst_56541,(0),null);
var inst_56543 = cljs.core.nth.call(null,inst_56541,(1),null);
var inst_56544 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56545 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56546 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56547 = [inst_56504,inst_56512,inst_56520,inst_56528];
var inst_56548 = (new cljs.core.PersistentVector(null,4,(5),inst_56546,inst_56547,null));
var inst_56549 = ["query",inst_56548,inst_56542];
var inst_56550 = cljs.core.PersistentHashMap.fromArrays(inst_56545,inst_56549);
var inst_56551 = [inst_56550,inst_56543];
var inst_56552 = (new cljs.core.PersistentVector(null,2,(5),inst_56544,inst_56551,null));
var inst_56553 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56552);
var _ = (function (){var statearr_56585 = state_56558;
(statearr_56585[(4)] = cljs.core.rest.call(null,(state_56558[(4)])));

return statearr_56585;
})();
var state_56558__$1 = (function (){var statearr_56586 = state_56558;
(statearr_56586[(11)] = inst_56553);

return statearr_56586;
})();
var statearr_56587_56636 = state_56558__$1;
(statearr_56587_56636[(2)] = inst_56542);

(statearr_56587_56636[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56559 === (16))){
var inst_56520 = (state_56558[(2)]);
var inst_56521 = fluree.db.util.async.channel_QMARK_.call(null,block);
var state_56558__$1 = (function (){var statearr_56588 = state_56558;
(statearr_56588[(8)] = inst_56520);

return statearr_56588;
})();
if(inst_56521){
var statearr_56589_56637 = state_56558__$1;
(statearr_56589_56637[(1)] = (18));

} else {
var statearr_56590_56638 = state_56558__$1;
(statearr_56590_56638[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56559 === (10))){
var state_56558__$1 = state_56558;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56558__$1,(13),from);
} else {
if((state_val_56559 === (18))){
var state_56558__$1 = state_56558;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56558__$1,(21),block);
} else {
if((state_val_56559 === (8))){
var inst_56504 = (state_56558[(2)]);
var inst_56505 = fluree.db.util.async.channel_QMARK_.call(null,from);
var state_56558__$1 = (function (){var statearr_56591 = state_56558;
(statearr_56591[(9)] = inst_56504);

return statearr_56591;
})();
if(inst_56505){
var statearr_56592_56639 = state_56558__$1;
(statearr_56592_56639[(1)] = (10));

} else {
var statearr_56593_56640 = state_56558__$1;
(statearr_56593_56640[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_56594 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56594[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_56594[(1)] = (1));

return statearr_56594;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_56558){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56558);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56595){var ex__2749__auto__ = e56595;
var statearr_56596_56641 = state_56558;
(statearr_56596_56641[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56558[(4)]))){
var statearr_56597_56642 = state_56558;
(statearr_56597_56642[(1)] = cljs.core.first.call(null,(state_56558[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56643 = state_56558;
state_56558 = G__56643;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_56558){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_56558);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56598 = f__2769__auto__.call(null);
(statearr_56598[(6)] = c__2768__auto__);

return statearr_56598;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56699){
var state_val_56700 = (state_56699[(1)]);
if((state_val_56700 === (7))){
var state_56699__$1 = state_56699;
var statearr_56701_56732 = state_56699__$1;
(statearr_56701_56732[(2)] = startSubject);

(statearr_56701_56732[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56700 === (1))){
var state_56699__$1 = state_56699;
var statearr_56702_56733 = state_56699__$1;
(statearr_56702_56733[(2)] = null);

(statearr_56702_56733[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56700 === (4))){
var inst_56644 = (state_56699[(2)]);
var state_56699__$1 = state_56699;
var statearr_56703_56734 = state_56699__$1;
(statearr_56703_56734[(2)] = inst_56644);

(statearr_56703_56734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56700 === (15))){
var inst_56676 = (state_56699[(2)]);
var inst_56677 = fluree.db.util.async.throw_err.call(null,inst_56676);
var inst_56678 = cljs.core.nth.call(null,inst_56677,(0),null);
var inst_56679 = cljs.core.nth.call(null,inst_56677,(1),null);
var inst_56680 = cljs.core.empty_QMARK_.call(null,inst_56678);
var state_56699__$1 = (function (){var statearr_56704 = state_56699;
(statearr_56704[(7)] = inst_56679);

return statearr_56704;
})();
if(inst_56680){
var statearr_56705_56735 = state_56699__$1;
(statearr_56705_56735[(1)] = (16));

} else {
var statearr_56706_56736 = state_56699__$1;
(statearr_56706_56736[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56700 === (13))){
var inst_56664 = (state_56699[(8)]);
var inst_56660 = (state_56699[(9)]);
var inst_56672 = (state_56699[(10)]);
var inst_56672__$1 = (state_56699[(2)]);
var inst_56673 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56674 = fluree.db.dbfunctions.internal.relationship_QMARK_.call(null,inst_56673,inst_56660,inst_56664,inst_56672__$1);
var state_56699__$1 = (function (){var statearr_56707 = state_56699;
(statearr_56707[(10)] = inst_56672__$1);

return statearr_56707;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56699__$1,(15),inst_56674);
} else {
if((state_val_56700 === (6))){
var state_56699__$1 = state_56699;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56699__$1,(9),startSubject);
} else {
if((state_val_56700 === (17))){
var state_56699__$1 = state_56699;
var statearr_56708_56737 = state_56699__$1;
(statearr_56708_56737[(2)] = true);

(statearr_56708_56737[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56700 === (3))){
var inst_56697 = (state_56699[(2)]);
var state_56699__$1 = state_56699;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56699__$1,inst_56697);
} else {
if((state_val_56700 === (12))){
var state_56699__$1 = state_56699;
var statearr_56709_56738 = state_56699__$1;
(statearr_56709_56738[(2)] = endSubject);

(statearr_56709_56738[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56700 === (2))){
var _ = (function (){var statearr_56710 = state_56699;
(statearr_56710[(4)] = cljs.core.cons.call(null,(5),(state_56699[(4)])));

return statearr_56710;
})();
var inst_56653 = fluree.db.util.async.channel_QMARK_.call(null,startSubject);
var state_56699__$1 = state_56699;
if(inst_56653){
var statearr_56711_56739 = state_56699__$1;
(statearr_56711_56739[(1)] = (6));

} else {
var statearr_56712_56740 = state_56699__$1;
(statearr_56712_56740[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56700 === (11))){
var state_56699__$1 = state_56699;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56699__$1,(14),endSubject);
} else {
if((state_val_56700 === (9))){
var inst_56656 = (state_56699[(2)]);
var inst_56657 = fluree.db.util.async.throw_err.call(null,inst_56656);
var state_56699__$1 = state_56699;
var statearr_56714_56741 = state_56699__$1;
(statearr_56714_56741[(2)] = inst_56657);

(statearr_56714_56741[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56700 === (5))){
var _ = (function (){var statearr_56715 = state_56699;
(statearr_56715[(4)] = cljs.core.rest.call(null,(state_56699[(4)])));

return statearr_56715;
})();
var state_56699__$1 = state_56699;
var ex56713 = (state_56699__$1[(2)]);
var statearr_56716_56742 = state_56699__$1;
(statearr_56716_56742[(5)] = ex56713);


if((ex56713 instanceof Error)){
var statearr_56717_56743 = state_56699__$1;
(statearr_56717_56743[(1)] = (4));

(statearr_56717_56743[(5)] = null);

} else {
throw ex56713;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56700 === (14))){
var inst_56668 = (state_56699[(2)]);
var inst_56669 = fluree.db.util.async.throw_err.call(null,inst_56668);
var state_56699__$1 = state_56699;
var statearr_56718_56744 = state_56699__$1;
(statearr_56718_56744[(2)] = inst_56669);

(statearr_56718_56744[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56700 === (16))){
var state_56699__$1 = state_56699;
var statearr_56719_56745 = state_56699__$1;
(statearr_56719_56745[(2)] = false);

(statearr_56719_56745[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56700 === (10))){
var inst_56663 = (state_56699[(2)]);
var inst_56664 = fluree.db.util.async.throw_err.call(null,inst_56663);
var inst_56665 = fluree.db.util.async.channel_QMARK_.call(null,endSubject);
var state_56699__$1 = (function (){var statearr_56720 = state_56699;
(statearr_56720[(8)] = inst_56664);

return statearr_56720;
})();
if(inst_56665){
var statearr_56721_56746 = state_56699__$1;
(statearr_56721_56746[(1)] = (11));

} else {
var statearr_56722_56747 = state_56699__$1;
(statearr_56722_56747[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56700 === (18))){
var inst_56664 = (state_56699[(8)]);
var inst_56679 = (state_56699[(7)]);
var inst_56660 = (state_56699[(9)]);
var inst_56672 = (state_56699[(10)]);
var inst_56684 = (state_56699[(2)]);
var inst_56685 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56686 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56687 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56688 = [inst_56660,inst_56664,inst_56672];
var inst_56689 = (new cljs.core.PersistentVector(null,3,(5),inst_56687,inst_56688,null));
var inst_56690 = ["relationship?",inst_56689,inst_56684];
var inst_56691 = cljs.core.PersistentHashMap.fromArrays(inst_56686,inst_56690);
var inst_56692 = [inst_56691,inst_56679];
var inst_56693 = (new cljs.core.PersistentVector(null,2,(5),inst_56685,inst_56692,null));
var inst_56694 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56693);
var _ = (function (){var statearr_56723 = state_56699;
(statearr_56723[(4)] = cljs.core.rest.call(null,(state_56699[(4)])));

return statearr_56723;
})();
var state_56699__$1 = (function (){var statearr_56724 = state_56699;
(statearr_56724[(11)] = inst_56694);

return statearr_56724;
})();
var statearr_56725_56748 = state_56699__$1;
(statearr_56725_56748[(2)] = inst_56684);

(statearr_56725_56748[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56700 === (8))){
var inst_56660 = (state_56699[(2)]);
var inst_56661 = fluree.db.dbfunctions.fns.coerce_args.call(null,path);
var state_56699__$1 = (function (){var statearr_56726 = state_56699;
(statearr_56726[(9)] = inst_56660);

return statearr_56726;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56699__$1,(10),inst_56661);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_56727 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56727[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__);

(statearr_56727[(1)] = (1));

return statearr_56727;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____1 = (function (state_56699){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56699);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56728){var ex__2749__auto__ = e56728;
var statearr_56729_56749 = state_56699;
(statearr_56729_56749[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56699[(4)]))){
var statearr_56730_56750 = state_56699;
(statearr_56730_56750[(1)] = cljs.core.first.call(null,(state_56699[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56751 = state_56699;
state_56699 = G__56751;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__ = function(state_56699){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____1.call(this,state_56699);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56731 = f__2769__auto__.call(null);
(statearr_56731[(6)] = c__2768__auto__);

return statearr_56731;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56788){
var state_val_56789 = (state_56788[(1)]);
if((state_val_56789 === (7))){
var state_56788__$1 = state_56788;
var statearr_56790_56810 = state_56788__$1;
(statearr_56790_56810[(2)] = pred_name);

(statearr_56790_56810[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56789 === (1))){
var state_56788__$1 = state_56788;
var statearr_56791_56811 = state_56788__$1;
(statearr_56791_56811[(2)] = null);

(statearr_56791_56811[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56789 === (4))){
var inst_56752 = (state_56788[(2)]);
var state_56788__$1 = state_56788;
var statearr_56792_56812 = state_56788__$1;
(statearr_56792_56812[(2)] = inst_56752);

(statearr_56792_56812[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56789 === (6))){
var state_56788__$1 = state_56788;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56788__$1,(9),pred_name);
} else {
if((state_val_56789 === (3))){
var inst_56786 = (state_56788[(2)]);
var state_56788__$1 = state_56788;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56788__$1,inst_56786);
} else {
if((state_val_56789 === (2))){
var _ = (function (){var statearr_56794 = state_56788;
(statearr_56794[(4)] = cljs.core.cons.call(null,(5),(state_56788[(4)])));

return statearr_56794;
})();
var inst_56761 = fluree.db.util.async.channel_QMARK_.call(null,pred_name);
var state_56788__$1 = state_56788;
if(inst_56761){
var statearr_56795_56813 = state_56788__$1;
(statearr_56795_56813[(1)] = (6));

} else {
var statearr_56796_56814 = state_56788__$1;
(statearr_56796_56814[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56789 === (9))){
var inst_56764 = (state_56788[(2)]);
var inst_56765 = fluree.db.util.async.throw_err.call(null,inst_56764);
var state_56788__$1 = state_56788;
var statearr_56797_56815 = state_56788__$1;
(statearr_56797_56815[(2)] = inst_56765);

(statearr_56797_56815[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56789 === (5))){
var _ = (function (){var statearr_56798 = state_56788;
(statearr_56798[(4)] = cljs.core.rest.call(null,(state_56788[(4)])));

return statearr_56798;
})();
var state_56788__$1 = state_56788;
var ex56793 = (state_56788__$1[(2)]);
var statearr_56799_56816 = state_56788__$1;
(statearr_56799_56816[(5)] = ex56793);


if((ex56793 instanceof Error)){
var statearr_56800_56817 = state_56788__$1;
(statearr_56800_56817[(1)] = (4));

(statearr_56800_56817[(5)] = null);

} else {
throw ex56793;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56789 === (10))){
var inst_56768 = (state_56788[(7)]);
var inst_56772 = (state_56788[(2)]);
var inst_56773 = fluree.db.util.async.throw_err.call(null,inst_56772);
var inst_56774 = cljs.core.nth.call(null,inst_56773,(0),null);
var inst_56775 = cljs.core.nth.call(null,inst_56773,(1),null);
var inst_56776 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56777 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56778 = ["max-pred-val",inst_56768,inst_56774];
var inst_56779 = cljs.core.PersistentHashMap.fromArrays(inst_56777,inst_56778);
var inst_56780 = (inst_56775 + (10));
var inst_56781 = [inst_56779,inst_56780];
var inst_56782 = (new cljs.core.PersistentVector(null,2,(5),inst_56776,inst_56781,null));
var inst_56783 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56782);
var _ = (function (){var statearr_56801 = state_56788;
(statearr_56801[(4)] = cljs.core.rest.call(null,(state_56788[(4)])));

return statearr_56801;
})();
var state_56788__$1 = (function (){var statearr_56802 = state_56788;
(statearr_56802[(8)] = inst_56783);

return statearr_56802;
})();
var statearr_56803_56818 = state_56788__$1;
(statearr_56803_56818[(2)] = inst_56774);

(statearr_56803_56818[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56789 === (8))){
var inst_56768 = (state_56788[(7)]);
var inst_56768__$1 = (state_56788[(2)]);
var inst_56769 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56770 = fluree.db.dbfunctions.internal.max_pred_val.call(null,inst_56769,inst_56768__$1,null);
var state_56788__$1 = (function (){var statearr_56804 = state_56788;
(statearr_56804[(7)] = inst_56768__$1);

return statearr_56804;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56788__$1,(10),inst_56770);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____0 = (function (){
var statearr_56805 = [null,null,null,null,null,null,null,null,null];
(statearr_56805[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__);

(statearr_56805[(1)] = (1));

return statearr_56805;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____1 = (function (state_56788){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56788);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56806){var ex__2749__auto__ = e56806;
var statearr_56807_56819 = state_56788;
(statearr_56807_56819[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56788[(4)]))){
var statearr_56808_56820 = state_56788;
(statearr_56808_56820[(1)] = cljs.core.first.call(null,(state_56788[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56821 = state_56788;
state_56788 = G__56821;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__ = function(state_56788){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____1.call(this,state_56788);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56809 = f__2769__auto__.call(null);
(statearr_56809[(6)] = c__2768__auto__);

return statearr_56809;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56848){
var state_val_56849 = (state_56848[(1)]);
if((state_val_56849 === (7))){
var state_56848__$1 = state_56848;
var statearr_56850_56869 = state_56848__$1;
(statearr_56850_56869[(2)] = n);

(statearr_56850_56869[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56849 === (1))){
var state_56848__$1 = state_56848;
var statearr_56851_56870 = state_56848__$1;
(statearr_56851_56870[(2)] = null);

(statearr_56851_56870[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56849 === (4))){
var inst_56822 = (state_56848[(2)]);
var state_56848__$1 = state_56848;
var statearr_56852_56871 = state_56848__$1;
(statearr_56852_56871[(2)] = inst_56822);

(statearr_56852_56871[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56849 === (6))){
var state_56848__$1 = state_56848;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56848__$1,(9),n);
} else {
if((state_val_56849 === (3))){
var inst_56846 = (state_56848[(2)]);
var state_56848__$1 = state_56848;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56848__$1,inst_56846);
} else {
if((state_val_56849 === (2))){
var _ = (function (){var statearr_56854 = state_56848;
(statearr_56854[(4)] = cljs.core.cons.call(null,(5),(state_56848[(4)])));

return statearr_56854;
})();
var inst_56828 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_56848__$1 = state_56848;
if(inst_56828){
var statearr_56855_56872 = state_56848__$1;
(statearr_56855_56872[(1)] = (6));

} else {
var statearr_56856_56873 = state_56848__$1;
(statearr_56856_56873[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56849 === (9))){
var inst_56831 = (state_56848[(2)]);
var inst_56832 = fluree.db.util.async.throw_err.call(null,inst_56831);
var state_56848__$1 = state_56848;
var statearr_56857_56874 = state_56848__$1;
(statearr_56857_56874[(2)] = inst_56832);

(statearr_56857_56874[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56849 === (5))){
var _ = (function (){var statearr_56858 = state_56848;
(statearr_56858[(4)] = cljs.core.rest.call(null,(state_56848[(4)])));

return statearr_56858;
})();
var state_56848__$1 = state_56848;
var ex56853 = (state_56848__$1[(2)]);
var statearr_56859_56875 = state_56848__$1;
(statearr_56859_56875[(5)] = ex56853);


if((ex56853 instanceof Error)){
var statearr_56860_56876 = state_56848__$1;
(statearr_56860_56876[(1)] = (4));

(statearr_56860_56876[(5)] = null);

} else {
throw ex56853;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56849 === (8))){
var inst_56835 = (state_56848[(2)]);
var inst_56836 = fluree.db.dbfunctions.internal.inc.call(null,inst_56835);
var inst_56837 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56838 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56839 = ["inc",inst_56835,inst_56836];
var inst_56840 = cljs.core.PersistentHashMap.fromArrays(inst_56838,inst_56839);
var inst_56841 = [inst_56840,(10)];
var inst_56842 = (new cljs.core.PersistentVector(null,2,(5),inst_56837,inst_56841,null));
var inst_56843 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56842);
var _ = (function (){var statearr_56861 = state_56848;
(statearr_56861[(4)] = cljs.core.rest.call(null,(state_56848[(4)])));

return statearr_56861;
})();
var state_56848__$1 = (function (){var statearr_56862 = state_56848;
(statearr_56862[(7)] = inst_56843);

return statearr_56862;
})();
var statearr_56863_56877 = state_56848__$1;
(statearr_56863_56877[(2)] = inst_56836);

(statearr_56863_56877[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____0 = (function (){
var statearr_56864 = [null,null,null,null,null,null,null,null];
(statearr_56864[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__);

(statearr_56864[(1)] = (1));

return statearr_56864;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____1 = (function (state_56848){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56848);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56865){var ex__2749__auto__ = e56865;
var statearr_56866_56878 = state_56848;
(statearr_56866_56878[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56848[(4)]))){
var statearr_56867_56879 = state_56848;
(statearr_56867_56879[(1)] = cljs.core.first.call(null,(state_56848[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56880 = state_56848;
state_56848 = G__56880;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__ = function(state_56848){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____1.call(this,state_56848);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56868 = f__2769__auto__.call(null);
(statearr_56868[(6)] = c__2768__auto__);

return statearr_56868;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56907){
var state_val_56908 = (state_56907[(1)]);
if((state_val_56908 === (7))){
var state_56907__$1 = state_56907;
var statearr_56909_56928 = state_56907__$1;
(statearr_56909_56928[(2)] = n);

(statearr_56909_56928[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56908 === (1))){
var state_56907__$1 = state_56907;
var statearr_56910_56929 = state_56907__$1;
(statearr_56910_56929[(2)] = null);

(statearr_56910_56929[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56908 === (4))){
var inst_56881 = (state_56907[(2)]);
var state_56907__$1 = state_56907;
var statearr_56911_56930 = state_56907__$1;
(statearr_56911_56930[(2)] = inst_56881);

(statearr_56911_56930[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56908 === (6))){
var state_56907__$1 = state_56907;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56907__$1,(9),n);
} else {
if((state_val_56908 === (3))){
var inst_56905 = (state_56907[(2)]);
var state_56907__$1 = state_56907;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56907__$1,inst_56905);
} else {
if((state_val_56908 === (2))){
var _ = (function (){var statearr_56913 = state_56907;
(statearr_56913[(4)] = cljs.core.cons.call(null,(5),(state_56907[(4)])));

return statearr_56913;
})();
var inst_56887 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_56907__$1 = state_56907;
if(inst_56887){
var statearr_56914_56931 = state_56907__$1;
(statearr_56914_56931[(1)] = (6));

} else {
var statearr_56915_56932 = state_56907__$1;
(statearr_56915_56932[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56908 === (9))){
var inst_56890 = (state_56907[(2)]);
var inst_56891 = fluree.db.util.async.throw_err.call(null,inst_56890);
var state_56907__$1 = state_56907;
var statearr_56916_56933 = state_56907__$1;
(statearr_56916_56933[(2)] = inst_56891);

(statearr_56916_56933[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56908 === (5))){
var _ = (function (){var statearr_56917 = state_56907;
(statearr_56917[(4)] = cljs.core.rest.call(null,(state_56907[(4)])));

return statearr_56917;
})();
var state_56907__$1 = state_56907;
var ex56912 = (state_56907__$1[(2)]);
var statearr_56918_56934 = state_56907__$1;
(statearr_56918_56934[(5)] = ex56912);


if((ex56912 instanceof Error)){
var statearr_56919_56935 = state_56907__$1;
(statearr_56919_56935[(1)] = (4));

(statearr_56919_56935[(5)] = null);

} else {
throw ex56912;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56908 === (8))){
var inst_56894 = (state_56907[(2)]);
var inst_56895 = fluree.db.dbfunctions.internal.dec.call(null,inst_56894);
var inst_56896 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56897 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56898 = ["dec",inst_56894,inst_56895];
var inst_56899 = cljs.core.PersistentHashMap.fromArrays(inst_56897,inst_56898);
var inst_56900 = [inst_56899,(10)];
var inst_56901 = (new cljs.core.PersistentVector(null,2,(5),inst_56896,inst_56900,null));
var inst_56902 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56901);
var _ = (function (){var statearr_56920 = state_56907;
(statearr_56920[(4)] = cljs.core.rest.call(null,(state_56907[(4)])));

return statearr_56920;
})();
var state_56907__$1 = (function (){var statearr_56921 = state_56907;
(statearr_56921[(7)] = inst_56902);

return statearr_56921;
})();
var statearr_56922_56936 = state_56907__$1;
(statearr_56922_56936[(2)] = inst_56895);

(statearr_56922_56936[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____0 = (function (){
var statearr_56923 = [null,null,null,null,null,null,null,null];
(statearr_56923[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__);

(statearr_56923[(1)] = (1));

return statearr_56923;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____1 = (function (state_56907){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56907);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56924){var ex__2749__auto__ = e56924;
var statearr_56925_56937 = state_56907;
(statearr_56925_56937[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56907[(4)]))){
var statearr_56926_56938 = state_56907;
(statearr_56926_56938[(1)] = cljs.core.first.call(null,(state_56907[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56939 = state_56907;
state_56907 = G__56939;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__ = function(state_56907){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____1.call(this,state_56907);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56927 = f__2769__auto__.call(null);
(statearr_56927[(6)] = c__2768__auto__);

return statearr_56927;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56989 = arguments.length;
var i__5770__auto___56990 = (0);
while(true){
if((i__5770__auto___56990 < len__5769__auto___56989)){
args__5775__auto__.push((arguments[i__5770__auto___56990]));

var G__56991 = (i__5770__auto___56990 + (1));
i__5770__auto___56990 = G__56991;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56972){
var state_val_56973 = (state_56972[(1)]);
if((state_val_56973 === (1))){
var state_56972__$1 = state_56972;
var statearr_56974_56992 = state_56972__$1;
(statearr_56974_56992[(2)] = null);

(statearr_56974_56992[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56973 === (2))){
var _ = (function (){var statearr_56975 = state_56972;
(statearr_56975[(4)] = cljs.core.cons.call(null,(5),(state_56972[(4)])));

return statearr_56975;
})();
var inst_56948 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56972__$1 = state_56972;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56972__$1,(6),inst_56948);
} else {
if((state_val_56973 === (3))){
var inst_56970 = (state_56972[(2)]);
var state_56972__$1 = state_56972;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56972__$1,inst_56970);
} else {
if((state_val_56973 === (4))){
var inst_56942 = (state_56972[(2)]);
var state_56972__$1 = state_56972;
var statearr_56977_56993 = state_56972__$1;
(statearr_56977_56993[(2)] = inst_56942);

(statearr_56977_56993[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56973 === (5))){
var _ = (function (){var statearr_56978 = state_56972;
(statearr_56978[(4)] = cljs.core.rest.call(null,(state_56972[(4)])));

return statearr_56978;
})();
var state_56972__$1 = state_56972;
var ex56976 = (state_56972__$1[(2)]);
var statearr_56979_56994 = state_56972__$1;
(statearr_56979_56994[(5)] = ex56976);


if((ex56976 instanceof Error)){
var statearr_56980_56995 = state_56972__$1;
(statearr_56980_56995[(1)] = (4));

(statearr_56980_56995[(5)] = null);

} else {
throw ex56976;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56973 === (6))){
var inst_56950 = (state_56972[(2)]);
var inst_56951 = fluree.db.util.async.throw_err.call(null,inst_56950);
var inst_56952 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._PLUS_,inst_56951);
var inst_56953 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56954 = [inst_56951];
var inst_56955 = (new cljs.core.PersistentVector(null,1,(5),inst_56953,inst_56954,null));
var inst_56956 = cljs.core.count.call(null,inst_56955);
var inst_56957 = ((9) + inst_56956);
var inst_56958 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56959 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56960 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56961 = [inst_56951];
var inst_56962 = (new cljs.core.PersistentVector(null,1,(5),inst_56960,inst_56961,null));
var inst_56963 = ["+",inst_56962,inst_56952];
var inst_56964 = cljs.core.PersistentHashMap.fromArrays(inst_56959,inst_56963);
var inst_56965 = [inst_56964,inst_56957];
var inst_56966 = (new cljs.core.PersistentVector(null,2,(5),inst_56958,inst_56965,null));
var inst_56967 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56966);
var _ = (function (){var statearr_56981 = state_56972;
(statearr_56981[(4)] = cljs.core.rest.call(null,(state_56972[(4)])));

return statearr_56981;
})();
var state_56972__$1 = (function (){var statearr_56982 = state_56972;
(statearr_56982[(7)] = inst_56967);

return statearr_56982;
})();
var statearr_56983_56996 = state_56972__$1;
(statearr_56983_56996[(2)] = inst_56952);

(statearr_56983_56996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_56984 = [null,null,null,null,null,null,null,null];
(statearr_56984[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_56984[(1)] = (1));

return statearr_56984;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_56972){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56972);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56985){var ex__2749__auto__ = e56985;
var statearr_56986_56997 = state_56972;
(statearr_56986_56997[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56972[(4)]))){
var statearr_56987_56998 = state_56972;
(statearr_56987_56998[(1)] = cljs.core.first.call(null,(state_56972[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56999 = state_56972;
state_56972 = G__56999;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_56972){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_56972);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56988 = f__2769__auto__.call(null);
(statearr_56988[(6)] = c__2768__auto__);

return statearr_56988;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq56940){
var G__56941 = cljs.core.first.call(null,seq56940);
var seq56940__$1 = cljs.core.next.call(null,seq56940);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56941,seq56940__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___57049 = arguments.length;
var i__5770__auto___57050 = (0);
while(true){
if((i__5770__auto___57050 < len__5769__auto___57049)){
args__5775__auto__.push((arguments[i__5770__auto___57050]));

var G__57051 = (i__5770__auto___57050 + (1));
i__5770__auto___57050 = G__57051;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57032){
var state_val_57033 = (state_57032[(1)]);
if((state_val_57033 === (1))){
var state_57032__$1 = state_57032;
var statearr_57034_57052 = state_57032__$1;
(statearr_57034_57052[(2)] = null);

(statearr_57034_57052[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57033 === (2))){
var _ = (function (){var statearr_57035 = state_57032;
(statearr_57035[(4)] = cljs.core.cons.call(null,(5),(state_57032[(4)])));

return statearr_57035;
})();
var inst_57008 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_57032__$1 = state_57032;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57032__$1,(6),inst_57008);
} else {
if((state_val_57033 === (3))){
var inst_57030 = (state_57032[(2)]);
var state_57032__$1 = state_57032;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57032__$1,inst_57030);
} else {
if((state_val_57033 === (4))){
var inst_57002 = (state_57032[(2)]);
var state_57032__$1 = state_57032;
var statearr_57037_57053 = state_57032__$1;
(statearr_57037_57053[(2)] = inst_57002);

(statearr_57037_57053[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57033 === (5))){
var _ = (function (){var statearr_57038 = state_57032;
(statearr_57038[(4)] = cljs.core.rest.call(null,(state_57032[(4)])));

return statearr_57038;
})();
var state_57032__$1 = state_57032;
var ex57036 = (state_57032__$1[(2)]);
var statearr_57039_57054 = state_57032__$1;
(statearr_57039_57054[(5)] = ex57036);


if((ex57036 instanceof Error)){
var statearr_57040_57055 = state_57032__$1;
(statearr_57040_57055[(1)] = (4));

(statearr_57040_57055[(5)] = null);

} else {
throw ex57036;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57033 === (6))){
var inst_57010 = (state_57032[(2)]);
var inst_57011 = fluree.db.util.async.throw_err.call(null,inst_57010);
var inst_57012 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._,inst_57011);
var inst_57013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57014 = [inst_57011];
var inst_57015 = (new cljs.core.PersistentVector(null,1,(5),inst_57013,inst_57014,null));
var inst_57016 = cljs.core.count.call(null,inst_57015);
var inst_57017 = ((9) + inst_57016);
var inst_57018 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57019 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57020 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57021 = [inst_57011];
var inst_57022 = (new cljs.core.PersistentVector(null,1,(5),inst_57020,inst_57021,null));
var inst_57023 = ["-",inst_57022,inst_57012];
var inst_57024 = cljs.core.PersistentHashMap.fromArrays(inst_57019,inst_57023);
var inst_57025 = [inst_57024,inst_57017];
var inst_57026 = (new cljs.core.PersistentVector(null,2,(5),inst_57018,inst_57025,null));
var inst_57027 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57026);
var _ = (function (){var statearr_57041 = state_57032;
(statearr_57041[(4)] = cljs.core.rest.call(null,(state_57032[(4)])));

return statearr_57041;
})();
var state_57032__$1 = (function (){var statearr_57042 = state_57032;
(statearr_57042[(7)] = inst_57027);

return statearr_57042;
})();
var statearr_57043_57056 = state_57032__$1;
(statearr_57043_57056[(2)] = inst_57012);

(statearr_57043_57056[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_57044 = [null,null,null,null,null,null,null,null];
(statearr_57044[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_57044[(1)] = (1));

return statearr_57044;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_57032){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57032);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57045){var ex__2749__auto__ = e57045;
var statearr_57046_57057 = state_57032;
(statearr_57046_57057[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57032[(4)]))){
var statearr_57047_57058 = state_57032;
(statearr_57047_57058[(1)] = cljs.core.first.call(null,(state_57032[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57059 = state_57032;
state_57032 = G__57059;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_57032){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_57032);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57048 = f__2769__auto__.call(null);
(statearr_57048[(6)] = c__2768__auto__);

return statearr_57048;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq57000){
var G__57001 = cljs.core.first.call(null,seq57000);
var seq57000__$1 = cljs.core.next.call(null,seq57000);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__57001,seq57000__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___57109 = arguments.length;
var i__5770__auto___57110 = (0);
while(true){
if((i__5770__auto___57110 < len__5769__auto___57109)){
args__5775__auto__.push((arguments[i__5770__auto___57110]));

var G__57111 = (i__5770__auto___57110 + (1));
i__5770__auto___57110 = G__57111;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57092){
var state_val_57093 = (state_57092[(1)]);
if((state_val_57093 === (1))){
var state_57092__$1 = state_57092;
var statearr_57094_57112 = state_57092__$1;
(statearr_57094_57112[(2)] = null);

(statearr_57094_57112[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57093 === (2))){
var _ = (function (){var statearr_57095 = state_57092;
(statearr_57095[(4)] = cljs.core.cons.call(null,(5),(state_57092[(4)])));

return statearr_57095;
})();
var inst_57068 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_57092__$1 = state_57092;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57092__$1,(6),inst_57068);
} else {
if((state_val_57093 === (3))){
var inst_57090 = (state_57092[(2)]);
var state_57092__$1 = state_57092;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57092__$1,inst_57090);
} else {
if((state_val_57093 === (4))){
var inst_57062 = (state_57092[(2)]);
var state_57092__$1 = state_57092;
var statearr_57097_57113 = state_57092__$1;
(statearr_57097_57113[(2)] = inst_57062);

(statearr_57097_57113[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57093 === (5))){
var _ = (function (){var statearr_57098 = state_57092;
(statearr_57098[(4)] = cljs.core.rest.call(null,(state_57092[(4)])));

return statearr_57098;
})();
var state_57092__$1 = state_57092;
var ex57096 = (state_57092__$1[(2)]);
var statearr_57099_57114 = state_57092__$1;
(statearr_57099_57114[(5)] = ex57096);


if((ex57096 instanceof Error)){
var statearr_57100_57115 = state_57092__$1;
(statearr_57100_57115[(1)] = (4));

(statearr_57100_57115[(5)] = null);

} else {
throw ex57096;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57093 === (6))){
var inst_57070 = (state_57092[(2)]);
var inst_57071 = fluree.db.util.async.throw_err.call(null,inst_57070);
var inst_57072 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._STAR_,inst_57071);
var inst_57073 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57074 = [inst_57071];
var inst_57075 = (new cljs.core.PersistentVector(null,1,(5),inst_57073,inst_57074,null));
var inst_57076 = cljs.core.count.call(null,inst_57075);
var inst_57077 = ((9) + inst_57076);
var inst_57078 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57079 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57080 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57081 = [inst_57071];
var inst_57082 = (new cljs.core.PersistentVector(null,1,(5),inst_57080,inst_57081,null));
var inst_57083 = ["*",inst_57082,inst_57072];
var inst_57084 = cljs.core.PersistentHashMap.fromArrays(inst_57079,inst_57083);
var inst_57085 = [inst_57084,inst_57077];
var inst_57086 = (new cljs.core.PersistentVector(null,2,(5),inst_57078,inst_57085,null));
var inst_57087 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57086);
var _ = (function (){var statearr_57101 = state_57092;
(statearr_57101[(4)] = cljs.core.rest.call(null,(state_57092[(4)])));

return statearr_57101;
})();
var state_57092__$1 = (function (){var statearr_57102 = state_57092;
(statearr_57102[(7)] = inst_57087);

return statearr_57102;
})();
var statearr_57103_57116 = state_57092__$1;
(statearr_57103_57116[(2)] = inst_57072);

(statearr_57103_57116[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_57104 = [null,null,null,null,null,null,null,null];
(statearr_57104[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_57104[(1)] = (1));

return statearr_57104;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_57092){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57092);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57105){var ex__2749__auto__ = e57105;
var statearr_57106_57117 = state_57092;
(statearr_57106_57117[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57092[(4)]))){
var statearr_57107_57118 = state_57092;
(statearr_57107_57118[(1)] = cljs.core.first.call(null,(state_57092[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57119 = state_57092;
state_57092 = G__57119;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_57092){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_57092);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57108 = f__2769__auto__.call(null);
(statearr_57108[(6)] = c__2768__auto__);

return statearr_57108;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq57060){
var G__57061 = cljs.core.first.call(null,seq57060);
var seq57060__$1 = cljs.core.next.call(null,seq57060);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__57061,seq57060__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___57169 = arguments.length;
var i__5770__auto___57170 = (0);
while(true){
if((i__5770__auto___57170 < len__5769__auto___57169)){
args__5775__auto__.push((arguments[i__5770__auto___57170]));

var G__57171 = (i__5770__auto___57170 + (1));
i__5770__auto___57170 = G__57171;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57152){
var state_val_57153 = (state_57152[(1)]);
if((state_val_57153 === (1))){
var state_57152__$1 = state_57152;
var statearr_57154_57172 = state_57152__$1;
(statearr_57154_57172[(2)] = null);

(statearr_57154_57172[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57153 === (2))){
var _ = (function (){var statearr_57155 = state_57152;
(statearr_57155[(4)] = cljs.core.cons.call(null,(5),(state_57152[(4)])));

return statearr_57155;
})();
var inst_57128 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_57152__$1 = state_57152;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57152__$1,(6),inst_57128);
} else {
if((state_val_57153 === (3))){
var inst_57150 = (state_57152[(2)]);
var state_57152__$1 = state_57152;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57152__$1,inst_57150);
} else {
if((state_val_57153 === (4))){
var inst_57122 = (state_57152[(2)]);
var state_57152__$1 = state_57152;
var statearr_57157_57173 = state_57152__$1;
(statearr_57157_57173[(2)] = inst_57122);

(statearr_57157_57173[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57153 === (5))){
var _ = (function (){var statearr_57158 = state_57152;
(statearr_57158[(4)] = cljs.core.rest.call(null,(state_57152[(4)])));

return statearr_57158;
})();
var state_57152__$1 = state_57152;
var ex57156 = (state_57152__$1[(2)]);
var statearr_57159_57174 = state_57152__$1;
(statearr_57159_57174[(5)] = ex57156);


if((ex57156 instanceof Error)){
var statearr_57160_57175 = state_57152__$1;
(statearr_57160_57175[(1)] = (4));

(statearr_57160_57175[(5)] = null);

} else {
throw ex57156;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57153 === (6))){
var inst_57130 = (state_57152[(2)]);
var inst_57131 = fluree.db.util.async.throw_err.call(null,inst_57130);
var inst_57132 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._SLASH_,inst_57131);
var inst_57133 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57134 = [inst_57131];
var inst_57135 = (new cljs.core.PersistentVector(null,1,(5),inst_57133,inst_57134,null));
var inst_57136 = cljs.core.count.call(null,inst_57135);
var inst_57137 = ((9) + inst_57136);
var inst_57138 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57139 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57140 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57141 = [inst_57131];
var inst_57142 = (new cljs.core.PersistentVector(null,1,(5),inst_57140,inst_57141,null));
var inst_57143 = ["/",inst_57142,inst_57132];
var inst_57144 = cljs.core.PersistentHashMap.fromArrays(inst_57139,inst_57143);
var inst_57145 = [inst_57144,inst_57137];
var inst_57146 = (new cljs.core.PersistentVector(null,2,(5),inst_57138,inst_57145,null));
var inst_57147 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57146);
var _ = (function (){var statearr_57161 = state_57152;
(statearr_57161[(4)] = cljs.core.rest.call(null,(state_57152[(4)])));

return statearr_57161;
})();
var state_57152__$1 = (function (){var statearr_57162 = state_57152;
(statearr_57162[(7)] = inst_57147);

return statearr_57162;
})();
var statearr_57163_57176 = state_57152__$1;
(statearr_57163_57176[(2)] = inst_57132);

(statearr_57163_57176[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_57164 = [null,null,null,null,null,null,null,null];
(statearr_57164[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_57164[(1)] = (1));

return statearr_57164;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_57152){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57152);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57165){var ex__2749__auto__ = e57165;
var statearr_57166_57177 = state_57152;
(statearr_57166_57177[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57152[(4)]))){
var statearr_57167_57178 = state_57152;
(statearr_57167_57178[(1)] = cljs.core.first.call(null,(state_57152[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57179 = state_57152;
state_57152 = G__57179;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_57152){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_57152);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57168 = f__2769__auto__.call(null);
(statearr_57168[(6)] = c__2768__auto__);

return statearr_57168;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq57120){
var G__57121 = cljs.core.first.call(null,seq57120);
var seq57120__$1 = cljs.core.next.call(null,seq57120);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__57121,seq57120__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57217){
var state_val_57218 = (state_57217[(1)]);
if((state_val_57218 === (7))){
var state_57217__$1 = state_57217;
var statearr_57219_57243 = state_57217__$1;
(statearr_57219_57243[(2)] = n);

(statearr_57219_57243[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57218 === (1))){
var state_57217__$1 = state_57217;
var statearr_57220_57244 = state_57217__$1;
(statearr_57220_57244[(2)] = null);

(statearr_57220_57244[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57218 === (4))){
var inst_57180 = (state_57217[(2)]);
var state_57217__$1 = state_57217;
var statearr_57221_57245 = state_57217__$1;
(statearr_57221_57245[(2)] = inst_57180);

(statearr_57221_57245[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57218 === (13))){
var inst_57197 = (state_57217[(2)]);
var inst_57198 = fluree.db.util.async.throw_err.call(null,inst_57197);
var state_57217__$1 = state_57217;
var statearr_57222_57246 = state_57217__$1;
(statearr_57222_57246[(2)] = inst_57198);

(statearr_57222_57246[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57218 === (6))){
var state_57217__$1 = state_57217;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57217__$1,(9),n);
} else {
if((state_val_57218 === (3))){
var inst_57215 = (state_57217[(2)]);
var state_57217__$1 = state_57217;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57217__$1,inst_57215);
} else {
if((state_val_57218 === (12))){
var inst_57193 = (state_57217[(7)]);
var inst_57201 = (state_57217[(2)]);
var inst_57202 = fluree.db.dbfunctions.internal.quot.call(null,inst_57193,inst_57201);
var inst_57203 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57204 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57205 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57206 = [inst_57193,inst_57201];
var inst_57207 = (new cljs.core.PersistentVector(null,2,(5),inst_57205,inst_57206,null));
var inst_57208 = ["quot",inst_57207,inst_57202];
var inst_57209 = cljs.core.PersistentHashMap.fromArrays(inst_57204,inst_57208);
var inst_57210 = [inst_57209,(2)];
var inst_57211 = (new cljs.core.PersistentVector(null,2,(5),inst_57203,inst_57210,null));
var inst_57212 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57211);
var _ = (function (){var statearr_57223 = state_57217;
(statearr_57223[(4)] = cljs.core.rest.call(null,(state_57217[(4)])));

return statearr_57223;
})();
var state_57217__$1 = (function (){var statearr_57224 = state_57217;
(statearr_57224[(8)] = inst_57212);

return statearr_57224;
})();
var statearr_57225_57247 = state_57217__$1;
(statearr_57225_57247[(2)] = inst_57202);

(statearr_57225_57247[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57218 === (2))){
var _ = (function (){var statearr_57226 = state_57217;
(statearr_57226[(4)] = cljs.core.cons.call(null,(5),(state_57217[(4)])));

return statearr_57226;
})();
var inst_57186 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_57217__$1 = state_57217;
if(inst_57186){
var statearr_57227_57248 = state_57217__$1;
(statearr_57227_57248[(1)] = (6));

} else {
var statearr_57228_57249 = state_57217__$1;
(statearr_57228_57249[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57218 === (11))){
var state_57217__$1 = state_57217;
var statearr_57230_57250 = state_57217__$1;
(statearr_57230_57250[(2)] = d);

(statearr_57230_57250[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57218 === (9))){
var inst_57189 = (state_57217[(2)]);
var inst_57190 = fluree.db.util.async.throw_err.call(null,inst_57189);
var state_57217__$1 = state_57217;
var statearr_57231_57251 = state_57217__$1;
(statearr_57231_57251[(2)] = inst_57190);

(statearr_57231_57251[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57218 === (5))){
var _ = (function (){var statearr_57232 = state_57217;
(statearr_57232[(4)] = cljs.core.rest.call(null,(state_57217[(4)])));

return statearr_57232;
})();
var state_57217__$1 = state_57217;
var ex57229 = (state_57217__$1[(2)]);
var statearr_57233_57252 = state_57217__$1;
(statearr_57233_57252[(5)] = ex57229);


if((ex57229 instanceof Error)){
var statearr_57234_57253 = state_57217__$1;
(statearr_57234_57253[(1)] = (4));

(statearr_57234_57253[(5)] = null);

} else {
throw ex57229;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57218 === (10))){
var state_57217__$1 = state_57217;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57217__$1,(13),d);
} else {
if((state_val_57218 === (8))){
var inst_57193 = (state_57217[(2)]);
var inst_57194 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_57217__$1 = (function (){var statearr_57235 = state_57217;
(statearr_57235[(7)] = inst_57193);

return statearr_57235;
})();
if(inst_57194){
var statearr_57236_57254 = state_57217__$1;
(statearr_57236_57254[(1)] = (10));

} else {
var statearr_57237_57255 = state_57217__$1;
(statearr_57237_57255[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____0 = (function (){
var statearr_57238 = [null,null,null,null,null,null,null,null,null];
(statearr_57238[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__);

(statearr_57238[(1)] = (1));

return statearr_57238;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____1 = (function (state_57217){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57217);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57239){var ex__2749__auto__ = e57239;
var statearr_57240_57256 = state_57217;
(statearr_57240_57256[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57217[(4)]))){
var statearr_57241_57257 = state_57217;
(statearr_57241_57257[(1)] = cljs.core.first.call(null,(state_57217[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57258 = state_57217;
state_57217 = G__57258;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__ = function(state_57217){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____1.call(this,state_57217);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57242 = f__2769__auto__.call(null);
(statearr_57242[(6)] = c__2768__auto__);

return statearr_57242;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57296){
var state_val_57297 = (state_57296[(1)]);
if((state_val_57297 === (7))){
var state_57296__$1 = state_57296;
var statearr_57298_57322 = state_57296__$1;
(statearr_57298_57322[(2)] = n);

(statearr_57298_57322[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57297 === (1))){
var state_57296__$1 = state_57296;
var statearr_57299_57323 = state_57296__$1;
(statearr_57299_57323[(2)] = null);

(statearr_57299_57323[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57297 === (4))){
var inst_57259 = (state_57296[(2)]);
var state_57296__$1 = state_57296;
var statearr_57300_57324 = state_57296__$1;
(statearr_57300_57324[(2)] = inst_57259);

(statearr_57300_57324[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57297 === (13))){
var inst_57276 = (state_57296[(2)]);
var inst_57277 = fluree.db.util.async.throw_err.call(null,inst_57276);
var state_57296__$1 = state_57296;
var statearr_57301_57325 = state_57296__$1;
(statearr_57301_57325[(2)] = inst_57277);

(statearr_57301_57325[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57297 === (6))){
var state_57296__$1 = state_57296;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57296__$1,(9),n);
} else {
if((state_val_57297 === (3))){
var inst_57294 = (state_57296[(2)]);
var state_57296__$1 = state_57296;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57296__$1,inst_57294);
} else {
if((state_val_57297 === (12))){
var inst_57272 = (state_57296[(7)]);
var inst_57280 = (state_57296[(2)]);
var inst_57281 = fluree.db.dbfunctions.internal.mod.call(null,inst_57272,inst_57280);
var inst_57282 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57283 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57284 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57285 = [inst_57272,inst_57280];
var inst_57286 = (new cljs.core.PersistentVector(null,2,(5),inst_57284,inst_57285,null));
var inst_57287 = ["mod",inst_57286,inst_57281];
var inst_57288 = cljs.core.PersistentHashMap.fromArrays(inst_57283,inst_57287);
var inst_57289 = [inst_57288,(2)];
var inst_57290 = (new cljs.core.PersistentVector(null,2,(5),inst_57282,inst_57289,null));
var inst_57291 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57290);
var _ = (function (){var statearr_57302 = state_57296;
(statearr_57302[(4)] = cljs.core.rest.call(null,(state_57296[(4)])));

return statearr_57302;
})();
var state_57296__$1 = (function (){var statearr_57303 = state_57296;
(statearr_57303[(8)] = inst_57291);

return statearr_57303;
})();
var statearr_57304_57326 = state_57296__$1;
(statearr_57304_57326[(2)] = inst_57281);

(statearr_57304_57326[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57297 === (2))){
var _ = (function (){var statearr_57305 = state_57296;
(statearr_57305[(4)] = cljs.core.cons.call(null,(5),(state_57296[(4)])));

return statearr_57305;
})();
var inst_57265 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_57296__$1 = state_57296;
if(inst_57265){
var statearr_57306_57327 = state_57296__$1;
(statearr_57306_57327[(1)] = (6));

} else {
var statearr_57307_57328 = state_57296__$1;
(statearr_57307_57328[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57297 === (11))){
var state_57296__$1 = state_57296;
var statearr_57309_57329 = state_57296__$1;
(statearr_57309_57329[(2)] = d);

(statearr_57309_57329[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57297 === (9))){
var inst_57268 = (state_57296[(2)]);
var inst_57269 = fluree.db.util.async.throw_err.call(null,inst_57268);
var state_57296__$1 = state_57296;
var statearr_57310_57330 = state_57296__$1;
(statearr_57310_57330[(2)] = inst_57269);

(statearr_57310_57330[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57297 === (5))){
var _ = (function (){var statearr_57311 = state_57296;
(statearr_57311[(4)] = cljs.core.rest.call(null,(state_57296[(4)])));

return statearr_57311;
})();
var state_57296__$1 = state_57296;
var ex57308 = (state_57296__$1[(2)]);
var statearr_57312_57331 = state_57296__$1;
(statearr_57312_57331[(5)] = ex57308);


if((ex57308 instanceof Error)){
var statearr_57313_57332 = state_57296__$1;
(statearr_57313_57332[(1)] = (4));

(statearr_57313_57332[(5)] = null);

} else {
throw ex57308;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57297 === (10))){
var state_57296__$1 = state_57296;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57296__$1,(13),d);
} else {
if((state_val_57297 === (8))){
var inst_57272 = (state_57296[(2)]);
var inst_57273 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_57296__$1 = (function (){var statearr_57314 = state_57296;
(statearr_57314[(7)] = inst_57272);

return statearr_57314;
})();
if(inst_57273){
var statearr_57315_57333 = state_57296__$1;
(statearr_57315_57333[(1)] = (10));

} else {
var statearr_57316_57334 = state_57296__$1;
(statearr_57316_57334[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____0 = (function (){
var statearr_57317 = [null,null,null,null,null,null,null,null,null];
(statearr_57317[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__);

(statearr_57317[(1)] = (1));

return statearr_57317;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____1 = (function (state_57296){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57296);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57318){var ex__2749__auto__ = e57318;
var statearr_57319_57335 = state_57296;
(statearr_57319_57335[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57296[(4)]))){
var statearr_57320_57336 = state_57296;
(statearr_57320_57336[(1)] = cljs.core.first.call(null,(state_57296[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57337 = state_57296;
state_57296 = G__57337;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__ = function(state_57296){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____1.call(this,state_57296);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57321 = f__2769__auto__.call(null);
(statearr_57321[(6)] = c__2768__auto__);

return statearr_57321;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57375){
var state_val_57376 = (state_57375[(1)]);
if((state_val_57376 === (7))){
var state_57375__$1 = state_57375;
var statearr_57377_57401 = state_57375__$1;
(statearr_57377_57401[(2)] = n);

(statearr_57377_57401[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57376 === (1))){
var state_57375__$1 = state_57375;
var statearr_57378_57402 = state_57375__$1;
(statearr_57378_57402[(2)] = null);

(statearr_57378_57402[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57376 === (4))){
var inst_57338 = (state_57375[(2)]);
var state_57375__$1 = state_57375;
var statearr_57379_57403 = state_57375__$1;
(statearr_57379_57403[(2)] = inst_57338);

(statearr_57379_57403[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57376 === (13))){
var inst_57355 = (state_57375[(2)]);
var inst_57356 = fluree.db.util.async.throw_err.call(null,inst_57355);
var state_57375__$1 = state_57375;
var statearr_57380_57404 = state_57375__$1;
(statearr_57380_57404[(2)] = inst_57356);

(statearr_57380_57404[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57376 === (6))){
var state_57375__$1 = state_57375;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57375__$1,(9),n);
} else {
if((state_val_57376 === (3))){
var inst_57373 = (state_57375[(2)]);
var state_57375__$1 = state_57375;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57375__$1,inst_57373);
} else {
if((state_val_57376 === (12))){
var inst_57351 = (state_57375[(7)]);
var inst_57359 = (state_57375[(2)]);
var inst_57360 = fluree.db.dbfunctions.internal.rem.call(null,inst_57351,inst_57359);
var inst_57361 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57362 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57363 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57364 = [inst_57351,inst_57359];
var inst_57365 = (new cljs.core.PersistentVector(null,2,(5),inst_57363,inst_57364,null));
var inst_57366 = ["rem",inst_57365,inst_57360];
var inst_57367 = cljs.core.PersistentHashMap.fromArrays(inst_57362,inst_57366);
var inst_57368 = [inst_57367,(2)];
var inst_57369 = (new cljs.core.PersistentVector(null,2,(5),inst_57361,inst_57368,null));
var inst_57370 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57369);
var _ = (function (){var statearr_57381 = state_57375;
(statearr_57381[(4)] = cljs.core.rest.call(null,(state_57375[(4)])));

return statearr_57381;
})();
var state_57375__$1 = (function (){var statearr_57382 = state_57375;
(statearr_57382[(8)] = inst_57370);

return statearr_57382;
})();
var statearr_57383_57405 = state_57375__$1;
(statearr_57383_57405[(2)] = inst_57360);

(statearr_57383_57405[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57376 === (2))){
var _ = (function (){var statearr_57384 = state_57375;
(statearr_57384[(4)] = cljs.core.cons.call(null,(5),(state_57375[(4)])));

return statearr_57384;
})();
var inst_57344 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_57375__$1 = state_57375;
if(inst_57344){
var statearr_57385_57406 = state_57375__$1;
(statearr_57385_57406[(1)] = (6));

} else {
var statearr_57386_57407 = state_57375__$1;
(statearr_57386_57407[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57376 === (11))){
var state_57375__$1 = state_57375;
var statearr_57388_57408 = state_57375__$1;
(statearr_57388_57408[(2)] = d);

(statearr_57388_57408[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57376 === (9))){
var inst_57347 = (state_57375[(2)]);
var inst_57348 = fluree.db.util.async.throw_err.call(null,inst_57347);
var state_57375__$1 = state_57375;
var statearr_57389_57409 = state_57375__$1;
(statearr_57389_57409[(2)] = inst_57348);

(statearr_57389_57409[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57376 === (5))){
var _ = (function (){var statearr_57390 = state_57375;
(statearr_57390[(4)] = cljs.core.rest.call(null,(state_57375[(4)])));

return statearr_57390;
})();
var state_57375__$1 = state_57375;
var ex57387 = (state_57375__$1[(2)]);
var statearr_57391_57410 = state_57375__$1;
(statearr_57391_57410[(5)] = ex57387);


if((ex57387 instanceof Error)){
var statearr_57392_57411 = state_57375__$1;
(statearr_57392_57411[(1)] = (4));

(statearr_57392_57411[(5)] = null);

} else {
throw ex57387;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57376 === (10))){
var state_57375__$1 = state_57375;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57375__$1,(13),d);
} else {
if((state_val_57376 === (8))){
var inst_57351 = (state_57375[(2)]);
var inst_57352 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_57375__$1 = (function (){var statearr_57393 = state_57375;
(statearr_57393[(7)] = inst_57351);

return statearr_57393;
})();
if(inst_57352){
var statearr_57394_57412 = state_57375__$1;
(statearr_57394_57412[(1)] = (10));

} else {
var statearr_57395_57413 = state_57375__$1;
(statearr_57395_57413[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____0 = (function (){
var statearr_57396 = [null,null,null,null,null,null,null,null,null];
(statearr_57396[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__);

(statearr_57396[(1)] = (1));

return statearr_57396;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____1 = (function (state_57375){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57375);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57397){var ex__2749__auto__ = e57397;
var statearr_57398_57414 = state_57375;
(statearr_57398_57414[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57375[(4)]))){
var statearr_57399_57415 = state_57375;
(statearr_57399_57415[(1)] = cljs.core.first.call(null,(state_57375[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57416 = state_57375;
state_57375 = G__57416;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__ = function(state_57375){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____1.call(this,state_57375);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57400 = f__2769__auto__.call(null);
(statearr_57400[(6)] = c__2768__auto__);

return statearr_57400;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57443){
var state_val_57444 = (state_57443[(1)]);
if((state_val_57444 === (7))){
var state_57443__$1 = state_57443;
var statearr_57445_57464 = state_57443__$1;
(statearr_57445_57464[(2)] = x);

(statearr_57445_57464[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57444 === (1))){
var state_57443__$1 = state_57443;
var statearr_57446_57465 = state_57443__$1;
(statearr_57446_57465[(2)] = null);

(statearr_57446_57465[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57444 === (4))){
var inst_57417 = (state_57443[(2)]);
var state_57443__$1 = state_57443;
var statearr_57447_57466 = state_57443__$1;
(statearr_57447_57466[(2)] = inst_57417);

(statearr_57447_57466[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57444 === (6))){
var state_57443__$1 = state_57443;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57443__$1,(9),x);
} else {
if((state_val_57444 === (3))){
var inst_57441 = (state_57443[(2)]);
var state_57443__$1 = state_57443;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57443__$1,inst_57441);
} else {
if((state_val_57444 === (2))){
var _ = (function (){var statearr_57449 = state_57443;
(statearr_57449[(4)] = cljs.core.cons.call(null,(5),(state_57443[(4)])));

return statearr_57449;
})();
var inst_57423 = fluree.db.util.async.channel_QMARK_.call(null,x);
var state_57443__$1 = state_57443;
if(inst_57423){
var statearr_57450_57467 = state_57443__$1;
(statearr_57450_57467[(1)] = (6));

} else {
var statearr_57451_57468 = state_57443__$1;
(statearr_57451_57468[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57444 === (9))){
var inst_57426 = (state_57443[(2)]);
var inst_57427 = fluree.db.util.async.throw_err.call(null,inst_57426);
var state_57443__$1 = state_57443;
var statearr_57452_57469 = state_57443__$1;
(statearr_57452_57469[(2)] = inst_57427);

(statearr_57452_57469[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57444 === (5))){
var _ = (function (){var statearr_57453 = state_57443;
(statearr_57453[(4)] = cljs.core.rest.call(null,(state_57443[(4)])));

return statearr_57453;
})();
var state_57443__$1 = state_57443;
var ex57448 = (state_57443__$1[(2)]);
var statearr_57454_57470 = state_57443__$1;
(statearr_57454_57470[(5)] = ex57448);


if((ex57448 instanceof Error)){
var statearr_57455_57471 = state_57443__$1;
(statearr_57455_57471[(1)] = (4));

(statearr_57455_57471[(5)] = null);

} else {
throw ex57448;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57444 === (8))){
var inst_57430 = (state_57443[(2)]);
var inst_57431 = fluree.db.dbfunctions.internal.boolean$.call(null,inst_57430);
var inst_57432 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57433 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57434 = ["boolean",inst_57430,inst_57431];
var inst_57435 = cljs.core.PersistentHashMap.fromArrays(inst_57433,inst_57434);
var inst_57436 = [inst_57435,(10)];
var inst_57437 = (new cljs.core.PersistentVector(null,2,(5),inst_57432,inst_57436,null));
var inst_57438 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57437);
var _ = (function (){var statearr_57456 = state_57443;
(statearr_57456[(4)] = cljs.core.rest.call(null,(state_57443[(4)])));

return statearr_57456;
})();
var state_57443__$1 = (function (){var statearr_57457 = state_57443;
(statearr_57457[(7)] = inst_57438);

return statearr_57457;
})();
var statearr_57458_57472 = state_57443__$1;
(statearr_57458_57472[(2)] = inst_57431);

(statearr_57458_57472[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____0 = (function (){
var statearr_57459 = [null,null,null,null,null,null,null,null];
(statearr_57459[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__);

(statearr_57459[(1)] = (1));

return statearr_57459;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____1 = (function (state_57443){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57443);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57460){var ex__2749__auto__ = e57460;
var statearr_57461_57473 = state_57443;
(statearr_57461_57473[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57443[(4)]))){
var statearr_57462_57474 = state_57443;
(statearr_57462_57474[(1)] = cljs.core.first.call(null,(state_57443[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57475 = state_57443;
state_57443 = G__57475;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__ = function(state_57443){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____1.call(this,state_57443);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57463 = f__2769__auto__.call(null);
(statearr_57463[(6)] = c__2768__auto__);

return statearr_57463;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57513){
var state_val_57514 = (state_57513[(1)]);
if((state_val_57514 === (7))){
var state_57513__$1 = state_57513;
var statearr_57515_57539 = state_57513__$1;
(statearr_57515_57539[(2)] = pattern);

(statearr_57515_57539[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57514 === (1))){
var state_57513__$1 = state_57513;
var statearr_57516_57540 = state_57513__$1;
(statearr_57516_57540[(2)] = null);

(statearr_57516_57540[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57514 === (4))){
var inst_57476 = (state_57513[(2)]);
var state_57513__$1 = state_57513;
var statearr_57517_57541 = state_57513__$1;
(statearr_57517_57541[(2)] = inst_57476);

(statearr_57517_57541[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57514 === (13))){
var inst_57493 = (state_57513[(2)]);
var inst_57494 = fluree.db.util.async.throw_err.call(null,inst_57493);
var state_57513__$1 = state_57513;
var statearr_57518_57542 = state_57513__$1;
(statearr_57518_57542[(2)] = inst_57494);

(statearr_57518_57542[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57514 === (6))){
var state_57513__$1 = state_57513;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57513__$1,(9),pattern);
} else {
if((state_val_57514 === (3))){
var inst_57511 = (state_57513[(2)]);
var state_57513__$1 = state_57513;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57513__$1,inst_57511);
} else {
if((state_val_57514 === (12))){
var inst_57489 = (state_57513[(7)]);
var inst_57497 = (state_57513[(2)]);
var inst_57498 = fluree.db.dbfunctions.internal.re_find.call(null,inst_57489,inst_57497);
var inst_57499 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57500 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57501 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57502 = [inst_57489,inst_57497];
var inst_57503 = (new cljs.core.PersistentVector(null,2,(5),inst_57501,inst_57502,null));
var inst_57504 = ["re-find",inst_57503,inst_57498];
var inst_57505 = cljs.core.PersistentHashMap.fromArrays(inst_57500,inst_57504);
var inst_57506 = [inst_57505,(10)];
var inst_57507 = (new cljs.core.PersistentVector(null,2,(5),inst_57499,inst_57506,null));
var inst_57508 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57507);
var _ = (function (){var statearr_57519 = state_57513;
(statearr_57519[(4)] = cljs.core.rest.call(null,(state_57513[(4)])));

return statearr_57519;
})();
var state_57513__$1 = (function (){var statearr_57520 = state_57513;
(statearr_57520[(8)] = inst_57508);

return statearr_57520;
})();
var statearr_57521_57543 = state_57513__$1;
(statearr_57521_57543[(2)] = inst_57498);

(statearr_57521_57543[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57514 === (2))){
var _ = (function (){var statearr_57522 = state_57513;
(statearr_57522[(4)] = cljs.core.cons.call(null,(5),(state_57513[(4)])));

return statearr_57522;
})();
var inst_57482 = fluree.db.util.async.channel_QMARK_.call(null,pattern);
var state_57513__$1 = state_57513;
if(inst_57482){
var statearr_57523_57544 = state_57513__$1;
(statearr_57523_57544[(1)] = (6));

} else {
var statearr_57524_57545 = state_57513__$1;
(statearr_57524_57545[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57514 === (11))){
var state_57513__$1 = state_57513;
var statearr_57526_57546 = state_57513__$1;
(statearr_57526_57546[(2)] = string);

(statearr_57526_57546[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57514 === (9))){
var inst_57485 = (state_57513[(2)]);
var inst_57486 = fluree.db.util.async.throw_err.call(null,inst_57485);
var state_57513__$1 = state_57513;
var statearr_57527_57547 = state_57513__$1;
(statearr_57527_57547[(2)] = inst_57486);

(statearr_57527_57547[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57514 === (5))){
var _ = (function (){var statearr_57528 = state_57513;
(statearr_57528[(4)] = cljs.core.rest.call(null,(state_57513[(4)])));

return statearr_57528;
})();
var state_57513__$1 = state_57513;
var ex57525 = (state_57513__$1[(2)]);
var statearr_57529_57548 = state_57513__$1;
(statearr_57529_57548[(5)] = ex57525);


if((ex57525 instanceof Error)){
var statearr_57530_57549 = state_57513__$1;
(statearr_57530_57549[(1)] = (4));

(statearr_57530_57549[(5)] = null);

} else {
throw ex57525;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57514 === (10))){
var state_57513__$1 = state_57513;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57513__$1,(13),string);
} else {
if((state_val_57514 === (8))){
var inst_57489 = (state_57513[(2)]);
var inst_57490 = fluree.db.util.async.channel_QMARK_.call(null,string);
var state_57513__$1 = (function (){var statearr_57531 = state_57513;
(statearr_57531[(7)] = inst_57489);

return statearr_57531;
})();
if(inst_57490){
var statearr_57532_57550 = state_57513__$1;
(statearr_57532_57550[(1)] = (10));

} else {
var statearr_57533_57551 = state_57513__$1;
(statearr_57533_57551[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____0 = (function (){
var statearr_57534 = [null,null,null,null,null,null,null,null,null];
(statearr_57534[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__);

(statearr_57534[(1)] = (1));

return statearr_57534;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____1 = (function (state_57513){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57513);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57535){var ex__2749__auto__ = e57535;
var statearr_57536_57552 = state_57513;
(statearr_57536_57552[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57513[(4)]))){
var statearr_57537_57553 = state_57513;
(statearr_57537_57553[(1)] = cljs.core.first.call(null,(state_57513[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57554 = state_57513;
state_57513 = G__57554;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__ = function(state_57513){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____1.call(this,state_57513);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57538 = f__2769__auto__.call(null);
(statearr_57538[(6)] = c__2768__auto__);

return statearr_57538;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57581){
var state_val_57582 = (state_57581[(1)]);
if((state_val_57582 === (7))){
var state_57581__$1 = state_57581;
var statearr_57583_57602 = state_57581__$1;
(statearr_57583_57602[(2)] = email);

(statearr_57583_57602[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57582 === (1))){
var state_57581__$1 = state_57581;
var statearr_57584_57603 = state_57581__$1;
(statearr_57584_57603[(2)] = null);

(statearr_57584_57603[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57582 === (4))){
var inst_57555 = (state_57581[(2)]);
var state_57581__$1 = state_57581;
var statearr_57585_57604 = state_57581__$1;
(statearr_57585_57604[(2)] = inst_57555);

(statearr_57585_57604[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57582 === (6))){
var state_57581__$1 = state_57581;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57581__$1,(9),email);
} else {
if((state_val_57582 === (3))){
var inst_57579 = (state_57581[(2)]);
var state_57581__$1 = state_57581;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57581__$1,inst_57579);
} else {
if((state_val_57582 === (2))){
var _ = (function (){var statearr_57587 = state_57581;
(statearr_57587[(4)] = cljs.core.cons.call(null,(5),(state_57581[(4)])));

return statearr_57587;
})();
var inst_57561 = fluree.db.util.async.channel_QMARK_.call(null,email);
var state_57581__$1 = state_57581;
if(inst_57561){
var statearr_57588_57605 = state_57581__$1;
(statearr_57588_57605[(1)] = (6));

} else {
var statearr_57589_57606 = state_57581__$1;
(statearr_57589_57606[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57582 === (9))){
var inst_57564 = (state_57581[(2)]);
var inst_57565 = fluree.db.util.async.throw_err.call(null,inst_57564);
var state_57581__$1 = state_57581;
var statearr_57590_57607 = state_57581__$1;
(statearr_57590_57607[(2)] = inst_57565);

(statearr_57590_57607[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57582 === (5))){
var _ = (function (){var statearr_57591 = state_57581;
(statearr_57591[(4)] = cljs.core.rest.call(null,(state_57581[(4)])));

return statearr_57591;
})();
var state_57581__$1 = state_57581;
var ex57586 = (state_57581__$1[(2)]);
var statearr_57592_57608 = state_57581__$1;
(statearr_57592_57608[(5)] = ex57586);


if((ex57586 instanceof Error)){
var statearr_57593_57609 = state_57581__$1;
(statearr_57593_57609[(1)] = (4));

(statearr_57593_57609[(5)] = null);

} else {
throw ex57586;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57582 === (8))){
var inst_57568 = (state_57581[(2)]);
var inst_57569 = fluree.db.dbfunctions.internal.valid_email_QMARK_.call(null,inst_57568);
var inst_57570 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57571 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57572 = ["re-find",inst_57568,inst_57569];
var inst_57573 = cljs.core.PersistentHashMap.fromArrays(inst_57571,inst_57572);
var inst_57574 = [inst_57573,(10)];
var inst_57575 = (new cljs.core.PersistentVector(null,2,(5),inst_57570,inst_57574,null));
var inst_57576 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57575);
var _ = (function (){var statearr_57594 = state_57581;
(statearr_57594[(4)] = cljs.core.rest.call(null,(state_57581[(4)])));

return statearr_57594;
})();
var state_57581__$1 = (function (){var statearr_57595 = state_57581;
(statearr_57595[(7)] = inst_57576);

return statearr_57595;
})();
var statearr_57596_57610 = state_57581__$1;
(statearr_57596_57610[(2)] = inst_57569);

(statearr_57596_57610[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_57597 = [null,null,null,null,null,null,null,null];
(statearr_57597[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__);

(statearr_57597[(1)] = (1));

return statearr_57597;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____1 = (function (state_57581){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57581);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57598){var ex__2749__auto__ = e57598;
var statearr_57599_57611 = state_57581;
(statearr_57599_57611[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57581[(4)]))){
var statearr_57600_57612 = state_57581;
(statearr_57600_57612[(1)] = cljs.core.first.call(null,(state_57581[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57613 = state_57581;
state_57581 = G__57613;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__ = function(state_57581){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____1.call(this,state_57581);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57601 = f__2769__auto__.call(null);
(statearr_57601[(6)] = c__2768__auto__);

return statearr_57601;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57660){
var state_val_57661 = (state_57660[(1)]);
if((state_val_57661 === (7))){
var inst_57630 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57660__$1 = state_57660;
if(cljs.core.truth_(inst_57630)){
var statearr_57662_57689 = state_57660__$1;
(statearr_57662_57689[(1)] = (9));

} else {
var statearr_57663_57690 = state_57660__$1;
(statearr_57663_57690[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57661 === (1))){
var state_57660__$1 = state_57660;
var statearr_57664_57691 = state_57660__$1;
(statearr_57664_57691[(2)] = null);

(statearr_57664_57691[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57661 === (4))){
var inst_57614 = (state_57660[(2)]);
var state_57660__$1 = state_57660;
var statearr_57665_57692 = state_57660__$1;
(statearr_57665_57692[(2)] = inst_57614);

(statearr_57665_57692[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57661 === (15))){
var inst_57641 = (state_57660[(2)]);
var state_57660__$1 = state_57660;
var statearr_57666_57693 = state_57660__$1;
(statearr_57666_57693[(2)] = inst_57641);

(statearr_57666_57693[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57661 === (13))){
var inst_57638 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_57660__$1 = state_57660;
var statearr_57667_57694 = state_57660__$1;
(statearr_57667_57694[(2)] = inst_57638);

(statearr_57667_57694[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57661 === (6))){
var inst_57625 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57626 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_57627 = [inst_57626,(0)];
var inst_57628 = (new cljs.core.PersistentVector(null,2,(5),inst_57625,inst_57627,null));
var state_57660__$1 = state_57660;
var statearr_57668_57695 = state_57660__$1;
(statearr_57668_57695[(2)] = inst_57628);

(statearr_57668_57695[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57661 === (3))){
var inst_57658 = (state_57660[(2)]);
var state_57660__$1 = state_57660;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57660__$1,inst_57658);
} else {
if((state_val_57661 === (12))){
var inst_57634 = (state_57660[(2)]);
var inst_57635 = fluree.db.util.async.throw_err.call(null,inst_57634);
var state_57660__$1 = state_57660;
var statearr_57669_57696 = state_57660__$1;
(statearr_57669_57696[(2)] = inst_57635);

(statearr_57669_57696[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57661 === (2))){
var _ = (function (){var statearr_57670 = state_57660;
(statearr_57670[(4)] = cljs.core.cons.call(null,(5),(state_57660[(4)])));

return statearr_57670;
})();
var inst_57623 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57660__$1 = state_57660;
if(cljs.core.truth_(inst_57623)){
var statearr_57671_57697 = state_57660__$1;
(statearr_57671_57697[(1)] = (6));

} else {
var statearr_57672_57698 = state_57660__$1;
(statearr_57672_57698[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57661 === (11))){
var inst_57643 = (state_57660[(2)]);
var state_57660__$1 = state_57660;
var statearr_57674_57699 = state_57660__$1;
(statearr_57674_57699[(2)] = inst_57643);

(statearr_57674_57699[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57661 === (9))){
var inst_57632 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth.call(null,_QMARK_ctx);
var state_57660__$1 = state_57660;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57660__$1,(12),inst_57632);
} else {
if((state_val_57661 === (5))){
var _ = (function (){var statearr_57675 = state_57660;
(statearr_57675[(4)] = cljs.core.rest.call(null,(state_57660[(4)])));

return statearr_57675;
})();
var state_57660__$1 = state_57660;
var ex57673 = (state_57660__$1[(2)]);
var statearr_57676_57700 = state_57660__$1;
(statearr_57676_57700[(5)] = ex57673);


if((ex57673 instanceof Error)){
var statearr_57677_57701 = state_57660__$1;
(statearr_57677_57701[(1)] = (4));

(statearr_57677_57701[(5)] = null);

} else {
throw ex57673;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57661 === (14))){
var state_57660__$1 = state_57660;
var statearr_57678_57702 = state_57660__$1;
(statearr_57678_57702[(2)] = null);

(statearr_57678_57702[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57661 === (10))){
var state_57660__$1 = state_57660;
var statearr_57679_57703 = state_57660__$1;
(statearr_57679_57703[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57661 === (8))){
var inst_57645 = (state_57660[(2)]);
var inst_57646 = cljs.core.nth.call(null,inst_57645,(0),null);
var inst_57647 = cljs.core.nth.call(null,inst_57645,(1),null);
var inst_57648 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57649 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57650 = ["?user_id","?ctx",inst_57646];
var inst_57651 = cljs.core.PersistentHashMap.fromArrays(inst_57649,inst_57650);
var inst_57652 = ((10) + inst_57647);
var inst_57653 = [inst_57651,inst_57652];
var inst_57654 = (new cljs.core.PersistentVector(null,2,(5),inst_57648,inst_57653,null));
var inst_57655 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57654);
var _ = (function (){var statearr_57681 = state_57660;
(statearr_57681[(4)] = cljs.core.rest.call(null,(state_57660[(4)])));

return statearr_57681;
})();
var state_57660__$1 = (function (){var statearr_57682 = state_57660;
(statearr_57682[(7)] = inst_57655);

return statearr_57682;
})();
var statearr_57683_57704 = state_57660__$1;
(statearr_57683_57704[(2)] = inst_57646);

(statearr_57683_57704[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____0 = (function (){
var statearr_57684 = [null,null,null,null,null,null,null,null];
(statearr_57684[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__);

(statearr_57684[(1)] = (1));

return statearr_57684;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____1 = (function (state_57660){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57660);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57685){var ex__2749__auto__ = e57685;
var statearr_57686_57705 = state_57660;
(statearr_57686_57705[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57660[(4)]))){
var statearr_57687_57706 = state_57660;
(statearr_57687_57706[(1)] = cljs.core.first.call(null,(state_57660[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57707 = state_57660;
state_57660 = G__57707;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__ = function(state_57660){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____1.call(this,state_57660);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57688 = f__2769__auto__.call(null);
(statearr_57688[(6)] = c__2768__auto__);

return statearr_57688;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57735){
var state_val_57736 = (state_57735[(1)]);
if((state_val_57736 === (7))){
var inst_57728 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_57735__$1 = state_57735;
var statearr_57737_57756 = state_57735__$1;
(statearr_57737_57756[(2)] = inst_57728);

(statearr_57737_57756[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57736 === (1))){
var state_57735__$1 = state_57735;
var statearr_57738_57757 = state_57735__$1;
(statearr_57738_57757[(2)] = null);

(statearr_57738_57757[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57736 === (4))){
var inst_57708 = (state_57735[(2)]);
var state_57735__$1 = state_57735;
var statearr_57739_57758 = state_57735__$1;
(statearr_57739_57758[(2)] = inst_57708);

(statearr_57739_57758[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57736 === (6))){
var inst_57716 = fluree.db.dbfunctions.internal._QMARK_auth_id.call(null,_QMARK_ctx);
var state_57735__$1 = state_57735;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57735__$1,(9),inst_57716);
} else {
if((state_val_57736 === (3))){
var inst_57733 = (state_57735[(2)]);
var state_57735__$1 = state_57735;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57735__$1,inst_57733);
} else {
if((state_val_57736 === (2))){
var _ = (function (){var statearr_57741 = state_57735;
(statearr_57741[(4)] = cljs.core.cons.call(null,(5),(state_57735[(4)])));

return statearr_57741;
})();
var inst_57714 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57735__$1 = state_57735;
if(cljs.core.truth_(inst_57714)){
var statearr_57742_57759 = state_57735__$1;
(statearr_57742_57759[(1)] = (6));

} else {
var statearr_57743_57760 = state_57735__$1;
(statearr_57743_57760[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57736 === (9))){
var inst_57718 = (state_57735[(2)]);
var inst_57719 = fluree.db.util.async.throw_err.call(null,inst_57718);
var inst_57720 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57721 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57722 = ["?auth_id","?ctx",inst_57719];
var inst_57723 = cljs.core.PersistentHashMap.fromArrays(inst_57721,inst_57722);
var inst_57724 = [inst_57723,(10)];
var inst_57725 = (new cljs.core.PersistentVector(null,2,(5),inst_57720,inst_57724,null));
var inst_57726 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57725);
var state_57735__$1 = (function (){var statearr_57744 = state_57735;
(statearr_57744[(7)] = inst_57726);

return statearr_57744;
})();
var statearr_57745_57761 = state_57735__$1;
(statearr_57745_57761[(2)] = inst_57719);

(statearr_57745_57761[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57736 === (5))){
var _ = (function (){var statearr_57746 = state_57735;
(statearr_57746[(4)] = cljs.core.rest.call(null,(state_57735[(4)])));

return statearr_57746;
})();
var state_57735__$1 = state_57735;
var ex57740 = (state_57735__$1[(2)]);
var statearr_57747_57762 = state_57735__$1;
(statearr_57747_57762[(5)] = ex57740);


if((ex57740 instanceof Error)){
var statearr_57748_57763 = state_57735__$1;
(statearr_57748_57763[(1)] = (4));

(statearr_57748_57763[(5)] = null);

} else {
throw ex57740;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57736 === (8))){
var inst_57730 = (state_57735[(2)]);
var _ = (function (){var statearr_57749 = state_57735;
(statearr_57749[(4)] = cljs.core.rest.call(null,(state_57735[(4)])));

return statearr_57749;
})();
var state_57735__$1 = state_57735;
var statearr_57750_57764 = state_57735__$1;
(statearr_57750_57764[(2)] = inst_57730);

(statearr_57750_57764[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____0 = (function (){
var statearr_57751 = [null,null,null,null,null,null,null,null];
(statearr_57751[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__);

(statearr_57751[(1)] = (1));

return statearr_57751;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____1 = (function (state_57735){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57735);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57752){var ex__2749__auto__ = e57752;
var statearr_57753_57765 = state_57735;
(statearr_57753_57765[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57735[(4)]))){
var statearr_57754_57766 = state_57735;
(statearr_57754_57766[(1)] = cljs.core.first.call(null,(state_57735[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57767 = state_57735;
state_57735 = G__57767;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__ = function(state_57735){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____1.call(this,state_57735);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57755 = f__2769__auto__.call(null);
(statearr_57755[(6)] = c__2768__auto__);

return statearr_57755;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__57769 = arguments.length;
switch (G__57769) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.call(null,_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57811){
var state_val_57812 = (state_57811[(1)]);
if((state_val_57812 === (7))){
var state_57811__$1 = state_57811;
var statearr_57813_57843 = state_57811__$1;
(statearr_57813_57843[(2)] = seed);

(statearr_57813_57843[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57812 === (1))){
var state_57811__$1 = state_57811;
var statearr_57814_57844 = state_57811__$1;
(statearr_57814_57844[(2)] = null);

(statearr_57814_57844[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57812 === (4))){
var inst_57770 = (state_57811[(2)]);
var state_57811__$1 = state_57811;
var statearr_57815_57845 = state_57811__$1;
(statearr_57815_57845[(2)] = inst_57770);

(statearr_57815_57845[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57812 === (15))){
var state_57811__$1 = state_57811;
var statearr_57816_57846 = state_57811__$1;
(statearr_57816_57846[(2)] = (10));

(statearr_57816_57846[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57812 === (13))){
var inst_57787 = (state_57811[(2)]);
var inst_57788 = fluree.db.util.async.throw_err.call(null,inst_57787);
var state_57811__$1 = state_57811;
var statearr_57817_57847 = state_57811__$1;
(statearr_57817_57847[(2)] = inst_57788);

(statearr_57817_57847[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57812 === (6))){
var state_57811__$1 = state_57811;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57811__$1,(9),seed);
} else {
if((state_val_57812 === (3))){
var inst_57809 = (state_57811[(2)]);
var state_57811__$1 = state_57811;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57811__$1,inst_57809);
} else {
if((state_val_57812 === (12))){
var inst_57791 = (state_57811[(7)]);
var inst_57791__$1 = (state_57811[(2)]);
var state_57811__$1 = (function (){var statearr_57818 = state_57811;
(statearr_57818[(7)] = inst_57791__$1);

return statearr_57818;
})();
if(cljs.core.truth_(inst_57791__$1)){
var statearr_57819_57848 = state_57811__$1;
(statearr_57819_57848[(1)] = (14));

} else {
var statearr_57820_57849 = state_57811__$1;
(statearr_57820_57849[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57812 === (2))){
var _ = (function (){var statearr_57821 = state_57811;
(statearr_57821[(4)] = cljs.core.cons.call(null,(5),(state_57811[(4)])));

return statearr_57821;
})();
var inst_57776 = fluree.db.util.async.channel_QMARK_.call(null,seed);
var state_57811__$1 = state_57811;
if(inst_57776){
var statearr_57822_57850 = state_57811__$1;
(statearr_57822_57850[(1)] = (6));

} else {
var statearr_57823_57851 = state_57811__$1;
(statearr_57823_57851[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57812 === (11))){
var state_57811__$1 = state_57811;
var statearr_57825_57852 = state_57811__$1;
(statearr_57825_57852[(2)] = max);

(statearr_57825_57852[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57812 === (9))){
var inst_57779 = (state_57811[(2)]);
var inst_57780 = fluree.db.util.async.throw_err.call(null,inst_57779);
var state_57811__$1 = state_57811;
var statearr_57826_57853 = state_57811__$1;
(statearr_57826_57853[(2)] = inst_57780);

(statearr_57826_57853[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57812 === (5))){
var _ = (function (){var statearr_57827 = state_57811;
(statearr_57827[(4)] = cljs.core.rest.call(null,(state_57811[(4)])));

return statearr_57827;
})();
var state_57811__$1 = state_57811;
var ex57824 = (state_57811__$1[(2)]);
var statearr_57828_57854 = state_57811__$1;
(statearr_57828_57854[(5)] = ex57824);


if((ex57824 instanceof Error)){
var statearr_57829_57855 = state_57811__$1;
(statearr_57829_57855[(1)] = (4));

(statearr_57829_57855[(5)] = null);

} else {
throw ex57824;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57812 === (14))){
var inst_57791 = (state_57811[(7)]);
var state_57811__$1 = state_57811;
var statearr_57830_57856 = state_57811__$1;
(statearr_57830_57856[(2)] = inst_57791);

(statearr_57830_57856[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57812 === (16))){
var inst_57783 = (state_57811[(8)]);
var inst_57795 = (state_57811[(2)]);
var inst_57796 = fluree.db.dbfunctions.internal.rand.call(null,inst_57783,inst_57795);
var inst_57797 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57798 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57799 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57800 = [max,seed];
var inst_57801 = (new cljs.core.PersistentVector(null,2,(5),inst_57799,inst_57800,null));
var inst_57802 = ["rand",inst_57801,inst_57796];
var inst_57803 = cljs.core.PersistentHashMap.fromArrays(inst_57798,inst_57802);
var inst_57804 = [inst_57803,(10)];
var inst_57805 = (new cljs.core.PersistentVector(null,2,(5),inst_57797,inst_57804,null));
var inst_57806 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57805);
var _ = (function (){var statearr_57831 = state_57811;
(statearr_57831[(4)] = cljs.core.rest.call(null,(state_57811[(4)])));

return statearr_57831;
})();
var state_57811__$1 = (function (){var statearr_57832 = state_57811;
(statearr_57832[(9)] = inst_57806);

return statearr_57832;
})();
var statearr_57833_57857 = state_57811__$1;
(statearr_57833_57857[(2)] = inst_57796);

(statearr_57833_57857[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57812 === (10))){
var state_57811__$1 = state_57811;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57811__$1,(13),max);
} else {
if((state_val_57812 === (8))){
var inst_57783 = (state_57811[(2)]);
var inst_57784 = fluree.db.util.async.channel_QMARK_.call(null,max);
var state_57811__$1 = (function (){var statearr_57834 = state_57811;
(statearr_57834[(8)] = inst_57783);

return statearr_57834;
})();
if(inst_57784){
var statearr_57835_57858 = state_57811__$1;
(statearr_57835_57858[(1)] = (10));

} else {
var statearr_57836_57859 = state_57811__$1;
(statearr_57836_57859[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_57837 = [null,null,null,null,null,null,null,null,null,null];
(statearr_57837[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_57837[(1)] = (1));

return statearr_57837;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_57811){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57811);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57838){var ex__2749__auto__ = e57838;
var statearr_57839_57860 = state_57811;
(statearr_57839_57860[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57811[(4)]))){
var statearr_57840_57861 = state_57811;
(statearr_57840_57861[(1)] = cljs.core.first.call(null,(state_57811[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57862 = state_57811;
state_57811 = G__57862;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_57811){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_57811);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57841 = f__2769__auto__.call(null);
(statearr_57841[(6)] = c__2768__auto__);

return statearr_57841;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57883){
var state_val_57884 = (state_57883[(1)]);
if((state_val_57884 === (1))){
var state_57883__$1 = state_57883;
var statearr_57885_57900 = state_57883__$1;
(statearr_57885_57900[(2)] = null);

(statearr_57885_57900[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57884 === (2))){
var _ = (function (){var statearr_57886 = state_57883;
(statearr_57886[(4)] = cljs.core.cons.call(null,(5),(state_57883[(4)])));

return statearr_57886;
})();
var inst_57869 = cljs.core.random_uuid.call(null);
var inst_57870 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_57869);
var inst_57871 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57872 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57873 = cljs.core.PersistentVector.EMPTY;
var inst_57874 = ["uuid",inst_57873,inst_57870];
var inst_57875 = cljs.core.PersistentHashMap.fromArrays(inst_57872,inst_57874);
var inst_57876 = [inst_57875,(10)];
var inst_57877 = (new cljs.core.PersistentVector(null,2,(5),inst_57871,inst_57876,null));
var inst_57878 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57877);
var ___$1 = (function (){var statearr_57887 = state_57883;
(statearr_57887[(4)] = cljs.core.rest.call(null,(state_57883[(4)])));

return statearr_57887;
})();
var state_57883__$1 = (function (){var statearr_57888 = state_57883;
(statearr_57888[(7)] = inst_57878);

return statearr_57888;
})();
var statearr_57889_57901 = state_57883__$1;
(statearr_57889_57901[(2)] = inst_57870);

(statearr_57889_57901[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57884 === (3))){
var inst_57881 = (state_57883[(2)]);
var state_57883__$1 = state_57883;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57883__$1,inst_57881);
} else {
if((state_val_57884 === (4))){
var inst_57863 = (state_57883[(2)]);
var state_57883__$1 = state_57883;
var statearr_57891_57902 = state_57883__$1;
(statearr_57891_57902[(2)] = inst_57863);

(statearr_57891_57902[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57884 === (5))){
var _ = (function (){var statearr_57892 = state_57883;
(statearr_57892[(4)] = cljs.core.rest.call(null,(state_57883[(4)])));

return statearr_57892;
})();
var state_57883__$1 = state_57883;
var ex57890 = (state_57883__$1[(2)]);
var statearr_57893_57903 = state_57883__$1;
(statearr_57893_57903[(5)] = ex57890);


if((ex57890 instanceof Error)){
var statearr_57894_57904 = state_57883__$1;
(statearr_57894_57904[(1)] = (4));

(statearr_57894_57904[(5)] = null);

} else {
throw ex57890;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____0 = (function (){
var statearr_57895 = [null,null,null,null,null,null,null,null];
(statearr_57895[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__);

(statearr_57895[(1)] = (1));

return statearr_57895;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____1 = (function (state_57883){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57883);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57896){var ex__2749__auto__ = e57896;
var statearr_57897_57905 = state_57883;
(statearr_57897_57905[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57883[(4)]))){
var statearr_57898_57906 = state_57883;
(statearr_57898_57906[(1)] = cljs.core.first.call(null,(state_57883[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57907 = state_57883;
state_57883 = G__57907;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__ = function(state_57883){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____1.call(this,state_57883);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57899 = f__2769__auto__.call(null);
(statearr_57899[(6)] = c__2768__auto__);

return statearr_57899;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57937){
var state_val_57938 = (state_57937[(1)]);
if((state_val_57938 === (7))){
var state_57937__$1 = state_57937;
var statearr_57939_57958 = state_57937__$1;
(statearr_57939_57958[(2)] = num);

(statearr_57939_57958[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57938 === (1))){
var state_57937__$1 = state_57937;
var statearr_57940_57959 = state_57937__$1;
(statearr_57940_57959[(2)] = null);

(statearr_57940_57959[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57938 === (4))){
var inst_57908 = (state_57937[(2)]);
var state_57937__$1 = state_57937;
var statearr_57941_57960 = state_57937__$1;
(statearr_57941_57960[(2)] = inst_57908);

(statearr_57941_57960[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57938 === (6))){
var state_57937__$1 = state_57937;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57937__$1,(9),num);
} else {
if((state_val_57938 === (3))){
var inst_57935 = (state_57937[(2)]);
var state_57937__$1 = state_57937;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57937__$1,inst_57935);
} else {
if((state_val_57938 === (2))){
var _ = (function (){var statearr_57943 = state_57937;
(statearr_57943[(4)] = cljs.core.cons.call(null,(5),(state_57937[(4)])));

return statearr_57943;
})();
var inst_57914 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_57937__$1 = state_57937;
if(inst_57914){
var statearr_57944_57961 = state_57937__$1;
(statearr_57944_57961[(1)] = (6));

} else {
var statearr_57945_57962 = state_57937__$1;
(statearr_57945_57962[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57938 === (9))){
var inst_57917 = (state_57937[(2)]);
var inst_57918 = fluree.db.util.async.throw_err.call(null,inst_57917);
var state_57937__$1 = state_57937;
var statearr_57946_57963 = state_57937__$1;
(statearr_57946_57963[(2)] = inst_57918);

(statearr_57946_57963[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57938 === (5))){
var _ = (function (){var statearr_57947 = state_57937;
(statearr_57947[(4)] = cljs.core.rest.call(null,(state_57937[(4)])));

return statearr_57947;
})();
var state_57937__$1 = state_57937;
var ex57942 = (state_57937__$1[(2)]);
var statearr_57948_57964 = state_57937__$1;
(statearr_57948_57964[(5)] = ex57942);


if((ex57942 instanceof Error)){
var statearr_57949_57965 = state_57937__$1;
(statearr_57949_57965[(1)] = (4));

(statearr_57949_57965[(5)] = null);

} else {
throw ex57942;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57938 === (8))){
var inst_57921 = (state_57937[(2)]);
var inst_57922 = fluree.db.dbfunctions.internal.ceil.call(null,inst_57921);
var inst_57923 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57924 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57925 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57926 = [fluree.db.dbfunctions.fns.ceil];
var inst_57927 = (new cljs.core.PersistentVector(null,1,(5),inst_57925,inst_57926,null));
var inst_57928 = ["",inst_57927,inst_57922];
var inst_57929 = cljs.core.PersistentHashMap.fromArrays(inst_57924,inst_57928);
var inst_57930 = [inst_57929,(10)];
var inst_57931 = (new cljs.core.PersistentVector(null,2,(5),inst_57923,inst_57930,null));
var inst_57932 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57931);
var _ = (function (){var statearr_57950 = state_57937;
(statearr_57950[(4)] = cljs.core.rest.call(null,(state_57937[(4)])));

return statearr_57950;
})();
var state_57937__$1 = (function (){var statearr_57951 = state_57937;
(statearr_57951[(7)] = inst_57932);

return statearr_57951;
})();
var statearr_57952_57966 = state_57937__$1;
(statearr_57952_57966[(2)] = inst_57922);

(statearr_57952_57966[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____0 = (function (){
var statearr_57953 = [null,null,null,null,null,null,null,null];
(statearr_57953[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__);

(statearr_57953[(1)] = (1));

return statearr_57953;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____1 = (function (state_57937){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57937);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57954){var ex__2749__auto__ = e57954;
var statearr_57955_57967 = state_57937;
(statearr_57955_57967[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57937[(4)]))){
var statearr_57956_57968 = state_57937;
(statearr_57956_57968[(1)] = cljs.core.first.call(null,(state_57937[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57969 = state_57937;
state_57937 = G__57969;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__ = function(state_57937){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____1.call(this,state_57937);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57957 = f__2769__auto__.call(null);
(statearr_57957[(6)] = c__2768__auto__);

return statearr_57957;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57999){
var state_val_58000 = (state_57999[(1)]);
if((state_val_58000 === (7))){
var state_57999__$1 = state_57999;
var statearr_58001_58020 = state_57999__$1;
(statearr_58001_58020[(2)] = num);

(statearr_58001_58020[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58000 === (1))){
var state_57999__$1 = state_57999;
var statearr_58002_58021 = state_57999__$1;
(statearr_58002_58021[(2)] = null);

(statearr_58002_58021[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58000 === (4))){
var inst_57970 = (state_57999[(2)]);
var state_57999__$1 = state_57999;
var statearr_58003_58022 = state_57999__$1;
(statearr_58003_58022[(2)] = inst_57970);

(statearr_58003_58022[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58000 === (6))){
var state_57999__$1 = state_57999;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57999__$1,(9),num);
} else {
if((state_val_58000 === (3))){
var inst_57997 = (state_57999[(2)]);
var state_57999__$1 = state_57999;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57999__$1,inst_57997);
} else {
if((state_val_58000 === (2))){
var _ = (function (){var statearr_58005 = state_57999;
(statearr_58005[(4)] = cljs.core.cons.call(null,(5),(state_57999[(4)])));

return statearr_58005;
})();
var inst_57976 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_57999__$1 = state_57999;
if(inst_57976){
var statearr_58006_58023 = state_57999__$1;
(statearr_58006_58023[(1)] = (6));

} else {
var statearr_58007_58024 = state_57999__$1;
(statearr_58007_58024[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58000 === (9))){
var inst_57979 = (state_57999[(2)]);
var inst_57980 = fluree.db.util.async.throw_err.call(null,inst_57979);
var state_57999__$1 = state_57999;
var statearr_58008_58025 = state_57999__$1;
(statearr_58008_58025[(2)] = inst_57980);

(statearr_58008_58025[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58000 === (5))){
var _ = (function (){var statearr_58009 = state_57999;
(statearr_58009[(4)] = cljs.core.rest.call(null,(state_57999[(4)])));

return statearr_58009;
})();
var state_57999__$1 = state_57999;
var ex58004 = (state_57999__$1[(2)]);
var statearr_58010_58026 = state_57999__$1;
(statearr_58010_58026[(5)] = ex58004);


if((ex58004 instanceof Error)){
var statearr_58011_58027 = state_57999__$1;
(statearr_58011_58027[(1)] = (4));

(statearr_58011_58027[(5)] = null);

} else {
throw ex58004;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58000 === (8))){
var inst_57983 = (state_57999[(2)]);
var inst_57984 = fluree.db.dbfunctions.internal.floor.call(null,inst_57983);
var inst_57985 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57986 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57987 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57988 = [fluree.db.dbfunctions.fns.floor];
var inst_57989 = (new cljs.core.PersistentVector(null,1,(5),inst_57987,inst_57988,null));
var inst_57990 = ["",inst_57989,inst_57984];
var inst_57991 = cljs.core.PersistentHashMap.fromArrays(inst_57986,inst_57990);
var inst_57992 = [inst_57991,(10)];
var inst_57993 = (new cljs.core.PersistentVector(null,2,(5),inst_57985,inst_57992,null));
var inst_57994 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57993);
var _ = (function (){var statearr_58012 = state_57999;
(statearr_58012[(4)] = cljs.core.rest.call(null,(state_57999[(4)])));

return statearr_58012;
})();
var state_57999__$1 = (function (){var statearr_58013 = state_57999;
(statearr_58013[(7)] = inst_57994);

return statearr_58013;
})();
var statearr_58014_58028 = state_57999__$1;
(statearr_58014_58028[(2)] = inst_57984);

(statearr_58014_58028[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____0 = (function (){
var statearr_58015 = [null,null,null,null,null,null,null,null];
(statearr_58015[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__);

(statearr_58015[(1)] = (1));

return statearr_58015;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____1 = (function (state_57999){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57999);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e58016){var ex__2749__auto__ = e58016;
var statearr_58017_58029 = state_57999;
(statearr_58017_58029[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57999[(4)]))){
var statearr_58018_58030 = state_57999;
(statearr_58018_58030[(1)] = cljs.core.first.call(null,(state_57999[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58031 = state_57999;
state_57999 = G__58031;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__ = function(state_57999){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____1.call(this,state_57999);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_58019 = f__2769__auto__.call(null);
(statearr_58019[(6)] = c__2768__auto__);

return statearr_58019;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_58056){
var state_val_58057 = (state_58056[(1)]);
if((state_val_58057 === (1))){
var state_58056__$1 = state_58056;
var statearr_58058_58073 = state_58056__$1;
(statearr_58058_58073[(2)] = null);

(statearr_58058_58073[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58057 === (2))){
var _ = (function (){var statearr_58059 = state_58056;
(statearr_58059[(4)] = cljs.core.cons.call(null,(5),(state_58056[(4)])));

return statearr_58059;
})();
var inst_58038 = fluree.db.dbfunctions.internal.cas.call(null,_QMARK_ctx,compare_val,new_val);
var state_58056__$1 = state_58056;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58056__$1,(6),inst_58038);
} else {
if((state_val_58057 === (3))){
var inst_58054 = (state_58056[(2)]);
var state_58056__$1 = state_58056;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58056__$1,inst_58054);
} else {
if((state_val_58057 === (4))){
var inst_58032 = (state_58056[(2)]);
var state_58056__$1 = state_58056;
var statearr_58061_58074 = state_58056__$1;
(statearr_58061_58074[(2)] = inst_58032);

(statearr_58061_58074[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58057 === (5))){
var _ = (function (){var statearr_58062 = state_58056;
(statearr_58062[(4)] = cljs.core.rest.call(null,(state_58056[(4)])));

return statearr_58062;
})();
var state_58056__$1 = state_58056;
var ex58060 = (state_58056__$1[(2)]);
var statearr_58063_58075 = state_58056__$1;
(statearr_58063_58075[(5)] = ex58060);


if((ex58060 instanceof Error)){
var statearr_58064_58076 = state_58056__$1;
(statearr_58064_58076[(1)] = (4));

(statearr_58064_58076[(5)] = null);

} else {
throw ex58060;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58057 === (6))){
var inst_58040 = (state_58056[(2)]);
var inst_58041 = fluree.db.util.async.throw_err.call(null,inst_58040);
var inst_58042 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58043 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_58044 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58045 = [compare_val,new_val];
var inst_58046 = (new cljs.core.PersistentVector(null,2,(5),inst_58044,inst_58045,null));
var inst_58047 = ["",inst_58046,inst_58041];
var inst_58048 = cljs.core.PersistentHashMap.fromArrays(inst_58043,inst_58047);
var inst_58049 = [inst_58048,(10)];
var inst_58050 = (new cljs.core.PersistentVector(null,2,(5),inst_58042,inst_58049,null));
var inst_58051 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_58050);
var _ = (function (){var statearr_58065 = state_58056;
(statearr_58065[(4)] = cljs.core.rest.call(null,(state_58056[(4)])));

return statearr_58065;
})();
var state_58056__$1 = (function (){var statearr_58066 = state_58056;
(statearr_58066[(7)] = inst_58051);

return statearr_58066;
})();
var statearr_58067_58077 = state_58056__$1;
(statearr_58067_58077[(2)] = inst_58041);

(statearr_58067_58077[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____0 = (function (){
var statearr_58068 = [null,null,null,null,null,null,null,null];
(statearr_58068[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__);

(statearr_58068[(1)] = (1));

return statearr_58068;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____1 = (function (state_58056){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_58056);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e58069){var ex__2749__auto__ = e58069;
var statearr_58070_58078 = state_58056;
(statearr_58070_58078[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_58056[(4)]))){
var statearr_58071_58079 = state_58056;
(statearr_58071_58079[(1)] = cljs.core.first.call(null,(state_58056[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58080 = state_58056;
state_58056 = G__58080;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__ = function(state_58056){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____1.call(this,state_58056);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_58072 = f__2769__auto__.call(null);
(statearr_58072[(6)] = c__2768__auto__);

return statearr_58072;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
