// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.range');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.call(null,param_str):param_str);
if(cljs.core.map_QMARK_.call(null,parsed_param)){
var key = cljs.core.first.call(null,cljs.core.keys.call(null,parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace.call(null,key) == null))?cljs.core.name.call(null,key):[cljs.core.namespace.call(null,key),"/",cljs.core.name.call(null,key)].join('')));
var value = cljs.core.first.call(null,cljs.core.vals.call(null,parsed_param));
var value_SINGLEQUOTE_ = fluree.db.dbfunctions.internal.parse_select_map.call(null,value);
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,value_SINGLEQUOTE_))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.call(null,cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_.call(null,parsed_param)))){
if((cljs.core.namespace.call(null,parsed_param) == null)){
return cljs.core.name.call(null,parsed_param);
} else {
return [cljs.core.namespace.call(null,parsed_param),"/",cljs.core.name.call(null,parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_.call(null,parsed_param)){
return cljs.core.mapv.call(null,fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.call(null,["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28031 = arguments.length;
var i__5770__auto___28032 = (0);
while(true){
if((i__5770__auto___28032 < len__5769__auto___28031)){
args__5775__auto__.push((arguments[i__5770__auto___28032]));

var G__28033 = (i__5770__auto___28032 + (1));
i__5770__auto___28032 = G__28033;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.call(null,e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.call(null,args));

throw cljs.core.ex_info.call(null,(function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,args))?clojure.string.join.call(null," ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq28028){
var G__28029 = cljs.core.first.call(null,seq28028);
var seq28028__$1 = cljs.core.next.call(null,seq28028);
var G__28030 = cljs.core.first.call(null,seq28028__$1);
var seq28028__$2 = cljs.core.next.call(null,seq28028__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28029,G__28030,seq28028__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$.call(null,x);
}catch (e28034){var e = e28034;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"boolean",x);
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e28035){var e = e28035;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nil?",arg);
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not.call(null,arg);
}catch (e28036){var e = e28036;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not",arg);
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_.call(null,arg)) || (cljs.core._EQ_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e28037){var e = e28037;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"empty?",arg);
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e28038){var e = e28038;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"if-else",test,true_res,false_res);
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28041 = arguments.length;
var i__5770__auto___28042 = (0);
while(true){
if((i__5770__auto___28042 < len__5769__auto___28041)){
args__5775__auto__.push((arguments[i__5770__auto___28042]));

var G__28043 = (i__5770__auto___28042 + (1));
i__5770__auto___28042 = G__28043;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28040){var e = e28040;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"and",args);
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq28039){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28039));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28046 = arguments.length;
var i__5770__auto___28047 = (0);
while(true){
if((i__5770__auto___28047 < len__5769__auto___28046)){
args__5775__auto__.push((arguments[i__5770__auto___28047]));

var G__28048 = (i__5770__auto___28047 + (1));
i__5770__auto___28047 = G__28048;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.some.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28045){var e = e28045;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"or",args);
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq28044){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28044));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count.call(null,coll);
}catch (e28049){var e = e28049;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"count",coll);
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28052 = arguments.length;
var i__5770__auto___28053 = (0);
while(true){
if((i__5770__auto___28053 < len__5769__auto___28052)){
args__5775__auto__.push((arguments[i__5770__auto___28053]));

var G__28054 = (i__5770__auto___28053 + (1));
i__5770__auto___28053 = G__28054;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.str,args);
}catch (e28051){var e = e28051;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"str",args);
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq28050){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28050));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28057 = arguments.length;
var i__5770__auto___28058 = (0);
while(true){
if((i__5770__auto___28058 < len__5769__auto___28057)){
args__5775__auto__.push((arguments[i__5770__auto___28058]));

var G__28059 = (i__5770__auto___28058 + (1));
i__5770__auto___28058 = G__28059;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.subs,args);
}catch (e28056){var e = e28056;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"subs",args);
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq28055){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28055));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case.call(null,str);
}catch (e28060){var e = e28060;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"lower-case",str);
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case.call(null,str);
}catch (e28061){var e = e28061;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"upper-case",str);
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28064 = arguments.length;
var i__5770__auto___28065 = (0);
while(true){
if((i__5770__auto___28065 < len__5769__auto___28064)){
args__5775__auto__.push((arguments[i__5770__auto___28065]));

var G__28066 = (i__5770__auto___28065 + (1));
i__5770__auto___28065 = G__28066;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.max,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28063){var e = e28063;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"max",args);
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq28062){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28062));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28069 = arguments.length;
var i__5770__auto___28070 = (0);
while(true){
if((i__5770__auto___28070 < len__5769__auto___28069)){
args__5775__auto__.push((arguments[i__5770__auto___28070]));

var G__28071 = (i__5770__auto___28070 + (1));
i__5770__auto___28070 = G__28071;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28068){var e = e28068;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"min",args);
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq28067){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28067));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28074 = arguments.length;
var i__5770__auto___28075 = (0);
while(true){
if((i__5770__auto___28075 < len__5769__auto___28074)){
args__5775__auto__.push((arguments[i__5770__auto___28075]));

var G__28076 = (i__5770__auto___28075 + (1));
i__5770__auto___28075 = G__28076;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT_,args);
}catch (e28073){var e = e28073;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">",args);
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq28072){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28072));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28079 = arguments.length;
var i__5770__auto___28080 = (0);
while(true){
if((i__5770__auto___28080 < len__5769__auto___28079)){
args__5775__auto__.push((arguments[i__5770__auto___28080]));

var G__28081 = (i__5770__auto___28080 + (1));
i__5770__auto___28080 = G__28081;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT__EQ_,args);
}catch (e28078){var e = e28078;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">=",args);
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq28077){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28077));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28084 = arguments.length;
var i__5770__auto___28085 = (0);
while(true){
if((i__5770__auto___28085 < len__5769__auto___28084)){
args__5775__auto__.push((arguments[i__5770__auto___28085]));

var G__28086 = (i__5770__auto___28085 + (1));
i__5770__auto___28085 = G__28086;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT_,args);
}catch (e28083){var e = e28083;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<",args);
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq28082){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28082));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28089 = arguments.length;
var i__5770__auto___28090 = (0);
while(true){
if((i__5770__auto___28090 < len__5769__auto___28089)){
args__5775__auto__.push((arguments[i__5770__auto___28090]));

var G__28091 = (i__5770__auto___28090 + (1));
i__5770__auto___28090 = G__28091;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT__EQ_,args);
}catch (e28088){var e = e28088;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<=",args);
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq28087){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28087));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28094 = arguments.length;
var i__5770__auto___28095 = (0);
while(true){
if((i__5770__auto___28095 < len__5769__auto___28094)){
args__5775__auto__.push((arguments[i__5770__auto___28095]));

var G__28096 = (i__5770__auto___28095 + (1));
i__5770__auto___28095 = G__28096;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.not_EQ_,args);
}catch (e28093){var e = e28093;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not=",args);
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq28092){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28092));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__28098 = arguments.length;
switch (G__28098) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28126){
var state_val_28127 = (state_28126[(1)]);
if((state_val_28127 === (7))){
var inst_28111 = (state_28126[(7)]);
var inst_28114 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28111,"query",query_map);
var state_28126__$1 = state_28126;
var statearr_28128_28214 = state_28126__$1;
(statearr_28128_28214[(2)] = inst_28114);

(statearr_28128_28214[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28127 === (1))){
var state_28126__$1 = state_28126;
var statearr_28129_28215 = state_28126__$1;
(statearr_28129_28215[(2)] = null);

(statearr_28129_28215[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28127 === (4))){
var inst_28099 = (state_28126[(2)]);
var state_28126__$1 = state_28126;
var statearr_28130_28216 = state_28126__$1;
(statearr_28130_28216[(2)] = inst_28099);

(statearr_28130_28216[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28127 === (6))){
var inst_28111 = (state_28126[(7)]);
var inst_28111__$1 = (state_28126[(2)]);
var inst_28112 = fluree.db.util.core.exception_QMARK_.call(null,inst_28111__$1);
var state_28126__$1 = (function (){var statearr_28131 = state_28126;
(statearr_28131[(7)] = inst_28111__$1);

return statearr_28131;
})();
if(inst_28112){
var statearr_28132_28217 = state_28126__$1;
(statearr_28132_28217[(1)] = (7));

} else {
var statearr_28133_28218 = state_28126__$1;
(statearr_28133_28218[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28127 === (3))){
var inst_28124 = (state_28126[(2)]);
var state_28126__$1 = state_28126;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28126__$1,inst_28124);
} else {
if((state_val_28127 === (2))){
var inst_28105 = (state_28126[(8)]);
var _ = (function (){var statearr_28135 = state_28126;
(statearr_28135[(4)] = cljs.core.cons.call(null,(5),(state_28126[(4)])));

return statearr_28135;
})();
var inst_28105__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_28106 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_28107 = cljs.core.assoc.call(null,inst_28106,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_28105__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000));
var inst_28108 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_28107);
var inst_28109 = fluree.db.query.fql.query.call(null,db,inst_28108);
var state_28126__$1 = (function (){var statearr_28136 = state_28126;
(statearr_28136[(8)] = inst_28105__$1);

return statearr_28136;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28126__$1,(6),inst_28109);
} else {
if((state_val_28127 === (9))){
var inst_28121 = (state_28126[(2)]);
var _ = (function (){var statearr_28137 = state_28126;
(statearr_28137[(4)] = cljs.core.rest.call(null,(state_28126[(4)])));

return statearr_28137;
})();
var state_28126__$1 = state_28126;
var statearr_28138_28219 = state_28126__$1;
(statearr_28138_28219[(2)] = inst_28121);

(statearr_28138_28219[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28127 === (5))){
var _ = (function (){var statearr_28139 = state_28126;
(statearr_28139[(4)] = cljs.core.rest.call(null,(state_28126[(4)])));

return statearr_28139;
})();
var state_28126__$1 = state_28126;
var ex28134 = (state_28126__$1[(2)]);
var statearr_28140_28220 = state_28126__$1;
(statearr_28140_28220[(5)] = ex28134);


if((ex28134 instanceof Error)){
var statearr_28141_28221 = state_28126__$1;
(statearr_28141_28221[(1)] = (4));

(statearr_28141_28221[(5)] = null);

} else {
throw ex28134;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28127 === (8))){
var inst_28111 = (state_28126[(7)]);
var inst_28105 = (state_28126[(8)]);
var inst_28116 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28117 = cljs.core.deref.call(null,inst_28105);
var inst_28118 = [inst_28111,inst_28117];
var inst_28119 = (new cljs.core.PersistentVector(null,2,(5),inst_28116,inst_28118,null));
var state_28126__$1 = state_28126;
var statearr_28142_28222 = state_28126__$1;
(statearr_28142_28222[(2)] = inst_28119);

(statearr_28142_28222[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2746__auto____0 = (function (){
var statearr_28143 = [null,null,null,null,null,null,null,null,null];
(statearr_28143[(0)] = fluree$db$dbfunctions$internal$state_machine__2746__auto__);

(statearr_28143[(1)] = (1));

return statearr_28143;
});
var fluree$db$dbfunctions$internal$state_machine__2746__auto____1 = (function (state_28126){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28126);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28144){var ex__2749__auto__ = e28144;
var statearr_28145_28223 = state_28126;
(statearr_28145_28223[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28126[(4)]))){
var statearr_28146_28224 = state_28126;
(statearr_28146_28224[(1)] = cljs.core.first.call(null,(state_28126[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28225 = state_28126;
state_28126 = G__28225;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2746__auto__ = function(state_28126){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____1.call(this,state_28126);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28147 = f__2769__auto__.call(null);
(statearr_28147[(6)] = c__2768__auto__);

return statearr_28147;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28192){
var state_val_28193 = (state_28192[(1)]);
if((state_val_28193 === (7))){
var inst_28178 = (state_28192[(2)]);
var inst_28179 = fluree.db.query.fql.query.call(null,db,inst_28178);
var state_28192__$1 = state_28192;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28192__$1,(8),inst_28179);
} else {
if((state_val_28193 === (1))){
var inst_28148 = typeof select === 'string';
var state_28192__$1 = state_28192;
if(cljs.core.truth_(inst_28148)){
var statearr_28194_28226 = state_28192__$1;
(statearr_28194_28226[(1)] = (2));

} else {
var statearr_28195_28227 = state_28192__$1;
(statearr_28195_28227[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28193 === (4))){
var inst_28154 = (state_28192[(7)]);
var inst_28161 = (state_28192[(8)]);
var inst_28153 = (state_28192[(2)]);
var inst_28154__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_28155 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28156 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_28157 = [inst_28154__$1,(100000)];
var inst_28158 = cljs.core.PersistentHashMap.fromArrays(inst_28156,inst_28157);
var inst_28159 = [inst_28153,from,where,block,limit,inst_28158];
var inst_28160 = cljs.core.PersistentHashMap.fromArrays(inst_28155,inst_28159);
var inst_28161__$1 = fluree.db.util.core.without_nils.call(null,inst_28160);
var inst_28162 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28161__$1);
var inst_28163 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28161__$1);
var inst_28164 = cljs.core.first.call(null,inst_28163);
var inst_28165 = fluree.db.dbfunctions.internal.str.call(null,inst_28164);
var inst_28166 = cljs.core._EQ_.call(null,"[",inst_28165);
var inst_28167 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28161__$1);
var inst_28168 = cljs.core.last.call(null,inst_28167);
var inst_28169 = fluree.db.dbfunctions.internal.str.call(null,inst_28168);
var inst_28170 = cljs.core._EQ_.call(null,"]",inst_28169);
var inst_28171 = fluree.db.dbfunctions.internal.and.call(null,inst_28162,inst_28166,inst_28170);
var state_28192__$1 = (function (){var statearr_28196 = state_28192;
(statearr_28196[(7)] = inst_28154__$1);

(statearr_28196[(8)] = inst_28161__$1);

return statearr_28196;
})();
if(cljs.core.truth_(inst_28171)){
var statearr_28197_28228 = state_28192__$1;
(statearr_28197_28228[(1)] = (5));

} else {
var statearr_28198_28229 = state_28192__$1;
(statearr_28198_28229[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28193 === (6))){
var inst_28161 = (state_28192[(8)]);
var state_28192__$1 = state_28192;
var statearr_28199_28230 = state_28192__$1;
(statearr_28199_28230[(2)] = inst_28161);

(statearr_28199_28230[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28193 === (3))){
var state_28192__$1 = state_28192;
var statearr_28200_28231 = state_28192__$1;
(statearr_28200_28231[(2)] = select);

(statearr_28200_28231[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28193 === (2))){
var inst_28150 = fluree.db.dbfunctions.internal.parse_select_map.call(null,select);
var state_28192__$1 = state_28192;
var statearr_28201_28232 = state_28192__$1;
(statearr_28201_28232[(2)] = inst_28150);

(statearr_28201_28232[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28193 === (11))){
var inst_28190 = (state_28192[(2)]);
var state_28192__$1 = state_28192;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28192__$1,inst_28190);
} else {
if((state_val_28193 === (9))){
var inst_28181 = (state_28192[(9)]);
var state_28192__$1 = state_28192;
var statearr_28202_28233 = state_28192__$1;
(statearr_28202_28233[(2)] = inst_28181);

(statearr_28202_28233[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28193 === (5))){
var inst_28161 = (state_28192[(8)]);
var inst_28173 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28161);
var inst_28174 = cljs.reader.read_string.call(null,inst_28173);
var inst_28175 = cljs.core.assoc.call(null,inst_28161,new cljs.core.Keyword(null,"where","where",-2044795965),inst_28174);
var state_28192__$1 = state_28192;
var statearr_28203_28234 = state_28192__$1;
(statearr_28203_28234[(2)] = inst_28175);

(statearr_28203_28234[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28193 === (10))){
var inst_28154 = (state_28192[(7)]);
var inst_28181 = (state_28192[(9)]);
var inst_28185 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28186 = cljs.core.deref.call(null,inst_28154);
var inst_28187 = [inst_28181,inst_28186];
var inst_28188 = (new cljs.core.PersistentVector(null,2,(5),inst_28185,inst_28187,null));
var state_28192__$1 = state_28192;
var statearr_28204_28235 = state_28192__$1;
(statearr_28204_28235[(2)] = inst_28188);

(statearr_28204_28235[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28193 === (8))){
var inst_28181 = (state_28192[(9)]);
var inst_28181__$1 = (state_28192[(2)]);
var inst_28182 = fluree.db.util.core.exception_QMARK_.call(null,inst_28181__$1);
var state_28192__$1 = (function (){var statearr_28205 = state_28192;
(statearr_28205[(9)] = inst_28181__$1);

return statearr_28205;
})();
if(inst_28182){
var statearr_28206_28236 = state_28192__$1;
(statearr_28206_28236[(1)] = (9));

} else {
var statearr_28207_28237 = state_28192__$1;
(statearr_28207_28237[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2746__auto____0 = (function (){
var statearr_28208 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28208[(0)] = fluree$db$dbfunctions$internal$state_machine__2746__auto__);

(statearr_28208[(1)] = (1));

return statearr_28208;
});
var fluree$db$dbfunctions$internal$state_machine__2746__auto____1 = (function (state_28192){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28192);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28209){var ex__2749__auto__ = e28209;
var statearr_28210_28238 = state_28192;
(statearr_28210_28238[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28192[(4)]))){
var statearr_28211_28239 = state_28192;
(statearr_28211_28239[(1)] = cljs.core.first.call(null,(state_28192[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28240 = state_28192;
state_28192 = G__28240;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2746__auto__ = function(state_28192){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____1.call(this,state_28192);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28212 = f__2769__auto__.call(null);
(statearr_28212[(6)] = c__2768__auto__);

return statearr_28212;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.call(null,fluree.db.dbfunctions.internal.str.call(null,"Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace.call(null,pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__28244 = path;
var vec__28245 = G__28244;
var seq__28246 = cljs.core.seq.call(null,vec__28245);
var first__28247 = cljs.core.first.call(null,seq__28246);
var seq__28246__$1 = cljs.core.next.call(null,seq__28246);
var var$ = first__28247;
var r = seq__28246__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__28244__$1 = G__28244;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__28251 = G__28244__$1;
var seq__28252 = cljs.core.seq.call(null,vec__28251);
var first__28253 = cljs.core.first.call(null,seq__28252);
var seq__28252__$1 = cljs.core.next.call(null,seq__28252);
var var$__$1 = first__28253;
var r__$1 = seq__28252__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.call(null,fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_.call(null,r__$1)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null)], null));
var G__28254 = r__$1;
var G__28255 = n__$2;
var G__28256 = next_clauses;
G__28244__$1 = G__28254;
n__$1 = G__28255;
where_clauses__$1 = G__28256;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",next_n),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",next_n)], null));
var G__28257 = r__$1;
var G__28258 = next_n;
var G__28259 = cljs.core.conj.call(null,where_clauses__$2,next_clause);
G__28244__$1 = G__28257;
n__$1 = G__28258;
where_clauses__$1 = G__28259;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,endSubject], null));
return cljs.core.conj.call(null,where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28296){
var state_val_28297 = (state_28296[(1)]);
if((state_val_28297 === (7))){
var inst_28269 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28270 = [path];
var inst_28271 = (new cljs.core.PersistentVector(null,1,(5),inst_28269,inst_28270,null));
var state_28296__$1 = state_28296;
var statearr_28298_28326 = state_28296__$1;
(statearr_28298_28326[(2)] = inst_28271);

(statearr_28298_28326[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28297 === (1))){
var state_28296__$1 = state_28296;
var statearr_28299_28327 = state_28296__$1;
(statearr_28299_28327[(2)] = null);

(statearr_28299_28327[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28297 === (4))){
var inst_28260 = (state_28296[(2)]);
var state_28296__$1 = state_28296;
var statearr_28300_28328 = state_28296__$1;
(statearr_28300_28328[(2)] = inst_28260);

(statearr_28300_28328[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28297 === (13))){
var inst_28287 = (state_28296[(2)]);
var inst_28288 = fluree.db.util.async.throw_err.call(null,inst_28287);
var _ = (function (){var statearr_28301 = state_28296;
(statearr_28301[(4)] = cljs.core.rest.call(null,(state_28296[(4)])));

return statearr_28301;
})();
var state_28296__$1 = state_28296;
var statearr_28302_28329 = state_28296__$1;
(statearr_28302_28329[(2)] = inst_28288);

(statearr_28302_28329[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28297 === (6))){
var state_28296__$1 = state_28296;
var statearr_28304_28330 = state_28296__$1;
(statearr_28304_28330[(2)] = path);

(statearr_28304_28330[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28297 === (3))){
var inst_28294 = (state_28296[(2)]);
var state_28296__$1 = state_28296;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28296__$1,inst_28294);
} else {
if((state_val_28297 === (12))){
var _ = (function (){var statearr_28305 = state_28296;
(statearr_28305[(4)] = cljs.core.rest.call(null,(state_28296[(4)])));

return statearr_28305;
})();
var state_28296__$1 = state_28296;
var ex28303 = (state_28296__$1[(2)]);
var statearr_28306_28331 = state_28296__$1;
(statearr_28306_28331[(5)] = ex28303);


var statearr_28307_28332 = state_28296__$1;
(statearr_28307_28332[(1)] = (11));

(statearr_28307_28332[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28297 === (2))){
var _ = (function (){var statearr_28308 = state_28296;
(statearr_28308[(4)] = cljs.core.cons.call(null,(5),(state_28296[(4)])));

return statearr_28308;
})();
var inst_28266 = cljs.core.vector_QMARK_.call(null,path);
var state_28296__$1 = state_28296;
if(inst_28266){
var statearr_28309_28333 = state_28296__$1;
(statearr_28309_28333[(1)] = (6));

} else {
var statearr_28310_28334 = state_28296__$1;
(statearr_28310_28334[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28297 === (11))){
var inst_28273 = (state_28296[(7)]);
var inst_28278 = (state_28296[(2)]);
var inst_28279 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28278,"relationship?",startSubject,inst_28273,endSubject);
var state_28296__$1 = state_28296;
var statearr_28312_28335 = state_28296__$1;
(statearr_28312_28335[(2)] = inst_28279);

(statearr_28312_28335[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28297 === (9))){
var inst_28277 = (state_28296[(8)]);
var _ = (function (){var statearr_28313 = state_28296;
(statearr_28313[(4)] = cljs.core.cons.call(null,(12),(state_28296[(4)])));

return statearr_28313;
})();
var inst_28285 = fluree.db.dbfunctions.internal.query.call(null,db,inst_28277);
var state_28296__$1 = state_28296;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28296__$1,(13),inst_28285);
} else {
if((state_val_28297 === (5))){
var _ = (function (){var statearr_28314 = state_28296;
(statearr_28314[(4)] = cljs.core.rest.call(null,(state_28296[(4)])));

return statearr_28314;
})();
var state_28296__$1 = state_28296;
var ex28311 = (state_28296__$1[(2)]);
var statearr_28315_28336 = state_28296__$1;
(statearr_28315_28336[(5)] = ex28311);


if((ex28311 instanceof Error)){
var statearr_28316_28337 = state_28296__$1;
(statearr_28316_28337[(1)] = (4));

(statearr_28316_28337[(5)] = null);

} else {
throw ex28311;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28297 === (10))){
var inst_28291 = (state_28296[(2)]);
var _ = (function (){var statearr_28317 = state_28296;
(statearr_28317[(4)] = cljs.core.rest.call(null,(state_28296[(4)])));

return statearr_28317;
})();
var state_28296__$1 = state_28296;
var statearr_28318_28338 = state_28296__$1;
(statearr_28318_28338[(2)] = inst_28291);

(statearr_28318_28338[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28297 === (8))){
var inst_28273 = (state_28296[(7)]);
var inst_28273__$1 = (state_28296[(2)]);
var inst_28274 = fluree.db.dbfunctions.internal.build_where_clause.call(null,startSubject,inst_28273__$1,endSubject);
var inst_28275 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_28276 = ["?var1",inst_28274];
var inst_28277 = cljs.core.PersistentHashMap.fromArrays(inst_28275,inst_28276);
var state_28296__$1 = (function (){var statearr_28319 = state_28296;
(statearr_28319[(7)] = inst_28273__$1);

(statearr_28319[(8)] = inst_28277);

return statearr_28319;
})();
var statearr_28320_28339 = state_28296__$1;
(statearr_28320_28339[(2)] = null);

(statearr_28320_28339[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_28321 = [null,null,null,null,null,null,null,null,null];
(statearr_28321[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__);

(statearr_28321[(1)] = (1));

return statearr_28321;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____1 = (function (state_28296){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28296);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28322){var ex__2749__auto__ = e28322;
var statearr_28323_28340 = state_28296;
(statearr_28323_28340[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28296[(4)]))){
var statearr_28324_28341 = state_28296;
(statearr_28324_28341[(1)] = cljs.core.first.call(null,(state_28296[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28342 = state_28296;
state_28296 = G__28342;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__ = function(state_28296){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____1.call(this,state_28296);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28325 = f__2769__auto__.call(null);
(statearr_28325[(6)] = c__2768__auto__);

return statearr_28325;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (1);
} else {
return (n + (1));
}
}catch (e28343){var e = e28343;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"inc",n);
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (-1);
} else {
return (n - (1));
}
}catch (e28344){var e = e28344;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"dec",n);
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__5045__auto__ = cljs.core.get.call(null,m,k);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.call(null,m,cljs.core.keyword.call(null,k));
}
}catch (e28345){var e = e28345;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get",m,k);
}});
/**
 * Retrieve's a subject's predicate value by doing a lookup.
 *   If multi returns a vector, else a single value.
 */
fluree.db.dbfunctions.internal.get_subj_pred = (function fluree$db$dbfunctions$internal$get_subj_pred(db,sid,pred){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28399){
var state_val_28400 = (state_28399[(1)]);
if((state_val_28400 === (7))){
var state_28399__$1 = state_28399;
var statearr_28401_28439 = state_28399__$1;
(statearr_28401_28439[(2)] = pred);

(statearr_28401_28439[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28400 === (20))){
var inst_28382 = (state_28399[(7)]);
var inst_28378 = (state_28399[(8)]);
var inst_28386 = cljs.core.mapv.call(null,inst_28382,inst_28378);
var state_28399__$1 = state_28399;
var statearr_28402_28440 = state_28399__$1;
(statearr_28402_28440[(2)] = inst_28386);

(statearr_28402_28440[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28400 === (1))){
var state_28399__$1 = state_28399;
var statearr_28403_28441 = state_28399__$1;
(statearr_28403_28441[(2)] = null);

(statearr_28403_28441[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28400 === (4))){
var inst_28346 = (state_28399[(2)]);
var state_28399__$1 = state_28399;
var statearr_28404_28442 = state_28399__$1;
(statearr_28404_28442[(2)] = inst_28346);

(statearr_28404_28442[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28400 === (15))){
var state_28399__$1 = state_28399;
var statearr_28405_28443 = state_28399__$1;
(statearr_28405_28443[(2)] = fluree.db.flake.o);

(statearr_28405_28443[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28400 === (21))){
var inst_28382 = (state_28399[(7)]);
var inst_28378 = (state_28399[(8)]);
var inst_28388 = cljs.core.first.call(null,inst_28378);
var inst_28389 = inst_28382.call(null,inst_28388);
var state_28399__$1 = state_28399;
var statearr_28406_28444 = state_28399__$1;
(statearr_28406_28444[(2)] = inst_28389);

(statearr_28406_28444[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28400 === (13))){
var inst_28375 = (state_28399[(2)]);
var inst_28376 = fluree.db.util.async.throw_err.call(null,inst_28375);
var state_28399__$1 = state_28399;
var statearr_28407_28445 = state_28399__$1;
(statearr_28407_28445[(2)] = inst_28376);

(statearr_28407_28445[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28400 === (22))){
var inst_28391 = (state_28399[(2)]);
var state_28399__$1 = state_28399;
var statearr_28408_28446 = state_28399__$1;
(statearr_28408_28446[(2)] = inst_28391);

(statearr_28408_28446[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28400 === (6))){
var inst_28356 = clojure.string.replace.call(null,pred,"/_","/");
var state_28399__$1 = state_28399;
var statearr_28409_28447 = state_28399__$1;
(statearr_28409_28447[(2)] = inst_28356);

(statearr_28409_28447[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28400 === (17))){
var inst_28360 = (state_28399[(9)]);
var state_28399__$1 = state_28399;
if(cljs.core.truth_(inst_28360)){
var statearr_28410_28448 = state_28399__$1;
(statearr_28410_28448[(1)] = (20));

} else {
var statearr_28411_28449 = state_28399__$1;
(statearr_28411_28449[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28400 === (3))){
var inst_28397 = (state_28399[(2)]);
var state_28399__$1 = state_28399;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28399__$1,inst_28397);
} else {
if((state_val_28400 === (12))){
var inst_28367 = (state_28399[(2)]);
var inst_28368 = fluree.db.util.async.throw_err.call(null,inst_28367);
var state_28399__$1 = state_28399;
var statearr_28412_28450 = state_28399__$1;
(statearr_28412_28450[(2)] = inst_28368);

(statearr_28412_28450[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28400 === (2))){
var inst_28354 = (state_28399[(10)]);
var _ = (function (){var statearr_28413 = state_28399;
(statearr_28413[(4)] = cljs.core.cons.call(null,(5),(state_28399[(4)])));

return statearr_28413;
})();
var inst_28352 = typeof pred === 'string';
var inst_28353 = cljs.core.re_matches.call(null,/.+\/_.+/,pred);
var inst_28354__$1 = fluree.db.dbfunctions.internal.and.call(null,inst_28352,inst_28353);
var state_28399__$1 = (function (){var statearr_28414 = state_28399;
(statearr_28414[(10)] = inst_28354__$1);

return statearr_28414;
})();
if(cljs.core.truth_(inst_28354__$1)){
var statearr_28415_28451 = state_28399__$1;
(statearr_28415_28451[(1)] = (6));

} else {
var statearr_28416_28452 = state_28399__$1;
(statearr_28416_28452[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28400 === (19))){
var inst_28394 = (state_28399[(2)]);
var _ = (function (){var statearr_28417 = state_28399;
(statearr_28417[(4)] = cljs.core.rest.call(null,(state_28399[(4)])));

return statearr_28417;
})();
var state_28399__$1 = state_28399;
var statearr_28418_28453 = state_28399__$1;
(statearr_28418_28453[(2)] = inst_28394);

(statearr_28418_28453[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28400 === (11))){
var inst_28354 = (state_28399[(10)]);
var inst_28378 = (state_28399[(2)]);
var state_28399__$1 = (function (){var statearr_28420 = state_28399;
(statearr_28420[(8)] = inst_28378);

return statearr_28420;
})();
if(cljs.core.truth_(inst_28354)){
var statearr_28421_28454 = state_28399__$1;
(statearr_28421_28454[(1)] = (14));

} else {
var statearr_28422_28455 = state_28399__$1;
(statearr_28422_28455[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28400 === (9))){
var inst_28359 = (state_28399[(11)]);
var inst_28362 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28363 = [sid,inst_28359];
var inst_28364 = (new cljs.core.PersistentVector(null,2,(5),inst_28362,inst_28363,null));
var inst_28365 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_28364);
var state_28399__$1 = state_28399;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28399__$1,(12),inst_28365);
} else {
if((state_val_28400 === (5))){
var _ = (function (){var statearr_28423 = state_28399;
(statearr_28423[(4)] = cljs.core.rest.call(null,(state_28399[(4)])));

return statearr_28423;
})();
var state_28399__$1 = state_28399;
var ex28419 = (state_28399__$1[(2)]);
var statearr_28424_28456 = state_28399__$1;
(statearr_28424_28456[(5)] = ex28419);


if((ex28419 instanceof Error)){
var statearr_28425_28457 = state_28399__$1;
(statearr_28425_28457[(1)] = (4));

(statearr_28425_28457[(5)] = null);

} else {
throw ex28419;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28400 === (14))){
var state_28399__$1 = state_28399;
var statearr_28426_28458 = state_28399__$1;
(statearr_28426_28458[(2)] = fluree.db.flake.s);

(statearr_28426_28458[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28400 === (16))){
var inst_28378 = (state_28399[(8)]);
var inst_28382 = (state_28399[(2)]);
var inst_28383 = cljs.core.seq.call(null,inst_28378);
var state_28399__$1 = (function (){var statearr_28427 = state_28399;
(statearr_28427[(7)] = inst_28382);

return statearr_28427;
})();
if(inst_28383){
var statearr_28428_28459 = state_28399__$1;
(statearr_28428_28459[(1)] = (17));

} else {
var statearr_28429_28460 = state_28399__$1;
(statearr_28429_28460[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28400 === (10))){
var inst_28359 = (state_28399[(11)]);
var inst_28370 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28371 = [sid,inst_28359];
var inst_28372 = (new cljs.core.PersistentVector(null,2,(5),inst_28370,inst_28371,null));
var inst_28373 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_28372);
var state_28399__$1 = state_28399;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28399__$1,(13),inst_28373);
} else {
if((state_val_28400 === (18))){
var state_28399__$1 = state_28399;
var statearr_28430_28461 = state_28399__$1;
(statearr_28430_28461[(2)] = null);

(statearr_28430_28461[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28400 === (8))){
var inst_28354 = (state_28399[(10)]);
var inst_28359 = (state_28399[(11)]);
var inst_28359__$1 = (state_28399[(2)]);
var inst_28360 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_28359__$1);
var state_28399__$1 = (function (){var statearr_28431 = state_28399;
(statearr_28431[(9)] = inst_28360);

(statearr_28431[(11)] = inst_28359__$1);

return statearr_28431;
})();
if(cljs.core.truth_(inst_28354)){
var statearr_28432_28462 = state_28399__$1;
(statearr_28432_28462[(1)] = (9));

} else {
var statearr_28433_28463 = state_28399__$1;
(statearr_28433_28463[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto____0 = (function (){
var statearr_28434 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28434[(0)] = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto__);

(statearr_28434[(1)] = (1));

return statearr_28434;
});
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto____1 = (function (state_28399){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28399);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28435){var ex__2749__auto__ = e28435;
var statearr_28436_28464 = state_28399;
(statearr_28436_28464[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28399[(4)]))){
var statearr_28437_28465 = state_28399;
(statearr_28437_28465[(1)] = cljs.core.first.call(null,(state_28399[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28466 = state_28399;
state_28399 = G__28466;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto__ = function(state_28399){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto____1.call(this,state_28399);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28438 = f__2769__auto__.call(null);
(statearr_28438[(6)] = c__2768__auto__);

return statearr_28438;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis.call(null);
}catch (e28467){var e = e28467;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28470 = arguments.length;
var i__5770__auto___28471 = (0);
while(true){
if((i__5770__auto___28471 < len__5769__auto___28470)){
args__5775__auto__.push((arguments[i__5770__auto___28471]));

var G__28472 = (i__5770__auto___28471 + (1));
i__5770__auto___28471 = G__28472;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._PLUS_,args);
}catch (e28469){var e = e28469;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"+",args);
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq28468){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28468));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28475 = arguments.length;
var i__5770__auto___28476 = (0);
while(true){
if((i__5770__auto___28476 < len__5769__auto___28475)){
args__5775__auto__.push((arguments[i__5770__auto___28476]));

var G__28477 = (i__5770__auto___28476 + (1));
i__5770__auto___28476 = G__28477;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._,args);
}catch (e28474){var e = e28474;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"-",args);
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq28473){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28473));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28480 = arguments.length;
var i__5770__auto___28481 = (0);
while(true){
if((i__5770__auto___28481 < len__5769__auto___28480)){
args__5775__auto__.push((arguments[i__5770__auto___28481]));

var G__28482 = (i__5770__auto___28481 + (1));
i__5770__auto___28481 = G__28482;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__5045__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_.call(null,args);
}
})())){
return (1);
} else {
return cljs.core.apply.call(null,cljs.core._STAR_,args);
}
}catch (e28479){var e = e28479;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"*",args);
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq28478){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28478));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28485 = arguments.length;
var i__5770__auto___28486 = (0);
while(true){
if((i__5770__auto___28486 < len__5769__auto___28485)){
args__5775__auto__.push((arguments[i__5770__auto___28486]));

var G__28487 = (i__5770__auto___28486 + (1));
i__5770__auto___28486 = G__28487;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
throw cljs.core.ex_info.call(null,"Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.call(null,cljs.core._SLASH_,args);
}
}catch (e28484){var e = e28484;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"/",args);
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq28483){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28483));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot.call(null,n,d);
}catch (e28488){var e = e28488;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"quot",n,d);
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod.call(null,n,d);
}catch (e28489){var e = e28489;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"mod",n,d);
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem.call(null,n,d);
}catch (e28490){var e = e28490;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rem",n,d);
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e28491){var e = e28491;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"ceil",num);
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e28492){var e = e28492;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"floor",num);
}});
/**
 * Follows a result set down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__28498 = path;
var vec__28499 = G__28498;
var seq__28500 = cljs.core.seq.call(null,vec__28499);
var first__28501 = cljs.core.first.call(null,seq__28500);
var seq__28500__$1 = cljs.core.next.call(null,seq__28500);
var pred = first__28501;
var r = seq__28500__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__28498__$1 = G__28498;
var subjects__$1 = subjects;
while(true){
var vec__28505 = G__28498__$1;
var seq__28506 = cljs.core.seq.call(null,vec__28505);
var first__28507 = cljs.core.first.call(null,seq__28506);
var seq__28506__$1 = cljs.core.next.call(null,seq__28506);
var pred__$1 = first__28507;
var r__$1 = seq__28506__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.call(null,((function (G__28498__$1,subjects__$1,vec__28505,seq__28506,first__28507,seq__28506__$1,pred__$1,r__$1,subjects__$2,G__28498,vec__28499,seq__28500,first__28501,seq__28500__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_.call(null,subject))?cljs.core.mapv.call(null,((function (G__28498__$1,subjects__$1,vec__28505,seq__28506,first__28507,seq__28506__$1,pred__$1,r__$1,subjects__$2,G__28498,vec__28499,seq__28500,first__28501,seq__28500__$1,pred,r,subjects){
return (function (p1__28493_SHARP_){
return fluree.db.dbfunctions.internal.get.call(null,p1__28493_SHARP_,pred__$1);
});})(G__28498__$1,subjects__$1,vec__28505,seq__28506,first__28507,seq__28506__$1,pred__$1,r__$1,subjects__$2,G__28498,vec__28499,seq__28500,first__28501,seq__28500__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get.call(null,subject,pred__$1));
if(((cljs.core.vector_QMARK_.call(null,sub_subjects)) || (cljs.core.set_QMARK_.call(null,sub_subjects)))){
return cljs.core.into.call(null,acc,sub_subjects);
} else {
return cljs.core.conj.call(null,acc,sub_subjects);
}
});})(G__28498__$1,subjects__$1,vec__28505,seq__28506,first__28507,seq__28506__$1,pred__$1,r__$1,subjects__$2,G__28498,vec__28499,seq__28500,first__28501,seq__28500__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__5043__auto__ = r__$1;
if(and__5043__auto__){
return cljs.core.not_empty.call(null,next_subjects);
} else {
return and__5043__auto__;
}
})())){
var G__28508 = r__$1;
var G__28509 = next_subjects;
G__28498__$1 = G__28508;
subjects__$1 = G__28509;
continue;
} else {
return cljs.core.set.call(null,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e28494){var e = e28494;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-all",start_subject,path);
}});
/**
 * Takes a path in a vector format and returns a select statement to crawl those vars.
 *   e.g. convert: ['_user/_auth', 'groupMembership/_user', 'group/_admins']
 *          to: {'_user/_auth' [{'groupMembership/_user' ['group/_admins']}]}
 */
fluree.db.dbfunctions.internal.select_from_path = (function fluree$db$dbfunctions$internal$select_from_path(path){
if(cljs.core._EQ_.call(null,(1),fluree.db.dbfunctions.internal.count.call(null,path))){
return path;
} else {
var r_path = cljs.core.reverse.call(null,path);
return cljs.core.reduce.call(null,(function (acc,p){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([p,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc], null)]);
}),cljs.core.first.call(null,r_path),cljs.core.rest.call(null,r_path));
}
});
/**
 * Follows a subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.follow_subject = (function fluree$db$dbfunctions$internal$follow_subject(_QMARK_ctx,sid,path){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28549){
var state_val_28550 = (state_28549[(1)]);
if((state_val_28550 === (7))){
var state_28549__$1 = state_28549;
var statearr_28551_28570 = state_28549__$1;
(statearr_28551_28570[(2)] = path);

(statearr_28551_28570[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28550 === (1))){
var state_28549__$1 = state_28549;
var statearr_28552_28571 = state_28549__$1;
(statearr_28552_28571[(2)] = null);

(statearr_28552_28571[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28550 === (4))){
var inst_28510 = (state_28549[(2)]);
var inst_28511 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28510,"get-all",sid,path);
var state_28549__$1 = state_28549;
var statearr_28553_28572 = state_28549__$1;
(statearr_28553_28572[(2)] = inst_28511);

(statearr_28553_28572[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28550 === (6))){
var inst_28528 = (state_28549[(2)]);
var inst_28529 = fluree.db.util.async.throw_err.call(null,inst_28528);
var inst_28530 = cljs.core.nth.call(null,inst_28529,(0),null);
var inst_28531 = cljs.core.nth.call(null,inst_28529,(1),null);
var inst_28532 = cljs.core.last.call(null,path);
var inst_28533 = cljs.core._EQ_.call(null,"_id",inst_28532);
var state_28549__$1 = (function (){var statearr_28554 = state_28549;
(statearr_28554[(7)] = inst_28530);

(statearr_28554[(8)] = inst_28531);

return statearr_28554;
})();
if(inst_28533){
var statearr_28555_28573 = state_28549__$1;
(statearr_28555_28573[(1)] = (7));

} else {
var statearr_28556_28574 = state_28549__$1;
(statearr_28556_28574[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28550 === (3))){
var inst_28547 = (state_28549[(2)]);
var state_28549__$1 = state_28549;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28549__$1,inst_28547);
} else {
if((state_val_28550 === (2))){
var _ = (function (){var statearr_28558 = state_28549;
(statearr_28558[(4)] = cljs.core.cons.call(null,(5),(state_28549[(4)])));

return statearr_28558;
})();
var inst_28520 = fluree.db.dbfunctions.internal.select_from_path.call(null,path);
var inst_28521 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28522 = cljs.core.PersistentHashMap.EMPTY;
var inst_28523 = [inst_28520,sid,inst_28522];
var inst_28524 = cljs.core.PersistentHashMap.fromArrays(inst_28521,inst_28523);
var inst_28525 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28526 = fluree.db.dbfunctions.internal.query.call(null,inst_28525,inst_28524);
var state_28549__$1 = state_28549;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28549__$1,(6),inst_28526);
} else {
if((state_val_28550 === (9))){
var inst_28530 = (state_28549[(7)]);
var inst_28531 = (state_28549[(8)]);
var inst_28538 = (state_28549[(2)]);
var inst_28539 = fluree.db.dbfunctions.internal.get_all.call(null,inst_28530,inst_28538);
var inst_28540 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28541 = fluree.db.dbfunctions.internal.count.call(null,path);
var inst_28542 = fluree.db.dbfunctions.internal._PLUS_.call(null,inst_28531,inst_28541,(9));
var inst_28543 = [inst_28539,inst_28542];
var inst_28544 = (new cljs.core.PersistentVector(null,2,(5),inst_28540,inst_28543,null));
var _ = (function (){var statearr_28559 = state_28549;
(statearr_28559[(4)] = cljs.core.rest.call(null,(state_28549[(4)])));

return statearr_28559;
})();
var state_28549__$1 = state_28549;
var statearr_28560_28575 = state_28549__$1;
(statearr_28560_28575[(2)] = inst_28544);

(statearr_28560_28575[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28550 === (5))){
var _ = (function (){var statearr_28561 = state_28549;
(statearr_28561[(4)] = cljs.core.rest.call(null,(state_28549[(4)])));

return statearr_28561;
})();
var state_28549__$1 = state_28549;
var ex28557 = (state_28549__$1[(2)]);
var statearr_28562_28576 = state_28549__$1;
(statearr_28562_28576[(5)] = ex28557);


var statearr_28563_28577 = state_28549__$1;
(statearr_28563_28577[(1)] = (4));

(statearr_28563_28577[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28550 === (8))){
var inst_28536 = cljs.core.conj.call(null,path,"_id");
var state_28549__$1 = state_28549;
var statearr_28564_28578 = state_28549__$1;
(statearr_28564_28578[(2)] = inst_28536);

(statearr_28564_28578[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto____0 = (function (){
var statearr_28565 = [null,null,null,null,null,null,null,null,null];
(statearr_28565[(0)] = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto__);

(statearr_28565[(1)] = (1));

return statearr_28565;
});
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto____1 = (function (state_28549){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28549);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28566){var ex__2749__auto__ = e28566;
var statearr_28567_28579 = state_28549;
(statearr_28567_28579[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28549[(4)]))){
var statearr_28568_28580 = state_28549;
(statearr_28568_28580[(1)] = cljs.core.first.call(null,(state_28549[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28581 = state_28549;
state_28549 = G__28581;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto__ = function(state_28549){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto____1.call(this,state_28549);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28569 = f__2769__auto__.call(null);
(statearr_28569[(6)] = c__2768__auto__);

return statearr_28569;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all.call(null,m,ks);
}catch (e28582){var e = e28582;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-in",m,ks);
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{if(cljs.core.sequential_QMARK_.call(null,key)){
return cljs.core.some.call(null,(function (p1__28583_SHARP_){
return fluree.db.dbfunctions.internal.contains_QMARK_.call(null,coll,p1__28583_SHARP_);
}),key);
} else {
return cljs.core.contains_QMARK_.call(null,coll,key);
}
}catch (e28584){var e = e28584;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"contains?",coll,key);
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28587 = arguments.length;
var i__5770__auto___28588 = (0);
while(true){
if((i__5770__auto___28588 < len__5769__auto___28587)){
args__5775__auto__.push((arguments[i__5770__auto___28588]));

var G__28589 = (i__5770__auto___28588 + (1));
i__5770__auto___28588 = G__28589;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.hash_set,args);
}catch (e28586){var e = e28586;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"hash-set",args);
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq28585){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28585));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_.call(null,coll))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.call(null,coll_SINGLEQUOTE_,key);
}catch (e28590){var e = e28590;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nth",coll,key);
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28593 = arguments.length;
var i__5770__auto___28594 = (0);
while(true){
if((i__5770__auto___28594 < len__5769__auto___28593)){
args__5775__auto__.push((arguments[i__5770__auto___28594]));

var G__28595 = (i__5770__auto___28594 + (1));
i__5770__auto___28594 = G__28595;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._EQ_,args);
}catch (e28592){var e = e28592;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"==",args);
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq28591){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28591));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,pattern),string);
}catch (e28596){var e = e28596;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"re-find",pattern,string);
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28653){
var state_val_28654 = (state_28653[(1)]);
if((state_val_28654 === (7))){
var inst_28599 = (state_28653[(2)]);
var state_28653__$1 = state_28653;
var statearr_28655_28689 = state_28653__$1;
(statearr_28655_28689[(2)] = inst_28599);

(statearr_28655_28689[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28654 === (1))){
var state_28653__$1 = state_28653;
var statearr_28656_28690 = state_28653__$1;
(statearr_28656_28690[(2)] = null);

(statearr_28656_28690[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28654 === (4))){
var inst_28598 = (state_28653[(2)]);
var state_28653__$1 = (function (){var statearr_28657 = state_28653;
(statearr_28657[(7)] = inst_28598);

return statearr_28657;
})();
var statearr_28658_28691 = state_28653__$1;
(statearr_28658_28691[(2)] = null);

(statearr_28658_28691[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28654 === (15))){
var inst_28636 = (state_28653[(8)]);
var inst_28624 = (state_28653[(9)]);
var inst_28621 = (state_28653[(10)]);
var inst_28634 = (state_28653[(11)]);
var inst_28633 = (state_28653[(12)]);
var inst_28623 = (state_28653[(13)]);
var inst_28640 = (function (){var db = inst_28621;
var prevT = inst_28623;
var db_SINGLEQUOTE_ = inst_28624;
var prev_vals = inst_28633;
var fuel = inst_28634;
var G__28635 = inst_28636;
return (function (p1__28597_SHARP_){
var f = p1__28597_SHARP_;
return fluree.db.flake.o.call(null,f);
});
})();
var inst_28641 = inst_28640.call(null,inst_28636);
var state_28653__$1 = state_28653;
var statearr_28659_28692 = state_28653__$1;
(statearr_28659_28692[(2)] = inst_28641);

(statearr_28659_28692[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28654 === (13))){
var inst_28636 = (state_28653[(8)]);
var inst_28633 = (state_28653[(12)]);
var inst_28632 = (state_28653[(2)]);
var inst_28633__$1 = fluree.db.util.async.throw_err.call(null,inst_28632);
var inst_28634 = fluree.db.dbfunctions.internal.count.call(null,inst_28633__$1);
var inst_28636__$1 = cljs.core.first.call(null,inst_28633__$1);
var inst_28637 = (inst_28636__$1 == null);
var state_28653__$1 = (function (){var statearr_28660 = state_28653;
(statearr_28660[(8)] = inst_28636__$1);

(statearr_28660[(11)] = inst_28634);

(statearr_28660[(12)] = inst_28633__$1);

return statearr_28660;
})();
if(cljs.core.truth_(inst_28637)){
var statearr_28661_28693 = state_28653__$1;
(statearr_28661_28693[(1)] = (14));

} else {
var statearr_28662_28694 = state_28653__$1;
(statearr_28662_28694[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28654 === (6))){
var inst_28608 = (state_28653[(2)]);
var state_28653__$1 = state_28653;
var statearr_28663_28695 = state_28653__$1;
(statearr_28663_28695[(2)] = inst_28608);

(statearr_28663_28695[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28654 === (3))){
var inst_28651 = (state_28653[(2)]);
var state_28653__$1 = state_28653;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28653__$1,inst_28651);
} else {
if((state_val_28654 === (12))){
var inst_28648 = (state_28653[(2)]);
var _ = (function (){var statearr_28664 = state_28653;
(statearr_28664[(4)] = cljs.core.rest.call(null,(state_28653[(4)])));

return statearr_28664;
})();
var state_28653__$1 = state_28653;
var statearr_28665_28696 = state_28653__$1;
(statearr_28665_28696[(2)] = inst_28648);

(statearr_28665_28696[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28654 === (2))){
var _ = (function (){var statearr_28667 = state_28653;
(statearr_28667[(4)] = cljs.core.cons.call(null,(9),(state_28653[(4)])));

return statearr_28667;
})();
var inst_28614 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28615 = typeof inst_28614 === 'string';
var state_28653__$1 = state_28653;
if(cljs.core.truth_(inst_28615)){
var statearr_28668_28697 = state_28653__$1;
(statearr_28668_28697[(1)] = (10));

} else {
var statearr_28669_28698 = state_28653__$1;
(statearr_28669_28698[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28654 === (11))){
var inst_28624 = (state_28653[(9)]);
var inst_28621 = (state_28653[(10)]);
var inst_28623 = (state_28653[(13)]);
var inst_28621__$1 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28622 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_28621__$1);
var inst_28623__$1 = fluree.db.dbfunctions.internal.inc.call(null,inst_28622);
var inst_28624__$1 = cljs.core.assoc.call(null,inst_28621__$1,new cljs.core.Keyword(null,"t","t",-1397832519),inst_28623__$1);
var inst_28625 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28626 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28627 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28628 = [inst_28626,inst_28627];
var inst_28629 = (new cljs.core.PersistentVector(null,2,(5),inst_28625,inst_28628,null));
var inst_28630 = fluree.db.dbproto._search.call(null,inst_28624__$1,inst_28629);
var state_28653__$1 = (function (){var statearr_28670 = state_28653;
(statearr_28670[(9)] = inst_28624__$1);

(statearr_28670[(10)] = inst_28621__$1);

(statearr_28670[(13)] = inst_28623__$1);

return statearr_28670;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28653__$1,(13),inst_28630);
} else {
if((state_val_28654 === (9))){
var _ = (function (){var statearr_28671 = state_28653;
(statearr_28671[(4)] = cljs.core.rest.call(null,(state_28653[(4)])));

return statearr_28671;
})();
var state_28653__$1 = state_28653;
var ex28666 = (state_28653__$1[(2)]);
var statearr_28672_28699 = state_28653__$1;
(statearr_28672_28699[(5)] = ex28666);


var statearr_28673_28700 = state_28653__$1;
(statearr_28673_28700[(1)] = (4));

(statearr_28673_28700[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28654 === (5))){
var inst_28598 = (state_28653[(7)]);
var _ = (function (){var statearr_28674 = state_28653;
(statearr_28674[(4)] = cljs.core.cons.call(null,(8),(state_28653[(4)])));

return statearr_28674;
})();
var inst_28605 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28598,"?pO","Context Object");
var ___$1 = (function (){var statearr_28675 = state_28653;
(statearr_28675[(4)] = cljs.core.rest.call(null,(state_28653[(4)])));

return statearr_28675;
})();
var state_28653__$1 = state_28653;
var statearr_28676_28701 = state_28653__$1;
(statearr_28676_28701[(2)] = inst_28605);

(statearr_28676_28701[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28654 === (14))){
var state_28653__$1 = state_28653;
var statearr_28677_28702 = state_28653__$1;
(statearr_28677_28702[(2)] = null);

(statearr_28677_28702[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28654 === (16))){
var inst_28634 = (state_28653[(11)]);
var inst_28643 = (state_28653[(2)]);
var inst_28644 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28645 = [inst_28643,inst_28634];
var inst_28646 = (new cljs.core.PersistentVector(null,2,(5),inst_28644,inst_28645,null));
var state_28653__$1 = state_28653;
var statearr_28679_28703 = state_28653__$1;
(statearr_28679_28703[(2)] = inst_28646);

(statearr_28679_28703[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28654 === (10))){
var inst_28617 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28618 = [null,(0)];
var inst_28619 = (new cljs.core.PersistentVector(null,2,(5),inst_28617,inst_28618,null));
var state_28653__$1 = state_28653;
var statearr_28680_28704 = state_28653__$1;
(statearr_28680_28704[(2)] = inst_28619);

(statearr_28680_28704[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28654 === (8))){
var _ = (function (){var statearr_28681 = state_28653;
(statearr_28681[(4)] = cljs.core.rest.call(null,(state_28653[(4)])));

return statearr_28681;
})();
var state_28653__$1 = state_28653;
var ex28678 = (state_28653__$1[(2)]);
var statearr_28682_28705 = state_28653__$1;
(statearr_28682_28705[(5)] = ex28678);


var statearr_28683_28706 = state_28653__$1;
(statearr_28683_28706[(1)] = (7));

(statearr_28683_28706[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____0 = (function (){
var statearr_28684 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28684[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__);

(statearr_28684[(1)] = (1));

return statearr_28684;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____1 = (function (state_28653){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28653);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28685){var ex__2749__auto__ = e28685;
var statearr_28686_28707 = state_28653;
(statearr_28686_28707[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28653[(4)]))){
var statearr_28687_28708 = state_28653;
(statearr_28687_28708[(1)] = cljs.core.first.call(null,(state_28653[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28709 = state_28653;
state_28653 = G__28709;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__ = function(state_28653){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____1.call(this,state_28653);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28688 = f__2769__auto__.call(null);
(statearr_28688[(6)] = c__2768__auto__);

return statearr_28688;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28761){
var state_val_28762 = (state_28761[(1)]);
if((state_val_28762 === (7))){
var inst_28711 = (state_28761[(2)]);
var state_28761__$1 = state_28761;
var statearr_28763_28792 = state_28761__$1;
(statearr_28763_28792[(2)] = inst_28711);

(statearr_28763_28792[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28762 === (1))){
var state_28761__$1 = state_28761;
var statearr_28764_28793 = state_28761__$1;
(statearr_28764_28793[(2)] = null);

(statearr_28764_28793[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28762 === (4))){
var inst_28710 = (state_28761[(2)]);
var state_28761__$1 = (function (){var statearr_28765 = state_28761;
(statearr_28765[(7)] = inst_28710);

return statearr_28765;
})();
var statearr_28766_28794 = state_28761__$1;
(statearr_28766_28794[(2)] = null);

(statearr_28766_28794[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28762 === (13))){
var inst_28756 = (state_28761[(2)]);
var _ = (function (){var statearr_28767 = state_28761;
(statearr_28767[(4)] = cljs.core.rest.call(null,(state_28761[(4)])));

return statearr_28767;
})();
var state_28761__$1 = state_28761;
var statearr_28768_28795 = state_28761__$1;
(statearr_28768_28795[(2)] = inst_28756);

(statearr_28768_28795[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28762 === (6))){
var inst_28720 = (state_28761[(2)]);
var state_28761__$1 = state_28761;
var statearr_28769_28796 = state_28761__$1;
(statearr_28769_28796[(2)] = inst_28720);

(statearr_28769_28796[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28762 === (3))){
var inst_28759 = (state_28761[(2)]);
var state_28761__$1 = state_28761;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28761__$1,inst_28759);
} else {
if((state_val_28762 === (12))){
var inst_28743 = (state_28761[(8)]);
var inst_28752 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28753 = [null,inst_28743];
var inst_28754 = (new cljs.core.PersistentVector(null,2,(5),inst_28752,inst_28753,null));
var state_28761__$1 = state_28761;
var statearr_28770_28797 = state_28761__$1;
(statearr_28770_28797[(2)] = inst_28754);

(statearr_28770_28797[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28762 === (2))){
var _ = (function (){var statearr_28772 = state_28761;
(statearr_28772[(4)] = cljs.core.cons.call(null,(9),(state_28761[(4)])));

return statearr_28772;
})();
var inst_28729 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28730 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28731 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28732 = [null,pred_name,"?o"];
var inst_28733 = (new cljs.core.PersistentVector(null,3,(5),inst_28731,inst_28732,null));
var inst_28734 = [inst_28733];
var inst_28735 = (new cljs.core.PersistentVector(null,1,(5),inst_28730,inst_28734,null));
var inst_28736 = ["?o",inst_28735,opts];
var inst_28737 = cljs.core.PersistentHashMap.fromArrays(inst_28729,inst_28736);
var inst_28738 = fluree.db.dbfunctions.internal.query.call(null,db,inst_28737);
var state_28761__$1 = state_28761;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28761__$1,(10),inst_28738);
} else {
if((state_val_28762 === (11))){
var inst_28742 = (state_28761[(9)]);
var inst_28743 = (state_28761[(8)]);
var inst_28747 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28748 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_28742);
var inst_28749 = [inst_28748,inst_28743];
var inst_28750 = (new cljs.core.PersistentVector(null,2,(5),inst_28747,inst_28749,null));
var state_28761__$1 = state_28761;
var statearr_28773_28798 = state_28761__$1;
(statearr_28773_28798[(2)] = inst_28750);

(statearr_28773_28798[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28762 === (9))){
var _ = (function (){var statearr_28774 = state_28761;
(statearr_28774[(4)] = cljs.core.rest.call(null,(state_28761[(4)])));

return statearr_28774;
})();
var state_28761__$1 = state_28761;
var ex28771 = (state_28761__$1[(2)]);
var statearr_28775_28799 = state_28761__$1;
(statearr_28775_28799[(5)] = ex28771);


var statearr_28776_28800 = state_28761__$1;
(statearr_28776_28800[(1)] = (4));

(statearr_28776_28800[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28762 === (5))){
var inst_28710 = (state_28761[(7)]);
var _ = (function (){var statearr_28778 = state_28761;
(statearr_28778[(4)] = cljs.core.cons.call(null,(8),(state_28761[(4)])));

return statearr_28778;
})();
var inst_28717 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28710,"max-pred-val",pred_name);
var ___$1 = (function (){var statearr_28779 = state_28761;
(statearr_28779[(4)] = cljs.core.rest.call(null,(state_28761[(4)])));

return statearr_28779;
})();
var state_28761__$1 = state_28761;
var statearr_28780_28801 = state_28761__$1;
(statearr_28780_28801[(2)] = inst_28717);

(statearr_28780_28801[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28762 === (10))){
var inst_28742 = (state_28761[(9)]);
var inst_28740 = (state_28761[(2)]);
var inst_28741 = fluree.db.util.async.throw_err.call(null,inst_28740);
var inst_28742__$1 = cljs.core.nth.call(null,inst_28741,(0),null);
var inst_28743 = cljs.core.nth.call(null,inst_28741,(1),null);
var inst_28744 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_28742__$1);
var inst_28745 = cljs.core.not.call(null,inst_28744);
var state_28761__$1 = (function (){var statearr_28781 = state_28761;
(statearr_28781[(9)] = inst_28742__$1);

(statearr_28781[(8)] = inst_28743);

return statearr_28781;
})();
if(inst_28745){
var statearr_28782_28802 = state_28761__$1;
(statearr_28782_28802[(1)] = (11));

} else {
var statearr_28783_28803 = state_28761__$1;
(statearr_28783_28803[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28762 === (8))){
var _ = (function (){var statearr_28784 = state_28761;
(statearr_28784[(4)] = cljs.core.rest.call(null,(state_28761[(4)])));

return statearr_28784;
})();
var state_28761__$1 = state_28761;
var ex28777 = (state_28761__$1[(2)]);
var statearr_28785_28804 = state_28761__$1;
(statearr_28785_28804[(5)] = ex28777);


var statearr_28786_28805 = state_28761__$1;
(statearr_28786_28805[(1)] = (7));

(statearr_28786_28805[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____0 = (function (){
var statearr_28787 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28787[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__);

(statearr_28787[(1)] = (1));

return statearr_28787;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____1 = (function (state_28761){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28761);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28788){var ex__2749__auto__ = e28788;
var statearr_28789_28806 = state_28761;
(statearr_28789_28806[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28761[(4)]))){
var statearr_28790_28807 = state_28761;
(statearr_28790_28807[(1)] = cljs.core.first.call(null,(state_28761[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28808 = state_28761;
state_28761 = G__28808;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__ = function(state_28761){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____1.call(this,state_28761);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28791 = f__2769__auto__.call(null);
(statearr_28791[(6)] = c__2768__auto__);

return statearr_28791;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$.call(null,(function (){var and__5043__auto__ = typeof email === 'string';
if(and__5043__auto__){
return cljs.core.re_matches.call(null,pattern,email);
} else {
return and__5043__auto__;
}
})());
}catch (e28809){var e = e28809;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"valid-email?",email);
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__28811 = arguments.length;
switch (G__28811) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28881){
var state_val_28882 = (state_28881[(1)]);
if((state_val_28882 === (7))){
var inst_28813 = (state_28881[(2)]);
var state_28881__$1 = state_28881;
var statearr_28883_28927 = state_28881__$1;
(statearr_28883_28927[(2)] = inst_28813);

(statearr_28883_28927[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28882 === (20))){
var inst_28857 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28858 = ["*"];
var inst_28859 = (new cljs.core.PersistentVector(null,1,(5),inst_28857,inst_28858,null));
var state_28881__$1 = state_28881;
var statearr_28884_28928 = state_28881__$1;
(statearr_28884_28928[(2)] = inst_28859);

(statearr_28884_28928[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28882 === (1))){
var state_28881__$1 = state_28881;
var statearr_28885_28929 = state_28881__$1;
(statearr_28885_28929[(2)] = null);

(statearr_28885_28929[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28882 === (4))){
var inst_28812 = (state_28881[(2)]);
var state_28881__$1 = (function (){var statearr_28886 = state_28881;
(statearr_28886[(7)] = inst_28812);

return statearr_28886;
})();
var statearr_28887_28930 = state_28881__$1;
(statearr_28887_28930[(2)] = null);

(statearr_28887_28930[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28882 === (15))){
var inst_28876 = (state_28881[(2)]);
var _ = (function (){var statearr_28888 = state_28881;
(statearr_28888[(4)] = cljs.core.rest.call(null,(state_28881[(4)])));

return statearr_28888;
})();
var state_28881__$1 = state_28881;
var statearr_28889_28931 = state_28881__$1;
(statearr_28889_28931[(2)] = inst_28876);

(statearr_28889_28931[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28882 === (21))){
var inst_28840 = (state_28881[(8)]);
var inst_28847 = (state_28881[(9)]);
var inst_28861 = (state_28881[(2)]);
var inst_28862 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28863 = cljs.core.PersistentHashMap.EMPTY;
var inst_28864 = [inst_28861,inst_28847,inst_28863];
var inst_28865 = cljs.core.PersistentHashMap.fromArrays(inst_28862,inst_28864);
var inst_28866 = fluree.db.dbfunctions.internal.query.call(null,inst_28840,inst_28865);
var state_28881__$1 = state_28881;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28881__$1,(22),inst_28866);
} else {
if((state_val_28882 === (13))){
var inst_28835 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_28881__$1 = state_28881;
var statearr_28890_28932 = state_28881__$1;
(statearr_28890_28932[(2)] = inst_28835);

(statearr_28890_28932[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28882 === (22))){
var inst_28868 = (state_28881[(2)]);
var inst_28869 = fluree.db.util.async.throw_err.call(null,inst_28868);
var inst_28870 = cljs.core.nth.call(null,inst_28869,(0),null);
var inst_28871 = cljs.core.nth.call(null,inst_28869,(1),null);
var inst_28872 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28873 = [inst_28870,inst_28871];
var inst_28874 = (new cljs.core.PersistentVector(null,2,(5),inst_28872,inst_28873,null));
var state_28881__$1 = state_28881;
var statearr_28891_28933 = state_28881__$1;
(statearr_28891_28933[(2)] = inst_28874);

(statearr_28891_28933[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28882 === (6))){
var inst_28822 = (state_28881[(2)]);
var state_28881__$1 = state_28881;
var statearr_28892_28934 = state_28881__$1;
(statearr_28892_28934[(2)] = inst_28822);

(statearr_28892_28934[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28882 === (17))){
var inst_28844 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28845 = fluree.db.dbfunctions.internal.get.call(null,inst_28844,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_28881__$1 = state_28881;
var statearr_28893_28935 = state_28881__$1;
(statearr_28893_28935[(2)] = inst_28845);

(statearr_28893_28935[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28882 === (3))){
var inst_28879 = (state_28881[(2)]);
var state_28881__$1 = state_28881;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28881__$1,inst_28879);
} else {
if((state_val_28882 === (12))){
var inst_28833 = (state_28881[(2)]);
var state_28881__$1 = state_28881;
if(cljs.core.truth_(inst_28833)){
var statearr_28894_28936 = state_28881__$1;
(statearr_28894_28936[(1)] = (13));

} else {
var statearr_28895_28937 = state_28881__$1;
(statearr_28895_28937[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28882 === (2))){
var inst_28828 = (state_28881[(10)]);
var _ = (function (){var statearr_28896 = state_28881;
(statearr_28896[(4)] = cljs.core.cons.call(null,(9),(state_28881[(4)])));

return statearr_28896;
})();
var inst_28828__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_28881__$1 = (function (){var statearr_28897 = state_28881;
(statearr_28897[(10)] = inst_28828__$1);

return statearr_28897;
})();
if(cljs.core.truth_(inst_28828__$1)){
var statearr_28898_28938 = state_28881__$1;
(statearr_28898_28938[(1)] = (10));

} else {
var statearr_28899_28939 = state_28881__$1;
(statearr_28899_28939[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28882 === (19))){
var inst_28849 = cljs.core.PersistentVector.EMPTY;
var inst_28850 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28851 = ["*"];
var inst_28852 = (new cljs.core.PersistentVector(null,1,(5),inst_28850,inst_28851,null));
var inst_28853 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_28854 = cljs.core.concat.call(null,inst_28852,inst_28853);
var inst_28855 = cljs.core.into.call(null,inst_28849,inst_28854);
var state_28881__$1 = state_28881;
var statearr_28901_28940 = state_28881__$1;
(statearr_28901_28940[(2)] = inst_28855);

(statearr_28901_28940[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28882 === (11))){
var inst_28828 = (state_28881[(10)]);
var state_28881__$1 = state_28881;
var statearr_28902_28941 = state_28881__$1;
(statearr_28902_28941[(2)] = inst_28828);

(statearr_28902_28941[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28882 === (9))){
var _ = (function (){var statearr_28903 = state_28881;
(statearr_28903[(4)] = cljs.core.rest.call(null,(state_28881[(4)])));

return statearr_28903;
})();
var state_28881__$1 = state_28881;
var ex28900 = (state_28881__$1[(2)]);
var statearr_28904_28942 = state_28881__$1;
(statearr_28904_28942[(5)] = ex28900);


var statearr_28905_28943 = state_28881__$1;
(statearr_28905_28943[(1)] = (4));

(statearr_28905_28943[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28882 === (5))){
var inst_28812 = (state_28881[(7)]);
var _ = (function (){var statearr_28906 = state_28881;
(statearr_28906[(4)] = cljs.core.cons.call(null,(8),(state_28881[(4)])));

return statearr_28906;
})();
var inst_28819 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28812,"?s","Context Object",additional_params);
var ___$1 = (function (){var statearr_28907 = state_28881;
(statearr_28907[(4)] = cljs.core.rest.call(null,(state_28881[(4)])));

return statearr_28907;
})();
var state_28881__$1 = state_28881;
var statearr_28908_28944 = state_28881__$1;
(statearr_28908_28944[(2)] = inst_28819);

(statearr_28908_28944[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28882 === (14))){
var inst_28841 = (state_28881[(11)]);
var inst_28840 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28841__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_28881__$1 = (function (){var statearr_28909 = state_28881;
(statearr_28909[(8)] = inst_28840);

(statearr_28909[(11)] = inst_28841__$1);

return statearr_28909;
})();
if(cljs.core.truth_(inst_28841__$1)){
var statearr_28910_28945 = state_28881__$1;
(statearr_28910_28945[(1)] = (16));

} else {
var statearr_28911_28946 = state_28881__$1;
(statearr_28911_28946[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28882 === (16))){
var inst_28841 = (state_28881[(11)]);
var state_28881__$1 = state_28881;
var statearr_28912_28947 = state_28881__$1;
(statearr_28912_28947[(2)] = inst_28841);

(statearr_28912_28947[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28882 === (10))){
var inst_28830 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,additional_params);
var state_28881__$1 = state_28881;
var statearr_28914_28948 = state_28881__$1;
(statearr_28914_28948[(2)] = inst_28830);

(statearr_28914_28948[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28882 === (18))){
var inst_28847 = (state_28881[(2)]);
var state_28881__$1 = (function (){var statearr_28915 = state_28881;
(statearr_28915[(9)] = inst_28847);

return statearr_28915;
})();
if(cljs.core.truth_(additional_params)){
var statearr_28916_28949 = state_28881__$1;
(statearr_28916_28949[(1)] = (19));

} else {
var statearr_28917_28950 = state_28881__$1;
(statearr_28917_28950[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28882 === (8))){
var _ = (function (){var statearr_28918 = state_28881;
(statearr_28918[(4)] = cljs.core.rest.call(null,(state_28881[(4)])));

return statearr_28918;
})();
var state_28881__$1 = state_28881;
var ex28913 = (state_28881__$1[(2)]);
var statearr_28919_28951 = state_28881__$1;
(statearr_28919_28951[(5)] = ex28913);


var statearr_28920_28952 = state_28881__$1;
(statearr_28920_28952[(1)] = (7));

(statearr_28920_28952[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2746__auto____0 = (function (){
var statearr_28921 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28921[(0)] = fluree$db$dbfunctions$internal$state_machine__2746__auto__);

(statearr_28921[(1)] = (1));

return statearr_28921;
});
var fluree$db$dbfunctions$internal$state_machine__2746__auto____1 = (function (state_28881){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28881);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28922){var ex__2749__auto__ = e28922;
var statearr_28923_28953 = state_28881;
(statearr_28923_28953[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28881[(4)]))){
var statearr_28924_28954 = state_28881;
(statearr_28924_28954[(1)] = cljs.core.first.call(null,(state_28881[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28955 = state_28881;
state_28881 = G__28955;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2746__auto__ = function(state_28881){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____1.call(this,state_28881);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28925 = f__2769__auto__.call(null);
(statearr_28925[(6)] = c__2768__auto__);

return statearr_28925;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__28957 = arguments.length;
switch (G__28957) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_29001){
var state_val_29002 = (state_29001[(1)]);
if((state_val_29002 === (7))){
var inst_28979 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28980 = ["*"];
var inst_28981 = (new cljs.core.PersistentVector(null,1,(5),inst_28979,inst_28980,null));
var state_29001__$1 = state_29001;
var statearr_29003_29023 = state_29001__$1;
(statearr_29003_29023[(2)] = inst_28981);

(statearr_29003_29023[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29002 === (1))){
var state_29001__$1 = state_29001;
var statearr_29004_29024 = state_29001__$1;
(statearr_29004_29024[(2)] = null);

(statearr_29004_29024[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29002 === (4))){
var inst_28958 = (state_29001[(2)]);
var inst_28959 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28958,"?p","Context Object",additional_params);
var state_29001__$1 = state_29001;
var statearr_29005_29025 = state_29001__$1;
(statearr_29005_29025[(2)] = inst_28959);

(statearr_29005_29025[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29002 === (6))){
var inst_28971 = cljs.core.PersistentVector.EMPTY;
var inst_28972 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28973 = ["*"];
var inst_28974 = (new cljs.core.PersistentVector(null,1,(5),inst_28972,inst_28973,null));
var inst_28975 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_28976 = cljs.core.concat.call(null,inst_28974,inst_28975);
var inst_28977 = cljs.core.into.call(null,inst_28971,inst_28976);
var state_29001__$1 = state_29001;
var statearr_29006_29026 = state_29001__$1;
(statearr_29006_29026[(2)] = inst_28977);

(statearr_29006_29026[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29002 === (3))){
var inst_28999 = (state_29001[(2)]);
var state_29001__$1 = state_29001;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29001__$1,inst_28999);
} else {
if((state_val_29002 === (2))){
var _ = (function (){var statearr_29008 = state_29001;
(statearr_29008[(4)] = cljs.core.cons.call(null,(5),(state_29001[(4)])));

return statearr_29008;
})();
var inst_28968 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28969 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29001__$1 = (function (){var statearr_29009 = state_29001;
(statearr_29009[(7)] = inst_28968);

(statearr_29009[(8)] = inst_28969);

return statearr_29009;
})();
if(cljs.core.truth_(additional_params)){
var statearr_29010_29027 = state_29001__$1;
(statearr_29010_29027[(1)] = (6));

} else {
var statearr_29011_29028 = state_29001__$1;
(statearr_29011_29028[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29002 === (9))){
var inst_28990 = (state_29001[(2)]);
var inst_28991 = fluree.db.util.async.throw_err.call(null,inst_28990);
var inst_28992 = cljs.core.nth.call(null,inst_28991,(0),null);
var inst_28993 = cljs.core.nth.call(null,inst_28991,(1),null);
var inst_28994 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28995 = [inst_28992,inst_28993];
var inst_28996 = (new cljs.core.PersistentVector(null,2,(5),inst_28994,inst_28995,null));
var _ = (function (){var statearr_29012 = state_29001;
(statearr_29012[(4)] = cljs.core.rest.call(null,(state_29001[(4)])));

return statearr_29012;
})();
var state_29001__$1 = state_29001;
var statearr_29013_29029 = state_29001__$1;
(statearr_29013_29029[(2)] = inst_28996);

(statearr_29013_29029[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29002 === (5))){
var _ = (function (){var statearr_29014 = state_29001;
(statearr_29014[(4)] = cljs.core.rest.call(null,(state_29001[(4)])));

return statearr_29014;
})();
var state_29001__$1 = state_29001;
var ex29007 = (state_29001__$1[(2)]);
var statearr_29015_29030 = state_29001__$1;
(statearr_29015_29030[(5)] = ex29007);


var statearr_29016_29031 = state_29001__$1;
(statearr_29016_29031[(1)] = (4));

(statearr_29016_29031[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29002 === (8))){
var inst_28968 = (state_29001[(7)]);
var inst_28969 = (state_29001[(8)]);
var inst_28983 = (state_29001[(2)]);
var inst_28984 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28985 = cljs.core.PersistentHashMap.EMPTY;
var inst_28986 = [inst_28983,inst_28969,inst_28985];
var inst_28987 = cljs.core.PersistentHashMap.fromArrays(inst_28984,inst_28986);
var inst_28988 = fluree.db.dbfunctions.internal.query.call(null,inst_28968,inst_28987);
var state_29001__$1 = state_29001;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29001__$1,(9),inst_28988);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2746__auto____0 = (function (){
var statearr_29017 = [null,null,null,null,null,null,null,null,null];
(statearr_29017[(0)] = fluree$db$dbfunctions$internal$state_machine__2746__auto__);

(statearr_29017[(1)] = (1));

return statearr_29017;
});
var fluree$db$dbfunctions$internal$state_machine__2746__auto____1 = (function (state_29001){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_29001);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e29018){var ex__2749__auto__ = e29018;
var statearr_29019_29032 = state_29001;
(statearr_29019_29032[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_29001[(4)]))){
var statearr_29020_29033 = state_29001;
(statearr_29020_29033[(1)] = cljs.core.first.call(null,(state_29001[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29034 = state_29001;
state_29001 = G__29034;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2746__auto__ = function(state_29001){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____1.call(this,state_29001);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_29021 = f__2769__auto__.call(null);
(statearr_29021[(6)] = c__2768__auto__);

return statearr_29021;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_29078){
var state_val_29079 = (state_29078[(1)]);
if((state_val_29079 === (1))){
var state_29078__$1 = state_29078;
var statearr_29080_29094 = state_29078__$1;
(statearr_29080_29094[(2)] = null);

(statearr_29080_29094[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29079 === (2))){
var _ = (function (){var statearr_29081 = state_29078;
(statearr_29081[(4)] = cljs.core.cons.call(null,(5),(state_29078[(4)])));

return statearr_29081;
})();
var inst_29045 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29046 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29047 = ["_user/_auth"];
var inst_29048 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29049 = ["*"];
var inst_29050 = (new cljs.core.PersistentVector(null,1,(5),inst_29048,inst_29049,null));
var inst_29051 = [inst_29050];
var inst_29052 = cljs.core.PersistentHashMap.fromArrays(inst_29047,inst_29051);
var inst_29053 = [inst_29052];
var inst_29054 = (new cljs.core.PersistentVector(null,1,(5),inst_29046,inst_29053,null));
var inst_29055 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29056 = cljs.core.PersistentHashMap.EMPTY;
var inst_29057 = [inst_29054,inst_29055,inst_29056];
var inst_29058 = cljs.core.PersistentHashMap.fromArrays(inst_29045,inst_29057);
var inst_29059 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29060 = fluree.db.dbfunctions.internal.query.call(null,inst_29059,inst_29058);
var state_29078__$1 = state_29078;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29078__$1,(6),inst_29060);
} else {
if((state_val_29079 === (3))){
var inst_29076 = (state_29078[(2)]);
var state_29078__$1 = state_29078;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29078__$1,inst_29076);
} else {
if((state_val_29079 === (4))){
var inst_29035 = (state_29078[(2)]);
var inst_29036 = fluree.db.dbfunctions.internal.function_error.call(null,inst_29035,"?user_id-from-auth","Context Object");
var state_29078__$1 = state_29078;
var statearr_29083_29095 = state_29078__$1;
(statearr_29083_29095[(2)] = inst_29036);

(statearr_29083_29095[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29079 === (5))){
var _ = (function (){var statearr_29084 = state_29078;
(statearr_29084[(4)] = cljs.core.rest.call(null,(state_29078[(4)])));

return statearr_29084;
})();
var state_29078__$1 = state_29078;
var ex29082 = (state_29078__$1[(2)]);
var statearr_29085_29096 = state_29078__$1;
(statearr_29085_29096[(5)] = ex29082);


var statearr_29086_29097 = state_29078__$1;
(statearr_29086_29097[(1)] = (4));

(statearr_29086_29097[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29079 === (6))){
var inst_29062 = (state_29078[(2)]);
var inst_29063 = fluree.db.util.async.throw_err.call(null,inst_29062);
var inst_29064 = cljs.core.nth.call(null,inst_29063,(0),null);
var inst_29065 = cljs.core.nth.call(null,inst_29063,(1),null);
var inst_29066 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29067 = ["_user/_auth","_id"];
var inst_29068 = (new cljs.core.PersistentVector(null,2,(5),inst_29066,inst_29067,null));
var inst_29069 = fluree.db.dbfunctions.internal.get_in.call(null,inst_29064,inst_29068);
var inst_29070 = cljs.core.first.call(null,inst_29069);
var inst_29071 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29072 = [inst_29070,inst_29065];
var inst_29073 = (new cljs.core.PersistentVector(null,2,(5),inst_29071,inst_29072,null));
var _ = (function (){var statearr_29087 = state_29078;
(statearr_29087[(4)] = cljs.core.rest.call(null,(state_29078[(4)])));

return statearr_29087;
})();
var state_29078__$1 = state_29078;
var statearr_29088_29098 = state_29078__$1;
(statearr_29088_29098[(2)] = inst_29073);

(statearr_29088_29098[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____0 = (function (){
var statearr_29089 = [null,null,null,null,null,null,null];
(statearr_29089[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__);

(statearr_29089[(1)] = (1));

return statearr_29089;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____1 = (function (state_29078){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_29078);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e29090){var ex__2749__auto__ = e29090;
var statearr_29091_29099 = state_29078;
(statearr_29091_29099[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_29078[(4)]))){
var statearr_29092_29100 = state_29078;
(statearr_29092_29100[(1)] = cljs.core.first.call(null,(state_29078[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29101 = state_29078;
state_29078 = G__29101;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__ = function(state_29078){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____1.call(this,state_29078);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_29093 = f__2769__auto__.call(null);
(statearr_29093[(6)] = c__2768__auto__);

return statearr_29093;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_29123){
var state_val_29124 = (state_29123[(1)]);
if((state_val_29124 === (7))){
var inst_29108 = (state_29123[(7)]);
var inst_29112 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29113 = fluree.db.dbproto._subid.call(null,inst_29112,inst_29108);
var state_29123__$1 = state_29123;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29123__$1,(9),inst_29113);
} else {
if((state_val_29124 === (1))){
var state_29123__$1 = state_29123;
var statearr_29125_29144 = state_29123__$1;
(statearr_29125_29144[(2)] = null);

(statearr_29125_29144[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29124 === (4))){
var inst_29102 = (state_29123[(2)]);
var state_29123__$1 = state_29123;
var statearr_29126_29145 = state_29123__$1;
(statearr_29126_29145[(2)] = inst_29102);

(statearr_29126_29145[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29124 === (6))){
var inst_29108 = (state_29123[(7)]);
var state_29123__$1 = state_29123;
var statearr_29127_29146 = state_29123__$1;
(statearr_29127_29146[(2)] = inst_29108);

(statearr_29127_29146[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29124 === (3))){
var inst_29121 = (state_29123[(2)]);
var state_29123__$1 = state_29123;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29123__$1,inst_29121);
} else {
if((state_val_29124 === (2))){
var inst_29108 = (state_29123[(7)]);
var _ = (function (){var statearr_29129 = state_29123;
(statearr_29129[(4)] = cljs.core.cons.call(null,(5),(state_29123[(4)])));

return statearr_29129;
})();
var inst_29108__$1 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29109 = typeof inst_29108__$1 === 'number';
var state_29123__$1 = (function (){var statearr_29130 = state_29123;
(statearr_29130[(7)] = inst_29108__$1);

return statearr_29130;
})();
if(cljs.core.truth_(inst_29109)){
var statearr_29131_29147 = state_29123__$1;
(statearr_29131_29147[(1)] = (6));

} else {
var statearr_29132_29148 = state_29123__$1;
(statearr_29132_29148[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29124 === (9))){
var inst_29115 = (state_29123[(2)]);
var inst_29116 = fluree.db.util.async.throw_err.call(null,inst_29115);
var state_29123__$1 = state_29123;
var statearr_29133_29149 = state_29123__$1;
(statearr_29133_29149[(2)] = inst_29116);

(statearr_29133_29149[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29124 === (5))){
var _ = (function (){var statearr_29134 = state_29123;
(statearr_29134[(4)] = cljs.core.rest.call(null,(state_29123[(4)])));

return statearr_29134;
})();
var state_29123__$1 = state_29123;
var ex29128 = (state_29123__$1[(2)]);
var statearr_29135_29150 = state_29123__$1;
(statearr_29135_29150[(5)] = ex29128);


if((ex29128 instanceof Error)){
var statearr_29136_29151 = state_29123__$1;
(statearr_29136_29151[(1)] = (4));

(statearr_29136_29151[(5)] = null);

} else {
throw ex29128;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29124 === (8))){
var inst_29118 = (state_29123[(2)]);
var _ = (function (){var statearr_29137 = state_29123;
(statearr_29137[(4)] = cljs.core.rest.call(null,(state_29123[(4)])));

return statearr_29137;
})();
var state_29123__$1 = state_29123;
var statearr_29138_29152 = state_29123__$1;
(statearr_29138_29152[(2)] = inst_29118);

(statearr_29138_29152[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____0 = (function (){
var statearr_29139 = [null,null,null,null,null,null,null,null];
(statearr_29139[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__);

(statearr_29139[(1)] = (1));

return statearr_29139;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____1 = (function (state_29123){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_29123);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e29140){var ex__2749__auto__ = e29140;
var statearr_29141_29153 = state_29123;
(statearr_29141_29153[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_29123[(4)]))){
var statearr_29142_29154 = state_29123;
(statearr_29142_29154[(1)] = cljs.core.first.call(null,(state_29123[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29155 = state_29123;
state_29123 = G__29155;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__ = function(state_29123){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____1.call(this,state_29123);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_29143 = f__2769__auto__.call(null);
(statearr_29143[(6)] = c__2768__auto__);

return statearr_29143;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv.call(null,(function (p1__29156_SHARP_){
return fluree.db.flake.op.call(null,p1__29156_SHARP_) === true;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__29157_SHARP_){
return fluree.db.flake.o.call(null,p1__29157_SHARP_);
}),trueF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e29158){var e = e29158;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objT",flakes);
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv.call(null,(function (p1__29159_SHARP_){
return fluree.db.flake.op.call(null,p1__29159_SHARP_) === false;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__29160_SHARP_){
return fluree.db.flake.o.call(null,p1__29160_SHARP_);
}),falseF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e29161){var e = e29161;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objF",flakes);
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = (Math.floor(fluree.db.dbfunctions.internal._STAR_.call(null,base,max_SINGLEQUOTE_)) | (0));
return num;
}catch (e29162){var e = e29162;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rand",instant,max_SINGLEQUOTE_);
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_29242){
var state_val_29243 = (state_29242[(1)]);
if((state_val_29243 === (7))){
var inst_29181 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val);
var inst_29182 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29183 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29184 = cljs.core.PersistentHashMap.fromArrays(inst_29182,inst_29183);
var inst_29185 = cljs.core.ex_info.call(null,inst_29181,inst_29184);
var inst_29186 = (function(){throw inst_29185})();
var state_29242__$1 = state_29242;
var statearr_29244_29279 = state_29242__$1;
(statearr_29244_29279[(2)] = inst_29186);

(statearr_29244_29279[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29243 === (1))){
var state_29242__$1 = state_29242;
var statearr_29245_29280 = state_29242__$1;
(statearr_29245_29280[(2)] = null);

(statearr_29245_29280[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29243 === (4))){
var inst_29163 = (state_29242[(2)]);
var state_29242__$1 = state_29242;
var statearr_29246_29281 = state_29242__$1;
(statearr_29246_29281[(2)] = inst_29163);

(statearr_29246_29281[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29243 === (15))){
var inst_29226 = (state_29242[(7)]);
var inst_29222 = (state_29242[(2)]);
var inst_29223 = fluree.db.util.async.throw_err.call(null,inst_29222);
var inst_29224 = cljs.core.nth.call(null,inst_29223,(0),null);
var inst_29225 = cljs.core.nth.call(null,inst_29223,(1),null);
var inst_29226__$1 = cljs.core.first.call(null,inst_29224);
var inst_29227 = cljs.core._EQ_.call(null,inst_29226__$1,compare_val);
var state_29242__$1 = (function (){var statearr_29247 = state_29242;
(statearr_29247[(7)] = inst_29226__$1);

(statearr_29247[(8)] = inst_29225);

return statearr_29247;
})();
if(inst_29227){
var statearr_29248_29282 = state_29242__$1;
(statearr_29248_29282[(1)] = (16));

} else {
var statearr_29249_29283 = state_29242__$1;
(statearr_29249_29283[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29243 === (13))){
var state_29242__$1 = state_29242;
var statearr_29250_29284 = state_29242__$1;
(statearr_29250_29284[(2)] = null);

(statearr_29250_29284[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29243 === (6))){
var state_29242__$1 = state_29242;
var statearr_29251_29285 = state_29242__$1;
(statearr_29251_29285[(2)] = null);

(statearr_29251_29285[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29243 === (17))){
var inst_29226 = (state_29242[(7)]);
var inst_29230 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29226)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_29231 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29232 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29233 = cljs.core.PersistentHashMap.fromArrays(inst_29231,inst_29232);
var inst_29234 = cljs.core.ex_info.call(null,inst_29230,inst_29233);
var inst_29235 = (function(){throw inst_29234})();
var state_29242__$1 = state_29242;
var statearr_29252_29286 = state_29242__$1;
(statearr_29252_29286[(2)] = inst_29235);

(statearr_29252_29286[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29243 === (3))){
var inst_29240 = (state_29242[(2)]);
var state_29242__$1 = state_29242;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29242__$1,inst_29240);
} else {
if((state_val_29243 === (12))){
var inst_29178 = (state_29242[(9)]);
var inst_29201 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas on a multi-cardinality predicate: ",inst_29178);
var inst_29202 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29203 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29204 = cljs.core.PersistentHashMap.fromArrays(inst_29202,inst_29203);
var inst_29205 = cljs.core.ex_info.call(null,inst_29201,inst_29204);
var inst_29206 = (function(){throw inst_29205})();
var state_29242__$1 = state_29242;
var statearr_29253_29287 = state_29242__$1;
(statearr_29253_29287[(2)] = inst_29206);

(statearr_29253_29287[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29243 === (2))){
var inst_29177 = (state_29242[(10)]);
var inst_29176 = (state_29242[(11)]);
var inst_29175 = (state_29242[(12)]);
var _ = (function (){var statearr_29254 = state_29242;
(statearr_29254[(4)] = cljs.core.cons.call(null,(5),(state_29242[(4)])));

return statearr_29254;
})();
var inst_29173 = _QMARK_ctx;
var inst_29174 = cljs.core.__destructure_map.call(null,inst_29173);
var inst_29175__$1 = cljs.core.get.call(null,inst_29174,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_29176__$1 = cljs.core.get.call(null,inst_29174,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_29177__$1 = cljs.core.get.call(null,inst_29174,new cljs.core.Keyword(null,"db","db",993250759));
var inst_29178 = fluree.db.dbproto._p_prop.call(null,inst_29177__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_29176__$1);
var state_29242__$1 = (function (){var statearr_29255 = state_29242;
(statearr_29255[(9)] = inst_29178);

(statearr_29255[(10)] = inst_29177__$1);

(statearr_29255[(11)] = inst_29176__$1);

(statearr_29255[(12)] = inst_29175__$1);

return statearr_29255;
})();
if(cljs.core.truth_(inst_29175__$1)){
var statearr_29256_29288 = state_29242__$1;
(statearr_29256_29288[(1)] = (6));

} else {
var statearr_29257_29289 = state_29242__$1;
(statearr_29257_29289[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29243 === (11))){
var inst_29177 = (state_29242[(10)]);
var inst_29176 = (state_29242[(11)]);
var inst_29198 = (state_29242[(2)]);
var inst_29199 = fluree.db.dbproto._p_prop.call(null,inst_29177,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_29176);
var state_29242__$1 = (function (){var statearr_29259 = state_29242;
(statearr_29259[(13)] = inst_29198);

return statearr_29259;
})();
if(cljs.core.truth_(inst_29199)){
var statearr_29260_29290 = state_29242__$1;
(statearr_29260_29290[(1)] = (12));

} else {
var statearr_29261_29291 = state_29242__$1;
(statearr_29261_29291[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29243 === (9))){
var state_29242__$1 = state_29242;
var statearr_29262_29292 = state_29242__$1;
(statearr_29262_29292[(2)] = null);

(statearr_29262_29292[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29243 === (5))){
var _ = (function (){var statearr_29263 = state_29242;
(statearr_29263[(4)] = cljs.core.rest.call(null,(state_29242[(4)])));

return statearr_29263;
})();
var state_29242__$1 = state_29242;
var ex29258 = (state_29242__$1[(2)]);
var statearr_29264_29293 = state_29242__$1;
(statearr_29264_29293[(5)] = ex29258);


if((ex29258 instanceof Error)){
var statearr_29265_29294 = state_29242__$1;
(statearr_29265_29294[(1)] = (4));

(statearr_29265_29294[(5)] = null);

} else {
throw ex29258;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29243 === (14))){
var inst_29178 = (state_29242[(9)]);
var inst_29177 = (state_29242[(10)]);
var inst_29175 = (state_29242[(12)]);
var inst_29209 = (state_29242[(2)]);
var inst_29210 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29211 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29212 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29213 = [inst_29175,inst_29178,"?current-val"];
var inst_29214 = (new cljs.core.PersistentVector(null,3,(5),inst_29212,inst_29213,null));
var inst_29215 = [inst_29214];
var inst_29216 = (new cljs.core.PersistentVector(null,1,(5),inst_29211,inst_29215,null));
var inst_29217 = cljs.core.PersistentHashMap.EMPTY;
var inst_29218 = ["?current-val",inst_29216,inst_29217];
var inst_29219 = cljs.core.PersistentHashMap.fromArrays(inst_29210,inst_29218);
var inst_29220 = fluree.db.dbfunctions.internal.query.call(null,inst_29177,inst_29219);
var state_29242__$1 = (function (){var statearr_29266 = state_29242;
(statearr_29266[(14)] = inst_29209);

return statearr_29266;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29242__$1,(15),inst_29220);
} else {
if((state_val_29243 === (16))){
var state_29242__$1 = state_29242;
var statearr_29267_29295 = state_29242__$1;
(statearr_29267_29295[(2)] = new_val);

(statearr_29267_29295[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29243 === (10))){
var inst_29191 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val);
var inst_29192 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29193 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29194 = cljs.core.PersistentHashMap.fromArrays(inst_29192,inst_29193);
var inst_29195 = cljs.core.ex_info.call(null,inst_29191,inst_29194);
var inst_29196 = (function(){throw inst_29195})();
var state_29242__$1 = state_29242;
var statearr_29268_29296 = state_29242__$1;
(statearr_29268_29296[(2)] = inst_29196);

(statearr_29268_29296[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29243 === (18))){
var inst_29237 = (state_29242[(2)]);
var _ = (function (){var statearr_29269 = state_29242;
(statearr_29269[(4)] = cljs.core.rest.call(null,(state_29242[(4)])));

return statearr_29269;
})();
var state_29242__$1 = state_29242;
var statearr_29270_29297 = state_29242__$1;
(statearr_29270_29297[(2)] = inst_29237);

(statearr_29270_29297[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29243 === (8))){
var inst_29178 = (state_29242[(9)]);
var inst_29188 = (state_29242[(2)]);
var state_29242__$1 = (function (){var statearr_29271 = state_29242;
(statearr_29271[(15)] = inst_29188);

return statearr_29271;
})();
if(cljs.core.truth_(inst_29178)){
var statearr_29272_29298 = state_29242__$1;
(statearr_29272_29298[(1)] = (9));

} else {
var statearr_29273_29299 = state_29242__$1;
(statearr_29273_29299[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____0 = (function (){
var statearr_29274 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29274[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__);

(statearr_29274[(1)] = (1));

return statearr_29274;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____1 = (function (state_29242){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_29242);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e29275){var ex__2749__auto__ = e29275;
var statearr_29276_29300 = state_29242;
(statearr_29276_29300[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_29242[(4)]))){
var statearr_29277_29301 = state_29242;
(statearr_29277_29301[(1)] = cljs.core.first.call(null,(state_29242[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29302 = state_29242;
state_29242 = G__29302;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__ = function(state_29242){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____1.call(this,state_29242);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_29278 = f__2769__auto__.call(null);
(statearr_29278[(6)] = c__2768__auto__);

return statearr_29278;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
