// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.call(null,["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-ledger-id] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__25821 = cljs.core.re_find.call(null,/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str.call(null,ledger));
var _ = cljs.core.nth.call(null,vec__25821,(0),null);
var network = cljs.core.nth.call(null,vec__25821,(1),null);
var maybe_alias = cljs.core.nth.call(null,vec__25821,(2),null);
if(cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return maybe_alias;
} else {
return and__5043__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
/**
 * Predicates to exclude from the database
 */
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(130),(106)]);
fluree.db.graphdb.exclude_flake_QMARK_ = (function fluree$db$graphdb$exclude_flake_QMARK_(f){
return cljs.core.contains_QMARK_.call(null,fluree.db.graphdb.exclude_predicates,fluree.db.flake.p.call(null,f));
});
fluree.db.graphdb.include_flake_QMARK_ = cljs.core.complement.call(null,fluree.db.graphdb.exclude_flake_QMARK_);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__25824){
var map__25825 = p__25824;
var map__25825__$1 = cljs.core.__destructure_map.call(null,map__25825);
var opts = map__25825__$1;
var reindex_QMARK_ = cljs.core.get.call(null,map__25825__$1,new cljs.core.Keyword(null,"reindex?","reindex?",683464852));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25885){
var state_val_25886 = (state_25885[(1)]);
if((state_val_25886 === (7))){
var inst_25856 = cljs.core.not.call(null,reindex_QMARK_);
var state_25885__$1 = state_25885;
var statearr_25887_25911 = state_25885__$1;
(statearr_25887_25911[(2)] = inst_25856);

(statearr_25887_25911[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25886 === (1))){
var state_25885__$1 = state_25885;
var statearr_25888_25912 = state_25885__$1;
(statearr_25888_25912[(2)] = null);

(statearr_25888_25912[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25886 === (4))){
var inst_25826 = (state_25885[(2)]);
var state_25885__$1 = state_25885;
var statearr_25889_25913 = state_25885__$1;
(statearr_25889_25913[(2)] = inst_25826);

(statearr_25889_25913[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25886 === (6))){
var inst_25840 = (state_25885[(7)]);
var inst_25846 = (state_25885[(8)]);
var inst_25854 = (state_25885[(9)]);
var inst_25839 = (state_25885[(2)]);
var inst_25840__$1 = fluree.db.util.async.throw_err.call(null,inst_25839);
var inst_25841 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_25842 = cljs.core.__destructure_map.call(null,inst_25841);
var inst_25843 = cljs.core.get.call(null,inst_25842,new cljs.core.Keyword(null,"post","post",269697687));
var inst_25844 = cljs.core.get.call(null,inst_25842,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_25845 = fluree.db.flake.size_bytes.call(null,inst_25840__$1);
var inst_25846__$1 = (inst_25844 + inst_25845);
var inst_25847 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25848 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_25849 = (new cljs.core.PersistentVector(null,2,(5),inst_25847,inst_25848,null));
var inst_25850 = cljs.core.get_in.call(null,db,inst_25849);
var inst_25851 = cljs.core.__destructure_map.call(null,inst_25850);
var inst_25852 = cljs.core.get.call(null,inst_25851,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_25853 = cljs.core.get.call(null,inst_25851,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_25854__$1 = (inst_25846__$1 > inst_25853);
var state_25885__$1 = (function (){var statearr_25890 = state_25885;
(statearr_25890[(10)] = inst_25843);

(statearr_25890[(7)] = inst_25840__$1);

(statearr_25890[(11)] = inst_25852);

(statearr_25890[(8)] = inst_25846__$1);

(statearr_25890[(9)] = inst_25854__$1);

return statearr_25890;
})();
if(cljs.core.truth_(inst_25854__$1)){
var statearr_25891_25914 = state_25885__$1;
(statearr_25891_25914[(1)] = (7));

} else {
var statearr_25892_25915 = state_25885__$1;
(statearr_25892_25915[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25886 === (3))){
var inst_25883 = (state_25885[(2)]);
var state_25885__$1 = state_25885;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25885__$1,inst_25883);
} else {
if((state_val_25886 === (12))){
var inst_25843 = (state_25885[(10)]);
var inst_25840 = (state_25885[(7)]);
var inst_25846 = (state_25885[(8)]);
var inst_25869 = (state_25885[(2)]);
var inst_25870 = cljs.core.into.call(null,inst_25843,inst_25840);
var inst_25871 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_25872 = cljs.core.swap_BANG_.call(null,inst_25871,cljs.core.empty);
var inst_25873 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25874 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_25875 = (new cljs.core.PersistentVector(null,2,(5),inst_25873,inst_25874,null));
var inst_25876 = cljs.core.assoc_in.call(null,db,inst_25875,inst_25870);
var inst_25877 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25878 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25879 = (new cljs.core.PersistentVector(null,2,(5),inst_25877,inst_25878,null));
var inst_25880 = cljs.core.assoc_in.call(null,inst_25876,inst_25879,inst_25846);
var _ = (function (){var statearr_25893 = state_25885;
(statearr_25893[(4)] = cljs.core.rest.call(null,(state_25885[(4)])));

return statearr_25893;
})();
var state_25885__$1 = (function (){var statearr_25894 = state_25885;
(statearr_25894[(12)] = inst_25872);

(statearr_25894[(13)] = inst_25869);

return statearr_25894;
})();
var statearr_25895_25916 = state_25885__$1;
(statearr_25895_25916[(2)] = inst_25880);

(statearr_25895_25916[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25886 === (2))){
var _ = (function (){var statearr_25896 = state_25885;
(statearr_25896[(4)] = cljs.core.cons.call(null,(5),(state_25885[(4)])));

return statearr_25896;
})();
var inst_25834 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25835 = [pred_id];
var inst_25836 = (new cljs.core.PersistentVector(null,1,(5),inst_25834,inst_25835,null));
var inst_25837 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_25836);
var state_25885__$1 = state_25885;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25885__$1,(6),inst_25837);
} else {
if((state_val_25886 === (11))){
var state_25885__$1 = state_25885;
var statearr_25898_25917 = state_25885__$1;
(statearr_25898_25917[(2)] = null);

(statearr_25898_25917[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25886 === (9))){
var inst_25859 = (state_25885[(2)]);
var state_25885__$1 = state_25885;
if(cljs.core.truth_(inst_25859)){
var statearr_25899_25918 = state_25885__$1;
(statearr_25899_25918[(1)] = (10));

} else {
var statearr_25900_25919 = state_25885__$1;
(statearr_25900_25919[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25886 === (5))){
var _ = (function (){var statearr_25901 = state_25885;
(statearr_25901[(4)] = cljs.core.rest.call(null,(state_25885[(4)])));

return statearr_25901;
})();
var state_25885__$1 = state_25885;
var ex25897 = (state_25885__$1[(2)]);
var statearr_25902_25920 = state_25885__$1;
(statearr_25902_25920[(5)] = ex25897);


if((ex25897 instanceof Error)){
var statearr_25903_25921 = state_25885__$1;
(statearr_25903_25921[(1)] = (4));

(statearr_25903_25921[(5)] = null);

} else {
throw ex25897;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25886 === (10))){
var inst_25861 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_25862 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_25863 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_25864 = cljs.core.PersistentHashMap.fromArrays(inst_25862,inst_25863);
var inst_25865 = cljs.core.ex_info.call(null,inst_25861,inst_25864);
var inst_25866 = (function(){throw inst_25865})();
var state_25885__$1 = state_25885;
var statearr_25904_25922 = state_25885__$1;
(statearr_25904_25922[(2)] = inst_25866);

(statearr_25904_25922[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25886 === (8))){
var inst_25854 = (state_25885[(9)]);
var state_25885__$1 = state_25885;
var statearr_25905_25923 = state_25885__$1;
(statearr_25905_25923[(2)] = inst_25854);

(statearr_25905_25923[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____0 = (function (){
var statearr_25906 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25906[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__);

(statearr_25906[(1)] = (1));

return statearr_25906;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____1 = (function (state_25885){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25885);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25907){var ex__2749__auto__ = e25907;
var statearr_25908_25924 = state_25885;
(statearr_25908_25924[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25885[(4)]))){
var statearr_25909_25925 = state_25885;
(statearr_25909_25925[(1)] = cljs.core.first.call(null,(state_25885[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25926 = state_25885;
state_25885 = G__25926;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__ = function(state_25885){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____1.call(this,state_25885);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25910 = f__2769__auto__.call(null);
(statearr_25910[(6)] = c__2768__auto__);

return statearr_25910;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__25929 = arguments.length;
switch (G__25929) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.call(null,db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26129){
var state_val_26130 = (state_26129[(1)]);
if((state_val_26130 === (7))){
var state_26129__$1 = state_26129;
var statearr_26131_26198 = state_26129__$1;
(statearr_26131_26198[(2)] = null);

(statearr_26131_26198[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (20))){
var inst_26049 = (state_26129[(7)]);
var inst_26051 = (state_26129[(8)]);
var inst_26054 = (state_26129[(9)]);
var inst_26053 = (state_26129[(10)]);
var inst_26050 = (state_26129[(11)]);
var inst_25966 = (state_26129[(12)]);
var inst_25965 = (state_26129[(13)]);
var inst_26052 = (state_26129[(14)]);
var inst_26016 = (state_26129[(15)]);
var inst_26064 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26065 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26066 = (new cljs.core.PersistentVector(null,2,(5),inst_26064,inst_26065,null));
var inst_26067 = cljs.core.get_in.call(null,inst_26016,inst_26066);
var inst_26068 = (inst_26067 + inst_25965);
var inst_26069 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26070 = [inst_26049,inst_26050,inst_26051,inst_26052,inst_26053,inst_26068];
var inst_26071 = cljs.core.PersistentHashMap.fromArrays(inst_26069,inst_26070);
var inst_26072 = cljs.core.assoc.call(null,inst_26016,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_26054,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_26071);
var state_26129__$1 = (function (){var statearr_26132 = state_26129;
(statearr_26132[(16)] = inst_26072);

return statearr_26132;
})();
if(cljs.core.truth_(inst_25966)){
var statearr_26133_26199 = state_26129__$1;
(statearr_26133_26199[(1)] = (23));

} else {
var statearr_26134_26200 = state_26129__$1;
(statearr_26134_26200[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (27))){
var inst_26072 = (state_26129[(16)]);
var state_26129__$1 = state_26129;
var statearr_26135_26201 = state_26129__$1;
(statearr_26135_26201[(2)] = inst_26072);

(statearr_26135_26201[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (1))){
var state_26129__$1 = state_26129;
var statearr_26136_26202 = state_26129__$1;
(statearr_26136_26202[(2)] = null);

(statearr_26136_26202[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (24))){
var inst_26072 = (state_26129[(16)]);
var inst_26076 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_26072);
var inst_26077 = (inst_26076 == null);
var state_26129__$1 = state_26129;
var statearr_26137_26203 = state_26129__$1;
(statearr_26137_26203[(2)] = inst_26077);

(statearr_26137_26203[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (39))){
var inst_26103 = (state_26129[(17)]);
var inst_26060 = (state_26129[(18)]);
var inst_26061 = (state_26129[(19)]);
var inst_26053 = (state_26129[(10)]);
var inst_26111 = (state_26129[(20)]);
var inst_26104 = (state_26129[(21)]);
var inst_26102 = (state_26129[(22)]);
var inst_26118 = (state_26129[(2)]);
var inst_26119 = cljs.core.conj.call(null,inst_26053,inst_26060);
var inst_26048 = inst_26061;
var inst_26049 = inst_26103;
var inst_26050 = inst_26104;
var inst_26051 = inst_26111;
var inst_26052 = inst_26118;
var inst_26053__$1 = inst_26119;
var inst_26054 = inst_26102;
var state_26129__$1 = (function (){var statearr_26138 = state_26129;
(statearr_26138[(7)] = inst_26049);

(statearr_26138[(8)] = inst_26051);

(statearr_26138[(9)] = inst_26054);

(statearr_26138[(10)] = inst_26053__$1);

(statearr_26138[(23)] = inst_26048);

(statearr_26138[(11)] = inst_26050);

(statearr_26138[(14)] = inst_26052);

return statearr_26138;
})();
var statearr_26139_26204 = state_26129__$1;
(statearr_26139_26204[(2)] = null);

(statearr_26139_26204[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (4))){
var inst_25930 = (state_26129[(2)]);
var state_26129__$1 = state_26129;
var statearr_26140_26205 = state_26129__$1;
(statearr_26140_26205[(2)] = inst_25930);

(statearr_26140_26205[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (15))){
var inst_25988 = (state_26129[(24)]);
var state_26129__$1 = state_26129;
var statearr_26141_26206 = state_26129__$1;
(statearr_26141_26206[(2)] = inst_25988);

(statearr_26141_26206[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (21))){
var inst_25969 = (state_26129[(25)]);
var inst_26049 = (state_26129[(7)]);
var inst_26051 = (state_26129[(8)]);
var inst_25964 = (state_26129[(26)]);
var inst_25937 = (state_26129[(27)]);
var inst_26060 = (state_26129[(18)]);
var inst_26025 = (state_26129[(28)]);
var inst_26061 = (state_26129[(19)]);
var inst_26054 = (state_26129[(9)]);
var inst_26026 = (state_26129[(29)]);
var inst_26053 = (state_26129[(10)]);
var inst_26048 = (state_26129[(23)]);
var inst_26050 = (state_26129[(11)]);
var inst_25966 = (state_26129[(12)]);
var inst_25960 = (state_26129[(30)]);
var inst_25956 = (state_26129[(31)]);
var inst_25967 = (state_26129[(32)]);
var inst_25965 = (state_26129[(13)]);
var inst_26052 = (state_26129[(14)]);
var inst_25952 = (state_26129[(33)]);
var inst_26016 = (state_26129[(15)]);
var inst_25953 = (state_26129[(34)]);
var inst_25975 = (state_26129[(35)]);
var inst_26099 = fluree.db.flake.s.call(null,inst_26060);
var inst_26100 = fluree.db.flake.sid__GT_cid.call(null,inst_26099);
var inst_26101 = (function (){var flakes_bytes = inst_25965;
var t = inst_25937;
var spot = inst_26049;
var add_flakes = inst_25953;
var seq__26057 = inst_26061;
var root_setting_change_QMARK_ = inst_25967;
var vec__26021 = inst_25953;
var ref_QMARK__map = inst_25964;
var r = inst_26061;
var seq__26022 = inst_26026;
var psot = inst_26050;
var vec__26056 = inst_26048;
var add_pred_to_idx_QMARK_ = inst_25975;
var _ = inst_25952;
var tspo = inst_26053;
var cid = inst_26100;
var ecount = inst_26054;
var pred_ecount = inst_25969;
var db_STAR_ = inst_26016;
var system_change_QMARK_ = inst_25966;
var first__26058 = inst_26060;
var first__26023 = inst_26025;
var add_preds = inst_25956;
var opst = inst_26052;
var G__26020 = inst_26048;
var idx_QMARK__map = inst_25960;
var post = inst_26051;
var f = inst_26060;
return (function (p1__25927_SHARP_){
if(cljs.core.truth_(p1__25927_SHARP_)){
var x__5130__auto__ = p1__25927_SHARP_;
var y__5131__auto__ = fluree.db.flake.s.call(null,f);
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
} else {
return fluree.db.flake.s.call(null,f);
}
});
})();
var inst_26102 = cljs.core.update.call(null,inst_26054,inst_26100,inst_26101);
var inst_26103 = cljs.core.conj.call(null,inst_26049,inst_26060);
var inst_26104 = cljs.core.conj.call(null,inst_26050,inst_26060);
var inst_26105 = fluree.db.flake.p.call(null,inst_26060);
var inst_26106 = cljs.core.get.call(null,inst_25960,inst_26105);
var state_26129__$1 = (function (){var statearr_26142 = state_26129;
(statearr_26142[(17)] = inst_26103);

(statearr_26142[(21)] = inst_26104);

(statearr_26142[(22)] = inst_26102);

return statearr_26142;
})();
if(cljs.core.truth_(inst_26106)){
var statearr_26143_26207 = state_26129__$1;
(statearr_26143_26207[(1)] = (34));

} else {
var statearr_26144_26208 = state_26129__$1;
(statearr_26144_26208[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (31))){
var inst_26088 = (state_26129[(36)]);
var state_26129__$1 = state_26129;
var statearr_26145_26209 = state_26129__$1;
(statearr_26145_26209[(2)] = inst_26088);

(statearr_26145_26209[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (32))){
var inst_26097 = (state_26129[(2)]);
var state_26129__$1 = state_26129;
var statearr_26146_26210 = state_26129__$1;
(statearr_26146_26210[(2)] = inst_26097);

(statearr_26146_26210[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (33))){
var inst_26088 = (state_26129[(36)]);
var inst_26092 = (state_26129[(2)]);
var inst_26093 = fluree.db.util.async.throw_err.call(null,inst_26092);
var inst_26094 = cljs.core.assoc.call(null,inst_26088,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_26093);
var state_26129__$1 = state_26129;
var statearr_26147_26211 = state_26129__$1;
(statearr_26147_26211[(2)] = inst_26094);

(statearr_26147_26211[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (13))){
var inst_25937 = (state_26129[(27)]);
var inst_25965 = (state_26129[(13)]);
var inst_26016 = (state_26129[(15)]);
var inst_25953 = (state_26129[(34)]);
var inst_26006 = (state_26129[(2)]);
var inst_26007 = cljs.core.assoc.call(null,inst_26006,new cljs.core.Keyword(null,"t","t",-1397832519),inst_25937);
var inst_26008 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26009 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26010 = (new cljs.core.PersistentVector(null,2,(5),inst_26008,inst_26009,null));
var inst_26011 = cljs.core.update_in.call(null,inst_26007,inst_26010,cljs.core._PLUS_,inst_25965);
var inst_26012 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26013 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_26014 = (new cljs.core.PersistentVector(null,2,(5),inst_26012,inst_26013,null));
var inst_26015 = cljs.core.count.call(null,inst_25953);
var inst_26016__$1 = cljs.core.update_in.call(null,inst_26011,inst_26014,cljs.core._PLUS_,inst_26015);
var inst_26024 = cljs.core.seq.call(null,inst_25953);
var inst_26025 = cljs.core.first.call(null,inst_26024);
var inst_26026 = cljs.core.next.call(null,inst_26024);
var inst_26027 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26028 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_26029 = (new cljs.core.PersistentVector(null,2,(5),inst_26027,inst_26028,null));
var inst_26030 = cljs.core.get_in.call(null,inst_26016__$1,inst_26029);
var inst_26031 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26032 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_26033 = (new cljs.core.PersistentVector(null,2,(5),inst_26031,inst_26032,null));
var inst_26034 = cljs.core.get_in.call(null,inst_26016__$1,inst_26033);
var inst_26035 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26036 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_26037 = (new cljs.core.PersistentVector(null,2,(5),inst_26035,inst_26036,null));
var inst_26038 = cljs.core.get_in.call(null,inst_26016__$1,inst_26037);
var inst_26039 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26040 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_26041 = (new cljs.core.PersistentVector(null,2,(5),inst_26039,inst_26040,null));
var inst_26042 = cljs.core.get_in.call(null,inst_26016__$1,inst_26041);
var inst_26043 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26044 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"tspo","tspo",-440144953)];
var inst_26045 = (new cljs.core.PersistentVector(null,2,(5),inst_26043,inst_26044,null));
var inst_26046 = cljs.core.get_in.call(null,inst_26016__$1,inst_26045);
var inst_26047 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26048 = inst_25953;
var inst_26049 = inst_26030;
var inst_26050 = inst_26034;
var inst_26051 = inst_26038;
var inst_26052 = inst_26042;
var inst_26053 = inst_26046;
var inst_26054 = inst_26047;
var state_26129__$1 = (function (){var statearr_26148 = state_26129;
(statearr_26148[(7)] = inst_26049);

(statearr_26148[(8)] = inst_26051);

(statearr_26148[(28)] = inst_26025);

(statearr_26148[(9)] = inst_26054);

(statearr_26148[(29)] = inst_26026);

(statearr_26148[(10)] = inst_26053);

(statearr_26148[(23)] = inst_26048);

(statearr_26148[(11)] = inst_26050);

(statearr_26148[(14)] = inst_26052);

(statearr_26148[(15)] = inst_26016__$1);

return statearr_26148;
})();
var statearr_26149_26212 = state_26129__$1;
(statearr_26149_26212[(2)] = null);

(statearr_26149_26212[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (22))){
var inst_26122 = (state_26129[(2)]);
var state_26129__$1 = state_26129;
var statearr_26150_26213 = state_26129__$1;
(statearr_26150_26213[(2)] = inst_26122);

(statearr_26150_26213[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (36))){
var inst_25964 = (state_26129[(26)]);
var inst_26060 = (state_26129[(18)]);
var inst_26111 = (state_26129[(2)]);
var inst_26112 = fluree.db.flake.p.call(null,inst_26060);
var inst_26113 = cljs.core.get.call(null,inst_25964,inst_26112);
var state_26129__$1 = (function (){var statearr_26151 = state_26129;
(statearr_26151[(20)] = inst_26111);

return statearr_26151;
})();
if(cljs.core.truth_(inst_26113)){
var statearr_26152_26214 = state_26129__$1;
(statearr_26152_26214[(1)] = (37));

} else {
var statearr_26153_26215 = state_26129__$1;
(statearr_26153_26215[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (29))){
var inst_26072 = (state_26129[(16)]);
var inst_26083 = (state_26129[(2)]);
var inst_26084 = fluree.db.util.async.throw_err.call(null,inst_26083);
var inst_26085 = cljs.core.assoc.call(null,inst_26072,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_26084);
var state_26129__$1 = state_26129;
var statearr_26154_26216 = state_26129__$1;
(statearr_26154_26216[(2)] = inst_26085);

(statearr_26154_26216[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (6))){
var inst_25937 = (state_26129[(27)]);
var inst_25942 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(db);
var inst_25943 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_25944 = ["Invalid with called for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25942)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25943)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25937),"."].join('');
var inst_25945 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25946 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_25947 = cljs.core.PersistentHashMap.fromArrays(inst_25945,inst_25946);
var inst_25948 = cljs.core.ex_info.call(null,inst_25944,inst_25947);
var inst_25949 = (function(){throw inst_25948})();
var state_26129__$1 = state_26129;
var statearr_26155_26217 = state_26129__$1;
(statearr_26155_26217[(2)] = inst_25949);

(statearr_26155_26217[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (28))){
var inst_25967 = (state_26129[(32)]);
var inst_26088 = (state_26129[(2)]);
var state_26129__$1 = (function (){var statearr_26156 = state_26129;
(statearr_26156[(36)] = inst_26088);

return statearr_26156;
})();
if(cljs.core.truth_(inst_25967)){
var statearr_26157_26218 = state_26129__$1;
(statearr_26157_26218[(1)] = (30));

} else {
var statearr_26158_26219 = state_26129__$1;
(statearr_26158_26219[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (25))){
var inst_26079 = (state_26129[(2)]);
var state_26129__$1 = state_26129;
if(cljs.core.truth_(inst_26079)){
var statearr_26159_26220 = state_26129__$1;
(statearr_26159_26220[(1)] = (26));

} else {
var statearr_26160_26221 = state_26129__$1;
(statearr_26160_26221[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (34))){
var inst_26051 = (state_26129[(8)]);
var inst_26060 = (state_26129[(18)]);
var inst_26108 = cljs.core.conj.call(null,inst_26051,inst_26060);
var state_26129__$1 = state_26129;
var statearr_26161_26222 = state_26129__$1;
(statearr_26161_26222[(2)] = inst_26108);

(statearr_26161_26222[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (17))){
var inst_25995 = (state_26129[(37)]);
var inst_25999 = (state_26129[(2)]);
var inst_26000 = fluree.db.util.async.throw_err.call(null,inst_25999);
var inst_25987 = inst_25995;
var inst_25988 = inst_26000;
var state_26129__$1 = (function (){var statearr_26162 = state_26129;
(statearr_26162[(24)] = inst_25988);

(statearr_26162[(38)] = inst_25987);

return statearr_26162;
})();
var statearr_26163_26223 = state_26129__$1;
(statearr_26163_26223[(2)] = null);

(statearr_26163_26223[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (3))){
var inst_26127 = (state_26129[(2)]);
var state_26129__$1 = state_26129;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26129__$1,inst_26127);
} else {
if((state_val_26130 === (12))){
var inst_25994 = (state_26129[(39)]);
var inst_25987 = (state_26129[(38)]);
var inst_25993 = cljs.core.seq.call(null,inst_25987);
var inst_25994__$1 = cljs.core.first.call(null,inst_25993);
var inst_25995 = cljs.core.next.call(null,inst_25993);
var state_26129__$1 = (function (){var statearr_26164 = state_26129;
(statearr_26164[(37)] = inst_25995);

(statearr_26164[(39)] = inst_25994__$1);

return statearr_26164;
})();
if(cljs.core.truth_(inst_25994__$1)){
var statearr_26165_26224 = state_26129__$1;
(statearr_26165_26224[(1)] = (14));

} else {
var statearr_26166_26225 = state_26129__$1;
(statearr_26166_26225[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (2))){
var inst_25937 = (state_26129[(27)]);
var _ = (function (){var statearr_26167 = state_26129;
(statearr_26167[(4)] = cljs.core.cons.call(null,(5),(state_26129[(4)])));

return statearr_26167;
})();
var inst_25936 = cljs.core.first.call(null,flakes);
var inst_25937__$1 = fluree.db.flake.t.call(null,inst_25936);
var inst_25938 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_25939 = (inst_25938 - (1));
var inst_25940 = cljs.core.not_EQ_.call(null,inst_25937__$1,inst_25939);
var state_26129__$1 = (function (){var statearr_26168 = state_26129;
(statearr_26168[(27)] = inst_25937__$1);

return statearr_26168;
})();
if(inst_25940){
var statearr_26169_26226 = state_26129__$1;
(statearr_26169_26226[(1)] = (6));

} else {
var statearr_26170_26227 = state_26129__$1;
(statearr_26170_26227[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (23))){
var inst_25966 = (state_26129[(12)]);
var state_26129__$1 = state_26129;
var statearr_26171_26228 = state_26129__$1;
(statearr_26171_26228[(2)] = inst_25966);

(statearr_26171_26228[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (35))){
var inst_26051 = (state_26129[(8)]);
var state_26129__$1 = state_26129;
var statearr_26172_26229 = state_26129__$1;
(statearr_26172_26229[(2)] = inst_26051);

(statearr_26172_26229[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (19))){
var inst_26124 = (state_26129[(2)]);
var _ = (function (){var statearr_26173 = state_26129;
(statearr_26173[(4)] = cljs.core.rest.call(null,(state_26129[(4)])));

return statearr_26173;
})();
var state_26129__$1 = state_26129;
var statearr_26174_26230 = state_26129__$1;
(statearr_26174_26230[(2)] = inst_26124);

(statearr_26174_26230[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (11))){
var inst_25975 = (state_26129[(35)]);
var inst_25975__$1 = (state_26129[(2)]);
var inst_25983 = cljs.core.seq.call(null,inst_25975__$1);
var inst_25984 = cljs.core.first.call(null,inst_25983);
var inst_25985 = cljs.core.next.call(null,inst_25983);
var inst_25986 = db;
var inst_25987 = inst_25975__$1;
var inst_25988 = inst_25986;
var state_26129__$1 = (function (){var statearr_26176 = state_26129;
(statearr_26176[(24)] = inst_25988);

(statearr_26176[(40)] = inst_25984);

(statearr_26176[(41)] = inst_25985);

(statearr_26176[(38)] = inst_25987);

(statearr_26176[(35)] = inst_25975__$1);

return statearr_26176;
})();
var statearr_26177_26231 = state_26129__$1;
(statearr_26177_26231[(2)] = null);

(statearr_26177_26231[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (9))){
var inst_25969 = (state_26129[(25)]);
var inst_25953 = (state_26129[(34)]);
var inst_25971 = fluree.db.util.schema.add_to_post_preds_QMARK_.call(null,inst_25953,inst_25969);
var state_26129__$1 = state_26129;
var statearr_26178_26232 = state_26129__$1;
(statearr_26178_26232[(2)] = inst_25971);

(statearr_26178_26232[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (5))){
var _ = (function (){var statearr_26179 = state_26129;
(statearr_26179[(4)] = cljs.core.rest.call(null,(state_26129[(4)])));

return statearr_26179;
})();
var state_26129__$1 = state_26129;
var ex26175 = (state_26129__$1[(2)]);
var statearr_26180_26233 = state_26129__$1;
(statearr_26180_26233[(5)] = ex26175);


if((ex26175 instanceof Error)){
var statearr_26181_26234 = state_26129__$1;
(statearr_26181_26234[(1)] = (4));

(statearr_26181_26234[(5)] = null);

} else {
throw ex26175;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (14))){
var inst_25988 = (state_26129[(24)]);
var inst_25994 = (state_26129[(39)]);
var inst_25997 = fluree.db.graphdb.add_predicate_to_idx.call(null,inst_25988,inst_25994,opts);
var state_26129__$1 = state_26129;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26129__$1,(17),inst_25997);
} else {
if((state_val_26130 === (26))){
var inst_26072 = (state_26129[(16)]);
var inst_26081 = fluree.db.query.schema.schema_map.call(null,inst_26072);
var state_26129__$1 = state_26129;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26129__$1,(29),inst_26081);
} else {
if((state_val_26130 === (16))){
var inst_26004 = (state_26129[(2)]);
var state_26129__$1 = state_26129;
var statearr_26182_26235 = state_26129__$1;
(statearr_26182_26235[(2)] = inst_26004);

(statearr_26182_26235[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (38))){
var inst_26052 = (state_26129[(14)]);
var state_26129__$1 = state_26129;
var statearr_26183_26236 = state_26129__$1;
(statearr_26183_26236[(2)] = inst_26052);

(statearr_26183_26236[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (30))){
var inst_26072 = (state_26129[(16)]);
var inst_26090 = fluree.db.query.schema.setting_map.call(null,inst_26072);
var state_26129__$1 = state_26129;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26129__$1,(33),inst_26090);
} else {
if((state_val_26130 === (10))){
var inst_25973 = cljs.core.PersistentVector.EMPTY;
var state_26129__$1 = state_26129;
var statearr_26184_26237 = state_26129__$1;
(statearr_26184_26237[(2)] = inst_25973);

(statearr_26184_26237[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (18))){
var inst_26060 = (state_26129[(18)]);
var inst_26048 = (state_26129[(23)]);
var inst_26059 = cljs.core.seq.call(null,inst_26048);
var inst_26060__$1 = cljs.core.first.call(null,inst_26059);
var inst_26061 = cljs.core.next.call(null,inst_26059);
var inst_26062 = cljs.core.not.call(null,inst_26060__$1);
var state_26129__$1 = (function (){var statearr_26185 = state_26129;
(statearr_26185[(18)] = inst_26060__$1);

(statearr_26185[(19)] = inst_26061);

return statearr_26185;
})();
if(inst_26062){
var statearr_26186_26238 = state_26129__$1;
(statearr_26186_26238[(1)] = (20));

} else {
var statearr_26187_26239 = state_26129__$1;
(statearr_26187_26239[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (37))){
var inst_26060 = (state_26129[(18)]);
var inst_26052 = (state_26129[(14)]);
var inst_26115 = cljs.core.conj.call(null,inst_26052,inst_26060);
var state_26129__$1 = state_26129;
var statearr_26188_26240 = state_26129__$1;
(statearr_26188_26240[(2)] = inst_26115);

(statearr_26188_26240[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26130 === (8))){
var inst_25937 = (state_26129[(27)]);
var inst_25966 = (state_26129[(12)]);
var inst_25960 = (state_26129[(30)]);
var inst_25956 = (state_26129[(31)]);
var inst_25952 = (state_26129[(33)]);
var inst_25953 = (state_26129[(34)]);
var inst_25952__$1 = (state_26129[(2)]);
var inst_25953__$1 = cljs.core.filter.call(null,fluree.db.graphdb.include_flake_QMARK_,flakes);
var inst_25954 = cljs.core.PersistentHashSet.EMPTY;
var inst_25955 = cljs.core.map.call(null,fluree.db.flake.p,inst_25953__$1);
var inst_25956__$1 = cljs.core.into.call(null,inst_25954,inst_25955);
var inst_25957 = cljs.core.PersistentHashMap.EMPTY;
var inst_25958 = (function (){var t = inst_25937;
var _ = inst_25952__$1;
var add_flakes = inst_25953__$1;
var add_preds = inst_25956__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_25959 = cljs.core.map.call(null,inst_25958,inst_25956__$1);
var inst_25960__$1 = cljs.core.into.call(null,inst_25957,inst_25959);
var inst_25961 = cljs.core.PersistentHashMap.EMPTY;
var inst_25962 = (function (){var t = inst_25937;
var _ = inst_25952__$1;
var add_flakes = inst_25953__$1;
var add_preds = inst_25956__$1;
var idx_QMARK__map = inst_25960__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_25963 = cljs.core.map.call(null,inst_25962,inst_25956__$1);
var inst_25964 = cljs.core.into.call(null,inst_25961,inst_25963);
var inst_25965 = fluree.db.flake.size_bytes.call(null,inst_25953__$1);
var inst_25966__$1 = fluree.db.util.schema.system_change_QMARK_.call(null,inst_25953__$1);
var inst_25967 = fluree.db.util.schema.setting_change_QMARK_.call(null,inst_25953__$1);
var inst_25968 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_25969 = cljs.core.get.call(null,inst_25968,(0));
var state_26129__$1 = (function (){var statearr_26189 = state_26129;
(statearr_26189[(25)] = inst_25969);

(statearr_26189[(26)] = inst_25964);

(statearr_26189[(12)] = inst_25966__$1);

(statearr_26189[(30)] = inst_25960__$1);

(statearr_26189[(31)] = inst_25956__$1);

(statearr_26189[(32)] = inst_25967);

(statearr_26189[(13)] = inst_25965);

(statearr_26189[(33)] = inst_25952__$1);

(statearr_26189[(34)] = inst_25953__$1);

return statearr_26189;
})();
if(cljs.core.truth_(inst_25966__$1)){
var statearr_26190_26241 = state_26129__$1;
(statearr_26190_26241[(1)] = (9));

} else {
var statearr_26191_26242 = state_26129__$1;
(statearr_26191_26242[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_26192 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26192[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_26192[(1)] = (1));

return statearr_26192;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_26129){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26129);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26193){var ex__2749__auto__ = e26193;
var statearr_26194_26243 = state_26129;
(statearr_26194_26243[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26129[(4)]))){
var statearr_26195_26244 = state_26129;
(statearr_26195_26244[(1)] = cljs.core.first.call(null,(state_26129[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26245 = state_26129;
state_26129 = G__26245;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_26129){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_26129);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26196 = f__2769__auto__.call(null);
(statearr_26196[(6)] = c__2768__auto__);

return statearr_26196;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__26247 = arguments.length;
switch (G__26247) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.call(null,db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.call(null);
var c__2768__auto___26394 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26343){
var state_val_26344 = (state_26343[(1)]);
if((state_val_26344 === (7))){
var state_26343__$1 = state_26343;
var statearr_26345_26395 = state_26343__$1;
(statearr_26345_26395[(2)] = null);

(statearr_26345_26395[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26344 === (20))){
var inst_26293 = (state_26343[(7)]);
var inst_26292 = (state_26343[(8)]);
var inst_26291 = (state_26343[(9)]);
var inst_26312 = (inst_26291 + (1));
var inst_26313 = cljs.core.assoc.call(null,inst_26293,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26312);
var inst_26314 = fluree.db.graphdb.with_t.call(null,inst_26313,inst_26292,opts);
var state_26343__$1 = state_26343;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26343__$1,(23),inst_26314);
} else {
if((state_val_26344 === (1))){
var state_26343__$1 = state_26343;
var statearr_26346_26396 = state_26343__$1;
(statearr_26346_26396[(2)] = null);

(statearr_26346_26396[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26344 === (24))){
var inst_26317 = (state_26343[(10)]);
var inst_26320 = cljs.core.assoc.call(null,inst_26317,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_26343__$1 = state_26343;
var statearr_26347_26397 = state_26343__$1;
(statearr_26347_26397[(2)] = inst_26320);

(statearr_26347_26397[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26344 === (4))){
var inst_26248 = (state_26343[(2)]);
var inst_26249 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_26248);
var state_26343__$1 = state_26343;
var statearr_26348_26398 = state_26343__$1;
(statearr_26348_26398[(2)] = inst_26249);

(statearr_26348_26398[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26344 === (15))){
var inst_26299 = (state_26343[(11)]);
var state_26343__$1 = state_26343;
var statearr_26349_26399 = state_26343__$1;
(statearr_26349_26399[(2)] = inst_26299);

(statearr_26349_26399[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26344 === (21))){
var state_26343__$1 = state_26343;
var statearr_26350_26400 = state_26343__$1;
(statearr_26350_26400[(2)] = null);

(statearr_26350_26400[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26344 === (13))){
var inst_26335 = (state_26343[(2)]);
var inst_26336 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_26335);
var state_26343__$1 = state_26343;
var statearr_26351_26401 = state_26343__$1;
(statearr_26351_26401[(2)] = inst_26336);

(statearr_26351_26401[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26344 === (22))){
var inst_26331 = (state_26343[(2)]);
var state_26343__$1 = state_26343;
var statearr_26352_26402 = state_26343__$1;
(statearr_26352_26402[(2)] = inst_26331);

(statearr_26352_26402[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26344 === (6))){
var inst_26259 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(db);
var inst_26260 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26261 = ["Invalid 'with' called for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26259)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26260)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_26262 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26263 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26264 = cljs.core.PersistentHashMap.fromArrays(inst_26262,inst_26263);
var inst_26265 = cljs.core.ex_info.call(null,inst_26261,inst_26264);
var inst_26266 = (function(){throw inst_26265})();
var state_26343__$1 = state_26343;
var statearr_26355_26403 = state_26343__$1;
(statearr_26355_26403[(2)] = inst_26266);

(statearr_26355_26403[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26344 === (25))){
var inst_26299 = (state_26343[(11)]);
var inst_26317 = (state_26343[(10)]);
var inst_26300 = (state_26343[(12)]);
var inst_26322 = fluree.db.flake.t.call(null,inst_26299);
var inst_26323 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26324 = [inst_26299];
var inst_26325 = (new cljs.core.PersistentVector(null,1,(5),inst_26323,inst_26324,null));
var inst_26290 = inst_26300;
var inst_26291 = inst_26322;
var inst_26292 = inst_26325;
var inst_26293 = inst_26317;
var state_26343__$1 = (function (){var statearr_26356 = state_26343;
(statearr_26356[(7)] = inst_26293);

(statearr_26356[(8)] = inst_26292);

(statearr_26356[(13)] = inst_26290);

(statearr_26356[(9)] = inst_26291);

return statearr_26356;
})();
var statearr_26357_26404 = state_26343__$1;
(statearr_26357_26404[(2)] = null);

(statearr_26357_26404[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26344 === (17))){
var inst_26293 = (state_26343[(7)]);
var inst_26299 = (state_26343[(11)]);
var inst_26292 = (state_26343[(8)]);
var inst_26300 = (state_26343[(12)]);
var inst_26291 = (state_26343[(9)]);
var inst_26308 = cljs.core.conj.call(null,inst_26292,inst_26299);
var tmp26353 = inst_26293;
var tmp26354 = inst_26291;
var inst_26290 = inst_26300;
var inst_26291__$1 = tmp26354;
var inst_26292__$1 = inst_26308;
var inst_26293__$1 = tmp26353;
var state_26343__$1 = (function (){var statearr_26358 = state_26343;
(statearr_26358[(7)] = inst_26293__$1);

(statearr_26358[(8)] = inst_26292__$1);

(statearr_26358[(13)] = inst_26290);

(statearr_26358[(9)] = inst_26291__$1);

return statearr_26358;
})();
var statearr_26359_26405 = state_26343__$1;
(statearr_26359_26405[(2)] = null);

(statearr_26359_26405[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26344 === (3))){
var inst_26341 = (state_26343[(2)]);
var state_26343__$1 = state_26343;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26343__$1,inst_26341);
} else {
if((state_val_26344 === (12))){
var inst_26299 = (state_26343[(11)]);
var inst_26290 = (state_26343[(13)]);
var inst_26298 = cljs.core.seq.call(null,inst_26290);
var inst_26299__$1 = cljs.core.first.call(null,inst_26298);
var inst_26300 = cljs.core.next.call(null,inst_26298);
var state_26343__$1 = (function (){var statearr_26360 = state_26343;
(statearr_26360[(11)] = inst_26299__$1);

(statearr_26360[(12)] = inst_26300);

return statearr_26360;
})();
if(cljs.core.truth_(inst_26299__$1)){
var statearr_26361_26406 = state_26343__$1;
(statearr_26361_26406[(1)] = (14));

} else {
var statearr_26362_26407 = state_26343__$1;
(statearr_26362_26407[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26344 === (2))){
var _ = (function (){var statearr_26363 = state_26343;
(statearr_26363[(4)] = cljs.core.cons.call(null,(5),(state_26343[(4)])));

return statearr_26363;
})();
var inst_26255 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26256 = (inst_26255 + (1));
var inst_26257 = cljs.core.not_EQ_.call(null,block,inst_26256);
var state_26343__$1 = state_26343;
if(inst_26257){
var statearr_26364_26408 = state_26343__$1;
(statearr_26364_26408[(1)] = (6));

} else {
var statearr_26365_26409 = state_26343__$1;
(statearr_26365_26409[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26344 === (23))){
var inst_26299 = (state_26343[(11)]);
var inst_26316 = (state_26343[(2)]);
var inst_26317 = fluree.db.util.async.throw_err.call(null,inst_26316);
var inst_26318 = (inst_26299 == null);
var state_26343__$1 = (function (){var statearr_26366 = state_26343;
(statearr_26366[(10)] = inst_26317);

return statearr_26366;
})();
if(cljs.core.truth_(inst_26318)){
var statearr_26367_26410 = state_26343__$1;
(statearr_26367_26410[(1)] = (24));

} else {
var statearr_26368_26411 = state_26343__$1;
(statearr_26368_26411[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26344 === (19))){
var inst_26333 = (state_26343[(2)]);
var state_26343__$1 = state_26343;
var statearr_26369_26412 = state_26343__$1;
(statearr_26369_26412[(2)] = inst_26333);

(statearr_26369_26412[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26344 === (11))){
var inst_26338 = (state_26343[(2)]);
var _ = (function (){var statearr_26371 = state_26343;
(statearr_26371[(4)] = cljs.core.rest.call(null,(state_26343[(4)])));

return statearr_26371;
})();
var state_26343__$1 = state_26343;
var statearr_26372_26413 = state_26343__$1;
(statearr_26372_26413[(2)] = inst_26338);

(statearr_26372_26413[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26344 === (9))){
var inst_26272 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_26273 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_26272);
var state_26343__$1 = state_26343;
var statearr_26373_26414 = state_26343__$1;
(statearr_26373_26414[(2)] = inst_26273);

(statearr_26373_26414[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26344 === (5))){
var _ = (function (){var statearr_26374 = state_26343;
(statearr_26374[(4)] = cljs.core.rest.call(null,(state_26343[(4)])));

return statearr_26374;
})();
var state_26343__$1 = state_26343;
var ex26370 = (state_26343__$1[(2)]);
var statearr_26375_26415 = state_26343__$1;
(statearr_26375_26415[(5)] = ex26370);


var statearr_26376_26416 = state_26343__$1;
(statearr_26376_26416[(1)] = (4));

(statearr_26376_26416[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26344 === (14))){
var inst_26299 = (state_26343[(11)]);
var inst_26291 = (state_26343[(9)]);
var inst_26302 = fluree.db.flake.t.call(null,inst_26299);
var inst_26303 = cljs.core._EQ_.call(null,inst_26291,inst_26302);
var state_26343__$1 = state_26343;
var statearr_26377_26417 = state_26343__$1;
(statearr_26377_26417[(2)] = inst_26303);

(statearr_26377_26417[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26344 === (26))){
var inst_26328 = (state_26343[(2)]);
var state_26343__$1 = state_26343;
var statearr_26378_26418 = state_26343__$1;
(statearr_26378_26418[(2)] = inst_26328);

(statearr_26378_26418[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26344 === (16))){
var inst_26306 = (state_26343[(2)]);
var state_26343__$1 = state_26343;
if(cljs.core.truth_(inst_26306)){
var statearr_26379_26419 = state_26343__$1;
(statearr_26379_26419[(1)] = (17));

} else {
var statearr_26380_26420 = state_26343__$1;
(statearr_26380_26420[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26344 === (10))){
var inst_26275 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_block,flakes);
var inst_26283 = cljs.core.seq.call(null,inst_26275);
var inst_26284 = cljs.core.first.call(null,inst_26283);
var inst_26285 = cljs.core.next.call(null,inst_26283);
var inst_26286 = cljs.core.first.call(null,inst_26275);
var inst_26287 = fluree.db.flake.t.call(null,inst_26286);
var inst_26288 = cljs.core.PersistentVector.EMPTY;
var inst_26289 = db;
var inst_26290 = inst_26275;
var inst_26291 = inst_26287;
var inst_26292 = inst_26288;
var inst_26293 = inst_26289;
var state_26343__$1 = (function (){var statearr_26381 = state_26343;
(statearr_26381[(14)] = inst_26285);

(statearr_26381[(7)] = inst_26293);

(statearr_26381[(8)] = inst_26292);

(statearr_26381[(13)] = inst_26290);

(statearr_26381[(9)] = inst_26291);

(statearr_26381[(15)] = inst_26284);

return statearr_26381;
})();
var statearr_26382_26421 = state_26343__$1;
(statearr_26382_26421[(2)] = null);

(statearr_26382_26421[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26344 === (18))){
var state_26343__$1 = state_26343;
var statearr_26383_26422 = state_26343__$1;
(statearr_26383_26422[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26344 === (8))){
var inst_26269 = (state_26343[(2)]);
var inst_26270 = cljs.core.empty_QMARK_.call(null,flakes);
var state_26343__$1 = (function (){var statearr_26385 = state_26343;
(statearr_26385[(16)] = inst_26269);

return statearr_26385;
})();
if(inst_26270){
var statearr_26386_26423 = state_26343__$1;
(statearr_26386_26423[(1)] = (9));

} else {
var statearr_26387_26424 = state_26343__$1;
(statearr_26387_26424[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_26388 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26388[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_26388[(1)] = (1));

return statearr_26388;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_26343){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26343);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26389){var ex__2749__auto__ = e26389;
var statearr_26390_26425 = state_26343;
(statearr_26390_26425[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26343[(4)]))){
var statearr_26391_26426 = state_26343;
(statearr_26391_26426[(1)] = cljs.core.first.call(null,(state_26343[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26427 = state_26343;
state_26343 = G__26427;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_26343){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_26343);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26392 = f__2769__auto__.call(null);
(statearr_26392[(6)] = c__2768__auto___26394);

return statearr_26392;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26479){
var state_val_26480 = (state_26479[(1)]);
if((state_val_26480 === (7))){
var state_26479__$1 = state_26479;
var statearr_26481_26508 = state_26479__$1;
(statearr_26481_26508[(2)] = tt_id);

(statearr_26481_26508[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26480 === (1))){
var state_26479__$1 = state_26479;
var statearr_26482_26509 = state_26479__$1;
(statearr_26482_26509[(2)] = null);

(statearr_26482_26509[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26480 === (4))){
var inst_26428 = (state_26479[(2)]);
var state_26479__$1 = state_26479;
var statearr_26483_26510 = state_26479__$1;
(statearr_26483_26510[(2)] = inst_26428);

(statearr_26483_26510[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26480 === (13))){
var inst_26472 = (state_26479[(2)]);
var state_26479__$1 = state_26479;
var statearr_26484_26511 = state_26479__$1;
(statearr_26484_26511[(2)] = inst_26472);

(statearr_26484_26511[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26480 === (6))){
var inst_26436 = cljs.core.random_uuid.call(null);
var state_26479__$1 = state_26479;
var statearr_26485_26512 = state_26479__$1;
(statearr_26485_26512[(2)] = inst_26436);

(statearr_26485_26512[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26480 === (3))){
var inst_26477 = (state_26479[(2)]);
var state_26479__$1 = state_26479;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26479__$1,inst_26477);
} else {
if((state_val_26480 === (12))){
var inst_26455 = (state_26479[(7)]);
var state_26479__$1 = state_26479;
var statearr_26486_26513 = state_26479__$1;
(statearr_26486_26513[(2)] = inst_26455);

(statearr_26486_26513[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26480 === (2))){
var _ = (function (){var statearr_26487 = state_26479;
(statearr_26487[(4)] = cljs.core.cons.call(null,(5),(state_26479[(4)])));

return statearr_26487;
})();
var inst_26434 = (tt_id == null);
var state_26479__$1 = state_26479;
if(cljs.core.truth_(inst_26434)){
var statearr_26488_26514 = state_26479__$1;
(statearr_26488_26514[(1)] = (6));

} else {
var statearr_26489_26515 = state_26479__$1;
(statearr_26489_26515[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26480 === (11))){
var inst_26462 = (state_26479[(8)]);
var inst_26455 = (state_26479[(7)]);
var inst_26465 = fluree.db.graphdb.with_t.call(null,inst_26455,inst_26462);
var state_26479__$1 = state_26479;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26479__$1,(14),inst_26465);
} else {
if((state_val_26480 === (9))){
var inst_26462 = (state_26479[(8)]);
var inst_26456 = (state_26479[(9)]);
var inst_26461 = cljs.core.seq.call(null,inst_26456);
var inst_26462__$1 = cljs.core.first.call(null,inst_26461);
var inst_26463 = cljs.core.next.call(null,inst_26461);
var state_26479__$1 = (function (){var statearr_26491 = state_26479;
(statearr_26491[(10)] = inst_26463);

(statearr_26491[(8)] = inst_26462__$1);

return statearr_26491;
})();
if(cljs.core.truth_(inst_26462__$1)){
var statearr_26492_26516 = state_26479__$1;
(statearr_26492_26516[(1)] = (11));

} else {
var statearr_26493_26517 = state_26479__$1;
(statearr_26493_26517[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26480 === (5))){
var _ = (function (){var statearr_26494 = state_26479;
(statearr_26494[(4)] = cljs.core.rest.call(null,(state_26479[(4)])));

return statearr_26494;
})();
var state_26479__$1 = state_26479;
var ex26490 = (state_26479__$1[(2)]);
var statearr_26495_26518 = state_26479__$1;
(statearr_26495_26518[(5)] = ex26490);


if((ex26490 instanceof Error)){
var statearr_26496_26519 = state_26479__$1;
(statearr_26496_26519[(1)] = (4));

(statearr_26496_26519[(5)] = null);

} else {
throw ex26490;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26480 === (14))){
var inst_26463 = (state_26479[(10)]);
var inst_26467 = (state_26479[(2)]);
var inst_26468 = fluree.db.util.async.throw_err.call(null,inst_26467);
var inst_26455 = inst_26468;
var inst_26456 = inst_26463;
var state_26479__$1 = (function (){var statearr_26497 = state_26479;
(statearr_26497[(9)] = inst_26456);

(statearr_26497[(7)] = inst_26455);

return statearr_26497;
})();
var statearr_26498_26520 = state_26479__$1;
(statearr_26498_26520[(2)] = null);

(statearr_26498_26520[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26480 === (10))){
var inst_26474 = (state_26479[(2)]);
var _ = (function (){var statearr_26499 = state_26479;
(statearr_26499[(4)] = cljs.core.rest.call(null,(state_26479[(4)])));

return statearr_26499;
})();
var state_26479__$1 = state_26479;
var statearr_26500_26521 = state_26479__$1;
(statearr_26500_26521[(2)] = inst_26474);

(statearr_26500_26521[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26480 === (8))){
var inst_26439 = (state_26479[(2)]);
var inst_26440 = (function (){var tt_id__$1 = inst_26439;
return (function (db_STAR_,idx){
return cljs.core.update.call(null,db_STAR_,idx,cljs.core.assoc,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id__$1);
});
})();
var inst_26441 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_26439);
var inst_26442 = cljs.core.reduce.call(null,inst_26440,inst_26441,fluree.db.index.types);
var inst_26443 = cljs.core.sort_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),fluree.db.flake.cmp_tx,flakes);
var inst_26444 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26443);
var inst_26452 = cljs.core.seq.call(null,inst_26444);
var inst_26453 = cljs.core.first.call(null,inst_26452);
var inst_26454 = cljs.core.next.call(null,inst_26452);
var inst_26455 = inst_26442;
var inst_26456 = inst_26444;
var state_26479__$1 = (function (){var statearr_26501 = state_26479;
(statearr_26501[(11)] = inst_26454);

(statearr_26501[(12)] = inst_26453);

(statearr_26501[(9)] = inst_26456);

(statearr_26501[(7)] = inst_26455);

return statearr_26501;
})();
var statearr_26502_26522 = state_26479__$1;
(statearr_26502_26522[(2)] = null);

(statearr_26502_26522[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____0 = (function (){
var statearr_26503 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26503[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__);

(statearr_26503[(1)] = (1));

return statearr_26503;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____1 = (function (state_26479){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26479);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26504){var ex__2749__auto__ = e26504;
var statearr_26505_26523 = state_26479;
(statearr_26505_26523[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26479[(4)]))){
var statearr_26506_26524 = state_26479;
(statearr_26506_26524[(1)] = cljs.core.first.call(null,(state_26479[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26525 = state_26479;
state_26479 = G__26525;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__ = function(state_26479){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____1.call(this,state_26479);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26507 = f__2769__auto__.call(null);
(statearr_26507[(6)] = c__2768__auto__);

return statearr_26507;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.call(null);
var c__2768__auto___26712 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26643){
var state_val_26644 = (state_26643[(1)]);
if((state_val_26644 === (7))){
var inst_26553 = (state_26643[(7)]);
var inst_26553__$1 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_26643__$1 = (function (){var statearr_26645 = state_26643;
(statearr_26645[(7)] = inst_26553__$1);

return statearr_26645;
})();
if(inst_26553__$1){
var statearr_26646_26713 = state_26643__$1;
(statearr_26646_26713[(1)] = (13));

} else {
var statearr_26647_26714 = state_26643__$1;
(statearr_26647_26714[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (20))){
var state_26643__$1 = state_26643;
var statearr_26648_26715 = state_26643__$1;
(statearr_26648_26715[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (27))){
var inst_26589 = (state_26643[(8)]);
var inst_26593 = fluree.db.flake.s.call(null,inst_26589);
var state_26643__$1 = state_26643;
var statearr_26650_26716 = state_26643__$1;
(statearr_26650_26716[(2)] = inst_26593);

(statearr_26650_26716[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (1))){
var state_26643__$1 = state_26643;
var statearr_26651_26717 = state_26643__$1;
(statearr_26651_26717[(2)] = null);

(statearr_26651_26717[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (24))){
var inst_26583 = (state_26643[(9)]);
var inst_26587 = cljs.core.first.call(null,inst_26583);
var state_26643__$1 = state_26643;
var statearr_26652_26718 = state_26643__$1;
(statearr_26652_26718[(2)] = inst_26587);

(statearr_26652_26718[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (39))){
var state_26643__$1 = state_26643;
var statearr_26653_26719 = state_26643__$1;
(statearr_26653_26719[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (4))){
var inst_26526 = (state_26643[(2)]);
var inst_26527 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_26528 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26529 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_26530 = cljs.core.PersistentHashMap.fromArrays(inst_26528,inst_26529);
var inst_26531 = cljs.core.ex_info.call(null,inst_26527,inst_26530,inst_26526);
var inst_26532 = cljs.core.async.put_BANG_.call(null,return_chan,inst_26531);
var state_26643__$1 = state_26643;
var statearr_26655_26720 = state_26643__$1;
(statearr_26655_26720[(2)] = inst_26532);

(statearr_26655_26720[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (15))){
var inst_26560 = (state_26643[(2)]);
var state_26643__$1 = state_26643;
if(cljs.core.truth_(inst_26560)){
var statearr_26656_26721 = state_26643__$1;
(statearr_26656_26721[(1)] = (16));

} else {
var statearr_26657_26722 = state_26643__$1;
(statearr_26657_26722[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (21))){
var inst_26609 = (state_26643[(2)]);
var state_26643__$1 = state_26643;
var statearr_26658_26723 = state_26643__$1;
(statearr_26658_26723[(2)] = inst_26609);

(statearr_26658_26723[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (31))){
var inst_26607 = (state_26643[(2)]);
var state_26643__$1 = state_26643;
var statearr_26659_26724 = state_26643__$1;
(statearr_26659_26724[(2)] = inst_26607);

(statearr_26659_26724[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (32))){
var inst_26613 = (state_26643[(10)]);
var inst_26615 = cljs.core.async.put_BANG_.call(null,return_chan,inst_26613);
var state_26643__$1 = state_26643;
var statearr_26660_26725 = state_26643__$1;
(statearr_26660_26725[(2)] = inst_26615);

(statearr_26660_26725[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (40))){
var inst_26636 = (state_26643[(2)]);
var state_26643__$1 = state_26643;
var statearr_26661_26726 = state_26643__$1;
(statearr_26661_26726[(2)] = inst_26636);

(statearr_26661_26726[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (33))){
var inst_26613 = (state_26643[(10)]);
var inst_26617 = (state_26643[(11)]);
var inst_26617__$1 = (inst_26613 == null);
var state_26643__$1 = (function (){var statearr_26662 = state_26643;
(statearr_26662[(11)] = inst_26617__$1);

return statearr_26662;
})();
if(cljs.core.truth_(inst_26617__$1)){
var statearr_26663_26727 = state_26643__$1;
(statearr_26663_26727[(1)] = (35));

} else {
var statearr_26664_26728 = state_26643__$1;
(statearr_26664_26728[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (13))){
var inst_26555 = cljs.core.first.call(null,ident);
var inst_26556 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_26555);
var inst_26557 = (inst_26556 == null);
var state_26643__$1 = state_26643;
var statearr_26665_26729 = state_26643__$1;
(statearr_26665_26729[(2)] = inst_26557);

(statearr_26665_26729[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (22))){
var inst_26583 = (state_26643[(9)]);
var inst_26582 = (state_26643[(2)]);
var inst_26583__$1 = fluree.db.util.async.throw_err.call(null,inst_26582);
var inst_26584 = (inst_26583__$1 == null);
var state_26643__$1 = (function (){var statearr_26666 = state_26643;
(statearr_26666[(9)] = inst_26583__$1);

return statearr_26666;
})();
if(cljs.core.truth_(inst_26584)){
var statearr_26667_26730 = state_26643__$1;
(statearr_26667_26730[(1)] = (23));

} else {
var statearr_26668_26731 = state_26643__$1;
(statearr_26668_26731[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (36))){
var inst_26617 = (state_26643[(11)]);
var state_26643__$1 = state_26643;
var statearr_26669_26732 = state_26643__$1;
(statearr_26669_26732[(2)] = inst_26617);

(statearr_26669_26732[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (41))){
var inst_26631 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_26643__$1 = state_26643;
var statearr_26670_26733 = state_26643__$1;
(statearr_26670_26733[(2)] = inst_26631);

(statearr_26670_26733[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (43))){
var inst_26634 = (state_26643[(2)]);
var state_26643__$1 = state_26643;
var statearr_26671_26734 = state_26643__$1;
(statearr_26671_26734[(2)] = inst_26634);

(statearr_26671_26734[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (29))){
var inst_26598 = cljs.core.pr_str.call(null,ident);
var inst_26599 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_26598].join('');
var inst_26600 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26601 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_26602 = cljs.core.PersistentHashMap.fromArrays(inst_26600,inst_26601);
var inst_26603 = cljs.core.ex_info.call(null,inst_26599,inst_26602);
var inst_26604 = (function(){throw inst_26603})();
var state_26643__$1 = state_26643;
var statearr_26672_26735 = state_26643__$1;
(statearr_26672_26735[(2)] = inst_26604);

(statearr_26672_26735[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (6))){
var inst_26540 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26541 = [ident];
var inst_26542 = (new cljs.core.PersistentVector(null,1,(5),inst_26540,inst_26541,null));
var inst_26543 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26542);
var state_26643__$1 = state_26643;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26643__$1,(9),inst_26543);
} else {
if((state_val_26644 === (28))){
var inst_26595 = (state_26643[(2)]);
var state_26643__$1 = state_26643;
var statearr_26673_26736 = state_26643__$1;
(statearr_26673_26736[(2)] = inst_26595);

(statearr_26673_26736[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (25))){
var inst_26589 = (state_26643[(8)]);
var inst_26589__$1 = (state_26643[(2)]);
var inst_26590 = (inst_26589__$1 == null);
var state_26643__$1 = (function (){var statearr_26674 = state_26643;
(statearr_26674[(8)] = inst_26589__$1);

return statearr_26674;
})();
if(cljs.core.truth_(inst_26590)){
var statearr_26675_26737 = state_26643__$1;
(statearr_26675_26737[(1)] = (26));

} else {
var statearr_26676_26738 = state_26643__$1;
(statearr_26676_26738[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (34))){
var inst_26638 = (state_26643[(2)]);
var _ = (function (){var statearr_26677 = state_26643;
(statearr_26677[(4)] = cljs.core.rest.call(null,(state_26643[(4)])));

return statearr_26677;
})();
var state_26643__$1 = state_26643;
var statearr_26678_26739 = state_26643__$1;
(statearr_26678_26739[(2)] = inst_26638);

(statearr_26678_26739[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (17))){
var inst_26571 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_26643__$1 = state_26643;
if(inst_26571){
var statearr_26679_26740 = state_26643__$1;
(statearr_26679_26740[(1)] = (19));

} else {
var statearr_26680_26741 = state_26643__$1;
(statearr_26680_26741[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (3))){
var inst_26641 = (state_26643[(2)]);
var state_26643__$1 = state_26643;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26643__$1,inst_26641);
} else {
if((state_val_26644 === (12))){
var inst_26551 = (state_26643[(2)]);
var state_26643__$1 = state_26643;
var statearr_26681_26742 = state_26643__$1;
(statearr_26681_26742[(2)] = inst_26551);

(statearr_26681_26742[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (2))){
var _ = (function (){var statearr_26682 = state_26643;
(statearr_26682[(4)] = cljs.core.cons.call(null,(5),(state_26643[(4)])));

return statearr_26682;
})();
var inst_26538 = typeof ident === 'number';
var state_26643__$1 = state_26643;
if(cljs.core.truth_(inst_26538)){
var statearr_26683_26743 = state_26643__$1;
(statearr_26683_26743[(1)] = (6));

} else {
var statearr_26684_26744 = state_26643__$1;
(statearr_26684_26744[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (23))){
var state_26643__$1 = state_26643;
var statearr_26685_26745 = state_26643__$1;
(statearr_26685_26745[(2)] = null);

(statearr_26685_26745[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (35))){
var state_26643__$1 = state_26643;
var statearr_26686_26746 = state_26643__$1;
(statearr_26686_26746[(2)] = strict_QMARK_);

(statearr_26686_26746[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (19))){
var inst_26574 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26575 = cljs.core.first.call(null,ident);
var inst_26576 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_26575);
var inst_26577 = cljs.core.second.call(null,ident);
var inst_26578 = [inst_26576,inst_26577];
var inst_26579 = (new cljs.core.PersistentVector(null,2,(5),inst_26574,inst_26578,null));
var inst_26580 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_26579);
var state_26643__$1 = state_26643;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26643__$1,(22),inst_26580);
} else {
if((state_val_26644 === (11))){
var state_26643__$1 = state_26643;
var statearr_26688_26747 = state_26643__$1;
(statearr_26688_26747[(2)] = null);

(statearr_26688_26747[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (9))){
var inst_26545 = (state_26643[(2)]);
var inst_26546 = fluree.db.util.async.throw_err.call(null,inst_26545);
var inst_26547 = cljs.core.not_empty.call(null,inst_26546);
var state_26643__$1 = state_26643;
if(cljs.core.truth_(inst_26547)){
var statearr_26689_26748 = state_26643__$1;
(statearr_26689_26748[(1)] = (10));

} else {
var statearr_26690_26749 = state_26643__$1;
(statearr_26690_26749[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (5))){
var _ = (function (){var statearr_26691 = state_26643;
(statearr_26691[(4)] = cljs.core.rest.call(null,(state_26643[(4)])));

return statearr_26691;
})();
var state_26643__$1 = state_26643;
var ex26687 = (state_26643__$1[(2)]);
var statearr_26692_26750 = state_26643__$1;
(statearr_26692_26750[(5)] = ex26687);


var statearr_26693_26751 = state_26643__$1;
(statearr_26693_26751[(1)] = (4));

(statearr_26693_26751[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (14))){
var inst_26553 = (state_26643[(7)]);
var state_26643__$1 = state_26643;
var statearr_26694_26752 = state_26643__$1;
(statearr_26694_26752[(2)] = inst_26553);

(statearr_26694_26752[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (26))){
var state_26643__$1 = state_26643;
var statearr_26695_26753 = state_26643__$1;
(statearr_26695_26753[(2)] = null);

(statearr_26695_26753[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (16))){
var inst_26562 = cljs.core.first.call(null,ident);
var inst_26563 = cljs.core.pr_str.call(null,inst_26562);
var inst_26564 = ["Subject ID lookup failed. The predicate ",inst_26563," does not exist."].join('');
var inst_26565 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26566 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_26567 = cljs.core.PersistentHashMap.fromArrays(inst_26565,inst_26566);
var inst_26568 = cljs.core.ex_info.call(null,inst_26564,inst_26567);
var inst_26569 = (function(){throw inst_26568})();
var state_26643__$1 = state_26643;
var statearr_26696_26754 = state_26643__$1;
(statearr_26696_26754[(2)] = inst_26569);

(statearr_26696_26754[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (38))){
var inst_26623 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_26624 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26625 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_26626 = cljs.core.PersistentHashMap.fromArrays(inst_26624,inst_26625);
var inst_26627 = cljs.core.ex_info.call(null,inst_26623,inst_26626);
var inst_26628 = cljs.core.async.put_BANG_.call(null,return_chan,inst_26627);
var state_26643__$1 = state_26643;
var statearr_26697_26755 = state_26643__$1;
(statearr_26697_26755[(2)] = inst_26628);

(statearr_26697_26755[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (30))){
var state_26643__$1 = state_26643;
var statearr_26698_26756 = state_26643__$1;
(statearr_26698_26756[(2)] = null);

(statearr_26698_26756[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (10))){
var state_26643__$1 = state_26643;
var statearr_26699_26757 = state_26643__$1;
(statearr_26699_26757[(2)] = ident);

(statearr_26699_26757[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (18))){
var inst_26611 = (state_26643[(2)]);
var state_26643__$1 = state_26643;
var statearr_26700_26758 = state_26643__$1;
(statearr_26700_26758[(2)] = inst_26611);

(statearr_26700_26758[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (42))){
var state_26643__$1 = state_26643;
var statearr_26701_26759 = state_26643__$1;
(statearr_26701_26759[(2)] = null);

(statearr_26701_26759[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (37))){
var inst_26621 = (state_26643[(2)]);
var state_26643__$1 = state_26643;
if(cljs.core.truth_(inst_26621)){
var statearr_26702_26760 = state_26643__$1;
(statearr_26702_26760[(1)] = (38));

} else {
var statearr_26703_26761 = state_26643__$1;
(statearr_26703_26761[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26644 === (8))){
var inst_26613 = (state_26643[(10)]);
var inst_26613__$1 = (state_26643[(2)]);
var state_26643__$1 = (function (){var statearr_26704 = state_26643;
(statearr_26704[(10)] = inst_26613__$1);

return statearr_26704;
})();
if(cljs.core.truth_(inst_26613__$1)){
var statearr_26705_26762 = state_26643__$1;
(statearr_26705_26762[(1)] = (32));

} else {
var statearr_26706_26763 = state_26643__$1;
(statearr_26706_26763[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__2746__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__2746__auto____0 = (function (){
var statearr_26707 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26707[(0)] = fluree$db$graphdb$subid_$_state_machine__2746__auto__);

(statearr_26707[(1)] = (1));

return statearr_26707;
});
var fluree$db$graphdb$subid_$_state_machine__2746__auto____1 = (function (state_26643){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26643);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26708){var ex__2749__auto__ = e26708;
var statearr_26709_26764 = state_26643;
(statearr_26709_26764[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26643[(4)]))){
var statearr_26710_26765 = state_26643;
(statearr_26710_26765[(1)] = cljs.core.first.call(null,(state_26643[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26766 = state_26643;
state_26643 = G__26766;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__2746__auto__ = function(state_26643){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__2746__auto____1.call(this,state_26643);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__2746__auto____0;
fluree$db$graphdb$subid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__2746__auto____1;
return fluree$db$graphdb$subid_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26711 = f__2769__auto__.call(null);
(statearr_26711[(6)] = c__2768__auto___26712);

return statearr_26711;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__26767){
var map__26768 = p__26767;
var map__26768__$1 = cljs.core.__destructure_map.call(null,map__26768);
var db = map__26768__$1;
var current_db_fn = cljs.core.get.call(null,map__26768__$1,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
var permissions = cljs.core.get.call(null,map__26768__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26784){
var state_val_26785 = (state_26784[(1)]);
if((state_val_26785 === (1))){
var state_26784__$1 = state_26784;
var statearr_26786_26800 = state_26784__$1;
(statearr_26786_26800[(2)] = null);

(statearr_26786_26800[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26785 === (2))){
var _ = (function (){var statearr_26787 = state_26784;
(statearr_26787[(4)] = cljs.core.cons.call(null,(5),(state_26784[(4)])));

return statearr_26787;
})();
var inst_26775 = current_db_fn.call(null,db);
var state_26784__$1 = state_26784;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26784__$1,(6),inst_26775);
} else {
if((state_val_26785 === (3))){
var inst_26782 = (state_26784[(2)]);
var state_26784__$1 = state_26784;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26784__$1,inst_26782);
} else {
if((state_val_26785 === (4))){
var inst_26769 = (state_26784[(2)]);
var state_26784__$1 = state_26784;
var statearr_26789_26801 = state_26784__$1;
(statearr_26789_26801[(2)] = inst_26769);

(statearr_26789_26801[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26785 === (5))){
var _ = (function (){var statearr_26790 = state_26784;
(statearr_26790[(4)] = cljs.core.rest.call(null,(state_26784[(4)])));

return statearr_26790;
})();
var state_26784__$1 = state_26784;
var ex26788 = (state_26784__$1[(2)]);
var statearr_26791_26802 = state_26784__$1;
(statearr_26791_26802[(5)] = ex26788);


if((ex26788 instanceof Error)){
var statearr_26792_26803 = state_26784__$1;
(statearr_26792_26803[(1)] = (4));

(statearr_26792_26803[(5)] = null);

} else {
throw ex26788;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26785 === (6))){
var inst_26777 = (state_26784[(2)]);
var inst_26778 = fluree.db.util.async.throw_err.call(null,inst_26777);
var inst_26779 = cljs.core.assoc.call(null,inst_26778,new cljs.core.Keyword(null,"permissions","permissions",67803075),permissions);
var _ = (function (){var statearr_26793 = state_26784;
(statearr_26793[(4)] = cljs.core.rest.call(null,(state_26784[(4)])));

return statearr_26793;
})();
var state_26784__$1 = state_26784;
var statearr_26794_26804 = state_26784__$1;
(statearr_26794_26804[(2)] = inst_26779);

(statearr_26794_26804[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____0 = (function (){
var statearr_26795 = [null,null,null,null,null,null,null];
(statearr_26795[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__);

(statearr_26795[(1)] = (1));

return statearr_26795;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____1 = (function (state_26784){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26784);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26796){var ex__2749__auto__ = e26796;
var statearr_26797_26805 = state_26784;
(statearr_26797_26805[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26784[(4)]))){
var statearr_26798_26806 = state_26784;
(statearr_26798_26806[(1)] = cljs.core.first.call(null,(state_26784[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26807 = state_26784;
state_26784 = G__26807;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__ = function(state_26784){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____1.call(this,state_26784);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26799 = f__2769__auto__.call(null);
(statearr_26799[(6)] = c__2768__auto__);

return statearr_26799;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.call(null,this$,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__26808,property,collection){
var map__26809 = p__26808;
var map__26809__$1 = cljs.core.__destructure_map.call(null,map__26809);
var schema = cljs.core.get.call(null,map__26809__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"partition","partition",1174740751),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_.call(null,collection)){
return cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__26810,property,predicate){
var map__26811 = p__26810;
var map__26811__$1 = cljs.core.__destructure_map.call(null,map__26811);
var this$ = map__26811__$1;
var schema = cljs.core.get.call(null,map__26811__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__26812 = cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return fluree.db.dbproto._c_prop.call(null,this$,new cljs.core.Keyword(null,"partition","partition",1174740751),G__26812);
} else {
return G__26812;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return new cljs.core.Keyword("fluree.db.graphdb","no-pred","fluree.db.graphdb/no-pred",1182779470);
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__26814 = arguments.length;
switch (G__26814) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26846){
var state_val_26847 = (state_26846[(1)]);
if((state_val_26847 === (7))){
var state_26846__$1 = state_26846;
var statearr_26848_26942 = state_26846__$1;
(statearr_26848_26942[(2)] = null);

(statearr_26848_26942[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (1))){
var state_26846__$1 = state_26846;
var statearr_26849_26943 = state_26846__$1;
(statearr_26849_26943[(2)] = null);

(statearr_26849_26943[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (4))){
var inst_26815 = (state_26846[(2)]);
var state_26846__$1 = state_26846;
var statearr_26850_26944 = state_26846__$1;
(statearr_26850_26944[(2)] = inst_26815);

(statearr_26850_26944[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (6))){
var inst_26829 = (state_26846[(7)]);
var inst_26828 = (state_26846[(2)]);
var inst_26829__$1 = fluree.db.util.async.throw_err.call(null,inst_26828);
var inst_26830 = (inst_26829__$1 == null);
var state_26846__$1 = (function (){var statearr_26851 = state_26846;
(statearr_26851[(7)] = inst_26829__$1);

return statearr_26851;
})();
if(cljs.core.truth_(inst_26830)){
var statearr_26852_26945 = state_26846__$1;
(statearr_26852_26945[(1)] = (7));

} else {
var statearr_26853_26946 = state_26846__$1;
(statearr_26853_26946[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (3))){
var inst_26844 = (state_26846[(2)]);
var state_26846__$1 = state_26846;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26846__$1,inst_26844);
} else {
if((state_val_26847 === (12))){
var inst_26841 = (state_26846[(2)]);
var _ = (function (){var statearr_26854 = state_26846;
(statearr_26854[(4)] = cljs.core.rest.call(null,(state_26846[(4)])));

return statearr_26854;
})();
var state_26846__$1 = state_26846;
var statearr_26855_26947 = state_26846__$1;
(statearr_26855_26947[(2)] = inst_26841);

(statearr_26855_26947[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (2))){
var _ = (function (){var statearr_26856 = state_26846;
(statearr_26856[(4)] = cljs.core.cons.call(null,(5),(state_26846[(4)])));

return statearr_26856;
})();
var inst_26822 = fluree.db.dbproto._rootdb.call(null,this$);
var inst_26823 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26824 = [tag_id,(30)];
var inst_26825 = (new cljs.core.PersistentVector(null,2,(5),inst_26823,inst_26824,null));
var inst_26826 = fluree.db.query.range.index_range.call(null,inst_26822,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26825);
var state_26846__$1 = state_26846;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26846__$1,(6),inst_26826);
} else {
if((state_val_26847 === (11))){
var inst_26835 = (state_26846[(8)]);
var inst_26839 = fluree.db.flake.o.call(null,inst_26835);
var state_26846__$1 = state_26846;
var statearr_26858_26948 = state_26846__$1;
(statearr_26858_26948[(2)] = inst_26839);

(statearr_26858_26948[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (9))){
var inst_26835 = (state_26846[(8)]);
var inst_26835__$1 = (state_26846[(2)]);
var inst_26836 = (inst_26835__$1 == null);
var state_26846__$1 = (function (){var statearr_26859 = state_26846;
(statearr_26859[(8)] = inst_26835__$1);

return statearr_26859;
})();
if(cljs.core.truth_(inst_26836)){
var statearr_26860_26949 = state_26846__$1;
(statearr_26860_26949[(1)] = (10));

} else {
var statearr_26861_26950 = state_26846__$1;
(statearr_26861_26950[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (5))){
var _ = (function (){var statearr_26862 = state_26846;
(statearr_26862[(4)] = cljs.core.rest.call(null,(state_26846[(4)])));

return statearr_26862;
})();
var state_26846__$1 = state_26846;
var ex26857 = (state_26846__$1[(2)]);
var statearr_26863_26951 = state_26846__$1;
(statearr_26863_26951[(5)] = ex26857);


if((ex26857 instanceof Error)){
var statearr_26864_26952 = state_26846__$1;
(statearr_26864_26952[(1)] = (4));

(statearr_26864_26952[(5)] = null);

} else {
throw ex26857;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (10))){
var state_26846__$1 = state_26846;
var statearr_26865_26953 = state_26846__$1;
(statearr_26865_26953[(2)] = null);

(statearr_26865_26953[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (8))){
var inst_26829 = (state_26846[(7)]);
var inst_26833 = cljs.core.first.call(null,inst_26829);
var state_26846__$1 = state_26846;
var statearr_26866_26954 = state_26846__$1;
(statearr_26866_26954[(2)] = inst_26833);

(statearr_26866_26954[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_26867 = [null,null,null,null,null,null,null,null,null];
(statearr_26867[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_26867[(1)] = (1));

return statearr_26867;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_26846){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26846);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26868){var ex__2749__auto__ = e26868;
var statearr_26869_26955 = state_26846;
(statearr_26869_26955[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26846[(4)]))){
var statearr_26870_26956 = state_26846;
(statearr_26870_26956[(1)] = cljs.core.first.call(null,(state_26846[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26957 = state_26846;
state_26846 = G__26957;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_26846){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_26846);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26871 = f__2769__auto__.call(null);
(statearr_26871[(6)] = c__2768__auto__);

return statearr_26871;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26907){
var state_val_26908 = (state_26907[(1)]);
if((state_val_26908 === (7))){
var inst_26881 = fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_26907__$1 = state_26907;
var statearr_26909_26958 = state_26907__$1;
(statearr_26909_26958[(2)] = inst_26881);

(statearr_26909_26958[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26908 === (1))){
var state_26907__$1 = state_26907;
var statearr_26910_26959 = state_26907__$1;
(statearr_26910_26959[(2)] = null);

(statearr_26910_26959[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26908 === (4))){
var inst_26872 = (state_26907[(2)]);
var state_26907__$1 = state_26907;
var statearr_26911_26960 = state_26907__$1;
(statearr_26911_26960[(2)] = inst_26872);

(statearr_26911_26960[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26908 === (15))){
var inst_26902 = (state_26907[(2)]);
var _ = (function (){var statearr_26912 = state_26907;
(statearr_26912[(4)] = cljs.core.rest.call(null,(state_26907[(4)])));

return statearr_26912;
})();
var state_26907__$1 = state_26907;
var statearr_26913_26961 = state_26907__$1;
(statearr_26913_26961[(2)] = inst_26902);

(statearr_26913_26961[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26908 === (13))){
var inst_26887 = (state_26907[(7)]);
var inst_26893 = clojure.string.includes_QMARK_.call(null,inst_26887,":");
var state_26907__$1 = state_26907;
if(inst_26893){
var statearr_26914_26962 = state_26907__$1;
(statearr_26914_26962[(1)] = (16));

} else {
var statearr_26915_26963 = state_26907__$1;
(statearr_26915_26963[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26908 === (6))){
var state_26907__$1 = state_26907;
var statearr_26916_26964 = state_26907__$1;
(statearr_26916_26964[(2)] = pred);

(statearr_26916_26964[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26908 === (17))){
var inst_26887 = (state_26907[(7)]);
var state_26907__$1 = state_26907;
var statearr_26917_26965 = state_26907__$1;
(statearr_26917_26965[(2)] = inst_26887);

(statearr_26917_26965[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26908 === (3))){
var inst_26905 = (state_26907[(2)]);
var state_26907__$1 = state_26907;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26907__$1,inst_26905);
} else {
if((state_val_26908 === (12))){
var inst_26891 = (state_26907[(2)]);
var state_26907__$1 = state_26907;
if(cljs.core.truth_(inst_26891)){
var statearr_26918_26966 = state_26907__$1;
(statearr_26918_26966[(1)] = (13));

} else {
var statearr_26919_26967 = state_26907__$1;
(statearr_26919_26967[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26908 === (2))){
var _ = (function (){var statearr_26920 = state_26907;
(statearr_26920[(4)] = cljs.core.cons.call(null,(5),(state_26907[(4)])));

return statearr_26920;
})();
var inst_26878 = typeof pred === 'string';
var state_26907__$1 = state_26907;
if(cljs.core.truth_(inst_26878)){
var statearr_26921_26968 = state_26907__$1;
(statearr_26921_26968[(1)] = (6));

} else {
var statearr_26922_26969 = state_26907__$1;
(statearr_26922_26969[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26908 === (11))){
var inst_26883 = (state_26907[(8)]);
var state_26907__$1 = state_26907;
var statearr_26924_26970 = state_26907__$1;
(statearr_26924_26970[(2)] = inst_26883);

(statearr_26924_26970[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26908 === (9))){
var inst_26883 = (state_26907[(8)]);
var inst_26886 = (state_26907[(2)]);
var inst_26887 = fluree.db.util.async.throw_err.call(null,inst_26886);
var state_26907__$1 = (function (){var statearr_26925 = state_26907;
(statearr_26925[(7)] = inst_26887);

return statearr_26925;
})();
if(cljs.core.truth_(inst_26883)){
var statearr_26926_26971 = state_26907__$1;
(statearr_26926_26971[(1)] = (10));

} else {
var statearr_26927_26972 = state_26907__$1;
(statearr_26927_26972[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26908 === (5))){
var _ = (function (){var statearr_26928 = state_26907;
(statearr_26928[(4)] = cljs.core.rest.call(null,(state_26907[(4)])));

return statearr_26928;
})();
var state_26907__$1 = state_26907;
var ex26923 = (state_26907__$1[(2)]);
var statearr_26929_26973 = state_26907__$1;
(statearr_26929_26973[(5)] = ex26923);


if((ex26923 instanceof Error)){
var statearr_26930_26974 = state_26907__$1;
(statearr_26930_26974[(1)] = (4));

(statearr_26930_26974[(5)] = null);

} else {
throw ex26923;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26908 === (14))){
var state_26907__$1 = state_26907;
var statearr_26931_26975 = state_26907__$1;
(statearr_26931_26975[(2)] = null);

(statearr_26931_26975[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26908 === (16))){
var inst_26887 = (state_26907[(7)]);
var inst_26895 = clojure.string.split.call(null,inst_26887,/:/);
var inst_26896 = cljs.core.second.call(null,inst_26895);
var state_26907__$1 = state_26907;
var statearr_26932_26976 = state_26907__$1;
(statearr_26932_26976[(2)] = inst_26896);

(statearr_26932_26976[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26908 === (10))){
var inst_26887 = (state_26907[(7)]);
var state_26907__$1 = state_26907;
var statearr_26933_26977 = state_26907__$1;
(statearr_26933_26977[(2)] = inst_26887);

(statearr_26933_26977[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26908 === (18))){
var inst_26899 = (state_26907[(2)]);
var state_26907__$1 = state_26907;
var statearr_26934_26978 = state_26907__$1;
(statearr_26934_26978[(2)] = inst_26899);

(statearr_26934_26978[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26908 === (8))){
var inst_26883 = (state_26907[(2)]);
var inst_26884 = fluree.db.dbproto._tag.call(null,this$,tag_id);
var state_26907__$1 = (function (){var statearr_26935 = state_26907;
(statearr_26935[(8)] = inst_26883);

return statearr_26935;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26907__$1,(9),inst_26884);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_26936 = [null,null,null,null,null,null,null,null,null];
(statearr_26936[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_26936[(1)] = (1));

return statearr_26936;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_26907){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26907);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26937){var ex__2749__auto__ = e26937;
var statearr_26938_26979 = state_26907;
(statearr_26938_26979[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26907[(4)]))){
var statearr_26939_26980 = state_26907;
(statearr_26939_26980[(1)] = cljs.core.first.call(null,(state_26907[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26981 = state_26907;
state_26907 = G__26981;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_26907){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_26907);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26940 = f__2769__auto__.call(null);
(statearr_26940[(6)] = c__2768__auto__);

return statearr_26940;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__26983 = arguments.length;
switch (G__26983) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27016){
var state_val_27017 = (state_27016[(1)]);
if((state_val_27017 === (7))){
var state_27016__$1 = state_27016;
var statearr_27018_27106 = state_27016__$1;
(statearr_27018_27106[(2)] = null);

(statearr_27018_27106[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27017 === (1))){
var state_27016__$1 = state_27016;
var statearr_27019_27107 = state_27016__$1;
(statearr_27019_27107[(2)] = null);

(statearr_27019_27107[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27017 === (4))){
var inst_26984 = (state_27016[(2)]);
var state_27016__$1 = state_27016;
var statearr_27020_27108 = state_27016__$1;
(statearr_27020_27108[(2)] = inst_26984);

(statearr_27020_27108[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27017 === (6))){
var inst_26999 = (state_27016[(7)]);
var inst_26998 = (state_27016[(2)]);
var inst_26999__$1 = fluree.db.util.async.throw_err.call(null,inst_26998);
var inst_27000 = (inst_26999__$1 == null);
var state_27016__$1 = (function (){var statearr_27021 = state_27016;
(statearr_27021[(7)] = inst_26999__$1);

return statearr_27021;
})();
if(cljs.core.truth_(inst_27000)){
var statearr_27022_27109 = state_27016__$1;
(statearr_27022_27109[(1)] = (7));

} else {
var statearr_27023_27110 = state_27016__$1;
(statearr_27023_27110[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27017 === (3))){
var inst_27014 = (state_27016[(2)]);
var state_27016__$1 = state_27016;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27016__$1,inst_27014);
} else {
if((state_val_27017 === (12))){
var inst_27011 = (state_27016[(2)]);
var _ = (function (){var statearr_27024 = state_27016;
(statearr_27024[(4)] = cljs.core.rest.call(null,(state_27016[(4)])));

return statearr_27024;
})();
var state_27016__$1 = state_27016;
var statearr_27025_27111 = state_27016__$1;
(statearr_27025_27111[(2)] = inst_27011);

(statearr_27025_27111[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27017 === (2))){
var _ = (function (){var statearr_27026 = state_27016;
(statearr_27026[(4)] = cljs.core.cons.call(null,(5),(state_27016[(4)])));

return statearr_27026;
})();
var inst_26990 = (30);
var inst_26992 = fluree.db.dbproto._rootdb.call(null,this$);
var inst_26993 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26994 = [inst_26990,tag_name];
var inst_26995 = (new cljs.core.PersistentVector(null,2,(5),inst_26993,inst_26994,null));
var inst_26996 = fluree.db.query.range.index_range.call(null,inst_26992,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_26995);
var state_27016__$1 = state_27016;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27016__$1,(6),inst_26996);
} else {
if((state_val_27017 === (11))){
var inst_27005 = (state_27016[(8)]);
var inst_27009 = fluree.db.flake.s.call(null,inst_27005);
var state_27016__$1 = state_27016;
var statearr_27028_27112 = state_27016__$1;
(statearr_27028_27112[(2)] = inst_27009);

(statearr_27028_27112[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27017 === (9))){
var inst_27005 = (state_27016[(8)]);
var inst_27005__$1 = (state_27016[(2)]);
var inst_27006 = (inst_27005__$1 == null);
var state_27016__$1 = (function (){var statearr_27029 = state_27016;
(statearr_27029[(8)] = inst_27005__$1);

return statearr_27029;
})();
if(cljs.core.truth_(inst_27006)){
var statearr_27030_27113 = state_27016__$1;
(statearr_27030_27113[(1)] = (10));

} else {
var statearr_27031_27114 = state_27016__$1;
(statearr_27031_27114[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27017 === (5))){
var _ = (function (){var statearr_27032 = state_27016;
(statearr_27032[(4)] = cljs.core.rest.call(null,(state_27016[(4)])));

return statearr_27032;
})();
var state_27016__$1 = state_27016;
var ex27027 = (state_27016__$1[(2)]);
var statearr_27033_27115 = state_27016__$1;
(statearr_27033_27115[(5)] = ex27027);


if((ex27027 instanceof Error)){
var statearr_27034_27116 = state_27016__$1;
(statearr_27034_27116[(1)] = (4));

(statearr_27034_27116[(5)] = null);

} else {
throw ex27027;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27017 === (10))){
var state_27016__$1 = state_27016;
var statearr_27035_27117 = state_27016__$1;
(statearr_27035_27117[(2)] = null);

(statearr_27035_27117[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27017 === (8))){
var inst_26999 = (state_27016[(7)]);
var inst_27003 = cljs.core.first.call(null,inst_26999);
var state_27016__$1 = state_27016;
var statearr_27036_27118 = state_27016__$1;
(statearr_27036_27118[(2)] = inst_27003);

(statearr_27036_27118[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_27037 = [null,null,null,null,null,null,null,null,null];
(statearr_27037[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_27037[(1)] = (1));

return statearr_27037;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_27016){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27016);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27038){var ex__2749__auto__ = e27038;
var statearr_27039_27119 = state_27016;
(statearr_27039_27119[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27016[(4)]))){
var statearr_27040_27120 = state_27016;
(statearr_27040_27120[(1)] = cljs.core.first.call(null,(state_27016[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27121 = state_27016;
state_27016 = G__27121;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_27016){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_27016);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27041 = f__2769__auto__.call(null);
(statearr_27041[(6)] = c__2768__auto__);

return statearr_27041;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27076){
var state_val_27077 = (state_27076[(1)]);
if((state_val_27077 === (7))){
var inst_27055 = typeof pred === 'string';
var state_27076__$1 = state_27076;
if(cljs.core.truth_(inst_27055)){
var statearr_27078_27122 = state_27076__$1;
(statearr_27078_27122[(1)] = (10));

} else {
var statearr_27079_27123 = state_27076__$1;
(statearr_27079_27123[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27077 === (1))){
var state_27076__$1 = state_27076;
var statearr_27080_27124 = state_27076__$1;
(statearr_27080_27124[(2)] = null);

(statearr_27080_27124[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27077 === (4))){
var inst_27042 = (state_27076[(2)]);
var state_27076__$1 = state_27076;
var statearr_27081_27125 = state_27076__$1;
(statearr_27081_27125[(2)] = inst_27042);

(statearr_27081_27125[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27077 === (15))){
var inst_27069 = (state_27076[(2)]);
var state_27076__$1 = state_27076;
var statearr_27082_27126 = state_27076__$1;
(statearr_27082_27126[(2)] = inst_27069);

(statearr_27082_27126[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27077 === (13))){
var inst_27060 = (state_27076[(7)]);
var inst_27062 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27060),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_27063 = fluree.db.dbproto._tag_id.call(null,this$,inst_27062);
var state_27076__$1 = state_27076;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27076__$1,(16),inst_27063);
} else {
if((state_val_27077 === (6))){
var inst_27050 = fluree.db.dbproto._tag_id.call(null,this$,tag_name);
var state_27076__$1 = state_27076;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27076__$1,(9),inst_27050);
} else {
if((state_val_27077 === (3))){
var inst_27074 = (state_27076[(2)]);
var state_27076__$1 = state_27076;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27076__$1,inst_27074);
} else {
if((state_val_27077 === (12))){
var inst_27060 = (state_27076[(7)]);
var inst_27060__$1 = (state_27076[(2)]);
var state_27076__$1 = (function (){var statearr_27083 = state_27076;
(statearr_27083[(7)] = inst_27060__$1);

return statearr_27083;
})();
if(cljs.core.truth_(inst_27060__$1)){
var statearr_27084_27127 = state_27076__$1;
(statearr_27084_27127[(1)] = (13));

} else {
var statearr_27085_27128 = state_27076__$1;
(statearr_27085_27128[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27077 === (2))){
var _ = (function (){var statearr_27086 = state_27076;
(statearr_27086[(4)] = cljs.core.cons.call(null,(5),(state_27076[(4)])));

return statearr_27086;
})();
var inst_27048 = clojure.string.includes_QMARK_.call(null,tag_name,"/");
var state_27076__$1 = state_27076;
if(inst_27048){
var statearr_27087_27129 = state_27076__$1;
(statearr_27087_27129[(1)] = (6));

} else {
var statearr_27088_27130 = state_27076__$1;
(statearr_27088_27130[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27077 === (11))){
var inst_27058 = fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_27076__$1 = state_27076;
var statearr_27090_27131 = state_27076__$1;
(statearr_27090_27131[(2)] = inst_27058);

(statearr_27090_27131[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27077 === (9))){
var inst_27052 = (state_27076[(2)]);
var inst_27053 = fluree.db.util.async.throw_err.call(null,inst_27052);
var state_27076__$1 = state_27076;
var statearr_27091_27132 = state_27076__$1;
(statearr_27091_27132[(2)] = inst_27053);

(statearr_27091_27132[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27077 === (5))){
var _ = (function (){var statearr_27092 = state_27076;
(statearr_27092[(4)] = cljs.core.rest.call(null,(state_27076[(4)])));

return statearr_27092;
})();
var state_27076__$1 = state_27076;
var ex27089 = (state_27076__$1[(2)]);
var statearr_27093_27133 = state_27076__$1;
(statearr_27093_27133[(5)] = ex27089);


if((ex27089 instanceof Error)){
var statearr_27094_27134 = state_27076__$1;
(statearr_27094_27134[(1)] = (4));

(statearr_27094_27134[(5)] = null);

} else {
throw ex27089;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27077 === (14))){
var state_27076__$1 = state_27076;
var statearr_27095_27135 = state_27076__$1;
(statearr_27095_27135[(2)] = null);

(statearr_27095_27135[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27077 === (16))){
var inst_27065 = (state_27076[(2)]);
var inst_27066 = fluree.db.util.async.throw_err.call(null,inst_27065);
var state_27076__$1 = state_27076;
var statearr_27096_27136 = state_27076__$1;
(statearr_27096_27136[(2)] = inst_27066);

(statearr_27096_27136[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27077 === (10))){
var state_27076__$1 = state_27076;
var statearr_27097_27137 = state_27076__$1;
(statearr_27097_27137[(2)] = pred);

(statearr_27097_27137[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27077 === (8))){
var inst_27071 = (state_27076[(2)]);
var _ = (function (){var statearr_27098 = state_27076;
(statearr_27098[(4)] = cljs.core.rest.call(null,(state_27076[(4)])));

return statearr_27098;
})();
var state_27076__$1 = state_27076;
var statearr_27099_27138 = state_27076__$1;
(statearr_27099_27138[(2)] = inst_27071);

(statearr_27099_27138[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_27100 = [null,null,null,null,null,null,null,null];
(statearr_27100[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_27100[(1)] = (1));

return statearr_27100;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_27076){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27076);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27101){var ex__2749__auto__ = e27101;
var statearr_27102_27139 = state_27076;
(statearr_27102_27139[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27076[(4)]))){
var statearr_27103_27140 = state_27076;
(statearr_27103_27140[(1)] = cljs.core.first.call(null,(state_27076[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27141 = state_27076;
state_27076 = G__27141;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_27076){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_27076);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27104 = f__2769__auto__.call(null);
(statearr_27104[(6)] = c__2768__auto__);

return statearr_27104;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.ledger_id = ledger_id;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.tspo = tspo;
this.schema = schema;
this.settings = settings;
this.comparators = comparators;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k27143,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__27147 = k27143;
var G__27147__$1 = (((G__27147 instanceof cljs.core.Keyword))?G__27147.fqn:null);
switch (G__27147__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "ledger-id":
return self__.ledger_id;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "tspo":
return self__.tspo;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "comparators":
return self__.comparators;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k27143,else__5346__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5366__auto__,p__27148){
var vec__27149 = p__27148;
var k__5367__auto__ = cljs.core.nth.call(null,vec__27149,(0),null);
var v__5368__auto__ = cljs.core.nth.call(null,vec__27149,(1),null);
return f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__);
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__5360__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tspo","tspo",-440144953),self__.tspo],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"comparators","comparators",-1325611955),self__.comparators],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27142){
var self__ = this;
var G__27142__$1 = this;
return (new cljs.core.RecordIter((0),G__27142__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"comparators","comparators",-1325611955),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (21 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll.call(null,coll__5340__auto__));
}).call(null,this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27144,other27145){
var self__ = this;
var this27144__$1 = this;
return (((!((other27145 == null)))) && ((((this27144__$1.constructor === other27145.constructor)) && (((cljs.core._EQ_.call(null,this27144__$1.conn,other27145.conn)) && (((cljs.core._EQ_.call(null,this27144__$1.network,other27145.network)) && (((cljs.core._EQ_.call(null,this27144__$1.ledger_id,other27145.ledger_id)) && (((cljs.core._EQ_.call(null,this27144__$1.block,other27145.block)) && (((cljs.core._EQ_.call(null,this27144__$1.t,other27145.t)) && (((cljs.core._EQ_.call(null,this27144__$1.tt_id,other27145.tt_id)) && (((cljs.core._EQ_.call(null,this27144__$1.stats,other27145.stats)) && (((cljs.core._EQ_.call(null,this27144__$1.spot,other27145.spot)) && (((cljs.core._EQ_.call(null,this27144__$1.psot,other27145.psot)) && (((cljs.core._EQ_.call(null,this27144__$1.post,other27145.post)) && (((cljs.core._EQ_.call(null,this27144__$1.opst,other27145.opst)) && (((cljs.core._EQ_.call(null,this27144__$1.tspo,other27145.tspo)) && (((cljs.core._EQ_.call(null,this27144__$1.schema,other27145.schema)) && (((cljs.core._EQ_.call(null,this27144__$1.settings,other27145.settings)) && (((cljs.core._EQ_.call(null,this27144__$1.comparators,other27145.comparators)) && (((cljs.core._EQ_.call(null,this27144__$1.schema_cache,other27145.schema_cache)) && (((cljs.core._EQ_.call(null,this27144__$1.novelty,other27145.novelty)) && (((cljs.core._EQ_.call(null,this27144__$1.permissions,other27145.permissions)) && (((cljs.core._EQ_.call(null,this27144__$1.fork,other27145.fork)) && (((cljs.core._EQ_.call(null,this27144__$1.fork_block,other27145.fork_block)) && (((cljs.core._EQ_.call(null,this27144__$1.current_db_fn,other27145.current_db_fn)) && (cljs.core._EQ_.call(null,this27144__$1.__extmap,other27145.__extmap)))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),null,new cljs.core.Keyword(null,"tspo","tspo",-440144953),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"comparators","comparators",-1325611955),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k27143){
var self__ = this;
var this__5350__auto____$1 = this;
var G__27152 = k27143;
var G__27152__$1 = (((G__27152 instanceof cljs.core.Keyword))?G__27152.fqn:null);
switch (G__27152__$1) {
case "conn":
case "network":
case "ledger-id":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "tspo":
case "schema":
case "settings":
case "comparators":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k27143);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__27142){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__27153 = cljs.core.keyword_identical_QMARK_;
var expr__27154 = k__5352__auto__;
if(cljs.core.truth_(pred__27153.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__27154))){
return (new fluree.db.graphdb.GraphDb(G__27142,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27153.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__27154))){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__27142,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27153.call(null,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),expr__27154))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__27142,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27153.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__27154))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,G__27142,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27153.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__27154))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,G__27142,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27153.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__27154))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,G__27142,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27153.call(null,new cljs.core.Keyword(null,"stats","stats",-85643011),expr__27154))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,G__27142,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27153.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),expr__27154))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,G__27142,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27153.call(null,new cljs.core.Keyword(null,"psot","psot",2111653059),expr__27154))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__27142,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27153.call(null,new cljs.core.Keyword(null,"post","post",269697687),expr__27154))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__27142,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27153.call(null,new cljs.core.Keyword(null,"opst","opst",1213963058),expr__27154))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__27142,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27153.call(null,new cljs.core.Keyword(null,"tspo","tspo",-440144953),expr__27154))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__27142,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27153.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__27154))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,G__27142,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27153.call(null,new cljs.core.Keyword(null,"settings","settings",1556144875),expr__27154))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,G__27142,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27153.call(null,new cljs.core.Keyword(null,"comparators","comparators",-1325611955),expr__27154))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,G__27142,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27153.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__27154))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,G__27142,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27153.call(null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),expr__27154))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,G__27142,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27153.call(null,new cljs.core.Keyword(null,"permissions","permissions",67803075),expr__27154))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,G__27142,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27153.call(null,new cljs.core.Keyword(null,"fork","fork",1062974235),expr__27154))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,G__27142,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27153.call(null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),expr__27154))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__27142,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27153.call(null,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),expr__27154))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__27142,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5352__auto__,G__27142),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tspo","tspo",-440144953),self__.tspo,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"comparators","comparators",-1325611955),self__.comparators,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__27142){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__27142,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5349__auto__,(0)),cljs.core._nth.call(null,entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db.call(null,this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx.call(null,this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop.call(null,this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop.call(null,this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.call(null,this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db.call(null,this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query.call(null,this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.call(null,this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.call(null,this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.call(null,this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.call(null,this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"ledger-id","ledger-id",-949008754,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"tspo","tspo",1200386574,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"comparators","comparators",314919572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write.call(null,writer__5390__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__27146){
var extmap__5385__auto__ = (function (){var G__27156 = cljs.core.dissoc.call(null,G__27146,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"comparators","comparators",-1325611955),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
if(cljs.core.record_QMARK_.call(null,G__27146)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__27156);
} else {
return G__27156;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27146),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27146),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(G__27146),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__27146),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__27146),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__27146),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__27146),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__27146),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__27146),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__27146),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__27146),new cljs.core.Keyword(null,"tspo","tspo",-440144953).cljs$core$IFn$_invoke$arity$1(G__27146),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__27146),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__27146),new cljs.core.Keyword(null,"comparators","comparators",-1325611955).cljs$core$IFn$_invoke$arity$1(G__27146),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27146),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__27146),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__27146),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__27146),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__27146),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__27146),null,cljs.core.not_empty.call(null,extmap__5385__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write.call(null,w,"#FlureeGraphDB ");

return cljs.core._write.call(null,w,cljs.core.pr.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),db__$1.ledger_id,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(comparators){
return cljs.core.reduce.call(null,(function (m,idx){
return cljs.core.assoc.call(null,m,idx,clojure.data.avl.sorted_set_by.call(null,cljs.core.get.call(null,comparators,idx)));
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),fluree.db.index.types);
});
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,ledger_id,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(ledger_id)){
} else {
throw (new Error(["Assert failed: ","No ledger-id provided when creating new db.","\n","ledger-id"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map.call(null,fluree.db.index.default_comparators);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var map__27159 = fluree.db.index.default_comparators;
var map__27159__$1 = cljs.core.__destructure_map.call(null,map__27159);
var spot_cmp = cljs.core.get.call(null,map__27159__$1,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot_cmp = cljs.core.get.call(null,map__27159__$1,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post_cmp = cljs.core.get.call(null,map__27159__$1,new cljs.core.Keyword(null,"post","post",269697687));
var opst_cmp = cljs.core.get.call(null,map__27159__$1,new cljs.core.Keyword(null,"opst","opst",1213963058));
var tspo_cmp = cljs.core.get.call(null,map__27159__$1,new cljs.core.Keyword(null,"tspo","tspo",-440144953));
var spot = fluree.db.index.empty_branch.call(null,network,ledger_id,spot_cmp);
var psot = fluree.db.index.empty_branch.call(null,network,ledger_id,psot_cmp);
var post = fluree.db.index.empty_branch.call(null,network,ledger_id,post_cmp);
var opst = fluree.db.index.empty_branch.call(null,network,ledger_id,opst_cmp);
var tspo = fluree.db.index.empty_branch.call(null,network,ledger_id,tspo_cmp);
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb.call(null,conn,network,ledger_id,(0),(-1),null,stats,spot,psot,post,opst,tspo,schema,settings,fluree.db.index.default_comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
