// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.query.analytical_parse');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"\"")) && (cljs.core._EQ_.call(null,cljs.core.last.call(null,cljs.core.name.call(null,form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.call(null,string);
}catch (e20105){var e = e20105;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some.call(null,(function (p1__20106_SHARP_){
var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,p1__20106_SHARP_);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.coll_QMARK_.call(null,p1__20106_SHARP_)){
return fluree.db.query.analytical.get_vars.call(null,p1__20106_SHARP_);
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv.call(null,(function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_.call(null,key);
var static_value = cljs.core.get.call(null,interm_vars,key_as_var);
if(((cljs.core._EQ_.call(null,idx,(1))) && (((cljs.core.not.call(null,key_as_var)) && (((cljs.core.not_EQ_.call(null,"_id",key)) && (cljs.core.not.call(null,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find.call(null,/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.call(null,["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20107_SHARP_){
return cljs.core.conj.call(null,p1__20107_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20108_SHARP_){
return cljs.core.conj.call(null,p1__20108_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.call(null,idx,(2));
if(and__5043__auto__){
return fluree.db.query.analytical_parse.query_fn_QMARK_.call(null,key);
} else {
return and__5043__auto__;
}
})())){
var filter_code = cljs.reader.read_string.call(null,cljs.core.subs.call(null,key,(1)));
var var$ = (function (){var or__5045__auto__ = fluree.db.query.analytical.get_vars.call(null,filter_code);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__20113 = fluree.db.query.analytical_filter.extract_filter_fn.call(null,filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.call(null,vec__20113,(0),null);
var _ = cljs.core.nth.call(null,vec__20113,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn.call(null,var$,fun);
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20109_SHARP_){
return cljs.core.conj.call(null,p1__20109_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.call(null,idx,(1));
if(and__5043__auto__){
return cljs.core.re_find.call(null,/\+/,key);
} else {
return and__5043__auto__;
}
})())){
var vec__20116 = clojure.string.split.call(null,key,/\+/);
var pred = cljs.core.nth.call(null,vec__20116,(0),null);
var recur_amt = cljs.core.nth.call(null,vec__20116,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__5045__auto__ = fluree.db.query.analytical.safe_read_string.call(null,recur_amt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20110_SHARP_){
return cljs.core.conj.call(null,p1__20110_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_.call(null,key)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20111_SHARP_){
return cljs.core.conj.call(null,p1__20111_SHARP_,fluree.db.query.analytical.safe_read_string.call(null,key));
}));
} else {
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20112_SHARP_){
return cljs.core.conj.call(null,p1__20112_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
/**
 * Returns an updated list of tuples that only contains tuple indexes from idx.
 *   e.g.:
 *   idx is a list of indexes, eg. [2 0 4]
 *   Thus, the return will be 3-tuples of nth 2, 0, 4 respectively.
 */
fluree.db.query.analytical.transform_tuples_to_idxs = (function fluree$db$query$analytical$transform_tuples_to_idxs(idxs,tuples){
return cljs.core.map.call(null,(function (tuple){
return cljs.core.map.call(null,(function (p1__20119_SHARP_){
return cljs.core.nth.call(null,tuple,p1__20119_SHARP_);
}),idxs);
}),tuples);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.call(null,(function (acc,var$){
var temp__5802__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var$);
if(cljs.core.truth_(temp__5802__auto__)){
var var$__$1 = temp__5802__auto__;
return cljs.core.conj.call(null,acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys.call(null,clause);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(rel_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(a_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
/**
 * Returns index positions of vars within headers.
 *   e.g. if vars were:
 *   ['?e '?name]
 *   and headers were:
 *   ['?email '?name '?x '?e]
 *   The return value would be: [3 1]
 */
fluree.db.query.analytical.get_tuple_indexes = (function fluree$db$query$analytical$get_tuple_indexes(vars,headers){
return cljs.core.reduce.call(null,(function (acc,var_smt){
var temp__5802__auto__ = (function (){var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var_smt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var var$ = temp__5802__auto__;
return cljs.core.conj.call(null,acc,fluree.db.util.core.index_of.call(null,headers,var$));
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. ","Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var idxs = fluree.db.query.analytical.get_tuple_indexes.call(null,vars,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
return fluree.db.query.analytical.transform_tuples_to_idxs.call(null,idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (add_amount > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fuel;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.volatile_QMARK_.call(null,fuel);
} else {
return and__5043__auto__;
}
})())){
return cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.call(null,(function (clause){
return cljs.core.mapv.call(null,(function (clause_item){
var temp__5802__auto__ = intersecting_vars.call(null,cljs.core.symbol.call(null,clause_item));
if(cljs.core.truth_(temp__5802__auto__)){
var key_replace = temp__5802__auto__;
var replacement = cljs.core.get.call(null,vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.call(null,replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__20122,optional_QMARK_,fuel,max_fuel){
var map__20123 = p__20122;
var map__20123__$1 = cljs.core.__destructure_map.call(null,map__20123);
var res = map__20123__$1;
var vars = cljs.core.get.call(null,map__20123__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20189){
var state_val_20190 = (state_20189[(1)]);
if((state_val_20190 === (7))){
var inst_20178 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20179 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses.call(null,r);
var inst_20180 = cljs.core.conj.call(null,inst_20179,clause);
var inst_20181 = [null,inst_20180];
var inst_20182 = (new cljs.core.PersistentVector(null,2,(5),inst_20178,inst_20181,null));
var state_20189__$1 = state_20189;
var statearr_20191_20219 = state_20189__$1;
(statearr_20191_20219[(2)] = inst_20182);

(statearr_20191_20219[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20190 === (1))){
var state_20189__$1 = state_20189;
var statearr_20192_20220 = state_20189__$1;
(statearr_20192_20220[(2)] = null);

(statearr_20192_20220[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20190 === (4))){
var inst_20124 = (state_20189[(2)]);
var state_20189__$1 = state_20189;
var statearr_20193_20221 = state_20189__$1;
(statearr_20193_20221[(2)] = inst_20124);

(statearr_20193_20221[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20190 === (15))){
var inst_20167 = (state_20189[(2)]);
var inst_20168 = fluree.db.util.async.throw_err.call(null,inst_20167);
var inst_20169 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_20168);
var inst_20170 = cljs.core.count.call(null,inst_20169);
var inst_20171 = fluree.db.query.analytical.add_fuel.call(null,inst_20170,fuel,max_fuel);
var inst_20172 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20173 = [inst_20168,r];
var inst_20174 = (new cljs.core.PersistentVector(null,2,(5),inst_20172,inst_20173,null));
var state_20189__$1 = (function (){var statearr_20194 = state_20189;
(statearr_20194[(7)] = inst_20171);

return statearr_20194;
})();
var statearr_20195_20222 = state_20189__$1;
(statearr_20195_20222[(2)] = inst_20174);

(statearr_20195_20222[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20190 === (13))){
var inst_20133 = (state_20189[(8)]);
var inst_20146 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_20147 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses.call(null,inst_20146);
var inst_20148 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_20133);
var inst_20149 = cljs.core.apply.call(null,cljs.core.concat,inst_20148);
var inst_20150 = cljs.core.set.call(null,inst_20149);
var inst_20151 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_20147);
var inst_20152 = cljs.core.apply.call(null,cljs.core.concat,inst_20151);
var inst_20153 = cljs.core.into.call(null,inst_20150,inst_20152);
var inst_20154 = (function (){var all_wd = inst_20133;
var optional = inst_20147;
var all_wd_vars = inst_20150;
var all_vars = inst_20153;
return (function (p1__20120_SHARP_){
return all_vars.call(null,p1__20120_SHARP_);
});
})();
var inst_20155 = cljs.core.keys.call(null,vars);
var inst_20156 = cljs.core.map.call(null,inst_20154,inst_20155);
var inst_20157 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_20156);
var inst_20158 = cljs.core.set.call(null,inst_20157);
var inst_20159 = (function (){var all_wd = inst_20133;
var optional = inst_20147;
var all_wd_vars = inst_20150;
var all_vars = inst_20153;
var intersecting_vars = inst_20158;
return (function (p1__20121_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,p1__20121_SHARP_);
});
})();
var inst_20160 = cljs.core.map.call(null,inst_20159,inst_20133);
var inst_20161 = cljs.core.apply.call(null,cljs.core.concat,inst_20160);
var inst_20162 = fluree.db.query.analytical.select_from_tuples.call(null,inst_20161,res);
var inst_20163 = fluree.db.query.analytical.replace_vars_wikidata.call(null,inst_20133,inst_20158,vars);
var inst_20164 = cljs.core.remove.call(null,inst_20158,inst_20153);
var inst_20165 = fluree.db.query.analytical_wikidata.get_wikidata_tuples.call(null,q_map,inst_20163,inst_20161,inst_20162,inst_20164,inst_20147);
var state_20189__$1 = state_20189;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20189__$1,(15),inst_20165);
} else {
if((state_val_20190 === (6))){
var inst_20134 = (state_20189[(9)]);
var inst_20132 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_20133 = fluree.db.query.analytical_wikidata.get_all_wd_clauses.call(null,inst_20132);
var inst_20134__$1 = optional_QMARK_;
var state_20189__$1 = (function (){var statearr_20196 = state_20189;
(statearr_20196[(9)] = inst_20134__$1);

(statearr_20196[(8)] = inst_20133);

return statearr_20196;
})();
if(cljs.core.truth_(inst_20134__$1)){
var statearr_20197_20223 = state_20189__$1;
(statearr_20197_20223[(1)] = (9));

} else {
var statearr_20198_20224 = state_20189__$1;
(statearr_20198_20224[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20190 === (3))){
var inst_20187 = (state_20189[(2)]);
var state_20189__$1 = state_20189;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20189__$1,inst_20187);
} else {
if((state_val_20190 === (12))){
var inst_20142 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20143 = [null,r];
var inst_20144 = (new cljs.core.PersistentVector(null,2,(5),inst_20142,inst_20143,null));
var state_20189__$1 = state_20189;
var statearr_20199_20225 = state_20189__$1;
(statearr_20199_20225[(2)] = inst_20144);

(statearr_20199_20225[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20190 === (2))){
var _ = (function (){var statearr_20200 = state_20189;
(statearr_20200[(4)] = cljs.core.cons.call(null,(5),(state_20189[(4)])));

return statearr_20200;
})();
var inst_20130 = (r == null);
var state_20189__$1 = state_20189;
if(cljs.core.truth_(inst_20130)){
var statearr_20201_20226 = state_20189__$1;
(statearr_20201_20226[(1)] = (6));

} else {
var statearr_20202_20227 = state_20189__$1;
(statearr_20202_20227[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20190 === (11))){
var inst_20140 = (state_20189[(2)]);
var state_20189__$1 = state_20189;
if(cljs.core.truth_(inst_20140)){
var statearr_20204_20228 = state_20189__$1;
(statearr_20204_20228[(1)] = (12));

} else {
var statearr_20205_20229 = state_20189__$1;
(statearr_20205_20229[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20190 === (9))){
var inst_20133 = (state_20189[(8)]);
var inst_20136 = cljs.core.empty_QMARK_.call(null,inst_20133);
var inst_20137 = (!(inst_20136));
var state_20189__$1 = state_20189;
var statearr_20206_20230 = state_20189__$1;
(statearr_20206_20230[(2)] = inst_20137);

(statearr_20206_20230[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20190 === (5))){
var _ = (function (){var statearr_20207 = state_20189;
(statearr_20207[(4)] = cljs.core.rest.call(null,(state_20189[(4)])));

return statearr_20207;
})();
var state_20189__$1 = state_20189;
var ex20203 = (state_20189__$1[(2)]);
var statearr_20208_20231 = state_20189__$1;
(statearr_20208_20231[(5)] = ex20203);


if((ex20203 instanceof Error)){
var statearr_20209_20232 = state_20189__$1;
(statearr_20209_20232[(1)] = (4));

(statearr_20209_20232[(5)] = null);

} else {
throw ex20203;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20190 === (14))){
var inst_20176 = (state_20189[(2)]);
var state_20189__$1 = state_20189;
var statearr_20210_20233 = state_20189__$1;
(statearr_20210_20233[(2)] = inst_20176);

(statearr_20210_20233[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20190 === (10))){
var inst_20134 = (state_20189[(9)]);
var state_20189__$1 = state_20189;
var statearr_20211_20234 = state_20189__$1;
(statearr_20211_20234[(2)] = inst_20134);

(statearr_20211_20234[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20190 === (8))){
var inst_20184 = (state_20189[(2)]);
var _ = (function (){var statearr_20212 = state_20189;
(statearr_20212[(4)] = cljs.core.rest.call(null,(state_20189[(4)])));

return statearr_20212;
})();
var state_20189__$1 = state_20189;
var statearr_20213_20235 = state_20189__$1;
(statearr_20213_20235[(2)] = inst_20184);

(statearr_20213_20235[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_20214 = [null,null,null,null,null,null,null,null,null,null];
(statearr_20214[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__);

(statearr_20214[(1)] = (1));

return statearr_20214;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____1 = (function (state_20189){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20189);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20215){var ex__2749__auto__ = e20215;
var statearr_20216_20236 = state_20189;
(statearr_20216_20236[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20189[(4)]))){
var statearr_20217_20237 = state_20189;
(statearr_20217_20237[(1)] = cljs.core.first.call(null,(state_20189[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20238 = state_20189;
state_20189 = G__20238;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__ = function(state_20189){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____1.call(this,state_20189);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20218 = f__2769__auto__.call(null);
(statearr_20218[(6)] = c__2768__auto__);

return statearr_20218;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string.call(null,block);
if(cljs.core.int_QMARK_.call(null,block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(ledger_id){
return cljs.core.re_find.call(null,/[a-z]+/,ledger_id);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(ledger_id){
return cljs.core.re_find.call(null,/[A-Z0-9]+/,ledger_id);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__20240 = arguments.length;
switch (G__20240) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.call(null,db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20334){
var state_val_20335 = (state_20334[(1)]);
if((state_val_20335 === (7))){
var inst_20247 = (state_20334[(7)]);
var inst_20257 = clojure.string.starts_with_QMARK_.call(null,inst_20247,"$fdb");
var state_20334__$1 = state_20334;
if(inst_20257){
var statearr_20336_20385 = state_20334__$1;
(statearr_20336_20385[(1)] = (9));

} else {
var statearr_20337_20386 = state_20334__$1;
(statearr_20337_20386[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20335 === (20))){
var state_20334__$1 = state_20334;
var statearr_20338_20387 = state_20334__$1;
(statearr_20338_20387[(2)] = null);

(statearr_20338_20387[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20335 === (27))){
var inst_20297 = (state_20334[(8)]);
var state_20334__$1 = state_20334;
var statearr_20339_20388 = state_20334__$1;
(statearr_20339_20388[(2)] = inst_20297);

(statearr_20339_20388[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20335 === (1))){
var state_20334__$1 = state_20334;
var statearr_20340_20389 = state_20334__$1;
(statearr_20340_20389[(2)] = null);

(statearr_20340_20389[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20335 === (24))){
var inst_20320 = (state_20334[(2)]);
var state_20334__$1 = state_20334;
var statearr_20341_20390 = state_20334__$1;
(statearr_20341_20390[(2)] = inst_20320);

(statearr_20341_20390[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20335 === (4))){
var inst_20241 = (state_20334[(2)]);
var state_20334__$1 = state_20334;
var statearr_20342_20391 = state_20334__$1;
(statearr_20342_20391[(2)] = inst_20241);

(statearr_20342_20391[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20335 === (15))){
var inst_20264 = (state_20334[(9)]);
var inst_20270 = (state_20334[(2)]);
var inst_20271 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20272 = cljs.core.PersistentVector.EMPTY;
var inst_20273 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_20274 = cljs.core.into.call(null,inst_20272,inst_20273);
var inst_20275 = [inst_20264,inst_20274];
var inst_20276 = (new cljs.core.PersistentVector(null,2,(5),inst_20271,inst_20275,null));
var state_20334__$1 = (function (){var statearr_20343 = state_20334;
(statearr_20343[(10)] = inst_20270);

return statearr_20343;
})();
var statearr_20344_20392 = state_20334__$1;
(statearr_20344_20392[(2)] = inst_20276);

(statearr_20344_20392[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20335 === (21))){
var inst_20323 = (state_20334[(2)]);
var state_20334__$1 = state_20334;
var statearr_20345_20393 = state_20334__$1;
(statearr_20345_20393[(2)] = inst_20323);

(statearr_20345_20393[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20335 === (13))){
var inst_20264 = (state_20334[(9)]);
var inst_20267 = (function(){throw inst_20264})();
var state_20334__$1 = state_20334;
var statearr_20346_20394 = state_20334__$1;
(statearr_20346_20394[(2)] = inst_20267);

(statearr_20346_20394[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20335 === (22))){
var inst_20286 = (state_20334[(11)]);
var inst_20288 = (state_20334[(12)]);
var inst_20290 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_20286);
var inst_20291 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20292 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_20288];
var inst_20293 = (new cljs.core.PersistentVector(null,2,(5),inst_20291,inst_20292,null));
var inst_20294 = cljs.core.get_in.call(null,opts,inst_20293);
var state_20334__$1 = (function (){var statearr_20347 = state_20334;
(statearr_20347[(13)] = inst_20290);

return statearr_20347;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20334__$1,(25),inst_20294);
} else {
if((state_val_20335 === (29))){
var inst_20301 = (state_20334[(2)]);
var inst_20302 = fluree.db.util.async.throw_err.call(null,inst_20301);
var state_20334__$1 = state_20334;
var statearr_20348_20395 = state_20334__$1;
(statearr_20348_20395[(2)] = inst_20302);

(statearr_20348_20395[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20335 === (6))){
var inst_20250 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20251 = cljs.core.PersistentVector.EMPTY;
var inst_20252 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_20253 = cljs.core.into.call(null,inst_20251,inst_20252);
var inst_20254 = [db,inst_20253];
var inst_20255 = (new cljs.core.PersistentVector(null,2,(5),inst_20250,inst_20254,null));
var state_20334__$1 = state_20334;
var statearr_20349_20396 = state_20334__$1;
(statearr_20349_20396[(2)] = inst_20255);

(statearr_20349_20396[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20335 === (28))){
var inst_20305 = (state_20334[(2)]);
var inst_20306 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20307 = cljs.core.PersistentVector.EMPTY;
var inst_20308 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_20309 = cljs.core.into.call(null,inst_20307,inst_20308);
var inst_20310 = [inst_20305,inst_20309];
var inst_20311 = (new cljs.core.PersistentVector(null,2,(5),inst_20306,inst_20310,null));
var state_20334__$1 = state_20334;
var statearr_20350_20397 = state_20334__$1;
(statearr_20350_20397[(2)] = inst_20311);

(statearr_20350_20397[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20335 === (25))){
var inst_20290 = (state_20334[(13)]);
var inst_20296 = (state_20334[(2)]);
var inst_20297 = fluree.db.util.async.throw_err.call(null,inst_20296);
var state_20334__$1 = (function (){var statearr_20351 = state_20334;
(statearr_20351[(8)] = inst_20297);

return statearr_20351;
})();
if(cljs.core.truth_(inst_20290)){
var statearr_20352_20398 = state_20334__$1;
(statearr_20352_20398[(1)] = (26));

} else {
var statearr_20353_20399 = state_20334__$1;
(statearr_20353_20399[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20335 === (17))){
var state_20334__$1 = state_20334;
var statearr_20354_20400 = state_20334__$1;
(statearr_20354_20400[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20335 === (3))){
var inst_20332 = (state_20334[(2)]);
var state_20334__$1 = state_20334;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20334__$1,inst_20332);
} else {
if((state_val_20335 === (12))){
var inst_20264 = (state_20334[(9)]);
var inst_20263 = (state_20334[(2)]);
var inst_20264__$1 = fluree.db.util.async.throw_err.call(null,inst_20263);
var inst_20265 = fluree.db.util.core.exception_QMARK_.call(null,inst_20264__$1);
var state_20334__$1 = (function (){var statearr_20356 = state_20334;
(statearr_20356[(9)] = inst_20264__$1);

return statearr_20356;
})();
if(inst_20265){
var statearr_20357_20401 = state_20334__$1;
(statearr_20357_20401[(1)] = (13));

} else {
var statearr_20358_20402 = state_20334__$1;
(statearr_20358_20402[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20335 === (2))){
var inst_20247 = (state_20334[(7)]);
var _ = (function (){var statearr_20359 = state_20334;
(statearr_20359[(4)] = cljs.core.cons.call(null,(5),(state_20334[(4)])));

return statearr_20359;
})();
var inst_20247__$1 = cljs.core.first.call(null,clause);
var inst_20248 = cljs.core._EQ_.call(null,"$fdb",inst_20247__$1);
var state_20334__$1 = (function (){var statearr_20360 = state_20334;
(statearr_20360[(7)] = inst_20247__$1);

return statearr_20360;
})();
if(inst_20248){
var statearr_20361_20403 = state_20334__$1;
(statearr_20361_20403[(1)] = (6));

} else {
var statearr_20362_20404 = state_20334__$1;
(statearr_20362_20404[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20335 === (23))){
var inst_20247 = (state_20334[(7)]);
var inst_20313 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20247)," is not supported in Fluree"].join('');
var inst_20314 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20315 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20316 = cljs.core.PersistentHashMap.fromArrays(inst_20314,inst_20315);
var inst_20317 = cljs.core.ex_info.call(null,inst_20313,inst_20316);
var inst_20318 = (function(){throw inst_20317})();
var state_20334__$1 = state_20334;
var statearr_20363_20405 = state_20334__$1;
(statearr_20363_20405[(2)] = inst_20318);

(statearr_20363_20405[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20335 === (19))){
var inst_20247 = (state_20334[(7)]);
var inst_20288 = (state_20334[(12)]);
var inst_20285 = fluree.db.query.analytical.isolate_source_name.call(null,inst_20247);
var inst_20286 = fluree.db.query.analytical.isolate_source_block.call(null,inst_20247);
var inst_20287 = cljs.core.keyword.call(null,inst_20285);
var inst_20288__$1 = cljs.core.get.call(null,prefixes,inst_20287);
var state_20334__$1 = (function (){var statearr_20364 = state_20334;
(statearr_20364[(11)] = inst_20286);

(statearr_20364[(12)] = inst_20288__$1);

return statearr_20364;
})();
if(cljs.core.truth_(inst_20288__$1)){
var statearr_20365_20406 = state_20334__$1;
(statearr_20365_20406[(1)] = (22));

} else {
var statearr_20366_20407 = state_20334__$1;
(statearr_20366_20407[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20335 === (11))){
var inst_20327 = (state_20334[(2)]);
var state_20334__$1 = state_20334;
var statearr_20368_20408 = state_20334__$1;
(statearr_20368_20408[(2)] = inst_20327);

(statearr_20368_20408[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20335 === (9))){
var inst_20247 = (state_20334[(7)]);
var inst_20259 = cljs.core.subs.call(null,inst_20247,(4));
var inst_20260 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_20259);
var inst_20261 = fluree.db.time_travel.as_of_block.call(null,db,inst_20260);
var state_20334__$1 = state_20334;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20334__$1,(12),inst_20261);
} else {
if((state_val_20335 === (5))){
var _ = (function (){var statearr_20369 = state_20334;
(statearr_20369[(4)] = cljs.core.rest.call(null,(state_20334[(4)])));

return statearr_20369;
})();
var state_20334__$1 = state_20334;
var ex20367 = (state_20334__$1[(2)]);
var statearr_20370_20409 = state_20334__$1;
(statearr_20370_20409[(5)] = ex20367);


if((ex20367 instanceof Error)){
var statearr_20371_20410 = state_20334__$1;
(statearr_20371_20410[(1)] = (4));

(statearr_20371_20410[(5)] = null);

} else {
throw ex20367;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20335 === (14))){
var state_20334__$1 = state_20334;
var statearr_20372_20411 = state_20334__$1;
(statearr_20372_20411[(2)] = null);

(statearr_20372_20411[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20335 === (26))){
var inst_20297 = (state_20334[(8)]);
var inst_20290 = (state_20334[(13)]);
var inst_20299 = fluree.db.time_travel.as_of_block.call(null,inst_20297,inst_20290);
var state_20334__$1 = state_20334;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20334__$1,(29),inst_20299);
} else {
if((state_val_20335 === (16))){
var inst_20280 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20281 = ["$wd",clause];
var inst_20282 = (new cljs.core.PersistentVector(null,2,(5),inst_20280,inst_20281,null));
var state_20334__$1 = state_20334;
var statearr_20373_20412 = state_20334__$1;
(statearr_20373_20412[(2)] = inst_20282);

(statearr_20373_20412[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20335 === (10))){
var inst_20247 = (state_20334[(7)]);
var inst_20278 = cljs.core._EQ_.call(null,"$wd",inst_20247);
var state_20334__$1 = state_20334;
if(inst_20278){
var statearr_20374_20413 = state_20334__$1;
(statearr_20374_20413[(1)] = (16));

} else {
var statearr_20375_20414 = state_20334__$1;
(statearr_20375_20414[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20335 === (18))){
var inst_20325 = (state_20334[(2)]);
var state_20334__$1 = state_20334;
var statearr_20376_20415 = state_20334__$1;
(statearr_20376_20415[(2)] = inst_20325);

(statearr_20376_20415[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20335 === (8))){
var inst_20329 = (state_20334[(2)]);
var _ = (function (){var statearr_20377 = state_20334;
(statearr_20377[(4)] = cljs.core.rest.call(null,(state_20334[(4)])));

return statearr_20377;
})();
var state_20334__$1 = state_20334;
var statearr_20378_20416 = state_20334__$1;
(statearr_20378_20416[(2)] = inst_20329);

(statearr_20378_20416[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2746__auto__ = null;
var fluree$db$query$analytical$state_machine__2746__auto____0 = (function (){
var statearr_20379 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20379[(0)] = fluree$db$query$analytical$state_machine__2746__auto__);

(statearr_20379[(1)] = (1));

return statearr_20379;
});
var fluree$db$query$analytical$state_machine__2746__auto____1 = (function (state_20334){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20334);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20380){var ex__2749__auto__ = e20380;
var statearr_20381_20417 = state_20334;
(statearr_20381_20417[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20334[(4)]))){
var statearr_20382_20418 = state_20334;
(statearr_20382_20418[(1)] = cljs.core.first.call(null,(state_20334[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20419 = state_20334;
state_20334 = G__20419;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2746__auto__ = function(state_20334){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2746__auto____1.call(this,state_20334);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2746__auto____0;
fluree$db$query$analytical$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2746__auto____1;
return fluree$db$query$analytical$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20383 = f__2769__auto__.call(null);
(statearr_20383[(6)] = c__2768__auto__);

return statearr_20383;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.call(null,(function (acc,p__20420){
var vec__20421 = p__20420;
var sub = cljs.core.nth.call(null,vec__20421,(0),null);
var obj = cljs.core.nth.call(null,vec__20421,(1),null);
return cljs.core.update.call(null,acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap.call(null,cljs.core.keys.call(null,tuple_map),cljs.core.map.call(null,(function (p1__20424_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set.call(null,p1__20424_SHARP_)]);
}),cljs.core.vals.call(null,tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map.call(null,tuple_map);
var G__20428 = subjects;
var vec__20429 = G__20428;
var seq__20430 = cljs.core.seq.call(null,vec__20429);
var first__20431 = cljs.core.first.call(null,seq__20430);
var seq__20430__$1 = cljs.core.next.call(null,seq__20430);
var subject = first__20431;
var r = seq__20430__$1;
var acc = expanded_map;
var G__20428__$1 = G__20428;
var acc__$1 = acc;
while(true){
var vec__20435 = G__20428__$1;
var seq__20436 = cljs.core.seq.call(null,vec__20435);
var first__20437 = cljs.core.first.call(null,seq__20436);
var seq__20436__$1 = cljs.core.next.call(null,seq__20436);
var subject__$1 = first__20437;
var r__$1 = seq__20436__$1;
var acc__$2 = acc__$1;
if(cljs.core.not.call(null,subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__20438 = r__$1;
var G__20439 = acc__$2;
G__20428__$1 = G__20438;
acc__$1 = G__20439;
continue;
} else {
var subject_all = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.call(null,subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.call(null,((function (G__20428__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__20435,seq__20436,first__20437,seq__20436__$1,subject__$1,r__$1,acc__$2,G__20428,vec__20429,seq__20430,first__20431,seq__20430__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.call(null,subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:all_followed.call(null,subject_to_follow));
var acc_SINGLEQUOTE_ = cljs.core.update_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__5045__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__20428__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20435,seq__20436,first__20437,seq__20436__$1,subject__$1,r__$1,acc__$2,G__20428,vec__20429,seq__20430,first__20431,seq__20430__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__20428__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20435,seq__20436,first__20437,seq__20436__$1,subject__$1,r__$1,acc__$2,G__20428,vec__20429,seq__20430,first__20431,seq__20430__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__20428__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20435,seq__20436,first__20437,seq__20436__$1,subject__$1,r__$1,acc__$2,G__20428,vec__20429,seq__20430,first__20431,seq__20430__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__20428__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20435,seq__20436,first__20437,seq__20436__$1,subject__$1,r__$1,acc__$2,G__20428,vec__20429,seq__20430,first__20431,seq__20430__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__20428__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__20435,seq__20436,first__20437,seq__20436__$1,subject__$1,r__$1,acc__$2,G__20428,vec__20429,seq__20430,first__20431,seq__20430__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.call(null,subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__20440 = r__$1;
var G__20441 = cljs.core.assoc_in.call(null,acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__20428__$1 = G__20440;
acc__$1 = G__20441;
continue;
} else {
var G__20442 = subjects;
var G__20443 = acc_STAR_;
G__20428__$1 = G__20442;
acc__$1 = G__20443;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.call(null,(function (acc,subject){
var subject_vals = cljs.core.get_in.call(null,recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.call(null,acc,cljs.core.map.call(null,(function (p1__20444_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__20444_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20535){
var state_val_20536 = (state_20535[(1)]);
if((state_val_20536 === (7))){
var state_20535__$1 = state_20535;
var statearr_20537_20583 = state_20535__$1;
(statearr_20537_20583[(2)] = (100));

(statearr_20537_20583[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20536 === (20))){
var inst_20484 = (state_20535[(7)]);
var state_20535__$1 = state_20535;
var statearr_20538_20584 = state_20535__$1;
(statearr_20538_20584[(2)] = inst_20484);

(statearr_20538_20584[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20536 === (1))){
var state_20535__$1 = state_20535;
var statearr_20539_20585 = state_20535__$1;
(statearr_20539_20585[(2)] = null);

(statearr_20539_20585[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20536 === (24))){
var inst_20523 = (state_20535[(8)]);
var inst_20522 = (state_20535[(9)]);
var inst_20521 = (state_20535[(10)]);
var inst_20456 = (state_20535[(11)]);
var inst_20526 = (function (){var max_depth = inst_20456;
var recur_map__$1 = inst_20522;
var subjects = inst_20521;
var tuples = inst_20523;
return (function (p1__20445_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second.call(null,p1__20445_SHARP_)],null));
});
})();
var inst_20527 = cljs.core.map.call(null,inst_20526,inst_20523);
var inst_20528 = cljs.core.distinct.call(null,inst_20527);
var state_20535__$1 = state_20535;
var statearr_20540_20586 = state_20535__$1;
(statearr_20540_20586[(2)] = inst_20528);

(statearr_20540_20586[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20536 === (4))){
var inst_20446 = (state_20535[(2)]);
var state_20535__$1 = state_20535;
var statearr_20541_20587 = state_20535__$1;
(statearr_20541_20587[(2)] = inst_20446);

(statearr_20541_20587[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20536 === (15))){
var inst_20469 = (state_20535[(12)]);
var inst_20480 = cljs.core.PersistentVector.EMPTY;
var inst_20481 = cljs.core.seq.call(null,inst_20469);
var inst_20482 = cljs.core.first.call(null,inst_20481);
var inst_20483 = cljs.core.next.call(null,inst_20481);
var inst_20484 = inst_20480;
var inst_20485 = inst_20469;
var state_20535__$1 = (function (){var statearr_20542 = state_20535;
(statearr_20542[(13)] = inst_20485);

(statearr_20542[(14)] = inst_20483);

(statearr_20542[(15)] = inst_20482);

(statearr_20542[(7)] = inst_20484);

return statearr_20542;
})();
var statearr_20543_20588 = state_20535__$1;
(statearr_20543_20588[(2)] = null);

(statearr_20543_20588[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20536 === (21))){
var inst_20505 = (state_20535[(2)]);
var state_20535__$1 = state_20535;
var statearr_20544_20589 = state_20535__$1;
(statearr_20544_20589[(2)] = inst_20505);

(statearr_20544_20589[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20536 === (13))){
var inst_20518 = (state_20535[(2)]);
var state_20535__$1 = state_20535;
var statearr_20545_20590 = state_20535__$1;
(statearr_20545_20590[(2)] = inst_20518);

(statearr_20545_20590[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20536 === (22))){
var inst_20492 = (state_20535[(16)]);
var inst_20484 = (state_20535[(7)]);
var inst_20499 = (state_20535[(2)]);
var inst_20500 = fluree.db.util.async.throw_err.call(null,inst_20499);
var inst_20501 = cljs.core.concat.call(null,inst_20484,inst_20500);
var inst_20484__$1 = inst_20501;
var inst_20485 = inst_20492;
var state_20535__$1 = (function (){var statearr_20546 = state_20535;
(statearr_20546[(13)] = inst_20485);

(statearr_20546[(7)] = inst_20484__$1);

return statearr_20546;
})();
var statearr_20547_20591 = state_20535__$1;
(statearr_20547_20591[(2)] = null);

(statearr_20547_20591[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20536 === (6))){
var inst_20452 = (state_20535[(17)]);
var state_20535__$1 = state_20535;
var statearr_20548_20592 = state_20535__$1;
(statearr_20548_20592[(2)] = inst_20452);

(statearr_20548_20592[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20536 === (25))){
var inst_20530 = (state_20535[(2)]);
var _ = (function (){var statearr_20549 = state_20535;
(statearr_20549[(4)] = cljs.core.rest.call(null,(state_20535[(4)])));

return statearr_20549;
})();
var state_20535__$1 = state_20535;
var statearr_20550_20593 = state_20535__$1;
(statearr_20550_20593[(2)] = inst_20530);

(statearr_20550_20593[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20536 === (17))){
var inst_20485 = (state_20535[(13)]);
var inst_20491 = (state_20535[(18)]);
var inst_20490 = cljs.core.seq.call(null,inst_20485);
var inst_20491__$1 = cljs.core.first.call(null,inst_20490);
var inst_20492 = cljs.core.next.call(null,inst_20490);
var state_20535__$1 = (function (){var statearr_20551 = state_20535;
(statearr_20551[(16)] = inst_20492);

(statearr_20551[(18)] = inst_20491__$1);

return statearr_20551;
})();
if(cljs.core.truth_(inst_20491__$1)){
var statearr_20552_20594 = state_20535__$1;
(statearr_20552_20594[(1)] = (19));

} else {
var statearr_20553_20595 = state_20535__$1;
(statearr_20553_20595[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20536 === (3))){
var inst_20533 = (state_20535[(2)]);
var state_20535__$1 = state_20535;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20535__$1,inst_20533);
} else {
if((state_val_20536 === (12))){
var inst_20458 = (state_20535[(19)]);
var inst_20469 = (state_20535[(12)]);
var inst_20464 = cljs.core.vals.call(null,inst_20458);
var inst_20465 = cljs.core.flatten.call(null,inst_20464);
var inst_20466 = cljs.core.set.call(null,inst_20465);
var inst_20467 = cljs.core.keys.call(null,inst_20458);
var inst_20468 = cljs.core.set.call(null,inst_20467);
var inst_20469__$1 = clojure.set.difference.call(null,inst_20466,inst_20468);
var inst_20470 = cljs.core.empty_QMARK_.call(null,inst_20469__$1);
var state_20535__$1 = (function (){var statearr_20554 = state_20535;
(statearr_20554[(12)] = inst_20469__$1);

return statearr_20554;
})();
if(inst_20470){
var statearr_20555_20596 = state_20535__$1;
(statearr_20555_20596[(1)] = (14));

} else {
var statearr_20556_20597 = state_20535__$1;
(statearr_20556_20597[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20536 === (2))){
var inst_20452 = (state_20535[(17)]);
var _ = (function (){var statearr_20557 = state_20535;
(statearr_20557[(4)] = cljs.core.cons.call(null,(5),(state_20535[(4)])));

return statearr_20557;
})();
var inst_20452__$1 = depth;
var state_20535__$1 = (function (){var statearr_20558 = state_20535;
(statearr_20558[(17)] = inst_20452__$1);

return statearr_20558;
})();
if(cljs.core.truth_(inst_20452__$1)){
var statearr_20559_20598 = state_20535__$1;
(statearr_20559_20598[(1)] = (6));

} else {
var statearr_20560_20599 = state_20535__$1;
(statearr_20560_20599[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20536 === (23))){
var inst_20523 = (state_20535[(8)]);
var state_20535__$1 = state_20535;
var statearr_20561_20600 = state_20535__$1;
(statearr_20561_20600[(2)] = inst_20523);

(statearr_20561_20600[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20536 === (19))){
var inst_20491 = (state_20535[(18)]);
var inst_20494 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20495 = [inst_20491,predicate];
var inst_20496 = (new cljs.core.PersistentVector(null,2,(5),inst_20494,inst_20495,null));
var inst_20497 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_20496);
var state_20535__$1 = state_20535;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20535__$1,(22),inst_20497);
} else {
if((state_val_20536 === (11))){
var inst_20458 = (state_20535[(19)]);
var state_20535__$1 = state_20535;
var statearr_20563_20601 = state_20535__$1;
(statearr_20563_20601[(2)] = inst_20458);

(statearr_20563_20601[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20536 === (9))){
var inst_20459 = (state_20535[(20)]);
var inst_20456 = (state_20535[(11)]);
var inst_20461 = (inst_20459 >= inst_20456);
var state_20535__$1 = state_20535;
if(cljs.core.truth_(inst_20461)){
var statearr_20564_20602 = state_20535__$1;
(statearr_20564_20602[(1)] = (11));

} else {
var statearr_20565_20603 = state_20535__$1;
(statearr_20565_20603[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20536 === (5))){
var _ = (function (){var statearr_20566 = state_20535;
(statearr_20566[(4)] = cljs.core.rest.call(null,(state_20535[(4)])));

return statearr_20566;
})();
var state_20535__$1 = state_20535;
var ex20562 = (state_20535__$1[(2)]);
var statearr_20567_20604 = state_20535__$1;
(statearr_20567_20604[(5)] = ex20562);


if((ex20562 instanceof Error)){
var statearr_20568_20605 = state_20535__$1;
(statearr_20568_20605[(1)] = (4));

(statearr_20568_20605[(5)] = null);

} else {
throw ex20562;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20536 === (14))){
var inst_20458 = (state_20535[(19)]);
var state_20535__$1 = state_20535;
var statearr_20569_20606 = state_20535__$1;
(statearr_20569_20606[(2)] = inst_20458);

(statearr_20569_20606[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20536 === (16))){
var inst_20516 = (state_20535[(2)]);
var state_20535__$1 = state_20535;
var statearr_20570_20607 = state_20535__$1;
(statearr_20570_20607[(2)] = inst_20516);

(statearr_20570_20607[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20536 === (10))){
var inst_20522 = (state_20535[(9)]);
var inst_20521 = (state_20535[(10)]);
var inst_20520 = (state_20535[(2)]);
var inst_20521__$1 = cljs.core.keys.call(null,inst_20520);
var inst_20522__$1 = fluree.db.query.analytical.follow_all_original_subject_paths.call(null,inst_20521__$1,inst_20520);
var inst_20523 = fluree.db.query.analytical.recur_map__GT_tuples.call(null,inst_20521__$1,inst_20522__$1);
var state_20535__$1 = (function (){var statearr_20571 = state_20535;
(statearr_20571[(8)] = inst_20523);

(statearr_20571[(9)] = inst_20522__$1);

(statearr_20571[(10)] = inst_20521__$1);

return statearr_20571;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_20572_20608 = state_20535__$1;
(statearr_20572_20608[(1)] = (23));

} else {
var statearr_20573_20609 = state_20535__$1;
(statearr_20573_20609[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20536 === (18))){
var inst_20459 = (state_20535[(20)]);
var inst_20458 = (state_20535[(19)]);
var inst_20507 = (state_20535[(2)]);
var inst_20508 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20509 = [(0),(2)];
var inst_20510 = (new cljs.core.PersistentVector(null,2,(5),inst_20508,inst_20509,null));
var inst_20511 = fluree.db.query.analytical.transform_tuples_to_idxs.call(null,inst_20510,inst_20507);
var inst_20512 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_20458,inst_20511);
var inst_20513 = (inst_20459 + (1));
var inst_20458__$1 = inst_20512;
var inst_20459__$1 = inst_20513;
var state_20535__$1 = (function (){var statearr_20574 = state_20535;
(statearr_20574[(20)] = inst_20459__$1);

(statearr_20574[(19)] = inst_20458__$1);

return statearr_20574;
})();
var statearr_20575_20610 = state_20535__$1;
(statearr_20575_20610[(2)] = null);

(statearr_20575_20610[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20536 === (8))){
var inst_20456 = (state_20535[(2)]);
var inst_20457 = recur_map;
var inst_20458 = inst_20457;
var inst_20459 = (1);
var state_20535__$1 = (function (){var statearr_20576 = state_20535;
(statearr_20576[(20)] = inst_20459);

(statearr_20576[(11)] = inst_20456);

(statearr_20576[(19)] = inst_20458);

return statearr_20576;
})();
var statearr_20577_20611 = state_20535__$1;
(statearr_20577_20611[(2)] = null);

(statearr_20577_20611[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____0 = (function (){
var statearr_20578 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20578[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__);

(statearr_20578[(1)] = (1));

return statearr_20578;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____1 = (function (state_20535){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20535);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20579){var ex__2749__auto__ = e20579;
var statearr_20580_20612 = state_20535;
(statearr_20580_20612[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20535[(4)]))){
var statearr_20581_20613 = state_20535;
(statearr_20581_20613[(1)] = cljs.core.first.call(null,(state_20535[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20614 = state_20535;
state_20535 = G__20614;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__ = function(state_20535){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____1.call(this,state_20535);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20582 = f__2769__auto__.call(null);
(statearr_20582[(6)] = c__2768__auto__);

return statearr_20582;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__20615,clause,fuel,max_fuel){
var map__20616 = p__20615;
var map__20616__$1 = cljs.core.__destructure_map.call(null,map__20616);
var res = map__20616__$1;
var headers = cljs.core.get.call(null,map__20616__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__20616__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.call(null,map__20616__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20727){
var state_val_20728 = (state_20727[(1)]);
if((state_val_20728 === (7))){
var inst_20633 = (state_20727[(7)]);
var state_20727__$1 = state_20727;
var statearr_20729_20782 = state_20727__$1;
(statearr_20729_20782[(2)] = inst_20633);

(statearr_20729_20782[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20728 === (20))){
var inst_20661 = (state_20727[(8)]);
var inst_20692 = typeof inst_20661 === 'number';
var state_20727__$1 = state_20727;
if(cljs.core.truth_(inst_20692)){
var statearr_20730_20783 = state_20727__$1;
(statearr_20730_20783[(1)] = (22));

} else {
var statearr_20731_20784 = state_20727__$1;
(statearr_20731_20784[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20728 === (27))){
var inst_20707 = (state_20727[(2)]);
var state_20727__$1 = state_20727;
var statearr_20732_20785 = state_20727__$1;
(statearr_20732_20785[(2)] = inst_20707);

(statearr_20732_20785[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20728 === (1))){
var state_20727__$1 = state_20727;
var statearr_20733_20786 = state_20727__$1;
(statearr_20733_20786[(2)] = null);

(statearr_20733_20786[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20728 === (24))){
var inst_20709 = (state_20727[(2)]);
var state_20727__$1 = state_20727;
var statearr_20734_20787 = state_20727__$1;
(statearr_20734_20787[(2)] = inst_20709);

(statearr_20734_20787[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20728 === (4))){
var inst_20617 = (state_20727[(2)]);
var state_20727__$1 = state_20727;
var statearr_20735_20788 = state_20727__$1;
(statearr_20735_20788[(2)] = inst_20617);

(statearr_20735_20788[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20728 === (15))){
var inst_20675 = (state_20727[(2)]);
var inst_20676 = cljs.core.nth.call(null,clause,(2));
var inst_20677 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_20676);
var state_20727__$1 = (function (){var statearr_20736 = state_20727;
(statearr_20736[(9)] = inst_20675);

return statearr_20736;
})();
if(cljs.core.truth_(inst_20677)){
var statearr_20737_20789 = state_20727__$1;
(statearr_20737_20789[(1)] = (16));

} else {
var statearr_20738_20790 = state_20727__$1;
(statearr_20738_20790[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20728 === (21))){
var inst_20634 = (state_20727[(10)]);
var inst_20664 = (state_20727[(11)]);
var inst_20663 = (state_20727[(12)]);
var inst_20711 = (state_20727[(2)]);
var inst_20712 = fluree.db.query.analytical.tuples__GT_recur.call(null,db,inst_20664,inst_20711,inst_20634,inst_20663);
var state_20727__$1 = state_20727;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20727__$1,(28),inst_20712);
} else {
if((state_val_20728 === (13))){
var inst_20643 = (state_20727[(13)]);
var inst_20667 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20643)].join('');
var inst_20668 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20669 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20670 = cljs.core.PersistentHashMap.fromArrays(inst_20668,inst_20669);
var inst_20671 = cljs.core.ex_info.call(null,inst_20667,inst_20670);
var inst_20672 = (function(){throw inst_20671})();
var state_20727__$1 = state_20727;
var statearr_20739_20791 = state_20727__$1;
(statearr_20739_20791[(2)] = inst_20672);

(statearr_20739_20791[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20728 === (22))){
var inst_20659 = (state_20727[(14)]);
var inst_20661 = (state_20727[(8)]);
var inst_20694 = cljs.core.PersistentHashMap.EMPTY;
var inst_20695 = cljs.core.flatten.call(null,inst_20659);
var inst_20696 = cljs.core.assoc.call(null,inst_20694,inst_20661,inst_20695);
var state_20727__$1 = state_20727;
var statearr_20740_20792 = state_20727__$1;
(statearr_20740_20792[(2)] = inst_20696);

(statearr_20740_20792[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20728 === (6))){
var inst_20645 = (state_20727[(15)]);
var state_20727__$1 = state_20727;
var statearr_20741_20793 = state_20727__$1;
(statearr_20741_20793[(2)] = inst_20645);

(statearr_20741_20793[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20728 === (28))){
var inst_20714 = (state_20727[(2)]);
var inst_20715 = fluree.db.util.async.throw_err.call(null,inst_20714);
var state_20727__$1 = state_20727;
var statearr_20742_20794 = state_20727__$1;
(statearr_20742_20794[(2)] = inst_20715);

(statearr_20742_20794[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20728 === (25))){
var inst_20659 = (state_20727[(14)]);
var inst_20655 = (state_20727[(16)]);
var inst_20700 = cljs.core.PersistentHashMap.EMPTY;
var inst_20701 = cljs.core.first.call(null,inst_20655);
var inst_20702 = cljs.core.first.call(null,inst_20701);
var inst_20703 = cljs.core.flatten.call(null,inst_20659);
var inst_20704 = cljs.core.assoc.call(null,inst_20700,inst_20702,inst_20703);
var state_20727__$1 = state_20727;
var statearr_20743_20795 = state_20727__$1;
(statearr_20743_20795[(2)] = inst_20704);

(statearr_20743_20795[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20728 === (17))){
var inst_20643 = (state_20727[(13)]);
var inst_20680 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20643)].join('');
var inst_20681 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20682 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20683 = cljs.core.PersistentHashMap.fromArrays(inst_20681,inst_20682);
var inst_20684 = cljs.core.ex_info.call(null,inst_20680,inst_20683);
var inst_20685 = (function(){throw inst_20684})();
var state_20727__$1 = state_20727;
var statearr_20744_20796 = state_20727__$1;
(statearr_20744_20796[(2)] = inst_20685);

(statearr_20744_20796[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20728 === (3))){
var inst_20725 = (state_20727[(2)]);
var state_20727__$1 = state_20727;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20727__$1,inst_20725);
} else {
if((state_val_20728 === (12))){
var inst_20630 = (state_20727[(17)]);
var inst_20718 = (state_20727[(2)]);
var inst_20719 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_20720 = cljs.core.keys.call(null,inst_20630);
var inst_20721 = [inst_20720,vars,inst_20718];
var inst_20722 = cljs.core.PersistentHashMap.fromArrays(inst_20719,inst_20721);
var _ = (function (){var statearr_20745 = state_20727;
(statearr_20745[(4)] = cljs.core.rest.call(null,(state_20727[(4)])));

return statearr_20745;
})();
var state_20727__$1 = state_20727;
var statearr_20746_20797 = state_20727__$1;
(statearr_20746_20797[(2)] = inst_20722);

(statearr_20746_20797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20728 === (2))){
var inst_20645 = (state_20727[(15)]);
var inst_20634 = (state_20727[(10)]);
var inst_20633 = (state_20727[(7)]);
var inst_20630 = (state_20727[(17)]);
var _ = (function (){var statearr_20747 = state_20727;
(statearr_20747[(4)] = cljs.core.cons.call(null,(5),(state_20727[(4)])));

return statearr_20747;
})();
var inst_20627 = fluree.db.query.analytical.clause__GT_rel.call(null,db,vars,clause);
var inst_20628 = cljs.core.__destructure_map.call(null,inst_20627);
var inst_20629 = cljs.core.get.call(null,inst_20628,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_20630__$1 = cljs.core.get.call(null,inst_20628,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_20631 = cljs.core.get.call(null,inst_20628,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_20632 = fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,clause);
var inst_20633__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_20631);
var inst_20634__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_20631);
var inst_20636 = (function (){var map__20623 = inst_20628;
var search = inst_20629;
var rel = inst_20630__$1;
var opts = inst_20631;
var common_keys = inst_20632;
var object_fn = inst_20633__$1;
var recur_depth = inst_20634__$1;
return (function (p__20635,common_key){
var vec__20748 = p__20635;
var acc = cljs.core.nth.call(null,vec__20748,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__20748,(1),null);
var idx_of = fluree.db.util.core.index_of.call(null,clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__20751 = cljs.core._EQ_;
var expr__20752 = idx_of;
if(cljs.core.truth_(pred__20751.call(null,(0),expr__20752))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_(pred__20751.call(null,(1),expr__20752))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_(pred__20751.call(null,(2),expr__20752))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__20752)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of.call(null,headers,common_key);
var v = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,cljs.core.first,fluree.db.query.analytical.transform_tuples_to_idxs.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,v));
var v__$1 = (cljs.core.truth_((function (){var and__5043__auto__ = (!(single_v_QMARK_));
if(and__5043__auto__){
var and__5043__auto____$1 = object_fn;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.call(null,k,object_fn);
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())?cljs.core.comp.call(null,v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.call(null,clause_SINGLEQUOTE_,idx_of,cljs.core.first.call(null,v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_20637 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20638 = cljs.core.PersistentHashMap.EMPTY;
var inst_20639 = [inst_20638,inst_20629];
var inst_20640 = (new cljs.core.PersistentVector(null,2,(5),inst_20637,inst_20639,null));
var inst_20641 = cljs.core.reduce.call(null,inst_20636,inst_20640,inst_20632);
var inst_20642 = cljs.core.nth.call(null,inst_20641,(0),null);
var inst_20643 = cljs.core.nth.call(null,inst_20641,(1),null);
var inst_20644 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_20645__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_20642);
var state_20727__$1 = (function (){var statearr_20754 = state_20727;
(statearr_20754[(15)] = inst_20645__$1);

(statearr_20754[(10)] = inst_20634__$1);

(statearr_20754[(13)] = inst_20643);

(statearr_20754[(7)] = inst_20633__$1);

(statearr_20754[(17)] = inst_20630__$1);

(statearr_20754[(18)] = inst_20644);

return statearr_20754;
})();
if(cljs.core.truth_(inst_20645__$1)){
var statearr_20755_20798 = state_20727__$1;
(statearr_20755_20798[(1)] = (6));

} else {
var statearr_20756_20799 = state_20727__$1;
(statearr_20756_20799[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20728 === (23))){
var inst_20661 = (state_20727[(8)]);
var inst_20698 = cljs.core.coll_QMARK_.call(null,inst_20661);
var state_20727__$1 = state_20727;
if(inst_20698){
var statearr_20757_20800 = state_20727__$1;
(statearr_20757_20800[(1)] = (25));

} else {
var statearr_20758_20801 = state_20727__$1;
(statearr_20758_20801[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20728 === (19))){
var inst_20659 = (state_20727[(14)]);
var inst_20689 = cljs.core.PersistentHashMap.EMPTY;
var inst_20690 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_20689,inst_20659);
var state_20727__$1 = state_20727;
var statearr_20759_20802 = state_20727__$1;
(statearr_20759_20802[(2)] = inst_20690);

(statearr_20759_20802[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20728 === (11))){
var inst_20659 = (state_20727[(14)]);
var state_20727__$1 = state_20727;
var statearr_20761_20803 = state_20727__$1;
(statearr_20761_20803[(2)] = inst_20659);

(statearr_20761_20803[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20728 === (9))){
var inst_20634 = (state_20727[(10)]);
var inst_20655 = (state_20727[(16)]);
var inst_20630 = (state_20727[(17)]);
var inst_20654 = (state_20727[(2)]);
var inst_20655__$1 = fluree.db.util.async.throw_err.call(null,inst_20654);
var inst_20656 = cljs.core.count.call(null,inst_20655__$1);
var inst_20657 = fluree.db.query.analytical.add_fuel.call(null,inst_20656,fuel,max_fuel);
var inst_20658 = cljs.core.vals.call(null,inst_20630);
var inst_20659 = fluree.db.query.analytical.transform_tuples_to_idxs.call(null,inst_20658,inst_20655__$1);
var state_20727__$1 = (function (){var statearr_20762 = state_20727;
(statearr_20762[(14)] = inst_20659);

(statearr_20762[(19)] = inst_20657);

(statearr_20762[(16)] = inst_20655__$1);

return statearr_20762;
})();
if(cljs.core.truth_(inst_20634)){
var statearr_20763_20804 = state_20727__$1;
(statearr_20763_20804[(1)] = (10));

} else {
var statearr_20764_20805 = state_20727__$1;
(statearr_20764_20805[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20728 === (5))){
var _ = (function (){var statearr_20765 = state_20727;
(statearr_20765[(4)] = cljs.core.rest.call(null,(state_20727[(4)])));

return statearr_20765;
})();
var state_20727__$1 = state_20727;
var ex20760 = (state_20727__$1[(2)]);
var statearr_20766_20806 = state_20727__$1;
(statearr_20766_20806[(5)] = ex20760);


if((ex20760 instanceof Error)){
var statearr_20767_20807 = state_20727__$1;
(statearr_20767_20807[(1)] = (4));

(statearr_20767_20807[(5)] = null);

} else {
throw ex20760;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20728 === (14))){
var state_20727__$1 = state_20727;
var statearr_20768_20808 = state_20727__$1;
(statearr_20768_20808[(2)] = null);

(statearr_20768_20808[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20728 === (26))){
var state_20727__$1 = state_20727;
var statearr_20769_20809 = state_20727__$1;
(statearr_20769_20809[(2)] = null);

(statearr_20769_20809[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20728 === (16))){
var state_20727__$1 = state_20727;
var statearr_20770_20810 = state_20727__$1;
(statearr_20770_20810[(2)] = null);

(statearr_20770_20810[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20728 === (10))){
var inst_20643 = (state_20727[(13)]);
var inst_20664 = (state_20727[(11)]);
var inst_20661 = cljs.core.first.call(null,inst_20643);
var inst_20662 = cljs.core.first.call(null,clause);
var inst_20663 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_20662);
var inst_20664__$1 = cljs.core.nth.call(null,inst_20643,(1));
var inst_20665 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_20664__$1);
var state_20727__$1 = (function (){var statearr_20771 = state_20727;
(statearr_20771[(11)] = inst_20664__$1);

(statearr_20771[(8)] = inst_20661);

(statearr_20771[(12)] = inst_20663);

return statearr_20771;
})();
if(cljs.core.truth_(inst_20665)){
var statearr_20772_20811 = state_20727__$1;
(statearr_20772_20811[(1)] = (13));

} else {
var statearr_20773_20812 = state_20727__$1;
(statearr_20773_20812[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20728 === (18))){
var inst_20663 = (state_20727[(12)]);
var inst_20687 = (state_20727[(2)]);
var state_20727__$1 = (function (){var statearr_20774 = state_20727;
(statearr_20774[(20)] = inst_20687);

return statearr_20774;
})();
if(cljs.core.truth_(inst_20663)){
var statearr_20775_20813 = state_20727__$1;
(statearr_20775_20813[(1)] = (19));

} else {
var statearr_20776_20814 = state_20727__$1;
(statearr_20776_20814[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20728 === (8))){
var inst_20643 = (state_20727[(13)]);
var inst_20644 = (state_20727[(18)]);
var inst_20649 = (state_20727[(2)]);
var inst_20650 = [inst_20649];
var inst_20651 = cljs.core.PersistentHashMap.fromArrays(inst_20644,inst_20650);
var inst_20652 = fluree.db.query.range.search.call(null,db,inst_20643,inst_20651);
var state_20727__$1 = state_20727;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20727__$1,(9),inst_20652);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_20777 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20777[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__);

(statearr_20777[(1)] = (1));

return statearr_20777;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____1 = (function (state_20727){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20727);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20778){var ex__2749__auto__ = e20778;
var statearr_20779_20815 = state_20727;
(statearr_20779_20815[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20727[(4)]))){
var statearr_20780_20816 = state_20727;
(statearr_20780_20816[(1)] = cljs.core.first.call(null,(state_20727[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20817 = state_20727;
state_20727 = G__20817;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__ = function(state_20727){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____1.call(this,state_20727);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20781 = f__2769__auto__.call(null);
(statearr_20781[(6)] = c__2768__auto__);

return statearr_20781;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__20818,res,clause){
var map__20819 = p__20818;
var map__20819__$1 = cljs.core.__destructure_map.call(null,map__20819);
var db = map__20819__$1;
var conn = cljs.core.get.call(null,map__20819__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__20819__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__20819__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
throw cljs.core.ex_info.call(null,"Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20928){
var state_val_20929 = (state_20928[(1)]);
if((state_val_20929 === (7))){
var inst_20828 = (state_20928[(7)]);
var state_20928__$1 = state_20928;
var statearr_20930_20971 = state_20928__$1;
(statearr_20930_20971[(2)] = inst_20828);

(statearr_20930_20971[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20929 === (20))){
var state_20928__$1 = state_20928;
var statearr_20931_20972 = state_20928__$1;
(statearr_20931_20972[(2)] = null);

(statearr_20931_20972[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20929 === (1))){
var state_20928__$1 = state_20928;
var statearr_20932_20973 = state_20928__$1;
(statearr_20932_20973[(2)] = null);

(statearr_20932_20973[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20929 === (24))){
var inst_20830 = (state_20928[(8)]);
var inst_20901 = (state_20928[(2)]);
var inst_20902 = fluree.db.flake.sid__GT_cid.call(null,inst_20901);
var inst_20903 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_20902);
var inst_20904 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20905 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20906 = [inst_20830];
var inst_20907 = (new cljs.core.PersistentVector(null,1,(5),inst_20905,inst_20906,null));
var inst_20908 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20909 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20910 = [inst_20903];
var inst_20911 = (new cljs.core.PersistentVector(null,1,(5),inst_20909,inst_20910,null));
var inst_20912 = [inst_20911];
var inst_20913 = (new cljs.core.PersistentVector(null,1,(5),inst_20908,inst_20912,null));
var inst_20914 = cljs.core.PersistentHashMap.EMPTY;
var inst_20915 = [inst_20907,inst_20913,inst_20914];
var inst_20916 = cljs.core.PersistentHashMap.fromArrays(inst_20904,inst_20915);
var state_20928__$1 = state_20928;
var statearr_20933_20974 = state_20928__$1;
(statearr_20933_20974[(2)] = inst_20916);

(statearr_20933_20974[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20929 === (4))){
var inst_20821 = (state_20928[(2)]);
var state_20928__$1 = state_20928;
var statearr_20934_20975 = state_20928__$1;
(statearr_20934_20975[(2)] = inst_20821);

(statearr_20934_20975[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20929 === (15))){
var inst_20828 = (state_20928[(7)]);
var inst_20830 = (state_20928[(8)]);
var inst_20849 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_20850 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20851 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20852 = [inst_20828];
var inst_20853 = (new cljs.core.PersistentVector(null,1,(5),inst_20851,inst_20852,null));
var inst_20854 = (function (){var subject_var = inst_20828;
var object_var = inst_20830;
var min_sid = inst_20849;
var max_sid = (0);
return (function (p1__20820_SHARP_){
return cljs.core.conj.call(null,cljs.core.PersistentVector.EMPTY,p1__20820_SHARP_);
});
})();
var inst_20855 = cljs.core.range.call(null,inst_20849,(0));
var inst_20856 = cljs.core.map.call(null,inst_20854,inst_20855);
var inst_20857 = cljs.core.PersistentHashMap.EMPTY;
var inst_20858 = [inst_20853,inst_20856,inst_20857];
var inst_20859 = cljs.core.PersistentHashMap.fromArrays(inst_20850,inst_20858);
var state_20928__$1 = state_20928;
var statearr_20935_20976 = state_20928__$1;
(statearr_20935_20976[(2)] = inst_20859);

(statearr_20935_20976[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20929 === (21))){
var inst_20919 = (state_20928[(2)]);
var state_20928__$1 = state_20928;
var statearr_20936_20977 = state_20928__$1;
(statearr_20936_20977[(2)] = inst_20919);

(statearr_20936_20977[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20929 === (13))){
var inst_20830 = (state_20928[(8)]);
var state_20928__$1 = state_20928;
if(cljs.core.truth_(inst_20830)){
var statearr_20937_20978 = state_20928__$1;
(statearr_20937_20978[(1)] = (19));

} else {
var statearr_20938_20979 = state_20928__$1;
(statearr_20938_20979[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20929 === (22))){
var inst_20892 = (state_20928[(9)]);
var state_20928__$1 = state_20928;
var statearr_20939_20980 = state_20928__$1;
(statearr_20939_20980[(2)] = inst_20892);

(statearr_20939_20980[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20929 === (6))){
var inst_20830 = (state_20928[(8)]);
var state_20928__$1 = state_20928;
var statearr_20940_20981 = state_20928__$1;
(statearr_20940_20981[(2)] = inst_20830);

(statearr_20940_20981[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20929 === (25))){
var inst_20898 = (state_20928[(2)]);
var inst_20899 = fluree.db.util.async.throw_err.call(null,inst_20898);
var state_20928__$1 = state_20928;
var statearr_20941_20982 = state_20928__$1;
(statearr_20941_20982[(2)] = inst_20899);

(statearr_20941_20982[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20929 === (17))){
var inst_20889 = (state_20928[(2)]);
var state_20928__$1 = state_20928;
var statearr_20942_20983 = state_20928__$1;
(statearr_20942_20983[(2)] = inst_20889);

(statearr_20942_20983[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20929 === (3))){
var inst_20926 = (state_20928[(2)]);
var state_20928__$1 = state_20928;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20928__$1,inst_20926);
} else {
if((state_val_20929 === (12))){
var inst_20843 = ["_tx",null,"_block",null];
var inst_20844 = (new cljs.core.PersistentArrayMap(null,2,inst_20843,null));
var inst_20845 = (new cljs.core.PersistentHashSet(null,inst_20844,null));
var inst_20846 = cljs.core.last.call(null,clause);
var inst_20847 = inst_20845.call(null,inst_20846);
var state_20928__$1 = state_20928;
if(cljs.core.truth_(inst_20847)){
var statearr_20943_20984 = state_20928__$1;
(statearr_20943_20984[(1)] = (15));

} else {
var statearr_20944_20985 = state_20928__$1;
(statearr_20944_20985[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20929 === (2))){
var inst_20828 = (state_20928[(7)]);
var _ = (function (){var statearr_20945 = state_20928;
(statearr_20945[(4)] = cljs.core.cons.call(null,(5),(state_20928[(4)])));

return statearr_20945;
})();
var inst_20827 = cljs.core.first.call(null,clause);
var inst_20828__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_20827);
var inst_20829 = cljs.core.last.call(null,clause);
var inst_20830 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_20829);
var state_20928__$1 = (function (){var statearr_20946 = state_20928;
(statearr_20946[(7)] = inst_20828__$1);

(statearr_20946[(8)] = inst_20830);

return statearr_20946;
})();
if(cljs.core.truth_(inst_20828__$1)){
var statearr_20947_20986 = state_20928__$1;
(statearr_20947_20986[(1)] = (6));

} else {
var statearr_20948_20987 = state_20928__$1;
(statearr_20948_20987[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20929 === (23))){
var inst_20892 = (state_20928[(9)]);
var inst_20896 = fluree.db.dbproto._subid.call(null,db,inst_20892);
var state_20928__$1 = state_20928;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20928__$1,(25),inst_20896);
} else {
if((state_val_20929 === (19))){
var inst_20892 = (state_20928[(9)]);
var inst_20892__$1 = cljs.core.first.call(null,clause);
var inst_20893 = typeof inst_20892__$1 === 'number';
var state_20928__$1 = (function (){var statearr_20949 = state_20928;
(statearr_20949[(9)] = inst_20892__$1);

return statearr_20949;
})();
if(cljs.core.truth_(inst_20893)){
var statearr_20950_20988 = state_20928__$1;
(statearr_20950_20988[(1)] = (22));

} else {
var statearr_20951_20989 = state_20928__$1;
(statearr_20951_20989[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20929 === (11))){
var inst_20923 = (state_20928[(2)]);
var _ = (function (){var statearr_20953 = state_20928;
(statearr_20953[(4)] = cljs.core.rest.call(null,(state_20928[(4)])));

return statearr_20953;
})();
var state_20928__$1 = state_20928;
var statearr_20954_20990 = state_20928__$1;
(statearr_20954_20990[(2)] = inst_20923);

(statearr_20954_20990[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20929 === (9))){
var inst_20836 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20837 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20838 = cljs.core.PersistentHashMap.fromArrays(inst_20836,inst_20837);
var inst_20839 = cljs.core.ex_info.call(null,"When using rdf:type, either a subject or a type (collection) must be specified.",inst_20838);
var inst_20840 = (function(){throw inst_20839})();
var state_20928__$1 = state_20928;
var statearr_20955_20991 = state_20928__$1;
(statearr_20955_20991[(2)] = inst_20840);

(statearr_20955_20991[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20929 === (5))){
var _ = (function (){var statearr_20956 = state_20928;
(statearr_20956[(4)] = cljs.core.rest.call(null,(state_20928[(4)])));

return statearr_20956;
})();
var state_20928__$1 = state_20928;
var ex20952 = (state_20928__$1[(2)]);
var statearr_20957_20992 = state_20928__$1;
(statearr_20957_20992[(5)] = ex20952);


if((ex20952 instanceof Error)){
var statearr_20958_20993 = state_20928__$1;
(statearr_20958_20993[(1)] = (4));

(statearr_20958_20993[(5)] = null);

} else {
throw ex20952;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20929 === (14))){
var inst_20921 = (state_20928[(2)]);
var state_20928__$1 = state_20928;
var statearr_20959_20994 = state_20928__$1;
(statearr_20959_20994[(2)] = inst_20921);

(statearr_20959_20994[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20929 === (16))){
var inst_20862 = (state_20928[(10)]);
var inst_20864 = (state_20928[(11)]);
var inst_20865 = (state_20928[(12)]);
var inst_20861 = cljs.core.last.call(null,clause);
var inst_20862__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"partition","partition",1174740751),inst_20861);
var inst_20863 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_20864__$1 = cljs.core.get.call(null,inst_20863,inst_20862__$1);
var inst_20865__$1 = fluree.db.flake.min_subject_id.call(null,inst_20862__$1);
var inst_20866 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20867 = [inst_20864__$1];
var inst_20868 = (new cljs.core.PersistentVector(null,1,(5),inst_20866,inst_20867,null));
var inst_20869 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20870 = [inst_20865__$1];
var inst_20871 = (new cljs.core.PersistentVector(null,1,(5),inst_20869,inst_20870,null));
var inst_20872 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_20868,cljs.core._LT__EQ_,inst_20871);
var state_20928__$1 = (function (){var statearr_20960 = state_20928;
(statearr_20960[(10)] = inst_20862__$1);

(statearr_20960[(11)] = inst_20864__$1);

(statearr_20960[(12)] = inst_20865__$1);

return statearr_20960;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20928__$1,(18),inst_20872);
} else {
if((state_val_20929 === (10))){
var inst_20828 = (state_20928[(7)]);
var state_20928__$1 = state_20928;
if(cljs.core.truth_(inst_20828)){
var statearr_20961_20995 = state_20928__$1;
(statearr_20961_20995[(1)] = (12));

} else {
var statearr_20962_20996 = state_20928__$1;
(statearr_20962_20996[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20929 === (18))){
var inst_20862 = (state_20928[(10)]);
var inst_20828 = (state_20928[(7)]);
var inst_20864 = (state_20928[(11)]);
var inst_20830 = (state_20928[(8)]);
var inst_20865 = (state_20928[(12)]);
var inst_20874 = (state_20928[(2)]);
var inst_20875 = fluree.db.util.async.throw_err.call(null,inst_20874);
var inst_20876 = (function (){var subject_var = inst_20828;
var object_var = inst_20830;
var partition = inst_20862;
var max_sid = inst_20864;
var min_sid = inst_20865;
var flakes = inst_20875;
return (function (f){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s], null);
});
})();
var inst_20877 = cljs.core.map.call(null,inst_20876);
var inst_20878 = cljs.core.distinct.call(null);
var inst_20879 = cljs.core.comp.call(null,inst_20877,inst_20878);
var inst_20880 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20881 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20882 = [inst_20828];
var inst_20883 = (new cljs.core.PersistentVector(null,1,(5),inst_20881,inst_20882,null));
var inst_20884 = cljs.core.sequence.call(null,inst_20879,inst_20875);
var inst_20885 = cljs.core.PersistentHashMap.EMPTY;
var inst_20886 = [inst_20883,inst_20884,inst_20885];
var inst_20887 = cljs.core.PersistentHashMap.fromArrays(inst_20880,inst_20886);
var state_20928__$1 = state_20928;
var statearr_20963_20997 = state_20928__$1;
(statearr_20963_20997[(2)] = inst_20887);

(statearr_20963_20997[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20929 === (8))){
var inst_20834 = (state_20928[(2)]);
var state_20928__$1 = state_20928;
if(cljs.core.truth_(inst_20834)){
var statearr_20964_20998 = state_20928__$1;
(statearr_20964_20998[(1)] = (9));

} else {
var statearr_20965_20999 = state_20928__$1;
(statearr_20965_20999[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_20966 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20966[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__);

(statearr_20966[(1)] = (1));

return statearr_20966;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____1 = (function (state_20928){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20928);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20967){var ex__2749__auto__ = e20967;
var statearr_20968_21000 = state_20928;
(statearr_20968_21000[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20928[(4)]))){
var statearr_20969_21001 = state_20928;
(statearr_20969_21001[(1)] = cljs.core.first.call(null,(state_20928[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21002 = state_20928;
state_20928 = G__21002;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__ = function(state_20928){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____1.call(this,state_20928);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20970 = f__2769__auto__.call(null);
(statearr_20970[(6)] = c__2768__auto__);

return statearr_20970;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.call(null,cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum.call(null,coll) / cljs.core.count.call(null,coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.call(null,coll);
var size = cljs.core.count.call(null,coll);
var med = (size >> (1));
var G__21008 = cljs.core.nth.call(null,terms,med);
if(cljs.core.even_QMARK_.call(null,size)){
return ((G__21008 + cljs.core.nth.call(null,terms,(med - (1)))) / (2));
} else {
return G__21008;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg.call(null,coll);
var sum__$1 = sum.call(null,(function (){var iter__5523__auto__ = (function fluree$db$query$analytical$variance_$_iter__21009(s__21010){
return (new cljs.core.LazySeq(null,(function (){
var s__21010__$1 = s__21010;
while(true){
var temp__5804__auto__ = cljs.core.seq.call(null,s__21010__$1);
if(temp__5804__auto__){
var s__21010__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__21010__$2)){
var c__5521__auto__ = cljs.core.chunk_first.call(null,s__21010__$2);
var size__5522__auto__ = cljs.core.count.call(null,c__5521__auto__);
var b__21012 = cljs.core.chunk_buffer.call(null,size__5522__auto__);
if((function (){var i__21011 = (0);
while(true){
if((i__21011 < size__5522__auto__)){
var x = cljs.core._nth.call(null,c__5521__auto__,i__21011);
var delta = (x - mean);
cljs.core.chunk_append.call(null,b__21012,(delta * delta));

var G__21013 = (i__21011 + (1));
i__21011 = G__21013;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21012),fluree$db$query$analytical$variance_$_iter__21009.call(null,cljs.core.chunk_rest.call(null,s__21010__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21012),null);
}
} else {
var x = cljs.core.first.call(null,s__21010__$2);
var delta = (x - mean);
return cljs.core.cons.call(null,(delta * delta),fluree$db$query$analytical$variance_$_iter__21009.call(null,cljs.core.rest.call(null,s__21010__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5523__auto__.call(null,coll);
})());
return (sum__$1 / cljs.core.count.call(null,coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
return Math.sqrt(variance.call(null,coll));
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__5130__auto__ = n;
var y__5131__auto__ = (- n);
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
}),(function() {
var G__21014 = null;
var G__21014__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__21014__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.last.call(null,acc)) < (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.butlast.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__21014 = function(n,coll){
switch(arguments.length){
case 1:
return G__21014__1.call(this,n);
case 2:
return G__21014__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21014.cljs$core$IFn$_invoke$arity$1 = G__21014__1;
G__21014.cljs$core$IFn$_invoke$arity$2 = G__21014__2;
return G__21014;
})()
,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__21015 = null;
var G__21015__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__21015__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.first.call(null,acc)) > (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.next.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__21015 = function(n,coll){
switch(arguments.length){
case 1:
return G__21015__1.call(this,n);
case 2:
return G__21015__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21015.cljs$core$IFn$_invoke$arity$1 = G__21015__1;
G__21015.cljs$core$IFn$_invoke$arity$2 = G__21015__2;
return G__21015;
})()
,(function (coll){
return cljs.core.count.call(null,cljs.core.distinct.call(null,coll));
}),avg,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__21016 = null;
var G__21016__1 = (function (coll){
return cljs.core.rand_nth.call(null,coll);
});
var G__21016__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.repeatedly.call(null,n,(function (){
return cljs.core.rand_nth.call(null,coll);
})));
});
G__21016 = function(n,coll){
switch(arguments.length){
case 1:
return G__21016__1.call(this,n);
case 2:
return G__21016__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21016.cljs$core$IFn$_invoke$arity$1 = G__21016__1;
G__21016.cljs$core$IFn$_invoke$arity$2 = G__21016__2;
return G__21016;
})()
,(function (n,coll){
return cljs.core.vec.call(null,cljs.core.take.call(null,n,cljs.core.shuffle.call(null,coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches.call(null,/^\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches.call(null,/^#\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
/**
 * Returns map of aggregate function executable code or error if invalid aggregate function.
 */
fluree.db.query.analytical.parse_aggregate_STAR_ = (function fluree$db$query$analytical$parse_aggregate_STAR_(parsed_code,as,valid_var){
var list_count = cljs.core.count.call(null,parsed_code);
var vec__21017 = ((cljs.core._EQ_.call(null,(3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,parsed_code),cljs.core.second.call(null,parsed_code),cljs.core.last.call(null,parsed_code)], null):((cljs.core._EQ_.call(null,(2),list_count))?((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first.call(null,parsed_code)))?(function(){throw cljs.core.ex_info.call(null,["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.pr_str.call(null,parsed_code)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,parsed_code),null,cljs.core.last.call(null,parsed_code)], null)):(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.pr_str.call(null,parsed_code)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var fun = cljs.core.nth.call(null,vec__21017,(0),null);
var arg = cljs.core.nth.call(null,vec__21017,(1),null);
var var$ = cljs.core.nth.call(null,vec__21017,(2),null);
var agg_fn = (function (){var temp__5802__auto__ = fluree.db.query.analytical.built_in_aggregates.call(null,fun);
if(cljs.core.truth_(temp__5802__auto__)){
var agg_fn = temp__5802__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return agg_fn.call(null,arg,coll);
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection function, provided: ",cljs.core.pr_str.call(null,parsed_code)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__21020 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_.call(null,var$)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second.call(null,var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
return agg_fn.call(null,cljs.core.distinct.call(null,coll));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.call(null,vec__21020,(0),null);
var variable = cljs.core.nth.call(null,vec__21020,(1),null);
var fn_str = ["(fn [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(variable),"] ",cljs.core.pr_str.call(null,parsed_code),")"].join('');
if(cljs.core.truth_(valid_var.call(null,variable))){
} else {
throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.pr_str.call(null,parsed_code)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402),fn_str,new cljs.core.Keyword(null,"function","function",-2127255473),agg_fn__$1], null);
});
/**
 * Parses string aggregate function and returns execution map if valid.
 */
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(code_str,valid_var){
var list_agg = cljs.reader.read_string.call(null,code_str);
var as_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first.call(null,list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,list_agg))].join('')):cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var code_parsed = ((as_QMARK_)?(function (){var func_list = cljs.core.second.call(null,list_agg);
if(cljs.core.coll_QMARK_.call(null,func_list)){
return func_list;
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(code_str)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
return fluree.db.query.analytical.parse_aggregate_STAR_.call(null,code_parsed,as,valid_var);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(tuples,aggregate_fn_map){
var map__21023 = aggregate_fn_map;
var map__21023__$1 = cljs.core.__destructure_map.call(null,map__21023);
var variable = cljs.core.get.call(null,map__21023__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.call(null,map__21023__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var function$ = cljs.core.get.call(null,map__21023__$1,new cljs.core.Keyword(null,"function","function",-2127255473));
var agg_params = cljs.core.flatten.call(null,fluree.db.query.analytical.select_from_tuples.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),tuples));
var agg_result = function$.call(null,agg_params);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.call(null,(function (res__$1,agg){
var vec__21025 = fluree.db.query.analytical.calculate_aggregate.call(null,res__$1,agg);
var as = cljs.core.nth.call(null,vec__21025,(0),null);
var agg_result = cljs.core.nth.call(null,vec__21025,(1),null);
var map__21028 = res__$1;
var map__21028__$1 = cljs.core.__destructure_map.call(null,map__21028);
var headers = cljs.core.get.call(null,map__21028__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__21028__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__21024_SHARP_){
return cljs.core.conj.call(null,cljs.core.vec.call(null,p1__21024_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,cljs.core.vec.call(null,headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.call(null,(function (acc,tuple){
var b_compare = cljs.core.map.call(null,(function (p1__21029_SHARP_){
return cljs.core.nth.call(null,tuple,p1__21029_SHARP_);
}),b_idxs);
return cljs.core.update.call(null,acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq.call(null,cljs.core.reduce.call(null,(function (acc,a_tuple){
var a_compare = cljs.core.map.call(null,(function (p1__21030_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__21030_SHARP_);
}),a_idxs);
var temp__5802__auto__ = cljs.core.get.call(null,b_map,a_compare);
if(cljs.core.truth_(temp__5802__auto__)){
var b_matched = temp__5802__auto__;
return cljs.core.reduce.call(null,(function (p1__21031_SHARP_,p2__21032_SHARP_){
return cljs.core.conj.call(null,p1__21031_SHARP_,cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (idx){
return cljs.core.nth.call(null,p2__21032_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.call(null,acc,cljs.core.concat.call(null,a_tuple,cljs.core.repeat.call(null,cljs.core.count.call(null,b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.call(null,(function (p1__21033_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__21033_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv.call(null,(function (p__21036,row,b_tuple){
var vec__21037 = p__21036;
var acc = cljs.core.nth.call(null,vec__21037,(0),null);
var b_rows = cljs.core.nth.call(null,vec__21037,(1),null);
if(cljs.core._EQ_.call(null,a_tuple_part,cljs.core.map.call(null,(function (p1__21034_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__21034_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,(function (){var or__5045__auto__ = acc;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (p1__21035_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__21035_SHARP_);
}),b_not_idxs))),cljs.core.conj.call(null,b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_res,b_res);
var a_idxs = cljs.core.map.call(null,(function (p1__21040_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__21040_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__21041_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__21041_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__21043_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__21043_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__21042_SHARP_){
return cljs.core.range.call(null,(0),p1__21042_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = fluree.db.query.analytical.match_tuples_lists.call(null,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.call(null,(function (p1__21044_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__21044_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_tuples,b_tuples);
var a_idxs = cljs.core.map.call(null,(function (p1__21045_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__21045_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__21046_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__21046_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__21048_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__21048_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__21047_SHARP_){
return cljs.core.range.call(null,(0),p1__21047_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = fluree.db.query.analytical.match_tuples_lists.call(null,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.call(null,(function (p1__21049_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__21049_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.call(null," ",filter_code_req),")"].join('');
var vec__21051 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.extract_filter_fn.call(null,filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.call(null,vec__21051,(0),null);
var _ = cljs.core.nth.call(null,vec__21051,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.call(null,(function (p1__21050_SHARP_){
return fluree.db.query.analytical_filter.filter_row.call(null,headers,p1__21050_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.call(null,(function (tuples__$1,filt){
var vec__21056 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.extract_filter_fn.call(null,filt,valid_vars);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.call(null,vec__21056,(0),null);
var filt_vars = cljs.core.nth.call(null,vec__21056,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.call(null,(function (p1__21054_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__21054_SHARP_);
}),filt_vars);
var filtered_tuples = cljs.core.reduce.call(null,(function (acc,clause){
if(cljs.core.every_QMARK_.call(null,(function (p1__21055_SHARP_){
return cljs.core.nth.call(null,clause,p1__21055_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row.call(null,headers,clause,filt_str))){
return cljs.core.conj.call(null,acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.call(null,acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__21059,filters,optional_QMARK_){
var map__21060 = p__21059;
var map__21060__$1 = cljs.core.__destructure_map.call(null,map__21060);
var tuple_map = map__21060__$1;
var headers = cljs.core.get.call(null,map__21060__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__21060__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.call(null,map__21060__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set.call(null,headers);
var header_vec = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.call(null,["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters.call(null,filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required.call(null,header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters.call(null,filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__21061 = clause;
var k = cljs.core.nth.call(null,vec__21061,(0),null);
var v = cljs.core.nth.call(null,vec__21061,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.call(null,["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__21064 = res;
var map__21064__$1 = cljs.core.__destructure_map.call(null,map__21064);
var headers = cljs.core.get.call(null,map__21064__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__21064__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_.call(null,v))?cljs.core.second.call(null,fluree.db.query.analytical.calculate_aggregate.call(null,res,fluree.db.query.analytical.parse_aggregate.call(null,cljs.core.subs.call(null,v,(1)),cljs.core.set.call(null,(function (){var temp__5802__auto__ = cljs.core.keys.call(null,vars);
if(cljs.core.truth_(temp__5802__auto__)){
var valid_var = temp__5802__auto__;
return cljs.core.conj.call(null,headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_21120){
var state_val_21121 = (state_21120[(1)]);
if((state_val_21121 === (7))){
var inst_21094 = (state_21120[(7)]);
var inst_21092 = (state_21120[(2)]);
var inst_21093 = fluree.db.util.async.throw_err.call(null,inst_21092);
var inst_21094__$1 = cljs.core.nth.call(null,inst_21093,(0),null);
var inst_21095 = cljs.core.nth.call(null,inst_21093,(1),null);
var inst_21096 = (inst_21094__$1 == null);
var state_21120__$1 = (function (){var statearr_21122 = state_21120;
(statearr_21122[(7)] = inst_21094__$1);

(statearr_21122[(8)] = inst_21095);

return statearr_21122;
})();
if(cljs.core.truth_(inst_21096)){
var statearr_21123_21152 = state_21120__$1;
(statearr_21123_21152[(1)] = (8));

} else {
var statearr_21124_21153 = state_21120__$1;
(statearr_21124_21153[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21121 === (1))){
var inst_21072 = optional_clauses;
var inst_21073 = cljs.core.seq.call(null,inst_21072);
var inst_21074 = cljs.core.first.call(null,inst_21073);
var inst_21075 = cljs.core.next.call(null,inst_21073);
var inst_21076 = where_tuples;
var inst_21077 = inst_21072;
var inst_21078 = inst_21076;
var state_21120__$1 = (function (){var statearr_21125 = state_21120;
(statearr_21125[(9)] = inst_21077);

(statearr_21125[(10)] = inst_21078);

(statearr_21125[(11)] = inst_21074);

(statearr_21125[(12)] = inst_21075);

return statearr_21125;
})();
var statearr_21126_21154 = state_21120__$1;
(statearr_21126_21154[(2)] = null);

(statearr_21126_21154[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21121 === (4))){
var inst_21085 = (state_21120[(13)]);
var inst_21084 = (state_21120[(14)]);
var inst_21078 = (state_21120[(10)]);
var inst_21090 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_21078,inst_21084,inst_21085,true,fuel,max_fuel,opts);
var state_21120__$1 = state_21120;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21120__$1,(7),inst_21090);
} else {
if((state_val_21121 === (15))){
var state_21120__$1 = state_21120;
var statearr_21127_21155 = state_21120__$1;
(statearr_21127_21155[(2)] = null);

(statearr_21127_21155[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21121 === (13))){
var inst_21111 = (state_21120[(2)]);
var state_21120__$1 = state_21120;
var statearr_21128_21156 = state_21120__$1;
(statearr_21128_21156[(2)] = inst_21111);

(statearr_21128_21156[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21121 === (6))){
var inst_21116 = (state_21120[(2)]);
var state_21120__$1 = state_21120;
var statearr_21129_21157 = state_21120__$1;
(statearr_21129_21157[(2)] = inst_21116);

(statearr_21129_21157[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21121 === (3))){
var inst_21118 = (state_21120[(2)]);
var state_21120__$1 = state_21120;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21120__$1,inst_21118);
} else {
if((state_val_21121 === (12))){
var state_21120__$1 = state_21120;
var statearr_21130_21158 = state_21120__$1;
(statearr_21130_21158[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21121 === (2))){
var inst_21077 = (state_21120[(9)]);
var inst_21084 = (state_21120[(14)]);
var inst_21083 = cljs.core.seq.call(null,inst_21077);
var inst_21084__$1 = cljs.core.first.call(null,inst_21083);
var inst_21085 = cljs.core.next.call(null,inst_21083);
var state_21120__$1 = (function (){var statearr_21132 = state_21120;
(statearr_21132[(13)] = inst_21085);

(statearr_21132[(14)] = inst_21084__$1);

return statearr_21132;
})();
if(cljs.core.truth_(inst_21084__$1)){
var statearr_21133_21159 = state_21120__$1;
(statearr_21133_21159[(1)] = (4));

} else {
var statearr_21134_21160 = state_21120__$1;
(statearr_21134_21160[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21121 === (11))){
var inst_21094 = (state_21120[(7)]);
var inst_21095 = (state_21120[(8)]);
var inst_21077 = inst_21095;
var inst_21078 = inst_21094;
var state_21120__$1 = (function (){var statearr_21135 = state_21120;
(statearr_21135[(9)] = inst_21077);

(statearr_21135[(10)] = inst_21078);

return statearr_21135;
})();
var statearr_21136_21161 = state_21120__$1;
(statearr_21136_21161[(2)] = null);

(statearr_21136_21161[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21121 === (9))){
var inst_21084 = (state_21120[(14)]);
var inst_21100 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_21084);
var state_21120__$1 = state_21120;
if(cljs.core.truth_(inst_21100)){
var statearr_21137_21162 = state_21120__$1;
(statearr_21137_21162[(1)] = (11));

} else {
var statearr_21138_21163 = state_21120__$1;
(statearr_21138_21163[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21121 === (5))){
var inst_21078 = (state_21120[(10)]);
var state_21120__$1 = state_21120;
var statearr_21139_21164 = state_21120__$1;
(statearr_21139_21164[(2)] = inst_21078);

(statearr_21139_21164[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21121 === (14))){
var inst_21094 = (state_21120[(7)]);
var inst_21078 = (state_21120[(10)]);
var inst_21095 = (state_21120[(8)]);
var inst_21105 = fluree.db.query.analytical.left_outer_join.call(null,inst_21078,inst_21094);
var inst_21077 = inst_21095;
var inst_21078__$1 = inst_21105;
var state_21120__$1 = (function (){var statearr_21140 = state_21120;
(statearr_21140[(9)] = inst_21077);

(statearr_21140[(10)] = inst_21078__$1);

return statearr_21140;
})();
var statearr_21141_21165 = state_21120__$1;
(statearr_21141_21165[(2)] = null);

(statearr_21141_21165[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21121 === (16))){
var inst_21109 = (state_21120[(2)]);
var state_21120__$1 = state_21120;
var statearr_21143_21166 = state_21120__$1;
(statearr_21143_21166[(2)] = inst_21109);

(statearr_21143_21166[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21121 === (10))){
var inst_21113 = (state_21120[(2)]);
var state_21120__$1 = state_21120;
var statearr_21144_21167 = state_21120__$1;
(statearr_21144_21167[(2)] = inst_21113);

(statearr_21144_21167[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21121 === (8))){
var inst_21078 = (state_21120[(10)]);
var inst_21095 = (state_21120[(8)]);
var tmp21142 = inst_21078;
var inst_21077 = inst_21095;
var inst_21078__$1 = tmp21142;
var state_21120__$1 = (function (){var statearr_21145 = state_21120;
(statearr_21145[(9)] = inst_21077);

(statearr_21145[(10)] = inst_21078__$1);

return statearr_21145;
})();
var statearr_21146_21168 = state_21120__$1;
(statearr_21146_21168[(2)] = null);

(statearr_21146_21168[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____0 = (function (){
var statearr_21147 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21147[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__);

(statearr_21147[(1)] = (1));

return statearr_21147;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____1 = (function (state_21120){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_21120);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e21148){var ex__2749__auto__ = e21148;
var statearr_21149_21169 = state_21120;
(statearr_21149_21169[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_21120[(4)]))){
var statearr_21150_21170 = state_21120;
(statearr_21150_21170[(1)] = cljs.core.first.call(null,(state_21120[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21171 = state_21120;
state_21120 = G__21171;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__ = function(state_21120){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____1.call(this,state_21120);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_21151 = f__2769__auto__.call(null);
(statearr_21151[(6)] = c__2768__auto__);

return statearr_21151;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.call(null,(function (acc,p__21173){
var vec__21174 = p__21173;
var var_name = cljs.core.nth.call(null,vec__21174,(0),null);
var var_val = cljs.core.nth.call(null,vec__21174,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__21172_SHARP_){
return cljs.core.conj.call(null,p1__21172_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__21178,p__21179,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__21180 = p__21178;
var map__21180__$1 = cljs.core.__destructure_map.call(null,map__21180);
var q_map = map__21180__$1;
var prefixes = cljs.core.get.call(null,map__21180__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__21181 = p__21179;
var map__21181__$1 = cljs.core.__destructure_map.call(null,map__21181);
var res = map__21181__$1;
var vars = cljs.core.get.call(null,map__21181__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_21418){
var state_val_21419 = (state_21418[(1)]);
if((state_val_21419 === (65))){
var inst_21368 = (state_21418[(7)]);
var inst_21367 = (state_21418[(8)]);
var inst_21379 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21380 = fluree.db.query.analytical.full_text__GT_tuples.call(null,inst_21367,res,inst_21368);
var inst_21381 = [inst_21380,r];
var inst_21382 = (new cljs.core.PersistentVector(null,2,(5),inst_21379,inst_21381,null));
var state_21418__$1 = state_21418;
var statearr_21420_21525 = state_21418__$1;
(statearr_21420_21525[(2)] = inst_21382);

(statearr_21420_21525[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (70))){
var inst_21394 = (state_21418[(2)]);
var state_21418__$1 = state_21418;
var statearr_21421_21526 = state_21418__$1;
(statearr_21421_21526[(2)] = inst_21394);

(statearr_21421_21526[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (62))){
var inst_21368 = (state_21418[(7)]);
var inst_21376 = cljs.core.second.call(null,inst_21368);
var inst_21377 = clojure.string.starts_with_QMARK_.call(null,inst_21376,"fullText:");
var state_21418__$1 = state_21418;
if(inst_21377){
var statearr_21422_21527 = state_21418__$1;
(statearr_21422_21527[(1)] = (65));

} else {
var statearr_21423_21528 = state_21418__$1;
(statearr_21423_21528[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (7))){
var inst_21287 = (state_21418[(9)]);
var inst_21286 = cljs.core.count.call(null,clause);
var inst_21287__$1 = cljs.core._EQ_.call(null,(3),inst_21286);
var state_21418__$1 = (function (){var statearr_21424 = state_21418;
(statearr_21424[(9)] = inst_21287__$1);

return statearr_21424;
})();
if(inst_21287__$1){
var statearr_21425_21529 = state_21418__$1;
(statearr_21425_21529[(1)] = (31));

} else {
var statearr_21426_21530 = state_21418__$1;
(statearr_21426_21530[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (59))){
var inst_21401 = (state_21418[(2)]);
var state_21418__$1 = state_21418;
var statearr_21427_21531 = state_21418__$1;
(statearr_21427_21531[(2)] = inst_21401);

(statearr_21427_21531[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (20))){
var inst_21250 = (state_21418[(2)]);
var state_21418__$1 = state_21418;
var statearr_21428_21532 = state_21418__$1;
(statearr_21428_21532[(2)] = inst_21250);

(statearr_21428_21532[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (58))){
var state_21418__$1 = state_21418;
var statearr_21429_21533 = state_21418__$1;
(statearr_21429_21533[(2)] = null);

(statearr_21429_21533[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (60))){
var inst_21367 = (state_21418[(8)]);
var inst_21365 = (state_21418[(2)]);
var inst_21366 = fluree.db.util.async.throw_err.call(null,inst_21365);
var inst_21367__$1 = cljs.core.nth.call(null,inst_21366,(0),null);
var inst_21368 = cljs.core.nth.call(null,inst_21366,(1),null);
var inst_21369 = cljs.core._EQ_.call(null,"$wd",inst_21367__$1);
var state_21418__$1 = (function (){var statearr_21430 = state_21418;
(statearr_21430[(7)] = inst_21368);

(statearr_21430[(8)] = inst_21367__$1);

return statearr_21430;
})();
if(inst_21369){
var statearr_21431_21534 = state_21418__$1;
(statearr_21431_21534[(1)] = (61));

} else {
var statearr_21432_21535 = state_21418__$1;
(statearr_21432_21535[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (27))){
var inst_21280 = (state_21418[(2)]);
var state_21418__$1 = state_21418;
var statearr_21433_21536 = state_21418__$1;
(statearr_21433_21536[(2)] = inst_21280);

(statearr_21433_21536[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (1))){
var state_21418__$1 = state_21418;
var statearr_21434_21537 = state_21418__$1;
(statearr_21434_21537[(2)] = null);

(statearr_21434_21537[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (69))){
var state_21418__$1 = state_21418;
var statearr_21435_21538 = state_21418__$1;
(statearr_21435_21538[(2)] = null);

(statearr_21435_21538[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (24))){
var inst_21244 = (state_21418[(2)]);
var state_21418__$1 = state_21418;
var statearr_21436_21539 = state_21418__$1;
(statearr_21436_21539[(2)] = inst_21244);

(statearr_21436_21539[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (55))){
var inst_21350 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_21351 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21352 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21353 = cljs.core.PersistentHashMap.fromArrays(inst_21351,inst_21352);
var inst_21354 = cljs.core.ex_info.call(null,inst_21350,inst_21353);
var inst_21355 = (function(){throw inst_21354})();
var state_21418__$1 = state_21418;
var statearr_21437_21540 = state_21418__$1;
(statearr_21437_21540[(2)] = inst_21355);

(statearr_21437_21540[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (39))){
var inst_21307 = (state_21418[(2)]);
var state_21418__$1 = state_21418;
if(cljs.core.truth_(inst_21307)){
var statearr_21438_21541 = state_21418__$1;
(statearr_21438_21541[(1)] = (40));

} else {
var statearr_21439_21542 = state_21418__$1;
(statearr_21439_21542[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (46))){
var inst_21407 = (state_21418[(2)]);
var state_21418__$1 = state_21418;
var statearr_21440_21543 = state_21418__$1;
(statearr_21440_21543[(2)] = inst_21407);

(statearr_21440_21543[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (4))){
var inst_21182 = (state_21418[(2)]);
var state_21418__$1 = state_21418;
var statearr_21441_21544 = state_21418__$1;
(statearr_21441_21544[(2)] = inst_21182);

(statearr_21441_21544[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (54))){
var inst_21343 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_21344 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21345 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21346 = cljs.core.PersistentHashMap.fromArrays(inst_21344,inst_21345);
var inst_21347 = cljs.core.ex_info.call(null,inst_21343,inst_21346);
var inst_21348 = (function(){throw inst_21347})();
var state_21418__$1 = state_21418;
var statearr_21442_21545 = state_21418__$1;
(statearr_21442_21545[(2)] = inst_21348);

(statearr_21442_21545[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (15))){
var inst_21282 = (state_21418[(2)]);
var state_21418__$1 = state_21418;
var statearr_21443_21546 = state_21418__$1;
(statearr_21443_21546[(2)] = inst_21282);

(statearr_21443_21546[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (48))){
var inst_21331 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21332 = fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,clause);
var inst_21333 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_21332);
var inst_21334 = [inst_21333,r];
var inst_21335 = (new cljs.core.PersistentVector(null,2,(5),inst_21331,inst_21334,null));
var state_21418__$1 = state_21418;
var statearr_21444_21547 = state_21418__$1;
(statearr_21444_21547[(2)] = inst_21335);

(statearr_21444_21547[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (50))){
var inst_21405 = (state_21418[(2)]);
var state_21418__$1 = state_21418;
var statearr_21445_21548 = state_21418__$1;
(statearr_21445_21548[(2)] = inst_21405);

(statearr_21445_21548[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (21))){
var inst_21218 = (state_21418[(10)]);
var inst_21216 = (state_21418[(11)]);
var inst_21195 = (state_21418[(12)]);
var inst_21191 = (state_21418[(13)]);
var inst_21221 = (state_21418[(14)]);
var inst_21227 = (state_21418[(15)]);
var inst_21228 = (state_21418[(16)]);
var inst_21220 = (state_21418[(17)]);
var inst_21219 = (state_21418[(18)]);
var inst_21232 = (state_21418[(2)]);
var inst_21233 = fluree.db.util.async.throw_err.call(null,inst_21232);
var inst_21234 = (function (){var new_res = inst_21233;
var rest = inst_21228;
var vec__21223 = inst_21220;
var first__21215 = inst_21218;
var tuples = inst_21221;
var first__21225 = inst_21227;
var seq__21214 = inst_21219;
var seq__21224 = inst_21228;
var G__21212 = inst_21220;
var vec__21213 = inst_21216;
var segment_type = inst_21191;
var pred__21192 = inst_21195;
var clause_group = inst_21227;
var expr__21193 = inst_21191;
return (function (res__$1,var$){
return cljs.core.update.call(null,new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_21235 = cljs.core.keys.call(null,vars);
var inst_21236 = cljs.core.reduce.call(null,inst_21234,inst_21233,inst_21235);
var inst_21237 = fluree.db.query.analytical.res_absorb_vars.call(null,inst_21236);
var state_21418__$1 = (function (){var statearr_21446 = state_21418;
(statearr_21446[(19)] = inst_21237);

return statearr_21446;
})();
if(cljs.core.truth_(inst_21221)){
var statearr_21447_21549 = state_21418__$1;
(statearr_21447_21549[(1)] = (22));

} else {
var statearr_21448_21550 = state_21418__$1;
(statearr_21448_21550[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (31))){
var inst_21289 = cljs.core.second.call(null,clause);
var inst_21290 = clojure.string.starts_with_QMARK_.call(null,inst_21289,"fullText:");
var state_21418__$1 = state_21418;
var statearr_21449_21551 = state_21418__$1;
(statearr_21449_21551[(2)] = inst_21290);

(statearr_21449_21551[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (32))){
var inst_21287 = (state_21418[(9)]);
var state_21418__$1 = state_21418;
var statearr_21450_21552 = state_21418__$1;
(statearr_21450_21552[(2)] = inst_21287);

(statearr_21450_21552[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (40))){
var inst_21309 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21310 = fluree.db.query.analytical.collection__GT_tuples.call(null,db,res,clause);
var state_21418__$1 = (function (){var statearr_21451 = state_21418;
(statearr_21451[(20)] = inst_21309);

return statearr_21451;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21418__$1,(43),inst_21310);
} else {
if((state_val_21419 === (56))){
var inst_21357 = (state_21418[(2)]);
var state_21418__$1 = state_21418;
var statearr_21452_21553 = state_21418__$1;
(statearr_21452_21553[(2)] = inst_21357);

(statearr_21452_21553[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (33))){
var inst_21293 = (state_21418[(2)]);
var state_21418__$1 = state_21418;
if(cljs.core.truth_(inst_21293)){
var statearr_21453_21554 = state_21418__$1;
(statearr_21453_21554[(1)] = (34));

} else {
var statearr_21454_21555 = state_21418__$1;
(statearr_21454_21555[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (13))){
var inst_21216 = (state_21418[(11)]);
var inst_21216__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21217 = cljs.core.seq.call(null,inst_21216__$1);
var inst_21218 = cljs.core.first.call(null,inst_21217);
var inst_21219 = cljs.core.next.call(null,inst_21217);
var inst_21220 = inst_21216__$1;
var inst_21221 = null;
var state_21418__$1 = (function (){var statearr_21455 = state_21418;
(statearr_21455[(10)] = inst_21218);

(statearr_21455[(11)] = inst_21216__$1);

(statearr_21455[(14)] = inst_21221);

(statearr_21455[(17)] = inst_21220);

(statearr_21455[(18)] = inst_21219);

return statearr_21455;
})();
var statearr_21456_21556 = state_21418__$1;
(statearr_21456_21556[(2)] = null);

(statearr_21456_21556[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (22))){
var inst_21237 = (state_21418[(19)]);
var inst_21221 = (state_21418[(14)]);
var inst_21228 = (state_21418[(16)]);
var inst_21239 = fluree.db.query.union.results.call(null,inst_21221,inst_21237);
var inst_21220 = inst_21228;
var inst_21221__$1 = inst_21239;
var state_21418__$1 = (function (){var statearr_21457 = state_21418;
(statearr_21457[(14)] = inst_21221__$1);

(statearr_21457[(17)] = inst_21220);

return statearr_21457;
})();
var statearr_21458_21557 = state_21418__$1;
(statearr_21458_21557[(2)] = null);

(statearr_21458_21557[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (36))){
var inst_21411 = (state_21418[(2)]);
var state_21418__$1 = state_21418;
var statearr_21459_21558 = state_21418__$1;
(statearr_21459_21558[(2)] = inst_21411);

(statearr_21459_21558[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (41))){
var inst_21317 = cljs.core.count.call(null,clause);
var inst_21318 = cljs.core._EQ_.call(null,(3),inst_21317);
var state_21418__$1 = state_21418;
if(inst_21318){
var statearr_21460_21559 = state_21418__$1;
(statearr_21460_21559[(1)] = (44));

} else {
var statearr_21461_21560 = state_21418__$1;
(statearr_21461_21560[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (43))){
var inst_21309 = (state_21418[(20)]);
var inst_21312 = (state_21418[(2)]);
var inst_21313 = fluree.db.util.async.throw_err.call(null,inst_21312);
var inst_21314 = [inst_21313,r];
var inst_21315 = (new cljs.core.PersistentVector(null,2,(5),inst_21309,inst_21314,null));
var state_21418__$1 = state_21418;
var statearr_21462_21561 = state_21418__$1;
(statearr_21462_21561[(2)] = inst_21315);

(statearr_21462_21561[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (61))){
var inst_21368 = (state_21418[(7)]);
var inst_21371 = fluree.db.query.analytical.wikidata__GT_tuples.call(null,q_map,inst_21368,r,res,optional_QMARK_,fuel,max_fuel);
var state_21418__$1 = state_21418;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21418__$1,(64),inst_21371);
} else {
if((state_val_21419 === (29))){
var inst_21191 = (state_21418[(13)]);
var inst_21274 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_21191)].join('');
var inst_21275 = (new Error(inst_21274));
var inst_21276 = (function(){throw inst_21275})();
var state_21418__$1 = state_21418;
var statearr_21463_21562 = state_21418__$1;
(statearr_21463_21562[(2)] = inst_21276);

(statearr_21463_21562[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (44))){
var inst_21320 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21321 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,db,res,clause,fuel,max_fuel);
var state_21418__$1 = (function (){var statearr_21464 = state_21418;
(statearr_21464[(21)] = inst_21320);

return statearr_21464;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21418__$1,(47),inst_21321);
} else {
if((state_val_21419 === (6))){
var inst_21195 = (state_21418[(12)]);
var inst_21191 = (state_21418[(13)]);
var inst_21190 = cljs.core.keys.call(null,clause);
var inst_21191__$1 = cljs.core.first.call(null,inst_21190);
var inst_21195__$1 = cljs.core._EQ_;
var inst_21196 = inst_21195__$1.call(null,new cljs.core.Keyword(null,"optional","optional",2053951509),inst_21191__$1);
var state_21418__$1 = (function (){var statearr_21465 = state_21418;
(statearr_21465[(12)] = inst_21195__$1);

(statearr_21465[(13)] = inst_21191__$1);

return statearr_21465;
})();
if(cljs.core.truth_(inst_21196)){
var statearr_21466_21563 = state_21418__$1;
(statearr_21466_21563[(1)] = (9));

} else {
var statearr_21467_21564 = state_21418__$1;
(statearr_21467_21564[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (28))){
var inst_21268 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21269 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21270 = fluree.db.query.analytical.tuples__GT_filtered.call(null,res,inst_21269,optional_QMARK_);
var inst_21271 = [inst_21270,r];
var inst_21272 = (new cljs.core.PersistentVector(null,2,(5),inst_21268,inst_21271,null));
var state_21418__$1 = state_21418;
var statearr_21468_21565 = state_21418__$1;
(statearr_21468_21565[(2)] = inst_21272);

(statearr_21468_21565[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (64))){
var inst_21373 = (state_21418[(2)]);
var inst_21374 = fluree.db.util.async.throw_err.call(null,inst_21373);
var state_21418__$1 = state_21418;
var statearr_21469_21566 = state_21418__$1;
(statearr_21469_21566[(2)] = inst_21374);

(statearr_21469_21566[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (51))){
var inst_21340 = cljs.core.first.call(null,clause);
var inst_21341 = cljs.core.sequential_QMARK_.call(null,inst_21340);
var state_21418__$1 = state_21418;
if(inst_21341){
var statearr_21470_21567 = state_21418__$1;
(statearr_21470_21567[(1)] = (54));

} else {
var statearr_21471_21568 = state_21418__$1;
(statearr_21471_21568[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (25))){
var inst_21195 = (state_21418[(12)]);
var inst_21191 = (state_21418[(13)]);
var inst_21256 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21257 = (function (){var segment_type = inst_21191;
var pred__21192 = inst_21195;
var expr__21193 = inst_21191;
var bindings = inst_21256;
return (function (p1__21177_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,p1__21177_SHARP_);
});
})();
var inst_21258 = cljs.core.map.call(null,inst_21257,inst_21256);
var inst_21259 = cljs.core.PersistentHashMap.EMPTY;
var inst_21260 = cljs.core.into.call(null,inst_21259,inst_21258);
var inst_21261 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21262 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_21260);
var inst_21263 = [inst_21262,r];
var inst_21264 = (new cljs.core.PersistentVector(null,2,(5),inst_21261,inst_21263,null));
var state_21418__$1 = state_21418;
var statearr_21472_21569 = state_21418__$1;
(statearr_21472_21569[(2)] = inst_21264);

(statearr_21472_21569[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (34))){
var inst_21295 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21296 = fluree.db.query.analytical.full_text__GT_tuples.call(null,db,res,clause);
var inst_21297 = [inst_21296,r];
var inst_21298 = (new cljs.core.PersistentVector(null,2,(5),inst_21295,inst_21297,null));
var state_21418__$1 = state_21418;
var statearr_21473_21570 = state_21418__$1;
(statearr_21473_21570[(2)] = inst_21298);

(statearr_21473_21570[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (17))){
var inst_21252 = (state_21418[(2)]);
var state_21418__$1 = state_21418;
var statearr_21474_21571 = state_21418__$1;
(statearr_21474_21571[(2)] = inst_21252);

(statearr_21474_21571[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (3))){
var inst_21416 = (state_21418[(2)]);
var state_21418__$1 = state_21418;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21418__$1,inst_21416);
} else {
if((state_val_21419 === (12))){
var inst_21198 = (state_21418[(22)]);
var inst_21202 = (state_21418[(2)]);
var inst_21203 = fluree.db.util.async.throw_err.call(null,inst_21202);
var inst_21204 = [inst_21203,r];
var inst_21205 = (new cljs.core.PersistentVector(null,2,(5),inst_21198,inst_21204,null));
var state_21418__$1 = state_21418;
var statearr_21475_21572 = state_21418__$1;
(statearr_21475_21572[(2)] = inst_21205);

(statearr_21475_21572[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (2))){
var _ = (function (){var statearr_21476 = state_21418;
(statearr_21476[(4)] = cljs.core.cons.call(null,(5),(state_21418[(4)])));

return statearr_21476;
})();
var inst_21188 = cljs.core.map_QMARK_.call(null,clause);
var state_21418__$1 = state_21418;
if(inst_21188){
var statearr_21477_21573 = state_21418__$1;
(statearr_21477_21573[(1)] = (6));

} else {
var statearr_21478_21574 = state_21418__$1;
(statearr_21478_21574[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (66))){
var state_21418__$1 = state_21418;
var statearr_21479_21575 = state_21418__$1;
(statearr_21479_21575[(1)] = (68));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (23))){
var inst_21237 = (state_21418[(19)]);
var inst_21228 = (state_21418[(16)]);
var inst_21220 = inst_21228;
var inst_21221 = inst_21237;
var state_21418__$1 = (function (){var statearr_21481 = state_21418;
(statearr_21481[(14)] = inst_21221);

(statearr_21481[(17)] = inst_21220);

return statearr_21481;
})();
var statearr_21482_21576 = state_21418__$1;
(statearr_21482_21576[(2)] = null);

(statearr_21482_21576[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (47))){
var inst_21320 = (state_21418[(21)]);
var inst_21323 = (state_21418[(2)]);
var inst_21324 = fluree.db.util.async.throw_err.call(null,inst_21323);
var inst_21325 = [inst_21324,r];
var inst_21326 = (new cljs.core.PersistentVector(null,2,(5),inst_21320,inst_21325,null));
var state_21418__$1 = state_21418;
var statearr_21483_21577 = state_21418__$1;
(statearr_21483_21577[(2)] = inst_21326);

(statearr_21483_21577[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (35))){
var inst_21301 = (state_21418[(23)]);
var inst_21300 = cljs.core.count.call(null,clause);
var inst_21301__$1 = cljs.core._EQ_.call(null,(3),inst_21300);
var state_21418__$1 = (function (){var statearr_21484 = state_21418;
(statearr_21484[(23)] = inst_21301__$1);

return statearr_21484;
})();
if(inst_21301__$1){
var statearr_21485_21578 = state_21418__$1;
(statearr_21485_21578[(1)] = (37));

} else {
var statearr_21486_21579 = state_21418__$1;
(statearr_21486_21579[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (19))){
var inst_21221 = (state_21418[(14)]);
var inst_21246 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21247 = [inst_21221,r];
var inst_21248 = (new cljs.core.PersistentVector(null,2,(5),inst_21246,inst_21247,null));
var state_21418__$1 = state_21418;
var statearr_21487_21580 = state_21418__$1;
(statearr_21487_21580[(2)] = inst_21248);

(statearr_21487_21580[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (57))){
var inst_21363 = fluree.db.query.analytical.get_source_clause.call(null,db,clause,prefixes,opts);
var state_21418__$1 = state_21418;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21418__$1,(60),inst_21363);
} else {
if((state_val_21419 === (68))){
var inst_21368 = (state_21418[(7)]);
var inst_21367 = (state_21418[(8)]);
var inst_21385 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21386 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,inst_21367,res,inst_21368,fuel,max_fuel);
var state_21418__$1 = (function (){var statearr_21488 = state_21418;
(statearr_21488[(24)] = inst_21385);

return statearr_21488;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21418__$1,(71),inst_21386);
} else {
if((state_val_21419 === (11))){
var inst_21284 = (state_21418[(2)]);
var state_21418__$1 = state_21418;
var statearr_21490_21581 = state_21418__$1;
(statearr_21490_21581[(2)] = inst_21284);

(statearr_21490_21581[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (9))){
var inst_21198 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21199 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21200 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_21199,res,fuel,max_fuel,opts);
var state_21418__$1 = (function (){var statearr_21491 = state_21418;
(statearr_21491[(22)] = inst_21198);

return statearr_21491;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21418__$1,(12),inst_21200);
} else {
if((state_val_21419 === (5))){
var _ = (function (){var statearr_21492 = state_21418;
(statearr_21492[(4)] = cljs.core.rest.call(null,(state_21418[(4)])));

return statearr_21492;
})();
var state_21418__$1 = state_21418;
var ex21489 = (state_21418__$1[(2)]);
var statearr_21493_21582 = state_21418__$1;
(statearr_21493_21582[(5)] = ex21489);


if((ex21489 instanceof Error)){
var statearr_21494_21583 = state_21418__$1;
(statearr_21494_21583[(1)] = (4));

(statearr_21494_21583[(5)] = null);

} else {
throw ex21489;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (14))){
var inst_21195 = (state_21418[(12)]);
var inst_21191 = (state_21418[(13)]);
var inst_21254 = inst_21195.call(null,new cljs.core.Keyword(null,"bind","bind",-113428417),inst_21191);
var state_21418__$1 = state_21418;
if(cljs.core.truth_(inst_21254)){
var statearr_21495_21584 = state_21418__$1;
(statearr_21495_21584[(1)] = (25));

} else {
var statearr_21496_21585 = state_21418__$1;
(statearr_21496_21585[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (45))){
var inst_21328 = cljs.core.count.call(null,clause);
var inst_21329 = cljs.core._EQ_.call(null,(2),inst_21328);
var state_21418__$1 = state_21418;
if(inst_21329){
var statearr_21497_21586 = state_21418__$1;
(statearr_21497_21586[(1)] = (48));

} else {
var statearr_21498_21587 = state_21418__$1;
(statearr_21498_21587[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (53))){
var inst_21403 = (state_21418[(2)]);
var state_21418__$1 = state_21418;
var statearr_21499_21588 = state_21418__$1;
(statearr_21499_21588[(2)] = inst_21403);

(statearr_21499_21588[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (26))){
var inst_21195 = (state_21418[(12)]);
var inst_21191 = (state_21418[(13)]);
var inst_21266 = inst_21195.call(null,new cljs.core.Keyword(null,"filter","filter",-948537934),inst_21191);
var state_21418__$1 = state_21418;
if(cljs.core.truth_(inst_21266)){
var statearr_21500_21589 = state_21418__$1;
(statearr_21500_21589[(1)] = (28));

} else {
var statearr_21501_21590 = state_21418__$1;
(statearr_21501_21590[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (16))){
var inst_21227 = (state_21418[(15)]);
var inst_21220 = (state_21418[(17)]);
var inst_21226 = cljs.core.seq.call(null,inst_21220);
var inst_21227__$1 = cljs.core.first.call(null,inst_21226);
var inst_21228 = cljs.core.next.call(null,inst_21226);
var state_21418__$1 = (function (){var statearr_21502 = state_21418;
(statearr_21502[(15)] = inst_21227__$1);

(statearr_21502[(16)] = inst_21228);

return statearr_21502;
})();
if(cljs.core.truth_(inst_21227__$1)){
var statearr_21503_21591 = state_21418__$1;
(statearr_21503_21591[(1)] = (18));

} else {
var statearr_21504_21592 = state_21418__$1;
(statearr_21504_21592[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (38))){
var inst_21301 = (state_21418[(23)]);
var state_21418__$1 = state_21418;
var statearr_21505_21593 = state_21418__$1;
(statearr_21505_21593[(2)] = inst_21301);

(statearr_21505_21593[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (30))){
var inst_21278 = (state_21418[(2)]);
var state_21418__$1 = state_21418;
var statearr_21506_21594 = state_21418__$1;
(statearr_21506_21594[(2)] = inst_21278);

(statearr_21506_21594[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (10))){
var inst_21195 = (state_21418[(12)]);
var inst_21191 = (state_21418[(13)]);
var inst_21207 = inst_21195.call(null,new cljs.core.Keyword(null,"union","union",2142937499),inst_21191);
var state_21418__$1 = state_21418;
if(cljs.core.truth_(inst_21207)){
var statearr_21507_21595 = state_21418__$1;
(statearr_21507_21595[(1)] = (13));

} else {
var statearr_21508_21596 = state_21418__$1;
(statearr_21508_21596[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (18))){
var inst_21227 = (state_21418[(15)]);
var inst_21230 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_21227,q_map,vars,fuel,max_fuel,opts);
var state_21418__$1 = state_21418;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21418__$1,(21),inst_21230);
} else {
if((state_val_21419 === (52))){
var state_21418__$1 = state_21418;
var statearr_21509_21597 = state_21418__$1;
(statearr_21509_21597[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (67))){
var inst_21396 = (state_21418[(2)]);
var state_21418__$1 = state_21418;
var statearr_21511_21598 = state_21418__$1;
(statearr_21511_21598[(2)] = inst_21396);

(statearr_21511_21598[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (71))){
var inst_21385 = (state_21418[(24)]);
var inst_21388 = (state_21418[(2)]);
var inst_21389 = fluree.db.util.async.throw_err.call(null,inst_21388);
var inst_21390 = [inst_21389,r];
var inst_21391 = (new cljs.core.PersistentVector(null,2,(5),inst_21385,inst_21390,null));
var state_21418__$1 = state_21418;
var statearr_21512_21599 = state_21418__$1;
(statearr_21512_21599[(2)] = inst_21391);

(statearr_21512_21599[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (42))){
var inst_21409 = (state_21418[(2)]);
var state_21418__$1 = state_21418;
var statearr_21513_21600 = state_21418__$1;
(statearr_21513_21600[(2)] = inst_21409);

(statearr_21513_21600[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (37))){
var inst_21303 = cljs.core.second.call(null,clause);
var inst_21304 = cljs.core._EQ_.call(null,inst_21303,"rdf:type");
var state_21418__$1 = state_21418;
var statearr_21514_21601 = state_21418__$1;
(statearr_21514_21601[(2)] = inst_21304);

(statearr_21514_21601[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (63))){
var inst_21398 = (state_21418[(2)]);
var state_21418__$1 = state_21418;
var statearr_21515_21602 = state_21418__$1;
(statearr_21515_21602[(2)] = inst_21398);

(statearr_21515_21602[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (8))){
var inst_21413 = (state_21418[(2)]);
var _ = (function (){var statearr_21516 = state_21418;
(statearr_21516[(4)] = cljs.core.rest.call(null,(state_21418[(4)])));

return statearr_21516;
})();
var state_21418__$1 = state_21418;
var statearr_21517_21603 = state_21418__$1;
(statearr_21517_21603[(2)] = inst_21413);

(statearr_21517_21603[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21419 === (49))){
var inst_21337 = cljs.core.count.call(null,clause);
var inst_21338 = cljs.core._EQ_.call(null,(1),inst_21337);
var state_21418__$1 = state_21418;
if(inst_21338){
var statearr_21518_21604 = state_21418__$1;
(statearr_21518_21604[(1)] = (51));

} else {
var statearr_21519_21605 = state_21418__$1;
(statearr_21519_21605[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_21520 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21520[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__);

(statearr_21520[(1)] = (1));

return statearr_21520;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____1 = (function (state_21418){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_21418);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e21521){var ex__2749__auto__ = e21521;
var statearr_21522_21606 = state_21418;
(statearr_21522_21606[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_21418[(4)]))){
var statearr_21523_21607 = state_21418;
(statearr_21523_21607[(1)] = cljs.core.first.call(null,(state_21418[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21608 = state_21418;
state_21418 = G__21608;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__ = function(state_21418){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____1.call(this,state_21418);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_21524 = f__2769__auto__.call(null);
(statearr_21524[(6)] = c__2768__auto__);

return statearr_21524;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__21610 = arguments.length;
switch (G__21610) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.call(null,db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_21689){
var state_val_21690 = (state_21689[(1)]);
if((state_val_21690 === (7))){
var inst_21684 = (state_21689[(2)]);
var _ = (function (){var statearr_21691 = state_21689;
(statearr_21691[(4)] = cljs.core.rest.call(null,(state_21689[(4)])));

return statearr_21691;
})();
var state_21689__$1 = state_21689;
var statearr_21692_21740 = state_21689__$1;
(statearr_21692_21740[(2)] = inst_21684);

(statearr_21692_21740[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21690 === (20))){
var inst_21649 = (state_21689[(7)]);
var inst_21661 = (state_21689[(2)]);
var inst_21631 = inst_21649;
var inst_21632 = inst_21661;
var state_21689__$1 = (function (){var statearr_21693 = state_21689;
(statearr_21693[(8)] = inst_21631);

(statearr_21693[(9)] = inst_21632);

return statearr_21693;
})();
var statearr_21694_21741 = state_21689__$1;
(statearr_21694_21741[(2)] = null);

(statearr_21694_21741[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21690 === (1))){
var state_21689__$1 = state_21689;
var statearr_21695_21742 = state_21689__$1;
(statearr_21695_21742[(2)] = null);

(statearr_21695_21742[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21690 === (24))){
var inst_21632 = (state_21689[(9)]);
var inst_21649 = (state_21689[(7)]);
var inst_21648 = (state_21689[(10)]);
var inst_21669 = fluree.db.query.analytical.inner_join.call(null,inst_21632,inst_21648);
var inst_21631 = inst_21649;
var inst_21632__$1 = inst_21669;
var state_21689__$1 = (function (){var statearr_21696 = state_21689;
(statearr_21696[(8)] = inst_21631);

(statearr_21696[(9)] = inst_21632__$1);

return statearr_21696;
})();
var statearr_21697_21743 = state_21689__$1;
(statearr_21697_21743[(2)] = null);

(statearr_21697_21743[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21690 === (4))){
var inst_21611 = (state_21689[(2)]);
var state_21689__$1 = state_21689;
var statearr_21699_21744 = state_21689__$1;
(statearr_21699_21744[(2)] = inst_21611);

(statearr_21699_21744[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21690 === (15))){
var inst_21648 = (state_21689[(10)]);
var state_21689__$1 = state_21689;
if(cljs.core.truth_(inst_21648)){
var statearr_21700_21745 = state_21689__$1;
(statearr_21700_21745[(1)] = (18));

} else {
var statearr_21701_21746 = state_21689__$1;
(statearr_21701_21746[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21690 === (21))){
var inst_21632 = (state_21689[(9)]);
var inst_21649 = (state_21689[(7)]);
var tmp21698 = inst_21632;
var inst_21631 = inst_21649;
var inst_21632__$1 = tmp21698;
var state_21689__$1 = (function (){var statearr_21702 = state_21689;
(statearr_21702[(8)] = inst_21631);

(statearr_21702[(9)] = inst_21632__$1);

return statearr_21702;
})();
var statearr_21703_21747 = state_21689__$1;
(statearr_21703_21747[(2)] = null);

(statearr_21703_21747[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21690 === (13))){
var inst_21632 = (state_21689[(9)]);
var inst_21655 = cljs.core.dissoc.call(null,inst_21632,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_21656 = cljs.core.empty_QMARK_.call(null,inst_21655);
var state_21689__$1 = state_21689;
if(inst_21656){
var statearr_21704_21748 = state_21689__$1;
(statearr_21704_21748[(1)] = (15));

} else {
var statearr_21705_21749 = state_21689__$1;
(statearr_21705_21749[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21690 === (22))){
var state_21689__$1 = state_21689;
var statearr_21706_21750 = state_21689__$1;
(statearr_21706_21750[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21690 === (6))){
var inst_21631 = (state_21689[(8)]);
var inst_21638 = (state_21689[(11)]);
var inst_21637 = cljs.core.seq.call(null,inst_21631);
var inst_21638__$1 = cljs.core.first.call(null,inst_21637);
var inst_21639 = cljs.core.next.call(null,inst_21637);
var state_21689__$1 = (function (){var statearr_21708 = state_21689;
(statearr_21708[(11)] = inst_21638__$1);

(statearr_21708[(12)] = inst_21639);

return statearr_21708;
})();
if(cljs.core.truth_(inst_21638__$1)){
var statearr_21709_21751 = state_21689__$1;
(statearr_21709_21751[(1)] = (8));

} else {
var statearr_21710_21752 = state_21689__$1;
(statearr_21710_21752[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21690 === (25))){
var state_21689__$1 = state_21689;
var statearr_21711_21753 = state_21689__$1;
(statearr_21711_21753[(2)] = null);

(statearr_21711_21753[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21690 === (17))){
var inst_21677 = (state_21689[(2)]);
var state_21689__$1 = state_21689;
var statearr_21712_21754 = state_21689__$1;
(statearr_21712_21754[(2)] = inst_21677);

(statearr_21712_21754[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21690 === (3))){
var inst_21687 = (state_21689[(2)]);
var state_21689__$1 = state_21689;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21689__$1,inst_21687);
} else {
if((state_val_21690 === (12))){
var inst_21649 = (state_21689[(7)]);
var inst_21648 = (state_21689[(10)]);
var inst_21631 = inst_21649;
var inst_21632 = inst_21648;
var state_21689__$1 = (function (){var statearr_21713 = state_21689;
(statearr_21713[(8)] = inst_21631);

(statearr_21713[(9)] = inst_21632);

return statearr_21713;
})();
var statearr_21714_21755 = state_21689__$1;
(statearr_21714_21755[(2)] = null);

(statearr_21714_21755[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21690 === (2))){
var _ = (function (){var statearr_21715 = state_21689;
(statearr_21715[(4)] = cljs.core.cons.call(null,(5),(state_21689[(4)])));

return statearr_21715;
})();
var inst_21624 = where;
var inst_21625 = cljs.core.seq.call(null,inst_21624);
var inst_21626 = cljs.core.first.call(null,inst_21625);
var inst_21627 = cljs.core.next.call(null,inst_21625);
var inst_21628 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_21629 = [vars];
var inst_21630 = cljs.core.PersistentHashMap.fromArrays(inst_21628,inst_21629);
var inst_21631 = inst_21624;
var inst_21632 = inst_21630;
var state_21689__$1 = (function (){var statearr_21716 = state_21689;
(statearr_21716[(8)] = inst_21631);

(statearr_21716[(13)] = inst_21627);

(statearr_21716[(9)] = inst_21632);

(statearr_21716[(14)] = inst_21626);

return statearr_21716;
})();
var statearr_21717_21756 = state_21689__$1;
(statearr_21717_21756[(2)] = null);

(statearr_21717_21756[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21690 === (23))){
var inst_21675 = (state_21689[(2)]);
var state_21689__$1 = state_21689;
var statearr_21718_21757 = state_21689__$1;
(statearr_21718_21757[(2)] = inst_21675);

(statearr_21718_21757[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21690 === (19))){
var inst_21632 = (state_21689[(9)]);
var state_21689__$1 = state_21689;
var statearr_21719_21758 = state_21689__$1;
(statearr_21719_21758[(2)] = inst_21632);

(statearr_21719_21758[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21690 === (11))){
var inst_21638 = (state_21689[(11)]);
var inst_21646 = (state_21689[(2)]);
var inst_21647 = fluree.db.util.async.throw_err.call(null,inst_21646);
var inst_21648 = cljs.core.nth.call(null,inst_21647,(0),null);
var inst_21649 = cljs.core.nth.call(null,inst_21647,(1),null);
var inst_21650 = cljs.core.count.call(null,inst_21638);
var inst_21651 = cljs.core._EQ_.call(null,(2),inst_21650);
var state_21689__$1 = (function (){var statearr_21721 = state_21689;
(statearr_21721[(7)] = inst_21649);

(statearr_21721[(10)] = inst_21648);

return statearr_21721;
})();
if(inst_21651){
var statearr_21722_21759 = state_21689__$1;
(statearr_21722_21759[(1)] = (12));

} else {
var statearr_21723_21760 = state_21689__$1;
(statearr_21723_21760[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21690 === (9))){
var inst_21632 = (state_21689[(9)]);
var state_21689__$1 = state_21689;
var statearr_21724_21761 = state_21689__$1;
(statearr_21724_21761[(2)] = inst_21632);

(statearr_21724_21761[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21690 === (5))){
var _ = (function (){var statearr_21725 = state_21689;
(statearr_21725[(4)] = cljs.core.rest.call(null,(state_21689[(4)])));

return statearr_21725;
})();
var state_21689__$1 = state_21689;
var ex21720 = (state_21689__$1[(2)]);
var statearr_21726_21762 = state_21689__$1;
(statearr_21726_21762[(5)] = ex21720);


if((ex21720 instanceof Error)){
var statearr_21727_21763 = state_21689__$1;
(statearr_21727_21763[(1)] = (4));

(statearr_21727_21763[(5)] = null);

} else {
throw ex21720;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21690 === (14))){
var inst_21679 = (state_21689[(2)]);
var state_21689__$1 = state_21689;
var statearr_21728_21764 = state_21689__$1;
(statearr_21728_21764[(2)] = inst_21679);

(statearr_21728_21764[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21690 === (26))){
var inst_21673 = (state_21689[(2)]);
var state_21689__$1 = state_21689;
var statearr_21729_21765 = state_21689__$1;
(statearr_21729_21765[(2)] = inst_21673);

(statearr_21729_21765[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21690 === (16))){
var inst_21648 = (state_21689[(10)]);
var inst_21664 = (inst_21648 == null);
var state_21689__$1 = state_21689;
if(cljs.core.truth_(inst_21664)){
var statearr_21730_21766 = state_21689__$1;
(statearr_21730_21766[(1)] = (21));

} else {
var statearr_21731_21767 = state_21689__$1;
(statearr_21731_21767[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21690 === (10))){
var inst_21682 = (state_21689[(2)]);
var state_21689__$1 = state_21689;
var statearr_21732_21768 = state_21689__$1;
(statearr_21732_21768[(2)] = inst_21682);

(statearr_21732_21768[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21690 === (18))){
var inst_21648 = (state_21689[(10)]);
var state_21689__$1 = state_21689;
var statearr_21733_21769 = state_21689__$1;
(statearr_21733_21769[(2)] = inst_21648);

(statearr_21733_21769[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21690 === (8))){
var inst_21632 = (state_21689[(9)]);
var inst_21638 = (state_21689[(11)]);
var inst_21639 = (state_21689[(12)]);
var inst_21644 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_21632,inst_21638,inst_21639,false,fuel,max_fuel,opts);
var state_21689__$1 = state_21689;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21689__$1,(11),inst_21644);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2746__auto__ = null;
var fluree$db$query$analytical$state_machine__2746__auto____0 = (function (){
var statearr_21734 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21734[(0)] = fluree$db$query$analytical$state_machine__2746__auto__);

(statearr_21734[(1)] = (1));

return statearr_21734;
});
var fluree$db$query$analytical$state_machine__2746__auto____1 = (function (state_21689){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_21689);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e21735){var ex__2749__auto__ = e21735;
var statearr_21736_21770 = state_21689;
(statearr_21736_21770[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_21689[(4)]))){
var statearr_21737_21771 = state_21689;
(statearr_21737_21771[(1)] = cljs.core.first.call(null,(state_21689[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21772 = state_21689;
state_21689 = G__21772;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2746__auto__ = function(state_21689){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2746__auto____1.call(this,state_21689);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2746__auto____0;
fluree$db$query$analytical$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2746__auto____1;
return fluree$db$query$analytical$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_21738 = f__2769__auto__.call(null);
(statearr_21738[(6)] = c__2768__auto__);

return statearr_21738;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(p__21773){
var map__21774 = p__21773;
var map__21774__$1 = cljs.core.__destructure_map.call(null,map__21774);
var opts = map__21774__$1;
var vars = cljs.core.get.call(null,map__21774__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var query_map = cljs.core.get.call(null,map__21774__$1,new cljs.core.Keyword(null,"query-map","query-map",-808576972));
var fuel = cljs.core.get.call(null,map__21774__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485));
var max_fuel = cljs.core.get.call(null,map__21774__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var db = cljs.core.get.call(null,map__21774__$1,new cljs.core.Keyword(null,"db","db",993250759));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_21808){
var state_val_21809 = (state_21808[(1)]);
if((state_val_21809 === (7))){
var inst_21790 = (state_21808[(7)]);
var inst_21785 = (state_21808[(8)]);
var inst_21792 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,query_map,inst_21785,inst_21790,fuel,max_fuel,opts);
var state_21808__$1 = state_21808;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21808__$1,(10),inst_21792);
} else {
if((state_val_21809 === (1))){
var state_21808__$1 = state_21808;
var statearr_21810_21835 = state_21808__$1;
(statearr_21810_21835[(2)] = null);

(statearr_21810_21835[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21809 === (4))){
var inst_21775 = (state_21808[(2)]);
var state_21808__$1 = state_21808;
var statearr_21811_21836 = state_21808__$1;
(statearr_21811_21836[(2)] = inst_21775);

(statearr_21811_21836[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21809 === (13))){
var inst_21803 = (state_21808[(2)]);
var _ = (function (){var statearr_21812 = state_21808;
(statearr_21812[(4)] = cljs.core.rest.call(null,(state_21808[(4)])));

return statearr_21812;
})();
var state_21808__$1 = state_21808;
var statearr_21813_21837 = state_21808__$1;
(statearr_21813_21837[(2)] = inst_21803);

(statearr_21813_21837[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21809 === (6))){
var inst_21785 = (state_21808[(8)]);
var inst_21789 = (state_21808[(2)]);
var inst_21790 = fluree.db.util.async.throw_err.call(null,inst_21789);
var state_21808__$1 = (function (){var statearr_21814 = state_21808;
(statearr_21814[(7)] = inst_21790);

return statearr_21814;
})();
if(cljs.core.truth_(inst_21785)){
var statearr_21815_21838 = state_21808__$1;
(statearr_21815_21838[(1)] = (7));

} else {
var statearr_21816_21839 = state_21808__$1;
(statearr_21816_21839[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21809 === (3))){
var inst_21806 = (state_21808[(2)]);
var state_21808__$1 = state_21808;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21808__$1,inst_21806);
} else {
if((state_val_21809 === (12))){
var inst_21798 = (state_21808[(9)]);
var state_21808__$1 = state_21808;
var statearr_21817_21840 = state_21808__$1;
(statearr_21817_21840[(2)] = inst_21798);

(statearr_21817_21840[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21809 === (2))){
var _ = (function (){var statearr_21818 = state_21808;
(statearr_21818[(4)] = cljs.core.cons.call(null,(5),(state_21808[(4)])));

return statearr_21818;
})();
var inst_21782 = query_map;
var inst_21783 = cljs.core.__destructure_map.call(null,inst_21782);
var inst_21784 = cljs.core.get.call(null,inst_21783,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_21785 = cljs.core.get.call(null,inst_21783,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_21786 = cljs.core.get.call(null,inst_21783,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_21787 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_21784,query_map,vars,fuel,max_fuel,opts);
var state_21808__$1 = (function (){var statearr_21819 = state_21808;
(statearr_21819[(10)] = inst_21786);

(statearr_21819[(8)] = inst_21785);

return statearr_21819;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21808__$1,(6),inst_21787);
} else {
if((state_val_21809 === (11))){
var inst_21798 = (state_21808[(9)]);
var inst_21786 = (state_21808[(10)]);
var inst_21800 = fluree.db.query.analytical.tuples__GT_filtered.call(null,inst_21798,inst_21786,null);
var state_21808__$1 = state_21808;
var statearr_21821_21841 = state_21808__$1;
(statearr_21821_21841[(2)] = inst_21800);

(statearr_21821_21841[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21809 === (9))){
var inst_21786 = (state_21808[(10)]);
var inst_21798 = (state_21808[(2)]);
var state_21808__$1 = (function (){var statearr_21822 = state_21808;
(statearr_21822[(9)] = inst_21798);

return statearr_21822;
})();
if(cljs.core.truth_(inst_21786)){
var statearr_21823_21842 = state_21808__$1;
(statearr_21823_21842[(1)] = (11));

} else {
var statearr_21824_21843 = state_21808__$1;
(statearr_21824_21843[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21809 === (5))){
var _ = (function (){var statearr_21825 = state_21808;
(statearr_21825[(4)] = cljs.core.rest.call(null,(state_21808[(4)])));

return statearr_21825;
})();
var state_21808__$1 = state_21808;
var ex21820 = (state_21808__$1[(2)]);
var statearr_21826_21844 = state_21808__$1;
(statearr_21826_21844[(5)] = ex21820);


if((ex21820 instanceof Error)){
var statearr_21827_21845 = state_21808__$1;
(statearr_21827_21845[(1)] = (4));

(statearr_21827_21845[(5)] = null);

} else {
throw ex21820;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21809 === (10))){
var inst_21794 = (state_21808[(2)]);
var inst_21795 = fluree.db.util.async.throw_err.call(null,inst_21794);
var state_21808__$1 = state_21808;
var statearr_21828_21846 = state_21808__$1;
(statearr_21828_21846[(2)] = inst_21795);

(statearr_21828_21846[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21809 === (8))){
var inst_21790 = (state_21808[(7)]);
var state_21808__$1 = state_21808;
var statearr_21829_21847 = state_21808__$1;
(statearr_21829_21847[(2)] = inst_21790);

(statearr_21829_21847[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__2746__auto____0 = (function (){
var statearr_21830 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21830[(0)] = fluree$db$query$analytical$q_$_state_machine__2746__auto__);

(statearr_21830[(1)] = (1));

return statearr_21830;
});
var fluree$db$query$analytical$q_$_state_machine__2746__auto____1 = (function (state_21808){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_21808);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e21831){var ex__2749__auto__ = e21831;
var statearr_21832_21848 = state_21808;
(statearr_21832_21848[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_21808[(4)]))){
var statearr_21833_21849 = state_21808;
(statearr_21833_21849[(1)] = cljs.core.first.call(null,(state_21808[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21850 = state_21808;
state_21808 = G__21850;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__2746__auto__ = function(state_21808){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__2746__auto____1.call(this,state_21808);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__2746__auto____0;
fluree$db$query$analytical$q_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$q_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_21834 = f__2769__auto__.call(null);
(statearr_21834[(6)] = c__2768__auto__);

return statearr_21834;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
