// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.call(null,(function (value_group){
var stringified = cljs.core.map.call(null,(function (p1__19887_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19887_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.call(null," ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.call(null," ",value_groups);
return ["VALUES ( ",clojure.string.join.call(null," ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__19891 = coll;
var vec__19892 = G__19891;
var seq__19893 = cljs.core.seq.call(null,vec__19892);
var first__19894 = cljs.core.first.call(null,seq__19893);
var seq__19893__$1 = cljs.core.next.call(null,seq__19893);
var clause = first__19894;
var r = seq__19893__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19891__$1 = G__19891;
var res__$1 = res;
while(true){
var vec__19898 = G__19891__$1;
var seq__19899 = cljs.core.seq.call(null,vec__19898);
var first__19900 = cljs.core.first.call(null,seq__19899);
var seq__19899__$1 = cljs.core.next.call(null,seq__19899);
var clause__$1 = first__19900;
var r__$1 = seq__19899__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__19901 = r__$1;
var G__19902 = cljs.core.conj.call(null,res__$2,clause__$1);
G__19891__$1 = G__19901;
res__$1 = G__19902;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.call(null,(function (res,p__19903){
var map__19904 = p__19903;
var map__19904__$1 = cljs.core.__destructure_map.call(null,map__19904);
var optional = cljs.core.get.call(null,map__19904__$1,new cljs.core.Keyword(null,"optional","optional",2053951509));
if(cljs.core.truth_(optional)){
return cljs.core.into.call(null,res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__19908 = coll;
var vec__19909 = G__19908;
var seq__19910 = cljs.core.seq.call(null,vec__19909);
var first__19911 = cljs.core.first.call(null,seq__19910);
var seq__19910__$1 = cljs.core.next.call(null,seq__19910);
var clause = first__19911;
var r = seq__19910__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19908__$1 = G__19908;
var res__$1 = res;
while(true){
var vec__19915 = G__19908__$1;
var seq__19916 = cljs.core.seq.call(null,vec__19915);
var first__19917 = cljs.core.first.call(null,seq__19916);
var seq__19916__$1 = cljs.core.next.call(null,seq__19916);
var clause__$1 = first__19917;
var r__$1 = seq__19916__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__19918 = r__$1;
var G__19919 = cljs.core.conj.call(null,res__$2,cljs.core.rest.call(null,clause__$1));
G__19908__$1 = G__19918;
res__$1 = G__19919;
continue;
} else {
var G__19920 = r__$1;
var G__19921 = res__$2;
G__19908__$1 = G__19920;
res__$1 = G__19921;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__19925 = coll;
var vec__19926 = G__19925;
var seq__19927 = cljs.core.seq.call(null,vec__19926);
var first__19928 = cljs.core.first.call(null,seq__19927);
var seq__19927__$1 = cljs.core.next.call(null,seq__19927);
var clause = first__19928;
var r = seq__19927__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19925__$1 = G__19925;
var res__$1 = res;
while(true){
var vec__19932 = G__19925__$1;
var seq__19933 = cljs.core.seq.call(null,vec__19932);
var first__19934 = cljs.core.first.call(null,seq__19933);
var seq__19933__$1 = cljs.core.next.call(null,seq__19933);
var clause__$1 = first__19934;
var r__$1 = seq__19933__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__19935 = r__$1;
var G__19936 = res__$2;
G__19925__$1 = G__19935;
res__$1 = G__19936;
continue;
} else {
var G__19937 = r__$1;
var G__19938 = cljs.core.conj.call(null,res__$2,clause__$1);
G__19925__$1 = G__19937;
res__$1 = G__19938;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__19941 = clause;
var G__19941__$1 = ((cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause)))?cljs.core.drop.call(null,(1),G__19941):G__19941);
var G__19941__$2 = clojure.string.join.call(null," ",G__19941__$1)
;
var G__19941__$3 = (function (p1__19939_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19939_SHARP_)," ."].join('');
}).call(null,G__19941__$2)
;
if(cljs.core.truth_(optional_QMARK_)){
return (function (p1__19940_SHARP_){
return ["OPTIONAL {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19940_SHARP_),"}"].join('');
}).call(null,G__19941__$3);
} else {
return G__19941__$3;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.call(null,(function (acc_str,prefix){
var pfx = cljs.core.symbol.call(null,[fluree.db.util.core.keyword__GT_str.call(null,cljs.core.key.call(null,prefix)),":"].join(''));
var source = cljs.core.symbol.call(null,cljs.core.val.call(null,prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map));
var map__19945 = opts;
var map__19945__$1 = cljs.core.__destructure_map.call(null,map__19945);
var limit = cljs.core.get.call(null,map__19945__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__19945__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.call(null,map__19945__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.call(null,map__19945__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.call(null,map__19945__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes.call(null,prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.call(null," ",cljs.core.map.call(null,(function (p1__19942_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19942_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.call(null," ",select_vars)].join('');
var where_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__19943_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__19943_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__19944_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__19944_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = language;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19959){
var state_val_19960 = (state_19959[(1)]);
if((state_val_19960 === (1))){
var inst_19946 = fluree.db.util.core.url_encode.call(null,query);
var inst_19947 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_19946)].join('');
var inst_19948 = ["User-Agent","Accept"];
var inst_19949 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_19950 = cljs.core.PersistentHashMap.fromArrays(inst_19948,inst_19949);
var inst_19951 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_19952 = [inst_19950,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_19953 = cljs.core.PersistentHashMap.fromArrays(inst_19951,inst_19952);
var inst_19954 = fluree.db.util.xhttp.get.call(null,inst_19947,inst_19953);
var state_19959__$1 = state_19959;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19959__$1,(2),inst_19954);
} else {
if((state_val_19960 === (2))){
var inst_19956 = (state_19959[(2)]);
var inst_19957 = fluree.db.util.async.throw_err.call(null,inst_19956);
var state_19959__$1 = state_19959;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19959__$1,inst_19957);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____0 = (function (){
var statearr_19961 = [null,null,null,null,null,null,null];
(statearr_19961[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__);

(statearr_19961[(1)] = (1));

return statearr_19961;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____1 = (function (state_19959){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19959);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e19962){var ex__2749__auto__ = e19962;
var statearr_19963_19966 = state_19959;
(statearr_19963_19966[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19959[(4)]))){
var statearr_19964_19967 = state_19959;
(statearr_19964_19967[(1)] = cljs.core.first.call(null,(state_19959[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19968 = state_19959;
state_19959 = G__19968;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__ = function(state_19959){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____1.call(this,state_19959);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_19965 = f__2769__auto__.call(null);
(statearr_19965[(6)] = c__2768__auto__);

return statearr_19965;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19986){
var state_val_19987 = (state_19986[(1)]);
if((state_val_19987 === (1))){
var inst_19969 = fluree.db.query.analytical_wikidata.submit_wikidata_query.call(null,query);
var state_19986__$1 = state_19986;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19986__$1,(2),inst_19969);
} else {
if((state_val_19987 === (2))){
var inst_19972 = (state_19986[(7)]);
var inst_19971 = (state_19986[(2)]);
var inst_19972__$1 = fluree.db.util.async.throw_err.call(null,inst_19971);
var inst_19973 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_19972__$1);
var inst_19974 = cljs.core.not_EQ_.call(null,(200),inst_19973);
var state_19986__$1 = (function (){var statearr_19988 = state_19986;
(statearr_19988[(7)] = inst_19972__$1);

return statearr_19988;
})();
if(inst_19974){
var statearr_19989_19998 = state_19986__$1;
(statearr_19989_19998[(1)] = (3));

} else {
var statearr_19990_19999 = state_19986__$1;
(statearr_19990_19999[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19987 === (3))){
var inst_19972 = (state_19986[(7)]);
var state_19986__$1 = state_19986;
var statearr_19991_20000 = state_19986__$1;
(statearr_19991_20000[(2)] = inst_19972);

(statearr_19991_20000[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19987 === (4))){
var inst_19972 = (state_19986[(7)]);
var inst_19977 = (function (){var body = inst_19972;
return (function (item){
return cljs.core.reduce.call(null,(function (acc,k_v){
return cljs.core.assoc.call(null,acc,cljs.core.key.call(null,k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_19978 = cljs.core.second.call(null,inst_19972);
var inst_19979 = cljs.core.second.call(null,inst_19978);
var inst_19980 = cljs.core.first.call(null,inst_19979);
var inst_19981 = cljs.core.second.call(null,inst_19980);
var inst_19982 = cljs.core.mapv.call(null,inst_19977,inst_19981);
var state_19986__$1 = state_19986;
var statearr_19992_20001 = state_19986__$1;
(statearr_19992_20001[(2)] = inst_19982);

(statearr_19992_20001[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19987 === (5))){
var inst_19984 = (state_19986[(2)]);
var state_19986__$1 = state_19986;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19986__$1,inst_19984);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____0 = (function (){
var statearr_19993 = [null,null,null,null,null,null,null,null];
(statearr_19993[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__);

(statearr_19993[(1)] = (1));

return statearr_19993;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____1 = (function (state_19986){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19986);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e19994){var ex__2749__auto__ = e19994;
var statearr_19995_20002 = state_19986;
(statearr_19995_20002[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19986[(4)]))){
var statearr_19996_20003 = state_19986;
(statearr_19996_20003[(1)] = cljs.core.first.call(null,(state_19986[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20004 = state_19986;
state_19986 = G__20004;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__ = function(state_19986){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____1.call(this,state_19986);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_19997 = f__2769__auto__.call(null);
(statearr_19997[(6)] = c__2768__auto__);

return statearr_19997;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.call(null,(function (p1__20005_SHARP_){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20005_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.call(null,(function (p1__20006_SHARP_){
return fluree.db.util.core.str__GT_keyword.call(null,cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20006_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.call(null,(function (res){
return cljs.core.map.call(null,(function (p1__20007_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(p1__20007_SHARP_.call(null,res));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20053){
var state_val_20054 = (state_20053[(1)]);
if((state_val_20054 === (7))){
var inst_20018 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt.call(null,matching_vars,matching_vals);
var state_20053__$1 = state_20053;
var statearr_20055_20083 = state_20053__$1;
(statearr_20055_20083[(2)] = inst_20018);

(statearr_20055_20083[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20054 === (1))){
var state_20053__$1 = state_20053;
var statearr_20056_20084 = state_20053__$1;
(statearr_20056_20084[(2)] = null);

(statearr_20056_20084[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20054 === (4))){
var inst_20008 = (state_20053[(2)]);
var state_20053__$1 = state_20053;
var statearr_20057_20085 = state_20053__$1;
(statearr_20057_20085[(2)] = inst_20008);

(statearr_20057_20085[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20054 === (15))){
var inst_20032 = (state_20053[(7)]);
var inst_20026 = (state_20053[(8)]);
var inst_20027 = (state_20053[(9)]);
var inst_20037 = (state_20053[(2)]);
var inst_20038 = cljs.core.subs.call(null,inst_20032,(0),inst_20037);
var inst_20039 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20040 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_20026);
var inst_20041 = [inst_20027,inst_20040];
var inst_20042 = cljs.core.PersistentHashMap.fromArrays(inst_20039,inst_20041);
var inst_20043 = cljs.core.ex_info.call(null,inst_20038,inst_20042);
var inst_20044 = (function(){throw inst_20043})();
var state_20053__$1 = state_20053;
var statearr_20058_20086 = state_20053__$1;
(statearr_20058_20086[(2)] = inst_20044);

(statearr_20058_20086[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20054 === (13))){
var inst_20031 = (state_20053[(10)]);
var state_20053__$1 = state_20053;
var statearr_20059_20087 = state_20053__$1;
(statearr_20059_20087[(2)] = inst_20031);

(statearr_20059_20087[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20054 === (6))){
var state_20053__$1 = state_20053;
var statearr_20060_20088 = state_20053__$1;
(statearr_20060_20088[(2)] = null);

(statearr_20060_20088[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20054 === (3))){
var inst_20051 = (state_20053[(2)]);
var state_20053__$1 = state_20053;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20053__$1,inst_20051);
} else {
if((state_val_20054 === (12))){
var inst_20048 = (state_20053[(2)]);
var _ = (function (){var statearr_20061 = state_20053;
(statearr_20061[(4)] = cljs.core.rest.call(null,(state_20053[(4)])));

return statearr_20061;
})();
var state_20053__$1 = state_20053;
var statearr_20062_20089 = state_20053__$1;
(statearr_20062_20089[(2)] = inst_20048);

(statearr_20062_20089[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20054 === (2))){
var _ = (function (){var statearr_20063 = state_20053;
(statearr_20063[(4)] = cljs.core.cons.call(null,(5),(state_20053[(4)])));

return statearr_20063;
})();
var inst_20015 = cljs.core.empty_QMARK_.call(null,matching_vars);
var state_20053__$1 = state_20053;
if(inst_20015){
var statearr_20064_20090 = state_20053__$1;
(statearr_20064_20090[(1)] = (6));

} else {
var statearr_20065_20091 = state_20053__$1;
(statearr_20065_20091[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20054 === (11))){
var inst_20026 = (state_20053[(8)]);
var inst_20046 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples.call(null,inst_20026,all_vars);
var state_20053__$1 = state_20053;
var statearr_20067_20092 = state_20053__$1;
(statearr_20067_20092[(2)] = inst_20046);

(statearr_20067_20092[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20054 === (9))){
var inst_20026 = (state_20053[(8)]);
var inst_20027 = (state_20053[(9)]);
var inst_20024 = (state_20053[(2)]);
var inst_20025 = fluree.db.util.async.throw_err.call(null,inst_20024);
var inst_20026__$1 = cljs.core.__destructure_map.call(null,inst_20025);
var inst_20027__$1 = cljs.core.get.call(null,inst_20026__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_20028 = cljs.core.get.call(null,inst_20026__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_20029 = cljs.core._EQ_.call(null,(400),inst_20027__$1);
var state_20053__$1 = (function (){var statearr_20068 = state_20053;
(statearr_20068[(11)] = inst_20028);

(statearr_20068[(8)] = inst_20026__$1);

(statearr_20068[(9)] = inst_20027__$1);

return statearr_20068;
})();
if(inst_20029){
var statearr_20069_20093 = state_20053__$1;
(statearr_20069_20093[(1)] = (10));

} else {
var statearr_20070_20094 = state_20053__$1;
(statearr_20070_20094[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20054 === (5))){
var _ = (function (){var statearr_20071 = state_20053;
(statearr_20071[(4)] = cljs.core.rest.call(null,(state_20053[(4)])));

return statearr_20071;
})();
var state_20053__$1 = state_20053;
var ex20066 = (state_20053__$1[(2)]);
var statearr_20072_20095 = state_20053__$1;
(statearr_20072_20095[(5)] = ex20066);


if((ex20066 instanceof Error)){
var statearr_20073_20096 = state_20053__$1;
(statearr_20073_20096[(1)] = (4));

(statearr_20073_20096[(5)] = null);

} else {
throw ex20066;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20054 === (14))){
var state_20053__$1 = state_20053;
var statearr_20074_20097 = state_20053__$1;
(statearr_20074_20097[(2)] = (1000));

(statearr_20074_20097[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20054 === (10))){
var inst_20031 = (state_20053[(10)]);
var inst_20028 = (state_20053[(11)]);
var inst_20026 = (state_20053[(8)]);
var inst_20031__$1 = cljs.core.count.call(null,inst_20028);
var inst_20032 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_20026);
var inst_20033 = (inst_20031__$1 < (1000));
var state_20053__$1 = (function (){var statearr_20075 = state_20053;
(statearr_20075[(10)] = inst_20031__$1);

(statearr_20075[(7)] = inst_20032);

return statearr_20075;
})();
if(cljs.core.truth_(inst_20033)){
var statearr_20076_20098 = state_20053__$1;
(statearr_20076_20098[(1)] = (13));

} else {
var statearr_20077_20099 = state_20053__$1;
(statearr_20077_20099[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20054 === (8))){
var inst_20020 = (state_20053[(2)]);
var inst_20021 = fluree.db.query.analytical_wikidata.generateWikiDataQuery.call(null,q_map,clauses,all_vars,inst_20020,optional_clauses);
var inst_20022 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query.call(null,inst_20021);
var state_20053__$1 = state_20053;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20053__$1,(9),inst_20022);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_20078 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20078[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__);

(statearr_20078[(1)] = (1));

return statearr_20078;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____1 = (function (state_20053){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20053);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20079){var ex__2749__auto__ = e20079;
var statearr_20080_20100 = state_20053;
(statearr_20080_20100[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20053[(4)]))){
var statearr_20081_20101 = state_20053;
(statearr_20081_20101[(1)] = cljs.core.first.call(null,(state_20053[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20102 = state_20053;
state_20053 = G__20102;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__ = function(state_20053){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____1.call(this,state_20053);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20082 = f__2769__auto__.call(null);
(statearr_20082[(6)] = c__2768__auto__);

return statearr_20082;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
