// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.analytical_parse');
goog.require('fluree.db.query.subject_crawl.core');
goog.require('fluree.db.query.fql_resp');
/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__24804 = arguments.length;
switch (G__24804) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol)));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2,arg3));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__24807 = arguments.length;
switch (G__24807) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__24809 = null;
var G__24809__0 = (function (){
return xf.call(null);
});
var G__24809__1 = (function (result){
return xf.call(null,result);
});
var G__24809__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return xf.call(null,result,flake);
});
G__24809 = function(result,flake){
switch(arguments.length){
case 0:
return G__24809__0.call(this);
case 1:
return G__24809__1.call(this,result);
case 2:
return G__24809__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24809.cljs$core$IFn$_invoke$arity$0 = G__24809__0;
G__24809.cljs$core$IFn$_invoke$arity$1 = G__24809__1;
G__24809.cljs$core$IFn$_invoke$arity$2 = G__24809__2;
return G__24809;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare.call(null,clojure.string.upper_case.call(null,a),clojure.string.upper_case.call(null,b));
if(cljs.core._EQ_.call(null,res,(0))){
return ((-1) * cljs.core.compare.call(null,a,b));
} else {
return res;
}
} else {
return cljs.core.compare.call(null,a,b);
}
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.call(null,(function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies.call(null,vars);
if(cljs.core.every_QMARK_.call(null,(function (p1__24810_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__24810_SHARP_);
}),cljs.core.vals.call(null,freqs))){
return vars;
} else {
var G__24814 = vars;
var vec__24815 = G__24814;
var seq__24816 = cljs.core.seq.call(null,vec__24815);
var first__24817 = cljs.core.first.call(null,seq__24816);
var seq__24816__$1 = cljs.core.next.call(null,seq__24816);
var var$ = first__24817;
var r = seq__24816__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__24814__$1 = G__24814;
var all_vars__$1 = all_vars;
while(true){
var vec__24821 = G__24814__$1;
var seq__24822 = cljs.core.seq.call(null,vec__24821);
var first__24823 = cljs.core.first.call(null,seq__24822);
var seq__24822__$1 = cljs.core.next.call(null,seq__24822);
var var$__$1 = first__24823;
var r__$1 = seq__24822__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not.call(null,var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_(cljs.core.set.call(null,all_vars__$2).call(null,var$__$1))){
var G__24824 = r__$1;
var G__24825 = cljs.core.conj.call(null,all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,all_vars__$2))].join(''));
G__24814__$1 = G__24824;
all_vars__$1 = G__24825;
continue;
} else {
var G__24826 = r__$1;
var G__24827 = cljs.core.conj.call(null,all_vars__$2,var$__$1);
G__24814__$1 = G__24826;
all_vars__$1 = G__24827;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,cljs.core.map.call(null,cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.call(null,(function (idx,select_item){
var temp__5804__auto__ = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5804__auto__)){
var query_map = temp__5804__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.call(null,pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__24828){
var vec__24829 = p__24828;
var tuple_index = cljs.core.nth.call(null,vec__24829,(0),null);
var query_map = cljs.core.nth.call(null,vec__24829,(1),null);
var temp__5804__auto__ = cljs.core.get.call(null,tuple_result,tuple_index);
if(cljs.core.truth_(temp__5804__auto__)){
var _id = temp__5804__auto__;
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24843){
var state_val_24844 = (state_24843[(1)]);
if((state_val_24844 === (1))){
var inst_24832 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24833 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_24834 = [query_map,_id,query_opts];
var inst_24835 = cljs.core.PersistentHashMap.fromArrays(inst_24833,inst_24834);
var inst_24836 = fluree.db.query.fql.query.call(null,db,inst_24835);
var state_24843__$1 = (function (){var statearr_24845 = state_24843;
(statearr_24845[(7)] = inst_24832);

return statearr_24845;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24843__$1,(2),inst_24836);
} else {
if((state_val_24844 === (2))){
var inst_24832 = (state_24843[(7)]);
var inst_24838 = (state_24843[(2)]);
var inst_24839 = fluree.db.util.async.throw_err.call(null,inst_24838);
var inst_24840 = [tuple_index,inst_24839];
var inst_24841 = (new cljs.core.PersistentVector(null,2,(5),inst_24832,inst_24840,null));
var state_24843__$1 = state_24843;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24843__$1,inst_24841);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__2746__auto____0 = (function (){
var statearr_24846 = [null,null,null,null,null,null,null,null];
(statearr_24846[(0)] = fluree$db$query$fql$expand_map_$_state_machine__2746__auto__);

(statearr_24846[(1)] = (1));

return statearr_24846;
});
var fluree$db$query$fql$expand_map_$_state_machine__2746__auto____1 = (function (state_24843){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24843);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24847){var ex__2749__auto__ = e24847;
var statearr_24848_24851 = state_24843;
(statearr_24848_24851[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24843[(4)]))){
var statearr_24849_24852 = state_24843;
(statearr_24849_24852[(1)] = cljs.core.first.call(null,(state_24843[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24853 = state_24843;
state_24843 = G__24853;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__2746__auto__ = function(state_24843){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__2746__auto____1.call(this,state_24843);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__2746__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__2746__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24850 = f__2769__auto__.call(null);
(statearr_24850[(6)] = c__2768__auto__);

return statearr_24850;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_.call(null,expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__24854 = expand_map_tuple;
var tuple_index = cljs.core.nth.call(null,vec__24854,(0),null);
var query_map_result = cljs.core.nth.call(null,vec__24854,(1),null);
return cljs.core.assoc.call(null,tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24917){
var state_val_24918 = (state_24917[(1)]);
if((state_val_24918 === (7))){
var inst_24912 = (state_24917[(2)]);
var _ = (function (){var statearr_24919 = state_24917;
(statearr_24919[(4)] = cljs.core.rest.call(null,(state_24917[(4)])));

return statearr_24919;
})();
var state_24917__$1 = state_24917;
var statearr_24920_25011 = state_24917__$1;
(statearr_24920_25011[(2)] = inst_24912);

(statearr_24920_25011[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24918 === (20))){
var inst_24903 = (state_24917[(2)]);
var state_24917__$1 = state_24917;
var statearr_24921_25012 = state_24917__$1;
(statearr_24921_25012[(2)] = inst_24903);

(statearr_24921_25012[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24918 === (1))){
var state_24917__$1 = state_24917;
var statearr_24922_25013 = state_24917__$1;
(statearr_24922_25013[(2)] = null);

(statearr_24922_25013[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24918 === (4))){
var inst_24859 = (state_24917[(2)]);
var state_24917__$1 = state_24917;
var statearr_24923_25014 = state_24917__$1;
(statearr_24923_25014[(2)] = inst_24859);

(statearr_24923_25014[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24918 === (15))){
var inst_24879 = (state_24917[(7)]);
var inst_24888 = cljs.core.second.call(null,inst_24879);
var inst_24889 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_24888);
var inst_24890 = (inst_24889 > max_fuel);
var state_24917__$1 = state_24917;
if(cljs.core.truth_(inst_24890)){
var statearr_24924_25015 = state_24917__$1;
(statearr_24924_25015[(1)] = (18));

} else {
var statearr_24925_25016 = state_24917__$1;
(statearr_24925_25016[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24918 === (13))){
var state_24917__$1 = state_24917;
var statearr_24926_25017 = state_24917__$1;
(statearr_24926_25017[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24918 === (6))){
var inst_24867 = (state_24917[(8)]);
var state_24917__$1 = state_24917;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24917__$1,(8),inst_24867);
} else {
if((state_val_24918 === (17))){
var inst_24906 = (state_24917[(2)]);
var state_24917__$1 = state_24917;
var statearr_24928_25018 = state_24917__$1;
(statearr_24928_25018[(2)] = inst_24906);

(statearr_24928_25018[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24918 === (3))){
var inst_24915 = (state_24917[(2)]);
var state_24917__$1 = state_24917;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24917__$1,inst_24915);
} else {
if((state_val_24918 === (12))){
var inst_24879 = (state_24917[(7)]);
var inst_24868 = (state_24917[(9)]);
var inst_24885 = inst_24868.call(null);
var state_24917__$1 = (function (){var statearr_24929 = state_24917;
(statearr_24929[(10)] = inst_24885);

return statearr_24929;
})();
var statearr_24930_25019 = state_24917__$1;
(statearr_24930_25019[(2)] = inst_24879);

(statearr_24930_25019[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24918 === (2))){
var inst_24867 = (state_24917[(8)]);
var inst_24868 = (state_24917[(9)]);
var _ = (function (){var statearr_24931 = state_24917;
(statearr_24931[(4)] = cljs.core.cons.call(null,(5),(state_24917[(4)])));

return statearr_24931;
})();
var inst_24865 = fluree.db.query.fql.build_expand_map.call(null,select,pp_keys);
var inst_24866 = cljs.core.async.chan.call(null);
var inst_24867__$1 = cljs.core.async.chan.call(null);
var inst_24868__$1 = (function (){var expandMaps = inst_24865;
var queue_ch = inst_24866;
var res_ch = inst_24867__$1;
return (function (){
cljs.core.async.close_BANG_.call(null,queue_ch);

return cljs.core.async.close_BANG_.call(null,res_ch);
});
})();
var inst_24869 = cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var inst_24870 = cljs.core.volatile_BANG_.call(null,(0));
var inst_24871 = cljs.core.assoc.call(null,inst_24869,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_24870);
var inst_24872 = (function (){var expandMaps = inst_24865;
var queue_ch = inst_24866;
var res_ch = inst_24867__$1;
var stop_BANG_ = inst_24868__$1;
var opts_STAR_ = inst_24871;
return (function (tuple_res,port){
var c__2768__auto____$1 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24964){
var state_val_24965 = (state_24964[(1)]);
if((state_val_24965 === (7))){
var state_24964__$1 = state_24964;
var statearr_24966_25020 = state_24964__$1;
(statearr_24966_25020[(2)] = tuple_res);

(statearr_24966_25020[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24965 === (1))){
var state_24964__$1 = state_24964;
var statearr_24967_25021 = state_24964__$1;
(statearr_24967_25021[(2)] = null);

(statearr_24967_25021[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24965 === (4))){
var inst_24932 = (state_24964[(2)]);
var inst_24933 = cljs.core.async.put_BANG_.call(null,port,inst_24932);
var inst_24934 = cljs.core.async.close_BANG_.call(null,port);
var state_24964__$1 = (function (){var statearr_24968 = state_24964;
(statearr_24968[(7)] = inst_24933);

return statearr_24968;
})();
var statearr_24969_25022 = state_24964__$1;
(statearr_24969_25022[(2)] = inst_24934);

(statearr_24969_25022[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24965 === (6))){
var inst_24941 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24942 = [tuple_res];
var inst_24943 = (new cljs.core.PersistentVector(null,1,(5),inst_24941,inst_24942,null));
var state_24964__$1 = state_24964;
var statearr_24970_25023 = state_24964__$1;
(statearr_24970_25023[(2)] = inst_24943);

(statearr_24970_25023[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24965 === (3))){
var inst_24962 = (state_24964[(2)]);
var state_24964__$1 = state_24964;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24964__$1,inst_24962);
} else {
if((state_val_24965 === (2))){
var ___$1 = (function (){var statearr_24972 = state_24964;
(statearr_24972[(4)] = cljs.core.cons.call(null,(5),(state_24964[(4)])));

return statearr_24972;
})();
var state_24964__$1 = state_24964;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_24973_25024 = state_24964__$1;
(statearr_24973_25024[(1)] = (6));

} else {
var statearr_24974_25025 = state_24964__$1;
(statearr_24974_25025[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24965 === (9))){
var inst_24946 = (state_24964[(8)]);
var inst_24948 = (state_24964[(9)]);
var inst_24955 = (state_24964[(2)]);
var inst_24956 = cljs.core.reduce.call(null,fluree.db.query.fql.replace_expand_maps,inst_24946,inst_24955);
var inst_24957 = inst_24948.call(null,inst_24956);
var inst_24958 = cljs.core.async.put_BANG_.call(null,port,inst_24957);
var inst_24959 = cljs.core.async.close_BANG_.call(null,port);
var ___$1 = (function (){var statearr_24975 = state_24964;
(statearr_24975[(4)] = cljs.core.rest.call(null,(state_24964[(4)])));

return statearr_24975;
})();
var state_24964__$1 = (function (){var statearr_24976 = state_24964;
(statearr_24976[(10)] = inst_24958);

return statearr_24976;
})();
var statearr_24977_25026 = state_24964__$1;
(statearr_24977_25026[(2)] = inst_24959);

(statearr_24977_25026[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24965 === (5))){
var ___$1 = (function (){var statearr_24978 = state_24964;
(statearr_24978[(4)] = cljs.core.rest.call(null,(state_24964[(4)])));

return statearr_24978;
})();
var state_24964__$1 = state_24964;
var ex24971 = (state_24964__$1[(2)]);
var statearr_24979_25027 = state_24964__$1;
(statearr_24979_25027[(5)] = ex24971);


var statearr_24980_25028 = state_24964__$1;
(statearr_24980_25028[(1)] = (4));

(statearr_24980_25028[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24965 === (8))){
var inst_24946 = (state_24964[(8)]);
var inst_24946__$1 = (state_24964[(2)]);
var inst_24947 = cljs.core.volatile_BANG_.call(null,(0));
var inst_24948 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24946__$1;
var query_fuel = inst_24947;
return (function (p1__24858_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,p1__24858_SHARP_),cljs.core.deref.call(null,query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__24858_SHARP_,cljs.core.deref.call(null,query_fuel)], null);
}
});
})();
var inst_24949 = cljs.core.PersistentVector.EMPTY;
var inst_24950 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24946__$1;
var query_fuel = inst_24947;
return (function (p1__24857_SHARP_){
return fluree.db.query.fql.expand_map.call(null,db,cljs.core.assoc.call(null,opts_STAR_,new cljs.core.Keyword(null,"fuel","fuel",10405485),fuel),tuple_res_SINGLEQUOTE_,p1__24857_SHARP_);
});
})();
var inst_24951 = cljs.core.keep.call(null,inst_24950,expandMaps);
var inst_24952 = cljs.core.async.merge.call(null,inst_24951);
var inst_24953 = cljs.core.async.into.call(null,inst_24949,inst_24952);
var state_24964__$1 = (function (){var statearr_24981 = state_24964;
(statearr_24981[(8)] = inst_24946__$1);

(statearr_24981[(9)] = inst_24948);

return statearr_24981;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24964__$1,(9),inst_24953);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0 = (function (){
var statearr_24982 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24982[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__);

(statearr_24982[(1)] = (1));

return statearr_24982;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1 = (function (state_24964){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24964);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24983){var ex__2749__auto__ = e24983;
var statearr_24984_25029 = state_24964;
(statearr_24984_25029[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24964[(4)]))){
var statearr_24985_25030 = state_24964;
(statearr_24985_25030[(1)] = cljs.core.first.call(null,(state_24964[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25031 = state_24964;
state_24964 = G__25031;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__ = function(state_24964){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1.call(this,state_24964);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24986 = f__2769__auto__.call(null);
(statearr_24986[(6)] = c__2768__auto____$1);

return statearr_24986;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto____$1;
});
})();
var inst_24873 = cljs.core.async.onto_chan_BANG_.call(null,inst_24866,tuples_res);
var inst_24874 = cljs.core.async.pipeline_async.call(null,parallelism,inst_24867__$1,inst_24872,inst_24866);
var inst_24875 = cljs.core.PersistentVector.EMPTY;
var inst_24876 = inst_24875;
var state_24917__$1 = (function (){var statearr_24987 = state_24917;
(statearr_24987[(11)] = inst_24873);

(statearr_24987[(12)] = inst_24876);

(statearr_24987[(13)] = inst_24874);

(statearr_24987[(8)] = inst_24867__$1);

(statearr_24987[(9)] = inst_24868__$1);

return statearr_24987;
})();
var statearr_24988_25032 = state_24917__$1;
(statearr_24988_25032[(2)] = null);

(statearr_24988_25032[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24918 === (19))){
var inst_24876 = (state_24917[(12)]);
var inst_24879 = (state_24917[(7)]);
var inst_24899 = cljs.core.first.call(null,inst_24879);
var inst_24900 = cljs.core.conj.call(null,inst_24876,inst_24899);
var inst_24876__$1 = inst_24900;
var state_24917__$1 = (function (){var statearr_24989 = state_24917;
(statearr_24989[(12)] = inst_24876__$1);

return statearr_24989;
})();
var statearr_24990_25033 = state_24917__$1;
(statearr_24990_25033[(2)] = null);

(statearr_24990_25033[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24918 === (11))){
var inst_24910 = (state_24917[(2)]);
var state_24917__$1 = state_24917;
var statearr_24992_25034 = state_24917__$1;
(statearr_24992_25034[(2)] = inst_24910);

(statearr_24992_25034[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24918 === (9))){
var inst_24876 = (state_24917[(12)]);
var state_24917__$1 = state_24917;
var statearr_24993_25035 = state_24917__$1;
(statearr_24993_25035[(2)] = inst_24876);

(statearr_24993_25035[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24918 === (5))){
var _ = (function (){var statearr_24994 = state_24917;
(statearr_24994[(4)] = cljs.core.rest.call(null,(state_24917[(4)])));

return statearr_24994;
})();
var state_24917__$1 = state_24917;
var ex24991 = (state_24917__$1[(2)]);
var statearr_24995_25036 = state_24917__$1;
(statearr_24995_25036[(5)] = ex24991);


if((ex24991 instanceof Error)){
var statearr_24996_25037 = state_24917__$1;
(statearr_24996_25037[(1)] = (4));

(statearr_24996_25037[(5)] = null);

} else {
throw ex24991;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24918 === (14))){
var inst_24908 = (state_24917[(2)]);
var state_24917__$1 = state_24917;
var statearr_24997_25038 = state_24917__$1;
(statearr_24997_25038[(2)] = inst_24908);

(statearr_24997_25038[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24918 === (16))){
var state_24917__$1 = state_24917;
var statearr_24998_25039 = state_24917__$1;
(statearr_24998_25039[(2)] = null);

(statearr_24998_25039[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24918 === (10))){
var inst_24879 = (state_24917[(7)]);
var inst_24883 = fluree.db.util.core.exception_QMARK_.call(null,inst_24879);
var state_24917__$1 = state_24917;
if(inst_24883){
var statearr_24999_25040 = state_24917__$1;
(statearr_24999_25040[(1)] = (12));

} else {
var statearr_25000_25041 = state_24917__$1;
(statearr_25000_25041[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24918 === (18))){
var inst_24868 = (state_24917[(9)]);
var inst_24892 = inst_24868.call(null);
var inst_24893 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_24894 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_24895 = [new cljs.core.Keyword("db","insufficient-fuel","db/insufficient-fuel",344386102),(400)];
var inst_24896 = cljs.core.PersistentHashMap.fromArrays(inst_24894,inst_24895);
var inst_24897 = cljs.core.ex_info.call(null,inst_24893,inst_24896);
var state_24917__$1 = (function (){var statearr_25001 = state_24917;
(statearr_25001[(14)] = inst_24892);

return statearr_25001;
})();
var statearr_25002_25042 = state_24917__$1;
(statearr_25002_25042[(2)] = inst_24897);

(statearr_25002_25042[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24918 === (8))){
var inst_24879 = (state_24917[(7)]);
var inst_24879__$1 = (state_24917[(2)]);
var inst_24880 = (inst_24879__$1 == null);
var state_24917__$1 = (function (){var statearr_25003 = state_24917;
(statearr_25003[(7)] = inst_24879__$1);

return statearr_25003;
})();
if(cljs.core.truth_(inst_24880)){
var statearr_25004_25043 = state_24917__$1;
(statearr_25004_25043[(1)] = (9));

} else {
var statearr_25005_25044 = state_24917__$1;
(statearr_25005_25044[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0 = (function (){
var statearr_25006 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25006[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__);

(statearr_25006[(1)] = (1));

return statearr_25006;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1 = (function (state_24917){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24917);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25007){var ex__2749__auto__ = e25007;
var statearr_25008_25045 = state_24917;
(statearr_25008_25045[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24917[(4)]))){
var statearr_25009_25046 = state_24917;
(statearr_25009_25046[(1)] = cljs.core.first.call(null,(state_24917[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25047 = state_24917;
state_24917 = G__25047;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__ = function(state_24917){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1.call(this,state_24917);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25010 = f__2769__auto__.call(null);
(statearr_25010[(6)] = c__2768__auto__);

return statearr_25010;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__25048 = select;
var map__25048__$1 = cljs.core.__destructure_map.call(null,map__25048);
var as = cljs.core.get.call(null,map__25048__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var variable = cljs.core.get.call(null,map__25048__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var value = cljs.core.get.call(null,map__25048__$1,new cljs.core.Keyword(null,"value","value",305978217));
var select_val = (function (){var or__5045__auto__ = as;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx.call(null,headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly.call(null,value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.call(null,tuple,idx);
}):(cljs.core.truth_(cljs.core.get.call(null,vars,select_val))?cljs.core.constantly.call(null,cljs.core.get.call(null,vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.call(null,cljs.core.juxt,cljs.core.map.call(null,cljs.core.partial.call(null,fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__25051 = orderBy;
var order = cljs.core.nth.call(null,vec__25051,(0),null);
var var$ = cljs.core.nth.call(null,vec__25051,(1),null);
var option = cljs.core.nth.call(null,vec__25051,(2),null);
var comparator = ((cljs.core._EQ_.call(null,"DESC",order))?(function (a,b){
return cljs.core.compare.call(null,b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.call(null,"NOCASE",clojure.string.upper_case.call(null,option))));
var keyfn = ((no_case_QMARK_)?(function (p1__25049_SHARP_){
return clojure.string.upper_case.call(null,cljs.core.nth.call(null,p1__25049_SHARP_,compare_idx));
}):(function (p1__25050_SHARP_){
return cljs.core.nth.call(null,p1__25050_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count.call(null,tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return cljs.core.sort_by.call(null,keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__25056 = arguments.length;
switch (G__25056) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__25057,p__25058,group_limit,opts){
var map__25059 = p__25057;
var map__25059__$1 = cljs.core.__destructure_map.call(null,map__25059);
var res = map__25059__$1;
var vars = cljs.core.get.call(null,map__25059__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__25060 = p__25058;
var map__25060__$1 = cljs.core.__destructure_map.call(null,map__25060);
var select_spec = map__25060__$1;
var inVector_QMARK_ = cljs.core.get.call(null,map__25060__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.call(null,map__25060__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__25060__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var expandMaps_QMARK_ = cljs.core.get.call(null,map__25060__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var limit = cljs.core.get.call(null,map__25060__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__25060__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.call(null,map__25060__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.call(null,map__25060__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__25060__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.call(null,map__25060__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25197){
var state_val_25198 = (state_25197[(1)]);
if((state_val_25198 === (7))){
var inst_25067 = (state_25197[(7)]);
var state_25197__$1 = state_25197;
var statearr_25199_25301 = state_25197__$1;
(statearr_25199_25301[(2)] = inst_25067);

(statearr_25199_25301[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (59))){
var inst_25190 = (state_25197[(2)]);
var state_25197__$1 = state_25197;
var statearr_25200_25302 = state_25197__$1;
(statearr_25200_25302[(2)] = inst_25190);

(statearr_25200_25302[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (20))){
var inst_25106 = (state_25197[(8)]);
var inst_25103 = (state_25197[(9)]);
var inst_25102 = (state_25197[(2)]);
var inst_25103__$1 = cljs.core.__destructure_map.call(null,inst_25102);
var inst_25104 = cljs.core.get.call(null,inst_25103__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_25105 = cljs.core.get.call(null,inst_25103__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_25106__$1 = offset;
var state_25197__$1 = (function (){var statearr_25201 = state_25197;
(statearr_25201[(10)] = inst_25104);

(statearr_25201[(8)] = inst_25106__$1);

(statearr_25201[(9)] = inst_25103__$1);

(statearr_25201[(11)] = inst_25105);

return statearr_25201;
})();
if(cljs.core.truth_(inst_25106__$1)){
var statearr_25202_25303 = state_25197__$1;
(statearr_25202_25303[(1)] = (21));

} else {
var statearr_25203_25304 = state_25197__$1;
(statearr_25203_25304[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (58))){
var inst_25182 = (state_25197[(12)]);
var state_25197__$1 = state_25197;
var statearr_25204_25305 = state_25197__$1;
(statearr_25204_25305[(2)] = inst_25182);

(statearr_25204_25305[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (60))){
var inst_25186 = (state_25197[(2)]);
var inst_25187 = fluree.db.util.async.throw_err.call(null,inst_25186);
var state_25197__$1 = state_25197;
var statearr_25205_25306 = state_25197__$1;
(statearr_25205_25306[(2)] = inst_25187);

(statearr_25205_25306[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (27))){
var inst_25118 = cljs.core.not.call(null,inVector_QMARK_);
var state_25197__$1 = state_25197;
var statearr_25206_25307 = state_25197__$1;
(statearr_25206_25307[(2)] = inst_25118);

(statearr_25206_25307[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (1))){
var state_25197__$1 = state_25197;
var statearr_25207_25308 = state_25197__$1;
(statearr_25207_25308[(2)] = null);

(statearr_25207_25308[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (24))){
var state_25197__$1 = state_25197;
var statearr_25208_25309 = state_25197__$1;
(statearr_25208_25309[(2)] = offset);

(statearr_25208_25309[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (55))){
var inst_25176 = (state_25197[(13)]);
var state_25197__$1 = state_25197;
var statearr_25209_25310 = state_25197__$1;
(statearr_25209_25310[(2)] = inst_25176);

(statearr_25209_25310[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (39))){
var inst_25144 = (state_25197[(14)]);
var inst_25146 = cljs.core.distinct.call(null);
var inst_25147 = cljs.core.conj.call(null,inst_25144,inst_25146);
var state_25197__$1 = state_25197;
var statearr_25210_25311 = state_25197__$1;
(statearr_25210_25311[(2)] = inst_25147);

(statearr_25210_25311[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (46))){
var inst_25156 = (state_25197[(15)]);
var state_25197__$1 = state_25197;
var statearr_25211_25312 = state_25197__$1;
(statearr_25211_25312[(2)] = inst_25156);

(statearr_25211_25312[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (4))){
var inst_25061 = (state_25197[(2)]);
var state_25197__$1 = state_25197;
var statearr_25212_25313 = state_25197__$1;
(statearr_25212_25313[(2)] = inst_25061);

(statearr_25212_25313[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (54))){
var inst_25170 = (state_25197[(16)]);
var inst_25176 = (state_25197[(13)]);
var inst_25178 = cljs.core.PersistentVector.EMPTY;
var inst_25179 = cljs.core.into.call(null,inst_25178,inst_25170,inst_25176);
var state_25197__$1 = state_25197;
var statearr_25213_25314 = state_25197__$1;
(statearr_25213_25314[(2)] = inst_25179);

(statearr_25213_25314[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (15))){
var inst_25088 = (state_25197[(17)]);
var inst_25090 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25091 = [inst_25088];
var inst_25092 = (new cljs.core.PersistentVector(null,1,(5),inst_25090,inst_25091,null));
var state_25197__$1 = state_25197;
var statearr_25214_25315 = state_25197__$1;
(statearr_25214_25315[(2)] = inst_25092);

(statearr_25214_25315[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (48))){
var inst_25162 = (state_25197[(18)]);
var inst_25104 = (state_25197[(10)]);
var inst_25121 = (state_25197[(19)]);
var inst_25126 = (state_25197[(20)]);
var inst_25103 = (state_25197[(9)]);
var inst_25115 = (state_25197[(21)]);
var inst_25105 = (state_25197[(11)]);
var inst_25164 = (function (){var map__25097 = inst_25103;
var headers = inst_25104;
var tuples = inst_25105;
var offset_SINGLEQUOTE_ = inst_25115;
var single_result_QMARK_ = inst_25121;
var pp_keys = inst_25126;
var G__25127 = inst_25162;
return (function (p1__25054_SHARP_){
return cljs.core.zipmap.call(null,fluree.db.query.fql.get_pretty_print_keys.call(null,select),p1__25054_SHARP_);
});
})();
var inst_25165 = cljs.core.map.call(null,inst_25164);
var inst_25166 = cljs.core.conj.call(null,inst_25162,inst_25165);
var state_25197__$1 = state_25197;
var statearr_25215_25316 = state_25197__$1;
(statearr_25215_25316[(2)] = inst_25166);

(statearr_25215_25316[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (50))){
var inst_25169 = (state_25197[(2)]);
var inst_25170 = cljs.core.apply.call(null,cljs.core.comp,inst_25169);
var state_25197__$1 = (function (){var statearr_25216 = state_25197;
(statearr_25216[(16)] = inst_25170);

return statearr_25216;
})();
if(cljs.core.truth_(orderBy)){
var statearr_25217_25317 = state_25197__$1;
(statearr_25217_25317[(1)] = (51));

} else {
var statearr_25218_25318 = state_25197__$1;
(statearr_25218_25318[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (21))){
var inst_25108 = cljs.core.not.call(null,groupBy);
var state_25197__$1 = state_25197;
var statearr_25219_25319 = state_25197__$1;
(statearr_25219_25319[(2)] = inst_25108);

(statearr_25219_25319[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (31))){
var state_25197__$1 = state_25197;
var statearr_25220_25320 = state_25197__$1;
(statearr_25220_25320[(2)] = null);

(statearr_25220_25320[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (32))){
var inst_25104 = (state_25197[(10)]);
var inst_25121 = (state_25197[(19)]);
var inst_25126 = (state_25197[(2)]);
var inst_25128 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25129 = fluree.db.query.fql.select_tuples_fn.call(null,inst_25104,vars,select);
var inst_25130 = cljs.core.map.call(null,inst_25129);
var inst_25131 = [inst_25130];
var inst_25132 = (new cljs.core.PersistentVector(null,1,(5),inst_25128,inst_25131,null));
var state_25197__$1 = (function (){var statearr_25221 = state_25197;
(statearr_25221[(20)] = inst_25126);

(statearr_25221[(22)] = inst_25132);

return statearr_25221;
})();
if(cljs.core.truth_(inst_25121)){
var statearr_25222_25321 = state_25197__$1;
(statearr_25222_25321[(1)] = (33));

} else {
var statearr_25223_25322 = state_25197__$1;
(statearr_25223_25322[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (40))){
var inst_25144 = (state_25197[(14)]);
var state_25197__$1 = state_25197;
var statearr_25224_25323 = state_25197__$1;
(statearr_25224_25323[(2)] = inst_25144);

(statearr_25224_25323[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (56))){
var inst_25182 = (state_25197[(2)]);
var state_25197__$1 = (function (){var statearr_25225 = state_25197;
(statearr_25225[(12)] = inst_25182);

return statearr_25225;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_25226_25324 = state_25197__$1;
(statearr_25226_25324[(1)] = (57));

} else {
var statearr_25227_25325 = state_25197__$1;
(statearr_25227_25325[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (33))){
var inst_25132 = (state_25197[(22)]);
var inst_25134 = cljs.core.map.call(null,cljs.core.first);
var inst_25135 = cljs.core.conj.call(null,inst_25132,inst_25134);
var state_25197__$1 = state_25197;
var statearr_25228_25326 = state_25197__$1;
(statearr_25228_25326[(2)] = inst_25135);

(statearr_25228_25326[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (13))){
var inst_25077 = (state_25197[(23)]);
var state_25197__$1 = state_25197;
var statearr_25229_25327 = state_25197__$1;
(statearr_25229_25327[(2)] = inst_25077);

(statearr_25229_25327[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (22))){
var inst_25106 = (state_25197[(8)]);
var state_25197__$1 = state_25197;
var statearr_25230_25328 = state_25197__$1;
(statearr_25230_25328[(2)] = inst_25106);

(statearr_25230_25328[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (36))){
var inst_25138 = (state_25197[(24)]);
var inst_25140 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel,(5));
var inst_25141 = cljs.core.conj.call(null,inst_25138,inst_25140);
var state_25197__$1 = state_25197;
var statearr_25231_25329 = state_25197__$1;
(statearr_25231_25329[(2)] = inst_25141);

(statearr_25231_25329[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (41))){
var inst_25115 = (state_25197[(21)]);
var inst_25150 = (state_25197[(2)]);
var state_25197__$1 = (function (){var statearr_25232 = state_25197;
(statearr_25232[(25)] = inst_25150);

return statearr_25232;
})();
if(cljs.core.truth_(inst_25115)){
var statearr_25233_25330 = state_25197__$1;
(statearr_25233_25330[(1)] = (42));

} else {
var statearr_25234_25331 = state_25197__$1;
(statearr_25234_25331[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (43))){
var inst_25150 = (state_25197[(25)]);
var state_25197__$1 = state_25197;
var statearr_25235_25332 = state_25197__$1;
(statearr_25235_25332[(2)] = inst_25150);

(statearr_25235_25332[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (29))){
var inst_25121 = (state_25197[(2)]);
var state_25197__$1 = (function (){var statearr_25236 = state_25197;
(statearr_25236[(19)] = inst_25121);

return statearr_25236;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25237_25333 = state_25197__$1;
(statearr_25237_25333[(1)] = (30));

} else {
var statearr_25238_25334 = state_25197__$1;
(statearr_25238_25334[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (44))){
var inst_25156 = (state_25197[(2)]);
var state_25197__$1 = (function (){var statearr_25239 = state_25197;
(statearr_25239[(15)] = inst_25156);

return statearr_25239;
})();
if(cljs.core.truth_(group_limit)){
var statearr_25240_25335 = state_25197__$1;
(statearr_25240_25335[(1)] = (45));

} else {
var statearr_25241_25336 = state_25197__$1;
(statearr_25241_25336[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (6))){
var inst_25069 = cljs.core.count.call(null,select);
var inst_25070 = cljs.core._EQ_.call(null,(1),inst_25069);
var state_25197__$1 = state_25197;
var statearr_25242_25337 = state_25197__$1;
(statearr_25242_25337[(2)] = inst_25070);

(statearr_25242_25337[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (28))){
var inst_25116 = (state_25197[(26)]);
var state_25197__$1 = state_25197;
var statearr_25243_25338 = state_25197__$1;
(statearr_25243_25338[(2)] = inst_25116);

(statearr_25243_25338[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (51))){
var inst_25104 = (state_25197[(10)]);
var inst_25105 = (state_25197[(11)]);
var inst_25173 = fluree.db.query.fql.order_result_tuples.call(null,fuel,max_fuel,inst_25104,orderBy,inst_25105);
var state_25197__$1 = state_25197;
var statearr_25244_25339 = state_25197__$1;
(statearr_25244_25339[(2)] = inst_25173);

(statearr_25244_25339[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (25))){
var state_25197__$1 = state_25197;
var statearr_25245_25340 = state_25197__$1;
(statearr_25245_25340[(2)] = null);

(statearr_25245_25340[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (34))){
var inst_25132 = (state_25197[(22)]);
var state_25197__$1 = state_25197;
var statearr_25246_25341 = state_25197__$1;
(statearr_25246_25341[(2)] = inst_25132);

(statearr_25246_25341[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (17))){
var inst_25095 = (state_25197[(2)]);
var state_25197__$1 = state_25197;
var statearr_25247_25342 = state_25197__$1;
(statearr_25247_25342[(2)] = inst_25095);

(statearr_25247_25342[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (3))){
var inst_25195 = (state_25197[(2)]);
var state_25197__$1 = state_25197;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25197__$1,inst_25195);
} else {
if((state_val_25198 === (12))){
var inst_25077 = (state_25197[(23)]);
var inst_25079 = cljs.core.first.call(null,select);
var inst_25080 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_25079);
var inst_25081 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25080);
var inst_25082 = cljs.core.subs.call(null,inst_25081,(1));
var inst_25083 = [inst_25082];
var inst_25084 = [inst_25077];
var inst_25085 = cljs.core.PersistentHashMap.fromArrays(inst_25083,inst_25084);
var state_25197__$1 = state_25197;
var statearr_25248_25343 = state_25197__$1;
(statearr_25248_25343[(2)] = inst_25085);

(statearr_25248_25343[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (2))){
var inst_25067 = (state_25197[(7)]);
var _ = (function (){var statearr_25249 = state_25197;
(statearr_25249[(4)] = cljs.core.cons.call(null,(5),(state_25197[(4)])));

return statearr_25249;
})();
var inst_25067__$1 = aggregates;
var state_25197__$1 = (function (){var statearr_25250 = state_25197;
(statearr_25250[(7)] = inst_25067__$1);

return statearr_25250;
})();
if(cljs.core.truth_(inst_25067__$1)){
var statearr_25251_25344 = state_25197__$1;
(statearr_25251_25344[(1)] = (6));

} else {
var statearr_25252_25345 = state_25197__$1;
(statearr_25252_25345[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (23))){
var inst_25111 = (state_25197[(2)]);
var state_25197__$1 = state_25197;
if(cljs.core.truth_(inst_25111)){
var statearr_25253_25346 = state_25197__$1;
(statearr_25253_25346[(1)] = (24));

} else {
var statearr_25254_25347 = state_25197__$1;
(statearr_25254_25347[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (47))){
var inst_25162 = (state_25197[(2)]);
var state_25197__$1 = (function (){var statearr_25255 = state_25197;
(statearr_25255[(18)] = inst_25162);

return statearr_25255;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25256_25348 = state_25197__$1;
(statearr_25256_25348[(1)] = (48));

} else {
var statearr_25257_25349 = state_25197__$1;
(statearr_25257_25349[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (35))){
var inst_25138 = (state_25197[(2)]);
var state_25197__$1 = (function (){var statearr_25258 = state_25197;
(statearr_25258[(24)] = inst_25138);

return statearr_25258;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25259_25350 = state_25197__$1;
(statearr_25259_25350[(1)] = (36));

} else {
var statearr_25260_25351 = state_25197__$1;
(statearr_25260_25351[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (19))){
var state_25197__$1 = state_25197;
var statearr_25261_25352 = state_25197__$1;
(statearr_25261_25352[(2)] = res);

(statearr_25261_25352[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (57))){
var inst_25121 = (state_25197[(19)]);
var inst_25182 = (state_25197[(12)]);
var inst_25126 = (state_25197[(20)]);
var inst_25184 = fluree.db.query.fql.pipeline_expandmaps_result.call(null,select,inst_25126,inst_25121,db,fuel,max_fuel,opts,(8),inst_25182);
var state_25197__$1 = state_25197;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25197__$1,(60),inst_25184);
} else {
if((state_val_25198 === (11))){
var inst_25192 = (state_25197[(2)]);
var _ = (function (){var statearr_25263 = state_25197;
(statearr_25263[(4)] = cljs.core.rest.call(null,(state_25197[(4)])));

return statearr_25263;
})();
var state_25197__$1 = state_25197;
var statearr_25264_25353 = state_25197__$1;
(statearr_25264_25353[(2)] = inst_25192);

(statearr_25264_25353[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (9))){
var inst_25075 = cljs.core.first.call(null,aggregates);
var inst_25076 = fluree.db.query.analytical.calculate_aggregate.call(null,res,inst_25075);
var inst_25077 = cljs.core.second.call(null,inst_25076);
var state_25197__$1 = (function (){var statearr_25265 = state_25197;
(statearr_25265[(23)] = inst_25077);

return statearr_25265;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25266_25354 = state_25197__$1;
(statearr_25266_25354[(1)] = (12));

} else {
var statearr_25267_25355 = state_25197__$1;
(statearr_25267_25355[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (5))){
var _ = (function (){var statearr_25268 = state_25197;
(statearr_25268[(4)] = cljs.core.rest.call(null,(state_25197[(4)])));

return statearr_25268;
})();
var state_25197__$1 = state_25197;
var ex25262 = (state_25197__$1[(2)]);
var statearr_25269_25356 = state_25197__$1;
(statearr_25269_25356[(5)] = ex25262);


if((ex25262 instanceof Error)){
var statearr_25270_25357 = state_25197__$1;
(statearr_25270_25357[(1)] = (4));

(statearr_25270_25357[(5)] = null);

} else {
throw ex25262;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (14))){
var inst_25088 = (state_25197[(2)]);
var state_25197__$1 = (function (){var statearr_25271 = state_25197;
(statearr_25271[(17)] = inst_25088);

return statearr_25271;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25272_25358 = state_25197__$1;
(statearr_25272_25358[(1)] = (15));

} else {
var statearr_25273_25359 = state_25197__$1;
(statearr_25273_25359[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (45))){
var inst_25156 = (state_25197[(15)]);
var inst_25158 = cljs.core.take.call(null,group_limit);
var inst_25159 = cljs.core.conj.call(null,inst_25156,inst_25158);
var state_25197__$1 = state_25197;
var statearr_25274_25360 = state_25197__$1;
(statearr_25274_25360[(2)] = inst_25159);

(statearr_25274_25360[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (53))){
var inst_25176 = (state_25197[(2)]);
var state_25197__$1 = (function (){var statearr_25275 = state_25197;
(statearr_25275[(13)] = inst_25176);

return statearr_25275;
})();
var statearr_25276_25361 = state_25197__$1;
(statearr_25276_25361[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (26))){
var inst_25116 = (state_25197[(26)]);
var inst_25115 = (state_25197[(2)]);
var inst_25116__$1 = cljs.core.not.call(null,prettyPrint);
var state_25197__$1 = (function (){var statearr_25278 = state_25197;
(statearr_25278[(26)] = inst_25116__$1);

(statearr_25278[(21)] = inst_25115);

return statearr_25278;
})();
if(inst_25116__$1){
var statearr_25279_25362 = state_25197__$1;
(statearr_25279_25362[(1)] = (27));

} else {
var statearr_25280_25363 = state_25197__$1;
(statearr_25280_25363[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (16))){
var inst_25088 = (state_25197[(17)]);
var state_25197__$1 = state_25197;
var statearr_25281_25364 = state_25197__$1;
(statearr_25281_25364[(2)] = inst_25088);

(statearr_25281_25364[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (38))){
var inst_25144 = (state_25197[(2)]);
var state_25197__$1 = (function (){var statearr_25282 = state_25197;
(statearr_25282[(14)] = inst_25144);

return statearr_25282;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25283_25365 = state_25197__$1;
(statearr_25283_25365[(1)] = (39));

} else {
var statearr_25284_25366 = state_25197__$1;
(statearr_25284_25366[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (30))){
var inst_25123 = fluree.db.query.fql.get_pretty_print_keys.call(null,select);
var state_25197__$1 = state_25197;
var statearr_25285_25367 = state_25197__$1;
(statearr_25285_25367[(2)] = inst_25123);

(statearr_25285_25367[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (10))){
var state_25197__$1 = state_25197;
if(cljs.core.truth_(aggregates)){
var statearr_25286_25368 = state_25197__$1;
(statearr_25286_25368[(1)] = (18));

} else {
var statearr_25287_25369 = state_25197__$1;
(statearr_25287_25369[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (18))){
var inst_25099 = fluree.db.query.analytical.add_aggregate_cols.call(null,res,aggregates);
var state_25197__$1 = state_25197;
var statearr_25288_25370 = state_25197__$1;
(statearr_25288_25370[(2)] = inst_25099);

(statearr_25288_25370[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (52))){
var inst_25105 = (state_25197[(11)]);
var state_25197__$1 = state_25197;
var statearr_25289_25371 = state_25197__$1;
(statearr_25289_25371[(2)] = inst_25105);

(statearr_25289_25371[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (42))){
var inst_25150 = (state_25197[(25)]);
var inst_25115 = (state_25197[(21)]);
var inst_25152 = cljs.core.drop.call(null,inst_25115);
var inst_25153 = cljs.core.conj.call(null,inst_25150,inst_25152);
var state_25197__$1 = state_25197;
var statearr_25290_25372 = state_25197__$1;
(statearr_25290_25372[(2)] = inst_25153);

(statearr_25290_25372[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (37))){
var inst_25138 = (state_25197[(24)]);
var state_25197__$1 = state_25197;
var statearr_25291_25373 = state_25197__$1;
(statearr_25291_25373[(2)] = inst_25138);

(statearr_25291_25373[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (8))){
var inst_25073 = (state_25197[(2)]);
var state_25197__$1 = state_25197;
if(cljs.core.truth_(inst_25073)){
var statearr_25292_25374 = state_25197__$1;
(statearr_25292_25374[(1)] = (9));

} else {
var statearr_25293_25375 = state_25197__$1;
(statearr_25293_25375[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25198 === (49))){
var inst_25162 = (state_25197[(18)]);
var state_25197__$1 = state_25197;
var statearr_25294_25376 = state_25197__$1;
(statearr_25294_25376[(2)] = inst_25162);

(statearr_25294_25376[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2746__auto__ = null;
var fluree$db$query$fql$state_machine__2746__auto____0 = (function (){
var statearr_25295 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25295[(0)] = fluree$db$query$fql$state_machine__2746__auto__);

(statearr_25295[(1)] = (1));

return statearr_25295;
});
var fluree$db$query$fql$state_machine__2746__auto____1 = (function (state_25197){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25197);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25296){var ex__2749__auto__ = e25296;
var statearr_25297_25377 = state_25197;
(statearr_25297_25377[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25197[(4)]))){
var statearr_25298_25378 = state_25197;
(statearr_25298_25378[(1)] = cljs.core.first.call(null,(state_25197[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25379 = state_25197;
state_25197 = G__25379;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2746__auto__ = function(state_25197){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2746__auto____1.call(this,state_25197);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2746__auto____0;
fluree$db$query$fql$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2746__auto____1;
return fluree$db$query$fql$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25299 = f__2769__auto__.call(null);
(statearr_25299[(6)] = c__2768__auto__);

return statearr_25299;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__25382,groupBy){
var map__25383 = p__25382;
var map__25383__$1 = cljs.core.__destructure_map.call(null,map__25383);
var res = map__25383__$1;
var headers = cljs.core.get.call(null,map__25383__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__25383__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__25384 = ((cljs.core.vector_QMARK_.call(null,groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.call(null,cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,groupBy)], null)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.call(null,vec__25384,(0),null);
var groupBy__$1 = cljs.core.nth.call(null,vec__25384,(1),null);
var group_idxs = cljs.core.map.call(null,(function (p1__25380_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__25380_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some.call(null,cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.call(null,(function (res__$1,tuple){
var k = cljs.core.map.call(null,(function (p1__25381_SHARP_){
return cljs.core.nth.call(null,tuple,p1__25381_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,k):cljs.core.first.call(null,k));
var v = tuple;
return cljs.core.assoc.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.conj.call(null,cljs.core.get.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__25387 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.call(null,vec__25387,(0),null);
var sortCriteria = cljs.core.nth.call(null,vec__25387,(1),null);
if(cljs.core._EQ_.call(null,sortCriteria,groupBy)){
if(cljs.core._EQ_.call(null,sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_.call(null,groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of.call(null,groupBy,sortCriteria);
if(cljs.core._EQ_.call(null,"DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx));
});
}
} else {
return null;

}
}
});
/**
 * groupBy statements can optionally have a 'having' statement which filters
 *   items within the group.
 */
fluree.db.query.fql.filter_having = (function fluree$db$query$fql$filter_having(p__25390,headers,group_map){
var map__25391 = p__25390;
var map__25391__$1 = cljs.core.__destructure_map.call(null,map__25391);
var having = map__25391__$1;
var params = cljs.core.get.call(null,map__25391__$1,new cljs.core.Keyword(null,"params","params",710516235));
var function$ = cljs.core.get.call(null,map__25391__$1,new cljs.core.Keyword(null,"function","function",-2127255473));
var idxs = fluree.db.query.analytical.get_tuple_indexes.call(null,params,headers);
var filtered = (function (){var G__25398 = group_map;
var vec__25399 = G__25398;
var seq__25400 = cljs.core.seq.call(null,vec__25399);
var first__25401 = cljs.core.first.call(null,seq__25400);
var seq__25400__$1 = cljs.core.next.call(null,seq__25400);
var vec__25402 = first__25401;
var k = cljs.core.nth.call(null,vec__25402,(0),null);
var tuples = cljs.core.nth.call(null,vec__25402,(1),null);
var r = seq__25400__$1;
var acc = cljs.core.PersistentArrayMap.EMPTY;
var G__25398__$1 = G__25398;
var acc__$1 = acc;
while(true){
var vec__25412 = G__25398__$1;
var seq__25413 = cljs.core.seq.call(null,vec__25412);
var first__25414 = cljs.core.first.call(null,seq__25413);
var seq__25413__$1 = cljs.core.next.call(null,seq__25413);
var vec__25415 = first__25414;
var k__$1 = cljs.core.nth.call(null,vec__25415,(0),null);
var tuples__$1 = cljs.core.nth.call(null,vec__25415,(1),null);
var r__$1 = seq__25413__$1;
var acc__$2 = acc__$1;
if(cljs.core.truth_(k__$1)){
var argument = cljs.core.flatten.call(null,fluree.db.query.analytical.transform_tuples_to_idxs.call(null,idxs,tuples__$1));
var res = (function (){try{return function$.call(null,argument);
}catch (e25418){var e = e25418;
fluree.db.util.log.error.call(null,e,["Error procesing fn: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402).cljs$core$IFn$_invoke$arity$1(having))," with argument: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(argument)].join(''));

throw cljs.core.ex_info.call(null,["Error executing having function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402).cljs$core$IFn$_invoke$arity$1(having))," with error message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.ex_message.call(null,e))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}})();
if(cljs.core.truth_(res)){
var G__25419 = r__$1;
var G__25420 = cljs.core.assoc.call(null,acc__$2,k__$1,tuples__$1);
G__25398__$1 = G__25419;
acc__$1 = G__25420;
continue;
} else {
var G__25421 = r__$1;
var G__25422 = acc__$2;
G__25398__$1 = G__25421;
acc__$1 = G__25422;
continue;
}
} else {
return acc__$2;
}
break;
}
})();
return filtered;
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__25423,p__25424,opts){
var map__25425 = p__25423;
var map__25425__$1 = cljs.core.__destructure_map.call(null,map__25425);
var res = map__25425__$1;
var headers = cljs.core.get.call(null,map__25425__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__25425__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__25426 = p__25424;
var map__25426__$1 = cljs.core.__destructure_map.call(null,map__25426);
var select_spec = map__25426__$1;
var groupBy = cljs.core.get.call(null,map__25426__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.call(null,map__25426__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.call(null,map__25426__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.call(null,map__25426__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__25426__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.call(null,map__25426__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.call(null,map__25426__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var having = cljs.core.get.call(null,map__25426__$1,new cljs.core.Keyword(null,"having","having",-399543166));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25550){
var state_val_25551 = (state_25550[(1)]);
if((state_val_25551 === (7))){
var state_25550__$1 = state_25550;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25552_25625 = state_25550__$1;
(statearr_25552_25625[(1)] = (30));

} else {
var statearr_25553_25626 = state_25550__$1;
(statearr_25553_25626[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (20))){
var inst_25457 = (state_25550[(2)]);
var state_25550__$1 = (function (){var statearr_25554 = state_25550;
(statearr_25554[(7)] = inst_25457);

return statearr_25554;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25555_25627 = state_25550__$1;
(statearr_25555_25627[(1)] = (21));

} else {
var statearr_25556_25628 = state_25550__$1;
(statearr_25556_25628[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (27))){
var inst_25483 = (state_25550[(8)]);
var state_25550__$1 = state_25550;
var statearr_25557_25629 = state_25550__$1;
(statearr_25557_25629[(2)] = inst_25483);

(statearr_25557_25629[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (1))){
var state_25550__$1 = state_25550;
var statearr_25558_25630 = state_25550__$1;
(statearr_25558_25630[(2)] = null);

(statearr_25558_25630[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (24))){
var inst_25494 = (state_25550[(9)]);
var inst_25482 = (state_25550[(10)]);
var inst_25491 = cljs.core.seq.call(null,inst_25482);
var inst_25492 = cljs.core.first.call(null,inst_25491);
var inst_25493 = cljs.core.next.call(null,inst_25491);
var inst_25494__$1 = cljs.core.nth.call(null,inst_25492,(0),null);
var inst_25495 = cljs.core.nth.call(null,inst_25492,(1),null);
var state_25550__$1 = (function (){var statearr_25559 = state_25550;
(statearr_25559[(9)] = inst_25494__$1);

(statearr_25559[(11)] = inst_25493);

(statearr_25559[(12)] = inst_25495);

return statearr_25559;
})();
if(cljs.core.truth_(inst_25494__$1)){
var statearr_25560_25631 = state_25550__$1;
(statearr_25560_25631[(1)] = (26));

} else {
var statearr_25561_25632 = state_25550__$1;
(statearr_25561_25632[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (39))){
var inst_25531 = (state_25550[(2)]);
var state_25550__$1 = state_25550;
var statearr_25562_25633 = state_25550__$1;
(statearr_25562_25633[(2)] = inst_25531);

(statearr_25562_25633[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (4))){
var inst_25427 = (state_25550[(2)]);
var state_25550__$1 = state_25550;
var statearr_25563_25634 = state_25550__$1;
(statearr_25563_25634[(2)] = inst_25427);

(statearr_25563_25634[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (15))){
var inst_25447 = (state_25550[(13)]);
var inst_25449 = cljs.core.drop.call(null,offset,inst_25447);
var state_25550__$1 = state_25550;
var statearr_25564_25635 = state_25550__$1;
(statearr_25564_25635[(2)] = inst_25449);

(statearr_25564_25635[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (21))){
var inst_25457 = (state_25550[(7)]);
var inst_25459 = cljs.core.take.call(null,(1),inst_25457);
var state_25550__$1 = state_25550;
var statearr_25565_25636 = state_25550__$1;
(statearr_25565_25636[(2)] = inst_25459);

(statearr_25565_25636[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (31))){
var state_25550__$1 = state_25550;
var statearr_25566_25637 = state_25550__$1;
(statearr_25566_25637[(2)] = limit);

(statearr_25566_25637[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (32))){
var inst_25517 = (state_25550[(2)]);
var inst_25518 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,res,select_spec,inst_25517,opts);
var state_25550__$1 = state_25550;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25550__$1,(33),inst_25518);
} else {
if((state_val_25551 === (40))){
var inst_25521 = (state_25550[(14)]);
var inst_25534 = cljs.core.first.call(null,inst_25521);
var state_25550__$1 = state_25550;
var statearr_25567_25638 = state_25550__$1;
(statearr_25567_25638[(2)] = inst_25534);

(statearr_25567_25638[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (33))){
var inst_25521 = (state_25550[(14)]);
var inst_25520 = (state_25550[(2)]);
var inst_25521__$1 = fluree.db.util.async.throw_err.call(null,inst_25520);
var inst_25522 = cljs.core.coll_QMARK_.call(null,inst_25521__$1);
var inst_25523 = (!(inst_25522));
var state_25550__$1 = (function (){var statearr_25568 = state_25550;
(statearr_25568[(14)] = inst_25521__$1);

return statearr_25568;
})();
if(inst_25523){
var statearr_25569_25639 = state_25550__$1;
(statearr_25569_25639[(1)] = (34));

} else {
var statearr_25570_25640 = state_25550__$1;
(statearr_25570_25640[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (13))){
var inst_25442 = (state_25550[(15)]);
var state_25550__$1 = state_25550;
var statearr_25571_25641 = state_25550__$1;
(statearr_25571_25641[(2)] = inst_25442);

(statearr_25571_25641[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (22))){
var inst_25457 = (state_25550[(7)]);
var state_25550__$1 = state_25550;
var statearr_25572_25642 = state_25550__$1;
(statearr_25572_25642[(2)] = inst_25457);

(statearr_25572_25642[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (36))){
var inst_25543 = (state_25550[(2)]);
var state_25550__$1 = state_25550;
var statearr_25573_25643 = state_25550__$1;
(statearr_25573_25643[(2)] = inst_25543);

(statearr_25573_25643[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (41))){
var state_25550__$1 = state_25550;
var statearr_25574_25644 = state_25550__$1;
(statearr_25574_25644[(1)] = (43));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (43))){
var inst_25521 = (state_25550[(14)]);
var state_25550__$1 = state_25550;
var statearr_25576_25645 = state_25550__$1;
(statearr_25576_25645[(2)] = inst_25521);

(statearr_25576_25645[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (29))){
var inst_25494 = (state_25550[(9)]);
var inst_25493 = (state_25550[(11)]);
var inst_25483 = (state_25550[(8)]);
var inst_25504 = (state_25550[(2)]);
var inst_25505 = fluree.db.util.async.throw_err.call(null,inst_25504);
var inst_25506 = cljs.core.assoc.call(null,inst_25483,inst_25494,inst_25505);
var inst_25482 = inst_25493;
var inst_25483__$1 = inst_25506;
var state_25550__$1 = (function (){var statearr_25577 = state_25550;
(statearr_25577[(10)] = inst_25482);

(statearr_25577[(8)] = inst_25483__$1);

return statearr_25577;
})();
var statearr_25578_25646 = state_25550__$1;
(statearr_25578_25646[(2)] = null);

(statearr_25578_25646[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (44))){
var state_25550__$1 = state_25550;
var statearr_25579_25647 = state_25550__$1;
(statearr_25579_25647[(2)] = null);

(statearr_25579_25647[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (6))){
var inst_25434 = (state_25550[(16)]);
var inst_25434__$1 = fluree.db.query.fql.build_order_fn.call(null,orderBy,groupBy);
var inst_25436 = fluree.db.query.fql.ad_hoc_group_by.call(null,res,groupBy);
var state_25550__$1 = (function (){var statearr_25580 = state_25550;
(statearr_25580[(17)] = inst_25436);

(statearr_25580[(16)] = inst_25434__$1);

return statearr_25580;
})();
if(cljs.core.truth_(inst_25434__$1)){
var statearr_25581_25648 = state_25550__$1;
(statearr_25581_25648[(1)] = (9));

} else {
var statearr_25582_25649 = state_25550__$1;
(statearr_25582_25649[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (28))){
var inst_25510 = (state_25550[(2)]);
var state_25550__$1 = state_25550;
var statearr_25583_25650 = state_25550__$1;
(statearr_25583_25650[(2)] = inst_25510);

(statearr_25583_25650[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (25))){
var inst_25512 = (state_25550[(2)]);
var state_25550__$1 = state_25550;
var statearr_25584_25651 = state_25550__$1;
(statearr_25584_25651[(2)] = inst_25512);

(statearr_25584_25651[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (34))){
var state_25550__$1 = state_25550;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25585_25652 = state_25550__$1;
(statearr_25585_25652[(1)] = (37));

} else {
var statearr_25586_25653 = state_25550__$1;
(statearr_25586_25653[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (17))){
var inst_25452 = (state_25550[(2)]);
var state_25550__$1 = (function (){var statearr_25587 = state_25550;
(statearr_25587[(18)] = inst_25452);

return statearr_25587;
})();
if(cljs.core.truth_(limit)){
var statearr_25588_25654 = state_25550__$1;
(statearr_25588_25654[(1)] = (18));

} else {
var statearr_25589_25655 = state_25550__$1;
(statearr_25589_25655[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (3))){
var inst_25548 = (state_25550[(2)]);
var state_25550__$1 = state_25550;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25550__$1,inst_25548);
} else {
if((state_val_25551 === (12))){
var inst_25442 = (state_25550[(15)]);
var inst_25444 = fluree.db.query.fql.filter_having.call(null,having,headers,inst_25442);
var state_25550__$1 = state_25550;
var statearr_25590_25656 = state_25550__$1;
(statearr_25590_25656[(2)] = inst_25444);

(statearr_25590_25656[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (2))){
var _ = (function (){var statearr_25591 = state_25550;
(statearr_25591[(4)] = cljs.core.cons.call(null,(5),(state_25550[(4)])));

return statearr_25591;
})();
var state_25550__$1 = state_25550;
if(cljs.core.truth_(groupBy)){
var statearr_25592_25657 = state_25550__$1;
(statearr_25592_25657[(1)] = (6));

} else {
var statearr_25593_25658 = state_25550__$1;
(statearr_25593_25658[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (23))){
var inst_25462 = (state_25550[(2)]);
var inst_25476 = cljs.core.seq.call(null,inst_25462);
var inst_25477 = cljs.core.first.call(null,inst_25476);
var inst_25478 = cljs.core.next.call(null,inst_25476);
var inst_25479 = cljs.core.nth.call(null,inst_25477,(0),null);
var inst_25480 = cljs.core.nth.call(null,inst_25477,(1),null);
var inst_25481 = cljs.core.PersistentHashMap.EMPTY;
var inst_25482 = inst_25462;
var inst_25483 = inst_25481;
var state_25550__$1 = (function (){var statearr_25594 = state_25550;
(statearr_25594[(19)] = inst_25478);

(statearr_25594[(10)] = inst_25482);

(statearr_25594[(20)] = inst_25480);

(statearr_25594[(21)] = inst_25479);

(statearr_25594[(8)] = inst_25483);

return statearr_25594;
})();
var statearr_25595_25659 = state_25550__$1;
(statearr_25595_25659[(2)] = null);

(statearr_25595_25659[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (35))){
var state_25550__$1 = state_25550;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25596_25660 = state_25550__$1;
(statearr_25596_25660[(1)] = (40));

} else {
var statearr_25597_25661 = state_25550__$1;
(statearr_25597_25661[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (19))){
var inst_25452 = (state_25550[(18)]);
var state_25550__$1 = state_25550;
var statearr_25598_25662 = state_25550__$1;
(statearr_25598_25662[(2)] = inst_25452);

(statearr_25598_25662[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (11))){
var inst_25442 = (state_25550[(2)]);
var state_25550__$1 = (function (){var statearr_25600 = state_25550;
(statearr_25600[(15)] = inst_25442);

return statearr_25600;
})();
if(cljs.core.truth_(having)){
var statearr_25601_25663 = state_25550__$1;
(statearr_25601_25663[(1)] = (12));

} else {
var statearr_25602_25664 = state_25550__$1;
(statearr_25602_25664[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (9))){
var inst_25436 = (state_25550[(17)]);
var inst_25434 = (state_25550[(16)]);
var inst_25438 = cljs.core.sorted_map_by.call(null,inst_25434);
var inst_25439 = cljs.core.into.call(null,inst_25438,inst_25436);
var state_25550__$1 = state_25550;
var statearr_25603_25665 = state_25550__$1;
(statearr_25603_25665[(2)] = inst_25439);

(statearr_25603_25665[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (5))){
var _ = (function (){var statearr_25604 = state_25550;
(statearr_25604[(4)] = cljs.core.rest.call(null,(state_25550[(4)])));

return statearr_25604;
})();
var state_25550__$1 = state_25550;
var ex25599 = (state_25550__$1[(2)]);
var statearr_25605_25666 = state_25550__$1;
(statearr_25605_25666[(5)] = ex25599);


if((ex25599 instanceof Error)){
var statearr_25606_25667 = state_25550__$1;
(statearr_25606_25667[(1)] = (4));

(statearr_25606_25667[(5)] = null);

} else {
throw ex25599;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (14))){
var inst_25447 = (state_25550[(2)]);
var state_25550__$1 = (function (){var statearr_25607 = state_25550;
(statearr_25607[(13)] = inst_25447);

return statearr_25607;
})();
if(cljs.core.truth_(offset)){
var statearr_25608_25668 = state_25550__$1;
(statearr_25608_25668[(1)] = (15));

} else {
var statearr_25609_25669 = state_25550__$1;
(statearr_25609_25669[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (45))){
var inst_25539 = (state_25550[(2)]);
var state_25550__$1 = state_25550;
var statearr_25610_25670 = state_25550__$1;
(statearr_25610_25670[(2)] = inst_25539);

(statearr_25610_25670[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (26))){
var inst_25495 = (state_25550[(12)]);
var inst_25497 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_25498 = [headers,vars,inst_25495];
var inst_25499 = cljs.core.PersistentHashMap.fromArrays(inst_25497,inst_25498);
var inst_25500 = cljs.core.assoc.call(null,select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_25501 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_25502 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,inst_25499,inst_25500,inst_25501);
var state_25550__$1 = state_25550;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25550__$1,(29),inst_25502);
} else {
if((state_val_25551 === (16))){
var inst_25447 = (state_25550[(13)]);
var state_25550__$1 = state_25550;
var statearr_25611_25671 = state_25550__$1;
(statearr_25611_25671[(2)] = inst_25447);

(statearr_25611_25671[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (38))){
var inst_25521 = (state_25550[(14)]);
var state_25550__$1 = state_25550;
var statearr_25612_25672 = state_25550__$1;
(statearr_25612_25672[(2)] = inst_25521);

(statearr_25612_25672[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (30))){
var state_25550__$1 = state_25550;
var statearr_25613_25673 = state_25550__$1;
(statearr_25613_25673[(2)] = (1));

(statearr_25613_25673[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (10))){
var inst_25436 = (state_25550[(17)]);
var state_25550__$1 = state_25550;
var statearr_25614_25674 = state_25550__$1;
(statearr_25614_25674[(2)] = inst_25436);

(statearr_25614_25674[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (18))){
var inst_25452 = (state_25550[(18)]);
var inst_25454 = cljs.core.take.call(null,limit,inst_25452);
var state_25550__$1 = state_25550;
var statearr_25615_25675 = state_25550__$1;
(statearr_25615_25675[(2)] = inst_25454);

(statearr_25615_25675[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (42))){
var inst_25541 = (state_25550[(2)]);
var state_25550__$1 = state_25550;
var statearr_25616_25676 = state_25550__$1;
(statearr_25616_25676[(2)] = inst_25541);

(statearr_25616_25676[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (37))){
var inst_25521 = (state_25550[(14)]);
var inst_25526 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25527 = [inst_25521];
var inst_25528 = (new cljs.core.PersistentVector(null,1,(5),inst_25526,inst_25527,null));
var state_25550__$1 = state_25550;
var statearr_25617_25677 = state_25550__$1;
(statearr_25617_25677[(2)] = inst_25528);

(statearr_25617_25677[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25551 === (8))){
var inst_25545 = (state_25550[(2)]);
var _ = (function (){var statearr_25618 = state_25550;
(statearr_25618[(4)] = cljs.core.rest.call(null,(state_25550[(4)])));

return statearr_25618;
})();
var state_25550__$1 = state_25550;
var statearr_25619_25678 = state_25550__$1;
(statearr_25619_25678[(2)] = inst_25545);

(statearr_25619_25678[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____0 = (function (){
var statearr_25620 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25620[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__);

(statearr_25620[(1)] = (1));

return statearr_25620;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____1 = (function (state_25550){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25550);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25621){var ex__2749__auto__ = e25621;
var statearr_25622_25679 = state_25550;
(statearr_25622_25679[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25550[(4)]))){
var statearr_25623_25680 = state_25550;
(statearr_25623_25680[(1)] = cljs.core.first.call(null,(state_25550[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25681 = state_25550;
state_25550 = G__25681;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__ = function(state_25550){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____1.call(this,state_25550);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25624 = f__2769__auto__.call(null);
(statearr_25624[(6)] = c__2768__auto__);

return statearr_25624;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.fql.process_ad_hoc_query = (function fluree$db$query$fql$process_ad_hoc_query(p__25682){
var map__25683 = p__25682;
var map__25683__$1 = cljs.core.__destructure_map.call(null,map__25683);
var opts = map__25683__$1;
var db = cljs.core.get.call(null,map__25683__$1,new cljs.core.Keyword(null,"db","db",993250759));
var parsed_query = cljs.core.get.call(null,map__25683__$1,new cljs.core.Keyword(null,"parsed-query","parsed-query",-428212689));
var fuel = cljs.core.get.call(null,map__25683__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485));
var max_fuel = cljs.core.get.call(null,map__25683__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25703){
var state_val_25704 = (state_25703[(1)]);
if((state_val_25704 === (1))){
var state_25703__$1 = state_25703;
var statearr_25705_25719 = state_25703__$1;
(statearr_25705_25719[(2)] = null);

(statearr_25705_25719[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25704 === (2))){
var _ = (function (){var statearr_25706 = state_25703;
(statearr_25706[(4)] = cljs.core.cons.call(null,(5),(state_25703[(4)])));

return statearr_25706;
})();
var inst_25690 = fluree.db.query.analytical.q.call(null,opts);
var state_25703__$1 = state_25703;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25703__$1,(6),inst_25690);
} else {
if((state_val_25704 === (3))){
var inst_25701 = (state_25703[(2)]);
var state_25703__$1 = state_25703;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25703__$1,inst_25701);
} else {
if((state_val_25704 === (4))){
var inst_25684 = (state_25703[(2)]);
var state_25703__$1 = state_25703;
var statearr_25708_25720 = state_25703__$1;
(statearr_25708_25720[(2)] = inst_25684);

(statearr_25708_25720[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25704 === (5))){
var _ = (function (){var statearr_25709 = state_25703;
(statearr_25709[(4)] = cljs.core.rest.call(null,(state_25703[(4)])));

return statearr_25709;
})();
var state_25703__$1 = state_25703;
var ex25707 = (state_25703__$1[(2)]);
var statearr_25710_25721 = state_25703__$1;
(statearr_25710_25721[(5)] = ex25707);


if((ex25707 instanceof Error)){
var statearr_25711_25722 = state_25703__$1;
(statearr_25711_25722[(1)] = (4));

(statearr_25711_25722[(5)] = null);

} else {
throw ex25707;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25704 === (6))){
var inst_25692 = (state_25703[(2)]);
var inst_25693 = fluree.db.util.async.throw_err.call(null,inst_25692);
var inst_25694 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(parsed_query);
var inst_25695 = fluree.db.query.fql.process_ad_hoc_res.call(null,db,fuel,max_fuel,inst_25693,inst_25694,opts);
var state_25703__$1 = state_25703;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25703__$1,(7),inst_25695);
} else {
if((state_val_25704 === (7))){
var inst_25697 = (state_25703[(2)]);
var inst_25698 = fluree.db.util.async.throw_err.call(null,inst_25697);
var _ = (function (){var statearr_25712 = state_25703;
(statearr_25712[(4)] = cljs.core.rest.call(null,(state_25703[(4)])));

return statearr_25712;
})();
var state_25703__$1 = state_25703;
var statearr_25713_25723 = state_25703__$1;
(statearr_25713_25723[(2)] = inst_25698);

(statearr_25713_25723[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2746__auto____0 = (function (){
var statearr_25714 = [null,null,null,null,null,null,null];
(statearr_25714[(0)] = fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2746__auto__);

(statearr_25714[(1)] = (1));

return statearr_25714;
});
var fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2746__auto____1 = (function (state_25703){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25703);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25715){var ex__2749__auto__ = e25715;
var statearr_25716_25724 = state_25703;
(statearr_25716_25724[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25703[(4)]))){
var statearr_25717_25725 = state_25703;
(statearr_25717_25725[(1)] = cljs.core.first.call(null,(state_25703[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25726 = state_25703;
state_25703 = G__25726;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2746__auto__ = function(state_25703){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2746__auto____1.call(this,state_25703);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2746__auto____0;
fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2746__auto____1;
return fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25718 = f__2769__auto__.call(null);
(statearr_25718[(6)] = c__2768__auto__);

return statearr_25718;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.fql.relationship_binding = (function fluree$db$query$fql$relationship_binding(p__25727){
var map__25728 = p__25727;
var map__25728__$1 = cljs.core.__destructure_map.call(null,map__25728);
var opts = map__25728__$1;
var vars = cljs.core.get.call(null,map__25728__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25764){
var state_val_25765 = (state_25764[(1)]);
if((state_val_25765 === (1))){
var inst_25736 = vars;
var inst_25737 = cljs.core.seq.call(null,inst_25736);
var inst_25738 = cljs.core.first.call(null,inst_25737);
var inst_25739 = cljs.core.next.call(null,inst_25737);
var inst_25740 = cljs.core.PersistentVector.EMPTY;
var inst_25741 = inst_25736;
var inst_25742 = inst_25740;
var state_25764__$1 = (function (){var statearr_25766 = state_25764;
(statearr_25766[(7)] = inst_25741);

(statearr_25766[(8)] = inst_25738);

(statearr_25766[(9)] = inst_25739);

(statearr_25766[(10)] = inst_25742);

return statearr_25766;
})();
var statearr_25767_25780 = state_25764__$1;
(statearr_25767_25780[(2)] = null);

(statearr_25767_25780[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25765 === (2))){
var inst_25748 = (state_25764[(11)]);
var inst_25741 = (state_25764[(7)]);
var inst_25747 = cljs.core.seq.call(null,inst_25741);
var inst_25748__$1 = cljs.core.first.call(null,inst_25747);
var inst_25749 = cljs.core.next.call(null,inst_25747);
var state_25764__$1 = (function (){var statearr_25768 = state_25764;
(statearr_25768[(11)] = inst_25748__$1);

(statearr_25768[(12)] = inst_25749);

return statearr_25768;
})();
if(cljs.core.truth_(inst_25748__$1)){
var statearr_25769_25781 = state_25764__$1;
(statearr_25769_25781[(1)] = (4));

} else {
var statearr_25770_25782 = state_25764__$1;
(statearr_25770_25782[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25765 === (3))){
var inst_25762 = (state_25764[(2)]);
var state_25764__$1 = state_25764;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25764__$1,inst_25762);
} else {
if((state_val_25765 === (4))){
var inst_25748 = (state_25764[(11)]);
var inst_25751 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"vars","vars",-2046957217),inst_25748);
var inst_25752 = fluree.db.query.fql.process_ad_hoc_query.call(null,inst_25751);
var state_25764__$1 = state_25764;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25764__$1,(7),inst_25752);
} else {
if((state_val_25765 === (5))){
var inst_25742 = (state_25764[(10)]);
var state_25764__$1 = state_25764;
var statearr_25771_25783 = state_25764__$1;
(statearr_25771_25783[(2)] = inst_25742);

(statearr_25771_25783[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25765 === (6))){
var inst_25760 = (state_25764[(2)]);
var state_25764__$1 = state_25764;
var statearr_25772_25784 = state_25764__$1;
(statearr_25772_25784[(2)] = inst_25760);

(statearr_25772_25784[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25765 === (7))){
var inst_25749 = (state_25764[(12)]);
var inst_25742 = (state_25764[(10)]);
var inst_25754 = (state_25764[(2)]);
var inst_25755 = fluree.db.util.async.throw_err.call(null,inst_25754);
var inst_25756 = cljs.core.into.call(null,inst_25742,inst_25755);
var inst_25741 = inst_25749;
var inst_25742__$1 = inst_25756;
var state_25764__$1 = (function (){var statearr_25773 = state_25764;
(statearr_25773[(7)] = inst_25741);

(statearr_25773[(10)] = inst_25742__$1);

return statearr_25773;
})();
var statearr_25774_25785 = state_25764__$1;
(statearr_25774_25785[(2)] = null);

(statearr_25774_25785[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$relationship_binding_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$relationship_binding_$_state_machine__2746__auto____0 = (function (){
var statearr_25775 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25775[(0)] = fluree$db$query$fql$relationship_binding_$_state_machine__2746__auto__);

(statearr_25775[(1)] = (1));

return statearr_25775;
});
var fluree$db$query$fql$relationship_binding_$_state_machine__2746__auto____1 = (function (state_25764){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25764);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25776){var ex__2749__auto__ = e25776;
var statearr_25777_25786 = state_25764;
(statearr_25777_25786[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25764[(4)]))){
var statearr_25778_25787 = state_25764;
(statearr_25778_25787[(1)] = cljs.core.first.call(null,(state_25764[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25788 = state_25764;
state_25764 = G__25788;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$relationship_binding_$_state_machine__2746__auto__ = function(state_25764){
switch(arguments.length){
case 0:
return fluree$db$query$fql$relationship_binding_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$relationship_binding_$_state_machine__2746__auto____1.call(this,state_25764);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$relationship_binding_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$relationship_binding_$_state_machine__2746__auto____0;
fluree$db$query$fql$relationship_binding_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$relationship_binding_$_state_machine__2746__auto____1;
return fluree$db$query$fql$relationship_binding_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25779 = f__2769__auto__.call(null);
(statearr_25779[(6)] = c__2768__auto__);

return statearr_25779;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Legacy ad-hoc query processor
 */
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,p__25789,query_map){
var map__25790 = p__25789;
var map__25790__$1 = cljs.core.__destructure_map.call(null,map__25790);
var parsed_query = map__25790__$1;
var rel_binding_QMARK_ = cljs.core.get.call(null,map__25790__$1,new cljs.core.Keyword(null,"rel-binding?","rel-binding?",1563806094));
var vars = cljs.core.get.call(null,map__25790__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__25791 = query_map;
var map__25791__$1 = cljs.core.__destructure_map.call(null,map__25791);
var selectOne = cljs.core.get.call(null,map__25791__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var limit = cljs.core.get.call(null,map__25791__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__25791__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.call(null,map__25791__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var orderBy = cljs.core.get.call(null,map__25791__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var groupBy = cljs.core.get.call(null,map__25791__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var prettyPrint = cljs.core.get.call(null,map__25791__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var opts = cljs.core.get.call(null,map__25791__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var opts_SINGLEQUOTE_ = (function (){var G__25792 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"limit","limit",-1355822363),limit,new cljs.core.Keyword(null,"offset","offset",296498311),(function (){var or__5045__auto__ = offset;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})(),new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),orderBy,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),prettyPrint], null),opts);
var G__25792__$1 = (cljs.core.truth_(selectOne)?cljs.core.assoc.call(null,G__25792,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1)):G__25792);
return cljs.core.assoc.call(null,G__25792__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"fuel","fuel",10405485),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.truth_((function (){var or__5045__auto____$1 = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_.call(null,(0));
} else {
return null;
}
}
})(),new cljs.core.Keyword(null,"parsed-query","parsed-query",-428212689),parsed_query,new cljs.core.Keyword(null,"query-map","query-map",-808576972),query_map,new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars);

})();
if(cljs.core.truth_(rel_binding_QMARK_)){
return fluree.db.query.fql.relationship_binding.call(null,opts_SINGLEQUOTE_);
} else {
return fluree.db.query.fql.process_ad_hoc_query.call(null,opts_SINGLEQUOTE_);
}
});
/**
 * Returns already cached query from cache if available, else
 *   executes and stores query into cache.
 */
fluree.db.query.fql.cache_query = (function fluree$db$query$fql$cache_query(p__25793,p__25794){
var map__25795 = p__25793;
var map__25795__$1 = cljs.core.__destructure_map.call(null,map__25795);
var db = map__25795__$1;
var network = cljs.core.get.call(null,map__25795__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__25795__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var block = cljs.core.get.call(null,map__25795__$1,new cljs.core.Keyword(null,"block","block",664686210));
var auth = cljs.core.get.call(null,map__25795__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var conn = cljs.core.get.call(null,map__25795__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var map__25796 = p__25794;
var map__25796__$1 = cljs.core.__destructure_map.call(null,map__25796);
var query_map = map__25796__$1;
var opts = cljs.core.get.call(null,map__25796__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var oc = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
var query_STAR_ = cljs.core.update.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.dissoc,new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var cache_key = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query","query",-1288509510),network,ledger_id,block,auth,query_STAR_], null);
return oc.call(null,cache_key,(function (_){
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___25813 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25806){
var state_val_25807 = (state_25806[(1)]);
if((state_val_25807 === (1))){
var inst_25797 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25798 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"cache","cache",-1237023054)];
var inst_25799 = (new cljs.core.PersistentVector(null,2,(5),inst_25797,inst_25798,null));
var inst_25800 = cljs.core.assoc_in.call(null,query_map,inst_25799,false);
var inst_25801 = fluree.db.query.fql.query.call(null,db,inst_25800);
var state_25806__$1 = state_25806;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25806__$1,(2),inst_25801);
} else {
if((state_val_25807 === (2))){
var inst_25803 = (state_25806[(2)]);
var inst_25804 = cljs.core.async.put_BANG_.call(null,pc,inst_25803);
var state_25806__$1 = state_25806;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25806__$1,inst_25804);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$cache_query_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$cache_query_$_state_machine__2746__auto____0 = (function (){
var statearr_25808 = [null,null,null,null,null,null,null];
(statearr_25808[(0)] = fluree$db$query$fql$cache_query_$_state_machine__2746__auto__);

(statearr_25808[(1)] = (1));

return statearr_25808;
});
var fluree$db$query$fql$cache_query_$_state_machine__2746__auto____1 = (function (state_25806){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25806);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25809){var ex__2749__auto__ = e25809;
var statearr_25810_25814 = state_25806;
(statearr_25810_25814[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25806[(4)]))){
var statearr_25811_25815 = state_25806;
(statearr_25811_25815[(1)] = cljs.core.first.call(null,(state_25806[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25816 = state_25806;
state_25806 = G__25816;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$cache_query_$_state_machine__2746__auto__ = function(state_25806){
switch(arguments.length){
case 0:
return fluree$db$query$fql$cache_query_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$cache_query_$_state_machine__2746__auto____1.call(this,state_25806);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$cache_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$cache_query_$_state_machine__2746__auto____0;
fluree$db$query$fql$cache_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$cache_query_$_state_machine__2746__auto____1;
return fluree$db$query$fql$cache_query_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25812 = f__2769__auto__.call(null);
(statearr_25812[(6)] = c__2768__auto___25813);

return statearr_25812;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));
});
/**
 * Returns true if query was requested to run from the cache.
 */
fluree.db.query.fql.cache_QMARK_ = (function fluree$db$query$fql$cache_QMARK_(p__25817){
var map__25818 = p__25817;
var map__25818__$1 = cljs.core.__destructure_map.call(null,map__25818);
var _query_map = map__25818__$1;
var opts = cljs.core.get.call(null,map__25818__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
return false;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
fluree.db.util.log.debug.call(null,"Running query:",cljs.core.pr_str.call(null,query_map));

if(fluree.db.query.fql.cache_QMARK_.call(null,query_map)){
return fluree.db.query.fql.cache_query.call(null,db,query_map);
} else {
var parsed_query = fluree.db.query.analytical_parse.parse.call(null,db,query_map);
var db_STAR_ = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"ctx-cache","ctx-cache",-391738418),cljs.core.volatile_BANG_.call(null,cljs.core.PersistentArrayMap.EMPTY));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"simple-subject-crawl","simple-subject-crawl",1022725044),new cljs.core.Keyword(null,"strategy","strategy",-1471631918).cljs$core$IFn$_invoke$arity$1(parsed_query))){
return fluree.db.query.subject_crawl.core.simple_subject_crawl.call(null,db_STAR_,parsed_query);
} else {
return fluree.db.query.fql.ad_hoc_query.call(null,db_STAR_,parsed_query,query_map);
}
}
});
