// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.fql_resp');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.analytical_parse');
/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql_resp.vswap_BANG_ = (function fluree$db$query$fql_resp$vswap_BANG_(var_args){
var G__21854 = arguments.length;
switch (G__21854) {
case 2:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol)));
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1));
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2));
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2,arg3));
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql_resp.has_ns_lookups_QMARK_ = (function fluree$db$query$fql_resp$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql_resp.full_select_spec = (function fluree$db$query$fql_resp$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid.call(null,subject_id);
var or__5045__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec.call(null,db,coll_id,cljs.core.get_in.call(null,base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.call(null,base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.call(null,lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
fluree.db.query.fql_resp.vswap_BANG_.call(null,cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
fluree.db.query.fql_resp.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql_resp$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.call(null,(function (acc,spec){
var key_spec = cljs.core.key.call(null,spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,spec)) == null))?cljs.core.assoc.call(null,cljs.core.val.call(null,spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val.call(null,spec));
return cljs.core.assoc.call(null,acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql_resp.add_fuel = (function fluree$db$query$fql_resp$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql_resp.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql_resp.resolve_reverse_refs = (function fluree$db$query$fql_resp$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_22015){
var state_val_22016 = (state_22015[(1)]);
if((state_val_22016 === (7))){
var inst_22010 = (state_22015[(2)]);
var _ = (function (){var statearr_22017 = state_22015;
(statearr_22017[(4)] = cljs.core.rest.call(null,(state_22015[(4)])));

return statearr_22017;
})();
var state_22015__$1 = state_22015;
var statearr_22018_22100 = state_22015__$1;
(statearr_22018_22100[(2)] = inst_22010);

(statearr_22018_22100[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (20))){
var inst_21937 = (state_22015[(7)]);
var state_22015__$1 = state_22015;
var statearr_22019_22101 = state_22015__$1;
(statearr_22019_22101[(2)] = inst_21937);

(statearr_22019_22101[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (27))){
var inst_21892 = (state_22015[(8)]);
var state_22015__$1 = state_22015;
if(cljs.core.truth_(inst_21892)){
var statearr_22020_22102 = state_22015__$1;
(statearr_22020_22102[(1)] = (29));

} else {
var statearr_22021_22103 = state_22015__$1;
(statearr_22021_22103[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (1))){
var state_22015__$1 = state_22015;
var statearr_22022_22104 = state_22015__$1;
(statearr_22022_22104[(2)] = null);

(statearr_22022_22104[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (24))){
var inst_21893 = (state_22015[(9)]);
var state_22015__$1 = state_22015;
var statearr_22023_22105 = state_22015__$1;
(statearr_22023_22105[(2)] = inst_21893);

(statearr_22023_22105[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (39))){
var inst_21929 = (state_22015[(10)]);
var state_22015__$1 = state_22015;
var statearr_22024_22106 = state_22015__$1;
(statearr_22024_22106[(2)] = inst_21929);

(statearr_22024_22106[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (46))){
var inst_21894 = (state_22015[(11)]);
var state_22015__$1 = state_22015;
var statearr_22025_22107 = state_22015__$1;
(statearr_22025_22107[(2)] = inst_21894);

(statearr_22025_22107[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (4))){
var inst_21856 = (state_22015[(2)]);
var state_22015__$1 = state_22015;
var statearr_22026_22108 = state_22015__$1;
(statearr_22026_22108[(2)] = inst_21856);

(statearr_22026_22108[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (15))){
var inst_21905 = (state_22015[(12)]);
var inst_21911 = cljs.core.count.call(null,inst_21905);
var inst_21912 = fluree.db.query.fql_resp.add_fuel.call(null,fuel,inst_21911,max_fuel);
var state_22015__$1 = state_22015;
var statearr_22027_22109 = state_22015__$1;
(statearr_22027_22109[(2)] = inst_21912);

(statearr_22027_22109[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (48))){
var inst_21996 = (state_22015[(13)]);
var inst_21874 = (state_22015[(14)]);
var inst_21881 = (state_22015[(15)]);
var inst_22004 = (state_22015[(2)]);
var inst_22005 = cljs.core.assoc.call(null,inst_21874,inst_22004,inst_21996);
var inst_21873 = inst_21881;
var inst_21874__$1 = inst_22005;
var state_22015__$1 = (function (){var statearr_22028 = state_22015;
(statearr_22028[(16)] = inst_21873);

(statearr_22028[(14)] = inst_21874__$1);

return statearr_22028;
})();
var statearr_22029_22110 = state_22015__$1;
(statearr_22029_22110[(2)] = null);

(statearr_22029_22110[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (50))){
var inst_21896 = (state_22015[(17)]);
var state_22015__$1 = state_22015;
var statearr_22030_22111 = state_22015__$1;
(statearr_22030_22111[(2)] = inst_21896);

(statearr_22030_22111[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (21))){
var inst_21893 = (state_22015[(9)]);
var state_22015__$1 = state_22015;
if(cljs.core.truth_(inst_21893)){
var statearr_22032_22112 = state_22015__$1;
(statearr_22032_22112[(1)] = (23));

} else {
var statearr_22033_22113 = state_22015__$1;
(statearr_22033_22113[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (31))){
var inst_21953 = (state_22015[(2)]);
var state_22015__$1 = state_22015;
if(cljs.core.truth_(inst_21953)){
var statearr_22034_22114 = state_22015__$1;
(statearr_22034_22114[(1)] = (32));

} else {
var statearr_22035_22115 = state_22015__$1;
(statearr_22035_22115[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (32))){
var inst_21929 = (state_22015[(10)]);
var inst_21936 = (state_22015[(18)]);
var inst_21928 = (state_22015[(19)]);
var inst_21955 = (inst_21928 + (1));
var tmp22031 = inst_21929;
var inst_21927 = inst_21936;
var inst_21928__$1 = inst_21955;
var inst_21929__$1 = tmp22031;
var state_22015__$1 = (function (){var statearr_22036 = state_22015;
(statearr_22036[(10)] = inst_21929__$1);

(statearr_22036[(20)] = inst_21927);

(statearr_22036[(19)] = inst_21928__$1);

return statearr_22036;
})();
var statearr_22037_22116 = state_22015__$1;
(statearr_22037_22116[(2)] = null);

(statearr_22037_22116[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (40))){
var state_22015__$1 = state_22015;
if(cljs.core.truth_(fuel)){
var statearr_22038_22117 = state_22015__$1;
(statearr_22038_22117[(1)] = (42));

} else {
var statearr_22039_22118 = state_22015__$1;
(statearr_22039_22118[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (33))){
var state_22015__$1 = state_22015;
var statearr_22040_22119 = state_22015__$1;
(statearr_22040_22119[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (13))){
var inst_21905 = (state_22015[(12)]);
var state_22015__$1 = state_22015;
var statearr_22042_22120 = state_22015__$1;
(statearr_22042_22120[(2)] = inst_21905);

(statearr_22042_22120[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (22))){
var inst_21946 = (state_22015[(2)]);
var state_22015__$1 = state_22015;
if(cljs.core.truth_(inst_21946)){
var statearr_22043_22121 = state_22015__$1;
(statearr_22043_22121[(1)] = (26));

} else {
var statearr_22044_22122 = state_22015__$1;
(statearr_22044_22122[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (36))){
var state_22015__$1 = state_22015;
var statearr_22045_22123 = state_22015__$1;
(statearr_22045_22123[(2)] = null);

(statearr_22045_22123[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (41))){
var inst_21936 = (state_22015[(18)]);
var inst_21928 = (state_22015[(19)]);
var inst_21985 = (state_22015[(2)]);
var inst_21986 = (inst_21928 + (1));
var inst_21927 = inst_21936;
var inst_21928__$1 = inst_21986;
var inst_21929 = inst_21985;
var state_22015__$1 = (function (){var statearr_22046 = state_22015;
(statearr_22046[(10)] = inst_21929);

(statearr_22046[(20)] = inst_21927);

(statearr_22046[(19)] = inst_21928__$1);

return statearr_22046;
})();
var statearr_22047_22124 = state_22015__$1;
(statearr_22047_22124[(2)] = null);

(statearr_22047_22124[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (43))){
var state_22015__$1 = state_22015;
var statearr_22048_22125 = state_22015__$1;
(statearr_22048_22125[(2)] = null);

(statearr_22048_22125[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (29))){
var inst_21892 = (state_22015[(8)]);
var inst_21928 = (state_22015[(19)]);
var inst_21950 = (inst_21928 < inst_21892);
var state_22015__$1 = state_22015;
var statearr_22049_22126 = state_22015__$1;
(statearr_22049_22126[(2)] = inst_21950);

(statearr_22049_22126[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (44))){
var inst_21969 = (state_22015[(21)]);
var inst_21965 = (state_22015[(22)]);
var inst_21978 = (state_22015[(2)]);
var inst_21979 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_21969,inst_21965);
var state_22015__$1 = (function (){var statearr_22050 = state_22015;
(statearr_22050[(23)] = inst_21978);

return statearr_22050;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22015__$1,(45),inst_21979);
} else {
if((state_val_22016 === (6))){
var inst_21873 = (state_22015[(16)]);
var inst_21880 = (state_22015[(24)]);
var inst_21879 = cljs.core.seq.call(null,inst_21873);
var inst_21880__$1 = cljs.core.first.call(null,inst_21879);
var inst_21881 = cljs.core.next.call(null,inst_21879);
var inst_21882 = cljs.core.not.call(null,inst_21880__$1);
var state_22015__$1 = (function (){var statearr_22051 = state_22015;
(statearr_22051[(24)] = inst_21880__$1);

(statearr_22051[(15)] = inst_21881);

return statearr_22051;
})();
if(inst_21882){
var statearr_22052_22127 = state_22015__$1;
(statearr_22052_22127[(1)] = (8));

} else {
var statearr_22053_22128 = state_22015__$1;
(statearr_22053_22128[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (28))){
var inst_21994 = (state_22015[(2)]);
var state_22015__$1 = state_22015;
var statearr_22054_22129 = state_22015__$1;
(statearr_22054_22129[(2)] = inst_21994);

(statearr_22054_22129[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (51))){
var inst_22002 = (state_22015[(2)]);
var state_22015__$1 = state_22015;
var statearr_22055_22130 = state_22015__$1;
(statearr_22055_22130[(2)] = inst_22002);

(statearr_22055_22130[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (25))){
var inst_21944 = (state_22015[(2)]);
var state_22015__$1 = state_22015;
var statearr_22056_22131 = state_22015__$1;
(statearr_22056_22131[(2)] = inst_21944);

(statearr_22056_22131[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (34))){
var inst_21992 = (state_22015[(2)]);
var state_22015__$1 = state_22015;
var statearr_22057_22132 = state_22015__$1;
(statearr_22057_22132[(2)] = inst_21992);

(statearr_22057_22132[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (17))){
var inst_21905 = (state_22015[(12)]);
var inst_21915 = (state_22015[(2)]);
var inst_21923 = cljs.core.seq.call(null,inst_21905);
var inst_21924 = cljs.core.first.call(null,inst_21923);
var inst_21925 = cljs.core.next.call(null,inst_21923);
var inst_21926 = cljs.core.PersistentVector.EMPTY;
var inst_21927 = inst_21905;
var inst_21928 = (0);
var inst_21929 = inst_21926;
var state_22015__$1 = (function (){var statearr_22058 = state_22015;
(statearr_22058[(25)] = inst_21924);

(statearr_22058[(10)] = inst_21929);

(statearr_22058[(26)] = inst_21915);

(statearr_22058[(20)] = inst_21927);

(statearr_22058[(19)] = inst_21928);

(statearr_22058[(27)] = inst_21925);

return statearr_22058;
})();
var statearr_22059_22133 = state_22015__$1;
(statearr_22059_22133[(2)] = null);

(statearr_22059_22133[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (3))){
var inst_22013 = (state_22015[(2)]);
var state_22015__$1 = state_22015;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22015__$1,inst_22013);
} else {
if((state_val_22016 === (12))){
var state_22015__$1 = state_22015;
var statearr_22060_22134 = state_22015__$1;
(statearr_22060_22134[(2)] = fuel);

(statearr_22060_22134[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (2))){
var _ = (function (){var statearr_22061 = state_22015;
(statearr_22061[(4)] = cljs.core.cons.call(null,(5),(state_22015[(4)])));

return statearr_22061;
})();
var inst_21869 = reverse_refs_specs;
var inst_21870 = cljs.core.seq.call(null,inst_21869);
var inst_21871 = cljs.core.first.call(null,inst_21870);
var inst_21872 = cljs.core.next.call(null,inst_21870);
var inst_21873 = inst_21869;
var inst_21874 = null;
var state_22015__$1 = (function (){var statearr_22062 = state_22015;
(statearr_22062[(16)] = inst_21873);

(statearr_22062[(28)] = inst_21871);

(statearr_22062[(14)] = inst_21874);

(statearr_22062[(29)] = inst_21872);

return statearr_22062;
})();
var statearr_22063_22135 = state_22015__$1;
(statearr_22063_22135[(2)] = null);

(statearr_22063_22135[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (23))){
var inst_21893 = (state_22015[(9)]);
var inst_21928 = (state_22015[(19)]);
var inst_21941 = (inst_21928 >= inst_21893);
var state_22015__$1 = state_22015;
var statearr_22064_22136 = state_22015__$1;
(statearr_22064_22136[(2)] = inst_21941);

(statearr_22064_22136[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (47))){
var inst_21895 = (state_22015[(30)]);
var state_22015__$1 = state_22015;
if(cljs.core.truth_(inst_21895)){
var statearr_22065_22137 = state_22015__$1;
(statearr_22065_22137[(1)] = (49));

} else {
var statearr_22066_22138 = state_22015__$1;
(statearr_22066_22138[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (35))){
var inst_21935 = (state_22015[(31)]);
var inst_21959 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21960 = [inst_21935];
var inst_21961 = (new cljs.core.PersistentVector(null,1,(5),inst_21959,inst_21960,null));
var inst_21962 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_21961);
var state_22015__$1 = state_22015;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22015__$1,(38),inst_21962);
} else {
if((state_val_22016 === (19))){
var inst_21894 = (state_22015[(11)]);
var inst_21996 = (state_22015[(2)]);
var state_22015__$1 = (function (){var statearr_22067 = state_22015;
(statearr_22067[(13)] = inst_21996);

return statearr_22067;
})();
if(cljs.core.truth_(inst_21894)){
var statearr_22068_22139 = state_22015__$1;
(statearr_22068_22139[(1)] = (46));

} else {
var statearr_22069_22140 = state_22015__$1;
(statearr_22069_22140[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (11))){
var inst_21905 = (state_22015[(12)]);
var inst_21902 = (state_22015[(2)]);
var inst_21903 = fluree.db.util.async.throw_err.call(null,inst_21902);
var inst_21904 = cljs.core.map.call(null,fluree.db.flake.s,inst_21903);
var inst_21905__$1 = cljs.core.not_empty.call(null,inst_21904);
var state_22015__$1 = (function (){var statearr_22071 = state_22015;
(statearr_22071[(12)] = inst_21905__$1);

return statearr_22071;
})();
if(cljs.core.truth_(inst_21905__$1)){
var statearr_22072_22141 = state_22015__$1;
(statearr_22072_22141[(1)] = (12));

} else {
var statearr_22073_22142 = state_22015__$1;
(statearr_22073_22142[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (9))){
var inst_21880 = (state_22015[(24)]);
var inst_21890 = (state_22015[(32)]);
var inst_21889 = cljs.core.nth.call(null,inst_21880,(0),null);
var inst_21890__$1 = cljs.core.nth.call(null,inst_21880,(1),null);
var inst_21891 = cljs.core.__destructure_map.call(null,inst_21890__$1);
var inst_21892 = cljs.core.get.call(null,inst_21891,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_21893 = cljs.core.get.call(null,inst_21891,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_21894 = cljs.core.get.call(null,inst_21891,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_21895 = cljs.core.get.call(null,inst_21891,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_21896 = cljs.core.get.call(null,inst_21891,new cljs.core.Keyword(null,"p","p",151049309));
var inst_21897 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21898 = [subject_id,inst_21889];
var inst_21899 = (new cljs.core.PersistentVector(null,2,(5),inst_21897,inst_21898,null));
var inst_21900 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_21899);
var state_22015__$1 = (function (){var statearr_22074 = state_22015;
(statearr_22074[(9)] = inst_21893);

(statearr_22074[(11)] = inst_21894);

(statearr_22074[(17)] = inst_21896);

(statearr_22074[(8)] = inst_21892);

(statearr_22074[(32)] = inst_21890__$1);

(statearr_22074[(30)] = inst_21895);

return statearr_22074;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22015__$1,(11),inst_21900);
} else {
if((state_val_22016 === (5))){
var _ = (function (){var statearr_22075 = state_22015;
(statearr_22075[(4)] = cljs.core.rest.call(null,(state_22015[(4)])));

return statearr_22075;
})();
var state_22015__$1 = state_22015;
var ex22070 = (state_22015__$1[(2)]);
var statearr_22076_22143 = state_22015__$1;
(statearr_22076_22143[(5)] = ex22070);


if((ex22070 instanceof Error)){
var statearr_22077_22144 = state_22015__$1;
(statearr_22077_22144[(1)] = (4));

(statearr_22077_22144[(5)] = null);

} else {
throw ex22070;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (14))){
var inst_21909 = (state_22015[(2)]);
var state_22015__$1 = state_22015;
if(cljs.core.truth_(inst_21909)){
var statearr_22078_22145 = state_22015__$1;
(statearr_22078_22145[(1)] = (15));

} else {
var statearr_22079_22146 = state_22015__$1;
(statearr_22079_22146[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (45))){
var inst_21929 = (state_22015[(10)]);
var inst_21981 = (state_22015[(2)]);
var inst_21982 = fluree.db.util.async.throw_err.call(null,inst_21981);
var inst_21983 = cljs.core.conj.call(null,inst_21929,inst_21982);
var state_22015__$1 = state_22015;
var statearr_22080_22147 = state_22015__$1;
(statearr_22080_22147[(2)] = inst_21983);

(statearr_22080_22147[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (26))){
var inst_21929 = (state_22015[(10)]);
var state_22015__$1 = state_22015;
var statearr_22081_22148 = state_22015__$1;
(statearr_22081_22148[(2)] = inst_21929);

(statearr_22081_22148[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (16))){
var state_22015__$1 = state_22015;
var statearr_22082_22149 = state_22015__$1;
(statearr_22082_22149[(2)] = null);

(statearr_22082_22149[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (38))){
var inst_21965 = (state_22015[(22)]);
var inst_21890 = (state_22015[(32)]);
var inst_21964 = (state_22015[(2)]);
var inst_21965__$1 = fluree.db.util.async.throw_err.call(null,inst_21964);
var inst_21966 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21967 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_21968 = (new cljs.core.PersistentVector(null,4,(5),inst_21966,inst_21967,null));
var inst_21969 = cljs.core.select_keys.call(null,inst_21890,inst_21968);
var inst_21970 = cljs.core.empty_QMARK_.call(null,inst_21965__$1);
var state_22015__$1 = (function (){var statearr_22083 = state_22015;
(statearr_22083[(21)] = inst_21969);

(statearr_22083[(22)] = inst_21965__$1);

return statearr_22083;
})();
if(inst_21970){
var statearr_22084_22150 = state_22015__$1;
(statearr_22084_22150[(1)] = (39));

} else {
var statearr_22085_22151 = state_22015__$1;
(statearr_22085_22151[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (30))){
var inst_21892 = (state_22015[(8)]);
var state_22015__$1 = state_22015;
var statearr_22086_22152 = state_22015__$1;
(statearr_22086_22152[(2)] = inst_21892);

(statearr_22086_22152[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (10))){
var inst_22008 = (state_22015[(2)]);
var state_22015__$1 = state_22015;
var statearr_22087_22153 = state_22015__$1;
(statearr_22087_22153[(2)] = inst_22008);

(statearr_22087_22153[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (18))){
var inst_21927 = (state_22015[(20)]);
var inst_21935 = (state_22015[(31)]);
var inst_21937 = (state_22015[(7)]);
var inst_21934 = cljs.core.seq.call(null,inst_21927);
var inst_21935__$1 = cljs.core.first.call(null,inst_21934);
var inst_21936 = cljs.core.next.call(null,inst_21934);
var inst_21937__$1 = cljs.core.not.call(null,inst_21935__$1);
var state_22015__$1 = (function (){var statearr_22088 = state_22015;
(statearr_22088[(18)] = inst_21936);

(statearr_22088[(31)] = inst_21935__$1);

(statearr_22088[(7)] = inst_21937__$1);

return statearr_22088;
})();
if(inst_21937__$1){
var statearr_22089_22154 = state_22015__$1;
(statearr_22089_22154[(1)] = (20));

} else {
var statearr_22090_22155 = state_22015__$1;
(statearr_22090_22155[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (42))){
var inst_21965 = (state_22015[(22)]);
var inst_21974 = cljs.core.count.call(null,inst_21965);
var inst_21975 = fluree.db.query.fql_resp.add_fuel.call(null,fuel,inst_21974,max_fuel);
var state_22015__$1 = state_22015;
var statearr_22091_22156 = state_22015__$1;
(statearr_22091_22156[(2)] = inst_21975);

(statearr_22091_22156[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (37))){
var inst_21990 = (state_22015[(2)]);
var state_22015__$1 = state_22015;
var statearr_22092_22157 = state_22015__$1;
(statearr_22092_22157[(2)] = inst_21990);

(statearr_22092_22157[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (8))){
var inst_21874 = (state_22015[(14)]);
var state_22015__$1 = state_22015;
var statearr_22093_22158 = state_22015__$1;
(statearr_22093_22158[(2)] = inst_21874);

(statearr_22093_22158[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22016 === (49))){
var inst_21895 = (state_22015[(30)]);
var state_22015__$1 = state_22015;
var statearr_22094_22159 = state_22015__$1;
(statearr_22094_22159[(2)] = inst_21895);

(statearr_22094_22159[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto____0 = (function (){
var statearr_22095 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22095[(0)] = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto__);

(statearr_22095[(1)] = (1));

return statearr_22095;
});
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto____1 = (function (state_22015){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_22015);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e22096){var ex__2749__auto__ = e22096;
var statearr_22097_22160 = state_22015;
(statearr_22097_22160[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_22015[(4)]))){
var statearr_22098_22161 = state_22015;
(statearr_22098_22161[(1)] = cljs.core.first.call(null,(state_22015[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22162 = state_22015;
state_22015 = G__22162;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto__ = function(state_22015){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto____1.call(this,state_22015);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto____0;
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto____1;
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_22099 = f__2769__auto__.call(null);
(statearr_22099[(6)] = c__2768__auto__);

return statearr_22099;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.fql_resp.component_follow_QMARK_ = (function fluree$db$query$fql_resp$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_.call(null,pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql_resp.fuel_flake_transducer = (function fluree$db$query$fql_resp$fuel_flake_transducer(var_args){
var G__22164 = arguments.length;
switch (G__22164) {
case 2:
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql_resp.fuel_flake_transducer.call(null,fuel,max_fuel,(1));
}));

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__22166 = null;
var G__22166__0 = (function (){
return xf.call(null);
});
var G__22166__1 = (function (result){
return xf.call(null,result);
});
var G__22166__2 = (function (result,flake){
fluree.db.query.fql_resp.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return xf.call(null,result,flake);
});
G__22166 = function(result,flake){
switch(arguments.length){
case 0:
return G__22166__0.call(this);
case 1:
return G__22166__1.call(this,result);
case 2:
return G__22166__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22166.cljs$core$IFn$_invoke$arity$0 = G__22166__0;
G__22166.cljs$core$IFn$_invoke$arity$1 = G__22166__1;
G__22166.cljs$core$IFn$_invoke$arity$2 = G__22166__2;
return G__22166;
})()
});
}));

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql_resp.recur_select_spec = (function fluree$db$query$fql_resp$recur_select_spec(select_spec,flake){
var recur_subject = fluree.db.flake.o.call(null,flake);
var recur_pred = fluree.db.flake.p.call(null,flake);
var map__22167 = select_spec;
var map__22167__$1 = cljs.core.__destructure_map.call(null,map__22167);
var recur_seen = cljs.core.get.call(null,map__22167__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.call(null,map__22167__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.call(null,recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql_resp.flake__GT_recur = (function fluree$db$query$fql_resp$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_22281){
var state_val_22282 = (state_22281[(1)]);
if((state_val_22282 === (7))){
var inst_22193 = flakes;
var inst_22194 = cljs.core.seq.call(null,inst_22193);
var inst_22195 = cljs.core.first.call(null,inst_22194);
var inst_22196 = cljs.core.next.call(null,inst_22194);
var inst_22197 = cljs.core.PersistentVector.EMPTY;
var inst_22198 = inst_22193;
var inst_22199 = (0);
var inst_22200 = inst_22197;
var state_22281__$1 = (function (){var statearr_22283 = state_22281;
(statearr_22283[(7)] = inst_22196);

(statearr_22283[(8)] = inst_22200);

(statearr_22283[(9)] = inst_22199);

(statearr_22283[(10)] = inst_22198);

(statearr_22283[(11)] = inst_22195);

return statearr_22283;
})();
var statearr_22284_22350 = state_22281__$1;
(statearr_22284_22350[(2)] = null);

(statearr_22284_22350[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (20))){
var state_22281__$1 = state_22281;
var statearr_22285_22351 = state_22281__$1;
(statearr_22285_22351[(2)] = results);

(statearr_22285_22351[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (27))){
var state_22281__$1 = state_22281;
var statearr_22286_22352 = state_22281__$1;
(statearr_22286_22352[(2)] = null);

(statearr_22286_22352[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (1))){
var state_22281__$1 = state_22281;
var statearr_22287_22353 = state_22281__$1;
(statearr_22287_22353[(2)] = null);

(statearr_22287_22353[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (24))){
var state_22281__$1 = state_22281;
var statearr_22288_22354 = state_22281__$1;
(statearr_22288_22354[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (39))){
var inst_22207 = (state_22281[(12)]);
var inst_22200 = (state_22281[(8)]);
var inst_22262 = (state_22281[(13)]);
var inst_22265 = (state_22281[(2)]);
var inst_22266 = fluree.db.util.async.throw_err.call(null,inst_22265);
var inst_22267 = cljs.core.conj.call(null,inst_22200,inst_22266);
var inst_22198 = inst_22207;
var inst_22199 = inst_22262;
var inst_22200__$1 = inst_22267;
var state_22281__$1 = (function (){var statearr_22290 = state_22281;
(statearr_22290[(8)] = inst_22200__$1);

(statearr_22290[(9)] = inst_22199);

(statearr_22290[(10)] = inst_22198);

return statearr_22290;
})();
var statearr_22291_22355 = state_22281__$1;
(statearr_22291_22355[(2)] = null);

(statearr_22291_22355[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (4))){
var inst_22168 = (state_22281[(2)]);
var state_22281__$1 = state_22281;
var statearr_22292_22356 = state_22281__$1;
(statearr_22292_22356[(2)] = inst_22168);

(statearr_22292_22356[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (15))){
var inst_22181 = (state_22281[(14)]);
var state_22281__$1 = state_22281;
var statearr_22293_22357 = state_22281__$1;
(statearr_22293_22357[(2)] = inst_22181);

(statearr_22293_22357[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (21))){
var inst_22177 = (state_22281[(15)]);
var state_22281__$1 = state_22281;
if(cljs.core.truth_(inst_22177)){
var statearr_22294_22358 = state_22281__$1;
(statearr_22294_22358[(1)] = (23));

} else {
var statearr_22295_22359 = state_22281__$1;
(statearr_22295_22359[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (31))){
var inst_22245 = (state_22281[(16)]);
var state_22281__$1 = state_22281;
var statearr_22296_22360 = state_22281__$1;
(statearr_22296_22360[(2)] = inst_22245);

(statearr_22296_22360[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (32))){
var inst_22237 = (state_22281[(17)]);
var inst_22251 = (state_22281[(2)]);
var state_22281__$1 = (function (){var statearr_22297 = state_22281;
(statearr_22297[(18)] = inst_22251);

return statearr_22297;
})();
if(cljs.core.truth_(inst_22237)){
var statearr_22298_22361 = state_22281__$1;
(statearr_22298_22361[(1)] = (33));

} else {
var statearr_22299_22362 = state_22281__$1;
(statearr_22299_22362[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (33))){
var inst_22237 = (state_22281[(17)]);
var state_22281__$1 = state_22281;
var statearr_22300_22363 = state_22281__$1;
(statearr_22300_22363[(2)] = inst_22237);

(statearr_22300_22363[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (13))){
var inst_22217 = (state_22281[(2)]);
var state_22281__$1 = state_22281;
if(cljs.core.truth_(inst_22217)){
var statearr_22302_22364 = state_22281__$1;
(statearr_22302_22364[(1)] = (17));

} else {
var statearr_22303_22365 = state_22281__$1;
(statearr_22303_22365[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (22))){
var inst_22234 = (state_22281[(2)]);
var state_22281__$1 = state_22281;
var statearr_22304_22366 = state_22281__$1;
(statearr_22304_22366[(2)] = inst_22234);

(statearr_22304_22366[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (36))){
var inst_22207 = (state_22281[(12)]);
var inst_22200 = (state_22281[(8)]);
var inst_22199 = (state_22281[(9)]);
var inst_22259 = (inst_22199 + (1));
var tmp22301 = inst_22200;
var inst_22198 = inst_22207;
var inst_22199__$1 = inst_22259;
var inst_22200__$1 = tmp22301;
var state_22281__$1 = (function (){var statearr_22305 = state_22281;
(statearr_22305[(8)] = inst_22200__$1);

(statearr_22305[(9)] = inst_22199__$1);

(statearr_22305[(10)] = inst_22198);

return statearr_22305;
})();
var statearr_22306_22367 = state_22281__$1;
(statearr_22306_22367[(2)] = null);

(statearr_22306_22367[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (29))){
var inst_22244 = (state_22281[(2)]);
var inst_22245 = fluree.db.util.async.throw_err.call(null,inst_22244);
var state_22281__$1 = (function (){var statearr_22307 = state_22281;
(statearr_22307[(16)] = inst_22245);

return statearr_22307;
})();
if(cljs.core.truth_(fuel)){
var statearr_22308_22368 = state_22281__$1;
(statearr_22308_22368[(1)] = (30));

} else {
var statearr_22309_22369 = state_22281__$1;
(statearr_22309_22369[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (6))){
var state_22281__$1 = state_22281;
var statearr_22310_22370 = state_22281__$1;
(statearr_22310_22370[(2)] = results);

(statearr_22310_22370[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (28))){
var inst_22230 = (state_22281[(2)]);
var state_22281__$1 = state_22281;
var statearr_22311_22371 = state_22281__$1;
(statearr_22311_22371[(2)] = inst_22230);

(statearr_22311_22371[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (25))){
var inst_22232 = (state_22281[(2)]);
var state_22281__$1 = state_22281;
var statearr_22312_22372 = state_22281__$1;
(statearr_22312_22372[(2)] = inst_22232);

(statearr_22312_22372[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (34))){
var inst_22251 = (state_22281[(18)]);
var inst_22254 = cljs.core.empty_QMARK_.call(null,inst_22251);
var state_22281__$1 = state_22281;
var statearr_22313_22373 = state_22281__$1;
(statearr_22313_22373[(2)] = inst_22254);

(statearr_22313_22373[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (17))){
var inst_22200 = (state_22281[(8)]);
var inst_22219 = cljs.core.empty_QMARK_.call(null,inst_22200);
var state_22281__$1 = state_22281;
if(inst_22219){
var statearr_22314_22374 = state_22281__$1;
(statearr_22314_22374[(1)] = (20));

} else {
var statearr_22315_22375 = state_22281__$1;
(statearr_22315_22375[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (3))){
var inst_22279 = (state_22281[(2)]);
var state_22281__$1 = state_22281;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22281__$1,inst_22279);
} else {
if((state_val_22282 === (12))){
var inst_22181 = (state_22281[(14)]);
var state_22281__$1 = state_22281;
if(cljs.core.truth_(inst_22181)){
var statearr_22316_22376 = state_22281__$1;
(statearr_22316_22376[(1)] = (14));

} else {
var statearr_22317_22377 = state_22281__$1;
(statearr_22317_22377[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (2))){
var _ = (function (){var statearr_22318 = state_22281;
(statearr_22318[(4)] = cljs.core.cons.call(null,(5),(state_22281[(4)])));

return statearr_22318;
})();
var inst_22175 = select_spec;
var inst_22176 = cljs.core.__destructure_map.call(null,inst_22175);
var inst_22177 = cljs.core.get.call(null,inst_22176,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_22178 = cljs.core.get.call(null,inst_22176,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_22179 = cljs.core.get.call(null,inst_22176,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_22180 = cljs.core.get.call(null,inst_22176,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_22181 = cljs.core.get.call(null,inst_22176,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22182 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_22183 = (inst_22180 > inst_22182);
var state_22281__$1 = (function (){var statearr_22319 = state_22281;
(statearr_22319[(14)] = inst_22181);

(statearr_22319[(19)] = inst_22178);

(statearr_22319[(20)] = inst_22179);

(statearr_22319[(15)] = inst_22177);

return statearr_22319;
})();
if(cljs.core.truth_(inst_22183)){
var statearr_22320_22378 = state_22281__$1;
(statearr_22320_22378[(1)] = (6));

} else {
var statearr_22321_22379 = state_22281__$1;
(statearr_22321_22379[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (23))){
var inst_22178 = (state_22281[(19)]);
var inst_22200 = (state_22281[(8)]);
var inst_22223 = cljs.core.assoc.call(null,results,inst_22178,inst_22200);
var state_22281__$1 = state_22281;
var statearr_22322_22380 = state_22281__$1;
(statearr_22322_22380[(2)] = inst_22223);

(statearr_22322_22380[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (35))){
var inst_22206 = (state_22281[(21)]);
var inst_22256 = (state_22281[(2)]);
var inst_22257 = fluree.db.query.fql_resp.recur_select_spec.call(null,select_spec,inst_22206);
var state_22281__$1 = (function (){var statearr_22323 = state_22281;
(statearr_22323[(22)] = inst_22257);

return statearr_22323;
})();
if(cljs.core.truth_(inst_22256)){
var statearr_22324_22381 = state_22281__$1;
(statearr_22324_22381[(1)] = (36));

} else {
var statearr_22325_22382 = state_22281__$1;
(statearr_22325_22382[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (19))){
var inst_22272 = (state_22281[(2)]);
var state_22281__$1 = state_22281;
var statearr_22326_22383 = state_22281__$1;
(statearr_22326_22383[(2)] = inst_22272);

(statearr_22326_22383[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (11))){
var inst_22208 = (state_22281[(23)]);
var state_22281__$1 = state_22281;
var statearr_22328_22384 = state_22281__$1;
(statearr_22328_22384[(2)] = inst_22208);

(statearr_22328_22384[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (9))){
var inst_22206 = (state_22281[(21)]);
var inst_22208 = (state_22281[(23)]);
var inst_22198 = (state_22281[(10)]);
var inst_22205 = cljs.core.seq.call(null,inst_22198);
var inst_22206__$1 = cljs.core.first.call(null,inst_22205);
var inst_22207 = cljs.core.next.call(null,inst_22205);
var inst_22208__$1 = cljs.core.not.call(null,inst_22206__$1);
var state_22281__$1 = (function (){var statearr_22329 = state_22281;
(statearr_22329[(21)] = inst_22206__$1);

(statearr_22329[(12)] = inst_22207);

(statearr_22329[(23)] = inst_22208__$1);

return statearr_22329;
})();
if(inst_22208__$1){
var statearr_22330_22385 = state_22281__$1;
(statearr_22330_22385[(1)] = (11));

} else {
var statearr_22331_22386 = state_22281__$1;
(statearr_22331_22386[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (5))){
var _ = (function (){var statearr_22332 = state_22281;
(statearr_22332[(4)] = cljs.core.rest.call(null,(state_22281[(4)])));

return statearr_22332;
})();
var state_22281__$1 = state_22281;
var ex22327 = (state_22281__$1[(2)]);
var statearr_22333_22387 = state_22281__$1;
(statearr_22333_22387[(5)] = ex22327);


if((ex22327 instanceof Error)){
var statearr_22334_22388 = state_22281__$1;
(statearr_22334_22388[(1)] = (4));

(statearr_22334_22388[(5)] = null);

} else {
throw ex22327;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (14))){
var inst_22181 = (state_22281[(14)]);
var inst_22199 = (state_22281[(9)]);
var inst_22212 = (inst_22199 < inst_22181);
var state_22281__$1 = state_22281;
var statearr_22335_22389 = state_22281__$1;
(statearr_22335_22389[(2)] = inst_22212);

(statearr_22335_22389[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (26))){
var inst_22178 = (state_22281[(19)]);
var inst_22200 = (state_22281[(8)]);
var inst_22226 = cljs.core.first.call(null,inst_22200);
var inst_22227 = cljs.core.assoc.call(null,results,inst_22178,inst_22226);
var state_22281__$1 = state_22281;
var statearr_22336_22390 = state_22281__$1;
(statearr_22336_22390[(2)] = inst_22227);

(statearr_22336_22390[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (16))){
var inst_22215 = (state_22281[(2)]);
var state_22281__$1 = state_22281;
var statearr_22337_22391 = state_22281__$1;
(statearr_22337_22391[(2)] = inst_22215);

(statearr_22337_22391[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (38))){
var inst_22270 = (state_22281[(2)]);
var state_22281__$1 = state_22281;
var statearr_22338_22392 = state_22281__$1;
(statearr_22338_22392[(2)] = inst_22270);

(statearr_22338_22392[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (30))){
var inst_22245 = (state_22281[(16)]);
var inst_22247 = fluree.db.query.fql_resp.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_22248 = cljs.core.sequence.call(null,inst_22247,inst_22245);
var state_22281__$1 = state_22281;
var statearr_22339_22393 = state_22281__$1;
(statearr_22339_22393[(2)] = inst_22248);

(statearr_22339_22393[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (10))){
var inst_22274 = (state_22281[(2)]);
var state_22281__$1 = state_22281;
var statearr_22340_22394 = state_22281__$1;
(statearr_22340_22394[(2)] = inst_22274);

(statearr_22340_22394[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22282 === (18))){
var inst_22206 = (state_22281[(21)]);
var inst_22179 = (state_22281[(20)]);
var inst_22236 = fluree.db.flake.o.call(null,inst_22206);
var inst_22237 = cljs.core.contains_QMARK_.call(null,inst_22179,inst_22236);
var inst_22239 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22240 = [inst_22236];
var inst_22241 = (new cljs.core.PersistentVector(null,1,(5),inst_22239,inst_22240,null));
var inst_22242 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22241);
var state_22281__$1 = (function (){var statearr_22341 = state_22281;
(statearr_22341[(17)] = inst_22237);

return statearr_22341;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22281__$1,(29),inst_22242);
} else {
if((state_val_22282 === (37))){
var inst_22251 = (state_22281[(18)]);
var inst_22199 = (state_22281[(9)]);
var inst_22257 = (state_22281[(22)]);
var inst_22262 = (inst_22199 + (1));
var inst_22263 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22257,inst_22251);
var state_22281__$1 = (function (){var statearr_22342 = state_22281;
(statearr_22342[(13)] = inst_22262);

return statearr_22342;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22281__$1,(39),inst_22263);
} else {
if((state_val_22282 === (8))){
var inst_22276 = (state_22281[(2)]);
var _ = (function (){var statearr_22343 = state_22281;
(statearr_22343[(4)] = cljs.core.rest.call(null,(state_22281[(4)])));

return statearr_22343;
})();
var state_22281__$1 = state_22281;
var statearr_22344_22395 = state_22281__$1;
(statearr_22344_22395[(2)] = inst_22276);

(statearr_22344_22395[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto____0 = (function (){
var statearr_22345 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22345[(0)] = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto__);

(statearr_22345[(1)] = (1));

return statearr_22345;
});
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto____1 = (function (state_22281){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_22281);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e22346){var ex__2749__auto__ = e22346;
var statearr_22347_22396 = state_22281;
(statearr_22347_22396[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_22281[(4)]))){
var statearr_22348_22397 = state_22281;
(statearr_22348_22397[(1)] = cljs.core.first.call(null,(state_22281[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22398 = state_22281;
state_22281 = G__22398;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto__ = function(state_22281){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto____1.call(this,state_22281);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto____0;
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto____1;
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_22349 = f__2769__auto__.call(null);
(statearr_22349[(6)] = c__2768__auto__);

return statearr_22349;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql_resp.wildcard_pred_spec = (function fluree$db$query$fql_resp$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__5045__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config.call(null,db,p,compact_QMARK_);
fluree.db.query.fql_resp.vswap_BANG_.call(null,cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql_resp.add_pred = (function fluree$db$query$fql_resp$add_pred(var_args){
var G__22402 = arguments.length;
switch (G__22402) {
case 9:
return fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql_resp.add_pred.call(null,db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_22841){
var state_val_22842 = (state_22841[(1)]);
if((state_val_22842 === (121))){
var inst_22764 = (state_22841[(2)]);
var inst_22765 = fluree.db.util.async.throw_err.call(null,inst_22764);
var inst_22766 = cljs.core.seq.call(null,inst_22765);
var state_22841__$1 = state_22841;
if(inst_22766){
var statearr_22843_23057 = state_22841__$1;
(statearr_22843_23057[(1)] = (122));

} else {
var statearr_22844_23058 = state_22841__$1;
(statearr_22844_23058[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (65))){
var inst_22557 = (state_22841[(7)]);
var inst_22556 = (state_22841[(2)]);
var inst_22557__$1 = fluree.db.util.async.throw_err.call(null,inst_22556);
var inst_22558 = cljs.core.seq.call(null,inst_22557__$1);
var state_22841__$1 = (function (){var statearr_22845 = state_22841;
(statearr_22845[(7)] = inst_22557__$1);

return statearr_22845;
})();
if(inst_22558){
var statearr_22846_23059 = state_22841__$1;
(statearr_22846_23059[(1)] = (66));

} else {
var statearr_22847_23060 = state_22841__$1;
(statearr_22847_23060[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (70))){
var inst_22557 = (state_22841[(7)]);
var inst_22568 = cljs.core.count.call(null,inst_22557);
var inst_22569 = fluree.db.query.fql_resp.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_22568);
var state_22841__$1 = state_22841;
var statearr_22848_23061 = state_22841__$1;
(statearr_22848_23061[(2)] = inst_22569);

(statearr_22848_23061[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (62))){
var inst_22547 = (state_22841[(8)]);
var inst_22550 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22551 = fluree.db.flake.o.call(null,inst_22547);
var inst_22552 = [inst_22551];
var inst_22553 = (new cljs.core.PersistentVector(null,1,(5),inst_22550,inst_22552,null));
var inst_22554 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22553);
var state_22841__$1 = state_22841;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22841__$1,(65),inst_22554);
} else {
if((state_val_22842 === (74))){
var inst_22541 = (state_22841[(9)]);
var state_22841__$1 = state_22841;
var statearr_22849_23062 = state_22841__$1;
(statearr_22849_23062[(2)] = inst_22541);

(statearr_22849_23062[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (110))){
var inst_22726 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_22727 = new cljs.core.Keyword(null,"root?","root?",-2045639518).cljs$core$IFn$_invoke$arity$1(inst_22726);
var inst_22728 = inst_22727 === true;
var state_22841__$1 = state_22841;
if(cljs.core.truth_(inst_22728)){
var statearr_22850_23063 = state_22841__$1;
(statearr_22850_23063[(1)] = (113));

} else {
var statearr_22851_23064 = state_22841__$1;
(statearr_22851_23064[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (130))){
var inst_22836 = (state_22841[(2)]);
var _ = (function (){var statearr_22852 = state_22841;
(statearr_22852[(4)] = cljs.core.rest.call(null,(state_22841[(4)])));

return statearr_22852;
})();
var state_22841__$1 = state_22841;
var statearr_22853_23065 = state_22841__$1;
(statearr_22853_23065[(2)] = inst_22836);

(statearr_22853_23065[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (128))){
var inst_22811 = (state_22841[(10)]);
var inst_22814 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22815 = [acc,inst_22811];
var inst_22816 = (new cljs.core.PersistentVector(null,2,(5),inst_22814,inst_22815,null));
var state_22841__$1 = state_22841;
var statearr_22854_23066 = state_22841__$1;
(statearr_22854_23066[(2)] = inst_22816);

(statearr_22854_23066[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (7))){
var inst_22414 = (state_22841[(11)]);
var state_22841__$1 = state_22841;
var statearr_22855_23067 = state_22841__$1;
(statearr_22855_23067[(2)] = inst_22414);

(statearr_22855_23067[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (59))){
var inst_22805 = (state_22841[(2)]);
var state_22841__$1 = state_22841;
var statearr_22856_23068 = state_22841__$1;
(statearr_22856_23068[(2)] = inst_22805);

(statearr_22856_23068[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (86))){
var inst_22635 = (state_22841[(12)]);
var inst_22635__$1 = (state_22841[(2)]);
var state_22841__$1 = (function (){var statearr_22857 = state_22841;
(statearr_22857[(12)] = inst_22635__$1);

return statearr_22857;
})();
if(cljs.core.truth_(inst_22635__$1)){
var statearr_22858_23069 = state_22841__$1;
(statearr_22858_23069[(1)] = (88));

} else {
var statearr_22859_23070 = state_22841__$1;
(statearr_22859_23070[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (20))){
var inst_22456 = (state_22841[(13)]);
var inst_22455 = (state_22841[(14)]);
var inst_22443 = (state_22841[(15)]);
var inst_22454 = (state_22841[(2)]);
var inst_22455__$1 = cljs.core.__destructure_map.call(null,inst_22443);
var inst_22456__$1 = cljs.core.get.call(null,inst_22455__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_22457 = cljs.core.get.call(null,inst_22455__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_22458 = cljs.core.get.call(null,inst_22455__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22459 = cljs.core.get.call(null,inst_22455__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_22460 = cljs.core.get.call(null,inst_22455__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_22461 = cljs.core.get.call(null,inst_22455__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_22841__$1 = (function (){var statearr_22860 = state_22841;
(statearr_22860[(13)] = inst_22456__$1);

(statearr_22860[(16)] = inst_22459);

(statearr_22860[(17)] = inst_22460);

(statearr_22860[(18)] = inst_22454);

(statearr_22860[(19)] = inst_22461);

(statearr_22860[(20)] = inst_22457);

(statearr_22860[(14)] = inst_22455__$1);

(statearr_22860[(21)] = inst_22458);

return statearr_22860;
})();
if(cljs.core.truth_(inst_22456__$1)){
var statearr_22861_23071 = state_22841__$1;
(statearr_22861_23071[(1)] = (24));

} else {
var statearr_22862_23072 = state_22841__$1;
(statearr_22862_23072[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (72))){
var inst_22566 = (state_22841[(22)]);
var inst_22572 = (state_22841[(2)]);
var inst_22573 = cljs.core.seq.call(null,inst_22566);
var state_22841__$1 = (function (){var statearr_22863 = state_22841;
(statearr_22863[(23)] = inst_22572);

return statearr_22863;
})();
if(inst_22573){
var statearr_22864_23073 = state_22841__$1;
(statearr_22864_23073[(1)] = (73));

} else {
var statearr_22865_23074 = state_22841__$1;
(statearr_22865_23074[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (58))){
var inst_22443 = (state_22841[(15)]);
var inst_22588 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_22443);
var state_22841__$1 = state_22841;
if(cljs.core.truth_(inst_22588)){
var statearr_22866_23075 = state_22841__$1;
(statearr_22866_23075[(1)] = (76));

} else {
var statearr_22867_23076 = state_22841__$1;
(statearr_22867_23076[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (60))){
var inst_22547 = (state_22841[(8)]);
var inst_22540 = (state_22841[(24)]);
var inst_22546 = cljs.core.seq.call(null,inst_22540);
var inst_22547__$1 = cljs.core.first.call(null,inst_22546);
var inst_22548 = cljs.core.next.call(null,inst_22546);
var state_22841__$1 = (function (){var statearr_22868 = state_22841;
(statearr_22868[(8)] = inst_22547__$1);

(statearr_22868[(25)] = inst_22548);

return statearr_22868;
})();
if(cljs.core.truth_(inst_22547__$1)){
var statearr_22869_23077 = state_22841__$1;
(statearr_22869_23077[(1)] = (62));

} else {
var statearr_22870_23078 = state_22841__$1;
(statearr_22870_23078[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (27))){
var inst_22460 = (state_22841[(17)]);
var inst_22464 = (state_22841[(26)]);
var inst_22464__$1 = cljs.core.not_EQ_.call(null,(0),inst_22460);
var state_22841__$1 = (function (){var statearr_22871 = state_22841;
(statearr_22871[(26)] = inst_22464__$1);

return statearr_22871;
})();
if(inst_22464__$1){
var statearr_22872_23079 = state_22841__$1;
(statearr_22872_23079[(1)] = (30));

} else {
var statearr_22873_23080 = state_22841__$1;
(statearr_22873_23080[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (1))){
var state_22841__$1 = state_22841;
var statearr_22874_23081 = state_22841__$1;
(statearr_22874_23081[(2)] = null);

(statearr_22874_23081[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (69))){
var inst_22562 = (state_22841[(2)]);
var inst_22563 = fluree.db.util.async.throw_err.call(null,inst_22562);
var state_22841__$1 = state_22841;
var statearr_22875_23082 = state_22841__$1;
(statearr_22875_23082[(2)] = inst_22563);

(statearr_22875_23082[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (101))){
var inst_22719 = (state_22841[(2)]);
var state_22841__$1 = state_22841;
var statearr_22876_23083 = state_22841__$1;
(statearr_22876_23083[(2)] = inst_22719);

(statearr_22876_23083[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (24))){
var inst_22460 = (state_22841[(17)]);
var state_22841__$1 = state_22841;
if(cljs.core.truth_(inst_22460)){
var statearr_22877_23084 = state_22841__$1;
(statearr_22877_23084[(1)] = (27));

} else {
var statearr_22878_23085 = state_22841__$1;
(statearr_22878_23085[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (102))){
var inst_22691 = (state_22841[(27)]);
var inst_22690 = (state_22841[(2)]);
var inst_22691__$1 = fluree.db.util.async.throw_err.call(null,inst_22690);
var inst_22692 = cljs.core.empty_QMARK_.call(null,inst_22691__$1);
var state_22841__$1 = (function (){var statearr_22879 = state_22841;
(statearr_22879[(27)] = inst_22691__$1);

return statearr_22879;
})();
if(inst_22692){
var statearr_22880_23086 = state_22841__$1;
(statearr_22880_23086[(1)] = (103));

} else {
var statearr_22881_23087 = state_22841__$1;
(statearr_22881_23087[(1)] = (104));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (135))){
var state_22841__$1 = state_22841;
var statearr_22882_23088 = state_22841__$1;
(statearr_22882_23088[(2)] = null);

(statearr_22882_23088[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (55))){
var inst_22443 = (state_22841[(15)]);
var inst_22516 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_22443);
var state_22841__$1 = state_22841;
var statearr_22883_23089 = state_22841__$1;
(statearr_22883_23089[(2)] = inst_22516);

(statearr_22883_23089[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (85))){
var inst_22610 = (state_22841[(28)]);
var inst_22443 = (state_22841[(15)]);
var inst_22622 = fluree.db.flake.o.call(null,inst_22610);
var inst_22623 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22443);
var inst_22624 = fluree.db.dbproto._tag.call(null,db,inst_22622,inst_22623);
var state_22841__$1 = state_22841;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22841__$1,(87),inst_22624);
} else {
if((state_val_22842 === (39))){
var inst_22459 = (state_22841[(16)]);
var inst_22491 = (state_22841[(29)]);
var inst_22491__$1 = cljs.core.not.call(null,inst_22459);
var state_22841__$1 = (function (){var statearr_22884 = state_22841;
(statearr_22884[(29)] = inst_22491__$1);

return statearr_22884;
})();
if(inst_22491__$1){
var statearr_22885_23090 = state_22841__$1;
(statearr_22885_23090[(1)] = (42));

} else {
var statearr_22886_23091 = state_22841__$1;
(statearr_22886_23091[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (88))){
var inst_22635 = (state_22841[(12)]);
var inst_22604 = (state_22841[(30)]);
var inst_22637 = cljs.core.conj.call(null,inst_22604,inst_22635);
var state_22841__$1 = state_22841;
var statearr_22887_23092 = state_22841__$1;
(statearr_22887_23092[(2)] = inst_22637);

(statearr_22887_23092[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (46))){
var inst_22458 = (state_22841[(21)]);
var state_22841__$1 = state_22841;
var statearr_22888_23093 = state_22841__$1;
(statearr_22888_23093[(2)] = inst_22458);

(statearr_22888_23093[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (4))){
var inst_22403 = (state_22841[(2)]);
var state_22841__$1 = state_22841;
var statearr_22889_23094 = state_22841__$1;
(statearr_22889_23094[(2)] = inst_22403);

(statearr_22889_23094[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (77))){
var inst_22650 = (state_22841[(31)]);
var inst_22650__$1 = componentFollow_QMARK_;
var state_22841__$1 = (function (){var statearr_22890 = state_22841;
(statearr_22890[(31)] = inst_22650__$1);

return statearr_22890;
})();
if(cljs.core.truth_(inst_22650__$1)){
var statearr_22891_23095 = state_22841__$1;
(statearr_22891_23095[(1)] = (91));

} else {
var statearr_22892_23096 = state_22841__$1;
(statearr_22892_23096[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (106))){
var inst_22671 = (state_22841[(32)]);
var inst_22705 = (state_22841[(2)]);
var inst_22706 = fluree.db.util.async.throw_err.call(null,inst_22705);
var inst_22707 = cljs.core.conj.call(null,inst_22671,inst_22706);
var state_22841__$1 = state_22841;
var statearr_22893_23097 = state_22841__$1;
(statearr_22893_23097[(2)] = inst_22707);

(statearr_22893_23097[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (119))){
var inst_22749 = (state_22841[(33)]);
var inst_22779 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22780 = [inst_22749,offset_map];
var inst_22781 = (new cljs.core.PersistentVector(null,2,(5),inst_22779,inst_22780,null));
var state_22841__$1 = state_22841;
var statearr_22894_23098 = state_22841__$1;
(statearr_22894_23098[(2)] = inst_22781);

(statearr_22894_23098[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (95))){
var inst_22457 = (state_22841[(20)]);
var state_22841__$1 = state_22841;
if(cljs.core.truth_(inst_22457)){
var statearr_22895_23099 = state_22841__$1;
(statearr_22895_23099[(1)] = (110));

} else {
var statearr_22896_23100 = state_22841__$1;
(statearr_22896_23100[(1)] = (111));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (54))){
var inst_22513 = (state_22841[(34)]);
var state_22841__$1 = state_22841;
var statearr_22897_23101 = state_22841__$1;
(statearr_22897_23101[(2)] = inst_22513);

(statearr_22897_23101[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (92))){
var inst_22650 = (state_22841[(31)]);
var state_22841__$1 = state_22841;
var statearr_22898_23102 = state_22841__$1;
(statearr_22898_23102[(2)] = inst_22650);

(statearr_22898_23102[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (104))){
var inst_22691 = (state_22841[(27)]);
var inst_22413 = (state_22841[(35)]);
var inst_22700 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298)];
var inst_22701 = [true,inst_22413];
var inst_22702 = cljs.core.PersistentHashMap.fromArrays(inst_22700,inst_22701);
var inst_22703 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22702,inst_22691);
var state_22841__$1 = state_22841;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22841__$1,(106),inst_22703);
} else {
if((state_val_22842 === (15))){
var inst_22436 = (state_22841[(36)]);
var inst_22413 = (state_22841[(35)]);
var inst_22440 = cljs.core.assoc.call(null,inst_22436,new cljs.core.Keyword(null,"compact?","compact?",1216893298),inst_22413);
var state_22841__$1 = state_22841;
var statearr_22899_23103 = state_22841__$1;
(statearr_22899_23103[(2)] = inst_22440);

(statearr_22899_23103[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (48))){
var inst_22507 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22508 = [null,offset_map];
var inst_22509 = (new cljs.core.PersistentVector(null,2,(5),inst_22507,inst_22508,null));
var state_22841__$1 = state_22841;
var statearr_22900_23104 = state_22841__$1;
(statearr_22900_23104[(2)] = inst_22509);

(statearr_22900_23104[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (50))){
var inst_22807 = (state_22841[(2)]);
var state_22841__$1 = state_22841;
var statearr_22901_23105 = state_22841__$1;
(statearr_22901_23105[(2)] = inst_22807);

(statearr_22901_23105[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (116))){
var inst_22755 = (state_22841[(37)]);
var inst_22748 = (state_22841[(38)]);
var inst_22754 = cljs.core.seq.call(null,inst_22748);
var inst_22755__$1 = cljs.core.first.call(null,inst_22754);
var inst_22756 = cljs.core.next.call(null,inst_22754);
var state_22841__$1 = (function (){var statearr_22902 = state_22841;
(statearr_22902[(39)] = inst_22756);

(statearr_22902[(37)] = inst_22755__$1);

return statearr_22902;
})();
if(cljs.core.truth_(inst_22755__$1)){
var statearr_22903_23106 = state_22841__$1;
(statearr_22903_23106[(1)] = (118));

} else {
var statearr_22904_23107 = state_22841__$1;
(statearr_22904_23107[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (75))){
var inst_22548 = (state_22841[(25)]);
var inst_22578 = (state_22841[(2)]);
var inst_22540 = inst_22548;
var inst_22541 = inst_22578;
var state_22841__$1 = (function (){var statearr_22905 = state_22841;
(statearr_22905[(9)] = inst_22541);

(statearr_22905[(24)] = inst_22540);

return statearr_22905;
})();
var statearr_22906_23108 = state_22841__$1;
(statearr_22906_23108[(2)] = null);

(statearr_22906_23108[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (99))){
var inst_22677 = (state_22841[(40)]);
var inst_22443 = (state_22841[(15)]);
var inst_22680 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22681 = fluree.db.flake.o.call(null,inst_22677);
var inst_22682 = [inst_22681];
var inst_22683 = (new cljs.core.PersistentVector(null,1,(5),inst_22680,inst_22682,null));
var inst_22684 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_22685 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_22443);
var inst_22686 = [inst_22685];
var inst_22687 = cljs.core.PersistentHashMap.fromArrays(inst_22684,inst_22686);
var inst_22688 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22683,inst_22687);
var state_22841__$1 = state_22841;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22841__$1,(102),inst_22688);
} else {
if((state_val_22842 === (21))){
var inst_22447 = (state_22841[(41)]);
var state_22841__$1 = state_22841;
var statearr_22907_23109 = state_22841__$1;
(statearr_22907_23109[(2)] = inst_22447);

(statearr_22907_23109[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (31))){
var inst_22464 = (state_22841[(26)]);
var state_22841__$1 = state_22841;
var statearr_22908_23110 = state_22841__$1;
(statearr_22908_23110[(2)] = inst_22464);

(statearr_22908_23110[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (113))){
var inst_22456 = (state_22841[(13)]);
var inst_22459 = (state_22841[(16)]);
var inst_22460 = (state_22841[(17)]);
var inst_22413 = (state_22841[(35)]);
var inst_22454 = (state_22841[(18)]);
var inst_22461 = (state_22841[(19)]);
var inst_22457 = (state_22841[(20)]);
var inst_22455 = (state_22841[(14)]);
var inst_22428 = (state_22841[(42)]);
var inst_22458 = (state_22841[(21)]);
var inst_22443 = (state_22841[(15)]);
var inst_22730 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22731 = (function (){var p = inst_22461;
var pred_spec__$1 = inst_22428;
var orderBy = inst_22459;
var multi_QMARK_ = inst_22456;
var limit = inst_22458;
var offset = inst_22460;
var k = inst_22454;
var compact_QMARK_ = inst_22413;
var pred_spec_SINGLEQUOTE_ = inst_22443;
var map__22409 = inst_22455;
var ref_QMARK_ = inst_22457;
return (function (p1__22399_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"_id","_id",-789960287)],[fluree.db.flake.o.call(null,p1__22399_SHARP_)]);
});
})();
var inst_22732 = cljs.core.mapv.call(null,inst_22731,flakes);
var inst_22733 = [inst_22732,offset_map];
var inst_22734 = (new cljs.core.PersistentVector(null,2,(5),inst_22730,inst_22733,null));
var state_22841__$1 = state_22841;
var statearr_22909_23111 = state_22841__$1;
(statearr_22909_23111[(2)] = inst_22734);

(statearr_22909_23111[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (32))){
var inst_22470 = (state_22841[(2)]);
var state_22841__$1 = state_22841;
var statearr_22910_23112 = state_22841__$1;
(statearr_22910_23112[(2)] = inst_22470);

(statearr_22910_23112[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (136))){
var inst_22832 = (state_22841[(2)]);
var state_22841__$1 = state_22841;
var statearr_22911_23113 = state_22841__$1;
(statearr_22911_23113[(2)] = inst_22832);

(statearr_22911_23113[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (40))){
var inst_22456 = (state_22841[(13)]);
var state_22841__$1 = state_22841;
var statearr_22912_23114 = state_22841__$1;
(statearr_22912_23114[(2)] = inst_22456);

(statearr_22912_23114[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (129))){
var inst_22456 = (state_22841[(13)]);
var state_22841__$1 = state_22841;
if(cljs.core.truth_(inst_22456)){
var statearr_22913_23115 = state_22841__$1;
(statearr_22913_23115[(1)] = (131));

} else {
var statearr_22914_23116 = state_22841__$1;
(statearr_22914_23116[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (91))){
var inst_22443 = (state_22841[(15)]);
var inst_22652 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_22443);
var state_22841__$1 = state_22841;
var statearr_22915_23117 = state_22841__$1;
(statearr_22915_23117[(2)] = inst_22652);

(statearr_22915_23117[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (117))){
var inst_22785 = (state_22841[(2)]);
var state_22841__$1 = state_22841;
var statearr_22916_23118 = state_22841__$1;
(statearr_22916_23118[(2)] = inst_22785);

(statearr_22916_23118[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (108))){
var state_22841__$1 = state_22841;
var statearr_22917_23119 = state_22841__$1;
(statearr_22917_23119[(2)] = null);

(statearr_22917_23119[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (56))){
var inst_22518 = (state_22841[(2)]);
var state_22841__$1 = state_22841;
var statearr_22918_23120 = state_22841__$1;
(statearr_22918_23120[(2)] = inst_22518);

(statearr_22918_23120[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (33))){
var inst_22461 = (state_22841[(19)]);
var inst_22478 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22479 = cljs.core.get.call(null,offset_map,inst_22461);
var state_22841__$1 = (function (){var statearr_22919 = state_22841;
(statearr_22919[(43)] = inst_22478);

return statearr_22919;
})();
if(cljs.core.truth_(inst_22479)){
var statearr_22920_23121 = state_22841__$1;
(statearr_22920_23121[(1)] = (36));

} else {
var statearr_22921_23122 = state_22841__$1;
(statearr_22921_23122[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (13))){
var inst_22428 = (state_22841[(42)]);
var state_22841__$1 = state_22841;
var statearr_22922_23123 = state_22841__$1;
(statearr_22922_23123[(2)] = inst_22428);

(statearr_22922_23123[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (22))){
var inst_22443 = (state_22841[(15)]);
var inst_22450 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22443);
var state_22841__$1 = state_22841;
var statearr_22923_23124 = state_22841__$1;
(statearr_22923_23124[(2)] = inst_22450);

(statearr_22923_23124[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (90))){
var inst_22611 = (state_22841[(44)]);
var inst_22640 = (state_22841[(2)]);
var inst_22603 = inst_22611;
var inst_22604 = inst_22640;
var state_22841__$1 = (function (){var statearr_22924 = state_22841;
(statearr_22924[(30)] = inst_22604);

(statearr_22924[(45)] = inst_22603);

return statearr_22924;
})();
var statearr_22925_23125 = state_22841__$1;
(statearr_22925_23125[(2)] = null);

(statearr_22925_23125[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (109))){
var inst_22709 = (state_22841[(46)]);
var inst_22678 = (state_22841[(47)]);
var inst_22715 = (state_22841[(2)]);
var inst_22670 = inst_22678;
var inst_22671 = inst_22709;
var state_22841__$1 = (function (){var statearr_22926 = state_22841;
(statearr_22926[(48)] = inst_22670);

(statearr_22926[(32)] = inst_22671);

(statearr_22926[(49)] = inst_22715);

return statearr_22926;
})();
var statearr_22927_23126 = state_22841__$1;
(statearr_22927_23126[(2)] = null);

(statearr_22927_23126[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (36))){
var inst_22461 = (state_22841[(19)]);
var inst_22481 = cljs.core.update.call(null,offset_map,inst_22461,cljs.core.dec);
var state_22841__$1 = state_22841;
var statearr_22928_23127 = state_22841__$1;
(statearr_22928_23127[(2)] = inst_22481);

(statearr_22928_23127[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (41))){
var inst_22505 = (state_22841[(2)]);
var state_22841__$1 = state_22841;
if(cljs.core.truth_(inst_22505)){
var statearr_22929_23128 = state_22841__$1;
(statearr_22929_23128[(1)] = (48));

} else {
var statearr_22930_23129 = state_22841__$1;
(statearr_22930_23129[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (118))){
var inst_22755 = (state_22841[(37)]);
var inst_22758 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22759 = fluree.db.flake.o.call(null,inst_22755);
var inst_22760 = [inst_22759];
var inst_22761 = (new cljs.core.PersistentVector(null,1,(5),inst_22758,inst_22760,null));
var inst_22762 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22761);
var state_22841__$1 = state_22841;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22841__$1,(121),inst_22762);
} else {
if((state_val_22842 === (89))){
var inst_22604 = (state_22841[(30)]);
var state_22841__$1 = state_22841;
var statearr_22931_23130 = state_22841__$1;
(statearr_22931_23130[(2)] = inst_22604);

(statearr_22931_23130[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (100))){
var inst_22671 = (state_22841[(32)]);
var state_22841__$1 = state_22841;
var statearr_22932_23131 = state_22841__$1;
(statearr_22932_23131[(2)] = inst_22671);

(statearr_22932_23131[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (131))){
var inst_22454 = (state_22841[(18)]);
var inst_22811 = (state_22841[(10)]);
var inst_22810 = (state_22841[(50)]);
var inst_22819 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22820 = cljs.core.assoc.call(null,acc,inst_22454,inst_22810);
var inst_22821 = [inst_22820,inst_22811];
var inst_22822 = (new cljs.core.PersistentVector(null,2,(5),inst_22819,inst_22821,null));
var state_22841__$1 = state_22841;
var statearr_22933_23132 = state_22841__$1;
(statearr_22933_23132[(2)] = inst_22822);

(statearr_22933_23132[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (122))){
var inst_22749 = (state_22841[(33)]);
var inst_22756 = (state_22841[(39)]);
var inst_22755 = (state_22841[(37)]);
var inst_22768 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22769 = fluree.db.flake.o.call(null,inst_22755);
var inst_22770 = [inst_22769];
var inst_22771 = cljs.core.PersistentHashMap.fromArrays(inst_22768,inst_22770);
var inst_22772 = cljs.core.conj.call(null,inst_22749,inst_22771);
var inst_22748 = inst_22756;
var inst_22749__$1 = inst_22772;
var state_22841__$1 = (function (){var statearr_22934 = state_22841;
(statearr_22934[(33)] = inst_22749__$1);

(statearr_22934[(38)] = inst_22748);

return statearr_22934;
})();
var statearr_22935_23133 = state_22841__$1;
(statearr_22935_23133[(2)] = null);

(statearr_22935_23133[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (43))){
var inst_22491 = (state_22841[(29)]);
var state_22841__$1 = state_22841;
var statearr_22936_23134 = state_22841__$1;
(statearr_22936_23134[(2)] = inst_22491);

(statearr_22936_23134[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (61))){
var inst_22527 = (state_22841[(51)]);
var inst_22584 = (state_22841[(2)]);
var inst_22585 = [inst_22584,offset_map];
var inst_22586 = (new cljs.core.PersistentVector(null,2,(5),inst_22527,inst_22585,null));
var state_22841__$1 = state_22841;
var statearr_22937_23135 = state_22841__$1;
(statearr_22937_23135[(2)] = inst_22586);

(statearr_22937_23135[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (29))){
var inst_22473 = (state_22841[(2)]);
var state_22841__$1 = state_22841;
var statearr_22938_23136 = state_22841__$1;
(statearr_22938_23136[(2)] = inst_22473);

(statearr_22938_23136[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (44))){
var inst_22502 = (state_22841[(2)]);
var state_22841__$1 = state_22841;
var statearr_22939_23137 = state_22841__$1;
(statearr_22939_23137[(2)] = inst_22502);

(statearr_22939_23137[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (93))){
var inst_22655 = (state_22841[(2)]);
var state_22841__$1 = state_22841;
if(cljs.core.truth_(inst_22655)){
var statearr_22940_23138 = state_22841__$1;
(statearr_22940_23138[(1)] = (94));

} else {
var statearr_22941_23139 = state_22841__$1;
(statearr_22941_23139[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (6))){
var inst_22416 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22417 = (inst_22416 == null);
var state_22841__$1 = state_22841;
var statearr_22942_23140 = state_22841__$1;
(statearr_22942_23140[(2)] = inst_22417);

(statearr_22942_23140[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (111))){
var state_22841__$1 = state_22841;
var statearr_22943_23141 = state_22841__$1;
(statearr_22943_23141[(1)] = (125));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (28))){
var inst_22460 = (state_22841[(17)]);
var state_22841__$1 = state_22841;
var statearr_22945_23142 = state_22841__$1;
(statearr_22945_23142[(2)] = inst_22460);

(statearr_22945_23142[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (134))){
var inst_22454 = (state_22841[(18)]);
var inst_22811 = (state_22841[(10)]);
var inst_22810 = (state_22841[(50)]);
var inst_22825 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22826 = cljs.core.first.call(null,inst_22810);
var inst_22827 = cljs.core.assoc.call(null,acc,inst_22454,inst_22826);
var inst_22828 = [inst_22827,inst_22811];
var inst_22829 = (new cljs.core.PersistentVector(null,2,(5),inst_22825,inst_22828,null));
var state_22841__$1 = state_22841;
var statearr_22946_23143 = state_22841__$1;
(statearr_22946_23143[(2)] = inst_22829);

(statearr_22946_23143[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (64))){
var inst_22582 = (state_22841[(2)]);
var state_22841__$1 = state_22841;
var statearr_22947_23144 = state_22841__$1;
(statearr_22947_23144[(2)] = inst_22582);

(statearr_22947_23144[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (103))){
var inst_22671 = (state_22841[(32)]);
var inst_22677 = (state_22841[(40)]);
var inst_22694 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22695 = fluree.db.flake.o.call(null,inst_22677);
var inst_22696 = [inst_22695];
var inst_22697 = cljs.core.PersistentHashMap.fromArrays(inst_22694,inst_22696);
var inst_22698 = cljs.core.conj.call(null,inst_22671,inst_22697);
var state_22841__$1 = state_22841;
var statearr_22948_23145 = state_22841__$1;
(statearr_22948_23145[(2)] = inst_22698);

(statearr_22948_23145[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (51))){
var inst_22513 = (state_22841[(34)]);
var inst_22443 = (state_22841[(15)]);
var inst_22513__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_22443);
var state_22841__$1 = (function (){var statearr_22949 = state_22841;
(statearr_22949[(34)] = inst_22513__$1);

return statearr_22949;
})();
if(cljs.core.truth_(inst_22513__$1)){
var statearr_22950_23146 = state_22841__$1;
(statearr_22950_23146[(1)] = (54));

} else {
var statearr_22951_23147 = state_22841__$1;
(statearr_22951_23147[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (25))){
var inst_22456 = (state_22841[(13)]);
var state_22841__$1 = state_22841;
var statearr_22952_23148 = state_22841__$1;
(statearr_22952_23148[(2)] = inst_22456);

(statearr_22952_23148[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (34))){
var inst_22456 = (state_22841[(13)]);
var state_22841__$1 = state_22841;
if(cljs.core.truth_(inst_22456)){
var statearr_22953_23149 = state_22841__$1;
(statearr_22953_23149[(1)] = (39));

} else {
var statearr_22954_23150 = state_22841__$1;
(statearr_22954_23150[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (125))){
var inst_22456 = (state_22841[(13)]);
var inst_22459 = (state_22841[(16)]);
var inst_22460 = (state_22841[(17)]);
var inst_22413 = (state_22841[(35)]);
var inst_22454 = (state_22841[(18)]);
var inst_22461 = (state_22841[(19)]);
var inst_22457 = (state_22841[(20)]);
var inst_22455 = (state_22841[(14)]);
var inst_22428 = (state_22841[(42)]);
var inst_22458 = (state_22841[(21)]);
var inst_22443 = (state_22841[(15)]);
var inst_22790 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22791 = (function (){var p = inst_22461;
var pred_spec__$1 = inst_22428;
var orderBy = inst_22459;
var multi_QMARK_ = inst_22456;
var limit = inst_22458;
var offset = inst_22460;
var k = inst_22454;
var compact_QMARK_ = inst_22413;
var pred_spec_SINGLEQUOTE_ = inst_22443;
var map__22409 = inst_22455;
var ref_QMARK_ = inst_22457;
return (function (p1__22400_SHARP_){
return fluree.db.flake.o.call(null,p1__22400_SHARP_);
});
})();
var inst_22792 = cljs.core.mapv.call(null,inst_22791,flakes);
var inst_22793 = [inst_22792,offset_map];
var inst_22794 = (new cljs.core.PersistentVector(null,2,(5),inst_22790,inst_22793,null));
var state_22841__$1 = state_22841;
var statearr_22955_23151 = state_22841__$1;
(statearr_22955_23151[(2)] = inst_22794);

(statearr_22955_23151[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (17))){
var inst_22444 = (state_22841[(52)]);
var inst_22443 = (state_22841[(15)]);
var inst_22443__$1 = (state_22841[(2)]);
var inst_22444__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_22443__$1);
var state_22841__$1 = (function (){var statearr_22956 = state_22841;
(statearr_22956[(52)] = inst_22444__$1);

(statearr_22956[(15)] = inst_22443__$1);

return statearr_22956;
})();
if(cljs.core.truth_(inst_22444__$1)){
var statearr_22957_23152 = state_22841__$1;
(statearr_22957_23152[(1)] = (18));

} else {
var statearr_22958_23153 = state_22841__$1;
(statearr_22958_23153[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (3))){
var inst_22839 = (state_22841[(2)]);
var state_22841__$1 = state_22841;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22841__$1,inst_22839);
} else {
if((state_val_22842 === (12))){
var inst_22428 = (state_22841[(42)]);
var inst_22433 = cljs.core.assoc.call(null,inst_22428,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_22841__$1 = state_22841;
var statearr_22959_23154 = state_22841__$1;
(statearr_22959_23154[(2)] = inst_22433);

(statearr_22959_23154[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (2))){
var inst_22414 = (state_22841[(11)]);
var _ = (function (){var statearr_22960 = state_22841;
(statearr_22960[(4)] = cljs.core.cons.call(null,(5),(state_22841[(4)])));

return statearr_22960;
})();
var inst_22413 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22414__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_22841__$1 = (function (){var statearr_22961 = state_22841;
(statearr_22961[(35)] = inst_22413);

(statearr_22961[(11)] = inst_22414__$1);

return statearr_22961;
})();
if(cljs.core.truth_(inst_22414__$1)){
var statearr_22962_23155 = state_22841__$1;
(statearr_22962_23155[(1)] = (6));

} else {
var statearr_22963_23156 = state_22841__$1;
(statearr_22963_23156[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (66))){
var inst_22526 = (state_22841[(53)]);
var inst_22557 = (state_22841[(7)]);
var inst_22560 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22526,inst_22557);
var state_22841__$1 = state_22841;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22841__$1,(69),inst_22560);
} else {
if((state_val_22842 === (107))){
var inst_22691 = (state_22841[(27)]);
var inst_22711 = cljs.core.count.call(null,inst_22691);
var inst_22712 = fluree.db.query.fql_resp.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_22711);
var state_22841__$1 = state_22841;
var statearr_22964_23157 = state_22841__$1;
(statearr_22964_23157[(2)] = inst_22712);

(statearr_22964_23157[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (23))){
var inst_22452 = (state_22841[(2)]);
var state_22841__$1 = state_22841;
var statearr_22965_23158 = state_22841__$1;
(statearr_22965_23158[(2)] = inst_22452);

(statearr_22965_23158[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (47))){
var inst_22499 = (state_22841[(2)]);
var state_22841__$1 = state_22841;
var statearr_22966_23159 = state_22841__$1;
(statearr_22966_23159[(2)] = inst_22499);

(statearr_22966_23159[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (35))){
var inst_22810 = (state_22841[(50)]);
var inst_22809 = (state_22841[(2)]);
var inst_22810__$1 = cljs.core.nth.call(null,inst_22809,(0),null);
var inst_22811 = cljs.core.nth.call(null,inst_22809,(1),null);
var inst_22812 = cljs.core.empty_QMARK_.call(null,inst_22810__$1);
var state_22841__$1 = (function (){var statearr_22967 = state_22841;
(statearr_22967[(10)] = inst_22811);

(statearr_22967[(50)] = inst_22810__$1);

return statearr_22967;
})();
if(inst_22812){
var statearr_22968_23160 = state_22841__$1;
(statearr_22968_23160[(1)] = (128));

} else {
var statearr_22969_23161 = state_22841__$1;
(statearr_22969_23161[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (127))){
var inst_22797 = (state_22841[(2)]);
var state_22841__$1 = state_22841;
var statearr_22970_23162 = state_22841__$1;
(statearr_22970_23162[(2)] = inst_22797);

(statearr_22970_23162[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (82))){
var inst_22604 = (state_22841[(30)]);
var state_22841__$1 = state_22841;
var statearr_22971_23163 = state_22841__$1;
(statearr_22971_23163[(2)] = inst_22604);

(statearr_22971_23163[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (76))){
var inst_22590 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22598 = flakes;
var inst_22599 = cljs.core.seq.call(null,inst_22598);
var inst_22600 = cljs.core.first.call(null,inst_22599);
var inst_22601 = cljs.core.next.call(null,inst_22599);
var inst_22602 = cljs.core.PersistentVector.EMPTY;
var inst_22603 = inst_22598;
var inst_22604 = inst_22602;
var state_22841__$1 = (function (){var statearr_22972 = state_22841;
(statearr_22972[(54)] = inst_22590);

(statearr_22972[(55)] = inst_22601);

(statearr_22972[(30)] = inst_22604);

(statearr_22972[(56)] = inst_22600);

(statearr_22972[(45)] = inst_22603);

return statearr_22972;
})();
var statearr_22973_23164 = state_22841__$1;
(statearr_22973_23164[(2)] = null);

(statearr_22973_23164[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (97))){
var inst_22670 = (state_22841[(48)]);
var inst_22677 = (state_22841[(40)]);
var inst_22676 = cljs.core.seq.call(null,inst_22670);
var inst_22677__$1 = cljs.core.first.call(null,inst_22676);
var inst_22678 = cljs.core.next.call(null,inst_22676);
var state_22841__$1 = (function (){var statearr_22974 = state_22841;
(statearr_22974[(47)] = inst_22678);

(statearr_22974[(40)] = inst_22677__$1);

return statearr_22974;
})();
if(cljs.core.truth_(inst_22677__$1)){
var statearr_22975_23165 = state_22841__$1;
(statearr_22975_23165[(1)] = (99));

} else {
var statearr_22976_23166 = state_22841__$1;
(statearr_22976_23166[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (19))){
var inst_22447 = (state_22841[(41)]);
var inst_22443 = (state_22841[(15)]);
var inst_22447__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22443);
var state_22841__$1 = (function (){var statearr_22977 = state_22841;
(statearr_22977[(41)] = inst_22447__$1);

return statearr_22977;
})();
if(cljs.core.truth_(inst_22447__$1)){
var statearr_22978_23167 = state_22841__$1;
(statearr_22978_23167[(1)] = (21));

} else {
var statearr_22979_23168 = state_22841__$1;
(statearr_22979_23168[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (57))){
var inst_22443 = (state_22841[(15)]);
var inst_22523 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22524 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_22525 = (new cljs.core.PersistentVector(null,3,(5),inst_22523,inst_22524,null));
var inst_22526 = cljs.core.select_keys.call(null,inst_22443,inst_22525);
var inst_22527 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22535 = flakes;
var inst_22536 = cljs.core.seq.call(null,inst_22535);
var inst_22537 = cljs.core.first.call(null,inst_22536);
var inst_22538 = cljs.core.next.call(null,inst_22536);
var inst_22539 = cljs.core.PersistentVector.EMPTY;
var inst_22540 = inst_22535;
var inst_22541 = inst_22539;
var state_22841__$1 = (function (){var statearr_22980 = state_22841;
(statearr_22980[(53)] = inst_22526);

(statearr_22980[(51)] = inst_22527);

(statearr_22980[(9)] = inst_22541);

(statearr_22980[(24)] = inst_22540);

(statearr_22980[(57)] = inst_22537);

(statearr_22980[(58)] = inst_22538);

return statearr_22980;
})();
var statearr_22981_23169 = state_22841__$1;
(statearr_22981_23169[(2)] = null);

(statearr_22981_23169[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (68))){
var inst_22566 = (state_22841[(2)]);
var state_22841__$1 = (function (){var statearr_22982 = state_22841;
(statearr_22982[(22)] = inst_22566);

return statearr_22982;
})();
if(cljs.core.truth_(fuel)){
var statearr_22983_23170 = state_22841__$1;
(statearr_22983_23170[(1)] = (70));

} else {
var statearr_22984_23171 = state_22841__$1;
(statearr_22984_23171[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (11))){
var inst_22428 = (state_22841[(42)]);
var inst_22428__$1 = (state_22841[(2)]);
var inst_22430 = cljs.core.contains_QMARK_.call(null,inst_22428__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var inst_22431 = (!(inst_22430));
var state_22841__$1 = (function (){var statearr_22985 = state_22841;
(statearr_22985[(42)] = inst_22428__$1);

return statearr_22985;
})();
if(inst_22431){
var statearr_22986_23172 = state_22841__$1;
(statearr_22986_23172[(1)] = (12));

} else {
var statearr_22987_23173 = state_22841__$1;
(statearr_22987_23173[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (115))){
var inst_22787 = (state_22841[(2)]);
var state_22841__$1 = state_22841;
var statearr_22989_23174 = state_22841__$1;
(statearr_22989_23174[(2)] = inst_22787);

(statearr_22989_23174[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (9))){
var inst_22422 = cljs.core.first.call(null,flakes);
var inst_22423 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22422);
var inst_22424 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22425 = fluree.db.query.fql_resp.wildcard_pred_spec.call(null,db,cache,inst_22423,inst_22424);
var state_22841__$1 = state_22841;
var statearr_22990_23175 = state_22841__$1;
(statearr_22990_23175[(2)] = inst_22425);

(statearr_22990_23175[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (5))){
var _ = (function (){var statearr_22991 = state_22841;
(statearr_22991[(4)] = cljs.core.rest.call(null,(state_22841[(4)])));

return statearr_22991;
})();
var state_22841__$1 = state_22841;
var ex22988 = (state_22841__$1[(2)]);
var statearr_22992_23176 = state_22841__$1;
(statearr_22992_23176[(5)] = ex22988);


if((ex22988 instanceof Error)){
var statearr_22993_23177 = state_22841__$1;
(statearr_22993_23177[(1)] = (4));

(statearr_22993_23177[(5)] = null);

} else {
throw ex22988;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (112))){
var inst_22799 = (state_22841[(2)]);
var state_22841__$1 = state_22841;
var statearr_22994_23178 = state_22841__$1;
(statearr_22994_23178[(2)] = inst_22799);

(statearr_22994_23178[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (83))){
var inst_22644 = (state_22841[(2)]);
var state_22841__$1 = state_22841;
var statearr_22995_23179 = state_22841__$1;
(statearr_22995_23179[(2)] = inst_22644);

(statearr_22995_23179[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (14))){
var inst_22428 = (state_22841[(42)]);
var inst_22436 = (state_22841[(2)]);
var inst_22437 = cljs.core.contains_QMARK_.call(null,inst_22428,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var inst_22438 = (!(inst_22437));
var state_22841__$1 = (function (){var statearr_22996 = state_22841;
(statearr_22996[(36)] = inst_22436);

return statearr_22996;
})();
if(inst_22438){
var statearr_22997_23180 = state_22841__$1;
(statearr_22997_23180[(1)] = (15));

} else {
var statearr_22998_23181 = state_22841__$1;
(statearr_22998_23181[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (45))){
var inst_22454 = (state_22841[(18)]);
var inst_22458 = (state_22841[(21)]);
var inst_22494 = cljs.core.get.call(null,acc,inst_22454);
var inst_22495 = cljs.core.count.call(null,inst_22494);
var inst_22496 = (inst_22495 >= inst_22458);
var state_22841__$1 = state_22841;
var statearr_22999_23182 = state_22841__$1;
(statearr_22999_23182[(2)] = inst_22496);

(statearr_22999_23182[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (53))){
var inst_22521 = (state_22841[(2)]);
var state_22841__$1 = state_22841;
if(cljs.core.truth_(inst_22521)){
var statearr_23000_23183 = state_22841__$1;
(statearr_23000_23183[(1)] = (57));

} else {
var statearr_23001_23184 = state_22841__$1;
(statearr_23001_23184[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (78))){
var inst_22803 = (state_22841[(2)]);
var state_22841__$1 = state_22841;
var statearr_23002_23185 = state_22841__$1;
(statearr_23002_23185[(2)] = inst_22803);

(statearr_23002_23185[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (132))){
var state_22841__$1 = state_22841;
var statearr_23004_23186 = state_22841__$1;
(statearr_23004_23186[(1)] = (134));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (26))){
var inst_22476 = (state_22841[(2)]);
var state_22841__$1 = state_22841;
if(cljs.core.truth_(inst_22476)){
var statearr_23006_23187 = state_22841__$1;
(statearr_23006_23187[(1)] = (33));

} else {
var statearr_23007_23188 = state_22841__$1;
(statearr_23007_23188[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (123))){
var inst_22749 = (state_22841[(33)]);
var inst_22756 = (state_22841[(39)]);
var tmp23003 = inst_22749;
var inst_22748 = inst_22756;
var inst_22749__$1 = tmp23003;
var state_22841__$1 = (function (){var statearr_23008 = state_22841;
(statearr_23008[(33)] = inst_22749__$1);

(statearr_23008[(38)] = inst_22748);

return statearr_23008;
})();
var statearr_23009_23189 = state_22841__$1;
(statearr_23009_23189[(2)] = null);

(statearr_23009_23189[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (16))){
var inst_22436 = (state_22841[(36)]);
var state_22841__$1 = state_22841;
var statearr_23010_23190 = state_22841__$1;
(statearr_23010_23190[(2)] = inst_22436);

(statearr_23010_23190[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (133))){
var inst_22834 = (state_22841[(2)]);
var state_22841__$1 = state_22841;
var statearr_23011_23191 = state_22841__$1;
(statearr_23011_23191[(2)] = inst_22834);

(statearr_23011_23191[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (81))){
var inst_22610 = (state_22841[(28)]);
var inst_22619 = (state_22841[(59)]);
var inst_22443 = (state_22841[(15)]);
var inst_22613 = cljs.core.deref.call(null,cache);
var inst_22614 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22615 = fluree.db.flake.o.call(null,inst_22610);
var inst_22616 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22443);
var inst_22617 = [inst_22615,inst_22616];
var inst_22618 = (new cljs.core.PersistentVector(null,2,(5),inst_22614,inst_22617,null));
var inst_22619__$1 = cljs.core.get.call(null,inst_22613,inst_22618);
var state_22841__$1 = (function (){var statearr_23012 = state_22841;
(statearr_23012[(59)] = inst_22619__$1);

return statearr_23012;
})();
if(cljs.core.truth_(inst_22619__$1)){
var statearr_23013_23192 = state_22841__$1;
(statearr_23013_23192[(1)] = (84));

} else {
var statearr_23014_23193 = state_22841__$1;
(statearr_23014_23193[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (120))){
var inst_22783 = (state_22841[(2)]);
var state_22841__$1 = state_22841;
var statearr_23015_23194 = state_22841__$1;
(statearr_23015_23194[(2)] = inst_22783);

(statearr_23015_23194[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (79))){
var inst_22610 = (state_22841[(28)]);
var inst_22603 = (state_22841[(45)]);
var inst_22609 = cljs.core.seq.call(null,inst_22603);
var inst_22610__$1 = cljs.core.first.call(null,inst_22609);
var inst_22611 = cljs.core.next.call(null,inst_22609);
var state_22841__$1 = (function (){var statearr_23016 = state_22841;
(statearr_23016[(44)] = inst_22611);

(statearr_23016[(28)] = inst_22610__$1);

return statearr_23016;
})();
if(cljs.core.truth_(inst_22610__$1)){
var statearr_23017_23195 = state_22841__$1;
(statearr_23017_23195[(1)] = (81));

} else {
var statearr_23018_23196 = state_22841__$1;
(statearr_23018_23196[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (38))){
var inst_22478 = (state_22841[(43)]);
var inst_22486 = (state_22841[(2)]);
var inst_22487 = [null,inst_22486];
var inst_22488 = (new cljs.core.PersistentVector(null,2,(5),inst_22478,inst_22487,null));
var state_22841__$1 = state_22841;
var statearr_23019_23197 = state_22841__$1;
(statearr_23019_23197[(2)] = inst_22488);

(statearr_23019_23197[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (126))){
var state_22841__$1 = state_22841;
var statearr_23020_23198 = state_22841__$1;
(statearr_23020_23198[(2)] = null);

(statearr_23020_23198[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (98))){
var inst_22657 = (state_22841[(60)]);
var inst_22721 = (state_22841[(2)]);
var inst_22722 = [inst_22721,offset_map];
var inst_22723 = (new cljs.core.PersistentVector(null,2,(5),inst_22657,inst_22722,null));
var state_22841__$1 = state_22841;
var statearr_23021_23199 = state_22841__$1;
(statearr_23021_23199[(2)] = inst_22723);

(statearr_23021_23199[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (124))){
var inst_22777 = (state_22841[(2)]);
var state_22841__$1 = state_22841;
var statearr_23022_23200 = state_22841__$1;
(statearr_23022_23200[(2)] = inst_22777);

(statearr_23022_23200[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (87))){
var inst_22610 = (state_22841[(28)]);
var inst_22443 = (state_22841[(15)]);
var inst_22626 = (state_22841[(2)]);
var inst_22627 = fluree.db.util.async.throw_err.call(null,inst_22626);
var inst_22628 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22629 = fluree.db.flake.o.call(null,inst_22610);
var inst_22630 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22443);
var inst_22631 = [inst_22629,inst_22630];
var inst_22632 = (new cljs.core.PersistentVector(null,2,(5),inst_22628,inst_22631,null));
var inst_22633 = fluree.db.query.fql_resp.vswap_BANG_.call(null,cache,cljs.core.assoc,inst_22632,inst_22627);
var state_22841__$1 = (function (){var statearr_23023 = state_22841;
(statearr_23023[(61)] = inst_22633);

return statearr_23023;
})();
var statearr_23024_23201 = state_22841__$1;
(statearr_23024_23201[(2)] = inst_22627);

(statearr_23024_23201[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (30))){
var inst_22461 = (state_22841[(19)]);
var inst_22466 = cljs.core.get.call(null,offset_map,inst_22461);
var inst_22467 = cljs.core.not_EQ_.call(null,(0),inst_22466);
var state_22841__$1 = state_22841;
var statearr_23025_23202 = state_22841__$1;
(statearr_23025_23202[(2)] = inst_22467);

(statearr_23025_23202[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (73))){
var inst_22566 = (state_22841[(22)]);
var inst_22541 = (state_22841[(9)]);
var inst_22575 = cljs.core.conj.call(null,inst_22541,inst_22566);
var state_22841__$1 = state_22841;
var statearr_23026_23203 = state_22841__$1;
(statearr_23026_23203[(2)] = inst_22575);

(statearr_23026_23203[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (96))){
var inst_22801 = (state_22841[(2)]);
var state_22841__$1 = state_22841;
var statearr_23027_23204 = state_22841__$1;
(statearr_23027_23204[(2)] = inst_22801);

(statearr_23027_23204[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (10))){
var state_22841__$1 = state_22841;
var statearr_23028_23205 = state_22841__$1;
(statearr_23028_23205[(2)] = pred_spec);

(statearr_23028_23205[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (18))){
var inst_22444 = (state_22841[(52)]);
var state_22841__$1 = state_22841;
var statearr_23029_23206 = state_22841__$1;
(statearr_23029_23206[(2)] = inst_22444);

(statearr_23029_23206[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (105))){
var inst_22709 = (state_22841[(2)]);
var state_22841__$1 = (function (){var statearr_23030 = state_22841;
(statearr_23030[(46)] = inst_22709);

return statearr_23030;
})();
if(cljs.core.truth_(fuel)){
var statearr_23031_23207 = state_22841__$1;
(statearr_23031_23207[(1)] = (107));

} else {
var statearr_23032_23208 = state_22841__$1;
(statearr_23032_23208[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (52))){
var inst_22511 = (state_22841[(62)]);
var state_22841__$1 = state_22841;
var statearr_23033_23209 = state_22841__$1;
(statearr_23033_23209[(2)] = inst_22511);

(statearr_23033_23209[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (114))){
var inst_22743 = flakes;
var inst_22744 = cljs.core.seq.call(null,inst_22743);
var inst_22745 = cljs.core.first.call(null,inst_22744);
var inst_22746 = cljs.core.next.call(null,inst_22744);
var inst_22747 = cljs.core.PersistentVector.EMPTY;
var inst_22748 = inst_22743;
var inst_22749 = inst_22747;
var state_22841__$1 = (function (){var statearr_23034 = state_22841;
(statearr_23034[(63)] = inst_22746);

(statearr_23034[(64)] = inst_22745);

(statearr_23034[(33)] = inst_22749);

(statearr_23034[(38)] = inst_22748);

return statearr_23034;
})();
var statearr_23035_23210 = state_22841__$1;
(statearr_23035_23210[(2)] = null);

(statearr_23035_23210[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (67))){
var state_22841__$1 = state_22841;
var statearr_23036_23211 = state_22841__$1;
(statearr_23036_23211[(2)] = null);

(statearr_23036_23211[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (71))){
var state_22841__$1 = state_22841;
var statearr_23037_23212 = state_22841__$1;
(statearr_23037_23212[(2)] = null);

(statearr_23037_23212[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (42))){
var inst_22458 = (state_22841[(21)]);
var state_22841__$1 = state_22841;
if(cljs.core.truth_(inst_22458)){
var statearr_23038_23213 = state_22841__$1;
(statearr_23038_23213[(1)] = (45));

} else {
var statearr_23039_23214 = state_22841__$1;
(statearr_23039_23214[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (80))){
var inst_22590 = (state_22841[(54)]);
var inst_22646 = (state_22841[(2)]);
var inst_22647 = [inst_22646,offset_map];
var inst_22648 = (new cljs.core.PersistentVector(null,2,(5),inst_22590,inst_22647,null));
var state_22841__$1 = state_22841;
var statearr_23040_23215 = state_22841__$1;
(statearr_23040_23215[(2)] = inst_22648);

(statearr_23040_23215[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (37))){
var inst_22460 = (state_22841[(17)]);
var inst_22461 = (state_22841[(19)]);
var inst_22483 = (inst_22460 - (1));
var inst_22484 = cljs.core.assoc.call(null,offset_map,inst_22461,inst_22483);
var state_22841__$1 = state_22841;
var statearr_23041_23216 = state_22841__$1;
(statearr_23041_23216[(2)] = inst_22484);

(statearr_23041_23216[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (63))){
var inst_22541 = (state_22841[(9)]);
var state_22841__$1 = state_22841;
var statearr_23042_23217 = state_22841__$1;
(statearr_23042_23217[(2)] = inst_22541);

(statearr_23042_23217[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (94))){
var inst_22657 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22665 = flakes;
var inst_22666 = cljs.core.seq.call(null,inst_22665);
var inst_22667 = cljs.core.first.call(null,inst_22666);
var inst_22668 = cljs.core.next.call(null,inst_22666);
var inst_22669 = cljs.core.PersistentVector.EMPTY;
var inst_22670 = inst_22665;
var inst_22671 = inst_22669;
var state_22841__$1 = (function (){var statearr_23043 = state_22841;
(statearr_23043[(65)] = inst_22668);

(statearr_23043[(66)] = inst_22667);

(statearr_23043[(48)] = inst_22670);

(statearr_23043[(32)] = inst_22671);

(statearr_23043[(60)] = inst_22657);

return statearr_23043;
})();
var statearr_23044_23218 = state_22841__$1;
(statearr_23044_23218[(2)] = null);

(statearr_23044_23218[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (8))){
var inst_22420 = (state_22841[(2)]);
var state_22841__$1 = state_22841;
if(cljs.core.truth_(inst_22420)){
var statearr_23045_23219 = state_22841__$1;
(statearr_23045_23219[(1)] = (9));

} else {
var statearr_23046_23220 = state_22841__$1;
(statearr_23046_23220[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (49))){
var inst_22511 = (state_22841[(62)]);
var inst_22511__$1 = cljs.core.not.call(null,recur_QMARK_);
var state_22841__$1 = (function (){var statearr_23047 = state_22841;
(statearr_23047[(62)] = inst_22511__$1);

return statearr_23047;
})();
if(inst_22511__$1){
var statearr_23048_23221 = state_22841__$1;
(statearr_23048_23221[(1)] = (51));

} else {
var statearr_23049_23222 = state_22841__$1;
(statearr_23049_23222[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22842 === (84))){
var inst_22619 = (state_22841[(59)]);
var state_22841__$1 = state_22841;
var statearr_23050_23223 = state_22841__$1;
(statearr_23050_23223[(2)] = inst_22619);

(statearr_23050_23223[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$state_machine__2746__auto__ = null;
var fluree$db$query$fql_resp$state_machine__2746__auto____0 = (function (){
var statearr_23051 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23051[(0)] = fluree$db$query$fql_resp$state_machine__2746__auto__);

(statearr_23051[(1)] = (1));

return statearr_23051;
});
var fluree$db$query$fql_resp$state_machine__2746__auto____1 = (function (state_22841){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_22841);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23052){var ex__2749__auto__ = e23052;
var statearr_23053_23224 = state_22841;
(statearr_23053_23224[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_22841[(4)]))){
var statearr_23054_23225 = state_22841;
(statearr_23054_23225[(1)] = cljs.core.first.call(null,(state_22841[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23226 = state_22841;
state_22841 = G__23226;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql_resp$state_machine__2746__auto__ = function(state_22841){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$state_machine__2746__auto____1.call(this,state_22841);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$state_machine__2746__auto____0;
fluree$db$query$fql_resp$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$state_machine__2746__auto____1;
return fluree$db$query$fql_resp$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23055 = f__2769__auto__.call(null);
(statearr_23055[(6)] = c__2768__auto__);

return statearr_23055;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.fql_resp.add_pred.cljs$lang$maxFixedArity = 10);

fluree.db.query.fql_resp.compare_fn = (function fluree$db$query$fql_resp$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare.call(null,clojure.string.upper_case.call(null,a),clojure.string.upper_case.call(null,b));
if(cljs.core._EQ_.call(null,res,(0))){
return ((-1) * cljs.core.compare.call(null,a,b));
} else {
return res;
}
} else {
return cljs.core.compare.call(null,a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql_resp.sort_offset_and_limit_res = (function fluree$db$query$fql_resp$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_.call(null,res)){
var G__23228 = res;
var G__23228__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.call(null,(function (p1__23227_SHARP_){
return cljs.core.get.call(null,p1__23227_SHARP_,sortPred);
}),fluree.db.query.fql_resp.compare_fn,G__23228):G__23228);
var G__23228__$2 = ((cljs.core._EQ_.call(null,"DESC",sortOrder))?cljs.core.reverse.call(null,G__23228__$1):G__23228__$1);
var G__23228__$3 = (cljs.core.truth_(offset)?cljs.core.drop.call(null,offset,G__23228__$2):G__23228__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.call(null,limit,G__23228__$3);
} else {
return G__23228__$3;
}
} else {
return res;
}
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql_resp.flakes__GT_res = (function fluree$db$query$fql_resp$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23409){
var state_val_23410 = (state_23409[(1)]);
if((state_val_23410 === (7))){
var state_23409__$1 = state_23409;
var statearr_23411_23497 = state_23409__$1;
(statearr_23411_23497[(2)] = null);

(statearr_23411_23497[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (20))){
var inst_23267 = cljs.core.PersistentHashMap.EMPTY;
var state_23409__$1 = state_23409;
var statearr_23412_23498 = state_23409__$1;
(statearr_23412_23498[(2)] = inst_23267);

(statearr_23412_23498[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (27))){
var inst_23255 = (state_23409[(7)]);
var inst_23285 = (state_23409[(8)]);
var inst_23269 = (state_23409[(9)]);
var inst_23249 = (state_23409[(10)]);
var inst_23388 = (state_23409[(2)]);
var inst_23389 = (function (){var top_level_subject = inst_23249;
var select_spec = inst_23255;
var base_acc = inst_23269;
var acc_PLUS_refs = inst_23285;
var result = inst_23388;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__5045__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var and__5043__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
}
})())){
return cljs.core.conj.call(null,acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_23390 = cljs.core.PersistentVector.EMPTY;
var inst_23391 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23255);
var inst_23392 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_23391);
var inst_23393 = cljs.core.vals.call(null,inst_23392);
var inst_23394 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23255);
var inst_23395 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_23394);
var inst_23396 = cljs.core.vals.call(null,inst_23395);
var inst_23397 = cljs.core.concat.call(null,inst_23393,inst_23396);
var inst_23398 = cljs.core.reduce.call(null,inst_23389,inst_23390,inst_23397);
var inst_23400 = (function (){var top_level_subject = inst_23249;
var select_spec = inst_23255;
var base_acc = inst_23269;
var acc_PLUS_refs = inst_23285;
var result = inst_23388;
var sort_preds = inst_23398;
return (function (acc,p__23399){
var vec__23413 = p__23399;
var selectPred = cljs.core.nth.call(null,vec__23413,(0),null);
var sortOrder = cljs.core.nth.call(null,vec__23413,(1),null);
var sortPred = cljs.core.nth.call(null,vec__23413,(2),null);
var limit = cljs.core.nth.call(null,vec__23413,(3),null);
return cljs.core.assoc.call(null,acc,selectPred,fluree.db.query.fql_resp.sort_offset_and_limit_res.call(null,sortPred,sortOrder,(0),limit,cljs.core.get.call(null,acc,selectPred)));
});
})();
var inst_23401 = cljs.core.reduce.call(null,inst_23400,inst_23388,inst_23398);
var state_23409__$1 = state_23409;
var statearr_23416_23499 = state_23409__$1;
(statearr_23416_23499[(2)] = inst_23401);

(statearr_23416_23499[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (1))){
var state_23409__$1 = state_23409;
var statearr_23417_23500 = state_23409__$1;
(statearr_23417_23500[(2)] = null);

(statearr_23417_23500[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (24))){
var inst_23285 = (state_23409[(8)]);
var inst_23285__$1 = (state_23409[(2)]);
var inst_23286 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"p","p",151049309),flakes);
var inst_23287 = cljs.core.PersistentHashMap.EMPTY;
var inst_23288 = inst_23286;
var inst_23289 = inst_23285__$1;
var inst_23290 = inst_23287;
var state_23409__$1 = (function (){var statearr_23418 = state_23409;
(statearr_23418[(8)] = inst_23285__$1);

(statearr_23418[(11)] = inst_23289);

(statearr_23418[(12)] = inst_23288);

(statearr_23418[(13)] = inst_23290);

return statearr_23418;
})();
var statearr_23419_23501 = state_23409__$1;
(statearr_23419_23501[(2)] = null);

(statearr_23419_23501[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (39))){
var inst_23298 = (state_23409[(14)]);
var inst_23255 = (state_23409[(7)]);
var inst_23289 = (state_23409[(11)]);
var inst_23305 = (state_23409[(15)]);
var inst_23334 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23335 = fluree.db.query.fql_resp.add_pred.call(null,db,cache,fuel,max_fuel,inst_23289,inst_23255,inst_23298,inst_23305,false);
var state_23409__$1 = (function (){var statearr_23420 = state_23409;
(statearr_23420[(16)] = inst_23334);

return statearr_23420;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23409__$1,(42),inst_23335);
} else {
if((state_val_23410 === (46))){
var inst_23298 = (state_23409[(14)]);
var inst_23288 = (state_23409[(12)]);
var inst_23290 = (state_23409[(13)]);
var inst_23352 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23353 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23354 = cljs.core.first.call(null,inst_23298);
var inst_23355 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_23354);
var inst_23356 = [inst_23355];
var inst_23357 = cljs.core.PersistentHashMap.fromArrays(inst_23353,inst_23356);
var inst_23358 = cljs.core.rest.call(null,inst_23288);
var inst_23359 = [inst_23357,inst_23358,inst_23290];
var inst_23360 = (new cljs.core.PersistentVector(null,3,(5),inst_23352,inst_23359,null));
var state_23409__$1 = state_23409;
var statearr_23421_23502 = state_23409__$1;
(statearr_23421_23502[(2)] = inst_23360);

(statearr_23421_23502[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (4))){
var inst_23229 = (state_23409[(2)]);
var state_23409__$1 = state_23409;
var statearr_23422_23503 = state_23409__$1;
(statearr_23422_23503[(2)] = inst_23229);

(statearr_23422_23503[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (15))){
var inst_23255 = (state_23409[(7)]);
var inst_23256 = (state_23409[(17)]);
var inst_23255__$1 = (state_23409[(2)]);
var inst_23256__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23255__$1);
var state_23409__$1 = (function (){var statearr_23423 = state_23409;
(statearr_23423[(7)] = inst_23255__$1);

(statearr_23423[(17)] = inst_23256__$1);

return statearr_23423;
})();
if(cljs.core.truth_(inst_23256__$1)){
var statearr_23424_23504 = state_23409__$1;
(statearr_23424_23504[(1)] = (16));

} else {
var statearr_23425_23505 = state_23409__$1;
(statearr_23425_23505[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (48))){
var inst_23371 = (state_23409[(2)]);
var state_23409__$1 = state_23409;
var statearr_23426_23506 = state_23409__$1;
(statearr_23426_23506[(2)] = inst_23371);

(statearr_23426_23506[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (50))){
var state_23409__$1 = state_23409;
var statearr_23427_23507 = state_23409__$1;
(statearr_23427_23507[(2)] = null);

(statearr_23427_23507[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (21))){
var inst_23255 = (state_23409[(7)]);
var inst_23269 = (state_23409[(2)]);
var inst_23270 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23271 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_23272 = (new cljs.core.PersistentVector(null,2,(5),inst_23270,inst_23271,null));
var inst_23273 = cljs.core.get_in.call(null,inst_23255,inst_23272);
var state_23409__$1 = (function (){var statearr_23428 = state_23409;
(statearr_23428[(9)] = inst_23269);

return statearr_23428;
})();
if(cljs.core.truth_(inst_23273)){
var statearr_23429_23508 = state_23409__$1;
(statearr_23429_23508[(1)] = (22));

} else {
var statearr_23430_23509 = state_23409__$1;
(statearr_23430_23509[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (31))){
var inst_23298 = (state_23409[(14)]);
var inst_23289 = (state_23409[(11)]);
var inst_23304 = (state_23409[(18)]);
var inst_23308 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23309 = fluree.db.query.fql_resp.flake__GT_recur.call(null,db,inst_23298,inst_23304,inst_23289,fuel,max_fuel,cache);
var state_23409__$1 = (function (){var statearr_23431 = state_23409;
(statearr_23431[(19)] = inst_23308);

return statearr_23431;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23409__$1,(34),inst_23309);
} else {
if((state_val_23410 === (32))){
var inst_23304 = (state_23409[(18)]);
var state_23409__$1 = state_23409;
if(cljs.core.truth_(inst_23304)){
var statearr_23432_23510 = state_23409__$1;
(statearr_23432_23510[(1)] = (35));

} else {
var statearr_23433_23511 = state_23409__$1;
(statearr_23433_23511[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (40))){
var inst_23255 = (state_23409[(7)]);
var inst_23345 = (state_23409[(20)]);
var inst_23344 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23255);
var inst_23345__$1 = cljs.core.empty_QMARK_.call(null,inst_23344);
var state_23409__$1 = (function (){var statearr_23434 = state_23409;
(statearr_23434[(20)] = inst_23345__$1);

return statearr_23434;
})();
if(inst_23345__$1){
var statearr_23435_23512 = state_23409__$1;
(statearr_23435_23512[(1)] = (43));

} else {
var statearr_23436_23513 = state_23409__$1;
(statearr_23436_23513[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (33))){
var inst_23298 = (state_23409[(14)]);
var inst_23377 = (state_23409[(2)]);
var inst_23378 = cljs.core.nth.call(null,inst_23377,(0),null);
var inst_23379 = cljs.core.nth.call(null,inst_23377,(1),null);
var inst_23380 = cljs.core.nth.call(null,inst_23377,(2),null);
var inst_23381 = cljs.core.first.call(null,inst_23298);
var inst_23382 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_23381);
var inst_23383 = cljs.core.assoc.call(null,inst_23378,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_23382);
var inst_23288 = inst_23379;
var inst_23289 = inst_23383;
var inst_23290 = inst_23380;
var state_23409__$1 = (function (){var statearr_23437 = state_23409;
(statearr_23437[(11)] = inst_23289);

(statearr_23437[(12)] = inst_23288);

(statearr_23437[(13)] = inst_23290);

return statearr_23437;
})();
var statearr_23438_23514 = state_23409__$1;
(statearr_23438_23514[(2)] = null);

(statearr_23438_23514[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (13))){
var inst_23249 = (state_23409[(10)]);
var inst_23252 = fluree.db.query.fql_resp.full_select_spec.call(null,db,cache,base_select_spec,inst_23249);
var state_23409__$1 = state_23409;
var statearr_23439_23515 = state_23409__$1;
(statearr_23439_23515[(2)] = inst_23252);

(statearr_23439_23515[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (22))){
var inst_23255 = (state_23409[(7)]);
var inst_23275 = cljs.core.first.call(null,flakes);
var inst_23276 = fluree.db.flake.s.call(null,inst_23275);
var inst_23277 = fluree.db.query.fql_resp.select_spec__GT_reverse_pred_specs.call(null,inst_23255);
var inst_23278 = fluree.db.query.fql_resp.resolve_reverse_refs.call(null,db,cache,fuel,max_fuel,inst_23276,inst_23277);
var state_23409__$1 = state_23409;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23409__$1,(25),inst_23278);
} else {
if((state_val_23410 === (36))){
var inst_23255 = (state_23409[(7)]);
var inst_23332 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23255);
var state_23409__$1 = state_23409;
if(cljs.core.truth_(inst_23332)){
var statearr_23440_23516 = state_23409__$1;
(statearr_23440_23516[(1)] = (39));

} else {
var statearr_23441_23517 = state_23409__$1;
(statearr_23441_23517[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (41))){
var inst_23373 = (state_23409[(2)]);
var state_23409__$1 = state_23409;
var statearr_23442_23518 = state_23409__$1;
(statearr_23442_23518[(2)] = inst_23373);

(statearr_23442_23518[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (43))){
var inst_23255 = (state_23409[(7)]);
var inst_23347 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23255);
var state_23409__$1 = state_23409;
var statearr_23443_23519 = state_23409__$1;
(statearr_23443_23519[(2)] = inst_23347);

(statearr_23443_23519[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (29))){
var inst_23298 = (state_23409[(14)]);
var inst_23255 = (state_23409[(7)]);
var inst_23288 = (state_23409[(12)]);
var inst_23304 = (state_23409[(18)]);
var inst_23298__$1 = cljs.core.first.call(null,inst_23288);
var inst_23299 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23300 = cljs.core.first.call(null,inst_23298__$1);
var inst_23301 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_23300);
var inst_23302 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_23301];
var inst_23303 = (new cljs.core.PersistentVector(null,3,(5),inst_23299,inst_23302,null));
var inst_23304__$1 = cljs.core.get_in.call(null,inst_23255,inst_23303);
var inst_23305 = fluree.db.query.fql_resp.component_follow_QMARK_.call(null,inst_23304__$1,inst_23255);
var inst_23306 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_23304__$1);
var state_23409__$1 = (function (){var statearr_23444 = state_23409;
(statearr_23444[(14)] = inst_23298__$1);

(statearr_23444[(18)] = inst_23304__$1);

(statearr_23444[(15)] = inst_23305);

return statearr_23444;
})();
if(cljs.core.truth_(inst_23306)){
var statearr_23445_23520 = state_23409__$1;
(statearr_23445_23520[(1)] = (31));

} else {
var statearr_23446_23521 = state_23409__$1;
(statearr_23446_23521[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (44))){
var inst_23345 = (state_23409[(20)]);
var state_23409__$1 = state_23409;
var statearr_23447_23522 = state_23409__$1;
(statearr_23447_23522[(2)] = inst_23345);

(statearr_23447_23522[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (6))){
var state_23409__$1 = state_23409;
var statearr_23448_23523 = state_23409__$1;
(statearr_23448_23523[(2)] = null);

(statearr_23448_23523[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (28))){
var inst_23289 = (state_23409[(11)]);
var state_23409__$1 = state_23409;
var statearr_23449_23524 = state_23409__$1;
(statearr_23449_23524[(2)] = inst_23289);

(statearr_23449_23524[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (51))){
var inst_23369 = (state_23409[(2)]);
var state_23409__$1 = state_23409;
var statearr_23450_23525 = state_23409__$1;
(statearr_23450_23525[(2)] = inst_23369);

(statearr_23450_23525[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (25))){
var inst_23269 = (state_23409[(9)]);
var inst_23280 = (state_23409[(2)]);
var inst_23281 = fluree.db.util.async.throw_err.call(null,inst_23280);
var inst_23282 = cljs.core.merge.call(null,inst_23269,inst_23281);
var state_23409__$1 = state_23409;
var statearr_23451_23526 = state_23409__$1;
(statearr_23451_23526[(2)] = inst_23282);

(statearr_23451_23526[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (34))){
var inst_23308 = (state_23409[(19)]);
var inst_23288 = (state_23409[(12)]);
var inst_23290 = (state_23409[(13)]);
var inst_23311 = (state_23409[(2)]);
var inst_23312 = fluree.db.util.async.throw_err.call(null,inst_23311);
var inst_23313 = cljs.core.rest.call(null,inst_23288);
var inst_23314 = [inst_23312,inst_23313,inst_23290];
var inst_23315 = (new cljs.core.PersistentVector(null,3,(5),inst_23308,inst_23314,null));
var state_23409__$1 = state_23409;
var statearr_23452_23527 = state_23409__$1;
(statearr_23452_23527[(2)] = inst_23315);

(statearr_23452_23527[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (17))){
var inst_23255 = (state_23409[(7)]);
var inst_23259 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23255);
var state_23409__$1 = state_23409;
var statearr_23454_23528 = state_23409__$1;
(statearr_23454_23528[(2)] = inst_23259);

(statearr_23454_23528[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (3))){
var inst_23407 = (state_23409[(2)]);
var state_23409__$1 = state_23409;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23409__$1,inst_23407);
} else {
if((state_val_23410 === (12))){
var _ = (function (){var statearr_23455 = state_23409;
(statearr_23455[(4)] = cljs.core.rest.call(null,(state_23409[(4)])));

return statearr_23455;
})();
var state_23409__$1 = state_23409;
var ex23453 = (state_23409__$1[(2)]);
var statearr_23456_23529 = state_23409__$1;
(statearr_23456_23529[(5)] = ex23453);


var statearr_23457_23530 = state_23409__$1;
(statearr_23457_23530[(1)] = (11));

(statearr_23457_23530[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (2))){
var _ = (function (){var statearr_23458 = state_23409;
(statearr_23458[(4)] = cljs.core.cons.call(null,(5),(state_23409[(4)])));

return statearr_23458;
})();
var inst_23235 = cljs.core.not_empty.call(null,flakes);
var state_23409__$1 = state_23409;
if(cljs.core.truth_(inst_23235)){
var statearr_23459_23531 = state_23409__$1;
(statearr_23459_23531[(1)] = (6));

} else {
var statearr_23460_23532 = state_23409__$1;
(statearr_23460_23532[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (23))){
var inst_23269 = (state_23409[(9)]);
var state_23409__$1 = state_23409;
var statearr_23461_23533 = state_23409__$1;
(statearr_23461_23533[(2)] = inst_23269);

(statearr_23461_23533[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (47))){
var state_23409__$1 = state_23409;
var statearr_23462_23534 = state_23409__$1;
(statearr_23462_23534[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (35))){
var inst_23298 = (state_23409[(14)]);
var inst_23289 = (state_23409[(11)]);
var inst_23304 = (state_23409[(18)]);
var inst_23305 = (state_23409[(15)]);
var inst_23290 = (state_23409[(13)]);
var inst_23321 = fluree.db.query.fql_resp.add_pred.call(null,db,cache,fuel,max_fuel,inst_23289,inst_23304,inst_23298,inst_23305,false,inst_23290);
var state_23409__$1 = state_23409;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23409__$1,(38),inst_23321);
} else {
if((state_val_23410 === (19))){
var inst_23249 = (state_23409[(10)]);
var inst_23263 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23264 = [inst_23249];
var inst_23265 = cljs.core.PersistentHashMap.fromArrays(inst_23263,inst_23264);
var state_23409__$1 = state_23409;
var statearr_23464_23535 = state_23409__$1;
(statearr_23464_23535[(2)] = inst_23265);

(statearr_23464_23535[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (11))){
var inst_23237 = (state_23409[(2)]);
var inst_23238 = fluree.db.util.log.error.call(null,inst_23237);
var inst_23239 = (function(){throw inst_23237})();
var state_23409__$1 = (function (){var statearr_23466 = state_23409;
(statearr_23466[(21)] = inst_23238);

return statearr_23466;
})();
var statearr_23467_23536 = state_23409__$1;
(statearr_23467_23536[(2)] = inst_23239);

(statearr_23467_23536[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (9))){
var _ = (function (){var statearr_23468 = state_23409;
(statearr_23468[(4)] = cljs.core.cons.call(null,(12),(state_23409[(4)])));

return statearr_23468;
})();
var inst_23245 = cljs.core.first.call(null,flakes);
var inst_23246 = fluree.db.flake.s.call(null,inst_23245);
var ___$1 = (function (){var statearr_23469 = state_23409;
(statearr_23469[(4)] = cljs.core.rest.call(null,(state_23409[(4)])));

return statearr_23469;
})();
var state_23409__$1 = state_23409;
var statearr_23470_23537 = state_23409__$1;
(statearr_23470_23537[(2)] = inst_23246);

(statearr_23470_23537[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (5))){
var _ = (function (){var statearr_23471 = state_23409;
(statearr_23471[(4)] = cljs.core.rest.call(null,(state_23409[(4)])));

return statearr_23471;
})();
var state_23409__$1 = state_23409;
var ex23465 = (state_23409__$1[(2)]);
var statearr_23472_23538 = state_23409__$1;
(statearr_23472_23538[(5)] = ex23465);


if((ex23465 instanceof Error)){
var statearr_23473_23539 = state_23409__$1;
(statearr_23473_23539[(1)] = (4));

(statearr_23473_23539[(5)] = null);

} else {
throw ex23465;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (14))){
var state_23409__$1 = state_23409;
var statearr_23474_23540 = state_23409__$1;
(statearr_23474_23540[(2)] = base_select_spec);

(statearr_23474_23540[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (45))){
var inst_23350 = (state_23409[(2)]);
var state_23409__$1 = state_23409;
if(cljs.core.truth_(inst_23350)){
var statearr_23475_23541 = state_23409__$1;
(statearr_23475_23541[(1)] = (46));

} else {
var statearr_23476_23542 = state_23409__$1;
(statearr_23476_23542[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (26))){
var inst_23288 = (state_23409[(12)]);
var inst_23292 = cljs.core.empty_QMARK_.call(null,inst_23288);
var state_23409__$1 = state_23409;
if(inst_23292){
var statearr_23477_23543 = state_23409__$1;
(statearr_23477_23543[(1)] = (28));

} else {
var statearr_23478_23544 = state_23409__$1;
(statearr_23478_23544[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (16))){
var inst_23256 = (state_23409[(17)]);
var state_23409__$1 = state_23409;
var statearr_23479_23545 = state_23409__$1;
(statearr_23479_23545[(2)] = inst_23256);

(statearr_23479_23545[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (38))){
var inst_23288 = (state_23409[(12)]);
var inst_23323 = (state_23409[(2)]);
var inst_23324 = fluree.db.util.async.throw_err.call(null,inst_23323);
var inst_23325 = cljs.core.nth.call(null,inst_23324,(0),null);
var inst_23326 = cljs.core.nth.call(null,inst_23324,(1),null);
var inst_23327 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23328 = cljs.core.rest.call(null,inst_23288);
var inst_23329 = [inst_23325,inst_23328,inst_23326];
var inst_23330 = (new cljs.core.PersistentVector(null,3,(5),inst_23327,inst_23329,null));
var state_23409__$1 = state_23409;
var statearr_23480_23546 = state_23409__$1;
(statearr_23480_23546[(2)] = inst_23330);

(statearr_23480_23546[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (30))){
var inst_23386 = (state_23409[(2)]);
var state_23409__$1 = state_23409;
var statearr_23481_23547 = state_23409__$1;
(statearr_23481_23547[(2)] = inst_23386);

(statearr_23481_23547[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (10))){
var inst_23249 = (state_23409[(2)]);
var inst_23250 = fluree.db.query.fql_resp.has_ns_lookups_QMARK_.call(null,base_select_spec);
var state_23409__$1 = (function (){var statearr_23482 = state_23409;
(statearr_23482[(10)] = inst_23249);

return statearr_23482;
})();
if(cljs.core.truth_(inst_23250)){
var statearr_23483_23548 = state_23409__$1;
(statearr_23483_23548[(1)] = (13));

} else {
var statearr_23484_23549 = state_23409__$1;
(statearr_23484_23549[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (18))){
var inst_23261 = (state_23409[(2)]);
var state_23409__$1 = state_23409;
if(cljs.core.truth_(inst_23261)){
var statearr_23485_23550 = state_23409__$1;
(statearr_23485_23550[(1)] = (19));

} else {
var statearr_23486_23551 = state_23409__$1;
(statearr_23486_23551[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (42))){
var inst_23334 = (state_23409[(16)]);
var inst_23288 = (state_23409[(12)]);
var inst_23290 = (state_23409[(13)]);
var inst_23337 = (state_23409[(2)]);
var inst_23338 = fluree.db.util.async.throw_err.call(null,inst_23337);
var inst_23339 = cljs.core.first.call(null,inst_23338);
var inst_23340 = cljs.core.rest.call(null,inst_23288);
var inst_23341 = [inst_23339,inst_23340,inst_23290];
var inst_23342 = (new cljs.core.PersistentVector(null,3,(5),inst_23334,inst_23341,null));
var state_23409__$1 = state_23409;
var statearr_23487_23552 = state_23409__$1;
(statearr_23487_23552[(2)] = inst_23342);

(statearr_23487_23552[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (37))){
var inst_23375 = (state_23409[(2)]);
var state_23409__$1 = state_23409;
var statearr_23488_23553 = state_23409__$1;
(statearr_23488_23553[(2)] = inst_23375);

(statearr_23488_23553[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (8))){
var inst_23404 = (state_23409[(2)]);
var _ = (function (){var statearr_23489 = state_23409;
(statearr_23489[(4)] = cljs.core.rest.call(null,(state_23409[(4)])));

return statearr_23489;
})();
var state_23409__$1 = state_23409;
var statearr_23490_23554 = state_23409__$1;
(statearr_23490_23554[(2)] = inst_23404);

(statearr_23490_23554[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23410 === (49))){
var inst_23289 = (state_23409[(11)]);
var inst_23288 = (state_23409[(12)]);
var inst_23290 = (state_23409[(13)]);
var inst_23363 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23364 = cljs.core.rest.call(null,inst_23288);
var inst_23365 = [inst_23289,inst_23364,inst_23290];
var inst_23366 = (new cljs.core.PersistentVector(null,3,(5),inst_23363,inst_23365,null));
var state_23409__$1 = state_23409;
var statearr_23491_23555 = state_23409__$1;
(statearr_23491_23555[(2)] = inst_23366);

(statearr_23491_23555[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto____0 = (function (){
var statearr_23492 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23492[(0)] = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto__);

(statearr_23492[(1)] = (1));

return statearr_23492;
});
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto____1 = (function (state_23409){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23409);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23493){var ex__2749__auto__ = e23493;
var statearr_23494_23556 = state_23409;
(statearr_23494_23556[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23409[(4)]))){
var statearr_23495_23557 = state_23409;
(statearr_23495_23557[(1)] = cljs.core.first.call(null,(state_23409[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23558 = state_23409;
state_23409 = G__23558;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto__ = function(state_23409){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto____1.call(this,state_23409);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto____0;
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto____1;
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23496 = f__2769__auto__.call(null);
(statearr_23496[(6)] = c__2768__auto__);

return statearr_23496;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
