// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.subject_crawl.common');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.schema');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.query.fql_resp');
/**
 * Transducing function to extract matching subjects from initial where clause.
 */
fluree.db.query.subject_crawl.common.where_subj_xf = (function fluree$db$query$subject_crawl$common$where_subj_xf(p__23561){
var map__23562 = p__23561;
var map__23562__$1 = cljs.core.__destructure_map.call(null,map__23562);
var start_test = cljs.core.get.call(null,map__23562__$1,new cljs.core.Keyword(null,"start-test","start-test",-952983565));
var start_flake = cljs.core.get.call(null,map__23562__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_test = cljs.core.get.call(null,map__23562__$1,new cljs.core.Keyword(null,"end-test","end-test",481973727));
var end_flake = cljs.core.get.call(null,map__23562__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var xf = cljs.core.get.call(null,map__23562__$1,new cljs.core.Keyword(null,"xf","xf",401902988));
return cljs.core.apply.call(null,cljs.core.comp,(function (){var G__23563 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.map.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739)),cljs.core.map.call(null,(function (flakes){
return fluree.db.flake.subrange.call(null,flakes,start_test,start_flake,end_test,end_flake);
}))], null);
if(cljs.core.truth_(xf)){
return cljs.core.conj.call(null,G__23563,xf);
} else {
return G__23563;
}
})());
});
fluree.db.query.subject_crawl.common.result_af = (function fluree$db$query$subject_crawl$common$result_af(p__23564){
var map__23565 = p__23564;
var map__23565__$1 = cljs.core.__destructure_map.call(null,map__23565);
var _opts = map__23565__$1;
var db = cljs.core.get.call(null,map__23565__$1,new cljs.core.Keyword(null,"db","db",993250759));
var cache = cljs.core.get.call(null,map__23565__$1,new cljs.core.Keyword(null,"cache","cache",-1237023054));
var fuel_vol = cljs.core.get.call(null,map__23565__$1,new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142));
var max_fuel = cljs.core.get.call(null,map__23565__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var select_spec = cljs.core.get.call(null,map__23565__$1,new cljs.core.Keyword(null,"select-spec","select-spec",55073283));
var error_ch = cljs.core.get.call(null,map__23565__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
return (function (flakes,port){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23596){
var state_val_23597 = (state_23596[(1)]);
if((state_val_23597 === (7))){
var state_23596__$1 = state_23596;
var statearr_23598_23624 = state_23596__$1;
(statearr_23598_23624[(2)] = null);

(statearr_23598_23624[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23597 === (1))){
var state_23596__$1 = state_23596;
var statearr_23599_23625 = state_23596__$1;
(statearr_23599_23625[(2)] = null);

(statearr_23599_23625[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23597 === (4))){
var inst_23566 = (state_23596[(2)]);
var inst_23567 = cljs.core.async.put_BANG_.call(null,error_ch,inst_23566);
var inst_23568 = cljs.core.async.close_BANG_.call(null,port);
var state_23596__$1 = (function (){var statearr_23600 = state_23596;
(statearr_23600[(7)] = inst_23567);

(statearr_23600[(8)] = inst_23568);

return statearr_23600;
})();
var statearr_23601_23626 = state_23596__$1;
(statearr_23601_23626[(2)] = null);

(statearr_23601_23626[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23597 === (6))){
var inst_23578 = (state_23596[(9)]);
var inst_23577 = (state_23596[(2)]);
var inst_23578__$1 = fluree.db.util.async.throw_err.call(null,inst_23577);
var inst_23579 = (inst_23578__$1 == null);
var state_23596__$1 = (function (){var statearr_23602 = state_23596;
(statearr_23602[(9)] = inst_23578__$1);

return statearr_23602;
})();
if(cljs.core.truth_(inst_23579)){
var statearr_23603_23627 = state_23596__$1;
(statearr_23603_23627[(1)] = (7));

} else {
var statearr_23604_23628 = state_23596__$1;
(statearr_23604_23628[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23597 === (3))){
var inst_23594 = (state_23596[(2)]);
var state_23596__$1 = state_23596;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23596__$1,inst_23594);
} else {
if((state_val_23597 === (12))){
var inst_23590 = (state_23596[(2)]);
var inst_23591 = cljs.core.async.close_BANG_.call(null,port);
var _ = (function (){var statearr_23605 = state_23596;
(statearr_23605[(4)] = cljs.core.rest.call(null,(state_23596[(4)])));

return statearr_23605;
})();
var state_23596__$1 = (function (){var statearr_23606 = state_23596;
(statearr_23606[(10)] = inst_23590);

return statearr_23606;
})();
var statearr_23607_23629 = state_23596__$1;
(statearr_23607_23629[(2)] = inst_23591);

(statearr_23607_23629[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23597 === (2))){
var _ = (function (){var statearr_23608 = state_23596;
(statearr_23608[(4)] = cljs.core.cons.call(null,(5),(state_23596[(4)])));

return statearr_23608;
})();
var inst_23575 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel_vol,max_fuel,select_spec,flakes);
var state_23596__$1 = state_23596;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23596__$1,(6),inst_23575);
} else {
if((state_val_23597 === (11))){
var inst_23584 = (state_23596[(11)]);
var inst_23588 = cljs.core.async.put_BANG_.call(null,port,inst_23584);
var state_23596__$1 = state_23596;
var statearr_23610_23630 = state_23596__$1;
(statearr_23610_23630[(2)] = inst_23588);

(statearr_23610_23630[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23597 === (9))){
var inst_23584 = (state_23596[(11)]);
var inst_23584__$1 = (state_23596[(2)]);
var inst_23585 = (inst_23584__$1 == null);
var state_23596__$1 = (function (){var statearr_23611 = state_23596;
(statearr_23611[(11)] = inst_23584__$1);

return statearr_23611;
})();
if(cljs.core.truth_(inst_23585)){
var statearr_23612_23631 = state_23596__$1;
(statearr_23612_23631[(1)] = (10));

} else {
var statearr_23613_23632 = state_23596__$1;
(statearr_23613_23632[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23597 === (5))){
var _ = (function (){var statearr_23614 = state_23596;
(statearr_23614[(4)] = cljs.core.rest.call(null,(state_23596[(4)])));

return statearr_23614;
})();
var state_23596__$1 = state_23596;
var ex23609 = (state_23596__$1[(2)]);
var statearr_23615_23633 = state_23596__$1;
(statearr_23615_23633[(5)] = ex23609);


var statearr_23616_23634 = state_23596__$1;
(statearr_23616_23634[(1)] = (4));

(statearr_23616_23634[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23597 === (10))){
var state_23596__$1 = state_23596;
var statearr_23617_23635 = state_23596__$1;
(statearr_23617_23635[(2)] = null);

(statearr_23617_23635[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23597 === (8))){
var inst_23578 = (state_23596[(9)]);
var inst_23582 = cljs.core.not_empty.call(null,inst_23578);
var state_23596__$1 = state_23596;
var statearr_23618_23636 = state_23596__$1;
(statearr_23618_23636[(2)] = inst_23582);

(statearr_23618_23636[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto____0 = (function (){
var statearr_23619 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23619[(0)] = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto__);

(statearr_23619[(1)] = (1));

return statearr_23619;
});
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto____1 = (function (state_23596){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23596);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23620){var ex__2749__auto__ = e23620;
var statearr_23621_23637 = state_23596;
(statearr_23621_23637[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23596[(4)]))){
var statearr_23622_23638 = state_23596;
(statearr_23622_23638[(1)] = cljs.core.first.call(null,(state_23596[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23639 = state_23596;
state_23596 = G__23639;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto__ = function(state_23596){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto____1.call(this,state_23596);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23623 = f__2769__auto__.call(null);
(statearr_23623[(6)] = c__2768__auto__);

return statearr_23623;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
});
/**
 * Returns a specific filtering function which takes all subject flakes and
 *   returns the flakes allowed, or nil if none are allowed.
 */
fluree.db.query.subject_crawl.common.subj_perm_filter_fn = (function fluree$db$query$subject_crawl$common$subj_perm_filter_fn(p__23640){
var map__23641 = p__23640;
var map__23641__$1 = cljs.core.__destructure_map.call(null,map__23641);
var db = map__23641__$1;
var permissions = cljs.core.get.call(null,map__23641__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var pred_permissions_QMARK_ = cljs.core.contains_QMARK_.call(null,permissions,new cljs.core.Keyword(null,"predicate","predicate",-1742501860));
var coll_permissions = new cljs.core.Keyword(null,"collection","collection",-683361892).cljs$core$IFn$_invoke$arity$1(permissions);
var filter_cache = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var default_deny_QMARK_ = ((new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(coll_permissions) === true)?false:true);
var filter_predicates_QMARK_ = (function (cid){
var temp__5806__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,filter_cache),cid);
if((temp__5806__auto__ == null)){
var coll_perm = cljs.core.get.call(null,coll_permissions,cid);
var filter_QMARK_ = ((fluree.db.util.schema.is_schema_cid_QMARK_.call(null,cid))?false:((pred_permissions_QMARK_)?true:(((coll_perm == null))?default_deny_QMARK_:((((cljs.core.contains_QMARK_.call(null,coll_perm,new cljs.core.Keyword(null,"all","all",892129742))) && (cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,coll_perm)))))?false:true
))));
cljs.core.swap_BANG_.call(null,filter_cache,cljs.core.assoc,cid,filter_QMARK_);

return cljs.core.filter;
} else {
var cached = temp__5806__auto__;
return cached;
}
});
return (function (flakes){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23672){
var state_val_23673 = (state_23672[(1)]);
if((state_val_23673 === (7))){
var inst_23648 = (state_23672[(7)]);
var inst_23658 = fluree.db.permissions_validate.allow_flake_QMARK_.call(null,db,inst_23648);
var state_23672__$1 = state_23672;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23672__$1,(10),inst_23658);
} else {
if((state_val_23673 === (1))){
var state_23672__$1 = state_23672;
var statearr_23674_23697 = state_23672__$1;
(statearr_23674_23697[(2)] = null);

(statearr_23674_23697[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23673 === (4))){
var inst_23642 = (state_23672[(2)]);
var state_23672__$1 = state_23672;
var statearr_23675_23698 = state_23672__$1;
(statearr_23675_23698[(2)] = inst_23642);

(statearr_23675_23698[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23673 === (13))){
var inst_23665 = (state_23672[(2)]);
var state_23672__$1 = state_23672;
var statearr_23676_23699 = state_23672__$1;
(statearr_23676_23699[(2)] = inst_23665);

(statearr_23676_23699[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23673 === (6))){
var inst_23653 = fluree.db.permissions_validate.allow_flakes_QMARK_.call(null,db,flakes);
var state_23672__$1 = state_23672;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23672__$1,(9),inst_23653);
} else {
if((state_val_23673 === (3))){
var inst_23670 = (state_23672[(2)]);
var state_23672__$1 = state_23672;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23672__$1,inst_23670);
} else {
if((state_val_23673 === (12))){
var state_23672__$1 = state_23672;
var statearr_23677_23700 = state_23672__$1;
(statearr_23677_23700[(2)] = null);

(statearr_23677_23700[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23673 === (2))){
var inst_23648 = (state_23672[(7)]);
var _ = (function (){var statearr_23678 = state_23672;
(statearr_23678[(4)] = cljs.core.cons.call(null,(5),(state_23672[(4)])));

return statearr_23678;
})();
var inst_23648__$1 = cljs.core.first.call(null,flakes);
var inst_23649 = fluree.db.flake.s.call(null,inst_23648__$1);
var inst_23650 = fluree.db.flake.sid__GT_cid.call(null,inst_23649);
var inst_23651 = filter_predicates_QMARK_.call(null,inst_23650);
var state_23672__$1 = (function (){var statearr_23679 = state_23672;
(statearr_23679[(7)] = inst_23648__$1);

return statearr_23679;
})();
if(cljs.core.truth_(inst_23651)){
var statearr_23680_23701 = state_23672__$1;
(statearr_23680_23701[(1)] = (6));

} else {
var statearr_23681_23702 = state_23672__$1;
(statearr_23681_23702[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23673 === (11))){
var state_23672__$1 = state_23672;
var statearr_23683_23703 = state_23672__$1;
(statearr_23683_23703[(2)] = flakes);

(statearr_23683_23703[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23673 === (9))){
var inst_23655 = (state_23672[(2)]);
var inst_23656 = fluree.db.util.async.throw_err.call(null,inst_23655);
var state_23672__$1 = state_23672;
var statearr_23684_23704 = state_23672__$1;
(statearr_23684_23704[(2)] = inst_23656);

(statearr_23684_23704[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23673 === (5))){
var _ = (function (){var statearr_23685 = state_23672;
(statearr_23685[(4)] = cljs.core.rest.call(null,(state_23672[(4)])));

return statearr_23685;
})();
var state_23672__$1 = state_23672;
var ex23682 = (state_23672__$1[(2)]);
var statearr_23686_23705 = state_23672__$1;
(statearr_23686_23705[(5)] = ex23682);


if((ex23682 instanceof Error)){
var statearr_23687_23706 = state_23672__$1;
(statearr_23687_23706[(1)] = (4));

(statearr_23687_23706[(5)] = null);

} else {
throw ex23682;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23673 === (10))){
var inst_23660 = (state_23672[(2)]);
var inst_23661 = fluree.db.util.async.throw_err.call(null,inst_23660);
var state_23672__$1 = state_23672;
if(cljs.core.truth_(inst_23661)){
var statearr_23688_23707 = state_23672__$1;
(statearr_23688_23707[(1)] = (11));

} else {
var statearr_23689_23708 = state_23672__$1;
(statearr_23689_23708[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23673 === (8))){
var inst_23667 = (state_23672[(2)]);
var _ = (function (){var statearr_23690 = state_23672;
(statearr_23690[(4)] = cljs.core.rest.call(null,(state_23672[(4)])));

return statearr_23690;
})();
var state_23672__$1 = state_23672;
var statearr_23691_23709 = state_23672__$1;
(statearr_23691_23709[(2)] = inst_23667);

(statearr_23691_23709[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto____0 = (function (){
var statearr_23692 = [null,null,null,null,null,null,null,null];
(statearr_23692[(0)] = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto__);

(statearr_23692[(1)] = (1));

return statearr_23692;
});
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto____1 = (function (state_23672){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23672);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23693){var ex__2749__auto__ = e23693;
var statearr_23694_23710 = state_23672;
(statearr_23694_23710[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23672[(4)]))){
var statearr_23695_23711 = state_23672;
(statearr_23695_23711[(1)] = cljs.core.first.call(null,(state_23672[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23712 = state_23672;
state_23672 = G__23712;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto__ = function(state_23672){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto____1.call(this,state_23672);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23696 = f__2769__auto__.call(null);
(statearr_23696[(6)] = c__2768__auto__);

return statearr_23696;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
});
fluree.db.query.subject_crawl.common.passes_filter_QMARK_ = (function fluree$db$query$subject_crawl$common$passes_filter_QMARK_(filter_fn,vars,pred_flakes){
return cljs.core.some.call(null,(function (p1__23713_SHARP_){
return filter_fn.call(null,p1__23713_SHARP_,vars);
}),pred_flakes);
});
/**
 * For a group of predicate flakes (all same .-p value)
 *   and a list of filter-functions, returns true if at least
 *   one of the predicates passes every function, else returns false.
 */
fluree.db.query.subject_crawl.common.pass_all_filters_QMARK_ = (function fluree$db$query$subject_crawl$common$pass_all_filters_QMARK_(filter_fns,vars,pred_flakes){
var G__23717 = filter_fns;
var vec__23718 = G__23717;
var seq__23719 = cljs.core.seq.call(null,vec__23718);
var first__23720 = cljs.core.first.call(null,seq__23719);
var seq__23719__$1 = cljs.core.next.call(null,seq__23719);
var filter_fn = first__23720;
var r_fns = seq__23719__$1;
var G__23717__$1 = G__23717;
while(true){
var vec__23721 = G__23717__$1;
var seq__23722 = cljs.core.seq.call(null,vec__23721);
var first__23723 = cljs.core.first.call(null,seq__23722);
var seq__23722__$1 = cljs.core.next.call(null,seq__23722);
var filter_fn__$1 = first__23723;
var r_fns__$1 = seq__23722__$1;
if(cljs.core.truth_(filter_fn__$1)){
if(cljs.core.truth_(fluree.db.query.subject_crawl.common.passes_filter_QMARK_.call(null,filter_fn__$1,vars,pred_flakes))){
var G__23724 = r_fns__$1;
G__23717__$1 = G__23724;
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
});
/**
 * Filters a set of flakes for a single subject and returns true if
 *   the subject meets the filter map.
 * 
 *   filter-map is a map where pred-ids are keys and values are a list of filtering functions
 *   where each flake of pred-id must return a truthy value if the subject is allowed.
 */
fluree.db.query.subject_crawl.common.filter_subject = (function fluree$db$query$subject_crawl$common$filter_subject(vars,filter_map,flakes){
var G__23728 = cljs.core.partition_by.call(null,fluree.db.flake.p,flakes);
var vec__23729 = G__23728;
var seq__23730 = cljs.core.seq.call(null,vec__23729);
var first__23731 = cljs.core.first.call(null,seq__23730);
var seq__23730__$1 = cljs.core.next.call(null,seq__23730);
var p_flakes = first__23731;
var r = seq__23730__$1;
var required_p = new cljs.core.Keyword(null,"required-p","required-p",-2091946078).cljs$core$IFn$_invoke$arity$1(filter_map);
var G__23728__$1 = G__23728;
var required_p__$1 = required_p;
while(true){
var vec__23735 = G__23728__$1;
var seq__23736 = cljs.core.seq.call(null,vec__23735);
var first__23737 = cljs.core.first.call(null,seq__23736);
var seq__23736__$1 = cljs.core.next.call(null,seq__23736);
var p_flakes__$1 = first__23737;
var r__$1 = seq__23736__$1;
var required_p__$2 = required_p__$1;
if(cljs.core.truth_(p_flakes__$1)){
var p = fluree.db.flake.p.call(null,cljs.core.first.call(null,p_flakes__$1));
var temp__5802__auto__ = cljs.core.get.call(null,filter_map,p);
if(cljs.core.truth_(temp__5802__auto__)){
var filter_fns = temp__5802__auto__;
if(fluree.db.query.subject_crawl.common.pass_all_filters_QMARK_.call(null,filter_fns,vars,p_flakes__$1)){
var G__23738 = r__$1;
var G__23739 = cljs.core.disj.call(null,required_p__$2,p);
G__23728__$1 = G__23738;
required_p__$1 = G__23739;
continue;
} else {
return null;
}
} else {
var G__23740 = r__$1;
var G__23741 = cljs.core.disj.call(null,required_p__$2,p);
G__23728__$1 = G__23740;
required_p__$1 = G__23741;
continue;
}
} else {
if(cljs.core.empty_QMARK_.call(null,required_p__$2)){
return flakes;
} else {
return null;
}
}
break;
}
});
/**
 * If order-by exists in query, orders final results.
 *   order-by is defined by a map with keys (see analytical-parse for code):
 *   - :type - :variable or :predicate
 *   - :order - :asc or :desc
 *   - :predicate - if type = :predicate, contains predicate pid or name
 *   - :variable - if type = :variable, contains variable name (not supported for simple subject crawl)
 */
fluree.db.query.subject_crawl.common.order_results = (function fluree$db$query$subject_crawl$common$order_results(results,p__23742,limit){
var map__23743 = p__23742;
var map__23743__$1 = cljs.core.__destructure_map.call(null,map__23743);
var type = cljs.core.get.call(null,map__23743__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var order = cljs.core.get.call(null,map__23743__$1,new cljs.core.Keyword(null,"order","order",-1254677256));
var predicate = cljs.core.get.call(null,map__23743__$1,new cljs.core.Keyword(null,"predicate","predicate",-1742501860));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"variable","variable",-281346492),type)){
throw cljs.core.ex_info.call(null,"Ordering by a variable not supported in this type of query.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
var sorted = (function (){var G__23744 = cljs.core.sort_by.call(null,(function (result){
return cljs.core.get.call(null,result,predicate);
}),results);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"desc","desc",2093485764),order)){
return cljs.core.reverse.call(null,G__23744);
} else {
return G__23744;
}
})();
return cljs.core.vec.call(null,cljs.core.take.call(null,limit,sorted));
}
});
/**
 * When some variables may be idents (two-tuples) they need to get resolved into
 *   subject _id values before executing query.
 */
fluree.db.query.subject_crawl.common.resolve_ident_vars = (function fluree$db$query$subject_crawl$common$resolve_ident_vars(db,vars,ident_vars){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23814){
var state_val_23815 = (state_23814[(1)]);
if((state_val_23815 === (7))){
var inst_23809 = (state_23814[(2)]);
var _ = (function (){var statearr_23816 = state_23814;
(statearr_23816[(4)] = cljs.core.rest.call(null,(state_23814[(4)])));

return statearr_23816;
})();
var state_23814__$1 = state_23814;
var statearr_23817_23859 = state_23814__$1;
(statearr_23817_23859[(2)] = inst_23809);

(statearr_23817_23859[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23815 === (20))){
var inst_23771 = (state_23814[(7)]);
var inst_23770 = (state_23814[(8)]);
var inst_23764 = (state_23814[(9)]);
var inst_23787 = (state_23814[(2)]);
var inst_23788 = cljs.core.assoc.call(null,inst_23764,inst_23770,inst_23787);
var inst_23763 = inst_23771;
var inst_23764__$1 = inst_23788;
var state_23814__$1 = (function (){var statearr_23818 = state_23814;
(statearr_23818[(10)] = inst_23763);

(statearr_23818[(9)] = inst_23764__$1);

return statearr_23818;
})();
var statearr_23819_23860 = state_23814__$1;
(statearr_23819_23860[(2)] = null);

(statearr_23819_23860[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23815 === (1))){
var state_23814__$1 = state_23814;
var statearr_23820_23861 = state_23814__$1;
(statearr_23820_23861[(2)] = null);

(statearr_23820_23861[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23815 === (4))){
var inst_23745 = (state_23814[(2)]);
var state_23814__$1 = state_23814;
var statearr_23821_23862 = state_23814__$1;
(statearr_23821_23862[(2)] = inst_23745);

(statearr_23821_23862[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23815 === (15))){
var state_23814__$1 = state_23814;
var statearr_23822_23863 = state_23814__$1;
(statearr_23822_23863[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23815 === (21))){
var inst_23773 = (state_23814[(11)]);
var inst_23770 = (state_23814[(8)]);
var inst_23792 = ["Invalid identity provided in variable: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_23770),". Must be a two-tuple identity, IRI, or integer id. ","Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_23773)].join('');
var inst_23793 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_23794 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_23795 = cljs.core.PersistentHashMap.fromArrays(inst_23793,inst_23794);
var inst_23796 = cljs.core.ex_info.call(null,inst_23792,inst_23795);
var inst_23797 = (function(){throw inst_23796})();
var state_23814__$1 = state_23814;
var statearr_23824_23864 = state_23814__$1;
(statearr_23824_23864[(2)] = inst_23797);

(statearr_23824_23864[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23815 === (13))){
var inst_23804 = (state_23814[(2)]);
var state_23814__$1 = state_23814;
var statearr_23825_23865 = state_23814__$1;
(statearr_23825_23865[(2)] = inst_23804);

(statearr_23825_23865[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23815 === (22))){
var state_23814__$1 = state_23814;
var statearr_23826_23866 = state_23814__$1;
(statearr_23826_23866[(2)] = null);

(statearr_23826_23866[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23815 === (6))){
var inst_23763 = (state_23814[(10)]);
var inst_23770 = (state_23814[(8)]);
var inst_23769 = cljs.core.seq.call(null,inst_23763);
var inst_23770__$1 = cljs.core.first.call(null,inst_23769);
var inst_23771 = cljs.core.next.call(null,inst_23769);
var state_23814__$1 = (function (){var statearr_23827 = state_23814;
(statearr_23827[(7)] = inst_23771);

(statearr_23827[(8)] = inst_23770__$1);

return statearr_23827;
})();
if(cljs.core.truth_(inst_23770__$1)){
var statearr_23828_23867 = state_23814__$1;
(statearr_23828_23867[(1)] = (8));

} else {
var statearr_23829_23868 = state_23814__$1;
(statearr_23829_23868[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23815 === (17))){
var inst_23783 = (state_23814[(12)]);
var inst_23782 = (state_23814[(2)]);
var inst_23783__$1 = fluree.db.util.async.throw_err.call(null,inst_23782);
var state_23814__$1 = (function (){var statearr_23830 = state_23814;
(statearr_23830[(12)] = inst_23783__$1);

return statearr_23830;
})();
if(cljs.core.truth_(inst_23783__$1)){
var statearr_23831_23869 = state_23814__$1;
(statearr_23831_23869[(1)] = (18));

} else {
var statearr_23832_23870 = state_23814__$1;
(statearr_23832_23870[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23815 === (3))){
var inst_23812 = (state_23814[(2)]);
var state_23814__$1 = state_23814;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23814__$1,inst_23812);
} else {
if((state_val_23815 === (12))){
var inst_23773 = (state_23814[(11)]);
var inst_23778 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_23773);
var state_23814__$1 = state_23814;
if(inst_23778){
var statearr_23833_23871 = state_23814__$1;
(statearr_23833_23871[(1)] = (14));

} else {
var statearr_23834_23872 = state_23814__$1;
(statearr_23834_23872[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23815 === (2))){
var _ = (function (){var statearr_23835 = state_23814;
(statearr_23835[(4)] = cljs.core.cons.call(null,(5),(state_23814[(4)])));

return statearr_23835;
})();
var inst_23758 = ident_vars;
var inst_23759 = cljs.core.seq.call(null,inst_23758);
var inst_23760 = cljs.core.first.call(null,inst_23759);
var inst_23761 = cljs.core.next.call(null,inst_23759);
var inst_23762 = vars;
var inst_23763 = inst_23758;
var inst_23764 = inst_23762;
var state_23814__$1 = (function (){var statearr_23836 = state_23814;
(statearr_23836[(13)] = inst_23761);

(statearr_23836[(10)] = inst_23763);

(statearr_23836[(9)] = inst_23764);

(statearr_23836[(14)] = inst_23760);

return statearr_23836;
})();
var statearr_23837_23873 = state_23814__$1;
(statearr_23837_23873[(2)] = null);

(statearr_23837_23873[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23815 === (23))){
var inst_23800 = (state_23814[(2)]);
var state_23814__$1 = state_23814;
var statearr_23839_23874 = state_23814__$1;
(statearr_23839_23874[(2)] = inst_23800);

(statearr_23839_23874[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23815 === (19))){
var state_23814__$1 = state_23814;
var statearr_23840_23875 = state_23814__$1;
(statearr_23840_23875[(2)] = (0));

(statearr_23840_23875[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23815 === (11))){
var inst_23771 = (state_23814[(7)]);
var inst_23764 = (state_23814[(9)]);
var tmp23838 = inst_23764;
var inst_23763 = inst_23771;
var inst_23764__$1 = tmp23838;
var state_23814__$1 = (function (){var statearr_23842 = state_23814;
(statearr_23842[(10)] = inst_23763);

(statearr_23842[(9)] = inst_23764__$1);

return statearr_23842;
})();
var statearr_23843_23876 = state_23814__$1;
(statearr_23843_23876[(2)] = null);

(statearr_23843_23876[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23815 === (9))){
var inst_23764 = (state_23814[(9)]);
var state_23814__$1 = state_23814;
var statearr_23844_23877 = state_23814__$1;
(statearr_23844_23877[(2)] = inst_23764);

(statearr_23844_23877[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23815 === (5))){
var _ = (function (){var statearr_23845 = state_23814;
(statearr_23845[(4)] = cljs.core.rest.call(null,(state_23814[(4)])));

return statearr_23845;
})();
var state_23814__$1 = state_23814;
var ex23841 = (state_23814__$1[(2)]);
var statearr_23846_23878 = state_23814__$1;
(statearr_23846_23878[(5)] = ex23841);


if((ex23841 instanceof Error)){
var statearr_23847_23879 = state_23814__$1;
(statearr_23847_23879[(1)] = (4));

(statearr_23847_23879[(5)] = null);

} else {
throw ex23841;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23815 === (14))){
var inst_23773 = (state_23814[(11)]);
var inst_23780 = fluree.db.dbproto._subid.call(null,db,inst_23773);
var state_23814__$1 = state_23814;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23814__$1,(17),inst_23780);
} else {
if((state_val_23815 === (16))){
var inst_23802 = (state_23814[(2)]);
var state_23814__$1 = state_23814;
var statearr_23848_23880 = state_23814__$1;
(statearr_23848_23880[(2)] = inst_23802);

(statearr_23848_23880[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23815 === (10))){
var inst_23807 = (state_23814[(2)]);
var state_23814__$1 = state_23814;
var statearr_23849_23881 = state_23814__$1;
(statearr_23849_23881[(2)] = inst_23807);

(statearr_23849_23881[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23815 === (18))){
var inst_23783 = (state_23814[(12)]);
var state_23814__$1 = state_23814;
var statearr_23850_23882 = state_23814__$1;
(statearr_23850_23882[(2)] = inst_23783);

(statearr_23850_23882[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23815 === (8))){
var inst_23773 = (state_23814[(11)]);
var inst_23770 = (state_23814[(8)]);
var inst_23773__$1 = cljs.core.get.call(null,vars,inst_23770);
var inst_23774 = cljs.core.int_QMARK_.call(null,inst_23773__$1);
var state_23814__$1 = (function (){var statearr_23851 = state_23814;
(statearr_23851[(11)] = inst_23773__$1);

return statearr_23851;
})();
if(inst_23774){
var statearr_23852_23883 = state_23814__$1;
(statearr_23852_23883[(1)] = (11));

} else {
var statearr_23853_23884 = state_23814__$1;
(statearr_23853_23884[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2746__auto____0 = (function (){
var statearr_23854 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23854[(0)] = fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2746__auto__);

(statearr_23854[(1)] = (1));

return statearr_23854;
});
var fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2746__auto____1 = (function (state_23814){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23814);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23855){var ex__2749__auto__ = e23855;
var statearr_23856_23885 = state_23814;
(statearr_23856_23885[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23814[(4)]))){
var statearr_23857_23886 = state_23814;
(statearr_23857_23886[(1)] = cljs.core.first.call(null,(state_23814[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23887 = state_23814;
state_23814 = G__23887;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2746__auto__ = function(state_23814){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2746__auto____1.call(this,state_23814);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23858 = f__2769__auto__.call(null);
(statearr_23858[(6)] = c__2768__auto__);

return statearr_23858;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
