// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.subject_crawl.subject');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('fluree.db.index');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.subject_crawl.common');
goog.require('fluree.db.dbproto');
/**
 * Returns chan of subjects in chunks per index-leaf
 *   that can be pulled as needed based on the selection criteria of a where clause.
 */
fluree.db.query.subject_crawl.subject.subjects_chan = (function fluree$db$query$subject_crawl$subject$subjects_chan(p__23892,error_ch,vars,p__23893){
var map__23894 = p__23892;
var map__23894__$1 = cljs.core.__destructure_map.call(null,map__23894);
var db = map__23894__$1;
var conn = cljs.core.get.call(null,map__23894__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var novelty = cljs.core.get.call(null,map__23894__$1,new cljs.core.Keyword(null,"novelty","novelty",-1590246024));
var t = cljs.core.get.call(null,map__23894__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__23895 = p__23893;
var map__23895__$1 = cljs.core.__destructure_map.call(null,map__23895);
var _where_clause = map__23895__$1;
var p = cljs.core.get.call(null,map__23895__$1,new cljs.core.Keyword(null,"p","p",151049309));
var o = cljs.core.get.call(null,map__23895__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var idx = cljs.core.get.call(null,map__23895__$1,new cljs.core.Keyword(null,"idx","idx",1053688473));
var o_STAR_ = (function (){var temp__5806__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(o);
if((temp__5806__auto__ == null)){
var temp__5804__auto__ = new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o);
if(cljs.core.truth_(temp__5804__auto__)){
var variable = temp__5804__auto__;
return cljs.core.get.call(null,vars,variable);
} else {
return null;
}
} else {
var v = temp__5806__auto__;
return v;
}
})();
var vec__23896 = (function (){var G__23899 = idx;
var G__23899__$1 = (((G__23899 instanceof cljs.core.Keyword))?G__23899.fqn:null);
switch (G__23899__$1) {
case "post":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.__GT_Flake.call(null,null,p,o_STAR_,null,null,(-2147483647)),fluree.db.flake.__GT_Flake.call(null,null,p,o_STAR_,null,null,(2147483647))], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.__GT_Flake.call(null,null,p,null,null,null,(-2147483647)),fluree.db.flake.__GT_Flake.call(null,null,p,null,null,null,(2147483647))], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__23899__$1)].join('')));

}
})();
var fflake = cljs.core.nth.call(null,vec__23896,(0),null);
var lflake = cljs.core.nth.call(null,vec__23896,(1),null);
var filter_fn = (cljs.core.truth_((function (){var and__5043__auto__ = o_STAR_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"psot","psot",2111653059),idx);
} else {
return and__5043__auto__;
}
})())?(function (p1__23890_SHARP_){
return cljs.core._EQ_.call(null,o_STAR_,fluree.db.flake.o.call(null,p1__23890_SHARP_));
}):(cljs.core.truth_(new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(o))?(function (){var f = cljs.core.get_in.call(null,o,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"filter","filter",-948537934),new cljs.core.Keyword(null,"function","function",-2127255473)], null));
return (function (p1__23891_SHARP_){
return f.call(null,fluree.db.flake.o.call(null,p1__23891_SHARP_));
});
})():null));
var idx_root = cljs.core.get.call(null,db,idx);
var cmp = new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(idx_root);
var range_set = fluree.db.flake.sorted_set_by.call(null,cmp,fflake,lflake);
var in_range_QMARK_ = (function (node){
return fluree.db.query.range.intersects_range_QMARK_.call(null,node,range_set);
});
var query_xf = fluree.db.query.subject_crawl.common.where_subj_xf.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"start-test","start-test",-952983565),cljs.core._GT__EQ_,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),fflake,new cljs.core.Keyword(null,"end-test","end-test",481973727),cljs.core._LT__EQ_,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),lflake,new cljs.core.Keyword(null,"xf","xf",401902988),(cljs.core.truth_(filter_fn)?cljs.core.map.call(null,(function (flakes){
return cljs.core.filter.call(null,filter_fn,flakes);
})):null)], null));
var resolver = fluree.db.index.__GT_CachedTRangeResolver.call(null,conn,cljs.core.get.call(null,novelty,idx),t,t,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(conn));
var tree_chan = fluree.db.index.tree_chan.call(null,resolver,idx_root,in_range_QMARK_,fluree.db.query.range.resolved_leaf_QMARK_,(1),query_xf,error_ch);
var return_chan = cljs.core.async.chan.call(null,(10),cljs.core.comp.call(null,cljs.core.map.call(null,fluree.db.flake.s),cljs.core.dedupe.call(null)));
var c__2768__auto___23969 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23938){
var state_val_23939 = (state_23938[(1)]);
if((state_val_23939 === (7))){
var inst_23934 = (state_23938[(2)]);
var state_23938__$1 = state_23938;
var statearr_23940_23970 = state_23938__$1;
(statearr_23940_23970[(2)] = inst_23934);

(statearr_23940_23970[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23939 === (1))){
var state_23938__$1 = state_23938;
var statearr_23941_23971 = state_23938__$1;
(statearr_23941_23971[(2)] = null);

(statearr_23941_23971[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23939 === (4))){
var inst_23902 = (state_23938[(7)]);
var inst_23902__$1 = (state_23938[(2)]);
var inst_23903 = (inst_23902__$1 == null);
var state_23938__$1 = (function (){var statearr_23942 = state_23938;
(statearr_23942[(7)] = inst_23902__$1);

return statearr_23942;
})();
if(cljs.core.truth_(inst_23903)){
var statearr_23943_23972 = state_23938__$1;
(statearr_23943_23972[(1)] = (5));

} else {
var statearr_23944_23973 = state_23938__$1;
(statearr_23944_23973[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23939 === (15))){
var state_23938__$1 = state_23938;
var statearr_23945_23974 = state_23938__$1;
(statearr_23945_23974[(2)] = false);

(statearr_23945_23974[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23939 === (13))){
var inst_23914 = (state_23938[(2)]);
var state_23938__$1 = state_23938;
if(cljs.core.truth_(inst_23914)){
var statearr_23946_23975 = state_23938__$1;
(statearr_23946_23975[(1)] = (14));

} else {
var statearr_23947_23976 = state_23938__$1;
(statearr_23947_23976[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23939 === (6))){
var inst_23902 = (state_23938[(7)]);
var inst_23907 = cljs.core.seq.call(null,inst_23902);
var inst_23908 = inst_23907;
var inst_23909 = (0);
var state_23938__$1 = (function (){var statearr_23948 = state_23938;
(statearr_23948[(8)] = inst_23909);

(statearr_23948[(9)] = inst_23908);

return statearr_23948;
})();
var statearr_23949_23977 = state_23938__$1;
(statearr_23949_23977[(2)] = null);

(statearr_23949_23977[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23939 === (17))){
var state_23938__$1 = state_23938;
var statearr_23950_23978 = state_23938__$1;
(statearr_23950_23978[(2)] = null);

(statearr_23950_23978[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23939 === (3))){
var inst_23936 = (state_23938[(2)]);
var state_23938__$1 = state_23938;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23938__$1,inst_23936);
} else {
if((state_val_23939 === (12))){
var inst_23924 = (state_23938[(2)]);
var state_23938__$1 = state_23938;
var statearr_23951_23979 = state_23938__$1;
(statearr_23951_23979[(2)] = inst_23924);

(statearr_23951_23979[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23939 === (2))){
var state_23938__$1 = state_23938;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23938__$1,(4),tree_chan);
} else {
if((state_val_23939 === (19))){
var inst_23932 = (state_23938[(2)]);
var state_23938__$1 = state_23938;
var statearr_23952_23980 = state_23938__$1;
(statearr_23952_23980[(2)] = inst_23932);

(statearr_23952_23980[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23939 === (11))){
var state_23938__$1 = state_23938;
var statearr_23953_23981 = state_23938__$1;
(statearr_23953_23981[(2)] = true);

(statearr_23953_23981[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23939 === (9))){
var inst_23926 = (state_23938[(2)]);
var state_23938__$1 = state_23938;
if(cljs.core.truth_(inst_23926)){
var statearr_23954_23982 = state_23938__$1;
(statearr_23954_23982[(1)] = (17));

} else {
var statearr_23955_23983 = state_23938__$1;
(statearr_23955_23983[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23939 === (5))){
var inst_23905 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_23938__$1 = state_23938;
var statearr_23956_23984 = state_23938__$1;
(statearr_23956_23984[(2)] = inst_23905);

(statearr_23956_23984[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23939 === (14))){
var inst_23909 = (state_23938[(8)]);
var inst_23908 = (state_23938[(9)]);
var inst_23916 = cljs.core.next.call(null,inst_23908);
var inst_23917 = (inst_23909 + (1));
var inst_23908__$1 = inst_23916;
var inst_23909__$1 = inst_23917;
var state_23938__$1 = (function (){var statearr_23957 = state_23938;
(statearr_23957[(8)] = inst_23909__$1);

(statearr_23957[(9)] = inst_23908__$1);

return statearr_23957;
})();
var statearr_23958_23985 = state_23938__$1;
(statearr_23958_23985[(2)] = null);

(statearr_23958_23985[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23939 === (16))){
var inst_23921 = (state_23938[(2)]);
var state_23938__$1 = state_23938;
var statearr_23959_23986 = state_23938__$1;
(statearr_23959_23986[(2)] = inst_23921);

(statearr_23959_23986[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23939 === (10))){
var inst_23908 = (state_23938[(9)]);
var inst_23912 = cljs.core.first.call(null,inst_23908);
var state_23938__$1 = state_23938;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23938__$1,(13),return_chan,inst_23912);
} else {
if((state_val_23939 === (18))){
var inst_23930 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_23938__$1 = state_23938;
var statearr_23960_23987 = state_23938__$1;
(statearr_23960_23987[(2)] = inst_23930);

(statearr_23960_23987[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23939 === (8))){
var inst_23908 = (state_23938[(9)]);
var state_23938__$1 = state_23938;
if(cljs.core.truth_(inst_23908)){
var statearr_23961_23988 = state_23938__$1;
(statearr_23961_23988[(1)] = (10));

} else {
var statearr_23962_23989 = state_23938__$1;
(statearr_23962_23989[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto____0 = (function (){
var statearr_23963 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23963[(0)] = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto__);

(statearr_23963[(1)] = (1));

return statearr_23963;
});
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto____1 = (function (state_23938){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23938);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23964){var ex__2749__auto__ = e23964;
var statearr_23965_23990 = state_23938;
(statearr_23965_23990[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23938[(4)]))){
var statearr_23966_23991 = state_23938;
(statearr_23966_23991[(1)] = cljs.core.first.call(null,(state_23938[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23992 = state_23938;
state_23938 = G__23992;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto__ = function(state_23938){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto____1.call(this,state_23938);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23967 = f__2769__auto__.call(null);
(statearr_23967[(6)] = c__2768__auto___23969);

return statearr_23967;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return return_chan;
});
fluree.db.query.subject_crawl.subject.flakes_xf = (function fluree$db$query$subject_crawl$subject$flakes_xf(p__23993){
var map__23994 = p__23993;
var map__23994__$1 = cljs.core.__destructure_map.call(null,map__23994);
var _opts = map__23994__$1;
var db = cljs.core.get.call(null,map__23994__$1,new cljs.core.Keyword(null,"db","db",993250759));
var fuel_vol = cljs.core.get.call(null,map__23994__$1,new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142));
var max_fuel = cljs.core.get.call(null,map__23994__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var error_ch = cljs.core.get.call(null,map__23994__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
var vars = cljs.core.get.call(null,map__23994__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var filter_map = cljs.core.get.call(null,map__23994__$1,new cljs.core.Keyword(null,"filter-map","filter-map",-314788257));
var permissioned_QMARK_ = cljs.core.get.call(null,map__23994__$1,new cljs.core.Keyword(null,"permissioned?","permissioned?",-560602803));
var permissions = (cljs.core.truth_(permissioned_QMARK_)?fluree.db.query.subject_crawl.common.subj_perm_filter_fn.call(null,db):null);
return (function (sid,port){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24039){
var state_val_24040 = (state_24039[(1)]);
if((state_val_24040 === (7))){
var inst_24010 = (state_24039[(7)]);
var inst_24012 = fluree.db.query.subject_crawl.common.filter_subject.call(null,vars,filter_map,inst_24010);
var state_24039__$1 = state_24039;
var statearr_24041_24077 = state_24039__$1;
(statearr_24041_24077[(2)] = inst_24012);

(statearr_24041_24077[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24040 === (1))){
var state_24039__$1 = state_24039;
var statearr_24042_24078 = state_24039__$1;
(statearr_24042_24078[(2)] = null);

(statearr_24042_24078[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24040 === (4))){
var inst_23995 = (state_24039[(2)]);
var inst_23996 = cljs.core.async.put_BANG_.call(null,error_ch,inst_23995);
var inst_23997 = cljs.core.async.close_BANG_.call(null,port);
var state_24039__$1 = (function (){var statearr_24043 = state_24039;
(statearr_24043[(8)] = inst_23997);

(statearr_24043[(9)] = inst_23996);

return statearr_24043;
})();
var statearr_24044_24079 = state_24039__$1;
(statearr_24044_24079[(2)] = null);

(statearr_24044_24079[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24040 === (15))){
var inst_24027 = (state_24039[(10)]);
var inst_24027__$1 = (state_24039[(2)]);
var inst_24028 = cljs.core.seq.call(null,inst_24027__$1);
var state_24039__$1 = (function (){var statearr_24045 = state_24039;
(statearr_24045[(10)] = inst_24027__$1);

return statearr_24045;
})();
if(inst_24028){
var statearr_24046_24080 = state_24039__$1;
(statearr_24046_24080[(1)] = (17));

} else {
var statearr_24047_24081 = state_24039__$1;
(statearr_24047_24081[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24040 === (13))){
var inst_24020 = (state_24039[(11)]);
var state_24039__$1 = state_24039;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24039__$1,(16),inst_24020);
} else {
if((state_val_24040 === (6))){
var inst_24009 = (state_24039[(2)]);
var inst_24010 = fluree.db.util.async.throw_err.call(null,inst_24009);
var state_24039__$1 = (function (){var statearr_24048 = state_24039;
(statearr_24048[(7)] = inst_24010);

return statearr_24048;
})();
if(cljs.core.truth_(filter_map)){
var statearr_24049_24082 = state_24039__$1;
(statearr_24049_24082[(1)] = (7));

} else {
var statearr_24050_24083 = state_24039__$1;
(statearr_24050_24083[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24040 === (17))){
var inst_24027 = (state_24039[(10)]);
var inst_24030 = cljs.core.async.put_BANG_.call(null,port,inst_24027);
var state_24039__$1 = state_24039;
var statearr_24051_24084 = state_24039__$1;
(statearr_24051_24084[(2)] = inst_24030);

(statearr_24051_24084[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24040 === (3))){
var inst_24037 = (state_24039[(2)]);
var state_24039__$1 = state_24039;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24039__$1,inst_24037);
} else {
if((state_val_24040 === (12))){
var inst_24020 = (state_24039[(2)]);
var state_24039__$1 = (function (){var statearr_24052 = state_24039;
(statearr_24052[(11)] = inst_24020);

return statearr_24052;
})();
if(cljs.core.truth_(permissioned_QMARK_)){
var statearr_24053_24085 = state_24039__$1;
(statearr_24053_24085[(1)] = (13));

} else {
var statearr_24054_24086 = state_24039__$1;
(statearr_24054_24086[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24040 === (2))){
var _ = (function (){var statearr_24055 = state_24039;
(statearr_24055[(4)] = cljs.core.cons.call(null,(5),(state_24039[(4)])));

return statearr_24055;
})();
var inst_24004 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24005 = [sid];
var inst_24006 = (new cljs.core.PersistentVector(null,1,(5),inst_24004,inst_24005,null));
var inst_24007 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_24006);
var state_24039__$1 = state_24039;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24039__$1,(6),inst_24007);
} else {
if((state_val_24040 === (19))){
var inst_24033 = (state_24039[(2)]);
var inst_24034 = cljs.core.async.close_BANG_.call(null,port);
var _ = (function (){var statearr_24056 = state_24039;
(statearr_24056[(4)] = cljs.core.rest.call(null,(state_24039[(4)])));

return statearr_24056;
})();
var state_24039__$1 = (function (){var statearr_24057 = state_24039;
(statearr_24057[(12)] = inst_24033);

return statearr_24057;
})();
var statearr_24058_24087 = state_24039__$1;
(statearr_24058_24087[(2)] = inst_24034);

(statearr_24058_24087[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24040 === (11))){
var inst_24015 = (state_24039[(13)]);
var state_24039__$1 = state_24039;
var statearr_24060_24088 = state_24039__$1;
(statearr_24060_24088[(2)] = inst_24015);

(statearr_24060_24088[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24040 === (9))){
var inst_24015 = (state_24039[(2)]);
var state_24039__$1 = (function (){var statearr_24061 = state_24039;
(statearr_24061[(13)] = inst_24015);

return statearr_24061;
})();
if(cljs.core.truth_(permissioned_QMARK_)){
var statearr_24062_24089 = state_24039__$1;
(statearr_24062_24089[(1)] = (10));

} else {
var statearr_24063_24090 = state_24039__$1;
(statearr_24063_24090[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24040 === (5))){
var _ = (function (){var statearr_24064 = state_24039;
(statearr_24064[(4)] = cljs.core.rest.call(null,(state_24039[(4)])));

return statearr_24064;
})();
var state_24039__$1 = state_24039;
var ex24059 = (state_24039__$1[(2)]);
var statearr_24065_24091 = state_24039__$1;
(statearr_24065_24091[(5)] = ex24059);


var statearr_24066_24092 = state_24039__$1;
(statearr_24066_24092[(1)] = (4));

(statearr_24066_24092[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24040 === (14))){
var inst_24020 = (state_24039[(11)]);
var state_24039__$1 = state_24039;
var statearr_24067_24093 = state_24039__$1;
(statearr_24067_24093[(2)] = inst_24020);

(statearr_24067_24093[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24040 === (16))){
var inst_24023 = (state_24039[(2)]);
var inst_24024 = fluree.db.util.async.throw_err.call(null,inst_24023);
var state_24039__$1 = state_24039;
var statearr_24068_24094 = state_24039__$1;
(statearr_24068_24094[(2)] = inst_24024);

(statearr_24068_24094[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24040 === (10))){
var inst_24015 = (state_24039[(13)]);
var inst_24017 = permissions.call(null,inst_24015);
var state_24039__$1 = state_24039;
var statearr_24069_24095 = state_24039__$1;
(statearr_24069_24095[(2)] = inst_24017);

(statearr_24069_24095[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24040 === (18))){
var state_24039__$1 = state_24039;
var statearr_24070_24096 = state_24039__$1;
(statearr_24070_24096[(2)] = null);

(statearr_24070_24096[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24040 === (8))){
var inst_24010 = (state_24039[(7)]);
var state_24039__$1 = state_24039;
var statearr_24071_24097 = state_24039__$1;
(statearr_24071_24097[(2)] = inst_24010);

(statearr_24071_24097[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto____0 = (function (){
var statearr_24072 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24072[(0)] = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto__);

(statearr_24072[(1)] = (1));

return statearr_24072;
});
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto____1 = (function (state_24039){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24039);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24073){var ex__2749__auto__ = e24073;
var statearr_24074_24098 = state_24039;
(statearr_24074_24098[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24039[(4)]))){
var statearr_24075_24099 = state_24039;
(statearr_24075_24099[(1)] = cljs.core.first.call(null,(state_24039[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24100 = state_24039;
state_24039 = G__24100;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto__ = function(state_24039){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto____1.call(this,state_24039);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24076 = f__2769__auto__.call(null);
(statearr_24076[(6)] = c__2768__auto__);

return statearr_24076;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
});
/**
 * For queries that specify _id as the predicate, we will have a
 *   single subject as a value.
 */
fluree.db.query.subject_crawl.subject.subjects_id_chan = (function fluree$db$query$subject_crawl$subject$subjects_id_chan(db,error_ch,vars,p__24101){
var map__24102 = p__24101;
var map__24102__$1 = cljs.core.__destructure_map.call(null,map__24102);
var f_where = map__24102__$1;
var o = cljs.core.get.call(null,map__24102__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var return_ch = cljs.core.async.chan.call(null);
var _id_val = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(o);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.call(null,vars,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o));
}
})();
if(cljs.core.truth_(_id_val)){
} else {
throw cljs.core.ex_info.call(null,["When using _id as the predicate, a value must be provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(f_where)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var c__2768__auto___24139 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24122){
var state_val_24123 = (state_24122[(1)]);
if((state_val_24123 === (7))){
var inst_24110 = (state_24122[(7)]);
var inst_24113 = cljs.core.async.put_BANG_.call(null,error_ch,inst_24110);
var state_24122__$1 = state_24122;
var statearr_24124_24140 = state_24122__$1;
(statearr_24124_24140[(2)] = inst_24113);

(statearr_24124_24140[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24123 === (1))){
var inst_24103 = typeof _id_val === 'number';
var state_24122__$1 = state_24122;
if(cljs.core.truth_(inst_24103)){
var statearr_24125_24141 = state_24122__$1;
(statearr_24125_24141[(1)] = (2));

} else {
var statearr_24126_24142 = state_24122__$1;
(statearr_24126_24142[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24123 === (4))){
var inst_24119 = (state_24122[(2)]);
var inst_24120 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_24122__$1 = (function (){var statearr_24127 = state_24122;
(statearr_24127[(8)] = inst_24119);

return statearr_24127;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24122__$1,inst_24120);
} else {
if((state_val_24123 === (6))){
var inst_24110 = (state_24122[(7)]);
var inst_24110__$1 = (state_24122[(2)]);
var inst_24111 = fluree.db.util.core.exception_QMARK_.call(null,inst_24110__$1);
var state_24122__$1 = (function (){var statearr_24128 = state_24122;
(statearr_24128[(7)] = inst_24110__$1);

return statearr_24128;
})();
if(inst_24111){
var statearr_24129_24143 = state_24122__$1;
(statearr_24129_24143[(1)] = (7));

} else {
var statearr_24130_24144 = state_24122__$1;
(statearr_24130_24144[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24123 === (3))){
var inst_24108 = fluree.db.dbproto._subid.call(null,db,_id_val);
var state_24122__$1 = state_24122;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24122__$1,(6),inst_24108);
} else {
if((state_val_24123 === (2))){
var state_24122__$1 = state_24122;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24122__$1,(5),return_ch,_id_val);
} else {
if((state_val_24123 === (9))){
var inst_24117 = (state_24122[(2)]);
var state_24122__$1 = state_24122;
var statearr_24131_24145 = state_24122__$1;
(statearr_24131_24145[(2)] = inst_24117);

(statearr_24131_24145[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24123 === (5))){
var inst_24106 = (state_24122[(2)]);
var state_24122__$1 = state_24122;
var statearr_24132_24146 = state_24122__$1;
(statearr_24132_24146[(2)] = inst_24106);

(statearr_24132_24146[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24123 === (8))){
var inst_24110 = (state_24122[(7)]);
var inst_24115 = cljs.core.async.put_BANG_.call(null,return_ch,inst_24110);
var state_24122__$1 = state_24122;
var statearr_24133_24147 = state_24122__$1;
(statearr_24133_24147[(2)] = inst_24115);

(statearr_24133_24147[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto____0 = (function (){
var statearr_24134 = [null,null,null,null,null,null,null,null,null];
(statearr_24134[(0)] = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto__);

(statearr_24134[(1)] = (1));

return statearr_24134;
});
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto____1 = (function (state_24122){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24122);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24135){var ex__2749__auto__ = e24135;
var statearr_24136_24148 = state_24122;
(statearr_24136_24148[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24122[(4)]))){
var statearr_24137_24149 = state_24122;
(statearr_24137_24149[(1)] = cljs.core.first.call(null,(state_24122[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24150 = state_24122;
state_24122 = G__24150;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto__ = function(state_24122){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto____1.call(this,state_24122);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24138 = f__2769__auto__.call(null);
(statearr_24138[(6)] = c__2768__auto___24139);

return statearr_24138;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return return_ch;
});
/**
 * If the predicate is a ref? type with an 'o' value, it must be resolved into a subject id.
 */
fluree.db.query.subject_crawl.subject.resolve_o_ident = (function fluree$db$query$subject_crawl$subject$resolve_o_ident(db,p__24151){
var map__24152 = p__24151;
var map__24152__$1 = cljs.core.__destructure_map.call(null,map__24152);
var where_clause = map__24152__$1;
var o = cljs.core.get.call(null,map__24152__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24176){
var state_val_24177 = (state_24176[(1)]);
if((state_val_24177 === (7))){
var inst_24163 = (state_24176[(7)]);
var state_24176__$1 = state_24176;
var statearr_24178_24197 = state_24176__$1;
(statearr_24178_24197[(2)] = inst_24163);

(statearr_24178_24197[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24177 === (1))){
var state_24176__$1 = state_24176;
var statearr_24179_24198 = state_24176__$1;
(statearr_24179_24198[(2)] = null);

(statearr_24179_24198[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24177 === (4))){
var inst_24153 = (state_24176[(2)]);
var state_24176__$1 = state_24176;
var statearr_24180_24199 = state_24176__$1;
(statearr_24180_24199[(2)] = inst_24153);

(statearr_24180_24199[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24177 === (6))){
var inst_24163 = (state_24176[(7)]);
var inst_24162 = (state_24176[(2)]);
var inst_24163__$1 = fluree.db.util.async.throw_err.call(null,inst_24162);
var state_24176__$1 = (function (){var statearr_24181 = state_24176;
(statearr_24181[(7)] = inst_24163__$1);

return statearr_24181;
})();
if(cljs.core.truth_(inst_24163__$1)){
var statearr_24182_24200 = state_24176__$1;
(statearr_24182_24200[(1)] = (7));

} else {
var statearr_24183_24201 = state_24176__$1;
(statearr_24183_24201[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24177 === (3))){
var inst_24174 = (state_24176[(2)]);
var state_24176__$1 = state_24176;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24176__$1,inst_24174);
} else {
if((state_val_24177 === (2))){
var _ = (function (){var statearr_24185 = state_24176;
(statearr_24185[(4)] = cljs.core.cons.call(null,(5),(state_24176[(4)])));

return statearr_24185;
})();
var inst_24159 = new cljs.core.Keyword(null,"ident","ident",-742346).cljs$core$IFn$_invoke$arity$1(o);
var inst_24160 = fluree.db.dbproto._subid.call(null,db,inst_24159);
var state_24176__$1 = state_24176;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24176__$1,(6),inst_24160);
} else {
if((state_val_24177 === (9))){
var inst_24167 = (state_24176[(2)]);
var inst_24168 = [new cljs.core.Keyword(null,"value","value",305978217)];
var inst_24169 = [inst_24167];
var inst_24170 = cljs.core.PersistentHashMap.fromArrays(inst_24168,inst_24169);
var inst_24171 = cljs.core.assoc.call(null,where_clause,new cljs.core.Keyword(null,"o","o",-1350007228),inst_24170);
var _ = (function (){var statearr_24186 = state_24176;
(statearr_24186[(4)] = cljs.core.rest.call(null,(state_24176[(4)])));

return statearr_24186;
})();
var state_24176__$1 = state_24176;
var statearr_24187_24202 = state_24176__$1;
(statearr_24187_24202[(2)] = inst_24171);

(statearr_24187_24202[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24177 === (5))){
var _ = (function (){var statearr_24188 = state_24176;
(statearr_24188[(4)] = cljs.core.rest.call(null,(state_24176[(4)])));

return statearr_24188;
})();
var state_24176__$1 = state_24176;
var ex24184 = (state_24176__$1[(2)]);
var statearr_24189_24203 = state_24176__$1;
(statearr_24189_24203[(5)] = ex24184);


if((ex24184 instanceof Error)){
var statearr_24190_24204 = state_24176__$1;
(statearr_24190_24204[(1)] = (4));

(statearr_24190_24204[(5)] = null);

} else {
throw ex24184;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24177 === (8))){
var state_24176__$1 = state_24176;
var statearr_24191_24205 = state_24176__$1;
(statearr_24191_24205[(2)] = (0));

(statearr_24191_24205[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2746__auto____0 = (function (){
var statearr_24192 = [null,null,null,null,null,null,null,null];
(statearr_24192[(0)] = fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2746__auto__);

(statearr_24192[(1)] = (1));

return statearr_24192;
});
var fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2746__auto____1 = (function (state_24176){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24176);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24193){var ex__2749__auto__ = e24193;
var statearr_24194_24206 = state_24176;
(statearr_24194_24206[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24176[(4)]))){
var statearr_24195_24207 = state_24176;
(statearr_24195_24207[(1)] = cljs.core.first.call(null,(state_24176[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24208 = state_24176;
state_24176 = G__24208;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2746__auto__ = function(state_24176){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2746__auto____1.call(this,state_24176);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24196 = f__2769__auto__.call(null);
(statearr_24196[(6)] = c__2768__auto__);

return statearr_24196;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.subject_crawl.subject.subj_crawl = (function fluree$db$query$subject_crawl$subject$subj_crawl(p__24209){
var map__24210 = p__24209;
var map__24210__$1 = cljs.core.__destructure_map.call(null,map__24210);
var opts = map__24210__$1;
var finish_fn = cljs.core.get.call(null,map__24210__$1,new cljs.core.Keyword(null,"finish-fn","finish-fn",1593909598));
var vars = cljs.core.get.call(null,map__24210__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var f_where = cljs.core.get.call(null,map__24210__$1,new cljs.core.Keyword(null,"f-where","f-where",-958007776));
var parallelism = cljs.core.get.call(null,map__24210__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333));
var limit = cljs.core.get.call(null,map__24210__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var ident_vars = cljs.core.get.call(null,map__24210__$1,new cljs.core.Keyword(null,"ident-vars","ident-vars",-876752986));
var db = cljs.core.get.call(null,map__24210__$1,new cljs.core.Keyword(null,"db","db",993250759));
var offset = cljs.core.get.call(null,map__24210__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var error_ch = cljs.core.get.call(null,map__24210__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24304){
var state_val_24305 = (state_24304[(1)]);
if((state_val_24305 === (7))){
var state_24304__$1 = state_24304;
var statearr_24306_24358 = state_24304__$1;
(statearr_24306_24358[(2)] = vars);

(statearr_24306_24358[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24305 === (20))){
var inst_24257 = (state_24304[(7)]);
var inst_24267 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24268 = [error_ch,inst_24257];
var inst_24269 = (new cljs.core.PersistentVector(null,2,(5),inst_24267,inst_24268,null));
var state_24304__$1 = state_24304;
return cljs.core.async.ioc_alts_BANG_.call(null,state_24304__$1,(22),inst_24269);
} else {
if((state_val_24305 === (27))){
var state_24304__$1 = state_24304;
var statearr_24307_24359 = state_24304__$1;
(statearr_24307_24359[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24305 === (1))){
var state_24304__$1 = state_24304;
var statearr_24309_24360 = state_24304__$1;
(statearr_24309_24360[(2)] = null);

(statearr_24309_24360[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24305 === (24))){
var inst_24272 = (state_24304[(8)]);
var inst_24281 = (inst_24272 == null);
var state_24304__$1 = state_24304;
if(cljs.core.truth_(inst_24281)){
var statearr_24310_24361 = state_24304__$1;
(statearr_24310_24361[(1)] = (26));

} else {
var statearr_24311_24362 = state_24304__$1;
(statearr_24311_24362[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24305 === (4))){
var inst_24211 = (state_24304[(2)]);
var state_24304__$1 = state_24304;
var statearr_24312_24363 = state_24304__$1;
(statearr_24312_24363[(2)] = inst_24211);

(statearr_24312_24363[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24305 === (15))){
var inst_24243 = (state_24304[(9)]);
var inst_24243__$1 = (state_24304[(2)]);
var inst_24244 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_24243__$1);
var inst_24245 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_24244);
var state_24304__$1 = (function (){var statearr_24313 = state_24304;
(statearr_24313[(9)] = inst_24243__$1);

return statearr_24313;
})();
if(inst_24245){
var statearr_24314_24364 = state_24304__$1;
(statearr_24314_24364[(1)] = (17));

} else {
var statearr_24315_24365 = state_24304__$1;
(statearr_24315_24365[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24305 === (21))){
var inst_24299 = (state_24304[(2)]);
var _ = (function (){var statearr_24316 = state_24304;
(statearr_24316[(4)] = cljs.core.rest.call(null,(state_24304[(4)])));

return statearr_24316;
})();
var state_24304__$1 = state_24304;
var statearr_24317_24366 = state_24304__$1;
(statearr_24317_24366[(2)] = inst_24299);

(statearr_24317_24366[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24305 === (31))){
var inst_24293 = (state_24304[(2)]);
var state_24304__$1 = state_24304;
var statearr_24318_24367 = state_24304__$1;
(statearr_24318_24367[(2)] = inst_24293);

(statearr_24318_24367[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24305 === (13))){
var inst_24237 = fluree.db.query.subject_crawl.subject.resolve_o_ident.call(null,db,f_where);
var state_24304__$1 = state_24304;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24304__$1,(16),inst_24237);
} else {
if((state_val_24305 === (22))){
var inst_24271 = (state_24304[(2)]);
var inst_24272 = cljs.core.nth.call(null,inst_24271,(0),null);
var inst_24273 = cljs.core.nth.call(null,inst_24271,(1),null);
var inst_24274 = cljs.core._EQ_.call(null,inst_24273,error_ch);
var state_24304__$1 = (function (){var statearr_24319 = state_24304;
(statearr_24319[(8)] = inst_24272);

return statearr_24319;
})();
if(inst_24274){
var statearr_24320_24368 = state_24304__$1;
(statearr_24320_24368[(1)] = (23));

} else {
var statearr_24321_24369 = state_24304__$1;
(statearr_24321_24369[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24305 === (29))){
var inst_24262 = (state_24304[(10)]);
var inst_24272 = (state_24304[(8)]);
var inst_24289 = cljs.core.conj.call(null,inst_24262,inst_24272);
var inst_24262__$1 = inst_24289;
var state_24304__$1 = (function (){var statearr_24322 = state_24304;
(statearr_24322[(10)] = inst_24262__$1);

return statearr_24322;
})();
var statearr_24323_24370 = state_24304__$1;
(statearr_24323_24370[(2)] = null);

(statearr_24323_24370[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24305 === (6))){
var inst_24223 = fluree.db.query.subject_crawl.common.resolve_ident_vars.call(null,db,vars,ident_vars);
var state_24304__$1 = state_24304;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24304__$1,(9),inst_24223);
} else {
if((state_val_24305 === (28))){
var inst_24295 = (state_24304[(2)]);
var state_24304__$1 = state_24304;
var statearr_24324_24371 = state_24304__$1;
(statearr_24324_24371[(2)] = inst_24295);

(statearr_24324_24371[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24305 === (25))){
var inst_24297 = (state_24304[(2)]);
var state_24304__$1 = state_24304;
var statearr_24325_24372 = state_24304__$1;
(statearr_24325_24372[(2)] = inst_24297);

(statearr_24325_24372[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24305 === (17))){
var inst_24243 = (state_24304[(9)]);
var inst_24229 = (state_24304[(11)]);
var inst_24247 = fluree.db.query.subject_crawl.subject.subjects_id_chan.call(null,db,error_ch,inst_24229,inst_24243);
var state_24304__$1 = state_24304;
var statearr_24326_24373 = state_24304__$1;
(statearr_24326_24373[(2)] = inst_24247);

(statearr_24326_24373[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24305 === (3))){
var inst_24302 = (state_24304[(2)]);
var state_24304__$1 = state_24304;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24304__$1,inst_24302);
} else {
if((state_val_24305 === (12))){
var inst_24235 = (state_24304[(2)]);
var state_24304__$1 = state_24304;
if(cljs.core.truth_(inst_24235)){
var statearr_24327_24374 = state_24304__$1;
(statearr_24327_24374[(1)] = (13));

} else {
var statearr_24328_24375 = state_24304__$1;
(statearr_24328_24375[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24305 === (2))){
var _ = (function (){var statearr_24329 = state_24304;
(statearr_24329[(4)] = cljs.core.cons.call(null,(5),(state_24304[(4)])));

return statearr_24329;
})();
var inst_24218 = f_where;
var inst_24219 = cljs.core.__destructure_map.call(null,inst_24218);
var inst_24220 = cljs.core.get.call(null,inst_24219,new cljs.core.Keyword(null,"o","o",-1350007228));
var inst_24221 = cljs.core.get.call(null,inst_24219,new cljs.core.Keyword(null,"p-ref?","p-ref?",-1416067934));
var state_24304__$1 = (function (){var statearr_24330 = state_24304;
(statearr_24330[(12)] = inst_24220);

(statearr_24330[(13)] = inst_24221);

return statearr_24330;
})();
if(cljs.core.truth_(ident_vars)){
var statearr_24331_24376 = state_24304__$1;
(statearr_24331_24376[(1)] = (6));

} else {
var statearr_24332_24377 = state_24304__$1;
(statearr_24332_24377[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24305 === (23))){
var inst_24272 = (state_24304[(8)]);
var inst_24257 = (state_24304[(7)]);
var inst_24256 = (state_24304[(14)]);
var inst_24251 = (state_24304[(15)]);
var inst_24276 = cljs.core.async.close_BANG_.call(null,inst_24251);
var inst_24277 = cljs.core.async.close_BANG_.call(null,inst_24256);
var inst_24278 = cljs.core.async.close_BANG_.call(null,inst_24257);
var inst_24279 = (function(){throw inst_24272})();
var state_24304__$1 = (function (){var statearr_24333 = state_24304;
(statearr_24333[(16)] = inst_24276);

(statearr_24333[(17)] = inst_24278);

(statearr_24333[(18)] = inst_24277);

return statearr_24333;
})();
var statearr_24334_24378 = state_24304__$1;
(statearr_24334_24378[(2)] = inst_24279);

(statearr_24334_24378[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24305 === (19))){
var inst_24257 = (state_24304[(7)]);
var inst_24256 = (state_24304[(14)]);
var inst_24230 = (state_24304[(19)]);
var inst_24251 = (state_24304[(15)]);
var inst_24251__$1 = (state_24304[(2)]);
var inst_24252 = fluree.db.query.subject_crawl.subject.flakes_xf.call(null,inst_24230);
var inst_24253 = cljs.core.drop.call(null,offset);
var inst_24254 = cljs.core.take.call(null,limit);
var inst_24255 = cljs.core.comp.call(null,inst_24253,inst_24254);
var inst_24256__$1 = cljs.core.async.chan.call(null,(32),inst_24255);
var inst_24257__$1 = cljs.core.async.chan.call(null);
var inst_24258 = cljs.core.async.pipeline_async.call(null,parallelism,inst_24256__$1,inst_24252,inst_24251__$1);
var inst_24259 = fluree.db.query.subject_crawl.common.result_af.call(null,inst_24230);
var inst_24260 = cljs.core.async.pipeline_async.call(null,parallelism,inst_24257__$1,inst_24259,inst_24256__$1);
var inst_24261 = cljs.core.PersistentVector.EMPTY;
var inst_24262 = inst_24261;
var state_24304__$1 = (function (){var statearr_24335 = state_24304;
(statearr_24335[(10)] = inst_24262);

(statearr_24335[(20)] = inst_24260);

(statearr_24335[(21)] = inst_24258);

(statearr_24335[(7)] = inst_24257__$1);

(statearr_24335[(14)] = inst_24256__$1);

(statearr_24335[(15)] = inst_24251__$1);

return statearr_24335;
})();
var statearr_24336_24379 = state_24304__$1;
(statearr_24336_24379[(2)] = null);

(statearr_24336_24379[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24305 === (11))){
var inst_24221 = (state_24304[(13)]);
var state_24304__$1 = state_24304;
var statearr_24338_24380 = state_24304__$1;
(statearr_24338_24380[(2)] = inst_24221);

(statearr_24338_24380[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24305 === (9))){
var inst_24225 = (state_24304[(2)]);
var inst_24226 = fluree.db.util.async.throw_err.call(null,inst_24225);
var state_24304__$1 = state_24304;
var statearr_24339_24381 = state_24304__$1;
(statearr_24339_24381[(2)] = inst_24226);

(statearr_24339_24381[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24305 === (5))){
var _ = (function (){var statearr_24340 = state_24304;
(statearr_24340[(4)] = cljs.core.rest.call(null,(state_24304[(4)])));

return statearr_24340;
})();
var state_24304__$1 = state_24304;
var ex24337 = (state_24304__$1[(2)]);
var statearr_24341_24382 = state_24304__$1;
(statearr_24341_24382[(5)] = ex24337);


if((ex24337 instanceof Error)){
var statearr_24342_24383 = state_24304__$1;
(statearr_24342_24383[(1)] = (4));

(statearr_24342_24383[(5)] = null);

} else {
throw ex24337;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24305 === (14))){
var state_24304__$1 = state_24304;
var statearr_24343_24384 = state_24304__$1;
(statearr_24343_24384[(2)] = f_where);

(statearr_24343_24384[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24305 === (26))){
var inst_24262 = (state_24304[(10)]);
var inst_24257 = (state_24304[(7)]);
var inst_24256 = (state_24304[(14)]);
var inst_24251 = (state_24304[(15)]);
var inst_24283 = cljs.core.async.close_BANG_.call(null,inst_24251);
var inst_24284 = cljs.core.async.close_BANG_.call(null,inst_24256);
var inst_24285 = cljs.core.async.close_BANG_.call(null,inst_24257);
var inst_24286 = finish_fn.call(null,inst_24262);
var state_24304__$1 = (function (){var statearr_24344 = state_24304;
(statearr_24344[(22)] = inst_24285);

(statearr_24344[(23)] = inst_24284);

(statearr_24344[(24)] = inst_24283);

return statearr_24344;
})();
var statearr_24345_24385 = state_24304__$1;
(statearr_24345_24385[(2)] = inst_24286);

(statearr_24345_24385[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24305 === (16))){
var inst_24239 = (state_24304[(2)]);
var inst_24240 = fluree.db.util.async.throw_err.call(null,inst_24239);
var state_24304__$1 = state_24304;
var statearr_24346_24386 = state_24304__$1;
(statearr_24346_24386[(2)] = inst_24240);

(statearr_24346_24386[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24305 === (30))){
var state_24304__$1 = state_24304;
var statearr_24347_24387 = state_24304__$1;
(statearr_24347_24387[(2)] = null);

(statearr_24347_24387[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24305 === (10))){
var inst_24220 = (state_24304[(12)]);
var inst_24232 = new cljs.core.Keyword(null,"ident","ident",-742346).cljs$core$IFn$_invoke$arity$1(inst_24220);
var state_24304__$1 = state_24304;
var statearr_24348_24388 = state_24304__$1;
(statearr_24348_24388[(2)] = inst_24232);

(statearr_24348_24388[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24305 === (18))){
var inst_24243 = (state_24304[(9)]);
var inst_24229 = (state_24304[(11)]);
var inst_24249 = fluree.db.query.subject_crawl.subject.subjects_chan.call(null,db,error_ch,inst_24229,inst_24243);
var state_24304__$1 = state_24304;
var statearr_24349_24389 = state_24304__$1;
(statearr_24349_24389[(2)] = inst_24249);

(statearr_24349_24389[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24305 === (8))){
var inst_24229 = (state_24304[(11)]);
var inst_24221 = (state_24304[(13)]);
var inst_24229__$1 = (state_24304[(2)]);
var inst_24230 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"vars","vars",-2046957217),inst_24229__$1);
var state_24304__$1 = (function (){var statearr_24350 = state_24304;
(statearr_24350[(19)] = inst_24230);

(statearr_24350[(11)] = inst_24229__$1);

return statearr_24350;
})();
if(cljs.core.truth_(inst_24221)){
var statearr_24351_24390 = state_24304__$1;
(statearr_24351_24390[(1)] = (10));

} else {
var statearr_24352_24391 = state_24304__$1;
(statearr_24352_24391[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto____0 = (function (){
var statearr_24353 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24353[(0)] = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto__);

(statearr_24353[(1)] = (1));

return statearr_24353;
});
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto____1 = (function (state_24304){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24304);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24354){var ex__2749__auto__ = e24354;
var statearr_24355_24392 = state_24304;
(statearr_24355_24392[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24304[(4)]))){
var statearr_24356_24393 = state_24304;
(statearr_24356_24393[(1)] = cljs.core.first.call(null,(state_24304[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24394 = state_24304;
state_24304 = G__24394;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto__ = function(state_24304){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto____1.call(this,state_24304);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24357 = f__2769__auto__.call(null);
(statearr_24357[(6)] = c__2768__auto__);

return statearr_24357;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
