// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.ledger_id = ledger_id;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k27189,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__27193 = k27189;
var G__27193__$1 = (((G__27193 instanceof cljs.core.Keyword))?G__27193.fqn:null);
switch (G__27193__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "ledger-id":
return self__.ledger_id;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k27189,else__5346__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5366__auto__,p__27194){
var vec__27195 = p__27194;
var k__5367__auto__ = cljs.core.nth.call(null,vec__27195,(0),null);
var v__5368__auto__ = cljs.core.nth.call(null,vec__27195,(1),null);
return f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__);
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.session.DbSession{",", ","}",opts__5360__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27188){
var self__ = this;
var G__27188__$1 = this;
return (new cljs.core.RecordIter((0),G__27188__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (11 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll.call(null,coll__5340__auto__));
}).call(null,this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27190,other27191){
var self__ = this;
var this27190__$1 = this;
return (((!((other27191 == null)))) && ((((this27190__$1.constructor === other27191.constructor)) && (((cljs.core._EQ_.call(null,this27190__$1.conn,other27191.conn)) && (((cljs.core._EQ_.call(null,this27190__$1.network,other27191.network)) && (((cljs.core._EQ_.call(null,this27190__$1.ledger_id,other27191.ledger_id)) && (((cljs.core._EQ_.call(null,this27190__$1.db_name,other27191.db_name)) && (((cljs.core._EQ_.call(null,this27190__$1.update_chan,other27191.update_chan)) && (((cljs.core._EQ_.call(null,this27190__$1.transact_chan,other27191.transact_chan)) && (((cljs.core._EQ_.call(null,this27190__$1.state,other27191.state)) && (((cljs.core._EQ_.call(null,this27190__$1.schema_cache,other27191.schema_cache)) && (((cljs.core._EQ_.call(null,this27190__$1.blank_db,other27191.blank_db)) && (((cljs.core._EQ_.call(null,this27190__$1.close,other27191.close)) && (((cljs.core._EQ_.call(null,this27190__$1.id,other27191.id)) && (cljs.core._EQ_.call(null,this27190__$1.__extmap,other27191.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k27189){
var self__ = this;
var this__5350__auto____$1 = this;
var G__27198 = k27189;
var G__27198__$1 = (((G__27198 instanceof cljs.core.Keyword))?G__27198.fqn:null);
switch (G__27198__$1) {
case "conn":
case "network":
case "ledger-id":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k27189);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__27188){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__27199 = cljs.core.keyword_identical_QMARK_;
var expr__27200 = k__5352__auto__;
if(cljs.core.truth_(pred__27199.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__27200))){
return (new fluree.db.session.DbSession(G__27188,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27199.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__27200))){
return (new fluree.db.session.DbSession(self__.conn,G__27188,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27199.call(null,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),expr__27200))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__27188,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27199.call(null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),expr__27200))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,G__27188,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27199.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),expr__27200))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,G__27188,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27199.call(null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),expr__27200))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,G__27188,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27199.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__27200))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,G__27188,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27199.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__27200))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__27188,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27199.call(null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),expr__27200))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__27188,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27199.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__27200))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__27188,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27199.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__27200))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__27188,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5352__auto__,G__27188),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__27188){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__27188,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5349__auto__,(0)),cljs.core._nth.call(null,entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"ledger-id","ledger-id",-949008754,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write.call(null,writer__5390__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__27192){
var extmap__5385__auto__ = (function (){var G__27202 = cljs.core.dissoc.call(null,G__27192,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.record_QMARK_.call(null,G__27192)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__27202);
} else {
return G__27202;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27192),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27192),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(G__27192),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__27192),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__27192),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__27192),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__27192),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27192),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__27192),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__27192),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__27192),null,cljs.core.not_empty.call(null,extmap__5385__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.call(null,fluree.db.session.cache_factory.call(null));
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__27205 = session;
var map__27205__$1 = cljs.core.__destructure_map.call(null,map__27205);
var network = cljs.core.get.call(null,map__27205__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__27205__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null);
cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.call(null,c,cache_key))){
return c;
} else {
return cljs.core.assoc.call(null,c,cache_key,session);
}
}));

return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,ledger_id){
return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,ledger_id){
return cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_.call(null,fluree.db.session.session_cache,fluree.db.session.cache_factory.call(null));
});
fluree.db.session.ready_QMARK_ = (function fluree$db$session$ready_QMARK_(db_info){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"ready","ready",1086465795),cljs.core.keyword.call(null,new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(db_info)));
});
fluree.db.session.load_ledger_info = (function fluree$db$session$load_ledger_info(conn,network,ledger_id){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27247){
var state_val_27248 = (state_27247[(1)]);
if((state_val_27248 === (7))){
var inst_27221 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)," is not found on this ledger group."].join('');
var inst_27222 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27223 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_27224 = cljs.core.PersistentHashMap.fromArrays(inst_27222,inst_27223);
var inst_27225 = cljs.core.ex_info.call(null,inst_27221,inst_27224);
var inst_27226 = (function(){throw inst_27225})();
var state_27247__$1 = state_27247;
var statearr_27249_27272 = state_27247__$1;
(statearr_27249_27272[(2)] = inst_27226);

(statearr_27249_27272[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27248 === (1))){
var state_27247__$1 = state_27247;
var statearr_27250_27273 = state_27247__$1;
(statearr_27250_27273[(2)] = null);

(statearr_27250_27273[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27248 === (4))){
var inst_27206 = (state_27247[(2)]);
var state_27247__$1 = state_27247;
var statearr_27251_27274 = state_27247__$1;
(statearr_27251_27274[(2)] = inst_27206);

(statearr_27251_27274[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27248 === (6))){
var inst_27218 = (state_27247[(7)]);
var inst_27217 = (state_27247[(2)]);
var inst_27218__$1 = fluree.db.util.async.throw_err.call(null,inst_27217);
var inst_27219 = cljs.core.empty_QMARK_.call(null,inst_27218__$1);
var state_27247__$1 = (function (){var statearr_27252 = state_27247;
(statearr_27252[(7)] = inst_27218__$1);

return statearr_27252;
})();
if(inst_27219){
var statearr_27253_27275 = state_27247__$1;
(statearr_27253_27275[(1)] = (7));

} else {
var statearr_27254_27276 = state_27247__$1;
(statearr_27254_27276[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27248 === (3))){
var inst_27245 = (state_27247[(2)]);
var state_27247__$1 = state_27247;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27247__$1,inst_27245);
} else {
if((state_val_27248 === (12))){
var inst_27240 = (state_27247[(2)]);
var state_27247__$1 = state_27247;
var statearr_27255_27277 = state_27247__$1;
(statearr_27255_27277[(2)] = inst_27240);

(statearr_27255_27277[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27248 === (2))){
var _ = (function (){var statearr_27256 = state_27247;
(statearr_27256[(4)] = cljs.core.cons.call(null,(5),(state_27247[(4)])));

return statearr_27256;
})();
var inst_27212 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27213 = [network,ledger_id];
var inst_27214 = (new cljs.core.PersistentVector(null,2,(5),inst_27212,inst_27213,null));
var inst_27215 = fluree.db.operations.ledger_info_async.call(null,conn,inst_27214);
var state_27247__$1 = state_27247;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27247__$1,(6),inst_27215);
} else {
if((state_val_27248 === (11))){
var inst_27218 = (state_27247[(7)]);
var state_27247__$1 = state_27247;
var statearr_27258_27278 = state_27247__$1;
(statearr_27258_27278[(2)] = inst_27218);

(statearr_27258_27278[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27248 === (9))){
var inst_27242 = (state_27247[(2)]);
var _ = (function (){var statearr_27259 = state_27247;
(statearr_27259[(4)] = cljs.core.rest.call(null,(state_27247[(4)])));

return statearr_27259;
})();
var state_27247__$1 = state_27247;
var statearr_27260_27279 = state_27247__$1;
(statearr_27260_27279[(2)] = inst_27242);

(statearr_27260_27279[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27248 === (5))){
var _ = (function (){var statearr_27261 = state_27247;
(statearr_27261[(4)] = cljs.core.rest.call(null,(state_27247[(4)])));

return statearr_27261;
})();
var state_27247__$1 = state_27247;
var ex27257 = (state_27247__$1[(2)]);
var statearr_27262_27280 = state_27247__$1;
(statearr_27262_27280[(5)] = ex27257);


if((ex27257 instanceof Error)){
var statearr_27263_27281 = state_27247__$1;
(statearr_27263_27281[(1)] = (4));

(statearr_27263_27281[(5)] = null);

} else {
throw ex27257;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27248 === (10))){
var inst_27218 = (state_27247[(7)]);
var inst_27231 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_27218);
var inst_27232 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27231),"."].join('');
var inst_27233 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27234 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_27235 = cljs.core.PersistentHashMap.fromArrays(inst_27233,inst_27234);
var inst_27236 = cljs.core.ex_info.call(null,inst_27232,inst_27235);
var inst_27237 = (function(){throw inst_27236})();
var state_27247__$1 = state_27247;
var statearr_27264_27282 = state_27247__$1;
(statearr_27264_27282[(2)] = inst_27237);

(statearr_27264_27282[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27248 === (8))){
var inst_27218 = (state_27247[(7)]);
var inst_27228 = fluree.db.session.ready_QMARK_.call(null,inst_27218);
var inst_27229 = (!(inst_27228));
var state_27247__$1 = state_27247;
if(inst_27229){
var statearr_27265_27283 = state_27247__$1;
(statearr_27265_27283[(1)] = (10));

} else {
var statearr_27266_27284 = state_27247__$1;
(statearr_27266_27284[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_ledger_info_$_state_machine__2746__auto__ = null;
var fluree$db$session$load_ledger_info_$_state_machine__2746__auto____0 = (function (){
var statearr_27267 = [null,null,null,null,null,null,null,null];
(statearr_27267[(0)] = fluree$db$session$load_ledger_info_$_state_machine__2746__auto__);

(statearr_27267[(1)] = (1));

return statearr_27267;
});
var fluree$db$session$load_ledger_info_$_state_machine__2746__auto____1 = (function (state_27247){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27247);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27268){var ex__2749__auto__ = e27268;
var statearr_27269_27285 = state_27247;
(statearr_27269_27285[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27247[(4)]))){
var statearr_27270_27286 = state_27247;
(statearr_27270_27286[(1)] = cljs.core.first.call(null,(state_27247[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27287 = state_27247;
state_27247 = G__27287;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$load_ledger_info_$_state_machine__2746__auto__ = function(state_27247){
switch(arguments.length){
case 0:
return fluree$db$session$load_ledger_info_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$load_ledger_info_$_state_machine__2746__auto____1.call(this,state_27247);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_ledger_info_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_ledger_info_$_state_machine__2746__auto____0;
fluree$db$session$load_ledger_info_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_ledger_info_$_state_machine__2746__auto____1;
return fluree$db$session$load_ledger_info_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27271 = f__2769__auto__.call(null);
(statearr_27271[(6)] = c__2768__auto__);

return statearr_27271;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.session.load_current_db = (function fluree$db$session$load_current_db(conn,p__27288){
var map__27289 = p__27288;
var map__27289__$1 = cljs.core.__destructure_map.call(null,map__27289);
var blank_db = map__27289__$1;
var network = cljs.core.get.call(null,map__27289__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__27289__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27364){
var state_val_27365 = (state_27364[(1)]);
if((state_val_27365 === (7))){
var inst_27307 = (state_27364[(7)]);
var inst_27306 = (state_27364[(2)]);
var inst_27307__$1 = fluree.db.util.async.throw_err.call(null,inst_27306);
var state_27364__$1 = (function (){var statearr_27366 = state_27364;
(statearr_27366[(7)] = inst_27307__$1);

return statearr_27366;
})();
if(cljs.core.truth_(inst_27307__$1)){
var statearr_27367_27402 = state_27364__$1;
(statearr_27367_27402[(1)] = (8));

} else {
var statearr_27368_27403 = state_27364__$1;
(statearr_27368_27403[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27365 === (20))){
var inst_27312 = (state_27364[(8)]);
var inst_27345 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27312)," for ledger: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_27346 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27347 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_27348 = cljs.core.PersistentHashMap.fromArrays(inst_27346,inst_27347);
var inst_27349 = cljs.core.ex_info.call(null,inst_27345,inst_27348);
var inst_27350 = (function(){throw inst_27349})();
var state_27364__$1 = state_27364;
var statearr_27369_27404 = state_27364__$1;
(statearr_27369_27404[(2)] = inst_27350);

(statearr_27369_27404[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27365 === (1))){
var state_27364__$1 = state_27364;
var statearr_27370_27405 = state_27364__$1;
(statearr_27370_27405[(2)] = null);

(statearr_27370_27405[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27365 === (4))){
var inst_27290 = (state_27364[(2)]);
var state_27364__$1 = state_27364;
var statearr_27371_27406 = state_27364__$1;
(statearr_27371_27406[(2)] = inst_27290);

(statearr_27371_27406[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27365 === (15))){
var inst_27354 = (state_27364[(2)]);
var state_27364__$1 = state_27364;
var statearr_27372_27407 = state_27364__$1;
(statearr_27372_27407[(2)] = inst_27354);

(statearr_27372_27407[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27365 === (21))){
var inst_27352 = (state_27364[(2)]);
var state_27364__$1 = state_27364;
var statearr_27373_27408 = state_27364__$1;
(statearr_27373_27408[(2)] = inst_27352);

(statearr_27373_27408[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27365 === (13))){
var inst_27311 = (state_27364[(9)]);
var inst_27316 = fluree.db.query.schema.schema_map.call(null,inst_27311);
var inst_27317 = fluree.db.query.schema.setting_map.call(null,inst_27311);
var inst_27318 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(inst_27311);
var inst_27319 = cljs.core.swap_BANG_.call(null,inst_27318,cljs.core.empty);
var state_27364__$1 = (function (){var statearr_27374 = state_27364;
(statearr_27374[(10)] = inst_27317);

(statearr_27374[(11)] = inst_27319);

return statearr_27374;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27364__$1,(16),inst_27316);
} else {
if((state_val_27365 === (22))){
var inst_27312 = (state_27364[(8)]);
var inst_27340 = (state_27364[(2)]);
var inst_27341 = fluree.db.util.async.throw_err.call(null,inst_27340);
var inst_27342 = (inst_27312 + (1));
var inst_27311 = inst_27341;
var inst_27312__$1 = inst_27342;
var state_27364__$1 = (function (){var statearr_27375 = state_27364;
(statearr_27375[(9)] = inst_27311);

(statearr_27375[(8)] = inst_27312__$1);

return statearr_27375;
})();
var statearr_27376_27409 = state_27364__$1;
(statearr_27376_27409[(2)] = null);

(statearr_27376_27409[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27365 === (6))){
var inst_27299 = (state_27364[(2)]);
var inst_27300 = fluree.db.util.async.throw_err.call(null,inst_27299);
var inst_27301 = cljs.core.__destructure_map.call(null,inst_27300);
var inst_27302 = cljs.core.get.call(null,inst_27301,new cljs.core.Keyword(null,"block","block",664686210));
var inst_27303 = cljs.core.get.call(null,inst_27301,new cljs.core.Keyword(null,"index","index",-1531685915));
var inst_27304 = fluree.db.storage.core.reify_db.call(null,conn,network,ledger_id,blank_db,inst_27303);
var state_27364__$1 = (function (){var statearr_27377 = state_27364;
(statearr_27377[(12)] = inst_27302);

return statearr_27377;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27364__$1,(7),inst_27304);
} else {
if((state_val_27365 === (17))){
var inst_27322 = (state_27364[(13)]);
var inst_27311 = (state_27364[(9)]);
var inst_27324 = (state_27364[(2)]);
var inst_27325 = fluree.db.util.async.throw_err.call(null,inst_27324);
var inst_27326 = cljs.core.assoc.call(null,inst_27311,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_27322,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_27325);
var state_27364__$1 = state_27364;
var statearr_27378_27410 = state_27364__$1;
(statearr_27378_27410[(2)] = inst_27326);

(statearr_27378_27410[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27365 === (3))){
var inst_27362 = (state_27364[(2)]);
var state_27364__$1 = state_27364;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27364__$1,inst_27362);
} else {
if((state_val_27365 === (12))){
var inst_27356 = (state_27364[(2)]);
var state_27364__$1 = state_27364;
var statearr_27379_27411 = state_27364__$1;
(statearr_27379_27411[(2)] = inst_27356);

(statearr_27379_27411[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27365 === (2))){
var _ = (function (){var statearr_27380 = state_27364;
(statearr_27380[(4)] = cljs.core.cons.call(null,(5),(state_27364[(4)])));

return statearr_27380;
})();
var inst_27297 = fluree.db.session.load_ledger_info.call(null,conn,network,ledger_id);
var state_27364__$1 = state_27364;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27364__$1,(6),inst_27297);
} else {
if((state_val_27365 === (19))){
var inst_27311 = (state_27364[(9)]);
var inst_27331 = (state_27364[(14)]);
var inst_27334 = cljs.core.__destructure_map.call(null,inst_27331);
var inst_27335 = cljs.core.get.call(null,inst_27334,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_27336 = cljs.core.get.call(null,inst_27334,new cljs.core.Keyword(null,"block","block",664686210));
var inst_27337 = cljs.core.get.call(null,inst_27334,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_27338 = fluree.db.dbproto._with.call(null,inst_27311,inst_27336,inst_27335);
var state_27364__$1 = (function (){var statearr_27381 = state_27364;
(statearr_27381[(15)] = inst_27337);

return statearr_27381;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27364__$1,(22),inst_27338);
} else {
if((state_val_27365 === (11))){
var inst_27302 = (state_27364[(12)]);
var inst_27312 = (state_27364[(8)]);
var inst_27314 = (inst_27312 > inst_27302);
var state_27364__$1 = state_27364;
if(cljs.core.truth_(inst_27314)){
var statearr_27383_27412 = state_27364__$1;
(statearr_27383_27412[(1)] = (13));

} else {
var statearr_27384_27413 = state_27364__$1;
(statearr_27384_27413[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27365 === (9))){
var state_27364__$1 = state_27364;
var statearr_27385_27414 = state_27364__$1;
(statearr_27385_27414[(2)] = null);

(statearr_27385_27414[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27365 === (5))){
var _ = (function (){var statearr_27386 = state_27364;
(statearr_27386[(4)] = cljs.core.rest.call(null,(state_27364[(4)])));

return statearr_27386;
})();
var state_27364__$1 = state_27364;
var ex27382 = (state_27364__$1[(2)]);
var statearr_27387_27415 = state_27364__$1;
(statearr_27387_27415[(5)] = ex27382);


if((ex27382 instanceof Error)){
var statearr_27388_27416 = state_27364__$1;
(statearr_27388_27416[(1)] = (4));

(statearr_27388_27416[(5)] = null);

} else {
throw ex27382;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27365 === (14))){
var inst_27312 = (state_27364[(8)]);
var inst_27328 = fluree.db.storage.core.read_block.call(null,conn,network,ledger_id,inst_27312);
var state_27364__$1 = state_27364;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27364__$1,(18),inst_27328);
} else {
if((state_val_27365 === (16))){
var inst_27317 = (state_27364[(10)]);
var inst_27321 = (state_27364[(2)]);
var inst_27322 = fluree.db.util.async.throw_err.call(null,inst_27321);
var state_27364__$1 = (function (){var statearr_27389 = state_27364;
(statearr_27389[(13)] = inst_27322);

return statearr_27389;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27364__$1,(17),inst_27317);
} else {
if((state_val_27365 === (10))){
var inst_27359 = (state_27364[(2)]);
var _ = (function (){var statearr_27390 = state_27364;
(statearr_27390[(4)] = cljs.core.rest.call(null,(state_27364[(4)])));

return statearr_27390;
})();
var state_27364__$1 = state_27364;
var statearr_27391_27417 = state_27364__$1;
(statearr_27391_27417[(2)] = inst_27359);

(statearr_27391_27417[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27365 === (18))){
var inst_27331 = (state_27364[(14)]);
var inst_27330 = (state_27364[(2)]);
var inst_27331__$1 = fluree.db.util.async.throw_err.call(null,inst_27330);
var state_27364__$1 = (function (){var statearr_27392 = state_27364;
(statearr_27392[(14)] = inst_27331__$1);

return statearr_27392;
})();
if(cljs.core.truth_(inst_27331__$1)){
var statearr_27393_27418 = state_27364__$1;
(statearr_27393_27418[(1)] = (19));

} else {
var statearr_27394_27419 = state_27364__$1;
(statearr_27394_27419[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27365 === (8))){
var inst_27307 = (state_27364[(7)]);
var inst_27309 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27307);
var inst_27310 = (inst_27309 + (1));
var inst_27311 = inst_27307;
var inst_27312 = inst_27310;
var state_27364__$1 = (function (){var statearr_27395 = state_27364;
(statearr_27395[(9)] = inst_27311);

(statearr_27395[(8)] = inst_27312);

return statearr_27395;
})();
var statearr_27396_27420 = state_27364__$1;
(statearr_27396_27420[(2)] = null);

(statearr_27396_27420[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_current_db_$_state_machine__2746__auto__ = null;
var fluree$db$session$load_current_db_$_state_machine__2746__auto____0 = (function (){
var statearr_27397 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27397[(0)] = fluree$db$session$load_current_db_$_state_machine__2746__auto__);

(statearr_27397[(1)] = (1));

return statearr_27397;
});
var fluree$db$session$load_current_db_$_state_machine__2746__auto____1 = (function (state_27364){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27364);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27398){var ex__2749__auto__ = e27398;
var statearr_27399_27421 = state_27364;
(statearr_27399_27421[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27364[(4)]))){
var statearr_27400_27422 = state_27364;
(statearr_27400_27422[(1)] = cljs.core.first.call(null,(state_27364[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27423 = state_27364;
state_27364 = G__27423;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$load_current_db_$_state_machine__2746__auto__ = function(state_27364){
switch(arguments.length){
case 0:
return fluree$db$session$load_current_db_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$load_current_db_$_state_machine__2746__auto____1.call(this,state_27364);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_current_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_current_db_$_state_machine__2746__auto____0;
fluree$db$session$load_current_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_current_db_$_state_machine__2746__auto____1;
return fluree$db$session$load_current_db_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27401 = f__2769__auto__.call(null);
(statearr_27401[(6)] = c__2768__auto__);

return statearr_27401;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Perform a compare and set operation to update the db stored in the session
 *   argument's state atom. Update the cache to `new-db-ch`, but only if the
 *   previously stored db channel is the same as the `old-db-ch`. Returns a boolean
 *   indicating whether the cache was updated.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(p__27424,old_db_ch,new_db_ch){
var map__27425 = p__27424;
var map__27425__$1 = cljs.core.__destructure_map.call(null,map__27425);
var state = cljs.core.get.call(null,map__27425__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core._EQ_.call(null,new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.call(null,state,(function (p__27426){
var map__27427 = p__27426;
var map__27427__$1 = cljs.core.__destructure_map.call(null,map__27427);
var s = map__27427__$1;
var current = cljs.core.get.call(null,map__27427__$1,new cljs.core.Keyword("db","current","db/current",-1088041545));
if(cljs.core._EQ_.call(null,current,old_db_ch)){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","current","db/current",-1088041545),new_db_ch);
} else {
return s;
}
}))),new_db_ch);
});
/**
 * Clears db channel from session state, forcing a new full load next time db
 *   channel is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(p__27428){
var map__27429 = p__27428;
var map__27429__$1 = cljs.core.__destructure_map.call(null,map__27429);
var state = cljs.core.get.call(null,map__27429__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
});
/**
 * Clears any cached database channels and forces an immediate reload. Returns a
 *   channel that will contain the newly loaded database
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(p__27430){
var map__27431 = p__27430;
var map__27431__$1 = cljs.core.__destructure_map.call(null,map__27431);
var conn = cljs.core.get.call(null,map__27431__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var blank_db = cljs.core.get.call(null,map__27431__$1,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534));
var state = cljs.core.get.call(null,map__27431__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var db_ch = cljs.core.async.promise_chan.call(null);
cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),db_ch);

var c__2768__auto___27468 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27451){
var state_val_27452 = (state_27451[(1)]);
if((state_val_27452 === (1))){
var state_27451__$1 = state_27451;
var statearr_27453_27469 = state_27451__$1;
(statearr_27453_27469[(2)] = null);

(statearr_27453_27469[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27452 === (2))){
var _ = (function (){var statearr_27454 = state_27451;
(statearr_27454[(4)] = cljs.core.cons.call(null,(5),(state_27451[(4)])));

return statearr_27454;
})();
var inst_27441 = fluree.db.session.load_current_db.call(null,conn,blank_db);
var state_27451__$1 = state_27451;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27451__$1,(6),inst_27441);
} else {
if((state_val_27452 === (3))){
var inst_27449 = (state_27451[(2)]);
var state_27451__$1 = state_27451;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27451__$1,inst_27449);
} else {
if((state_val_27452 === (4))){
var inst_27432 = (state_27451[(2)]);
var inst_27433 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
var inst_27434 = fluree.db.util.log.error.call(null,inst_27432,"Error reloading db");
var inst_27435 = cljs.core.async.put_BANG_.call(null,db_ch,inst_27432);
var state_27451__$1 = (function (){var statearr_27456 = state_27451;
(statearr_27456[(7)] = inst_27433);

(statearr_27456[(8)] = inst_27434);

return statearr_27456;
})();
var statearr_27457_27470 = state_27451__$1;
(statearr_27457_27470[(2)] = inst_27435);

(statearr_27457_27470[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27452 === (5))){
var _ = (function (){var statearr_27458 = state_27451;
(statearr_27458[(4)] = cljs.core.rest.call(null,(state_27451[(4)])));

return statearr_27458;
})();
var state_27451__$1 = state_27451;
var ex27455 = (state_27451__$1[(2)]);
var statearr_27459_27471 = state_27451__$1;
(statearr_27459_27471[(5)] = ex27455);


var statearr_27460_27472 = state_27451__$1;
(statearr_27460_27472[(1)] = (4));

(statearr_27460_27472[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27452 === (6))){
var inst_27443 = (state_27451[(2)]);
var inst_27444 = fluree.db.util.async.throw_err.call(null,inst_27443);
var state_27451__$1 = state_27451;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27451__$1,(7),db_ch,inst_27444);
} else {
if((state_val_27452 === (7))){
var inst_27446 = (state_27451[(2)]);
var _ = (function (){var statearr_27461 = state_27451;
(statearr_27461[(4)] = cljs.core.rest.call(null,(state_27451[(4)])));

return statearr_27461;
})();
var state_27451__$1 = state_27451;
var statearr_27462_27473 = state_27451__$1;
(statearr_27462_27473[(2)] = inst_27446);

(statearr_27462_27473[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$reload_db_BANG__$_state_machine__2746__auto__ = null;
var fluree$db$session$reload_db_BANG__$_state_machine__2746__auto____0 = (function (){
var statearr_27463 = [null,null,null,null,null,null,null,null,null];
(statearr_27463[(0)] = fluree$db$session$reload_db_BANG__$_state_machine__2746__auto__);

(statearr_27463[(1)] = (1));

return statearr_27463;
});
var fluree$db$session$reload_db_BANG__$_state_machine__2746__auto____1 = (function (state_27451){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27451);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27464){var ex__2749__auto__ = e27464;
var statearr_27465_27474 = state_27451;
(statearr_27465_27474[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27451[(4)]))){
var statearr_27466_27475 = state_27451;
(statearr_27466_27475[(1)] = cljs.core.first.call(null,(state_27451[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27476 = state_27451;
state_27451 = G__27476;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$reload_db_BANG__$_state_machine__2746__auto__ = function(state_27451){
switch(arguments.length){
case 0:
return fluree$db$session$reload_db_BANG__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$reload_db_BANG__$_state_machine__2746__auto____1.call(this,state_27451);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$reload_db_BANG__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$reload_db_BANG__$_state_machine__2746__auto____0;
fluree$db$session$reload_db_BANG__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$reload_db_BANG__$_state_machine__2746__auto____1;
return fluree$db$session$reload_db_BANG__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27467 = f__2769__auto__.call(null);
(statearr_27467[(6)] = c__2768__auto___27468);

return statearr_27467;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return db_ch;
});
/**
 * Gets the channel containing the current database from the session's state. If
 *   no database channel is cached then the current database is loaded form storage
 *   and a new channel containing it is cached. Returns the cached channel that
 *   will contain the current database
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(var_args){
var G__27478 = arguments.length;
switch (G__27478) {
case 1:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 = (function (p__27479){
var map__27480 = p__27479;
var map__27480__$1 = cljs.core.__destructure_map.call(null,map__27480);
var session = map__27480__$1;
var blank_db = cljs.core.get.call(null,map__27480__$1,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534));
return fluree.db.session.current_db.call(null,session,blank_db);
}));

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2 = (function (p__27481,blank_db){
var map__27482 = p__27481;
var map__27482__$1 = cljs.core.__destructure_map.call(null,map__27482);
var session = map__27482__$1;
var conn = cljs.core.get.call(null,map__27482__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var state = cljs.core.get.call(null,map__27482__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
cljs.core.swap_BANG_.call(null,state,(function (s){
return cljs.core.update.call(null,cljs.core.assoc.call(null,s,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis.call(null)),new cljs.core.Keyword("req","count","req/count",2145574363),cljs.core.inc);
}));

var or__5045__auto__ = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,state));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var cur_ch = cljs.core.async.promise_chan.call(null);
var state_ch = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.call(null,state,(function (s){
if(cljs.core.not.call(null,new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(s))){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","current","db/current",-1088041545),cur_ch);
} else {
return s;
}
})));
if(cljs.core._EQ_.call(null,cur_ch,state_ch)){
var c__2768__auto___27520 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27502){
var state_val_27503 = (state_27502[(1)]);
if((state_val_27503 === (1))){
var state_27502__$1 = state_27502;
var statearr_27504_27521 = state_27502__$1;
(statearr_27504_27521[(2)] = null);

(statearr_27504_27521[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27503 === (2))){
var _ = (function (){var statearr_27505 = state_27502;
(statearr_27505[(4)] = cljs.core.cons.call(null,(5),(state_27502[(4)])));

return statearr_27505;
})();
var inst_27492 = fluree.db.session.load_current_db.call(null,conn,blank_db);
var state_27502__$1 = state_27502;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27502__$1,(6),inst_27492);
} else {
if((state_val_27503 === (3))){
var inst_27500 = (state_27502[(2)]);
var state_27502__$1 = state_27502;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27502__$1,inst_27500);
} else {
if((state_val_27503 === (4))){
var inst_27483 = (state_27502[(2)]);
var inst_27484 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
var inst_27485 = fluree.db.util.log.error.call(null,inst_27483,"Error loading current db");
var inst_27486 = cljs.core.async.put_BANG_.call(null,cur_ch,inst_27483);
var state_27502__$1 = (function (){var statearr_27507 = state_27502;
(statearr_27507[(7)] = inst_27485);

(statearr_27507[(8)] = inst_27484);

return statearr_27507;
})();
var statearr_27508_27522 = state_27502__$1;
(statearr_27508_27522[(2)] = inst_27486);

(statearr_27508_27522[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27503 === (5))){
var _ = (function (){var statearr_27509 = state_27502;
(statearr_27509[(4)] = cljs.core.rest.call(null,(state_27502[(4)])));

return statearr_27509;
})();
var state_27502__$1 = state_27502;
var ex27506 = (state_27502__$1[(2)]);
var statearr_27510_27523 = state_27502__$1;
(statearr_27510_27523[(5)] = ex27506);


var statearr_27511_27524 = state_27502__$1;
(statearr_27511_27524[(1)] = (4));

(statearr_27511_27524[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27503 === (6))){
var inst_27494 = (state_27502[(2)]);
var inst_27495 = fluree.db.util.async.throw_err.call(null,inst_27494);
var state_27502__$1 = state_27502;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27502__$1,(7),cur_ch,inst_27495);
} else {
if((state_val_27503 === (7))){
var inst_27497 = (state_27502[(2)]);
var _ = (function (){var statearr_27512 = state_27502;
(statearr_27512[(4)] = cljs.core.rest.call(null,(state_27502[(4)])));

return statearr_27512;
})();
var state_27502__$1 = state_27502;
var statearr_27513_27525 = state_27502__$1;
(statearr_27513_27525[(2)] = inst_27497);

(statearr_27513_27525[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2746__auto__ = null;
var fluree$db$session$state_machine__2746__auto____0 = (function (){
var statearr_27514 = [null,null,null,null,null,null,null,null,null];
(statearr_27514[(0)] = fluree$db$session$state_machine__2746__auto__);

(statearr_27514[(1)] = (1));

return statearr_27514;
});
var fluree$db$session$state_machine__2746__auto____1 = (function (state_27502){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27502);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27515){var ex__2749__auto__ = e27515;
var statearr_27516_27526 = state_27502;
(statearr_27516_27526[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27502[(4)]))){
var statearr_27517_27527 = state_27502;
(statearr_27517_27527[(1)] = cljs.core.first.call(null,(state_27502[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27528 = state_27502;
state_27502 = G__27528;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$state_machine__2746__auto__ = function(state_27502){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2746__auto____1.call(this,state_27502);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2746__auto____0;
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2746__auto____1;
return fluree$db$session$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27518 = f__2769__auto__.call(null);
(statearr_27518[(6)] = c__2768__auto___27520);

return statearr_27518;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return cur_ch;
} else {
return state_ch;
}
}
}));

(fluree.db.session.current_db.cljs$lang$maxFixedArity = 2);

/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_promise_ch = (function fluree$db$session$indexing_promise_ch(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock. Returns two-tuple of [lock? promise-chan]
 *   where lock? indicates if the lock was successful, and promise-chan is whatever
 *   promise-chan is registered for indexing.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,pc){
var swap_res = cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),pc);
} else {
return s;
}
}));
var res_pc = new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(swap_res);
var lock_QMARK_ = cljs.core._EQ_.call(null,pc,res_pc);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lock_QMARK_,res_pc], null);
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword("db","indexed","db/indexed",390759770),block);
}));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.call(null,cljs.cache.lru_cache_factory.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__5045__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var ledger_id = alias;
cljs.core.swap_BANG_.call(null,fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),ledger_id);

return ledger_id;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger named testledger on network testnet.
 *   - [testnet testledger] - already in form of [network ledger-id]
 * 
 *   The two-arity version of this exists for backwards compatibility. It doesn't do anything with the
 *   conn arg so there is also a single-arity version that just takes the ledger name.
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(var_args){
var G__27530 = arguments.length;
switch (G__27530) {
case 1:
return fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$1 = (function (ledger){
return fluree.db.session.resolve_ledger.call(null,null,ledger);
}));

(fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$2 = (function (_conn,ledger){
if(cljs.core.sequential_QMARK_.call(null,ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.call(null,ledger);
var network = cljs.core.namespace.call(null,ledger__$1);
var ledger_id = cljs.core.name.call(null,ledger__$1);
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return ledger_id;
} else {
return and__5043__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.pr_str.call(null,ledger__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null);
}
}));

(fluree.db.session.resolve_ledger.cljs$lang$maxFixedArity = 2);

if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__5642__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27533){
var state_val_27534 = (state_27533[(1)]);
if((state_val_27534 === (1))){
var state_27533__$1 = state_27533;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27533__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2746__auto__ = null;
var fluree$db$session$state_machine__2746__auto____0 = (function (){
var statearr_27535 = [null,null,null,null,null,null,null];
(statearr_27535[(0)] = fluree$db$session$state_machine__2746__auto__);

(statearr_27535[(1)] = (1));

return statearr_27535;
});
var fluree$db$session$state_machine__2746__auto____1 = (function (state_27533){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27533);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27536){var ex__2749__auto__ = e27536;
var statearr_27537_27540 = state_27533;
(statearr_27537_27540[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27533[(4)]))){
var statearr_27538_27541 = state_27533;
(statearr_27538_27541[(1)] = cljs.core.first.call(null,(state_27533[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27542 = state_27533;
state_27533 = G__27542;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$state_machine__2746__auto__ = function(state_27533){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2746__auto____1.call(this,state_27533);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2746__auto____0;
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2746__auto____1;
return fluree$db$session$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27539 = f__2769__auto__.call(null);
(statearr_27539[(6)] = c__2768__auto__);

return statearr_27539;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__27543){
var map__27544 = p__27543;
var map__27544__$1 = cljs.core.__destructure_map.call(null,map__27544);
var data = map__27544__$1;
var block = cljs.core.get.call(null,map__27544__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__27544__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__27544__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27603){
var state_val_27604 = (state_27603[(1)]);
if((state_val_27604 === (7))){
var inst_27555 = (state_27603[(7)]);
var inst_27558 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27559 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27560 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27558),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27559),": Received block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current at block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27555),". No-op."].join('');
var inst_27561 = fluree.db.util.log.info.call(null,inst_27560);
var state_27603__$1 = state_27603;
var statearr_27605_27639 = state_27603__$1;
(statearr_27605_27639[(2)] = inst_27561);

(statearr_27605_27639[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27604 === (1))){
var state_27603__$1 = state_27603;
var statearr_27606_27640 = state_27603__$1;
(statearr_27606_27640[(2)] = null);

(statearr_27606_27640[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27604 === (4))){
var inst_27545 = (state_27603[(2)]);
var state_27603__$1 = state_27603;
var statearr_27607_27641 = state_27603__$1;
(statearr_27607_27641[(2)] = inst_27545);

(statearr_27607_27641[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27604 === (15))){
var inst_27584 = (state_27603[(2)]);
var state_27603__$1 = state_27603;
var statearr_27608_27642 = state_27603__$1;
(statearr_27608_27642[(2)] = inst_27584);

(statearr_27608_27642[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27604 === (13))){
var inst_27575 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_27576 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27577 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27578 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27579 = [inst_27577,inst_27578];
var inst_27580 = (new cljs.core.PersistentVector(null,2,(5),inst_27576,inst_27579,null));
var inst_27581 = fluree.db.conn_events.process_event.call(null,inst_27575,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),inst_27580,data);
var state_27603__$1 = state_27603;
var statearr_27609_27643 = state_27603__$1;
(statearr_27609_27643[(2)] = inst_27581);

(statearr_27609_27643[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27604 === (6))){
var inst_27555 = (state_27603[(7)]);
var inst_27554 = (state_27603[(8)]);
var inst_27553 = (state_27603[(2)]);
var inst_27554__$1 = fluree.db.util.async.throw_err.call(null,inst_27553);
var inst_27555__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27554__$1);
var inst_27556 = (block <= inst_27555__$1);
var state_27603__$1 = (function (){var statearr_27610 = state_27603;
(statearr_27610[(7)] = inst_27555__$1);

(statearr_27610[(8)] = inst_27554__$1);

return statearr_27610;
})();
if(cljs.core.truth_(inst_27556)){
var statearr_27611_27644 = state_27603__$1;
(statearr_27611_27644[(1)] = (7));

} else {
var statearr_27612_27645 = state_27603__$1;
(statearr_27612_27645[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27604 === (17))){
var state_27603__$1 = state_27603;
var statearr_27613_27646 = state_27603__$1;
(statearr_27613_27646[(2)] = null);

(statearr_27613_27646[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27604 === (3))){
var inst_27601 = (state_27603[(2)]);
var state_27603__$1 = state_27603;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27603__$1,inst_27601);
} else {
if((state_val_27604 === (12))){
var inst_27596 = (state_27603[(2)]);
var state_27603__$1 = state_27603;
var statearr_27614_27647 = state_27603__$1;
(statearr_27614_27647[(2)] = inst_27596);

(statearr_27614_27647[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27604 === (2))){
var inst_27551 = (state_27603[(9)]);
var _ = (function (){var statearr_27615 = state_27603;
(statearr_27615[(4)] = cljs.core.cons.call(null,(5),(state_27603[(4)])));

return statearr_27615;
})();
var inst_27551__$1 = fluree.db.session.current_db.call(null,session);
var state_27603__$1 = (function (){var statearr_27616 = state_27603;
(statearr_27616[(9)] = inst_27551__$1);

return statearr_27616;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27603__$1,(6),inst_27551__$1);
} else {
if((state_val_27604 === (11))){
var state_27603__$1 = state_27603;
var statearr_27618_27648 = state_27603__$1;
(statearr_27618_27648[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27604 === (9))){
var inst_27598 = (state_27603[(2)]);
var _ = (function (){var statearr_27620 = state_27603;
(statearr_27620[(4)] = cljs.core.rest.call(null,(state_27603[(4)])));

return statearr_27620;
})();
var state_27603__$1 = state_27603;
var statearr_27621_27649 = state_27603__$1;
(statearr_27621_27649[(2)] = inst_27598);

(statearr_27621_27649[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27604 === (5))){
var _ = (function (){var statearr_27622 = state_27603;
(statearr_27622[(4)] = cljs.core.rest.call(null,(state_27603[(4)])));

return statearr_27622;
})();
var state_27603__$1 = state_27603;
var ex27617 = (state_27603__$1[(2)]);
var statearr_27623_27650 = state_27603__$1;
(statearr_27623_27650[(5)] = ex27617);


if((ex27617 instanceof Error)){
var statearr_27624_27651 = state_27603__$1;
(statearr_27624_27651[(1)] = (4));

(statearr_27624_27651[(5)] = null);

} else {
throw ex27617;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27604 === (14))){
var state_27603__$1 = state_27603;
var statearr_27625_27652 = state_27603__$1;
(statearr_27625_27652[(2)] = null);

(statearr_27625_27652[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27604 === (16))){
var inst_27555 = (state_27603[(7)]);
var inst_27587 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27588 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27589 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27587),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27588),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27555),". Forcing a db reload."].join('');
var inst_27590 = fluree.db.util.log.info.call(null,inst_27589);
var inst_27591 = fluree.db.session.reload_db_BANG_.call(null,session);
var state_27603__$1 = (function (){var statearr_27626 = state_27603;
(statearr_27626[(10)] = inst_27590);

return statearr_27626;
})();
var statearr_27627_27653 = state_27603__$1;
(statearr_27627_27653[(2)] = inst_27591);

(statearr_27627_27653[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27604 === (10))){
var inst_27551 = (state_27603[(9)]);
var inst_27555 = (state_27603[(7)]);
var inst_27554 = (state_27603[(8)]);
var inst_27566 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27567 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27568 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27566),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27567),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_27569 = fluree.db.util.log.trace.call(null,inst_27568);
var inst_27570 = (function (){var current_db_ch = inst_27551;
var current_db = inst_27554;
var current_block = inst_27555;
return (function (f){
if((f instanceof fluree.db.flake.Flake)){
return f;
} else {
return fluree.db.flake.parts__GT_Flake.call(null,f);
}
});
})();
var inst_27571 = cljs.core.map.call(null,inst_27570,flakes);
var inst_27572 = fluree.db.dbproto._with.call(null,inst_27554,block,inst_27571);
var inst_27573 = fluree.db.session.cas_db_BANG_.call(null,session,inst_27551,inst_27572);
var state_27603__$1 = (function (){var statearr_27628 = state_27603;
(statearr_27628[(11)] = inst_27569);

return statearr_27628;
})();
if(inst_27573){
var statearr_27629_27654 = state_27603__$1;
(statearr_27629_27654[(1)] = (13));

} else {
var statearr_27630_27655 = state_27603__$1;
(statearr_27630_27655[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27604 === (18))){
var inst_27594 = (state_27603[(2)]);
var state_27603__$1 = state_27603;
var statearr_27631_27656 = state_27603__$1;
(statearr_27631_27656[(2)] = inst_27594);

(statearr_27631_27656[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27604 === (8))){
var inst_27555 = (state_27603[(7)]);
var inst_27563 = ((1) + inst_27555);
var inst_27564 = cljs.core._EQ_.call(null,block,inst_27563);
var state_27603__$1 = state_27603;
if(inst_27564){
var statearr_27632_27657 = state_27603__$1;
(statearr_27632_27657[(1)] = (10));

} else {
var statearr_27633_27658 = state_27603__$1;
(statearr_27633_27658[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2746__auto__ = null;
var fluree$db$session$state_machine__2746__auto____0 = (function (){
var statearr_27634 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27634[(0)] = fluree$db$session$state_machine__2746__auto__);

(statearr_27634[(1)] = (1));

return statearr_27634;
});
var fluree$db$session$state_machine__2746__auto____1 = (function (state_27603){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27603);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27635){var ex__2749__auto__ = e27635;
var statearr_27636_27659 = state_27603;
(statearr_27636_27659[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27603[(4)]))){
var statearr_27637_27660 = state_27603;
(statearr_27637_27660[(1)] = cljs.core.first.call(null,(state_27603[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27661 = state_27603;
state_27603 = G__27661;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$state_machine__2746__auto__ = function(state_27603){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2746__auto____1.call(this,state_27603);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2746__auto____0;
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2746__auto____1;
return fluree$db$session$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27638 = f__2769__auto__.call(null);
(statearr_27638[(6)] = c__2768__auto__);

return statearr_27638;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27668){
var state_val_27669 = (state_27668[(1)]);
if((state_val_27669 === (1))){
var inst_27662 = fluree.db.session.clear_db_BANG_.call(null,session);
var inst_27663 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27664 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27665 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27663),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27664)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_27666 = fluree.db.util.log.debug.call(null,inst_27665);
var state_27668__$1 = (function (){var statearr_27670 = state_27668;
(statearr_27670[(7)] = inst_27662);

(statearr_27670[(8)] = inst_27666);

return statearr_27670;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27668__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2746__auto__ = null;
var fluree$db$session$state_machine__2746__auto____0 = (function (){
var statearr_27671 = [null,null,null,null,null,null,null,null,null];
(statearr_27671[(0)] = fluree$db$session$state_machine__2746__auto__);

(statearr_27671[(1)] = (1));

return statearr_27671;
});
var fluree$db$session$state_machine__2746__auto____1 = (function (state_27668){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27668);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27672){var ex__2749__auto__ = e27672;
var statearr_27673_27676 = state_27668;
(statearr_27673_27676[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27668[(4)]))){
var statearr_27674_27677 = state_27668;
(statearr_27674_27677[(1)] = cljs.core.first.call(null,(state_27668[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27678 = state_27668;
state_27668 = G__27678;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$state_machine__2746__auto__ = function(state_27668){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2746__auto____1.call(this,state_27668);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2746__auto____0;
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2746__auto____1;
return fluree$db$session$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27675 = f__2769__auto__.call(null);
(statearr_27675[(6)] = c__2768__auto__);

return statearr_27675;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + ledger-id will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__27680 = arguments.length;
switch (G__27680) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (p__27681){
var map__27682 = p__27681;
var map__27682__$1 = cljs.core.__destructure_map.call(null,map__27682);
var session = map__27682__$1;
var conn = cljs.core.get.call(null,map__27682__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.call(null,map__27682__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.call(null,map__27682__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.call(null,map__27682__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.call(null,map__27682__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__27682__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var id = cljs.core.get.call(null,map__27682__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.truth_(fluree.db.session.closed_QMARK_.call(null,session))){
fluree.db.session.remove_cache_BANG_.call(null,network,ledger_id);

return false;
} else {
cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,ledger_id,id);

cljs.core.async.close_BANG_.call(null,update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_.call(null,transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_.call(null,network,ledger_id);

if(cljs.core.fn_QMARK_.call(null,new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session).call(null);
} else {
}

return true;
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,ledger_id){
var temp__5802__auto__ = fluree.db.session.from_cache.call(null,network,ledger_id);
if(cljs.core.truth_(temp__5802__auto__)){
var session = temp__5802__auto__;
return fluree.db.session.close.call(null,session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27735){
var state_val_27736 = (state_27735[(1)]);
if((state_val_27736 === (7))){
var inst_27731 = (state_27735[(2)]);
var state_27735__$1 = state_27735;
var statearr_27737_27768 = state_27735__$1;
(statearr_27737_27768[(2)] = inst_27731);

(statearr_27737_27768[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27736 === (1))){
var state_27735__$1 = state_27735;
var statearr_27738_27769 = state_27735__$1;
(statearr_27738_27769[(2)] = null);

(statearr_27738_27769[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27736 === (4))){
var inst_27687 = (state_27735[(7)]);
var inst_27686 = (state_27735[(2)]);
var inst_27687__$1 = fluree.db.util.async.throw_err.call(null,inst_27686);
var inst_27688 = fluree.db.session.from_cache.call(null,network,ledger_id);
var inst_27689 = (inst_27687__$1 == null);
var state_27735__$1 = (function (){var statearr_27739 = state_27735;
(statearr_27739[(8)] = inst_27688);

(statearr_27739[(7)] = inst_27687__$1);

return statearr_27739;
})();
if(cljs.core.truth_(inst_27689)){
var statearr_27740_27770 = state_27735__$1;
(statearr_27740_27770[(1)] = (5));

} else {
var statearr_27741_27771 = state_27735__$1;
(statearr_27741_27771[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27736 === (15))){
var inst_27723 = (state_27735[(2)]);
var state_27735__$1 = (function (){var statearr_27742 = state_27735;
(statearr_27742[(9)] = inst_27723);

return statearr_27742;
})();
var statearr_27743_27772 = state_27735__$1;
(statearr_27743_27772[(2)] = null);

(statearr_27743_27772[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27736 === (13))){
var inst_27727 = (state_27735[(2)]);
var state_27735__$1 = state_27735;
var statearr_27745_27773 = state_27735__$1;
(statearr_27745_27773[(2)] = inst_27727);

(statearr_27745_27773[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27736 === (6))){
var inst_27688 = (state_27735[(8)]);
var inst_27694 = (inst_27688 == null);
var state_27735__$1 = state_27735;
if(cljs.core.truth_(inst_27694)){
var statearr_27746_27774 = state_27735__$1;
(statearr_27746_27774[(1)] = (8));

} else {
var statearr_27747_27775 = state_27735__$1;
(statearr_27747_27775[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27736 === (17))){
var _ = (function (){var statearr_27748 = state_27735;
(statearr_27748[(4)] = cljs.core.rest.call(null,(state_27735[(4)])));

return statearr_27748;
})();
var state_27735__$1 = state_27735;
var ex27744 = (state_27735__$1[(2)]);
var statearr_27749_27776 = state_27735__$1;
(statearr_27749_27776[(5)] = ex27744);


var statearr_27750_27777 = state_27735__$1;
(statearr_27750_27777[(1)] = (16));

(statearr_27750_27777[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27736 === (3))){
var inst_27733 = (state_27735[(2)]);
var state_27735__$1 = state_27735;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27735__$1,inst_27733);
} else {
if((state_val_27736 === (12))){
var state_27735__$1 = state_27735;
var statearr_27751_27778 = state_27735__$1;
(statearr_27751_27778[(2)] = null);

(statearr_27751_27778[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27736 === (2))){
var state_27735__$1 = state_27735;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27735__$1,(4),update_chan);
} else {
if((state_val_27736 === (11))){
var state_27735__$1 = state_27735;
var statearr_27752_27779 = state_27735__$1;
(statearr_27752_27779[(2)] = null);

(statearr_27752_27779[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27736 === (9))){
var state_27735__$1 = state_27735;
var statearr_27753_27780 = state_27735__$1;
(statearr_27753_27780[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27736 === (5))){
var inst_27691 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_27692 = fluree.db.util.log.info.call(null,"Channel closed for session updates for:",inst_27691);
var state_27735__$1 = state_27735;
var statearr_27755_27781 = state_27735__$1;
(statearr_27755_27781[(2)] = inst_27692);

(statearr_27755_27781[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27736 === (14))){
var inst_27688 = (state_27735[(8)]);
var inst_27687 = (state_27735[(7)]);
var _ = (function (){var statearr_27756 = state_27735;
(statearr_27756[(4)] = cljs.core.cons.call(null,(17),(state_27735[(4)])));

return statearr_27756;
})();
var inst_27711 = cljs.core.nth.call(null,inst_27687,(0),null);
var inst_27712 = cljs.core.nth.call(null,inst_27687,(1),null);
var inst_27713 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_27714 = cljs.core.pr_str.call(null,inst_27687);
var inst_27715 = fluree.db.util.core.trunc.call(null,inst_27714,(200));
var inst_27716 = fluree.db.util.log.trace.call(null,inst_27713,inst_27715);
var inst_27717 = fluree.db.session.process_ledger_update.call(null,inst_27688,inst_27711,inst_27712);
var state_27735__$1 = (function (){var statearr_27757 = state_27735;
(statearr_27757[(10)] = inst_27716);

return statearr_27757;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27735__$1,(18),inst_27717);
} else {
if((state_val_27736 === (16))){
var inst_27687 = (state_27735[(7)]);
var inst_27701 = (state_27735[(2)]);
var inst_27702 = fluree.db.util.log.error.call(null,inst_27701,"Exception processing ledger updates for message: ",inst_27687);
var state_27735__$1 = state_27735;
var statearr_27758_27782 = state_27735__$1;
(statearr_27758_27782[(2)] = inst_27702);

(statearr_27758_27782[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27736 === (10))){
var inst_27729 = (state_27735[(2)]);
var state_27735__$1 = state_27735;
var statearr_27759_27783 = state_27735__$1;
(statearr_27759_27783[(2)] = inst_27729);

(statearr_27759_27783[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27736 === (18))){
var inst_27719 = (state_27735[(2)]);
var inst_27720 = fluree.db.util.async.throw_err.call(null,inst_27719);
var _ = (function (){var statearr_27760 = state_27735;
(statearr_27760[(4)] = cljs.core.rest.call(null,(state_27735[(4)])));

return statearr_27760;
})();
var state_27735__$1 = state_27735;
var statearr_27761_27784 = state_27735__$1;
(statearr_27761_27784[(2)] = inst_27720);

(statearr_27761_27784[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27736 === (8))){
var inst_27687 = (state_27735[(7)]);
var inst_27696 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_27697 = cljs.core.first.call(null,inst_27687);
var inst_27698 = fluree.db.util.log.warn.call(null,"Ledger update received for session that is no longer open:",inst_27696,"Message: ",inst_27697);
var state_27735__$1 = state_27735;
var statearr_27762_27785 = state_27735__$1;
(statearr_27762_27785[(2)] = inst_27698);

(statearr_27762_27785[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____0 = (function (){
var statearr_27763 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27763[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__);

(statearr_27763[(1)] = (1));

return statearr_27763;
});
var fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____1 = (function (state_27735){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27735);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27764){var ex__2749__auto__ = e27764;
var statearr_27765_27786 = state_27735;
(statearr_27765_27786[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27735[(4)]))){
var statearr_27766_27787 = state_27735;
(statearr_27766_27787[(1)] = cljs.core.first.call(null,(state_27735[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27788 = state_27735;
state_27735 = G__27788;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__ = function(state_27735){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____1.call(this,state_27735);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27767 = f__2769__auto__.call(null);
(statearr_27767[(6)] = c__2768__auto__);

return statearr_27767;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Creates a connection without first checking if one already exists. Only useful
 *   if reloading and replacing an existing session.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__27789){
var map__27790 = p__27789;
var map__27790__$1 = cljs.core.__destructure_map.call(null,map__27790);
var network = cljs.core.get.call(null,map__27790__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__27790__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var db = cljs.core.get.call(null,map__27790__$1,new cljs.core.Keyword(null,"db","db",993250759));
var ledger_id = cljs.core.get.call(null,map__27790__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var transactor_QMARK_ = cljs.core.get.call(null,map__27790__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.call(null,map__27790__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.call(null,map__27790__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.call(null,map__27790__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.call(null,map__27790__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cur_db = (cljs.core.truth_(db)?cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null);
var state__$1 = cljs.core.atom.call(null,cljs.core.merge.call(null,state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","current","db/current",-1088041545),cur_db,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)));
var session = fluree.db.session.map__GT_DbSession.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[ledger_id,cljs.core.async.chan.call(null),db_name,state__$1,close,id,schema_cache,(cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.call(null):null),network,null,conn]));
var current_db_fn = cljs.core.partial.call(null,fluree.db.session.current_db,session);
var blank_db = fluree.db.graphdb.blank_db.call(null,conn,network,ledger_id,schema_cache,current_db_fn);
return cljs.core.assoc.call(null,session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__27794 = block_result;
var map__27794__$1 = cljs.core.__destructure_map.call(null,map__27794);
var block = cljs.core.get.call(null,map__27794__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.call(null,map__27794__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.call(null,map__27794__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.call(null,map__27794__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.call(null,map__27794__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__5045__auto__ = cljs.core.get.call(null,txns,cljs.core.keyword.call(null,txid));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.call(null,txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.call(null,["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.call(null,block_result)], null))})());
var map__27795 = tx_result;
var map__27795__$1 = cljs.core.__destructure_map.call(null,map__27795);
var t = cljs.core.get.call(null,map__27795__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.call(null,map__27795__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first.call(null,flakes) instanceof fluree.db.flake.Flake))?(function (p1__27791_SHARP_){
return cljs.core._EQ_.call(null,t,fluree.db.flake.t.call(null,p1__27791_SHARP_));
}):(function (p1__27792_SHARP_){
return cljs.core._EQ_.call(null,t,cljs.core.nth.call(null,p1__27792_SHARP_,(3)));
}));
var response = cljs.core.assoc.call(null,tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.call(null,t_filter,flakes));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some.call(null,(function (p1__27793_SHARP_){
if(cljs.core._EQ_.call(null,(109),cljs.core.second.call(null,p1__27793_SHARP_))){
return cljs.core.nth.call(null,p1__27793_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__27796 = (cljs.core.truth_(error_msg)?cljs.core.re_find.call(null,/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.call(null,vec__27796,(0),null);
var status__$1 = cljs.core.nth.call(null,vec__27796,(1),null);
var error = cljs.core.nth.call(null,vec__27796,(2),null);
var message = cljs.core.nth.call(null,vec__27796,(3),null);
return cljs.core.ex_info.call(null,(function (){var or__5045__auto__ = message;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.call(null,error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
fluree.db.util.log.trace.call(null,"Create and cache session. Opt keys: ",cljs.core.keys.call(null,opts));

var id = cljs.core.keyword.call(null,"session",cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid.call(null)),(0),(7)));
var session = fluree.db.session.session_factory.call(null,cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_.call(null,session);
var new_QMARK_ = cljs.core._EQ_.call(null,id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.call(null,session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__27800 = arguments.length;
switch (G__27800) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.call(null,conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__27801){
var map__27802 = p__27801;
var map__27802__$1 = cljs.core.__destructure_map.call(null,map__27802);
var state = cljs.core.get.call(null,map__27802__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.call(null,map__27802__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.call(null,map__27802__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__27802__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__27803 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__27803,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__27803,(1),null);
var ledger_alias = cljs.core.nth.call(null,vec__27803,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__5045__auto__ = fluree.db.session.from_cache.call(null,network,ledger_id);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var session = fluree.db.session.create_and_cache_session.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__5045__auto____$1 = state;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.call(null,session,opts);

new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,ledger_id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session),(function (event_type,event_data){
cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5804__auto__ = cljs.core.not_empty.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5804__auto__)){
var tx_callbacks = temp__5804__auto__;
var tids = cljs.core.keys.call(null,new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__27806 = cljs.core.seq.call(null,tids);
var chunk__27807 = null;
var count__27808 = (0);
var i__27809 = (0);
while(true){
if((i__27809 < count__27808)){
var tid = cljs.core._nth.call(null,chunk__27807,i__27809);
var temp__5804__auto___27922__$1 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5804__auto___27922__$1)){
var keyed_callbacks_27923 = temp__5804__auto___27922__$1;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_27924 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__27850_27925 = cljs.core.seq.call(null,keyed_callbacks_27923);
var chunk__27851_27926 = null;
var count__27852_27927 = (0);
var i__27853_27928 = (0);
while(true){
if((i__27853_27928 < count__27852_27927)){
var vec__27862_27929 = cljs.core._nth.call(null,chunk__27851_27926,i__27853_27928);
var k_27930 = cljs.core.nth.call(null,vec__27862_27929,(0),null);
var f_27931 = cljs.core.nth.call(null,vec__27862_27929,(1),null);
try{f_27931.call(null,tx_response_27924);
}catch (e27865){var e_27932 = e27865;
fluree.db.util.log.error.call(null,e_27932,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__27933 = seq__27850_27925;
var G__27934 = chunk__27851_27926;
var G__27935 = count__27852_27927;
var G__27936 = (i__27853_27928 + (1));
seq__27850_27925 = G__27933;
chunk__27851_27926 = G__27934;
count__27852_27927 = G__27935;
i__27853_27928 = G__27936;
continue;
} else {
var temp__5804__auto___27937__$2 = cljs.core.seq.call(null,seq__27850_27925);
if(temp__5804__auto___27937__$2){
var seq__27850_27938__$1 = temp__5804__auto___27937__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27850_27938__$1)){
var c__5568__auto___27939 = cljs.core.chunk_first.call(null,seq__27850_27938__$1);
var G__27940 = cljs.core.chunk_rest.call(null,seq__27850_27938__$1);
var G__27941 = c__5568__auto___27939;
var G__27942 = cljs.core.count.call(null,c__5568__auto___27939);
var G__27943 = (0);
seq__27850_27925 = G__27940;
chunk__27851_27926 = G__27941;
count__27852_27927 = G__27942;
i__27853_27928 = G__27943;
continue;
} else {
var vec__27866_27944 = cljs.core.first.call(null,seq__27850_27938__$1);
var k_27945 = cljs.core.nth.call(null,vec__27866_27944,(0),null);
var f_27946 = cljs.core.nth.call(null,vec__27866_27944,(1),null);
try{f_27946.call(null,tx_response_27924);
}catch (e27869){var e_27947 = e27869;
fluree.db.util.log.error.call(null,e_27947,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__27948 = cljs.core.next.call(null,seq__27850_27938__$1);
var G__27949 = null;
var G__27950 = (0);
var G__27951 = (0);
seq__27850_27925 = G__27948;
chunk__27851_27926 = G__27949;
count__27852_27927 = G__27950;
i__27853_27928 = G__27951;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__27952 = seq__27806;
var G__27953 = chunk__27807;
var G__27954 = count__27808;
var G__27955 = (i__27809 + (1));
seq__27806 = G__27952;
chunk__27807 = G__27953;
count__27808 = G__27954;
i__27809 = G__27955;
continue;
} else {
var temp__5804__auto____$1 = cljs.core.seq.call(null,seq__27806);
if(temp__5804__auto____$1){
var seq__27806__$1 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27806__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__27806__$1);
var G__27956 = cljs.core.chunk_rest.call(null,seq__27806__$1);
var G__27957 = c__5568__auto__;
var G__27958 = cljs.core.count.call(null,c__5568__auto__);
var G__27959 = (0);
seq__27806 = G__27956;
chunk__27807 = G__27957;
count__27808 = G__27958;
i__27809 = G__27959;
continue;
} else {
var tid = cljs.core.first.call(null,seq__27806__$1);
var temp__5804__auto___27960__$2 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5804__auto___27960__$2)){
var keyed_callbacks_27961 = temp__5804__auto___27960__$2;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_27962 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__27870_27963 = cljs.core.seq.call(null,keyed_callbacks_27961);
var chunk__27871_27964 = null;
var count__27872_27965 = (0);
var i__27873_27966 = (0);
while(true){
if((i__27873_27966 < count__27872_27965)){
var vec__27882_27967 = cljs.core._nth.call(null,chunk__27871_27964,i__27873_27966);
var k_27968 = cljs.core.nth.call(null,vec__27882_27967,(0),null);
var f_27969 = cljs.core.nth.call(null,vec__27882_27967,(1),null);
try{f_27969.call(null,tx_response_27962);
}catch (e27885){var e_27970 = e27885;
fluree.db.util.log.error.call(null,e_27970,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__27971 = seq__27870_27963;
var G__27972 = chunk__27871_27964;
var G__27973 = count__27872_27965;
var G__27974 = (i__27873_27966 + (1));
seq__27870_27963 = G__27971;
chunk__27871_27964 = G__27972;
count__27872_27965 = G__27973;
i__27873_27966 = G__27974;
continue;
} else {
var temp__5804__auto___27975__$3 = cljs.core.seq.call(null,seq__27870_27963);
if(temp__5804__auto___27975__$3){
var seq__27870_27976__$1 = temp__5804__auto___27975__$3;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27870_27976__$1)){
var c__5568__auto___27977 = cljs.core.chunk_first.call(null,seq__27870_27976__$1);
var G__27978 = cljs.core.chunk_rest.call(null,seq__27870_27976__$1);
var G__27979 = c__5568__auto___27977;
var G__27980 = cljs.core.count.call(null,c__5568__auto___27977);
var G__27981 = (0);
seq__27870_27963 = G__27978;
chunk__27871_27964 = G__27979;
count__27872_27965 = G__27980;
i__27873_27966 = G__27981;
continue;
} else {
var vec__27886_27982 = cljs.core.first.call(null,seq__27870_27976__$1);
var k_27983 = cljs.core.nth.call(null,vec__27886_27982,(0),null);
var f_27984 = cljs.core.nth.call(null,vec__27886_27982,(1),null);
try{f_27984.call(null,tx_response_27962);
}catch (e27889){var e_27985 = e27889;
fluree.db.util.log.error.call(null,e_27985,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__27986 = cljs.core.next.call(null,seq__27870_27976__$1);
var G__27987 = null;
var G__27988 = (0);
var G__27989 = (0);
seq__27870_27963 = G__27986;
chunk__27871_27964 = G__27987;
count__27872_27965 = G__27988;
i__27873_27966 = G__27989;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__27990 = cljs.core.next.call(null,seq__27806__$1);
var G__27991 = null;
var G__27992 = (0);
var G__27993 = (0);
seq__27806 = G__27990;
chunk__27807 = G__27991;
count__27808 = G__27992;
i__27809 = G__27993;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}));

fluree.db.session.process_ledger_updates.call(null,conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_27994 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__2768__auto___27995 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27906){
var state_val_27907 = (state_27906[(1)]);
if((state_val_27907 === (1))){
var state_27906__$1 = state_27906;
var statearr_27908_27996 = state_27906__$1;
(statearr_27908_27996[(2)] = null);

(statearr_27908_27996[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27907 === (2))){
var inst_27891 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_27906__$1 = state_27906;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27906__$1,(4),inst_27891);
} else {
if((state_val_27907 === (3))){
var inst_27904 = (state_27906[(2)]);
var state_27906__$1 = state_27906;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27906__$1,inst_27904);
} else {
if((state_val_27907 === (4))){
var inst_27893 = (state_27906[(7)]);
var inst_27893__$1 = (state_27906[(2)]);
var inst_27894 = (inst_27893__$1 == null);
var state_27906__$1 = (function (){var statearr_27909 = state_27906;
(statearr_27909[(7)] = inst_27893__$1);

return statearr_27909;
})();
if(cljs.core.truth_(inst_27894)){
var statearr_27910_27997 = state_27906__$1;
(statearr_27910_27997[(1)] = (5));

} else {
var statearr_27911_27998 = state_27906__$1;
(statearr_27911_27998[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27907 === (5))){
var inst_27896 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_27897 = fluree.db.util.log.info.call(null,"Transactor session closing for db:",inst_27896);
var state_27906__$1 = state_27906;
var statearr_27912_27999 = state_27906__$1;
(statearr_27912_27999[(2)] = inst_27897);

(statearr_27912_27999[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27907 === (6))){
var inst_27893 = (state_27906[(7)]);
var inst_27899 = transact_handler_27994.call(null,conn,inst_27893);
var state_27906__$1 = (function (){var statearr_27913 = state_27906;
(statearr_27913[(8)] = inst_27899);

return statearr_27913;
})();
var statearr_27914_28000 = state_27906__$1;
(statearr_27914_28000[(2)] = null);

(statearr_27914_28000[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27907 === (7))){
var inst_27902 = (state_27906[(2)]);
var state_27906__$1 = state_27906;
var statearr_27915_28001 = state_27906__$1;
(statearr_27915_28001[(2)] = inst_27902);

(statearr_27915_28001[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2746__auto__ = null;
var fluree$db$session$state_machine__2746__auto____0 = (function (){
var statearr_27916 = [null,null,null,null,null,null,null,null,null];
(statearr_27916[(0)] = fluree$db$session$state_machine__2746__auto__);

(statearr_27916[(1)] = (1));

return statearr_27916;
});
var fluree$db$session$state_machine__2746__auto____1 = (function (state_27906){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27906);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27917){var ex__2749__auto__ = e27917;
var statearr_27918_28002 = state_27906;
(statearr_27918_28002[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27906[(4)]))){
var statearr_27919_28003 = state_27906;
(statearr_27919_28003[(1)] = cljs.core.first.call(null,(state_27906[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28004 = state_27906;
state_27906 = G__28004;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$state_machine__2746__auto__ = function(state_27906){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2746__auto____1.call(this,state_27906);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2746__auto____0;
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2746__auto____1;
return fluree$db$session$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27920 = f__2769__auto__.call(null);
(statearr_27920[(6)] = c__2768__auto___27995);

return statearr_27920;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.call(null,conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.call(null,conn,ledger,opts);
return fluree.db.session.current_db.call(null,session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__28007 = arguments.length;
switch (G__28007) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.call(null,null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__28008 = cljs.core.vals.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.call(null,(function (p1__28005_SHARP_){
return cljs.core._EQ_.call(null,conn_id,cljs.core.get_in.call(null,p1__28005_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__28008);
} else {
return G__28008;
}
})();
var seq__28009 = cljs.core.seq.call(null,sessions);
var chunk__28010 = null;
var count__28011 = (0);
var i__28012 = (0);
while(true){
if((i__28012 < count__28011)){
var session = cljs.core._nth.call(null,chunk__28010,i__28012);
fluree.db.session.close.call(null,session);


var G__28014 = seq__28009;
var G__28015 = chunk__28010;
var G__28016 = count__28011;
var G__28017 = (i__28012 + (1));
seq__28009 = G__28014;
chunk__28010 = G__28015;
count__28011 = G__28016;
i__28012 = G__28017;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__28009);
if(temp__5804__auto__){
var seq__28009__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28009__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__28009__$1);
var G__28018 = cljs.core.chunk_rest.call(null,seq__28009__$1);
var G__28019 = c__5568__auto__;
var G__28020 = cljs.core.count.call(null,c__5568__auto__);
var G__28021 = (0);
seq__28009 = G__28018;
chunk__28010 = G__28019;
count__28011 = G__28020;
i__28012 = G__28021;
continue;
} else {
var session = cljs.core.first.call(null,seq__28009__$1);
fluree.db.session.close.call(null,session);


var G__28022 = cljs.core.next.call(null,seq__28009__$1);
var G__28023 = null;
var G__28024 = (0);
var G__28025 = (0);
seq__28009 = G__28022;
chunk__28010 = G__28023;
count__28011 = G__28024;
i__28012 = G__28025;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.call(null,"Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.call(null,pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_.call(null,cljs.core.get.call(null,updated,tid))){
return cljs.core.dissoc.call(null,updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
