// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('cljs.analyzer');
goog.require('cljs.analyzer.impl');
goog.require('cljs.env');
goog.require('cljs.source_map');
goog.require('cljs.tools.reader');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__6861 = s;
var map__6861__$1 = cljs.core.__destructure_map(map__6861);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6861__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6861__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__6863 = info;
var map__6864 = G__6863;
var map__6864__$1 = cljs.core.__destructure_map(map__6864);
var shadow = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6864__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__6863__$1 = G__6863;
while(true){
var d__$2 = d__$1;
var map__6866 = G__6863__$1;
var map__6866__$1 = cljs.core.__destructure_map(map__6866);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6866__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$1)){
var G__6867 = (d__$2 + (1));
var G__6868 = shadow__$1;
d__$1 = G__6867;
G__6863__$1 = G__6868;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__6869){
var map__6870 = p__6869;
var map__6870__$1 = cljs.core.__destructure_map(map__6870);
var name_var = map__6870__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6870__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6870__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__6871 = info;
var map__6871__$1 = cljs.core.__destructure_map(map__6871);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6871__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6871__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__6872 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__6872) : cljs.compiler.munge.call(null,G__6872));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__6874 = arguments.length;
switch (G__6874) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.impl.cljs_map_QMARK_(s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__6875 = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",25,1,11790,11790,new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__6875.cljs$core$IFn$_invoke$arity$1 ? fexpr__6875.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__6875.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__6877 = cp;
switch (G__6877) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__6879_6883 = cljs.core.seq(s);
var chunk__6880_6884 = null;
var count__6881_6885 = (0);
var i__6882_6886 = (0);
while(true){
if((i__6882_6886 < count__6881_6885)){
var c_6887 = chunk__6880_6884.cljs$core$IIndexed$_nth$arity$2(null,i__6882_6886);
sb.append(cljs.compiler.escape_char(c_6887));


var G__6888 = seq__6879_6883;
var G__6889 = chunk__6880_6884;
var G__6890 = count__6881_6885;
var G__6891 = (i__6882_6886 + (1));
seq__6879_6883 = G__6888;
chunk__6880_6884 = G__6889;
count__6881_6885 = G__6890;
i__6882_6886 = G__6891;
continue;
} else {
var temp__5804__auto___6892 = cljs.core.seq(seq__6879_6883);
if(temp__5804__auto___6892){
var seq__6879_6893__$1 = temp__5804__auto___6892;
if(cljs.core.chunked_seq_QMARK_(seq__6879_6893__$1)){
var c__5568__auto___6894 = cljs.core.chunk_first(seq__6879_6893__$1);
var G__6895 = cljs.core.chunk_rest(seq__6879_6893__$1);
var G__6896 = c__5568__auto___6894;
var G__6897 = cljs.core.count(c__5568__auto___6894);
var G__6898 = (0);
seq__6879_6883 = G__6895;
chunk__6880_6884 = G__6896;
count__6881_6885 = G__6897;
i__6882_6886 = G__6898;
continue;
} else {
var c_6899 = cljs.core.first(seq__6879_6893__$1);
sb.append(cljs.compiler.escape_char(c_6899));


var G__6900 = cljs.core.next(seq__6879_6893__$1);
var G__6901 = null;
var G__6902 = (0);
var G__6903 = (0);
seq__6879_6883 = G__6900;
chunk__6880_6884 = G__6901;
count__6881_6885 = G__6902;
i__6882_6886 = G__6903;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__5642__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__6904 = cljs.core.get_global_hierarchy;
return (fexpr__6904.cljs$core$IFn$_invoke$arity$0 ? fexpr__6904.cljs$core$IFn$_invoke$arity$0() : fexpr__6904.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__6905_6910 = ast;
var map__6905_6911__$1 = cljs.core.__destructure_map(map__6905_6910);
var env_6912 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6905_6911__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_6912))){
var map__6906_6913 = env_6912;
var map__6906_6914__$1 = cljs.core.__destructure_map(map__6906_6913);
var line_6915 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6906_6914__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_6916 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6906_6914__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__6907 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__6909 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__6908 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__6908.cljs$core$IFn$_invoke$arity$1 ? fexpr__6908.cljs$core$IFn$_invoke$arity$1(G__6909) : fexpr__6908.call(null,G__6909));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__6907,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__6907;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_6915 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_6916)?(column_6916 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__6925 = arguments.length;
switch (G__6925) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__5794__auto__ = [];
var len__5769__auto___6932 = arguments.length;
var i__5770__auto___6933 = (0);
while(true){
if((i__5770__auto___6933 < len__5769__auto___6932)){
args_arr__5794__auto__.push((arguments[i__5770__auto___6933]));

var G__6934 = (i__5770__auto___6933 + (1));
i__5770__auto___6933 = G__6934;
continue;
} else {
}
break;
}

var argseq__5795__auto__ = (new cljs.core.IndexedSeq(args_arr__5794__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__5795__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.impl.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(typeof a === 'function'){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_6935 = (function (){var G__6926 = a;
if((!(typeof a === 'string'))){
return G__6926.toString();
} else {
return G__6926;
}
})();
var temp__5808__auto___6936 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5808__auto___6936 == null)){
} else {
var sm_data_6937 = temp__5808__auto___6936;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_6937,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__6917_SHARP_){
return (p1__6917_SHARP_ + s_6935.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_6935], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__6927 = cljs.core.seq(xs);
var chunk__6928 = null;
var count__6929 = (0);
var i__6930 = (0);
while(true){
if((i__6930 < count__6929)){
var x = chunk__6928.cljs$core$IIndexed$_nth$arity$2(null,i__6930);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__6938 = seq__6927;
var G__6939 = chunk__6928;
var G__6940 = count__6929;
var G__6941 = (i__6930 + (1));
seq__6927 = G__6938;
chunk__6928 = G__6939;
count__6929 = G__6940;
i__6930 = G__6941;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__6927);
if(temp__5804__auto__){
var seq__6927__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__6927__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__6927__$1);
var G__6942 = cljs.core.chunk_rest(seq__6927__$1);
var G__6943 = c__5568__auto__;
var G__6944 = cljs.core.count(c__5568__auto__);
var G__6945 = (0);
seq__6927 = G__6942;
chunk__6928 = G__6943;
count__6929 = G__6944;
i__6930 = G__6945;
continue;
} else {
var x = cljs.core.first(seq__6927__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__6946 = cljs.core.next(seq__6927__$1);
var G__6947 = null;
var G__6948 = (0);
var G__6949 = (0);
seq__6927 = G__6946;
chunk__6928 = G__6947;
count__6929 = G__6948;
i__6930 = G__6949;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq6919){
var G__6920 = cljs.core.first(seq6919);
var seq6919__$1 = cljs.core.next(seq6919);
var G__6921 = cljs.core.first(seq6919__$1);
var seq6919__$2 = cljs.core.next(seq6919__$1);
var G__6922 = cljs.core.first(seq6919__$2);
var seq6919__$3 = cljs.core.next(seq6919__$2);
var G__6923 = cljs.core.first(seq6919__$3);
var seq6919__$4 = cljs.core.next(seq6919__$3);
var G__6924 = cljs.core.first(seq6919__$4);
var seq6919__$5 = cljs.core.next(seq6919__$4);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6920,G__6921,G__6922,G__6923,G__6924,seq6919__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__6950){
var map__6951 = p__6950;
var map__6951__$1 = cljs.core.__destructure_map(map__6951);
var m = map__6951__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6951__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__6959 = arguments.length;
switch (G__6959) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__5794__auto__ = [];
var len__5769__auto___6965 = arguments.length;
var i__5770__auto___6966 = (0);
while(true){
if((i__5770__auto___6966 < len__5769__auto___6965)){
args_arr__5794__auto__.push((arguments[i__5770__auto___6966]));

var G__6967 = (i__5770__auto___6966 + (1));
i__5770__auto___6966 = G__6967;
continue;
} else {
}
break;
}

var argseq__5795__auto__ = (new cljs.core.IndexedSeq(args_arr__5794__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__5795__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__6960_6968 = cljs.core.seq(xs);
var chunk__6961_6969 = null;
var count__6962_6970 = (0);
var i__6963_6971 = (0);
while(true){
if((i__6963_6971 < count__6962_6970)){
var x_6972 = chunk__6961_6969.cljs$core$IIndexed$_nth$arity$2(null,i__6963_6971);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_6972);


var G__6973 = seq__6960_6968;
var G__6974 = chunk__6961_6969;
var G__6975 = count__6962_6970;
var G__6976 = (i__6963_6971 + (1));
seq__6960_6968 = G__6973;
chunk__6961_6969 = G__6974;
count__6962_6970 = G__6975;
i__6963_6971 = G__6976;
continue;
} else {
var temp__5804__auto___6977 = cljs.core.seq(seq__6960_6968);
if(temp__5804__auto___6977){
var seq__6960_6978__$1 = temp__5804__auto___6977;
if(cljs.core.chunked_seq_QMARK_(seq__6960_6978__$1)){
var c__5568__auto___6979 = cljs.core.chunk_first(seq__6960_6978__$1);
var G__6980 = cljs.core.chunk_rest(seq__6960_6978__$1);
var G__6981 = c__5568__auto___6979;
var G__6982 = cljs.core.count(c__5568__auto___6979);
var G__6983 = (0);
seq__6960_6968 = G__6980;
chunk__6961_6969 = G__6981;
count__6962_6970 = G__6982;
i__6963_6971 = G__6983;
continue;
} else {
var x_6984 = cljs.core.first(seq__6960_6978__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_6984);


var G__6985 = cljs.core.next(seq__6960_6978__$1);
var G__6986 = null;
var G__6987 = (0);
var G__6988 = (0);
seq__6960_6968 = G__6985;
chunk__6961_6969 = G__6986;
count__6962_6970 = G__6987;
i__6963_6971 = G__6988;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq6953){
var G__6954 = cljs.core.first(seq6953);
var seq6953__$1 = cljs.core.next(seq6953);
var G__6955 = cljs.core.first(seq6953__$1);
var seq6953__$2 = cljs.core.next(seq6953__$1);
var G__6956 = cljs.core.first(seq6953__$2);
var seq6953__$3 = cljs.core.next(seq6953__$2);
var G__6957 = cljs.core.first(seq6953__$3);
var seq6953__$4 = cljs.core.next(seq6953__$3);
var G__6958 = cljs.core.first(seq6953__$4);
var seq6953__$5 = cljs.core.next(seq6953__$4);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6954,G__6955,G__6956,G__6957,G__6958,seq6953__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__5690__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__6989_6993 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__6990_6994 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__6991_6995 = true;
var _STAR_print_fn_STAR__temp_val__6992_6996 = (function (x__5691__auto__){
return sb__5690__auto__.append(x__5691__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__6991_6995);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__6992_6996);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__6990_6994);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__6989_6993);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__5690__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__5642__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__6997 = cljs.core.get_global_hierarchy;
return (fexpr__6997.cljs$core$IFn$_invoke$arity$0 ? fexpr__6997.cljs$core$IFn$_invoke$arity$0() : fexpr__6997.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.impl.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__6998 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6998,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6998,(1),null);
var G__7001 = ns;
var G__7002 = name;
var G__7003 = (function (){
var G__7004 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__7004) : cljs.compiler.emit_constant.call(null,G__7004));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__7001,G__7002,G__7003) : cljs.compiler.emit_record_value.call(null,G__7001,G__7002,G__7003));
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(x)){
var G__7005 = cljs.core.keys(x);
var G__7006 = cljs.core.vals(x);
var G__7007 = cljs.compiler.emit_constants_comma_sep;
var G__7008 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__7005,G__7006,G__7007,G__7008) : cljs.compiler.emit_map.call(null,G__7005,G__7006,G__7007,G__7008));
} else {
if(cljs.analyzer.impl.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.impl.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__7009 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__7010 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__7009,G__7010) : cljs.compiler.emit_with_meta.call(null,G__7009,G__7010));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type(x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
if((((x === (0))) && ((((1) / x) < (0))))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(-0)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__7011 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7011,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7011,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7011,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5802__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__5043__auto__)){
var G__7014 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__7014) : x.call(null,G__7014));
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var value = temp__5802__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5802__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__5043__auto__)){
var G__7015 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__7015) : x.call(null,G__7015));
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var value = temp__5802__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_inst = (function cljs$compiler$emit_inst(inst_ms){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",inst_ms,")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emit_inst(date.getTime());
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__7017 = items;
var G__7018 = (function (p1__7016_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__7016_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__7017,G__7018) : cljs.compiler.emit_js_object.call(null,G__7017,G__7018));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__7020){
var map__7021 = p__7020;
var map__7021__$1 = cljs.core.__destructure_map(map__7021);
var ast = map__7021__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7021__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7021__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7021__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5802__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5802__auto__)){
var const_expr = temp__5802__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__7022 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__7022__$1 = cljs.core.__destructure_map(map__7022);
var cenv = map__7022__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7022__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name(var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__5045__auto__ = js_module_name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__7023 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__5043__auto__ = (function (){var G__7024 = new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__7024) : cljs.compiler.es5_GT__EQ_.call(null,G__7024));
})();
if(cljs.core.truth_(and__5043__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__5043__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__7023,cljs.analyzer.es5_allowed);
} else {
return G__7023;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__5045__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__7025 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__7025,reserved);
} else {
return G__7025;
}
})();
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__7026_7027 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__7026_7028__$1 = (((G__7026_7027 instanceof cljs.core.Keyword))?G__7026_7027.fqn:null);
switch (G__7026_7028__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__5043__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__7030){
var map__7031 = p__7030;
var map__7031__$1 = cljs.core.__destructure_map(map__7031);
var arg = map__7031__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7031__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7031__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7031__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7031__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.analyzer.ast_QMARK_(sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_(meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__7032 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__7032__$1 = cljs.core.__destructure_map(map__7032);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7032__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__7033){
var map__7034 = p__7033;
var map__7034__$1 = cljs.core.__destructure_map(map__7034);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7034__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7034__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7034__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__7035_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__7035_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__7036 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__7036) : comma_sep.call(null,G__7036));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__7037 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__7037) : comma_sep.call(null,G__7037));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__7038){
var map__7039 = p__7038;
var map__7039__$1 = cljs.core.__destructure_map(map__7039);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7039__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7039__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7039__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__7040){
var map__7041 = p__7040;
var map__7041__$1 = cljs.core.__destructure_map(map__7041);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7041__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7041__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__7042_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__7042_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__7043 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__7043) : comma_sep.call(null,G__7043));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set","set",304602554),(function (p__7044){
var map__7045 = p__7044;
var map__7045__$1 = cljs.core.__destructure_map(map__7045);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7045__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7045__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5804__auto___7068 = cljs.core.seq(items);
if(temp__5804__auto___7068){
var items_7069__$1 = temp__5804__auto___7068;
var vec__7046_7070 = items_7069__$1;
var seq__7047_7071 = cljs.core.seq(vec__7046_7070);
var first__7048_7072 = cljs.core.first(seq__7047_7071);
var seq__7047_7073__$1 = cljs.core.next(seq__7047_7071);
var vec__7049_7074 = first__7048_7072;
var k_7075 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7049_7074,(0),null);
var v_7076 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7049_7074,(1),null);
var r_7077 = seq__7047_7073__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_7075),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_7076) : emit_js_object_val.call(null,v_7076)));

var seq__7052_7078 = cljs.core.seq(r_7077);
var chunk__7053_7079 = null;
var count__7054_7080 = (0);
var i__7055_7081 = (0);
while(true){
if((i__7055_7081 < count__7054_7080)){
var vec__7062_7082 = chunk__7053_7079.cljs$core$IIndexed$_nth$arity$2(null,i__7055_7081);
var k_7083__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7062_7082,(0),null);
var v_7084__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7062_7082,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_7083__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_7084__$1) : emit_js_object_val.call(null,v_7084__$1)));


var G__7085 = seq__7052_7078;
var G__7086 = chunk__7053_7079;
var G__7087 = count__7054_7080;
var G__7088 = (i__7055_7081 + (1));
seq__7052_7078 = G__7085;
chunk__7053_7079 = G__7086;
count__7054_7080 = G__7087;
i__7055_7081 = G__7088;
continue;
} else {
var temp__5804__auto___7089__$1 = cljs.core.seq(seq__7052_7078);
if(temp__5804__auto___7089__$1){
var seq__7052_7090__$1 = temp__5804__auto___7089__$1;
if(cljs.core.chunked_seq_QMARK_(seq__7052_7090__$1)){
var c__5568__auto___7091 = cljs.core.chunk_first(seq__7052_7090__$1);
var G__7092 = cljs.core.chunk_rest(seq__7052_7090__$1);
var G__7093 = c__5568__auto___7091;
var G__7094 = cljs.core.count(c__5568__auto___7091);
var G__7095 = (0);
seq__7052_7078 = G__7092;
chunk__7053_7079 = G__7093;
count__7054_7080 = G__7094;
i__7055_7081 = G__7095;
continue;
} else {
var vec__7065_7096 = cljs.core.first(seq__7052_7090__$1);
var k_7097__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7065_7096,(0),null);
var v_7098__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7065_7096,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_7097__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_7098__$1) : emit_js_object_val.call(null,v_7098__$1)));


var G__7099 = cljs.core.next(seq__7052_7090__$1);
var G__7100 = null;
var G__7101 = (0);
var G__7102 = (0);
seq__7052_7078 = G__7099;
chunk__7053_7079 = G__7100;
count__7054_7080 = G__7101;
i__7055_7081 = G__7102;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__7103){
var map__7104 = p__7103;
var map__7104__$1 = cljs.core.__destructure_map(map__7104);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7104__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7104__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7104__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__7105){
var map__7106 = p__7105;
var map__7106__$1 = cljs.core.__destructure_map(map__7106);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7106__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7106__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__7107){
var map__7108 = p__7107;
var map__7108__$1 = cljs.core.__destructure_map(map__7108);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7108__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__7109){
var map__7110 = p__7109;
var map__7110__$1 = cljs.core.__destructure_map(map__7110);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7110__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7110__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__7111 = cljs.analyzer.unwrap_quote(expr);
var map__7111__$1 = cljs.core.__destructure_map(map__7111);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7111__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7111__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7111__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__5045__auto__ = (function (){var and__5043__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842));
if(and__5043__auto__){
var and__5043__auto____$1 = form;
if(cljs.core.truth_(and__5043__auto____$1)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var and__5043__auto__ = (!((const_expr == null)));
if(and__5043__auto__){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return and__5043__auto__;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__7112 = cljs.analyzer.unwrap_quote(expr);
var map__7112__$1 = cljs.core.__destructure_map(map__7112);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7112__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7112__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7112__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__5045__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__5045__auto__){
return or__5045__auto__;
} else {
var and__5043__auto__ = (!((const_expr == null)));
if(and__5043__auto__){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return and__5043__auto__;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__5045__auto__ = (function (){var fexpr__7113 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null);
return (fexpr__7113.cljs$core$IFn$_invoke$arity$1 ? fexpr__7113.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__7113.call(null,tag));
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__7114){
var map__7115 = p__7114;
var map__7115__$1 = cljs.core.__destructure_map(map__7115);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7115__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7115__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7115__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7115__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7115__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__5045__auto__ = unchecked;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__7116){
var map__7117 = p__7116;
var map__7117__$1 = cljs.core.__destructure_map(map__7117);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7117__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7117__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7117__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7117__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__7118_7146 = cljs.core.seq(nodes);
var chunk__7119_7147 = null;
var count__7120_7148 = (0);
var i__7121_7149 = (0);
while(true){
if((i__7121_7149 < count__7120_7148)){
var map__7134_7150 = chunk__7119_7147.cljs$core$IIndexed$_nth$arity$2(null,i__7121_7149);
var map__7134_7151__$1 = cljs.core.__destructure_map(map__7134_7150);
var ts_7152 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7134_7151__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__7135_7153 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7134_7151__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__7135_7154__$1 = cljs.core.__destructure_map(map__7135_7153);
var then_7155 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7135_7154__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__7136_7156 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_7152));
var chunk__7137_7157 = null;
var count__7138_7158 = (0);
var i__7139_7159 = (0);
while(true){
if((i__7139_7159 < count__7138_7158)){
var test_7160 = chunk__7137_7157.cljs$core$IIndexed$_nth$arity$2(null,i__7139_7159);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_7160,":");


var G__7161 = seq__7136_7156;
var G__7162 = chunk__7137_7157;
var G__7163 = count__7138_7158;
var G__7164 = (i__7139_7159 + (1));
seq__7136_7156 = G__7161;
chunk__7137_7157 = G__7162;
count__7138_7158 = G__7163;
i__7139_7159 = G__7164;
continue;
} else {
var temp__5804__auto___7165 = cljs.core.seq(seq__7136_7156);
if(temp__5804__auto___7165){
var seq__7136_7166__$1 = temp__5804__auto___7165;
if(cljs.core.chunked_seq_QMARK_(seq__7136_7166__$1)){
var c__5568__auto___7167 = cljs.core.chunk_first(seq__7136_7166__$1);
var G__7168 = cljs.core.chunk_rest(seq__7136_7166__$1);
var G__7169 = c__5568__auto___7167;
var G__7170 = cljs.core.count(c__5568__auto___7167);
var G__7171 = (0);
seq__7136_7156 = G__7168;
chunk__7137_7157 = G__7169;
count__7138_7158 = G__7170;
i__7139_7159 = G__7171;
continue;
} else {
var test_7172 = cljs.core.first(seq__7136_7166__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_7172,":");


var G__7173 = cljs.core.next(seq__7136_7166__$1);
var G__7174 = null;
var G__7175 = (0);
var G__7176 = (0);
seq__7136_7156 = G__7173;
chunk__7137_7157 = G__7174;
count__7138_7158 = G__7175;
i__7139_7159 = G__7176;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_7155);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_7155);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__7177 = seq__7118_7146;
var G__7178 = chunk__7119_7147;
var G__7179 = count__7120_7148;
var G__7180 = (i__7121_7149 + (1));
seq__7118_7146 = G__7177;
chunk__7119_7147 = G__7178;
count__7120_7148 = G__7179;
i__7121_7149 = G__7180;
continue;
} else {
var temp__5804__auto___7181 = cljs.core.seq(seq__7118_7146);
if(temp__5804__auto___7181){
var seq__7118_7182__$1 = temp__5804__auto___7181;
if(cljs.core.chunked_seq_QMARK_(seq__7118_7182__$1)){
var c__5568__auto___7183 = cljs.core.chunk_first(seq__7118_7182__$1);
var G__7184 = cljs.core.chunk_rest(seq__7118_7182__$1);
var G__7185 = c__5568__auto___7183;
var G__7186 = cljs.core.count(c__5568__auto___7183);
var G__7187 = (0);
seq__7118_7146 = G__7184;
chunk__7119_7147 = G__7185;
count__7120_7148 = G__7186;
i__7121_7149 = G__7187;
continue;
} else {
var map__7140_7188 = cljs.core.first(seq__7118_7182__$1);
var map__7140_7189__$1 = cljs.core.__destructure_map(map__7140_7188);
var ts_7190 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7140_7189__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__7141_7191 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7140_7189__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__7141_7192__$1 = cljs.core.__destructure_map(map__7141_7191);
var then_7193 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7141_7192__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__7142_7194 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_7190));
var chunk__7143_7195 = null;
var count__7144_7196 = (0);
var i__7145_7197 = (0);
while(true){
if((i__7145_7197 < count__7144_7196)){
var test_7198 = chunk__7143_7195.cljs$core$IIndexed$_nth$arity$2(null,i__7145_7197);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_7198,":");


var G__7199 = seq__7142_7194;
var G__7200 = chunk__7143_7195;
var G__7201 = count__7144_7196;
var G__7202 = (i__7145_7197 + (1));
seq__7142_7194 = G__7199;
chunk__7143_7195 = G__7200;
count__7144_7196 = G__7201;
i__7145_7197 = G__7202;
continue;
} else {
var temp__5804__auto___7203__$1 = cljs.core.seq(seq__7142_7194);
if(temp__5804__auto___7203__$1){
var seq__7142_7204__$1 = temp__5804__auto___7203__$1;
if(cljs.core.chunked_seq_QMARK_(seq__7142_7204__$1)){
var c__5568__auto___7205 = cljs.core.chunk_first(seq__7142_7204__$1);
var G__7206 = cljs.core.chunk_rest(seq__7142_7204__$1);
var G__7207 = c__5568__auto___7205;
var G__7208 = cljs.core.count(c__5568__auto___7205);
var G__7209 = (0);
seq__7142_7194 = G__7206;
chunk__7143_7195 = G__7207;
count__7144_7196 = G__7208;
i__7145_7197 = G__7209;
continue;
} else {
var test_7210 = cljs.core.first(seq__7142_7204__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_7210,":");


var G__7211 = cljs.core.next(seq__7142_7204__$1);
var G__7212 = null;
var G__7213 = (0);
var G__7214 = (0);
seq__7142_7194 = G__7211;
chunk__7143_7195 = G__7212;
count__7144_7196 = G__7213;
i__7145_7197 = G__7214;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_7193);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_7193);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__7215 = cljs.core.next(seq__7118_7182__$1);
var G__7216 = null;
var G__7217 = (0);
var G__7218 = (0);
seq__7118_7146 = G__7215;
chunk__7119_7147 = G__7216;
count__7120_7148 = G__7217;
i__7121_7149 = G__7218;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__7219){
var map__7220 = p__7219;
var map__7220__$1 = cljs.core.__destructure_map(map__7220);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7220__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7220__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(goog.string.startsWith(t,"!")){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__7224 = env;
var G__7225 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__7224,G__7225) : cljs.compiler.resolve_type.call(null,G__7224,G__7225));
})())].join('');
} else {
if(goog.string.startsWith(t,"{")){
return t;
} else {
if(goog.string.startsWith(t,"function")){
var idx = t.lastIndexOf(":");
var vec__7226 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7226,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7226,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__7221_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__7221_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__7221_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__7229 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__7229,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__7229;
}
} else {
if(goog.string.endsWith(t,"=")){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__7232 = env;
var G__7233 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__7232,G__7233) : cljs.compiler.resolve_type.call(null,G__7232,G__7233));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__7234_SHARP_){
return cljs.compiler.resolve_type(env,p1__7234_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__7235 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__7236 = cljs.core.seq(vec__7235);
var first__7237 = cljs.core.first(seq__7236);
var seq__7236__$1 = cljs.core.next(seq__7236);
var p = first__7237;
var first__7237__$1 = cljs.core.first(seq__7236__$1);
var seq__7236__$2 = cljs.core.next(seq__7236__$1);
var ts = first__7237__$1;
var first__7237__$2 = cljs.core.first(seq__7236__$2);
var seq__7236__$3 = cljs.core.next(seq__7236__$2);
var n = first__7237__$2;
var xs = seq__7236__$3;
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p);
if(and__5043__auto__){
var and__5043__auto____$1 = ts;
if(cljs.core.truth_(and__5043__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__7238 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__7239 = cljs.core.seq(vec__7238);
var first__7240 = cljs.core.first(seq__7239);
var seq__7239__$1 = cljs.core.next(seq__7239);
var p = first__7240;
var first__7240__$1 = cljs.core.first(seq__7239__$1);
var seq__7239__$2 = cljs.core.next(seq__7239__$1);
var ts = first__7240__$1;
var xs = seq__7239__$2;
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p);
if(and__5043__auto__){
var and__5043__auto____$1 = ts;
if(cljs.core.truth_(and__5043__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__7242 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null));
var fexpr__7241 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null);
return (fexpr__7241.cljs$core$IFn$_invoke$arity$1 ? fexpr__7241.cljs$core$IFn$_invoke$arity$1(G__7242) : fexpr__7241.call(null,G__7242));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__7245 = arguments.length;
switch (G__7245) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__7253 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__7243_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__7243_SHARP_);
} else {
return p1__7243_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__7254 = cljs.core.seq(vec__7253);
var first__7255 = cljs.core.first(seq__7254);
var seq__7254__$1 = cljs.core.next(seq__7254);
var x = first__7255;
var ys = seq__7254__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__7256 = cljs.core.seq(ys);
var chunk__7257 = null;
var count__7258 = (0);
var i__7259 = (0);
while(true){
if((i__7259 < count__7258)){
var next_line = chunk__7257.cljs$core$IIndexed$_nth$arity$2(null,i__7259);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__7265 = seq__7256;
var G__7266 = chunk__7257;
var G__7267 = count__7258;
var G__7268 = (i__7259 + (1));
seq__7256 = G__7265;
chunk__7257 = G__7266;
count__7258 = G__7267;
i__7259 = G__7268;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__7256);
if(temp__5804__auto__){
var seq__7256__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__7256__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__7256__$1);
var G__7269 = cljs.core.chunk_rest(seq__7256__$1);
var G__7270 = c__5568__auto__;
var G__7271 = cljs.core.count(c__5568__auto__);
var G__7272 = (0);
seq__7256 = G__7269;
chunk__7257 = G__7270;
count__7258 = G__7271;
i__7259 = G__7272;
continue;
} else {
var next_line = cljs.core.first(seq__7256__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__7273 = cljs.core.next(seq__7256__$1);
var G__7274 = null;
var G__7275 = (0);
var G__7276 = (0);
seq__7256 = G__7273;
chunk__7257 = G__7274;
count__7258 = G__7275;
i__7259 = G__7276;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__7260_7277 = cljs.core.seq(docs__$2);
var chunk__7261_7278 = null;
var count__7262_7279 = (0);
var i__7263_7280 = (0);
while(true){
if((i__7263_7280 < count__7262_7279)){
var e_7281 = chunk__7261_7278.cljs$core$IIndexed$_nth$arity$2(null,i__7263_7280);
if(cljs.core.truth_(e_7281)){
print_comment_lines(e_7281);
} else {
}


var G__7282 = seq__7260_7277;
var G__7283 = chunk__7261_7278;
var G__7284 = count__7262_7279;
var G__7285 = (i__7263_7280 + (1));
seq__7260_7277 = G__7282;
chunk__7261_7278 = G__7283;
count__7262_7279 = G__7284;
i__7263_7280 = G__7285;
continue;
} else {
var temp__5804__auto___7286 = cljs.core.seq(seq__7260_7277);
if(temp__5804__auto___7286){
var seq__7260_7287__$1 = temp__5804__auto___7286;
if(cljs.core.chunked_seq_QMARK_(seq__7260_7287__$1)){
var c__5568__auto___7288 = cljs.core.chunk_first(seq__7260_7287__$1);
var G__7289 = cljs.core.chunk_rest(seq__7260_7287__$1);
var G__7290 = c__5568__auto___7288;
var G__7291 = cljs.core.count(c__5568__auto___7288);
var G__7292 = (0);
seq__7260_7277 = G__7289;
chunk__7261_7278 = G__7290;
count__7262_7279 = G__7291;
i__7263_7280 = G__7292;
continue;
} else {
var e_7293 = cljs.core.first(seq__7260_7287__$1);
if(cljs.core.truth_(e_7293)){
print_comment_lines(e_7293);
} else {
}


var G__7294 = cljs.core.next(seq__7260_7287__$1);
var G__7295 = null;
var G__7296 = (0);
var G__7297 = (0);
seq__7260_7277 = G__7294;
chunk__7261_7278 = G__7295;
count__7262_7279 = G__7296;
i__7263_7280 = G__7297;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (((x === true) || (((x === false) || (typeof x === 'number'))))));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__5043__auto__ = cljs.core.some((function (p1__7299_SHARP_){
return goog.string.startsWith(p1__7299_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__5043__auto__)){
var and__5043__auto____$1 = opts;
if(cljs.core.truth_(and__5043__auto____$1)){
var and__5043__auto____$2 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478));
if(and__5043__auto____$2){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return and__5043__auto____$2;
}
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__7300){
var map__7301 = p__7300;
var map__7301__$1 = cljs.core.__destructure_map(map__7301);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7301__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7301__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7301__$1,new cljs.core.Keyword(null,"test","test",577538877));
var goog_define = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7301__$1,new cljs.core.Keyword(null,"goog-define","goog-define",-1048305441));
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7301__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7301__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7301__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7301__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7301__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7301__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__5045__auto__ = init;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((cljs.core.truth_(goog_define)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog_define),"}"].join('')], null):null),jsdoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)], 0)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5802__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5802__auto__)){
var define = temp__5802__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__5043__auto__)){
return test;
} else {
return and__5043__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__7302){
var map__7303 = p__7302;
var map__7303__$1 = cljs.core.__destructure_map(map__7303);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7303__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7303__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7303__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__7304_7328 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__7305_7329 = null;
var count__7306_7330 = (0);
var i__7307_7331 = (0);
while(true){
if((i__7307_7331 < count__7306_7330)){
var vec__7314_7332 = chunk__7305_7329.cljs$core$IIndexed$_nth$arity$2(null,i__7307_7331);
var i_7333 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7314_7332,(0),null);
var param_7334 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7314_7332,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_7334);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__7335 = seq__7304_7328;
var G__7336 = chunk__7305_7329;
var G__7337 = count__7306_7330;
var G__7338 = (i__7307_7331 + (1));
seq__7304_7328 = G__7335;
chunk__7305_7329 = G__7336;
count__7306_7330 = G__7337;
i__7307_7331 = G__7338;
continue;
} else {
var temp__5804__auto___7339 = cljs.core.seq(seq__7304_7328);
if(temp__5804__auto___7339){
var seq__7304_7340__$1 = temp__5804__auto___7339;
if(cljs.core.chunked_seq_QMARK_(seq__7304_7340__$1)){
var c__5568__auto___7341 = cljs.core.chunk_first(seq__7304_7340__$1);
var G__7342 = cljs.core.chunk_rest(seq__7304_7340__$1);
var G__7343 = c__5568__auto___7341;
var G__7344 = cljs.core.count(c__5568__auto___7341);
var G__7345 = (0);
seq__7304_7328 = G__7342;
chunk__7305_7329 = G__7343;
count__7306_7330 = G__7344;
i__7307_7331 = G__7345;
continue;
} else {
var vec__7317_7346 = cljs.core.first(seq__7304_7340__$1);
var i_7347 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7317_7346,(0),null);
var param_7348 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7317_7346,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_7348);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__7349 = cljs.core.next(seq__7304_7340__$1);
var G__7350 = null;
var G__7351 = (0);
var G__7352 = (0);
seq__7304_7328 = G__7349;
chunk__7305_7329 = G__7350;
count__7306_7330 = G__7351;
i__7307_7331 = G__7352;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__7320_7353 = cljs.core.seq(params);
var chunk__7321_7354 = null;
var count__7322_7355 = (0);
var i__7323_7356 = (0);
while(true){
if((i__7323_7356 < count__7322_7355)){
var param_7357 = chunk__7321_7354.cljs$core$IIndexed$_nth$arity$2(null,i__7323_7356);
cljs.compiler.emit(param_7357);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7357,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7358 = seq__7320_7353;
var G__7359 = chunk__7321_7354;
var G__7360 = count__7322_7355;
var G__7361 = (i__7323_7356 + (1));
seq__7320_7353 = G__7358;
chunk__7321_7354 = G__7359;
count__7322_7355 = G__7360;
i__7323_7356 = G__7361;
continue;
} else {
var temp__5804__auto___7362 = cljs.core.seq(seq__7320_7353);
if(temp__5804__auto___7362){
var seq__7320_7363__$1 = temp__5804__auto___7362;
if(cljs.core.chunked_seq_QMARK_(seq__7320_7363__$1)){
var c__5568__auto___7364 = cljs.core.chunk_first(seq__7320_7363__$1);
var G__7365 = cljs.core.chunk_rest(seq__7320_7363__$1);
var G__7366 = c__5568__auto___7364;
var G__7367 = cljs.core.count(c__5568__auto___7364);
var G__7368 = (0);
seq__7320_7353 = G__7365;
chunk__7321_7354 = G__7366;
count__7322_7355 = G__7367;
i__7323_7356 = G__7368;
continue;
} else {
var param_7369 = cljs.core.first(seq__7320_7363__$1);
cljs.compiler.emit(param_7369);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7369,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7370 = cljs.core.next(seq__7320_7363__$1);
var G__7371 = null;
var G__7372 = (0);
var G__7373 = (0);
seq__7320_7353 = G__7370;
chunk__7321_7354 = G__7371;
count__7322_7355 = G__7372;
i__7323_7356 = G__7373;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__7324_7374 = cljs.core.seq(params);
var chunk__7325_7375 = null;
var count__7326_7376 = (0);
var i__7327_7377 = (0);
while(true){
if((i__7327_7377 < count__7326_7376)){
var param_7378 = chunk__7325_7375.cljs$core$IIndexed$_nth$arity$2(null,i__7327_7377);
cljs.compiler.emit(param_7378);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7378,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7379 = seq__7324_7374;
var G__7380 = chunk__7325_7375;
var G__7381 = count__7326_7376;
var G__7382 = (i__7327_7377 + (1));
seq__7324_7374 = G__7379;
chunk__7325_7375 = G__7380;
count__7326_7376 = G__7381;
i__7327_7377 = G__7382;
continue;
} else {
var temp__5804__auto___7383 = cljs.core.seq(seq__7324_7374);
if(temp__5804__auto___7383){
var seq__7324_7384__$1 = temp__5804__auto___7383;
if(cljs.core.chunked_seq_QMARK_(seq__7324_7384__$1)){
var c__5568__auto___7385 = cljs.core.chunk_first(seq__7324_7384__$1);
var G__7386 = cljs.core.chunk_rest(seq__7324_7384__$1);
var G__7387 = c__5568__auto___7385;
var G__7388 = cljs.core.count(c__5568__auto___7385);
var G__7389 = (0);
seq__7324_7374 = G__7386;
chunk__7325_7375 = G__7387;
count__7326_7376 = G__7388;
i__7327_7377 = G__7389;
continue;
} else {
var param_7390 = cljs.core.first(seq__7324_7384__$1);
cljs.compiler.emit(param_7390);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7390,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7391 = cljs.core.next(seq__7324_7384__$1);
var G__7392 = null;
var G__7393 = (0);
var G__7394 = (0);
seq__7324_7374 = G__7391;
chunk__7325_7375 = G__7392;
count__7326_7376 = G__7393;
i__7327_7377 = G__7394;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__7395 = cljs.core.seq(params);
var chunk__7396 = null;
var count__7397 = (0);
var i__7398 = (0);
while(true){
if((i__7398 < count__7397)){
var param = chunk__7396.cljs$core$IIndexed$_nth$arity$2(null,i__7398);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7399 = seq__7395;
var G__7400 = chunk__7396;
var G__7401 = count__7397;
var G__7402 = (i__7398 + (1));
seq__7395 = G__7399;
chunk__7396 = G__7400;
count__7397 = G__7401;
i__7398 = G__7402;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__7395);
if(temp__5804__auto__){
var seq__7395__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__7395__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__7395__$1);
var G__7403 = cljs.core.chunk_rest(seq__7395__$1);
var G__7404 = c__5568__auto__;
var G__7405 = cljs.core.count(c__5568__auto__);
var G__7406 = (0);
seq__7395 = G__7403;
chunk__7396 = G__7404;
count__7397 = G__7405;
i__7398 = G__7406;
continue;
} else {
var param = cljs.core.first(seq__7395__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7407 = cljs.core.next(seq__7395__$1);
var G__7408 = null;
var G__7409 = (0);
var G__7410 = (0);
seq__7395 = G__7407;
chunk__7396 = G__7408;
count__7397 = G__7409;
i__7398 = G__7410;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__7411){
var map__7412 = p__7411;
var map__7412__$1 = cljs.core.__destructure_map(map__7412);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7412__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7412__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7412__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7412__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7412__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7412__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_(startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__7413){
var map__7414 = p__7413;
var map__7414__$1 = cljs.core.__destructure_map(map__7414);
var f = map__7414__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7414__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7414__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7414__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7414__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7414__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7414__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7414__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7414__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_7423__$1 = (function (){var or__5045__auto__ = name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_7424 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_7423__$1);
var delegate_name_7425 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_7424),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_7425," = function (");

var seq__7415_7426 = cljs.core.seq(params);
var chunk__7416_7427 = null;
var count__7417_7428 = (0);
var i__7418_7429 = (0);
while(true){
if((i__7418_7429 < count__7417_7428)){
var param_7430 = chunk__7416_7427.cljs$core$IIndexed$_nth$arity$2(null,i__7418_7429);
cljs.compiler.emit(param_7430);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7430,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7431 = seq__7415_7426;
var G__7432 = chunk__7416_7427;
var G__7433 = count__7417_7428;
var G__7434 = (i__7418_7429 + (1));
seq__7415_7426 = G__7431;
chunk__7416_7427 = G__7432;
count__7417_7428 = G__7433;
i__7418_7429 = G__7434;
continue;
} else {
var temp__5804__auto___7435 = cljs.core.seq(seq__7415_7426);
if(temp__5804__auto___7435){
var seq__7415_7436__$1 = temp__5804__auto___7435;
if(cljs.core.chunked_seq_QMARK_(seq__7415_7436__$1)){
var c__5568__auto___7437 = cljs.core.chunk_first(seq__7415_7436__$1);
var G__7438 = cljs.core.chunk_rest(seq__7415_7436__$1);
var G__7439 = c__5568__auto___7437;
var G__7440 = cljs.core.count(c__5568__auto___7437);
var G__7441 = (0);
seq__7415_7426 = G__7438;
chunk__7416_7427 = G__7439;
count__7417_7428 = G__7440;
i__7418_7429 = G__7441;
continue;
} else {
var param_7442 = cljs.core.first(seq__7415_7436__$1);
cljs.compiler.emit(param_7442);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7442,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7443 = cljs.core.next(seq__7415_7436__$1);
var G__7444 = null;
var G__7445 = (0);
var G__7446 = (0);
seq__7415_7426 = G__7443;
chunk__7416_7427 = G__7444;
count__7417_7428 = G__7445;
i__7418_7429 = G__7446;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_7424," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_7447 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_7447,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_7425,".call(this,");

var seq__7419_7448 = cljs.core.seq(params);
var chunk__7420_7449 = null;
var count__7421_7450 = (0);
var i__7422_7451 = (0);
while(true){
if((i__7422_7451 < count__7421_7450)){
var param_7452 = chunk__7420_7449.cljs$core$IIndexed$_nth$arity$2(null,i__7422_7451);
cljs.compiler.emit(param_7452);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7452,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7453 = seq__7419_7448;
var G__7454 = chunk__7420_7449;
var G__7455 = count__7421_7450;
var G__7456 = (i__7422_7451 + (1));
seq__7419_7448 = G__7453;
chunk__7420_7449 = G__7454;
count__7421_7450 = G__7455;
i__7422_7451 = G__7456;
continue;
} else {
var temp__5804__auto___7457 = cljs.core.seq(seq__7419_7448);
if(temp__5804__auto___7457){
var seq__7419_7458__$1 = temp__5804__auto___7457;
if(cljs.core.chunked_seq_QMARK_(seq__7419_7458__$1)){
var c__5568__auto___7459 = cljs.core.chunk_first(seq__7419_7458__$1);
var G__7460 = cljs.core.chunk_rest(seq__7419_7458__$1);
var G__7461 = c__5568__auto___7459;
var G__7462 = cljs.core.count(c__5568__auto___7459);
var G__7463 = (0);
seq__7419_7448 = G__7460;
chunk__7420_7449 = G__7461;
count__7421_7450 = G__7462;
i__7422_7451 = G__7463;
continue;
} else {
var param_7464 = cljs.core.first(seq__7419_7458__$1);
cljs.compiler.emit(param_7464);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7464,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7465 = cljs.core.next(seq__7419_7458__$1);
var G__7466 = null;
var G__7467 = (0);
var G__7468 = (0);
seq__7419_7448 = G__7465;
chunk__7420_7449 = G__7466;
count__7421_7450 = G__7467;
i__7422_7451 = G__7468;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7424,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_7424,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.Keyword(null,"name","name",1843675177),name_7423__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7424,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_7425,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_7424,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__7472){
var map__7473 = p__7472;
var map__7473__$1 = cljs.core.__destructure_map(map__7473);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7473__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7473__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7473__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7473__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7473__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7473__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7473__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7473__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__7469_SHARP_){
var and__5043__auto__ = p1__7469_SHARP_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.deref(new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__7469_SHARP_));
} else {
return and__5043__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__5045__auto__ = in_loop;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_7525__$1 = (function (){var or__5045__auto__ = name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_7526 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_7525__$1);
var maxparams_7527 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_7528 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_7526),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_7529 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__7470_SHARP_){
return cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__7470_SHARP_)));
}),cljs.core.seq(mmap_7528));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_7526," = null;");

var seq__7474_7530 = cljs.core.seq(ms_7529);
var chunk__7475_7531 = null;
var count__7476_7532 = (0);
var i__7477_7533 = (0);
while(true){
if((i__7477_7533 < count__7476_7532)){
var vec__7484_7534 = chunk__7475_7531.cljs$core$IIndexed$_nth$arity$2(null,i__7477_7533);
var n_7535 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7484_7534,(0),null);
var meth_7536 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7484_7534,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_7535," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7536))){
cljs.compiler.emit_variadic_fn_method(meth_7536);
} else {
cljs.compiler.emit_fn_method(meth_7536);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__7537 = seq__7474_7530;
var G__7538 = chunk__7475_7531;
var G__7539 = count__7476_7532;
var G__7540 = (i__7477_7533 + (1));
seq__7474_7530 = G__7537;
chunk__7475_7531 = G__7538;
count__7476_7532 = G__7539;
i__7477_7533 = G__7540;
continue;
} else {
var temp__5804__auto___7541 = cljs.core.seq(seq__7474_7530);
if(temp__5804__auto___7541){
var seq__7474_7542__$1 = temp__5804__auto___7541;
if(cljs.core.chunked_seq_QMARK_(seq__7474_7542__$1)){
var c__5568__auto___7543 = cljs.core.chunk_first(seq__7474_7542__$1);
var G__7544 = cljs.core.chunk_rest(seq__7474_7542__$1);
var G__7545 = c__5568__auto___7543;
var G__7546 = cljs.core.count(c__5568__auto___7543);
var G__7547 = (0);
seq__7474_7530 = G__7544;
chunk__7475_7531 = G__7545;
count__7476_7532 = G__7546;
i__7477_7533 = G__7547;
continue;
} else {
var vec__7487_7548 = cljs.core.first(seq__7474_7542__$1);
var n_7549 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7487_7548,(0),null);
var meth_7550 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7487_7548,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_7549," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7550))){
cljs.compiler.emit_variadic_fn_method(meth_7550);
} else {
cljs.compiler.emit_fn_method(meth_7550);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__7551 = cljs.core.next(seq__7474_7542__$1);
var G__7552 = null;
var G__7553 = (0);
var G__7554 = (0);
seq__7474_7530 = G__7551;
chunk__7475_7531 = G__7552;
count__7476_7532 = G__7553;
i__7477_7533 = G__7554;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7526," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_7527),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_7527)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_7527));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__7490_7555 = cljs.core.seq(ms_7529);
var chunk__7491_7556 = null;
var count__7492_7557 = (0);
var i__7493_7558 = (0);
while(true){
if((i__7493_7558 < count__7492_7557)){
var vec__7500_7559 = chunk__7491_7556.cljs$core$IIndexed$_nth$arity$2(null,i__7493_7558);
var n_7560 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7500_7559,(0),null);
var meth_7561 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7500_7559,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7561))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_7562 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_7562," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_7563 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_7562," = new cljs.core.IndexedSeq(",a_7563,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_7560,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_7527)),(((cljs.core.count(maxparams_7527) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_7562,");"], 0));
} else {
var pcnt_7564 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7561));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_7564,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_7560,".call(this",(((pcnt_7564 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_7564,maxparams_7527)),null,(1),null)),(2),null))),");");
}


var G__7565 = seq__7490_7555;
var G__7566 = chunk__7491_7556;
var G__7567 = count__7492_7557;
var G__7568 = (i__7493_7558 + (1));
seq__7490_7555 = G__7565;
chunk__7491_7556 = G__7566;
count__7492_7557 = G__7567;
i__7493_7558 = G__7568;
continue;
} else {
var temp__5804__auto___7569 = cljs.core.seq(seq__7490_7555);
if(temp__5804__auto___7569){
var seq__7490_7570__$1 = temp__5804__auto___7569;
if(cljs.core.chunked_seq_QMARK_(seq__7490_7570__$1)){
var c__5568__auto___7571 = cljs.core.chunk_first(seq__7490_7570__$1);
var G__7572 = cljs.core.chunk_rest(seq__7490_7570__$1);
var G__7573 = c__5568__auto___7571;
var G__7574 = cljs.core.count(c__5568__auto___7571);
var G__7575 = (0);
seq__7490_7555 = G__7572;
chunk__7491_7556 = G__7573;
count__7492_7557 = G__7574;
i__7493_7558 = G__7575;
continue;
} else {
var vec__7503_7576 = cljs.core.first(seq__7490_7570__$1);
var n_7577 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7503_7576,(0),null);
var meth_7578 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7503_7576,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7578))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_7579 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_7579," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_7580 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_7579," = new cljs.core.IndexedSeq(",a_7580,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_7577,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_7527)),(((cljs.core.count(maxparams_7527) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_7579,");"], 0));
} else {
var pcnt_7581 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7578));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_7581,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_7577,".call(this",(((pcnt_7581 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_7581,maxparams_7527)),null,(1),null)),(2),null))),");");
}


var G__7582 = cljs.core.next(seq__7490_7570__$1);
var G__7583 = null;
var G__7584 = (0);
var G__7585 = (0);
seq__7490_7555 = G__7582;
chunk__7491_7556 = G__7583;
count__7492_7557 = G__7584;
i__7493_7558 = G__7585;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_7586 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_7529)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_7586,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7526,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7526,".cljs$lang$applyTo = ",cljs.core.some((function (p1__7471_SHARP_){
var vec__7506 = p1__7471_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7506,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7506,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_7529),".cljs$lang$applyTo;");
} else {
}

var seq__7509_7587 = cljs.core.seq(ms_7529);
var chunk__7510_7588 = null;
var count__7511_7589 = (0);
var i__7512_7590 = (0);
while(true){
if((i__7512_7590 < count__7511_7589)){
var vec__7519_7591 = chunk__7510_7588.cljs$core$IIndexed$_nth$arity$2(null,i__7512_7590);
var n_7592 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7519_7591,(0),null);
var meth_7593 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7519_7591,(1),null);
var c_7594 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7593));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7593))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7526,".cljs$core$IFn$_invoke$arity$variadic = ",n_7592,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_7526,".cljs$core$IFn$_invoke$arity$",c_7594," = ",n_7592,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__7595 = seq__7509_7587;
var G__7596 = chunk__7510_7588;
var G__7597 = count__7511_7589;
var G__7598 = (i__7512_7590 + (1));
seq__7509_7587 = G__7595;
chunk__7510_7588 = G__7596;
count__7511_7589 = G__7597;
i__7512_7590 = G__7598;
continue;
} else {
var temp__5804__auto___7599 = cljs.core.seq(seq__7509_7587);
if(temp__5804__auto___7599){
var seq__7509_7600__$1 = temp__5804__auto___7599;
if(cljs.core.chunked_seq_QMARK_(seq__7509_7600__$1)){
var c__5568__auto___7601 = cljs.core.chunk_first(seq__7509_7600__$1);
var G__7602 = cljs.core.chunk_rest(seq__7509_7600__$1);
var G__7603 = c__5568__auto___7601;
var G__7604 = cljs.core.count(c__5568__auto___7601);
var G__7605 = (0);
seq__7509_7587 = G__7602;
chunk__7510_7588 = G__7603;
count__7511_7589 = G__7604;
i__7512_7590 = G__7605;
continue;
} else {
var vec__7522_7606 = cljs.core.first(seq__7509_7600__$1);
var n_7607 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7522_7606,(0),null);
var meth_7608 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7522_7606,(1),null);
var c_7609 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7608));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7608))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7526,".cljs$core$IFn$_invoke$arity$variadic = ",n_7607,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_7526,".cljs$core$IFn$_invoke$arity$",c_7609," = ",n_7607,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__7610 = cljs.core.next(seq__7509_7600__$1);
var G__7611 = null;
var G__7612 = (0);
var G__7613 = (0);
seq__7509_7587 = G__7610;
chunk__7510_7588 = G__7611;
count__7511_7589 = G__7612;
i__7512_7590 = G__7613;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_7526,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"do","do",46310725),(function (p__7614){
var map__7615 = p__7614;
var map__7615__$1 = cljs.core.__destructure_map(map__7615);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7615__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7615__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7615__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__7616_7620 = cljs.core.seq(statements);
var chunk__7617_7621 = null;
var count__7618_7622 = (0);
var i__7619_7623 = (0);
while(true){
if((i__7619_7623 < count__7618_7622)){
var s_7624 = chunk__7617_7621.cljs$core$IIndexed$_nth$arity$2(null,i__7619_7623);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_7624);


var G__7625 = seq__7616_7620;
var G__7626 = chunk__7617_7621;
var G__7627 = count__7618_7622;
var G__7628 = (i__7619_7623 + (1));
seq__7616_7620 = G__7625;
chunk__7617_7621 = G__7626;
count__7618_7622 = G__7627;
i__7619_7623 = G__7628;
continue;
} else {
var temp__5804__auto___7629 = cljs.core.seq(seq__7616_7620);
if(temp__5804__auto___7629){
var seq__7616_7630__$1 = temp__5804__auto___7629;
if(cljs.core.chunked_seq_QMARK_(seq__7616_7630__$1)){
var c__5568__auto___7631 = cljs.core.chunk_first(seq__7616_7630__$1);
var G__7632 = cljs.core.chunk_rest(seq__7616_7630__$1);
var G__7633 = c__5568__auto___7631;
var G__7634 = cljs.core.count(c__5568__auto___7631);
var G__7635 = (0);
seq__7616_7620 = G__7632;
chunk__7617_7621 = G__7633;
count__7618_7622 = G__7634;
i__7619_7623 = G__7635;
continue;
} else {
var s_7636 = cljs.core.first(seq__7616_7630__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_7636);


var G__7637 = cljs.core.next(seq__7616_7630__$1);
var G__7638 = null;
var G__7639 = (0);
var G__7640 = (0);
seq__7616_7620 = G__7637;
chunk__7617_7621 = G__7638;
count__7618_7622 = G__7639;
i__7619_7623 = G__7640;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__7641){
var map__7642 = p__7641;
var map__7642__$1 = cljs.core.__destructure_map(map__7642);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7642__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7642__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7642__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7642__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7642__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__5045__auto__ = name;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"const","const",1709929842),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote(finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__7643,is_loop){
var map__7644 = p__7643;
var map__7644__$1 = cljs.core.__destructure_map(map__7644);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7644__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7644__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7644__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__7645_7655 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__7646_7656 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__7646_7656);

try{var seq__7647_7657 = cljs.core.seq(bindings);
var chunk__7648_7658 = null;
var count__7649_7659 = (0);
var i__7650_7660 = (0);
while(true){
if((i__7650_7660 < count__7649_7659)){
var map__7653_7661 = chunk__7648_7658.cljs$core$IIndexed$_nth$arity$2(null,i__7650_7660);
var map__7653_7662__$1 = cljs.core.__destructure_map(map__7653_7661);
var binding_7663 = map__7653_7662__$1;
var init_7664 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7653_7662__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_7663);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_7664,";");


var G__7665 = seq__7647_7657;
var G__7666 = chunk__7648_7658;
var G__7667 = count__7649_7659;
var G__7668 = (i__7650_7660 + (1));
seq__7647_7657 = G__7665;
chunk__7648_7658 = G__7666;
count__7649_7659 = G__7667;
i__7650_7660 = G__7668;
continue;
} else {
var temp__5804__auto___7669 = cljs.core.seq(seq__7647_7657);
if(temp__5804__auto___7669){
var seq__7647_7670__$1 = temp__5804__auto___7669;
if(cljs.core.chunked_seq_QMARK_(seq__7647_7670__$1)){
var c__5568__auto___7671 = cljs.core.chunk_first(seq__7647_7670__$1);
var G__7672 = cljs.core.chunk_rest(seq__7647_7670__$1);
var G__7673 = c__5568__auto___7671;
var G__7674 = cljs.core.count(c__5568__auto___7671);
var G__7675 = (0);
seq__7647_7657 = G__7672;
chunk__7648_7658 = G__7673;
count__7649_7659 = G__7674;
i__7650_7660 = G__7675;
continue;
} else {
var map__7654_7676 = cljs.core.first(seq__7647_7670__$1);
var map__7654_7677__$1 = cljs.core.__destructure_map(map__7654_7676);
var binding_7678 = map__7654_7677__$1;
var init_7679 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7654_7677__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_7678);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_7679,";");


var G__7680 = cljs.core.next(seq__7647_7670__$1);
var G__7681 = null;
var G__7682 = (0);
var G__7683 = (0);
seq__7647_7657 = G__7680;
chunk__7648_7658 = G__7681;
count__7649_7659 = G__7682;
i__7650_7660 = G__7683;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__7645_7655);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__7684){
var map__7685 = p__7684;
var map__7685__$1 = cljs.core.__destructure_map(map__7685);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7685__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7685__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7685__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__5636__auto___7686 = cljs.core.count(exprs);
var i_7687 = (0);
while(true){
if((i_7687 < n__5636__auto___7686)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_7687) : temps.call(null,i_7687))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_7687) : exprs.call(null,i_7687)),";");

var G__7688 = (i_7687 + (1));
i_7687 = G__7688;
continue;
} else {
}
break;
}

var n__5636__auto___7689 = cljs.core.count(exprs);
var i_7690 = (0);
while(true){
if((i_7690 < n__5636__auto___7689)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_7690) : params.call(null,i_7690)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_7690) : temps.call(null,i_7690)),";");

var G__7691 = (i_7690 + (1));
i_7690 = G__7691;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__7692){
var map__7693 = p__7692;
var map__7693__$1 = cljs.core.__destructure_map(map__7693);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7693__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7693__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7693__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__7694_7702 = cljs.core.seq(bindings);
var chunk__7695_7703 = null;
var count__7696_7704 = (0);
var i__7697_7705 = (0);
while(true){
if((i__7697_7705 < count__7696_7704)){
var map__7700_7706 = chunk__7695_7703.cljs$core$IIndexed$_nth$arity$2(null,i__7697_7705);
var map__7700_7707__$1 = cljs.core.__destructure_map(map__7700_7706);
var binding_7708 = map__7700_7707__$1;
var init_7709 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7700_7707__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_7708)," = ",init_7709,";");


var G__7710 = seq__7694_7702;
var G__7711 = chunk__7695_7703;
var G__7712 = count__7696_7704;
var G__7713 = (i__7697_7705 + (1));
seq__7694_7702 = G__7710;
chunk__7695_7703 = G__7711;
count__7696_7704 = G__7712;
i__7697_7705 = G__7713;
continue;
} else {
var temp__5804__auto___7714 = cljs.core.seq(seq__7694_7702);
if(temp__5804__auto___7714){
var seq__7694_7715__$1 = temp__5804__auto___7714;
if(cljs.core.chunked_seq_QMARK_(seq__7694_7715__$1)){
var c__5568__auto___7716 = cljs.core.chunk_first(seq__7694_7715__$1);
var G__7717 = cljs.core.chunk_rest(seq__7694_7715__$1);
var G__7718 = c__5568__auto___7716;
var G__7719 = cljs.core.count(c__5568__auto___7716);
var G__7720 = (0);
seq__7694_7702 = G__7717;
chunk__7695_7703 = G__7718;
count__7696_7704 = G__7719;
i__7697_7705 = G__7720;
continue;
} else {
var map__7701_7721 = cljs.core.first(seq__7694_7715__$1);
var map__7701_7722__$1 = cljs.core.__destructure_map(map__7701_7721);
var binding_7723 = map__7701_7722__$1;
var init_7724 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7701_7722__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_7723)," = ",init_7724,";");


var G__7725 = cljs.core.next(seq__7694_7715__$1);
var G__7726 = null;
var G__7727 = (0);
var G__7728 = (0);
seq__7694_7702 = G__7725;
chunk__7695_7703 = G__7726;
count__7696_7704 = G__7727;
i__7697_7705 = G__7728;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__7731){
var map__7732 = p__7731;
var map__7732__$1 = cljs.core.__destructure_map(map__7732);
var expr = map__7732__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7732__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7732__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7732__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__5043__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__5043__auto__)){
var and__5043__auto____$1 = cljs.core.not(new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info));
if(and__5043__auto____$1){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__5043__auto__ = protocol;
if(cljs.core.truth_(and__5043__auto__)){
var and__5043__auto____$1 = tag;
if(cljs.core.truth_(and__5043__auto____$1)){
var or__5045__auto__ = (function (){var and__5043__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__5043__auto____$2)){
var and__5043__auto____$3 = protocol;
if(cljs.core.truth_(and__5043__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__5043__auto____$3;
}
} else {
return and__5043__auto____$2;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var and__5043__auto____$2 = (function (){var or__5045__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__5043__auto____$2)){
var or__5045__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__5045__auto____$1){
return or__5045__auto____$1;
} else {
var and__5043__auto____$3 = (!(cljs.core.set_QMARK_(tag)));
if(and__5043__auto____$3){
var and__5043__auto____$4 = cljs.core.not((function (){var fexpr__7736 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null);
return (fexpr__7736.cljs$core$IFn$_invoke$arity$1 ? fexpr__7736.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__7736.call(null,tag));
})());
if(and__5043__auto____$4){
var temp__5804__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(tag,cljs.core.assoc,new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true)));
if(cljs.core.truth_(temp__5804__auto__)){
var ps = temp__5804__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return and__5043__auto____$4;
}
} else {
return and__5043__auto____$3;
}
}
} else {
return and__5043__auto____$2;
}
}
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$((function (){var fexpr__7737 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null);
return (fexpr__7737.cljs$core$IFn$_invoke$arity$1 ? fexpr__7737.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__7737.call(null,first_arg_tag));
})())));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__5045__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__5045__auto__){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__5045__auto____$1){
return or__5045__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__5045__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__5045__auto__){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = (function (){var temp__5804__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5804__auto__)){
var ns_str = temp__5804__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__5045__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__5045__auto__){
return or__5045__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__7733 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return (arity > mfa);
} else {
return and__5043__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__7729_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__7729_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__7730_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__7730_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7733,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7733,(1),null);
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_7740 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_7740,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_7741 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_7741,args)),(((mfa_7741 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_7741,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__5043__auto__)){
var G__7739 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__7738 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__7738.cljs$core$IFn$_invoke$arity$1 ? fexpr__7738.cljs$core$IFn$_invoke$arity$1(G__7739) : fexpr__7738.call(null,G__7739));
} else {
return and__5043__auto__;
}
})())){
var fprop_7742 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_7742," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_7742,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_7742," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_7742,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__7743){
var map__7744 = p__7743;
var map__7744__$1 = cljs.core.__destructure_map(map__7744);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7744__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7744__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7744__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__7745){
var map__7746 = p__7745;
var map__7746__$1 = cljs.core.__destructure_map(map__7746);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7746__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7746__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7746__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.sublib_select = (function cljs$compiler$sublib_select(sublib){
if(cljs.core.truth_(sublib)){
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(sublib,/\./);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__7747_SHARP_){
return ["['",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__7747_SHARP_),"']"].join('');
}),xs));
} else {
return null;
}
});
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
var vec__7748 = cljs.analyzer.lib_AMPERSAND_sublib(lib);
var lib_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7748,(0),null);
var sublib = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7748,(1),null);
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib_SINGLEQUOTE_));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib_SINGLEQUOTE_));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.sublib_select(sublib),";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__7751 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__7751__$1 = cljs.core.__destructure_map(map__7751);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7751__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7751__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__7752 = options;
var map__7752__$1 = cljs.core.__destructure_map(map__7752);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7752__$1,new cljs.core.Keyword(null,"target","target",253001721));
var nodejs_rt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7752__$1,new cljs.core.Keyword(null,"nodejs-rt","nodejs-rt",-512437071));
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7752__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__7753 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__7759 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__7759__$1 = cljs.core.__destructure_map(map__7759);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7759__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7759__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7753,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7753,(1),null);
var vec__7756 = (function (){var map__7760 = cljs.core.group_by(cljs.analyzer.goog_module_dep_QMARK_,libs_to_load);
var map__7760__$1 = cljs.core.__destructure_map(map__7760);
var goog_modules = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7760__$1,true);
var libs_to_load__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7760__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [goog_modules,libs_to_load__$1], null);
})();
var goog_modules = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7756,(0),null);
var libs_to_load__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7756,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load__$1);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__7761_7805 = cljs.core.seq(libs_to_load__$1);
var chunk__7762_7806 = null;
var count__7763_7807 = (0);
var i__7764_7808 = (0);
while(true){
if((i__7764_7808 < count__7763_7807)){
var lib_7809 = chunk__7762_7806.cljs$core$IIndexed$_nth$arity$2(null,i__7764_7808);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_7809)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_7809),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_7809),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_7809),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_7809),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_7809,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_7809),"');");
}

}
}
}


var G__7810 = seq__7761_7805;
var G__7811 = chunk__7762_7806;
var G__7812 = count__7763_7807;
var G__7813 = (i__7764_7808 + (1));
seq__7761_7805 = G__7810;
chunk__7762_7806 = G__7811;
count__7763_7807 = G__7812;
i__7764_7808 = G__7813;
continue;
} else {
var temp__5804__auto___7814 = cljs.core.seq(seq__7761_7805);
if(temp__5804__auto___7814){
var seq__7761_7815__$1 = temp__5804__auto___7814;
if(cljs.core.chunked_seq_QMARK_(seq__7761_7815__$1)){
var c__5568__auto___7816 = cljs.core.chunk_first(seq__7761_7815__$1);
var G__7817 = cljs.core.chunk_rest(seq__7761_7815__$1);
var G__7818 = c__5568__auto___7816;
var G__7819 = cljs.core.count(c__5568__auto___7816);
var G__7820 = (0);
seq__7761_7805 = G__7817;
chunk__7762_7806 = G__7818;
count__7763_7807 = G__7819;
i__7764_7808 = G__7820;
continue;
} else {
var lib_7821 = cljs.core.first(seq__7761_7815__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_7821)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_7821),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_7821),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_7821),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_7821),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_7821,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_7821),"');");
}

}
}
}


var G__7822 = cljs.core.next(seq__7761_7815__$1);
var G__7823 = null;
var G__7824 = (0);
var G__7825 = (0);
seq__7761_7805 = G__7822;
chunk__7762_7806 = G__7823;
count__7763_7807 = G__7824;
i__7764_7808 = G__7825;
continue;
}
} else {
}
}
break;
}

var seq__7765_7826 = cljs.core.seq(node_libs);
var chunk__7766_7827 = null;
var count__7767_7828 = (0);
var i__7768_7829 = (0);
while(true){
if((i__7768_7829 < count__7767_7828)){
var lib_7830 = chunk__7766_7827.cljs$core$IIndexed$_nth$arity$2(null,i__7768_7829);
var vec__7775_7831 = cljs.analyzer.lib_AMPERSAND_sublib(lib_7830);
var lib_SINGLEQUOTE__7832 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7775_7831,(0),null);
var sublib_7833 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7775_7831,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_7830)," = require('",lib_SINGLEQUOTE__7832,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_7833),";"], 0));


var G__7834 = seq__7765_7826;
var G__7835 = chunk__7766_7827;
var G__7836 = count__7767_7828;
var G__7837 = (i__7768_7829 + (1));
seq__7765_7826 = G__7834;
chunk__7766_7827 = G__7835;
count__7767_7828 = G__7836;
i__7768_7829 = G__7837;
continue;
} else {
var temp__5804__auto___7838 = cljs.core.seq(seq__7765_7826);
if(temp__5804__auto___7838){
var seq__7765_7839__$1 = temp__5804__auto___7838;
if(cljs.core.chunked_seq_QMARK_(seq__7765_7839__$1)){
var c__5568__auto___7840 = cljs.core.chunk_first(seq__7765_7839__$1);
var G__7841 = cljs.core.chunk_rest(seq__7765_7839__$1);
var G__7842 = c__5568__auto___7840;
var G__7843 = cljs.core.count(c__5568__auto___7840);
var G__7844 = (0);
seq__7765_7826 = G__7841;
chunk__7766_7827 = G__7842;
count__7767_7828 = G__7843;
i__7768_7829 = G__7844;
continue;
} else {
var lib_7845 = cljs.core.first(seq__7765_7839__$1);
var vec__7778_7846 = cljs.analyzer.lib_AMPERSAND_sublib(lib_7845);
var lib_SINGLEQUOTE__7847 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7778_7846,(0),null);
var sublib_7848 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7778_7846,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_7845)," = require('",lib_SINGLEQUOTE__7847,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_7848),";"], 0));


var G__7849 = cljs.core.next(seq__7765_7839__$1);
var G__7850 = null;
var G__7851 = (0);
var G__7852 = (0);
seq__7765_7826 = G__7849;
chunk__7766_7827 = G__7850;
count__7767_7828 = G__7851;
i__7768_7829 = G__7852;
continue;
}
} else {
}
}
break;
}

var seq__7781_7853 = cljs.core.seq(goog_modules);
var chunk__7782_7854 = null;
var count__7783_7855 = (0);
var i__7784_7856 = (0);
while(true){
if((i__7784_7856 < count__7783_7855)){
var lib_7857 = chunk__7782_7854.cljs$core$IIndexed$_nth$arity$2(null,i__7784_7856);
var vec__7791_7858 = cljs.analyzer.lib_AMPERSAND_sublib(lib_7857);
var lib_SINGLEQUOTE__7859 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7791_7858,(0),null);
var sublib_7860 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7791_7858,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",lib_SINGLEQUOTE__7859,"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.scope(function(){");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_goog_module_lib.cljs$core$IFn$_invoke$arity$1(lib_7857)," = goog.module.get('",lib_SINGLEQUOTE__7859,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_7860),";"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");


var G__7861 = seq__7781_7853;
var G__7862 = chunk__7782_7854;
var G__7863 = count__7783_7855;
var G__7864 = (i__7784_7856 + (1));
seq__7781_7853 = G__7861;
chunk__7782_7854 = G__7862;
count__7783_7855 = G__7863;
i__7784_7856 = G__7864;
continue;
} else {
var temp__5804__auto___7865 = cljs.core.seq(seq__7781_7853);
if(temp__5804__auto___7865){
var seq__7781_7866__$1 = temp__5804__auto___7865;
if(cljs.core.chunked_seq_QMARK_(seq__7781_7866__$1)){
var c__5568__auto___7867 = cljs.core.chunk_first(seq__7781_7866__$1);
var G__7868 = cljs.core.chunk_rest(seq__7781_7866__$1);
var G__7869 = c__5568__auto___7867;
var G__7870 = cljs.core.count(c__5568__auto___7867);
var G__7871 = (0);
seq__7781_7853 = G__7868;
chunk__7782_7854 = G__7869;
count__7783_7855 = G__7870;
i__7784_7856 = G__7871;
continue;
} else {
var lib_7872 = cljs.core.first(seq__7781_7866__$1);
var vec__7794_7873 = cljs.analyzer.lib_AMPERSAND_sublib(lib_7872);
var lib_SINGLEQUOTE__7874 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7794_7873,(0),null);
var sublib_7875 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7794_7873,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",lib_SINGLEQUOTE__7874,"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.scope(function(){");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_goog_module_lib.cljs$core$IFn$_invoke$arity$1(lib_7872)," = goog.module.get('",lib_SINGLEQUOTE__7874,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_7875),";"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");


var G__7876 = cljs.core.next(seq__7781_7866__$1);
var G__7877 = null;
var G__7878 = (0);
var G__7879 = (0);
seq__7781_7853 = G__7876;
chunk__7782_7854 = G__7877;
count__7783_7855 = G__7878;
i__7784_7856 = G__7879;
continue;
}
} else {
}
}
break;
}

var seq__7797_7880 = cljs.core.seq(global_exports_libs);
var chunk__7798_7881 = null;
var count__7799_7882 = (0);
var i__7800_7883 = (0);
while(true){
if((i__7800_7883 < count__7799_7882)){
var lib_7884 = chunk__7798_7881.cljs$core$IIndexed$_nth$arity$2(null,i__7800_7883);
var map__7803_7885 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_7884))));
var map__7803_7886__$1 = cljs.core.__destructure_map(map__7803_7885);
var global_exports_7887 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7803_7886__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_7887,lib_7884);


var G__7888 = seq__7797_7880;
var G__7889 = chunk__7798_7881;
var G__7890 = count__7799_7882;
var G__7891 = (i__7800_7883 + (1));
seq__7797_7880 = G__7888;
chunk__7798_7881 = G__7889;
count__7799_7882 = G__7890;
i__7800_7883 = G__7891;
continue;
} else {
var temp__5804__auto___7892 = cljs.core.seq(seq__7797_7880);
if(temp__5804__auto___7892){
var seq__7797_7893__$1 = temp__5804__auto___7892;
if(cljs.core.chunked_seq_QMARK_(seq__7797_7893__$1)){
var c__5568__auto___7894 = cljs.core.chunk_first(seq__7797_7893__$1);
var G__7895 = cljs.core.chunk_rest(seq__7797_7893__$1);
var G__7896 = c__5568__auto___7894;
var G__7897 = cljs.core.count(c__5568__auto___7894);
var G__7898 = (0);
seq__7797_7880 = G__7895;
chunk__7798_7881 = G__7896;
count__7799_7882 = G__7897;
i__7800_7883 = G__7898;
continue;
} else {
var lib_7899 = cljs.core.first(seq__7797_7893__$1);
var map__7804_7900 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_7899))));
var map__7804_7901__$1 = cljs.core.__destructure_map(map__7804_7900);
var global_exports_7902 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7804_7901__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_7902,lib_7899);


var G__7903 = cljs.core.next(seq__7797_7893__$1);
var G__7904 = null;
var G__7905 = (0);
var G__7906 = (0);
seq__7797_7880 = G__7903;
chunk__7798_7881 = G__7904;
count__7799_7882 = G__7905;
i__7800_7883 = G__7906;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__7907){
var map__7908 = p__7907;
var map__7908__$1 = cljs.core.__destructure_map(map__7908);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7908__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7908__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7908__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7908__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7908__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7908__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7908__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__7909){
var map__7910 = p__7909;
var map__7910__$1 = cljs.core.__destructure_map(map__7910);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7910__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7910__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7910__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7910__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7910__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7910__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7910__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__7911){
var map__7912 = p__7911;
var map__7912__$1 = cljs.core.__destructure_map(map__7912);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7912__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7912__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7912__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7912__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7912__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__7913_7937 = cljs.core.seq(protocols);
var chunk__7914_7938 = null;
var count__7915_7939 = (0);
var i__7916_7940 = (0);
while(true){
if((i__7916_7940 < count__7915_7939)){
var protocol_7941 = chunk__7914_7938.cljs$core$IIndexed$_nth$arity$2(null,i__7916_7940);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7941)),"}");


var G__7942 = seq__7913_7937;
var G__7943 = chunk__7914_7938;
var G__7944 = count__7915_7939;
var G__7945 = (i__7916_7940 + (1));
seq__7913_7937 = G__7942;
chunk__7914_7938 = G__7943;
count__7915_7939 = G__7944;
i__7916_7940 = G__7945;
continue;
} else {
var temp__5804__auto___7946 = cljs.core.seq(seq__7913_7937);
if(temp__5804__auto___7946){
var seq__7913_7947__$1 = temp__5804__auto___7946;
if(cljs.core.chunked_seq_QMARK_(seq__7913_7947__$1)){
var c__5568__auto___7948 = cljs.core.chunk_first(seq__7913_7947__$1);
var G__7949 = cljs.core.chunk_rest(seq__7913_7947__$1);
var G__7950 = c__5568__auto___7948;
var G__7951 = cljs.core.count(c__5568__auto___7948);
var G__7952 = (0);
seq__7913_7937 = G__7949;
chunk__7914_7938 = G__7950;
count__7915_7939 = G__7951;
i__7916_7940 = G__7952;
continue;
} else {
var protocol_7953 = cljs.core.first(seq__7913_7947__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7953)),"}");


var G__7954 = cljs.core.next(seq__7913_7947__$1);
var G__7955 = null;
var G__7956 = (0);
var G__7957 = (0);
seq__7913_7937 = G__7954;
chunk__7914_7938 = G__7955;
count__7915_7939 = G__7956;
i__7916_7940 = G__7957;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__7917_7958 = cljs.core.seq(fields__$1);
var chunk__7918_7959 = null;
var count__7919_7960 = (0);
var i__7920_7961 = (0);
while(true){
if((i__7920_7961 < count__7919_7960)){
var fld_7962 = chunk__7918_7959.cljs$core$IIndexed$_nth$arity$2(null,i__7920_7961);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_7962," = ",fld_7962,";");


var G__7963 = seq__7917_7958;
var G__7964 = chunk__7918_7959;
var G__7965 = count__7919_7960;
var G__7966 = (i__7920_7961 + (1));
seq__7917_7958 = G__7963;
chunk__7918_7959 = G__7964;
count__7919_7960 = G__7965;
i__7920_7961 = G__7966;
continue;
} else {
var temp__5804__auto___7967 = cljs.core.seq(seq__7917_7958);
if(temp__5804__auto___7967){
var seq__7917_7968__$1 = temp__5804__auto___7967;
if(cljs.core.chunked_seq_QMARK_(seq__7917_7968__$1)){
var c__5568__auto___7969 = cljs.core.chunk_first(seq__7917_7968__$1);
var G__7970 = cljs.core.chunk_rest(seq__7917_7968__$1);
var G__7971 = c__5568__auto___7969;
var G__7972 = cljs.core.count(c__5568__auto___7969);
var G__7973 = (0);
seq__7917_7958 = G__7970;
chunk__7918_7959 = G__7971;
count__7919_7960 = G__7972;
i__7920_7961 = G__7973;
continue;
} else {
var fld_7974 = cljs.core.first(seq__7917_7968__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_7974," = ",fld_7974,";");


var G__7975 = cljs.core.next(seq__7917_7968__$1);
var G__7976 = null;
var G__7977 = (0);
var G__7978 = (0);
seq__7917_7958 = G__7975;
chunk__7918_7959 = G__7976;
count__7919_7960 = G__7977;
i__7920_7961 = G__7978;
continue;
}
} else {
}
}
break;
}

var seq__7921_7979 = cljs.core.seq(pmasks);
var chunk__7922_7980 = null;
var count__7923_7981 = (0);
var i__7924_7982 = (0);
while(true){
if((i__7924_7982 < count__7923_7981)){
var vec__7931_7983 = chunk__7922_7980.cljs$core$IIndexed$_nth$arity$2(null,i__7924_7982);
var pno_7984 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7931_7983,(0),null);
var pmask_7985 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7931_7983,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_7984,"$ = ",pmask_7985,";");


var G__7986 = seq__7921_7979;
var G__7987 = chunk__7922_7980;
var G__7988 = count__7923_7981;
var G__7989 = (i__7924_7982 + (1));
seq__7921_7979 = G__7986;
chunk__7922_7980 = G__7987;
count__7923_7981 = G__7988;
i__7924_7982 = G__7989;
continue;
} else {
var temp__5804__auto___7990 = cljs.core.seq(seq__7921_7979);
if(temp__5804__auto___7990){
var seq__7921_7991__$1 = temp__5804__auto___7990;
if(cljs.core.chunked_seq_QMARK_(seq__7921_7991__$1)){
var c__5568__auto___7992 = cljs.core.chunk_first(seq__7921_7991__$1);
var G__7993 = cljs.core.chunk_rest(seq__7921_7991__$1);
var G__7994 = c__5568__auto___7992;
var G__7995 = cljs.core.count(c__5568__auto___7992);
var G__7996 = (0);
seq__7921_7979 = G__7993;
chunk__7922_7980 = G__7994;
count__7923_7981 = G__7995;
i__7924_7982 = G__7996;
continue;
} else {
var vec__7934_7997 = cljs.core.first(seq__7921_7991__$1);
var pno_7998 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7934_7997,(0),null);
var pmask_7999 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7934_7997,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_7998,"$ = ",pmask_7999,";");


var G__8000 = cljs.core.next(seq__7921_7991__$1);
var G__8001 = null;
var G__8002 = (0);
var G__8003 = (0);
seq__7921_7979 = G__8000;
chunk__7922_7980 = G__8001;
count__7923_7981 = G__8002;
i__7924_7982 = G__8003;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__8004){
var map__8005 = p__8004;
var map__8005__$1 = cljs.core.__destructure_map(map__8005);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8005__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8005__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8005__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8005__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8005__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__8006_8030 = cljs.core.seq(protocols);
var chunk__8007_8031 = null;
var count__8008_8032 = (0);
var i__8009_8033 = (0);
while(true){
if((i__8009_8033 < count__8008_8032)){
var protocol_8034 = chunk__8007_8031.cljs$core$IIndexed$_nth$arity$2(null,i__8009_8033);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_8034)),"}");


var G__8035 = seq__8006_8030;
var G__8036 = chunk__8007_8031;
var G__8037 = count__8008_8032;
var G__8038 = (i__8009_8033 + (1));
seq__8006_8030 = G__8035;
chunk__8007_8031 = G__8036;
count__8008_8032 = G__8037;
i__8009_8033 = G__8038;
continue;
} else {
var temp__5804__auto___8039 = cljs.core.seq(seq__8006_8030);
if(temp__5804__auto___8039){
var seq__8006_8040__$1 = temp__5804__auto___8039;
if(cljs.core.chunked_seq_QMARK_(seq__8006_8040__$1)){
var c__5568__auto___8041 = cljs.core.chunk_first(seq__8006_8040__$1);
var G__8042 = cljs.core.chunk_rest(seq__8006_8040__$1);
var G__8043 = c__5568__auto___8041;
var G__8044 = cljs.core.count(c__5568__auto___8041);
var G__8045 = (0);
seq__8006_8030 = G__8042;
chunk__8007_8031 = G__8043;
count__8008_8032 = G__8044;
i__8009_8033 = G__8045;
continue;
} else {
var protocol_8046 = cljs.core.first(seq__8006_8040__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_8046)),"}");


var G__8047 = cljs.core.next(seq__8006_8040__$1);
var G__8048 = null;
var G__8049 = (0);
var G__8050 = (0);
seq__8006_8030 = G__8047;
chunk__8007_8031 = G__8048;
count__8008_8032 = G__8049;
i__8009_8033 = G__8050;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__8010_8051 = cljs.core.seq(fields__$1);
var chunk__8011_8052 = null;
var count__8012_8053 = (0);
var i__8013_8054 = (0);
while(true){
if((i__8013_8054 < count__8012_8053)){
var fld_8055 = chunk__8011_8052.cljs$core$IIndexed$_nth$arity$2(null,i__8013_8054);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_8055," = ",fld_8055,";");


var G__8056 = seq__8010_8051;
var G__8057 = chunk__8011_8052;
var G__8058 = count__8012_8053;
var G__8059 = (i__8013_8054 + (1));
seq__8010_8051 = G__8056;
chunk__8011_8052 = G__8057;
count__8012_8053 = G__8058;
i__8013_8054 = G__8059;
continue;
} else {
var temp__5804__auto___8060 = cljs.core.seq(seq__8010_8051);
if(temp__5804__auto___8060){
var seq__8010_8061__$1 = temp__5804__auto___8060;
if(cljs.core.chunked_seq_QMARK_(seq__8010_8061__$1)){
var c__5568__auto___8062 = cljs.core.chunk_first(seq__8010_8061__$1);
var G__8063 = cljs.core.chunk_rest(seq__8010_8061__$1);
var G__8064 = c__5568__auto___8062;
var G__8065 = cljs.core.count(c__5568__auto___8062);
var G__8066 = (0);
seq__8010_8051 = G__8063;
chunk__8011_8052 = G__8064;
count__8012_8053 = G__8065;
i__8013_8054 = G__8066;
continue;
} else {
var fld_8067 = cljs.core.first(seq__8010_8061__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_8067," = ",fld_8067,";");


var G__8068 = cljs.core.next(seq__8010_8061__$1);
var G__8069 = null;
var G__8070 = (0);
var G__8071 = (0);
seq__8010_8051 = G__8068;
chunk__8011_8052 = G__8069;
count__8012_8053 = G__8070;
i__8013_8054 = G__8071;
continue;
}
} else {
}
}
break;
}

var seq__8014_8072 = cljs.core.seq(pmasks);
var chunk__8015_8073 = null;
var count__8016_8074 = (0);
var i__8017_8075 = (0);
while(true){
if((i__8017_8075 < count__8016_8074)){
var vec__8024_8076 = chunk__8015_8073.cljs$core$IIndexed$_nth$arity$2(null,i__8017_8075);
var pno_8077 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8024_8076,(0),null);
var pmask_8078 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8024_8076,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_8077,"$ = ",pmask_8078,";");


var G__8079 = seq__8014_8072;
var G__8080 = chunk__8015_8073;
var G__8081 = count__8016_8074;
var G__8082 = (i__8017_8075 + (1));
seq__8014_8072 = G__8079;
chunk__8015_8073 = G__8080;
count__8016_8074 = G__8081;
i__8017_8075 = G__8082;
continue;
} else {
var temp__5804__auto___8083 = cljs.core.seq(seq__8014_8072);
if(temp__5804__auto___8083){
var seq__8014_8084__$1 = temp__5804__auto___8083;
if(cljs.core.chunked_seq_QMARK_(seq__8014_8084__$1)){
var c__5568__auto___8085 = cljs.core.chunk_first(seq__8014_8084__$1);
var G__8086 = cljs.core.chunk_rest(seq__8014_8084__$1);
var G__8087 = c__5568__auto___8085;
var G__8088 = cljs.core.count(c__5568__auto___8085);
var G__8089 = (0);
seq__8014_8072 = G__8086;
chunk__8015_8073 = G__8087;
count__8016_8074 = G__8088;
i__8017_8075 = G__8089;
continue;
} else {
var vec__8027_8090 = cljs.core.first(seq__8014_8084__$1);
var pno_8091 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8027_8090,(0),null);
var pmask_8092 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8027_8090,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_8091,"$ = ",pmask_8092,";");


var G__8093 = cljs.core.next(seq__8014_8084__$1);
var G__8094 = null;
var G__8095 = (0);
var G__8096 = (0);
seq__8014_8072 = G__8093;
chunk__8015_8073 = G__8094;
count__8016_8074 = G__8095;
i__8017_8075 = G__8096;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__8097){
var map__8098 = p__8097;
var map__8098__$1 = cljs.core.__destructure_map(map__8098);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8098__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8098__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8098__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8098__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8098__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__8099){
var map__8100 = p__8099;
var map__8100__$1 = cljs.core.__destructure_map(map__8100);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8100__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8100__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8100__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8100__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8100__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__5043__auto__ = code;
if(cljs.core.truth_(and__5043__auto__)){
return goog.string.startsWith(clojure.string.trim(code),"/*");
} else {
return and__5043__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__9256__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__9256__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__8105 = cljs.core.seq(table);
var chunk__8106 = null;
var count__8107 = (0);
var i__8108 = (0);
while(true){
if((i__8108 < count__8107)){
var vec__8115 = chunk__8106.cljs$core$IIndexed$_nth$arity$2(null,i__8108);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8115,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8115,(1),null);
var ns_8121 = cljs.core.namespace(sym);
var name_8122 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__8123 = seq__8105;
var G__8124 = chunk__8106;
var G__8125 = count__8107;
var G__8126 = (i__8108 + (1));
seq__8105 = G__8123;
chunk__8106 = G__8124;
count__8107 = G__8125;
i__8108 = G__8126;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__8105);
if(temp__5804__auto__){
var seq__8105__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__8105__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__8105__$1);
var G__8127 = cljs.core.chunk_rest(seq__8105__$1);
var G__8128 = c__5568__auto__;
var G__8129 = cljs.core.count(c__5568__auto__);
var G__8130 = (0);
seq__8105 = G__8127;
chunk__8106 = G__8128;
count__8107 = G__8129;
i__8108 = G__8130;
continue;
} else {
var vec__8118 = cljs.core.first(seq__8105__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8118,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8118,(1),null);
var ns_8131 = cljs.core.namespace(sym);
var name_8132 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__8133 = cljs.core.next(seq__8105__$1);
var G__8134 = null;
var G__8135 = (0);
var G__8136 = (0);
seq__8105 = G__8133;
chunk__8106 = G__8134;
count__8107 = G__8135;
i__8108 = G__8136;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__8138 = arguments.length;
switch (G__8138) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.analyzer.get_externs():null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_8143 = cljs.core.first(ks);
var vec__8139_8144 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_8143);
var top_8145 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8139_8144,(0),null);
var prefix_SINGLEQUOTE__8146 = vec__8139_8144;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_8143)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__8146) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_8145)) || (cljs.core.contains_QMARK_(known_externs,top_8145)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__8146)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_8145);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__8146)),";");
}
} else {
}

var m_8147 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_8143);
if(cljs.core.empty_QMARK_(m_8147)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__8146,m_8147,top_level,known_externs);
}

var G__8148 = cljs.core.next(ks);
ks = G__8148;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

