// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.dbfunctions.ctx');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__72208 = arguments.length;
switch (G__72208) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5802__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var block = temp__5802__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2706__auto___72247 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_72229){
var state_val_72230 = (state_72229[(1)]);
if((state_val_72230 === (1))){
var state_72229__$1 = state_72229;
var statearr_72231_72248 = state_72229__$1;
(statearr_72231_72248[(2)] = null);

(statearr_72231_72248[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72230 === (2))){
var _ = (function (){var statearr_72232 = state_72229;
(statearr_72232[(4)] = cljs.core.cons((5),(state_72229[(4)])));

return statearr_72232;
})();
var inst_72215 = fluree.db.session.db(conn,ledger,null);
var state_72229__$1 = state_72229;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72229__$1,(7),inst_72215);
} else {
if((state_val_72230 === (3))){
var inst_72225 = (state_72229[(2)]);
var inst_72226 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_72225);
var inst_72227 = cljs.core.async.close_BANG_(pc);
var state_72229__$1 = (function (){var statearr_72234 = state_72229;
(statearr_72234[(7)] = inst_72226);

return statearr_72234;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_72229__$1,inst_72227);
} else {
if((state_val_72230 === (4))){
var inst_72209 = (state_72229[(2)]);
var state_72229__$1 = state_72229;
var statearr_72235_72249 = state_72229__$1;
(statearr_72235_72249[(2)] = inst_72209);

(statearr_72235_72249[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72230 === (5))){
var _ = (function (){var statearr_72236 = state_72229;
(statearr_72236[(4)] = cljs.core.rest((state_72229[(4)])));

return statearr_72236;
})();
var state_72229__$1 = state_72229;
var ex72233 = (state_72229__$1[(2)]);
var statearr_72237_72250 = state_72229__$1;
(statearr_72237_72250[(5)] = ex72233);


var statearr_72238_72251 = state_72229__$1;
(statearr_72238_72251[(1)] = (4));

(statearr_72238_72251[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72230 === (6))){
var inst_72221 = (state_72229[(2)]);
var inst_72222 = fluree.db.util.async.throw_err(inst_72221);
var _ = (function (){var statearr_72239 = state_72229;
(statearr_72239[(4)] = cljs.core.rest((state_72229[(4)])));

return statearr_72239;
})();
var state_72229__$1 = state_72229;
var statearr_72240_72252 = state_72229__$1;
(statearr_72240_72252[(2)] = inst_72222);

(statearr_72240_72252[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72230 === (7))){
var inst_72217 = (state_72229[(2)]);
var inst_72218 = fluree.db.util.async.throw_err(inst_72217);
var inst_72219 = fluree.db.time_travel.as_of_block(inst_72218,block);
var state_72229__$1 = state_72229;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72229__$1,(6),inst_72219);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2684__auto__ = null;
var fluree$db$api$ledger$state_machine__2684__auto____0 = (function (){
var statearr_72241 = [null,null,null,null,null,null,null,null];
(statearr_72241[(0)] = fluree$db$api$ledger$state_machine__2684__auto__);

(statearr_72241[(1)] = (1));

return statearr_72241;
});
var fluree$db$api$ledger$state_machine__2684__auto____1 = (function (state_72229){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_72229);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e72242){var ex__2687__auto__ = e72242;
var statearr_72243_72253 = state_72229;
(statearr_72243_72253[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_72229[(4)]))){
var statearr_72244_72254 = state_72229;
(statearr_72244_72254[(1)] = cljs.core.first((state_72229[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72255 = state_72229;
state_72229 = G__72255;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2684__auto__ = function(state_72229){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2684__auto____1.call(this,state_72229);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2684__auto____0;
fluree$db$api$ledger$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2684__auto____1;
return fluree$db$api$ledger$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_72245 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_72245[(6)] = c__2706__auto___72247);

return statearr_72245;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t(db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_72296){
var state_val_72297 = (state_72296[(1)]);
if((state_val_72297 === (7))){
var inst_72265 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_72296__$1 = state_72296;
if(inst_72265){
var statearr_72298_72329 = state_72296__$1;
(statearr_72298_72329[(1)] = (9));

} else {
var statearr_72299_72330 = state_72296__$1;
(statearr_72299_72330[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72297 === (1))){
var state_72296__$1 = state_72296;
var statearr_72300_72331 = state_72296__$1;
(statearr_72300_72331[(2)] = null);

(statearr_72300_72331[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72297 === (4))){
var inst_72256 = (state_72296[(2)]);
var state_72296__$1 = state_72296;
var statearr_72301_72332 = state_72296__$1;
(statearr_72301_72332[(2)] = inst_72256);

(statearr_72301_72332[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72297 === (15))){
var inst_72273 = (state_72296[(7)]);
var inst_72272 = (state_72296[(2)]);
var inst_72273__$1 = fluree.db.util.async.throw_err(inst_72272);
var state_72296__$1 = (function (){var statearr_72302 = state_72296;
(statearr_72302[(7)] = inst_72273__$1);

return statearr_72302;
})();
if(cljs.core.truth_(inst_72273__$1)){
var statearr_72303_72333 = state_72296__$1;
(statearr_72303_72333[(1)] = (16));

} else {
var statearr_72304_72334 = state_72296__$1;
(statearr_72304_72334[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72297 === (13))){
var state_72296__$1 = state_72296;
var statearr_72305_72335 = state_72296__$1;
(statearr_72305_72335[(2)] = null);

(statearr_72305_72335[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72297 === (6))){
var state_72296__$1 = state_72296;
var statearr_72306_72336 = state_72296__$1;
(statearr_72306_72336[(2)] = db);

(statearr_72306_72336[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72297 === (17))){
var inst_72277 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_72278 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72279 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_72280 = cljs.core.PersistentHashMap.fromArrays(inst_72278,inst_72279);
var inst_72281 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_72277,inst_72280);
var inst_72282 = (function(){throw inst_72281})();
var state_72296__$1 = state_72296;
var statearr_72307_72337 = state_72296__$1;
(statearr_72307_72337[(2)] = inst_72282);

(statearr_72307_72337[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72297 === (3))){
var inst_72294 = (state_72296[(2)]);
var state_72296__$1 = state_72296;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72296__$1,inst_72294);
} else {
if((state_val_72297 === (12))){
var inst_72270 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_72296__$1 = state_72296;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72296__$1,(15),inst_72270);
} else {
if((state_val_72297 === (2))){
var _ = (function (){var statearr_72308 = state_72296;
(statearr_72308[(4)] = cljs.core.cons((5),(state_72296[(4)])));

return statearr_72308;
})();
var inst_72262 = cljs.core.not(auth);
var state_72296__$1 = state_72296;
if(inst_72262){
var statearr_72309_72338 = state_72296__$1;
(statearr_72309_72338[(1)] = (6));

} else {
var statearr_72310_72339 = state_72296__$1;
(statearr_72310_72339[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72297 === (11))){
var inst_72289 = (state_72296[(2)]);
var state_72296__$1 = state_72296;
var statearr_72312_72340 = state_72296__$1;
(statearr_72312_72340[(2)] = inst_72289);

(statearr_72312_72340[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72297 === (9))){
var inst_72267 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_72296__$1 = state_72296;
var statearr_72313_72341 = state_72296__$1;
(statearr_72313_72341[(2)] = inst_72267);

(statearr_72313_72341[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72297 === (5))){
var _ = (function (){var statearr_72314 = state_72296;
(statearr_72314[(4)] = cljs.core.rest((state_72296[(4)])));

return statearr_72314;
})();
var state_72296__$1 = state_72296;
var ex72311 = (state_72296__$1[(2)]);
var statearr_72315_72342 = state_72296__$1;
(statearr_72315_72342[(5)] = ex72311);


if((ex72311 instanceof Error)){
var statearr_72316_72343 = state_72296__$1;
(statearr_72316_72343[(1)] = (4));

(statearr_72316_72343[(5)] = null);

} else {
throw ex72311;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72297 === (14))){
var inst_72287 = (state_72296[(2)]);
var state_72296__$1 = state_72296;
var statearr_72317_72344 = state_72296__$1;
(statearr_72317_72344[(2)] = inst_72287);

(statearr_72317_72344[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72297 === (16))){
var inst_72273 = (state_72296[(7)]);
var inst_72275 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_72273);
var state_72296__$1 = state_72296;
var statearr_72318_72345 = state_72296__$1;
(statearr_72318_72345[(2)] = inst_72275);

(statearr_72318_72345[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72297 === (10))){
var state_72296__$1 = state_72296;
var statearr_72319_72346 = state_72296__$1;
(statearr_72319_72346[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72297 === (18))){
var inst_72284 = (state_72296[(2)]);
var state_72296__$1 = state_72296;
var statearr_72321_72347 = state_72296__$1;
(statearr_72321_72347[(2)] = inst_72284);

(statearr_72321_72347[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72297 === (8))){
var inst_72291 = (state_72296[(2)]);
var _ = (function (){var statearr_72322 = state_72296;
(statearr_72322[(4)] = cljs.core.rest((state_72296[(4)])));

return statearr_72322;
})();
var state_72296__$1 = state_72296;
var statearr_72323_72348 = state_72296__$1;
(statearr_72323_72348[(2)] = inst_72291);

(statearr_72323_72348[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____0 = (function (){
var statearr_72324 = [null,null,null,null,null,null,null,null];
(statearr_72324[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__);

(statearr_72324[(1)] = (1));

return statearr_72324;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____1 = (function (state_72296){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_72296);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e72325){var ex__2687__auto__ = e72325;
var statearr_72326_72349 = state_72296;
(statearr_72326_72349[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_72296[(4)]))){
var statearr_72327_72350 = state_72296;
(statearr_72327_72350[(1)] = cljs.core.first((state_72296[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72351 = state_72296;
state_72296 = G__72351;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__ = function(state_72296){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____1.call(this,state_72296);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_72328 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_72328[(6)] = c__2706__auto__);

return statearr_72328;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_72423){
var state_val_72424 = (state_72423[(1)]);
if((state_val_72424 === (7))){
var inst_72361 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_72423__$1 = state_72423;
if(inst_72361){
var statearr_72425_72479 = state_72423__$1;
(statearr_72425_72479[(1)] = (9));

} else {
var statearr_72426_72480 = state_72423__$1;
(statearr_72426_72480[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72424 === (20))){
var inst_72385 = (state_72423[(7)]);
var state_72423__$1 = state_72423;
if(cljs.core.truth_(inst_72385)){
var statearr_72427_72481 = state_72423__$1;
(statearr_72427_72481[(1)] = (22));

} else {
var statearr_72428_72482 = state_72423__$1;
(statearr_72428_72482[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72424 === (27))){
var state_72423__$1 = state_72423;
var statearr_72429_72483 = state_72423__$1;
(statearr_72429_72483[(2)] = null);

(statearr_72429_72483[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72424 === (1))){
var state_72423__$1 = state_72423;
var statearr_72430_72484 = state_72423__$1;
(statearr_72430_72484[(2)] = null);

(statearr_72430_72484[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72424 === (24))){
var inst_72399 = (state_72423[(2)]);
var state_72423__$1 = state_72423;
var statearr_72431_72485 = state_72423__$1;
(statearr_72431_72485[(2)] = inst_72399);

(statearr_72431_72485[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72424 === (4))){
var inst_72352 = (state_72423[(2)]);
var state_72423__$1 = state_72423;
var statearr_72432_72486 = state_72423__$1;
(statearr_72432_72486[(2)] = inst_72352);

(statearr_72432_72486[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72424 === (15))){
var inst_72368 = (state_72423[(8)]);
var inst_72367 = (state_72423[(2)]);
var inst_72368__$1 = fluree.db.util.async.throw_err(inst_72367);
var state_72423__$1 = (function (){var statearr_72433 = state_72423;
(statearr_72433[(8)] = inst_72368__$1);

return statearr_72433;
})();
if(cljs.core.truth_(inst_72368__$1)){
var statearr_72434_72487 = state_72423__$1;
(statearr_72434_72487[(1)] = (16));

} else {
var statearr_72435_72488 = state_72423__$1;
(statearr_72435_72488[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72424 === (21))){
var inst_72401 = (state_72423[(9)]);
var inst_72401__$1 = (state_72423[(2)]);
var state_72423__$1 = (function (){var statearr_72436 = state_72423;
(statearr_72436[(9)] = inst_72401__$1);

return statearr_72436;
})();
if(cljs.core.truth_(inst_72401__$1)){
var statearr_72437_72489 = state_72423__$1;
(statearr_72437_72489[(1)] = (29));

} else {
var statearr_72438_72490 = state_72423__$1;
(statearr_72438_72490[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72424 === (31))){
var inst_72401 = (state_72423[(9)]);
var inst_72409 = (state_72423[(2)]);
var state_72423__$1 = (function (){var statearr_72439 = state_72423;
(statearr_72439[(10)] = inst_72409);

return statearr_72439;
})();
if(cljs.core.truth_(inst_72401)){
var statearr_72440_72491 = state_72423__$1;
(statearr_72440_72491[(1)] = (33));

} else {
var statearr_72441_72492 = state_72423__$1;
(statearr_72441_72492[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72424 === (32))){
var inst_72405 = (state_72423[(2)]);
var inst_72406 = fluree.db.util.async.throw_err(inst_72405);
var state_72423__$1 = state_72423;
var statearr_72442_72493 = state_72423__$1;
(statearr_72442_72493[(2)] = inst_72406);

(statearr_72442_72493[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72424 === (33))){
var inst_72401 = (state_72423[(9)]);
var inst_72411 = fluree.db.permissions.permission_map(db,inst_72401,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_72423__$1 = state_72423;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72423__$1,(36),inst_72411);
} else {
if((state_val_72424 === (13))){
var state_72423__$1 = state_72423;
var statearr_72443_72494 = state_72423__$1;
(statearr_72443_72494[(2)] = null);

(statearr_72443_72494[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72424 === (22))){
var inst_72385 = (state_72423[(7)]);
var inst_72389 = fluree.db.auth.roles(db,inst_72385);
var state_72423__$1 = state_72423;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72423__$1,(25),inst_72389);
} else {
if((state_val_72424 === (36))){
var inst_72413 = (state_72423[(2)]);
var inst_72414 = fluree.db.util.async.throw_err(inst_72413);
var state_72423__$1 = state_72423;
var statearr_72444_72495 = state_72423__$1;
(statearr_72444_72495[(2)] = inst_72414);

(statearr_72444_72495[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72424 === (29))){
var inst_72401 = (state_72423[(9)]);
var inst_72385 = (state_72423[(7)]);
var inst_72403 = fluree.db.dbfunctions.ctx.build(db,inst_72385,inst_72401);
var state_72423__$1 = state_72423;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72423__$1,(32),inst_72403);
} else {
if((state_val_72424 === (6))){
var state_72423__$1 = state_72423;
var statearr_72445_72496 = state_72423__$1;
(statearr_72445_72496[(2)] = null);

(statearr_72445_72496[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72424 === (28))){
var inst_72397 = (state_72423[(2)]);
var state_72423__$1 = state_72423;
var statearr_72446_72497 = state_72423__$1;
(statearr_72446_72497[(2)] = inst_72397);

(statearr_72446_72497[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72424 === (25))){
var inst_72391 = (state_72423[(2)]);
var inst_72392 = fluree.db.util.async.throw_err(inst_72391);
var state_72423__$1 = state_72423;
var statearr_72447_72498 = state_72423__$1;
(statearr_72447_72498[(2)] = inst_72392);

(statearr_72447_72498[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72424 === (34))){
var state_72423__$1 = state_72423;
var statearr_72448_72499 = state_72423__$1;
(statearr_72448_72499[(2)] = null);

(statearr_72448_72499[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72424 === (17))){
var inst_72371 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_72372 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72373 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_72374 = cljs.core.PersistentHashMap.fromArrays(inst_72372,inst_72373);
var inst_72375 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_72371,inst_72374);
var inst_72376 = (function(){throw inst_72375})();
var state_72423__$1 = state_72423;
var statearr_72449_72500 = state_72423__$1;
(statearr_72449_72500[(2)] = inst_72376);

(statearr_72449_72500[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72424 === (3))){
var inst_72421 = (state_72423[(2)]);
var state_72423__$1 = state_72423;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72423__$1,inst_72421);
} else {
if((state_val_72424 === (12))){
var inst_72365 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_72423__$1 = state_72423;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72423__$1,(15),inst_72365);
} else {
if((state_val_72424 === (2))){
var _ = (function (){var statearr_72450 = state_72423;
(statearr_72450[(4)] = cljs.core.cons((5),(state_72423[(4)])));

return statearr_72450;
})();
var inst_72358 = (auth == null);
var state_72423__$1 = state_72423;
if(cljs.core.truth_(inst_72358)){
var statearr_72451_72501 = state_72423__$1;
(statearr_72451_72501[(1)] = (6));

} else {
var statearr_72452_72502 = state_72423__$1;
(statearr_72452_72502[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72424 === (23))){
var state_72423__$1 = state_72423;
var statearr_72453_72503 = state_72423__$1;
(statearr_72453_72503[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72424 === (35))){
var inst_72401 = (state_72423[(9)]);
var inst_72409 = (state_72423[(10)]);
var inst_72385 = (state_72423[(7)]);
var inst_72417 = (state_72423[(2)]);
var inst_72418 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_72385,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"auth-id","auth-id",444160740),auth,new cljs.core.Keyword(null,"roles","roles",143379530),inst_72401,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_72417,new cljs.core.Keyword(null,"ctx","ctx",-493610118),inst_72409], 0));
var _ = (function (){var statearr_72455 = state_72423;
(statearr_72455[(4)] = cljs.core.rest((state_72423[(4)])));

return statearr_72455;
})();
var state_72423__$1 = state_72423;
var statearr_72456_72504 = state_72423__$1;
(statearr_72456_72504[(2)] = inst_72418);

(statearr_72456_72504[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72424 === (19))){
var state_72423__$1 = state_72423;
var statearr_72457_72505 = state_72423__$1;
(statearr_72457_72505[(2)] = roles);

(statearr_72457_72505[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72424 === (11))){
var inst_72383 = (state_72423[(2)]);
var state_72423__$1 = state_72423;
var statearr_72459_72506 = state_72423__$1;
(statearr_72459_72506[(2)] = inst_72383);

(statearr_72459_72506[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72424 === (9))){
var state_72423__$1 = state_72423;
var statearr_72460_72507 = state_72423__$1;
(statearr_72460_72507[(2)] = (0));

(statearr_72460_72507[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72424 === (5))){
var _ = (function (){var statearr_72461 = state_72423;
(statearr_72461[(4)] = cljs.core.rest((state_72423[(4)])));

return statearr_72461;
})();
var state_72423__$1 = state_72423;
var ex72458 = (state_72423__$1[(2)]);
var statearr_72462_72508 = state_72423__$1;
(statearr_72462_72508[(5)] = ex72458);


if((ex72458 instanceof Error)){
var statearr_72463_72509 = state_72423__$1;
(statearr_72463_72509[(1)] = (4));

(statearr_72463_72509[(5)] = null);

} else {
throw ex72458;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72424 === (14))){
var inst_72381 = (state_72423[(2)]);
var state_72423__$1 = state_72423;
var statearr_72464_72510 = state_72423__$1;
(statearr_72464_72510[(2)] = inst_72381);

(statearr_72464_72510[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72424 === (26))){
var state_72423__$1 = state_72423;
var statearr_72465_72511 = state_72423__$1;
(statearr_72465_72511[(2)] = null);

(statearr_72465_72511[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72424 === (16))){
var inst_72368 = (state_72423[(8)]);
var state_72423__$1 = state_72423;
var statearr_72466_72512 = state_72423__$1;
(statearr_72466_72512[(2)] = inst_72368);

(statearr_72466_72512[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72424 === (30))){
var state_72423__$1 = state_72423;
var statearr_72467_72513 = state_72423__$1;
(statearr_72467_72513[(2)] = null);

(statearr_72467_72513[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72424 === (10))){
var state_72423__$1 = state_72423;
if(cljs.core.truth_(auth)){
var statearr_72468_72514 = state_72423__$1;
(statearr_72468_72514[(1)] = (12));

} else {
var statearr_72469_72515 = state_72423__$1;
(statearr_72469_72515[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72424 === (18))){
var inst_72378 = (state_72423[(2)]);
var state_72423__$1 = state_72423;
var statearr_72470_72516 = state_72423__$1;
(statearr_72470_72516[(2)] = inst_72378);

(statearr_72470_72516[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72424 === (8))){
var inst_72385 = (state_72423[(2)]);
var state_72423__$1 = (function (){var statearr_72471 = state_72423;
(statearr_72471[(7)] = inst_72385);

return statearr_72471;
})();
if(cljs.core.truth_(roles)){
var statearr_72472_72517 = state_72423__$1;
(statearr_72472_72517[(1)] = (19));

} else {
var statearr_72473_72518 = state_72423__$1;
(statearr_72473_72518[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____0 = (function (){
var statearr_72474 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_72474[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__);

(statearr_72474[(1)] = (1));

return statearr_72474;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____1 = (function (state_72423){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_72423);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e72475){var ex__2687__auto__ = e72475;
var statearr_72476_72519 = state_72423;
(statearr_72476_72519[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_72423[(4)]))){
var statearr_72477_72520 = state_72423;
(statearr_72477_72520[(1)] = cljs.core.first((state_72423[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72521 = state_72423;
state_72423 = G__72521;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__ = function(state_72423){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____1.call(this,state_72423);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_72478 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_72478[(6)] = c__2706__auto__);

return statearr_72478;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__72522 = db;
var map__72522__$1 = cljs.core.__destructure_map(map__72522);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72522__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72522__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72522__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,ledger_id,listen_id);

var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_72529){
var state_val_72530 = (state_72529[(1)]);
if((state_val_72530 === (1))){
var inst_72523 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_72524 = fluree.db.session.db(conn,inst_72523,null);
var state_72529__$1 = state_72529;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72529__$1,(2),inst_72524);
} else {
if((state_val_72530 === (2))){
var inst_72526 = (state_72529[(2)]);
var inst_72527 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_72526);
var state_72529__$1 = state_72529;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72529__$1,inst_72527);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0 = (function (){
var statearr_72531 = [null,null,null,null,null,null,null];
(statearr_72531[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__);

(statearr_72531[(1)] = (1));

return statearr_72531;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1 = (function (state_72529){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_72529);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e72532){var ex__2687__auto__ = e72532;
var statearr_72533_72560 = state_72529;
(statearr_72533_72560[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_72529[(4)]))){
var statearr_72534_72561 = state_72529;
(statearr_72534_72561[(1)] = cljs.core.first((state_72529[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72562 = state_72529;
state_72529 = G__72562;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__ = function(state_72529){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1.call(this,state_72529);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_72535 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_72535[(6)] = c__2706__auto__);

return statearr_72535;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,ledger_id,listen_id,event_fn);

var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_72548){
var state_val_72549 = (state_72548[(1)]);
if((state_val_72549 === (1))){
var inst_72536 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_72537 = fluree.db.session.db(conn,inst_72536,null);
var state_72548__$1 = state_72548;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72548__$1,(2),inst_72537);
} else {
if((state_val_72549 === (2))){
var inst_72539 = (state_72548[(7)]);
var inst_72539__$1 = (state_72548[(2)]);
var inst_72540 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_72539__$1);
var inst_72541 = newer_block_QMARK_(inst_72540);
var state_72548__$1 = (function (){var statearr_72550 = state_72548;
(statearr_72550[(7)] = inst_72539__$1);

return statearr_72550;
})();
if(inst_72541){
var statearr_72551_72563 = state_72548__$1;
(statearr_72551_72563[(1)] = (3));

} else {
var statearr_72552_72564 = state_72548__$1;
(statearr_72552_72564[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72549 === (3))){
var inst_72539 = (state_72548[(7)]);
var inst_72543 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_72539);
var state_72548__$1 = state_72548;
var statearr_72553_72565 = state_72548__$1;
(statearr_72553_72565[(2)] = inst_72543);

(statearr_72553_72565[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72549 === (4))){
var state_72548__$1 = state_72548;
var statearr_72554_72566 = state_72548__$1;
(statearr_72554_72566[(2)] = null);

(statearr_72554_72566[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72549 === (5))){
var inst_72546 = (state_72548[(2)]);
var state_72548__$1 = state_72548;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72548__$1,inst_72546);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0 = (function (){
var statearr_72555 = [null,null,null,null,null,null,null,null];
(statearr_72555[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__);

(statearr_72555[(1)] = (1));

return statearr_72555;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1 = (function (state_72548){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_72548);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e72556){var ex__2687__auto__ = e72556;
var statearr_72557_72567 = state_72548;
(statearr_72557_72567[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_72548[(4)]))){
var statearr_72558_72568 = state_72548;
(statearr_72558_72568[(1)] = cljs.core.first((state_72548[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72569 = state_72548;
state_72548 = G__72569;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__ = function(state_72548){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1.call(this,state_72548);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_72559 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_72559[(6)] = c__2706__auto__);

return statearr_72559;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__72570 = db;
var map__72570__$1 = cljs.core.__destructure_map(map__72570);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72570__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72570__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72570__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var listen_id = cljs.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__5133__auto__ = syncTimeout;
var y__5134__auto__ = (120000);
return ((x__5133__auto__ < y__5134__auto__) ? x__5133__auto__ : y__5134__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__2706__auto___72646 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_72620){
var state_val_72621 = (state_72620[(1)]);
if((state_val_72621 === (7))){
var inst_72586 = (state_72620[(7)]);
var inst_72597 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_72586,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_72620__$1 = state_72620;
if(inst_72597){
var statearr_72622_72647 = state_72620__$1;
(statearr_72622_72647[(1)] = (9));

} else {
var statearr_72623_72648 = state_72620__$1;
(statearr_72623_72648[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (1))){
var inst_72579 = (state_72620[(8)]);
var inst_72571 = (state_72620[(9)]);
var inst_72571__$1 = cljs.core.async.timeout(timeout);
var inst_72579__$1 = res_port;
var inst_72580 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72581 = [inst_72571__$1,inst_72579__$1];
var inst_72582 = (new cljs.core.PersistentVector(null,2,(5),inst_72580,inst_72581,null));
var state_72620__$1 = (function (){var statearr_72624 = state_72620;
(statearr_72624[(8)] = inst_72579__$1);

(statearr_72624[(9)] = inst_72571__$1);

return statearr_72624;
})();
return cljs.core.async.ioc_alts_BANG_(state_72620__$1,(2),inst_72582);
} else {
if((state_val_72621 === (4))){
var inst_72579 = (state_72620[(8)]);
var inst_72586 = (state_72620[(7)]);
var inst_72590 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_72586,inst_72579);
var state_72620__$1 = state_72620;
if(inst_72590){
var statearr_72625_72649 = state_72620__$1;
(statearr_72625_72649[(1)] = (6));

} else {
var statearr_72626_72650 = state_72620__$1;
(statearr_72626_72650[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (13))){
var inst_72605 = (state_72620[(10)]);
var inst_72616 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_72605);
var state_72620__$1 = state_72620;
var statearr_72627_72651 = state_72620__$1;
(statearr_72627_72651[(2)] = inst_72616);

(statearr_72627_72651[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (6))){
var inst_72584 = (state_72620[(11)]);
var inst_72595 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72584,(0),null);
var state_72620__$1 = state_72620;
var statearr_72628_72652 = state_72620__$1;
(statearr_72628_72652[(2)] = inst_72595);

(statearr_72628_72652[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (3))){
var state_72620__$1 = state_72620;
var statearr_72629_72653 = state_72620__$1;
(statearr_72629_72653[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_72629_72653[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (12))){
var inst_72609 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_72610 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72611 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_72612 = cljs.core.PersistentHashMap.fromArrays(inst_72610,inst_72611);
var inst_72613 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_72609,inst_72612);
var inst_72614 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_72613);
var state_72620__$1 = state_72620;
var statearr_72630_72654 = state_72620__$1;
(statearr_72630_72654[(2)] = inst_72614);

(statearr_72630_72654[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (2))){
var inst_72584 = (state_72620[(11)]);
var inst_72571 = (state_72620[(9)]);
var inst_72586 = (state_72620[(7)]);
var inst_72584__$1 = (state_72620[(2)]);
var inst_72585 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72584__$1,(0),null);
var inst_72586__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72584__$1,(1),null);
var inst_72587 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_72586__$1,inst_72571);
var state_72620__$1 = (function (){var statearr_72631 = state_72620;
(statearr_72631[(12)] = inst_72585);

(statearr_72631[(11)] = inst_72584__$1);

(statearr_72631[(7)] = inst_72586__$1);

return statearr_72631;
})();
if(inst_72587){
var statearr_72632_72655 = state_72620__$1;
(statearr_72632_72655[(1)] = (3));

} else {
var statearr_72633_72656 = state_72620__$1;
(statearr_72633_72656[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (11))){
var inst_72601 = (state_72620[(2)]);
var state_72620__$1 = state_72620;
var statearr_72634_72657 = state_72620__$1;
(statearr_72634_72657[(2)] = inst_72601);

(statearr_72634_72657[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (9))){
var inst_72585 = (state_72620[(12)]);
var state_72620__$1 = state_72620;
var statearr_72635_72658 = state_72620__$1;
(statearr_72635_72658[(2)] = inst_72585);

(statearr_72635_72658[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (5))){
var inst_72605 = (state_72620[(10)]);
var inst_72605__$1 = (state_72620[(2)]);
var inst_72606 = fluree.db.connection.remove_listener(conn,network,ledger_id,listen_id);
var inst_72607 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_72605__$1);
var state_72620__$1 = (function (){var statearr_72636 = state_72620;
(statearr_72636[(13)] = inst_72606);

(statearr_72636[(10)] = inst_72605__$1);

return statearr_72636;
})();
if(inst_72607){
var statearr_72637_72659 = state_72620__$1;
(statearr_72637_72659[(1)] = (12));

} else {
var statearr_72638_72660 = state_72620__$1;
(statearr_72638_72660[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (14))){
var inst_72618 = (state_72620[(2)]);
var state_72620__$1 = state_72620;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72620__$1,inst_72618);
} else {
if((state_val_72621 === (10))){
var state_72620__$1 = state_72620;
var statearr_72639_72661 = state_72620__$1;
(statearr_72639_72661[(2)] = null);

(statearr_72639_72661[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (8))){
var inst_72603 = (state_72620[(2)]);
var state_72620__$1 = state_72620;
var statearr_72640_72662 = state_72620__$1;
(statearr_72640_72662[(2)] = inst_72603);

(statearr_72640_72662[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____0 = (function (){
var statearr_72641 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72641[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__);

(statearr_72641[(1)] = (1));

return statearr_72641;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____1 = (function (state_72620){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_72620);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e72642){var ex__2687__auto__ = e72642;
var statearr_72643_72663 = state_72620;
(statearr_72643_72663[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_72620[(4)]))){
var statearr_72644_72664 = state_72620;
(statearr_72644_72664[(1)] = cljs.core.first((state_72620[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72665 = state_72620;
state_72620 = G__72665;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__ = function(state_72620){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____1.call(this,state_72620);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_72645 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_72645[(6)] = c__2706__auto___72646);

return statearr_72645;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__72667 = arguments.length;
switch (G__72667) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__72668){
var map__72669 = p__72668;
var map__72669__$1 = cljs.core.__destructure_map(map__72669);
var opts = map__72669__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72669__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72669__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72669__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72669__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72669__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2706__auto___72758 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_72720){
var state_val_72721 = (state_72720[(1)]);
if((state_val_72721 === (7))){
var inst_72682 = (state_72720[(7)]);
var inst_72684 = fluree.db.api.ledger.syncTo_db(inst_72682,syncTo,syncTimeout);
var state_72720__$1 = state_72720;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72720__$1,(10),inst_72684);
} else {
if((state_val_72721 === (20))){
var inst_72706 = (state_72720[(8)]);
var state_72720__$1 = state_72720;
var statearr_72722_72759 = state_72720__$1;
(statearr_72722_72759[(2)] = inst_72706);

(statearr_72722_72759[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (1))){
var state_72720__$1 = state_72720;
var statearr_72723_72760 = state_72720__$1;
(statearr_72723_72760[(2)] = null);

(statearr_72723_72760[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (4))){
var inst_72670 = (state_72720[(2)]);
var inst_72671 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_72670);
var inst_72672 = cljs.core.async.close_BANG_(pc);
var state_72720__$1 = (function (){var statearr_72724 = state_72720;
(statearr_72724[(9)] = inst_72671);

return statearr_72724;
})();
var statearr_72725_72761 = state_72720__$1;
(statearr_72725_72761[(2)] = inst_72672);

(statearr_72725_72761[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (15))){
var inst_72698 = (state_72720[(10)]);
var inst_72700 = fluree.db.api.ledger.add_db_permissions(inst_72698,auth,roles);
var state_72720__$1 = state_72720;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72720__$1,(18),inst_72700);
} else {
if((state_val_72721 === (21))){
var inst_72714 = (state_72720[(2)]);
var inst_72715 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_72714);
var _ = (function (){var statearr_72726 = state_72720;
(statearr_72726[(4)] = cljs.core.rest((state_72720[(4)])));

return statearr_72726;
})();
var state_72720__$1 = state_72720;
var statearr_72727_72762 = state_72720__$1;
(statearr_72727_72762[(2)] = inst_72715);

(statearr_72727_72762[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (13))){
var inst_72698 = (state_72720[(2)]);
var state_72720__$1 = (function (){var statearr_72728 = state_72720;
(statearr_72728[(10)] = inst_72698);

return statearr_72728;
})();
if(cljs.core.truth_(roles)){
var statearr_72729_72763 = state_72720__$1;
(statearr_72729_72763[(1)] = (15));

} else {
var statearr_72730_72764 = state_72720__$1;
(statearr_72730_72764[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (22))){
var inst_72710 = (state_72720[(2)]);
var inst_72711 = fluree.db.util.async.throw_err(inst_72710);
var state_72720__$1 = state_72720;
var statearr_72731_72765 = state_72720__$1;
(statearr_72731_72765[(2)] = inst_72711);

(statearr_72731_72765[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (6))){
var inst_72681 = (state_72720[(2)]);
var inst_72682 = fluree.db.util.async.throw_err(inst_72681);
var state_72720__$1 = (function (){var statearr_72732 = state_72720;
(statearr_72732[(7)] = inst_72682);

return statearr_72732;
})();
if(cljs.core.truth_(syncTo)){
var statearr_72733_72766 = state_72720__$1;
(statearr_72733_72766[(1)] = (7));

} else {
var statearr_72734_72767 = state_72720__$1;
(statearr_72734_72767[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (17))){
var inst_72706 = (state_72720[(2)]);
var state_72720__$1 = (function (){var statearr_72735 = state_72720;
(statearr_72735[(8)] = inst_72706);

return statearr_72735;
})();
if(cljs.core.truth_(auth)){
var statearr_72736_72768 = state_72720__$1;
(statearr_72736_72768[(1)] = (19));

} else {
var statearr_72737_72769 = state_72720__$1;
(statearr_72737_72769[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (3))){
var inst_72718 = (state_72720[(2)]);
var state_72720__$1 = state_72720;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72720__$1,inst_72718);
} else {
if((state_val_72721 === (12))){
var inst_72690 = (state_72720[(11)]);
var state_72720__$1 = state_72720;
var statearr_72738_72770 = state_72720__$1;
(statearr_72738_72770[(2)] = inst_72690);

(statearr_72738_72770[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (2))){
var _ = (function (){var statearr_72739 = state_72720;
(statearr_72739[(4)] = cljs.core.cons((5),(state_72720[(4)])));

return statearr_72739;
})();
var inst_72679 = fluree.db.session.db(conn,ledger,opts_SINGLEQUOTE_);
var state_72720__$1 = state_72720;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72720__$1,(6),inst_72679);
} else {
if((state_val_72721 === (19))){
var inst_72706 = (state_72720[(8)]);
var inst_72708 = fluree.db.api.ledger.add_db_permissions(inst_72706,auth,roles);
var state_72720__$1 = state_72720;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72720__$1,(22),inst_72708);
} else {
if((state_val_72721 === (11))){
var inst_72690 = (state_72720[(11)]);
var inst_72692 = fluree.db.time_travel.as_of_block(inst_72690,block);
var state_72720__$1 = state_72720;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72720__$1,(14),inst_72692);
} else {
if((state_val_72721 === (9))){
var inst_72690 = (state_72720[(2)]);
var state_72720__$1 = (function (){var statearr_72741 = state_72720;
(statearr_72741[(11)] = inst_72690);

return statearr_72741;
})();
if(cljs.core.truth_(block)){
var statearr_72742_72771 = state_72720__$1;
(statearr_72742_72771[(1)] = (11));

} else {
var statearr_72743_72772 = state_72720__$1;
(statearr_72743_72772[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (5))){
var _ = (function (){var statearr_72744 = state_72720;
(statearr_72744[(4)] = cljs.core.rest((state_72720[(4)])));

return statearr_72744;
})();
var state_72720__$1 = state_72720;
var ex72740 = (state_72720__$1[(2)]);
var statearr_72745_72773 = state_72720__$1;
(statearr_72745_72773[(5)] = ex72740);


var statearr_72746_72774 = state_72720__$1;
(statearr_72746_72774[(1)] = (4));

(statearr_72746_72774[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (14))){
var inst_72694 = (state_72720[(2)]);
var inst_72695 = fluree.db.util.async.throw_err(inst_72694);
var state_72720__$1 = state_72720;
var statearr_72747_72775 = state_72720__$1;
(statearr_72747_72775[(2)] = inst_72695);

(statearr_72747_72775[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (16))){
var inst_72698 = (state_72720[(10)]);
var state_72720__$1 = state_72720;
var statearr_72748_72776 = state_72720__$1;
(statearr_72748_72776[(2)] = inst_72698);

(statearr_72748_72776[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (10))){
var inst_72686 = (state_72720[(2)]);
var inst_72687 = fluree.db.util.async.throw_err(inst_72686);
var state_72720__$1 = state_72720;
var statearr_72749_72777 = state_72720__$1;
(statearr_72749_72777[(2)] = inst_72687);

(statearr_72749_72777[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (18))){
var inst_72702 = (state_72720[(2)]);
var inst_72703 = fluree.db.util.async.throw_err(inst_72702);
var state_72720__$1 = state_72720;
var statearr_72750_72778 = state_72720__$1;
(statearr_72750_72778[(2)] = inst_72703);

(statearr_72750_72778[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72721 === (8))){
var inst_72682 = (state_72720[(7)]);
var state_72720__$1 = state_72720;
var statearr_72751_72779 = state_72720__$1;
(statearr_72751_72779[(2)] = inst_72682);

(statearr_72751_72779[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2684__auto__ = null;
var fluree$db$api$ledger$state_machine__2684__auto____0 = (function (){
var statearr_72752 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72752[(0)] = fluree$db$api$ledger$state_machine__2684__auto__);

(statearr_72752[(1)] = (1));

return statearr_72752;
});
var fluree$db$api$ledger$state_machine__2684__auto____1 = (function (state_72720){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_72720);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e72753){var ex__2687__auto__ = e72753;
var statearr_72754_72780 = state_72720;
(statearr_72754_72780[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_72720[(4)]))){
var statearr_72755_72781 = state_72720;
(statearr_72755_72781[(1)] = cljs.core.first((state_72720[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72782 = state_72720;
state_72720 = G__72782;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2684__auto__ = function(state_72720){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2684__auto____1.call(this,state_72720);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2684__auto____0;
fluree$db$api$ledger$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2684__auto____1;
return fluree$db$api$ledger$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_72756 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_72756[(6)] = c__2706__auto___72758);

return statearr_72756;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

