// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.index');
goog.require('fluree.db.util.schema');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__5045__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * If a predicate is provided as a string value, coerce to pid
 */
fluree.db.query.range.coerce_predicate = (function fluree$db$query$range$coerce_predicate(db,pred){
if(typeof pred === 'string'){
var or__5045__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),pred);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",pred].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return pred;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__14967 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14967,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14967,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14967,(2),null);
var p4 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14967,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14967,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14967,(5),null);
var G__14970 = idx;
var G__14970__$1 = (((G__14970 instanceof cljs.core.Keyword))?G__14970.fqn:null);
switch (G__14970__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.query.range.coerce_predicate(db,p2),p3,p4,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.query.range.coerce_predicate(db,p1),p3,p4,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.query.range.coerce_predicate(db,p1),p2,p4,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.query.range.coerce_predicate(db,p2),p1,p4,op,m], null);

break;
case "tspo":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.query.range.coerce_predicate(db,p3),p4,p1,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14970__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(9007199254740991)], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
fluree.db.query.range.txn_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null);
fluree.db.query.range.txn_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__14972 = idx;
var G__14972__$1 = (((G__14972 instanceof cljs.core.Keyword))?G__14972.fqn:null);
switch (G__14972__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
case "tspo":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14972__$1)].join('')));

}
});
/**
 * Biggest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__14974 = idx;
var G__14974__$1 = (((G__14974 instanceof cljs.core.Keyword))?G__14974.fqn:null);
switch (G__14974__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
case "tspo":
return fluree.db.query.range.txn_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14974__$1)].join('')));

}
});
fluree.db.query.range.resolve_subid = (function fluree$db$query$range$resolve_subid(db,id){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if(cljs.core.not(id)){
cljs.core.async.close_BANG_(out);
} else {
if(fluree.db.util.core.pred_ident_QMARK_(id)){
cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2(fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,id),out);
} else {
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(out,id);
}
}

return out;
});
fluree.db.query.range.resolve_match_flake = (function fluree$db$query$range$resolve_match_flake(db,test,parts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_15014){
var state_val_15015 = (state_15014[(1)]);
if((state_val_15015 === (7))){
var inst_14991 = (state_15014[(7)]);
var inst_14998 = (state_15014[(2)]);
var inst_14999 = fluree.db.util.async.throw_err(inst_14998);
var state_15014__$1 = (function (){var statearr_15016 = state_15014;
(statearr_15016[(8)] = inst_14999);

return statearr_15016;
})();
if(cljs.core.truth_(inst_14991)){
var statearr_15017_15041 = state_15014__$1;
(statearr_15017_15041[(1)] = (8));

} else {
var statearr_15018_15042 = state_15014__$1;
(statearr_15018_15042[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15015 === (1))){
var state_15014__$1 = state_15014;
var statearr_15019_15043 = state_15014__$1;
(statearr_15019_15043[(2)] = null);

(statearr_15019_15043[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15015 === (4))){
var inst_14976 = (state_15014[(2)]);
var state_15014__$1 = state_15014;
var statearr_15020_15044 = state_15014__$1;
(statearr_15020_15044[(2)] = inst_14976);

(statearr_15020_15044[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15015 === (13))){
var inst_15006 = (state_15014[(2)]);
var state_15014__$1 = state_15014;
var statearr_15021_15045 = state_15014__$1;
(statearr_15021_15045[(2)] = inst_15006);

(statearr_15021_15045[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15015 === (6))){
var inst_14988 = (state_15014[(9)]);
var inst_14994 = (state_15014[(2)]);
var inst_14995 = fluree.db.util.async.throw_err(inst_14994);
var inst_14996 = fluree.db.query.range.resolve_subid(db,inst_14988);
var state_15014__$1 = (function (){var statearr_15022 = state_15014;
(statearr_15022[(10)] = inst_14995);

return statearr_15022;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15014__$1,(7),inst_14996);
} else {
if((state_val_15015 === (3))){
var inst_15012 = (state_15014[(2)]);
var state_15014__$1 = state_15014;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15014__$1,inst_15012);
} else {
if((state_val_15015 === (12))){
var state_15014__$1 = state_15014;
var statearr_15023_15046 = state_15014__$1;
(statearr_15023_15046[(2)] = (2147483647));

(statearr_15023_15046[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15015 === (2))){
var _ = (function (){var statearr_15024 = state_15014;
(statearr_15024[(4)] = cljs.core.cons((5),(state_15014[(4)])));

return statearr_15024;
})();
var inst_14985 = parts;
var inst_14986 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14985,(0),null);
var inst_14987 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14985,(1),null);
var inst_14988 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14985,(2),null);
var inst_14989 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14985,(3),null);
var inst_14990 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14985,(4),null);
var inst_14991 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14985,(5),null);
var inst_14992 = fluree.db.query.range.resolve_subid(db,inst_14986);
var state_15014__$1 = (function (){var statearr_15025 = state_15014;
(statearr_15025[(11)] = inst_14987);

(statearr_15025[(12)] = inst_14990);

(statearr_15025[(7)] = inst_14991);

(statearr_15025[(13)] = inst_14989);

(statearr_15025[(9)] = inst_14988);

return statearr_15025;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15014__$1,(6),inst_14992);
} else {
if((state_val_15015 === (11))){
var state_15014__$1 = state_15014;
var statearr_15027_15047 = state_15014__$1;
(statearr_15027_15047[(2)] = (-2147483647));

(statearr_15027_15047[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15015 === (9))){
var inst_15002 = (cljs.core._GT__EQ_ === test);
var state_15014__$1 = state_15014;
if(cljs.core.truth_(inst_15002)){
var statearr_15028_15048 = state_15014__$1;
(statearr_15028_15048[(1)] = (11));

} else {
var statearr_15029_15049 = state_15014__$1;
(statearr_15029_15049[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15015 === (5))){
var _ = (function (){var statearr_15030 = state_15014;
(statearr_15030[(4)] = cljs.core.rest((state_15014[(4)])));

return statearr_15030;
})();
var state_15014__$1 = state_15014;
var ex15026 = (state_15014__$1[(2)]);
var statearr_15031_15050 = state_15014__$1;
(statearr_15031_15050[(5)] = ex15026);


if((ex15026 instanceof Error)){
var statearr_15032_15051 = state_15014__$1;
(statearr_15032_15051[(1)] = (4));

(statearr_15032_15051[(5)] = null);

} else {
throw ex15026;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15015 === (10))){
var inst_14995 = (state_15014[(10)]);
var inst_14987 = (state_15014[(11)]);
var inst_14990 = (state_15014[(12)]);
var inst_14989 = (state_15014[(13)]);
var inst_14999 = (state_15014[(8)]);
var inst_15008 = (state_15014[(2)]);
var inst_15009 = fluree.db.flake.__GT_Flake(inst_14995,inst_14987,inst_14999,inst_14989,inst_14990,inst_15008);
var _ = (function (){var statearr_15033 = state_15014;
(statearr_15033[(4)] = cljs.core.rest((state_15014[(4)])));

return statearr_15033;
})();
var state_15014__$1 = state_15014;
var statearr_15034_15052 = state_15014__$1;
(statearr_15034_15052[(2)] = inst_15009);

(statearr_15034_15052[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15015 === (8))){
var inst_14991 = (state_15014[(7)]);
var state_15014__$1 = state_15014;
var statearr_15035_15053 = state_15014__$1;
(statearr_15035_15053[(2)] = inst_14991);

(statearr_15035_15053[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto__ = null;
var fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto____0 = (function (){
var statearr_15036 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15036[(0)] = fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto__);

(statearr_15036[(1)] = (1));

return statearr_15036;
});
var fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto____1 = (function (state_15014){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_15014);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e15037){var ex__2687__auto__ = e15037;
var statearr_15038_15054 = state_15014;
(statearr_15038_15054[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_15014[(4)]))){
var statearr_15039_15055 = state_15014;
(statearr_15039_15055[(1)] = cljs.core.first((state_15014[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15056 = state_15014;
state_15014 = G__15056;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto__ = function(state_15014){
switch(arguments.length){
case 0:
return fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto____1.call(this,state_15014);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto____0;
fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto____1;
return fluree$db$query$range$resolve_match_flake_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_15040 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_15040[(6)] = c__2706__auto__);

return statearr_15040;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.range.resolved_leaf_QMARK_ = (function fluree$db$query$range$resolved_leaf_QMARK_(node){
var and__5043__auto__ = fluree.db.index.leaf_QMARK_(node);
if(and__5043__auto__){
return fluree.db.index.resolved_QMARK_(node);
} else {
return and__5043__auto__;
}
});
/**
 * Returns true if the supplied `node` contains flakes between the `lower` and
 *   `upper` flakes, according to the `node`'s comparator.
 */
fluree.db.query.range.intersects_range_QMARK_ = (function fluree$db$query$range$intersects_range_QMARK_(node,range_set){
return cljs.core.not((function (){var or__5045__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(node);
if(cljs.core.truth_(and__5043__auto__)){
return fluree.db.flake.lower_than_all_QMARK_(new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(node),range_set);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return ((cljs.core.not(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(node))) && (fluree.db.flake.higher_than_all_QMARK_(new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(node),range_set)));
}
})());
});
/**
 * Returns a transducer to filter flakes according to the boolean function values
 *   of the `:subject-fn`, `:predicate-fn`, and `:object-fn` keys from the supplied
 *   options map. All three functions are optional, and each supplied function will
 *   be applied to its corresponding flake component, and only flakes where each
 *   function evaluates to a truthy value will be included.
 */
fluree.db.query.range.query_filter = (function fluree$db$query$range$query_filter(p__15057){
var map__15058 = p__15057;
var map__15058__$1 = cljs.core.__destructure_map(map__15058);
var subject_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15058__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var predicate_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15058__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var object_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15058__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var filter_xfs = (function (){var G__15059 = cljs.core.PersistentVector.EMPTY;
var G__15059__$1 = (cljs.core.truth_(subject_fn)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15059,cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (f){
var G__15060 = fluree.db.flake.s(f);
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__15060) : subject_fn.call(null,G__15060));
}))):G__15059);
var G__15059__$2 = (cljs.core.truth_(predicate_fn)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15059__$1,cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (f){
var G__15061 = fluree.db.flake.p(f);
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__15061) : predicate_fn.call(null,G__15061));
}))):G__15059__$1);
if(cljs.core.truth_(object_fn)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15059__$2,cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (f){
var G__15062 = fluree.db.flake.o(f);
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__15062) : object_fn.call(null,G__15062));
})));
} else {
return G__15059__$2;
}
})();
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,filter_xfs);
});
/**
 * Returns a transducer to extract flakes from each leaf from a stream of index
 *   leaf nodes that satisfy the bounds specified in the supplied query options
 *   map. The result of the transformation will be a stream of collections of
 *   flakes from the leaf nodes in the input stream, with one flake collection for
 *   each input leaf.
 */
fluree.db.query.range.extract_query_flakes = (function fluree$db$query$range$extract_query_flakes(p__15063){
var map__15064 = p__15063;
var map__15064__$1 = cljs.core.__destructure_map(map__15064);
var opts = map__15064__$1;
var start_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15064__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var start_test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15064__$1,new cljs.core.Keyword(null,"start-test","start-test",-952983565));
var end_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15064__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var end_test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15064__$1,new cljs.core.Keyword(null,"end-test","end-test",481973727));
return cljs.core.comp.cljs$core$IFn$_invoke$arity$3(cljs.core.map.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"flakes","flakes",1977895739)),cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (flakes){
return fluree.db.flake.subrange.cljs$core$IFn$_invoke$arity$5(flakes,start_test,start_flake,end_test,end_flake);
})),cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (flakes){
return cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentVector.EMPTY,fluree.db.query.range.query_filter(opts),flakes);
})));
});
/**
 * Returns a channel that will contain a stream of chunked flake collections that
 *   contain the flakes between `start-flake` and `end-flake` and are within the
 *   transaction range starting at `from-t` and ending at `to-t`.
 */
fluree.db.query.range.resolve_flake_slices = (function fluree$db$query$range$resolve_flake_slices(p__15065,root,novelty,error_ch,p__15066){
var map__15067 = p__15065;
var map__15067__$1 = cljs.core.__destructure_map(map__15067);
var conn = map__15067__$1;
var async_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15067__$1,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891));
var map__15068 = p__15066;
var map__15068__$1 = cljs.core.__destructure_map(map__15068);
var opts = map__15068__$1;
var from_t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15068__$1,new cljs.core.Keyword(null,"from-t","from-t",1730913525));
var to_t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15068__$1,new cljs.core.Keyword(null,"to-t","to-t",569467359));
var start_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15068__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15068__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var resolver = fluree.db.index.__GT_CachedTRangeResolver(conn,novelty,from_t,to_t,async_cache);
var cmp = new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(root);
var range_set = fluree.db.flake.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic(cmp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_flake,end_flake], 0));
var in_range_QMARK_ = (function (node){
return fluree.db.query.range.intersects_range_QMARK_(node,range_set);
});
var query_xf = fluree.db.query.range.extract_query_flakes(opts);
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7(resolver,root,in_range_QMARK_,fluree.db.query.range.resolved_leaf_QMARK_,(1),query_xf,error_ch);
});
fluree.db.query.range.unauthorized_QMARK_ = (function fluree$db$query$range$unauthorized_QMARK_(f){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,new cljs.core.Keyword("fluree.db.query.range","unauthorized","fluree.db.query.range/unauthorized",527238548));
});
fluree.db.query.range.authorize_flake = (function fluree$db$query$range$authorize_flake(db,error_ch,flake){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_15099){
var state_val_15100 = (state_15099[(1)]);
if((state_val_15100 === (7))){
var inst_15082 = (state_15099[(7)]);
var state_15099__$1 = state_15099;
var statearr_15101_15125 = state_15099__$1;
(statearr_15101_15125[(2)] = inst_15082);

(statearr_15101_15125[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15100 === (1))){
var state_15099__$1 = state_15099;
var statearr_15102_15126 = state_15099__$1;
(statearr_15102_15126[(2)] = null);

(statearr_15102_15126[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15100 === (4))){
var inst_15069 = (state_15099[(2)]);
var inst_15070 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15071 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_15072 = (new cljs.core.PersistentVector(null,3,(5),inst_15070,inst_15071,null));
var inst_15073 = cljs.core.select_keys(db,inst_15072);
var inst_15074 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3(inst_15069,"Error authorizing flake in ledger",inst_15073) : fluree.db.util.log.error.call(null,inst_15069,"Error authorizing flake in ledger",inst_15073));
var state_15099__$1 = (function (){var statearr_15104 = state_15099;
(statearr_15104[(8)] = inst_15074);

return statearr_15104;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15099__$1,(5),error_ch,inst_15069);
} else {
if((state_val_15100 === (13))){
var inst_15094 = (state_15099[(2)]);
var _ = (function (){var statearr_15105 = state_15099;
(statearr_15105[(4)] = cljs.core.rest((state_15099[(4)])));

return statearr_15105;
})();
var state_15099__$1 = state_15099;
var statearr_15106_15127 = state_15099__$1;
(statearr_15106_15127[(2)] = inst_15094);

(statearr_15106_15127[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15100 === (6))){
var _ = (function (){var statearr_15107 = state_15099;
(statearr_15107[(4)] = cljs.core.rest((state_15099[(4)])));

return statearr_15107;
})();
var state_15099__$1 = state_15099;
var ex15103 = (state_15099__$1[(2)]);
var statearr_15108_15128 = state_15099__$1;
(statearr_15108_15128[(5)] = ex15103);


var statearr_15109_15129 = state_15099__$1;
(statearr_15109_15129[(1)] = (4));

(statearr_15109_15129[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15100 === (3))){
var inst_15097 = (state_15099[(2)]);
var state_15099__$1 = state_15099;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15099__$1,inst_15097);
} else {
if((state_val_15100 === (12))){
var state_15099__$1 = state_15099;
var statearr_15110_15130 = state_15099__$1;
(statearr_15110_15130[(2)] = new cljs.core.Keyword("fluree.db.query.range","unauthorized","fluree.db.query.range/unauthorized",527238548));

(statearr_15110_15130[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15100 === (2))){
var inst_15082 = (state_15099[(7)]);
var _ = (function (){var statearr_15111 = state_15099;
(statearr_15111[(4)] = cljs.core.cons((6),(state_15099[(4)])));

return statearr_15111;
})();
var inst_15082__$1 = fluree.db.util.schema.is_schema_flake_QMARK_(flake);
var state_15099__$1 = (function (){var statearr_15112 = state_15099;
(statearr_15112[(7)] = inst_15082__$1);

return statearr_15112;
})();
if(inst_15082__$1){
var statearr_15113_15131 = state_15099__$1;
(statearr_15113_15131[(1)] = (7));

} else {
var statearr_15114_15132 = state_15099__$1;
(statearr_15114_15132[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15100 === (11))){
var state_15099__$1 = state_15099;
var statearr_15115_15133 = state_15099__$1;
(statearr_15115_15133[(2)] = flake);

(statearr_15115_15133[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15100 === (9))){
var inst_15090 = (state_15099[(2)]);
var state_15099__$1 = state_15099;
if(cljs.core.truth_(inst_15090)){
var statearr_15116_15134 = state_15099__$1;
(statearr_15116_15134[(1)] = (11));

} else {
var statearr_15117_15135 = state_15099__$1;
(statearr_15117_15135[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15100 === (5))){
var inst_15076 = (state_15099[(2)]);
var state_15099__$1 = state_15099;
var statearr_15118_15136 = state_15099__$1;
(statearr_15118_15136[(2)] = inst_15076);

(statearr_15118_15136[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15100 === (10))){
var inst_15087 = (state_15099[(2)]);
var inst_15088 = fluree.db.util.async.throw_err(inst_15087);
var state_15099__$1 = state_15099;
var statearr_15119_15137 = state_15099__$1;
(statearr_15119_15137[(2)] = inst_15088);

(statearr_15119_15137[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15100 === (8))){
var inst_15085 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,flake);
var state_15099__$1 = state_15099;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15099__$1,(10),inst_15085);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$authorize_flake_$_state_machine__2684__auto__ = null;
var fluree$db$query$range$authorize_flake_$_state_machine__2684__auto____0 = (function (){
var statearr_15120 = [null,null,null,null,null,null,null,null,null];
(statearr_15120[(0)] = fluree$db$query$range$authorize_flake_$_state_machine__2684__auto__);

(statearr_15120[(1)] = (1));

return statearr_15120;
});
var fluree$db$query$range$authorize_flake_$_state_machine__2684__auto____1 = (function (state_15099){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_15099);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e15121){var ex__2687__auto__ = e15121;
var statearr_15122_15138 = state_15099;
(statearr_15122_15138[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_15099[(4)]))){
var statearr_15123_15139 = state_15099;
(statearr_15123_15139[(1)] = cljs.core.first((state_15099[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15140 = state_15099;
state_15099 = G__15140;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$range$authorize_flake_$_state_machine__2684__auto__ = function(state_15099){
switch(arguments.length){
case 0:
return fluree$db$query$range$authorize_flake_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$range$authorize_flake_$_state_machine__2684__auto____1.call(this,state_15099);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$authorize_flake_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$authorize_flake_$_state_machine__2684__auto____0;
fluree$db$query$range$authorize_flake_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$authorize_flake_$_state_machine__2684__auto____1;
return fluree$db$query$range$authorize_flake_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_15124 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_15124[(6)] = c__2706__auto__);

return statearr_15124;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Authorize each flake in the supplied `flakes` collection asynchronously,
 *   returning a collection containing only allowed flakes according to the
 *   permissions of the supplied `db`.
 */
fluree.db.query.range.authorize_flakes = (function fluree$db$query$range$authorize_flakes(db,error_ch,flakes){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((function() { 
var G__15141__delegate = function (fs){
return cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentVector.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$1(fluree.db.query.range.unauthorized_QMARK_),fs);
};
var G__15141 = function (var_args){
var fs = null;
if (arguments.length > 0) {
var G__15142__i = 0, G__15142__a = new Array(arguments.length -  0);
while (G__15142__i < G__15142__a.length) {G__15142__a[G__15142__i] = arguments[G__15142__i + 0]; ++G__15142__i;}
  fs = new cljs.core.IndexedSeq(G__15142__a,0,null);
} 
return G__15141__delegate.call(this,fs);};
G__15141.cljs$lang$maxFixedArity = 0;
G__15141.cljs$lang$applyTo = (function (arglist__15143){
var fs = cljs.core.seq(arglist__15143);
return G__15141__delegate(fs);
});
G__15141.cljs$core$IFn$_invoke$arity$variadic = G__15141__delegate;
return G__15141;
})()
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.range.authorize_flake,db,error_ch),flakes));
});
/**
 * Returns a channel that will eventually return a stream of flake slices
 *   containing only the schema flakes and the flakes validated by
 *   fluree.db.permissions-validate/allow-flake? function for the database `db`
 *   from the `flake-slices` channel
 */
fluree.db.query.range.filter_authorized = (function fluree$db$query$range$filter_authorized(p__15144,start,end,error_ch,flake_slices){
var map__15145 = p__15144;
var map__15145__$1 = cljs.core.__destructure_map(map__15145);
var db = map__15145__$1;
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15145__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
return flake_slices;
});
/**
 * Returns a transducer to filter a stream of flakes to only contain flakes from
 *   at most `limit` subjects, skipping the flakes from the first `offset`
 *   subjects.
 */
fluree.db.query.range.filter_subject_page = (function fluree$db$query$range$filter_subject_page(limit,offset){
var subject_page_xfs = (function (){var G__15146 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.flake.s)], null);
var G__15146__$1 = (cljs.core.truth_(offset)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15146,cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset)):G__15146);
var G__15146__$2 = (cljs.core.truth_(limit)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15146__$1,cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit)):G__15146__$1);
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15146__$2,cljs.core.cat);

})();
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,subject_page_xfs);
});
/**
 * Collects flakes from the stream of flake collections in the `flake-slices`
 *   channel into a sorted vector according to the `limit`, `offset`, and
 *   `flake-limit` parameters. The result will have flakes from at most `limit`
 *   subjects, not including flakes from the first `offset` subjects, and having at
 *   most `flake-limit` flakes in total.
 */
fluree.db.query.range.into_page = (function fluree$db$query$range$into_page(limit,offset,flake_limit,flake_slices){
var page_xfs = (function (){var G__15147 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cat], null);
var G__15147__$1 = (cljs.core.truth_((function (){var or__5045__auto__ = limit;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return offset;
}
})())?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15147,fluree.db.query.range.filter_subject_page(limit,offset)):G__15147);
if(cljs.core.truth_(flake_limit)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__15147__$1,cljs.core.take.cljs$core$IFn$_invoke$arity$1(flake_limit));
} else {
return G__15147__$1;
}
})();
var page_xf = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,page_xfs);
return cljs.core.async.transduce(page_xf,cljs.core.conj,cljs.core.PersistentVector.EMPTY,flake_slices);
});
/**
 * Return a channel that will eventually hold a sorted vector of the range of
 *   flakes from `db` that meet the criteria specified in the `opts` map.
 */
fluree.db.query.range.index_range_STAR_ = (function fluree$db$query$range$index_range_STAR_(p__15148,error_ch,p__15149){
var map__15150 = p__15148;
var map__15150__$1 = cljs.core.__destructure_map(map__15150);
var db = map__15150__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15150__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var map__15151 = p__15149;
var map__15151__$1 = cljs.core.__destructure_map(map__15151);
var opts = map__15151__$1;
var idx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15151__$1,new cljs.core.Keyword(null,"idx","idx",1053688473));
var start_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15151__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15151__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15151__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15151__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var flake_limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15151__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961));
var idx_root = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var idx_cmp = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var novelty = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx], null));
return fluree.db.query.range.into_page(limit,offset,flake_limit,fluree.db.query.range.filter_authorized(db,start_flake,end_flake,error_ch,fluree.db.query.range.resolve_flake_slices(conn,idx_root,novelty,error_ch,opts)));
});
/**
 * Finds the full index or time range interval including the maximum and minimum
 *   tests when only one test is provided
 */
fluree.db.query.range.expand_range_interval = (function fluree$db$query$range$expand_range_interval(idx,test,match){
var pred__15152 = cljs.core.identical_QMARK_;
var expr__15153 = test;
if(cljs.core.truth_((pred__15152.cljs$core$IFn$_invoke$arity$2 ? pred__15152.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__15153) : pred__15152.call(null,cljs.core._EQ_,expr__15153)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__15152.cljs$core$IFn$_invoke$arity$2 ? pred__15152.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__15153) : pred__15152.call(null,cljs.core._LT_,expr__15153)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__15152.cljs$core$IFn$_invoke$arity$2 ? pred__15152.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__15153) : pred__15152.call(null,cljs.core._LT__EQ_,expr__15153)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__15152.cljs$core$IFn$_invoke$arity$2 ? pred__15152.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__15153) : pred__15152.call(null,cljs.core._GT_,expr__15153)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__15152.cljs$core$IFn$_invoke$arity$2 ? pred__15152.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__15153) : pred__15152.call(null,cljs.core._GT__EQ_,expr__15153)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__15153)].join('')));
}
}
}
}
}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we
 *   don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will return in
 *   reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number
 *          is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used
 *         when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__15156 = arguments.length;
switch (G__15156) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__15157 = fluree.db.query.range.expand_range_interval(idx,test,match);
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15157,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15157,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15157,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15157,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (p__15160,idx,start_test,start_match,end_test,end_match,opts){
var map__15161 = p__15160;
var map__15161__$1 = cljs.core.__destructure_map(map__15161);
var db = map__15161__$1;
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15161__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__15162 = opts;
var map__15162__$1 = cljs.core.__destructure_map(map__15162);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15162__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var from_t = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__15162__$1,new cljs.core.Keyword(null,"from-t","from-t",1730913525),t);
var to_t = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__15162__$1,new cljs.core.Keyword(null,"to-t","to-t",569467359),t);
var idx_compare = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var start_parts = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var end_parts = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_15224){
var state_val_15225 = (state_15224[(1)]);
if((state_val_15225 === (7))){
var inst_15181 = (state_15224[(7)]);
var inst_15172 = (state_15224[(8)]);
var inst_15177 = (state_15224[(9)]);
var inst_15175 = (state_15224[(2)]);
var inst_15176 = fluree.db.util.async.throw_err(inst_15175);
var inst_15177__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_15178 = [new cljs.core.Keyword(null,"idx","idx",1053688473),new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359),new cljs.core.Keyword(null,"start-test","start-test",-952983565),new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),new cljs.core.Keyword(null,"end-test","end-test",481973727),new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961)];
var inst_15179 = [idx,from_t,to_t,start_test,inst_15172,end_test,inst_15176,limit];
var inst_15180 = cljs.core.PersistentHashMap.fromArrays(inst_15178,inst_15179);
var inst_15181__$1 = fluree.db.query.range.index_range_STAR_(db,inst_15177__$1,inst_15180);
var inst_15189 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15190 = [inst_15177__$1,inst_15181__$1];
var inst_15191 = (new cljs.core.PersistentVector(null,2,(5),inst_15189,inst_15190,null));
var state_15224__$1 = (function (){var statearr_15226 = state_15224;
(statearr_15226[(7)] = inst_15181__$1);

(statearr_15226[(9)] = inst_15177__$1);

return statearr_15226;
})();
return cljs.core.async.ioc_alts_BANG_(state_15224__$1,(8),inst_15191);
} else {
if((state_val_15225 === (1))){
var state_15224__$1 = state_15224;
var statearr_15227_15256 = state_15224__$1;
(statearr_15227_15256[(2)] = null);

(statearr_15227_15256[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15225 === (4))){
var inst_15163 = (state_15224[(2)]);
var state_15224__$1 = state_15224;
var statearr_15228_15257 = state_15224__$1;
(statearr_15228_15257[(2)] = inst_15163);

(statearr_15228_15257[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15225 === (15))){
var inst_15194 = (state_15224[(10)]);
var state_15224__$1 = state_15224;
var statearr_15229_15258 = state_15224__$1;
(statearr_15229_15258[(2)] = inst_15194);

(statearr_15229_15258[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15225 === (13))){
var inst_15195 = (state_15224[(11)]);
var inst_15211 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15195,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_15224__$1 = state_15224;
if(inst_15211){
var statearr_15230_15259 = state_15224__$1;
(statearr_15230_15259[(1)] = (15));

} else {
var statearr_15231_15260 = state_15224__$1;
(statearr_15231_15260[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15225 === (6))){
var inst_15171 = (state_15224[(2)]);
var inst_15172 = fluree.db.util.async.throw_err(inst_15171);
var inst_15173 = fluree.db.query.range.resolve_match_flake(db,end_test,end_parts);
var state_15224__$1 = (function (){var statearr_15232 = state_15224;
(statearr_15232[(8)] = inst_15172);

return statearr_15232;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15224__$1,(7),inst_15173);
} else {
if((state_val_15225 === (17))){
var inst_15215 = (state_15224[(2)]);
var state_15224__$1 = state_15224;
var statearr_15233_15261 = state_15224__$1;
(statearr_15233_15261[(2)] = inst_15215);

(statearr_15233_15261[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15225 === (3))){
var inst_15222 = (state_15224[(2)]);
var state_15224__$1 = state_15224;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15224__$1,inst_15222);
} else {
if((state_val_15225 === (12))){
var inst_15193 = (state_15224[(12)]);
var inst_15209 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15193,(0),null);
var state_15224__$1 = state_15224;
var statearr_15234_15262 = state_15224__$1;
(statearr_15234_15262[(2)] = inst_15209);

(statearr_15234_15262[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15225 === (2))){
var _ = (function (){var statearr_15235 = state_15224;
(statearr_15235[(4)] = cljs.core.cons((5),(state_15224[(4)])));

return statearr_15235;
})();
var inst_15169 = fluree.db.query.range.resolve_match_flake(db,start_test,start_parts);
var state_15224__$1 = state_15224;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15224__$1,(6),inst_15169);
} else {
if((state_val_15225 === (11))){
var inst_15219 = (state_15224[(2)]);
var _ = (function (){var statearr_15237 = state_15224;
(statearr_15237[(4)] = cljs.core.rest((state_15224[(4)])));

return statearr_15237;
})();
var state_15224__$1 = state_15224;
var statearr_15238_15263 = state_15224__$1;
(statearr_15238_15263[(2)] = inst_15219);

(statearr_15238_15263[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15225 === (9))){
var inst_15193 = (state_15224[(12)]);
var inst_15201 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15193,(0),null);
var inst_15202 = (function(){throw inst_15201})();
var state_15224__$1 = state_15224;
var statearr_15239_15264 = state_15224__$1;
(statearr_15239_15264[(2)] = inst_15202);

(statearr_15239_15264[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15225 === (5))){
var _ = (function (){var statearr_15240 = state_15224;
(statearr_15240[(4)] = cljs.core.rest((state_15224[(4)])));

return statearr_15240;
})();
var state_15224__$1 = state_15224;
var ex15236 = (state_15224__$1[(2)]);
var statearr_15241_15265 = state_15224__$1;
(statearr_15241_15265[(5)] = ex15236);


if((ex15236 instanceof Error)){
var statearr_15242_15266 = state_15224__$1;
(statearr_15242_15266[(1)] = (4));

(statearr_15242_15266[(5)] = null);

} else {
throw ex15236;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15225 === (14))){
var inst_15217 = (state_15224[(2)]);
var state_15224__$1 = state_15224;
var statearr_15243_15267 = state_15224__$1;
(statearr_15243_15267[(2)] = inst_15217);

(statearr_15243_15267[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15225 === (16))){
var state_15224__$1 = state_15224;
var statearr_15244_15268 = state_15224__$1;
(statearr_15244_15268[(2)] = null);

(statearr_15244_15268[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15225 === (10))){
var inst_15181 = (state_15224[(7)]);
var inst_15195 = (state_15224[(11)]);
var inst_15204 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15195,inst_15181);
var state_15224__$1 = state_15224;
if(inst_15204){
var statearr_15245_15269 = state_15224__$1;
(statearr_15245_15269[(1)] = (12));

} else {
var statearr_15246_15270 = state_15224__$1;
(statearr_15246_15270[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15225 === (8))){
var inst_15195 = (state_15224[(11)]);
var inst_15193 = (state_15224[(12)]);
var inst_15177 = (state_15224[(9)]);
var inst_15193__$1 = (state_15224[(2)]);
var inst_15194 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15193__$1,(0),null);
var inst_15195__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15193__$1,(1),null);
var inst_15196 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15195__$1,inst_15177);
var state_15224__$1 = (function (){var statearr_15247 = state_15224;
(statearr_15247[(11)] = inst_15195__$1);

(statearr_15247[(10)] = inst_15194);

(statearr_15247[(12)] = inst_15193__$1);

return statearr_15247;
})();
if(inst_15196){
var statearr_15248_15271 = state_15224__$1;
(statearr_15248_15271[(1)] = (9));

} else {
var statearr_15249_15272 = state_15224__$1;
(statearr_15249_15272[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2684__auto__ = null;
var fluree$db$query$range$state_machine__2684__auto____0 = (function (){
var statearr_15250 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15250[(0)] = fluree$db$query$range$state_machine__2684__auto__);

(statearr_15250[(1)] = (1));

return statearr_15250;
});
var fluree$db$query$range$state_machine__2684__auto____1 = (function (state_15224){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_15224);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e15251){var ex__2687__auto__ = e15251;
var statearr_15252_15273 = state_15224;
(statearr_15252_15273[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_15224[(4)]))){
var statearr_15253_15274 = state_15224;
(statearr_15253_15274[(1)] = cljs.core.first((state_15224[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15275 = state_15224;
state_15224 = G__15275;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2684__auto__ = function(state_15224){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2684__auto____1.call(this,state_15224);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2684__auto____0;
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2684__auto____1;
return fluree$db$query$range$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_15254 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_15254[(6)] = c__2706__auto__);

return statearr_15254;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__15277 = arguments.length;
switch (G__15277) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__15278 = fluree.db.query.range.expand_range_interval(idx,test,match);
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15278,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15278,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15278,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15278,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (p__15281,idx,start_test,start_match,end_test,end_match,p__15282){
var map__15283 = p__15281;
var map__15283__$1 = cljs.core.__destructure_map(map__15283);
var db = map__15283__$1;
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15283__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15283__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__15284 = p__15282;
var map__15284__$1 = cljs.core.__destructure_map(map__15284);
var opts = map__15284__$1;
var object_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15284__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var idx_compare = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var vec__15285 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var s1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15285,(0),null);
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15285,(1),null);
var o1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15285,(2),null);
var t1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15285,(3),null);
var op1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15285,(4),null);
var m1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15285,(5),null);
var vec__15288 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var s2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15288,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15288,(1),null);
var o2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15288,(2),null);
var t2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15288,(3),null);
var op2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15288,(4),null);
var m2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15288,(5),null);
var vec__15291 = (function (){var temp__5806__auto__ = ((cljs.core.boolean_QMARK_(o1))?o1:((cljs.core.boolean_QMARK_(o2))?o2:null
));
if((temp__5806__auto__ == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [o1,o2], null),object_fn], null);
} else {
var bool = temp__5806__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null], null),(function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
})], null);
}
})();
var vec__15294 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15291,(0),null);
var o1__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15294,(0),null);
var o2__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15294,(1),null);
var object_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15291,(1),null);
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_15362){
var state_val_15363 = (state_15362[(1)]);
if((state_val_15363 === (7))){
var inst_15309 = (state_15362[(7)]);
var inst_15319 = (state_15362[(8)]);
var inst_15317 = (state_15362[(9)]);
var inst_15315 = (state_15362[(2)]);
var inst_15316 = fluree.db.util.async.throw_err(inst_15315);
var inst_15317__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_15318 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"idx","idx",1053688473),idx,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"from-t","from-t",1730913525),t,new cljs.core.Keyword(null,"to-t","to-t",569467359),t,new cljs.core.Keyword(null,"start-test","start-test",-952983565),start_test,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),inst_15309,new cljs.core.Keyword(null,"end-test","end-test",481973727),end_test,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),inst_15316,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),object_fn__$1], 0));
var inst_15319__$1 = fluree.db.query.range.index_range_STAR_(db,inst_15317__$1,inst_15318);
var inst_15327 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15328 = [inst_15317__$1,inst_15319__$1];
var inst_15329 = (new cljs.core.PersistentVector(null,2,(5),inst_15327,inst_15328,null));
var state_15362__$1 = (function (){var statearr_15364 = state_15362;
(statearr_15364[(8)] = inst_15319__$1);

(statearr_15364[(9)] = inst_15317__$1);

return statearr_15364;
})();
return cljs.core.async.ioc_alts_BANG_(state_15362__$1,(8),inst_15329);
} else {
if((state_val_15363 === (1))){
var state_15362__$1 = state_15362;
var statearr_15365_15394 = state_15362__$1;
(statearr_15365_15394[(2)] = null);

(statearr_15365_15394[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15363 === (4))){
var inst_15297 = (state_15362[(2)]);
var state_15362__$1 = state_15362;
var statearr_15366_15395 = state_15362__$1;
(statearr_15366_15395[(2)] = inst_15297);

(statearr_15366_15395[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15363 === (15))){
var inst_15332 = (state_15362[(10)]);
var state_15362__$1 = state_15362;
var statearr_15367_15396 = state_15362__$1;
(statearr_15367_15396[(2)] = inst_15332);

(statearr_15367_15396[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15363 === (13))){
var inst_15333 = (state_15362[(11)]);
var inst_15349 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15333,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_15362__$1 = state_15362;
if(inst_15349){
var statearr_15368_15397 = state_15362__$1;
(statearr_15368_15397[(1)] = (15));

} else {
var statearr_15369_15398 = state_15362__$1;
(statearr_15369_15398[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15363 === (6))){
var inst_15308 = (state_15362[(2)]);
var inst_15309 = fluree.db.util.async.throw_err(inst_15308);
var inst_15310 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15311 = [s2,p2,o2__$1,t2,op2,m2];
var inst_15312 = (new cljs.core.PersistentVector(null,6,(5),inst_15310,inst_15311,null));
var inst_15313 = fluree.db.query.range.resolve_match_flake(db,end_test,inst_15312);
var state_15362__$1 = (function (){var statearr_15370 = state_15362;
(statearr_15370[(7)] = inst_15309);

return statearr_15370;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15362__$1,(7),inst_15313);
} else {
if((state_val_15363 === (17))){
var inst_15353 = (state_15362[(2)]);
var state_15362__$1 = state_15362;
var statearr_15371_15399 = state_15362__$1;
(statearr_15371_15399[(2)] = inst_15353);

(statearr_15371_15399[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15363 === (3))){
var inst_15360 = (state_15362[(2)]);
var state_15362__$1 = state_15362;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15362__$1,inst_15360);
} else {
if((state_val_15363 === (12))){
var inst_15331 = (state_15362[(12)]);
var inst_15347 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15331,(0),null);
var state_15362__$1 = state_15362;
var statearr_15372_15400 = state_15362__$1;
(statearr_15372_15400[(2)] = inst_15347);

(statearr_15372_15400[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15363 === (2))){
var _ = (function (){var statearr_15373 = state_15362;
(statearr_15373[(4)] = cljs.core.cons((5),(state_15362[(4)])));

return statearr_15373;
})();
var inst_15303 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15304 = [s1,p1,o1__$1,t1,op1,m1];
var inst_15305 = (new cljs.core.PersistentVector(null,6,(5),inst_15303,inst_15304,null));
var inst_15306 = fluree.db.query.range.resolve_match_flake(db,start_test,inst_15305);
var state_15362__$1 = state_15362;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15362__$1,(6),inst_15306);
} else {
if((state_val_15363 === (11))){
var inst_15357 = (state_15362[(2)]);
var _ = (function (){var statearr_15375 = state_15362;
(statearr_15375[(4)] = cljs.core.rest((state_15362[(4)])));

return statearr_15375;
})();
var state_15362__$1 = state_15362;
var statearr_15376_15401 = state_15362__$1;
(statearr_15376_15401[(2)] = inst_15357);

(statearr_15376_15401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15363 === (9))){
var inst_15331 = (state_15362[(12)]);
var inst_15339 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15331,(0),null);
var inst_15340 = (function(){throw inst_15339})();
var state_15362__$1 = state_15362;
var statearr_15377_15402 = state_15362__$1;
(statearr_15377_15402[(2)] = inst_15340);

(statearr_15377_15402[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15363 === (5))){
var _ = (function (){var statearr_15378 = state_15362;
(statearr_15378[(4)] = cljs.core.rest((state_15362[(4)])));

return statearr_15378;
})();
var state_15362__$1 = state_15362;
var ex15374 = (state_15362__$1[(2)]);
var statearr_15379_15403 = state_15362__$1;
(statearr_15379_15403[(5)] = ex15374);


if((ex15374 instanceof Error)){
var statearr_15380_15404 = state_15362__$1;
(statearr_15380_15404[(1)] = (4));

(statearr_15380_15404[(5)] = null);

} else {
throw ex15374;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15363 === (14))){
var inst_15355 = (state_15362[(2)]);
var state_15362__$1 = state_15362;
var statearr_15381_15405 = state_15362__$1;
(statearr_15381_15405[(2)] = inst_15355);

(statearr_15381_15405[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15363 === (16))){
var state_15362__$1 = state_15362;
var statearr_15382_15406 = state_15362__$1;
(statearr_15382_15406[(2)] = null);

(statearr_15382_15406[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15363 === (10))){
var inst_15333 = (state_15362[(11)]);
var inst_15319 = (state_15362[(8)]);
var inst_15342 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15333,inst_15319);
var state_15362__$1 = state_15362;
if(inst_15342){
var statearr_15383_15407 = state_15362__$1;
(statearr_15383_15407[(1)] = (12));

} else {
var statearr_15384_15408 = state_15362__$1;
(statearr_15384_15408[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15363 === (8))){
var inst_15333 = (state_15362[(11)]);
var inst_15317 = (state_15362[(9)]);
var inst_15331 = (state_15362[(12)]);
var inst_15331__$1 = (state_15362[(2)]);
var inst_15332 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15331__$1,(0),null);
var inst_15333__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15331__$1,(1),null);
var inst_15334 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15333__$1,inst_15317);
var state_15362__$1 = (function (){var statearr_15385 = state_15362;
(statearr_15385[(11)] = inst_15333__$1);

(statearr_15385[(10)] = inst_15332);

(statearr_15385[(12)] = inst_15331__$1);

return statearr_15385;
})();
if(inst_15334){
var statearr_15386_15409 = state_15362__$1;
(statearr_15386_15409[(1)] = (9));

} else {
var statearr_15387_15410 = state_15362__$1;
(statearr_15387_15410[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2684__auto__ = null;
var fluree$db$query$range$state_machine__2684__auto____0 = (function (){
var statearr_15388 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15388[(0)] = fluree$db$query$range$state_machine__2684__auto__);

(statearr_15388[(1)] = (1));

return statearr_15388;
});
var fluree$db$query$range$state_machine__2684__auto____1 = (function (state_15362){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_15362);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e15389){var ex__2687__auto__ = e15389;
var statearr_15390_15411 = state_15362;
(statearr_15390_15411[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_15362[(4)]))){
var statearr_15391_15412 = state_15362;
(statearr_15391_15412[(1)] = cljs.core.first((state_15362[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15413 = state_15362;
state_15362 = G__15413;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2684__auto__ = function(state_15362){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2684__auto____1.call(this,state_15362);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2684__auto____0;
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2684__auto____1;
return fluree$db$query$range$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_15392 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_15392[(6)] = c__2706__auto__);

return statearr_15392;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= fluree.db.flake.o(f))) && ((fluree.db.flake.o(f) <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_15469){
var state_val_15470 = (state_15469[(1)]);
if((state_val_15470 === (7))){
var inst_15433 = (state_15469[(7)]);
var inst_15443 = (state_15469[(8)]);
var inst_15441 = fluree.db.flake.Flake__GT_parts(inst_15433);
var inst_15442 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15441,(0),null);
var inst_15443__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15441,(1),null);
var inst_15444 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15441,(2),null);
var inst_15445 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15441,(3),null);
var inst_15446 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15441,(4),null);
var inst_15447 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15441,(5),null);
var inst_15448 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_15444,inst_15443__$1);
var state_15469__$1 = (function (){var statearr_15471 = state_15469;
(statearr_15471[(9)] = inst_15442);

(statearr_15471[(10)] = inst_15446);

(statearr_15471[(11)] = inst_15445);

(statearr_15471[(12)] = inst_15447);

(statearr_15471[(8)] = inst_15443__$1);

return statearr_15471;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15469__$1,(10),inst_15448);
} else {
if((state_val_15470 === (1))){
var inst_15421 = flakes;
var inst_15422 = cljs.core.seq(inst_15421);
var inst_15423 = cljs.core.first(inst_15422);
var inst_15424 = cljs.core.next(inst_15422);
var inst_15425 = cljs.core.PersistentVector.EMPTY;
var inst_15426 = inst_15421;
var inst_15427 = inst_15425;
var state_15469__$1 = (function (){var statearr_15472 = state_15469;
(statearr_15472[(13)] = inst_15427);

(statearr_15472[(14)] = inst_15423);

(statearr_15472[(15)] = inst_15426);

(statearr_15472[(16)] = inst_15424);

return statearr_15472;
})();
var statearr_15473_15491 = state_15469__$1;
(statearr_15473_15491[(2)] = null);

(statearr_15473_15491[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15470 === (4))){
var inst_15433 = (state_15469[(7)]);
var inst_15436 = fluree.db.query.range.is_tag_flake_QMARK_(inst_15433);
var state_15469__$1 = state_15469;
if(inst_15436){
var statearr_15474_15492 = state_15469__$1;
(statearr_15474_15492[(1)] = (7));

} else {
var statearr_15475_15493 = state_15469__$1;
(statearr_15475_15493[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15470 === (6))){
var inst_15465 = (state_15469[(2)]);
var state_15469__$1 = state_15469;
var statearr_15476_15494 = state_15469__$1;
(statearr_15476_15494[(2)] = inst_15465);

(statearr_15476_15494[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15470 === (3))){
var inst_15467 = (state_15469[(2)]);
var state_15469__$1 = state_15469;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15469__$1,inst_15467);
} else {
if((state_val_15470 === (2))){
var inst_15426 = (state_15469[(15)]);
var inst_15433 = (state_15469[(7)]);
var inst_15432 = cljs.core.seq(inst_15426);
var inst_15433__$1 = cljs.core.first(inst_15432);
var inst_15434 = cljs.core.next(inst_15432);
var state_15469__$1 = (function (){var statearr_15477 = state_15469;
(statearr_15477[(7)] = inst_15433__$1);

(statearr_15477[(17)] = inst_15434);

return statearr_15477;
})();
if(cljs.core.truth_(inst_15433__$1)){
var statearr_15478_15495 = state_15469__$1;
(statearr_15478_15495[(1)] = (4));

} else {
var statearr_15479_15496 = state_15469__$1;
(statearr_15479_15496[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15470 === (9))){
var inst_15462 = (state_15469[(2)]);
var state_15469__$1 = state_15469;
var statearr_15480_15497 = state_15469__$1;
(statearr_15480_15497[(2)] = inst_15462);

(statearr_15480_15497[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15470 === (5))){
var inst_15427 = (state_15469[(13)]);
var state_15469__$1 = state_15469;
var statearr_15481_15498 = state_15469__$1;
(statearr_15481_15498[(2)] = inst_15427);

(statearr_15481_15498[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15470 === (10))){
var inst_15442 = (state_15469[(9)]);
var inst_15427 = (state_15469[(13)]);
var inst_15446 = (state_15469[(10)]);
var inst_15445 = (state_15469[(11)]);
var inst_15447 = (state_15469[(12)]);
var inst_15443 = (state_15469[(8)]);
var inst_15434 = (state_15469[(17)]);
var inst_15450 = (state_15469[(2)]);
var inst_15451 = fluree.db.util.async.throw_err(inst_15450);
var inst_15452 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15453 = [inst_15442,inst_15443,inst_15451,inst_15445,inst_15446,inst_15447];
var inst_15454 = (new cljs.core.PersistentVector(null,6,(5),inst_15452,inst_15453,null));
var inst_15455 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_15454);
var inst_15456 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_15427,inst_15455);
var inst_15426 = inst_15434;
var inst_15427__$1 = inst_15456;
var state_15469__$1 = (function (){var statearr_15482 = state_15469;
(statearr_15482[(13)] = inst_15427__$1);

(statearr_15482[(15)] = inst_15426);

return statearr_15482;
})();
var statearr_15483_15499 = state_15469__$1;
(statearr_15483_15499[(2)] = null);

(statearr_15483_15499[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15470 === (8))){
var inst_15427 = (state_15469[(13)]);
var inst_15433 = (state_15469[(7)]);
var inst_15434 = (state_15469[(17)]);
var inst_15459 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_15427,inst_15433);
var inst_15426 = inst_15434;
var inst_15427__$1 = inst_15459;
var state_15469__$1 = (function (){var statearr_15484 = state_15469;
(statearr_15484[(13)] = inst_15427__$1);

(statearr_15484[(15)] = inst_15426);

return statearr_15484;
})();
var statearr_15485_15500 = state_15469__$1;
(statearr_15485_15500[(2)] = null);

(statearr_15485_15500[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto____0 = (function (){
var statearr_15486 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15486[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto__);

(statearr_15486[(1)] = (1));

return statearr_15486;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto____1 = (function (state_15469){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_15469);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e15487){var ex__2687__auto__ = e15487;
var statearr_15488_15501 = state_15469;
(statearr_15488_15501[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_15469[(4)]))){
var statearr_15489_15502 = state_15469;
(statearr_15489_15502[(1)] = cljs.core.first((state_15469[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15503 = state_15469;
state_15469 = G__15503;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto__ = function(state_15469){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto____1.call(this,state_15469);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_15490 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_15490[(6)] = c__2706__auto__);

return statearr_15490;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__15505 = arguments.length;
switch (G__15505) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_15687){
var state_val_15688 = (state_15687[(1)]);
if((state_val_15688 === (65))){
var inst_15556 = (state_15687[(7)]);
var state_15687__$1 = state_15687;
if(cljs.core.truth_(inst_15556)){
var statearr_15689_15793 = state_15687__$1;
(statearr_15689_15793[(1)] = (68));

} else {
var statearr_15690_15794 = state_15687__$1;
(statearr_15690_15794[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (70))){
var inst_15666 = (state_15687[(2)]);
var state_15687__$1 = state_15687;
var statearr_15691_15795 = state_15687__$1;
(statearr_15691_15795[(2)] = inst_15666);

(statearr_15691_15795[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (62))){
var inst_15632 = (state_15687[(2)]);
var inst_15633 = fluree.db.util.async.throw_err(inst_15632);
var inst_15634 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((1),inst_15633);
var state_15687__$1 = state_15687;
var statearr_15692_15796 = state_15687__$1;
(statearr_15692_15796[(2)] = inst_15634);

(statearr_15692_15796[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (74))){
var inst_15682 = (state_15687[(2)]);
var _ = (function (){var statearr_15693 = state_15687;
(statearr_15693[(4)] = cljs.core.rest((state_15687[(4)])));

return statearr_15693;
})();
var state_15687__$1 = state_15687;
var statearr_15694_15797 = state_15687__$1;
(statearr_15694_15797[(2)] = inst_15682);

(statearr_15694_15797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (7))){
var state_15687__$1 = state_15687;
var statearr_15695_15798 = state_15687__$1;
(statearr_15695_15798[(2)] = false);

(statearr_15695_15798[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (59))){
var inst_15556 = (state_15687[(7)]);
var inst_15626 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15627 = [inst_15556];
var inst_15628 = (new cljs.core.PersistentVector(null,1,(5),inst_15626,inst_15627,null));
var inst_15629 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var inst_15630 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15628,inst_15629);
var state_15687__$1 = state_15687;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15687__$1,(62),inst_15630);
} else {
if((state_val_15688 === (20))){
var state_15687__$1 = state_15687;
var statearr_15696_15799 = state_15687__$1;
(statearr_15696_15799[(2)] = null);

(statearr_15696_15799[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (72))){
var inst_15674 = (state_15687[(8)]);
var inst_15676 = fluree.db.query.range.coerce_tag_flakes(db,inst_15674);
var state_15687__$1 = state_15687;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15687__$1,(75),inst_15676);
} else {
if((state_val_15688 === (58))){
var inst_15624 = (state_15687[(2)]);
var state_15687__$1 = state_15687;
if(cljs.core.truth_(inst_15624)){
var statearr_15697_15800 = state_15687__$1;
(statearr_15697_15800[(1)] = (59));

} else {
var statearr_15698_15801 = state_15687__$1;
(statearr_15698_15801[(1)] = (60));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (60))){
var inst_15618 = (state_15687[(9)]);
var inst_15517 = (state_15687[(10)]);
var inst_15519 = (state_15687[(11)]);
var inst_15516 = (state_15687[(12)]);
var inst_15636 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15637 = [inst_15517,inst_15516,null,inst_15519];
var inst_15638 = (new cljs.core.PersistentVector(null,4,(5),inst_15636,inst_15637,null));
var inst_15639 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_15618);
var inst_15640 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15638,inst_15639);
var state_15687__$1 = state_15687;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15687__$1,(63),inst_15640);
} else {
if((state_val_15688 === (27))){
var inst_15517 = (state_15687[(10)]);
var inst_15556 = (state_15687[(7)]);
var inst_15519 = (state_15687[(11)]);
var inst_15516 = (state_15687[(12)]);
var inst_15568 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15569 = [inst_15516,inst_15517,inst_15556,inst_15519];
var inst_15570 = (new cljs.core.PersistentVector(null,4,(5),inst_15568,inst_15569,null));
var inst_15571 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15570,opts);
var state_15687__$1 = state_15687;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15687__$1,(30),inst_15571);
} else {
if((state_val_15688 === (1))){
var state_15687__$1 = state_15687;
var statearr_15699_15802 = state_15687__$1;
(statearr_15699_15802[(2)] = null);

(statearr_15699_15802[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (69))){
var state_15687__$1 = state_15687;
var statearr_15700_15803 = state_15687__$1;
(statearr_15700_15803[(2)] = null);

(statearr_15700_15803[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (24))){
var inst_15517 = (state_15687[(10)]);
var state_15687__$1 = state_15687;
if(cljs.core.truth_(inst_15517)){
var statearr_15701_15804 = state_15687__$1;
(statearr_15701_15804[(1)] = (31));

} else {
var statearr_15702_15805 = state_15687__$1;
(statearr_15702_15805[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (55))){
var inst_15517 = (state_15687[(10)]);
var inst_15619 = (state_15687[(13)]);
var inst_15618 = (state_15687[(2)]);
var inst_15619__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_15517);
var state_15687__$1 = (function (){var statearr_15703 = state_15687;
(statearr_15703[(9)] = inst_15618);

(statearr_15703[(13)] = inst_15619__$1);

return statearr_15703;
})();
if(inst_15619__$1){
var statearr_15704_15806 = state_15687__$1;
(statearr_15704_15806[(1)] = (56));

} else {
var statearr_15705_15807 = state_15687__$1;
(statearr_15705_15807[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (39))){
var inst_15586 = (state_15687[(2)]);
var state_15687__$1 = state_15687;
var statearr_15706_15808 = state_15687__$1;
(statearr_15706_15808[(2)] = inst_15586);

(statearr_15706_15808[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (46))){
var inst_15610 = (state_15687[(2)]);
var state_15687__$1 = state_15687;
if(cljs.core.truth_(inst_15610)){
var statearr_15707_15809 = state_15687__$1;
(statearr_15707_15809[(1)] = (50));

} else {
var statearr_15708_15810 = state_15687__$1;
(statearr_15708_15810[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (4))){
var inst_15506 = (state_15687[(2)]);
var state_15687__$1 = state_15687;
var statearr_15709_15811 = state_15687__$1;
(statearr_15709_15811[(2)] = inst_15506);

(statearr_15709_15811[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (54))){
var inst_15517 = (state_15687[(10)]);
var inst_15556 = (state_15687[(7)]);
var inst_15531 = (state_15687[(14)]);
var inst_15515 = (state_15687[(15)]);
var inst_15519 = (state_15687[(11)]);
var inst_15612 = (state_15687[(16)]);
var inst_15516 = (state_15687[(12)]);
var inst_15520 = (state_15687[(17)]);
var inst_15526 = (state_15687[(18)]);
var inst_15616 = (function (){var t = inst_15519;
var temp__5802__auto__ = inst_15612;
var p = inst_15517;
var idx_predicate_QMARK_ = inst_15520;
var o = inst_15556;
var tag_predicate_QMARK_ = inst_15526;
var s = inst_15516;
var o_coerce_QMARK_ = inst_15531;
var vec__15512 = inst_15515;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_15687__$1 = state_15687;
var statearr_15710_15812 = state_15687__$1;
(statearr_15710_15812[(2)] = inst_15616);

(statearr_15710_15812[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (15))){
var inst_15518 = (state_15687[(19)]);
var inst_15537 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_15518);
var state_15687__$1 = state_15687;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15687__$1,(18),inst_15537);
} else {
if((state_val_15688 === (48))){
var inst_15603 = (state_15687[(20)]);
var state_15687__$1 = state_15687;
var statearr_15711_15813 = state_15687__$1;
(statearr_15711_15813[(2)] = inst_15603);

(statearr_15711_15813[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (50))){
var inst_15612 = (state_15687[(16)]);
var inst_15612__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_15687__$1 = (function (){var statearr_15712 = state_15687;
(statearr_15712[(16)] = inst_15612__$1);

return statearr_15712;
})();
if(cljs.core.truth_(inst_15612__$1)){
var statearr_15713_15814 = state_15687__$1;
(statearr_15713_15814[(1)] = (53));

} else {
var statearr_15714_15815 = state_15687__$1;
(statearr_15714_15815[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (75))){
var inst_15678 = (state_15687[(2)]);
var inst_15679 = fluree.db.util.async.throw_err(inst_15678);
var state_15687__$1 = state_15687;
var statearr_15715_15816 = state_15687__$1;
(statearr_15715_15816[(2)] = inst_15679);

(statearr_15715_15816[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (21))){
var inst_15552 = (state_15687[(2)]);
var state_15687__$1 = state_15687;
var statearr_15716_15817 = state_15687__$1;
(statearr_15716_15817[(2)] = inst_15552);

(statearr_15716_15817[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (31))){
var inst_15556 = (state_15687[(7)]);
var inst_15579 = (state_15687[(21)]);
var inst_15579__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_15556);
var state_15687__$1 = (function (){var statearr_15717 = state_15687;
(statearr_15717[(21)] = inst_15579__$1);

return statearr_15717;
})();
if(inst_15579__$1){
var statearr_15718_15818 = state_15687__$1;
(statearr_15718_15818[(1)] = (34));

} else {
var statearr_15719_15819 = state_15687__$1;
(statearr_15719_15819[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (32))){
var inst_15517 = (state_15687[(10)]);
var state_15687__$1 = state_15687;
var statearr_15720_15820 = state_15687__$1;
(statearr_15720_15820[(2)] = inst_15517);

(statearr_15720_15820[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (40))){
var inst_15517 = (state_15687[(10)]);
var inst_15556 = (state_15687[(7)]);
var inst_15519 = (state_15687[(11)]);
var inst_15516 = (state_15687[(12)]);
var inst_15594 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15595 = [inst_15517,inst_15556,inst_15516,inst_15519];
var inst_15596 = (new cljs.core.PersistentVector(null,4,(5),inst_15594,inst_15595,null));
var inst_15597 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_15596,opts);
var state_15687__$1 = state_15687;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15687__$1,(43),inst_15597);
} else {
if((state_val_15688 === (56))){
var inst_15556 = (state_15687[(7)]);
var inst_15621 = cljs.core.int_QMARK_(inst_15556);
var state_15687__$1 = state_15687;
var statearr_15721_15821 = state_15687__$1;
(statearr_15721_15821[(2)] = inst_15621);

(statearr_15721_15821[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (33))){
var inst_15592 = (state_15687[(2)]);
var state_15687__$1 = state_15687;
if(cljs.core.truth_(inst_15592)){
var statearr_15722_15822 = state_15687__$1;
(statearr_15722_15822[(1)] = (40));

} else {
var statearr_15723_15823 = state_15687__$1;
(statearr_15723_15823[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (13))){
var inst_15518 = (state_15687[(19)]);
var inst_15535 = fluree.db.query.range.tag_string_QMARK_(inst_15518);
var state_15687__$1 = state_15687;
if(cljs.core.truth_(inst_15535)){
var statearr_15724_15824 = state_15687__$1;
(statearr_15724_15824[(1)] = (15));

} else {
var statearr_15725_15825 = state_15687__$1;
(statearr_15725_15825[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (22))){
var inst_15548 = (state_15687[(2)]);
var inst_15549 = fluree.db.util.async.throw_err(inst_15548);
var state_15687__$1 = state_15687;
var statearr_15726_15826 = state_15687__$1;
(statearr_15726_15826[(2)] = inst_15549);

(statearr_15726_15826[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (36))){
var inst_15589 = (state_15687[(2)]);
var state_15687__$1 = state_15687;
var statearr_15727_15827 = state_15687__$1;
(statearr_15727_15827[(2)] = inst_15589);

(statearr_15727_15827[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (41))){
var inst_15517 = (state_15687[(10)]);
var state_15687__$1 = state_15687;
if(cljs.core.truth_(inst_15517)){
var statearr_15728_15828 = state_15687__$1;
(statearr_15728_15828[(1)] = (44));

} else {
var statearr_15729_15829 = state_15687__$1;
(statearr_15729_15829[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (43))){
var inst_15599 = (state_15687[(2)]);
var inst_15600 = fluree.db.util.async.throw_err(inst_15599);
var state_15687__$1 = state_15687;
var statearr_15730_15830 = state_15687__$1;
(statearr_15730_15830[(2)] = inst_15600);

(statearr_15730_15830[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (61))){
var inst_15645 = (state_15687[(2)]);
var state_15687__$1 = state_15687;
var statearr_15731_15831 = state_15687__$1;
(statearr_15731_15831[(2)] = inst_15645);

(statearr_15731_15831[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (29))){
var inst_15565 = (state_15687[(2)]);
var inst_15566 = fluree.db.util.async.throw_err(inst_15565);
var state_15687__$1 = state_15687;
var statearr_15732_15832 = state_15687__$1;
(statearr_15732_15832[(2)] = inst_15566);

(statearr_15732_15832[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (44))){
var inst_15603 = (state_15687[(20)]);
var inst_15520 = (state_15687[(17)]);
var inst_15603__$1 = cljs.core.not(inst_15520);
var state_15687__$1 = (function (){var statearr_15733 = state_15687;
(statearr_15733[(20)] = inst_15603__$1);

return statearr_15733;
})();
if(inst_15603__$1){
var statearr_15734_15833 = state_15687__$1;
(statearr_15734_15833[(1)] = (47));

} else {
var statearr_15735_15834 = state_15687__$1;
(statearr_15735_15834[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (6))){
var inst_15517 = (state_15687[(10)]);
var inst_15522 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),inst_15517);
var inst_15523 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_15522);
var state_15687__$1 = state_15687;
var statearr_15736_15835 = state_15687__$1;
(statearr_15736_15835[(2)] = inst_15523);

(statearr_15736_15835[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (28))){
var inst_15576 = (state_15687[(2)]);
var state_15687__$1 = state_15687;
var statearr_15737_15836 = state_15687__$1;
(statearr_15737_15836[(2)] = inst_15576);

(statearr_15737_15836[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (64))){
var inst_15517 = (state_15687[(10)]);
var inst_15556 = (state_15687[(7)]);
var inst_15519 = (state_15687[(11)]);
var inst_15516 = (state_15687[(12)]);
var inst_15648 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15649 = [inst_15517,inst_15516,inst_15556,inst_15519];
var inst_15650 = (new cljs.core.PersistentVector(null,4,(5),inst_15648,inst_15649,null));
var inst_15651 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15650,opts);
var state_15687__$1 = state_15687;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15687__$1,(67),inst_15651);
} else {
if((state_val_15688 === (51))){
var inst_15517 = (state_15687[(10)]);
var state_15687__$1 = state_15687;
if(cljs.core.truth_(inst_15517)){
var statearr_15738_15837 = state_15687__$1;
(statearr_15738_15837[(1)] = (64));

} else {
var statearr_15739_15838 = state_15687__$1;
(statearr_15739_15838[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (25))){
var inst_15526 = (state_15687[(18)]);
var inst_15674 = (state_15687[(2)]);
var state_15687__$1 = (function (){var statearr_15740 = state_15687;
(statearr_15740[(8)] = inst_15674);

return statearr_15740;
})();
if(cljs.core.truth_(inst_15526)){
var statearr_15741_15839 = state_15687__$1;
(statearr_15741_15839[(1)] = (72));

} else {
var statearr_15742_15840 = state_15687__$1;
(statearr_15742_15840[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (34))){
var inst_15520 = (state_15687[(17)]);
var state_15687__$1 = state_15687;
if(cljs.core.truth_(inst_15520)){
var statearr_15743_15841 = state_15687__$1;
(statearr_15743_15841[(1)] = (37));

} else {
var statearr_15744_15842 = state_15687__$1;
(statearr_15744_15842[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (17))){
var inst_15554 = (state_15687[(2)]);
var state_15687__$1 = state_15687;
var statearr_15745_15843 = state_15687__$1;
(statearr_15745_15843[(2)] = inst_15554);

(statearr_15745_15843[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (3))){
var inst_15685 = (state_15687[(2)]);
var state_15687__$1 = state_15687;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15687__$1,inst_15685);
} else {
if((state_val_15688 === (12))){
var inst_15518 = (state_15687[(19)]);
var state_15687__$1 = state_15687;
var statearr_15746_15844 = state_15687__$1;
(statearr_15746_15844[(2)] = inst_15518);

(statearr_15746_15844[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (2))){
var inst_15517 = (state_15687[(10)]);
var inst_15515 = (state_15687[(15)]);
var _ = (function (){var statearr_15747 = state_15687;
(statearr_15747[(4)] = cljs.core.cons((5),(state_15687[(4)])));

return statearr_15747;
})();
var inst_15515__$1 = fparts;
var inst_15516 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15515__$1,(0),null);
var inst_15517__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15515__$1,(1),null);
var inst_15518 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15515__$1,(2),null);
var inst_15519 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15515__$1,(3),null);
var inst_15520 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_15517__$1);
var state_15687__$1 = (function (){var statearr_15748 = state_15687;
(statearr_15748[(10)] = inst_15517__$1);

(statearr_15748[(15)] = inst_15515__$1);

(statearr_15748[(11)] = inst_15519);

(statearr_15748[(12)] = inst_15516);

(statearr_15748[(17)] = inst_15520);

(statearr_15748[(19)] = inst_15518);

return statearr_15748;
})();
if(cljs.core.truth_(inst_15517__$1)){
var statearr_15749_15845 = state_15687__$1;
(statearr_15749_15845[(1)] = (6));

} else {
var statearr_15750_15846 = state_15687__$1;
(statearr_15750_15846[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (66))){
var inst_15668 = (state_15687[(2)]);
var state_15687__$1 = state_15687;
var statearr_15751_15847 = state_15687__$1;
(statearr_15751_15847[(2)] = inst_15668);

(statearr_15751_15847[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (23))){
var inst_15517 = (state_15687[(10)]);
var inst_15558 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_15517);
var state_15687__$1 = state_15687;
if(inst_15558){
var statearr_15752_15848 = state_15687__$1;
(statearr_15752_15848[(1)] = (26));

} else {
var statearr_15753_15849 = state_15687__$1;
(statearr_15753_15849[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (47))){
var inst_15556 = (state_15687[(7)]);
var state_15687__$1 = state_15687;
var statearr_15754_15850 = state_15687__$1;
(statearr_15754_15850[(2)] = inst_15556);

(statearr_15754_15850[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (35))){
var inst_15579 = (state_15687[(21)]);
var state_15687__$1 = state_15687;
var statearr_15755_15851 = state_15687__$1;
(statearr_15755_15851[(2)] = inst_15579);

(statearr_15755_15851[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (19))){
var inst_15517 = (state_15687[(10)]);
var inst_15518 = (state_15687[(19)]);
var inst_15544 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_15517);
var inst_15545 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15544),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15518)].join('');
var inst_15546 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_15545);
var state_15687__$1 = state_15687;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15687__$1,(22),inst_15546);
} else {
if((state_val_15688 === (57))){
var inst_15619 = (state_15687[(13)]);
var state_15687__$1 = state_15687;
var statearr_15756_15852 = state_15687__$1;
(statearr_15756_15852[(2)] = inst_15619);

(statearr_15756_15852[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (68))){
var inst_15517 = (state_15687[(10)]);
var inst_15556 = (state_15687[(7)]);
var inst_15519 = (state_15687[(11)]);
var inst_15516 = (state_15687[(12)]);
var inst_15657 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15658 = [inst_15556,inst_15517,inst_15516,inst_15519];
var inst_15659 = (new cljs.core.PersistentVector(null,4,(5),inst_15657,inst_15658,null));
var inst_15660 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_15659,opts);
var state_15687__$1 = state_15687;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15687__$1,(71),inst_15660);
} else {
if((state_val_15688 === (11))){
var inst_15531 = (state_15687[(14)]);
var inst_15531__$1 = (state_15687[(2)]);
var inst_15532 = cljs.core.not(inst_15531__$1);
var state_15687__$1 = (function (){var statearr_15758 = state_15687;
(statearr_15758[(14)] = inst_15531__$1);

return statearr_15758;
})();
if(inst_15532){
var statearr_15759_15853 = state_15687__$1;
(statearr_15759_15853[(1)] = (12));

} else {
var statearr_15760_15854 = state_15687__$1;
(statearr_15760_15854[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (9))){
var inst_15518 = (state_15687[(19)]);
var inst_15528 = typeof inst_15518 === 'string';
var state_15687__$1 = state_15687;
var statearr_15761_15855 = state_15687__$1;
(statearr_15761_15855[(2)] = inst_15528);

(statearr_15761_15855[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (5))){
var _ = (function (){var statearr_15762 = state_15687;
(statearr_15762[(4)] = cljs.core.rest((state_15687[(4)])));

return statearr_15762;
})();
var state_15687__$1 = state_15687;
var ex15757 = (state_15687__$1[(2)]);
var statearr_15763_15856 = state_15687__$1;
(statearr_15763_15856[(5)] = ex15757);


if((ex15757 instanceof Error)){
var statearr_15764_15857 = state_15687__$1;
(statearr_15764_15857[(1)] = (4));

(statearr_15764_15857[(5)] = null);

} else {
throw ex15757;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (14))){
var inst_15516 = (state_15687[(12)]);
var inst_15556 = (state_15687[(2)]);
var state_15687__$1 = (function (){var statearr_15765 = state_15687;
(statearr_15765[(7)] = inst_15556);

return statearr_15765;
})();
if(cljs.core.truth_(inst_15516)){
var statearr_15766_15858 = state_15687__$1;
(statearr_15766_15858[(1)] = (23));

} else {
var statearr_15767_15859 = state_15687__$1;
(statearr_15767_15859[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (45))){
var inst_15517 = (state_15687[(10)]);
var state_15687__$1 = state_15687;
var statearr_15768_15860 = state_15687__$1;
(statearr_15768_15860[(2)] = inst_15517);

(statearr_15768_15860[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (53))){
var inst_15517 = (state_15687[(10)]);
var inst_15556 = (state_15687[(7)]);
var inst_15531 = (state_15687[(14)]);
var inst_15515 = (state_15687[(15)]);
var inst_15519 = (state_15687[(11)]);
var inst_15612 = (state_15687[(16)]);
var inst_15516 = (state_15687[(12)]);
var inst_15520 = (state_15687[(17)]);
var inst_15526 = (state_15687[(18)]);
var inst_15614 = (function (){var obj_fn = inst_15612;
var t = inst_15519;
var temp__5802__auto__ = inst_15612;
var p = inst_15517;
var idx_predicate_QMARK_ = inst_15520;
var o = inst_15556;
var tag_predicate_QMARK_ = inst_15526;
var s = inst_15516;
var o_coerce_QMARK_ = inst_15531;
var vec__15512 = inst_15515;
return (function (x){
var and__5043__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__5043__auto__;
}
});
})();
var state_15687__$1 = state_15687;
var statearr_15769_15861 = state_15687__$1;
(statearr_15769_15861[(2)] = inst_15614);

(statearr_15769_15861[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (26))){
var inst_15519 = (state_15687[(11)]);
var inst_15516 = (state_15687[(12)]);
var inst_15560 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15561 = [inst_15516,null,null,inst_15519];
var inst_15562 = (new cljs.core.PersistentVector(null,4,(5),inst_15560,inst_15561,null));
var inst_15563 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15562,opts);
var state_15687__$1 = state_15687;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15687__$1,(29),inst_15563);
} else {
if((state_val_15688 === (16))){
var inst_15518 = (state_15687[(19)]);
var inst_15542 = typeof inst_15518 === 'string';
var state_15687__$1 = state_15687;
if(cljs.core.truth_(inst_15542)){
var statearr_15770_15862 = state_15687__$1;
(statearr_15770_15862[(1)] = (19));

} else {
var statearr_15771_15863 = state_15687__$1;
(statearr_15771_15863[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (38))){
var inst_15520 = (state_15687[(17)]);
var state_15687__$1 = state_15687;
var statearr_15772_15864 = state_15687__$1;
(statearr_15772_15864[(2)] = inst_15520);

(statearr_15772_15864[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (30))){
var inst_15573 = (state_15687[(2)]);
var inst_15574 = fluree.db.util.async.throw_err(inst_15573);
var state_15687__$1 = state_15687;
var statearr_15773_15865 = state_15687__$1;
(statearr_15773_15865[(2)] = inst_15574);

(statearr_15773_15865[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (73))){
var inst_15674 = (state_15687[(8)]);
var state_15687__$1 = state_15687;
var statearr_15774_15866 = state_15687__$1;
(statearr_15774_15866[(2)] = inst_15674);

(statearr_15774_15866[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (10))){
var inst_15526 = (state_15687[(18)]);
var state_15687__$1 = state_15687;
var statearr_15775_15867 = state_15687__$1;
(statearr_15775_15867[(2)] = inst_15526);

(statearr_15775_15867[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (18))){
var inst_15539 = (state_15687[(2)]);
var inst_15540 = fluree.db.util.async.throw_err(inst_15539);
var state_15687__$1 = state_15687;
var statearr_15776_15868 = state_15687__$1;
(statearr_15776_15868[(2)] = inst_15540);

(statearr_15776_15868[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (52))){
var inst_15670 = (state_15687[(2)]);
var state_15687__$1 = state_15687;
var statearr_15777_15869 = state_15687__$1;
(statearr_15777_15869[(2)] = inst_15670);

(statearr_15777_15869[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (67))){
var inst_15653 = (state_15687[(2)]);
var inst_15654 = fluree.db.util.async.throw_err(inst_15653);
var state_15687__$1 = state_15687;
var statearr_15778_15870 = state_15687__$1;
(statearr_15778_15870[(2)] = inst_15654);

(statearr_15778_15870[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (71))){
var inst_15662 = (state_15687[(2)]);
var inst_15663 = fluree.db.util.async.throw_err(inst_15662);
var state_15687__$1 = state_15687;
var statearr_15779_15871 = state_15687__$1;
(statearr_15779_15871[(2)] = inst_15663);

(statearr_15779_15871[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (42))){
var inst_15672 = (state_15687[(2)]);
var state_15687__$1 = state_15687;
var statearr_15780_15872 = state_15687__$1;
(statearr_15780_15872[(2)] = inst_15672);

(statearr_15780_15872[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (37))){
var inst_15556 = (state_15687[(7)]);
var inst_15582 = cljs.core.fn_QMARK_(inst_15556);
var inst_15583 = (!(inst_15582));
var state_15687__$1 = state_15687;
var statearr_15781_15873 = state_15687__$1;
(statearr_15781_15873[(2)] = inst_15583);

(statearr_15781_15873[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (63))){
var inst_15642 = (state_15687[(2)]);
var inst_15643 = fluree.db.util.async.throw_err(inst_15642);
var state_15687__$1 = state_15687;
var statearr_15782_15874 = state_15687__$1;
(statearr_15782_15874[(2)] = inst_15643);

(statearr_15782_15874[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (8))){
var inst_15526 = (state_15687[(18)]);
var inst_15526__$1 = (state_15687[(2)]);
var state_15687__$1 = (function (){var statearr_15783 = state_15687;
(statearr_15783[(18)] = inst_15526__$1);

return statearr_15783;
})();
if(cljs.core.truth_(inst_15526__$1)){
var statearr_15784_15875 = state_15687__$1;
(statearr_15784_15875[(1)] = (9));

} else {
var statearr_15785_15876 = state_15687__$1;
(statearr_15785_15876[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15688 === (49))){
var inst_15607 = (state_15687[(2)]);
var state_15687__$1 = state_15687;
var statearr_15786_15877 = state_15687__$1;
(statearr_15786_15877[(2)] = inst_15607);

(statearr_15786_15877[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2684__auto__ = null;
var fluree$db$query$range$state_machine__2684__auto____0 = (function (){
var statearr_15787 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15787[(0)] = fluree$db$query$range$state_machine__2684__auto__);

(statearr_15787[(1)] = (1));

return statearr_15787;
});
var fluree$db$query$range$state_machine__2684__auto____1 = (function (state_15687){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_15687);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e15788){var ex__2687__auto__ = e15788;
var statearr_15789_15878 = state_15687;
(statearr_15789_15878[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_15687[(4)]))){
var statearr_15790_15879 = state_15687;
(statearr_15790_15879[(1)] = cljs.core.first((state_15687[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15880 = state_15687;
state_15687 = G__15880;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2684__auto__ = function(state_15687){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2684__auto____1.call(this,state_15687);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2684__auto____0;
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2684__auto____1;
return fluree$db$query$range$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_15791 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_15791[(6)] = c__2706__auto__);

return statearr_15791;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__15882 = arguments.length;
switch (G__15882) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_15917){
var state_val_15918 = (state_15917[(1)]);
if((state_val_15918 === (7))){
var inst_15904 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_15905 = ["Invalid collection name: ",inst_15904].join('');
var inst_15906 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15907 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_15908 = cljs.core.PersistentHashMap.fromArrays(inst_15906,inst_15907);
var inst_15909 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_15905,inst_15908);
var inst_15910 = (function(){throw inst_15909})();
var state_15917__$1 = state_15917;
var statearr_15919_15939 = state_15917__$1;
(statearr_15919_15939[(2)] = inst_15910);

(statearr_15919_15939[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15918 === (1))){
var state_15917__$1 = state_15917;
var statearr_15920_15940 = state_15917__$1;
(statearr_15920_15940[(2)] = null);

(statearr_15920_15940[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15918 === (4))){
var inst_15883 = (state_15917[(2)]);
var state_15917__$1 = state_15917;
var statearr_15921_15941 = state_15917__$1;
(statearr_15921_15941[(2)] = inst_15883);

(statearr_15921_15941[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15918 === (6))){
var inst_15889 = (state_15917[(7)]);
var inst_15891 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15892 = fluree.db.flake.max_subject_id(inst_15889);
var inst_15893 = [inst_15892];
var inst_15894 = (new cljs.core.PersistentVector(null,1,(5),inst_15891,inst_15893,null));
var inst_15895 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15896 = fluree.db.flake.min_subject_id(inst_15889);
var inst_15897 = [inst_15896];
var inst_15898 = (new cljs.core.PersistentVector(null,1,(5),inst_15895,inst_15897,null));
var inst_15899 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_15894,cljs.core._LT__EQ_,inst_15898,opts);
var state_15917__$1 = state_15917;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15917__$1,(9),inst_15899);
} else {
if((state_val_15918 === (3))){
var inst_15915 = (state_15917[(2)]);
var state_15917__$1 = state_15917;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15917__$1,inst_15915);
} else {
if((state_val_15918 === (2))){
var inst_15889 = (state_15917[(7)]);
var _ = (function (){var statearr_15923 = state_15917;
(statearr_15923[(4)] = cljs.core.cons((5),(state_15917[(4)])));

return statearr_15923;
})();
var inst_15889__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),name);
var state_15917__$1 = (function (){var statearr_15924 = state_15917;
(statearr_15924[(7)] = inst_15889__$1);

return statearr_15924;
})();
if(cljs.core.truth_(inst_15889__$1)){
var statearr_15925_15942 = state_15917__$1;
(statearr_15925_15942[(1)] = (6));

} else {
var statearr_15926_15943 = state_15917__$1;
(statearr_15926_15943[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15918 === (9))){
var inst_15901 = (state_15917[(2)]);
var inst_15902 = fluree.db.util.async.throw_err(inst_15901);
var state_15917__$1 = state_15917;
var statearr_15927_15944 = state_15917__$1;
(statearr_15927_15944[(2)] = inst_15902);

(statearr_15927_15944[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15918 === (5))){
var _ = (function (){var statearr_15928 = state_15917;
(statearr_15928[(4)] = cljs.core.rest((state_15917[(4)])));

return statearr_15928;
})();
var state_15917__$1 = state_15917;
var ex15922 = (state_15917__$1[(2)]);
var statearr_15929_15945 = state_15917__$1;
(statearr_15929_15945[(5)] = ex15922);


var statearr_15930_15946 = state_15917__$1;
(statearr_15930_15946[(1)] = (4));

(statearr_15930_15946[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15918 === (8))){
var inst_15912 = (state_15917[(2)]);
var _ = (function (){var statearr_15931 = state_15917;
(statearr_15931[(4)] = cljs.core.rest((state_15917[(4)])));

return statearr_15931;
})();
var state_15917__$1 = state_15917;
var statearr_15932_15947 = state_15917__$1;
(statearr_15932_15947[(2)] = inst_15912);

(statearr_15932_15947[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2684__auto__ = null;
var fluree$db$query$range$state_machine__2684__auto____0 = (function (){
var statearr_15933 = [null,null,null,null,null,null,null,null];
(statearr_15933[(0)] = fluree$db$query$range$state_machine__2684__auto__);

(statearr_15933[(1)] = (1));

return statearr_15933;
});
var fluree$db$query$range$state_machine__2684__auto____1 = (function (state_15917){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_15917);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e15934){var ex__2687__auto__ = e15934;
var statearr_15935_15948 = state_15917;
(statearr_15935_15948[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_15917[(4)]))){
var statearr_15936_15949 = state_15917;
(statearr_15936_15949[(1)] = cljs.core.first((state_15917[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15950 = state_15917;
state_15917 = G__15950;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2684__auto__ = function(state_15917){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2684__auto____1.call(this,state_15917);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2684__auto____0;
fluree$db$query$range$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2684__auto____1;
return fluree$db$query$range$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_15937 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_15937[(6)] = c__2706__auto__);

return statearr_15937;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__15954 = flakes;
var vec__15955 = G__15954;
var seq__15956 = cljs.core.seq(vec__15955);
var first__15957 = cljs.core.first(seq__15956);
var seq__15956__$1 = cljs.core.next(seq__15956);
var flake_SINGLEQUOTE_ = first__15957;
var r = seq__15956__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15954__$1 = G__15954;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15963 = G__15954__$1;
var seq__15964 = cljs.core.seq(vec__15963);
var first__15965 = cljs.core.first(seq__15964);
var seq__15964__$1 = cljs.core.next(seq__15964);
var flake_SINGLEQUOTE___$1 = first__15965;
var r__$1 = seq__15964__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = fluree.db.flake.o(flake_SINGLEQUOTE___$1);
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e15967){var e = e15967;
return null;
}})();
var map__15966 = cmd_map;
var map__15966__$1 = cljs.core.__destructure_map(map__15966);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15966__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15966__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15966__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15966__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15966__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15966__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__15968 = r__$1;
var G__15969 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__15954__$1 = G__15968;
result_STAR___$1 = G__15969;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__15978 = blocks;
var vec__15979 = G__15978;
var seq__15980 = cljs.core.seq(vec__15979);
var first__15981 = cljs.core.first(seq__15980);
var seq__15980__$1 = cljs.core.next(seq__15980);
var block_SINGLEQUOTE_ = first__15981;
var r = seq__15980__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15978__$1 = G__15978;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15986 = G__15978__$1;
var seq__15987 = cljs.core.seq(vec__15986);
var first__15988 = cljs.core.first(seq__15987);
var seq__15987__$1 = cljs.core.next(seq__15987);
var block_SINGLEQUOTE___$1 = first__15988;
var r__$1 = seq__15987__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__15989 = block_SINGLEQUOTE___$1;
var map__15989__$1 = cljs.core.__destructure_map(map__15989);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15989__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15989__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15989__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some(((function (G__15978__$1,result_STAR___$1,map__15989,map__15989__$1,block,t,flakes,vec__15986,seq__15987,first__15988,seq__15987__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15978,vec__15979,seq__15980,first__15981,seq__15980__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15970_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p(p1__15970_SHARP_),(2))){
return fluree.db.flake.o(p1__15970_SHARP_);
} else {
return null;
}
});})(G__15978__$1,result_STAR___$1,map__15989,map__15989__$1,block,t,flakes,vec__15986,seq__15987,first__15988,seq__15987__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15978,vec__15979,seq__15980,first__15981,seq__15980__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__15978__$1,result_STAR___$1,map__15989,map__15989__$1,block,t,flakes,prev_hash,vec__15986,seq__15987,first__15988,seq__15987__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15978,vec__15979,seq__15980,first__15981,seq__15980__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15971_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p(p1__15971_SHARP_),(1))){
return fluree.db.flake.o(p1__15971_SHARP_);
} else {
return null;
}
});})(G__15978__$1,result_STAR___$1,map__15989,map__15989__$1,block,t,flakes,prev_hash,vec__15986,seq__15987,first__15988,seq__15987__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15978,vec__15979,seq__15980,first__15981,seq__15980__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__15978__$1,result_STAR___$1,map__15989,map__15989__$1,block,t,flakes,prev_hash,hash,vec__15986,seq__15987,first__15988,seq__15987__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15978,vec__15979,seq__15980,first__15981,seq__15980__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15972_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p(p1__15972_SHARP_),(5))){
return fluree.db.flake.o(p1__15972_SHARP_);
} else {
return null;
}
});})(G__15978__$1,result_STAR___$1,map__15989,map__15989__$1,block,t,flakes,prev_hash,hash,vec__15986,seq__15987,first__15988,seq__15987__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15978,vec__15979,seq__15980,first__15981,seq__15980__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__15978__$1,result_STAR___$1,map__15989,map__15989__$1,block,t,flakes,prev_hash,hash,instant,vec__15986,seq__15987,first__15988,seq__15987__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15978,vec__15979,seq__15980,first__15981,seq__15980__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15973_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p(p1__15973_SHARP_),(7))){
return fluree.db.flake.o(p1__15973_SHARP_);
} else {
return null;
}
});})(G__15978__$1,result_STAR___$1,map__15989,map__15989__$1,block,t,flakes,prev_hash,hash,instant,vec__15986,seq__15987,first__15988,seq__15987__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15978,vec__15979,seq__15980,first__15981,seq__15980__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__15978__$1,result_STAR___$1,map__15989,map__15989__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15986,seq__15987,first__15988,seq__15987__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15978,vec__15979,seq__15980,first__15981,seq__15980__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15974_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p(p1__15974_SHARP_),(106));
});})(G__15978__$1,result_STAR___$1,map__15989,map__15989__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15986,seq__15987,first__15988,seq__15987__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15978,vec__15979,seq__15980,first__15981,seq__15980__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__15990 = r__$1;
var G__15991 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__15978__$1 = G__15990;
result_STAR___$1 = G__15991;
continue;
}
break;
}
});
