// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.subject_crawl.core');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.subject_crawl.subject');
goog.require('fluree.db.query.subject_crawl.rdf_type');
goog.require('fluree.db.query.subject_crawl.common');
/**
 * Returns a parsed selection specification.
 * 
 *   This strategy is only deployed if there is a single selection graph crawl,
 *   so this assumes this case is true in code.
 */
fluree.db.query.subject_crawl.core.retrieve_select_spec = (function fluree$db$query$subject_crawl$core$retrieve_select_spec(db,p__24742){
var map__24743 = p__24742;
var map__24743__$1 = cljs.core.__destructure_map(map__24743);
var parsed_query = map__24743__$1;
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24743__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24743__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var select_smt = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(select)));
return fluree.db.query.fql_parser.parse_db(db,select_smt,opts);
});
fluree.db.query.subject_crawl.core.relationship_binding = (function fluree$db$query$subject_crawl$core$relationship_binding(p__24744){
var map__24745 = p__24744;
var map__24745__$1 = cljs.core.__destructure_map(map__24745);
var opts = map__24745__$1;
var rdf_type_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24745__$1,new cljs.core.Keyword(null,"rdf-type?","rdf-type?",942727441));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24745__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_24789){
var state_val_24790 = (state_24789[(1)]);
if((state_val_24790 === (7))){
var inst_24768 = (state_24789[(7)]);
var inst_24770 = fluree.db.query.subject_crawl.rdf_type.rdf_type_crawl(inst_24768);
var state_24789__$1 = state_24789;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24789__$1,(10),inst_24770);
} else {
if((state_val_24790 === (1))){
var inst_24753 = vars;
var inst_24754 = cljs.core.seq(inst_24753);
var inst_24755 = cljs.core.first(inst_24754);
var inst_24756 = cljs.core.next(inst_24754);
var inst_24757 = cljs.core.PersistentVector.EMPTY;
var inst_24758 = inst_24753;
var inst_24759 = inst_24757;
var state_24789__$1 = (function (){var statearr_24791 = state_24789;
(statearr_24791[(8)] = inst_24758);

(statearr_24791[(9)] = inst_24759);

(statearr_24791[(10)] = inst_24755);

(statearr_24791[(11)] = inst_24756);

return statearr_24791;
})();
var statearr_24792_24810 = state_24789__$1;
(statearr_24792_24810[(2)] = null);

(statearr_24792_24810[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24790 === (4))){
var inst_24765 = (state_24789[(12)]);
var inst_24768 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"vars","vars",-2046957217),inst_24765);
var state_24789__$1 = (function (){var statearr_24793 = state_24789;
(statearr_24793[(7)] = inst_24768);

return statearr_24793;
})();
if(cljs.core.truth_(rdf_type_QMARK_)){
var statearr_24794_24811 = state_24789__$1;
(statearr_24794_24811[(1)] = (7));

} else {
var statearr_24795_24812 = state_24789__$1;
(statearr_24795_24812[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24790 === (6))){
var inst_24785 = (state_24789[(2)]);
var state_24789__$1 = state_24789;
var statearr_24796_24813 = state_24789__$1;
(statearr_24796_24813[(2)] = inst_24785);

(statearr_24796_24813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24790 === (3))){
var inst_24787 = (state_24789[(2)]);
var state_24789__$1 = state_24789;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24789__$1,inst_24787);
} else {
if((state_val_24790 === (2))){
var inst_24758 = (state_24789[(8)]);
var inst_24765 = (state_24789[(12)]);
var inst_24764 = cljs.core.seq(inst_24758);
var inst_24765__$1 = cljs.core.first(inst_24764);
var inst_24766 = cljs.core.next(inst_24764);
var state_24789__$1 = (function (){var statearr_24797 = state_24789;
(statearr_24797[(13)] = inst_24766);

(statearr_24797[(12)] = inst_24765__$1);

return statearr_24797;
})();
if(cljs.core.truth_(inst_24765__$1)){
var statearr_24798_24814 = state_24789__$1;
(statearr_24798_24814[(1)] = (4));

} else {
var statearr_24799_24815 = state_24789__$1;
(statearr_24799_24815[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24790 === (11))){
var inst_24777 = (state_24789[(2)]);
var inst_24778 = fluree.db.util.async.throw_err(inst_24777);
var state_24789__$1 = state_24789;
var statearr_24800_24816 = state_24789__$1;
(statearr_24800_24816[(2)] = inst_24778);

(statearr_24800_24816[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24790 === (9))){
var inst_24759 = (state_24789[(9)]);
var inst_24766 = (state_24789[(13)]);
var inst_24780 = (state_24789[(2)]);
var inst_24781 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24759,inst_24780);
var inst_24758 = inst_24766;
var inst_24759__$1 = inst_24781;
var state_24789__$1 = (function (){var statearr_24801 = state_24789;
(statearr_24801[(8)] = inst_24758);

(statearr_24801[(9)] = inst_24759__$1);

return statearr_24801;
})();
var statearr_24802_24817 = state_24789__$1;
(statearr_24802_24817[(2)] = null);

(statearr_24802_24817[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24790 === (5))){
var inst_24759 = (state_24789[(9)]);
var state_24789__$1 = state_24789;
var statearr_24803_24818 = state_24789__$1;
(statearr_24803_24818[(2)] = inst_24759);

(statearr_24803_24818[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24790 === (10))){
var inst_24772 = (state_24789[(2)]);
var inst_24773 = fluree.db.util.async.throw_err(inst_24772);
var state_24789__$1 = state_24789;
var statearr_24804_24819 = state_24789__$1;
(statearr_24804_24819[(2)] = inst_24773);

(statearr_24804_24819[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24790 === (8))){
var inst_24768 = (state_24789[(7)]);
var inst_24775 = fluree.db.query.subject_crawl.subject.subj_crawl(inst_24768);
var state_24789__$1 = state_24789;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24789__$1,(11),inst_24775);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto__ = null;
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto____0 = (function (){
var statearr_24805 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24805[(0)] = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto__);

(statearr_24805[(1)] = (1));

return statearr_24805;
});
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto____1 = (function (state_24789){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_24789);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e24806){var ex__2687__auto__ = e24806;
var statearr_24807_24820 = state_24789;
(statearr_24807_24820[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_24789[(4)]))){
var statearr_24808_24821 = state_24789;
(statearr_24808_24821[(1)] = cljs.core.first((state_24789[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24822 = state_24789;
state_24789 = G__24822;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto__ = function(state_24789){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto____1.call(this,state_24789);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto____0;
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto____1;
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_24809 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_24809[(6)] = c__2706__auto__);

return statearr_24809;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * After results are processed, the response may be modified if:
 *   - order-by exists, in which case we need to perform a sort
 *   - selectOne? exists, in which case we take the (first result)
 *   - pretty-print is true, in which case each result needs to get embedded in a map
 */
fluree.db.query.subject_crawl.core.build_finishing_fn = (function fluree$db$query$subject_crawl$core$build_finishing_fn(p__24824){
var map__24825 = p__24824;
var map__24825__$1 = cljs.core.__destructure_map(map__24825);
var parsed_query = map__24825__$1;
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24825__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var order_by = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24825__$1,new cljs.core.Keyword(null,"order-by","order-by",1527318070));
var pretty_print = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24825__$1,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24825__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var fns = (function (){var G__24826 = cljs.core.PersistentVector.EMPTY;
var G__24826__$1 = (cljs.core.truth_(selectOne_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__24826,(function (result){
return cljs.core.first(result);
})):G__24826);
var G__24826__$2 = (cljs.core.truth_(pretty_print)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__24826__$1,(function (){var select_var = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(parsed_query))))),(1));
return (function (result){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__24823_SHARP_){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([select_var,p1__24823_SHARP_]);
}),result);
});
})()):G__24826__$1);
if(cljs.core.truth_(order_by)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__24826__$2,(function (result){
return fluree.db.query.subject_crawl.common.order_results(result,order_by,limit);
}));
} else {
return G__24826__$2;
}
})();
if(cljs.core.empty_QMARK_(fns)){
return cljs.core.identity;
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,fns);
}
});
/**
 * Executes a simple subject crawl analytical query execution strategy.
 * 
 *   Strategy involves:
 *   (a) Get a list of subjects from first where clause
 *   (b) select all flakes for each subject
 *   (c) filter subjects based on subsequent where clause(s)
 *   (d) apply offset/limit for (c)
 *   (e) send result into :select graph crawl
 */
fluree.db.query.subject_crawl.core.simple_subject_crawl = (function fluree$db$query$subject_crawl$core$simple_subject_crawl(db,p__24827){
var map__24828 = p__24827;
var map__24828__$1 = cljs.core.__destructure_map(map__24828);
var parsed_query = map__24828__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24828__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var ident_vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24828__$1,new cljs.core.Keyword(null,"ident-vars","ident-vars",-876752986));
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24828__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24828__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24828__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var fuel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24828__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485));
var rel_binding_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24828__$1,new cljs.core.Keyword(null,"rel-binding?","rel-binding?",1563806094));
var order_by = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24828__$1,new cljs.core.Keyword(null,"order-by","order-by",1527318070));
var error_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var f_where = cljs.core.first(where);
var rdf_type_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("rdf","type","rdf/type",1175423232),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(f_where));
var filter_map = new cljs.core.Keyword(null,"s-filter","s-filter",-1111214020).cljs$core$IFn$_invoke$arity$1(cljs.core.second(where));
var cache = cljs.core.volatile_BANG_(cljs.core.PersistentArrayMap.EMPTY);
var fuel_vol = cljs.core.volatile_BANG_((0));
var select_spec = fluree.db.query.subject_crawl.core.retrieve_select_spec(db,parsed_query);
var finish_fn = fluree.db.query.subject_crawl.core.build_finishing_fn(parsed_query);
var opts = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"f-where","f-where",-958007776),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"select-spec","select-spec",55073283),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"ident-vars","ident-vars",-876752986),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736),new cljs.core.Keyword(null,"permissioned?","permissioned?",-560602803),new cljs.core.Keyword(null,"rdf-type?","rdf-type?",942727441),new cljs.core.Keyword(null,"cache","cache",-1237023054),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142),new cljs.core.Keyword(null,"query","query",-1288509510),new cljs.core.Keyword(null,"finish-fn","finish-fn",1593909598),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"filter-map","filter-map",-314788257)],[f_where,(3),select_spec,(cljs.core.truth_(order_by)?(9007199254740991):limit),ident_vars,offset,db,error_ch,cljs.core.not(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"root?","root?",-2045639518)], null))),rdf_type_QMARK_,cache,fuel,fuel_vol,parsed_query,finish_fn,vars,filter_map]);
if(cljs.core.truth_(rel_binding_QMARK_)){
return fluree.db.query.subject_crawl.core.relationship_binding(opts);
} else {
if(rdf_type_QMARK_){
return fluree.db.query.subject_crawl.rdf_type.rdf_type_crawl(opts);
} else {
return fluree.db.query.subject_crawl.subject.subj_crawl(opts);
}
}
});
