// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('flureedb');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.crypto');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.api_js');
goog.require('fluree.db.connection_js');
cljs.core.enable_console_print_BANG_();
if((typeof flureedb !== 'undefined') && (typeof flureedb.app_state !== 'undefined')){
} else {
flureedb.app_state = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"product","product",1363474257),"FlureeDB APIs",new cljs.core.Keyword(null,"version","version",425292698),"v0.17.0"], null));
}
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"product","product",1363474257).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state)),new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state))], 0));
flureedb.on_js_reload = (function flureedb$on_js_reload(){
return null;
});
fluree.db.util.log.set_level_BANG_(new cljs.core.Keyword(null,"warning","warning",-1685650671));
/**
 * Configure logging for Fluree processes.  Supported options:
 *   1. level [Values: severe, warning, info, config, fine, finer, finest]
 *   
 */
flureedb.set_logging = (function flureedb$set_logging(opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__72785 = opts_SINGLEQUOTE_;
var map__72785__$1 = cljs.core.__destructure_map(map__72785);
var level = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72785__$1,new cljs.core.Keyword(null,"level","level",1290497552));
return fluree.db.util.log.set_level_BANG_(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(level));
});
goog.exportSymbol('flureedb.set_logging', flureedb.set_logging);
/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
flureedb.connect = (function flureedb$connect(var_args){
var G__72787 = arguments.length;
switch (G__72787) {
case 1:
return flureedb.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect', flureedb.connect);

(flureedb.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
flureedb.connect_p = (function flureedb$connect_p(var_args){
var G__72790 = arguments.length;
switch (G__72790) {
case 1:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect_p', flureedb.connect_p);

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
flureedb.close = (function flureedb$close(conn){
return fluree.db.connection_js.close(conn);
});
goog.exportSymbol('flureedb.close', flureedb.close);
/**
 * Authenticate with Fluree On-Demand
 */
flureedb.authenticate = (function flureedb$authenticate(var_args){
var G__72793 = arguments.length;
switch (G__72793) {
case 4:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.authenticate', flureedb.authenticate);

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,syncTo);
}));

(flureedb.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Attempts to generate a new user auth record account.
 */
flureedb.password_generate = (function flureedb$password_generate(var_args){
var G__72796 = arguments.length;
switch (G__72796) {
case 4:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_generate', flureedb.password_generate);

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5(conn,ledger,password,user,null);
}));

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,password,user,opts){
var opts_SINGLEQUOTE_ = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
var data = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_SINGLEQUOTE_,new cljs.core.Keyword(null,"user","user",1532431356),user);
return fluree.db.connection_js.password_generate(conn,ledger,password,data);
}));

(flureedb.password_generate.cljs$lang$maxFixedArity = 5);

/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - connection - connection object to server
 *   - ledger     - ledger identifier
 *   - password   - plain-text password
 *   - user       - _user/username (TODO: should allow any _user ident in the future)
 *   - auth       - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire     - requested time to expire in milliseconds
 */
flureedb.password_login = (function flureedb$password_login(var_args){
var G__72799 = arguments.length;
switch (G__72799) {
case 4:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_login', flureedb.password_login);

(flureedb.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4(conn,ledger,password,user);
}));

(flureedb.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,auth,expire);
}));

(flureedb.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 *   Returns a promise that eventually contains the token or an exception
 */
flureedb.renew_token = (function flureedb$renew_token(var_args){
var G__72802 = arguments.length;
switch (G__72802) {
case 2:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.renew_token', flureedb.renew_token);

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,expire);
}));

(flureedb.renew_token.cljs$lang$maxFixedArity = 3);

/**
 * Returns a queryable database from the connection.
 */
flureedb.db = (function flureedb$db(var_args){
var args__5775__auto__ = [];
var len__5769__auto___72811 = arguments.length;
var i__5770__auto___72812 = (0);
while(true){
if((i__5770__auto___72812 < len__5769__auto___72811)){
args__5775__auto__.push((arguments[i__5770__auto___72812]));

var G__72813 = (i__5770__auto___72812 + (1));
i__5770__auto___72812 = G__72813;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return flureedb.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});
goog.exportSymbol('flureedb.db', flureedb.db);

(flureedb.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__72807){
var vec__72808 = p__72807;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72808,(0),null);
var opts__$1 = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts__$1);
}));

(flureedb.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureedb.db.cljs$lang$applyTo = (function (seq72804){
var G__72805 = cljs.core.first(seq72804);
var seq72804__$1 = cljs.core.next(seq72804);
var G__72806 = cljs.core.first(seq72804__$1);
var seq72804__$2 = cljs.core.next(seq72804__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72805,G__72806,seq72804__$2);
}));

/**
 * Returns db's schema map.
 */
flureedb.db_schema = (function flureedb$db_schema(db){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_72835){
var state_val_72836 = (state_72835[(1)]);
if((state_val_72836 === (1))){
var state_72835__$1 = state_72835;
var statearr_72837_72852 = state_72835__$1;
(statearr_72837_72852[(2)] = null);

(statearr_72837_72852[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72836 === (2))){
var _ = (function (){var statearr_72838 = state_72835;
(statearr_72838[(4)] = cljs.core.cons((5),(state_72835[(4)])));

return statearr_72838;
})();
var state_72835__$1 = state_72835;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72835__$1,(6),db);
} else {
if((state_val_72836 === (3))){
var inst_72833 = (state_72835[(2)]);
var state_72835__$1 = state_72835;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72835__$1,inst_72833);
} else {
if((state_val_72836 === (4))){
var inst_72814 = (state_72835[(2)]);
var inst_72815 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72816 = [inst_72814];
var inst_72817 = (new cljs.core.PersistentVector(null,1,(5),inst_72815,inst_72816,null));
var inst_72818 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72817);
var inst_72819 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_72814) : reject.call(null,inst_72814));
var state_72835__$1 = (function (){var statearr_72840 = state_72835;
(statearr_72840[(7)] = inst_72818);

return statearr_72840;
})();
var statearr_72841_72853 = state_72835__$1;
(statearr_72841_72853[(2)] = inst_72819);

(statearr_72841_72853[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72836 === (5))){
var _ = (function (){var statearr_72842 = state_72835;
(statearr_72842[(4)] = cljs.core.rest((state_72835[(4)])));

return statearr_72842;
})();
var state_72835__$1 = state_72835;
var ex72839 = (state_72835__$1[(2)]);
var statearr_72843_72854 = state_72835__$1;
(statearr_72843_72854[(5)] = ex72839);


var statearr_72844_72855 = state_72835__$1;
(statearr_72844_72855[(1)] = (4));

(statearr_72844_72855[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72836 === (6))){
var inst_72826 = (state_72835[(2)]);
var inst_72827 = fluree.db.util.async.throw_err(inst_72826);
var inst_72828 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_72827);
var inst_72829 = cljs.core.clj__GT_js(inst_72828);
var inst_72830 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_72829) : resolve.call(null,inst_72829));
var _ = (function (){var statearr_72845 = state_72835;
(statearr_72845[(4)] = cljs.core.rest((state_72835[(4)])));

return statearr_72845;
})();
var state_72835__$1 = state_72835;
var statearr_72846_72856 = state_72835__$1;
(statearr_72846_72856[(2)] = inst_72830);

(statearr_72846_72856[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$db_schema_$_state_machine__2684__auto__ = null;
var flureedb$db_schema_$_state_machine__2684__auto____0 = (function (){
var statearr_72847 = [null,null,null,null,null,null,null,null];
(statearr_72847[(0)] = flureedb$db_schema_$_state_machine__2684__auto__);

(statearr_72847[(1)] = (1));

return statearr_72847;
});
var flureedb$db_schema_$_state_machine__2684__auto____1 = (function (state_72835){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_72835);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e72848){var ex__2687__auto__ = e72848;
var statearr_72849_72857 = state_72835;
(statearr_72849_72857[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_72835[(4)]))){
var statearr_72850_72858 = state_72835;
(statearr_72850_72858[(1)] = cljs.core.first((state_72835[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72859 = state_72835;
state_72835 = G__72859;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$db_schema_$_state_machine__2684__auto__ = function(state_72835){
switch(arguments.length){
case 0:
return flureedb$db_schema_$_state_machine__2684__auto____0.call(this);
case 1:
return flureedb$db_schema_$_state_machine__2684__auto____1.call(this,state_72835);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$db_schema_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$db_schema_$_state_machine__2684__auto____0;
flureedb$db_schema_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$db_schema_$_state_machine__2684__auto____1;
return flureedb$db_schema_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_72851 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_72851[(6)] = c__2706__auto__);

return statearr_72851;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
});
goog.exportSymbol('flureedb.db_schema', flureedb.db_schema);
/**
 * Completely deletes a ledger.
 *   Returns a promise that will have a response with a corresponding status of success.
 * 
 *   A 200 status indicates the deletion has been successfully initiated.
 *   The full deletion happens in the background on the respective ledger.
 * 
 *   Query servers get notified when this process initiates, and ledger will be marked as
 *   being in a deletion state during the deletion process.
 * 
 *   Attempts to use a ledger in a deletion state will throw an exception.
 */
flureedb.delete_ledger = (function flureedb$delete_ledger(var_args){
var G__72861 = arguments.length;
switch (G__72861) {
case 2:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.delete_ledger', flureedb.delete_ledger);

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_72934){
var state_val_72935 = (state_72934[(1)]);
if((state_val_72935 === (7))){
var inst_72877 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_72934__$1 = state_72934;
var statearr_72936_72981 = state_72934__$1;
(statearr_72936_72981[(2)] = inst_72877);

(statearr_72936_72981[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72935 === (20))){
var inst_72885 = (state_72934[(7)]);
var inst_72909 = (state_72934[(2)]);
var state_72934__$1 = (function (){var statearr_72937 = state_72934;
(statearr_72937[(8)] = inst_72909);

return statearr_72937;
})();
if(cljs.core.truth_(inst_72885)){
var statearr_72938_72982 = state_72934__$1;
(statearr_72938_72982[(1)] = (21));

} else {
var statearr_72939_72983 = state_72934__$1;
(statearr_72939_72983[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72935 === (1))){
var state_72934__$1 = state_72934;
var statearr_72940_72984 = state_72934__$1;
(statearr_72940_72984[(2)] = null);

(statearr_72940_72984[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72935 === (24))){
var inst_72916 = (state_72934[(2)]);
var inst_72917 = fluree.db.util.async.throw_err(inst_72916);
var state_72934__$1 = state_72934;
var statearr_72941_72985 = state_72934__$1;
(statearr_72941_72985[(2)] = inst_72917);

(statearr_72941_72985[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72935 === (4))){
var inst_72862 = (state_72934[(2)]);
var inst_72863 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72864 = [inst_72862];
var inst_72865 = (new cljs.core.PersistentVector(null,1,(5),inst_72863,inst_72864,null));
var inst_72866 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72865);
var inst_72867 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_72862) : reject.call(null,inst_72862));
var state_72934__$1 = (function (){var statearr_72942 = state_72934;
(statearr_72942[(9)] = inst_72866);

return statearr_72942;
})();
var statearr_72943_72986 = state_72934__$1;
(statearr_72943_72986[(2)] = inst_72867);

(statearr_72943_72986[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72935 === (15))){
var inst_72898 = (state_72934[(10)]);
var inst_72900 = fluree.db.util.core.without_nils(inst_72898);
var inst_72901 = fluree.db.util.json.stringify(inst_72900);
var state_72934__$1 = state_72934;
var statearr_72944_72987 = state_72934__$1;
(statearr_72944_72987[(2)] = inst_72901);

(statearr_72944_72987[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72935 === (21))){
var inst_72909 = (state_72934[(8)]);
var inst_72904 = (state_72934[(11)]);
var inst_72911 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_72912 = [inst_72904,inst_72909];
var inst_72913 = cljs.core.PersistentHashMap.fromArrays(inst_72911,inst_72912);
var inst_72914 = fluree.db.operations.command_async(conn,inst_72913);
var state_72934__$1 = state_72934;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72934__$1,(24),inst_72914);
} else {
if((state_val_72935 === (13))){
var inst_72886 = (state_72934[(12)]);
var inst_72893 = (inst_72886 + (30000));
var state_72934__$1 = state_72934;
var statearr_72945_72988 = state_72934__$1;
(statearr_72945_72988[(2)] = inst_72893);

(statearr_72945_72988[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72935 === (22))){
var inst_72898 = (state_72934[(10)]);
var inst_72919 = fluree.db.operations.unsigned_command_async(conn,inst_72898);
var state_72934__$1 = state_72934;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72934__$1,(25),inst_72919);
} else {
if((state_val_72935 === (6))){
var state_72934__$1 = state_72934;
var statearr_72946_72989 = state_72934__$1;
(statearr_72946_72989[(2)] = null);

(statearr_72946_72989[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72935 === (25))){
var inst_72921 = (state_72934[(2)]);
var inst_72922 = fluree.db.util.async.throw_err(inst_72921);
var state_72934__$1 = state_72934;
var statearr_72947_72990 = state_72934__$1;
(statearr_72947_72990[(2)] = inst_72922);

(statearr_72947_72990[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72935 === (17))){
var inst_72885 = (state_72934[(7)]);
var inst_72904 = (state_72934[(2)]);
var state_72934__$1 = (function (){var statearr_72948 = state_72934;
(statearr_72948[(11)] = inst_72904);

return statearr_72948;
})();
if(cljs.core.truth_(inst_72885)){
var statearr_72949_72991 = state_72934__$1;
(statearr_72949_72991[(1)] = (18));

} else {
var statearr_72950_72992 = state_72934__$1;
(statearr_72950_72992[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72935 === (3))){
var inst_72932 = (state_72934[(2)]);
var state_72934__$1 = state_72934;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72934__$1,inst_72932);
} else {
if((state_val_72935 === (12))){
var inst_72883 = (state_72934[(13)]);
var state_72934__$1 = state_72934;
var statearr_72951_72993 = state_72934__$1;
(statearr_72951_72993[(2)] = inst_72883);

(statearr_72951_72993[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72935 === (2))){
var _ = (function (){var statearr_72952 = state_72934;
(statearr_72952[(4)] = cljs.core.cons((5),(state_72934[(4)])));

return statearr_72952;
})();
var inst_72874 = (opts == null);
var state_72934__$1 = state_72934;
if(cljs.core.truth_(inst_72874)){
var statearr_72953_72994 = state_72934__$1;
(statearr_72953_72994[(1)] = (6));

} else {
var statearr_72954_72995 = state_72934__$1;
(statearr_72954_72995[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72935 === (23))){
var inst_72924 = (state_72934[(2)]);
var inst_72925 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_72926 = [(200),inst_72924];
var inst_72927 = cljs.core.PersistentHashMap.fromArrays(inst_72925,inst_72926);
var inst_72928 = cljs.core.clj__GT_js(inst_72927);
var inst_72929 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_72928) : resolve.call(null,inst_72928));
var _ = (function (){var statearr_72955 = state_72934;
(statearr_72955[(4)] = cljs.core.rest((state_72934[(4)])));

return statearr_72955;
})();
var state_72934__$1 = state_72934;
var statearr_72956_72996 = state_72934__$1;
(statearr_72956_72996[(2)] = inst_72929);

(statearr_72956_72996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72935 === (19))){
var state_72934__$1 = state_72934;
var statearr_72957_72997 = state_72934__$1;
(statearr_72957_72997[(2)] = null);

(statearr_72957_72997[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72935 === (11))){
var inst_72883 = (state_72934[(13)]);
var inst_72890 = (state_72934[(2)]);
var state_72934__$1 = (function (){var statearr_72959 = state_72934;
(statearr_72959[(14)] = inst_72890);

return statearr_72959;
})();
if(cljs.core.truth_(inst_72883)){
var statearr_72960_72998 = state_72934__$1;
(statearr_72960_72998[(1)] = (12));

} else {
var statearr_72961_72999 = state_72934__$1;
(statearr_72961_72999[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72935 === (9))){
var inst_72882 = (state_72934[(15)]);
var state_72934__$1 = state_72934;
var statearr_72962_73000 = state_72934__$1;
(statearr_72962_73000[(2)] = inst_72882);

(statearr_72962_73000[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72935 === (5))){
var _ = (function (){var statearr_72963 = state_72934;
(statearr_72963[(4)] = cljs.core.rest((state_72934[(4)])));

return statearr_72963;
})();
var state_72934__$1 = state_72934;
var ex72958 = (state_72934__$1[(2)]);
var statearr_72964_73001 = state_72934__$1;
(statearr_72964_73001[(5)] = ex72958);


var statearr_72965_73002 = state_72934__$1;
(statearr_72965_73002[(1)] = (4));

(statearr_72965_73002[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72935 === (14))){
var inst_72885 = (state_72934[(7)]);
var inst_72890 = (state_72934[(14)]);
var inst_72895 = (state_72934[(2)]);
var inst_72896 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_72897 = [new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),ledger,inst_72890,inst_72895];
var inst_72898 = cljs.core.PersistentHashMap.fromArrays(inst_72896,inst_72897);
var state_72934__$1 = (function (){var statearr_72966 = state_72934;
(statearr_72966[(10)] = inst_72898);

return statearr_72966;
})();
if(cljs.core.truth_(inst_72885)){
var statearr_72967_73003 = state_72934__$1;
(statearr_72967_73003[(1)] = (15));

} else {
var statearr_72968_73004 = state_72934__$1;
(statearr_72968_73004[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72935 === (16))){
var state_72934__$1 = state_72934;
var statearr_72969_73005 = state_72934__$1;
(statearr_72969_73005[(2)] = null);

(statearr_72969_73005[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72935 === (10))){
var inst_72886 = (state_72934[(12)]);
var state_72934__$1 = state_72934;
var statearr_72970_73006 = state_72934__$1;
(statearr_72970_73006[(2)] = inst_72886);

(statearr_72970_73006[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72935 === (18))){
var inst_72885 = (state_72934[(7)]);
var inst_72904 = (state_72934[(11)]);
var inst_72906 = fluree.crypto.sign_message(inst_72904,inst_72885);
var state_72934__$1 = state_72934;
var statearr_72971_73007 = state_72934__$1;
(statearr_72971_73007[(2)] = inst_72906);

(statearr_72971_73007[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72935 === (8))){
var inst_72882 = (state_72934[(15)]);
var inst_72879 = (state_72934[(2)]);
var inst_72880 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_72879);
var inst_72881 = cljs.core.__destructure_map(inst_72879);
var inst_72882__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72881,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_72883 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72881,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_72884 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_72881,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_72885 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72881,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_72886 = fluree.db.util.core.current_time_millis();
var state_72934__$1 = (function (){var statearr_72972 = state_72934;
(statearr_72972[(7)] = inst_72885);

(statearr_72972[(16)] = inst_72880);

(statearr_72972[(15)] = inst_72882__$1);

(statearr_72972[(17)] = inst_72884);

(statearr_72972[(12)] = inst_72886);

(statearr_72972[(13)] = inst_72883);

return statearr_72972;
})();
if(cljs.core.truth_(inst_72882__$1)){
var statearr_72973_73008 = state_72934__$1;
(statearr_72973_73008[(1)] = (9));

} else {
var statearr_72974_73009 = state_72934__$1;
(statearr_72974_73009[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2684__auto__ = null;
var flureedb$state_machine__2684__auto____0 = (function (){
var statearr_72975 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72975[(0)] = flureedb$state_machine__2684__auto__);

(statearr_72975[(1)] = (1));

return statearr_72975;
});
var flureedb$state_machine__2684__auto____1 = (function (state_72934){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_72934);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e72976){var ex__2687__auto__ = e72976;
var statearr_72977_73010 = state_72934;
(statearr_72977_73010[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_72934[(4)]))){
var statearr_72978_73011 = state_72934;
(statearr_72978_73011[(1)] = cljs.core.first((state_72934[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73012 = state_72934;
state_72934 = G__73012;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$state_machine__2684__auto__ = function(state_72934){
switch(arguments.length){
case 0:
return flureedb$state_machine__2684__auto____0.call(this);
case 1:
return flureedb$state_machine__2684__auto____1.call(this,state_72934);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2684__auto____0;
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2684__auto____1;
return flureedb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_72979 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_72979[(6)] = c__2706__auto__);

return statearr_72979;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(flureedb.delete_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Returns promise returning ledger's stats, including db size and # of flakes.
 *   If ledger doesn't exist, will return an empty map.
 */
flureedb.ledger_stats = (function flureedb$ledger_stats(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_73034){
var state_val_73035 = (state_73034[(1)]);
if((state_val_73035 === (1))){
var state_73034__$1 = state_73034;
var statearr_73036_73051 = state_73034__$1;
(statearr_73036_73051[(2)] = null);

(statearr_73036_73051[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73035 === (2))){
var _ = (function (){var statearr_73037 = state_73034;
(statearr_73037[(4)] = cljs.core.cons((5),(state_73034[(4)])));

return statearr_73037;
})();
var inst_73024 = fluree.db.operations.ledger_stats_async(conn,ledger);
var state_73034__$1 = state_73034;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73034__$1,(6),inst_73024);
} else {
if((state_val_73035 === (3))){
var inst_73032 = (state_73034[(2)]);
var state_73034__$1 = state_73034;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73034__$1,inst_73032);
} else {
if((state_val_73035 === (4))){
var inst_73013 = (state_73034[(2)]);
var inst_73014 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73015 = [inst_73013];
var inst_73016 = (new cljs.core.PersistentVector(null,1,(5),inst_73014,inst_73015,null));
var inst_73017 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73016);
var inst_73018 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_73013) : reject.call(null,inst_73013));
var state_73034__$1 = (function (){var statearr_73039 = state_73034;
(statearr_73039[(7)] = inst_73017);

return statearr_73039;
})();
var statearr_73040_73052 = state_73034__$1;
(statearr_73040_73052[(2)] = inst_73018);

(statearr_73040_73052[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73035 === (5))){
var _ = (function (){var statearr_73041 = state_73034;
(statearr_73041[(4)] = cljs.core.rest((state_73034[(4)])));

return statearr_73041;
})();
var state_73034__$1 = state_73034;
var ex73038 = (state_73034__$1[(2)]);
var statearr_73042_73053 = state_73034__$1;
(statearr_73042_73053[(5)] = ex73038);


var statearr_73043_73054 = state_73034__$1;
(statearr_73043_73054[(1)] = (4));

(statearr_73043_73054[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73035 === (6))){
var inst_73026 = (state_73034[(2)]);
var inst_73027 = fluree.db.util.async.throw_err(inst_73026);
var inst_73028 = cljs.core.clj__GT_js(inst_73027);
var inst_73029 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_73028) : resolve.call(null,inst_73028));
var _ = (function (){var statearr_73044 = state_73034;
(statearr_73044[(4)] = cljs.core.rest((state_73034[(4)])));

return statearr_73044;
})();
var state_73034__$1 = state_73034;
var statearr_73045_73055 = state_73034__$1;
(statearr_73045_73055[(2)] = inst_73029);

(statearr_73045_73055[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$ledger_stats_$_state_machine__2684__auto__ = null;
var flureedb$ledger_stats_$_state_machine__2684__auto____0 = (function (){
var statearr_73046 = [null,null,null,null,null,null,null,null];
(statearr_73046[(0)] = flureedb$ledger_stats_$_state_machine__2684__auto__);

(statearr_73046[(1)] = (1));

return statearr_73046;
});
var flureedb$ledger_stats_$_state_machine__2684__auto____1 = (function (state_73034){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_73034);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e73047){var ex__2687__auto__ = e73047;
var statearr_73048_73056 = state_73034;
(statearr_73048_73056[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_73034[(4)]))){
var statearr_73049_73057 = state_73034;
(statearr_73049_73057[(1)] = cljs.core.first((state_73034[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73058 = state_73034;
state_73034 = G__73058;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$ledger_stats_$_state_machine__2684__auto__ = function(state_73034){
switch(arguments.length){
case 0:
return flureedb$ledger_stats_$_state_machine__2684__auto____0.call(this);
case 1:
return flureedb$ledger_stats_$_state_machine__2684__auto____1.call(this,state_73034);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$ledger_stats_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$ledger_stats_$_state_machine__2684__auto____0;
flureedb$ledger_stats_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$ledger_stats_$_state_machine__2684__auto____1;
return flureedb$ledger_stats_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_73050 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_73050[(6)] = c__2706__auto__);

return statearr_73050;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
});
goog.exportSymbol('flureedb.ledger_stats', flureedb.ledger_stats);
/**
 * Attempts to create new ledger.
 * 
 * A successful result will kick off a process on the ledger server(s) to bootstrap.
 * 
 * Once successful, will return with a command-id.
 * 
 * Ledger creation is handled asynchronously and may not be immediately available.
 * 
 * Options include:
 * - :alias       - Alias, if different than ledger-ident.
 * - :root        - Root account id to bootstrap with (string). Defaults to connection default account id.
 * - :doc         - Optional doc string about this db.
 * - :fork        - If forking an existing db, ref to db (actual identity, not ledger-ident). Must exist in network db.
 * - :forkBlock   - If fork is provided, optionally provide the block to fork at. Defaults to latest known.
 * - :persistResp - Respond immediately once persisted with the ledger-id, don't wait for transaction to be finished
 * - :jwt         - token for Fluree On-Demand access
 * 
 */
flureedb.new_ledger = (function flureedb$new_ledger(var_args){
var G__73060 = arguments.length;
switch (G__73060) {
case 2:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.new_ledger', flureedb.new_ledger);

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_73187){
var state_val_73188 = (state_73187[(1)]);
if((state_val_73188 === (7))){
var inst_73086 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_73187__$1 = state_73187;
var statearr_73189_73259 = state_73187__$1;
(statearr_73189_73259[(2)] = inst_73086);

(statearr_73189_73259[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (20))){
var inst_73093 = (state_73187[(7)]);
var inst_73132 = (state_73187[(2)]);
var inst_73133 = fluree.db.util.core.current_time_millis();
var state_73187__$1 = (function (){var statearr_73190 = state_73187;
(statearr_73190[(8)] = inst_73132);

(statearr_73190[(9)] = inst_73133);

return statearr_73190;
})();
if(cljs.core.truth_(inst_73093)){
var statearr_73191_73260 = state_73187__$1;
(statearr_73191_73260[(1)] = (21));

} else {
var statearr_73192_73261 = state_73187__$1;
(statearr_73192_73261[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (27))){
var inst_73101 = (state_73187[(10)]);
var inst_73146 = (state_73187[(11)]);
var inst_73148 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_73146,new cljs.core.Keyword(null,"jwt","jwt",1504015441),inst_73101);
var state_73187__$1 = state_73187;
var statearr_73193_73262 = state_73187__$1;
(statearr_73193_73262[(2)] = inst_73148);

(statearr_73193_73262[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (1))){
var state_73187__$1 = state_73187;
var statearr_73194_73263 = state_73187__$1;
(statearr_73194_73263[(2)] = null);

(statearr_73194_73263[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (24))){
var inst_73099 = (state_73187[(12)]);
var state_73187__$1 = state_73187;
var statearr_73195_73264 = state_73187__$1;
(statearr_73195_73264[(2)] = inst_73099);

(statearr_73195_73264[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (39))){
var inst_73169 = (state_73187[(2)]);
var inst_73170 = fluree.db.util.async.throw_err(inst_73169);
var state_73187__$1 = state_73187;
var statearr_73196_73265 = state_73187__$1;
(statearr_73196_73265[(2)] = inst_73170);

(statearr_73196_73265[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (4))){
var inst_73061 = (state_73187[(2)]);
var inst_73062 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73063 = [inst_73061];
var inst_73064 = (new cljs.core.PersistentVector(null,1,(5),inst_73062,inst_73063,null));
var inst_73065 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73064);
var inst_73066 = cljs.core.ex_data(inst_73061);
var inst_73067 = cljs.core.ex_message(inst_73061);
var inst_73068 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_73066,new cljs.core.Keyword(null,"message","message",-406056002),inst_73067);
var inst_73069 = cljs.core.clj__GT_js(inst_73068);
var inst_73070 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_73069) : reject.call(null,inst_73069));
var state_73187__$1 = (function (){var statearr_73197 = state_73187;
(statearr_73197[(13)] = inst_73065);

return statearr_73197;
})();
var statearr_73198_73266 = state_73187__$1;
(statearr_73198_73266[(2)] = inst_73070);

(statearr_73198_73266[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (15))){
var inst_73122 = (state_73187[(14)]);
var inst_73124 = fluree.db.graphdb.validate_ledger_name(inst_73122,"alias");
var state_73187__$1 = state_73187;
var statearr_73199_73267 = state_73187__$1;
(statearr_73199_73267[(2)] = inst_73124);

(statearr_73199_73267[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (21))){
var inst_73093 = (state_73187[(7)]);
var state_73187__$1 = state_73187;
var statearr_73200_73268 = state_73187__$1;
(statearr_73200_73268[(2)] = inst_73093);

(statearr_73200_73268[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (31))){
var state_73187__$1 = state_73187;
var statearr_73201_73269 = state_73187__$1;
(statearr_73201_73269[(2)] = null);

(statearr_73201_73269[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (32))){
var inst_73095 = (state_73187[(15)]);
var inst_73157 = (state_73187[(2)]);
var state_73187__$1 = (function (){var statearr_73202 = state_73187;
(statearr_73202[(16)] = inst_73157);

return statearr_73202;
})();
if(cljs.core.truth_(inst_73095)){
var statearr_73203_73270 = state_73187__$1;
(statearr_73203_73270[(1)] = (33));

} else {
var statearr_73204_73271 = state_73187__$1;
(statearr_73204_73271[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (40))){
var inst_73174 = (state_73187[(2)]);
var inst_73175 = fluree.db.util.async.throw_err(inst_73174);
var state_73187__$1 = state_73187;
var statearr_73205_73272 = state_73187__$1;
(statearr_73205_73272[(2)] = inst_73175);

(statearr_73205_73272[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (33))){
var inst_73095 = (state_73187[(15)]);
var inst_73157 = (state_73187[(16)]);
var inst_73159 = fluree.crypto.sign_message(inst_73157,inst_73095);
var state_73187__$1 = state_73187;
var statearr_73206_73273 = state_73187__$1;
(statearr_73206_73273[(2)] = inst_73159);

(statearr_73206_73273[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (13))){
var state_73187__$1 = state_73187;
var statearr_73207_73274 = state_73187__$1;
(statearr_73207_73274[(2)] = null);

(statearr_73207_73274[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (22))){
var inst_73133 = (state_73187[(9)]);
var state_73187__$1 = state_73187;
var statearr_73208_73275 = state_73187__$1;
(statearr_73208_73275[(2)] = inst_73133);

(statearr_73208_73275[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (36))){
var inst_73157 = (state_73187[(16)]);
var inst_73162 = (state_73187[(17)]);
var inst_73164 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_73165 = [inst_73157,inst_73162];
var inst_73166 = cljs.core.PersistentHashMap.fromArrays(inst_73164,inst_73165);
var inst_73167 = fluree.db.operations.command_async(conn,inst_73166);
var state_73187__$1 = state_73187;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73187__$1,(39),inst_73167);
} else {
if((state_val_73188 === (29))){
var inst_73095 = (state_73187[(15)]);
var inst_73151 = (state_73187[(2)]);
var state_73187__$1 = (function (){var statearr_73209 = state_73187;
(statearr_73209[(18)] = inst_73151);

return statearr_73209;
})();
if(cljs.core.truth_(inst_73095)){
var statearr_73210_73276 = state_73187__$1;
(statearr_73210_73276[(1)] = (30));

} else {
var statearr_73211_73277 = state_73187__$1;
(statearr_73211_73277[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (6))){
var state_73187__$1 = state_73187;
var statearr_73212_73278 = state_73187__$1;
(statearr_73212_73278[(2)] = null);

(statearr_73212_73278[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (28))){
var inst_73146 = (state_73187[(11)]);
var state_73187__$1 = state_73187;
var statearr_73213_73279 = state_73187__$1;
(statearr_73213_73279[(2)] = inst_73146);

(statearr_73213_73279[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (25))){
var inst_73133 = (state_73187[(9)]);
var inst_73140 = (inst_73133 + (30000));
var state_73187__$1 = state_73187;
var statearr_73214_73280 = state_73187__$1;
(statearr_73214_73280[(2)] = inst_73140);

(statearr_73214_73280[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (34))){
var state_73187__$1 = state_73187;
var statearr_73215_73281 = state_73187__$1;
(statearr_73215_73281[(2)] = null);

(statearr_73215_73281[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (17))){
var inst_73103 = (state_73187[(19)]);
var inst_73127 = (state_73187[(2)]);
var state_73187__$1 = (function (){var statearr_73216 = state_73187;
(statearr_73216[(20)] = inst_73127);

return statearr_73216;
})();
if(cljs.core.truth_(inst_73103)){
var statearr_73217_73282 = state_73187__$1;
(statearr_73217_73282[(1)] = (18));

} else {
var statearr_73218_73283 = state_73187__$1;
(statearr_73218_73283[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (3))){
var inst_73185 = (state_73187[(2)]);
var state_73187__$1 = state_73187;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73187__$1,inst_73185);
} else {
if((state_val_73188 === (12))){
var inst_73117 = fluree.db.graphdb.validate_ledger_ident(ledger);
var state_73187__$1 = state_73187;
var statearr_73219_73284 = state_73187__$1;
(statearr_73219_73284[(2)] = inst_73117);

(statearr_73219_73284[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (2))){
var _ = (function (){var statearr_73220 = state_73187;
(statearr_73220[(4)] = cljs.core.cons((5),(state_73187[(4)])));

return statearr_73220;
})();
var inst_73083 = (opts == null);
var state_73187__$1 = state_73187;
if(cljs.core.truth_(inst_73083)){
var statearr_73221_73285 = state_73187__$1;
(statearr_73221_73285[(1)] = (6));

} else {
var statearr_73222_73286 = state_73187__$1;
(statearr_73222_73286[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (23))){
var inst_73099 = (state_73187[(12)]);
var inst_73137 = (state_73187[(2)]);
var state_73187__$1 = (function (){var statearr_73223 = state_73187;
(statearr_73223[(21)] = inst_73137);

return statearr_73223;
})();
if(cljs.core.truth_(inst_73099)){
var statearr_73224_73287 = state_73187__$1;
(statearr_73224_73287[(1)] = (24));

} else {
var statearr_73225_73288 = state_73187__$1;
(statearr_73225_73288[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (35))){
var inst_73095 = (state_73187[(15)]);
var inst_73162 = (state_73187[(2)]);
var state_73187__$1 = (function (){var statearr_73226 = state_73187;
(statearr_73226[(17)] = inst_73162);

return statearr_73226;
})();
if(cljs.core.truth_(inst_73095)){
var statearr_73227_73289 = state_73187__$1;
(statearr_73227_73289[(1)] = (36));

} else {
var statearr_73228_73290 = state_73187__$1;
(statearr_73228_73290[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (19))){
var state_73187__$1 = state_73187;
var statearr_73229_73291 = state_73187__$1;
(statearr_73229_73291[(2)] = null);

(statearr_73229_73291[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (11))){
var inst_73103 = (state_73187[(19)]);
var inst_73113 = (state_73187[(22)]);
var inst_73106 = (state_73187[(23)]);
var inst_73113__$1 = (state_73187[(2)]);
var inst_73114 = fluree.db.graphdb.validate_ledger_name(inst_73113__$1,"ledger");
var inst_73115 = fluree.db.graphdb.validate_ledger_name(inst_73106,"network");
var state_73187__$1 = (function (){var statearr_73231 = state_73187;
(statearr_73231[(22)] = inst_73113__$1);

(statearr_73231[(24)] = inst_73115);

(statearr_73231[(25)] = inst_73114);

return statearr_73231;
})();
if(cljs.core.truth_(inst_73103)){
var statearr_73232_73292 = state_73187__$1;
(statearr_73232_73292[(1)] = (12));

} else {
var statearr_73233_73293 = state_73187__$1;
(statearr_73233_73293[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (9))){
var inst_73107 = (state_73187[(26)]);
var inst_73110 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_73107,(1));
var state_73187__$1 = state_73187;
var statearr_73234_73294 = state_73187__$1;
(statearr_73234_73294[(2)] = inst_73110);

(statearr_73234_73294[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (5))){
var _ = (function (){var statearr_73235 = state_73187;
(statearr_73235[(4)] = cljs.core.rest((state_73187[(4)])));

return statearr_73235;
})();
var state_73187__$1 = state_73187;
var ex73230 = (state_73187__$1[(2)]);
var statearr_73236_73295 = state_73187__$1;
(statearr_73236_73295[(5)] = ex73230);


var statearr_73237_73296 = state_73187__$1;
(statearr_73237_73296[(1)] = (4));

(statearr_73237_73296[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (14))){
var inst_73103 = (state_73187[(19)]);
var inst_73120 = (state_73187[(2)]);
var inst_73121 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73120,(0),null);
var inst_73122 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73120,(1),null);
var state_73187__$1 = (function (){var statearr_73238 = state_73187;
(statearr_73238[(27)] = inst_73121);

(statearr_73238[(14)] = inst_73122);

return statearr_73238;
})();
if(cljs.core.truth_(inst_73103)){
var statearr_73239_73297 = state_73187__$1;
(statearr_73239_73297[(1)] = (15));

} else {
var statearr_73240_73298 = state_73187__$1;
(statearr_73240_73298[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (26))){
var inst_73092 = (state_73187[(28)]);
var inst_73132 = (state_73187[(8)]);
var inst_73113 = (state_73187[(22)]);
var inst_73102 = (state_73187[(29)]);
var inst_73101 = (state_73187[(10)]);
var inst_73097 = (state_73187[(30)]);
var inst_73096 = (state_73187[(31)]);
var inst_73094 = (state_73187[(32)]);
var inst_73106 = (state_73187[(23)]);
var inst_73104 = (state_73187[(33)]);
var inst_73098 = (state_73187[(34)]);
var inst_73100 = (state_73187[(35)]);
var inst_73137 = (state_73187[(21)]);
var inst_73142 = (state_73187[(2)]);
var inst_73143 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"copy","copy",-1077617309),new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"alias","alias",-2039751630),new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710),new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508)];
var inst_73144 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73106),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73113)].join('');
var inst_73145 = [inst_73144,inst_73097,inst_73098,new cljs.core.Keyword(null,"new-ledger","new-ledger",34666434),inst_73142,inst_73100,inst_73132,inst_73104,inst_73102,inst_73092,inst_73137,inst_73094,inst_73096];
var inst_73146 = cljs.core.PersistentHashMap.fromArrays(inst_73143,inst_73145);
var state_73187__$1 = (function (){var statearr_73241 = state_73187;
(statearr_73241[(11)] = inst_73146);

return statearr_73241;
})();
if(cljs.core.truth_(inst_73101)){
var statearr_73242_73299 = state_73187__$1;
(statearr_73242_73299[(1)] = (27));

} else {
var statearr_73243_73300 = state_73187__$1;
(statearr_73243_73300[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (16))){
var state_73187__$1 = state_73187;
var statearr_73244_73301 = state_73187__$1;
(statearr_73244_73301[(2)] = null);

(statearr_73244_73301[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (38))){
var inst_73177 = (state_73187[(2)]);
var inst_73178 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_73179 = [(200),inst_73177];
var inst_73180 = cljs.core.PersistentHashMap.fromArrays(inst_73178,inst_73179);
var inst_73181 = cljs.core.clj__GT_js(inst_73180);
var inst_73182 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_73181) : resolve.call(null,inst_73181));
var _ = (function (){var statearr_73245 = state_73187;
(statearr_73245[(4)] = cljs.core.rest((state_73187[(4)])));

return statearr_73245;
})();
var state_73187__$1 = state_73187;
var statearr_73246_73302 = state_73187__$1;
(statearr_73246_73302[(2)] = inst_73182);

(statearr_73246_73302[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (30))){
var inst_73151 = (state_73187[(18)]);
var inst_73153 = fluree.db.util.core.without_nils(inst_73151);
var inst_73154 = fluree.db.util.json.stringify(inst_73153);
var state_73187__$1 = state_73187;
var statearr_73247_73303 = state_73187__$1;
(statearr_73247_73303[(2)] = inst_73154);

(statearr_73247_73303[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (10))){
var inst_73107 = (state_73187[(26)]);
var state_73187__$1 = state_73187;
var statearr_73248_73304 = state_73187__$1;
(statearr_73248_73304[(2)] = inst_73107);

(statearr_73248_73304[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (18))){
var inst_73121 = (state_73187[(27)]);
var inst_73122 = (state_73187[(14)]);
var inst_73129 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73121),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73122)].join('');
var state_73187__$1 = state_73187;
var statearr_73249_73305 = state_73187__$1;
(statearr_73249_73305[(2)] = inst_73129);

(statearr_73249_73305[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73188 === (37))){
var inst_73151 = (state_73187[(18)]);
var inst_73172 = fluree.db.operations.unsigned_command_async(conn,inst_73151);
var state_73187__$1 = state_73187;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73187__$1,(40),inst_73172);
} else {
if((state_val_73188 === (8))){
var inst_73107 = (state_73187[(26)]);
var inst_73088 = (state_73187[(2)]);
var inst_73089 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_73088);
var inst_73090 = cljs.core.__destructure_map(inst_73088);
var inst_73091 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_73090,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_73092 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73090,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_73093 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73090,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_73094 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73090,new cljs.core.Keyword(null,"doc","doc",1913296891));
var inst_73095 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73090,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_73096 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73090,new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508));
var inst_73097 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73090,new cljs.core.Keyword(null,"copy","copy",-1077617309));
var inst_73098 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73090,new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547));
var inst_73099 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73090,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_73100 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73090,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_73101 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73090,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var inst_73102 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73090,new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846));
var inst_73103 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73090,new cljs.core.Keyword(null,"alias","alias",-2039751630));
var inst_73104 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73090,new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710));
var inst_73105 = fluree.db.graphdb.validate_ledger_ident(ledger);
var inst_73106 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73105,(0),null);
var inst_73107__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73105,(1),null);
var inst_73108 = clojure.string.starts_with_QMARK_(inst_73107__$1,"$");
var state_73187__$1 = (function (){var statearr_73250 = state_73187;
(statearr_73250[(28)] = inst_73092);

(statearr_73250[(19)] = inst_73103);

(statearr_73250[(29)] = inst_73102);

(statearr_73250[(10)] = inst_73101);

(statearr_73250[(36)] = inst_73091);

(statearr_73250[(30)] = inst_73097);

(statearr_73250[(31)] = inst_73096);

(statearr_73250[(32)] = inst_73094);

(statearr_73250[(15)] = inst_73095);

(statearr_73250[(12)] = inst_73099);

(statearr_73250[(37)] = inst_73089);

(statearr_73250[(23)] = inst_73106);

(statearr_73250[(33)] = inst_73104);

(statearr_73250[(34)] = inst_73098);

(statearr_73250[(35)] = inst_73100);

(statearr_73250[(7)] = inst_73093);

(statearr_73250[(26)] = inst_73107__$1);

return statearr_73250;
})();
if(inst_73108){
var statearr_73251_73306 = state_73187__$1;
(statearr_73251_73306[(1)] = (9));

} else {
var statearr_73252_73307 = state_73187__$1;
(statearr_73252_73307[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2684__auto__ = null;
var flureedb$state_machine__2684__auto____0 = (function (){
var statearr_73253 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73253[(0)] = flureedb$state_machine__2684__auto__);

(statearr_73253[(1)] = (1));

return statearr_73253;
});
var flureedb$state_machine__2684__auto____1 = (function (state_73187){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_73187);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e73254){var ex__2687__auto__ = e73254;
var statearr_73255_73308 = state_73187;
(statearr_73255_73308[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_73187[(4)]))){
var statearr_73256_73309 = state_73187;
(statearr_73256_73309[(1)] = cljs.core.first((state_73187[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73310 = state_73187;
state_73187 = G__73310;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$state_machine__2684__auto__ = function(state_73187){
switch(arguments.length){
case 0:
return flureedb$state_machine__2684__auto____0.call(this);
case 1:
return flureedb$state_machine__2684__auto____1.call(this,state_73187);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2684__auto____0;
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2684__auto____1;
return flureedb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_73257 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_73257[(6)] = c__2706__auto__);

return statearr_73257;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(flureedb.new_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a promise that will eventually contain a response or an exception
 *   if the timeout period has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
flureedb.monitor_tx = (function flureedb$monitor_tx(conn,ledger,txid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_73333){
var state_val_73334 = (state_73333[(1)]);
if((state_val_73334 === (1))){
var state_73333__$1 = state_73333;
var statearr_73335_73351 = state_73333__$1;
(statearr_73335_73351[(2)] = null);

(statearr_73335_73351[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73334 === (2))){
var _ = (function (){var statearr_73336 = state_73333;
(statearr_73336[(4)] = cljs.core.cons((5),(state_73333[(4)])));

return statearr_73336;
})();
var inst_73323 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1(conn);
var inst_73324 = fluree.db.api_js.monitor_tx(conn,ledger,txid,timeout_ms);
var state_73333__$1 = (function (){var statearr_73337 = state_73333;
(statearr_73337[(7)] = inst_73323);

return statearr_73337;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73333__$1,(6),inst_73324);
} else {
if((state_val_73334 === (3))){
var inst_73331 = (state_73333[(2)]);
var state_73333__$1 = state_73333;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73333__$1,inst_73331);
} else {
if((state_val_73334 === (4))){
var inst_73311 = (state_73333[(2)]);
var inst_73312 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73313 = [inst_73311];
var inst_73314 = (new cljs.core.PersistentVector(null,1,(5),inst_73312,inst_73313,null));
var inst_73315 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73314);
var inst_73316 = cljs.core.clj__GT_js(inst_73311);
var inst_73317 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_73316) : reject.call(null,inst_73316));
var state_73333__$1 = (function (){var statearr_73339 = state_73333;
(statearr_73339[(8)] = inst_73315);

return statearr_73339;
})();
var statearr_73340_73352 = state_73333__$1;
(statearr_73340_73352[(2)] = inst_73317);

(statearr_73340_73352[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73334 === (5))){
var _ = (function (){var statearr_73341 = state_73333;
(statearr_73341[(4)] = cljs.core.rest((state_73333[(4)])));

return statearr_73341;
})();
var state_73333__$1 = state_73333;
var ex73338 = (state_73333__$1[(2)]);
var statearr_73342_73353 = state_73333__$1;
(statearr_73342_73353[(5)] = ex73338);


var statearr_73343_73354 = state_73333__$1;
(statearr_73343_73354[(1)] = (4));

(statearr_73343_73354[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73334 === (6))){
var inst_73326 = (state_73333[(2)]);
var inst_73327 = cljs.core.clj__GT_js(inst_73326);
var inst_73328 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_73327) : resolve.call(null,inst_73327));
var _ = (function (){var statearr_73344 = state_73333;
(statearr_73344[(4)] = cljs.core.rest((state_73333[(4)])));

return statearr_73344;
})();
var state_73333__$1 = state_73333;
var statearr_73345_73355 = state_73333__$1;
(statearr_73345_73355[(2)] = inst_73328);

(statearr_73345_73355[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$monitor_tx_$_state_machine__2684__auto__ = null;
var flureedb$monitor_tx_$_state_machine__2684__auto____0 = (function (){
var statearr_73346 = [null,null,null,null,null,null,null,null,null];
(statearr_73346[(0)] = flureedb$monitor_tx_$_state_machine__2684__auto__);

(statearr_73346[(1)] = (1));

return statearr_73346;
});
var flureedb$monitor_tx_$_state_machine__2684__auto____1 = (function (state_73333){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_73333);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e73347){var ex__2687__auto__ = e73347;
var statearr_73348_73356 = state_73333;
(statearr_73348_73356[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_73333[(4)]))){
var statearr_73349_73357 = state_73333;
(statearr_73349_73357[(1)] = cljs.core.first((state_73333[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73358 = state_73333;
state_73333 = G__73358;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$monitor_tx_$_state_machine__2684__auto__ = function(state_73333){
switch(arguments.length){
case 0:
return flureedb$monitor_tx_$_state_machine__2684__auto____0.call(this);
case 1:
return flureedb$monitor_tx_$_state_machine__2684__auto____1.call(this,state_73333);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$monitor_tx_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$monitor_tx_$_state_machine__2684__auto____0;
flureedb$monitor_tx_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$monitor_tx_$_state_machine__2684__auto____1;
return flureedb$monitor_tx_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_73350 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_73350[(6)] = c__2706__auto__);

return statearr_73350;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
});
goog.exportSymbol('flureedb.monitor_tx', flureedb.monitor_tx);
/**
 * Submits a transaction for a ledger and a transaction. Returns a promise
 * that will eventually have the result of the tx, the txid (if :txid-only option used), or
 * an exception due to an invalid transaction or if the timeout occurs prior to a response.
 * 
 * Will locally sign a final transaction command if a private key is provided via :private-key
 * in the options, otherwise will submit the transaction to the connected ledger and request signature,
 * provided the ledger group has a default private key available for signing.
 * 
 * Options (opts) is a map with the following possible keys:
 * - private-key - The private key to use for signing. If not present, a default
 *                 private key will attempt to be used from the connection, if available.
 * - auth        - The auth id for the auth record being used. The private key must
 *                 correspond to this auth record, or an authority of this auth record.
 * - expire      - When this transaction should expire if not yet attempted.
 *                 Defaults to 5 minutes.
 * - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                 By default epoch milliseconds is used.
 * - deps        - List of one or more txids that must be successfully processed before
 *                 this tx is processed. If any fail, this tx will fail. (not yet implemented)
 * - txid-only   - Boolean (default of false). If true, will not wait for a response to the tx,
 *                 but instead return with the txid once it is successfully persisted by the
 *                 transactors. The txid can be used to look up/monitor the response at a later time.
 * - timeout     - will respond with an exception if timeout reached before response available.
 * - jwt         - token to access Fluree On-Demand
 * 
 */
flureedb.transact = (function flureedb$transact(var_args){
var G__73360 = arguments.length;
switch (G__73360) {
case 3:
return flureedb.transact.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.transact.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.transact', flureedb.transact);

(flureedb.transact.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return flureedb.transact.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(flureedb.transact.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_73389){
var state_val_73390 = (state_73389[(1)]);
if((state_val_73390 === (7))){
var inst_73375 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_73389__$1 = state_73389;
var statearr_73391_73412 = state_73389__$1;
(statearr_73391_73412[(2)] = inst_73375);

(statearr_73391_73412[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73390 === (1))){
var state_73389__$1 = state_73389;
var statearr_73392_73413 = state_73389__$1;
(statearr_73392_73413[(2)] = null);

(statearr_73392_73413[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73390 === (4))){
var inst_73361 = (state_73389[(2)]);
var inst_73362 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73363 = [inst_73361];
var inst_73364 = (new cljs.core.PersistentVector(null,1,(5),inst_73362,inst_73363,null));
var inst_73365 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73364);
var inst_73366 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_73361) : reject.call(null,inst_73361));
var state_73389__$1 = (function (){var statearr_73393 = state_73389;
(statearr_73393[(7)] = inst_73365);

return statearr_73393;
})();
var statearr_73394_73414 = state_73389__$1;
(statearr_73394_73414[(2)] = inst_73366);

(statearr_73394_73414[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73390 === (6))){
var state_73389__$1 = state_73389;
var statearr_73395_73415 = state_73389__$1;
(statearr_73395_73415[(2)] = null);

(statearr_73395_73415[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73390 === (3))){
var inst_73387 = (state_73389[(2)]);
var state_73389__$1 = state_73389;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73389__$1,inst_73387);
} else {
if((state_val_73390 === (2))){
var _ = (function (){var statearr_73397 = state_73389;
(statearr_73397[(4)] = cljs.core.cons((5),(state_73389[(4)])));

return statearr_73397;
})();
var inst_73372 = (opts == null);
var state_73389__$1 = state_73389;
if(cljs.core.truth_(inst_73372)){
var statearr_73398_73416 = state_73389__$1;
(statearr_73398_73416[(1)] = (6));

} else {
var statearr_73399_73417 = state_73389__$1;
(statearr_73399_73417[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73390 === (9))){
var inst_73382 = (state_73389[(2)]);
var inst_73383 = cljs.core.clj__GT_js(inst_73382);
var inst_73384 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_73383) : resolve.call(null,inst_73383));
var _ = (function (){var statearr_73400 = state_73389;
(statearr_73400[(4)] = cljs.core.rest((state_73389[(4)])));

return statearr_73400;
})();
var state_73389__$1 = state_73389;
var statearr_73401_73418 = state_73389__$1;
(statearr_73401_73418[(2)] = inst_73384);

(statearr_73401_73418[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73390 === (5))){
var _ = (function (){var statearr_73402 = state_73389;
(statearr_73402[(4)] = cljs.core.rest((state_73389[(4)])));

return statearr_73402;
})();
var state_73389__$1 = state_73389;
var ex73396 = (state_73389__$1[(2)]);
var statearr_73403_73419 = state_73389__$1;
(statearr_73403_73419[(5)] = ex73396);


var statearr_73404_73420 = state_73389__$1;
(statearr_73404_73420[(1)] = (4));

(statearr_73404_73420[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73390 === (8))){
var inst_73377 = (state_73389[(2)]);
var inst_73378 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_73377);
var inst_73379 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(txn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_73380 = fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_73379,inst_73377);
var state_73389__$1 = (function (){var statearr_73405 = state_73389;
(statearr_73405[(8)] = inst_73378);

return statearr_73405;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73389__$1,(9),inst_73380);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2684__auto__ = null;
var flureedb$state_machine__2684__auto____0 = (function (){
var statearr_73406 = [null,null,null,null,null,null,null,null,null];
(statearr_73406[(0)] = flureedb$state_machine__2684__auto__);

(statearr_73406[(1)] = (1));

return statearr_73406;
});
var flureedb$state_machine__2684__auto____1 = (function (state_73389){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_73389);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e73407){var ex__2687__auto__ = e73407;
var statearr_73408_73421 = state_73389;
(statearr_73408_73421[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_73389[(4)]))){
var statearr_73409_73422 = state_73389;
(statearr_73409_73422[(1)] = cljs.core.first((state_73389[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73423 = state_73389;
state_73389 = G__73423;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$state_machine__2684__auto__ = function(state_73389){
switch(arguments.length){
case 0:
return flureedb$state_machine__2684__auto____0.call(this);
case 1:
return flureedb$state_machine__2684__auto____1.call(this,state_73389);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2684__auto____0;
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2684__auto____1;
return flureedb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_73410 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_73410[(6)] = c__2706__auto__);

return statearr_73410;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(flureedb.transact.cljs$lang$maxFixedArity = 4);

/**
 * Returns a Promise that will eventually contain blocks from start block (inclusive)
 *   to end if provided (inclusive). Each block is a separate map, containing keys :block,
 *   :t and :flakes.
 */
flureedb.block_range = (function flureedb$block_range(var_args){
var G__73425 = arguments.length;
switch (G__73425) {
case 3:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range', flureedb.block_range);

(flureedb.block_range.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,start){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,start,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,start,end){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,end,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,start,end,opts){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_73457){
var state_val_73458 = (state_73457[(1)]);
if((state_val_73458 === (7))){
var inst_73440 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_73457__$1 = state_73457;
var statearr_73459_73480 = state_73457__$1;
(statearr_73459_73480[(2)] = inst_73440);

(statearr_73459_73480[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73458 === (1))){
var state_73457__$1 = state_73457;
var statearr_73460_73481 = state_73457__$1;
(statearr_73460_73481[(2)] = null);

(statearr_73460_73481[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73458 === (4))){
var inst_73426 = (state_73457[(2)]);
var inst_73427 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73428 = [inst_73426];
var inst_73429 = (new cljs.core.PersistentVector(null,1,(5),inst_73427,inst_73428,null));
var inst_73430 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73429);
var inst_73431 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_73426) : reject.call(null,inst_73426));
var state_73457__$1 = (function (){var statearr_73461 = state_73457;
(statearr_73461[(7)] = inst_73430);

return statearr_73461;
})();
var statearr_73462_73482 = state_73457__$1;
(statearr_73462_73482[(2)] = inst_73431);

(statearr_73462_73482[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73458 === (6))){
var state_73457__$1 = state_73457;
var statearr_73463_73483 = state_73457__$1;
(statearr_73463_73483[(2)] = null);

(statearr_73463_73483[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73458 === (3))){
var inst_73455 = (state_73457[(2)]);
var state_73457__$1 = state_73457;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73457__$1,inst_73455);
} else {
if((state_val_73458 === (2))){
var _ = (function (){var statearr_73465 = state_73457;
(statearr_73465[(4)] = cljs.core.cons((5),(state_73457[(4)])));

return statearr_73465;
})();
var inst_73437 = (opts == null);
var state_73457__$1 = state_73457;
if(cljs.core.truth_(inst_73437)){
var statearr_73466_73484 = state_73457__$1;
(statearr_73466_73484[(1)] = (6));

} else {
var statearr_73467_73485 = state_73457__$1;
(statearr_73467_73485[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73458 === (9))){
var inst_73442 = (state_73457[(8)]);
var inst_73445 = (state_73457[(2)]);
var inst_73446 = fluree.db.util.async.throw_err(inst_73445);
var inst_73447 = fluree.db.query.block.block_range(inst_73446,start,end,inst_73442);
var state_73457__$1 = state_73457;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73457__$1,(10),inst_73447);
} else {
if((state_val_73458 === (5))){
var _ = (function (){var statearr_73468 = state_73457;
(statearr_73468[(4)] = cljs.core.rest((state_73457[(4)])));

return statearr_73468;
})();
var state_73457__$1 = state_73457;
var ex73464 = (state_73457__$1[(2)]);
var statearr_73469_73486 = state_73457__$1;
(statearr_73469_73486[(5)] = ex73464);


var statearr_73470_73487 = state_73457__$1;
(statearr_73470_73487[(1)] = (4));

(statearr_73470_73487[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73458 === (10))){
var inst_73449 = (state_73457[(2)]);
var inst_73450 = fluree.db.util.async.throw_err(inst_73449);
var inst_73451 = cljs.core.clj__GT_js(inst_73450);
var inst_73452 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_73451) : resolve.call(null,inst_73451));
var _ = (function (){var statearr_73471 = state_73457;
(statearr_73471[(4)] = cljs.core.rest((state_73457[(4)])));

return statearr_73471;
})();
var state_73457__$1 = state_73457;
var statearr_73472_73488 = state_73457__$1;
(statearr_73472_73488[(2)] = inst_73452);

(statearr_73472_73488[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73458 === (8))){
var inst_73442 = (state_73457[(8)]);
var inst_73442__$1 = (state_73457[(2)]);
var inst_73443 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_73442__$1], 0));
var state_73457__$1 = (function (){var statearr_73473 = state_73457;
(statearr_73473[(8)] = inst_73442__$1);

return statearr_73473;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73457__$1,(9),inst_73443);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2684__auto__ = null;
var flureedb$state_machine__2684__auto____0 = (function (){
var statearr_73474 = [null,null,null,null,null,null,null,null,null];
(statearr_73474[(0)] = flureedb$state_machine__2684__auto__);

(statearr_73474[(1)] = (1));

return statearr_73474;
});
var flureedb$state_machine__2684__auto____1 = (function (state_73457){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_73457);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e73475){var ex__2687__auto__ = e73475;
var statearr_73476_73489 = state_73457;
(statearr_73476_73489[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_73457[(4)]))){
var statearr_73477_73490 = state_73457;
(statearr_73477_73490[(1)] = cljs.core.first((state_73457[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73491 = state_73457;
state_73457 = G__73491;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$state_machine__2684__auto__ = function(state_73457){
switch(arguments.length){
case 0:
return flureedb$state_machine__2684__auto____0.call(this);
case 1:
return flureedb$state_machine__2684__auto____1.call(this,state_73457);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2684__auto____0;
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2684__auto____1;
return flureedb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_73478 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_73478[(6)] = c__2706__auto__);

return statearr_73478;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(flureedb.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Returns a Promise that will eventually contain transaction information for blocks from
 * start block (inclusive) to end if provided (exclusive). Each block is a separate map,
 * containing keys :block :tx
 */
flureedb.block_range_with_txn = (function flureedb$block_range_with_txn(var_args){
var G__73493 = arguments.length;
switch (G__73493) {
case 3:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range_with_txn', flureedb.block_range_with_txn);

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,block_map){
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4(conn,ledger,block_map,null);
}));

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,block_map,opts){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_73531){
var state_val_73532 = (state_73531[(1)]);
if((state_val_73532 === (7))){
var inst_73509 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_73531__$1 = state_73531;
var statearr_73533_73554 = state_73531__$1;
(statearr_73533_73554[(2)] = inst_73509);

(statearr_73533_73554[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73532 === (1))){
var state_73531__$1 = state_73531;
var statearr_73534_73555 = state_73531__$1;
(statearr_73534_73555[(2)] = null);

(statearr_73534_73555[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73532 === (4))){
var inst_73494 = (state_73531[(2)]);
var inst_73495 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73496 = [inst_73494];
var inst_73497 = (new cljs.core.PersistentVector(null,1,(5),inst_73495,inst_73496,null));
var inst_73498 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73497);
var inst_73499 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_73494) : reject.call(null,inst_73494));
var state_73531__$1 = (function (){var statearr_73535 = state_73531;
(statearr_73535[(7)] = inst_73498);

return statearr_73535;
})();
var statearr_73536_73556 = state_73531__$1;
(statearr_73536_73556[(2)] = inst_73499);

(statearr_73536_73556[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73532 === (6))){
var state_73531__$1 = state_73531;
var statearr_73537_73557 = state_73531__$1;
(statearr_73537_73557[(2)] = null);

(statearr_73537_73557[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73532 === (3))){
var inst_73529 = (state_73531[(2)]);
var state_73531__$1 = state_73531;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73531__$1,inst_73529);
} else {
if((state_val_73532 === (2))){
var _ = (function (){var statearr_73539 = state_73531;
(statearr_73539[(4)] = cljs.core.cons((5),(state_73531[(4)])));

return statearr_73539;
})();
var inst_73506 = (opts == null);
var state_73531__$1 = state_73531;
if(cljs.core.truth_(inst_73506)){
var statearr_73540_73558 = state_73531__$1;
(statearr_73540_73558[(1)] = (6));

} else {
var statearr_73541_73559 = state_73531__$1;
(statearr_73541_73559[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73532 === (9))){
var inst_73514 = (state_73531[(8)]);
var inst_73511 = (state_73531[(9)]);
var inst_73515 = (state_73531[(10)]);
var inst_73518 = (state_73531[(2)]);
var inst_73519 = fluree.db.util.async.throw_err(inst_73518);
var inst_73520 = fluree.db.query.block.block_range(inst_73519,inst_73514,inst_73515,inst_73511);
var state_73531__$1 = state_73531;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73531__$1,(10),inst_73520);
} else {
if((state_val_73532 === (5))){
var _ = (function (){var statearr_73542 = state_73531;
(statearr_73542[(4)] = cljs.core.rest((state_73531[(4)])));

return statearr_73542;
})();
var state_73531__$1 = state_73531;
var ex73538 = (state_73531__$1[(2)]);
var statearr_73543_73560 = state_73531__$1;
(statearr_73543_73560[(5)] = ex73538);


var statearr_73544_73561 = state_73531__$1;
(statearr_73544_73561[(1)] = (4));

(statearr_73544_73561[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73532 === (10))){
var inst_73522 = (state_73531[(2)]);
var inst_73523 = fluree.db.util.async.throw_err(inst_73522);
var inst_73524 = fluree.db.query.range.block_with_tx_data(inst_73523);
var inst_73525 = cljs.core.clj__GT_js(inst_73524);
var inst_73526 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_73525) : resolve.call(null,inst_73525));
var _ = (function (){var statearr_73545 = state_73531;
(statearr_73545[(4)] = cljs.core.rest((state_73531[(4)])));

return statearr_73545;
})();
var state_73531__$1 = state_73531;
var statearr_73546_73562 = state_73531__$1;
(statearr_73546_73562[(2)] = inst_73526);

(statearr_73546_73562[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73532 === (8))){
var inst_73511 = (state_73531[(9)]);
var inst_73511__$1 = (state_73531[(2)]);
var inst_73512 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(block_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_73513 = cljs.core.__destructure_map(inst_73512);
var inst_73514 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73513,new cljs.core.Keyword(null,"start","start",-355208981));
var inst_73515 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73513,new cljs.core.Keyword(null,"end","end",-268185958));
var inst_73516 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_73511__$1], 0));
var state_73531__$1 = (function (){var statearr_73547 = state_73531;
(statearr_73547[(8)] = inst_73514);

(statearr_73547[(9)] = inst_73511__$1);

(statearr_73547[(10)] = inst_73515);

return statearr_73547;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73531__$1,(9),inst_73516);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2684__auto__ = null;
var flureedb$state_machine__2684__auto____0 = (function (){
var statearr_73548 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_73548[(0)] = flureedb$state_machine__2684__auto__);

(statearr_73548[(1)] = (1));

return statearr_73548;
});
var flureedb$state_machine__2684__auto____1 = (function (state_73531){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_73531);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e73549){var ex__2687__auto__ = e73549;
var statearr_73550_73563 = state_73531;
(statearr_73550_73563[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_73531[(4)]))){
var statearr_73551_73564 = state_73531;
(statearr_73551_73564[(1)] = cljs.core.first((state_73531[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73565 = state_73531;
state_73531 = G__73565;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$state_machine__2684__auto__ = function(state_73531){
switch(arguments.length){
case 0:
return flureedb$state_machine__2684__auto____0.call(this);
case 1:
return flureedb$state_machine__2684__auto____1.call(this,state_73531);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2684__auto____0;
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2684__auto____1;
return flureedb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_73552 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_73552[(6)] = c__2706__auto__);

return statearr_73552;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(flureedb.block_range_with_txn.cljs$lang$maxFixedArity = 4);

flureedb.block_query = (function flureedb$block_query(var_args){
var G__73567 = arguments.length;
switch (G__73567) {
case 3:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_query', flureedb.block_query);

(flureedb.block_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.block_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_73637){
var state_val_73638 = (state_73637[(1)]);
if((state_val_73638 === (7))){
var inst_73583 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_73637__$1 = state_73637;
var statearr_73639_73680 = state_73637__$1;
(statearr_73639_73680[(2)] = inst_73583);

(statearr_73639_73680[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73638 === (20))){
var inst_73585 = (state_73637[(7)]);
var inst_73579 = (state_73637[(8)]);
var inst_73621 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73622 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_73623 = (new cljs.core.PersistentVector(null,1,(5),inst_73621,inst_73622,null));
var inst_73624 = cljs.core.assoc_in(inst_73585,inst_73623,new cljs.core.Keyword(null,"block","block",664686210));
var inst_73625 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_73579,inst_73624);
var state_73637__$1 = state_73637;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73637__$1,(23),inst_73625);
} else {
if((state_val_73638 === (1))){
var state_73637__$1 = state_73637;
var statearr_73640_73681 = state_73637__$1;
(statearr_73640_73681[(2)] = null);

(statearr_73640_73681[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73638 === (4))){
var inst_73568 = (state_73637[(2)]);
var inst_73569 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73570 = [inst_73568];
var inst_73571 = (new cljs.core.PersistentVector(null,1,(5),inst_73569,inst_73570,null));
var inst_73572 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73571);
var inst_73573 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_73568) : reject.call(null,inst_73568));
var state_73637__$1 = (function (){var statearr_73641 = state_73637;
(statearr_73641[(9)] = inst_73572);

return statearr_73641;
})();
var statearr_73642_73682 = state_73637__$1;
(statearr_73642_73682[(2)] = inst_73573);

(statearr_73642_73682[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73638 === (15))){
var inst_73609 = (state_73637[(2)]);
var inst_73610 = fluree.db.util.async.throw_err(inst_73609);
var state_73637__$1 = state_73637;
var statearr_73643_73683 = state_73637__$1;
(statearr_73643_73683[(2)] = inst_73610);

(statearr_73643_73683[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73638 === (21))){
var inst_73630 = (state_73637[(2)]);
var inst_73631 = cljs.core.clj__GT_js(inst_73630);
var inst_73632 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_73631) : resolve.call(null,inst_73631));
var _ = (function (){var statearr_73644 = state_73637;
(statearr_73644[(4)] = cljs.core.rest((state_73637[(4)])));

return statearr_73644;
})();
var state_73637__$1 = state_73637;
var statearr_73645_73684 = state_73637__$1;
(statearr_73645_73684[(2)] = inst_73632);

(statearr_73645_73684[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73638 === (13))){
var state_73637__$1 = state_73637;
var statearr_73646_73685 = state_73637__$1;
(statearr_73646_73685[(2)] = null);

(statearr_73646_73685[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73638 === (22))){
var inst_73618 = (state_73637[(2)]);
var inst_73619 = fluree.db.util.async.throw_err(inst_73618);
var state_73637__$1 = state_73637;
var statearr_73647_73686 = state_73637__$1;
(statearr_73647_73686[(2)] = inst_73619);

(statearr_73647_73686[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73638 === (6))){
var state_73637__$1 = state_73637;
var statearr_73648_73687 = state_73637__$1;
(statearr_73648_73687[(2)] = null);

(statearr_73648_73687[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73638 === (17))){
var state_73637__$1 = state_73637;
var statearr_73649_73688 = state_73637__$1;
(statearr_73649_73688[(2)] = null);

(statearr_73649_73688[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73638 === (3))){
var inst_73635 = (state_73637[(2)]);
var state_73637__$1 = state_73637;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73637__$1,inst_73635);
} else {
if((state_val_73638 === (12))){
var inst_73593 = (state_73637[(10)]);
var inst_73597 = [new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var state_73637__$1 = (function (){var statearr_73650 = state_73637;
(statearr_73650[(11)] = inst_73597);

return statearr_73650;
})();
if(cljs.core.truth_(inst_73593)){
var statearr_73651_73689 = state_73637__$1;
(statearr_73651_73689[(1)] = (16));

} else {
var statearr_73652_73690 = state_73637__$1;
(statearr_73652_73690[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73638 === (2))){
var _ = (function (){var statearr_73653 = state_73637;
(statearr_73653[(4)] = cljs.core.cons((5),(state_73637[(4)])));

return statearr_73653;
})();
var inst_73579 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_73580 = (opts == null);
var state_73637__$1 = (function (){var statearr_73654 = state_73637;
(statearr_73654[(8)] = inst_73579);

return statearr_73654;
})();
if(cljs.core.truth_(inst_73580)){
var statearr_73655_73691 = state_73637__$1;
(statearr_73655_73691[(1)] = (6));

} else {
var statearr_73656_73692 = state_73637__$1;
(statearr_73656_73692[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73638 === (23))){
var inst_73627 = (state_73637[(2)]);
var inst_73628 = fluree.db.util.async.throw_err(inst_73627);
var state_73637__$1 = state_73637;
var statearr_73657_73693 = state_73637__$1;
(statearr_73657_73693[(2)] = inst_73628);

(statearr_73657_73693[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73638 === (19))){
var inst_73585 = (state_73637[(7)]);
var inst_73613 = (state_73637[(12)]);
var inst_73579 = (state_73637[(8)]);
var inst_73616 = fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(inst_73613,inst_73579,inst_73585);
var state_73637__$1 = state_73637;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73637__$1,(22),inst_73616);
} else {
if((state_val_73638 === (11))){
var inst_73587 = (state_73637[(13)]);
var inst_73585 = (state_73637[(7)]);
var inst_73593 = (state_73637[(2)]);
var inst_73594 = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(inst_73585);
var inst_73595 = (inst_73587 == null);
var state_73637__$1 = (function (){var statearr_73659 = state_73637;
(statearr_73659[(14)] = inst_73594);

(statearr_73659[(10)] = inst_73593);

return statearr_73659;
})();
if(cljs.core.truth_(inst_73595)){
var statearr_73660_73694 = state_73637__$1;
(statearr_73660_73694[(1)] = (12));

} else {
var statearr_73661_73695 = state_73637__$1;
(statearr_73661_73695[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73638 === (9))){
var inst_73588 = (state_73637[(15)]);
var state_73637__$1 = state_73637;
var statearr_73662_73696 = state_73637__$1;
(statearr_73662_73696[(2)] = inst_73588);

(statearr_73662_73696[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73638 === (5))){
var _ = (function (){var statearr_73663 = state_73637;
(statearr_73663[(4)] = cljs.core.rest((state_73637[(4)])));

return statearr_73663;
})();
var state_73637__$1 = state_73637;
var ex73658 = (state_73637__$1[(2)]);
var statearr_73664_73697 = state_73637__$1;
(statearr_73664_73697[(5)] = ex73658);


var statearr_73665_73698 = state_73637__$1;
(statearr_73665_73698[(1)] = (4));

(statearr_73665_73698[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73638 === (14))){
var inst_73587 = (state_73637[(13)]);
var inst_73613 = (state_73637[(2)]);
var inst_73614 = (inst_73587 == null);
var state_73637__$1 = (function (){var statearr_73666 = state_73637;
(statearr_73666[(12)] = inst_73613);

return statearr_73666;
})();
if(cljs.core.truth_(inst_73614)){
var statearr_73667_73699 = state_73637__$1;
(statearr_73667_73699[(1)] = (19));

} else {
var statearr_73668_73700 = state_73637__$1;
(statearr_73668_73700[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73638 === (16))){
var inst_73593 = (state_73637[(10)]);
var inst_73599 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73600 = ["_auth/id",inst_73593];
var inst_73601 = (new cljs.core.PersistentVector(null,2,(5),inst_73599,inst_73600,null));
var state_73637__$1 = state_73637;
var statearr_73669_73701 = state_73637__$1;
(statearr_73669_73701[(2)] = inst_73601);

(statearr_73669_73701[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73638 === (10))){
var inst_73585 = (state_73637[(7)]);
var inst_73591 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_73585);
var state_73637__$1 = state_73637;
var statearr_73670_73702 = state_73637__$1;
(statearr_73670_73702[(2)] = inst_73591);

(statearr_73670_73702[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73638 === (18))){
var inst_73597 = (state_73637[(11)]);
var inst_73594 = (state_73637[(14)]);
var inst_73604 = (state_73637[(2)]);
var inst_73605 = [inst_73604,inst_73594];
var inst_73606 = cljs.core.PersistentHashMap.fromArrays(inst_73597,inst_73605);
var inst_73607 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_73606], 0));
var state_73637__$1 = state_73637;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73637__$1,(15),inst_73607);
} else {
if((state_val_73638 === (8))){
var inst_73588 = (state_73637[(15)]);
var inst_73585 = (state_73637[(7)]);
var inst_73585__$1 = (state_73637[(2)]);
var inst_73586 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_73585__$1);
var inst_73587 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(inst_73585__$1);
var inst_73588__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_73585__$1);
var state_73637__$1 = (function (){var statearr_73671 = state_73637;
(statearr_73671[(15)] = inst_73588__$1);

(statearr_73671[(13)] = inst_73587);

(statearr_73671[(16)] = inst_73586);

(statearr_73671[(7)] = inst_73585__$1);

return statearr_73671;
})();
if(cljs.core.truth_(inst_73588__$1)){
var statearr_73672_73703 = state_73637__$1;
(statearr_73672_73703[(1)] = (9));

} else {
var statearr_73673_73704 = state_73637__$1;
(statearr_73673_73704[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2684__auto__ = null;
var flureedb$state_machine__2684__auto____0 = (function (){
var statearr_73674 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73674[(0)] = flureedb$state_machine__2684__auto__);

(statearr_73674[(1)] = (1));

return statearr_73674;
});
var flureedb$state_machine__2684__auto____1 = (function (state_73637){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_73637);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e73675){var ex__2687__auto__ = e73675;
var statearr_73676_73705 = state_73637;
(statearr_73676_73705[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_73637[(4)]))){
var statearr_73677_73706 = state_73637;
(statearr_73677_73706[(1)] = cljs.core.first((state_73637[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73707 = state_73637;
state_73637 = G__73707;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$state_machine__2684__auto__ = function(state_73637){
switch(arguments.length){
case 0:
return flureedb$state_machine__2684__auto____0.call(this);
case 1:
return flureedb$state_machine__2684__auto____1.call(this,state_73637);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2684__auto____0;
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2684__auto____1;
return flureedb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_73678 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_73678[(6)] = c__2706__auto__);

return statearr_73678;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(flureedb.block_query.cljs$lang$maxFixedArity = 4);

flureedb.history_query = (function flureedb$history_query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_73730){
var state_val_73731 = (state_73730[(1)]);
if((state_val_73731 === (1))){
var state_73730__$1 = state_73730;
var statearr_73732_73747 = state_73730__$1;
(statearr_73732_73747[(2)] = null);

(statearr_73732_73747[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73731 === (2))){
var _ = (function (){var statearr_73733 = state_73730;
(statearr_73733[(4)] = cljs.core.cons((5),(state_73730[(4)])));

return statearr_73733;
})();
var inst_73719 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_73720 = fluree.db.api.query.history_query_async(sources,inst_73719);
var state_73730__$1 = state_73730;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73730__$1,(6),inst_73720);
} else {
if((state_val_73731 === (3))){
var inst_73728 = (state_73730[(2)]);
var state_73730__$1 = state_73730;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73730__$1,inst_73728);
} else {
if((state_val_73731 === (4))){
var inst_73708 = (state_73730[(2)]);
var inst_73709 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73710 = [inst_73708];
var inst_73711 = (new cljs.core.PersistentVector(null,1,(5),inst_73709,inst_73710,null));
var inst_73712 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73711);
var inst_73713 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_73708) : reject.call(null,inst_73708));
var state_73730__$1 = (function (){var statearr_73735 = state_73730;
(statearr_73735[(7)] = inst_73712);

return statearr_73735;
})();
var statearr_73736_73748 = state_73730__$1;
(statearr_73736_73748[(2)] = inst_73713);

(statearr_73736_73748[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73731 === (5))){
var _ = (function (){var statearr_73737 = state_73730;
(statearr_73737[(4)] = cljs.core.rest((state_73730[(4)])));

return statearr_73737;
})();
var state_73730__$1 = state_73730;
var ex73734 = (state_73730__$1[(2)]);
var statearr_73738_73749 = state_73730__$1;
(statearr_73738_73749[(5)] = ex73734);


var statearr_73739_73750 = state_73730__$1;
(statearr_73739_73750[(1)] = (4));

(statearr_73739_73750[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73731 === (6))){
var inst_73722 = (state_73730[(2)]);
var inst_73723 = fluree.db.util.async.throw_err(inst_73722);
var inst_73724 = cljs.core.clj__GT_js(inst_73723);
var inst_73725 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_73724) : resolve.call(null,inst_73724));
var _ = (function (){var statearr_73740 = state_73730;
(statearr_73740[(4)] = cljs.core.rest((state_73730[(4)])));

return statearr_73740;
})();
var state_73730__$1 = state_73730;
var statearr_73741_73751 = state_73730__$1;
(statearr_73741_73751[(2)] = inst_73725);

(statearr_73741_73751[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$history_query_$_state_machine__2684__auto__ = null;
var flureedb$history_query_$_state_machine__2684__auto____0 = (function (){
var statearr_73742 = [null,null,null,null,null,null,null,null];
(statearr_73742[(0)] = flureedb$history_query_$_state_machine__2684__auto__);

(statearr_73742[(1)] = (1));

return statearr_73742;
});
var flureedb$history_query_$_state_machine__2684__auto____1 = (function (state_73730){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_73730);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e73743){var ex__2687__auto__ = e73743;
var statearr_73744_73752 = state_73730;
(statearr_73744_73752[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_73730[(4)]))){
var statearr_73745_73753 = state_73730;
(statearr_73745_73753[(1)] = cljs.core.first((state_73730[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73754 = state_73730;
state_73730 = G__73754;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$history_query_$_state_machine__2684__auto__ = function(state_73730){
switch(arguments.length){
case 0:
return flureedb$history_query_$_state_machine__2684__auto____0.call(this);
case 1:
return flureedb$history_query_$_state_machine__2684__auto____1.call(this,state_73730);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$history_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$history_query_$_state_machine__2684__auto____0;
flureedb$history_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$history_query_$_state_machine__2684__auto____1;
return flureedb$history_query_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_73746 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_73746[(6)] = c__2706__auto__);

return statearr_73746;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
});
goog.exportSymbol('flureedb.history_query', flureedb.history_query);
flureedb.multi_query = (function flureedb$multi_query(sources,multi_query_map){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_73777){
var state_val_73778 = (state_73777[(1)]);
if((state_val_73778 === (1))){
var state_73777__$1 = state_73777;
var statearr_73779_73794 = state_73777__$1;
(statearr_73779_73794[(2)] = null);

(statearr_73779_73794[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73778 === (2))){
var _ = (function (){var statearr_73780 = state_73777;
(statearr_73780[(4)] = cljs.core.cons((5),(state_73777[(4)])));

return statearr_73780;
})();
var inst_73766 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(multi_query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_73767 = fluree.db.api.query.multi_query_async(sources,inst_73766);
var state_73777__$1 = state_73777;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73777__$1,(6),inst_73767);
} else {
if((state_val_73778 === (3))){
var inst_73775 = (state_73777[(2)]);
var state_73777__$1 = state_73777;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73777__$1,inst_73775);
} else {
if((state_val_73778 === (4))){
var inst_73755 = (state_73777[(2)]);
var inst_73756 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73757 = [inst_73755];
var inst_73758 = (new cljs.core.PersistentVector(null,1,(5),inst_73756,inst_73757,null));
var inst_73759 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73758);
var inst_73760 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_73755) : reject.call(null,inst_73755));
var state_73777__$1 = (function (){var statearr_73782 = state_73777;
(statearr_73782[(7)] = inst_73759);

return statearr_73782;
})();
var statearr_73783_73795 = state_73777__$1;
(statearr_73783_73795[(2)] = inst_73760);

(statearr_73783_73795[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73778 === (5))){
var _ = (function (){var statearr_73784 = state_73777;
(statearr_73784[(4)] = cljs.core.rest((state_73777[(4)])));

return statearr_73784;
})();
var state_73777__$1 = state_73777;
var ex73781 = (state_73777__$1[(2)]);
var statearr_73785_73796 = state_73777__$1;
(statearr_73785_73796[(5)] = ex73781);


var statearr_73786_73797 = state_73777__$1;
(statearr_73786_73797[(1)] = (4));

(statearr_73786_73797[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73778 === (6))){
var inst_73769 = (state_73777[(2)]);
var inst_73770 = fluree.db.util.async.throw_err(inst_73769);
var inst_73771 = cljs.core.clj__GT_js(inst_73770);
var inst_73772 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_73771) : resolve.call(null,inst_73771));
var _ = (function (){var statearr_73787 = state_73777;
(statearr_73787[(4)] = cljs.core.rest((state_73777[(4)])));

return statearr_73787;
})();
var state_73777__$1 = state_73777;
var statearr_73788_73798 = state_73777__$1;
(statearr_73788_73798[(2)] = inst_73772);

(statearr_73788_73798[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$multi_query_$_state_machine__2684__auto__ = null;
var flureedb$multi_query_$_state_machine__2684__auto____0 = (function (){
var statearr_73789 = [null,null,null,null,null,null,null,null];
(statearr_73789[(0)] = flureedb$multi_query_$_state_machine__2684__auto__);

(statearr_73789[(1)] = (1));

return statearr_73789;
});
var flureedb$multi_query_$_state_machine__2684__auto____1 = (function (state_73777){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_73777);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e73790){var ex__2687__auto__ = e73790;
var statearr_73791_73799 = state_73777;
(statearr_73791_73799[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_73777[(4)]))){
var statearr_73792_73800 = state_73777;
(statearr_73792_73800[(1)] = cljs.core.first((state_73777[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73801 = state_73777;
state_73777 = G__73801;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$multi_query_$_state_machine__2684__auto__ = function(state_73777){
switch(arguments.length){
case 0:
return flureedb$multi_query_$_state_machine__2684__auto____0.call(this);
case 1:
return flureedb$multi_query_$_state_machine__2684__auto____1.call(this,state_73777);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$multi_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$multi_query_$_state_machine__2684__auto____0;
flureedb$multi_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$multi_query_$_state_machine__2684__auto____1;
return flureedb$multi_query_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_73793 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_73793[(6)] = c__2706__auto__);

return statearr_73793;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
});
goog.exportSymbol('flureedb.multi_query', flureedb.multi_query);
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 * 
 *   Returns promise containing results.
 */
flureedb.query = (function flureedb$query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_73824){
var state_val_73825 = (state_73824[(1)]);
if((state_val_73825 === (1))){
var state_73824__$1 = state_73824;
var statearr_73826_73841 = state_73824__$1;
(statearr_73826_73841[(2)] = null);

(statearr_73826_73841[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73825 === (2))){
var _ = (function (){var statearr_73827 = state_73824;
(statearr_73827[(4)] = cljs.core.cons((5),(state_73824[(4)])));

return statearr_73827;
})();
var inst_73814 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_73815 = fluree.db.api.query.query_async(sources,inst_73814);
var state_73824__$1 = state_73824;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73824__$1,(6),inst_73815);
} else {
if((state_val_73825 === (3))){
var inst_73822 = (state_73824[(2)]);
var state_73824__$1 = state_73824;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73824__$1,inst_73822);
} else {
if((state_val_73825 === (4))){
var inst_73802 = (state_73824[(2)]);
var inst_73803 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73804 = [inst_73802];
var inst_73805 = (new cljs.core.PersistentVector(null,1,(5),inst_73803,inst_73804,null));
var inst_73806 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73805);
var inst_73807 = cljs.core.clj__GT_js(inst_73802);
var inst_73808 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_73807) : reject.call(null,inst_73807));
var state_73824__$1 = (function (){var statearr_73829 = state_73824;
(statearr_73829[(7)] = inst_73806);

return statearr_73829;
})();
var statearr_73830_73842 = state_73824__$1;
(statearr_73830_73842[(2)] = inst_73808);

(statearr_73830_73842[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73825 === (5))){
var _ = (function (){var statearr_73831 = state_73824;
(statearr_73831[(4)] = cljs.core.rest((state_73824[(4)])));

return statearr_73831;
})();
var state_73824__$1 = state_73824;
var ex73828 = (state_73824__$1[(2)]);
var statearr_73832_73843 = state_73824__$1;
(statearr_73832_73843[(5)] = ex73828);


var statearr_73833_73844 = state_73824__$1;
(statearr_73833_73844[(1)] = (4));

(statearr_73833_73844[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73825 === (6))){
var inst_73817 = (state_73824[(2)]);
var inst_73818 = cljs.core.clj__GT_js(inst_73817);
var inst_73819 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_73818) : resolve.call(null,inst_73818));
var _ = (function (){var statearr_73834 = state_73824;
(statearr_73834[(4)] = cljs.core.rest((state_73824[(4)])));

return statearr_73834;
})();
var state_73824__$1 = state_73824;
var statearr_73835_73845 = state_73824__$1;
(statearr_73835_73845[(2)] = inst_73819);

(statearr_73835_73845[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$query_$_state_machine__2684__auto__ = null;
var flureedb$query_$_state_machine__2684__auto____0 = (function (){
var statearr_73836 = [null,null,null,null,null,null,null,null];
(statearr_73836[(0)] = flureedb$query_$_state_machine__2684__auto__);

(statearr_73836[(1)] = (1));

return statearr_73836;
});
var flureedb$query_$_state_machine__2684__auto____1 = (function (state_73824){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_73824);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e73837){var ex__2687__auto__ = e73837;
var statearr_73838_73846 = state_73824;
(statearr_73838_73846[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_73824[(4)]))){
var statearr_73839_73847 = state_73824;
(statearr_73839_73847[(1)] = cljs.core.first((state_73824[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73848 = state_73824;
state_73824 = G__73848;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$query_$_state_machine__2684__auto__ = function(state_73824){
switch(arguments.length){
case 0:
return flureedb$query_$_state_machine__2684__auto____0.call(this);
case 1:
return flureedb$query_$_state_machine__2684__auto____1.call(this,state_73824);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$query_$_state_machine__2684__auto____0;
flureedb$query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$query_$_state_machine__2684__auto____1;
return flureedb$query_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_73840 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_73840[(6)] = c__2706__auto__);

return statearr_73840;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
});
goog.exportSymbol('flureedb.query', flureedb.query);
/**
 * Execute a query against a ledger, or optionally
 *   additional sources if the query spans multiple data sets.
 * 
 *   Returns promise containing results.
 */
flureedb.signed_query = (function flureedb$signed_query(var_args){
var G__73850 = arguments.length;
switch (G__73850) {
case 3:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.signed_query', flureedb.signed_query);

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_73880){
var state_val_73881 = (state_73880[(1)]);
if((state_val_73881 === (7))){
var inst_73867 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_73880__$1 = state_73880;
var statearr_73882_73903 = state_73880__$1;
(statearr_73882_73903[(2)] = inst_73867);

(statearr_73882_73903[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73881 === (1))){
var state_73880__$1 = state_73880;
var statearr_73883_73904 = state_73880__$1;
(statearr_73883_73904[(2)] = null);

(statearr_73883_73904[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73881 === (4))){
var inst_73851 = (state_73880[(2)]);
var inst_73852 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73853 = [inst_73851];
var inst_73854 = (new cljs.core.PersistentVector(null,1,(5),inst_73852,inst_73853,null));
var inst_73855 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73854);
var inst_73856 = cljs.core.clj__GT_js(inst_73851);
var inst_73857 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_73856) : reject.call(null,inst_73856));
var state_73880__$1 = (function (){var statearr_73884 = state_73880;
(statearr_73884[(7)] = inst_73855);

return statearr_73884;
})();
var statearr_73885_73905 = state_73880__$1;
(statearr_73885_73905[(2)] = inst_73857);

(statearr_73885_73905[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73881 === (6))){
var state_73880__$1 = state_73880;
var statearr_73886_73906 = state_73880__$1;
(statearr_73886_73906[(2)] = null);

(statearr_73886_73906[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73881 === (3))){
var inst_73878 = (state_73880[(2)]);
var state_73880__$1 = state_73880;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73880__$1,inst_73878);
} else {
if((state_val_73881 === (2))){
var _ = (function (){var statearr_73888 = state_73880;
(statearr_73888[(4)] = cljs.core.cons((5),(state_73880[(4)])));

return statearr_73888;
})();
var inst_73863 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_73864 = (opts == null);
var state_73880__$1 = (function (){var statearr_73889 = state_73880;
(statearr_73889[(8)] = inst_73863);

return statearr_73889;
})();
if(cljs.core.truth_(inst_73864)){
var statearr_73890_73907 = state_73880__$1;
(statearr_73890_73907[(1)] = (6));

} else {
var statearr_73891_73908 = state_73880__$1;
(statearr_73891_73908[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73881 === (9))){
var inst_73872 = (state_73880[(2)]);
var inst_73873 = fluree.db.util.async.throw_err(inst_73872);
var inst_73874 = cljs.core.clj__GT_js(inst_73873);
var inst_73875 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_73874) : resolve.call(null,inst_73874));
var _ = (function (){var statearr_73892 = state_73880;
(statearr_73892[(4)] = cljs.core.rest((state_73880[(4)])));

return statearr_73892;
})();
var state_73880__$1 = state_73880;
var statearr_73893_73909 = state_73880__$1;
(statearr_73893_73909[(2)] = inst_73875);

(statearr_73893_73909[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73881 === (5))){
var _ = (function (){var statearr_73894 = state_73880;
(statearr_73894[(4)] = cljs.core.rest((state_73880[(4)])));

return statearr_73894;
})();
var state_73880__$1 = state_73880;
var ex73887 = (state_73880__$1[(2)]);
var statearr_73895_73910 = state_73880__$1;
(statearr_73895_73910[(5)] = ex73887);


var statearr_73896_73911 = state_73880__$1;
(statearr_73896_73911[(1)] = (4));

(statearr_73896_73911[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73881 === (8))){
var inst_73863 = (state_73880[(8)]);
var inst_73869 = (state_73880[(2)]);
var inst_73870 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_73863,inst_73869);
var state_73880__$1 = state_73880;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73880__$1,(9),inst_73870);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2684__auto__ = null;
var flureedb$state_machine__2684__auto____0 = (function (){
var statearr_73897 = [null,null,null,null,null,null,null,null,null];
(statearr_73897[(0)] = flureedb$state_machine__2684__auto__);

(statearr_73897[(1)] = (1));

return statearr_73897;
});
var flureedb$state_machine__2684__auto____1 = (function (state_73880){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_73880);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e73898){var ex__2687__auto__ = e73898;
var statearr_73899_73912 = state_73880;
(statearr_73899_73912[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_73880[(4)]))){
var statearr_73900_73913 = state_73880;
(statearr_73900_73913[(1)] = cljs.core.first((state_73880[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73914 = state_73880;
state_73880 = G__73914;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureedb$state_machine__2684__auto__ = function(state_73880){
switch(arguments.length){
case 0:
return flureedb$state_machine__2684__auto____0.call(this);
case 1:
return flureedb$state_machine__2684__auto____1.call(this,state_73880);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2684__auto____0;
flureedb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2684__auto____1;
return flureedb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_73901 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_73901[(6)] = c__2706__auto__);

return statearr_73901;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(flureedb.signed_query.cljs$lang$maxFixedArity = 4);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
flureedb.listen = (function flureedb$listen(conn,ledger,key,callback){
return fluree.db.connection_js.listen(conn,ledger,key,callback);
});
goog.exportSymbol('flureedb.listen', flureedb.listen);
/**
 * Closes a listener.
 */
flureedb.close_listener = (function flureedb$close_listener(conn,ledger,key){
return fluree.db.connection_js.close_listener(conn,ledger,key);
});
goog.exportSymbol('flureedb.close_listener', flureedb.close_listener);
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
flureedb.listeners = (function flureedb$listeners(conn){
return fluree.db.connection_js.listeners(conn);
});
goog.exportSymbol('flureedb.listeners', flureedb.listeners);
/**
 * Takes an http request and creates an http signature using a private key
 */
flureedb.http_signature = (function flureedb$http_signature(req_method,url,request,private_key,auth){
return fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$5(req_method,url,request,private_key,auth);
});
goog.exportSymbol('flureedb.http_signature', flureedb.http_signature);
