// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.dbfunctions.ctx');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__74096 = arguments.length;
switch (G__74096) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5802__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var block = temp__5802__auto__;
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___74135 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_74117){
var state_val_74118 = (state_74117[(1)]);
if((state_val_74118 === (1))){
var state_74117__$1 = state_74117;
var statearr_74119_74136 = state_74117__$1;
(statearr_74119_74136[(2)] = null);

(statearr_74119_74136[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74118 === (2))){
var _ = (function (){var statearr_74120 = state_74117;
(statearr_74120[(4)] = cljs.core.cons.call(null,(5),(state_74117[(4)])));

return statearr_74120;
})();
var inst_74103 = fluree.db.session.db.call(null,conn,ledger,null);
var state_74117__$1 = state_74117;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74117__$1,(7),inst_74103);
} else {
if((state_val_74118 === (3))){
var inst_74113 = (state_74117[(2)]);
var inst_74114 = cljs.core.async.put_BANG_.call(null,pc,inst_74113);
var inst_74115 = cljs.core.async.close_BANG_.call(null,pc);
var state_74117__$1 = (function (){var statearr_74122 = state_74117;
(statearr_74122[(7)] = inst_74114);

return statearr_74122;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74117__$1,inst_74115);
} else {
if((state_val_74118 === (4))){
var inst_74097 = (state_74117[(2)]);
var state_74117__$1 = state_74117;
var statearr_74123_74137 = state_74117__$1;
(statearr_74123_74137[(2)] = inst_74097);

(statearr_74123_74137[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74118 === (5))){
var _ = (function (){var statearr_74124 = state_74117;
(statearr_74124[(4)] = cljs.core.rest.call(null,(state_74117[(4)])));

return statearr_74124;
})();
var state_74117__$1 = state_74117;
var ex74121 = (state_74117__$1[(2)]);
var statearr_74125_74138 = state_74117__$1;
(statearr_74125_74138[(5)] = ex74121);


var statearr_74126_74139 = state_74117__$1;
(statearr_74126_74139[(1)] = (4));

(statearr_74126_74139[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74118 === (6))){
var inst_74109 = (state_74117[(2)]);
var inst_74110 = fluree.db.util.async.throw_err.call(null,inst_74109);
var _ = (function (){var statearr_74127 = state_74117;
(statearr_74127[(4)] = cljs.core.rest.call(null,(state_74117[(4)])));

return statearr_74127;
})();
var state_74117__$1 = state_74117;
var statearr_74128_74140 = state_74117__$1;
(statearr_74128_74140[(2)] = inst_74110);

(statearr_74128_74140[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74118 === (7))){
var inst_74105 = (state_74117[(2)]);
var inst_74106 = fluree.db.util.async.throw_err.call(null,inst_74105);
var inst_74107 = fluree.db.time_travel.as_of_block.call(null,inst_74106,block);
var state_74117__$1 = state_74117;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74117__$1,(6),inst_74107);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2746__auto__ = null;
var fluree$db$api$ledger$state_machine__2746__auto____0 = (function (){
var statearr_74129 = [null,null,null,null,null,null,null,null];
(statearr_74129[(0)] = fluree$db$api$ledger$state_machine__2746__auto__);

(statearr_74129[(1)] = (1));

return statearr_74129;
});
var fluree$db$api$ledger$state_machine__2746__auto____1 = (function (state_74117){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_74117);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e74130){var ex__2749__auto__ = e74130;
var statearr_74131_74141 = state_74117;
(statearr_74131_74141[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_74117[(4)]))){
var statearr_74132_74142 = state_74117;
(statearr_74132_74142[(1)] = cljs.core.first.call(null,(state_74117[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74143 = state_74117;
state_74117 = G__74143;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2746__auto__ = function(state_74117){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2746__auto____1.call(this,state_74117);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2746__auto____0;
fluree$db$api$ledger$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2746__auto____1;
return fluree$db$api$ledger$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_74133 = f__2769__auto__.call(null);
(statearr_74133[(6)] = c__2768__auto___74135);

return statearr_74133;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
} else {
return fluree.db.session.db.call(null,conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t.call(null,db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_74184){
var state_val_74185 = (state_74184[(1)]);
if((state_val_74185 === (7))){
var inst_74153 = cljs.core._EQ_.call(null,(0),auth);
var state_74184__$1 = state_74184;
if(inst_74153){
var statearr_74186_74217 = state_74184__$1;
(statearr_74186_74217[(1)] = (9));

} else {
var statearr_74187_74218 = state_74184__$1;
(statearr_74187_74218[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74185 === (1))){
var state_74184__$1 = state_74184;
var statearr_74188_74219 = state_74184__$1;
(statearr_74188_74219[(2)] = null);

(statearr_74188_74219[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74185 === (4))){
var inst_74144 = (state_74184[(2)]);
var state_74184__$1 = state_74184;
var statearr_74189_74220 = state_74184__$1;
(statearr_74189_74220[(2)] = inst_74144);

(statearr_74189_74220[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74185 === (15))){
var inst_74161 = (state_74184[(7)]);
var inst_74160 = (state_74184[(2)]);
var inst_74161__$1 = fluree.db.util.async.throw_err.call(null,inst_74160);
var state_74184__$1 = (function (){var statearr_74190 = state_74184;
(statearr_74190[(7)] = inst_74161__$1);

return statearr_74190;
})();
if(cljs.core.truth_(inst_74161__$1)){
var statearr_74191_74221 = state_74184__$1;
(statearr_74191_74221[(1)] = (16));

} else {
var statearr_74192_74222 = state_74184__$1;
(statearr_74192_74222[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74185 === (13))){
var state_74184__$1 = state_74184;
var statearr_74193_74223 = state_74184__$1;
(statearr_74193_74223[(2)] = null);

(statearr_74193_74223[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74185 === (6))){
var state_74184__$1 = state_74184;
var statearr_74194_74224 = state_74184__$1;
(statearr_74194_74224[(2)] = db);

(statearr_74194_74224[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74185 === (17))){
var inst_74165 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_74166 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74167 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_74168 = cljs.core.PersistentHashMap.fromArrays(inst_74166,inst_74167);
var inst_74169 = cljs.core.ex_info.call(null,inst_74165,inst_74168);
var inst_74170 = (function(){throw inst_74169})();
var state_74184__$1 = state_74184;
var statearr_74195_74225 = state_74184__$1;
(statearr_74195_74225[(2)] = inst_74170);

(statearr_74195_74225[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74185 === (3))){
var inst_74182 = (state_74184[(2)]);
var state_74184__$1 = state_74184;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74184__$1,inst_74182);
} else {
if((state_val_74185 === (12))){
var inst_74158 = fluree.db.dbproto._subid.call(null,db,auth);
var state_74184__$1 = state_74184;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74184__$1,(15),inst_74158);
} else {
if((state_val_74185 === (2))){
var _ = (function (){var statearr_74196 = state_74184;
(statearr_74196[(4)] = cljs.core.cons.call(null,(5),(state_74184[(4)])));

return statearr_74196;
})();
var inst_74150 = cljs.core.not.call(null,auth);
var state_74184__$1 = state_74184;
if(inst_74150){
var statearr_74197_74226 = state_74184__$1;
(statearr_74197_74226[(1)] = (6));

} else {
var statearr_74198_74227 = state_74184__$1;
(statearr_74198_74227[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74185 === (11))){
var inst_74177 = (state_74184[(2)]);
var state_74184__$1 = state_74184;
var statearr_74200_74228 = state_74184__$1;
(statearr_74200_74228[(2)] = inst_74177);

(statearr_74200_74228[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74185 === (9))){
var inst_74155 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_74184__$1 = state_74184;
var statearr_74201_74229 = state_74184__$1;
(statearr_74201_74229[(2)] = inst_74155);

(statearr_74201_74229[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74185 === (5))){
var _ = (function (){var statearr_74202 = state_74184;
(statearr_74202[(4)] = cljs.core.rest.call(null,(state_74184[(4)])));

return statearr_74202;
})();
var state_74184__$1 = state_74184;
var ex74199 = (state_74184__$1[(2)]);
var statearr_74203_74230 = state_74184__$1;
(statearr_74203_74230[(5)] = ex74199);


if((ex74199 instanceof Error)){
var statearr_74204_74231 = state_74184__$1;
(statearr_74204_74231[(1)] = (4));

(statearr_74204_74231[(5)] = null);

} else {
throw ex74199;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74185 === (14))){
var inst_74175 = (state_74184[(2)]);
var state_74184__$1 = state_74184;
var statearr_74205_74232 = state_74184__$1;
(statearr_74205_74232[(2)] = inst_74175);

(statearr_74205_74232[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74185 === (16))){
var inst_74161 = (state_74184[(7)]);
var inst_74163 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_74161);
var state_74184__$1 = state_74184;
var statearr_74206_74233 = state_74184__$1;
(statearr_74206_74233[(2)] = inst_74163);

(statearr_74206_74233[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74185 === (10))){
var state_74184__$1 = state_74184;
var statearr_74207_74234 = state_74184__$1;
(statearr_74207_74234[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74185 === (18))){
var inst_74172 = (state_74184[(2)]);
var state_74184__$1 = state_74184;
var statearr_74209_74235 = state_74184__$1;
(statearr_74209_74235[(2)] = inst_74172);

(statearr_74209_74235[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74185 === (8))){
var inst_74179 = (state_74184[(2)]);
var _ = (function (){var statearr_74210 = state_74184;
(statearr_74210[(4)] = cljs.core.rest.call(null,(state_74184[(4)])));

return statearr_74210;
})();
var state_74184__$1 = state_74184;
var statearr_74211_74236 = state_74184__$1;
(statearr_74211_74236[(2)] = inst_74179);

(statearr_74211_74236[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____0 = (function (){
var statearr_74212 = [null,null,null,null,null,null,null,null];
(statearr_74212[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__);

(statearr_74212[(1)] = (1));

return statearr_74212;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____1 = (function (state_74184){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_74184);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e74213){var ex__2749__auto__ = e74213;
var statearr_74214_74237 = state_74184;
(statearr_74214_74237[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_74184[(4)]))){
var statearr_74215_74238 = state_74184;
(statearr_74215_74238[(1)] = cljs.core.first.call(null,(state_74184[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74239 = state_74184;
state_74184 = G__74239;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__ = function(state_74184){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____1.call(this,state_74184);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_74216 = f__2769__auto__.call(null);
(statearr_74216[(6)] = c__2768__auto__);

return statearr_74216;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_74311){
var state_val_74312 = (state_74311[(1)]);
if((state_val_74312 === (7))){
var inst_74249 = cljs.core._EQ_.call(null,(0),auth);
var state_74311__$1 = state_74311;
if(inst_74249){
var statearr_74313_74367 = state_74311__$1;
(statearr_74313_74367[(1)] = (9));

} else {
var statearr_74314_74368 = state_74311__$1;
(statearr_74314_74368[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74312 === (20))){
var inst_74273 = (state_74311[(7)]);
var state_74311__$1 = state_74311;
if(cljs.core.truth_(inst_74273)){
var statearr_74315_74369 = state_74311__$1;
(statearr_74315_74369[(1)] = (22));

} else {
var statearr_74316_74370 = state_74311__$1;
(statearr_74316_74370[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74312 === (27))){
var state_74311__$1 = state_74311;
var statearr_74317_74371 = state_74311__$1;
(statearr_74317_74371[(2)] = null);

(statearr_74317_74371[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74312 === (1))){
var state_74311__$1 = state_74311;
var statearr_74318_74372 = state_74311__$1;
(statearr_74318_74372[(2)] = null);

(statearr_74318_74372[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74312 === (24))){
var inst_74287 = (state_74311[(2)]);
var state_74311__$1 = state_74311;
var statearr_74319_74373 = state_74311__$1;
(statearr_74319_74373[(2)] = inst_74287);

(statearr_74319_74373[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74312 === (4))){
var inst_74240 = (state_74311[(2)]);
var state_74311__$1 = state_74311;
var statearr_74320_74374 = state_74311__$1;
(statearr_74320_74374[(2)] = inst_74240);

(statearr_74320_74374[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74312 === (15))){
var inst_74256 = (state_74311[(8)]);
var inst_74255 = (state_74311[(2)]);
var inst_74256__$1 = fluree.db.util.async.throw_err.call(null,inst_74255);
var state_74311__$1 = (function (){var statearr_74321 = state_74311;
(statearr_74321[(8)] = inst_74256__$1);

return statearr_74321;
})();
if(cljs.core.truth_(inst_74256__$1)){
var statearr_74322_74375 = state_74311__$1;
(statearr_74322_74375[(1)] = (16));

} else {
var statearr_74323_74376 = state_74311__$1;
(statearr_74323_74376[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74312 === (21))){
var inst_74289 = (state_74311[(9)]);
var inst_74289__$1 = (state_74311[(2)]);
var state_74311__$1 = (function (){var statearr_74324 = state_74311;
(statearr_74324[(9)] = inst_74289__$1);

return statearr_74324;
})();
if(cljs.core.truth_(inst_74289__$1)){
var statearr_74325_74377 = state_74311__$1;
(statearr_74325_74377[(1)] = (29));

} else {
var statearr_74326_74378 = state_74311__$1;
(statearr_74326_74378[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74312 === (31))){
var inst_74289 = (state_74311[(9)]);
var inst_74297 = (state_74311[(2)]);
var state_74311__$1 = (function (){var statearr_74327 = state_74311;
(statearr_74327[(10)] = inst_74297);

return statearr_74327;
})();
if(cljs.core.truth_(inst_74289)){
var statearr_74328_74379 = state_74311__$1;
(statearr_74328_74379[(1)] = (33));

} else {
var statearr_74329_74380 = state_74311__$1;
(statearr_74329_74380[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74312 === (32))){
var inst_74293 = (state_74311[(2)]);
var inst_74294 = fluree.db.util.async.throw_err.call(null,inst_74293);
var state_74311__$1 = state_74311;
var statearr_74330_74381 = state_74311__$1;
(statearr_74330_74381[(2)] = inst_74294);

(statearr_74330_74381[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74312 === (33))){
var inst_74289 = (state_74311[(9)]);
var inst_74299 = fluree.db.permissions.permission_map.call(null,db,inst_74289,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_74311__$1 = state_74311;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74311__$1,(36),inst_74299);
} else {
if((state_val_74312 === (13))){
var state_74311__$1 = state_74311;
var statearr_74331_74382 = state_74311__$1;
(statearr_74331_74382[(2)] = null);

(statearr_74331_74382[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74312 === (22))){
var inst_74273 = (state_74311[(7)]);
var inst_74277 = fluree.db.auth.roles.call(null,db,inst_74273);
var state_74311__$1 = state_74311;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74311__$1,(25),inst_74277);
} else {
if((state_val_74312 === (36))){
var inst_74301 = (state_74311[(2)]);
var inst_74302 = fluree.db.util.async.throw_err.call(null,inst_74301);
var state_74311__$1 = state_74311;
var statearr_74332_74383 = state_74311__$1;
(statearr_74332_74383[(2)] = inst_74302);

(statearr_74332_74383[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74312 === (29))){
var inst_74273 = (state_74311[(7)]);
var inst_74289 = (state_74311[(9)]);
var inst_74291 = fluree.db.dbfunctions.ctx.build.call(null,db,inst_74273,inst_74289);
var state_74311__$1 = state_74311;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74311__$1,(32),inst_74291);
} else {
if((state_val_74312 === (6))){
var state_74311__$1 = state_74311;
var statearr_74333_74384 = state_74311__$1;
(statearr_74333_74384[(2)] = null);

(statearr_74333_74384[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74312 === (28))){
var inst_74285 = (state_74311[(2)]);
var state_74311__$1 = state_74311;
var statearr_74334_74385 = state_74311__$1;
(statearr_74334_74385[(2)] = inst_74285);

(statearr_74334_74385[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74312 === (25))){
var inst_74279 = (state_74311[(2)]);
var inst_74280 = fluree.db.util.async.throw_err.call(null,inst_74279);
var state_74311__$1 = state_74311;
var statearr_74335_74386 = state_74311__$1;
(statearr_74335_74386[(2)] = inst_74280);

(statearr_74335_74386[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74312 === (34))){
var state_74311__$1 = state_74311;
var statearr_74336_74387 = state_74311__$1;
(statearr_74336_74387[(2)] = null);

(statearr_74336_74387[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74312 === (17))){
var inst_74259 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_74260 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74261 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_74262 = cljs.core.PersistentHashMap.fromArrays(inst_74260,inst_74261);
var inst_74263 = cljs.core.ex_info.call(null,inst_74259,inst_74262);
var inst_74264 = (function(){throw inst_74263})();
var state_74311__$1 = state_74311;
var statearr_74337_74388 = state_74311__$1;
(statearr_74337_74388[(2)] = inst_74264);

(statearr_74337_74388[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74312 === (3))){
var inst_74309 = (state_74311[(2)]);
var state_74311__$1 = state_74311;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74311__$1,inst_74309);
} else {
if((state_val_74312 === (12))){
var inst_74253 = fluree.db.dbproto._subid.call(null,db,auth);
var state_74311__$1 = state_74311;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74311__$1,(15),inst_74253);
} else {
if((state_val_74312 === (2))){
var _ = (function (){var statearr_74338 = state_74311;
(statearr_74338[(4)] = cljs.core.cons.call(null,(5),(state_74311[(4)])));

return statearr_74338;
})();
var inst_74246 = (auth == null);
var state_74311__$1 = state_74311;
if(cljs.core.truth_(inst_74246)){
var statearr_74339_74389 = state_74311__$1;
(statearr_74339_74389[(1)] = (6));

} else {
var statearr_74340_74390 = state_74311__$1;
(statearr_74340_74390[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74312 === (23))){
var state_74311__$1 = state_74311;
var statearr_74341_74391 = state_74311__$1;
(statearr_74341_74391[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74312 === (35))){
var inst_74297 = (state_74311[(10)]);
var inst_74273 = (state_74311[(7)]);
var inst_74289 = (state_74311[(9)]);
var inst_74305 = (state_74311[(2)]);
var inst_74306 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_74273,new cljs.core.Keyword(null,"auth-id","auth-id",444160740),auth,new cljs.core.Keyword(null,"roles","roles",143379530),inst_74289,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_74305,new cljs.core.Keyword(null,"ctx","ctx",-493610118),inst_74297);
var _ = (function (){var statearr_74343 = state_74311;
(statearr_74343[(4)] = cljs.core.rest.call(null,(state_74311[(4)])));

return statearr_74343;
})();
var state_74311__$1 = state_74311;
var statearr_74344_74392 = state_74311__$1;
(statearr_74344_74392[(2)] = inst_74306);

(statearr_74344_74392[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74312 === (19))){
var state_74311__$1 = state_74311;
var statearr_74345_74393 = state_74311__$1;
(statearr_74345_74393[(2)] = roles);

(statearr_74345_74393[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74312 === (11))){
var inst_74271 = (state_74311[(2)]);
var state_74311__$1 = state_74311;
var statearr_74347_74394 = state_74311__$1;
(statearr_74347_74394[(2)] = inst_74271);

(statearr_74347_74394[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74312 === (9))){
var state_74311__$1 = state_74311;
var statearr_74348_74395 = state_74311__$1;
(statearr_74348_74395[(2)] = (0));

(statearr_74348_74395[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74312 === (5))){
var _ = (function (){var statearr_74349 = state_74311;
(statearr_74349[(4)] = cljs.core.rest.call(null,(state_74311[(4)])));

return statearr_74349;
})();
var state_74311__$1 = state_74311;
var ex74346 = (state_74311__$1[(2)]);
var statearr_74350_74396 = state_74311__$1;
(statearr_74350_74396[(5)] = ex74346);


if((ex74346 instanceof Error)){
var statearr_74351_74397 = state_74311__$1;
(statearr_74351_74397[(1)] = (4));

(statearr_74351_74397[(5)] = null);

} else {
throw ex74346;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74312 === (14))){
var inst_74269 = (state_74311[(2)]);
var state_74311__$1 = state_74311;
var statearr_74352_74398 = state_74311__$1;
(statearr_74352_74398[(2)] = inst_74269);

(statearr_74352_74398[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74312 === (26))){
var state_74311__$1 = state_74311;
var statearr_74353_74399 = state_74311__$1;
(statearr_74353_74399[(2)] = null);

(statearr_74353_74399[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74312 === (16))){
var inst_74256 = (state_74311[(8)]);
var state_74311__$1 = state_74311;
var statearr_74354_74400 = state_74311__$1;
(statearr_74354_74400[(2)] = inst_74256);

(statearr_74354_74400[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74312 === (30))){
var state_74311__$1 = state_74311;
var statearr_74355_74401 = state_74311__$1;
(statearr_74355_74401[(2)] = null);

(statearr_74355_74401[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74312 === (10))){
var state_74311__$1 = state_74311;
if(cljs.core.truth_(auth)){
var statearr_74356_74402 = state_74311__$1;
(statearr_74356_74402[(1)] = (12));

} else {
var statearr_74357_74403 = state_74311__$1;
(statearr_74357_74403[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74312 === (18))){
var inst_74266 = (state_74311[(2)]);
var state_74311__$1 = state_74311;
var statearr_74358_74404 = state_74311__$1;
(statearr_74358_74404[(2)] = inst_74266);

(statearr_74358_74404[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74312 === (8))){
var inst_74273 = (state_74311[(2)]);
var state_74311__$1 = (function (){var statearr_74359 = state_74311;
(statearr_74359[(7)] = inst_74273);

return statearr_74359;
})();
if(cljs.core.truth_(roles)){
var statearr_74360_74405 = state_74311__$1;
(statearr_74360_74405[(1)] = (19));

} else {
var statearr_74361_74406 = state_74311__$1;
(statearr_74361_74406[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____0 = (function (){
var statearr_74362 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_74362[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__);

(statearr_74362[(1)] = (1));

return statearr_74362;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____1 = (function (state_74311){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_74311);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e74363){var ex__2749__auto__ = e74363;
var statearr_74364_74407 = state_74311;
(statearr_74364_74407[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_74311[(4)]))){
var statearr_74365_74408 = state_74311;
(statearr_74365_74408[(1)] = cljs.core.first.call(null,(state_74311[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74409 = state_74311;
state_74311 = G__74409;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__ = function(state_74311){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____1.call(this,state_74311);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_74366 = f__2769__auto__.call(null);
(statearr_74366[(6)] = c__2768__auto__);

return statearr_74366;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__74410 = db;
var map__74410__$1 = cljs.core.__destructure_map.call(null,map__74410);
var conn = cljs.core.get.call(null,map__74410__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__74410__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__74410__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
if(((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_.call(null,new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,listen_id);

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_74417){
var state_val_74418 = (state_74417[(1)]);
if((state_val_74418 === (1))){
var inst_74411 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_74412 = fluree.db.session.db.call(null,conn,inst_74411,null);
var state_74417__$1 = state_74417;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74417__$1,(2),inst_74412);
} else {
if((state_val_74418 === (2))){
var inst_74414 = (state_74417[(2)]);
var inst_74415 = cljs.core.async.put_BANG_.call(null,resp_port,inst_74414);
var state_74417__$1 = state_74417;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74417__$1,inst_74415);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0 = (function (){
var statearr_74419 = [null,null,null,null,null,null,null];
(statearr_74419[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__);

(statearr_74419[(1)] = (1));

return statearr_74419;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1 = (function (state_74417){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_74417);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e74420){var ex__2749__auto__ = e74420;
var statearr_74421_74448 = state_74417;
(statearr_74421_74448[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_74417[(4)]))){
var statearr_74422_74449 = state_74417;
(statearr_74422_74449[(1)] = cljs.core.first.call(null,(state_74417[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74450 = state_74417;
state_74417 = G__74450;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__ = function(state_74417){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1.call(this,state_74417);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_74423 = f__2769__auto__.call(null);
(statearr_74423[(6)] = c__2768__auto__);

return statearr_74423;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener.call(null,conn,network,ledger_id,listen_id,event_fn);

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_74436){
var state_val_74437 = (state_74436[(1)]);
if((state_val_74437 === (1))){
var inst_74424 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_74425 = fluree.db.session.db.call(null,conn,inst_74424,null);
var state_74436__$1 = state_74436;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74436__$1,(2),inst_74425);
} else {
if((state_val_74437 === (2))){
var inst_74427 = (state_74436[(7)]);
var inst_74427__$1 = (state_74436[(2)]);
var inst_74428 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_74427__$1);
var inst_74429 = newer_block_QMARK_.call(null,inst_74428);
var state_74436__$1 = (function (){var statearr_74438 = state_74436;
(statearr_74438[(7)] = inst_74427__$1);

return statearr_74438;
})();
if(inst_74429){
var statearr_74439_74451 = state_74436__$1;
(statearr_74439_74451[(1)] = (3));

} else {
var statearr_74440_74452 = state_74436__$1;
(statearr_74440_74452[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74437 === (3))){
var inst_74427 = (state_74436[(7)]);
var inst_74431 = cljs.core.async.put_BANG_.call(null,resp_port,inst_74427);
var state_74436__$1 = state_74436;
var statearr_74441_74453 = state_74436__$1;
(statearr_74441_74453[(2)] = inst_74431);

(statearr_74441_74453[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74437 === (4))){
var state_74436__$1 = state_74436;
var statearr_74442_74454 = state_74436__$1;
(statearr_74442_74454[(2)] = null);

(statearr_74442_74454[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74437 === (5))){
var inst_74434 = (state_74436[(2)]);
var state_74436__$1 = state_74436;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74436__$1,inst_74434);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0 = (function (){
var statearr_74443 = [null,null,null,null,null,null,null,null];
(statearr_74443[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__);

(statearr_74443[(1)] = (1));

return statearr_74443;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1 = (function (state_74436){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_74436);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e74444){var ex__2749__auto__ = e74444;
var statearr_74445_74455 = state_74436;
(statearr_74445_74455[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_74436[(4)]))){
var statearr_74446_74456 = state_74436;
(statearr_74446_74456[(1)] = cljs.core.first.call(null,(state_74436[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74457 = state_74436;
state_74436 = G__74457;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__ = function(state_74436){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1.call(this,state_74436);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_74447 = f__2769__auto__.call(null);
(statearr_74447[(6)] = c__2768__auto__);

return statearr_74447;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_.call(null,syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.call(null);
var map__74458 = db;
var map__74458__$1 = cljs.core.__destructure_map.call(null,map__74458);
var conn = cljs.core.get.call(null,map__74458__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__74458__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__74458__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var listen_id = cljs.core.random_uuid.call(null);
var timeout = ((cljs.core.pos_int_QMARK_.call(null,syncTimeout))?(function (){var x__5133__auto__ = syncTimeout;
var y__5134__auto__ = (120000);
return ((x__5133__auto__ < y__5134__auto__) ? x__5133__auto__ : y__5134__auto__);
})():(60000));
var res_port = cljs.core.async.chan.call(null);
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.call(null,pc,db);
} else {
fluree.db.api.ledger.syncTo_wait.call(null,db,syncTo,listen_id,res_port);

var c__2768__auto___74534 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_74508){
var state_val_74509 = (state_74508[(1)]);
if((state_val_74509 === (7))){
var inst_74474 = (state_74508[(7)]);
var inst_74485 = cljs.core._EQ_.call(null,inst_74474,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_74508__$1 = state_74508;
if(inst_74485){
var statearr_74510_74535 = state_74508__$1;
(statearr_74510_74535[(1)] = (9));

} else {
var statearr_74511_74536 = state_74508__$1;
(statearr_74511_74536[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74509 === (1))){
var inst_74459 = (state_74508[(8)]);
var inst_74467 = (state_74508[(9)]);
var inst_74459__$1 = cljs.core.async.timeout.call(null,timeout);
var inst_74467__$1 = res_port;
var inst_74468 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74469 = [inst_74459__$1,inst_74467__$1];
var inst_74470 = (new cljs.core.PersistentVector(null,2,(5),inst_74468,inst_74469,null));
var state_74508__$1 = (function (){var statearr_74512 = state_74508;
(statearr_74512[(8)] = inst_74459__$1);

(statearr_74512[(9)] = inst_74467__$1);

return statearr_74512;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_74508__$1,(2),inst_74470);
} else {
if((state_val_74509 === (4))){
var inst_74467 = (state_74508[(9)]);
var inst_74474 = (state_74508[(7)]);
var inst_74478 = cljs.core._EQ_.call(null,inst_74474,inst_74467);
var state_74508__$1 = state_74508;
if(inst_74478){
var statearr_74513_74537 = state_74508__$1;
(statearr_74513_74537[(1)] = (6));

} else {
var statearr_74514_74538 = state_74508__$1;
(statearr_74514_74538[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74509 === (13))){
var inst_74493 = (state_74508[(10)]);
var inst_74504 = cljs.core.async.put_BANG_.call(null,pc,inst_74493);
var state_74508__$1 = state_74508;
var statearr_74515_74539 = state_74508__$1;
(statearr_74515_74539[(2)] = inst_74504);

(statearr_74515_74539[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74509 === (6))){
var inst_74472 = (state_74508[(11)]);
var inst_74483 = cljs.core.nth.call(null,inst_74472,(0),null);
var state_74508__$1 = state_74508;
var statearr_74516_74540 = state_74508__$1;
(statearr_74516_74540[(2)] = inst_74483);

(statearr_74516_74540[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74509 === (3))){
var state_74508__$1 = state_74508;
var statearr_74517_74541 = state_74508__$1;
(statearr_74517_74541[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_74517_74541[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74509 === (12))){
var inst_74497 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_74498 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74499 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_74500 = cljs.core.PersistentHashMap.fromArrays(inst_74498,inst_74499);
var inst_74501 = cljs.core.ex_info.call(null,inst_74497,inst_74500);
var inst_74502 = cljs.core.async.put_BANG_.call(null,pc,inst_74501);
var state_74508__$1 = state_74508;
var statearr_74518_74542 = state_74508__$1;
(statearr_74518_74542[(2)] = inst_74502);

(statearr_74518_74542[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74509 === (2))){
var inst_74472 = (state_74508[(11)]);
var inst_74459 = (state_74508[(8)]);
var inst_74474 = (state_74508[(7)]);
var inst_74472__$1 = (state_74508[(2)]);
var inst_74473 = cljs.core.nth.call(null,inst_74472__$1,(0),null);
var inst_74474__$1 = cljs.core.nth.call(null,inst_74472__$1,(1),null);
var inst_74475 = cljs.core._EQ_.call(null,inst_74474__$1,inst_74459);
var state_74508__$1 = (function (){var statearr_74519 = state_74508;
(statearr_74519[(11)] = inst_74472__$1);

(statearr_74519[(12)] = inst_74473);

(statearr_74519[(7)] = inst_74474__$1);

return statearr_74519;
})();
if(inst_74475){
var statearr_74520_74543 = state_74508__$1;
(statearr_74520_74543[(1)] = (3));

} else {
var statearr_74521_74544 = state_74508__$1;
(statearr_74521_74544[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74509 === (11))){
var inst_74489 = (state_74508[(2)]);
var state_74508__$1 = state_74508;
var statearr_74522_74545 = state_74508__$1;
(statearr_74522_74545[(2)] = inst_74489);

(statearr_74522_74545[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74509 === (9))){
var inst_74473 = (state_74508[(12)]);
var state_74508__$1 = state_74508;
var statearr_74523_74546 = state_74508__$1;
(statearr_74523_74546[(2)] = inst_74473);

(statearr_74523_74546[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74509 === (5))){
var inst_74493 = (state_74508[(10)]);
var inst_74493__$1 = (state_74508[(2)]);
var inst_74494 = fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,listen_id);
var inst_74495 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_74493__$1);
var state_74508__$1 = (function (){var statearr_74524 = state_74508;
(statearr_74524[(10)] = inst_74493__$1);

(statearr_74524[(13)] = inst_74494);

return statearr_74524;
})();
if(inst_74495){
var statearr_74525_74547 = state_74508__$1;
(statearr_74525_74547[(1)] = (12));

} else {
var statearr_74526_74548 = state_74508__$1;
(statearr_74526_74548[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74509 === (14))){
var inst_74506 = (state_74508[(2)]);
var state_74508__$1 = state_74508;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74508__$1,inst_74506);
} else {
if((state_val_74509 === (10))){
var state_74508__$1 = state_74508;
var statearr_74527_74549 = state_74508__$1;
(statearr_74527_74549[(2)] = null);

(statearr_74527_74549[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74509 === (8))){
var inst_74491 = (state_74508[(2)]);
var state_74508__$1 = state_74508;
var statearr_74528_74550 = state_74508__$1;
(statearr_74528_74550[(2)] = inst_74491);

(statearr_74528_74550[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____0 = (function (){
var statearr_74529 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74529[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__);

(statearr_74529[(1)] = (1));

return statearr_74529;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____1 = (function (state_74508){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_74508);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e74530){var ex__2749__auto__ = e74530;
var statearr_74531_74551 = state_74508;
(statearr_74531_74551[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_74508[(4)]))){
var statearr_74532_74552 = state_74508;
(statearr_74532_74552[(1)] = cljs.core.first.call(null,(state_74508[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74553 = state_74508;
state_74508 = G__74553;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__ = function(state_74508){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____1.call(this,state_74508);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_74533 = f__2769__auto__.call(null);
(statearr_74533[(6)] = c__2768__auto___74534);

return statearr_74533;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__74555 = arguments.length;
switch (G__74555) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__74556){
var map__74557 = p__74556;
var map__74557__$1 = cljs.core.__destructure_map.call(null,map__74557);
var opts = map__74557__$1;
var roles = cljs.core.get.call(null,map__74557__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.call(null,map__74557__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.call(null,map__74557__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.call(null,map__74557__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.call(null,map__74557__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.call(null);
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2768__auto___74646 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_74608){
var state_val_74609 = (state_74608[(1)]);
if((state_val_74609 === (7))){
var inst_74570 = (state_74608[(7)]);
var inst_74572 = fluree.db.api.ledger.syncTo_db.call(null,inst_74570,syncTo,syncTimeout);
var state_74608__$1 = state_74608;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74608__$1,(10),inst_74572);
} else {
if((state_val_74609 === (20))){
var inst_74594 = (state_74608[(8)]);
var state_74608__$1 = state_74608;
var statearr_74610_74647 = state_74608__$1;
(statearr_74610_74647[(2)] = inst_74594);

(statearr_74610_74647[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74609 === (1))){
var state_74608__$1 = state_74608;
var statearr_74611_74648 = state_74608__$1;
(statearr_74611_74648[(2)] = null);

(statearr_74611_74648[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74609 === (4))){
var inst_74558 = (state_74608[(2)]);
var inst_74559 = cljs.core.async.put_BANG_.call(null,pc,inst_74558);
var inst_74560 = cljs.core.async.close_BANG_.call(null,pc);
var state_74608__$1 = (function (){var statearr_74612 = state_74608;
(statearr_74612[(9)] = inst_74559);

return statearr_74612;
})();
var statearr_74613_74649 = state_74608__$1;
(statearr_74613_74649[(2)] = inst_74560);

(statearr_74613_74649[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74609 === (15))){
var inst_74586 = (state_74608[(10)]);
var inst_74588 = fluree.db.api.ledger.add_db_permissions.call(null,inst_74586,auth,roles);
var state_74608__$1 = state_74608;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74608__$1,(18),inst_74588);
} else {
if((state_val_74609 === (21))){
var inst_74602 = (state_74608[(2)]);
var inst_74603 = cljs.core.async.put_BANG_.call(null,pc,inst_74602);
var _ = (function (){var statearr_74614 = state_74608;
(statearr_74614[(4)] = cljs.core.rest.call(null,(state_74608[(4)])));

return statearr_74614;
})();
var state_74608__$1 = state_74608;
var statearr_74615_74650 = state_74608__$1;
(statearr_74615_74650[(2)] = inst_74603);

(statearr_74615_74650[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74609 === (13))){
var inst_74586 = (state_74608[(2)]);
var state_74608__$1 = (function (){var statearr_74616 = state_74608;
(statearr_74616[(10)] = inst_74586);

return statearr_74616;
})();
if(cljs.core.truth_(roles)){
var statearr_74617_74651 = state_74608__$1;
(statearr_74617_74651[(1)] = (15));

} else {
var statearr_74618_74652 = state_74608__$1;
(statearr_74618_74652[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74609 === (22))){
var inst_74598 = (state_74608[(2)]);
var inst_74599 = fluree.db.util.async.throw_err.call(null,inst_74598);
var state_74608__$1 = state_74608;
var statearr_74619_74653 = state_74608__$1;
(statearr_74619_74653[(2)] = inst_74599);

(statearr_74619_74653[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74609 === (6))){
var inst_74569 = (state_74608[(2)]);
var inst_74570 = fluree.db.util.async.throw_err.call(null,inst_74569);
var state_74608__$1 = (function (){var statearr_74620 = state_74608;
(statearr_74620[(7)] = inst_74570);

return statearr_74620;
})();
if(cljs.core.truth_(syncTo)){
var statearr_74621_74654 = state_74608__$1;
(statearr_74621_74654[(1)] = (7));

} else {
var statearr_74622_74655 = state_74608__$1;
(statearr_74622_74655[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74609 === (17))){
var inst_74594 = (state_74608[(2)]);
var state_74608__$1 = (function (){var statearr_74623 = state_74608;
(statearr_74623[(8)] = inst_74594);

return statearr_74623;
})();
if(cljs.core.truth_(auth)){
var statearr_74624_74656 = state_74608__$1;
(statearr_74624_74656[(1)] = (19));

} else {
var statearr_74625_74657 = state_74608__$1;
(statearr_74625_74657[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74609 === (3))){
var inst_74606 = (state_74608[(2)]);
var state_74608__$1 = state_74608;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74608__$1,inst_74606);
} else {
if((state_val_74609 === (12))){
var inst_74578 = (state_74608[(11)]);
var state_74608__$1 = state_74608;
var statearr_74626_74658 = state_74608__$1;
(statearr_74626_74658[(2)] = inst_74578);

(statearr_74626_74658[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74609 === (2))){
var _ = (function (){var statearr_74627 = state_74608;
(statearr_74627[(4)] = cljs.core.cons.call(null,(5),(state_74608[(4)])));

return statearr_74627;
})();
var inst_74567 = fluree.db.session.db.call(null,conn,ledger,opts_SINGLEQUOTE_);
var state_74608__$1 = state_74608;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74608__$1,(6),inst_74567);
} else {
if((state_val_74609 === (19))){
var inst_74594 = (state_74608[(8)]);
var inst_74596 = fluree.db.api.ledger.add_db_permissions.call(null,inst_74594,auth,roles);
var state_74608__$1 = state_74608;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74608__$1,(22),inst_74596);
} else {
if((state_val_74609 === (11))){
var inst_74578 = (state_74608[(11)]);
var inst_74580 = fluree.db.time_travel.as_of_block.call(null,inst_74578,block);
var state_74608__$1 = state_74608;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74608__$1,(14),inst_74580);
} else {
if((state_val_74609 === (9))){
var inst_74578 = (state_74608[(2)]);
var state_74608__$1 = (function (){var statearr_74629 = state_74608;
(statearr_74629[(11)] = inst_74578);

return statearr_74629;
})();
if(cljs.core.truth_(block)){
var statearr_74630_74659 = state_74608__$1;
(statearr_74630_74659[(1)] = (11));

} else {
var statearr_74631_74660 = state_74608__$1;
(statearr_74631_74660[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74609 === (5))){
var _ = (function (){var statearr_74632 = state_74608;
(statearr_74632[(4)] = cljs.core.rest.call(null,(state_74608[(4)])));

return statearr_74632;
})();
var state_74608__$1 = state_74608;
var ex74628 = (state_74608__$1[(2)]);
var statearr_74633_74661 = state_74608__$1;
(statearr_74633_74661[(5)] = ex74628);


var statearr_74634_74662 = state_74608__$1;
(statearr_74634_74662[(1)] = (4));

(statearr_74634_74662[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74609 === (14))){
var inst_74582 = (state_74608[(2)]);
var inst_74583 = fluree.db.util.async.throw_err.call(null,inst_74582);
var state_74608__$1 = state_74608;
var statearr_74635_74663 = state_74608__$1;
(statearr_74635_74663[(2)] = inst_74583);

(statearr_74635_74663[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74609 === (16))){
var inst_74586 = (state_74608[(10)]);
var state_74608__$1 = state_74608;
var statearr_74636_74664 = state_74608__$1;
(statearr_74636_74664[(2)] = inst_74586);

(statearr_74636_74664[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74609 === (10))){
var inst_74574 = (state_74608[(2)]);
var inst_74575 = fluree.db.util.async.throw_err.call(null,inst_74574);
var state_74608__$1 = state_74608;
var statearr_74637_74665 = state_74608__$1;
(statearr_74637_74665[(2)] = inst_74575);

(statearr_74637_74665[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74609 === (18))){
var inst_74590 = (state_74608[(2)]);
var inst_74591 = fluree.db.util.async.throw_err.call(null,inst_74590);
var state_74608__$1 = state_74608;
var statearr_74638_74666 = state_74608__$1;
(statearr_74638_74666[(2)] = inst_74591);

(statearr_74638_74666[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74609 === (8))){
var inst_74570 = (state_74608[(7)]);
var state_74608__$1 = state_74608;
var statearr_74639_74667 = state_74608__$1;
(statearr_74639_74667[(2)] = inst_74570);

(statearr_74639_74667[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2746__auto__ = null;
var fluree$db$api$ledger$state_machine__2746__auto____0 = (function (){
var statearr_74640 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74640[(0)] = fluree$db$api$ledger$state_machine__2746__auto__);

(statearr_74640[(1)] = (1));

return statearr_74640;
});
var fluree$db$api$ledger$state_machine__2746__auto____1 = (function (state_74608){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_74608);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e74641){var ex__2749__auto__ = e74641;
var statearr_74642_74668 = state_74608;
(statearr_74642_74668[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_74608[(4)]))){
var statearr_74643_74669 = state_74608;
(statearr_74643_74669[(1)] = cljs.core.first.call(null,(state_74608[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74670 = state_74608;
state_74608 = G__74670;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2746__auto__ = function(state_74608){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2746__auto____1.call(this,state_74608);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2746__auto____0;
fluree$db$api$ledger$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2746__auto____1;
return fluree$db$api$ledger$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_74644 = f__2769__auto__.call(null);
(statearr_74644[(6)] = c__2768__auto___74646);

return statearr_74644;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

