// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.call(null,new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt.call(null,secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__68963 = arguments.length;
switch (G__68963) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69008){
var state_val_69009 = (state_69008[(1)]);
if((state_val_69009 === (7))){
var inst_68978 = typeof user === 'string';
var state_69008__$1 = state_69008;
if(cljs.core.truth_(inst_68978)){
var statearr_69010_69039 = state_69008__$1;
(statearr_69010_69039[(1)] = (9));

} else {
var statearr_69011_69040 = state_69008__$1;
(statearr_69011_69040[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69009 === (1))){
var state_69008__$1 = state_69008;
var statearr_69012_69041 = state_69008__$1;
(statearr_69012_69041[(2)] = null);

(statearr_69012_69041[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69009 === (4))){
var inst_68964 = (state_69008[(2)]);
var inst_68965 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68966 = [inst_68964];
var inst_68967 = (new cljs.core.PersistentVector(null,1,(5),inst_68965,inst_68966,null));
var inst_68968 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_68967);
var inst_68969 = reject.call(null,inst_68964);
var state_69008__$1 = (function (){var statearr_69013 = state_69008;
(statearr_69013[(7)] = inst_68968);

return statearr_69013;
})();
var statearr_69014_69042 = state_69008__$1;
(statearr_69014_69042[(2)] = inst_68969);

(statearr_69014_69042[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69009 === (15))){
var inst_68997 = (state_69008[(2)]);
var inst_68998 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_68997);
var inst_68999 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_69000 = cljs.core.constantly.call(null,inst_68998);
var inst_69001 = cljs.core.swap_BANG_.call(null,inst_68999,inst_69000);
var inst_69002 = fluree.db.connection.add_token.call(null,conn,inst_68998);
var inst_69003 = resolve.call(null,inst_68997);
var _ = (function (){var statearr_69015 = state_69008;
(statearr_69015[(4)] = cljs.core.rest.call(null,(state_69008[(4)])));

return statearr_69015;
})();
var state_69008__$1 = (function (){var statearr_69016 = state_69008;
(statearr_69016[(8)] = inst_69001);

(statearr_69016[(9)] = inst_69002);

return statearr_69016;
})();
var statearr_69017_69043 = state_69008__$1;
(statearr_69017_69043[(2)] = inst_69003);

(statearr_69017_69043[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69009 === (13))){
var state_69008__$1 = state_69008;
var statearr_69018_69044 = state_69008__$1;
(statearr_69018_69044[(2)] = null);

(statearr_69018_69044[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69009 === (6))){
var state_69008__$1 = state_69008;
var statearr_69019_69045 = state_69008__$1;
(statearr_69019_69045[(2)] = user);

(statearr_69019_69045[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69009 === (3))){
var inst_69006 = (state_69008[(2)]);
var state_69008__$1 = state_69008;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69008__$1,inst_69006);
} else {
if((state_val_69009 === (12))){
var state_69008__$1 = state_69008;
var statearr_69020_69046 = state_69008__$1;
(statearr_69020_69046[(2)] = user);

(statearr_69020_69046[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69009 === (2))){
var _ = (function (){var statearr_69021 = state_69008;
(statearr_69021[(4)] = cljs.core.cons.call(null,(5),(state_69008[(4)])));

return statearr_69021;
})();
var inst_68975 = typeof user === 'number';
var state_69008__$1 = state_69008;
if(cljs.core.truth_(inst_68975)){
var statearr_69022_69047 = state_69008__$1;
(statearr_69022_69047[(1)] = (6));

} else {
var statearr_69023_69048 = state_69008__$1;
(statearr_69023_69048[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69009 === (11))){
var inst_68989 = (state_69008[(2)]);
var state_69008__$1 = state_69008;
var statearr_69025_69049 = state_69008__$1;
(statearr_69025_69049[(2)] = inst_68989);

(statearr_69025_69049[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69009 === (9))){
var inst_68980 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68981 = ["_user/username",user];
var inst_68982 = (new cljs.core.PersistentVector(null,2,(5),inst_68980,inst_68981,null));
var state_69008__$1 = state_69008;
var statearr_69026_69050 = state_69008__$1;
(statearr_69026_69050[(2)] = inst_68982);

(statearr_69026_69050[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69009 === (5))){
var _ = (function (){var statearr_69027 = state_69008;
(statearr_69027[(4)] = cljs.core.rest.call(null,(state_69008[(4)])));

return statearr_69027;
})();
var state_69008__$1 = state_69008;
var ex69024 = (state_69008__$1[(2)]);
var statearr_69028_69051 = state_69008__$1;
(statearr_69028_69051[(5)] = ex69024);


var statearr_69029_69052 = state_69008__$1;
(statearr_69029_69052[(1)] = (4));

(statearr_69029_69052[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69009 === (14))){
var inst_68987 = (state_69008[(2)]);
var state_69008__$1 = state_69008;
var statearr_69030_69053 = state_69008__$1;
(statearr_69030_69053[(2)] = inst_68987);

(statearr_69030_69053[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69009 === (10))){
var state_69008__$1 = state_69008;
var statearr_69031_69054 = state_69008__$1;
(statearr_69031_69054[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69009 === (8))){
var inst_68991 = (state_69008[(2)]);
var inst_68992 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_68993 = [account,inst_68991,password,expireSeconds,syncTo];
var inst_68994 = cljs.core.PersistentHashMap.fromArrays(inst_68992,inst_68993);
var inst_68995 = fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_68994);
var state_69008__$1 = state_69008;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69008__$1,(15),inst_68995);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_69033 = [null,null,null,null,null,null,null,null,null,null];
(statearr_69033[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_69033[(1)] = (1));

return statearr_69033;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_69008){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69008);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69034){var ex__2749__auto__ = e69034;
var statearr_69035_69055 = state_69008;
(statearr_69035_69055[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69008[(4)]))){
var statearr_69036_69056 = state_69008;
(statearr_69036_69056[(1)] = cljs.core.first.call(null,(state_69008[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69057 = state_69008;
state_69008 = G__69057;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_69008){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_69008);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69037 = f__2769__auto__.call(null);
(statearr_69037[(6)] = c__2768__auto__);

return statearr_69037;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__69059 = arguments.length;
switch (G__69059) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,fluree.db.connection.connect.call(null,servers_string,opts),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.call(null);
var _ = (function (){var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69068){
var state_val_69069 = (state_69068[(1)]);
if((state_val_69069 === (1))){
var inst_69060 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_69061 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69062 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_69063 = (new cljs.core.PersistentVector(null,4,(5),inst_69061,inst_69062,null));
var inst_69064 = cljs.core.async.put_BANG_.call(null,inst_69060,inst_69063);
var inst_69065 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__69070 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__69071 = null;
var count__69072 = (0);
var i__69073 = (0);
while(true){
if((i__69073 < count__69072)){
var k = cljs.core._nth.call(null,chunk__69071,i__69073);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__69081 = seq__69070;
var G__69082 = chunk__69071;
var G__69083 = count__69072;
var G__69084 = (i__69073 + (1));
seq__69070 = G__69081;
chunk__69071 = G__69082;
count__69072 = G__69083;
i__69073 = G__69084;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__69070);
if(temp__5804__auto__){
var seq__69070__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__69070__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__69070__$1);
var G__69085 = cljs.core.chunk_rest.call(null,seq__69070__$1);
var G__69086 = c__5568__auto__;
var G__69087 = cljs.core.count.call(null,c__5568__auto__);
var G__69088 = (0);
seq__69070 = G__69085;
chunk__69071 = G__69086;
count__69072 = G__69087;
i__69073 = G__69088;
continue;
} else {
var k = cljs.core.first.call(null,seq__69070__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__69089 = cljs.core.next.call(null,seq__69070__$1);
var G__69090 = null;
var G__69091 = (0);
var G__69092 = (0);
seq__69070 = G__69089;
chunk__69071 = G__69090;
count__69072 = G__69091;
i__69073 = G__69092;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_69066 = cljs.core.async.take_BANG_.call(null,pc,inst_69065);
var state_69068__$1 = (function (){var statearr_69074 = state_69068;
(statearr_69074[(7)] = inst_69064);

return statearr_69074;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69068__$1,inst_69066);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_69075 = [null,null,null,null,null,null,null,null];
(statearr_69075[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_69075[(1)] = (1));

return statearr_69075;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_69068){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69068);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69076){var ex__2749__auto__ = e69076;
var statearr_69077_69093 = state_69068;
(statearr_69077_69093[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69068[(4)]))){
var statearr_69078_69094 = state_69068;
(statearr_69078_69094[(1)] = cljs.core.first.call(null,(state_69068[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69095 = state_69068;
state_69068 = G__69095;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_69068){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_69068);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69079 = f__2769__auto__.call(null);
(statearr_69079[(6)] = c__2768__auto__);

return statearr_69079;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__69097 = arguments.length;
switch (G__69097) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69134){
var state_val_69135 = (state_69134[(1)]);
if((state_val_69135 === (1))){
var state_69134__$1 = state_69134;
var statearr_69136_69157 = state_69134__$1;
(statearr_69136_69157[(2)] = null);

(statearr_69136_69157[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69135 === (2))){
var _ = (function (){var statearr_69137 = state_69134;
(statearr_69137[(4)] = cljs.core.cons.call(null,(5),(state_69134[(4)])));

return statearr_69137;
})();
var inst_69109 = fluree.db.connection.connect.call(null,servers_string,opts);
var inst_69110 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69111 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_69112 = (new cljs.core.PersistentVector(null,1,(5),inst_69110,inst_69111,null));
var inst_69113 = cljs.core.PersistentHashMap.EMPTY;
var inst_69114 = cljs.core.atom.call(null,inst_69113);
var inst_69115 = cljs.core.assoc_in.call(null,inst_69109,inst_69112,inst_69114);
var inst_69116 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69117 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_69118 = (new cljs.core.PersistentVector(null,1,(5),inst_69116,inst_69117,null));
var inst_69119 = cljs.core.PersistentHashMap.EMPTY;
var inst_69120 = cljs.core.atom.call(null,inst_69119);
var inst_69121 = cljs.core.assoc_in.call(null,inst_69115,inst_69118,inst_69120);
var inst_69122 = cljs.core.async.promise_chan.call(null);
var inst_69123 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_69121);
var inst_69124 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69125 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_69122,null];
var inst_69126 = (new cljs.core.PersistentVector(null,4,(5),inst_69124,inst_69125,null));
var inst_69127 = cljs.core.async.put_BANG_.call(null,inst_69123,inst_69126);
var inst_69128 = (function (){var conn = inst_69121;
var pc = inst_69122;
return (function (x){
if((x == null)){
} else {
var seq__69138_69158 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__69139_69159 = null;
var count__69140_69160 = (0);
var i__69141_69161 = (0);
while(true){
if((i__69141_69161 < count__69140_69160)){
var k_69162 = cljs.core._nth.call(null,chunk__69139_69159,i__69141_69161);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_69162], null),cljs.core.get.call(null,x,k_69162,null));


var G__69163 = seq__69138_69158;
var G__69164 = chunk__69139_69159;
var G__69165 = count__69140_69160;
var G__69166 = (i__69141_69161 + (1));
seq__69138_69158 = G__69163;
chunk__69139_69159 = G__69164;
count__69140_69160 = G__69165;
i__69141_69161 = G__69166;
continue;
} else {
var temp__5804__auto___69167 = cljs.core.seq.call(null,seq__69138_69158);
if(temp__5804__auto___69167){
var seq__69138_69168__$1 = temp__5804__auto___69167;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__69138_69168__$1)){
var c__5568__auto___69169 = cljs.core.chunk_first.call(null,seq__69138_69168__$1);
var G__69170 = cljs.core.chunk_rest.call(null,seq__69138_69168__$1);
var G__69171 = c__5568__auto___69169;
var G__69172 = cljs.core.count.call(null,c__5568__auto___69169);
var G__69173 = (0);
seq__69138_69158 = G__69170;
chunk__69139_69159 = G__69171;
count__69140_69160 = G__69172;
i__69141_69161 = G__69173;
continue;
} else {
var k_69174 = cljs.core.first.call(null,seq__69138_69168__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_69174], null),cljs.core.get.call(null,x,k_69174,null));


var G__69175 = cljs.core.next.call(null,seq__69138_69168__$1);
var G__69176 = null;
var G__69177 = (0);
var G__69178 = (0);
seq__69138_69158 = G__69175;
chunk__69139_69159 = G__69176;
count__69140_69160 = G__69177;
i__69141_69161 = G__69178;
continue;
}
} else {
}
}
break;
}
}

return resolve.call(null,conn);
});
})();
var inst_69129 = cljs.core.async.take_BANG_.call(null,inst_69122,inst_69128);
var ___$1 = (function (){var statearr_69142 = state_69134;
(statearr_69142[(4)] = cljs.core.rest.call(null,(state_69134[(4)])));

return statearr_69142;
})();
var state_69134__$1 = (function (){var statearr_69143 = state_69134;
(statearr_69143[(7)] = inst_69127);

return statearr_69143;
})();
var statearr_69144_69179 = state_69134__$1;
(statearr_69144_69179[(2)] = inst_69129);

(statearr_69144_69179[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69135 === (3))){
var inst_69132 = (state_69134[(2)]);
var state_69134__$1 = state_69134;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69134__$1,inst_69132);
} else {
if((state_val_69135 === (4))){
var inst_69098 = (state_69134[(2)]);
var inst_69099 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69100 = [inst_69098];
var inst_69101 = (new cljs.core.PersistentVector(null,1,(5),inst_69099,inst_69100,null));
var inst_69102 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_69101);
var inst_69103 = reject.call(null,inst_69098);
var state_69134__$1 = (function (){var statearr_69146 = state_69134;
(statearr_69146[(8)] = inst_69102);

return statearr_69146;
})();
var statearr_69147_69180 = state_69134__$1;
(statearr_69147_69180[(2)] = inst_69103);

(statearr_69147_69180[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69135 === (5))){
var _ = (function (){var statearr_69148 = state_69134;
(statearr_69148[(4)] = cljs.core.rest.call(null,(state_69134[(4)])));

return statearr_69148;
})();
var state_69134__$1 = state_69134;
var ex69145 = (state_69134__$1[(2)]);
var statearr_69149_69181 = state_69134__$1;
(statearr_69149_69181[(5)] = ex69145);


var statearr_69150_69182 = state_69134__$1;
(statearr_69150_69182[(1)] = (4));

(statearr_69150_69182[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_69151 = [null,null,null,null,null,null,null,null,null];
(statearr_69151[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_69151[(1)] = (1));

return statearr_69151;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_69134){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69134);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69152){var ex__2749__auto__ = e69152;
var statearr_69153_69183 = state_69134;
(statearr_69153_69183[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69134[(4)]))){
var statearr_69154_69184 = state_69134;
(statearr_69154_69184[(1)] = cljs.core.first.call(null,(state_69134[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69185 = state_69134;
state_69134 = G__69185;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_69134){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_69134);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69155 = f__2769__auto__.call(null);
(statearr_69155[(6)] = c__2768__auto__);

return statearr_69155;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_.call(null,conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__69187 = arguments.length;
switch (G__69187) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.call(null,conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not.call(null,open_api_QMARK_)) && (cljs.core.not.call(null,has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.call(null,"To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token.call(null,conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__69189 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__69189,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__69189,(1),null);
var cb_STAR_ = (function (header,data){
return callback.call(null,cljs.core.clj__GT_js.call(null,header),cljs.core.clj__GT_js.call(null,data));
});
return fluree.db.connection.add_listener.call(null,conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__69192 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__69192,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__69192,(1),null);
return fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js.call(null,fluree.db.connection.listeners.call(null,conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69245){
var state_val_69246 = (state_69245[(1)]);
if((state_val_69246 === (7))){
var inst_69206 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69207 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_69208 = cljs.core.PersistentHashMap.fromArrays(inst_69206,inst_69207);
var inst_69209 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_69208);
var inst_69210 = (function(){throw inst_69209})();
var state_69245__$1 = state_69245;
var statearr_69247_69276 = state_69245__$1;
(statearr_69247_69276[(2)] = inst_69210);

(statearr_69247_69276[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69246 === (1))){
var state_69245__$1 = state_69245;
var statearr_69248_69277 = state_69245__$1;
(statearr_69248_69277[(2)] = null);

(statearr_69248_69277[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69246 === (4))){
var inst_69195 = (state_69245[(2)]);
var inst_69196 = cljs.core.clj__GT_js.call(null,inst_69195);
var inst_69197 = reject.call(null,inst_69196);
var state_69245__$1 = state_69245;
var statearr_69249_69278 = state_69245__$1;
(statearr_69249_69278[(2)] = inst_69197);

(statearr_69249_69278[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69246 === (13))){
var inst_69224 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69225 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_69226 = cljs.core.PersistentHashMap.fromArrays(inst_69224,inst_69225);
var inst_69227 = cljs.core.ex_info.call(null,"A password must be supplied.",inst_69226);
var inst_69228 = (function(){throw inst_69227})();
var state_69245__$1 = state_69245;
var statearr_69250_69279 = state_69245__$1;
(statearr_69250_69279[(2)] = inst_69228);

(statearr_69250_69279[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69246 === (6))){
var state_69245__$1 = state_69245;
var statearr_69251_69280 = state_69245__$1;
(statearr_69251_69280[(2)] = null);

(statearr_69251_69280[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69246 === (3))){
var inst_69243 = (state_69245[(2)]);
var state_69245__$1 = state_69245;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69245__$1,inst_69243);
} else {
if((state_val_69246 === (12))){
var state_69245__$1 = state_69245;
var statearr_69252_69281 = state_69245__$1;
(statearr_69252_69281[(2)] = null);

(statearr_69252_69281[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69246 === (2))){
var _ = (function (){var statearr_69253 = state_69245;
(statearr_69253[(4)] = cljs.core.cons.call(null,(5),(state_69245[(4)])));

return statearr_69253;
})();
var inst_69203 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_69245__$1 = state_69245;
if(cljs.core.truth_(inst_69203)){
var statearr_69254_69282 = state_69245__$1;
(statearr_69254_69282[(1)] = (6));

} else {
var statearr_69255_69283 = state_69245__$1;
(statearr_69255_69283[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69246 === (11))){
var inst_69221 = (state_69245[(2)]);
var state_69245__$1 = (function (){var statearr_69257 = state_69245;
(statearr_69257[(7)] = inst_69221);

return statearr_69257;
})();
if(cljs.core.truth_(password)){
var statearr_69258_69284 = state_69245__$1;
(statearr_69258_69284[(1)] = (12));

} else {
var statearr_69259_69285 = state_69245__$1;
(statearr_69259_69285[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69246 === (9))){
var state_69245__$1 = state_69245;
var statearr_69260_69286 = state_69245__$1;
(statearr_69260_69286[(2)] = null);

(statearr_69260_69286[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69246 === (5))){
var _ = (function (){var statearr_69261 = state_69245;
(statearr_69261[(4)] = cljs.core.rest.call(null,(state_69245[(4)])));

return statearr_69261;
})();
var state_69245__$1 = state_69245;
var ex69256 = (state_69245__$1[(2)]);
var statearr_69262_69287 = state_69245__$1;
(statearr_69262_69287[(5)] = ex69256);


var statearr_69263_69288 = state_69245__$1;
(statearr_69263_69288[(1)] = (4));

(statearr_69263_69288[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69246 === (14))){
var inst_69230 = (state_69245[(2)]);
var inst_69231 = cljs.core.assoc.call(null,map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,new cljs.core.Keyword(null,"password","password",417022471),password);
var inst_69232 = fluree.db.util.core.without_nils.call(null,inst_69231);
var inst_69233 = cljs.core.async.promise_chan.call(null);
var inst_69234 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_69235 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69236 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_69232,inst_69233,null];
var inst_69237 = (new cljs.core.PersistentVector(null,4,(5),inst_69235,inst_69236,null));
var inst_69238 = cljs.core.async.put_BANG_.call(null,inst_69234,inst_69237);
var inst_69239 = (function (){var _ = inst_69230;
var data = inst_69232;
var pc = inst_69233;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_69240 = cljs.core.async.take_BANG_.call(null,inst_69233,inst_69239);
var _ = (function (){var statearr_69264 = state_69245;
(statearr_69264[(4)] = cljs.core.rest.call(null,(state_69245[(4)])));

return statearr_69264;
})();
var state_69245__$1 = (function (){var statearr_69265 = state_69245;
(statearr_69265[(8)] = inst_69238);

return statearr_69265;
})();
var statearr_69266_69289 = state_69245__$1;
(statearr_69266_69289[(2)] = inst_69240);

(statearr_69266_69289[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69246 === (10))){
var inst_69215 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69216 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_69217 = cljs.core.PersistentHashMap.fromArrays(inst_69215,inst_69216);
var inst_69218 = cljs.core.ex_info.call(null,"A ledger must be supplied.",inst_69217);
var inst_69219 = (function(){throw inst_69218})();
var state_69245__$1 = state_69245;
var statearr_69267_69290 = state_69245__$1;
(statearr_69267_69290[(2)] = inst_69219);

(statearr_69267_69290[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69246 === (8))){
var inst_69212 = (state_69245[(2)]);
var state_69245__$1 = (function (){var statearr_69268 = state_69245;
(statearr_69268[(9)] = inst_69212);

return statearr_69268;
})();
if(cljs.core.truth_(ledger)){
var statearr_69269_69291 = state_69245__$1;
(statearr_69269_69291[(1)] = (9));

} else {
var statearr_69270_69292 = state_69245__$1;
(statearr_69270_69292[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2746__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2746__auto____0 = (function (){
var statearr_69271 = [null,null,null,null,null,null,null,null,null,null];
(statearr_69271[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2746__auto__);

(statearr_69271[(1)] = (1));

return statearr_69271;
});
var fluree$db$connection_js$password_generate_$_state_machine__2746__auto____1 = (function (state_69245){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69245);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69272){var ex__2749__auto__ = e69272;
var statearr_69273_69293 = state_69245;
(statearr_69273_69293[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69245[(4)]))){
var statearr_69274_69294 = state_69245;
(statearr_69274_69294[(1)] = cljs.core.first.call(null,(state_69245[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69295 = state_69245;
state_69245 = G__69295;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2746__auto__ = function(state_69245){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2746__auto____1.call(this,state_69245);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2746__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2746__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69275 = f__2769__auto__.call(null);
(statearr_69275[(6)] = c__2768__auto__);

return statearr_69275;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__69297 = arguments.length;
switch (G__69297) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69364){
var state_val_69365 = (state_69364[(1)]);
if((state_val_69365 === (7))){
var inst_69309 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69310 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_69311 = cljs.core.PersistentHashMap.fromArrays(inst_69309,inst_69310);
var inst_69312 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_69311);
var inst_69313 = (function(){throw inst_69312})();
var state_69364__$1 = state_69364;
var statearr_69366_69405 = state_69364__$1;
(statearr_69366_69405[(2)] = inst_69313);

(statearr_69366_69405[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69365 === (20))){
var inst_69347 = (state_69364[(2)]);
var inst_69348 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_69349 = [ledger,password,user,auth,expire];
var inst_69350 = cljs.core.PersistentHashMap.fromArrays(inst_69348,inst_69349);
var inst_69351 = fluree.db.util.core.without_nils.call(null,inst_69350);
var inst_69352 = cljs.core.async.promise_chan.call(null);
var inst_69353 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_69354 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69355 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_69351,inst_69352,null];
var inst_69356 = (new cljs.core.PersistentVector(null,4,(5),inst_69354,inst_69355,null));
var inst_69357 = cljs.core.async.put_BANG_.call(null,inst_69353,inst_69356);
var inst_69358 = (function (){var _ = inst_69347;
var data = inst_69351;
var pc = inst_69352;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_69359 = cljs.core.async.take_BANG_.call(null,inst_69352,inst_69358);
var _ = (function (){var statearr_69367 = state_69364;
(statearr_69367[(4)] = cljs.core.rest.call(null,(state_69364[(4)])));

return statearr_69367;
})();
var state_69364__$1 = (function (){var statearr_69368 = state_69364;
(statearr_69368[(7)] = inst_69357);

return statearr_69368;
})();
var statearr_69369_69406 = state_69364__$1;
(statearr_69369_69406[(2)] = inst_69359);

(statearr_69369_69406[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69365 === (1))){
var state_69364__$1 = state_69364;
var statearr_69370_69407 = state_69364__$1;
(statearr_69370_69407[(2)] = null);

(statearr_69370_69407[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69365 === (4))){
var inst_69298 = (state_69364[(2)]);
var inst_69299 = cljs.core.clj__GT_js.call(null,inst_69298);
var inst_69300 = reject.call(null,inst_69299);
var state_69364__$1 = state_69364;
var statearr_69371_69408 = state_69364__$1;
(statearr_69371_69408[(2)] = inst_69300);

(statearr_69371_69408[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69365 === (15))){
var inst_69334 = (state_69364[(8)]);
var state_69364__$1 = state_69364;
var statearr_69372_69409 = state_69364__$1;
(statearr_69372_69409[(2)] = inst_69334);

(statearr_69372_69409[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69365 === (13))){
var inst_69327 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69328 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_69329 = cljs.core.PersistentHashMap.fromArrays(inst_69327,inst_69328);
var inst_69330 = cljs.core.ex_info.call(null,"A password must be supplied in the provided JSON.",inst_69329);
var inst_69331 = (function(){throw inst_69330})();
var state_69364__$1 = state_69364;
var statearr_69373_69410 = state_69364__$1;
(statearr_69373_69410[(2)] = inst_69331);

(statearr_69373_69410[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69365 === (6))){
var state_69364__$1 = state_69364;
var statearr_69374_69411 = state_69364__$1;
(statearr_69374_69411[(2)] = null);

(statearr_69374_69411[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69365 === (17))){
var inst_69338 = (state_69364[(2)]);
var state_69364__$1 = state_69364;
if(cljs.core.truth_(inst_69338)){
var statearr_69375_69412 = state_69364__$1;
(statearr_69375_69412[(1)] = (18));

} else {
var statearr_69376_69413 = state_69364__$1;
(statearr_69376_69413[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69365 === (3))){
var inst_69362 = (state_69364[(2)]);
var state_69364__$1 = state_69364;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69364__$1,inst_69362);
} else {
if((state_val_69365 === (12))){
var state_69364__$1 = state_69364;
var statearr_69377_69414 = state_69364__$1;
(statearr_69377_69414[(2)] = null);

(statearr_69377_69414[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69365 === (2))){
var _ = (function (){var statearr_69378 = state_69364;
(statearr_69378[(4)] = cljs.core.cons.call(null,(5),(state_69364[(4)])));

return statearr_69378;
})();
var inst_69306 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_69364__$1 = state_69364;
if(cljs.core.truth_(inst_69306)){
var statearr_69379_69415 = state_69364__$1;
(statearr_69379_69415[(1)] = (6));

} else {
var statearr_69380_69416 = state_69364__$1;
(statearr_69380_69416[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69365 === (19))){
var inst_69341 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69342 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_69343 = cljs.core.PersistentHashMap.fromArrays(inst_69341,inst_69342);
var inst_69344 = cljs.core.ex_info.call(null,"A user identity or auth identity must be supplied.",inst_69343);
var inst_69345 = (function(){throw inst_69344})();
var state_69364__$1 = state_69364;
var statearr_69381_69417 = state_69364__$1;
(statearr_69381_69417[(2)] = inst_69345);

(statearr_69381_69417[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69365 === (11))){
var inst_69324 = (state_69364[(2)]);
var state_69364__$1 = (function (){var statearr_69383 = state_69364;
(statearr_69383[(9)] = inst_69324);

return statearr_69383;
})();
if(cljs.core.truth_(password)){
var statearr_69384_69418 = state_69364__$1;
(statearr_69384_69418[(1)] = (12));

} else {
var statearr_69385_69419 = state_69364__$1;
(statearr_69385_69419[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69365 === (9))){
var state_69364__$1 = state_69364;
var statearr_69386_69420 = state_69364__$1;
(statearr_69386_69420[(2)] = null);

(statearr_69386_69420[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69365 === (5))){
var _ = (function (){var statearr_69387 = state_69364;
(statearr_69387[(4)] = cljs.core.rest.call(null,(state_69364[(4)])));

return statearr_69387;
})();
var state_69364__$1 = state_69364;
var ex69382 = (state_69364__$1[(2)]);
var statearr_69388_69421 = state_69364__$1;
(statearr_69388_69421[(5)] = ex69382);


var statearr_69389_69422 = state_69364__$1;
(statearr_69389_69422[(1)] = (4));

(statearr_69389_69422[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69365 === (14))){
var inst_69334 = (state_69364[(8)]);
var inst_69333 = (state_69364[(2)]);
var inst_69334__$1 = user;
var state_69364__$1 = (function (){var statearr_69390 = state_69364;
(statearr_69390[(10)] = inst_69333);

(statearr_69390[(8)] = inst_69334__$1);

return statearr_69390;
})();
if(cljs.core.truth_(inst_69334__$1)){
var statearr_69391_69423 = state_69364__$1;
(statearr_69391_69423[(1)] = (15));

} else {
var statearr_69392_69424 = state_69364__$1;
(statearr_69392_69424[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69365 === (16))){
var state_69364__$1 = state_69364;
var statearr_69393_69425 = state_69364__$1;
(statearr_69393_69425[(2)] = auth);

(statearr_69393_69425[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69365 === (10))){
var inst_69318 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69319 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_69320 = cljs.core.PersistentHashMap.fromArrays(inst_69318,inst_69319);
var inst_69321 = cljs.core.ex_info.call(null,"A ledger must be supplied in the provided JSON.",inst_69320);
var inst_69322 = (function(){throw inst_69321})();
var state_69364__$1 = state_69364;
var statearr_69394_69426 = state_69364__$1;
(statearr_69394_69426[(2)] = inst_69322);

(statearr_69394_69426[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69365 === (18))){
var state_69364__$1 = state_69364;
var statearr_69395_69427 = state_69364__$1;
(statearr_69395_69427[(2)] = null);

(statearr_69395_69427[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69365 === (8))){
var inst_69315 = (state_69364[(2)]);
var state_69364__$1 = (function (){var statearr_69396 = state_69364;
(statearr_69396[(11)] = inst_69315);

return statearr_69396;
})();
if(cljs.core.truth_(ledger)){
var statearr_69397_69428 = state_69364__$1;
(statearr_69397_69428[(1)] = (9));

} else {
var statearr_69398_69429 = state_69364__$1;
(statearr_69398_69429[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_69399 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69399[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_69399[(1)] = (1));

return statearr_69399;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_69364){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69364);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69400){var ex__2749__auto__ = e69400;
var statearr_69401_69430 = state_69364;
(statearr_69401_69430[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69364[(4)]))){
var statearr_69402_69431 = state_69364;
(statearr_69402_69431[(1)] = cljs.core.first.call(null,(state_69364[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69432 = state_69364;
state_69364 = G__69432;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_69364){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_69364);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69403 = f__2769__auto__.call(null);
(statearr_69403[(6)] = c__2768__auto__);

return statearr_69403;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__69434 = arguments.length;
switch (G__69434) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69469){
var state_val_69470 = (state_69469[(1)]);
if((state_val_69470 === (1))){
var state_69469__$1 = state_69469;
var statearr_69471_69491 = state_69469__$1;
(statearr_69471_69491[(2)] = null);

(statearr_69471_69491[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69470 === (2))){
var _ = (function (){var statearr_69472 = state_69469;
(statearr_69472[(4)] = cljs.core.cons.call(null,(5),(state_69469[(4)])));

return statearr_69472;
})();
var inst_69443 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_69469__$1 = state_69469;
if(cljs.core.truth_(inst_69443)){
var statearr_69473_69492 = state_69469__$1;
(statearr_69473_69492[(1)] = (6));

} else {
var statearr_69474_69493 = state_69469__$1;
(statearr_69474_69493[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69470 === (3))){
var inst_69467 = (state_69469[(2)]);
var state_69469__$1 = state_69469;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69469__$1,inst_69467);
} else {
if((state_val_69470 === (4))){
var inst_69435 = (state_69469[(2)]);
var inst_69436 = cljs.core.clj__GT_js.call(null,inst_69435);
var inst_69437 = reject.call(null,inst_69436);
var state_69469__$1 = state_69469;
var statearr_69476_69494 = state_69469__$1;
(statearr_69476_69494[(2)] = inst_69437);

(statearr_69476_69494[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69470 === (5))){
var _ = (function (){var statearr_69477 = state_69469;
(statearr_69477[(4)] = cljs.core.rest.call(null,(state_69469[(4)])));

return statearr_69477;
})();
var state_69469__$1 = state_69469;
var ex69475 = (state_69469__$1[(2)]);
var statearr_69478_69495 = state_69469__$1;
(statearr_69478_69495[(5)] = ex69475);


var statearr_69479_69496 = state_69469__$1;
(statearr_69479_69496[(1)] = (4));

(statearr_69479_69496[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69470 === (6))){
var state_69469__$1 = state_69469;
var statearr_69480_69497 = state_69469__$1;
(statearr_69480_69497[(2)] = null);

(statearr_69480_69497[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69470 === (7))){
var inst_69446 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69447 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_69448 = cljs.core.PersistentHashMap.fromArrays(inst_69446,inst_69447);
var inst_69449 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_69448);
var inst_69450 = (function(){throw inst_69449})();
var state_69469__$1 = state_69469;
var statearr_69481_69498 = state_69469__$1;
(statearr_69481_69498[(2)] = inst_69450);

(statearr_69481_69498[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69470 === (8))){
var inst_69452 = (state_69469[(2)]);
var inst_69453 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_69454 = [jwt,expire];
var inst_69455 = cljs.core.PersistentHashMap.fromArrays(inst_69453,inst_69454);
var inst_69456 = fluree.db.util.core.without_nils.call(null,inst_69455);
var inst_69457 = cljs.core.async.promise_chan.call(null);
var inst_69458 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_69459 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69460 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_69456,inst_69457,null];
var inst_69461 = (new cljs.core.PersistentVector(null,4,(5),inst_69459,inst_69460,null));
var inst_69462 = cljs.core.async.put_BANG_.call(null,inst_69458,inst_69461);
var inst_69463 = (function (){var _ = inst_69452;
var data = inst_69456;
var pc = inst_69457;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
});
})();
var inst_69464 = cljs.core.async.take_BANG_.call(null,inst_69457,inst_69463);
var _ = (function (){var statearr_69482 = state_69469;
(statearr_69482[(4)] = cljs.core.rest.call(null,(state_69469[(4)])));

return statearr_69482;
})();
var state_69469__$1 = (function (){var statearr_69483 = state_69469;
(statearr_69483[(7)] = inst_69462);

return statearr_69483;
})();
var statearr_69484_69499 = state_69469__$1;
(statearr_69484_69499[(2)] = inst_69464);

(statearr_69484_69499[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_69485 = [null,null,null,null,null,null,null,null];
(statearr_69485[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_69485[(1)] = (1));

return statearr_69485;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_69469){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69469);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69486){var ex__2749__auto__ = e69486;
var statearr_69487_69500 = state_69469;
(statearr_69487_69500[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69469[(4)]))){
var statearr_69488_69501 = state_69469;
(statearr_69488_69501[(1)] = cljs.core.first.call(null,(state_69469[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69502 = state_69469;
state_69469 = G__69502;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_69469){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_69469);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69489 = f__2769__auto__.call(null);
(statearr_69489[(6)] = c__2768__auto__);

return statearr_69489;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

