// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.call(null,["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-ledger-id] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__25751 = cljs.core.re_find.call(null,/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str.call(null,ledger));
var _ = cljs.core.nth.call(null,vec__25751,(0),null);
var network = cljs.core.nth.call(null,vec__25751,(1),null);
var maybe_alias = cljs.core.nth.call(null,vec__25751,(2),null);
if(cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return maybe_alias;
} else {
return and__5043__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
/**
 * Predicates to exclude from the database
 */
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(130),(106)]);
fluree.db.graphdb.exclude_flake_QMARK_ = (function fluree$db$graphdb$exclude_flake_QMARK_(f){
return cljs.core.contains_QMARK_.call(null,fluree.db.graphdb.exclude_predicates,fluree.db.flake.p.call(null,f));
});
fluree.db.graphdb.include_flake_QMARK_ = cljs.core.complement.call(null,fluree.db.graphdb.exclude_flake_QMARK_);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__25754){
var map__25755 = p__25754;
var map__25755__$1 = cljs.core.__destructure_map.call(null,map__25755);
var opts = map__25755__$1;
var reindex_QMARK_ = cljs.core.get.call(null,map__25755__$1,new cljs.core.Keyword(null,"reindex?","reindex?",683464852));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25815){
var state_val_25816 = (state_25815[(1)]);
if((state_val_25816 === (7))){
var inst_25786 = cljs.core.not.call(null,reindex_QMARK_);
var state_25815__$1 = state_25815;
var statearr_25817_25841 = state_25815__$1;
(statearr_25817_25841[(2)] = inst_25786);

(statearr_25817_25841[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (1))){
var state_25815__$1 = state_25815;
var statearr_25818_25842 = state_25815__$1;
(statearr_25818_25842[(2)] = null);

(statearr_25818_25842[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (4))){
var inst_25756 = (state_25815[(2)]);
var state_25815__$1 = state_25815;
var statearr_25819_25843 = state_25815__$1;
(statearr_25819_25843[(2)] = inst_25756);

(statearr_25819_25843[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (6))){
var inst_25770 = (state_25815[(7)]);
var inst_25784 = (state_25815[(8)]);
var inst_25776 = (state_25815[(9)]);
var inst_25769 = (state_25815[(2)]);
var inst_25770__$1 = fluree.db.util.async.throw_err.call(null,inst_25769);
var inst_25771 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_25772 = cljs.core.__destructure_map.call(null,inst_25771);
var inst_25773 = cljs.core.get.call(null,inst_25772,new cljs.core.Keyword(null,"post","post",269697687));
var inst_25774 = cljs.core.get.call(null,inst_25772,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_25775 = fluree.db.flake.size_bytes.call(null,inst_25770__$1);
var inst_25776__$1 = (inst_25774 + inst_25775);
var inst_25777 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25778 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_25779 = (new cljs.core.PersistentVector(null,2,(5),inst_25777,inst_25778,null));
var inst_25780 = cljs.core.get_in.call(null,db,inst_25779);
var inst_25781 = cljs.core.__destructure_map.call(null,inst_25780);
var inst_25782 = cljs.core.get.call(null,inst_25781,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_25783 = cljs.core.get.call(null,inst_25781,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_25784__$1 = (inst_25776__$1 > inst_25783);
var state_25815__$1 = (function (){var statearr_25820 = state_25815;
(statearr_25820[(7)] = inst_25770__$1);

(statearr_25820[(8)] = inst_25784__$1);

(statearr_25820[(10)] = inst_25773);

(statearr_25820[(9)] = inst_25776__$1);

(statearr_25820[(11)] = inst_25782);

return statearr_25820;
})();
if(cljs.core.truth_(inst_25784__$1)){
var statearr_25821_25844 = state_25815__$1;
(statearr_25821_25844[(1)] = (7));

} else {
var statearr_25822_25845 = state_25815__$1;
(statearr_25822_25845[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (3))){
var inst_25813 = (state_25815[(2)]);
var state_25815__$1 = state_25815;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25815__$1,inst_25813);
} else {
if((state_val_25816 === (12))){
var inst_25770 = (state_25815[(7)]);
var inst_25773 = (state_25815[(10)]);
var inst_25776 = (state_25815[(9)]);
var inst_25799 = (state_25815[(2)]);
var inst_25800 = cljs.core.into.call(null,inst_25773,inst_25770);
var inst_25801 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_25802 = cljs.core.swap_BANG_.call(null,inst_25801,cljs.core.empty);
var inst_25803 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25804 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_25805 = (new cljs.core.PersistentVector(null,2,(5),inst_25803,inst_25804,null));
var inst_25806 = cljs.core.assoc_in.call(null,db,inst_25805,inst_25800);
var inst_25807 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25808 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25809 = (new cljs.core.PersistentVector(null,2,(5),inst_25807,inst_25808,null));
var inst_25810 = cljs.core.assoc_in.call(null,inst_25806,inst_25809,inst_25776);
var _ = (function (){var statearr_25823 = state_25815;
(statearr_25823[(4)] = cljs.core.rest.call(null,(state_25815[(4)])));

return statearr_25823;
})();
var state_25815__$1 = (function (){var statearr_25824 = state_25815;
(statearr_25824[(12)] = inst_25802);

(statearr_25824[(13)] = inst_25799);

return statearr_25824;
})();
var statearr_25825_25846 = state_25815__$1;
(statearr_25825_25846[(2)] = inst_25810);

(statearr_25825_25846[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (2))){
var _ = (function (){var statearr_25826 = state_25815;
(statearr_25826[(4)] = cljs.core.cons.call(null,(5),(state_25815[(4)])));

return statearr_25826;
})();
var inst_25764 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25765 = [pred_id];
var inst_25766 = (new cljs.core.PersistentVector(null,1,(5),inst_25764,inst_25765,null));
var inst_25767 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_25766);
var state_25815__$1 = state_25815;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25815__$1,(6),inst_25767);
} else {
if((state_val_25816 === (11))){
var state_25815__$1 = state_25815;
var statearr_25828_25847 = state_25815__$1;
(statearr_25828_25847[(2)] = null);

(statearr_25828_25847[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (9))){
var inst_25789 = (state_25815[(2)]);
var state_25815__$1 = state_25815;
if(cljs.core.truth_(inst_25789)){
var statearr_25829_25848 = state_25815__$1;
(statearr_25829_25848[(1)] = (10));

} else {
var statearr_25830_25849 = state_25815__$1;
(statearr_25830_25849[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (5))){
var _ = (function (){var statearr_25831 = state_25815;
(statearr_25831[(4)] = cljs.core.rest.call(null,(state_25815[(4)])));

return statearr_25831;
})();
var state_25815__$1 = state_25815;
var ex25827 = (state_25815__$1[(2)]);
var statearr_25832_25850 = state_25815__$1;
(statearr_25832_25850[(5)] = ex25827);


if((ex25827 instanceof Error)){
var statearr_25833_25851 = state_25815__$1;
(statearr_25833_25851[(1)] = (4));

(statearr_25833_25851[(5)] = null);

} else {
throw ex25827;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (10))){
var inst_25791 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_25792 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_25793 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_25794 = cljs.core.PersistentHashMap.fromArrays(inst_25792,inst_25793);
var inst_25795 = cljs.core.ex_info.call(null,inst_25791,inst_25794);
var inst_25796 = (function(){throw inst_25795})();
var state_25815__$1 = state_25815;
var statearr_25834_25852 = state_25815__$1;
(statearr_25834_25852[(2)] = inst_25796);

(statearr_25834_25852[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25816 === (8))){
var inst_25784 = (state_25815[(8)]);
var state_25815__$1 = state_25815;
var statearr_25835_25853 = state_25815__$1;
(statearr_25835_25853[(2)] = inst_25784);

(statearr_25835_25853[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____0 = (function (){
var statearr_25836 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25836[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__);

(statearr_25836[(1)] = (1));

return statearr_25836;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____1 = (function (state_25815){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25815);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25837){var ex__2749__auto__ = e25837;
var statearr_25838_25854 = state_25815;
(statearr_25838_25854[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25815[(4)]))){
var statearr_25839_25855 = state_25815;
(statearr_25839_25855[(1)] = cljs.core.first.call(null,(state_25815[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25856 = state_25815;
state_25815 = G__25856;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__ = function(state_25815){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____1.call(this,state_25815);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25840 = f__2769__auto__.call(null);
(statearr_25840[(6)] = c__2768__auto__);

return statearr_25840;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__25859 = arguments.length;
switch (G__25859) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.call(null,db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26059){
var state_val_26060 = (state_26059[(1)]);
if((state_val_26060 === (7))){
var state_26059__$1 = state_26059;
var statearr_26061_26128 = state_26059__$1;
(statearr_26061_26128[(2)] = null);

(statearr_26061_26128[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (20))){
var inst_25982 = (state_26059[(7)]);
var inst_25946 = (state_26059[(8)]);
var inst_25983 = (state_26059[(9)]);
var inst_25984 = (state_26059[(10)]);
var inst_25980 = (state_26059[(11)]);
var inst_25979 = (state_26059[(12)]);
var inst_25896 = (state_26059[(13)]);
var inst_25981 = (state_26059[(14)]);
var inst_25895 = (state_26059[(15)]);
var inst_25994 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25995 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25996 = (new cljs.core.PersistentVector(null,2,(5),inst_25994,inst_25995,null));
var inst_25997 = cljs.core.get_in.call(null,inst_25946,inst_25996);
var inst_25998 = (inst_25997 + inst_25895);
var inst_25999 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26000 = [inst_25979,inst_25980,inst_25981,inst_25982,inst_25983,inst_25998];
var inst_26001 = cljs.core.PersistentHashMap.fromArrays(inst_25999,inst_26000);
var inst_26002 = cljs.core.assoc.call(null,inst_25946,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_25984,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_26001);
var state_26059__$1 = (function (){var statearr_26062 = state_26059;
(statearr_26062[(16)] = inst_26002);

return statearr_26062;
})();
if(cljs.core.truth_(inst_25896)){
var statearr_26063_26129 = state_26059__$1;
(statearr_26063_26129[(1)] = (23));

} else {
var statearr_26064_26130 = state_26059__$1;
(statearr_26064_26130[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (27))){
var inst_26002 = (state_26059[(16)]);
var state_26059__$1 = state_26059;
var statearr_26065_26131 = state_26059__$1;
(statearr_26065_26131[(2)] = inst_26002);

(statearr_26065_26131[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (1))){
var state_26059__$1 = state_26059;
var statearr_26066_26132 = state_26059__$1;
(statearr_26066_26132[(2)] = null);

(statearr_26066_26132[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (24))){
var inst_26002 = (state_26059[(16)]);
var inst_26006 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_26002);
var inst_26007 = (inst_26006 == null);
var state_26059__$1 = state_26059;
var statearr_26067_26133 = state_26059__$1;
(statearr_26067_26133[(2)] = inst_26007);

(statearr_26067_26133[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (39))){
var inst_25983 = (state_26059[(9)]);
var inst_25991 = (state_26059[(17)]);
var inst_25990 = (state_26059[(18)]);
var inst_26041 = (state_26059[(19)]);
var inst_26032 = (state_26059[(20)]);
var inst_26034 = (state_26059[(21)]);
var inst_26033 = (state_26059[(22)]);
var inst_26048 = (state_26059[(2)]);
var inst_26049 = cljs.core.conj.call(null,inst_25983,inst_25990);
var inst_25978 = inst_25991;
var inst_25979 = inst_26033;
var inst_25980 = inst_26034;
var inst_25981 = inst_26041;
var inst_25982 = inst_26048;
var inst_25983__$1 = inst_26049;
var inst_25984 = inst_26032;
var state_26059__$1 = (function (){var statearr_26068 = state_26059;
(statearr_26068[(7)] = inst_25982);

(statearr_26068[(9)] = inst_25983__$1);

(statearr_26068[(10)] = inst_25984);

(statearr_26068[(23)] = inst_25978);

(statearr_26068[(11)] = inst_25980);

(statearr_26068[(12)] = inst_25979);

(statearr_26068[(14)] = inst_25981);

return statearr_26068;
})();
var statearr_26069_26134 = state_26059__$1;
(statearr_26069_26134[(2)] = null);

(statearr_26069_26134[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (4))){
var inst_25860 = (state_26059[(2)]);
var state_26059__$1 = state_26059;
var statearr_26070_26135 = state_26059__$1;
(statearr_26070_26135[(2)] = inst_25860);

(statearr_26070_26135[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (15))){
var inst_25918 = (state_26059[(24)]);
var state_26059__$1 = state_26059;
var statearr_26071_26136 = state_26059__$1;
(statearr_26071_26136[(2)] = inst_25918);

(statearr_26071_26136[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (21))){
var inst_25886 = (state_26059[(25)]);
var inst_25982 = (state_26059[(7)]);
var inst_25867 = (state_26059[(26)]);
var inst_25946 = (state_26059[(8)]);
var inst_25983 = (state_26059[(9)]);
var inst_25991 = (state_26059[(17)]);
var inst_25990 = (state_26059[(18)]);
var inst_25984 = (state_26059[(10)]);
var inst_25899 = (state_26059[(27)]);
var inst_25897 = (state_26059[(28)]);
var inst_25978 = (state_26059[(23)]);
var inst_25980 = (state_26059[(11)]);
var inst_25894 = (state_26059[(29)]);
var inst_25956 = (state_26059[(30)]);
var inst_25979 = (state_26059[(12)]);
var inst_25883 = (state_26059[(31)]);
var inst_25896 = (state_26059[(13)]);
var inst_25905 = (state_26059[(32)]);
var inst_25981 = (state_26059[(14)]);
var inst_25890 = (state_26059[(33)]);
var inst_25895 = (state_26059[(15)]);
var inst_25882 = (state_26059[(34)]);
var inst_25955 = (state_26059[(35)]);
var inst_26029 = fluree.db.flake.s.call(null,inst_25990);
var inst_26030 = fluree.db.flake.sid__GT_cid.call(null,inst_26029);
var inst_26031 = (function (){var flakes_bytes = inst_25895;
var t = inst_25867;
var spot = inst_25979;
var add_flakes = inst_25883;
var vec__25951 = inst_25883;
var root_setting_change_QMARK_ = inst_25897;
var ref_QMARK__map = inst_25894;
var r = inst_25991;
var psot = inst_25980;
var add_pred_to_idx_QMARK_ = inst_25905;
var _ = inst_25882;
var vec__25986 = inst_25978;
var tspo = inst_25983;
var cid = inst_26030;
var ecount = inst_25984;
var pred_ecount = inst_25899;
var db_STAR_ = inst_25946;
var seq__25952 = inst_25956;
var system_change_QMARK_ = inst_25896;
var first__25953 = inst_25955;
var add_preds = inst_25886;
var G__25950 = inst_25978;
var opst = inst_25982;
var seq__25987 = inst_25991;
var idx_QMARK__map = inst_25890;
var post = inst_25981;
var first__25988 = inst_25990;
var f = inst_25990;
return (function (p1__25857_SHARP_){
if(cljs.core.truth_(p1__25857_SHARP_)){
var x__5130__auto__ = p1__25857_SHARP_;
var y__5131__auto__ = fluree.db.flake.s.call(null,f);
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
} else {
return fluree.db.flake.s.call(null,f);
}
});
})();
var inst_26032 = cljs.core.update.call(null,inst_25984,inst_26030,inst_26031);
var inst_26033 = cljs.core.conj.call(null,inst_25979,inst_25990);
var inst_26034 = cljs.core.conj.call(null,inst_25980,inst_25990);
var inst_26035 = fluree.db.flake.p.call(null,inst_25990);
var inst_26036 = cljs.core.get.call(null,inst_25890,inst_26035);
var state_26059__$1 = (function (){var statearr_26072 = state_26059;
(statearr_26072[(20)] = inst_26032);

(statearr_26072[(21)] = inst_26034);

(statearr_26072[(22)] = inst_26033);

return statearr_26072;
})();
if(cljs.core.truth_(inst_26036)){
var statearr_26073_26137 = state_26059__$1;
(statearr_26073_26137[(1)] = (34));

} else {
var statearr_26074_26138 = state_26059__$1;
(statearr_26074_26138[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (31))){
var inst_26018 = (state_26059[(36)]);
var state_26059__$1 = state_26059;
var statearr_26075_26139 = state_26059__$1;
(statearr_26075_26139[(2)] = inst_26018);

(statearr_26075_26139[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (32))){
var inst_26027 = (state_26059[(2)]);
var state_26059__$1 = state_26059;
var statearr_26076_26140 = state_26059__$1;
(statearr_26076_26140[(2)] = inst_26027);

(statearr_26076_26140[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (33))){
var inst_26018 = (state_26059[(36)]);
var inst_26022 = (state_26059[(2)]);
var inst_26023 = fluree.db.util.async.throw_err.call(null,inst_26022);
var inst_26024 = cljs.core.assoc.call(null,inst_26018,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_26023);
var state_26059__$1 = state_26059;
var statearr_26077_26141 = state_26059__$1;
(statearr_26077_26141[(2)] = inst_26024);

(statearr_26077_26141[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (13))){
var inst_25867 = (state_26059[(26)]);
var inst_25946 = (state_26059[(8)]);
var inst_25883 = (state_26059[(31)]);
var inst_25895 = (state_26059[(15)]);
var inst_25936 = (state_26059[(2)]);
var inst_25937 = cljs.core.assoc.call(null,inst_25936,new cljs.core.Keyword(null,"t","t",-1397832519),inst_25867);
var inst_25938 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25939 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25940 = (new cljs.core.PersistentVector(null,2,(5),inst_25938,inst_25939,null));
var inst_25941 = cljs.core.update_in.call(null,inst_25937,inst_25940,cljs.core._PLUS_,inst_25895);
var inst_25942 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25943 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_25944 = (new cljs.core.PersistentVector(null,2,(5),inst_25942,inst_25943,null));
var inst_25945 = cljs.core.count.call(null,inst_25883);
var inst_25946__$1 = cljs.core.update_in.call(null,inst_25941,inst_25944,cljs.core._PLUS_,inst_25945);
var inst_25954 = cljs.core.seq.call(null,inst_25883);
var inst_25955 = cljs.core.first.call(null,inst_25954);
var inst_25956 = cljs.core.next.call(null,inst_25954);
var inst_25957 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25958 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_25959 = (new cljs.core.PersistentVector(null,2,(5),inst_25957,inst_25958,null));
var inst_25960 = cljs.core.get_in.call(null,inst_25946__$1,inst_25959);
var inst_25961 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25962 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_25963 = (new cljs.core.PersistentVector(null,2,(5),inst_25961,inst_25962,null));
var inst_25964 = cljs.core.get_in.call(null,inst_25946__$1,inst_25963);
var inst_25965 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25966 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_25967 = (new cljs.core.PersistentVector(null,2,(5),inst_25965,inst_25966,null));
var inst_25968 = cljs.core.get_in.call(null,inst_25946__$1,inst_25967);
var inst_25969 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25970 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_25971 = (new cljs.core.PersistentVector(null,2,(5),inst_25969,inst_25970,null));
var inst_25972 = cljs.core.get_in.call(null,inst_25946__$1,inst_25971);
var inst_25973 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25974 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"tspo","tspo",-440144953)];
var inst_25975 = (new cljs.core.PersistentVector(null,2,(5),inst_25973,inst_25974,null));
var inst_25976 = cljs.core.get_in.call(null,inst_25946__$1,inst_25975);
var inst_25977 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_25978 = inst_25883;
var inst_25979 = inst_25960;
var inst_25980 = inst_25964;
var inst_25981 = inst_25968;
var inst_25982 = inst_25972;
var inst_25983 = inst_25976;
var inst_25984 = inst_25977;
var state_26059__$1 = (function (){var statearr_26078 = state_26059;
(statearr_26078[(7)] = inst_25982);

(statearr_26078[(8)] = inst_25946__$1);

(statearr_26078[(9)] = inst_25983);

(statearr_26078[(10)] = inst_25984);

(statearr_26078[(23)] = inst_25978);

(statearr_26078[(11)] = inst_25980);

(statearr_26078[(30)] = inst_25956);

(statearr_26078[(12)] = inst_25979);

(statearr_26078[(14)] = inst_25981);

(statearr_26078[(35)] = inst_25955);

return statearr_26078;
})();
var statearr_26079_26142 = state_26059__$1;
(statearr_26079_26142[(2)] = null);

(statearr_26079_26142[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (22))){
var inst_26052 = (state_26059[(2)]);
var state_26059__$1 = state_26059;
var statearr_26080_26143 = state_26059__$1;
(statearr_26080_26143[(2)] = inst_26052);

(statearr_26080_26143[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (36))){
var inst_25990 = (state_26059[(18)]);
var inst_25894 = (state_26059[(29)]);
var inst_26041 = (state_26059[(2)]);
var inst_26042 = fluree.db.flake.p.call(null,inst_25990);
var inst_26043 = cljs.core.get.call(null,inst_25894,inst_26042);
var state_26059__$1 = (function (){var statearr_26081 = state_26059;
(statearr_26081[(19)] = inst_26041);

return statearr_26081;
})();
if(cljs.core.truth_(inst_26043)){
var statearr_26082_26144 = state_26059__$1;
(statearr_26082_26144[(1)] = (37));

} else {
var statearr_26083_26145 = state_26059__$1;
(statearr_26083_26145[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (29))){
var inst_26002 = (state_26059[(16)]);
var inst_26013 = (state_26059[(2)]);
var inst_26014 = fluree.db.util.async.throw_err.call(null,inst_26013);
var inst_26015 = cljs.core.assoc.call(null,inst_26002,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_26014);
var state_26059__$1 = state_26059;
var statearr_26084_26146 = state_26059__$1;
(statearr_26084_26146[(2)] = inst_26015);

(statearr_26084_26146[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (6))){
var inst_25867 = (state_26059[(26)]);
var inst_25872 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(db);
var inst_25873 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_25874 = ["Invalid with called for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25872)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25873)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25867),"."].join('');
var inst_25875 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25876 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_25877 = cljs.core.PersistentHashMap.fromArrays(inst_25875,inst_25876);
var inst_25878 = cljs.core.ex_info.call(null,inst_25874,inst_25877);
var inst_25879 = (function(){throw inst_25878})();
var state_26059__$1 = state_26059;
var statearr_26085_26147 = state_26059__$1;
(statearr_26085_26147[(2)] = inst_25879);

(statearr_26085_26147[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (28))){
var inst_25897 = (state_26059[(28)]);
var inst_26018 = (state_26059[(2)]);
var state_26059__$1 = (function (){var statearr_26086 = state_26059;
(statearr_26086[(36)] = inst_26018);

return statearr_26086;
})();
if(cljs.core.truth_(inst_25897)){
var statearr_26087_26148 = state_26059__$1;
(statearr_26087_26148[(1)] = (30));

} else {
var statearr_26088_26149 = state_26059__$1;
(statearr_26088_26149[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (25))){
var inst_26009 = (state_26059[(2)]);
var state_26059__$1 = state_26059;
if(cljs.core.truth_(inst_26009)){
var statearr_26089_26150 = state_26059__$1;
(statearr_26089_26150[(1)] = (26));

} else {
var statearr_26090_26151 = state_26059__$1;
(statearr_26090_26151[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (34))){
var inst_25990 = (state_26059[(18)]);
var inst_25981 = (state_26059[(14)]);
var inst_26038 = cljs.core.conj.call(null,inst_25981,inst_25990);
var state_26059__$1 = state_26059;
var statearr_26091_26152 = state_26059__$1;
(statearr_26091_26152[(2)] = inst_26038);

(statearr_26091_26152[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (17))){
var inst_25925 = (state_26059[(37)]);
var inst_25929 = (state_26059[(2)]);
var inst_25930 = fluree.db.util.async.throw_err.call(null,inst_25929);
var inst_25917 = inst_25925;
var inst_25918 = inst_25930;
var state_26059__$1 = (function (){var statearr_26092 = state_26059;
(statearr_26092[(38)] = inst_25917);

(statearr_26092[(24)] = inst_25918);

return statearr_26092;
})();
var statearr_26093_26153 = state_26059__$1;
(statearr_26093_26153[(2)] = null);

(statearr_26093_26153[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (3))){
var inst_26057 = (state_26059[(2)]);
var state_26059__$1 = state_26059;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26059__$1,inst_26057);
} else {
if((state_val_26060 === (12))){
var inst_25917 = (state_26059[(38)]);
var inst_25924 = (state_26059[(39)]);
var inst_25923 = cljs.core.seq.call(null,inst_25917);
var inst_25924__$1 = cljs.core.first.call(null,inst_25923);
var inst_25925 = cljs.core.next.call(null,inst_25923);
var state_26059__$1 = (function (){var statearr_26094 = state_26059;
(statearr_26094[(39)] = inst_25924__$1);

(statearr_26094[(37)] = inst_25925);

return statearr_26094;
})();
if(cljs.core.truth_(inst_25924__$1)){
var statearr_26095_26154 = state_26059__$1;
(statearr_26095_26154[(1)] = (14));

} else {
var statearr_26096_26155 = state_26059__$1;
(statearr_26096_26155[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (2))){
var inst_25867 = (state_26059[(26)]);
var _ = (function (){var statearr_26097 = state_26059;
(statearr_26097[(4)] = cljs.core.cons.call(null,(5),(state_26059[(4)])));

return statearr_26097;
})();
var inst_25866 = cljs.core.first.call(null,flakes);
var inst_25867__$1 = fluree.db.flake.t.call(null,inst_25866);
var inst_25868 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_25869 = (inst_25868 - (1));
var inst_25870 = cljs.core.not_EQ_.call(null,inst_25867__$1,inst_25869);
var state_26059__$1 = (function (){var statearr_26098 = state_26059;
(statearr_26098[(26)] = inst_25867__$1);

return statearr_26098;
})();
if(inst_25870){
var statearr_26099_26156 = state_26059__$1;
(statearr_26099_26156[(1)] = (6));

} else {
var statearr_26100_26157 = state_26059__$1;
(statearr_26100_26157[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (23))){
var inst_25896 = (state_26059[(13)]);
var state_26059__$1 = state_26059;
var statearr_26101_26158 = state_26059__$1;
(statearr_26101_26158[(2)] = inst_25896);

(statearr_26101_26158[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (35))){
var inst_25981 = (state_26059[(14)]);
var state_26059__$1 = state_26059;
var statearr_26102_26159 = state_26059__$1;
(statearr_26102_26159[(2)] = inst_25981);

(statearr_26102_26159[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (19))){
var inst_26054 = (state_26059[(2)]);
var _ = (function (){var statearr_26103 = state_26059;
(statearr_26103[(4)] = cljs.core.rest.call(null,(state_26059[(4)])));

return statearr_26103;
})();
var state_26059__$1 = state_26059;
var statearr_26104_26160 = state_26059__$1;
(statearr_26104_26160[(2)] = inst_26054);

(statearr_26104_26160[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (11))){
var inst_25905 = (state_26059[(32)]);
var inst_25905__$1 = (state_26059[(2)]);
var inst_25913 = cljs.core.seq.call(null,inst_25905__$1);
var inst_25914 = cljs.core.first.call(null,inst_25913);
var inst_25915 = cljs.core.next.call(null,inst_25913);
var inst_25916 = db;
var inst_25917 = inst_25905__$1;
var inst_25918 = inst_25916;
var state_26059__$1 = (function (){var statearr_26106 = state_26059;
(statearr_26106[(38)] = inst_25917);

(statearr_26106[(24)] = inst_25918);

(statearr_26106[(40)] = inst_25914);

(statearr_26106[(32)] = inst_25905__$1);

(statearr_26106[(41)] = inst_25915);

return statearr_26106;
})();
var statearr_26107_26161 = state_26059__$1;
(statearr_26107_26161[(2)] = null);

(statearr_26107_26161[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (9))){
var inst_25899 = (state_26059[(27)]);
var inst_25883 = (state_26059[(31)]);
var inst_25901 = fluree.db.util.schema.add_to_post_preds_QMARK_.call(null,inst_25883,inst_25899);
var state_26059__$1 = state_26059;
var statearr_26108_26162 = state_26059__$1;
(statearr_26108_26162[(2)] = inst_25901);

(statearr_26108_26162[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (5))){
var _ = (function (){var statearr_26109 = state_26059;
(statearr_26109[(4)] = cljs.core.rest.call(null,(state_26059[(4)])));

return statearr_26109;
})();
var state_26059__$1 = state_26059;
var ex26105 = (state_26059__$1[(2)]);
var statearr_26110_26163 = state_26059__$1;
(statearr_26110_26163[(5)] = ex26105);


if((ex26105 instanceof Error)){
var statearr_26111_26164 = state_26059__$1;
(statearr_26111_26164[(1)] = (4));

(statearr_26111_26164[(5)] = null);

} else {
throw ex26105;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (14))){
var inst_25924 = (state_26059[(39)]);
var inst_25918 = (state_26059[(24)]);
var inst_25927 = fluree.db.graphdb.add_predicate_to_idx.call(null,inst_25918,inst_25924,opts);
var state_26059__$1 = state_26059;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26059__$1,(17),inst_25927);
} else {
if((state_val_26060 === (26))){
var inst_26002 = (state_26059[(16)]);
var inst_26011 = fluree.db.query.schema.schema_map.call(null,inst_26002);
var state_26059__$1 = state_26059;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26059__$1,(29),inst_26011);
} else {
if((state_val_26060 === (16))){
var inst_25934 = (state_26059[(2)]);
var state_26059__$1 = state_26059;
var statearr_26112_26165 = state_26059__$1;
(statearr_26112_26165[(2)] = inst_25934);

(statearr_26112_26165[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (38))){
var inst_25982 = (state_26059[(7)]);
var state_26059__$1 = state_26059;
var statearr_26113_26166 = state_26059__$1;
(statearr_26113_26166[(2)] = inst_25982);

(statearr_26113_26166[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (30))){
var inst_26002 = (state_26059[(16)]);
var inst_26020 = fluree.db.query.schema.setting_map.call(null,inst_26002);
var state_26059__$1 = state_26059;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26059__$1,(33),inst_26020);
} else {
if((state_val_26060 === (10))){
var inst_25903 = cljs.core.PersistentVector.EMPTY;
var state_26059__$1 = state_26059;
var statearr_26114_26167 = state_26059__$1;
(statearr_26114_26167[(2)] = inst_25903);

(statearr_26114_26167[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (18))){
var inst_25990 = (state_26059[(18)]);
var inst_25978 = (state_26059[(23)]);
var inst_25989 = cljs.core.seq.call(null,inst_25978);
var inst_25990__$1 = cljs.core.first.call(null,inst_25989);
var inst_25991 = cljs.core.next.call(null,inst_25989);
var inst_25992 = cljs.core.not.call(null,inst_25990__$1);
var state_26059__$1 = (function (){var statearr_26115 = state_26059;
(statearr_26115[(17)] = inst_25991);

(statearr_26115[(18)] = inst_25990__$1);

return statearr_26115;
})();
if(inst_25992){
var statearr_26116_26168 = state_26059__$1;
(statearr_26116_26168[(1)] = (20));

} else {
var statearr_26117_26169 = state_26059__$1;
(statearr_26117_26169[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (37))){
var inst_25982 = (state_26059[(7)]);
var inst_25990 = (state_26059[(18)]);
var inst_26045 = cljs.core.conj.call(null,inst_25982,inst_25990);
var state_26059__$1 = state_26059;
var statearr_26118_26170 = state_26059__$1;
(statearr_26118_26170[(2)] = inst_26045);

(statearr_26118_26170[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26060 === (8))){
var inst_25886 = (state_26059[(25)]);
var inst_25867 = (state_26059[(26)]);
var inst_25883 = (state_26059[(31)]);
var inst_25896 = (state_26059[(13)]);
var inst_25890 = (state_26059[(33)]);
var inst_25882 = (state_26059[(34)]);
var inst_25882__$1 = (state_26059[(2)]);
var inst_25883__$1 = cljs.core.filter.call(null,fluree.db.graphdb.include_flake_QMARK_,flakes);
var inst_25884 = cljs.core.PersistentHashSet.EMPTY;
var inst_25885 = cljs.core.map.call(null,fluree.db.flake.p,inst_25883__$1);
var inst_25886__$1 = cljs.core.into.call(null,inst_25884,inst_25885);
var inst_25887 = cljs.core.PersistentHashMap.EMPTY;
var inst_25888 = (function (){var t = inst_25867;
var _ = inst_25882__$1;
var add_flakes = inst_25883__$1;
var add_preds = inst_25886__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_25889 = cljs.core.map.call(null,inst_25888,inst_25886__$1);
var inst_25890__$1 = cljs.core.into.call(null,inst_25887,inst_25889);
var inst_25891 = cljs.core.PersistentHashMap.EMPTY;
var inst_25892 = (function (){var t = inst_25867;
var _ = inst_25882__$1;
var add_flakes = inst_25883__$1;
var add_preds = inst_25886__$1;
var idx_QMARK__map = inst_25890__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_25893 = cljs.core.map.call(null,inst_25892,inst_25886__$1);
var inst_25894 = cljs.core.into.call(null,inst_25891,inst_25893);
var inst_25895 = fluree.db.flake.size_bytes.call(null,inst_25883__$1);
var inst_25896__$1 = fluree.db.util.schema.system_change_QMARK_.call(null,inst_25883__$1);
var inst_25897 = fluree.db.util.schema.setting_change_QMARK_.call(null,inst_25883__$1);
var inst_25898 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_25899 = cljs.core.get.call(null,inst_25898,(0));
var state_26059__$1 = (function (){var statearr_26119 = state_26059;
(statearr_26119[(25)] = inst_25886__$1);

(statearr_26119[(27)] = inst_25899);

(statearr_26119[(28)] = inst_25897);

(statearr_26119[(29)] = inst_25894);

(statearr_26119[(31)] = inst_25883__$1);

(statearr_26119[(13)] = inst_25896__$1);

(statearr_26119[(33)] = inst_25890__$1);

(statearr_26119[(15)] = inst_25895);

(statearr_26119[(34)] = inst_25882__$1);

return statearr_26119;
})();
if(cljs.core.truth_(inst_25896__$1)){
var statearr_26120_26171 = state_26059__$1;
(statearr_26120_26171[(1)] = (9));

} else {
var statearr_26121_26172 = state_26059__$1;
(statearr_26121_26172[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_26122 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26122[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_26122[(1)] = (1));

return statearr_26122;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_26059){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26059);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26123){var ex__2749__auto__ = e26123;
var statearr_26124_26173 = state_26059;
(statearr_26124_26173[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26059[(4)]))){
var statearr_26125_26174 = state_26059;
(statearr_26125_26174[(1)] = cljs.core.first.call(null,(state_26059[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26175 = state_26059;
state_26059 = G__26175;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_26059){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_26059);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26126 = f__2769__auto__.call(null);
(statearr_26126[(6)] = c__2768__auto__);

return statearr_26126;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__26177 = arguments.length;
switch (G__26177) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.call(null,db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.call(null);
var c__2768__auto___26324 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26273){
var state_val_26274 = (state_26273[(1)]);
if((state_val_26274 === (7))){
var state_26273__$1 = state_26273;
var statearr_26275_26325 = state_26273__$1;
(statearr_26275_26325[(2)] = null);

(statearr_26275_26325[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26274 === (20))){
var inst_26223 = (state_26273[(7)]);
var inst_26222 = (state_26273[(8)]);
var inst_26221 = (state_26273[(9)]);
var inst_26242 = (inst_26221 + (1));
var inst_26243 = cljs.core.assoc.call(null,inst_26223,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26242);
var inst_26244 = fluree.db.graphdb.with_t.call(null,inst_26243,inst_26222,opts);
var state_26273__$1 = state_26273;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26273__$1,(23),inst_26244);
} else {
if((state_val_26274 === (1))){
var state_26273__$1 = state_26273;
var statearr_26276_26326 = state_26273__$1;
(statearr_26276_26326[(2)] = null);

(statearr_26276_26326[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26274 === (24))){
var inst_26247 = (state_26273[(10)]);
var inst_26250 = cljs.core.assoc.call(null,inst_26247,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_26273__$1 = state_26273;
var statearr_26277_26327 = state_26273__$1;
(statearr_26277_26327[(2)] = inst_26250);

(statearr_26277_26327[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26274 === (4))){
var inst_26178 = (state_26273[(2)]);
var inst_26179 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_26178);
var state_26273__$1 = state_26273;
var statearr_26278_26328 = state_26273__$1;
(statearr_26278_26328[(2)] = inst_26179);

(statearr_26278_26328[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26274 === (15))){
var inst_26229 = (state_26273[(11)]);
var state_26273__$1 = state_26273;
var statearr_26279_26329 = state_26273__$1;
(statearr_26279_26329[(2)] = inst_26229);

(statearr_26279_26329[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26274 === (21))){
var state_26273__$1 = state_26273;
var statearr_26280_26330 = state_26273__$1;
(statearr_26280_26330[(2)] = null);

(statearr_26280_26330[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26274 === (13))){
var inst_26265 = (state_26273[(2)]);
var inst_26266 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_26265);
var state_26273__$1 = state_26273;
var statearr_26281_26331 = state_26273__$1;
(statearr_26281_26331[(2)] = inst_26266);

(statearr_26281_26331[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26274 === (22))){
var inst_26261 = (state_26273[(2)]);
var state_26273__$1 = state_26273;
var statearr_26282_26332 = state_26273__$1;
(statearr_26282_26332[(2)] = inst_26261);

(statearr_26282_26332[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26274 === (6))){
var inst_26189 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(db);
var inst_26190 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26191 = ["Invalid 'with' called for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26189)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26190)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_26192 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26193 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26194 = cljs.core.PersistentHashMap.fromArrays(inst_26192,inst_26193);
var inst_26195 = cljs.core.ex_info.call(null,inst_26191,inst_26194);
var inst_26196 = (function(){throw inst_26195})();
var state_26273__$1 = state_26273;
var statearr_26285_26333 = state_26273__$1;
(statearr_26285_26333[(2)] = inst_26196);

(statearr_26285_26333[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26274 === (25))){
var inst_26230 = (state_26273[(12)]);
var inst_26247 = (state_26273[(10)]);
var inst_26229 = (state_26273[(11)]);
var inst_26252 = fluree.db.flake.t.call(null,inst_26229);
var inst_26253 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26254 = [inst_26229];
var inst_26255 = (new cljs.core.PersistentVector(null,1,(5),inst_26253,inst_26254,null));
var inst_26220 = inst_26230;
var inst_26221 = inst_26252;
var inst_26222 = inst_26255;
var inst_26223 = inst_26247;
var state_26273__$1 = (function (){var statearr_26286 = state_26273;
(statearr_26286[(7)] = inst_26223);

(statearr_26286[(8)] = inst_26222);

(statearr_26286[(13)] = inst_26220);

(statearr_26286[(9)] = inst_26221);

return statearr_26286;
})();
var statearr_26287_26334 = state_26273__$1;
(statearr_26287_26334[(2)] = null);

(statearr_26287_26334[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26274 === (17))){
var inst_26223 = (state_26273[(7)]);
var inst_26230 = (state_26273[(12)]);
var inst_26229 = (state_26273[(11)]);
var inst_26222 = (state_26273[(8)]);
var inst_26221 = (state_26273[(9)]);
var inst_26238 = cljs.core.conj.call(null,inst_26222,inst_26229);
var tmp26283 = inst_26223;
var tmp26284 = inst_26221;
var inst_26220 = inst_26230;
var inst_26221__$1 = tmp26284;
var inst_26222__$1 = inst_26238;
var inst_26223__$1 = tmp26283;
var state_26273__$1 = (function (){var statearr_26288 = state_26273;
(statearr_26288[(7)] = inst_26223__$1);

(statearr_26288[(8)] = inst_26222__$1);

(statearr_26288[(13)] = inst_26220);

(statearr_26288[(9)] = inst_26221__$1);

return statearr_26288;
})();
var statearr_26289_26335 = state_26273__$1;
(statearr_26289_26335[(2)] = null);

(statearr_26289_26335[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26274 === (3))){
var inst_26271 = (state_26273[(2)]);
var state_26273__$1 = state_26273;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26273__$1,inst_26271);
} else {
if((state_val_26274 === (12))){
var inst_26229 = (state_26273[(11)]);
var inst_26220 = (state_26273[(13)]);
var inst_26228 = cljs.core.seq.call(null,inst_26220);
var inst_26229__$1 = cljs.core.first.call(null,inst_26228);
var inst_26230 = cljs.core.next.call(null,inst_26228);
var state_26273__$1 = (function (){var statearr_26290 = state_26273;
(statearr_26290[(12)] = inst_26230);

(statearr_26290[(11)] = inst_26229__$1);

return statearr_26290;
})();
if(cljs.core.truth_(inst_26229__$1)){
var statearr_26291_26336 = state_26273__$1;
(statearr_26291_26336[(1)] = (14));

} else {
var statearr_26292_26337 = state_26273__$1;
(statearr_26292_26337[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26274 === (2))){
var _ = (function (){var statearr_26293 = state_26273;
(statearr_26293[(4)] = cljs.core.cons.call(null,(5),(state_26273[(4)])));

return statearr_26293;
})();
var inst_26185 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26186 = (inst_26185 + (1));
var inst_26187 = cljs.core.not_EQ_.call(null,block,inst_26186);
var state_26273__$1 = state_26273;
if(inst_26187){
var statearr_26294_26338 = state_26273__$1;
(statearr_26294_26338[(1)] = (6));

} else {
var statearr_26295_26339 = state_26273__$1;
(statearr_26295_26339[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26274 === (23))){
var inst_26229 = (state_26273[(11)]);
var inst_26246 = (state_26273[(2)]);
var inst_26247 = fluree.db.util.async.throw_err.call(null,inst_26246);
var inst_26248 = (inst_26229 == null);
var state_26273__$1 = (function (){var statearr_26296 = state_26273;
(statearr_26296[(10)] = inst_26247);

return statearr_26296;
})();
if(cljs.core.truth_(inst_26248)){
var statearr_26297_26340 = state_26273__$1;
(statearr_26297_26340[(1)] = (24));

} else {
var statearr_26298_26341 = state_26273__$1;
(statearr_26298_26341[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26274 === (19))){
var inst_26263 = (state_26273[(2)]);
var state_26273__$1 = state_26273;
var statearr_26299_26342 = state_26273__$1;
(statearr_26299_26342[(2)] = inst_26263);

(statearr_26299_26342[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26274 === (11))){
var inst_26268 = (state_26273[(2)]);
var _ = (function (){var statearr_26301 = state_26273;
(statearr_26301[(4)] = cljs.core.rest.call(null,(state_26273[(4)])));

return statearr_26301;
})();
var state_26273__$1 = state_26273;
var statearr_26302_26343 = state_26273__$1;
(statearr_26302_26343[(2)] = inst_26268);

(statearr_26302_26343[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26274 === (9))){
var inst_26202 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_26203 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_26202);
var state_26273__$1 = state_26273;
var statearr_26303_26344 = state_26273__$1;
(statearr_26303_26344[(2)] = inst_26203);

(statearr_26303_26344[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26274 === (5))){
var _ = (function (){var statearr_26304 = state_26273;
(statearr_26304[(4)] = cljs.core.rest.call(null,(state_26273[(4)])));

return statearr_26304;
})();
var state_26273__$1 = state_26273;
var ex26300 = (state_26273__$1[(2)]);
var statearr_26305_26345 = state_26273__$1;
(statearr_26305_26345[(5)] = ex26300);


var statearr_26306_26346 = state_26273__$1;
(statearr_26306_26346[(1)] = (4));

(statearr_26306_26346[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26274 === (14))){
var inst_26229 = (state_26273[(11)]);
var inst_26221 = (state_26273[(9)]);
var inst_26232 = fluree.db.flake.t.call(null,inst_26229);
var inst_26233 = cljs.core._EQ_.call(null,inst_26221,inst_26232);
var state_26273__$1 = state_26273;
var statearr_26307_26347 = state_26273__$1;
(statearr_26307_26347[(2)] = inst_26233);

(statearr_26307_26347[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26274 === (26))){
var inst_26258 = (state_26273[(2)]);
var state_26273__$1 = state_26273;
var statearr_26308_26348 = state_26273__$1;
(statearr_26308_26348[(2)] = inst_26258);

(statearr_26308_26348[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26274 === (16))){
var inst_26236 = (state_26273[(2)]);
var state_26273__$1 = state_26273;
if(cljs.core.truth_(inst_26236)){
var statearr_26309_26349 = state_26273__$1;
(statearr_26309_26349[(1)] = (17));

} else {
var statearr_26310_26350 = state_26273__$1;
(statearr_26310_26350[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26274 === (10))){
var inst_26205 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_block,flakes);
var inst_26213 = cljs.core.seq.call(null,inst_26205);
var inst_26214 = cljs.core.first.call(null,inst_26213);
var inst_26215 = cljs.core.next.call(null,inst_26213);
var inst_26216 = cljs.core.first.call(null,inst_26205);
var inst_26217 = fluree.db.flake.t.call(null,inst_26216);
var inst_26218 = cljs.core.PersistentVector.EMPTY;
var inst_26219 = db;
var inst_26220 = inst_26205;
var inst_26221 = inst_26217;
var inst_26222 = inst_26218;
var inst_26223 = inst_26219;
var state_26273__$1 = (function (){var statearr_26311 = state_26273;
(statearr_26311[(14)] = inst_26215);

(statearr_26311[(7)] = inst_26223);

(statearr_26311[(15)] = inst_26214);

(statearr_26311[(8)] = inst_26222);

(statearr_26311[(13)] = inst_26220);

(statearr_26311[(9)] = inst_26221);

return statearr_26311;
})();
var statearr_26312_26351 = state_26273__$1;
(statearr_26312_26351[(2)] = null);

(statearr_26312_26351[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26274 === (18))){
var state_26273__$1 = state_26273;
var statearr_26313_26352 = state_26273__$1;
(statearr_26313_26352[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26274 === (8))){
var inst_26199 = (state_26273[(2)]);
var inst_26200 = cljs.core.empty_QMARK_.call(null,flakes);
var state_26273__$1 = (function (){var statearr_26315 = state_26273;
(statearr_26315[(16)] = inst_26199);

return statearr_26315;
})();
if(inst_26200){
var statearr_26316_26353 = state_26273__$1;
(statearr_26316_26353[(1)] = (9));

} else {
var statearr_26317_26354 = state_26273__$1;
(statearr_26317_26354[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_26318 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26318[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_26318[(1)] = (1));

return statearr_26318;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_26273){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26273);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26319){var ex__2749__auto__ = e26319;
var statearr_26320_26355 = state_26273;
(statearr_26320_26355[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26273[(4)]))){
var statearr_26321_26356 = state_26273;
(statearr_26321_26356[(1)] = cljs.core.first.call(null,(state_26273[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26357 = state_26273;
state_26273 = G__26357;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_26273){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_26273);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26322 = f__2769__auto__.call(null);
(statearr_26322[(6)] = c__2768__auto___26324);

return statearr_26322;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26409){
var state_val_26410 = (state_26409[(1)]);
if((state_val_26410 === (7))){
var state_26409__$1 = state_26409;
var statearr_26411_26438 = state_26409__$1;
(statearr_26411_26438[(2)] = tt_id);

(statearr_26411_26438[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26410 === (1))){
var state_26409__$1 = state_26409;
var statearr_26412_26439 = state_26409__$1;
(statearr_26412_26439[(2)] = null);

(statearr_26412_26439[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26410 === (4))){
var inst_26358 = (state_26409[(2)]);
var state_26409__$1 = state_26409;
var statearr_26413_26440 = state_26409__$1;
(statearr_26413_26440[(2)] = inst_26358);

(statearr_26413_26440[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26410 === (13))){
var inst_26402 = (state_26409[(2)]);
var state_26409__$1 = state_26409;
var statearr_26414_26441 = state_26409__$1;
(statearr_26414_26441[(2)] = inst_26402);

(statearr_26414_26441[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26410 === (6))){
var inst_26366 = cljs.core.random_uuid.call(null);
var state_26409__$1 = state_26409;
var statearr_26415_26442 = state_26409__$1;
(statearr_26415_26442[(2)] = inst_26366);

(statearr_26415_26442[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26410 === (3))){
var inst_26407 = (state_26409[(2)]);
var state_26409__$1 = state_26409;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26409__$1,inst_26407);
} else {
if((state_val_26410 === (12))){
var inst_26385 = (state_26409[(7)]);
var state_26409__$1 = state_26409;
var statearr_26416_26443 = state_26409__$1;
(statearr_26416_26443[(2)] = inst_26385);

(statearr_26416_26443[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26410 === (2))){
var _ = (function (){var statearr_26417 = state_26409;
(statearr_26417[(4)] = cljs.core.cons.call(null,(5),(state_26409[(4)])));

return statearr_26417;
})();
var inst_26364 = (tt_id == null);
var state_26409__$1 = state_26409;
if(cljs.core.truth_(inst_26364)){
var statearr_26418_26444 = state_26409__$1;
(statearr_26418_26444[(1)] = (6));

} else {
var statearr_26419_26445 = state_26409__$1;
(statearr_26419_26445[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26410 === (11))){
var inst_26385 = (state_26409[(7)]);
var inst_26392 = (state_26409[(8)]);
var inst_26395 = fluree.db.graphdb.with_t.call(null,inst_26385,inst_26392);
var state_26409__$1 = state_26409;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26409__$1,(14),inst_26395);
} else {
if((state_val_26410 === (9))){
var inst_26386 = (state_26409[(9)]);
var inst_26392 = (state_26409[(8)]);
var inst_26391 = cljs.core.seq.call(null,inst_26386);
var inst_26392__$1 = cljs.core.first.call(null,inst_26391);
var inst_26393 = cljs.core.next.call(null,inst_26391);
var state_26409__$1 = (function (){var statearr_26421 = state_26409;
(statearr_26421[(10)] = inst_26393);

(statearr_26421[(8)] = inst_26392__$1);

return statearr_26421;
})();
if(cljs.core.truth_(inst_26392__$1)){
var statearr_26422_26446 = state_26409__$1;
(statearr_26422_26446[(1)] = (11));

} else {
var statearr_26423_26447 = state_26409__$1;
(statearr_26423_26447[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26410 === (5))){
var _ = (function (){var statearr_26424 = state_26409;
(statearr_26424[(4)] = cljs.core.rest.call(null,(state_26409[(4)])));

return statearr_26424;
})();
var state_26409__$1 = state_26409;
var ex26420 = (state_26409__$1[(2)]);
var statearr_26425_26448 = state_26409__$1;
(statearr_26425_26448[(5)] = ex26420);


if((ex26420 instanceof Error)){
var statearr_26426_26449 = state_26409__$1;
(statearr_26426_26449[(1)] = (4));

(statearr_26426_26449[(5)] = null);

} else {
throw ex26420;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26410 === (14))){
var inst_26393 = (state_26409[(10)]);
var inst_26397 = (state_26409[(2)]);
var inst_26398 = fluree.db.util.async.throw_err.call(null,inst_26397);
var inst_26385 = inst_26398;
var inst_26386 = inst_26393;
var state_26409__$1 = (function (){var statearr_26427 = state_26409;
(statearr_26427[(9)] = inst_26386);

(statearr_26427[(7)] = inst_26385);

return statearr_26427;
})();
var statearr_26428_26450 = state_26409__$1;
(statearr_26428_26450[(2)] = null);

(statearr_26428_26450[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26410 === (10))){
var inst_26404 = (state_26409[(2)]);
var _ = (function (){var statearr_26429 = state_26409;
(statearr_26429[(4)] = cljs.core.rest.call(null,(state_26409[(4)])));

return statearr_26429;
})();
var state_26409__$1 = state_26409;
var statearr_26430_26451 = state_26409__$1;
(statearr_26430_26451[(2)] = inst_26404);

(statearr_26430_26451[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26410 === (8))){
var inst_26369 = (state_26409[(2)]);
var inst_26370 = (function (){var tt_id__$1 = inst_26369;
return (function (db_STAR_,idx){
return cljs.core.update.call(null,db_STAR_,idx,cljs.core.assoc,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id__$1);
});
})();
var inst_26371 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_26369);
var inst_26372 = cljs.core.reduce.call(null,inst_26370,inst_26371,fluree.db.index.types);
var inst_26373 = cljs.core.sort_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),fluree.db.flake.cmp_tx,flakes);
var inst_26374 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26373);
var inst_26382 = cljs.core.seq.call(null,inst_26374);
var inst_26383 = cljs.core.first.call(null,inst_26382);
var inst_26384 = cljs.core.next.call(null,inst_26382);
var inst_26385 = inst_26372;
var inst_26386 = inst_26374;
var state_26409__$1 = (function (){var statearr_26431 = state_26409;
(statearr_26431[(9)] = inst_26386);

(statearr_26431[(11)] = inst_26384);

(statearr_26431[(12)] = inst_26383);

(statearr_26431[(7)] = inst_26385);

return statearr_26431;
})();
var statearr_26432_26452 = state_26409__$1;
(statearr_26432_26452[(2)] = null);

(statearr_26432_26452[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____0 = (function (){
var statearr_26433 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26433[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__);

(statearr_26433[(1)] = (1));

return statearr_26433;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____1 = (function (state_26409){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26409);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26434){var ex__2749__auto__ = e26434;
var statearr_26435_26453 = state_26409;
(statearr_26435_26453[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26409[(4)]))){
var statearr_26436_26454 = state_26409;
(statearr_26436_26454[(1)] = cljs.core.first.call(null,(state_26409[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26455 = state_26409;
state_26409 = G__26455;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__ = function(state_26409){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____1.call(this,state_26409);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26437 = f__2769__auto__.call(null);
(statearr_26437[(6)] = c__2768__auto__);

return statearr_26437;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.call(null);
var c__2768__auto___26642 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26573){
var state_val_26574 = (state_26573[(1)]);
if((state_val_26574 === (7))){
var inst_26483 = (state_26573[(7)]);
var inst_26483__$1 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_26573__$1 = (function (){var statearr_26575 = state_26573;
(statearr_26575[(7)] = inst_26483__$1);

return statearr_26575;
})();
if(inst_26483__$1){
var statearr_26576_26643 = state_26573__$1;
(statearr_26576_26643[(1)] = (13));

} else {
var statearr_26577_26644 = state_26573__$1;
(statearr_26577_26644[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (20))){
var state_26573__$1 = state_26573;
var statearr_26578_26645 = state_26573__$1;
(statearr_26578_26645[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (27))){
var inst_26519 = (state_26573[(8)]);
var inst_26523 = fluree.db.flake.s.call(null,inst_26519);
var state_26573__$1 = state_26573;
var statearr_26580_26646 = state_26573__$1;
(statearr_26580_26646[(2)] = inst_26523);

(statearr_26580_26646[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (1))){
var state_26573__$1 = state_26573;
var statearr_26581_26647 = state_26573__$1;
(statearr_26581_26647[(2)] = null);

(statearr_26581_26647[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (24))){
var inst_26513 = (state_26573[(9)]);
var inst_26517 = cljs.core.first.call(null,inst_26513);
var state_26573__$1 = state_26573;
var statearr_26582_26648 = state_26573__$1;
(statearr_26582_26648[(2)] = inst_26517);

(statearr_26582_26648[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (39))){
var state_26573__$1 = state_26573;
var statearr_26583_26649 = state_26573__$1;
(statearr_26583_26649[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (4))){
var inst_26456 = (state_26573[(2)]);
var inst_26457 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_26458 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26459 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_26460 = cljs.core.PersistentHashMap.fromArrays(inst_26458,inst_26459);
var inst_26461 = cljs.core.ex_info.call(null,inst_26457,inst_26460,inst_26456);
var inst_26462 = cljs.core.async.put_BANG_.call(null,return_chan,inst_26461);
var state_26573__$1 = state_26573;
var statearr_26585_26650 = state_26573__$1;
(statearr_26585_26650[(2)] = inst_26462);

(statearr_26585_26650[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (15))){
var inst_26490 = (state_26573[(2)]);
var state_26573__$1 = state_26573;
if(cljs.core.truth_(inst_26490)){
var statearr_26586_26651 = state_26573__$1;
(statearr_26586_26651[(1)] = (16));

} else {
var statearr_26587_26652 = state_26573__$1;
(statearr_26587_26652[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (21))){
var inst_26539 = (state_26573[(2)]);
var state_26573__$1 = state_26573;
var statearr_26588_26653 = state_26573__$1;
(statearr_26588_26653[(2)] = inst_26539);

(statearr_26588_26653[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (31))){
var inst_26537 = (state_26573[(2)]);
var state_26573__$1 = state_26573;
var statearr_26589_26654 = state_26573__$1;
(statearr_26589_26654[(2)] = inst_26537);

(statearr_26589_26654[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (32))){
var inst_26543 = (state_26573[(10)]);
var inst_26545 = cljs.core.async.put_BANG_.call(null,return_chan,inst_26543);
var state_26573__$1 = state_26573;
var statearr_26590_26655 = state_26573__$1;
(statearr_26590_26655[(2)] = inst_26545);

(statearr_26590_26655[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (40))){
var inst_26566 = (state_26573[(2)]);
var state_26573__$1 = state_26573;
var statearr_26591_26656 = state_26573__$1;
(statearr_26591_26656[(2)] = inst_26566);

(statearr_26591_26656[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (33))){
var inst_26543 = (state_26573[(10)]);
var inst_26547 = (state_26573[(11)]);
var inst_26547__$1 = (inst_26543 == null);
var state_26573__$1 = (function (){var statearr_26592 = state_26573;
(statearr_26592[(11)] = inst_26547__$1);

return statearr_26592;
})();
if(cljs.core.truth_(inst_26547__$1)){
var statearr_26593_26657 = state_26573__$1;
(statearr_26593_26657[(1)] = (35));

} else {
var statearr_26594_26658 = state_26573__$1;
(statearr_26594_26658[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (13))){
var inst_26485 = cljs.core.first.call(null,ident);
var inst_26486 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_26485);
var inst_26487 = (inst_26486 == null);
var state_26573__$1 = state_26573;
var statearr_26595_26659 = state_26573__$1;
(statearr_26595_26659[(2)] = inst_26487);

(statearr_26595_26659[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (22))){
var inst_26513 = (state_26573[(9)]);
var inst_26512 = (state_26573[(2)]);
var inst_26513__$1 = fluree.db.util.async.throw_err.call(null,inst_26512);
var inst_26514 = (inst_26513__$1 == null);
var state_26573__$1 = (function (){var statearr_26596 = state_26573;
(statearr_26596[(9)] = inst_26513__$1);

return statearr_26596;
})();
if(cljs.core.truth_(inst_26514)){
var statearr_26597_26660 = state_26573__$1;
(statearr_26597_26660[(1)] = (23));

} else {
var statearr_26598_26661 = state_26573__$1;
(statearr_26598_26661[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (36))){
var inst_26547 = (state_26573[(11)]);
var state_26573__$1 = state_26573;
var statearr_26599_26662 = state_26573__$1;
(statearr_26599_26662[(2)] = inst_26547);

(statearr_26599_26662[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (41))){
var inst_26561 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_26573__$1 = state_26573;
var statearr_26600_26663 = state_26573__$1;
(statearr_26600_26663[(2)] = inst_26561);

(statearr_26600_26663[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (43))){
var inst_26564 = (state_26573[(2)]);
var state_26573__$1 = state_26573;
var statearr_26601_26664 = state_26573__$1;
(statearr_26601_26664[(2)] = inst_26564);

(statearr_26601_26664[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (29))){
var inst_26528 = cljs.core.pr_str.call(null,ident);
var inst_26529 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_26528].join('');
var inst_26530 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26531 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_26532 = cljs.core.PersistentHashMap.fromArrays(inst_26530,inst_26531);
var inst_26533 = cljs.core.ex_info.call(null,inst_26529,inst_26532);
var inst_26534 = (function(){throw inst_26533})();
var state_26573__$1 = state_26573;
var statearr_26602_26665 = state_26573__$1;
(statearr_26602_26665[(2)] = inst_26534);

(statearr_26602_26665[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (6))){
var inst_26470 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26471 = [ident];
var inst_26472 = (new cljs.core.PersistentVector(null,1,(5),inst_26470,inst_26471,null));
var inst_26473 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26472);
var state_26573__$1 = state_26573;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26573__$1,(9),inst_26473);
} else {
if((state_val_26574 === (28))){
var inst_26525 = (state_26573[(2)]);
var state_26573__$1 = state_26573;
var statearr_26603_26666 = state_26573__$1;
(statearr_26603_26666[(2)] = inst_26525);

(statearr_26603_26666[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (25))){
var inst_26519 = (state_26573[(8)]);
var inst_26519__$1 = (state_26573[(2)]);
var inst_26520 = (inst_26519__$1 == null);
var state_26573__$1 = (function (){var statearr_26604 = state_26573;
(statearr_26604[(8)] = inst_26519__$1);

return statearr_26604;
})();
if(cljs.core.truth_(inst_26520)){
var statearr_26605_26667 = state_26573__$1;
(statearr_26605_26667[(1)] = (26));

} else {
var statearr_26606_26668 = state_26573__$1;
(statearr_26606_26668[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (34))){
var inst_26568 = (state_26573[(2)]);
var _ = (function (){var statearr_26607 = state_26573;
(statearr_26607[(4)] = cljs.core.rest.call(null,(state_26573[(4)])));

return statearr_26607;
})();
var state_26573__$1 = state_26573;
var statearr_26608_26669 = state_26573__$1;
(statearr_26608_26669[(2)] = inst_26568);

(statearr_26608_26669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (17))){
var inst_26501 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_26573__$1 = state_26573;
if(inst_26501){
var statearr_26609_26670 = state_26573__$1;
(statearr_26609_26670[(1)] = (19));

} else {
var statearr_26610_26671 = state_26573__$1;
(statearr_26610_26671[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (3))){
var inst_26571 = (state_26573[(2)]);
var state_26573__$1 = state_26573;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26573__$1,inst_26571);
} else {
if((state_val_26574 === (12))){
var inst_26481 = (state_26573[(2)]);
var state_26573__$1 = state_26573;
var statearr_26611_26672 = state_26573__$1;
(statearr_26611_26672[(2)] = inst_26481);

(statearr_26611_26672[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (2))){
var _ = (function (){var statearr_26612 = state_26573;
(statearr_26612[(4)] = cljs.core.cons.call(null,(5),(state_26573[(4)])));

return statearr_26612;
})();
var inst_26468 = typeof ident === 'number';
var state_26573__$1 = state_26573;
if(cljs.core.truth_(inst_26468)){
var statearr_26613_26673 = state_26573__$1;
(statearr_26613_26673[(1)] = (6));

} else {
var statearr_26614_26674 = state_26573__$1;
(statearr_26614_26674[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (23))){
var state_26573__$1 = state_26573;
var statearr_26615_26675 = state_26573__$1;
(statearr_26615_26675[(2)] = null);

(statearr_26615_26675[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (35))){
var state_26573__$1 = state_26573;
var statearr_26616_26676 = state_26573__$1;
(statearr_26616_26676[(2)] = strict_QMARK_);

(statearr_26616_26676[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (19))){
var inst_26504 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26505 = cljs.core.first.call(null,ident);
var inst_26506 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_26505);
var inst_26507 = cljs.core.second.call(null,ident);
var inst_26508 = [inst_26506,inst_26507];
var inst_26509 = (new cljs.core.PersistentVector(null,2,(5),inst_26504,inst_26508,null));
var inst_26510 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_26509);
var state_26573__$1 = state_26573;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26573__$1,(22),inst_26510);
} else {
if((state_val_26574 === (11))){
var state_26573__$1 = state_26573;
var statearr_26618_26677 = state_26573__$1;
(statearr_26618_26677[(2)] = null);

(statearr_26618_26677[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (9))){
var inst_26475 = (state_26573[(2)]);
var inst_26476 = fluree.db.util.async.throw_err.call(null,inst_26475);
var inst_26477 = cljs.core.not_empty.call(null,inst_26476);
var state_26573__$1 = state_26573;
if(cljs.core.truth_(inst_26477)){
var statearr_26619_26678 = state_26573__$1;
(statearr_26619_26678[(1)] = (10));

} else {
var statearr_26620_26679 = state_26573__$1;
(statearr_26620_26679[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (5))){
var _ = (function (){var statearr_26621 = state_26573;
(statearr_26621[(4)] = cljs.core.rest.call(null,(state_26573[(4)])));

return statearr_26621;
})();
var state_26573__$1 = state_26573;
var ex26617 = (state_26573__$1[(2)]);
var statearr_26622_26680 = state_26573__$1;
(statearr_26622_26680[(5)] = ex26617);


var statearr_26623_26681 = state_26573__$1;
(statearr_26623_26681[(1)] = (4));

(statearr_26623_26681[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (14))){
var inst_26483 = (state_26573[(7)]);
var state_26573__$1 = state_26573;
var statearr_26624_26682 = state_26573__$1;
(statearr_26624_26682[(2)] = inst_26483);

(statearr_26624_26682[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (26))){
var state_26573__$1 = state_26573;
var statearr_26625_26683 = state_26573__$1;
(statearr_26625_26683[(2)] = null);

(statearr_26625_26683[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (16))){
var inst_26492 = cljs.core.first.call(null,ident);
var inst_26493 = cljs.core.pr_str.call(null,inst_26492);
var inst_26494 = ["Subject ID lookup failed. The predicate ",inst_26493," does not exist."].join('');
var inst_26495 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26496 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_26497 = cljs.core.PersistentHashMap.fromArrays(inst_26495,inst_26496);
var inst_26498 = cljs.core.ex_info.call(null,inst_26494,inst_26497);
var inst_26499 = (function(){throw inst_26498})();
var state_26573__$1 = state_26573;
var statearr_26626_26684 = state_26573__$1;
(statearr_26626_26684[(2)] = inst_26499);

(statearr_26626_26684[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (38))){
var inst_26553 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_26554 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26555 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_26556 = cljs.core.PersistentHashMap.fromArrays(inst_26554,inst_26555);
var inst_26557 = cljs.core.ex_info.call(null,inst_26553,inst_26556);
var inst_26558 = cljs.core.async.put_BANG_.call(null,return_chan,inst_26557);
var state_26573__$1 = state_26573;
var statearr_26627_26685 = state_26573__$1;
(statearr_26627_26685[(2)] = inst_26558);

(statearr_26627_26685[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (30))){
var state_26573__$1 = state_26573;
var statearr_26628_26686 = state_26573__$1;
(statearr_26628_26686[(2)] = null);

(statearr_26628_26686[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (10))){
var state_26573__$1 = state_26573;
var statearr_26629_26687 = state_26573__$1;
(statearr_26629_26687[(2)] = ident);

(statearr_26629_26687[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (18))){
var inst_26541 = (state_26573[(2)]);
var state_26573__$1 = state_26573;
var statearr_26630_26688 = state_26573__$1;
(statearr_26630_26688[(2)] = inst_26541);

(statearr_26630_26688[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (42))){
var state_26573__$1 = state_26573;
var statearr_26631_26689 = state_26573__$1;
(statearr_26631_26689[(2)] = null);

(statearr_26631_26689[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (37))){
var inst_26551 = (state_26573[(2)]);
var state_26573__$1 = state_26573;
if(cljs.core.truth_(inst_26551)){
var statearr_26632_26690 = state_26573__$1;
(statearr_26632_26690[(1)] = (38));

} else {
var statearr_26633_26691 = state_26573__$1;
(statearr_26633_26691[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26574 === (8))){
var inst_26543 = (state_26573[(10)]);
var inst_26543__$1 = (state_26573[(2)]);
var state_26573__$1 = (function (){var statearr_26634 = state_26573;
(statearr_26634[(10)] = inst_26543__$1);

return statearr_26634;
})();
if(cljs.core.truth_(inst_26543__$1)){
var statearr_26635_26692 = state_26573__$1;
(statearr_26635_26692[(1)] = (32));

} else {
var statearr_26636_26693 = state_26573__$1;
(statearr_26636_26693[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__2746__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__2746__auto____0 = (function (){
var statearr_26637 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26637[(0)] = fluree$db$graphdb$subid_$_state_machine__2746__auto__);

(statearr_26637[(1)] = (1));

return statearr_26637;
});
var fluree$db$graphdb$subid_$_state_machine__2746__auto____1 = (function (state_26573){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26573);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26638){var ex__2749__auto__ = e26638;
var statearr_26639_26694 = state_26573;
(statearr_26639_26694[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26573[(4)]))){
var statearr_26640_26695 = state_26573;
(statearr_26640_26695[(1)] = cljs.core.first.call(null,(state_26573[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26696 = state_26573;
state_26573 = G__26696;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__2746__auto__ = function(state_26573){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__2746__auto____1.call(this,state_26573);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__2746__auto____0;
fluree$db$graphdb$subid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__2746__auto____1;
return fluree$db$graphdb$subid_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26641 = f__2769__auto__.call(null);
(statearr_26641[(6)] = c__2768__auto___26642);

return statearr_26641;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__26697){
var map__26698 = p__26697;
var map__26698__$1 = cljs.core.__destructure_map.call(null,map__26698);
var db = map__26698__$1;
var current_db_fn = cljs.core.get.call(null,map__26698__$1,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
var permissions = cljs.core.get.call(null,map__26698__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26714){
var state_val_26715 = (state_26714[(1)]);
if((state_val_26715 === (1))){
var state_26714__$1 = state_26714;
var statearr_26716_26730 = state_26714__$1;
(statearr_26716_26730[(2)] = null);

(statearr_26716_26730[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26715 === (2))){
var _ = (function (){var statearr_26717 = state_26714;
(statearr_26717[(4)] = cljs.core.cons.call(null,(5),(state_26714[(4)])));

return statearr_26717;
})();
var inst_26705 = current_db_fn.call(null,db);
var state_26714__$1 = state_26714;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26714__$1,(6),inst_26705);
} else {
if((state_val_26715 === (3))){
var inst_26712 = (state_26714[(2)]);
var state_26714__$1 = state_26714;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26714__$1,inst_26712);
} else {
if((state_val_26715 === (4))){
var inst_26699 = (state_26714[(2)]);
var state_26714__$1 = state_26714;
var statearr_26719_26731 = state_26714__$1;
(statearr_26719_26731[(2)] = inst_26699);

(statearr_26719_26731[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26715 === (5))){
var _ = (function (){var statearr_26720 = state_26714;
(statearr_26720[(4)] = cljs.core.rest.call(null,(state_26714[(4)])));

return statearr_26720;
})();
var state_26714__$1 = state_26714;
var ex26718 = (state_26714__$1[(2)]);
var statearr_26721_26732 = state_26714__$1;
(statearr_26721_26732[(5)] = ex26718);


if((ex26718 instanceof Error)){
var statearr_26722_26733 = state_26714__$1;
(statearr_26722_26733[(1)] = (4));

(statearr_26722_26733[(5)] = null);

} else {
throw ex26718;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26715 === (6))){
var inst_26707 = (state_26714[(2)]);
var inst_26708 = fluree.db.util.async.throw_err.call(null,inst_26707);
var inst_26709 = cljs.core.assoc.call(null,inst_26708,new cljs.core.Keyword(null,"permissions","permissions",67803075),permissions);
var _ = (function (){var statearr_26723 = state_26714;
(statearr_26723[(4)] = cljs.core.rest.call(null,(state_26714[(4)])));

return statearr_26723;
})();
var state_26714__$1 = state_26714;
var statearr_26724_26734 = state_26714__$1;
(statearr_26724_26734[(2)] = inst_26709);

(statearr_26724_26734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____0 = (function (){
var statearr_26725 = [null,null,null,null,null,null,null];
(statearr_26725[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__);

(statearr_26725[(1)] = (1));

return statearr_26725;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____1 = (function (state_26714){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26714);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26726){var ex__2749__auto__ = e26726;
var statearr_26727_26735 = state_26714;
(statearr_26727_26735[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26714[(4)]))){
var statearr_26728_26736 = state_26714;
(statearr_26728_26736[(1)] = cljs.core.first.call(null,(state_26714[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26737 = state_26714;
state_26714 = G__26737;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__ = function(state_26714){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____1.call(this,state_26714);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26729 = f__2769__auto__.call(null);
(statearr_26729[(6)] = c__2768__auto__);

return statearr_26729;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.call(null,this$,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__26738,property,collection){
var map__26739 = p__26738;
var map__26739__$1 = cljs.core.__destructure_map.call(null,map__26739);
var schema = cljs.core.get.call(null,map__26739__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"partition","partition",1174740751),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_.call(null,collection)){
return cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__26740,property,predicate){
var map__26741 = p__26740;
var map__26741__$1 = cljs.core.__destructure_map.call(null,map__26741);
var this$ = map__26741__$1;
var schema = cljs.core.get.call(null,map__26741__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__26742 = cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return fluree.db.dbproto._c_prop.call(null,this$,new cljs.core.Keyword(null,"partition","partition",1174740751),G__26742);
} else {
return G__26742;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return new cljs.core.Keyword("fluree.db.graphdb","no-pred","fluree.db.graphdb/no-pred",1182779470);
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__26744 = arguments.length;
switch (G__26744) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26776){
var state_val_26777 = (state_26776[(1)]);
if((state_val_26777 === (7))){
var state_26776__$1 = state_26776;
var statearr_26778_26872 = state_26776__$1;
(statearr_26778_26872[(2)] = null);

(statearr_26778_26872[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26777 === (1))){
var state_26776__$1 = state_26776;
var statearr_26779_26873 = state_26776__$1;
(statearr_26779_26873[(2)] = null);

(statearr_26779_26873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26777 === (4))){
var inst_26745 = (state_26776[(2)]);
var state_26776__$1 = state_26776;
var statearr_26780_26874 = state_26776__$1;
(statearr_26780_26874[(2)] = inst_26745);

(statearr_26780_26874[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26777 === (6))){
var inst_26759 = (state_26776[(7)]);
var inst_26758 = (state_26776[(2)]);
var inst_26759__$1 = fluree.db.util.async.throw_err.call(null,inst_26758);
var inst_26760 = (inst_26759__$1 == null);
var state_26776__$1 = (function (){var statearr_26781 = state_26776;
(statearr_26781[(7)] = inst_26759__$1);

return statearr_26781;
})();
if(cljs.core.truth_(inst_26760)){
var statearr_26782_26875 = state_26776__$1;
(statearr_26782_26875[(1)] = (7));

} else {
var statearr_26783_26876 = state_26776__$1;
(statearr_26783_26876[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26777 === (3))){
var inst_26774 = (state_26776[(2)]);
var state_26776__$1 = state_26776;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26776__$1,inst_26774);
} else {
if((state_val_26777 === (12))){
var inst_26771 = (state_26776[(2)]);
var _ = (function (){var statearr_26784 = state_26776;
(statearr_26784[(4)] = cljs.core.rest.call(null,(state_26776[(4)])));

return statearr_26784;
})();
var state_26776__$1 = state_26776;
var statearr_26785_26877 = state_26776__$1;
(statearr_26785_26877[(2)] = inst_26771);

(statearr_26785_26877[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26777 === (2))){
var _ = (function (){var statearr_26786 = state_26776;
(statearr_26786[(4)] = cljs.core.cons.call(null,(5),(state_26776[(4)])));

return statearr_26786;
})();
var inst_26752 = fluree.db.dbproto._rootdb.call(null,this$);
var inst_26753 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26754 = [tag_id,(30)];
var inst_26755 = (new cljs.core.PersistentVector(null,2,(5),inst_26753,inst_26754,null));
var inst_26756 = fluree.db.query.range.index_range.call(null,inst_26752,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26755);
var state_26776__$1 = state_26776;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26776__$1,(6),inst_26756);
} else {
if((state_val_26777 === (11))){
var inst_26765 = (state_26776[(8)]);
var inst_26769 = fluree.db.flake.o.call(null,inst_26765);
var state_26776__$1 = state_26776;
var statearr_26788_26878 = state_26776__$1;
(statearr_26788_26878[(2)] = inst_26769);

(statearr_26788_26878[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26777 === (9))){
var inst_26765 = (state_26776[(8)]);
var inst_26765__$1 = (state_26776[(2)]);
var inst_26766 = (inst_26765__$1 == null);
var state_26776__$1 = (function (){var statearr_26789 = state_26776;
(statearr_26789[(8)] = inst_26765__$1);

return statearr_26789;
})();
if(cljs.core.truth_(inst_26766)){
var statearr_26790_26879 = state_26776__$1;
(statearr_26790_26879[(1)] = (10));

} else {
var statearr_26791_26880 = state_26776__$1;
(statearr_26791_26880[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26777 === (5))){
var _ = (function (){var statearr_26792 = state_26776;
(statearr_26792[(4)] = cljs.core.rest.call(null,(state_26776[(4)])));

return statearr_26792;
})();
var state_26776__$1 = state_26776;
var ex26787 = (state_26776__$1[(2)]);
var statearr_26793_26881 = state_26776__$1;
(statearr_26793_26881[(5)] = ex26787);


if((ex26787 instanceof Error)){
var statearr_26794_26882 = state_26776__$1;
(statearr_26794_26882[(1)] = (4));

(statearr_26794_26882[(5)] = null);

} else {
throw ex26787;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26777 === (10))){
var state_26776__$1 = state_26776;
var statearr_26795_26883 = state_26776__$1;
(statearr_26795_26883[(2)] = null);

(statearr_26795_26883[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26777 === (8))){
var inst_26759 = (state_26776[(7)]);
var inst_26763 = cljs.core.first.call(null,inst_26759);
var state_26776__$1 = state_26776;
var statearr_26796_26884 = state_26776__$1;
(statearr_26796_26884[(2)] = inst_26763);

(statearr_26796_26884[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_26797 = [null,null,null,null,null,null,null,null,null];
(statearr_26797[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_26797[(1)] = (1));

return statearr_26797;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_26776){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26776);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26798){var ex__2749__auto__ = e26798;
var statearr_26799_26885 = state_26776;
(statearr_26799_26885[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26776[(4)]))){
var statearr_26800_26886 = state_26776;
(statearr_26800_26886[(1)] = cljs.core.first.call(null,(state_26776[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26887 = state_26776;
state_26776 = G__26887;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_26776){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_26776);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26801 = f__2769__auto__.call(null);
(statearr_26801[(6)] = c__2768__auto__);

return statearr_26801;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26837){
var state_val_26838 = (state_26837[(1)]);
if((state_val_26838 === (7))){
var inst_26811 = fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_26837__$1 = state_26837;
var statearr_26839_26888 = state_26837__$1;
(statearr_26839_26888[(2)] = inst_26811);

(statearr_26839_26888[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26838 === (1))){
var state_26837__$1 = state_26837;
var statearr_26840_26889 = state_26837__$1;
(statearr_26840_26889[(2)] = null);

(statearr_26840_26889[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26838 === (4))){
var inst_26802 = (state_26837[(2)]);
var state_26837__$1 = state_26837;
var statearr_26841_26890 = state_26837__$1;
(statearr_26841_26890[(2)] = inst_26802);

(statearr_26841_26890[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26838 === (15))){
var inst_26832 = (state_26837[(2)]);
var _ = (function (){var statearr_26842 = state_26837;
(statearr_26842[(4)] = cljs.core.rest.call(null,(state_26837[(4)])));

return statearr_26842;
})();
var state_26837__$1 = state_26837;
var statearr_26843_26891 = state_26837__$1;
(statearr_26843_26891[(2)] = inst_26832);

(statearr_26843_26891[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26838 === (13))){
var inst_26817 = (state_26837[(7)]);
var inst_26823 = clojure.string.includes_QMARK_.call(null,inst_26817,":");
var state_26837__$1 = state_26837;
if(inst_26823){
var statearr_26844_26892 = state_26837__$1;
(statearr_26844_26892[(1)] = (16));

} else {
var statearr_26845_26893 = state_26837__$1;
(statearr_26845_26893[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26838 === (6))){
var state_26837__$1 = state_26837;
var statearr_26846_26894 = state_26837__$1;
(statearr_26846_26894[(2)] = pred);

(statearr_26846_26894[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26838 === (17))){
var inst_26817 = (state_26837[(7)]);
var state_26837__$1 = state_26837;
var statearr_26847_26895 = state_26837__$1;
(statearr_26847_26895[(2)] = inst_26817);

(statearr_26847_26895[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26838 === (3))){
var inst_26835 = (state_26837[(2)]);
var state_26837__$1 = state_26837;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26837__$1,inst_26835);
} else {
if((state_val_26838 === (12))){
var inst_26821 = (state_26837[(2)]);
var state_26837__$1 = state_26837;
if(cljs.core.truth_(inst_26821)){
var statearr_26848_26896 = state_26837__$1;
(statearr_26848_26896[(1)] = (13));

} else {
var statearr_26849_26897 = state_26837__$1;
(statearr_26849_26897[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26838 === (2))){
var _ = (function (){var statearr_26850 = state_26837;
(statearr_26850[(4)] = cljs.core.cons.call(null,(5),(state_26837[(4)])));

return statearr_26850;
})();
var inst_26808 = typeof pred === 'string';
var state_26837__$1 = state_26837;
if(cljs.core.truth_(inst_26808)){
var statearr_26851_26898 = state_26837__$1;
(statearr_26851_26898[(1)] = (6));

} else {
var statearr_26852_26899 = state_26837__$1;
(statearr_26852_26899[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26838 === (11))){
var inst_26813 = (state_26837[(8)]);
var state_26837__$1 = state_26837;
var statearr_26854_26900 = state_26837__$1;
(statearr_26854_26900[(2)] = inst_26813);

(statearr_26854_26900[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26838 === (9))){
var inst_26813 = (state_26837[(8)]);
var inst_26816 = (state_26837[(2)]);
var inst_26817 = fluree.db.util.async.throw_err.call(null,inst_26816);
var state_26837__$1 = (function (){var statearr_26855 = state_26837;
(statearr_26855[(7)] = inst_26817);

return statearr_26855;
})();
if(cljs.core.truth_(inst_26813)){
var statearr_26856_26901 = state_26837__$1;
(statearr_26856_26901[(1)] = (10));

} else {
var statearr_26857_26902 = state_26837__$1;
(statearr_26857_26902[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26838 === (5))){
var _ = (function (){var statearr_26858 = state_26837;
(statearr_26858[(4)] = cljs.core.rest.call(null,(state_26837[(4)])));

return statearr_26858;
})();
var state_26837__$1 = state_26837;
var ex26853 = (state_26837__$1[(2)]);
var statearr_26859_26903 = state_26837__$1;
(statearr_26859_26903[(5)] = ex26853);


if((ex26853 instanceof Error)){
var statearr_26860_26904 = state_26837__$1;
(statearr_26860_26904[(1)] = (4));

(statearr_26860_26904[(5)] = null);

} else {
throw ex26853;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26838 === (14))){
var state_26837__$1 = state_26837;
var statearr_26861_26905 = state_26837__$1;
(statearr_26861_26905[(2)] = null);

(statearr_26861_26905[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26838 === (16))){
var inst_26817 = (state_26837[(7)]);
var inst_26825 = clojure.string.split.call(null,inst_26817,/:/);
var inst_26826 = cljs.core.second.call(null,inst_26825);
var state_26837__$1 = state_26837;
var statearr_26862_26906 = state_26837__$1;
(statearr_26862_26906[(2)] = inst_26826);

(statearr_26862_26906[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26838 === (10))){
var inst_26817 = (state_26837[(7)]);
var state_26837__$1 = state_26837;
var statearr_26863_26907 = state_26837__$1;
(statearr_26863_26907[(2)] = inst_26817);

(statearr_26863_26907[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26838 === (18))){
var inst_26829 = (state_26837[(2)]);
var state_26837__$1 = state_26837;
var statearr_26864_26908 = state_26837__$1;
(statearr_26864_26908[(2)] = inst_26829);

(statearr_26864_26908[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26838 === (8))){
var inst_26813 = (state_26837[(2)]);
var inst_26814 = fluree.db.dbproto._tag.call(null,this$,tag_id);
var state_26837__$1 = (function (){var statearr_26865 = state_26837;
(statearr_26865[(8)] = inst_26813);

return statearr_26865;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26837__$1,(9),inst_26814);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_26866 = [null,null,null,null,null,null,null,null,null];
(statearr_26866[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_26866[(1)] = (1));

return statearr_26866;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_26837){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26837);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26867){var ex__2749__auto__ = e26867;
var statearr_26868_26909 = state_26837;
(statearr_26868_26909[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26837[(4)]))){
var statearr_26869_26910 = state_26837;
(statearr_26869_26910[(1)] = cljs.core.first.call(null,(state_26837[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26911 = state_26837;
state_26837 = G__26911;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_26837){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_26837);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26870 = f__2769__auto__.call(null);
(statearr_26870[(6)] = c__2768__auto__);

return statearr_26870;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__26913 = arguments.length;
switch (G__26913) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26946){
var state_val_26947 = (state_26946[(1)]);
if((state_val_26947 === (7))){
var state_26946__$1 = state_26946;
var statearr_26948_27036 = state_26946__$1;
(statearr_26948_27036[(2)] = null);

(statearr_26948_27036[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26947 === (1))){
var state_26946__$1 = state_26946;
var statearr_26949_27037 = state_26946__$1;
(statearr_26949_27037[(2)] = null);

(statearr_26949_27037[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26947 === (4))){
var inst_26914 = (state_26946[(2)]);
var state_26946__$1 = state_26946;
var statearr_26950_27038 = state_26946__$1;
(statearr_26950_27038[(2)] = inst_26914);

(statearr_26950_27038[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26947 === (6))){
var inst_26929 = (state_26946[(7)]);
var inst_26928 = (state_26946[(2)]);
var inst_26929__$1 = fluree.db.util.async.throw_err.call(null,inst_26928);
var inst_26930 = (inst_26929__$1 == null);
var state_26946__$1 = (function (){var statearr_26951 = state_26946;
(statearr_26951[(7)] = inst_26929__$1);

return statearr_26951;
})();
if(cljs.core.truth_(inst_26930)){
var statearr_26952_27039 = state_26946__$1;
(statearr_26952_27039[(1)] = (7));

} else {
var statearr_26953_27040 = state_26946__$1;
(statearr_26953_27040[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26947 === (3))){
var inst_26944 = (state_26946[(2)]);
var state_26946__$1 = state_26946;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26946__$1,inst_26944);
} else {
if((state_val_26947 === (12))){
var inst_26941 = (state_26946[(2)]);
var _ = (function (){var statearr_26954 = state_26946;
(statearr_26954[(4)] = cljs.core.rest.call(null,(state_26946[(4)])));

return statearr_26954;
})();
var state_26946__$1 = state_26946;
var statearr_26955_27041 = state_26946__$1;
(statearr_26955_27041[(2)] = inst_26941);

(statearr_26955_27041[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26947 === (2))){
var _ = (function (){var statearr_26956 = state_26946;
(statearr_26956[(4)] = cljs.core.cons.call(null,(5),(state_26946[(4)])));

return statearr_26956;
})();
var inst_26920 = (30);
var inst_26922 = fluree.db.dbproto._rootdb.call(null,this$);
var inst_26923 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26924 = [inst_26920,tag_name];
var inst_26925 = (new cljs.core.PersistentVector(null,2,(5),inst_26923,inst_26924,null));
var inst_26926 = fluree.db.query.range.index_range.call(null,inst_26922,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_26925);
var state_26946__$1 = state_26946;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26946__$1,(6),inst_26926);
} else {
if((state_val_26947 === (11))){
var inst_26935 = (state_26946[(8)]);
var inst_26939 = fluree.db.flake.s.call(null,inst_26935);
var state_26946__$1 = state_26946;
var statearr_26958_27042 = state_26946__$1;
(statearr_26958_27042[(2)] = inst_26939);

(statearr_26958_27042[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26947 === (9))){
var inst_26935 = (state_26946[(8)]);
var inst_26935__$1 = (state_26946[(2)]);
var inst_26936 = (inst_26935__$1 == null);
var state_26946__$1 = (function (){var statearr_26959 = state_26946;
(statearr_26959[(8)] = inst_26935__$1);

return statearr_26959;
})();
if(cljs.core.truth_(inst_26936)){
var statearr_26960_27043 = state_26946__$1;
(statearr_26960_27043[(1)] = (10));

} else {
var statearr_26961_27044 = state_26946__$1;
(statearr_26961_27044[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26947 === (5))){
var _ = (function (){var statearr_26962 = state_26946;
(statearr_26962[(4)] = cljs.core.rest.call(null,(state_26946[(4)])));

return statearr_26962;
})();
var state_26946__$1 = state_26946;
var ex26957 = (state_26946__$1[(2)]);
var statearr_26963_27045 = state_26946__$1;
(statearr_26963_27045[(5)] = ex26957);


if((ex26957 instanceof Error)){
var statearr_26964_27046 = state_26946__$1;
(statearr_26964_27046[(1)] = (4));

(statearr_26964_27046[(5)] = null);

} else {
throw ex26957;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26947 === (10))){
var state_26946__$1 = state_26946;
var statearr_26965_27047 = state_26946__$1;
(statearr_26965_27047[(2)] = null);

(statearr_26965_27047[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26947 === (8))){
var inst_26929 = (state_26946[(7)]);
var inst_26933 = cljs.core.first.call(null,inst_26929);
var state_26946__$1 = state_26946;
var statearr_26966_27048 = state_26946__$1;
(statearr_26966_27048[(2)] = inst_26933);

(statearr_26966_27048[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_26967 = [null,null,null,null,null,null,null,null,null];
(statearr_26967[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_26967[(1)] = (1));

return statearr_26967;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_26946){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26946);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26968){var ex__2749__auto__ = e26968;
var statearr_26969_27049 = state_26946;
(statearr_26969_27049[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26946[(4)]))){
var statearr_26970_27050 = state_26946;
(statearr_26970_27050[(1)] = cljs.core.first.call(null,(state_26946[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27051 = state_26946;
state_26946 = G__27051;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_26946){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_26946);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26971 = f__2769__auto__.call(null);
(statearr_26971[(6)] = c__2768__auto__);

return statearr_26971;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27006){
var state_val_27007 = (state_27006[(1)]);
if((state_val_27007 === (7))){
var inst_26985 = typeof pred === 'string';
var state_27006__$1 = state_27006;
if(cljs.core.truth_(inst_26985)){
var statearr_27008_27052 = state_27006__$1;
(statearr_27008_27052[(1)] = (10));

} else {
var statearr_27009_27053 = state_27006__$1;
(statearr_27009_27053[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27007 === (1))){
var state_27006__$1 = state_27006;
var statearr_27010_27054 = state_27006__$1;
(statearr_27010_27054[(2)] = null);

(statearr_27010_27054[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27007 === (4))){
var inst_26972 = (state_27006[(2)]);
var state_27006__$1 = state_27006;
var statearr_27011_27055 = state_27006__$1;
(statearr_27011_27055[(2)] = inst_26972);

(statearr_27011_27055[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27007 === (15))){
var inst_26999 = (state_27006[(2)]);
var state_27006__$1 = state_27006;
var statearr_27012_27056 = state_27006__$1;
(statearr_27012_27056[(2)] = inst_26999);

(statearr_27012_27056[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27007 === (13))){
var inst_26990 = (state_27006[(7)]);
var inst_26992 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26990),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_26993 = fluree.db.dbproto._tag_id.call(null,this$,inst_26992);
var state_27006__$1 = state_27006;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27006__$1,(16),inst_26993);
} else {
if((state_val_27007 === (6))){
var inst_26980 = fluree.db.dbproto._tag_id.call(null,this$,tag_name);
var state_27006__$1 = state_27006;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27006__$1,(9),inst_26980);
} else {
if((state_val_27007 === (3))){
var inst_27004 = (state_27006[(2)]);
var state_27006__$1 = state_27006;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27006__$1,inst_27004);
} else {
if((state_val_27007 === (12))){
var inst_26990 = (state_27006[(7)]);
var inst_26990__$1 = (state_27006[(2)]);
var state_27006__$1 = (function (){var statearr_27013 = state_27006;
(statearr_27013[(7)] = inst_26990__$1);

return statearr_27013;
})();
if(cljs.core.truth_(inst_26990__$1)){
var statearr_27014_27057 = state_27006__$1;
(statearr_27014_27057[(1)] = (13));

} else {
var statearr_27015_27058 = state_27006__$1;
(statearr_27015_27058[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27007 === (2))){
var _ = (function (){var statearr_27016 = state_27006;
(statearr_27016[(4)] = cljs.core.cons.call(null,(5),(state_27006[(4)])));

return statearr_27016;
})();
var inst_26978 = clojure.string.includes_QMARK_.call(null,tag_name,"/");
var state_27006__$1 = state_27006;
if(inst_26978){
var statearr_27017_27059 = state_27006__$1;
(statearr_27017_27059[(1)] = (6));

} else {
var statearr_27018_27060 = state_27006__$1;
(statearr_27018_27060[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27007 === (11))){
var inst_26988 = fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_27006__$1 = state_27006;
var statearr_27020_27061 = state_27006__$1;
(statearr_27020_27061[(2)] = inst_26988);

(statearr_27020_27061[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27007 === (9))){
var inst_26982 = (state_27006[(2)]);
var inst_26983 = fluree.db.util.async.throw_err.call(null,inst_26982);
var state_27006__$1 = state_27006;
var statearr_27021_27062 = state_27006__$1;
(statearr_27021_27062[(2)] = inst_26983);

(statearr_27021_27062[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27007 === (5))){
var _ = (function (){var statearr_27022 = state_27006;
(statearr_27022[(4)] = cljs.core.rest.call(null,(state_27006[(4)])));

return statearr_27022;
})();
var state_27006__$1 = state_27006;
var ex27019 = (state_27006__$1[(2)]);
var statearr_27023_27063 = state_27006__$1;
(statearr_27023_27063[(5)] = ex27019);


if((ex27019 instanceof Error)){
var statearr_27024_27064 = state_27006__$1;
(statearr_27024_27064[(1)] = (4));

(statearr_27024_27064[(5)] = null);

} else {
throw ex27019;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27007 === (14))){
var state_27006__$1 = state_27006;
var statearr_27025_27065 = state_27006__$1;
(statearr_27025_27065[(2)] = null);

(statearr_27025_27065[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27007 === (16))){
var inst_26995 = (state_27006[(2)]);
var inst_26996 = fluree.db.util.async.throw_err.call(null,inst_26995);
var state_27006__$1 = state_27006;
var statearr_27026_27066 = state_27006__$1;
(statearr_27026_27066[(2)] = inst_26996);

(statearr_27026_27066[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27007 === (10))){
var state_27006__$1 = state_27006;
var statearr_27027_27067 = state_27006__$1;
(statearr_27027_27067[(2)] = pred);

(statearr_27027_27067[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27007 === (8))){
var inst_27001 = (state_27006[(2)]);
var _ = (function (){var statearr_27028 = state_27006;
(statearr_27028[(4)] = cljs.core.rest.call(null,(state_27006[(4)])));

return statearr_27028;
})();
var state_27006__$1 = state_27006;
var statearr_27029_27068 = state_27006__$1;
(statearr_27029_27068[(2)] = inst_27001);

(statearr_27029_27068[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_27030 = [null,null,null,null,null,null,null,null];
(statearr_27030[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_27030[(1)] = (1));

return statearr_27030;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_27006){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27006);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27031){var ex__2749__auto__ = e27031;
var statearr_27032_27069 = state_27006;
(statearr_27032_27069[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27006[(4)]))){
var statearr_27033_27070 = state_27006;
(statearr_27033_27070[(1)] = cljs.core.first.call(null,(state_27006[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27071 = state_27006;
state_27006 = G__27071;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_27006){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_27006);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27034 = f__2769__auto__.call(null);
(statearr_27034[(6)] = c__2768__auto__);

return statearr_27034;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.ledger_id = ledger_id;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.tspo = tspo;
this.schema = schema;
this.settings = settings;
this.comparators = comparators;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k27073,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__27077 = k27073;
var G__27077__$1 = (((G__27077 instanceof cljs.core.Keyword))?G__27077.fqn:null);
switch (G__27077__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "ledger-id":
return self__.ledger_id;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "tspo":
return self__.tspo;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "comparators":
return self__.comparators;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k27073,else__5346__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5366__auto__,p__27078){
var vec__27079 = p__27078;
var k__5367__auto__ = cljs.core.nth.call(null,vec__27079,(0),null);
var v__5368__auto__ = cljs.core.nth.call(null,vec__27079,(1),null);
return f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__);
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__5360__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tspo","tspo",-440144953),self__.tspo],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"comparators","comparators",-1325611955),self__.comparators],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27072){
var self__ = this;
var G__27072__$1 = this;
return (new cljs.core.RecordIter((0),G__27072__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"comparators","comparators",-1325611955),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (21 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll.call(null,coll__5340__auto__));
}).call(null,this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27074,other27075){
var self__ = this;
var this27074__$1 = this;
return (((!((other27075 == null)))) && ((((this27074__$1.constructor === other27075.constructor)) && (((cljs.core._EQ_.call(null,this27074__$1.conn,other27075.conn)) && (((cljs.core._EQ_.call(null,this27074__$1.network,other27075.network)) && (((cljs.core._EQ_.call(null,this27074__$1.ledger_id,other27075.ledger_id)) && (((cljs.core._EQ_.call(null,this27074__$1.block,other27075.block)) && (((cljs.core._EQ_.call(null,this27074__$1.t,other27075.t)) && (((cljs.core._EQ_.call(null,this27074__$1.tt_id,other27075.tt_id)) && (((cljs.core._EQ_.call(null,this27074__$1.stats,other27075.stats)) && (((cljs.core._EQ_.call(null,this27074__$1.spot,other27075.spot)) && (((cljs.core._EQ_.call(null,this27074__$1.psot,other27075.psot)) && (((cljs.core._EQ_.call(null,this27074__$1.post,other27075.post)) && (((cljs.core._EQ_.call(null,this27074__$1.opst,other27075.opst)) && (((cljs.core._EQ_.call(null,this27074__$1.tspo,other27075.tspo)) && (((cljs.core._EQ_.call(null,this27074__$1.schema,other27075.schema)) && (((cljs.core._EQ_.call(null,this27074__$1.settings,other27075.settings)) && (((cljs.core._EQ_.call(null,this27074__$1.comparators,other27075.comparators)) && (((cljs.core._EQ_.call(null,this27074__$1.schema_cache,other27075.schema_cache)) && (((cljs.core._EQ_.call(null,this27074__$1.novelty,other27075.novelty)) && (((cljs.core._EQ_.call(null,this27074__$1.permissions,other27075.permissions)) && (((cljs.core._EQ_.call(null,this27074__$1.fork,other27075.fork)) && (((cljs.core._EQ_.call(null,this27074__$1.fork_block,other27075.fork_block)) && (((cljs.core._EQ_.call(null,this27074__$1.current_db_fn,other27075.current_db_fn)) && (cljs.core._EQ_.call(null,this27074__$1.__extmap,other27075.__extmap)))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),null,new cljs.core.Keyword(null,"tspo","tspo",-440144953),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"comparators","comparators",-1325611955),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k27073){
var self__ = this;
var this__5350__auto____$1 = this;
var G__27082 = k27073;
var G__27082__$1 = (((G__27082 instanceof cljs.core.Keyword))?G__27082.fqn:null);
switch (G__27082__$1) {
case "conn":
case "network":
case "ledger-id":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "tspo":
case "schema":
case "settings":
case "comparators":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k27073);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__27072){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__27083 = cljs.core.keyword_identical_QMARK_;
var expr__27084 = k__5352__auto__;
if(cljs.core.truth_(pred__27083.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__27084))){
return (new fluree.db.graphdb.GraphDb(G__27072,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27083.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__27084))){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__27072,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27083.call(null,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),expr__27084))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__27072,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27083.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__27084))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,G__27072,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27083.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__27084))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,G__27072,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27083.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__27084))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,G__27072,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27083.call(null,new cljs.core.Keyword(null,"stats","stats",-85643011),expr__27084))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,G__27072,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27083.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),expr__27084))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,G__27072,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27083.call(null,new cljs.core.Keyword(null,"psot","psot",2111653059),expr__27084))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__27072,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27083.call(null,new cljs.core.Keyword(null,"post","post",269697687),expr__27084))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__27072,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27083.call(null,new cljs.core.Keyword(null,"opst","opst",1213963058),expr__27084))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__27072,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27083.call(null,new cljs.core.Keyword(null,"tspo","tspo",-440144953),expr__27084))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__27072,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27083.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__27084))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,G__27072,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27083.call(null,new cljs.core.Keyword(null,"settings","settings",1556144875),expr__27084))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,G__27072,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27083.call(null,new cljs.core.Keyword(null,"comparators","comparators",-1325611955),expr__27084))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,G__27072,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27083.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__27084))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,G__27072,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27083.call(null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),expr__27084))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,G__27072,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27083.call(null,new cljs.core.Keyword(null,"permissions","permissions",67803075),expr__27084))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,G__27072,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27083.call(null,new cljs.core.Keyword(null,"fork","fork",1062974235),expr__27084))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,G__27072,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27083.call(null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),expr__27084))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__27072,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27083.call(null,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),expr__27084))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__27072,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5352__auto__,G__27072),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tspo","tspo",-440144953),self__.tspo,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"comparators","comparators",-1325611955),self__.comparators,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__27072){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__27072,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5349__auto__,(0)),cljs.core._nth.call(null,entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db.call(null,this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx.call(null,this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop.call(null,this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop.call(null,this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.call(null,this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db.call(null,this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query.call(null,this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.call(null,this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.call(null,this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.call(null,this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.call(null,this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"ledger-id","ledger-id",-949008754,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"tspo","tspo",1200386574,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"comparators","comparators",314919572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write.call(null,writer__5390__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__27076){
var extmap__5385__auto__ = (function (){var G__27086 = cljs.core.dissoc.call(null,G__27076,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"comparators","comparators",-1325611955),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
if(cljs.core.record_QMARK_.call(null,G__27076)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__27086);
} else {
return G__27086;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27076),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27076),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(G__27076),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__27076),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__27076),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__27076),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__27076),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__27076),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__27076),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__27076),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__27076),new cljs.core.Keyword(null,"tspo","tspo",-440144953).cljs$core$IFn$_invoke$arity$1(G__27076),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__27076),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__27076),new cljs.core.Keyword(null,"comparators","comparators",-1325611955).cljs$core$IFn$_invoke$arity$1(G__27076),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27076),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__27076),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__27076),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__27076),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__27076),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__27076),null,cljs.core.not_empty.call(null,extmap__5385__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write.call(null,w,"#FlureeGraphDB ");

return cljs.core._write.call(null,w,cljs.core.pr.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),db__$1.ledger_id,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(comparators){
return cljs.core.reduce.call(null,(function (m,idx){
return cljs.core.assoc.call(null,m,idx,clojure.data.avl.sorted_set_by.call(null,cljs.core.get.call(null,comparators,idx)));
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),fluree.db.index.types);
});
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,ledger_id,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(ledger_id)){
} else {
throw (new Error(["Assert failed: ","No ledger-id provided when creating new db.","\n","ledger-id"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map.call(null,fluree.db.index.default_comparators);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var map__27089 = fluree.db.index.default_comparators;
var map__27089__$1 = cljs.core.__destructure_map.call(null,map__27089);
var spot_cmp = cljs.core.get.call(null,map__27089__$1,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot_cmp = cljs.core.get.call(null,map__27089__$1,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post_cmp = cljs.core.get.call(null,map__27089__$1,new cljs.core.Keyword(null,"post","post",269697687));
var opst_cmp = cljs.core.get.call(null,map__27089__$1,new cljs.core.Keyword(null,"opst","opst",1213963058));
var tspo_cmp = cljs.core.get.call(null,map__27089__$1,new cljs.core.Keyword(null,"tspo","tspo",-440144953));
var spot = fluree.db.index.empty_branch.call(null,network,ledger_id,spot_cmp);
var psot = fluree.db.index.empty_branch.call(null,network,ledger_id,psot_cmp);
var post = fluree.db.index.empty_branch.call(null,network,ledger_id,post_cmp);
var opst = fluree.db.index.empty_branch.call(null,network,ledger_id,opst_cmp);
var tspo = fluree.db.index.empty_branch.call(null,network,ledger_id,tspo_cmp);
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb.call(null,conn,network,ledger_id,(0),(-1),null,stats,spot,psot,post,opst,tspo,schema,settings,fluree.db.index.default_comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
