// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.query.analytical_parse');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"\"")) && (cljs.core._EQ_.call(null,cljs.core.last.call(null,cljs.core.name.call(null,form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.call(null,string);
}catch (e20035){var e = e20035;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some.call(null,(function (p1__20036_SHARP_){
var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,p1__20036_SHARP_);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.coll_QMARK_.call(null,p1__20036_SHARP_)){
return fluree.db.query.analytical.get_vars.call(null,p1__20036_SHARP_);
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv.call(null,(function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_.call(null,key);
var static_value = cljs.core.get.call(null,interm_vars,key_as_var);
if(((cljs.core._EQ_.call(null,idx,(1))) && (((cljs.core.not.call(null,key_as_var)) && (((cljs.core.not_EQ_.call(null,"_id",key)) && (cljs.core.not.call(null,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find.call(null,/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.call(null,["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20037_SHARP_){
return cljs.core.conj.call(null,p1__20037_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20038_SHARP_){
return cljs.core.conj.call(null,p1__20038_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.call(null,idx,(2));
if(and__5043__auto__){
return fluree.db.query.analytical_parse.query_fn_QMARK_.call(null,key);
} else {
return and__5043__auto__;
}
})())){
var filter_code = cljs.reader.read_string.call(null,cljs.core.subs.call(null,key,(1)));
var var$ = (function (){var or__5045__auto__ = fluree.db.query.analytical.get_vars.call(null,filter_code);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__20043 = fluree.db.query.analytical_filter.extract_filter_fn.call(null,filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.call(null,vec__20043,(0),null);
var _ = cljs.core.nth.call(null,vec__20043,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn.call(null,var$,fun);
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20039_SHARP_){
return cljs.core.conj.call(null,p1__20039_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.call(null,idx,(1));
if(and__5043__auto__){
return cljs.core.re_find.call(null,/\+/,key);
} else {
return and__5043__auto__;
}
})())){
var vec__20046 = clojure.string.split.call(null,key,/\+/);
var pred = cljs.core.nth.call(null,vec__20046,(0),null);
var recur_amt = cljs.core.nth.call(null,vec__20046,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__5045__auto__ = fluree.db.query.analytical.safe_read_string.call(null,recur_amt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20040_SHARP_){
return cljs.core.conj.call(null,p1__20040_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_.call(null,key)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20041_SHARP_){
return cljs.core.conj.call(null,p1__20041_SHARP_,fluree.db.query.analytical.safe_read_string.call(null,key));
}));
} else {
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20042_SHARP_){
return cljs.core.conj.call(null,p1__20042_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
/**
 * Returns an updated list of tuples that only contains tuple indexes from idx.
 *   e.g.:
 *   idx is a list of indexes, eg. [2 0 4]
 *   Thus, the return will be 3-tuples of nth 2, 0, 4 respectively.
 */
fluree.db.query.analytical.transform_tuples_to_idxs = (function fluree$db$query$analytical$transform_tuples_to_idxs(idxs,tuples){
return cljs.core.map.call(null,(function (tuple){
return cljs.core.map.call(null,(function (p1__20049_SHARP_){
return cljs.core.nth.call(null,tuple,p1__20049_SHARP_);
}),idxs);
}),tuples);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.call(null,(function (acc,var$){
var temp__5802__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var$);
if(cljs.core.truth_(temp__5802__auto__)){
var var$__$1 = temp__5802__auto__;
return cljs.core.conj.call(null,acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys.call(null,clause);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(rel_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(a_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
/**
 * Returns index positions of vars within headers.
 *   e.g. if vars were:
 *   ['?e '?name]
 *   and headers were:
 *   ['?email '?name '?x '?e]
 *   The return value would be: [3 1]
 */
fluree.db.query.analytical.get_tuple_indexes = (function fluree$db$query$analytical$get_tuple_indexes(vars,headers){
return cljs.core.reduce.call(null,(function (acc,var_smt){
var temp__5802__auto__ = (function (){var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var_smt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var var$ = temp__5802__auto__;
return cljs.core.conj.call(null,acc,fluree.db.util.core.index_of.call(null,headers,var$));
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. ","Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var idxs = fluree.db.query.analytical.get_tuple_indexes.call(null,vars,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
return fluree.db.query.analytical.transform_tuples_to_idxs.call(null,idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (add_amount > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fuel;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.volatile_QMARK_.call(null,fuel);
} else {
return and__5043__auto__;
}
})())){
return cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.call(null,(function (clause){
return cljs.core.mapv.call(null,(function (clause_item){
var temp__5802__auto__ = intersecting_vars.call(null,cljs.core.symbol.call(null,clause_item));
if(cljs.core.truth_(temp__5802__auto__)){
var key_replace = temp__5802__auto__;
var replacement = cljs.core.get.call(null,vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.call(null,replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__20052,optional_QMARK_,fuel,max_fuel){
var map__20053 = p__20052;
var map__20053__$1 = cljs.core.__destructure_map.call(null,map__20053);
var res = map__20053__$1;
var vars = cljs.core.get.call(null,map__20053__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20119){
var state_val_20120 = (state_20119[(1)]);
if((state_val_20120 === (7))){
var inst_20108 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20109 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses.call(null,r);
var inst_20110 = cljs.core.conj.call(null,inst_20109,clause);
var inst_20111 = [null,inst_20110];
var inst_20112 = (new cljs.core.PersistentVector(null,2,(5),inst_20108,inst_20111,null));
var state_20119__$1 = state_20119;
var statearr_20121_20149 = state_20119__$1;
(statearr_20121_20149[(2)] = inst_20112);

(statearr_20121_20149[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20120 === (1))){
var state_20119__$1 = state_20119;
var statearr_20122_20150 = state_20119__$1;
(statearr_20122_20150[(2)] = null);

(statearr_20122_20150[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20120 === (4))){
var inst_20054 = (state_20119[(2)]);
var state_20119__$1 = state_20119;
var statearr_20123_20151 = state_20119__$1;
(statearr_20123_20151[(2)] = inst_20054);

(statearr_20123_20151[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20120 === (15))){
var inst_20097 = (state_20119[(2)]);
var inst_20098 = fluree.db.util.async.throw_err.call(null,inst_20097);
var inst_20099 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_20098);
var inst_20100 = cljs.core.count.call(null,inst_20099);
var inst_20101 = fluree.db.query.analytical.add_fuel.call(null,inst_20100,fuel,max_fuel);
var inst_20102 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20103 = [inst_20098,r];
var inst_20104 = (new cljs.core.PersistentVector(null,2,(5),inst_20102,inst_20103,null));
var state_20119__$1 = (function (){var statearr_20124 = state_20119;
(statearr_20124[(7)] = inst_20101);

return statearr_20124;
})();
var statearr_20125_20152 = state_20119__$1;
(statearr_20125_20152[(2)] = inst_20104);

(statearr_20125_20152[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20120 === (13))){
var inst_20063 = (state_20119[(8)]);
var inst_20076 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_20077 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses.call(null,inst_20076);
var inst_20078 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_20063);
var inst_20079 = cljs.core.apply.call(null,cljs.core.concat,inst_20078);
var inst_20080 = cljs.core.set.call(null,inst_20079);
var inst_20081 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_20077);
var inst_20082 = cljs.core.apply.call(null,cljs.core.concat,inst_20081);
var inst_20083 = cljs.core.into.call(null,inst_20080,inst_20082);
var inst_20084 = (function (){var all_wd = inst_20063;
var optional = inst_20077;
var all_wd_vars = inst_20080;
var all_vars = inst_20083;
return (function (p1__20050_SHARP_){
return all_vars.call(null,p1__20050_SHARP_);
});
})();
var inst_20085 = cljs.core.keys.call(null,vars);
var inst_20086 = cljs.core.map.call(null,inst_20084,inst_20085);
var inst_20087 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_20086);
var inst_20088 = cljs.core.set.call(null,inst_20087);
var inst_20089 = (function (){var all_wd = inst_20063;
var optional = inst_20077;
var all_wd_vars = inst_20080;
var all_vars = inst_20083;
var intersecting_vars = inst_20088;
return (function (p1__20051_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,p1__20051_SHARP_);
});
})();
var inst_20090 = cljs.core.map.call(null,inst_20089,inst_20063);
var inst_20091 = cljs.core.apply.call(null,cljs.core.concat,inst_20090);
var inst_20092 = fluree.db.query.analytical.select_from_tuples.call(null,inst_20091,res);
var inst_20093 = fluree.db.query.analytical.replace_vars_wikidata.call(null,inst_20063,inst_20088,vars);
var inst_20094 = cljs.core.remove.call(null,inst_20088,inst_20083);
var inst_20095 = fluree.db.query.analytical_wikidata.get_wikidata_tuples.call(null,q_map,inst_20093,inst_20091,inst_20092,inst_20094,inst_20077);
var state_20119__$1 = state_20119;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20119__$1,(15),inst_20095);
} else {
if((state_val_20120 === (6))){
var inst_20064 = (state_20119[(9)]);
var inst_20062 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_20063 = fluree.db.query.analytical_wikidata.get_all_wd_clauses.call(null,inst_20062);
var inst_20064__$1 = optional_QMARK_;
var state_20119__$1 = (function (){var statearr_20126 = state_20119;
(statearr_20126[(8)] = inst_20063);

(statearr_20126[(9)] = inst_20064__$1);

return statearr_20126;
})();
if(cljs.core.truth_(inst_20064__$1)){
var statearr_20127_20153 = state_20119__$1;
(statearr_20127_20153[(1)] = (9));

} else {
var statearr_20128_20154 = state_20119__$1;
(statearr_20128_20154[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20120 === (3))){
var inst_20117 = (state_20119[(2)]);
var state_20119__$1 = state_20119;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20119__$1,inst_20117);
} else {
if((state_val_20120 === (12))){
var inst_20072 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20073 = [null,r];
var inst_20074 = (new cljs.core.PersistentVector(null,2,(5),inst_20072,inst_20073,null));
var state_20119__$1 = state_20119;
var statearr_20129_20155 = state_20119__$1;
(statearr_20129_20155[(2)] = inst_20074);

(statearr_20129_20155[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20120 === (2))){
var _ = (function (){var statearr_20130 = state_20119;
(statearr_20130[(4)] = cljs.core.cons.call(null,(5),(state_20119[(4)])));

return statearr_20130;
})();
var inst_20060 = (r == null);
var state_20119__$1 = state_20119;
if(cljs.core.truth_(inst_20060)){
var statearr_20131_20156 = state_20119__$1;
(statearr_20131_20156[(1)] = (6));

} else {
var statearr_20132_20157 = state_20119__$1;
(statearr_20132_20157[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20120 === (11))){
var inst_20070 = (state_20119[(2)]);
var state_20119__$1 = state_20119;
if(cljs.core.truth_(inst_20070)){
var statearr_20134_20158 = state_20119__$1;
(statearr_20134_20158[(1)] = (12));

} else {
var statearr_20135_20159 = state_20119__$1;
(statearr_20135_20159[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20120 === (9))){
var inst_20063 = (state_20119[(8)]);
var inst_20066 = cljs.core.empty_QMARK_.call(null,inst_20063);
var inst_20067 = (!(inst_20066));
var state_20119__$1 = state_20119;
var statearr_20136_20160 = state_20119__$1;
(statearr_20136_20160[(2)] = inst_20067);

(statearr_20136_20160[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20120 === (5))){
var _ = (function (){var statearr_20137 = state_20119;
(statearr_20137[(4)] = cljs.core.rest.call(null,(state_20119[(4)])));

return statearr_20137;
})();
var state_20119__$1 = state_20119;
var ex20133 = (state_20119__$1[(2)]);
var statearr_20138_20161 = state_20119__$1;
(statearr_20138_20161[(5)] = ex20133);


if((ex20133 instanceof Error)){
var statearr_20139_20162 = state_20119__$1;
(statearr_20139_20162[(1)] = (4));

(statearr_20139_20162[(5)] = null);

} else {
throw ex20133;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20120 === (14))){
var inst_20106 = (state_20119[(2)]);
var state_20119__$1 = state_20119;
var statearr_20140_20163 = state_20119__$1;
(statearr_20140_20163[(2)] = inst_20106);

(statearr_20140_20163[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20120 === (10))){
var inst_20064 = (state_20119[(9)]);
var state_20119__$1 = state_20119;
var statearr_20141_20164 = state_20119__$1;
(statearr_20141_20164[(2)] = inst_20064);

(statearr_20141_20164[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20120 === (8))){
var inst_20114 = (state_20119[(2)]);
var _ = (function (){var statearr_20142 = state_20119;
(statearr_20142[(4)] = cljs.core.rest.call(null,(state_20119[(4)])));

return statearr_20142;
})();
var state_20119__$1 = state_20119;
var statearr_20143_20165 = state_20119__$1;
(statearr_20143_20165[(2)] = inst_20114);

(statearr_20143_20165[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_20144 = [null,null,null,null,null,null,null,null,null,null];
(statearr_20144[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__);

(statearr_20144[(1)] = (1));

return statearr_20144;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____1 = (function (state_20119){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20119);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20145){var ex__2749__auto__ = e20145;
var statearr_20146_20166 = state_20119;
(statearr_20146_20166[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20119[(4)]))){
var statearr_20147_20167 = state_20119;
(statearr_20147_20167[(1)] = cljs.core.first.call(null,(state_20119[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20168 = state_20119;
state_20119 = G__20168;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__ = function(state_20119){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____1.call(this,state_20119);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20148 = f__2769__auto__.call(null);
(statearr_20148[(6)] = c__2768__auto__);

return statearr_20148;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string.call(null,block);
if(cljs.core.int_QMARK_.call(null,block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(ledger_id){
return cljs.core.re_find.call(null,/[a-z]+/,ledger_id);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(ledger_id){
return cljs.core.re_find.call(null,/[A-Z0-9]+/,ledger_id);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__20170 = arguments.length;
switch (G__20170) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.call(null,db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20264){
var state_val_20265 = (state_20264[(1)]);
if((state_val_20265 === (7))){
var inst_20177 = (state_20264[(7)]);
var inst_20187 = clojure.string.starts_with_QMARK_.call(null,inst_20177,"$fdb");
var state_20264__$1 = state_20264;
if(inst_20187){
var statearr_20266_20315 = state_20264__$1;
(statearr_20266_20315[(1)] = (9));

} else {
var statearr_20267_20316 = state_20264__$1;
(statearr_20267_20316[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20265 === (20))){
var state_20264__$1 = state_20264;
var statearr_20268_20317 = state_20264__$1;
(statearr_20268_20317[(2)] = null);

(statearr_20268_20317[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20265 === (27))){
var inst_20227 = (state_20264[(8)]);
var state_20264__$1 = state_20264;
var statearr_20269_20318 = state_20264__$1;
(statearr_20269_20318[(2)] = inst_20227);

(statearr_20269_20318[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20265 === (1))){
var state_20264__$1 = state_20264;
var statearr_20270_20319 = state_20264__$1;
(statearr_20270_20319[(2)] = null);

(statearr_20270_20319[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20265 === (24))){
var inst_20250 = (state_20264[(2)]);
var state_20264__$1 = state_20264;
var statearr_20271_20320 = state_20264__$1;
(statearr_20271_20320[(2)] = inst_20250);

(statearr_20271_20320[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20265 === (4))){
var inst_20171 = (state_20264[(2)]);
var state_20264__$1 = state_20264;
var statearr_20272_20321 = state_20264__$1;
(statearr_20272_20321[(2)] = inst_20171);

(statearr_20272_20321[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20265 === (15))){
var inst_20194 = (state_20264[(9)]);
var inst_20200 = (state_20264[(2)]);
var inst_20201 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20202 = cljs.core.PersistentVector.EMPTY;
var inst_20203 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_20204 = cljs.core.into.call(null,inst_20202,inst_20203);
var inst_20205 = [inst_20194,inst_20204];
var inst_20206 = (new cljs.core.PersistentVector(null,2,(5),inst_20201,inst_20205,null));
var state_20264__$1 = (function (){var statearr_20273 = state_20264;
(statearr_20273[(10)] = inst_20200);

return statearr_20273;
})();
var statearr_20274_20322 = state_20264__$1;
(statearr_20274_20322[(2)] = inst_20206);

(statearr_20274_20322[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20265 === (21))){
var inst_20253 = (state_20264[(2)]);
var state_20264__$1 = state_20264;
var statearr_20275_20323 = state_20264__$1;
(statearr_20275_20323[(2)] = inst_20253);

(statearr_20275_20323[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20265 === (13))){
var inst_20194 = (state_20264[(9)]);
var inst_20197 = (function(){throw inst_20194})();
var state_20264__$1 = state_20264;
var statearr_20276_20324 = state_20264__$1;
(statearr_20276_20324[(2)] = inst_20197);

(statearr_20276_20324[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20265 === (22))){
var inst_20216 = (state_20264[(11)]);
var inst_20218 = (state_20264[(12)]);
var inst_20220 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_20216);
var inst_20221 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20222 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_20218];
var inst_20223 = (new cljs.core.PersistentVector(null,2,(5),inst_20221,inst_20222,null));
var inst_20224 = cljs.core.get_in.call(null,opts,inst_20223);
var state_20264__$1 = (function (){var statearr_20277 = state_20264;
(statearr_20277[(13)] = inst_20220);

return statearr_20277;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20264__$1,(25),inst_20224);
} else {
if((state_val_20265 === (29))){
var inst_20231 = (state_20264[(2)]);
var inst_20232 = fluree.db.util.async.throw_err.call(null,inst_20231);
var state_20264__$1 = state_20264;
var statearr_20278_20325 = state_20264__$1;
(statearr_20278_20325[(2)] = inst_20232);

(statearr_20278_20325[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20265 === (6))){
var inst_20180 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20181 = cljs.core.PersistentVector.EMPTY;
var inst_20182 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_20183 = cljs.core.into.call(null,inst_20181,inst_20182);
var inst_20184 = [db,inst_20183];
var inst_20185 = (new cljs.core.PersistentVector(null,2,(5),inst_20180,inst_20184,null));
var state_20264__$1 = state_20264;
var statearr_20279_20326 = state_20264__$1;
(statearr_20279_20326[(2)] = inst_20185);

(statearr_20279_20326[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20265 === (28))){
var inst_20235 = (state_20264[(2)]);
var inst_20236 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20237 = cljs.core.PersistentVector.EMPTY;
var inst_20238 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_20239 = cljs.core.into.call(null,inst_20237,inst_20238);
var inst_20240 = [inst_20235,inst_20239];
var inst_20241 = (new cljs.core.PersistentVector(null,2,(5),inst_20236,inst_20240,null));
var state_20264__$1 = state_20264;
var statearr_20280_20327 = state_20264__$1;
(statearr_20280_20327[(2)] = inst_20241);

(statearr_20280_20327[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20265 === (25))){
var inst_20220 = (state_20264[(13)]);
var inst_20226 = (state_20264[(2)]);
var inst_20227 = fluree.db.util.async.throw_err.call(null,inst_20226);
var state_20264__$1 = (function (){var statearr_20281 = state_20264;
(statearr_20281[(8)] = inst_20227);

return statearr_20281;
})();
if(cljs.core.truth_(inst_20220)){
var statearr_20282_20328 = state_20264__$1;
(statearr_20282_20328[(1)] = (26));

} else {
var statearr_20283_20329 = state_20264__$1;
(statearr_20283_20329[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20265 === (17))){
var state_20264__$1 = state_20264;
var statearr_20284_20330 = state_20264__$1;
(statearr_20284_20330[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20265 === (3))){
var inst_20262 = (state_20264[(2)]);
var state_20264__$1 = state_20264;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20264__$1,inst_20262);
} else {
if((state_val_20265 === (12))){
var inst_20194 = (state_20264[(9)]);
var inst_20193 = (state_20264[(2)]);
var inst_20194__$1 = fluree.db.util.async.throw_err.call(null,inst_20193);
var inst_20195 = fluree.db.util.core.exception_QMARK_.call(null,inst_20194__$1);
var state_20264__$1 = (function (){var statearr_20286 = state_20264;
(statearr_20286[(9)] = inst_20194__$1);

return statearr_20286;
})();
if(inst_20195){
var statearr_20287_20331 = state_20264__$1;
(statearr_20287_20331[(1)] = (13));

} else {
var statearr_20288_20332 = state_20264__$1;
(statearr_20288_20332[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20265 === (2))){
var inst_20177 = (state_20264[(7)]);
var _ = (function (){var statearr_20289 = state_20264;
(statearr_20289[(4)] = cljs.core.cons.call(null,(5),(state_20264[(4)])));

return statearr_20289;
})();
var inst_20177__$1 = cljs.core.first.call(null,clause);
var inst_20178 = cljs.core._EQ_.call(null,"$fdb",inst_20177__$1);
var state_20264__$1 = (function (){var statearr_20290 = state_20264;
(statearr_20290[(7)] = inst_20177__$1);

return statearr_20290;
})();
if(inst_20178){
var statearr_20291_20333 = state_20264__$1;
(statearr_20291_20333[(1)] = (6));

} else {
var statearr_20292_20334 = state_20264__$1;
(statearr_20292_20334[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20265 === (23))){
var inst_20177 = (state_20264[(7)]);
var inst_20243 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20177)," is not supported in Fluree"].join('');
var inst_20244 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20245 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20246 = cljs.core.PersistentHashMap.fromArrays(inst_20244,inst_20245);
var inst_20247 = cljs.core.ex_info.call(null,inst_20243,inst_20246);
var inst_20248 = (function(){throw inst_20247})();
var state_20264__$1 = state_20264;
var statearr_20293_20335 = state_20264__$1;
(statearr_20293_20335[(2)] = inst_20248);

(statearr_20293_20335[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20265 === (19))){
var inst_20218 = (state_20264[(12)]);
var inst_20177 = (state_20264[(7)]);
var inst_20215 = fluree.db.query.analytical.isolate_source_name.call(null,inst_20177);
var inst_20216 = fluree.db.query.analytical.isolate_source_block.call(null,inst_20177);
var inst_20217 = cljs.core.keyword.call(null,inst_20215);
var inst_20218__$1 = cljs.core.get.call(null,prefixes,inst_20217);
var state_20264__$1 = (function (){var statearr_20294 = state_20264;
(statearr_20294[(11)] = inst_20216);

(statearr_20294[(12)] = inst_20218__$1);

return statearr_20294;
})();
if(cljs.core.truth_(inst_20218__$1)){
var statearr_20295_20336 = state_20264__$1;
(statearr_20295_20336[(1)] = (22));

} else {
var statearr_20296_20337 = state_20264__$1;
(statearr_20296_20337[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20265 === (11))){
var inst_20257 = (state_20264[(2)]);
var state_20264__$1 = state_20264;
var statearr_20298_20338 = state_20264__$1;
(statearr_20298_20338[(2)] = inst_20257);

(statearr_20298_20338[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20265 === (9))){
var inst_20177 = (state_20264[(7)]);
var inst_20189 = cljs.core.subs.call(null,inst_20177,(4));
var inst_20190 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_20189);
var inst_20191 = fluree.db.time_travel.as_of_block.call(null,db,inst_20190);
var state_20264__$1 = state_20264;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20264__$1,(12),inst_20191);
} else {
if((state_val_20265 === (5))){
var _ = (function (){var statearr_20299 = state_20264;
(statearr_20299[(4)] = cljs.core.rest.call(null,(state_20264[(4)])));

return statearr_20299;
})();
var state_20264__$1 = state_20264;
var ex20297 = (state_20264__$1[(2)]);
var statearr_20300_20339 = state_20264__$1;
(statearr_20300_20339[(5)] = ex20297);


if((ex20297 instanceof Error)){
var statearr_20301_20340 = state_20264__$1;
(statearr_20301_20340[(1)] = (4));

(statearr_20301_20340[(5)] = null);

} else {
throw ex20297;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20265 === (14))){
var state_20264__$1 = state_20264;
var statearr_20302_20341 = state_20264__$1;
(statearr_20302_20341[(2)] = null);

(statearr_20302_20341[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20265 === (26))){
var inst_20220 = (state_20264[(13)]);
var inst_20227 = (state_20264[(8)]);
var inst_20229 = fluree.db.time_travel.as_of_block.call(null,inst_20227,inst_20220);
var state_20264__$1 = state_20264;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20264__$1,(29),inst_20229);
} else {
if((state_val_20265 === (16))){
var inst_20210 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20211 = ["$wd",clause];
var inst_20212 = (new cljs.core.PersistentVector(null,2,(5),inst_20210,inst_20211,null));
var state_20264__$1 = state_20264;
var statearr_20303_20342 = state_20264__$1;
(statearr_20303_20342[(2)] = inst_20212);

(statearr_20303_20342[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20265 === (10))){
var inst_20177 = (state_20264[(7)]);
var inst_20208 = cljs.core._EQ_.call(null,"$wd",inst_20177);
var state_20264__$1 = state_20264;
if(inst_20208){
var statearr_20304_20343 = state_20264__$1;
(statearr_20304_20343[(1)] = (16));

} else {
var statearr_20305_20344 = state_20264__$1;
(statearr_20305_20344[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20265 === (18))){
var inst_20255 = (state_20264[(2)]);
var state_20264__$1 = state_20264;
var statearr_20306_20345 = state_20264__$1;
(statearr_20306_20345[(2)] = inst_20255);

(statearr_20306_20345[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20265 === (8))){
var inst_20259 = (state_20264[(2)]);
var _ = (function (){var statearr_20307 = state_20264;
(statearr_20307[(4)] = cljs.core.rest.call(null,(state_20264[(4)])));

return statearr_20307;
})();
var state_20264__$1 = state_20264;
var statearr_20308_20346 = state_20264__$1;
(statearr_20308_20346[(2)] = inst_20259);

(statearr_20308_20346[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2746__auto__ = null;
var fluree$db$query$analytical$state_machine__2746__auto____0 = (function (){
var statearr_20309 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20309[(0)] = fluree$db$query$analytical$state_machine__2746__auto__);

(statearr_20309[(1)] = (1));

return statearr_20309;
});
var fluree$db$query$analytical$state_machine__2746__auto____1 = (function (state_20264){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20264);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20310){var ex__2749__auto__ = e20310;
var statearr_20311_20347 = state_20264;
(statearr_20311_20347[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20264[(4)]))){
var statearr_20312_20348 = state_20264;
(statearr_20312_20348[(1)] = cljs.core.first.call(null,(state_20264[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20349 = state_20264;
state_20264 = G__20349;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2746__auto__ = function(state_20264){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2746__auto____1.call(this,state_20264);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2746__auto____0;
fluree$db$query$analytical$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2746__auto____1;
return fluree$db$query$analytical$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20313 = f__2769__auto__.call(null);
(statearr_20313[(6)] = c__2768__auto__);

return statearr_20313;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.call(null,(function (acc,p__20350){
var vec__20351 = p__20350;
var sub = cljs.core.nth.call(null,vec__20351,(0),null);
var obj = cljs.core.nth.call(null,vec__20351,(1),null);
return cljs.core.update.call(null,acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap.call(null,cljs.core.keys.call(null,tuple_map),cljs.core.map.call(null,(function (p1__20354_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set.call(null,p1__20354_SHARP_)]);
}),cljs.core.vals.call(null,tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map.call(null,tuple_map);
var G__20358 = subjects;
var vec__20359 = G__20358;
var seq__20360 = cljs.core.seq.call(null,vec__20359);
var first__20361 = cljs.core.first.call(null,seq__20360);
var seq__20360__$1 = cljs.core.next.call(null,seq__20360);
var subject = first__20361;
var r = seq__20360__$1;
var acc = expanded_map;
var G__20358__$1 = G__20358;
var acc__$1 = acc;
while(true){
var vec__20365 = G__20358__$1;
var seq__20366 = cljs.core.seq.call(null,vec__20365);
var first__20367 = cljs.core.first.call(null,seq__20366);
var seq__20366__$1 = cljs.core.next.call(null,seq__20366);
var subject__$1 = first__20367;
var r__$1 = seq__20366__$1;
var acc__$2 = acc__$1;
if(cljs.core.not.call(null,subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__20368 = r__$1;
var G__20369 = acc__$2;
G__20358__$1 = G__20368;
acc__$1 = G__20369;
continue;
} else {
var subject_all = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.call(null,subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.call(null,((function (G__20358__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__20365,seq__20366,first__20367,seq__20366__$1,subject__$1,r__$1,acc__$2,G__20358,vec__20359,seq__20360,first__20361,seq__20360__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.call(null,subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:all_followed.call(null,subject_to_follow));
var acc_SINGLEQUOTE_ = cljs.core.update_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__5045__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__20358__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20365,seq__20366,first__20367,seq__20366__$1,subject__$1,r__$1,acc__$2,G__20358,vec__20359,seq__20360,first__20361,seq__20360__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__20358__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20365,seq__20366,first__20367,seq__20366__$1,subject__$1,r__$1,acc__$2,G__20358,vec__20359,seq__20360,first__20361,seq__20360__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__20358__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20365,seq__20366,first__20367,seq__20366__$1,subject__$1,r__$1,acc__$2,G__20358,vec__20359,seq__20360,first__20361,seq__20360__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__20358__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20365,seq__20366,first__20367,seq__20366__$1,subject__$1,r__$1,acc__$2,G__20358,vec__20359,seq__20360,first__20361,seq__20360__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__20358__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__20365,seq__20366,first__20367,seq__20366__$1,subject__$1,r__$1,acc__$2,G__20358,vec__20359,seq__20360,first__20361,seq__20360__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.call(null,subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__20370 = r__$1;
var G__20371 = cljs.core.assoc_in.call(null,acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__20358__$1 = G__20370;
acc__$1 = G__20371;
continue;
} else {
var G__20372 = subjects;
var G__20373 = acc_STAR_;
G__20358__$1 = G__20372;
acc__$1 = G__20373;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.call(null,(function (acc,subject){
var subject_vals = cljs.core.get_in.call(null,recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.call(null,acc,cljs.core.map.call(null,(function (p1__20374_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__20374_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20465){
var state_val_20466 = (state_20465[(1)]);
if((state_val_20466 === (7))){
var state_20465__$1 = state_20465;
var statearr_20467_20513 = state_20465__$1;
(statearr_20467_20513[(2)] = (100));

(statearr_20467_20513[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20466 === (20))){
var inst_20414 = (state_20465[(7)]);
var state_20465__$1 = state_20465;
var statearr_20468_20514 = state_20465__$1;
(statearr_20468_20514[(2)] = inst_20414);

(statearr_20468_20514[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20466 === (1))){
var state_20465__$1 = state_20465;
var statearr_20469_20515 = state_20465__$1;
(statearr_20469_20515[(2)] = null);

(statearr_20469_20515[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20466 === (24))){
var inst_20453 = (state_20465[(8)]);
var inst_20451 = (state_20465[(9)]);
var inst_20386 = (state_20465[(10)]);
var inst_20452 = (state_20465[(11)]);
var inst_20456 = (function (){var max_depth = inst_20386;
var recur_map__$1 = inst_20452;
var subjects = inst_20451;
var tuples = inst_20453;
return (function (p1__20375_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second.call(null,p1__20375_SHARP_)],null));
});
})();
var inst_20457 = cljs.core.map.call(null,inst_20456,inst_20453);
var inst_20458 = cljs.core.distinct.call(null,inst_20457);
var state_20465__$1 = state_20465;
var statearr_20470_20516 = state_20465__$1;
(statearr_20470_20516[(2)] = inst_20458);

(statearr_20470_20516[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20466 === (4))){
var inst_20376 = (state_20465[(2)]);
var state_20465__$1 = state_20465;
var statearr_20471_20517 = state_20465__$1;
(statearr_20471_20517[(2)] = inst_20376);

(statearr_20471_20517[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20466 === (15))){
var inst_20399 = (state_20465[(12)]);
var inst_20410 = cljs.core.PersistentVector.EMPTY;
var inst_20411 = cljs.core.seq.call(null,inst_20399);
var inst_20412 = cljs.core.first.call(null,inst_20411);
var inst_20413 = cljs.core.next.call(null,inst_20411);
var inst_20414 = inst_20410;
var inst_20415 = inst_20399;
var state_20465__$1 = (function (){var statearr_20472 = state_20465;
(statearr_20472[(7)] = inst_20414);

(statearr_20472[(13)] = inst_20412);

(statearr_20472[(14)] = inst_20415);

(statearr_20472[(15)] = inst_20413);

return statearr_20472;
})();
var statearr_20473_20518 = state_20465__$1;
(statearr_20473_20518[(2)] = null);

(statearr_20473_20518[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20466 === (21))){
var inst_20435 = (state_20465[(2)]);
var state_20465__$1 = state_20465;
var statearr_20474_20519 = state_20465__$1;
(statearr_20474_20519[(2)] = inst_20435);

(statearr_20474_20519[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20466 === (13))){
var inst_20448 = (state_20465[(2)]);
var state_20465__$1 = state_20465;
var statearr_20475_20520 = state_20465__$1;
(statearr_20475_20520[(2)] = inst_20448);

(statearr_20475_20520[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20466 === (22))){
var inst_20414 = (state_20465[(7)]);
var inst_20422 = (state_20465[(16)]);
var inst_20429 = (state_20465[(2)]);
var inst_20430 = fluree.db.util.async.throw_err.call(null,inst_20429);
var inst_20431 = cljs.core.concat.call(null,inst_20414,inst_20430);
var inst_20414__$1 = inst_20431;
var inst_20415 = inst_20422;
var state_20465__$1 = (function (){var statearr_20476 = state_20465;
(statearr_20476[(7)] = inst_20414__$1);

(statearr_20476[(14)] = inst_20415);

return statearr_20476;
})();
var statearr_20477_20521 = state_20465__$1;
(statearr_20477_20521[(2)] = null);

(statearr_20477_20521[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20466 === (6))){
var inst_20382 = (state_20465[(17)]);
var state_20465__$1 = state_20465;
var statearr_20478_20522 = state_20465__$1;
(statearr_20478_20522[(2)] = inst_20382);

(statearr_20478_20522[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20466 === (25))){
var inst_20460 = (state_20465[(2)]);
var _ = (function (){var statearr_20479 = state_20465;
(statearr_20479[(4)] = cljs.core.rest.call(null,(state_20465[(4)])));

return statearr_20479;
})();
var state_20465__$1 = state_20465;
var statearr_20480_20523 = state_20465__$1;
(statearr_20480_20523[(2)] = inst_20460);

(statearr_20480_20523[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20466 === (17))){
var inst_20421 = (state_20465[(18)]);
var inst_20415 = (state_20465[(14)]);
var inst_20420 = cljs.core.seq.call(null,inst_20415);
var inst_20421__$1 = cljs.core.first.call(null,inst_20420);
var inst_20422 = cljs.core.next.call(null,inst_20420);
var state_20465__$1 = (function (){var statearr_20481 = state_20465;
(statearr_20481[(18)] = inst_20421__$1);

(statearr_20481[(16)] = inst_20422);

return statearr_20481;
})();
if(cljs.core.truth_(inst_20421__$1)){
var statearr_20482_20524 = state_20465__$1;
(statearr_20482_20524[(1)] = (19));

} else {
var statearr_20483_20525 = state_20465__$1;
(statearr_20483_20525[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20466 === (3))){
var inst_20463 = (state_20465[(2)]);
var state_20465__$1 = state_20465;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20465__$1,inst_20463);
} else {
if((state_val_20466 === (12))){
var inst_20388 = (state_20465[(19)]);
var inst_20399 = (state_20465[(12)]);
var inst_20394 = cljs.core.vals.call(null,inst_20388);
var inst_20395 = cljs.core.flatten.call(null,inst_20394);
var inst_20396 = cljs.core.set.call(null,inst_20395);
var inst_20397 = cljs.core.keys.call(null,inst_20388);
var inst_20398 = cljs.core.set.call(null,inst_20397);
var inst_20399__$1 = clojure.set.difference.call(null,inst_20396,inst_20398);
var inst_20400 = cljs.core.empty_QMARK_.call(null,inst_20399__$1);
var state_20465__$1 = (function (){var statearr_20484 = state_20465;
(statearr_20484[(12)] = inst_20399__$1);

return statearr_20484;
})();
if(inst_20400){
var statearr_20485_20526 = state_20465__$1;
(statearr_20485_20526[(1)] = (14));

} else {
var statearr_20486_20527 = state_20465__$1;
(statearr_20486_20527[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20466 === (2))){
var inst_20382 = (state_20465[(17)]);
var _ = (function (){var statearr_20487 = state_20465;
(statearr_20487[(4)] = cljs.core.cons.call(null,(5),(state_20465[(4)])));

return statearr_20487;
})();
var inst_20382__$1 = depth;
var state_20465__$1 = (function (){var statearr_20488 = state_20465;
(statearr_20488[(17)] = inst_20382__$1);

return statearr_20488;
})();
if(cljs.core.truth_(inst_20382__$1)){
var statearr_20489_20528 = state_20465__$1;
(statearr_20489_20528[(1)] = (6));

} else {
var statearr_20490_20529 = state_20465__$1;
(statearr_20490_20529[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20466 === (23))){
var inst_20453 = (state_20465[(8)]);
var state_20465__$1 = state_20465;
var statearr_20491_20530 = state_20465__$1;
(statearr_20491_20530[(2)] = inst_20453);

(statearr_20491_20530[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20466 === (19))){
var inst_20421 = (state_20465[(18)]);
var inst_20424 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20425 = [inst_20421,predicate];
var inst_20426 = (new cljs.core.PersistentVector(null,2,(5),inst_20424,inst_20425,null));
var inst_20427 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_20426);
var state_20465__$1 = state_20465;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20465__$1,(22),inst_20427);
} else {
if((state_val_20466 === (11))){
var inst_20388 = (state_20465[(19)]);
var state_20465__$1 = state_20465;
var statearr_20493_20531 = state_20465__$1;
(statearr_20493_20531[(2)] = inst_20388);

(statearr_20493_20531[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20466 === (9))){
var inst_20389 = (state_20465[(20)]);
var inst_20386 = (state_20465[(10)]);
var inst_20391 = (inst_20389 >= inst_20386);
var state_20465__$1 = state_20465;
if(cljs.core.truth_(inst_20391)){
var statearr_20494_20532 = state_20465__$1;
(statearr_20494_20532[(1)] = (11));

} else {
var statearr_20495_20533 = state_20465__$1;
(statearr_20495_20533[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20466 === (5))){
var _ = (function (){var statearr_20496 = state_20465;
(statearr_20496[(4)] = cljs.core.rest.call(null,(state_20465[(4)])));

return statearr_20496;
})();
var state_20465__$1 = state_20465;
var ex20492 = (state_20465__$1[(2)]);
var statearr_20497_20534 = state_20465__$1;
(statearr_20497_20534[(5)] = ex20492);


if((ex20492 instanceof Error)){
var statearr_20498_20535 = state_20465__$1;
(statearr_20498_20535[(1)] = (4));

(statearr_20498_20535[(5)] = null);

} else {
throw ex20492;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20466 === (14))){
var inst_20388 = (state_20465[(19)]);
var state_20465__$1 = state_20465;
var statearr_20499_20536 = state_20465__$1;
(statearr_20499_20536[(2)] = inst_20388);

(statearr_20499_20536[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20466 === (16))){
var inst_20446 = (state_20465[(2)]);
var state_20465__$1 = state_20465;
var statearr_20500_20537 = state_20465__$1;
(statearr_20500_20537[(2)] = inst_20446);

(statearr_20500_20537[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20466 === (10))){
var inst_20451 = (state_20465[(9)]);
var inst_20452 = (state_20465[(11)]);
var inst_20450 = (state_20465[(2)]);
var inst_20451__$1 = cljs.core.keys.call(null,inst_20450);
var inst_20452__$1 = fluree.db.query.analytical.follow_all_original_subject_paths.call(null,inst_20451__$1,inst_20450);
var inst_20453 = fluree.db.query.analytical.recur_map__GT_tuples.call(null,inst_20451__$1,inst_20452__$1);
var state_20465__$1 = (function (){var statearr_20501 = state_20465;
(statearr_20501[(8)] = inst_20453);

(statearr_20501[(9)] = inst_20451__$1);

(statearr_20501[(11)] = inst_20452__$1);

return statearr_20501;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_20502_20538 = state_20465__$1;
(statearr_20502_20538[(1)] = (23));

} else {
var statearr_20503_20539 = state_20465__$1;
(statearr_20503_20539[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20466 === (18))){
var inst_20389 = (state_20465[(20)]);
var inst_20388 = (state_20465[(19)]);
var inst_20437 = (state_20465[(2)]);
var inst_20438 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20439 = [(0),(2)];
var inst_20440 = (new cljs.core.PersistentVector(null,2,(5),inst_20438,inst_20439,null));
var inst_20441 = fluree.db.query.analytical.transform_tuples_to_idxs.call(null,inst_20440,inst_20437);
var inst_20442 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_20388,inst_20441);
var inst_20443 = (inst_20389 + (1));
var inst_20388__$1 = inst_20442;
var inst_20389__$1 = inst_20443;
var state_20465__$1 = (function (){var statearr_20504 = state_20465;
(statearr_20504[(20)] = inst_20389__$1);

(statearr_20504[(19)] = inst_20388__$1);

return statearr_20504;
})();
var statearr_20505_20540 = state_20465__$1;
(statearr_20505_20540[(2)] = null);

(statearr_20505_20540[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20466 === (8))){
var inst_20386 = (state_20465[(2)]);
var inst_20387 = recur_map;
var inst_20388 = inst_20387;
var inst_20389 = (1);
var state_20465__$1 = (function (){var statearr_20506 = state_20465;
(statearr_20506[(20)] = inst_20389);

(statearr_20506[(10)] = inst_20386);

(statearr_20506[(19)] = inst_20388);

return statearr_20506;
})();
var statearr_20507_20541 = state_20465__$1;
(statearr_20507_20541[(2)] = null);

(statearr_20507_20541[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____0 = (function (){
var statearr_20508 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20508[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__);

(statearr_20508[(1)] = (1));

return statearr_20508;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____1 = (function (state_20465){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20465);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20509){var ex__2749__auto__ = e20509;
var statearr_20510_20542 = state_20465;
(statearr_20510_20542[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20465[(4)]))){
var statearr_20511_20543 = state_20465;
(statearr_20511_20543[(1)] = cljs.core.first.call(null,(state_20465[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20544 = state_20465;
state_20465 = G__20544;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__ = function(state_20465){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____1.call(this,state_20465);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20512 = f__2769__auto__.call(null);
(statearr_20512[(6)] = c__2768__auto__);

return statearr_20512;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__20545,clause,fuel,max_fuel){
var map__20546 = p__20545;
var map__20546__$1 = cljs.core.__destructure_map.call(null,map__20546);
var res = map__20546__$1;
var headers = cljs.core.get.call(null,map__20546__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__20546__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.call(null,map__20546__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20657){
var state_val_20658 = (state_20657[(1)]);
if((state_val_20658 === (7))){
var inst_20563 = (state_20657[(7)]);
var state_20657__$1 = state_20657;
var statearr_20659_20712 = state_20657__$1;
(statearr_20659_20712[(2)] = inst_20563);

(statearr_20659_20712[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20658 === (20))){
var inst_20591 = (state_20657[(8)]);
var inst_20622 = typeof inst_20591 === 'number';
var state_20657__$1 = state_20657;
if(cljs.core.truth_(inst_20622)){
var statearr_20660_20713 = state_20657__$1;
(statearr_20660_20713[(1)] = (22));

} else {
var statearr_20661_20714 = state_20657__$1;
(statearr_20661_20714[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20658 === (27))){
var inst_20637 = (state_20657[(2)]);
var state_20657__$1 = state_20657;
var statearr_20662_20715 = state_20657__$1;
(statearr_20662_20715[(2)] = inst_20637);

(statearr_20662_20715[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20658 === (1))){
var state_20657__$1 = state_20657;
var statearr_20663_20716 = state_20657__$1;
(statearr_20663_20716[(2)] = null);

(statearr_20663_20716[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20658 === (24))){
var inst_20639 = (state_20657[(2)]);
var state_20657__$1 = state_20657;
var statearr_20664_20717 = state_20657__$1;
(statearr_20664_20717[(2)] = inst_20639);

(statearr_20664_20717[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20658 === (4))){
var inst_20547 = (state_20657[(2)]);
var state_20657__$1 = state_20657;
var statearr_20665_20718 = state_20657__$1;
(statearr_20665_20718[(2)] = inst_20547);

(statearr_20665_20718[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20658 === (15))){
var inst_20605 = (state_20657[(2)]);
var inst_20606 = cljs.core.nth.call(null,clause,(2));
var inst_20607 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_20606);
var state_20657__$1 = (function (){var statearr_20666 = state_20657;
(statearr_20666[(9)] = inst_20605);

return statearr_20666;
})();
if(cljs.core.truth_(inst_20607)){
var statearr_20667_20719 = state_20657__$1;
(statearr_20667_20719[(1)] = (16));

} else {
var statearr_20668_20720 = state_20657__$1;
(statearr_20668_20720[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20658 === (21))){
var inst_20593 = (state_20657[(10)]);
var inst_20564 = (state_20657[(11)]);
var inst_20594 = (state_20657[(12)]);
var inst_20641 = (state_20657[(2)]);
var inst_20642 = fluree.db.query.analytical.tuples__GT_recur.call(null,db,inst_20594,inst_20641,inst_20564,inst_20593);
var state_20657__$1 = state_20657;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20657__$1,(28),inst_20642);
} else {
if((state_val_20658 === (13))){
var inst_20573 = (state_20657[(13)]);
var inst_20597 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20573)].join('');
var inst_20598 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20599 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20600 = cljs.core.PersistentHashMap.fromArrays(inst_20598,inst_20599);
var inst_20601 = cljs.core.ex_info.call(null,inst_20597,inst_20600);
var inst_20602 = (function(){throw inst_20601})();
var state_20657__$1 = state_20657;
var statearr_20669_20721 = state_20657__$1;
(statearr_20669_20721[(2)] = inst_20602);

(statearr_20669_20721[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20658 === (22))){
var inst_20589 = (state_20657[(14)]);
var inst_20591 = (state_20657[(8)]);
var inst_20624 = cljs.core.PersistentHashMap.EMPTY;
var inst_20625 = cljs.core.flatten.call(null,inst_20589);
var inst_20626 = cljs.core.assoc.call(null,inst_20624,inst_20591,inst_20625);
var state_20657__$1 = state_20657;
var statearr_20670_20722 = state_20657__$1;
(statearr_20670_20722[(2)] = inst_20626);

(statearr_20670_20722[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20658 === (6))){
var inst_20575 = (state_20657[(15)]);
var state_20657__$1 = state_20657;
var statearr_20671_20723 = state_20657__$1;
(statearr_20671_20723[(2)] = inst_20575);

(statearr_20671_20723[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20658 === (28))){
var inst_20644 = (state_20657[(2)]);
var inst_20645 = fluree.db.util.async.throw_err.call(null,inst_20644);
var state_20657__$1 = state_20657;
var statearr_20672_20724 = state_20657__$1;
(statearr_20672_20724[(2)] = inst_20645);

(statearr_20672_20724[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20658 === (25))){
var inst_20589 = (state_20657[(14)]);
var inst_20585 = (state_20657[(16)]);
var inst_20630 = cljs.core.PersistentHashMap.EMPTY;
var inst_20631 = cljs.core.first.call(null,inst_20585);
var inst_20632 = cljs.core.first.call(null,inst_20631);
var inst_20633 = cljs.core.flatten.call(null,inst_20589);
var inst_20634 = cljs.core.assoc.call(null,inst_20630,inst_20632,inst_20633);
var state_20657__$1 = state_20657;
var statearr_20673_20725 = state_20657__$1;
(statearr_20673_20725[(2)] = inst_20634);

(statearr_20673_20725[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20658 === (17))){
var inst_20573 = (state_20657[(13)]);
var inst_20610 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20573)].join('');
var inst_20611 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20612 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20613 = cljs.core.PersistentHashMap.fromArrays(inst_20611,inst_20612);
var inst_20614 = cljs.core.ex_info.call(null,inst_20610,inst_20613);
var inst_20615 = (function(){throw inst_20614})();
var state_20657__$1 = state_20657;
var statearr_20674_20726 = state_20657__$1;
(statearr_20674_20726[(2)] = inst_20615);

(statearr_20674_20726[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20658 === (3))){
var inst_20655 = (state_20657[(2)]);
var state_20657__$1 = state_20657;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20657__$1,inst_20655);
} else {
if((state_val_20658 === (12))){
var inst_20560 = (state_20657[(17)]);
var inst_20648 = (state_20657[(2)]);
var inst_20649 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_20650 = cljs.core.keys.call(null,inst_20560);
var inst_20651 = [inst_20650,vars,inst_20648];
var inst_20652 = cljs.core.PersistentHashMap.fromArrays(inst_20649,inst_20651);
var _ = (function (){var statearr_20675 = state_20657;
(statearr_20675[(4)] = cljs.core.rest.call(null,(state_20657[(4)])));

return statearr_20675;
})();
var state_20657__$1 = state_20657;
var statearr_20676_20727 = state_20657__$1;
(statearr_20676_20727[(2)] = inst_20652);

(statearr_20676_20727[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20658 === (2))){
var inst_20564 = (state_20657[(11)]);
var inst_20560 = (state_20657[(17)]);
var inst_20575 = (state_20657[(15)]);
var inst_20563 = (state_20657[(7)]);
var _ = (function (){var statearr_20677 = state_20657;
(statearr_20677[(4)] = cljs.core.cons.call(null,(5),(state_20657[(4)])));

return statearr_20677;
})();
var inst_20557 = fluree.db.query.analytical.clause__GT_rel.call(null,db,vars,clause);
var inst_20558 = cljs.core.__destructure_map.call(null,inst_20557);
var inst_20559 = cljs.core.get.call(null,inst_20558,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_20560__$1 = cljs.core.get.call(null,inst_20558,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_20561 = cljs.core.get.call(null,inst_20558,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_20562 = fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,clause);
var inst_20563__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_20561);
var inst_20564__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_20561);
var inst_20566 = (function (){var map__20553 = inst_20558;
var search = inst_20559;
var rel = inst_20560__$1;
var opts = inst_20561;
var common_keys = inst_20562;
var object_fn = inst_20563__$1;
var recur_depth = inst_20564__$1;
return (function (p__20565,common_key){
var vec__20678 = p__20565;
var acc = cljs.core.nth.call(null,vec__20678,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__20678,(1),null);
var idx_of = fluree.db.util.core.index_of.call(null,clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__20681 = cljs.core._EQ_;
var expr__20682 = idx_of;
if(cljs.core.truth_(pred__20681.call(null,(0),expr__20682))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_(pred__20681.call(null,(1),expr__20682))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_(pred__20681.call(null,(2),expr__20682))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__20682)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of.call(null,headers,common_key);
var v = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,cljs.core.first,fluree.db.query.analytical.transform_tuples_to_idxs.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,v));
var v__$1 = (cljs.core.truth_((function (){var and__5043__auto__ = (!(single_v_QMARK_));
if(and__5043__auto__){
var and__5043__auto____$1 = object_fn;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.call(null,k,object_fn);
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())?cljs.core.comp.call(null,v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.call(null,clause_SINGLEQUOTE_,idx_of,cljs.core.first.call(null,v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_20567 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20568 = cljs.core.PersistentHashMap.EMPTY;
var inst_20569 = [inst_20568,inst_20559];
var inst_20570 = (new cljs.core.PersistentVector(null,2,(5),inst_20567,inst_20569,null));
var inst_20571 = cljs.core.reduce.call(null,inst_20566,inst_20570,inst_20562);
var inst_20572 = cljs.core.nth.call(null,inst_20571,(0),null);
var inst_20573 = cljs.core.nth.call(null,inst_20571,(1),null);
var inst_20574 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_20575__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_20572);
var state_20657__$1 = (function (){var statearr_20684 = state_20657;
(statearr_20684[(18)] = inst_20574);

(statearr_20684[(11)] = inst_20564__$1);

(statearr_20684[(17)] = inst_20560__$1);

(statearr_20684[(13)] = inst_20573);

(statearr_20684[(15)] = inst_20575__$1);

(statearr_20684[(7)] = inst_20563__$1);

return statearr_20684;
})();
if(cljs.core.truth_(inst_20575__$1)){
var statearr_20685_20728 = state_20657__$1;
(statearr_20685_20728[(1)] = (6));

} else {
var statearr_20686_20729 = state_20657__$1;
(statearr_20686_20729[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20658 === (23))){
var inst_20591 = (state_20657[(8)]);
var inst_20628 = cljs.core.coll_QMARK_.call(null,inst_20591);
var state_20657__$1 = state_20657;
if(inst_20628){
var statearr_20687_20730 = state_20657__$1;
(statearr_20687_20730[(1)] = (25));

} else {
var statearr_20688_20731 = state_20657__$1;
(statearr_20688_20731[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20658 === (19))){
var inst_20589 = (state_20657[(14)]);
var inst_20619 = cljs.core.PersistentHashMap.EMPTY;
var inst_20620 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_20619,inst_20589);
var state_20657__$1 = state_20657;
var statearr_20689_20732 = state_20657__$1;
(statearr_20689_20732[(2)] = inst_20620);

(statearr_20689_20732[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20658 === (11))){
var inst_20589 = (state_20657[(14)]);
var state_20657__$1 = state_20657;
var statearr_20691_20733 = state_20657__$1;
(statearr_20691_20733[(2)] = inst_20589);

(statearr_20691_20733[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20658 === (9))){
var inst_20564 = (state_20657[(11)]);
var inst_20560 = (state_20657[(17)]);
var inst_20585 = (state_20657[(16)]);
var inst_20584 = (state_20657[(2)]);
var inst_20585__$1 = fluree.db.util.async.throw_err.call(null,inst_20584);
var inst_20586 = cljs.core.count.call(null,inst_20585__$1);
var inst_20587 = fluree.db.query.analytical.add_fuel.call(null,inst_20586,fuel,max_fuel);
var inst_20588 = cljs.core.vals.call(null,inst_20560);
var inst_20589 = fluree.db.query.analytical.transform_tuples_to_idxs.call(null,inst_20588,inst_20585__$1);
var state_20657__$1 = (function (){var statearr_20692 = state_20657;
(statearr_20692[(14)] = inst_20589);

(statearr_20692[(19)] = inst_20587);

(statearr_20692[(16)] = inst_20585__$1);

return statearr_20692;
})();
if(cljs.core.truth_(inst_20564)){
var statearr_20693_20734 = state_20657__$1;
(statearr_20693_20734[(1)] = (10));

} else {
var statearr_20694_20735 = state_20657__$1;
(statearr_20694_20735[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20658 === (5))){
var _ = (function (){var statearr_20695 = state_20657;
(statearr_20695[(4)] = cljs.core.rest.call(null,(state_20657[(4)])));

return statearr_20695;
})();
var state_20657__$1 = state_20657;
var ex20690 = (state_20657__$1[(2)]);
var statearr_20696_20736 = state_20657__$1;
(statearr_20696_20736[(5)] = ex20690);


if((ex20690 instanceof Error)){
var statearr_20697_20737 = state_20657__$1;
(statearr_20697_20737[(1)] = (4));

(statearr_20697_20737[(5)] = null);

} else {
throw ex20690;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20658 === (14))){
var state_20657__$1 = state_20657;
var statearr_20698_20738 = state_20657__$1;
(statearr_20698_20738[(2)] = null);

(statearr_20698_20738[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20658 === (26))){
var state_20657__$1 = state_20657;
var statearr_20699_20739 = state_20657__$1;
(statearr_20699_20739[(2)] = null);

(statearr_20699_20739[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20658 === (16))){
var state_20657__$1 = state_20657;
var statearr_20700_20740 = state_20657__$1;
(statearr_20700_20740[(2)] = null);

(statearr_20700_20740[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20658 === (10))){
var inst_20573 = (state_20657[(13)]);
var inst_20594 = (state_20657[(12)]);
var inst_20591 = cljs.core.first.call(null,inst_20573);
var inst_20592 = cljs.core.first.call(null,clause);
var inst_20593 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_20592);
var inst_20594__$1 = cljs.core.nth.call(null,inst_20573,(1));
var inst_20595 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_20594__$1);
var state_20657__$1 = (function (){var statearr_20701 = state_20657;
(statearr_20701[(10)] = inst_20593);

(statearr_20701[(8)] = inst_20591);

(statearr_20701[(12)] = inst_20594__$1);

return statearr_20701;
})();
if(cljs.core.truth_(inst_20595)){
var statearr_20702_20741 = state_20657__$1;
(statearr_20702_20741[(1)] = (13));

} else {
var statearr_20703_20742 = state_20657__$1;
(statearr_20703_20742[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20658 === (18))){
var inst_20593 = (state_20657[(10)]);
var inst_20617 = (state_20657[(2)]);
var state_20657__$1 = (function (){var statearr_20704 = state_20657;
(statearr_20704[(20)] = inst_20617);

return statearr_20704;
})();
if(cljs.core.truth_(inst_20593)){
var statearr_20705_20743 = state_20657__$1;
(statearr_20705_20743[(1)] = (19));

} else {
var statearr_20706_20744 = state_20657__$1;
(statearr_20706_20744[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20658 === (8))){
var inst_20574 = (state_20657[(18)]);
var inst_20573 = (state_20657[(13)]);
var inst_20579 = (state_20657[(2)]);
var inst_20580 = [inst_20579];
var inst_20581 = cljs.core.PersistentHashMap.fromArrays(inst_20574,inst_20580);
var inst_20582 = fluree.db.query.range.search.call(null,db,inst_20573,inst_20581);
var state_20657__$1 = state_20657;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20657__$1,(9),inst_20582);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_20707 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20707[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__);

(statearr_20707[(1)] = (1));

return statearr_20707;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____1 = (function (state_20657){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20657);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20708){var ex__2749__auto__ = e20708;
var statearr_20709_20745 = state_20657;
(statearr_20709_20745[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20657[(4)]))){
var statearr_20710_20746 = state_20657;
(statearr_20710_20746[(1)] = cljs.core.first.call(null,(state_20657[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20747 = state_20657;
state_20657 = G__20747;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__ = function(state_20657){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____1.call(this,state_20657);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20711 = f__2769__auto__.call(null);
(statearr_20711[(6)] = c__2768__auto__);

return statearr_20711;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__20748,res,clause){
var map__20749 = p__20748;
var map__20749__$1 = cljs.core.__destructure_map.call(null,map__20749);
var db = map__20749__$1;
var conn = cljs.core.get.call(null,map__20749__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__20749__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__20749__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
throw cljs.core.ex_info.call(null,"Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20858){
var state_val_20859 = (state_20858[(1)]);
if((state_val_20859 === (7))){
var inst_20758 = (state_20858[(7)]);
var state_20858__$1 = state_20858;
var statearr_20860_20901 = state_20858__$1;
(statearr_20860_20901[(2)] = inst_20758);

(statearr_20860_20901[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20859 === (20))){
var state_20858__$1 = state_20858;
var statearr_20861_20902 = state_20858__$1;
(statearr_20861_20902[(2)] = null);

(statearr_20861_20902[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20859 === (1))){
var state_20858__$1 = state_20858;
var statearr_20862_20903 = state_20858__$1;
(statearr_20862_20903[(2)] = null);

(statearr_20862_20903[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20859 === (24))){
var inst_20760 = (state_20858[(8)]);
var inst_20831 = (state_20858[(2)]);
var inst_20832 = fluree.db.flake.sid__GT_cid.call(null,inst_20831);
var inst_20833 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_20832);
var inst_20834 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20835 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20836 = [inst_20760];
var inst_20837 = (new cljs.core.PersistentVector(null,1,(5),inst_20835,inst_20836,null));
var inst_20838 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20839 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20840 = [inst_20833];
var inst_20841 = (new cljs.core.PersistentVector(null,1,(5),inst_20839,inst_20840,null));
var inst_20842 = [inst_20841];
var inst_20843 = (new cljs.core.PersistentVector(null,1,(5),inst_20838,inst_20842,null));
var inst_20844 = cljs.core.PersistentHashMap.EMPTY;
var inst_20845 = [inst_20837,inst_20843,inst_20844];
var inst_20846 = cljs.core.PersistentHashMap.fromArrays(inst_20834,inst_20845);
var state_20858__$1 = state_20858;
var statearr_20863_20904 = state_20858__$1;
(statearr_20863_20904[(2)] = inst_20846);

(statearr_20863_20904[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20859 === (4))){
var inst_20751 = (state_20858[(2)]);
var state_20858__$1 = state_20858;
var statearr_20864_20905 = state_20858__$1;
(statearr_20864_20905[(2)] = inst_20751);

(statearr_20864_20905[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20859 === (15))){
var inst_20758 = (state_20858[(7)]);
var inst_20760 = (state_20858[(8)]);
var inst_20779 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_20780 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20781 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20782 = [inst_20758];
var inst_20783 = (new cljs.core.PersistentVector(null,1,(5),inst_20781,inst_20782,null));
var inst_20784 = (function (){var subject_var = inst_20758;
var object_var = inst_20760;
var min_sid = inst_20779;
var max_sid = (0);
return (function (p1__20750_SHARP_){
return cljs.core.conj.call(null,cljs.core.PersistentVector.EMPTY,p1__20750_SHARP_);
});
})();
var inst_20785 = cljs.core.range.call(null,inst_20779,(0));
var inst_20786 = cljs.core.map.call(null,inst_20784,inst_20785);
var inst_20787 = cljs.core.PersistentHashMap.EMPTY;
var inst_20788 = [inst_20783,inst_20786,inst_20787];
var inst_20789 = cljs.core.PersistentHashMap.fromArrays(inst_20780,inst_20788);
var state_20858__$1 = state_20858;
var statearr_20865_20906 = state_20858__$1;
(statearr_20865_20906[(2)] = inst_20789);

(statearr_20865_20906[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20859 === (21))){
var inst_20849 = (state_20858[(2)]);
var state_20858__$1 = state_20858;
var statearr_20866_20907 = state_20858__$1;
(statearr_20866_20907[(2)] = inst_20849);

(statearr_20866_20907[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20859 === (13))){
var inst_20760 = (state_20858[(8)]);
var state_20858__$1 = state_20858;
if(cljs.core.truth_(inst_20760)){
var statearr_20867_20908 = state_20858__$1;
(statearr_20867_20908[(1)] = (19));

} else {
var statearr_20868_20909 = state_20858__$1;
(statearr_20868_20909[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20859 === (22))){
var inst_20822 = (state_20858[(9)]);
var state_20858__$1 = state_20858;
var statearr_20869_20910 = state_20858__$1;
(statearr_20869_20910[(2)] = inst_20822);

(statearr_20869_20910[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20859 === (6))){
var inst_20760 = (state_20858[(8)]);
var state_20858__$1 = state_20858;
var statearr_20870_20911 = state_20858__$1;
(statearr_20870_20911[(2)] = inst_20760);

(statearr_20870_20911[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20859 === (25))){
var inst_20828 = (state_20858[(2)]);
var inst_20829 = fluree.db.util.async.throw_err.call(null,inst_20828);
var state_20858__$1 = state_20858;
var statearr_20871_20912 = state_20858__$1;
(statearr_20871_20912[(2)] = inst_20829);

(statearr_20871_20912[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20859 === (17))){
var inst_20819 = (state_20858[(2)]);
var state_20858__$1 = state_20858;
var statearr_20872_20913 = state_20858__$1;
(statearr_20872_20913[(2)] = inst_20819);

(statearr_20872_20913[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20859 === (3))){
var inst_20856 = (state_20858[(2)]);
var state_20858__$1 = state_20858;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20858__$1,inst_20856);
} else {
if((state_val_20859 === (12))){
var inst_20773 = ["_tx",null,"_block",null];
var inst_20774 = (new cljs.core.PersistentArrayMap(null,2,inst_20773,null));
var inst_20775 = (new cljs.core.PersistentHashSet(null,inst_20774,null));
var inst_20776 = cljs.core.last.call(null,clause);
var inst_20777 = inst_20775.call(null,inst_20776);
var state_20858__$1 = state_20858;
if(cljs.core.truth_(inst_20777)){
var statearr_20873_20914 = state_20858__$1;
(statearr_20873_20914[(1)] = (15));

} else {
var statearr_20874_20915 = state_20858__$1;
(statearr_20874_20915[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20859 === (2))){
var inst_20758 = (state_20858[(7)]);
var _ = (function (){var statearr_20875 = state_20858;
(statearr_20875[(4)] = cljs.core.cons.call(null,(5),(state_20858[(4)])));

return statearr_20875;
})();
var inst_20757 = cljs.core.first.call(null,clause);
var inst_20758__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_20757);
var inst_20759 = cljs.core.last.call(null,clause);
var inst_20760 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_20759);
var state_20858__$1 = (function (){var statearr_20876 = state_20858;
(statearr_20876[(7)] = inst_20758__$1);

(statearr_20876[(8)] = inst_20760);

return statearr_20876;
})();
if(cljs.core.truth_(inst_20758__$1)){
var statearr_20877_20916 = state_20858__$1;
(statearr_20877_20916[(1)] = (6));

} else {
var statearr_20878_20917 = state_20858__$1;
(statearr_20878_20917[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20859 === (23))){
var inst_20822 = (state_20858[(9)]);
var inst_20826 = fluree.db.dbproto._subid.call(null,db,inst_20822);
var state_20858__$1 = state_20858;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20858__$1,(25),inst_20826);
} else {
if((state_val_20859 === (19))){
var inst_20822 = (state_20858[(9)]);
var inst_20822__$1 = cljs.core.first.call(null,clause);
var inst_20823 = typeof inst_20822__$1 === 'number';
var state_20858__$1 = (function (){var statearr_20879 = state_20858;
(statearr_20879[(9)] = inst_20822__$1);

return statearr_20879;
})();
if(cljs.core.truth_(inst_20823)){
var statearr_20880_20918 = state_20858__$1;
(statearr_20880_20918[(1)] = (22));

} else {
var statearr_20881_20919 = state_20858__$1;
(statearr_20881_20919[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20859 === (11))){
var inst_20853 = (state_20858[(2)]);
var _ = (function (){var statearr_20883 = state_20858;
(statearr_20883[(4)] = cljs.core.rest.call(null,(state_20858[(4)])));

return statearr_20883;
})();
var state_20858__$1 = state_20858;
var statearr_20884_20920 = state_20858__$1;
(statearr_20884_20920[(2)] = inst_20853);

(statearr_20884_20920[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20859 === (9))){
var inst_20766 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20767 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20768 = cljs.core.PersistentHashMap.fromArrays(inst_20766,inst_20767);
var inst_20769 = cljs.core.ex_info.call(null,"When using rdf:type, either a subject or a type (collection) must be specified.",inst_20768);
var inst_20770 = (function(){throw inst_20769})();
var state_20858__$1 = state_20858;
var statearr_20885_20921 = state_20858__$1;
(statearr_20885_20921[(2)] = inst_20770);

(statearr_20885_20921[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20859 === (5))){
var _ = (function (){var statearr_20886 = state_20858;
(statearr_20886[(4)] = cljs.core.rest.call(null,(state_20858[(4)])));

return statearr_20886;
})();
var state_20858__$1 = state_20858;
var ex20882 = (state_20858__$1[(2)]);
var statearr_20887_20922 = state_20858__$1;
(statearr_20887_20922[(5)] = ex20882);


if((ex20882 instanceof Error)){
var statearr_20888_20923 = state_20858__$1;
(statearr_20888_20923[(1)] = (4));

(statearr_20888_20923[(5)] = null);

} else {
throw ex20882;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20859 === (14))){
var inst_20851 = (state_20858[(2)]);
var state_20858__$1 = state_20858;
var statearr_20889_20924 = state_20858__$1;
(statearr_20889_20924[(2)] = inst_20851);

(statearr_20889_20924[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20859 === (16))){
var inst_20794 = (state_20858[(10)]);
var inst_20792 = (state_20858[(11)]);
var inst_20795 = (state_20858[(12)]);
var inst_20791 = cljs.core.last.call(null,clause);
var inst_20792__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"partition","partition",1174740751),inst_20791);
var inst_20793 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_20794__$1 = cljs.core.get.call(null,inst_20793,inst_20792__$1);
var inst_20795__$1 = fluree.db.flake.min_subject_id.call(null,inst_20792__$1);
var inst_20796 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20797 = [inst_20794__$1];
var inst_20798 = (new cljs.core.PersistentVector(null,1,(5),inst_20796,inst_20797,null));
var inst_20799 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20800 = [inst_20795__$1];
var inst_20801 = (new cljs.core.PersistentVector(null,1,(5),inst_20799,inst_20800,null));
var inst_20802 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_20798,cljs.core._LT__EQ_,inst_20801);
var state_20858__$1 = (function (){var statearr_20890 = state_20858;
(statearr_20890[(10)] = inst_20794__$1);

(statearr_20890[(11)] = inst_20792__$1);

(statearr_20890[(12)] = inst_20795__$1);

return statearr_20890;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20858__$1,(18),inst_20802);
} else {
if((state_val_20859 === (10))){
var inst_20758 = (state_20858[(7)]);
var state_20858__$1 = state_20858;
if(cljs.core.truth_(inst_20758)){
var statearr_20891_20925 = state_20858__$1;
(statearr_20891_20925[(1)] = (12));

} else {
var statearr_20892_20926 = state_20858__$1;
(statearr_20892_20926[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20859 === (18))){
var inst_20794 = (state_20858[(10)]);
var inst_20792 = (state_20858[(11)]);
var inst_20795 = (state_20858[(12)]);
var inst_20758 = (state_20858[(7)]);
var inst_20760 = (state_20858[(8)]);
var inst_20804 = (state_20858[(2)]);
var inst_20805 = fluree.db.util.async.throw_err.call(null,inst_20804);
var inst_20806 = (function (){var subject_var = inst_20758;
var object_var = inst_20760;
var partition = inst_20792;
var max_sid = inst_20794;
var min_sid = inst_20795;
var flakes = inst_20805;
return (function (f){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s], null);
});
})();
var inst_20807 = cljs.core.map.call(null,inst_20806);
var inst_20808 = cljs.core.distinct.call(null);
var inst_20809 = cljs.core.comp.call(null,inst_20807,inst_20808);
var inst_20810 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20811 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20812 = [inst_20758];
var inst_20813 = (new cljs.core.PersistentVector(null,1,(5),inst_20811,inst_20812,null));
var inst_20814 = cljs.core.sequence.call(null,inst_20809,inst_20805);
var inst_20815 = cljs.core.PersistentHashMap.EMPTY;
var inst_20816 = [inst_20813,inst_20814,inst_20815];
var inst_20817 = cljs.core.PersistentHashMap.fromArrays(inst_20810,inst_20816);
var state_20858__$1 = state_20858;
var statearr_20893_20927 = state_20858__$1;
(statearr_20893_20927[(2)] = inst_20817);

(statearr_20893_20927[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20859 === (8))){
var inst_20764 = (state_20858[(2)]);
var state_20858__$1 = state_20858;
if(cljs.core.truth_(inst_20764)){
var statearr_20894_20928 = state_20858__$1;
(statearr_20894_20928[(1)] = (9));

} else {
var statearr_20895_20929 = state_20858__$1;
(statearr_20895_20929[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_20896 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20896[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__);

(statearr_20896[(1)] = (1));

return statearr_20896;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____1 = (function (state_20858){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20858);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20897){var ex__2749__auto__ = e20897;
var statearr_20898_20930 = state_20858;
(statearr_20898_20930[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20858[(4)]))){
var statearr_20899_20931 = state_20858;
(statearr_20899_20931[(1)] = cljs.core.first.call(null,(state_20858[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20932 = state_20858;
state_20858 = G__20932;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__ = function(state_20858){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____1.call(this,state_20858);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20900 = f__2769__auto__.call(null);
(statearr_20900[(6)] = c__2768__auto__);

return statearr_20900;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.call(null,cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum.call(null,coll) / cljs.core.count.call(null,coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.call(null,coll);
var size = cljs.core.count.call(null,coll);
var med = (size >> (1));
var G__20938 = cljs.core.nth.call(null,terms,med);
if(cljs.core.even_QMARK_.call(null,size)){
return ((G__20938 + cljs.core.nth.call(null,terms,(med - (1)))) / (2));
} else {
return G__20938;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg.call(null,coll);
var sum__$1 = sum.call(null,(function (){var iter__5523__auto__ = (function fluree$db$query$analytical$variance_$_iter__20939(s__20940){
return (new cljs.core.LazySeq(null,(function (){
var s__20940__$1 = s__20940;
while(true){
var temp__5804__auto__ = cljs.core.seq.call(null,s__20940__$1);
if(temp__5804__auto__){
var s__20940__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20940__$2)){
var c__5521__auto__ = cljs.core.chunk_first.call(null,s__20940__$2);
var size__5522__auto__ = cljs.core.count.call(null,c__5521__auto__);
var b__20942 = cljs.core.chunk_buffer.call(null,size__5522__auto__);
if((function (){var i__20941 = (0);
while(true){
if((i__20941 < size__5522__auto__)){
var x = cljs.core._nth.call(null,c__5521__auto__,i__20941);
var delta = (x - mean);
cljs.core.chunk_append.call(null,b__20942,(delta * delta));

var G__20943 = (i__20941 + (1));
i__20941 = G__20943;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20942),fluree$db$query$analytical$variance_$_iter__20939.call(null,cljs.core.chunk_rest.call(null,s__20940__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20942),null);
}
} else {
var x = cljs.core.first.call(null,s__20940__$2);
var delta = (x - mean);
return cljs.core.cons.call(null,(delta * delta),fluree$db$query$analytical$variance_$_iter__20939.call(null,cljs.core.rest.call(null,s__20940__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5523__auto__.call(null,coll);
})());
return (sum__$1 / cljs.core.count.call(null,coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
return Math.sqrt(variance.call(null,coll));
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__5130__auto__ = n;
var y__5131__auto__ = (- n);
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
}),(function() {
var G__20944 = null;
var G__20944__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__20944__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.last.call(null,acc)) < (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.butlast.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__20944 = function(n,coll){
switch(arguments.length){
case 1:
return G__20944__1.call(this,n);
case 2:
return G__20944__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__20944.cljs$core$IFn$_invoke$arity$1 = G__20944__1;
G__20944.cljs$core$IFn$_invoke$arity$2 = G__20944__2;
return G__20944;
})()
,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__20945 = null;
var G__20945__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__20945__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.first.call(null,acc)) > (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.next.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__20945 = function(n,coll){
switch(arguments.length){
case 1:
return G__20945__1.call(this,n);
case 2:
return G__20945__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__20945.cljs$core$IFn$_invoke$arity$1 = G__20945__1;
G__20945.cljs$core$IFn$_invoke$arity$2 = G__20945__2;
return G__20945;
})()
,(function (coll){
return cljs.core.count.call(null,cljs.core.distinct.call(null,coll));
}),avg,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__20946 = null;
var G__20946__1 = (function (coll){
return cljs.core.rand_nth.call(null,coll);
});
var G__20946__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.repeatedly.call(null,n,(function (){
return cljs.core.rand_nth.call(null,coll);
})));
});
G__20946 = function(n,coll){
switch(arguments.length){
case 1:
return G__20946__1.call(this,n);
case 2:
return G__20946__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__20946.cljs$core$IFn$_invoke$arity$1 = G__20946__1;
G__20946.cljs$core$IFn$_invoke$arity$2 = G__20946__2;
return G__20946;
})()
,(function (n,coll){
return cljs.core.vec.call(null,cljs.core.take.call(null,n,cljs.core.shuffle.call(null,coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches.call(null,/^\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches.call(null,/^#\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
/**
 * Returns map of aggregate function executable code or error if invalid aggregate function.
 */
fluree.db.query.analytical.parse_aggregate_STAR_ = (function fluree$db$query$analytical$parse_aggregate_STAR_(parsed_code,as,valid_var){
var list_count = cljs.core.count.call(null,parsed_code);
var vec__20947 = ((cljs.core._EQ_.call(null,(3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,parsed_code),cljs.core.second.call(null,parsed_code),cljs.core.last.call(null,parsed_code)], null):((cljs.core._EQ_.call(null,(2),list_count))?((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first.call(null,parsed_code)))?(function(){throw cljs.core.ex_info.call(null,["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.pr_str.call(null,parsed_code)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,parsed_code),null,cljs.core.last.call(null,parsed_code)], null)):(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.pr_str.call(null,parsed_code)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var fun = cljs.core.nth.call(null,vec__20947,(0),null);
var arg = cljs.core.nth.call(null,vec__20947,(1),null);
var var$ = cljs.core.nth.call(null,vec__20947,(2),null);
var agg_fn = (function (){var temp__5802__auto__ = fluree.db.query.analytical.built_in_aggregates.call(null,fun);
if(cljs.core.truth_(temp__5802__auto__)){
var agg_fn = temp__5802__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return agg_fn.call(null,arg,coll);
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection function, provided: ",cljs.core.pr_str.call(null,parsed_code)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__20950 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_.call(null,var$)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second.call(null,var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
return agg_fn.call(null,cljs.core.distinct.call(null,coll));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.call(null,vec__20950,(0),null);
var variable = cljs.core.nth.call(null,vec__20950,(1),null);
var fn_str = ["(fn [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(variable),"] ",cljs.core.pr_str.call(null,parsed_code),")"].join('');
if(cljs.core.truth_(valid_var.call(null,variable))){
} else {
throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.pr_str.call(null,parsed_code)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402),fn_str,new cljs.core.Keyword(null,"function","function",-2127255473),agg_fn__$1], null);
});
/**
 * Parses string aggregate function and returns execution map if valid.
 */
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(code_str,valid_var){
var list_agg = cljs.reader.read_string.call(null,code_str);
var as_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first.call(null,list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,list_agg))].join('')):cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var code_parsed = ((as_QMARK_)?(function (){var func_list = cljs.core.second.call(null,list_agg);
if(cljs.core.coll_QMARK_.call(null,func_list)){
return func_list;
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(code_str)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
return fluree.db.query.analytical.parse_aggregate_STAR_.call(null,code_parsed,as,valid_var);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(tuples,aggregate_fn_map){
var map__20953 = aggregate_fn_map;
var map__20953__$1 = cljs.core.__destructure_map.call(null,map__20953);
var variable = cljs.core.get.call(null,map__20953__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.call(null,map__20953__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var function$ = cljs.core.get.call(null,map__20953__$1,new cljs.core.Keyword(null,"function","function",-2127255473));
var agg_params = cljs.core.flatten.call(null,fluree.db.query.analytical.select_from_tuples.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),tuples));
var agg_result = function$.call(null,agg_params);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.call(null,(function (res__$1,agg){
var vec__20955 = fluree.db.query.analytical.calculate_aggregate.call(null,res__$1,agg);
var as = cljs.core.nth.call(null,vec__20955,(0),null);
var agg_result = cljs.core.nth.call(null,vec__20955,(1),null);
var map__20958 = res__$1;
var map__20958__$1 = cljs.core.__destructure_map.call(null,map__20958);
var headers = cljs.core.get.call(null,map__20958__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__20958__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__20954_SHARP_){
return cljs.core.conj.call(null,cljs.core.vec.call(null,p1__20954_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,cljs.core.vec.call(null,headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.call(null,(function (acc,tuple){
var b_compare = cljs.core.map.call(null,(function (p1__20959_SHARP_){
return cljs.core.nth.call(null,tuple,p1__20959_SHARP_);
}),b_idxs);
return cljs.core.update.call(null,acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq.call(null,cljs.core.reduce.call(null,(function (acc,a_tuple){
var a_compare = cljs.core.map.call(null,(function (p1__20960_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__20960_SHARP_);
}),a_idxs);
var temp__5802__auto__ = cljs.core.get.call(null,b_map,a_compare);
if(cljs.core.truth_(temp__5802__auto__)){
var b_matched = temp__5802__auto__;
return cljs.core.reduce.call(null,(function (p1__20961_SHARP_,p2__20962_SHARP_){
return cljs.core.conj.call(null,p1__20961_SHARP_,cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (idx){
return cljs.core.nth.call(null,p2__20962_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.call(null,acc,cljs.core.concat.call(null,a_tuple,cljs.core.repeat.call(null,cljs.core.count.call(null,b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.call(null,(function (p1__20963_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__20963_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv.call(null,(function (p__20966,row,b_tuple){
var vec__20967 = p__20966;
var acc = cljs.core.nth.call(null,vec__20967,(0),null);
var b_rows = cljs.core.nth.call(null,vec__20967,(1),null);
if(cljs.core._EQ_.call(null,a_tuple_part,cljs.core.map.call(null,(function (p1__20964_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__20964_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,(function (){var or__5045__auto__ = acc;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (p1__20965_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__20965_SHARP_);
}),b_not_idxs))),cljs.core.conj.call(null,b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_res,b_res);
var a_idxs = cljs.core.map.call(null,(function (p1__20970_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__20970_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__20971_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__20971_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__20973_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__20973_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__20972_SHARP_){
return cljs.core.range.call(null,(0),p1__20972_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = fluree.db.query.analytical.match_tuples_lists.call(null,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.call(null,(function (p1__20974_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__20974_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_tuples,b_tuples);
var a_idxs = cljs.core.map.call(null,(function (p1__20975_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__20975_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__20976_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__20976_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__20978_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__20978_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__20977_SHARP_){
return cljs.core.range.call(null,(0),p1__20977_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = fluree.db.query.analytical.match_tuples_lists.call(null,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.call(null,(function (p1__20979_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__20979_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.call(null," ",filter_code_req),")"].join('');
var vec__20981 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.extract_filter_fn.call(null,filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.call(null,vec__20981,(0),null);
var _ = cljs.core.nth.call(null,vec__20981,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.call(null,(function (p1__20980_SHARP_){
return fluree.db.query.analytical_filter.filter_row.call(null,headers,p1__20980_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.call(null,(function (tuples__$1,filt){
var vec__20986 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.extract_filter_fn.call(null,filt,valid_vars);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.call(null,vec__20986,(0),null);
var filt_vars = cljs.core.nth.call(null,vec__20986,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.call(null,(function (p1__20984_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__20984_SHARP_);
}),filt_vars);
var filtered_tuples = cljs.core.reduce.call(null,(function (acc,clause){
if(cljs.core.every_QMARK_.call(null,(function (p1__20985_SHARP_){
return cljs.core.nth.call(null,clause,p1__20985_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row.call(null,headers,clause,filt_str))){
return cljs.core.conj.call(null,acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.call(null,acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__20989,filters,optional_QMARK_){
var map__20990 = p__20989;
var map__20990__$1 = cljs.core.__destructure_map.call(null,map__20990);
var tuple_map = map__20990__$1;
var headers = cljs.core.get.call(null,map__20990__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__20990__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.call(null,map__20990__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set.call(null,headers);
var header_vec = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.call(null,["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters.call(null,filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required.call(null,header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters.call(null,filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__20991 = clause;
var k = cljs.core.nth.call(null,vec__20991,(0),null);
var v = cljs.core.nth.call(null,vec__20991,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.call(null,["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__20994 = res;
var map__20994__$1 = cljs.core.__destructure_map.call(null,map__20994);
var headers = cljs.core.get.call(null,map__20994__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__20994__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_.call(null,v))?cljs.core.second.call(null,fluree.db.query.analytical.calculate_aggregate.call(null,res,fluree.db.query.analytical.parse_aggregate.call(null,cljs.core.subs.call(null,v,(1)),cljs.core.set.call(null,(function (){var temp__5802__auto__ = cljs.core.keys.call(null,vars);
if(cljs.core.truth_(temp__5802__auto__)){
var valid_var = temp__5802__auto__;
return cljs.core.conj.call(null,headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_21050){
var state_val_21051 = (state_21050[(1)]);
if((state_val_21051 === (7))){
var inst_21024 = (state_21050[(7)]);
var inst_21022 = (state_21050[(2)]);
var inst_21023 = fluree.db.util.async.throw_err.call(null,inst_21022);
var inst_21024__$1 = cljs.core.nth.call(null,inst_21023,(0),null);
var inst_21025 = cljs.core.nth.call(null,inst_21023,(1),null);
var inst_21026 = (inst_21024__$1 == null);
var state_21050__$1 = (function (){var statearr_21052 = state_21050;
(statearr_21052[(7)] = inst_21024__$1);

(statearr_21052[(8)] = inst_21025);

return statearr_21052;
})();
if(cljs.core.truth_(inst_21026)){
var statearr_21053_21082 = state_21050__$1;
(statearr_21053_21082[(1)] = (8));

} else {
var statearr_21054_21083 = state_21050__$1;
(statearr_21054_21083[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21051 === (1))){
var inst_21002 = optional_clauses;
var inst_21003 = cljs.core.seq.call(null,inst_21002);
var inst_21004 = cljs.core.first.call(null,inst_21003);
var inst_21005 = cljs.core.next.call(null,inst_21003);
var inst_21006 = where_tuples;
var inst_21007 = inst_21002;
var inst_21008 = inst_21006;
var state_21050__$1 = (function (){var statearr_21055 = state_21050;
(statearr_21055[(9)] = inst_21008);

(statearr_21055[(10)] = inst_21007);

(statearr_21055[(11)] = inst_21004);

(statearr_21055[(12)] = inst_21005);

return statearr_21055;
})();
var statearr_21056_21084 = state_21050__$1;
(statearr_21056_21084[(2)] = null);

(statearr_21056_21084[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21051 === (4))){
var inst_21008 = (state_21050[(9)]);
var inst_21015 = (state_21050[(13)]);
var inst_21014 = (state_21050[(14)]);
var inst_21020 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_21008,inst_21014,inst_21015,true,fuel,max_fuel,opts);
var state_21050__$1 = state_21050;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21050__$1,(7),inst_21020);
} else {
if((state_val_21051 === (15))){
var state_21050__$1 = state_21050;
var statearr_21057_21085 = state_21050__$1;
(statearr_21057_21085[(2)] = null);

(statearr_21057_21085[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21051 === (13))){
var inst_21041 = (state_21050[(2)]);
var state_21050__$1 = state_21050;
var statearr_21058_21086 = state_21050__$1;
(statearr_21058_21086[(2)] = inst_21041);

(statearr_21058_21086[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21051 === (6))){
var inst_21046 = (state_21050[(2)]);
var state_21050__$1 = state_21050;
var statearr_21059_21087 = state_21050__$1;
(statearr_21059_21087[(2)] = inst_21046);

(statearr_21059_21087[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21051 === (3))){
var inst_21048 = (state_21050[(2)]);
var state_21050__$1 = state_21050;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21050__$1,inst_21048);
} else {
if((state_val_21051 === (12))){
var state_21050__$1 = state_21050;
var statearr_21060_21088 = state_21050__$1;
(statearr_21060_21088[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21051 === (2))){
var inst_21007 = (state_21050[(10)]);
var inst_21014 = (state_21050[(14)]);
var inst_21013 = cljs.core.seq.call(null,inst_21007);
var inst_21014__$1 = cljs.core.first.call(null,inst_21013);
var inst_21015 = cljs.core.next.call(null,inst_21013);
var state_21050__$1 = (function (){var statearr_21062 = state_21050;
(statearr_21062[(13)] = inst_21015);

(statearr_21062[(14)] = inst_21014__$1);

return statearr_21062;
})();
if(cljs.core.truth_(inst_21014__$1)){
var statearr_21063_21089 = state_21050__$1;
(statearr_21063_21089[(1)] = (4));

} else {
var statearr_21064_21090 = state_21050__$1;
(statearr_21064_21090[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21051 === (11))){
var inst_21024 = (state_21050[(7)]);
var inst_21025 = (state_21050[(8)]);
var inst_21007 = inst_21025;
var inst_21008 = inst_21024;
var state_21050__$1 = (function (){var statearr_21065 = state_21050;
(statearr_21065[(9)] = inst_21008);

(statearr_21065[(10)] = inst_21007);

return statearr_21065;
})();
var statearr_21066_21091 = state_21050__$1;
(statearr_21066_21091[(2)] = null);

(statearr_21066_21091[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21051 === (9))){
var inst_21014 = (state_21050[(14)]);
var inst_21030 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_21014);
var state_21050__$1 = state_21050;
if(cljs.core.truth_(inst_21030)){
var statearr_21067_21092 = state_21050__$1;
(statearr_21067_21092[(1)] = (11));

} else {
var statearr_21068_21093 = state_21050__$1;
(statearr_21068_21093[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21051 === (5))){
var inst_21008 = (state_21050[(9)]);
var state_21050__$1 = state_21050;
var statearr_21069_21094 = state_21050__$1;
(statearr_21069_21094[(2)] = inst_21008);

(statearr_21069_21094[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21051 === (14))){
var inst_21024 = (state_21050[(7)]);
var inst_21025 = (state_21050[(8)]);
var inst_21008 = (state_21050[(9)]);
var inst_21035 = fluree.db.query.analytical.left_outer_join.call(null,inst_21008,inst_21024);
var inst_21007 = inst_21025;
var inst_21008__$1 = inst_21035;
var state_21050__$1 = (function (){var statearr_21070 = state_21050;
(statearr_21070[(9)] = inst_21008__$1);

(statearr_21070[(10)] = inst_21007);

return statearr_21070;
})();
var statearr_21071_21095 = state_21050__$1;
(statearr_21071_21095[(2)] = null);

(statearr_21071_21095[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21051 === (16))){
var inst_21039 = (state_21050[(2)]);
var state_21050__$1 = state_21050;
var statearr_21073_21096 = state_21050__$1;
(statearr_21073_21096[(2)] = inst_21039);

(statearr_21073_21096[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21051 === (10))){
var inst_21043 = (state_21050[(2)]);
var state_21050__$1 = state_21050;
var statearr_21074_21097 = state_21050__$1;
(statearr_21074_21097[(2)] = inst_21043);

(statearr_21074_21097[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21051 === (8))){
var inst_21025 = (state_21050[(8)]);
var inst_21008 = (state_21050[(9)]);
var tmp21072 = inst_21008;
var inst_21007 = inst_21025;
var inst_21008__$1 = tmp21072;
var state_21050__$1 = (function (){var statearr_21075 = state_21050;
(statearr_21075[(9)] = inst_21008__$1);

(statearr_21075[(10)] = inst_21007);

return statearr_21075;
})();
var statearr_21076_21098 = state_21050__$1;
(statearr_21076_21098[(2)] = null);

(statearr_21076_21098[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____0 = (function (){
var statearr_21077 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21077[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__);

(statearr_21077[(1)] = (1));

return statearr_21077;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____1 = (function (state_21050){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_21050);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e21078){var ex__2749__auto__ = e21078;
var statearr_21079_21099 = state_21050;
(statearr_21079_21099[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_21050[(4)]))){
var statearr_21080_21100 = state_21050;
(statearr_21080_21100[(1)] = cljs.core.first.call(null,(state_21050[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21101 = state_21050;
state_21050 = G__21101;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__ = function(state_21050){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____1.call(this,state_21050);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_21081 = f__2769__auto__.call(null);
(statearr_21081[(6)] = c__2768__auto__);

return statearr_21081;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.call(null,(function (acc,p__21103){
var vec__21104 = p__21103;
var var_name = cljs.core.nth.call(null,vec__21104,(0),null);
var var_val = cljs.core.nth.call(null,vec__21104,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__21102_SHARP_){
return cljs.core.conj.call(null,p1__21102_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__21108,p__21109,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__21110 = p__21108;
var map__21110__$1 = cljs.core.__destructure_map.call(null,map__21110);
var q_map = map__21110__$1;
var prefixes = cljs.core.get.call(null,map__21110__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__21111 = p__21109;
var map__21111__$1 = cljs.core.__destructure_map.call(null,map__21111);
var res = map__21111__$1;
var vars = cljs.core.get.call(null,map__21111__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_21348){
var state_val_21349 = (state_21348[(1)]);
if((state_val_21349 === (65))){
var inst_21297 = (state_21348[(7)]);
var inst_21298 = (state_21348[(8)]);
var inst_21309 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21310 = fluree.db.query.analytical.full_text__GT_tuples.call(null,inst_21297,res,inst_21298);
var inst_21311 = [inst_21310,r];
var inst_21312 = (new cljs.core.PersistentVector(null,2,(5),inst_21309,inst_21311,null));
var state_21348__$1 = state_21348;
var statearr_21350_21455 = state_21348__$1;
(statearr_21350_21455[(2)] = inst_21312);

(statearr_21350_21455[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (70))){
var inst_21324 = (state_21348[(2)]);
var state_21348__$1 = state_21348;
var statearr_21351_21456 = state_21348__$1;
(statearr_21351_21456[(2)] = inst_21324);

(statearr_21351_21456[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (62))){
var inst_21298 = (state_21348[(8)]);
var inst_21306 = cljs.core.second.call(null,inst_21298);
var inst_21307 = clojure.string.starts_with_QMARK_.call(null,inst_21306,"fullText:");
var state_21348__$1 = state_21348;
if(inst_21307){
var statearr_21352_21457 = state_21348__$1;
(statearr_21352_21457[(1)] = (65));

} else {
var statearr_21353_21458 = state_21348__$1;
(statearr_21353_21458[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (7))){
var inst_21217 = (state_21348[(9)]);
var inst_21216 = cljs.core.count.call(null,clause);
var inst_21217__$1 = cljs.core._EQ_.call(null,(3),inst_21216);
var state_21348__$1 = (function (){var statearr_21354 = state_21348;
(statearr_21354[(9)] = inst_21217__$1);

return statearr_21354;
})();
if(inst_21217__$1){
var statearr_21355_21459 = state_21348__$1;
(statearr_21355_21459[(1)] = (31));

} else {
var statearr_21356_21460 = state_21348__$1;
(statearr_21356_21460[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (59))){
var inst_21331 = (state_21348[(2)]);
var state_21348__$1 = state_21348;
var statearr_21357_21461 = state_21348__$1;
(statearr_21357_21461[(2)] = inst_21331);

(statearr_21357_21461[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (20))){
var inst_21180 = (state_21348[(2)]);
var state_21348__$1 = state_21348;
var statearr_21358_21462 = state_21348__$1;
(statearr_21358_21462[(2)] = inst_21180);

(statearr_21358_21462[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (58))){
var state_21348__$1 = state_21348;
var statearr_21359_21463 = state_21348__$1;
(statearr_21359_21463[(2)] = null);

(statearr_21359_21463[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (60))){
var inst_21297 = (state_21348[(7)]);
var inst_21295 = (state_21348[(2)]);
var inst_21296 = fluree.db.util.async.throw_err.call(null,inst_21295);
var inst_21297__$1 = cljs.core.nth.call(null,inst_21296,(0),null);
var inst_21298 = cljs.core.nth.call(null,inst_21296,(1),null);
var inst_21299 = cljs.core._EQ_.call(null,"$wd",inst_21297__$1);
var state_21348__$1 = (function (){var statearr_21360 = state_21348;
(statearr_21360[(7)] = inst_21297__$1);

(statearr_21360[(8)] = inst_21298);

return statearr_21360;
})();
if(inst_21299){
var statearr_21361_21464 = state_21348__$1;
(statearr_21361_21464[(1)] = (61));

} else {
var statearr_21362_21465 = state_21348__$1;
(statearr_21362_21465[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (27))){
var inst_21210 = (state_21348[(2)]);
var state_21348__$1 = state_21348;
var statearr_21363_21466 = state_21348__$1;
(statearr_21363_21466[(2)] = inst_21210);

(statearr_21363_21466[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (1))){
var state_21348__$1 = state_21348;
var statearr_21364_21467 = state_21348__$1;
(statearr_21364_21467[(2)] = null);

(statearr_21364_21467[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (69))){
var state_21348__$1 = state_21348;
var statearr_21365_21468 = state_21348__$1;
(statearr_21365_21468[(2)] = null);

(statearr_21365_21468[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (24))){
var inst_21174 = (state_21348[(2)]);
var state_21348__$1 = state_21348;
var statearr_21366_21469 = state_21348__$1;
(statearr_21366_21469[(2)] = inst_21174);

(statearr_21366_21469[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (55))){
var inst_21280 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_21281 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21282 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21283 = cljs.core.PersistentHashMap.fromArrays(inst_21281,inst_21282);
var inst_21284 = cljs.core.ex_info.call(null,inst_21280,inst_21283);
var inst_21285 = (function(){throw inst_21284})();
var state_21348__$1 = state_21348;
var statearr_21367_21470 = state_21348__$1;
(statearr_21367_21470[(2)] = inst_21285);

(statearr_21367_21470[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (39))){
var inst_21237 = (state_21348[(2)]);
var state_21348__$1 = state_21348;
if(cljs.core.truth_(inst_21237)){
var statearr_21368_21471 = state_21348__$1;
(statearr_21368_21471[(1)] = (40));

} else {
var statearr_21369_21472 = state_21348__$1;
(statearr_21369_21472[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (46))){
var inst_21337 = (state_21348[(2)]);
var state_21348__$1 = state_21348;
var statearr_21370_21473 = state_21348__$1;
(statearr_21370_21473[(2)] = inst_21337);

(statearr_21370_21473[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (4))){
var inst_21112 = (state_21348[(2)]);
var state_21348__$1 = state_21348;
var statearr_21371_21474 = state_21348__$1;
(statearr_21371_21474[(2)] = inst_21112);

(statearr_21371_21474[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (54))){
var inst_21273 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_21274 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21275 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21276 = cljs.core.PersistentHashMap.fromArrays(inst_21274,inst_21275);
var inst_21277 = cljs.core.ex_info.call(null,inst_21273,inst_21276);
var inst_21278 = (function(){throw inst_21277})();
var state_21348__$1 = state_21348;
var statearr_21372_21475 = state_21348__$1;
(statearr_21372_21475[(2)] = inst_21278);

(statearr_21372_21475[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (15))){
var inst_21212 = (state_21348[(2)]);
var state_21348__$1 = state_21348;
var statearr_21373_21476 = state_21348__$1;
(statearr_21373_21476[(2)] = inst_21212);

(statearr_21373_21476[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (48))){
var inst_21261 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21262 = fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,clause);
var inst_21263 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_21262);
var inst_21264 = [inst_21263,r];
var inst_21265 = (new cljs.core.PersistentVector(null,2,(5),inst_21261,inst_21264,null));
var state_21348__$1 = state_21348;
var statearr_21374_21477 = state_21348__$1;
(statearr_21374_21477[(2)] = inst_21265);

(statearr_21374_21477[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (50))){
var inst_21335 = (state_21348[(2)]);
var state_21348__$1 = state_21348;
var statearr_21375_21478 = state_21348__$1;
(statearr_21375_21478[(2)] = inst_21335);

(statearr_21375_21478[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (21))){
var inst_21149 = (state_21348[(10)]);
var inst_21146 = (state_21348[(11)]);
var inst_21148 = (state_21348[(12)]);
var inst_21125 = (state_21348[(13)]);
var inst_21157 = (state_21348[(14)]);
var inst_21150 = (state_21348[(15)]);
var inst_21121 = (state_21348[(16)]);
var inst_21151 = (state_21348[(17)]);
var inst_21158 = (state_21348[(18)]);
var inst_21162 = (state_21348[(2)]);
var inst_21163 = fluree.db.util.async.throw_err.call(null,inst_21162);
var inst_21164 = (function (){var new_res = inst_21163;
var vec__21153 = inst_21150;
var rest = inst_21158;
var seq__21154 = inst_21158;
var first__21155 = inst_21157;
var first__21145 = inst_21148;
var expr__21123 = inst_21121;
var seq__21144 = inst_21149;
var tuples = inst_21151;
var vec__21143 = inst_21146;
var pred__21122 = inst_21125;
var segment_type = inst_21121;
var G__21142 = inst_21150;
var clause_group = inst_21157;
return (function (res__$1,var$){
return cljs.core.update.call(null,new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_21165 = cljs.core.keys.call(null,vars);
var inst_21166 = cljs.core.reduce.call(null,inst_21164,inst_21163,inst_21165);
var inst_21167 = fluree.db.query.analytical.res_absorb_vars.call(null,inst_21166);
var state_21348__$1 = (function (){var statearr_21376 = state_21348;
(statearr_21376[(19)] = inst_21167);

return statearr_21376;
})();
if(cljs.core.truth_(inst_21151)){
var statearr_21377_21479 = state_21348__$1;
(statearr_21377_21479[(1)] = (22));

} else {
var statearr_21378_21480 = state_21348__$1;
(statearr_21378_21480[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (31))){
var inst_21219 = cljs.core.second.call(null,clause);
var inst_21220 = clojure.string.starts_with_QMARK_.call(null,inst_21219,"fullText:");
var state_21348__$1 = state_21348;
var statearr_21379_21481 = state_21348__$1;
(statearr_21379_21481[(2)] = inst_21220);

(statearr_21379_21481[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (32))){
var inst_21217 = (state_21348[(9)]);
var state_21348__$1 = state_21348;
var statearr_21380_21482 = state_21348__$1;
(statearr_21380_21482[(2)] = inst_21217);

(statearr_21380_21482[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (40))){
var inst_21239 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21240 = fluree.db.query.analytical.collection__GT_tuples.call(null,db,res,clause);
var state_21348__$1 = (function (){var statearr_21381 = state_21348;
(statearr_21381[(20)] = inst_21239);

return statearr_21381;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21348__$1,(43),inst_21240);
} else {
if((state_val_21349 === (56))){
var inst_21287 = (state_21348[(2)]);
var state_21348__$1 = state_21348;
var statearr_21382_21483 = state_21348__$1;
(statearr_21382_21483[(2)] = inst_21287);

(statearr_21382_21483[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (33))){
var inst_21223 = (state_21348[(2)]);
var state_21348__$1 = state_21348;
if(cljs.core.truth_(inst_21223)){
var statearr_21383_21484 = state_21348__$1;
(statearr_21383_21484[(1)] = (34));

} else {
var statearr_21384_21485 = state_21348__$1;
(statearr_21384_21485[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (13))){
var inst_21146 = (state_21348[(11)]);
var inst_21146__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21147 = cljs.core.seq.call(null,inst_21146__$1);
var inst_21148 = cljs.core.first.call(null,inst_21147);
var inst_21149 = cljs.core.next.call(null,inst_21147);
var inst_21150 = inst_21146__$1;
var inst_21151 = null;
var state_21348__$1 = (function (){var statearr_21385 = state_21348;
(statearr_21385[(10)] = inst_21149);

(statearr_21385[(11)] = inst_21146__$1);

(statearr_21385[(12)] = inst_21148);

(statearr_21385[(15)] = inst_21150);

(statearr_21385[(17)] = inst_21151);

return statearr_21385;
})();
var statearr_21386_21486 = state_21348__$1;
(statearr_21386_21486[(2)] = null);

(statearr_21386_21486[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (22))){
var inst_21167 = (state_21348[(19)]);
var inst_21151 = (state_21348[(17)]);
var inst_21158 = (state_21348[(18)]);
var inst_21169 = fluree.db.query.union.results.call(null,inst_21151,inst_21167);
var inst_21150 = inst_21158;
var inst_21151__$1 = inst_21169;
var state_21348__$1 = (function (){var statearr_21387 = state_21348;
(statearr_21387[(15)] = inst_21150);

(statearr_21387[(17)] = inst_21151__$1);

return statearr_21387;
})();
var statearr_21388_21487 = state_21348__$1;
(statearr_21388_21487[(2)] = null);

(statearr_21388_21487[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (36))){
var inst_21341 = (state_21348[(2)]);
var state_21348__$1 = state_21348;
var statearr_21389_21488 = state_21348__$1;
(statearr_21389_21488[(2)] = inst_21341);

(statearr_21389_21488[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (41))){
var inst_21247 = cljs.core.count.call(null,clause);
var inst_21248 = cljs.core._EQ_.call(null,(3),inst_21247);
var state_21348__$1 = state_21348;
if(inst_21248){
var statearr_21390_21489 = state_21348__$1;
(statearr_21390_21489[(1)] = (44));

} else {
var statearr_21391_21490 = state_21348__$1;
(statearr_21391_21490[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (43))){
var inst_21239 = (state_21348[(20)]);
var inst_21242 = (state_21348[(2)]);
var inst_21243 = fluree.db.util.async.throw_err.call(null,inst_21242);
var inst_21244 = [inst_21243,r];
var inst_21245 = (new cljs.core.PersistentVector(null,2,(5),inst_21239,inst_21244,null));
var state_21348__$1 = state_21348;
var statearr_21392_21491 = state_21348__$1;
(statearr_21392_21491[(2)] = inst_21245);

(statearr_21392_21491[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (61))){
var inst_21298 = (state_21348[(8)]);
var inst_21301 = fluree.db.query.analytical.wikidata__GT_tuples.call(null,q_map,inst_21298,r,res,optional_QMARK_,fuel,max_fuel);
var state_21348__$1 = state_21348;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21348__$1,(64),inst_21301);
} else {
if((state_val_21349 === (29))){
var inst_21121 = (state_21348[(16)]);
var inst_21204 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_21121)].join('');
var inst_21205 = (new Error(inst_21204));
var inst_21206 = (function(){throw inst_21205})();
var state_21348__$1 = state_21348;
var statearr_21393_21492 = state_21348__$1;
(statearr_21393_21492[(2)] = inst_21206);

(statearr_21393_21492[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (44))){
var inst_21250 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21251 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,db,res,clause,fuel,max_fuel);
var state_21348__$1 = (function (){var statearr_21394 = state_21348;
(statearr_21394[(21)] = inst_21250);

return statearr_21394;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21348__$1,(47),inst_21251);
} else {
if((state_val_21349 === (6))){
var inst_21125 = (state_21348[(13)]);
var inst_21121 = (state_21348[(16)]);
var inst_21120 = cljs.core.keys.call(null,clause);
var inst_21121__$1 = cljs.core.first.call(null,inst_21120);
var inst_21125__$1 = cljs.core._EQ_;
var inst_21126 = inst_21125__$1.call(null,new cljs.core.Keyword(null,"optional","optional",2053951509),inst_21121__$1);
var state_21348__$1 = (function (){var statearr_21395 = state_21348;
(statearr_21395[(13)] = inst_21125__$1);

(statearr_21395[(16)] = inst_21121__$1);

return statearr_21395;
})();
if(cljs.core.truth_(inst_21126)){
var statearr_21396_21493 = state_21348__$1;
(statearr_21396_21493[(1)] = (9));

} else {
var statearr_21397_21494 = state_21348__$1;
(statearr_21397_21494[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (28))){
var inst_21198 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21199 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21200 = fluree.db.query.analytical.tuples__GT_filtered.call(null,res,inst_21199,optional_QMARK_);
var inst_21201 = [inst_21200,r];
var inst_21202 = (new cljs.core.PersistentVector(null,2,(5),inst_21198,inst_21201,null));
var state_21348__$1 = state_21348;
var statearr_21398_21495 = state_21348__$1;
(statearr_21398_21495[(2)] = inst_21202);

(statearr_21398_21495[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (64))){
var inst_21303 = (state_21348[(2)]);
var inst_21304 = fluree.db.util.async.throw_err.call(null,inst_21303);
var state_21348__$1 = state_21348;
var statearr_21399_21496 = state_21348__$1;
(statearr_21399_21496[(2)] = inst_21304);

(statearr_21399_21496[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (51))){
var inst_21270 = cljs.core.first.call(null,clause);
var inst_21271 = cljs.core.sequential_QMARK_.call(null,inst_21270);
var state_21348__$1 = state_21348;
if(inst_21271){
var statearr_21400_21497 = state_21348__$1;
(statearr_21400_21497[(1)] = (54));

} else {
var statearr_21401_21498 = state_21348__$1;
(statearr_21401_21498[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (25))){
var inst_21125 = (state_21348[(13)]);
var inst_21121 = (state_21348[(16)]);
var inst_21186 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21187 = (function (){var segment_type = inst_21121;
var pred__21122 = inst_21125;
var expr__21123 = inst_21121;
var bindings = inst_21186;
return (function (p1__21107_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,p1__21107_SHARP_);
});
})();
var inst_21188 = cljs.core.map.call(null,inst_21187,inst_21186);
var inst_21189 = cljs.core.PersistentHashMap.EMPTY;
var inst_21190 = cljs.core.into.call(null,inst_21189,inst_21188);
var inst_21191 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21192 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_21190);
var inst_21193 = [inst_21192,r];
var inst_21194 = (new cljs.core.PersistentVector(null,2,(5),inst_21191,inst_21193,null));
var state_21348__$1 = state_21348;
var statearr_21402_21499 = state_21348__$1;
(statearr_21402_21499[(2)] = inst_21194);

(statearr_21402_21499[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (34))){
var inst_21225 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21226 = fluree.db.query.analytical.full_text__GT_tuples.call(null,db,res,clause);
var inst_21227 = [inst_21226,r];
var inst_21228 = (new cljs.core.PersistentVector(null,2,(5),inst_21225,inst_21227,null));
var state_21348__$1 = state_21348;
var statearr_21403_21500 = state_21348__$1;
(statearr_21403_21500[(2)] = inst_21228);

(statearr_21403_21500[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (17))){
var inst_21182 = (state_21348[(2)]);
var state_21348__$1 = state_21348;
var statearr_21404_21501 = state_21348__$1;
(statearr_21404_21501[(2)] = inst_21182);

(statearr_21404_21501[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (3))){
var inst_21346 = (state_21348[(2)]);
var state_21348__$1 = state_21348;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21348__$1,inst_21346);
} else {
if((state_val_21349 === (12))){
var inst_21128 = (state_21348[(22)]);
var inst_21132 = (state_21348[(2)]);
var inst_21133 = fluree.db.util.async.throw_err.call(null,inst_21132);
var inst_21134 = [inst_21133,r];
var inst_21135 = (new cljs.core.PersistentVector(null,2,(5),inst_21128,inst_21134,null));
var state_21348__$1 = state_21348;
var statearr_21405_21502 = state_21348__$1;
(statearr_21405_21502[(2)] = inst_21135);

(statearr_21405_21502[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (2))){
var _ = (function (){var statearr_21406 = state_21348;
(statearr_21406[(4)] = cljs.core.cons.call(null,(5),(state_21348[(4)])));

return statearr_21406;
})();
var inst_21118 = cljs.core.map_QMARK_.call(null,clause);
var state_21348__$1 = state_21348;
if(inst_21118){
var statearr_21407_21503 = state_21348__$1;
(statearr_21407_21503[(1)] = (6));

} else {
var statearr_21408_21504 = state_21348__$1;
(statearr_21408_21504[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (66))){
var state_21348__$1 = state_21348;
var statearr_21409_21505 = state_21348__$1;
(statearr_21409_21505[(1)] = (68));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (23))){
var inst_21167 = (state_21348[(19)]);
var inst_21158 = (state_21348[(18)]);
var inst_21150 = inst_21158;
var inst_21151 = inst_21167;
var state_21348__$1 = (function (){var statearr_21411 = state_21348;
(statearr_21411[(15)] = inst_21150);

(statearr_21411[(17)] = inst_21151);

return statearr_21411;
})();
var statearr_21412_21506 = state_21348__$1;
(statearr_21412_21506[(2)] = null);

(statearr_21412_21506[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (47))){
var inst_21250 = (state_21348[(21)]);
var inst_21253 = (state_21348[(2)]);
var inst_21254 = fluree.db.util.async.throw_err.call(null,inst_21253);
var inst_21255 = [inst_21254,r];
var inst_21256 = (new cljs.core.PersistentVector(null,2,(5),inst_21250,inst_21255,null));
var state_21348__$1 = state_21348;
var statearr_21413_21507 = state_21348__$1;
(statearr_21413_21507[(2)] = inst_21256);

(statearr_21413_21507[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (35))){
var inst_21231 = (state_21348[(23)]);
var inst_21230 = cljs.core.count.call(null,clause);
var inst_21231__$1 = cljs.core._EQ_.call(null,(3),inst_21230);
var state_21348__$1 = (function (){var statearr_21414 = state_21348;
(statearr_21414[(23)] = inst_21231__$1);

return statearr_21414;
})();
if(inst_21231__$1){
var statearr_21415_21508 = state_21348__$1;
(statearr_21415_21508[(1)] = (37));

} else {
var statearr_21416_21509 = state_21348__$1;
(statearr_21416_21509[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (19))){
var inst_21151 = (state_21348[(17)]);
var inst_21176 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21177 = [inst_21151,r];
var inst_21178 = (new cljs.core.PersistentVector(null,2,(5),inst_21176,inst_21177,null));
var state_21348__$1 = state_21348;
var statearr_21417_21510 = state_21348__$1;
(statearr_21417_21510[(2)] = inst_21178);

(statearr_21417_21510[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (57))){
var inst_21293 = fluree.db.query.analytical.get_source_clause.call(null,db,clause,prefixes,opts);
var state_21348__$1 = state_21348;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21348__$1,(60),inst_21293);
} else {
if((state_val_21349 === (68))){
var inst_21297 = (state_21348[(7)]);
var inst_21298 = (state_21348[(8)]);
var inst_21315 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21316 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,inst_21297,res,inst_21298,fuel,max_fuel);
var state_21348__$1 = (function (){var statearr_21418 = state_21348;
(statearr_21418[(24)] = inst_21315);

return statearr_21418;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21348__$1,(71),inst_21316);
} else {
if((state_val_21349 === (11))){
var inst_21214 = (state_21348[(2)]);
var state_21348__$1 = state_21348;
var statearr_21420_21511 = state_21348__$1;
(statearr_21420_21511[(2)] = inst_21214);

(statearr_21420_21511[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (9))){
var inst_21128 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21129 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21130 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_21129,res,fuel,max_fuel,opts);
var state_21348__$1 = (function (){var statearr_21421 = state_21348;
(statearr_21421[(22)] = inst_21128);

return statearr_21421;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21348__$1,(12),inst_21130);
} else {
if((state_val_21349 === (5))){
var _ = (function (){var statearr_21422 = state_21348;
(statearr_21422[(4)] = cljs.core.rest.call(null,(state_21348[(4)])));

return statearr_21422;
})();
var state_21348__$1 = state_21348;
var ex21419 = (state_21348__$1[(2)]);
var statearr_21423_21512 = state_21348__$1;
(statearr_21423_21512[(5)] = ex21419);


if((ex21419 instanceof Error)){
var statearr_21424_21513 = state_21348__$1;
(statearr_21424_21513[(1)] = (4));

(statearr_21424_21513[(5)] = null);

} else {
throw ex21419;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (14))){
var inst_21125 = (state_21348[(13)]);
var inst_21121 = (state_21348[(16)]);
var inst_21184 = inst_21125.call(null,new cljs.core.Keyword(null,"bind","bind",-113428417),inst_21121);
var state_21348__$1 = state_21348;
if(cljs.core.truth_(inst_21184)){
var statearr_21425_21514 = state_21348__$1;
(statearr_21425_21514[(1)] = (25));

} else {
var statearr_21426_21515 = state_21348__$1;
(statearr_21426_21515[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (45))){
var inst_21258 = cljs.core.count.call(null,clause);
var inst_21259 = cljs.core._EQ_.call(null,(2),inst_21258);
var state_21348__$1 = state_21348;
if(inst_21259){
var statearr_21427_21516 = state_21348__$1;
(statearr_21427_21516[(1)] = (48));

} else {
var statearr_21428_21517 = state_21348__$1;
(statearr_21428_21517[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (53))){
var inst_21333 = (state_21348[(2)]);
var state_21348__$1 = state_21348;
var statearr_21429_21518 = state_21348__$1;
(statearr_21429_21518[(2)] = inst_21333);

(statearr_21429_21518[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (26))){
var inst_21125 = (state_21348[(13)]);
var inst_21121 = (state_21348[(16)]);
var inst_21196 = inst_21125.call(null,new cljs.core.Keyword(null,"filter","filter",-948537934),inst_21121);
var state_21348__$1 = state_21348;
if(cljs.core.truth_(inst_21196)){
var statearr_21430_21519 = state_21348__$1;
(statearr_21430_21519[(1)] = (28));

} else {
var statearr_21431_21520 = state_21348__$1;
(statearr_21431_21520[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (16))){
var inst_21157 = (state_21348[(14)]);
var inst_21150 = (state_21348[(15)]);
var inst_21156 = cljs.core.seq.call(null,inst_21150);
var inst_21157__$1 = cljs.core.first.call(null,inst_21156);
var inst_21158 = cljs.core.next.call(null,inst_21156);
var state_21348__$1 = (function (){var statearr_21432 = state_21348;
(statearr_21432[(14)] = inst_21157__$1);

(statearr_21432[(18)] = inst_21158);

return statearr_21432;
})();
if(cljs.core.truth_(inst_21157__$1)){
var statearr_21433_21521 = state_21348__$1;
(statearr_21433_21521[(1)] = (18));

} else {
var statearr_21434_21522 = state_21348__$1;
(statearr_21434_21522[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (38))){
var inst_21231 = (state_21348[(23)]);
var state_21348__$1 = state_21348;
var statearr_21435_21523 = state_21348__$1;
(statearr_21435_21523[(2)] = inst_21231);

(statearr_21435_21523[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (30))){
var inst_21208 = (state_21348[(2)]);
var state_21348__$1 = state_21348;
var statearr_21436_21524 = state_21348__$1;
(statearr_21436_21524[(2)] = inst_21208);

(statearr_21436_21524[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (10))){
var inst_21125 = (state_21348[(13)]);
var inst_21121 = (state_21348[(16)]);
var inst_21137 = inst_21125.call(null,new cljs.core.Keyword(null,"union","union",2142937499),inst_21121);
var state_21348__$1 = state_21348;
if(cljs.core.truth_(inst_21137)){
var statearr_21437_21525 = state_21348__$1;
(statearr_21437_21525[(1)] = (13));

} else {
var statearr_21438_21526 = state_21348__$1;
(statearr_21438_21526[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (18))){
var inst_21157 = (state_21348[(14)]);
var inst_21160 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_21157,q_map,vars,fuel,max_fuel,opts);
var state_21348__$1 = state_21348;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21348__$1,(21),inst_21160);
} else {
if((state_val_21349 === (52))){
var state_21348__$1 = state_21348;
var statearr_21439_21527 = state_21348__$1;
(statearr_21439_21527[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (67))){
var inst_21326 = (state_21348[(2)]);
var state_21348__$1 = state_21348;
var statearr_21441_21528 = state_21348__$1;
(statearr_21441_21528[(2)] = inst_21326);

(statearr_21441_21528[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (71))){
var inst_21315 = (state_21348[(24)]);
var inst_21318 = (state_21348[(2)]);
var inst_21319 = fluree.db.util.async.throw_err.call(null,inst_21318);
var inst_21320 = [inst_21319,r];
var inst_21321 = (new cljs.core.PersistentVector(null,2,(5),inst_21315,inst_21320,null));
var state_21348__$1 = state_21348;
var statearr_21442_21529 = state_21348__$1;
(statearr_21442_21529[(2)] = inst_21321);

(statearr_21442_21529[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (42))){
var inst_21339 = (state_21348[(2)]);
var state_21348__$1 = state_21348;
var statearr_21443_21530 = state_21348__$1;
(statearr_21443_21530[(2)] = inst_21339);

(statearr_21443_21530[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (37))){
var inst_21233 = cljs.core.second.call(null,clause);
var inst_21234 = cljs.core._EQ_.call(null,inst_21233,"rdf:type");
var state_21348__$1 = state_21348;
var statearr_21444_21531 = state_21348__$1;
(statearr_21444_21531[(2)] = inst_21234);

(statearr_21444_21531[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (63))){
var inst_21328 = (state_21348[(2)]);
var state_21348__$1 = state_21348;
var statearr_21445_21532 = state_21348__$1;
(statearr_21445_21532[(2)] = inst_21328);

(statearr_21445_21532[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (8))){
var inst_21343 = (state_21348[(2)]);
var _ = (function (){var statearr_21446 = state_21348;
(statearr_21446[(4)] = cljs.core.rest.call(null,(state_21348[(4)])));

return statearr_21446;
})();
var state_21348__$1 = state_21348;
var statearr_21447_21533 = state_21348__$1;
(statearr_21447_21533[(2)] = inst_21343);

(statearr_21447_21533[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21349 === (49))){
var inst_21267 = cljs.core.count.call(null,clause);
var inst_21268 = cljs.core._EQ_.call(null,(1),inst_21267);
var state_21348__$1 = state_21348;
if(inst_21268){
var statearr_21448_21534 = state_21348__$1;
(statearr_21448_21534[(1)] = (51));

} else {
var statearr_21449_21535 = state_21348__$1;
(statearr_21449_21535[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_21450 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21450[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__);

(statearr_21450[(1)] = (1));

return statearr_21450;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____1 = (function (state_21348){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_21348);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e21451){var ex__2749__auto__ = e21451;
var statearr_21452_21536 = state_21348;
(statearr_21452_21536[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_21348[(4)]))){
var statearr_21453_21537 = state_21348;
(statearr_21453_21537[(1)] = cljs.core.first.call(null,(state_21348[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21538 = state_21348;
state_21348 = G__21538;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__ = function(state_21348){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____1.call(this,state_21348);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_21454 = f__2769__auto__.call(null);
(statearr_21454[(6)] = c__2768__auto__);

return statearr_21454;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__21540 = arguments.length;
switch (G__21540) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.call(null,db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_21619){
var state_val_21620 = (state_21619[(1)]);
if((state_val_21620 === (7))){
var inst_21614 = (state_21619[(2)]);
var _ = (function (){var statearr_21621 = state_21619;
(statearr_21621[(4)] = cljs.core.rest.call(null,(state_21619[(4)])));

return statearr_21621;
})();
var state_21619__$1 = state_21619;
var statearr_21622_21670 = state_21619__$1;
(statearr_21622_21670[(2)] = inst_21614);

(statearr_21622_21670[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21620 === (20))){
var inst_21579 = (state_21619[(7)]);
var inst_21591 = (state_21619[(2)]);
var inst_21561 = inst_21579;
var inst_21562 = inst_21591;
var state_21619__$1 = (function (){var statearr_21623 = state_21619;
(statearr_21623[(8)] = inst_21562);

(statearr_21623[(9)] = inst_21561);

return statearr_21623;
})();
var statearr_21624_21671 = state_21619__$1;
(statearr_21624_21671[(2)] = null);

(statearr_21624_21671[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21620 === (1))){
var state_21619__$1 = state_21619;
var statearr_21625_21672 = state_21619__$1;
(statearr_21625_21672[(2)] = null);

(statearr_21625_21672[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21620 === (24))){
var inst_21562 = (state_21619[(8)]);
var inst_21578 = (state_21619[(10)]);
var inst_21579 = (state_21619[(7)]);
var inst_21599 = fluree.db.query.analytical.inner_join.call(null,inst_21562,inst_21578);
var inst_21561 = inst_21579;
var inst_21562__$1 = inst_21599;
var state_21619__$1 = (function (){var statearr_21626 = state_21619;
(statearr_21626[(8)] = inst_21562__$1);

(statearr_21626[(9)] = inst_21561);

return statearr_21626;
})();
var statearr_21627_21673 = state_21619__$1;
(statearr_21627_21673[(2)] = null);

(statearr_21627_21673[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21620 === (4))){
var inst_21541 = (state_21619[(2)]);
var state_21619__$1 = state_21619;
var statearr_21629_21674 = state_21619__$1;
(statearr_21629_21674[(2)] = inst_21541);

(statearr_21629_21674[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21620 === (15))){
var inst_21578 = (state_21619[(10)]);
var state_21619__$1 = state_21619;
if(cljs.core.truth_(inst_21578)){
var statearr_21630_21675 = state_21619__$1;
(statearr_21630_21675[(1)] = (18));

} else {
var statearr_21631_21676 = state_21619__$1;
(statearr_21631_21676[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21620 === (21))){
var inst_21562 = (state_21619[(8)]);
var inst_21579 = (state_21619[(7)]);
var tmp21628 = inst_21562;
var inst_21561 = inst_21579;
var inst_21562__$1 = tmp21628;
var state_21619__$1 = (function (){var statearr_21632 = state_21619;
(statearr_21632[(8)] = inst_21562__$1);

(statearr_21632[(9)] = inst_21561);

return statearr_21632;
})();
var statearr_21633_21677 = state_21619__$1;
(statearr_21633_21677[(2)] = null);

(statearr_21633_21677[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21620 === (13))){
var inst_21562 = (state_21619[(8)]);
var inst_21585 = cljs.core.dissoc.call(null,inst_21562,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_21586 = cljs.core.empty_QMARK_.call(null,inst_21585);
var state_21619__$1 = state_21619;
if(inst_21586){
var statearr_21634_21678 = state_21619__$1;
(statearr_21634_21678[(1)] = (15));

} else {
var statearr_21635_21679 = state_21619__$1;
(statearr_21635_21679[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21620 === (22))){
var state_21619__$1 = state_21619;
var statearr_21636_21680 = state_21619__$1;
(statearr_21636_21680[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21620 === (6))){
var inst_21568 = (state_21619[(11)]);
var inst_21561 = (state_21619[(9)]);
var inst_21567 = cljs.core.seq.call(null,inst_21561);
var inst_21568__$1 = cljs.core.first.call(null,inst_21567);
var inst_21569 = cljs.core.next.call(null,inst_21567);
var state_21619__$1 = (function (){var statearr_21638 = state_21619;
(statearr_21638[(12)] = inst_21569);

(statearr_21638[(11)] = inst_21568__$1);

return statearr_21638;
})();
if(cljs.core.truth_(inst_21568__$1)){
var statearr_21639_21681 = state_21619__$1;
(statearr_21639_21681[(1)] = (8));

} else {
var statearr_21640_21682 = state_21619__$1;
(statearr_21640_21682[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21620 === (25))){
var state_21619__$1 = state_21619;
var statearr_21641_21683 = state_21619__$1;
(statearr_21641_21683[(2)] = null);

(statearr_21641_21683[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21620 === (17))){
var inst_21607 = (state_21619[(2)]);
var state_21619__$1 = state_21619;
var statearr_21642_21684 = state_21619__$1;
(statearr_21642_21684[(2)] = inst_21607);

(statearr_21642_21684[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21620 === (3))){
var inst_21617 = (state_21619[(2)]);
var state_21619__$1 = state_21619;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21619__$1,inst_21617);
} else {
if((state_val_21620 === (12))){
var inst_21578 = (state_21619[(10)]);
var inst_21579 = (state_21619[(7)]);
var inst_21561 = inst_21579;
var inst_21562 = inst_21578;
var state_21619__$1 = (function (){var statearr_21643 = state_21619;
(statearr_21643[(8)] = inst_21562);

(statearr_21643[(9)] = inst_21561);

return statearr_21643;
})();
var statearr_21644_21685 = state_21619__$1;
(statearr_21644_21685[(2)] = null);

(statearr_21644_21685[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21620 === (2))){
var _ = (function (){var statearr_21645 = state_21619;
(statearr_21645[(4)] = cljs.core.cons.call(null,(5),(state_21619[(4)])));

return statearr_21645;
})();
var inst_21554 = where;
var inst_21555 = cljs.core.seq.call(null,inst_21554);
var inst_21556 = cljs.core.first.call(null,inst_21555);
var inst_21557 = cljs.core.next.call(null,inst_21555);
var inst_21558 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_21559 = [vars];
var inst_21560 = cljs.core.PersistentHashMap.fromArrays(inst_21558,inst_21559);
var inst_21561 = inst_21554;
var inst_21562 = inst_21560;
var state_21619__$1 = (function (){var statearr_21646 = state_21619;
(statearr_21646[(8)] = inst_21562);

(statearr_21646[(13)] = inst_21556);

(statearr_21646[(9)] = inst_21561);

(statearr_21646[(14)] = inst_21557);

return statearr_21646;
})();
var statearr_21647_21686 = state_21619__$1;
(statearr_21647_21686[(2)] = null);

(statearr_21647_21686[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21620 === (23))){
var inst_21605 = (state_21619[(2)]);
var state_21619__$1 = state_21619;
var statearr_21648_21687 = state_21619__$1;
(statearr_21648_21687[(2)] = inst_21605);

(statearr_21648_21687[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21620 === (19))){
var inst_21562 = (state_21619[(8)]);
var state_21619__$1 = state_21619;
var statearr_21649_21688 = state_21619__$1;
(statearr_21649_21688[(2)] = inst_21562);

(statearr_21649_21688[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21620 === (11))){
var inst_21568 = (state_21619[(11)]);
var inst_21576 = (state_21619[(2)]);
var inst_21577 = fluree.db.util.async.throw_err.call(null,inst_21576);
var inst_21578 = cljs.core.nth.call(null,inst_21577,(0),null);
var inst_21579 = cljs.core.nth.call(null,inst_21577,(1),null);
var inst_21580 = cljs.core.count.call(null,inst_21568);
var inst_21581 = cljs.core._EQ_.call(null,(2),inst_21580);
var state_21619__$1 = (function (){var statearr_21651 = state_21619;
(statearr_21651[(10)] = inst_21578);

(statearr_21651[(7)] = inst_21579);

return statearr_21651;
})();
if(inst_21581){
var statearr_21652_21689 = state_21619__$1;
(statearr_21652_21689[(1)] = (12));

} else {
var statearr_21653_21690 = state_21619__$1;
(statearr_21653_21690[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21620 === (9))){
var inst_21562 = (state_21619[(8)]);
var state_21619__$1 = state_21619;
var statearr_21654_21691 = state_21619__$1;
(statearr_21654_21691[(2)] = inst_21562);

(statearr_21654_21691[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21620 === (5))){
var _ = (function (){var statearr_21655 = state_21619;
(statearr_21655[(4)] = cljs.core.rest.call(null,(state_21619[(4)])));

return statearr_21655;
})();
var state_21619__$1 = state_21619;
var ex21650 = (state_21619__$1[(2)]);
var statearr_21656_21692 = state_21619__$1;
(statearr_21656_21692[(5)] = ex21650);


if((ex21650 instanceof Error)){
var statearr_21657_21693 = state_21619__$1;
(statearr_21657_21693[(1)] = (4));

(statearr_21657_21693[(5)] = null);

} else {
throw ex21650;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21620 === (14))){
var inst_21609 = (state_21619[(2)]);
var state_21619__$1 = state_21619;
var statearr_21658_21694 = state_21619__$1;
(statearr_21658_21694[(2)] = inst_21609);

(statearr_21658_21694[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21620 === (26))){
var inst_21603 = (state_21619[(2)]);
var state_21619__$1 = state_21619;
var statearr_21659_21695 = state_21619__$1;
(statearr_21659_21695[(2)] = inst_21603);

(statearr_21659_21695[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21620 === (16))){
var inst_21578 = (state_21619[(10)]);
var inst_21594 = (inst_21578 == null);
var state_21619__$1 = state_21619;
if(cljs.core.truth_(inst_21594)){
var statearr_21660_21696 = state_21619__$1;
(statearr_21660_21696[(1)] = (21));

} else {
var statearr_21661_21697 = state_21619__$1;
(statearr_21661_21697[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21620 === (10))){
var inst_21612 = (state_21619[(2)]);
var state_21619__$1 = state_21619;
var statearr_21662_21698 = state_21619__$1;
(statearr_21662_21698[(2)] = inst_21612);

(statearr_21662_21698[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21620 === (18))){
var inst_21578 = (state_21619[(10)]);
var state_21619__$1 = state_21619;
var statearr_21663_21699 = state_21619__$1;
(statearr_21663_21699[(2)] = inst_21578);

(statearr_21663_21699[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21620 === (8))){
var inst_21569 = (state_21619[(12)]);
var inst_21562 = (state_21619[(8)]);
var inst_21568 = (state_21619[(11)]);
var inst_21574 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_21562,inst_21568,inst_21569,false,fuel,max_fuel,opts);
var state_21619__$1 = state_21619;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21619__$1,(11),inst_21574);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2746__auto__ = null;
var fluree$db$query$analytical$state_machine__2746__auto____0 = (function (){
var statearr_21664 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21664[(0)] = fluree$db$query$analytical$state_machine__2746__auto__);

(statearr_21664[(1)] = (1));

return statearr_21664;
});
var fluree$db$query$analytical$state_machine__2746__auto____1 = (function (state_21619){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_21619);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e21665){var ex__2749__auto__ = e21665;
var statearr_21666_21700 = state_21619;
(statearr_21666_21700[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_21619[(4)]))){
var statearr_21667_21701 = state_21619;
(statearr_21667_21701[(1)] = cljs.core.first.call(null,(state_21619[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21702 = state_21619;
state_21619 = G__21702;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2746__auto__ = function(state_21619){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2746__auto____1.call(this,state_21619);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2746__auto____0;
fluree$db$query$analytical$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2746__auto____1;
return fluree$db$query$analytical$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_21668 = f__2769__auto__.call(null);
(statearr_21668[(6)] = c__2768__auto__);

return statearr_21668;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(p__21703){
var map__21704 = p__21703;
var map__21704__$1 = cljs.core.__destructure_map.call(null,map__21704);
var opts = map__21704__$1;
var vars = cljs.core.get.call(null,map__21704__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var query_map = cljs.core.get.call(null,map__21704__$1,new cljs.core.Keyword(null,"query-map","query-map",-808576972));
var fuel = cljs.core.get.call(null,map__21704__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485));
var max_fuel = cljs.core.get.call(null,map__21704__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var db = cljs.core.get.call(null,map__21704__$1,new cljs.core.Keyword(null,"db","db",993250759));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_21738){
var state_val_21739 = (state_21738[(1)]);
if((state_val_21739 === (7))){
var inst_21715 = (state_21738[(7)]);
var inst_21720 = (state_21738[(8)]);
var inst_21722 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,query_map,inst_21715,inst_21720,fuel,max_fuel,opts);
var state_21738__$1 = state_21738;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21738__$1,(10),inst_21722);
} else {
if((state_val_21739 === (1))){
var state_21738__$1 = state_21738;
var statearr_21740_21765 = state_21738__$1;
(statearr_21740_21765[(2)] = null);

(statearr_21740_21765[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21739 === (4))){
var inst_21705 = (state_21738[(2)]);
var state_21738__$1 = state_21738;
var statearr_21741_21766 = state_21738__$1;
(statearr_21741_21766[(2)] = inst_21705);

(statearr_21741_21766[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21739 === (13))){
var inst_21733 = (state_21738[(2)]);
var _ = (function (){var statearr_21742 = state_21738;
(statearr_21742[(4)] = cljs.core.rest.call(null,(state_21738[(4)])));

return statearr_21742;
})();
var state_21738__$1 = state_21738;
var statearr_21743_21767 = state_21738__$1;
(statearr_21743_21767[(2)] = inst_21733);

(statearr_21743_21767[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21739 === (6))){
var inst_21715 = (state_21738[(7)]);
var inst_21719 = (state_21738[(2)]);
var inst_21720 = fluree.db.util.async.throw_err.call(null,inst_21719);
var state_21738__$1 = (function (){var statearr_21744 = state_21738;
(statearr_21744[(8)] = inst_21720);

return statearr_21744;
})();
if(cljs.core.truth_(inst_21715)){
var statearr_21745_21768 = state_21738__$1;
(statearr_21745_21768[(1)] = (7));

} else {
var statearr_21746_21769 = state_21738__$1;
(statearr_21746_21769[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21739 === (3))){
var inst_21736 = (state_21738[(2)]);
var state_21738__$1 = state_21738;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21738__$1,inst_21736);
} else {
if((state_val_21739 === (12))){
var inst_21728 = (state_21738[(9)]);
var state_21738__$1 = state_21738;
var statearr_21747_21770 = state_21738__$1;
(statearr_21747_21770[(2)] = inst_21728);

(statearr_21747_21770[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21739 === (2))){
var _ = (function (){var statearr_21748 = state_21738;
(statearr_21748[(4)] = cljs.core.cons.call(null,(5),(state_21738[(4)])));

return statearr_21748;
})();
var inst_21712 = query_map;
var inst_21713 = cljs.core.__destructure_map.call(null,inst_21712);
var inst_21714 = cljs.core.get.call(null,inst_21713,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_21715 = cljs.core.get.call(null,inst_21713,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_21716 = cljs.core.get.call(null,inst_21713,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_21717 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_21714,query_map,vars,fuel,max_fuel,opts);
var state_21738__$1 = (function (){var statearr_21749 = state_21738;
(statearr_21749[(7)] = inst_21715);

(statearr_21749[(10)] = inst_21716);

return statearr_21749;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21738__$1,(6),inst_21717);
} else {
if((state_val_21739 === (11))){
var inst_21716 = (state_21738[(10)]);
var inst_21728 = (state_21738[(9)]);
var inst_21730 = fluree.db.query.analytical.tuples__GT_filtered.call(null,inst_21728,inst_21716,null);
var state_21738__$1 = state_21738;
var statearr_21751_21771 = state_21738__$1;
(statearr_21751_21771[(2)] = inst_21730);

(statearr_21751_21771[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21739 === (9))){
var inst_21716 = (state_21738[(10)]);
var inst_21728 = (state_21738[(2)]);
var state_21738__$1 = (function (){var statearr_21752 = state_21738;
(statearr_21752[(9)] = inst_21728);

return statearr_21752;
})();
if(cljs.core.truth_(inst_21716)){
var statearr_21753_21772 = state_21738__$1;
(statearr_21753_21772[(1)] = (11));

} else {
var statearr_21754_21773 = state_21738__$1;
(statearr_21754_21773[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21739 === (5))){
var _ = (function (){var statearr_21755 = state_21738;
(statearr_21755[(4)] = cljs.core.rest.call(null,(state_21738[(4)])));

return statearr_21755;
})();
var state_21738__$1 = state_21738;
var ex21750 = (state_21738__$1[(2)]);
var statearr_21756_21774 = state_21738__$1;
(statearr_21756_21774[(5)] = ex21750);


if((ex21750 instanceof Error)){
var statearr_21757_21775 = state_21738__$1;
(statearr_21757_21775[(1)] = (4));

(statearr_21757_21775[(5)] = null);

} else {
throw ex21750;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21739 === (10))){
var inst_21724 = (state_21738[(2)]);
var inst_21725 = fluree.db.util.async.throw_err.call(null,inst_21724);
var state_21738__$1 = state_21738;
var statearr_21758_21776 = state_21738__$1;
(statearr_21758_21776[(2)] = inst_21725);

(statearr_21758_21776[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21739 === (8))){
var inst_21720 = (state_21738[(8)]);
var state_21738__$1 = state_21738;
var statearr_21759_21777 = state_21738__$1;
(statearr_21759_21777[(2)] = inst_21720);

(statearr_21759_21777[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__2746__auto____0 = (function (){
var statearr_21760 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21760[(0)] = fluree$db$query$analytical$q_$_state_machine__2746__auto__);

(statearr_21760[(1)] = (1));

return statearr_21760;
});
var fluree$db$query$analytical$q_$_state_machine__2746__auto____1 = (function (state_21738){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_21738);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e21761){var ex__2749__auto__ = e21761;
var statearr_21762_21778 = state_21738;
(statearr_21762_21778[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_21738[(4)]))){
var statearr_21763_21779 = state_21738;
(statearr_21763_21779[(1)] = cljs.core.first.call(null,(state_21738[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21780 = state_21738;
state_21738 = G__21780;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__2746__auto__ = function(state_21738){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__2746__auto____1.call(this,state_21738);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__2746__auto____0;
fluree$db$query$analytical$q_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$q_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_21764 = f__2769__auto__.call(null);
(statearr_21764[(6)] = c__2768__auto__);

return statearr_21764;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
