// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.analytical_parse');
goog.require('fluree.db.query.subject_crawl.core');
goog.require('fluree.db.query.fql_resp');
/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__24734 = arguments.length;
switch (G__24734) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol)));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2,arg3));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__24737 = arguments.length;
switch (G__24737) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__24739 = null;
var G__24739__0 = (function (){
return xf.call(null);
});
var G__24739__1 = (function (result){
return xf.call(null,result);
});
var G__24739__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return xf.call(null,result,flake);
});
G__24739 = function(result,flake){
switch(arguments.length){
case 0:
return G__24739__0.call(this);
case 1:
return G__24739__1.call(this,result);
case 2:
return G__24739__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24739.cljs$core$IFn$_invoke$arity$0 = G__24739__0;
G__24739.cljs$core$IFn$_invoke$arity$1 = G__24739__1;
G__24739.cljs$core$IFn$_invoke$arity$2 = G__24739__2;
return G__24739;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare.call(null,clojure.string.upper_case.call(null,a),clojure.string.upper_case.call(null,b));
if(cljs.core._EQ_.call(null,res,(0))){
return ((-1) * cljs.core.compare.call(null,a,b));
} else {
return res;
}
} else {
return cljs.core.compare.call(null,a,b);
}
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.call(null,(function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies.call(null,vars);
if(cljs.core.every_QMARK_.call(null,(function (p1__24740_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__24740_SHARP_);
}),cljs.core.vals.call(null,freqs))){
return vars;
} else {
var G__24744 = vars;
var vec__24745 = G__24744;
var seq__24746 = cljs.core.seq.call(null,vec__24745);
var first__24747 = cljs.core.first.call(null,seq__24746);
var seq__24746__$1 = cljs.core.next.call(null,seq__24746);
var var$ = first__24747;
var r = seq__24746__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__24744__$1 = G__24744;
var all_vars__$1 = all_vars;
while(true){
var vec__24751 = G__24744__$1;
var seq__24752 = cljs.core.seq.call(null,vec__24751);
var first__24753 = cljs.core.first.call(null,seq__24752);
var seq__24752__$1 = cljs.core.next.call(null,seq__24752);
var var$__$1 = first__24753;
var r__$1 = seq__24752__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not.call(null,var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_(cljs.core.set.call(null,all_vars__$2).call(null,var$__$1))){
var G__24754 = r__$1;
var G__24755 = cljs.core.conj.call(null,all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,all_vars__$2))].join(''));
G__24744__$1 = G__24754;
all_vars__$1 = G__24755;
continue;
} else {
var G__24756 = r__$1;
var G__24757 = cljs.core.conj.call(null,all_vars__$2,var$__$1);
G__24744__$1 = G__24756;
all_vars__$1 = G__24757;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,cljs.core.map.call(null,cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.call(null,(function (idx,select_item){
var temp__5804__auto__ = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5804__auto__)){
var query_map = temp__5804__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.call(null,pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__24758){
var vec__24759 = p__24758;
var tuple_index = cljs.core.nth.call(null,vec__24759,(0),null);
var query_map = cljs.core.nth.call(null,vec__24759,(1),null);
var temp__5804__auto__ = cljs.core.get.call(null,tuple_result,tuple_index);
if(cljs.core.truth_(temp__5804__auto__)){
var _id = temp__5804__auto__;
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24773){
var state_val_24774 = (state_24773[(1)]);
if((state_val_24774 === (1))){
var inst_24762 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24763 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_24764 = [query_map,_id,query_opts];
var inst_24765 = cljs.core.PersistentHashMap.fromArrays(inst_24763,inst_24764);
var inst_24766 = fluree.db.query.fql.query.call(null,db,inst_24765);
var state_24773__$1 = (function (){var statearr_24775 = state_24773;
(statearr_24775[(7)] = inst_24762);

return statearr_24775;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24773__$1,(2),inst_24766);
} else {
if((state_val_24774 === (2))){
var inst_24762 = (state_24773[(7)]);
var inst_24768 = (state_24773[(2)]);
var inst_24769 = fluree.db.util.async.throw_err.call(null,inst_24768);
var inst_24770 = [tuple_index,inst_24769];
var inst_24771 = (new cljs.core.PersistentVector(null,2,(5),inst_24762,inst_24770,null));
var state_24773__$1 = state_24773;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24773__$1,inst_24771);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__2746__auto____0 = (function (){
var statearr_24776 = [null,null,null,null,null,null,null,null];
(statearr_24776[(0)] = fluree$db$query$fql$expand_map_$_state_machine__2746__auto__);

(statearr_24776[(1)] = (1));

return statearr_24776;
});
var fluree$db$query$fql$expand_map_$_state_machine__2746__auto____1 = (function (state_24773){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24773);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24777){var ex__2749__auto__ = e24777;
var statearr_24778_24781 = state_24773;
(statearr_24778_24781[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24773[(4)]))){
var statearr_24779_24782 = state_24773;
(statearr_24779_24782[(1)] = cljs.core.first.call(null,(state_24773[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24783 = state_24773;
state_24773 = G__24783;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__2746__auto__ = function(state_24773){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__2746__auto____1.call(this,state_24773);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__2746__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__2746__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24780 = f__2769__auto__.call(null);
(statearr_24780[(6)] = c__2768__auto__);

return statearr_24780;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_.call(null,expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__24784 = expand_map_tuple;
var tuple_index = cljs.core.nth.call(null,vec__24784,(0),null);
var query_map_result = cljs.core.nth.call(null,vec__24784,(1),null);
return cljs.core.assoc.call(null,tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24847){
var state_val_24848 = (state_24847[(1)]);
if((state_val_24848 === (7))){
var inst_24842 = (state_24847[(2)]);
var _ = (function (){var statearr_24849 = state_24847;
(statearr_24849[(4)] = cljs.core.rest.call(null,(state_24847[(4)])));

return statearr_24849;
})();
var state_24847__$1 = state_24847;
var statearr_24850_24941 = state_24847__$1;
(statearr_24850_24941[(2)] = inst_24842);

(statearr_24850_24941[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24848 === (20))){
var inst_24833 = (state_24847[(2)]);
var state_24847__$1 = state_24847;
var statearr_24851_24942 = state_24847__$1;
(statearr_24851_24942[(2)] = inst_24833);

(statearr_24851_24942[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24848 === (1))){
var state_24847__$1 = state_24847;
var statearr_24852_24943 = state_24847__$1;
(statearr_24852_24943[(2)] = null);

(statearr_24852_24943[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24848 === (4))){
var inst_24789 = (state_24847[(2)]);
var state_24847__$1 = state_24847;
var statearr_24853_24944 = state_24847__$1;
(statearr_24853_24944[(2)] = inst_24789);

(statearr_24853_24944[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24848 === (15))){
var inst_24809 = (state_24847[(7)]);
var inst_24818 = cljs.core.second.call(null,inst_24809);
var inst_24819 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_24818);
var inst_24820 = (inst_24819 > max_fuel);
var state_24847__$1 = state_24847;
if(cljs.core.truth_(inst_24820)){
var statearr_24854_24945 = state_24847__$1;
(statearr_24854_24945[(1)] = (18));

} else {
var statearr_24855_24946 = state_24847__$1;
(statearr_24855_24946[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24848 === (13))){
var state_24847__$1 = state_24847;
var statearr_24856_24947 = state_24847__$1;
(statearr_24856_24947[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24848 === (6))){
var inst_24797 = (state_24847[(8)]);
var state_24847__$1 = state_24847;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24847__$1,(8),inst_24797);
} else {
if((state_val_24848 === (17))){
var inst_24836 = (state_24847[(2)]);
var state_24847__$1 = state_24847;
var statearr_24858_24948 = state_24847__$1;
(statearr_24858_24948[(2)] = inst_24836);

(statearr_24858_24948[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24848 === (3))){
var inst_24845 = (state_24847[(2)]);
var state_24847__$1 = state_24847;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24847__$1,inst_24845);
} else {
if((state_val_24848 === (12))){
var inst_24809 = (state_24847[(7)]);
var inst_24798 = (state_24847[(9)]);
var inst_24815 = inst_24798.call(null);
var state_24847__$1 = (function (){var statearr_24859 = state_24847;
(statearr_24859[(10)] = inst_24815);

return statearr_24859;
})();
var statearr_24860_24949 = state_24847__$1;
(statearr_24860_24949[(2)] = inst_24809);

(statearr_24860_24949[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24848 === (2))){
var inst_24797 = (state_24847[(8)]);
var inst_24798 = (state_24847[(9)]);
var _ = (function (){var statearr_24861 = state_24847;
(statearr_24861[(4)] = cljs.core.cons.call(null,(5),(state_24847[(4)])));

return statearr_24861;
})();
var inst_24795 = fluree.db.query.fql.build_expand_map.call(null,select,pp_keys);
var inst_24796 = cljs.core.async.chan.call(null);
var inst_24797__$1 = cljs.core.async.chan.call(null);
var inst_24798__$1 = (function (){var expandMaps = inst_24795;
var queue_ch = inst_24796;
var res_ch = inst_24797__$1;
return (function (){
cljs.core.async.close_BANG_.call(null,queue_ch);

return cljs.core.async.close_BANG_.call(null,res_ch);
});
})();
var inst_24799 = cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var inst_24800 = cljs.core.volatile_BANG_.call(null,(0));
var inst_24801 = cljs.core.assoc.call(null,inst_24799,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_24800);
var inst_24802 = (function (){var expandMaps = inst_24795;
var queue_ch = inst_24796;
var res_ch = inst_24797__$1;
var stop_BANG_ = inst_24798__$1;
var opts_STAR_ = inst_24801;
return (function (tuple_res,port){
var c__2768__auto____$1 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24894){
var state_val_24895 = (state_24894[(1)]);
if((state_val_24895 === (7))){
var state_24894__$1 = state_24894;
var statearr_24896_24950 = state_24894__$1;
(statearr_24896_24950[(2)] = tuple_res);

(statearr_24896_24950[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24895 === (1))){
var state_24894__$1 = state_24894;
var statearr_24897_24951 = state_24894__$1;
(statearr_24897_24951[(2)] = null);

(statearr_24897_24951[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24895 === (4))){
var inst_24862 = (state_24894[(2)]);
var inst_24863 = cljs.core.async.put_BANG_.call(null,port,inst_24862);
var inst_24864 = cljs.core.async.close_BANG_.call(null,port);
var state_24894__$1 = (function (){var statearr_24898 = state_24894;
(statearr_24898[(7)] = inst_24863);

return statearr_24898;
})();
var statearr_24899_24952 = state_24894__$1;
(statearr_24899_24952[(2)] = inst_24864);

(statearr_24899_24952[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24895 === (6))){
var inst_24871 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24872 = [tuple_res];
var inst_24873 = (new cljs.core.PersistentVector(null,1,(5),inst_24871,inst_24872,null));
var state_24894__$1 = state_24894;
var statearr_24900_24953 = state_24894__$1;
(statearr_24900_24953[(2)] = inst_24873);

(statearr_24900_24953[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24895 === (3))){
var inst_24892 = (state_24894[(2)]);
var state_24894__$1 = state_24894;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24894__$1,inst_24892);
} else {
if((state_val_24895 === (2))){
var ___$1 = (function (){var statearr_24902 = state_24894;
(statearr_24902[(4)] = cljs.core.cons.call(null,(5),(state_24894[(4)])));

return statearr_24902;
})();
var state_24894__$1 = state_24894;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_24903_24954 = state_24894__$1;
(statearr_24903_24954[(1)] = (6));

} else {
var statearr_24904_24955 = state_24894__$1;
(statearr_24904_24955[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24895 === (9))){
var inst_24876 = (state_24894[(8)]);
var inst_24878 = (state_24894[(9)]);
var inst_24885 = (state_24894[(2)]);
var inst_24886 = cljs.core.reduce.call(null,fluree.db.query.fql.replace_expand_maps,inst_24876,inst_24885);
var inst_24887 = inst_24878.call(null,inst_24886);
var inst_24888 = cljs.core.async.put_BANG_.call(null,port,inst_24887);
var inst_24889 = cljs.core.async.close_BANG_.call(null,port);
var ___$1 = (function (){var statearr_24905 = state_24894;
(statearr_24905[(4)] = cljs.core.rest.call(null,(state_24894[(4)])));

return statearr_24905;
})();
var state_24894__$1 = (function (){var statearr_24906 = state_24894;
(statearr_24906[(10)] = inst_24888);

return statearr_24906;
})();
var statearr_24907_24956 = state_24894__$1;
(statearr_24907_24956[(2)] = inst_24889);

(statearr_24907_24956[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24895 === (5))){
var ___$1 = (function (){var statearr_24908 = state_24894;
(statearr_24908[(4)] = cljs.core.rest.call(null,(state_24894[(4)])));

return statearr_24908;
})();
var state_24894__$1 = state_24894;
var ex24901 = (state_24894__$1[(2)]);
var statearr_24909_24957 = state_24894__$1;
(statearr_24909_24957[(5)] = ex24901);


var statearr_24910_24958 = state_24894__$1;
(statearr_24910_24958[(1)] = (4));

(statearr_24910_24958[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24895 === (8))){
var inst_24876 = (state_24894[(8)]);
var inst_24876__$1 = (state_24894[(2)]);
var inst_24877 = cljs.core.volatile_BANG_.call(null,(0));
var inst_24878 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24876__$1;
var query_fuel = inst_24877;
return (function (p1__24788_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,p1__24788_SHARP_),cljs.core.deref.call(null,query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__24788_SHARP_,cljs.core.deref.call(null,query_fuel)], null);
}
});
})();
var inst_24879 = cljs.core.PersistentVector.EMPTY;
var inst_24880 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24876__$1;
var query_fuel = inst_24877;
return (function (p1__24787_SHARP_){
return fluree.db.query.fql.expand_map.call(null,db,cljs.core.assoc.call(null,opts_STAR_,new cljs.core.Keyword(null,"fuel","fuel",10405485),fuel),tuple_res_SINGLEQUOTE_,p1__24787_SHARP_);
});
})();
var inst_24881 = cljs.core.keep.call(null,inst_24880,expandMaps);
var inst_24882 = cljs.core.async.merge.call(null,inst_24881);
var inst_24883 = cljs.core.async.into.call(null,inst_24879,inst_24882);
var state_24894__$1 = (function (){var statearr_24911 = state_24894;
(statearr_24911[(8)] = inst_24876__$1);

(statearr_24911[(9)] = inst_24878);

return statearr_24911;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24894__$1,(9),inst_24883);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0 = (function (){
var statearr_24912 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24912[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__);

(statearr_24912[(1)] = (1));

return statearr_24912;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1 = (function (state_24894){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24894);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24913){var ex__2749__auto__ = e24913;
var statearr_24914_24959 = state_24894;
(statearr_24914_24959[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24894[(4)]))){
var statearr_24915_24960 = state_24894;
(statearr_24915_24960[(1)] = cljs.core.first.call(null,(state_24894[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24961 = state_24894;
state_24894 = G__24961;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__ = function(state_24894){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1.call(this,state_24894);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24916 = f__2769__auto__.call(null);
(statearr_24916[(6)] = c__2768__auto____$1);

return statearr_24916;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto____$1;
});
})();
var inst_24803 = cljs.core.async.onto_chan_BANG_.call(null,inst_24796,tuples_res);
var inst_24804 = cljs.core.async.pipeline_async.call(null,parallelism,inst_24797__$1,inst_24802,inst_24796);
var inst_24805 = cljs.core.PersistentVector.EMPTY;
var inst_24806 = inst_24805;
var state_24847__$1 = (function (){var statearr_24917 = state_24847;
(statearr_24917[(11)] = inst_24804);

(statearr_24917[(8)] = inst_24797__$1);

(statearr_24917[(12)] = inst_24806);

(statearr_24917[(13)] = inst_24803);

(statearr_24917[(9)] = inst_24798__$1);

return statearr_24917;
})();
var statearr_24918_24962 = state_24847__$1;
(statearr_24918_24962[(2)] = null);

(statearr_24918_24962[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24848 === (19))){
var inst_24806 = (state_24847[(12)]);
var inst_24809 = (state_24847[(7)]);
var inst_24829 = cljs.core.first.call(null,inst_24809);
var inst_24830 = cljs.core.conj.call(null,inst_24806,inst_24829);
var inst_24806__$1 = inst_24830;
var state_24847__$1 = (function (){var statearr_24919 = state_24847;
(statearr_24919[(12)] = inst_24806__$1);

return statearr_24919;
})();
var statearr_24920_24963 = state_24847__$1;
(statearr_24920_24963[(2)] = null);

(statearr_24920_24963[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24848 === (11))){
var inst_24840 = (state_24847[(2)]);
var state_24847__$1 = state_24847;
var statearr_24922_24964 = state_24847__$1;
(statearr_24922_24964[(2)] = inst_24840);

(statearr_24922_24964[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24848 === (9))){
var inst_24806 = (state_24847[(12)]);
var state_24847__$1 = state_24847;
var statearr_24923_24965 = state_24847__$1;
(statearr_24923_24965[(2)] = inst_24806);

(statearr_24923_24965[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24848 === (5))){
var _ = (function (){var statearr_24924 = state_24847;
(statearr_24924[(4)] = cljs.core.rest.call(null,(state_24847[(4)])));

return statearr_24924;
})();
var state_24847__$1 = state_24847;
var ex24921 = (state_24847__$1[(2)]);
var statearr_24925_24966 = state_24847__$1;
(statearr_24925_24966[(5)] = ex24921);


if((ex24921 instanceof Error)){
var statearr_24926_24967 = state_24847__$1;
(statearr_24926_24967[(1)] = (4));

(statearr_24926_24967[(5)] = null);

} else {
throw ex24921;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24848 === (14))){
var inst_24838 = (state_24847[(2)]);
var state_24847__$1 = state_24847;
var statearr_24927_24968 = state_24847__$1;
(statearr_24927_24968[(2)] = inst_24838);

(statearr_24927_24968[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24848 === (16))){
var state_24847__$1 = state_24847;
var statearr_24928_24969 = state_24847__$1;
(statearr_24928_24969[(2)] = null);

(statearr_24928_24969[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24848 === (10))){
var inst_24809 = (state_24847[(7)]);
var inst_24813 = fluree.db.util.core.exception_QMARK_.call(null,inst_24809);
var state_24847__$1 = state_24847;
if(inst_24813){
var statearr_24929_24970 = state_24847__$1;
(statearr_24929_24970[(1)] = (12));

} else {
var statearr_24930_24971 = state_24847__$1;
(statearr_24930_24971[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24848 === (18))){
var inst_24798 = (state_24847[(9)]);
var inst_24822 = inst_24798.call(null);
var inst_24823 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_24824 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_24825 = [new cljs.core.Keyword("db","insufficient-fuel","db/insufficient-fuel",344386102),(400)];
var inst_24826 = cljs.core.PersistentHashMap.fromArrays(inst_24824,inst_24825);
var inst_24827 = cljs.core.ex_info.call(null,inst_24823,inst_24826);
var state_24847__$1 = (function (){var statearr_24931 = state_24847;
(statearr_24931[(14)] = inst_24822);

return statearr_24931;
})();
var statearr_24932_24972 = state_24847__$1;
(statearr_24932_24972[(2)] = inst_24827);

(statearr_24932_24972[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24848 === (8))){
var inst_24809 = (state_24847[(7)]);
var inst_24809__$1 = (state_24847[(2)]);
var inst_24810 = (inst_24809__$1 == null);
var state_24847__$1 = (function (){var statearr_24933 = state_24847;
(statearr_24933[(7)] = inst_24809__$1);

return statearr_24933;
})();
if(cljs.core.truth_(inst_24810)){
var statearr_24934_24973 = state_24847__$1;
(statearr_24934_24973[(1)] = (9));

} else {
var statearr_24935_24974 = state_24847__$1;
(statearr_24935_24974[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0 = (function (){
var statearr_24936 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24936[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__);

(statearr_24936[(1)] = (1));

return statearr_24936;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1 = (function (state_24847){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24847);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24937){var ex__2749__auto__ = e24937;
var statearr_24938_24975 = state_24847;
(statearr_24938_24975[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24847[(4)]))){
var statearr_24939_24976 = state_24847;
(statearr_24939_24976[(1)] = cljs.core.first.call(null,(state_24847[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24977 = state_24847;
state_24847 = G__24977;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__ = function(state_24847){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1.call(this,state_24847);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24940 = f__2769__auto__.call(null);
(statearr_24940[(6)] = c__2768__auto__);

return statearr_24940;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__24978 = select;
var map__24978__$1 = cljs.core.__destructure_map.call(null,map__24978);
var as = cljs.core.get.call(null,map__24978__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var variable = cljs.core.get.call(null,map__24978__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var value = cljs.core.get.call(null,map__24978__$1,new cljs.core.Keyword(null,"value","value",305978217));
var select_val = (function (){var or__5045__auto__ = as;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx.call(null,headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly.call(null,value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.call(null,tuple,idx);
}):(cljs.core.truth_(cljs.core.get.call(null,vars,select_val))?cljs.core.constantly.call(null,cljs.core.get.call(null,vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.call(null,cljs.core.juxt,cljs.core.map.call(null,cljs.core.partial.call(null,fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__24981 = orderBy;
var order = cljs.core.nth.call(null,vec__24981,(0),null);
var var$ = cljs.core.nth.call(null,vec__24981,(1),null);
var option = cljs.core.nth.call(null,vec__24981,(2),null);
var comparator = ((cljs.core._EQ_.call(null,"DESC",order))?(function (a,b){
return cljs.core.compare.call(null,b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.call(null,"NOCASE",clojure.string.upper_case.call(null,option))));
var keyfn = ((no_case_QMARK_)?(function (p1__24979_SHARP_){
return clojure.string.upper_case.call(null,cljs.core.nth.call(null,p1__24979_SHARP_,compare_idx));
}):(function (p1__24980_SHARP_){
return cljs.core.nth.call(null,p1__24980_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count.call(null,tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return cljs.core.sort_by.call(null,keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__24986 = arguments.length;
switch (G__24986) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__24987,p__24988,group_limit,opts){
var map__24989 = p__24987;
var map__24989__$1 = cljs.core.__destructure_map.call(null,map__24989);
var res = map__24989__$1;
var vars = cljs.core.get.call(null,map__24989__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__24990 = p__24988;
var map__24990__$1 = cljs.core.__destructure_map.call(null,map__24990);
var select_spec = map__24990__$1;
var inVector_QMARK_ = cljs.core.get.call(null,map__24990__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.call(null,map__24990__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__24990__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var expandMaps_QMARK_ = cljs.core.get.call(null,map__24990__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var limit = cljs.core.get.call(null,map__24990__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__24990__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.call(null,map__24990__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.call(null,map__24990__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__24990__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.call(null,map__24990__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25127){
var state_val_25128 = (state_25127[(1)]);
if((state_val_25128 === (7))){
var inst_24997 = (state_25127[(7)]);
var state_25127__$1 = state_25127;
var statearr_25129_25231 = state_25127__$1;
(statearr_25129_25231[(2)] = inst_24997);

(statearr_25129_25231[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (59))){
var inst_25120 = (state_25127[(2)]);
var state_25127__$1 = state_25127;
var statearr_25130_25232 = state_25127__$1;
(statearr_25130_25232[(2)] = inst_25120);

(statearr_25130_25232[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (20))){
var inst_25036 = (state_25127[(8)]);
var inst_25033 = (state_25127[(9)]);
var inst_25032 = (state_25127[(2)]);
var inst_25033__$1 = cljs.core.__destructure_map.call(null,inst_25032);
var inst_25034 = cljs.core.get.call(null,inst_25033__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_25035 = cljs.core.get.call(null,inst_25033__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_25036__$1 = offset;
var state_25127__$1 = (function (){var statearr_25131 = state_25127;
(statearr_25131[(10)] = inst_25035);

(statearr_25131[(11)] = inst_25034);

(statearr_25131[(8)] = inst_25036__$1);

(statearr_25131[(9)] = inst_25033__$1);

return statearr_25131;
})();
if(cljs.core.truth_(inst_25036__$1)){
var statearr_25132_25233 = state_25127__$1;
(statearr_25132_25233[(1)] = (21));

} else {
var statearr_25133_25234 = state_25127__$1;
(statearr_25133_25234[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (58))){
var inst_25112 = (state_25127[(12)]);
var state_25127__$1 = state_25127;
var statearr_25134_25235 = state_25127__$1;
(statearr_25134_25235[(2)] = inst_25112);

(statearr_25134_25235[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (60))){
var inst_25116 = (state_25127[(2)]);
var inst_25117 = fluree.db.util.async.throw_err.call(null,inst_25116);
var state_25127__$1 = state_25127;
var statearr_25135_25236 = state_25127__$1;
(statearr_25135_25236[(2)] = inst_25117);

(statearr_25135_25236[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (27))){
var inst_25048 = cljs.core.not.call(null,inVector_QMARK_);
var state_25127__$1 = state_25127;
var statearr_25136_25237 = state_25127__$1;
(statearr_25136_25237[(2)] = inst_25048);

(statearr_25136_25237[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (1))){
var state_25127__$1 = state_25127;
var statearr_25137_25238 = state_25127__$1;
(statearr_25137_25238[(2)] = null);

(statearr_25137_25238[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (24))){
var state_25127__$1 = state_25127;
var statearr_25138_25239 = state_25127__$1;
(statearr_25138_25239[(2)] = offset);

(statearr_25138_25239[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (55))){
var inst_25106 = (state_25127[(13)]);
var state_25127__$1 = state_25127;
var statearr_25139_25240 = state_25127__$1;
(statearr_25139_25240[(2)] = inst_25106);

(statearr_25139_25240[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (39))){
var inst_25074 = (state_25127[(14)]);
var inst_25076 = cljs.core.distinct.call(null);
var inst_25077 = cljs.core.conj.call(null,inst_25074,inst_25076);
var state_25127__$1 = state_25127;
var statearr_25140_25241 = state_25127__$1;
(statearr_25140_25241[(2)] = inst_25077);

(statearr_25140_25241[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (46))){
var inst_25086 = (state_25127[(15)]);
var state_25127__$1 = state_25127;
var statearr_25141_25242 = state_25127__$1;
(statearr_25141_25242[(2)] = inst_25086);

(statearr_25141_25242[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (4))){
var inst_24991 = (state_25127[(2)]);
var state_25127__$1 = state_25127;
var statearr_25142_25243 = state_25127__$1;
(statearr_25142_25243[(2)] = inst_24991);

(statearr_25142_25243[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (54))){
var inst_25106 = (state_25127[(13)]);
var inst_25100 = (state_25127[(16)]);
var inst_25108 = cljs.core.PersistentVector.EMPTY;
var inst_25109 = cljs.core.into.call(null,inst_25108,inst_25100,inst_25106);
var state_25127__$1 = state_25127;
var statearr_25143_25244 = state_25127__$1;
(statearr_25143_25244[(2)] = inst_25109);

(statearr_25143_25244[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (15))){
var inst_25018 = (state_25127[(17)]);
var inst_25020 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25021 = [inst_25018];
var inst_25022 = (new cljs.core.PersistentVector(null,1,(5),inst_25020,inst_25021,null));
var state_25127__$1 = state_25127;
var statearr_25144_25245 = state_25127__$1;
(statearr_25144_25245[(2)] = inst_25022);

(statearr_25144_25245[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (48))){
var inst_25092 = (state_25127[(18)]);
var inst_25051 = (state_25127[(19)]);
var inst_25035 = (state_25127[(10)]);
var inst_25034 = (state_25127[(11)]);
var inst_25033 = (state_25127[(9)]);
var inst_25056 = (state_25127[(20)]);
var inst_25045 = (state_25127[(21)]);
var inst_25094 = (function (){var map__25027 = inst_25033;
var headers = inst_25034;
var tuples = inst_25035;
var offset_SINGLEQUOTE_ = inst_25045;
var single_result_QMARK_ = inst_25051;
var pp_keys = inst_25056;
var G__25057 = inst_25092;
return (function (p1__24984_SHARP_){
return cljs.core.zipmap.call(null,fluree.db.query.fql.get_pretty_print_keys.call(null,select),p1__24984_SHARP_);
});
})();
var inst_25095 = cljs.core.map.call(null,inst_25094);
var inst_25096 = cljs.core.conj.call(null,inst_25092,inst_25095);
var state_25127__$1 = state_25127;
var statearr_25145_25246 = state_25127__$1;
(statearr_25145_25246[(2)] = inst_25096);

(statearr_25145_25246[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (50))){
var inst_25099 = (state_25127[(2)]);
var inst_25100 = cljs.core.apply.call(null,cljs.core.comp,inst_25099);
var state_25127__$1 = (function (){var statearr_25146 = state_25127;
(statearr_25146[(16)] = inst_25100);

return statearr_25146;
})();
if(cljs.core.truth_(orderBy)){
var statearr_25147_25247 = state_25127__$1;
(statearr_25147_25247[(1)] = (51));

} else {
var statearr_25148_25248 = state_25127__$1;
(statearr_25148_25248[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (21))){
var inst_25038 = cljs.core.not.call(null,groupBy);
var state_25127__$1 = state_25127;
var statearr_25149_25249 = state_25127__$1;
(statearr_25149_25249[(2)] = inst_25038);

(statearr_25149_25249[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (31))){
var state_25127__$1 = state_25127;
var statearr_25150_25250 = state_25127__$1;
(statearr_25150_25250[(2)] = null);

(statearr_25150_25250[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (32))){
var inst_25051 = (state_25127[(19)]);
var inst_25034 = (state_25127[(11)]);
var inst_25056 = (state_25127[(2)]);
var inst_25058 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25059 = fluree.db.query.fql.select_tuples_fn.call(null,inst_25034,vars,select);
var inst_25060 = cljs.core.map.call(null,inst_25059);
var inst_25061 = [inst_25060];
var inst_25062 = (new cljs.core.PersistentVector(null,1,(5),inst_25058,inst_25061,null));
var state_25127__$1 = (function (){var statearr_25151 = state_25127;
(statearr_25151[(22)] = inst_25062);

(statearr_25151[(20)] = inst_25056);

return statearr_25151;
})();
if(cljs.core.truth_(inst_25051)){
var statearr_25152_25251 = state_25127__$1;
(statearr_25152_25251[(1)] = (33));

} else {
var statearr_25153_25252 = state_25127__$1;
(statearr_25153_25252[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (40))){
var inst_25074 = (state_25127[(14)]);
var state_25127__$1 = state_25127;
var statearr_25154_25253 = state_25127__$1;
(statearr_25154_25253[(2)] = inst_25074);

(statearr_25154_25253[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (56))){
var inst_25112 = (state_25127[(2)]);
var state_25127__$1 = (function (){var statearr_25155 = state_25127;
(statearr_25155[(12)] = inst_25112);

return statearr_25155;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_25156_25254 = state_25127__$1;
(statearr_25156_25254[(1)] = (57));

} else {
var statearr_25157_25255 = state_25127__$1;
(statearr_25157_25255[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (33))){
var inst_25062 = (state_25127[(22)]);
var inst_25064 = cljs.core.map.call(null,cljs.core.first);
var inst_25065 = cljs.core.conj.call(null,inst_25062,inst_25064);
var state_25127__$1 = state_25127;
var statearr_25158_25256 = state_25127__$1;
(statearr_25158_25256[(2)] = inst_25065);

(statearr_25158_25256[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (13))){
var inst_25007 = (state_25127[(23)]);
var state_25127__$1 = state_25127;
var statearr_25159_25257 = state_25127__$1;
(statearr_25159_25257[(2)] = inst_25007);

(statearr_25159_25257[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (22))){
var inst_25036 = (state_25127[(8)]);
var state_25127__$1 = state_25127;
var statearr_25160_25258 = state_25127__$1;
(statearr_25160_25258[(2)] = inst_25036);

(statearr_25160_25258[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (36))){
var inst_25068 = (state_25127[(24)]);
var inst_25070 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel,(5));
var inst_25071 = cljs.core.conj.call(null,inst_25068,inst_25070);
var state_25127__$1 = state_25127;
var statearr_25161_25259 = state_25127__$1;
(statearr_25161_25259[(2)] = inst_25071);

(statearr_25161_25259[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (41))){
var inst_25045 = (state_25127[(21)]);
var inst_25080 = (state_25127[(2)]);
var state_25127__$1 = (function (){var statearr_25162 = state_25127;
(statearr_25162[(25)] = inst_25080);

return statearr_25162;
})();
if(cljs.core.truth_(inst_25045)){
var statearr_25163_25260 = state_25127__$1;
(statearr_25163_25260[(1)] = (42));

} else {
var statearr_25164_25261 = state_25127__$1;
(statearr_25164_25261[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (43))){
var inst_25080 = (state_25127[(25)]);
var state_25127__$1 = state_25127;
var statearr_25165_25262 = state_25127__$1;
(statearr_25165_25262[(2)] = inst_25080);

(statearr_25165_25262[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (29))){
var inst_25051 = (state_25127[(2)]);
var state_25127__$1 = (function (){var statearr_25166 = state_25127;
(statearr_25166[(19)] = inst_25051);

return statearr_25166;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25167_25263 = state_25127__$1;
(statearr_25167_25263[(1)] = (30));

} else {
var statearr_25168_25264 = state_25127__$1;
(statearr_25168_25264[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (44))){
var inst_25086 = (state_25127[(2)]);
var state_25127__$1 = (function (){var statearr_25169 = state_25127;
(statearr_25169[(15)] = inst_25086);

return statearr_25169;
})();
if(cljs.core.truth_(group_limit)){
var statearr_25170_25265 = state_25127__$1;
(statearr_25170_25265[(1)] = (45));

} else {
var statearr_25171_25266 = state_25127__$1;
(statearr_25171_25266[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (6))){
var inst_24999 = cljs.core.count.call(null,select);
var inst_25000 = cljs.core._EQ_.call(null,(1),inst_24999);
var state_25127__$1 = state_25127;
var statearr_25172_25267 = state_25127__$1;
(statearr_25172_25267[(2)] = inst_25000);

(statearr_25172_25267[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (28))){
var inst_25046 = (state_25127[(26)]);
var state_25127__$1 = state_25127;
var statearr_25173_25268 = state_25127__$1;
(statearr_25173_25268[(2)] = inst_25046);

(statearr_25173_25268[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (51))){
var inst_25035 = (state_25127[(10)]);
var inst_25034 = (state_25127[(11)]);
var inst_25103 = fluree.db.query.fql.order_result_tuples.call(null,fuel,max_fuel,inst_25034,orderBy,inst_25035);
var state_25127__$1 = state_25127;
var statearr_25174_25269 = state_25127__$1;
(statearr_25174_25269[(2)] = inst_25103);

(statearr_25174_25269[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (25))){
var state_25127__$1 = state_25127;
var statearr_25175_25270 = state_25127__$1;
(statearr_25175_25270[(2)] = null);

(statearr_25175_25270[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (34))){
var inst_25062 = (state_25127[(22)]);
var state_25127__$1 = state_25127;
var statearr_25176_25271 = state_25127__$1;
(statearr_25176_25271[(2)] = inst_25062);

(statearr_25176_25271[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (17))){
var inst_25025 = (state_25127[(2)]);
var state_25127__$1 = state_25127;
var statearr_25177_25272 = state_25127__$1;
(statearr_25177_25272[(2)] = inst_25025);

(statearr_25177_25272[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (3))){
var inst_25125 = (state_25127[(2)]);
var state_25127__$1 = state_25127;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25127__$1,inst_25125);
} else {
if((state_val_25128 === (12))){
var inst_25007 = (state_25127[(23)]);
var inst_25009 = cljs.core.first.call(null,select);
var inst_25010 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_25009);
var inst_25011 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25010);
var inst_25012 = cljs.core.subs.call(null,inst_25011,(1));
var inst_25013 = [inst_25012];
var inst_25014 = [inst_25007];
var inst_25015 = cljs.core.PersistentHashMap.fromArrays(inst_25013,inst_25014);
var state_25127__$1 = state_25127;
var statearr_25178_25273 = state_25127__$1;
(statearr_25178_25273[(2)] = inst_25015);

(statearr_25178_25273[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (2))){
var inst_24997 = (state_25127[(7)]);
var _ = (function (){var statearr_25179 = state_25127;
(statearr_25179[(4)] = cljs.core.cons.call(null,(5),(state_25127[(4)])));

return statearr_25179;
})();
var inst_24997__$1 = aggregates;
var state_25127__$1 = (function (){var statearr_25180 = state_25127;
(statearr_25180[(7)] = inst_24997__$1);

return statearr_25180;
})();
if(cljs.core.truth_(inst_24997__$1)){
var statearr_25181_25274 = state_25127__$1;
(statearr_25181_25274[(1)] = (6));

} else {
var statearr_25182_25275 = state_25127__$1;
(statearr_25182_25275[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (23))){
var inst_25041 = (state_25127[(2)]);
var state_25127__$1 = state_25127;
if(cljs.core.truth_(inst_25041)){
var statearr_25183_25276 = state_25127__$1;
(statearr_25183_25276[(1)] = (24));

} else {
var statearr_25184_25277 = state_25127__$1;
(statearr_25184_25277[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (47))){
var inst_25092 = (state_25127[(2)]);
var state_25127__$1 = (function (){var statearr_25185 = state_25127;
(statearr_25185[(18)] = inst_25092);

return statearr_25185;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25186_25278 = state_25127__$1;
(statearr_25186_25278[(1)] = (48));

} else {
var statearr_25187_25279 = state_25127__$1;
(statearr_25187_25279[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (35))){
var inst_25068 = (state_25127[(2)]);
var state_25127__$1 = (function (){var statearr_25188 = state_25127;
(statearr_25188[(24)] = inst_25068);

return statearr_25188;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25189_25280 = state_25127__$1;
(statearr_25189_25280[(1)] = (36));

} else {
var statearr_25190_25281 = state_25127__$1;
(statearr_25190_25281[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (19))){
var state_25127__$1 = state_25127;
var statearr_25191_25282 = state_25127__$1;
(statearr_25191_25282[(2)] = res);

(statearr_25191_25282[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (57))){
var inst_25112 = (state_25127[(12)]);
var inst_25051 = (state_25127[(19)]);
var inst_25056 = (state_25127[(20)]);
var inst_25114 = fluree.db.query.fql.pipeline_expandmaps_result.call(null,select,inst_25056,inst_25051,db,fuel,max_fuel,opts,(8),inst_25112);
var state_25127__$1 = state_25127;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25127__$1,(60),inst_25114);
} else {
if((state_val_25128 === (11))){
var inst_25122 = (state_25127[(2)]);
var _ = (function (){var statearr_25193 = state_25127;
(statearr_25193[(4)] = cljs.core.rest.call(null,(state_25127[(4)])));

return statearr_25193;
})();
var state_25127__$1 = state_25127;
var statearr_25194_25283 = state_25127__$1;
(statearr_25194_25283[(2)] = inst_25122);

(statearr_25194_25283[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (9))){
var inst_25005 = cljs.core.first.call(null,aggregates);
var inst_25006 = fluree.db.query.analytical.calculate_aggregate.call(null,res,inst_25005);
var inst_25007 = cljs.core.second.call(null,inst_25006);
var state_25127__$1 = (function (){var statearr_25195 = state_25127;
(statearr_25195[(23)] = inst_25007);

return statearr_25195;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25196_25284 = state_25127__$1;
(statearr_25196_25284[(1)] = (12));

} else {
var statearr_25197_25285 = state_25127__$1;
(statearr_25197_25285[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (5))){
var _ = (function (){var statearr_25198 = state_25127;
(statearr_25198[(4)] = cljs.core.rest.call(null,(state_25127[(4)])));

return statearr_25198;
})();
var state_25127__$1 = state_25127;
var ex25192 = (state_25127__$1[(2)]);
var statearr_25199_25286 = state_25127__$1;
(statearr_25199_25286[(5)] = ex25192);


if((ex25192 instanceof Error)){
var statearr_25200_25287 = state_25127__$1;
(statearr_25200_25287[(1)] = (4));

(statearr_25200_25287[(5)] = null);

} else {
throw ex25192;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (14))){
var inst_25018 = (state_25127[(2)]);
var state_25127__$1 = (function (){var statearr_25201 = state_25127;
(statearr_25201[(17)] = inst_25018);

return statearr_25201;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25202_25288 = state_25127__$1;
(statearr_25202_25288[(1)] = (15));

} else {
var statearr_25203_25289 = state_25127__$1;
(statearr_25203_25289[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (45))){
var inst_25086 = (state_25127[(15)]);
var inst_25088 = cljs.core.take.call(null,group_limit);
var inst_25089 = cljs.core.conj.call(null,inst_25086,inst_25088);
var state_25127__$1 = state_25127;
var statearr_25204_25290 = state_25127__$1;
(statearr_25204_25290[(2)] = inst_25089);

(statearr_25204_25290[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (53))){
var inst_25106 = (state_25127[(2)]);
var state_25127__$1 = (function (){var statearr_25205 = state_25127;
(statearr_25205[(13)] = inst_25106);

return statearr_25205;
})();
var statearr_25206_25291 = state_25127__$1;
(statearr_25206_25291[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (26))){
var inst_25046 = (state_25127[(26)]);
var inst_25045 = (state_25127[(2)]);
var inst_25046__$1 = cljs.core.not.call(null,prettyPrint);
var state_25127__$1 = (function (){var statearr_25208 = state_25127;
(statearr_25208[(26)] = inst_25046__$1);

(statearr_25208[(21)] = inst_25045);

return statearr_25208;
})();
if(inst_25046__$1){
var statearr_25209_25292 = state_25127__$1;
(statearr_25209_25292[(1)] = (27));

} else {
var statearr_25210_25293 = state_25127__$1;
(statearr_25210_25293[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (16))){
var inst_25018 = (state_25127[(17)]);
var state_25127__$1 = state_25127;
var statearr_25211_25294 = state_25127__$1;
(statearr_25211_25294[(2)] = inst_25018);

(statearr_25211_25294[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (38))){
var inst_25074 = (state_25127[(2)]);
var state_25127__$1 = (function (){var statearr_25212 = state_25127;
(statearr_25212[(14)] = inst_25074);

return statearr_25212;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25213_25295 = state_25127__$1;
(statearr_25213_25295[(1)] = (39));

} else {
var statearr_25214_25296 = state_25127__$1;
(statearr_25214_25296[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (30))){
var inst_25053 = fluree.db.query.fql.get_pretty_print_keys.call(null,select);
var state_25127__$1 = state_25127;
var statearr_25215_25297 = state_25127__$1;
(statearr_25215_25297[(2)] = inst_25053);

(statearr_25215_25297[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (10))){
var state_25127__$1 = state_25127;
if(cljs.core.truth_(aggregates)){
var statearr_25216_25298 = state_25127__$1;
(statearr_25216_25298[(1)] = (18));

} else {
var statearr_25217_25299 = state_25127__$1;
(statearr_25217_25299[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (18))){
var inst_25029 = fluree.db.query.analytical.add_aggregate_cols.call(null,res,aggregates);
var state_25127__$1 = state_25127;
var statearr_25218_25300 = state_25127__$1;
(statearr_25218_25300[(2)] = inst_25029);

(statearr_25218_25300[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (52))){
var inst_25035 = (state_25127[(10)]);
var state_25127__$1 = state_25127;
var statearr_25219_25301 = state_25127__$1;
(statearr_25219_25301[(2)] = inst_25035);

(statearr_25219_25301[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (42))){
var inst_25045 = (state_25127[(21)]);
var inst_25080 = (state_25127[(25)]);
var inst_25082 = cljs.core.drop.call(null,inst_25045);
var inst_25083 = cljs.core.conj.call(null,inst_25080,inst_25082);
var state_25127__$1 = state_25127;
var statearr_25220_25302 = state_25127__$1;
(statearr_25220_25302[(2)] = inst_25083);

(statearr_25220_25302[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (37))){
var inst_25068 = (state_25127[(24)]);
var state_25127__$1 = state_25127;
var statearr_25221_25303 = state_25127__$1;
(statearr_25221_25303[(2)] = inst_25068);

(statearr_25221_25303[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (8))){
var inst_25003 = (state_25127[(2)]);
var state_25127__$1 = state_25127;
if(cljs.core.truth_(inst_25003)){
var statearr_25222_25304 = state_25127__$1;
(statearr_25222_25304[(1)] = (9));

} else {
var statearr_25223_25305 = state_25127__$1;
(statearr_25223_25305[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25128 === (49))){
var inst_25092 = (state_25127[(18)]);
var state_25127__$1 = state_25127;
var statearr_25224_25306 = state_25127__$1;
(statearr_25224_25306[(2)] = inst_25092);

(statearr_25224_25306[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2746__auto__ = null;
var fluree$db$query$fql$state_machine__2746__auto____0 = (function (){
var statearr_25225 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25225[(0)] = fluree$db$query$fql$state_machine__2746__auto__);

(statearr_25225[(1)] = (1));

return statearr_25225;
});
var fluree$db$query$fql$state_machine__2746__auto____1 = (function (state_25127){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25127);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25226){var ex__2749__auto__ = e25226;
var statearr_25227_25307 = state_25127;
(statearr_25227_25307[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25127[(4)]))){
var statearr_25228_25308 = state_25127;
(statearr_25228_25308[(1)] = cljs.core.first.call(null,(state_25127[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25309 = state_25127;
state_25127 = G__25309;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2746__auto__ = function(state_25127){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2746__auto____1.call(this,state_25127);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2746__auto____0;
fluree$db$query$fql$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2746__auto____1;
return fluree$db$query$fql$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25229 = f__2769__auto__.call(null);
(statearr_25229[(6)] = c__2768__auto__);

return statearr_25229;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__25312,groupBy){
var map__25313 = p__25312;
var map__25313__$1 = cljs.core.__destructure_map.call(null,map__25313);
var res = map__25313__$1;
var headers = cljs.core.get.call(null,map__25313__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__25313__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__25314 = ((cljs.core.vector_QMARK_.call(null,groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.call(null,cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,groupBy)], null)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.call(null,vec__25314,(0),null);
var groupBy__$1 = cljs.core.nth.call(null,vec__25314,(1),null);
var group_idxs = cljs.core.map.call(null,(function (p1__25310_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__25310_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some.call(null,cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.call(null,(function (res__$1,tuple){
var k = cljs.core.map.call(null,(function (p1__25311_SHARP_){
return cljs.core.nth.call(null,tuple,p1__25311_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,k):cljs.core.first.call(null,k));
var v = tuple;
return cljs.core.assoc.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.conj.call(null,cljs.core.get.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__25317 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.call(null,vec__25317,(0),null);
var sortCriteria = cljs.core.nth.call(null,vec__25317,(1),null);
if(cljs.core._EQ_.call(null,sortCriteria,groupBy)){
if(cljs.core._EQ_.call(null,sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_.call(null,groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of.call(null,groupBy,sortCriteria);
if(cljs.core._EQ_.call(null,"DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx));
});
}
} else {
return null;

}
}
});
/**
 * groupBy statements can optionally have a 'having' statement which filters
 *   items within the group.
 */
fluree.db.query.fql.filter_having = (function fluree$db$query$fql$filter_having(p__25320,headers,group_map){
var map__25321 = p__25320;
var map__25321__$1 = cljs.core.__destructure_map.call(null,map__25321);
var having = map__25321__$1;
var params = cljs.core.get.call(null,map__25321__$1,new cljs.core.Keyword(null,"params","params",710516235));
var function$ = cljs.core.get.call(null,map__25321__$1,new cljs.core.Keyword(null,"function","function",-2127255473));
var idxs = fluree.db.query.analytical.get_tuple_indexes.call(null,params,headers);
var filtered = (function (){var G__25328 = group_map;
var vec__25329 = G__25328;
var seq__25330 = cljs.core.seq.call(null,vec__25329);
var first__25331 = cljs.core.first.call(null,seq__25330);
var seq__25330__$1 = cljs.core.next.call(null,seq__25330);
var vec__25332 = first__25331;
var k = cljs.core.nth.call(null,vec__25332,(0),null);
var tuples = cljs.core.nth.call(null,vec__25332,(1),null);
var r = seq__25330__$1;
var acc = cljs.core.PersistentArrayMap.EMPTY;
var G__25328__$1 = G__25328;
var acc__$1 = acc;
while(true){
var vec__25342 = G__25328__$1;
var seq__25343 = cljs.core.seq.call(null,vec__25342);
var first__25344 = cljs.core.first.call(null,seq__25343);
var seq__25343__$1 = cljs.core.next.call(null,seq__25343);
var vec__25345 = first__25344;
var k__$1 = cljs.core.nth.call(null,vec__25345,(0),null);
var tuples__$1 = cljs.core.nth.call(null,vec__25345,(1),null);
var r__$1 = seq__25343__$1;
var acc__$2 = acc__$1;
if(cljs.core.truth_(k__$1)){
var argument = cljs.core.flatten.call(null,fluree.db.query.analytical.transform_tuples_to_idxs.call(null,idxs,tuples__$1));
var res = (function (){try{return function$.call(null,argument);
}catch (e25348){var e = e25348;
fluree.db.util.log.error.call(null,e,["Error procesing fn: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402).cljs$core$IFn$_invoke$arity$1(having))," with argument: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(argument)].join(''));

throw cljs.core.ex_info.call(null,["Error executing having function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402).cljs$core$IFn$_invoke$arity$1(having))," with error message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.ex_message.call(null,e))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}})();
if(cljs.core.truth_(res)){
var G__25349 = r__$1;
var G__25350 = cljs.core.assoc.call(null,acc__$2,k__$1,tuples__$1);
G__25328__$1 = G__25349;
acc__$1 = G__25350;
continue;
} else {
var G__25351 = r__$1;
var G__25352 = acc__$2;
G__25328__$1 = G__25351;
acc__$1 = G__25352;
continue;
}
} else {
return acc__$2;
}
break;
}
})();
return filtered;
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__25353,p__25354,opts){
var map__25355 = p__25353;
var map__25355__$1 = cljs.core.__destructure_map.call(null,map__25355);
var res = map__25355__$1;
var headers = cljs.core.get.call(null,map__25355__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__25355__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__25356 = p__25354;
var map__25356__$1 = cljs.core.__destructure_map.call(null,map__25356);
var select_spec = map__25356__$1;
var groupBy = cljs.core.get.call(null,map__25356__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.call(null,map__25356__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.call(null,map__25356__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.call(null,map__25356__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__25356__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.call(null,map__25356__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.call(null,map__25356__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var having = cljs.core.get.call(null,map__25356__$1,new cljs.core.Keyword(null,"having","having",-399543166));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25480){
var state_val_25481 = (state_25480[(1)]);
if((state_val_25481 === (7))){
var state_25480__$1 = state_25480;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25482_25555 = state_25480__$1;
(statearr_25482_25555[(1)] = (30));

} else {
var statearr_25483_25556 = state_25480__$1;
(statearr_25483_25556[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (20))){
var inst_25387 = (state_25480[(2)]);
var state_25480__$1 = (function (){var statearr_25484 = state_25480;
(statearr_25484[(7)] = inst_25387);

return statearr_25484;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25485_25557 = state_25480__$1;
(statearr_25485_25557[(1)] = (21));

} else {
var statearr_25486_25558 = state_25480__$1;
(statearr_25486_25558[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (27))){
var inst_25413 = (state_25480[(8)]);
var state_25480__$1 = state_25480;
var statearr_25487_25559 = state_25480__$1;
(statearr_25487_25559[(2)] = inst_25413);

(statearr_25487_25559[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (1))){
var state_25480__$1 = state_25480;
var statearr_25488_25560 = state_25480__$1;
(statearr_25488_25560[(2)] = null);

(statearr_25488_25560[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (24))){
var inst_25412 = (state_25480[(9)]);
var inst_25424 = (state_25480[(10)]);
var inst_25421 = cljs.core.seq.call(null,inst_25412);
var inst_25422 = cljs.core.first.call(null,inst_25421);
var inst_25423 = cljs.core.next.call(null,inst_25421);
var inst_25424__$1 = cljs.core.nth.call(null,inst_25422,(0),null);
var inst_25425 = cljs.core.nth.call(null,inst_25422,(1),null);
var state_25480__$1 = (function (){var statearr_25489 = state_25480;
(statearr_25489[(11)] = inst_25423);

(statearr_25489[(12)] = inst_25425);

(statearr_25489[(10)] = inst_25424__$1);

return statearr_25489;
})();
if(cljs.core.truth_(inst_25424__$1)){
var statearr_25490_25561 = state_25480__$1;
(statearr_25490_25561[(1)] = (26));

} else {
var statearr_25491_25562 = state_25480__$1;
(statearr_25491_25562[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (39))){
var inst_25461 = (state_25480[(2)]);
var state_25480__$1 = state_25480;
var statearr_25492_25563 = state_25480__$1;
(statearr_25492_25563[(2)] = inst_25461);

(statearr_25492_25563[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (4))){
var inst_25357 = (state_25480[(2)]);
var state_25480__$1 = state_25480;
var statearr_25493_25564 = state_25480__$1;
(statearr_25493_25564[(2)] = inst_25357);

(statearr_25493_25564[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (15))){
var inst_25377 = (state_25480[(13)]);
var inst_25379 = cljs.core.drop.call(null,offset,inst_25377);
var state_25480__$1 = state_25480;
var statearr_25494_25565 = state_25480__$1;
(statearr_25494_25565[(2)] = inst_25379);

(statearr_25494_25565[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (21))){
var inst_25387 = (state_25480[(7)]);
var inst_25389 = cljs.core.take.call(null,(1),inst_25387);
var state_25480__$1 = state_25480;
var statearr_25495_25566 = state_25480__$1;
(statearr_25495_25566[(2)] = inst_25389);

(statearr_25495_25566[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (31))){
var state_25480__$1 = state_25480;
var statearr_25496_25567 = state_25480__$1;
(statearr_25496_25567[(2)] = limit);

(statearr_25496_25567[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (32))){
var inst_25447 = (state_25480[(2)]);
var inst_25448 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,res,select_spec,inst_25447,opts);
var state_25480__$1 = state_25480;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25480__$1,(33),inst_25448);
} else {
if((state_val_25481 === (40))){
var inst_25451 = (state_25480[(14)]);
var inst_25464 = cljs.core.first.call(null,inst_25451);
var state_25480__$1 = state_25480;
var statearr_25497_25568 = state_25480__$1;
(statearr_25497_25568[(2)] = inst_25464);

(statearr_25497_25568[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (33))){
var inst_25451 = (state_25480[(14)]);
var inst_25450 = (state_25480[(2)]);
var inst_25451__$1 = fluree.db.util.async.throw_err.call(null,inst_25450);
var inst_25452 = cljs.core.coll_QMARK_.call(null,inst_25451__$1);
var inst_25453 = (!(inst_25452));
var state_25480__$1 = (function (){var statearr_25498 = state_25480;
(statearr_25498[(14)] = inst_25451__$1);

return statearr_25498;
})();
if(inst_25453){
var statearr_25499_25569 = state_25480__$1;
(statearr_25499_25569[(1)] = (34));

} else {
var statearr_25500_25570 = state_25480__$1;
(statearr_25500_25570[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (13))){
var inst_25372 = (state_25480[(15)]);
var state_25480__$1 = state_25480;
var statearr_25501_25571 = state_25480__$1;
(statearr_25501_25571[(2)] = inst_25372);

(statearr_25501_25571[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (22))){
var inst_25387 = (state_25480[(7)]);
var state_25480__$1 = state_25480;
var statearr_25502_25572 = state_25480__$1;
(statearr_25502_25572[(2)] = inst_25387);

(statearr_25502_25572[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (36))){
var inst_25473 = (state_25480[(2)]);
var state_25480__$1 = state_25480;
var statearr_25503_25573 = state_25480__$1;
(statearr_25503_25573[(2)] = inst_25473);

(statearr_25503_25573[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (41))){
var state_25480__$1 = state_25480;
var statearr_25504_25574 = state_25480__$1;
(statearr_25504_25574[(1)] = (43));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (43))){
var inst_25451 = (state_25480[(14)]);
var state_25480__$1 = state_25480;
var statearr_25506_25575 = state_25480__$1;
(statearr_25506_25575[(2)] = inst_25451);

(statearr_25506_25575[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (29))){
var inst_25423 = (state_25480[(11)]);
var inst_25413 = (state_25480[(8)]);
var inst_25424 = (state_25480[(10)]);
var inst_25434 = (state_25480[(2)]);
var inst_25435 = fluree.db.util.async.throw_err.call(null,inst_25434);
var inst_25436 = cljs.core.assoc.call(null,inst_25413,inst_25424,inst_25435);
var inst_25412 = inst_25423;
var inst_25413__$1 = inst_25436;
var state_25480__$1 = (function (){var statearr_25507 = state_25480;
(statearr_25507[(8)] = inst_25413__$1);

(statearr_25507[(9)] = inst_25412);

return statearr_25507;
})();
var statearr_25508_25576 = state_25480__$1;
(statearr_25508_25576[(2)] = null);

(statearr_25508_25576[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (44))){
var state_25480__$1 = state_25480;
var statearr_25509_25577 = state_25480__$1;
(statearr_25509_25577[(2)] = null);

(statearr_25509_25577[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (6))){
var inst_25364 = (state_25480[(16)]);
var inst_25364__$1 = fluree.db.query.fql.build_order_fn.call(null,orderBy,groupBy);
var inst_25366 = fluree.db.query.fql.ad_hoc_group_by.call(null,res,groupBy);
var state_25480__$1 = (function (){var statearr_25510 = state_25480;
(statearr_25510[(16)] = inst_25364__$1);

(statearr_25510[(17)] = inst_25366);

return statearr_25510;
})();
if(cljs.core.truth_(inst_25364__$1)){
var statearr_25511_25578 = state_25480__$1;
(statearr_25511_25578[(1)] = (9));

} else {
var statearr_25512_25579 = state_25480__$1;
(statearr_25512_25579[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (28))){
var inst_25440 = (state_25480[(2)]);
var state_25480__$1 = state_25480;
var statearr_25513_25580 = state_25480__$1;
(statearr_25513_25580[(2)] = inst_25440);

(statearr_25513_25580[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (25))){
var inst_25442 = (state_25480[(2)]);
var state_25480__$1 = state_25480;
var statearr_25514_25581 = state_25480__$1;
(statearr_25514_25581[(2)] = inst_25442);

(statearr_25514_25581[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (34))){
var state_25480__$1 = state_25480;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25515_25582 = state_25480__$1;
(statearr_25515_25582[(1)] = (37));

} else {
var statearr_25516_25583 = state_25480__$1;
(statearr_25516_25583[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (17))){
var inst_25382 = (state_25480[(2)]);
var state_25480__$1 = (function (){var statearr_25517 = state_25480;
(statearr_25517[(18)] = inst_25382);

return statearr_25517;
})();
if(cljs.core.truth_(limit)){
var statearr_25518_25584 = state_25480__$1;
(statearr_25518_25584[(1)] = (18));

} else {
var statearr_25519_25585 = state_25480__$1;
(statearr_25519_25585[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (3))){
var inst_25478 = (state_25480[(2)]);
var state_25480__$1 = state_25480;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25480__$1,inst_25478);
} else {
if((state_val_25481 === (12))){
var inst_25372 = (state_25480[(15)]);
var inst_25374 = fluree.db.query.fql.filter_having.call(null,having,headers,inst_25372);
var state_25480__$1 = state_25480;
var statearr_25520_25586 = state_25480__$1;
(statearr_25520_25586[(2)] = inst_25374);

(statearr_25520_25586[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (2))){
var _ = (function (){var statearr_25521 = state_25480;
(statearr_25521[(4)] = cljs.core.cons.call(null,(5),(state_25480[(4)])));

return statearr_25521;
})();
var state_25480__$1 = state_25480;
if(cljs.core.truth_(groupBy)){
var statearr_25522_25587 = state_25480__$1;
(statearr_25522_25587[(1)] = (6));

} else {
var statearr_25523_25588 = state_25480__$1;
(statearr_25523_25588[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (23))){
var inst_25392 = (state_25480[(2)]);
var inst_25406 = cljs.core.seq.call(null,inst_25392);
var inst_25407 = cljs.core.first.call(null,inst_25406);
var inst_25408 = cljs.core.next.call(null,inst_25406);
var inst_25409 = cljs.core.nth.call(null,inst_25407,(0),null);
var inst_25410 = cljs.core.nth.call(null,inst_25407,(1),null);
var inst_25411 = cljs.core.PersistentHashMap.EMPTY;
var inst_25412 = inst_25392;
var inst_25413 = inst_25411;
var state_25480__$1 = (function (){var statearr_25524 = state_25480;
(statearr_25524[(19)] = inst_25408);

(statearr_25524[(8)] = inst_25413);

(statearr_25524[(9)] = inst_25412);

(statearr_25524[(20)] = inst_25410);

(statearr_25524[(21)] = inst_25409);

return statearr_25524;
})();
var statearr_25525_25589 = state_25480__$1;
(statearr_25525_25589[(2)] = null);

(statearr_25525_25589[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (35))){
var state_25480__$1 = state_25480;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25526_25590 = state_25480__$1;
(statearr_25526_25590[(1)] = (40));

} else {
var statearr_25527_25591 = state_25480__$1;
(statearr_25527_25591[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (19))){
var inst_25382 = (state_25480[(18)]);
var state_25480__$1 = state_25480;
var statearr_25528_25592 = state_25480__$1;
(statearr_25528_25592[(2)] = inst_25382);

(statearr_25528_25592[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (11))){
var inst_25372 = (state_25480[(2)]);
var state_25480__$1 = (function (){var statearr_25530 = state_25480;
(statearr_25530[(15)] = inst_25372);

return statearr_25530;
})();
if(cljs.core.truth_(having)){
var statearr_25531_25593 = state_25480__$1;
(statearr_25531_25593[(1)] = (12));

} else {
var statearr_25532_25594 = state_25480__$1;
(statearr_25532_25594[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (9))){
var inst_25364 = (state_25480[(16)]);
var inst_25366 = (state_25480[(17)]);
var inst_25368 = cljs.core.sorted_map_by.call(null,inst_25364);
var inst_25369 = cljs.core.into.call(null,inst_25368,inst_25366);
var state_25480__$1 = state_25480;
var statearr_25533_25595 = state_25480__$1;
(statearr_25533_25595[(2)] = inst_25369);

(statearr_25533_25595[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (5))){
var _ = (function (){var statearr_25534 = state_25480;
(statearr_25534[(4)] = cljs.core.rest.call(null,(state_25480[(4)])));

return statearr_25534;
})();
var state_25480__$1 = state_25480;
var ex25529 = (state_25480__$1[(2)]);
var statearr_25535_25596 = state_25480__$1;
(statearr_25535_25596[(5)] = ex25529);


if((ex25529 instanceof Error)){
var statearr_25536_25597 = state_25480__$1;
(statearr_25536_25597[(1)] = (4));

(statearr_25536_25597[(5)] = null);

} else {
throw ex25529;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (14))){
var inst_25377 = (state_25480[(2)]);
var state_25480__$1 = (function (){var statearr_25537 = state_25480;
(statearr_25537[(13)] = inst_25377);

return statearr_25537;
})();
if(cljs.core.truth_(offset)){
var statearr_25538_25598 = state_25480__$1;
(statearr_25538_25598[(1)] = (15));

} else {
var statearr_25539_25599 = state_25480__$1;
(statearr_25539_25599[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (45))){
var inst_25469 = (state_25480[(2)]);
var state_25480__$1 = state_25480;
var statearr_25540_25600 = state_25480__$1;
(statearr_25540_25600[(2)] = inst_25469);

(statearr_25540_25600[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (26))){
var inst_25425 = (state_25480[(12)]);
var inst_25427 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_25428 = [headers,vars,inst_25425];
var inst_25429 = cljs.core.PersistentHashMap.fromArrays(inst_25427,inst_25428);
var inst_25430 = cljs.core.assoc.call(null,select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_25431 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_25432 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,inst_25429,inst_25430,inst_25431);
var state_25480__$1 = state_25480;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25480__$1,(29),inst_25432);
} else {
if((state_val_25481 === (16))){
var inst_25377 = (state_25480[(13)]);
var state_25480__$1 = state_25480;
var statearr_25541_25601 = state_25480__$1;
(statearr_25541_25601[(2)] = inst_25377);

(statearr_25541_25601[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (38))){
var inst_25451 = (state_25480[(14)]);
var state_25480__$1 = state_25480;
var statearr_25542_25602 = state_25480__$1;
(statearr_25542_25602[(2)] = inst_25451);

(statearr_25542_25602[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (30))){
var state_25480__$1 = state_25480;
var statearr_25543_25603 = state_25480__$1;
(statearr_25543_25603[(2)] = (1));

(statearr_25543_25603[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (10))){
var inst_25366 = (state_25480[(17)]);
var state_25480__$1 = state_25480;
var statearr_25544_25604 = state_25480__$1;
(statearr_25544_25604[(2)] = inst_25366);

(statearr_25544_25604[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (18))){
var inst_25382 = (state_25480[(18)]);
var inst_25384 = cljs.core.take.call(null,limit,inst_25382);
var state_25480__$1 = state_25480;
var statearr_25545_25605 = state_25480__$1;
(statearr_25545_25605[(2)] = inst_25384);

(statearr_25545_25605[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (42))){
var inst_25471 = (state_25480[(2)]);
var state_25480__$1 = state_25480;
var statearr_25546_25606 = state_25480__$1;
(statearr_25546_25606[(2)] = inst_25471);

(statearr_25546_25606[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (37))){
var inst_25451 = (state_25480[(14)]);
var inst_25456 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25457 = [inst_25451];
var inst_25458 = (new cljs.core.PersistentVector(null,1,(5),inst_25456,inst_25457,null));
var state_25480__$1 = state_25480;
var statearr_25547_25607 = state_25480__$1;
(statearr_25547_25607[(2)] = inst_25458);

(statearr_25547_25607[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25481 === (8))){
var inst_25475 = (state_25480[(2)]);
var _ = (function (){var statearr_25548 = state_25480;
(statearr_25548[(4)] = cljs.core.rest.call(null,(state_25480[(4)])));

return statearr_25548;
})();
var state_25480__$1 = state_25480;
var statearr_25549_25608 = state_25480__$1;
(statearr_25549_25608[(2)] = inst_25475);

(statearr_25549_25608[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____0 = (function (){
var statearr_25550 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25550[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__);

(statearr_25550[(1)] = (1));

return statearr_25550;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____1 = (function (state_25480){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25480);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25551){var ex__2749__auto__ = e25551;
var statearr_25552_25609 = state_25480;
(statearr_25552_25609[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25480[(4)]))){
var statearr_25553_25610 = state_25480;
(statearr_25553_25610[(1)] = cljs.core.first.call(null,(state_25480[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25611 = state_25480;
state_25480 = G__25611;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__ = function(state_25480){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____1.call(this,state_25480);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25554 = f__2769__auto__.call(null);
(statearr_25554[(6)] = c__2768__auto__);

return statearr_25554;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.fql.process_ad_hoc_query = (function fluree$db$query$fql$process_ad_hoc_query(p__25612){
var map__25613 = p__25612;
var map__25613__$1 = cljs.core.__destructure_map.call(null,map__25613);
var opts = map__25613__$1;
var db = cljs.core.get.call(null,map__25613__$1,new cljs.core.Keyword(null,"db","db",993250759));
var parsed_query = cljs.core.get.call(null,map__25613__$1,new cljs.core.Keyword(null,"parsed-query","parsed-query",-428212689));
var fuel = cljs.core.get.call(null,map__25613__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485));
var max_fuel = cljs.core.get.call(null,map__25613__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25633){
var state_val_25634 = (state_25633[(1)]);
if((state_val_25634 === (1))){
var state_25633__$1 = state_25633;
var statearr_25635_25649 = state_25633__$1;
(statearr_25635_25649[(2)] = null);

(statearr_25635_25649[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25634 === (2))){
var _ = (function (){var statearr_25636 = state_25633;
(statearr_25636[(4)] = cljs.core.cons.call(null,(5),(state_25633[(4)])));

return statearr_25636;
})();
var inst_25620 = fluree.db.query.analytical.q.call(null,opts);
var state_25633__$1 = state_25633;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25633__$1,(6),inst_25620);
} else {
if((state_val_25634 === (3))){
var inst_25631 = (state_25633[(2)]);
var state_25633__$1 = state_25633;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25633__$1,inst_25631);
} else {
if((state_val_25634 === (4))){
var inst_25614 = (state_25633[(2)]);
var state_25633__$1 = state_25633;
var statearr_25638_25650 = state_25633__$1;
(statearr_25638_25650[(2)] = inst_25614);

(statearr_25638_25650[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25634 === (5))){
var _ = (function (){var statearr_25639 = state_25633;
(statearr_25639[(4)] = cljs.core.rest.call(null,(state_25633[(4)])));

return statearr_25639;
})();
var state_25633__$1 = state_25633;
var ex25637 = (state_25633__$1[(2)]);
var statearr_25640_25651 = state_25633__$1;
(statearr_25640_25651[(5)] = ex25637);


if((ex25637 instanceof Error)){
var statearr_25641_25652 = state_25633__$1;
(statearr_25641_25652[(1)] = (4));

(statearr_25641_25652[(5)] = null);

} else {
throw ex25637;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25634 === (6))){
var inst_25622 = (state_25633[(2)]);
var inst_25623 = fluree.db.util.async.throw_err.call(null,inst_25622);
var inst_25624 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(parsed_query);
var inst_25625 = fluree.db.query.fql.process_ad_hoc_res.call(null,db,fuel,max_fuel,inst_25623,inst_25624,opts);
var state_25633__$1 = state_25633;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25633__$1,(7),inst_25625);
} else {
if((state_val_25634 === (7))){
var inst_25627 = (state_25633[(2)]);
var inst_25628 = fluree.db.util.async.throw_err.call(null,inst_25627);
var _ = (function (){var statearr_25642 = state_25633;
(statearr_25642[(4)] = cljs.core.rest.call(null,(state_25633[(4)])));

return statearr_25642;
})();
var state_25633__$1 = state_25633;
var statearr_25643_25653 = state_25633__$1;
(statearr_25643_25653[(2)] = inst_25628);

(statearr_25643_25653[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2746__auto____0 = (function (){
var statearr_25644 = [null,null,null,null,null,null,null];
(statearr_25644[(0)] = fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2746__auto__);

(statearr_25644[(1)] = (1));

return statearr_25644;
});
var fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2746__auto____1 = (function (state_25633){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25633);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25645){var ex__2749__auto__ = e25645;
var statearr_25646_25654 = state_25633;
(statearr_25646_25654[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25633[(4)]))){
var statearr_25647_25655 = state_25633;
(statearr_25647_25655[(1)] = cljs.core.first.call(null,(state_25633[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25656 = state_25633;
state_25633 = G__25656;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2746__auto__ = function(state_25633){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2746__auto____1.call(this,state_25633);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2746__auto____0;
fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2746__auto____1;
return fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25648 = f__2769__auto__.call(null);
(statearr_25648[(6)] = c__2768__auto__);

return statearr_25648;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.fql.relationship_binding = (function fluree$db$query$fql$relationship_binding(p__25657){
var map__25658 = p__25657;
var map__25658__$1 = cljs.core.__destructure_map.call(null,map__25658);
var opts = map__25658__$1;
var vars = cljs.core.get.call(null,map__25658__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25694){
var state_val_25695 = (state_25694[(1)]);
if((state_val_25695 === (1))){
var inst_25666 = vars;
var inst_25667 = cljs.core.seq.call(null,inst_25666);
var inst_25668 = cljs.core.first.call(null,inst_25667);
var inst_25669 = cljs.core.next.call(null,inst_25667);
var inst_25670 = cljs.core.PersistentVector.EMPTY;
var inst_25671 = inst_25666;
var inst_25672 = inst_25670;
var state_25694__$1 = (function (){var statearr_25696 = state_25694;
(statearr_25696[(7)] = inst_25668);

(statearr_25696[(8)] = inst_25669);

(statearr_25696[(9)] = inst_25671);

(statearr_25696[(10)] = inst_25672);

return statearr_25696;
})();
var statearr_25697_25710 = state_25694__$1;
(statearr_25697_25710[(2)] = null);

(statearr_25697_25710[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25695 === (2))){
var inst_25678 = (state_25694[(11)]);
var inst_25671 = (state_25694[(9)]);
var inst_25677 = cljs.core.seq.call(null,inst_25671);
var inst_25678__$1 = cljs.core.first.call(null,inst_25677);
var inst_25679 = cljs.core.next.call(null,inst_25677);
var state_25694__$1 = (function (){var statearr_25698 = state_25694;
(statearr_25698[(12)] = inst_25679);

(statearr_25698[(11)] = inst_25678__$1);

return statearr_25698;
})();
if(cljs.core.truth_(inst_25678__$1)){
var statearr_25699_25711 = state_25694__$1;
(statearr_25699_25711[(1)] = (4));

} else {
var statearr_25700_25712 = state_25694__$1;
(statearr_25700_25712[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25695 === (3))){
var inst_25692 = (state_25694[(2)]);
var state_25694__$1 = state_25694;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25694__$1,inst_25692);
} else {
if((state_val_25695 === (4))){
var inst_25678 = (state_25694[(11)]);
var inst_25681 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"vars","vars",-2046957217),inst_25678);
var inst_25682 = fluree.db.query.fql.process_ad_hoc_query.call(null,inst_25681);
var state_25694__$1 = state_25694;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25694__$1,(7),inst_25682);
} else {
if((state_val_25695 === (5))){
var inst_25672 = (state_25694[(10)]);
var state_25694__$1 = state_25694;
var statearr_25701_25713 = state_25694__$1;
(statearr_25701_25713[(2)] = inst_25672);

(statearr_25701_25713[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25695 === (6))){
var inst_25690 = (state_25694[(2)]);
var state_25694__$1 = state_25694;
var statearr_25702_25714 = state_25694__$1;
(statearr_25702_25714[(2)] = inst_25690);

(statearr_25702_25714[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25695 === (7))){
var inst_25679 = (state_25694[(12)]);
var inst_25672 = (state_25694[(10)]);
var inst_25684 = (state_25694[(2)]);
var inst_25685 = fluree.db.util.async.throw_err.call(null,inst_25684);
var inst_25686 = cljs.core.into.call(null,inst_25672,inst_25685);
var inst_25671 = inst_25679;
var inst_25672__$1 = inst_25686;
var state_25694__$1 = (function (){var statearr_25703 = state_25694;
(statearr_25703[(9)] = inst_25671);

(statearr_25703[(10)] = inst_25672__$1);

return statearr_25703;
})();
var statearr_25704_25715 = state_25694__$1;
(statearr_25704_25715[(2)] = null);

(statearr_25704_25715[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$relationship_binding_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$relationship_binding_$_state_machine__2746__auto____0 = (function (){
var statearr_25705 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25705[(0)] = fluree$db$query$fql$relationship_binding_$_state_machine__2746__auto__);

(statearr_25705[(1)] = (1));

return statearr_25705;
});
var fluree$db$query$fql$relationship_binding_$_state_machine__2746__auto____1 = (function (state_25694){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25694);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25706){var ex__2749__auto__ = e25706;
var statearr_25707_25716 = state_25694;
(statearr_25707_25716[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25694[(4)]))){
var statearr_25708_25717 = state_25694;
(statearr_25708_25717[(1)] = cljs.core.first.call(null,(state_25694[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25718 = state_25694;
state_25694 = G__25718;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$relationship_binding_$_state_machine__2746__auto__ = function(state_25694){
switch(arguments.length){
case 0:
return fluree$db$query$fql$relationship_binding_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$relationship_binding_$_state_machine__2746__auto____1.call(this,state_25694);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$relationship_binding_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$relationship_binding_$_state_machine__2746__auto____0;
fluree$db$query$fql$relationship_binding_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$relationship_binding_$_state_machine__2746__auto____1;
return fluree$db$query$fql$relationship_binding_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25709 = f__2769__auto__.call(null);
(statearr_25709[(6)] = c__2768__auto__);

return statearr_25709;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Legacy ad-hoc query processor
 */
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,p__25719,query_map){
var map__25720 = p__25719;
var map__25720__$1 = cljs.core.__destructure_map.call(null,map__25720);
var parsed_query = map__25720__$1;
var rel_binding_QMARK_ = cljs.core.get.call(null,map__25720__$1,new cljs.core.Keyword(null,"rel-binding?","rel-binding?",1563806094));
var vars = cljs.core.get.call(null,map__25720__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__25721 = query_map;
var map__25721__$1 = cljs.core.__destructure_map.call(null,map__25721);
var selectOne = cljs.core.get.call(null,map__25721__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var limit = cljs.core.get.call(null,map__25721__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__25721__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.call(null,map__25721__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var orderBy = cljs.core.get.call(null,map__25721__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var groupBy = cljs.core.get.call(null,map__25721__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var prettyPrint = cljs.core.get.call(null,map__25721__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var opts = cljs.core.get.call(null,map__25721__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var opts_SINGLEQUOTE_ = (function (){var G__25722 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"limit","limit",-1355822363),limit,new cljs.core.Keyword(null,"offset","offset",296498311),(function (){var or__5045__auto__ = offset;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})(),new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),orderBy,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),prettyPrint], null),opts);
var G__25722__$1 = (cljs.core.truth_(selectOne)?cljs.core.assoc.call(null,G__25722,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1)):G__25722);
return cljs.core.assoc.call(null,G__25722__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"fuel","fuel",10405485),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.truth_((function (){var or__5045__auto____$1 = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_.call(null,(0));
} else {
return null;
}
}
})(),new cljs.core.Keyword(null,"parsed-query","parsed-query",-428212689),parsed_query,new cljs.core.Keyword(null,"query-map","query-map",-808576972),query_map,new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars);

})();
if(cljs.core.truth_(rel_binding_QMARK_)){
return fluree.db.query.fql.relationship_binding.call(null,opts_SINGLEQUOTE_);
} else {
return fluree.db.query.fql.process_ad_hoc_query.call(null,opts_SINGLEQUOTE_);
}
});
/**
 * Returns already cached query from cache if available, else
 *   executes and stores query into cache.
 */
fluree.db.query.fql.cache_query = (function fluree$db$query$fql$cache_query(p__25723,p__25724){
var map__25725 = p__25723;
var map__25725__$1 = cljs.core.__destructure_map.call(null,map__25725);
var db = map__25725__$1;
var network = cljs.core.get.call(null,map__25725__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__25725__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var block = cljs.core.get.call(null,map__25725__$1,new cljs.core.Keyword(null,"block","block",664686210));
var auth = cljs.core.get.call(null,map__25725__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var conn = cljs.core.get.call(null,map__25725__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var map__25726 = p__25724;
var map__25726__$1 = cljs.core.__destructure_map.call(null,map__25726);
var query_map = map__25726__$1;
var opts = cljs.core.get.call(null,map__25726__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var oc = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
var query_STAR_ = cljs.core.update.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.dissoc,new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var cache_key = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query","query",-1288509510),network,ledger_id,block,auth,query_STAR_], null);
return oc.call(null,cache_key,(function (_){
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___25743 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_25736){
var state_val_25737 = (state_25736[(1)]);
if((state_val_25737 === (1))){
var inst_25727 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25728 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"cache","cache",-1237023054)];
var inst_25729 = (new cljs.core.PersistentVector(null,2,(5),inst_25727,inst_25728,null));
var inst_25730 = cljs.core.assoc_in.call(null,query_map,inst_25729,false);
var inst_25731 = fluree.db.query.fql.query.call(null,db,inst_25730);
var state_25736__$1 = state_25736;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25736__$1,(2),inst_25731);
} else {
if((state_val_25737 === (2))){
var inst_25733 = (state_25736[(2)]);
var inst_25734 = cljs.core.async.put_BANG_.call(null,pc,inst_25733);
var state_25736__$1 = state_25736;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25736__$1,inst_25734);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$cache_query_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql$cache_query_$_state_machine__2746__auto____0 = (function (){
var statearr_25738 = [null,null,null,null,null,null,null];
(statearr_25738[(0)] = fluree$db$query$fql$cache_query_$_state_machine__2746__auto__);

(statearr_25738[(1)] = (1));

return statearr_25738;
});
var fluree$db$query$fql$cache_query_$_state_machine__2746__auto____1 = (function (state_25736){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_25736);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e25739){var ex__2749__auto__ = e25739;
var statearr_25740_25744 = state_25736;
(statearr_25740_25744[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_25736[(4)]))){
var statearr_25741_25745 = state_25736;
(statearr_25741_25745[(1)] = cljs.core.first.call(null,(state_25736[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25746 = state_25736;
state_25736 = G__25746;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql$cache_query_$_state_machine__2746__auto__ = function(state_25736){
switch(arguments.length){
case 0:
return fluree$db$query$fql$cache_query_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql$cache_query_$_state_machine__2746__auto____1.call(this,state_25736);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$cache_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$cache_query_$_state_machine__2746__auto____0;
fluree$db$query$fql$cache_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$cache_query_$_state_machine__2746__auto____1;
return fluree$db$query$fql$cache_query_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_25742 = f__2769__auto__.call(null);
(statearr_25742[(6)] = c__2768__auto___25743);

return statearr_25742;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));
});
/**
 * Returns true if query was requested to run from the cache.
 */
fluree.db.query.fql.cache_QMARK_ = (function fluree$db$query$fql$cache_QMARK_(p__25747){
var map__25748 = p__25747;
var map__25748__$1 = cljs.core.__destructure_map.call(null,map__25748);
var _query_map = map__25748__$1;
var opts = cljs.core.get.call(null,map__25748__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
return false;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
fluree.db.util.log.debug.call(null,"Running query:",cljs.core.pr_str.call(null,query_map));

if(fluree.db.query.fql.cache_QMARK_.call(null,query_map)){
return fluree.db.query.fql.cache_query.call(null,db,query_map);
} else {
var parsed_query = fluree.db.query.analytical_parse.parse.call(null,db,query_map);
var db_STAR_ = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"ctx-cache","ctx-cache",-391738418),cljs.core.volatile_BANG_.call(null,cljs.core.PersistentArrayMap.EMPTY));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"simple-subject-crawl","simple-subject-crawl",1022725044),new cljs.core.Keyword(null,"strategy","strategy",-1471631918).cljs$core$IFn$_invoke$arity$1(parsed_query))){
return fluree.db.query.subject_crawl.core.simple_subject_crawl.call(null,db_STAR_,parsed_query);
} else {
return fluree.db.query.fql.ad_hoc_query.call(null,db_STAR_,parsed_query,query_map);
}
}
});
