// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.subject_crawl.common');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.schema');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.query.fql_resp');
/**
 * Transducing function to extract matching subjects from initial where clause.
 */
fluree.db.query.subject_crawl.common.where_subj_xf = (function fluree$db$query$subject_crawl$common$where_subj_xf(p__23491){
var map__23492 = p__23491;
var map__23492__$1 = cljs.core.__destructure_map.call(null,map__23492);
var start_test = cljs.core.get.call(null,map__23492__$1,new cljs.core.Keyword(null,"start-test","start-test",-952983565));
var start_flake = cljs.core.get.call(null,map__23492__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_test = cljs.core.get.call(null,map__23492__$1,new cljs.core.Keyword(null,"end-test","end-test",481973727));
var end_flake = cljs.core.get.call(null,map__23492__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var xf = cljs.core.get.call(null,map__23492__$1,new cljs.core.Keyword(null,"xf","xf",401902988));
return cljs.core.apply.call(null,cljs.core.comp,(function (){var G__23493 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.map.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739)),cljs.core.map.call(null,(function (flakes){
return fluree.db.flake.subrange.call(null,flakes,start_test,start_flake,end_test,end_flake);
}))], null);
if(cljs.core.truth_(xf)){
return cljs.core.conj.call(null,G__23493,xf);
} else {
return G__23493;
}
})());
});
fluree.db.query.subject_crawl.common.result_af = (function fluree$db$query$subject_crawl$common$result_af(p__23494){
var map__23495 = p__23494;
var map__23495__$1 = cljs.core.__destructure_map.call(null,map__23495);
var _opts = map__23495__$1;
var db = cljs.core.get.call(null,map__23495__$1,new cljs.core.Keyword(null,"db","db",993250759));
var cache = cljs.core.get.call(null,map__23495__$1,new cljs.core.Keyword(null,"cache","cache",-1237023054));
var fuel_vol = cljs.core.get.call(null,map__23495__$1,new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142));
var max_fuel = cljs.core.get.call(null,map__23495__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var select_spec = cljs.core.get.call(null,map__23495__$1,new cljs.core.Keyword(null,"select-spec","select-spec",55073283));
var error_ch = cljs.core.get.call(null,map__23495__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
return (function (flakes,port){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23526){
var state_val_23527 = (state_23526[(1)]);
if((state_val_23527 === (7))){
var state_23526__$1 = state_23526;
var statearr_23528_23554 = state_23526__$1;
(statearr_23528_23554[(2)] = null);

(statearr_23528_23554[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23527 === (1))){
var state_23526__$1 = state_23526;
var statearr_23529_23555 = state_23526__$1;
(statearr_23529_23555[(2)] = null);

(statearr_23529_23555[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23527 === (4))){
var inst_23496 = (state_23526[(2)]);
var inst_23497 = cljs.core.async.put_BANG_.call(null,error_ch,inst_23496);
var inst_23498 = cljs.core.async.close_BANG_.call(null,port);
var state_23526__$1 = (function (){var statearr_23530 = state_23526;
(statearr_23530[(7)] = inst_23497);

(statearr_23530[(8)] = inst_23498);

return statearr_23530;
})();
var statearr_23531_23556 = state_23526__$1;
(statearr_23531_23556[(2)] = null);

(statearr_23531_23556[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23527 === (6))){
var inst_23508 = (state_23526[(9)]);
var inst_23507 = (state_23526[(2)]);
var inst_23508__$1 = fluree.db.util.async.throw_err.call(null,inst_23507);
var inst_23509 = (inst_23508__$1 == null);
var state_23526__$1 = (function (){var statearr_23532 = state_23526;
(statearr_23532[(9)] = inst_23508__$1);

return statearr_23532;
})();
if(cljs.core.truth_(inst_23509)){
var statearr_23533_23557 = state_23526__$1;
(statearr_23533_23557[(1)] = (7));

} else {
var statearr_23534_23558 = state_23526__$1;
(statearr_23534_23558[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23527 === (3))){
var inst_23524 = (state_23526[(2)]);
var state_23526__$1 = state_23526;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23526__$1,inst_23524);
} else {
if((state_val_23527 === (12))){
var inst_23520 = (state_23526[(2)]);
var inst_23521 = cljs.core.async.close_BANG_.call(null,port);
var _ = (function (){var statearr_23535 = state_23526;
(statearr_23535[(4)] = cljs.core.rest.call(null,(state_23526[(4)])));

return statearr_23535;
})();
var state_23526__$1 = (function (){var statearr_23536 = state_23526;
(statearr_23536[(10)] = inst_23520);

return statearr_23536;
})();
var statearr_23537_23559 = state_23526__$1;
(statearr_23537_23559[(2)] = inst_23521);

(statearr_23537_23559[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23527 === (2))){
var _ = (function (){var statearr_23538 = state_23526;
(statearr_23538[(4)] = cljs.core.cons.call(null,(5),(state_23526[(4)])));

return statearr_23538;
})();
var inst_23505 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel_vol,max_fuel,select_spec,flakes);
var state_23526__$1 = state_23526;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23526__$1,(6),inst_23505);
} else {
if((state_val_23527 === (11))){
var inst_23514 = (state_23526[(11)]);
var inst_23518 = cljs.core.async.put_BANG_.call(null,port,inst_23514);
var state_23526__$1 = state_23526;
var statearr_23540_23560 = state_23526__$1;
(statearr_23540_23560[(2)] = inst_23518);

(statearr_23540_23560[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23527 === (9))){
var inst_23514 = (state_23526[(11)]);
var inst_23514__$1 = (state_23526[(2)]);
var inst_23515 = (inst_23514__$1 == null);
var state_23526__$1 = (function (){var statearr_23541 = state_23526;
(statearr_23541[(11)] = inst_23514__$1);

return statearr_23541;
})();
if(cljs.core.truth_(inst_23515)){
var statearr_23542_23561 = state_23526__$1;
(statearr_23542_23561[(1)] = (10));

} else {
var statearr_23543_23562 = state_23526__$1;
(statearr_23543_23562[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23527 === (5))){
var _ = (function (){var statearr_23544 = state_23526;
(statearr_23544[(4)] = cljs.core.rest.call(null,(state_23526[(4)])));

return statearr_23544;
})();
var state_23526__$1 = state_23526;
var ex23539 = (state_23526__$1[(2)]);
var statearr_23545_23563 = state_23526__$1;
(statearr_23545_23563[(5)] = ex23539);


var statearr_23546_23564 = state_23526__$1;
(statearr_23546_23564[(1)] = (4));

(statearr_23546_23564[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23527 === (10))){
var state_23526__$1 = state_23526;
var statearr_23547_23565 = state_23526__$1;
(statearr_23547_23565[(2)] = null);

(statearr_23547_23565[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23527 === (8))){
var inst_23508 = (state_23526[(9)]);
var inst_23512 = cljs.core.not_empty.call(null,inst_23508);
var state_23526__$1 = state_23526;
var statearr_23548_23566 = state_23526__$1;
(statearr_23548_23566[(2)] = inst_23512);

(statearr_23548_23566[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto____0 = (function (){
var statearr_23549 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23549[(0)] = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto__);

(statearr_23549[(1)] = (1));

return statearr_23549;
});
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto____1 = (function (state_23526){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23526);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23550){var ex__2749__auto__ = e23550;
var statearr_23551_23567 = state_23526;
(statearr_23551_23567[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23526[(4)]))){
var statearr_23552_23568 = state_23526;
(statearr_23552_23568[(1)] = cljs.core.first.call(null,(state_23526[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23569 = state_23526;
state_23526 = G__23569;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto__ = function(state_23526){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto____1.call(this,state_23526);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23553 = f__2769__auto__.call(null);
(statearr_23553[(6)] = c__2768__auto__);

return statearr_23553;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
});
/**
 * Returns a specific filtering function which takes all subject flakes and
 *   returns the flakes allowed, or nil if none are allowed.
 */
fluree.db.query.subject_crawl.common.subj_perm_filter_fn = (function fluree$db$query$subject_crawl$common$subj_perm_filter_fn(p__23570){
var map__23571 = p__23570;
var map__23571__$1 = cljs.core.__destructure_map.call(null,map__23571);
var db = map__23571__$1;
var permissions = cljs.core.get.call(null,map__23571__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var pred_permissions_QMARK_ = cljs.core.contains_QMARK_.call(null,permissions,new cljs.core.Keyword(null,"predicate","predicate",-1742501860));
var coll_permissions = new cljs.core.Keyword(null,"collection","collection",-683361892).cljs$core$IFn$_invoke$arity$1(permissions);
var filter_cache = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var default_deny_QMARK_ = ((new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(coll_permissions) === true)?false:true);
var filter_predicates_QMARK_ = (function (cid){
var temp__5806__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,filter_cache),cid);
if((temp__5806__auto__ == null)){
var coll_perm = cljs.core.get.call(null,coll_permissions,cid);
var filter_QMARK_ = ((fluree.db.util.schema.is_schema_cid_QMARK_.call(null,cid))?false:((pred_permissions_QMARK_)?true:(((coll_perm == null))?default_deny_QMARK_:((((cljs.core.contains_QMARK_.call(null,coll_perm,new cljs.core.Keyword(null,"all","all",892129742))) && (cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,coll_perm)))))?false:true
))));
cljs.core.swap_BANG_.call(null,filter_cache,cljs.core.assoc,cid,filter_QMARK_);

return cljs.core.filter;
} else {
var cached = temp__5806__auto__;
return cached;
}
});
return (function (flakes){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23602){
var state_val_23603 = (state_23602[(1)]);
if((state_val_23603 === (7))){
var inst_23578 = (state_23602[(7)]);
var inst_23588 = fluree.db.permissions_validate.allow_flake_QMARK_.call(null,db,inst_23578);
var state_23602__$1 = state_23602;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23602__$1,(10),inst_23588);
} else {
if((state_val_23603 === (1))){
var state_23602__$1 = state_23602;
var statearr_23604_23627 = state_23602__$1;
(statearr_23604_23627[(2)] = null);

(statearr_23604_23627[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23603 === (4))){
var inst_23572 = (state_23602[(2)]);
var state_23602__$1 = state_23602;
var statearr_23605_23628 = state_23602__$1;
(statearr_23605_23628[(2)] = inst_23572);

(statearr_23605_23628[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23603 === (13))){
var inst_23595 = (state_23602[(2)]);
var state_23602__$1 = state_23602;
var statearr_23606_23629 = state_23602__$1;
(statearr_23606_23629[(2)] = inst_23595);

(statearr_23606_23629[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23603 === (6))){
var inst_23583 = fluree.db.permissions_validate.allow_flakes_QMARK_.call(null,db,flakes);
var state_23602__$1 = state_23602;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23602__$1,(9),inst_23583);
} else {
if((state_val_23603 === (3))){
var inst_23600 = (state_23602[(2)]);
var state_23602__$1 = state_23602;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23602__$1,inst_23600);
} else {
if((state_val_23603 === (12))){
var state_23602__$1 = state_23602;
var statearr_23607_23630 = state_23602__$1;
(statearr_23607_23630[(2)] = null);

(statearr_23607_23630[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23603 === (2))){
var inst_23578 = (state_23602[(7)]);
var _ = (function (){var statearr_23608 = state_23602;
(statearr_23608[(4)] = cljs.core.cons.call(null,(5),(state_23602[(4)])));

return statearr_23608;
})();
var inst_23578__$1 = cljs.core.first.call(null,flakes);
var inst_23579 = fluree.db.flake.s.call(null,inst_23578__$1);
var inst_23580 = fluree.db.flake.sid__GT_cid.call(null,inst_23579);
var inst_23581 = filter_predicates_QMARK_.call(null,inst_23580);
var state_23602__$1 = (function (){var statearr_23609 = state_23602;
(statearr_23609[(7)] = inst_23578__$1);

return statearr_23609;
})();
if(cljs.core.truth_(inst_23581)){
var statearr_23610_23631 = state_23602__$1;
(statearr_23610_23631[(1)] = (6));

} else {
var statearr_23611_23632 = state_23602__$1;
(statearr_23611_23632[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23603 === (11))){
var state_23602__$1 = state_23602;
var statearr_23613_23633 = state_23602__$1;
(statearr_23613_23633[(2)] = flakes);

(statearr_23613_23633[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23603 === (9))){
var inst_23585 = (state_23602[(2)]);
var inst_23586 = fluree.db.util.async.throw_err.call(null,inst_23585);
var state_23602__$1 = state_23602;
var statearr_23614_23634 = state_23602__$1;
(statearr_23614_23634[(2)] = inst_23586);

(statearr_23614_23634[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23603 === (5))){
var _ = (function (){var statearr_23615 = state_23602;
(statearr_23615[(4)] = cljs.core.rest.call(null,(state_23602[(4)])));

return statearr_23615;
})();
var state_23602__$1 = state_23602;
var ex23612 = (state_23602__$1[(2)]);
var statearr_23616_23635 = state_23602__$1;
(statearr_23616_23635[(5)] = ex23612);


if((ex23612 instanceof Error)){
var statearr_23617_23636 = state_23602__$1;
(statearr_23617_23636[(1)] = (4));

(statearr_23617_23636[(5)] = null);

} else {
throw ex23612;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23603 === (10))){
var inst_23590 = (state_23602[(2)]);
var inst_23591 = fluree.db.util.async.throw_err.call(null,inst_23590);
var state_23602__$1 = state_23602;
if(cljs.core.truth_(inst_23591)){
var statearr_23618_23637 = state_23602__$1;
(statearr_23618_23637[(1)] = (11));

} else {
var statearr_23619_23638 = state_23602__$1;
(statearr_23619_23638[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23603 === (8))){
var inst_23597 = (state_23602[(2)]);
var _ = (function (){var statearr_23620 = state_23602;
(statearr_23620[(4)] = cljs.core.rest.call(null,(state_23602[(4)])));

return statearr_23620;
})();
var state_23602__$1 = state_23602;
var statearr_23621_23639 = state_23602__$1;
(statearr_23621_23639[(2)] = inst_23597);

(statearr_23621_23639[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto____0 = (function (){
var statearr_23622 = [null,null,null,null,null,null,null,null];
(statearr_23622[(0)] = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto__);

(statearr_23622[(1)] = (1));

return statearr_23622;
});
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto____1 = (function (state_23602){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23602);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23623){var ex__2749__auto__ = e23623;
var statearr_23624_23640 = state_23602;
(statearr_23624_23640[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23602[(4)]))){
var statearr_23625_23641 = state_23602;
(statearr_23625_23641[(1)] = cljs.core.first.call(null,(state_23602[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23642 = state_23602;
state_23602 = G__23642;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto__ = function(state_23602){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto____1.call(this,state_23602);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23626 = f__2769__auto__.call(null);
(statearr_23626[(6)] = c__2768__auto__);

return statearr_23626;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
});
fluree.db.query.subject_crawl.common.passes_filter_QMARK_ = (function fluree$db$query$subject_crawl$common$passes_filter_QMARK_(filter_fn,vars,pred_flakes){
return cljs.core.some.call(null,(function (p1__23643_SHARP_){
return filter_fn.call(null,p1__23643_SHARP_,vars);
}),pred_flakes);
});
/**
 * For a group of predicate flakes (all same .-p value)
 *   and a list of filter-functions, returns true if at least
 *   one of the predicates passes every function, else returns false.
 */
fluree.db.query.subject_crawl.common.pass_all_filters_QMARK_ = (function fluree$db$query$subject_crawl$common$pass_all_filters_QMARK_(filter_fns,vars,pred_flakes){
var G__23647 = filter_fns;
var vec__23648 = G__23647;
var seq__23649 = cljs.core.seq.call(null,vec__23648);
var first__23650 = cljs.core.first.call(null,seq__23649);
var seq__23649__$1 = cljs.core.next.call(null,seq__23649);
var filter_fn = first__23650;
var r_fns = seq__23649__$1;
var G__23647__$1 = G__23647;
while(true){
var vec__23651 = G__23647__$1;
var seq__23652 = cljs.core.seq.call(null,vec__23651);
var first__23653 = cljs.core.first.call(null,seq__23652);
var seq__23652__$1 = cljs.core.next.call(null,seq__23652);
var filter_fn__$1 = first__23653;
var r_fns__$1 = seq__23652__$1;
if(cljs.core.truth_(filter_fn__$1)){
if(cljs.core.truth_(fluree.db.query.subject_crawl.common.passes_filter_QMARK_.call(null,filter_fn__$1,vars,pred_flakes))){
var G__23654 = r_fns__$1;
G__23647__$1 = G__23654;
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
});
/**
 * Filters a set of flakes for a single subject and returns true if
 *   the subject meets the filter map.
 * 
 *   filter-map is a map where pred-ids are keys and values are a list of filtering functions
 *   where each flake of pred-id must return a truthy value if the subject is allowed.
 */
fluree.db.query.subject_crawl.common.filter_subject = (function fluree$db$query$subject_crawl$common$filter_subject(vars,filter_map,flakes){
var G__23658 = cljs.core.partition_by.call(null,fluree.db.flake.p,flakes);
var vec__23659 = G__23658;
var seq__23660 = cljs.core.seq.call(null,vec__23659);
var first__23661 = cljs.core.first.call(null,seq__23660);
var seq__23660__$1 = cljs.core.next.call(null,seq__23660);
var p_flakes = first__23661;
var r = seq__23660__$1;
var required_p = new cljs.core.Keyword(null,"required-p","required-p",-2091946078).cljs$core$IFn$_invoke$arity$1(filter_map);
var G__23658__$1 = G__23658;
var required_p__$1 = required_p;
while(true){
var vec__23665 = G__23658__$1;
var seq__23666 = cljs.core.seq.call(null,vec__23665);
var first__23667 = cljs.core.first.call(null,seq__23666);
var seq__23666__$1 = cljs.core.next.call(null,seq__23666);
var p_flakes__$1 = first__23667;
var r__$1 = seq__23666__$1;
var required_p__$2 = required_p__$1;
if(cljs.core.truth_(p_flakes__$1)){
var p = fluree.db.flake.p.call(null,cljs.core.first.call(null,p_flakes__$1));
var temp__5802__auto__ = cljs.core.get.call(null,filter_map,p);
if(cljs.core.truth_(temp__5802__auto__)){
var filter_fns = temp__5802__auto__;
if(fluree.db.query.subject_crawl.common.pass_all_filters_QMARK_.call(null,filter_fns,vars,p_flakes__$1)){
var G__23668 = r__$1;
var G__23669 = cljs.core.disj.call(null,required_p__$2,p);
G__23658__$1 = G__23668;
required_p__$1 = G__23669;
continue;
} else {
return null;
}
} else {
var G__23670 = r__$1;
var G__23671 = cljs.core.disj.call(null,required_p__$2,p);
G__23658__$1 = G__23670;
required_p__$1 = G__23671;
continue;
}
} else {
if(cljs.core.empty_QMARK_.call(null,required_p__$2)){
return flakes;
} else {
return null;
}
}
break;
}
});
/**
 * If order-by exists in query, orders final results.
 *   order-by is defined by a map with keys (see analytical-parse for code):
 *   - :type - :variable or :predicate
 *   - :order - :asc or :desc
 *   - :predicate - if type = :predicate, contains predicate pid or name
 *   - :variable - if type = :variable, contains variable name (not supported for simple subject crawl)
 */
fluree.db.query.subject_crawl.common.order_results = (function fluree$db$query$subject_crawl$common$order_results(results,p__23672,limit){
var map__23673 = p__23672;
var map__23673__$1 = cljs.core.__destructure_map.call(null,map__23673);
var type = cljs.core.get.call(null,map__23673__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var order = cljs.core.get.call(null,map__23673__$1,new cljs.core.Keyword(null,"order","order",-1254677256));
var predicate = cljs.core.get.call(null,map__23673__$1,new cljs.core.Keyword(null,"predicate","predicate",-1742501860));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"variable","variable",-281346492),type)){
throw cljs.core.ex_info.call(null,"Ordering by a variable not supported in this type of query.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
var sorted = (function (){var G__23674 = cljs.core.sort_by.call(null,(function (result){
return cljs.core.get.call(null,result,predicate);
}),results);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"desc","desc",2093485764),order)){
return cljs.core.reverse.call(null,G__23674);
} else {
return G__23674;
}
})();
return cljs.core.vec.call(null,cljs.core.take.call(null,limit,sorted));
}
});
/**
 * When some variables may be idents (two-tuples) they need to get resolved into
 *   subject _id values before executing query.
 */
fluree.db.query.subject_crawl.common.resolve_ident_vars = (function fluree$db$query$subject_crawl$common$resolve_ident_vars(db,vars,ident_vars){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23744){
var state_val_23745 = (state_23744[(1)]);
if((state_val_23745 === (7))){
var inst_23739 = (state_23744[(2)]);
var _ = (function (){var statearr_23746 = state_23744;
(statearr_23746[(4)] = cljs.core.rest.call(null,(state_23744[(4)])));

return statearr_23746;
})();
var state_23744__$1 = state_23744;
var statearr_23747_23789 = state_23744__$1;
(statearr_23747_23789[(2)] = inst_23739);

(statearr_23747_23789[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23745 === (20))){
var inst_23700 = (state_23744[(7)]);
var inst_23694 = (state_23744[(8)]);
var inst_23701 = (state_23744[(9)]);
var inst_23717 = (state_23744[(2)]);
var inst_23718 = cljs.core.assoc.call(null,inst_23694,inst_23700,inst_23717);
var inst_23693 = inst_23701;
var inst_23694__$1 = inst_23718;
var state_23744__$1 = (function (){var statearr_23748 = state_23744;
(statearr_23748[(10)] = inst_23693);

(statearr_23748[(8)] = inst_23694__$1);

return statearr_23748;
})();
var statearr_23749_23790 = state_23744__$1;
(statearr_23749_23790[(2)] = null);

(statearr_23749_23790[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23745 === (1))){
var state_23744__$1 = state_23744;
var statearr_23750_23791 = state_23744__$1;
(statearr_23750_23791[(2)] = null);

(statearr_23750_23791[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23745 === (4))){
var inst_23675 = (state_23744[(2)]);
var state_23744__$1 = state_23744;
var statearr_23751_23792 = state_23744__$1;
(statearr_23751_23792[(2)] = inst_23675);

(statearr_23751_23792[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23745 === (15))){
var state_23744__$1 = state_23744;
var statearr_23752_23793 = state_23744__$1;
(statearr_23752_23793[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23745 === (21))){
var inst_23700 = (state_23744[(7)]);
var inst_23703 = (state_23744[(11)]);
var inst_23722 = ["Invalid identity provided in variable: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_23700),". Must be a two-tuple identity, IRI, or integer id. ","Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_23703)].join('');
var inst_23723 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_23724 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_23725 = cljs.core.PersistentHashMap.fromArrays(inst_23723,inst_23724);
var inst_23726 = cljs.core.ex_info.call(null,inst_23722,inst_23725);
var inst_23727 = (function(){throw inst_23726})();
var state_23744__$1 = state_23744;
var statearr_23754_23794 = state_23744__$1;
(statearr_23754_23794[(2)] = inst_23727);

(statearr_23754_23794[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23745 === (13))){
var inst_23734 = (state_23744[(2)]);
var state_23744__$1 = state_23744;
var statearr_23755_23795 = state_23744__$1;
(statearr_23755_23795[(2)] = inst_23734);

(statearr_23755_23795[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23745 === (22))){
var state_23744__$1 = state_23744;
var statearr_23756_23796 = state_23744__$1;
(statearr_23756_23796[(2)] = null);

(statearr_23756_23796[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23745 === (6))){
var inst_23700 = (state_23744[(7)]);
var inst_23693 = (state_23744[(10)]);
var inst_23699 = cljs.core.seq.call(null,inst_23693);
var inst_23700__$1 = cljs.core.first.call(null,inst_23699);
var inst_23701 = cljs.core.next.call(null,inst_23699);
var state_23744__$1 = (function (){var statearr_23757 = state_23744;
(statearr_23757[(7)] = inst_23700__$1);

(statearr_23757[(9)] = inst_23701);

return statearr_23757;
})();
if(cljs.core.truth_(inst_23700__$1)){
var statearr_23758_23797 = state_23744__$1;
(statearr_23758_23797[(1)] = (8));

} else {
var statearr_23759_23798 = state_23744__$1;
(statearr_23759_23798[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23745 === (17))){
var inst_23713 = (state_23744[(12)]);
var inst_23712 = (state_23744[(2)]);
var inst_23713__$1 = fluree.db.util.async.throw_err.call(null,inst_23712);
var state_23744__$1 = (function (){var statearr_23760 = state_23744;
(statearr_23760[(12)] = inst_23713__$1);

return statearr_23760;
})();
if(cljs.core.truth_(inst_23713__$1)){
var statearr_23761_23799 = state_23744__$1;
(statearr_23761_23799[(1)] = (18));

} else {
var statearr_23762_23800 = state_23744__$1;
(statearr_23762_23800[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23745 === (3))){
var inst_23742 = (state_23744[(2)]);
var state_23744__$1 = state_23744;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23744__$1,inst_23742);
} else {
if((state_val_23745 === (12))){
var inst_23703 = (state_23744[(11)]);
var inst_23708 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_23703);
var state_23744__$1 = state_23744;
if(inst_23708){
var statearr_23763_23801 = state_23744__$1;
(statearr_23763_23801[(1)] = (14));

} else {
var statearr_23764_23802 = state_23744__$1;
(statearr_23764_23802[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23745 === (2))){
var _ = (function (){var statearr_23765 = state_23744;
(statearr_23765[(4)] = cljs.core.cons.call(null,(5),(state_23744[(4)])));

return statearr_23765;
})();
var inst_23688 = ident_vars;
var inst_23689 = cljs.core.seq.call(null,inst_23688);
var inst_23690 = cljs.core.first.call(null,inst_23689);
var inst_23691 = cljs.core.next.call(null,inst_23689);
var inst_23692 = vars;
var inst_23693 = inst_23688;
var inst_23694 = inst_23692;
var state_23744__$1 = (function (){var statearr_23766 = state_23744;
(statearr_23766[(13)] = inst_23691);

(statearr_23766[(14)] = inst_23690);

(statearr_23766[(10)] = inst_23693);

(statearr_23766[(8)] = inst_23694);

return statearr_23766;
})();
var statearr_23767_23803 = state_23744__$1;
(statearr_23767_23803[(2)] = null);

(statearr_23767_23803[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23745 === (23))){
var inst_23730 = (state_23744[(2)]);
var state_23744__$1 = state_23744;
var statearr_23769_23804 = state_23744__$1;
(statearr_23769_23804[(2)] = inst_23730);

(statearr_23769_23804[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23745 === (19))){
var state_23744__$1 = state_23744;
var statearr_23770_23805 = state_23744__$1;
(statearr_23770_23805[(2)] = (0));

(statearr_23770_23805[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23745 === (11))){
var inst_23694 = (state_23744[(8)]);
var inst_23701 = (state_23744[(9)]);
var tmp23768 = inst_23694;
var inst_23693 = inst_23701;
var inst_23694__$1 = tmp23768;
var state_23744__$1 = (function (){var statearr_23772 = state_23744;
(statearr_23772[(10)] = inst_23693);

(statearr_23772[(8)] = inst_23694__$1);

return statearr_23772;
})();
var statearr_23773_23806 = state_23744__$1;
(statearr_23773_23806[(2)] = null);

(statearr_23773_23806[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23745 === (9))){
var inst_23694 = (state_23744[(8)]);
var state_23744__$1 = state_23744;
var statearr_23774_23807 = state_23744__$1;
(statearr_23774_23807[(2)] = inst_23694);

(statearr_23774_23807[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23745 === (5))){
var _ = (function (){var statearr_23775 = state_23744;
(statearr_23775[(4)] = cljs.core.rest.call(null,(state_23744[(4)])));

return statearr_23775;
})();
var state_23744__$1 = state_23744;
var ex23771 = (state_23744__$1[(2)]);
var statearr_23776_23808 = state_23744__$1;
(statearr_23776_23808[(5)] = ex23771);


if((ex23771 instanceof Error)){
var statearr_23777_23809 = state_23744__$1;
(statearr_23777_23809[(1)] = (4));

(statearr_23777_23809[(5)] = null);

} else {
throw ex23771;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23745 === (14))){
var inst_23703 = (state_23744[(11)]);
var inst_23710 = fluree.db.dbproto._subid.call(null,db,inst_23703);
var state_23744__$1 = state_23744;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23744__$1,(17),inst_23710);
} else {
if((state_val_23745 === (16))){
var inst_23732 = (state_23744[(2)]);
var state_23744__$1 = state_23744;
var statearr_23778_23810 = state_23744__$1;
(statearr_23778_23810[(2)] = inst_23732);

(statearr_23778_23810[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23745 === (10))){
var inst_23737 = (state_23744[(2)]);
var state_23744__$1 = state_23744;
var statearr_23779_23811 = state_23744__$1;
(statearr_23779_23811[(2)] = inst_23737);

(statearr_23779_23811[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23745 === (18))){
var inst_23713 = (state_23744[(12)]);
var state_23744__$1 = state_23744;
var statearr_23780_23812 = state_23744__$1;
(statearr_23780_23812[(2)] = inst_23713);

(statearr_23780_23812[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23745 === (8))){
var inst_23700 = (state_23744[(7)]);
var inst_23703 = (state_23744[(11)]);
var inst_23703__$1 = cljs.core.get.call(null,vars,inst_23700);
var inst_23704 = cljs.core.int_QMARK_.call(null,inst_23703__$1);
var state_23744__$1 = (function (){var statearr_23781 = state_23744;
(statearr_23781[(11)] = inst_23703__$1);

return statearr_23781;
})();
if(inst_23704){
var statearr_23782_23813 = state_23744__$1;
(statearr_23782_23813[(1)] = (11));

} else {
var statearr_23783_23814 = state_23744__$1;
(statearr_23783_23814[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2746__auto____0 = (function (){
var statearr_23784 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23784[(0)] = fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2746__auto__);

(statearr_23784[(1)] = (1));

return statearr_23784;
});
var fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2746__auto____1 = (function (state_23744){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23744);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23785){var ex__2749__auto__ = e23785;
var statearr_23786_23815 = state_23744;
(statearr_23786_23815[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23744[(4)]))){
var statearr_23787_23816 = state_23744;
(statearr_23787_23816[(1)] = cljs.core.first.call(null,(state_23744[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23817 = state_23744;
state_23744 = G__23817;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2746__auto__ = function(state_23744){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2746__auto____1.call(this,state_23744);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23788 = f__2769__auto__.call(null);
(statearr_23788[(6)] = c__2768__auto__);

return statearr_23788;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
