// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
fluree.db.util.xhttp.node$module$axios = require('axios');
fluree.db.util.xhttp.node$module$ws = require('ws');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5804__auto__ = e.response;
if(cljs.core.truth_(temp__5804__auto__)){
var resp = temp__5804__auto__;
var temp__5804__auto____$1 = resp.status;
if(cljs.core.truth_(temp__5804__auto____$1)){
var st = temp__5804__auto____$1;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
})();
var error = ((clojure.string.starts_with_QMARK_.call(null,e.message,"timeout"))?new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562):(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return ((((300) <= status)) && ((status <= (499))));
} else {
return and__5043__auto__;
}
})())?new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305):(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return (status >= (500));
} else {
return and__5043__auto__;
}
})())?new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040):(function (){
fluree.db.util.log.error.call(null,"XHTTP Request Error:",e.request);

return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
})()

)));
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__5043__auto__ = status;
if(cljs.core.truth_(and__5043__auto__)){
return (status > (0));
} else {
return and__5043__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.call(null,message,(function (){var G__19690 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.call(null,G__19690,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__19690;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__19691 = opts;
var map__19691__$1 = cljs.core.__destructure_map.call(null,map__19691);
var request_timeout = cljs.core.get.call(null,map__19691__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__19691__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__19691__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__19692 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__19692__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__19692,headers):G__19692);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__19692__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__19692__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"post",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1,new cljs.core.Keyword(null,"data","data",-232669377),message], null))).then((function (resp){
return cljs.core.async.put_BANG_.call(null,response_chan,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.call(null,resp,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true)));
})).catch((function (err){
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,err));
}));

return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json, :edn or :binary (default :text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__19693 = opts;
var map__19693__$1 = cljs.core.__destructure_map.call(null,map__19693);
var request_timeout = cljs.core.get.call(null,map__19693__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__19693__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__19693__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.call(null,map__19693__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.call(null,map__19693__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__19694 = cljs.core.PersistentArrayMap.EMPTY;
var G__19694__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__19694,headers):G__19694);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__19694__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__19694__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"get",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1], null))).then((function (resp){
var data = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.call(null,resp,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true));
return cljs.core.async.put_BANG_.call(null,response_chan,(function (){var G__19695 = output_format;
var G__19695__$1 = (((G__19695 instanceof cljs.core.Keyword))?G__19695.fqn:null);
switch (G__19695__$1) {
case "text":
return data;

break;
case "json":
return fluree.db.util.json.stringify.call(null,data);

break;
default:
throw cljs.core.ex_info.call(null,"http get only supports output formats of json and text.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
})).catch((function (err){
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,err));
}));

return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__19697 = cljs.core.assoc.call(null,cljs.core.assoc_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.call(null,G__19697,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify.call(null,new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__19697;
}
})();
return fluree.db.util.xhttp.get.call(null,url,opts_STAR_);
});
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19729){
var state_val_19730 = (state_19729[(1)]);
if((state_val_19730 === (7))){
var inst_19725 = (state_19729[(2)]);
var state_19729__$1 = state_19729;
var statearr_19731_19756 = state_19729__$1;
(statearr_19731_19756[(2)] = inst_19725);

(statearr_19731_19756[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19730 === (1))){
var state_19729__$1 = state_19729;
var statearr_19732_19757 = state_19729__$1;
(statearr_19732_19757[(2)] = null);

(statearr_19732_19757[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19730 === (4))){
var inst_19700 = (state_19729[(7)]);
var inst_19700__$1 = (state_19729[(2)]);
var inst_19701 = (inst_19700__$1 == null);
var state_19729__$1 = (function (){var statearr_19733 = state_19729;
(statearr_19733[(7)] = inst_19700__$1);

return statearr_19733;
})();
if(cljs.core.truth_(inst_19701)){
var statearr_19734_19758 = state_19729__$1;
(statearr_19734_19758[(1)] = (5));

} else {
var statearr_19735_19759 = state_19729__$1;
(statearr_19735_19759[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19730 === (6))){
var inst_19700 = (state_19729[(7)]);
var inst_19708 = cljs.core.nth.call(null,inst_19700,(0),null);
var inst_19709 = cljs.core.nth.call(null,inst_19700,(1),null);
var state_19729__$1 = (function (){var statearr_19736 = state_19729;
(statearr_19736[(8)] = inst_19709);

(statearr_19736[(9)] = inst_19708);

return statearr_19736;
})();
var statearr_19737_19760 = state_19729__$1;
(statearr_19737_19760[(2)] = null);

(statearr_19737_19760[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19730 === (3))){
var inst_19727 = (state_19729[(2)]);
var state_19729__$1 = state_19729;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19729__$1,inst_19727);
} else {
if((state_val_19730 === (2))){
var state_19729__$1 = state_19729;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19729__$1,(4),pub_chan);
} else {
if((state_val_19730 === (11))){
var _ = (function (){var statearr_19739 = state_19729;
(statearr_19739[(4)] = cljs.core.rest.call(null,(state_19729[(4)])));

return statearr_19739;
})();
var state_19729__$1 = state_19729;
var ex19738 = (state_19729__$1[(2)]);
var statearr_19740_19761 = state_19729__$1;
(statearr_19740_19761[(5)] = ex19738);


var statearr_19741_19762 = state_19729__$1;
(statearr_19741_19762[(1)] = (10));

(statearr_19741_19762[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19730 === (9))){
var inst_19722 = (state_19729[(2)]);
var state_19729__$1 = (function (){var statearr_19742 = state_19729;
(statearr_19742[(10)] = inst_19722);

return statearr_19742;
})();
var statearr_19743_19763 = state_19729__$1;
(statearr_19743_19763[(2)] = null);

(statearr_19743_19763[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19730 === (5))){
var inst_19703 = fluree.db.util.log.info.call(null,"Web socket pub/producer channel closed.");
var state_19729__$1 = state_19729;
var statearr_19744_19764 = state_19729__$1;
(statearr_19744_19764[(2)] = inst_19703);

(statearr_19744_19764[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19730 === (10))){
var inst_19709 = (state_19729[(8)]);
var inst_19708 = (state_19729[(9)]);
var inst_19710 = (state_19729[(2)]);
var inst_19711 = fluree.db.util.log.error.call(null,inst_19710,"Error sending websocket message:",inst_19708);
var inst_19712 = cljs.core.async.put_BANG_.call(null,inst_19709,false);
var state_19729__$1 = (function (){var statearr_19745 = state_19729;
(statearr_19745[(11)] = inst_19711);

return statearr_19745;
})();
var statearr_19746_19765 = state_19729__$1;
(statearr_19746_19765[(2)] = inst_19712);

(statearr_19746_19765[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19730 === (8))){
var inst_19709 = (state_19729[(8)]);
var inst_19708 = (state_19729[(9)]);
var _ = (function (){var statearr_19747 = state_19729;
(statearr_19747[(4)] = cljs.core.cons.call(null,(11),(state_19729[(4)])));

return statearr_19747;
})();
var inst_19718 = ws.send(inst_19708);
var inst_19719 = cljs.core.async.put_BANG_.call(null,inst_19709,true);
var ___$1 = (function (){var statearr_19748 = state_19729;
(statearr_19748[(4)] = cljs.core.rest.call(null,(state_19729[(4)])));

return statearr_19748;
})();
var state_19729__$1 = (function (){var statearr_19749 = state_19729;
(statearr_19749[(12)] = inst_19718);

return statearr_19749;
})();
var statearr_19750_19766 = state_19729__$1;
(statearr_19750_19766[(2)] = inst_19719);

(statearr_19750_19766[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2746__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2746__auto____0 = (function (){
var statearr_19751 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19751[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2746__auto__);

(statearr_19751[(1)] = (1));

return statearr_19751;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2746__auto____1 = (function (state_19729){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19729);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e19752){var ex__2749__auto__ = e19752;
var statearr_19753_19767 = state_19729;
(statearr_19753_19767[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19729[(4)]))){
var statearr_19754_19768 = state_19729;
(statearr_19754_19768[(1)] = cljs.core.first.call(null,(state_19729[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19769 = state_19729;
state_19729 = G__19769;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2746__auto__ = function(state_19729){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2746__auto____1.call(this,state_19729);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2746__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2746__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_19755 = f__2769__auto__.call(null);
(statearr_19755[(6)] = c__2768__auto__);

return statearr_19755;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (((cljs.core._STAR_target_STAR_ === "nodejs"))?(new fluree.db.util.xhttp.node$module$ws(url)):(new WebSocket(url)));
var open_QMARK_ = cljs.core.async.promise_chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.call(null,open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.call(null,sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.call(null,"Websocket closed: ",e.reason,"Code: ",e.code);

return close_fn.call(null);
}));

var c__2768__auto___19807 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19794){
var state_val_19795 = (state_19794[(1)]);
if((state_val_19795 === (1))){
var inst_19773 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19774 = [open_QMARK_,timeout_chan];
var inst_19775 = (new cljs.core.PersistentVector(null,2,(5),inst_19773,inst_19774,null));
var state_19794__$1 = state_19794;
return cljs.core.async.ioc_alts_BANG_.call(null,state_19794__$1,(2),inst_19775,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_19795 === (2))){
var inst_19777 = (state_19794[(2)]);
var inst_19778 = cljs.core.nth.call(null,inst_19777,(0),null);
var inst_19779 = cljs.core.nth.call(null,inst_19777,(1),null);
var inst_19780 = cljs.core._EQ_.call(null,inst_19779,timeout_chan);
var state_19794__$1 = (function (){var statearr_19796 = state_19794;
(statearr_19796[(7)] = inst_19778);

return statearr_19796;
})();
if(inst_19780){
var statearr_19797_19808 = state_19794__$1;
(statearr_19797_19808[(1)] = (3));

} else {
var statearr_19798_19809 = state_19794__$1;
(statearr_19798_19809[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19795 === (3))){
var inst_19782 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_19783 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19784 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_19785 = cljs.core.PersistentHashMap.fromArrays(inst_19783,inst_19784);
var inst_19786 = cljs.core.ex_info.call(null,inst_19782,inst_19785);
var inst_19787 = cljs.core.async.put_BANG_.call(null,resp_chan,inst_19786);
var inst_19788 = fluree.db.util.xhttp.close_websocket.call(null,ws);
var state_19794__$1 = (function (){var statearr_19799 = state_19794;
(statearr_19799[(8)] = inst_19787);

return statearr_19799;
})();
var statearr_19800_19810 = state_19794__$1;
(statearr_19800_19810[(2)] = inst_19788);

(statearr_19800_19810[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19795 === (4))){
var inst_19790 = fluree.db.util.xhttp.socket_publish_loop.call(null,ws,pub_chan);
var state_19794__$1 = state_19794;
var statearr_19801_19811 = state_19794__$1;
(statearr_19801_19811[(2)] = inst_19790);

(statearr_19801_19811[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19795 === (5))){
var inst_19792 = (state_19794[(2)]);
var state_19794__$1 = state_19794;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19794__$1,inst_19792);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__2746__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__2746__auto____0 = (function (){
var statearr_19802 = [null,null,null,null,null,null,null,null,null];
(statearr_19802[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__2746__auto__);

(statearr_19802[(1)] = (1));

return statearr_19802;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__2746__auto____1 = (function (state_19794){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19794);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e19803){var ex__2749__auto__ = e19803;
var statearr_19804_19812 = state_19794;
(statearr_19804_19812[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19794[(4)]))){
var statearr_19805_19813 = state_19794;
(statearr_19805_19813[(1)] = cljs.core.first.call(null,(state_19794[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19814 = state_19794;
state_19794 = G__19814;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__2746__auto__ = function(state_19794){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__2746__auto____1.call(this,state_19794);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__2746__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__2746__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_19806 = f__2769__auto__.call(null);
(statearr_19806[(6)] = c__2768__auto___19807);

return statearr_19806;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
