// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('sci.impl.evaluator');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('sci.impl.interop');
goog.require('sci.impl.macros');
goog.require('sci.impl.records');
goog.require('sci.impl.types');
goog.require('sci.impl.utils');
goog.require('sci.impl.vars');
sci.impl.evaluator.macros = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Symbol(null,"fn","fn",465265323,null),"null",new cljs.core.Symbol(null,"do","do",1686842252,null),"null",new cljs.core.Symbol(null,"defn","defn",-126010802,null),"null",new cljs.core.Symbol(null,"syntax-quote","syntax-quote",407366680,null),"null",new cljs.core.Symbol(null,"def","def",597100991,null),"null"], null), null);
/**
 * The and macro from clojure.core. Note: and is unrolled in the analyzer, this is a fallback.
 */
sci.impl.evaluator.eval_and = (function sci$impl$evaluator$eval_and(ctx,bindings,args){
var args__$1 = cljs.core.seq.call(null,args);
while(true){
if(args__$1){
var x = cljs.core.first.call(null,args__$1);
var v = sci.impl.types.eval.call(null,x,ctx,bindings);
if(cljs.core.truth_(v)){
var xs = cljs.core.next.call(null,args__$1);
if(xs){
var G__31488 = xs;
args__$1 = G__31488;
continue;
} else {
return v;
}
} else {
return v;
}
} else {
return true;
}
break;
}
});
/**
 * The or macro from clojure.core. Note: or is unrolled in the analyzer, this is a fallback.
 */
sci.impl.evaluator.eval_or = (function sci$impl$evaluator$eval_or(ctx,bindings,args){
var args__$1 = cljs.core.seq.call(null,args);
while(true){
if(args__$1){
var x = cljs.core.first.call(null,args__$1);
var v = sci.impl.types.eval.call(null,x,ctx,bindings);
var or__5045__auto__ = v;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var G__31489 = cljs.core.next.call(null,args__$1);
args__$1 = G__31489;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * The let macro from clojure.core
 */
sci.impl.evaluator.eval_let = (function sci$impl$evaluator$eval_let(ctx,bindings,let_bindings,exprs,idxs){
var vec__31490 = (function (){var ctx__$1 = ctx;
var bindings__$1 = bindings;
var let_bindings__$1 = let_bindings;
var idx = (0);
while(true){
var let_name = cljs.core.first.call(null,let_bindings__$1);
if(cljs.core.truth_(let_name)){
var let_bindings__$2 = cljs.core.rest.call(null,let_bindings__$1);
var let_val = cljs.core.first.call(null,let_bindings__$2);
var rest_let_bindings = cljs.core.next.call(null,let_bindings__$2);
var v = sci.impl.types.eval.call(null,let_val,ctx__$1,bindings__$1);
(bindings__$1[cljs.core.nth.call(null,idxs,idx)] = v);

var G__31493 = ctx__$1;
var G__31494 = bindings__$1;
var G__31495 = rest_let_bindings;
var G__31496 = (idx + (1));
ctx__$1 = G__31493;
bindings__$1 = G__31494;
let_bindings__$1 = G__31495;
idx = G__31496;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ctx__$1,bindings__$1], null);
}
break;
}
})();
var ctx__$1 = cljs.core.nth.call(null,vec__31490,(0),null);
var bindings__$1 = cljs.core.nth.call(null,vec__31490,(1),null);
return sci.impl.types.eval.call(null,exprs,ctx__$1,bindings__$1);
});
sci.impl.evaluator.eval_def = (function sci$impl$evaluator$eval_def(ctx,bindings,var_name,init,m){
var init__$1 = sci.impl.types.eval.call(null,init,ctx,bindings);
var m__$1 = sci.impl.types.eval.call(null,m,ctx,bindings);
var cnn = sci.impl.types.getName.call(null,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(m__$1));
var assoc_in_env = (function (env){
var the_current_ns = cljs.core.get.call(null,cljs.core.get.call(null,env,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469)),cnn);
var prev = cljs.core.get.call(null,the_current_ns,var_name);
var prev__$1 = (((!(sci.impl.utils.var_QMARK_.call(null,prev))))?(new sci.lang.Var(prev,cljs.core.symbol.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cnn),cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_name)),cljs.core.meta.call(null,prev),false)):prev);
var v = (((sci.impl.utils.var_unbound === init__$1))?(function (){var G__31497 = prev__$1;
cljs.core.alter_meta_BANG_.call(null,G__31497,cljs.core.merge,m__$1);

return G__31497;
})():(function (){
sci.impl.vars.bindRoot.call(null,prev__$1,init__$1);

cljs.core.alter_meta_BANG_.call(null,prev__$1,cljs.core.merge,m__$1);

return prev__$1;
})()
);
var the_current_ns__$1 = cljs.core.assoc.call(null,the_current_ns,var_name,v);
return cljs.core.assoc_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn], null),the_current_ns__$1);
});
var env = cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx),assoc_in_env);
return cljs.core.get.call(null,cljs.core.get.call(null,cljs.core.get.call(null,env,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469)),cnn),var_name);
});
var ret__5824__auto___31498 = sci.impl.evaluator.resolve_symbol = (function sci$impl$evaluator$resolve_symbol(_AMPERSAND_form,_AMPERSAND_env,bindings,sym){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,".get",".get",1446963300,null),null,(1),null)),(new cljs.core.List(null,cljs.core.with_meta.call(null,bindings,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"java.util.Map","java.util.Map",981564201,null)], null)),null,(1),null)),(new cljs.core.List(null,sym,null,(1),null)))));
});
(sci.impl.evaluator.resolve_symbol.cljs$lang$macro = true);

sci.impl.evaluator.eval_case = (function sci$impl$evaluator$eval_case(var_args){
var G__31500 = arguments.length;
switch (G__31500) {
case 4:
return sci.impl.evaluator.eval_case.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return sci.impl.evaluator.eval_case.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sci.impl.evaluator.eval_case.cljs$core$IFn$_invoke$arity$4 = (function (ctx,bindings,case_map,case_val){
var v = sci.impl.types.eval.call(null,case_val,ctx,bindings);
var temp__5802__auto__ = cljs.core.find.call(null,case_map,v);
if(cljs.core.truth_(temp__5802__auto__)){
var vec__31501 = temp__5802__auto__;
var _ = cljs.core.nth.call(null,vec__31501,(0),null);
var found = cljs.core.nth.call(null,vec__31501,(1),null);
return sci.impl.types.eval.call(null,found,ctx,bindings);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)].join('')));
}
}));

(sci.impl.evaluator.eval_case.cljs$core$IFn$_invoke$arity$5 = (function (ctx,bindings,case_map,case_val,case_default){
var v = sci.impl.types.eval.call(null,case_val,ctx,bindings);
var temp__5802__auto__ = cljs.core.find.call(null,case_map,v);
if(cljs.core.truth_(temp__5802__auto__)){
var vec__31504 = temp__5802__auto__;
var _ = cljs.core.nth.call(null,vec__31504,(0),null);
var found = cljs.core.nth.call(null,vec__31504,(1),null);
return sci.impl.types.eval.call(null,found,ctx,bindings);
} else {
return sci.impl.types.eval.call(null,case_default,ctx,bindings);
}
}));

(sci.impl.evaluator.eval_case.cljs$lang$maxFixedArity = 5);

sci.impl.evaluator.eval_try = (function sci$impl$evaluator$eval_try(ctx,bindings,body,catches,finally$){
try{var _STAR_in_try_STAR__orig_val__31512 = sci.impl.utils._STAR_in_try_STAR_;
var _STAR_in_try_STAR__temp_val__31513 = true;
(sci.impl.utils._STAR_in_try_STAR_ = _STAR_in_try_STAR__temp_val__31513);

try{return sci.impl.types.eval.call(null,body,ctx,bindings);
}finally {(sci.impl.utils._STAR_in_try_STAR_ = _STAR_in_try_STAR__orig_val__31512);
}}catch (e31508){var e = e31508;
var temp__5802__auto__ = cljs.core.reduce.call(null,(function (_,c){
var clazz = new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(c);
if(cljs.core.truth_((function (){var or__5045__auto__ = cljs.core.keyword_identical_QMARK_.call(null,new cljs.core.Keyword(null,"default","default",-1987822328),clazz);
if(or__5045__auto__){
return or__5045__auto__;
} else {
if((clazz instanceof sci.impl.types.NodeR)){
var c__5078__auto__ = sci.impl.types.eval.call(null,clazz,ctx,bindings);
var x__5079__auto__ = e;
return (x__5079__auto__ instanceof c__5078__auto__);
} else {
return (e instanceof clazz);
}
}
})())){
return cljs.core.reduced.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("sci.impl.evaluator","try-result","sci.impl.evaluator/try-result",-1394897780),(function (){
(bindings[new cljs.core.Keyword(null,"ex-idx","ex-idx",795118805).cljs$core$IFn$_invoke$arity$1(c)] = e);

return sci.impl.types.eval.call(null,new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(c),ctx,bindings);
})()
], null));
} else {
return null;
}
}),null,catches);
if(cljs.core.truth_(temp__5802__auto__)){
var vec__31509 = temp__5802__auto__;
var _ = cljs.core.nth.call(null,vec__31509,(0),null);
var r = cljs.core.nth.call(null,vec__31509,(1),null);
return r;
} else {
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e,body);
}
}finally {sci.impl.types.eval.call(null,finally$,ctx,bindings);
}});
sci.impl.evaluator.eval_static_method_invocation = (function sci$impl$evaluator$eval_static_method_invocation(ctx,bindings,expr){
return sci.impl.interop.invoke_static_method.call(null,cljs.core.first.call(null,expr),cljs.core.map.call(null,(function (p1__31514_SHARP_){
return sci.impl.types.eval.call(null,p1__31514_SHARP_,ctx,bindings);
}),cljs.core.rest.call(null,expr)));
});
sci.impl.evaluator.eval_instance_method_invocation = (function sci$impl$evaluator$eval_instance_method_invocation(ctx,bindings,instance_expr,method_str,field_access,args,allowed){
var instance_meta = cljs.core.meta.call(null,instance_expr);
var tag_class = new cljs.core.Keyword(null,"tag-class","tag-class",714967874).cljs$core$IFn$_invoke$arity$1(instance_meta);
var instance_expr_STAR_ = sci.impl.types.eval.call(null,instance_expr,ctx,bindings);
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core.map_QMARK_.call(null,instance_expr_STAR_);
if(and__5043__auto__){
return new cljs.core.Keyword("sci.impl","record","sci.impl/record",-1939193950).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,instance_expr_STAR_));
} else {
return and__5043__auto__;
}
})())){
return cljs.core.get.call(null,instance_expr_STAR_,cljs.core.keyword.call(null,method_str));
} else {
var instance_class = (function (){var or__5045__auto__ = tag_class;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.type.call(null,instance_expr_STAR_);
}
})();
var env = cljs.core.deref.call(null,new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx));
var class__GT_opts = new cljs.core.Keyword(null,"class->opts","class->opts",2061906477).cljs$core$IFn$_invoke$arity$1(env);
var allowed_QMARK_ = (function (){var or__5045__auto__ = allowed;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = cljs.core.get.call(null,class__GT_opts,new cljs.core.Keyword(null,"allow","allow",-1857325745));
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
var or__5045__auto____$2 = (function (){var instance_class_name = instance_class.name;
var instance_class_symbol = cljs.core.symbol.call(null,instance_class_name);
return cljs.core.get.call(null,class__GT_opts,instance_class_symbol);
})();
if(cljs.core.truth_(or__5045__auto____$2)){
return or__5045__auto____$2;
} else {
return console.log(cljs.core.str.cljs$core$IFn$_invoke$arity$1(method_str));
}
}
}
})();
var target_class = (cljs.core.truth_(allowed_QMARK_)?instance_class:(function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"public-class","public-class",1127293019).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_(temp__5804__auto__)){
var f = temp__5804__auto__;
return f.call(null,instance_expr_STAR_);
} else {
return null;
}
})());
if(cljs.core.truth_(allowed_QMARK_)){
} else {
sci.impl.utils.throw_error_with_location.call(null,["Method ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(method_str)," on ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(instance_class)," not allowed!"].join(''),instance_expr);
}

if(cljs.core.truth_(field_access)){
return sci.impl.interop.invoke_instance_field.call(null,instance_expr_STAR_,target_class,method_str);
} else {
var args__$1 = cljs.core.map.call(null,(function (p1__31516_SHARP_){
return sci.impl.types.eval.call(null,p1__31516_SHARP_,ctx,bindings);
}),args);
return sci.impl.interop.invoke_instance_method.call(null,instance_expr_STAR_,target_class,method_str,args__$1);
}
}
});
sci.impl.evaluator.eval_resolve = (function sci$impl$evaluator$eval_resolve(var_args){
var G__31518 = arguments.length;
switch (G__31518) {
case 3:
return sci.impl.evaluator.eval_resolve.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return sci.impl.evaluator.eval_resolve.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sci.impl.evaluator.eval_resolve.cljs$core$IFn$_invoke$arity$3 = (function (ctx,bindings,sym){
return sci.impl.evaluator.eval_resolve.call(null,ctx,bindings,null,sym);
}));

(sci.impl.evaluator.eval_resolve.cljs$core$IFn$_invoke$arity$4 = (function (ctx,bindings,env,sym){
if(((cljs.core.not.call(null,env)) || ((!(cljs.core.contains_QMARK_.call(null,env,sym)))))){
var sym__$1 = sci.impl.types.eval.call(null,sym,ctx,bindings);
var res = cljs.core.second.call(null,cljs.core.deref.call(null,sci.impl.utils.lookup).call(null,ctx,sym__$1,false));
if((res instanceof sci.impl.types.NodeR)){
return null;
} else {
return res;
}
} else {
return null;
}
}));

(sci.impl.evaluator.eval_resolve.cljs$lang$maxFixedArity = 4);

cljs.core.vreset_BANG_.call(null,sci.impl.utils.eval_resolve_state,sci.impl.evaluator.eval_resolve);
sci.impl.evaluator.eval_import = (function sci$impl$evaluator$eval_import(var_args){
var args__5775__auto__ = [];
var len__5769__auto___31526 = arguments.length;
var i__5770__auto___31527 = (0);
while(true){
if((i__5770__auto___31527 < len__5769__auto___31526)){
args__5775__auto__.push((arguments[i__5770__auto___31527]));

var G__31528 = (i__5770__auto___31527 + (1));
i__5770__auto___31527 = G__31528;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return sci.impl.evaluator.eval_import.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(sci.impl.evaluator.eval_import.cljs$core$IFn$_invoke$arity$variadic = (function (ctx,import_symbols_or_lists){
var specs = cljs.core.map.call(null,(function (p1__31520_SHARP_){
if(((cljs.core.seq_QMARK_.call(null,p1__31520_SHARP_)) && (cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.first.call(null,p1__31520_SHARP_))))){
return cljs.core.second.call(null,p1__31520_SHARP_);
} else {
return p1__31520_SHARP_;
}
}),import_symbols_or_lists);
var env = new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx);
return cljs.core.reduce.call(null,(function (_,spec){
var vec__31523 = (((spec instanceof cljs.core.Symbol))?(function (){var s = cljs.core.str.cljs$core$IFn$_invoke$arity$1(spec);
var last_dot = clojure.string.last_index_of.call(null,s,".");
var package_PLUS_class_name = (cljs.core.truth_(last_dot)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,cljs.core.subs.call(null,s,(0),last_dot)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,cljs.core.subs.call(null,s,(last_dot + (1)),((s).length)))], null)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec], null)], null));
return package_PLUS_class_name;
})():(function (){var p = cljs.core.first.call(null,spec);
var cs = cljs.core.rest.call(null,spec);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cs], null);
})());
var package$ = cljs.core.nth.call(null,vec__31523,(0),null);
var classes = cljs.core.nth.call(null,vec__31523,(1),null);
return cljs.core.reduce.call(null,(function (___$1,class$){
var fq_class_name = cljs.core.symbol.call(null,(cljs.core.truth_(package$)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(package$),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)].join(''):class$));
var temp__5802__auto__ = sci.impl.interop.resolve_class.call(null,ctx,fq_class_name);
if(cljs.core.truth_(temp__5802__auto__)){
var clazz = temp__5802__auto__;
var cnn = sci.impl.utils.current_ns_name.call(null);
cljs.core.swap_BANG_.call(null,env,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn,new cljs.core.Keyword(null,"imports","imports",-1249933394),class$], null),fq_class_name);

return clazz;
} else {
var temp__5802__auto____$1 = (function (){var rec_ns = cljs.core.symbol.call(null,sci.impl.utils.demunge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(package$)));
var rec_var = cljs.core.get_in.call(null,cljs.core.deref.call(null,env),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),rec_ns,class$], null));
return rec_var;
})();
if(cljs.core.truth_(temp__5802__auto____$1)){
var rec_var = temp__5802__auto____$1;
var cnn = sci.impl.utils.current_ns_name.call(null);
cljs.core.swap_BANG_.call(null,env,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn,new cljs.core.Keyword(null,"refers","refers",158076809),class$], null),rec_var);

return cljs.core.deref.call(null,rec_var);
} else {
throw (new Error(["Unable to resolve classname: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fq_class_name)].join('')));
}
}
}),null,classes);
}),null,specs);
}));

(sci.impl.evaluator.eval_import.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sci.impl.evaluator.eval_import.cljs$lang$applyTo = (function (seq31521){
var G__31522 = cljs.core.first.call(null,seq31521);
var seq31521__$1 = cljs.core.next.call(null,seq31521);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__31522,seq31521__$1);
}));

/**
 * Note: various arities of do have already been unrolled in the analyzer.
 */
sci.impl.evaluator.eval_do = (function sci$impl$evaluator$eval_do(ctx,bindings,exprs){
var exprs__$1 = cljs.core.seq.call(null,exprs);
var exprs__$2 = exprs__$1;
while(true){
if(exprs__$2){
var ret = sci.impl.types.eval.call(null,cljs.core.first.call(null,exprs__$2),ctx,bindings);
var temp__5802__auto__ = cljs.core.next.call(null,exprs__$2);
if(temp__5802__auto__){
var exprs__$3 = temp__5802__auto__;
var G__31529 = exprs__$3;
exprs__$2 = G__31529;
continue;
} else {
return ret;
}
} else {
return null;
}
break;
}
});
cljs.core.vreset_BANG_.call(null,sci.impl.utils.eval_do_STAR_,sci.impl.evaluator.eval_do);
sci.impl.evaluator.fn_call = (function sci$impl$evaluator$fn_call(ctx,bindings,f,args){
var G__31724 = cljs.core.count.call(null,args);
switch (G__31724) {
case (0):
return f.call(null);

break;
case (1):
var arg31534 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
return f.call(null,arg31534);

break;
case (2):
var arg31535 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg31536 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
return f.call(null,arg31535,arg31536);

break;
case (3):
var arg31537 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg31538 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg31539 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
return f.call(null,arg31537,arg31538,arg31539);

break;
case (4):
var arg31540 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg31541 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg31542 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg31543 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
return f.call(null,arg31540,arg31541,arg31542,arg31543);

break;
case (5):
var arg31544 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg31545 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg31546 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg31547 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg31548 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
return f.call(null,arg31544,arg31545,arg31546,arg31547,arg31548);

break;
case (6):
var arg31549 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg31550 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg31551 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg31552 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg31553 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg31554 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
return f.call(null,arg31549,arg31550,arg31551,arg31552,arg31553,arg31554);

break;
case (7):
var arg31555 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg31556 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg31557 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg31558 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg31559 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg31560 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg31561 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
return f.call(null,arg31555,arg31556,arg31557,arg31558,arg31559,arg31560,arg31561);

break;
case (8):
var arg31562 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg31563 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg31564 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg31565 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg31566 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg31567 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg31568 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg31569 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
return f.call(null,arg31562,arg31563,arg31564,arg31565,arg31566,arg31567,arg31568,arg31569);

break;
case (9):
var arg31570 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg31571 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg31572 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg31573 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg31574 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg31575 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg31576 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg31577 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg31578 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
return f.call(null,arg31570,arg31571,arg31572,arg31573,arg31574,arg31575,arg31576,arg31577,arg31578);

break;
case (10):
var arg31579 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg31580 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg31581 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg31582 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg31583 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg31584 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg31585 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg31586 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg31587 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg31588 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
return f.call(null,arg31579,arg31580,arg31581,arg31582,arg31583,arg31584,arg31585,arg31586,arg31587,arg31588);

break;
case (11):
var arg31589 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg31590 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg31591 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg31592 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg31593 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg31594 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg31595 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg31596 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg31597 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg31598 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg31599 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
return f.call(null,arg31589,arg31590,arg31591,arg31592,arg31593,arg31594,arg31595,arg31596,arg31597,arg31598,arg31599);

break;
case (12):
var arg31600 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg31601 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg31602 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg31603 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg31604 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg31605 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg31606 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg31607 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg31608 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg31609 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg31610 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg31611 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
return f.call(null,arg31600,arg31601,arg31602,arg31603,arg31604,arg31605,arg31606,arg31607,arg31608,arg31609,arg31610,arg31611);

break;
case (13):
var arg31612 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg31613 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg31614 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg31615 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg31616 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg31617 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg31618 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg31619 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg31620 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg31621 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg31622 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg31623 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
var arg31624 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$12),ctx,bindings);
var args__$13 = cljs.core.rest.call(null,args__$12);
return f.call(null,arg31612,arg31613,arg31614,arg31615,arg31616,arg31617,arg31618,arg31619,arg31620,arg31621,arg31622,arg31623,arg31624);

break;
case (14):
var arg31625 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg31626 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg31627 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg31628 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg31629 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg31630 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg31631 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg31632 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg31633 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg31634 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg31635 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg31636 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
var arg31637 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$12),ctx,bindings);
var args__$13 = cljs.core.rest.call(null,args__$12);
var arg31638 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$13),ctx,bindings);
var args__$14 = cljs.core.rest.call(null,args__$13);
return f.call(null,arg31625,arg31626,arg31627,arg31628,arg31629,arg31630,arg31631,arg31632,arg31633,arg31634,arg31635,arg31636,arg31637,arg31638);

break;
case (15):
var arg31639 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg31640 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg31641 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg31642 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg31643 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg31644 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg31645 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg31646 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg31647 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg31648 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg31649 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg31650 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
var arg31651 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$12),ctx,bindings);
var args__$13 = cljs.core.rest.call(null,args__$12);
var arg31652 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$13),ctx,bindings);
var args__$14 = cljs.core.rest.call(null,args__$13);
var arg31653 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$14),ctx,bindings);
var args__$15 = cljs.core.rest.call(null,args__$14);
return f.call(null,arg31639,arg31640,arg31641,arg31642,arg31643,arg31644,arg31645,arg31646,arg31647,arg31648,arg31649,arg31650,arg31651,arg31652,arg31653);

break;
case (16):
var arg31654 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg31655 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg31656 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg31657 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg31658 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg31659 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg31660 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg31661 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg31662 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg31663 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg31664 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg31665 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
var arg31666 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$12),ctx,bindings);
var args__$13 = cljs.core.rest.call(null,args__$12);
var arg31667 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$13),ctx,bindings);
var args__$14 = cljs.core.rest.call(null,args__$13);
var arg31668 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$14),ctx,bindings);
var args__$15 = cljs.core.rest.call(null,args__$14);
var arg31669 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$15),ctx,bindings);
var args__$16 = cljs.core.rest.call(null,args__$15);
return f.call(null,arg31654,arg31655,arg31656,arg31657,arg31658,arg31659,arg31660,arg31661,arg31662,arg31663,arg31664,arg31665,arg31666,arg31667,arg31668,arg31669);

break;
case (17):
var arg31670 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg31671 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg31672 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg31673 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg31674 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg31675 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg31676 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg31677 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg31678 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg31679 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg31680 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg31681 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
var arg31682 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$12),ctx,bindings);
var args__$13 = cljs.core.rest.call(null,args__$12);
var arg31683 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$13),ctx,bindings);
var args__$14 = cljs.core.rest.call(null,args__$13);
var arg31684 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$14),ctx,bindings);
var args__$15 = cljs.core.rest.call(null,args__$14);
var arg31685 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$15),ctx,bindings);
var args__$16 = cljs.core.rest.call(null,args__$15);
var arg31686 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$16),ctx,bindings);
var args__$17 = cljs.core.rest.call(null,args__$16);
return f.call(null,arg31670,arg31671,arg31672,arg31673,arg31674,arg31675,arg31676,arg31677,arg31678,arg31679,arg31680,arg31681,arg31682,arg31683,arg31684,arg31685,arg31686);

break;
case (18):
var arg31687 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg31688 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg31689 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg31690 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg31691 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg31692 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg31693 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg31694 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg31695 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg31696 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg31697 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg31698 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
var arg31699 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$12),ctx,bindings);
var args__$13 = cljs.core.rest.call(null,args__$12);
var arg31700 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$13),ctx,bindings);
var args__$14 = cljs.core.rest.call(null,args__$13);
var arg31701 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$14),ctx,bindings);
var args__$15 = cljs.core.rest.call(null,args__$14);
var arg31702 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$15),ctx,bindings);
var args__$16 = cljs.core.rest.call(null,args__$15);
var arg31703 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$16),ctx,bindings);
var args__$17 = cljs.core.rest.call(null,args__$16);
var arg31704 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$17),ctx,bindings);
var args__$18 = cljs.core.rest.call(null,args__$17);
return f.call(null,arg31687,arg31688,arg31689,arg31690,arg31691,arg31692,arg31693,arg31694,arg31695,arg31696,arg31697,arg31698,arg31699,arg31700,arg31701,arg31702,arg31703,arg31704);

break;
case (19):
var arg31705 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg31706 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg31707 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg31708 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg31709 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg31710 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg31711 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg31712 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg31713 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg31714 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg31715 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg31716 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
var arg31717 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$12),ctx,bindings);
var args__$13 = cljs.core.rest.call(null,args__$12);
var arg31718 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$13),ctx,bindings);
var args__$14 = cljs.core.rest.call(null,args__$13);
var arg31719 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$14),ctx,bindings);
var args__$15 = cljs.core.rest.call(null,args__$14);
var arg31720 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$15),ctx,bindings);
var args__$16 = cljs.core.rest.call(null,args__$15);
var arg31721 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$16),ctx,bindings);
var args__$17 = cljs.core.rest.call(null,args__$16);
var arg31722 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$17),ctx,bindings);
var args__$18 = cljs.core.rest.call(null,args__$17);
var arg31723 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$18),ctx,bindings);
var args__$19 = cljs.core.rest.call(null,args__$18);
return f.call(null,arg31705,arg31706,arg31707,arg31708,arg31709,arg31710,arg31711,arg31712,arg31713,arg31714,arg31715,arg31716,arg31717,arg31718,arg31719,arg31720,arg31721,arg31722,arg31723);

break;
default:
var args__$1 = cljs.core.mapv.call(null,(function (p1__31244_SHARP_){
return sci.impl.types.eval.call(null,p1__31244_SHARP_,ctx,bindings);
}),args);
return cljs.core.apply.call(null,f,args__$1);

}
});
