(ns alphabase.base64url
  "Base 64 optimized namespace"
  (:require [clojure.set :as set]
            #?@(:cljs [[goog.crypt.base64 :as g-base64]]))
  #?(:clj (:import (java.util Base64))))

#?(:clj (set! *warn-on-reflection* true))

(def ^:const base64url-chars "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_.")
(def ^:const base64url-set (set base64url-chars))

(defn encode
  "Converts a byte array into a base64URL string."
  ^String
  [ba]
  #?(:clj (-> (Base64/getUrlEncoder)
              (.encodeToString ba))
     :cljs (g-base64/encodeByteArray ba g-base64/Alphabet.WEBSAFE)))

(defn decode
  "Decodes a base64URL string into a byte array."
  ^bytes
  [b64url-string]
  #?(:clj (-> (Base64/getUrlDecoder)
              (.decode ^String b64url-string))
     :cljs (g-base64/decodeStringToByteArray b64url-string)))

(defn base64url?
  [x]
  (and (string? x) (set/subset? (set x) base64url-set)))
