// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__5824__auto___54384 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_54435){
var state_val_54436 = (state_54435[(1)]);
if((state_val_54436 === (7))){
var inst_54430 = (state_54435[(2)]);
var _ = (function (){var statearr_54437 = state_54435;
(statearr_54437[(4)] = cljs.core.rest((state_54435[(4)])));

return statearr_54437;
})();
var state_54435__$1 = state_54435;
var statearr_54438_54465 = state_54435__$1;
(statearr_54438_54465[(2)] = inst_54430);

(statearr_54438_54465[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54436 === (1))){
var state_54435__$1 = state_54435;
var statearr_54439_54466 = state_54435__$1;
(statearr_54439_54466[(2)] = null);

(statearr_54439_54466[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54436 === (4))){
var inst_54385 = (state_54435[(2)]);
var state_54435__$1 = state_54435;
var statearr_54440_54467 = state_54435__$1;
(statearr_54440_54467[(2)] = inst_54385);

(statearr_54440_54467[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54436 === (13))){
var inst_54426 = (state_54435[(2)]);
var state_54435__$1 = state_54435;
var statearr_54441_54468 = state_54435__$1;
(statearr_54441_54468[(2)] = inst_54426);

(statearr_54441_54468[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54436 === (6))){
var inst_54403 = (state_54435[(7)]);
var inst_54410 = (state_54435[(8)]);
var inst_54409 = cljs.core.seq(inst_54403);
var inst_54410__$1 = cljs.core.first(inst_54409);
var inst_54411 = cljs.core.next(inst_54409);
var inst_54412 = cljs.core.not(inst_54410__$1);
var state_54435__$1 = (function (){var statearr_54442 = state_54435;
(statearr_54442[(9)] = inst_54411);

(statearr_54442[(8)] = inst_54410__$1);

return statearr_54442;
})();
if(inst_54412){
var statearr_54443_54469 = state_54435__$1;
(statearr_54443_54469[(1)] = (8));

} else {
var statearr_54444_54470 = state_54435__$1;
(statearr_54444_54470[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54436 === (3))){
var inst_54433 = (state_54435[(2)]);
var state_54435__$1 = state_54435;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54435__$1,inst_54433);
} else {
if((state_val_54436 === (12))){
var inst_54404 = (state_54435[(10)]);
var inst_54411 = (state_54435[(9)]);
var inst_54410 = (state_54435[(8)]);
var inst_54423 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_54404,inst_54410);
var inst_54403 = inst_54411;
var inst_54404__$1 = inst_54423;
var state_54435__$1 = (function (){var statearr_54445 = state_54435;
(statearr_54445[(10)] = inst_54404__$1);

(statearr_54445[(7)] = inst_54403);

return statearr_54445;
})();
var statearr_54446_54471 = state_54435__$1;
(statearr_54446_54471[(2)] = null);

(statearr_54446_54471[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54436 === (2))){
var _ = (function (){var statearr_54447 = state_54435;
(statearr_54447[(4)] = cljs.core.cons((5),(state_54435[(4)])));

return statearr_54447;
})();
var inst_54398 = args;
var inst_54399 = cljs.core.seq(inst_54398);
var inst_54400 = cljs.core.first(inst_54399);
var inst_54401 = cljs.core.next(inst_54399);
var inst_54402 = cljs.core.PersistentVector.EMPTY;
var inst_54403 = inst_54398;
var inst_54404 = inst_54402;
var state_54435__$1 = (function (){var statearr_54448 = state_54435;
(statearr_54448[(10)] = inst_54404);

(statearr_54448[(7)] = inst_54403);

(statearr_54448[(11)] = inst_54400);

(statearr_54448[(12)] = inst_54401);

return statearr_54448;
})();
var statearr_54449_54472 = state_54435__$1;
(statearr_54449_54472[(2)] = null);

(statearr_54449_54472[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54436 === (11))){
var inst_54410 = (state_54435[(8)]);
var state_54435__$1 = state_54435;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54435__$1,(14),inst_54410);
} else {
if((state_val_54436 === (9))){
var inst_54410 = (state_54435[(8)]);
var inst_54415 = fluree.db.util.async.channel_QMARK_(inst_54410);
var state_54435__$1 = state_54435;
if(inst_54415){
var statearr_54451_54473 = state_54435__$1;
(statearr_54451_54473[(1)] = (11));

} else {
var statearr_54452_54474 = state_54435__$1;
(statearr_54452_54474[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54436 === (5))){
var _ = (function (){var statearr_54453 = state_54435;
(statearr_54453[(4)] = cljs.core.rest((state_54435[(4)])));

return statearr_54453;
})();
var state_54435__$1 = state_54435;
var ex54450 = (state_54435__$1[(2)]);
var statearr_54454_54475 = state_54435__$1;
(statearr_54454_54475[(5)] = ex54450);


if((ex54450 instanceof Error)){
var statearr_54455_54476 = state_54435__$1;
(statearr_54455_54476[(1)] = (4));

(statearr_54455_54476[(5)] = null);

} else {
throw ex54450;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54436 === (14))){
var inst_54404 = (state_54435[(10)]);
var inst_54411 = (state_54435[(9)]);
var inst_54418 = (state_54435[(2)]);
var inst_54419 = fluree.db.util.async.throw_err(inst_54418);
var inst_54420 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_54404,inst_54419);
var inst_54403 = inst_54411;
var inst_54404__$1 = inst_54420;
var state_54435__$1 = (function (){var statearr_54456 = state_54435;
(statearr_54456[(10)] = inst_54404__$1);

(statearr_54456[(7)] = inst_54403);

return statearr_54456;
})();
var statearr_54457_54477 = state_54435__$1;
(statearr_54457_54477[(2)] = null);

(statearr_54457_54477[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54436 === (10))){
var inst_54428 = (state_54435[(2)]);
var state_54435__$1 = state_54435;
var statearr_54458_54478 = state_54435__$1;
(statearr_54458_54478[(2)] = inst_54428);

(statearr_54458_54478[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54436 === (8))){
var inst_54404 = (state_54435[(10)]);
var state_54435__$1 = state_54435;
var statearr_54459_54479 = state_54435__$1;
(statearr_54459_54479[(2)] = inst_54404);

(statearr_54459_54479[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto____0 = (function (){
var statearr_54460 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54460[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto__);

(statearr_54460[(1)] = (1));

return statearr_54460;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto____1 = (function (state_54435){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_54435);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e54461){var ex__2687__auto__ = e54461;
var statearr_54462_54480 = state_54435;
(statearr_54462_54480[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_54435[(4)]))){
var statearr_54463_54481 = state_54435;
(statearr_54463_54481[(1)] = cljs.core.first((state_54435[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54482 = state_54435;
state_54435 = G__54482;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto__ = function(state_54435){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto____1.call(this,state_54435);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_54464 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_54464[(6)] = c__2706__auto__);

return statearr_54464;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__54484 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54484,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54484,(1),null);
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Smart function stack:",res], null));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (p1__54483_SHARP_){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.update.cljs$core$IFn$_invoke$arity$4(p1__54483_SHARP_,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj,entry),new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._,cost),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_,cost);
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_54532){
var state_val_54533 = (state_54532[(1)]);
if((state_val_54533 === (7))){
var state_54532__$1 = state_54532;
var statearr_54534_54563 = state_54532__$1;
(statearr_54534_54563[(2)] = coll);

(statearr_54534_54563[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54533 === (1))){
var state_54532__$1 = state_54532;
var statearr_54535_54564 = state_54532__$1;
(statearr_54535_54564[(2)] = null);

(statearr_54535_54564[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54533 === (4))){
var inst_54487 = (state_54532[(2)]);
var state_54532__$1 = state_54532;
var statearr_54536_54565 = state_54532__$1;
(statearr_54536_54565[(2)] = inst_54487);

(statearr_54536_54565[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54533 === (15))){
var inst_54506 = (state_54532[(7)]);
var inst_54514 = (state_54532[(2)]);
var inst_54515 = fluree.db.dbfunctions.internal.nth(inst_54506,inst_54514);
var inst_54516 = cljs.core.count(inst_54506);
var inst_54517 = ((9) + inst_54516);
var inst_54518 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54519 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54520 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54521 = [inst_54506,inst_54514];
var inst_54522 = (new cljs.core.PersistentVector(null,2,(5),inst_54520,inst_54521,null));
var inst_54523 = ["nth",inst_54522,inst_54515];
var inst_54524 = cljs.core.PersistentHashMap.fromArrays(inst_54519,inst_54523);
var inst_54525 = [inst_54524,inst_54517];
var inst_54526 = (new cljs.core.PersistentVector(null,2,(5),inst_54518,inst_54525,null));
var inst_54527 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54526);
var _ = (function (){var statearr_54537 = state_54532;
(statearr_54537[(4)] = cljs.core.rest((state_54532[(4)])));

return statearr_54537;
})();
var state_54532__$1 = (function (){var statearr_54538 = state_54532;
(statearr_54538[(8)] = inst_54527);

return statearr_54538;
})();
var statearr_54539_54566 = state_54532__$1;
(statearr_54539_54566[(2)] = inst_54515);

(statearr_54539_54566[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54533 === (13))){
var state_54532__$1 = state_54532;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54532__$1,(16),key);
} else {
if((state_val_54533 === (6))){
var state_54532__$1 = state_54532;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54532__$1,(9),coll);
} else {
if((state_val_54533 === (3))){
var inst_54530 = (state_54532[(2)]);
var state_54532__$1 = state_54532;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54532__$1,inst_54530);
} else {
if((state_val_54533 === (12))){
var inst_54506 = (state_54532[(2)]);
var inst_54507 = fluree.db.util.async.channel_QMARK_(key);
var state_54532__$1 = (function (){var statearr_54540 = state_54532;
(statearr_54540[(7)] = inst_54506);

return statearr_54540;
})();
if(inst_54507){
var statearr_54541_54567 = state_54532__$1;
(statearr_54541_54567[(1)] = (13));

} else {
var statearr_54542_54568 = state_54532__$1;
(statearr_54542_54568[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54533 === (2))){
var _ = (function (){var statearr_54543 = state_54532;
(statearr_54543[(4)] = cljs.core.cons((5),(state_54532[(4)])));

return statearr_54543;
})();
var inst_54493 = fluree.db.util.async.channel_QMARK_(coll);
var state_54532__$1 = state_54532;
if(inst_54493){
var statearr_54544_54569 = state_54532__$1;
(statearr_54544_54569[(1)] = (6));

} else {
var statearr_54545_54570 = state_54532__$1;
(statearr_54545_54570[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54533 === (11))){
var inst_54500 = (state_54532[(9)]);
var state_54532__$1 = state_54532;
var statearr_54547_54571 = state_54532__$1;
(statearr_54547_54571[(2)] = inst_54500);

(statearr_54547_54571[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54533 === (9))){
var inst_54496 = (state_54532[(2)]);
var inst_54497 = fluree.db.util.async.throw_err(inst_54496);
var state_54532__$1 = state_54532;
var statearr_54548_54572 = state_54532__$1;
(statearr_54548_54572[(2)] = inst_54497);

(statearr_54548_54572[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54533 === (5))){
var _ = (function (){var statearr_54549 = state_54532;
(statearr_54549[(4)] = cljs.core.rest((state_54532[(4)])));

return statearr_54549;
})();
var state_54532__$1 = state_54532;
var ex54546 = (state_54532__$1[(2)]);
var statearr_54550_54573 = state_54532__$1;
(statearr_54550_54573[(5)] = ex54546);


if((ex54546 instanceof Error)){
var statearr_54551_54574 = state_54532__$1;
(statearr_54551_54574[(1)] = (4));

(statearr_54551_54574[(5)] = null);

} else {
throw ex54546;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54533 === (14))){
var state_54532__$1 = state_54532;
var statearr_54552_54575 = state_54532__$1;
(statearr_54552_54575[(2)] = key);

(statearr_54552_54575[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54533 === (16))){
var inst_54510 = (state_54532[(2)]);
var inst_54511 = fluree.db.util.async.throw_err(inst_54510);
var state_54532__$1 = state_54532;
var statearr_54553_54576 = state_54532__$1;
(statearr_54553_54576[(2)] = inst_54511);

(statearr_54553_54576[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54533 === (10))){
var inst_54500 = (state_54532[(9)]);
var inst_54503 = cljs.core.vec(inst_54500);
var state_54532__$1 = state_54532;
var statearr_54554_54577 = state_54532__$1;
(statearr_54554_54577[(2)] = inst_54503);

(statearr_54554_54577[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54533 === (8))){
var inst_54500 = (state_54532[(9)]);
var inst_54500__$1 = (state_54532[(2)]);
var inst_54501 = cljs.core.set_QMARK_(inst_54500__$1);
var state_54532__$1 = (function (){var statearr_54555 = state_54532;
(statearr_54555[(9)] = inst_54500__$1);

return statearr_54555;
})();
if(inst_54501){
var statearr_54556_54578 = state_54532__$1;
(statearr_54556_54578[(1)] = (10));

} else {
var statearr_54557_54579 = state_54532__$1;
(statearr_54557_54579[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto____0 = (function (){
var statearr_54558 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54558[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto__);

(statearr_54558[(1)] = (1));

return statearr_54558;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto____1 = (function (state_54532){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_54532);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e54559){var ex__2687__auto__ = e54559;
var statearr_54560_54580 = state_54532;
(statearr_54560_54580[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_54532[(4)]))){
var statearr_54561_54581 = state_54532;
(statearr_54561_54581[(1)] = cljs.core.first((state_54532[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54582 = state_54532;
state_54532 = G__54582;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto__ = function(state_54532){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto____1.call(this,state_54532);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_54562 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_54562[(6)] = c__2706__auto__);

return statearr_54562;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_54643){
var state_val_54644 = (state_54643[(1)]);
if((state_val_54644 === (7))){
var state_54643__$1 = state_54643;
var statearr_54645_54679 = state_54643__$1;
(statearr_54645_54679[(2)] = test);

(statearr_54645_54679[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54644 === (20))){
var inst_54617 = (state_54643[(2)]);
var inst_54618 = fluree.db.util.async.throw_err(inst_54617);
var state_54643__$1 = state_54643;
var statearr_54646_54680 = state_54643__$1;
(statearr_54646_54680[(2)] = inst_54618);

(statearr_54646_54680[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54644 === (1))){
var state_54643__$1 = state_54643;
var statearr_54647_54681 = state_54643__$1;
(statearr_54647_54681[(2)] = null);

(statearr_54647_54681[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54644 === (4))){
var inst_54583 = (state_54643[(2)]);
var state_54643__$1 = state_54643;
var statearr_54648_54682 = state_54643__$1;
(statearr_54648_54682[(2)] = inst_54583);

(statearr_54648_54682[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54644 === (15))){
var inst_54601 = (state_54643[(7)]);
var inst_54609 = (state_54643[(2)]);
var inst_54610 = [inst_54609,f];
var inst_54611 = (new cljs.core.PersistentVector(null,2,(5),inst_54601,inst_54610,null));
var state_54643__$1 = state_54643;
var statearr_54649_54683 = state_54643__$1;
(statearr_54649_54683[(2)] = inst_54611);

(statearr_54649_54683[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54644 === (13))){
var state_54643__$1 = state_54643;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54643__$1,(16),t);
} else {
if((state_val_54644 === (6))){
var state_54643__$1 = state_54643;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54643__$1,(9),test);
} else {
if((state_val_54644 === (17))){
var state_54643__$1 = state_54643;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54643__$1,(20),f);
} else {
if((state_val_54644 === (3))){
var inst_54641 = (state_54643[(2)]);
var state_54643__$1 = state_54643;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54643__$1,inst_54641);
} else {
if((state_val_54644 === (12))){
var inst_54599 = (state_54643[(8)]);
var inst_54625 = (state_54643[(2)]);
var inst_54626 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54625,(0),null);
var inst_54627 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54625,(1),null);
var inst_54628 = fluree.db.dbfunctions.internal.if_else(inst_54599,inst_54626,inst_54627);
var inst_54629 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54630 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54631 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54632 = [inst_54599,inst_54626,inst_54627];
var inst_54633 = (new cljs.core.PersistentVector(null,3,(5),inst_54631,inst_54632,null));
var inst_54634 = ["if-else",inst_54633,inst_54628];
var inst_54635 = cljs.core.PersistentHashMap.fromArrays(inst_54630,inst_54634);
var inst_54636 = [inst_54635,(10)];
var inst_54637 = (new cljs.core.PersistentVector(null,2,(5),inst_54629,inst_54636,null));
var inst_54638 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54637);
var _ = (function (){var statearr_54650 = state_54643;
(statearr_54650[(4)] = cljs.core.rest((state_54643[(4)])));

return statearr_54650;
})();
var state_54643__$1 = (function (){var statearr_54651 = state_54643;
(statearr_54651[(9)] = inst_54638);

return statearr_54651;
})();
var statearr_54652_54684 = state_54643__$1;
(statearr_54652_54684[(2)] = inst_54628);

(statearr_54652_54684[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54644 === (2))){
var _ = (function (){var statearr_54653 = state_54643;
(statearr_54653[(4)] = cljs.core.cons((5),(state_54643[(4)])));

return statearr_54653;
})();
var inst_54592 = fluree.db.util.async.channel_QMARK_(test);
var state_54643__$1 = state_54643;
if(inst_54592){
var statearr_54654_54685 = state_54643__$1;
(statearr_54654_54685[(1)] = (6));

} else {
var statearr_54655_54686 = state_54643__$1;
(statearr_54655_54686[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54644 === (19))){
var inst_54613 = (state_54643[(10)]);
var inst_54621 = (state_54643[(2)]);
var inst_54622 = [f,inst_54621];
var inst_54623 = (new cljs.core.PersistentVector(null,2,(5),inst_54613,inst_54622,null));
var state_54643__$1 = state_54643;
var statearr_54656_54687 = state_54643__$1;
(statearr_54656_54687[(2)] = inst_54623);

(statearr_54656_54687[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54644 === (11))){
var inst_54613 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54614 = fluree.db.util.async.channel_QMARK_(f);
var state_54643__$1 = (function (){var statearr_54658 = state_54643;
(statearr_54658[(10)] = inst_54613);

return statearr_54658;
})();
if(inst_54614){
var statearr_54659_54688 = state_54643__$1;
(statearr_54659_54688[(1)] = (17));

} else {
var statearr_54660_54689 = state_54643__$1;
(statearr_54660_54689[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54644 === (9))){
var inst_54595 = (state_54643[(2)]);
var inst_54596 = fluree.db.util.async.throw_err(inst_54595);
var state_54643__$1 = state_54643;
var statearr_54661_54690 = state_54643__$1;
(statearr_54661_54690[(2)] = inst_54596);

(statearr_54661_54690[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54644 === (5))){
var _ = (function (){var statearr_54662 = state_54643;
(statearr_54662[(4)] = cljs.core.rest((state_54643[(4)])));

return statearr_54662;
})();
var state_54643__$1 = state_54643;
var ex54657 = (state_54643__$1[(2)]);
var statearr_54663_54691 = state_54643__$1;
(statearr_54663_54691[(5)] = ex54657);


if((ex54657 instanceof Error)){
var statearr_54664_54692 = state_54643__$1;
(statearr_54664_54692[(1)] = (4));

(statearr_54664_54692[(5)] = null);

} else {
throw ex54657;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54644 === (14))){
var state_54643__$1 = state_54643;
var statearr_54665_54693 = state_54643__$1;
(statearr_54665_54693[(2)] = t);

(statearr_54665_54693[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54644 === (16))){
var inst_54605 = (state_54643[(2)]);
var inst_54606 = fluree.db.util.async.throw_err(inst_54605);
var state_54643__$1 = state_54643;
var statearr_54666_54694 = state_54643__$1;
(statearr_54666_54694[(2)] = inst_54606);

(statearr_54666_54694[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54644 === (10))){
var inst_54601 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54602 = fluree.db.util.async.channel_QMARK_(t);
var state_54643__$1 = (function (){var statearr_54667 = state_54643;
(statearr_54667[(7)] = inst_54601);

return statearr_54667;
})();
if(inst_54602){
var statearr_54668_54695 = state_54643__$1;
(statearr_54668_54695[(1)] = (13));

} else {
var statearr_54669_54696 = state_54643__$1;
(statearr_54669_54696[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54644 === (18))){
var state_54643__$1 = state_54643;
var statearr_54670_54697 = state_54643__$1;
(statearr_54670_54697[(2)] = f);

(statearr_54670_54697[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54644 === (8))){
var inst_54599 = (state_54643[(8)]);
var inst_54599__$1 = (state_54643[(2)]);
var state_54643__$1 = (function (){var statearr_54671 = state_54643;
(statearr_54671[(8)] = inst_54599__$1);

return statearr_54671;
})();
if(cljs.core.truth_(inst_54599__$1)){
var statearr_54672_54698 = state_54643__$1;
(statearr_54672_54698[(1)] = (10));

} else {
var statearr_54673_54699 = state_54643__$1;
(statearr_54673_54699[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto____0 = (function (){
var statearr_54674 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_54674[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto__);

(statearr_54674[(1)] = (1));

return statearr_54674;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto____1 = (function (state_54643){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_54643);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e54675){var ex__2687__auto__ = e54675;
var statearr_54676_54700 = state_54643;
(statearr_54676_54700[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_54643[(4)]))){
var statearr_54677_54701 = state_54643;
(statearr_54677_54701[(1)] = cljs.core.first((state_54643[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54702 = state_54643;
state_54643 = G__54702;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto__ = function(state_54643){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto____1.call(this,state_54643);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_54678 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_54678[(6)] = c__2706__auto__);

return statearr_54678;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_54732){
var state_val_54733 = (state_54732[(1)]);
if((state_val_54733 === (7))){
var state_54732__$1 = state_54732;
var statearr_54734_54753 = state_54732__$1;
(statearr_54734_54753[(2)] = arg);

(statearr_54734_54753[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54733 === (1))){
var state_54732__$1 = state_54732;
var statearr_54735_54754 = state_54732__$1;
(statearr_54735_54754[(2)] = null);

(statearr_54735_54754[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54733 === (4))){
var inst_54703 = (state_54732[(2)]);
var state_54732__$1 = state_54732;
var statearr_54736_54755 = state_54732__$1;
(statearr_54736_54755[(2)] = inst_54703);

(statearr_54736_54755[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54733 === (6))){
var state_54732__$1 = state_54732;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54732__$1,(9),arg);
} else {
if((state_val_54733 === (3))){
var inst_54730 = (state_54732[(2)]);
var state_54732__$1 = state_54732;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54732__$1,inst_54730);
} else {
if((state_val_54733 === (2))){
var _ = (function (){var statearr_54738 = state_54732;
(statearr_54738[(4)] = cljs.core.cons((5),(state_54732[(4)])));

return statearr_54738;
})();
var inst_54709 = fluree.db.util.async.channel_QMARK_(arg);
var state_54732__$1 = state_54732;
if(inst_54709){
var statearr_54739_54756 = state_54732__$1;
(statearr_54739_54756[(1)] = (6));

} else {
var statearr_54740_54757 = state_54732__$1;
(statearr_54740_54757[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54733 === (9))){
var inst_54712 = (state_54732[(2)]);
var inst_54713 = fluree.db.util.async.throw_err(inst_54712);
var state_54732__$1 = state_54732;
var statearr_54741_54758 = state_54732__$1;
(statearr_54741_54758[(2)] = inst_54713);

(statearr_54741_54758[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54733 === (5))){
var _ = (function (){var statearr_54742 = state_54732;
(statearr_54742[(4)] = cljs.core.rest((state_54732[(4)])));

return statearr_54742;
})();
var state_54732__$1 = state_54732;
var ex54737 = (state_54732__$1[(2)]);
var statearr_54743_54759 = state_54732__$1;
(statearr_54743_54759[(5)] = ex54737);


if((ex54737 instanceof Error)){
var statearr_54744_54760 = state_54732__$1;
(statearr_54744_54760[(1)] = (4));

(statearr_54744_54760[(5)] = null);

} else {
throw ex54737;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54733 === (8))){
var inst_54716 = (state_54732[(2)]);
var inst_54717 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_54716);
var inst_54718 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54719 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54720 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54721 = [inst_54716];
var inst_54722 = (new cljs.core.PersistentVector(null,1,(5),inst_54720,inst_54721,null));
var inst_54723 = ["nil?",inst_54722,inst_54717];
var inst_54724 = cljs.core.PersistentHashMap.fromArrays(inst_54719,inst_54723);
var inst_54725 = [inst_54724,(10)];
var inst_54726 = (new cljs.core.PersistentVector(null,2,(5),inst_54718,inst_54725,null));
var inst_54727 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54726);
var _ = (function (){var statearr_54745 = state_54732;
(statearr_54745[(4)] = cljs.core.rest((state_54732[(4)])));

return statearr_54745;
})();
var state_54732__$1 = (function (){var statearr_54746 = state_54732;
(statearr_54746[(7)] = inst_54727);

return statearr_54746;
})();
var statearr_54747_54761 = state_54732__$1;
(statearr_54747_54761[(2)] = inst_54717);

(statearr_54747_54761[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_54748 = [null,null,null,null,null,null,null,null];
(statearr_54748[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto__);

(statearr_54748[(1)] = (1));

return statearr_54748;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto____1 = (function (state_54732){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_54732);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e54749){var ex__2687__auto__ = e54749;
var statearr_54750_54762 = state_54732;
(statearr_54750_54762[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_54732[(4)]))){
var statearr_54751_54763 = state_54732;
(statearr_54751_54763[(1)] = cljs.core.first((state_54732[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54764 = state_54732;
state_54732 = G__54764;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto__ = function(state_54732){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto____1.call(this,state_54732);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_54752 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_54752[(6)] = c__2706__auto__);

return statearr_54752;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_54794){
var state_val_54795 = (state_54794[(1)]);
if((state_val_54795 === (7))){
var state_54794__$1 = state_54794;
var statearr_54796_54815 = state_54794__$1;
(statearr_54796_54815[(2)] = arg);

(statearr_54796_54815[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54795 === (1))){
var state_54794__$1 = state_54794;
var statearr_54797_54816 = state_54794__$1;
(statearr_54797_54816[(2)] = null);

(statearr_54797_54816[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54795 === (4))){
var inst_54765 = (state_54794[(2)]);
var state_54794__$1 = state_54794;
var statearr_54798_54817 = state_54794__$1;
(statearr_54798_54817[(2)] = inst_54765);

(statearr_54798_54817[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54795 === (6))){
var state_54794__$1 = state_54794;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54794__$1,(9),arg);
} else {
if((state_val_54795 === (3))){
var inst_54792 = (state_54794[(2)]);
var state_54794__$1 = state_54794;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54794__$1,inst_54792);
} else {
if((state_val_54795 === (2))){
var _ = (function (){var statearr_54800 = state_54794;
(statearr_54800[(4)] = cljs.core.cons((5),(state_54794[(4)])));

return statearr_54800;
})();
var inst_54771 = fluree.db.util.async.channel_QMARK_(arg);
var state_54794__$1 = state_54794;
if(inst_54771){
var statearr_54801_54818 = state_54794__$1;
(statearr_54801_54818[(1)] = (6));

} else {
var statearr_54802_54819 = state_54794__$1;
(statearr_54802_54819[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54795 === (9))){
var inst_54774 = (state_54794[(2)]);
var inst_54775 = fluree.db.util.async.throw_err(inst_54774);
var state_54794__$1 = state_54794;
var statearr_54803_54820 = state_54794__$1;
(statearr_54803_54820[(2)] = inst_54775);

(statearr_54803_54820[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54795 === (5))){
var _ = (function (){var statearr_54804 = state_54794;
(statearr_54804[(4)] = cljs.core.rest((state_54794[(4)])));

return statearr_54804;
})();
var state_54794__$1 = state_54794;
var ex54799 = (state_54794__$1[(2)]);
var statearr_54805_54821 = state_54794__$1;
(statearr_54805_54821[(5)] = ex54799);


if((ex54799 instanceof Error)){
var statearr_54806_54822 = state_54794__$1;
(statearr_54806_54822[(1)] = (4));

(statearr_54806_54822[(5)] = null);

} else {
throw ex54799;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54795 === (8))){
var inst_54778 = (state_54794[(2)]);
var inst_54779 = fluree.db.dbfunctions.internal.not(inst_54778);
var inst_54780 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54781 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54782 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54783 = [inst_54778];
var inst_54784 = (new cljs.core.PersistentVector(null,1,(5),inst_54782,inst_54783,null));
var inst_54785 = ["not",inst_54784,inst_54779];
var inst_54786 = cljs.core.PersistentHashMap.fromArrays(inst_54781,inst_54785);
var inst_54787 = [inst_54786,(10)];
var inst_54788 = (new cljs.core.PersistentVector(null,2,(5),inst_54780,inst_54787,null));
var inst_54789 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54788);
var _ = (function (){var statearr_54807 = state_54794;
(statearr_54807[(4)] = cljs.core.rest((state_54794[(4)])));

return statearr_54807;
})();
var state_54794__$1 = (function (){var statearr_54808 = state_54794;
(statearr_54808[(7)] = inst_54789);

return statearr_54808;
})();
var statearr_54809_54823 = state_54794__$1;
(statearr_54809_54823[(2)] = inst_54779);

(statearr_54809_54823[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto____0 = (function (){
var statearr_54810 = [null,null,null,null,null,null,null,null];
(statearr_54810[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto__);

(statearr_54810[(1)] = (1));

return statearr_54810;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto____1 = (function (state_54794){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_54794);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e54811){var ex__2687__auto__ = e54811;
var statearr_54812_54824 = state_54794;
(statearr_54812_54824[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_54794[(4)]))){
var statearr_54813_54825 = state_54794;
(statearr_54813_54825[(1)] = cljs.core.first((state_54794[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54826 = state_54794;
state_54794 = G__54826;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto__ = function(state_54794){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto____1.call(this,state_54794);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_54814 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_54814[(6)] = c__2706__auto__);

return statearr_54814;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_54856){
var state_val_54857 = (state_54856[(1)]);
if((state_val_54857 === (7))){
var state_54856__$1 = state_54856;
var statearr_54858_54877 = state_54856__$1;
(statearr_54858_54877[(2)] = arg);

(statearr_54858_54877[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54857 === (1))){
var state_54856__$1 = state_54856;
var statearr_54859_54878 = state_54856__$1;
(statearr_54859_54878[(2)] = null);

(statearr_54859_54878[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54857 === (4))){
var inst_54827 = (state_54856[(2)]);
var state_54856__$1 = state_54856;
var statearr_54860_54879 = state_54856__$1;
(statearr_54860_54879[(2)] = inst_54827);

(statearr_54860_54879[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54857 === (6))){
var state_54856__$1 = state_54856;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54856__$1,(9),arg);
} else {
if((state_val_54857 === (3))){
var inst_54854 = (state_54856[(2)]);
var state_54856__$1 = state_54856;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54856__$1,inst_54854);
} else {
if((state_val_54857 === (2))){
var _ = (function (){var statearr_54862 = state_54856;
(statearr_54862[(4)] = cljs.core.cons((5),(state_54856[(4)])));

return statearr_54862;
})();
var inst_54833 = fluree.db.util.async.channel_QMARK_(arg);
var state_54856__$1 = state_54856;
if(inst_54833){
var statearr_54863_54880 = state_54856__$1;
(statearr_54863_54880[(1)] = (6));

} else {
var statearr_54864_54881 = state_54856__$1;
(statearr_54864_54881[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54857 === (9))){
var inst_54836 = (state_54856[(2)]);
var inst_54837 = fluree.db.util.async.throw_err(inst_54836);
var state_54856__$1 = state_54856;
var statearr_54865_54882 = state_54856__$1;
(statearr_54865_54882[(2)] = inst_54837);

(statearr_54865_54882[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54857 === (5))){
var _ = (function (){var statearr_54866 = state_54856;
(statearr_54866[(4)] = cljs.core.rest((state_54856[(4)])));

return statearr_54866;
})();
var state_54856__$1 = state_54856;
var ex54861 = (state_54856__$1[(2)]);
var statearr_54867_54883 = state_54856__$1;
(statearr_54867_54883[(5)] = ex54861);


if((ex54861 instanceof Error)){
var statearr_54868_54884 = state_54856__$1;
(statearr_54868_54884[(1)] = (4));

(statearr_54868_54884[(5)] = null);

} else {
throw ex54861;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54857 === (8))){
var inst_54840 = (state_54856[(2)]);
var inst_54841 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_54840);
var inst_54842 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54843 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54844 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54845 = [inst_54840];
var inst_54846 = (new cljs.core.PersistentVector(null,1,(5),inst_54844,inst_54845,null));
var inst_54847 = ["empty?",inst_54846,inst_54841];
var inst_54848 = cljs.core.PersistentHashMap.fromArrays(inst_54843,inst_54847);
var inst_54849 = [inst_54848,(10)];
var inst_54850 = (new cljs.core.PersistentVector(null,2,(5),inst_54842,inst_54849,null));
var inst_54851 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54850);
var _ = (function (){var statearr_54869 = state_54856;
(statearr_54869[(4)] = cljs.core.rest((state_54856[(4)])));

return statearr_54869;
})();
var state_54856__$1 = (function (){var statearr_54870 = state_54856;
(statearr_54870[(7)] = inst_54851);

return statearr_54870;
})();
var statearr_54871_54885 = state_54856__$1;
(statearr_54871_54885[(2)] = inst_54841);

(statearr_54871_54885[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_54872 = [null,null,null,null,null,null,null,null];
(statearr_54872[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto__);

(statearr_54872[(1)] = (1));

return statearr_54872;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto____1 = (function (state_54856){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_54856);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e54873){var ex__2687__auto__ = e54873;
var statearr_54874_54886 = state_54856;
(statearr_54874_54886[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_54856[(4)]))){
var statearr_54875_54887 = state_54856;
(statearr_54875_54887[(1)] = cljs.core.first((state_54856[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54888 = state_54856;
state_54856 = G__54888;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto__ = function(state_54856){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto____1.call(this,state_54856);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_54876 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_54876[(6)] = c__2706__auto__);

return statearr_54876;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___54933 = arguments.length;
var i__5770__auto___54934 = (0);
while(true){
if((i__5770__auto___54934 < len__5769__auto___54933)){
args__5775__auto__.push((arguments[i__5770__auto___54934]));

var G__54935 = (i__5770__auto___54934 + (1));
i__5770__auto___54934 = G__54935;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_54916){
var state_val_54917 = (state_54916[(1)]);
if((state_val_54917 === (1))){
var state_54916__$1 = state_54916;
var statearr_54918_54936 = state_54916__$1;
(statearr_54918_54936[(2)] = null);

(statearr_54918_54936[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54917 === (2))){
var _ = (function (){var statearr_54919 = state_54916;
(statearr_54919[(4)] = cljs.core.cons((5),(state_54916[(4)])));

return statearr_54919;
})();
var inst_54897 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54916__$1 = state_54916;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54916__$1,(6),inst_54897);
} else {
if((state_val_54917 === (3))){
var inst_54914 = (state_54916[(2)]);
var state_54916__$1 = state_54916;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54916__$1,inst_54914);
} else {
if((state_val_54917 === (4))){
var inst_54891 = (state_54916[(2)]);
var state_54916__$1 = state_54916;
var statearr_54921_54937 = state_54916__$1;
(statearr_54921_54937[(2)] = inst_54891);

(statearr_54921_54937[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54917 === (5))){
var _ = (function (){var statearr_54922 = state_54916;
(statearr_54922[(4)] = cljs.core.rest((state_54916[(4)])));

return statearr_54922;
})();
var state_54916__$1 = state_54916;
var ex54920 = (state_54916__$1[(2)]);
var statearr_54923_54938 = state_54916__$1;
(statearr_54923_54938[(5)] = ex54920);


if((ex54920 instanceof Error)){
var statearr_54924_54939 = state_54916__$1;
(statearr_54924_54939[(1)] = (4));

(statearr_54924_54939[(5)] = null);

} else {
throw ex54920;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54917 === (6))){
var inst_54899 = (state_54916[(2)]);
var inst_54900 = fluree.db.util.async.throw_err(inst_54899);
var inst_54901 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_54900);
var inst_54902 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54903 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54904 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54905 = [inst_54900];
var inst_54906 = (new cljs.core.PersistentVector(null,1,(5),inst_54904,inst_54905,null));
var inst_54907 = ["str",inst_54906,inst_54901];
var inst_54908 = cljs.core.PersistentHashMap.fromArrays(inst_54903,inst_54907);
var inst_54909 = [inst_54908,(10)];
var inst_54910 = (new cljs.core.PersistentVector(null,2,(5),inst_54902,inst_54909,null));
var inst_54911 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54910);
var _ = (function (){var statearr_54925 = state_54916;
(statearr_54925[(4)] = cljs.core.rest((state_54916[(4)])));

return statearr_54925;
})();
var state_54916__$1 = (function (){var statearr_54926 = state_54916;
(statearr_54926[(7)] = inst_54911);

return statearr_54926;
})();
var statearr_54927_54940 = state_54916__$1;
(statearr_54927_54940[(2)] = inst_54901);

(statearr_54927_54940[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_54928 = [null,null,null,null,null,null,null,null];
(statearr_54928[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_54928[(1)] = (1));

return statearr_54928;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_54916){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_54916);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e54929){var ex__2687__auto__ = e54929;
var statearr_54930_54941 = state_54916;
(statearr_54930_54941[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_54916[(4)]))){
var statearr_54931_54942 = state_54916;
(statearr_54931_54942[(1)] = cljs.core.first((state_54916[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54943 = state_54916;
state_54916 = G__54943;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_54916){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_54916);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_54932 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_54932[(6)] = c__2706__auto__);

return statearr_54932;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq54889){
var G__54890 = cljs.core.first(seq54889);
var seq54889__$1 = cljs.core.next(seq54889);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54890,seq54889__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_54969){
var state_val_54970 = (state_54969[(1)]);
if((state_val_54970 === (1))){
var state_54969__$1 = state_54969;
var statearr_54971_54986 = state_54969__$1;
(statearr_54971_54986[(2)] = null);

(statearr_54971_54986[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54970 === (2))){
var _ = (function (){var statearr_54972 = state_54969;
(statearr_54972[(4)] = cljs.core.cons((5),(state_54969[(4)])));

return statearr_54972;
})();
var inst_54950 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54969__$1 = state_54969;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54969__$1,(6),inst_54950);
} else {
if((state_val_54970 === (3))){
var inst_54967 = (state_54969[(2)]);
var state_54969__$1 = state_54969;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54969__$1,inst_54967);
} else {
if((state_val_54970 === (4))){
var inst_54944 = (state_54969[(2)]);
var state_54969__$1 = state_54969;
var statearr_54974_54987 = state_54969__$1;
(statearr_54974_54987[(2)] = inst_54944);

(statearr_54974_54987[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54970 === (5))){
var _ = (function (){var statearr_54975 = state_54969;
(statearr_54975[(4)] = cljs.core.rest((state_54969[(4)])));

return statearr_54975;
})();
var state_54969__$1 = state_54969;
var ex54973 = (state_54969__$1[(2)]);
var statearr_54976_54988 = state_54969__$1;
(statearr_54976_54988[(5)] = ex54973);


if((ex54973 instanceof Error)){
var statearr_54977_54989 = state_54969__$1;
(statearr_54977_54989[(1)] = (4));

(statearr_54977_54989[(5)] = null);

} else {
throw ex54973;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54970 === (6))){
var inst_54952 = (state_54969[(2)]);
var inst_54953 = fluree.db.util.async.throw_err(inst_54952);
var inst_54954 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_54953);
var inst_54955 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54956 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54957 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54958 = [inst_54953];
var inst_54959 = (new cljs.core.PersistentVector(null,1,(5),inst_54957,inst_54958,null));
var inst_54960 = ["subs",inst_54959,inst_54954];
var inst_54961 = cljs.core.PersistentHashMap.fromArrays(inst_54956,inst_54960);
var inst_54962 = [inst_54961,(30)];
var inst_54963 = (new cljs.core.PersistentVector(null,2,(5),inst_54955,inst_54962,null));
var inst_54964 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54963);
var _ = (function (){var statearr_54978 = state_54969;
(statearr_54978[(4)] = cljs.core.rest((state_54969[(4)])));

return statearr_54978;
})();
var state_54969__$1 = (function (){var statearr_54979 = state_54969;
(statearr_54979[(7)] = inst_54964);

return statearr_54979;
})();
var statearr_54980_54990 = state_54969__$1;
(statearr_54980_54990[(2)] = inst_54954);

(statearr_54980_54990[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto____0 = (function (){
var statearr_54981 = [null,null,null,null,null,null,null,null];
(statearr_54981[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto__);

(statearr_54981[(1)] = (1));

return statearr_54981;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto____1 = (function (state_54969){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_54969);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e54982){var ex__2687__auto__ = e54982;
var statearr_54983_54991 = state_54969;
(statearr_54983_54991[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_54969[(4)]))){
var statearr_54984_54992 = state_54969;
(statearr_54984_54992[(1)] = cljs.core.first((state_54969[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54993 = state_54969;
state_54969 = G__54993;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto__ = function(state_54969){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto____1.call(this,state_54969);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_54985 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_54985[(6)] = c__2706__auto__);

return statearr_54985;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55023){
var state_val_55024 = (state_55023[(1)]);
if((state_val_55024 === (7))){
var state_55023__$1 = state_55023;
var statearr_55025_55044 = state_55023__$1;
(statearr_55025_55044[(2)] = str);

(statearr_55025_55044[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55024 === (1))){
var state_55023__$1 = state_55023;
var statearr_55026_55045 = state_55023__$1;
(statearr_55026_55045[(2)] = null);

(statearr_55026_55045[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55024 === (4))){
var inst_54994 = (state_55023[(2)]);
var state_55023__$1 = state_55023;
var statearr_55027_55046 = state_55023__$1;
(statearr_55027_55046[(2)] = inst_54994);

(statearr_55027_55046[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55024 === (6))){
var state_55023__$1 = state_55023;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55023__$1,(9),str);
} else {
if((state_val_55024 === (3))){
var inst_55021 = (state_55023[(2)]);
var state_55023__$1 = state_55023;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55023__$1,inst_55021);
} else {
if((state_val_55024 === (2))){
var _ = (function (){var statearr_55029 = state_55023;
(statearr_55029[(4)] = cljs.core.cons((5),(state_55023[(4)])));

return statearr_55029;
})();
var inst_55000 = fluree.db.util.async.channel_QMARK_(str);
var state_55023__$1 = state_55023;
if(inst_55000){
var statearr_55030_55047 = state_55023__$1;
(statearr_55030_55047[(1)] = (6));

} else {
var statearr_55031_55048 = state_55023__$1;
(statearr_55031_55048[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55024 === (9))){
var inst_55003 = (state_55023[(2)]);
var inst_55004 = fluree.db.util.async.throw_err(inst_55003);
var state_55023__$1 = state_55023;
var statearr_55032_55049 = state_55023__$1;
(statearr_55032_55049[(2)] = inst_55004);

(statearr_55032_55049[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55024 === (5))){
var _ = (function (){var statearr_55033 = state_55023;
(statearr_55033[(4)] = cljs.core.rest((state_55023[(4)])));

return statearr_55033;
})();
var state_55023__$1 = state_55023;
var ex55028 = (state_55023__$1[(2)]);
var statearr_55034_55050 = state_55023__$1;
(statearr_55034_55050[(5)] = ex55028);


if((ex55028 instanceof Error)){
var statearr_55035_55051 = state_55023__$1;
(statearr_55035_55051[(1)] = (4));

(statearr_55035_55051[(5)] = null);

} else {
throw ex55028;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55024 === (8))){
var inst_55007 = (state_55023[(2)]);
var inst_55008 = fluree.db.dbfunctions.internal.lower_case(inst_55007);
var inst_55009 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55010 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55011 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55012 = [inst_55007];
var inst_55013 = (new cljs.core.PersistentVector(null,1,(5),inst_55011,inst_55012,null));
var inst_55014 = ["lower-case",inst_55013,inst_55008];
var inst_55015 = cljs.core.PersistentHashMap.fromArrays(inst_55010,inst_55014);
var inst_55016 = [inst_55015,(10)];
var inst_55017 = (new cljs.core.PersistentVector(null,2,(5),inst_55009,inst_55016,null));
var inst_55018 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55017);
var _ = (function (){var statearr_55036 = state_55023;
(statearr_55036[(4)] = cljs.core.rest((state_55023[(4)])));

return statearr_55036;
})();
var state_55023__$1 = (function (){var statearr_55037 = state_55023;
(statearr_55037[(7)] = inst_55018);

return statearr_55037;
})();
var statearr_55038_55052 = state_55023__$1;
(statearr_55038_55052[(2)] = inst_55008);

(statearr_55038_55052[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto____0 = (function (){
var statearr_55039 = [null,null,null,null,null,null,null,null];
(statearr_55039[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto__);

(statearr_55039[(1)] = (1));

return statearr_55039;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto____1 = (function (state_55023){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55023);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55040){var ex__2687__auto__ = e55040;
var statearr_55041_55053 = state_55023;
(statearr_55041_55053[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55023[(4)]))){
var statearr_55042_55054 = state_55023;
(statearr_55042_55054[(1)] = cljs.core.first((state_55023[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55055 = state_55023;
state_55023 = G__55055;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto__ = function(state_55023){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto____1.call(this,state_55023);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55043 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55043[(6)] = c__2706__auto__);

return statearr_55043;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55085){
var state_val_55086 = (state_55085[(1)]);
if((state_val_55086 === (7))){
var state_55085__$1 = state_55085;
var statearr_55087_55106 = state_55085__$1;
(statearr_55087_55106[(2)] = str);

(statearr_55087_55106[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55086 === (1))){
var state_55085__$1 = state_55085;
var statearr_55088_55107 = state_55085__$1;
(statearr_55088_55107[(2)] = null);

(statearr_55088_55107[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55086 === (4))){
var inst_55056 = (state_55085[(2)]);
var state_55085__$1 = state_55085;
var statearr_55089_55108 = state_55085__$1;
(statearr_55089_55108[(2)] = inst_55056);

(statearr_55089_55108[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55086 === (6))){
var state_55085__$1 = state_55085;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55085__$1,(9),str);
} else {
if((state_val_55086 === (3))){
var inst_55083 = (state_55085[(2)]);
var state_55085__$1 = state_55085;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55085__$1,inst_55083);
} else {
if((state_val_55086 === (2))){
var _ = (function (){var statearr_55091 = state_55085;
(statearr_55091[(4)] = cljs.core.cons((5),(state_55085[(4)])));

return statearr_55091;
})();
var inst_55062 = fluree.db.util.async.channel_QMARK_(str);
var state_55085__$1 = state_55085;
if(inst_55062){
var statearr_55092_55109 = state_55085__$1;
(statearr_55092_55109[(1)] = (6));

} else {
var statearr_55093_55110 = state_55085__$1;
(statearr_55093_55110[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55086 === (9))){
var inst_55065 = (state_55085[(2)]);
var inst_55066 = fluree.db.util.async.throw_err(inst_55065);
var state_55085__$1 = state_55085;
var statearr_55094_55111 = state_55085__$1;
(statearr_55094_55111[(2)] = inst_55066);

(statearr_55094_55111[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55086 === (5))){
var _ = (function (){var statearr_55095 = state_55085;
(statearr_55095[(4)] = cljs.core.rest((state_55085[(4)])));

return statearr_55095;
})();
var state_55085__$1 = state_55085;
var ex55090 = (state_55085__$1[(2)]);
var statearr_55096_55112 = state_55085__$1;
(statearr_55096_55112[(5)] = ex55090);


if((ex55090 instanceof Error)){
var statearr_55097_55113 = state_55085__$1;
(statearr_55097_55113[(1)] = (4));

(statearr_55097_55113[(5)] = null);

} else {
throw ex55090;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55086 === (8))){
var inst_55069 = (state_55085[(2)]);
var inst_55070 = fluree.db.dbfunctions.internal.upper_case(inst_55069);
var inst_55071 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55072 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55073 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55074 = [inst_55069];
var inst_55075 = (new cljs.core.PersistentVector(null,1,(5),inst_55073,inst_55074,null));
var inst_55076 = ["upper-case",inst_55075,inst_55070];
var inst_55077 = cljs.core.PersistentHashMap.fromArrays(inst_55072,inst_55076);
var inst_55078 = [inst_55077,(10)];
var inst_55079 = (new cljs.core.PersistentVector(null,2,(5),inst_55071,inst_55078,null));
var inst_55080 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55079);
var _ = (function (){var statearr_55098 = state_55085;
(statearr_55098[(4)] = cljs.core.rest((state_55085[(4)])));

return statearr_55098;
})();
var state_55085__$1 = (function (){var statearr_55099 = state_55085;
(statearr_55099[(7)] = inst_55080);

return statearr_55099;
})();
var statearr_55100_55114 = state_55085__$1;
(statearr_55100_55114[(2)] = inst_55070);

(statearr_55100_55114[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto____0 = (function (){
var statearr_55101 = [null,null,null,null,null,null,null,null];
(statearr_55101[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto__);

(statearr_55101[(1)] = (1));

return statearr_55101;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto____1 = (function (state_55085){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55085);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55102){var ex__2687__auto__ = e55102;
var statearr_55103_55115 = state_55085;
(statearr_55103_55115[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55085[(4)]))){
var statearr_55104_55116 = state_55085;
(statearr_55104_55116[(1)] = cljs.core.first((state_55085[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55117 = state_55085;
state_55085 = G__55117;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto__ = function(state_55085){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto____1.call(this,state_55085);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55105 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55105[(6)] = c__2706__auto__);

return statearr_55105;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__5043__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__5043__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__55119 = arguments.length;
switch (G__55119) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55147){
var state_val_55148 = (state_55147[(1)]);
if((state_val_55148 === (1))){
var state_55147__$1 = state_55147;
var statearr_55149_55165 = state_55147__$1;
(statearr_55149_55165[(2)] = null);

(statearr_55149_55165[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55148 === (2))){
var _ = (function (){var statearr_55150 = state_55147;
(statearr_55150[(4)] = cljs.core.cons((5),(state_55147[(4)])));

return statearr_55150;
})();
var inst_55129 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_55147__$1 = state_55147;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55147__$1,(6),inst_55129);
} else {
if((state_val_55148 === (3))){
var inst_55145 = (state_55147[(2)]);
var state_55147__$1 = state_55147;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55147__$1,inst_55145);
} else {
if((state_val_55148 === (4))){
var inst_55120 = (state_55147[(2)]);
var state_55147__$1 = state_55147;
var statearr_55152_55166 = state_55147__$1;
(statearr_55152_55166[(2)] = inst_55120);

(statearr_55152_55166[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55148 === (5))){
var _ = (function (){var statearr_55153 = state_55147;
(statearr_55153[(4)] = cljs.core.rest((state_55147[(4)])));

return statearr_55153;
})();
var state_55147__$1 = state_55147;
var ex55151 = (state_55147__$1[(2)]);
var statearr_55154_55167 = state_55147__$1;
(statearr_55154_55167[(5)] = ex55151);


if((ex55151 instanceof Error)){
var statearr_55155_55168 = state_55147__$1;
(statearr_55155_55168[(1)] = (4));

(statearr_55155_55168[(5)] = null);

} else {
throw ex55151;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55148 === (6))){
var inst_55131 = (state_55147[(2)]);
var inst_55132 = fluree.db.util.async.throw_err(inst_55131);
var inst_55133 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55132,(0),null);
var inst_55134 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55132,(1),null);
var inst_55135 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55136 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55137 = ["?s","?ctx",inst_55133];
var inst_55138 = cljs.core.PersistentHashMap.fromArrays(inst_55136,inst_55137);
var inst_55139 = ((10) + inst_55134);
var inst_55140 = [inst_55138,inst_55139];
var inst_55141 = (new cljs.core.PersistentVector(null,2,(5),inst_55135,inst_55140,null));
var inst_55142 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55141);
var _ = (function (){var statearr_55156 = state_55147;
(statearr_55156[(4)] = cljs.core.rest((state_55147[(4)])));

return statearr_55156;
})();
var state_55147__$1 = (function (){var statearr_55157 = state_55147;
(statearr_55157[(7)] = inst_55142);

return statearr_55157;
})();
var statearr_55158_55169 = state_55147__$1;
(statearr_55158_55169[(2)] = inst_55133);

(statearr_55158_55169[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_55159 = [null,null,null,null,null,null,null,null];
(statearr_55159[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_55159[(1)] = (1));

return statearr_55159;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_55147){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55147);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55160){var ex__2687__auto__ = e55160;
var statearr_55161_55170 = state_55147;
(statearr_55161_55170[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55147[(4)]))){
var statearr_55162_55171 = state_55147;
(statearr_55162_55171[(1)] = cljs.core.first((state_55147[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55172 = state_55147;
state_55147 = G__55172;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_55147){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_55147);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55163 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55163[(6)] = c__2706__auto__);

return statearr_55163;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__55174 = arguments.length;
switch (G__55174) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55212){
var state_val_55213 = (state_55212[(1)]);
if((state_val_55213 === (7))){
var inst_55205 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_55212__$1 = state_55212;
var statearr_55214_55234 = state_55212__$1;
(statearr_55214_55234[(2)] = inst_55205);

(statearr_55214_55234[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55213 === (1))){
var state_55212__$1 = state_55212;
var statearr_55215_55235 = state_55212__$1;
(statearr_55215_55235[(2)] = null);

(statearr_55215_55235[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55213 === (4))){
var inst_55175 = (state_55212[(2)]);
var state_55212__$1 = state_55212;
var statearr_55216_55236 = state_55212__$1;
(statearr_55216_55236[(2)] = inst_55175);

(statearr_55216_55236[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55213 === (6))){
var inst_55186 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_55212__$1 = state_55212;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55212__$1,(10),inst_55186);
} else {
if((state_val_55213 === (3))){
var inst_55210 = (state_55212[(2)]);
var state_55212__$1 = state_55212;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55212__$1,inst_55210);
} else {
if((state_val_55213 === (2))){
var _ = (function (){var statearr_55218 = state_55212;
(statearr_55218[(4)] = cljs.core.cons((5),(state_55212[(4)])));

return statearr_55218;
})();
var inst_55181 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55212__$1 = state_55212;
if(cljs.core.truth_(inst_55181)){
var statearr_55219_55237 = state_55212__$1;
(statearr_55219_55237[(1)] = (6));

} else {
var statearr_55220_55238 = state_55212__$1;
(statearr_55220_55238[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55213 === (9))){
var inst_55192 = (state_55212[(2)]);
var inst_55193 = fluree.db.util.async.throw_err(inst_55192);
var inst_55194 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55193,(0),null);
var inst_55195 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55193,(1),null);
var inst_55196 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55197 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55198 = ["?p","?ctx",inst_55194];
var inst_55199 = cljs.core.PersistentHashMap.fromArrays(inst_55197,inst_55198);
var inst_55200 = ((10) + inst_55195);
var inst_55201 = [inst_55199,inst_55200];
var inst_55202 = (new cljs.core.PersistentVector(null,2,(5),inst_55196,inst_55201,null));
var inst_55203 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55202);
var state_55212__$1 = (function (){var statearr_55221 = state_55212;
(statearr_55221[(7)] = inst_55203);

return statearr_55221;
})();
var statearr_55222_55239 = state_55212__$1;
(statearr_55222_55239[(2)] = inst_55194);

(statearr_55222_55239[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55213 === (5))){
var _ = (function (){var statearr_55223 = state_55212;
(statearr_55223[(4)] = cljs.core.rest((state_55212[(4)])));

return statearr_55223;
})();
var state_55212__$1 = state_55212;
var ex55217 = (state_55212__$1[(2)]);
var statearr_55224_55240 = state_55212__$1;
(statearr_55224_55240[(5)] = ex55217);


if((ex55217 instanceof Error)){
var statearr_55225_55241 = state_55212__$1;
(statearr_55225_55241[(1)] = (4));

(statearr_55225_55241[(5)] = null);

} else {
throw ex55217;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55213 === (10))){
var inst_55188 = (state_55212[(2)]);
var inst_55189 = fluree.db.util.async.throw_err(inst_55188);
var inst_55190 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_55189);
var state_55212__$1 = state_55212;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55212__$1,(9),inst_55190);
} else {
if((state_val_55213 === (8))){
var inst_55207 = (state_55212[(2)]);
var _ = (function (){var statearr_55226 = state_55212;
(statearr_55226[(4)] = cljs.core.rest((state_55212[(4)])));

return statearr_55226;
})();
var state_55212__$1 = state_55212;
var statearr_55227_55242 = state_55212__$1;
(statearr_55227_55242[(2)] = inst_55207);

(statearr_55227_55242[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_55228 = [null,null,null,null,null,null,null,null];
(statearr_55228[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_55228[(1)] = (1));

return statearr_55228;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_55212){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55212);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55229){var ex__2687__auto__ = e55229;
var statearr_55230_55243 = state_55212;
(statearr_55230_55243[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55212[(4)]))){
var statearr_55231_55244 = state_55212;
(statearr_55231_55244[(1)] = cljs.core.first((state_55212[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55245 = state_55212;
state_55212 = G__55245;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_55212){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_55212);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55232 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55232[(6)] = c__2706__auto__);

return statearr_55232;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55294 = arguments.length;
var i__5770__auto___55295 = (0);
while(true){
if((i__5770__auto___55295 < len__5769__auto___55294)){
args__5775__auto__.push((arguments[i__5770__auto___55295]));

var G__55296 = (i__5770__auto___55295 + (1));
i__5770__auto___55295 = G__55296;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55277){
var state_val_55278 = (state_55277[(1)]);
if((state_val_55278 === (1))){
var state_55277__$1 = state_55277;
var statearr_55279_55297 = state_55277__$1;
(statearr_55279_55297[(2)] = null);

(statearr_55279_55297[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55278 === (2))){
var _ = (function (){var statearr_55280 = state_55277;
(statearr_55280[(4)] = cljs.core.cons((5),(state_55277[(4)])));

return statearr_55280;
})();
var inst_55254 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55277__$1 = state_55277;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55277__$1,(6),inst_55254);
} else {
if((state_val_55278 === (3))){
var inst_55275 = (state_55277[(2)]);
var state_55277__$1 = state_55277;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55277__$1,inst_55275);
} else {
if((state_val_55278 === (4))){
var inst_55248 = (state_55277[(2)]);
var state_55277__$1 = state_55277;
var statearr_55282_55298 = state_55277__$1;
(statearr_55282_55298[(2)] = inst_55248);

(statearr_55282_55298[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55278 === (5))){
var _ = (function (){var statearr_55283 = state_55277;
(statearr_55283[(4)] = cljs.core.rest((state_55277[(4)])));

return statearr_55283;
})();
var state_55277__$1 = state_55277;
var ex55281 = (state_55277__$1[(2)]);
var statearr_55284_55299 = state_55277__$1;
(statearr_55284_55299[(5)] = ex55281);


if((ex55281 instanceof Error)){
var statearr_55285_55300 = state_55277__$1;
(statearr_55285_55300[(1)] = (4));

(statearr_55285_55300[(5)] = null);

} else {
throw ex55281;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55278 === (6))){
var inst_55256 = (state_55277[(2)]);
var inst_55257 = fluree.db.util.async.throw_err(inst_55256);
var inst_55258 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_55257);
var inst_55259 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55260 = [inst_55257];
var inst_55261 = (new cljs.core.PersistentVector(null,1,(5),inst_55259,inst_55260,null));
var inst_55262 = cljs.core.count(inst_55261);
var inst_55263 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55264 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55265 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55266 = [inst_55257];
var inst_55267 = (new cljs.core.PersistentVector(null,1,(5),inst_55265,inst_55266,null));
var inst_55268 = ["and",inst_55267,inst_55258];
var inst_55269 = cljs.core.PersistentHashMap.fromArrays(inst_55264,inst_55268);
var inst_55270 = [inst_55269,inst_55262];
var inst_55271 = (new cljs.core.PersistentVector(null,2,(5),inst_55263,inst_55270,null));
var inst_55272 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55271);
var _ = (function (){var statearr_55286 = state_55277;
(statearr_55286[(4)] = cljs.core.rest((state_55277[(4)])));

return statearr_55286;
})();
var state_55277__$1 = (function (){var statearr_55287 = state_55277;
(statearr_55287[(7)] = inst_55272);

return statearr_55287;
})();
var statearr_55288_55301 = state_55277__$1;
(statearr_55288_55301[(2)] = inst_55258);

(statearr_55288_55301[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_55289 = [null,null,null,null,null,null,null,null];
(statearr_55289[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_55289[(1)] = (1));

return statearr_55289;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_55277){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55277);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55290){var ex__2687__auto__ = e55290;
var statearr_55291_55302 = state_55277;
(statearr_55291_55302[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55277[(4)]))){
var statearr_55292_55303 = state_55277;
(statearr_55292_55303[(1)] = cljs.core.first((state_55277[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55304 = state_55277;
state_55277 = G__55304;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_55277){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_55277);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55293 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55293[(6)] = c__2706__auto__);

return statearr_55293;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq55246){
var G__55247 = cljs.core.first(seq55246);
var seq55246__$1 = cljs.core.next(seq55246);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55247,seq55246__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55353 = arguments.length;
var i__5770__auto___55354 = (0);
while(true){
if((i__5770__auto___55354 < len__5769__auto___55353)){
args__5775__auto__.push((arguments[i__5770__auto___55354]));

var G__55355 = (i__5770__auto___55354 + (1));
i__5770__auto___55354 = G__55355;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55336){
var state_val_55337 = (state_55336[(1)]);
if((state_val_55337 === (1))){
var state_55336__$1 = state_55336;
var statearr_55338_55356 = state_55336__$1;
(statearr_55338_55356[(2)] = null);

(statearr_55338_55356[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55337 === (2))){
var _ = (function (){var statearr_55339 = state_55336;
(statearr_55339[(4)] = cljs.core.cons((5),(state_55336[(4)])));

return statearr_55339;
})();
var inst_55313 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55336__$1 = state_55336;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55336__$1,(6),inst_55313);
} else {
if((state_val_55337 === (3))){
var inst_55334 = (state_55336[(2)]);
var state_55336__$1 = state_55336;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55336__$1,inst_55334);
} else {
if((state_val_55337 === (4))){
var inst_55307 = (state_55336[(2)]);
var state_55336__$1 = state_55336;
var statearr_55341_55357 = state_55336__$1;
(statearr_55341_55357[(2)] = inst_55307);

(statearr_55341_55357[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55337 === (5))){
var _ = (function (){var statearr_55342 = state_55336;
(statearr_55342[(4)] = cljs.core.rest((state_55336[(4)])));

return statearr_55342;
})();
var state_55336__$1 = state_55336;
var ex55340 = (state_55336__$1[(2)]);
var statearr_55343_55358 = state_55336__$1;
(statearr_55343_55358[(5)] = ex55340);


if((ex55340 instanceof Error)){
var statearr_55344_55359 = state_55336__$1;
(statearr_55344_55359[(1)] = (4));

(statearr_55344_55359[(5)] = null);

} else {
throw ex55340;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55337 === (6))){
var inst_55315 = (state_55336[(2)]);
var inst_55316 = fluree.db.util.async.throw_err(inst_55315);
var inst_55317 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_55316);
var inst_55318 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55319 = [inst_55316];
var inst_55320 = (new cljs.core.PersistentVector(null,1,(5),inst_55318,inst_55319,null));
var inst_55321 = cljs.core.count(inst_55320);
var inst_55322 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55323 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55324 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55325 = [inst_55316];
var inst_55326 = (new cljs.core.PersistentVector(null,1,(5),inst_55324,inst_55325,null));
var inst_55327 = ["or",inst_55326,inst_55317];
var inst_55328 = cljs.core.PersistentHashMap.fromArrays(inst_55323,inst_55327);
var inst_55329 = [inst_55328,inst_55321];
var inst_55330 = (new cljs.core.PersistentVector(null,2,(5),inst_55322,inst_55329,null));
var inst_55331 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55330);
var _ = (function (){var statearr_55345 = state_55336;
(statearr_55345[(4)] = cljs.core.rest((state_55336[(4)])));

return statearr_55345;
})();
var state_55336__$1 = (function (){var statearr_55346 = state_55336;
(statearr_55346[(7)] = inst_55331);

return statearr_55346;
})();
var statearr_55347_55360 = state_55336__$1;
(statearr_55347_55360[(2)] = inst_55317);

(statearr_55347_55360[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_55348 = [null,null,null,null,null,null,null,null];
(statearr_55348[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_55348[(1)] = (1));

return statearr_55348;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_55336){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55336);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55349){var ex__2687__auto__ = e55349;
var statearr_55350_55361 = state_55336;
(statearr_55350_55361[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55336[(4)]))){
var statearr_55351_55362 = state_55336;
(statearr_55351_55362[(1)] = cljs.core.first((state_55336[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55363 = state_55336;
state_55336 = G__55363;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_55336){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_55336);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55352 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55352[(6)] = c__2706__auto__);

return statearr_55352;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq55305){
var G__55306 = cljs.core.first(seq55305);
var seq55305__$1 = cljs.core.next(seq55305);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55306,seq55305__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55401){
var state_val_55402 = (state_55401[(1)]);
if((state_val_55402 === (7))){
var inst_55377 = fluree.db.util.async.channel_QMARK_(coll);
var state_55401__$1 = state_55401;
if(inst_55377){
var statearr_55403_55426 = state_55401__$1;
(statearr_55403_55426[(1)] = (10));

} else {
var statearr_55404_55427 = state_55401__$1;
(statearr_55404_55427[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55402 === (1))){
var state_55401__$1 = state_55401;
var statearr_55405_55428 = state_55401__$1;
(statearr_55405_55428[(2)] = null);

(statearr_55405_55428[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55402 === (4))){
var inst_55364 = (state_55401[(2)]);
var state_55401__$1 = state_55401;
var statearr_55406_55429 = state_55401__$1;
(statearr_55406_55429[(2)] = inst_55364);

(statearr_55406_55429[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55402 === (13))){
var inst_55380 = (state_55401[(2)]);
var inst_55381 = fluree.db.util.async.throw_err(inst_55380);
var state_55401__$1 = state_55401;
var statearr_55407_55430 = state_55401__$1;
(statearr_55407_55430[(2)] = inst_55381);

(statearr_55407_55430[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55402 === (6))){
var inst_55372 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_55401__$1 = state_55401;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55401__$1,(9),inst_55372);
} else {
if((state_val_55402 === (3))){
var inst_55399 = (state_55401[(2)]);
var state_55401__$1 = state_55401;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55401__$1,inst_55399);
} else {
if((state_val_55402 === (12))){
var inst_55384 = (state_55401[(2)]);
var state_55401__$1 = state_55401;
var statearr_55408_55431 = state_55401__$1;
(statearr_55408_55431[(2)] = inst_55384);

(statearr_55408_55431[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55402 === (2))){
var _ = (function (){var statearr_55409 = state_55401;
(statearr_55409[(4)] = cljs.core.cons((5),(state_55401[(4)])));

return statearr_55409;
})();
var inst_55370 = cljs.core.vector_QMARK_(coll);
var state_55401__$1 = state_55401;
if(inst_55370){
var statearr_55410_55432 = state_55401__$1;
(statearr_55410_55432[(1)] = (6));

} else {
var statearr_55411_55433 = state_55401__$1;
(statearr_55411_55433[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55402 === (11))){
var state_55401__$1 = state_55401;
var statearr_55413_55434 = state_55401__$1;
(statearr_55413_55434[(2)] = coll);

(statearr_55413_55434[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55402 === (9))){
var inst_55374 = (state_55401[(2)]);
var inst_55375 = fluree.db.util.async.throw_err(inst_55374);
var state_55401__$1 = state_55401;
var statearr_55414_55435 = state_55401__$1;
(statearr_55414_55435[(2)] = inst_55375);

(statearr_55414_55435[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55402 === (5))){
var _ = (function (){var statearr_55415 = state_55401;
(statearr_55415[(4)] = cljs.core.rest((state_55401[(4)])));

return statearr_55415;
})();
var state_55401__$1 = state_55401;
var ex55412 = (state_55401__$1[(2)]);
var statearr_55416_55436 = state_55401__$1;
(statearr_55416_55436[(5)] = ex55412);


if((ex55412 instanceof Error)){
var statearr_55417_55437 = state_55401__$1;
(statearr_55417_55437[(1)] = (4));

(statearr_55417_55437[(5)] = null);

} else {
throw ex55412;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55402 === (10))){
var state_55401__$1 = state_55401;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55401__$1,(13),coll);
} else {
if((state_val_55402 === (8))){
var inst_55386 = (state_55401[(2)]);
var inst_55387 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_55386);
var inst_55388 = cljs.core.count(inst_55387);
var inst_55389 = ((9) + inst_55388);
var inst_55390 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55391 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55392 = ["count",inst_55386,inst_55388];
var inst_55393 = cljs.core.PersistentHashMap.fromArrays(inst_55391,inst_55392);
var inst_55394 = [inst_55393,inst_55389];
var inst_55395 = (new cljs.core.PersistentVector(null,2,(5),inst_55390,inst_55394,null));
var inst_55396 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55395);
var _ = (function (){var statearr_55418 = state_55401;
(statearr_55418[(4)] = cljs.core.rest((state_55401[(4)])));

return statearr_55418;
})();
var state_55401__$1 = (function (){var statearr_55419 = state_55401;
(statearr_55419[(7)] = inst_55396);

return statearr_55419;
})();
var statearr_55420_55438 = state_55401__$1;
(statearr_55420_55438[(2)] = inst_55388);

(statearr_55420_55438[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto____0 = (function (){
var statearr_55421 = [null,null,null,null,null,null,null,null];
(statearr_55421[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto__);

(statearr_55421[(1)] = (1));

return statearr_55421;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto____1 = (function (state_55401){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55401);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55422){var ex__2687__auto__ = e55422;
var statearr_55423_55439 = state_55401;
(statearr_55423_55439[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55401[(4)]))){
var statearr_55424_55440 = state_55401;
(statearr_55424_55440[(1)] = cljs.core.first((state_55401[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55441 = state_55401;
state_55401 = G__55441;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto__ = function(state_55401){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto____1.call(this,state_55401);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55425 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55425[(6)] = c__2706__auto__);

return statearr_55425;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(p__55442,subject,pred){
var map__55443 = p__55442;
var map__55443__$1 = cljs.core.__destructure_map(map__55443);
var _QMARK_ctx = map__55443__$1;
var cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55443__$1,new cljs.core.Keyword(null,"cache","cache",-1237023054));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55443__$1,new cljs.core.Keyword(null,"db","db",993250759));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55534){
var state_val_55535 = (state_55534[(1)]);
if((state_val_55535 === (7))){
var state_55534__$1 = state_55534;
var statearr_55536_55592 = state_55534__$1;
(statearr_55536_55592[(2)] = subject);

(statearr_55536_55592[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55535 === (20))){
var state_55534__$1 = state_55534;
var statearr_55537_55593 = state_55534__$1;
(statearr_55537_55593[(2)] = cache);

(statearr_55537_55593[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55535 === (27))){
var inst_55477 = (state_55534[(7)]);
var inst_55465 = (state_55534[(8)]);
var inst_55491 = fluree.db.dbfunctions.internal.get_subj_pred(db,inst_55477,inst_55465);
var state_55534__$1 = state_55534;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55534__$1,(29),inst_55491);
} else {
if((state_val_55535 === (1))){
var state_55534__$1 = state_55534;
var statearr_55538_55594 = state_55534__$1;
(statearr_55538_55594[(2)] = null);

(statearr_55538_55594[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55535 === (24))){
var inst_55477 = (state_55534[(7)]);
var inst_55504 = cljs.core.int_QMARK_(inst_55477);
var state_55534__$1 = state_55534;
if(inst_55504){
var statearr_55539_55595 = state_55534__$1;
(statearr_55539_55595[(1)] = (30));

} else {
var statearr_55540_55596 = state_55534__$1;
(statearr_55540_55596[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55535 === (4))){
var inst_55444 = (state_55534[(2)]);
var state_55534__$1 = state_55534;
var statearr_55541_55597 = state_55534__$1;
(statearr_55541_55597[(2)] = inst_55444);

(statearr_55541_55597[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55535 === (15))){
var inst_55457 = (state_55534[(9)]);
var state_55534__$1 = state_55534;
var statearr_55542_55598 = state_55534__$1;
(statearr_55542_55598[(2)] = inst_55457);

(statearr_55542_55598[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55535 === (21))){
var inst_55478 = (state_55534[(10)]);
var state_55534__$1 = state_55534;
var statearr_55543_55599 = state_55534__$1;
(statearr_55543_55599[(2)] = inst_55478);

(statearr_55543_55599[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55535 === (31))){
var state_55534__$1 = state_55534;
var statearr_55544_55600 = state_55534__$1;
(statearr_55544_55600[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55535 === (32))){
var inst_55517 = (state_55534[(2)]);
var state_55534__$1 = state_55534;
var statearr_55546_55601 = state_55534__$1;
(statearr_55546_55601[(2)] = inst_55517);

(statearr_55546_55601[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55535 === (33))){
var inst_55508 = (state_55534[(2)]);
var inst_55509 = fluree.db.util.async.throw_err(inst_55508);
var state_55534__$1 = state_55534;
var statearr_55547_55602 = state_55534__$1;
(statearr_55547_55602[(2)] = inst_55509);

(statearr_55547_55602[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55535 === (13))){
var inst_55461 = (state_55534[(2)]);
var inst_55462 = fluree.db.util.async.throw_err(inst_55461);
var state_55534__$1 = state_55534;
var statearr_55548_55603 = state_55534__$1;
(statearr_55548_55603[(2)] = inst_55462);

(statearr_55548_55603[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55535 === (22))){
var inst_55482 = (state_55534[(2)]);
var state_55534__$1 = state_55534;
if(cljs.core.truth_(inst_55482)){
var statearr_55549_55604 = state_55534__$1;
(statearr_55549_55604[(1)] = (23));

} else {
var statearr_55550_55605 = state_55534__$1;
(statearr_55550_55605[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55535 === (36))){
var inst_55515 = (state_55534[(2)]);
var state_55534__$1 = state_55534;
var statearr_55551_55606 = state_55534__$1;
(statearr_55551_55606[(2)] = inst_55515);

(statearr_55551_55606[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55535 === (29))){
var inst_55477 = (state_55534[(7)]);
var inst_55465 = (state_55534[(8)]);
var inst_55493 = (state_55534[(2)]);
var inst_55494 = fluree.db.util.async.throw_err(inst_55493);
var inst_55495 = cljs.core._deref(cache);
var inst_55496 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55497 = [new cljs.core.Keyword(null,"get","get",1683182755),inst_55477,inst_55465];
var inst_55498 = (new cljs.core.PersistentVector(null,3,(5),inst_55496,inst_55497,null));
var inst_55499 = cljs.core.assoc_in(inst_55495,inst_55498,inst_55494);
var inst_55500 = cljs.core._vreset_BANG_(cache,inst_55499);
var state_55534__$1 = (function (){var statearr_55552 = state_55534;
(statearr_55552[(11)] = inst_55500);

return statearr_55552;
})();
var statearr_55553_55607 = state_55534__$1;
(statearr_55553_55607[(2)] = inst_55494);

(statearr_55553_55607[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55535 === (6))){
var state_55534__$1 = state_55534;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55534__$1,(9),subject);
} else {
if((state_val_55535 === (28))){
var inst_55502 = (state_55534[(2)]);
var state_55534__$1 = state_55534;
var statearr_55554_55608 = state_55534__$1;
(statearr_55554_55608[(2)] = inst_55502);

(statearr_55554_55608[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55535 === (25))){
var inst_55457 = (state_55534[(9)]);
var inst_55465 = (state_55534[(8)]);
var inst_55519 = (state_55534[(2)]);
var inst_55520 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55521 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55522 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55523 = [inst_55457,inst_55465];
var inst_55524 = (new cljs.core.PersistentVector(null,2,(5),inst_55522,inst_55523,null));
var inst_55525 = ["get",inst_55524,inst_55519];
var inst_55526 = cljs.core.PersistentHashMap.fromArrays(inst_55521,inst_55525);
var inst_55527 = [inst_55526,(10)];
var inst_55528 = (new cljs.core.PersistentVector(null,2,(5),inst_55520,inst_55527,null));
var inst_55529 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55528);
var _ = (function (){var statearr_55555 = state_55534;
(statearr_55555[(4)] = cljs.core.rest((state_55534[(4)])));

return statearr_55555;
})();
var state_55534__$1 = (function (){var statearr_55556 = state_55534;
(statearr_55556[(12)] = inst_55529);

return statearr_55556;
})();
var statearr_55557_55609 = state_55534__$1;
(statearr_55557_55609[(2)] = inst_55519);

(statearr_55557_55609[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55535 === (34))){
var inst_55477 = (state_55534[(7)]);
var inst_55465 = (state_55534[(8)]);
var inst_55512 = fluree.db.dbfunctions.internal.get(inst_55477,inst_55465);
var state_55534__$1 = state_55534;
var statearr_55558_55610 = state_55534__$1;
(statearr_55558_55610[(2)] = inst_55512);

(statearr_55558_55610[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55535 === (17))){
var inst_55457 = (state_55534[(9)]);
var inst_55471 = cljs.core.first(inst_55457);
var state_55534__$1 = state_55534;
var statearr_55559_55611 = state_55534__$1;
(statearr_55559_55611[(2)] = inst_55471);

(statearr_55559_55611[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55535 === (3))){
var inst_55532 = (state_55534[(2)]);
var state_55534__$1 = state_55534;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55534__$1,inst_55532);
} else {
if((state_val_55535 === (12))){
var inst_55457 = (state_55534[(9)]);
var inst_55465 = (state_55534[(2)]);
var inst_55466 = cljs.core.vector_QMARK_(inst_55457);
var state_55534__$1 = (function (){var statearr_55560 = state_55534;
(statearr_55560[(8)] = inst_55465);

return statearr_55560;
})();
if(inst_55466){
var statearr_55561_55612 = state_55534__$1;
(statearr_55561_55612[(1)] = (14));

} else {
var statearr_55562_55613 = state_55534__$1;
(statearr_55562_55613[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55535 === (2))){
var _ = (function (){var statearr_55563 = state_55534;
(statearr_55563[(4)] = cljs.core.cons((5),(state_55534[(4)])));

return statearr_55563;
})();
var inst_55450 = fluree.db.util.async.channel_QMARK_(subject);
var state_55534__$1 = state_55534;
if(inst_55450){
var statearr_55564_55614 = state_55534__$1;
(statearr_55564_55614[(1)] = (6));

} else {
var statearr_55565_55615 = state_55534__$1;
(statearr_55565_55615[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55535 === (23))){
var inst_55477 = (state_55534[(7)]);
var inst_55488 = (state_55534[(13)]);
var inst_55465 = (state_55534[(8)]);
var inst_55484 = cljs.core.deref(cache);
var inst_55485 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55486 = [new cljs.core.Keyword(null,"get","get",1683182755),inst_55477,inst_55465];
var inst_55487 = (new cljs.core.PersistentVector(null,3,(5),inst_55485,inst_55486,null));
var inst_55488__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_55484,inst_55487);
var state_55534__$1 = (function (){var statearr_55566 = state_55534;
(statearr_55566[(13)] = inst_55488__$1);

return statearr_55566;
})();
if(cljs.core.truth_(inst_55488__$1)){
var statearr_55567_55616 = state_55534__$1;
(statearr_55567_55616[(1)] = (26));

} else {
var statearr_55568_55617 = state_55534__$1;
(statearr_55568_55617[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55535 === (35))){
var state_55534__$1 = state_55534;
var statearr_55569_55618 = state_55534__$1;
(statearr_55569_55618[(2)] = null);

(statearr_55569_55618[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55535 === (19))){
var inst_55474 = (state_55534[(2)]);
var state_55534__$1 = state_55534;
var statearr_55570_55619 = state_55534__$1;
(statearr_55570_55619[(2)] = inst_55474);

(statearr_55570_55619[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55535 === (11))){
var state_55534__$1 = state_55534;
var statearr_55572_55620 = state_55534__$1;
(statearr_55572_55620[(2)] = pred);

(statearr_55572_55620[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55535 === (9))){
var inst_55453 = (state_55534[(2)]);
var inst_55454 = fluree.db.util.async.throw_err(inst_55453);
var state_55534__$1 = state_55534;
var statearr_55573_55621 = state_55534__$1;
(statearr_55573_55621[(2)] = inst_55454);

(statearr_55573_55621[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55535 === (5))){
var _ = (function (){var statearr_55574 = state_55534;
(statearr_55574[(4)] = cljs.core.rest((state_55534[(4)])));

return statearr_55574;
})();
var state_55534__$1 = state_55534;
var ex55571 = (state_55534__$1[(2)]);
var statearr_55575_55622 = state_55534__$1;
(statearr_55575_55622[(5)] = ex55571);


if((ex55571 instanceof Error)){
var statearr_55576_55623 = state_55534__$1;
(statearr_55576_55623[(1)] = (4));

(statearr_55576_55623[(5)] = null);

} else {
throw ex55571;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55535 === (14))){
var inst_55457 = (state_55534[(9)]);
var inst_55468 = cljs.core.count(inst_55457);
var inst_55469 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_55468);
var state_55534__$1 = state_55534;
if(inst_55469){
var statearr_55577_55624 = state_55534__$1;
(statearr_55577_55624[(1)] = (17));

} else {
var statearr_55578_55625 = state_55534__$1;
(statearr_55578_55625[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55535 === (26))){
var inst_55488 = (state_55534[(13)]);
var state_55534__$1 = state_55534;
var statearr_55579_55626 = state_55534__$1;
(statearr_55579_55626[(2)] = inst_55488);

(statearr_55579_55626[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55535 === (16))){
var inst_55477 = (state_55534[(7)]);
var inst_55478 = (state_55534[(10)]);
var inst_55477__$1 = (state_55534[(2)]);
var inst_55478__$1 = cljs.core.int_QMARK_(inst_55477__$1);
var state_55534__$1 = (function (){var statearr_55580 = state_55534;
(statearr_55580[(7)] = inst_55477__$1);

(statearr_55580[(10)] = inst_55478__$1);

return statearr_55580;
})();
if(inst_55478__$1){
var statearr_55581_55627 = state_55534__$1;
(statearr_55581_55627[(1)] = (20));

} else {
var statearr_55582_55628 = state_55534__$1;
(statearr_55582_55628[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55535 === (30))){
var inst_55477 = (state_55534[(7)]);
var inst_55465 = (state_55534[(8)]);
var inst_55506 = fluree.db.dbfunctions.internal.get_subj_pred(db,inst_55477,inst_55465);
var state_55534__$1 = state_55534;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55534__$1,(33),inst_55506);
} else {
if((state_val_55535 === (10))){
var state_55534__$1 = state_55534;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55534__$1,(13),pred);
} else {
if((state_val_55535 === (18))){
var inst_55457 = (state_55534[(9)]);
var state_55534__$1 = state_55534;
var statearr_55583_55629 = state_55534__$1;
(statearr_55583_55629[(2)] = inst_55457);

(statearr_55583_55629[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55535 === (8))){
var inst_55457 = (state_55534[(2)]);
var inst_55458 = fluree.db.util.async.channel_QMARK_(pred);
var state_55534__$1 = (function (){var statearr_55584 = state_55534;
(statearr_55584[(9)] = inst_55457);

return statearr_55584;
})();
if(inst_55458){
var statearr_55585_55630 = state_55534__$1;
(statearr_55585_55630[(1)] = (10));

} else {
var statearr_55586_55631 = state_55534__$1;
(statearr_55586_55631[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto____0 = (function (){
var statearr_55587 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55587[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto__);

(statearr_55587[(1)] = (1));

return statearr_55587;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto____1 = (function (state_55534){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55534);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55588){var ex__2687__auto__ = e55588;
var statearr_55589_55632 = state_55534;
(statearr_55589_55632[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55534[(4)]))){
var statearr_55590_55633 = state_55534;
(statearr_55590_55633[(1)] = cljs.core.first((state_55534[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55634 = state_55534;
state_55534 = G__55634;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto__ = function(state_55534){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto____1.call(this,state_55534);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55591 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55591[(6)] = c__2706__auto__);

return statearr_55591;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55673){
var state_val_55674 = (state_55673[(1)]);
if((state_val_55674 === (7))){
var inst_55641 = (state_55673[(7)]);
var state_55673__$1 = state_55673;
var statearr_55675_55699 = state_55673__$1;
(statearr_55675_55699[(2)] = inst_55641);

(statearr_55675_55699[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55674 === (1))){
var state_55673__$1 = state_55673;
var statearr_55676_55700 = state_55673__$1;
(statearr_55676_55700[(2)] = null);

(statearr_55676_55700[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55674 === (4))){
var inst_55635 = (state_55673[(2)]);
var state_55673__$1 = state_55673;
var statearr_55677_55701 = state_55673__$1;
(statearr_55677_55701[(2)] = inst_55635);

(statearr_55677_55701[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55674 === (6))){
var inst_55643 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55673__$1 = state_55673;
var statearr_55678_55702 = state_55673__$1;
(statearr_55678_55702[(2)] = inst_55643);

(statearr_55678_55702[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55674 === (3))){
var inst_55671 = (state_55673[(2)]);
var state_55673__$1 = state_55673;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55673__$1,inst_55671);
} else {
if((state_val_55674 === (12))){
var inst_55653 = (state_55673[(2)]);
var inst_55654 = fluree.db.util.async.throw_err(inst_55653);
var inst_55655 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55654,(0),null);
var inst_55656 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55654,(1),null);
var inst_55657 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55658 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55659 = ["?pO","?ctx",inst_55655];
var inst_55660 = cljs.core.PersistentHashMap.fromArrays(inst_55658,inst_55659);
var inst_55661 = ((10) + inst_55656);
var inst_55662 = [inst_55660,inst_55661];
var inst_55663 = (new cljs.core.PersistentVector(null,2,(5),inst_55657,inst_55662,null));
var inst_55664 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55663);
var state_55673__$1 = (function (){var statearr_55679 = state_55673;
(statearr_55679[(8)] = inst_55664);

return statearr_55679;
})();
var statearr_55680_55703 = state_55673__$1;
(statearr_55680_55703[(2)] = inst_55655);

(statearr_55680_55703[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55674 === (2))){
var inst_55641 = (state_55673[(7)]);
var _ = (function (){var statearr_55681 = state_55673;
(statearr_55681[(4)] = cljs.core.cons((5),(state_55673[(4)])));

return statearr_55681;
})();
var inst_55641__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55673__$1 = (function (){var statearr_55682 = state_55673;
(statearr_55682[(7)] = inst_55641__$1);

return statearr_55682;
})();
if(cljs.core.truth_(inst_55641__$1)){
var statearr_55683_55704 = state_55673__$1;
(statearr_55683_55704[(1)] = (6));

} else {
var statearr_55684_55705 = state_55673__$1;
(statearr_55684_55705[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55674 === (11))){
var inst_55668 = (state_55673[(2)]);
var _ = (function (){var statearr_55686 = state_55673;
(statearr_55686[(4)] = cljs.core.rest((state_55673[(4)])));

return statearr_55686;
})();
var state_55673__$1 = state_55673;
var statearr_55687_55706 = state_55673__$1;
(statearr_55687_55706[(2)] = inst_55668);

(statearr_55687_55706[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55674 === (9))){
var inst_55651 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_55673__$1 = state_55673;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55673__$1,(12),inst_55651);
} else {
if((state_val_55674 === (5))){
var _ = (function (){var statearr_55688 = state_55673;
(statearr_55688[(4)] = cljs.core.rest((state_55673[(4)])));

return statearr_55688;
})();
var state_55673__$1 = state_55673;
var ex55685 = (state_55673__$1[(2)]);
var statearr_55689_55707 = state_55673__$1;
(statearr_55689_55707[(5)] = ex55685);


if((ex55685 instanceof Error)){
var statearr_55690_55708 = state_55673__$1;
(statearr_55690_55708[(1)] = (4));

(statearr_55690_55708[(5)] = null);

} else {
throw ex55685;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55674 === (10))){
var inst_55666 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_55673__$1 = state_55673;
var statearr_55691_55709 = state_55673__$1;
(statearr_55691_55709[(2)] = inst_55666);

(statearr_55691_55709[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55674 === (8))){
var inst_55646 = (state_55673[(2)]);
var state_55673__$1 = state_55673;
if(cljs.core.truth_(inst_55646)){
var statearr_55692_55710 = state_55673__$1;
(statearr_55692_55710[(1)] = (9));

} else {
var statearr_55693_55711 = state_55673__$1;
(statearr_55693_55711[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto____0 = (function (){
var statearr_55694 = [null,null,null,null,null,null,null,null,null];
(statearr_55694[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto__);

(statearr_55694[(1)] = (1));

return statearr_55694;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto____1 = (function (state_55673){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55673);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55695){var ex__2687__auto__ = e55695;
var statearr_55696_55712 = state_55673;
(statearr_55696_55712[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55673[(4)]))){
var statearr_55697_55713 = state_55673;
(statearr_55697_55713[(1)] = cljs.core.first((state_55673[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55714 = state_55673;
state_55673 = G__55714;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto__ = function(state_55673){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto____1.call(this,state_55673);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55698 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55698[(6)] = c__2706__auto__);

return statearr_55698;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Used to get-all values in a nested result set, or also can follow a subject down the provided path and return a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55783){
var state_val_55784 = (state_55783[(1)]);
if((state_val_55784 === (7))){
var state_55783__$1 = state_55783;
var statearr_55785_55823 = state_55783__$1;
(statearr_55785_55823[(2)] = subject);

(statearr_55785_55823[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55784 === (20))){
var inst_55751 = (state_55783[(7)]);
var inst_55739 = (state_55783[(8)]);
var inst_55754 = fluree.db.dbfunctions.internal.follow_subject(_QMARK_ctx,inst_55751,inst_55739);
var state_55783__$1 = state_55783;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55783__$1,(23),inst_55754);
} else {
if((state_val_55784 === (1))){
var state_55783__$1 = state_55783;
var statearr_55786_55824 = state_55783__$1;
(statearr_55786_55824[(2)] = null);

(statearr_55786_55824[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55784 === (4))){
var inst_55715 = (state_55783[(2)]);
var state_55783__$1 = state_55783;
var statearr_55787_55825 = state_55783__$1;
(statearr_55787_55825[(2)] = inst_55715);

(statearr_55787_55825[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55784 === (15))){
var inst_55731 = (state_55783[(9)]);
var state_55783__$1 = state_55783;
var statearr_55788_55826 = state_55783__$1;
(statearr_55788_55826[(2)] = inst_55731);

(statearr_55788_55826[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55784 === (21))){
var inst_55751 = (state_55783[(7)]);
var inst_55739 = (state_55783[(8)]);
var inst_55759 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55760 = fluree.db.dbfunctions.internal.get_all(inst_55751,inst_55739);
var inst_55761 = cljs.core.count(inst_55739);
var inst_55762 = ((9) + inst_55761);
var inst_55763 = [inst_55760,inst_55762];
var inst_55764 = (new cljs.core.PersistentVector(null,2,(5),inst_55759,inst_55763,null));
var state_55783__$1 = state_55783;
var statearr_55789_55827 = state_55783__$1;
(statearr_55789_55827[(2)] = inst_55764);

(statearr_55789_55827[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55784 === (13))){
var inst_55735 = (state_55783[(2)]);
var inst_55736 = fluree.db.util.async.throw_err(inst_55735);
var state_55783__$1 = state_55783;
var statearr_55790_55828 = state_55783__$1;
(statearr_55790_55828[(2)] = inst_55736);

(statearr_55790_55828[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55784 === (22))){
var inst_55731 = (state_55783[(9)]);
var inst_55739 = (state_55783[(8)]);
var inst_55766 = (state_55783[(2)]);
var inst_55767 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55766,(0),null);
var inst_55768 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55766,(1),null);
var inst_55769 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55770 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55771 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55772 = [inst_55731,inst_55739];
var inst_55773 = (new cljs.core.PersistentVector(null,2,(5),inst_55771,inst_55772,null));
var inst_55774 = ["get-all",inst_55773,inst_55767];
var inst_55775 = cljs.core.PersistentHashMap.fromArrays(inst_55770,inst_55774);
var inst_55776 = [inst_55775,inst_55768];
var inst_55777 = (new cljs.core.PersistentVector(null,2,(5),inst_55769,inst_55776,null));
var inst_55778 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55777);
var _ = (function (){var statearr_55791 = state_55783;
(statearr_55791[(4)] = cljs.core.rest((state_55783[(4)])));

return statearr_55791;
})();
var state_55783__$1 = (function (){var statearr_55792 = state_55783;
(statearr_55792[(10)] = inst_55778);

return statearr_55792;
})();
var statearr_55793_55829 = state_55783__$1;
(statearr_55793_55829[(2)] = inst_55767);

(statearr_55793_55829[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55784 === (6))){
var state_55783__$1 = state_55783;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55783__$1,(9),subject);
} else {
if((state_val_55784 === (17))){
var inst_55731 = (state_55783[(9)]);
var inst_55745 = cljs.core.first(inst_55731);
var state_55783__$1 = state_55783;
var statearr_55794_55830 = state_55783__$1;
(statearr_55794_55830[(2)] = inst_55745);

(statearr_55794_55830[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55784 === (3))){
var inst_55781 = (state_55783[(2)]);
var state_55783__$1 = state_55783;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55783__$1,inst_55781);
} else {
if((state_val_55784 === (12))){
var inst_55731 = (state_55783[(9)]);
var inst_55739 = (state_55783[(2)]);
var inst_55740 = cljs.core.vector_QMARK_(inst_55731);
var state_55783__$1 = (function (){var statearr_55795 = state_55783;
(statearr_55795[(8)] = inst_55739);

return statearr_55795;
})();
if(inst_55740){
var statearr_55796_55831 = state_55783__$1;
(statearr_55796_55831[(1)] = (14));

} else {
var statearr_55797_55832 = state_55783__$1;
(statearr_55797_55832[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55784 === (2))){
var _ = (function (){var statearr_55798 = state_55783;
(statearr_55798[(4)] = cljs.core.cons((5),(state_55783[(4)])));

return statearr_55798;
})();
var inst_55724 = fluree.db.util.async.channel_QMARK_(subject);
var state_55783__$1 = state_55783;
if(inst_55724){
var statearr_55799_55833 = state_55783__$1;
(statearr_55799_55833[(1)] = (6));

} else {
var statearr_55800_55834 = state_55783__$1;
(statearr_55800_55834[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55784 === (23))){
var inst_55756 = (state_55783[(2)]);
var inst_55757 = fluree.db.util.async.throw_err(inst_55756);
var state_55783__$1 = state_55783;
var statearr_55801_55835 = state_55783__$1;
(statearr_55801_55835[(2)] = inst_55757);

(statearr_55801_55835[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55784 === (19))){
var inst_55748 = (state_55783[(2)]);
var state_55783__$1 = state_55783;
var statearr_55802_55836 = state_55783__$1;
(statearr_55802_55836[(2)] = inst_55748);

(statearr_55802_55836[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55784 === (11))){
var state_55783__$1 = state_55783;
var statearr_55804_55837 = state_55783__$1;
(statearr_55804_55837[(2)] = path);

(statearr_55804_55837[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55784 === (9))){
var inst_55727 = (state_55783[(2)]);
var inst_55728 = fluree.db.util.async.throw_err(inst_55727);
var state_55783__$1 = state_55783;
var statearr_55805_55838 = state_55783__$1;
(statearr_55805_55838[(2)] = inst_55728);

(statearr_55805_55838[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55784 === (5))){
var _ = (function (){var statearr_55806 = state_55783;
(statearr_55806[(4)] = cljs.core.rest((state_55783[(4)])));

return statearr_55806;
})();
var state_55783__$1 = state_55783;
var ex55803 = (state_55783__$1[(2)]);
var statearr_55807_55839 = state_55783__$1;
(statearr_55807_55839[(5)] = ex55803);


if((ex55803 instanceof Error)){
var statearr_55808_55840 = state_55783__$1;
(statearr_55808_55840[(1)] = (4));

(statearr_55808_55840[(5)] = null);

} else {
throw ex55803;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55784 === (14))){
var inst_55731 = (state_55783[(9)]);
var inst_55742 = cljs.core.count(inst_55731);
var inst_55743 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_55742);
var state_55783__$1 = state_55783;
if(inst_55743){
var statearr_55809_55841 = state_55783__$1;
(statearr_55809_55841[(1)] = (17));

} else {
var statearr_55810_55842 = state_55783__$1;
(statearr_55810_55842[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55784 === (16))){
var inst_55751 = (state_55783[(7)]);
var inst_55751__$1 = (state_55783[(2)]);
var inst_55752 = cljs.core.int_QMARK_(inst_55751__$1);
var state_55783__$1 = (function (){var statearr_55811 = state_55783;
(statearr_55811[(7)] = inst_55751__$1);

return statearr_55811;
})();
if(inst_55752){
var statearr_55812_55843 = state_55783__$1;
(statearr_55812_55843[(1)] = (20));

} else {
var statearr_55813_55844 = state_55783__$1;
(statearr_55813_55844[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55784 === (10))){
var state_55783__$1 = state_55783;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55783__$1,(13),path);
} else {
if((state_val_55784 === (18))){
var inst_55731 = (state_55783[(9)]);
var state_55783__$1 = state_55783;
var statearr_55814_55845 = state_55783__$1;
(statearr_55814_55845[(2)] = inst_55731);

(statearr_55814_55845[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55784 === (8))){
var inst_55731 = (state_55783[(2)]);
var inst_55732 = fluree.db.util.async.channel_QMARK_(path);
var state_55783__$1 = (function (){var statearr_55815 = state_55783;
(statearr_55815[(9)] = inst_55731);

return statearr_55815;
})();
if(inst_55732){
var statearr_55816_55846 = state_55783__$1;
(statearr_55816_55846[(1)] = (10));

} else {
var statearr_55817_55847 = state_55783__$1;
(statearr_55817_55847[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto____0 = (function (){
var statearr_55818 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_55818[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto__);

(statearr_55818[(1)] = (1));

return statearr_55818;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto____1 = (function (state_55783){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55783);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55819){var ex__2687__auto__ = e55819;
var statearr_55820_55848 = state_55783;
(statearr_55820_55848[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55783[(4)]))){
var statearr_55821_55849 = state_55783;
(statearr_55821_55849[(1)] = cljs.core.first((state_55783[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55850 = state_55783;
state_55783 = G__55850;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto__ = function(state_55783){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto____1.call(this,state_55783);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55822 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55822[(6)] = c__2706__auto__);

return statearr_55822;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55889){
var state_val_55890 = (state_55889[(1)]);
if((state_val_55890 === (7))){
var state_55889__$1 = state_55889;
var statearr_55891_55915 = state_55889__$1;
(statearr_55891_55915[(2)] = subject);

(statearr_55891_55915[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55890 === (1))){
var state_55889__$1 = state_55889;
var statearr_55892_55916 = state_55889__$1;
(statearr_55892_55916[(2)] = null);

(statearr_55892_55916[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55890 === (4))){
var inst_55851 = (state_55889[(2)]);
var state_55889__$1 = state_55889;
var statearr_55893_55917 = state_55889__$1;
(statearr_55893_55917[(2)] = inst_55851);

(statearr_55893_55917[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55890 === (13))){
var inst_55868 = (state_55889[(2)]);
var inst_55869 = fluree.db.util.async.throw_err(inst_55868);
var state_55889__$1 = state_55889;
var statearr_55894_55918 = state_55889__$1;
(statearr_55894_55918[(2)] = inst_55869);

(statearr_55894_55918[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55890 === (6))){
var state_55889__$1 = state_55889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55889__$1,(9),subject);
} else {
if((state_val_55890 === (3))){
var inst_55887 = (state_55889[(2)]);
var state_55889__$1 = state_55889;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55889__$1,inst_55887);
} else {
if((state_val_55890 === (12))){
var inst_55864 = (state_55889[(7)]);
var inst_55872 = (state_55889[(2)]);
var inst_55873 = fluree.db.dbfunctions.internal.get_in(inst_55864,inst_55872);
var inst_55874 = cljs.core.count(inst_55872);
var inst_55875 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55876 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55877 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55878 = [inst_55864,inst_55872];
var inst_55879 = (new cljs.core.PersistentVector(null,2,(5),inst_55877,inst_55878,null));
var inst_55880 = ["get-in",inst_55879,inst_55873];
var inst_55881 = cljs.core.PersistentHashMap.fromArrays(inst_55876,inst_55880);
var inst_55882 = [inst_55881,inst_55874];
var inst_55883 = (new cljs.core.PersistentVector(null,2,(5),inst_55875,inst_55882,null));
var inst_55884 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55883);
var _ = (function (){var statearr_55895 = state_55889;
(statearr_55895[(4)] = cljs.core.rest((state_55889[(4)])));

return statearr_55895;
})();
var state_55889__$1 = (function (){var statearr_55896 = state_55889;
(statearr_55896[(8)] = inst_55884);

return statearr_55896;
})();
var statearr_55897_55919 = state_55889__$1;
(statearr_55897_55919[(2)] = inst_55873);

(statearr_55897_55919[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55890 === (2))){
var _ = (function (){var statearr_55898 = state_55889;
(statearr_55898[(4)] = cljs.core.cons((5),(state_55889[(4)])));

return statearr_55898;
})();
var inst_55857 = fluree.db.util.async.channel_QMARK_(subject);
var state_55889__$1 = state_55889;
if(inst_55857){
var statearr_55899_55920 = state_55889__$1;
(statearr_55899_55920[(1)] = (6));

} else {
var statearr_55900_55921 = state_55889__$1;
(statearr_55900_55921[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55890 === (11))){
var state_55889__$1 = state_55889;
var statearr_55902_55922 = state_55889__$1;
(statearr_55902_55922[(2)] = path);

(statearr_55902_55922[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55890 === (9))){
var inst_55860 = (state_55889[(2)]);
var inst_55861 = fluree.db.util.async.throw_err(inst_55860);
var state_55889__$1 = state_55889;
var statearr_55903_55923 = state_55889__$1;
(statearr_55903_55923[(2)] = inst_55861);

(statearr_55903_55923[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55890 === (5))){
var _ = (function (){var statearr_55904 = state_55889;
(statearr_55904[(4)] = cljs.core.rest((state_55889[(4)])));

return statearr_55904;
})();
var state_55889__$1 = state_55889;
var ex55901 = (state_55889__$1[(2)]);
var statearr_55905_55924 = state_55889__$1;
(statearr_55905_55924[(5)] = ex55901);


if((ex55901 instanceof Error)){
var statearr_55906_55925 = state_55889__$1;
(statearr_55906_55925[(1)] = (4));

(statearr_55906_55925[(5)] = null);

} else {
throw ex55901;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55890 === (10))){
var state_55889__$1 = state_55889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55889__$1,(13),path);
} else {
if((state_val_55890 === (8))){
var inst_55864 = (state_55889[(2)]);
var inst_55865 = fluree.db.util.async.channel_QMARK_(path);
var state_55889__$1 = (function (){var statearr_55907 = state_55889;
(statearr_55907[(7)] = inst_55864);

return statearr_55907;
})();
if(inst_55865){
var statearr_55908_55926 = state_55889__$1;
(statearr_55908_55926[(1)] = (10));

} else {
var statearr_55909_55927 = state_55889__$1;
(statearr_55909_55927[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto____0 = (function (){
var statearr_55910 = [null,null,null,null,null,null,null,null,null];
(statearr_55910[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto__);

(statearr_55910[(1)] = (1));

return statearr_55910;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto____1 = (function (state_55889){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55889);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e55911){var ex__2687__auto__ = e55911;
var statearr_55912_55928 = state_55889;
(statearr_55912_55928[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55889[(4)]))){
var statearr_55913_55929 = state_55889;
(statearr_55913_55929[(1)] = cljs.core.first((state_55889[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55930 = state_55889;
state_55889 = G__55930;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto__ = function(state_55889){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto____1.call(this,state_55889);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_55914 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_55914[(6)] = c__2706__auto__);

return statearr_55914;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns a value from the user's context if set. Provide the key or key sequence.
 */
fluree.db.dbfunctions.fns.ctx = (function fluree$db$dbfunctions$fns$ctx(p__55931,key_or_ks){
var map__55932 = p__55931;
var map__55932__$1 = cljs.core.__destructure_map(map__55932);
var _QMARK_ctx = map__55932__$1;
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55932__$1,new cljs.core.Keyword(null,"db","db",993250759));
if(cljs.core.sequential_QMARK_(key_or_ks)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ctx","ctx",-493610118).cljs$core$IFn$_invoke$arity$1(db),key_or_ks);
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ctx","ctx",-493610118).cljs$core$IFn$_invoke$arity$1(db),key_or_ks);
}
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_55977){
var state_val_55978 = (state_55977[(1)]);
if((state_val_55978 === (7))){
var state_55977__$1 = state_55977;
var statearr_55979_56008 = state_55977__$1;
(statearr_55979_56008[(2)] = coll);

(statearr_55979_56008[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55978 === (1))){
var state_55977__$1 = state_55977;
var statearr_55980_56009 = state_55977__$1;
(statearr_55980_56009[(2)] = null);

(statearr_55980_56009[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55978 === (4))){
var inst_55933 = (state_55977[(2)]);
var state_55977__$1 = state_55977;
var statearr_55981_56010 = state_55977__$1;
(statearr_55981_56010[(2)] = inst_55933);

(statearr_55981_56010[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55978 === (15))){
var inst_55953 = (state_55977[(7)]);
var inst_55961 = (state_55977[(2)]);
var inst_55962 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_55953,inst_55961);
var inst_55963 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55964 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55965 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55966 = [inst_55953,inst_55961];
var inst_55967 = (new cljs.core.PersistentVector(null,2,(5),inst_55965,inst_55966,null));
var inst_55968 = ["contains?",inst_55967,inst_55962];
var inst_55969 = cljs.core.PersistentHashMap.fromArrays(inst_55964,inst_55968);
var inst_55970 = [inst_55969,(10)];
var inst_55971 = (new cljs.core.PersistentVector(null,2,(5),inst_55963,inst_55970,null));
var inst_55972 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55971);
var _ = (function (){var statearr_55982 = state_55977;
(statearr_55982[(4)] = cljs.core.rest((state_55977[(4)])));

return statearr_55982;
})();
var state_55977__$1 = (function (){var statearr_55983 = state_55977;
(statearr_55983[(8)] = inst_55972);

return statearr_55983;
})();
var statearr_55984_56011 = state_55977__$1;
(statearr_55984_56011[(2)] = inst_55962);

(statearr_55984_56011[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55978 === (13))){
var state_55977__$1 = state_55977;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55977__$1,(16),key);
} else {
if((state_val_55978 === (6))){
var state_55977__$1 = state_55977;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55977__$1,(9),coll);
} else {
if((state_val_55978 === (3))){
var inst_55975 = (state_55977[(2)]);
var state_55977__$1 = state_55977;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55977__$1,inst_55975);
} else {
if((state_val_55978 === (12))){
var inst_55953 = (state_55977[(2)]);
var inst_55954 = fluree.db.util.async.channel_QMARK_(key);
var state_55977__$1 = (function (){var statearr_55985 = state_55977;
(statearr_55985[(7)] = inst_55953);

return statearr_55985;
})();
if(inst_55954){
var statearr_55986_56012 = state_55977__$1;
(statearr_55986_56012[(1)] = (13));

} else {
var statearr_55987_56013 = state_55977__$1;
(statearr_55987_56013[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55978 === (2))){
var _ = (function (){var statearr_55988 = state_55977;
(statearr_55988[(4)] = cljs.core.cons((5),(state_55977[(4)])));

return statearr_55988;
})();
var inst_55939 = fluree.db.util.async.channel_QMARK_(coll);
var state_55977__$1 = state_55977;
if(inst_55939){
var statearr_55989_56014 = state_55977__$1;
(statearr_55989_56014[(1)] = (6));

} else {
var statearr_55990_56015 = state_55977__$1;
(statearr_55990_56015[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55978 === (11))){
var inst_55946 = (state_55977[(9)]);
var inst_55950 = cljs.core.flatten(inst_55946);
var inst_55951 = cljs.core.set(inst_55950);
var state_55977__$1 = state_55977;
var statearr_55992_56016 = state_55977__$1;
(statearr_55992_56016[(2)] = inst_55951);

(statearr_55992_56016[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55978 === (9))){
var inst_55942 = (state_55977[(2)]);
var inst_55943 = fluree.db.util.async.throw_err(inst_55942);
var state_55977__$1 = state_55977;
var statearr_55993_56017 = state_55977__$1;
(statearr_55993_56017[(2)] = inst_55943);

(statearr_55993_56017[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55978 === (5))){
var _ = (function (){var statearr_55994 = state_55977;
(statearr_55994[(4)] = cljs.core.rest((state_55977[(4)])));

return statearr_55994;
})();
var state_55977__$1 = state_55977;
var ex55991 = (state_55977__$1[(2)]);
var statearr_55995_56018 = state_55977__$1;
(statearr_55995_56018[(5)] = ex55991);


if((ex55991 instanceof Error)){
var statearr_55996_56019 = state_55977__$1;
(statearr_55996_56019[(1)] = (4));

(statearr_55996_56019[(5)] = null);

} else {
throw ex55991;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55978 === (14))){
var state_55977__$1 = state_55977;
var statearr_55997_56020 = state_55977__$1;
(statearr_55997_56020[(2)] = key);

(statearr_55997_56020[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55978 === (16))){
var inst_55957 = (state_55977[(2)]);
var inst_55958 = fluree.db.util.async.throw_err(inst_55957);
var state_55977__$1 = state_55977;
var statearr_55998_56021 = state_55977__$1;
(statearr_55998_56021[(2)] = inst_55958);

(statearr_55998_56021[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55978 === (10))){
var inst_55946 = (state_55977[(9)]);
var state_55977__$1 = state_55977;
var statearr_55999_56022 = state_55977__$1;
(statearr_55999_56022[(2)] = inst_55946);

(statearr_55999_56022[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55978 === (8))){
var inst_55946 = (state_55977[(9)]);
var inst_55946__$1 = (state_55977[(2)]);
var inst_55947 = cljs.core.set_QMARK_(inst_55946__$1);
var state_55977__$1 = (function (){var statearr_56000 = state_55977;
(statearr_56000[(9)] = inst_55946__$1);

return statearr_56000;
})();
if(inst_55947){
var statearr_56001_56023 = state_55977__$1;
(statearr_56001_56023[(1)] = (10));

} else {
var statearr_56002_56024 = state_55977__$1;
(statearr_56002_56024[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_56003 = [null,null,null,null,null,null,null,null,null,null];
(statearr_56003[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto__);

(statearr_56003[(1)] = (1));

return statearr_56003;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto____1 = (function (state_55977){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_55977);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56004){var ex__2687__auto__ = e56004;
var statearr_56005_56025 = state_55977;
(statearr_56005_56025[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_55977[(4)]))){
var statearr_56006_56026 = state_55977;
(statearr_56006_56026[(1)] = cljs.core.first((state_55977[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56027 = state_55977;
state_55977 = G__56027;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto__ = function(state_55977){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto____1.call(this,state_55977);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56007 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56007[(6)] = c__2706__auto__);

return statearr_56007;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56099 = arguments.length;
var i__5770__auto___56100 = (0);
while(true){
if((i__5770__auto___56100 < len__5769__auto___56099)){
args__5775__auto__.push((arguments[i__5770__auto___56100]));

var G__56101 = (i__5770__auto___56100 + (1));
i__5770__auto___56100 = G__56101;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56073){
var state_val_56074 = (state_56073[(1)]);
if((state_val_56074 === (7))){
var inst_56039 = (state_56073[(7)]);
var inst_56043 = cljs.core.first(inst_56039);
var inst_56044 = cljs.core.coll_QMARK_(inst_56043);
var state_56073__$1 = state_56073;
var statearr_56075_56102 = state_56073__$1;
(statearr_56075_56102[(2)] = inst_56044);

(statearr_56075_56102[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56074 === (1))){
var state_56073__$1 = state_56073;
var statearr_56076_56103 = state_56073__$1;
(statearr_56076_56103[(2)] = null);

(statearr_56076_56103[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56074 === (4))){
var inst_56030 = (state_56073[(2)]);
var state_56073__$1 = state_56073;
var statearr_56077_56104 = state_56073__$1;
(statearr_56077_56104[(2)] = inst_56030);

(statearr_56077_56104[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56074 === (6))){
var inst_56039 = (state_56073[(7)]);
var inst_56041 = (state_56073[(8)]);
var inst_56038 = (state_56073[(2)]);
var inst_56039__$1 = fluree.db.util.async.throw_err(inst_56038);
var inst_56040 = cljs.core.count(inst_56039__$1);
var inst_56041__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_56040);
var state_56073__$1 = (function (){var statearr_56078 = state_56073;
(statearr_56078[(7)] = inst_56039__$1);

(statearr_56078[(8)] = inst_56041__$1);

return statearr_56078;
})();
if(inst_56041__$1){
var statearr_56079_56105 = state_56073__$1;
(statearr_56079_56105[(1)] = (7));

} else {
var statearr_56080_56106 = state_56073__$1;
(statearr_56080_56106[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56074 === (3))){
var inst_56071 = (state_56073[(2)]);
var state_56073__$1 = state_56073;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56073__$1,inst_56071);
} else {
if((state_val_56074 === (12))){
var inst_56052 = (state_56073[(2)]);
var inst_56053 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_56052);
var inst_56054 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56055 = [inst_56052];
var inst_56056 = (new cljs.core.PersistentVector(null,1,(5),inst_56054,inst_56055,null));
var inst_56057 = cljs.core.count(inst_56056);
var inst_56058 = ((9) + inst_56057);
var inst_56059 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56060 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56061 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56062 = [inst_56052];
var inst_56063 = (new cljs.core.PersistentVector(null,1,(5),inst_56061,inst_56062,null));
var inst_56064 = ["hash-set",inst_56063,inst_56053];
var inst_56065 = cljs.core.PersistentHashMap.fromArrays(inst_56060,inst_56064);
var inst_56066 = [inst_56065,inst_56058];
var inst_56067 = (new cljs.core.PersistentVector(null,2,(5),inst_56059,inst_56066,null));
var inst_56068 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56067);
var _ = (function (){var statearr_56081 = state_56073;
(statearr_56081[(4)] = cljs.core.rest((state_56073[(4)])));

return statearr_56081;
})();
var state_56073__$1 = (function (){var statearr_56082 = state_56073;
(statearr_56082[(9)] = inst_56068);

return statearr_56082;
})();
var statearr_56083_56107 = state_56073__$1;
(statearr_56083_56107[(2)] = inst_56053);

(statearr_56083_56107[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56074 === (2))){
var _ = (function (){var statearr_56084 = state_56073;
(statearr_56084[(4)] = cljs.core.cons((5),(state_56073[(4)])));

return statearr_56084;
})();
var inst_56036 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56073__$1 = state_56073;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56073__$1,(6),inst_56036);
} else {
if((state_val_56074 === (11))){
var inst_56039 = (state_56073[(7)]);
var state_56073__$1 = state_56073;
var statearr_56086_56108 = state_56073__$1;
(statearr_56086_56108[(2)] = inst_56039);

(statearr_56086_56108[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56074 === (9))){
var inst_56047 = (state_56073[(2)]);
var state_56073__$1 = state_56073;
if(cljs.core.truth_(inst_56047)){
var statearr_56087_56109 = state_56073__$1;
(statearr_56087_56109[(1)] = (10));

} else {
var statearr_56088_56110 = state_56073__$1;
(statearr_56088_56110[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56074 === (5))){
var _ = (function (){var statearr_56089 = state_56073;
(statearr_56089[(4)] = cljs.core.rest((state_56073[(4)])));

return statearr_56089;
})();
var state_56073__$1 = state_56073;
var ex56085 = (state_56073__$1[(2)]);
var statearr_56090_56111 = state_56073__$1;
(statearr_56090_56111[(5)] = ex56085);


if((ex56085 instanceof Error)){
var statearr_56091_56112 = state_56073__$1;
(statearr_56091_56112[(1)] = (4));

(statearr_56091_56112[(5)] = null);

} else {
throw ex56085;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56074 === (10))){
var inst_56039 = (state_56073[(7)]);
var inst_56049 = cljs.core.first(inst_56039);
var state_56073__$1 = state_56073;
var statearr_56092_56113 = state_56073__$1;
(statearr_56092_56113[(2)] = inst_56049);

(statearr_56092_56113[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56074 === (8))){
var inst_56041 = (state_56073[(8)]);
var state_56073__$1 = state_56073;
var statearr_56093_56114 = state_56073__$1;
(statearr_56093_56114[(2)] = inst_56041);

(statearr_56093_56114[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_56094 = [null,null,null,null,null,null,null,null,null,null];
(statearr_56094[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_56094[(1)] = (1));

return statearr_56094;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_56073){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56073);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56095){var ex__2687__auto__ = e56095;
var statearr_56096_56115 = state_56073;
(statearr_56096_56115[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56073[(4)]))){
var statearr_56097_56116 = state_56073;
(statearr_56097_56116[(1)] = cljs.core.first((state_56073[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56117 = state_56073;
state_56073 = G__56117;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_56073){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_56073);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56098 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56098[(6)] = c__2706__auto__);

return statearr_56098;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq56028){
var G__56029 = cljs.core.first(seq56028);
var seq56028__$1 = cljs.core.next(seq56028);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56029,seq56028__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56167 = arguments.length;
var i__5770__auto___56168 = (0);
while(true){
if((i__5770__auto___56168 < len__5769__auto___56167)){
args__5775__auto__.push((arguments[i__5770__auto___56168]));

var G__56169 = (i__5770__auto___56168 + (1));
i__5770__auto___56168 = G__56169;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56150){
var state_val_56151 = (state_56150[(1)]);
if((state_val_56151 === (1))){
var state_56150__$1 = state_56150;
var statearr_56152_56170 = state_56150__$1;
(statearr_56152_56170[(2)] = null);

(statearr_56152_56170[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56151 === (2))){
var _ = (function (){var statearr_56153 = state_56150;
(statearr_56153[(4)] = cljs.core.cons((5),(state_56150[(4)])));

return statearr_56153;
})();
var inst_56126 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56150__$1 = state_56150;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56150__$1,(6),inst_56126);
} else {
if((state_val_56151 === (3))){
var inst_56148 = (state_56150[(2)]);
var state_56150__$1 = state_56150;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56150__$1,inst_56148);
} else {
if((state_val_56151 === (4))){
var inst_56120 = (state_56150[(2)]);
var state_56150__$1 = state_56150;
var statearr_56155_56171 = state_56150__$1;
(statearr_56155_56171[(2)] = inst_56120);

(statearr_56155_56171[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56151 === (5))){
var _ = (function (){var statearr_56156 = state_56150;
(statearr_56156[(4)] = cljs.core.rest((state_56150[(4)])));

return statearr_56156;
})();
var state_56150__$1 = state_56150;
var ex56154 = (state_56150__$1[(2)]);
var statearr_56157_56172 = state_56150__$1;
(statearr_56157_56172[(5)] = ex56154);


if((ex56154 instanceof Error)){
var statearr_56158_56173 = state_56150__$1;
(statearr_56158_56173[(1)] = (4));

(statearr_56158_56173[(5)] = null);

} else {
throw ex56154;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56151 === (6))){
var inst_56128 = (state_56150[(2)]);
var inst_56129 = fluree.db.util.async.throw_err(inst_56128);
var inst_56130 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_56129);
var inst_56131 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56132 = [inst_56129];
var inst_56133 = (new cljs.core.PersistentVector(null,1,(5),inst_56131,inst_56132,null));
var inst_56134 = cljs.core.count(inst_56133);
var inst_56135 = ((9) + inst_56134);
var inst_56136 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56137 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56138 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56139 = [inst_56129];
var inst_56140 = (new cljs.core.PersistentVector(null,1,(5),inst_56138,inst_56139,null));
var inst_56141 = ["==",inst_56140,inst_56130];
var inst_56142 = cljs.core.PersistentHashMap.fromArrays(inst_56137,inst_56141);
var inst_56143 = [inst_56142,inst_56135];
var inst_56144 = (new cljs.core.PersistentVector(null,2,(5),inst_56136,inst_56143,null));
var inst_56145 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56144);
var _ = (function (){var statearr_56159 = state_56150;
(statearr_56159[(4)] = cljs.core.rest((state_56150[(4)])));

return statearr_56159;
})();
var state_56150__$1 = (function (){var statearr_56160 = state_56150;
(statearr_56160[(7)] = inst_56145);

return statearr_56160;
})();
var statearr_56161_56174 = state_56150__$1;
(statearr_56161_56174[(2)] = inst_56130);

(statearr_56161_56174[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_56162 = [null,null,null,null,null,null,null,null];
(statearr_56162[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_56162[(1)] = (1));

return statearr_56162;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_56150){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56150);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56163){var ex__2687__auto__ = e56163;
var statearr_56164_56175 = state_56150;
(statearr_56164_56175[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56150[(4)]))){
var statearr_56165_56176 = state_56150;
(statearr_56165_56176[(1)] = cljs.core.first((state_56150[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56177 = state_56150;
state_56150 = G__56177;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_56150){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_56150);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56166 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56166[(6)] = c__2706__auto__);

return statearr_56166;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq56118){
var G__56119 = cljs.core.first(seq56118);
var seq56118__$1 = cljs.core.next(seq56118);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56119,seq56118__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56227 = arguments.length;
var i__5770__auto___56228 = (0);
while(true){
if((i__5770__auto___56228 < len__5769__auto___56227)){
args__5775__auto__.push((arguments[i__5770__auto___56228]));

var G__56229 = (i__5770__auto___56228 + (1));
i__5770__auto___56228 = G__56229;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56210){
var state_val_56211 = (state_56210[(1)]);
if((state_val_56211 === (1))){
var state_56210__$1 = state_56210;
var statearr_56212_56230 = state_56210__$1;
(statearr_56212_56230[(2)] = null);

(statearr_56212_56230[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56211 === (2))){
var _ = (function (){var statearr_56213 = state_56210;
(statearr_56213[(4)] = cljs.core.cons((5),(state_56210[(4)])));

return statearr_56213;
})();
var inst_56186 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56210__$1 = state_56210;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56210__$1,(6),inst_56186);
} else {
if((state_val_56211 === (3))){
var inst_56208 = (state_56210[(2)]);
var state_56210__$1 = state_56210;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56210__$1,inst_56208);
} else {
if((state_val_56211 === (4))){
var inst_56180 = (state_56210[(2)]);
var state_56210__$1 = state_56210;
var statearr_56215_56231 = state_56210__$1;
(statearr_56215_56231[(2)] = inst_56180);

(statearr_56215_56231[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56211 === (5))){
var _ = (function (){var statearr_56216 = state_56210;
(statearr_56216[(4)] = cljs.core.rest((state_56210[(4)])));

return statearr_56216;
})();
var state_56210__$1 = state_56210;
var ex56214 = (state_56210__$1[(2)]);
var statearr_56217_56232 = state_56210__$1;
(statearr_56217_56232[(5)] = ex56214);


if((ex56214 instanceof Error)){
var statearr_56218_56233 = state_56210__$1;
(statearr_56218_56233[(1)] = (4));

(statearr_56218_56233[(5)] = null);

} else {
throw ex56214;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56211 === (6))){
var inst_56188 = (state_56210[(2)]);
var inst_56189 = fluree.db.util.async.throw_err(inst_56188);
var inst_56190 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_56189);
var inst_56191 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56192 = [inst_56189];
var inst_56193 = (new cljs.core.PersistentVector(null,1,(5),inst_56191,inst_56192,null));
var inst_56194 = cljs.core.count(inst_56193);
var inst_56195 = ((9) + inst_56194);
var inst_56196 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56197 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56198 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56199 = [inst_56189];
var inst_56200 = (new cljs.core.PersistentVector(null,1,(5),inst_56198,inst_56199,null));
var inst_56201 = [">",inst_56200,inst_56190];
var inst_56202 = cljs.core.PersistentHashMap.fromArrays(inst_56197,inst_56201);
var inst_56203 = [inst_56202,inst_56195];
var inst_56204 = (new cljs.core.PersistentVector(null,2,(5),inst_56196,inst_56203,null));
var inst_56205 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56204);
var _ = (function (){var statearr_56219 = state_56210;
(statearr_56219[(4)] = cljs.core.rest((state_56210[(4)])));

return statearr_56219;
})();
var state_56210__$1 = (function (){var statearr_56220 = state_56210;
(statearr_56220[(7)] = inst_56205);

return statearr_56220;
})();
var statearr_56221_56234 = state_56210__$1;
(statearr_56221_56234[(2)] = inst_56190);

(statearr_56221_56234[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_56222 = [null,null,null,null,null,null,null,null];
(statearr_56222[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_56222[(1)] = (1));

return statearr_56222;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_56210){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56210);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56223){var ex__2687__auto__ = e56223;
var statearr_56224_56235 = state_56210;
(statearr_56224_56235[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56210[(4)]))){
var statearr_56225_56236 = state_56210;
(statearr_56225_56236[(1)] = cljs.core.first((state_56210[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56237 = state_56210;
state_56210 = G__56237;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_56210){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_56210);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56226 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56226[(6)] = c__2706__auto__);

return statearr_56226;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq56178){
var G__56179 = cljs.core.first(seq56178);
var seq56178__$1 = cljs.core.next(seq56178);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56179,seq56178__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56287 = arguments.length;
var i__5770__auto___56288 = (0);
while(true){
if((i__5770__auto___56288 < len__5769__auto___56287)){
args__5775__auto__.push((arguments[i__5770__auto___56288]));

var G__56289 = (i__5770__auto___56288 + (1));
i__5770__auto___56288 = G__56289;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56270){
var state_val_56271 = (state_56270[(1)]);
if((state_val_56271 === (1))){
var state_56270__$1 = state_56270;
var statearr_56272_56290 = state_56270__$1;
(statearr_56272_56290[(2)] = null);

(statearr_56272_56290[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56271 === (2))){
var _ = (function (){var statearr_56273 = state_56270;
(statearr_56273[(4)] = cljs.core.cons((5),(state_56270[(4)])));

return statearr_56273;
})();
var inst_56246 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56270__$1 = state_56270;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56270__$1,(6),inst_56246);
} else {
if((state_val_56271 === (3))){
var inst_56268 = (state_56270[(2)]);
var state_56270__$1 = state_56270;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56270__$1,inst_56268);
} else {
if((state_val_56271 === (4))){
var inst_56240 = (state_56270[(2)]);
var state_56270__$1 = state_56270;
var statearr_56275_56291 = state_56270__$1;
(statearr_56275_56291[(2)] = inst_56240);

(statearr_56275_56291[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56271 === (5))){
var _ = (function (){var statearr_56276 = state_56270;
(statearr_56276[(4)] = cljs.core.rest((state_56270[(4)])));

return statearr_56276;
})();
var state_56270__$1 = state_56270;
var ex56274 = (state_56270__$1[(2)]);
var statearr_56277_56292 = state_56270__$1;
(statearr_56277_56292[(5)] = ex56274);


if((ex56274 instanceof Error)){
var statearr_56278_56293 = state_56270__$1;
(statearr_56278_56293[(1)] = (4));

(statearr_56278_56293[(5)] = null);

} else {
throw ex56274;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56271 === (6))){
var inst_56248 = (state_56270[(2)]);
var inst_56249 = fluree.db.util.async.throw_err(inst_56248);
var inst_56250 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_56249);
var inst_56251 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56252 = [inst_56249];
var inst_56253 = (new cljs.core.PersistentVector(null,1,(5),inst_56251,inst_56252,null));
var inst_56254 = cljs.core.count(inst_56253);
var inst_56255 = ((9) + inst_56254);
var inst_56256 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56257 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56258 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56259 = [inst_56249];
var inst_56260 = (new cljs.core.PersistentVector(null,1,(5),inst_56258,inst_56259,null));
var inst_56261 = ["<",inst_56260,inst_56250];
var inst_56262 = cljs.core.PersistentHashMap.fromArrays(inst_56257,inst_56261);
var inst_56263 = [inst_56262,inst_56255];
var inst_56264 = (new cljs.core.PersistentVector(null,2,(5),inst_56256,inst_56263,null));
var inst_56265 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56264);
var _ = (function (){var statearr_56279 = state_56270;
(statearr_56279[(4)] = cljs.core.rest((state_56270[(4)])));

return statearr_56279;
})();
var state_56270__$1 = (function (){var statearr_56280 = state_56270;
(statearr_56280[(7)] = inst_56265);

return statearr_56280;
})();
var statearr_56281_56294 = state_56270__$1;
(statearr_56281_56294[(2)] = inst_56250);

(statearr_56281_56294[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_56282 = [null,null,null,null,null,null,null,null];
(statearr_56282[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_56282[(1)] = (1));

return statearr_56282;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_56270){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56270);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56283){var ex__2687__auto__ = e56283;
var statearr_56284_56295 = state_56270;
(statearr_56284_56295[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56270[(4)]))){
var statearr_56285_56296 = state_56270;
(statearr_56285_56296[(1)] = cljs.core.first((state_56270[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56297 = state_56270;
state_56270 = G__56297;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_56270){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_56270);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56286 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56286[(6)] = c__2706__auto__);

return statearr_56286;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq56238){
var G__56239 = cljs.core.first(seq56238);
var seq56238__$1 = cljs.core.next(seq56238);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56239,seq56238__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56347 = arguments.length;
var i__5770__auto___56348 = (0);
while(true){
if((i__5770__auto___56348 < len__5769__auto___56347)){
args__5775__auto__.push((arguments[i__5770__auto___56348]));

var G__56349 = (i__5770__auto___56348 + (1));
i__5770__auto___56348 = G__56349;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56330){
var state_val_56331 = (state_56330[(1)]);
if((state_val_56331 === (1))){
var state_56330__$1 = state_56330;
var statearr_56332_56350 = state_56330__$1;
(statearr_56332_56350[(2)] = null);

(statearr_56332_56350[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56331 === (2))){
var _ = (function (){var statearr_56333 = state_56330;
(statearr_56333[(4)] = cljs.core.cons((5),(state_56330[(4)])));

return statearr_56333;
})();
var inst_56306 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56330__$1 = state_56330;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56330__$1,(6),inst_56306);
} else {
if((state_val_56331 === (3))){
var inst_56328 = (state_56330[(2)]);
var state_56330__$1 = state_56330;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56330__$1,inst_56328);
} else {
if((state_val_56331 === (4))){
var inst_56300 = (state_56330[(2)]);
var state_56330__$1 = state_56330;
var statearr_56335_56351 = state_56330__$1;
(statearr_56335_56351[(2)] = inst_56300);

(statearr_56335_56351[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56331 === (5))){
var _ = (function (){var statearr_56336 = state_56330;
(statearr_56336[(4)] = cljs.core.rest((state_56330[(4)])));

return statearr_56336;
})();
var state_56330__$1 = state_56330;
var ex56334 = (state_56330__$1[(2)]);
var statearr_56337_56352 = state_56330__$1;
(statearr_56337_56352[(5)] = ex56334);


if((ex56334 instanceof Error)){
var statearr_56338_56353 = state_56330__$1;
(statearr_56338_56353[(1)] = (4));

(statearr_56338_56353[(5)] = null);

} else {
throw ex56334;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56331 === (6))){
var inst_56308 = (state_56330[(2)]);
var inst_56309 = fluree.db.util.async.throw_err(inst_56308);
var inst_56310 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_56309);
var inst_56311 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56312 = [inst_56309];
var inst_56313 = (new cljs.core.PersistentVector(null,1,(5),inst_56311,inst_56312,null));
var inst_56314 = cljs.core.count(inst_56313);
var inst_56315 = ((9) + inst_56314);
var inst_56316 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56317 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56318 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56319 = [inst_56309];
var inst_56320 = (new cljs.core.PersistentVector(null,1,(5),inst_56318,inst_56319,null));
var inst_56321 = ["<=",inst_56320,inst_56310];
var inst_56322 = cljs.core.PersistentHashMap.fromArrays(inst_56317,inst_56321);
var inst_56323 = [inst_56322,inst_56315];
var inst_56324 = (new cljs.core.PersistentVector(null,2,(5),inst_56316,inst_56323,null));
var inst_56325 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56324);
var _ = (function (){var statearr_56339 = state_56330;
(statearr_56339[(4)] = cljs.core.rest((state_56330[(4)])));

return statearr_56339;
})();
var state_56330__$1 = (function (){var statearr_56340 = state_56330;
(statearr_56340[(7)] = inst_56325);

return statearr_56340;
})();
var statearr_56341_56354 = state_56330__$1;
(statearr_56341_56354[(2)] = inst_56310);

(statearr_56341_56354[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_56342 = [null,null,null,null,null,null,null,null];
(statearr_56342[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_56342[(1)] = (1));

return statearr_56342;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_56330){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56330);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56343){var ex__2687__auto__ = e56343;
var statearr_56344_56355 = state_56330;
(statearr_56344_56355[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56330[(4)]))){
var statearr_56345_56356 = state_56330;
(statearr_56345_56356[(1)] = cljs.core.first((state_56330[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56357 = state_56330;
state_56330 = G__56357;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_56330){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_56330);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56346 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56346[(6)] = c__2706__auto__);

return statearr_56346;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq56298){
var G__56299 = cljs.core.first(seq56298);
var seq56298__$1 = cljs.core.next(seq56298);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56299,seq56298__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56407 = arguments.length;
var i__5770__auto___56408 = (0);
while(true){
if((i__5770__auto___56408 < len__5769__auto___56407)){
args__5775__auto__.push((arguments[i__5770__auto___56408]));

var G__56409 = (i__5770__auto___56408 + (1));
i__5770__auto___56408 = G__56409;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56390){
var state_val_56391 = (state_56390[(1)]);
if((state_val_56391 === (1))){
var state_56390__$1 = state_56390;
var statearr_56392_56410 = state_56390__$1;
(statearr_56392_56410[(2)] = null);

(statearr_56392_56410[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56391 === (2))){
var _ = (function (){var statearr_56393 = state_56390;
(statearr_56393[(4)] = cljs.core.cons((5),(state_56390[(4)])));

return statearr_56393;
})();
var inst_56366 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56390__$1 = state_56390;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56390__$1,(6),inst_56366);
} else {
if((state_val_56391 === (3))){
var inst_56388 = (state_56390[(2)]);
var state_56390__$1 = state_56390;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56390__$1,inst_56388);
} else {
if((state_val_56391 === (4))){
var inst_56360 = (state_56390[(2)]);
var state_56390__$1 = state_56390;
var statearr_56395_56411 = state_56390__$1;
(statearr_56395_56411[(2)] = inst_56360);

(statearr_56395_56411[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56391 === (5))){
var _ = (function (){var statearr_56396 = state_56390;
(statearr_56396[(4)] = cljs.core.rest((state_56390[(4)])));

return statearr_56396;
})();
var state_56390__$1 = state_56390;
var ex56394 = (state_56390__$1[(2)]);
var statearr_56397_56412 = state_56390__$1;
(statearr_56397_56412[(5)] = ex56394);


if((ex56394 instanceof Error)){
var statearr_56398_56413 = state_56390__$1;
(statearr_56398_56413[(1)] = (4));

(statearr_56398_56413[(5)] = null);

} else {
throw ex56394;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56391 === (6))){
var inst_56368 = (state_56390[(2)]);
var inst_56369 = fluree.db.util.async.throw_err(inst_56368);
var inst_56370 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_56369);
var inst_56371 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56372 = [inst_56369];
var inst_56373 = (new cljs.core.PersistentVector(null,1,(5),inst_56371,inst_56372,null));
var inst_56374 = cljs.core.count(inst_56373);
var inst_56375 = ((9) + inst_56374);
var inst_56376 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56377 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56378 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56379 = [inst_56369];
var inst_56380 = (new cljs.core.PersistentVector(null,1,(5),inst_56378,inst_56379,null));
var inst_56381 = [">=",inst_56380,inst_56370];
var inst_56382 = cljs.core.PersistentHashMap.fromArrays(inst_56377,inst_56381);
var inst_56383 = [inst_56382,inst_56375];
var inst_56384 = (new cljs.core.PersistentVector(null,2,(5),inst_56376,inst_56383,null));
var inst_56385 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56384);
var _ = (function (){var statearr_56399 = state_56390;
(statearr_56399[(4)] = cljs.core.rest((state_56390[(4)])));

return statearr_56399;
})();
var state_56390__$1 = (function (){var statearr_56400 = state_56390;
(statearr_56400[(7)] = inst_56385);

return statearr_56400;
})();
var statearr_56401_56414 = state_56390__$1;
(statearr_56401_56414[(2)] = inst_56370);

(statearr_56401_56414[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_56402 = [null,null,null,null,null,null,null,null];
(statearr_56402[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_56402[(1)] = (1));

return statearr_56402;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_56390){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56390);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56403){var ex__2687__auto__ = e56403;
var statearr_56404_56415 = state_56390;
(statearr_56404_56415[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56390[(4)]))){
var statearr_56405_56416 = state_56390;
(statearr_56405_56416[(1)] = cljs.core.first((state_56390[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56417 = state_56390;
state_56390 = G__56417;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_56390){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_56390);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56406 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56406[(6)] = c__2706__auto__);

return statearr_56406;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq56358){
var G__56359 = cljs.core.first(seq56358);
var seq56358__$1 = cljs.core.next(seq56358);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56359,seq56358__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56467 = arguments.length;
var i__5770__auto___56468 = (0);
while(true){
if((i__5770__auto___56468 < len__5769__auto___56467)){
args__5775__auto__.push((arguments[i__5770__auto___56468]));

var G__56469 = (i__5770__auto___56468 + (1));
i__5770__auto___56468 = G__56469;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56450){
var state_val_56451 = (state_56450[(1)]);
if((state_val_56451 === (1))){
var state_56450__$1 = state_56450;
var statearr_56452_56470 = state_56450__$1;
(statearr_56452_56470[(2)] = null);

(statearr_56452_56470[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56451 === (2))){
var _ = (function (){var statearr_56453 = state_56450;
(statearr_56453[(4)] = cljs.core.cons((5),(state_56450[(4)])));

return statearr_56453;
})();
var inst_56426 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56450__$1 = state_56450;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56450__$1,(6),inst_56426);
} else {
if((state_val_56451 === (3))){
var inst_56448 = (state_56450[(2)]);
var state_56450__$1 = state_56450;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56450__$1,inst_56448);
} else {
if((state_val_56451 === (4))){
var inst_56420 = (state_56450[(2)]);
var state_56450__$1 = state_56450;
var statearr_56455_56471 = state_56450__$1;
(statearr_56455_56471[(2)] = inst_56420);

(statearr_56455_56471[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56451 === (5))){
var _ = (function (){var statearr_56456 = state_56450;
(statearr_56456[(4)] = cljs.core.rest((state_56450[(4)])));

return statearr_56456;
})();
var state_56450__$1 = state_56450;
var ex56454 = (state_56450__$1[(2)]);
var statearr_56457_56472 = state_56450__$1;
(statearr_56457_56472[(5)] = ex56454);


if((ex56454 instanceof Error)){
var statearr_56458_56473 = state_56450__$1;
(statearr_56458_56473[(1)] = (4));

(statearr_56458_56473[(5)] = null);

} else {
throw ex56454;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56451 === (6))){
var inst_56428 = (state_56450[(2)]);
var inst_56429 = fluree.db.util.async.throw_err(inst_56428);
var inst_56430 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_56429);
var inst_56431 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56432 = [inst_56429];
var inst_56433 = (new cljs.core.PersistentVector(null,1,(5),inst_56431,inst_56432,null));
var inst_56434 = cljs.core.count(inst_56433);
var inst_56435 = ((9) + inst_56434);
var inst_56436 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56437 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56438 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56439 = [inst_56429];
var inst_56440 = (new cljs.core.PersistentVector(null,1,(5),inst_56438,inst_56439,null));
var inst_56441 = ["not=",inst_56440,inst_56430];
var inst_56442 = cljs.core.PersistentHashMap.fromArrays(inst_56437,inst_56441);
var inst_56443 = [inst_56442,inst_56435];
var inst_56444 = (new cljs.core.PersistentVector(null,2,(5),inst_56436,inst_56443,null));
var inst_56445 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56444);
var _ = (function (){var statearr_56459 = state_56450;
(statearr_56459[(4)] = cljs.core.rest((state_56450[(4)])));

return statearr_56459;
})();
var state_56450__$1 = (function (){var statearr_56460 = state_56450;
(statearr_56460[(7)] = inst_56445);

return statearr_56460;
})();
var statearr_56461_56474 = state_56450__$1;
(statearr_56461_56474[(2)] = inst_56430);

(statearr_56461_56474[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_56462 = [null,null,null,null,null,null,null,null];
(statearr_56462[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_56462[(1)] = (1));

return statearr_56462;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_56450){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56450);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56463){var ex__2687__auto__ = e56463;
var statearr_56464_56475 = state_56450;
(statearr_56464_56475[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56450[(4)]))){
var statearr_56465_56476 = state_56450;
(statearr_56465_56476[(1)] = cljs.core.first((state_56450[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56477 = state_56450;
state_56450 = G__56477;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_56450){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_56450);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56466 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56466[(6)] = c__2706__auto__);

return statearr_56466;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq56418){
var G__56419 = cljs.core.first(seq56418);
var seq56418__$1 = cljs.core.next(seq56418);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56419,seq56418__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56527 = arguments.length;
var i__5770__auto___56528 = (0);
while(true){
if((i__5770__auto___56528 < len__5769__auto___56527)){
args__5775__auto__.push((arguments[i__5770__auto___56528]));

var G__56529 = (i__5770__auto___56528 + (1));
i__5770__auto___56528 = G__56529;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56510){
var state_val_56511 = (state_56510[(1)]);
if((state_val_56511 === (1))){
var state_56510__$1 = state_56510;
var statearr_56512_56530 = state_56510__$1;
(statearr_56512_56530[(2)] = null);

(statearr_56512_56530[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56511 === (2))){
var _ = (function (){var statearr_56513 = state_56510;
(statearr_56513[(4)] = cljs.core.cons((5),(state_56510[(4)])));

return statearr_56513;
})();
var inst_56486 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56510__$1 = state_56510;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56510__$1,(6),inst_56486);
} else {
if((state_val_56511 === (3))){
var inst_56508 = (state_56510[(2)]);
var state_56510__$1 = state_56510;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56510__$1,inst_56508);
} else {
if((state_val_56511 === (4))){
var inst_56480 = (state_56510[(2)]);
var state_56510__$1 = state_56510;
var statearr_56515_56531 = state_56510__$1;
(statearr_56515_56531[(2)] = inst_56480);

(statearr_56515_56531[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56511 === (5))){
var _ = (function (){var statearr_56516 = state_56510;
(statearr_56516[(4)] = cljs.core.rest((state_56510[(4)])));

return statearr_56516;
})();
var state_56510__$1 = state_56510;
var ex56514 = (state_56510__$1[(2)]);
var statearr_56517_56532 = state_56510__$1;
(statearr_56517_56532[(5)] = ex56514);


if((ex56514 instanceof Error)){
var statearr_56518_56533 = state_56510__$1;
(statearr_56518_56533[(1)] = (4));

(statearr_56518_56533[(5)] = null);

} else {
throw ex56514;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56511 === (6))){
var inst_56488 = (state_56510[(2)]);
var inst_56489 = fluree.db.util.async.throw_err(inst_56488);
var inst_56490 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_56489);
var inst_56491 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56492 = [inst_56489];
var inst_56493 = (new cljs.core.PersistentVector(null,1,(5),inst_56491,inst_56492,null));
var inst_56494 = cljs.core.count(inst_56493);
var inst_56495 = ((9) + inst_56494);
var inst_56496 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56497 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56498 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56499 = [inst_56489];
var inst_56500 = (new cljs.core.PersistentVector(null,1,(5),inst_56498,inst_56499,null));
var inst_56501 = ["max",inst_56500,inst_56490];
var inst_56502 = cljs.core.PersistentHashMap.fromArrays(inst_56497,inst_56501);
var inst_56503 = [inst_56502,inst_56495];
var inst_56504 = (new cljs.core.PersistentVector(null,2,(5),inst_56496,inst_56503,null));
var inst_56505 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56504);
var _ = (function (){var statearr_56519 = state_56510;
(statearr_56519[(4)] = cljs.core.rest((state_56510[(4)])));

return statearr_56519;
})();
var state_56510__$1 = (function (){var statearr_56520 = state_56510;
(statearr_56520[(7)] = inst_56505);

return statearr_56520;
})();
var statearr_56521_56534 = state_56510__$1;
(statearr_56521_56534[(2)] = inst_56490);

(statearr_56521_56534[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_56522 = [null,null,null,null,null,null,null,null];
(statearr_56522[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_56522[(1)] = (1));

return statearr_56522;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_56510){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56510);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56523){var ex__2687__auto__ = e56523;
var statearr_56524_56535 = state_56510;
(statearr_56524_56535[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56510[(4)]))){
var statearr_56525_56536 = state_56510;
(statearr_56525_56536[(1)] = cljs.core.first((state_56510[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56537 = state_56510;
state_56510 = G__56537;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_56510){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_56510);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56526 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56526[(6)] = c__2706__auto__);

return statearr_56526;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq56478){
var G__56479 = cljs.core.first(seq56478);
var seq56478__$1 = cljs.core.next(seq56478);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56479,seq56478__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56587 = arguments.length;
var i__5770__auto___56588 = (0);
while(true){
if((i__5770__auto___56588 < len__5769__auto___56587)){
args__5775__auto__.push((arguments[i__5770__auto___56588]));

var G__56589 = (i__5770__auto___56588 + (1));
i__5770__auto___56588 = G__56589;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56570){
var state_val_56571 = (state_56570[(1)]);
if((state_val_56571 === (1))){
var state_56570__$1 = state_56570;
var statearr_56572_56590 = state_56570__$1;
(statearr_56572_56590[(2)] = null);

(statearr_56572_56590[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56571 === (2))){
var _ = (function (){var statearr_56573 = state_56570;
(statearr_56573[(4)] = cljs.core.cons((5),(state_56570[(4)])));

return statearr_56573;
})();
var inst_56546 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56570__$1 = state_56570;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56570__$1,(6),inst_56546);
} else {
if((state_val_56571 === (3))){
var inst_56568 = (state_56570[(2)]);
var state_56570__$1 = state_56570;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56570__$1,inst_56568);
} else {
if((state_val_56571 === (4))){
var inst_56540 = (state_56570[(2)]);
var state_56570__$1 = state_56570;
var statearr_56575_56591 = state_56570__$1;
(statearr_56575_56591[(2)] = inst_56540);

(statearr_56575_56591[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56571 === (5))){
var _ = (function (){var statearr_56576 = state_56570;
(statearr_56576[(4)] = cljs.core.rest((state_56570[(4)])));

return statearr_56576;
})();
var state_56570__$1 = state_56570;
var ex56574 = (state_56570__$1[(2)]);
var statearr_56577_56592 = state_56570__$1;
(statearr_56577_56592[(5)] = ex56574);


if((ex56574 instanceof Error)){
var statearr_56578_56593 = state_56570__$1;
(statearr_56578_56593[(1)] = (4));

(statearr_56578_56593[(5)] = null);

} else {
throw ex56574;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56571 === (6))){
var inst_56548 = (state_56570[(2)]);
var inst_56549 = fluree.db.util.async.throw_err(inst_56548);
var inst_56550 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_56549);
var inst_56551 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56552 = [inst_56549];
var inst_56553 = (new cljs.core.PersistentVector(null,1,(5),inst_56551,inst_56552,null));
var inst_56554 = cljs.core.count(inst_56553);
var inst_56555 = ((9) + inst_56554);
var inst_56556 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56557 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56558 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56559 = [inst_56549];
var inst_56560 = (new cljs.core.PersistentVector(null,1,(5),inst_56558,inst_56559,null));
var inst_56561 = ["min",inst_56560,inst_56550];
var inst_56562 = cljs.core.PersistentHashMap.fromArrays(inst_56557,inst_56561);
var inst_56563 = [inst_56562,inst_56555];
var inst_56564 = (new cljs.core.PersistentVector(null,2,(5),inst_56556,inst_56563,null));
var inst_56565 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56564);
var _ = (function (){var statearr_56579 = state_56570;
(statearr_56579[(4)] = cljs.core.rest((state_56570[(4)])));

return statearr_56579;
})();
var state_56570__$1 = (function (){var statearr_56580 = state_56570;
(statearr_56580[(7)] = inst_56565);

return statearr_56580;
})();
var statearr_56581_56594 = state_56570__$1;
(statearr_56581_56594[(2)] = inst_56550);

(statearr_56581_56594[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_56582 = [null,null,null,null,null,null,null,null];
(statearr_56582[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_56582[(1)] = (1));

return statearr_56582;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_56570){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56570);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56583){var ex__2687__auto__ = e56583;
var statearr_56584_56595 = state_56570;
(statearr_56584_56595[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56570[(4)]))){
var statearr_56585_56596 = state_56570;
(statearr_56585_56596[(1)] = cljs.core.first((state_56570[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56597 = state_56570;
state_56570 = G__56597;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_56570){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_56570);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56586 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56586[(6)] = c__2706__auto__);

return statearr_56586;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq56538){
var G__56539 = cljs.core.first(seq56538);
var seq56538__$1 = cljs.core.next(seq56538);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56539,seq56538__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__56599 = arguments.length;
switch (G__56599) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56644){
var state_val_56645 = (state_56644[(1)]);
if((state_val_56645 === (7))){
var state_56644__$1 = state_56644;
var statearr_56646_56783 = state_56644__$1;
(statearr_56646_56783[(2)] = query_map);

(statearr_56646_56783[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56645 === (1))){
var state_56644__$1 = state_56644;
var statearr_56647_56784 = state_56644__$1;
(statearr_56647_56784[(2)] = null);

(statearr_56647_56784[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56645 === (4))){
var inst_56600 = (state_56644[(2)]);
var state_56644__$1 = state_56644;
var statearr_56648_56785 = state_56644__$1;
(statearr_56648_56785[(2)] = inst_56600);

(statearr_56648_56785[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56645 === (13))){
var inst_56622 = (state_56644[(7)]);
var inst_56626 = (state_56644[(2)]);
var inst_56627 = fluree.db.util.async.throw_err(inst_56626);
var inst_56628 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56627,(0),null);
var inst_56629 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56627,(1),null);
var inst_56630 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56631 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56632 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56633 = [inst_56622];
var inst_56634 = (new cljs.core.PersistentVector(null,1,(5),inst_56632,inst_56633,null));
var inst_56635 = ["query",inst_56634,inst_56628];
var inst_56636 = cljs.core.PersistentHashMap.fromArrays(inst_56631,inst_56635);
var inst_56637 = [inst_56636,inst_56629];
var inst_56638 = (new cljs.core.PersistentVector(null,2,(5),inst_56630,inst_56637,null));
var inst_56639 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56638);
var _ = (function (){var statearr_56649 = state_56644;
(statearr_56649[(4)] = cljs.core.rest((state_56644[(4)])));

return statearr_56649;
})();
var state_56644__$1 = (function (){var statearr_56650 = state_56644;
(statearr_56650[(8)] = inst_56639);

return statearr_56650;
})();
var statearr_56651_56786 = state_56644__$1;
(statearr_56651_56786[(2)] = inst_56628);

(statearr_56651_56786[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56645 === (6))){
var state_56644__$1 = state_56644;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56644__$1,(9),query_map);
} else {
if((state_val_56645 === (3))){
var inst_56642 = (state_56644[(2)]);
var state_56644__$1 = state_56644;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56644__$1,inst_56642);
} else {
if((state_val_56645 === (12))){
var inst_56622 = (state_56644[(7)]);
var inst_56622__$1 = (state_56644[(2)]);
var inst_56623 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56624 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_56623,inst_56622__$1);
var state_56644__$1 = (function (){var statearr_56652 = state_56644;
(statearr_56652[(7)] = inst_56622__$1);

return statearr_56652;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56644__$1,(13),inst_56624);
} else {
if((state_val_56645 === (2))){
var _ = (function (){var statearr_56653 = state_56644;
(statearr_56653[(4)] = cljs.core.cons((5),(state_56644[(4)])));

return statearr_56653;
})();
var inst_56609 = fluree.db.util.async.channel_QMARK_(query_map);
var state_56644__$1 = state_56644;
if(inst_56609){
var statearr_56654_56787 = state_56644__$1;
(statearr_56654_56787[(1)] = (6));

} else {
var statearr_56655_56788 = state_56644__$1;
(statearr_56655_56788[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56645 === (11))){
var inst_56616 = (state_56644[(9)]);
var state_56644__$1 = state_56644;
var statearr_56657_56789 = state_56644__$1;
(statearr_56657_56789[(2)] = inst_56616);

(statearr_56657_56789[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56645 === (9))){
var inst_56612 = (state_56644[(2)]);
var inst_56613 = fluree.db.util.async.throw_err(inst_56612);
var state_56644__$1 = state_56644;
var statearr_56658_56790 = state_56644__$1;
(statearr_56658_56790[(2)] = inst_56613);

(statearr_56658_56790[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56645 === (5))){
var _ = (function (){var statearr_56659 = state_56644;
(statearr_56659[(4)] = cljs.core.rest((state_56644[(4)])));

return statearr_56659;
})();
var state_56644__$1 = state_56644;
var ex56656 = (state_56644__$1[(2)]);
var statearr_56660_56791 = state_56644__$1;
(statearr_56660_56791[(5)] = ex56656);


if((ex56656 instanceof Error)){
var statearr_56661_56792 = state_56644__$1;
(statearr_56661_56792[(1)] = (4));

(statearr_56661_56792[(5)] = null);

} else {
throw ex56656;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56645 === (10))){
var inst_56616 = (state_56644[(9)]);
var inst_56619 = fluree.db.util.json.parse(inst_56616);
var state_56644__$1 = state_56644;
var statearr_56662_56793 = state_56644__$1;
(statearr_56662_56793[(2)] = inst_56619);

(statearr_56662_56793[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56645 === (8))){
var inst_56616 = (state_56644[(9)]);
var inst_56616__$1 = (state_56644[(2)]);
var inst_56617 = typeof inst_56616__$1 === 'string';
var state_56644__$1 = (function (){var statearr_56663 = state_56644;
(statearr_56663[(9)] = inst_56616__$1);

return statearr_56663;
})();
if(cljs.core.truth_(inst_56617)){
var statearr_56664_56794 = state_56644__$1;
(statearr_56664_56794[(1)] = (10));

} else {
var statearr_56665_56795 = state_56644__$1;
(statearr_56665_56795[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_56666 = [null,null,null,null,null,null,null,null,null,null];
(statearr_56666[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_56666[(1)] = (1));

return statearr_56666;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_56644){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56644);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56667){var ex__2687__auto__ = e56667;
var statearr_56668_56796 = state_56644;
(statearr_56668_56796[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56644[(4)]))){
var statearr_56669_56797 = state_56644;
(statearr_56669_56797[(1)] = cljs.core.first((state_56644[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56798 = state_56644;
state_56644 = G__56798;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_56644){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_56644);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56670 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56670[(6)] = c__2706__auto__);

return statearr_56670;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56741){
var state_val_56742 = (state_56741[(1)]);
if((state_val_56742 === (7))){
var state_56741__$1 = state_56741;
var statearr_56743_56799 = state_56741__$1;
(statearr_56743_56799[(2)] = select);

(statearr_56743_56799[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56742 === (20))){
var inst_56711 = (state_56741[(2)]);
var inst_56712 = fluree.db.util.async.channel_QMARK_(limit);
var state_56741__$1 = (function (){var statearr_56744 = state_56741;
(statearr_56744[(7)] = inst_56711);

return statearr_56744;
})();
if(inst_56712){
var statearr_56745_56800 = state_56741__$1;
(statearr_56745_56800[(1)] = (22));

} else {
var statearr_56746_56801 = state_56741__$1;
(statearr_56746_56801[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56742 === (1))){
var state_56741__$1 = state_56741;
var statearr_56747_56802 = state_56741__$1;
(statearr_56747_56802[(2)] = null);

(statearr_56747_56802[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56742 === (24))){
var inst_56687 = (state_56741[(8)]);
var inst_56711 = (state_56741[(7)]);
var inst_56695 = (state_56741[(9)]);
var inst_56703 = (state_56741[(10)]);
var inst_56719 = (state_56741[(2)]);
var inst_56720 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56721 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_56720,inst_56687,inst_56695,inst_56703,inst_56711,inst_56719);
var state_56741__$1 = state_56741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56741__$1,(26),inst_56721);
} else {
if((state_val_56742 === (4))){
var inst_56671 = (state_56741[(2)]);
var state_56741__$1 = state_56741;
var statearr_56748_56803 = state_56741__$1;
(statearr_56748_56803[(2)] = inst_56671);

(statearr_56748_56803[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56742 === (15))){
var state_56741__$1 = state_56741;
var statearr_56749_56804 = state_56741__$1;
(statearr_56749_56804[(2)] = where);

(statearr_56749_56804[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56742 === (21))){
var inst_56707 = (state_56741[(2)]);
var inst_56708 = fluree.db.util.async.throw_err(inst_56707);
var state_56741__$1 = state_56741;
var statearr_56750_56805 = state_56741__$1;
(statearr_56750_56805[(2)] = inst_56708);

(statearr_56750_56805[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56742 === (13))){
var inst_56691 = (state_56741[(2)]);
var inst_56692 = fluree.db.util.async.throw_err(inst_56691);
var state_56741__$1 = state_56741;
var statearr_56751_56806 = state_56741__$1;
(statearr_56751_56806[(2)] = inst_56692);

(statearr_56751_56806[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56742 === (22))){
var state_56741__$1 = state_56741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56741__$1,(25),limit);
} else {
if((state_val_56742 === (6))){
var state_56741__$1 = state_56741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56741__$1,(9),select);
} else {
if((state_val_56742 === (25))){
var inst_56715 = (state_56741[(2)]);
var inst_56716 = fluree.db.util.async.throw_err(inst_56715);
var state_56741__$1 = state_56741;
var statearr_56752_56807 = state_56741__$1;
(statearr_56752_56807[(2)] = inst_56716);

(statearr_56752_56807[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56742 === (17))){
var inst_56699 = (state_56741[(2)]);
var inst_56700 = fluree.db.util.async.throw_err(inst_56699);
var state_56741__$1 = state_56741;
var statearr_56753_56808 = state_56741__$1;
(statearr_56753_56808[(2)] = inst_56700);

(statearr_56753_56808[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56742 === (3))){
var inst_56739 = (state_56741[(2)]);
var state_56741__$1 = state_56741;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56741__$1,inst_56739);
} else {
if((state_val_56742 === (12))){
var inst_56695 = (state_56741[(2)]);
var inst_56696 = fluree.db.util.async.channel_QMARK_(where);
var state_56741__$1 = (function (){var statearr_56754 = state_56741;
(statearr_56754[(9)] = inst_56695);

return statearr_56754;
})();
if(inst_56696){
var statearr_56755_56809 = state_56741__$1;
(statearr_56755_56809[(1)] = (14));

} else {
var statearr_56756_56810 = state_56741__$1;
(statearr_56756_56810[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56742 === (2))){
var _ = (function (){var statearr_56757 = state_56741;
(statearr_56757[(4)] = cljs.core.cons((5),(state_56741[(4)])));

return statearr_56757;
})();
var inst_56680 = fluree.db.util.async.channel_QMARK_(select);
var state_56741__$1 = state_56741;
if(inst_56680){
var statearr_56758_56811 = state_56741__$1;
(statearr_56758_56811[(1)] = (6));

} else {
var statearr_56759_56812 = state_56741__$1;
(statearr_56759_56812[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56742 === (23))){
var state_56741__$1 = state_56741;
var statearr_56760_56813 = state_56741__$1;
(statearr_56760_56813[(2)] = limit);

(statearr_56760_56813[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56742 === (19))){
var state_56741__$1 = state_56741;
var statearr_56761_56814 = state_56741__$1;
(statearr_56761_56814[(2)] = block);

(statearr_56761_56814[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56742 === (11))){
var state_56741__$1 = state_56741;
var statearr_56763_56815 = state_56741__$1;
(statearr_56763_56815[(2)] = from);

(statearr_56763_56815[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56742 === (9))){
var inst_56683 = (state_56741[(2)]);
var inst_56684 = fluree.db.util.async.throw_err(inst_56683);
var state_56741__$1 = state_56741;
var statearr_56764_56816 = state_56741__$1;
(statearr_56764_56816[(2)] = inst_56684);

(statearr_56764_56816[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56742 === (5))){
var _ = (function (){var statearr_56765 = state_56741;
(statearr_56765[(4)] = cljs.core.rest((state_56741[(4)])));

return statearr_56765;
})();
var state_56741__$1 = state_56741;
var ex56762 = (state_56741__$1[(2)]);
var statearr_56766_56817 = state_56741__$1;
(statearr_56766_56817[(5)] = ex56762);


if((ex56762 instanceof Error)){
var statearr_56767_56818 = state_56741__$1;
(statearr_56767_56818[(1)] = (4));

(statearr_56767_56818[(5)] = null);

} else {
throw ex56762;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56742 === (14))){
var state_56741__$1 = state_56741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56741__$1,(17),where);
} else {
if((state_val_56742 === (26))){
var inst_56687 = (state_56741[(8)]);
var inst_56711 = (state_56741[(7)]);
var inst_56695 = (state_56741[(9)]);
var inst_56703 = (state_56741[(10)]);
var inst_56723 = (state_56741[(2)]);
var inst_56724 = fluree.db.util.async.throw_err(inst_56723);
var inst_56725 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56724,(0),null);
var inst_56726 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56724,(1),null);
var inst_56727 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56728 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56729 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56730 = [inst_56687,inst_56695,inst_56703,inst_56711];
var inst_56731 = (new cljs.core.PersistentVector(null,4,(5),inst_56729,inst_56730,null));
var inst_56732 = ["query",inst_56731,inst_56725];
var inst_56733 = cljs.core.PersistentHashMap.fromArrays(inst_56728,inst_56732);
var inst_56734 = [inst_56733,inst_56726];
var inst_56735 = (new cljs.core.PersistentVector(null,2,(5),inst_56727,inst_56734,null));
var inst_56736 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56735);
var _ = (function (){var statearr_56768 = state_56741;
(statearr_56768[(4)] = cljs.core.rest((state_56741[(4)])));

return statearr_56768;
})();
var state_56741__$1 = (function (){var statearr_56769 = state_56741;
(statearr_56769[(11)] = inst_56736);

return statearr_56769;
})();
var statearr_56770_56819 = state_56741__$1;
(statearr_56770_56819[(2)] = inst_56725);

(statearr_56770_56819[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56742 === (16))){
var inst_56703 = (state_56741[(2)]);
var inst_56704 = fluree.db.util.async.channel_QMARK_(block);
var state_56741__$1 = (function (){var statearr_56771 = state_56741;
(statearr_56771[(10)] = inst_56703);

return statearr_56771;
})();
if(inst_56704){
var statearr_56772_56820 = state_56741__$1;
(statearr_56772_56820[(1)] = (18));

} else {
var statearr_56773_56821 = state_56741__$1;
(statearr_56773_56821[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56742 === (10))){
var state_56741__$1 = state_56741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56741__$1,(13),from);
} else {
if((state_val_56742 === (18))){
var state_56741__$1 = state_56741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56741__$1,(21),block);
} else {
if((state_val_56742 === (8))){
var inst_56687 = (state_56741[(2)]);
var inst_56688 = fluree.db.util.async.channel_QMARK_(from);
var state_56741__$1 = (function (){var statearr_56774 = state_56741;
(statearr_56774[(8)] = inst_56687);

return statearr_56774;
})();
if(inst_56688){
var statearr_56775_56822 = state_56741__$1;
(statearr_56775_56822[(1)] = (10));

} else {
var statearr_56776_56823 = state_56741__$1;
(statearr_56776_56823[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_56777 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56777[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_56777[(1)] = (1));

return statearr_56777;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_56741){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56741);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56778){var ex__2687__auto__ = e56778;
var statearr_56779_56824 = state_56741;
(statearr_56779_56824[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56741[(4)]))){
var statearr_56780_56825 = state_56741;
(statearr_56780_56825[(1)] = cljs.core.first((state_56741[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56826 = state_56741;
state_56741 = G__56826;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_56741){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_56741);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56781 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56781[(6)] = c__2706__auto__);

return statearr_56781;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56882){
var state_val_56883 = (state_56882[(1)]);
if((state_val_56883 === (7))){
var state_56882__$1 = state_56882;
var statearr_56884_56915 = state_56882__$1;
(statearr_56884_56915[(2)] = startSubject);

(statearr_56884_56915[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56883 === (1))){
var state_56882__$1 = state_56882;
var statearr_56885_56916 = state_56882__$1;
(statearr_56885_56916[(2)] = null);

(statearr_56885_56916[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56883 === (4))){
var inst_56827 = (state_56882[(2)]);
var state_56882__$1 = state_56882;
var statearr_56886_56917 = state_56882__$1;
(statearr_56886_56917[(2)] = inst_56827);

(statearr_56886_56917[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56883 === (15))){
var inst_56859 = (state_56882[(2)]);
var inst_56860 = fluree.db.util.async.throw_err(inst_56859);
var inst_56861 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56860,(0),null);
var inst_56862 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56860,(1),null);
var inst_56863 = cljs.core.empty_QMARK_(inst_56861);
var state_56882__$1 = (function (){var statearr_56887 = state_56882;
(statearr_56887[(7)] = inst_56862);

return statearr_56887;
})();
if(inst_56863){
var statearr_56888_56918 = state_56882__$1;
(statearr_56888_56918[(1)] = (16));

} else {
var statearr_56889_56919 = state_56882__$1;
(statearr_56889_56919[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56883 === (13))){
var inst_56843 = (state_56882[(8)]);
var inst_56855 = (state_56882[(9)]);
var inst_56847 = (state_56882[(10)]);
var inst_56855__$1 = (state_56882[(2)]);
var inst_56856 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56857 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_56856,inst_56843,inst_56847,inst_56855__$1);
var state_56882__$1 = (function (){var statearr_56890 = state_56882;
(statearr_56890[(9)] = inst_56855__$1);

return statearr_56890;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56882__$1,(15),inst_56857);
} else {
if((state_val_56883 === (6))){
var state_56882__$1 = state_56882;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56882__$1,(9),startSubject);
} else {
if((state_val_56883 === (17))){
var state_56882__$1 = state_56882;
var statearr_56891_56920 = state_56882__$1;
(statearr_56891_56920[(2)] = true);

(statearr_56891_56920[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56883 === (3))){
var inst_56880 = (state_56882[(2)]);
var state_56882__$1 = state_56882;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56882__$1,inst_56880);
} else {
if((state_val_56883 === (12))){
var state_56882__$1 = state_56882;
var statearr_56892_56921 = state_56882__$1;
(statearr_56892_56921[(2)] = endSubject);

(statearr_56892_56921[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56883 === (2))){
var _ = (function (){var statearr_56893 = state_56882;
(statearr_56893[(4)] = cljs.core.cons((5),(state_56882[(4)])));

return statearr_56893;
})();
var inst_56836 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_56882__$1 = state_56882;
if(inst_56836){
var statearr_56894_56922 = state_56882__$1;
(statearr_56894_56922[(1)] = (6));

} else {
var statearr_56895_56923 = state_56882__$1;
(statearr_56895_56923[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56883 === (11))){
var state_56882__$1 = state_56882;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56882__$1,(14),endSubject);
} else {
if((state_val_56883 === (9))){
var inst_56839 = (state_56882[(2)]);
var inst_56840 = fluree.db.util.async.throw_err(inst_56839);
var state_56882__$1 = state_56882;
var statearr_56897_56924 = state_56882__$1;
(statearr_56897_56924[(2)] = inst_56840);

(statearr_56897_56924[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56883 === (5))){
var _ = (function (){var statearr_56898 = state_56882;
(statearr_56898[(4)] = cljs.core.rest((state_56882[(4)])));

return statearr_56898;
})();
var state_56882__$1 = state_56882;
var ex56896 = (state_56882__$1[(2)]);
var statearr_56899_56925 = state_56882__$1;
(statearr_56899_56925[(5)] = ex56896);


if((ex56896 instanceof Error)){
var statearr_56900_56926 = state_56882__$1;
(statearr_56900_56926[(1)] = (4));

(statearr_56900_56926[(5)] = null);

} else {
throw ex56896;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56883 === (14))){
var inst_56851 = (state_56882[(2)]);
var inst_56852 = fluree.db.util.async.throw_err(inst_56851);
var state_56882__$1 = state_56882;
var statearr_56901_56927 = state_56882__$1;
(statearr_56901_56927[(2)] = inst_56852);

(statearr_56901_56927[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56883 === (16))){
var state_56882__$1 = state_56882;
var statearr_56902_56928 = state_56882__$1;
(statearr_56902_56928[(2)] = false);

(statearr_56902_56928[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56883 === (10))){
var inst_56846 = (state_56882[(2)]);
var inst_56847 = fluree.db.util.async.throw_err(inst_56846);
var inst_56848 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_56882__$1 = (function (){var statearr_56903 = state_56882;
(statearr_56903[(10)] = inst_56847);

return statearr_56903;
})();
if(inst_56848){
var statearr_56904_56929 = state_56882__$1;
(statearr_56904_56929[(1)] = (11));

} else {
var statearr_56905_56930 = state_56882__$1;
(statearr_56905_56930[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56883 === (18))){
var inst_56843 = (state_56882[(8)]);
var inst_56862 = (state_56882[(7)]);
var inst_56855 = (state_56882[(9)]);
var inst_56847 = (state_56882[(10)]);
var inst_56867 = (state_56882[(2)]);
var inst_56868 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56869 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56870 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56871 = [inst_56843,inst_56847,inst_56855];
var inst_56872 = (new cljs.core.PersistentVector(null,3,(5),inst_56870,inst_56871,null));
var inst_56873 = ["relationship?",inst_56872,inst_56867];
var inst_56874 = cljs.core.PersistentHashMap.fromArrays(inst_56869,inst_56873);
var inst_56875 = [inst_56874,inst_56862];
var inst_56876 = (new cljs.core.PersistentVector(null,2,(5),inst_56868,inst_56875,null));
var inst_56877 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56876);
var _ = (function (){var statearr_56906 = state_56882;
(statearr_56906[(4)] = cljs.core.rest((state_56882[(4)])));

return statearr_56906;
})();
var state_56882__$1 = (function (){var statearr_56907 = state_56882;
(statearr_56907[(11)] = inst_56877);

return statearr_56907;
})();
var statearr_56908_56931 = state_56882__$1;
(statearr_56908_56931[(2)] = inst_56867);

(statearr_56908_56931[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56883 === (8))){
var inst_56843 = (state_56882[(2)]);
var inst_56844 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_56882__$1 = (function (){var statearr_56909 = state_56882;
(statearr_56909[(8)] = inst_56843);

return statearr_56909;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56882__$1,(10),inst_56844);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_56910 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56910[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto__);

(statearr_56910[(1)] = (1));

return statearr_56910;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto____1 = (function (state_56882){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56882);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56911){var ex__2687__auto__ = e56911;
var statearr_56912_56932 = state_56882;
(statearr_56912_56932[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56882[(4)]))){
var statearr_56913_56933 = state_56882;
(statearr_56913_56933[(1)] = cljs.core.first((state_56882[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56934 = state_56882;
state_56882 = G__56934;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto__ = function(state_56882){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto____1.call(this,state_56882);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56914 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56914[(6)] = c__2706__auto__);

return statearr_56914;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_56971){
var state_val_56972 = (state_56971[(1)]);
if((state_val_56972 === (7))){
var state_56971__$1 = state_56971;
var statearr_56973_56993 = state_56971__$1;
(statearr_56973_56993[(2)] = pred_name);

(statearr_56973_56993[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56972 === (1))){
var state_56971__$1 = state_56971;
var statearr_56974_56994 = state_56971__$1;
(statearr_56974_56994[(2)] = null);

(statearr_56974_56994[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56972 === (4))){
var inst_56935 = (state_56971[(2)]);
var state_56971__$1 = state_56971;
var statearr_56975_56995 = state_56971__$1;
(statearr_56975_56995[(2)] = inst_56935);

(statearr_56975_56995[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56972 === (6))){
var state_56971__$1 = state_56971;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56971__$1,(9),pred_name);
} else {
if((state_val_56972 === (3))){
var inst_56969 = (state_56971[(2)]);
var state_56971__$1 = state_56971;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56971__$1,inst_56969);
} else {
if((state_val_56972 === (2))){
var _ = (function (){var statearr_56977 = state_56971;
(statearr_56977[(4)] = cljs.core.cons((5),(state_56971[(4)])));

return statearr_56977;
})();
var inst_56944 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_56971__$1 = state_56971;
if(inst_56944){
var statearr_56978_56996 = state_56971__$1;
(statearr_56978_56996[(1)] = (6));

} else {
var statearr_56979_56997 = state_56971__$1;
(statearr_56979_56997[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56972 === (9))){
var inst_56947 = (state_56971[(2)]);
var inst_56948 = fluree.db.util.async.throw_err(inst_56947);
var state_56971__$1 = state_56971;
var statearr_56980_56998 = state_56971__$1;
(statearr_56980_56998[(2)] = inst_56948);

(statearr_56980_56998[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56972 === (5))){
var _ = (function (){var statearr_56981 = state_56971;
(statearr_56981[(4)] = cljs.core.rest((state_56971[(4)])));

return statearr_56981;
})();
var state_56971__$1 = state_56971;
var ex56976 = (state_56971__$1[(2)]);
var statearr_56982_56999 = state_56971__$1;
(statearr_56982_56999[(5)] = ex56976);


if((ex56976 instanceof Error)){
var statearr_56983_57000 = state_56971__$1;
(statearr_56983_57000[(1)] = (4));

(statearr_56983_57000[(5)] = null);

} else {
throw ex56976;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56972 === (10))){
var inst_56951 = (state_56971[(7)]);
var inst_56955 = (state_56971[(2)]);
var inst_56956 = fluree.db.util.async.throw_err(inst_56955);
var inst_56957 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56956,(0),null);
var inst_56958 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56956,(1),null);
var inst_56959 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56960 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56961 = ["max-pred-val",inst_56951,inst_56957];
var inst_56962 = cljs.core.PersistentHashMap.fromArrays(inst_56960,inst_56961);
var inst_56963 = (inst_56958 + (10));
var inst_56964 = [inst_56962,inst_56963];
var inst_56965 = (new cljs.core.PersistentVector(null,2,(5),inst_56959,inst_56964,null));
var inst_56966 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56965);
var _ = (function (){var statearr_56984 = state_56971;
(statearr_56984[(4)] = cljs.core.rest((state_56971[(4)])));

return statearr_56984;
})();
var state_56971__$1 = (function (){var statearr_56985 = state_56971;
(statearr_56985[(8)] = inst_56966);

return statearr_56985;
})();
var statearr_56986_57001 = state_56971__$1;
(statearr_56986_57001[(2)] = inst_56957);

(statearr_56986_57001[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56972 === (8))){
var inst_56951 = (state_56971[(7)]);
var inst_56951__$1 = (state_56971[(2)]);
var inst_56952 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56953 = fluree.db.dbfunctions.internal.max_pred_val(inst_56952,inst_56951__$1,null);
var state_56971__$1 = (function (){var statearr_56987 = state_56971;
(statearr_56987[(7)] = inst_56951__$1);

return statearr_56987;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56971__$1,(10),inst_56953);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto____0 = (function (){
var statearr_56988 = [null,null,null,null,null,null,null,null,null];
(statearr_56988[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto__);

(statearr_56988[(1)] = (1));

return statearr_56988;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto____1 = (function (state_56971){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_56971);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e56989){var ex__2687__auto__ = e56989;
var statearr_56990_57002 = state_56971;
(statearr_56990_57002[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_56971[(4)]))){
var statearr_56991_57003 = state_56971;
(statearr_56991_57003[(1)] = cljs.core.first((state_56971[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57004 = state_56971;
state_56971 = G__57004;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto__ = function(state_56971){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto____1.call(this,state_56971);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_56992 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_56992[(6)] = c__2706__auto__);

return statearr_56992;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57031){
var state_val_57032 = (state_57031[(1)]);
if((state_val_57032 === (7))){
var state_57031__$1 = state_57031;
var statearr_57033_57052 = state_57031__$1;
(statearr_57033_57052[(2)] = n);

(statearr_57033_57052[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57032 === (1))){
var state_57031__$1 = state_57031;
var statearr_57034_57053 = state_57031__$1;
(statearr_57034_57053[(2)] = null);

(statearr_57034_57053[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57032 === (4))){
var inst_57005 = (state_57031[(2)]);
var state_57031__$1 = state_57031;
var statearr_57035_57054 = state_57031__$1;
(statearr_57035_57054[(2)] = inst_57005);

(statearr_57035_57054[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57032 === (6))){
var state_57031__$1 = state_57031;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57031__$1,(9),n);
} else {
if((state_val_57032 === (3))){
var inst_57029 = (state_57031[(2)]);
var state_57031__$1 = state_57031;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57031__$1,inst_57029);
} else {
if((state_val_57032 === (2))){
var _ = (function (){var statearr_57037 = state_57031;
(statearr_57037[(4)] = cljs.core.cons((5),(state_57031[(4)])));

return statearr_57037;
})();
var inst_57011 = fluree.db.util.async.channel_QMARK_(n);
var state_57031__$1 = state_57031;
if(inst_57011){
var statearr_57038_57055 = state_57031__$1;
(statearr_57038_57055[(1)] = (6));

} else {
var statearr_57039_57056 = state_57031__$1;
(statearr_57039_57056[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57032 === (9))){
var inst_57014 = (state_57031[(2)]);
var inst_57015 = fluree.db.util.async.throw_err(inst_57014);
var state_57031__$1 = state_57031;
var statearr_57040_57057 = state_57031__$1;
(statearr_57040_57057[(2)] = inst_57015);

(statearr_57040_57057[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57032 === (5))){
var _ = (function (){var statearr_57041 = state_57031;
(statearr_57041[(4)] = cljs.core.rest((state_57031[(4)])));

return statearr_57041;
})();
var state_57031__$1 = state_57031;
var ex57036 = (state_57031__$1[(2)]);
var statearr_57042_57058 = state_57031__$1;
(statearr_57042_57058[(5)] = ex57036);


if((ex57036 instanceof Error)){
var statearr_57043_57059 = state_57031__$1;
(statearr_57043_57059[(1)] = (4));

(statearr_57043_57059[(5)] = null);

} else {
throw ex57036;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57032 === (8))){
var inst_57018 = (state_57031[(2)]);
var inst_57019 = fluree.db.dbfunctions.internal.inc(inst_57018);
var inst_57020 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57021 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57022 = ["inc",inst_57018,inst_57019];
var inst_57023 = cljs.core.PersistentHashMap.fromArrays(inst_57021,inst_57022);
var inst_57024 = [inst_57023,(10)];
var inst_57025 = (new cljs.core.PersistentVector(null,2,(5),inst_57020,inst_57024,null));
var inst_57026 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57025);
var _ = (function (){var statearr_57044 = state_57031;
(statearr_57044[(4)] = cljs.core.rest((state_57031[(4)])));

return statearr_57044;
})();
var state_57031__$1 = (function (){var statearr_57045 = state_57031;
(statearr_57045[(7)] = inst_57026);

return statearr_57045;
})();
var statearr_57046_57060 = state_57031__$1;
(statearr_57046_57060[(2)] = inst_57019);

(statearr_57046_57060[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto____0 = (function (){
var statearr_57047 = [null,null,null,null,null,null,null,null];
(statearr_57047[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto__);

(statearr_57047[(1)] = (1));

return statearr_57047;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto____1 = (function (state_57031){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57031);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57048){var ex__2687__auto__ = e57048;
var statearr_57049_57061 = state_57031;
(statearr_57049_57061[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57031[(4)]))){
var statearr_57050_57062 = state_57031;
(statearr_57050_57062[(1)] = cljs.core.first((state_57031[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57063 = state_57031;
state_57031 = G__57063;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto__ = function(state_57031){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto____1.call(this,state_57031);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57051 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57051[(6)] = c__2706__auto__);

return statearr_57051;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57090){
var state_val_57091 = (state_57090[(1)]);
if((state_val_57091 === (7))){
var state_57090__$1 = state_57090;
var statearr_57092_57111 = state_57090__$1;
(statearr_57092_57111[(2)] = n);

(statearr_57092_57111[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57091 === (1))){
var state_57090__$1 = state_57090;
var statearr_57093_57112 = state_57090__$1;
(statearr_57093_57112[(2)] = null);

(statearr_57093_57112[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57091 === (4))){
var inst_57064 = (state_57090[(2)]);
var state_57090__$1 = state_57090;
var statearr_57094_57113 = state_57090__$1;
(statearr_57094_57113[(2)] = inst_57064);

(statearr_57094_57113[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57091 === (6))){
var state_57090__$1 = state_57090;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57090__$1,(9),n);
} else {
if((state_val_57091 === (3))){
var inst_57088 = (state_57090[(2)]);
var state_57090__$1 = state_57090;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57090__$1,inst_57088);
} else {
if((state_val_57091 === (2))){
var _ = (function (){var statearr_57096 = state_57090;
(statearr_57096[(4)] = cljs.core.cons((5),(state_57090[(4)])));

return statearr_57096;
})();
var inst_57070 = fluree.db.util.async.channel_QMARK_(n);
var state_57090__$1 = state_57090;
if(inst_57070){
var statearr_57097_57114 = state_57090__$1;
(statearr_57097_57114[(1)] = (6));

} else {
var statearr_57098_57115 = state_57090__$1;
(statearr_57098_57115[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57091 === (9))){
var inst_57073 = (state_57090[(2)]);
var inst_57074 = fluree.db.util.async.throw_err(inst_57073);
var state_57090__$1 = state_57090;
var statearr_57099_57116 = state_57090__$1;
(statearr_57099_57116[(2)] = inst_57074);

(statearr_57099_57116[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57091 === (5))){
var _ = (function (){var statearr_57100 = state_57090;
(statearr_57100[(4)] = cljs.core.rest((state_57090[(4)])));

return statearr_57100;
})();
var state_57090__$1 = state_57090;
var ex57095 = (state_57090__$1[(2)]);
var statearr_57101_57117 = state_57090__$1;
(statearr_57101_57117[(5)] = ex57095);


if((ex57095 instanceof Error)){
var statearr_57102_57118 = state_57090__$1;
(statearr_57102_57118[(1)] = (4));

(statearr_57102_57118[(5)] = null);

} else {
throw ex57095;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57091 === (8))){
var inst_57077 = (state_57090[(2)]);
var inst_57078 = fluree.db.dbfunctions.internal.dec(inst_57077);
var inst_57079 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57080 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57081 = ["dec",inst_57077,inst_57078];
var inst_57082 = cljs.core.PersistentHashMap.fromArrays(inst_57080,inst_57081);
var inst_57083 = [inst_57082,(10)];
var inst_57084 = (new cljs.core.PersistentVector(null,2,(5),inst_57079,inst_57083,null));
var inst_57085 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57084);
var _ = (function (){var statearr_57103 = state_57090;
(statearr_57103[(4)] = cljs.core.rest((state_57090[(4)])));

return statearr_57103;
})();
var state_57090__$1 = (function (){var statearr_57104 = state_57090;
(statearr_57104[(7)] = inst_57085);

return statearr_57104;
})();
var statearr_57105_57119 = state_57090__$1;
(statearr_57105_57119[(2)] = inst_57078);

(statearr_57105_57119[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto____0 = (function (){
var statearr_57106 = [null,null,null,null,null,null,null,null];
(statearr_57106[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto__);

(statearr_57106[(1)] = (1));

return statearr_57106;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto____1 = (function (state_57090){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57090);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57107){var ex__2687__auto__ = e57107;
var statearr_57108_57120 = state_57090;
(statearr_57108_57120[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57090[(4)]))){
var statearr_57109_57121 = state_57090;
(statearr_57109_57121[(1)] = cljs.core.first((state_57090[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57122 = state_57090;
state_57090 = G__57122;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto__ = function(state_57090){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto____1.call(this,state_57090);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57110 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57110[(6)] = c__2706__auto__);

return statearr_57110;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___57172 = arguments.length;
var i__5770__auto___57173 = (0);
while(true){
if((i__5770__auto___57173 < len__5769__auto___57172)){
args__5775__auto__.push((arguments[i__5770__auto___57173]));

var G__57174 = (i__5770__auto___57173 + (1));
i__5770__auto___57173 = G__57174;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57155){
var state_val_57156 = (state_57155[(1)]);
if((state_val_57156 === (1))){
var state_57155__$1 = state_57155;
var statearr_57157_57175 = state_57155__$1;
(statearr_57157_57175[(2)] = null);

(statearr_57157_57175[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57156 === (2))){
var _ = (function (){var statearr_57158 = state_57155;
(statearr_57158[(4)] = cljs.core.cons((5),(state_57155[(4)])));

return statearr_57158;
})();
var inst_57131 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_57155__$1 = state_57155;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57155__$1,(6),inst_57131);
} else {
if((state_val_57156 === (3))){
var inst_57153 = (state_57155[(2)]);
var state_57155__$1 = state_57155;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57155__$1,inst_57153);
} else {
if((state_val_57156 === (4))){
var inst_57125 = (state_57155[(2)]);
var state_57155__$1 = state_57155;
var statearr_57160_57176 = state_57155__$1;
(statearr_57160_57176[(2)] = inst_57125);

(statearr_57160_57176[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57156 === (5))){
var _ = (function (){var statearr_57161 = state_57155;
(statearr_57161[(4)] = cljs.core.rest((state_57155[(4)])));

return statearr_57161;
})();
var state_57155__$1 = state_57155;
var ex57159 = (state_57155__$1[(2)]);
var statearr_57162_57177 = state_57155__$1;
(statearr_57162_57177[(5)] = ex57159);


if((ex57159 instanceof Error)){
var statearr_57163_57178 = state_57155__$1;
(statearr_57163_57178[(1)] = (4));

(statearr_57163_57178[(5)] = null);

} else {
throw ex57159;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57156 === (6))){
var inst_57133 = (state_57155[(2)]);
var inst_57134 = fluree.db.util.async.throw_err(inst_57133);
var inst_57135 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_57134);
var inst_57136 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57137 = [inst_57134];
var inst_57138 = (new cljs.core.PersistentVector(null,1,(5),inst_57136,inst_57137,null));
var inst_57139 = cljs.core.count(inst_57138);
var inst_57140 = ((9) + inst_57139);
var inst_57141 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57142 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57143 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57144 = [inst_57134];
var inst_57145 = (new cljs.core.PersistentVector(null,1,(5),inst_57143,inst_57144,null));
var inst_57146 = ["+",inst_57145,inst_57135];
var inst_57147 = cljs.core.PersistentHashMap.fromArrays(inst_57142,inst_57146);
var inst_57148 = [inst_57147,inst_57140];
var inst_57149 = (new cljs.core.PersistentVector(null,2,(5),inst_57141,inst_57148,null));
var inst_57150 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57149);
var _ = (function (){var statearr_57164 = state_57155;
(statearr_57164[(4)] = cljs.core.rest((state_57155[(4)])));

return statearr_57164;
})();
var state_57155__$1 = (function (){var statearr_57165 = state_57155;
(statearr_57165[(7)] = inst_57150);

return statearr_57165;
})();
var statearr_57166_57179 = state_57155__$1;
(statearr_57166_57179[(2)] = inst_57135);

(statearr_57166_57179[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_57167 = [null,null,null,null,null,null,null,null];
(statearr_57167[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_57167[(1)] = (1));

return statearr_57167;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_57155){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57155);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57168){var ex__2687__auto__ = e57168;
var statearr_57169_57180 = state_57155;
(statearr_57169_57180[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57155[(4)]))){
var statearr_57170_57181 = state_57155;
(statearr_57170_57181[(1)] = cljs.core.first((state_57155[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57182 = state_57155;
state_57155 = G__57182;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_57155){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_57155);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57171 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57171[(6)] = c__2706__auto__);

return statearr_57171;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq57123){
var G__57124 = cljs.core.first(seq57123);
var seq57123__$1 = cljs.core.next(seq57123);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__57124,seq57123__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___57232 = arguments.length;
var i__5770__auto___57233 = (0);
while(true){
if((i__5770__auto___57233 < len__5769__auto___57232)){
args__5775__auto__.push((arguments[i__5770__auto___57233]));

var G__57234 = (i__5770__auto___57233 + (1));
i__5770__auto___57233 = G__57234;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57215){
var state_val_57216 = (state_57215[(1)]);
if((state_val_57216 === (1))){
var state_57215__$1 = state_57215;
var statearr_57217_57235 = state_57215__$1;
(statearr_57217_57235[(2)] = null);

(statearr_57217_57235[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57216 === (2))){
var _ = (function (){var statearr_57218 = state_57215;
(statearr_57218[(4)] = cljs.core.cons((5),(state_57215[(4)])));

return statearr_57218;
})();
var inst_57191 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_57215__$1 = state_57215;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57215__$1,(6),inst_57191);
} else {
if((state_val_57216 === (3))){
var inst_57213 = (state_57215[(2)]);
var state_57215__$1 = state_57215;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57215__$1,inst_57213);
} else {
if((state_val_57216 === (4))){
var inst_57185 = (state_57215[(2)]);
var state_57215__$1 = state_57215;
var statearr_57220_57236 = state_57215__$1;
(statearr_57220_57236[(2)] = inst_57185);

(statearr_57220_57236[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57216 === (5))){
var _ = (function (){var statearr_57221 = state_57215;
(statearr_57221[(4)] = cljs.core.rest((state_57215[(4)])));

return statearr_57221;
})();
var state_57215__$1 = state_57215;
var ex57219 = (state_57215__$1[(2)]);
var statearr_57222_57237 = state_57215__$1;
(statearr_57222_57237[(5)] = ex57219);


if((ex57219 instanceof Error)){
var statearr_57223_57238 = state_57215__$1;
(statearr_57223_57238[(1)] = (4));

(statearr_57223_57238[(5)] = null);

} else {
throw ex57219;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57216 === (6))){
var inst_57193 = (state_57215[(2)]);
var inst_57194 = fluree.db.util.async.throw_err(inst_57193);
var inst_57195 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_57194);
var inst_57196 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57197 = [inst_57194];
var inst_57198 = (new cljs.core.PersistentVector(null,1,(5),inst_57196,inst_57197,null));
var inst_57199 = cljs.core.count(inst_57198);
var inst_57200 = ((9) + inst_57199);
var inst_57201 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57202 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57203 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57204 = [inst_57194];
var inst_57205 = (new cljs.core.PersistentVector(null,1,(5),inst_57203,inst_57204,null));
var inst_57206 = ["-",inst_57205,inst_57195];
var inst_57207 = cljs.core.PersistentHashMap.fromArrays(inst_57202,inst_57206);
var inst_57208 = [inst_57207,inst_57200];
var inst_57209 = (new cljs.core.PersistentVector(null,2,(5),inst_57201,inst_57208,null));
var inst_57210 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57209);
var _ = (function (){var statearr_57224 = state_57215;
(statearr_57224[(4)] = cljs.core.rest((state_57215[(4)])));

return statearr_57224;
})();
var state_57215__$1 = (function (){var statearr_57225 = state_57215;
(statearr_57225[(7)] = inst_57210);

return statearr_57225;
})();
var statearr_57226_57239 = state_57215__$1;
(statearr_57226_57239[(2)] = inst_57195);

(statearr_57226_57239[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_57227 = [null,null,null,null,null,null,null,null];
(statearr_57227[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_57227[(1)] = (1));

return statearr_57227;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_57215){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57215);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57228){var ex__2687__auto__ = e57228;
var statearr_57229_57240 = state_57215;
(statearr_57229_57240[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57215[(4)]))){
var statearr_57230_57241 = state_57215;
(statearr_57230_57241[(1)] = cljs.core.first((state_57215[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57242 = state_57215;
state_57215 = G__57242;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_57215){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_57215);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57231 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57231[(6)] = c__2706__auto__);

return statearr_57231;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq57183){
var G__57184 = cljs.core.first(seq57183);
var seq57183__$1 = cljs.core.next(seq57183);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__57184,seq57183__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___57292 = arguments.length;
var i__5770__auto___57293 = (0);
while(true){
if((i__5770__auto___57293 < len__5769__auto___57292)){
args__5775__auto__.push((arguments[i__5770__auto___57293]));

var G__57294 = (i__5770__auto___57293 + (1));
i__5770__auto___57293 = G__57294;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57275){
var state_val_57276 = (state_57275[(1)]);
if((state_val_57276 === (1))){
var state_57275__$1 = state_57275;
var statearr_57277_57295 = state_57275__$1;
(statearr_57277_57295[(2)] = null);

(statearr_57277_57295[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57276 === (2))){
var _ = (function (){var statearr_57278 = state_57275;
(statearr_57278[(4)] = cljs.core.cons((5),(state_57275[(4)])));

return statearr_57278;
})();
var inst_57251 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_57275__$1 = state_57275;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57275__$1,(6),inst_57251);
} else {
if((state_val_57276 === (3))){
var inst_57273 = (state_57275[(2)]);
var state_57275__$1 = state_57275;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57275__$1,inst_57273);
} else {
if((state_val_57276 === (4))){
var inst_57245 = (state_57275[(2)]);
var state_57275__$1 = state_57275;
var statearr_57280_57296 = state_57275__$1;
(statearr_57280_57296[(2)] = inst_57245);

(statearr_57280_57296[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57276 === (5))){
var _ = (function (){var statearr_57281 = state_57275;
(statearr_57281[(4)] = cljs.core.rest((state_57275[(4)])));

return statearr_57281;
})();
var state_57275__$1 = state_57275;
var ex57279 = (state_57275__$1[(2)]);
var statearr_57282_57297 = state_57275__$1;
(statearr_57282_57297[(5)] = ex57279);


if((ex57279 instanceof Error)){
var statearr_57283_57298 = state_57275__$1;
(statearr_57283_57298[(1)] = (4));

(statearr_57283_57298[(5)] = null);

} else {
throw ex57279;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57276 === (6))){
var inst_57253 = (state_57275[(2)]);
var inst_57254 = fluree.db.util.async.throw_err(inst_57253);
var inst_57255 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_57254);
var inst_57256 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57257 = [inst_57254];
var inst_57258 = (new cljs.core.PersistentVector(null,1,(5),inst_57256,inst_57257,null));
var inst_57259 = cljs.core.count(inst_57258);
var inst_57260 = ((9) + inst_57259);
var inst_57261 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57262 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57263 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57264 = [inst_57254];
var inst_57265 = (new cljs.core.PersistentVector(null,1,(5),inst_57263,inst_57264,null));
var inst_57266 = ["*",inst_57265,inst_57255];
var inst_57267 = cljs.core.PersistentHashMap.fromArrays(inst_57262,inst_57266);
var inst_57268 = [inst_57267,inst_57260];
var inst_57269 = (new cljs.core.PersistentVector(null,2,(5),inst_57261,inst_57268,null));
var inst_57270 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57269);
var _ = (function (){var statearr_57284 = state_57275;
(statearr_57284[(4)] = cljs.core.rest((state_57275[(4)])));

return statearr_57284;
})();
var state_57275__$1 = (function (){var statearr_57285 = state_57275;
(statearr_57285[(7)] = inst_57270);

return statearr_57285;
})();
var statearr_57286_57299 = state_57275__$1;
(statearr_57286_57299[(2)] = inst_57255);

(statearr_57286_57299[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_57287 = [null,null,null,null,null,null,null,null];
(statearr_57287[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_57287[(1)] = (1));

return statearr_57287;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_57275){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57275);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57288){var ex__2687__auto__ = e57288;
var statearr_57289_57300 = state_57275;
(statearr_57289_57300[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57275[(4)]))){
var statearr_57290_57301 = state_57275;
(statearr_57290_57301[(1)] = cljs.core.first((state_57275[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57302 = state_57275;
state_57275 = G__57302;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_57275){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_57275);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57291 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57291[(6)] = c__2706__auto__);

return statearr_57291;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq57243){
var G__57244 = cljs.core.first(seq57243);
var seq57243__$1 = cljs.core.next(seq57243);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__57244,seq57243__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___57352 = arguments.length;
var i__5770__auto___57353 = (0);
while(true){
if((i__5770__auto___57353 < len__5769__auto___57352)){
args__5775__auto__.push((arguments[i__5770__auto___57353]));

var G__57354 = (i__5770__auto___57353 + (1));
i__5770__auto___57353 = G__57354;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57335){
var state_val_57336 = (state_57335[(1)]);
if((state_val_57336 === (1))){
var state_57335__$1 = state_57335;
var statearr_57337_57355 = state_57335__$1;
(statearr_57337_57355[(2)] = null);

(statearr_57337_57355[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57336 === (2))){
var _ = (function (){var statearr_57338 = state_57335;
(statearr_57338[(4)] = cljs.core.cons((5),(state_57335[(4)])));

return statearr_57338;
})();
var inst_57311 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_57335__$1 = state_57335;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57335__$1,(6),inst_57311);
} else {
if((state_val_57336 === (3))){
var inst_57333 = (state_57335[(2)]);
var state_57335__$1 = state_57335;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57335__$1,inst_57333);
} else {
if((state_val_57336 === (4))){
var inst_57305 = (state_57335[(2)]);
var state_57335__$1 = state_57335;
var statearr_57340_57356 = state_57335__$1;
(statearr_57340_57356[(2)] = inst_57305);

(statearr_57340_57356[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57336 === (5))){
var _ = (function (){var statearr_57341 = state_57335;
(statearr_57341[(4)] = cljs.core.rest((state_57335[(4)])));

return statearr_57341;
})();
var state_57335__$1 = state_57335;
var ex57339 = (state_57335__$1[(2)]);
var statearr_57342_57357 = state_57335__$1;
(statearr_57342_57357[(5)] = ex57339);


if((ex57339 instanceof Error)){
var statearr_57343_57358 = state_57335__$1;
(statearr_57343_57358[(1)] = (4));

(statearr_57343_57358[(5)] = null);

} else {
throw ex57339;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57336 === (6))){
var inst_57313 = (state_57335[(2)]);
var inst_57314 = fluree.db.util.async.throw_err(inst_57313);
var inst_57315 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_57314);
var inst_57316 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57317 = [inst_57314];
var inst_57318 = (new cljs.core.PersistentVector(null,1,(5),inst_57316,inst_57317,null));
var inst_57319 = cljs.core.count(inst_57318);
var inst_57320 = ((9) + inst_57319);
var inst_57321 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57322 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57323 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57324 = [inst_57314];
var inst_57325 = (new cljs.core.PersistentVector(null,1,(5),inst_57323,inst_57324,null));
var inst_57326 = ["/",inst_57325,inst_57315];
var inst_57327 = cljs.core.PersistentHashMap.fromArrays(inst_57322,inst_57326);
var inst_57328 = [inst_57327,inst_57320];
var inst_57329 = (new cljs.core.PersistentVector(null,2,(5),inst_57321,inst_57328,null));
var inst_57330 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57329);
var _ = (function (){var statearr_57344 = state_57335;
(statearr_57344[(4)] = cljs.core.rest((state_57335[(4)])));

return statearr_57344;
})();
var state_57335__$1 = (function (){var statearr_57345 = state_57335;
(statearr_57345[(7)] = inst_57330);

return statearr_57345;
})();
var statearr_57346_57359 = state_57335__$1;
(statearr_57346_57359[(2)] = inst_57315);

(statearr_57346_57359[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_57347 = [null,null,null,null,null,null,null,null];
(statearr_57347[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_57347[(1)] = (1));

return statearr_57347;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_57335){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57335);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57348){var ex__2687__auto__ = e57348;
var statearr_57349_57360 = state_57335;
(statearr_57349_57360[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57335[(4)]))){
var statearr_57350_57361 = state_57335;
(statearr_57350_57361[(1)] = cljs.core.first((state_57335[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57362 = state_57335;
state_57335 = G__57362;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_57335){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_57335);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57351 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57351[(6)] = c__2706__auto__);

return statearr_57351;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq57303){
var G__57304 = cljs.core.first(seq57303);
var seq57303__$1 = cljs.core.next(seq57303);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__57304,seq57303__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57400){
var state_val_57401 = (state_57400[(1)]);
if((state_val_57401 === (7))){
var state_57400__$1 = state_57400;
var statearr_57402_57426 = state_57400__$1;
(statearr_57402_57426[(2)] = n);

(statearr_57402_57426[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (1))){
var state_57400__$1 = state_57400;
var statearr_57403_57427 = state_57400__$1;
(statearr_57403_57427[(2)] = null);

(statearr_57403_57427[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (4))){
var inst_57363 = (state_57400[(2)]);
var state_57400__$1 = state_57400;
var statearr_57404_57428 = state_57400__$1;
(statearr_57404_57428[(2)] = inst_57363);

(statearr_57404_57428[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (13))){
var inst_57380 = (state_57400[(2)]);
var inst_57381 = fluree.db.util.async.throw_err(inst_57380);
var state_57400__$1 = state_57400;
var statearr_57405_57429 = state_57400__$1;
(statearr_57405_57429[(2)] = inst_57381);

(statearr_57405_57429[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (6))){
var state_57400__$1 = state_57400;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57400__$1,(9),n);
} else {
if((state_val_57401 === (3))){
var inst_57398 = (state_57400[(2)]);
var state_57400__$1 = state_57400;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57400__$1,inst_57398);
} else {
if((state_val_57401 === (12))){
var inst_57376 = (state_57400[(7)]);
var inst_57384 = (state_57400[(2)]);
var inst_57385 = fluree.db.dbfunctions.internal.quot(inst_57376,inst_57384);
var inst_57386 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57387 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57388 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57389 = [inst_57376,inst_57384];
var inst_57390 = (new cljs.core.PersistentVector(null,2,(5),inst_57388,inst_57389,null));
var inst_57391 = ["quot",inst_57390,inst_57385];
var inst_57392 = cljs.core.PersistentHashMap.fromArrays(inst_57387,inst_57391);
var inst_57393 = [inst_57392,(2)];
var inst_57394 = (new cljs.core.PersistentVector(null,2,(5),inst_57386,inst_57393,null));
var inst_57395 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57394);
var _ = (function (){var statearr_57406 = state_57400;
(statearr_57406[(4)] = cljs.core.rest((state_57400[(4)])));

return statearr_57406;
})();
var state_57400__$1 = (function (){var statearr_57407 = state_57400;
(statearr_57407[(8)] = inst_57395);

return statearr_57407;
})();
var statearr_57408_57430 = state_57400__$1;
(statearr_57408_57430[(2)] = inst_57385);

(statearr_57408_57430[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (2))){
var _ = (function (){var statearr_57409 = state_57400;
(statearr_57409[(4)] = cljs.core.cons((5),(state_57400[(4)])));

return statearr_57409;
})();
var inst_57369 = fluree.db.util.async.channel_QMARK_(n);
var state_57400__$1 = state_57400;
if(inst_57369){
var statearr_57410_57431 = state_57400__$1;
(statearr_57410_57431[(1)] = (6));

} else {
var statearr_57411_57432 = state_57400__$1;
(statearr_57411_57432[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (11))){
var state_57400__$1 = state_57400;
var statearr_57413_57433 = state_57400__$1;
(statearr_57413_57433[(2)] = d);

(statearr_57413_57433[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (9))){
var inst_57372 = (state_57400[(2)]);
var inst_57373 = fluree.db.util.async.throw_err(inst_57372);
var state_57400__$1 = state_57400;
var statearr_57414_57434 = state_57400__$1;
(statearr_57414_57434[(2)] = inst_57373);

(statearr_57414_57434[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (5))){
var _ = (function (){var statearr_57415 = state_57400;
(statearr_57415[(4)] = cljs.core.rest((state_57400[(4)])));

return statearr_57415;
})();
var state_57400__$1 = state_57400;
var ex57412 = (state_57400__$1[(2)]);
var statearr_57416_57435 = state_57400__$1;
(statearr_57416_57435[(5)] = ex57412);


if((ex57412 instanceof Error)){
var statearr_57417_57436 = state_57400__$1;
(statearr_57417_57436[(1)] = (4));

(statearr_57417_57436[(5)] = null);

} else {
throw ex57412;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57401 === (10))){
var state_57400__$1 = state_57400;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57400__$1,(13),d);
} else {
if((state_val_57401 === (8))){
var inst_57376 = (state_57400[(2)]);
var inst_57377 = fluree.db.util.async.channel_QMARK_(d);
var state_57400__$1 = (function (){var statearr_57418 = state_57400;
(statearr_57418[(7)] = inst_57376);

return statearr_57418;
})();
if(inst_57377){
var statearr_57419_57437 = state_57400__$1;
(statearr_57419_57437[(1)] = (10));

} else {
var statearr_57420_57438 = state_57400__$1;
(statearr_57420_57438[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto____0 = (function (){
var statearr_57421 = [null,null,null,null,null,null,null,null,null];
(statearr_57421[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto__);

(statearr_57421[(1)] = (1));

return statearr_57421;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto____1 = (function (state_57400){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57400);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57422){var ex__2687__auto__ = e57422;
var statearr_57423_57439 = state_57400;
(statearr_57423_57439[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57400[(4)]))){
var statearr_57424_57440 = state_57400;
(statearr_57424_57440[(1)] = cljs.core.first((state_57400[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57441 = state_57400;
state_57400 = G__57441;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto__ = function(state_57400){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto____1.call(this,state_57400);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57425 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57425[(6)] = c__2706__auto__);

return statearr_57425;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57479){
var state_val_57480 = (state_57479[(1)]);
if((state_val_57480 === (7))){
var state_57479__$1 = state_57479;
var statearr_57481_57505 = state_57479__$1;
(statearr_57481_57505[(2)] = n);

(statearr_57481_57505[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57480 === (1))){
var state_57479__$1 = state_57479;
var statearr_57482_57506 = state_57479__$1;
(statearr_57482_57506[(2)] = null);

(statearr_57482_57506[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57480 === (4))){
var inst_57442 = (state_57479[(2)]);
var state_57479__$1 = state_57479;
var statearr_57483_57507 = state_57479__$1;
(statearr_57483_57507[(2)] = inst_57442);

(statearr_57483_57507[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57480 === (13))){
var inst_57459 = (state_57479[(2)]);
var inst_57460 = fluree.db.util.async.throw_err(inst_57459);
var state_57479__$1 = state_57479;
var statearr_57484_57508 = state_57479__$1;
(statearr_57484_57508[(2)] = inst_57460);

(statearr_57484_57508[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57480 === (6))){
var state_57479__$1 = state_57479;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57479__$1,(9),n);
} else {
if((state_val_57480 === (3))){
var inst_57477 = (state_57479[(2)]);
var state_57479__$1 = state_57479;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57479__$1,inst_57477);
} else {
if((state_val_57480 === (12))){
var inst_57455 = (state_57479[(7)]);
var inst_57463 = (state_57479[(2)]);
var inst_57464 = fluree.db.dbfunctions.internal.mod(inst_57455,inst_57463);
var inst_57465 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57466 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57467 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57468 = [inst_57455,inst_57463];
var inst_57469 = (new cljs.core.PersistentVector(null,2,(5),inst_57467,inst_57468,null));
var inst_57470 = ["mod",inst_57469,inst_57464];
var inst_57471 = cljs.core.PersistentHashMap.fromArrays(inst_57466,inst_57470);
var inst_57472 = [inst_57471,(2)];
var inst_57473 = (new cljs.core.PersistentVector(null,2,(5),inst_57465,inst_57472,null));
var inst_57474 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57473);
var _ = (function (){var statearr_57485 = state_57479;
(statearr_57485[(4)] = cljs.core.rest((state_57479[(4)])));

return statearr_57485;
})();
var state_57479__$1 = (function (){var statearr_57486 = state_57479;
(statearr_57486[(8)] = inst_57474);

return statearr_57486;
})();
var statearr_57487_57509 = state_57479__$1;
(statearr_57487_57509[(2)] = inst_57464);

(statearr_57487_57509[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57480 === (2))){
var _ = (function (){var statearr_57488 = state_57479;
(statearr_57488[(4)] = cljs.core.cons((5),(state_57479[(4)])));

return statearr_57488;
})();
var inst_57448 = fluree.db.util.async.channel_QMARK_(n);
var state_57479__$1 = state_57479;
if(inst_57448){
var statearr_57489_57510 = state_57479__$1;
(statearr_57489_57510[(1)] = (6));

} else {
var statearr_57490_57511 = state_57479__$1;
(statearr_57490_57511[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57480 === (11))){
var state_57479__$1 = state_57479;
var statearr_57492_57512 = state_57479__$1;
(statearr_57492_57512[(2)] = d);

(statearr_57492_57512[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57480 === (9))){
var inst_57451 = (state_57479[(2)]);
var inst_57452 = fluree.db.util.async.throw_err(inst_57451);
var state_57479__$1 = state_57479;
var statearr_57493_57513 = state_57479__$1;
(statearr_57493_57513[(2)] = inst_57452);

(statearr_57493_57513[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57480 === (5))){
var _ = (function (){var statearr_57494 = state_57479;
(statearr_57494[(4)] = cljs.core.rest((state_57479[(4)])));

return statearr_57494;
})();
var state_57479__$1 = state_57479;
var ex57491 = (state_57479__$1[(2)]);
var statearr_57495_57514 = state_57479__$1;
(statearr_57495_57514[(5)] = ex57491);


if((ex57491 instanceof Error)){
var statearr_57496_57515 = state_57479__$1;
(statearr_57496_57515[(1)] = (4));

(statearr_57496_57515[(5)] = null);

} else {
throw ex57491;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57480 === (10))){
var state_57479__$1 = state_57479;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57479__$1,(13),d);
} else {
if((state_val_57480 === (8))){
var inst_57455 = (state_57479[(2)]);
var inst_57456 = fluree.db.util.async.channel_QMARK_(d);
var state_57479__$1 = (function (){var statearr_57497 = state_57479;
(statearr_57497[(7)] = inst_57455);

return statearr_57497;
})();
if(inst_57456){
var statearr_57498_57516 = state_57479__$1;
(statearr_57498_57516[(1)] = (10));

} else {
var statearr_57499_57517 = state_57479__$1;
(statearr_57499_57517[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto____0 = (function (){
var statearr_57500 = [null,null,null,null,null,null,null,null,null];
(statearr_57500[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto__);

(statearr_57500[(1)] = (1));

return statearr_57500;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto____1 = (function (state_57479){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57479);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57501){var ex__2687__auto__ = e57501;
var statearr_57502_57518 = state_57479;
(statearr_57502_57518[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57479[(4)]))){
var statearr_57503_57519 = state_57479;
(statearr_57503_57519[(1)] = cljs.core.first((state_57479[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57520 = state_57479;
state_57479 = G__57520;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto__ = function(state_57479){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto____1.call(this,state_57479);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57504 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57504[(6)] = c__2706__auto__);

return statearr_57504;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57558){
var state_val_57559 = (state_57558[(1)]);
if((state_val_57559 === (7))){
var state_57558__$1 = state_57558;
var statearr_57560_57584 = state_57558__$1;
(statearr_57560_57584[(2)] = n);

(statearr_57560_57584[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57559 === (1))){
var state_57558__$1 = state_57558;
var statearr_57561_57585 = state_57558__$1;
(statearr_57561_57585[(2)] = null);

(statearr_57561_57585[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57559 === (4))){
var inst_57521 = (state_57558[(2)]);
var state_57558__$1 = state_57558;
var statearr_57562_57586 = state_57558__$1;
(statearr_57562_57586[(2)] = inst_57521);

(statearr_57562_57586[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57559 === (13))){
var inst_57538 = (state_57558[(2)]);
var inst_57539 = fluree.db.util.async.throw_err(inst_57538);
var state_57558__$1 = state_57558;
var statearr_57563_57587 = state_57558__$1;
(statearr_57563_57587[(2)] = inst_57539);

(statearr_57563_57587[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57559 === (6))){
var state_57558__$1 = state_57558;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57558__$1,(9),n);
} else {
if((state_val_57559 === (3))){
var inst_57556 = (state_57558[(2)]);
var state_57558__$1 = state_57558;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57558__$1,inst_57556);
} else {
if((state_val_57559 === (12))){
var inst_57534 = (state_57558[(7)]);
var inst_57542 = (state_57558[(2)]);
var inst_57543 = fluree.db.dbfunctions.internal.rem(inst_57534,inst_57542);
var inst_57544 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57545 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57546 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57547 = [inst_57534,inst_57542];
var inst_57548 = (new cljs.core.PersistentVector(null,2,(5),inst_57546,inst_57547,null));
var inst_57549 = ["rem",inst_57548,inst_57543];
var inst_57550 = cljs.core.PersistentHashMap.fromArrays(inst_57545,inst_57549);
var inst_57551 = [inst_57550,(2)];
var inst_57552 = (new cljs.core.PersistentVector(null,2,(5),inst_57544,inst_57551,null));
var inst_57553 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57552);
var _ = (function (){var statearr_57564 = state_57558;
(statearr_57564[(4)] = cljs.core.rest((state_57558[(4)])));

return statearr_57564;
})();
var state_57558__$1 = (function (){var statearr_57565 = state_57558;
(statearr_57565[(8)] = inst_57553);

return statearr_57565;
})();
var statearr_57566_57588 = state_57558__$1;
(statearr_57566_57588[(2)] = inst_57543);

(statearr_57566_57588[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57559 === (2))){
var _ = (function (){var statearr_57567 = state_57558;
(statearr_57567[(4)] = cljs.core.cons((5),(state_57558[(4)])));

return statearr_57567;
})();
var inst_57527 = fluree.db.util.async.channel_QMARK_(n);
var state_57558__$1 = state_57558;
if(inst_57527){
var statearr_57568_57589 = state_57558__$1;
(statearr_57568_57589[(1)] = (6));

} else {
var statearr_57569_57590 = state_57558__$1;
(statearr_57569_57590[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57559 === (11))){
var state_57558__$1 = state_57558;
var statearr_57571_57591 = state_57558__$1;
(statearr_57571_57591[(2)] = d);

(statearr_57571_57591[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57559 === (9))){
var inst_57530 = (state_57558[(2)]);
var inst_57531 = fluree.db.util.async.throw_err(inst_57530);
var state_57558__$1 = state_57558;
var statearr_57572_57592 = state_57558__$1;
(statearr_57572_57592[(2)] = inst_57531);

(statearr_57572_57592[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57559 === (5))){
var _ = (function (){var statearr_57573 = state_57558;
(statearr_57573[(4)] = cljs.core.rest((state_57558[(4)])));

return statearr_57573;
})();
var state_57558__$1 = state_57558;
var ex57570 = (state_57558__$1[(2)]);
var statearr_57574_57593 = state_57558__$1;
(statearr_57574_57593[(5)] = ex57570);


if((ex57570 instanceof Error)){
var statearr_57575_57594 = state_57558__$1;
(statearr_57575_57594[(1)] = (4));

(statearr_57575_57594[(5)] = null);

} else {
throw ex57570;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57559 === (10))){
var state_57558__$1 = state_57558;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57558__$1,(13),d);
} else {
if((state_val_57559 === (8))){
var inst_57534 = (state_57558[(2)]);
var inst_57535 = fluree.db.util.async.channel_QMARK_(d);
var state_57558__$1 = (function (){var statearr_57576 = state_57558;
(statearr_57576[(7)] = inst_57534);

return statearr_57576;
})();
if(inst_57535){
var statearr_57577_57595 = state_57558__$1;
(statearr_57577_57595[(1)] = (10));

} else {
var statearr_57578_57596 = state_57558__$1;
(statearr_57578_57596[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto____0 = (function (){
var statearr_57579 = [null,null,null,null,null,null,null,null,null];
(statearr_57579[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto__);

(statearr_57579[(1)] = (1));

return statearr_57579;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto____1 = (function (state_57558){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57558);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57580){var ex__2687__auto__ = e57580;
var statearr_57581_57597 = state_57558;
(statearr_57581_57597[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57558[(4)]))){
var statearr_57582_57598 = state_57558;
(statearr_57582_57598[(1)] = cljs.core.first((state_57558[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57599 = state_57558;
state_57558 = G__57599;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto__ = function(state_57558){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto____1.call(this,state_57558);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57583 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57583[(6)] = c__2706__auto__);

return statearr_57583;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57626){
var state_val_57627 = (state_57626[(1)]);
if((state_val_57627 === (7))){
var state_57626__$1 = state_57626;
var statearr_57628_57647 = state_57626__$1;
(statearr_57628_57647[(2)] = x);

(statearr_57628_57647[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57627 === (1))){
var state_57626__$1 = state_57626;
var statearr_57629_57648 = state_57626__$1;
(statearr_57629_57648[(2)] = null);

(statearr_57629_57648[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57627 === (4))){
var inst_57600 = (state_57626[(2)]);
var state_57626__$1 = state_57626;
var statearr_57630_57649 = state_57626__$1;
(statearr_57630_57649[(2)] = inst_57600);

(statearr_57630_57649[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57627 === (6))){
var state_57626__$1 = state_57626;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57626__$1,(9),x);
} else {
if((state_val_57627 === (3))){
var inst_57624 = (state_57626[(2)]);
var state_57626__$1 = state_57626;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57626__$1,inst_57624);
} else {
if((state_val_57627 === (2))){
var _ = (function (){var statearr_57632 = state_57626;
(statearr_57632[(4)] = cljs.core.cons((5),(state_57626[(4)])));

return statearr_57632;
})();
var inst_57606 = fluree.db.util.async.channel_QMARK_(x);
var state_57626__$1 = state_57626;
if(inst_57606){
var statearr_57633_57650 = state_57626__$1;
(statearr_57633_57650[(1)] = (6));

} else {
var statearr_57634_57651 = state_57626__$1;
(statearr_57634_57651[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57627 === (9))){
var inst_57609 = (state_57626[(2)]);
var inst_57610 = fluree.db.util.async.throw_err(inst_57609);
var state_57626__$1 = state_57626;
var statearr_57635_57652 = state_57626__$1;
(statearr_57635_57652[(2)] = inst_57610);

(statearr_57635_57652[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57627 === (5))){
var _ = (function (){var statearr_57636 = state_57626;
(statearr_57636[(4)] = cljs.core.rest((state_57626[(4)])));

return statearr_57636;
})();
var state_57626__$1 = state_57626;
var ex57631 = (state_57626__$1[(2)]);
var statearr_57637_57653 = state_57626__$1;
(statearr_57637_57653[(5)] = ex57631);


if((ex57631 instanceof Error)){
var statearr_57638_57654 = state_57626__$1;
(statearr_57638_57654[(1)] = (4));

(statearr_57638_57654[(5)] = null);

} else {
throw ex57631;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57627 === (8))){
var inst_57613 = (state_57626[(2)]);
var inst_57614 = fluree.db.dbfunctions.internal.boolean$(inst_57613);
var inst_57615 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57616 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57617 = ["boolean",inst_57613,inst_57614];
var inst_57618 = cljs.core.PersistentHashMap.fromArrays(inst_57616,inst_57617);
var inst_57619 = [inst_57618,(10)];
var inst_57620 = (new cljs.core.PersistentVector(null,2,(5),inst_57615,inst_57619,null));
var inst_57621 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57620);
var _ = (function (){var statearr_57639 = state_57626;
(statearr_57639[(4)] = cljs.core.rest((state_57626[(4)])));

return statearr_57639;
})();
var state_57626__$1 = (function (){var statearr_57640 = state_57626;
(statearr_57640[(7)] = inst_57621);

return statearr_57640;
})();
var statearr_57641_57655 = state_57626__$1;
(statearr_57641_57655[(2)] = inst_57614);

(statearr_57641_57655[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto____0 = (function (){
var statearr_57642 = [null,null,null,null,null,null,null,null];
(statearr_57642[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto__);

(statearr_57642[(1)] = (1));

return statearr_57642;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto____1 = (function (state_57626){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57626);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57643){var ex__2687__auto__ = e57643;
var statearr_57644_57656 = state_57626;
(statearr_57644_57656[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57626[(4)]))){
var statearr_57645_57657 = state_57626;
(statearr_57645_57657[(1)] = cljs.core.first((state_57626[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57658 = state_57626;
state_57626 = G__57658;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto__ = function(state_57626){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto____1.call(this,state_57626);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57646 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57646[(6)] = c__2706__auto__);

return statearr_57646;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57696){
var state_val_57697 = (state_57696[(1)]);
if((state_val_57697 === (7))){
var state_57696__$1 = state_57696;
var statearr_57698_57722 = state_57696__$1;
(statearr_57698_57722[(2)] = pattern);

(statearr_57698_57722[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57697 === (1))){
var state_57696__$1 = state_57696;
var statearr_57699_57723 = state_57696__$1;
(statearr_57699_57723[(2)] = null);

(statearr_57699_57723[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57697 === (4))){
var inst_57659 = (state_57696[(2)]);
var state_57696__$1 = state_57696;
var statearr_57700_57724 = state_57696__$1;
(statearr_57700_57724[(2)] = inst_57659);

(statearr_57700_57724[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57697 === (13))){
var inst_57676 = (state_57696[(2)]);
var inst_57677 = fluree.db.util.async.throw_err(inst_57676);
var state_57696__$1 = state_57696;
var statearr_57701_57725 = state_57696__$1;
(statearr_57701_57725[(2)] = inst_57677);

(statearr_57701_57725[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57697 === (6))){
var state_57696__$1 = state_57696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57696__$1,(9),pattern);
} else {
if((state_val_57697 === (3))){
var inst_57694 = (state_57696[(2)]);
var state_57696__$1 = state_57696;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57696__$1,inst_57694);
} else {
if((state_val_57697 === (12))){
var inst_57672 = (state_57696[(7)]);
var inst_57680 = (state_57696[(2)]);
var inst_57681 = fluree.db.dbfunctions.internal.re_find(inst_57672,inst_57680);
var inst_57682 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57683 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57684 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57685 = [inst_57672,inst_57680];
var inst_57686 = (new cljs.core.PersistentVector(null,2,(5),inst_57684,inst_57685,null));
var inst_57687 = ["re-find",inst_57686,inst_57681];
var inst_57688 = cljs.core.PersistentHashMap.fromArrays(inst_57683,inst_57687);
var inst_57689 = [inst_57688,(10)];
var inst_57690 = (new cljs.core.PersistentVector(null,2,(5),inst_57682,inst_57689,null));
var inst_57691 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57690);
var _ = (function (){var statearr_57702 = state_57696;
(statearr_57702[(4)] = cljs.core.rest((state_57696[(4)])));

return statearr_57702;
})();
var state_57696__$1 = (function (){var statearr_57703 = state_57696;
(statearr_57703[(8)] = inst_57691);

return statearr_57703;
})();
var statearr_57704_57726 = state_57696__$1;
(statearr_57704_57726[(2)] = inst_57681);

(statearr_57704_57726[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57697 === (2))){
var _ = (function (){var statearr_57705 = state_57696;
(statearr_57705[(4)] = cljs.core.cons((5),(state_57696[(4)])));

return statearr_57705;
})();
var inst_57665 = fluree.db.util.async.channel_QMARK_(pattern);
var state_57696__$1 = state_57696;
if(inst_57665){
var statearr_57706_57727 = state_57696__$1;
(statearr_57706_57727[(1)] = (6));

} else {
var statearr_57707_57728 = state_57696__$1;
(statearr_57707_57728[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57697 === (11))){
var state_57696__$1 = state_57696;
var statearr_57709_57729 = state_57696__$1;
(statearr_57709_57729[(2)] = string);

(statearr_57709_57729[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57697 === (9))){
var inst_57668 = (state_57696[(2)]);
var inst_57669 = fluree.db.util.async.throw_err(inst_57668);
var state_57696__$1 = state_57696;
var statearr_57710_57730 = state_57696__$1;
(statearr_57710_57730[(2)] = inst_57669);

(statearr_57710_57730[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57697 === (5))){
var _ = (function (){var statearr_57711 = state_57696;
(statearr_57711[(4)] = cljs.core.rest((state_57696[(4)])));

return statearr_57711;
})();
var state_57696__$1 = state_57696;
var ex57708 = (state_57696__$1[(2)]);
var statearr_57712_57731 = state_57696__$1;
(statearr_57712_57731[(5)] = ex57708);


if((ex57708 instanceof Error)){
var statearr_57713_57732 = state_57696__$1;
(statearr_57713_57732[(1)] = (4));

(statearr_57713_57732[(5)] = null);

} else {
throw ex57708;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57697 === (10))){
var state_57696__$1 = state_57696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57696__$1,(13),string);
} else {
if((state_val_57697 === (8))){
var inst_57672 = (state_57696[(2)]);
var inst_57673 = fluree.db.util.async.channel_QMARK_(string);
var state_57696__$1 = (function (){var statearr_57714 = state_57696;
(statearr_57714[(7)] = inst_57672);

return statearr_57714;
})();
if(inst_57673){
var statearr_57715_57733 = state_57696__$1;
(statearr_57715_57733[(1)] = (10));

} else {
var statearr_57716_57734 = state_57696__$1;
(statearr_57716_57734[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto____0 = (function (){
var statearr_57717 = [null,null,null,null,null,null,null,null,null];
(statearr_57717[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto__);

(statearr_57717[(1)] = (1));

return statearr_57717;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto____1 = (function (state_57696){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57696);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57718){var ex__2687__auto__ = e57718;
var statearr_57719_57735 = state_57696;
(statearr_57719_57735[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57696[(4)]))){
var statearr_57720_57736 = state_57696;
(statearr_57720_57736[(1)] = cljs.core.first((state_57696[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57737 = state_57696;
state_57696 = G__57737;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto__ = function(state_57696){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto____1.call(this,state_57696);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57721 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57721[(6)] = c__2706__auto__);

return statearr_57721;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57764){
var state_val_57765 = (state_57764[(1)]);
if((state_val_57765 === (7))){
var state_57764__$1 = state_57764;
var statearr_57766_57785 = state_57764__$1;
(statearr_57766_57785[(2)] = email);

(statearr_57766_57785[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57765 === (1))){
var state_57764__$1 = state_57764;
var statearr_57767_57786 = state_57764__$1;
(statearr_57767_57786[(2)] = null);

(statearr_57767_57786[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57765 === (4))){
var inst_57738 = (state_57764[(2)]);
var state_57764__$1 = state_57764;
var statearr_57768_57787 = state_57764__$1;
(statearr_57768_57787[(2)] = inst_57738);

(statearr_57768_57787[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57765 === (6))){
var state_57764__$1 = state_57764;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57764__$1,(9),email);
} else {
if((state_val_57765 === (3))){
var inst_57762 = (state_57764[(2)]);
var state_57764__$1 = state_57764;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57764__$1,inst_57762);
} else {
if((state_val_57765 === (2))){
var _ = (function (){var statearr_57770 = state_57764;
(statearr_57770[(4)] = cljs.core.cons((5),(state_57764[(4)])));

return statearr_57770;
})();
var inst_57744 = fluree.db.util.async.channel_QMARK_(email);
var state_57764__$1 = state_57764;
if(inst_57744){
var statearr_57771_57788 = state_57764__$1;
(statearr_57771_57788[(1)] = (6));

} else {
var statearr_57772_57789 = state_57764__$1;
(statearr_57772_57789[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57765 === (9))){
var inst_57747 = (state_57764[(2)]);
var inst_57748 = fluree.db.util.async.throw_err(inst_57747);
var state_57764__$1 = state_57764;
var statearr_57773_57790 = state_57764__$1;
(statearr_57773_57790[(2)] = inst_57748);

(statearr_57773_57790[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57765 === (5))){
var _ = (function (){var statearr_57774 = state_57764;
(statearr_57774[(4)] = cljs.core.rest((state_57764[(4)])));

return statearr_57774;
})();
var state_57764__$1 = state_57764;
var ex57769 = (state_57764__$1[(2)]);
var statearr_57775_57791 = state_57764__$1;
(statearr_57775_57791[(5)] = ex57769);


if((ex57769 instanceof Error)){
var statearr_57776_57792 = state_57764__$1;
(statearr_57776_57792[(1)] = (4));

(statearr_57776_57792[(5)] = null);

} else {
throw ex57769;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57765 === (8))){
var inst_57751 = (state_57764[(2)]);
var inst_57752 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_57751);
var inst_57753 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57754 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57755 = ["re-find",inst_57751,inst_57752];
var inst_57756 = cljs.core.PersistentHashMap.fromArrays(inst_57754,inst_57755);
var inst_57757 = [inst_57756,(10)];
var inst_57758 = (new cljs.core.PersistentVector(null,2,(5),inst_57753,inst_57757,null));
var inst_57759 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57758);
var _ = (function (){var statearr_57777 = state_57764;
(statearr_57777[(4)] = cljs.core.rest((state_57764[(4)])));

return statearr_57777;
})();
var state_57764__$1 = (function (){var statearr_57778 = state_57764;
(statearr_57778[(7)] = inst_57759);

return statearr_57778;
})();
var statearr_57779_57793 = state_57764__$1;
(statearr_57779_57793[(2)] = inst_57752);

(statearr_57779_57793[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_57780 = [null,null,null,null,null,null,null,null];
(statearr_57780[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto__);

(statearr_57780[(1)] = (1));

return statearr_57780;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto____1 = (function (state_57764){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57764);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57781){var ex__2687__auto__ = e57781;
var statearr_57782_57794 = state_57764;
(statearr_57782_57794[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57764[(4)]))){
var statearr_57783_57795 = state_57764;
(statearr_57783_57795[(1)] = cljs.core.first((state_57764[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57796 = state_57764;
state_57764 = G__57796;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto__ = function(state_57764){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto____1.call(this,state_57764);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57784 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57784[(6)] = c__2706__auto__);

return statearr_57784;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57843){
var state_val_57844 = (state_57843[(1)]);
if((state_val_57844 === (7))){
var inst_57813 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57843__$1 = state_57843;
if(cljs.core.truth_(inst_57813)){
var statearr_57845_57872 = state_57843__$1;
(statearr_57845_57872[(1)] = (9));

} else {
var statearr_57846_57873 = state_57843__$1;
(statearr_57846_57873[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57844 === (1))){
var state_57843__$1 = state_57843;
var statearr_57847_57874 = state_57843__$1;
(statearr_57847_57874[(2)] = null);

(statearr_57847_57874[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57844 === (4))){
var inst_57797 = (state_57843[(2)]);
var state_57843__$1 = state_57843;
var statearr_57848_57875 = state_57843__$1;
(statearr_57848_57875[(2)] = inst_57797);

(statearr_57848_57875[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57844 === (15))){
var inst_57824 = (state_57843[(2)]);
var state_57843__$1 = state_57843;
var statearr_57849_57876 = state_57843__$1;
(statearr_57849_57876[(2)] = inst_57824);

(statearr_57849_57876[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57844 === (13))){
var inst_57821 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_57843__$1 = state_57843;
var statearr_57850_57877 = state_57843__$1;
(statearr_57850_57877[(2)] = inst_57821);

(statearr_57850_57877[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57844 === (6))){
var inst_57808 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57809 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_57810 = [inst_57809,(0)];
var inst_57811 = (new cljs.core.PersistentVector(null,2,(5),inst_57808,inst_57810,null));
var state_57843__$1 = state_57843;
var statearr_57851_57878 = state_57843__$1;
(statearr_57851_57878[(2)] = inst_57811);

(statearr_57851_57878[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57844 === (3))){
var inst_57841 = (state_57843[(2)]);
var state_57843__$1 = state_57843;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57843__$1,inst_57841);
} else {
if((state_val_57844 === (12))){
var inst_57817 = (state_57843[(2)]);
var inst_57818 = fluree.db.util.async.throw_err(inst_57817);
var state_57843__$1 = state_57843;
var statearr_57852_57879 = state_57843__$1;
(statearr_57852_57879[(2)] = inst_57818);

(statearr_57852_57879[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57844 === (2))){
var _ = (function (){var statearr_57853 = state_57843;
(statearr_57853[(4)] = cljs.core.cons((5),(state_57843[(4)])));

return statearr_57853;
})();
var inst_57806 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57843__$1 = state_57843;
if(cljs.core.truth_(inst_57806)){
var statearr_57854_57880 = state_57843__$1;
(statearr_57854_57880[(1)] = (6));

} else {
var statearr_57855_57881 = state_57843__$1;
(statearr_57855_57881[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57844 === (11))){
var inst_57826 = (state_57843[(2)]);
var state_57843__$1 = state_57843;
var statearr_57857_57882 = state_57843__$1;
(statearr_57857_57882[(2)] = inst_57826);

(statearr_57857_57882[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57844 === (9))){
var inst_57815 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_57843__$1 = state_57843;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57843__$1,(12),inst_57815);
} else {
if((state_val_57844 === (5))){
var _ = (function (){var statearr_57858 = state_57843;
(statearr_57858[(4)] = cljs.core.rest((state_57843[(4)])));

return statearr_57858;
})();
var state_57843__$1 = state_57843;
var ex57856 = (state_57843__$1[(2)]);
var statearr_57859_57883 = state_57843__$1;
(statearr_57859_57883[(5)] = ex57856);


if((ex57856 instanceof Error)){
var statearr_57860_57884 = state_57843__$1;
(statearr_57860_57884[(1)] = (4));

(statearr_57860_57884[(5)] = null);

} else {
throw ex57856;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57844 === (14))){
var state_57843__$1 = state_57843;
var statearr_57861_57885 = state_57843__$1;
(statearr_57861_57885[(2)] = null);

(statearr_57861_57885[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57844 === (10))){
var state_57843__$1 = state_57843;
var statearr_57862_57886 = state_57843__$1;
(statearr_57862_57886[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57844 === (8))){
var inst_57828 = (state_57843[(2)]);
var inst_57829 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_57828,(0),null);
var inst_57830 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_57828,(1),null);
var inst_57831 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57832 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57833 = ["?user_id","?ctx",inst_57829];
var inst_57834 = cljs.core.PersistentHashMap.fromArrays(inst_57832,inst_57833);
var inst_57835 = ((10) + inst_57830);
var inst_57836 = [inst_57834,inst_57835];
var inst_57837 = (new cljs.core.PersistentVector(null,2,(5),inst_57831,inst_57836,null));
var inst_57838 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57837);
var _ = (function (){var statearr_57864 = state_57843;
(statearr_57864[(4)] = cljs.core.rest((state_57843[(4)])));

return statearr_57864;
})();
var state_57843__$1 = (function (){var statearr_57865 = state_57843;
(statearr_57865[(7)] = inst_57838);

return statearr_57865;
})();
var statearr_57866_57887 = state_57843__$1;
(statearr_57866_57887[(2)] = inst_57829);

(statearr_57866_57887[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto____0 = (function (){
var statearr_57867 = [null,null,null,null,null,null,null,null];
(statearr_57867[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto__);

(statearr_57867[(1)] = (1));

return statearr_57867;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto____1 = (function (state_57843){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57843);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57868){var ex__2687__auto__ = e57868;
var statearr_57869_57888 = state_57843;
(statearr_57869_57888[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57843[(4)]))){
var statearr_57870_57889 = state_57843;
(statearr_57870_57889[(1)] = cljs.core.first((state_57843[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57890 = state_57843;
state_57843 = G__57890;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto__ = function(state_57843){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto____1.call(this,state_57843);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57871 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57871[(6)] = c__2706__auto__);

return statearr_57871;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57918){
var state_val_57919 = (state_57918[(1)]);
if((state_val_57919 === (7))){
var inst_57911 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_57918__$1 = state_57918;
var statearr_57920_57939 = state_57918__$1;
(statearr_57920_57939[(2)] = inst_57911);

(statearr_57920_57939[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57919 === (1))){
var state_57918__$1 = state_57918;
var statearr_57921_57940 = state_57918__$1;
(statearr_57921_57940[(2)] = null);

(statearr_57921_57940[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57919 === (4))){
var inst_57891 = (state_57918[(2)]);
var state_57918__$1 = state_57918;
var statearr_57922_57941 = state_57918__$1;
(statearr_57922_57941[(2)] = inst_57891);

(statearr_57922_57941[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57919 === (6))){
var inst_57899 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_57918__$1 = state_57918;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57918__$1,(9),inst_57899);
} else {
if((state_val_57919 === (3))){
var inst_57916 = (state_57918[(2)]);
var state_57918__$1 = state_57918;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57918__$1,inst_57916);
} else {
if((state_val_57919 === (2))){
var _ = (function (){var statearr_57924 = state_57918;
(statearr_57924[(4)] = cljs.core.cons((5),(state_57918[(4)])));

return statearr_57924;
})();
var inst_57897 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57918__$1 = state_57918;
if(cljs.core.truth_(inst_57897)){
var statearr_57925_57942 = state_57918__$1;
(statearr_57925_57942[(1)] = (6));

} else {
var statearr_57926_57943 = state_57918__$1;
(statearr_57926_57943[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57919 === (9))){
var inst_57901 = (state_57918[(2)]);
var inst_57902 = fluree.db.util.async.throw_err(inst_57901);
var inst_57903 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57904 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57905 = ["?auth_id","?ctx",inst_57902];
var inst_57906 = cljs.core.PersistentHashMap.fromArrays(inst_57904,inst_57905);
var inst_57907 = [inst_57906,(10)];
var inst_57908 = (new cljs.core.PersistentVector(null,2,(5),inst_57903,inst_57907,null));
var inst_57909 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57908);
var state_57918__$1 = (function (){var statearr_57927 = state_57918;
(statearr_57927[(7)] = inst_57909);

return statearr_57927;
})();
var statearr_57928_57944 = state_57918__$1;
(statearr_57928_57944[(2)] = inst_57902);

(statearr_57928_57944[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57919 === (5))){
var _ = (function (){var statearr_57929 = state_57918;
(statearr_57929[(4)] = cljs.core.rest((state_57918[(4)])));

return statearr_57929;
})();
var state_57918__$1 = state_57918;
var ex57923 = (state_57918__$1[(2)]);
var statearr_57930_57945 = state_57918__$1;
(statearr_57930_57945[(5)] = ex57923);


if((ex57923 instanceof Error)){
var statearr_57931_57946 = state_57918__$1;
(statearr_57931_57946[(1)] = (4));

(statearr_57931_57946[(5)] = null);

} else {
throw ex57923;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57919 === (8))){
var inst_57913 = (state_57918[(2)]);
var _ = (function (){var statearr_57932 = state_57918;
(statearr_57932[(4)] = cljs.core.rest((state_57918[(4)])));

return statearr_57932;
})();
var state_57918__$1 = state_57918;
var statearr_57933_57947 = state_57918__$1;
(statearr_57933_57947[(2)] = inst_57913);

(statearr_57933_57947[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto____0 = (function (){
var statearr_57934 = [null,null,null,null,null,null,null,null];
(statearr_57934[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto__);

(statearr_57934[(1)] = (1));

return statearr_57934;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto____1 = (function (state_57918){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57918);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e57935){var ex__2687__auto__ = e57935;
var statearr_57936_57948 = state_57918;
(statearr_57936_57948[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57918[(4)]))){
var statearr_57937_57949 = state_57918;
(statearr_57937_57949[(1)] = cljs.core.first((state_57918[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57950 = state_57918;
state_57918 = G__57950;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto__ = function(state_57918){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto____1.call(this,state_57918);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_57938 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_57938[(6)] = c__2706__auto__);

return statearr_57938;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__57952 = arguments.length;
switch (G__57952) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_57994){
var state_val_57995 = (state_57994[(1)]);
if((state_val_57995 === (7))){
var state_57994__$1 = state_57994;
var statearr_57996_58026 = state_57994__$1;
(statearr_57996_58026[(2)] = seed);

(statearr_57996_58026[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57995 === (1))){
var state_57994__$1 = state_57994;
var statearr_57997_58027 = state_57994__$1;
(statearr_57997_58027[(2)] = null);

(statearr_57997_58027[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57995 === (4))){
var inst_57953 = (state_57994[(2)]);
var state_57994__$1 = state_57994;
var statearr_57998_58028 = state_57994__$1;
(statearr_57998_58028[(2)] = inst_57953);

(statearr_57998_58028[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57995 === (15))){
var state_57994__$1 = state_57994;
var statearr_57999_58029 = state_57994__$1;
(statearr_57999_58029[(2)] = (10));

(statearr_57999_58029[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57995 === (13))){
var inst_57970 = (state_57994[(2)]);
var inst_57971 = fluree.db.util.async.throw_err(inst_57970);
var state_57994__$1 = state_57994;
var statearr_58000_58030 = state_57994__$1;
(statearr_58000_58030[(2)] = inst_57971);

(statearr_58000_58030[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57995 === (6))){
var state_57994__$1 = state_57994;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57994__$1,(9),seed);
} else {
if((state_val_57995 === (3))){
var inst_57992 = (state_57994[(2)]);
var state_57994__$1 = state_57994;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57994__$1,inst_57992);
} else {
if((state_val_57995 === (12))){
var inst_57974 = (state_57994[(7)]);
var inst_57974__$1 = (state_57994[(2)]);
var state_57994__$1 = (function (){var statearr_58001 = state_57994;
(statearr_58001[(7)] = inst_57974__$1);

return statearr_58001;
})();
if(cljs.core.truth_(inst_57974__$1)){
var statearr_58002_58031 = state_57994__$1;
(statearr_58002_58031[(1)] = (14));

} else {
var statearr_58003_58032 = state_57994__$1;
(statearr_58003_58032[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57995 === (2))){
var _ = (function (){var statearr_58004 = state_57994;
(statearr_58004[(4)] = cljs.core.cons((5),(state_57994[(4)])));

return statearr_58004;
})();
var inst_57959 = fluree.db.util.async.channel_QMARK_(seed);
var state_57994__$1 = state_57994;
if(inst_57959){
var statearr_58005_58033 = state_57994__$1;
(statearr_58005_58033[(1)] = (6));

} else {
var statearr_58006_58034 = state_57994__$1;
(statearr_58006_58034[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57995 === (11))){
var state_57994__$1 = state_57994;
var statearr_58008_58035 = state_57994__$1;
(statearr_58008_58035[(2)] = max);

(statearr_58008_58035[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57995 === (9))){
var inst_57962 = (state_57994[(2)]);
var inst_57963 = fluree.db.util.async.throw_err(inst_57962);
var state_57994__$1 = state_57994;
var statearr_58009_58036 = state_57994__$1;
(statearr_58009_58036[(2)] = inst_57963);

(statearr_58009_58036[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57995 === (5))){
var _ = (function (){var statearr_58010 = state_57994;
(statearr_58010[(4)] = cljs.core.rest((state_57994[(4)])));

return statearr_58010;
})();
var state_57994__$1 = state_57994;
var ex58007 = (state_57994__$1[(2)]);
var statearr_58011_58037 = state_57994__$1;
(statearr_58011_58037[(5)] = ex58007);


if((ex58007 instanceof Error)){
var statearr_58012_58038 = state_57994__$1;
(statearr_58012_58038[(1)] = (4));

(statearr_58012_58038[(5)] = null);

} else {
throw ex58007;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57995 === (14))){
var inst_57974 = (state_57994[(7)]);
var state_57994__$1 = state_57994;
var statearr_58013_58039 = state_57994__$1;
(statearr_58013_58039[(2)] = inst_57974);

(statearr_58013_58039[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57995 === (16))){
var inst_57966 = (state_57994[(8)]);
var inst_57978 = (state_57994[(2)]);
var inst_57979 = fluree.db.dbfunctions.internal.rand(inst_57966,inst_57978);
var inst_57980 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57981 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57982 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57983 = [max,seed];
var inst_57984 = (new cljs.core.PersistentVector(null,2,(5),inst_57982,inst_57983,null));
var inst_57985 = ["rand",inst_57984,inst_57979];
var inst_57986 = cljs.core.PersistentHashMap.fromArrays(inst_57981,inst_57985);
var inst_57987 = [inst_57986,(10)];
var inst_57988 = (new cljs.core.PersistentVector(null,2,(5),inst_57980,inst_57987,null));
var inst_57989 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57988);
var _ = (function (){var statearr_58014 = state_57994;
(statearr_58014[(4)] = cljs.core.rest((state_57994[(4)])));

return statearr_58014;
})();
var state_57994__$1 = (function (){var statearr_58015 = state_57994;
(statearr_58015[(9)] = inst_57989);

return statearr_58015;
})();
var statearr_58016_58040 = state_57994__$1;
(statearr_58016_58040[(2)] = inst_57979);

(statearr_58016_58040[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57995 === (10))){
var state_57994__$1 = state_57994;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57994__$1,(13),max);
} else {
if((state_val_57995 === (8))){
var inst_57966 = (state_57994[(2)]);
var inst_57967 = fluree.db.util.async.channel_QMARK_(max);
var state_57994__$1 = (function (){var statearr_58017 = state_57994;
(statearr_58017[(8)] = inst_57966);

return statearr_58017;
})();
if(inst_57967){
var statearr_58018_58041 = state_57994__$1;
(statearr_58018_58041[(1)] = (10));

} else {
var statearr_58019_58042 = state_57994__$1;
(statearr_58019_58042[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2684__auto____0 = (function (){
var statearr_58020 = [null,null,null,null,null,null,null,null,null,null];
(statearr_58020[(0)] = fluree$db$dbfunctions$fns$state_machine__2684__auto__);

(statearr_58020[(1)] = (1));

return statearr_58020;
});
var fluree$db$dbfunctions$fns$state_machine__2684__auto____1 = (function (state_57994){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_57994);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e58021){var ex__2687__auto__ = e58021;
var statearr_58022_58043 = state_57994;
(statearr_58022_58043[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_57994[(4)]))){
var statearr_58023_58044 = state_57994;
(statearr_58023_58044[(1)] = cljs.core.first((state_57994[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58045 = state_57994;
state_57994 = G__58045;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2684__auto__ = function(state_57994){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2684__auto____1.call(this,state_57994);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_58024 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_58024[(6)] = c__2706__auto__);

return statearr_58024;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_58066){
var state_val_58067 = (state_58066[(1)]);
if((state_val_58067 === (1))){
var state_58066__$1 = state_58066;
var statearr_58068_58083 = state_58066__$1;
(statearr_58068_58083[(2)] = null);

(statearr_58068_58083[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58067 === (2))){
var _ = (function (){var statearr_58069 = state_58066;
(statearr_58069[(4)] = cljs.core.cons((5),(state_58066[(4)])));

return statearr_58069;
})();
var inst_58052 = cljs.core.random_uuid();
var inst_58053 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_58052);
var inst_58054 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58055 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_58056 = cljs.core.PersistentVector.EMPTY;
var inst_58057 = ["uuid",inst_58056,inst_58053];
var inst_58058 = cljs.core.PersistentHashMap.fromArrays(inst_58055,inst_58057);
var inst_58059 = [inst_58058,(10)];
var inst_58060 = (new cljs.core.PersistentVector(null,2,(5),inst_58054,inst_58059,null));
var inst_58061 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_58060);
var ___$1 = (function (){var statearr_58070 = state_58066;
(statearr_58070[(4)] = cljs.core.rest((state_58066[(4)])));

return statearr_58070;
})();
var state_58066__$1 = (function (){var statearr_58071 = state_58066;
(statearr_58071[(7)] = inst_58061);

return statearr_58071;
})();
var statearr_58072_58084 = state_58066__$1;
(statearr_58072_58084[(2)] = inst_58053);

(statearr_58072_58084[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58067 === (3))){
var inst_58064 = (state_58066[(2)]);
var state_58066__$1 = state_58066;
return cljs.core.async.impl.ioc_helpers.return_chan(state_58066__$1,inst_58064);
} else {
if((state_val_58067 === (4))){
var inst_58046 = (state_58066[(2)]);
var state_58066__$1 = state_58066;
var statearr_58074_58085 = state_58066__$1;
(statearr_58074_58085[(2)] = inst_58046);

(statearr_58074_58085[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58067 === (5))){
var _ = (function (){var statearr_58075 = state_58066;
(statearr_58075[(4)] = cljs.core.rest((state_58066[(4)])));

return statearr_58075;
})();
var state_58066__$1 = state_58066;
var ex58073 = (state_58066__$1[(2)]);
var statearr_58076_58086 = state_58066__$1;
(statearr_58076_58086[(5)] = ex58073);


if((ex58073 instanceof Error)){
var statearr_58077_58087 = state_58066__$1;
(statearr_58077_58087[(1)] = (4));

(statearr_58077_58087[(5)] = null);

} else {
throw ex58073;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto____0 = (function (){
var statearr_58078 = [null,null,null,null,null,null,null,null];
(statearr_58078[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto__);

(statearr_58078[(1)] = (1));

return statearr_58078;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto____1 = (function (state_58066){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_58066);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e58079){var ex__2687__auto__ = e58079;
var statearr_58080_58088 = state_58066;
(statearr_58080_58088[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_58066[(4)]))){
var statearr_58081_58089 = state_58066;
(statearr_58081_58089[(1)] = cljs.core.first((state_58066[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58090 = state_58066;
state_58066 = G__58090;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto__ = function(state_58066){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto____1.call(this,state_58066);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_58082 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_58082[(6)] = c__2706__auto__);

return statearr_58082;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_58120){
var state_val_58121 = (state_58120[(1)]);
if((state_val_58121 === (7))){
var state_58120__$1 = state_58120;
var statearr_58122_58141 = state_58120__$1;
(statearr_58122_58141[(2)] = num);

(statearr_58122_58141[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58121 === (1))){
var state_58120__$1 = state_58120;
var statearr_58123_58142 = state_58120__$1;
(statearr_58123_58142[(2)] = null);

(statearr_58123_58142[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58121 === (4))){
var inst_58091 = (state_58120[(2)]);
var state_58120__$1 = state_58120;
var statearr_58124_58143 = state_58120__$1;
(statearr_58124_58143[(2)] = inst_58091);

(statearr_58124_58143[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58121 === (6))){
var state_58120__$1 = state_58120;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58120__$1,(9),num);
} else {
if((state_val_58121 === (3))){
var inst_58118 = (state_58120[(2)]);
var state_58120__$1 = state_58120;
return cljs.core.async.impl.ioc_helpers.return_chan(state_58120__$1,inst_58118);
} else {
if((state_val_58121 === (2))){
var _ = (function (){var statearr_58126 = state_58120;
(statearr_58126[(4)] = cljs.core.cons((5),(state_58120[(4)])));

return statearr_58126;
})();
var inst_58097 = fluree.db.util.async.channel_QMARK_(num);
var state_58120__$1 = state_58120;
if(inst_58097){
var statearr_58127_58144 = state_58120__$1;
(statearr_58127_58144[(1)] = (6));

} else {
var statearr_58128_58145 = state_58120__$1;
(statearr_58128_58145[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58121 === (9))){
var inst_58100 = (state_58120[(2)]);
var inst_58101 = fluree.db.util.async.throw_err(inst_58100);
var state_58120__$1 = state_58120;
var statearr_58129_58146 = state_58120__$1;
(statearr_58129_58146[(2)] = inst_58101);

(statearr_58129_58146[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58121 === (5))){
var _ = (function (){var statearr_58130 = state_58120;
(statearr_58130[(4)] = cljs.core.rest((state_58120[(4)])));

return statearr_58130;
})();
var state_58120__$1 = state_58120;
var ex58125 = (state_58120__$1[(2)]);
var statearr_58131_58147 = state_58120__$1;
(statearr_58131_58147[(5)] = ex58125);


if((ex58125 instanceof Error)){
var statearr_58132_58148 = state_58120__$1;
(statearr_58132_58148[(1)] = (4));

(statearr_58132_58148[(5)] = null);

} else {
throw ex58125;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58121 === (8))){
var inst_58104 = (state_58120[(2)]);
var inst_58105 = fluree.db.dbfunctions.internal.ceil(inst_58104);
var inst_58106 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58107 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_58108 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58109 = [fluree.db.dbfunctions.fns.ceil];
var inst_58110 = (new cljs.core.PersistentVector(null,1,(5),inst_58108,inst_58109,null));
var inst_58111 = ["",inst_58110,inst_58105];
var inst_58112 = cljs.core.PersistentHashMap.fromArrays(inst_58107,inst_58111);
var inst_58113 = [inst_58112,(10)];
var inst_58114 = (new cljs.core.PersistentVector(null,2,(5),inst_58106,inst_58113,null));
var inst_58115 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_58114);
var _ = (function (){var statearr_58133 = state_58120;
(statearr_58133[(4)] = cljs.core.rest((state_58120[(4)])));

return statearr_58133;
})();
var state_58120__$1 = (function (){var statearr_58134 = state_58120;
(statearr_58134[(7)] = inst_58115);

return statearr_58134;
})();
var statearr_58135_58149 = state_58120__$1;
(statearr_58135_58149[(2)] = inst_58105);

(statearr_58135_58149[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto____0 = (function (){
var statearr_58136 = [null,null,null,null,null,null,null,null];
(statearr_58136[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto__);

(statearr_58136[(1)] = (1));

return statearr_58136;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto____1 = (function (state_58120){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_58120);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e58137){var ex__2687__auto__ = e58137;
var statearr_58138_58150 = state_58120;
(statearr_58138_58150[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_58120[(4)]))){
var statearr_58139_58151 = state_58120;
(statearr_58139_58151[(1)] = cljs.core.first((state_58120[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58152 = state_58120;
state_58120 = G__58152;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto__ = function(state_58120){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto____1.call(this,state_58120);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_58140 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_58140[(6)] = c__2706__auto__);

return statearr_58140;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_58182){
var state_val_58183 = (state_58182[(1)]);
if((state_val_58183 === (7))){
var state_58182__$1 = state_58182;
var statearr_58184_58203 = state_58182__$1;
(statearr_58184_58203[(2)] = num);

(statearr_58184_58203[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58183 === (1))){
var state_58182__$1 = state_58182;
var statearr_58185_58204 = state_58182__$1;
(statearr_58185_58204[(2)] = null);

(statearr_58185_58204[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58183 === (4))){
var inst_58153 = (state_58182[(2)]);
var state_58182__$1 = state_58182;
var statearr_58186_58205 = state_58182__$1;
(statearr_58186_58205[(2)] = inst_58153);

(statearr_58186_58205[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58183 === (6))){
var state_58182__$1 = state_58182;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58182__$1,(9),num);
} else {
if((state_val_58183 === (3))){
var inst_58180 = (state_58182[(2)]);
var state_58182__$1 = state_58182;
return cljs.core.async.impl.ioc_helpers.return_chan(state_58182__$1,inst_58180);
} else {
if((state_val_58183 === (2))){
var _ = (function (){var statearr_58188 = state_58182;
(statearr_58188[(4)] = cljs.core.cons((5),(state_58182[(4)])));

return statearr_58188;
})();
var inst_58159 = fluree.db.util.async.channel_QMARK_(num);
var state_58182__$1 = state_58182;
if(inst_58159){
var statearr_58189_58206 = state_58182__$1;
(statearr_58189_58206[(1)] = (6));

} else {
var statearr_58190_58207 = state_58182__$1;
(statearr_58190_58207[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58183 === (9))){
var inst_58162 = (state_58182[(2)]);
var inst_58163 = fluree.db.util.async.throw_err(inst_58162);
var state_58182__$1 = state_58182;
var statearr_58191_58208 = state_58182__$1;
(statearr_58191_58208[(2)] = inst_58163);

(statearr_58191_58208[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58183 === (5))){
var _ = (function (){var statearr_58192 = state_58182;
(statearr_58192[(4)] = cljs.core.rest((state_58182[(4)])));

return statearr_58192;
})();
var state_58182__$1 = state_58182;
var ex58187 = (state_58182__$1[(2)]);
var statearr_58193_58209 = state_58182__$1;
(statearr_58193_58209[(5)] = ex58187);


if((ex58187 instanceof Error)){
var statearr_58194_58210 = state_58182__$1;
(statearr_58194_58210[(1)] = (4));

(statearr_58194_58210[(5)] = null);

} else {
throw ex58187;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58183 === (8))){
var inst_58166 = (state_58182[(2)]);
var inst_58167 = fluree.db.dbfunctions.internal.floor(inst_58166);
var inst_58168 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58169 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_58170 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58171 = [fluree.db.dbfunctions.fns.floor];
var inst_58172 = (new cljs.core.PersistentVector(null,1,(5),inst_58170,inst_58171,null));
var inst_58173 = ["",inst_58172,inst_58167];
var inst_58174 = cljs.core.PersistentHashMap.fromArrays(inst_58169,inst_58173);
var inst_58175 = [inst_58174,(10)];
var inst_58176 = (new cljs.core.PersistentVector(null,2,(5),inst_58168,inst_58175,null));
var inst_58177 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_58176);
var _ = (function (){var statearr_58195 = state_58182;
(statearr_58195[(4)] = cljs.core.rest((state_58182[(4)])));

return statearr_58195;
})();
var state_58182__$1 = (function (){var statearr_58196 = state_58182;
(statearr_58196[(7)] = inst_58177);

return statearr_58196;
})();
var statearr_58197_58211 = state_58182__$1;
(statearr_58197_58211[(2)] = inst_58167);

(statearr_58197_58211[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto____0 = (function (){
var statearr_58198 = [null,null,null,null,null,null,null,null];
(statearr_58198[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto__);

(statearr_58198[(1)] = (1));

return statearr_58198;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto____1 = (function (state_58182){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_58182);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e58199){var ex__2687__auto__ = e58199;
var statearr_58200_58212 = state_58182;
(statearr_58200_58212[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_58182[(4)]))){
var statearr_58201_58213 = state_58182;
(statearr_58201_58213[(1)] = cljs.core.first((state_58182[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58214 = state_58182;
state_58182 = G__58214;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto__ = function(state_58182){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto____1.call(this,state_58182);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_58202 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_58202[(6)] = c__2706__auto__);

return statearr_58202;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_58239){
var state_val_58240 = (state_58239[(1)]);
if((state_val_58240 === (1))){
var state_58239__$1 = state_58239;
var statearr_58241_58256 = state_58239__$1;
(statearr_58241_58256[(2)] = null);

(statearr_58241_58256[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58240 === (2))){
var _ = (function (){var statearr_58242 = state_58239;
(statearr_58242[(4)] = cljs.core.cons((5),(state_58239[(4)])));

return statearr_58242;
})();
var inst_58221 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_58239__$1 = state_58239;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58239__$1,(6),inst_58221);
} else {
if((state_val_58240 === (3))){
var inst_58237 = (state_58239[(2)]);
var state_58239__$1 = state_58239;
return cljs.core.async.impl.ioc_helpers.return_chan(state_58239__$1,inst_58237);
} else {
if((state_val_58240 === (4))){
var inst_58215 = (state_58239[(2)]);
var state_58239__$1 = state_58239;
var statearr_58244_58257 = state_58239__$1;
(statearr_58244_58257[(2)] = inst_58215);

(statearr_58244_58257[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58240 === (5))){
var _ = (function (){var statearr_58245 = state_58239;
(statearr_58245[(4)] = cljs.core.rest((state_58239[(4)])));

return statearr_58245;
})();
var state_58239__$1 = state_58239;
var ex58243 = (state_58239__$1[(2)]);
var statearr_58246_58258 = state_58239__$1;
(statearr_58246_58258[(5)] = ex58243);


if((ex58243 instanceof Error)){
var statearr_58247_58259 = state_58239__$1;
(statearr_58247_58259[(1)] = (4));

(statearr_58247_58259[(5)] = null);

} else {
throw ex58243;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58240 === (6))){
var inst_58223 = (state_58239[(2)]);
var inst_58224 = fluree.db.util.async.throw_err(inst_58223);
var inst_58225 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58226 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_58227 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58228 = [compare_val,new_val];
var inst_58229 = (new cljs.core.PersistentVector(null,2,(5),inst_58227,inst_58228,null));
var inst_58230 = ["",inst_58229,inst_58224];
var inst_58231 = cljs.core.PersistentHashMap.fromArrays(inst_58226,inst_58230);
var inst_58232 = [inst_58231,(10)];
var inst_58233 = (new cljs.core.PersistentVector(null,2,(5),inst_58225,inst_58232,null));
var inst_58234 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_58233);
var _ = (function (){var statearr_58248 = state_58239;
(statearr_58248[(4)] = cljs.core.rest((state_58239[(4)])));

return statearr_58248;
})();
var state_58239__$1 = (function (){var statearr_58249 = state_58239;
(statearr_58249[(7)] = inst_58234);

return statearr_58249;
})();
var statearr_58250_58260 = state_58239__$1;
(statearr_58250_58260[(2)] = inst_58224);

(statearr_58250_58260[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto____0 = (function (){
var statearr_58251 = [null,null,null,null,null,null,null,null];
(statearr_58251[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto__);

(statearr_58251[(1)] = (1));

return statearr_58251;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto____1 = (function (state_58239){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_58239);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e58252){var ex__2687__auto__ = e58252;
var statearr_58253_58261 = state_58239;
(statearr_58253_58261[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_58239[(4)]))){
var statearr_58254_58262 = state_58239;
(statearr_58254_58262[(1)] = cljs.core.first((state_58239[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58263 = state_58239;
state_58239 = G__58263;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto__ = function(state_58239){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto____1.call(this,state_58239);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_58255 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_58255[(6)] = c__2706__auto__);

return statearr_58255;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
