// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.index');
goog.require('cljs.core');
goog.require('clojure.data.avl');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
/**
 * Map of default index comparators for the five index types
 */
fluree.db.index.default_comparators = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"post","post",269697687),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"tspo","tspo",-440144953),fluree.db.flake.cmp_flakes_block], null);
/**
 * The five possible index orderings based on the subject, predicate, object,
 *   and transaction flake attributes
 */
fluree.db.index.types = cljs.core.set(cljs.core.keys(fluree.db.index.default_comparators));
/**
 * Returns `true` if `node` is a map for a leaf node
 */
fluree.db.index.leaf_QMARK_ = (function fluree$db$index$leaf_QMARK_(node){
return new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node) === true;
});
/**
 * Returns `true` if `node` is a map for branch node
 */
fluree.db.index.branch_QMARK_ = (function fluree$db$index$branch_QMARK_(node){
return new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node) === false;
});

/**
 * @interface
 */
fluree.db.index.Resolver = function(){};

var fluree$db$index$Resolver$resolve$dyn_14612 = (function (r,node){
var x__5393__auto__ = (((r == null))?null:r);
var m__5394__auto__ = (fluree.db.index.resolve[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(r,node) : m__5394__auto__.call(null,r,node));
} else {
var m__5392__auto__ = (fluree.db.index.resolve["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(r,node) : m__5392__auto__.call(null,r,node));
} else {
throw cljs.core.missing_protocol("Resolver.resolve",r);
}
}
});
/**
 * Populate the supplied index branch or leaf node maps with either the child
 *   node attributes or the flakes they store, respectively.
 */
fluree.db.index.resolve = (function fluree$db$index$resolve(r,node){
if((((!((r == null)))) && ((!((r.fluree$db$index$Resolver$resolve$arity$2 == null)))))){
return r.fluree$db$index$Resolver$resolve$arity$2(r,node);
} else {
return fluree$db$index$Resolver$resolve$dyn_14612(r,node);
}
});

fluree.db.index.try_resolve = (function fluree$db$index$try_resolve(r,error_ch,node){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_14634){
var state_val_14635 = (state_14634[(1)]);
if((state_val_14635 === (1))){
var state_14634__$1 = state_14634;
var statearr_14636_14651 = state_14634__$1;
(statearr_14636_14651[(2)] = null);

(statearr_14636_14651[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14635 === (2))){
var _ = (function (){var statearr_14637 = state_14634;
(statearr_14637[(4)] = cljs.core.cons((6),(state_14634[(4)])));

return statearr_14637;
})();
var inst_14626 = fluree.db.index.resolve(r,node);
var state_14634__$1 = state_14634;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14634__$1,(7),inst_14626);
} else {
if((state_val_14635 === (3))){
var inst_14632 = (state_14634[(2)]);
var state_14634__$1 = state_14634;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14634__$1,inst_14632);
} else {
if((state_val_14635 === (4))){
var inst_14613 = (state_14634[(2)]);
var inst_14614 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14615 = [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015)];
var inst_14616 = (new cljs.core.PersistentVector(null,3,(5),inst_14614,inst_14615,null));
var inst_14617 = cljs.core.select_keys(node,inst_14616);
var inst_14618 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3(inst_14613,"Error resolving index node:",inst_14617) : fluree.db.util.log.error.call(null,inst_14613,"Error resolving index node:",inst_14617));
var state_14634__$1 = (function (){var statearr_14639 = state_14634;
(statearr_14639[(7)] = inst_14618);

return statearr_14639;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14634__$1,(5),error_ch,inst_14613);
} else {
if((state_val_14635 === (5))){
var inst_14620 = (state_14634[(2)]);
var state_14634__$1 = state_14634;
var statearr_14640_14652 = state_14634__$1;
(statearr_14640_14652[(2)] = inst_14620);

(statearr_14640_14652[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14635 === (6))){
var _ = (function (){var statearr_14641 = state_14634;
(statearr_14641[(4)] = cljs.core.rest((state_14634[(4)])));

return statearr_14641;
})();
var state_14634__$1 = state_14634;
var ex14638 = (state_14634__$1[(2)]);
var statearr_14642_14653 = state_14634__$1;
(statearr_14642_14653[(5)] = ex14638);


var statearr_14643_14654 = state_14634__$1;
(statearr_14643_14654[(1)] = (4));

(statearr_14643_14654[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14635 === (7))){
var inst_14628 = (state_14634[(2)]);
var inst_14629 = fluree.db.util.async.throw_err(inst_14628);
var _ = (function (){var statearr_14644 = state_14634;
(statearr_14644[(4)] = cljs.core.rest((state_14634[(4)])));

return statearr_14644;
})();
var state_14634__$1 = state_14634;
var statearr_14645_14655 = state_14634__$1;
(statearr_14645_14655[(2)] = inst_14629);

(statearr_14645_14655[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$try_resolve_$_state_machine__2684__auto__ = null;
var fluree$db$index$try_resolve_$_state_machine__2684__auto____0 = (function (){
var statearr_14646 = [null,null,null,null,null,null,null,null];
(statearr_14646[(0)] = fluree$db$index$try_resolve_$_state_machine__2684__auto__);

(statearr_14646[(1)] = (1));

return statearr_14646;
});
var fluree$db$index$try_resolve_$_state_machine__2684__auto____1 = (function (state_14634){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_14634);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e14647){var ex__2687__auto__ = e14647;
var statearr_14648_14656 = state_14634;
(statearr_14648_14656[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_14634[(4)]))){
var statearr_14649_14657 = state_14634;
(statearr_14649_14657[(1)] = cljs.core.first((state_14634[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14658 = state_14634;
state_14634 = G__14658;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$index$try_resolve_$_state_machine__2684__auto__ = function(state_14634){
switch(arguments.length){
case 0:
return fluree$db$index$try_resolve_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$index$try_resolve_$_state_machine__2684__auto____1.call(this,state_14634);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$try_resolve_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$try_resolve_$_state_machine__2684__auto____0;
fluree$db$index$try_resolve_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$try_resolve_$_state_machine__2684__auto____1;
return fluree$db$index$try_resolve_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_14650 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_14650[(6)] = c__2706__auto__);

return statearr_14650;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns `true` if the data associated with the index node map `node` is fully
 *   resolved from storage
 */
fluree.db.index.resolved_QMARK_ = (function fluree$db$index$resolved_QMARK_(node){
if(fluree.db.index.leaf_QMARK_(node)){
return (!((new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(node) == null)));
} else {
if(fluree.db.index.branch_QMARK_(node)){
return (!((new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(node) == null)));
} else {
return null;
}
}
});
/**
 * Clear the populated child node attributes from the supplied `node` map if it
 *   represents a branch, or the populated flakes if `node` represents a leaf.
 */
fluree.db.index.unresolve = (function fluree$db$index$unresolve(node){
if(fluree.db.index.leaf_QMARK_(node)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(node,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
} else {
if(fluree.db.index.branch_QMARK_(node)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(node,new cljs.core.Keyword(null,"children","children",-940561982));
} else {
return null;
}
}
});
fluree.db.index.lookup = (function fluree$db$index$lookup(branch,flake){
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.index.branch_QMARK_(branch);
if(and__5043__auto__){
return fluree.db.index.resolved_QMARK_(branch);
} else {
return and__5043__auto__;
}
})())){
var map__14659 = branch;
var map__14659__$1 = cljs.core.__destructure_map(map__14659);
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14659__$1,new cljs.core.Keyword(null,"children","children",-940561982));
return cljs.core.val((function (){var or__5045__auto__ = clojure.data.avl.nearest(children,cljs.core._LT__EQ_,flake);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.first(children);
}
})());
} else {
return null;
}
});
fluree.db.index.lookup_leaf = (function fluree$db$index$lookup_leaf(r,branch,flake){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_14695){
var state_val_14696 = (state_14695[(1)]);
if((state_val_14696 === (7))){
var inst_14666 = (state_14695[(7)]);
var state_14695__$1 = state_14695;
var statearr_14697_14728 = state_14695__$1;
(statearr_14697_14728[(2)] = inst_14666);

(statearr_14697_14728[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14696 === (1))){
var state_14695__$1 = state_14695;
var statearr_14698_14729 = state_14695__$1;
(statearr_14698_14729[(2)] = null);

(statearr_14698_14729[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14696 === (4))){
var inst_14660 = (state_14695[(2)]);
var state_14695__$1 = state_14695;
var statearr_14699_14730 = state_14695__$1;
(statearr_14699_14730[(2)] = inst_14660);

(statearr_14699_14730[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14696 === (15))){
var inst_14674 = (state_14695[(8)]);
var inst_14679 = fluree.db.index.resolve(r,inst_14674);
var state_14695__$1 = state_14695;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14695__$1,(17),inst_14679);
} else {
if((state_val_14696 === (13))){
var inst_14687 = (state_14695[(2)]);
var state_14695__$1 = state_14695;
var statearr_14700_14731 = state_14695__$1;
(statearr_14700_14731[(2)] = inst_14687);

(statearr_14700_14731[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14696 === (6))){
var inst_14668 = fluree.db.index.resolved_QMARK_(branch);
var state_14695__$1 = state_14695;
var statearr_14701_14732 = state_14695__$1;
(statearr_14701_14732[(2)] = inst_14668);

(statearr_14701_14732[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14696 === (17))){
var inst_14681 = (state_14695[(2)]);
var inst_14682 = fluree.db.util.async.throw_err(inst_14681);
var inst_14674 = inst_14682;
var state_14695__$1 = (function (){var statearr_14702 = state_14695;
(statearr_14702[(8)] = inst_14674);

return statearr_14702;
})();
var statearr_14703_14733 = state_14695__$1;
(statearr_14703_14733[(2)] = null);

(statearr_14703_14733[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14696 === (3))){
var inst_14693 = (state_14695[(2)]);
var state_14695__$1 = state_14695;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14695__$1,inst_14693);
} else {
if((state_val_14696 === (12))){
var inst_14674 = (state_14695[(8)]);
var inst_14676 = fluree.db.index.leaf_QMARK_(inst_14674);
var state_14695__$1 = state_14695;
if(inst_14676){
var statearr_14704_14734 = state_14695__$1;
(statearr_14704_14734[(1)] = (14));

} else {
var statearr_14705_14735 = state_14695__$1;
(statearr_14705_14735[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14696 === (2))){
var inst_14666 = (state_14695[(7)]);
var _ = (function (){var statearr_14706 = state_14695;
(statearr_14706[(4)] = cljs.core.cons((5),(state_14695[(4)])));

return statearr_14706;
})();
var inst_14666__$1 = fluree.db.index.branch_QMARK_(branch);
var state_14695__$1 = (function (){var statearr_14707 = state_14695;
(statearr_14707[(7)] = inst_14666__$1);

return statearr_14707;
})();
if(inst_14666__$1){
var statearr_14708_14736 = state_14695__$1;
(statearr_14708_14736[(1)] = (6));

} else {
var statearr_14709_14737 = state_14695__$1;
(statearr_14709_14737[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14696 === (11))){
var inst_14690 = (state_14695[(2)]);
var _ = (function (){var statearr_14711 = state_14695;
(statearr_14711[(4)] = cljs.core.rest((state_14695[(4)])));

return statearr_14711;
})();
var state_14695__$1 = state_14695;
var statearr_14712_14738 = state_14695__$1;
(statearr_14712_14738[(2)] = inst_14690);

(statearr_14712_14738[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14696 === (9))){
var inst_14673 = fluree.db.index.lookup(branch,flake);
var inst_14674 = inst_14673;
var state_14695__$1 = (function (){var statearr_14713 = state_14695;
(statearr_14713[(8)] = inst_14674);

return statearr_14713;
})();
var statearr_14714_14739 = state_14695__$1;
(statearr_14714_14739[(2)] = null);

(statearr_14714_14739[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14696 === (5))){
var _ = (function (){var statearr_14715 = state_14695;
(statearr_14715[(4)] = cljs.core.rest((state_14695[(4)])));

return statearr_14715;
})();
var state_14695__$1 = state_14695;
var ex14710 = (state_14695__$1[(2)]);
var statearr_14716_14740 = state_14695__$1;
(statearr_14716_14740[(5)] = ex14710);


if((ex14710 instanceof Error)){
var statearr_14717_14741 = state_14695__$1;
(statearr_14717_14741[(1)] = (4));

(statearr_14717_14741[(5)] = null);

} else {
throw ex14710;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14696 === (14))){
var inst_14674 = (state_14695[(8)]);
var state_14695__$1 = state_14695;
var statearr_14718_14742 = state_14695__$1;
(statearr_14718_14742[(2)] = inst_14674);

(statearr_14718_14742[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14696 === (16))){
var inst_14685 = (state_14695[(2)]);
var state_14695__$1 = state_14695;
var statearr_14719_14743 = state_14695__$1;
(statearr_14719_14743[(2)] = inst_14685);

(statearr_14719_14743[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14696 === (10))){
var state_14695__$1 = state_14695;
var statearr_14720_14744 = state_14695__$1;
(statearr_14720_14744[(2)] = null);

(statearr_14720_14744[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14696 === (8))){
var inst_14671 = (state_14695[(2)]);
var state_14695__$1 = state_14695;
if(cljs.core.truth_(inst_14671)){
var statearr_14721_14745 = state_14695__$1;
(statearr_14721_14745[(1)] = (9));

} else {
var statearr_14722_14746 = state_14695__$1;
(statearr_14722_14746[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$lookup_leaf_$_state_machine__2684__auto__ = null;
var fluree$db$index$lookup_leaf_$_state_machine__2684__auto____0 = (function (){
var statearr_14723 = [null,null,null,null,null,null,null,null,null];
(statearr_14723[(0)] = fluree$db$index$lookup_leaf_$_state_machine__2684__auto__);

(statearr_14723[(1)] = (1));

return statearr_14723;
});
var fluree$db$index$lookup_leaf_$_state_machine__2684__auto____1 = (function (state_14695){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_14695);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e14724){var ex__2687__auto__ = e14724;
var statearr_14725_14747 = state_14695;
(statearr_14725_14747[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_14695[(4)]))){
var statearr_14726_14748 = state_14695;
(statearr_14726_14748[(1)] = cljs.core.first((state_14695[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14749 = state_14695;
state_14695 = G__14749;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$index$lookup_leaf_$_state_machine__2684__auto__ = function(state_14695){
switch(arguments.length){
case 0:
return fluree$db$index$lookup_leaf_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$index$lookup_leaf_$_state_machine__2684__auto____1.call(this,state_14695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$lookup_leaf_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$lookup_leaf_$_state_machine__2684__auto____0;
fluree$db$index$lookup_leaf_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$lookup_leaf_$_state_machine__2684__auto____1;
return fluree$db$index$lookup_leaf_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_14727 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_14727[(6)] = c__2706__auto__);

return statearr_14727;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.index.add_flakes = (function fluree$db$index$add_flakes(leaf,flakes){
var new_leaf = cljs.core.update.cljs$core$IFn$_invoke$arity$3(cljs.core.update.cljs$core$IFn$_invoke$arity$4(leaf,new cljs.core.Keyword(null,"flakes","flakes",1977895739),fluree.db.flake.conj_all,flakes),new cljs.core.Keyword(null,"size","size",1098693007),(function (size){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,size,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.size_flake,flakes));
}));
var new_first = (function (){var or__5045__auto__ = (function (){var G__14750 = new_leaf;
var G__14750__$1 = (((G__14750 == null))?null:new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(G__14750));
if((G__14750__$1 == null)){
return null;
} else {
return cljs.core.first(G__14750__$1);
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.maximum;
}
})();
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_leaf,new cljs.core.Keyword(null,"first","first",-644103046),new_first);
});
fluree.db.index.rem_flakes = (function fluree$db$index$rem_flakes(leaf,flakes){
var new_leaf = cljs.core.update.cljs$core$IFn$_invoke$arity$3(cljs.core.update.cljs$core$IFn$_invoke$arity$4(leaf,new cljs.core.Keyword(null,"flakes","flakes",1977895739),fluree.db.flake.disj_all,flakes),new cljs.core.Keyword(null,"size","size",1098693007),(function (size){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._,size,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.size_flake,flakes));
}));
var new_first = (function (){var or__5045__auto__ = (function (){var G__14751 = new_leaf;
var G__14751__$1 = (((G__14751 == null))?null:new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(G__14751));
if((G__14751__$1 == null)){
return null;
} else {
return cljs.core.first(G__14751__$1);
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.maximum;
}
})();
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_leaf,new cljs.core.Keyword(null,"first","first",-644103046),new_first);
});
/**
 * Returns a blank leaf node map for the provided `network`, `ledger-id`, and index
 *   comparator `cmp`.
 */
fluree.db.index.empty_leaf = (function fluree$db$index$empty_leaf(network,ledger_id,cmp){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739)],[(0),ledger_id,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),cmp,(0),network,fluree.db.flake.maximum,null]);
});
fluree.db.index.new_leaf = (function fluree$db$index$new_leaf(network,ledger_id,cmp,flakes){
var empty_set = fluree.db.flake.sorted_set_by(cmp);
return fluree.db.index.add_flakes(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(fluree.db.index.empty_leaf(network,ledger_id,cmp),new cljs.core.Keyword(null,"flakes","flakes",1977895739),empty_set),flakes);
});
/**
 * Checks if the `node` passed in the second argument is a descendant of the
 *   `branch` passed in the first argument
 */
fluree.db.index.descendant_QMARK_ = (function fluree$db$index$descendant_QMARK_(p__14752,p__14753){
var map__14754 = p__14752;
var map__14754__$1 = cljs.core.__destructure_map(map__14754);
var branch = map__14754__$1;
var cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14754__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var first_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14754__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14754__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var leftmost_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14754__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var map__14755 = p__14753;
var map__14755__$1 = cljs.core.__destructure_map(map__14755);
var node = map__14755__$1;
var node_first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14755__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var node_rhs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14755__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
if((!(fluree.db.index.branch_QMARK_(branch)))){
return false;
} else {
var and__5043__auto__ = (function (){var or__5045__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (!(((cmp.cljs$core$IFn$_invoke$arity$2 ? cmp.cljs$core$IFn$_invoke$arity$2(first_flake,node_first) : cmp.call(null,first_flake,node_first)) > (0))));
}
})();
if(cljs.core.truth_(and__5043__auto__)){
return (((rhs == null)) || ((((!((node_rhs == null)))) && ((!(((cmp.cljs$core$IFn$_invoke$arity$2 ? cmp.cljs$core$IFn$_invoke$arity$2(node_rhs,rhs) : cmp.call(null,node_rhs,rhs)) > (0))))))));
} else {
return and__5043__auto__;
}
}
});
fluree.db.index.child_entry = (function fluree$db$index$child_entry(p__14756){
var map__14757 = p__14756;
var map__14757__$1 = cljs.core.__destructure_map(map__14757);
var node = map__14757__$1;
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14757__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var child_node = fluree.db.index.unresolve(node);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [first,child_node], null);
});
/**
 * Returns avl sorted map whose keys are the first flakes of the index node
 *   sequence `child-nodes`, and whose values are the corresponding nodes from
 *   `child-nodes`.
 */
fluree.db.index.child_map = (function fluree$db$index$child_map(var_args){
var args__5775__auto__ = [];
var len__5769__auto___14760 = arguments.length;
var i__5770__auto___14761 = (0);
while(true){
if((i__5770__auto___14761 < len__5769__auto___14760)){
args__5775__auto__.push((arguments[i__5770__auto___14761]));

var G__14762 = (i__5770__auto___14761 + (1));
i__5770__auto___14761 = G__14762;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.index.child_map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.index.child_map.cljs$core$IFn$_invoke$arity$variadic = (function (cmp,child_nodes){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_map_by,cmp,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(fluree.db.index.child_entry,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([child_nodes], 0)));
}));

(fluree.db.index.child_map.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.index.child_map.cljs$lang$applyTo = (function (seq14758){
var G__14759 = cljs.core.first(seq14758);
var seq14758__$1 = cljs.core.next(seq14758);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14759,seq14758__$1);
}));

/**
 * Returns a blank branch node which contains a single empty leaf node for the
 *   provided `network`, `ledger-id`, and index comparator `cmp`.
 */
fluree.db.index.empty_branch = (function fluree$db$index$empty_branch(network,ledger_id,cmp){
var child_node = fluree.db.index.empty_leaf(network,ledger_id,cmp);
var children = fluree.db.index.child_map.cljs$core$IFn$_invoke$arity$variadic(cmp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([child_node], 0));
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739)],[children,(0),ledger_id,false,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),cmp,(0),network,fluree.db.flake.maximum,null]);
});
fluree.db.index.reset_children = (function fluree$db$index$reset_children(p__14763,new_child_nodes){
var map__14764 = p__14763;
var map__14764__$1 = cljs.core.__destructure_map(map__14764);
var branch = map__14764__$1;
var comparator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14764__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14764__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var new_kids = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.index.child_map,comparator,new_child_nodes);
var new_first = (function (){var or__5045__auto__ = (function (){var G__14765 = new_kids;
var G__14765__$1 = (((G__14765 == null))?null:cljs.core.first(G__14765));
if((G__14765__$1 == null)){
return null;
} else {
return cljs.core.key(G__14765__$1);
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.maximum;
}
})();
var new_size = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,size,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"size","size",1098693007),new_child_nodes));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(branch,new cljs.core.Keyword(null,"first","first",-644103046),new_first,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"size","size",1098693007),new_size,new cljs.core.Keyword(null,"children","children",-940561982),new_kids], 0));
});
fluree.db.index.new_branch = (function fluree$db$index$new_branch(network,ledger_id,cmp,child_nodes){
return fluree.db.index.reset_children(fluree.db.index.empty_branch(network,ledger_id,cmp),child_nodes);
});
/**
 * Returns `true` if `flake` has a transaction value after the provided `t`
 */
fluree.db.index.after_t_QMARK_ = (function fluree$db$index$after_t_QMARK_(t,flake){
return (fluree.db.flake.t(flake) < t);
});
/**
 * Returns a sequence containing only flakes from the flake set `flakes` with
 *   transaction values after the provided `t`.
 */
fluree.db.index.filter_after = (function fluree$db$index$filter_after(t,flakes){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.index.after_t_QMARK_,t),flakes);
});
/**
 * Returns an avl-subset of the avl-set `flakes` with transaction values on or
 *   before the provided `t`.
 */
fluree.db.index.flakes_through = (function fluree$db$index$flakes_through(t,flakes){
return fluree.db.flake.disj_all(flakes,fluree.db.index.filter_after(t,flakes));
});
fluree.db.index.novelty_subrange = (function fluree$db$index$novelty_subrange(p__14766,through_t,novelty){
var map__14767 = p__14766;
var map__14767__$1 = cljs.core.__destructure_map(map__14767);
var node = map__14767__$1;
var first_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14767__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14767__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var leftmost_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14767__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
(fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$6 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$6("novelty-subrange: first-flake:",first_flake,"\nrhs:",rhs,"\nleftmost?",leftmost_QMARK_) : fluree.db.util.log.debug.call(null,"novelty-subrange: first-flake:",first_flake,"\nrhs:",rhs,"\nleftmost?",leftmost_QMARK_));

var subrange = (cljs.core.truth_((function (){var and__5043__auto__ = rhs;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__5043__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__5043__auto__ = rhs;
if(cljs.core.truth_(and__5043__auto__)){
return leftmost_QMARK_;
} else {
return and__5043__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__5043__auto__ = (rhs == null);
if(and__5043__auto__){
return leftmost_QMARK_;
} else {
return and__5043__auto__;
}
})())?novelty:null))));
return fluree.db.index.flakes_through(through_t,subrange);
});
/**
 * Returns a sequence of flakes from the sorted set `flakes` that are out of date
 *   by the transaction `t` because `flakes` contains another flake with the same
 *   subject and predicate and a transaction value later than that flake but on or
 *   before `t`.
 */
fluree.db.index.stale_by = (function fluree$db$index$stale_by(t,flakes){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (flakes__$1){
var last_flake = cljs.core.last(flakes__$1);
if(cljs.core.truth_(fluree.db.flake.op(last_flake))){
return cljs.core.butlast(flakes__$1);
} else {
return flakes__$1;
}
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.s,fluree.db.flake.p,fluree.db.flake.o),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.index.after_t_QMARK_,t)),flakes))], 0));
});
/**
 * Returns a sorted set of flakes that are not out of date between the
 *   transactions `from-t` and `to-t`.
 */
fluree.db.index.t_range = (function fluree$db$index$t_range(p__14768,novelty,from_t,to_t){
var map__14769 = p__14768;
var map__14769__$1 = cljs.core.__destructure_map(map__14769);
var leaf = map__14769__$1;
var leaf_t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14769__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14769__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var latest = (function (){var G__14770 = flakes;
if((leaf_t > to_t)){
return fluree.db.flake.conj_all(G__14770,fluree.db.index.novelty_subrange(leaf,to_t,novelty));
} else {
return G__14770;
}
})();
var stale_flakes = fluree.db.index.stale_by(from_t,latest);
var subsequent = fluree.db.index.filter_after(to_t,latest);
var out_of_range = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(stale_flakes,subsequent);
return fluree.db.flake.disj_all(latest,out_of_range);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {fluree.db.index.Resolver}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.CachedTRangeResolver = (function (node_resolver,novelty,from_t,to_t,async_cache,__meta,__extmap,__hash){
this.node_resolver = node_resolver;
this.novelty = novelty;
this.from_t = from_t;
this.to_t = to_t;
this.async_cache = async_cache;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.CachedTRangeResolver.prototype.fluree$db$index$Resolver$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.CachedTRangeResolver.prototype.fluree$db$index$Resolver$resolve$arity$2 = (function (_,p__14776){
var self__ = this;
var map__14777 = p__14776;
var map__14777__$1 = cljs.core.__destructure_map(map__14777);
var node = map__14777__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14777__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var tempid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14777__$1,new cljs.core.Keyword(null,"tempid","tempid",1427663222));
var tt_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14777__$1,new cljs.core.Keyword(null,"tt-id","tt-id",725587484));
var ___$1 = this;
if(fluree.db.index.branch_QMARK_(node)){
return fluree.db.index.resolve(self__.node_resolver,node);
} else {
var G__14778 = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.index","t-range","fluree.db.index/t-range",437950593),id,tempid,tt_id,self__.from_t,self__.to_t], null);
var G__14779 = (function (___$2){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_14797){
var state_val_14798 = (state_14797[(1)]);
if((state_val_14798 === (1))){
var state_14797__$1 = state_14797;
var statearr_14799_14834 = state_14797__$1;
(statearr_14799_14834[(2)] = null);

(statearr_14799_14834[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14798 === (2))){
var ___$3 = (function (){var statearr_14800 = state_14797;
(statearr_14800[(4)] = cljs.core.cons((5),(state_14797[(4)])));

return statearr_14800;
})();
var inst_14786 = fluree.db.index.resolve(self__.node_resolver,node);
var state_14797__$1 = state_14797;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14797__$1,(6),inst_14786);
} else {
if((state_val_14798 === (3))){
var inst_14795 = (state_14797[(2)]);
var state_14797__$1 = state_14797;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14797__$1,inst_14795);
} else {
if((state_val_14798 === (4))){
var inst_14780 = (state_14797[(2)]);
var state_14797__$1 = state_14797;
var statearr_14802_14835 = state_14797__$1;
(statearr_14802_14835[(2)] = inst_14780);

(statearr_14802_14835[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14798 === (5))){
var ___$3 = (function (){var statearr_14803 = state_14797;
(statearr_14803[(4)] = cljs.core.rest((state_14797[(4)])));

return statearr_14803;
})();
var state_14797__$1 = state_14797;
var ex14801 = (state_14797__$1[(2)]);
var statearr_14804_14836 = state_14797__$1;
(statearr_14804_14836[(5)] = ex14801);


if((ex14801 instanceof Error)){
var statearr_14805_14837 = state_14797__$1;
(statearr_14805_14837[(1)] = (4));

(statearr_14805_14837[(5)] = null);

} else {
throw ex14801;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14798 === (6))){
var inst_14788 = (state_14797[(2)]);
var inst_14789 = fluree.db.util.async.throw_err(inst_14788);
var inst_14790 = fluree.db.index.t_range(inst_14789,self__.novelty,self__.from_t,self__.to_t);
var inst_14791 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_14789,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_14792 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_14791,new cljs.core.Keyword(null,"from-t","from-t",1730913525),self__.from_t,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"to-t","to-t",569467359),self__.to_t,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_14790], 0));
var ___$3 = (function (){var statearr_14806 = state_14797;
(statearr_14806[(4)] = cljs.core.rest((state_14797[(4)])));

return statearr_14806;
})();
var state_14797__$1 = state_14797;
var statearr_14807_14838 = state_14797__$1;
(statearr_14807_14838[(2)] = inst_14792);

(statearr_14807_14838[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__2684__auto__ = null;
var fluree$db$index$state_machine__2684__auto____0 = (function (){
var statearr_14808 = [null,null,null,null,null,null,null];
(statearr_14808[(0)] = fluree$db$index$state_machine__2684__auto__);

(statearr_14808[(1)] = (1));

return statearr_14808;
});
var fluree$db$index$state_machine__2684__auto____1 = (function (state_14797){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_14797);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e14809){var ex__2687__auto__ = e14809;
var statearr_14810_14839 = state_14797;
(statearr_14810_14839[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_14797[(4)]))){
var statearr_14811_14840 = state_14797;
(statearr_14811_14840[(1)] = cljs.core.first((state_14797[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14841 = state_14797;
state_14797 = G__14841;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$index$state_machine__2684__auto__ = function(state_14797){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2684__auto____1.call(this,state_14797);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2684__auto____0;
fluree$db$index$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2684__auto____1;
return fluree$db$index$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_14812 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_14812[(6)] = c__2706__auto__);

return statearr_14812;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
return (self__.async_cache.cljs$core$IFn$_invoke$arity$2 ? self__.async_cache.cljs$core$IFn$_invoke$arity$2(G__14778,G__14779) : self__.async_cache.call(null,G__14778,G__14779));
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k14772,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__14813 = k14772;
var G__14813__$1 = (((G__14813 instanceof cljs.core.Keyword))?G__14813.fqn:null);
switch (G__14813__$1) {
case "node-resolver":
return self__.node_resolver;

break;
case "novelty":
return self__.novelty;

break;
case "from-t":
return self__.from_t;

break;
case "to-t":
return self__.to_t;

break;
case "async-cache":
return self__.async_cache;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k14772,else__5346__auto__);

}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__14814){
var vec__14815 = p__14814;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14815,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14815,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.index.CachedTRangeResolver{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),self__.node_resolver],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"from-t","from-t",1730913525),self__.from_t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"to-t","to-t",569467359),self__.to_t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache],null))], null),self__.__extmap));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__14771){
var self__ = this;
var G__14771__$1 = this;
return (new cljs.core.RecordIter((0),G__14771__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (5 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__14818 = (function (coll__5340__auto__){
return (361103374 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
});
return fexpr__14818(this__5339__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this14773,other14774){
var self__ = this;
var this14773__$1 = this;
return (((!((other14774 == null)))) && ((((this14773__$1.constructor === other14774.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14773__$1.node_resolver,other14774.node_resolver)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14773__$1.novelty,other14774.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14773__$1.from_t,other14774.from_t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14773__$1.to_t,other14774.to_t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14773__$1.async_cache,other14774.async_cache)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14773__$1.__extmap,other14774.__extmap)))))))))))))));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),null,new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),null,new cljs.core.Keyword(null,"from-t","from-t",1730913525),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"to-t","to-t",569467359),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k14772){
var self__ = this;
var this__5350__auto____$1 = this;
var G__14819 = k14772;
var G__14819__$1 = (((G__14819 instanceof cljs.core.Keyword))?G__14819.fqn:null);
switch (G__14819__$1) {
case "node-resolver":
case "novelty":
case "from-t":
case "to-t":
case "async-cache":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k14772);

}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__14771){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__14820 = cljs.core.keyword_identical_QMARK_;
var expr__14821 = k__5352__auto__;
if(cljs.core.truth_((function (){var G__14823 = new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078);
var G__14824 = expr__14821;
return (pred__14820.cljs$core$IFn$_invoke$arity$2 ? pred__14820.cljs$core$IFn$_invoke$arity$2(G__14823,G__14824) : pred__14820.call(null,G__14823,G__14824));
})())){
return (new fluree.db.index.CachedTRangeResolver(G__14771,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__14825 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024);
var G__14826 = expr__14821;
return (pred__14820.cljs$core$IFn$_invoke$arity$2 ? pred__14820.cljs$core$IFn$_invoke$arity$2(G__14825,G__14826) : pred__14820.call(null,G__14825,G__14826));
})())){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,G__14771,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__14827 = new cljs.core.Keyword(null,"from-t","from-t",1730913525);
var G__14828 = expr__14821;
return (pred__14820.cljs$core$IFn$_invoke$arity$2 ? pred__14820.cljs$core$IFn$_invoke$arity$2(G__14827,G__14828) : pred__14820.call(null,G__14827,G__14828));
})())){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,G__14771,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__14829 = new cljs.core.Keyword(null,"to-t","to-t",569467359);
var G__14830 = expr__14821;
return (pred__14820.cljs$core$IFn$_invoke$arity$2 ? pred__14820.cljs$core$IFn$_invoke$arity$2(G__14829,G__14830) : pred__14820.call(null,G__14829,G__14830));
})())){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,G__14771,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__14831 = new cljs.core.Keyword(null,"async-cache","async-cache",-190459891);
var G__14832 = expr__14821;
return (pred__14820.cljs$core$IFn$_invoke$arity$2 ? pred__14820.cljs$core$IFn$_invoke$arity$2(G__14831,G__14832) : pred__14820.call(null,G__14831,G__14832));
})())){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,G__14771,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__14771),null));
}
}
}
}
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),self__.node_resolver,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"from-t","from-t",1730913525),self__.from_t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"to-t","to-t",569467359),self__.to_t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache,null))], null),self__.__extmap));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__14771){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,G__14771,self__.__extmap,self__.__hash));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.index.CachedTRangeResolver.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"node-resolver","node-resolver",-1971835691,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"from-t","from-t",-923522244,null),new cljs.core.Symbol(null,"to-t","to-t",-2084968410,null),new cljs.core.Symbol(null,"async-cache","async-cache",1450071636,null)], null);
}));

(fluree.db.index.CachedTRangeResolver.cljs$lang$type = true);

(fluree.db.index.CachedTRangeResolver.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.index/CachedTRangeResolver",null,(1),null));
}));

(fluree.db.index.CachedTRangeResolver.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"fluree.db.index/CachedTRangeResolver");
}));

/**
 * Positional factory function for fluree.db.index/CachedTRangeResolver.
 */
fluree.db.index.__GT_CachedTRangeResolver = (function fluree$db$index$__GT_CachedTRangeResolver(node_resolver,novelty,from_t,to_t,async_cache){
return (new fluree.db.index.CachedTRangeResolver(node_resolver,novelty,from_t,to_t,async_cache,null,null,null));
});

/**
 * Factory function for fluree.db.index/CachedTRangeResolver, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_CachedTRangeResolver = (function fluree$db$index$map__GT_CachedTRangeResolver(G__14775){
var extmap__5385__auto__ = (function (){var G__14833 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__14775,new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891)], 0));
if(cljs.core.record_QMARK_(G__14775)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__14833);
} else {
return G__14833;
}
})();
return (new fluree.db.index.CachedTRangeResolver(new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078).cljs$core$IFn$_invoke$arity$1(G__14775),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__14775),new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(G__14775),new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(G__14775),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(G__14775),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

/**
 * Find the value of `leaf` at transaction `t` by adding new flakes from
 *   `idx-novelty` to `leaf` if `t` is newer than `leaf`, or removing flakes later
 *   than `t` from `leaf` if `t` is older than `leaf`.
 */
fluree.db.index.at_t = (function fluree$db$index$at_t(p__14844,t,idx_novelty){
var map__14845 = p__14844;
var map__14845__$1 = cljs.core.__destructure_map(map__14845);
var leaf = map__14845__$1;
var leaf_t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14845__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var rhs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14845__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var leftmost_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14845__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14845__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(leaf_t,t)){
return leaf;
} else {
var G__14846 = leaf;
var G__14846__$1 = (((leaf_t > t))?fluree.db.index.add_flakes(G__14846,fluree.db.index.novelty_subrange(leaf,t,idx_novelty)):G__14846);
var G__14846__$2 = (((leaf_t < t))?fluree.db.index.rem_flakes(G__14846__$1,fluree.db.index.filter_after(t,flakes)):G__14846__$1);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__14846__$2,new cljs.core.Keyword(null,"t","t",-1397832519),t);

}
});
fluree.db.index.mark_expanded = (function fluree$db$index$mark_expanded(node){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(node,new cljs.core.Keyword("fluree.db.index","expanded","fluree.db.index/expanded",-1916776179),true);
});
fluree.db.index.unmark_expanded = (function fluree$db$index$unmark_expanded(node){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(node,new cljs.core.Keyword("fluree.db.index","expanded","fluree.db.index/expanded",-1916776179));
});
fluree.db.index.expanded_QMARK_ = (function fluree$db$index$expanded_QMARK_(node){
return new cljs.core.Keyword("fluree.db.index","expanded","fluree.db.index/expanded",-1916776179).cljs$core$IFn$_invoke$arity$1(node) === true;
});
fluree.db.index.resolve_when = (function fluree$db$index$resolve_when(r,resolve_QMARK_,error_ch,node){
if(cljs.core.truth_((resolve_QMARK_.cljs$core$IFn$_invoke$arity$1 ? resolve_QMARK_.cljs$core$IFn$_invoke$arity$1(node) : resolve_QMARK_.call(null,node)))){
return fluree.db.index.try_resolve(r,error_ch,node);
} else {
var G__14847 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(G__14847,node);

return G__14847;
}
});
fluree.db.index.resolve_children_when = (function fluree$db$index$resolve_children_when(r,resolve_QMARK_,error_ch,branch){
if(cljs.core.truth_(fluree.db.index.resolved_QMARK_(branch))){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__14848){
var vec__14849 = p__14848;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14849,(0),null);
var child = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14849,(1),null);
return fluree.db.index.resolve_when(r,resolve_QMARK_,error_ch,child);
}),new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(branch)));
} else {
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_14854){
var state_val_14855 = (state_14854[(1)]);
if((state_val_14855 === (1))){
var inst_14852 = cljs.core.PersistentVector.EMPTY;
var state_14854__$1 = state_14854;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14854__$1,inst_14852);
} else {
return null;
}
});
return (function() {
var fluree$db$index$resolve_children_when_$_state_machine__2684__auto__ = null;
var fluree$db$index$resolve_children_when_$_state_machine__2684__auto____0 = (function (){
var statearr_14856 = [null,null,null,null,null,null,null];
(statearr_14856[(0)] = fluree$db$index$resolve_children_when_$_state_machine__2684__auto__);

(statearr_14856[(1)] = (1));

return statearr_14856;
});
var fluree$db$index$resolve_children_when_$_state_machine__2684__auto____1 = (function (state_14854){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_14854);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e14857){var ex__2687__auto__ = e14857;
var statearr_14858_14861 = state_14854;
(statearr_14858_14861[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_14854[(4)]))){
var statearr_14859_14862 = state_14854;
(statearr_14859_14862[(1)] = cljs.core.first((state_14854[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14863 = state_14854;
state_14854 = G__14863;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$index$resolve_children_when_$_state_machine__2684__auto__ = function(state_14854){
switch(arguments.length){
case 0:
return fluree$db$index$resolve_children_when_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$index$resolve_children_when_$_state_machine__2684__auto____1.call(this,state_14854);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$resolve_children_when_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$resolve_children_when_$_state_machine__2684__auto____0;
fluree$db$index$resolve_children_when_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$resolve_children_when_$_state_machine__2684__auto____1;
return fluree$db$index$resolve_children_when_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_14860 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_14860[(6)] = c__2706__auto__);

return statearr_14860;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}
});
/**
 * Returns a channel that will eventually contain the stream of index nodes
 *   descended from `root` in depth-first order. `resolve?` is a boolean function
 *   that will be applied to each node to determine whether or not the data
 *   associated with that node will be resolved from disk using the supplied
 *   `Resolver` `r`. `include?` is a boolean function that will be applied to each
 *   node to determine if it will be included in the final output node stream, `n`
 *   is an optional parameter specifying the number of nodes to load concurrently,
 *   and `xf` is an optional transducer that will transform the output stream if
 *   supplied.
 */
fluree.db.index.tree_chan = (function fluree$db$index$tree_chan(var_args){
var G__14865 = arguments.length;
switch (G__14865) {
case 5:
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 7:
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$5 = (function (r,root,resolve_QMARK_,include_QMARK_,error_ch){
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7(r,root,resolve_QMARK_,include_QMARK_,(1),cljs.core.identity,error_ch);
}));

(fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7 = (function (r,root,resolve_QMARK_,include_QMARK_,n,xf,error_ch){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(n,xf);
var c__2706__auto___14943 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_14911){
var state_val_14912 = (state_14911[(1)]);
if((state_val_14912 === (7))){
var inst_14906 = (state_14911[(2)]);
var state_14911__$1 = state_14911;
var statearr_14913_14944 = state_14911__$1;
(statearr_14913_14944[(2)] = inst_14906);

(statearr_14913_14944[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14912 === (1))){
var inst_14866 = fluree.db.index.resolve_when(r,resolve_QMARK_,error_ch,root);
var state_14911__$1 = state_14911;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14911__$1,(2),inst_14866);
} else {
if((state_val_14912 === (4))){
var inst_14908 = (state_14911[(2)]);
var inst_14909 = cljs.core.async.close_BANG_(out);
var state_14911__$1 = (function (){var statearr_14914 = state_14911;
(statearr_14914[(7)] = inst_14908);

return statearr_14914;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_14911__$1,inst_14909);
} else {
if((state_val_14912 === (15))){
var state_14911__$1 = state_14911;
var statearr_14915_14945 = state_14911__$1;
(statearr_14915_14945[(2)] = null);

(statearr_14915_14945[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14912 === (13))){
var inst_14903 = (state_14911[(2)]);
var state_14911__$1 = state_14911;
var statearr_14916_14946 = state_14911__$1;
(statearr_14916_14946[(2)] = inst_14903);

(statearr_14916_14946[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14912 === (6))){
var state_14911__$1 = state_14911;
var statearr_14917_14947 = state_14911__$1;
(statearr_14917_14947[(2)] = null);

(statearr_14917_14947[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14912 === (17))){
var inst_14888 = (state_14911[(2)]);
var state_14911__$1 = state_14911;
var statearr_14918_14948 = state_14911__$1;
(statearr_14918_14948[(2)] = inst_14888);

(statearr_14918_14948[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14912 === (3))){
var inst_14872 = (state_14911[(8)]);
var inst_14874 = (state_14911[(9)]);
var inst_14874__$1 = cljs.core.peek(inst_14872);
var state_14911__$1 = (function (){var statearr_14919 = state_14911;
(statearr_14919[(9)] = inst_14874__$1);

return statearr_14919;
})();
if(cljs.core.truth_(inst_14874__$1)){
var statearr_14920_14949 = state_14911__$1;
(statearr_14920_14949[(1)] = (5));

} else {
var statearr_14921_14950 = state_14911__$1;
(statearr_14921_14950[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14912 === (12))){
var inst_14874 = (state_14911[(9)]);
var inst_14894 = fluree.db.index.resolve_children_when(r,resolve_QMARK_,error_ch,inst_14874);
var state_14911__$1 = state_14911;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14911__$1,(18),inst_14894);
} else {
if((state_val_14912 === (2))){
var inst_14868 = (state_14911[(2)]);
var inst_14869 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14870 = [inst_14868];
var inst_14871 = (new cljs.core.PersistentVector(null,1,(5),inst_14869,inst_14870,null));
var inst_14872 = inst_14871;
var state_14911__$1 = (function (){var statearr_14922 = state_14911;
(statearr_14922[(8)] = inst_14872);

return statearr_14922;
})();
var statearr_14923_14951 = state_14911__$1;
(statearr_14923_14951[(2)] = null);

(statearr_14923_14951[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14912 === (11))){
var inst_14874 = (state_14911[(9)]);
var inst_14884 = (include_QMARK_.cljs$core$IFn$_invoke$arity$1 ? include_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_14874) : include_QMARK_.call(null,inst_14874));
var state_14911__$1 = state_14911;
if(cljs.core.truth_(inst_14884)){
var statearr_14924_14952 = state_14911__$1;
(statearr_14924_14952[(1)] = (14));

} else {
var statearr_14925_14953 = state_14911__$1;
(statearr_14925_14953[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14912 === (9))){
var inst_14874 = (state_14911[(9)]);
var inst_14880 = fluree.db.index.expanded_QMARK_(inst_14874);
var state_14911__$1 = state_14911;
var statearr_14926_14954 = state_14911__$1;
(statearr_14926_14954[(2)] = inst_14880);

(statearr_14926_14954[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14912 === (5))){
var inst_14872 = (state_14911[(8)]);
var inst_14874 = (state_14911[(9)]);
var inst_14877 = (state_14911[(10)]);
var inst_14876 = cljs.core.pop(inst_14872);
var inst_14877__$1 = fluree.db.index.leaf_QMARK_(inst_14874);
var state_14911__$1 = (function (){var statearr_14927 = state_14911;
(statearr_14927[(10)] = inst_14877__$1);

(statearr_14927[(11)] = inst_14876);

return statearr_14927;
})();
if(inst_14877__$1){
var statearr_14928_14955 = state_14911__$1;
(statearr_14928_14955[(1)] = (8));

} else {
var statearr_14929_14956 = state_14911__$1;
(statearr_14929_14956[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14912 === (14))){
var inst_14874 = (state_14911[(9)]);
var inst_14886 = fluree.db.index.unmark_expanded(inst_14874);
var state_14911__$1 = state_14911;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14911__$1,(17),out,inst_14886);
} else {
if((state_val_14912 === (16))){
var inst_14876 = (state_14911[(11)]);
var inst_14891 = (state_14911[(2)]);
var inst_14872 = inst_14876;
var state_14911__$1 = (function (){var statearr_14930 = state_14911;
(statearr_14930[(8)] = inst_14872);

(statearr_14930[(12)] = inst_14891);

return statearr_14930;
})();
var statearr_14931_14957 = state_14911__$1;
(statearr_14931_14957[(2)] = null);

(statearr_14931_14957[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14912 === (10))){
var inst_14882 = (state_14911[(2)]);
var state_14911__$1 = state_14911;
if(cljs.core.truth_(inst_14882)){
var statearr_14932_14958 = state_14911__$1;
(statearr_14932_14958[(1)] = (11));

} else {
var statearr_14933_14959 = state_14911__$1;
(statearr_14933_14959[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14912 === (18))){
var inst_14874 = (state_14911[(9)]);
var inst_14876 = (state_14911[(11)]);
var inst_14896 = (state_14911[(2)]);
var inst_14897 = fluree.db.index.mark_expanded(inst_14874);
var inst_14898 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_14876,inst_14897);
var inst_14899 = cljs.core.rseq(inst_14896);
var inst_14900 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_14898,inst_14899);
var inst_14872 = inst_14900;
var state_14911__$1 = (function (){var statearr_14934 = state_14911;
(statearr_14934[(8)] = inst_14872);

return statearr_14934;
})();
var statearr_14935_14960 = state_14911__$1;
(statearr_14935_14960[(2)] = null);

(statearr_14935_14960[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14912 === (8))){
var inst_14877 = (state_14911[(10)]);
var state_14911__$1 = state_14911;
var statearr_14936_14961 = state_14911__$1;
(statearr_14936_14961[(2)] = inst_14877);

(statearr_14936_14961[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__2684__auto__ = null;
var fluree$db$index$state_machine__2684__auto____0 = (function (){
var statearr_14937 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14937[(0)] = fluree$db$index$state_machine__2684__auto__);

(statearr_14937[(1)] = (1));

return statearr_14937;
});
var fluree$db$index$state_machine__2684__auto____1 = (function (state_14911){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_14911);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e14938){var ex__2687__auto__ = e14938;
var statearr_14939_14962 = state_14911;
(statearr_14939_14962[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_14911[(4)]))){
var statearr_14940_14963 = state_14911;
(statearr_14940_14963[(1)] = cljs.core.first((state_14911[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14964 = state_14911;
state_14911 = G__14964;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$index$state_machine__2684__auto__ = function(state_14911){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2684__auto____1.call(this,state_14911);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2684__auto____0;
fluree$db$index$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2684__auto____1;
return fluree$db$index$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_14941 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_14941[(6)] = c__2706__auto___14943);

return statearr_14941;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return out;
}));

(fluree.db.index.tree_chan.cljs$lang$maxFixedArity = 7);

